%module geom

%include "std_vector.i"
%include "std_string.i"
%include "exception.i"

%include "Shape.h"
%include "Rectangle.h"

%{
#include "Shape.h"
#include "Rectangle.h"
%}

%template(dVector) std::vector<double>;
%template(rectVector) std::vector<Rectangle*>;

%exceptionclass ShapeError;

%exception *::whine {
    try {
        $action
    } catch(ShapeError & e) {
    	std::string s_1("ShapeError: "), s_2(e.what());
        std::string s = s_1 + s_2;
        SWIG_exception(SWIG_RuntimeError, s.c_str());
    }
}