import unittest
from prime import find_factors
from numpy import prod
from random import choice
from hypothesis import given, assume
from hypothesis.strategies import integers

class PrimeTester(unittest.TestCase):
    primes = [2,3,5,7,11,13,17,19]

    #@classmethod
    #def setUpClass(self):
    #    self.primes = [2,3,5,7,11,13,17,19]

    def test_70(self):
        #given
        value = 70
        expected = [2,5,7]
        #when
        result = find_factors(value)
        #then
        self.assertEqual(result, expected)

    def test_primes(self):
        #given
        for p in self.primes:
            with self.subTest(config = p):
                #when
                result = find_factors(p)
                #then
                self.assertEqual(result, [p])

    def test_fuzzy(self):
        for _ in range(10):
            #given
            expected = [choice(self.primes) for _ in range(5)]
            expected.sort()
            value = prod(expected)
            with self.subTest(config = value):
                #when
                result = find_factors(value)
                #then
                self.assertEqual(result, expected)

    @given(integers(min_value=1))
    def test_hypothesis(self, value):
        #when
        result = prod(find_factors(value))
        #then
        self.assertEqual(result, value)



if __name__ == "__main__":
    unittest.main(verbosity=2)
