class Beverage:

    def __init__(self, with_milk, with_sugar):
        self.with_milk = with_milk
        self.with_sugar = with_sugar

    def get_description(self):
        description = str(self._get_default_description())
        if self.with_milk:
            description += ", with milk"
        if self.with_sugar:
            description += ", with_sugar"
        return description
        
    def _get_default_description(self):
        return "beverage" 

    def get_cost(self):
        cost = self._get_default_cost()
        if self.with_milk:
            cost += 0.30
        if self.with_sugar:
            cost += 0.20
        return cost
        
    def _get_default_cost(self):
        return 0.00
        
class Coffee(Beverage):

    def _get_default_description(self):
        return "normal coffee"
        
    def _get_default_cost(self):
        return 3.00         
