%module geom

%include "std_vector.i"
%include "std_string.i"
%include "exception.i"

%include "Shape.h"
%include "Rectangle.h"

%{
#include "Shape.h"
#include "Rectangle.h"
%}

%template(dVector) std::vector<double>;
%template(rectVector) std::vector<Rectangle*>;

%exceptionclass ShapeError;

%exception *::whine {
    try {
        $action
    } catch(ShapeError & e) {
        ShapeError *ecopy = new ShapeError(e.what());
        PyObject *err = SWIG_NewPointerObj(ecopy, SWIGTYPE_p_ShapeError, 1);
        PyErr_SetString(PyExc_RuntimeError, ecopy->what());
    }
}