import unittest
from random import choice
from numpy import prod
from prime import find_factors

class PrimeTester(unittest.TestCase):

    @classmethod
    def setUpClass(self):
        self.primes = [2,3,5,7,11,13,17,19]

    def test_fuzzy(self):
        for _ in range(5):
            #given
            expect = [choice(self.primes) for _ in range(5)]
            expect.sort()
            value = prod(expect)
            with self.subTest(config=value):
                #when
                result = find_factors(value)
                #then
                self.assertEqual(result, expect)


    def test_primes(self):
        #given
        for p in self.primes:
            with self.subTest(config = p):
                #when
                result = find_factors(p)
                #then
                self.assertEqual(result, [p])

    def test_70(self):
        #given
        value = 70
        expect = [2,5,7]
        #when
        result = find_factors(value)
        #then
        self.assertEqual(result, expect)

if __name__ == "__main__":
    unittest.main(verbosity=2)
