import unittest
from numpy import prod
from prime import find_factors
from random import choice

class PrimeTester(unittest.TestCase):

    @classmethod
    def setUpClass(self):
        self.primes = [2,3,5,7,11,13,17,19,23]

    def test_fuzzy(self):
        #given
        for _ in range(5):
            expect = [choice(self.primes) for _ in range(5)]
            expect.sort()
            value = prod(expect)
            #when
            with self.subTest(config = value):
                result = find_factors(value)
                #then
                self.assertEqual(result, expect)

    def test_primes(self):
        #given
        for p in self.primes:
        #when
            with self.subTest(config = p):
                result = find_factors(p)
                #then
                self.assertEqual(result, [p])

    def test_70(self):
        #given
        expected = [2,5,7]
        value = prod(expected)
        #when
        result = find_factors(value)
        #then
        self.assertEqual(result, expected)

if __name__ == "__main__":
    unittest.main(verbosity=2)

