import unittest
from random import randint
from dist_to_mean import get_dists, mean

def round_helper(values):
    return [round(x, 3) for x in values]


class DeviationTester(unittest.TestCase):

    def test_mean_trivial(self):
        #given
        values = [-2, 2, -6, 6]
        expect = 0
        #when
        result = mean(values)
        #then
        self.assertAlmostEqual(result, expect)

    def test_dist_trivial(self):
        #given
        values = [-2, 2, -6, 6]
        expected = values
        #when
        result = round_helper(get_dists(values))
        #then
        self.assertEqual(result, expected)

    def test_dist_fuzzy(self):
        #given
        values = [randint(0,20) for _ in range(100)]
        expected = 0
        #when
        result = sum(get_dists(values))
        #then
        self.assertAlmostEqual(result, expected)

if __name__ == "__main__":
    unittest.main()

