#include <stdexcept>
#include <iostream>

#include "UnitVector.h"

UnitVector::UnitVector() : Vector(){
    std::range_error  e("Vector has zero length");
}

UnitVector::UnitVector(const Vector& v) : Vector(v.x,v.y,v.z){
    double l = Vector::length();
    
    if (l==0.0) {
        std::range_error  e("Vector has zero length");
        throw e;
    }
    
    x = x/l;
    y = y/l;
    z = z/l;

}

UnitVector::UnitVector(double fx,double fy, double fz) : Vector(fx,fy,fz){
    
    double l = Vector::length();
    
    if (l==0.0) {
        std::range_error  e("Vector has zero length");
        throw e;
    }
    
    x = x/l;
    y = y/l;
    z = z/l;
}

double UnitVector::length(){
    return 1.0;
}




int main(){
    
    
    Vector v(1,2,4);
    v = v*2.0;
    std::cout << v.length() << std::endl;
    UnitVector w(1,0,0);
    std::cout << v*w << std::endl;
    std::cout << (v^w).length() << std::endl;
}
