import numpy as np
from matplotlib.colors import LinearSegmentedColormap

import config

# Find confidence levels in 2D map
def findConfLevel(m):
  
  levels = [0.990,0.950,0.683]
  values = []
  values.append(0.0)
  m_flatsorted = m.flatten()
  m_flatsorted.sort()
  m_cumulative = np.cumsum(m_flatsorted)
  for l in levels:
    values.append(np.max(m_flatsorted[m_cumulative<1-l]))
  values.append(np.max(m))
  return values

# Generate colormap
def generateColormap(values,base,name,alpha=1.0):
  if len(values)<3:
    raise ValuesError("Value array should have at least three entries")
  base_temp = base.copy()
  a_alpha = ((0.0,0.0,0.0),
             (values[1]/values[-1],0.0,alpha),
             (1.0,alpha,alpha))
  base_temp['alpha'] = a_alpha
  return LinearSegmentedColormap(name, base_temp )
