# cython: experimental_cpp_class_def=True

# Anagram finder

from libcpp.map cimport map
from libcpp.vector cimport vector
from libcpp.string cimport string

from cython.operator cimport dereference as deref, preincrement as inc

def findAnagram():
    cdef string fileName = "/usr/share/dict/words"
    inputFile = file(fileName)
    cdef map[string,vector[string]] matchingMap
    cdef string key
    for word in inputFile:
        word = word[:-1]
        key = ''.join(sorted(word.lower()))
        matchingMap[key].push_back(word)
    cdef vector[string] maxEntry
    cdef signed long max
    max = 0
    cdef map[string,vector[string]].iterator it
    it = matchingMap.begin()
    cdef int i
    while it != matchingMap.end():
        mEnt = deref(it)
        if mEnt.second.size()>max:
            maxEntry = vector[string]()
            maxEntry.push_back(mEnt.first)
            max = mEnt.second.size()
        elif mEnt.second.size()==max:
            maxEntry.push_back(mEnt.first)
        for i in range(mEnt.second.size()):
            print(mEnt.second[i]),
        print ""
        inc(it)
    print "Set generating the maximum number of words:"
    for i in range(maxEntry.size()):
        print(maxEntry[i]),
    print ""