# Scientific Programming with Python
# Software Carpentry Exercise
# Author: Nicola Chiapolini <nchiapol _at_ physik _dot_ uzh _dot ch>


import unittest
import numpy as np
from numpy.testing import assert_array_equal, assert_array_almost_equal

from kmeans import kmean_classify, kmean_means, kmean


class KmeanTester(unittest.TestCase):

    @classmethod
    def setUpClass(self):
        """ print and set the random seed """
        seed = np.random.randint(1000)
        print seed
        np.random.seed(seed)

    def test_kmean_classify(self):
        """ correctly classifiy positiv/negativ numebers """
        # given
        data = np.random.randn(100, 2)
        means = np.array([[0, 10], [0, -10]])
        expect = np.where(data[:, 1] > 0, 0, 1)
        # when
        result = kmean_classify(data, means)
        # then
        assert_array_equal(result, expect)

    def test_kmean_means(self):
        """ calculate correct mean values from two 2d gauss """
        # given
        n = 300
        offset = [10, 10]
        data = np.random.randn(2*n, 2)
        indices = np.zeros(2*n, dtype=int)
        data[::2] += offset
        indices[::2] = 1
        expect = np.array([[0, 0], offset])
        # when
        result = kmean_means(data, indices)
        # then
        assert_array_almost_equal(result, expect, 1)

    def test_kmean(self):
        """ get expeccted result for two distant 2d gauss """
        # given
        n = 300
        offset = [10, 10]
        data = np.random.randn(2*n, 2)
        data[::2] += offset
        expect_indices = np.zeros(2*n, dtype=int)
        expect_indices[::2] = 1
        expect_means = [offset, [0, 0]]
        # when
        indices, means = kmean(data, 2)
        # then
        if indices[0] == 0:
            expect_indices += 1
            expect_indices %= 2
            expect_means = [expect_means[0], expect_means[1]]
        assert_array_equal(indices, expect_indices)
        assert_array_almost_equal(means, expect_means, 1)
