# stl_ex.pyx
# Examples of STL containers


from libcpp.map cimport map
from libcpp.pair cimport pair
from libcpp.set cimport set
from libcpp.string cimport string
from libcpp.vector cimport vector

from cython.operator cimport dereference as deref, preincrement as inc

def returnString(c):
    cdef string s = "Hello, "+c+"!"
    return s

def returnVector(a):
    cdef vector[int] v = a
    v[0] = -1
    return v

def returnMap(d):
    cdef map[string,int] m
    for k,v in d.iteritems():
        m[k] = v
    cdef map[string,int].iterator it
    it = m.begin()
    while it != m.end():
        mEnt = deref(it)
        print "%5s : %d"%(mEnt.first,mEnt.second)
        inc(it)
    return m
    
def returnMap2(d):
    cdef map[string,int] m = d
    m["new"] = -1
    return m

def returnPair():
    a = ("pi",3.1415926)
    cdef pair[string,double] p = a
    return p

def returnSet(a):
    cdef set[double] s = a
    return s