
def find_factors(value):
    """ find the prime factors of value and return a sorted list
    
    >>> find_factors(2)
    [2]
    >>> find_factors(70)
    [2, 5, 7]

    """
    factors = []
    divisor = 2
    while value > 1:
        if value % divisor == 0:
            factors.append(divisor)
            value /= divisor
        else:
            divisor += 1
    return factors

