
module ol_vamp_1_pphhtt_lambda4_ttxhhgg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none

  contains

! **********************************************************************
subroutine vamp_1(M, mode, hel)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_pphhtt_lambda4_ttxhhgg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_pphhtt_lambda4_ttxhhgg_1.
! **********************************************************************
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/DREALKIND, only: stability_mode
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
#endif
  use ol_loop_pphhtt_lambda4_ttxhhgg_1_/**/REALKIND, only: c, f, wf, den
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tensor_sum_storage_pphhtt_lambda4_ttxhhgg_1_/**/REALKIND
  use ol_loop_routines_/**/REALKIND, only: G0initialisation, TI2_call
  implicit none

  complex(REALKIND) :: Gcoeff
  complex(REALKIND), intent(in) :: M(3)
  integer, intent(in) :: mode, hel ! recycle mode & hel conf number

  ! Declarations of loop wave function tensors
  complex(REALKIND), dimension(4,1,4,17) :: G0
  complex(REALKIND), dimension(4,5,4,26) :: G1
  complex(REALKIND), dimension(4,15,4,13) :: G2
  complex(REALKIND), dimension(4,35,4,2) :: G3
  complex(REALKIND), dimension(5,8) :: G1tensor
  complex(REALKIND), dimension(15,5) :: G2tensor
  complex(REALKIND), dimension(35,4) :: G3tensor
if (mode == -1) return

  if (mode == 1 .or. stability_mode < 20 .or. stability_mode >= 30) then

  call G0initialisation(G0(:,:,:,1))

  ! Vertex and propagator calls to build loop structures
  call loop_AV_Q(G0(:,:,:,1),wf(:,-4),G0(:,:,:,2))
  call loop_A_Q(G0(:,:,:,2),Q(:,16),MT,G1(:,:,:,1))
  call loop_AV_Q(G1(:,:,:,1),wf(:,-5),G1(:,:,:,2))
  call loop_A_Q(G1(:,:,:,2),Q(:,48),MT,G2(:,:,:,1))
  call loop_AS_Q(G2(:,:,:,1),wf(:,73),G2(:,:,:,2),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,2),Q(:,63),MT,G3tensor(:,1))
  call loop_QV_A(G0(:,:,:,1),wf(:,-4),G0(:,:,:,3))
  call loop_Q_A(G0(:,:,:,3),Q(:,16),MT,G1(:,:,:,3))
  call loop_QV_A(G1(:,:,:,3),wf(:,-5),G1(:,:,:,4))
  call loop_Q_A(G1(:,:,:,4),Q(:,48),MT,G2(:,:,:,3))
  call loop_QS_A(G2(:,:,:,3),wf(:,73),G2(:,:,:,4),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,4),Q(:,63),MT,G3tensor(:,2))
  call loop_SQ_A(G0(:,:,:,1),wf(:,39),G0(:,:,:,4),gH)
  call loop_Q_A(G0(:,:,:,4),Q(:,17),MT,G1(:,:,:,5))
  call loop_QA_S(G1(:,:,:,5),wf(:,21),G1(:,:,:,6),gH)
  call check_last_SSS_S(l_switch,G1(:,:,:,6),wf(:,-3),wf(:,-2),G1tensor(:,1))
  call loop_SSS_S(G0(:,:,:,1),wf(:,-3),wf(:,-2),G0(:,:,:,5))
  call loop_SQ_A(G0(:,:,:,5),wf(:,74),G0(:,:,:,6),gH)
  call loop_Q_A(G0(:,:,:,6),Q(:,61),MT,G1(:,:,:,7))
  call check_last_QA_S(l_switch,G1(:,:,:,7),wf(:,-1),G1tensor(:,2),gH)
  call loop_SQ_A(G0(:,:,:,5),wf(:,39),G0(:,:,:,7),gH)
  call loop_Q_A(G0(:,:,:,7),Q(:,29),MT,G1(:,:,:,8))
  call loop_QV_A(G1(:,:,:,8),wf(:,-5),G1(:,:,:,9))
  call loop_Q_A(G1(:,:,:,9),Q(:,61),MT,G2(:,:,:,5))
  call check_last_QA_S(l_switch,G2(:,:,:,5),wf(:,-1),G2tensor(:,1),gH)
  call loop_SA_Q(G0(:,:,:,5),wf(:,75),G0(:,:,:,8),gH)
  call loop_A_Q(G0(:,:,:,8),Q(:,62),MT,G1(:,:,:,10))
  call check_last_AQ_S(l_switch,G1(:,:,:,10),wf(:,0),G1tensor(:,3),gH)
  call loop_SA_Q(G0(:,:,:,5),wf(:,14),G0(:,:,:,9),gH)
  call loop_A_Q(G0(:,:,:,9),Q(:,30),MT,G1(:,:,:,11))
  call loop_AV_Q(G1(:,:,:,11),wf(:,-5),G1(:,:,:,12))
  call loop_A_Q(G1(:,:,:,12),Q(:,62),MT,G2(:,:,:,6))
  call check_last_AQ_S(l_switch,G2(:,:,:,6),wf(:,0),G2tensor(:,2),gH)
  call loop_SQ_A(G0(:,:,:,5),wf(:,76),G0(:,:,:,10),gH)
  call loop_Q_A(G0(:,:,:,10),Q(:,61),MT,G1(:,:,:,13))
  call check_last_QA_S(l_switch,G1(:,:,:,13),wf(:,-1),G1tensor(:,4),gH)
  call loop_SQ_A(G0(:,:,:,5),wf(:,46),G0(:,:,:,11),gH)
  call loop_Q_A(G0(:,:,:,11),Q(:,45),MT,G1(:,:,:,14))
  call loop_QV_A(G1(:,:,:,14),wf(:,-4),G1(:,:,:,15))
  call loop_Q_A(G1(:,:,:,15),Q(:,61),MT,G2(:,:,:,7))
  call check_last_QA_S(l_switch,G2(:,:,:,7),wf(:,-1),G2tensor(:,3),gH)
  call loop_SA_Q(G0(:,:,:,5),wf(:,77),G0(:,:,:,12),gH)
  call loop_A_Q(G0(:,:,:,12),Q(:,62),MT,G1(:,:,:,16))
  call check_last_AQ_S(l_switch,G1(:,:,:,16),wf(:,0),G1tensor(:,5),gH)
  call loop_SA_Q(G0(:,:,:,5),wf(:,21),G0(:,:,:,13),gH)
  call loop_A_Q(G0(:,:,:,13),Q(:,46),MT,G1(:,:,:,17))
  call loop_AV_Q(G1(:,:,:,17),wf(:,-4),G1(:,:,:,18))
  call loop_A_Q(G1(:,:,:,18),Q(:,62),MT,G2(:,:,:,8))
  call check_last_AQ_S(l_switch,G2(:,:,:,8),wf(:,0),G2tensor(:,4),gH)
  call loop_SQ_A(G0(:,:,:,5),wf(:,51),G0(:,:,:,14),gH)
  call loop_Q_A(G0(:,:,:,14),Q(:,61),MT,G1(:,:,:,19))
  call check_last_QA_S(l_switch,G1(:,:,:,19),wf(:,-1),G1tensor(:,6),gH)
  call loop_SA_Q(G0(:,:,:,5),wf(:,26),G0(:,:,:,15),gH)
  call loop_A_Q(G0(:,:,:,15),Q(:,62),MT,G1(:,:,:,20))
  call check_last_AQ_S(l_switch,G1(:,:,:,20),wf(:,0),G1tensor(:,7),gH)
  call loop_SA_Q(G0(:,:,:,5),wf(:,-1),G0(:,:,:,16),gH)
  call loop_A_Q(G0(:,:,:,16),Q(:,14),MT,G1(:,:,:,21))
  call loop_AV_Q(G1(:,:,:,21),wf(:,3),G1(:,:,:,22))
  call loop_A_Q(G1(:,:,:,22),Q(:,62),MT,G2(:,:,:,9))
  call check_last_AQ_S(l_switch,G2(:,:,:,9),wf(:,0),G2tensor(:,5),gH)
  call loop_AV_Q(G1(:,:,:,21),wf(:,-5),G1(:,:,:,23))
  call loop_A_Q(G1(:,:,:,23),Q(:,46),MT,G2(:,:,:,10))
  call loop_AV_Q(G2(:,:,:,10),wf(:,-4),G2(:,:,:,11))
  call loop_A_Q(G2(:,:,:,11),Q(:,62),MT,G3(:,:,:,1))
  call check_last_AQ_S(l_switch,G3(:,:,:,1),wf(:,0),G3tensor(:,3),gH)
  call loop_AV_Q(G1(:,:,:,21),wf(:,-4),G1(:,:,:,24))
  call loop_A_Q(G1(:,:,:,24),Q(:,30),MT,G2(:,:,:,12))
  call loop_AV_Q(G2(:,:,:,12),wf(:,-5),G2(:,:,:,13))
  call loop_A_Q(G2(:,:,:,13),Q(:,62),MT,G3(:,:,:,2))
  call check_last_AQ_S(l_switch,G3(:,:,:,2),wf(:,0),G3tensor(:,4),gH)
  call loop_SA_Q(G0(:,:,:,1),wf(:,14),G0(:,:,:,17),gH)
  call loop_A_Q(G0(:,:,:,17),Q(:,18),MT,G1(:,:,:,25))
  call loop_AQ_S(G1(:,:,:,25),wf(:,46),G1(:,:,:,26),gH)
  call check_last_SSS_S(l_switch,G1(:,:,:,26),wf(:,-3),wf(:,-2),G1tensor(:,8))

  end if

  ! add colour interference with born to the sum of coefficient tensors for the proper tensor integral
  Gcoeff = (c(3)*M(3)) * den(89)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,1)
  Gcoeff = (c(3)*M(3)) * den(89)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,2)
  Gcoeff = (-(c(2)*M(2))) * den(69)
  T1sum(1:5,1) = T1sum(1:5,1) + Gcoeff * G1tensor(:,1)
  Gcoeff = (-(c(2)*M(2))) * den(90)
  T1sum(1:5,2) = T1sum(1:5,2) + Gcoeff * G1tensor(:,2)
  Gcoeff = (-(c(2)*M(2))) * den(36)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,1)
  Gcoeff = (-(c(2)*M(1))) * den(73)
  T1sum(1:5,3) = T1sum(1:5,3) + Gcoeff * G1tensor(:,8)
  Gcoeff = (-(c(2)*M(1))) * den(91)
  T1sum(1:5,4) = T1sum(1:5,4) + Gcoeff * G1tensor(:,3)
  Gcoeff = (-(c(2)*M(1))) * den(12)
  T2sum(1:15,2) = T2sum(1:15,2) + Gcoeff * G2tensor(:,2)
  Gcoeff = (-(c(2)*M(1))) * den(92)
  T1sum(1:5,2) = T1sum(1:5,2) + Gcoeff * G1tensor(:,4)
  Gcoeff = (-(c(2)*M(1))) * den(42)
  T2sum(1:15,3) = T2sum(1:15,3) + Gcoeff * G2tensor(:,3)
  Gcoeff = (-(c(2)*M(2))) * den(93)
  T1sum(1:5,4) = T1sum(1:5,4) + Gcoeff * G1tensor(:,5)
  Gcoeff = (-(c(2)*M(2))) * den(18)
  T2sum(1:15,4) = T2sum(1:15,4) + Gcoeff * G2tensor(:,4)
  Gcoeff = (c(1)*(M(1)-M(2))) * den(48)
  T1sum(1:5,2) = T1sum(1:5,2) + Gcoeff * G1tensor(:,6)
  Gcoeff = (c(1)*(M(1)-M(2))) * den(24)
  T1sum(1:5,4) = T1sum(1:5,4) + Gcoeff * G1tensor(:,7)
  Gcoeff = (c(1)*(M(1)-M(2))) * den(3)
  T2sum(1:15,5) = T2sum(1:15,5) + Gcoeff * G2tensor(:,5)
  Gcoeff = (-(c(2)*M(2)))
  T3sum(1:35,2) = T3sum(1:35,2) + Gcoeff * G3tensor(:,3)
  Gcoeff = (-(c(2)*M(1)))
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,4)

#ifdef LOOPSQUARED
#ifndef PRECISION_dp
  call gtdealloc()
#endif
#endif

end subroutine vamp_1

#ifdef LOOPSQUARED
subroutine gtdealloc()
  implicit none

end subroutine gtdealloc
#endif

end module ol_vamp_1_pphhtt_lambda4_ttxhhgg_1_/**/REALKIND
