
module ol_vamp_1_pphhtt_lambda4_ttxddxhh_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none

  contains

! **********************************************************************
subroutine vamp_1(M, mode, hel)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_pphhtt_lambda4_ttxddxhh_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_pphhtt_lambda4_ttxddxhh_1.
! **********************************************************************
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/DREALKIND, only: stability_mode
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
#endif
  use ol_loop_pphhtt_lambda4_ttxddxhh_1_/**/REALKIND, only: c, f, wf, den
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tensor_sum_storage_pphhtt_lambda4_ttxddxhh_1_/**/REALKIND
  use ol_loop_routines_/**/REALKIND, only: G0initialisation, TI2_call
  implicit none

  complex(REALKIND) :: Gcoeff
  complex(REALKIND), intent(in) :: M(3)
  integer, intent(in) :: mode, hel ! recycle mode & hel conf number

  ! Declarations of loop wave function tensors
  complex(REALKIND), dimension(4,1,4,16) :: G0
  complex(REALKIND), dimension(4,5,4,11) :: G1
  complex(REALKIND), dimension(5,4) :: G1tensor
  complex(REALKIND), dimension(15,4) :: G2tensor
if (mode == -1) return

  if (mode == 1 .or. stability_mode < 20 .or. stability_mode >= 30) then

  call G0initialisation(G0(:,:,:,1))

  ! Vertex and propagator calls to build loop structures
  call loop_AQ_S(G0(:,:,:,1),wf(:,28),G0(:,:,:,2),gH)
  call loop_SSS_S(G0(:,:,:,2),wf(:,-5),wf(:,-4),G0(:,:,:,3))
  call loop_SA_Q(G0(:,:,:,3),wf(:,-1),G0(:,:,:,4),gH)
  call check_last_A_Q(l_switch,G0(:,:,:,4),Q(:,63),MT,G1tensor(:,1))
  call loop_AQ_S(G0(:,:,:,1),wf(:,30),G0(:,:,:,5),gH)
  call loop_SSS_S(G0(:,:,:,5),wf(:,-5),wf(:,-4),G0(:,:,:,6))
  call loop_SA_Q(G0(:,:,:,6),wf(:,-1),G0(:,:,:,7),gH)
  call check_last_A_Q(l_switch,G0(:,:,:,7),Q(:,63),MT,G1tensor(:,2))
  call loop_QA_S(G0(:,:,:,1),wf(:,15),G0(:,:,:,8),gH)
  call loop_SSS_S(G0(:,:,:,8),wf(:,-5),wf(:,-4),G0(:,:,:,9))
  call loop_SQ_A(G0(:,:,:,9),wf(:,0),G0(:,:,:,10),gH)
  call check_last_Q_A(l_switch,G0(:,:,:,10),Q(:,63),MT,G1tensor(:,3))
  call loop_QA_S(G0(:,:,:,1),wf(:,17),G0(:,:,:,11),gH)
  call loop_SSS_S(G0(:,:,:,11),wf(:,-5),wf(:,-4),G0(:,:,:,12))
  call loop_SQ_A(G0(:,:,:,12),wf(:,0),G0(:,:,:,13),gH)
  call check_last_Q_A(l_switch,G0(:,:,:,13),Q(:,63),MT,G1tensor(:,4))
  call loop_QV_A(G0(:,:,:,1),wf(:,3),G0(:,:,:,14))
  call loop_Q_A(G0(:,:,:,14),Q(:,12),MT,G1(:,:,:,1))
  call loop_QA_S(G1(:,:,:,1),wf(:,-1),G1(:,:,:,2),gH)
  call loop_SSS_S(G1(:,:,:,2),wf(:,-5),wf(:,-4),G1(:,:,:,3))
  call loop_SQ_A(G1(:,:,:,3),wf(:,0),G1(:,:,:,4),gH)
  call check_last_Q_A(l_switch,G1(:,:,:,4),Q(:,63),MT,G2tensor(:,1))
  call loop_QZ_A(G0(:,:,:,1),wf(:,8),G0(:,:,:,15),gZu)
  call loop_Q_A(G0(:,:,:,15),Q(:,12),MT,G1(:,:,:,5))
  call loop_QA_S(G1(:,:,:,5),wf(:,-1),G1(:,:,:,6),gH)
  call loop_SSS_S(G1(:,:,:,6),wf(:,-5),wf(:,-4),G1(:,:,:,7))
  call loop_SQ_A(G1(:,:,:,7),wf(:,0),G1(:,:,:,8),gH)
  call check_last_Q_A(l_switch,G1(:,:,:,8),Q(:,63),MT,G2tensor(:,2))
  call loop_QS_A(G0(:,:,:,1),wf(:,43),G0(:,:,:,16),gH)
  call loop_Q_A(G0(:,:,:,16),Q(:,51),MT,G1(:,:,:,9))
  call loop_QV_A(G1(:,:,:,9),wf(:,3),G1(:,:,:,10))
  call check_last_Q_A(l_switch,G1(:,:,:,10),Q(:,63),MT,G2tensor(:,3))
  call loop_QZ_A(G1(:,:,:,9),wf(:,8),G1(:,:,:,11),gZu)
  call check_last_Q_A(l_switch,G1(:,:,:,11),Q(:,63),MT,G2tensor(:,4))

  end if

  ! add colour interference with born to the sum of coefficient tensors for the proper tensor integral
  Gcoeff = (c(1)*M(3)) * den(24)
  T1sum(1:5,1) = T1sum(1:5,1) + Gcoeff * G1tensor(:,1)
  Gcoeff = (-(c(2)*M(3))) * den(26)
  T1sum(1:5,1) = T1sum(1:5,1) + Gcoeff * G1tensor(:,2)
  Gcoeff = (-(c(4)*M(1))+c(3)*M(2)) * den(24)
  T1sum(1:5,1) = T1sum(1:5,1) + Gcoeff * G1tensor(:,1)
  Gcoeff = (c(1)*M(3)) * den(12)
  T1sum(1:5,2) = T1sum(1:5,2) + Gcoeff * G1tensor(:,3)
  Gcoeff = (-(c(2)*M(3))) * den(14)
  T1sum(1:5,2) = T1sum(1:5,2) + Gcoeff * G1tensor(:,4)
  Gcoeff = (-(c(4)*M(1))+c(3)*M(2)) * den(12)
  T1sum(1:5,2) = T1sum(1:5,2) + Gcoeff * G1tensor(:,3)
  Gcoeff = (c(1)*M(3)) * den(3)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,1)
  Gcoeff = (-(c(2)*M(3))) * den(6)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,2)
  Gcoeff = (-(c(4)*M(1))+c(3)*M(2)) * den(3)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,1)
  Gcoeff = (-(c(5)*M(3))) * den(47)
  T2sum(1:15,2) = T2sum(1:15,2) + Gcoeff * G2tensor(:,3)
  Gcoeff = (c(6)*M(3)) * den(48)
  T2sum(1:15,2) = T2sum(1:15,2) + Gcoeff * G2tensor(:,4)

#ifdef LOOPSQUARED
#ifndef PRECISION_dp
  call gtdealloc()
#endif
#endif

end subroutine vamp_1

#ifdef LOOPSQUARED
subroutine gtdealloc()
  implicit none

end subroutine gtdealloc
#endif

end module ol_vamp_1_pphhtt_lambda4_ttxddxhh_1_/**/REALKIND
