
module ol_colourmatrix_pphhtt_lambda4_ttxhhgg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  logical, save           :: colmat_not_initialised = .true.
  complex(REALKIND), save :: K1(46,2), K2(2,1), KL(2,3)
  contains
  subroutine colourmatrix_init
    use ol_parameters_decl_/**/REALKIND, only: CI
    implicit none
    colmat_not_initialised = .false.
    ! colour matrix

  K1( 1,:) = [ 16, -2]
  K1( 2,:) = [ -2, 16]
  K1( 3,:) = [  0,  0]
  K1( 4,:) = [  0,  0]
  K1( 5,:) = [  0,  0]
  K1( 6,:) = [  0,  0]
  K1( 7,:) = [  0,  0]
  K1( 8,:) = [  0,  0]
  K1( 9,:) = [  0,  0]
  K1(10,:) = [  0,  0]
  K1(11,:) = [  0,  0]
  K1(12,:) = [  0,  0]
  K1(13,:) = [  0,  0]
  K1(14,:) = [  0,  0]
  K1(15,:) = [  0,  0]
  K1(16,:) = [  0,  0]
  K1(17,:) = [  0,  0]
  K1(18,:) = [  0,  0]
  K1(19,:) = [  0,  0]
  K1(20,:) = [  0,  0]
  K1(21,:) = [  0,  0]
  K1(22,:) = [  0,  0]
  K1(23,:) = [  0,  0]
  K1(24,:) = [  0,  0]
  K1(25,:) = [  0,  0]
  K1(26,:) = [  0,  0]
  K1(27,:) = [  0,  0]
  K1(28,:) = [  0,  0]
  K1(29,:) = [  0,  0]
  K1(30,:) = [  0,  0]
  K1(31,:) = [  0,  0]
  K1(32,:) = [  0,  0]
  K1(33,:) = [  0,  0]
  K1(34,:) = [  0,  0]
  K1(35,:) = [  0,  0]
  K1(36,:) = [  0,  0]
  K1(37,:) = [  0,  0]
  K1(38,:) = [  0,  0]
  K1(39,:) = [  0,  0]
  K1(40,:) = [  0,  0]
  K1(41,:) = [  0,  0]
  K1(42,:) = [  0,  0]
  K1(43,:) = [  0,  0]
  K1(44,:) = [  0,  0]
  K1(45,:) = [ 16, -2]
  K1(46,:) = [ -2, 16]
  K1 = (1._/**/REALKIND / 3) * K1

  K2(1,:) = [ 2]
  K2(2,:) = [ 2]

  KL(1,:) = [ 16, -2,  6]
  KL(2,:) = [ -2, 16,  6]
  KL = (1._/**/REALKIND / 3) * KL

  end subroutine colourmatrix_init
end module ol_colourmatrix_pphhtt_lambda4_ttxhhgg_1_/**/REALKIND



module ol_forced_parameters_pphhtt_lambda4_ttxhhgg_1_/**/REALKIND
  implicit none
  contains
  subroutine check_forced_parameters
    use ol_parameters_decl_/**/REALKIND
    use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
    use ol_loop_parameters_decl_/**/DREALKIND, only: LeadingColour, nc, nf, CKMORDER
#endif
    implicit none
    logical, save :: checks_not_written = .true.

    if (checks_not_written) then
    ! e.g.
    ! if (ME /= 0) write(*,101) 'ME = 0'
  if (CKMORDER /= 0) write(*,101) 'CKMORDER = 0'
  if (nc /= 3) write(*,101) 'nc = 3'
  if (nf /= 6) write(*,101) 'nf = 6'
  if (MU /= 0) write(*,101) 'MU = 0'
  if (MD /= 0) write(*,101) 'MD = 0'
  if (MS /= 0) write(*,101) 'MS = 0'
  if (MC /= 0) write(*,101) 'MC = 0'
  if (YU /= 0) write(*,101) 'YU = 0'
  if (YD /= 0) write(*,101) 'YD = 0'
  if (YS /= 0) write(*,101) 'YS = 0'
  if (YC /= 0) write(*,101) 'YC = 0'
  if (LeadingColour /= 0) write(*,101) 'LeadingColour = 0'
  if (wMT /= 0) write(*,101) 'wMT = 0'
  if (wMT /= 0) write(*,101) 'wMT = 0'
  if (wMH /= 0) write(*,101) 'wMH = 0'
  if (wMH /= 0) write(*,101) 'wMH = 0'


    checks_not_written = .false.
    end if

    101 format('[OpenLoops] === WARNING ===',/,'[OpenLoops] code was generated with ',A,/,'[OpenLoops] ===============')
  end subroutine check_forced_parameters
end module ol_forced_parameters_pphhtt_lambda4_ttxhhgg_1_/**/REALKIND

module ol_loop_pphhtt_lambda4_ttxhhgg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND, intkind1
  implicit none
  ! diagram prefactors
  integer,           save :: fac_status_loop1 = -1, fac_status_loop2 = -1
  complex(REALKIND), save :: f(8), c(3)
  ! tree wavefunctions
  complex(REALKIND), save :: wf(4,-6+1:77)
  ! denominators
  complex(REALKIND), save :: den(93)
  ! Born, CT and Loop colour vector for each helicity configuration
  complex(REALKIND), save :: M0(2,16), Mct(1,16), Mcol_loop(3,16)
  ! zero helicity identifier
  logical,           save :: zerohel(16) = .true., zerohel_ct(16) = .true.

  contains

! **********************************************************************
subroutine fac_init_loop()
! Writes diagram prefactors to 'f', rsp. 'c'
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND
  use ol_parameters_decl_/**/DREALKIND, only: do_ew_renorm
  use ol_loop_parameters_decl_/**/REALKIND
  use ol_parameters_init_/**/REALKIND, only: ensure_mp_loop_init
  use ol_init, only: set_parameter, tree_parameters_flush, parameters_flush
#ifndef PRECISION_dp
  use ol_loop_parameters_decl_/**/DREALKIND, only: SwF, SwB
!  use ol_loop_parameters_decl_/**/DREALKIND, only: DOI
#endif
  implicit none
  call set_parameter("ew_renorm", 0)
  if (parameters_status == 0) call tree_parameters_flush()
  if (loop_parameters_status == 0) call parameters_flush()
  call ensure_mp_loop_init()
  fac_status_loop1 = parameters_status
  fac_status_loop2 = loop_parameters_status
  ! factors of the diagrams
    f(1) = (3*CI*eQED**2*gQCD**2*lambdaHHH*MH**2*YT)/(4._/**/REALKIND*MW**2*sw**2)
    f(2) = (3*eQED**2*gQCD**2*lambdaHHH*MH**2*YT)/(MW**2*sw**2*4._/**/REALKIND)
    f(3) = (3*CI*countertermnorm*ctHGG*eQED**4*gQCD**2*lambdaHHHH*MH**2*MT*YT**2)/(8._/**/REALKIND*MQ2sum*MW**3*sw**3)
    f(4) = (CI*eQED**2*gQCD**2*YT**2)/(4._/**/REALKIND*MW**2*sw**2)
    f(5) = (eQED**2*gQCD**2*YT**2)/(MW**2*sw**2*4._/**/REALKIND)
    f(6) = (3*CI*eQED**4*gQCD**2*integralnorm*lambdaHHHH*MH**2*SwB*YT**2)/(16._/**/REALKIND*MW**4*sw**4)
    f(7) = (3*eQED**4*gQCD**2*integralnorm*lambdaHHHH*MH**2*SwB*YT**2)/(MW**4*sw**4*16._/**/REALKIND)
    f(8) = (3*eQED**4*gQCD**2*integralnorm*lambdaHHHH*MH**2*SwF*YT**2)/(MW**4*sw**4*16._/**/REALKIND)

  c = [ CI*f(6), f(7), f(8) ]
end subroutine fac_init_loop


! **********************************************************************
subroutine tree_wavefunctions(P, H, M1, M2, POLSEL)
! P(0:3,npart) = 2 -> n-2 external momenta (standard representation)
! H(npart)     = external-particle helicities
! Writes the tree wave functions to 'wf', denominators to 'den'.
! Returns the Born and counterterm colour vectors M1 and M2.
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/REALKIND ! counterterms
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_wavefunctions_/**/REALKIND
  use ol_propagators_/**/REALKIND
  use ol_vertices_/**/REALKIND
  use ol_counterterms_/**/REALKIND
  implicit none
  real(REALKIND),    intent(in)  :: P(0:3,6)
  integer,           intent(in)  :: H(6)
  integer,           intent(in), optional  :: POLSEL(6)
  complex(REALKIND), intent(out) :: M1(2), M2(1)
  complex(REALKIND) :: A(39)
  ! external WFs
  if (present(POLSEL)) then
    call pol_wf_Q(P(:,1), rMT, H(1), wf(:,0), POLSEL(1))
    call pol_wf_A(P(:,2), rMT, H(2), wf(:,-1), POLSEL(2))
    call pol_wf_S(P(:,3), rMH, H(3), wf(:,-2), POLSEL(3))
    call pol_wf_S(P(:,4), rMH, H(4), wf(:,-3), POLSEL(4))
    call pol_wf_V(P(:,5), rZERO, H(5), wf(:,-4), POLSEL(5))
    call pol_wf_V(P(:,6), rZERO, H(6), wf(:,-5), POLSEL(6))

  else
    call pol_wf_Q(P(:,1), rMT, H(1), wf(:,0), 0)
    call pol_wf_A(P(:,2), rMT, H(2), wf(:,-1), 0)
    call pol_wf_S(P(:,3), rMH, H(3), wf(:,-2), 0)
    call pol_wf_S(P(:,4), rMH, H(4), wf(:,-3), 0)
    call pol_wf_V(P(:,5), rZERO, H(5), wf(:,-4), 0)
    call pol_wf_V(P(:,6), rZERO, H(6), wf(:,-5), 0)

  end if

  ! internal WFs
  call vert_QS_A(gH,wf(:,0),wf(:,-2),wf(:,1))
  call vert_SA_Q(gH,wf(:,-3),wf(:,-1),wf(:,2))
  call vert_UV_W(wf(:,-4),Q(:,16),wf(:,-5),Q(:,32),wf(:,3))
  call prop_Q_A(wf(:,1),Q(:,5),MT,1_intkind1,wf(:,4))
  call prop_A_Q(wf(:,2),Q(:,10),MT,1_intkind1,wf(:,5))
  call vert_QA_V(wf(:,4),wf(:,5),wf(:,6))
  call vert_VQ_A(wf(:,-4),wf(:,4),wf(:,7))
  call vert_AV_Q(wf(:,5),wf(:,-5),wf(:,8))
  call prop_Q_A(wf(:,7),Q(:,21),MT,1_intkind1,wf(:,9))
  call vert_AV_Q(wf(:,5),wf(:,-4),wf(:,10))
  call vert_VQ_A(wf(:,-5),wf(:,4),wf(:,11))
  call prop_A_Q(wf(:,10),Q(:,26),MT,1_intkind1,wf(:,12))
  call vert_AV_Q(wf(:,-1),wf(:,-4),wf(:,13))
  call prop_A_Q(wf(:,13),Q(:,18),MT,1_intkind1,wf(:,14))
  call vert_QS_A(gH,wf(:,4),wf(:,-3),wf(:,15))
  call vert_AV_Q(wf(:,14),wf(:,-5),wf(:,16))
  call prop_Q_A(wf(:,15),Q(:,13),MT,1_intkind1,wf(:,17))
  call vert_SA_Q(gH,wf(:,-3),wf(:,14),wf(:,18))
  call prop_A_Q(wf(:,18),Q(:,26),MT,1_intkind1,wf(:,19))
  call vert_AV_Q(wf(:,-1),wf(:,-5),wf(:,20))
  call prop_A_Q(wf(:,20),Q(:,34),MT,1_intkind1,wf(:,21))
  call vert_AV_Q(wf(:,21),wf(:,-4),wf(:,22))
  call vert_SA_Q(gH,wf(:,-3),wf(:,21),wf(:,23))
  call prop_A_Q(wf(:,23),Q(:,42),MT,1_intkind1,wf(:,24))
  call vert_AV_Q(wf(:,-1),wf(:,3),wf(:,25))
  call prop_A_Q(wf(:,25),Q(:,50),MT,1_intkind1,wf(:,26))
  call vert_QS_A(gH,wf(:,0),wf(:,-3),wf(:,27))
  call vert_SA_Q(gH,wf(:,-2),wf(:,-1),wf(:,28))
  call prop_Q_A(wf(:,27),Q(:,9),MT,1_intkind1,wf(:,29))
  call prop_A_Q(wf(:,28),Q(:,6),MT,1_intkind1,wf(:,30))
  call vert_QA_V(wf(:,29),wf(:,30),wf(:,31))
  call vert_VQ_A(wf(:,-4),wf(:,29),wf(:,32))
  call vert_AV_Q(wf(:,30),wf(:,-5),wf(:,33))
  call prop_Q_A(wf(:,32),Q(:,25),MT,1_intkind1,wf(:,34))
  call vert_AV_Q(wf(:,30),wf(:,-4),wf(:,35))
  call vert_VQ_A(wf(:,-5),wf(:,29),wf(:,36))
  call prop_A_Q(wf(:,35),Q(:,22),MT,1_intkind1,wf(:,37))
  call vert_VQ_A(wf(:,-4),wf(:,0),wf(:,38))
  call prop_Q_A(wf(:,38),Q(:,17),MT,1_intkind1,wf(:,39))
  call vert_QS_A(gH,wf(:,39),wf(:,-3),wf(:,40))
  call prop_Q_A(wf(:,40),Q(:,25),MT,1_intkind1,wf(:,41))
  call vert_SA_Q(gH,wf(:,-3),wf(:,30),wf(:,42))
  call vert_VQ_A(wf(:,-5),wf(:,39),wf(:,43))
  call prop_A_Q(wf(:,42),Q(:,14),MT,1_intkind1,wf(:,44))
  call vert_VQ_A(wf(:,-5),wf(:,0),wf(:,45))
  call prop_Q_A(wf(:,45),Q(:,33),MT,1_intkind1,wf(:,46))
  call vert_QS_A(gH,wf(:,46),wf(:,-3),wf(:,47))
  call prop_Q_A(wf(:,47),Q(:,41),MT,1_intkind1,wf(:,48))
  call vert_VQ_A(wf(:,-4),wf(:,46),wf(:,49))
  call vert_VQ_A(wf(:,3),wf(:,0),wf(:,50))
  call prop_Q_A(wf(:,50),Q(:,49),MT,1_intkind1,wf(:,51))
  call vert_QS_A(gH,wf(:,29),wf(:,-2),wf(:,52))
  call prop_Q_A(wf(:,52),Q(:,13),MT,1_intkind1,wf(:,53))
  call vert_SA_Q(gH,wf(:,-2),wf(:,14),wf(:,54))
  call prop_A_Q(wf(:,54),Q(:,22),MT,1_intkind1,wf(:,55))
  call vert_SA_Q(gH,wf(:,-2),wf(:,21),wf(:,56))
  call prop_A_Q(wf(:,56),Q(:,38),MT,1_intkind1,wf(:,57))
  call vert_QS_A(gH,wf(:,39),wf(:,-2),wf(:,58))
  call prop_Q_A(wf(:,58),Q(:,21),MT,1_intkind1,wf(:,59))
  call vert_SA_Q(gH,wf(:,-2),wf(:,5),wf(:,60))
  call prop_A_Q(wf(:,60),Q(:,14),MT,1_intkind1,wf(:,61))
  call vert_QS_A(gH,wf(:,46),wf(:,-2),wf(:,62))
  call prop_Q_A(wf(:,62),Q(:,37),MT,1_intkind1,wf(:,63))
  call vert_SS_S(wf(:,-2),wf(:,-3),wf(:,64))
  call vert_AQ_S(gH,wf(:,21),wf(:,39),wf(:,65))
  call vert_SA_Q(gH,wf(:,64),wf(:,-1),wf(:,66))
  call prop_A_Q(wf(:,66),Q(:,14),MT,1_intkind1,wf(:,67))
  call vert_AQ_S(gH,wf(:,14),wf(:,46),wf(:,68))
  call vert_QS_A(gH,wf(:,0),wf(:,64),wf(:,69))
  call prop_Q_A(wf(:,69),Q(:,13),MT,1_intkind1,wf(:,70))
  call vert_AQ_S(gH,wf(:,-1),wf(:,0),wf(:,71))
  call counter_GG_S(wf(:,-4),wf(:,-5),wf(:,72))
  call vert_SSS_S(wf(:,71),wf(:,-2),wf(:,-3),wf(:,73))
  call prop_Q_A(wf(:,43),Q(:,49),MT,1_intkind1,wf(:,74))
  call prop_A_Q(wf(:,16),Q(:,50),MT,1_intkind1,wf(:,75))
  call prop_Q_A(wf(:,49),Q(:,49),MT,1_intkind1,wf(:,76))
  call prop_A_Q(wf(:,22),Q(:,50),MT,1_intkind1,wf(:,77))

  call denominators()
  call diagrams(A)
  call colourvectors(A, M1, M2)
end subroutine tree_wavefunctions


subroutine denominators()
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_momenta_decl_/**/REALKIND, only: Q
  implicit none
  ! propagators
  den(1) = 1 / (Q(5,5) - MT2)
  den(2) = 1 / (Q(5,10) - MT2)
  den(3) = 1 / (Q(5,48))
  den(6) = 1 / (Q(5,21) - MT2)
  den(9) = 1 / (Q(5,26) - MT2)
  den(12) = 1 / (Q(5,18) - MT2)
  den(13) = 1 / (Q(5,13) - MT2)
  den(18) = 1 / (Q(5,34) - MT2)
  den(20) = 1 / (Q(5,42) - MT2)
  den(23) = 1 / (Q(5,50) - MT2)
  den(26) = 1 / (Q(5,9) - MT2)
  den(27) = 1 / (Q(5,6) - MT2)
  den(30) = 1 / (Q(5,25) - MT2)
  den(33) = 1 / (Q(5,22) - MT2)
  den(36) = 1 / (Q(5,17) - MT2)
  den(39) = 1 / (Q(5,14) - MT2)
  den(42) = 1 / (Q(5,33) - MT2)
  den(43) = 1 / (Q(5,41) - MT2)
  den(47) = 1 / (Q(5,49) - MT2)
  den(55) = 1 / (Q(5,38) - MT2)
  den(63) = 1 / (Q(5,37) - MT2)
  den(68) = 1 / (Q(5,12) - MH2)
  den(85) = 1 / (Q(5,3) - MH2)
  den(86) = 1 / (Q(5,48) - MH2)
  den(88) = 1 / (Q(5,15) - MH2)

  ! denominators
  den(4) = den(1)*den(2)
  den(5) = den(3)*den(4)
  den(7) = den(1)*den(6)
  den(8) = den(2)*den(7)
  den(10) = den(2)*den(9)
  den(11) = den(1)*den(10)
  den(14) = den(1)*den(13)
  den(15) = den(12)*den(14)
  den(16) = den(9)*den(12)
  den(17) = den(1)*den(16)
  den(19) = den(14)*den(18)
  den(21) = den(18)*den(20)
  den(22) = den(1)*den(21)
  den(24) = den(3)*den(23)
  den(25) = den(1)*den(24)
  den(28) = den(26)*den(27)
  den(29) = den(3)*den(28)
  den(31) = den(26)*den(30)
  den(32) = den(27)*den(31)
  den(34) = den(27)*den(33)
  den(35) = den(26)*den(34)
  den(37) = den(30)*den(36)
  den(38) = den(27)*den(37)
  den(40) = den(27)*den(39)
  den(41) = den(36)*den(40)
  den(44) = den(42)*den(43)
  den(45) = den(27)*den(44)
  den(46) = den(40)*den(42)
  den(48) = den(3)*den(47)
  den(49) = den(27)*den(48)
  den(50) = den(13)*den(26)
  den(51) = den(12)*den(50)
  den(52) = den(12)*den(33)
  den(53) = den(26)*den(52)
  den(54) = den(18)*den(50)
  den(56) = den(18)*den(55)
  den(57) = den(26)*den(56)
  den(58) = den(24)*den(26)
  den(59) = den(6)*den(36)
  den(60) = den(2)*den(59)
  den(61) = den(2)*den(39)
  den(62) = den(36)*den(61)
  den(64) = den(42)*den(63)
  den(65) = den(2)*den(64)
  den(66) = den(42)*den(61)
  den(67) = den(2)*den(48)
  den(69) = den(18)*den(36)
  den(70) = den(68)*den(69)
  den(71) = den(39)*den(68)
  den(72) = den(36)*den(71)
  den(73) = den(12)*den(42)
  den(74) = den(68)*den(73)
  den(75) = den(13)*den(68)
  den(76) = den(12)*den(75)
  den(77) = den(42)*den(71)
  den(78) = den(18)*den(75)
  den(79) = den(3)*den(75)
  den(80) = den(48)*den(68)
  den(81) = den(18)*den(59)
  den(82) = den(36)*den(56)
  den(83) = den(12)*den(64)
  den(84) = den(42)*den(52)
  den(87) = den(85)*den(86)
  den(89) = den(85)*den(88)
  den(90) = den(36)*den(47)
  den(91) = den(12)*den(23)
  den(92) = den(42)*den(47)
  den(93) = den(18)*den(23)

end subroutine denominators


subroutine diagrams(A)
  ! colour stripped tree amplitudes
  use ol_contractions_/**/REALKIND
  implicit none
  complex(REALKIND), intent(out) :: A(39)

  A(1) = cont_VV(wf(:,3),wf(:,6)) * den(5)
  A(2) = cont_QA(wf(:,8),wf(:,9)) * den(8)
  A(3) = cont_QA(wf(:,11),wf(:,12)) * den(11)
  A(4) = cont_QA(wf(:,16),wf(:,17)) * den(15)
  A(5) = cont_QA(wf(:,11),wf(:,19)) * den(17)
  A(6) = cont_QA(wf(:,17),wf(:,22)) * den(19)
  A(7) = cont_QA(wf(:,7),wf(:,24)) * den(22)
  A(8) = cont_QA(wf(:,15),wf(:,26)) * den(25)
  A(9) = cont_VV(wf(:,3),wf(:,31)) * den(29)
  A(10) = cont_QA(wf(:,33),wf(:,34)) * den(32)
  A(11) = cont_QA(wf(:,36),wf(:,37)) * den(35)
  A(12) = cont_QA(wf(:,33),wf(:,41)) * den(38)
  A(13) = cont_QA(wf(:,43),wf(:,44)) * den(41)
  A(14) = cont_QA(wf(:,35),wf(:,48)) * den(45)
  A(15) = cont_QA(wf(:,44),wf(:,49)) * den(46)
  A(16) = cont_QA(wf(:,42),wf(:,51)) * den(49)
  A(17) = cont_QA(wf(:,16),wf(:,53)) * den(51)
  A(18) = cont_QA(wf(:,36),wf(:,55)) * den(53)
  A(19) = cont_QA(wf(:,22),wf(:,53)) * den(54)
  A(20) = cont_QA(wf(:,32),wf(:,57)) * den(57)
  A(21) = cont_QA(wf(:,26),wf(:,52)) * den(58)
  A(22) = cont_QA(wf(:,8),wf(:,59)) * den(60)
  A(23) = cont_QA(wf(:,43),wf(:,61)) * den(62)
  A(24) = cont_QA(wf(:,10),wf(:,63)) * den(65)
  A(25) = cont_QA(wf(:,49),wf(:,61)) * den(66)
  A(26) = cont_QA(wf(:,51),wf(:,60)) * den(67)
  A(27) = cont_SS(wf(:,64),wf(:,65)) * den(70)
  A(28) = cont_QA(wf(:,43),wf(:,67)) * den(72)
  A(29) = cont_SS(wf(:,64),wf(:,68)) * den(74)
  A(30) = cont_QA(wf(:,16),wf(:,70)) * den(76)
  A(31) = cont_QA(wf(:,49),wf(:,67)) * den(77)
  A(32) = cont_QA(wf(:,22),wf(:,70)) * den(78)
  A(33) = cont_QA(wf(:,25),wf(:,70)) * den(79)
  A(34) = cont_QA(wf(:,51),wf(:,66)) * den(80)
  A(35) = cont_QA(wf(:,23),wf(:,59)) * den(81)
  A(36) = cont_QA(wf(:,40),wf(:,57)) * den(82)
  A(37) = cont_QA(wf(:,18),wf(:,63)) * den(83)
  A(38) = cont_QA(wf(:,47),wf(:,55)) * den(84)

  A(39) = cont_SS(wf(:,72),wf(:,73)) * den(87)

end subroutine diagrams


subroutine colourvectors(A, M1, M2)
  ! Born and counterterm colour vectors
  use ol_parameters_decl_/**/REALKIND, only: CI
  implicit none
  complex(REALKIND), intent(in) :: A(39)
  complex(REALKIND), intent(out) :: M1(2), M2(1)

  M1(1) = (A(29)+A(30)+A(31))*f(1)+CI*(A(33)+A(34))*f(2)+(A(3)+A(4)+A(5)+A(11)+A(14)+A(15)+A(17)+A(18)+A(24)+A(25)+A(37) &
       +A(38))*f(4)+CI*(A(1)+A(8)+A(9)+A(16)+A(21)+A(26))*f(5)
  M1(2) = (A(27)+A(28)+A(32))*f(1)+CI*(-A(33)-A(34))*f(2)+(A(2)+A(6)+A(7)+A(10)+A(12)+A(13)+A(19)+A(20)+A(22)+A(23)+A(35) &
       +A(36))*f(4)+CI*(-A(1)-A(8)-A(9)-A(16)-A(21)-A(26))*f(5)

  M2(1) = -2*A(39)*f(3)

end subroutine colourvectors

end module ol_loop_pphhtt_lambda4_ttxhhgg_1_/**/REALKIND
