
module ol_colourmatrix_pphhtt_lambda4_ttxddxhh_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  logical, save           :: colmat_not_initialised = .true.
  complex(REALKIND), save :: K1(69,3), K2(3,0), KL(3,3)
  contains
  subroutine colourmatrix_init
    use ol_parameters_decl_/**/REALKIND, only: CI
    implicit none
    colmat_not_initialised = .false.
    ! colour matrix

  K1( 1,:) = [   9,   0,   3]
  K1( 2,:) = [   0,   0,   0]
  K1( 3,:) = [   3,   0,   9]
  K1( 4,:) = [   0,   4,   0]
  K1( 5,:) = [   4,   0,  12]
  K1( 6,:) = [   0,  12,   0]
  K1( 7,:) = [   0,  -4,   0]
  K1( 8,:) = [  -4,   0, -12]
  K1( 9,:) = [   0, -12,   0]
  K1(10,:) = [   0,   4,   0]
  K1(11,:) = [   4,   0,  12]
  K1(12,:) = [   0,  12,   0]
  K1(13,:) = [   0,   4,   0]
  K1(14,:) = [   4,   0,   0]
  K1(15,:) = [   0,   0,   0]
  K1(16,:) = [   0,  -4,   0]
  K1(17,:) = [  -4,   0,   0]
  K1(18,:) = [   0,   0,   0]
  K1(19,:) = [   0,   4,   0]
  K1(20,:) = [   4,   0,  12]
  K1(21,:) = [   0,  12,   0]
  K1(22,:) = [   0,  -4,   0]
  K1(23,:) = [  -4,   0,   0]
  K1(24,:) = [   0,   0,   0]
  K1(25,:) = [   0,   4,   0]
  K1(26,:) = [   4,   0,   0]
  K1(27,:) = [   0,   0,   0]
  K1(28,:) = [   0,  -4,   0]
  K1(29,:) = [  -4,   0, -12]
  K1(30,:) = [   0, -12,   0]
  K1(31,:) = [   0,   4,   0]
  K1(32,:) = [   4,   0,  12]
  K1(33,:) = [   0,  12,   0]
  K1(34,:) = [   0,   0,   0]
  K1(35,:) = [   0,   0,   0]
  K1(36,:) = [   0,   0,   0]
  K1(37,:) = [   0,   0,   0]
  K1(38,:) = [   0,   0,   0]
  K1(39,:) = [   0,   0,   0]
  K1(40,:) = [   0,   0,   0]
  K1(41,:) = [   0,   0,   0]
  K1(42,:) = [   0,   0,   0]
  K1(43,:) = [   0,   0,   0]
  K1(44,:) = [   0,   0,   0]
  K1(45,:) = [   0,   0,   0]
  K1(46,:) = [   0,   0,   0]
  K1(47,:) = [   0,   0,   0]
  K1(48,:) = [   0,   0,   0]
  K1(49,:) = [   0,   0,   0]
  K1(50,:) = [   0,   0,   0]
  K1(51,:) = [   0,   0,   0]
  K1(52,:) = [   0,   0,   0]
  K1(53,:) = [   0,   0,   0]
  K1(54,:) = [   0,   0,   0]
  K1(55,:) = [   0,   0,   0]
  K1(56,:) = [   0,   0,   0]
  K1(57,:) = [   0,   0,   0]
  K1(58,:) = [   0,   0,   0]
  K1(59,:) = [   0,   0,   0]
  K1(60,:) = [   0,   0,   0]
  K1(61,:) = [   0,   0,   0]
  K1(62,:) = [   0,   0,   0]
  K1(63,:) = [   0,   0,   0]
  K1(64,:) = [   0,   0,   0]
  K1(65,:) = [   0,   0,   0]
  K1(66,:) = [   0,   0,   0]
  K1(67,:) = [   9,   0,   3]
  K1(68,:) = [   0,   0,   0]
  K1(69,:) = [   3,   0,   9]

  KL(1,:) = [ 9, 3, 0]
  KL(2,:) = [ 0, 0, 0]
  KL(3,:) = [ 3, 9, 0]

  end subroutine colourmatrix_init
end module ol_colourmatrix_pphhtt_lambda4_ttxddxhh_1_/**/REALKIND



module ol_forced_parameters_pphhtt_lambda4_ttxddxhh_1_/**/REALKIND
  implicit none
  contains
  subroutine check_forced_parameters
    use ol_parameters_decl_/**/REALKIND
    use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
    use ol_loop_parameters_decl_/**/DREALKIND, only: LeadingColour, nc, nf, CKMORDER
#endif
    implicit none
    logical, save :: checks_not_written = .true.

    if (checks_not_written) then
    ! e.g.
    ! if (ME /= 0) write(*,101) 'ME = 0'
  if (CKMORDER /= 0) write(*,101) 'CKMORDER = 0'
  if (nc /= 3) write(*,101) 'nc = 3'
  if (nf /= 6) write(*,101) 'nf = 6'
  if (MU /= 0) write(*,101) 'MU = 0'
  if (MD /= 0) write(*,101) 'MD = 0'
  if (MS /= 0) write(*,101) 'MS = 0'
  if (MC /= 0) write(*,101) 'MC = 0'
  if (YU /= 0) write(*,101) 'YU = 0'
  if (YD /= 0) write(*,101) 'YD = 0'
  if (YS /= 0) write(*,101) 'YS = 0'
  if (YC /= 0) write(*,101) 'YC = 0'
  if (LeadingColour /= 0) write(*,101) 'LeadingColour = 0'
  if (wMT /= 0) write(*,101) 'wMT = 0'
  if (wMT /= 0) write(*,101) 'wMT = 0'
  if (wMH /= 0) write(*,101) 'wMH = 0'
  if (wMH /= 0) write(*,101) 'wMH = 0'


    checks_not_written = .false.
    end if

    101 format('[OpenLoops] === WARNING ===',/,'[OpenLoops] code was generated with ',A,/,'[OpenLoops] ===============')
  end subroutine check_forced_parameters
end module ol_forced_parameters_pphhtt_lambda4_ttxddxhh_1_/**/REALKIND

module ol_loop_pphhtt_lambda4_ttxddxhh_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND, intkind1
  implicit none
  ! diagram prefactors
  integer,           save :: fac_status_loop1 = -1, fac_status_loop2 = -1
  complex(REALKIND), save :: f(12), c(6)
  ! tree wavefunctions
  complex(REALKIND), save :: wf(4,-6+1:43)
  ! denominators
  complex(REALKIND), save :: den(48)
  ! Born, CT and Loop colour vector for each helicity configuration
  complex(REALKIND), save :: M0(3,16), Mct(0,16), Mcol_loop(3,16)
  ! zero helicity identifier
  logical,           save :: zerohel(16) = .true., zerohel_ct(16) = .true.

  contains

! **********************************************************************
subroutine fac_init_loop()
! Writes diagram prefactors to 'f', rsp. 'c'
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND
  use ol_parameters_decl_/**/DREALKIND, only: do_ew_renorm
  use ol_loop_parameters_decl_/**/REALKIND
  use ol_parameters_init_/**/REALKIND, only: ensure_mp_loop_init
  use ol_init, only: set_parameter, tree_parameters_flush, parameters_flush
#ifndef PRECISION_dp
  use ol_loop_parameters_decl_/**/DREALKIND, only: SwF, SwB
!  use ol_loop_parameters_decl_/**/DREALKIND, only: DOI
#endif
  implicit none
  call set_parameter("ew_renorm", 0)
  if (parameters_status == 0) call tree_parameters_flush()
  if (loop_parameters_status == 0) call parameters_flush()
  call ensure_mp_loop_init()
  fac_status_loop1 = parameters_status
  fac_status_loop2 = loop_parameters_status
  ! factors of the diagrams
    f( 1) = (CI*eQED**4*lambdaHZZ*YT)/(2._/**/REALKIND*cw**2*sw**2)
    f( 2) = (CI*eQED**4*lambdaHHH*MH**2*YT)/(6._/**/REALKIND*MW**2*sw**2)
    f( 3) = (3*CI*eQED**4*lambdaHHH*MH**2*YT)/(4._/**/REALKIND*MW**2*sw**2)
    f( 4) = (3*CI*eQED**2*gQCD**2*lambdaHHH*MH**2*YT)/(4._/**/REALKIND*MW**2*sw**2)
    f( 5) = (CI*eQED**4*YT**2)/(18._/**/REALKIND*MW**2*sw**2)
    f( 6) = (CI*eQED**4*YT**2)/(4._/**/REALKIND*MW**2*sw**2)
    f( 7) = (CI*eQED**2*gQCD**2*YT**2)/(4._/**/REALKIND*MW**2*sw**2)
    f( 8) = (eQED**6*integralnorm*lambdaHHHH*MH**2*SwB*YT**2)/(MW**4*sw**4*24._/**/REALKIND)
    f( 9) = (3*eQED**6*integralnorm*lambdaHHHH*MH**2*SwB*YT**2)/(MW**4*sw**4*16._/**/REALKIND)
    f(10) = (3*eQED**4*gQCD**2*integralnorm*lambdaHHHH*MH**2*SwB*YT**2)/(MW**4*sw**4*16._/**/REALKIND)
    f(11) = (eQED**6*integralnorm*lambdaHHHH*MH**2*SwF*YT**2)/(MW**4*sw**4*24._/**/REALKIND)
    f(12) = (3*eQED**6*integralnorm*lambdaHHHH*MH**2*SwF*YT**2)/(MW**4*sw**4*16._/**/REALKIND)

  c = [ 6*f(8), 6*f(9), f(10), 3*f(10), 18*f(11), 18*f(12) ]
  c = (1._/**/REALKIND / 6) * c
end subroutine fac_init_loop


! **********************************************************************
subroutine tree_wavefunctions(P, H, M1, M2, POLSEL)
! P(0:3,npart) = 2 -> n-2 external momenta (standard representation)
! H(npart)     = external-particle helicities
! Writes the tree wave functions to 'wf', denominators to 'den'.
! Returns the Born and counterterm colour vectors M1 and M2.
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/REALKIND ! counterterms
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_wavefunctions_/**/REALKIND
  use ol_propagators_/**/REALKIND
  use ol_vertices_/**/REALKIND
  use ol_counterterms_/**/REALKIND
  implicit none
  real(REALKIND),    intent(in)  :: P(0:3,6)
  integer,           intent(in)  :: H(6)
  integer,           intent(in), optional  :: POLSEL(6)
  complex(REALKIND), intent(out) :: M1(3), M2(0)
  complex(REALKIND) :: A(28)
  ! external WFs
  if (present(POLSEL)) then
    call pol_wf_Q(P(:,1), rMT, H(1), wf(:,0), POLSEL(1))
    call pol_wf_A(P(:,2), rMT, H(2), wf(:,-1), POLSEL(2))
    call pol_wf_Q(P(:,3), rZERO, H(3), wf(:,-2), POLSEL(3))
    call pol_wf_A(P(:,4), rZERO, H(4), wf(:,-3), POLSEL(4))
    call pol_wf_S(P(:,5), rMH, H(5), wf(:,-4), POLSEL(5))
    call pol_wf_S(P(:,6), rMH, H(6), wf(:,-5), POLSEL(6))

  else
    call pol_wf_Q(P(:,1), rMT, H(1), wf(:,0), 0)
    call pol_wf_A(P(:,2), rMT, H(2), wf(:,-1), 0)
    call pol_wf_Q(P(:,3), rZERO, H(3), wf(:,-2), 0)
    call pol_wf_A(P(:,4), rZERO, H(4), wf(:,-3), 0)
    call pol_wf_S(P(:,5), rMH, H(5), wf(:,-4), 0)
    call pol_wf_S(P(:,6), rMH, H(6), wf(:,-5), 0)

  end if

  ! internal WFs
  call vert_QS_A(gH,wf(:,0),wf(:,-4),wf(:,1))
  call vert_SA_Q(gH,wf(:,-5),wf(:,-1),wf(:,2))
  call vert_QA_V(wf(:,-2),wf(:,-3),wf(:,3))
  call prop_Q_A(wf(:,1),Q(:,17),MT,1_intkind1,wf(:,4))
  call prop_A_Q(wf(:,2),Q(:,34),MT,1_intkind1,wf(:,5))
  call vert_QA_V(wf(:,4),wf(:,5),wf(:,6))
  call vert_QA_Z(gZd,wf(:,-2),wf(:,-3),wf(:,7))
  call prop_W_W(wf(:,7),Q(:,12),MZ,1_intkind1,wf(:,8))
  call vert_QA_Z(gZu,wf(:,4),wf(:,5),wf(:,9))
  call vert_QA_Z(gZu,wf(:,4),wf(:,-1),wf(:,10))
  call vert_SV_V(wf(:,-5),wf(:,8),wf(:,11))
  call prop_W_W(wf(:,10),Q(:,19),MZ,1_intkind1,wf(:,12))
  call vert_AV_Q(wf(:,-1),wf(:,3),wf(:,13))
  call vert_QS_A(gH,wf(:,4),wf(:,-5),wf(:,14))
  call prop_A_Q(wf(:,13),Q(:,14),MT,1_intkind1,wf(:,15))
  call vert_AZ_Q(gZu,wf(:,-1),wf(:,8),wf(:,16))
  call prop_A_Q(wf(:,16),Q(:,14),MT,1_intkind1,wf(:,17))
  call vert_QS_A(gH,wf(:,0),wf(:,-5),wf(:,18))
  call vert_SA_Q(gH,wf(:,-4),wf(:,-1),wf(:,19))
  call prop_Q_A(wf(:,18),Q(:,33),MT,1_intkind1,wf(:,20))
  call prop_A_Q(wf(:,19),Q(:,18),MT,1_intkind1,wf(:,21))
  call vert_QA_V(wf(:,20),wf(:,21),wf(:,22))
  call vert_QA_Z(gZu,wf(:,20),wf(:,21),wf(:,23))
  call vert_QA_Z(gZu,wf(:,0),wf(:,21),wf(:,24))
  call prop_W_W(wf(:,24),Q(:,19),MZ,1_intkind1,wf(:,25))
  call vert_VQ_A(wf(:,3),wf(:,0),wf(:,26))
  call vert_SA_Q(gH,wf(:,-5),wf(:,21),wf(:,27))
  call prop_Q_A(wf(:,26),Q(:,13),MT,1_intkind1,wf(:,28))
  call vert_ZQ_A(gZu,wf(:,8),wf(:,0),wf(:,29))
  call prop_Q_A(wf(:,29),Q(:,13),MT,1_intkind1,wf(:,30))
  call vert_QA_Z(gZu,wf(:,20),wf(:,-1),wf(:,31))
  call vert_SV_V(wf(:,-4),wf(:,8),wf(:,32))
  call prop_W_W(wf(:,31),Q(:,35),MZ,1_intkind1,wf(:,33))
  call vert_QS_A(gH,wf(:,20),wf(:,-4),wf(:,34))
  call vert_QA_Z(gZu,wf(:,0),wf(:,5),wf(:,35))
  call prop_W_W(wf(:,35),Q(:,35),MZ,1_intkind1,wf(:,36))
  call vert_SA_Q(gH,wf(:,-4),wf(:,5),wf(:,37))
  call vert_SS_S(wf(:,-4),wf(:,-5),wf(:,38))
  call vert_SA_Q(gH,wf(:,38),wf(:,-1),wf(:,39))
  call vert_QS_A(gH,wf(:,0),wf(:,38),wf(:,40))
  call prop_Q_A(wf(:,40),Q(:,49),MT,1_intkind1,wf(:,41))
  call vert_AQ_S(gH,wf(:,-1),wf(:,0),wf(:,42))
  call vert_SSS_S(wf(:,42),wf(:,-4),wf(:,-5),wf(:,43))

  call denominators()
  call diagrams(A)
  call colourvectors(A, M1, M2)
end subroutine tree_wavefunctions


subroutine denominators()
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_momenta_decl_/**/REALKIND, only: Q
  implicit none
  ! propagators
  den(1) = 1 / (Q(5,17) - MT2)
  den(2) = 1 / (Q(5,34) - MT2)
  den(3) = 1 / (Q(5,12))
  den(6) = 1 / (Q(5,12) - MZ2)
  den(8) = 1 / (Q(5,19) - MZ2)
  den(11) = 1 / (Q(5,14) - MT2)
  den(16) = 1 / (Q(5,33) - MT2)
  den(17) = 1 / (Q(5,18) - MT2)
  den(23) = 1 / (Q(5,13) - MT2)
  den(28) = 1 / (Q(5,35) - MZ2)
  den(37) = 1 / (Q(5,48) - MH2)
  den(40) = 1 / (Q(5,49) - MT2)
  den(44) = 1 / (Q(5,3) - MH2)
  den(45) = 1 / (Q(5,51) - MH2)

  ! denominators
  den(4) = den(1)*den(2)
  den(5) = den(3)*den(4)
  den(7) = den(4)*den(6)
  den(9) = den(1)*den(8)
  den(10) = den(6)*den(9)
  den(12) = den(3)*den(11)
  den(13) = den(1)*den(12)
  den(14) = den(6)*den(11)
  den(15) = den(1)*den(14)
  den(18) = den(16)*den(17)
  den(19) = den(3)*den(18)
  den(20) = den(6)*den(18)
  den(21) = den(8)*den(17)
  den(22) = den(6)*den(21)
  den(24) = den(3)*den(23)
  den(25) = den(17)*den(24)
  den(26) = den(6)*den(23)
  den(27) = den(17)*den(26)
  den(29) = den(16)*den(28)
  den(30) = den(6)*den(29)
  den(31) = den(12)*den(16)
  den(32) = den(14)*den(16)
  den(33) = den(2)*den(28)
  den(34) = den(6)*den(33)
  den(35) = den(2)*den(24)
  den(36) = den(2)*den(26)
  den(38) = den(24)*den(37)
  den(39) = den(26)*den(37)
  den(41) = den(37)*den(40)
  den(42) = den(3)*den(41)
  den(43) = den(6)*den(41)
  den(46) = den(44)*den(45)
  den(47) = den(3)*den(46)
  den(48) = den(6)*den(46)

end subroutine denominators


subroutine diagrams(A)
  ! colour stripped tree amplitudes
  use ol_contractions_/**/REALKIND
  implicit none
  complex(REALKIND), intent(out) :: A(28)

  A(1) = cont_VV(wf(:,3),wf(:,6)) * den(5)
  A(2) = cont_VV(wf(:,8),wf(:,9)) * den(7)
  A(3) = cont_VV(wf(:,3),wf(:,6)) * den(5)
  A(4) = cont_VV(wf(:,11),wf(:,12)) * den(10)
  A(5) = cont_QA(wf(:,14),wf(:,15)) * den(13)
  A(6) = cont_QA(wf(:,14),wf(:,17)) * den(15)
  A(7) = cont_QA(wf(:,14),wf(:,15)) * den(13)
  A(8) = cont_VV(wf(:,3),wf(:,22)) * den(19)
  A(9) = cont_VV(wf(:,8),wf(:,23)) * den(20)
  A(10) = cont_VV(wf(:,3),wf(:,22)) * den(19)
  A(11) = cont_VV(wf(:,11),wf(:,25)) * den(22)
  A(12) = cont_QA(wf(:,27),wf(:,28)) * den(25)
  A(13) = cont_QA(wf(:,27),wf(:,30)) * den(27)
  A(14) = cont_QA(wf(:,27),wf(:,28)) * den(25)
  A(15) = cont_VV(wf(:,32),wf(:,33)) * den(30)
  A(16) = cont_QA(wf(:,15),wf(:,34)) * den(31)
  A(17) = cont_QA(wf(:,17),wf(:,34)) * den(32)
  A(18) = cont_QA(wf(:,15),wf(:,34)) * den(31)
  A(19) = cont_VV(wf(:,32),wf(:,36)) * den(34)
  A(20) = cont_QA(wf(:,28),wf(:,37)) * den(35)
  A(21) = cont_QA(wf(:,30),wf(:,37)) * den(36)
  A(22) = cont_QA(wf(:,28),wf(:,37)) * den(35)
  A(23) = cont_QA(wf(:,28),wf(:,39)) * den(38)
  A(24) = cont_QA(wf(:,30),wf(:,39)) * den(39)
  A(25) = cont_QA(wf(:,28),wf(:,39)) * den(38)
  A(26) = cont_QA(wf(:,13),wf(:,41)) * den(42)
  A(27) = cont_QA(wf(:,16),wf(:,41)) * den(43)
  A(28) = cont_QA(wf(:,13),wf(:,41)) * den(42)


end subroutine diagrams


subroutine colourvectors(A, M1, M2)
  ! Born and counterterm colour vectors
  use ol_parameters_decl_/**/REALKIND, only: CI
  implicit none
  complex(REALKIND), intent(in) :: A(28)
  complex(REALKIND), intent(out) :: M1(3), M2(0)

  M1(1) = ((A(25)+A(28))*f(4))/2._/**/REALKIND+((A(3)+A(7)+A(10)+A(14)+A(18)+A(22))*f(7))/2._/**/REALKIND
  M1(2) = (A(4)+A(11)+A(15)+A(19))*f(1)+(-A(23)-A(26))*f(2)+(A(24)+A(27))*f(3)+(-A(1)-A(5)-A(8)-A(12)-A(16)-A(20))*f(5)+(A(2)+A(6) &
       +A(9)+A(13)+A(17)+A(21))*f(6)
  M1(3) = ((-A(25)-A(28))*f(4))/6._/**/REALKIND+((-A(3)-A(7)-A(10)-A(14)-A(18)-A(22))*f(7))/6._/**/REALKIND


end subroutine colourvectors

end module ol_loop_pphhtt_lambda4_ttxddxhh_1_/**/REALKIND
