
module ol_vamp_1_ppzzj_ddxzzg_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppzzj_ddxzzg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppzzj_ddxzzg_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_momenta_decl_/**/QREALKIND, only: Q
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_ppzzj_ddxzzg_1_/**/DREALKIND
  use ol_tensor_sum_storage_ppzzj_ddxzzg_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_ppzzj_ddxzzg_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_ppzzj_ddxzzg_1_/**/DREALKIND, only: ntry, p_switch, Hel
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(72)
  type(Hpolcont), intent(in) :: M(1,72)


#ifndef PRECISION_dp
  if (ntry==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel
#else
  if (ntry==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
call G0_hol_initialisation(ntry,Gcoeff,G0H72(1),m0h(1),h0tab(:,1),[16,4,1,2,8],[0,0,0,0,0],5,0)
  call Hloop_AV_Q(ntry,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,1),heltab2x72(:,:,1))
  call Hloop_A_Q(ntry,G0H36(1),16,0,G1H36(1),n2h36(1))
Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
call G0_hol_initialisation(ntry,Gcoeff,G0H72(1),m0h(2),h0tab(:,2),[16,2,1,4,8],[0,0,0,0,0],5,0)
  call Hloop_QV_A(ntry,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,2),heltab2x72(:,:,2))
  call Hloop_Q_A(ntry,G0H36(1),16,0,G1H36(2),n2h36(2))
Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
call G0_hol_initialisation(ntry,Gcoeff,G0H72(1),m0h(3),h0tab(:,3),[16,4,2,1,8],[0,0,0,0,0],5,0)
  call Hloop_QV_A(ntry,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,3),heltab2x72(:,:,3))
  call Hloop_Q_A(ntry,G0H36(1),16,0,G1H36(3),n2h36(3))
Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
call G0_hol_initialisation(ntry,Gcoeff,G0H72(1),m0h(4),h0tab(:,4),[16,2,1,8,4],[0,0,0,0,0],5,0)
  call Hloop_QV_A(ntry,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,4),heltab2x72(:,:,4))
  call Hloop_Q_A(ntry,G0H36(1),16,0,G1H36(4),n2h36(4))
Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
call G0_hol_initialisation(ntry,Gcoeff,G0H72(1),m0h(5),h0tab(:,5),[16,1,2,4,8],[0,0,0,0,0],5,0)
  call Hloop_AV_Q(ntry,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,5),heltab2x72(:,:,5))
  call Hloop_A_Q(ntry,G0H36(1),16,0,G1H36(5),n2h36(5))
Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
call G0_hol_initialisation(ntry,Gcoeff,G0H72(1),m0h(6),h0tab(:,6),[16,1,2,8,4],[0,0,0,0,0],5,0)
  call Hloop_AV_Q(ntry,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,6),heltab2x72(:,:,6))
  call Hloop_A_Q(ntry,G0H36(1),16,0,G1H36(6),n2h36(6))
Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
call G0_hol_initialisation(ntry,Gcoeff,G0H72(1),m0h(7),h0tab(:,7),[16,1,4,8,2],[0,0,0,0,0],5,0)
  call Hloop_UV_W(ntry,G0H72(1),0,ex5(:),16,G1H36(7),m3h2x36(:,7),heltab2x72(:,:,7))
Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
call G0_hol_initialisation(ntry,Gcoeff,G0H72(1),m0h(8),h0tab(:,8),[16,1,8,4,2],[0,0,0,0,0],5,0)
  call Hloop_UV_W(ntry,G0H72(1),0,ex5(:),16,G1H36(8),m3h2x36(:,8),heltab2x72(:,:,8))
  call Hloop_AZ_Q(ntry,G1H36(1),ex3(:),G1H12(1),ngZd,m3h3x12(:,1),heltab2x36(:,:,1))
  call Hloop_A_Q(ntry,G1H12(1),20,0,G2H12(1),n2h12(1))
  call Hloop_QA_V(ntry,G1H36(2),ex2(:),G1H18(1),m3h2x18(:,1),heltab2x36(:,:,2))
  call Hloop_QZ_A(ntry,G1H36(3),ex3(:),G1H12(1),ngZd,m3h3x12(:,2),heltab2x36(:,:,3))
  call Hloop_Q_A(ntry,G1H12(1),20,0,G2H12(2),n2h12(2))
  call Hloop_QA_V(ntry,G1H36(4),ex2(:),G1H18(2),m3h2x18(:,2),heltab2x36(:,:,4))
  call Hloop_AQ_V(ntry,G1H36(5),ex1(:),G1H18(3),m3h2x18(:,3),heltab2x36(:,:,5))
  call Hloop_AQ_V(ntry,G1H36(6),ex1(:),G1H18(4),m3h2x18(:,4),heltab2x36(:,:,6))
  call Hloop_VQ_A(ntry,G1H36(7),ex1(:),G1H18(5),m3h2x18(:,5),heltab2x36(:,:,7))
  call Hloop_Q_A(ntry,G1H18(5),17,0,G2H18(1),n2h18(1))
  call Hloop_VQ_A(ntry,G1H36(8),ex1(:),G1H18(5),m3h2x18(:,6),heltab2x36(:,:,8))
  call Hloop_Q_A(ntry,G1H18(5),17,0,G2H18(2),n2h18(2))
  call Hloop_AQ_V(ntry,G2H12(1),ex1(:),G2H6(1),m3h2x6(:,1),heltab2x12(:,:,1))
  call Hloop_VQ_A(ntry,G1H18(1),ex1(:),G1H9(1),m3h2x9(:,1),heltab2x18(:,:,1))
  call Hloop_Q_A(ntry,G1H9(1),19,0,G2H9(1),n2h9(1))
  call Hloop_QA_V(ntry,G2H12(2),ex2(:),G2H6(2),m3h2x6(:,2),heltab2x12(:,:,2))
  call Hloop_VQ_A(ntry,G1H18(2),ex1(:),G1H9(1),m3h2x9(:,2),heltab2x18(:,:,2))
  call Hloop_Q_A(ntry,G1H9(1),19,0,G2H9(2),n2h9(2))
  call Hloop_VA_Q(ntry,G1H18(3),ex2(:),G1H9(1),m3h2x9(:,3),heltab2x18(:,:,3))
  call Hloop_A_Q(ntry,G1H9(1),19,0,G2H9(3),n2h9(3))
  call Hloop_VA_Q(ntry,G1H18(4),ex2(:),G1H9(1),m3h2x9(:,4),heltab2x18(:,:,4))
  call Hloop_A_Q(ntry,G1H9(1),19,0,G2H9(4),n2h9(4))
call Hotf_5pt_reduction(G2H18(1),RedSet_5(1),mass5set(:,1),  & 
G1H18(5),G1H18(1),G1H18(2),G1H18(3),G1H18(4),G1H18(6),18)
call HG1shiftOLR(G1H18(1),2,18)
call Hotf_5pt_reduction(G2H18(2),RedSet_5(2),mass5set(:,1),  & 
G1H18(7),G1H18(8),G1H18(9),G1H18(10),G1H18(11),G1H18(12),18)
call HG1shiftOLR(G1H18(8),2,18)
  call Hloop_QZ_A(ntry,G1H18(5),ex3(:),G1H6(1),ngZd,m3h3x6(:,1),heltab2x18(:,:,5))
  call Hloop_Q_A(ntry,G1H6(1),21,0,G2H6(3),n2h6(1))
call HGT_raise_alpha_OLR(G1H18(1),1,1,18)
call HGT_raise_alpha_invQ_OLR(G1H18(1),2,5,18)
  call Hloop_VA_Q(ntry,G1H18(1),ex2(:),G1H9(1),m3h2x9(:,5),heltab2x18(:,:,6))
  call Hloop_QZ_A(ntry,G1H18(3),ex3(:),G1H6(1),ngZd,m3h3x6(:,2),heltab2x18(:,:,7))
  call Hloop_Q_A(ntry,G1H6(1),21,0,G2H6(4),n2h6(2))
  call Hloop_QZ_A(ntry,G1H18(4),ex3(:),G1H6(1),ngZd,m3h3x6(:,3),heltab2x18(:,:,8))
  call Hloop_Q_A(ntry,G1H6(1),21,0,G2H6(5),n2h6(3))
  call Hloop_QZ_A(ntry,G1H18(6),ex3(:),G1H6(1),ngZd,m3h3x6(:,4),heltab2x18(:,:,9))
  call Hloop_Q_A(ntry,G1H6(1),21,0,G2H6(6),n2h6(4))
  call Hloop_QZ_A(ntry,G1H18(7),ex4(:),G1H6(1),ngZd,m3h3x6(:,5),heltab2x18(:,:,10))
  call Hloop_Q_A(ntry,G1H6(1),25,0,G2H6(7),n2h6(5))
call HGT_raise_alpha_OLR(G1H18(8),1,1,18)
call HGT_raise_alpha_invQ_OLR(G1H18(8),2,5,18)
  call Hloop_VA_Q(ntry,G1H18(8),ex2(:),G1H9(2),m3h2x9(:,6),heltab2x18(:,:,11))
  call Hloop_QZ_A(ntry,G1H18(10),ex4(:),G1H6(1),ngZd,m3h3x6(:,6),heltab2x18(:,:,12))
  call Hloop_Q_A(ntry,G1H6(1),25,0,G2H6(8),n2h6(6))
  call Hloop_QZ_A(ntry,G1H18(11),ex4(:),G1H6(1),ngZd,m3h3x6(:,7),heltab2x18(:,:,13))
  call Hloop_Q_A(ntry,G1H6(1),25,0,G2H6(9),n2h6(7))
  call Hloop_QZ_A(ntry,G1H18(12),ex4(:),G1H6(1),ngZd,m3h3x6(:,8),heltab2x18(:,:,14))
  call Hloop_Q_A(ntry,G1H6(1),25,0,G2H6(10),n2h6(8))
call Hotf_5pt_reduction(G2H6(1),RedSet_5(3),mass5set(:,1),  & 
G1H6(1),G1H6(2),G1H6(3),G1H6(4),G1H6(5),G1H6(6),6)
call HG1shiftOLR(G1H6(2),8,6)
call Hotf_5pt_reduction(G2H9(1),RedSet_5(4),mass5set(:,1),  & 
G1H9(3),G1H9(4),G1H9(5),G1H9(6),G1H9(7),G1H9(8),9)
call HG1shiftOLR(G1H9(4),8,9)
call Hotf_5pt_reduction(G2H6(2),RedSet_5(5),mass5set(:,1),  & 
G1H6(7),G1H6(8),G1H6(9),G1H6(10),G1H6(11),G1H6(12),6)
call HG1shiftOLR(G1H6(8),8,6)
call Hotf_5pt_reduction(G2H9(2),RedSet_5(6),mass5set(:,1),  & 
G1H9(9),G1H9(10),G1H9(11),G1H9(12),G1H9(13),G1H9(14),9)
call HG1shiftOLR(G1H9(10),4,9)
call Hotf_5pt_reduction(G2H9(3),RedSet_5(7),mass5set(:,1),  & 
G1H9(15),G1H9(16),G1H9(17),G1H9(18),G1H9(19),G1H9(20),9)
call HG1shiftOLR(G1H9(16),8,9)
call Hotf_5pt_reduction(G2H9(4),RedSet_5(8),mass5set(:,1),  & 
G1H9(21),G1H9(22),G1H9(23),G1H9(24),G1H9(25),G1H9(26),9)
call HG1shiftOLR(G1H9(22),4,9)
call Hotf_5pt_reduction(G2H6(3),RedSet_5(1),mass5set(:,1),  & 
G1H6(13),G1H6(14),G1H6(15),G1H6(16),G1H6(17),G1H6(18),6)
call HG1shiftOLR(G1H6(14),2,6)
call Hotf_4pt_reduction(G2H6(5),RedSet_4(1),mass4set(:,1),  & 
G1H6(19),G1H6(20),G1H6(21),G1H6(22),G1H6(23),6)
call HG1shiftOLR(G1H6(20),2,6)
call Hotf_4pt_reduction(G2H6(6),RedSet_4(2),mass4set(:,1),  & 
G1H6(24),G1H6(25),G1H6(26),G1H6(27),G1H6(28),6)
call HG1shiftOLR(G1H6(25),10,6)
call Hotf_5pt_reduction(G2H6(7),RedSet_5(2),mass5set(:,1),  & 
G1H6(29),G1H6(30),G1H6(31),G1H6(32),G1H6(33),G1H6(34),6)
call HG1shiftOLR(G1H6(30),2,6)
call Hotf_4pt_reduction(G2H6(9),RedSet_4(1),mass4set(:,1),  & 
G1H6(35),G1H6(36),G1H6(37),G1H6(38),G1H6(39),6)
call HG1shiftOLR(G1H6(36),2,6)
call Hotf_4pt_reduction(G2H6(10),RedSet_4(3),mass4set(:,1),  & 
G1H6(40),G1H6(41),G1H6(42),G1H6(43),G1H6(44),6)
call HG1shiftOLR(G1H6(41),6,6)
  call ol_merge(ntry,G1H6(19),[G1H6(17)])
  call ol_merge(ntry,G1H6(24),[G1H6(18)])
  call ol_merge(ntry,G1H6(35),[G1H6(33)])
  call ol_merge(ntry,G1H6(40),[G1H6(34)])
  call Hloop_VA_Q(ntry,G1H6(1),ex2(:),G1H3(1),m3h2x3(:,1),heltab2x6(:,:,1))
  call Hloop_A_Q(ntry,G1H3(1),23,0,G2H3(1),n2h3(1))
call HGT_OLR(G1H6(2),1,1,6)
call HGT_invQ_OLR(G1H6(2),2,5,6)
  call Hloop_Q_A(ntry,G1H6(2),-8,0,G2H6(1),n2h6(9))
  call Hloop_QZ_A(ntry,G2H6(1),ex4(:),G2H2(1),ngZd,m3h3x2(:,1),heltab2x6(:,:,2))
  call Hloop_VA_Q(ntry,G1H6(5),ex2(:),G1H3(1),m3h2x3(:,2),heltab2x6(:,:,3))
  call Hloop_A_Q(ntry,G1H3(1),23,0,G2H3(2),n2h3(2))
  call Hloop_VA_Q(ntry,G1H6(6),ex2(:),G1H3(1),m3h2x3(:,3),heltab2x6(:,:,4))
  call Hloop_A_Q(ntry,G1H3(1),23,0,G2H3(3),n2h3(3))
  call Hloop_QZ_A(ntry,G1H9(3),ex3(:),G1H3(1),ngZd,m3h3x3(:,1),heltab2x9(:,:,1))
  call Hloop_Q_A(ntry,G1H3(1),23,0,G2H3(4),n2h3(4))
call HGT_OLR(G1H9(4),1,1,9)
call HGT_invQ_OLR(G1H9(4),2,5,9)
  call Hloop_A_Q(ntry,G1H9(4),-8,0,G2H9(1),n2h9(5))
  call Hloop_AZ_Q(ntry,G2H9(1),ex4(:),G2H3(5),ngZd,m3h3x3(:,2),heltab2x9(:,:,2))
  call Hloop_QZ_A(ntry,G1H9(7),ex3(:),G1H3(1),ngZd,m3h3x3(:,3),heltab2x9(:,:,3))
  call Hloop_Q_A(ntry,G1H3(1),23,0,G2H3(6),n2h3(5))
  call Hloop_QZ_A(ntry,G1H9(8),ex3(:),G1H3(1),ngZd,m3h3x3(:,4),heltab2x9(:,:,4))
  call Hloop_Q_A(ntry,G1H3(1),23,0,G2H3(7),n2h3(6))
  call Hloop_VQ_A(ntry,G1H6(7),ex1(:),G1H3(1),m3h2x3(:,4),heltab2x6(:,:,5))
  call Hloop_Q_A(ntry,G1H3(1),23,0,G2H3(8),n2h3(7))
call HGT_OLR(G1H6(8),1,1,6)
call HGT_invQ_OLR(G1H6(8),2,5,6)
  call Hloop_A_Q(ntry,G1H6(8),-8,0,G2H6(2),n2h6(10))
  call Hloop_AZ_Q(ntry,G2H6(2),ex4(:),G2H2(2),ngZd,m3h3x2(:,2),heltab2x6(:,:,6))
  call Hloop_VQ_A(ntry,G1H6(11),ex1(:),G1H3(1),m3h2x3(:,5),heltab2x6(:,:,7))
  call Hloop_Q_A(ntry,G1H3(1),23,0,G2H3(9),n2h3(8))
  call Hloop_VQ_A(ntry,G1H6(12),ex1(:),G1H3(1),m3h2x3(:,6),heltab2x6(:,:,8))
  call Hloop_Q_A(ntry,G1H3(1),23,0,G2H3(10),n2h3(9))
  call Hloop_QZ_A(ntry,G1H9(9),ex4(:),G1H3(1),ngZd,m3h3x3(:,5),heltab2x9(:,:,5))
  call Hloop_Q_A(ntry,G1H3(1),27,0,G2H3(11),n2h3(10))
call HGT_OLR(G1H9(10),1,1,9)
call HGT_invQ_OLR(G1H9(10),2,5,9)
  call Hloop_A_Q(ntry,G1H9(10),-4,0,G2H9(2),n2h9(6))
  call Hloop_AZ_Q(ntry,G2H9(2),ex3(:),G2H3(12),ngZd,m3h3x3(:,6),heltab2x9(:,:,6))
  call Hloop_QZ_A(ntry,G1H9(13),ex4(:),G1H3(1),ngZd,m3h3x3(:,7),heltab2x9(:,:,7))
  call Hloop_Q_A(ntry,G1H3(1),27,0,G2H3(13),n2h3(11))
  call Hloop_QZ_A(ntry,G1H9(14),ex4(:),G1H3(1),ngZd,m3h3x3(:,8),heltab2x9(:,:,8))
  call Hloop_Q_A(ntry,G1H3(1),27,0,G2H3(14),n2h3(12))
  call Hloop_AZ_Q(ntry,G1H9(15),ex3(:),G1H3(1),ngZd,m3h3x3(:,9),heltab2x9(:,:,9))
  call Hloop_A_Q(ntry,G1H3(1),23,0,G2H3(15),n2h3(13))
call HGT_OLR(G1H9(16),1,1,9)
call HGT_invQ_OLR(G1H9(16),2,5,9)
  call Hloop_Q_A(ntry,G1H9(16),-8,0,G2H9(3),n2h9(7))
  call Hloop_QZ_A(ntry,G2H9(3),ex4(:),G2H3(16),ngZd,m3h3x3(:,10),heltab2x9(:,:,10))
  call Hloop_AZ_Q(ntry,G1H9(19),ex3(:),G1H3(1),ngZd,m3h3x3(:,11),heltab2x9(:,:,11))
  call Hloop_A_Q(ntry,G1H3(1),23,0,G2H3(17),n2h3(14))
  call Hloop_AZ_Q(ntry,G1H9(20),ex3(:),G1H3(1),ngZd,m3h3x3(:,12),heltab2x9(:,:,12))
  call Hloop_A_Q(ntry,G1H3(1),23,0,G2H3(18),n2h3(15))
  call Hloop_AZ_Q(ntry,G1H9(21),ex4(:),G1H3(1),ngZd,m3h3x3(:,13),heltab2x9(:,:,13))
  call Hloop_A_Q(ntry,G1H3(1),27,0,G2H3(19),n2h3(16))
call HGT_OLR(G1H9(22),1,1,9)
call HGT_invQ_OLR(G1H9(22),2,5,9)
  call Hloop_Q_A(ntry,G1H9(22),-4,0,G2H9(4),n2h9(8))
  call Hloop_QZ_A(ntry,G2H9(4),ex3(:),G2H3(20),ngZd,m3h3x3(:,14),heltab2x9(:,:,14))
  call Hloop_AZ_Q(ntry,G1H9(25),ex4(:),G1H3(1),ngZd,m3h3x3(:,15),heltab2x9(:,:,15))
  call Hloop_A_Q(ntry,G1H3(1),27,0,G2H3(21),n2h3(17))
  call Hloop_AZ_Q(ntry,G1H9(26),ex4(:),G1H3(1),ngZd,m3h3x3(:,16),heltab2x9(:,:,16))
  call Hloop_A_Q(ntry,G1H3(1),27,0,G2H3(22),n2h3(18))
  call Hloop_QZ_A(ntry,G1H6(13),ex4(:),G1H2(1),ngZd,m3h3x2(:,3),heltab2x6(:,:,9))
  call Hloop_Q_A(ntry,G1H2(1),29,0,G2H2(3),n2h2(1))
call HGT_raise_alpha_OLR(G1H6(14),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(14),2,5,6)
  call Hloop_VA_Q(ntry,G1H6(14),ex2(:),G1H3(1),m3h2x3(:,7),heltab2x6(:,:,10))
  call Hloop_QZ_A(ntry,G1H6(19),ex4(:),G1H2(1),ngZd,m3h3x2(:,4),heltab2x6(:,:,11))
  call Hloop_Q_A(ntry,G1H2(1),29,0,G2H2(4),n2h2(2))
  call Hloop_QZ_A(ntry,G1H6(24),ex4(:),G1H2(1),ngZd,m3h3x2(:,5),heltab2x6(:,:,12))
  call Hloop_Q_A(ntry,G1H2(1),29,0,G2H2(5),n2h2(3))
call HGT_raise_alpha_OLR(G1H6(20),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(20),2,5,6)
  call Hloop_VA_Q(ntry,G1H6(20),ex2(:),G1H3(2),m3h2x3(:,8),heltab2x6(:,:,13))
  call Hloop_QZ_A(ntry,G1H6(23),ex4(:),G1H2(1),ngZd,m3h3x2(:,6),heltab2x6(:,:,14))
  call Hloop_Q_A(ntry,G1H2(1),29,0,G2H2(6),n2h2(4))
call HGT_raise_alpha_OLR(G1H6(25),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(25),2,5,6)
  call Hloop_VA_Q(ntry,G1H6(25),ex2(:),G1H3(3),m3h2x3(:,9),heltab2x6(:,:,15))
  call Hloop_QZ_A(ntry,G1H6(28),ex4(:),G1H2(1),ngZd,m3h3x2(:,7),heltab2x6(:,:,16))
  call Hloop_Q_A(ntry,G1H2(1),29,0,G2H2(7),n2h2(5))
  call Hloop_QZ_A(ntry,G1H6(29),ex3(:),G1H2(1),ngZd,m3h3x2(:,8),heltab2x6(:,:,17))
  call Hloop_Q_A(ntry,G1H2(1),29,0,G2H2(8),n2h2(6))
call HGT_raise_alpha_OLR(G1H6(30),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(30),2,5,6)
  call Hloop_VA_Q(ntry,G1H6(30),ex2(:),G1H3(4),m3h2x3(:,10),heltab2x6(:,:,18))
  call Hloop_QZ_A(ntry,G1H6(35),ex3(:),G1H2(1),ngZd,m3h3x2(:,9),heltab2x6(:,:,19))
  call Hloop_Q_A(ntry,G1H2(1),29,0,G2H2(9),n2h2(7))
  call Hloop_QZ_A(ntry,G1H6(40),ex3(:),G1H2(1),ngZd,m3h3x2(:,10),heltab2x6(:,:,20))
  call Hloop_Q_A(ntry,G1H2(1),29,0,G2H2(10),n2h2(8))
call HGT_raise_alpha_OLR(G1H6(36),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(36),2,5,6)
  call Hloop_VA_Q(ntry,G1H6(36),ex2(:),G1H3(5),m3h2x3(:,11),heltab2x6(:,:,21))
  call Hloop_QZ_A(ntry,G1H6(39),ex3(:),G1H2(1),ngZd,m3h3x2(:,11),heltab2x6(:,:,22))
  call Hloop_Q_A(ntry,G1H2(1),29,0,G2H2(11),n2h2(9))
call HGT_raise_alpha_OLR(G1H6(41),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(41),2,5,6)
  call Hloop_VA_Q(ntry,G1H6(41),ex2(:),G1H3(6),m3h2x3(:,12),heltab2x6(:,:,23))
  call Hloop_QZ_A(ntry,G1H6(44),ex3(:),G1H2(1),ngZd,m3h3x2(:,12),heltab2x6(:,:,24))
  call Hloop_Q_A(ntry,G1H2(1),29,0,G2H2(12),n2h2(10))
call Hotf_5pt_reduction(G2H3(1),RedSet_5(3),mass5set(:,1),  & 
G1H3(7),G1H3(8),G1H3(9),G1H3(10),G1H3(11),G1H3(12),3)
call HG1shiftOLR(G1H3(8),8,3)
call Hotf_4pt_reduction(G2H3(3),RedSet_4(4),mass4set(:,1),  & 
G1H3(13),G1H3(14),G1H3(15),G1H3(16),G1H3(17),3)
call HG1shiftOLR(G1H3(14),10,3)
call Hotf_5pt_reduction(G2H3(4),RedSet_5(4),mass5set(:,1),  & 
G1H3(18),G1H3(19),G1H3(20),G1H3(21),G1H3(22),G1H3(23),3)
call HG1shiftOLR(G1H3(19),8,3)
call Hotf_4pt_reduction(G2H3(7),RedSet_4(5),mass4set(:,1),  & 
G1H3(24),G1H3(25),G1H3(26),G1H3(27),G1H3(28),3)
call HG1shiftOLR(G1H3(25),12,3)
call Hotf_5pt_reduction(G2H3(8),RedSet_5(5),mass5set(:,1),  & 
G1H3(29),G1H3(30),G1H3(31),G1H3(32),G1H3(33),G1H3(34),3)
call HG1shiftOLR(G1H3(30),8,3)
call Hotf_4pt_reduction(G2H3(10),RedSet_4(6),mass4set(:,1),  & 
G1H3(35),G1H3(36),G1H3(37),G1H3(38),G1H3(39),3)
call HG1shiftOLR(G1H3(36),9,3)
call Hotf_5pt_reduction(G2H3(11),RedSet_5(6),mass5set(:,1),  & 
G1H3(40),G1H3(41),G1H3(42),G1H3(43),G1H3(44),G1H3(45),3)
call HG1shiftOLR(G1H3(41),4,3)
call Hotf_4pt_reduction(G2H3(14),RedSet_4(5),mass4set(:,1),  & 
G1H3(46),G1H3(47),G1H3(48),G1H3(49),G1H3(50),3)
call HG1shiftOLR(G1H3(47),12,3)
call Hotf_5pt_reduction(G2H3(15),RedSet_5(7),mass5set(:,1),  & 
G1H3(51),G1H3(52),G1H3(53),G1H3(54),G1H3(55),G1H3(56),3)
call HG1shiftOLR(G1H3(52),8,3)
call Hotf_4pt_reduction(G2H3(18),RedSet_4(7),mass4set(:,1),  & 
G1H3(57),G1H3(58),G1H3(59),G1H3(60),G1H3(61),3)
call HG1shiftOLR(G1H3(58),12,3)
call Hotf_5pt_reduction(G2H3(19),RedSet_5(8),mass5set(:,1),  & 
G1H3(62),G1H3(63),G1H3(64),G1H3(65),G1H3(66),G1H3(67),3)
call HG1shiftOLR(G1H3(63),4,3)
call Hotf_4pt_reduction(G2H3(22),RedSet_4(7),mass4set(:,1),  & 
G1H3(68),G1H3(69),G1H3(70),G1H3(71),G1H3(72),3)
call HG1shiftOLR(G1H3(69),12,3)
  call Hcheck_last_QA_V(ntry,l_switch,G2H2(3),ex2(:),G2tensor(1),m3h2x1(:,1),heltab2x2(:,:,1))
  call Hcheck_last_QA_V(ntry,l_switch,G2H2(5),ex2(:),G2tensor(2),m3h2x1(:,2),heltab2x2(:,:,2))
  call Hcheck_last_QA_V(ntry,l_switch,G2H2(8),ex2(:),G2tensor(3),m3h2x1(:,3),heltab2x2(:,:,3))
  call Hcheck_last_QA_V(ntry,l_switch,G2H2(10),ex2(:),G2tensor(4),m3h2x1(:,4),heltab2x2(:,:,4))
  call ol_merge(ntry,G1H3(13),[G1H3(12)])
  call ol_merge(ntry,G1H3(24),[G1H3(23)])
  call ol_merge(ntry,G1H3(35),[G1H3(34)])
  call ol_merge(ntry,G1H3(46),[G1H3(45)])
  call ol_merge(ntry,G1H3(57),[G1H3(56)])
  call ol_merge(ntry,G1H3(68),[G1H3(67)])
  call Hloop_AZ_Q(ntry,G1H3(7),ex4(:),G1H1(1),ngZd,m3h3x1(:,1),heltab2x3(:,:,1))
  call Hcheck_last_A_Q(ntry,l_switch,G1H1(1),31,0,G2tensor(5),n2h1(1))
  call Hloop_AZ_Q(ntry,G1H3(8),ex4(:),G1H1(1),ngZd,m3h3x1(:,2),heltab2x3(:,:,2))
  call Hcheck_last_A_Q(ntry,l_switch,G1H1(1),8,0,G2tensor(6),n2h1(2))
  call Hloop_AZ_Q(ntry,G1H3(13),ex4(:),G1H1(1),ngZd,m3h3x1(:,3),heltab2x3(:,:,3))
  call Hcheck_last_A_Q(ntry,l_switch,G1H1(1),31,0,G2tensor(7),n2h1(3))
  call Hloop_AZ_Q(ntry,G1H3(14),ex4(:),G1H1(1),ngZd,m3h3x1(:,4),heltab2x3(:,:,4))
  call Hcheck_last_A_Q(ntry,l_switch,G1H1(1),10,0,G2tensor(8),n2h1(4))
  call Hloop_QZ_A(ntry,G1H3(18),ex4(:),G1H1(1),ngZd,m3h3x1(:,5),heltab2x3(:,:,5))
  call Hcheck_last_Q_A(ntry,l_switch,G1H1(1),31,0,G2tensor(9),n2h1(5))
  call Hloop_QZ_A(ntry,G1H3(19),ex4(:),G1H1(1),ngZd,m3h3x1(:,6),heltab2x3(:,:,6))
  call Hcheck_last_Q_A(ntry,l_switch,G1H1(1),8,0,G2tensor(10),n2h1(6))
  call Hloop_QZ_A(ntry,G1H3(24),ex4(:),G1H1(1),ngZd,m3h3x1(:,7),heltab2x3(:,:,7))
  call Hcheck_last_Q_A(ntry,l_switch,G1H1(1),31,0,G2tensor(11),n2h1(7))
  call Hloop_QZ_A(ntry,G1H3(25),ex4(:),G1H1(1),ngZd,m3h3x1(:,8),heltab2x3(:,:,8))
  call Hcheck_last_Q_A(ntry,l_switch,G1H1(1),12,0,G2tensor(12),n2h1(8))
  call Hloop_QZ_A(ntry,G1H3(29),ex4(:),G1H1(1),ngZd,m3h3x1(:,9),heltab2x3(:,:,9))
  call Hcheck_last_Q_A(ntry,l_switch,G1H1(1),31,0,G2tensor(13),n2h1(9))
  call Hloop_QZ_A(ntry,G1H3(30),ex4(:),G1H1(1),ngZd,m3h3x1(:,10),heltab2x3(:,:,10))
  call Hcheck_last_Q_A(ntry,l_switch,G1H1(1),8,0,G2tensor(14),n2h1(10))
  call Hloop_QZ_A(ntry,G1H3(35),ex4(:),G1H1(1),ngZd,m3h3x1(:,11),heltab2x3(:,:,11))
  call Hcheck_last_Q_A(ntry,l_switch,G1H1(1),31,0,G2tensor(15),n2h1(11))
  call Hloop_QZ_A(ntry,G1H3(36),ex4(:),G1H1(1),ngZd,m3h3x1(:,12),heltab2x3(:,:,12))
  call Hcheck_last_Q_A(ntry,l_switch,G1H1(1),9,0,G2tensor(16),n2h1(12))
  call Hloop_QZ_A(ntry,G1H3(40),ex3(:),G1H1(1),ngZd,m3h3x1(:,13),heltab2x3(:,:,13))
  call Hcheck_last_Q_A(ntry,l_switch,G1H1(1),31,0,G2tensor(17),n2h1(13))
  call Hloop_QZ_A(ntry,G1H3(41),ex3(:),G1H1(1),ngZd,m3h3x1(:,14),heltab2x3(:,:,14))
  call Hcheck_last_Q_A(ntry,l_switch,G1H1(1),4,0,G2tensor(18),n2h1(14))
  call Hloop_QZ_A(ntry,G1H3(46),ex3(:),G1H1(1),ngZd,m3h3x1(:,15),heltab2x3(:,:,15))
  call Hcheck_last_Q_A(ntry,l_switch,G1H1(1),31,0,G2tensor(19),n2h1(15))
  call Hloop_QZ_A(ntry,G1H3(47),ex3(:),G1H1(1),ngZd,m3h3x1(:,16),heltab2x3(:,:,16))
  call Hcheck_last_Q_A(ntry,l_switch,G1H1(1),12,0,G2tensor(20),n2h1(16))
  call Hloop_AZ_Q(ntry,G1H3(51),ex4(:),G1H1(1),ngZd,m3h3x1(:,17),heltab2x3(:,:,17))
  call Hcheck_last_A_Q(ntry,l_switch,G1H1(1),31,0,G2tensor(21),n2h1(17))
  call Hloop_AZ_Q(ntry,G1H3(52),ex4(:),G1H1(1),ngZd,m3h3x1(:,18),heltab2x3(:,:,18))
  call Hcheck_last_A_Q(ntry,l_switch,G1H1(1),8,0,G2tensor(22),n2h1(18))
  call Hloop_AZ_Q(ntry,G1H3(57),ex4(:),G1H1(1),ngZd,m3h3x1(:,19),heltab2x3(:,:,19))
  call Hcheck_last_A_Q(ntry,l_switch,G1H1(1),31,0,G2tensor(23),n2h1(19))
  call Hloop_AZ_Q(ntry,G1H3(58),ex4(:),G1H1(1),ngZd,m3h3x1(:,20),heltab2x3(:,:,20))
  call Hcheck_last_A_Q(ntry,l_switch,G1H1(1),12,0,G2tensor(24),n2h1(20))
  call Hloop_AZ_Q(ntry,G1H3(62),ex3(:),G1H1(1),ngZd,m3h3x1(:,21),heltab2x3(:,:,21))
  call Hcheck_last_A_Q(ntry,l_switch,G1H1(1),31,0,G2tensor(25),n2h1(21))
  call Hloop_AZ_Q(ntry,G1H3(63),ex3(:),G1H1(1),ngZd,m3h3x1(:,22),heltab2x3(:,:,22))
  call Hcheck_last_A_Q(ntry,l_switch,G1H1(1),4,0,G2tensor(26),n2h1(22))
  call Hloop_AZ_Q(ntry,G1H3(68),ex3(:),G1H1(1),ngZd,m3h3x1(:,23),heltab2x3(:,:,23))
  call Hcheck_last_A_Q(ntry,l_switch,G1H1(1),31,0,G2tensor(27),n2h1(23))
  call Hloop_AZ_Q(ntry,G1H3(69),ex3(:),G1H1(1),ngZd,m3h3x1(:,24),heltab2x3(:,:,24))
  call Hcheck_last_A_Q(ntry,l_switch,G1H1(1),12,0,G2tensor(28),n2h1(24))
call Hotf_5pt_reduction_last(G2tensor(1),RedSet_5(1),mass5set(:,1),  & 
G1tensor(1),G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(5),G1tensor(6))
call G_TensorShift(G1tensor(2),2)
call Hotf_5pt_reduction_last(G2tensor(3),RedSet_5(2),mass5set(:,1),  & 
G1tensor(7),G1tensor(8),G1tensor(9),G1tensor(10),G1tensor(11),G1tensor(12))
call G_TensorShift(G1tensor(8),2)
call Hotf_5pt_reduction_last(G2tensor(5),RedSet_5(3),mass5set(:,1),  & 
G1tensor(13),G1tensor(14),G1tensor(15),G1tensor(16),G1tensor(17),G1tensor(18))
call G_TensorShift(G1tensor(14),8)
call Hotf_5pt_reduction_last(G2tensor(9),RedSet_5(4),mass5set(:,1),  & 
G1tensor(19),G1tensor(20),G1tensor(21),G1tensor(22),G1tensor(23),G1tensor(24))
call G_TensorShift(G1tensor(20),8)
call Hotf_5pt_reduction_last(G2tensor(13),RedSet_5(5),mass5set(:,1),  & 
G1tensor(25),G1tensor(26),G1tensor(27),G1tensor(28),G1tensor(29),G1tensor(30))
call G_TensorShift(G1tensor(26),8)
call Hotf_5pt_reduction_last(G2tensor(17),RedSet_5(6),mass5set(:,1),  & 
G1tensor(31),G1tensor(32),G1tensor(33),G1tensor(34),G1tensor(35),G1tensor(36))
call G_TensorShift(G1tensor(32),4)
call Hotf_5pt_reduction_last(G2tensor(21),RedSet_5(7),mass5set(:,1),  & 
G1tensor(37),G1tensor(38),G1tensor(39),G1tensor(40),G1tensor(41),G1tensor(42))
call G_TensorShift(G1tensor(38),8)
call Hotf_5pt_reduction_last(G2tensor(25),RedSet_5(8),mass5set(:,1),  & 
G1tensor(43),G1tensor(44),G1tensor(45),G1tensor(46),G1tensor(47),G1tensor(48))
call G_TensorShift(G1tensor(44),4)
call ol_merge_tensors(T1sum(1),[G1tensor(1)])
call ol_merge_tensors(T1sum(2),[G1tensor(7)])
call ol_merge_tensors(T1sum(3),[G1tensor(13)])
call ol_merge_tensors(T1sum(4),[G1tensor(19)])
call ol_merge_tensors(T1sum(5),[G1tensor(25)])
call ol_merge_tensors(T1sum(6),[G1tensor(31)])
call ol_merge_tensors(T1sum(7),[G1tensor(37)])
call ol_merge_tensors(T1sum(8),[G1tensor(43)])
Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(13)
call G0_hol_initialisation(ntry,Gcoeff,G0H72(1),m0h(9),h0tab(:,9),[16,3,8,4],[0,0,0,0],4,1,wf4(:,5))
  call Hloop_QV_A(ntry,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,9),heltab2x72(:,:,9))
  call Hloop_Q_A(ntry,G0H36(1),16,0,G1H36(1),n2h36(7))
Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(13)
call G0_hol_initialisation(ntry,Gcoeff,G0H72(1),m0h(10),h0tab(:,10),[16,3,8,4],[nMT,nMT,nMT,nMT],4,1,wf4(:,5))
  call Hloop_QV_A(ntry,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,10),heltab2x72(:,:,10))
  call Hloop_Q_A(ntry,G0H36(1),16,nMT,G1H36(2),n2h36(8))
Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(13)
call G0_hol_initialisation(ntry,Gcoeff,G0H72(1),m0h(11),h0tab(:,11),[16,3,8,4],[0,0,0,0],4,1,wf4(:,5))
  call Hloop_AV_Q(ntry,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,11),heltab2x72(:,:,11))
  call Hloop_A_Q(ntry,G0H36(1),16,0,G1H36(3),n2h36(9))
Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(13)
call G0_hol_initialisation(ntry,Gcoeff,G0H72(1),m0h(12),h0tab(:,12),[16,3,8,4],[nMT,nMT,nMT,nMT],4,1,wf4(:,5))
  call Hloop_AV_Q(ntry,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,12),heltab2x72(:,:,12))
  call Hloop_A_Q(ntry,G0H36(1),16,nMT,G1H36(4),n2h36(10))
Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(13)
call G0_hol_initialisation(ntry,Gcoeff,G0H72(1),m0h(13),h0tab(:,13),[16,3,8,4],[0,0,0,0],4,1,wf4(:,5))
  call Hloop_QV_A(ntry,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,13),heltab2x72(:,:,13))
  call Hloop_Q_A(ntry,G0H36(1),16,0,G1H36(5),n2h36(11))
Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(13)
call G0_hol_initialisation(ntry,Gcoeff,G0H72(1),m0h(14),h0tab(:,14),[16,3,8,4],[nMB,nMB,nMB,nMB],4,1,wf4(:,5))
  call Hloop_QV_A(ntry,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,14),heltab2x72(:,:,14))
  call Hloop_Q_A(ntry,G0H36(1),16,nMB,G1H36(6),n2h36(12))
Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(13)
call G0_hol_initialisation(ntry,Gcoeff,G0H72(1),m0h(15),h0tab(:,15),[16,3,8,4],[0,0,0,0],4,1,wf4(:,5))
  call Hloop_AV_Q(ntry,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,15),heltab2x72(:,:,15))
  call Hloop_A_Q(ntry,G0H36(1),16,0,G1H36(7),n2h36(13))
Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(13)
call G0_hol_initialisation(ntry,Gcoeff,G0H72(1),m0h(16),h0tab(:,16),[16,3,8,4],[nMB,nMB,nMB,nMB],4,1,wf4(:,5))
  call Hloop_AV_Q(ntry,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,16),heltab2x72(:,:,16))
  call Hloop_A_Q(ntry,G0H36(1),16,nMB,G1H36(8),n2h36(14))
Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(13)
call G0_hol_initialisation(ntry,Gcoeff,G0H72(1),m0h(17),h0tab(:,17),[16,3,4,8],[0,0,0,0],4,1,wf4(:,5))
  call Hloop_AV_Q(ntry,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,17),heltab2x72(:,:,17))
  call Hloop_A_Q(ntry,G0H36(1),16,0,G1H36(9),n2h36(15))
Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(13)
call G0_hol_initialisation(ntry,Gcoeff,G0H72(1),m0h(18),h0tab(:,18),[16,3,4,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,5))
  call Hloop_AV_Q(ntry,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,18),heltab2x72(:,:,18))
  call Hloop_A_Q(ntry,G0H36(1),16,nMT,G1H36(10),n2h36(16))
Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(13)
call G0_hol_initialisation(ntry,Gcoeff,G0H72(1),m0h(19),h0tab(:,19),[16,3,4,8],[0,0,0,0],4,1,wf4(:,5))
  call Hloop_QV_A(ntry,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,19),heltab2x72(:,:,19))
  call Hloop_Q_A(ntry,G0H36(1),16,0,G1H36(11),n2h36(17))
Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(13)
call G0_hol_initialisation(ntry,Gcoeff,G0H72(1),m0h(20),h0tab(:,20),[16,3,4,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,5))
  call Hloop_QV_A(ntry,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,20),heltab2x72(:,:,20))
  call Hloop_Q_A(ntry,G0H36(1),16,nMT,G1H36(12),n2h36(18))
Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(13)
call G0_hol_initialisation(ntry,Gcoeff,G0H72(1),m0h(21),h0tab(:,21),[16,3,4,8],[0,0,0,0],4,1,wf4(:,5))
  call Hloop_AV_Q(ntry,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,21),heltab2x72(:,:,21))
  call Hloop_A_Q(ntry,G0H36(1),16,0,G1H36(13),n2h36(19))
Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(13)
call G0_hol_initialisation(ntry,Gcoeff,G0H72(1),m0h(22),h0tab(:,22),[16,3,4,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,5))
  call Hloop_AV_Q(ntry,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,22),heltab2x72(:,:,22))
  call Hloop_A_Q(ntry,G0H36(1),16,nMB,G1H36(14),n2h36(20))
Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(13)
call G0_hol_initialisation(ntry,Gcoeff,G0H72(1),m0h(23),h0tab(:,23),[16,3,4,8],[0,0,0,0],4,1,wf4(:,5))
  call Hloop_QV_A(ntry,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,23),heltab2x72(:,:,23))
  call Hloop_Q_A(ntry,G0H36(1),16,0,G1H36(15),n2h36(21))
Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(13)
call G0_hol_initialisation(ntry,Gcoeff,G0H72(1),m0h(24),h0tab(:,24),[16,3,4,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,5))
  call Hloop_QV_A(ntry,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,24),heltab2x72(:,:,24))
  call Hloop_Q_A(ntry,G0H36(1),16,nMB,G1H36(16),n2h36(22))
Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(13)
call G0_hol_initialisation(ntry,Gcoeff,G0H72(1),m0h(25),h0tab(:,25),[16,4,3,8],[0,0,0,0],4,1,wf4(:,5))
  call Hloop_QV_A(ntry,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,25),heltab2x72(:,:,25))
  call Hloop_Q_A(ntry,G0H36(1),16,0,G1H36(17),n2h36(23))
Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(13)
call G0_hol_initialisation(ntry,Gcoeff,G0H72(1),m0h(26),h0tab(:,26),[16,4,3,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,5))
  call Hloop_QV_A(ntry,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,26),heltab2x72(:,:,26))
  call Hloop_Q_A(ntry,G0H36(1),16,nMT,G1H36(18),n2h36(24))
Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(13)
call G0_hol_initialisation(ntry,Gcoeff,G0H72(1),m0h(27),h0tab(:,27),[16,4,3,8],[0,0,0,0],4,1,wf4(:,5))
  call Hloop_AV_Q(ntry,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,27),heltab2x72(:,:,27))
  call Hloop_A_Q(ntry,G0H36(1),16,0,G1H36(19),n2h36(25))
Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(13)
call G0_hol_initialisation(ntry,Gcoeff,G0H72(1),m0h(28),h0tab(:,28),[16,4,3,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,5))
  call Hloop_AV_Q(ntry,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,28),heltab2x72(:,:,28))
  call Hloop_A_Q(ntry,G0H36(1),16,nMT,G1H36(20),n2h36(26))
Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(13)
call G0_hol_initialisation(ntry,Gcoeff,G0H72(1),m0h(29),h0tab(:,29),[16,4,3,8],[0,0,0,0],4,1,wf4(:,5))
  call Hloop_QV_A(ntry,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,29),heltab2x72(:,:,29))
  call Hloop_Q_A(ntry,G0H36(1),16,0,G1H36(21),n2h36(27))
Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(13)
call G0_hol_initialisation(ntry,Gcoeff,G0H72(1),m0h(30),h0tab(:,30),[16,4,3,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,5))
  call Hloop_QV_A(ntry,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,30),heltab2x72(:,:,30))
  call Hloop_Q_A(ntry,G0H36(1),16,nMB,G1H36(22),n2h36(28))
Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(13)
call G0_hol_initialisation(ntry,Gcoeff,G0H72(1),m0h(31),h0tab(:,31),[16,4,3,8],[0,0,0,0],4,1,wf4(:,5))
  call Hloop_AV_Q(ntry,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,31),heltab2x72(:,:,31))
  call Hloop_A_Q(ntry,G0H36(1),16,0,G1H36(23),n2h36(29))
Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(13)
call G0_hol_initialisation(ntry,Gcoeff,G0H72(1),m0h(32),h0tab(:,32),[16,4,3,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,5))
  call Hloop_AV_Q(ntry,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,32),heltab2x72(:,:,32))
  call Hloop_A_Q(ntry,G0H36(1),16,nMB,G1H36(24),n2h36(30))
Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(1)
call G0_hol_initialisation(ntry,Gcoeff,G0H72(1),m0h(33),h0tab(:,33),[16,2,8,5],[0,0,0,0],4,1,wf6(:,3))
  call Hloop_UV_W(ntry,G0H72(1),0,ex5(:),16,G1H36(25),m3h2x36(:,33),heltab2x72(:,:,33))
Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(1)
call G0_hol_initialisation(ntry,Gcoeff,G0H72(1),m0h(34),h0tab(:,34),[16,5,2,8],[0,0,0,0],4,1,wf6(:,3))
  call Hloop_AV_Q(ntry,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,34),heltab2x72(:,:,34))
  call Hloop_A_Q(ntry,G0H36(1),16,0,G1H36(26),n2h36(31))
Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(1)
call G0_hol_initialisation(ntry,Gcoeff,G0H72(1),m0h(35),h0tab(:,35),[16,2,5,8],[0,0,0,0],4,1,wf6(:,3))
  call Hloop_QV_A(ntry,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,35),heltab2x72(:,:,35))
  call Hloop_Q_A(ntry,G0H36(1),16,0,G1H36(27),n2h36(32))
Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(7)
call G0_hol_initialisation(ntry,Gcoeff,G0H72(1),m0h(36),h0tab(:,36),[16,1,8,6],[0,0,0,0],4,1,wf6(:,8))
  call Hloop_UV_W(ntry,G0H72(1),0,ex5(:),16,G1H36(28),m3h2x36(:,36),heltab2x72(:,:,36))
Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(7)
call G0_hol_initialisation(ntry,Gcoeff,G0H72(1),m0h(37),h0tab(:,37),[16,6,1,8],[0,0,0,0],4,1,wf6(:,8))
  call Hloop_QV_A(ntry,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,37),heltab2x72(:,:,37))
  call Hloop_Q_A(ntry,G0H36(1),16,0,G1H36(29),n2h36(33))
Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(7)
call G0_hol_initialisation(ntry,Gcoeff,G0H72(1),m0h(38),h0tab(:,38),[16,1,6,8],[0,0,0,0],4,1,wf6(:,8))
  call Hloop_AV_Q(ntry,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,38),heltab2x72(:,:,38))
  call Hloop_A_Q(ntry,G0H36(1),16,0,G1H36(30),n2h36(34))
Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(6)
call G0_hol_initialisation(ntry,Gcoeff,G0H72(1),m0h(39),h0tab(:,39),[16,2,4,9],[0,0,0,0],4,1,wf6(:,7))
  call Hloop_UV_W(ntry,G0H72(1),0,ex5(:),16,G1H36(31),m3h2x36(:,39),heltab2x72(:,:,39))
Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(6)
call G0_hol_initialisation(ntry,Gcoeff,G0H72(1),m0h(40),h0tab(:,40),[16,4,2,9],[0,0,0,0],4,1,wf6(:,7))
  call Hloop_QV_A(ntry,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,40),heltab2x72(:,:,40))
  call Hloop_Q_A(ntry,G0H36(1),16,0,G1H36(32),n2h36(35))
Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(6)
call G0_hol_initialisation(ntry,Gcoeff,G0H72(1),m0h(41),h0tab(:,41),[16,2,9,4],[0,0,0,0],4,1,wf6(:,7))
  call Hloop_QV_A(ntry,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,41),heltab2x72(:,:,41))
  call Hloop_Q_A(ntry,G0H36(1),16,0,G1H36(33),n2h36(36))
Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(2)
call G0_hol_initialisation(ntry,Gcoeff,G0H72(1),m0h(42),h0tab(:,42),[16,1,4,10],[0,0,0,0],4,1,wf6(:,4))
  call Hloop_UV_W(ntry,G0H72(1),0,ex5(:),16,G1H36(34),m3h2x36(:,42),heltab2x72(:,:,42))
Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(2)
call G0_hol_initialisation(ntry,Gcoeff,G0H72(1),m0h(43),h0tab(:,43),[16,4,1,10],[0,0,0,0],4,1,wf6(:,4))
  call Hloop_AV_Q(ntry,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,43),heltab2x72(:,:,43))
  call Hloop_A_Q(ntry,G0H36(1),16,0,G1H36(35),n2h36(37))
Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(2)
call G0_hol_initialisation(ntry,Gcoeff,G0H72(1),m0h(44),h0tab(:,44),[16,1,10,4],[0,0,0,0],4,1,wf6(:,4))
  call Hloop_AV_Q(ntry,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,44),heltab2x72(:,:,44))
  call Hloop_A_Q(ntry,G0H36(1),16,0,G1H36(36),n2h36(38))
Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(9)
call G0_hol_initialisation(ntry,Gcoeff,G0H72(1),m0h(45),h0tab(:,45),[17,2,4,8],[0,0,0,0],4,1,wf4(:,4))
  call Hloop_AQ_V(ntry,G0H72(1),wf4(:,4),G0H18(1),m3h4x18(:,1),heltab2x72(:,:,45))
Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(9)
call G0_hol_initialisation(ntry,Gcoeff,G0H72(1),m0h(46),h0tab(:,46),[17,2,8,4],[0,0,0,0],4,1,wf4(:,4))
  call Hloop_AQ_V(ntry,G0H72(1),wf4(:,4),G0H18(2),m3h4x18(:,2),heltab2x72(:,:,46))
Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(4)
call G0_hol_initialisation(ntry,Gcoeff,G0H72(1),m0h(47),h0tab(:,47),[18,1,4,8],[0,0,0,0],4,1,wf4(:,2))
  call Hloop_QA_V(ntry,G0H72(1),wf4(:,2),G0H18(3),m3h4x18(:,3),heltab2x72(:,:,47))
Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(4)
call G0_hol_initialisation(ntry,Gcoeff,G0H72(1),m0h(48),h0tab(:,48),[18,1,8,4],[0,0,0,0],4,1,wf4(:,2))
  call Hloop_QA_V(ntry,G0H72(1),wf4(:,2),G0H18(4),m3h4x18(:,4),heltab2x72(:,:,48))
  call Hloop_QZ_A(ntry,G1H18(2),ex3(:),G1H6(17),ngZd,m3h3x6(:,9),heltab2x18(:,:,15))
  call Hloop_Q_A(ntry,G1H6(17),21,0,G2H6(3),n2h6(17))
  call Hloop_QZ_A(ntry,G1H18(9),ex4(:),G1H6(18),ngZd,m3h3x6(:,10),heltab2x18(:,:,16))
  call Hloop_Q_A(ntry,G1H6(18),25,0,G2H6(5),n2h6(18))
  call Hloop_QV_A(ntry,G1H36(1),wf4(:,5),G1H9(3),m3h4x9(:,1),heltab2x36(:,:,9))
  call Hloop_Q_A(ntry,G1H9(3),19,0,G2H9(1),n2h9(9))
  call Hloop_QV_A(ntry,G1H36(2),wf4(:,5),G1H9(4),m3h4x9(:,2),heltab2x36(:,:,10))
  call Hloop_Q_A(ntry,G1H9(4),19,nMT,G2H9(2),n2h9(10))
  call Hloop_AV_Q(ntry,G1H36(3),wf4(:,5),G1H9(7),m3h4x9(:,3),heltab2x36(:,:,11))
  call Hloop_A_Q(ntry,G1H9(7),19,0,G2H9(3),n2h9(11))
  call Hloop_AV_Q(ntry,G1H36(4),wf4(:,5),G1H9(8),m3h4x9(:,4),heltab2x36(:,:,12))
  call Hloop_A_Q(ntry,G1H9(8),19,nMT,G2H9(4),n2h9(12))
  call Hloop_QV_A(ntry,G1H36(5),wf4(:,5),G1H9(9),m3h4x9(:,5),heltab2x36(:,:,13))
  call Hloop_Q_A(ntry,G1H9(9),19,0,G2H9(5),n2h9(13))
  call Hloop_QV_A(ntry,G1H36(6),wf4(:,5),G1H9(10),m3h4x9(:,6),heltab2x36(:,:,14))
  call Hloop_Q_A(ntry,G1H9(10),19,nMB,G2H9(6),n2h9(14))
  call Hloop_AV_Q(ntry,G1H36(7),wf4(:,5),G1H9(13),m3h4x9(:,7),heltab2x36(:,:,15))
  call Hloop_A_Q(ntry,G1H9(13),19,0,G2H9(7),n2h9(15))
  call Hloop_AV_Q(ntry,G1H36(8),wf4(:,5),G1H9(14),m3h4x9(:,8),heltab2x36(:,:,16))
  call Hloop_A_Q(ntry,G1H9(14),19,nMB,G2H9(8),n2h9(16))
  call Hloop_AV_Q(ntry,G1H36(9),wf4(:,5),G1H9(15),m3h4x9(:,9),heltab2x36(:,:,17))
  call Hloop_A_Q(ntry,G1H9(15),19,0,G2H9(9),n2h9(17))
  call Hloop_AV_Q(ntry,G1H36(10),wf4(:,5),G1H9(16),m3h4x9(:,10),heltab2x36(:,:,18))
  call Hloop_A_Q(ntry,G1H9(16),19,nMT,G2H9(10),n2h9(18))
  call Hloop_QV_A(ntry,G1H36(11),wf4(:,5),G1H9(19),m3h4x9(:,11),heltab2x36(:,:,19))
  call Hloop_Q_A(ntry,G1H9(19),19,0,G2H9(11),n2h9(19))
  call Hloop_QV_A(ntry,G1H36(12),wf4(:,5),G1H9(20),m3h4x9(:,12),heltab2x36(:,:,20))
  call Hloop_Q_A(ntry,G1H9(20),19,nMT,G2H9(12),n2h9(20))
  call Hloop_AV_Q(ntry,G1H36(13),wf4(:,5),G1H9(21),m3h4x9(:,13),heltab2x36(:,:,21))
  call Hloop_A_Q(ntry,G1H9(21),19,0,G2H9(13),n2h9(21))
  call Hloop_AV_Q(ntry,G1H36(14),wf4(:,5),G1H9(22),m3h4x9(:,14),heltab2x36(:,:,22))
  call Hloop_A_Q(ntry,G1H9(22),19,nMB,G2H9(14),n2h9(22))
  call Hloop_QV_A(ntry,G1H36(15),wf4(:,5),G1H9(25),m3h4x9(:,15),heltab2x36(:,:,23))
  call Hloop_Q_A(ntry,G1H9(25),19,0,G2H9(15),n2h9(23))
  call Hloop_QV_A(ntry,G1H36(16),wf4(:,5),G1H9(26),m3h4x9(:,16),heltab2x36(:,:,24))
  call Hloop_Q_A(ntry,G1H9(26),19,nMB,G2H9(16),n2h9(24))
  call Hloop_QZ_A(ntry,G1H36(17),ex3(:),G1H12(1),ngZu,m3h3x12(:,3),heltab2x36(:,:,25))
  call Hloop_Q_A(ntry,G1H12(1),20,0,G2H12(1),n2h12(3))
  call Hloop_QZ_A(ntry,G1H36(18),ex3(:),G1H12(1),ngZu,m3h3x12(:,4),heltab2x36(:,:,26))
  call Hloop_Q_A(ntry,G1H12(1),20,nMT,G2H12(2),n2h12(4))
  call Hloop_AZ_Q(ntry,G1H36(19),ex3(:),G1H12(1),ngZu,m3h3x12(:,5),heltab2x36(:,:,27))
  call Hloop_A_Q(ntry,G1H12(1),20,0,G2H12(3),n2h12(5))
  call Hloop_AZ_Q(ntry,G1H36(20),ex3(:),G1H12(1),ngZu,m3h3x12(:,6),heltab2x36(:,:,28))
  call Hloop_A_Q(ntry,G1H12(1),20,nMT,G2H12(4),n2h12(6))
  call Hloop_QZ_A(ntry,G1H36(21),ex3(:),G1H12(1),ngZd,m3h3x12(:,7),heltab2x36(:,:,29))
  call Hloop_Q_A(ntry,G1H12(1),20,0,G2H12(5),n2h12(7))
  call Hloop_QZ_A(ntry,G1H36(22),ex3(:),G1H12(1),ngZd,m3h3x12(:,8),heltab2x36(:,:,30))
  call Hloop_Q_A(ntry,G1H12(1),20,nMB,G2H12(6),n2h12(8))
  call Hloop_AZ_Q(ntry,G1H36(23),ex3(:),G1H12(1),ngZd,m3h3x12(:,9),heltab2x36(:,:,31))
  call Hloop_A_Q(ntry,G1H12(1),20,0,G2H12(7),n2h12(9))
  call Hloop_AZ_Q(ntry,G1H36(24),ex3(:),G1H12(1),ngZd,m3h3x12(:,10),heltab2x36(:,:,32))
  call Hloop_A_Q(ntry,G1H12(1),20,nMB,G2H12(8),n2h12(10))
  call Hloop_VA_Q(ntry,G1H36(25),ex2(:),G1H18(5),m3h2x18(:,7),heltab2x36(:,:,33))
  call Hloop_A_Q(ntry,G1H18(5),18,0,G2H18(1),n2h18(5))
  call Hloop_AQ_V(ntry,G1H36(26),wf6(:,3),G1H6(33),m3h6x6(:,1),heltab2x36(:,:,34))
  call Hloop_QA_V(ntry,G1H36(27),ex2(:),G1H18(1),m3h2x18(:,8),heltab2x36(:,:,35))
  call Hloop_VQ_A(ntry,G1H36(28),ex1(:),G1H18(3),m3h2x18(:,9),heltab2x36(:,:,36))
  call Hloop_Q_A(ntry,G1H18(3),17,0,G2H18(2),n2h18(6))
  call Hloop_QA_V(ntry,G1H36(29),wf6(:,8),G1H6(34),m3h6x6(:,2),heltab2x36(:,:,37))
  call Hloop_AQ_V(ntry,G1H36(30),ex1(:),G1H18(4),m3h2x18(:,10),heltab2x36(:,:,38))
  call Hloop_VA_Q(ntry,G1H36(31),ex2(:),G1H18(6),m3h2x18(:,11),heltab2x36(:,:,39))
  call Hloop_A_Q(ntry,G1H18(6),18,0,G2H18(3),n2h18(7))
  call Hloop_QZ_A(ntry,G1H36(32),ex3(:),G1H12(1),ngZd,m3h3x12(:,11),heltab2x36(:,:,40))
  call Hloop_Q_A(ntry,G1H12(1),20,0,G2H12(9),n2h12(11))
  call Hloop_QA_V(ntry,G1H36(33),ex2(:),G1H18(7),m3h2x18(:,12),heltab2x36(:,:,41))
  call Hloop_VQ_A(ntry,G1H36(34),ex1(:),G1H18(8),m3h2x18(:,13),heltab2x36(:,:,42))
  call Hloop_Q_A(ntry,G1H18(8),17,0,G2H18(4),n2h18(8))
  call Hloop_AZ_Q(ntry,G1H36(35),ex3(:),G1H12(1),ngZd,m3h3x12(:,12),heltab2x36(:,:,43))
  call Hloop_A_Q(ntry,G1H12(1),20,0,G2H12(10),n2h12(12))
  call Hloop_AQ_V(ntry,G1H36(36),ex1(:),G1H18(10),m3h2x18(:,14),heltab2x36(:,:,44))
  call Hloop_VA_Q(ntry,G0H18(1),ex2(:),G0H9(1),m3h2x9(:,7),heltab2x18(:,:,17))
  call Hloop_A_Q(ntry,G0H9(1),19,0,G1H9(3),n2h9(25))
  call Hloop_VA_Q(ntry,G0H18(2),ex2(:),G0H9(1),m3h2x9(:,8),heltab2x18(:,:,18))
  call Hloop_A_Q(ntry,G0H9(1),19,0,G1H9(4),n2h9(26))
  call Hloop_VQ_A(ntry,G0H18(3),ex1(:),G0H9(1),m3h2x9(:,9),heltab2x18(:,:,19))
  call Hloop_Q_A(ntry,G0H9(1),19,0,G1H9(7),n2h9(27))
  call Hloop_VQ_A(ntry,G0H18(4),ex1(:),G0H9(1),m3h2x9(:,10),heltab2x18(:,:,20))
  call Hloop_Q_A(ntry,G0H9(1),19,0,G1H9(8),n2h9(28))
  call ol_merge(ntry,G1H9(7),[G1H9(5)])
call HGT_w2_OLR(G1H9(1),1,1,9)
call HGT_w2_invQ_OLR(G1H9(1),2,5,9)
  call ol_merge(ntry,G1H9(1),[G1H9(7)])
  call ol_merge(ntry,G2H6(4),[G1H6(16)])
  call ol_merge(ntry,G1H9(8),[G1H9(11)])
call HGT_w2_OLR(G1H9(2),1,1,9)
call HGT_w2_invQ_OLR(G1H9(2),2,5,9)
  call ol_merge(ntry,G1H9(2),[G1H9(8)])
  call ol_merge(ntry,G2H6(8),[G1H6(32)])
  call ol_merge(ntry,G1H6(33),[G1H6(4)])
  call ol_merge(ntry,G2H9(15),[G1H9(6)])
  call ol_merge(ntry,G1H6(34),[G1H6(10)])
  call ol_merge(ntry,G2H9(5),[G1H9(12)])
  call ol_merge(ntry,G1H9(3),[G1H9(17)])
  call ol_merge(ntry,G2H9(13),[G1H9(18)])
  call ol_merge(ntry,G1H9(4),[G1H9(23)])
  call ol_merge(ntry,G2H9(7),[G1H9(24)])
  call ol_merge(ntry,G2H6(3),[G1H6(15)])
  call ol_merge(ntry,G2H6(5),[G1H6(31)])
  call Hloop_QZ_A(ntry,G1H9(1),ex3(:),G1H3(12),ngZd,m3h3x3(:,17),heltab2x9(:,:,17))
  call Hloop_Q_A(ntry,G1H3(12),23,0,G2H3(1),n2h3(19))
call Hotf_4pt_reduction(G2H6(4),RedSet_4(9),mass4set(:,1),  & 
G1H6(1),G1H6(2),G1H6(5),G1H6(6),G1H6(7),6)
call HG1shiftOLR(G1H6(2),2,6)
  call Hloop_QZ_A(ntry,G1H9(2),ex4(:),G1H3(23),ngZd,m3h3x3(:,18),heltab2x9(:,:,18))
  call Hloop_Q_A(ntry,G1H3(23),27,0,G2H3(3),n2h3(20))
call Hotf_4pt_reduction(G2H6(8),RedSet_4(12),mass4set(:,1),  & 
G1H6(8),G1H6(11),G1H6(12),G1H6(13),G1H6(14),6)
call HG1shiftOLR(G1H6(11),2,6)
  call Hloop_VA_Q(ntry,G1H6(3),ex2(:),G1H3(34),m3h2x3(:,13),heltab2x6(:,:,25))
  call Hloop_A_Q(ntry,G1H3(34),23,0,G2H3(4),n2h3(21))
  call Hloop_VA_Q(ntry,G1H6(33),ex2(:),G1H3(45),m3h2x3(:,14),heltab2x6(:,:,26))
  call Hloop_A_Q(ntry,G1H3(45),23,0,G2H3(7),n2h3(22))
call Hotf_4pt_reduction(G2H9(15),RedSet_4(19),mass4set(:,1),  & 
G1H9(9),G1H9(10),G1H9(13),G1H9(14),G1H9(15),G0H9(1),9)
call HG1shiftOLR(G1H9(10),8,9)
  call Hloop_VQ_A(ntry,G1H6(9),ex1(:),G1H3(56),m3h2x3(:,15),heltab2x6(:,:,27))
  call Hloop_Q_A(ntry,G1H3(56),23,0,G2H3(8),n2h3(23))
  call Hloop_VQ_A(ntry,G1H6(34),ex1(:),G1H3(67),m3h2x3(:,16),heltab2x6(:,:,28))
  call Hloop_Q_A(ntry,G1H3(67),23,0,G2H3(10),n2h3(24))
call Hotf_4pt_reduction(G2H9(5),RedSet_4(26),mass4set(:,1),  & 
G1H9(16),G1H9(19),G1H9(20),G1H9(21),G1H9(22),G0H9(2),9)
call HG1shiftOLR(G1H9(19),4,9)
  call Hloop_AZ_Q(ntry,G1H9(3),ex3(:),G1H3(7),ngZd,m3h3x3(:,19),heltab2x9(:,:,19))
  call Hloop_A_Q(ntry,G1H3(7),23,0,G2H3(11),n2h3(25))
call Hotf_4pt_reduction(G2H9(13),RedSet_4(19),mass4set(:,1),  & 
G1H9(25),G1H9(26),G1H9(5),G1H9(7),G1H9(11),G0H9(3),9)
call HG1shiftOLR(G1H9(26),8,9)
  call Hloop_AZ_Q(ntry,G1H9(4),ex4(:),G1H3(8),ngZd,m3h3x3(:,20),heltab2x9(:,:,20))
  call Hloop_A_Q(ntry,G1H3(8),27,0,G2H3(14),n2h3(26))
call Hotf_4pt_reduction(G2H9(7),RedSet_4(26),mass4set(:,1),  & 
G1H9(8),G1H9(6),G1H9(12),G1H9(17),G1H9(18),G0H9(4),9)
call HG1shiftOLR(G1H9(6),4,9)
call Hotf_4pt_reduction(G2H6(3),RedSet_4(8),mass4set(:,1),  & 
G1H6(19),G1H6(24),G1H6(20),G1H6(23),G1H6(25),6)
call HG1shiftOLR(G1H6(24),2,6)
  call Hloop_QZ_A(ntry,G1H6(21),ex4(:),G1H2(1),ngZd,m3h3x2(:,13),heltab2x6(:,:,29))
  call Hloop_Q_A(ntry,G1H2(1),29,0,G2H2(3),n2h2(11))
  call Hloop_QZ_A(ntry,G1H6(22),ex4(:),G1H2(1),ngZd,m3h3x2(:,14),heltab2x6(:,:,30))
  call Hloop_Q_A(ntry,G1H2(1),29,0,G2H2(5),n2h2(12))
  call Hloop_QZ_A(ntry,G1H6(26),ex4(:),G1H2(1),ngZd,m3h3x2(:,15),heltab2x6(:,:,31))
  call Hloop_Q_A(ntry,G1H2(1),29,0,G2H2(8),n2h2(13))
  call Hloop_QZ_A(ntry,G1H6(27),ex4(:),G1H2(1),ngZd,m3h3x2(:,16),heltab2x6(:,:,32))
  call Hloop_Q_A(ntry,G1H2(1),29,0,G2H2(10),n2h2(14))
call Hotf_4pt_reduction(G2H6(5),RedSet_4(11),mass4set(:,1),  & 
G1H6(28),G1H6(29),G1H6(30),G1H6(35),G1H6(40),6)
call HG1shiftOLR(G1H6(29),2,6)
  call Hloop_QZ_A(ntry,G1H6(37),ex3(:),G1H2(1),ngZd,m3h3x2(:,17),heltab2x6(:,:,33))
  call Hloop_Q_A(ntry,G1H2(1),29,0,G2H2(13),n2h2(15))
  call Hloop_QZ_A(ntry,G1H6(38),ex3(:),G1H2(1),ngZd,m3h3x2(:,18),heltab2x6(:,:,34))
  call Hloop_Q_A(ntry,G1H2(1),29,0,G2H2(14),n2h2(16))
  call Hloop_QZ_A(ntry,G1H6(42),ex3(:),G1H2(1),ngZd,m3h3x2(:,19),heltab2x6(:,:,35))
  call Hloop_Q_A(ntry,G1H2(1),29,0,G2H2(15),n2h2(17))
  call Hloop_QZ_A(ntry,G1H6(43),ex3(:),G1H2(1),ngZd,m3h3x2(:,20),heltab2x6(:,:,36))
  call Hloop_Q_A(ntry,G1H2(1),29,0,G2H2(16),n2h2(18))
call Hotf_4pt_reduction(G2H9(1),RedSet_4(26),mass4set(:,1),  & 
G1H9(23),G1H9(24),G1H9(1),G1H9(2),G1H9(3),G0H9(5),9)
call HG1shiftOLR(G1H9(24),4,9)
call Hotf_4pt_reduction(G2H9(2),RedSet_4(26),mass4set(:,2),  & 
G1H9(4),G1H9(27),G1H9(28),G1H9(29),G1H9(30),G0H9(6),9)
call HG1shiftOLR(G1H9(27),4,9)
call Hotf_4pt_reduction(G2H9(3),RedSet_4(26),mass4set(:,1),  & 
G1H9(31),G1H9(32),G1H9(33),G1H9(34),G1H9(35),G0H9(7),9)
call HG1shiftOLR(G1H9(32),4,9)
call Hotf_4pt_reduction(G2H9(4),RedSet_4(26),mass4set(:,2),  & 
G1H9(36),G1H9(37),G1H9(38),G1H9(39),G1H9(40),G0H9(8),9)
call HG1shiftOLR(G1H9(37),4,9)
call Hotf_4pt_reduction(G2H9(6),RedSet_4(26),mass4set(:,3),  & 
G1H9(41),G1H9(42),G1H9(43),G1H9(44),G1H9(45),G0H9(9),9)
call HG1shiftOLR(G1H9(42),4,9)
call Hotf_4pt_reduction(G2H9(8),RedSet_4(26),mass4set(:,3),  & 
G1H9(46),G1H9(47),G1H9(48),G1H9(49),G1H9(50),G0H9(10),9)
call HG1shiftOLR(G1H9(47),4,9)
call Hotf_4pt_reduction(G2H9(9),RedSet_4(19),mass4set(:,1),  & 
G1H9(51),G1H9(52),G1H9(53),G1H9(54),G1H9(55),G0H9(11),9)
call HG1shiftOLR(G1H9(52),8,9)
call Hotf_4pt_reduction(G2H9(10),RedSet_4(19),mass4set(:,2),  & 
G1H9(56),G1H9(57),G1H9(58),G1H9(59),G1H9(60),G0H9(12),9)
call HG1shiftOLR(G1H9(57),8,9)
call Hotf_4pt_reduction(G2H9(11),RedSet_4(19),mass4set(:,1),  & 
G1H9(61),G1H9(62),G1H9(63),G1H9(64),G1H9(65),G0H9(13),9)
call HG1shiftOLR(G1H9(62),8,9)
call Hotf_4pt_reduction(G2H9(12),RedSet_4(19),mass4set(:,2),  & 
G1H9(66),G1H9(67),G1H9(68),G1H9(69),G1H9(70),G0H9(14),9)
call HG1shiftOLR(G1H9(67),8,9)
call Hotf_4pt_reduction(G2H9(14),RedSet_4(19),mass4set(:,3),  & 
G1H9(71),G1H9(72),G1H9(73),G1H9(74),G1H9(75),G0H9(15),9)
call HG1shiftOLR(G1H9(72),8,9)
call Hotf_4pt_reduction(G2H9(16),RedSet_4(19),mass4set(:,3),  & 
G1H9(76),G1H9(77),G1H9(78),G1H9(79),G1H9(80),G0H9(16),9)
call HG1shiftOLR(G1H9(77),8,9)
call Hotf_4pt_reduction(G2H12(1),RedSet_4(16),mass4set(:,1),  & 
G1H12(1),G1H12(2),G1H12(3),G1H12(4),G1H12(5),G0H12(1),12)
call HG1shiftOLR(G1H12(2),8,12)
call Hotf_4pt_reduction(G2H12(2),RedSet_4(16),mass4set(:,2),  & 
G1H12(6),G1H12(7),G1H12(8),G1H12(9),G1H12(10),G0H12(2),12)
call HG1shiftOLR(G1H12(7),8,12)
call Hotf_4pt_reduction(G2H12(3),RedSet_4(16),mass4set(:,1),  & 
G1H12(11),G1H12(12),G1H12(13),G1H12(14),G1H12(15),G0H12(3),12)
call HG1shiftOLR(G1H12(12),8,12)
call Hotf_4pt_reduction(G2H12(4),RedSet_4(16),mass4set(:,2),  & 
G1H12(16),G1H12(17),G1H12(18),G1H12(19),G1H12(20),G0H12(4),12)
call HG1shiftOLR(G1H12(17),8,12)
call Hotf_4pt_reduction(G2H12(5),RedSet_4(16),mass4set(:,1),  & 
G1H12(21),G1H12(22),G1H12(23),G1H12(24),G1H12(25),G0H12(5),12)
call HG1shiftOLR(G1H12(22),8,12)
call Hotf_4pt_reduction(G2H12(6),RedSet_4(16),mass4set(:,3),  & 
G1H12(26),G1H12(27),G1H12(28),G1H12(29),G1H12(30),G0H12(6),12)
call HG1shiftOLR(G1H12(27),8,12)
call Hotf_4pt_reduction(G2H12(7),RedSet_4(16),mass4set(:,1),  & 
G1H12(31),G1H12(32),G1H12(33),G1H12(34),G1H12(35),G0H12(7),12)
call HG1shiftOLR(G1H12(32),8,12)
call Hotf_4pt_reduction(G2H12(8),RedSet_4(16),mass4set(:,3),  & 
G1H12(36),G1H12(37),G1H12(38),G1H12(39),G1H12(40),G0H12(8),12)
call HG1shiftOLR(G1H12(37),8,12)
call Hotf_4pt_reduction(G2H18(1),RedSet_4(35),mass4set(:,1),  & 
G1H18(11),G1H18(12),G1H18(2),G1H18(9),G1H18(5),18)
call HG1shiftOLR(G1H18(12),5,18)
  call Hloop_VQ_A(ntry,G1H18(1),wf6(:,3),G1H3(13),m3h6x3(:,1),heltab2x18(:,:,21))
  call Hloop_Q_A(ntry,G1H3(13),23,0,G2H3(15),n2h3(27))
call Hotf_4pt_reduction(G2H18(2),RedSet_4(3),mass4set(:,1),  & 
G1H18(3),G1H18(6),G1H18(8),G1H18(1),G1H18(13),18)
call HG1shiftOLR(G1H18(6),6,18)
  call Hloop_VA_Q(ntry,G1H18(4),wf6(:,8),G1H3(14),m3h6x3(:,2),heltab2x18(:,:,22))
  call Hloop_A_Q(ntry,G1H3(14),23,0,G2H3(18),n2h3(28))
call Hotf_4pt_reduction(G2H18(3),RedSet_4(36),mass4set(:,1),  & 
G1H18(4),G1H18(14),G1H18(15),G1H18(16),G1H18(17),18)
call HG1shiftOLR(G1H18(14),9,18)
  call Hloop_QA_V(ntry,G2H12(9),ex2(:),G2H6(6),m3h2x6(:,3),heltab2x12(:,:,3))
  call Hloop_VQ_A(ntry,G1H18(7),wf6(:,7),G1H3(18),m3h6x3(:,3),heltab2x18(:,:,23))
  call Hloop_Q_A(ntry,G1H3(18),27,0,G2H3(19),n2h3(29))
call Hotf_4pt_reduction(G2H18(4),RedSet_4(2),mass4set(:,1),  & 
G1H18(7),G1H18(18),G1H18(19),G1H18(20),G1H18(21),18)
call HG1shiftOLR(G1H18(18),10,18)
  call Hloop_AQ_V(ntry,G2H12(10),ex1(:),G2H6(7),m3h2x6(:,4),heltab2x12(:,:,4))
  call Hloop_VA_Q(ntry,G1H18(10),wf6(:,4),G1H3(19),m3h6x3(:,4),heltab2x18(:,:,24))
  call Hloop_A_Q(ntry,G1H3(19),27,0,G2H3(22),n2h3(30))
  call Hloop_QZ_A(ntry,G1H6(1),ex4(:),G1H2(1),ngZd,m3h3x2(:,21),heltab2x6(:,:,37))
  call Hloop_Q_A(ntry,G1H2(1),29,0,G2H2(17),n2h2(19))
call HGT_raise_alpha_OLR(G1H6(2),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(2),2,5,6)
  call Hloop_VA_Q(ntry,G1H6(2),ex2(:),G1H3(24),m3h2x3(:,17),heltab2x6(:,:,38))
  call Hloop_QZ_A(ntry,G1H6(6),ex4(:),G1H2(1),ngZd,m3h3x2(:,22),heltab2x6(:,:,39))
  call Hloop_Q_A(ntry,G1H2(1),29,0,G2H2(18),n2h2(20))
  call Hloop_QZ_A(ntry,G1H6(7),ex4(:),G1H2(1),ngZd,m3h3x2(:,23),heltab2x6(:,:,40))
  call Hloop_Q_A(ntry,G1H2(1),29,0,G2H2(19),n2h2(21))
  call Hloop_QZ_A(ntry,G1H6(8),ex3(:),G1H2(1),ngZd,m3h3x2(:,24),heltab2x6(:,:,41))
  call Hloop_Q_A(ntry,G1H2(1),29,0,G2H2(20),n2h2(22))
call HGT_raise_alpha_OLR(G1H6(11),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(11),2,5,6)
  call Hloop_VA_Q(ntry,G1H6(11),ex2(:),G1H3(25),m3h2x3(:,18),heltab2x6(:,:,42))
  call Hloop_QZ_A(ntry,G1H6(13),ex3(:),G1H2(1),ngZd,m3h3x2(:,25),heltab2x6(:,:,43))
  call Hloop_Q_A(ntry,G1H2(1),29,0,G2H2(21),n2h2(23))
  call Hloop_QZ_A(ntry,G1H6(14),ex3(:),G1H2(1),ngZd,m3h3x2(:,26),heltab2x6(:,:,44))
  call Hloop_Q_A(ntry,G1H2(1),29,0,G2H2(22),n2h2(24))
  call Hloop_QZ_A(ntry,G1H9(9),ex3(:),G1H3(29),ngZd,m3h3x3(:,21),heltab2x9(:,:,21))
  call Hloop_Q_A(ntry,G1H3(29),23,0,G2H3(23),n2h3(31))
call HGT_OLR(G1H9(10),1,1,9)
call HGT_invQ_OLR(G1H9(10),2,5,9)
  call Hloop_A_Q(ntry,G1H9(10),-8,0,G2H9(15),n2h9(29))
  call Hloop_AZ_Q(ntry,G2H9(15),ex4(:),G2H3(24),ngZd,m3h3x3(:,22),heltab2x9(:,:,22))
  call Hloop_QZ_A(ntry,G1H9(14),ex3(:),G1H3(30),ngZd,m3h3x3(:,23),heltab2x9(:,:,23))
  call Hloop_Q_A(ntry,G1H3(30),23,0,G2H3(25),n2h3(32))
  call Hloop_QZ_A(ntry,G1H9(15),ex3(:),G1H3(35),ngZd,m3h3x3(:,24),heltab2x9(:,:,24))
  call Hloop_Q_A(ntry,G1H3(35),23,0,G2H3(26),n2h3(33))
  call Hloop_QZ_A(ntry,G0H9(1),ex3(:),G0H3(1),ngZd,m3h3x3(:,25),heltab2x9(:,:,25))
  call Hloop_Q_A(ntry,G0H3(1),23,0,G1H3(36),n2h3(34))
  call Hloop_QZ_A(ntry,G1H9(16),ex4(:),G1H3(40),ngZd,m3h3x3(:,26),heltab2x9(:,:,26))
  call Hloop_Q_A(ntry,G1H3(40),27,0,G2H3(27),n2h3(35))
call HGT_OLR(G1H9(19),1,1,9)
call HGT_invQ_OLR(G1H9(19),2,5,9)
  call Hloop_A_Q(ntry,G1H9(19),-4,0,G2H9(5),n2h9(30))
  call Hloop_AZ_Q(ntry,G2H9(5),ex3(:),G2H3(28),ngZd,m3h3x3(:,27),heltab2x9(:,:,27))
  call Hloop_QZ_A(ntry,G1H9(21),ex4(:),G1H3(41),ngZd,m3h3x3(:,28),heltab2x9(:,:,28))
  call Hloop_Q_A(ntry,G1H3(41),27,0,G2H3(29),n2h3(36))
  call Hloop_QZ_A(ntry,G1H9(22),ex4(:),G1H3(46),ngZd,m3h3x3(:,29),heltab2x9(:,:,29))
  call Hloop_Q_A(ntry,G1H3(46),27,0,G2H3(30),n2h3(37))
  call Hloop_QZ_A(ntry,G0H9(2),ex4(:),G0H3(1),ngZd,m3h3x3(:,30),heltab2x9(:,:,30))
  call Hloop_Q_A(ntry,G0H3(1),27,0,G1H3(47),n2h3(38))
  call Hloop_AZ_Q(ntry,G1H9(25),ex3(:),G1H3(51),ngZd,m3h3x3(:,31),heltab2x9(:,:,31))
  call Hloop_A_Q(ntry,G1H3(51),23,0,G2H3(31),n2h3(39))
call HGT_OLR(G1H9(26),1,1,9)
call HGT_invQ_OLR(G1H9(26),2,5,9)
  call Hloop_Q_A(ntry,G1H9(26),-8,0,G2H9(13),n2h9(31))
  call Hloop_QZ_A(ntry,G2H9(13),ex4(:),G2H3(32),ngZd,m3h3x3(:,32),heltab2x9(:,:,32))
  call Hloop_AZ_Q(ntry,G1H9(7),ex3(:),G1H3(52),ngZd,m3h3x3(:,33),heltab2x9(:,:,33))
  call Hloop_A_Q(ntry,G1H3(52),23,0,G2H3(33),n2h3(40))
  call Hloop_AZ_Q(ntry,G1H9(11),ex3(:),G1H3(57),ngZd,m3h3x3(:,34),heltab2x9(:,:,34))
  call Hloop_A_Q(ntry,G1H3(57),23,0,G2H3(34),n2h3(41))
  call Hloop_AZ_Q(ntry,G0H9(3),ex3(:),G0H3(1),ngZd,m3h3x3(:,35),heltab2x9(:,:,35))
  call Hloop_A_Q(ntry,G0H3(1),23,0,G1H3(58),n2h3(42))
  call Hloop_AZ_Q(ntry,G1H9(8),ex4(:),G1H3(62),ngZd,m3h3x3(:,36),heltab2x9(:,:,36))
  call Hloop_A_Q(ntry,G1H3(62),27,0,G2H3(35),n2h3(43))
call HGT_OLR(G1H9(6),1,1,9)
call HGT_invQ_OLR(G1H9(6),2,5,9)
  call Hloop_Q_A(ntry,G1H9(6),-4,0,G2H9(7),n2h9(32))
  call Hloop_QZ_A(ntry,G2H9(7),ex3(:),G2H3(36),ngZd,m3h3x3(:,37),heltab2x9(:,:,37))
  call Hloop_AZ_Q(ntry,G1H9(17),ex4(:),G1H3(63),ngZd,m3h3x3(:,38),heltab2x9(:,:,38))
  call Hloop_A_Q(ntry,G1H3(63),27,0,G2H3(37),n2h3(44))
  call Hloop_AZ_Q(ntry,G1H9(18),ex4(:),G1H3(68),ngZd,m3h3x3(:,39),heltab2x9(:,:,39))
  call Hloop_A_Q(ntry,G1H3(68),27,0,G2H3(38),n2h3(45))
  call Hloop_AZ_Q(ntry,G0H9(4),ex4(:),G0H3(1),ngZd,m3h3x3(:,40),heltab2x9(:,:,40))
  call Hloop_A_Q(ntry,G0H3(1),27,0,G1H3(69),n2h3(46))
  call Hloop_QZ_A(ntry,G1H6(19),ex4(:),G1H2(1),ngZd,m3h3x2(:,27),heltab2x6(:,:,45))
  call Hloop_Q_A(ntry,G1H2(1),29,0,G2H2(23),n2h2(25))
call HGT_raise_alpha_OLR(G1H6(24),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(24),2,5,6)
  call Hloop_VA_Q(ntry,G1H6(24),ex2(:),G1H3(12),m3h2x3(:,19),heltab2x6(:,:,46))
  call Hloop_QZ_A(ntry,G1H6(23),ex4(:),G1H2(1),ngZd,m3h3x2(:,28),heltab2x6(:,:,47))
  call Hloop_Q_A(ntry,G1H2(1),29,0,G2H2(24),n2h2(26))
  call Hloop_QZ_A(ntry,G1H6(25),ex4(:),G1H2(1),ngZd,m3h3x2(:,29),heltab2x6(:,:,48))
  call Hloop_Q_A(ntry,G1H2(1),29,0,G2H2(25),n2h2(27))
  call Hloop_QZ_A(ntry,G1H6(28),ex3(:),G1H2(1),ngZd,m3h3x2(:,30),heltab2x6(:,:,49))
  call Hloop_Q_A(ntry,G1H2(1),29,0,G2H2(26),n2h2(28))
call HGT_raise_alpha_OLR(G1H6(29),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(29),2,5,6)
  call Hloop_VA_Q(ntry,G1H6(29),ex2(:),G1H3(23),m3h2x3(:,20),heltab2x6(:,:,50))
  call Hloop_QZ_A(ntry,G1H6(35),ex3(:),G1H2(1),ngZd,m3h3x2(:,31),heltab2x6(:,:,51))
  call Hloop_Q_A(ntry,G1H2(1),29,0,G2H2(27),n2h2(29))
  call Hloop_QZ_A(ntry,G1H6(40),ex3(:),G1H2(1),ngZd,m3h3x2(:,32),heltab2x6(:,:,52))
  call Hloop_Q_A(ntry,G1H2(1),29,0,G2H2(28),n2h2(30))
  call Hloop_QZ_A(ntry,G1H9(23),ex4(:),G1H3(34),ngZu,m3h3x3(:,41),heltab2x9(:,:,41))
  call Hloop_Q_A(ntry,G1H3(34),27,0,G2H3(39),n2h3(47))
call HGT_OLR(G1H9(24),1,1,9)
call HGT_invQ_OLR(G1H9(24),2,5,9)
  call Hloop_A_Q(ntry,G1H9(24),-4,0,G2H9(1),n2h9(33))
  call Hloop_AZ_Q(ntry,G2H9(1),ex3(:),G2H3(40),ngZu,m3h3x3(:,42),heltab2x9(:,:,42))
  call Hloop_QZ_A(ntry,G1H9(2),ex4(:),G1H3(45),ngZu,m3h3x3(:,43),heltab2x9(:,:,43))
  call Hloop_Q_A(ntry,G1H3(45),27,0,G2H3(41),n2h3(48))
  call Hloop_QZ_A(ntry,G1H9(3),ex4(:),G1H3(56),ngZu,m3h3x3(:,44),heltab2x9(:,:,44))
  call Hloop_Q_A(ntry,G1H3(56),27,0,G2H3(42),n2h3(49))
  call Hloop_QZ_A(ntry,G0H9(5),ex4(:),G0H3(1),ngZu,m3h3x3(:,45),heltab2x9(:,:,45))
  call Hloop_Q_A(ntry,G0H3(1),27,0,G1H3(67),n2h3(50))
  call Hloop_QZ_A(ntry,G1H9(4),ex4(:),G1H3(7),ngZu,m3h3x3(:,46),heltab2x9(:,:,46))
  call Hloop_Q_A(ntry,G1H3(7),27,nMT,G2H3(43),n2h3(51))
call HGT_OLR(G1H9(27),1,1,9)
call HGT_invQ_OLR(G1H9(27),2,5,9)
  call Hloop_A_Q(ntry,G1H9(27),-4,nMT,G2H9(2),n2h9(34))
  call Hloop_AZ_Q(ntry,G2H9(2),ex3(:),G2H3(44),ngZu,m3h3x3(:,47),heltab2x9(:,:,47))
  call Hloop_QZ_A(ntry,G1H9(29),ex4(:),G1H3(8),ngZu,m3h3x3(:,48),heltab2x9(:,:,48))
  call Hloop_Q_A(ntry,G1H3(8),27,nMT,G2H3(45),n2h3(52))
  call Hloop_QZ_A(ntry,G1H9(30),ex4(:),G1H3(13),ngZu,m3h3x3(:,49),heltab2x9(:,:,49))
  call Hloop_Q_A(ntry,G1H3(13),27,nMT,G2H3(46),n2h3(53))
  call Hloop_QZ_A(ntry,G0H9(6),ex4(:),G0H3(1),ngZu,m3h3x3(:,50),heltab2x9(:,:,50))
  call Hloop_Q_A(ntry,G0H3(1),27,nMT,G1H3(14),n2h3(54))
  call Hloop_AZ_Q(ntry,G1H9(31),ex4(:),G1H3(18),ngZu,m3h3x3(:,51),heltab2x9(:,:,51))
  call Hloop_A_Q(ntry,G1H3(18),27,0,G2H3(47),n2h3(55))
call HGT_OLR(G1H9(32),1,1,9)
call HGT_invQ_OLR(G1H9(32),2,5,9)
  call Hloop_Q_A(ntry,G1H9(32),-4,0,G2H9(3),n2h9(35))
  call Hloop_QZ_A(ntry,G2H9(3),ex3(:),G2H3(48),ngZu,m3h3x3(:,52),heltab2x9(:,:,52))
  call Hloop_AZ_Q(ntry,G1H9(34),ex4(:),G1H3(19),ngZu,m3h3x3(:,53),heltab2x9(:,:,53))
  call Hloop_A_Q(ntry,G1H3(19),27,0,G2H3(49),n2h3(56))
  call Hloop_AZ_Q(ntry,G1H9(35),ex4(:),G1H3(29),ngZu,m3h3x3(:,54),heltab2x9(:,:,54))
  call Hloop_A_Q(ntry,G1H3(29),27,0,G2H3(50),n2h3(57))
  call Hloop_AZ_Q(ntry,G0H9(7),ex4(:),G0H3(1),ngZu,m3h3x3(:,55),heltab2x9(:,:,55))
  call Hloop_A_Q(ntry,G0H3(1),27,0,G1H3(30),n2h3(58))
  call Hloop_AZ_Q(ntry,G1H9(36),ex4(:),G1H3(35),ngZu,m3h3x3(:,56),heltab2x9(:,:,56))
  call Hloop_A_Q(ntry,G1H3(35),27,nMT,G2H3(51),n2h3(59))
call HGT_OLR(G1H9(37),1,1,9)
call HGT_invQ_OLR(G1H9(37),2,5,9)
  call Hloop_Q_A(ntry,G1H9(37),-4,nMT,G2H9(4),n2h9(36))
  call Hloop_QZ_A(ntry,G2H9(4),ex3(:),G2H3(52),ngZu,m3h3x3(:,57),heltab2x9(:,:,57))
  call Hloop_AZ_Q(ntry,G1H9(39),ex4(:),G1H3(40),ngZu,m3h3x3(:,58),heltab2x9(:,:,58))
  call Hloop_A_Q(ntry,G1H3(40),27,nMT,G2H3(53),n2h3(60))
  call Hloop_AZ_Q(ntry,G1H9(40),ex4(:),G1H3(41),ngZu,m3h3x3(:,59),heltab2x9(:,:,59))
  call Hloop_A_Q(ntry,G1H3(41),27,nMT,G2H3(54),n2h3(61))
  call Hloop_AZ_Q(ntry,G0H9(8),ex4(:),G0H3(1),ngZu,m3h3x3(:,60),heltab2x9(:,:,60))
  call Hloop_A_Q(ntry,G0H3(1),27,nMT,G1H3(46),n2h3(62))
  call Hloop_QZ_A(ntry,G1H9(41),ex4(:),G1H3(51),ngZd,m3h3x3(:,61),heltab2x9(:,:,61))
  call Hloop_Q_A(ntry,G1H3(51),27,nMB,G2H3(55),n2h3(63))
call HGT_OLR(G1H9(42),1,1,9)
call HGT_invQ_OLR(G1H9(42),2,5,9)
  call Hloop_A_Q(ntry,G1H9(42),-4,nMB,G2H9(6),n2h9(37))
  call Hloop_AZ_Q(ntry,G2H9(6),ex3(:),G2H3(56),ngZd,m3h3x3(:,62),heltab2x9(:,:,62))
  call Hloop_QZ_A(ntry,G1H9(44),ex4(:),G1H3(52),ngZd,m3h3x3(:,63),heltab2x9(:,:,63))
  call Hloop_Q_A(ntry,G1H3(52),27,nMB,G2H3(57),n2h3(64))
  call Hloop_QZ_A(ntry,G1H9(45),ex4(:),G1H3(57),ngZd,m3h3x3(:,64),heltab2x9(:,:,64))
  call Hloop_Q_A(ntry,G1H3(57),27,nMB,G2H3(58),n2h3(65))
  call Hloop_QZ_A(ntry,G0H9(9),ex4(:),G0H3(1),ngZd,m3h3x3(:,65),heltab2x9(:,:,65))
  call Hloop_Q_A(ntry,G0H3(1),27,nMB,G1H3(62),n2h3(66))
  call Hloop_AZ_Q(ntry,G1H9(46),ex4(:),G1H3(63),ngZd,m3h3x3(:,66),heltab2x9(:,:,66))
  call Hloop_A_Q(ntry,G1H3(63),27,nMB,G2H3(59),n2h3(67))
call HGT_OLR(G1H9(47),1,1,9)
call HGT_invQ_OLR(G1H9(47),2,5,9)
  call Hloop_Q_A(ntry,G1H9(47),-4,nMB,G2H9(8),n2h9(38))
  call Hloop_QZ_A(ntry,G2H9(8),ex3(:),G2H3(60),ngZd,m3h3x3(:,67),heltab2x9(:,:,67))
  call Hloop_AZ_Q(ntry,G1H9(49),ex4(:),G1H3(68),ngZd,m3h3x3(:,68),heltab2x9(:,:,68))
  call Hloop_A_Q(ntry,G1H3(68),27,nMB,G2H3(61),n2h3(68))
  call Hloop_AZ_Q(ntry,G1H9(50),ex4(:),G1H3(34),ngZd,m3h3x3(:,69),heltab2x9(:,:,69))
  call Hloop_A_Q(ntry,G1H3(34),27,nMB,G2H3(62),n2h3(69))
  call Hloop_AZ_Q(ntry,G0H9(10),ex4(:),G0H3(1),ngZd,m3h3x3(:,70),heltab2x9(:,:,70))
  call Hloop_A_Q(ntry,G0H3(1),27,nMB,G1H3(45),n2h3(70))
  call Hloop_AZ_Q(ntry,G1H9(51),ex3(:),G1H3(56),ngZu,m3h3x3(:,71),heltab2x9(:,:,71))
  call Hloop_A_Q(ntry,G1H3(56),23,0,G2H3(63),n2h3(71))
call HGT_OLR(G1H9(52),1,1,9)
call HGT_invQ_OLR(G1H9(52),2,5,9)
  call Hloop_Q_A(ntry,G1H9(52),-8,0,G2H9(9),n2h9(39))
  call Hloop_QZ_A(ntry,G2H9(9),ex4(:),G2H3(64),ngZu,m3h3x3(:,72),heltab2x9(:,:,72))
  call Hloop_AZ_Q(ntry,G1H9(54),ex3(:),G1H3(7),ngZu,m3h3x3(:,73),heltab2x9(:,:,73))
  call Hloop_A_Q(ntry,G1H3(7),23,0,G2H3(65),n2h3(72))
  call Hloop_AZ_Q(ntry,G1H9(55),ex3(:),G1H3(8),ngZu,m3h3x3(:,74),heltab2x9(:,:,74))
  call Hloop_A_Q(ntry,G1H3(8),23,0,G2H3(66),n2h3(73))
  call Hloop_AZ_Q(ntry,G0H9(11),ex3(:),G0H3(1),ngZu,m3h3x3(:,75),heltab2x9(:,:,75))
  call Hloop_A_Q(ntry,G0H3(1),23,0,G1H3(13),n2h3(74))
  call Hloop_AZ_Q(ntry,G1H9(56),ex3(:),G1H3(18),ngZu,m3h3x3(:,76),heltab2x9(:,:,76))
  call Hloop_A_Q(ntry,G1H3(18),23,nMT,G2H3(67),n2h3(75))
call HGT_OLR(G1H9(57),1,1,9)
call HGT_invQ_OLR(G1H9(57),2,5,9)
  call Hloop_Q_A(ntry,G1H9(57),-8,nMT,G2H9(10),n2h9(40))
  call Hloop_QZ_A(ntry,G2H9(10),ex4(:),G2H3(68),ngZu,m3h3x3(:,77),heltab2x9(:,:,77))
  call Hloop_AZ_Q(ntry,G1H9(59),ex3(:),G1H3(19),ngZu,m3h3x3(:,78),heltab2x9(:,:,78))
  call Hloop_A_Q(ntry,G1H3(19),23,nMT,G2H3(69),n2h3(76))
  call Hloop_AZ_Q(ntry,G1H9(60),ex3(:),G1H3(29),ngZu,m3h3x3(:,79),heltab2x9(:,:,79))
  call Hloop_A_Q(ntry,G1H3(29),23,nMT,G2H3(70),n2h3(77))
  call Hloop_AZ_Q(ntry,G0H9(12),ex3(:),G0H3(1),ngZu,m3h3x3(:,80),heltab2x9(:,:,80))
  call Hloop_A_Q(ntry,G0H3(1),23,nMT,G1H3(35),n2h3(78))
  call Hloop_QZ_A(ntry,G1H9(61),ex3(:),G1H3(40),ngZu,m3h3x3(:,81),heltab2x9(:,:,81))
  call Hloop_Q_A(ntry,G1H3(40),23,0,G2H3(71),n2h3(79))
call HGT_OLR(G1H9(62),1,1,9)
call HGT_invQ_OLR(G1H9(62),2,5,9)
  call Hloop_A_Q(ntry,G1H9(62),-8,0,G2H9(11),n2h9(41))
  call Hloop_AZ_Q(ntry,G2H9(11),ex4(:),G2H3(72),ngZu,m3h3x3(:,82),heltab2x9(:,:,82))
  call Hloop_QZ_A(ntry,G1H9(64),ex3(:),G1H3(41),ngZu,m3h3x3(:,83),heltab2x9(:,:,83))
  call Hloop_Q_A(ntry,G1H3(41),23,0,G2H3(73),n2h3(80))
  call Hloop_QZ_A(ntry,G1H9(65),ex3(:),G1H3(51),ngZu,m3h3x3(:,84),heltab2x9(:,:,84))
  call Hloop_Q_A(ntry,G1H3(51),23,0,G2H3(74),n2h3(81))
  call Hloop_QZ_A(ntry,G0H9(13),ex3(:),G0H3(1),ngZu,m3h3x3(:,85),heltab2x9(:,:,85))
  call Hloop_Q_A(ntry,G0H3(1),23,0,G1H3(52),n2h3(82))
  call Hloop_QZ_A(ntry,G1H9(66),ex3(:),G1H3(57),ngZu,m3h3x3(:,86),heltab2x9(:,:,86))
  call Hloop_Q_A(ntry,G1H3(57),23,nMT,G2H3(75),n2h3(83))
call HGT_OLR(G1H9(67),1,1,9)
call HGT_invQ_OLR(G1H9(67),2,5,9)
  call Hloop_A_Q(ntry,G1H9(67),-8,nMT,G2H9(12),n2h9(42))
  call Hloop_AZ_Q(ntry,G2H9(12),ex4(:),G2H3(76),ngZu,m3h3x3(:,87),heltab2x9(:,:,87))
  call Hloop_QZ_A(ntry,G1H9(69),ex3(:),G1H3(63),ngZu,m3h3x3(:,88),heltab2x9(:,:,88))
  call Hloop_Q_A(ntry,G1H3(63),23,nMT,G2H3(77),n2h3(84))
  call Hloop_QZ_A(ntry,G1H9(70),ex3(:),G1H3(68),ngZu,m3h3x3(:,89),heltab2x9(:,:,89))
  call Hloop_Q_A(ntry,G1H3(68),23,nMT,G2H3(78),n2h3(85))
  call Hloop_QZ_A(ntry,G0H9(14),ex3(:),G0H3(1),ngZu,m3h3x3(:,90),heltab2x9(:,:,90))
  call Hloop_Q_A(ntry,G0H3(1),23,nMT,G1H3(34),n2h3(86))
  call Hloop_AZ_Q(ntry,G1H9(71),ex3(:),G1H3(56),ngZd,m3h3x3(:,91),heltab2x9(:,:,91))
  call Hloop_A_Q(ntry,G1H3(56),23,nMB,G2H3(79),n2h3(87))
call HGT_OLR(G1H9(72),1,1,9)
call HGT_invQ_OLR(G1H9(72),2,5,9)
  call Hloop_Q_A(ntry,G1H9(72),-8,nMB,G2H9(14),n2h9(43))
  call Hloop_QZ_A(ntry,G2H9(14),ex4(:),G2H3(80),ngZd,m3h3x3(:,92),heltab2x9(:,:,92))
  call Hloop_AZ_Q(ntry,G1H9(74),ex3(:),G1H3(7),ngZd,m3h3x3(:,93),heltab2x9(:,:,93))
  call Hloop_A_Q(ntry,G1H3(7),23,nMB,G2H3(81),n2h3(88))
  call Hloop_AZ_Q(ntry,G1H9(75),ex3(:),G1H3(8),ngZd,m3h3x3(:,94),heltab2x9(:,:,94))
  call Hloop_A_Q(ntry,G1H3(8),23,nMB,G2H3(82),n2h3(89))
  call Hloop_AZ_Q(ntry,G0H9(15),ex3(:),G0H3(1),ngZd,m3h3x3(:,95),heltab2x9(:,:,95))
  call Hloop_A_Q(ntry,G0H3(1),23,nMB,G1H3(18),n2h3(90))
  call Hloop_QZ_A(ntry,G1H9(76),ex3(:),G1H3(19),ngZd,m3h3x3(:,96),heltab2x9(:,:,96))
  call Hloop_Q_A(ntry,G1H3(19),23,nMB,G2H3(83),n2h3(91))
call HGT_OLR(G1H9(77),1,1,9)
call HGT_invQ_OLR(G1H9(77),2,5,9)
  call Hloop_A_Q(ntry,G1H9(77),-8,nMB,G2H9(16),n2h9(44))
  call Hloop_AZ_Q(ntry,G2H9(16),ex4(:),G2H3(84),ngZd,m3h3x3(:,97),heltab2x9(:,:,97))
  call Hloop_QZ_A(ntry,G1H9(79),ex3(:),G1H3(29),ngZd,m3h3x3(:,98),heltab2x9(:,:,98))
  call Hloop_Q_A(ntry,G1H3(29),23,nMB,G2H3(85),n2h3(92))
  call Hloop_QZ_A(ntry,G1H9(80),ex3(:),G1H3(40),ngZd,m3h3x3(:,99),heltab2x9(:,:,99))
  call Hloop_Q_A(ntry,G1H3(40),23,nMB,G2H3(86),n2h3(93))
  call Hloop_QZ_A(ntry,G0H9(16),ex3(:),G0H3(1),ngZd,m3h3x3(:,100),heltab2x9(:,:,100))
  call Hloop_Q_A(ntry,G0H3(1),23,nMB,G1H3(41),n2h3(94))
  call Hloop_QV_A(ntry,G1H12(1),wf4(:,5),G1H3(51),m3h4x3(:,1),heltab2x12(:,:,5))
  call Hloop_Q_A(ntry,G1H3(51),23,0,G2H3(87),n2h3(95))
call HGT_OLR(G1H12(2),1,1,12)
call HGT_invQ_OLR(G1H12(2),2,5,12)
  call Hloop_A_Q(ntry,G1H12(2),-8,0,G2H12(1),n2h12(13))
  call Hloop_AZ_Q(ntry,G2H12(1),ex4(:),G2H4(1),ngZu,m3h3x4(:,1),heltab2x12(:,:,6))
  call Hloop_QV_A(ntry,G1H12(4),wf4(:,5),G1H3(57),m3h4x3(:,2),heltab2x12(:,:,7))
  call Hloop_Q_A(ntry,G1H3(57),23,0,G2H3(88),n2h3(96))
  call Hloop_QV_A(ntry,G1H12(5),wf4(:,5),G1H3(63),m3h4x3(:,3),heltab2x12(:,:,8))
  call Hloop_Q_A(ntry,G1H3(63),23,0,G2H3(89),n2h3(97))
  call Hloop_QV_A(ntry,G0H12(1),wf4(:,5),G0H3(1),m3h4x3(:,4),heltab2x12(:,:,9))
  call Hloop_Q_A(ntry,G0H3(1),23,0,G1H3(68),n2h3(98))
  call Hloop_QV_A(ntry,G1H12(6),wf4(:,5),G1H3(56),m3h4x3(:,5),heltab2x12(:,:,10))
  call Hloop_Q_A(ntry,G1H3(56),23,nMT,G2H3(90),n2h3(99))
call HGT_OLR(G1H12(7),1,1,12)
call HGT_invQ_OLR(G1H12(7),2,5,12)
  call Hloop_A_Q(ntry,G1H12(7),-8,nMT,G2H12(2),n2h12(14))
  call Hloop_AZ_Q(ntry,G2H12(2),ex4(:),G2H4(2),ngZu,m3h3x4(:,2),heltab2x12(:,:,11))
  call Hloop_QV_A(ntry,G1H12(9),wf4(:,5),G1H3(7),m3h4x3(:,6),heltab2x12(:,:,12))
  call Hloop_Q_A(ntry,G1H3(7),23,nMT,G2H3(91),n2h3(100))
  call Hloop_QV_A(ntry,G1H12(10),wf4(:,5),G1H3(8),m3h4x3(:,7),heltab2x12(:,:,13))
  call Hloop_Q_A(ntry,G1H3(8),23,nMT,G2H3(92),n2h3(101))
  call Hloop_QV_A(ntry,G0H12(2),wf4(:,5),G0H3(1),m3h4x3(:,8),heltab2x12(:,:,14))
  call Hloop_Q_A(ntry,G0H3(1),23,nMT,G1H3(19),n2h3(102))
  call Hloop_AV_Q(ntry,G1H12(11),wf4(:,5),G1H3(29),m3h4x3(:,9),heltab2x12(:,:,15))
  call Hloop_A_Q(ntry,G1H3(29),23,0,G2H3(93),n2h3(103))
call HGT_OLR(G1H12(12),1,1,12)
call HGT_invQ_OLR(G1H12(12),2,5,12)
  call Hloop_Q_A(ntry,G1H12(12),-8,0,G2H12(3),n2h12(15))
  call Hloop_QZ_A(ntry,G2H12(3),ex4(:),G2H4(3),ngZu,m3h3x4(:,3),heltab2x12(:,:,16))
  call Hloop_AV_Q(ntry,G1H12(14),wf4(:,5),G1H3(40),m3h4x3(:,10),heltab2x12(:,:,17))
  call Hloop_A_Q(ntry,G1H3(40),23,0,G2H3(94),n2h3(104))
  call Hloop_AV_Q(ntry,G1H12(15),wf4(:,5),G1H3(51),m3h4x3(:,11),heltab2x12(:,:,18))
  call Hloop_A_Q(ntry,G1H3(51),23,0,G2H3(95),n2h3(105))
  call Hloop_AV_Q(ntry,G0H12(3),wf4(:,5),G0H3(1),m3h4x3(:,12),heltab2x12(:,:,19))
  call Hloop_A_Q(ntry,G0H3(1),23,0,G1H3(57),n2h3(106))
  call Hloop_AV_Q(ntry,G1H12(16),wf4(:,5),G1H3(63),m3h4x3(:,13),heltab2x12(:,:,20))
  call Hloop_A_Q(ntry,G1H3(63),23,nMT,G2H3(96),n2h3(107))
call HGT_OLR(G1H12(17),1,1,12)
call HGT_invQ_OLR(G1H12(17),2,5,12)
  call Hloop_Q_A(ntry,G1H12(17),-8,nMT,G2H12(4),n2h12(16))
  call Hloop_QZ_A(ntry,G2H12(4),ex4(:),G2H4(4),ngZu,m3h3x4(:,4),heltab2x12(:,:,21))
  call Hloop_AV_Q(ntry,G1H12(19),wf4(:,5),G1H3(56),m3h4x3(:,14),heltab2x12(:,:,22))
  call Hloop_A_Q(ntry,G1H3(56),23,nMT,G2H3(97),n2h3(108))
  call Hloop_AV_Q(ntry,G1H12(20),wf4(:,5),G1H3(7),m3h4x3(:,15),heltab2x12(:,:,23))
  call Hloop_A_Q(ntry,G1H3(7),23,nMT,G2H3(98),n2h3(109))
  call Hloop_AV_Q(ntry,G0H12(4),wf4(:,5),G0H3(1),m3h4x3(:,16),heltab2x12(:,:,24))
  call Hloop_A_Q(ntry,G0H3(1),23,nMT,G1H3(8),n2h3(110))
  call Hloop_QV_A(ntry,G1H12(21),wf4(:,5),G1H3(29),m3h4x3(:,17),heltab2x12(:,:,25))
  call Hloop_Q_A(ntry,G1H3(29),23,0,G2H3(99),n2h3(111))
call HGT_OLR(G1H12(22),1,1,12)
call HGT_invQ_OLR(G1H12(22),2,5,12)
  call Hloop_A_Q(ntry,G1H12(22),-8,0,G2H12(5),n2h12(17))
  call Hloop_AZ_Q(ntry,G2H12(5),ex4(:),G2H4(5),ngZd,m3h3x4(:,5),heltab2x12(:,:,26))
  call Hloop_QV_A(ntry,G1H12(24),wf4(:,5),G1H3(40),m3h4x3(:,18),heltab2x12(:,:,27))
  call Hloop_Q_A(ntry,G1H3(40),23,0,G2H3(100),n2h3(112))
  call Hloop_QV_A(ntry,G1H12(25),wf4(:,5),G1H3(51),m3h4x3(:,19),heltab2x12(:,:,28))
  call Hloop_Q_A(ntry,G1H3(51),23,0,G2H3(101),n2h3(113))
  call Hloop_QV_A(ntry,G0H12(5),wf4(:,5),G0H3(1),m3h4x3(:,20),heltab2x12(:,:,29))
  call Hloop_Q_A(ntry,G0H3(1),23,0,G1H3(63),n2h3(114))
  call Hloop_QV_A(ntry,G1H12(26),wf4(:,5),G1H3(56),m3h4x3(:,21),heltab2x12(:,:,30))
  call Hloop_Q_A(ntry,G1H3(56),23,nMB,G2H3(102),n2h3(115))
call HGT_OLR(G1H12(27),1,1,12)
call HGT_invQ_OLR(G1H12(27),2,5,12)
  call Hloop_A_Q(ntry,G1H12(27),-8,nMB,G2H12(6),n2h12(18))
  call Hloop_AZ_Q(ntry,G2H12(6),ex4(:),G2H4(6),ngZd,m3h3x4(:,6),heltab2x12(:,:,31))
  call Hloop_QV_A(ntry,G1H12(29),wf4(:,5),G1H3(7),m3h4x3(:,22),heltab2x12(:,:,32))
  call Hloop_Q_A(ntry,G1H3(7),23,nMB,G2H3(103),n2h3(116))
  call Hloop_QV_A(ntry,G1H12(30),wf4(:,5),G1H3(29),m3h4x3(:,23),heltab2x12(:,:,33))
  call Hloop_Q_A(ntry,G1H3(29),23,nMB,G2H3(104),n2h3(117))
  call Hloop_QV_A(ntry,G0H12(6),wf4(:,5),G0H3(1),m3h4x3(:,24),heltab2x12(:,:,34))
  call Hloop_Q_A(ntry,G0H3(1),23,nMB,G1H3(40),n2h3(118))
  call Hloop_AV_Q(ntry,G1H12(31),wf4(:,5),G1H3(51),m3h4x3(:,25),heltab2x12(:,:,35))
  call Hloop_A_Q(ntry,G1H3(51),23,0,G2H3(105),n2h3(119))
call HGT_OLR(G1H12(32),1,1,12)
call HGT_invQ_OLR(G1H12(32),2,5,12)
  call Hloop_Q_A(ntry,G1H12(32),-8,0,G2H12(7),n2h12(19))
  call Hloop_QZ_A(ntry,G2H12(7),ex4(:),G2H4(7),ngZd,m3h3x4(:,7),heltab2x12(:,:,36))
  call Hloop_AV_Q(ntry,G1H12(34),wf4(:,5),G1H3(56),m3h4x3(:,26),heltab2x12(:,:,37))
  call Hloop_A_Q(ntry,G1H3(56),23,0,G2H3(106),n2h3(120))
  call Hloop_AV_Q(ntry,G1H12(35),wf4(:,5),G1H3(7),m3h4x3(:,27),heltab2x12(:,:,38))
  call Hloop_A_Q(ntry,G1H3(7),23,0,G2H3(107),n2h3(121))
  call Hloop_AV_Q(ntry,G0H12(7),wf4(:,5),G0H3(1),m3h4x3(:,28),heltab2x12(:,:,39))
  call Hloop_A_Q(ntry,G0H3(1),23,0,G1H3(29),n2h3(122))
  call Hloop_AV_Q(ntry,G1H12(36),wf4(:,5),G1H3(51),m3h4x3(:,29),heltab2x12(:,:,40))
  call Hloop_A_Q(ntry,G1H3(51),23,nMB,G2H3(108),n2h3(123))
call HGT_OLR(G1H12(37),1,1,12)
call HGT_invQ_OLR(G1H12(37),2,5,12)
  call Hloop_Q_A(ntry,G1H12(37),-8,nMB,G2H12(8),n2h12(20))
  call Hloop_QZ_A(ntry,G2H12(8),ex4(:),G2H4(8),ngZd,m3h3x4(:,8),heltab2x12(:,:,41))
  call Hloop_AV_Q(ntry,G1H12(39),wf4(:,5),G1H3(56),m3h4x3(:,30),heltab2x12(:,:,42))
  call Hloop_A_Q(ntry,G1H3(56),23,nMB,G2H3(109),n2h3(124))
  call Hloop_AV_Q(ntry,G1H12(40),wf4(:,5),G1H3(7),m3h4x3(:,31),heltab2x12(:,:,43))
  call Hloop_A_Q(ntry,G1H3(7),23,nMB,G2H3(110),n2h3(125))
  call Hloop_AV_Q(ntry,G0H12(8),wf4(:,5),G0H3(1),m3h4x3(:,32),heltab2x12(:,:,44))
  call Hloop_A_Q(ntry,G0H3(1),23,nMB,G1H3(51),n2h3(126))
  call Hloop_AZ_Q(ntry,G1H18(11),ex4(:),G1H6(36),ngZd,m3h3x6(:,11),heltab2x18(:,:,25))
  call Hloop_A_Q(ntry,G1H6(36),26,0,G2H6(9),n2h6(23))
call HGT_raise_alpha_OLR(G1H18(12),1,1,18)
call HGT_raise_alpha_invQ_OLR(G1H18(12),2,5,18)
  call Hloop_VQ_A(ntry,G1H18(12),wf6(:,3),G1H3(56),m3h6x3(:,5),heltab2x18(:,:,26))
  call Hloop_AZ_Q(ntry,G1H18(9),ex4(:),G1H6(39),ngZd,m3h3x6(:,12),heltab2x18(:,:,27))
  call Hloop_A_Q(ntry,G1H6(39),26,0,G2H6(10),n2h6(24))
  call Hloop_AZ_Q(ntry,G1H18(5),ex4(:),G1H6(41),ngZd,m3h3x6(:,13),heltab2x18(:,:,28))
  call Hloop_A_Q(ntry,G1H6(41),26,0,G2H6(1),n2h6(25))
  call Hloop_QZ_A(ntry,G1H18(3),ex4(:),G1H6(44),ngZd,m3h3x6(:,14),heltab2x18(:,:,29))
  call Hloop_Q_A(ntry,G1H6(44),25,0,G2H6(2),n2h6(26))
call HGT_raise_alpha_OLR(G1H18(6),1,1,18)
call HGT_raise_alpha_invQ_OLR(G1H18(6),2,5,18)
  call Hloop_VA_Q(ntry,G1H18(6),wf6(:,8),G1H3(7),m3h6x3(:,6),heltab2x18(:,:,30))
  call Hloop_QZ_A(ntry,G1H18(1),ex4(:),G1H6(17),ngZd,m3h3x6(:,15),heltab2x18(:,:,31))
  call Hloop_Q_A(ntry,G1H6(17),25,0,G2H6(4),n2h6(27))
  call Hloop_QZ_A(ntry,G1H18(13),ex4(:),G1H6(18),ngZd,m3h3x6(:,16),heltab2x18(:,:,32))
  call Hloop_Q_A(ntry,G1H6(18),25,0,G2H6(8),n2h6(28))
  call Hloop_AZ_Q(ntry,G1H18(4),ex3(:),G1H6(16),ngZd,m3h3x6(:,17),heltab2x18(:,:,33))
  call Hloop_A_Q(ntry,G1H6(16),22,0,G2H6(3),n2h6(29))
call HGT_raise_alpha_OLR(G1H18(14),1,1,18)
call HGT_raise_alpha_invQ_OLR(G1H18(14),2,5,18)
  call Hloop_VQ_A(ntry,G1H18(14),wf6(:,7),G1H3(73),m3h6x3(:,7),heltab2x18(:,:,34))
  call Hloop_AZ_Q(ntry,G1H18(16),ex3(:),G1H6(32),ngZd,m3h3x6(:,18),heltab2x18(:,:,35))
  call Hloop_A_Q(ntry,G1H6(32),22,0,G2H6(5),n2h6(30))
  call Hloop_AZ_Q(ntry,G1H18(17),ex3(:),G1H6(4),ngZd,m3h3x6(:,19),heltab2x18(:,:,36))
  call Hloop_A_Q(ntry,G1H6(4),22,0,G2H6(11),n2h6(31))
  call Hloop_QZ_A(ntry,G1H18(7),ex3(:),G1H6(10),ngZd,m3h3x6(:,20),heltab2x18(:,:,37))
  call Hloop_Q_A(ntry,G1H6(10),21,0,G2H6(12),n2h6(32))
call HGT_raise_alpha_OLR(G1H18(18),1,1,18)
call HGT_raise_alpha_invQ_OLR(G1H18(18),2,5,18)
  call Hloop_VA_Q(ntry,G1H18(18),wf6(:,4),G1H3(74),m3h6x3(:,8),heltab2x18(:,:,38))
  call Hloop_QZ_A(ntry,G1H18(20),ex3(:),G1H6(15),ngZd,m3h3x6(:,21),heltab2x18(:,:,39))
  call Hloop_Q_A(ntry,G1H6(15),21,0,G2H6(13),n2h6(33))
  call Hloop_QZ_A(ntry,G1H18(21),ex3(:),G1H6(31),ngZd,m3h3x6(:,22),heltab2x18(:,:,40))
  call Hloop_Q_A(ntry,G1H6(31),21,0,G2H6(14),n2h6(34))
  call ol_merge(ntry,G2H3(105),[G2H3(2),G1H3(11)])
  call ol_merge(ntry,G2H3(15),[G2H3(6),G1H3(22)])
  call ol_merge(ntry,G2H3(99),[G2H3(9),G1H3(33)])
  call ol_merge(ntry,G2H3(8),[G1H3(31)])
call HGT_OLR(G2H3(12),1,1,3)
call HGT_invQ_OLR(G2H3(12),2,5,3)
call HGT_OLR(G2H3(12),6,15,3)
  call ol_merge(ntry,G2H3(12),[G2H3(8)])
  call ol_merge(ntry,G2H3(19),[G2H3(13),G1H3(44)])
  call ol_merge(ntry,G2H3(18),[G2H3(17),G1H3(55)])
  call ol_merge(ntry,G2H3(4),[G1H3(9)])
call HGT_OLR(G2H3(20),1,1,3)
call HGT_invQ_OLR(G2H3(20),2,5,3)
call HGT_OLR(G2H3(20),6,15,3)
  call ol_merge(ntry,G2H3(20),[G2H3(4)])
  call ol_merge(ntry,G2H3(22),[G2H3(21),G1H3(66)])
  call ol_merge(ntry,G2H3(1),[G1H3(20)])
call HGT_w2_OLR(G1H3(1),1,1,3)
call HGT_w2_invQ_OLR(G1H3(1),2,5,3)
  call ol_merge(ntry,G2H3(1),[G1H3(1)])
  call ol_merge(ntry,G2H2(9),[G2H2(4)])
call HGT_w2_OLR(G1H3(2),1,1,3)
call HGT_w2_invQ_OLR(G1H3(2),2,5,3)
  call ol_merge(ntry,G1H3(2),[G1H3(26)])
  call ol_merge(ntry,G2H2(12),[G2H2(11),G2H2(7),G2H2(6)])
  call ol_merge(ntry,G2H3(3),[G1H3(42)])
call HGT_w2_OLR(G1H3(4),1,1,3)
call HGT_w2_invQ_OLR(G1H3(4),2,5,3)
  call ol_merge(ntry,G2H3(3),[G1H3(4)])
call HGT_w2_OLR(G1H3(5),1,1,3)
call HGT_w2_invQ_OLR(G1H3(5),2,5,3)
  call ol_merge(ntry,G1H3(5),[G1H3(48)])
  call ol_merge(ntry,G2H3(7),[G1H3(10)])
  call ol_merge(ntry,G2H3(107),[G1H3(17)])
  call ol_merge(ntry,G2H3(23),[G1H3(21)])
  call ol_merge(ntry,G2H3(26),[G1H3(27)])
  call ol_merge(ntry,G2H3(10),[G1H3(32)])
  call ol_merge(ntry,G2H3(101),[G1H3(39)])
  call ol_merge(ntry,G2H3(27),[G1H3(43)])
  call ol_merge(ntry,G2H3(30),[G1H3(49)])
  call ol_merge(ntry,G2H3(11),[G1H3(53)])
  call ol_merge(ntry,G2H3(31),[G1H3(54)])
  call ol_merge(ntry,G2H3(34),[G1H3(60)])
  call ol_merge(ntry,G2H3(14),[G1H3(64)])
  call ol_merge(ntry,G2H3(35),[G1H3(65)])
  call ol_merge(ntry,G2H3(38),[G1H3(71)])
  call ol_merge(ntry,G2H2(25),[G2H2(8)])
  call ol_merge(ntry,G2H2(19),[G2H2(10)])
  call ol_merge(ntry,G2H2(28),[G2H2(15)])
  call ol_merge(ntry,G2H2(22),[G2H2(16)])
call HGT_OLR(G2H2(1),1,1,2)
call HGT_invQ_OLR(G2H2(1),2,5,2)
call HGT_OLR(G2H2(1),6,15,2)
call Hotf_4pt_reduction(G2H2(1),RedSet_4(37),mass4set(:,1),  & 
G1H2(1),G1H2(2),G1H2(3),G1H2(4),G1H2(5),2)
call HG1shiftOLR(G1H2(2),2,2)
call Hotf_4pt_reduction(G2H3(105),RedSet_4(16),mass4set(:,1),  & 
G1H3(11),G1H3(22),G1H3(33),G1H3(31),G1H3(44),3)
call HG1shiftOLR(G1H3(22),8,3)
call HGT_OLR(G2H3(5),1,1,3)
call HGT_invQ_OLR(G2H3(5),2,5,3)
call HGT_OLR(G2H3(5),6,15,3)
call Hotf_4pt_reduction(G2H3(5),RedSet_4(38),mass4set(:,1),  & 
G1H3(55),G1H3(9),G1H3(66),G1H3(20),G1H3(1),3)
call HG1shiftOLR(G1H3(9),4,3)
call Hotf_4pt_reduction(G2H3(15),RedSet_4(20),mass4set(:,1),  & 
G1H3(26),G1H3(42),G1H3(4),G1H3(48),G1H3(10),3)
call HG1shiftOLR(G1H3(42),8,3)
call HGT_OLR(G2H2(2),1,1,2)
call HGT_invQ_OLR(G2H2(2),2,5,2)
call HGT_OLR(G2H2(2),6,15,2)
call Hotf_4pt_reduction(G2H2(2),RedSet_4(39),mass4set(:,1),  & 
G1H2(6),G1H2(7),G1H2(8),G1H2(9),G1H2(10),2)
call HG1shiftOLR(G1H2(7),1,2)
call Hotf_4pt_reduction(G2H3(99),RedSet_4(16),mass4set(:,1),  & 
G1H3(17),G1H3(21),G1H3(27),G1H3(32),G1H3(39),3)
call HG1shiftOLR(G1H3(21),8,3)
call Hotf_4pt_reduction(G2H3(12),RedSet_4(22),mass4set(:,1),  & 
G1H3(43),G1H3(49),G1H3(53),G1H3(54),G1H3(60),3)
call HG1shiftOLR(G1H3(49),8,3)
call Hotf_4pt_reduction(G2H3(19),RedSet_4(27),mass4set(:,1),  & 
G1H3(64),G1H3(65),G1H3(71),G1H3(75),G1H3(76),3)
call HG1shiftOLR(G1H3(65),4,3)
call HGT_OLR(G2H3(16),1,1,3)
call HGT_invQ_OLR(G2H3(16),2,5,3)
call HGT_OLR(G2H3(16),6,15,3)
call Hotf_4pt_reduction(G2H3(16),RedSet_4(40),mass4set(:,1),  & 
G1H3(77),G1H3(78),G1H3(79),G1H3(80),G1H3(81),3)
call HG1shiftOLR(G1H3(78),4,3)
call Hotf_4pt_reduction(G2H3(18),RedSet_4(30),mass4set(:,1),  & 
G1H3(82),G1H3(83),G1H3(84),G1H3(85),G1H3(86),3)
call HG1shiftOLR(G1H3(83),8,3)
call Hotf_4pt_reduction(G2H3(20),RedSet_4(14),mass4set(:,1),  & 
G1H3(87),G1H3(88),G1H3(89),G1H3(90),G1H3(91),3)
call HG1shiftOLR(G1H3(88),8,3)
call Hotf_4pt_reduction(G2H3(22),RedSet_4(33),mass4set(:,1),  & 
G1H3(92),G1H3(93),G1H3(94),G1H3(95),G1H3(96),3)
call HG1shiftOLR(G1H3(93),4,3)
call Hotf_4pt_reduction(G2H3(1),RedSet_4(18),mass4set(:,1),  & 
G1H3(97),G1H3(98),G1H3(99),G1H3(100),G1H3(101),3)
call HG1shiftOLR(G1H3(98),8,3)
  call Hcheck_last_QA_V(ntry,l_switch,G2H2(9),ex2(:),G2tensor(1),m3h2x1(:,5),heltab2x2(:,:,5))
  call Hloop_QZ_A(ntry,G1H3(2),ex4(:),G1H1(1),ngZd,m3h3x1(:,25),heltab2x3(:,:,25))
  call Hcheck_last_Q_A(ntry,l_switch,G1H1(1),31,0,G2tensor(3),n2h1(25))
  call Hcheck_last_QA_V(ntry,l_switch,G2H2(12),ex2(:),G2tensor(5),m3h2x1(:,6),heltab2x2(:,:,6))
call HGT_w2_OLR(G1H3(3),1,1,3)
call HGT_w2_invQ_OLR(G1H3(3),2,5,3)
  call Hloop_QZ_A(ntry,G1H3(3),ex4(:),G1H1(1),ngZd,m3h3x1(:,26),heltab2x3(:,:,26))
  call Hcheck_last_Q_A(ntry,l_switch,G1H1(1),8,0,G2tensor(9),n2h1(26))
call Hotf_4pt_reduction(G2H3(3),RedSet_4(25),mass4set(:,1),  & 
G1H3(2),G1H3(3),G1H3(102),G1H3(103),G1H3(104),3)
call HG1shiftOLR(G1H3(3),4,3)
  call Hloop_QZ_A(ntry,G1H3(5),ex3(:),G1H1(1),ngZd,m3h3x1(:,27),heltab2x3(:,:,27))
  call Hcheck_last_Q_A(ntry,l_switch,G1H1(1),31,0,G2tensor(13),n2h1(27))
call HGT_w2_OLR(G1H3(6),1,1,3)
call HGT_w2_invQ_OLR(G1H3(6),2,5,3)
  call Hloop_QZ_A(ntry,G1H3(6),ex3(:),G1H1(1),ngZd,m3h3x1(:,28),heltab2x3(:,:,28))
  call Hcheck_last_Q_A(ntry,l_switch,G1H1(1),4,0,G2tensor(17),n2h1(28))
call Hotf_4pt_reduction(G2H3(7),RedSet_4(15),mass4set(:,1),  & 
G1H3(5),G1H3(6),G1H3(105),G1H3(106),G1H3(107),3)
call HG1shiftOLR(G1H3(6),8,3)
  call Hloop_AZ_Q(ntry,G1H3(15),ex4(:),G1H1(1),ngZd,m3h3x1(:,29),heltab2x3(:,:,29))
  call Hcheck_last_A_Q(ntry,l_switch,G1H1(1),31,0,G2tensor(21),n2h1(29))
  call Hloop_AZ_Q(ntry,G1H3(16),ex4(:),G1H1(1),ngZd,m3h3x1(:,30),heltab2x3(:,:,30))
  call Hcheck_last_A_Q(ntry,l_switch,G1H1(1),31,0,G2tensor(25),n2h1(30))
  call Hloop_AZ_Q(ntry,G2H3(107),ex4(:),G2H1(1),ngZd,m3h3x1(:,31),heltab2x3(:,:,31))
  call Hcheck_last_A_Q(ntry,l_switch,G2H1(1),31,0,G3tensor(1),n2h1(31))
call Hotf_4pt_reduction(G2H3(23),RedSet_4(19),mass4set(:,1),  & 
G1H3(15),G1H3(16),G1H3(108),G1H3(109),G1H3(110),3)
call HG1shiftOLR(G1H3(16),8,3)
  call Hloop_QZ_A(ntry,G2H3(26),ex4(:),G2H1(1),ngZd,m3h3x1(:,32),heltab2x3(:,:,32))
  call Hcheck_last_Q_A(ntry,l_switch,G2H1(1),31,0,G3tensor(2),n2h1(32))
  call Hloop_QZ_A(ntry,G1H3(28),ex4(:),G1H1(1),ngZd,m3h3x1(:,33),heltab2x3(:,:,33))
  call Hcheck_last_Q_A(ntry,l_switch,G1H1(1),31,0,G2tensor(29),n2h1(33))
call Hotf_4pt_reduction(G2H3(10),RedSet_4(23),mass4set(:,1),  & 
G1H3(28),G1H3(111),G1H3(112),G1H3(113),G1H3(114),3)
call HG1shiftOLR(G1H3(111),8,3)
  call Hloop_QZ_A(ntry,G1H3(37),ex4(:),G1H1(1),ngZd,m3h3x1(:,34),heltab2x3(:,:,34))
  call Hcheck_last_Q_A(ntry,l_switch,G1H1(1),31,0,G2tensor(30),n2h1(34))
  call Hloop_QZ_A(ntry,G1H3(38),ex4(:),G1H1(1),ngZd,m3h3x1(:,35),heltab2x3(:,:,35))
  call Hcheck_last_Q_A(ntry,l_switch,G1H1(1),31,0,G2tensor(31),n2h1(35))
  call Hloop_QZ_A(ntry,G2H3(101),ex4(:),G2H1(1),ngZd,m3h3x1(:,36),heltab2x3(:,:,36))
  call Hcheck_last_Q_A(ntry,l_switch,G2H1(1),31,0,G3tensor(3),n2h1(36))
call Hotf_4pt_reduction(G2H3(27),RedSet_4(26),mass4set(:,1),  & 
G1H3(37),G1H3(38),G1H3(115),G1H3(116),G1H3(117),3)
call HG1shiftOLR(G1H3(38),4,3)
  call Hloop_QZ_A(ntry,G2H3(30),ex3(:),G2H1(1),ngZd,m3h3x1(:,37),heltab2x3(:,:,37))
  call Hcheck_last_Q_A(ntry,l_switch,G2H1(1),31,0,G3tensor(4),n2h1(37))
  call Hloop_QZ_A(ntry,G1H3(50),ex3(:),G1H1(1),ngZd,m3h3x1(:,38),heltab2x3(:,:,38))
  call Hcheck_last_Q_A(ntry,l_switch,G1H1(1),31,0,G2tensor(32),n2h1(38))
call Hotf_4pt_reduction(G2H3(11),RedSet_4(29),mass4set(:,1),  & 
G1H3(50),G1H3(118),G1H3(119),G1H3(120),G1H3(121),3)
call HG1shiftOLR(G1H3(118),8,3)
call Hotf_4pt_reduction(G2H3(31),RedSet_4(19),mass4set(:,1),  & 
G1H3(122),G1H3(123),G1H3(124),G1H3(125),G1H3(126),3)
call HG1shiftOLR(G1H3(123),8,3)
  call Hloop_AZ_Q(ntry,G1H3(59),ex4(:),G1H1(1),ngZd,m3h3x1(:,39),heltab2x3(:,:,39))
  call Hcheck_last_A_Q(ntry,l_switch,G1H1(1),31,0,G2tensor(33),n2h1(39))
  call Hloop_AZ_Q(ntry,G2H3(34),ex4(:),G2H1(1),ngZd,m3h3x1(:,40),heltab2x3(:,:,40))
  call Hcheck_last_A_Q(ntry,l_switch,G2H1(1),31,0,G3tensor(5),n2h1(40))
  call Hloop_AZ_Q(ntry,G1H3(61),ex4(:),G1H1(1),ngZd,m3h3x1(:,41),heltab2x3(:,:,41))
  call Hcheck_last_A_Q(ntry,l_switch,G1H1(1),31,0,G2tensor(34),n2h1(41))
call Hotf_4pt_reduction(G2H3(14),RedSet_4(32),mass4set(:,1),  & 
G1H3(59),G1H3(61),G1H3(127),G1H3(128),G1H3(129),3)
call HG1shiftOLR(G1H3(61),4,3)
call Hotf_4pt_reduction(G2H3(35),RedSet_4(26),mass4set(:,1),  & 
G1H3(130),G1H3(131),G1H3(132),G1H3(133),G1H3(134),3)
call HG1shiftOLR(G1H3(131),4,3)
  call Hloop_AZ_Q(ntry,G1H3(70),ex3(:),G1H1(1),ngZd,m3h3x1(:,42),heltab2x3(:,:,42))
  call Hcheck_last_A_Q(ntry,l_switch,G1H1(1),31,0,G2tensor(35),n2h1(42))
  call Hloop_AZ_Q(ntry,G2H3(38),ex3(:),G2H1(1),ngZd,m3h3x1(:,43),heltab2x3(:,:,43))
  call Hcheck_last_A_Q(ntry,l_switch,G2H1(1),31,0,G3tensor(6),n2h1(43))
  call Hloop_AZ_Q(ntry,G1H3(72),ex3(:),G1H1(1),ngZd,m3h3x1(:,44),heltab2x3(:,:,44))
  call Hcheck_last_A_Q(ntry,l_switch,G1H1(1),31,0,G2tensor(36),n2h1(44))
  call Hcheck_last_QA_V(ntry,l_switch,G2H2(25),ex2(:),G2tensor(37),m3h2x1(:,7),heltab2x2(:,:,7))
  call Hcheck_last_QA_V(ntry,l_switch,G2H2(19),ex2(:),G2tensor(38),m3h2x1(:,8),heltab2x2(:,:,8))
  call Hcheck_last_QA_V(ntry,l_switch,G2H2(28),ex2(:),G2tensor(39),m3h2x1(:,9),heltab2x2(:,:,9))
  call Hcheck_last_QA_V(ntry,l_switch,G2H2(22),ex2(:),G2tensor(40),m3h2x1(:,10),heltab2x2(:,:,10))
call Hotf_4pt_reduction(G2H6(6),RedSet_4(6),mass4set(:,1),  & 
G1H6(3),G1H6(33),G1H6(9),G1H6(34),G1H6(21),6)
call HG1shiftOLR(G1H6(33),9,6)
call Hotf_4pt_reduction(G2H6(7),RedSet_4(4),mass4set(:,1),  & 
G1H6(22),G1H6(26),G1H6(27),G1H6(37),G1H6(38),6)
call HG1shiftOLR(G1H6(26),10,6)
  call Hcheck_last_QA_V(ntry,l_switch,G2H2(17),ex2(:),G2tensor(41),m3h2x1(:,11),heltab2x2(:,:,11))
  call Hcheck_last_QA_V(ntry,l_switch,G2H2(20),ex2(:),G2tensor(42),m3h2x1(:,12),heltab2x2(:,:,12))
  call Hloop_QZ_A(ntry,G1H3(36),ex4(:),G1H1(1),ngZd,m3h3x1(:,45),heltab2x3(:,:,45))
  call Hcheck_last_Q_A(ntry,l_switch,G1H1(1),31,0,G2tensor(43),n2h1(45))
  call Hloop_QZ_A(ntry,G1H3(47),ex3(:),G1H1(1),ngZd,m3h3x1(:,46),heltab2x3(:,:,46))
  call Hcheck_last_Q_A(ntry,l_switch,G1H1(1),31,0,G2tensor(44),n2h1(46))
  call Hloop_AZ_Q(ntry,G1H3(58),ex4(:),G1H1(1),ngZd,m3h3x1(:,47),heltab2x3(:,:,47))
  call Hcheck_last_A_Q(ntry,l_switch,G1H1(1),31,0,G2tensor(45),n2h1(47))
  call Hloop_AZ_Q(ntry,G1H3(69),ex3(:),G1H1(1),ngZd,m3h3x1(:,48),heltab2x3(:,:,48))
  call Hcheck_last_A_Q(ntry,l_switch,G1H1(1),31,0,G2tensor(46),n2h1(48))
  call Hcheck_last_QA_V(ntry,l_switch,G2H2(23),ex2(:),G2tensor(47),m3h2x1(:,13),heltab2x2(:,:,13))
  call Hcheck_last_QA_V(ntry,l_switch,G2H2(26),ex2(:),G2tensor(48),m3h2x1(:,14),heltab2x2(:,:,14))
call Hotf_4pt_reduction(G2H3(39),RedSet_4(26),mass4set(:,1),  & 
G1H3(70),G1H3(72),G1H3(36),G1H3(47),G1H3(58),3)
call HG1shiftOLR(G1H3(72),4,3)
  call Hloop_QZ_A(ntry,G2H3(42),ex3(:),G2H1(1),ngZu,m3h3x1(:,49),heltab2x3(:,:,49))
  call Hcheck_last_Q_A(ntry,l_switch,G2H1(1),31,0,G3tensor(7),n2h1(49))
  call Hloop_QZ_A(ntry,G1H3(67),ex3(:),G1H1(1),ngZu,m3h3x1(:,50),heltab2x3(:,:,50))
  call Hcheck_last_Q_A(ntry,l_switch,G1H1(1),31,0,G2tensor(49),n2h1(50))
call Hotf_4pt_reduction(G2H3(43),RedSet_4(26),mass4set(:,2),  & 
G1H3(69),G1H3(67),G1H3(135),G1H3(136),G1H3(137),3)
call HG1shiftOLR(G1H3(67),4,3)
  call Hloop_QZ_A(ntry,G2H3(46),ex3(:),G2H1(1),ngZu,m3h3x1(:,51),heltab2x3(:,:,51))
  call Hcheck_last_Q_A(ntry,l_switch,G2H1(1),31,nMT,G3tensor(8),n2h1(51))
  call Hloop_QZ_A(ntry,G1H3(14),ex3(:),G1H1(1),ngZu,m3h3x1(:,52),heltab2x3(:,:,52))
  call Hcheck_last_Q_A(ntry,l_switch,G1H1(1),31,nMT,G2tensor(50),n2h1(52))
call Hotf_4pt_reduction(G2H3(47),RedSet_4(26),mass4set(:,1),  & 
G1H3(14),G1H3(138),G1H3(139),G1H3(140),G1H3(141),3)
call HG1shiftOLR(G1H3(138),4,3)
  call Hloop_AZ_Q(ntry,G2H3(50),ex3(:),G2H1(1),ngZu,m3h3x1(:,53),heltab2x3(:,:,53))
  call Hcheck_last_A_Q(ntry,l_switch,G2H1(1),31,0,G3tensor(9),n2h1(53))
  call Hloop_AZ_Q(ntry,G1H3(30),ex3(:),G1H1(1),ngZu,m3h3x1(:,54),heltab2x3(:,:,54))
  call Hcheck_last_A_Q(ntry,l_switch,G1H1(1),31,0,G2tensor(51),n2h1(54))
call Hotf_4pt_reduction(G2H3(51),RedSet_4(26),mass4set(:,2),  & 
G1H3(30),G1H3(142),G1H3(143),G1H3(144),G1H3(145),3)
call HG1shiftOLR(G1H3(142),4,3)
  call Hloop_AZ_Q(ntry,G2H3(54),ex3(:),G2H1(1),ngZu,m3h3x1(:,55),heltab2x3(:,:,55))
  call Hcheck_last_A_Q(ntry,l_switch,G2H1(1),31,nMT,G3tensor(10),n2h1(55))
  call Hloop_AZ_Q(ntry,G1H3(46),ex3(:),G1H1(1),ngZu,m3h3x1(:,56),heltab2x3(:,:,56))
  call Hcheck_last_A_Q(ntry,l_switch,G1H1(1),31,nMT,G2tensor(52),n2h1(56))
call Hotf_4pt_reduction(G2H3(55),RedSet_4(26),mass4set(:,3),  & 
G1H3(46),G1H3(146),G1H3(147),G1H3(148),G1H3(149),3)
call HG1shiftOLR(G1H3(146),4,3)
  call Hloop_QZ_A(ntry,G2H3(58),ex3(:),G2H1(1),ngZd,m3h3x1(:,57),heltab2x3(:,:,57))
  call Hcheck_last_Q_A(ntry,l_switch,G2H1(1),31,nMB,G3tensor(11),n2h1(57))
  call Hloop_QZ_A(ntry,G1H3(62),ex3(:),G1H1(1),ngZd,m3h3x1(:,58),heltab2x3(:,:,58))
  call Hcheck_last_Q_A(ntry,l_switch,G1H1(1),31,nMB,G2tensor(53),n2h1(58))
call Hotf_4pt_reduction(G2H3(59),RedSet_4(26),mass4set(:,3),  & 
G1H3(62),G1H3(150),G1H3(151),G1H3(152),G1H3(153),3)
call HG1shiftOLR(G1H3(150),4,3)
  call Hloop_AZ_Q(ntry,G2H3(62),ex3(:),G2H1(1),ngZd,m3h3x1(:,59),heltab2x3(:,:,59))
  call Hcheck_last_A_Q(ntry,l_switch,G2H1(1),31,nMB,G3tensor(12),n2h1(59))
  call Hloop_AZ_Q(ntry,G1H3(45),ex3(:),G1H1(1),ngZd,m3h3x1(:,60),heltab2x3(:,:,60))
  call Hcheck_last_A_Q(ntry,l_switch,G1H1(1),31,nMB,G2tensor(54),n2h1(60))
call Hotf_4pt_reduction(G2H3(63),RedSet_4(19),mass4set(:,1),  & 
G1H3(45),G1H3(154),G1H3(155),G1H3(156),G1H3(157),3)
call HG1shiftOLR(G1H3(154),8,3)
  call Hloop_AZ_Q(ntry,G2H3(66),ex4(:),G2H1(1),ngZu,m3h3x1(:,61),heltab2x3(:,:,61))
  call Hcheck_last_A_Q(ntry,l_switch,G2H1(1),31,0,G3tensor(13),n2h1(61))
  call Hloop_AZ_Q(ntry,G1H3(13),ex4(:),G1H1(1),ngZu,m3h3x1(:,62),heltab2x3(:,:,62))
  call Hcheck_last_A_Q(ntry,l_switch,G1H1(1),31,0,G2tensor(55),n2h1(62))
call Hotf_4pt_reduction(G2H3(67),RedSet_4(19),mass4set(:,2),  & 
G1H3(13),G1H3(158),G1H3(159),G1H3(160),G1H3(161),3)
call HG1shiftOLR(G1H3(158),8,3)
  call Hloop_AZ_Q(ntry,G2H3(70),ex4(:),G2H1(1),ngZu,m3h3x1(:,63),heltab2x3(:,:,63))
  call Hcheck_last_A_Q(ntry,l_switch,G2H1(1),31,nMT,G3tensor(14),n2h1(63))
  call Hloop_AZ_Q(ntry,G1H3(35),ex4(:),G1H1(1),ngZu,m3h3x1(:,64),heltab2x3(:,:,64))
  call Hcheck_last_A_Q(ntry,l_switch,G1H1(1),31,nMT,G2tensor(56),n2h1(64))
call Hotf_4pt_reduction(G2H3(71),RedSet_4(19),mass4set(:,1),  & 
G1H3(35),G1H3(162),G1H3(163),G1H3(164),G1H3(165),3)
call HG1shiftOLR(G1H3(162),8,3)
  call Hloop_QZ_A(ntry,G2H3(74),ex4(:),G2H1(1),ngZu,m3h3x1(:,65),heltab2x3(:,:,65))
  call Hcheck_last_Q_A(ntry,l_switch,G2H1(1),31,0,G3tensor(15),n2h1(65))
  call Hloop_QZ_A(ntry,G1H3(52),ex4(:),G1H1(1),ngZu,m3h3x1(:,66),heltab2x3(:,:,66))
  call Hcheck_last_Q_A(ntry,l_switch,G1H1(1),31,0,G2tensor(57),n2h1(66))
call Hotf_4pt_reduction(G2H3(75),RedSet_4(19),mass4set(:,2),  & 
G1H3(52),G1H3(166),G1H3(167),G1H3(168),G1H3(169),3)
call HG1shiftOLR(G1H3(166),8,3)
  call Hloop_QZ_A(ntry,G2H3(78),ex4(:),G2H1(1),ngZu,m3h3x1(:,67),heltab2x3(:,:,67))
  call Hcheck_last_Q_A(ntry,l_switch,G2H1(1),31,nMT,G3tensor(16),n2h1(67))
  call Hloop_QZ_A(ntry,G1H3(34),ex4(:),G1H1(1),ngZu,m3h3x1(:,68),heltab2x3(:,:,68))
  call Hcheck_last_Q_A(ntry,l_switch,G1H1(1),31,nMT,G2tensor(58),n2h1(68))
call Hotf_4pt_reduction(G2H3(79),RedSet_4(19),mass4set(:,3),  & 
G1H3(34),G1H3(170),G1H3(171),G1H3(172),G1H3(173),3)
call HG1shiftOLR(G1H3(170),8,3)
  call Hloop_AZ_Q(ntry,G2H3(82),ex4(:),G2H1(1),ngZd,m3h3x1(:,69),heltab2x3(:,:,69))
  call Hcheck_last_A_Q(ntry,l_switch,G2H1(1),31,nMB,G3tensor(17),n2h1(69))
  call Hloop_AZ_Q(ntry,G1H3(18),ex4(:),G1H1(1),ngZd,m3h3x1(:,70),heltab2x3(:,:,70))
  call Hcheck_last_A_Q(ntry,l_switch,G1H1(1),31,nMB,G2tensor(59),n2h1(70))
call Hotf_4pt_reduction(G2H3(83),RedSet_4(19),mass4set(:,3),  & 
G1H3(18),G1H3(174),G1H3(175),G1H3(176),G1H3(177),3)
call HG1shiftOLR(G1H3(174),8,3)
  call Hloop_QZ_A(ntry,G2H3(86),ex4(:),G2H1(1),ngZd,m3h3x1(:,71),heltab2x3(:,:,71))
  call Hcheck_last_Q_A(ntry,l_switch,G2H1(1),31,nMB,G3tensor(18),n2h1(71))
  call Hloop_QZ_A(ntry,G1H3(41),ex4(:),G1H1(1),ngZd,m3h3x1(:,72),heltab2x3(:,:,72))
  call Hcheck_last_Q_A(ntry,l_switch,G1H1(1),31,nMB,G2tensor(60),n2h1(72))
call Hotf_4pt_reduction(G2H3(87),RedSet_4(16),mass4set(:,1),  & 
G1H3(41),G1H3(178),G1H3(179),G1H3(180),G1H3(181),3)
call HG1shiftOLR(G1H3(178),8,3)
  call Hloop_QZ_A(ntry,G2H3(89),ex4(:),G2H1(1),ngZu,m3h3x1(:,73),heltab2x3(:,:,73))
  call Hcheck_last_Q_A(ntry,l_switch,G2H1(1),31,0,G3tensor(19),n2h1(73))
  call Hloop_QZ_A(ntry,G1H3(68),ex4(:),G1H1(1),ngZu,m3h3x1(:,74),heltab2x3(:,:,74))
  call Hcheck_last_Q_A(ntry,l_switch,G1H1(1),31,0,G2tensor(61),n2h1(74))
call Hotf_4pt_reduction(G2H3(90),RedSet_4(16),mass4set(:,2),  & 
G1H3(68),G1H3(182),G1H3(183),G1H3(184),G1H3(185),3)
call HG1shiftOLR(G1H3(182),8,3)
  call Hloop_QZ_A(ntry,G2H3(92),ex4(:),G2H1(1),ngZu,m3h3x1(:,75),heltab2x3(:,:,75))
  call Hcheck_last_Q_A(ntry,l_switch,G2H1(1),31,nMT,G3tensor(20),n2h1(75))
  call Hloop_QZ_A(ntry,G1H3(19),ex4(:),G1H1(1),ngZu,m3h3x1(:,76),heltab2x3(:,:,76))
  call Hcheck_last_Q_A(ntry,l_switch,G1H1(1),31,nMT,G2tensor(62),n2h1(76))
call Hotf_4pt_reduction(G2H3(93),RedSet_4(16),mass4set(:,1),  & 
G1H3(19),G1H3(186),G1H3(187),G1H3(188),G1H3(189),3)
call HG1shiftOLR(G1H3(186),8,3)
  call Hloop_AZ_Q(ntry,G2H3(95),ex4(:),G2H1(1),ngZu,m3h3x1(:,77),heltab2x3(:,:,77))
  call Hcheck_last_A_Q(ntry,l_switch,G2H1(1),31,0,G3tensor(21),n2h1(77))
  call Hloop_AZ_Q(ntry,G1H3(57),ex4(:),G1H1(1),ngZu,m3h3x1(:,78),heltab2x3(:,:,78))
  call Hcheck_last_A_Q(ntry,l_switch,G1H1(1),31,0,G2tensor(63),n2h1(78))
call Hotf_4pt_reduction(G2H3(96),RedSet_4(16),mass4set(:,2),  & 
G1H3(57),G1H3(190),G1H3(191),G1H3(192),G1H3(193),3)
call HG1shiftOLR(G1H3(190),8,3)
  call Hloop_AZ_Q(ntry,G2H3(98),ex4(:),G2H1(1),ngZu,m3h3x1(:,79),heltab2x3(:,:,79))
  call Hcheck_last_A_Q(ntry,l_switch,G2H1(1),31,nMT,G3tensor(22),n2h1(79))
  call Hloop_AZ_Q(ntry,G1H3(8),ex4(:),G1H1(1),ngZu,m3h3x1(:,80),heltab2x3(:,:,80))
  call Hcheck_last_A_Q(ntry,l_switch,G1H1(1),31,nMT,G2tensor(64),n2h1(80))
  call Hloop_QZ_A(ntry,G1H3(63),ex4(:),G1H1(1),ngZd,m3h3x1(:,81),heltab2x3(:,:,81))
  call Hcheck_last_Q_A(ntry,l_switch,G1H1(1),31,0,G2tensor(65),n2h1(81))
call Hotf_4pt_reduction(G2H3(102),RedSet_4(16),mass4set(:,3),  & 
G1H3(8),G1H3(63),G1H3(194),G1H3(195),G1H3(196),3)
call HG1shiftOLR(G1H3(63),8,3)
  call Hloop_QZ_A(ntry,G2H3(104),ex4(:),G2H1(1),ngZd,m3h3x1(:,82),heltab2x3(:,:,82))
  call Hcheck_last_Q_A(ntry,l_switch,G2H1(1),31,nMB,G3tensor(23),n2h1(82))
  call Hloop_QZ_A(ntry,G1H3(40),ex4(:),G1H1(1),ngZd,m3h3x1(:,83),heltab2x3(:,:,83))
  call Hcheck_last_Q_A(ntry,l_switch,G1H1(1),31,nMB,G2tensor(66),n2h1(83))
  call Hloop_AZ_Q(ntry,G1H3(29),ex4(:),G1H1(1),ngZd,m3h3x1(:,84),heltab2x3(:,:,84))
  call Hcheck_last_A_Q(ntry,l_switch,G1H1(1),31,0,G2tensor(67),n2h1(84))
call Hotf_4pt_reduction(G2H3(108),RedSet_4(16),mass4set(:,3),  & 
G1H3(40),G1H3(29),G1H3(197),G1H3(198),G1H3(199),3)
call HG1shiftOLR(G1H3(29),8,3)
  call Hloop_AZ_Q(ntry,G2H3(110),ex4(:),G2H1(1),ngZd,m3h3x1(:,85),heltab2x3(:,:,85))
  call Hcheck_last_A_Q(ntry,l_switch,G2H1(1),31,nMB,G3tensor(24),n2h1(85))
  call Hloop_AZ_Q(ntry,G1H3(51),ex4(:),G1H1(1),ngZd,m3h3x1(:,86),heltab2x3(:,:,86))
  call Hcheck_last_A_Q(ntry,l_switch,G1H1(1),31,nMB,G2tensor(68),n2h1(86))
  call Hcheck_last_AQ_V(ntry,l_switch,G2H6(9),wf6(:,3),G2tensor(69),m3h6x1(:,1),heltab2x6(:,:,53))
  call Hcheck_last_AQ_V(ntry,l_switch,G2H6(1),wf6(:,3),G2tensor(70),m3h6x1(:,2),heltab2x6(:,:,54))
  call Hcheck_last_QA_V(ntry,l_switch,G2H6(2),wf6(:,8),G2tensor(71),m3h6x1(:,3),heltab2x6(:,:,55))
  call Hcheck_last_QA_V(ntry,l_switch,G2H6(8),wf6(:,8),G2tensor(72),m3h6x1(:,4),heltab2x6(:,:,56))
  call Hcheck_last_AQ_V(ntry,l_switch,G2H6(3),wf6(:,7),G2tensor(73),m3h6x1(:,5),heltab2x6(:,:,57))
  call Hcheck_last_AQ_V(ntry,l_switch,G2H6(11),wf6(:,7),G2tensor(74),m3h6x1(:,6),heltab2x6(:,:,58))
  call Hcheck_last_QA_V(ntry,l_switch,G2H6(12),wf6(:,4),G2tensor(75),m3h6x1(:,7),heltab2x6(:,:,59))
  call Hcheck_last_QA_V(ntry,l_switch,G2H6(14),wf6(:,4),G2tensor(76),m3h6x1(:,8),heltab2x6(:,:,60))
  call Hloop_VA_Q(ntry,G1H2(1),ex2(:),G1H1(1),m3h2x1(:,15),heltab2x2(:,:,15))
  call Hcheck_last_A_Q(ntry,l_switch,G1H1(1),31,0,G2tensor(77),n2h1(87))
  call Hloop_VA_Q(ntry,G1H2(2),ex2(:),G1H1(1),m3h2x1(:,16),heltab2x2(:,:,16))
  call Hcheck_last_A_Q(ntry,l_switch,G1H1(1),2,0,G2tensor(78),n2h1(88))
  call Hloop_VA_Q(ntry,G1H2(5),ex2(:),G1H1(1),m3h2x1(:,17),heltab2x2(:,:,17))
  call Hcheck_last_A_Q(ntry,l_switch,G1H1(1),31,0,G2tensor(79),n2h1(89))
  call Hloop_AZ_Q(ntry,G1H3(11),ex4(:),G1H1(1),ngZd,m3h3x1(:,87),heltab2x3(:,:,87))
  call Hcheck_last_A_Q(ntry,l_switch,G1H1(1),31,0,G2tensor(80),n2h1(90))
  call Hloop_AZ_Q(ntry,G1H3(22),ex4(:),G1H1(1),ngZd,m3h3x1(:,88),heltab2x3(:,:,88))
  call Hcheck_last_A_Q(ntry,l_switch,G1H1(1),8,0,G2tensor(81),n2h1(91))
  call Hloop_AZ_Q(ntry,G1H3(44),ex4(:),G1H1(1),ngZd,m3h3x1(:,89),heltab2x3(:,:,89))
  call Hcheck_last_A_Q(ntry,l_switch,G1H1(1),31,0,G2tensor(82),n2h1(92))
  call Hloop_QZ_A(ntry,G1H3(55),ex3(:),G1H1(1),ngZd,m3h3x1(:,90),heltab2x3(:,:,90))
  call Hcheck_last_Q_A(ntry,l_switch,G1H1(1),31,0,G2tensor(83),n2h1(93))
  call Hloop_QZ_A(ntry,G1H3(9),ex3(:),G1H1(1),ngZd,m3h3x1(:,91),heltab2x3(:,:,91))
  call Hcheck_last_Q_A(ntry,l_switch,G1H1(1),4,0,G2tensor(84),n2h1(94))
  call Hloop_QZ_A(ntry,G1H3(1),ex3(:),G1H1(1),ngZd,m3h3x1(:,92),heltab2x3(:,:,92))
  call Hcheck_last_Q_A(ntry,l_switch,G1H1(1),31,0,G2tensor(85),n2h1(95))
  call Hloop_QZ_A(ntry,G1H3(26),ex4(:),G1H1(1),ngZd,m3h3x1(:,93),heltab2x3(:,:,93))
  call Hcheck_last_Q_A(ntry,l_switch,G1H1(1),31,0,G2tensor(86),n2h1(96))
  call Hloop_QZ_A(ntry,G1H3(42),ex4(:),G1H1(1),ngZd,m3h3x1(:,94),heltab2x3(:,:,94))
  call Hcheck_last_Q_A(ntry,l_switch,G1H1(1),8,0,G2tensor(87),n2h1(97))
  call Hloop_QZ_A(ntry,G1H3(10),ex4(:),G1H1(1),ngZd,m3h3x1(:,95),heltab2x3(:,:,95))
  call Hcheck_last_Q_A(ntry,l_switch,G1H1(1),31,0,G2tensor(88),n2h1(98))
  call Hloop_VQ_A(ntry,G1H2(6),ex1(:),G1H1(1),m3h2x1(:,18),heltab2x2(:,:,18))
  call Hcheck_last_Q_A(ntry,l_switch,G1H1(1),31,0,G2tensor(89),n2h1(99))
  call Hloop_VQ_A(ntry,G1H2(7),ex1(:),G1H1(1),m3h2x1(:,19),heltab2x2(:,:,19))
  call Hcheck_last_Q_A(ntry,l_switch,G1H1(1),1,0,G2tensor(90),n2h1(100))
  call Hloop_VQ_A(ntry,G1H2(10),ex1(:),G1H1(1),m3h2x1(:,20),heltab2x2(:,:,20))
  call Hcheck_last_Q_A(ntry,l_switch,G1H1(1),31,0,G2tensor(91),n2h1(101))
  call Hloop_QZ_A(ntry,G1H3(17),ex4(:),G1H1(1),ngZd,m3h3x1(:,96),heltab2x3(:,:,96))
  call Hcheck_last_Q_A(ntry,l_switch,G1H1(1),31,0,G2tensor(92),n2h1(102))
  call Hloop_QZ_A(ntry,G1H3(21),ex4(:),G1H1(1),ngZd,m3h3x1(:,97),heltab2x3(:,:,97))
  call Hcheck_last_Q_A(ntry,l_switch,G1H1(1),8,0,G2tensor(93),n2h1(103))
  call Hloop_QZ_A(ntry,G1H3(39),ex4(:),G1H1(1),ngZd,m3h3x1(:,98),heltab2x3(:,:,98))
  call Hcheck_last_Q_A(ntry,l_switch,G1H1(1),31,0,G2tensor(94),n2h1(104))
  call Hloop_QZ_A(ntry,G1H3(43),ex4(:),G1H1(1),ngZd,m3h3x1(:,99),heltab2x3(:,:,99))
  call Hcheck_last_Q_A(ntry,l_switch,G1H1(1),31,0,G2tensor(95),n2h1(105))
  call Hloop_QZ_A(ntry,G1H3(49),ex4(:),G1H1(1),ngZd,m3h3x1(:,100),heltab2x3(:,:,100))
  call Hcheck_last_Q_A(ntry,l_switch,G1H1(1),8,0,G2tensor(96),n2h1(106))
  call Hloop_QZ_A(ntry,G1H3(60),ex4(:),G1H1(1),ngZd,m3h3x1(:,101),heltab2x3(:,:,101))
  call Hcheck_last_Q_A(ntry,l_switch,G1H1(1),31,0,G2tensor(97),n2h1(107))
  call Hloop_QZ_A(ntry,G1H3(64),ex3(:),G1H1(1),ngZd,m3h3x1(:,102),heltab2x3(:,:,102))
  call Hcheck_last_Q_A(ntry,l_switch,G1H1(1),31,0,G2tensor(98),n2h1(108))
  call Hloop_QZ_A(ntry,G1H3(65),ex3(:),G1H1(1),ngZd,m3h3x1(:,103),heltab2x3(:,:,103))
  call Hcheck_last_Q_A(ntry,l_switch,G1H1(1),4,0,G2tensor(99),n2h1(109))
  call Hloop_QZ_A(ntry,G1H3(76),ex3(:),G1H1(1),ngZd,m3h3x1(:,104),heltab2x3(:,:,104))
  call Hcheck_last_Q_A(ntry,l_switch,G1H1(1),31,0,G2tensor(100),n2h1(110))
  call Hloop_AZ_Q(ntry,G1H3(77),ex3(:),G1H1(1),ngZd,m3h3x1(:,105),heltab2x3(:,:,105))
  call Hcheck_last_A_Q(ntry,l_switch,G1H1(1),31,0,G2tensor(101),n2h1(111))
  call Hloop_AZ_Q(ntry,G1H3(78),ex3(:),G1H1(1),ngZd,m3h3x1(:,106),heltab2x3(:,:,106))
  call Hcheck_last_A_Q(ntry,l_switch,G1H1(1),4,0,G2tensor(102),n2h1(112))
  call Hloop_AZ_Q(ntry,G1H3(81),ex3(:),G1H1(1),ngZd,m3h3x1(:,107),heltab2x3(:,:,107))
  call Hcheck_last_A_Q(ntry,l_switch,G1H1(1),31,0,G2tensor(103),n2h1(113))
  call Hloop_AZ_Q(ntry,G1H3(82),ex4(:),G1H1(1),ngZd,m3h3x1(:,108),heltab2x3(:,:,108))
  call Hcheck_last_A_Q(ntry,l_switch,G1H1(1),31,0,G2tensor(104),n2h1(114))
  call Hloop_AZ_Q(ntry,G1H3(83),ex4(:),G1H1(1),ngZd,m3h3x1(:,109),heltab2x3(:,:,109))
  call Hcheck_last_A_Q(ntry,l_switch,G1H1(1),8,0,G2tensor(105),n2h1(115))
  call Hloop_AZ_Q(ntry,G1H3(86),ex4(:),G1H1(1),ngZd,m3h3x1(:,110),heltab2x3(:,:,110))
  call Hcheck_last_A_Q(ntry,l_switch,G1H1(1),31,0,G2tensor(106),n2h1(116))
  call Hloop_AZ_Q(ntry,G1H3(87),ex4(:),G1H1(1),ngZd,m3h3x1(:,111),heltab2x3(:,:,111))
  call Hcheck_last_A_Q(ntry,l_switch,G1H1(1),31,0,G2tensor(107),n2h1(117))
  call Hloop_AZ_Q(ntry,G1H3(88),ex4(:),G1H1(1),ngZd,m3h3x1(:,112),heltab2x3(:,:,112))
  call Hcheck_last_A_Q(ntry,l_switch,G1H1(1),8,0,G2tensor(108),n2h1(118))
  call Hloop_AZ_Q(ntry,G1H3(91),ex4(:),G1H1(1),ngZd,m3h3x1(:,113),heltab2x3(:,:,113))
  call Hcheck_last_A_Q(ntry,l_switch,G1H1(1),31,0,G2tensor(109),n2h1(119))
  call Hloop_AZ_Q(ntry,G1H3(92),ex3(:),G1H1(1),ngZd,m3h3x1(:,114),heltab2x3(:,:,114))
  call Hcheck_last_A_Q(ntry,l_switch,G1H1(1),31,0,G2tensor(110),n2h1(120))
  call Hloop_AZ_Q(ntry,G1H3(93),ex3(:),G1H1(1),ngZd,m3h3x1(:,115),heltab2x3(:,:,115))
  call Hcheck_last_A_Q(ntry,l_switch,G1H1(1),4,0,G2tensor(111),n2h1(121))
  call Hloop_AZ_Q(ntry,G1H3(96),ex3(:),G1H1(1),ngZd,m3h3x1(:,116),heltab2x3(:,:,116))
  call Hcheck_last_A_Q(ntry,l_switch,G1H1(1),31,0,G2tensor(112),n2h1(122))
  call Hloop_QZ_A(ntry,G1H3(97),ex4(:),G1H1(1),ngZd,m3h3x1(:,117),heltab2x3(:,:,117))
  call Hcheck_last_Q_A(ntry,l_switch,G1H1(1),31,0,G2tensor(113),n2h1(123))
  call Hloop_QZ_A(ntry,G1H3(98),ex4(:),G1H1(1),ngZd,m3h3x1(:,118),heltab2x3(:,:,118))
  call Hcheck_last_Q_A(ntry,l_switch,G1H1(1),8,0,G2tensor(114),n2h1(124))
  call Hloop_QZ_A(ntry,G1H3(101),ex4(:),G1H1(1),ngZd,m3h3x1(:,119),heltab2x3(:,:,119))
  call Hcheck_last_Q_A(ntry,l_switch,G1H1(1),31,0,G2tensor(115),n2h1(125))
  call Hloop_QZ_A(ntry,G1H3(2),ex3(:),G1H1(1),ngZd,m3h3x1(:,120),heltab2x3(:,:,120))
  call Hcheck_last_Q_A(ntry,l_switch,G1H1(1),31,0,G2tensor(116),n2h1(126))
  call Hloop_QZ_A(ntry,G1H3(3),ex3(:),G1H1(1),ngZd,m3h3x1(:,121),heltab2x3(:,:,121))
  call Hcheck_last_Q_A(ntry,l_switch,G1H1(1),4,0,G2tensor(117),n2h1(127))
  call Hloop_QZ_A(ntry,G1H3(104),ex3(:),G1H1(1),ngZd,m3h3x1(:,122),heltab2x3(:,:,122))
  call Hcheck_last_Q_A(ntry,l_switch,G1H1(1),31,0,G2tensor(118),n2h1(128))
  call Hloop_AZ_Q(ntry,G1H3(5),ex4(:),G1H1(1),ngZd,m3h3x1(:,123),heltab2x3(:,:,123))
  call Hcheck_last_A_Q(ntry,l_switch,G1H1(1),31,0,G2tensor(119),n2h1(129))
  call Hloop_AZ_Q(ntry,G1H3(6),ex4(:),G1H1(1),ngZd,m3h3x1(:,124),heltab2x3(:,:,124))
  call Hcheck_last_A_Q(ntry,l_switch,G1H1(1),8,0,G2tensor(120),n2h1(130))
  call Hloop_AZ_Q(ntry,G1H3(107),ex4(:),G1H1(1),ngZd,m3h3x1(:,125),heltab2x3(:,:,125))
  call Hcheck_last_A_Q(ntry,l_switch,G1H1(1),31,0,G2tensor(121),n2h1(131))
  call Hloop_QZ_A(ntry,G1H3(15),ex4(:),G1H1(1),ngZd,m3h3x1(:,126),heltab2x3(:,:,126))
  call Hcheck_last_Q_A(ntry,l_switch,G1H1(1),31,0,G2tensor(122),n2h1(132))
  call Hloop_QZ_A(ntry,G1H3(16),ex4(:),G1H1(1),ngZd,m3h3x1(:,127),heltab2x3(:,:,127))
  call Hcheck_last_Q_A(ntry,l_switch,G1H1(1),8,0,G2tensor(123),n2h1(133))
  call Hloop_QZ_A(ntry,G1H3(110),ex4(:),G1H1(1),ngZd,m3h3x1(:,128),heltab2x3(:,:,128))
  call Hcheck_last_Q_A(ntry,l_switch,G1H1(1),31,0,G2tensor(124),n2h1(134))
  call Hloop_QZ_A(ntry,G1H3(28),ex4(:),G1H1(1),ngZd,m3h3x1(:,129),heltab2x3(:,:,129))
  call Hcheck_last_Q_A(ntry,l_switch,G1H1(1),31,0,G2tensor(125),n2h1(135))
  call Hloop_QZ_A(ntry,G1H3(111),ex4(:),G1H1(1),ngZd,m3h3x1(:,130),heltab2x3(:,:,130))
  call Hcheck_last_Q_A(ntry,l_switch,G1H1(1),8,0,G2tensor(126),n2h1(136))
  call Hloop_QZ_A(ntry,G1H3(114),ex4(:),G1H1(1),ngZd,m3h3x1(:,131),heltab2x3(:,:,131))
  call Hcheck_last_Q_A(ntry,l_switch,G1H1(1),31,0,G2tensor(127),n2h1(137))
  call Hloop_QZ_A(ntry,G1H3(37),ex3(:),G1H1(1),ngZd,m3h3x1(:,132),heltab2x3(:,:,132))
  call Hcheck_last_Q_A(ntry,l_switch,G1H1(1),31,0,G2tensor(128),n2h1(138))
  call Hloop_QZ_A(ntry,G1H3(38),ex3(:),G1H1(1),ngZd,m3h3x1(:,133),heltab2x3(:,:,133))
  call Hcheck_last_Q_A(ntry,l_switch,G1H1(1),4,0,G2tensor(129),n2h1(139))
  call Hloop_QZ_A(ntry,G1H3(117),ex3(:),G1H1(1),ngZd,m3h3x1(:,134),heltab2x3(:,:,134))
  call Hcheck_last_Q_A(ntry,l_switch,G1H1(1),31,0,G2tensor(130),n2h1(140))
  call Hloop_AZ_Q(ntry,G1H3(50),ex4(:),G1H1(1),ngZd,m3h3x1(:,135),heltab2x3(:,:,135))
  call Hcheck_last_A_Q(ntry,l_switch,G1H1(1),31,0,G2tensor(131),n2h1(141))
  call Hloop_AZ_Q(ntry,G1H3(118),ex4(:),G1H1(1),ngZd,m3h3x1(:,136),heltab2x3(:,:,136))
  call Hcheck_last_A_Q(ntry,l_switch,G1H1(1),8,0,G2tensor(132),n2h1(142))
  call Hloop_AZ_Q(ntry,G1H3(121),ex4(:),G1H1(1),ngZd,m3h3x1(:,137),heltab2x3(:,:,137))
  call Hcheck_last_A_Q(ntry,l_switch,G1H1(1),31,0,G2tensor(133),n2h1(143))
  call Hloop_AZ_Q(ntry,G1H3(122),ex4(:),G1H1(1),ngZd,m3h3x1(:,138),heltab2x3(:,:,138))
  call Hcheck_last_A_Q(ntry,l_switch,G1H1(1),31,0,G2tensor(134),n2h1(144))
  call Hloop_AZ_Q(ntry,G1H3(123),ex4(:),G1H1(1),ngZd,m3h3x1(:,139),heltab2x3(:,:,139))
  call Hcheck_last_A_Q(ntry,l_switch,G1H1(1),8,0,G2tensor(135),n2h1(145))
  call Hloop_AZ_Q(ntry,G1H3(126),ex4(:),G1H1(1),ngZd,m3h3x1(:,140),heltab2x3(:,:,140))
  call Hcheck_last_A_Q(ntry,l_switch,G1H1(1),31,0,G2tensor(136),n2h1(146))
  call Hloop_AZ_Q(ntry,G1H3(59),ex3(:),G1H1(1),ngZd,m3h3x1(:,141),heltab2x3(:,:,141))
  call Hcheck_last_A_Q(ntry,l_switch,G1H1(1),31,0,G2tensor(137),n2h1(147))
  call Hloop_AZ_Q(ntry,G1H3(61),ex3(:),G1H1(1),ngZd,m3h3x1(:,142),heltab2x3(:,:,142))
  call Hcheck_last_A_Q(ntry,l_switch,G1H1(1),4,0,G2tensor(138),n2h1(148))
  call Hloop_AZ_Q(ntry,G1H3(129),ex3(:),G1H1(1),ngZd,m3h3x1(:,143),heltab2x3(:,:,143))
  call Hcheck_last_A_Q(ntry,l_switch,G1H1(1),31,0,G2tensor(139),n2h1(149))
  call Hloop_AZ_Q(ntry,G1H3(130),ex3(:),G1H1(1),ngZd,m3h3x1(:,144),heltab2x3(:,:,144))
  call Hcheck_last_A_Q(ntry,l_switch,G1H1(1),31,0,G2tensor(140),n2h1(150))
  call Hloop_AZ_Q(ntry,G1H3(131),ex3(:),G1H1(1),ngZd,m3h3x1(:,145),heltab2x3(:,:,145))
  call Hcheck_last_A_Q(ntry,l_switch,G1H1(1),4,0,G2tensor(141),n2h1(151))
  call Hloop_AZ_Q(ntry,G1H3(134),ex3(:),G1H1(1),ngZd,m3h3x1(:,146),heltab2x3(:,:,146))
  call Hcheck_last_A_Q(ntry,l_switch,G1H1(1),31,0,G2tensor(142),n2h1(152))
  call Hloop_VQ_A(ntry,G1H6(3),wf6(:,7),G1H1(1),m3h6x1(:,9),heltab2x6(:,:,61))
  call Hcheck_last_Q_A(ntry,l_switch,G1H1(1),31,0,G2tensor(143),n2h1(153))
  call Hloop_VQ_A(ntry,G1H6(33),wf6(:,7),G1H1(1),m3h6x1(:,10),heltab2x6(:,:,62))
  call Hcheck_last_Q_A(ntry,l_switch,G1H1(1),9,0,G2tensor(144),n2h1(154))
  call Hloop_VQ_A(ntry,G1H6(21),wf6(:,7),G1H1(1),m3h6x1(:,11),heltab2x6(:,:,63))
  call Hcheck_last_Q_A(ntry,l_switch,G1H1(1),31,0,G2tensor(145),n2h1(155))
  call Hloop_VA_Q(ntry,G1H6(22),wf6(:,4),G1H1(1),m3h6x1(:,12),heltab2x6(:,:,64))
  call Hcheck_last_A_Q(ntry,l_switch,G1H1(1),31,0,G2tensor(146),n2h1(156))
  call Hloop_VA_Q(ntry,G1H6(26),wf6(:,4),G1H1(1),m3h6x1(:,13),heltab2x6(:,:,65))
  call Hcheck_last_A_Q(ntry,l_switch,G1H1(1),10,0,G2tensor(147),n2h1(157))
  call Hloop_VA_Q(ntry,G1H6(38),wf6(:,4),G1H1(1),m3h6x1(:,14),heltab2x6(:,:,66))
  call Hcheck_last_A_Q(ntry,l_switch,G1H1(1),31,0,G2tensor(148),n2h1(158))
  call Hloop_QZ_A(ntry,G1H3(70),ex3(:),G1H1(1),ngZu,m3h3x1(:,147),heltab2x3(:,:,147))
  call Hcheck_last_Q_A(ntry,l_switch,G1H1(1),31,0,G2tensor(149),n2h1(159))
  call Hloop_QZ_A(ntry,G1H3(72),ex3(:),G1H1(1),ngZu,m3h3x1(:,148),heltab2x3(:,:,148))
  call Hcheck_last_Q_A(ntry,l_switch,G1H1(1),4,0,G2tensor(150),n2h1(160))
  call Hloop_QZ_A(ntry,G1H3(58),ex3(:),G1H1(1),ngZu,m3h3x1(:,149),heltab2x3(:,:,149))
  call Hcheck_last_Q_A(ntry,l_switch,G1H1(1),31,0,G2tensor(151),n2h1(161))
  call Hloop_QZ_A(ntry,G1H3(69),ex3(:),G1H1(1),ngZu,m3h3x1(:,150),heltab2x3(:,:,150))
  call Hcheck_last_Q_A(ntry,l_switch,G1H1(1),31,nMT,G2tensor(152),n2h1(162))
  call Hloop_QZ_A(ntry,G1H3(67),ex3(:),G1H1(1),ngZu,m3h3x1(:,151),heltab2x3(:,:,151))
  call Hcheck_last_Q_A(ntry,l_switch,G1H1(1),4,nMT,G2tensor(153),n2h1(163))
  call Hloop_QZ_A(ntry,G1H3(137),ex3(:),G1H1(1),ngZu,m3h3x1(:,152),heltab2x3(:,:,152))
  call Hcheck_last_Q_A(ntry,l_switch,G1H1(1),31,nMT,G2tensor(154),n2h1(164))
  call Hloop_AZ_Q(ntry,G1H3(14),ex3(:),G1H1(1),ngZu,m3h3x1(:,153),heltab2x3(:,:,153))
  call Hcheck_last_A_Q(ntry,l_switch,G1H1(1),31,0,G2tensor(155),n2h1(165))
  call Hloop_AZ_Q(ntry,G1H3(138),ex3(:),G1H1(1),ngZu,m3h3x1(:,154),heltab2x3(:,:,154))
  call Hcheck_last_A_Q(ntry,l_switch,G1H1(1),4,0,G2tensor(156),n2h1(166))
  call Hloop_AZ_Q(ntry,G1H3(141),ex3(:),G1H1(1),ngZu,m3h3x1(:,155),heltab2x3(:,:,155))
  call Hcheck_last_A_Q(ntry,l_switch,G1H1(1),31,0,G2tensor(157),n2h1(167))
  call Hloop_AZ_Q(ntry,G1H3(30),ex3(:),G1H1(1),ngZu,m3h3x1(:,156),heltab2x3(:,:,156))
  call Hcheck_last_A_Q(ntry,l_switch,G1H1(1),31,nMT,G2tensor(158),n2h1(168))
  call Hloop_AZ_Q(ntry,G1H3(142),ex3(:),G1H1(1),ngZu,m3h3x1(:,157),heltab2x3(:,:,157))
  call Hcheck_last_A_Q(ntry,l_switch,G1H1(1),4,nMT,G2tensor(159),n2h1(169))
  call Hloop_AZ_Q(ntry,G1H3(145),ex3(:),G1H1(1),ngZu,m3h3x1(:,158),heltab2x3(:,:,158))
  call Hcheck_last_A_Q(ntry,l_switch,G1H1(1),31,nMT,G2tensor(160),n2h1(170))
  call Hloop_QZ_A(ntry,G1H3(46),ex3(:),G1H1(1),ngZd,m3h3x1(:,159),heltab2x3(:,:,159))
  call Hcheck_last_Q_A(ntry,l_switch,G1H1(1),31,nMB,G2tensor(161),n2h1(171))
  call Hloop_QZ_A(ntry,G1H3(146),ex3(:),G1H1(1),ngZd,m3h3x1(:,160),heltab2x3(:,:,160))
  call Hcheck_last_Q_A(ntry,l_switch,G1H1(1),4,nMB,G2tensor(162),n2h1(172))
  call Hloop_QZ_A(ntry,G1H3(149),ex3(:),G1H1(1),ngZd,m3h3x1(:,161),heltab2x3(:,:,161))
  call Hcheck_last_Q_A(ntry,l_switch,G1H1(1),31,nMB,G2tensor(163),n2h1(173))
  call Hloop_AZ_Q(ntry,G1H3(62),ex3(:),G1H1(1),ngZd,m3h3x1(:,162),heltab2x3(:,:,162))
  call Hcheck_last_A_Q(ntry,l_switch,G1H1(1),31,nMB,G2tensor(164),n2h1(174))
  call Hloop_AZ_Q(ntry,G1H3(150),ex3(:),G1H1(1),ngZd,m3h3x1(:,163),heltab2x3(:,:,163))
  call Hcheck_last_A_Q(ntry,l_switch,G1H1(1),4,nMB,G2tensor(165),n2h1(175))
  call Hloop_AZ_Q(ntry,G1H3(153),ex3(:),G1H1(1),ngZd,m3h3x1(:,164),heltab2x3(:,:,164))
  call Hcheck_last_A_Q(ntry,l_switch,G1H1(1),31,nMB,G2tensor(166),n2h1(176))
  call Hloop_AZ_Q(ntry,G1H3(45),ex4(:),G1H1(1),ngZu,m3h3x1(:,165),heltab2x3(:,:,165))
  call Hcheck_last_A_Q(ntry,l_switch,G1H1(1),31,0,G2tensor(167),n2h1(177))
  call Hloop_AZ_Q(ntry,G1H3(154),ex4(:),G1H1(1),ngZu,m3h3x1(:,166),heltab2x3(:,:,166))
  call Hcheck_last_A_Q(ntry,l_switch,G1H1(1),8,0,G2tensor(168),n2h1(178))
  call Hloop_AZ_Q(ntry,G1H3(157),ex4(:),G1H1(1),ngZu,m3h3x1(:,167),heltab2x3(:,:,167))
  call Hcheck_last_A_Q(ntry,l_switch,G1H1(1),31,0,G2tensor(169),n2h1(179))
  call Hloop_AZ_Q(ntry,G1H3(13),ex4(:),G1H1(1),ngZu,m3h3x1(:,168),heltab2x3(:,:,168))
  call Hcheck_last_A_Q(ntry,l_switch,G1H1(1),31,nMT,G2tensor(170),n2h1(180))
  call Hloop_AZ_Q(ntry,G1H3(158),ex4(:),G1H1(1),ngZu,m3h3x1(:,169),heltab2x3(:,:,169))
  call Hcheck_last_A_Q(ntry,l_switch,G1H1(1),8,nMT,G2tensor(171),n2h1(181))
  call Hloop_AZ_Q(ntry,G1H3(161),ex4(:),G1H1(1),ngZu,m3h3x1(:,170),heltab2x3(:,:,170))
  call Hcheck_last_A_Q(ntry,l_switch,G1H1(1),31,nMT,G2tensor(172),n2h1(182))
  call Hloop_QZ_A(ntry,G1H3(35),ex4(:),G1H1(1),ngZu,m3h3x1(:,171),heltab2x3(:,:,171))
  call Hcheck_last_Q_A(ntry,l_switch,G1H1(1),31,0,G2tensor(173),n2h1(183))
  call Hloop_QZ_A(ntry,G1H3(162),ex4(:),G1H1(1),ngZu,m3h3x1(:,172),heltab2x3(:,:,172))
  call Hcheck_last_Q_A(ntry,l_switch,G1H1(1),8,0,G2tensor(174),n2h1(184))
  call Hloop_QZ_A(ntry,G1H3(165),ex4(:),G1H1(1),ngZu,m3h3x1(:,173),heltab2x3(:,:,173))
  call Hcheck_last_Q_A(ntry,l_switch,G1H1(1),31,0,G2tensor(175),n2h1(185))
  call Hloop_QZ_A(ntry,G1H3(52),ex4(:),G1H1(1),ngZu,m3h3x1(:,174),heltab2x3(:,:,174))
  call Hcheck_last_Q_A(ntry,l_switch,G1H1(1),31,nMT,G2tensor(176),n2h1(186))
  call Hloop_QZ_A(ntry,G1H3(166),ex4(:),G1H1(1),ngZu,m3h3x1(:,175),heltab2x3(:,:,175))
  call Hcheck_last_Q_A(ntry,l_switch,G1H1(1),8,nMT,G2tensor(177),n2h1(187))
  call Hloop_QZ_A(ntry,G1H3(169),ex4(:),G1H1(1),ngZu,m3h3x1(:,176),heltab2x3(:,:,176))
  call Hcheck_last_Q_A(ntry,l_switch,G1H1(1),31,nMT,G2tensor(178),n2h1(188))
  call Hloop_AZ_Q(ntry,G1H3(34),ex4(:),G1H1(1),ngZd,m3h3x1(:,177),heltab2x3(:,:,177))
  call Hcheck_last_A_Q(ntry,l_switch,G1H1(1),31,nMB,G2tensor(179),n2h1(189))
  call Hloop_AZ_Q(ntry,G1H3(170),ex4(:),G1H1(1),ngZd,m3h3x1(:,178),heltab2x3(:,:,178))
  call Hcheck_last_A_Q(ntry,l_switch,G1H1(1),8,nMB,G2tensor(180),n2h1(190))
  call Hloop_AZ_Q(ntry,G1H3(173),ex4(:),G1H1(1),ngZd,m3h3x1(:,179),heltab2x3(:,:,179))
  call Hcheck_last_A_Q(ntry,l_switch,G1H1(1),31,nMB,G2tensor(181),n2h1(191))
  call Hloop_QZ_A(ntry,G1H3(18),ex4(:),G1H1(1),ngZd,m3h3x1(:,180),heltab2x3(:,:,180))
  call Hcheck_last_Q_A(ntry,l_switch,G1H1(1),31,nMB,G2tensor(182),n2h1(192))
  call Hloop_QZ_A(ntry,G1H3(174),ex4(:),G1H1(1),ngZd,m3h3x1(:,181),heltab2x3(:,:,181))
  call Hcheck_last_Q_A(ntry,l_switch,G1H1(1),8,nMB,G2tensor(183),n2h1(193))
  call Hloop_QZ_A(ntry,G1H3(177),ex4(:),G1H1(1),ngZd,m3h3x1(:,182),heltab2x3(:,:,182))
  call Hcheck_last_Q_A(ntry,l_switch,G1H1(1),31,nMB,G2tensor(184),n2h1(194))
  call Hloop_QZ_A(ntry,G1H3(41),ex4(:),G1H1(1),ngZu,m3h3x1(:,183),heltab2x3(:,:,183))
  call Hcheck_last_Q_A(ntry,l_switch,G1H1(1),31,0,G2tensor(185),n2h1(195))
  call Hloop_QZ_A(ntry,G1H3(178),ex4(:),G1H1(1),ngZu,m3h3x1(:,184),heltab2x3(:,:,184))
  call Hcheck_last_Q_A(ntry,l_switch,G1H1(1),8,0,G2tensor(186),n2h1(196))
  call Hloop_QZ_A(ntry,G1H3(181),ex4(:),G1H1(1),ngZu,m3h3x1(:,185),heltab2x3(:,:,185))
  call Hcheck_last_Q_A(ntry,l_switch,G1H1(1),31,0,G2tensor(187),n2h1(197))
  call Hloop_QZ_A(ntry,G1H3(68),ex4(:),G1H1(1),ngZu,m3h3x1(:,186),heltab2x3(:,:,186))
  call Hcheck_last_Q_A(ntry,l_switch,G1H1(1),31,nMT,G2tensor(188),n2h1(198))
  call Hloop_QZ_A(ntry,G1H3(182),ex4(:),G1H1(1),ngZu,m3h3x1(:,187),heltab2x3(:,:,187))
  call Hcheck_last_Q_A(ntry,l_switch,G1H1(1),8,nMT,G2tensor(189),n2h1(199))
  call Hloop_QZ_A(ntry,G1H3(185),ex4(:),G1H1(1),ngZu,m3h3x1(:,188),heltab2x3(:,:,188))
  call Hcheck_last_Q_A(ntry,l_switch,G1H1(1),31,nMT,G2tensor(190),n2h1(200))
  call Hloop_AZ_Q(ntry,G1H3(19),ex4(:),G1H1(1),ngZu,m3h3x1(:,189),heltab2x3(:,:,189))
  call Hcheck_last_A_Q(ntry,l_switch,G1H1(1),31,0,G2tensor(191),n2h1(201))
  call Hloop_AZ_Q(ntry,G1H3(186),ex4(:),G1H1(1),ngZu,m3h3x1(:,190),heltab2x3(:,:,190))
  call Hcheck_last_A_Q(ntry,l_switch,G1H1(1),8,0,G2tensor(192),n2h1(202))
  call Hloop_AZ_Q(ntry,G1H3(189),ex4(:),G1H1(1),ngZu,m3h3x1(:,191),heltab2x3(:,:,191))
  call Hcheck_last_A_Q(ntry,l_switch,G1H1(1),31,0,G2tensor(193),n2h1(203))
  call Hloop_AZ_Q(ntry,G1H3(57),ex4(:),G1H1(1),ngZu,m3h3x1(:,192),heltab2x3(:,:,192))
  call Hcheck_last_A_Q(ntry,l_switch,G1H1(1),31,nMT,G2tensor(194),n2h1(204))
  call Hloop_AZ_Q(ntry,G1H3(190),ex4(:),G1H1(1),ngZu,m3h3x1(:,193),heltab2x3(:,:,193))
  call Hcheck_last_A_Q(ntry,l_switch,G1H1(1),8,nMT,G2tensor(195),n2h1(205))
  call Hloop_AZ_Q(ntry,G1H3(193),ex4(:),G1H1(1),ngZu,m3h3x1(:,194),heltab2x3(:,:,194))
  call Hcheck_last_A_Q(ntry,l_switch,G1H1(1),31,nMT,G2tensor(196),n2h1(206))
  call Hloop_QZ_A(ntry,G1H3(8),ex4(:),G1H1(1),ngZd,m3h3x1(:,195),heltab2x3(:,:,195))
  call Hcheck_last_Q_A(ntry,l_switch,G1H1(1),31,nMB,G2tensor(197),n2h1(207))
  call Hloop_QZ_A(ntry,G1H3(63),ex4(:),G1H1(1),ngZd,m3h3x1(:,196),heltab2x3(:,:,196))
  call Hcheck_last_Q_A(ntry,l_switch,G1H1(1),8,nMB,G2tensor(198),n2h1(208))
  call Hloop_QZ_A(ntry,G1H3(196),ex4(:),G1H1(1),ngZd,m3h3x1(:,197),heltab2x3(:,:,197))
  call Hcheck_last_Q_A(ntry,l_switch,G1H1(1),31,nMB,G2tensor(199),n2h1(209))
  call Hloop_AZ_Q(ntry,G1H3(40),ex4(:),G1H1(1),ngZd,m3h3x1(:,198),heltab2x3(:,:,198))
  call Hcheck_last_A_Q(ntry,l_switch,G1H1(1),31,nMB,G2tensor(200),n2h1(210))
  call Hloop_AZ_Q(ntry,G1H3(29),ex4(:),G1H1(1),ngZd,m3h3x1(:,199),heltab2x3(:,:,199))
  call Hcheck_last_A_Q(ntry,l_switch,G1H1(1),8,nMB,G2tensor(201),n2h1(211))
  call Hloop_AZ_Q(ntry,G1H3(199),ex4(:),G1H1(1),ngZd,m3h3x1(:,200),heltab2x3(:,:,200))
  call Hcheck_last_A_Q(ntry,l_switch,G1H1(1),31,nMB,G2tensor(202),n2h1(212))
  call ol_merge_tensors(G2tensor(75),[G2tensor(2),G1tensor(6)])
  call ol_merge_tensors(G2tensor(71),[G2tensor(4),G1tensor(12)])
  call ol_merge_tensors(G2tensor(77),[G2tensor(6),G1tensor(14)])
  call ol_merge_tensors(G2tensor(146),[G2tensor(7),G1tensor(18)])
  call ol_merge_tensors(G2tensor(83),[G2tensor(10),G1tensor(20)])
  call ol_merge_tensors(G2tensor(19),[G2tensor(11),G1tensor(36),G1tensor(24)])
  call ol_merge_tensors(G2tensor(89),[G2tensor(14),G1tensor(26)])
  call ol_merge_tensors(G2tensor(143),[G2tensor(15),G1tensor(30)])
  call ol_merge_tensors(G2tensor(95),[G2tensor(18),G1tensor(32),G1tensor(27)])
  call ol_merge_tensors(G2tensor(101),[G2tensor(22),G1tensor(38)])
  call ol_merge_tensors(G2tensor(27),[G2tensor(23),G1tensor(48),G1tensor(42)])
  call ol_merge_tensors(G2tensor(107),[G2tensor(26),G1tensor(44),G1tensor(15)])
  call ol_merge_tensors(G2tensor(113),[G1tensor(21),G1tensor(2)])
  call ol_merge_tensors(G2tensor(47),[G1tensor(3)])
  call ol_merge_tensors(G2tensor(41),[G1tensor(4)])
  call ol_merge_tensors(G2tensor(1),[G1tensor(11),G1tensor(5)])
  call ol_merge_tensors(G2tensor(116),[G1tensor(33),G1tensor(8)])
  call ol_merge_tensors(G2tensor(48),[G1tensor(9)])
  call ol_merge_tensors(G2tensor(42),[G1tensor(10)])
  call ol_merge_tensors(G2tensor(119),[G1tensor(16)])
  call ol_merge_tensors(G2tensor(191),[G2tensor(185),G2tensor(92),G2tensor(80),G1tensor(29),G1tensor(17)])
  call ol_merge_tensors(G2tensor(173),[G2tensor(167),G2tensor(134),G2tensor(122),G1tensor(40),G1tensor(22)])
  call ol_merge_tensors(G2tensor(86),[G1tensor(23)])
  call ol_merge_tensors(G2tensor(125),[G1tensor(28)])
  call ol_merge_tensors(G2tensor(155),[G2tensor(149),G2tensor(140),G2tensor(128),G1tensor(46),G1tensor(34)])
  call ol_merge_tensors(G2tensor(98),[G1tensor(35)])
  call ol_merge_tensors(G2tensor(131),[G1tensor(39)])
  call ol_merge_tensors(G2tensor(104),[G1tensor(41)])
  call ol_merge_tensors(G2tensor(137),[G1tensor(45)])
  call ol_merge_tensors(G2tensor(110),[G1tensor(47)])
  call ol_merge_tensors(G2tensor(57),[G2tensor(55),G2tensor(45),G2tensor(43)])
  call ol_merge_tensors(G2tensor(51),[G2tensor(49),G2tensor(46),G2tensor(44)])
  call ol_merge_tensors(G2tensor(52),[G2tensor(50)])
  call ol_merge_tensors(G2tensor(54),[G2tensor(53)])
  call ol_merge_tensors(G2tensor(58),[G2tensor(56)])
  call ol_merge_tensors(G2tensor(60),[G2tensor(59)])
  call ol_merge_tensors(G2tensor(67),[G2tensor(65),G2tensor(63),G2tensor(61)])
  call ol_merge_tensors(G2tensor(64),[G2tensor(62)])
  call ol_merge_tensors(G2tensor(68),[G2tensor(66)])
  call ol_merge_tensors(G2tensor(158),[G2tensor(152)])
  call ol_merge_tensors(G2tensor(164),[G2tensor(161)])
  call ol_merge_tensors(G2tensor(176),[G2tensor(170)])
  call ol_merge_tensors(G2tensor(182),[G2tensor(179)])
  call ol_merge_tensors(G2tensor(194),[G2tensor(188)])
  call ol_merge_tensors(G2tensor(200),[G2tensor(197)])
call Hotf_4pt_reduction_last(G2tensor(75),RedSet_4(2),mass4set(:,1),  & 
G1tensor(1),G1tensor(7),G1tensor(13),G1tensor(19),G1tensor(25))
call G_TensorShift(G1tensor(7),10)
call Hotf_4pt_reduction_last(G2tensor(71),RedSet_4(3),mass4set(:,1),  & 
G1tensor(31),G1tensor(37),G1tensor(43),G1tensor(6),G1tensor(12))
call G_TensorShift(G1tensor(37),6)
call Hotf_4pt_reduction_last(G2tensor(77),RedSet_4(37),mass4set(:,1),  & 
G1tensor(14),G1tensor(18),G1tensor(20),G1tensor(36),G1tensor(24))
call G_TensorShift(G1tensor(18),2)
call Hotf_4pt_reduction_last(G2tensor(146),RedSet_4(4),mass4set(:,1),  & 
G1tensor(26),G1tensor(30),G1tensor(32),G1tensor(27),G1tensor(38))
call G_TensorShift(G1tensor(30),10)
call Hotf_4pt_reduction_last(G2tensor(83),RedSet_4(38),mass4set(:,1),  & 
G1tensor(48),G1tensor(42),G1tensor(44),G1tensor(15),G1tensor(21))
call G_TensorShift(G1tensor(42),4)
call Hotf_4pt_reduction_last(G2tensor(19),RedSet_4(5),mass4set(:,1),  & 
G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(11),G1tensor(5))
call G_TensorShift(G1tensor(3),12)
call Hotf_4pt_reduction_last(G2tensor(89),RedSet_4(39),mass4set(:,1),  & 
G1tensor(33),G1tensor(8),G1tensor(9),G1tensor(10),G1tensor(16))
call G_TensorShift(G1tensor(8),1)
call Hotf_4pt_reduction_last(G2tensor(143),RedSet_4(6),mass4set(:,1),  & 
G1tensor(29),G1tensor(17),G1tensor(40),G1tensor(22),G1tensor(23))
call G_TensorShift(G1tensor(17),9)
call Hotf_4pt_reduction_last(G2tensor(95),RedSet_4(22),mass4set(:,1),  & 
G1tensor(28),G1tensor(46),G1tensor(34),G1tensor(35),G1tensor(39))
call G_TensorShift(G1tensor(46),8)
call Hotf_4pt_reduction_last(G2tensor(101),RedSet_4(40),mass4set(:,1),  & 
G1tensor(41),G1tensor(45),G1tensor(47),G1tensor(49),G1tensor(50))
call G_TensorShift(G1tensor(45),4)
call Hotf_4pt_reduction_last(G2tensor(27),RedSet_4(7),mass4set(:,1),  & 
G1tensor(51),G1tensor(52),G1tensor(53),G1tensor(54),G1tensor(55))
call G_TensorShift(G1tensor(52),12)
call Hotf_4pt_reduction_last(G2tensor(107),RedSet_4(14),mass4set(:,1),  & 
G1tensor(56),G1tensor(57),G1tensor(58),G1tensor(59),G1tensor(60))
call G_TensorShift(G1tensor(57),8)
call Hotf_4pt_reduction_last(G2tensor(113),RedSet_4(18),mass4set(:,1),  & 
G1tensor(61),G1tensor(62),G1tensor(63),G1tensor(64),G1tensor(65))
call G_TensorShift(G1tensor(62),8)
call Hotf_4pt_reduction_last(G2tensor(47),RedSet_4(8),mass4set(:,1),  & 
G1tensor(66),G1tensor(67),G1tensor(68),G1tensor(69),G1tensor(70))
call G_TensorShift(G1tensor(67),2)
call Hotf_4pt_reduction_last(G2tensor(41),RedSet_4(9),mass4set(:,1),  & 
G1tensor(71),G1tensor(72),G1tensor(73),G1tensor(74),G1tensor(75))
call G_TensorShift(G1tensor(72),2)
call Hotf_4pt_reduction_last(G2tensor(1),RedSet_4(1),mass4set(:,1),  & 
G1tensor(76),G1tensor(77),G1tensor(78),G1tensor(79),G1tensor(80))
call G_TensorShift(G1tensor(77),2)
call Hotf_4pt_reduction_last(G2tensor(116),RedSet_4(25),mass4set(:,1),  & 
G1tensor(81),G1tensor(82),G1tensor(83),G1tensor(84),G1tensor(85))
call G_TensorShift(G1tensor(82),4)
call Hotf_4pt_reduction_last(G2tensor(48),RedSet_4(11),mass4set(:,1),  & 
G1tensor(86),G1tensor(87),G1tensor(88),G1tensor(89),G1tensor(90))
call G_TensorShift(G1tensor(87),2)
call Hotf_4pt_reduction_last(G2tensor(42),RedSet_4(12),mass4set(:,1),  & 
G1tensor(91),G1tensor(92),G1tensor(93),G1tensor(94),G1tensor(95))
call G_TensorShift(G1tensor(92),2)
call Hotf_4pt_reduction_last(G2tensor(119),RedSet_4(15),mass4set(:,1),  & 
G1tensor(96),G1tensor(97),G1tensor(98),G1tensor(99),G1tensor(100))
call G_TensorShift(G1tensor(97),8)
call Hotf_4pt_reduction_last(G2tensor(191),RedSet_4(16),mass4set(:,1),  & 
G1tensor(101),G1tensor(102),G1tensor(103),G1tensor(104),G1tensor(105))
call G_TensorShift(G1tensor(102),8)
call Hotf_4pt_reduction_last(G2tensor(173),RedSet_4(19),mass4set(:,1),  & 
G1tensor(106),G1tensor(107),G1tensor(108),G1tensor(109),G1tensor(110))
call G_TensorShift(G1tensor(107),8)
call Hotf_4pt_reduction_last(G2tensor(86),RedSet_4(20),mass4set(:,1),  & 
G1tensor(111),G1tensor(112),G1tensor(113),G1tensor(114),G1tensor(115))
call G_TensorShift(G1tensor(112),8)
call Hotf_4pt_reduction_last(G2tensor(125),RedSet_4(23),mass4set(:,1),  & 
G1tensor(116),G1tensor(117),G1tensor(118),G1tensor(119),G1tensor(120))
call G_TensorShift(G1tensor(117),8)
call Hotf_4pt_reduction_last(G2tensor(155),RedSet_4(26),mass4set(:,1),  & 
G1tensor(121),G1tensor(122),G1tensor(123),G1tensor(124),G1tensor(125))
call G_TensorShift(G1tensor(122),4)
call Hotf_4pt_reduction_last(G2tensor(98),RedSet_4(27),mass4set(:,1),  & 
G1tensor(126),G1tensor(127),G1tensor(128),G1tensor(129),G1tensor(130))
call G_TensorShift(G1tensor(127),4)
call Hotf_4pt_reduction_last(G2tensor(131),RedSet_4(29),mass4set(:,1),  & 
G1tensor(131),G1tensor(132),G1tensor(133),G1tensor(134),G1tensor(135))
call G_TensorShift(G1tensor(132),8)
call Hotf_4pt_reduction_last(G2tensor(104),RedSet_4(30),mass4set(:,1),  & 
G1tensor(136),G1tensor(137),G1tensor(138),G1tensor(139),G1tensor(140))
call G_TensorShift(G1tensor(137),8)
call Hotf_4pt_reduction_last(G2tensor(137),RedSet_4(32),mass4set(:,1),  & 
G1tensor(141),G1tensor(142),G1tensor(143),G1tensor(144),G1tensor(145))
call G_TensorShift(G1tensor(142),4)
call Hotf_4pt_reduction_last(G2tensor(110),RedSet_4(33),mass4set(:,1),  & 
G1tensor(146),G1tensor(147),G1tensor(148),G1tensor(149),G1tensor(150))
call G_TensorShift(G1tensor(147),4)
call Hotf_4pt_reduction_last(G2tensor(57),RedSet_4(19),mass4set(:,1),  & 
G1tensor(151),G1tensor(152),G1tensor(153),G1tensor(154),G1tensor(155),G0tensor(1))
call G_TensorShift(G1tensor(152),8)
call Hotf_4pt_reduction_last(G2tensor(51),RedSet_4(26),mass4set(:,1),  & 
G1tensor(151),G1tensor(156),G1tensor(157),G1tensor(158),G1tensor(159),G0tensor(2))
call G_TensorShift(G1tensor(156),4)
call Hotf_4pt_reduction_last(G2tensor(52),RedSet_4(26),mass4set(:,2),  & 
G1tensor(151),G1tensor(160),G1tensor(161),G1tensor(162),G1tensor(163),G0tensor(3))
call G_TensorShift(G1tensor(160),4)
call Hotf_4pt_reduction_last(G2tensor(54),RedSet_4(26),mass4set(:,3),  & 
G1tensor(151),G1tensor(164),G1tensor(165),G1tensor(166),G1tensor(167),G0tensor(4))
call G_TensorShift(G1tensor(164),4)
call Hotf_4pt_reduction_last(G2tensor(58),RedSet_4(19),mass4set(:,2),  & 
G1tensor(151),G1tensor(168),G1tensor(169),G1tensor(170),G1tensor(171),G0tensor(5))
call G_TensorShift(G1tensor(168),8)
call Hotf_4pt_reduction_last(G2tensor(60),RedSet_4(19),mass4set(:,3),  & 
G1tensor(151),G1tensor(172),G1tensor(173),G1tensor(174),G1tensor(175),G0tensor(6))
call G_TensorShift(G1tensor(172),8)
call Hotf_4pt_reduction_last(G2tensor(67),RedSet_4(16),mass4set(:,1),  & 
G1tensor(151),G1tensor(176),G1tensor(177),G1tensor(178),G1tensor(179),G0tensor(7))
call G_TensorShift(G1tensor(176),8)
call Hotf_4pt_reduction_last(G2tensor(64),RedSet_4(16),mass4set(:,2),  & 
G1tensor(151),G1tensor(180),G1tensor(181),G1tensor(182),G1tensor(183),G0tensor(8))
call G_TensorShift(G1tensor(180),8)
call Hotf_4pt_reduction_last(G2tensor(68),RedSet_4(16),mass4set(:,3),  & 
G1tensor(151),G1tensor(184),G1tensor(185),G1tensor(186),G1tensor(187),G0tensor(9))
call G_TensorShift(G1tensor(184),8)
call Hotf_4pt_reduction_last(G2tensor(69),RedSet_4(35),mass4set(:,1),  & 
G1tensor(151),G1tensor(188),G1tensor(189),G1tensor(190),G1tensor(191))
call G_TensorShift(G1tensor(188),5)
call Hotf_4pt_reduction_last(G2tensor(73),RedSet_4(36),mass4set(:,1),  & 
G1tensor(192),G1tensor(193),G1tensor(194),G1tensor(195),G1tensor(196))
call G_TensorShift(G1tensor(193),9)
call Hotf_4pt_reduction_last(G2tensor(158),RedSet_4(26),mass4set(:,2),  & 
G1tensor(197),G1tensor(198),G1tensor(199),G1tensor(200),G1tensor(201))
call G_TensorShift(G1tensor(198),4)
call Hotf_4pt_reduction_last(G2tensor(164),RedSet_4(26),mass4set(:,3),  & 
G1tensor(202),G1tensor(203),G1tensor(204),G1tensor(205),G1tensor(206))
call G_TensorShift(G1tensor(203),4)
call Hotf_4pt_reduction_last(G2tensor(176),RedSet_4(19),mass4set(:,2),  & 
G1tensor(207),G1tensor(208),G1tensor(209),G1tensor(210),G1tensor(211))
call G_TensorShift(G1tensor(208),8)
call Hotf_4pt_reduction_last(G2tensor(182),RedSet_4(19),mass4set(:,3),  & 
G1tensor(212),G1tensor(213),G1tensor(214),G1tensor(215),G1tensor(216))
call G_TensorShift(G1tensor(213),8)
call Hotf_4pt_reduction_last(G2tensor(194),RedSet_4(16),mass4set(:,2),  & 
G1tensor(217),G1tensor(218),G1tensor(219),G1tensor(220),G1tensor(221))
call G_TensorShift(G1tensor(218),8)
call Hotf_4pt_reduction_last(G2tensor(200),RedSet_4(16),mass4set(:,3),  & 
G1tensor(222),G1tensor(223),G1tensor(224),G1tensor(225),G1tensor(226))
call G_TensorShift(G1tensor(223),8)
call Hotf_4pt_reduction_last(G1tensor(1),RedSet_4(2),mass4set(:,1),  & 
G0tensor(10),G0tensor(11),G0tensor(12),G0tensor(13),G0tensor(14))
call Hotf_4pt_reduction_last(G1tensor(31),RedSet_4(3),mass4set(:,1),  & 
G0tensor(15),G0tensor(16),G0tensor(17),G0tensor(18),G0tensor(19))
call Hotf_4pt_reduction_last(G1tensor(14),RedSet_4(37),mass4set(:,1),  & 
G0tensor(20),G0tensor(21),G0tensor(22),G0tensor(23),G0tensor(24))
call Hotf_4pt_reduction_last(G1tensor(26),RedSet_4(4),mass4set(:,1),  & 
G0tensor(25),G0tensor(26),G0tensor(27),G0tensor(28),G0tensor(29))
call Hotf_4pt_reduction_last(G1tensor(48),RedSet_4(38),mass4set(:,1),  & 
G0tensor(30),G0tensor(31),G0tensor(32),G0tensor(33),G0tensor(34))
call Hotf_4pt_reduction_last(G1tensor(2),RedSet_4(5),mass4set(:,1),  & 
G0tensor(35),G0tensor(36),G0tensor(37),G0tensor(38),G0tensor(39))
call Hotf_4pt_reduction_last(G1tensor(33),RedSet_4(39),mass4set(:,1),  & 
G0tensor(40),G0tensor(41),G0tensor(42),G0tensor(43),G0tensor(44))
call Hotf_4pt_reduction_last(G1tensor(29),RedSet_4(6),mass4set(:,1),  & 
G0tensor(45),G0tensor(46),G0tensor(47),G0tensor(48),G0tensor(49))
call Hotf_4pt_reduction_last(G1tensor(28),RedSet_4(22),mass4set(:,1),  & 
G0tensor(50),G0tensor(51),G0tensor(52),G0tensor(53),G0tensor(54))
call Hotf_4pt_reduction_last(G1tensor(41),RedSet_4(40),mass4set(:,1),  & 
G0tensor(55),G0tensor(56),G0tensor(57),G0tensor(58),G0tensor(59))
call Hotf_4pt_reduction_last(G1tensor(51),RedSet_4(7),mass4set(:,1),  & 
G0tensor(60),G0tensor(61),G0tensor(62),G0tensor(63),G0tensor(64))
call Hotf_4pt_reduction_last(G1tensor(56),RedSet_4(14),mass4set(:,1),  & 
G0tensor(65),G0tensor(66),G0tensor(67),G0tensor(68),G0tensor(69))
call Hotf_4pt_reduction_last(G1tensor(61),RedSet_4(18),mass4set(:,1),  & 
G0tensor(70),G0tensor(71),G0tensor(72),G0tensor(73),G0tensor(74))
call Hotf_4pt_reduction_last(G1tensor(66),RedSet_4(8),mass4set(:,1),  & 
G0tensor(75),G0tensor(76),G0tensor(77),G0tensor(78),G0tensor(79))
call Hotf_4pt_reduction_last(G1tensor(71),RedSet_4(9),mass4set(:,1),  & 
G0tensor(80),G0tensor(81),G0tensor(82),G0tensor(83),G0tensor(84))
call Hotf_4pt_reduction_last(G1tensor(76),RedSet_4(1),mass4set(:,1),  & 
G0tensor(85),G0tensor(86),G0tensor(87),G0tensor(88),G0tensor(89))
call Hotf_4pt_reduction_last(G1tensor(81),RedSet_4(25),mass4set(:,1),  & 
G0tensor(90),G0tensor(91),G0tensor(92),G0tensor(93),G0tensor(94))
call Hotf_4pt_reduction_last(G1tensor(86),RedSet_4(11),mass4set(:,1),  & 
G0tensor(95),G0tensor(96),G0tensor(97),G0tensor(98),G0tensor(99))
call Hotf_4pt_reduction_last(G1tensor(91),RedSet_4(12),mass4set(:,1),  & 
G0tensor(100),G0tensor(101),G0tensor(102),G0tensor(103),G0tensor(104))
call Hotf_4pt_reduction_last(G1tensor(96),RedSet_4(15),mass4set(:,1),  & 
G0tensor(105),G0tensor(106),G0tensor(107),G0tensor(108),G0tensor(109))
call Hotf_4pt_reduction_last(G1tensor(101),RedSet_4(16),mass4set(:,1),  & 
G0tensor(110),G0tensor(111),G0tensor(112),G0tensor(113),G0tensor(114))
call Hotf_4pt_reduction_last(G1tensor(106),RedSet_4(19),mass4set(:,1),  & 
G0tensor(115),G0tensor(116),G0tensor(117),G0tensor(118),G0tensor(119))
call Hotf_4pt_reduction_last(G1tensor(111),RedSet_4(20),mass4set(:,1),  & 
G0tensor(120),G0tensor(121),G0tensor(122),G0tensor(123),G0tensor(124))
call Hotf_4pt_reduction_last(G1tensor(116),RedSet_4(23),mass4set(:,1),  & 
G0tensor(125),G0tensor(126),G0tensor(127),G0tensor(128),G0tensor(129))
call Hotf_4pt_reduction_last(G1tensor(121),RedSet_4(26),mass4set(:,1),  & 
G0tensor(130),G0tensor(131),G0tensor(132),G0tensor(133),G0tensor(134))
call Hotf_4pt_reduction_last(G1tensor(126),RedSet_4(27),mass4set(:,1),  & 
G0tensor(135),G0tensor(136),G0tensor(137),G0tensor(138),G0tensor(139))
call Hotf_4pt_reduction_last(G1tensor(131),RedSet_4(29),mass4set(:,1),  & 
G0tensor(140),G0tensor(141),G0tensor(142),G0tensor(143),G0tensor(144))
call Hotf_4pt_reduction_last(G1tensor(136),RedSet_4(30),mass4set(:,1),  & 
G0tensor(145),G0tensor(146),G0tensor(147),G0tensor(148),G0tensor(149))
call Hotf_4pt_reduction_last(G1tensor(141),RedSet_4(32),mass4set(:,1),  & 
G0tensor(150),G0tensor(151),G0tensor(152),G0tensor(153),G0tensor(154))
call Hotf_4pt_reduction_last(G1tensor(146),RedSet_4(33),mass4set(:,1),  & 
G0tensor(155),G0tensor(156),G0tensor(157),G0tensor(158),G0tensor(159))
call Hotf_4pt_reduction_last(G1tensor(151),RedSet_4(35),mass4set(:,1),  & 
G0tensor(160),G0tensor(161),G0tensor(162),G0tensor(163),G0tensor(164))
call Hotf_4pt_reduction_last(G1tensor(192),RedSet_4(36),mass4set(:,1),  & 
G0tensor(165),G0tensor(166),G0tensor(167),G0tensor(168),G0tensor(169))
call Hotf_4pt_reduction_last(G1tensor(197),RedSet_4(26),mass4set(:,2),  & 
G0tensor(170),G0tensor(171),G0tensor(172),G0tensor(173),G0tensor(174))
call Hotf_4pt_reduction_last(G1tensor(202),RedSet_4(26),mass4set(:,3),  & 
G0tensor(175),G0tensor(176),G0tensor(177),G0tensor(178),G0tensor(179))
call Hotf_4pt_reduction_last(G1tensor(207),RedSet_4(19),mass4set(:,2),  & 
G0tensor(180),G0tensor(181),G0tensor(182),G0tensor(183),G0tensor(184))
call Hotf_4pt_reduction_last(G1tensor(212),RedSet_4(19),mass4set(:,3),  & 
G0tensor(185),G0tensor(186),G0tensor(187),G0tensor(188),G0tensor(189))
call Hotf_4pt_reduction_last(G1tensor(217),RedSet_4(16),mass4set(:,2),  & 
G0tensor(190),G0tensor(191),G0tensor(192),G0tensor(193),G0tensor(194))
call Hotf_4pt_reduction_last(G1tensor(222),RedSet_4(16),mass4set(:,3),  & 
G0tensor(195),G0tensor(196),G0tensor(197),G0tensor(198),G0tensor(199))
call ol_merge_tensors(T0sum(1),[G0tensor(10)])
call ol_merge_tensors(T0sum(2),[G0tensor(15)])
call ol_merge_tensors(T0sum(3),[G0tensor(20)])
call ol_merge_tensors(T0sum(4),[G0tensor(25)])
call ol_merge_tensors(T0sum(5),[G0tensor(30)])
call ol_merge_tensors(T0sum(6),[G0tensor(35)])
call ol_merge_tensors(T0sum(7),[G0tensor(40)])
call ol_merge_tensors(T0sum(8),[G0tensor(45)])
call ol_merge_tensors(T0sum(9),[G0tensor(50)])
call ol_merge_tensors(T0sum(10),[G0tensor(55)])
call ol_merge_tensors(T0sum(11),[G0tensor(60)])
call ol_merge_tensors(T0sum(12),[G0tensor(65)])
call ol_merge_tensors(T0sum(13),[G0tensor(70)])
call ol_merge_tensors(T0sum(14),[G0tensor(75)])
call ol_merge_tensors(T0sum(15),[G0tensor(80)])
call ol_merge_tensors(T0sum(16),[G0tensor(85)])
call ol_merge_tensors(T0sum(17),[G0tensor(90)])
call ol_merge_tensors(T0sum(18),[G0tensor(95)])
call ol_merge_tensors(T0sum(19),[G0tensor(100)])
call ol_merge_tensors(T0sum(20),[G0tensor(105)])
call ol_merge_tensors(T0sum(21),[G0tensor(110)])
call ol_merge_tensors(T0sum(22),[G0tensor(115)])
call ol_merge_tensors(T0sum(23),[G0tensor(120)])
call ol_merge_tensors(T0sum(24),[G0tensor(125)])
call ol_merge_tensors(T0sum(25),[G0tensor(130)])
call ol_merge_tensors(T0sum(26),[G0tensor(135)])
call ol_merge_tensors(T0sum(27),[G0tensor(140)])
call ol_merge_tensors(T0sum(28),[G0tensor(145)])
call ol_merge_tensors(T0sum(29),[G0tensor(150)])
call ol_merge_tensors(T0sum(30),[G0tensor(155)])
call ol_merge_tensors(T0sum(31),[G0tensor(1)])
call ol_merge_tensors(T0sum(32),[G0tensor(2)])
call ol_merge_tensors(T0sum(33),[G0tensor(3)])
call ol_merge_tensors(T0sum(34),[G0tensor(4)])
call ol_merge_tensors(T0sum(35),[G0tensor(5)])
call ol_merge_tensors(T0sum(36),[G0tensor(6)])
call ol_merge_tensors(T0sum(37),[G0tensor(7)])
call ol_merge_tensors(T0sum(38),[G0tensor(8)])
call ol_merge_tensors(T0sum(39),[G0tensor(9)])
call ol_merge_tensors(T0sum(40),[G0tensor(160)])
call ol_merge_tensors(T0sum(41),[G0tensor(165)])
call ol_merge_tensors(T0sum(42),[G0tensor(170)])
call ol_merge_tensors(T0sum(43),[G0tensor(175)])
call ol_merge_tensors(T0sum(44),[G0tensor(180)])
call ol_merge_tensors(T0sum(45),[G0tensor(185)])
call ol_merge_tensors(T0sum(46),[G0tensor(190)])
call ol_merge_tensors(T0sum(47),[G0tensor(195)])
Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(15)
call G0_hol_initialisation(ntry,Gcoeff,G0H72(1),m0h(49),h0tab(:,49),[16,3,12],[nMT,nMT,nMT],3,2,wf4(:,5),wf9(:,1))
  call Hloop_AV_Q(ntry,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,45),heltab2x72(:,:,49))
  call Hloop_A_Q(ntry,G0H36(1),16,nMT,G1H36(1),n2h36(39))
Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(15)
call G0_hol_initialisation(ntry,Gcoeff,G0H72(1),m0h(50),h0tab(:,50),[16,3,12],[nMT,nMT,nMT],3,2,wf4(:,5),wf9(:,1))
  call Hloop_QV_A(ntry,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,46),heltab2x72(:,:,50))
  call Hloop_Q_A(ntry,G0H36(1),16,nMT,G1H36(2),n2h36(40))
Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(15)
call G0_hol_initialisation(ntry,Gcoeff,G0H72(1),m0h(51),h0tab(:,51),[16,3,12],[nMB,nMB,nMB],3,2,wf4(:,5),wf9(:,1))
  call Hloop_AV_Q(ntry,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,47),heltab2x72(:,:,51))
  call Hloop_A_Q(ntry,G0H36(1),16,nMB,G1H36(3),n2h36(41))
Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(15)
call G0_hol_initialisation(ntry,Gcoeff,G0H72(1),m0h(52),h0tab(:,52),[16,3,12],[nMB,nMB,nMB],3,2,wf4(:,5),wf9(:,1))
  call Hloop_QV_A(ntry,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,48),heltab2x72(:,:,52))
  call Hloop_Q_A(ntry,G0H36(1),16,nMB,G1H36(4),n2h36(42))
Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(3)
call G0_hol_initialisation(ntry,Gcoeff,G0H72(1),m0h(53),h0tab(:,53),[16,5,10],[0,0,0],3,2,wf6(:,3),wf6(:,4))
  call Hloop_AV_Q(ntry,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,49),heltab2x72(:,:,53))
  call Hloop_A_Q(ntry,G0H36(1),16,0,G1H36(5),n2h36(43))
Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(3)
call G0_hol_initialisation(ntry,Gcoeff,G0H72(1),m0h(54),h0tab(:,54),[16,5,10],[0,0,0],3,2,wf6(:,3),wf6(:,4))
  call Hloop_UV_W(ntry,G0H72(1),0,ex5(:),16,G1H36(6),m3h2x36(:,50),heltab2x72(:,:,54))
Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(5)
call G0_hol_initialisation(ntry,Gcoeff,G0H72(1),m0h(55),h0tab(:,55),[18,5,8],[0,0,0],3,2,wf4(:,2),wf6(:,3))
  call Hloop_QA_V(ntry,G0H72(1),wf4(:,2),G0H18(1),m3h4x18(:,5),heltab2x72(:,:,55))
Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(53)
call G0_hol_initialisation(ntry,Gcoeff,G0H72(1),m0h(56),h0tab(:,56),[16,7,8],[0,0,0],3,1,wf12(:,6))
  call Hloop_AV_Q(ntry,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,51),heltab2x72(:,:,56))
  call Hloop_A_Q(ntry,G0H36(1),16,0,G1H36(7),n2h36(44))
Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(53)
call G0_hol_initialisation(ntry,Gcoeff,G0H72(1),m0h(57),h0tab(:,57),[16,7,8],[nMT,nMT,nMT],3,1,wf12(:,6))
  call Hloop_AV_Q(ntry,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,52),heltab2x72(:,:,57))
  call Hloop_A_Q(ntry,G0H36(1),16,nMT,G1H36(8),n2h36(45))
Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(53)
call G0_hol_initialisation(ntry,Gcoeff,G0H72(1),m0h(58),h0tab(:,58),[16,7,8],[0,0,0],3,1,wf12(:,6))
  call Hloop_QV_A(ntry,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,53),heltab2x72(:,:,58))
  call Hloop_Q_A(ntry,G0H36(1),16,0,G1H36(9),n2h36(46))
Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(53)
call G0_hol_initialisation(ntry,Gcoeff,G0H72(1),m0h(59),h0tab(:,59),[16,7,8],[nMT,nMT,nMT],3,1,wf12(:,6))
  call Hloop_QV_A(ntry,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,54),heltab2x72(:,:,59))
  call Hloop_Q_A(ntry,G0H36(1),16,nMT,G1H36(10),n2h36(47))
Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(53)
call G0_hol_initialisation(ntry,Gcoeff,G0H72(1),m0h(60),h0tab(:,60),[16,7,8],[0,0,0],3,1,wf12(:,6))
  call Hloop_AV_Q(ntry,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,55),heltab2x72(:,:,60))
  call Hloop_A_Q(ntry,G0H36(1),16,0,G1H36(11),n2h36(48))
Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(53)
call G0_hol_initialisation(ntry,Gcoeff,G0H72(1),m0h(61),h0tab(:,61),[16,7,8],[nMB,nMB,nMB],3,1,wf12(:,6))
  call Hloop_AV_Q(ntry,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,56),heltab2x72(:,:,61))
  call Hloop_A_Q(ntry,G0H36(1),16,nMB,G1H36(12),n2h36(49))
Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(53)
call G0_hol_initialisation(ntry,Gcoeff,G0H72(1),m0h(62),h0tab(:,62),[16,7,8],[0,0,0],3,1,wf12(:,6))
  call Hloop_QV_A(ntry,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,57),heltab2x72(:,:,62))
  call Hloop_Q_A(ntry,G0H36(1),16,0,G1H36(13),n2h36(50))
Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(53)
call G0_hol_initialisation(ntry,Gcoeff,G0H72(1),m0h(63),h0tab(:,63),[16,7,8],[nMB,nMB,nMB],3,1,wf12(:,6))
  call Hloop_QV_A(ntry,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,58),heltab2x72(:,:,63))
  call Hloop_Q_A(ntry,G0H36(1),16,nMB,G1H36(14),n2h36(51))
Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(31)
call G0_hol_initialisation(ntry,Gcoeff,G0H72(1),m0h(64),h0tab(:,64),[16,2,13],[0,0,0],3,1,wf18(:,8))
  call Hloop_QV_A(ntry,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,59),heltab2x72(:,:,64))
  call Hloop_Q_A(ntry,G0H36(1),16,0,G1H36(15),n2h36(52))
Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(31)
call G0_hol_initialisation(ntry,Gcoeff,G0H72(1),m0h(65),h0tab(:,65),[16,2,13],[0,0,0],3,1,wf18(:,8))
  call Hloop_UV_W(ntry,G0H72(1),0,ex5(:),16,G1H36(16),m3h2x36(:,60),heltab2x72(:,:,65))
Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(26)
call G0_hol_initialisation(ntry,Gcoeff,G0H72(1),m0h(66),h0tab(:,66),[21,2,8],[0,0,0],3,1,wf12(:,19))
  call Hloop_AQ_V(ntry,G0H72(1),wf12(:,19),G0H6(1),m3h12x6(:,1),heltab2x72(:,:,66))
Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(8)
call G0_hol_initialisation(ntry,Gcoeff,G0H72(1),m0h(67),h0tab(:,67),[16,6,9],[0,0,0],3,2,wf6(:,8),wf6(:,7))
  call Hloop_QV_A(ntry,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,61),heltab2x72(:,:,67))
  call Hloop_Q_A(ntry,G0H36(1),16,0,G1H36(17),n2h36(53))
Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(8)
call G0_hol_initialisation(ntry,Gcoeff,G0H72(1),m0h(68),h0tab(:,68),[16,6,9],[0,0,0],3,2,wf6(:,8),wf6(:,7))
  call Hloop_UV_W(ntry,G0H72(1),0,ex5(:),16,G1H36(18),m3h2x36(:,62),heltab2x72(:,:,68))
Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(10)
call G0_hol_initialisation(ntry,Gcoeff,G0H72(1),m0h(69),h0tab(:,69),[17,6,8],[0,0,0],3,2,wf4(:,4),wf6(:,8))
  call Hloop_AQ_V(ntry,G0H72(1),wf4(:,4),G0H18(2),m3h4x18(:,6),heltab2x72(:,:,69))
Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(54)
call G0_hol_initialisation(ntry,Gcoeff,G0H72(1),m0h(70),h0tab(:,70),[16,7,8],[0,0,0],3,1,wf12(:,9))
  call Hloop_AV_Q(ntry,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,63),heltab2x72(:,:,70))
  call Hloop_A_Q(ntry,G0H36(1),16,0,G1H36(19),n2h36(54))
Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(54)
call G0_hol_initialisation(ntry,Gcoeff,G0H72(1),m0h(71),h0tab(:,71),[16,7,8],[nMT,nMT,nMT],3,1,wf12(:,9))
  call Hloop_AV_Q(ntry,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,64),heltab2x72(:,:,71))
  call Hloop_A_Q(ntry,G0H36(1),16,nMT,G1H36(20),n2h36(55))
Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(54)
call G0_hol_initialisation(ntry,Gcoeff,G0H72(1),m0h(72),h0tab(:,72),[16,7,8],[0,0,0],3,1,wf12(:,9))
  call Hloop_QV_A(ntry,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,65),heltab2x72(:,:,72))
  call Hloop_Q_A(ntry,G0H36(1),16,0,G1H36(21),n2h36(56))
Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(54)
call G0_hol_initialisation(ntry,Gcoeff,G0H72(1),m0h(73),h0tab(:,73),[16,7,8],[nMT,nMT,nMT],3,1,wf12(:,9))
  call Hloop_QV_A(ntry,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,66),heltab2x72(:,:,73))
  call Hloop_Q_A(ntry,G0H36(1),16,nMT,G1H36(22),n2h36(57))
Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(54)
call G0_hol_initialisation(ntry,Gcoeff,G0H72(1),m0h(74),h0tab(:,74),[16,7,8],[0,0,0],3,1,wf12(:,9))
  call Hloop_AV_Q(ntry,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,67),heltab2x72(:,:,74))
  call Hloop_A_Q(ntry,G0H36(1),16,0,G1H36(23),n2h36(58))
Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(54)
call G0_hol_initialisation(ntry,Gcoeff,G0H72(1),m0h(75),h0tab(:,75),[16,7,8],[nMB,nMB,nMB],3,1,wf12(:,9))
  call Hloop_AV_Q(ntry,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,68),heltab2x72(:,:,75))
  call Hloop_A_Q(ntry,G0H36(1),16,nMB,G1H36(24),n2h36(59))
Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(54)
call G0_hol_initialisation(ntry,Gcoeff,G0H72(1),m0h(76),h0tab(:,76),[16,7,8],[0,0,0],3,1,wf12(:,9))
  call Hloop_QV_A(ntry,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,69),heltab2x72(:,:,76))
  call Hloop_Q_A(ntry,G0H36(1),16,0,G1H36(25),n2h36(60))
Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(54)
call G0_hol_initialisation(ntry,Gcoeff,G0H72(1),m0h(77),h0tab(:,77),[16,7,8],[nMB,nMB,nMB],3,1,wf12(:,9))
  call Hloop_QV_A(ntry,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,70),heltab2x72(:,:,77))
  call Hloop_Q_A(ntry,G0H36(1),16,nMB,G1H36(26),n2h36(61))
Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(40)
call G0_hol_initialisation(ntry,Gcoeff,G0H72(1),m0h(78),h0tab(:,78),[16,1,14],[0,0,0],3,1,wf18(:,10))
  call Hloop_AV_Q(ntry,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,71),heltab2x72(:,:,78))
  call Hloop_A_Q(ntry,G0H36(1),16,0,G1H36(27),n2h36(62))
Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(40)
call G0_hol_initialisation(ntry,Gcoeff,G0H72(1),m0h(79),h0tab(:,79),[16,1,14],[0,0,0],3,1,wf18(:,10))
  call Hloop_UV_W(ntry,G0H72(1),0,ex5(:),16,G1H36(28),m3h2x36(:,72),heltab2x72(:,:,79))
Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(34)
call G0_hol_initialisation(ntry,Gcoeff,G0H72(1),m0h(80),h0tab(:,80),[22,1,8],[0,0,0],3,1,wf12(:,23))
  call Hloop_QA_V(ntry,G0H72(1),wf12(:,23),G0H6(2),m3h12x6(:,2),heltab2x72(:,:,80))
Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(11)
call G0_hol_initialisation(ntry,Gcoeff,G0H72(1),m0h(81),h0tab(:,81),[18,4,9],[0,0,0],3,2,wf4(:,2),wf6(:,7))
  call Hloop_VA_Q(ntry,G0H72(1),wf4(:,2),G0H18(3),m3h4x18(:,7),heltab2x72(:,:,81))
  call Hloop_A_Q(ntry,G0H18(3),18,0,G1H18(10),n2h18(13))
Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(56)
call G0_hol_initialisation(ntry,Gcoeff,G0H72(1),m0h(82),h0tab(:,82),[16,4,11],[0,0,0],3,1,wf12(:,10))
  call Hloop_QV_A(ntry,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,73),heltab2x72(:,:,82))
  call Hloop_Q_A(ntry,G0H36(1),16,0,G1H36(29),n2h36(63))
Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(56)
call G0_hol_initialisation(ntry,Gcoeff,G0H72(1),m0h(83),h0tab(:,83),[16,4,11],[nMT,nMT,nMT],3,1,wf12(:,10))
  call Hloop_QV_A(ntry,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,74),heltab2x72(:,:,83))
  call Hloop_Q_A(ntry,G0H36(1),16,nMT,G1H36(30),n2h36(64))
Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(56)
call G0_hol_initialisation(ntry,Gcoeff,G0H72(1),m0h(84),h0tab(:,84),[16,4,11],[0,0,0],3,1,wf12(:,10))
  call Hloop_AV_Q(ntry,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,75),heltab2x72(:,:,84))
  call Hloop_A_Q(ntry,G0H36(1),16,0,G1H36(31),n2h36(65))
Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(56)
call G0_hol_initialisation(ntry,Gcoeff,G0H72(1),m0h(85),h0tab(:,85),[16,4,11],[nMT,nMT,nMT],3,1,wf12(:,10))
  call Hloop_AV_Q(ntry,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,76),heltab2x72(:,:,85))
  call Hloop_A_Q(ntry,G0H36(1),16,nMT,G1H36(32),n2h36(66))
Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(56)
call G0_hol_initialisation(ntry,Gcoeff,G0H72(1),m0h(86),h0tab(:,86),[16,4,11],[0,0,0],3,1,wf12(:,10))
  call Hloop_QV_A(ntry,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,77),heltab2x72(:,:,86))
  call Hloop_Q_A(ntry,G0H36(1),16,0,G1H36(33),n2h36(67))
Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(56)
call G0_hol_initialisation(ntry,Gcoeff,G0H72(1),m0h(87),h0tab(:,87),[16,4,11],[nMB,nMB,nMB],3,1,wf12(:,10))
  call Hloop_QV_A(ntry,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,78),heltab2x72(:,:,87))
  call Hloop_Q_A(ntry,G0H36(1),16,nMB,G1H36(34),n2h36(68))
Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(56)
call G0_hol_initialisation(ntry,Gcoeff,G0H72(1),m0h(88),h0tab(:,88),[16,4,11],[0,0,0],3,1,wf12(:,10))
  call Hloop_AV_Q(ntry,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,79),heltab2x72(:,:,88))
  call Hloop_A_Q(ntry,G0H36(1),16,0,G1H36(35),n2h36(69))
Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(56)
call G0_hol_initialisation(ntry,Gcoeff,G0H72(1),m0h(89),h0tab(:,89),[16,4,11],[nMB,nMB,nMB],3,1,wf12(:,10))
  call Hloop_AV_Q(ntry,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,80),heltab2x72(:,:,89))
  call Hloop_A_Q(ntry,G0H36(1),16,nMB,G1H36(36),n2h36(70))
Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(46)
call G0_hol_initialisation(ntry,Gcoeff,G0H72(1),m0h(90),h0tab(:,90),[16,2,13],[0,0,0],3,1,wf18(:,11))
  call Hloop_QV_A(ntry,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,81),heltab2x72(:,:,90))
  call Hloop_Q_A(ntry,G0H36(1),16,0,G1H36(37),n2h36(71))
Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(46)
call G0_hol_initialisation(ntry,Gcoeff,G0H72(1),m0h(91),h0tab(:,91),[16,2,13],[0,0,0],3,1,wf18(:,11))
  call Hloop_UV_W(ntry,G0H72(1),0,ex5(:),16,G1H36(38),m3h2x36(:,82),heltab2x72(:,:,91))
Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(37)
call G0_hol_initialisation(ntry,Gcoeff,G0H72(1),m0h(92),h0tab(:,92),[25,2,4],[0,0,0],3,1,wf12(:,24))
  call Hloop_AQ_V(ntry,G0H72(1),wf12(:,24),G0H6(3),m3h12x6(:,3),heltab2x72(:,:,92))
Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(12)
call G0_hol_initialisation(ntry,Gcoeff,G0H72(1),m0h(93),h0tab(:,93),[17,4,10],[0,0,0],3,2,wf4(:,4),wf6(:,4))
  call Hloop_VQ_A(ntry,G0H72(1),wf4(:,4),G0H18(4),m3h4x18(:,8),heltab2x72(:,:,93))
  call Hloop_Q_A(ntry,G0H18(4),17,0,G1H18(11),n2h18(14))
Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(57)
call G0_hol_initialisation(ntry,Gcoeff,G0H72(1),m0h(94),h0tab(:,94),[16,4,11],[0,0,0],3,1,wf12(:,12))
  call Hloop_QV_A(ntry,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,83),heltab2x72(:,:,94))
  call Hloop_Q_A(ntry,G0H36(1),16,0,G1H36(39),n2h36(72))
Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(57)
call G0_hol_initialisation(ntry,Gcoeff,G0H72(1),m0h(95),h0tab(:,95),[16,4,11],[nMT,nMT,nMT],3,1,wf12(:,12))
  call Hloop_QV_A(ntry,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,84),heltab2x72(:,:,95))
  call Hloop_Q_A(ntry,G0H36(1),16,nMT,G1H36(40),n2h36(73))
Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(57)
call G0_hol_initialisation(ntry,Gcoeff,G0H72(1),m0h(96),h0tab(:,96),[16,4,11],[0,0,0],3,1,wf12(:,12))
  call Hloop_AV_Q(ntry,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,85),heltab2x72(:,:,96))
  call Hloop_A_Q(ntry,G0H36(1),16,0,G1H36(41),n2h36(74))
Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(57)
call G0_hol_initialisation(ntry,Gcoeff,G0H72(1),m0h(97),h0tab(:,97),[16,4,11],[nMT,nMT,nMT],3,1,wf12(:,12))
  call Hloop_AV_Q(ntry,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,86),heltab2x72(:,:,97))
  call Hloop_A_Q(ntry,G0H36(1),16,nMT,G1H36(42),n2h36(75))
Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(57)
call G0_hol_initialisation(ntry,Gcoeff,G0H72(1),m0h(98),h0tab(:,98),[16,4,11],[0,0,0],3,1,wf12(:,12))
  call Hloop_QV_A(ntry,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,87),heltab2x72(:,:,98))
  call Hloop_Q_A(ntry,G0H36(1),16,0,G1H36(43),n2h36(76))
Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(57)
call G0_hol_initialisation(ntry,Gcoeff,G0H72(1),m0h(99),h0tab(:,99),[16,4,11],[nMB,nMB,nMB],3,1,wf12(:,12))
  call Hloop_QV_A(ntry,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,88),heltab2x72(:,:,99))
  call Hloop_Q_A(ntry,G0H36(1),16,nMB,G1H36(44),n2h36(77))
Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(57)
call G0_hol_initialisation(ntry,Gcoeff,G0H72(1),m0h(100),h0tab(:,100),[16,4,11],[0,0,0],3,1,wf12(:,12))
  call Hloop_AV_Q(ntry,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,89),heltab2x72(:,:,100))
  call Hloop_A_Q(ntry,G0H36(1),16,0,G1H36(45),n2h36(78))
Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(57)
call G0_hol_initialisation(ntry,Gcoeff,G0H72(1),m0h(101),h0tab(:,101),[16,4,11],[nMB,nMB,nMB],3,1,wf12(:,12))
  call Hloop_AV_Q(ntry,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,90),heltab2x72(:,:,101))
  call Hloop_A_Q(ntry,G0H36(1),16,nMB,G1H36(46),n2h36(79))
Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(48)
call G0_hol_initialisation(ntry,Gcoeff,G0H72(1),m0h(102),h0tab(:,102),[16,1,14],[0,0,0],3,1,wf18(:,13))
  call Hloop_AV_Q(ntry,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,91),heltab2x72(:,:,102))
  call Hloop_A_Q(ntry,G0H36(1),16,0,G1H36(47),n2h36(80))
Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(48)
call G0_hol_initialisation(ntry,Gcoeff,G0H72(1),m0h(103),h0tab(:,103),[16,1,14],[0,0,0],3,1,wf18(:,13))
  call Hloop_UV_W(ntry,G0H72(1),0,ex5(:),16,G1H36(48),m3h2x36(:,92),heltab2x72(:,:,103))
Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(23)
call G0_hol_initialisation(ntry,Gcoeff,G0H72(1),m0h(104),h0tab(:,104),[26,1,4],[0,0,0],3,1,wf12(:,18))
  call Hloop_QA_V(ntry,G0H72(1),wf12(:,18),G0H6(4),m3h12x6(:,4),heltab2x72(:,:,104))
Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(50)
call G0_hol_initialisation(ntry,Gcoeff,G0H72(1),m0h(105),h0tab(:,105),[21,2,8],[0,0,0],3,1,wf12(:,28))
  call Hloop_AQ_V(ntry,G0H72(1),wf12(:,28),G0H6(5),m3h12x6(:,5),heltab2x72(:,:,105))
Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(42)
call G0_hol_initialisation(ntry,Gcoeff,G0H72(1),m0h(106),h0tab(:,106),[25,2,4],[0,0,0],3,1,wf12(:,25))
  call Hloop_AQ_V(ntry,G0H72(1),wf12(:,25),G0H6(6),m3h12x6(:,6),heltab2x72(:,:,106))
Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(44)
call G0_hol_initialisation(ntry,Gcoeff,G0H72(1),m0h(107),h0tab(:,107),[22,1,8],[0,0,0],3,1,wf12(:,27))
  call Hloop_QA_V(ntry,G0H72(1),wf12(:,27),G0H6(7),m3h12x6(:,7),heltab2x72(:,:,107))
Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(28)
call G0_hol_initialisation(ntry,Gcoeff,G0H72(1),m0h(108),h0tab(:,108),[26,1,4],[0,0,0],3,1,wf12(:,21))
  call Hloop_QA_V(ntry,G0H72(1),wf12(:,21),G0H6(8),m3h12x6(:,8),heltab2x72(:,:,108))
  call ol_merge(ntry,G1H6(20),[G1H6(5)])
  call ol_merge(ntry,G1H6(30),[G1H6(12)])
  call ol_merge(ntry,G1H18(10),[G1H18(15)])
  call ol_merge(ntry,G1H18(11),[G1H18(19)])
  call ol_merge(ntry,G0H6(5),[G0H6(1)])
  call ol_merge(ntry,G0H6(7),[G0H6(2)])
  call ol_merge(ntry,G0H6(6),[G0H6(3)])
  call ol_merge(ntry,G0H6(8),[G0H6(4)])
  call Hloop_QZ_A(ntry,G1H6(20),ex4(:),G1H2(1),ngZd,m3h3x2(:,33),heltab2x6(:,:,67))
  call Hloop_Q_A(ntry,G1H2(1),29,0,G2H2(4),n2h2(31))
  call Hloop_QZ_A(ntry,G1H6(30),ex3(:),G1H2(2),ngZd,m3h3x2(:,34),heltab2x6(:,:,68))
  call Hloop_Q_A(ntry,G1H2(2),29,0,G2H2(11),n2h2(32))
  call Hloop_QZ_A(ntry,G1H9(13),ex3(:),G1H3(51),ngZd,m3h3x3(:,101),heltab2x9(:,:,101))
  call Hloop_Q_A(ntry,G1H3(51),23,0,G2H3(2),n2h3(127))
  call Hloop_QZ_A(ntry,G1H9(20),ex4(:),G1H3(11),ngZd,m3h3x3(:,102),heltab2x9(:,:,102))
  call Hloop_Q_A(ntry,G1H3(11),27,0,G2H3(6),n2h3(128))
  call Hloop_AZ_Q(ntry,G1H9(5),ex3(:),G1H3(22),ngZd,m3h3x3(:,103),heltab2x9(:,:,103))
  call Hloop_A_Q(ntry,G1H3(22),23,0,G2H3(9),n2h3(129))
  call Hloop_AZ_Q(ntry,G1H9(12),ex4(:),G1H3(44),ngZd,m3h3x3(:,104),heltab2x9(:,:,104))
  call Hloop_A_Q(ntry,G1H3(44),27,0,G2H3(8),n2h3(130))
  call Hloop_QZ_A(ntry,G1H9(1),ex4(:),G1H3(55),ngZu,m3h3x3(:,105),heltab2x9(:,:,105))
  call Hloop_Q_A(ntry,G1H3(55),27,0,G2H3(13),n2h3(131))
  call Hloop_QZ_A(ntry,G1H9(28),ex4(:),G1H3(9),ngZu,m3h3x3(:,106),heltab2x9(:,:,106))
  call Hloop_Q_A(ntry,G1H3(9),27,nMT,G2H3(17),n2h3(132))
  call Hloop_AZ_Q(ntry,G1H9(33),ex4(:),G1H3(1),ngZu,m3h3x3(:,107),heltab2x9(:,:,107))
  call Hloop_A_Q(ntry,G1H3(1),27,0,G2H3(4),n2h3(133))
  call Hloop_AZ_Q(ntry,G1H9(38),ex4(:),G1H3(26),ngZu,m3h3x3(:,108),heltab2x9(:,:,108))
  call Hloop_A_Q(ntry,G1H3(26),27,nMT,G2H3(21),n2h3(134))
  call Hloop_QZ_A(ntry,G1H9(43),ex4(:),G1H3(42),ngZd,m3h3x3(:,109),heltab2x9(:,:,109))
  call Hloop_Q_A(ntry,G1H3(42),27,nMB,G2H3(105),n2h3(135))
  call Hloop_AZ_Q(ntry,G1H9(48),ex4(:),G1H3(10),ngZd,m3h3x3(:,110),heltab2x9(:,:,110))
  call Hloop_A_Q(ntry,G1H3(10),27,nMB,G2H3(5),n2h3(136))
  call Hloop_AZ_Q(ntry,G1H9(53),ex3(:),G1H3(17),ngZu,m3h3x3(:,111),heltab2x9(:,:,111))
  call Hloop_A_Q(ntry,G1H3(17),23,0,G2H3(15),n2h3(137))
  call Hloop_AZ_Q(ntry,G1H9(58),ex3(:),G1H3(21),ngZu,m3h3x3(:,112),heltab2x9(:,:,112))
  call Hloop_A_Q(ntry,G1H3(21),23,nMT,G2H3(99),n2h3(138))
  call Hloop_QZ_A(ntry,G1H9(63),ex3(:),G1H3(39),ngZu,m3h3x3(:,113),heltab2x9(:,:,113))
  call Hloop_Q_A(ntry,G1H3(39),23,0,G2H3(12),n2h3(139))
  call Hloop_QZ_A(ntry,G1H9(68),ex3(:),G1H3(43),ngZu,m3h3x3(:,114),heltab2x9(:,:,114))
  call Hloop_Q_A(ntry,G1H3(43),23,nMT,G2H3(19),n2h3(140))
  call Hloop_AZ_Q(ntry,G1H9(73),ex3(:),G1H3(49),ngZd,m3h3x3(:,115),heltab2x9(:,:,115))
  call Hloop_A_Q(ntry,G1H3(49),23,nMB,G2H3(16),n2h3(141))
  call Hloop_QZ_A(ntry,G1H9(78),ex3(:),G1H3(60),ngZd,m3h3x3(:,116),heltab2x9(:,:,116))
  call Hloop_Q_A(ntry,G1H3(60),23,nMB,G2H3(18),n2h3(142))
  call Hloop_QV_A(ntry,G1H12(3),wf4(:,5),G1H3(64),m3h4x3(:,33),heltab2x12(:,:,45))
  call Hloop_Q_A(ntry,G1H3(64),23,0,G2H3(20),n2h3(143))
  call Hloop_QV_A(ntry,G1H12(8),wf4(:,5),G1H3(65),m3h4x3(:,34),heltab2x12(:,:,46))
  call Hloop_Q_A(ntry,G1H3(65),23,nMT,G2H3(22),n2h3(144))
  call Hloop_AV_Q(ntry,G1H12(13),wf4(:,5),G1H3(76),m3h4x3(:,35),heltab2x12(:,:,47))
  call Hloop_A_Q(ntry,G1H3(76),23,0,G2H3(1),n2h3(145))
  call Hloop_AV_Q(ntry,G1H12(18),wf4(:,5),G1H3(77),m3h4x3(:,36),heltab2x12(:,:,48))
  call Hloop_A_Q(ntry,G1H3(77),23,nMT,G2H3(3),n2h3(146))
  call Hloop_QV_A(ntry,G1H12(23),wf4(:,5),G1H3(78),m3h4x3(:,37),heltab2x12(:,:,49))
  call Hloop_Q_A(ntry,G1H3(78),23,0,G2H3(7),n2h3(147))
  call Hloop_QV_A(ntry,G1H12(28),wf4(:,5),G1H3(81),m3h4x3(:,38),heltab2x12(:,:,50))
  call Hloop_Q_A(ntry,G1H3(81),23,nMB,G2H3(107),n2h3(148))
  call Hloop_AV_Q(ntry,G1H12(33),wf4(:,5),G1H3(82),m3h4x3(:,39),heltab2x12(:,:,51))
  call Hloop_A_Q(ntry,G1H3(82),23,0,G2H3(23),n2h3(149))
  call Hloop_AV_Q(ntry,G1H12(38),wf4(:,5),G1H3(83),m3h4x3(:,40),heltab2x12(:,:,52))
  call Hloop_A_Q(ntry,G1H3(83),23,nMB,G2H3(26),n2h3(150))
  call Hloop_AZ_Q(ntry,G1H18(2),ex4(:),G1H6(42),ngZd,m3h3x6(:,23),heltab2x18(:,:,41))
  call Hloop_A_Q(ntry,G1H6(42),26,0,G2H6(6),n2h6(35))
  call Hloop_QZ_A(ntry,G1H18(8),ex4(:),G1H6(43),ngZd,m3h3x6(:,24),heltab2x18(:,:,42))
  call Hloop_Q_A(ntry,G1H6(43),25,0,G2H6(7),n2h6(36))
  call Hloop_AZ_Q(ntry,G1H18(10),ex3(:),G1H6(1),ngZd,m3h3x6(:,25),heltab2x18(:,:,43))
  call Hloop_A_Q(ntry,G1H6(1),22,0,G2H6(9),n2h6(37))
  call Hloop_QZ_A(ntry,G1H18(11),ex3(:),G1H6(2),ngZd,m3h3x6(:,26),heltab2x18(:,:,44))
  call Hloop_Q_A(ntry,G1H6(2),21,0,G2H6(1),n2h6(38))
  call Hloop_AV_Q(ntry,G1H36(1),wf4(:,5),G1H9(9),m3h4x9(:,17),heltab2x36(:,:,45))
  call Hloop_A_Q(ntry,G1H9(9),19,nMT,G2H9(15),n2h9(45))
  call Hloop_QV_A(ntry,G1H36(2),wf4(:,5),G1H9(10),m3h4x9(:,18),heltab2x36(:,:,46))
  call Hloop_Q_A(ntry,G1H9(10),19,nMT,G2H9(5),n2h9(46))
  call Hloop_AV_Q(ntry,G1H36(3),wf4(:,5),G1H9(14),m3h4x9(:,19),heltab2x36(:,:,47))
  call Hloop_A_Q(ntry,G1H9(14),19,nMB,G2H9(13),n2h9(47))
  call Hloop_QV_A(ntry,G1H36(4),wf4(:,5),G1H9(15),m3h4x9(:,20),heltab2x36(:,:,48))
  call Hloop_Q_A(ntry,G1H9(15),19,nMB,G2H9(7),n2h9(48))
  call Hloop_AQ_V(ntry,G1H36(5),wf6(:,3),G1H6(6),m3h6x6(:,3),heltab2x36(:,:,49))
  call Hloop_VQ_A(ntry,G1H36(6),wf6(:,3),G1H6(7),m3h6x6(:,4),heltab2x36(:,:,50))
  call Hloop_Q_A(ntry,G1H6(7),21,0,G2H6(2),n2h6(39))
  call Hloop_VQ_A(ntry,G0H18(1),wf6(:,3),G0H3(1),m3h6x3(:,9),heltab2x18(:,:,45))
  call Hloop_Q_A(ntry,G0H3(1),23,0,G1H3(86),n2h3(151))
  call Hloop_AV_Q(ntry,G1H36(7),wf12(:,6),G1H3(87),m3h12x3(:,1),heltab2x36(:,:,51))
  call Hloop_A_Q(ntry,G1H3(87),23,0,G2H3(10),n2h3(152))
  call Hloop_AV_Q(ntry,G1H36(8),wf12(:,6),G1H3(88),m3h12x3(:,2),heltab2x36(:,:,52))
  call Hloop_A_Q(ntry,G1H3(88),23,nMT,G2H3(101),n2h3(153))
  call Hloop_QV_A(ntry,G1H36(9),wf12(:,6),G1H3(91),m3h12x3(:,3),heltab2x36(:,:,53))
  call Hloop_Q_A(ntry,G1H3(91),23,0,G2H3(27),n2h3(154))
  call Hloop_QV_A(ntry,G1H36(10),wf12(:,6),G1H3(92),m3h12x3(:,4),heltab2x36(:,:,54))
  call Hloop_Q_A(ntry,G1H3(92),23,nMT,G2H3(30),n2h3(155))
  call Hloop_AV_Q(ntry,G1H36(11),wf12(:,6),G1H3(93),m3h12x3(:,5),heltab2x36(:,:,55))
  call Hloop_A_Q(ntry,G1H3(93),23,0,G2H3(11),n2h3(156))
  call Hloop_AV_Q(ntry,G1H36(12),wf12(:,6),G1H3(96),m3h12x3(:,6),heltab2x36(:,:,56))
  call Hloop_A_Q(ntry,G1H3(96),23,nMB,G2H3(31),n2h3(157))
  call Hloop_QV_A(ntry,G1H36(13),wf12(:,6),G1H3(97),m3h12x3(:,7),heltab2x36(:,:,57))
  call Hloop_Q_A(ntry,G1H3(97),23,0,G2H3(34),n2h3(158))
  call Hloop_QV_A(ntry,G1H36(14),wf12(:,6),G1H3(98),m3h12x3(:,8),heltab2x36(:,:,58))
  call Hloop_Q_A(ntry,G1H3(98),23,nMB,G2H3(14),n2h3(159))
  call Hloop_QA_V(ntry,G1H36(15),ex2(:),G1H18(12),m3h2x18(:,15),heltab2x36(:,:,59))
  call Hloop_VA_Q(ntry,G1H36(16),ex2(:),G1H18(9),m3h2x18(:,16),heltab2x36(:,:,60))
  call Hloop_A_Q(ntry,G1H18(9),18,0,G2H18(1),n2h18(15))
  call Hloop_VA_Q(ntry,G0H6(5),ex2(:),G0H3(1),m3h2x3(:,21),heltab2x6(:,:,69))
  call Hloop_A_Q(ntry,G0H3(1),23,0,G1H3(101),n2h3(160))



end subroutine vamp_1

end module ol_vamp_1_ppzzj_ddxzzg_1_/**/REALKIND
