
module ol_colourmatrix_ppzzj2loop_ddxzzg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  logical, save           :: colmat_not_initialised = .true.
  complex(REALKIND), save :: K1(17,1), K2(17,1), Cas(5) = 0
  contains
  subroutine colourmatrix_init
    use ol_parameters_decl_/**/REALKIND, only: CI
    implicit none
    integer :: k, co
    colmat_not_initialised = .false.
    ! colour matrix

  K1( 1,:) = [ 4]
  K1( 2,:) = [ 0]
  K1( 3,:) = [ 0]
  K1( 4,:) = [ 0]
  K1( 5,:) = [ 0]
  K1( 6,:) = [ 0]
  K1( 7,:) = [ 0]
  K1( 8,:) = [ 0]
  K1( 9,:) = [ 0]
  K1(10,:) = [ 0]
  K1(11,:) = [ 0]
  K1(12,:) = [ 0]
  K1(13,:) = [ 0]
  K1(14,:) = [ 0]
  K1(15,:) = [ 0]
  K1(16,:) = [ 0]
  K1(17,:) = [ 4]

  K2( 1,:) = [ 4]
  K2( 2,:) = [ 0]
  K2( 3,:) = [ 0]
  K2( 4,:) = [ 0]
  K2( 5,:) = [ 0]
  K2( 6,:) = [ 0]
  K2( 7,:) = [ 0]
  K2( 8,:) = [ 0]
  K2( 9,:) = [ 0]
  K2(10,:) = [ 0]
  K2(11,:) = [ 0]
  K2(12,:) = [ 0]
  K2(13,:) = [ 0]
  K2(14,:) = [ 0]
  K2(15,:) = [ 0]
  K2(16,:) = [ 0]
  K2(17,:) = [ 4]

#if 1 > 0
    co = 0
    do k = 1, 5
      co = co + k
      Cas(k) = K1(1+1*co,1)/K1(1,1)
    end do
#endif
  end subroutine colourmatrix_init
end module ol_colourmatrix_ppzzj2loop_ddxzzg_1_/**/REALKIND



module ol_forced_parameters_ppzzj2loop_ddxzzg_1_/**/REALKIND
  implicit none
  contains
  subroutine check_forced_parameters
    use ol_parameters_decl_/**/REALKIND
    use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
    use ol_loop_parameters_decl_/**/DREALKIND, only: LeadingColour, nc, nf, CKMORDER
#endif
    implicit none
    logical, save :: checks_not_written = .true.

    if (checks_not_written) then
    ! e.g.
    ! if (ME /= 0) write(*,101) 'ME = 0'
  if (CKMORDER /= 0) write(*,101) 'CKMORDER = 0'
  if (nc /= 3) write(*,101) 'nc = 3'
  if (nf /= 6) write(*,101) 'nf = 6'
  if (MU /= 0) write(*,101) 'MU = 0'
  if (MD /= 0) write(*,101) 'MD = 0'
  if (MS /= 0) write(*,101) 'MS = 0'
  if (MC /= 0) write(*,101) 'MC = 0'
  if (LeadingColour /= 0) write(*,101) 'LeadingColour = 0'
  if (wMZ /= 0) write(*,101) 'wMZ = 0'
  if (wMZ /= 0) write(*,101) 'wMZ = 0'


    checks_not_written = .false.
    end if

    101 format('[OpenLoops] === WARNING ===',/,'[OpenLoops] code was generated with ',A,/,'[OpenLoops] ===============')
  end subroutine check_forced_parameters
end module ol_forced_parameters_ppzzj2loop_ddxzzg_1_/**/REALKIND


! **********************************************************************
module ol_loop_storage_ppzzj2loop_ddxzzg_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, intkind1, intkind2
  use ol_debug, only: ol_msg
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont

#ifdef PRECISION_dp
  integer(intkind1), save :: ntryL = 1
  integer(intkind1), save :: p_switch = 0 ! switch for dp or qp. Used for memory allocation of the OL types
  ! the following are flags for memory allocation of the hol coefficients in dp or qp
  logical, save :: dp_not_alloc = .TRUE., qp_not_alloc = .TRUE.
  integer, save :: n_merge_steps  ! total number of merging steps
  integer, save :: n_merge_mism   ! number of merging mismatches
  integer, save :: merge_step = 1 ! current merging step
  integer(intkind2), save, allocatable :: merge_tables(:,:,:) ! merging tables
  integer(intkind2), save, allocatable :: merge_mism(:)       ! array of merging mismatches
  integer(intkind2), save, allocatable :: merge_hels(:)       ! array with relevant helicities for a merging step
  logical, save :: merge_tables_on = .false.
  integer(intkind2), parameter :: nheltot = 72 ! number of helicity configurations
  integer(intkind2), save :: nhel = 72 ! number of non-vanishing helicity configurations (adapted at runtime)
  integer(intkind2), save :: hel_states = 72 ! number of helicity configurations needed for mem-allocation
  integer(intkind2), save :: Hel(72) ! physical helicity states
  integer(intkind2), save :: nhflip = 72    ! relevant helicities for helicity-flipped interference
  integer(intkind2), save :: helflip(2,72) ! Table for the helicity-flipped interference
  integer(intkind2), save, allocatable :: hflip(:,:)
  integer(intkind2) :: tsb
  integer, save :: pi_flip_bak = -1, pj_flip_bak = -1
#endif

  type(Hpolcont), save, allocatable :: A(:,:), M1helarray(:,:), M1helarray_ct(:,:)
  complex(REALKIND), save :: den(66)

  ! external wave functions ex1(h1),... for h<n> helicities
  type(wfun) :: ex1(2), ex2(2), ex3(3), ex4(3), ex5(2)

  ! wf<h>(h,n) n wave functions with h helicity configurations
  type(wfun) :: wf2(2,66), wf3(3,28), wf4(4,100), wf6(6,420), wf8(8,64), wf9(9,36), wf12(12,170), wf18(18,316), wf24(24,116), &
    wf36(36,20), wf72(72,3730)

  ! diagram prefactors
  integer,           save :: fac_status_loop1 = -1, fac_status_loop2 = -1
  complex(REALKIND), save :: f(676), c(0)

  !Vector in helicity and colour space for Born-Loop interference
  type(Hpolcont),   save, allocatable :: M0_col1_helarray(:,:), M0M1_hel_cc(:,:,:)
  complex(REALKIND), save :: M2ctcc(16)

end module ol_loop_storage_ppzzj2loop_ddxzzg_1_/**/REALKIND






! **********************************************************************
module ol_loop_ppzzj2loop_ddxzzg_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, DREALKIND, intkind1, intkind2
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont
  use ol_loop_storage_ppzzj2loop_ddxzzg_1_/**/REALKIND
  implicit none

!*********************************************************************************
  contains

! **********************************************************************
subroutine fac_init_loop(P)
! Writes diagram prefactors to 'f', rsp. 'c'
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND
  use ol_init, only: set_parameter, tree_parameters_flush, parameters_flush
  use ol_ewsud_/**/REALKIND
  use ol_ewsud2loop_/**/REALKIND

#ifndef PRECISION_dp
  use ol_loop_parameters_decl_/**/DREALKIND, only: SwF, SwB
!  use ol_loop_parameters_decl_/**/DREALKIND, only: DOI
#endif
  implicit none
  real(REALKIND)    :: P(0:3,5)
  call set_parameter("ew_renorm", 1)

  if (1 > 0) then
    compute_sudakovEW = 1
  else
    compute_sudakovEW = 0
  end if

  if (parameters_status == 0) call tree_parameters_flush()
  if (loop_parameters_status == 0) call parameters_flush()
  fac_status_loop1 = parameters_status
  fac_status_loop2 = loop_parameters_status
  ! factors of the diagrams
    f(  1) = CI*eQED**2*gQCD
    f(  2) = CI*countertermnorm*ct1L*eQED**4*gQCD
    f(  3) = (CI*countertermnorm*eQED**4*gQCD*logEWs(1,1,nMReg,P,0,0,1))/9._/**/REALKIND
    f(  4) = (CI*countertermnorm*eQED**4*gQCD*logEWs(1,1,nMW,P,0,0,1))/(2._/**/REALKIND*sw**2)
    f(  5) = CI*countertermnorm*eQED**4*gQCD*logEWs(1,1,nMZ,P,0,0,1)
    f(  6) = (CI*countertermnorm*eQED**4*gQCD*logEWs(2,1,nMReg,P,0,0,1))/9._/**/REALKIND
    f(  7) = (CI*countertermnorm*eQED**4*gQCD*logEWs(2,1,nMW,P,0,0,1))/(2._/**/REALKIND*sw**2)
    f(  8) = CI*countertermnorm*eQED**4*gQCD*logEWs(2,1,nMZ,P,0,0,1)
    f(  9) = (CI*countertermnorm*eQED**4*gQCD*logEWs(2,2,nMReg,P,0,0,1))/9._/**/REALKIND
    f( 10) = (CI*countertermnorm*eQED**4*gQCD*logEWs(2,2,nMW,P,0,0,1))/(2._/**/REALKIND*sw**2)
    f( 11) = CI*countertermnorm*eQED**4*gQCD*logEWs(2,2,nMZ,P,0,0,1)
    f( 12) = (CI*countertermnorm*cw**2*eQED**4*gQCD*logEWs(3,1,nMW,P,23,24,1))/(2._/**/REALKIND*sw**4)
    f( 13) = (CI*countertermnorm*cw*eQED**4*gQCD*logEWs(3,1,nMW,P,23,24,1))/(2._/**/REALKIND*sw**3)
    f( 14) = (CI*countertermnorm*cw**2*eQED**4*gQCD*logEWs(3,2,nMW,P,23,24,1))/(2._/**/REALKIND*sw**4)
    f( 15) = (CI*countertermnorm*cw*eQED**4*gQCD*logEWs(3,2,nMW,P,23,24,1))/(2._/**/REALKIND*sw**3)
    f( 16) = (CI*countertermnorm*cw*eQED**4*gQCD*logEWs(3,3,nMW,P,23,22,1))/(3._/**/REALKIND*sw)
    f( 17) = (CI*countertermnorm*cw**2*eQED**4*gQCD*logEWs(3,3,nMW,P,23,23,1))/sw**2
    f( 18) = (CI*countertermnorm*cw**2*eQED**4*gQCD*logEWs(4,1,nMW,P,23,24,1))/(2._/**/REALKIND*sw**4)
    f( 19) = (CI*countertermnorm*cw*eQED**4*gQCD*logEWs(4,1,nMW,P,23,24,1))/(2._/**/REALKIND*sw**3)
    f( 20) = (CI*countertermnorm*cw**2*eQED**4*gQCD*logEWs(4,2,nMW,P,23,24,1))/(2._/**/REALKIND*sw**4)
    f( 21) = (CI*countertermnorm*cw*eQED**4*gQCD*logEWs(4,2,nMW,P,23,24,1))/(2._/**/REALKIND*sw**3)
    f( 22) = (CI*countertermnorm*cw**2*eQED**4*gQCD*logEWs(4,3,nMW,P,23,24,1))/(2._/**/REALKIND*sw**4)
    f( 23) = (CI*countertermnorm*cw**3*eQED**4*gQCD*logEWs(4,3,nMW,P,23,24,1))/sw**3
    f( 24) = (CI*countertermnorm*cw**2*eQED**4*gQCD*logEWs(4,3,nMW,P,23,24,1))/(3._/**/REALKIND*sw**2)
    f( 25) = (CI*countertermnorm*cw*eQED**4*gQCD*logEWs(4,4,nMW,P,23,22,1))/(3._/**/REALKIND*sw)
    f( 26) = (CI*countertermnorm*cw**2*eQED**4*gQCD*logEWs(4,4,nMW,P,23,23,1))/sw**2
    f( 27) = (CI*countertermnorm*eQED**6*gQCD*logEWs2loop(1,2,0,0,nMReg,nMReg,P,31))/81._/**/REALKIND
    f( 28) = (CI*countertermnorm*eQED**6*gQCD*logEWs2loop(1,2,0,0,nMW,nMW,P,31))/(4._/**/REALKIND*sw**4)
    f( 29) = CI*countertermnorm*eQED**6*gQCD*logEWs2loop(1,2,0,0,nMZ,nMZ,P,31)
    f( 30) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loop(1,2,1,3,nMW,nMW,P,211))/(2._/**/REALKIND*sw**6)
    f( 31) = (CI*countertermnorm*cw*eQED**6*gQCD*logEWs2loop(1,2,1,3,nMW,nMW,P,211))/(2._/**/REALKIND*sw**5)
    f( 32) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loop(1,2,1,4,nMW,nMW,P,211))/(2._/**/REALKIND*sw**6)
    f( 33) = (CI*countertermnorm*cw*eQED**6*gQCD*logEWs2loop(1,2,1,4,nMW,nMW,P,211))/(2._/**/REALKIND*sw**5)
    f( 34) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loop(1,3,0,0,nMW,nMW,P,31))/(4._/**/REALKIND*sw**6)
    f( 35) = (CI*countertermnorm*cw*eQED**6*gQCD*logEWs2loop(1,3,0,0,nMW,nMW,P,31))/(4._/**/REALKIND*sw**5)
    f( 36) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loop(1,3,1,4,nMW,nMW,P,211))/(2._/**/REALKIND*sw**6)
    f( 37) = (CI*countertermnorm*cw**3*eQED**6*gQCD*logEWs2loop(1,3,1,4,nMW,nMW,P,211))/sw**5
    f( 38) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loop(1,3,1,4,nMW,nMW,P,211))/(3._/**/REALKIND*sw**4)
    f( 39) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loop(1,4,0,0,nMW,nMW,P,31))/(4._/**/REALKIND*sw**6)
    f( 40) = (CI*countertermnorm*cw*eQED**6*gQCD*logEWs2loop(1,4,0,0,nMW,nMW,P,31))/(4._/**/REALKIND*sw**5)
    f( 41) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loop(1,4,1,3,nMW,nMW,P,211))/(2._/**/REALKIND*sw**6)
    f( 42) = (CI*countertermnorm*cw**3*eQED**6*gQCD*logEWs2loop(1,4,1,3,nMW,nMW,P,211))/sw**5
    f( 43) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loop(1,4,1,3,nMW,nMW,P,211))/(3._/**/REALKIND*sw**4)
    f( 44) = (CI*countertermnorm*eQED**6*gQCD*logEWs2loop(2,1,0,0,nMReg,nMReg,P,22))/81._/**/REALKIND
    f( 45) = (CI*countertermnorm*eQED**6*gQCD*logEWs2loop(2,1,0,0,nMReg,nMReg,P,31))/81._/**/REALKIND
    f( 46) = (CI*countertermnorm*eQED**6*gQCD*logEWs2loop(2,1,0,0,nMW,nMW,P,22))/(4._/**/REALKIND*sw**4)
    f( 47) = (CI*countertermnorm*eQED**6*gQCD*logEWs2loop(2,1,0,0,nMW,nMW,P,31))/(4._/**/REALKIND*sw**4)
    f( 48) = CI*countertermnorm*eQED**6*gQCD*logEWs2loop(2,1,0,0,nMZ,nMZ,P,22)
    f( 49) = CI*countertermnorm*eQED**6*gQCD*logEWs2loop(2,1,0,0,nMZ,nMZ,P,31)
    f( 50) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loop(2,1,2,3,nMW,nMW,P,211))/(2._/**/REALKIND*sw**6)
    f( 51) = (CI*countertermnorm*cw*eQED**6*gQCD*logEWs2loop(2,1,2,3,nMW,nMW,P,211))/(2._/**/REALKIND*sw**5)
    f( 52) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loop(2,1,2,4,nMW,nMW,P,211))/(2._/**/REALKIND*sw**6)
    f( 53) = (CI*countertermnorm*cw*eQED**6*gQCD*logEWs2loop(2,1,2,4,nMW,nMW,P,211))/(2._/**/REALKIND*sw**5)
    f( 54) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loop(2,3,0,0,nMW,nMW,P,31))/(4._/**/REALKIND*sw**6)
    f( 55) = (CI*countertermnorm*cw*eQED**6*gQCD*logEWs2loop(2,3,0,0,nMW,nMW,P,31))/(4._/**/REALKIND*sw**5)
    f( 56) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loop(2,3,2,4,nMW,nMW,P,211))/(2._/**/REALKIND*sw**6)
    f( 57) = (CI*countertermnorm*cw**3*eQED**6*gQCD*logEWs2loop(2,3,2,4,nMW,nMW,P,211))/sw**5
    f( 58) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loop(2,3,2,4,nMW,nMW,P,211))/(3._/**/REALKIND*sw**4)
    f( 59) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loop(2,4,0,0,nMW,nMW,P,31))/(4._/**/REALKIND*sw**6)
    f( 60) = (CI*countertermnorm*cw*eQED**6*gQCD*logEWs2loop(2,4,0,0,nMW,nMW,P,31))/(4._/**/REALKIND*sw**5)
    f( 61) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loop(2,4,2,3,nMW,nMW,P,211))/(2._/**/REALKIND*sw**6)
    f( 62) = (CI*countertermnorm*cw**3*eQED**6*gQCD*logEWs2loop(2,4,2,3,nMW,nMW,P,211))/sw**5
    f( 63) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loop(2,4,2,3,nMW,nMW,P,211))/(3._/**/REALKIND*sw**4)
    f( 64) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loop(3,1,0,0,nMW,nMW,P,22))/(2._/**/REALKIND*sw**4)
    f( 65) = (CI*countertermnorm*cw*eQED**6*gQCD*logEWs2loop(3,1,0,0,nMW,nMW,P,22))/(6._/**/REALKIND*sw**3)
    f( 66) = (CI*countertermnorm*cw**4*eQED**6*gQCD*logEWs2loop(3,1,0,0,nMW,nMW,P,31))/(2._/**/REALKIND*sw**6)
    f( 67) = (CI*countertermnorm*cw**3*eQED**6*gQCD*logEWs2loop(3,1,0,0,nMW,nMW,P,31))/(2._/**/REALKIND*sw**5)
    f( 68) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loop(3,1,0,0,nMW,nMW,P,31))/(2._/**/REALKIND*sw**4)
    f( 69) = (CI*countertermnorm*cw*eQED**6*gQCD*logEWs2loop(3,1,0,0,nMW,nMW,P,31))/(2._/**/REALKIND*sw**3)
    f( 70) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loop(3,1,3,2,nMW,nMW,P,211))/sw**4
    f( 71) = (2*CI*countertermnorm*cw*eQED**6*gQCD*logEWs2loop(3,1,3,2,nMW,nMW,P,211))/(3._/**/REALKIND*sw**3)
    f( 72) = (CI*countertermnorm*cw**4*eQED**6*gQCD*logEWs2loop(3,1,3,4,nMW,nMW,P,211))/sw**6
    f( 73) = (CI*countertermnorm*cw**3*eQED**6*gQCD*logEWs2loop(3,1,3,4,nMW,nMW,P,211))/sw**5
    f( 74) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loop(3,1,3,4,nMW,nMW,P,211))/(3._/**/REALKIND*sw**4)
    f( 75) = (2*CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loop(3,1,3,4,nMW,nMW,P,211))/(3._/**/REALKIND*sw**4)
    f( 76) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loop(3,1,3,4,nMW,nMW,P,211))/sw**4
    f( 77) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loop(3,2,0,0,nMW,nMW,P,22))/(2._/**/REALKIND*sw**4)
    f( 78) = (CI*countertermnorm*cw*eQED**6*gQCD*logEWs2loop(3,2,0,0,nMW,nMW,P,22))/(6._/**/REALKIND*sw**3)
    f( 79) = (CI*countertermnorm*cw**4*eQED**6*gQCD*logEWs2loop(3,2,0,0,nMW,nMW,P,31))/(2._/**/REALKIND*sw**6)
    f( 80) = (CI*countertermnorm*cw**3*eQED**6*gQCD*logEWs2loop(3,2,0,0,nMW,nMW,P,31))/(2._/**/REALKIND*sw**5)
    f( 81) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loop(3,2,0,0,nMW,nMW,P,31))/(2._/**/REALKIND*sw**4)
    f( 82) = (CI*countertermnorm*cw*eQED**6*gQCD*logEWs2loop(3,2,0,0,nMW,nMW,P,31))/(2._/**/REALKIND*sw**3)
    f( 83) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loop(3,2,3,1,nMW,nMW,P,211))/sw**4
    f( 84) = (2*CI*countertermnorm*cw*eQED**6*gQCD*logEWs2loop(3,2,3,1,nMW,nMW,P,211))/(3._/**/REALKIND*sw**3)
    f( 85) = (CI*countertermnorm*cw**4*eQED**6*gQCD*logEWs2loop(3,2,3,4,nMW,nMW,P,211))/sw**6
    f( 86) = (CI*countertermnorm*cw**3*eQED**6*gQCD*logEWs2loop(3,2,3,4,nMW,nMW,P,211))/sw**5
    f( 87) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loop(3,2,3,4,nMW,nMW,P,211))/(3._/**/REALKIND*sw**4)
    f( 88) = (2*CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loop(3,2,3,4,nMW,nMW,P,211))/(3._/**/REALKIND*sw**4)
    f( 89) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loop(3,2,3,4,nMW,nMW,P,211))/sw**4
    f( 90) = (CI*countertermnorm*cw**4*eQED**6*gQCD*logEWs2loop(3,4,0,0,nMW,nMW,P,31))/(2._/**/REALKIND*sw**6)
    f( 91) = (CI*countertermnorm*cw**5*eQED**6*gQCD*logEWs2loop(3,4,0,0,nMW,nMW,P,31))/sw**5
    f( 92) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loop(3,4,0,0,nMW,nMW,P,31))/(2._/**/REALKIND*sw**4)
    f( 93) = (CI*countertermnorm*cw**4*eQED**6*gQCD*logEWs2loop(3,4,0,0,nMW,nMW,P,31))/(3._/**/REALKIND*sw**4)
    f( 94) = (CI*countertermnorm*cw**3*eQED**6*gQCD*logEWs2loop(3,4,0,0,nMW,nMW,P,31))/sw**3
    f( 95) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loop(3,4,0,0,nMW,nMW,P,31))/(3._/**/REALKIND*sw**2)
    f( 96) = (CI*countertermnorm*cw**4*eQED**6*gQCD*logEWs2loop(3,4,3,1,nMW,nMW,P,211))/sw**6
    f( 97) = (CI*countertermnorm*cw**3*eQED**6*gQCD*logEWs2loop(3,4,3,1,nMW,nMW,P,211))/sw**5
    f( 98) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loop(3,4,3,1,nMW,nMW,P,211))/(3._/**/REALKIND*sw**4)
    f( 99) = (2*CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loop(3,4,3,1,nMW,nMW,P,211))/(3._/**/REALKIND*sw**4)
    f(100) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loop(3,4,3,1,nMW,nMW,P,211))/sw**4
    f(101) = (CI*countertermnorm*cw**4*eQED**6*gQCD*logEWs2loop(3,4,3,2,nMW,nMW,P,211))/sw**6
    f(102) = (CI*countertermnorm*cw**3*eQED**6*gQCD*logEWs2loop(3,4,3,2,nMW,nMW,P,211))/sw**5
    f(103) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loop(3,4,3,2,nMW,nMW,P,211))/(3._/**/REALKIND*sw**4)
    f(104) = (2*CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loop(3,4,3,2,nMW,nMW,P,211))/(3._/**/REALKIND*sw**4)
    f(105) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loop(3,4,3,2,nMW,nMW,P,211))/sw**4
    f(106) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loop(4,1,0,0,nMW,nMW,P,22))/(2._/**/REALKIND*sw**4)
    f(107) = (CI*countertermnorm*cw*eQED**6*gQCD*logEWs2loop(4,1,0,0,nMW,nMW,P,22))/(6._/**/REALKIND*sw**3)
    f(108) = (CI*countertermnorm*cw**4*eQED**6*gQCD*logEWs2loop(4,1,0,0,nMW,nMW,P,31))/(2._/**/REALKIND*sw**6)
    f(109) = (CI*countertermnorm*cw**3*eQED**6*gQCD*logEWs2loop(4,1,0,0,nMW,nMW,P,31))/(2._/**/REALKIND*sw**5)
    f(110) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loop(4,1,0,0,nMW,nMW,P,31))/(2._/**/REALKIND*sw**4)
    f(111) = (CI*countertermnorm*cw*eQED**6*gQCD*logEWs2loop(4,1,0,0,nMW,nMW,P,31))/(2._/**/REALKIND*sw**3)
    f(112) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loop(4,1,3,2,nMW,nMW,P,1111))/(4._/**/REALKIND*sw**6)
    f(113) = (CI*countertermnorm*cw**3*eQED**6*gQCD*logEWs2loop(4,1,3,2,nMW,nMW,P,1111))/(2._/**/REALKIND*sw**5)
    f(114) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loop(4,1,3,2,nMW,nMW,P,1111))/(3._/**/REALKIND*sw**4)
    f(115) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loop(4,1,4,2,nMW,nMW,P,211))/sw**4
    f(116) = (2*CI*countertermnorm*cw*eQED**6*gQCD*logEWs2loop(4,1,4,2,nMW,nMW,P,211))/(3._/**/REALKIND*sw**3)
    f(117) = (CI*countertermnorm*cw**4*eQED**6*gQCD*logEWs2loop(4,1,4,3,nMW,nMW,P,211))/sw**6
    f(118) = (CI*countertermnorm*cw**3*eQED**6*gQCD*logEWs2loop(4,1,4,3,nMW,nMW,P,211))/sw**5
    f(119) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loop(4,1,4,3,nMW,nMW,P,211))/(3._/**/REALKIND*sw**4)
    f(120) = (2*CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loop(4,1,4,3,nMW,nMW,P,211))/(3._/**/REALKIND*sw**4)
    f(121) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loop(4,1,4,3,nMW,nMW,P,211))/sw**4
    f(122) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loop(4,2,0,0,nMW,nMW,P,22))/(2._/**/REALKIND*sw**4)
    f(123) = (CI*countertermnorm*cw*eQED**6*gQCD*logEWs2loop(4,2,0,0,nMW,nMW,P,22))/(6._/**/REALKIND*sw**3)
    f(124) = (CI*countertermnorm*cw**4*eQED**6*gQCD*logEWs2loop(4,2,0,0,nMW,nMW,P,31))/(2._/**/REALKIND*sw**6)
    f(125) = (CI*countertermnorm*cw**3*eQED**6*gQCD*logEWs2loop(4,2,0,0,nMW,nMW,P,31))/(2._/**/REALKIND*sw**5)
    f(126) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loop(4,2,0,0,nMW,nMW,P,31))/(2._/**/REALKIND*sw**4)
    f(127) = (CI*countertermnorm*cw*eQED**6*gQCD*logEWs2loop(4,2,0,0,nMW,nMW,P,31))/(2._/**/REALKIND*sw**3)
    f(128) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loop(4,2,3,1,nMW,nMW,P,1111))/(4._/**/REALKIND*sw**6)
    f(129) = (CI*countertermnorm*cw**3*eQED**6*gQCD*logEWs2loop(4,2,3,1,nMW,nMW,P,1111))/(2._/**/REALKIND*sw**5)
    f(130) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loop(4,2,3,1,nMW,nMW,P,1111))/(3._/**/REALKIND*sw**4)
    f(131) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loop(4,2,4,1,nMW,nMW,P,211))/sw**4
    f(132) = (2*CI*countertermnorm*cw*eQED**6*gQCD*logEWs2loop(4,2,4,1,nMW,nMW,P,211))/(3._/**/REALKIND*sw**3)
    f(133) = (CI*countertermnorm*cw**4*eQED**6*gQCD*logEWs2loop(4,2,4,3,nMW,nMW,P,211))/sw**6
    f(134) = (CI*countertermnorm*cw**3*eQED**6*gQCD*logEWs2loop(4,2,4,3,nMW,nMW,P,211))/sw**5
    f(135) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loop(4,2,4,3,nMW,nMW,P,211))/(3._/**/REALKIND*sw**4)
    f(136) = (2*CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loop(4,2,4,3,nMW,nMW,P,211))/(3._/**/REALKIND*sw**4)
    f(137) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loop(4,2,4,3,nMW,nMW,P,211))/sw**4
    f(138) = (CI*countertermnorm*cw**4*eQED**6*gQCD*logEWs2loop(4,3,0,0,nMW,nMW,P,22))/sw**4
    f(139) = (CI*countertermnorm*cw**3*eQED**6*gQCD*logEWs2loop(4,3,0,0,nMW,nMW,P,22))/(3._/**/REALKIND*sw**3)
    f(140) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loop(4,3,0,0,nMW,nMW,P,22))/(9._/**/REALKIND*sw**2)
    f(141) = (CI*countertermnorm*cw**4*eQED**6*gQCD*logEWs2loop(4,3,0,0,nMW,nMW,P,31))/(2._/**/REALKIND*sw**6)
    f(142) = (CI*countertermnorm*cw**5*eQED**6*gQCD*logEWs2loop(4,3,0,0,nMW,nMW,P,31))/sw**5
    f(143) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loop(4,3,0,0,nMW,nMW,P,31))/(2._/**/REALKIND*sw**4)
    f(144) = (CI*countertermnorm*cw**4*eQED**6*gQCD*logEWs2loop(4,3,0,0,nMW,nMW,P,31))/(3._/**/REALKIND*sw**4)
    f(145) = (CI*countertermnorm*cw**3*eQED**6*gQCD*logEWs2loop(4,3,0,0,nMW,nMW,P,31))/sw**3
    f(146) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loop(4,3,0,0,nMW,nMW,P,31))/(3._/**/REALKIND*sw**2)
    f(147) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loop(4,3,2,1,nMW,nMW,P,1111))/(4._/**/REALKIND*sw**6)
    f(148) = (CI*countertermnorm*cw**3*eQED**6*gQCD*logEWs2loop(4,3,2,1,nMW,nMW,P,1111))/(2._/**/REALKIND*sw**5)
    f(149) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loop(4,3,2,1,nMW,nMW,P,1111))/(3._/**/REALKIND*sw**4)
    f(150) = (CI*countertermnorm*cw**4*eQED**6*gQCD*logEWs2loop(4,3,4,1,nMW,nMW,P,211))/sw**6
    f(151) = (CI*countertermnorm*cw**3*eQED**6*gQCD*logEWs2loop(4,3,4,1,nMW,nMW,P,211))/sw**5
    f(152) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loop(4,3,4,1,nMW,nMW,P,211))/(3._/**/REALKIND*sw**4)
    f(153) = (2*CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loop(4,3,4,1,nMW,nMW,P,211))/(3._/**/REALKIND*sw**4)
    f(154) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loop(4,3,4,1,nMW,nMW,P,211))/sw**4
    f(155) = (CI*countertermnorm*cw**4*eQED**6*gQCD*logEWs2loop(4,3,4,2,nMW,nMW,P,211))/sw**6
    f(156) = (CI*countertermnorm*cw**3*eQED**6*gQCD*logEWs2loop(4,3,4,2,nMW,nMW,P,211))/sw**5
    f(157) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loop(4,3,4,2,nMW,nMW,P,211))/(3._/**/REALKIND*sw**4)
    f(158) = (2*CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loop(4,3,4,2,nMW,nMW,P,211))/(3._/**/REALKIND*sw**4)
    f(159) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loop(4,3,4,2,nMW,nMW,P,211))/sw**4
    f(160) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopD13(3,nMW,2,nMReg,1,nMW,P,111))/(sw**4*6._/**/REALKIND)
    f(161) = (CI*countertermnorm*cw*eQED**6*gQCD*logEWs2loopD13(3,nMW,2,nMReg,1,nMW,P,111))/(sw**3*6._/**/REALKIND)
    f(162) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopD13(3,nMW,2,nMW,1,nMReg,P,111))/(sw**4*6._/**/REALKIND)
    f(163) = (CI*countertermnorm*cw*eQED**6*gQCD*logEWs2loopD13(3,nMW,2,nMW,1,nMReg,P,111))/(sw**3*6._/**/REALKIND)
    f(164) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopD13(4,nMW,2,nMReg,1,nMW,P,111))/(sw**4*6._/**/REALKIND)
    f(165) = (CI*countertermnorm*cw*eQED**6*gQCD*logEWs2loopD13(4,nMW,2,nMReg,1,nMW,P,111))/(sw**3*6._/**/REALKIND)
    f(166) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopD13(4,nMW,2,nMW,1,nMReg,P,111))/(sw**4*6._/**/REALKIND)
    f(167) = (CI*countertermnorm*cw*eQED**6*gQCD*logEWs2loopD13(4,nMW,2,nMW,1,nMReg,P,111))/(sw**3*6._/**/REALKIND)
    f(168) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopD13(4,nMW,3,nMW,1,nMReg,P,111))/(sw**4*6._/**/REALKIND)
    f(169) = (CI*countertermnorm*cw**3*eQED**6*gQCD*logEWs2loopD13(4,nMW,3,nMW,1,nMReg,P,111))/(sw**3*3._/**/REALKIND)
    f(170) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopD13(4,nMW,3,nMW,1,nMReg,P,111))/(sw**2*9._/**/REALKIND)
    f(171) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopD13(4,nMW,3,nMW,2,nMReg,P,111))/(sw**4*6._/**/REALKIND)
    f(172) = (CI*countertermnorm*cw**3*eQED**6*gQCD*logEWs2loopD13(4,nMW,3,nMW,2,nMReg,P,111))/(sw**3*3._/**/REALKIND)
    f(173) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopD13(4,nMW,3,nMW,2,nMReg,P,111))/(sw**2*9._/**/REALKIND)
    f(174) = (CI*countertermnorm*eQED**6*gQCD*logEWs2loopD3(1,nMReg,nMW,2,nMW,P,21))/(sw**2*6._/**/REALKIND)
    f(175) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopD3(1,nMReg,nMW,3,nMW,P,21))/(sw**4*6._/**/REALKIND)
    f(176) = (CI*countertermnorm*cw*eQED**6*gQCD*logEWs2loopD3(1,nMReg,nMW,3,nMW,P,21))/(sw**3*6._/**/REALKIND)
    f(177) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopD3(1,nMReg,nMW,4,nMW,P,21))/(sw**4*6._/**/REALKIND)
    f(178) = (CI*countertermnorm*cw*eQED**6*gQCD*logEWs2loopD3(1,nMReg,nMW,4,nMW,P,21))/(sw**3*6._/**/REALKIND)
    f(179) = (CI*countertermnorm*eQED**6*gQCD*logEWs2loopD3(1,nMW,nMReg,2,nMW,P,21))/(sw**2*3._/**/REALKIND)
    f(180) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopD3(1,nMW,nMReg,3,nMW,P,21))/(sw**4*3._/**/REALKIND)
    f(181) = (CI*countertermnorm*cw*eQED**6*gQCD*logEWs2loopD3(1,nMW,nMReg,3,nMW,P,21))/(sw**3*3._/**/REALKIND)
    f(182) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopD3(1,nMW,nMReg,4,nMW,P,21))/(sw**4*3._/**/REALKIND)
    f(183) = (CI*countertermnorm*cw*eQED**6*gQCD*logEWs2loopD3(1,nMW,nMReg,4,nMW,P,21))/(sw**3*3._/**/REALKIND)
    f(184) = (CI*countertermnorm*eQED**6*gQCD*logEWs2loopD3(1,nMW,nMW,2,nMReg,P,21))/(sw**2*6._/**/REALKIND)
    f(185) = (CI*countertermnorm*cw*eQED**6*gQCD*logEWs2loopD3(1,nMW,nMW,2,nMZ,P,21))/(sw**3*2._/**/REALKIND)
    f(186) = (CI*countertermnorm*cw*eQED**6*gQCD*logEWs2loopD3(1,nMW,nMZ,2,nMW,P,21))/(sw**3*2._/**/REALKIND)
    f(187) = (CI*countertermnorm*cw**3*eQED**6*gQCD*logEWs2loopD3(1,nMW,nMZ,3,nMW,P,21))/(sw**5*2._/**/REALKIND)
    f(188) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopD3(1,nMW,nMZ,3,nMW,P,21))/(sw**4*2._/**/REALKIND)
    f(189) = (CI*countertermnorm*cw**3*eQED**6*gQCD*logEWs2loopD3(1,nMW,nMZ,4,nMW,P,21))/(sw**5*2._/**/REALKIND)
    f(190) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopD3(1,nMW,nMZ,4,nMW,P,21))/(sw**4*2._/**/REALKIND)
    f(191) = (CI*countertermnorm*cw*eQED**6*gQCD*logEWs2loopD3(1,nMZ,nMW,2,nMW,P,21))/(sw**3*2._/**/REALKIND)
    f(192) = (CI*countertermnorm*cw**3*eQED**6*gQCD*logEWs2loopD3(1,nMZ,nMW,3,nMW,P,21))/(sw**5*2._/**/REALKIND)
    f(193) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopD3(1,nMZ,nMW,3,nMW,P,21))/(sw**4*2._/**/REALKIND)
    f(194) = (CI*countertermnorm*cw**3*eQED**6*gQCD*logEWs2loopD3(1,nMZ,nMW,4,nMW,P,21))/(sw**5*2._/**/REALKIND)
    f(195) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopD3(1,nMZ,nMW,4,nMW,P,21))/(sw**4*2._/**/REALKIND)
    f(196) = (CI*countertermnorm*eQED**6*gQCD*logEWs2loopD3(2,nMReg,nMW,1,nMW,P,21))/(sw**2*6._/**/REALKIND)
    f(197) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopD3(2,nMReg,nMW,3,nMW,P,21))/(sw**4*6._/**/REALKIND)
    f(198) = (CI*countertermnorm*cw*eQED**6*gQCD*logEWs2loopD3(2,nMReg,nMW,3,nMW,P,21))/(sw**3*6._/**/REALKIND)
    f(199) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopD3(2,nMReg,nMW,4,nMW,P,21))/(sw**4*6._/**/REALKIND)
    f(200) = (CI*countertermnorm*cw*eQED**6*gQCD*logEWs2loopD3(2,nMReg,nMW,4,nMW,P,21))/(sw**3*6._/**/REALKIND)
    f(201) = (CI*countertermnorm*eQED**6*gQCD*logEWs2loopD3(2,nMW,nMReg,1,nMW,P,21))/(sw**2*3._/**/REALKIND)
    f(202) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopD3(2,nMW,nMReg,3,nMW,P,21))/(sw**4*3._/**/REALKIND)
    f(203) = (CI*countertermnorm*cw*eQED**6*gQCD*logEWs2loopD3(2,nMW,nMReg,3,nMW,P,21))/(sw**3*3._/**/REALKIND)
    f(204) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopD3(2,nMW,nMReg,4,nMW,P,21))/(sw**4*3._/**/REALKIND)
    f(205) = (CI*countertermnorm*cw*eQED**6*gQCD*logEWs2loopD3(2,nMW,nMReg,4,nMW,P,21))/(sw**3*3._/**/REALKIND)
    f(206) = (CI*countertermnorm*eQED**6*gQCD*logEWs2loopD3(2,nMW,nMW,1,nMReg,P,21))/(sw**2*6._/**/REALKIND)
    f(207) = (CI*countertermnorm*cw*eQED**6*gQCD*logEWs2loopD3(2,nMW,nMW,1,nMZ,P,21))/(sw**3*2._/**/REALKIND)
    f(208) = (CI*countertermnorm*cw*eQED**6*gQCD*logEWs2loopD3(2,nMW,nMZ,1,nMW,P,21))/(sw**3*2._/**/REALKIND)
    f(209) = (CI*countertermnorm*cw**3*eQED**6*gQCD*logEWs2loopD3(2,nMW,nMZ,3,nMW,P,21))/(sw**5*2._/**/REALKIND)
    f(210) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopD3(2,nMW,nMZ,3,nMW,P,21))/(sw**4*2._/**/REALKIND)
    f(211) = (CI*countertermnorm*cw**3*eQED**6*gQCD*logEWs2loopD3(2,nMW,nMZ,4,nMW,P,21))/(sw**5*2._/**/REALKIND)
    f(212) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopD3(2,nMW,nMZ,4,nMW,P,21))/(sw**4*2._/**/REALKIND)
    f(213) = (CI*countertermnorm*cw*eQED**6*gQCD*logEWs2loopD3(2,nMZ,nMW,1,nMW,P,21))/(sw**3*2._/**/REALKIND)
    f(214) = (CI*countertermnorm*cw**3*eQED**6*gQCD*logEWs2loopD3(2,nMZ,nMW,3,nMW,P,21))/(sw**5*2._/**/REALKIND)
    f(215) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopD3(2,nMZ,nMW,3,nMW,P,21))/(sw**4*2._/**/REALKIND)
    f(216) = (CI*countertermnorm*cw**3*eQED**6*gQCD*logEWs2loopD3(2,nMZ,nMW,4,nMW,P,21))/(sw**5*2._/**/REALKIND)
    f(217) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopD3(2,nMZ,nMW,4,nMW,P,21))/(sw**4*2._/**/REALKIND)
    f(218) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopD3(3,nMW,nMReg,1,nMW,P,21))/(sw**4*2._/**/REALKIND)
    f(219) = (CI*countertermnorm*cw*eQED**6*gQCD*logEWs2loopD3(3,nMW,nMReg,1,nMW,P,21))/(sw**3*2._/**/REALKIND)
    f(220) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopD3(3,nMW,nMReg,2,nMW,P,21))/(sw**4*2._/**/REALKIND)
    f(221) = (CI*countertermnorm*cw*eQED**6*gQCD*logEWs2loopD3(3,nMW,nMReg,2,nMW,P,21))/(sw**3*2._/**/REALKIND)
    f(222) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopD3(3,nMW,nMReg,4,nMW,P,21))/(sw**4*2._/**/REALKIND)
    f(223) = (CI*countertermnorm*cw**3*eQED**6*gQCD*logEWs2loopD3(3,nMW,nMReg,4,nMW,P,21))/sw**3
    f(224) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopD3(3,nMW,nMReg,4,nMW,P,21))/(sw**2*3._/**/REALKIND)
    f(225) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopD3(3,nMW,nMW,1,nMReg,P,21))/(sw**2*3._/**/REALKIND)
    f(226) = (CI*countertermnorm*cw*eQED**6*gQCD*logEWs2loopD3(3,nMW,nMW,1,nMReg,P,21))/(sw*9._/**/REALKIND)
    f(227) = (CI*countertermnorm*cw**3*eQED**6*gQCD*logEWs2loopD3(3,nMW,nMW,1,nMZ,P,21))/sw**3
    f(228) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopD3(3,nMW,nMW,1,nMZ,P,21))/(sw**2*3._/**/REALKIND)
    f(229) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopD3(3,nMW,nMW,2,nMReg,P,21))/(sw**2*3._/**/REALKIND)
    f(230) = (CI*countertermnorm*cw*eQED**6*gQCD*logEWs2loopD3(3,nMW,nMW,2,nMReg,P,21))/(sw*9._/**/REALKIND)
    f(231) = (CI*countertermnorm*cw**3*eQED**6*gQCD*logEWs2loopD3(3,nMW,nMW,2,nMZ,P,21))/sw**3
    f(232) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopD3(3,nMW,nMW,2,nMZ,P,21))/(sw**2*3._/**/REALKIND)
    f(233) = (CI*countertermnorm*cw**4*eQED**6*gQCD*logEWs2loopD3(3,nMW,nMZ,1,nMW,P,21))/(sw**6*2._/**/REALKIND)
    f(234) = (CI*countertermnorm*cw**3*eQED**6*gQCD*logEWs2loopD3(3,nMW,nMZ,1,nMW,P,21))/(sw**5*2._/**/REALKIND)
    f(235) = (CI*countertermnorm*cw**4*eQED**6*gQCD*logEWs2loopD3(3,nMW,nMZ,2,nMW,P,21))/(sw**6*2._/**/REALKIND)
    f(236) = (CI*countertermnorm*cw**3*eQED**6*gQCD*logEWs2loopD3(3,nMW,nMZ,2,nMW,P,21))/(sw**5*2._/**/REALKIND)
    f(237) = (CI*countertermnorm*cw**4*eQED**6*gQCD*logEWs2loopD3(3,nMW,nMZ,4,nMW,P,21))/(sw**6*2._/**/REALKIND)
    f(238) = (CI*countertermnorm*cw**5*eQED**6*gQCD*logEWs2loopD3(3,nMW,nMZ,4,nMW,P,21))/sw**5
    f(239) = (CI*countertermnorm*cw**4*eQED**6*gQCD*logEWs2loopD3(3,nMW,nMZ,4,nMW,P,21))/(sw**4*3._/**/REALKIND)
    f(240) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopD3(4,nMW,nMReg,1,nMW,P,21))/(sw**4*2._/**/REALKIND)
    f(241) = (CI*countertermnorm*cw*eQED**6*gQCD*logEWs2loopD3(4,nMW,nMReg,1,nMW,P,21))/(sw**3*2._/**/REALKIND)
    f(242) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopD3(4,nMW,nMReg,2,nMW,P,21))/(sw**4*2._/**/REALKIND)
    f(243) = (CI*countertermnorm*cw*eQED**6*gQCD*logEWs2loopD3(4,nMW,nMReg,2,nMW,P,21))/(sw**3*2._/**/REALKIND)
    f(244) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopD3(4,nMW,nMReg,3,nMW,P,21))/(sw**4*2._/**/REALKIND)
    f(245) = (CI*countertermnorm*cw**3*eQED**6*gQCD*logEWs2loopD3(4,nMW,nMReg,3,nMW,P,21))/sw**3
    f(246) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopD3(4,nMW,nMReg,3,nMW,P,21))/(sw**2*3._/**/REALKIND)
    f(247) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopD3(4,nMW,nMW,1,nMReg,P,21))/(sw**2*3._/**/REALKIND)
    f(248) = (CI*countertermnorm*cw*eQED**6*gQCD*logEWs2loopD3(4,nMW,nMW,1,nMReg,P,21))/(sw*9._/**/REALKIND)
    f(249) = (CI*countertermnorm*cw**3*eQED**6*gQCD*logEWs2loopD3(4,nMW,nMW,1,nMZ,P,21))/sw**3
    f(250) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopD3(4,nMW,nMW,1,nMZ,P,21))/(sw**2*3._/**/REALKIND)
    f(251) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopD3(4,nMW,nMW,2,nMReg,P,21))/(sw**2*3._/**/REALKIND)
    f(252) = (CI*countertermnorm*cw*eQED**6*gQCD*logEWs2loopD3(4,nMW,nMW,2,nMReg,P,21))/(sw*9._/**/REALKIND)
    f(253) = (CI*countertermnorm*cw**3*eQED**6*gQCD*logEWs2loopD3(4,nMW,nMW,2,nMZ,P,21))/sw**3
    f(254) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopD3(4,nMW,nMW,2,nMZ,P,21))/(sw**2*3._/**/REALKIND)
    f(255) = (CI*countertermnorm*cw**4*eQED**6*gQCD*logEWs2loopD3(4,nMW,nMZ,1,nMW,P,21))/(sw**6*2._/**/REALKIND)
    f(256) = (CI*countertermnorm*cw**3*eQED**6*gQCD*logEWs2loopD3(4,nMW,nMZ,1,nMW,P,21))/(sw**5*2._/**/REALKIND)
    f(257) = (CI*countertermnorm*cw**4*eQED**6*gQCD*logEWs2loopD3(4,nMW,nMZ,2,nMW,P,21))/(sw**6*2._/**/REALKIND)
    f(258) = (CI*countertermnorm*cw**3*eQED**6*gQCD*logEWs2loopD3(4,nMW,nMZ,2,nMW,P,21))/(sw**5*2._/**/REALKIND)
    f(259) = (CI*countertermnorm*cw**4*eQED**6*gQCD*logEWs2loopD3(4,nMW,nMZ,3,nMW,P,21))/(sw**6*2._/**/REALKIND)
    f(260) = (CI*countertermnorm*cw**5*eQED**6*gQCD*logEWs2loopD3(4,nMW,nMZ,3,nMW,P,21))/sw**5
    f(261) = (CI*countertermnorm*cw**4*eQED**6*gQCD*logEWs2loopD3(4,nMW,nMZ,3,nMW,P,21))/(sw**4*3._/**/REALKIND)
    f(262) = (CI*countertermnorm*eQED**6*gQCD*logEWs2loopMix1(1,2,nMReg,1,1,nMW,P,31))/(18._/**/REALKIND*sw**2)
    f(263) = (CI*countertermnorm*eQED**6*gQCD*logEWs2loopMix1(1,2,nMReg,1,1,nMZ,P,31))/9._/**/REALKIND
    f(264) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopMix1(1,2,nMReg,1,3,nMW,P,211))/(9._/**/REALKIND*sw**4)
    f(265) = (CI*countertermnorm*cw*eQED**6*gQCD*logEWs2loopMix1(1,2,nMReg,1,3,nMW,P,211))/(9._/**/REALKIND*sw**3)
    f(266) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopMix1(1,2,nMReg,1,4,nMW,P,211))/(9._/**/REALKIND*sw**4)
    f(267) = (CI*countertermnorm*cw*eQED**6*gQCD*logEWs2loopMix1(1,2,nMReg,1,4,nMW,P,211))/(9._/**/REALKIND*sw**3)
    f(268) = (2*CI*countertermnorm*eQED**6*gQCD*logEWs2loopMix1(1,2,nMW,1,1,nMReg,P,31))/(9._/**/REALKIND*sw**2)
    f(269) = (CI*countertermnorm*eQED**6*gQCD*logEWs2loopMix1(1,2,nMW,1,1,nMZ,P,31))/(2._/**/REALKIND*sw**2)
    f(270) = (CI*countertermnorm*eQED**6*gQCD*logEWs2loopMix1(1,2,nMZ,1,1,nMReg,P,31))/9._/**/REALKIND
    f(271) = (CI*countertermnorm*eQED**6*gQCD*logEWs2loopMix1(1,2,nMZ,1,1,nMW,P,31))/(2._/**/REALKIND*sw**2)
    f(272) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopMix1(1,2,nMZ,1,3,nMW,P,211))/sw**4
    f(273) = (CI*countertermnorm*cw*eQED**6*gQCD*logEWs2loopMix1(1,2,nMZ,1,3,nMW,P,211))/sw**3
    f(274) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopMix1(1,2,nMZ,1,4,nMW,P,211))/sw**4
    f(275) = (CI*countertermnorm*cw*eQED**6*gQCD*logEWs2loopMix1(1,2,nMZ,1,4,nMW,P,211))/sw**3
    f(276) = (2*CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopMix1(1,3,nMW,1,1,nMReg,P,31))/(9._/**/REALKIND*sw**4)
    f(277) = (2*CI*countertermnorm*cw*eQED**6*gQCD*logEWs2loopMix1(1,3,nMW,1,1,nMReg,P,31))/(9._/**/REALKIND*sw**3)
    f(278) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopMix1(1,3,nMW,1,1,nMZ,P,31))/(2._/**/REALKIND*sw**4)
    f(279) = (CI*countertermnorm*cw*eQED**6*gQCD*logEWs2loopMix1(1,3,nMW,1,1,nMZ,P,31))/(2._/**/REALKIND*sw**3)
    f(280) = (2*CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopMix1(1,3,nMW,1,2,nMReg,P,211))/(9._/**/REALKIND*sw**4)
    f(281) = (2*CI*countertermnorm*cw*eQED**6*gQCD*logEWs2loopMix1(1,3,nMW,1,2,nMReg,P,211))/(9._/**/REALKIND*sw**3)
    f(282) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopMix1(1,3,nMW,1,2,nMZ,P,211))/sw**4
    f(283) = (CI*countertermnorm*cw*eQED**6*gQCD*logEWs2loopMix1(1,3,nMW,1,2,nMZ,P,211))/sw**3
    f(284) = (2*CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopMix1(1,4,nMW,1,1,nMReg,P,31))/(9._/**/REALKIND*sw**4)
    f(285) = (2*CI*countertermnorm*cw*eQED**6*gQCD*logEWs2loopMix1(1,4,nMW,1,1,nMReg,P,31))/(9._/**/REALKIND*sw**3)
    f(286) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopMix1(1,4,nMW,1,1,nMZ,P,31))/(2._/**/REALKIND*sw**4)
    f(287) = (CI*countertermnorm*cw*eQED**6*gQCD*logEWs2loopMix1(1,4,nMW,1,1,nMZ,P,31))/(2._/**/REALKIND*sw**3)
    f(288) = (2*CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopMix1(1,4,nMW,1,2,nMReg,P,211))/(9._/**/REALKIND*sw**4)
    f(289) = (2*CI*countertermnorm*cw*eQED**6*gQCD*logEWs2loopMix1(1,4,nMW,1,2,nMReg,P,211))/(9._/**/REALKIND*sw**3)
    f(290) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopMix1(1,4,nMW,1,2,nMZ,P,211))/sw**4
    f(291) = (CI*countertermnorm*cw*eQED**6*gQCD*logEWs2loopMix1(1,4,nMW,1,2,nMZ,P,211))/sw**3
    f(292) = (CI*countertermnorm*eQED**6*gQCD*logEWs2loopMix1(2,1,nMReg,2,1,nMW,P,22))/(18._/**/REALKIND*sw**2)
    f(293) = (CI*countertermnorm*eQED**6*gQCD*logEWs2loopMix1(2,1,nMReg,2,1,nMZ,P,22))/9._/**/REALKIND
    f(294) = (CI*countertermnorm*eQED**6*gQCD*logEWs2loopMix1(2,1,nMReg,2,2,nMW,P,31))/(18._/**/REALKIND*sw**2)
    f(295) = (CI*countertermnorm*eQED**6*gQCD*logEWs2loopMix1(2,1,nMReg,2,2,nMZ,P,31))/9._/**/REALKIND
    f(296) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopMix1(2,1,nMReg,2,3,nMW,P,211))/(9._/**/REALKIND*sw**4)
    f(297) = (CI*countertermnorm*cw*eQED**6*gQCD*logEWs2loopMix1(2,1,nMReg,2,3,nMW,P,211))/(9._/**/REALKIND*sw**3)
    f(298) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopMix1(2,1,nMReg,2,4,nMW,P,211))/(9._/**/REALKIND*sw**4)
    f(299) = (CI*countertermnorm*cw*eQED**6*gQCD*logEWs2loopMix1(2,1,nMReg,2,4,nMW,P,211))/(9._/**/REALKIND*sw**3)
    f(300) = (2*CI*countertermnorm*eQED**6*gQCD*logEWs2loopMix1(2,1,nMW,2,1,nMReg,P,22))/(9._/**/REALKIND*sw**2)
    f(301) = (CI*countertermnorm*eQED**6*gQCD*logEWs2loopMix1(2,1,nMW,2,1,nMZ,P,22))/(2._/**/REALKIND*sw**2)
    f(302) = (2*CI*countertermnorm*eQED**6*gQCD*logEWs2loopMix1(2,1,nMW,2,2,nMReg,P,31))/(9._/**/REALKIND*sw**2)
    f(303) = (CI*countertermnorm*eQED**6*gQCD*logEWs2loopMix1(2,1,nMW,2,2,nMZ,P,31))/(2._/**/REALKIND*sw**2)
    f(304) = (CI*countertermnorm*eQED**6*gQCD*logEWs2loopMix1(2,1,nMZ,2,1,nMReg,P,22))/9._/**/REALKIND
    f(305) = (CI*countertermnorm*eQED**6*gQCD*logEWs2loopMix1(2,1,nMZ,2,1,nMW,P,22))/(2._/**/REALKIND*sw**2)
    f(306) = (CI*countertermnorm*eQED**6*gQCD*logEWs2loopMix1(2,1,nMZ,2,2,nMReg,P,31))/9._/**/REALKIND
    f(307) = (CI*countertermnorm*eQED**6*gQCD*logEWs2loopMix1(2,1,nMZ,2,2,nMW,P,31))/(2._/**/REALKIND*sw**2)
    f(308) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopMix1(2,1,nMZ,2,3,nMW,P,211))/sw**4
    f(309) = (CI*countertermnorm*cw*eQED**6*gQCD*logEWs2loopMix1(2,1,nMZ,2,3,nMW,P,211))/sw**3
    f(310) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopMix1(2,1,nMZ,2,4,nMW,P,211))/sw**4
    f(311) = (CI*countertermnorm*cw*eQED**6*gQCD*logEWs2loopMix1(2,1,nMZ,2,4,nMW,P,211))/sw**3
    f(312) = (2*CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopMix1(2,3,nMW,2,1,nMReg,P,211))/(9._/**/REALKIND*sw**4)
    f(313) = (2*CI*countertermnorm*cw*eQED**6*gQCD*logEWs2loopMix1(2,3,nMW,2,1,nMReg,P,211))/(9._/**/REALKIND*sw**3)
    f(314) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopMix1(2,3,nMW,2,1,nMZ,P,211))/sw**4
    f(315) = (CI*countertermnorm*cw*eQED**6*gQCD*logEWs2loopMix1(2,3,nMW,2,1,nMZ,P,211))/sw**3
    f(316) = (2*CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopMix1(2,3,nMW,2,2,nMReg,P,31))/(9._/**/REALKIND*sw**4)
    f(317) = (2*CI*countertermnorm*cw*eQED**6*gQCD*logEWs2loopMix1(2,3,nMW,2,2,nMReg,P,31))/(9._/**/REALKIND*sw**3)
    f(318) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopMix1(2,3,nMW,2,2,nMZ,P,31))/(2._/**/REALKIND*sw**4)
    f(319) = (CI*countertermnorm*cw*eQED**6*gQCD*logEWs2loopMix1(2,3,nMW,2,2,nMZ,P,31))/(2._/**/REALKIND*sw**3)
    f(320) = (2*CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopMix1(2,4,nMW,2,1,nMReg,P,211))/(9._/**/REALKIND*sw**4)
    f(321) = (2*CI*countertermnorm*cw*eQED**6*gQCD*logEWs2loopMix1(2,4,nMW,2,1,nMReg,P,211))/(9._/**/REALKIND*sw**3)
    f(322) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopMix1(2,4,nMW,2,1,nMZ,P,211))/sw**4
    f(323) = (CI*countertermnorm*cw*eQED**6*gQCD*logEWs2loopMix1(2,4,nMW,2,1,nMZ,P,211))/sw**3
    f(324) = (2*CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopMix1(2,4,nMW,2,2,nMReg,P,31))/(9._/**/REALKIND*sw**4)
    f(325) = (2*CI*countertermnorm*cw*eQED**6*gQCD*logEWs2loopMix1(2,4,nMW,2,2,nMReg,P,31))/(9._/**/REALKIND*sw**3)
    f(326) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopMix1(2,4,nMW,2,2,nMZ,P,31))/(2._/**/REALKIND*sw**4)
    f(327) = (CI*countertermnorm*cw*eQED**6*gQCD*logEWs2loopMix1(2,4,nMW,2,2,nMZ,P,31))/(2._/**/REALKIND*sw**3)
    f(328) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopMix1(3,1,nMW,3,1,nMReg,P,22))/(3._/**/REALKIND*sw**4)
    f(329) = (CI*countertermnorm*cw*eQED**6*gQCD*logEWs2loopMix1(3,1,nMW,3,1,nMReg,P,22))/(3._/**/REALKIND*sw**3)
    f(330) = (CI*countertermnorm*cw**3*eQED**6*gQCD*logEWs2loopMix1(3,1,nMW,3,1,nMZ,P,22))/(2._/**/REALKIND*sw**5)
    f(331) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopMix1(3,1,nMW,3,1,nMZ,P,22))/(2._/**/REALKIND*sw**4)
    f(332) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopMix1(3,1,nMW,3,2,nMReg,P,211))/(3._/**/REALKIND*sw**4)
    f(333) = (CI*countertermnorm*cw*eQED**6*gQCD*logEWs2loopMix1(3,1,nMW,3,2,nMReg,P,211))/(3._/**/REALKIND*sw**3)
    f(334) = (CI*countertermnorm*cw**3*eQED**6*gQCD*logEWs2loopMix1(3,1,nMW,3,2,nMZ,P,211))/sw**5
    f(335) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopMix1(3,1,nMW,3,2,nMZ,P,211))/sw**4
    f(336) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopMix1(3,1,nMW,3,3,nMReg,P,31))/(2._/**/REALKIND*sw**4)
    f(337) = (CI*countertermnorm*cw*eQED**6*gQCD*logEWs2loopMix1(3,1,nMW,3,3,nMReg,P,31))/(2._/**/REALKIND*sw**3)
    f(338) = (CI*countertermnorm*cw**4*eQED**6*gQCD*logEWs2loopMix1(3,1,nMW,3,3,nMZ,P,31))/(2._/**/REALKIND*sw**6)
    f(339) = (CI*countertermnorm*cw**3*eQED**6*gQCD*logEWs2loopMix1(3,1,nMW,3,3,nMZ,P,31))/(2._/**/REALKIND*sw**5)
    f(340) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopMix1(3,2,nMW,3,1,nMReg,P,211))/(3._/**/REALKIND*sw**4)
    f(341) = (CI*countertermnorm*cw*eQED**6*gQCD*logEWs2loopMix1(3,2,nMW,3,1,nMReg,P,211))/(3._/**/REALKIND*sw**3)
    f(342) = (CI*countertermnorm*cw**3*eQED**6*gQCD*logEWs2loopMix1(3,2,nMW,3,1,nMZ,P,211))/sw**5
    f(343) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopMix1(3,2,nMW,3,1,nMZ,P,211))/sw**4
    f(344) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopMix1(3,2,nMW,3,2,nMReg,P,22))/(3._/**/REALKIND*sw**4)
    f(345) = (CI*countertermnorm*cw*eQED**6*gQCD*logEWs2loopMix1(3,2,nMW,3,2,nMReg,P,22))/(3._/**/REALKIND*sw**3)
    f(346) = (CI*countertermnorm*cw**3*eQED**6*gQCD*logEWs2loopMix1(3,2,nMW,3,2,nMZ,P,22))/(2._/**/REALKIND*sw**5)
    f(347) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopMix1(3,2,nMW,3,2,nMZ,P,22))/(2._/**/REALKIND*sw**4)
    f(348) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopMix1(3,2,nMW,3,3,nMReg,P,31))/(2._/**/REALKIND*sw**4)
    f(349) = (CI*countertermnorm*cw*eQED**6*gQCD*logEWs2loopMix1(3,2,nMW,3,3,nMReg,P,31))/(2._/**/REALKIND*sw**3)
    f(350) = (CI*countertermnorm*cw**4*eQED**6*gQCD*logEWs2loopMix1(3,2,nMW,3,3,nMZ,P,31))/(2._/**/REALKIND*sw**6)
    f(351) = (CI*countertermnorm*cw**3*eQED**6*gQCD*logEWs2loopMix1(3,2,nMW,3,3,nMZ,P,31))/(2._/**/REALKIND*sw**5)
    f(352) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopMix1(3,4,nMW,3,1,nMReg,P,211))/(3._/**/REALKIND*sw**4)
    f(353) = (2*CI*countertermnorm*cw**3*eQED**6*gQCD*logEWs2loopMix1(3,4,nMW,3,1,nMReg,P,211))/(3._/**/REALKIND*sw**3)
    f(354) = (2*CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopMix1(3,4,nMW,3,1,nMReg,P,211))/(9._/**/REALKIND*sw**2)
    f(355) = (CI*countertermnorm*cw**3*eQED**6*gQCD*logEWs2loopMix1(3,4,nMW,3,1,nMZ,P,211))/sw**5
    f(356) = (2*CI*countertermnorm*cw**4*eQED**6*gQCD*logEWs2loopMix1(3,4,nMW,3,1,nMZ,P,211))/sw**4
    f(357) = (2*CI*countertermnorm*cw**3*eQED**6*gQCD*logEWs2loopMix1(3,4,nMW,3,1,nMZ,P,211))/(3._/**/REALKIND*sw**3)
    f(358) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopMix1(3,4,nMW,3,2,nMReg,P,211))/(3._/**/REALKIND*sw**4)
    f(359) = (2*CI*countertermnorm*cw**3*eQED**6*gQCD*logEWs2loopMix1(3,4,nMW,3,2,nMReg,P,211))/(3._/**/REALKIND*sw**3)
    f(360) = (2*CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopMix1(3,4,nMW,3,2,nMReg,P,211))/(9._/**/REALKIND*sw**2)
    f(361) = (CI*countertermnorm*cw**3*eQED**6*gQCD*logEWs2loopMix1(3,4,nMW,3,2,nMZ,P,211))/sw**5
    f(362) = (2*CI*countertermnorm*cw**4*eQED**6*gQCD*logEWs2loopMix1(3,4,nMW,3,2,nMZ,P,211))/sw**4
    f(363) = (2*CI*countertermnorm*cw**3*eQED**6*gQCD*logEWs2loopMix1(3,4,nMW,3,2,nMZ,P,211))/(3._/**/REALKIND*sw**3)
    f(364) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopMix1(3,4,nMW,3,3,nMReg,P,31))/(2._/**/REALKIND*sw**4)
    f(365) = (CI*countertermnorm*cw**3*eQED**6*gQCD*logEWs2loopMix1(3,4,nMW,3,3,nMReg,P,31))/sw**3
    f(366) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopMix1(3,4,nMW,3,3,nMReg,P,31))/(3._/**/REALKIND*sw**2)
    f(367) = (CI*countertermnorm*cw**4*eQED**6*gQCD*logEWs2loopMix1(3,4,nMW,3,3,nMZ,P,31))/(2._/**/REALKIND*sw**6)
    f(368) = (CI*countertermnorm*cw**5*eQED**6*gQCD*logEWs2loopMix1(3,4,nMW,3,3,nMZ,P,31))/sw**5
    f(369) = (CI*countertermnorm*cw**4*eQED**6*gQCD*logEWs2loopMix1(3,4,nMW,3,3,nMZ,P,31))/(3._/**/REALKIND*sw**4)
    f(370) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopMix1(4,1,nMW,4,1,nMReg,P,22))/(3._/**/REALKIND*sw**4)
    f(371) = (CI*countertermnorm*cw*eQED**6*gQCD*logEWs2loopMix1(4,1,nMW,4,1,nMReg,P,22))/(3._/**/REALKIND*sw**3)
    f(372) = (CI*countertermnorm*cw**3*eQED**6*gQCD*logEWs2loopMix1(4,1,nMW,4,1,nMZ,P,22))/(2._/**/REALKIND*sw**5)
    f(373) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopMix1(4,1,nMW,4,1,nMZ,P,22))/(2._/**/REALKIND*sw**4)
    f(374) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopMix1(4,1,nMW,4,2,nMReg,P,211))/(3._/**/REALKIND*sw**4)
    f(375) = (CI*countertermnorm*cw*eQED**6*gQCD*logEWs2loopMix1(4,1,nMW,4,2,nMReg,P,211))/(3._/**/REALKIND*sw**3)
    f(376) = (CI*countertermnorm*cw**3*eQED**6*gQCD*logEWs2loopMix1(4,1,nMW,4,2,nMZ,P,211))/sw**5
    f(377) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopMix1(4,1,nMW,4,2,nMZ,P,211))/sw**4
    f(378) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopMix1(4,1,nMW,4,4,nMReg,P,31))/(2._/**/REALKIND*sw**4)
    f(379) = (CI*countertermnorm*cw*eQED**6*gQCD*logEWs2loopMix1(4,1,nMW,4,4,nMReg,P,31))/(2._/**/REALKIND*sw**3)
    f(380) = (CI*countertermnorm*cw**4*eQED**6*gQCD*logEWs2loopMix1(4,1,nMW,4,4,nMZ,P,31))/(2._/**/REALKIND*sw**6)
    f(381) = (CI*countertermnorm*cw**3*eQED**6*gQCD*logEWs2loopMix1(4,1,nMW,4,4,nMZ,P,31))/(2._/**/REALKIND*sw**5)
    f(382) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopMix1(4,2,nMW,4,1,nMReg,P,211))/(3._/**/REALKIND*sw**4)
    f(383) = (CI*countertermnorm*cw*eQED**6*gQCD*logEWs2loopMix1(4,2,nMW,4,1,nMReg,P,211))/(3._/**/REALKIND*sw**3)
    f(384) = (CI*countertermnorm*cw**3*eQED**6*gQCD*logEWs2loopMix1(4,2,nMW,4,1,nMZ,P,211))/sw**5
    f(385) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopMix1(4,2,nMW,4,1,nMZ,P,211))/sw**4
    f(386) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopMix1(4,2,nMW,4,2,nMReg,P,22))/(3._/**/REALKIND*sw**4)
    f(387) = (CI*countertermnorm*cw*eQED**6*gQCD*logEWs2loopMix1(4,2,nMW,4,2,nMReg,P,22))/(3._/**/REALKIND*sw**3)
    f(388) = (CI*countertermnorm*cw**3*eQED**6*gQCD*logEWs2loopMix1(4,2,nMW,4,2,nMZ,P,22))/(2._/**/REALKIND*sw**5)
    f(389) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopMix1(4,2,nMW,4,2,nMZ,P,22))/(2._/**/REALKIND*sw**4)
    f(390) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopMix1(4,2,nMW,4,4,nMReg,P,31))/(2._/**/REALKIND*sw**4)
    f(391) = (CI*countertermnorm*cw*eQED**6*gQCD*logEWs2loopMix1(4,2,nMW,4,4,nMReg,P,31))/(2._/**/REALKIND*sw**3)
    f(392) = (CI*countertermnorm*cw**4*eQED**6*gQCD*logEWs2loopMix1(4,2,nMW,4,4,nMZ,P,31))/(2._/**/REALKIND*sw**6)
    f(393) = (CI*countertermnorm*cw**3*eQED**6*gQCD*logEWs2loopMix1(4,2,nMW,4,4,nMZ,P,31))/(2._/**/REALKIND*sw**5)
    f(394) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopMix1(4,3,nMW,2,1,nMReg,P,1111))/(18._/**/REALKIND*sw**4)
    f(395) = (CI*countertermnorm*cw**3*eQED**6*gQCD*logEWs2loopMix1(4,3,nMW,2,1,nMReg,P,1111))/(9._/**/REALKIND*sw**3)
    f(396) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopMix1(4,3,nMW,2,1,nMReg,P,1111))/(27._/**/REALKIND*sw**2)
    f(397) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopMix1(4,3,nMW,2,1,nMZ,P,1111))/(2._/**/REALKIND*sw**4)
    f(398) = (CI*countertermnorm*cw**3*eQED**6*gQCD*logEWs2loopMix1(4,3,nMW,2,1,nMZ,P,1111))/sw**3
    f(399) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopMix1(4,3,nMW,2,1,nMZ,P,1111))/(3._/**/REALKIND*sw**2)
    f(400) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopMix1(4,3,nMW,4,1,nMReg,P,211))/(3._/**/REALKIND*sw**4)
    f(401) = (2*CI*countertermnorm*cw**3*eQED**6*gQCD*logEWs2loopMix1(4,3,nMW,4,1,nMReg,P,211))/(3._/**/REALKIND*sw**3)
    f(402) = (2*CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopMix1(4,3,nMW,4,1,nMReg,P,211))/(9._/**/REALKIND*sw**2)
    f(403) = (CI*countertermnorm*cw**3*eQED**6*gQCD*logEWs2loopMix1(4,3,nMW,4,1,nMZ,P,211))/sw**5
    f(404) = (2*CI*countertermnorm*cw**4*eQED**6*gQCD*logEWs2loopMix1(4,3,nMW,4,1,nMZ,P,211))/sw**4
    f(405) = (2*CI*countertermnorm*cw**3*eQED**6*gQCD*logEWs2loopMix1(4,3,nMW,4,1,nMZ,P,211))/(3._/**/REALKIND*sw**3)
    f(406) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopMix1(4,3,nMW,4,2,nMReg,P,211))/(3._/**/REALKIND*sw**4)
    f(407) = (2*CI*countertermnorm*cw**3*eQED**6*gQCD*logEWs2loopMix1(4,3,nMW,4,2,nMReg,P,211))/(3._/**/REALKIND*sw**3)
    f(408) = (2*CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopMix1(4,3,nMW,4,2,nMReg,P,211))/(9._/**/REALKIND*sw**2)
    f(409) = (CI*countertermnorm*cw**3*eQED**6*gQCD*logEWs2loopMix1(4,3,nMW,4,2,nMZ,P,211))/sw**5
    f(410) = (2*CI*countertermnorm*cw**4*eQED**6*gQCD*logEWs2loopMix1(4,3,nMW,4,2,nMZ,P,211))/sw**4
    f(411) = (2*CI*countertermnorm*cw**3*eQED**6*gQCD*logEWs2loopMix1(4,3,nMW,4,2,nMZ,P,211))/(3._/**/REALKIND*sw**3)
    f(412) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopMix1(4,3,nMW,4,3,nMReg,P,22))/(2._/**/REALKIND*sw**4)
    f(413) = (CI*countertermnorm*cw**3*eQED**6*gQCD*logEWs2loopMix1(4,3,nMW,4,3,nMReg,P,22))/sw**3
    f(414) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopMix1(4,3,nMW,4,3,nMReg,P,22))/(3._/**/REALKIND*sw**2)
    f(415) = (CI*countertermnorm*cw**4*eQED**6*gQCD*logEWs2loopMix1(4,3,nMW,4,3,nMZ,P,22))/(2._/**/REALKIND*sw**6)
    f(416) = (CI*countertermnorm*cw**5*eQED**6*gQCD*logEWs2loopMix1(4,3,nMW,4,3,nMZ,P,22))/sw**5
    f(417) = (CI*countertermnorm*cw**4*eQED**6*gQCD*logEWs2loopMix1(4,3,nMW,4,3,nMZ,P,22))/(3._/**/REALKIND*sw**4)
    f(418) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopMix1(4,3,nMW,4,4,nMReg,P,31))/(2._/**/REALKIND*sw**4)
    f(419) = (CI*countertermnorm*cw**3*eQED**6*gQCD*logEWs2loopMix1(4,3,nMW,4,4,nMReg,P,31))/sw**3
    f(420) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopMix1(4,3,nMW,4,4,nMReg,P,31))/(3._/**/REALKIND*sw**2)
    f(421) = (CI*countertermnorm*cw**4*eQED**6*gQCD*logEWs2loopMix1(4,3,nMW,4,4,nMZ,P,31))/(2._/**/REALKIND*sw**6)
    f(422) = (CI*countertermnorm*cw**5*eQED**6*gQCD*logEWs2loopMix1(4,3,nMW,4,4,nMZ,P,31))/sw**5
    f(423) = (CI*countertermnorm*cw**4*eQED**6*gQCD*logEWs2loopMix1(4,3,nMW,4,4,nMZ,P,31))/(3._/**/REALKIND*sw**4)
    f(424) = (CI*countertermnorm*eQED**6*gQCD*logEWs2loopMix2(1,1,2,1,nMReg,nMW,P,31))/(9._/**/REALKIND*sw**2)
    f(425) = (CI*countertermnorm*eQED**6*gQCD*logEWs2loopMix2(1,1,2,1,nMReg,nMZ,P,31))/9._/**/REALKIND
    f(426) = (CI*countertermnorm*eQED**6*gQCD*logEWs2loopMix2(1,1,2,1,nMW,nMReg,P,31))/(9._/**/REALKIND*sw**2)
    f(427) = (CI*countertermnorm*eQED**6*gQCD*logEWs2loopMix2(1,1,2,1,nMW,nMZ,P,31))/(2._/**/REALKIND*sw**2)
    f(428) = (CI*countertermnorm*eQED**6*gQCD*logEWs2loopMix2(1,1,2,1,nMZ,nMReg,P,31))/9._/**/REALKIND
    f(429) = (CI*countertermnorm*eQED**6*gQCD*logEWs2loopMix2(1,1,2,1,nMZ,nMW,P,31))/(2._/**/REALKIND*sw**2)
    f(430) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopMix2(1,1,3,1,nMReg,nMW,P,31))/(9._/**/REALKIND*sw**4)
    f(431) = (CI*countertermnorm*cw*eQED**6*gQCD*logEWs2loopMix2(1,1,3,1,nMReg,nMW,P,31))/(9._/**/REALKIND*sw**3)
    f(432) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopMix2(1,1,3,1,nMZ,nMW,P,31))/(2._/**/REALKIND*sw**4)
    f(433) = (CI*countertermnorm*cw*eQED**6*gQCD*logEWs2loopMix2(1,1,3,1,nMZ,nMW,P,31))/(2._/**/REALKIND*sw**3)
    f(434) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopMix2(1,1,4,1,nMReg,nMW,P,31))/(9._/**/REALKIND*sw**4)
    f(435) = (CI*countertermnorm*cw*eQED**6*gQCD*logEWs2loopMix2(1,1,4,1,nMReg,nMW,P,31))/(9._/**/REALKIND*sw**3)
    f(436) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopMix2(1,1,4,1,nMZ,nMW,P,31))/(2._/**/REALKIND*sw**4)
    f(437) = (CI*countertermnorm*cw*eQED**6*gQCD*logEWs2loopMix2(1,1,4,1,nMZ,nMW,P,31))/(2._/**/REALKIND*sw**3)
    f(438) = (CI*countertermnorm*eQED**6*gQCD*logEWs2loopMix2(2,1,1,2,nMReg,nMW,P,22))/(9._/**/REALKIND*sw**2)
    f(439) = (CI*countertermnorm*eQED**6*gQCD*logEWs2loopMix2(2,1,1,2,nMReg,nMZ,P,22))/9._/**/REALKIND
    f(440) = (CI*countertermnorm*eQED**6*gQCD*logEWs2loopMix2(2,1,1,2,nMW,nMReg,P,22))/(9._/**/REALKIND*sw**2)
    f(441) = (CI*countertermnorm*eQED**6*gQCD*logEWs2loopMix2(2,1,1,2,nMW,nMZ,P,22))/(2._/**/REALKIND*sw**2)
    f(442) = (CI*countertermnorm*eQED**6*gQCD*logEWs2loopMix2(2,1,1,2,nMZ,nMReg,P,22))/9._/**/REALKIND
    f(443) = (CI*countertermnorm*eQED**6*gQCD*logEWs2loopMix2(2,1,1,2,nMZ,nMW,P,22))/(2._/**/REALKIND*sw**2)
    f(444) = (CI*countertermnorm*eQED**6*gQCD*logEWs2loopMix2(2,2,1,2,nMReg,nMW,P,31))/(9._/**/REALKIND*sw**2)
    f(445) = (CI*countertermnorm*eQED**6*gQCD*logEWs2loopMix2(2,2,1,2,nMReg,nMZ,P,31))/9._/**/REALKIND
    f(446) = (CI*countertermnorm*eQED**6*gQCD*logEWs2loopMix2(2,2,1,2,nMW,nMReg,P,31))/(9._/**/REALKIND*sw**2)
    f(447) = (CI*countertermnorm*eQED**6*gQCD*logEWs2loopMix2(2,2,1,2,nMW,nMZ,P,31))/(2._/**/REALKIND*sw**2)
    f(448) = (CI*countertermnorm*eQED**6*gQCD*logEWs2loopMix2(2,2,1,2,nMZ,nMReg,P,31))/9._/**/REALKIND
    f(449) = (CI*countertermnorm*eQED**6*gQCD*logEWs2loopMix2(2,2,1,2,nMZ,nMW,P,31))/(2._/**/REALKIND*sw**2)
    f(450) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopMix2(2,2,3,2,nMReg,nMW,P,31))/(9._/**/REALKIND*sw**4)
    f(451) = (CI*countertermnorm*cw*eQED**6*gQCD*logEWs2loopMix2(2,2,3,2,nMReg,nMW,P,31))/(9._/**/REALKIND*sw**3)
    f(452) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopMix2(2,2,3,2,nMZ,nMW,P,31))/(2._/**/REALKIND*sw**4)
    f(453) = (CI*countertermnorm*cw*eQED**6*gQCD*logEWs2loopMix2(2,2,3,2,nMZ,nMW,P,31))/(2._/**/REALKIND*sw**3)
    f(454) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopMix2(2,2,4,2,nMReg,nMW,P,31))/(9._/**/REALKIND*sw**4)
    f(455) = (CI*countertermnorm*cw*eQED**6*gQCD*logEWs2loopMix2(2,2,4,2,nMReg,nMW,P,31))/(9._/**/REALKIND*sw**3)
    f(456) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopMix2(2,2,4,2,nMZ,nMW,P,31))/(2._/**/REALKIND*sw**4)
    f(457) = (CI*countertermnorm*cw*eQED**6*gQCD*logEWs2loopMix2(2,2,4,2,nMZ,nMW,P,31))/(2._/**/REALKIND*sw**3)
    f(458) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopMix2(3,1,1,3,nMW,nMReg,P,22))/(6._/**/REALKIND*sw**4)
    f(459) = (CI*countertermnorm*cw*eQED**6*gQCD*logEWs2loopMix2(3,1,1,3,nMW,nMReg,P,22))/(6._/**/REALKIND*sw**3)
    f(460) = (CI*countertermnorm*cw**3*eQED**6*gQCD*logEWs2loopMix2(3,1,1,3,nMW,nMZ,P,22))/(2._/**/REALKIND*sw**5)
    f(461) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopMix2(3,1,1,3,nMW,nMZ,P,22))/(2._/**/REALKIND*sw**4)
    f(462) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopMix2(3,2,2,3,nMW,nMReg,P,22))/(6._/**/REALKIND*sw**4)
    f(463) = (CI*countertermnorm*cw*eQED**6*gQCD*logEWs2loopMix2(3,2,2,3,nMW,nMReg,P,22))/(6._/**/REALKIND*sw**3)
    f(464) = (CI*countertermnorm*cw**3*eQED**6*gQCD*logEWs2loopMix2(3,2,2,3,nMW,nMZ,P,22))/(2._/**/REALKIND*sw**5)
    f(465) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopMix2(3,2,2,3,nMW,nMZ,P,22))/(2._/**/REALKIND*sw**4)
    f(466) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopMix2(3,3,1,3,nMW,nMReg,P,31))/(3._/**/REALKIND*sw**2)
    f(467) = (CI*countertermnorm*cw*eQED**6*gQCD*logEWs2loopMix2(3,3,1,3,nMW,nMReg,P,31))/(9._/**/REALKIND*sw)
    f(468) = (CI*countertermnorm*cw**3*eQED**6*gQCD*logEWs2loopMix2(3,3,1,3,nMW,nMZ,P,31))/sw**3
    f(469) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopMix2(3,3,1,3,nMW,nMZ,P,31))/(3._/**/REALKIND*sw**2)
    f(470) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopMix2(3,3,2,3,nMW,nMReg,P,31))/(3._/**/REALKIND*sw**2)
    f(471) = (CI*countertermnorm*cw*eQED**6*gQCD*logEWs2loopMix2(3,3,2,3,nMW,nMReg,P,31))/(9._/**/REALKIND*sw)
    f(472) = (CI*countertermnorm*cw**3*eQED**6*gQCD*logEWs2loopMix2(3,3,2,3,nMW,nMZ,P,31))/sw**3
    f(473) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopMix2(3,3,2,3,nMW,nMZ,P,31))/(3._/**/REALKIND*sw**2)
    f(474) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopMix2(4,1,1,4,nMW,nMReg,P,22))/(6._/**/REALKIND*sw**4)
    f(475) = (CI*countertermnorm*cw*eQED**6*gQCD*logEWs2loopMix2(4,1,1,4,nMW,nMReg,P,22))/(6._/**/REALKIND*sw**3)
    f(476) = (CI*countertermnorm*cw**3*eQED**6*gQCD*logEWs2loopMix2(4,1,1,4,nMW,nMZ,P,22))/(2._/**/REALKIND*sw**5)
    f(477) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopMix2(4,1,1,4,nMW,nMZ,P,22))/(2._/**/REALKIND*sw**4)
    f(478) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopMix2(4,2,2,4,nMW,nMReg,P,22))/(6._/**/REALKIND*sw**4)
    f(479) = (CI*countertermnorm*cw*eQED**6*gQCD*logEWs2loopMix2(4,2,2,4,nMW,nMReg,P,22))/(6._/**/REALKIND*sw**3)
    f(480) = (CI*countertermnorm*cw**3*eQED**6*gQCD*logEWs2loopMix2(4,2,2,4,nMW,nMZ,P,22))/(2._/**/REALKIND*sw**5)
    f(481) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopMix2(4,2,2,4,nMW,nMZ,P,22))/(2._/**/REALKIND*sw**4)
    f(482) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopMix2(4,4,1,4,nMW,nMReg,P,31))/(3._/**/REALKIND*sw**2)
    f(483) = (CI*countertermnorm*cw*eQED**6*gQCD*logEWs2loopMix2(4,4,1,4,nMW,nMReg,P,31))/(9._/**/REALKIND*sw)
    f(484) = (CI*countertermnorm*cw**3*eQED**6*gQCD*logEWs2loopMix2(4,4,1,4,nMW,nMZ,P,31))/sw**3
    f(485) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopMix2(4,4,1,4,nMW,nMZ,P,31))/(3._/**/REALKIND*sw**2)
    f(486) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopMix2(4,4,2,4,nMW,nMReg,P,31))/(3._/**/REALKIND*sw**2)
    f(487) = (CI*countertermnorm*cw*eQED**6*gQCD*logEWs2loopMix2(4,4,2,4,nMW,nMReg,P,31))/(9._/**/REALKIND*sw)
    f(488) = (CI*countertermnorm*cw**3*eQED**6*gQCD*logEWs2loopMix2(4,4,2,4,nMW,nMZ,P,31))/sw**3
    f(489) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopMix2(4,4,2,4,nMW,nMZ,P,31))/(3._/**/REALKIND*sw**2)
    f(490) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopNP(3,1,0,0,nMW,nMW,P,22))/(2._/**/REALKIND*sw**4)
    f(491) = (CI*countertermnorm*cw*eQED**6*gQCD*logEWs2loopNP(3,1,0,0,nMW,nMW,P,22))/(6._/**/REALKIND*sw**3)
    f(492) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopNP(3,2,0,0,nMW,nMW,P,22))/(2._/**/REALKIND*sw**4)
    f(493) = (CI*countertermnorm*cw*eQED**6*gQCD*logEWs2loopNP(3,2,0,0,nMW,nMW,P,22))/(6._/**/REALKIND*sw**3)
    f(494) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopNP(4,1,0,0,nMW,nMW,P,22))/(2._/**/REALKIND*sw**4)
    f(495) = (CI*countertermnorm*cw*eQED**6*gQCD*logEWs2loopNP(4,1,0,0,nMW,nMW,P,22))/(6._/**/REALKIND*sw**3)
    f(496) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopNP(4,2,0,0,nMW,nMW,P,22))/(2._/**/REALKIND*sw**4)
    f(497) = (CI*countertermnorm*cw*eQED**6*gQCD*logEWs2loopNP(4,2,0,0,nMW,nMW,P,22))/(6._/**/REALKIND*sw**3)
    f(498) = (CI*countertermnorm*cw**4*eQED**6*gQCD*logEWs2loopNP(4,3,0,0,nMW,nMW,P,22))/sw**4
    f(499) = (CI*countertermnorm*cw**3*eQED**6*gQCD*logEWs2loopNP(4,3,0,0,nMW,nMW,P,22))/(3._/**/REALKIND*sw**3)
    f(500) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopNP(4,3,0,0,nMW,nMW,P,22))/(9._/**/REALKIND*sw**2)
    f(501) = (CI*countertermnorm*ct2L*eQED**6*gQCD*logEWs2loopPR(2,nMReg,1,nMReg,P,11))/9._/**/REALKIND
    f(502) = (CI*countertermnorm*ct2L*eQED**6*gQCD*logEWs2loopPR(2,nMW,1,nMW,P,11))/(2._/**/REALKIND*sw**2)
    f(503) = (CI*countertermnorm*ct2L*eQED**6*gQCD*logEWs2loopPR(2,nMZ,1,nMReg,P,11))/3._/**/REALKIND
    f(504) = CI*countertermnorm*ct2L*eQED**6*gQCD*logEWs2loopPR(2,nMZ,1,nMZ,P,11)
    f(505) = (CI*countertermnorm*ct2L*cw**2*eQED**6*gQCD*logEWs2loopPR(3,nMW,1,nMW,P,11))/(2._/**/REALKIND*sw**4)
    f(506) = (CI*countertermnorm*ct2L*cw*eQED**6*gQCD*logEWs2loopPR(3,nMW,1,nMW,P,11))/(2._/**/REALKIND*sw**3)
    f(507) = (CI*countertermnorm*ct2L*cw**2*eQED**6*gQCD*logEWs2loopPR(3,nMW,2,nMW,P,11))/(2._/**/REALKIND*sw**4)
    f(508) = (CI*countertermnorm*ct2L*cw*eQED**6*gQCD*logEWs2loopPR(3,nMW,2,nMW,P,11))/(2._/**/REALKIND*sw**3)
    f(509) = (CI*countertermnorm*ct2L*cw**2*eQED**6*gQCD*logEWs2loopPR(4,nMW,1,nMW,P,11))/(2._/**/REALKIND*sw**4)
    f(510) = (CI*countertermnorm*ct2L*cw*eQED**6*gQCD*logEWs2loopPR(4,nMW,1,nMW,P,11))/(2._/**/REALKIND*sw**3)
    f(511) = (CI*countertermnorm*ct2L*cw**2*eQED**6*gQCD*logEWs2loopPR(4,nMW,2,nMW,P,11))/(2._/**/REALKIND*sw**4)
    f(512) = (CI*countertermnorm*ct2L*cw*eQED**6*gQCD*logEWs2loopPR(4,nMW,2,nMW,P,11))/(2._/**/REALKIND*sw**3)
    f(513) = (CI*countertermnorm*ct2L*cw**2*eQED**6*gQCD*logEWs2loopPR(4,nMW,3,nMW,P,11))/(2._/**/REALKIND*sw**4)
    f(514) = (CI*countertermnorm*ct2L*cw**3*eQED**6*gQCD*logEWs2loopPR(4,nMW,3,nMW,P,11))/sw**3
    f(515) = (CI*countertermnorm*ct2L*cw**2*eQED**6*gQCD*logEWs2loopPR(4,nMW,3,nMW,P,11))/(3._/**/REALKIND*sw**2)
    f(516) = (CI*countertermnorm*ct2L*eQED**6*gQCD*LogEWs2loopPR(2,nMReg,1,nMZ,P,11))/3._/**/REALKIND
    f(517) = (CI*countertermnorm*eQED**6*gQCD*logEWs2loopWFR(1,1,nMReg,1,2,nMReg,P,31,0,0))/81._/**/REALKIND
    f(518) = (CI*countertermnorm*eQED**6*gQCD*logEWs2loopWFR(1,1,nMReg,1,2,nMW,P,31,0,0))/(18._/**/REALKIND*sw**2)
    f(519) = (CI*countertermnorm*eQED**6*gQCD*logEWs2loopWFR(1,1,nMReg,1,2,nMZ,P,31,0,0))/9._/**/REALKIND
    f(520) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopWFR(1,1,nMReg,1,3,nMW,P,31,0,0))/(18._/**/REALKIND*sw**4)
    f(521) = (CI*countertermnorm*cw*eQED**6*gQCD*logEWs2loopWFR(1,1,nMReg,1,3,nMW,P,31,0,0))/(18._/**/REALKIND*sw**3)
    f(522) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopWFR(1,1,nMReg,1,4,nMW,P,31,0,0))/(18._/**/REALKIND*sw**4)
    f(523) = (CI*countertermnorm*cw*eQED**6*gQCD*logEWs2loopWFR(1,1,nMReg,1,4,nMW,P,31,0,0))/(18._/**/REALKIND*sw**3)
    f(524) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopWFR(1,1,nMReg,2,3,nMW,P,211,0,0))/(9._/**/REALKIND*sw**4)
    f(525) = (CI*countertermnorm*cw*eQED**6*gQCD*logEWs2loopWFR(1,1,nMReg,2,3,nMW,P,211,0,0))/(9._/**/REALKIND*sw**3)
    f(526) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopWFR(1,1,nMReg,2,4,nMW,P,211,0,0))/(9._/**/REALKIND*sw**4)
    f(527) = (CI*countertermnorm*cw*eQED**6*gQCD*logEWs2loopWFR(1,1,nMReg,2,4,nMW,P,211,0,0))/(9._/**/REALKIND*sw**3)
    f(528) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopWFR(1,1,nMReg,3,4,nMW,P,211,0,0))/(9._/**/REALKIND*sw**4)
    f(529) = (2*CI*countertermnorm*cw**3*eQED**6*gQCD*logEWs2loopWFR(1,1,nMReg,3,4,nMW,P,211,0,0))/(9._/**/REALKIND*sw**3)
    f(530) = (2*CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopWFR(1,1,nMReg,3,4,nMW,P,211,0,0))/(27._/**/REALKIND*sw**2)
    f(531) = (CI*countertermnorm*eQED**6*gQCD*logEWs2loopWFR(1,1,nMW,1,2,nMReg,P,31,0,0))/(18._/**/REALKIND*sw**2)
    f(532) = (CI*countertermnorm*eQED**6*gQCD*logEWs2loopWFR(1,1,nMW,1,2,nMW,P,31,0,0))/(4._/**/REALKIND*sw**4)
    f(533) = (CI*countertermnorm*eQED**6*gQCD*logEWs2loopWFR(1,1,nMW,1,2,nMZ,P,31,0,0))/(2._/**/REALKIND*sw**2)
    f(534) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopWFR(1,1,nMW,1,3,nMW,P,31,0,0))/(4._/**/REALKIND*sw**6)
    f(535) = (CI*countertermnorm*cw*eQED**6*gQCD*logEWs2loopWFR(1,1,nMW,1,3,nMW,P,31,0,0))/(4._/**/REALKIND*sw**5)
    f(536) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopWFR(1,1,nMW,1,4,nMW,P,31,0,0))/(4._/**/REALKIND*sw**6)
    f(537) = (CI*countertermnorm*cw*eQED**6*gQCD*logEWs2loopWFR(1,1,nMW,1,4,nMW,P,31,0,0))/(4._/**/REALKIND*sw**5)
    f(538) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopWFR(1,1,nMW,2,3,nMW,P,211,0,0))/(2._/**/REALKIND*sw**6)
    f(539) = (CI*countertermnorm*cw*eQED**6*gQCD*logEWs2loopWFR(1,1,nMW,2,3,nMW,P,211,0,0))/(2._/**/REALKIND*sw**5)
    f(540) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopWFR(1,1,nMW,2,4,nMW,P,211,0,0))/(2._/**/REALKIND*sw**6)
    f(541) = (CI*countertermnorm*cw*eQED**6*gQCD*logEWs2loopWFR(1,1,nMW,2,4,nMW,P,211,0,0))/(2._/**/REALKIND*sw**5)
    f(542) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopWFR(1,1,nMW,3,4,nMW,P,211,0,0))/(2._/**/REALKIND*sw**6)
    f(543) = (CI*countertermnorm*cw**3*eQED**6*gQCD*logEWs2loopWFR(1,1,nMW,3,4,nMW,P,211,0,0))/sw**5
    f(544) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopWFR(1,1,nMW,3,4,nMW,P,211,0,0))/(3._/**/REALKIND*sw**4)
    f(545) = (CI*countertermnorm*eQED**6*gQCD*logEWs2loopWFR(1,1,nMZ,1,2,nMReg,P,31,0,0))/9._/**/REALKIND
    f(546) = (CI*countertermnorm*eQED**6*gQCD*logEWs2loopWFR(1,1,nMZ,1,2,nMW,P,31,0,0))/(2._/**/REALKIND*sw**2)
    f(547) = CI*countertermnorm*eQED**6*gQCD*logEWs2loopWFR(1,1,nMZ,1,2,nMZ,P,31,0,0)
    f(548) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopWFR(1,1,nMZ,1,3,nMW,P,31,0,0))/(2._/**/REALKIND*sw**4)
    f(549) = (CI*countertermnorm*cw*eQED**6*gQCD*logEWs2loopWFR(1,1,nMZ,1,3,nMW,P,31,0,0))/(2._/**/REALKIND*sw**3)
    f(550) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopWFR(1,1,nMZ,1,4,nMW,P,31,0,0))/(2._/**/REALKIND*sw**4)
    f(551) = (CI*countertermnorm*cw*eQED**6*gQCD*logEWs2loopWFR(1,1,nMZ,1,4,nMW,P,31,0,0))/(2._/**/REALKIND*sw**3)
    f(552) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopWFR(1,1,nMZ,2,3,nMW,P,211,0,0))/sw**4
    f(553) = (CI*countertermnorm*cw*eQED**6*gQCD*logEWs2loopWFR(1,1,nMZ,2,3,nMW,P,211,0,0))/sw**3
    f(554) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopWFR(1,1,nMZ,2,4,nMW,P,211,0,0))/sw**4
    f(555) = (CI*countertermnorm*cw*eQED**6*gQCD*logEWs2loopWFR(1,1,nMZ,2,4,nMW,P,211,0,0))/sw**3
    f(556) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopWFR(1,1,nMZ,3,4,nMW,P,211,0,0))/sw**4
    f(557) = (2*CI*countertermnorm*cw**3*eQED**6*gQCD*logEWs2loopWFR(1,1,nMZ,3,4,nMW,P,211,0,0))/sw**3
    f(558) = (2*CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopWFR(1,1,nMZ,3,4,nMW,P,211,0,0))/(3._/**/REALKIND*sw**2)
    f(559) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopWFR(2,2,nMReg,1,3,nMW,P,211,0,0))/(9._/**/REALKIND*sw**4)
    f(560) = (CI*countertermnorm*cw*eQED**6*gQCD*logEWs2loopWFR(2,2,nMReg,1,3,nMW,P,211,0,0))/(9._/**/REALKIND*sw**3)
    f(561) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopWFR(2,2,nMReg,1,4,nMW,P,211,0,0))/(9._/**/REALKIND*sw**4)
    f(562) = (CI*countertermnorm*cw*eQED**6*gQCD*logEWs2loopWFR(2,2,nMReg,1,4,nMW,P,211,0,0))/(9._/**/REALKIND*sw**3)
    f(563) = (CI*countertermnorm*eQED**6*gQCD*logEWs2loopWFR(2,2,nMReg,2,1,nMReg,P,31,0,0))/81._/**/REALKIND
    f(564) = (CI*countertermnorm*eQED**6*gQCD*logEWs2loopWFR(2,2,nMReg,2,1,nMW,P,31,0,0))/(18._/**/REALKIND*sw**2)
    f(565) = (CI*countertermnorm*eQED**6*gQCD*logEWs2loopWFR(2,2,nMReg,2,1,nMZ,P,31,0,0))/9._/**/REALKIND
    f(566) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopWFR(2,2,nMReg,2,3,nMW,P,31,0,0))/(18._/**/REALKIND*sw**4)
    f(567) = (CI*countertermnorm*cw*eQED**6*gQCD*logEWs2loopWFR(2,2,nMReg,2,3,nMW,P,31,0,0))/(18._/**/REALKIND*sw**3)
    f(568) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopWFR(2,2,nMReg,2,4,nMW,P,31,0,0))/(18._/**/REALKIND*sw**4)
    f(569) = (CI*countertermnorm*cw*eQED**6*gQCD*logEWs2loopWFR(2,2,nMReg,2,4,nMW,P,31,0,0))/(18._/**/REALKIND*sw**3)
    f(570) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopWFR(2,2,nMReg,3,4,nMW,P,211,0,0))/(9._/**/REALKIND*sw**4)
    f(571) = (2*CI*countertermnorm*cw**3*eQED**6*gQCD*logEWs2loopWFR(2,2,nMReg,3,4,nMW,P,211,0,0))/(9._/**/REALKIND*sw**3)
    f(572) = (2*CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopWFR(2,2,nMReg,3,4,nMW,P,211,0,0))/(27._/**/REALKIND*sw**2)
    f(573) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopWFR(2,2,nMW,1,3,nMW,P,211,0,0))/(2._/**/REALKIND*sw**6)
    f(574) = (CI*countertermnorm*cw*eQED**6*gQCD*logEWs2loopWFR(2,2,nMW,1,3,nMW,P,211,0,0))/(2._/**/REALKIND*sw**5)
    f(575) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopWFR(2,2,nMW,1,4,nMW,P,211,0,0))/(2._/**/REALKIND*sw**6)
    f(576) = (CI*countertermnorm*cw*eQED**6*gQCD*logEWs2loopWFR(2,2,nMW,1,4,nMW,P,211,0,0))/(2._/**/REALKIND*sw**5)
    f(577) = (CI*countertermnorm*eQED**6*gQCD*logEWs2loopWFR(2,2,nMW,2,1,nMReg,P,31,0,0))/(18._/**/REALKIND*sw**2)
    f(578) = (CI*countertermnorm*eQED**6*gQCD*logEWs2loopWFR(2,2,nMW,2,1,nMW,P,31,0,0))/(4._/**/REALKIND*sw**4)
    f(579) = (CI*countertermnorm*eQED**6*gQCD*logEWs2loopWFR(2,2,nMW,2,1,nMZ,P,31,0,0))/(2._/**/REALKIND*sw**2)
    f(580) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopWFR(2,2,nMW,2,3,nMW,P,31,0,0))/(4._/**/REALKIND*sw**6)
    f(581) = (CI*countertermnorm*cw*eQED**6*gQCD*logEWs2loopWFR(2,2,nMW,2,3,nMW,P,31,0,0))/(4._/**/REALKIND*sw**5)
    f(582) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopWFR(2,2,nMW,2,4,nMW,P,31,0,0))/(4._/**/REALKIND*sw**6)
    f(583) = (CI*countertermnorm*cw*eQED**6*gQCD*logEWs2loopWFR(2,2,nMW,2,4,nMW,P,31,0,0))/(4._/**/REALKIND*sw**5)
    f(584) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopWFR(2,2,nMW,3,4,nMW,P,211,0,0))/(2._/**/REALKIND*sw**6)
    f(585) = (CI*countertermnorm*cw**3*eQED**6*gQCD*logEWs2loopWFR(2,2,nMW,3,4,nMW,P,211,0,0))/sw**5
    f(586) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopWFR(2,2,nMW,3,4,nMW,P,211,0,0))/(3._/**/REALKIND*sw**4)
    f(587) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopWFR(2,2,nMZ,1,3,nMW,P,211,0,0))/sw**4
    f(588) = (CI*countertermnorm*cw*eQED**6*gQCD*logEWs2loopWFR(2,2,nMZ,1,3,nMW,P,211,0,0))/sw**3
    f(589) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopWFR(2,2,nMZ,1,4,nMW,P,211,0,0))/sw**4
    f(590) = (CI*countertermnorm*cw*eQED**6*gQCD*logEWs2loopWFR(2,2,nMZ,1,4,nMW,P,211,0,0))/sw**3
    f(591) = (CI*countertermnorm*eQED**6*gQCD*logEWs2loopWFR(2,2,nMZ,2,1,nMReg,P,31,0,0))/9._/**/REALKIND
    f(592) = (CI*countertermnorm*eQED**6*gQCD*logEWs2loopWFR(2,2,nMZ,2,1,nMW,P,31,0,0))/(2._/**/REALKIND*sw**2)
    f(593) = CI*countertermnorm*eQED**6*gQCD*logEWs2loopWFR(2,2,nMZ,2,1,nMZ,P,31,0,0)
    f(594) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopWFR(2,2,nMZ,2,3,nMW,P,31,0,0))/(2._/**/REALKIND*sw**4)
    f(595) = (CI*countertermnorm*cw*eQED**6*gQCD*logEWs2loopWFR(2,2,nMZ,2,3,nMW,P,31,0,0))/(2._/**/REALKIND*sw**3)
    f(596) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopWFR(2,2,nMZ,2,4,nMW,P,31,0,0))/(2._/**/REALKIND*sw**4)
    f(597) = (CI*countertermnorm*cw*eQED**6*gQCD*logEWs2loopWFR(2,2,nMZ,2,4,nMW,P,31,0,0))/(2._/**/REALKIND*sw**3)
    f(598) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopWFR(2,2,nMZ,3,4,nMW,P,211,0,0))/sw**4
    f(599) = (2*CI*countertermnorm*cw**3*eQED**6*gQCD*logEWs2loopWFR(2,2,nMZ,3,4,nMW,P,211,0,0))/sw**3
    f(600) = (2*CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopWFR(2,2,nMZ,3,4,nMW,P,211,0,0))/(3._/**/REALKIND*sw**2)
    f(601) = (2*CI*countertermnorm*cw*eQED**6*gQCD*logEWs2loopWFR(3,3,nMW,1,2,nMReg,P,211,23,22))/(27._/**/REALKIND*sw)
    f(602) = (2*CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopWFR(3,3,nMW,1,2,nMReg,P,211,23,23))/(9._/**/REALKIND*sw**2)
    f(603) = (2*CI*countertermnorm*cw*eQED**6*gQCD*logEWs2loopWFR(3,3,nMW,1,2,nMW,P,211,23,22))/(3._/**/REALKIND*sw**3)
    f(604) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopWFR(3,3,nMW,1,2,nMW,P,211,23,23))/sw**4
    f(605) = (2*CI*countertermnorm*cw*eQED**6*gQCD*logEWs2loopWFR(3,3,nMW,1,2,nMZ,P,211,23,22))/(3._/**/REALKIND*sw)
    f(606) = (2*CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopWFR(3,3,nMW,1,2,nMZ,P,211,23,23))/sw**2
    f(607) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopWFR(3,3,nMW,1,4,nMW,P,211,23,22))/(3._/**/REALKIND*sw**4)
    f(608) = (2*CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopWFR(3,3,nMW,1,4,nMW,P,211,23,22))/(3._/**/REALKIND*sw**4)
    f(609) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopWFR(3,3,nMW,1,4,nMW,P,211,23,22))/sw**4
    f(610) = (CI*countertermnorm*cw**4*eQED**6*gQCD*logEWs2loopWFR(3,3,nMW,1,4,nMW,P,211,23,23))/sw**6
    f(611) = (CI*countertermnorm*cw**3*eQED**6*gQCD*logEWs2loopWFR(3,3,nMW,1,4,nMW,P,211,23,23))/sw**5
    f(612) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopWFR(3,3,nMW,2,4,nMW,P,211,23,22))/(3._/**/REALKIND*sw**4)
    f(613) = (2*CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopWFR(3,3,nMW,2,4,nMW,P,211,23,22))/(3._/**/REALKIND*sw**4)
    f(614) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopWFR(3,3,nMW,2,4,nMW,P,211,23,22))/sw**4
    f(615) = (CI*countertermnorm*cw**4*eQED**6*gQCD*logEWs2loopWFR(3,3,nMW,2,4,nMW,P,211,23,23))/sw**6
    f(616) = (CI*countertermnorm*cw**3*eQED**6*gQCD*logEWs2loopWFR(3,3,nMW,2,4,nMW,P,211,23,23))/sw**5
    f(617) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopWFR(3,3,nMW,3,1,nMW,P,31,23,22))/(2._/**/REALKIND*sw**4)
    f(618) = (CI*countertermnorm*cw*eQED**6*gQCD*logEWs2loopWFR(3,3,nMW,3,1,nMW,P,31,23,22))/(2._/**/REALKIND*sw**3)
    f(619) = (CI*countertermnorm*cw**4*eQED**6*gQCD*logEWs2loopWFR(3,3,nMW,3,1,nMW,P,31,23,23))/(2._/**/REALKIND*sw**6)
    f(620) = (CI*countertermnorm*cw**3*eQED**6*gQCD*logEWs2loopWFR(3,3,nMW,3,1,nMW,P,31,23,23))/(2._/**/REALKIND*sw**5)
    f(621) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopWFR(3,3,nMW,3,2,nMW,P,31,23,22))/(2._/**/REALKIND*sw**4)
    f(622) = (CI*countertermnorm*cw*eQED**6*gQCD*logEWs2loopWFR(3,3,nMW,3,2,nMW,P,31,23,22))/(2._/**/REALKIND*sw**3)
    f(623) = (CI*countertermnorm*cw**4*eQED**6*gQCD*logEWs2loopWFR(3,3,nMW,3,2,nMW,P,31,23,23))/(2._/**/REALKIND*sw**6)
    f(624) = (CI*countertermnorm*cw**3*eQED**6*gQCD*logEWs2loopWFR(3,3,nMW,3,2,nMW,P,31,23,23))/(2._/**/REALKIND*sw**5)
    f(625) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopWFR(3,3,nMW,3,4,nMW,P,31,23,22))/(2._/**/REALKIND*sw**4)
    f(626) = (CI*countertermnorm*cw**3*eQED**6*gQCD*logEWs2loopWFR(3,3,nMW,3,4,nMW,P,31,23,22))/sw**3
    f(627) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopWFR(3,3,nMW,3,4,nMW,P,31,23,22))/(3._/**/REALKIND*sw**2)
    f(628) = (CI*countertermnorm*cw**4*eQED**6*gQCD*logEWs2loopWFR(3,3,nMW,3,4,nMW,P,31,23,23))/(2._/**/REALKIND*sw**6)
    f(629) = (CI*countertermnorm*cw**5*eQED**6*gQCD*logEWs2loopWFR(3,3,nMW,3,4,nMW,P,31,23,23))/sw**5
    f(630) = (CI*countertermnorm*cw**4*eQED**6*gQCD*logEWs2loopWFR(3,3,nMW,3,4,nMW,P,31,23,23))/(3._/**/REALKIND*sw**4)
    f(631) = (2*CI*countertermnorm*cw*eQED**6*gQCD*logEWs2loopWFR(4,4,nMW,1,2,nMReg,P,211,23,22))/(27._/**/REALKIND*sw)
    f(632) = (2*CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopWFR(4,4,nMW,1,2,nMReg,P,211,23,23))/(9._/**/REALKIND*sw**2)
    f(633) = (2*CI*countertermnorm*cw*eQED**6*gQCD*logEWs2loopWFR(4,4,nMW,1,2,nMW,P,211,23,22))/(3._/**/REALKIND*sw**3)
    f(634) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopWFR(4,4,nMW,1,2,nMW,P,211,23,23))/sw**4
    f(635) = (2*CI*countertermnorm*cw*eQED**6*gQCD*logEWs2loopWFR(4,4,nMW,1,2,nMZ,P,211,23,22))/(3._/**/REALKIND*sw)
    f(636) = (2*CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopWFR(4,4,nMW,1,2,nMZ,P,211,23,23))/sw**2
    f(637) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopWFR(4,4,nMW,1,3,nMW,P,211,23,22))/(3._/**/REALKIND*sw**4)
    f(638) = (2*CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopWFR(4,4,nMW,1,3,nMW,P,211,23,22))/(3._/**/REALKIND*sw**4)
    f(639) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopWFR(4,4,nMW,1,3,nMW,P,211,23,22))/sw**4
    f(640) = (CI*countertermnorm*cw**4*eQED**6*gQCD*logEWs2loopWFR(4,4,nMW,1,3,nMW,P,211,23,23))/sw**6
    f(641) = (CI*countertermnorm*cw**3*eQED**6*gQCD*logEWs2loopWFR(4,4,nMW,1,3,nMW,P,211,23,23))/sw**5
    f(642) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopWFR(4,4,nMW,2,3,nMW,P,211,23,22))/(3._/**/REALKIND*sw**4)
    f(643) = (2*CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopWFR(4,4,nMW,2,3,nMW,P,211,23,22))/(3._/**/REALKIND*sw**4)
    f(644) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopWFR(4,4,nMW,2,3,nMW,P,211,23,22))/sw**4
    f(645) = (CI*countertermnorm*cw**4*eQED**6*gQCD*logEWs2loopWFR(4,4,nMW,2,3,nMW,P,211,23,23))/sw**6
    f(646) = (CI*countertermnorm*cw**3*eQED**6*gQCD*logEWs2loopWFR(4,4,nMW,2,3,nMW,P,211,23,23))/sw**5
    f(647) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopWFR(4,4,nMW,4,1,nMW,P,31,23,22))/(2._/**/REALKIND*sw**4)
    f(648) = (CI*countertermnorm*cw*eQED**6*gQCD*logEWs2loopWFR(4,4,nMW,4,1,nMW,P,31,23,22))/(2._/**/REALKIND*sw**3)
    f(649) = (CI*countertermnorm*cw**4*eQED**6*gQCD*logEWs2loopWFR(4,4,nMW,4,1,nMW,P,31,23,23))/(2._/**/REALKIND*sw**6)
    f(650) = (CI*countertermnorm*cw**3*eQED**6*gQCD*logEWs2loopWFR(4,4,nMW,4,1,nMW,P,31,23,23))/(2._/**/REALKIND*sw**5)
    f(651) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopWFR(4,4,nMW,4,2,nMW,P,31,23,22))/(2._/**/REALKIND*sw**4)
    f(652) = (CI*countertermnorm*cw*eQED**6*gQCD*logEWs2loopWFR(4,4,nMW,4,2,nMW,P,31,23,22))/(2._/**/REALKIND*sw**3)
    f(653) = (CI*countertermnorm*cw**4*eQED**6*gQCD*logEWs2loopWFR(4,4,nMW,4,2,nMW,P,31,23,23))/(2._/**/REALKIND*sw**6)
    f(654) = (CI*countertermnorm*cw**3*eQED**6*gQCD*logEWs2loopWFR(4,4,nMW,4,2,nMW,P,31,23,23))/(2._/**/REALKIND*sw**5)
    f(655) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopWFR(4,4,nMW,4,3,nMW,P,31,23,22))/(2._/**/REALKIND*sw**4)
    f(656) = (CI*countertermnorm*cw**3*eQED**6*gQCD*logEWs2loopWFR(4,4,nMW,4,3,nMW,P,31,23,22))/sw**3
    f(657) = (CI*countertermnorm*cw**2*eQED**6*gQCD*logEWs2loopWFR(4,4,nMW,4,3,nMW,P,31,23,22))/(3._/**/REALKIND*sw**2)
    f(658) = (CI*countertermnorm*cw**4*eQED**6*gQCD*logEWs2loopWFR(4,4,nMW,4,3,nMW,P,31,23,23))/(2._/**/REALKIND*sw**6)
    f(659) = (CI*countertermnorm*cw**5*eQED**6*gQCD*logEWs2loopWFR(4,4,nMW,4,3,nMW,P,31,23,23))/sw**5
    f(660) = (CI*countertermnorm*cw**4*eQED**6*gQCD*logEWs2loopWFR(4,4,nMW,4,3,nMW,P,31,23,23))/(3._/**/REALKIND*sw**4)
    f(661) = (CI*countertermnorm*eQED**6*gQCD*NLLSi(2,nMReg,1,nMReg,P,11))/9._/**/REALKIND
    f(662) = (CI*countertermnorm*eQED**6*gQCD*NLLSi(2,nMReg,1,nMZ,P,11))/3._/**/REALKIND
    f(663) = (CI*countertermnorm*eQED**6*gQCD*NLLSi(2,nMW,1,nMW,P,11))/(2._/**/REALKIND*sw**2)
    f(664) = (CI*countertermnorm*eQED**6*gQCD*NLLSi(2,nMZ,1,nMReg,P,11))/3._/**/REALKIND
    f(665) = CI*countertermnorm*eQED**6*gQCD*NLLSi(2,nMZ,1,nMZ,P,11)
    f(666) = (CI*countertermnorm*cw**2*eQED**6*gQCD*NLLSi(3,nMW,1,nMW,P,11))/(2._/**/REALKIND*sw**4)
    f(667) = (CI*countertermnorm*cw*eQED**6*gQCD*NLLSi(3,nMW,1,nMW,P,11))/(2._/**/REALKIND*sw**3)
    f(668) = (CI*countertermnorm*cw**2*eQED**6*gQCD*NLLSi(3,nMW,2,nMW,P,11))/(2._/**/REALKIND*sw**4)
    f(669) = (CI*countertermnorm*cw*eQED**6*gQCD*NLLSi(3,nMW,2,nMW,P,11))/(2._/**/REALKIND*sw**3)
    f(670) = (CI*countertermnorm*cw**2*eQED**6*gQCD*NLLSi(4,nMW,1,nMW,P,11))/(2._/**/REALKIND*sw**4)
    f(671) = (CI*countertermnorm*cw*eQED**6*gQCD*NLLSi(4,nMW,1,nMW,P,11))/(2._/**/REALKIND*sw**3)
    f(672) = (CI*countertermnorm*cw**2*eQED**6*gQCD*NLLSi(4,nMW,2,nMW,P,11))/(2._/**/REALKIND*sw**4)
    f(673) = (CI*countertermnorm*cw*eQED**6*gQCD*NLLSi(4,nMW,2,nMW,P,11))/(2._/**/REALKIND*sw**3)
    f(674) = (CI*countertermnorm*cw**2*eQED**6*gQCD*NLLSi(4,nMW,3,nMW,P,11))/(2._/**/REALKIND*sw**4)
    f(675) = (CI*countertermnorm*cw**3*eQED**6*gQCD*NLLSi(4,nMW,3,nMW,P,11))/sw**3
    f(676) = (CI*countertermnorm*cw**2*eQED**6*gQCD*NLLSi(4,nMW,3,nMW,P,11))/(3._/**/REALKIND*sw**2)


end subroutine fac_init_loop

subroutine denominators()
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_momenta_decl_/**/REALKIND, only: L
  implicit none
  ! propagators
  den(1) = 1 /((L(5,5))+L(6,5))
  den(2) = 1 /((L(5,10))+L(6,10))
  den(4) = 1 /((L(5,18))+L(6,18))
  den(6) = 1 /((L(5,9))+L(6,9))
  den(7) = 1 /((L(5,6))+L(6,6))
  den(9) = 1 /((L(5,17))+L(6,17))
  den(13) = 1 /((L(5,21))+L(6,21))
  den(15) = 1 /((L(5,13))+L(6,13))
  den(17) = 1 /((L(5,25))+L(6,25))
  den(22) = 1 /((L(5,22))+L(6,22))
  den(24) = 1 /((L(5,14))+L(6,14))
  den(26) = 1 /((L(5,26))+L(6,26))
  den(31) = 1 /((L(5,19))+L(6,19))
  den(33) = 1 /((L(5,19) - MZ2)+L(6,19))
  den(37) = 1 /((L(5,12) - MW2)+L(6,12))
  den(52) = 1 /((L(5,12))+L(6,12))
  den(54) = 1 /((L(5,12) - MZ2)+L(6,12))
  den(58) = 1 /((L(5,19) - MW2)+L(6,19))

  ! denominators
  den(3) = den(1)*den(2)
  den(5) = den(1)*den(4)
  den(8) = den(6)*den(7)
  den(10) = den(7)*den(9)
  den(11) = den(4)*den(6)
  den(12) = den(2)*den(9)
  den(14) = den(1)*den(13)
  den(16) = den(1)*den(15)
  den(18) = den(6)*den(17)
  den(19) = den(6)*den(15)
  den(20) = den(9)*den(17)
  den(21) = den(9)*den(13)
  den(23) = den(7)*den(22)
  den(25) = den(7)*den(24)
  den(27) = den(2)*den(26)
  den(28) = den(2)*den(24)
  den(29) = den(4)*den(26)
  den(30) = den(4)*den(22)
  den(32) = den(9)*den(31)
  den(34) = den(9)*den(33)
  den(35) = den(4)*den(31)
  den(36) = den(4)*den(33)
  den(38) = den(9)*den(37)
  den(39) = den(4)*den(37)
  den(40) = den(9)*den(28)
  den(41) = den(9)*den(25)
  den(42) = den(2)*den(21)
  den(43) = den(7)*den(20)
  den(44) = den(6)*den(30)
  den(45) = den(6)*den(23)
  den(46) = den(4)*den(19)
  den(47) = den(7)*den(18)
  den(48) = den(1)*den(29)
  den(49) = den(1)*den(27)
  den(50) = den(4)*den(16)
  den(51) = den(2)*den(14)
  den(53) = den(9)*den(52)
  den(55) = den(9)*den(54)
  den(56) = den(4)*den(52)
  den(57) = den(4)*den(54)
  den(59) = den(9)*den(58)
  den(60) = den(4)*den(58)
  den(61) = den(15)*den(52)
  den(62) = den(15)*den(54)
  den(63) = den(24)*den(52)
  den(64) = den(24)*den(54)
  den(65) = den(15)*den(37)
  den(66) = den(24)*den(37)

end subroutine denominators

#ifdef PRECISION_dp
! **********************************************************************
subroutine init_merging_tables(tot_num_hels, tot_num_merge_steps)
!-----------------------------------------------------------------------
! In the first event the merging tables are fully initialised
! **********************************************************************
  implicit none
  integer, intent(in) :: tot_num_hels, tot_num_merge_steps
  n_merge_steps = tot_num_merge_steps
  allocate(merge_tables(tot_num_hels,2,n_merge_steps))
  allocate(merge_mism(n_merge_steps+1))
  allocate(merge_hels(n_merge_steps))
  merge_tables_on = .true.
  merge_mism = 0_intkind2
  merge_tables = -1_intkind2
  merge_hels = -1_intkind2
end subroutine init_merging_tables

! **********************************************************************
subroutine update_merging_tables(tot_num_hels)
!-----------------------------------------------------------------------
! After the first evaluation the merging tables are adapted
! **********************************************************************
  implicit none
  integer, intent(in) :: tot_num_hels
  integer(intkind2), allocatable ::  merge_tables_tmp(:,:,:), merge_hels_tmp(:)

  if(merge_mism(1) == 0) then ! helicity configurations match in all merging steps
    if(allocated(merge_tables)) deallocate(merge_tables)
    if(allocated(merge_hels)) deallocate(merge_hels)
    if(allocated(merge_mism)) deallocate(merge_mism)
    allocate(merge_mism(1))
    allocate(merge_hels(1))
    allocate(merge_tables(1,1,1)) ! dummy allocation
    merge_mism = 0_intkind2
    merge_tables = -1_intkind2
    merge_hels = -1_intkind2
  else
    n_merge_mism = merge_mism(1)
    allocate(merge_tables_tmp(tot_num_hels,2,n_merge_mism))
    merge_tables_tmp(:,:,1:n_merge_mism) = merge_tables(:,:,1:n_merge_mism)
    if(allocated(merge_tables)) then
      deallocate(merge_tables)
      allocate(merge_tables(tot_num_hels,2,n_merge_mism))
    end if
    merge_tables = merge_tables_tmp
    if(allocated(merge_tables_tmp)) deallocate(merge_tables_tmp)
    allocate(merge_hels_tmp(n_merge_mism))
    merge_hels_tmp(1:n_merge_mism) = merge_hels(1:n_merge_mism)
    if(allocated(merge_hels)) then
      deallocate(merge_hels)
      allocate(merge_hels(n_merge_mism))
    end if
    merge_hels = merge_hels_tmp
    if(allocated(merge_hels_tmp)) deallocate(merge_hels_tmp)
  end if
  merge_tables_on = .true.
end subroutine update_merging_tables
#endif

! **********************************************************************
subroutine allocate_diagrams()
!-----------------------------------------------------------------------
! After the first Born evaluation, colour-stripped amplitudes and
! colour vectors are initialiased with the minimum number of relevant
! helicity states.
! **********************************************************************
#ifndef PRECISION_dp
  use ol_loop_storage_ppzzj2loop_ddxzzg_1_/**/DREALKIND, only: hel_states
#endif
  implicit none

  if (allocated(A)) deallocate(A)
  if (allocated(M1helarray)) deallocate(M1helarray)
  if (allocated(M1helarray_ct)) deallocate(M1helarray_ct)
  if (allocated(M0_col1_helarray)) deallocate(M0_col1_helarray)
  allocate(A(hel_states,3730))
  allocate(M1helarray(1,hel_states))
  allocate(M1helarray_ct(1,hel_states))
  allocate(M0_col1_helarray(1,hel_states))
  A(1:hel_states,1:3730)%j = 0
  A(1:hel_states,1:3730)%e = 0
  A(1:hel_states,1:3730)%hf = 0
  A(1:hel_states,1:3730)%s = 0
#if 1 > 0
  if (allocated(M0M1_hel_cc)) deallocate(M0M1_hel_cc)
  allocate(M0M1_hel_cc(1,hel_states,16))
#endif
end subroutine allocate_diagrams

!
!
!
! **********************************************************************
#ifdef PRECISION_dp
recursive subroutine amp2(P_scatt, M02, qp_kinematics, M2ct, M2colint)
#else
recursive subroutine amp2(P_scatt, M02, qp_kinematics, M2ct, M2colint)
  use ol_loop_storage_ppzzj2loop_ddxzzg_1_/**/DREALKIND, only: &
  nhel, Hel, hel_states
#endif
! P_scatt(0:3,Npart) = incoming external momenta
! M2  = helicity-summed squared matrix element for down anti-down Z Z glue -> 0
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND !, only: ci, parameters_status, ZERO, scalefactor, >masses<
  use ol_parameters_init_/**/REALKIND, only: ensure_mp_init, ensure_mp_loop_init
  use ol_kinematics_/**/REALKIND, only: init_kinematics
  use ol_momenta_decl_/**/DREALKIND, only: momenta_nan_check
  use ol_settings_ppzzj2loop_ddxzzg_1, only: hel_mem_opt, loopcc
  use ol_data_types_/**/REALKIND
  use ol_h_helicity_bookkeeping_/**/REALKIND, only: &
    & helbookkeeping_wf, helsync, flip_phase
  use ol_helicity_init, only: helbookkeeping_flip, helsync_flip
  use ol_hel_propagators_/**/REALKIND
  use ol_hel_wavefunctions_/**/REALKIND
  use ol_wavefunctions_/**/REALKIND, only: wf_V_Std
  use ol_ewsud_/**/REALKIND, only: set_shat
  use ol_ewsud2loop_/**/REALKIND
! 
  use ol_hel_vertices_/**/REALKIND
  use ol_hel_contractions_/**/REALKIND
  use ol_external_ppzzj2loop_ddxzzg_1, only: &
    & external_perm_ppzzj2loop_ddxzzg_1, &
    & external_perm_inv_ppzzj2loop_ddxzzg_1, &
    & extcomb_perm_ppzzj2loop_ddxzzg_1, &
    & average_factor_ppzzj2loop_ddxzzg_1
  use ol_external_ppzzj2loop_ddxzzg_1, only: &
    & H, hel_not_initialised, hel_init, POLSEL 
  use ol_colourmatrix_ppzzj2loop_ddxzzg_1_/**/REALKIND, only: &
    & colmat_not_initialised, colourmatrix_init
  use ol_forced_parameters_ppzzj2loop_ddxzzg_1_/**/REALKIND, only: &
    & check_forced_parameters
  use ol_heltables_OLR_ppzzj2loop_ddxzzg_1
  use ol_kinematics_/**/REALKIND, only: LC2Std_Rep_cmplx
  use ol_h_counterterms_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND ! counterterms
  use ol_loop_parameters_decl_/**/DREALKIND, only: &
    & IR_is_on, DOI, CT_is_on, R2_is_on, TP_is_on
  use ol_init, only: set_parameter, parameters_flush
#ifdef PRECISION_dp
  use ol_kinematics_/**/QREALKIND, only: conv_mom_scatt2in_qp=>conv_mom_scatt2in, &
                                         internal_momenta_qp=>internal_momenta
  use ol_momenta_decl_/**/DREALKIND, only: L
  use ol_momenta_decl_/**/QREALKIND, only: L_qp=>L
#endif
  implicit none

  real(DREALKIND), intent(in)  :: P_scatt(0:3,5)
  real(REALKIND),  intent(out) :: M02
  logical, intent(in) :: qp_kinematics
  real(REALKIND),  intent(out), optional :: M2ct
  real(REALKIND),  intent(out), optional :: M2colint(16)
  real(REALKIND) :: iM2ct
  real(REALKIND) :: iM2colint(16)

  integer(intkind1), save :: ntry = 0

  integer           :: shift, k, r, m, n, i
  real(REALKIND)    :: P(0:3,5)
#ifdef PRECISION_dp
  real(QREALKIND)    :: P_qp(0:3,5)
#endif
  integer           :: extmasses2(5)
  real(REALKIND)    :: M2add, M2add_ct, M2add_colint(16)
  complex(REALKIND) :: M1(1), M2(1)
  real(REALKIND)    :: P_scatt_intern(0:3,5)
  real(REALKIND), save :: scalebackfactor, old_scalefactor = 0
  integer(intkind1) :: nsync
  integer, allocatable :: extcombs_permuted(:)
  integer              :: extcombs(16), nextcombs
  integer              :: CT_on_bak, R2_on_bak, TP_on_bak, DOI_bak
  logical              :: do_ct, do_colint
#if 5 > 3
  integer :: ind_cc_comb(5)
#endif
  complex(REALKIND) :: omega(2) ! phases for helicity correlations

  if (present(M2ct)) then
    do_ct = .true.
  else
    do_ct = .false.
  end if

  if (present(M2colint)) then
    do_colint = .true.
  else
    do_colint = .false.
  end if

  if(ntry == 0) then
    ! recursive initialization call needed for the correct helicity bokkeeping
    ntry = 1
    CT_on_bak = CT_is_on
    R2_on_bak = R2_is_on
    TP_on_bak = TP_is_on
    DOI_bak = DOI
    call set_parameter("ct_on", 1)
    call set_parameter("r2_on", 1)
    call set_parameter("tp_on", 1)
    DOI = 1
    call amp2(P_scatt, M02, qp_kinematics, M2ct=iM2ct, M2colint=iM2colint)
    call set_parameter("ct_on", CT_on_bak)
    call set_parameter("r2_on", R2_on_bak)
    call set_parameter("tp_on", TP_on_bak)
    DOI = DOI_bak
  end if

  if (ntry < 2) then
    if (allocated(A)) deallocate(A)
    allocate(A(nhel,3730))
  end if

  if (do_ct) call set_parameter("ew_renorm", 1)
   extmasses2 = [ 0, 0, nMZ, nMZ, 0 ]
  ! Convert 2 -> n-2 PS-point to n -> 0 (so that P(1) + ... + P(n) = 0) and compute
  ! internal-propagator momenta in light-cone representation
  call init_kinematics(P_scatt, extmasses2, P, &
     external_perm_inv_ppzzj2loop_ddxzzg_1, 5, qp_kinematics)

  if (do_ct) call set_shat(P,external_perm_inv_ppzzj2loop_ddxzzg_1)
  if (do_ct) call set_muren2(P)

  call parameters_flush()
  call ensure_mp_init()
  if (do_ct) call ensure_mp_loop_init()

  if (colmat_not_initialised) call colourmatrix_init()

  if (fac_status_loop1 /= parameters_status .or. fac_status_loop2 /= loop_parameters_status) then
    call check_forced_parameters()
  end if

  if (momenta_nan_check(P_scatt) /= 0) then
    M02 = 0
    return
  end if

!  extmasses2 = [ 0, 0, nMZ, nMZ, 0 ]

  extmasses2 = [ 0, 0, nMZ, nMZ, 0 ]
  ! Convert 2 -> n-2 PS-point to n -> 0 (so that P(1) + ... + P(n) = 0) and compute
  ! internal-propagator momenta in light-cone representation
!  call init_kinematics(P_scatt, extmasses2, P, &
!     external_perm_inv_ppzzj2loop_ddxzzg_1, 5, qp_kinematics)

!  if (do_ct) call set_shat(P,external_perm_inv_ppzzj2loop_ddxzzg_1)
  if (do_ct) call fac_init_loop(P)

  ! denominators
  call denominators()

   if (heltables_not_init) call init_heltables()

  ! external WFs
  ! Here the external wavefunctions are initialiased
  call pol_wf_Q(P(:,1), rZERO, H1, ex1, POLSEL(1),1)
  call pol_wf_A(P(:,2), rZERO, H2, ex2, POLSEL(2),2)
  call pol_wf_V(P(:,3), rMZ, H3, ex3, POLSEL(3),3)
  call pol_wf_V(P(:,4), rMZ, H4, ex4, POLSEL(4),4)
  call pol_wf_V(P(:,5), rZERO, H5, ex5, POLSEL(5),5)



  ! internal WFs
  ! e.g. call vert_VQ_A(ntry, ex3, ex1, wf1, n1, t1) ...
  call vert_ZQ_A(gZd,ntry, ex3(:), ex1(:), wf6(:,1), n3(:,1), t3x6(:,:,1))
  call vert_AZ_Q(gZd,ntry, ex2(:), ex4(:), wf6(:,2), n3(:,2), t3x6(:,:,2))
  call prop_Q_A(ntry, wf6(:,1), 5, ZERO, 0_intkind1, wf6(:,3), n2(1))
  call prop_A_Q(ntry, wf6(:,2), 10, ZERO, 0_intkind1, wf6(:,4), n2(2))
  call vert_VQ_A(ntry, ex5(:), wf6(:,3), wf12(:,1), n3(:,3), t3x12(:,:,1))
  call vert_AV_Q(ntry, ex2(:), ex5(:), wf4(:,1), n3(:,4), t3x4(:,:,1))
  call prop_A_Q(ntry, wf4(:,1), 18, ZERO, 0_intkind1, wf4(:,2), n2(3))
  call vert_ZQ_A(gZd,ntry, ex4(:), wf6(:,3), wf18(:,1), n3(:,5), t3x18(:,:,1))
  call vert_ZQ_A(gZd,ntry, ex4(:), ex1(:), wf6(:,5), n3(:,6), t3x6(:,:,3))
  call vert_AZ_Q(gZd,ntry, ex2(:), ex3(:), wf6(:,6), n3(:,7), t3x6(:,:,4))
  call prop_Q_A(ntry, wf6(:,5), 9, ZERO, 0_intkind1, wf6(:,7), n2(4))
  call prop_A_Q(ntry, wf6(:,6), 6, ZERO, 0_intkind1, wf6(:,8), n2(5))
  call vert_VQ_A(ntry, ex5(:), wf6(:,7), wf12(:,2), n3(:,8), t3x12(:,:,2))
  call vert_VQ_A(ntry, ex5(:), ex1(:), wf4(:,3), n3(:,9), t3x4(:,:,2))
  call prop_Q_A(ntry, wf4(:,3), 17, ZERO, 0_intkind1, wf4(:,4), n2(6))
  call vert_ZQ_A(gZd,ntry, ex4(:), wf4(:,4), wf12(:,3), n3(:,10), t3x12(:,:,3))
  call vert_ZQ_A(gZd,ntry, ex3(:), wf6(:,7), wf18(:,2), n3(:,11), t3x18(:,:,2))
  call vert_ZQ_A(gZd,ntry, ex3(:), wf4(:,4), wf12(:,4), n3(:,12), t3x12(:,:,4))
  call counter_A_Q_LR_EWs([cONE,cONE],ntry, ex2(:), 2, wf2(:,1), n2(7))
  call counter_A_Q_LR_EWs([cONE,cONE],ntry, wf2(:,1), 2, wf2(:,2), n2(8))
  call prop_Q_A(ntry, wf12(:,1), 21, ZERO, 0_intkind1, wf12(:,5), n2(9))
  call vert_AZ_Q(gZd,ntry, wf2(:,2), ex4(:), wf6(:,9), n3(:,13), t3x6(:,:,5))
  call prop_Q_A(ntry, wf18(:,1), 13, ZERO, 0_intkind1, wf18(:,3), n2(10))
  call vert_AV_Q(ntry, wf2(:,2), ex5(:), wf4(:,5), n3(:,14), t3x4(:,:,3))
  call prop_Q_A(ntry, wf12(:,2), 25, ZERO, 0_intkind1, wf12(:,6), n2(11))
  call vert_AZ_Q(gZd,ntry, wf2(:,2), ex3(:), wf6(:,10), n3(:,15), t3x6(:,:,6))
  call prop_Q_A(ntry, wf18(:,2), 13, ZERO, 0_intkind1, wf18(:,4), n2(12))
  call prop_Q_A(ntry, wf12(:,3), 25, ZERO, 0_intkind1, wf12(:,7), n2(13))
  call prop_Q_A(ntry, wf12(:,4), 21, ZERO, 0_intkind1, wf12(:,8), n2(14))
  call counter_Q_A_LR_EWs([cONE,cONE],ntry, ex1(:), 1, wf2(:,3), n2(15))
  call vert_AV_Q(ntry, wf6(:,8), ex5(:), wf12(:,9), n3(:,16), t3x12(:,:,5))
  call counter_Q_A_LR_EWs([cONE,cONE],ntry, wf2(:,3), 1, wf2(:,4), n2(16))
  call prop_A_Q(ntry, wf12(:,9), 22, ZERO, 0_intkind1, wf12(:,10), n2(17))
  call vert_ZQ_A(gZd,ntry, ex4(:), wf2(:,4), wf6(:,11), n3(:,17), t3x6(:,:,7))
  call vert_AZ_Q(gZd,ntry, wf6(:,8), ex4(:), wf18(:,5), n3(:,18), t3x18(:,:,3))
  call prop_A_Q(ntry, wf18(:,5), 14, ZERO, 0_intkind1, wf18(:,6), n2(18))
  call vert_VQ_A(ntry, ex5(:), wf2(:,4), wf4(:,6), n3(:,19), t3x4(:,:,4))
  call vert_AV_Q(ntry, wf6(:,4), ex5(:), wf12(:,11), n3(:,20), t3x12(:,:,6))
  call prop_A_Q(ntry, wf12(:,11), 26, ZERO, 0_intkind1, wf12(:,12), n2(19))
  call vert_ZQ_A(gZd,ntry, ex3(:), wf2(:,4), wf6(:,12), n3(:,21), t3x6(:,:,8))
  call vert_AZ_Q(gZd,ntry, wf6(:,4), ex3(:), wf18(:,7), n3(:,22), t3x18(:,:,4))
  call prop_A_Q(ntry, wf18(:,7), 14, ZERO, 0_intkind1, wf18(:,8), n2(20))
  call vert_AZ_Q(gZd,ntry, wf4(:,2), ex4(:), wf12(:,13), n3(:,23), t3x12(:,:,7))
  call prop_A_Q(ntry, wf12(:,13), 26, ZERO, 0_intkind1, wf12(:,14), n2(21))
  call vert_AZ_Q(gZd,ntry, wf4(:,2), ex3(:), wf12(:,15), n3(:,24), t3x12(:,:,8))
  call prop_A_Q(ntry, wf12(:,15), 22, ZERO, 0_intkind1, wf12(:,16), n2(22))
  call counter_A_Q_LR_EWs(gZd,ntry, ex2(:), 2, wf2(:,5), n2(23))
  call counter_A_Q_LR_EWs(gZd,ntry, wf2(:,5), 2, wf2(:,6), n2(24))
  call vert_AZ_Q(gZd,ntry, wf2(:,6), ex4(:), wf6(:,13), n3(:,25), t3x6(:,:,9))
  call vert_AV_Q(ntry, wf2(:,6), ex5(:), wf4(:,7), n3(:,26), t3x4(:,:,5))
  call vert_AZ_Q(gZd,ntry, wf2(:,6), ex3(:), wf6(:,14), n3(:,27), t3x6(:,:,10))
  call counter_Q_A_LR_EWs(gZd,ntry, ex1(:), 1, wf2(:,7), n2(25))
  call counter_Q_A_LR_EWs(gZd,ntry, wf2(:,7), 1, wf2(:,8), n2(26))
  call vert_ZQ_A(gZd,ntry, ex4(:), wf2(:,8), wf6(:,15), n3(:,28), t3x6(:,:,11))
  call vert_VQ_A(ntry, ex5(:), wf2(:,8), wf4(:,8), n3(:,29), t3x4(:,:,6))
  call vert_ZQ_A(gZd,ntry, ex3(:), wf2(:,8), wf6(:,16), n3(:,30), t3x6(:,:,12))
  call counter_V_U_T_EWs(cONE,ntry, ex4(:), 8, wf3(:,1), n2(27))
  call vert_QA_V(ntry, wf6(:,3), wf4(:,2), wf24(:,1), n3(:,31), t3x24(:,:,1))
  call counter_W_V_T_EWs(cONE,ntry, wf3(:,1), 8, wf3(:,2), n2(28))
  call counter_V_W_T_EWs(cONE,ntry, ex4(:), 8, wf3(:,3), n2(29))
  call counter_U_V_T_EWs(cONE,ntry, wf3(:,3), 8, wf3(:,4), n2(30))
  call vert_QA_Z(gZd,ntry, wf6(:,3), wf4(:,2), wf24(:,2), n3(:,32), t3x24(:,:,2))
  call vert_AV_Q(ntry, ex2(:), wf3(:,2), wf6(:,17), n3(:,33), t3x6(:,:,13))
  call vert_AV_Q(ntry, ex2(:), wf3(:,4), wf6(:,18), n3(:,34), t3x6(:,:,14))
  call vert_AZ_Q(gZd,ntry, ex2(:), wf3(:,2), wf6(:,19), n3(:,35), t3x6(:,:,15))
  call vert_AZ_Q(gZd,ntry, ex2(:), wf3(:,4), wf6(:,20), n3(:,36), t3x6(:,:,16))
  call vert_QA_V(ntry, wf4(:,4), wf6(:,8), wf24(:,3), n3(:,37), t3x24(:,:,3))
  call vert_QA_Z(gZd,ntry, wf4(:,4), wf6(:,8), wf24(:,4), n3(:,38), t3x24(:,:,4))
  call vert_VQ_A(ntry, wf3(:,2), ex1(:), wf6(:,21), n3(:,39), t3x6(:,:,17))
  call vert_VQ_A(ntry, wf3(:,4), ex1(:), wf6(:,22), n3(:,40), t3x6(:,:,18))
  call vert_ZQ_A(gZd,ntry, wf3(:,2), ex1(:), wf6(:,23), n3(:,41), t3x6(:,:,19))
  call vert_ZQ_A(gZd,ntry, wf3(:,4), ex1(:), wf6(:,24), n3(:,42), t3x6(:,:,20))
  call counter_V_U_T_EWs(cONE,ntry, ex3(:), 4, wf3(:,5), n2(31))
  call vert_QA_V(ntry, wf6(:,7), wf4(:,2), wf24(:,5), n3(:,43), t3x24(:,:,5))
  call counter_W_V_T_EWs(cONE,ntry, wf3(:,5), 4, wf3(:,6), n2(32))
  call counter_V_W_T_EWs(cONE,ntry, ex3(:), 4, wf3(:,7), n2(33))
  call counter_U_V_T_EWs(cONE,ntry, wf3(:,7), 4, wf3(:,8), n2(34))
  call vert_QA_Z(gZd,ntry, wf6(:,7), wf4(:,2), wf24(:,6), n3(:,44), t3x24(:,:,6))
  call vert_AV_Q(ntry, ex2(:), wf3(:,6), wf6(:,25), n3(:,45), t3x6(:,:,21))
  call vert_AV_Q(ntry, ex2(:), wf3(:,8), wf6(:,26), n3(:,46), t3x6(:,:,22))
  call vert_AZ_Q(gZd,ntry, ex2(:), wf3(:,6), wf6(:,27), n3(:,47), t3x6(:,:,23))
  call vert_AZ_Q(gZd,ntry, ex2(:), wf3(:,8), wf6(:,28), n3(:,48), t3x6(:,:,24))
  call vert_QA_V(ntry, wf4(:,4), wf6(:,4), wf24(:,7), n3(:,49), t3x24(:,:,7))
  call vert_QA_Z(gZd,ntry, wf4(:,4), wf6(:,4), wf24(:,8), n3(:,50), t3x24(:,:,8))
  call vert_VQ_A(ntry, wf3(:,6), ex1(:), wf6(:,29), n3(:,51), t3x6(:,:,25))
  call vert_VQ_A(ntry, wf3(:,8), ex1(:), wf6(:,30), n3(:,52), t3x6(:,:,26))
  call vert_ZQ_A(gZd,ntry, wf3(:,6), ex1(:), wf6(:,31), n3(:,53), t3x6(:,:,27))
  call vert_ZQ_A(gZd,ntry, wf3(:,8), ex1(:), wf6(:,32), n3(:,54), t3x6(:,:,28))
  call counter_A_Q_LR_EWs([ZERO,cONE],ntry, ex2(:), 2, wf2(:,9), n2(35))
  call counter_A_Q_LR_EWs([ZERO,cONE],ntry, wf2(:,9), 2, wf2(:,10), n2(36))
  call vert_AZ_Q(gZd,ntry, wf2(:,10), ex4(:), wf6(:,33), n3(:,55), t3x6(:,:,29))
  call vert_AV_Q(ntry, wf2(:,10), ex5(:), wf4(:,9), n3(:,56), t3x4(:,:,7))
  call vert_AZ_Q(gZd,ntry, wf2(:,10), ex3(:), wf6(:,34), n3(:,57), t3x6(:,:,30))
  call counter_Q_A_LR_EWs([ZERO,cONE],ntry, ex1(:), 1, wf2(:,11), n2(37))
  call counter_Q_A_LR_EWs([ZERO,cONE],ntry, wf2(:,11), 1, wf2(:,12), n2(38))
  call vert_ZQ_A(gZd,ntry, ex4(:), wf2(:,12), wf6(:,35), n3(:,58), t3x6(:,:,31))
  call vert_VQ_A(ntry, ex5(:), wf2(:,12), wf4(:,10), n3(:,59), t3x4(:,:,8))
  call vert_ZQ_A(gZd,ntry, ex3(:), wf2(:,12), wf6(:,36), n3(:,60), t3x6(:,:,32))
  call vert_AZ_Q(gZd,ntry, wf2(:,1), ex3(:), wf6(:,37), n3(:,61), t3x6(:,:,33))
  call vert_ZQ_A(gZd,ntry, ex4(:), wf2(:,3), wf6(:,38), n3(:,62), t3x6(:,:,34))
  call prop_A_Q(ntry, wf6(:,37), 6, ZERO, 0_intkind1, wf6(:,39), n2(39))
  call prop_Q_A(ntry, wf6(:,38), 9, ZERO, 0_intkind1, wf6(:,40), n2(40))
  call vert_AV_Q(ntry, wf6(:,39), ex5(:), wf12(:,17), n3(:,63), t3x12(:,:,9))
  call vert_VQ_A(ntry, ex5(:), wf2(:,3), wf4(:,11), n3(:,64), t3x4(:,:,9))
  call prop_Q_A(ntry, wf4(:,11), 17, ZERO, 0_intkind1, wf4(:,12), n2(41))
  call vert_AZ_Q(gZd,ntry, wf6(:,39), ex4(:), wf18(:,9), n3(:,65), t3x18(:,:,5))
  call vert_ZQ_A(gZd,ntry, ex3(:), wf2(:,3), wf6(:,41), n3(:,66), t3x6(:,:,35))
  call vert_AZ_Q(gZd,ntry, wf2(:,1), ex4(:), wf6(:,42), n3(:,67), t3x6(:,:,36))
  call prop_Q_A(ntry, wf6(:,41), 5, ZERO, 0_intkind1, wf6(:,43), n2(42))
  call prop_A_Q(ntry, wf6(:,42), 10, ZERO, 0_intkind1, wf6(:,44), n2(43))
  call vert_VQ_A(ntry, ex5(:), wf6(:,43), wf12(:,18), n3(:,68), t3x12(:,:,10))
  call vert_AZ_Q(gZd,ntry, wf6(:,44), ex3(:), wf18(:,10), n3(:,69), t3x18(:,:,6))
  call vert_AV_Q(ntry, wf2(:,1), ex5(:), wf4(:,13), n3(:,70), t3x4(:,:,10))
  call prop_A_Q(ntry, wf4(:,13), 18, ZERO, 0_intkind1, wf4(:,14), n2(44))
  call vert_ZQ_A(gZd,ntry, ex4(:), wf6(:,43), wf18(:,11), n3(:,71), t3x18(:,:,7))
  call vert_ZQ_A(gZd,ntry, ex3(:), wf6(:,40), wf18(:,12), n3(:,72), t3x18(:,:,8))
  call vert_AZ_Q(gZd,ntry, wf2(:,5), ex3(:), wf6(:,45), n3(:,73), t3x6(:,:,37))
  call vert_ZQ_A(gZd,ntry, ex4(:), wf2(:,7), wf6(:,46), n3(:,74), t3x6(:,:,38))
  call prop_A_Q(ntry, wf6(:,45), 6, ZERO, 0_intkind1, wf6(:,47), n2(45))
  call prop_Q_A(ntry, wf6(:,46), 9, ZERO, 0_intkind1, wf6(:,48), n2(46))
  call vert_AV_Q(ntry, wf6(:,47), ex5(:), wf12(:,19), n3(:,75), t3x12(:,:,11))
  call vert_VQ_A(ntry, ex5(:), wf2(:,7), wf4(:,15), n3(:,76), t3x4(:,:,11))
  call prop_Q_A(ntry, wf4(:,15), 17, ZERO, 0_intkind1, wf4(:,16), n2(47))
  call vert_AZ_Q(gZd,ntry, wf6(:,47), ex4(:), wf18(:,13), n3(:,77), t3x18(:,:,9))
  call vert_ZQ_A(gZd,ntry, ex3(:), wf2(:,7), wf6(:,49), n3(:,78), t3x6(:,:,39))
  call vert_AZ_Q(gZd,ntry, wf2(:,5), ex4(:), wf6(:,50), n3(:,79), t3x6(:,:,40))
  call prop_Q_A(ntry, wf6(:,49), 5, ZERO, 0_intkind1, wf6(:,51), n2(48))
  call prop_A_Q(ntry, wf6(:,50), 10, ZERO, 0_intkind1, wf6(:,52), n2(49))
  call vert_VQ_A(ntry, ex5(:), wf6(:,51), wf12(:,20), n3(:,80), t3x12(:,:,12))
  call vert_AZ_Q(gZd,ntry, wf6(:,52), ex3(:), wf18(:,14), n3(:,81), t3x18(:,:,10))
  call vert_AV_Q(ntry, wf2(:,5), ex5(:), wf4(:,17), n3(:,82), t3x4(:,:,12))
  call prop_A_Q(ntry, wf4(:,17), 18, ZERO, 0_intkind1, wf4(:,18), n2(50))
  call vert_ZQ_A(gZd,ntry, ex4(:), wf6(:,51), wf18(:,15), n3(:,83), t3x18(:,:,11))
  call vert_ZQ_A(gZd,ntry, ex3(:), wf6(:,48), wf18(:,16), n3(:,84), t3x18(:,:,12))
  call vert_QA_V(ntry, wf4(:,4), ex2(:), wf8(:,1), n3(:,85), t3x8(:,:,1))
  call vert_UV_W(ntry, wf3(:,7), 4, wf3(:,1), 8, wf9(:,1), n3(:,86), t3x9(:,:,1))
  call vert_UV_W(ntry, wf3(:,3), 8, wf3(:,5), 4, wf9(:,2), n3(:,87), t3x9(:,:,2))
  call vert_QA_Z(gZd,ntry, wf4(:,4), ex2(:), wf8(:,2), n3(:,88), t3x8(:,:,2))
  call vert_QA_V(ntry, ex1(:), wf4(:,2), wf8(:,3), n3(:,89), t3x8(:,:,3))
  call vert_QA_Z(gZd,ntry, ex1(:), wf4(:,2), wf8(:,4), n3(:,90), t3x8(:,:,4))
  call vert_AV_Q(ntry, wf2(:,9), ex5(:), wf4(:,19), n3(:,91), t3x4(:,:,13))
  call vert_WQ_A(ntry, wf3(:,3), wf6(:,3), wf18(:,17), n3(:,92), t3x18(:,:,13))
  call prop_A_Q(ntry, wf4(:,19), 18, ZERO, 0_intkind1, wf4(:,20), n2(51))
  call vert_AW_Q(ntry, wf2(:,9), wf3(:,3), wf6(:,53), n3(:,93), t3x6(:,:,41))
  call vert_UV_W(ntry, ex3(:), 4, wf3(:,3), 8, wf9(:,3), n3(:,94), t3x9(:,:,3))
  call vert_QA_W(ntry, wf4(:,4), wf2(:,9), wf8(:,5), n3(:,95), t3x8(:,:,5))
  call vert_AZ_Q(gZu,ntry, wf2(:,9), ex3(:), wf6(:,54), n3(:,96), t3x6(:,:,42))
  call vert_WQ_A(ntry, wf3(:,3), wf4(:,4), wf12(:,21), n3(:,97), t3x12(:,:,13))
  call prop_A_Q(ntry, wf6(:,54), 6, ZERO, 0_intkind1, wf6(:,55), n2(52))
  call vert_WQ_A(ntry, wf3(:,3), ex1(:), wf6(:,56), n3(:,98), t3x6(:,:,43))
  call prop_Q_A(ntry, wf6(:,56), 9, ZERO, 0_intkind1, wf6(:,57), n2(53))
  call vert_VQ_A(ntry, ex5(:), wf6(:,57), wf12(:,22), n3(:,99), t3x12(:,:,14))
  call vert_ZQ_A(gZu,ntry, ex3(:), wf6(:,57), wf18(:,18), n3(:,100), t3x18(:,:,14))
  call vert_WQ_A(ntry, wf9(:,3), ex1(:), wf18(:,19), n3(:,101), t3x18(:,:,15))
  call vert_WQ_A(ntry, wf3(:,7), wf6(:,7), wf18(:,20), n3(:,102), t3x18(:,:,16))
  call vert_AW_Q(ntry, wf2(:,9), wf3(:,7), wf6(:,58), n3(:,103), t3x6(:,:,44))
  call vert_UV_W(ntry, ex4(:), 8, wf3(:,7), 4, wf9(:,4), n3(:,104), t3x9(:,:,4))
  call vert_AZ_Q(gZu,ntry, wf2(:,9), ex4(:), wf6(:,59), n3(:,105), t3x6(:,:,45))
  call vert_WQ_A(ntry, wf3(:,7), wf4(:,4), wf12(:,23), n3(:,106), t3x12(:,:,15))
  call prop_A_Q(ntry, wf6(:,59), 10, ZERO, 0_intkind1, wf6(:,60), n2(54))
  call vert_WQ_A(ntry, wf3(:,7), ex1(:), wf6(:,61), n3(:,107), t3x6(:,:,46))
  call prop_Q_A(ntry, wf6(:,61), 5, ZERO, 0_intkind1, wf6(:,62), n2(55))
  call vert_VQ_A(ntry, ex5(:), wf6(:,62), wf12(:,24), n3(:,108), t3x12(:,:,16))
  call vert_ZQ_A(gZu,ntry, ex4(:), wf6(:,62), wf18(:,21), n3(:,109), t3x18(:,:,17))
  call vert_WQ_A(ntry, wf9(:,4), ex1(:), wf18(:,22), n3(:,110), t3x18(:,:,18))
  call vert_VQ_A(ntry, ex5(:), wf2(:,11), wf4(:,21), n3(:,111), t3x4(:,:,14))
  call vert_AW_Q(ntry, wf6(:,8), wf3(:,1), wf18(:,23), n3(:,112), t3x18(:,:,19))
  call prop_Q_A(ntry, wf4(:,21), 17, ZERO, 0_intkind1, wf4(:,22), n2(56))
  call vert_WQ_A(ntry, wf3(:,1), wf2(:,11), wf6(:,63), n3(:,113), t3x6(:,:,47))
  call vert_UV_W(ntry, wf3(:,1), 8, ex3(:), 4, wf9(:,5), n3(:,114), t3x9(:,:,5))
  call vert_QA_W(ntry, wf2(:,11), wf4(:,2), wf8(:,6), n3(:,115), t3x8(:,:,6))
  call vert_ZQ_A(gZu,ntry, ex3(:), wf2(:,11), wf6(:,64), n3(:,116), t3x6(:,:,48))
  call vert_AW_Q(ntry, wf4(:,2), wf3(:,1), wf12(:,25), n3(:,117), t3x12(:,:,17))
  call prop_Q_A(ntry, wf6(:,64), 5, ZERO, 0_intkind1, wf6(:,65), n2(57))
  call vert_AW_Q(ntry, ex2(:), wf3(:,1), wf6(:,66), n3(:,118), t3x6(:,:,49))
  call prop_A_Q(ntry, wf6(:,66), 10, ZERO, 0_intkind1, wf6(:,67), n2(58))
  call vert_AV_Q(ntry, wf6(:,67), ex5(:), wf12(:,26), n3(:,119), t3x12(:,:,18))
  call vert_AZ_Q(gZu,ntry, wf6(:,67), ex3(:), wf18(:,24), n3(:,120), t3x18(:,:,20))
  call vert_AW_Q(ntry, ex2(:), wf9(:,5), wf18(:,25), n3(:,121), t3x18(:,:,21))
  call vert_AW_Q(ntry, wf6(:,4), wf3(:,5), wf18(:,26), n3(:,122), t3x18(:,:,22))
  call vert_WQ_A(ntry, wf3(:,5), wf2(:,11), wf6(:,68), n3(:,123), t3x6(:,:,50))
  call vert_UV_W(ntry, wf3(:,5), 4, ex4(:), 8, wf9(:,6), n3(:,124), t3x9(:,:,6))
  call vert_ZQ_A(gZu,ntry, ex4(:), wf2(:,11), wf6(:,69), n3(:,125), t3x6(:,:,51))
  call vert_AW_Q(ntry, wf4(:,2), wf3(:,5), wf12(:,27), n3(:,126), t3x12(:,:,19))
  call prop_Q_A(ntry, wf6(:,69), 9, ZERO, 0_intkind1, wf6(:,70), n2(59))
  call vert_AW_Q(ntry, ex2(:), wf3(:,5), wf6(:,71), n3(:,127), t3x6(:,:,52))
  call prop_A_Q(ntry, wf6(:,71), 6, ZERO, 0_intkind1, wf6(:,72), n2(60))
  call vert_AV_Q(ntry, wf6(:,72), ex5(:), wf12(:,28), n3(:,128), t3x12(:,:,20))
  call vert_AZ_Q(gZu,ntry, wf6(:,72), ex4(:), wf18(:,27), n3(:,129), t3x18(:,:,23))
  call vert_AW_Q(ntry, ex2(:), wf9(:,6), wf18(:,28), n3(:,130), t3x18(:,:,24))
  call vert_AV_Q(ntry, wf6(:,55), ex5(:), wf12(:,29), n3(:,131), t3x12(:,:,21))
  call vert_AZ_Q(gZu,ntry, wf6(:,55), ex4(:), wf18(:,29), n3(:,132), t3x18(:,:,25))
  call vert_VQ_A(ntry, ex5(:), wf6(:,65), wf12(:,30), n3(:,133), t3x12(:,:,22))
  call vert_AZ_Q(gZu,ntry, wf6(:,60), ex3(:), wf18(:,30), n3(:,134), t3x18(:,:,26))
  call vert_ZQ_A(gZu,ntry, ex4(:), wf6(:,65), wf18(:,31), n3(:,135), t3x18(:,:,27))
  call vert_ZQ_A(gZu,ntry, ex3(:), wf6(:,70), wf18(:,32), n3(:,136), t3x18(:,:,28))
  call counter_Q_A_LR(EWctdd,ntry, wf4(:,4), 17, wf4(:,23), n2(61))
  call counter_A_Q_LR(EWctdd,ntry, wf6(:,4), 10, wf6(:,73), n2(62))
  call counter_A_Q_LR(EWctdd,ntry, wf6(:,8), 6, wf6(:,74), n2(63))
  call counter_Q_A_LR(EWctdd,ntry, wf6(:,7), 9, wf6(:,75), n2(64))
  call counter_A_Q_LR(EWctdd,ntry, wf4(:,2), 18, wf4(:,24), n2(65))
  call counter_Q_A_LR(EWctdd,ntry, wf6(:,3), 5, wf6(:,76), n2(66))
  call counter_VQ_A_LR(EWctGdd,ntry, ex5(:), wf6(:,3), wf12(:,31), n3(:,137), t3x12(:,:,23))
  call counter_ZQ_A(EWctVdd,ntry, ex4(:), wf6(:,3), wf18(:,33), n3(:,138), t3x18(:,:,29))
  call counter_VQ_A_LR(EWctGdd,ntry, ex5(:), wf6(:,7), wf12(:,32), n3(:,139), t3x12(:,:,24))
  call counter_ZQ_A(EWctVdd,ntry, ex4(:), wf4(:,4), wf12(:,33), n3(:,140), t3x12(:,:,25))
  call counter_ZQ_A(EWctVdd,ntry, ex3(:), wf6(:,7), wf18(:,34), n3(:,141), t3x18(:,:,30))
  call counter_ZQ_A(EWctVdd,ntry, ex3(:), wf4(:,4), wf12(:,34), n3(:,142), t3x12(:,:,26))
  call counter_AV_Q_LR(EWctGdd,ntry, ex2(:), ex5(:), wf4(:,25), n3(:,143), t3x4(:,:,15))
  call prop_A_Q(ntry, wf4(:,25), 18, ZERO, 0_intkind1, wf4(:,26), n2(67))
  call counter_AZ_Q(EWctVdd,ntry, ex2(:), ex4(:), wf6(:,77), n3(:,144), t3x6(:,:,53))
  call prop_A_Q(ntry, wf6(:,77), 10, ZERO, 0_intkind1, wf6(:,78), n2(68))
  call counter_AZ_Q(EWctVdd,ntry, ex2(:), ex3(:), wf6(:,79), n3(:,145), t3x6(:,:,54))
  call prop_A_Q(ntry, wf6(:,79), 6, ZERO, 0_intkind1, wf6(:,80), n2(69))
  call counter_VQ_A_LR(EWctGdd,ntry, ex5(:), ex1(:), wf4(:,27), n3(:,146), t3x4(:,:,16))
  call prop_Q_A(ntry, wf4(:,27), 17, ZERO, 0_intkind1, wf4(:,28), n2(70))
  call vert_ZQ_A(gZd,ntry, ex4(:), wf4(:,28), wf12(:,35), n3(:,147), t3x12(:,:,27))
  call counter_ZQ_A(EWctVdd,ntry, ex4(:), ex1(:), wf6(:,81), n3(:,148), t3x6(:,:,55))
  call prop_Q_A(ntry, wf6(:,81), 9, ZERO, 0_intkind1, wf6(:,82), n2(71))
  call vert_VQ_A(ntry, ex5(:), wf6(:,82), wf12(:,36), n3(:,149), t3x12(:,:,28))
  call vert_ZQ_A(gZd,ntry, ex3(:), wf4(:,28), wf12(:,37), n3(:,150), t3x12(:,:,29))
  call vert_ZQ_A(gZd,ntry, ex3(:), wf6(:,82), wf18(:,35), n3(:,151), t3x18(:,:,31))
  call counter_ZQ_A(EWctVdd,ntry, ex3(:), ex1(:), wf6(:,83), n3(:,152), t3x6(:,:,56))
  call prop_Q_A(ntry, wf6(:,83), 5, ZERO, 0_intkind1, wf6(:,84), n2(72))
  call vert_VQ_A(ntry, ex5(:), wf6(:,84), wf12(:,38), n3(:,153), t3x12(:,:,30))
  call vert_ZQ_A(gZd,ntry, ex4(:), wf6(:,84), wf18(:,36), n3(:,154), t3x18(:,:,32))
  call prop_Q_A(ntry, wf6(:,12), 5, ZERO, 0_intkind1, wf6(:,85), n2(73))
  call prop_A_Q(ntry, wf6(:,9), 10, ZERO, 0_intkind1, wf6(:,86), n2(74))
  call vert_VQ_A(ntry, ex5(:), wf6(:,85), wf12(:,39), n3(:,155), t3x12(:,:,31))
  call prop_A_Q(ntry, wf4(:,5), 18, ZERO, 0_intkind1, wf4(:,29), n2(75))
  call vert_ZQ_A(gZd,ntry, ex4(:), wf6(:,85), wf18(:,37), n3(:,156), t3x18(:,:,33))
  call prop_A_Q(ntry, wf6(:,10), 6, ZERO, 0_intkind1, wf6(:,87), n2(76))
  call prop_Q_A(ntry, wf6(:,11), 9, ZERO, 0_intkind1, wf6(:,88), n2(77))
  call vert_AV_Q(ntry, wf6(:,87), ex5(:), wf12(:,40), n3(:,157), t3x12(:,:,32))
  call vert_ZQ_A(gZd,ntry, ex3(:), wf6(:,88), wf18(:,38), n3(:,158), t3x18(:,:,34))
  call prop_Q_A(ntry, wf4(:,6), 17, ZERO, 0_intkind1, wf4(:,30), n2(78))
  call vert_AZ_Q(gZd,ntry, wf6(:,87), ex4(:), wf18(:,39), n3(:,159), t3x18(:,:,35))
  call vert_AZ_Q(gZd,ntry, wf6(:,86), ex3(:), wf18(:,40), n3(:,160), t3x18(:,:,36))
  call counter_A_Q_LR_EWs([cONE,cONE],ntry, wf2(:,2), 2, wf2(:,13), n2(79))
  call prop_Q_A(ntry, wf12(:,18), 21, ZERO, 0_intkind1, wf12(:,41), n2(80))
  call vert_AZ_Q(gZd,ntry, wf2(:,13), ex4(:), wf6(:,89), n3(:,161), t3x6(:,:,57))
  call prop_Q_A(ntry, wf18(:,11), 13, ZERO, 0_intkind1, wf18(:,41), n2(81))
  call vert_AV_Q(ntry, wf2(:,13), ex5(:), wf4(:,31), n3(:,162), t3x4(:,:,17))
  call vert_VQ_A(ntry, ex5(:), wf6(:,40), wf12(:,42), n3(:,163), t3x12(:,:,33))
  call prop_Q_A(ntry, wf12(:,42), 25, ZERO, 0_intkind1, wf12(:,43), n2(82))
  call vert_AZ_Q(gZd,ntry, wf2(:,13), ex3(:), wf6(:,90), n3(:,164), t3x6(:,:,58))
  call prop_Q_A(ntry, wf18(:,12), 13, ZERO, 0_intkind1, wf18(:,42), n2(83))
  call vert_ZQ_A(gZd,ntry, ex4(:), wf4(:,12), wf12(:,44), n3(:,165), t3x12(:,:,34))
  call prop_Q_A(ntry, wf12(:,44), 25, ZERO, 0_intkind1, wf12(:,45), n2(84))
  call vert_ZQ_A(gZd,ntry, ex3(:), wf4(:,12), wf12(:,46), n3(:,166), t3x12(:,:,35))
  call prop_Q_A(ntry, wf12(:,46), 21, ZERO, 0_intkind1, wf12(:,47), n2(85))
  call counter_Q_A_LR_EWs([cONE,cONE],ntry, wf2(:,4), 1, wf2(:,14), n2(86))
  call prop_A_Q(ntry, wf12(:,17), 22, ZERO, 0_intkind1, wf12(:,48), n2(87))
  call vert_ZQ_A(gZd,ntry, ex4(:), wf2(:,14), wf6(:,91), n3(:,167), t3x6(:,:,59))
  call prop_A_Q(ntry, wf18(:,9), 14, ZERO, 0_intkind1, wf18(:,43), n2(88))
  call vert_VQ_A(ntry, ex5(:), wf2(:,14), wf4(:,32), n3(:,168), t3x4(:,:,18))
  call vert_AV_Q(ntry, wf6(:,44), ex5(:), wf12(:,49), n3(:,169), t3x12(:,:,36))
  call prop_A_Q(ntry, wf12(:,49), 26, ZERO, 0_intkind1, wf12(:,50), n2(89))
  call vert_ZQ_A(gZd,ntry, ex3(:), wf2(:,14), wf6(:,92), n3(:,170), t3x6(:,:,60))
  call prop_A_Q(ntry, wf18(:,10), 14, ZERO, 0_intkind1, wf18(:,44), n2(90))
  call vert_AZ_Q(gZd,ntry, wf4(:,14), ex4(:), wf12(:,51), n3(:,171), t3x12(:,:,37))
  call prop_A_Q(ntry, wf12(:,51), 26, ZERO, 0_intkind1, wf12(:,52), n2(91))
  call vert_AZ_Q(gZd,ntry, wf4(:,14), ex3(:), wf12(:,53), n3(:,172), t3x12(:,:,38))
  call prop_A_Q(ntry, wf12(:,53), 22, ZERO, 0_intkind1, wf12(:,54), n2(92))
  call prop_Q_A(ntry, wf6(:,16), 5, ZERO, 0_intkind1, wf6(:,93), n2(93))
  call prop_A_Q(ntry, wf6(:,13), 10, ZERO, 0_intkind1, wf6(:,94), n2(94))
  call vert_VQ_A(ntry, ex5(:), wf6(:,93), wf12(:,55), n3(:,173), t3x12(:,:,39))
  call prop_A_Q(ntry, wf4(:,7), 18, ZERO, 0_intkind1, wf4(:,33), n2(95))
  call vert_ZQ_A(gZd,ntry, ex4(:), wf6(:,93), wf18(:,45), n3(:,174), t3x18(:,:,37))
  call prop_A_Q(ntry, wf6(:,14), 6, ZERO, 0_intkind1, wf6(:,95), n2(96))
  call prop_Q_A(ntry, wf6(:,15), 9, ZERO, 0_intkind1, wf6(:,96), n2(97))
  call vert_AV_Q(ntry, wf6(:,95), ex5(:), wf12(:,56), n3(:,175), t3x12(:,:,40))
  call vert_ZQ_A(gZd,ntry, ex3(:), wf6(:,96), wf18(:,46), n3(:,176), t3x18(:,:,38))
  call prop_Q_A(ntry, wf4(:,8), 17, ZERO, 0_intkind1, wf4(:,34), n2(98))
  call vert_AZ_Q(gZd,ntry, wf6(:,95), ex4(:), wf18(:,47), n3(:,177), t3x18(:,:,39))
  call vert_AZ_Q(gZd,ntry, wf6(:,94), ex3(:), wf18(:,48), n3(:,178), t3x18(:,:,40))
  call counter_A_Q_LR_EWs(gZd,ntry, wf2(:,6), 2, wf2(:,15), n2(99))
  call prop_Q_A(ntry, wf12(:,20), 21, ZERO, 0_intkind1, wf12(:,57), n2(100))
  call vert_AZ_Q(gZd,ntry, wf2(:,15), ex4(:), wf6(:,97), n3(:,179), t3x6(:,:,61))
  call prop_Q_A(ntry, wf18(:,15), 13, ZERO, 0_intkind1, wf18(:,49), n2(101))
  call vert_AV_Q(ntry, wf2(:,15), ex5(:), wf4(:,35), n3(:,180), t3x4(:,:,19))
  call vert_VQ_A(ntry, ex5(:), wf6(:,48), wf12(:,58), n3(:,181), t3x12(:,:,41))
  call prop_Q_A(ntry, wf12(:,58), 25, ZERO, 0_intkind1, wf12(:,59), n2(102))
  call vert_AZ_Q(gZd,ntry, wf2(:,15), ex3(:), wf6(:,98), n3(:,182), t3x6(:,:,62))
  call prop_Q_A(ntry, wf18(:,16), 13, ZERO, 0_intkind1, wf18(:,50), n2(103))
  call vert_ZQ_A(gZd,ntry, ex4(:), wf4(:,16), wf12(:,60), n3(:,183), t3x12(:,:,42))
  call prop_Q_A(ntry, wf12(:,60), 25, ZERO, 0_intkind1, wf12(:,61), n2(104))
  call vert_ZQ_A(gZd,ntry, ex3(:), wf4(:,16), wf12(:,62), n3(:,184), t3x12(:,:,43))
  call prop_Q_A(ntry, wf12(:,62), 21, ZERO, 0_intkind1, wf12(:,63), n2(105))
  call counter_Q_A_LR_EWs(gZd,ntry, wf2(:,8), 1, wf2(:,16), n2(106))
  call prop_A_Q(ntry, wf12(:,19), 22, ZERO, 0_intkind1, wf12(:,64), n2(107))
  call vert_ZQ_A(gZd,ntry, ex4(:), wf2(:,16), wf6(:,99), n3(:,185), t3x6(:,:,63))
  call prop_A_Q(ntry, wf18(:,13), 14, ZERO, 0_intkind1, wf18(:,51), n2(108))
  call vert_VQ_A(ntry, ex5(:), wf2(:,16), wf4(:,36), n3(:,186), t3x4(:,:,20))
  call vert_AV_Q(ntry, wf6(:,52), ex5(:), wf12(:,65), n3(:,187), t3x12(:,:,44))
  call prop_A_Q(ntry, wf12(:,65), 26, ZERO, 0_intkind1, wf12(:,66), n2(109))
  call vert_ZQ_A(gZd,ntry, ex3(:), wf2(:,16), wf6(:,100), n3(:,188), t3x6(:,:,64))
  call prop_A_Q(ntry, wf18(:,14), 14, ZERO, 0_intkind1, wf18(:,52), n2(110))
  call vert_AZ_Q(gZd,ntry, wf4(:,18), ex4(:), wf12(:,67), n3(:,189), t3x12(:,:,45))
  call prop_A_Q(ntry, wf12(:,67), 26, ZERO, 0_intkind1, wf12(:,68), n2(111))
  call vert_AZ_Q(gZd,ntry, wf4(:,18), ex3(:), wf12(:,69), n3(:,190), t3x12(:,:,46))
  call prop_A_Q(ntry, wf12(:,69), 22, ZERO, 0_intkind1, wf12(:,70), n2(112))
  call prop_A_Q(ntry, wf6(:,58), 6, ZERO, 0_intkind1, wf6(:,101), n2(113))
  call vert_WQ_A(ntry, wf3(:,1), wf4(:,22), wf12(:,71), n3(:,191), t3x12(:,:,47))
  call prop_A_Q(ntry, wf6(:,53), 10, ZERO, 0_intkind1, wf6(:,102), n2(114))
  call vert_WQ_A(ntry, wf3(:,5), wf4(:,22), wf12(:,72), n3(:,192), t3x12(:,:,48))
  call vert_QA_V(ntry, wf4(:,22), wf2(:,9), wf8(:,7), n3(:,193), t3x8(:,:,7))
  call vert_QA_Z(gZu,ntry, wf4(:,22), wf2(:,9), wf8(:,8), n3(:,194), t3x8(:,:,8))
  call prop_Q_A(ntry, wf6(:,68), 5, ZERO, 0_intkind1, wf6(:,103), n2(115))
  call vert_AW_Q(ntry, wf4(:,20), wf3(:,3), wf12(:,73), n3(:,195), t3x12(:,:,49))
  call prop_Q_A(ntry, wf6(:,63), 9, ZERO, 0_intkind1, wf6(:,104), n2(116))
  call vert_AW_Q(ntry, wf4(:,20), wf3(:,7), wf12(:,74), n3(:,196), t3x12(:,:,50))
  call vert_QA_V(ntry, wf2(:,11), wf4(:,20), wf8(:,9), n3(:,197), t3x8(:,:,9))
  call vert_QA_Z(gZu,ntry, wf2(:,11), wf4(:,20), wf8(:,10), n3(:,198), t3x8(:,:,10))
  call vert_VQ_A(ntry, ex5(:), wf6(:,103), wf12(:,75), n3(:,199), t3x12(:,:,51))
  call vert_VQ_A(ntry, ex5(:), wf6(:,104), wf12(:,76), n3(:,200), t3x12(:,:,52))
  call vert_VQ_A(ntry, wf3(:,4), wf4(:,4), wf12(:,77), n3(:,201), t3x12(:,:,53))
  call vert_VQ_A(ntry, wf3(:,2), wf4(:,4), wf12(:,78), n3(:,202), t3x12(:,:,54))
  call vert_ZQ_A(gZd,ntry, wf3(:,4), wf4(:,4), wf12(:,79), n3(:,203), t3x12(:,:,55))
  call vert_ZQ_A(gZd,ntry, wf3(:,2), wf4(:,4), wf12(:,80), n3(:,204), t3x12(:,:,56))
  call prop_Q_A(ntry, wf12(:,23), 21, ZERO, 0_intkind1, wf12(:,81), n2(117))
  call vert_AV_Q(ntry, wf2(:,9), wf3(:,4), wf6(:,105), n3(:,205), t3x6(:,:,65))
  call vert_AV_Q(ntry, wf2(:,9), wf3(:,2), wf6(:,106), n3(:,206), t3x6(:,:,66))
  call vert_AZ_Q(gZu,ntry, wf2(:,9), wf3(:,4), wf6(:,107), n3(:,207), t3x6(:,:,67))
  call vert_AZ_Q(gZu,ntry, wf2(:,9), wf3(:,2), wf6(:,108), n3(:,208), t3x6(:,:,68))
  call vert_UV_W(ntry, wf3(:,4), 8, wf3(:,7), 4, wf9(:,7), n3(:,209), t3x9(:,:,7))
  call vert_UV_W(ntry, wf3(:,2), 8, wf3(:,7), 4, wf9(:,8), n3(:,210), t3x9(:,:,8))
  call vert_VQ_A(ntry, wf3(:,8), wf4(:,4), wf12(:,82), n3(:,211), t3x12(:,:,57))
  call vert_VQ_A(ntry, wf3(:,6), wf4(:,4), wf12(:,83), n3(:,212), t3x12(:,:,58))
  call vert_ZQ_A(gZd,ntry, wf3(:,8), wf4(:,4), wf12(:,84), n3(:,213), t3x12(:,:,59))
  call vert_ZQ_A(gZd,ntry, wf3(:,6), wf4(:,4), wf12(:,85), n3(:,214), t3x12(:,:,60))
  call prop_Q_A(ntry, wf12(:,21), 25, ZERO, 0_intkind1, wf12(:,86), n2(118))
  call vert_AV_Q(ntry, wf2(:,9), wf3(:,8), wf6(:,109), n3(:,215), t3x6(:,:,69))
  call vert_AV_Q(ntry, wf2(:,9), wf3(:,6), wf6(:,110), n3(:,216), t3x6(:,:,70))
  call vert_AZ_Q(gZu,ntry, wf2(:,9), wf3(:,8), wf6(:,111), n3(:,217), t3x6(:,:,71))
  call vert_AZ_Q(gZu,ntry, wf2(:,9), wf3(:,6), wf6(:,112), n3(:,218), t3x6(:,:,72))
  call vert_UV_W(ntry, wf3(:,8), 4, wf3(:,3), 8, wf9(:,9), n3(:,219), t3x9(:,:,9))
  call vert_UV_W(ntry, wf3(:,6), 4, wf3(:,3), 8, wf9(:,10), n3(:,220), t3x9(:,:,10))
  call vert_QA_V(ntry, wf4(:,4), wf2(:,10), wf8(:,11), n3(:,221), t3x8(:,:,11))
  call vert_QA_Z(gZd,ntry, wf4(:,4), wf2(:,10), wf8(:,12), n3(:,222), t3x8(:,:,12))
  call vert_AW_Q(ntry, wf2(:,10), wf3(:,5), wf6(:,113), n3(:,223), t3x6(:,:,73))
  call vert_AW_Q(ntry, wf2(:,10), wf3(:,1), wf6(:,114), n3(:,224), t3x6(:,:,74))
  call vert_VQ_A(ntry, wf3(:,4), wf6(:,62), wf18(:,53), n3(:,225), t3x18(:,:,41))
  call vert_VQ_A(ntry, wf3(:,2), wf6(:,62), wf18(:,54), n3(:,226), t3x18(:,:,42))
  call vert_ZQ_A(gZu,ntry, wf3(:,4), wf6(:,62), wf18(:,55), n3(:,227), t3x18(:,:,43))
  call vert_ZQ_A(gZu,ntry, wf3(:,2), wf6(:,62), wf18(:,56), n3(:,228), t3x18(:,:,44))
  call prop_Q_A(ntry, wf6(:,22), 9, ZERO, 0_intkind1, wf6(:,115), n2(119))
  call prop_Q_A(ntry, wf6(:,21), 9, ZERO, 0_intkind1, wf6(:,116), n2(120))
  call prop_Q_A(ntry, wf6(:,24), 9, ZERO, 0_intkind1, wf6(:,117), n2(121))
  call prop_Q_A(ntry, wf6(:,23), 9, ZERO, 0_intkind1, wf6(:,118), n2(122))
  call vert_QA_W(ntry, ex1(:), wf4(:,20), wf8(:,13), n3(:,229), t3x8(:,:,13))
  call vert_VQ_A(ntry, wf3(:,8), wf6(:,57), wf18(:,57), n3(:,230), t3x18(:,:,45))
  call vert_VQ_A(ntry, wf3(:,6), wf6(:,57), wf18(:,58), n3(:,231), t3x18(:,:,46))
  call vert_ZQ_A(gZu,ntry, wf3(:,8), wf6(:,57), wf18(:,59), n3(:,232), t3x18(:,:,47))
  call vert_ZQ_A(gZu,ntry, wf3(:,6), wf6(:,57), wf18(:,60), n3(:,233), t3x18(:,:,48))
  call prop_Q_A(ntry, wf6(:,30), 5, ZERO, 0_intkind1, wf6(:,119), n2(123))
  call prop_Q_A(ntry, wf6(:,29), 5, ZERO, 0_intkind1, wf6(:,120), n2(124))
  call prop_Q_A(ntry, wf6(:,32), 5, ZERO, 0_intkind1, wf6(:,121), n2(125))
  call prop_Q_A(ntry, wf6(:,31), 5, ZERO, 0_intkind1, wf6(:,122), n2(126))
  call prop_Q_A(ntry, wf12(:,24), 21, ZERO, 0_intkind1, wf12(:,87), n2(127))
  call vert_AV_Q(ntry, wf6(:,101), ex5(:), wf12(:,88), n3(:,234), t3x12(:,:,61))
  call prop_Q_A(ntry, wf12(:,22), 25, ZERO, 0_intkind1, wf12(:,89), n2(128))
  call vert_AV_Q(ntry, wf6(:,102), ex5(:), wf12(:,90), n3(:,235), t3x12(:,:,62))
  call vert_WQ_A(ntry, wf3(:,1), wf6(:,62), wf18(:,61), n3(:,236), t3x18(:,:,49))
  call prop_A_Q(ntry, wf4(:,9), 18, ZERO, 0_intkind1, wf4(:,37), n2(129))
  call vert_WQ_A(ntry, wf3(:,5), wf6(:,57), wf18(:,62), n3(:,237), t3x18(:,:,50))
  call vert_VQ_A(ntry, wf9(:,2), ex1(:), wf18(:,63), n3(:,238), t3x18(:,:,51))
  call prop_Q_A(ntry, wf18(:,63), 13, ZERO, 0_intkind1, wf18(:,64), n2(130))
  call vert_VQ_A(ntry, wf9(:,1), ex1(:), wf18(:,65), n3(:,239), t3x18(:,:,52))
  call prop_Q_A(ntry, wf18(:,65), 13, ZERO, 0_intkind1, wf18(:,66), n2(131))
  call vert_ZQ_A(gZd,ntry, wf9(:,2), ex1(:), wf18(:,67), n3(:,240), t3x18(:,:,53))
  call prop_Q_A(ntry, wf18(:,67), 13, ZERO, 0_intkind1, wf18(:,68), n2(132))
  call vert_ZQ_A(gZd,ntry, wf9(:,1), ex1(:), wf18(:,69), n3(:,241), t3x18(:,:,54))
  call prop_Q_A(ntry, wf18(:,69), 13, ZERO, 0_intkind1, wf18(:,70), n2(133))
  call vert_AV_Q(ntry, wf4(:,2), wf3(:,4), wf12(:,91), n3(:,242), t3x12(:,:,63))
  call vert_AV_Q(ntry, wf4(:,2), wf3(:,2), wf12(:,92), n3(:,243), t3x12(:,:,64))
  call vert_AZ_Q(gZd,ntry, wf4(:,2), wf3(:,4), wf12(:,93), n3(:,244), t3x12(:,:,65))
  call vert_AZ_Q(gZd,ntry, wf4(:,2), wf3(:,2), wf12(:,94), n3(:,245), t3x12(:,:,66))
  call prop_A_Q(ntry, wf12(:,27), 22, ZERO, 0_intkind1, wf12(:,95), n2(134))
  call vert_VQ_A(ntry, wf3(:,4), wf2(:,11), wf6(:,123), n3(:,246), t3x6(:,:,75))
  call vert_VQ_A(ntry, wf3(:,2), wf2(:,11), wf6(:,124), n3(:,247), t3x6(:,:,76))
  call vert_ZQ_A(gZu,ntry, wf3(:,4), wf2(:,11), wf6(:,125), n3(:,248), t3x6(:,:,77))
  call vert_ZQ_A(gZu,ntry, wf3(:,2), wf2(:,11), wf6(:,126), n3(:,249), t3x6(:,:,78))
  call vert_UV_W(ntry, wf3(:,5), 4, wf3(:,4), 8, wf9(:,11), n3(:,250), t3x9(:,:,11))
  call vert_UV_W(ntry, wf3(:,5), 4, wf3(:,2), 8, wf9(:,12), n3(:,251), t3x9(:,:,12))
  call vert_AV_Q(ntry, wf4(:,2), wf3(:,8), wf12(:,96), n3(:,252), t3x12(:,:,67))
  call vert_AV_Q(ntry, wf4(:,2), wf3(:,6), wf12(:,97), n3(:,253), t3x12(:,:,68))
  call vert_AZ_Q(gZd,ntry, wf4(:,2), wf3(:,8), wf12(:,98), n3(:,254), t3x12(:,:,69))
  call vert_AZ_Q(gZd,ntry, wf4(:,2), wf3(:,6), wf12(:,99), n3(:,255), t3x12(:,:,70))
  call prop_A_Q(ntry, wf12(:,25), 26, ZERO, 0_intkind1, wf12(:,100), n2(135))
  call vert_VQ_A(ntry, wf3(:,8), wf2(:,11), wf6(:,127), n3(:,256), t3x6(:,:,79))
  call vert_VQ_A(ntry, wf3(:,6), wf2(:,11), wf6(:,128), n3(:,257), t3x6(:,:,80))
  call vert_ZQ_A(gZu,ntry, wf3(:,8), wf2(:,11), wf6(:,129), n3(:,258), t3x6(:,:,81))
  call vert_ZQ_A(gZu,ntry, wf3(:,6), wf2(:,11), wf6(:,130), n3(:,259), t3x6(:,:,82))
  call vert_UV_W(ntry, wf3(:,1), 8, wf3(:,8), 4, wf9(:,13), n3(:,260), t3x9(:,:,13))
  call vert_UV_W(ntry, wf3(:,1), 8, wf3(:,6), 4, wf9(:,14), n3(:,261), t3x9(:,:,14))
  call vert_QA_V(ntry, wf2(:,12), wf4(:,2), wf8(:,14), n3(:,262), t3x8(:,:,14))
  call vert_QA_Z(gZd,ntry, wf2(:,12), wf4(:,2), wf8(:,15), n3(:,263), t3x8(:,:,15))
  call vert_WQ_A(ntry, wf3(:,7), wf2(:,12), wf6(:,131), n3(:,264), t3x6(:,:,83))
  call vert_WQ_A(ntry, wf3(:,3), wf2(:,12), wf6(:,132), n3(:,265), t3x6(:,:,84))
  call vert_AV_Q(ntry, wf6(:,72), wf3(:,4), wf18(:,71), n3(:,266), t3x18(:,:,55))
  call vert_AV_Q(ntry, wf6(:,72), wf3(:,2), wf18(:,72), n3(:,267), t3x18(:,:,56))
  call vert_AZ_Q(gZu,ntry, wf6(:,72), wf3(:,4), wf18(:,73), n3(:,268), t3x18(:,:,57))
  call vert_AZ_Q(gZu,ntry, wf6(:,72), wf3(:,2), wf18(:,74), n3(:,269), t3x18(:,:,58))
  call prop_A_Q(ntry, wf6(:,18), 10, ZERO, 0_intkind1, wf6(:,133), n2(136))
  call prop_A_Q(ntry, wf6(:,17), 10, ZERO, 0_intkind1, wf6(:,134), n2(137))
  call prop_A_Q(ntry, wf6(:,20), 10, ZERO, 0_intkind1, wf6(:,135), n2(138))
  call prop_A_Q(ntry, wf6(:,19), 10, ZERO, 0_intkind1, wf6(:,136), n2(139))
  call vert_QA_W(ntry, wf4(:,22), ex2(:), wf8(:,16), n3(:,270), t3x8(:,:,16))
  call vert_AV_Q(ntry, wf6(:,67), wf3(:,8), wf18(:,75), n3(:,271), t3x18(:,:,59))
  call vert_AV_Q(ntry, wf6(:,67), wf3(:,6), wf18(:,76), n3(:,272), t3x18(:,:,60))
  call vert_AZ_Q(gZu,ntry, wf6(:,67), wf3(:,8), wf18(:,77), n3(:,273), t3x18(:,:,61))
  call vert_AZ_Q(gZu,ntry, wf6(:,67), wf3(:,6), wf18(:,78), n3(:,274), t3x18(:,:,62))
  call prop_A_Q(ntry, wf6(:,26), 6, ZERO, 0_intkind1, wf6(:,137), n2(140))
  call prop_A_Q(ntry, wf6(:,25), 6, ZERO, 0_intkind1, wf6(:,138), n2(141))
  call prop_A_Q(ntry, wf6(:,28), 6, ZERO, 0_intkind1, wf6(:,139), n2(142))
  call prop_A_Q(ntry, wf6(:,27), 6, ZERO, 0_intkind1, wf6(:,140), n2(143))
  call prop_A_Q(ntry, wf12(:,28), 22, ZERO, 0_intkind1, wf12(:,101), n2(144))
  call prop_A_Q(ntry, wf12(:,26), 26, ZERO, 0_intkind1, wf12(:,102), n2(145))
  call vert_AW_Q(ntry, wf6(:,72), wf3(:,3), wf18(:,79), n3(:,275), t3x18(:,:,63))
  call prop_Q_A(ntry, wf4(:,10), 17, ZERO, 0_intkind1, wf4(:,38), n2(146))
  call vert_AW_Q(ntry, wf6(:,67), wf3(:,7), wf18(:,80), n3(:,276), t3x18(:,:,64))
  call vert_AV_Q(ntry, ex2(:), wf9(:,2), wf18(:,81), n3(:,277), t3x18(:,:,65))
  call prop_A_Q(ntry, wf18(:,81), 14, ZERO, 0_intkind1, wf18(:,82), n2(147))
  call vert_AV_Q(ntry, ex2(:), wf9(:,1), wf18(:,83), n3(:,278), t3x18(:,:,66))
  call prop_A_Q(ntry, wf18(:,83), 14, ZERO, 0_intkind1, wf18(:,84), n2(148))
  call vert_AZ_Q(gZd,ntry, ex2(:), wf9(:,2), wf18(:,85), n3(:,279), t3x18(:,:,67))
  call prop_A_Q(ntry, wf18(:,85), 14, ZERO, 0_intkind1, wf18(:,86), n2(149))
  call vert_AZ_Q(gZd,ntry, ex2(:), wf9(:,1), wf18(:,87), n3(:,280), t3x18(:,:,68))
  call prop_A_Q(ntry, wf18(:,87), 14, ZERO, 0_intkind1, wf18(:,88), n2(150))
  call vert_VQ_A(ntry, wf3(:,4), wf6(:,65), wf18(:,89), n3(:,281), t3x18(:,:,69))
  call vert_VQ_A(ntry, wf3(:,2), wf6(:,65), wf18(:,90), n3(:,282), t3x18(:,:,70))
  call vert_ZQ_A(gZu,ntry, wf3(:,4), wf6(:,65), wf18(:,91), n3(:,283), t3x18(:,:,71))
  call vert_ZQ_A(gZu,ntry, wf3(:,2), wf6(:,65), wf18(:,92), n3(:,284), t3x18(:,:,72))
  call prop_Q_A(ntry, wf12(:,30), 21, ZERO, 0_intkind1, wf12(:,103), n2(151))
  call vert_WQ_A(ntry, wf3(:,1), wf6(:,65), wf18(:,93), n3(:,285), t3x18(:,:,73))
  call vert_AV_Q(ntry, wf6(:,55), wf3(:,4), wf18(:,94), n3(:,286), t3x18(:,:,74))
  call vert_AV_Q(ntry, wf6(:,55), wf3(:,2), wf18(:,95), n3(:,287), t3x18(:,:,75))
  call vert_AZ_Q(gZu,ntry, wf6(:,55), wf3(:,4), wf18(:,96), n3(:,288), t3x18(:,:,76))
  call vert_AZ_Q(gZu,ntry, wf6(:,55), wf3(:,2), wf18(:,97), n3(:,289), t3x18(:,:,77))
  call vert_ZQ_A(gZu,ntry, ex3(:), wf4(:,22), wf12(:,104), n3(:,290), t3x12(:,:,71))
  call prop_Q_A(ntry, wf12(:,104), 21, ZERO, 0_intkind1, wf12(:,105), n2(152))
  call vert_AW_Q(ntry, wf2(:,10), wf9(:,5), wf18(:,98), n3(:,291), t3x18(:,:,78))
  call prop_A_Q(ntry, wf6(:,34), 6, ZERO, 0_intkind1, wf6(:,141), n2(153))
  call prop_A_Q(ntry, wf12(:,29), 22, ZERO, 0_intkind1, wf12(:,106), n2(154))
  call vert_AZ_Q(gZu,ntry, wf4(:,20), ex3(:), wf12(:,107), n3(:,292), t3x12(:,:,72))
  call prop_A_Q(ntry, wf12(:,107), 22, ZERO, 0_intkind1, wf12(:,108), n2(155))
  call vert_WQ_A(ntry, wf9(:,5), wf2(:,11), wf18(:,99), n3(:,293), t3x18(:,:,79))
  call vert_ZQ_A(gZd,ntry, ex3(:), wf6(:,104), wf18(:,100), n3(:,294), t3x18(:,:,80))
  call prop_Q_A(ntry, wf18(:,100), 13, ZERO, 0_intkind1, wf18(:,101), n2(156))
  call vert_AW_Q(ntry, wf6(:,55), wf3(:,3), wf18(:,102), n3(:,295), t3x18(:,:,81))
  call vert_WQ_A(ntry, wf9(:,3), wf2(:,12), wf18(:,103), n3(:,296), t3x18(:,:,82))
  call prop_Q_A(ntry, wf6(:,36), 5, ZERO, 0_intkind1, wf6(:,142), n2(157))
  call vert_AW_Q(ntry, wf2(:,9), wf9(:,3), wf18(:,104), n3(:,297), t3x18(:,:,83))
  call vert_AZ_Q(gZd,ntry, wf6(:,102), ex3(:), wf18(:,105), n3(:,298), t3x18(:,:,84))
  call prop_A_Q(ntry, wf18(:,105), 14, ZERO, 0_intkind1, wf18(:,106), n2(158))
  call vert_VQ_A(ntry, wf3(:,8), wf6(:,70), wf18(:,107), n3(:,299), t3x18(:,:,85))
  call vert_VQ_A(ntry, wf3(:,6), wf6(:,70), wf18(:,108), n3(:,300), t3x18(:,:,86))
  call vert_ZQ_A(gZu,ntry, wf3(:,8), wf6(:,70), wf18(:,109), n3(:,301), t3x18(:,:,87))
  call vert_ZQ_A(gZu,ntry, wf3(:,6), wf6(:,70), wf18(:,110), n3(:,302), t3x18(:,:,88))
  call vert_VQ_A(ntry, ex5(:), wf6(:,70), wf12(:,109), n3(:,303), t3x12(:,:,73))
  call prop_Q_A(ntry, wf12(:,109), 25, ZERO, 0_intkind1, wf12(:,110), n2(159))
  call vert_WQ_A(ntry, wf3(:,5), wf6(:,70), wf18(:,111), n3(:,304), t3x18(:,:,89))
  call vert_AV_Q(ntry, wf6(:,60), wf3(:,8), wf18(:,112), n3(:,305), t3x18(:,:,90))
  call vert_AV_Q(ntry, wf6(:,60), wf3(:,6), wf18(:,113), n3(:,306), t3x18(:,:,91))
  call vert_AZ_Q(gZu,ntry, wf6(:,60), wf3(:,8), wf18(:,114), n3(:,307), t3x18(:,:,92))
  call vert_AZ_Q(gZu,ntry, wf6(:,60), wf3(:,6), wf18(:,115), n3(:,308), t3x18(:,:,93))
  call vert_ZQ_A(gZu,ntry, ex4(:), wf4(:,22), wf12(:,111), n3(:,309), t3x12(:,:,74))
  call prop_Q_A(ntry, wf12(:,111), 25, ZERO, 0_intkind1, wf12(:,112), n2(160))
  call vert_AW_Q(ntry, wf2(:,10), wf9(:,6), wf18(:,116), n3(:,310), t3x18(:,:,94))
  call prop_A_Q(ntry, wf6(:,33), 10, ZERO, 0_intkind1, wf6(:,143), n2(161))
  call vert_AV_Q(ntry, wf6(:,60), ex5(:), wf12(:,113), n3(:,311), t3x12(:,:,75))
  call prop_A_Q(ntry, wf12(:,113), 26, ZERO, 0_intkind1, wf12(:,114), n2(162))
  call vert_AZ_Q(gZu,ntry, wf4(:,20), ex4(:), wf12(:,115), n3(:,312), t3x12(:,:,76))
  call prop_A_Q(ntry, wf12(:,115), 26, ZERO, 0_intkind1, wf12(:,116), n2(163))
  call vert_WQ_A(ntry, wf9(:,6), wf2(:,11), wf18(:,117), n3(:,313), t3x18(:,:,95))
  call vert_ZQ_A(gZd,ntry, ex4(:), wf6(:,103), wf18(:,118), n3(:,314), t3x18(:,:,96))
  call prop_Q_A(ntry, wf18(:,118), 13, ZERO, 0_intkind1, wf18(:,119), n2(164))
  call vert_AW_Q(ntry, wf6(:,60), wf3(:,7), wf18(:,120), n3(:,315), t3x18(:,:,97))
  call vert_WQ_A(ntry, wf9(:,4), wf2(:,12), wf18(:,121), n3(:,316), t3x18(:,:,98))
  call prop_Q_A(ntry, wf6(:,35), 9, ZERO, 0_intkind1, wf6(:,144), n2(165))
  call vert_AW_Q(ntry, wf2(:,9), wf9(:,4), wf18(:,122), n3(:,317), t3x18(:,:,99))
  call vert_AZ_Q(gZd,ntry, wf6(:,101), ex4(:), wf18(:,123), n3(:,318), t3x18(:,:,100))
  call prop_A_Q(ntry, wf18(:,123), 14, ZERO, 0_intkind1, wf18(:,124), n2(166))
  call vert_VQ_A(ntry, ex5(:), wf6(:,119), wf12(:,117), n3(:,319), t3x12(:,:,77))
  call vert_VQ_A(ntry, ex5(:), wf6(:,120), wf12(:,118), n3(:,320), t3x12(:,:,78))
  call vert_VQ_A(ntry, ex5(:), wf6(:,121), wf12(:,119), n3(:,321), t3x12(:,:,79))
  call vert_VQ_A(ntry, ex5(:), wf6(:,122), wf12(:,120), n3(:,322), t3x12(:,:,80))
  call vert_VQ_A(ntry, ex5(:), wf6(:,116), wf12(:,121), n3(:,323), t3x12(:,:,81))
  call vert_VQ_A(ntry, ex5(:), wf6(:,115), wf12(:,122), n3(:,324), t3x12(:,:,82))
  call vert_VQ_A(ntry, ex5(:), wf6(:,118), wf12(:,123), n3(:,325), t3x12(:,:,83))
  call vert_VQ_A(ntry, ex5(:), wf6(:,117), wf12(:,124), n3(:,326), t3x12(:,:,84))
  call vert_VQ_A(ntry, wf3(:,4), wf6(:,3), wf18(:,125), n3(:,327), t3x18(:,:,101))
  call vert_ZQ_A(gZd,ntry, wf3(:,4), wf6(:,3), wf18(:,126), n3(:,328), t3x18(:,:,102))
  call vert_AV_Q(ntry, wf2(:,10), wf3(:,4), wf6(:,145), n3(:,329), t3x6(:,:,85))
  call vert_AZ_Q(gZd,ntry, wf2(:,10), wf3(:,4), wf6(:,146), n3(:,330), t3x6(:,:,86))
  call vert_ZQ_A(gZd,ntry, ex3(:), wf6(:,115), wf18(:,127), n3(:,331), t3x18(:,:,103))
  call vert_ZQ_A(gZd,ntry, ex3(:), wf6(:,117), wf18(:,128), n3(:,332), t3x18(:,:,104))
  call vert_VQ_A(ntry, wf3(:,8), wf6(:,7), wf18(:,129), n3(:,333), t3x18(:,:,105))
  call vert_ZQ_A(gZd,ntry, wf3(:,8), wf6(:,7), wf18(:,130), n3(:,334), t3x18(:,:,106))
  call vert_AV_Q(ntry, wf2(:,10), wf3(:,8), wf6(:,147), n3(:,335), t3x6(:,:,87))
  call vert_AZ_Q(gZd,ntry, wf2(:,10), wf3(:,8), wf6(:,148), n3(:,336), t3x6(:,:,88))
  call vert_ZQ_A(gZd,ntry, ex4(:), wf6(:,119), wf18(:,131), n3(:,337), t3x18(:,:,107))
  call vert_ZQ_A(gZd,ntry, ex4(:), wf6(:,121), wf18(:,132), n3(:,338), t3x18(:,:,108))
  call vert_AV_Q(ntry, wf6(:,8), wf3(:,2), wf18(:,133), n3(:,339), t3x18(:,:,109))
  call vert_AZ_Q(gZd,ntry, wf6(:,8), wf3(:,2), wf18(:,134), n3(:,340), t3x18(:,:,110))
  call vert_VQ_A(ntry, wf3(:,2), wf2(:,12), wf6(:,149), n3(:,341), t3x6(:,:,89))
  call vert_ZQ_A(gZd,ntry, wf3(:,2), wf2(:,12), wf6(:,150), n3(:,342), t3x6(:,:,90))
  call vert_AV_Q(ntry, wf6(:,134), ex5(:), wf12(:,125), n3(:,343), t3x12(:,:,85))
  call vert_AV_Q(ntry, wf6(:,136), ex5(:), wf12(:,126), n3(:,344), t3x12(:,:,86))
  call vert_AZ_Q(gZd,ntry, wf6(:,134), ex3(:), wf18(:,135), n3(:,345), t3x18(:,:,111))
  call vert_AZ_Q(gZd,ntry, wf6(:,136), ex3(:), wf18(:,136), n3(:,346), t3x18(:,:,112))
  call vert_AV_Q(ntry, wf6(:,4), wf3(:,6), wf18(:,137), n3(:,347), t3x18(:,:,113))
  call vert_AZ_Q(gZd,ntry, wf6(:,4), wf3(:,6), wf18(:,138), n3(:,348), t3x18(:,:,114))
  call vert_VQ_A(ntry, wf3(:,6), wf2(:,12), wf6(:,151), n3(:,349), t3x6(:,:,91))
  call vert_ZQ_A(gZd,ntry, wf3(:,6), wf2(:,12), wf6(:,152), n3(:,350), t3x6(:,:,92))
  call vert_AV_Q(ntry, wf6(:,138), ex5(:), wf12(:,127), n3(:,351), t3x12(:,:,87))
  call vert_AV_Q(ntry, wf6(:,140), ex5(:), wf12(:,128), n3(:,352), t3x12(:,:,88))
  call vert_AZ_Q(gZd,ntry, wf6(:,138), ex4(:), wf18(:,139), n3(:,353), t3x18(:,:,115))
  call vert_AZ_Q(gZd,ntry, wf6(:,140), ex4(:), wf18(:,140), n3(:,354), t3x18(:,:,116))
  call vert_VQ_A(ntry, ex5(:), wf6(:,142), wf12(:,129), n3(:,355), t3x12(:,:,89))
  call vert_ZQ_A(gZd,ntry, ex4(:), wf6(:,142), wf18(:,141), n3(:,356), t3x18(:,:,117))
  call vert_AV_Q(ntry, wf6(:,141), ex5(:), wf12(:,130), n3(:,357), t3x12(:,:,90))
  call vert_ZQ_A(gZd,ntry, ex3(:), wf6(:,144), wf18(:,142), n3(:,358), t3x18(:,:,118))
  call vert_AZ_Q(gZd,ntry, wf6(:,141), ex4(:), wf18(:,143), n3(:,359), t3x18(:,:,119))
  call vert_AZ_Q(gZd,ntry, wf6(:,143), ex3(:), wf18(:,144), n3(:,360), t3x18(:,:,120))
  call vert_VQ_A(ntry, wf3(:,2), wf6(:,3), wf18(:,145), n3(:,361), t3x18(:,:,121))
  call vert_ZQ_A(gZd,ntry, wf3(:,2), wf6(:,3), wf18(:,146), n3(:,362), t3x18(:,:,122))
  call vert_AV_Q(ntry, wf2(:,10), wf3(:,2), wf6(:,153), n3(:,363), t3x6(:,:,93))
  call vert_AZ_Q(gZd,ntry, wf2(:,10), wf3(:,2), wf6(:,154), n3(:,364), t3x6(:,:,94))
  call vert_ZQ_A(gZd,ntry, ex3(:), wf6(:,116), wf18(:,147), n3(:,365), t3x18(:,:,123))
  call vert_ZQ_A(gZd,ntry, ex3(:), wf6(:,118), wf18(:,148), n3(:,366), t3x18(:,:,124))
  call vert_VQ_A(ntry, wf3(:,6), wf6(:,7), wf18(:,149), n3(:,367), t3x18(:,:,125))
  call vert_ZQ_A(gZd,ntry, wf3(:,6), wf6(:,7), wf18(:,150), n3(:,368), t3x18(:,:,126))
  call vert_AV_Q(ntry, wf2(:,10), wf3(:,6), wf6(:,155), n3(:,369), t3x6(:,:,95))
  call vert_AZ_Q(gZd,ntry, wf2(:,10), wf3(:,6), wf6(:,156), n3(:,370), t3x6(:,:,96))
  call vert_ZQ_A(gZd,ntry, ex4(:), wf6(:,120), wf18(:,151), n3(:,371), t3x18(:,:,127))
  call vert_ZQ_A(gZd,ntry, ex4(:), wf6(:,122), wf18(:,152), n3(:,372), t3x18(:,:,128))
  call vert_AV_Q(ntry, wf6(:,8), wf3(:,4), wf18(:,153), n3(:,373), t3x18(:,:,129))
  call vert_AZ_Q(gZd,ntry, wf6(:,8), wf3(:,4), wf18(:,154), n3(:,374), t3x18(:,:,130))
  call vert_VQ_A(ntry, wf3(:,4), wf2(:,12), wf6(:,157), n3(:,375), t3x6(:,:,97))
  call vert_ZQ_A(gZd,ntry, wf3(:,4), wf2(:,12), wf6(:,158), n3(:,376), t3x6(:,:,98))
  call vert_AV_Q(ntry, wf6(:,133), ex5(:), wf12(:,131), n3(:,377), t3x12(:,:,91))
  call vert_AV_Q(ntry, wf6(:,135), ex5(:), wf12(:,132), n3(:,378), t3x12(:,:,92))
  call vert_AZ_Q(gZd,ntry, wf6(:,133), ex3(:), wf18(:,155), n3(:,379), t3x18(:,:,131))
  call vert_AZ_Q(gZd,ntry, wf6(:,135), ex3(:), wf18(:,156), n3(:,380), t3x18(:,:,132))
  call vert_AV_Q(ntry, wf6(:,4), wf3(:,8), wf18(:,157), n3(:,381), t3x18(:,:,133))
  call vert_AZ_Q(gZd,ntry, wf6(:,4), wf3(:,8), wf18(:,158), n3(:,382), t3x18(:,:,134))
  call vert_VQ_A(ntry, wf3(:,8), wf2(:,12), wf6(:,159), n3(:,383), t3x6(:,:,99))
  call vert_ZQ_A(gZd,ntry, wf3(:,8), wf2(:,12), wf6(:,160), n3(:,384), t3x6(:,:,100))
  call vert_AV_Q(ntry, wf6(:,137), ex5(:), wf12(:,133), n3(:,385), t3x12(:,:,93))
  call vert_AV_Q(ntry, wf6(:,139), ex5(:), wf12(:,134), n3(:,386), t3x12(:,:,94))
  call vert_AZ_Q(gZd,ntry, wf6(:,137), ex4(:), wf18(:,159), n3(:,387), t3x18(:,:,135))
  call vert_AZ_Q(gZd,ntry, wf6(:,139), ex4(:), wf18(:,160), n3(:,388), t3x18(:,:,136))
  call vert_QA_W(ntry, wf4(:,4), wf6(:,72), wf24(:,9), n3(:,389), t3x24(:,:,9))
  call counter_V_W_T_EWs(cONE,ntry, wf3(:,4), 8, wf3(:,9), n2(167))
  call counter_V_W_T_EWs(cONE,ntry, wf3(:,2), 8, wf3(:,10), n2(168))
  call vert_QA_W(ntry, wf12(:,81), ex2(:), wf24(:,10), n3(:,390), t3x24(:,:,10))
  call counter_V_U_T_EWs(cONE,ntry, wf3(:,4), 8, wf3(:,11), n2(169))
  call counter_V_U_T_EWs(cONE,ntry, wf3(:,2), 8, wf3(:,12), n2(170))
  call vert_UV_W(ntry, wf3(:,5), 4, wf8(:,1), 19, wf24(:,11), n3(:,391), t3x24(:,:,11))
  call vert_UV_W(ntry, wf8(:,1), 19, wf3(:,7), 4, wf24(:,12), n3(:,392), t3x24(:,:,12))
  call vert_UV_W(ntry, wf3(:,5), 4, wf8(:,2), 19, wf24(:,13), n3(:,393), t3x24(:,:,13))
  call vert_UV_W(ntry, wf8(:,2), 19, wf3(:,7), 4, wf24(:,14), n3(:,394), t3x24(:,:,14))
  call vert_QA_W(ntry, wf4(:,4), wf6(:,67), wf24(:,15), n3(:,395), t3x24(:,:,15))
  call counter_V_W_T_EWs(cONE,ntry, wf3(:,8), 4, wf3(:,13), n2(171))
  call counter_V_W_T_EWs(cONE,ntry, wf3(:,6), 4, wf3(:,14), n2(172))
  call vert_QA_W(ntry, wf12(:,86), ex2(:), wf24(:,16), n3(:,396), t3x24(:,:,16))
  call counter_V_U_T_EWs(cONE,ntry, wf3(:,8), 4, wf3(:,15), n2(173))
  call counter_V_U_T_EWs(cONE,ntry, wf3(:,6), 4, wf3(:,16), n2(174))
  call vert_UV_W(ntry, wf3(:,1), 8, wf8(:,1), 19, wf24(:,17), n3(:,397), t3x24(:,:,17))
  call vert_UV_W(ntry, wf8(:,1), 19, wf3(:,3), 8, wf24(:,18), n3(:,398), t3x24(:,:,18))
  call vert_UV_W(ntry, wf3(:,1), 8, wf8(:,2), 19, wf24(:,19), n3(:,399), t3x24(:,:,19))
  call vert_UV_W(ntry, wf8(:,2), 19, wf3(:,3), 8, wf24(:,20), n3(:,400), t3x24(:,:,20))
  call vert_QA_W(ntry, wf6(:,62), wf4(:,2), wf24(:,21), n3(:,401), t3x24(:,:,21))
  call vert_QA_W(ntry, ex1(:), wf12(:,95), wf24(:,22), n3(:,402), t3x24(:,:,22))
  call vert_UV_W(ntry, wf3(:,5), 4, wf8(:,3), 19, wf24(:,23), n3(:,403), t3x24(:,:,23))
  call vert_UV_W(ntry, wf8(:,3), 19, wf3(:,7), 4, wf24(:,24), n3(:,404), t3x24(:,:,24))
  call vert_UV_W(ntry, wf3(:,5), 4, wf8(:,4), 19, wf24(:,25), n3(:,405), t3x24(:,:,25))
  call vert_UV_W(ntry, wf8(:,4), 19, wf3(:,7), 4, wf24(:,26), n3(:,406), t3x24(:,:,26))
  call vert_QA_W(ntry, wf6(:,57), wf4(:,2), wf24(:,27), n3(:,407), t3x24(:,:,27))
  call vert_QA_W(ntry, ex1(:), wf12(:,100), wf24(:,28), n3(:,408), t3x24(:,:,28))
  call vert_UV_W(ntry, wf3(:,1), 8, wf8(:,3), 19, wf24(:,29), n3(:,409), t3x24(:,:,29))
  call vert_UV_W(ntry, wf8(:,3), 19, wf3(:,3), 8, wf24(:,30), n3(:,410), t3x24(:,:,30))
  call vert_UV_W(ntry, wf3(:,1), 8, wf8(:,4), 19, wf24(:,31), n3(:,411), t3x24(:,:,31))
  call vert_UV_W(ntry, wf8(:,4), 19, wf3(:,3), 8, wf24(:,32), n3(:,412), t3x24(:,:,32))
  call vert_AW_Q(ntry, ex2(:), wf3(:,11), wf6(:,161), n3(:,413), t3x6(:,:,101))
  call vert_AW_Q(ntry, ex2(:), wf3(:,12), wf6(:,162), n3(:,414), t3x6(:,:,102))
  call vert_WQ_A(ntry, wf3(:,9), ex1(:), wf6(:,163), n3(:,415), t3x6(:,:,103))
  call vert_WQ_A(ntry, wf3(:,10), ex1(:), wf6(:,164), n3(:,416), t3x6(:,:,104))
  call vert_AW_Q(ntry, ex2(:), wf3(:,15), wf6(:,165), n3(:,417), t3x6(:,:,105))
  call vert_AW_Q(ntry, ex2(:), wf3(:,16), wf6(:,166), n3(:,418), t3x6(:,:,106))
  call vert_WQ_A(ntry, wf3(:,13), ex1(:), wf6(:,167), n3(:,419), t3x6(:,:,107))
  call vert_WQ_A(ntry, wf3(:,14), ex1(:), wf6(:,168), n3(:,420), t3x6(:,:,108))
  call vert_QA_W(ntry, wf6(:,3), wf4(:,20), wf24(:,33), n3(:,421), t3x24(:,:,33))
  call vert_QA_W(ntry, wf12(:,5), wf2(:,9), wf24(:,34), n3(:,422), t3x24(:,:,34))
  call prop_Q_A(ntry, wf18(:,17), 13, ZERO, 0_intkind1, wf18(:,161), n2(175))
  call vert_VQ_A(ntry, ex5(:), wf18(:,161), wf36(:,1), n3(:,423), t3x36(:,:,1))
  call counter_A_Q_LR_EWs([ZERO,cONE],ntry, wf2(:,10), 2, wf2(:,17), n2(176))
  call vert_WQ_A(ntry, wf3(:,3), wf12(:,5), wf36(:,2), n3(:,424), t3x36(:,:,2))
  call vert_QA_W(ntry, wf4(:,4), wf6(:,55), wf24(:,35), n3(:,425), t3x24(:,:,35))
  call vert_UV_W(ntry, wf8(:,5), 19, ex3(:), 4, wf24(:,36), n3(:,426), t3x24(:,:,36))
  call vert_QA_W(ntry, wf12(:,8), wf2(:,9), wf24(:,37), n3(:,427), t3x24(:,:,37))
  call vert_WQ_A(ntry, wf9(:,3), wf4(:,4), wf36(:,3), n3(:,428), t3x36(:,:,3))
  call vert_ZQ_A(gZu,ntry, ex3(:), wf12(:,86), wf36(:,4), n3(:,429), t3x36(:,:,4))
  call vert_WQ_A(ntry, wf3(:,3), wf12(:,8), wf36(:,5), n3(:,430), t3x36(:,:,5))
  call vert_UV_W(ntry, ex3(:), 4, wf3(:,9), 8, wf9(:,15), n3(:,431), t3x9(:,:,15))
  call vert_UV_W(ntry, ex3(:), 4, wf3(:,10), 8, wf9(:,16), n3(:,432), t3x9(:,:,16))
  call vert_AZ_Q(gZu,ntry, wf2(:,17), ex3(:), wf6(:,169), n3(:,433), t3x6(:,:,109))
  call prop_Q_A(ntry, wf18(:,18), 13, ZERO, 0_intkind1, wf18(:,162), n2(177))
  call vert_AV_Q(ntry, wf2(:,17), ex5(:), wf4(:,39), n3(:,434), t3x4(:,:,21))
  call prop_Q_A(ntry, wf18(:,19), 13, ZERO, 0_intkind1, wf18(:,163), n2(178))
  call vert_QA_W(ntry, wf6(:,7), wf4(:,20), wf24(:,38), n3(:,435), t3x24(:,:,38))
  call vert_QA_W(ntry, wf12(:,6), wf2(:,9), wf24(:,39), n3(:,436), t3x24(:,:,39))
  call prop_Q_A(ntry, wf18(:,20), 13, ZERO, 0_intkind1, wf18(:,164), n2(179))
  call vert_VQ_A(ntry, ex5(:), wf18(:,164), wf36(:,6), n3(:,437), t3x36(:,:,6))
  call vert_WQ_A(ntry, wf3(:,7), wf12(:,6), wf36(:,7), n3(:,438), t3x36(:,:,7))
  call vert_QA_W(ntry, wf4(:,4), wf6(:,60), wf24(:,40), n3(:,439), t3x24(:,:,40))
  call vert_UV_W(ntry, wf8(:,5), 19, ex4(:), 8, wf24(:,41), n3(:,440), t3x24(:,:,41))
  call vert_QA_W(ntry, wf12(:,7), wf2(:,9), wf24(:,42), n3(:,441), t3x24(:,:,42))
  call vert_WQ_A(ntry, wf9(:,4), wf4(:,4), wf36(:,8), n3(:,442), t3x36(:,:,8))
  call vert_ZQ_A(gZu,ntry, ex4(:), wf12(:,81), wf36(:,9), n3(:,443), t3x36(:,:,9))
  call vert_WQ_A(ntry, wf3(:,7), wf12(:,7), wf36(:,10), n3(:,444), t3x36(:,:,10))
  call vert_UV_W(ntry, ex4(:), 8, wf3(:,13), 4, wf9(:,17), n3(:,445), t3x9(:,:,17))
  call vert_UV_W(ntry, ex4(:), 8, wf3(:,14), 4, wf9(:,18), n3(:,446), t3x9(:,:,18))
  call vert_AZ_Q(gZu,ntry, wf2(:,17), ex4(:), wf6(:,170), n3(:,447), t3x6(:,:,110))
  call prop_Q_A(ntry, wf18(:,21), 13, ZERO, 0_intkind1, wf18(:,165), n2(180))
  call prop_Q_A(ntry, wf18(:,22), 13, ZERO, 0_intkind1, wf18(:,166), n2(181))
  call vert_QA_W(ntry, wf4(:,22), wf6(:,8), wf24(:,43), n3(:,448), t3x24(:,:,43))
  call vert_QA_W(ntry, wf2(:,11), wf12(:,10), wf24(:,44), n3(:,449), t3x24(:,:,44))
  call prop_A_Q(ntry, wf18(:,23), 14, ZERO, 0_intkind1, wf18(:,167), n2(182))
  call vert_AV_Q(ntry, wf18(:,167), ex5(:), wf36(:,11), n3(:,450), t3x36(:,:,11))
  call counter_Q_A_LR_EWs([ZERO,cONE],ntry, wf2(:,12), 1, wf2(:,18), n2(183))
  call vert_AW_Q(ntry, wf12(:,10), wf3(:,1), wf36(:,12), n3(:,451), t3x36(:,:,12))
  call vert_QA_W(ntry, wf6(:,65), wf4(:,2), wf24(:,45), n3(:,452), t3x24(:,:,45))
  call vert_UV_W(ntry, ex3(:), 4, wf8(:,6), 19, wf24(:,46), n3(:,453), t3x24(:,:,46))
  call vert_QA_W(ntry, wf2(:,11), wf12(:,16), wf24(:,47), n3(:,454), t3x24(:,:,47))
  call vert_AW_Q(ntry, wf4(:,2), wf9(:,5), wf36(:,13), n3(:,455), t3x36(:,:,13))
  call vert_AZ_Q(gZu,ntry, wf12(:,100), ex3(:), wf36(:,14), n3(:,456), t3x36(:,:,14))
  call vert_AW_Q(ntry, wf12(:,16), wf3(:,1), wf36(:,15), n3(:,457), t3x36(:,:,15))
  call vert_UV_W(ntry, wf3(:,11), 8, ex3(:), 4, wf9(:,19), n3(:,458), t3x9(:,:,19))
  call vert_UV_W(ntry, wf3(:,12), 8, ex3(:), 4, wf9(:,20), n3(:,459), t3x9(:,:,20))
  call vert_ZQ_A(gZu,ntry, ex3(:), wf2(:,18), wf6(:,171), n3(:,460), t3x6(:,:,111))
  call prop_A_Q(ntry, wf18(:,24), 14, ZERO, 0_intkind1, wf18(:,168), n2(184))
  call vert_VQ_A(ntry, ex5(:), wf2(:,18), wf4(:,40), n3(:,461), t3x4(:,:,22))
  call prop_A_Q(ntry, wf18(:,25), 14, ZERO, 0_intkind1, wf18(:,169), n2(185))
  call vert_QA_W(ntry, wf4(:,22), wf6(:,4), wf24(:,48), n3(:,462), t3x24(:,:,48))
  call vert_QA_W(ntry, wf2(:,11), wf12(:,12), wf24(:,49), n3(:,463), t3x24(:,:,49))
  call prop_A_Q(ntry, wf18(:,26), 14, ZERO, 0_intkind1, wf18(:,170), n2(186))
  call vert_AV_Q(ntry, wf18(:,170), ex5(:), wf36(:,16), n3(:,464), t3x36(:,:,16))
  call vert_AW_Q(ntry, wf12(:,12), wf3(:,5), wf36(:,17), n3(:,465), t3x36(:,:,17))
  call vert_QA_W(ntry, wf6(:,70), wf4(:,2), wf24(:,50), n3(:,466), t3x24(:,:,50))
  call vert_UV_W(ntry, ex4(:), 8, wf8(:,6), 19, wf24(:,51), n3(:,467), t3x24(:,:,51))
  call vert_QA_W(ntry, wf2(:,11), wf12(:,14), wf24(:,52), n3(:,468), t3x24(:,:,52))
  call vert_AW_Q(ntry, wf4(:,2), wf9(:,6), wf36(:,18), n3(:,469), t3x36(:,:,18))
  call vert_AZ_Q(gZu,ntry, wf12(:,95), ex4(:), wf36(:,19), n3(:,470), t3x36(:,:,19))
  call vert_AW_Q(ntry, wf12(:,14), wf3(:,5), wf36(:,20), n3(:,471), t3x36(:,:,20))
  call vert_UV_W(ntry, wf3(:,15), 4, ex4(:), 8, wf9(:,21), n3(:,472), t3x9(:,:,21))
  call vert_UV_W(ntry, wf3(:,16), 4, ex4(:), 8, wf9(:,22), n3(:,473), t3x9(:,:,22))
  call vert_ZQ_A(gZu,ntry, ex4(:), wf2(:,18), wf6(:,172), n3(:,474), t3x6(:,:,112))
  call prop_A_Q(ntry, wf18(:,27), 14, ZERO, 0_intkind1, wf18(:,171), n2(187))
  call prop_A_Q(ntry, wf18(:,28), 14, ZERO, 0_intkind1, wf18(:,172), n2(188))
  call prop_Q_A(ntry, wf18(:,31), 13, ZERO, 0_intkind1, wf18(:,173), n2(189))
  call prop_Q_A(ntry, wf18(:,32), 13, ZERO, 0_intkind1, wf18(:,174), n2(190))
  call prop_A_Q(ntry, wf18(:,29), 14, ZERO, 0_intkind1, wf18(:,175), n2(191))
  call prop_A_Q(ntry, wf18(:,30), 14, ZERO, 0_intkind1, wf18(:,176), n2(192))
  call vert_AW_Q(ntry, wf2(:,1), wf3(:,5), wf6(:,173), n3(:,475), t3x6(:,:,113))
  call prop_A_Q(ntry, wf6(:,173), 6, ZERO, 0_intkind1, wf6(:,174), n2(193))
  call vert_WQ_A(ntry, wf3(:,3), wf4(:,12), wf12(:,135), n3(:,476), t3x12(:,:,95))
  call vert_AW_Q(ntry, wf2(:,1), wf3(:,1), wf6(:,175), n3(:,477), t3x6(:,:,114))
  call prop_A_Q(ntry, wf6(:,175), 10, ZERO, 0_intkind1, wf6(:,176), n2(194))
  call vert_WQ_A(ntry, wf3(:,7), wf4(:,12), wf12(:,136), n3(:,478), t3x12(:,:,96))
  call vert_QA_V(ntry, wf4(:,12), wf2(:,1), wf8(:,17), n3(:,479), t3x8(:,:,17))
  call vert_QA_Z(gZd,ntry, wf4(:,12), wf2(:,1), wf8(:,18), n3(:,480), t3x8(:,:,18))
  call vert_WQ_A(ntry, wf3(:,7), wf2(:,3), wf6(:,177), n3(:,481), t3x6(:,:,115))
  call prop_Q_A(ntry, wf6(:,177), 5, ZERO, 0_intkind1, wf6(:,178), n2(195))
  call vert_AW_Q(ntry, wf4(:,14), wf3(:,1), wf12(:,137), n3(:,482), t3x12(:,:,97))
  call vert_WQ_A(ntry, wf3(:,3), wf2(:,3), wf6(:,179), n3(:,483), t3x6(:,:,116))
  call prop_Q_A(ntry, wf6(:,179), 9, ZERO, 0_intkind1, wf6(:,180), n2(196))
  call vert_AW_Q(ntry, wf4(:,14), wf3(:,5), wf12(:,138), n3(:,484), t3x12(:,:,98))
  call vert_QA_V(ntry, wf2(:,3), wf4(:,14), wf8(:,19), n3(:,485), t3x8(:,:,19))
  call vert_QA_Z(gZd,ntry, wf2(:,3), wf4(:,14), wf8(:,20), n3(:,486), t3x8(:,:,20))
  call vert_VQ_A(ntry, ex5(:), wf6(:,178), wf12(:,139), n3(:,487), t3x12(:,:,99))
  call vert_VQ_A(ntry, ex5(:), wf6(:,180), wf12(:,140), n3(:,488), t3x12(:,:,100))
  call counter_U_W_T_EWs(cONE,ntry, wf3(:,3), 8, wf3(:,17), n2(197))
  call vert_WQ_A(ntry, wf3(:,17), wf4(:,4), wf12(:,141), n3(:,489), t3x12(:,:,101))
  call counter_W_U_T_EWs(cONE,ntry, wf3(:,1), 8, wf3(:,18), n2(198))
  call vert_AW_Q(ntry, wf2(:,1), wf3(:,18), wf6(:,181), n3(:,490), t3x6(:,:,117))
  call vert_QA_V(ntry, wf4(:,4), wf2(:,1), wf8(:,21), n3(:,491), t3x8(:,:,21))
  call vert_UV_W(ntry, wf3(:,17), 8, wf3(:,5), 4, wf9(:,23), n3(:,492), t3x9(:,:,23))
  call vert_UV_W(ntry, wf3(:,7), 4, wf3(:,18), 8, wf9(:,24), n3(:,493), t3x9(:,:,24))
  call vert_QA_Z(gZd,ntry, wf4(:,4), wf2(:,1), wf8(:,22), n3(:,494), t3x8(:,:,22))
  call counter_U_W_T_EWs(cONE,ntry, wf3(:,7), 4, wf3(:,19), n2(199))
  call vert_WQ_A(ntry, wf3(:,19), wf4(:,4), wf12(:,142), n3(:,495), t3x12(:,:,102))
  call counter_W_U_T_EWs(cONE,ntry, wf3(:,5), 4, wf3(:,20), n2(200))
  call vert_AW_Q(ntry, wf2(:,1), wf3(:,20), wf6(:,182), n3(:,496), t3x6(:,:,118))
  call vert_UV_W(ntry, wf3(:,19), 4, wf3(:,1), 8, wf9(:,25), n3(:,497), t3x9(:,:,25))
  call vert_UV_W(ntry, wf3(:,3), 8, wf3(:,20), 4, wf9(:,26), n3(:,498), t3x9(:,:,26))
  call vert_WQ_A(ntry, wf3(:,18), wf6(:,62), wf18(:,177), n3(:,499), t3x18(:,:,137))
  call vert_WQ_A(ntry, wf3(:,17), ex1(:), wf6(:,183), n3(:,500), t3x6(:,:,119))
  call prop_Q_A(ntry, wf6(:,183), 9, ZERO, 0_intkind1, wf6(:,184), n2(201))
  call vert_QA_V(ntry, ex1(:), wf4(:,14), wf8(:,23), n3(:,501), t3x8(:,:,23))
  call vert_QA_Z(gZd,ntry, ex1(:), wf4(:,14), wf8(:,24), n3(:,502), t3x8(:,:,24))
  call vert_WQ_A(ntry, wf3(:,20), wf6(:,57), wf18(:,178), n3(:,503), t3x18(:,:,138))
  call vert_WQ_A(ntry, wf3(:,19), ex1(:), wf6(:,185), n3(:,504), t3x6(:,:,120))
  call prop_Q_A(ntry, wf6(:,185), 5, ZERO, 0_intkind1, wf6(:,186), n2(202))
  call vert_AV_Q(ntry, wf6(:,174), ex5(:), wf12(:,143), n3(:,505), t3x12(:,:,103))
  call vert_AV_Q(ntry, wf6(:,176), ex5(:), wf12(:,144), n3(:,506), t3x12(:,:,104))
  call vert_AW_Q(ntry, wf4(:,2), wf3(:,18), wf12(:,145), n3(:,507), t3x12(:,:,105))
  call vert_WQ_A(ntry, wf3(:,17), wf2(:,3), wf6(:,187), n3(:,508), t3x6(:,:,121))
  call vert_QA_V(ntry, wf2(:,3), wf4(:,2), wf8(:,25), n3(:,509), t3x8(:,:,25))
  call vert_QA_Z(gZd,ntry, wf2(:,3), wf4(:,2), wf8(:,26), n3(:,510), t3x8(:,:,26))
  call vert_AW_Q(ntry, wf4(:,2), wf3(:,20), wf12(:,146), n3(:,511), t3x12(:,:,106))
  call vert_WQ_A(ntry, wf3(:,19), wf2(:,3), wf6(:,188), n3(:,512), t3x6(:,:,122))
  call vert_AW_Q(ntry, wf6(:,72), wf3(:,17), wf18(:,179), n3(:,513), t3x18(:,:,139))
  call vert_AW_Q(ntry, ex2(:), wf3(:,18), wf6(:,189), n3(:,514), t3x6(:,:,123))
  call prop_A_Q(ntry, wf6(:,189), 10, ZERO, 0_intkind1, wf6(:,190), n2(203))
  call vert_QA_V(ntry, wf4(:,12), ex2(:), wf8(:,27), n3(:,515), t3x8(:,:,27))
  call vert_QA_Z(gZd,ntry, wf4(:,12), ex2(:), wf8(:,28), n3(:,516), t3x8(:,:,28))
  call vert_AW_Q(ntry, wf6(:,67), wf3(:,19), wf18(:,180), n3(:,517), t3x18(:,:,140))
  call vert_AW_Q(ntry, ex2(:), wf3(:,20), wf6(:,191), n3(:,518), t3x6(:,:,124))
  call prop_A_Q(ntry, wf6(:,191), 6, ZERO, 0_intkind1, wf6(:,192), n2(204))
  call vert_WQ_A(ntry, wf3(:,18), wf6(:,65), wf18(:,181), n3(:,519), t3x18(:,:,141))
  call vert_WQ_A(ntry, wf3(:,17), wf6(:,43), wf18(:,182), n3(:,520), t3x18(:,:,142))
  call vert_AW_Q(ntry, wf2(:,9), wf3(:,17), wf6(:,193), n3(:,521), t3x6(:,:,125))
  call counter_A_Q_LR_EWs([cONE,cONE],ntry, wf2(:,9), 2, wf2(:,19), n2(205))
  call vert_AV_Q(ntry, wf2(:,19), ex5(:), wf4(:,41), n3(:,522), t3x4(:,:,23))
  call vert_WQ_A(ntry, wf3(:,3), wf6(:,43), wf18(:,183), n3(:,523), t3x18(:,:,143))
  call prop_A_Q(ntry, wf4(:,41), 18, ZERO, 0_intkind1, wf4(:,42), n2(206))
  call counter_A_Q_LR_EWs([ZERO,cONE],ntry, wf2(:,1), 2, wf2(:,20), n2(207))
  call vert_AV_Q(ntry, wf2(:,20), ex5(:), wf4(:,43), n3(:,524), t3x4(:,:,24))
  call prop_A_Q(ntry, wf4(:,43), 18, ZERO, 0_intkind1, wf4(:,44), n2(208))
  call vert_AW_Q(ntry, wf2(:,19), wf3(:,3), wf6(:,194), n3(:,525), t3x6(:,:,126))
  call vert_AW_Q(ntry, wf2(:,20), wf3(:,3), wf6(:,195), n3(:,526), t3x6(:,:,127))
  call vert_AW_Q(ntry, wf6(:,39), wf3(:,18), wf18(:,184), n3(:,527), t3x18(:,:,144))
  call vert_AW_Q(ntry, wf6(:,55), wf3(:,17), wf18(:,185), n3(:,528), t3x18(:,:,145))
  call vert_UV_W(ntry, wf3(:,18), 8, ex3(:), 4, wf9(:,27), n3(:,529), t3x9(:,:,27))
  call vert_QA_W(ntry, wf4(:,22), wf2(:,1), wf8(:,29), n3(:,530), t3x8(:,:,29))
  call vert_UV_W(ntry, ex3(:), 4, wf3(:,17), 8, wf9(:,28), n3(:,531), t3x9(:,:,28))
  call vert_QA_W(ntry, wf4(:,12), wf2(:,9), wf8(:,30), n3(:,532), t3x8(:,:,30))
  call vert_AW_Q(ntry, wf2(:,19), wf9(:,3), wf18(:,186), n3(:,533), t3x18(:,:,146))
  call vert_AW_Q(ntry, wf2(:,20), wf9(:,3), wf18(:,187), n3(:,534), t3x18(:,:,147))
  call vert_AZ_Q(gZu,ntry, wf2(:,19), ex3(:), wf6(:,196), n3(:,535), t3x6(:,:,128))
  call prop_A_Q(ntry, wf6(:,196), 6, ZERO, 0_intkind1, wf6(:,197), n2(209))
  call vert_AZ_Q(gZu,ntry, wf2(:,20), ex3(:), wf6(:,198), n3(:,536), t3x6(:,:,129))
  call prop_A_Q(ntry, wf6(:,198), 6, ZERO, 0_intkind1, wf6(:,199), n2(210))
  call vert_WQ_A(ntry, wf3(:,18), wf2(:,11), wf6(:,200), n3(:,537), t3x6(:,:,130))
  call vert_QA_W(ntry, wf2(:,11), wf4(:,14), wf8(:,31), n3(:,538), t3x8(:,:,31))
  call vert_QA_W(ntry, wf2(:,3), wf4(:,20), wf8(:,32), n3(:,539), t3x8(:,:,32))
  call vert_WQ_A(ntry, wf9(:,3), wf2(:,3), wf18(:,188), n3(:,540), t3x18(:,:,148))
  call vert_ZQ_A(gZu,ntry, ex3(:), wf6(:,180), wf18(:,189), n3(:,541), t3x18(:,:,149))
  call prop_Q_A(ntry, wf18(:,189), 13, ZERO, 0_intkind1, wf18(:,190), n2(211))
  call counter_Q_A_LR_EWs([cONE,cONE],ntry, wf2(:,11), 1, wf2(:,21), n2(212))
  call vert_VQ_A(ntry, ex5(:), wf2(:,21), wf4(:,45), n3(:,542), t3x4(:,:,25))
  call vert_AW_Q(ntry, wf6(:,39), wf3(:,1), wf18(:,191), n3(:,543), t3x18(:,:,150))
  call prop_Q_A(ntry, wf4(:,45), 17, ZERO, 0_intkind1, wf4(:,46), n2(213))
  call counter_Q_A_LR_EWs([ZERO,cONE],ntry, wf2(:,3), 1, wf2(:,22), n2(214))
  call vert_VQ_A(ntry, ex5(:), wf2(:,22), wf4(:,47), n3(:,544), t3x4(:,:,26))
  call prop_Q_A(ntry, wf4(:,47), 17, ZERO, 0_intkind1, wf4(:,48), n2(215))
  call vert_WQ_A(ntry, wf3(:,1), wf2(:,21), wf6(:,201), n3(:,545), t3x6(:,:,131))
  call vert_WQ_A(ntry, wf3(:,1), wf2(:,22), wf6(:,202), n3(:,546), t3x6(:,:,132))
  call vert_WQ_A(ntry, wf9(:,5), wf2(:,21), wf18(:,192), n3(:,547), t3x18(:,:,151))
  call vert_WQ_A(ntry, wf9(:,5), wf2(:,22), wf18(:,193), n3(:,548), t3x18(:,:,152))
  call vert_ZQ_A(gZu,ntry, ex3(:), wf2(:,21), wf6(:,203), n3(:,549), t3x6(:,:,133))
  call prop_Q_A(ntry, wf6(:,203), 5, ZERO, 0_intkind1, wf6(:,204), n2(216))
  call vert_ZQ_A(gZu,ntry, ex3(:), wf2(:,22), wf6(:,205), n3(:,550), t3x6(:,:,134))
  call prop_Q_A(ntry, wf6(:,205), 5, ZERO, 0_intkind1, wf6(:,206), n2(217))
  call vert_AW_Q(ntry, wf2(:,1), wf9(:,5), wf18(:,194), n3(:,551), t3x18(:,:,153))
  call vert_AZ_Q(gZu,ntry, wf6(:,176), ex3(:), wf18(:,195), n3(:,552), t3x18(:,:,154))
  call prop_A_Q(ntry, wf18(:,195), 14, ZERO, 0_intkind1, wf18(:,196), n2(218))
  call vert_WQ_A(ntry, wf3(:,20), wf6(:,70), wf18(:,197), n3(:,553), t3x18(:,:,155))
  call vert_WQ_A(ntry, wf3(:,19), wf6(:,40), wf18(:,198), n3(:,554), t3x18(:,:,156))
  call vert_AW_Q(ntry, wf2(:,9), wf3(:,19), wf6(:,207), n3(:,555), t3x6(:,:,135))
  call vert_WQ_A(ntry, wf3(:,7), wf6(:,40), wf18(:,199), n3(:,556), t3x18(:,:,157))
  call vert_AW_Q(ntry, wf2(:,19), wf3(:,7), wf6(:,208), n3(:,557), t3x6(:,:,136))
  call vert_AW_Q(ntry, wf2(:,20), wf3(:,7), wf6(:,209), n3(:,558), t3x6(:,:,137))
  call vert_AW_Q(ntry, wf6(:,44), wf3(:,20), wf18(:,200), n3(:,559), t3x18(:,:,158))
  call vert_AW_Q(ntry, wf6(:,60), wf3(:,19), wf18(:,201), n3(:,560), t3x18(:,:,159))
  call vert_UV_W(ntry, wf3(:,20), 4, ex4(:), 8, wf9(:,29), n3(:,561), t3x9(:,:,29))
  call vert_UV_W(ntry, ex4(:), 8, wf3(:,19), 4, wf9(:,30), n3(:,562), t3x9(:,:,30))
  call vert_AW_Q(ntry, wf2(:,19), wf9(:,4), wf18(:,202), n3(:,563), t3x18(:,:,160))
  call vert_AW_Q(ntry, wf2(:,20), wf9(:,4), wf18(:,203), n3(:,564), t3x18(:,:,161))
  call vert_AZ_Q(gZu,ntry, wf2(:,19), ex4(:), wf6(:,210), n3(:,565), t3x6(:,:,138))
  call prop_A_Q(ntry, wf6(:,210), 10, ZERO, 0_intkind1, wf6(:,211), n2(219))
  call vert_AZ_Q(gZu,ntry, wf2(:,20), ex4(:), wf6(:,212), n3(:,566), t3x6(:,:,139))
  call prop_A_Q(ntry, wf6(:,212), 10, ZERO, 0_intkind1, wf6(:,213), n2(220))
  call vert_WQ_A(ntry, wf3(:,20), wf2(:,11), wf6(:,214), n3(:,567), t3x6(:,:,140))
  call vert_WQ_A(ntry, wf9(:,4), wf2(:,3), wf18(:,204), n3(:,568), t3x18(:,:,162))
  call vert_ZQ_A(gZu,ntry, ex4(:), wf6(:,178), wf18(:,205), n3(:,569), t3x18(:,:,163))
  call prop_Q_A(ntry, wf18(:,205), 13, ZERO, 0_intkind1, wf18(:,206), n2(221))
  call vert_AW_Q(ntry, wf6(:,44), wf3(:,5), wf18(:,207), n3(:,570), t3x18(:,:,164))
  call vert_WQ_A(ntry, wf3(:,5), wf2(:,21), wf6(:,215), n3(:,571), t3x6(:,:,141))
  call vert_WQ_A(ntry, wf3(:,5), wf2(:,22), wf6(:,216), n3(:,572), t3x6(:,:,142))
  call vert_WQ_A(ntry, wf9(:,6), wf2(:,21), wf18(:,208), n3(:,573), t3x18(:,:,165))
  call vert_WQ_A(ntry, wf9(:,6), wf2(:,22), wf18(:,209), n3(:,574), t3x18(:,:,166))
  call vert_ZQ_A(gZu,ntry, ex4(:), wf2(:,21), wf6(:,217), n3(:,575), t3x6(:,:,143))
  call prop_Q_A(ntry, wf6(:,217), 9, ZERO, 0_intkind1, wf6(:,218), n2(222))
  call vert_ZQ_A(gZu,ntry, ex4(:), wf2(:,22), wf6(:,219), n3(:,576), t3x6(:,:,144))
  call prop_Q_A(ntry, wf6(:,219), 9, ZERO, 0_intkind1, wf6(:,220), n2(223))
  call vert_AW_Q(ntry, wf2(:,1), wf9(:,6), wf18(:,210), n3(:,577), t3x18(:,:,167))
  call vert_AZ_Q(gZu,ntry, wf6(:,174), ex4(:), wf18(:,211), n3(:,578), t3x18(:,:,168))
  call prop_A_Q(ntry, wf18(:,211), 14, ZERO, 0_intkind1, wf18(:,212), n2(224))
  call vert_UV_W(ntry, wf3(:,17), 8, wf3(:,20), 4, wf9(:,31), n3(:,579), t3x9(:,:,31))
  call vert_UV_W(ntry, wf3(:,19), 4, wf3(:,18), 8, wf9(:,32), n3(:,580), t3x9(:,:,32))
  call vert_VQ_A(ntry, ex5(:), wf6(:,186), wf12(:,147), n3(:,581), t3x12(:,:,107))
  call vert_VQ_A(ntry, ex5(:), wf6(:,184), wf12(:,148), n3(:,582), t3x12(:,:,108))
  call vert_WQ_A(ntry, wf3(:,17), wf6(:,3), wf18(:,213), n3(:,583), t3x18(:,:,169))
  call vert_AW_Q(ntry, wf2(:,19), wf3(:,17), wf6(:,221), n3(:,584), t3x6(:,:,145))
  call vert_AW_Q(ntry, wf2(:,20), wf3(:,17), wf6(:,222), n3(:,585), t3x6(:,:,146))
  call vert_QA_W(ntry, wf4(:,4), wf2(:,19), wf8(:,33), n3(:,586), t3x8(:,:,33))
  call vert_QA_W(ntry, wf4(:,4), wf2(:,20), wf8(:,34), n3(:,587), t3x8(:,:,34))
  call vert_ZQ_A(gZu,ntry, ex3(:), wf6(:,184), wf18(:,214), n3(:,588), t3x18(:,:,170))
  call vert_WQ_A(ntry, wf9(:,28), ex1(:), wf18(:,215), n3(:,589), t3x18(:,:,171))
  call vert_WQ_A(ntry, wf3(:,19), wf6(:,7), wf18(:,216), n3(:,590), t3x18(:,:,172))
  call vert_AW_Q(ntry, wf2(:,19), wf3(:,19), wf6(:,223), n3(:,591), t3x6(:,:,147))
  call vert_AW_Q(ntry, wf2(:,20), wf3(:,19), wf6(:,224), n3(:,592), t3x6(:,:,148))
  call vert_ZQ_A(gZu,ntry, ex4(:), wf6(:,186), wf18(:,217), n3(:,593), t3x18(:,:,173))
  call vert_WQ_A(ntry, wf9(:,30), ex1(:), wf18(:,218), n3(:,594), t3x18(:,:,174))
  call vert_AW_Q(ntry, wf6(:,8), wf3(:,18), wf18(:,219), n3(:,595), t3x18(:,:,175))
  call vert_WQ_A(ntry, wf3(:,18), wf2(:,21), wf6(:,225), n3(:,596), t3x6(:,:,149))
  call vert_WQ_A(ntry, wf3(:,18), wf2(:,22), wf6(:,226), n3(:,597), t3x6(:,:,150))
  call vert_QA_W(ntry, wf2(:,21), wf4(:,2), wf8(:,35), n3(:,598), t3x8(:,:,35))
  call vert_QA_W(ntry, wf2(:,22), wf4(:,2), wf8(:,36), n3(:,599), t3x8(:,:,36))
  call vert_AV_Q(ntry, wf6(:,190), ex5(:), wf12(:,149), n3(:,600), t3x12(:,:,109))
  call vert_AZ_Q(gZu,ntry, wf6(:,190), ex3(:), wf18(:,220), n3(:,601), t3x18(:,:,176))
  call vert_AW_Q(ntry, ex2(:), wf9(:,27), wf18(:,221), n3(:,602), t3x18(:,:,177))
  call vert_AW_Q(ntry, wf6(:,4), wf3(:,20), wf18(:,222), n3(:,603), t3x18(:,:,178))
  call vert_WQ_A(ntry, wf3(:,20), wf2(:,21), wf6(:,227), n3(:,604), t3x6(:,:,151))
  call vert_WQ_A(ntry, wf3(:,20), wf2(:,22), wf6(:,228), n3(:,605), t3x6(:,:,152))
  call vert_AV_Q(ntry, wf6(:,192), ex5(:), wf12(:,150), n3(:,606), t3x12(:,:,110))
  call vert_AZ_Q(gZu,ntry, wf6(:,192), ex4(:), wf18(:,223), n3(:,607), t3x18(:,:,179))
  call vert_AW_Q(ntry, ex2(:), wf9(:,29), wf18(:,224), n3(:,608), t3x18(:,:,180))
  call vert_VQ_A(ntry, ex5(:), wf6(:,204), wf12(:,151), n3(:,609), t3x12(:,:,111))
  call vert_VQ_A(ntry, ex5(:), wf6(:,206), wf12(:,152), n3(:,610), t3x12(:,:,112))
  call vert_ZQ_A(gZu,ntry, ex4(:), wf6(:,204), wf18(:,225), n3(:,611), t3x18(:,:,181))
  call vert_ZQ_A(gZu,ntry, ex4(:), wf6(:,206), wf18(:,226), n3(:,612), t3x18(:,:,182))
  call vert_AV_Q(ntry, wf6(:,197), ex5(:), wf12(:,153), n3(:,613), t3x12(:,:,113))
  call vert_AV_Q(ntry, wf6(:,199), ex5(:), wf12(:,154), n3(:,614), t3x12(:,:,114))
  call vert_ZQ_A(gZu,ntry, ex3(:), wf6(:,218), wf18(:,227), n3(:,615), t3x18(:,:,183))
  call vert_ZQ_A(gZu,ntry, ex3(:), wf6(:,220), wf18(:,228), n3(:,616), t3x18(:,:,184))
  call vert_AZ_Q(gZu,ntry, wf6(:,197), ex4(:), wf18(:,229), n3(:,617), t3x18(:,:,185))
  call vert_AZ_Q(gZu,ntry, wf6(:,199), ex4(:), wf18(:,230), n3(:,618), t3x18(:,:,186))
  call vert_AZ_Q(gZu,ntry, wf6(:,211), ex3(:), wf18(:,231), n3(:,619), t3x18(:,:,187))
  call vert_AZ_Q(gZu,ntry, wf6(:,213), ex3(:), wf18(:,232), n3(:,620), t3x18(:,:,188))
  call counter_U_W_T_EWs(cONE,ntry, wf3(:,17), 8, wf3(:,21), n2(225))
  call counter_W_U_T_EWs(cONE,ntry, wf3(:,18), 8, wf3(:,22), n2(226))
  call counter_U_W_T_EWs(cONE,ntry, wf3(:,19), 4, wf3(:,23), n2(227))
  call counter_W_U_T_EWs(cONE,ntry, wf3(:,20), 4, wf3(:,24), n2(228))
  call vert_AW_Q(ntry, ex2(:), wf3(:,22), wf6(:,229), n3(:,621), t3x6(:,:,153))
  call vert_WQ_A(ntry, wf3(:,21), ex1(:), wf6(:,230), n3(:,622), t3x6(:,:,154))
  call vert_AW_Q(ntry, ex2(:), wf3(:,24), wf6(:,231), n3(:,623), t3x6(:,:,155))
  call vert_WQ_A(ntry, wf3(:,23), ex1(:), wf6(:,232), n3(:,624), t3x6(:,:,156))
  call vert_QA_V(ntry, wf6(:,3), wf4(:,14), wf24(:,53), n3(:,625), t3x24(:,:,53))
  call counter_U_V_T_EWs(cONE,ntry, wf3(:,17), 8, wf3(:,25), n2(229))
  call counter_W_V_T_EWs(cONE,ntry, wf3(:,18), 8, wf3(:,26), n2(230))
  call vert_QA_Z(gZd,ntry, wf6(:,3), wf4(:,14), wf24(:,54), n3(:,626), t3x24(:,:,54))
  call vert_QA_V(ntry, wf12(:,5), wf2(:,1), wf24(:,55), n3(:,627), t3x24(:,:,55))
  call vert_QA_Z(gZd,ntry, wf12(:,5), wf2(:,1), wf24(:,56), n3(:,628), t3x24(:,:,56))
  call counter_A_Q_LR_EWs([cONE,cONE],ntry, wf2(:,19), 2, wf2(:,23), n2(231))
  call counter_A_Q_LR_EWs([cONE,cONE],ntry, wf2(:,20), 2, wf2(:,24), n2(232))
  call vert_QA_V(ntry, wf4(:,4), wf6(:,39), wf24(:,57), n3(:,629), t3x24(:,:,57))
  call vert_QA_Z(gZd,ntry, wf4(:,4), wf6(:,39), wf24(:,58), n3(:,630), t3x24(:,:,58))
  call vert_QA_V(ntry, wf12(:,8), wf2(:,1), wf24(:,59), n3(:,631), t3x24(:,:,59))
  call vert_QA_Z(gZd,ntry, wf12(:,8), wf2(:,1), wf24(:,60), n3(:,632), t3x24(:,:,60))
  call vert_VQ_A(ntry, wf3(:,25), ex1(:), wf6(:,233), n3(:,633), t3x6(:,:,157))
  call vert_VQ_A(ntry, wf3(:,26), ex1(:), wf6(:,234), n3(:,634), t3x6(:,:,158))
  call vert_ZQ_A(gZd,ntry, wf3(:,25), ex1(:), wf6(:,235), n3(:,635), t3x6(:,:,159))
  call vert_ZQ_A(gZd,ntry, wf3(:,26), ex1(:), wf6(:,236), n3(:,636), t3x6(:,:,160))
  call vert_UV_W(ntry, ex3(:), 4, wf3(:,21), 8, wf9(:,33), n3(:,637), t3x9(:,:,33))
  call vert_AZ_Q(gZu,ntry, wf2(:,23), ex3(:), wf6(:,237), n3(:,638), t3x6(:,:,161))
  call vert_AZ_Q(gZu,ntry, wf2(:,24), ex3(:), wf6(:,238), n3(:,639), t3x6(:,:,162))
  call vert_AV_Q(ntry, wf2(:,23), ex5(:), wf4(:,49), n3(:,640), t3x4(:,:,27))
  call vert_AV_Q(ntry, wf2(:,24), ex5(:), wf4(:,50), n3(:,641), t3x4(:,:,28))
  call vert_QA_V(ntry, wf6(:,7), wf4(:,14), wf24(:,61), n3(:,642), t3x24(:,:,61))
  call counter_U_V_T_EWs(cONE,ntry, wf3(:,19), 4, wf3(:,27), n2(233))
  call counter_W_V_T_EWs(cONE,ntry, wf3(:,20), 4, wf3(:,28), n2(234))
  call vert_QA_Z(gZd,ntry, wf6(:,7), wf4(:,14), wf24(:,62), n3(:,643), t3x24(:,:,62))
  call vert_QA_V(ntry, wf12(:,6), wf2(:,1), wf24(:,63), n3(:,644), t3x24(:,:,63))
  call vert_QA_Z(gZd,ntry, wf12(:,6), wf2(:,1), wf24(:,64), n3(:,645), t3x24(:,:,64))
  call vert_QA_V(ntry, wf4(:,4), wf6(:,44), wf24(:,65), n3(:,646), t3x24(:,:,65))
  call vert_QA_Z(gZd,ntry, wf4(:,4), wf6(:,44), wf24(:,66), n3(:,647), t3x24(:,:,66))
  call vert_QA_V(ntry, wf12(:,7), wf2(:,1), wf24(:,67), n3(:,648), t3x24(:,:,67))
  call vert_QA_Z(gZd,ntry, wf12(:,7), wf2(:,1), wf24(:,68), n3(:,649), t3x24(:,:,68))
  call vert_VQ_A(ntry, wf3(:,27), ex1(:), wf6(:,239), n3(:,650), t3x6(:,:,163))
  call vert_VQ_A(ntry, wf3(:,28), ex1(:), wf6(:,240), n3(:,651), t3x6(:,:,164))
  call vert_ZQ_A(gZd,ntry, wf3(:,27), ex1(:), wf6(:,241), n3(:,652), t3x6(:,:,165))
  call vert_ZQ_A(gZd,ntry, wf3(:,28), ex1(:), wf6(:,242), n3(:,653), t3x6(:,:,166))
  call vert_UV_W(ntry, ex4(:), 8, wf3(:,23), 4, wf9(:,34), n3(:,654), t3x9(:,:,34))
  call vert_AZ_Q(gZu,ntry, wf2(:,23), ex4(:), wf6(:,243), n3(:,655), t3x6(:,:,167))
  call vert_AZ_Q(gZu,ntry, wf2(:,24), ex4(:), wf6(:,244), n3(:,656), t3x6(:,:,168))
  call vert_QA_V(ntry, wf4(:,12), wf6(:,8), wf24(:,69), n3(:,657), t3x24(:,:,69))
  call vert_QA_Z(gZd,ntry, wf4(:,12), wf6(:,8), wf24(:,70), n3(:,658), t3x24(:,:,70))
  call vert_QA_V(ntry, wf2(:,3), wf12(:,10), wf24(:,71), n3(:,659), t3x24(:,:,71))
  call vert_QA_Z(gZd,ntry, wf2(:,3), wf12(:,10), wf24(:,72), n3(:,660), t3x24(:,:,72))
  call counter_Q_A_LR_EWs([cONE,cONE],ntry, wf2(:,21), 1, wf2(:,25), n2(235))
  call counter_Q_A_LR_EWs([cONE,cONE],ntry, wf2(:,22), 1, wf2(:,26), n2(236))
  call vert_QA_V(ntry, wf6(:,43), wf4(:,2), wf24(:,73), n3(:,661), t3x24(:,:,73))
  call vert_QA_Z(gZd,ntry, wf6(:,43), wf4(:,2), wf24(:,74), n3(:,662), t3x24(:,:,74))
  call vert_QA_V(ntry, wf2(:,3), wf12(:,16), wf24(:,75), n3(:,663), t3x24(:,:,75))
  call vert_QA_Z(gZd,ntry, wf2(:,3), wf12(:,16), wf24(:,76), n3(:,664), t3x24(:,:,76))
  call vert_AV_Q(ntry, ex2(:), wf3(:,25), wf6(:,245), n3(:,665), t3x6(:,:,169))
  call vert_AV_Q(ntry, ex2(:), wf3(:,26), wf6(:,246), n3(:,666), t3x6(:,:,170))
  call vert_AZ_Q(gZd,ntry, ex2(:), wf3(:,25), wf6(:,247), n3(:,667), t3x6(:,:,171))
  call vert_AZ_Q(gZd,ntry, ex2(:), wf3(:,26), wf6(:,248), n3(:,668), t3x6(:,:,172))
  call vert_UV_W(ntry, wf3(:,22), 8, ex3(:), 4, wf9(:,35), n3(:,669), t3x9(:,:,35))
  call vert_ZQ_A(gZu,ntry, ex3(:), wf2(:,25), wf6(:,249), n3(:,670), t3x6(:,:,173))
  call vert_ZQ_A(gZu,ntry, ex3(:), wf2(:,26), wf6(:,250), n3(:,671), t3x6(:,:,174))
  call vert_VQ_A(ntry, ex5(:), wf2(:,25), wf4(:,51), n3(:,672), t3x4(:,:,29))
  call vert_VQ_A(ntry, ex5(:), wf2(:,26), wf4(:,52), n3(:,673), t3x4(:,:,30))
  call vert_QA_V(ntry, wf4(:,12), wf6(:,4), wf24(:,77), n3(:,674), t3x24(:,:,77))
  call vert_QA_Z(gZd,ntry, wf4(:,12), wf6(:,4), wf24(:,78), n3(:,675), t3x24(:,:,78))
  call vert_QA_V(ntry, wf2(:,3), wf12(:,12), wf24(:,79), n3(:,676), t3x24(:,:,79))
  call vert_QA_Z(gZd,ntry, wf2(:,3), wf12(:,12), wf24(:,80), n3(:,677), t3x24(:,:,80))
  call vert_QA_V(ntry, wf6(:,40), wf4(:,2), wf24(:,81), n3(:,678), t3x24(:,:,81))
  call vert_QA_Z(gZd,ntry, wf6(:,40), wf4(:,2), wf24(:,82), n3(:,679), t3x24(:,:,82))
  call vert_QA_V(ntry, wf2(:,3), wf12(:,14), wf24(:,83), n3(:,680), t3x24(:,:,83))
  call vert_QA_Z(gZd,ntry, wf2(:,3), wf12(:,14), wf24(:,84), n3(:,681), t3x24(:,:,84))
  call vert_AV_Q(ntry, ex2(:), wf3(:,27), wf6(:,251), n3(:,682), t3x6(:,:,175))
  call vert_AV_Q(ntry, ex2(:), wf3(:,28), wf6(:,252), n3(:,683), t3x6(:,:,176))
  call vert_AZ_Q(gZd,ntry, ex2(:), wf3(:,27), wf6(:,253), n3(:,684), t3x6(:,:,177))
  call vert_AZ_Q(gZd,ntry, ex2(:), wf3(:,28), wf6(:,254), n3(:,685), t3x6(:,:,178))
  call vert_UV_W(ntry, wf3(:,24), 4, ex4(:), 8, wf9(:,36), n3(:,686), t3x9(:,:,36))
  call vert_ZQ_A(gZu,ntry, ex4(:), wf2(:,25), wf6(:,255), n3(:,687), t3x6(:,:,179))
  call vert_ZQ_A(gZu,ntry, ex4(:), wf2(:,26), wf6(:,256), n3(:,688), t3x6(:,:,180))
  call counter_A_Q_LR_EWs([ZERO,cONE],ntry, wf2(:,19), 2, wf2(:,27), n2(237))
  call vert_AZ_Q(gZd,ntry, wf2(:,27), ex4(:), wf6(:,257), n3(:,689), t3x6(:,:,181))
  call counter_A_Q_LR_EWs([ZERO,cONE],ntry, wf2(:,20), 2, wf2(:,28), n2(238))
  call vert_AZ_Q(gZd,ntry, wf2(:,28), ex4(:), wf6(:,258), n3(:,690), t3x6(:,:,182))
  call vert_AV_Q(ntry, wf2(:,27), ex5(:), wf4(:,53), n3(:,691), t3x4(:,:,31))
  call vert_AV_Q(ntry, wf2(:,28), ex5(:), wf4(:,54), n3(:,692), t3x4(:,:,32))
  call vert_AZ_Q(gZd,ntry, wf2(:,27), ex3(:), wf6(:,259), n3(:,693), t3x6(:,:,183))
  call vert_AZ_Q(gZd,ntry, wf2(:,28), ex3(:), wf6(:,260), n3(:,694), t3x6(:,:,184))
  call counter_Q_A_LR_EWs([ZERO,cONE],ntry, wf2(:,21), 1, wf2(:,29), n2(239))
  call vert_ZQ_A(gZd,ntry, ex4(:), wf2(:,29), wf6(:,261), n3(:,695), t3x6(:,:,185))
  call counter_Q_A_LR_EWs([ZERO,cONE],ntry, wf2(:,22), 1, wf2(:,30), n2(240))
  call vert_ZQ_A(gZd,ntry, ex4(:), wf2(:,30), wf6(:,262), n3(:,696), t3x6(:,:,186))
  call vert_VQ_A(ntry, ex5(:), wf2(:,29), wf4(:,55), n3(:,697), t3x4(:,:,33))
  call vert_VQ_A(ntry, ex5(:), wf2(:,30), wf4(:,56), n3(:,698), t3x4(:,:,34))
  call vert_ZQ_A(gZd,ntry, ex3(:), wf2(:,29), wf6(:,263), n3(:,699), t3x6(:,:,187))
  call vert_ZQ_A(gZd,ntry, ex3(:), wf2(:,30), wf6(:,264), n3(:,700), t3x6(:,:,188))
  call counter_Q_A_LR_EWs(gZd,ntry, wf2(:,3), 1, wf2(:,31), n2(241))
  call counter_A_Q_LR_EWs(gZd,ntry, wf2(:,1), 2, wf2(:,32), n2(242))
  call vert_ZQ_A(gZd,ntry, ex3(:), wf2(:,31), wf6(:,265), n3(:,701), t3x6(:,:,189))
  call vert_AZ_Q(gZd,ntry, wf2(:,32), ex4(:), wf6(:,266), n3(:,702), t3x6(:,:,190))
  call prop_Q_A(ntry, wf6(:,265), 5, ZERO, 0_intkind1, wf6(:,267), n2(243))
  call prop_A_Q(ntry, wf6(:,266), 10, ZERO, 0_intkind1, wf6(:,268), n2(244))
  call vert_VQ_A(ntry, ex5(:), wf6(:,267), wf12(:,155), n3(:,703), t3x12(:,:,115))
  call counter_Q_A_LR_EWs([cONE,cONE],ntry, wf2(:,7), 1, wf2(:,33), n2(245))
  call vert_ZQ_A(gZd,ntry, ex3(:), wf2(:,33), wf6(:,269), n3(:,704), t3x6(:,:,191))
  call prop_Q_A(ntry, wf6(:,269), 5, ZERO, 0_intkind1, wf6(:,270), n2(246))
  call vert_VQ_A(ntry, ex5(:), wf6(:,270), wf12(:,156), n3(:,705), t3x12(:,:,116))
  call counter_A_Q_LR_EWs([cONE,cONE],ntry, wf2(:,5), 2, wf2(:,34), n2(247))
  call vert_AZ_Q(gZd,ntry, wf2(:,34), ex4(:), wf6(:,271), n3(:,706), t3x6(:,:,192))
  call prop_A_Q(ntry, wf6(:,271), 10, ZERO, 0_intkind1, wf6(:,272), n2(248))
  call vert_AV_Q(ntry, wf2(:,32), ex5(:), wf4(:,57), n3(:,707), t3x4(:,:,35))
  call prop_A_Q(ntry, wf4(:,57), 18, ZERO, 0_intkind1, wf4(:,58), n2(249))
  call vert_ZQ_A(gZd,ntry, ex4(:), wf6(:,267), wf18(:,233), n3(:,708), t3x18(:,:,189))
  call vert_ZQ_A(gZd,ntry, ex4(:), wf6(:,270), wf18(:,234), n3(:,709), t3x18(:,:,190))
  call vert_AV_Q(ntry, wf2(:,34), ex5(:), wf4(:,59), n3(:,710), t3x4(:,:,36))
  call prop_A_Q(ntry, wf4(:,59), 18, ZERO, 0_intkind1, wf4(:,60), n2(250))
  call vert_AZ_Q(gZd,ntry, wf2(:,32), ex3(:), wf6(:,273), n3(:,711), t3x6(:,:,193))
  call vert_ZQ_A(gZd,ntry, ex4(:), wf2(:,31), wf6(:,274), n3(:,712), t3x6(:,:,194))
  call prop_A_Q(ntry, wf6(:,273), 6, ZERO, 0_intkind1, wf6(:,275), n2(251))
  call prop_Q_A(ntry, wf6(:,274), 9, ZERO, 0_intkind1, wf6(:,276), n2(252))
  call vert_AV_Q(ntry, wf6(:,275), ex5(:), wf12(:,157), n3(:,713), t3x12(:,:,117))
  call vert_ZQ_A(gZd,ntry, ex4(:), wf2(:,33), wf6(:,277), n3(:,714), t3x6(:,:,195))
  call prop_Q_A(ntry, wf6(:,277), 9, ZERO, 0_intkind1, wf6(:,278), n2(253))
  call vert_AZ_Q(gZd,ntry, wf2(:,34), ex3(:), wf6(:,279), n3(:,715), t3x6(:,:,196))
  call prop_A_Q(ntry, wf6(:,279), 6, ZERO, 0_intkind1, wf6(:,280), n2(254))
  call vert_AV_Q(ntry, wf6(:,280), ex5(:), wf12(:,158), n3(:,716), t3x12(:,:,118))
  call vert_ZQ_A(gZd,ntry, ex3(:), wf6(:,276), wf18(:,235), n3(:,717), t3x18(:,:,191))
  call vert_ZQ_A(gZd,ntry, ex3(:), wf6(:,278), wf18(:,236), n3(:,718), t3x18(:,:,192))
  call vert_VQ_A(ntry, ex5(:), wf2(:,31), wf4(:,61), n3(:,719), t3x4(:,:,37))
  call prop_Q_A(ntry, wf4(:,61), 17, ZERO, 0_intkind1, wf4(:,62), n2(255))
  call vert_AZ_Q(gZd,ntry, wf6(:,275), ex4(:), wf18(:,237), n3(:,720), t3x18(:,:,193))
  call vert_VQ_A(ntry, ex5(:), wf2(:,33), wf4(:,63), n3(:,721), t3x4(:,:,38))
  call prop_Q_A(ntry, wf4(:,63), 17, ZERO, 0_intkind1, wf4(:,64), n2(256))
  call vert_AZ_Q(gZd,ntry, wf6(:,280), ex4(:), wf18(:,238), n3(:,722), t3x18(:,:,194))
  call vert_AZ_Q(gZd,ntry, wf6(:,268), ex3(:), wf18(:,239), n3(:,723), t3x18(:,:,195))
  call vert_AZ_Q(gZd,ntry, wf6(:,272), ex3(:), wf18(:,240), n3(:,724), t3x18(:,:,196))
  call counter_A_Q_LR_EWs(gZd,ntry, wf2(:,32), 2, wf2(:,35), n2(257))
  call vert_AZ_Q(gZd,ntry, wf2(:,35), ex4(:), wf6(:,281), n3(:,725), t3x6(:,:,197))
  call counter_A_Q_LR_EWs(gZd,ntry, wf2(:,34), 2, wf2(:,36), n2(258))
  call vert_AZ_Q(gZd,ntry, wf2(:,36), ex4(:), wf6(:,282), n3(:,726), t3x6(:,:,198))
  call counter_A_Q_LR_EWs([cONE,cONE],ntry, wf2(:,32), 2, wf2(:,37), n2(259))
  call vert_AZ_Q(gZd,ntry, wf2(:,37), ex4(:), wf6(:,283), n3(:,727), t3x6(:,:,199))
  call counter_A_Q_LR_EWs([cONE,cONE],ntry, wf2(:,34), 2, wf2(:,38), n2(260))
  call vert_AZ_Q(gZd,ntry, wf2(:,38), ex4(:), wf6(:,284), n3(:,728), t3x6(:,:,200))
  call vert_AV_Q(ntry, wf2(:,35), ex5(:), wf4(:,65), n3(:,729), t3x4(:,:,39))
  call vert_AV_Q(ntry, wf2(:,36), ex5(:), wf4(:,66), n3(:,730), t3x4(:,:,40))
  call vert_AV_Q(ntry, wf2(:,37), ex5(:), wf4(:,67), n3(:,731), t3x4(:,:,41))
  call vert_AV_Q(ntry, wf2(:,38), ex5(:), wf4(:,68), n3(:,732), t3x4(:,:,42))
  call vert_AZ_Q(gZd,ntry, wf2(:,35), ex3(:), wf6(:,285), n3(:,733), t3x6(:,:,201))
  call vert_AZ_Q(gZd,ntry, wf2(:,36), ex3(:), wf6(:,286), n3(:,734), t3x6(:,:,202))
  call vert_AZ_Q(gZd,ntry, wf2(:,37), ex3(:), wf6(:,287), n3(:,735), t3x6(:,:,203))
  call vert_AZ_Q(gZd,ntry, wf2(:,38), ex3(:), wf6(:,288), n3(:,736), t3x6(:,:,204))
  call counter_Q_A_LR_EWs(gZd,ntry, wf2(:,31), 1, wf2(:,39), n2(261))
  call vert_ZQ_A(gZd,ntry, ex4(:), wf2(:,39), wf6(:,289), n3(:,737), t3x6(:,:,205))
  call counter_Q_A_LR_EWs(gZd,ntry, wf2(:,33), 1, wf2(:,40), n2(262))
  call vert_ZQ_A(gZd,ntry, ex4(:), wf2(:,40), wf6(:,290), n3(:,738), t3x6(:,:,206))
  call counter_Q_A_LR_EWs([cONE,cONE],ntry, wf2(:,31), 1, wf2(:,41), n2(263))
  call vert_ZQ_A(gZd,ntry, ex4(:), wf2(:,41), wf6(:,291), n3(:,739), t3x6(:,:,207))
  call counter_Q_A_LR_EWs([cONE,cONE],ntry, wf2(:,33), 1, wf2(:,42), n2(264))
  call vert_ZQ_A(gZd,ntry, ex4(:), wf2(:,42), wf6(:,292), n3(:,740), t3x6(:,:,208))
  call vert_VQ_A(ntry, ex5(:), wf2(:,39), wf4(:,69), n3(:,741), t3x4(:,:,43))
  call vert_VQ_A(ntry, ex5(:), wf2(:,40), wf4(:,70), n3(:,742), t3x4(:,:,44))
  call vert_VQ_A(ntry, ex5(:), wf2(:,41), wf4(:,71), n3(:,743), t3x4(:,:,45))
  call vert_VQ_A(ntry, ex5(:), wf2(:,42), wf4(:,72), n3(:,744), t3x4(:,:,46))
  call vert_ZQ_A(gZd,ntry, ex3(:), wf2(:,39), wf6(:,293), n3(:,745), t3x6(:,:,209))
  call vert_ZQ_A(gZd,ntry, ex3(:), wf2(:,40), wf6(:,294), n3(:,746), t3x6(:,:,210))
  call vert_ZQ_A(gZd,ntry, ex3(:), wf2(:,41), wf6(:,295), n3(:,747), t3x6(:,:,211))
  call vert_ZQ_A(gZd,ntry, ex3(:), wf2(:,42), wf6(:,296), n3(:,748), t3x6(:,:,212))
  call vert_AW_Q(ntry, wf2(:,5), wf3(:,5), wf6(:,297), n3(:,749), t3x6(:,:,213))
  call prop_A_Q(ntry, wf6(:,297), 6, ZERO, 0_intkind1, wf6(:,298), n2(265))
  call vert_WQ_A(ntry, wf3(:,3), wf4(:,16), wf12(:,159), n3(:,750), t3x12(:,:,119))
  call vert_AW_Q(ntry, wf2(:,5), wf3(:,1), wf6(:,299), n3(:,751), t3x6(:,:,214))
  call prop_A_Q(ntry, wf6(:,299), 10, ZERO, 0_intkind1, wf6(:,300), n2(266))
  call vert_WQ_A(ntry, wf3(:,7), wf4(:,16), wf12(:,160), n3(:,752), t3x12(:,:,120))
  call vert_QA_V(ntry, wf4(:,16), wf2(:,5), wf8(:,37), n3(:,753), t3x8(:,:,37))
  call vert_QA_Z(gZd,ntry, wf4(:,16), wf2(:,5), wf8(:,38), n3(:,754), t3x8(:,:,38))
  call vert_WQ_A(ntry, wf3(:,7), wf2(:,7), wf6(:,301), n3(:,755), t3x6(:,:,215))
  call prop_Q_A(ntry, wf6(:,301), 5, ZERO, 0_intkind1, wf6(:,302), n2(267))
  call vert_AW_Q(ntry, wf4(:,18), wf3(:,1), wf12(:,161), n3(:,756), t3x12(:,:,121))
  call vert_WQ_A(ntry, wf3(:,3), wf2(:,7), wf6(:,303), n3(:,757), t3x6(:,:,216))
  call prop_Q_A(ntry, wf6(:,303), 9, ZERO, 0_intkind1, wf6(:,304), n2(268))
  call vert_AW_Q(ntry, wf4(:,18), wf3(:,5), wf12(:,162), n3(:,758), t3x12(:,:,122))
  call vert_QA_V(ntry, wf2(:,7), wf4(:,18), wf8(:,39), n3(:,759), t3x8(:,:,39))
  call vert_QA_Z(gZd,ntry, wf2(:,7), wf4(:,18), wf8(:,40), n3(:,760), t3x8(:,:,40))
  call vert_VQ_A(ntry, ex5(:), wf6(:,302), wf12(:,163), n3(:,761), t3x12(:,:,123))
  call vert_VQ_A(ntry, ex5(:), wf6(:,304), wf12(:,164), n3(:,762), t3x12(:,:,124))
  call vert_AW_Q(ntry, wf2(:,5), wf3(:,18), wf6(:,305), n3(:,763), t3x6(:,:,217))
  call vert_QA_V(ntry, wf4(:,4), wf2(:,5), wf8(:,41), n3(:,764), t3x8(:,:,41))
  call vert_QA_Z(gZd,ntry, wf4(:,4), wf2(:,5), wf8(:,42), n3(:,765), t3x8(:,:,42))
  call vert_AW_Q(ntry, wf2(:,5), wf3(:,20), wf6(:,306), n3(:,766), t3x6(:,:,218))
  call vert_QA_V(ntry, ex1(:), wf4(:,18), wf8(:,43), n3(:,767), t3x8(:,:,43))
  call vert_QA_Z(gZd,ntry, ex1(:), wf4(:,18), wf8(:,44), n3(:,768), t3x8(:,:,44))
  call vert_AV_Q(ntry, wf6(:,298), ex5(:), wf12(:,165), n3(:,769), t3x12(:,:,125))
  call vert_AV_Q(ntry, wf6(:,300), ex5(:), wf12(:,166), n3(:,770), t3x12(:,:,126))
  call vert_WQ_A(ntry, wf3(:,17), wf2(:,7), wf6(:,307), n3(:,771), t3x6(:,:,219))
  call vert_QA_V(ntry, wf2(:,7), wf4(:,2), wf8(:,45), n3(:,772), t3x8(:,:,45))
  call vert_QA_Z(gZd,ntry, wf2(:,7), wf4(:,2), wf8(:,46), n3(:,773), t3x8(:,:,46))
  call vert_WQ_A(ntry, wf3(:,19), wf2(:,7), wf6(:,308), n3(:,774), t3x6(:,:,220))
  call vert_QA_V(ntry, wf4(:,16), ex2(:), wf8(:,47), n3(:,775), t3x8(:,:,47))
  call vert_QA_Z(gZd,ntry, wf4(:,16), ex2(:), wf8(:,48), n3(:,776), t3x8(:,:,48))
  call vert_WQ_A(ntry, wf3(:,17), wf6(:,51), wf18(:,241), n3(:,777), t3x18(:,:,197))
  call counter_A_Q_LR_EWs(gZu,ntry, wf2(:,9), 2, wf2(:,43), n2(269))
  call vert_AV_Q(ntry, wf2(:,43), ex5(:), wf4(:,73), n3(:,778), t3x4(:,:,47))
  call vert_WQ_A(ntry, wf3(:,3), wf6(:,51), wf18(:,242), n3(:,779), t3x18(:,:,198))
  call prop_A_Q(ntry, wf4(:,73), 18, ZERO, 0_intkind1, wf4(:,74), n2(270))
  call counter_A_Q_LR_EWs([ZERO,cONE],ntry, wf2(:,5), 2, wf2(:,44), n2(271))
  call vert_AV_Q(ntry, wf2(:,44), ex5(:), wf4(:,75), n3(:,780), t3x4(:,:,48))
  call prop_A_Q(ntry, wf4(:,75), 18, ZERO, 0_intkind1, wf4(:,76), n2(272))
  call vert_AW_Q(ntry, wf2(:,43), wf3(:,3), wf6(:,309), n3(:,781), t3x6(:,:,221))
  call vert_AW_Q(ntry, wf2(:,44), wf3(:,3), wf6(:,310), n3(:,782), t3x6(:,:,222))
  call vert_AW_Q(ntry, wf6(:,47), wf3(:,18), wf18(:,243), n3(:,783), t3x18(:,:,199))
  call vert_QA_W(ntry, wf4(:,22), wf2(:,5), wf8(:,49), n3(:,784), t3x8(:,:,49))
  call vert_QA_W(ntry, wf4(:,16), wf2(:,9), wf8(:,50), n3(:,785), t3x8(:,:,50))
  call vert_AW_Q(ntry, wf2(:,43), wf9(:,3), wf18(:,244), n3(:,786), t3x18(:,:,200))
  call vert_AW_Q(ntry, wf2(:,44), wf9(:,3), wf18(:,245), n3(:,787), t3x18(:,:,201))
  call vert_AZ_Q(gZu,ntry, wf2(:,43), ex3(:), wf6(:,311), n3(:,788), t3x6(:,:,223))
  call prop_A_Q(ntry, wf6(:,311), 6, ZERO, 0_intkind1, wf6(:,312), n2(273))
  call vert_AZ_Q(gZu,ntry, wf2(:,44), ex3(:), wf6(:,313), n3(:,789), t3x6(:,:,224))
  call prop_A_Q(ntry, wf6(:,313), 6, ZERO, 0_intkind1, wf6(:,314), n2(274))
  call vert_QA_W(ntry, wf2(:,11), wf4(:,18), wf8(:,51), n3(:,790), t3x8(:,:,51))
  call vert_QA_W(ntry, wf2(:,7), wf4(:,20), wf8(:,52), n3(:,791), t3x8(:,:,52))
  call vert_WQ_A(ntry, wf9(:,3), wf2(:,7), wf18(:,246), n3(:,792), t3x18(:,:,202))
  call vert_ZQ_A(gZu,ntry, ex3(:), wf6(:,304), wf18(:,247), n3(:,793), t3x18(:,:,203))
  call prop_Q_A(ntry, wf18(:,247), 13, ZERO, 0_intkind1, wf18(:,248), n2(275))
  call counter_Q_A_LR_EWs(gZu,ntry, wf2(:,11), 1, wf2(:,45), n2(276))
  call vert_VQ_A(ntry, ex5(:), wf2(:,45), wf4(:,77), n3(:,794), t3x4(:,:,49))
  call vert_AW_Q(ntry, wf6(:,47), wf3(:,1), wf18(:,249), n3(:,795), t3x18(:,:,204))
  call prop_Q_A(ntry, wf4(:,77), 17, ZERO, 0_intkind1, wf4(:,78), n2(277))
  call counter_Q_A_LR_EWs([ZERO,cONE],ntry, wf2(:,7), 1, wf2(:,46), n2(278))
  call vert_VQ_A(ntry, ex5(:), wf2(:,46), wf4(:,79), n3(:,796), t3x4(:,:,50))
  call prop_Q_A(ntry, wf4(:,79), 17, ZERO, 0_intkind1, wf4(:,80), n2(279))
  call vert_WQ_A(ntry, wf3(:,1), wf2(:,45), wf6(:,315), n3(:,797), t3x6(:,:,225))
  call vert_WQ_A(ntry, wf3(:,1), wf2(:,46), wf6(:,316), n3(:,798), t3x6(:,:,226))
  call vert_WQ_A(ntry, wf9(:,5), wf2(:,45), wf18(:,250), n3(:,799), t3x18(:,:,205))
  call vert_WQ_A(ntry, wf9(:,5), wf2(:,46), wf18(:,251), n3(:,800), t3x18(:,:,206))
  call vert_ZQ_A(gZu,ntry, ex3(:), wf2(:,45), wf6(:,317), n3(:,801), t3x6(:,:,227))
  call prop_Q_A(ntry, wf6(:,317), 5, ZERO, 0_intkind1, wf6(:,318), n2(280))
  call vert_ZQ_A(gZu,ntry, ex3(:), wf2(:,46), wf6(:,319), n3(:,802), t3x6(:,:,228))
  call prop_Q_A(ntry, wf6(:,319), 5, ZERO, 0_intkind1, wf6(:,320), n2(281))
  call vert_AW_Q(ntry, wf2(:,5), wf9(:,5), wf18(:,252), n3(:,803), t3x18(:,:,207))
  call vert_AZ_Q(gZu,ntry, wf6(:,300), ex3(:), wf18(:,253), n3(:,804), t3x18(:,:,208))
  call prop_A_Q(ntry, wf18(:,253), 14, ZERO, 0_intkind1, wf18(:,254), n2(282))
  call vert_WQ_A(ntry, wf3(:,19), wf6(:,48), wf18(:,255), n3(:,805), t3x18(:,:,209))
  call vert_WQ_A(ntry, wf3(:,7), wf6(:,48), wf18(:,256), n3(:,806), t3x18(:,:,210))
  call vert_AW_Q(ntry, wf2(:,43), wf3(:,7), wf6(:,321), n3(:,807), t3x6(:,:,229))
  call vert_AW_Q(ntry, wf2(:,44), wf3(:,7), wf6(:,322), n3(:,808), t3x6(:,:,230))
  call vert_AW_Q(ntry, wf6(:,52), wf3(:,20), wf18(:,257), n3(:,809), t3x18(:,:,211))
  call vert_AW_Q(ntry, wf2(:,43), wf9(:,4), wf18(:,258), n3(:,810), t3x18(:,:,212))
  call vert_AW_Q(ntry, wf2(:,44), wf9(:,4), wf18(:,259), n3(:,811), t3x18(:,:,213))
  call vert_AZ_Q(gZu,ntry, wf2(:,43), ex4(:), wf6(:,323), n3(:,812), t3x6(:,:,231))
  call prop_A_Q(ntry, wf6(:,323), 10, ZERO, 0_intkind1, wf6(:,324), n2(283))
  call vert_AZ_Q(gZu,ntry, wf2(:,44), ex4(:), wf6(:,325), n3(:,813), t3x6(:,:,232))
  call prop_A_Q(ntry, wf6(:,325), 10, ZERO, 0_intkind1, wf6(:,326), n2(284))
  call vert_WQ_A(ntry, wf9(:,4), wf2(:,7), wf18(:,260), n3(:,814), t3x18(:,:,214))
  call vert_ZQ_A(gZu,ntry, ex4(:), wf6(:,302), wf18(:,261), n3(:,815), t3x18(:,:,215))
  call prop_Q_A(ntry, wf18(:,261), 13, ZERO, 0_intkind1, wf18(:,262), n2(285))
  call vert_AW_Q(ntry, wf6(:,52), wf3(:,5), wf18(:,263), n3(:,816), t3x18(:,:,216))
  call vert_WQ_A(ntry, wf3(:,5), wf2(:,45), wf6(:,327), n3(:,817), t3x6(:,:,233))
  call vert_WQ_A(ntry, wf3(:,5), wf2(:,46), wf6(:,328), n3(:,818), t3x6(:,:,234))
  call vert_WQ_A(ntry, wf9(:,6), wf2(:,45), wf18(:,264), n3(:,819), t3x18(:,:,217))
  call vert_WQ_A(ntry, wf9(:,6), wf2(:,46), wf18(:,265), n3(:,820), t3x18(:,:,218))
  call vert_ZQ_A(gZu,ntry, ex4(:), wf2(:,45), wf6(:,329), n3(:,821), t3x6(:,:,235))
  call prop_Q_A(ntry, wf6(:,329), 9, ZERO, 0_intkind1, wf6(:,330), n2(286))
  call vert_ZQ_A(gZu,ntry, ex4(:), wf2(:,46), wf6(:,331), n3(:,822), t3x6(:,:,236))
  call prop_Q_A(ntry, wf6(:,331), 9, ZERO, 0_intkind1, wf6(:,332), n2(287))
  call vert_AW_Q(ntry, wf2(:,5), wf9(:,6), wf18(:,266), n3(:,823), t3x18(:,:,219))
  call vert_AZ_Q(gZu,ntry, wf6(:,298), ex4(:), wf18(:,267), n3(:,824), t3x18(:,:,220))
  call prop_A_Q(ntry, wf18(:,267), 14, ZERO, 0_intkind1, wf18(:,268), n2(288))
  call vert_AW_Q(ntry, wf2(:,43), wf3(:,17), wf6(:,333), n3(:,825), t3x6(:,:,237))
  call vert_AW_Q(ntry, wf2(:,44), wf3(:,17), wf6(:,334), n3(:,826), t3x6(:,:,238))
  call vert_QA_W(ntry, wf4(:,4), wf2(:,43), wf8(:,53), n3(:,827), t3x8(:,:,53))
  call vert_QA_W(ntry, wf4(:,4), wf2(:,44), wf8(:,54), n3(:,828), t3x8(:,:,54))
  call vert_AW_Q(ntry, wf2(:,43), wf3(:,19), wf6(:,335), n3(:,829), t3x6(:,:,239))
  call vert_AW_Q(ntry, wf2(:,44), wf3(:,19), wf6(:,336), n3(:,830), t3x6(:,:,240))
  call vert_WQ_A(ntry, wf3(:,18), wf2(:,45), wf6(:,337), n3(:,831), t3x6(:,:,241))
  call vert_WQ_A(ntry, wf3(:,18), wf2(:,46), wf6(:,338), n3(:,832), t3x6(:,:,242))
  call vert_QA_W(ntry, wf2(:,45), wf4(:,2), wf8(:,55), n3(:,833), t3x8(:,:,55))
  call vert_QA_W(ntry, wf2(:,46), wf4(:,2), wf8(:,56), n3(:,834), t3x8(:,:,56))
  call vert_WQ_A(ntry, wf3(:,20), wf2(:,45), wf6(:,339), n3(:,835), t3x6(:,:,243))
  call vert_WQ_A(ntry, wf3(:,20), wf2(:,46), wf6(:,340), n3(:,836), t3x6(:,:,244))
  call vert_VQ_A(ntry, ex5(:), wf6(:,318), wf12(:,167), n3(:,837), t3x12(:,:,127))
  call vert_VQ_A(ntry, ex5(:), wf6(:,320), wf12(:,168), n3(:,838), t3x12(:,:,128))
  call vert_ZQ_A(gZu,ntry, ex4(:), wf6(:,318), wf18(:,269), n3(:,839), t3x18(:,:,221))
  call vert_ZQ_A(gZu,ntry, ex4(:), wf6(:,320), wf18(:,270), n3(:,840), t3x18(:,:,222))
  call vert_AV_Q(ntry, wf6(:,312), ex5(:), wf12(:,169), n3(:,841), t3x12(:,:,129))
  call vert_AV_Q(ntry, wf6(:,314), ex5(:), wf12(:,170), n3(:,842), t3x12(:,:,130))
  call vert_ZQ_A(gZu,ntry, ex3(:), wf6(:,330), wf18(:,271), n3(:,843), t3x18(:,:,223))
  call vert_ZQ_A(gZu,ntry, ex3(:), wf6(:,332), wf18(:,272), n3(:,844), t3x18(:,:,224))
  call vert_AZ_Q(gZu,ntry, wf6(:,312), ex4(:), wf18(:,273), n3(:,845), t3x18(:,:,225))
  call vert_AZ_Q(gZu,ntry, wf6(:,314), ex4(:), wf18(:,274), n3(:,846), t3x18(:,:,226))
  call vert_AZ_Q(gZu,ntry, wf6(:,324), ex3(:), wf18(:,275), n3(:,847), t3x18(:,:,227))
  call vert_AZ_Q(gZu,ntry, wf6(:,326), ex3(:), wf18(:,276), n3(:,848), t3x18(:,:,228))
  call vert_QA_V(ntry, wf6(:,3), wf4(:,18), wf24(:,85), n3(:,849), t3x24(:,:,85))
  call vert_QA_Z(gZd,ntry, wf6(:,3), wf4(:,18), wf24(:,86), n3(:,850), t3x24(:,:,86))
  call vert_QA_V(ntry, wf12(:,5), wf2(:,5), wf24(:,87), n3(:,851), t3x24(:,:,87))
  call vert_QA_Z(gZd,ntry, wf12(:,5), wf2(:,5), wf24(:,88), n3(:,852), t3x24(:,:,88))
  call counter_A_Q_LR_EWs(gZu,ntry, wf2(:,43), 2, wf2(:,47), n2(289))
  call counter_A_Q_LR_EWs(gZu,ntry, wf2(:,44), 2, wf2(:,48), n2(290))
  call vert_QA_V(ntry, wf4(:,4), wf6(:,47), wf24(:,89), n3(:,853), t3x24(:,:,89))
  call vert_QA_Z(gZd,ntry, wf4(:,4), wf6(:,47), wf24(:,90), n3(:,854), t3x24(:,:,90))
  call vert_QA_V(ntry, wf12(:,8), wf2(:,5), wf24(:,91), n3(:,855), t3x24(:,:,91))
  call vert_QA_Z(gZd,ntry, wf12(:,8), wf2(:,5), wf24(:,92), n3(:,856), t3x24(:,:,92))
  call vert_AZ_Q(gZu,ntry, wf2(:,47), ex3(:), wf6(:,341), n3(:,857), t3x6(:,:,245))
  call vert_AZ_Q(gZu,ntry, wf2(:,48), ex3(:), wf6(:,342), n3(:,858), t3x6(:,:,246))
  call vert_AV_Q(ntry, wf2(:,47), ex5(:), wf4(:,81), n3(:,859), t3x4(:,:,51))
  call vert_AV_Q(ntry, wf2(:,48), ex5(:), wf4(:,82), n3(:,860), t3x4(:,:,52))
  call vert_QA_V(ntry, wf6(:,7), wf4(:,18), wf24(:,93), n3(:,861), t3x24(:,:,93))
  call vert_QA_Z(gZd,ntry, wf6(:,7), wf4(:,18), wf24(:,94), n3(:,862), t3x24(:,:,94))
  call vert_QA_V(ntry, wf12(:,6), wf2(:,5), wf24(:,95), n3(:,863), t3x24(:,:,95))
  call vert_QA_Z(gZd,ntry, wf12(:,6), wf2(:,5), wf24(:,96), n3(:,864), t3x24(:,:,96))
  call vert_QA_V(ntry, wf4(:,4), wf6(:,52), wf24(:,97), n3(:,865), t3x24(:,:,97))
  call vert_QA_Z(gZd,ntry, wf4(:,4), wf6(:,52), wf24(:,98), n3(:,866), t3x24(:,:,98))
  call vert_QA_V(ntry, wf12(:,7), wf2(:,5), wf24(:,99), n3(:,867), t3x24(:,:,99))
  call vert_QA_Z(gZd,ntry, wf12(:,7), wf2(:,5), wf24(:,100), n3(:,868), t3x24(:,:,100))
  call vert_AZ_Q(gZu,ntry, wf2(:,47), ex4(:), wf6(:,343), n3(:,869), t3x6(:,:,247))
  call vert_AZ_Q(gZu,ntry, wf2(:,48), ex4(:), wf6(:,344), n3(:,870), t3x6(:,:,248))
  call vert_QA_V(ntry, wf4(:,16), wf6(:,8), wf24(:,101), n3(:,871), t3x24(:,:,101))
  call vert_QA_Z(gZd,ntry, wf4(:,16), wf6(:,8), wf24(:,102), n3(:,872), t3x24(:,:,102))
  call vert_QA_V(ntry, wf2(:,7), wf12(:,10), wf24(:,103), n3(:,873), t3x24(:,:,103))
  call vert_QA_Z(gZd,ntry, wf2(:,7), wf12(:,10), wf24(:,104), n3(:,874), t3x24(:,:,104))
  call counter_Q_A_LR_EWs(gZu,ntry, wf2(:,45), 1, wf2(:,49), n2(291))
  call counter_Q_A_LR_EWs(gZu,ntry, wf2(:,46), 1, wf2(:,50), n2(292))
  call vert_QA_V(ntry, wf6(:,51), wf4(:,2), wf24(:,105), n3(:,875), t3x24(:,:,105))
  call vert_QA_Z(gZd,ntry, wf6(:,51), wf4(:,2), wf24(:,106), n3(:,876), t3x24(:,:,106))
  call vert_QA_V(ntry, wf2(:,7), wf12(:,16), wf24(:,107), n3(:,877), t3x24(:,:,107))
  call vert_QA_Z(gZd,ntry, wf2(:,7), wf12(:,16), wf24(:,108), n3(:,878), t3x24(:,:,108))
  call vert_ZQ_A(gZu,ntry, ex3(:), wf2(:,49), wf6(:,345), n3(:,879), t3x6(:,:,249))
  call vert_ZQ_A(gZu,ntry, ex3(:), wf2(:,50), wf6(:,346), n3(:,880), t3x6(:,:,250))
  call vert_VQ_A(ntry, ex5(:), wf2(:,49), wf4(:,83), n3(:,881), t3x4(:,:,53))
  call vert_VQ_A(ntry, ex5(:), wf2(:,50), wf4(:,84), n3(:,882), t3x4(:,:,54))
  call vert_QA_V(ntry, wf4(:,16), wf6(:,4), wf24(:,109), n3(:,883), t3x24(:,:,109))
  call vert_QA_Z(gZd,ntry, wf4(:,16), wf6(:,4), wf24(:,110), n3(:,884), t3x24(:,:,110))
  call vert_QA_V(ntry, wf2(:,7), wf12(:,12), wf24(:,111), n3(:,885), t3x24(:,:,111))
  call vert_QA_Z(gZd,ntry, wf2(:,7), wf12(:,12), wf24(:,112), n3(:,886), t3x24(:,:,112))
  call vert_QA_V(ntry, wf6(:,48), wf4(:,2), wf24(:,113), n3(:,887), t3x24(:,:,113))
  call vert_QA_Z(gZd,ntry, wf6(:,48), wf4(:,2), wf24(:,114), n3(:,888), t3x24(:,:,114))
  call vert_QA_V(ntry, wf2(:,7), wf12(:,14), wf24(:,115), n3(:,889), t3x24(:,:,115))
  call vert_QA_Z(gZd,ntry, wf2(:,7), wf12(:,14), wf24(:,116), n3(:,890), t3x24(:,:,116))
  call vert_ZQ_A(gZu,ntry, ex4(:), wf2(:,49), wf6(:,347), n3(:,891), t3x6(:,:,251))
  call vert_ZQ_A(gZu,ntry, ex4(:), wf2(:,50), wf6(:,348), n3(:,892), t3x6(:,:,252))
  call counter_A_Q_LR_EWs([ZERO,cONE],ntry, wf2(:,43), 2, wf2(:,51), n2(293))
  call vert_AZ_Q(gZd,ntry, wf2(:,51), ex4(:), wf6(:,349), n3(:,893), t3x6(:,:,253))
  call counter_A_Q_LR_EWs([ZERO,cONE],ntry, wf2(:,44), 2, wf2(:,52), n2(294))
  call vert_AZ_Q(gZd,ntry, wf2(:,52), ex4(:), wf6(:,350), n3(:,894), t3x6(:,:,254))
  call vert_AV_Q(ntry, wf2(:,51), ex5(:), wf4(:,85), n3(:,895), t3x4(:,:,55))
  call vert_AV_Q(ntry, wf2(:,52), ex5(:), wf4(:,86), n3(:,896), t3x4(:,:,56))
  call vert_AZ_Q(gZd,ntry, wf2(:,51), ex3(:), wf6(:,351), n3(:,897), t3x6(:,:,255))
  call vert_AZ_Q(gZd,ntry, wf2(:,52), ex3(:), wf6(:,352), n3(:,898), t3x6(:,:,256))
  call counter_Q_A_LR_EWs([ZERO,cONE],ntry, wf2(:,45), 1, wf2(:,53), n2(295))
  call vert_ZQ_A(gZd,ntry, ex4(:), wf2(:,53), wf6(:,353), n3(:,899), t3x6(:,:,257))
  call counter_Q_A_LR_EWs([ZERO,cONE],ntry, wf2(:,46), 1, wf2(:,54), n2(296))
  call vert_ZQ_A(gZd,ntry, ex4(:), wf2(:,54), wf6(:,354), n3(:,900), t3x6(:,:,258))
  call vert_VQ_A(ntry, ex5(:), wf2(:,53), wf4(:,87), n3(:,901), t3x4(:,:,57))
  call vert_VQ_A(ntry, ex5(:), wf2(:,54), wf4(:,88), n3(:,902), t3x4(:,:,58))
  call vert_ZQ_A(gZd,ntry, ex3(:), wf2(:,53), wf6(:,355), n3(:,903), t3x6(:,:,259))
  call vert_ZQ_A(gZd,ntry, ex3(:), wf2(:,54), wf6(:,356), n3(:,904), t3x6(:,:,260))
  call vert_VQ_A(ntry, wf3(:,4), wf2(:,3), wf6(:,357), n3(:,905), t3x6(:,:,261))
  call vert_VQ_A(ntry, wf3(:,2), wf2(:,3), wf6(:,358), n3(:,906), t3x6(:,:,262))
  call vert_ZQ_A(gZd,ntry, wf3(:,4), wf2(:,3), wf6(:,359), n3(:,907), t3x6(:,:,263))
  call vert_ZQ_A(gZd,ntry, wf3(:,2), wf2(:,3), wf6(:,360), n3(:,908), t3x6(:,:,264))
  call vert_VQ_A(ntry, wf3(:,8), wf2(:,3), wf6(:,361), n3(:,909), t3x6(:,:,265))
  call vert_VQ_A(ntry, wf3(:,6), wf2(:,3), wf6(:,362), n3(:,910), t3x6(:,:,266))
  call vert_ZQ_A(gZd,ntry, wf3(:,8), wf2(:,3), wf6(:,363), n3(:,911), t3x6(:,:,267))
  call vert_ZQ_A(gZd,ntry, wf3(:,6), wf2(:,3), wf6(:,364), n3(:,912), t3x6(:,:,268))
  call vert_AV_Q(ntry, wf2(:,1), wf3(:,4), wf6(:,365), n3(:,913), t3x6(:,:,269))
  call vert_AV_Q(ntry, wf2(:,1), wf3(:,2), wf6(:,366), n3(:,914), t3x6(:,:,270))
  call vert_AZ_Q(gZd,ntry, wf2(:,1), wf3(:,4), wf6(:,367), n3(:,915), t3x6(:,:,271))
  call vert_AZ_Q(gZd,ntry, wf2(:,1), wf3(:,2), wf6(:,368), n3(:,916), t3x6(:,:,272))
  call vert_AV_Q(ntry, wf2(:,1), wf3(:,8), wf6(:,369), n3(:,917), t3x6(:,:,273))
  call vert_AV_Q(ntry, wf2(:,1), wf3(:,6), wf6(:,370), n3(:,918), t3x6(:,:,274))
  call vert_AZ_Q(gZd,ntry, wf2(:,1), wf3(:,8), wf6(:,371), n3(:,919), t3x6(:,:,275))
  call vert_AZ_Q(gZd,ntry, wf2(:,1), wf3(:,6), wf6(:,372), n3(:,920), t3x6(:,:,276))
  call vert_VQ_A(ntry, wf3(:,4), wf2(:,7), wf6(:,373), n3(:,921), t3x6(:,:,277))
  call vert_VQ_A(ntry, wf3(:,2), wf2(:,7), wf6(:,374), n3(:,922), t3x6(:,:,278))
  call vert_ZQ_A(gZd,ntry, wf3(:,4), wf2(:,7), wf6(:,375), n3(:,923), t3x6(:,:,279))
  call vert_ZQ_A(gZd,ntry, wf3(:,2), wf2(:,7), wf6(:,376), n3(:,924), t3x6(:,:,280))
  call vert_VQ_A(ntry, wf3(:,8), wf2(:,7), wf6(:,377), n3(:,925), t3x6(:,:,281))
  call vert_VQ_A(ntry, wf3(:,6), wf2(:,7), wf6(:,378), n3(:,926), t3x6(:,:,282))
  call vert_ZQ_A(gZd,ntry, wf3(:,8), wf2(:,7), wf6(:,379), n3(:,927), t3x6(:,:,283))
  call vert_ZQ_A(gZd,ntry, wf3(:,6), wf2(:,7), wf6(:,380), n3(:,928), t3x6(:,:,284))
  call vert_AV_Q(ntry, wf2(:,5), wf3(:,4), wf6(:,381), n3(:,929), t3x6(:,:,285))
  call vert_AV_Q(ntry, wf2(:,5), wf3(:,2), wf6(:,382), n3(:,930), t3x6(:,:,286))
  call vert_AZ_Q(gZd,ntry, wf2(:,5), wf3(:,4), wf6(:,383), n3(:,931), t3x6(:,:,287))
  call vert_AZ_Q(gZd,ntry, wf2(:,5), wf3(:,2), wf6(:,384), n3(:,932), t3x6(:,:,288))
  call vert_AV_Q(ntry, wf2(:,5), wf3(:,8), wf6(:,385), n3(:,933), t3x6(:,:,289))
  call vert_AV_Q(ntry, wf2(:,5), wf3(:,6), wf6(:,386), n3(:,934), t3x6(:,:,290))
  call vert_AZ_Q(gZd,ntry, wf2(:,5), wf3(:,8), wf6(:,387), n3(:,935), t3x6(:,:,291))
  call vert_AZ_Q(gZd,ntry, wf2(:,5), wf3(:,6), wf6(:,388), n3(:,936), t3x6(:,:,292))
  call counter_A_Q_LR_EWs([ZERO,cONE],ntry, wf2(:,2), 2, wf2(:,55), n2(297))
  call vert_AZ_Q(gZu,ntry, wf2(:,55), ex3(:), wf6(:,389), n3(:,937), t3x6(:,:,293))
  call vert_AV_Q(ntry, wf2(:,55), ex5(:), wf4(:,89), n3(:,938), t3x4(:,:,59))
  call vert_AZ_Q(gZu,ntry, wf2(:,55), ex4(:), wf6(:,390), n3(:,939), t3x6(:,:,294))
  call counter_Q_A_LR_EWs([ZERO,cONE],ntry, wf2(:,4), 1, wf2(:,56), n2(298))
  call vert_ZQ_A(gZu,ntry, ex3(:), wf2(:,56), wf6(:,391), n3(:,940), t3x6(:,:,295))
  call vert_VQ_A(ntry, ex5(:), wf2(:,56), wf4(:,90), n3(:,941), t3x4(:,:,60))
  call vert_ZQ_A(gZu,ntry, ex4(:), wf2(:,56), wf6(:,392), n3(:,942), t3x6(:,:,296))
  call counter_A_Q_LR_EWs([cONE,cONE],ntry, wf2(:,10), 2, wf2(:,57), n2(299))
  call vert_AZ_Q(gZd,ntry, wf2(:,57), ex4(:), wf6(:,393), n3(:,943), t3x6(:,:,297))
  call vert_AV_Q(ntry, wf2(:,57), ex5(:), wf4(:,91), n3(:,944), t3x4(:,:,61))
  call vert_AZ_Q(gZd,ntry, wf2(:,57), ex3(:), wf6(:,394), n3(:,945), t3x6(:,:,298))
  call counter_Q_A_LR_EWs([cONE,cONE],ntry, wf2(:,12), 1, wf2(:,58), n2(300))
  call vert_ZQ_A(gZd,ntry, ex4(:), wf2(:,58), wf6(:,395), n3(:,946), t3x6(:,:,299))
  call vert_VQ_A(ntry, ex5(:), wf2(:,58), wf4(:,92), n3(:,947), t3x4(:,:,62))
  call vert_ZQ_A(gZd,ntry, ex3(:), wf2(:,58), wf6(:,396), n3(:,948), t3x6(:,:,300))
  call counter_A_Q_LR_EWs([ZERO,cONE],ntry, wf2(:,6), 2, wf2(:,59), n2(301))
  call vert_AZ_Q(gZu,ntry, wf2(:,59), ex3(:), wf6(:,397), n3(:,949), t3x6(:,:,301))
  call vert_AV_Q(ntry, wf2(:,59), ex5(:), wf4(:,93), n3(:,950), t3x4(:,:,63))
  call vert_AZ_Q(gZu,ntry, wf2(:,59), ex4(:), wf6(:,398), n3(:,951), t3x6(:,:,302))
  call counter_Q_A_LR_EWs([ZERO,cONE],ntry, wf2(:,8), 1, wf2(:,60), n2(302))
  call vert_ZQ_A(gZu,ntry, ex3(:), wf2(:,60), wf6(:,399), n3(:,952), t3x6(:,:,303))
  call vert_VQ_A(ntry, ex5(:), wf2(:,60), wf4(:,94), n3(:,953), t3x4(:,:,64))
  call vert_ZQ_A(gZu,ntry, ex4(:), wf2(:,60), wf6(:,400), n3(:,954), t3x6(:,:,304))
  call counter_A_Q_LR_EWs(gZd,ntry, wf2(:,10), 2, wf2(:,61), n2(303))
  call vert_AZ_Q(gZd,ntry, wf2(:,61), ex4(:), wf6(:,401), n3(:,955), t3x6(:,:,305))
  call vert_AV_Q(ntry, wf2(:,61), ex5(:), wf4(:,95), n3(:,956), t3x4(:,:,65))
  call vert_AZ_Q(gZd,ntry, wf2(:,61), ex3(:), wf6(:,402), n3(:,957), t3x6(:,:,306))
  call counter_Q_A_LR_EWs(gZd,ntry, wf2(:,12), 1, wf2(:,62), n2(304))
  call vert_ZQ_A(gZd,ntry, ex4(:), wf2(:,62), wf6(:,403), n3(:,958), t3x6(:,:,307))
  call vert_VQ_A(ntry, ex5(:), wf2(:,62), wf4(:,96), n3(:,959), t3x4(:,:,66))
  call vert_ZQ_A(gZd,ntry, ex3(:), wf2(:,62), wf6(:,404), n3(:,960), t3x6(:,:,308))
  call counter_A_Q_LR_EWs(gZd,ntry, wf2(:,2), 2, wf2(:,63), n2(305))
  call vert_AZ_Q(gZd,ntry, wf2(:,63), ex4(:), wf6(:,405), n3(:,961), t3x6(:,:,309))
  call counter_A_Q_LR_EWs([cONE,cONE],ntry, wf2(:,6), 2, wf2(:,64), n2(306))
  call vert_AZ_Q(gZd,ntry, wf2(:,64), ex4(:), wf6(:,406), n3(:,962), t3x6(:,:,310))
  call vert_AV_Q(ntry, wf2(:,63), ex5(:), wf4(:,97), n3(:,963), t3x4(:,:,67))
  call vert_AV_Q(ntry, wf2(:,64), ex5(:), wf4(:,98), n3(:,964), t3x4(:,:,68))
  call vert_AZ_Q(gZd,ntry, wf2(:,63), ex3(:), wf6(:,407), n3(:,965), t3x6(:,:,311))
  call vert_AZ_Q(gZd,ntry, wf2(:,64), ex3(:), wf6(:,408), n3(:,966), t3x6(:,:,312))
  call counter_Q_A_LR_EWs(gZd,ntry, wf2(:,4), 1, wf2(:,65), n2(307))
  call vert_ZQ_A(gZd,ntry, ex4(:), wf2(:,65), wf6(:,409), n3(:,967), t3x6(:,:,313))
  call counter_Q_A_LR_EWs([cONE,cONE],ntry, wf2(:,8), 1, wf2(:,66), n2(308))
  call vert_ZQ_A(gZd,ntry, ex4(:), wf2(:,66), wf6(:,410), n3(:,968), t3x6(:,:,314))
  call vert_VQ_A(ntry, ex5(:), wf2(:,65), wf4(:,99), n3(:,969), t3x4(:,:,69))
  call vert_VQ_A(ntry, ex5(:), wf2(:,66), wf4(:,100), n3(:,970), t3x4(:,:,70))
  call vert_ZQ_A(gZd,ntry, ex3(:), wf2(:,65), wf6(:,411), n3(:,971), t3x6(:,:,315))
  call vert_ZQ_A(gZd,ntry, ex3(:), wf2(:,66), wf6(:,412), n3(:,972), t3x6(:,:,316))
  call vert_QA_V(ntry, wf4(:,4), wf2(:,2), wf8(:,57), n3(:,973), t3x8(:,:,57))
  call vert_QA_Z(gZd,ntry, wf4(:,4), wf2(:,2), wf8(:,58), n3(:,974), t3x8(:,:,58))
  call vert_AW_Q(ntry, wf2(:,2), wf3(:,5), wf6(:,413), n3(:,975), t3x6(:,:,317))
  call vert_AW_Q(ntry, wf2(:,2), wf3(:,1), wf6(:,414), n3(:,976), t3x6(:,:,318))
  call vert_QA_V(ntry, wf2(:,4), wf4(:,2), wf8(:,59), n3(:,977), t3x8(:,:,59))
  call vert_QA_Z(gZd,ntry, wf2(:,4), wf4(:,2), wf8(:,60), n3(:,978), t3x8(:,:,60))
  call vert_WQ_A(ntry, wf3(:,7), wf2(:,4), wf6(:,415), n3(:,979), t3x6(:,:,319))
  call vert_WQ_A(ntry, wf3(:,3), wf2(:,4), wf6(:,416), n3(:,980), t3x6(:,:,320))
  call vert_VQ_A(ntry, wf3(:,4), wf6(:,43), wf18(:,277), n3(:,981), t3x18(:,:,229))
  call vert_VQ_A(ntry, wf3(:,2), wf6(:,43), wf18(:,278), n3(:,982), t3x18(:,:,230))
  call vert_ZQ_A(gZd,ntry, wf3(:,4), wf6(:,43), wf18(:,279), n3(:,983), t3x18(:,:,231))
  call vert_ZQ_A(gZd,ntry, wf3(:,2), wf6(:,43), wf18(:,280), n3(:,984), t3x18(:,:,232))
  call vert_AV_Q(ntry, wf6(:,39), wf3(:,4), wf18(:,281), n3(:,985), t3x18(:,:,233))
  call vert_AV_Q(ntry, wf6(:,39), wf3(:,2), wf18(:,282), n3(:,986), t3x18(:,:,234))
  call vert_AZ_Q(gZd,ntry, wf6(:,39), wf3(:,4), wf18(:,283), n3(:,987), t3x18(:,:,235))
  call vert_AZ_Q(gZd,ntry, wf6(:,39), wf3(:,2), wf18(:,284), n3(:,988), t3x18(:,:,236))
  call vert_AW_Q(ntry, wf2(:,2), wf9(:,5), wf18(:,285), n3(:,989), t3x18(:,:,237))
  call vert_WQ_A(ntry, wf9(:,3), wf2(:,4), wf18(:,286), n3(:,990), t3x18(:,:,238))
  call vert_VQ_A(ntry, wf3(:,8), wf6(:,40), wf18(:,287), n3(:,991), t3x18(:,:,239))
  call vert_VQ_A(ntry, wf3(:,6), wf6(:,40), wf18(:,288), n3(:,992), t3x18(:,:,240))
  call vert_ZQ_A(gZd,ntry, wf3(:,8), wf6(:,40), wf18(:,289), n3(:,993), t3x18(:,:,241))
  call vert_ZQ_A(gZd,ntry, wf3(:,6), wf6(:,40), wf18(:,290), n3(:,994), t3x18(:,:,242))
  call vert_AV_Q(ntry, wf6(:,44), wf3(:,8), wf18(:,291), n3(:,995), t3x18(:,:,243))
  call vert_AV_Q(ntry, wf6(:,44), wf3(:,6), wf18(:,292), n3(:,996), t3x18(:,:,244))
  call vert_AZ_Q(gZd,ntry, wf6(:,44), wf3(:,8), wf18(:,293), n3(:,997), t3x18(:,:,245))
  call vert_AZ_Q(gZd,ntry, wf6(:,44), wf3(:,6), wf18(:,294), n3(:,998), t3x18(:,:,246))
  call vert_AW_Q(ntry, wf2(:,2), wf9(:,6), wf18(:,295), n3(:,999), t3x18(:,:,247))
  call vert_WQ_A(ntry, wf9(:,4), wf2(:,4), wf18(:,296), n3(:,1000), t3x18(:,:,248))
  call vert_QA_V(ntry, wf4(:,4), wf2(:,6), wf8(:,61), n3(:,1001), t3x8(:,:,61))
  call vert_QA_Z(gZd,ntry, wf4(:,4), wf2(:,6), wf8(:,62), n3(:,1002), t3x8(:,:,62))
  call vert_AW_Q(ntry, wf2(:,6), wf3(:,5), wf6(:,417), n3(:,1003), t3x6(:,:,321))
  call vert_AW_Q(ntry, wf2(:,6), wf3(:,1), wf6(:,418), n3(:,1004), t3x6(:,:,322))
  call vert_QA_V(ntry, wf2(:,8), wf4(:,2), wf8(:,63), n3(:,1005), t3x8(:,:,63))
  call vert_QA_Z(gZd,ntry, wf2(:,8), wf4(:,2), wf8(:,64), n3(:,1006), t3x8(:,:,64))
  call vert_WQ_A(ntry, wf3(:,7), wf2(:,8), wf6(:,419), n3(:,1007), t3x6(:,:,323))
  call vert_WQ_A(ntry, wf3(:,3), wf2(:,8), wf6(:,420), n3(:,1008), t3x6(:,:,324))
  call vert_VQ_A(ntry, wf3(:,4), wf6(:,51), wf18(:,297), n3(:,1009), t3x18(:,:,249))
  call vert_VQ_A(ntry, wf3(:,2), wf6(:,51), wf18(:,298), n3(:,1010), t3x18(:,:,250))
  call vert_ZQ_A(gZd,ntry, wf3(:,4), wf6(:,51), wf18(:,299), n3(:,1011), t3x18(:,:,251))
  call vert_ZQ_A(gZd,ntry, wf3(:,2), wf6(:,51), wf18(:,300), n3(:,1012), t3x18(:,:,252))
  call vert_AV_Q(ntry, wf6(:,47), wf3(:,4), wf18(:,301), n3(:,1013), t3x18(:,:,253))
  call vert_AV_Q(ntry, wf6(:,47), wf3(:,2), wf18(:,302), n3(:,1014), t3x18(:,:,254))
  call vert_AZ_Q(gZd,ntry, wf6(:,47), wf3(:,4), wf18(:,303), n3(:,1015), t3x18(:,:,255))
  call vert_AZ_Q(gZd,ntry, wf6(:,47), wf3(:,2), wf18(:,304), n3(:,1016), t3x18(:,:,256))
  call vert_AW_Q(ntry, wf2(:,6), wf9(:,5), wf18(:,305), n3(:,1017), t3x18(:,:,257))
  call vert_WQ_A(ntry, wf9(:,3), wf2(:,8), wf18(:,306), n3(:,1018), t3x18(:,:,258))
  call vert_VQ_A(ntry, wf3(:,8), wf6(:,48), wf18(:,307), n3(:,1019), t3x18(:,:,259))
  call vert_VQ_A(ntry, wf3(:,6), wf6(:,48), wf18(:,308), n3(:,1020), t3x18(:,:,260))
  call vert_ZQ_A(gZd,ntry, wf3(:,8), wf6(:,48), wf18(:,309), n3(:,1021), t3x18(:,:,261))
  call vert_ZQ_A(gZd,ntry, wf3(:,6), wf6(:,48), wf18(:,310), n3(:,1022), t3x18(:,:,262))
  call vert_AV_Q(ntry, wf6(:,52), wf3(:,8), wf18(:,311), n3(:,1023), t3x18(:,:,263))
  call vert_AV_Q(ntry, wf6(:,52), wf3(:,6), wf18(:,312), n3(:,1024), t3x18(:,:,264))
  call vert_AZ_Q(gZd,ntry, wf6(:,52), wf3(:,8), wf18(:,313), n3(:,1025), t3x18(:,:,265))
  call vert_AZ_Q(gZd,ntry, wf6(:,52), wf3(:,6), wf18(:,314), n3(:,1026), t3x18(:,:,266))
  call vert_AW_Q(ntry, wf2(:,6), wf9(:,6), wf18(:,315), n3(:,1027), t3x18(:,:,267))
  call vert_WQ_A(ntry, wf9(:,4), wf2(:,8), wf18(:,316), n3(:,1028), t3x18(:,:,268))


  if (ntry==1) then
    call physical_helicities()
  end if

  ! computation of the colour-stripped amplitudes
  do nsync = ntry+ntry-1, ntry+1  !  nsync = 1,2  for 1st point and nsync = 3 later
    call diagrams()
    if (nsync == 1) call helsync(nsync, A, nhel, Hel)
  end do

  if (ntry < 2) then
    if(hel_mem_opt) hel_states = nhel
    call allocate_diagrams()
  end if

  ! In the following loop the coefficients \Gamma_{i} of the expansion in
  ! the colour basis are computed for every helicity state and stored in M1helarray.
  ! Also the colour vector for the Born-loop interference is computed and saved in
  ! M0_col1_helarray
  do k = 1, nhel
    if (do_ct) call colourvectors(A, k, M1helarray(:,k),M1helarray_ct(:,k))
#if 0 > 0
    call colborninterf(M1helarray(:,k), M0_col1_helarray(:,k), 0)
#endif
  end do
  M1helarray(:,nhel+1:)%j = 0
  M0_col1_helarray(:,nhel+1:)%hf = -1_intkind2
  M0_col1_helarray(:,nhel+1:)%j = 0

  M2add = 0
  M2add_ct = 0
  M2add_colint = 0

  M02 = 0
  if (do_ct) M2ct = 0
  if (do_colint) M2colint = 0

  do k = 1, nhel
    call colint(M1helarray(:,k)%j, M2add)
    if (do_ct) call colint_ct(M1helarray(:,k)%j, M1helarray_ct(:,k)%j, M2add_ct, 0)
    if (IR_is_on > 0) then
      if (do_colint) call colint_IR(M1helarray(:,k)%j, M2add_colint)
    end if
    !summation over helicity configurations
    M02 = M02 + M2add
    if (do_ct) M2ct = M2ct + M2add_ct
    if (do_colint) M2colint = M2colint + M2add_colint
  end do

#if 1 > 0 && 5 > 3 && 0 > 0
  if (loopcc) then
    !!Born-loop colour correlators interference
    ind_cc_comb = [
    M0M1_hel_cc(:,:,:)%j = 0
    M2ctcc = 0
    do n = 1, 5
      M2add_ct = 0
      m = ind_cc_comb(n)
        do k = 1, nhel
          call colint_ct(M1helarray(:,k)%j, M1helarray_ct(:,k)%j, M2add_ct, m)
          call colborninterf(M1helarray(:,k), M0M1_hel_cc(:,k,m), m)
          M2ctcc(m) = M2ctcc(m) + M2add_ct
        end do
    end do
    M0M1_hel_cc(:,nhel+1:,:)%hf = -1_intkind2
    M0M1_hel_cc(:,nhel+1:,:)%j = 0
  end if
#endif

  if (ntry < 1) then
    if (allocated(A)) deallocate(A)
  end if
  ntry=2

  contains

subroutine physical_helicities()
  implicit none

integer :: i1,i2,i3,i4,i5
integer :: n

n=0

do i5= 1, 2
do i4= 1, 3
do i3= 1, 3
do i2= 1, 2
do i1= 1, 2
n = n + 1
 if((ex1(i1)%hf==-1_intkind2) .OR. (ex2(i2)%hf==-1_intkind2) .OR. (ex3(i3)%hf==-1_intkind2) .OR. (ex4(i4)%hf==-1_intkind2)  &
    .OR. (ex5(i5)%hf==-1_intkind2)) then
  Hel(n) = -1_intkind2
 else
  Hel(n) = ex1(i1)%hf + ex2(i2)%hf + ex3(i3)%hf + ex4(i4)%hf + ex5(i5)%hf
 end if
end do
end do
end do
end do
end do

end subroutine physical_helicities

subroutine diagrams()
  implicit none
  integer :: h
  ! e.g. call cont_VV(nsync, wf3, wf6, A(:,1), n64, t64, nhel, den(5)) ...

    call Hcont_QA(nsync, wf6(:,4), wf12(:,1), A(:,1), n3(:,1029), t3x72(:,:,1), nhel, den(3))
    call Hcont_QA(nsync, wf4(:,2), wf18(:,1), A(:,2), n3(:,1030), t3x72(:,:,2), nhel, den(5))
    call Hcont_QA(nsync, wf6(:,8), wf12(:,2), A(:,3), n3(:,1031), t3x72(:,:,3), nhel, den(8))
    call Hcont_QA(nsync, wf6(:,8), wf12(:,3), A(:,4), n3(:,1032), t3x72(:,:,4), nhel, den(10))
    call Hcont_QA(nsync, wf4(:,2), wf18(:,2), A(:,5), n3(:,1033), t3x72(:,:,5), nhel, den(11))
    call Hcont_QA(nsync, wf6(:,4), wf12(:,4), A(:,6), n3(:,1034), t3x72(:,:,6), nhel, den(12))

    call Hcont_QA(nsync, wf12(:,5), wf6(:,9), A(:,7), n3(:,1035), t3x72(:,:,7), nhel, den(14))
    call Hcont_QA(nsync, wf18(:,3), wf4(:,5), A(:,8), n3(:,1036), t3x72(:,:,8), nhel, den(16))
    call Hcont_QA(nsync, wf12(:,6), wf6(:,10), A(:,9), n3(:,1037), t3x72(:,:,9), nhel, den(18))
    call Hcont_QA(nsync, wf4(:,5), wf18(:,4), A(:,10), n3(:,1038), t3x72(:,:,10), nhel, den(19))
    call Hcont_QA(nsync, wf6(:,10), wf12(:,7), A(:,11), n3(:,1039), t3x72(:,:,11), nhel, den(20))
    call Hcont_QA(nsync, wf6(:,9), wf12(:,8), A(:,12), n3(:,1040), t3x72(:,:,12), nhel, den(21))
    call Hcont_QA(nsync, wf12(:,10), wf6(:,11), A(:,13), n3(:,1041), t3x72(:,:,13), nhel, den(23))
    call Hcont_QA(nsync, wf18(:,6), wf4(:,6), A(:,14), n3(:,1042), t3x72(:,:,14), nhel, den(25))
    call Hcont_QA(nsync, wf12(:,12), wf6(:,12), A(:,15), n3(:,1043), t3x72(:,:,15), nhel, den(27))
    call Hcont_QA(nsync, wf4(:,6), wf18(:,8), A(:,16), n3(:,1044), t3x72(:,:,16), nhel, den(28))
    call Hcont_QA(nsync, wf6(:,12), wf12(:,14), A(:,17), n3(:,1045), t3x72(:,:,17), nhel, den(29))
    call Hcont_QA(nsync, wf6(:,11), wf12(:,16), A(:,18), n3(:,1046), t3x72(:,:,18), nhel, den(30))
    call Hcont_QA(nsync, wf12(:,5), wf6(:,13), A(:,19), n3(:,1047), t3x72(:,:,19), nhel, den(14))
    call Hcont_QA(nsync, wf18(:,3), wf4(:,7), A(:,20), n3(:,1048), t3x72(:,:,20), nhel, den(16))
    call Hcont_QA(nsync, wf12(:,6), wf6(:,14), A(:,21), n3(:,1049), t3x72(:,:,21), nhel, den(18))
    call Hcont_QA(nsync, wf18(:,4), wf4(:,7), A(:,22), n3(:,1050), t3x72(:,:,22), nhel, den(19))
    call Hcont_QA(nsync, wf12(:,7), wf6(:,14), A(:,23), n3(:,1051), t3x72(:,:,23), nhel, den(20))
    call Hcont_QA(nsync, wf12(:,8), wf6(:,13), A(:,24), n3(:,1052), t3x72(:,:,24), nhel, den(21))
    call Hcont_QA(nsync, wf12(:,10), wf6(:,15), A(:,25), n3(:,1053), t3x72(:,:,25), nhel, den(23))
    call Hcont_QA(nsync, wf18(:,6), wf4(:,8), A(:,26), n3(:,1054), t3x72(:,:,26), nhel, den(25))
    call Hcont_QA(nsync, wf12(:,12), wf6(:,16), A(:,27), n3(:,1055), t3x72(:,:,27), nhel, den(27))
    call Hcont_QA(nsync, wf18(:,8), wf4(:,8), A(:,28), n3(:,1056), t3x72(:,:,28), nhel, den(28))
    call Hcont_QA(nsync, wf12(:,14), wf6(:,16), A(:,29), n3(:,1057), t3x72(:,:,29), nhel, den(29))
    call Hcont_QA(nsync, wf12(:,16), wf6(:,15), A(:,30), n3(:,1058), t3x72(:,:,30), nhel, den(30))
    call Hcont_VV(nsync, wf24(:,1), wf3(:,2), A(:,31), n3(:,1059), t3x72(:,:,31), nhel, den(5))
    call Hcont_VV(nsync, wf24(:,1), wf3(:,4), A(:,32), n3(:,1060), t3x72(:,:,32), nhel, den(5))
    call Hcont_VV(nsync, wf3(:,2), wf24(:,2), A(:,33), n3(:,1061), t3x72(:,:,33), nhel, den(5))
    call Hcont_VV(nsync, wf3(:,4), wf24(:,2), A(:,34), n3(:,1062), t3x72(:,:,34), nhel, den(5))
    call Hcont_QA(nsync, wf12(:,5), wf6(:,17), A(:,35), n3(:,1063), t3x72(:,:,35), nhel, den(14))
    call Hcont_QA(nsync, wf12(:,5), wf6(:,18), A(:,36), n3(:,1064), t3x72(:,:,36), nhel, den(14))
    call Hcont_QA(nsync, wf12(:,5), wf6(:,19), A(:,37), n3(:,1065), t3x72(:,:,37), nhel, den(14))
    call Hcont_QA(nsync, wf12(:,5), wf6(:,20), A(:,38), n3(:,1066), t3x72(:,:,38), nhel, den(14))
    call Hcont_VV(nsync, wf3(:,2), wf24(:,3), A(:,39), n3(:,1067), t3x72(:,:,39), nhel, den(10))
    call Hcont_VV(nsync, wf3(:,4), wf24(:,3), A(:,40), n3(:,1068), t3x72(:,:,40), nhel, den(10))
    call Hcont_VV(nsync, wf3(:,2), wf24(:,4), A(:,41), n3(:,1069), t3x72(:,:,41), nhel, den(10))
    call Hcont_VV(nsync, wf3(:,4), wf24(:,4), A(:,42), n3(:,1070), t3x72(:,:,42), nhel, den(10))
    call Hcont_QA(nsync, wf12(:,10), wf6(:,21), A(:,43), n3(:,1071), t3x72(:,:,43), nhel, den(23))
    call Hcont_QA(nsync, wf12(:,10), wf6(:,22), A(:,44), n3(:,1072), t3x72(:,:,44), nhel, den(23))
    call Hcont_QA(nsync, wf12(:,10), wf6(:,23), A(:,45), n3(:,1073), t3x72(:,:,45), nhel, den(23))
    call Hcont_QA(nsync, wf12(:,10), wf6(:,24), A(:,46), n3(:,1074), t3x72(:,:,46), nhel, den(23))
    call Hcont_QA(nsync, wf12(:,8), wf6(:,17), A(:,47), n3(:,1075), t3x72(:,:,47), nhel, den(21))
    call Hcont_QA(nsync, wf12(:,8), wf6(:,18), A(:,48), n3(:,1076), t3x72(:,:,48), nhel, den(21))
    call Hcont_QA(nsync, wf12(:,8), wf6(:,19), A(:,49), n3(:,1077), t3x72(:,:,49), nhel, den(21))
    call Hcont_QA(nsync, wf12(:,8), wf6(:,20), A(:,50), n3(:,1078), t3x72(:,:,50), nhel, den(21))
    call Hcont_QA(nsync, wf12(:,16), wf6(:,21), A(:,51), n3(:,1079), t3x72(:,:,51), nhel, den(30))
    call Hcont_QA(nsync, wf12(:,16), wf6(:,22), A(:,52), n3(:,1080), t3x72(:,:,52), nhel, den(30))
    call Hcont_QA(nsync, wf12(:,16), wf6(:,23), A(:,53), n3(:,1081), t3x72(:,:,53), nhel, den(30))
    call Hcont_QA(nsync, wf12(:,16), wf6(:,24), A(:,54), n3(:,1082), t3x72(:,:,54), nhel, den(30))
    call Hcont_VV(nsync, wf24(:,5), wf3(:,6), A(:,55), n3(:,1083), t3x72(:,:,55), nhel, den(11))
    call Hcont_VV(nsync, wf24(:,5), wf3(:,8), A(:,56), n3(:,1084), t3x72(:,:,56), nhel, den(11))
    call Hcont_VV(nsync, wf3(:,6), wf24(:,6), A(:,57), n3(:,1085), t3x72(:,:,57), nhel, den(11))
    call Hcont_VV(nsync, wf3(:,8), wf24(:,6), A(:,58), n3(:,1086), t3x72(:,:,58), nhel, den(11))
    call Hcont_QA(nsync, wf12(:,6), wf6(:,25), A(:,59), n3(:,1087), t3x72(:,:,59), nhel, den(18))
    call Hcont_QA(nsync, wf12(:,6), wf6(:,26), A(:,60), n3(:,1088), t3x72(:,:,60), nhel, den(18))
    call Hcont_QA(nsync, wf12(:,6), wf6(:,27), A(:,61), n3(:,1089), t3x72(:,:,61), nhel, den(18))
    call Hcont_QA(nsync, wf12(:,6), wf6(:,28), A(:,62), n3(:,1090), t3x72(:,:,62), nhel, den(18))
    call Hcont_VV(nsync, wf3(:,6), wf24(:,7), A(:,63), n3(:,1091), t3x72(:,:,63), nhel, den(12))
    call Hcont_VV(nsync, wf3(:,8), wf24(:,7), A(:,64), n3(:,1092), t3x72(:,:,64), nhel, den(12))
    call Hcont_VV(nsync, wf3(:,6), wf24(:,8), A(:,65), n3(:,1093), t3x72(:,:,65), nhel, den(12))
    call Hcont_VV(nsync, wf3(:,8), wf24(:,8), A(:,66), n3(:,1094), t3x72(:,:,66), nhel, den(12))
    call Hcont_QA(nsync, wf12(:,12), wf6(:,29), A(:,67), n3(:,1095), t3x72(:,:,67), nhel, den(27))
    call Hcont_QA(nsync, wf12(:,12), wf6(:,30), A(:,68), n3(:,1096), t3x72(:,:,68), nhel, den(27))
    call Hcont_QA(nsync, wf12(:,12), wf6(:,31), A(:,69), n3(:,1097), t3x72(:,:,69), nhel, den(27))
    call Hcont_QA(nsync, wf12(:,12), wf6(:,32), A(:,70), n3(:,1098), t3x72(:,:,70), nhel, den(27))
    call Hcont_QA(nsync, wf12(:,7), wf6(:,25), A(:,71), n3(:,1099), t3x72(:,:,71), nhel, den(20))
    call Hcont_QA(nsync, wf12(:,7), wf6(:,26), A(:,72), n3(:,1100), t3x72(:,:,72), nhel, den(20))
    call Hcont_QA(nsync, wf12(:,7), wf6(:,27), A(:,73), n3(:,1101), t3x72(:,:,73), nhel, den(20))
    call Hcont_QA(nsync, wf12(:,7), wf6(:,28), A(:,74), n3(:,1102), t3x72(:,:,74), nhel, den(20))
    call Hcont_QA(nsync, wf12(:,14), wf6(:,29), A(:,75), n3(:,1103), t3x72(:,:,75), nhel, den(29))
    call Hcont_QA(nsync, wf12(:,14), wf6(:,30), A(:,76), n3(:,1104), t3x72(:,:,76), nhel, den(29))
    call Hcont_QA(nsync, wf12(:,14), wf6(:,31), A(:,77), n3(:,1105), t3x72(:,:,77), nhel, den(29))
    call Hcont_QA(nsync, wf12(:,14), wf6(:,32), A(:,78), n3(:,1106), t3x72(:,:,78), nhel, den(29))
    call Hcont_QA(nsync, wf12(:,5), wf6(:,33), A(:,79), n3(:,1107), t3x72(:,:,79), nhel, den(14))
    call Hcont_QA(nsync, wf18(:,3), wf4(:,9), A(:,80), n3(:,1108), t3x72(:,:,80), nhel, den(16))
    call Hcont_QA(nsync, wf12(:,6), wf6(:,34), A(:,81), n3(:,1109), t3x72(:,:,81), nhel, den(18))
    call Hcont_QA(nsync, wf18(:,4), wf4(:,9), A(:,82), n3(:,1110), t3x72(:,:,82), nhel, den(19))
    call Hcont_QA(nsync, wf12(:,7), wf6(:,34), A(:,83), n3(:,1111), t3x72(:,:,83), nhel, den(20))
    call Hcont_QA(nsync, wf12(:,8), wf6(:,33), A(:,84), n3(:,1112), t3x72(:,:,84), nhel, den(21))
    call Hcont_QA(nsync, wf12(:,10), wf6(:,35), A(:,85), n3(:,1113), t3x72(:,:,85), nhel, den(23))
    call Hcont_QA(nsync, wf18(:,6), wf4(:,10), A(:,86), n3(:,1114), t3x72(:,:,86), nhel, den(25))
    call Hcont_QA(nsync, wf12(:,12), wf6(:,36), A(:,87), n3(:,1115), t3x72(:,:,87), nhel, den(27))
    call Hcont_QA(nsync, wf18(:,8), wf4(:,10), A(:,88), n3(:,1116), t3x72(:,:,88), nhel, den(28))
    call Hcont_QA(nsync, wf12(:,14), wf6(:,36), A(:,89), n3(:,1117), t3x72(:,:,89), nhel, den(29))
    call Hcont_QA(nsync, wf12(:,16), wf6(:,35), A(:,90), n3(:,1118), t3x72(:,:,90), nhel, den(30))
    call Hcont_QA(nsync, wf6(:,40), wf12(:,17), A(:,91), n3(:,1119), t3x72(:,:,91), nhel, den(8))
    call Hcont_QA(nsync, wf4(:,12), wf18(:,9), A(:,92), n3(:,1120), t3x72(:,:,92), nhel, den(10))
    call Hcont_QA(nsync, wf6(:,44), wf12(:,18), A(:,93), n3(:,1121), t3x72(:,:,93), nhel, den(3))
    call Hcont_QA(nsync, wf4(:,12), wf18(:,10), A(:,94), n3(:,1122), t3x72(:,:,94), nhel, den(12))
    call Hcont_QA(nsync, wf4(:,14), wf18(:,11), A(:,95), n3(:,1123), t3x72(:,:,95), nhel, den(5))
    call Hcont_QA(nsync, wf4(:,14), wf18(:,12), A(:,96), n3(:,1124), t3x72(:,:,96), nhel, den(11))
    call Hcont_QA(nsync, wf6(:,48), wf12(:,19), A(:,97), n3(:,1125), t3x72(:,:,97), nhel, den(8))
    call Hcont_QA(nsync, wf4(:,16), wf18(:,13), A(:,98), n3(:,1126), t3x72(:,:,98), nhel, den(10))
    call Hcont_QA(nsync, wf6(:,52), wf12(:,20), A(:,99), n3(:,1127), t3x72(:,:,99), nhel, den(3))
    call Hcont_QA(nsync, wf4(:,16), wf18(:,14), A(:,100), n3(:,1128), t3x72(:,:,100), nhel, den(12))
    call Hcont_QA(nsync, wf4(:,18), wf18(:,15), A(:,101), n3(:,1129), t3x72(:,:,101), nhel, den(5))
    call Hcont_QA(nsync, wf4(:,18), wf18(:,16), A(:,102), n3(:,1130), t3x72(:,:,102), nhel, den(11))
    call Hcont_VV(nsync, wf8(:,1), wf9(:,1), A(:,103), n3(:,1131), t3x72(:,:,103), nhel, den(32))
    call Hcont_VV(nsync, wf8(:,1), wf9(:,2), A(:,104), n3(:,1132), t3x72(:,:,104), nhel, den(32))
    call Hcont_VV(nsync, wf9(:,1), wf8(:,2), A(:,105), n3(:,1133), t3x72(:,:,105), nhel, den(34))
    call Hcont_VV(nsync, wf9(:,2), wf8(:,2), A(:,106), n3(:,1134), t3x72(:,:,106), nhel, den(34))
    call Hcont_VV(nsync, wf9(:,1), wf8(:,3), A(:,107), n3(:,1135), t3x72(:,:,107), nhel, den(35))
    call Hcont_VV(nsync, wf9(:,2), wf8(:,3), A(:,108), n3(:,1136), t3x72(:,:,108), nhel, den(35))
    call Hcont_VV(nsync, wf9(:,1), wf8(:,4), A(:,109), n3(:,1137), t3x72(:,:,109), nhel, den(36))
    call Hcont_VV(nsync, wf9(:,2), wf8(:,4), A(:,110), n3(:,1138), t3x72(:,:,110), nhel, den(36))
    call Hcont_QA(nsync, wf18(:,17), wf4(:,20), A(:,111), n3(:,1139), t3x72(:,:,111), nhel, den(5))
    call Hcont_QA(nsync, wf12(:,5), wf6(:,53), A(:,112), n3(:,1140), t3x72(:,:,112), nhel, den(14))
    call Hcont_VV(nsync, wf9(:,3), wf8(:,5), A(:,113), n3(:,1141), t3x72(:,:,113), nhel, den(38))
    call Hcont_QA(nsync, wf12(:,21), wf6(:,55), A(:,114), n3(:,1142), t3x72(:,:,114), nhel, den(10))
    call Hcont_QA(nsync, wf12(:,8), wf6(:,53), A(:,115), n3(:,1143), t3x72(:,:,115), nhel, den(21))
    call Hcont_QA(nsync, wf6(:,55), wf12(:,22), A(:,116), n3(:,1144), t3x72(:,:,116), nhel, den(8))
    call Hcont_QA(nsync, wf4(:,20), wf18(:,18), A(:,117), n3(:,1145), t3x72(:,:,117), nhel, den(11))
    call Hcont_QA(nsync, wf4(:,20), wf18(:,19), A(:,118), n3(:,1146), t3x72(:,:,118), nhel, den(39))
    call Hcont_QA(nsync, wf4(:,20), wf18(:,20), A(:,119), n3(:,1147), t3x72(:,:,119), nhel, den(11))
    call Hcont_QA(nsync, wf12(:,6), wf6(:,58), A(:,120), n3(:,1148), t3x72(:,:,120), nhel, den(18))
    call Hcont_VV(nsync, wf8(:,5), wf9(:,4), A(:,121), n3(:,1149), t3x72(:,:,121), nhel, den(38))
    call Hcont_QA(nsync, wf12(:,23), wf6(:,60), A(:,122), n3(:,1150), t3x72(:,:,122), nhel, den(12))
    call Hcont_QA(nsync, wf12(:,7), wf6(:,58), A(:,123), n3(:,1151), t3x72(:,:,123), nhel, den(20))
    call Hcont_QA(nsync, wf6(:,60), wf12(:,24), A(:,124), n3(:,1152), t3x72(:,:,124), nhel, den(3))
    call Hcont_QA(nsync, wf4(:,20), wf18(:,21), A(:,125), n3(:,1153), t3x72(:,:,125), nhel, den(5))
    call Hcont_QA(nsync, wf4(:,20), wf18(:,22), A(:,126), n3(:,1154), t3x72(:,:,126), nhel, den(39))
    call Hcont_QA(nsync, wf18(:,23), wf4(:,22), A(:,127), n3(:,1155), t3x72(:,:,127), nhel, den(10))
    call Hcont_QA(nsync, wf12(:,10), wf6(:,63), A(:,128), n3(:,1156), t3x72(:,:,128), nhel, den(23))
    call Hcont_VV(nsync, wf9(:,5), wf8(:,6), A(:,129), n3(:,1157), t3x72(:,:,129), nhel, den(39))
    call Hcont_QA(nsync, wf12(:,25), wf6(:,65), A(:,130), n3(:,1158), t3x72(:,:,130), nhel, den(5))
    call Hcont_QA(nsync, wf12(:,16), wf6(:,63), A(:,131), n3(:,1159), t3x72(:,:,131), nhel, den(30))
    call Hcont_QA(nsync, wf6(:,65), wf12(:,26), A(:,132), n3(:,1160), t3x72(:,:,132), nhel, den(3))
    call Hcont_QA(nsync, wf4(:,22), wf18(:,24), A(:,133), n3(:,1161), t3x72(:,:,133), nhel, den(12))
    call Hcont_QA(nsync, wf4(:,22), wf18(:,25), A(:,134), n3(:,1162), t3x72(:,:,134), nhel, den(38))
    call Hcont_QA(nsync, wf4(:,22), wf18(:,26), A(:,135), n3(:,1163), t3x72(:,:,135), nhel, den(12))
    call Hcont_QA(nsync, wf12(:,12), wf6(:,68), A(:,136), n3(:,1164), t3x72(:,:,136), nhel, den(27))
    call Hcont_VV(nsync, wf8(:,6), wf9(:,6), A(:,137), n3(:,1165), t3x72(:,:,137), nhel, den(39))
    call Hcont_QA(nsync, wf12(:,27), wf6(:,70), A(:,138), n3(:,1166), t3x72(:,:,138), nhel, den(11))
    call Hcont_QA(nsync, wf12(:,14), wf6(:,68), A(:,139), n3(:,1167), t3x72(:,:,139), nhel, den(29))
    call Hcont_QA(nsync, wf6(:,70), wf12(:,28), A(:,140), n3(:,1168), t3x72(:,:,140), nhel, den(8))
    call Hcont_QA(nsync, wf4(:,22), wf18(:,27), A(:,141), n3(:,1169), t3x72(:,:,141), nhel, den(10))
    call Hcont_QA(nsync, wf4(:,22), wf18(:,28), A(:,142), n3(:,1170), t3x72(:,:,142), nhel, den(38))
    call Hcont_QA(nsync, wf6(:,70), wf12(:,29), A(:,143), n3(:,1171), t3x72(:,:,143), nhel, den(8))
    call Hcont_QA(nsync, wf4(:,22), wf18(:,29), A(:,144), n3(:,1172), t3x72(:,:,144), nhel, den(10))
    call Hcont_QA(nsync, wf6(:,60), wf12(:,30), A(:,145), n3(:,1173), t3x72(:,:,145), nhel, den(3))
    call Hcont_QA(nsync, wf4(:,22), wf18(:,30), A(:,146), n3(:,1174), t3x72(:,:,146), nhel, den(12))
    call Hcont_QA(nsync, wf4(:,20), wf18(:,31), A(:,147), n3(:,1175), t3x72(:,:,147), nhel, den(5))
    call Hcont_QA(nsync, wf4(:,20), wf18(:,32), A(:,148), n3(:,1176), t3x72(:,:,148), nhel, den(11))
    call Hcont_QA(nsync, wf12(:,23), wf6(:,67), A(:,149), n3(:,1177), t3x72(:,:,149), nhel, den(12))
    call Hcont_QA(nsync, wf12(:,21), wf6(:,72), A(:,150), n3(:,1178), t3x72(:,:,150), nhel, den(10))
    call Hcont_QA(nsync, wf6(:,57), wf12(:,27), A(:,151), n3(:,1179), t3x72(:,:,151), nhel, den(11))
    call Hcont_QA(nsync, wf6(:,62), wf12(:,25), A(:,152), n3(:,1180), t3x72(:,:,152), nhel, den(5))
    call Hcont_QA(nsync, wf12(:,22), wf6(:,72), A(:,153), n3(:,1181), t3x72(:,:,153), nhel, den(8))
    call Hcont_QA(nsync, wf12(:,24), wf6(:,67), A(:,154), n3(:,1182), t3x72(:,:,154), nhel, den(3))
    call Hcont_QA(nsync, wf18(:,8), wf4(:,23), A(:,155), n3(:,1183), t3x72(:,:,155), nhel, den(40))
    call Hcont_QA(nsync, wf18(:,6), wf4(:,23), A(:,156), n3(:,1184), t3x72(:,:,156), nhel, den(41))
    call Hcont_QA(nsync, wf12(:,8), wf6(:,73), A(:,157), n3(:,1185), t3x72(:,:,157), nhel, den(42))
    call Hcont_QA(nsync, wf12(:,7), wf6(:,74), A(:,158), n3(:,1186), t3x72(:,:,158), nhel, den(43))
    call Hcont_QA(nsync, wf12(:,16), wf6(:,75), A(:,159), n3(:,1187), t3x72(:,:,159), nhel, den(44))
    call Hcont_QA(nsync, wf12(:,10), wf6(:,75), A(:,160), n3(:,1188), t3x72(:,:,160), nhel, den(45))
    call Hcont_QA(nsync, wf18(:,4), wf4(:,24), A(:,161), n3(:,1189), t3x72(:,:,161), nhel, den(46))
    call Hcont_QA(nsync, wf12(:,6), wf6(:,74), A(:,162), n3(:,1190), t3x72(:,:,162), nhel, den(47))
    call Hcont_QA(nsync, wf12(:,14), wf6(:,76), A(:,163), n3(:,1191), t3x72(:,:,163), nhel, den(48))
    call Hcont_QA(nsync, wf12(:,12), wf6(:,76), A(:,164), n3(:,1192), t3x72(:,:,164), nhel, den(49))
    call Hcont_QA(nsync, wf18(:,3), wf4(:,24), A(:,165), n3(:,1193), t3x72(:,:,165), nhel, den(50))
    call Hcont_QA(nsync, wf12(:,5), wf6(:,73), A(:,166), n3(:,1194), t3x72(:,:,166), nhel, den(51))
    call Hcont_QA(nsync, wf6(:,4), wf12(:,31), A(:,167), n3(:,1195), t3x72(:,:,167), nhel, den(3))
    call Hcont_QA(nsync, wf4(:,2), wf18(:,33), A(:,168), n3(:,1196), t3x72(:,:,168), nhel, den(5))
    call Hcont_QA(nsync, wf6(:,8), wf12(:,32), A(:,169), n3(:,1197), t3x72(:,:,169), nhel, den(8))
    call Hcont_QA(nsync, wf6(:,8), wf12(:,33), A(:,170), n3(:,1198), t3x72(:,:,170), nhel, den(10))
    call Hcont_QA(nsync, wf4(:,2), wf18(:,34), A(:,171), n3(:,1199), t3x72(:,:,171), nhel, den(11))
    call Hcont_QA(nsync, wf6(:,4), wf12(:,34), A(:,172), n3(:,1200), t3x72(:,:,172), nhel, den(12))
    call Hcont_QA(nsync, wf18(:,1), wf4(:,26), A(:,173), n3(:,1201), t3x72(:,:,173), nhel, den(5))
    call Hcont_QA(nsync, wf12(:,1), wf6(:,78), A(:,174), n3(:,1202), t3x72(:,:,174), nhel, den(3))
    call Hcont_QA(nsync, wf18(:,2), wf4(:,26), A(:,175), n3(:,1203), t3x72(:,:,175), nhel, den(11))
    call Hcont_QA(nsync, wf12(:,4), wf6(:,78), A(:,176), n3(:,1204), t3x72(:,:,176), nhel, den(12))
    call Hcont_QA(nsync, wf12(:,2), wf6(:,80), A(:,177), n3(:,1205), t3x72(:,:,177), nhel, den(8))
    call Hcont_QA(nsync, wf12(:,3), wf6(:,80), A(:,178), n3(:,1206), t3x72(:,:,178), nhel, den(10))
    call Hcont_QA(nsync, wf6(:,8), wf12(:,35), A(:,179), n3(:,1207), t3x72(:,:,179), nhel, den(10))
    call Hcont_QA(nsync, wf6(:,8), wf12(:,36), A(:,180), n3(:,1208), t3x72(:,:,180), nhel, den(8))
    call Hcont_QA(nsync, wf6(:,4), wf12(:,37), A(:,181), n3(:,1209), t3x72(:,:,181), nhel, den(12))
    call Hcont_QA(nsync, wf4(:,2), wf18(:,35), A(:,182), n3(:,1210), t3x72(:,:,182), nhel, den(11))
    call Hcont_QA(nsync, wf6(:,4), wf12(:,38), A(:,183), n3(:,1211), t3x72(:,:,183), nhel, den(3))
    call Hcont_QA(nsync, wf4(:,2), wf18(:,36), A(:,184), n3(:,1212), t3x72(:,:,184), nhel, den(5))
    call Hcont_QA(nsync, wf6(:,86), wf12(:,39), A(:,185), n3(:,1213), t3x72(:,:,185), nhel, den(3))
    call Hcont_QA(nsync, wf4(:,29), wf18(:,37), A(:,186), n3(:,1214), t3x72(:,:,186), nhel, den(5))
    call Hcont_QA(nsync, wf6(:,88), wf12(:,40), A(:,187), n3(:,1215), t3x72(:,:,187), nhel, den(8))
    call Hcont_QA(nsync, wf4(:,29), wf18(:,38), A(:,188), n3(:,1216), t3x72(:,:,188), nhel, den(11))
    call Hcont_QA(nsync, wf4(:,30), wf18(:,39), A(:,189), n3(:,1217), t3x72(:,:,189), nhel, den(10))
    call Hcont_QA(nsync, wf4(:,30), wf18(:,40), A(:,190), n3(:,1218), t3x72(:,:,190), nhel, den(12))
    call Hcont_QA(nsync, wf12(:,41), wf6(:,89), A(:,191), n3(:,1219), t3x72(:,:,191), nhel, den(14))
    call Hcont_QA(nsync, wf18(:,41), wf4(:,31), A(:,192), n3(:,1220), t3x72(:,:,192), nhel, den(16))
    call Hcont_QA(nsync, wf12(:,43), wf6(:,90), A(:,193), n3(:,1221), t3x72(:,:,193), nhel, den(18))
    call Hcont_QA(nsync, wf4(:,31), wf18(:,42), A(:,194), n3(:,1222), t3x72(:,:,194), nhel, den(19))
    call Hcont_QA(nsync, wf6(:,90), wf12(:,45), A(:,195), n3(:,1223), t3x72(:,:,195), nhel, den(20))
    call Hcont_QA(nsync, wf6(:,89), wf12(:,47), A(:,196), n3(:,1224), t3x72(:,:,196), nhel, den(21))
    call Hcont_QA(nsync, wf12(:,48), wf6(:,91), A(:,197), n3(:,1225), t3x72(:,:,197), nhel, den(23))
    call Hcont_QA(nsync, wf18(:,43), wf4(:,32), A(:,198), n3(:,1226), t3x72(:,:,198), nhel, den(25))
    call Hcont_QA(nsync, wf12(:,50), wf6(:,92), A(:,199), n3(:,1227), t3x72(:,:,199), nhel, den(27))
    call Hcont_QA(nsync, wf4(:,32), wf18(:,44), A(:,200), n3(:,1228), t3x72(:,:,200), nhel, den(28))
    call Hcont_QA(nsync, wf6(:,92), wf12(:,52), A(:,201), n3(:,1229), t3x72(:,:,201), nhel, den(29))
    call Hcont_QA(nsync, wf6(:,91), wf12(:,54), A(:,202), n3(:,1230), t3x72(:,:,202), nhel, den(30))
    call Hcont_QA(nsync, wf6(:,94), wf12(:,55), A(:,203), n3(:,1231), t3x72(:,:,203), nhel, den(3))
    call Hcont_QA(nsync, wf4(:,33), wf18(:,45), A(:,204), n3(:,1232), t3x72(:,:,204), nhel, den(5))
    call Hcont_QA(nsync, wf6(:,96), wf12(:,56), A(:,205), n3(:,1233), t3x72(:,:,205), nhel, den(8))
    call Hcont_QA(nsync, wf4(:,33), wf18(:,46), A(:,206), n3(:,1234), t3x72(:,:,206), nhel, den(11))
    call Hcont_QA(nsync, wf4(:,34), wf18(:,47), A(:,207), n3(:,1235), t3x72(:,:,207), nhel, den(10))
    call Hcont_QA(nsync, wf4(:,34), wf18(:,48), A(:,208), n3(:,1236), t3x72(:,:,208), nhel, den(12))
    call Hcont_QA(nsync, wf12(:,57), wf6(:,97), A(:,209), n3(:,1237), t3x72(:,:,209), nhel, den(14))
    call Hcont_QA(nsync, wf18(:,49), wf4(:,35), A(:,210), n3(:,1238), t3x72(:,:,210), nhel, den(16))
    call Hcont_QA(nsync, wf12(:,59), wf6(:,98), A(:,211), n3(:,1239), t3x72(:,:,211), nhel, den(18))
    call Hcont_QA(nsync, wf4(:,35), wf18(:,50), A(:,212), n3(:,1240), t3x72(:,:,212), nhel, den(19))
    call Hcont_QA(nsync, wf6(:,98), wf12(:,61), A(:,213), n3(:,1241), t3x72(:,:,213), nhel, den(20))
    call Hcont_QA(nsync, wf6(:,97), wf12(:,63), A(:,214), n3(:,1242), t3x72(:,:,214), nhel, den(21))
    call Hcont_QA(nsync, wf12(:,64), wf6(:,99), A(:,215), n3(:,1243), t3x72(:,:,215), nhel, den(23))
    call Hcont_QA(nsync, wf18(:,51), wf4(:,36), A(:,216), n3(:,1244), t3x72(:,:,216), nhel, den(25))
    call Hcont_QA(nsync, wf12(:,66), wf6(:,100), A(:,217), n3(:,1245), t3x72(:,:,217), nhel, den(27))
    call Hcont_QA(nsync, wf4(:,36), wf18(:,52), A(:,218), n3(:,1246), t3x72(:,:,218), nhel, den(28))
    call Hcont_QA(nsync, wf6(:,100), wf12(:,68), A(:,219), n3(:,1247), t3x72(:,:,219), nhel, den(29))
    call Hcont_QA(nsync, wf6(:,99), wf12(:,70), A(:,220), n3(:,1248), t3x72(:,:,220), nhel, den(30))
    call Hcont_QA(nsync, wf6(:,101), wf12(:,71), A(:,221), n3(:,1249), t3x72(:,:,221), nhel, den(10))
    call Hcont_QA(nsync, wf6(:,101), wf12(:,71), A(:,222), n3(:,1250), t3x72(:,:,222), nhel, den(10))
    call Hcont_QA(nsync, wf6(:,102), wf12(:,72), A(:,223), n3(:,1251), t3x72(:,:,223), nhel, den(12))
    call Hcont_QA(nsync, wf6(:,102), wf12(:,72), A(:,224), n3(:,1252), t3x72(:,:,224), nhel, den(12))
    call Hcont_VV(nsync, wf9(:,2), wf8(:,7), A(:,225), n3(:,1253), t3x72(:,:,225), nhel, den(53))
    call Hcont_VV(nsync, wf9(:,2), wf8(:,7), A(:,226), n3(:,1254), t3x72(:,:,226), nhel, den(53))
    call Hcont_VV(nsync, wf9(:,1), wf8(:,7), A(:,227), n3(:,1255), t3x72(:,:,227), nhel, den(53))
    call Hcont_VV(nsync, wf9(:,1), wf8(:,7), A(:,228), n3(:,1256), t3x72(:,:,228), nhel, den(53))
    call Hcont_VV(nsync, wf9(:,2), wf8(:,8), A(:,229), n3(:,1257), t3x72(:,:,229), nhel, den(55))
    call Hcont_VV(nsync, wf9(:,2), wf8(:,8), A(:,230), n3(:,1258), t3x72(:,:,230), nhel, den(55))
    call Hcont_VV(nsync, wf9(:,1), wf8(:,8), A(:,231), n3(:,1259), t3x72(:,:,231), nhel, den(55))
    call Hcont_VV(nsync, wf9(:,1), wf8(:,8), A(:,232), n3(:,1260), t3x72(:,:,232), nhel, den(55))
    call Hcont_QA(nsync, wf6(:,103), wf12(:,73), A(:,233), n3(:,1261), t3x72(:,:,233), nhel, den(5))
    call Hcont_QA(nsync, wf6(:,103), wf12(:,73), A(:,234), n3(:,1262), t3x72(:,:,234), nhel, den(5))
    call Hcont_QA(nsync, wf6(:,104), wf12(:,74), A(:,235), n3(:,1263), t3x72(:,:,235), nhel, den(11))
    call Hcont_QA(nsync, wf6(:,104), wf12(:,74), A(:,236), n3(:,1264), t3x72(:,:,236), nhel, den(11))
    call Hcont_VV(nsync, wf9(:,2), wf8(:,9), A(:,237), n3(:,1265), t3x72(:,:,237), nhel, den(56))
    call Hcont_VV(nsync, wf9(:,2), wf8(:,9), A(:,238), n3(:,1266), t3x72(:,:,238), nhel, den(56))
    call Hcont_VV(nsync, wf9(:,1), wf8(:,9), A(:,239), n3(:,1267), t3x72(:,:,239), nhel, den(56))
    call Hcont_VV(nsync, wf9(:,1), wf8(:,9), A(:,240), n3(:,1268), t3x72(:,:,240), nhel, den(56))
    call Hcont_VV(nsync, wf9(:,2), wf8(:,10), A(:,241), n3(:,1269), t3x72(:,:,241), nhel, den(57))
    call Hcont_VV(nsync, wf9(:,2), wf8(:,10), A(:,242), n3(:,1270), t3x72(:,:,242), nhel, den(57))
    call Hcont_VV(nsync, wf9(:,1), wf8(:,10), A(:,243), n3(:,1271), t3x72(:,:,243), nhel, den(57))
    call Hcont_VV(nsync, wf9(:,1), wf8(:,10), A(:,244), n3(:,1272), t3x72(:,:,244), nhel, den(57))
    call Hcont_QA(nsync, wf6(:,102), wf12(:,75), A(:,245), n3(:,1273), t3x72(:,:,245), nhel, den(3))
    call Hcont_QA(nsync, wf6(:,102), wf12(:,75), A(:,246), n3(:,1274), t3x72(:,:,246), nhel, den(3))
    call Hcont_QA(nsync, wf6(:,101), wf12(:,76), A(:,247), n3(:,1275), t3x72(:,:,247), nhel, den(8))
    call Hcont_QA(nsync, wf6(:,101), wf12(:,76), A(:,248), n3(:,1276), t3x72(:,:,248), nhel, den(8))
    call Hcont_QA(nsync, wf6(:,101), wf12(:,77), A(:,249), n3(:,1277), t3x72(:,:,249), nhel, den(10))
    call Hcont_QA(nsync, wf6(:,101), wf12(:,78), A(:,250), n3(:,1278), t3x72(:,:,250), nhel, den(10))
    call Hcont_QA(nsync, wf6(:,101), wf12(:,79), A(:,251), n3(:,1279), t3x72(:,:,251), nhel, den(10))
    call Hcont_QA(nsync, wf6(:,101), wf12(:,80), A(:,252), n3(:,1280), t3x72(:,:,252), nhel, den(10))
    call Hcont_QA(nsync, wf12(:,81), wf6(:,105), A(:,253), n3(:,1281), t3x72(:,:,253), nhel, den(21))
    call Hcont_QA(nsync, wf12(:,81), wf6(:,106), A(:,254), n3(:,1282), t3x72(:,:,254), nhel, den(21))
    call Hcont_QA(nsync, wf12(:,81), wf6(:,107), A(:,255), n3(:,1283), t3x72(:,:,255), nhel, den(21))
    call Hcont_QA(nsync, wf12(:,81), wf6(:,108), A(:,256), n3(:,1284), t3x72(:,:,256), nhel, den(21))
    call Hcont_VV(nsync, wf8(:,5), wf9(:,7), A(:,257), n3(:,1285), t3x72(:,:,257), nhel, den(59))
    call Hcont_VV(nsync, wf8(:,5), wf9(:,8), A(:,258), n3(:,1286), t3x72(:,:,258), nhel, den(59))
    call Hcont_VV(nsync, wf8(:,5), wf9(:,7), A(:,259), n3(:,1287), t3x72(:,:,259), nhel, den(59))
    call Hcont_VV(nsync, wf8(:,5), wf9(:,8), A(:,260), n3(:,1288), t3x72(:,:,260), nhel, den(59))
    call Hcont_QA(nsync, wf6(:,102), wf12(:,82), A(:,261), n3(:,1289), t3x72(:,:,261), nhel, den(12))
    call Hcont_QA(nsync, wf6(:,102), wf12(:,83), A(:,262), n3(:,1290), t3x72(:,:,262), nhel, den(12))
    call Hcont_QA(nsync, wf6(:,102), wf12(:,84), A(:,263), n3(:,1291), t3x72(:,:,263), nhel, den(12))
    call Hcont_QA(nsync, wf6(:,102), wf12(:,85), A(:,264), n3(:,1292), t3x72(:,:,264), nhel, den(12))
    call Hcont_QA(nsync, wf12(:,86), wf6(:,109), A(:,265), n3(:,1293), t3x72(:,:,265), nhel, den(20))
    call Hcont_QA(nsync, wf12(:,86), wf6(:,110), A(:,266), n3(:,1294), t3x72(:,:,266), nhel, den(20))
    call Hcont_QA(nsync, wf12(:,86), wf6(:,111), A(:,267), n3(:,1295), t3x72(:,:,267), nhel, den(20))
    call Hcont_QA(nsync, wf12(:,86), wf6(:,112), A(:,268), n3(:,1296), t3x72(:,:,268), nhel, den(20))
    call Hcont_VV(nsync, wf8(:,5), wf9(:,9), A(:,269), n3(:,1297), t3x72(:,:,269), nhel, den(59))
    call Hcont_VV(nsync, wf8(:,5), wf9(:,10), A(:,270), n3(:,1298), t3x72(:,:,270), nhel, den(59))
    call Hcont_VV(nsync, wf8(:,5), wf9(:,9), A(:,271), n3(:,1299), t3x72(:,:,271), nhel, den(59))
    call Hcont_VV(nsync, wf8(:,5), wf9(:,10), A(:,272), n3(:,1300), t3x72(:,:,272), nhel, den(59))
    call Hcont_VV(nsync, wf9(:,2), wf8(:,11), A(:,273), n3(:,1301), t3x72(:,:,273), nhel, den(53))
    call Hcont_VV(nsync, wf9(:,1), wf8(:,11), A(:,274), n3(:,1302), t3x72(:,:,274), nhel, den(53))
    call Hcont_VV(nsync, wf9(:,2), wf8(:,12), A(:,275), n3(:,1303), t3x72(:,:,275), nhel, den(55))
    call Hcont_VV(nsync, wf9(:,1), wf8(:,12), A(:,276), n3(:,1304), t3x72(:,:,276), nhel, den(55))
    call Hcont_QA(nsync, wf12(:,86), wf6(:,113), A(:,277), n3(:,1305), t3x72(:,:,277), nhel, den(20))
    call Hcont_QA(nsync, wf12(:,81), wf6(:,114), A(:,278), n3(:,1306), t3x72(:,:,278), nhel, den(21))
    call Hcont_QA(nsync, wf4(:,20), wf18(:,53), A(:,279), n3(:,1307), t3x72(:,:,279), nhel, den(5))
    call Hcont_QA(nsync, wf4(:,20), wf18(:,54), A(:,280), n3(:,1308), t3x72(:,:,280), nhel, den(5))
    call Hcont_QA(nsync, wf4(:,20), wf18(:,55), A(:,281), n3(:,1309), t3x72(:,:,281), nhel, den(5))
    call Hcont_QA(nsync, wf4(:,20), wf18(:,56), A(:,282), n3(:,1310), t3x72(:,:,282), nhel, den(5))
    call Hcont_QA(nsync, wf12(:,74), wf6(:,115), A(:,283), n3(:,1311), t3x72(:,:,283), nhel, den(11))
    call Hcont_QA(nsync, wf12(:,74), wf6(:,116), A(:,284), n3(:,1312), t3x72(:,:,284), nhel, den(11))
    call Hcont_QA(nsync, wf12(:,74), wf6(:,117), A(:,285), n3(:,1313), t3x72(:,:,285), nhel, den(11))
    call Hcont_QA(nsync, wf12(:,74), wf6(:,118), A(:,286), n3(:,1314), t3x72(:,:,286), nhel, den(11))
    call Hcont_VV(nsync, wf9(:,7), wf8(:,13), A(:,287), n3(:,1315), t3x72(:,:,287), nhel, den(60))
    call Hcont_VV(nsync, wf9(:,8), wf8(:,13), A(:,288), n3(:,1316), t3x72(:,:,288), nhel, den(60))
    call Hcont_VV(nsync, wf9(:,7), wf8(:,13), A(:,289), n3(:,1317), t3x72(:,:,289), nhel, den(60))
    call Hcont_VV(nsync, wf9(:,8), wf8(:,13), A(:,290), n3(:,1318), t3x72(:,:,290), nhel, den(60))
    call Hcont_QA(nsync, wf4(:,20), wf18(:,57), A(:,291), n3(:,1319), t3x72(:,:,291), nhel, den(11))
    call Hcont_QA(nsync, wf4(:,20), wf18(:,58), A(:,292), n3(:,1320), t3x72(:,:,292), nhel, den(11))
    call Hcont_QA(nsync, wf4(:,20), wf18(:,59), A(:,293), n3(:,1321), t3x72(:,:,293), nhel, den(11))
    call Hcont_QA(nsync, wf4(:,20), wf18(:,60), A(:,294), n3(:,1322), t3x72(:,:,294), nhel, den(11))
    call Hcont_QA(nsync, wf12(:,73), wf6(:,119), A(:,295), n3(:,1323), t3x72(:,:,295), nhel, den(5))
    call Hcont_QA(nsync, wf12(:,73), wf6(:,120), A(:,296), n3(:,1324), t3x72(:,:,296), nhel, den(5))
    call Hcont_QA(nsync, wf12(:,73), wf6(:,121), A(:,297), n3(:,1325), t3x72(:,:,297), nhel, den(5))
    call Hcont_QA(nsync, wf12(:,73), wf6(:,122), A(:,298), n3(:,1326), t3x72(:,:,298), nhel, den(5))
    call Hcont_VV(nsync, wf9(:,9), wf8(:,13), A(:,299), n3(:,1327), t3x72(:,:,299), nhel, den(60))
    call Hcont_VV(nsync, wf9(:,10), wf8(:,13), A(:,300), n3(:,1328), t3x72(:,:,300), nhel, den(60))
    call Hcont_VV(nsync, wf9(:,9), wf8(:,13), A(:,301), n3(:,1329), t3x72(:,:,301), nhel, den(60))
    call Hcont_VV(nsync, wf9(:,10), wf8(:,13), A(:,302), n3(:,1330), t3x72(:,:,302), nhel, den(60))
    call Hcont_QA(nsync, wf6(:,105), wf12(:,87), A(:,303), n3(:,1331), t3x72(:,:,303), nhel, den(14))
    call Hcont_QA(nsync, wf6(:,106), wf12(:,87), A(:,304), n3(:,1332), t3x72(:,:,304), nhel, den(14))
    call Hcont_QA(nsync, wf6(:,107), wf12(:,87), A(:,305), n3(:,1333), t3x72(:,:,305), nhel, den(14))
    call Hcont_QA(nsync, wf6(:,108), wf12(:,87), A(:,306), n3(:,1334), t3x72(:,:,306), nhel, den(14))
    call Hcont_QA(nsync, wf6(:,115), wf12(:,88), A(:,307), n3(:,1335), t3x72(:,:,307), nhel, den(8))
    call Hcont_QA(nsync, wf6(:,116), wf12(:,88), A(:,308), n3(:,1336), t3x72(:,:,308), nhel, den(8))
    call Hcont_QA(nsync, wf6(:,117), wf12(:,88), A(:,309), n3(:,1337), t3x72(:,:,309), nhel, den(8))
    call Hcont_QA(nsync, wf6(:,118), wf12(:,88), A(:,310), n3(:,1338), t3x72(:,:,310), nhel, den(8))
    call Hcont_QA(nsync, wf6(:,109), wf12(:,89), A(:,311), n3(:,1339), t3x72(:,:,311), nhel, den(18))
    call Hcont_QA(nsync, wf6(:,110), wf12(:,89), A(:,312), n3(:,1340), t3x72(:,:,312), nhel, den(18))
    call Hcont_QA(nsync, wf6(:,111), wf12(:,89), A(:,313), n3(:,1341), t3x72(:,:,313), nhel, den(18))
    call Hcont_QA(nsync, wf6(:,112), wf12(:,89), A(:,314), n3(:,1342), t3x72(:,:,314), nhel, den(18))
    call Hcont_QA(nsync, wf6(:,119), wf12(:,90), A(:,315), n3(:,1343), t3x72(:,:,315), nhel, den(3))
    call Hcont_QA(nsync, wf6(:,120), wf12(:,90), A(:,316), n3(:,1344), t3x72(:,:,316), nhel, den(3))
    call Hcont_QA(nsync, wf6(:,121), wf12(:,90), A(:,317), n3(:,1345), t3x72(:,:,317), nhel, den(3))
    call Hcont_QA(nsync, wf6(:,122), wf12(:,90), A(:,318), n3(:,1346), t3x72(:,:,318), nhel, den(3))
    call Hcont_QA(nsync, wf18(:,61), wf4(:,37), A(:,319), n3(:,1347), t3x72(:,:,319), nhel, den(5))
    call Hcont_QA(nsync, wf6(:,114), wf12(:,87), A(:,320), n3(:,1348), t3x72(:,:,320), nhel, den(14))
    call Hcont_QA(nsync, wf4(:,37), wf18(:,62), A(:,321), n3(:,1349), t3x72(:,:,321), nhel, den(11))
    call Hcont_QA(nsync, wf6(:,113), wf12(:,89), A(:,322), n3(:,1350), t3x72(:,:,322), nhel, den(18))
    call Hcont_QA(nsync, wf4(:,9), wf18(:,64), A(:,323), n3(:,1351), t3x72(:,:,323), nhel, den(61))
    call Hcont_QA(nsync, wf4(:,9), wf18(:,66), A(:,324), n3(:,1352), t3x72(:,:,324), nhel, den(61))
    call Hcont_QA(nsync, wf4(:,9), wf18(:,68), A(:,325), n3(:,1353), t3x72(:,:,325), nhel, den(62))
    call Hcont_QA(nsync, wf4(:,9), wf18(:,70), A(:,326), n3(:,1354), t3x72(:,:,326), nhel, den(62))
    call Hcont_QA(nsync, wf6(:,103), wf12(:,91), A(:,327), n3(:,1355), t3x72(:,:,327), nhel, den(5))
    call Hcont_QA(nsync, wf6(:,103), wf12(:,92), A(:,328), n3(:,1356), t3x72(:,:,328), nhel, den(5))
    call Hcont_QA(nsync, wf6(:,103), wf12(:,93), A(:,329), n3(:,1357), t3x72(:,:,329), nhel, den(5))
    call Hcont_QA(nsync, wf6(:,103), wf12(:,94), A(:,330), n3(:,1358), t3x72(:,:,330), nhel, den(5))
    call Hcont_QA(nsync, wf12(:,95), wf6(:,123), A(:,331), n3(:,1359), t3x72(:,:,331), nhel, den(30))
    call Hcont_QA(nsync, wf12(:,95), wf6(:,124), A(:,332), n3(:,1360), t3x72(:,:,332), nhel, den(30))
    call Hcont_QA(nsync, wf12(:,95), wf6(:,125), A(:,333), n3(:,1361), t3x72(:,:,333), nhel, den(30))
    call Hcont_QA(nsync, wf12(:,95), wf6(:,126), A(:,334), n3(:,1362), t3x72(:,:,334), nhel, den(30))
    call Hcont_VV(nsync, wf8(:,6), wf9(:,11), A(:,335), n3(:,1363), t3x72(:,:,335), nhel, den(60))
    call Hcont_VV(nsync, wf8(:,6), wf9(:,12), A(:,336), n3(:,1364), t3x72(:,:,336), nhel, den(60))
    call Hcont_VV(nsync, wf8(:,6), wf9(:,11), A(:,337), n3(:,1365), t3x72(:,:,337), nhel, den(60))
    call Hcont_VV(nsync, wf8(:,6), wf9(:,12), A(:,338), n3(:,1366), t3x72(:,:,338), nhel, den(60))
    call Hcont_QA(nsync, wf6(:,104), wf12(:,96), A(:,339), n3(:,1367), t3x72(:,:,339), nhel, den(11))
    call Hcont_QA(nsync, wf6(:,104), wf12(:,97), A(:,340), n3(:,1368), t3x72(:,:,340), nhel, den(11))
    call Hcont_QA(nsync, wf6(:,104), wf12(:,98), A(:,341), n3(:,1369), t3x72(:,:,341), nhel, den(11))
    call Hcont_QA(nsync, wf6(:,104), wf12(:,99), A(:,342), n3(:,1370), t3x72(:,:,342), nhel, den(11))
    call Hcont_QA(nsync, wf12(:,100), wf6(:,127), A(:,343), n3(:,1371), t3x72(:,:,343), nhel, den(29))
    call Hcont_QA(nsync, wf12(:,100), wf6(:,128), A(:,344), n3(:,1372), t3x72(:,:,344), nhel, den(29))
    call Hcont_QA(nsync, wf12(:,100), wf6(:,129), A(:,345), n3(:,1373), t3x72(:,:,345), nhel, den(29))
    call Hcont_QA(nsync, wf12(:,100), wf6(:,130), A(:,346), n3(:,1374), t3x72(:,:,346), nhel, den(29))
    call Hcont_VV(nsync, wf8(:,6), wf9(:,13), A(:,347), n3(:,1375), t3x72(:,:,347), nhel, den(60))
    call Hcont_VV(nsync, wf8(:,6), wf9(:,14), A(:,348), n3(:,1376), t3x72(:,:,348), nhel, den(60))
    call Hcont_VV(nsync, wf8(:,6), wf9(:,13), A(:,349), n3(:,1377), t3x72(:,:,349), nhel, den(60))
    call Hcont_VV(nsync, wf8(:,6), wf9(:,14), A(:,350), n3(:,1378), t3x72(:,:,350), nhel, den(60))
    call Hcont_VV(nsync, wf9(:,2), wf8(:,14), A(:,351), n3(:,1379), t3x72(:,:,351), nhel, den(56))
    call Hcont_VV(nsync, wf9(:,1), wf8(:,14), A(:,352), n3(:,1380), t3x72(:,:,352), nhel, den(56))
    call Hcont_VV(nsync, wf9(:,2), wf8(:,15), A(:,353), n3(:,1381), t3x72(:,:,353), nhel, den(57))
    call Hcont_VV(nsync, wf9(:,1), wf8(:,15), A(:,354), n3(:,1382), t3x72(:,:,354), nhel, den(57))
    call Hcont_QA(nsync, wf12(:,100), wf6(:,131), A(:,355), n3(:,1383), t3x72(:,:,355), nhel, den(29))
    call Hcont_QA(nsync, wf12(:,95), wf6(:,132), A(:,356), n3(:,1384), t3x72(:,:,356), nhel, den(30))
    call Hcont_QA(nsync, wf4(:,22), wf18(:,71), A(:,357), n3(:,1385), t3x72(:,:,357), nhel, den(10))
    call Hcont_QA(nsync, wf4(:,22), wf18(:,72), A(:,358), n3(:,1386), t3x72(:,:,358), nhel, den(10))
    call Hcont_QA(nsync, wf4(:,22), wf18(:,73), A(:,359), n3(:,1387), t3x72(:,:,359), nhel, den(10))
    call Hcont_QA(nsync, wf4(:,22), wf18(:,74), A(:,360), n3(:,1388), t3x72(:,:,360), nhel, den(10))
    call Hcont_QA(nsync, wf12(:,72), wf6(:,133), A(:,361), n3(:,1389), t3x72(:,:,361), nhel, den(12))
    call Hcont_QA(nsync, wf12(:,72), wf6(:,134), A(:,362), n3(:,1390), t3x72(:,:,362), nhel, den(12))
    call Hcont_QA(nsync, wf12(:,72), wf6(:,135), A(:,363), n3(:,1391), t3x72(:,:,363), nhel, den(12))
    call Hcont_QA(nsync, wf12(:,72), wf6(:,136), A(:,364), n3(:,1392), t3x72(:,:,364), nhel, den(12))
    call Hcont_VV(nsync, wf9(:,11), wf8(:,16), A(:,365), n3(:,1393), t3x72(:,:,365), nhel, den(59))
    call Hcont_VV(nsync, wf9(:,12), wf8(:,16), A(:,366), n3(:,1394), t3x72(:,:,366), nhel, den(59))
    call Hcont_VV(nsync, wf9(:,11), wf8(:,16), A(:,367), n3(:,1395), t3x72(:,:,367), nhel, den(59))
    call Hcont_VV(nsync, wf9(:,12), wf8(:,16), A(:,368), n3(:,1396), t3x72(:,:,368), nhel, den(59))
    call Hcont_QA(nsync, wf4(:,22), wf18(:,75), A(:,369), n3(:,1397), t3x72(:,:,369), nhel, den(12))
    call Hcont_QA(nsync, wf4(:,22), wf18(:,76), A(:,370), n3(:,1398), t3x72(:,:,370), nhel, den(12))
    call Hcont_QA(nsync, wf4(:,22), wf18(:,77), A(:,371), n3(:,1399), t3x72(:,:,371), nhel, den(12))
    call Hcont_QA(nsync, wf4(:,22), wf18(:,78), A(:,372), n3(:,1400), t3x72(:,:,372), nhel, den(12))
    call Hcont_QA(nsync, wf12(:,71), wf6(:,137), A(:,373), n3(:,1401), t3x72(:,:,373), nhel, den(10))
    call Hcont_QA(nsync, wf12(:,71), wf6(:,138), A(:,374), n3(:,1402), t3x72(:,:,374), nhel, den(10))
    call Hcont_QA(nsync, wf12(:,71), wf6(:,139), A(:,375), n3(:,1403), t3x72(:,:,375), nhel, den(10))
    call Hcont_QA(nsync, wf12(:,71), wf6(:,140), A(:,376), n3(:,1404), t3x72(:,:,376), nhel, den(10))
    call Hcont_VV(nsync, wf9(:,13), wf8(:,16), A(:,377), n3(:,1405), t3x72(:,:,377), nhel, den(59))
    call Hcont_VV(nsync, wf9(:,14), wf8(:,16), A(:,378), n3(:,1406), t3x72(:,:,378), nhel, den(59))
    call Hcont_VV(nsync, wf9(:,13), wf8(:,16), A(:,379), n3(:,1407), t3x72(:,:,379), nhel, den(59))
    call Hcont_VV(nsync, wf9(:,14), wf8(:,16), A(:,380), n3(:,1408), t3x72(:,:,380), nhel, den(59))
    call Hcont_QA(nsync, wf6(:,123), wf12(:,101), A(:,381), n3(:,1409), t3x72(:,:,381), nhel, den(23))
    call Hcont_QA(nsync, wf6(:,124), wf12(:,101), A(:,382), n3(:,1410), t3x72(:,:,382), nhel, den(23))
    call Hcont_QA(nsync, wf6(:,125), wf12(:,101), A(:,383), n3(:,1411), t3x72(:,:,383), nhel, den(23))
    call Hcont_QA(nsync, wf6(:,126), wf12(:,101), A(:,384), n3(:,1412), t3x72(:,:,384), nhel, den(23))
    call Hcont_QA(nsync, wf12(:,75), wf6(:,133), A(:,385), n3(:,1413), t3x72(:,:,385), nhel, den(3))
    call Hcont_QA(nsync, wf12(:,75), wf6(:,134), A(:,386), n3(:,1414), t3x72(:,:,386), nhel, den(3))
    call Hcont_QA(nsync, wf12(:,75), wf6(:,135), A(:,387), n3(:,1415), t3x72(:,:,387), nhel, den(3))
    call Hcont_QA(nsync, wf12(:,75), wf6(:,136), A(:,388), n3(:,1416), t3x72(:,:,388), nhel, den(3))
    call Hcont_QA(nsync, wf6(:,127), wf12(:,102), A(:,389), n3(:,1417), t3x72(:,:,389), nhel, den(27))
    call Hcont_QA(nsync, wf6(:,128), wf12(:,102), A(:,390), n3(:,1418), t3x72(:,:,390), nhel, den(27))
    call Hcont_QA(nsync, wf6(:,129), wf12(:,102), A(:,391), n3(:,1419), t3x72(:,:,391), nhel, den(27))
    call Hcont_QA(nsync, wf6(:,130), wf12(:,102), A(:,392), n3(:,1420), t3x72(:,:,392), nhel, den(27))
    call Hcont_QA(nsync, wf12(:,76), wf6(:,137), A(:,393), n3(:,1421), t3x72(:,:,393), nhel, den(8))
    call Hcont_QA(nsync, wf12(:,76), wf6(:,138), A(:,394), n3(:,1422), t3x72(:,:,394), nhel, den(8))
    call Hcont_QA(nsync, wf12(:,76), wf6(:,139), A(:,395), n3(:,1423), t3x72(:,:,395), nhel, den(8))
    call Hcont_QA(nsync, wf12(:,76), wf6(:,140), A(:,396), n3(:,1424), t3x72(:,:,396), nhel, den(8))
    call Hcont_QA(nsync, wf18(:,79), wf4(:,38), A(:,397), n3(:,1425), t3x72(:,:,397), nhel, den(10))
    call Hcont_QA(nsync, wf6(:,132), wf12(:,101), A(:,398), n3(:,1426), t3x72(:,:,398), nhel, den(23))
    call Hcont_QA(nsync, wf4(:,38), wf18(:,80), A(:,399), n3(:,1427), t3x72(:,:,399), nhel, den(12))
    call Hcont_QA(nsync, wf6(:,131), wf12(:,102), A(:,400), n3(:,1428), t3x72(:,:,400), nhel, den(27))
    call Hcont_QA(nsync, wf4(:,10), wf18(:,82), A(:,401), n3(:,1429), t3x72(:,:,401), nhel, den(63))
    call Hcont_QA(nsync, wf4(:,10), wf18(:,84), A(:,402), n3(:,1430), t3x72(:,:,402), nhel, den(63))
    call Hcont_QA(nsync, wf4(:,10), wf18(:,86), A(:,403), n3(:,1431), t3x72(:,:,403), nhel, den(64))
    call Hcont_QA(nsync, wf4(:,10), wf18(:,88), A(:,404), n3(:,1432), t3x72(:,:,404), nhel, den(64))
    call Hcont_QA(nsync, wf4(:,20), wf18(:,89), A(:,405), n3(:,1433), t3x72(:,:,405), nhel, den(5))
    call Hcont_QA(nsync, wf4(:,20), wf18(:,90), A(:,406), n3(:,1434), t3x72(:,:,406), nhel, den(5))
    call Hcont_QA(nsync, wf4(:,20), wf18(:,91), A(:,407), n3(:,1435), t3x72(:,:,407), nhel, den(5))
    call Hcont_QA(nsync, wf4(:,20), wf18(:,92), A(:,408), n3(:,1436), t3x72(:,:,408), nhel, den(5))
    call Hcont_QA(nsync, wf6(:,105), wf12(:,103), A(:,409), n3(:,1437), t3x72(:,:,409), nhel, den(14))
    call Hcont_QA(nsync, wf6(:,106), wf12(:,103), A(:,410), n3(:,1438), t3x72(:,:,410), nhel, den(14))
    call Hcont_QA(nsync, wf6(:,107), wf12(:,103), A(:,411), n3(:,1439), t3x72(:,:,411), nhel, den(14))
    call Hcont_QA(nsync, wf6(:,108), wf12(:,103), A(:,412), n3(:,1440), t3x72(:,:,412), nhel, den(14))
    call Hcont_QA(nsync, wf4(:,37), wf18(:,93), A(:,413), n3(:,1441), t3x72(:,:,413), nhel, den(5))
    call Hcont_QA(nsync, wf6(:,114), wf12(:,103), A(:,414), n3(:,1442), t3x72(:,:,414), nhel, den(14))
    call Hcont_QA(nsync, wf4(:,22), wf18(:,94), A(:,415), n3(:,1443), t3x72(:,:,415), nhel, den(10))
    call Hcont_QA(nsync, wf4(:,22), wf18(:,95), A(:,416), n3(:,1444), t3x72(:,:,416), nhel, den(10))
    call Hcont_QA(nsync, wf4(:,22), wf18(:,96), A(:,417), n3(:,1445), t3x72(:,:,417), nhel, den(10))
    call Hcont_QA(nsync, wf4(:,22), wf18(:,97), A(:,418), n3(:,1446), t3x72(:,:,418), nhel, den(10))
    call Hcont_QA(nsync, wf6(:,105), wf12(:,105), A(:,419), n3(:,1447), t3x72(:,:,419), nhel, den(21))
    call Hcont_QA(nsync, wf6(:,106), wf12(:,105), A(:,420), n3(:,1448), t3x72(:,:,420), nhel, den(21))
    call Hcont_QA(nsync, wf6(:,107), wf12(:,105), A(:,421), n3(:,1449), t3x72(:,:,421), nhel, den(21))
    call Hcont_QA(nsync, wf6(:,108), wf12(:,105), A(:,422), n3(:,1450), t3x72(:,:,422), nhel, den(21))
    call Hcont_QA(nsync, wf4(:,22), wf18(:,98), A(:,423), n3(:,1451), t3x72(:,:,423), nhel, den(38))
    call Hcont_QA(nsync, wf12(:,71), wf6(:,141), A(:,424), n3(:,1452), t3x72(:,:,424), nhel, den(10))
    call Hcont_QA(nsync, wf6(:,114), wf12(:,105), A(:,425), n3(:,1453), t3x72(:,:,425), nhel, den(21))
    call Hcont_QA(nsync, wf6(:,123), wf12(:,106), A(:,426), n3(:,1454), t3x72(:,:,426), nhel, den(23))
    call Hcont_QA(nsync, wf6(:,124), wf12(:,106), A(:,427), n3(:,1455), t3x72(:,:,427), nhel, den(23))
    call Hcont_QA(nsync, wf6(:,125), wf12(:,106), A(:,428), n3(:,1456), t3x72(:,:,428), nhel, den(23))
    call Hcont_QA(nsync, wf6(:,126), wf12(:,106), A(:,429), n3(:,1457), t3x72(:,:,429), nhel, den(23))
    call Hcont_QA(nsync, wf6(:,123), wf12(:,108), A(:,430), n3(:,1458), t3x72(:,:,430), nhel, den(30))
    call Hcont_QA(nsync, wf6(:,124), wf12(:,108), A(:,431), n3(:,1459), t3x72(:,:,431), nhel, den(30))
    call Hcont_QA(nsync, wf6(:,125), wf12(:,108), A(:,432), n3(:,1460), t3x72(:,:,432), nhel, den(30))
    call Hcont_QA(nsync, wf6(:,126), wf12(:,108), A(:,433), n3(:,1461), t3x72(:,:,433), nhel, den(30))
    call Hcont_QA(nsync, wf4(:,37), wf18(:,99), A(:,434), n3(:,1462), t3x72(:,:,434), nhel, den(39))
    call Hcont_QA(nsync, wf12(:,76), wf6(:,141), A(:,435), n3(:,1463), t3x72(:,:,435), nhel, den(8))
    call Hcont_QA(nsync, wf4(:,9), wf18(:,101), A(:,436), n3(:,1464), t3x72(:,:,436), nhel, den(19))
    call Hcont_QA(nsync, wf4(:,38), wf18(:,102), A(:,437), n3(:,1465), t3x72(:,:,437), nhel, den(10))
    call Hcont_QA(nsync, wf6(:,132), wf12(:,106), A(:,438), n3(:,1466), t3x72(:,:,438), nhel, den(23))
    call Hcont_QA(nsync, wf4(:,20), wf18(:,103), A(:,439), n3(:,1467), t3x72(:,:,439), nhel, den(39))
    call Hcont_QA(nsync, wf12(:,73), wf6(:,142), A(:,440), n3(:,1468), t3x72(:,:,440), nhel, den(5))
    call Hcont_QA(nsync, wf6(:,132), wf12(:,108), A(:,441), n3(:,1469), t3x72(:,:,441), nhel, den(30))
    call Hcont_QA(nsync, wf4(:,38), wf18(:,104), A(:,442), n3(:,1470), t3x72(:,:,442), nhel, den(38))
    call Hcont_QA(nsync, wf12(:,90), wf6(:,142), A(:,443), n3(:,1471), t3x72(:,:,443), nhel, den(3))
    call Hcont_QA(nsync, wf4(:,10), wf18(:,106), A(:,444), n3(:,1472), t3x72(:,:,444), nhel, den(28))
    call Hcont_QA(nsync, wf4(:,20), wf18(:,107), A(:,445), n3(:,1473), t3x72(:,:,445), nhel, den(11))
    call Hcont_QA(nsync, wf4(:,20), wf18(:,108), A(:,446), n3(:,1474), t3x72(:,:,446), nhel, den(11))
    call Hcont_QA(nsync, wf4(:,20), wf18(:,109), A(:,447), n3(:,1475), t3x72(:,:,447), nhel, den(11))
    call Hcont_QA(nsync, wf4(:,20), wf18(:,110), A(:,448), n3(:,1476), t3x72(:,:,448), nhel, den(11))
    call Hcont_QA(nsync, wf6(:,109), wf12(:,110), A(:,449), n3(:,1477), t3x72(:,:,449), nhel, den(18))
    call Hcont_QA(nsync, wf6(:,110), wf12(:,110), A(:,450), n3(:,1478), t3x72(:,:,450), nhel, den(18))
    call Hcont_QA(nsync, wf6(:,111), wf12(:,110), A(:,451), n3(:,1479), t3x72(:,:,451), nhel, den(18))
    call Hcont_QA(nsync, wf6(:,112), wf12(:,110), A(:,452), n3(:,1480), t3x72(:,:,452), nhel, den(18))
    call Hcont_QA(nsync, wf4(:,37), wf18(:,111), A(:,453), n3(:,1481), t3x72(:,:,453), nhel, den(11))
    call Hcont_QA(nsync, wf6(:,113), wf12(:,110), A(:,454), n3(:,1482), t3x72(:,:,454), nhel, den(18))
    call Hcont_QA(nsync, wf4(:,22), wf18(:,112), A(:,455), n3(:,1483), t3x72(:,:,455), nhel, den(12))
    call Hcont_QA(nsync, wf4(:,22), wf18(:,113), A(:,456), n3(:,1484), t3x72(:,:,456), nhel, den(12))
    call Hcont_QA(nsync, wf4(:,22), wf18(:,114), A(:,457), n3(:,1485), t3x72(:,:,457), nhel, den(12))
    call Hcont_QA(nsync, wf4(:,22), wf18(:,115), A(:,458), n3(:,1486), t3x72(:,:,458), nhel, den(12))
    call Hcont_QA(nsync, wf6(:,109), wf12(:,112), A(:,459), n3(:,1487), t3x72(:,:,459), nhel, den(20))
    call Hcont_QA(nsync, wf6(:,110), wf12(:,112), A(:,460), n3(:,1488), t3x72(:,:,460), nhel, den(20))
    call Hcont_QA(nsync, wf6(:,111), wf12(:,112), A(:,461), n3(:,1489), t3x72(:,:,461), nhel, den(20))
    call Hcont_QA(nsync, wf6(:,112), wf12(:,112), A(:,462), n3(:,1490), t3x72(:,:,462), nhel, den(20))
    call Hcont_QA(nsync, wf4(:,22), wf18(:,116), A(:,463), n3(:,1491), t3x72(:,:,463), nhel, den(38))
    call Hcont_QA(nsync, wf12(:,72), wf6(:,143), A(:,464), n3(:,1492), t3x72(:,:,464), nhel, den(12))
    call Hcont_QA(nsync, wf6(:,113), wf12(:,112), A(:,465), n3(:,1493), t3x72(:,:,465), nhel, den(20))
    call Hcont_QA(nsync, wf6(:,127), wf12(:,114), A(:,466), n3(:,1494), t3x72(:,:,466), nhel, den(27))
    call Hcont_QA(nsync, wf6(:,128), wf12(:,114), A(:,467), n3(:,1495), t3x72(:,:,467), nhel, den(27))
    call Hcont_QA(nsync, wf6(:,129), wf12(:,114), A(:,468), n3(:,1496), t3x72(:,:,468), nhel, den(27))
    call Hcont_QA(nsync, wf6(:,130), wf12(:,114), A(:,469), n3(:,1497), t3x72(:,:,469), nhel, den(27))
    call Hcont_QA(nsync, wf6(:,127), wf12(:,116), A(:,470), n3(:,1498), t3x72(:,:,470), nhel, den(29))
    call Hcont_QA(nsync, wf6(:,128), wf12(:,116), A(:,471), n3(:,1499), t3x72(:,:,471), nhel, den(29))
    call Hcont_QA(nsync, wf6(:,129), wf12(:,116), A(:,472), n3(:,1500), t3x72(:,:,472), nhel, den(29))
    call Hcont_QA(nsync, wf6(:,130), wf12(:,116), A(:,473), n3(:,1501), t3x72(:,:,473), nhel, den(29))
    call Hcont_QA(nsync, wf4(:,37), wf18(:,117), A(:,474), n3(:,1502), t3x72(:,:,474), nhel, den(39))
    call Hcont_QA(nsync, wf12(:,75), wf6(:,143), A(:,475), n3(:,1503), t3x72(:,:,475), nhel, den(3))
    call Hcont_QA(nsync, wf4(:,9), wf18(:,119), A(:,476), n3(:,1504), t3x72(:,:,476), nhel, den(16))
    call Hcont_QA(nsync, wf4(:,38), wf18(:,120), A(:,477), n3(:,1505), t3x72(:,:,477), nhel, den(12))
    call Hcont_QA(nsync, wf6(:,131), wf12(:,114), A(:,478), n3(:,1506), t3x72(:,:,478), nhel, den(27))
    call Hcont_QA(nsync, wf4(:,20), wf18(:,121), A(:,479), n3(:,1507), t3x72(:,:,479), nhel, den(39))
    call Hcont_QA(nsync, wf12(:,74), wf6(:,144), A(:,480), n3(:,1508), t3x72(:,:,480), nhel, den(11))
    call Hcont_QA(nsync, wf6(:,131), wf12(:,116), A(:,481), n3(:,1509), t3x72(:,:,481), nhel, den(29))
    call Hcont_QA(nsync, wf4(:,38), wf18(:,122), A(:,482), n3(:,1510), t3x72(:,:,482), nhel, den(38))
    call Hcont_QA(nsync, wf12(:,88), wf6(:,144), A(:,483), n3(:,1511), t3x72(:,:,483), nhel, den(8))
    call Hcont_QA(nsync, wf4(:,10), wf18(:,124), A(:,484), n3(:,1512), t3x72(:,:,484), nhel, den(25))
    call Hcont_QA(nsync, wf12(:,78), wf6(:,137), A(:,485), n3(:,1513), t3x72(:,:,485), nhel, den(10))
    call Hcont_QA(nsync, wf12(:,77), wf6(:,138), A(:,486), n3(:,1514), t3x72(:,:,486), nhel, den(10))
    call Hcont_QA(nsync, wf12(:,80), wf6(:,137), A(:,487), n3(:,1515), t3x72(:,:,487), nhel, den(10))
    call Hcont_QA(nsync, wf12(:,79), wf6(:,138), A(:,488), n3(:,1516), t3x72(:,:,488), nhel, den(10))
    call Hcont_QA(nsync, wf12(:,78), wf6(:,139), A(:,489), n3(:,1517), t3x72(:,:,489), nhel, den(10))
    call Hcont_QA(nsync, wf12(:,77), wf6(:,140), A(:,490), n3(:,1518), t3x72(:,:,490), nhel, den(10))
    call Hcont_QA(nsync, wf12(:,80), wf6(:,139), A(:,491), n3(:,1519), t3x72(:,:,491), nhel, den(10))
    call Hcont_QA(nsync, wf12(:,79), wf6(:,140), A(:,492), n3(:,1520), t3x72(:,:,492), nhel, den(10))
    call Hcont_QA(nsync, wf12(:,82), wf6(:,134), A(:,493), n3(:,1521), t3x72(:,:,493), nhel, den(12))
    call Hcont_QA(nsync, wf12(:,83), wf6(:,133), A(:,494), n3(:,1522), t3x72(:,:,494), nhel, den(12))
    call Hcont_QA(nsync, wf12(:,82), wf6(:,136), A(:,495), n3(:,1523), t3x72(:,:,495), nhel, den(12))
    call Hcont_QA(nsync, wf12(:,83), wf6(:,135), A(:,496), n3(:,1524), t3x72(:,:,496), nhel, den(12))
    call Hcont_QA(nsync, wf12(:,84), wf6(:,134), A(:,497), n3(:,1525), t3x72(:,:,497), nhel, den(12))
    call Hcont_QA(nsync, wf12(:,85), wf6(:,133), A(:,498), n3(:,1526), t3x72(:,:,498), nhel, den(12))
    call Hcont_QA(nsync, wf12(:,84), wf6(:,136), A(:,499), n3(:,1527), t3x72(:,:,499), nhel, den(12))
    call Hcont_QA(nsync, wf12(:,85), wf6(:,135), A(:,500), n3(:,1528), t3x72(:,:,500), nhel, den(12))
    call Hcont_QA(nsync, wf6(:,119), wf12(:,92), A(:,501), n3(:,1529), t3x72(:,:,501), nhel, den(5))
    call Hcont_QA(nsync, wf6(:,120), wf12(:,91), A(:,502), n3(:,1530), t3x72(:,:,502), nhel, den(5))
    call Hcont_QA(nsync, wf6(:,119), wf12(:,94), A(:,503), n3(:,1531), t3x72(:,:,503), nhel, den(5))
    call Hcont_QA(nsync, wf6(:,120), wf12(:,93), A(:,504), n3(:,1532), t3x72(:,:,504), nhel, den(5))
    call Hcont_QA(nsync, wf6(:,121), wf12(:,92), A(:,505), n3(:,1533), t3x72(:,:,505), nhel, den(5))
    call Hcont_QA(nsync, wf6(:,122), wf12(:,91), A(:,506), n3(:,1534), t3x72(:,:,506), nhel, den(5))
    call Hcont_QA(nsync, wf6(:,121), wf12(:,94), A(:,507), n3(:,1535), t3x72(:,:,507), nhel, den(5))
    call Hcont_QA(nsync, wf6(:,122), wf12(:,93), A(:,508), n3(:,1536), t3x72(:,:,508), nhel, den(5))
    call Hcont_QA(nsync, wf6(:,116), wf12(:,96), A(:,509), n3(:,1537), t3x72(:,:,509), nhel, den(11))
    call Hcont_QA(nsync, wf6(:,115), wf12(:,97), A(:,510), n3(:,1538), t3x72(:,:,510), nhel, den(11))
    call Hcont_QA(nsync, wf6(:,118), wf12(:,96), A(:,511), n3(:,1539), t3x72(:,:,511), nhel, den(11))
    call Hcont_QA(nsync, wf6(:,117), wf12(:,97), A(:,512), n3(:,1540), t3x72(:,:,512), nhel, den(11))
    call Hcont_QA(nsync, wf6(:,116), wf12(:,98), A(:,513), n3(:,1541), t3x72(:,:,513), nhel, den(11))
    call Hcont_QA(nsync, wf6(:,115), wf12(:,99), A(:,514), n3(:,1542), t3x72(:,:,514), nhel, den(11))
    call Hcont_QA(nsync, wf6(:,118), wf12(:,98), A(:,515), n3(:,1543), t3x72(:,:,515), nhel, den(11))
    call Hcont_QA(nsync, wf6(:,117), wf12(:,99), A(:,516), n3(:,1544), t3x72(:,:,516), nhel, den(11))
    call Hcont_QA(nsync, wf6(:,134), wf12(:,117), A(:,517), n3(:,1545), t3x72(:,:,517), nhel, den(3))
    call Hcont_QA(nsync, wf6(:,133), wf12(:,118), A(:,518), n3(:,1546), t3x72(:,:,518), nhel, den(3))
    call Hcont_QA(nsync, wf6(:,136), wf12(:,117), A(:,519), n3(:,1547), t3x72(:,:,519), nhel, den(3))
    call Hcont_QA(nsync, wf6(:,135), wf12(:,118), A(:,520), n3(:,1548), t3x72(:,:,520), nhel, den(3))
    call Hcont_QA(nsync, wf6(:,134), wf12(:,119), A(:,521), n3(:,1549), t3x72(:,:,521), nhel, den(3))
    call Hcont_QA(nsync, wf6(:,133), wf12(:,120), A(:,522), n3(:,1550), t3x72(:,:,522), nhel, den(3))
    call Hcont_QA(nsync, wf6(:,136), wf12(:,119), A(:,523), n3(:,1551), t3x72(:,:,523), nhel, den(3))
    call Hcont_QA(nsync, wf6(:,135), wf12(:,120), A(:,524), n3(:,1552), t3x72(:,:,524), nhel, den(3))
    call Hcont_QA(nsync, wf6(:,137), wf12(:,121), A(:,525), n3(:,1553), t3x72(:,:,525), nhel, den(8))
    call Hcont_QA(nsync, wf6(:,138), wf12(:,122), A(:,526), n3(:,1554), t3x72(:,:,526), nhel, den(8))
    call Hcont_QA(nsync, wf6(:,137), wf12(:,123), A(:,527), n3(:,1555), t3x72(:,:,527), nhel, den(8))
    call Hcont_QA(nsync, wf6(:,138), wf12(:,124), A(:,528), n3(:,1556), t3x72(:,:,528), nhel, den(8))
    call Hcont_QA(nsync, wf6(:,139), wf12(:,121), A(:,529), n3(:,1557), t3x72(:,:,529), nhel, den(8))
    call Hcont_QA(nsync, wf6(:,140), wf12(:,122), A(:,530), n3(:,1558), t3x72(:,:,530), nhel, den(8))
    call Hcont_QA(nsync, wf6(:,139), wf12(:,123), A(:,531), n3(:,1559), t3x72(:,:,531), nhel, den(8))
    call Hcont_QA(nsync, wf6(:,140), wf12(:,124), A(:,532), n3(:,1560), t3x72(:,:,532), nhel, den(8))
    call Hcont_QA(nsync, wf4(:,37), wf18(:,125), A(:,533), n3(:,1561), t3x72(:,:,533), nhel, den(5))
    call Hcont_QA(nsync, wf4(:,37), wf18(:,126), A(:,534), n3(:,1562), t3x72(:,:,534), nhel, den(5))
    call Hcont_QA(nsync, wf12(:,5), wf6(:,145), A(:,535), n3(:,1563), t3x72(:,:,535), nhel, den(14))
    call Hcont_QA(nsync, wf12(:,5), wf6(:,146), A(:,536), n3(:,1564), t3x72(:,:,536), nhel, den(14))
    call Hcont_QA(nsync, wf12(:,77), wf6(:,141), A(:,537), n3(:,1565), t3x72(:,:,537), nhel, den(10))
    call Hcont_QA(nsync, wf12(:,79), wf6(:,141), A(:,538), n3(:,1566), t3x72(:,:,538), nhel, den(10))
    call Hcont_QA(nsync, wf12(:,8), wf6(:,145), A(:,539), n3(:,1567), t3x72(:,:,539), nhel, den(21))
    call Hcont_QA(nsync, wf12(:,8), wf6(:,146), A(:,540), n3(:,1568), t3x72(:,:,540), nhel, den(21))
    call Hcont_QA(nsync, wf6(:,141), wf12(:,122), A(:,541), n3(:,1569), t3x72(:,:,541), nhel, den(8))
    call Hcont_QA(nsync, wf6(:,141), wf12(:,124), A(:,542), n3(:,1570), t3x72(:,:,542), nhel, den(8))
    call Hcont_QA(nsync, wf4(:,37), wf18(:,127), A(:,543), n3(:,1571), t3x72(:,:,543), nhel, den(11))
    call Hcont_QA(nsync, wf4(:,37), wf18(:,128), A(:,544), n3(:,1572), t3x72(:,:,544), nhel, den(11))
    call Hcont_QA(nsync, wf4(:,37), wf18(:,129), A(:,545), n3(:,1573), t3x72(:,:,545), nhel, den(11))
    call Hcont_QA(nsync, wf4(:,37), wf18(:,130), A(:,546), n3(:,1574), t3x72(:,:,546), nhel, den(11))
    call Hcont_QA(nsync, wf12(:,6), wf6(:,147), A(:,547), n3(:,1575), t3x72(:,:,547), nhel, den(18))
    call Hcont_QA(nsync, wf12(:,6), wf6(:,148), A(:,548), n3(:,1576), t3x72(:,:,548), nhel, den(18))
    call Hcont_QA(nsync, wf12(:,82), wf6(:,143), A(:,549), n3(:,1577), t3x72(:,:,549), nhel, den(12))
    call Hcont_QA(nsync, wf12(:,84), wf6(:,143), A(:,550), n3(:,1578), t3x72(:,:,550), nhel, den(12))
    call Hcont_QA(nsync, wf12(:,7), wf6(:,147), A(:,551), n3(:,1579), t3x72(:,:,551), nhel, den(20))
    call Hcont_QA(nsync, wf12(:,7), wf6(:,148), A(:,552), n3(:,1580), t3x72(:,:,552), nhel, den(20))
    call Hcont_QA(nsync, wf6(:,143), wf12(:,117), A(:,553), n3(:,1581), t3x72(:,:,553), nhel, den(3))
    call Hcont_QA(nsync, wf6(:,143), wf12(:,119), A(:,554), n3(:,1582), t3x72(:,:,554), nhel, den(3))
    call Hcont_QA(nsync, wf4(:,37), wf18(:,131), A(:,555), n3(:,1583), t3x72(:,:,555), nhel, den(5))
    call Hcont_QA(nsync, wf4(:,37), wf18(:,132), A(:,556), n3(:,1584), t3x72(:,:,556), nhel, den(5))
    call Hcont_QA(nsync, wf4(:,38), wf18(:,133), A(:,557), n3(:,1585), t3x72(:,:,557), nhel, den(10))
    call Hcont_QA(nsync, wf4(:,38), wf18(:,134), A(:,558), n3(:,1586), t3x72(:,:,558), nhel, den(10))
    call Hcont_QA(nsync, wf12(:,10), wf6(:,149), A(:,559), n3(:,1587), t3x72(:,:,559), nhel, den(23))
    call Hcont_QA(nsync, wf12(:,10), wf6(:,150), A(:,560), n3(:,1588), t3x72(:,:,560), nhel, den(23))
    call Hcont_QA(nsync, wf12(:,92), wf6(:,142), A(:,561), n3(:,1589), t3x72(:,:,561), nhel, den(5))
    call Hcont_QA(nsync, wf12(:,94), wf6(:,142), A(:,562), n3(:,1590), t3x72(:,:,562), nhel, den(5))
    call Hcont_QA(nsync, wf12(:,16), wf6(:,149), A(:,563), n3(:,1591), t3x72(:,:,563), nhel, den(30))
    call Hcont_QA(nsync, wf12(:,16), wf6(:,150), A(:,564), n3(:,1592), t3x72(:,:,564), nhel, den(30))
    call Hcont_QA(nsync, wf6(:,142), wf12(:,125), A(:,565), n3(:,1593), t3x72(:,:,565), nhel, den(3))
    call Hcont_QA(nsync, wf6(:,142), wf12(:,126), A(:,566), n3(:,1594), t3x72(:,:,566), nhel, den(3))
    call Hcont_QA(nsync, wf4(:,38), wf18(:,135), A(:,567), n3(:,1595), t3x72(:,:,567), nhel, den(12))
    call Hcont_QA(nsync, wf4(:,38), wf18(:,136), A(:,568), n3(:,1596), t3x72(:,:,568), nhel, den(12))
    call Hcont_QA(nsync, wf4(:,38), wf18(:,137), A(:,569), n3(:,1597), t3x72(:,:,569), nhel, den(12))
    call Hcont_QA(nsync, wf4(:,38), wf18(:,138), A(:,570), n3(:,1598), t3x72(:,:,570), nhel, den(12))
    call Hcont_QA(nsync, wf12(:,12), wf6(:,151), A(:,571), n3(:,1599), t3x72(:,:,571), nhel, den(27))
    call Hcont_QA(nsync, wf12(:,12), wf6(:,152), A(:,572), n3(:,1600), t3x72(:,:,572), nhel, den(27))
    call Hcont_QA(nsync, wf12(:,97), wf6(:,144), A(:,573), n3(:,1601), t3x72(:,:,573), nhel, den(11))
    call Hcont_QA(nsync, wf12(:,99), wf6(:,144), A(:,574), n3(:,1602), t3x72(:,:,574), nhel, den(11))
    call Hcont_QA(nsync, wf12(:,14), wf6(:,151), A(:,575), n3(:,1603), t3x72(:,:,575), nhel, den(29))
    call Hcont_QA(nsync, wf12(:,14), wf6(:,152), A(:,576), n3(:,1604), t3x72(:,:,576), nhel, den(29))
    call Hcont_QA(nsync, wf6(:,144), wf12(:,127), A(:,577), n3(:,1605), t3x72(:,:,577), nhel, den(8))
    call Hcont_QA(nsync, wf6(:,144), wf12(:,128), A(:,578), n3(:,1606), t3x72(:,:,578), nhel, den(8))
    call Hcont_QA(nsync, wf4(:,38), wf18(:,139), A(:,579), n3(:,1607), t3x72(:,:,579), nhel, den(10))
    call Hcont_QA(nsync, wf4(:,38), wf18(:,140), A(:,580), n3(:,1608), t3x72(:,:,580), nhel, den(10))
    call Hcont_QA(nsync, wf6(:,143), wf12(:,129), A(:,581), n3(:,1609), t3x72(:,:,581), nhel, den(3))
    call Hcont_QA(nsync, wf4(:,37), wf18(:,141), A(:,582), n3(:,1610), t3x72(:,:,582), nhel, den(5))
    call Hcont_QA(nsync, wf6(:,144), wf12(:,130), A(:,583), n3(:,1611), t3x72(:,:,583), nhel, den(8))
    call Hcont_QA(nsync, wf4(:,37), wf18(:,142), A(:,584), n3(:,1612), t3x72(:,:,584), nhel, den(11))
    call Hcont_QA(nsync, wf4(:,38), wf18(:,143), A(:,585), n3(:,1613), t3x72(:,:,585), nhel, den(10))
    call Hcont_QA(nsync, wf4(:,38), wf18(:,144), A(:,586), n3(:,1614), t3x72(:,:,586), nhel, den(12))
    call Hcont_QA(nsync, wf12(:,77), wf6(:,137), A(:,587), n3(:,1615), t3x72(:,:,587), nhel, den(10))
    call Hcont_QA(nsync, wf12(:,78), wf6(:,138), A(:,588), n3(:,1616), t3x72(:,:,588), nhel, den(10))
    call Hcont_QA(nsync, wf12(:,79), wf6(:,137), A(:,589), n3(:,1617), t3x72(:,:,589), nhel, den(10))
    call Hcont_QA(nsync, wf12(:,80), wf6(:,138), A(:,590), n3(:,1618), t3x72(:,:,590), nhel, den(10))
    call Hcont_QA(nsync, wf12(:,77), wf6(:,139), A(:,591), n3(:,1619), t3x72(:,:,591), nhel, den(10))
    call Hcont_QA(nsync, wf12(:,78), wf6(:,140), A(:,592), n3(:,1620), t3x72(:,:,592), nhel, den(10))
    call Hcont_QA(nsync, wf12(:,79), wf6(:,139), A(:,593), n3(:,1621), t3x72(:,:,593), nhel, den(10))
    call Hcont_QA(nsync, wf12(:,80), wf6(:,140), A(:,594), n3(:,1622), t3x72(:,:,594), nhel, den(10))
    call Hcont_QA(nsync, wf12(:,82), wf6(:,133), A(:,595), n3(:,1623), t3x72(:,:,595), nhel, den(12))
    call Hcont_QA(nsync, wf12(:,83), wf6(:,134), A(:,596), n3(:,1624), t3x72(:,:,596), nhel, den(12))
    call Hcont_QA(nsync, wf12(:,82), wf6(:,135), A(:,597), n3(:,1625), t3x72(:,:,597), nhel, den(12))
    call Hcont_QA(nsync, wf12(:,83), wf6(:,136), A(:,598), n3(:,1626), t3x72(:,:,598), nhel, den(12))
    call Hcont_QA(nsync, wf12(:,84), wf6(:,133), A(:,599), n3(:,1627), t3x72(:,:,599), nhel, den(12))
    call Hcont_QA(nsync, wf12(:,85), wf6(:,134), A(:,600), n3(:,1628), t3x72(:,:,600), nhel, den(12))
    call Hcont_QA(nsync, wf12(:,84), wf6(:,135), A(:,601), n3(:,1629), t3x72(:,:,601), nhel, den(12))
    call Hcont_QA(nsync, wf12(:,85), wf6(:,136), A(:,602), n3(:,1630), t3x72(:,:,602), nhel, den(12))
    call Hcont_QA(nsync, wf6(:,119), wf12(:,91), A(:,603), n3(:,1631), t3x72(:,:,603), nhel, den(5))
    call Hcont_QA(nsync, wf6(:,120), wf12(:,92), A(:,604), n3(:,1632), t3x72(:,:,604), nhel, den(5))
    call Hcont_QA(nsync, wf6(:,119), wf12(:,93), A(:,605), n3(:,1633), t3x72(:,:,605), nhel, den(5))
    call Hcont_QA(nsync, wf6(:,120), wf12(:,94), A(:,606), n3(:,1634), t3x72(:,:,606), nhel, den(5))
    call Hcont_QA(nsync, wf6(:,121), wf12(:,91), A(:,607), n3(:,1635), t3x72(:,:,607), nhel, den(5))
    call Hcont_QA(nsync, wf6(:,122), wf12(:,92), A(:,608), n3(:,1636), t3x72(:,:,608), nhel, den(5))
    call Hcont_QA(nsync, wf6(:,121), wf12(:,93), A(:,609), n3(:,1637), t3x72(:,:,609), nhel, den(5))
    call Hcont_QA(nsync, wf6(:,122), wf12(:,94), A(:,610), n3(:,1638), t3x72(:,:,610), nhel, den(5))
    call Hcont_QA(nsync, wf6(:,115), wf12(:,96), A(:,611), n3(:,1639), t3x72(:,:,611), nhel, den(11))
    call Hcont_QA(nsync, wf6(:,116), wf12(:,97), A(:,612), n3(:,1640), t3x72(:,:,612), nhel, den(11))
    call Hcont_QA(nsync, wf6(:,117), wf12(:,96), A(:,613), n3(:,1641), t3x72(:,:,613), nhel, den(11))
    call Hcont_QA(nsync, wf6(:,118), wf12(:,97), A(:,614), n3(:,1642), t3x72(:,:,614), nhel, den(11))
    call Hcont_QA(nsync, wf6(:,115), wf12(:,98), A(:,615), n3(:,1643), t3x72(:,:,615), nhel, den(11))
    call Hcont_QA(nsync, wf6(:,116), wf12(:,99), A(:,616), n3(:,1644), t3x72(:,:,616), nhel, den(11))
    call Hcont_QA(nsync, wf6(:,117), wf12(:,98), A(:,617), n3(:,1645), t3x72(:,:,617), nhel, den(11))
    call Hcont_QA(nsync, wf6(:,118), wf12(:,99), A(:,618), n3(:,1646), t3x72(:,:,618), nhel, den(11))
    call Hcont_QA(nsync, wf6(:,133), wf12(:,117), A(:,619), n3(:,1647), t3x72(:,:,619), nhel, den(3))
    call Hcont_QA(nsync, wf6(:,134), wf12(:,118), A(:,620), n3(:,1648), t3x72(:,:,620), nhel, den(3))
    call Hcont_QA(nsync, wf6(:,135), wf12(:,117), A(:,621), n3(:,1649), t3x72(:,:,621), nhel, den(3))
    call Hcont_QA(nsync, wf6(:,136), wf12(:,118), A(:,622), n3(:,1650), t3x72(:,:,622), nhel, den(3))
    call Hcont_QA(nsync, wf6(:,133), wf12(:,119), A(:,623), n3(:,1651), t3x72(:,:,623), nhel, den(3))
    call Hcont_QA(nsync, wf6(:,134), wf12(:,120), A(:,624), n3(:,1652), t3x72(:,:,624), nhel, den(3))
    call Hcont_QA(nsync, wf6(:,135), wf12(:,119), A(:,625), n3(:,1653), t3x72(:,:,625), nhel, den(3))
    call Hcont_QA(nsync, wf6(:,136), wf12(:,120), A(:,626), n3(:,1654), t3x72(:,:,626), nhel, den(3))
    call Hcont_QA(nsync, wf6(:,137), wf12(:,122), A(:,627), n3(:,1655), t3x72(:,:,627), nhel, den(8))
    call Hcont_QA(nsync, wf6(:,138), wf12(:,121), A(:,628), n3(:,1656), t3x72(:,:,628), nhel, den(8))
    call Hcont_QA(nsync, wf6(:,137), wf12(:,124), A(:,629), n3(:,1657), t3x72(:,:,629), nhel, den(8))
    call Hcont_QA(nsync, wf6(:,138), wf12(:,123), A(:,630), n3(:,1658), t3x72(:,:,630), nhel, den(8))
    call Hcont_QA(nsync, wf6(:,139), wf12(:,122), A(:,631), n3(:,1659), t3x72(:,:,631), nhel, den(8))
    call Hcont_QA(nsync, wf6(:,140), wf12(:,121), A(:,632), n3(:,1660), t3x72(:,:,632), nhel, den(8))
    call Hcont_QA(nsync, wf6(:,139), wf12(:,124), A(:,633), n3(:,1661), t3x72(:,:,633), nhel, den(8))
    call Hcont_QA(nsync, wf6(:,140), wf12(:,123), A(:,634), n3(:,1662), t3x72(:,:,634), nhel, den(8))
    call Hcont_QA(nsync, wf4(:,37), wf18(:,145), A(:,635), n3(:,1663), t3x72(:,:,635), nhel, den(5))
    call Hcont_QA(nsync, wf4(:,37), wf18(:,146), A(:,636), n3(:,1664), t3x72(:,:,636), nhel, den(5))
    call Hcont_QA(nsync, wf12(:,5), wf6(:,153), A(:,637), n3(:,1665), t3x72(:,:,637), nhel, den(14))
    call Hcont_QA(nsync, wf12(:,5), wf6(:,154), A(:,638), n3(:,1666), t3x72(:,:,638), nhel, den(14))
    call Hcont_QA(nsync, wf12(:,78), wf6(:,141), A(:,639), n3(:,1667), t3x72(:,:,639), nhel, den(10))
    call Hcont_QA(nsync, wf12(:,80), wf6(:,141), A(:,640), n3(:,1668), t3x72(:,:,640), nhel, den(10))
    call Hcont_QA(nsync, wf12(:,8), wf6(:,153), A(:,641), n3(:,1669), t3x72(:,:,641), nhel, den(21))
    call Hcont_QA(nsync, wf12(:,8), wf6(:,154), A(:,642), n3(:,1670), t3x72(:,:,642), nhel, den(21))
    call Hcont_QA(nsync, wf6(:,141), wf12(:,121), A(:,643), n3(:,1671), t3x72(:,:,643), nhel, den(8))
    call Hcont_QA(nsync, wf6(:,141), wf12(:,123), A(:,644), n3(:,1672), t3x72(:,:,644), nhel, den(8))
    call Hcont_QA(nsync, wf4(:,37), wf18(:,147), A(:,645), n3(:,1673), t3x72(:,:,645), nhel, den(11))
    call Hcont_QA(nsync, wf4(:,37), wf18(:,148), A(:,646), n3(:,1674), t3x72(:,:,646), nhel, den(11))
    call Hcont_QA(nsync, wf4(:,37), wf18(:,149), A(:,647), n3(:,1675), t3x72(:,:,647), nhel, den(11))
    call Hcont_QA(nsync, wf4(:,37), wf18(:,150), A(:,648), n3(:,1676), t3x72(:,:,648), nhel, den(11))
    call Hcont_QA(nsync, wf12(:,6), wf6(:,155), A(:,649), n3(:,1677), t3x72(:,:,649), nhel, den(18))
    call Hcont_QA(nsync, wf12(:,6), wf6(:,156), A(:,650), n3(:,1678), t3x72(:,:,650), nhel, den(18))
    call Hcont_QA(nsync, wf12(:,83), wf6(:,143), A(:,651), n3(:,1679), t3x72(:,:,651), nhel, den(12))
    call Hcont_QA(nsync, wf12(:,85), wf6(:,143), A(:,652), n3(:,1680), t3x72(:,:,652), nhel, den(12))
    call Hcont_QA(nsync, wf12(:,7), wf6(:,155), A(:,653), n3(:,1681), t3x72(:,:,653), nhel, den(20))
    call Hcont_QA(nsync, wf12(:,7), wf6(:,156), A(:,654), n3(:,1682), t3x72(:,:,654), nhel, den(20))
    call Hcont_QA(nsync, wf6(:,143), wf12(:,118), A(:,655), n3(:,1683), t3x72(:,:,655), nhel, den(3))
    call Hcont_QA(nsync, wf6(:,143), wf12(:,120), A(:,656), n3(:,1684), t3x72(:,:,656), nhel, den(3))
    call Hcont_QA(nsync, wf4(:,37), wf18(:,151), A(:,657), n3(:,1685), t3x72(:,:,657), nhel, den(5))
    call Hcont_QA(nsync, wf4(:,37), wf18(:,152), A(:,658), n3(:,1686), t3x72(:,:,658), nhel, den(5))
    call Hcont_QA(nsync, wf4(:,38), wf18(:,153), A(:,659), n3(:,1687), t3x72(:,:,659), nhel, den(10))
    call Hcont_QA(nsync, wf4(:,38), wf18(:,154), A(:,660), n3(:,1688), t3x72(:,:,660), nhel, den(10))
    call Hcont_QA(nsync, wf12(:,10), wf6(:,157), A(:,661), n3(:,1689), t3x72(:,:,661), nhel, den(23))
    call Hcont_QA(nsync, wf12(:,10), wf6(:,158), A(:,662), n3(:,1690), t3x72(:,:,662), nhel, den(23))
    call Hcont_QA(nsync, wf12(:,91), wf6(:,142), A(:,663), n3(:,1691), t3x72(:,:,663), nhel, den(5))
    call Hcont_QA(nsync, wf12(:,93), wf6(:,142), A(:,664), n3(:,1692), t3x72(:,:,664), nhel, den(5))
    call Hcont_QA(nsync, wf12(:,16), wf6(:,157), A(:,665), n3(:,1693), t3x72(:,:,665), nhel, den(30))
    call Hcont_QA(nsync, wf12(:,16), wf6(:,158), A(:,666), n3(:,1694), t3x72(:,:,666), nhel, den(30))
    call Hcont_QA(nsync, wf6(:,142), wf12(:,131), A(:,667), n3(:,1695), t3x72(:,:,667), nhel, den(3))
    call Hcont_QA(nsync, wf6(:,142), wf12(:,132), A(:,668), n3(:,1696), t3x72(:,:,668), nhel, den(3))
    call Hcont_QA(nsync, wf4(:,38), wf18(:,155), A(:,669), n3(:,1697), t3x72(:,:,669), nhel, den(12))
    call Hcont_QA(nsync, wf4(:,38), wf18(:,156), A(:,670), n3(:,1698), t3x72(:,:,670), nhel, den(12))
    call Hcont_QA(nsync, wf4(:,38), wf18(:,157), A(:,671), n3(:,1699), t3x72(:,:,671), nhel, den(12))
    call Hcont_QA(nsync, wf4(:,38), wf18(:,158), A(:,672), n3(:,1700), t3x72(:,:,672), nhel, den(12))
    call Hcont_QA(nsync, wf12(:,12), wf6(:,159), A(:,673), n3(:,1701), t3x72(:,:,673), nhel, den(27))
    call Hcont_QA(nsync, wf12(:,12), wf6(:,160), A(:,674), n3(:,1702), t3x72(:,:,674), nhel, den(27))
    call Hcont_QA(nsync, wf12(:,96), wf6(:,144), A(:,675), n3(:,1703), t3x72(:,:,675), nhel, den(11))
    call Hcont_QA(nsync, wf12(:,98), wf6(:,144), A(:,676), n3(:,1704), t3x72(:,:,676), nhel, den(11))
    call Hcont_QA(nsync, wf12(:,14), wf6(:,159), A(:,677), n3(:,1705), t3x72(:,:,677), nhel, den(29))
    call Hcont_QA(nsync, wf12(:,14), wf6(:,160), A(:,678), n3(:,1706), t3x72(:,:,678), nhel, den(29))
    call Hcont_QA(nsync, wf6(:,144), wf12(:,133), A(:,679), n3(:,1707), t3x72(:,:,679), nhel, den(8))
    call Hcont_QA(nsync, wf6(:,144), wf12(:,134), A(:,680), n3(:,1708), t3x72(:,:,680), nhel, den(8))
    call Hcont_QA(nsync, wf4(:,38), wf18(:,159), A(:,681), n3(:,1709), t3x72(:,:,681), nhel, den(10))
    call Hcont_QA(nsync, wf4(:,38), wf18(:,160), A(:,682), n3(:,1710), t3x72(:,:,682), nhel, den(10))
    call Hcont_VV(nsync, wf24(:,9), wf3(:,9), A(:,683), n3(:,1711), t3x72(:,:,683), nhel, den(10))
    call Hcont_VV(nsync, wf24(:,9), wf3(:,10), A(:,684), n3(:,1712), t3x72(:,:,684), nhel, den(10))
    call Hcont_VV(nsync, wf24(:,9), wf3(:,9), A(:,685), n3(:,1713), t3x72(:,:,685), nhel, den(10))
    call Hcont_VV(nsync, wf24(:,9), wf3(:,10), A(:,686), n3(:,1714), t3x72(:,:,686), nhel, den(10))
    call Hcont_VV(nsync, wf24(:,10), wf3(:,11), A(:,687), n3(:,1715), t3x72(:,:,687), nhel, den(21))
    call Hcont_VV(nsync, wf24(:,10), wf3(:,12), A(:,688), n3(:,1716), t3x72(:,:,688), nhel, den(21))
    call Hcont_VV(nsync, wf24(:,10), wf3(:,11), A(:,689), n3(:,1717), t3x72(:,:,689), nhel, den(21))
    call Hcont_VV(nsync, wf24(:,10), wf3(:,12), A(:,690), n3(:,1718), t3x72(:,:,690), nhel, den(21))
    call Hcont_VV(nsync, wf3(:,9), wf24(:,11), A(:,691), n3(:,1719), t3x72(:,:,691), nhel, den(32))
    call Hcont_VV(nsync, wf3(:,10), wf24(:,11), A(:,692), n3(:,1720), t3x72(:,:,692), nhel, den(32))
    call Hcont_VV(nsync, wf3(:,11), wf24(:,12), A(:,693), n3(:,1721), t3x72(:,:,693), nhel, den(32))
    call Hcont_VV(nsync, wf3(:,12), wf24(:,12), A(:,694), n3(:,1722), t3x72(:,:,694), nhel, den(32))
    call Hcont_VV(nsync, wf3(:,9), wf24(:,13), A(:,695), n3(:,1723), t3x72(:,:,695), nhel, den(34))
    call Hcont_VV(nsync, wf3(:,10), wf24(:,13), A(:,696), n3(:,1724), t3x72(:,:,696), nhel, den(34))
    call Hcont_VV(nsync, wf3(:,11), wf24(:,14), A(:,697), n3(:,1725), t3x72(:,:,697), nhel, den(34))
    call Hcont_VV(nsync, wf3(:,12), wf24(:,14), A(:,698), n3(:,1726), t3x72(:,:,698), nhel, den(34))
    call Hcont_VV(nsync, wf3(:,9), wf24(:,11), A(:,699), n3(:,1727), t3x72(:,:,699), nhel, den(32))
    call Hcont_VV(nsync, wf3(:,10), wf24(:,11), A(:,700), n3(:,1728), t3x72(:,:,700), nhel, den(32))
    call Hcont_VV(nsync, wf3(:,11), wf24(:,12), A(:,701), n3(:,1729), t3x72(:,:,701), nhel, den(32))
    call Hcont_VV(nsync, wf3(:,12), wf24(:,12), A(:,702), n3(:,1730), t3x72(:,:,702), nhel, den(32))
    call Hcont_VV(nsync, wf3(:,9), wf24(:,13), A(:,703), n3(:,1731), t3x72(:,:,703), nhel, den(34))
    call Hcont_VV(nsync, wf3(:,10), wf24(:,13), A(:,704), n3(:,1732), t3x72(:,:,704), nhel, den(34))
    call Hcont_VV(nsync, wf3(:,11), wf24(:,14), A(:,705), n3(:,1733), t3x72(:,:,705), nhel, den(34))
    call Hcont_VV(nsync, wf3(:,12), wf24(:,14), A(:,706), n3(:,1734), t3x72(:,:,706), nhel, den(34))
    call Hcont_VV(nsync, wf24(:,15), wf3(:,13), A(:,707), n3(:,1735), t3x72(:,:,707), nhel, den(12))
    call Hcont_VV(nsync, wf24(:,15), wf3(:,14), A(:,708), n3(:,1736), t3x72(:,:,708), nhel, den(12))
    call Hcont_VV(nsync, wf24(:,15), wf3(:,13), A(:,709), n3(:,1737), t3x72(:,:,709), nhel, den(12))
    call Hcont_VV(nsync, wf24(:,15), wf3(:,14), A(:,710), n3(:,1738), t3x72(:,:,710), nhel, den(12))
    call Hcont_VV(nsync, wf24(:,16), wf3(:,15), A(:,711), n3(:,1739), t3x72(:,:,711), nhel, den(20))
    call Hcont_VV(nsync, wf24(:,16), wf3(:,16), A(:,712), n3(:,1740), t3x72(:,:,712), nhel, den(20))
    call Hcont_VV(nsync, wf24(:,16), wf3(:,15), A(:,713), n3(:,1741), t3x72(:,:,713), nhel, den(20))
    call Hcont_VV(nsync, wf24(:,16), wf3(:,16), A(:,714), n3(:,1742), t3x72(:,:,714), nhel, den(20))
    call Hcont_VV(nsync, wf3(:,13), wf24(:,17), A(:,715), n3(:,1743), t3x72(:,:,715), nhel, den(32))
    call Hcont_VV(nsync, wf3(:,14), wf24(:,17), A(:,716), n3(:,1744), t3x72(:,:,716), nhel, den(32))
    call Hcont_VV(nsync, wf3(:,15), wf24(:,18), A(:,717), n3(:,1745), t3x72(:,:,717), nhel, den(32))
    call Hcont_VV(nsync, wf3(:,16), wf24(:,18), A(:,718), n3(:,1746), t3x72(:,:,718), nhel, den(32))
    call Hcont_VV(nsync, wf3(:,13), wf24(:,19), A(:,719), n3(:,1747), t3x72(:,:,719), nhel, den(34))
    call Hcont_VV(nsync, wf3(:,14), wf24(:,19), A(:,720), n3(:,1748), t3x72(:,:,720), nhel, den(34))
    call Hcont_VV(nsync, wf3(:,15), wf24(:,20), A(:,721), n3(:,1749), t3x72(:,:,721), nhel, den(34))
    call Hcont_VV(nsync, wf3(:,16), wf24(:,20), A(:,722), n3(:,1750), t3x72(:,:,722), nhel, den(34))
    call Hcont_VV(nsync, wf3(:,13), wf24(:,17), A(:,723), n3(:,1751), t3x72(:,:,723), nhel, den(32))
    call Hcont_VV(nsync, wf3(:,14), wf24(:,17), A(:,724), n3(:,1752), t3x72(:,:,724), nhel, den(32))
    call Hcont_VV(nsync, wf3(:,15), wf24(:,18), A(:,725), n3(:,1753), t3x72(:,:,725), nhel, den(32))
    call Hcont_VV(nsync, wf3(:,16), wf24(:,18), A(:,726), n3(:,1754), t3x72(:,:,726), nhel, den(32))
    call Hcont_VV(nsync, wf3(:,13), wf24(:,19), A(:,727), n3(:,1755), t3x72(:,:,727), nhel, den(34))
    call Hcont_VV(nsync, wf3(:,14), wf24(:,19), A(:,728), n3(:,1756), t3x72(:,:,728), nhel, den(34))
    call Hcont_VV(nsync, wf3(:,15), wf24(:,20), A(:,729), n3(:,1757), t3x72(:,:,729), nhel, den(34))
    call Hcont_VV(nsync, wf3(:,16), wf24(:,20), A(:,730), n3(:,1758), t3x72(:,:,730), nhel, den(34))
    call Hcont_VV(nsync, wf3(:,11), wf24(:,21), A(:,731), n3(:,1759), t3x72(:,:,731), nhel, den(5))
    call Hcont_VV(nsync, wf3(:,12), wf24(:,21), A(:,732), n3(:,1760), t3x72(:,:,732), nhel, den(5))
    call Hcont_VV(nsync, wf3(:,11), wf24(:,21), A(:,733), n3(:,1761), t3x72(:,:,733), nhel, den(5))
    call Hcont_VV(nsync, wf3(:,12), wf24(:,21), A(:,734), n3(:,1762), t3x72(:,:,734), nhel, den(5))
    call Hcont_VV(nsync, wf3(:,9), wf24(:,22), A(:,735), n3(:,1763), t3x72(:,:,735), nhel, den(30))
    call Hcont_VV(nsync, wf3(:,10), wf24(:,22), A(:,736), n3(:,1764), t3x72(:,:,736), nhel, den(30))
    call Hcont_VV(nsync, wf3(:,9), wf24(:,22), A(:,737), n3(:,1765), t3x72(:,:,737), nhel, den(30))
    call Hcont_VV(nsync, wf3(:,10), wf24(:,22), A(:,738), n3(:,1766), t3x72(:,:,738), nhel, den(30))
    call Hcont_VV(nsync, wf3(:,9), wf24(:,23), A(:,739), n3(:,1767), t3x72(:,:,739), nhel, den(35))
    call Hcont_VV(nsync, wf3(:,10), wf24(:,23), A(:,740), n3(:,1768), t3x72(:,:,740), nhel, den(35))
    call Hcont_VV(nsync, wf3(:,11), wf24(:,24), A(:,741), n3(:,1769), t3x72(:,:,741), nhel, den(35))
    call Hcont_VV(nsync, wf3(:,12), wf24(:,24), A(:,742), n3(:,1770), t3x72(:,:,742), nhel, den(35))
    call Hcont_VV(nsync, wf3(:,9), wf24(:,25), A(:,743), n3(:,1771), t3x72(:,:,743), nhel, den(36))
    call Hcont_VV(nsync, wf3(:,10), wf24(:,25), A(:,744), n3(:,1772), t3x72(:,:,744), nhel, den(36))
    call Hcont_VV(nsync, wf3(:,11), wf24(:,26), A(:,745), n3(:,1773), t3x72(:,:,745), nhel, den(36))
    call Hcont_VV(nsync, wf3(:,12), wf24(:,26), A(:,746), n3(:,1774), t3x72(:,:,746), nhel, den(36))
    call Hcont_VV(nsync, wf3(:,9), wf24(:,23), A(:,747), n3(:,1775), t3x72(:,:,747), nhel, den(35))
    call Hcont_VV(nsync, wf3(:,10), wf24(:,23), A(:,748), n3(:,1776), t3x72(:,:,748), nhel, den(35))
    call Hcont_VV(nsync, wf3(:,11), wf24(:,24), A(:,749), n3(:,1777), t3x72(:,:,749), nhel, den(35))
    call Hcont_VV(nsync, wf3(:,12), wf24(:,24), A(:,750), n3(:,1778), t3x72(:,:,750), nhel, den(35))
    call Hcont_VV(nsync, wf3(:,9), wf24(:,25), A(:,751), n3(:,1779), t3x72(:,:,751), nhel, den(36))
    call Hcont_VV(nsync, wf3(:,10), wf24(:,25), A(:,752), n3(:,1780), t3x72(:,:,752), nhel, den(36))
    call Hcont_VV(nsync, wf3(:,11), wf24(:,26), A(:,753), n3(:,1781), t3x72(:,:,753), nhel, den(36))
    call Hcont_VV(nsync, wf3(:,12), wf24(:,26), A(:,754), n3(:,1782), t3x72(:,:,754), nhel, den(36))
    call Hcont_VV(nsync, wf3(:,15), wf24(:,27), A(:,755), n3(:,1783), t3x72(:,:,755), nhel, den(11))
    call Hcont_VV(nsync, wf3(:,16), wf24(:,27), A(:,756), n3(:,1784), t3x72(:,:,756), nhel, den(11))
    call Hcont_VV(nsync, wf3(:,15), wf24(:,27), A(:,757), n3(:,1785), t3x72(:,:,757), nhel, den(11))
    call Hcont_VV(nsync, wf3(:,16), wf24(:,27), A(:,758), n3(:,1786), t3x72(:,:,758), nhel, den(11))
    call Hcont_VV(nsync, wf3(:,13), wf24(:,28), A(:,759), n3(:,1787), t3x72(:,:,759), nhel, den(29))
    call Hcont_VV(nsync, wf3(:,14), wf24(:,28), A(:,760), n3(:,1788), t3x72(:,:,760), nhel, den(29))
    call Hcont_VV(nsync, wf3(:,13), wf24(:,28), A(:,761), n3(:,1789), t3x72(:,:,761), nhel, den(29))
    call Hcont_VV(nsync, wf3(:,14), wf24(:,28), A(:,762), n3(:,1790), t3x72(:,:,762), nhel, den(29))
    call Hcont_VV(nsync, wf3(:,13), wf24(:,29), A(:,763), n3(:,1791), t3x72(:,:,763), nhel, den(35))
    call Hcont_VV(nsync, wf3(:,14), wf24(:,29), A(:,764), n3(:,1792), t3x72(:,:,764), nhel, den(35))
    call Hcont_VV(nsync, wf3(:,15), wf24(:,30), A(:,765), n3(:,1793), t3x72(:,:,765), nhel, den(35))
    call Hcont_VV(nsync, wf3(:,16), wf24(:,30), A(:,766), n3(:,1794), t3x72(:,:,766), nhel, den(35))
    call Hcont_VV(nsync, wf3(:,13), wf24(:,31), A(:,767), n3(:,1795), t3x72(:,:,767), nhel, den(36))
    call Hcont_VV(nsync, wf3(:,14), wf24(:,31), A(:,768), n3(:,1796), t3x72(:,:,768), nhel, den(36))
    call Hcont_VV(nsync, wf3(:,15), wf24(:,32), A(:,769), n3(:,1797), t3x72(:,:,769), nhel, den(36))
    call Hcont_VV(nsync, wf3(:,16), wf24(:,32), A(:,770), n3(:,1798), t3x72(:,:,770), nhel, den(36))
    call Hcont_VV(nsync, wf3(:,13), wf24(:,29), A(:,771), n3(:,1799), t3x72(:,:,771), nhel, den(35))
    call Hcont_VV(nsync, wf3(:,14), wf24(:,29), A(:,772), n3(:,1800), t3x72(:,:,772), nhel, den(35))
    call Hcont_VV(nsync, wf3(:,15), wf24(:,30), A(:,773), n3(:,1801), t3x72(:,:,773), nhel, den(35))
    call Hcont_VV(nsync, wf3(:,16), wf24(:,30), A(:,774), n3(:,1802), t3x72(:,:,774), nhel, den(35))
    call Hcont_VV(nsync, wf3(:,13), wf24(:,31), A(:,775), n3(:,1803), t3x72(:,:,775), nhel, den(36))
    call Hcont_VV(nsync, wf3(:,14), wf24(:,31), A(:,776), n3(:,1804), t3x72(:,:,776), nhel, den(36))
    call Hcont_VV(nsync, wf3(:,15), wf24(:,32), A(:,777), n3(:,1805), t3x72(:,:,777), nhel, den(36))
    call Hcont_VV(nsync, wf3(:,16), wf24(:,32), A(:,778), n3(:,1806), t3x72(:,:,778), nhel, den(36))
    call Hcont_QA(nsync, wf12(:,87), wf6(:,161), A(:,779), n3(:,1807), t3x72(:,:,779), nhel, den(14))
    call Hcont_QA(nsync, wf12(:,87), wf6(:,162), A(:,780), n3(:,1808), t3x72(:,:,780), nhel, den(14))
    call Hcont_QA(nsync, wf12(:,87), wf6(:,161), A(:,781), n3(:,1809), t3x72(:,:,781), nhel, den(14))
    call Hcont_QA(nsync, wf12(:,87), wf6(:,162), A(:,782), n3(:,1810), t3x72(:,:,782), nhel, den(14))
    call Hcont_QA(nsync, wf12(:,101), wf6(:,163), A(:,783), n3(:,1811), t3x72(:,:,783), nhel, den(23))
    call Hcont_QA(nsync, wf12(:,101), wf6(:,164), A(:,784), n3(:,1812), t3x72(:,:,784), nhel, den(23))
    call Hcont_QA(nsync, wf12(:,101), wf6(:,163), A(:,785), n3(:,1813), t3x72(:,:,785), nhel, den(23))
    call Hcont_QA(nsync, wf12(:,101), wf6(:,164), A(:,786), n3(:,1814), t3x72(:,:,786), nhel, den(23))
    call Hcont_QA(nsync, wf12(:,89), wf6(:,165), A(:,787), n3(:,1815), t3x72(:,:,787), nhel, den(18))
    call Hcont_QA(nsync, wf12(:,89), wf6(:,166), A(:,788), n3(:,1816), t3x72(:,:,788), nhel, den(18))
    call Hcont_QA(nsync, wf12(:,89), wf6(:,165), A(:,789), n3(:,1817), t3x72(:,:,789), nhel, den(18))
    call Hcont_QA(nsync, wf12(:,89), wf6(:,166), A(:,790), n3(:,1818), t3x72(:,:,790), nhel, den(18))
    call Hcont_QA(nsync, wf12(:,102), wf6(:,167), A(:,791), n3(:,1819), t3x72(:,:,791), nhel, den(27))
    call Hcont_QA(nsync, wf12(:,102), wf6(:,168), A(:,792), n3(:,1820), t3x72(:,:,792), nhel, den(27))
    call Hcont_QA(nsync, wf12(:,102), wf6(:,167), A(:,793), n3(:,1821), t3x72(:,:,793), nhel, den(27))
    call Hcont_QA(nsync, wf12(:,102), wf6(:,168), A(:,794), n3(:,1822), t3x72(:,:,794), nhel, den(27))
    call Hcont_VV(nsync, wf3(:,9), wf24(:,33), A(:,795), n3(:,1823), t3x72(:,:,795), nhel, den(5))
    call Hcont_VV(nsync, wf3(:,10), wf24(:,33), A(:,796), n3(:,1824), t3x72(:,:,796), nhel, den(5))
    call Hcont_VV(nsync, wf3(:,9), wf24(:,33), A(:,797), n3(:,1825), t3x72(:,:,797), nhel, den(5))
    call Hcont_VV(nsync, wf3(:,10), wf24(:,33), A(:,798), n3(:,1826), t3x72(:,:,798), nhel, den(5))
    call Hcont_VV(nsync, wf3(:,9), wf24(:,34), A(:,799), n3(:,1827), t3x72(:,:,799), nhel, den(14))
    call Hcont_VV(nsync, wf3(:,10), wf24(:,34), A(:,800), n3(:,1828), t3x72(:,:,800), nhel, den(14))
    call Hcont_VV(nsync, wf3(:,9), wf24(:,34), A(:,801), n3(:,1829), t3x72(:,:,801), nhel, den(14))
    call Hcont_VV(nsync, wf3(:,10), wf24(:,34), A(:,802), n3(:,1830), t3x72(:,:,802), nhel, den(14))
    call Hcont_QA(nsync, wf36(:,1), wf2(:,17), A(:,803), n3(:,1831), t3x72(:,:,803), nhel, den(16))
    call Hcont_QA(nsync, wf2(:,17), wf36(:,2), A(:,804), n3(:,1832), t3x72(:,:,804), nhel, den(14))
    call Hcont_VV(nsync, wf3(:,9), wf24(:,35), A(:,805), n3(:,1833), t3x72(:,:,805), nhel, den(10))
    call Hcont_VV(nsync, wf3(:,10), wf24(:,35), A(:,806), n3(:,1834), t3x72(:,:,806), nhel, den(10))
    call Hcont_VV(nsync, wf3(:,9), wf24(:,35), A(:,807), n3(:,1835), t3x72(:,:,807), nhel, den(10))
    call Hcont_VV(nsync, wf3(:,10), wf24(:,35), A(:,808), n3(:,1836), t3x72(:,:,808), nhel, den(10))
    call Hcont_VV(nsync, wf3(:,9), wf24(:,36), A(:,809), n3(:,1837), t3x72(:,:,809), nhel, den(59))
    call Hcont_VV(nsync, wf3(:,10), wf24(:,36), A(:,810), n3(:,1838), t3x72(:,:,810), nhel, den(59))
    call Hcont_VV(nsync, wf3(:,9), wf24(:,36), A(:,811), n3(:,1839), t3x72(:,:,811), nhel, den(59))
    call Hcont_VV(nsync, wf3(:,10), wf24(:,36), A(:,812), n3(:,1840), t3x72(:,:,812), nhel, den(59))
    call Hcont_VV(nsync, wf3(:,9), wf24(:,37), A(:,813), n3(:,1841), t3x72(:,:,813), nhel, den(21))
    call Hcont_VV(nsync, wf3(:,10), wf24(:,37), A(:,814), n3(:,1842), t3x72(:,:,814), nhel, den(21))
    call Hcont_VV(nsync, wf3(:,9), wf24(:,37), A(:,815), n3(:,1843), t3x72(:,:,815), nhel, den(21))
    call Hcont_VV(nsync, wf3(:,10), wf24(:,37), A(:,816), n3(:,1844), t3x72(:,:,816), nhel, den(21))
    call Hcont_QA(nsync, wf2(:,17), wf36(:,3), A(:,817), n3(:,1845), t3x72(:,:,817), nhel, den(38))
    call Hcont_QA(nsync, wf2(:,17), wf36(:,4), A(:,818), n3(:,1846), t3x72(:,:,818), nhel, den(20))
    call Hcont_QA(nsync, wf2(:,17), wf36(:,5), A(:,819), n3(:,1847), t3x72(:,:,819), nhel, den(21))
    call Hcont_QA(nsync, wf12(:,106), wf6(:,163), A(:,820), n3(:,1848), t3x72(:,:,820), nhel, den(23))
    call Hcont_QA(nsync, wf12(:,106), wf6(:,164), A(:,821), n3(:,1849), t3x72(:,:,821), nhel, den(23))
    call Hcont_QA(nsync, wf12(:,106), wf6(:,163), A(:,822), n3(:,1850), t3x72(:,:,822), nhel, den(23))
    call Hcont_QA(nsync, wf12(:,106), wf6(:,164), A(:,823), n3(:,1851), t3x72(:,:,823), nhel, den(23))
    call Hcont_QA(nsync, wf12(:,108), wf6(:,163), A(:,824), n3(:,1852), t3x72(:,:,824), nhel, den(30))
    call Hcont_QA(nsync, wf12(:,108), wf6(:,164), A(:,825), n3(:,1853), t3x72(:,:,825), nhel, den(30))
    call Hcont_QA(nsync, wf12(:,108), wf6(:,163), A(:,826), n3(:,1854), t3x72(:,:,826), nhel, den(30))
    call Hcont_QA(nsync, wf12(:,108), wf6(:,164), A(:,827), n3(:,1855), t3x72(:,:,827), nhel, den(30))
    call Hcont_VV(nsync, wf8(:,13), wf9(:,15), A(:,828), n3(:,1856), t3x72(:,:,828), nhel, den(60))
    call Hcont_VV(nsync, wf8(:,13), wf9(:,16), A(:,829), n3(:,1857), t3x72(:,:,829), nhel, den(60))
    call Hcont_VV(nsync, wf8(:,13), wf9(:,15), A(:,830), n3(:,1858), t3x72(:,:,830), nhel, den(60))
    call Hcont_VV(nsync, wf8(:,13), wf9(:,16), A(:,831), n3(:,1859), t3x72(:,:,831), nhel, den(60))
    call Hcont_QA(nsync, wf12(:,89), wf6(:,169), A(:,832), n3(:,1860), t3x72(:,:,832), nhel, den(18))
    call Hcont_QA(nsync, wf18(:,162), wf4(:,39), A(:,833), n3(:,1861), t3x72(:,:,833), nhel, den(19))
    call Hcont_QA(nsync, wf4(:,39), wf18(:,163), A(:,834), n3(:,1862), t3x72(:,:,834), nhel, den(65))
    call Hcont_VV(nsync, wf3(:,13), wf24(:,38), A(:,835), n3(:,1863), t3x72(:,:,835), nhel, den(11))
    call Hcont_VV(nsync, wf3(:,14), wf24(:,38), A(:,836), n3(:,1864), t3x72(:,:,836), nhel, den(11))
    call Hcont_VV(nsync, wf3(:,13), wf24(:,38), A(:,837), n3(:,1865), t3x72(:,:,837), nhel, den(11))
    call Hcont_VV(nsync, wf3(:,14), wf24(:,38), A(:,838), n3(:,1866), t3x72(:,:,838), nhel, den(11))
    call Hcont_VV(nsync, wf3(:,13), wf24(:,39), A(:,839), n3(:,1867), t3x72(:,:,839), nhel, den(18))
    call Hcont_VV(nsync, wf3(:,14), wf24(:,39), A(:,840), n3(:,1868), t3x72(:,:,840), nhel, den(18))
    call Hcont_VV(nsync, wf3(:,13), wf24(:,39), A(:,841), n3(:,1869), t3x72(:,:,841), nhel, den(18))
    call Hcont_VV(nsync, wf3(:,14), wf24(:,39), A(:,842), n3(:,1870), t3x72(:,:,842), nhel, den(18))
    call Hcont_QA(nsync, wf2(:,17), wf36(:,6), A(:,843), n3(:,1871), t3x72(:,:,843), nhel, den(19))
    call Hcont_QA(nsync, wf2(:,17), wf36(:,7), A(:,844), n3(:,1872), t3x72(:,:,844), nhel, den(18))
    call Hcont_VV(nsync, wf3(:,13), wf24(:,40), A(:,845), n3(:,1873), t3x72(:,:,845), nhel, den(12))
    call Hcont_VV(nsync, wf3(:,14), wf24(:,40), A(:,846), n3(:,1874), t3x72(:,:,846), nhel, den(12))
    call Hcont_VV(nsync, wf3(:,13), wf24(:,40), A(:,847), n3(:,1875), t3x72(:,:,847), nhel, den(12))
    call Hcont_VV(nsync, wf3(:,14), wf24(:,40), A(:,848), n3(:,1876), t3x72(:,:,848), nhel, den(12))
    call Hcont_VV(nsync, wf3(:,13), wf24(:,41), A(:,849), n3(:,1877), t3x72(:,:,849), nhel, den(59))
    call Hcont_VV(nsync, wf3(:,14), wf24(:,41), A(:,850), n3(:,1878), t3x72(:,:,850), nhel, den(59))
    call Hcont_VV(nsync, wf3(:,13), wf24(:,41), A(:,851), n3(:,1879), t3x72(:,:,851), nhel, den(59))
    call Hcont_VV(nsync, wf3(:,14), wf24(:,41), A(:,852), n3(:,1880), t3x72(:,:,852), nhel, den(59))
    call Hcont_VV(nsync, wf3(:,13), wf24(:,42), A(:,853), n3(:,1881), t3x72(:,:,853), nhel, den(20))
    call Hcont_VV(nsync, wf3(:,14), wf24(:,42), A(:,854), n3(:,1882), t3x72(:,:,854), nhel, den(20))
    call Hcont_VV(nsync, wf3(:,13), wf24(:,42), A(:,855), n3(:,1883), t3x72(:,:,855), nhel, den(20))
    call Hcont_VV(nsync, wf3(:,14), wf24(:,42), A(:,856), n3(:,1884), t3x72(:,:,856), nhel, den(20))
    call Hcont_QA(nsync, wf2(:,17), wf36(:,8), A(:,857), n3(:,1885), t3x72(:,:,857), nhel, den(38))
    call Hcont_QA(nsync, wf2(:,17), wf36(:,9), A(:,858), n3(:,1886), t3x72(:,:,858), nhel, den(21))
    call Hcont_QA(nsync, wf2(:,17), wf36(:,10), A(:,859), n3(:,1887), t3x72(:,:,859), nhel, den(20))
    call Hcont_QA(nsync, wf12(:,114), wf6(:,167), A(:,860), n3(:,1888), t3x72(:,:,860), nhel, den(27))
    call Hcont_QA(nsync, wf12(:,114), wf6(:,168), A(:,861), n3(:,1889), t3x72(:,:,861), nhel, den(27))
    call Hcont_QA(nsync, wf12(:,114), wf6(:,167), A(:,862), n3(:,1890), t3x72(:,:,862), nhel, den(27))
    call Hcont_QA(nsync, wf12(:,114), wf6(:,168), A(:,863), n3(:,1891), t3x72(:,:,863), nhel, den(27))
    call Hcont_QA(nsync, wf12(:,116), wf6(:,167), A(:,864), n3(:,1892), t3x72(:,:,864), nhel, den(29))
    call Hcont_QA(nsync, wf12(:,116), wf6(:,168), A(:,865), n3(:,1893), t3x72(:,:,865), nhel, den(29))
    call Hcont_QA(nsync, wf12(:,116), wf6(:,167), A(:,866), n3(:,1894), t3x72(:,:,866), nhel, den(29))
    call Hcont_QA(nsync, wf12(:,116), wf6(:,168), A(:,867), n3(:,1895), t3x72(:,:,867), nhel, den(29))
    call Hcont_VV(nsync, wf8(:,13), wf9(:,17), A(:,868), n3(:,1896), t3x72(:,:,868), nhel, den(60))
    call Hcont_VV(nsync, wf8(:,13), wf9(:,18), A(:,869), n3(:,1897), t3x72(:,:,869), nhel, den(60))
    call Hcont_VV(nsync, wf8(:,13), wf9(:,17), A(:,870), n3(:,1898), t3x72(:,:,870), nhel, den(60))
    call Hcont_VV(nsync, wf8(:,13), wf9(:,18), A(:,871), n3(:,1899), t3x72(:,:,871), nhel, den(60))
    call Hcont_QA(nsync, wf12(:,87), wf6(:,170), A(:,872), n3(:,1900), t3x72(:,:,872), nhel, den(14))
    call Hcont_QA(nsync, wf4(:,39), wf18(:,165), A(:,873), n3(:,1901), t3x72(:,:,873), nhel, den(16))
    call Hcont_QA(nsync, wf4(:,39), wf18(:,166), A(:,874), n3(:,1902), t3x72(:,:,874), nhel, den(65))
    call Hcont_VV(nsync, wf3(:,11), wf24(:,43), A(:,875), n3(:,1903), t3x72(:,:,875), nhel, den(10))
    call Hcont_VV(nsync, wf3(:,12), wf24(:,43), A(:,876), n3(:,1904), t3x72(:,:,876), nhel, den(10))
    call Hcont_VV(nsync, wf3(:,11), wf24(:,43), A(:,877), n3(:,1905), t3x72(:,:,877), nhel, den(10))
    call Hcont_VV(nsync, wf3(:,12), wf24(:,43), A(:,878), n3(:,1906), t3x72(:,:,878), nhel, den(10))
    call Hcont_VV(nsync, wf3(:,11), wf24(:,44), A(:,879), n3(:,1907), t3x72(:,:,879), nhel, den(23))
    call Hcont_VV(nsync, wf3(:,12), wf24(:,44), A(:,880), n3(:,1908), t3x72(:,:,880), nhel, den(23))
    call Hcont_VV(nsync, wf3(:,11), wf24(:,44), A(:,881), n3(:,1909), t3x72(:,:,881), nhel, den(23))
    call Hcont_VV(nsync, wf3(:,12), wf24(:,44), A(:,882), n3(:,1910), t3x72(:,:,882), nhel, den(23))
    call Hcont_QA(nsync, wf36(:,11), wf2(:,18), A(:,883), n3(:,1911), t3x72(:,:,883), nhel, den(25))
    call Hcont_QA(nsync, wf2(:,18), wf36(:,12), A(:,884), n3(:,1912), t3x72(:,:,884), nhel, den(23))
    call Hcont_VV(nsync, wf3(:,11), wf24(:,45), A(:,885), n3(:,1913), t3x72(:,:,885), nhel, den(5))
    call Hcont_VV(nsync, wf3(:,12), wf24(:,45), A(:,886), n3(:,1914), t3x72(:,:,886), nhel, den(5))
    call Hcont_VV(nsync, wf3(:,11), wf24(:,45), A(:,887), n3(:,1915), t3x72(:,:,887), nhel, den(5))
    call Hcont_VV(nsync, wf3(:,12), wf24(:,45), A(:,888), n3(:,1916), t3x72(:,:,888), nhel, den(5))
    call Hcont_VV(nsync, wf3(:,11), wf24(:,46), A(:,889), n3(:,1917), t3x72(:,:,889), nhel, den(60))
    call Hcont_VV(nsync, wf3(:,12), wf24(:,46), A(:,890), n3(:,1918), t3x72(:,:,890), nhel, den(60))
    call Hcont_VV(nsync, wf3(:,11), wf24(:,46), A(:,891), n3(:,1919), t3x72(:,:,891), nhel, den(60))
    call Hcont_VV(nsync, wf3(:,12), wf24(:,46), A(:,892), n3(:,1920), t3x72(:,:,892), nhel, den(60))
    call Hcont_VV(nsync, wf3(:,11), wf24(:,47), A(:,893), n3(:,1921), t3x72(:,:,893), nhel, den(30))
    call Hcont_VV(nsync, wf3(:,12), wf24(:,47), A(:,894), n3(:,1922), t3x72(:,:,894), nhel, den(30))
    call Hcont_VV(nsync, wf3(:,11), wf24(:,47), A(:,895), n3(:,1923), t3x72(:,:,895), nhel, den(30))
    call Hcont_VV(nsync, wf3(:,12), wf24(:,47), A(:,896), n3(:,1924), t3x72(:,:,896), nhel, den(30))
    call Hcont_QA(nsync, wf2(:,18), wf36(:,13), A(:,897), n3(:,1925), t3x72(:,:,897), nhel, den(39))
    call Hcont_QA(nsync, wf2(:,18), wf36(:,14), A(:,898), n3(:,1926), t3x72(:,:,898), nhel, den(29))
    call Hcont_QA(nsync, wf2(:,18), wf36(:,15), A(:,899), n3(:,1927), t3x72(:,:,899), nhel, den(30))
    call Hcont_QA(nsync, wf12(:,103), wf6(:,161), A(:,900), n3(:,1928), t3x72(:,:,900), nhel, den(14))
    call Hcont_QA(nsync, wf12(:,103), wf6(:,162), A(:,901), n3(:,1929), t3x72(:,:,901), nhel, den(14))
    call Hcont_QA(nsync, wf12(:,103), wf6(:,161), A(:,902), n3(:,1930), t3x72(:,:,902), nhel, den(14))
    call Hcont_QA(nsync, wf12(:,103), wf6(:,162), A(:,903), n3(:,1931), t3x72(:,:,903), nhel, den(14))
    call Hcont_QA(nsync, wf12(:,105), wf6(:,161), A(:,904), n3(:,1932), t3x72(:,:,904), nhel, den(21))
    call Hcont_QA(nsync, wf12(:,105), wf6(:,162), A(:,905), n3(:,1933), t3x72(:,:,905), nhel, den(21))
    call Hcont_QA(nsync, wf12(:,105), wf6(:,161), A(:,906), n3(:,1934), t3x72(:,:,906), nhel, den(21))
    call Hcont_QA(nsync, wf12(:,105), wf6(:,162), A(:,907), n3(:,1935), t3x72(:,:,907), nhel, den(21))
    call Hcont_VV(nsync, wf8(:,16), wf9(:,19), A(:,908), n3(:,1936), t3x72(:,:,908), nhel, den(59))
    call Hcont_VV(nsync, wf8(:,16), wf9(:,20), A(:,909), n3(:,1937), t3x72(:,:,909), nhel, den(59))
    call Hcont_VV(nsync, wf8(:,16), wf9(:,19), A(:,910), n3(:,1938), t3x72(:,:,910), nhel, den(59))
    call Hcont_VV(nsync, wf8(:,16), wf9(:,20), A(:,911), n3(:,1939), t3x72(:,:,911), nhel, den(59))
    call Hcont_QA(nsync, wf12(:,102), wf6(:,171), A(:,912), n3(:,1940), t3x72(:,:,912), nhel, den(27))
    call Hcont_QA(nsync, wf18(:,168), wf4(:,40), A(:,913), n3(:,1941), t3x72(:,:,913), nhel, den(28))
    call Hcont_QA(nsync, wf4(:,40), wf18(:,169), A(:,914), n3(:,1942), t3x72(:,:,914), nhel, den(66))
    call Hcont_VV(nsync, wf3(:,15), wf24(:,48), A(:,915), n3(:,1943), t3x72(:,:,915), nhel, den(12))
    call Hcont_VV(nsync, wf3(:,16), wf24(:,48), A(:,916), n3(:,1944), t3x72(:,:,916), nhel, den(12))
    call Hcont_VV(nsync, wf3(:,15), wf24(:,48), A(:,917), n3(:,1945), t3x72(:,:,917), nhel, den(12))
    call Hcont_VV(nsync, wf3(:,16), wf24(:,48), A(:,918), n3(:,1946), t3x72(:,:,918), nhel, den(12))
    call Hcont_VV(nsync, wf3(:,15), wf24(:,49), A(:,919), n3(:,1947), t3x72(:,:,919), nhel, den(27))
    call Hcont_VV(nsync, wf3(:,16), wf24(:,49), A(:,920), n3(:,1948), t3x72(:,:,920), nhel, den(27))
    call Hcont_VV(nsync, wf3(:,15), wf24(:,49), A(:,921), n3(:,1949), t3x72(:,:,921), nhel, den(27))
    call Hcont_VV(nsync, wf3(:,16), wf24(:,49), A(:,922), n3(:,1950), t3x72(:,:,922), nhel, den(27))
    call Hcont_QA(nsync, wf2(:,18), wf36(:,16), A(:,923), n3(:,1951), t3x72(:,:,923), nhel, den(28))
    call Hcont_QA(nsync, wf2(:,18), wf36(:,17), A(:,924), n3(:,1952), t3x72(:,:,924), nhel, den(27))
    call Hcont_VV(nsync, wf3(:,15), wf24(:,50), A(:,925), n3(:,1953), t3x72(:,:,925), nhel, den(11))
    call Hcont_VV(nsync, wf3(:,16), wf24(:,50), A(:,926), n3(:,1954), t3x72(:,:,926), nhel, den(11))
    call Hcont_VV(nsync, wf3(:,15), wf24(:,50), A(:,927), n3(:,1955), t3x72(:,:,927), nhel, den(11))
    call Hcont_VV(nsync, wf3(:,16), wf24(:,50), A(:,928), n3(:,1956), t3x72(:,:,928), nhel, den(11))
    call Hcont_VV(nsync, wf3(:,15), wf24(:,51), A(:,929), n3(:,1957), t3x72(:,:,929), nhel, den(60))
    call Hcont_VV(nsync, wf3(:,16), wf24(:,51), A(:,930), n3(:,1958), t3x72(:,:,930), nhel, den(60))
    call Hcont_VV(nsync, wf3(:,15), wf24(:,51), A(:,931), n3(:,1959), t3x72(:,:,931), nhel, den(60))
    call Hcont_VV(nsync, wf3(:,16), wf24(:,51), A(:,932), n3(:,1960), t3x72(:,:,932), nhel, den(60))
    call Hcont_VV(nsync, wf3(:,15), wf24(:,52), A(:,933), n3(:,1961), t3x72(:,:,933), nhel, den(29))
    call Hcont_VV(nsync, wf3(:,16), wf24(:,52), A(:,934), n3(:,1962), t3x72(:,:,934), nhel, den(29))
    call Hcont_VV(nsync, wf3(:,15), wf24(:,52), A(:,935), n3(:,1963), t3x72(:,:,935), nhel, den(29))
    call Hcont_VV(nsync, wf3(:,16), wf24(:,52), A(:,936), n3(:,1964), t3x72(:,:,936), nhel, den(29))
    call Hcont_QA(nsync, wf2(:,18), wf36(:,18), A(:,937), n3(:,1965), t3x72(:,:,937), nhel, den(39))
    call Hcont_QA(nsync, wf2(:,18), wf36(:,19), A(:,938), n3(:,1966), t3x72(:,:,938), nhel, den(30))
    call Hcont_QA(nsync, wf2(:,18), wf36(:,20), A(:,939), n3(:,1967), t3x72(:,:,939), nhel, den(29))
    call Hcont_QA(nsync, wf12(:,110), wf6(:,165), A(:,940), n3(:,1968), t3x72(:,:,940), nhel, den(18))
    call Hcont_QA(nsync, wf12(:,110), wf6(:,166), A(:,941), n3(:,1969), t3x72(:,:,941), nhel, den(18))
    call Hcont_QA(nsync, wf12(:,110), wf6(:,165), A(:,942), n3(:,1970), t3x72(:,:,942), nhel, den(18))
    call Hcont_QA(nsync, wf12(:,110), wf6(:,166), A(:,943), n3(:,1971), t3x72(:,:,943), nhel, den(18))
    call Hcont_QA(nsync, wf12(:,112), wf6(:,165), A(:,944), n3(:,1972), t3x72(:,:,944), nhel, den(20))
    call Hcont_QA(nsync, wf12(:,112), wf6(:,166), A(:,945), n3(:,1973), t3x72(:,:,945), nhel, den(20))
    call Hcont_QA(nsync, wf12(:,112), wf6(:,165), A(:,946), n3(:,1974), t3x72(:,:,946), nhel, den(20))
    call Hcont_QA(nsync, wf12(:,112), wf6(:,166), A(:,947), n3(:,1975), t3x72(:,:,947), nhel, den(20))
    call Hcont_VV(nsync, wf8(:,16), wf9(:,21), A(:,948), n3(:,1976), t3x72(:,:,948), nhel, den(59))
    call Hcont_VV(nsync, wf8(:,16), wf9(:,22), A(:,949), n3(:,1977), t3x72(:,:,949), nhel, den(59))
    call Hcont_VV(nsync, wf8(:,16), wf9(:,21), A(:,950), n3(:,1978), t3x72(:,:,950), nhel, den(59))
    call Hcont_VV(nsync, wf8(:,16), wf9(:,22), A(:,951), n3(:,1979), t3x72(:,:,951), nhel, den(59))
    call Hcont_QA(nsync, wf12(:,101), wf6(:,172), A(:,952), n3(:,1980), t3x72(:,:,952), nhel, den(23))
    call Hcont_QA(nsync, wf4(:,40), wf18(:,171), A(:,953), n3(:,1981), t3x72(:,:,953), nhel, den(25))
    call Hcont_QA(nsync, wf4(:,40), wf18(:,172), A(:,954), n3(:,1982), t3x72(:,:,954), nhel, den(66))
    call Hcont_QA(nsync, wf12(:,103), wf6(:,170), A(:,955), n3(:,1983), t3x72(:,:,955), nhel, den(14))
    call Hcont_QA(nsync, wf4(:,39), wf18(:,173), A(:,956), n3(:,1984), t3x72(:,:,956), nhel, den(16))
    call Hcont_QA(nsync, wf12(:,110), wf6(:,169), A(:,957), n3(:,1985), t3x72(:,:,957), nhel, den(18))
    call Hcont_QA(nsync, wf4(:,39), wf18(:,174), A(:,958), n3(:,1986), t3x72(:,:,958), nhel, den(19))
    call Hcont_QA(nsync, wf12(:,112), wf6(:,169), A(:,959), n3(:,1987), t3x72(:,:,959), nhel, den(20))
    call Hcont_QA(nsync, wf12(:,105), wf6(:,170), A(:,960), n3(:,1988), t3x72(:,:,960), nhel, den(21))
    call Hcont_QA(nsync, wf12(:,106), wf6(:,172), A(:,961), n3(:,1989), t3x72(:,:,961), nhel, den(23))
    call Hcont_QA(nsync, wf4(:,40), wf18(:,175), A(:,962), n3(:,1990), t3x72(:,:,962), nhel, den(25))
    call Hcont_QA(nsync, wf12(:,114), wf6(:,171), A(:,963), n3(:,1991), t3x72(:,:,963), nhel, den(27))
    call Hcont_QA(nsync, wf4(:,40), wf18(:,176), A(:,964), n3(:,1992), t3x72(:,:,964), nhel, den(28))
    call Hcont_QA(nsync, wf12(:,116), wf6(:,171), A(:,965), n3(:,1993), t3x72(:,:,965), nhel, den(29))
    call Hcont_QA(nsync, wf12(:,108), wf6(:,172), A(:,966), n3(:,1994), t3x72(:,:,966), nhel, den(30))
    call Hcont_QA(nsync, wf6(:,174), wf12(:,135), A(:,967), n3(:,1995), t3x72(:,:,967), nhel, den(10))
    call Hcont_QA(nsync, wf6(:,176), wf12(:,136), A(:,968), n3(:,1996), t3x72(:,:,968), nhel, den(12))
    call Hcont_VV(nsync, wf9(:,2), wf8(:,17), A(:,969), n3(:,1997), t3x72(:,:,969), nhel, den(53))
    call Hcont_VV(nsync, wf9(:,1), wf8(:,17), A(:,970), n3(:,1998), t3x72(:,:,970), nhel, den(53))
    call Hcont_VV(nsync, wf9(:,2), wf8(:,18), A(:,971), n3(:,1999), t3x72(:,:,971), nhel, den(55))
    call Hcont_VV(nsync, wf9(:,1), wf8(:,18), A(:,972), n3(:,2000), t3x72(:,:,972), nhel, den(55))
    call Hcont_QA(nsync, wf6(:,178), wf12(:,137), A(:,973), n3(:,2001), t3x72(:,:,973), nhel, den(5))
    call Hcont_QA(nsync, wf6(:,180), wf12(:,138), A(:,974), n3(:,2002), t3x72(:,:,974), nhel, den(11))
    call Hcont_VV(nsync, wf9(:,2), wf8(:,19), A(:,975), n3(:,2003), t3x72(:,:,975), nhel, den(56))
    call Hcont_VV(nsync, wf9(:,1), wf8(:,19), A(:,976), n3(:,2004), t3x72(:,:,976), nhel, den(56))
    call Hcont_VV(nsync, wf9(:,2), wf8(:,20), A(:,977), n3(:,2005), t3x72(:,:,977), nhel, den(57))
    call Hcont_VV(nsync, wf9(:,1), wf8(:,20), A(:,978), n3(:,2006), t3x72(:,:,978), nhel, den(57))
    call Hcont_QA(nsync, wf6(:,176), wf12(:,139), A(:,979), n3(:,2007), t3x72(:,:,979), nhel, den(3))
    call Hcont_QA(nsync, wf6(:,174), wf12(:,140), A(:,980), n3(:,2008), t3x72(:,:,980), nhel, den(8))
    call Hcont_QA(nsync, wf6(:,174), wf12(:,141), A(:,981), n3(:,2009), t3x72(:,:,981), nhel, den(10))
    call Hcont_QA(nsync, wf12(:,81), wf6(:,181), A(:,982), n3(:,2010), t3x72(:,:,982), nhel, den(21))
    call Hcont_VV(nsync, wf8(:,21), wf9(:,23), A(:,983), n3(:,2011), t3x72(:,:,983), nhel, den(32))
    call Hcont_VV(nsync, wf8(:,21), wf9(:,24), A(:,984), n3(:,2012), t3x72(:,:,984), nhel, den(32))
    call Hcont_VV(nsync, wf9(:,23), wf8(:,22), A(:,985), n3(:,2013), t3x72(:,:,985), nhel, den(34))
    call Hcont_VV(nsync, wf9(:,24), wf8(:,22), A(:,986), n3(:,2014), t3x72(:,:,986), nhel, den(34))
    call Hcont_QA(nsync, wf6(:,176), wf12(:,142), A(:,987), n3(:,2015), t3x72(:,:,987), nhel, den(12))
    call Hcont_QA(nsync, wf12(:,86), wf6(:,182), A(:,988), n3(:,2016), t3x72(:,:,988), nhel, den(20))
    call Hcont_VV(nsync, wf8(:,21), wf9(:,25), A(:,989), n3(:,2017), t3x72(:,:,989), nhel, den(32))
    call Hcont_VV(nsync, wf8(:,21), wf9(:,26), A(:,990), n3(:,2018), t3x72(:,:,990), nhel, den(32))
    call Hcont_VV(nsync, wf8(:,22), wf9(:,25), A(:,991), n3(:,2019), t3x72(:,:,991), nhel, den(34))
    call Hcont_VV(nsync, wf8(:,22), wf9(:,26), A(:,992), n3(:,2020), t3x72(:,:,992), nhel, den(34))
    call Hcont_QA(nsync, wf4(:,14), wf18(:,177), A(:,993), n3(:,2021), t3x72(:,:,993), nhel, den(5))
    call Hcont_QA(nsync, wf12(:,138), wf6(:,184), A(:,994), n3(:,2022), t3x72(:,:,994), nhel, den(11))
    call Hcont_VV(nsync, wf9(:,23), wf8(:,23), A(:,995), n3(:,2023), t3x72(:,:,995), nhel, den(35))
    call Hcont_VV(nsync, wf9(:,24), wf8(:,23), A(:,996), n3(:,2024), t3x72(:,:,996), nhel, den(35))
    call Hcont_VV(nsync, wf9(:,23), wf8(:,24), A(:,997), n3(:,2025), t3x72(:,:,997), nhel, den(36))
    call Hcont_VV(nsync, wf9(:,24), wf8(:,24), A(:,998), n3(:,2026), t3x72(:,:,998), nhel, den(36))
    call Hcont_QA(nsync, wf4(:,14), wf18(:,178), A(:,999), n3(:,2027), t3x72(:,:,999), nhel, den(11))
    call Hcont_QA(nsync, wf12(:,137), wf6(:,186), A(:,1000), n3(:,2028), t3x72(:,:,1000), nhel, den(5))
    call Hcont_VV(nsync, wf9(:,25), wf8(:,23), A(:,1001), n3(:,2029), t3x72(:,:,1001), nhel, den(35))
    call Hcont_VV(nsync, wf9(:,26), wf8(:,23), A(:,1002), n3(:,2030), t3x72(:,:,1002), nhel, den(35))
    call Hcont_VV(nsync, wf9(:,25), wf8(:,24), A(:,1003), n3(:,2031), t3x72(:,:,1003), nhel, den(36))
    call Hcont_VV(nsync, wf9(:,26), wf8(:,24), A(:,1004), n3(:,2032), t3x72(:,:,1004), nhel, den(36))
    call Hcont_QA(nsync, wf12(:,87), wf6(:,181), A(:,1005), n3(:,2033), t3x72(:,:,1005), nhel, den(14))
    call Hcont_QA(nsync, wf6(:,184), wf12(:,143), A(:,1006), n3(:,2034), t3x72(:,:,1006), nhel, den(8))
    call Hcont_QA(nsync, wf12(:,89), wf6(:,182), A(:,1007), n3(:,2035), t3x72(:,:,1007), nhel, den(18))
    call Hcont_QA(nsync, wf6(:,186), wf12(:,144), A(:,1008), n3(:,2036), t3x72(:,:,1008), nhel, den(3))
    call Hcont_QA(nsync, wf6(:,178), wf12(:,145), A(:,1009), n3(:,2037), t3x72(:,:,1009), nhel, den(5))
    call Hcont_QA(nsync, wf12(:,95), wf6(:,187), A(:,1010), n3(:,2038), t3x72(:,:,1010), nhel, den(30))
    call Hcont_VV(nsync, wf9(:,23), wf8(:,25), A(:,1011), n3(:,2039), t3x72(:,:,1011), nhel, den(35))
    call Hcont_VV(nsync, wf9(:,24), wf8(:,25), A(:,1012), n3(:,2040), t3x72(:,:,1012), nhel, den(35))
    call Hcont_VV(nsync, wf9(:,23), wf8(:,26), A(:,1013), n3(:,2041), t3x72(:,:,1013), nhel, den(36))
    call Hcont_VV(nsync, wf9(:,24), wf8(:,26), A(:,1014), n3(:,2042), t3x72(:,:,1014), nhel, den(36))
    call Hcont_QA(nsync, wf6(:,180), wf12(:,146), A(:,1015), n3(:,2043), t3x72(:,:,1015), nhel, den(11))
    call Hcont_QA(nsync, wf12(:,100), wf6(:,188), A(:,1016), n3(:,2044), t3x72(:,:,1016), nhel, den(29))
    call Hcont_VV(nsync, wf9(:,25), wf8(:,25), A(:,1017), n3(:,2045), t3x72(:,:,1017), nhel, den(35))
    call Hcont_VV(nsync, wf9(:,26), wf8(:,25), A(:,1018), n3(:,2046), t3x72(:,:,1018), nhel, den(35))
    call Hcont_VV(nsync, wf9(:,25), wf8(:,26), A(:,1019), n3(:,2047), t3x72(:,:,1019), nhel, den(36))
    call Hcont_VV(nsync, wf9(:,26), wf8(:,26), A(:,1020), n3(:,2048), t3x72(:,:,1020), nhel, den(36))
    call Hcont_QA(nsync, wf4(:,12), wf18(:,179), A(:,1021), n3(:,2049), t3x72(:,:,1021), nhel, den(10))
    call Hcont_QA(nsync, wf12(:,136), wf6(:,190), A(:,1022), n3(:,2050), t3x72(:,:,1022), nhel, den(12))
    call Hcont_VV(nsync, wf9(:,23), wf8(:,27), A(:,1023), n3(:,2051), t3x72(:,:,1023), nhel, den(32))
    call Hcont_VV(nsync, wf9(:,24), wf8(:,27), A(:,1024), n3(:,2052), t3x72(:,:,1024), nhel, den(32))
    call Hcont_VV(nsync, wf9(:,23), wf8(:,28), A(:,1025), n3(:,2053), t3x72(:,:,1025), nhel, den(34))
    call Hcont_VV(nsync, wf9(:,24), wf8(:,28), A(:,1026), n3(:,2054), t3x72(:,:,1026), nhel, den(34))
    call Hcont_QA(nsync, wf4(:,12), wf18(:,180), A(:,1027), n3(:,2055), t3x72(:,:,1027), nhel, den(12))
    call Hcont_QA(nsync, wf12(:,135), wf6(:,192), A(:,1028), n3(:,2056), t3x72(:,:,1028), nhel, den(10))
    call Hcont_VV(nsync, wf9(:,25), wf8(:,27), A(:,1029), n3(:,2057), t3x72(:,:,1029), nhel, den(32))
    call Hcont_VV(nsync, wf9(:,26), wf8(:,27), A(:,1030), n3(:,2058), t3x72(:,:,1030), nhel, den(32))
    call Hcont_VV(nsync, wf9(:,25), wf8(:,28), A(:,1031), n3(:,2059), t3x72(:,:,1031), nhel, den(34))
    call Hcont_VV(nsync, wf9(:,26), wf8(:,28), A(:,1032), n3(:,2060), t3x72(:,:,1032), nhel, den(34))
    call Hcont_QA(nsync, wf12(:,101), wf6(:,187), A(:,1033), n3(:,2061), t3x72(:,:,1033), nhel, den(23))
    call Hcont_QA(nsync, wf12(:,139), wf6(:,190), A(:,1034), n3(:,2062), t3x72(:,:,1034), nhel, den(3))
    call Hcont_QA(nsync, wf12(:,102), wf6(:,188), A(:,1035), n3(:,2063), t3x72(:,:,1035), nhel, den(27))
    call Hcont_QA(nsync, wf12(:,140), wf6(:,192), A(:,1036), n3(:,2064), t3x72(:,:,1036), nhel, den(8))
    call Hcont_QA(nsync, wf4(:,14), wf18(:,181), A(:,1037), n3(:,2065), t3x72(:,:,1037), nhel, den(5))
    call Hcont_QA(nsync, wf4(:,20), wf18(:,182), A(:,1038), n3(:,2066), t3x72(:,:,1038), nhel, den(5))
    call Hcont_QA(nsync, wf12(:,103), wf6(:,181), A(:,1039), n3(:,2067), t3x72(:,:,1039), nhel, den(14))
    call Hcont_QA(nsync, wf12(:,41), wf6(:,193), A(:,1040), n3(:,2068), t3x72(:,:,1040), nhel, den(14))
    call Hcont_QA(nsync, wf18(:,183), wf4(:,42), A(:,1041), n3(:,2069), t3x72(:,:,1041), nhel, den(5))
    call Hcont_QA(nsync, wf18(:,183), wf4(:,44), A(:,1042), n3(:,2070), t3x72(:,:,1042), nhel, den(5))
    call Hcont_QA(nsync, wf12(:,41), wf6(:,194), A(:,1043), n3(:,2071), t3x72(:,:,1043), nhel, den(14))
    call Hcont_QA(nsync, wf12(:,41), wf6(:,195), A(:,1044), n3(:,2072), t3x72(:,:,1044), nhel, den(14))
    call Hcont_QA(nsync, wf4(:,22), wf18(:,184), A(:,1045), n3(:,2073), t3x72(:,:,1045), nhel, den(10))
    call Hcont_QA(nsync, wf4(:,12), wf18(:,185), A(:,1046), n3(:,2074), t3x72(:,:,1046), nhel, den(10))
    call Hcont_VV(nsync, wf9(:,27), wf8(:,29), A(:,1047), n3(:,2075), t3x72(:,:,1047), nhel, den(38))
    call Hcont_VV(nsync, wf9(:,28), wf8(:,30), A(:,1048), n3(:,2076), t3x72(:,:,1048), nhel, den(38))
    call Hcont_QA(nsync, wf12(:,105), wf6(:,181), A(:,1049), n3(:,2077), t3x72(:,:,1049), nhel, den(21))
    call Hcont_QA(nsync, wf12(:,47), wf6(:,193), A(:,1050), n3(:,2078), t3x72(:,:,1050), nhel, den(21))
    call Hcont_QA(nsync, wf4(:,12), wf18(:,186), A(:,1051), n3(:,2079), t3x72(:,:,1051), nhel, den(38))
    call Hcont_QA(nsync, wf4(:,12), wf18(:,187), A(:,1052), n3(:,2080), t3x72(:,:,1052), nhel, den(38))
    call Hcont_QA(nsync, wf12(:,135), wf6(:,197), A(:,1053), n3(:,2081), t3x72(:,:,1053), nhel, den(10))
    call Hcont_QA(nsync, wf12(:,135), wf6(:,199), A(:,1054), n3(:,2082), t3x72(:,:,1054), nhel, den(10))
    call Hcont_QA(nsync, wf12(:,47), wf6(:,194), A(:,1055), n3(:,2083), t3x72(:,:,1055), nhel, den(21))
    call Hcont_QA(nsync, wf12(:,47), wf6(:,195), A(:,1056), n3(:,2084), t3x72(:,:,1056), nhel, den(21))
    call Hcont_QA(nsync, wf12(:,48), wf6(:,200), A(:,1057), n3(:,2085), t3x72(:,:,1057), nhel, den(23))
    call Hcont_QA(nsync, wf12(:,106), wf6(:,187), A(:,1058), n3(:,2086), t3x72(:,:,1058), nhel, den(23))
    call Hcont_VV(nsync, wf9(:,27), wf8(:,31), A(:,1059), n3(:,2087), t3x72(:,:,1059), nhel, den(39))
    call Hcont_VV(nsync, wf9(:,28), wf8(:,32), A(:,1060), n3(:,2088), t3x72(:,:,1060), nhel, den(39))
    call Hcont_QA(nsync, wf12(:,54), wf6(:,200), A(:,1061), n3(:,2089), t3x72(:,:,1061), nhel, den(30))
    call Hcont_QA(nsync, wf12(:,108), wf6(:,187), A(:,1062), n3(:,2090), t3x72(:,:,1062), nhel, den(30))
    call Hcont_QA(nsync, wf4(:,42), wf18(:,188), A(:,1063), n3(:,2091), t3x72(:,:,1063), nhel, den(39))
    call Hcont_QA(nsync, wf4(:,44), wf18(:,188), A(:,1064), n3(:,2092), t3x72(:,:,1064), nhel, den(39))
    call Hcont_QA(nsync, wf12(:,140), wf6(:,197), A(:,1065), n3(:,2093), t3x72(:,:,1065), nhel, den(8))
    call Hcont_QA(nsync, wf12(:,140), wf6(:,199), A(:,1066), n3(:,2094), t3x72(:,:,1066), nhel, den(8))
    call Hcont_QA(nsync, wf4(:,41), wf18(:,190), A(:,1067), n3(:,2095), t3x72(:,:,1067), nhel, den(19))
    call Hcont_QA(nsync, wf4(:,43), wf18(:,190), A(:,1068), n3(:,2096), t3x72(:,:,1068), nhel, den(19))
    call Hcont_QA(nsync, wf18(:,191), wf4(:,46), A(:,1069), n3(:,2097), t3x72(:,:,1069), nhel, den(10))
    call Hcont_QA(nsync, wf18(:,191), wf4(:,48), A(:,1070), n3(:,2098), t3x72(:,:,1070), nhel, den(10))
    call Hcont_QA(nsync, wf12(:,48), wf6(:,201), A(:,1071), n3(:,2099), t3x72(:,:,1071), nhel, den(23))
    call Hcont_QA(nsync, wf12(:,48), wf6(:,202), A(:,1072), n3(:,2100), t3x72(:,:,1072), nhel, den(23))
    call Hcont_QA(nsync, wf4(:,14), wf18(:,192), A(:,1073), n3(:,2101), t3x72(:,:,1073), nhel, den(39))
    call Hcont_QA(nsync, wf4(:,14), wf18(:,193), A(:,1074), n3(:,2102), t3x72(:,:,1074), nhel, den(39))
    call Hcont_QA(nsync, wf12(:,137), wf6(:,204), A(:,1075), n3(:,2103), t3x72(:,:,1075), nhel, den(5))
    call Hcont_QA(nsync, wf12(:,137), wf6(:,206), A(:,1076), n3(:,2104), t3x72(:,:,1076), nhel, den(5))
    call Hcont_QA(nsync, wf12(:,54), wf6(:,201), A(:,1077), n3(:,2105), t3x72(:,:,1077), nhel, den(30))
    call Hcont_QA(nsync, wf12(:,54), wf6(:,202), A(:,1078), n3(:,2106), t3x72(:,:,1078), nhel, den(30))
    call Hcont_QA(nsync, wf4(:,46), wf18(:,194), A(:,1079), n3(:,2107), t3x72(:,:,1079), nhel, den(38))
    call Hcont_QA(nsync, wf4(:,48), wf18(:,194), A(:,1080), n3(:,2108), t3x72(:,:,1080), nhel, den(38))
    call Hcont_QA(nsync, wf12(:,144), wf6(:,204), A(:,1081), n3(:,2109), t3x72(:,:,1081), nhel, den(3))
    call Hcont_QA(nsync, wf12(:,144), wf6(:,206), A(:,1082), n3(:,2110), t3x72(:,:,1082), nhel, den(3))
    call Hcont_QA(nsync, wf4(:,45), wf18(:,196), A(:,1083), n3(:,2111), t3x72(:,:,1083), nhel, den(28))
    call Hcont_QA(nsync, wf4(:,47), wf18(:,196), A(:,1084), n3(:,2112), t3x72(:,:,1084), nhel, den(28))
    call Hcont_QA(nsync, wf4(:,14), wf18(:,197), A(:,1085), n3(:,2113), t3x72(:,:,1085), nhel, den(11))
    call Hcont_QA(nsync, wf4(:,20), wf18(:,198), A(:,1086), n3(:,2114), t3x72(:,:,1086), nhel, den(11))
    call Hcont_QA(nsync, wf12(:,110), wf6(:,182), A(:,1087), n3(:,2115), t3x72(:,:,1087), nhel, den(18))
    call Hcont_QA(nsync, wf12(:,43), wf6(:,207), A(:,1088), n3(:,2116), t3x72(:,:,1088), nhel, den(18))
    call Hcont_QA(nsync, wf4(:,42), wf18(:,199), A(:,1089), n3(:,2117), t3x72(:,:,1089), nhel, den(11))
    call Hcont_QA(nsync, wf4(:,44), wf18(:,199), A(:,1090), n3(:,2118), t3x72(:,:,1090), nhel, den(11))
    call Hcont_QA(nsync, wf12(:,43), wf6(:,208), A(:,1091), n3(:,2119), t3x72(:,:,1091), nhel, den(18))
    call Hcont_QA(nsync, wf12(:,43), wf6(:,209), A(:,1092), n3(:,2120), t3x72(:,:,1092), nhel, den(18))
    call Hcont_QA(nsync, wf4(:,22), wf18(:,200), A(:,1093), n3(:,2121), t3x72(:,:,1093), nhel, den(12))
    call Hcont_QA(nsync, wf4(:,12), wf18(:,201), A(:,1094), n3(:,2122), t3x72(:,:,1094), nhel, den(12))
    call Hcont_VV(nsync, wf8(:,29), wf9(:,29), A(:,1095), n3(:,2123), t3x72(:,:,1095), nhel, den(38))
    call Hcont_VV(nsync, wf8(:,30), wf9(:,30), A(:,1096), n3(:,2124), t3x72(:,:,1096), nhel, den(38))
    call Hcont_QA(nsync, wf12(:,112), wf6(:,182), A(:,1097), n3(:,2125), t3x72(:,:,1097), nhel, den(20))
    call Hcont_QA(nsync, wf12(:,45), wf6(:,207), A(:,1098), n3(:,2126), t3x72(:,:,1098), nhel, den(20))
    call Hcont_QA(nsync, wf4(:,12), wf18(:,202), A(:,1099), n3(:,2127), t3x72(:,:,1099), nhel, den(38))
    call Hcont_QA(nsync, wf4(:,12), wf18(:,203), A(:,1100), n3(:,2128), t3x72(:,:,1100), nhel, den(38))
    call Hcont_QA(nsync, wf12(:,136), wf6(:,211), A(:,1101), n3(:,2129), t3x72(:,:,1101), nhel, den(12))
    call Hcont_QA(nsync, wf12(:,136), wf6(:,213), A(:,1102), n3(:,2130), t3x72(:,:,1102), nhel, den(12))
    call Hcont_QA(nsync, wf12(:,45), wf6(:,208), A(:,1103), n3(:,2131), t3x72(:,:,1103), nhel, den(20))
    call Hcont_QA(nsync, wf12(:,45), wf6(:,209), A(:,1104), n3(:,2132), t3x72(:,:,1104), nhel, den(20))
    call Hcont_QA(nsync, wf12(:,50), wf6(:,214), A(:,1105), n3(:,2133), t3x72(:,:,1105), nhel, den(27))
    call Hcont_QA(nsync, wf12(:,114), wf6(:,188), A(:,1106), n3(:,2134), t3x72(:,:,1106), nhel, den(27))
    call Hcont_VV(nsync, wf8(:,31), wf9(:,29), A(:,1107), n3(:,2135), t3x72(:,:,1107), nhel, den(39))
    call Hcont_VV(nsync, wf8(:,32), wf9(:,30), A(:,1108), n3(:,2136), t3x72(:,:,1108), nhel, den(39))
    call Hcont_QA(nsync, wf12(:,52), wf6(:,214), A(:,1109), n3(:,2137), t3x72(:,:,1109), nhel, den(29))
    call Hcont_QA(nsync, wf12(:,116), wf6(:,188), A(:,1110), n3(:,2138), t3x72(:,:,1110), nhel, den(29))
    call Hcont_QA(nsync, wf4(:,42), wf18(:,204), A(:,1111), n3(:,2139), t3x72(:,:,1111), nhel, den(39))
    call Hcont_QA(nsync, wf4(:,44), wf18(:,204), A(:,1112), n3(:,2140), t3x72(:,:,1112), nhel, den(39))
    call Hcont_QA(nsync, wf12(:,139), wf6(:,211), A(:,1113), n3(:,2141), t3x72(:,:,1113), nhel, den(3))
    call Hcont_QA(nsync, wf12(:,139), wf6(:,213), A(:,1114), n3(:,2142), t3x72(:,:,1114), nhel, den(3))
    call Hcont_QA(nsync, wf4(:,41), wf18(:,206), A(:,1115), n3(:,2143), t3x72(:,:,1115), nhel, den(16))
    call Hcont_QA(nsync, wf4(:,43), wf18(:,206), A(:,1116), n3(:,2144), t3x72(:,:,1116), nhel, den(16))
    call Hcont_QA(nsync, wf4(:,46), wf18(:,207), A(:,1117), n3(:,2145), t3x72(:,:,1117), nhel, den(12))
    call Hcont_QA(nsync, wf4(:,48), wf18(:,207), A(:,1118), n3(:,2146), t3x72(:,:,1118), nhel, den(12))
    call Hcont_QA(nsync, wf12(:,50), wf6(:,215), A(:,1119), n3(:,2147), t3x72(:,:,1119), nhel, den(27))
    call Hcont_QA(nsync, wf12(:,50), wf6(:,216), A(:,1120), n3(:,2148), t3x72(:,:,1120), nhel, den(27))
    call Hcont_QA(nsync, wf4(:,14), wf18(:,208), A(:,1121), n3(:,2149), t3x72(:,:,1121), nhel, den(39))
    call Hcont_QA(nsync, wf4(:,14), wf18(:,209), A(:,1122), n3(:,2150), t3x72(:,:,1122), nhel, den(39))
    call Hcont_QA(nsync, wf12(:,138), wf6(:,218), A(:,1123), n3(:,2151), t3x72(:,:,1123), nhel, den(11))
    call Hcont_QA(nsync, wf12(:,138), wf6(:,220), A(:,1124), n3(:,2152), t3x72(:,:,1124), nhel, den(11))
    call Hcont_QA(nsync, wf12(:,52), wf6(:,215), A(:,1125), n3(:,2153), t3x72(:,:,1125), nhel, den(29))
    call Hcont_QA(nsync, wf12(:,52), wf6(:,216), A(:,1126), n3(:,2154), t3x72(:,:,1126), nhel, den(29))
    call Hcont_QA(nsync, wf4(:,46), wf18(:,210), A(:,1127), n3(:,2155), t3x72(:,:,1127), nhel, den(38))
    call Hcont_QA(nsync, wf4(:,48), wf18(:,210), A(:,1128), n3(:,2156), t3x72(:,:,1128), nhel, den(38))
    call Hcont_QA(nsync, wf12(:,143), wf6(:,218), A(:,1129), n3(:,2157), t3x72(:,:,1129), nhel, den(8))
    call Hcont_QA(nsync, wf12(:,143), wf6(:,220), A(:,1130), n3(:,2158), t3x72(:,:,1130), nhel, den(8))
    call Hcont_QA(nsync, wf4(:,45), wf18(:,212), A(:,1131), n3(:,2159), t3x72(:,:,1131), nhel, den(25))
    call Hcont_QA(nsync, wf4(:,47), wf18(:,212), A(:,1132), n3(:,2160), t3x72(:,:,1132), nhel, den(25))
    call Hcont_QA(nsync, wf12(:,141), wf6(:,192), A(:,1133), n3(:,2161), t3x72(:,:,1133), nhel, den(10))
    call Hcont_QA(nsync, wf12(:,142), wf6(:,190), A(:,1134), n3(:,2162), t3x72(:,:,1134), nhel, den(12))
    call Hcont_VV(nsync, wf8(:,1), wf9(:,31), A(:,1135), n3(:,2163), t3x72(:,:,1135), nhel, den(32))
    call Hcont_VV(nsync, wf8(:,1), wf9(:,32), A(:,1136), n3(:,2164), t3x72(:,:,1136), nhel, den(32))
    call Hcont_VV(nsync, wf8(:,2), wf9(:,31), A(:,1137), n3(:,2165), t3x72(:,:,1137), nhel, den(34))
    call Hcont_VV(nsync, wf8(:,2), wf9(:,32), A(:,1138), n3(:,2166), t3x72(:,:,1138), nhel, den(34))
    call Hcont_QA(nsync, wf6(:,186), wf12(:,145), A(:,1139), n3(:,2167), t3x72(:,:,1139), nhel, den(5))
    call Hcont_QA(nsync, wf6(:,184), wf12(:,146), A(:,1140), n3(:,2168), t3x72(:,:,1140), nhel, den(11))
    call Hcont_VV(nsync, wf8(:,3), wf9(:,31), A(:,1141), n3(:,2169), t3x72(:,:,1141), nhel, den(35))
    call Hcont_VV(nsync, wf8(:,3), wf9(:,32), A(:,1142), n3(:,2170), t3x72(:,:,1142), nhel, den(35))
    call Hcont_VV(nsync, wf8(:,4), wf9(:,31), A(:,1143), n3(:,2171), t3x72(:,:,1143), nhel, den(36))
    call Hcont_VV(nsync, wf8(:,4), wf9(:,32), A(:,1144), n3(:,2172), t3x72(:,:,1144), nhel, den(36))
    call Hcont_QA(nsync, wf6(:,190), wf12(:,147), A(:,1145), n3(:,2173), t3x72(:,:,1145), nhel, den(3))
    call Hcont_QA(nsync, wf6(:,192), wf12(:,148), A(:,1146), n3(:,2174), t3x72(:,:,1146), nhel, den(8))
    call Hcont_QA(nsync, wf4(:,42), wf18(:,213), A(:,1147), n3(:,2175), t3x72(:,:,1147), nhel, den(5))
    call Hcont_QA(nsync, wf4(:,44), wf18(:,213), A(:,1148), n3(:,2176), t3x72(:,:,1148), nhel, den(5))
    call Hcont_QA(nsync, wf12(:,5), wf6(:,221), A(:,1149), n3(:,2177), t3x72(:,:,1149), nhel, den(14))
    call Hcont_QA(nsync, wf12(:,5), wf6(:,222), A(:,1150), n3(:,2178), t3x72(:,:,1150), nhel, den(14))
    call Hcont_QA(nsync, wf12(:,141), wf6(:,197), A(:,1151), n3(:,2179), t3x72(:,:,1151), nhel, den(10))
    call Hcont_QA(nsync, wf12(:,141), wf6(:,199), A(:,1152), n3(:,2180), t3x72(:,:,1152), nhel, den(10))
    call Hcont_VV(nsync, wf9(:,28), wf8(:,33), A(:,1153), n3(:,2181), t3x72(:,:,1153), nhel, den(38))
    call Hcont_VV(nsync, wf9(:,28), wf8(:,34), A(:,1154), n3(:,2182), t3x72(:,:,1154), nhel, den(38))
    call Hcont_QA(nsync, wf12(:,8), wf6(:,221), A(:,1155), n3(:,2183), t3x72(:,:,1155), nhel, den(21))
    call Hcont_QA(nsync, wf12(:,8), wf6(:,222), A(:,1156), n3(:,2184), t3x72(:,:,1156), nhel, den(21))
    call Hcont_QA(nsync, wf6(:,197), wf12(:,148), A(:,1157), n3(:,2185), t3x72(:,:,1157), nhel, den(8))
    call Hcont_QA(nsync, wf6(:,199), wf12(:,148), A(:,1158), n3(:,2186), t3x72(:,:,1158), nhel, den(8))
    call Hcont_QA(nsync, wf4(:,42), wf18(:,214), A(:,1159), n3(:,2187), t3x72(:,:,1159), nhel, den(11))
    call Hcont_QA(nsync, wf4(:,44), wf18(:,214), A(:,1160), n3(:,2188), t3x72(:,:,1160), nhel, den(11))
    call Hcont_QA(nsync, wf4(:,42), wf18(:,215), A(:,1161), n3(:,2189), t3x72(:,:,1161), nhel, den(39))
    call Hcont_QA(nsync, wf4(:,44), wf18(:,215), A(:,1162), n3(:,2190), t3x72(:,:,1162), nhel, den(39))
    call Hcont_QA(nsync, wf4(:,42), wf18(:,216), A(:,1163), n3(:,2191), t3x72(:,:,1163), nhel, den(11))
    call Hcont_QA(nsync, wf4(:,44), wf18(:,216), A(:,1164), n3(:,2192), t3x72(:,:,1164), nhel, den(11))
    call Hcont_QA(nsync, wf12(:,6), wf6(:,223), A(:,1165), n3(:,2193), t3x72(:,:,1165), nhel, den(18))
    call Hcont_QA(nsync, wf12(:,6), wf6(:,224), A(:,1166), n3(:,2194), t3x72(:,:,1166), nhel, den(18))
    call Hcont_QA(nsync, wf12(:,142), wf6(:,211), A(:,1167), n3(:,2195), t3x72(:,:,1167), nhel, den(12))
    call Hcont_QA(nsync, wf12(:,142), wf6(:,213), A(:,1168), n3(:,2196), t3x72(:,:,1168), nhel, den(12))
    call Hcont_VV(nsync, wf9(:,30), wf8(:,33), A(:,1169), n3(:,2197), t3x72(:,:,1169), nhel, den(38))
    call Hcont_VV(nsync, wf9(:,30), wf8(:,34), A(:,1170), n3(:,2198), t3x72(:,:,1170), nhel, den(38))
    call Hcont_QA(nsync, wf12(:,7), wf6(:,223), A(:,1171), n3(:,2199), t3x72(:,:,1171), nhel, den(20))
    call Hcont_QA(nsync, wf12(:,7), wf6(:,224), A(:,1172), n3(:,2200), t3x72(:,:,1172), nhel, den(20))
    call Hcont_QA(nsync, wf6(:,211), wf12(:,147), A(:,1173), n3(:,2201), t3x72(:,:,1173), nhel, den(3))
    call Hcont_QA(nsync, wf6(:,213), wf12(:,147), A(:,1174), n3(:,2202), t3x72(:,:,1174), nhel, den(3))
    call Hcont_QA(nsync, wf4(:,42), wf18(:,217), A(:,1175), n3(:,2203), t3x72(:,:,1175), nhel, den(5))
    call Hcont_QA(nsync, wf4(:,44), wf18(:,217), A(:,1176), n3(:,2204), t3x72(:,:,1176), nhel, den(5))
    call Hcont_QA(nsync, wf4(:,42), wf18(:,218), A(:,1177), n3(:,2205), t3x72(:,:,1177), nhel, den(39))
    call Hcont_QA(nsync, wf4(:,44), wf18(:,218), A(:,1178), n3(:,2206), t3x72(:,:,1178), nhel, den(39))
    call Hcont_QA(nsync, wf4(:,46), wf18(:,219), A(:,1179), n3(:,2207), t3x72(:,:,1179), nhel, den(10))
    call Hcont_QA(nsync, wf4(:,48), wf18(:,219), A(:,1180), n3(:,2208), t3x72(:,:,1180), nhel, den(10))
    call Hcont_QA(nsync, wf12(:,10), wf6(:,225), A(:,1181), n3(:,2209), t3x72(:,:,1181), nhel, den(23))
    call Hcont_QA(nsync, wf12(:,10), wf6(:,226), A(:,1182), n3(:,2210), t3x72(:,:,1182), nhel, den(23))
    call Hcont_QA(nsync, wf12(:,145), wf6(:,204), A(:,1183), n3(:,2211), t3x72(:,:,1183), nhel, den(5))
    call Hcont_QA(nsync, wf12(:,145), wf6(:,206), A(:,1184), n3(:,2212), t3x72(:,:,1184), nhel, den(5))
    call Hcont_VV(nsync, wf9(:,27), wf8(:,35), A(:,1185), n3(:,2213), t3x72(:,:,1185), nhel, den(39))
    call Hcont_VV(nsync, wf9(:,27), wf8(:,36), A(:,1186), n3(:,2214), t3x72(:,:,1186), nhel, den(39))
    call Hcont_QA(nsync, wf12(:,16), wf6(:,225), A(:,1187), n3(:,2215), t3x72(:,:,1187), nhel, den(30))
    call Hcont_QA(nsync, wf12(:,16), wf6(:,226), A(:,1188), n3(:,2216), t3x72(:,:,1188), nhel, den(30))
    call Hcont_QA(nsync, wf6(:,204), wf12(:,149), A(:,1189), n3(:,2217), t3x72(:,:,1189), nhel, den(3))
    call Hcont_QA(nsync, wf6(:,206), wf12(:,149), A(:,1190), n3(:,2218), t3x72(:,:,1190), nhel, den(3))
    call Hcont_QA(nsync, wf4(:,46), wf18(:,220), A(:,1191), n3(:,2219), t3x72(:,:,1191), nhel, den(12))
    call Hcont_QA(nsync, wf4(:,48), wf18(:,220), A(:,1192), n3(:,2220), t3x72(:,:,1192), nhel, den(12))
    call Hcont_QA(nsync, wf4(:,46), wf18(:,221), A(:,1193), n3(:,2221), t3x72(:,:,1193), nhel, den(38))
    call Hcont_QA(nsync, wf4(:,48), wf18(:,221), A(:,1194), n3(:,2222), t3x72(:,:,1194), nhel, den(38))
    call Hcont_QA(nsync, wf4(:,46), wf18(:,222), A(:,1195), n3(:,2223), t3x72(:,:,1195), nhel, den(12))
    call Hcont_QA(nsync, wf4(:,48), wf18(:,222), A(:,1196), n3(:,2224), t3x72(:,:,1196), nhel, den(12))
    call Hcont_QA(nsync, wf12(:,12), wf6(:,227), A(:,1197), n3(:,2225), t3x72(:,:,1197), nhel, den(27))
    call Hcont_QA(nsync, wf12(:,12), wf6(:,228), A(:,1198), n3(:,2226), t3x72(:,:,1198), nhel, den(27))
    call Hcont_QA(nsync, wf12(:,146), wf6(:,218), A(:,1199), n3(:,2227), t3x72(:,:,1199), nhel, den(11))
    call Hcont_QA(nsync, wf12(:,146), wf6(:,220), A(:,1200), n3(:,2228), t3x72(:,:,1200), nhel, den(11))
    call Hcont_VV(nsync, wf9(:,29), wf8(:,35), A(:,1201), n3(:,2229), t3x72(:,:,1201), nhel, den(39))
    call Hcont_VV(nsync, wf9(:,29), wf8(:,36), A(:,1202), n3(:,2230), t3x72(:,:,1202), nhel, den(39))
    call Hcont_QA(nsync, wf12(:,14), wf6(:,227), A(:,1203), n3(:,2231), t3x72(:,:,1203), nhel, den(29))
    call Hcont_QA(nsync, wf12(:,14), wf6(:,228), A(:,1204), n3(:,2232), t3x72(:,:,1204), nhel, den(29))
    call Hcont_QA(nsync, wf6(:,218), wf12(:,150), A(:,1205), n3(:,2233), t3x72(:,:,1205), nhel, den(8))
    call Hcont_QA(nsync, wf6(:,220), wf12(:,150), A(:,1206), n3(:,2234), t3x72(:,:,1206), nhel, den(8))
    call Hcont_QA(nsync, wf4(:,46), wf18(:,223), A(:,1207), n3(:,2235), t3x72(:,:,1207), nhel, den(10))
    call Hcont_QA(nsync, wf4(:,48), wf18(:,223), A(:,1208), n3(:,2236), t3x72(:,:,1208), nhel, den(10))
    call Hcont_QA(nsync, wf4(:,46), wf18(:,224), A(:,1209), n3(:,2237), t3x72(:,:,1209), nhel, den(38))
    call Hcont_QA(nsync, wf4(:,48), wf18(:,224), A(:,1210), n3(:,2238), t3x72(:,:,1210), nhel, den(38))
    call Hcont_QA(nsync, wf6(:,211), wf12(:,151), A(:,1211), n3(:,2239), t3x72(:,:,1211), nhel, den(3))
    call Hcont_QA(nsync, wf6(:,213), wf12(:,151), A(:,1212), n3(:,2240), t3x72(:,:,1212), nhel, den(3))
    call Hcont_QA(nsync, wf6(:,211), wf12(:,152), A(:,1213), n3(:,2241), t3x72(:,:,1213), nhel, den(3))
    call Hcont_QA(nsync, wf6(:,213), wf12(:,152), A(:,1214), n3(:,2242), t3x72(:,:,1214), nhel, den(3))
    call Hcont_QA(nsync, wf4(:,42), wf18(:,225), A(:,1215), n3(:,2243), t3x72(:,:,1215), nhel, den(5))
    call Hcont_QA(nsync, wf4(:,44), wf18(:,225), A(:,1216), n3(:,2244), t3x72(:,:,1216), nhel, den(5))
    call Hcont_QA(nsync, wf4(:,42), wf18(:,226), A(:,1217), n3(:,2245), t3x72(:,:,1217), nhel, den(5))
    call Hcont_QA(nsync, wf4(:,44), wf18(:,226), A(:,1218), n3(:,2246), t3x72(:,:,1218), nhel, den(5))
    call Hcont_QA(nsync, wf6(:,218), wf12(:,153), A(:,1219), n3(:,2247), t3x72(:,:,1219), nhel, den(8))
    call Hcont_QA(nsync, wf6(:,218), wf12(:,154), A(:,1220), n3(:,2248), t3x72(:,:,1220), nhel, den(8))
    call Hcont_QA(nsync, wf6(:,220), wf12(:,153), A(:,1221), n3(:,2249), t3x72(:,:,1221), nhel, den(8))
    call Hcont_QA(nsync, wf6(:,220), wf12(:,154), A(:,1222), n3(:,2250), t3x72(:,:,1222), nhel, den(8))
    call Hcont_QA(nsync, wf4(:,42), wf18(:,227), A(:,1223), n3(:,2251), t3x72(:,:,1223), nhel, den(11))
    call Hcont_QA(nsync, wf4(:,44), wf18(:,227), A(:,1224), n3(:,2252), t3x72(:,:,1224), nhel, den(11))
    call Hcont_QA(nsync, wf4(:,42), wf18(:,228), A(:,1225), n3(:,2253), t3x72(:,:,1225), nhel, den(11))
    call Hcont_QA(nsync, wf4(:,44), wf18(:,228), A(:,1226), n3(:,2254), t3x72(:,:,1226), nhel, den(11))
    call Hcont_QA(nsync, wf4(:,46), wf18(:,229), A(:,1227), n3(:,2255), t3x72(:,:,1227), nhel, den(10))
    call Hcont_QA(nsync, wf4(:,46), wf18(:,230), A(:,1228), n3(:,2256), t3x72(:,:,1228), nhel, den(10))
    call Hcont_QA(nsync, wf4(:,48), wf18(:,229), A(:,1229), n3(:,2257), t3x72(:,:,1229), nhel, den(10))
    call Hcont_QA(nsync, wf4(:,48), wf18(:,230), A(:,1230), n3(:,2258), t3x72(:,:,1230), nhel, den(10))
    call Hcont_QA(nsync, wf4(:,46), wf18(:,231), A(:,1231), n3(:,2259), t3x72(:,:,1231), nhel, den(12))
    call Hcont_QA(nsync, wf4(:,46), wf18(:,232), A(:,1232), n3(:,2260), t3x72(:,:,1232), nhel, den(12))
    call Hcont_QA(nsync, wf4(:,48), wf18(:,231), A(:,1233), n3(:,2261), t3x72(:,:,1233), nhel, den(12))
    call Hcont_QA(nsync, wf4(:,48), wf18(:,232), A(:,1234), n3(:,2262), t3x72(:,:,1234), nhel, den(12))
    call Hcont_VV(nsync, wf24(:,9), wf3(:,21), A(:,1235), n3(:,2263), t3x72(:,:,1235), nhel, den(10))
    call Hcont_VV(nsync, wf24(:,10), wf3(:,22), A(:,1236), n3(:,2264), t3x72(:,:,1236), nhel, den(21))
    call Hcont_VV(nsync, wf24(:,11), wf3(:,21), A(:,1237), n3(:,2265), t3x72(:,:,1237), nhel, den(32))
    call Hcont_VV(nsync, wf24(:,12), wf3(:,22), A(:,1238), n3(:,2266), t3x72(:,:,1238), nhel, den(32))
    call Hcont_VV(nsync, wf24(:,13), wf3(:,21), A(:,1239), n3(:,2267), t3x72(:,:,1239), nhel, den(34))
    call Hcont_VV(nsync, wf24(:,14), wf3(:,22), A(:,1240), n3(:,2268), t3x72(:,:,1240), nhel, den(34))
    call Hcont_VV(nsync, wf24(:,15), wf3(:,23), A(:,1241), n3(:,2269), t3x72(:,:,1241), nhel, den(12))
    call Hcont_VV(nsync, wf24(:,16), wf3(:,24), A(:,1242), n3(:,2270), t3x72(:,:,1242), nhel, den(20))
    call Hcont_VV(nsync, wf24(:,17), wf3(:,23), A(:,1243), n3(:,2271), t3x72(:,:,1243), nhel, den(32))
    call Hcont_VV(nsync, wf24(:,18), wf3(:,24), A(:,1244), n3(:,2272), t3x72(:,:,1244), nhel, den(32))
    call Hcont_VV(nsync, wf24(:,19), wf3(:,23), A(:,1245), n3(:,2273), t3x72(:,:,1245), nhel, den(34))
    call Hcont_VV(nsync, wf24(:,20), wf3(:,24), A(:,1246), n3(:,2274), t3x72(:,:,1246), nhel, den(34))
    call Hcont_VV(nsync, wf24(:,21), wf3(:,22), A(:,1247), n3(:,2275), t3x72(:,:,1247), nhel, den(5))
    call Hcont_VV(nsync, wf24(:,22), wf3(:,21), A(:,1248), n3(:,2276), t3x72(:,:,1248), nhel, den(30))
    call Hcont_VV(nsync, wf24(:,23), wf3(:,21), A(:,1249), n3(:,2277), t3x72(:,:,1249), nhel, den(35))
    call Hcont_VV(nsync, wf24(:,24), wf3(:,22), A(:,1250), n3(:,2278), t3x72(:,:,1250), nhel, den(35))
    call Hcont_VV(nsync, wf24(:,25), wf3(:,21), A(:,1251), n3(:,2279), t3x72(:,:,1251), nhel, den(36))
    call Hcont_VV(nsync, wf24(:,26), wf3(:,22), A(:,1252), n3(:,2280), t3x72(:,:,1252), nhel, den(36))
    call Hcont_VV(nsync, wf24(:,27), wf3(:,24), A(:,1253), n3(:,2281), t3x72(:,:,1253), nhel, den(11))
    call Hcont_VV(nsync, wf24(:,28), wf3(:,23), A(:,1254), n3(:,2282), t3x72(:,:,1254), nhel, den(29))
    call Hcont_VV(nsync, wf24(:,29), wf3(:,23), A(:,1255), n3(:,2283), t3x72(:,:,1255), nhel, den(35))
    call Hcont_VV(nsync, wf24(:,30), wf3(:,24), A(:,1256), n3(:,2284), t3x72(:,:,1256), nhel, den(35))
    call Hcont_VV(nsync, wf24(:,31), wf3(:,23), A(:,1257), n3(:,2285), t3x72(:,:,1257), nhel, den(36))
    call Hcont_VV(nsync, wf24(:,32), wf3(:,24), A(:,1258), n3(:,2286), t3x72(:,:,1258), nhel, den(36))
    call Hcont_QA(nsync, wf12(:,87), wf6(:,229), A(:,1259), n3(:,2287), t3x72(:,:,1259), nhel, den(14))
    call Hcont_QA(nsync, wf12(:,101), wf6(:,230), A(:,1260), n3(:,2288), t3x72(:,:,1260), nhel, den(23))
    call Hcont_QA(nsync, wf12(:,89), wf6(:,231), A(:,1261), n3(:,2289), t3x72(:,:,1261), nhel, den(18))
    call Hcont_QA(nsync, wf12(:,102), wf6(:,232), A(:,1262), n3(:,2290), t3x72(:,:,1262), nhel, den(27))
    call Hcont_VV(nsync, wf24(:,33), wf3(:,21), A(:,1263), n3(:,2291), t3x72(:,:,1263), nhel, den(5))
    call Hcont_VV(nsync, wf24(:,53), wf3(:,25), A(:,1264), n3(:,2292), t3x72(:,:,1264), nhel, den(5))
    call Hcont_VV(nsync, wf24(:,53), wf3(:,26), A(:,1265), n3(:,2293), t3x72(:,:,1265), nhel, den(5))
    call Hcont_VV(nsync, wf3(:,25), wf24(:,54), A(:,1266), n3(:,2294), t3x72(:,:,1266), nhel, den(5))
    call Hcont_VV(nsync, wf3(:,26), wf24(:,54), A(:,1267), n3(:,2295), t3x72(:,:,1267), nhel, den(5))
    call Hcont_VV(nsync, wf24(:,34), wf3(:,21), A(:,1268), n3(:,2296), t3x72(:,:,1268), nhel, den(14))
    call Hcont_VV(nsync, wf3(:,25), wf24(:,55), A(:,1269), n3(:,2297), t3x72(:,:,1269), nhel, den(14))
    call Hcont_VV(nsync, wf3(:,26), wf24(:,55), A(:,1270), n3(:,2298), t3x72(:,:,1270), nhel, den(14))
    call Hcont_VV(nsync, wf3(:,25), wf24(:,56), A(:,1271), n3(:,2299), t3x72(:,:,1271), nhel, den(14))
    call Hcont_VV(nsync, wf3(:,26), wf24(:,56), A(:,1272), n3(:,2300), t3x72(:,:,1272), nhel, den(14))
    call Hcont_QA(nsync, wf36(:,1), wf2(:,23), A(:,1273), n3(:,2301), t3x72(:,:,1273), nhel, den(16))
    call Hcont_QA(nsync, wf36(:,1), wf2(:,24), A(:,1274), n3(:,2302), t3x72(:,:,1274), nhel, den(16))
    call Hcont_QA(nsync, wf36(:,2), wf2(:,23), A(:,1275), n3(:,2303), t3x72(:,:,1275), nhel, den(14))
    call Hcont_QA(nsync, wf36(:,2), wf2(:,24), A(:,1276), n3(:,2304), t3x72(:,:,1276), nhel, den(14))
    call Hcont_VV(nsync, wf24(:,35), wf3(:,21), A(:,1277), n3(:,2305), t3x72(:,:,1277), nhel, den(10))
    call Hcont_VV(nsync, wf3(:,25), wf24(:,57), A(:,1278), n3(:,2306), t3x72(:,:,1278), nhel, den(10))
    call Hcont_VV(nsync, wf3(:,26), wf24(:,57), A(:,1279), n3(:,2307), t3x72(:,:,1279), nhel, den(10))
    call Hcont_VV(nsync, wf3(:,25), wf24(:,58), A(:,1280), n3(:,2308), t3x72(:,:,1280), nhel, den(10))
    call Hcont_VV(nsync, wf3(:,26), wf24(:,58), A(:,1281), n3(:,2309), t3x72(:,:,1281), nhel, den(10))
    call Hcont_VV(nsync, wf24(:,36), wf3(:,21), A(:,1282), n3(:,2310), t3x72(:,:,1282), nhel, den(59))
    call Hcont_VV(nsync, wf24(:,37), wf3(:,21), A(:,1283), n3(:,2311), t3x72(:,:,1283), nhel, den(21))
    call Hcont_VV(nsync, wf3(:,25), wf24(:,59), A(:,1284), n3(:,2312), t3x72(:,:,1284), nhel, den(21))
    call Hcont_VV(nsync, wf3(:,26), wf24(:,59), A(:,1285), n3(:,2313), t3x72(:,:,1285), nhel, den(21))
    call Hcont_VV(nsync, wf3(:,25), wf24(:,60), A(:,1286), n3(:,2314), t3x72(:,:,1286), nhel, den(21))
    call Hcont_VV(nsync, wf3(:,26), wf24(:,60), A(:,1287), n3(:,2315), t3x72(:,:,1287), nhel, den(21))
    call Hcont_QA(nsync, wf36(:,3), wf2(:,23), A(:,1288), n3(:,2316), t3x72(:,:,1288), nhel, den(38))
    call Hcont_QA(nsync, wf36(:,3), wf2(:,24), A(:,1289), n3(:,2317), t3x72(:,:,1289), nhel, den(38))
    call Hcont_QA(nsync, wf36(:,4), wf2(:,23), A(:,1290), n3(:,2318), t3x72(:,:,1290), nhel, den(20))
    call Hcont_QA(nsync, wf36(:,4), wf2(:,24), A(:,1291), n3(:,2319), t3x72(:,:,1291), nhel, den(20))
    call Hcont_QA(nsync, wf36(:,5), wf2(:,23), A(:,1292), n3(:,2320), t3x72(:,:,1292), nhel, den(21))
    call Hcont_QA(nsync, wf36(:,5), wf2(:,24), A(:,1293), n3(:,2321), t3x72(:,:,1293), nhel, den(21))
    call Hcont_QA(nsync, wf12(:,106), wf6(:,230), A(:,1294), n3(:,2322), t3x72(:,:,1294), nhel, den(23))
    call Hcont_QA(nsync, wf12(:,48), wf6(:,233), A(:,1295), n3(:,2323), t3x72(:,:,1295), nhel, den(23))
    call Hcont_QA(nsync, wf12(:,48), wf6(:,234), A(:,1296), n3(:,2324), t3x72(:,:,1296), nhel, den(23))
    call Hcont_QA(nsync, wf12(:,48), wf6(:,235), A(:,1297), n3(:,2325), t3x72(:,:,1297), nhel, den(23))
    call Hcont_QA(nsync, wf12(:,48), wf6(:,236), A(:,1298), n3(:,2326), t3x72(:,:,1298), nhel, den(23))
    call Hcont_QA(nsync, wf12(:,108), wf6(:,230), A(:,1299), n3(:,2327), t3x72(:,:,1299), nhel, den(30))
    call Hcont_QA(nsync, wf12(:,54), wf6(:,233), A(:,1300), n3(:,2328), t3x72(:,:,1300), nhel, den(30))
    call Hcont_QA(nsync, wf12(:,54), wf6(:,234), A(:,1301), n3(:,2329), t3x72(:,:,1301), nhel, den(30))
    call Hcont_QA(nsync, wf12(:,54), wf6(:,235), A(:,1302), n3(:,2330), t3x72(:,:,1302), nhel, den(30))
    call Hcont_QA(nsync, wf12(:,54), wf6(:,236), A(:,1303), n3(:,2331), t3x72(:,:,1303), nhel, den(30))
    call Hcont_VV(nsync, wf8(:,13), wf9(:,33), A(:,1304), n3(:,2332), t3x72(:,:,1304), nhel, den(60))
    call Hcont_QA(nsync, wf12(:,89), wf6(:,237), A(:,1305), n3(:,2333), t3x72(:,:,1305), nhel, den(18))
    call Hcont_QA(nsync, wf12(:,89), wf6(:,238), A(:,1306), n3(:,2334), t3x72(:,:,1306), nhel, den(18))
    call Hcont_QA(nsync, wf18(:,162), wf4(:,49), A(:,1307), n3(:,2335), t3x72(:,:,1307), nhel, den(19))
    call Hcont_QA(nsync, wf18(:,162), wf4(:,50), A(:,1308), n3(:,2336), t3x72(:,:,1308), nhel, den(19))
    call Hcont_QA(nsync, wf18(:,163), wf4(:,49), A(:,1309), n3(:,2337), t3x72(:,:,1309), nhel, den(65))
    call Hcont_QA(nsync, wf18(:,163), wf4(:,50), A(:,1310), n3(:,2338), t3x72(:,:,1310), nhel, den(65))
    call Hcont_VV(nsync, wf24(:,38), wf3(:,23), A(:,1311), n3(:,2339), t3x72(:,:,1311), nhel, den(11))
    call Hcont_VV(nsync, wf24(:,61), wf3(:,27), A(:,1312), n3(:,2340), t3x72(:,:,1312), nhel, den(11))
    call Hcont_VV(nsync, wf24(:,61), wf3(:,28), A(:,1313), n3(:,2341), t3x72(:,:,1313), nhel, den(11))
    call Hcont_VV(nsync, wf3(:,27), wf24(:,62), A(:,1314), n3(:,2342), t3x72(:,:,1314), nhel, den(11))
    call Hcont_VV(nsync, wf3(:,28), wf24(:,62), A(:,1315), n3(:,2343), t3x72(:,:,1315), nhel, den(11))
    call Hcont_VV(nsync, wf24(:,39), wf3(:,23), A(:,1316), n3(:,2344), t3x72(:,:,1316), nhel, den(18))
    call Hcont_VV(nsync, wf3(:,27), wf24(:,63), A(:,1317), n3(:,2345), t3x72(:,:,1317), nhel, den(18))
    call Hcont_VV(nsync, wf3(:,28), wf24(:,63), A(:,1318), n3(:,2346), t3x72(:,:,1318), nhel, den(18))
    call Hcont_VV(nsync, wf3(:,27), wf24(:,64), A(:,1319), n3(:,2347), t3x72(:,:,1319), nhel, den(18))
    call Hcont_VV(nsync, wf3(:,28), wf24(:,64), A(:,1320), n3(:,2348), t3x72(:,:,1320), nhel, den(18))
    call Hcont_QA(nsync, wf36(:,6), wf2(:,23), A(:,1321), n3(:,2349), t3x72(:,:,1321), nhel, den(19))
    call Hcont_QA(nsync, wf36(:,6), wf2(:,24), A(:,1322), n3(:,2350), t3x72(:,:,1322), nhel, den(19))
    call Hcont_QA(nsync, wf36(:,7), wf2(:,23), A(:,1323), n3(:,2351), t3x72(:,:,1323), nhel, den(18))
    call Hcont_QA(nsync, wf36(:,7), wf2(:,24), A(:,1324), n3(:,2352), t3x72(:,:,1324), nhel, den(18))
    call Hcont_VV(nsync, wf24(:,40), wf3(:,23), A(:,1325), n3(:,2353), t3x72(:,:,1325), nhel, den(12))
    call Hcont_VV(nsync, wf3(:,27), wf24(:,65), A(:,1326), n3(:,2354), t3x72(:,:,1326), nhel, den(12))
    call Hcont_VV(nsync, wf3(:,28), wf24(:,65), A(:,1327), n3(:,2355), t3x72(:,:,1327), nhel, den(12))
    call Hcont_VV(nsync, wf3(:,27), wf24(:,66), A(:,1328), n3(:,2356), t3x72(:,:,1328), nhel, den(12))
    call Hcont_VV(nsync, wf3(:,28), wf24(:,66), A(:,1329), n3(:,2357), t3x72(:,:,1329), nhel, den(12))
    call Hcont_VV(nsync, wf24(:,41), wf3(:,23), A(:,1330), n3(:,2358), t3x72(:,:,1330), nhel, den(59))
    call Hcont_VV(nsync, wf24(:,42), wf3(:,23), A(:,1331), n3(:,2359), t3x72(:,:,1331), nhel, den(20))
    call Hcont_VV(nsync, wf3(:,27), wf24(:,67), A(:,1332), n3(:,2360), t3x72(:,:,1332), nhel, den(20))
    call Hcont_VV(nsync, wf3(:,28), wf24(:,67), A(:,1333), n3(:,2361), t3x72(:,:,1333), nhel, den(20))
    call Hcont_VV(nsync, wf3(:,27), wf24(:,68), A(:,1334), n3(:,2362), t3x72(:,:,1334), nhel, den(20))
    call Hcont_VV(nsync, wf3(:,28), wf24(:,68), A(:,1335), n3(:,2363), t3x72(:,:,1335), nhel, den(20))
    call Hcont_QA(nsync, wf36(:,8), wf2(:,23), A(:,1336), n3(:,2364), t3x72(:,:,1336), nhel, den(38))
    call Hcont_QA(nsync, wf36(:,8), wf2(:,24), A(:,1337), n3(:,2365), t3x72(:,:,1337), nhel, den(38))
    call Hcont_QA(nsync, wf36(:,9), wf2(:,23), A(:,1338), n3(:,2366), t3x72(:,:,1338), nhel, den(21))
    call Hcont_QA(nsync, wf36(:,9), wf2(:,24), A(:,1339), n3(:,2367), t3x72(:,:,1339), nhel, den(21))
    call Hcont_QA(nsync, wf36(:,10), wf2(:,23), A(:,1340), n3(:,2368), t3x72(:,:,1340), nhel, den(20))
    call Hcont_QA(nsync, wf36(:,10), wf2(:,24), A(:,1341), n3(:,2369), t3x72(:,:,1341), nhel, den(20))
    call Hcont_QA(nsync, wf12(:,114), wf6(:,232), A(:,1342), n3(:,2370), t3x72(:,:,1342), nhel, den(27))
    call Hcont_QA(nsync, wf12(:,50), wf6(:,239), A(:,1343), n3(:,2371), t3x72(:,:,1343), nhel, den(27))
    call Hcont_QA(nsync, wf12(:,50), wf6(:,240), A(:,1344), n3(:,2372), t3x72(:,:,1344), nhel, den(27))
    call Hcont_QA(nsync, wf12(:,50), wf6(:,241), A(:,1345), n3(:,2373), t3x72(:,:,1345), nhel, den(27))
    call Hcont_QA(nsync, wf12(:,50), wf6(:,242), A(:,1346), n3(:,2374), t3x72(:,:,1346), nhel, den(27))
    call Hcont_QA(nsync, wf12(:,116), wf6(:,232), A(:,1347), n3(:,2375), t3x72(:,:,1347), nhel, den(29))
    call Hcont_QA(nsync, wf12(:,52), wf6(:,239), A(:,1348), n3(:,2376), t3x72(:,:,1348), nhel, den(29))
    call Hcont_QA(nsync, wf12(:,52), wf6(:,240), A(:,1349), n3(:,2377), t3x72(:,:,1349), nhel, den(29))
    call Hcont_QA(nsync, wf12(:,52), wf6(:,241), A(:,1350), n3(:,2378), t3x72(:,:,1350), nhel, den(29))
    call Hcont_QA(nsync, wf12(:,52), wf6(:,242), A(:,1351), n3(:,2379), t3x72(:,:,1351), nhel, den(29))
    call Hcont_VV(nsync, wf8(:,13), wf9(:,34), A(:,1352), n3(:,2380), t3x72(:,:,1352), nhel, den(60))
    call Hcont_QA(nsync, wf12(:,87), wf6(:,243), A(:,1353), n3(:,2381), t3x72(:,:,1353), nhel, den(14))
    call Hcont_QA(nsync, wf12(:,87), wf6(:,244), A(:,1354), n3(:,2382), t3x72(:,:,1354), nhel, den(14))
    call Hcont_QA(nsync, wf18(:,165), wf4(:,49), A(:,1355), n3(:,2383), t3x72(:,:,1355), nhel, den(16))
    call Hcont_QA(nsync, wf18(:,165), wf4(:,50), A(:,1356), n3(:,2384), t3x72(:,:,1356), nhel, den(16))
    call Hcont_QA(nsync, wf18(:,166), wf4(:,49), A(:,1357), n3(:,2385), t3x72(:,:,1357), nhel, den(65))
    call Hcont_QA(nsync, wf18(:,166), wf4(:,50), A(:,1358), n3(:,2386), t3x72(:,:,1358), nhel, den(65))
    call Hcont_VV(nsync, wf24(:,43), wf3(:,22), A(:,1359), n3(:,2387), t3x72(:,:,1359), nhel, den(10))
    call Hcont_VV(nsync, wf3(:,25), wf24(:,69), A(:,1360), n3(:,2388), t3x72(:,:,1360), nhel, den(10))
    call Hcont_VV(nsync, wf3(:,26), wf24(:,69), A(:,1361), n3(:,2389), t3x72(:,:,1361), nhel, den(10))
    call Hcont_VV(nsync, wf3(:,25), wf24(:,70), A(:,1362), n3(:,2390), t3x72(:,:,1362), nhel, den(10))
    call Hcont_VV(nsync, wf3(:,26), wf24(:,70), A(:,1363), n3(:,2391), t3x72(:,:,1363), nhel, den(10))
    call Hcont_VV(nsync, wf24(:,44), wf3(:,22), A(:,1364), n3(:,2392), t3x72(:,:,1364), nhel, den(23))
    call Hcont_VV(nsync, wf3(:,25), wf24(:,71), A(:,1365), n3(:,2393), t3x72(:,:,1365), nhel, den(23))
    call Hcont_VV(nsync, wf3(:,26), wf24(:,71), A(:,1366), n3(:,2394), t3x72(:,:,1366), nhel, den(23))
    call Hcont_VV(nsync, wf3(:,25), wf24(:,72), A(:,1367), n3(:,2395), t3x72(:,:,1367), nhel, den(23))
    call Hcont_VV(nsync, wf3(:,26), wf24(:,72), A(:,1368), n3(:,2396), t3x72(:,:,1368), nhel, den(23))
    call Hcont_QA(nsync, wf36(:,11), wf2(:,25), A(:,1369), n3(:,2397), t3x72(:,:,1369), nhel, den(25))
    call Hcont_QA(nsync, wf36(:,11), wf2(:,26), A(:,1370), n3(:,2398), t3x72(:,:,1370), nhel, den(25))
    call Hcont_QA(nsync, wf36(:,12), wf2(:,25), A(:,1371), n3(:,2399), t3x72(:,:,1371), nhel, den(23))
    call Hcont_QA(nsync, wf36(:,12), wf2(:,26), A(:,1372), n3(:,2400), t3x72(:,:,1372), nhel, den(23))
    call Hcont_VV(nsync, wf24(:,45), wf3(:,22), A(:,1373), n3(:,2401), t3x72(:,:,1373), nhel, den(5))
    call Hcont_VV(nsync, wf3(:,25), wf24(:,73), A(:,1374), n3(:,2402), t3x72(:,:,1374), nhel, den(5))
    call Hcont_VV(nsync, wf3(:,26), wf24(:,73), A(:,1375), n3(:,2403), t3x72(:,:,1375), nhel, den(5))
    call Hcont_VV(nsync, wf3(:,25), wf24(:,74), A(:,1376), n3(:,2404), t3x72(:,:,1376), nhel, den(5))
    call Hcont_VV(nsync, wf3(:,26), wf24(:,74), A(:,1377), n3(:,2405), t3x72(:,:,1377), nhel, den(5))
    call Hcont_VV(nsync, wf24(:,46), wf3(:,22), A(:,1378), n3(:,2406), t3x72(:,:,1378), nhel, den(60))
    call Hcont_VV(nsync, wf24(:,47), wf3(:,22), A(:,1379), n3(:,2407), t3x72(:,:,1379), nhel, den(30))
    call Hcont_VV(nsync, wf3(:,25), wf24(:,75), A(:,1380), n3(:,2408), t3x72(:,:,1380), nhel, den(30))
    call Hcont_VV(nsync, wf3(:,26), wf24(:,75), A(:,1381), n3(:,2409), t3x72(:,:,1381), nhel, den(30))
    call Hcont_VV(nsync, wf3(:,25), wf24(:,76), A(:,1382), n3(:,2410), t3x72(:,:,1382), nhel, den(30))
    call Hcont_VV(nsync, wf3(:,26), wf24(:,76), A(:,1383), n3(:,2411), t3x72(:,:,1383), nhel, den(30))
    call Hcont_QA(nsync, wf36(:,13), wf2(:,25), A(:,1384), n3(:,2412), t3x72(:,:,1384), nhel, den(39))
    call Hcont_QA(nsync, wf36(:,13), wf2(:,26), A(:,1385), n3(:,2413), t3x72(:,:,1385), nhel, den(39))
    call Hcont_QA(nsync, wf36(:,14), wf2(:,25), A(:,1386), n3(:,2414), t3x72(:,:,1386), nhel, den(29))
    call Hcont_QA(nsync, wf36(:,14), wf2(:,26), A(:,1387), n3(:,2415), t3x72(:,:,1387), nhel, den(29))
    call Hcont_QA(nsync, wf36(:,15), wf2(:,25), A(:,1388), n3(:,2416), t3x72(:,:,1388), nhel, den(30))
    call Hcont_QA(nsync, wf36(:,15), wf2(:,26), A(:,1389), n3(:,2417), t3x72(:,:,1389), nhel, den(30))
    call Hcont_QA(nsync, wf12(:,103), wf6(:,229), A(:,1390), n3(:,2418), t3x72(:,:,1390), nhel, den(14))
    call Hcont_QA(nsync, wf12(:,41), wf6(:,245), A(:,1391), n3(:,2419), t3x72(:,:,1391), nhel, den(14))
    call Hcont_QA(nsync, wf12(:,41), wf6(:,246), A(:,1392), n3(:,2420), t3x72(:,:,1392), nhel, den(14))
    call Hcont_QA(nsync, wf12(:,41), wf6(:,247), A(:,1393), n3(:,2421), t3x72(:,:,1393), nhel, den(14))
    call Hcont_QA(nsync, wf12(:,41), wf6(:,248), A(:,1394), n3(:,2422), t3x72(:,:,1394), nhel, den(14))
    call Hcont_QA(nsync, wf12(:,105), wf6(:,229), A(:,1395), n3(:,2423), t3x72(:,:,1395), nhel, den(21))
    call Hcont_QA(nsync, wf12(:,47), wf6(:,245), A(:,1396), n3(:,2424), t3x72(:,:,1396), nhel, den(21))
    call Hcont_QA(nsync, wf12(:,47), wf6(:,246), A(:,1397), n3(:,2425), t3x72(:,:,1397), nhel, den(21))
    call Hcont_QA(nsync, wf12(:,47), wf6(:,247), A(:,1398), n3(:,2426), t3x72(:,:,1398), nhel, den(21))
    call Hcont_QA(nsync, wf12(:,47), wf6(:,248), A(:,1399), n3(:,2427), t3x72(:,:,1399), nhel, den(21))
    call Hcont_VV(nsync, wf8(:,16), wf9(:,35), A(:,1400), n3(:,2428), t3x72(:,:,1400), nhel, den(59))
    call Hcont_QA(nsync, wf12(:,102), wf6(:,249), A(:,1401), n3(:,2429), t3x72(:,:,1401), nhel, den(27))
    call Hcont_QA(nsync, wf12(:,102), wf6(:,250), A(:,1402), n3(:,2430), t3x72(:,:,1402), nhel, den(27))
    call Hcont_QA(nsync, wf18(:,168), wf4(:,51), A(:,1403), n3(:,2431), t3x72(:,:,1403), nhel, den(28))
    call Hcont_QA(nsync, wf18(:,168), wf4(:,52), A(:,1404), n3(:,2432), t3x72(:,:,1404), nhel, den(28))
    call Hcont_QA(nsync, wf18(:,169), wf4(:,51), A(:,1405), n3(:,2433), t3x72(:,:,1405), nhel, den(66))
    call Hcont_QA(nsync, wf18(:,169), wf4(:,52), A(:,1406), n3(:,2434), t3x72(:,:,1406), nhel, den(66))
    call Hcont_VV(nsync, wf24(:,48), wf3(:,24), A(:,1407), n3(:,2435), t3x72(:,:,1407), nhel, den(12))
    call Hcont_VV(nsync, wf3(:,27), wf24(:,77), A(:,1408), n3(:,2436), t3x72(:,:,1408), nhel, den(12))
    call Hcont_VV(nsync, wf3(:,28), wf24(:,77), A(:,1409), n3(:,2437), t3x72(:,:,1409), nhel, den(12))
    call Hcont_VV(nsync, wf3(:,27), wf24(:,78), A(:,1410), n3(:,2438), t3x72(:,:,1410), nhel, den(12))
    call Hcont_VV(nsync, wf3(:,28), wf24(:,78), A(:,1411), n3(:,2439), t3x72(:,:,1411), nhel, den(12))
    call Hcont_VV(nsync, wf24(:,49), wf3(:,24), A(:,1412), n3(:,2440), t3x72(:,:,1412), nhel, den(27))
    call Hcont_VV(nsync, wf3(:,27), wf24(:,79), A(:,1413), n3(:,2441), t3x72(:,:,1413), nhel, den(27))
    call Hcont_VV(nsync, wf3(:,28), wf24(:,79), A(:,1414), n3(:,2442), t3x72(:,:,1414), nhel, den(27))
    call Hcont_VV(nsync, wf3(:,27), wf24(:,80), A(:,1415), n3(:,2443), t3x72(:,:,1415), nhel, den(27))
    call Hcont_VV(nsync, wf3(:,28), wf24(:,80), A(:,1416), n3(:,2444), t3x72(:,:,1416), nhel, den(27))
    call Hcont_QA(nsync, wf36(:,16), wf2(:,25), A(:,1417), n3(:,2445), t3x72(:,:,1417), nhel, den(28))
    call Hcont_QA(nsync, wf36(:,16), wf2(:,26), A(:,1418), n3(:,2446), t3x72(:,:,1418), nhel, den(28))
    call Hcont_QA(nsync, wf36(:,17), wf2(:,25), A(:,1419), n3(:,2447), t3x72(:,:,1419), nhel, den(27))
    call Hcont_QA(nsync, wf36(:,17), wf2(:,26), A(:,1420), n3(:,2448), t3x72(:,:,1420), nhel, den(27))
    call Hcont_VV(nsync, wf24(:,50), wf3(:,24), A(:,1421), n3(:,2449), t3x72(:,:,1421), nhel, den(11))
    call Hcont_VV(nsync, wf3(:,27), wf24(:,81), A(:,1422), n3(:,2450), t3x72(:,:,1422), nhel, den(11))
    call Hcont_VV(nsync, wf3(:,28), wf24(:,81), A(:,1423), n3(:,2451), t3x72(:,:,1423), nhel, den(11))
    call Hcont_VV(nsync, wf3(:,27), wf24(:,82), A(:,1424), n3(:,2452), t3x72(:,:,1424), nhel, den(11))
    call Hcont_VV(nsync, wf3(:,28), wf24(:,82), A(:,1425), n3(:,2453), t3x72(:,:,1425), nhel, den(11))
    call Hcont_VV(nsync, wf24(:,51), wf3(:,24), A(:,1426), n3(:,2454), t3x72(:,:,1426), nhel, den(60))
    call Hcont_VV(nsync, wf24(:,52), wf3(:,24), A(:,1427), n3(:,2455), t3x72(:,:,1427), nhel, den(29))
    call Hcont_VV(nsync, wf3(:,27), wf24(:,83), A(:,1428), n3(:,2456), t3x72(:,:,1428), nhel, den(29))
    call Hcont_VV(nsync, wf3(:,28), wf24(:,83), A(:,1429), n3(:,2457), t3x72(:,:,1429), nhel, den(29))
    call Hcont_VV(nsync, wf3(:,27), wf24(:,84), A(:,1430), n3(:,2458), t3x72(:,:,1430), nhel, den(29))
    call Hcont_VV(nsync, wf3(:,28), wf24(:,84), A(:,1431), n3(:,2459), t3x72(:,:,1431), nhel, den(29))
    call Hcont_QA(nsync, wf36(:,18), wf2(:,25), A(:,1432), n3(:,2460), t3x72(:,:,1432), nhel, den(39))
    call Hcont_QA(nsync, wf36(:,18), wf2(:,26), A(:,1433), n3(:,2461), t3x72(:,:,1433), nhel, den(39))
    call Hcont_QA(nsync, wf36(:,19), wf2(:,25), A(:,1434), n3(:,2462), t3x72(:,:,1434), nhel, den(30))
    call Hcont_QA(nsync, wf36(:,19), wf2(:,26), A(:,1435), n3(:,2463), t3x72(:,:,1435), nhel, den(30))
    call Hcont_QA(nsync, wf36(:,20), wf2(:,25), A(:,1436), n3(:,2464), t3x72(:,:,1436), nhel, den(29))
    call Hcont_QA(nsync, wf36(:,20), wf2(:,26), A(:,1437), n3(:,2465), t3x72(:,:,1437), nhel, den(29))
    call Hcont_QA(nsync, wf12(:,110), wf6(:,231), A(:,1438), n3(:,2466), t3x72(:,:,1438), nhel, den(18))
    call Hcont_QA(nsync, wf12(:,43), wf6(:,251), A(:,1439), n3(:,2467), t3x72(:,:,1439), nhel, den(18))
    call Hcont_QA(nsync, wf12(:,43), wf6(:,252), A(:,1440), n3(:,2468), t3x72(:,:,1440), nhel, den(18))
    call Hcont_QA(nsync, wf12(:,43), wf6(:,253), A(:,1441), n3(:,2469), t3x72(:,:,1441), nhel, den(18))
    call Hcont_QA(nsync, wf12(:,43), wf6(:,254), A(:,1442), n3(:,2470), t3x72(:,:,1442), nhel, den(18))
    call Hcont_QA(nsync, wf12(:,112), wf6(:,231), A(:,1443), n3(:,2471), t3x72(:,:,1443), nhel, den(20))
    call Hcont_QA(nsync, wf12(:,45), wf6(:,251), A(:,1444), n3(:,2472), t3x72(:,:,1444), nhel, den(20))
    call Hcont_QA(nsync, wf12(:,45), wf6(:,252), A(:,1445), n3(:,2473), t3x72(:,:,1445), nhel, den(20))
    call Hcont_QA(nsync, wf12(:,45), wf6(:,253), A(:,1446), n3(:,2474), t3x72(:,:,1446), nhel, den(20))
    call Hcont_QA(nsync, wf12(:,45), wf6(:,254), A(:,1447), n3(:,2475), t3x72(:,:,1447), nhel, den(20))
    call Hcont_VV(nsync, wf8(:,16), wf9(:,36), A(:,1448), n3(:,2476), t3x72(:,:,1448), nhel, den(59))
    call Hcont_QA(nsync, wf12(:,101), wf6(:,255), A(:,1449), n3(:,2477), t3x72(:,:,1449), nhel, den(23))
    call Hcont_QA(nsync, wf12(:,101), wf6(:,256), A(:,1450), n3(:,2478), t3x72(:,:,1450), nhel, den(23))
    call Hcont_QA(nsync, wf18(:,171), wf4(:,51), A(:,1451), n3(:,2479), t3x72(:,:,1451), nhel, den(25))
    call Hcont_QA(nsync, wf18(:,171), wf4(:,52), A(:,1452), n3(:,2480), t3x72(:,:,1452), nhel, den(25))
    call Hcont_QA(nsync, wf18(:,172), wf4(:,51), A(:,1453), n3(:,2481), t3x72(:,:,1453), nhel, den(66))
    call Hcont_QA(nsync, wf18(:,172), wf4(:,52), A(:,1454), n3(:,2482), t3x72(:,:,1454), nhel, den(66))
    call Hcont_QA(nsync, wf12(:,103), wf6(:,243), A(:,1455), n3(:,2483), t3x72(:,:,1455), nhel, den(14))
    call Hcont_QA(nsync, wf12(:,103), wf6(:,244), A(:,1456), n3(:,2484), t3x72(:,:,1456), nhel, den(14))
    call Hcont_QA(nsync, wf12(:,41), wf6(:,257), A(:,1457), n3(:,2485), t3x72(:,:,1457), nhel, den(14))
    call Hcont_QA(nsync, wf12(:,41), wf6(:,258), A(:,1458), n3(:,2486), t3x72(:,:,1458), nhel, den(14))
    call Hcont_QA(nsync, wf18(:,173), wf4(:,49), A(:,1459), n3(:,2487), t3x72(:,:,1459), nhel, den(16))
    call Hcont_QA(nsync, wf18(:,173), wf4(:,50), A(:,1460), n3(:,2488), t3x72(:,:,1460), nhel, den(16))
    call Hcont_QA(nsync, wf18(:,41), wf4(:,53), A(:,1461), n3(:,2489), t3x72(:,:,1461), nhel, den(16))
    call Hcont_QA(nsync, wf18(:,41), wf4(:,54), A(:,1462), n3(:,2490), t3x72(:,:,1462), nhel, den(16))
    call Hcont_QA(nsync, wf12(:,110), wf6(:,237), A(:,1463), n3(:,2491), t3x72(:,:,1463), nhel, den(18))
    call Hcont_QA(nsync, wf12(:,110), wf6(:,238), A(:,1464), n3(:,2492), t3x72(:,:,1464), nhel, den(18))
    call Hcont_QA(nsync, wf12(:,43), wf6(:,259), A(:,1465), n3(:,2493), t3x72(:,:,1465), nhel, den(18))
    call Hcont_QA(nsync, wf12(:,43), wf6(:,260), A(:,1466), n3(:,2494), t3x72(:,:,1466), nhel, den(18))
    call Hcont_QA(nsync, wf18(:,174), wf4(:,49), A(:,1467), n3(:,2495), t3x72(:,:,1467), nhel, den(19))
    call Hcont_QA(nsync, wf18(:,174), wf4(:,50), A(:,1468), n3(:,2496), t3x72(:,:,1468), nhel, den(19))
    call Hcont_QA(nsync, wf18(:,42), wf4(:,53), A(:,1469), n3(:,2497), t3x72(:,:,1469), nhel, den(19))
    call Hcont_QA(nsync, wf18(:,42), wf4(:,54), A(:,1470), n3(:,2498), t3x72(:,:,1470), nhel, den(19))
    call Hcont_QA(nsync, wf12(:,112), wf6(:,237), A(:,1471), n3(:,2499), t3x72(:,:,1471), nhel, den(20))
    call Hcont_QA(nsync, wf12(:,112), wf6(:,238), A(:,1472), n3(:,2500), t3x72(:,:,1472), nhel, den(20))
    call Hcont_QA(nsync, wf12(:,45), wf6(:,259), A(:,1473), n3(:,2501), t3x72(:,:,1473), nhel, den(20))
    call Hcont_QA(nsync, wf12(:,45), wf6(:,260), A(:,1474), n3(:,2502), t3x72(:,:,1474), nhel, den(20))
    call Hcont_QA(nsync, wf12(:,105), wf6(:,243), A(:,1475), n3(:,2503), t3x72(:,:,1475), nhel, den(21))
    call Hcont_QA(nsync, wf12(:,105), wf6(:,244), A(:,1476), n3(:,2504), t3x72(:,:,1476), nhel, den(21))
    call Hcont_QA(nsync, wf12(:,47), wf6(:,257), A(:,1477), n3(:,2505), t3x72(:,:,1477), nhel, den(21))
    call Hcont_QA(nsync, wf12(:,47), wf6(:,258), A(:,1478), n3(:,2506), t3x72(:,:,1478), nhel, den(21))
    call Hcont_QA(nsync, wf12(:,106), wf6(:,255), A(:,1479), n3(:,2507), t3x72(:,:,1479), nhel, den(23))
    call Hcont_QA(nsync, wf12(:,48), wf6(:,261), A(:,1480), n3(:,2508), t3x72(:,:,1480), nhel, den(23))
    call Hcont_QA(nsync, wf12(:,106), wf6(:,256), A(:,1481), n3(:,2509), t3x72(:,:,1481), nhel, den(23))
    call Hcont_QA(nsync, wf12(:,48), wf6(:,262), A(:,1482), n3(:,2510), t3x72(:,:,1482), nhel, den(23))
    call Hcont_QA(nsync, wf18(:,175), wf4(:,51), A(:,1483), n3(:,2511), t3x72(:,:,1483), nhel, den(25))
    call Hcont_QA(nsync, wf18(:,43), wf4(:,55), A(:,1484), n3(:,2512), t3x72(:,:,1484), nhel, den(25))
    call Hcont_QA(nsync, wf18(:,175), wf4(:,52), A(:,1485), n3(:,2513), t3x72(:,:,1485), nhel, den(25))
    call Hcont_QA(nsync, wf18(:,43), wf4(:,56), A(:,1486), n3(:,2514), t3x72(:,:,1486), nhel, den(25))
    call Hcont_QA(nsync, wf12(:,114), wf6(:,249), A(:,1487), n3(:,2515), t3x72(:,:,1487), nhel, den(27))
    call Hcont_QA(nsync, wf12(:,50), wf6(:,263), A(:,1488), n3(:,2516), t3x72(:,:,1488), nhel, den(27))
    call Hcont_QA(nsync, wf12(:,114), wf6(:,250), A(:,1489), n3(:,2517), t3x72(:,:,1489), nhel, den(27))
    call Hcont_QA(nsync, wf12(:,50), wf6(:,264), A(:,1490), n3(:,2518), t3x72(:,:,1490), nhel, den(27))
    call Hcont_QA(nsync, wf18(:,176), wf4(:,51), A(:,1491), n3(:,2519), t3x72(:,:,1491), nhel, den(28))
    call Hcont_QA(nsync, wf18(:,44), wf4(:,55), A(:,1492), n3(:,2520), t3x72(:,:,1492), nhel, den(28))
    call Hcont_QA(nsync, wf18(:,176), wf4(:,52), A(:,1493), n3(:,2521), t3x72(:,:,1493), nhel, den(28))
    call Hcont_QA(nsync, wf18(:,44), wf4(:,56), A(:,1494), n3(:,2522), t3x72(:,:,1494), nhel, den(28))
    call Hcont_QA(nsync, wf12(:,116), wf6(:,249), A(:,1495), n3(:,2523), t3x72(:,:,1495), nhel, den(29))
    call Hcont_QA(nsync, wf12(:,52), wf6(:,263), A(:,1496), n3(:,2524), t3x72(:,:,1496), nhel, den(29))
    call Hcont_QA(nsync, wf12(:,116), wf6(:,250), A(:,1497), n3(:,2525), t3x72(:,:,1497), nhel, den(29))
    call Hcont_QA(nsync, wf12(:,52), wf6(:,264), A(:,1498), n3(:,2526), t3x72(:,:,1498), nhel, den(29))
    call Hcont_QA(nsync, wf12(:,108), wf6(:,255), A(:,1499), n3(:,2527), t3x72(:,:,1499), nhel, den(30))
    call Hcont_QA(nsync, wf12(:,54), wf6(:,261), A(:,1500), n3(:,2528), t3x72(:,:,1500), nhel, den(30))
    call Hcont_QA(nsync, wf12(:,108), wf6(:,256), A(:,1501), n3(:,2529), t3x72(:,:,1501), nhel, den(30))
    call Hcont_QA(nsync, wf12(:,54), wf6(:,262), A(:,1502), n3(:,2530), t3x72(:,:,1502), nhel, den(30))
    call Hcont_QA(nsync, wf6(:,268), wf12(:,155), A(:,1503), n3(:,2531), t3x72(:,:,1503), nhel, den(3))
    call Hcont_QA(nsync, wf6(:,268), wf12(:,156), A(:,1504), n3(:,2532), t3x72(:,:,1504), nhel, den(3))
    call Hcont_QA(nsync, wf12(:,155), wf6(:,272), A(:,1505), n3(:,2533), t3x72(:,:,1505), nhel, den(3))
    call Hcont_QA(nsync, wf12(:,156), wf6(:,272), A(:,1506), n3(:,2534), t3x72(:,:,1506), nhel, den(3))
    call Hcont_QA(nsync, wf4(:,58), wf18(:,233), A(:,1507), n3(:,2535), t3x72(:,:,1507), nhel, den(5))
    call Hcont_QA(nsync, wf4(:,58), wf18(:,234), A(:,1508), n3(:,2536), t3x72(:,:,1508), nhel, den(5))
    call Hcont_QA(nsync, wf18(:,233), wf4(:,60), A(:,1509), n3(:,2537), t3x72(:,:,1509), nhel, den(5))
    call Hcont_QA(nsync, wf18(:,234), wf4(:,60), A(:,1510), n3(:,2538), t3x72(:,:,1510), nhel, den(5))
    call Hcont_QA(nsync, wf6(:,276), wf12(:,157), A(:,1511), n3(:,2539), t3x72(:,:,1511), nhel, den(8))
    call Hcont_QA(nsync, wf12(:,157), wf6(:,278), A(:,1512), n3(:,2540), t3x72(:,:,1512), nhel, den(8))
    call Hcont_QA(nsync, wf6(:,276), wf12(:,158), A(:,1513), n3(:,2541), t3x72(:,:,1513), nhel, den(8))
    call Hcont_QA(nsync, wf6(:,278), wf12(:,158), A(:,1514), n3(:,2542), t3x72(:,:,1514), nhel, den(8))
    call Hcont_QA(nsync, wf4(:,58), wf18(:,235), A(:,1515), n3(:,2543), t3x72(:,:,1515), nhel, den(11))
    call Hcont_QA(nsync, wf4(:,58), wf18(:,236), A(:,1516), n3(:,2544), t3x72(:,:,1516), nhel, den(11))
    call Hcont_QA(nsync, wf4(:,60), wf18(:,235), A(:,1517), n3(:,2545), t3x72(:,:,1517), nhel, den(11))
    call Hcont_QA(nsync, wf4(:,60), wf18(:,236), A(:,1518), n3(:,2546), t3x72(:,:,1518), nhel, den(11))
    call Hcont_QA(nsync, wf4(:,62), wf18(:,237), A(:,1519), n3(:,2547), t3x72(:,:,1519), nhel, den(10))
    call Hcont_QA(nsync, wf18(:,237), wf4(:,64), A(:,1520), n3(:,2548), t3x72(:,:,1520), nhel, den(10))
    call Hcont_QA(nsync, wf4(:,62), wf18(:,238), A(:,1521), n3(:,2549), t3x72(:,:,1521), nhel, den(10))
    call Hcont_QA(nsync, wf4(:,64), wf18(:,238), A(:,1522), n3(:,2550), t3x72(:,:,1522), nhel, den(10))
    call Hcont_QA(nsync, wf4(:,62), wf18(:,239), A(:,1523), n3(:,2551), t3x72(:,:,1523), nhel, den(12))
    call Hcont_QA(nsync, wf4(:,64), wf18(:,239), A(:,1524), n3(:,2552), t3x72(:,:,1524), nhel, den(12))
    call Hcont_QA(nsync, wf4(:,62), wf18(:,240), A(:,1525), n3(:,2553), t3x72(:,:,1525), nhel, den(12))
    call Hcont_QA(nsync, wf4(:,64), wf18(:,240), A(:,1526), n3(:,2554), t3x72(:,:,1526), nhel, den(12))
    call Hcont_QA(nsync, wf12(:,41), wf6(:,281), A(:,1527), n3(:,2555), t3x72(:,:,1527), nhel, den(14))
    call Hcont_QA(nsync, wf12(:,41), wf6(:,282), A(:,1528), n3(:,2556), t3x72(:,:,1528), nhel, den(14))
    call Hcont_QA(nsync, wf12(:,57), wf6(:,283), A(:,1529), n3(:,2557), t3x72(:,:,1529), nhel, den(14))
    call Hcont_QA(nsync, wf12(:,57), wf6(:,284), A(:,1530), n3(:,2558), t3x72(:,:,1530), nhel, den(14))
    call Hcont_QA(nsync, wf18(:,41), wf4(:,65), A(:,1531), n3(:,2559), t3x72(:,:,1531), nhel, den(16))
    call Hcont_QA(nsync, wf18(:,41), wf4(:,66), A(:,1532), n3(:,2560), t3x72(:,:,1532), nhel, den(16))
    call Hcont_QA(nsync, wf18(:,49), wf4(:,67), A(:,1533), n3(:,2561), t3x72(:,:,1533), nhel, den(16))
    call Hcont_QA(nsync, wf18(:,49), wf4(:,68), A(:,1534), n3(:,2562), t3x72(:,:,1534), nhel, den(16))
    call Hcont_QA(nsync, wf12(:,43), wf6(:,285), A(:,1535), n3(:,2563), t3x72(:,:,1535), nhel, den(18))
    call Hcont_QA(nsync, wf12(:,43), wf6(:,286), A(:,1536), n3(:,2564), t3x72(:,:,1536), nhel, den(18))
    call Hcont_QA(nsync, wf12(:,59), wf6(:,287), A(:,1537), n3(:,2565), t3x72(:,:,1537), nhel, den(18))
    call Hcont_QA(nsync, wf12(:,59), wf6(:,288), A(:,1538), n3(:,2566), t3x72(:,:,1538), nhel, den(18))
    call Hcont_QA(nsync, wf18(:,42), wf4(:,65), A(:,1539), n3(:,2567), t3x72(:,:,1539), nhel, den(19))
    call Hcont_QA(nsync, wf18(:,42), wf4(:,66), A(:,1540), n3(:,2568), t3x72(:,:,1540), nhel, den(19))
    call Hcont_QA(nsync, wf18(:,50), wf4(:,67), A(:,1541), n3(:,2569), t3x72(:,:,1541), nhel, den(19))
    call Hcont_QA(nsync, wf18(:,50), wf4(:,68), A(:,1542), n3(:,2570), t3x72(:,:,1542), nhel, den(19))
    call Hcont_QA(nsync, wf12(:,45), wf6(:,285), A(:,1543), n3(:,2571), t3x72(:,:,1543), nhel, den(20))
    call Hcont_QA(nsync, wf12(:,45), wf6(:,286), A(:,1544), n3(:,2572), t3x72(:,:,1544), nhel, den(20))
    call Hcont_QA(nsync, wf12(:,61), wf6(:,287), A(:,1545), n3(:,2573), t3x72(:,:,1545), nhel, den(20))
    call Hcont_QA(nsync, wf12(:,61), wf6(:,288), A(:,1546), n3(:,2574), t3x72(:,:,1546), nhel, den(20))
    call Hcont_QA(nsync, wf12(:,47), wf6(:,281), A(:,1547), n3(:,2575), t3x72(:,:,1547), nhel, den(21))
    call Hcont_QA(nsync, wf12(:,47), wf6(:,282), A(:,1548), n3(:,2576), t3x72(:,:,1548), nhel, den(21))
    call Hcont_QA(nsync, wf12(:,63), wf6(:,283), A(:,1549), n3(:,2577), t3x72(:,:,1549), nhel, den(21))
    call Hcont_QA(nsync, wf12(:,63), wf6(:,284), A(:,1550), n3(:,2578), t3x72(:,:,1550), nhel, den(21))
    call Hcont_QA(nsync, wf12(:,48), wf6(:,289), A(:,1551), n3(:,2579), t3x72(:,:,1551), nhel, den(23))
    call Hcont_QA(nsync, wf12(:,48), wf6(:,290), A(:,1552), n3(:,2580), t3x72(:,:,1552), nhel, den(23))
    call Hcont_QA(nsync, wf12(:,64), wf6(:,291), A(:,1553), n3(:,2581), t3x72(:,:,1553), nhel, den(23))
    call Hcont_QA(nsync, wf12(:,64), wf6(:,292), A(:,1554), n3(:,2582), t3x72(:,:,1554), nhel, den(23))
    call Hcont_QA(nsync, wf18(:,43), wf4(:,69), A(:,1555), n3(:,2583), t3x72(:,:,1555), nhel, den(25))
    call Hcont_QA(nsync, wf18(:,43), wf4(:,70), A(:,1556), n3(:,2584), t3x72(:,:,1556), nhel, den(25))
    call Hcont_QA(nsync, wf18(:,51), wf4(:,71), A(:,1557), n3(:,2585), t3x72(:,:,1557), nhel, den(25))
    call Hcont_QA(nsync, wf18(:,51), wf4(:,72), A(:,1558), n3(:,2586), t3x72(:,:,1558), nhel, den(25))
    call Hcont_QA(nsync, wf12(:,50), wf6(:,293), A(:,1559), n3(:,2587), t3x72(:,:,1559), nhel, den(27))
    call Hcont_QA(nsync, wf12(:,50), wf6(:,294), A(:,1560), n3(:,2588), t3x72(:,:,1560), nhel, den(27))
    call Hcont_QA(nsync, wf12(:,66), wf6(:,295), A(:,1561), n3(:,2589), t3x72(:,:,1561), nhel, den(27))
    call Hcont_QA(nsync, wf12(:,66), wf6(:,296), A(:,1562), n3(:,2590), t3x72(:,:,1562), nhel, den(27))
    call Hcont_QA(nsync, wf18(:,44), wf4(:,69), A(:,1563), n3(:,2591), t3x72(:,:,1563), nhel, den(28))
    call Hcont_QA(nsync, wf18(:,44), wf4(:,70), A(:,1564), n3(:,2592), t3x72(:,:,1564), nhel, den(28))
    call Hcont_QA(nsync, wf18(:,52), wf4(:,71), A(:,1565), n3(:,2593), t3x72(:,:,1565), nhel, den(28))
    call Hcont_QA(nsync, wf18(:,52), wf4(:,72), A(:,1566), n3(:,2594), t3x72(:,:,1566), nhel, den(28))
    call Hcont_QA(nsync, wf12(:,52), wf6(:,293), A(:,1567), n3(:,2595), t3x72(:,:,1567), nhel, den(29))
    call Hcont_QA(nsync, wf12(:,52), wf6(:,294), A(:,1568), n3(:,2596), t3x72(:,:,1568), nhel, den(29))
    call Hcont_QA(nsync, wf12(:,68), wf6(:,295), A(:,1569), n3(:,2597), t3x72(:,:,1569), nhel, den(29))
    call Hcont_QA(nsync, wf12(:,68), wf6(:,296), A(:,1570), n3(:,2598), t3x72(:,:,1570), nhel, den(29))
    call Hcont_QA(nsync, wf12(:,54), wf6(:,289), A(:,1571), n3(:,2599), t3x72(:,:,1571), nhel, den(30))
    call Hcont_QA(nsync, wf12(:,54), wf6(:,290), A(:,1572), n3(:,2600), t3x72(:,:,1572), nhel, den(30))
    call Hcont_QA(nsync, wf12(:,70), wf6(:,291), A(:,1573), n3(:,2601), t3x72(:,:,1573), nhel, den(30))
    call Hcont_QA(nsync, wf12(:,70), wf6(:,292), A(:,1574), n3(:,2602), t3x72(:,:,1574), nhel, den(30))
    call Hcont_QA(nsync, wf6(:,298), wf12(:,159), A(:,1575), n3(:,2603), t3x72(:,:,1575), nhel, den(10))
    call Hcont_QA(nsync, wf6(:,300), wf12(:,160), A(:,1576), n3(:,2604), t3x72(:,:,1576), nhel, den(12))
    call Hcont_VV(nsync, wf9(:,2), wf8(:,37), A(:,1577), n3(:,2605), t3x72(:,:,1577), nhel, den(53))
    call Hcont_VV(nsync, wf9(:,1), wf8(:,37), A(:,1578), n3(:,2606), t3x72(:,:,1578), nhel, den(53))
    call Hcont_VV(nsync, wf9(:,2), wf8(:,38), A(:,1579), n3(:,2607), t3x72(:,:,1579), nhel, den(55))
    call Hcont_VV(nsync, wf9(:,1), wf8(:,38), A(:,1580), n3(:,2608), t3x72(:,:,1580), nhel, den(55))
    call Hcont_QA(nsync, wf6(:,302), wf12(:,161), A(:,1581), n3(:,2609), t3x72(:,:,1581), nhel, den(5))
    call Hcont_QA(nsync, wf6(:,304), wf12(:,162), A(:,1582), n3(:,2610), t3x72(:,:,1582), nhel, den(11))
    call Hcont_VV(nsync, wf9(:,2), wf8(:,39), A(:,1583), n3(:,2611), t3x72(:,:,1583), nhel, den(56))
    call Hcont_VV(nsync, wf9(:,1), wf8(:,39), A(:,1584), n3(:,2612), t3x72(:,:,1584), nhel, den(56))
    call Hcont_VV(nsync, wf9(:,2), wf8(:,40), A(:,1585), n3(:,2613), t3x72(:,:,1585), nhel, den(57))
    call Hcont_VV(nsync, wf9(:,1), wf8(:,40), A(:,1586), n3(:,2614), t3x72(:,:,1586), nhel, den(57))
    call Hcont_QA(nsync, wf6(:,300), wf12(:,163), A(:,1587), n3(:,2615), t3x72(:,:,1587), nhel, den(3))
    call Hcont_QA(nsync, wf6(:,298), wf12(:,164), A(:,1588), n3(:,2616), t3x72(:,:,1588), nhel, den(8))
    call Hcont_QA(nsync, wf12(:,141), wf6(:,298), A(:,1589), n3(:,2617), t3x72(:,:,1589), nhel, den(10))
    call Hcont_QA(nsync, wf12(:,81), wf6(:,305), A(:,1590), n3(:,2618), t3x72(:,:,1590), nhel, den(21))
    call Hcont_VV(nsync, wf9(:,23), wf8(:,41), A(:,1591), n3(:,2619), t3x72(:,:,1591), nhel, den(32))
    call Hcont_VV(nsync, wf9(:,24), wf8(:,41), A(:,1592), n3(:,2620), t3x72(:,:,1592), nhel, den(32))
    call Hcont_VV(nsync, wf9(:,23), wf8(:,42), A(:,1593), n3(:,2621), t3x72(:,:,1593), nhel, den(34))
    call Hcont_VV(nsync, wf9(:,24), wf8(:,42), A(:,1594), n3(:,2622), t3x72(:,:,1594), nhel, den(34))
    call Hcont_QA(nsync, wf12(:,142), wf6(:,300), A(:,1595), n3(:,2623), t3x72(:,:,1595), nhel, den(12))
    call Hcont_QA(nsync, wf12(:,86), wf6(:,306), A(:,1596), n3(:,2624), t3x72(:,:,1596), nhel, den(20))
    call Hcont_VV(nsync, wf9(:,25), wf8(:,41), A(:,1597), n3(:,2625), t3x72(:,:,1597), nhel, den(32))
    call Hcont_VV(nsync, wf9(:,26), wf8(:,41), A(:,1598), n3(:,2626), t3x72(:,:,1598), nhel, den(32))
    call Hcont_VV(nsync, wf9(:,25), wf8(:,42), A(:,1599), n3(:,2627), t3x72(:,:,1599), nhel, den(34))
    call Hcont_VV(nsync, wf9(:,26), wf8(:,42), A(:,1600), n3(:,2628), t3x72(:,:,1600), nhel, den(34))
    call Hcont_QA(nsync, wf4(:,18), wf18(:,177), A(:,1601), n3(:,2629), t3x72(:,:,1601), nhel, den(5))
    call Hcont_QA(nsync, wf6(:,184), wf12(:,162), A(:,1602), n3(:,2630), t3x72(:,:,1602), nhel, den(11))
    call Hcont_VV(nsync, wf9(:,23), wf8(:,43), A(:,1603), n3(:,2631), t3x72(:,:,1603), nhel, den(35))
    call Hcont_VV(nsync, wf9(:,24), wf8(:,43), A(:,1604), n3(:,2632), t3x72(:,:,1604), nhel, den(35))
    call Hcont_VV(nsync, wf9(:,23), wf8(:,44), A(:,1605), n3(:,2633), t3x72(:,:,1605), nhel, den(36))
    call Hcont_VV(nsync, wf9(:,24), wf8(:,44), A(:,1606), n3(:,2634), t3x72(:,:,1606), nhel, den(36))
    call Hcont_QA(nsync, wf4(:,18), wf18(:,178), A(:,1607), n3(:,2635), t3x72(:,:,1607), nhel, den(11))
    call Hcont_QA(nsync, wf6(:,186), wf12(:,161), A(:,1608), n3(:,2636), t3x72(:,:,1608), nhel, den(5))
    call Hcont_VV(nsync, wf9(:,25), wf8(:,43), A(:,1609), n3(:,2637), t3x72(:,:,1609), nhel, den(35))
    call Hcont_VV(nsync, wf9(:,26), wf8(:,43), A(:,1610), n3(:,2638), t3x72(:,:,1610), nhel, den(35))
    call Hcont_VV(nsync, wf9(:,25), wf8(:,44), A(:,1611), n3(:,2639), t3x72(:,:,1611), nhel, den(36))
    call Hcont_VV(nsync, wf9(:,26), wf8(:,44), A(:,1612), n3(:,2640), t3x72(:,:,1612), nhel, den(36))
    call Hcont_QA(nsync, wf12(:,87), wf6(:,305), A(:,1613), n3(:,2641), t3x72(:,:,1613), nhel, den(14))
    call Hcont_QA(nsync, wf6(:,184), wf12(:,165), A(:,1614), n3(:,2642), t3x72(:,:,1614), nhel, den(8))
    call Hcont_QA(nsync, wf12(:,89), wf6(:,306), A(:,1615), n3(:,2643), t3x72(:,:,1615), nhel, den(18))
    call Hcont_QA(nsync, wf6(:,186), wf12(:,166), A(:,1616), n3(:,2644), t3x72(:,:,1616), nhel, den(3))
    call Hcont_QA(nsync, wf12(:,145), wf6(:,302), A(:,1617), n3(:,2645), t3x72(:,:,1617), nhel, den(5))
    call Hcont_QA(nsync, wf12(:,95), wf6(:,307), A(:,1618), n3(:,2646), t3x72(:,:,1618), nhel, den(30))
    call Hcont_VV(nsync, wf9(:,23), wf8(:,45), A(:,1619), n3(:,2647), t3x72(:,:,1619), nhel, den(35))
    call Hcont_VV(nsync, wf9(:,24), wf8(:,45), A(:,1620), n3(:,2648), t3x72(:,:,1620), nhel, den(35))
    call Hcont_VV(nsync, wf9(:,23), wf8(:,46), A(:,1621), n3(:,2649), t3x72(:,:,1621), nhel, den(36))
    call Hcont_VV(nsync, wf9(:,24), wf8(:,46), A(:,1622), n3(:,2650), t3x72(:,:,1622), nhel, den(36))
    call Hcont_QA(nsync, wf12(:,146), wf6(:,304), A(:,1623), n3(:,2651), t3x72(:,:,1623), nhel, den(11))
    call Hcont_QA(nsync, wf12(:,100), wf6(:,308), A(:,1624), n3(:,2652), t3x72(:,:,1624), nhel, den(29))
    call Hcont_VV(nsync, wf9(:,25), wf8(:,45), A(:,1625), n3(:,2653), t3x72(:,:,1625), nhel, den(35))
    call Hcont_VV(nsync, wf9(:,26), wf8(:,45), A(:,1626), n3(:,2654), t3x72(:,:,1626), nhel, den(35))
    call Hcont_VV(nsync, wf9(:,25), wf8(:,46), A(:,1627), n3(:,2655), t3x72(:,:,1627), nhel, den(36))
    call Hcont_VV(nsync, wf9(:,26), wf8(:,46), A(:,1628), n3(:,2656), t3x72(:,:,1628), nhel, den(36))
    call Hcont_QA(nsync, wf4(:,16), wf18(:,179), A(:,1629), n3(:,2657), t3x72(:,:,1629), nhel, den(10))
    call Hcont_QA(nsync, wf6(:,190), wf12(:,160), A(:,1630), n3(:,2658), t3x72(:,:,1630), nhel, den(12))
    call Hcont_VV(nsync, wf9(:,23), wf8(:,47), A(:,1631), n3(:,2659), t3x72(:,:,1631), nhel, den(32))
    call Hcont_VV(nsync, wf9(:,24), wf8(:,47), A(:,1632), n3(:,2660), t3x72(:,:,1632), nhel, den(32))
    call Hcont_VV(nsync, wf9(:,23), wf8(:,48), A(:,1633), n3(:,2661), t3x72(:,:,1633), nhel, den(34))
    call Hcont_VV(nsync, wf9(:,24), wf8(:,48), A(:,1634), n3(:,2662), t3x72(:,:,1634), nhel, den(34))
    call Hcont_QA(nsync, wf4(:,16), wf18(:,180), A(:,1635), n3(:,2663), t3x72(:,:,1635), nhel, den(12))
    call Hcont_QA(nsync, wf6(:,192), wf12(:,159), A(:,1636), n3(:,2664), t3x72(:,:,1636), nhel, den(10))
    call Hcont_VV(nsync, wf9(:,25), wf8(:,47), A(:,1637), n3(:,2665), t3x72(:,:,1637), nhel, den(32))
    call Hcont_VV(nsync, wf9(:,26), wf8(:,47), A(:,1638), n3(:,2666), t3x72(:,:,1638), nhel, den(32))
    call Hcont_VV(nsync, wf9(:,25), wf8(:,48), A(:,1639), n3(:,2667), t3x72(:,:,1639), nhel, den(34))
    call Hcont_VV(nsync, wf9(:,26), wf8(:,48), A(:,1640), n3(:,2668), t3x72(:,:,1640), nhel, den(34))
    call Hcont_QA(nsync, wf12(:,101), wf6(:,307), A(:,1641), n3(:,2669), t3x72(:,:,1641), nhel, den(23))
    call Hcont_QA(nsync, wf6(:,190), wf12(:,163), A(:,1642), n3(:,2670), t3x72(:,:,1642), nhel, den(3))
    call Hcont_QA(nsync, wf12(:,102), wf6(:,308), A(:,1643), n3(:,2671), t3x72(:,:,1643), nhel, den(27))
    call Hcont_QA(nsync, wf6(:,192), wf12(:,164), A(:,1644), n3(:,2672), t3x72(:,:,1644), nhel, den(8))
    call Hcont_QA(nsync, wf4(:,18), wf18(:,181), A(:,1645), n3(:,2673), t3x72(:,:,1645), nhel, den(5))
    call Hcont_QA(nsync, wf4(:,20), wf18(:,241), A(:,1646), n3(:,2674), t3x72(:,:,1646), nhel, den(5))
    call Hcont_QA(nsync, wf12(:,103), wf6(:,305), A(:,1647), n3(:,2675), t3x72(:,:,1647), nhel, den(14))
    call Hcont_QA(nsync, wf12(:,57), wf6(:,193), A(:,1648), n3(:,2676), t3x72(:,:,1648), nhel, den(14))
    call Hcont_QA(nsync, wf18(:,242), wf4(:,74), A(:,1649), n3(:,2677), t3x72(:,:,1649), nhel, den(5))
    call Hcont_QA(nsync, wf18(:,242), wf4(:,76), A(:,1650), n3(:,2678), t3x72(:,:,1650), nhel, den(5))
    call Hcont_QA(nsync, wf12(:,57), wf6(:,309), A(:,1651), n3(:,2679), t3x72(:,:,1651), nhel, den(14))
    call Hcont_QA(nsync, wf12(:,57), wf6(:,310), A(:,1652), n3(:,2680), t3x72(:,:,1652), nhel, den(14))
    call Hcont_QA(nsync, wf4(:,22), wf18(:,243), A(:,1653), n3(:,2681), t3x72(:,:,1653), nhel, den(10))
    call Hcont_QA(nsync, wf4(:,16), wf18(:,185), A(:,1654), n3(:,2682), t3x72(:,:,1654), nhel, den(10))
    call Hcont_VV(nsync, wf9(:,27), wf8(:,49), A(:,1655), n3(:,2683), t3x72(:,:,1655), nhel, den(38))
    call Hcont_VV(nsync, wf9(:,28), wf8(:,50), A(:,1656), n3(:,2684), t3x72(:,:,1656), nhel, den(38))
    call Hcont_QA(nsync, wf12(:,105), wf6(:,305), A(:,1657), n3(:,2685), t3x72(:,:,1657), nhel, den(21))
    call Hcont_QA(nsync, wf12(:,63), wf6(:,193), A(:,1658), n3(:,2686), t3x72(:,:,1658), nhel, den(21))
    call Hcont_QA(nsync, wf4(:,16), wf18(:,244), A(:,1659), n3(:,2687), t3x72(:,:,1659), nhel, den(38))
    call Hcont_QA(nsync, wf4(:,16), wf18(:,245), A(:,1660), n3(:,2688), t3x72(:,:,1660), nhel, den(38))
    call Hcont_QA(nsync, wf12(:,159), wf6(:,312), A(:,1661), n3(:,2689), t3x72(:,:,1661), nhel, den(10))
    call Hcont_QA(nsync, wf12(:,159), wf6(:,314), A(:,1662), n3(:,2690), t3x72(:,:,1662), nhel, den(10))
    call Hcont_QA(nsync, wf12(:,63), wf6(:,309), A(:,1663), n3(:,2691), t3x72(:,:,1663), nhel, den(21))
    call Hcont_QA(nsync, wf12(:,63), wf6(:,310), A(:,1664), n3(:,2692), t3x72(:,:,1664), nhel, den(21))
    call Hcont_QA(nsync, wf12(:,64), wf6(:,200), A(:,1665), n3(:,2693), t3x72(:,:,1665), nhel, den(23))
    call Hcont_QA(nsync, wf12(:,106), wf6(:,307), A(:,1666), n3(:,2694), t3x72(:,:,1666), nhel, den(23))
    call Hcont_VV(nsync, wf9(:,27), wf8(:,51), A(:,1667), n3(:,2695), t3x72(:,:,1667), nhel, den(39))
    call Hcont_VV(nsync, wf9(:,28), wf8(:,52), A(:,1668), n3(:,2696), t3x72(:,:,1668), nhel, den(39))
    call Hcont_QA(nsync, wf12(:,70), wf6(:,200), A(:,1669), n3(:,2697), t3x72(:,:,1669), nhel, den(30))
    call Hcont_QA(nsync, wf12(:,108), wf6(:,307), A(:,1670), n3(:,2698), t3x72(:,:,1670), nhel, den(30))
    call Hcont_QA(nsync, wf4(:,74), wf18(:,246), A(:,1671), n3(:,2699), t3x72(:,:,1671), nhel, den(39))
    call Hcont_QA(nsync, wf4(:,76), wf18(:,246), A(:,1672), n3(:,2700), t3x72(:,:,1672), nhel, den(39))
    call Hcont_QA(nsync, wf12(:,164), wf6(:,312), A(:,1673), n3(:,2701), t3x72(:,:,1673), nhel, den(8))
    call Hcont_QA(nsync, wf12(:,164), wf6(:,314), A(:,1674), n3(:,2702), t3x72(:,:,1674), nhel, den(8))
    call Hcont_QA(nsync, wf4(:,73), wf18(:,248), A(:,1675), n3(:,2703), t3x72(:,:,1675), nhel, den(19))
    call Hcont_QA(nsync, wf4(:,75), wf18(:,248), A(:,1676), n3(:,2704), t3x72(:,:,1676), nhel, den(19))
    call Hcont_QA(nsync, wf18(:,249), wf4(:,78), A(:,1677), n3(:,2705), t3x72(:,:,1677), nhel, den(10))
    call Hcont_QA(nsync, wf18(:,249), wf4(:,80), A(:,1678), n3(:,2706), t3x72(:,:,1678), nhel, den(10))
    call Hcont_QA(nsync, wf12(:,64), wf6(:,315), A(:,1679), n3(:,2707), t3x72(:,:,1679), nhel, den(23))
    call Hcont_QA(nsync, wf12(:,64), wf6(:,316), A(:,1680), n3(:,2708), t3x72(:,:,1680), nhel, den(23))
    call Hcont_QA(nsync, wf4(:,18), wf18(:,250), A(:,1681), n3(:,2709), t3x72(:,:,1681), nhel, den(39))
    call Hcont_QA(nsync, wf4(:,18), wf18(:,251), A(:,1682), n3(:,2710), t3x72(:,:,1682), nhel, den(39))
    call Hcont_QA(nsync, wf12(:,161), wf6(:,318), A(:,1683), n3(:,2711), t3x72(:,:,1683), nhel, den(5))
    call Hcont_QA(nsync, wf12(:,161), wf6(:,320), A(:,1684), n3(:,2712), t3x72(:,:,1684), nhel, den(5))
    call Hcont_QA(nsync, wf12(:,70), wf6(:,315), A(:,1685), n3(:,2713), t3x72(:,:,1685), nhel, den(30))
    call Hcont_QA(nsync, wf12(:,70), wf6(:,316), A(:,1686), n3(:,2714), t3x72(:,:,1686), nhel, den(30))
    call Hcont_QA(nsync, wf4(:,78), wf18(:,252), A(:,1687), n3(:,2715), t3x72(:,:,1687), nhel, den(38))
    call Hcont_QA(nsync, wf4(:,80), wf18(:,252), A(:,1688), n3(:,2716), t3x72(:,:,1688), nhel, den(38))
    call Hcont_QA(nsync, wf12(:,166), wf6(:,318), A(:,1689), n3(:,2717), t3x72(:,:,1689), nhel, den(3))
    call Hcont_QA(nsync, wf12(:,166), wf6(:,320), A(:,1690), n3(:,2718), t3x72(:,:,1690), nhel, den(3))
    call Hcont_QA(nsync, wf4(:,77), wf18(:,254), A(:,1691), n3(:,2719), t3x72(:,:,1691), nhel, den(28))
    call Hcont_QA(nsync, wf4(:,79), wf18(:,254), A(:,1692), n3(:,2720), t3x72(:,:,1692), nhel, den(28))
    call Hcont_QA(nsync, wf4(:,18), wf18(:,197), A(:,1693), n3(:,2721), t3x72(:,:,1693), nhel, den(11))
    call Hcont_QA(nsync, wf4(:,20), wf18(:,255), A(:,1694), n3(:,2722), t3x72(:,:,1694), nhel, den(11))
    call Hcont_QA(nsync, wf12(:,110), wf6(:,306), A(:,1695), n3(:,2723), t3x72(:,:,1695), nhel, den(18))
    call Hcont_QA(nsync, wf12(:,59), wf6(:,207), A(:,1696), n3(:,2724), t3x72(:,:,1696), nhel, den(18))
    call Hcont_QA(nsync, wf4(:,74), wf18(:,256), A(:,1697), n3(:,2725), t3x72(:,:,1697), nhel, den(11))
    call Hcont_QA(nsync, wf4(:,76), wf18(:,256), A(:,1698), n3(:,2726), t3x72(:,:,1698), nhel, den(11))
    call Hcont_QA(nsync, wf12(:,59), wf6(:,321), A(:,1699), n3(:,2727), t3x72(:,:,1699), nhel, den(18))
    call Hcont_QA(nsync, wf12(:,59), wf6(:,322), A(:,1700), n3(:,2728), t3x72(:,:,1700), nhel, den(18))
    call Hcont_QA(nsync, wf4(:,22), wf18(:,257), A(:,1701), n3(:,2729), t3x72(:,:,1701), nhel, den(12))
    call Hcont_QA(nsync, wf4(:,16), wf18(:,201), A(:,1702), n3(:,2730), t3x72(:,:,1702), nhel, den(12))
    call Hcont_VV(nsync, wf9(:,29), wf8(:,49), A(:,1703), n3(:,2731), t3x72(:,:,1703), nhel, den(38))
    call Hcont_VV(nsync, wf9(:,30), wf8(:,50), A(:,1704), n3(:,2732), t3x72(:,:,1704), nhel, den(38))
    call Hcont_QA(nsync, wf12(:,112), wf6(:,306), A(:,1705), n3(:,2733), t3x72(:,:,1705), nhel, den(20))
    call Hcont_QA(nsync, wf12(:,61), wf6(:,207), A(:,1706), n3(:,2734), t3x72(:,:,1706), nhel, den(20))
    call Hcont_QA(nsync, wf4(:,16), wf18(:,258), A(:,1707), n3(:,2735), t3x72(:,:,1707), nhel, den(38))
    call Hcont_QA(nsync, wf4(:,16), wf18(:,259), A(:,1708), n3(:,2736), t3x72(:,:,1708), nhel, den(38))
    call Hcont_QA(nsync, wf12(:,160), wf6(:,324), A(:,1709), n3(:,2737), t3x72(:,:,1709), nhel, den(12))
    call Hcont_QA(nsync, wf12(:,160), wf6(:,326), A(:,1710), n3(:,2738), t3x72(:,:,1710), nhel, den(12))
    call Hcont_QA(nsync, wf12(:,61), wf6(:,321), A(:,1711), n3(:,2739), t3x72(:,:,1711), nhel, den(20))
    call Hcont_QA(nsync, wf12(:,61), wf6(:,322), A(:,1712), n3(:,2740), t3x72(:,:,1712), nhel, den(20))
    call Hcont_QA(nsync, wf12(:,66), wf6(:,214), A(:,1713), n3(:,2741), t3x72(:,:,1713), nhel, den(27))
    call Hcont_QA(nsync, wf12(:,114), wf6(:,308), A(:,1714), n3(:,2742), t3x72(:,:,1714), nhel, den(27))
    call Hcont_VV(nsync, wf9(:,29), wf8(:,51), A(:,1715), n3(:,2743), t3x72(:,:,1715), nhel, den(39))
    call Hcont_VV(nsync, wf9(:,30), wf8(:,52), A(:,1716), n3(:,2744), t3x72(:,:,1716), nhel, den(39))
    call Hcont_QA(nsync, wf12(:,68), wf6(:,214), A(:,1717), n3(:,2745), t3x72(:,:,1717), nhel, den(29))
    call Hcont_QA(nsync, wf12(:,116), wf6(:,308), A(:,1718), n3(:,2746), t3x72(:,:,1718), nhel, den(29))
    call Hcont_QA(nsync, wf4(:,74), wf18(:,260), A(:,1719), n3(:,2747), t3x72(:,:,1719), nhel, den(39))
    call Hcont_QA(nsync, wf4(:,76), wf18(:,260), A(:,1720), n3(:,2748), t3x72(:,:,1720), nhel, den(39))
    call Hcont_QA(nsync, wf12(:,163), wf6(:,324), A(:,1721), n3(:,2749), t3x72(:,:,1721), nhel, den(3))
    call Hcont_QA(nsync, wf12(:,163), wf6(:,326), A(:,1722), n3(:,2750), t3x72(:,:,1722), nhel, den(3))
    call Hcont_QA(nsync, wf4(:,73), wf18(:,262), A(:,1723), n3(:,2751), t3x72(:,:,1723), nhel, den(16))
    call Hcont_QA(nsync, wf4(:,75), wf18(:,262), A(:,1724), n3(:,2752), t3x72(:,:,1724), nhel, den(16))
    call Hcont_QA(nsync, wf4(:,78), wf18(:,263), A(:,1725), n3(:,2753), t3x72(:,:,1725), nhel, den(12))
    call Hcont_QA(nsync, wf4(:,80), wf18(:,263), A(:,1726), n3(:,2754), t3x72(:,:,1726), nhel, den(12))
    call Hcont_QA(nsync, wf12(:,66), wf6(:,327), A(:,1727), n3(:,2755), t3x72(:,:,1727), nhel, den(27))
    call Hcont_QA(nsync, wf12(:,66), wf6(:,328), A(:,1728), n3(:,2756), t3x72(:,:,1728), nhel, den(27))
    call Hcont_QA(nsync, wf4(:,18), wf18(:,264), A(:,1729), n3(:,2757), t3x72(:,:,1729), nhel, den(39))
    call Hcont_QA(nsync, wf4(:,18), wf18(:,265), A(:,1730), n3(:,2758), t3x72(:,:,1730), nhel, den(39))
    call Hcont_QA(nsync, wf12(:,162), wf6(:,330), A(:,1731), n3(:,2759), t3x72(:,:,1731), nhel, den(11))
    call Hcont_QA(nsync, wf12(:,162), wf6(:,332), A(:,1732), n3(:,2760), t3x72(:,:,1732), nhel, den(11))
    call Hcont_QA(nsync, wf12(:,68), wf6(:,327), A(:,1733), n3(:,2761), t3x72(:,:,1733), nhel, den(29))
    call Hcont_QA(nsync, wf12(:,68), wf6(:,328), A(:,1734), n3(:,2762), t3x72(:,:,1734), nhel, den(29))
    call Hcont_QA(nsync, wf4(:,78), wf18(:,266), A(:,1735), n3(:,2763), t3x72(:,:,1735), nhel, den(38))
    call Hcont_QA(nsync, wf4(:,80), wf18(:,266), A(:,1736), n3(:,2764), t3x72(:,:,1736), nhel, den(38))
    call Hcont_QA(nsync, wf12(:,165), wf6(:,330), A(:,1737), n3(:,2765), t3x72(:,:,1737), nhel, den(8))
    call Hcont_QA(nsync, wf12(:,165), wf6(:,332), A(:,1738), n3(:,2766), t3x72(:,:,1738), nhel, den(8))
    call Hcont_QA(nsync, wf4(:,77), wf18(:,268), A(:,1739), n3(:,2767), t3x72(:,:,1739), nhel, den(25))
    call Hcont_QA(nsync, wf4(:,79), wf18(:,268), A(:,1740), n3(:,2768), t3x72(:,:,1740), nhel, den(25))
    call Hcont_QA(nsync, wf12(:,141), wf6(:,192), A(:,1741), n3(:,2769), t3x72(:,:,1741), nhel, den(10))
    call Hcont_QA(nsync, wf12(:,142), wf6(:,190), A(:,1742), n3(:,2770), t3x72(:,:,1742), nhel, den(12))
    call Hcont_VV(nsync, wf8(:,1), wf9(:,31), A(:,1743), n3(:,2771), t3x72(:,:,1743), nhel, den(32))
    call Hcont_VV(nsync, wf8(:,1), wf9(:,32), A(:,1744), n3(:,2772), t3x72(:,:,1744), nhel, den(32))
    call Hcont_VV(nsync, wf8(:,2), wf9(:,31), A(:,1745), n3(:,2773), t3x72(:,:,1745), nhel, den(34))
    call Hcont_VV(nsync, wf8(:,2), wf9(:,32), A(:,1746), n3(:,2774), t3x72(:,:,1746), nhel, den(34))
    call Hcont_QA(nsync, wf6(:,186), wf12(:,145), A(:,1747), n3(:,2775), t3x72(:,:,1747), nhel, den(5))
    call Hcont_QA(nsync, wf6(:,184), wf12(:,146), A(:,1748), n3(:,2776), t3x72(:,:,1748), nhel, den(11))
    call Hcont_VV(nsync, wf8(:,3), wf9(:,31), A(:,1749), n3(:,2777), t3x72(:,:,1749), nhel, den(35))
    call Hcont_VV(nsync, wf8(:,3), wf9(:,32), A(:,1750), n3(:,2778), t3x72(:,:,1750), nhel, den(35))
    call Hcont_VV(nsync, wf8(:,4), wf9(:,31), A(:,1751), n3(:,2779), t3x72(:,:,1751), nhel, den(36))
    call Hcont_VV(nsync, wf8(:,4), wf9(:,32), A(:,1752), n3(:,2780), t3x72(:,:,1752), nhel, den(36))
    call Hcont_QA(nsync, wf6(:,190), wf12(:,147), A(:,1753), n3(:,2781), t3x72(:,:,1753), nhel, den(3))
    call Hcont_QA(nsync, wf6(:,192), wf12(:,148), A(:,1754), n3(:,2782), t3x72(:,:,1754), nhel, den(8))
    call Hcont_QA(nsync, wf18(:,213), wf4(:,74), A(:,1755), n3(:,2783), t3x72(:,:,1755), nhel, den(5))
    call Hcont_QA(nsync, wf18(:,213), wf4(:,76), A(:,1756), n3(:,2784), t3x72(:,:,1756), nhel, den(5))
    call Hcont_QA(nsync, wf12(:,5), wf6(:,333), A(:,1757), n3(:,2785), t3x72(:,:,1757), nhel, den(14))
    call Hcont_QA(nsync, wf12(:,5), wf6(:,334), A(:,1758), n3(:,2786), t3x72(:,:,1758), nhel, den(14))
    call Hcont_QA(nsync, wf12(:,141), wf6(:,312), A(:,1759), n3(:,2787), t3x72(:,:,1759), nhel, den(10))
    call Hcont_QA(nsync, wf12(:,141), wf6(:,314), A(:,1760), n3(:,2788), t3x72(:,:,1760), nhel, den(10))
    call Hcont_VV(nsync, wf9(:,28), wf8(:,53), A(:,1761), n3(:,2789), t3x72(:,:,1761), nhel, den(38))
    call Hcont_VV(nsync, wf9(:,28), wf8(:,54), A(:,1762), n3(:,2790), t3x72(:,:,1762), nhel, den(38))
    call Hcont_QA(nsync, wf12(:,8), wf6(:,333), A(:,1763), n3(:,2791), t3x72(:,:,1763), nhel, den(21))
    call Hcont_QA(nsync, wf12(:,8), wf6(:,334), A(:,1764), n3(:,2792), t3x72(:,:,1764), nhel, den(21))
    call Hcont_QA(nsync, wf12(:,148), wf6(:,312), A(:,1765), n3(:,2793), t3x72(:,:,1765), nhel, den(8))
    call Hcont_QA(nsync, wf12(:,148), wf6(:,314), A(:,1766), n3(:,2794), t3x72(:,:,1766), nhel, den(8))
    call Hcont_QA(nsync, wf18(:,214), wf4(:,74), A(:,1767), n3(:,2795), t3x72(:,:,1767), nhel, den(11))
    call Hcont_QA(nsync, wf18(:,214), wf4(:,76), A(:,1768), n3(:,2796), t3x72(:,:,1768), nhel, den(11))
    call Hcont_QA(nsync, wf18(:,215), wf4(:,74), A(:,1769), n3(:,2797), t3x72(:,:,1769), nhel, den(39))
    call Hcont_QA(nsync, wf18(:,215), wf4(:,76), A(:,1770), n3(:,2798), t3x72(:,:,1770), nhel, den(39))
    call Hcont_QA(nsync, wf18(:,216), wf4(:,74), A(:,1771), n3(:,2799), t3x72(:,:,1771), nhel, den(11))
    call Hcont_QA(nsync, wf18(:,216), wf4(:,76), A(:,1772), n3(:,2800), t3x72(:,:,1772), nhel, den(11))
    call Hcont_QA(nsync, wf12(:,6), wf6(:,335), A(:,1773), n3(:,2801), t3x72(:,:,1773), nhel, den(18))
    call Hcont_QA(nsync, wf12(:,6), wf6(:,336), A(:,1774), n3(:,2802), t3x72(:,:,1774), nhel, den(18))
    call Hcont_QA(nsync, wf12(:,142), wf6(:,324), A(:,1775), n3(:,2803), t3x72(:,:,1775), nhel, den(12))
    call Hcont_QA(nsync, wf12(:,142), wf6(:,326), A(:,1776), n3(:,2804), t3x72(:,:,1776), nhel, den(12))
    call Hcont_VV(nsync, wf9(:,30), wf8(:,53), A(:,1777), n3(:,2805), t3x72(:,:,1777), nhel, den(38))
    call Hcont_VV(nsync, wf9(:,30), wf8(:,54), A(:,1778), n3(:,2806), t3x72(:,:,1778), nhel, den(38))
    call Hcont_QA(nsync, wf12(:,7), wf6(:,335), A(:,1779), n3(:,2807), t3x72(:,:,1779), nhel, den(20))
    call Hcont_QA(nsync, wf12(:,7), wf6(:,336), A(:,1780), n3(:,2808), t3x72(:,:,1780), nhel, den(20))
    call Hcont_QA(nsync, wf12(:,147), wf6(:,324), A(:,1781), n3(:,2809), t3x72(:,:,1781), nhel, den(3))
    call Hcont_QA(nsync, wf12(:,147), wf6(:,326), A(:,1782), n3(:,2810), t3x72(:,:,1782), nhel, den(3))
    call Hcont_QA(nsync, wf18(:,217), wf4(:,74), A(:,1783), n3(:,2811), t3x72(:,:,1783), nhel, den(5))
    call Hcont_QA(nsync, wf18(:,217), wf4(:,76), A(:,1784), n3(:,2812), t3x72(:,:,1784), nhel, den(5))
    call Hcont_QA(nsync, wf18(:,218), wf4(:,74), A(:,1785), n3(:,2813), t3x72(:,:,1785), nhel, den(39))
    call Hcont_QA(nsync, wf18(:,218), wf4(:,76), A(:,1786), n3(:,2814), t3x72(:,:,1786), nhel, den(39))
    call Hcont_QA(nsync, wf18(:,219), wf4(:,78), A(:,1787), n3(:,2815), t3x72(:,:,1787), nhel, den(10))
    call Hcont_QA(nsync, wf18(:,219), wf4(:,80), A(:,1788), n3(:,2816), t3x72(:,:,1788), nhel, den(10))
    call Hcont_QA(nsync, wf12(:,10), wf6(:,337), A(:,1789), n3(:,2817), t3x72(:,:,1789), nhel, den(23))
    call Hcont_QA(nsync, wf12(:,10), wf6(:,338), A(:,1790), n3(:,2818), t3x72(:,:,1790), nhel, den(23))
    call Hcont_QA(nsync, wf12(:,145), wf6(:,318), A(:,1791), n3(:,2819), t3x72(:,:,1791), nhel, den(5))
    call Hcont_QA(nsync, wf12(:,145), wf6(:,320), A(:,1792), n3(:,2820), t3x72(:,:,1792), nhel, den(5))
    call Hcont_VV(nsync, wf9(:,27), wf8(:,55), A(:,1793), n3(:,2821), t3x72(:,:,1793), nhel, den(39))
    call Hcont_VV(nsync, wf9(:,27), wf8(:,56), A(:,1794), n3(:,2822), t3x72(:,:,1794), nhel, den(39))
    call Hcont_QA(nsync, wf12(:,16), wf6(:,337), A(:,1795), n3(:,2823), t3x72(:,:,1795), nhel, den(30))
    call Hcont_QA(nsync, wf12(:,16), wf6(:,338), A(:,1796), n3(:,2824), t3x72(:,:,1796), nhel, den(30))
    call Hcont_QA(nsync, wf12(:,149), wf6(:,318), A(:,1797), n3(:,2825), t3x72(:,:,1797), nhel, den(3))
    call Hcont_QA(nsync, wf12(:,149), wf6(:,320), A(:,1798), n3(:,2826), t3x72(:,:,1798), nhel, den(3))
    call Hcont_QA(nsync, wf18(:,220), wf4(:,78), A(:,1799), n3(:,2827), t3x72(:,:,1799), nhel, den(12))
    call Hcont_QA(nsync, wf18(:,220), wf4(:,80), A(:,1800), n3(:,2828), t3x72(:,:,1800), nhel, den(12))
    call Hcont_QA(nsync, wf18(:,221), wf4(:,78), A(:,1801), n3(:,2829), t3x72(:,:,1801), nhel, den(38))
    call Hcont_QA(nsync, wf18(:,221), wf4(:,80), A(:,1802), n3(:,2830), t3x72(:,:,1802), nhel, den(38))
    call Hcont_QA(nsync, wf18(:,222), wf4(:,78), A(:,1803), n3(:,2831), t3x72(:,:,1803), nhel, den(12))
    call Hcont_QA(nsync, wf18(:,222), wf4(:,80), A(:,1804), n3(:,2832), t3x72(:,:,1804), nhel, den(12))
    call Hcont_QA(nsync, wf12(:,12), wf6(:,339), A(:,1805), n3(:,2833), t3x72(:,:,1805), nhel, den(27))
    call Hcont_QA(nsync, wf12(:,12), wf6(:,340), A(:,1806), n3(:,2834), t3x72(:,:,1806), nhel, den(27))
    call Hcont_QA(nsync, wf12(:,146), wf6(:,330), A(:,1807), n3(:,2835), t3x72(:,:,1807), nhel, den(11))
    call Hcont_QA(nsync, wf12(:,146), wf6(:,332), A(:,1808), n3(:,2836), t3x72(:,:,1808), nhel, den(11))
    call Hcont_VV(nsync, wf9(:,29), wf8(:,55), A(:,1809), n3(:,2837), t3x72(:,:,1809), nhel, den(39))
    call Hcont_VV(nsync, wf9(:,29), wf8(:,56), A(:,1810), n3(:,2838), t3x72(:,:,1810), nhel, den(39))
    call Hcont_QA(nsync, wf12(:,14), wf6(:,339), A(:,1811), n3(:,2839), t3x72(:,:,1811), nhel, den(29))
    call Hcont_QA(nsync, wf12(:,14), wf6(:,340), A(:,1812), n3(:,2840), t3x72(:,:,1812), nhel, den(29))
    call Hcont_QA(nsync, wf12(:,150), wf6(:,330), A(:,1813), n3(:,2841), t3x72(:,:,1813), nhel, den(8))
    call Hcont_QA(nsync, wf12(:,150), wf6(:,332), A(:,1814), n3(:,2842), t3x72(:,:,1814), nhel, den(8))
    call Hcont_QA(nsync, wf18(:,223), wf4(:,78), A(:,1815), n3(:,2843), t3x72(:,:,1815), nhel, den(10))
    call Hcont_QA(nsync, wf18(:,223), wf4(:,80), A(:,1816), n3(:,2844), t3x72(:,:,1816), nhel, den(10))
    call Hcont_QA(nsync, wf18(:,224), wf4(:,78), A(:,1817), n3(:,2845), t3x72(:,:,1817), nhel, den(38))
    call Hcont_QA(nsync, wf18(:,224), wf4(:,80), A(:,1818), n3(:,2846), t3x72(:,:,1818), nhel, den(38))
    call Hcont_QA(nsync, wf6(:,324), wf12(:,167), A(:,1819), n3(:,2847), t3x72(:,:,1819), nhel, den(3))
    call Hcont_QA(nsync, wf6(:,326), wf12(:,167), A(:,1820), n3(:,2848), t3x72(:,:,1820), nhel, den(3))
    call Hcont_QA(nsync, wf6(:,324), wf12(:,168), A(:,1821), n3(:,2849), t3x72(:,:,1821), nhel, den(3))
    call Hcont_QA(nsync, wf6(:,326), wf12(:,168), A(:,1822), n3(:,2850), t3x72(:,:,1822), nhel, den(3))
    call Hcont_QA(nsync, wf4(:,74), wf18(:,269), A(:,1823), n3(:,2851), t3x72(:,:,1823), nhel, den(5))
    call Hcont_QA(nsync, wf4(:,76), wf18(:,269), A(:,1824), n3(:,2852), t3x72(:,:,1824), nhel, den(5))
    call Hcont_QA(nsync, wf4(:,74), wf18(:,270), A(:,1825), n3(:,2853), t3x72(:,:,1825), nhel, den(5))
    call Hcont_QA(nsync, wf4(:,76), wf18(:,270), A(:,1826), n3(:,2854), t3x72(:,:,1826), nhel, den(5))
    call Hcont_QA(nsync, wf6(:,330), wf12(:,169), A(:,1827), n3(:,2855), t3x72(:,:,1827), nhel, den(8))
    call Hcont_QA(nsync, wf6(:,330), wf12(:,170), A(:,1828), n3(:,2856), t3x72(:,:,1828), nhel, den(8))
    call Hcont_QA(nsync, wf6(:,332), wf12(:,169), A(:,1829), n3(:,2857), t3x72(:,:,1829), nhel, den(8))
    call Hcont_QA(nsync, wf6(:,332), wf12(:,170), A(:,1830), n3(:,2858), t3x72(:,:,1830), nhel, den(8))
    call Hcont_QA(nsync, wf4(:,74), wf18(:,271), A(:,1831), n3(:,2859), t3x72(:,:,1831), nhel, den(11))
    call Hcont_QA(nsync, wf4(:,76), wf18(:,271), A(:,1832), n3(:,2860), t3x72(:,:,1832), nhel, den(11))
    call Hcont_QA(nsync, wf4(:,74), wf18(:,272), A(:,1833), n3(:,2861), t3x72(:,:,1833), nhel, den(11))
    call Hcont_QA(nsync, wf4(:,76), wf18(:,272), A(:,1834), n3(:,2862), t3x72(:,:,1834), nhel, den(11))
    call Hcont_QA(nsync, wf4(:,78), wf18(:,273), A(:,1835), n3(:,2863), t3x72(:,:,1835), nhel, den(10))
    call Hcont_QA(nsync, wf4(:,78), wf18(:,274), A(:,1836), n3(:,2864), t3x72(:,:,1836), nhel, den(10))
    call Hcont_QA(nsync, wf4(:,80), wf18(:,273), A(:,1837), n3(:,2865), t3x72(:,:,1837), nhel, den(10))
    call Hcont_QA(nsync, wf4(:,80), wf18(:,274), A(:,1838), n3(:,2866), t3x72(:,:,1838), nhel, den(10))
    call Hcont_QA(nsync, wf4(:,78), wf18(:,275), A(:,1839), n3(:,2867), t3x72(:,:,1839), nhel, den(12))
    call Hcont_QA(nsync, wf4(:,78), wf18(:,276), A(:,1840), n3(:,2868), t3x72(:,:,1840), nhel, den(12))
    call Hcont_QA(nsync, wf4(:,80), wf18(:,275), A(:,1841), n3(:,2869), t3x72(:,:,1841), nhel, den(12))
    call Hcont_QA(nsync, wf4(:,80), wf18(:,276), A(:,1842), n3(:,2870), t3x72(:,:,1842), nhel, den(12))
    call Hcont_VV(nsync, wf24(:,9), wf3(:,21), A(:,1843), n3(:,2871), t3x72(:,:,1843), nhel, den(10))
    call Hcont_VV(nsync, wf24(:,10), wf3(:,22), A(:,1844), n3(:,2872), t3x72(:,:,1844), nhel, den(21))
    call Hcont_VV(nsync, wf24(:,11), wf3(:,21), A(:,1845), n3(:,2873), t3x72(:,:,1845), nhel, den(32))
    call Hcont_VV(nsync, wf24(:,12), wf3(:,22), A(:,1846), n3(:,2874), t3x72(:,:,1846), nhel, den(32))
    call Hcont_VV(nsync, wf24(:,13), wf3(:,21), A(:,1847), n3(:,2875), t3x72(:,:,1847), nhel, den(34))
    call Hcont_VV(nsync, wf24(:,14), wf3(:,22), A(:,1848), n3(:,2876), t3x72(:,:,1848), nhel, den(34))
    call Hcont_VV(nsync, wf24(:,15), wf3(:,23), A(:,1849), n3(:,2877), t3x72(:,:,1849), nhel, den(12))
    call Hcont_VV(nsync, wf24(:,16), wf3(:,24), A(:,1850), n3(:,2878), t3x72(:,:,1850), nhel, den(20))
    call Hcont_VV(nsync, wf24(:,17), wf3(:,23), A(:,1851), n3(:,2879), t3x72(:,:,1851), nhel, den(32))
    call Hcont_VV(nsync, wf24(:,18), wf3(:,24), A(:,1852), n3(:,2880), t3x72(:,:,1852), nhel, den(32))
    call Hcont_VV(nsync, wf24(:,19), wf3(:,23), A(:,1853), n3(:,2881), t3x72(:,:,1853), nhel, den(34))
    call Hcont_VV(nsync, wf24(:,20), wf3(:,24), A(:,1854), n3(:,2882), t3x72(:,:,1854), nhel, den(34))
    call Hcont_VV(nsync, wf24(:,21), wf3(:,22), A(:,1855), n3(:,2883), t3x72(:,:,1855), nhel, den(5))
    call Hcont_VV(nsync, wf24(:,22), wf3(:,21), A(:,1856), n3(:,2884), t3x72(:,:,1856), nhel, den(30))
    call Hcont_VV(nsync, wf24(:,23), wf3(:,21), A(:,1857), n3(:,2885), t3x72(:,:,1857), nhel, den(35))
    call Hcont_VV(nsync, wf24(:,24), wf3(:,22), A(:,1858), n3(:,2886), t3x72(:,:,1858), nhel, den(35))
    call Hcont_VV(nsync, wf24(:,25), wf3(:,21), A(:,1859), n3(:,2887), t3x72(:,:,1859), nhel, den(36))
    call Hcont_VV(nsync, wf24(:,26), wf3(:,22), A(:,1860), n3(:,2888), t3x72(:,:,1860), nhel, den(36))
    call Hcont_VV(nsync, wf24(:,27), wf3(:,24), A(:,1861), n3(:,2889), t3x72(:,:,1861), nhel, den(11))
    call Hcont_VV(nsync, wf24(:,28), wf3(:,23), A(:,1862), n3(:,2890), t3x72(:,:,1862), nhel, den(29))
    call Hcont_VV(nsync, wf24(:,29), wf3(:,23), A(:,1863), n3(:,2891), t3x72(:,:,1863), nhel, den(35))
    call Hcont_VV(nsync, wf24(:,30), wf3(:,24), A(:,1864), n3(:,2892), t3x72(:,:,1864), nhel, den(35))
    call Hcont_VV(nsync, wf24(:,31), wf3(:,23), A(:,1865), n3(:,2893), t3x72(:,:,1865), nhel, den(36))
    call Hcont_VV(nsync, wf24(:,32), wf3(:,24), A(:,1866), n3(:,2894), t3x72(:,:,1866), nhel, den(36))
    call Hcont_QA(nsync, wf12(:,87), wf6(:,229), A(:,1867), n3(:,2895), t3x72(:,:,1867), nhel, den(14))
    call Hcont_QA(nsync, wf12(:,101), wf6(:,230), A(:,1868), n3(:,2896), t3x72(:,:,1868), nhel, den(23))
    call Hcont_QA(nsync, wf12(:,89), wf6(:,231), A(:,1869), n3(:,2897), t3x72(:,:,1869), nhel, den(18))
    call Hcont_QA(nsync, wf12(:,102), wf6(:,232), A(:,1870), n3(:,2898), t3x72(:,:,1870), nhel, den(27))
    call Hcont_VV(nsync, wf24(:,33), wf3(:,21), A(:,1871), n3(:,2899), t3x72(:,:,1871), nhel, den(5))
    call Hcont_VV(nsync, wf3(:,25), wf24(:,85), A(:,1872), n3(:,2900), t3x72(:,:,1872), nhel, den(5))
    call Hcont_VV(nsync, wf3(:,26), wf24(:,85), A(:,1873), n3(:,2901), t3x72(:,:,1873), nhel, den(5))
    call Hcont_VV(nsync, wf3(:,25), wf24(:,86), A(:,1874), n3(:,2902), t3x72(:,:,1874), nhel, den(5))
    call Hcont_VV(nsync, wf3(:,26), wf24(:,86), A(:,1875), n3(:,2903), t3x72(:,:,1875), nhel, den(5))
    call Hcont_VV(nsync, wf24(:,34), wf3(:,21), A(:,1876), n3(:,2904), t3x72(:,:,1876), nhel, den(14))
    call Hcont_VV(nsync, wf3(:,25), wf24(:,87), A(:,1877), n3(:,2905), t3x72(:,:,1877), nhel, den(14))
    call Hcont_VV(nsync, wf3(:,26), wf24(:,87), A(:,1878), n3(:,2906), t3x72(:,:,1878), nhel, den(14))
    call Hcont_VV(nsync, wf3(:,25), wf24(:,88), A(:,1879), n3(:,2907), t3x72(:,:,1879), nhel, den(14))
    call Hcont_VV(nsync, wf3(:,26), wf24(:,88), A(:,1880), n3(:,2908), t3x72(:,:,1880), nhel, den(14))
    call Hcont_QA(nsync, wf36(:,1), wf2(:,47), A(:,1881), n3(:,2909), t3x72(:,:,1881), nhel, den(16))
    call Hcont_QA(nsync, wf36(:,1), wf2(:,48), A(:,1882), n3(:,2910), t3x72(:,:,1882), nhel, den(16))
    call Hcont_QA(nsync, wf36(:,2), wf2(:,47), A(:,1883), n3(:,2911), t3x72(:,:,1883), nhel, den(14))
    call Hcont_QA(nsync, wf36(:,2), wf2(:,48), A(:,1884), n3(:,2912), t3x72(:,:,1884), nhel, den(14))
    call Hcont_VV(nsync, wf24(:,35), wf3(:,21), A(:,1885), n3(:,2913), t3x72(:,:,1885), nhel, den(10))
    call Hcont_VV(nsync, wf3(:,25), wf24(:,89), A(:,1886), n3(:,2914), t3x72(:,:,1886), nhel, den(10))
    call Hcont_VV(nsync, wf3(:,26), wf24(:,89), A(:,1887), n3(:,2915), t3x72(:,:,1887), nhel, den(10))
    call Hcont_VV(nsync, wf3(:,25), wf24(:,90), A(:,1888), n3(:,2916), t3x72(:,:,1888), nhel, den(10))
    call Hcont_VV(nsync, wf3(:,26), wf24(:,90), A(:,1889), n3(:,2917), t3x72(:,:,1889), nhel, den(10))
    call Hcont_VV(nsync, wf24(:,36), wf3(:,21), A(:,1890), n3(:,2918), t3x72(:,:,1890), nhel, den(59))
    call Hcont_VV(nsync, wf24(:,37), wf3(:,21), A(:,1891), n3(:,2919), t3x72(:,:,1891), nhel, den(21))
    call Hcont_VV(nsync, wf3(:,25), wf24(:,91), A(:,1892), n3(:,2920), t3x72(:,:,1892), nhel, den(21))
    call Hcont_VV(nsync, wf3(:,26), wf24(:,91), A(:,1893), n3(:,2921), t3x72(:,:,1893), nhel, den(21))
    call Hcont_VV(nsync, wf3(:,25), wf24(:,92), A(:,1894), n3(:,2922), t3x72(:,:,1894), nhel, den(21))
    call Hcont_VV(nsync, wf3(:,26), wf24(:,92), A(:,1895), n3(:,2923), t3x72(:,:,1895), nhel, den(21))
    call Hcont_QA(nsync, wf36(:,3), wf2(:,47), A(:,1896), n3(:,2924), t3x72(:,:,1896), nhel, den(38))
    call Hcont_QA(nsync, wf36(:,3), wf2(:,48), A(:,1897), n3(:,2925), t3x72(:,:,1897), nhel, den(38))
    call Hcont_QA(nsync, wf36(:,4), wf2(:,47), A(:,1898), n3(:,2926), t3x72(:,:,1898), nhel, den(20))
    call Hcont_QA(nsync, wf36(:,4), wf2(:,48), A(:,1899), n3(:,2927), t3x72(:,:,1899), nhel, den(20))
    call Hcont_QA(nsync, wf36(:,5), wf2(:,47), A(:,1900), n3(:,2928), t3x72(:,:,1900), nhel, den(21))
    call Hcont_QA(nsync, wf36(:,5), wf2(:,48), A(:,1901), n3(:,2929), t3x72(:,:,1901), nhel, den(21))
    call Hcont_QA(nsync, wf12(:,106), wf6(:,230), A(:,1902), n3(:,2930), t3x72(:,:,1902), nhel, den(23))
    call Hcont_QA(nsync, wf12(:,64), wf6(:,233), A(:,1903), n3(:,2931), t3x72(:,:,1903), nhel, den(23))
    call Hcont_QA(nsync, wf12(:,64), wf6(:,234), A(:,1904), n3(:,2932), t3x72(:,:,1904), nhel, den(23))
    call Hcont_QA(nsync, wf12(:,64), wf6(:,235), A(:,1905), n3(:,2933), t3x72(:,:,1905), nhel, den(23))
    call Hcont_QA(nsync, wf12(:,64), wf6(:,236), A(:,1906), n3(:,2934), t3x72(:,:,1906), nhel, den(23))
    call Hcont_QA(nsync, wf12(:,108), wf6(:,230), A(:,1907), n3(:,2935), t3x72(:,:,1907), nhel, den(30))
    call Hcont_QA(nsync, wf12(:,70), wf6(:,233), A(:,1908), n3(:,2936), t3x72(:,:,1908), nhel, den(30))
    call Hcont_QA(nsync, wf12(:,70), wf6(:,234), A(:,1909), n3(:,2937), t3x72(:,:,1909), nhel, den(30))
    call Hcont_QA(nsync, wf12(:,70), wf6(:,235), A(:,1910), n3(:,2938), t3x72(:,:,1910), nhel, den(30))
    call Hcont_QA(nsync, wf12(:,70), wf6(:,236), A(:,1911), n3(:,2939), t3x72(:,:,1911), nhel, den(30))
    call Hcont_VV(nsync, wf8(:,13), wf9(:,33), A(:,1912), n3(:,2940), t3x72(:,:,1912), nhel, den(60))
    call Hcont_QA(nsync, wf12(:,89), wf6(:,341), A(:,1913), n3(:,2941), t3x72(:,:,1913), nhel, den(18))
    call Hcont_QA(nsync, wf12(:,89), wf6(:,342), A(:,1914), n3(:,2942), t3x72(:,:,1914), nhel, den(18))
    call Hcont_QA(nsync, wf18(:,162), wf4(:,81), A(:,1915), n3(:,2943), t3x72(:,:,1915), nhel, den(19))
    call Hcont_QA(nsync, wf18(:,162), wf4(:,82), A(:,1916), n3(:,2944), t3x72(:,:,1916), nhel, den(19))
    call Hcont_QA(nsync, wf18(:,163), wf4(:,81), A(:,1917), n3(:,2945), t3x72(:,:,1917), nhel, den(65))
    call Hcont_QA(nsync, wf18(:,163), wf4(:,82), A(:,1918), n3(:,2946), t3x72(:,:,1918), nhel, den(65))
    call Hcont_VV(nsync, wf24(:,38), wf3(:,23), A(:,1919), n3(:,2947), t3x72(:,:,1919), nhel, den(11))
    call Hcont_VV(nsync, wf3(:,27), wf24(:,93), A(:,1920), n3(:,2948), t3x72(:,:,1920), nhel, den(11))
    call Hcont_VV(nsync, wf3(:,28), wf24(:,93), A(:,1921), n3(:,2949), t3x72(:,:,1921), nhel, den(11))
    call Hcont_VV(nsync, wf3(:,27), wf24(:,94), A(:,1922), n3(:,2950), t3x72(:,:,1922), nhel, den(11))
    call Hcont_VV(nsync, wf3(:,28), wf24(:,94), A(:,1923), n3(:,2951), t3x72(:,:,1923), nhel, den(11))
    call Hcont_VV(nsync, wf24(:,39), wf3(:,23), A(:,1924), n3(:,2952), t3x72(:,:,1924), nhel, den(18))
    call Hcont_VV(nsync, wf3(:,27), wf24(:,95), A(:,1925), n3(:,2953), t3x72(:,:,1925), nhel, den(18))
    call Hcont_VV(nsync, wf3(:,28), wf24(:,95), A(:,1926), n3(:,2954), t3x72(:,:,1926), nhel, den(18))
    call Hcont_VV(nsync, wf3(:,27), wf24(:,96), A(:,1927), n3(:,2955), t3x72(:,:,1927), nhel, den(18))
    call Hcont_VV(nsync, wf3(:,28), wf24(:,96), A(:,1928), n3(:,2956), t3x72(:,:,1928), nhel, den(18))
    call Hcont_QA(nsync, wf36(:,6), wf2(:,47), A(:,1929), n3(:,2957), t3x72(:,:,1929), nhel, den(19))
    call Hcont_QA(nsync, wf36(:,6), wf2(:,48), A(:,1930), n3(:,2958), t3x72(:,:,1930), nhel, den(19))
    call Hcont_QA(nsync, wf36(:,7), wf2(:,47), A(:,1931), n3(:,2959), t3x72(:,:,1931), nhel, den(18))
    call Hcont_QA(nsync, wf36(:,7), wf2(:,48), A(:,1932), n3(:,2960), t3x72(:,:,1932), nhel, den(18))
    call Hcont_VV(nsync, wf24(:,40), wf3(:,23), A(:,1933), n3(:,2961), t3x72(:,:,1933), nhel, den(12))
    call Hcont_VV(nsync, wf3(:,27), wf24(:,97), A(:,1934), n3(:,2962), t3x72(:,:,1934), nhel, den(12))
    call Hcont_VV(nsync, wf3(:,28), wf24(:,97), A(:,1935), n3(:,2963), t3x72(:,:,1935), nhel, den(12))
    call Hcont_VV(nsync, wf3(:,27), wf24(:,98), A(:,1936), n3(:,2964), t3x72(:,:,1936), nhel, den(12))
    call Hcont_VV(nsync, wf3(:,28), wf24(:,98), A(:,1937), n3(:,2965), t3x72(:,:,1937), nhel, den(12))
    call Hcont_VV(nsync, wf24(:,41), wf3(:,23), A(:,1938), n3(:,2966), t3x72(:,:,1938), nhel, den(59))
    call Hcont_VV(nsync, wf24(:,42), wf3(:,23), A(:,1939), n3(:,2967), t3x72(:,:,1939), nhel, den(20))
    call Hcont_VV(nsync, wf3(:,27), wf24(:,99), A(:,1940), n3(:,2968), t3x72(:,:,1940), nhel, den(20))
    call Hcont_VV(nsync, wf3(:,28), wf24(:,99), A(:,1941), n3(:,2969), t3x72(:,:,1941), nhel, den(20))
    call Hcont_VV(nsync, wf3(:,27), wf24(:,100), A(:,1942), n3(:,2970), t3x72(:,:,1942), nhel, den(20))
    call Hcont_VV(nsync, wf3(:,28), wf24(:,100), A(:,1943), n3(:,2971), t3x72(:,:,1943), nhel, den(20))
    call Hcont_QA(nsync, wf36(:,8), wf2(:,47), A(:,1944), n3(:,2972), t3x72(:,:,1944), nhel, den(38))
    call Hcont_QA(nsync, wf36(:,8), wf2(:,48), A(:,1945), n3(:,2973), t3x72(:,:,1945), nhel, den(38))
    call Hcont_QA(nsync, wf36(:,9), wf2(:,47), A(:,1946), n3(:,2974), t3x72(:,:,1946), nhel, den(21))
    call Hcont_QA(nsync, wf36(:,9), wf2(:,48), A(:,1947), n3(:,2975), t3x72(:,:,1947), nhel, den(21))
    call Hcont_QA(nsync, wf36(:,10), wf2(:,47), A(:,1948), n3(:,2976), t3x72(:,:,1948), nhel, den(20))
    call Hcont_QA(nsync, wf36(:,10), wf2(:,48), A(:,1949), n3(:,2977), t3x72(:,:,1949), nhel, den(20))
    call Hcont_QA(nsync, wf12(:,114), wf6(:,232), A(:,1950), n3(:,2978), t3x72(:,:,1950), nhel, den(27))
    call Hcont_QA(nsync, wf12(:,66), wf6(:,239), A(:,1951), n3(:,2979), t3x72(:,:,1951), nhel, den(27))
    call Hcont_QA(nsync, wf12(:,66), wf6(:,240), A(:,1952), n3(:,2980), t3x72(:,:,1952), nhel, den(27))
    call Hcont_QA(nsync, wf12(:,66), wf6(:,241), A(:,1953), n3(:,2981), t3x72(:,:,1953), nhel, den(27))
    call Hcont_QA(nsync, wf12(:,66), wf6(:,242), A(:,1954), n3(:,2982), t3x72(:,:,1954), nhel, den(27))
    call Hcont_QA(nsync, wf12(:,116), wf6(:,232), A(:,1955), n3(:,2983), t3x72(:,:,1955), nhel, den(29))
    call Hcont_QA(nsync, wf12(:,68), wf6(:,239), A(:,1956), n3(:,2984), t3x72(:,:,1956), nhel, den(29))
    call Hcont_QA(nsync, wf12(:,68), wf6(:,240), A(:,1957), n3(:,2985), t3x72(:,:,1957), nhel, den(29))
    call Hcont_QA(nsync, wf12(:,68), wf6(:,241), A(:,1958), n3(:,2986), t3x72(:,:,1958), nhel, den(29))
    call Hcont_QA(nsync, wf12(:,68), wf6(:,242), A(:,1959), n3(:,2987), t3x72(:,:,1959), nhel, den(29))
    call Hcont_VV(nsync, wf8(:,13), wf9(:,34), A(:,1960), n3(:,2988), t3x72(:,:,1960), nhel, den(60))
    call Hcont_QA(nsync, wf12(:,87), wf6(:,343), A(:,1961), n3(:,2989), t3x72(:,:,1961), nhel, den(14))
    call Hcont_QA(nsync, wf12(:,87), wf6(:,344), A(:,1962), n3(:,2990), t3x72(:,:,1962), nhel, den(14))
    call Hcont_QA(nsync, wf18(:,165), wf4(:,81), A(:,1963), n3(:,2991), t3x72(:,:,1963), nhel, den(16))
    call Hcont_QA(nsync, wf18(:,165), wf4(:,82), A(:,1964), n3(:,2992), t3x72(:,:,1964), nhel, den(16))
    call Hcont_QA(nsync, wf18(:,166), wf4(:,81), A(:,1965), n3(:,2993), t3x72(:,:,1965), nhel, den(65))
    call Hcont_QA(nsync, wf18(:,166), wf4(:,82), A(:,1966), n3(:,2994), t3x72(:,:,1966), nhel, den(65))
    call Hcont_VV(nsync, wf24(:,43), wf3(:,22), A(:,1967), n3(:,2995), t3x72(:,:,1967), nhel, den(10))
    call Hcont_VV(nsync, wf3(:,25), wf24(:,101), A(:,1968), n3(:,2996), t3x72(:,:,1968), nhel, den(10))
    call Hcont_VV(nsync, wf3(:,26), wf24(:,101), A(:,1969), n3(:,2997), t3x72(:,:,1969), nhel, den(10))
    call Hcont_VV(nsync, wf3(:,25), wf24(:,102), A(:,1970), n3(:,2998), t3x72(:,:,1970), nhel, den(10))
    call Hcont_VV(nsync, wf3(:,26), wf24(:,102), A(:,1971), n3(:,2999), t3x72(:,:,1971), nhel, den(10))
    call Hcont_VV(nsync, wf24(:,44), wf3(:,22), A(:,1972), n3(:,3000), t3x72(:,:,1972), nhel, den(23))
    call Hcont_VV(nsync, wf3(:,25), wf24(:,103), A(:,1973), n3(:,3001), t3x72(:,:,1973), nhel, den(23))
    call Hcont_VV(nsync, wf3(:,26), wf24(:,103), A(:,1974), n3(:,3002), t3x72(:,:,1974), nhel, den(23))
    call Hcont_VV(nsync, wf3(:,25), wf24(:,104), A(:,1975), n3(:,3003), t3x72(:,:,1975), nhel, den(23))
    call Hcont_VV(nsync, wf3(:,26), wf24(:,104), A(:,1976), n3(:,3004), t3x72(:,:,1976), nhel, den(23))
    call Hcont_QA(nsync, wf36(:,11), wf2(:,49), A(:,1977), n3(:,3005), t3x72(:,:,1977), nhel, den(25))
    call Hcont_QA(nsync, wf36(:,11), wf2(:,50), A(:,1978), n3(:,3006), t3x72(:,:,1978), nhel, den(25))
    call Hcont_QA(nsync, wf36(:,12), wf2(:,49), A(:,1979), n3(:,3007), t3x72(:,:,1979), nhel, den(23))
    call Hcont_QA(nsync, wf36(:,12), wf2(:,50), A(:,1980), n3(:,3008), t3x72(:,:,1980), nhel, den(23))
    call Hcont_VV(nsync, wf24(:,45), wf3(:,22), A(:,1981), n3(:,3009), t3x72(:,:,1981), nhel, den(5))
    call Hcont_VV(nsync, wf3(:,25), wf24(:,105), A(:,1982), n3(:,3010), t3x72(:,:,1982), nhel, den(5))
    call Hcont_VV(nsync, wf3(:,26), wf24(:,105), A(:,1983), n3(:,3011), t3x72(:,:,1983), nhel, den(5))
    call Hcont_VV(nsync, wf3(:,25), wf24(:,106), A(:,1984), n3(:,3012), t3x72(:,:,1984), nhel, den(5))
    call Hcont_VV(nsync, wf3(:,26), wf24(:,106), A(:,1985), n3(:,3013), t3x72(:,:,1985), nhel, den(5))
    call Hcont_VV(nsync, wf24(:,46), wf3(:,22), A(:,1986), n3(:,3014), t3x72(:,:,1986), nhel, den(60))
    call Hcont_VV(nsync, wf24(:,47), wf3(:,22), A(:,1987), n3(:,3015), t3x72(:,:,1987), nhel, den(30))
    call Hcont_VV(nsync, wf3(:,25), wf24(:,107), A(:,1988), n3(:,3016), t3x72(:,:,1988), nhel, den(30))
    call Hcont_VV(nsync, wf3(:,26), wf24(:,107), A(:,1989), n3(:,3017), t3x72(:,:,1989), nhel, den(30))
    call Hcont_VV(nsync, wf3(:,25), wf24(:,108), A(:,1990), n3(:,3018), t3x72(:,:,1990), nhel, den(30))
    call Hcont_VV(nsync, wf3(:,26), wf24(:,108), A(:,1991), n3(:,3019), t3x72(:,:,1991), nhel, den(30))
    call Hcont_QA(nsync, wf36(:,13), wf2(:,49), A(:,1992), n3(:,3020), t3x72(:,:,1992), nhel, den(39))
    call Hcont_QA(nsync, wf36(:,13), wf2(:,50), A(:,1993), n3(:,3021), t3x72(:,:,1993), nhel, den(39))
    call Hcont_QA(nsync, wf36(:,14), wf2(:,49), A(:,1994), n3(:,3022), t3x72(:,:,1994), nhel, den(29))
    call Hcont_QA(nsync, wf36(:,14), wf2(:,50), A(:,1995), n3(:,3023), t3x72(:,:,1995), nhel, den(29))
    call Hcont_QA(nsync, wf36(:,15), wf2(:,49), A(:,1996), n3(:,3024), t3x72(:,:,1996), nhel, den(30))
    call Hcont_QA(nsync, wf36(:,15), wf2(:,50), A(:,1997), n3(:,3025), t3x72(:,:,1997), nhel, den(30))
    call Hcont_QA(nsync, wf12(:,103), wf6(:,229), A(:,1998), n3(:,3026), t3x72(:,:,1998), nhel, den(14))
    call Hcont_QA(nsync, wf12(:,57), wf6(:,245), A(:,1999), n3(:,3027), t3x72(:,:,1999), nhel, den(14))
    call Hcont_QA(nsync, wf12(:,57), wf6(:,246), A(:,2000), n3(:,3028), t3x72(:,:,2000), nhel, den(14))
    call Hcont_QA(nsync, wf12(:,57), wf6(:,247), A(:,2001), n3(:,3029), t3x72(:,:,2001), nhel, den(14))
    call Hcont_QA(nsync, wf12(:,57), wf6(:,248), A(:,2002), n3(:,3030), t3x72(:,:,2002), nhel, den(14))
    call Hcont_QA(nsync, wf12(:,105), wf6(:,229), A(:,2003), n3(:,3031), t3x72(:,:,2003), nhel, den(21))
    call Hcont_QA(nsync, wf12(:,63), wf6(:,245), A(:,2004), n3(:,3032), t3x72(:,:,2004), nhel, den(21))
    call Hcont_QA(nsync, wf12(:,63), wf6(:,246), A(:,2005), n3(:,3033), t3x72(:,:,2005), nhel, den(21))
    call Hcont_QA(nsync, wf12(:,63), wf6(:,247), A(:,2006), n3(:,3034), t3x72(:,:,2006), nhel, den(21))
    call Hcont_QA(nsync, wf12(:,63), wf6(:,248), A(:,2007), n3(:,3035), t3x72(:,:,2007), nhel, den(21))
    call Hcont_VV(nsync, wf8(:,16), wf9(:,35), A(:,2008), n3(:,3036), t3x72(:,:,2008), nhel, den(59))
    call Hcont_QA(nsync, wf12(:,102), wf6(:,345), A(:,2009), n3(:,3037), t3x72(:,:,2009), nhel, den(27))
    call Hcont_QA(nsync, wf12(:,102), wf6(:,346), A(:,2010), n3(:,3038), t3x72(:,:,2010), nhel, den(27))
    call Hcont_QA(nsync, wf18(:,168), wf4(:,83), A(:,2011), n3(:,3039), t3x72(:,:,2011), nhel, den(28))
    call Hcont_QA(nsync, wf18(:,168), wf4(:,84), A(:,2012), n3(:,3040), t3x72(:,:,2012), nhel, den(28))
    call Hcont_QA(nsync, wf18(:,169), wf4(:,83), A(:,2013), n3(:,3041), t3x72(:,:,2013), nhel, den(66))
    call Hcont_QA(nsync, wf18(:,169), wf4(:,84), A(:,2014), n3(:,3042), t3x72(:,:,2014), nhel, den(66))
    call Hcont_VV(nsync, wf24(:,48), wf3(:,24), A(:,2015), n3(:,3043), t3x72(:,:,2015), nhel, den(12))
    call Hcont_VV(nsync, wf3(:,27), wf24(:,109), A(:,2016), n3(:,3044), t3x72(:,:,2016), nhel, den(12))
    call Hcont_VV(nsync, wf3(:,28), wf24(:,109), A(:,2017), n3(:,3045), t3x72(:,:,2017), nhel, den(12))
    call Hcont_VV(nsync, wf3(:,27), wf24(:,110), A(:,2018), n3(:,3046), t3x72(:,:,2018), nhel, den(12))
    call Hcont_VV(nsync, wf3(:,28), wf24(:,110), A(:,2019), n3(:,3047), t3x72(:,:,2019), nhel, den(12))
    call Hcont_VV(nsync, wf24(:,49), wf3(:,24), A(:,2020), n3(:,3048), t3x72(:,:,2020), nhel, den(27))
    call Hcont_VV(nsync, wf3(:,27), wf24(:,111), A(:,2021), n3(:,3049), t3x72(:,:,2021), nhel, den(27))
    call Hcont_VV(nsync, wf3(:,28), wf24(:,111), A(:,2022), n3(:,3050), t3x72(:,:,2022), nhel, den(27))
    call Hcont_VV(nsync, wf3(:,27), wf24(:,112), A(:,2023), n3(:,3051), t3x72(:,:,2023), nhel, den(27))
    call Hcont_VV(nsync, wf3(:,28), wf24(:,112), A(:,2024), n3(:,3052), t3x72(:,:,2024), nhel, den(27))
    call Hcont_QA(nsync, wf36(:,16), wf2(:,49), A(:,2025), n3(:,3053), t3x72(:,:,2025), nhel, den(28))
    call Hcont_QA(nsync, wf36(:,16), wf2(:,50), A(:,2026), n3(:,3054), t3x72(:,:,2026), nhel, den(28))
    call Hcont_QA(nsync, wf36(:,17), wf2(:,49), A(:,2027), n3(:,3055), t3x72(:,:,2027), nhel, den(27))
    call Hcont_QA(nsync, wf36(:,17), wf2(:,50), A(:,2028), n3(:,3056), t3x72(:,:,2028), nhel, den(27))
    call Hcont_VV(nsync, wf24(:,50), wf3(:,24), A(:,2029), n3(:,3057), t3x72(:,:,2029), nhel, den(11))
    call Hcont_VV(nsync, wf3(:,27), wf24(:,113), A(:,2030), n3(:,3058), t3x72(:,:,2030), nhel, den(11))
    call Hcont_VV(nsync, wf3(:,28), wf24(:,113), A(:,2031), n3(:,3059), t3x72(:,:,2031), nhel, den(11))
    call Hcont_VV(nsync, wf3(:,27), wf24(:,114), A(:,2032), n3(:,3060), t3x72(:,:,2032), nhel, den(11))
    call Hcont_VV(nsync, wf3(:,28), wf24(:,114), A(:,2033), n3(:,3061), t3x72(:,:,2033), nhel, den(11))
    call Hcont_VV(nsync, wf24(:,51), wf3(:,24), A(:,2034), n3(:,3062), t3x72(:,:,2034), nhel, den(60))
    call Hcont_VV(nsync, wf24(:,52), wf3(:,24), A(:,2035), n3(:,3063), t3x72(:,:,2035), nhel, den(29))
    call Hcont_VV(nsync, wf3(:,27), wf24(:,115), A(:,2036), n3(:,3064), t3x72(:,:,2036), nhel, den(29))
    call Hcont_VV(nsync, wf3(:,28), wf24(:,115), A(:,2037), n3(:,3065), t3x72(:,:,2037), nhel, den(29))
    call Hcont_VV(nsync, wf3(:,27), wf24(:,116), A(:,2038), n3(:,3066), t3x72(:,:,2038), nhel, den(29))
    call Hcont_VV(nsync, wf3(:,28), wf24(:,116), A(:,2039), n3(:,3067), t3x72(:,:,2039), nhel, den(29))
    call Hcont_QA(nsync, wf36(:,18), wf2(:,49), A(:,2040), n3(:,3068), t3x72(:,:,2040), nhel, den(39))
    call Hcont_QA(nsync, wf36(:,18), wf2(:,50), A(:,2041), n3(:,3069), t3x72(:,:,2041), nhel, den(39))
    call Hcont_QA(nsync, wf36(:,19), wf2(:,49), A(:,2042), n3(:,3070), t3x72(:,:,2042), nhel, den(30))
    call Hcont_QA(nsync, wf36(:,19), wf2(:,50), A(:,2043), n3(:,3071), t3x72(:,:,2043), nhel, den(30))
    call Hcont_QA(nsync, wf36(:,20), wf2(:,49), A(:,2044), n3(:,3072), t3x72(:,:,2044), nhel, den(29))
    call Hcont_QA(nsync, wf36(:,20), wf2(:,50), A(:,2045), n3(:,3073), t3x72(:,:,2045), nhel, den(29))
    call Hcont_QA(nsync, wf12(:,110), wf6(:,231), A(:,2046), n3(:,3074), t3x72(:,:,2046), nhel, den(18))
    call Hcont_QA(nsync, wf12(:,59), wf6(:,251), A(:,2047), n3(:,3075), t3x72(:,:,2047), nhel, den(18))
    call Hcont_QA(nsync, wf12(:,59), wf6(:,252), A(:,2048), n3(:,3076), t3x72(:,:,2048), nhel, den(18))
    call Hcont_QA(nsync, wf12(:,59), wf6(:,253), A(:,2049), n3(:,3077), t3x72(:,:,2049), nhel, den(18))
    call Hcont_QA(nsync, wf12(:,59), wf6(:,254), A(:,2050), n3(:,3078), t3x72(:,:,2050), nhel, den(18))
    call Hcont_QA(nsync, wf12(:,112), wf6(:,231), A(:,2051), n3(:,3079), t3x72(:,:,2051), nhel, den(20))
    call Hcont_QA(nsync, wf12(:,61), wf6(:,251), A(:,2052), n3(:,3080), t3x72(:,:,2052), nhel, den(20))
    call Hcont_QA(nsync, wf12(:,61), wf6(:,252), A(:,2053), n3(:,3081), t3x72(:,:,2053), nhel, den(20))
    call Hcont_QA(nsync, wf12(:,61), wf6(:,253), A(:,2054), n3(:,3082), t3x72(:,:,2054), nhel, den(20))
    call Hcont_QA(nsync, wf12(:,61), wf6(:,254), A(:,2055), n3(:,3083), t3x72(:,:,2055), nhel, den(20))
    call Hcont_VV(nsync, wf8(:,16), wf9(:,36), A(:,2056), n3(:,3084), t3x72(:,:,2056), nhel, den(59))
    call Hcont_QA(nsync, wf12(:,101), wf6(:,347), A(:,2057), n3(:,3085), t3x72(:,:,2057), nhel, den(23))
    call Hcont_QA(nsync, wf12(:,101), wf6(:,348), A(:,2058), n3(:,3086), t3x72(:,:,2058), nhel, den(23))
    call Hcont_QA(nsync, wf18(:,171), wf4(:,83), A(:,2059), n3(:,3087), t3x72(:,:,2059), nhel, den(25))
    call Hcont_QA(nsync, wf18(:,171), wf4(:,84), A(:,2060), n3(:,3088), t3x72(:,:,2060), nhel, den(25))
    call Hcont_QA(nsync, wf18(:,172), wf4(:,83), A(:,2061), n3(:,3089), t3x72(:,:,2061), nhel, den(66))
    call Hcont_QA(nsync, wf18(:,172), wf4(:,84), A(:,2062), n3(:,3090), t3x72(:,:,2062), nhel, den(66))
    call Hcont_QA(nsync, wf12(:,103), wf6(:,343), A(:,2063), n3(:,3091), t3x72(:,:,2063), nhel, den(14))
    call Hcont_QA(nsync, wf12(:,103), wf6(:,344), A(:,2064), n3(:,3092), t3x72(:,:,2064), nhel, den(14))
    call Hcont_QA(nsync, wf12(:,57), wf6(:,349), A(:,2065), n3(:,3093), t3x72(:,:,2065), nhel, den(14))
    call Hcont_QA(nsync, wf12(:,57), wf6(:,350), A(:,2066), n3(:,3094), t3x72(:,:,2066), nhel, den(14))
    call Hcont_QA(nsync, wf18(:,173), wf4(:,81), A(:,2067), n3(:,3095), t3x72(:,:,2067), nhel, den(16))
    call Hcont_QA(nsync, wf18(:,173), wf4(:,82), A(:,2068), n3(:,3096), t3x72(:,:,2068), nhel, den(16))
    call Hcont_QA(nsync, wf18(:,49), wf4(:,85), A(:,2069), n3(:,3097), t3x72(:,:,2069), nhel, den(16))
    call Hcont_QA(nsync, wf18(:,49), wf4(:,86), A(:,2070), n3(:,3098), t3x72(:,:,2070), nhel, den(16))
    call Hcont_QA(nsync, wf12(:,110), wf6(:,341), A(:,2071), n3(:,3099), t3x72(:,:,2071), nhel, den(18))
    call Hcont_QA(nsync, wf12(:,110), wf6(:,342), A(:,2072), n3(:,3100), t3x72(:,:,2072), nhel, den(18))
    call Hcont_QA(nsync, wf12(:,59), wf6(:,351), A(:,2073), n3(:,3101), t3x72(:,:,2073), nhel, den(18))
    call Hcont_QA(nsync, wf12(:,59), wf6(:,352), A(:,2074), n3(:,3102), t3x72(:,:,2074), nhel, den(18))
    call Hcont_QA(nsync, wf18(:,174), wf4(:,81), A(:,2075), n3(:,3103), t3x72(:,:,2075), nhel, den(19))
    call Hcont_QA(nsync, wf18(:,174), wf4(:,82), A(:,2076), n3(:,3104), t3x72(:,:,2076), nhel, den(19))
    call Hcont_QA(nsync, wf18(:,50), wf4(:,85), A(:,2077), n3(:,3105), t3x72(:,:,2077), nhel, den(19))
    call Hcont_QA(nsync, wf18(:,50), wf4(:,86), A(:,2078), n3(:,3106), t3x72(:,:,2078), nhel, den(19))
    call Hcont_QA(nsync, wf12(:,112), wf6(:,341), A(:,2079), n3(:,3107), t3x72(:,:,2079), nhel, den(20))
    call Hcont_QA(nsync, wf12(:,112), wf6(:,342), A(:,2080), n3(:,3108), t3x72(:,:,2080), nhel, den(20))
    call Hcont_QA(nsync, wf12(:,61), wf6(:,351), A(:,2081), n3(:,3109), t3x72(:,:,2081), nhel, den(20))
    call Hcont_QA(nsync, wf12(:,61), wf6(:,352), A(:,2082), n3(:,3110), t3x72(:,:,2082), nhel, den(20))
    call Hcont_QA(nsync, wf12(:,105), wf6(:,343), A(:,2083), n3(:,3111), t3x72(:,:,2083), nhel, den(21))
    call Hcont_QA(nsync, wf12(:,105), wf6(:,344), A(:,2084), n3(:,3112), t3x72(:,:,2084), nhel, den(21))
    call Hcont_QA(nsync, wf12(:,63), wf6(:,349), A(:,2085), n3(:,3113), t3x72(:,:,2085), nhel, den(21))
    call Hcont_QA(nsync, wf12(:,63), wf6(:,350), A(:,2086), n3(:,3114), t3x72(:,:,2086), nhel, den(21))
    call Hcont_QA(nsync, wf12(:,106), wf6(:,347), A(:,2087), n3(:,3115), t3x72(:,:,2087), nhel, den(23))
    call Hcont_QA(nsync, wf12(:,64), wf6(:,353), A(:,2088), n3(:,3116), t3x72(:,:,2088), nhel, den(23))
    call Hcont_QA(nsync, wf12(:,106), wf6(:,348), A(:,2089), n3(:,3117), t3x72(:,:,2089), nhel, den(23))
    call Hcont_QA(nsync, wf12(:,64), wf6(:,354), A(:,2090), n3(:,3118), t3x72(:,:,2090), nhel, den(23))
    call Hcont_QA(nsync, wf18(:,175), wf4(:,83), A(:,2091), n3(:,3119), t3x72(:,:,2091), nhel, den(25))
    call Hcont_QA(nsync, wf18(:,51), wf4(:,87), A(:,2092), n3(:,3120), t3x72(:,:,2092), nhel, den(25))
    call Hcont_QA(nsync, wf18(:,175), wf4(:,84), A(:,2093), n3(:,3121), t3x72(:,:,2093), nhel, den(25))
    call Hcont_QA(nsync, wf18(:,51), wf4(:,88), A(:,2094), n3(:,3122), t3x72(:,:,2094), nhel, den(25))
    call Hcont_QA(nsync, wf12(:,114), wf6(:,345), A(:,2095), n3(:,3123), t3x72(:,:,2095), nhel, den(27))
    call Hcont_QA(nsync, wf12(:,66), wf6(:,355), A(:,2096), n3(:,3124), t3x72(:,:,2096), nhel, den(27))
    call Hcont_QA(nsync, wf12(:,114), wf6(:,346), A(:,2097), n3(:,3125), t3x72(:,:,2097), nhel, den(27))
    call Hcont_QA(nsync, wf12(:,66), wf6(:,356), A(:,2098), n3(:,3126), t3x72(:,:,2098), nhel, den(27))
    call Hcont_QA(nsync, wf18(:,176), wf4(:,83), A(:,2099), n3(:,3127), t3x72(:,:,2099), nhel, den(28))
    call Hcont_QA(nsync, wf18(:,52), wf4(:,87), A(:,2100), n3(:,3128), t3x72(:,:,2100), nhel, den(28))
    call Hcont_QA(nsync, wf18(:,176), wf4(:,84), A(:,2101), n3(:,3129), t3x72(:,:,2101), nhel, den(28))
    call Hcont_QA(nsync, wf18(:,52), wf4(:,88), A(:,2102), n3(:,3130), t3x72(:,:,2102), nhel, den(28))
    call Hcont_QA(nsync, wf12(:,116), wf6(:,345), A(:,2103), n3(:,3131), t3x72(:,:,2103), nhel, den(29))
    call Hcont_QA(nsync, wf12(:,68), wf6(:,355), A(:,2104), n3(:,3132), t3x72(:,:,2104), nhel, den(29))
    call Hcont_QA(nsync, wf12(:,116), wf6(:,346), A(:,2105), n3(:,3133), t3x72(:,:,2105), nhel, den(29))
    call Hcont_QA(nsync, wf12(:,68), wf6(:,356), A(:,2106), n3(:,3134), t3x72(:,:,2106), nhel, den(29))
    call Hcont_QA(nsync, wf12(:,108), wf6(:,347), A(:,2107), n3(:,3135), t3x72(:,:,2107), nhel, den(30))
    call Hcont_QA(nsync, wf12(:,70), wf6(:,353), A(:,2108), n3(:,3136), t3x72(:,:,2108), nhel, den(30))
    call Hcont_QA(nsync, wf12(:,108), wf6(:,348), A(:,2109), n3(:,3137), t3x72(:,:,2109), nhel, den(30))
    call Hcont_QA(nsync, wf12(:,70), wf6(:,354), A(:,2110), n3(:,3138), t3x72(:,:,2110), nhel, den(30))
    call Hcont_QA(nsync, wf18(:,167), wf4(:,45), A(:,2111), n3(:,3139), t3x72(:,:,2111), nhel, den(25))
    call Hcont_QA(nsync, wf18(:,167), wf4(:,47), A(:,2112), n3(:,3140), t3x72(:,:,2112), nhel, den(25))
    call Hcont_QA(nsync, wf12(:,10), wf6(:,201), A(:,2113), n3(:,3141), t3x72(:,:,2113), nhel, den(23))
    call Hcont_QA(nsync, wf12(:,10), wf6(:,202), A(:,2114), n3(:,3142), t3x72(:,:,2114), nhel, den(23))
    call Hcont_QA(nsync, wf4(:,22), wf18(:,219), A(:,2115), n3(:,3143), t3x72(:,:,2115), nhel, den(10))
    call Hcont_QA(nsync, wf4(:,12), wf18(:,153), A(:,2116), n3(:,3144), t3x72(:,:,2116), nhel, den(10))
    call Hcont_QA(nsync, wf4(:,12), wf18(:,133), A(:,2117), n3(:,3145), t3x72(:,:,2117), nhel, den(10))
    call Hcont_QA(nsync, wf4(:,12), wf18(:,154), A(:,2118), n3(:,3146), t3x72(:,:,2118), nhel, den(10))
    call Hcont_QA(nsync, wf4(:,12), wf18(:,134), A(:,2119), n3(:,3147), t3x72(:,:,2119), nhel, den(10))
    call Hcont_QA(nsync, wf12(:,10), wf6(:,200), A(:,2120), n3(:,3148), t3x72(:,:,2120), nhel, den(23))
    call Hcont_QA(nsync, wf12(:,10), wf6(:,357), A(:,2121), n3(:,3149), t3x72(:,:,2121), nhel, den(23))
    call Hcont_QA(nsync, wf12(:,10), wf6(:,358), A(:,2122), n3(:,3150), t3x72(:,:,2122), nhel, den(23))
    call Hcont_QA(nsync, wf12(:,10), wf6(:,359), A(:,2123), n3(:,3151), t3x72(:,:,2123), nhel, den(23))
    call Hcont_QA(nsync, wf12(:,10), wf6(:,360), A(:,2124), n3(:,3152), t3x72(:,:,2124), nhel, den(23))
    call Hcont_VV(nsync, wf9(:,5), wf8(:,35), A(:,2125), n3(:,3153), t3x72(:,:,2125), nhel, den(39))
    call Hcont_VV(nsync, wf9(:,5), wf8(:,36), A(:,2126), n3(:,3154), t3x72(:,:,2126), nhel, den(39))
    call Hcont_QA(nsync, wf12(:,100), wf6(:,203), A(:,2127), n3(:,3155), t3x72(:,:,2127), nhel, den(29))
    call Hcont_QA(nsync, wf12(:,100), wf6(:,205), A(:,2128), n3(:,3156), t3x72(:,:,2128), nhel, den(29))
    call Hcont_QA(nsync, wf12(:,16), wf6(:,201), A(:,2129), n3(:,3157), t3x72(:,:,2129), nhel, den(30))
    call Hcont_QA(nsync, wf12(:,16), wf6(:,202), A(:,2130), n3(:,3158), t3x72(:,:,2130), nhel, den(30))
    call Hcont_QA(nsync, wf6(:,65), wf12(:,145), A(:,2131), n3(:,3159), t3x72(:,:,2131), nhel, den(5))
    call Hcont_QA(nsync, wf6(:,43), wf12(:,91), A(:,2132), n3(:,3160), t3x72(:,:,2132), nhel, den(5))
    call Hcont_QA(nsync, wf6(:,43), wf12(:,92), A(:,2133), n3(:,3161), t3x72(:,:,2133), nhel, den(5))
    call Hcont_QA(nsync, wf6(:,43), wf12(:,93), A(:,2134), n3(:,3162), t3x72(:,:,2134), nhel, den(5))
    call Hcont_QA(nsync, wf6(:,43), wf12(:,94), A(:,2135), n3(:,3163), t3x72(:,:,2135), nhel, den(5))
    call Hcont_VV(nsync, wf8(:,6), wf9(:,27), A(:,2136), n3(:,3164), t3x72(:,:,2136), nhel, den(60))
    call Hcont_QA(nsync, wf12(:,16), wf6(:,200), A(:,2137), n3(:,3165), t3x72(:,:,2137), nhel, den(30))
    call Hcont_QA(nsync, wf12(:,16), wf6(:,357), A(:,2138), n3(:,3166), t3x72(:,:,2138), nhel, den(30))
    call Hcont_QA(nsync, wf12(:,16), wf6(:,358), A(:,2139), n3(:,3167), t3x72(:,:,2139), nhel, den(30))
    call Hcont_QA(nsync, wf12(:,16), wf6(:,359), A(:,2140), n3(:,3168), t3x72(:,:,2140), nhel, den(30))
    call Hcont_QA(nsync, wf12(:,16), wf6(:,360), A(:,2141), n3(:,3169), t3x72(:,:,2141), nhel, den(30))
    call Hcont_QA(nsync, wf12(:,26), wf6(:,204), A(:,2142), n3(:,3170), t3x72(:,:,2142), nhel, den(3))
    call Hcont_QA(nsync, wf12(:,26), wf6(:,206), A(:,2143), n3(:,3171), t3x72(:,:,2143), nhel, den(3))
    call Hcont_QA(nsync, wf18(:,168), wf4(:,45), A(:,2144), n3(:,3172), t3x72(:,:,2144), nhel, den(28))
    call Hcont_QA(nsync, wf18(:,168), wf4(:,47), A(:,2145), n3(:,3173), t3x72(:,:,2145), nhel, den(28))
    call Hcont_QA(nsync, wf18(:,169), wf4(:,45), A(:,2146), n3(:,3174), t3x72(:,:,2146), nhel, den(66))
    call Hcont_QA(nsync, wf18(:,169), wf4(:,47), A(:,2147), n3(:,3175), t3x72(:,:,2147), nhel, den(66))
    call Hcont_QA(nsync, wf12(:,30), wf6(:,190), A(:,2148), n3(:,3176), t3x72(:,:,2148), nhel, den(3))
    call Hcont_QA(nsync, wf12(:,18), wf6(:,133), A(:,2149), n3(:,3177), t3x72(:,:,2149), nhel, den(3))
    call Hcont_QA(nsync, wf12(:,18), wf6(:,134), A(:,2150), n3(:,3178), t3x72(:,:,2150), nhel, den(3))
    call Hcont_QA(nsync, wf12(:,18), wf6(:,135), A(:,2151), n3(:,3179), t3x72(:,:,2151), nhel, den(3))
    call Hcont_QA(nsync, wf12(:,18), wf6(:,136), A(:,2152), n3(:,3180), t3x72(:,:,2152), nhel, den(3))
    call Hcont_QA(nsync, wf12(:,104), wf6(:,190), A(:,2153), n3(:,3181), t3x72(:,:,2153), nhel, den(12))
    call Hcont_QA(nsync, wf12(:,46), wf6(:,133), A(:,2154), n3(:,3182), t3x72(:,:,2154), nhel, den(12))
    call Hcont_QA(nsync, wf12(:,46), wf6(:,134), A(:,2155), n3(:,3183), t3x72(:,:,2155), nhel, den(12))
    call Hcont_QA(nsync, wf12(:,46), wf6(:,135), A(:,2156), n3(:,3184), t3x72(:,:,2156), nhel, den(12))
    call Hcont_QA(nsync, wf12(:,46), wf6(:,136), A(:,2157), n3(:,3185), t3x72(:,:,2157), nhel, den(12))
    call Hcont_VV(nsync, wf8(:,16), wf9(:,27), A(:,2158), n3(:,3186), t3x72(:,:,2158), nhel, den(59))
    call Hcont_QA(nsync, wf18(:,170), wf4(:,45), A(:,2159), n3(:,3187), t3x72(:,:,2159), nhel, den(28))
    call Hcont_QA(nsync, wf18(:,170), wf4(:,47), A(:,2160), n3(:,3188), t3x72(:,:,2160), nhel, den(28))
    call Hcont_QA(nsync, wf12(:,12), wf6(:,215), A(:,2161), n3(:,3189), t3x72(:,:,2161), nhel, den(27))
    call Hcont_QA(nsync, wf12(:,12), wf6(:,216), A(:,2162), n3(:,3190), t3x72(:,:,2162), nhel, den(27))
    call Hcont_QA(nsync, wf4(:,22), wf18(:,222), A(:,2163), n3(:,3191), t3x72(:,:,2163), nhel, den(12))
    call Hcont_QA(nsync, wf4(:,12), wf18(:,157), A(:,2164), n3(:,3192), t3x72(:,:,2164), nhel, den(12))
    call Hcont_QA(nsync, wf4(:,12), wf18(:,137), A(:,2165), n3(:,3193), t3x72(:,:,2165), nhel, den(12))
    call Hcont_QA(nsync, wf4(:,12), wf18(:,158), A(:,2166), n3(:,3194), t3x72(:,:,2166), nhel, den(12))
    call Hcont_QA(nsync, wf4(:,12), wf18(:,138), A(:,2167), n3(:,3195), t3x72(:,:,2167), nhel, den(12))
    call Hcont_QA(nsync, wf12(:,12), wf6(:,214), A(:,2168), n3(:,3196), t3x72(:,:,2168), nhel, den(27))
    call Hcont_QA(nsync, wf12(:,12), wf6(:,361), A(:,2169), n3(:,3197), t3x72(:,:,2169), nhel, den(27))
    call Hcont_QA(nsync, wf12(:,12), wf6(:,362), A(:,2170), n3(:,3198), t3x72(:,:,2170), nhel, den(27))
    call Hcont_QA(nsync, wf12(:,12), wf6(:,363), A(:,2171), n3(:,3199), t3x72(:,:,2171), nhel, den(27))
    call Hcont_QA(nsync, wf12(:,12), wf6(:,364), A(:,2172), n3(:,3200), t3x72(:,:,2172), nhel, den(27))
    call Hcont_VV(nsync, wf9(:,6), wf8(:,35), A(:,2173), n3(:,3201), t3x72(:,:,2173), nhel, den(39))
    call Hcont_VV(nsync, wf9(:,6), wf8(:,36), A(:,2174), n3(:,3202), t3x72(:,:,2174), nhel, den(39))
    call Hcont_QA(nsync, wf12(:,95), wf6(:,217), A(:,2175), n3(:,3203), t3x72(:,:,2175), nhel, den(30))
    call Hcont_QA(nsync, wf12(:,95), wf6(:,219), A(:,2176), n3(:,3204), t3x72(:,:,2176), nhel, den(30))
    call Hcont_QA(nsync, wf12(:,14), wf6(:,215), A(:,2177), n3(:,3205), t3x72(:,:,2177), nhel, den(29))
    call Hcont_QA(nsync, wf12(:,14), wf6(:,216), A(:,2178), n3(:,3206), t3x72(:,:,2178), nhel, den(29))
    call Hcont_QA(nsync, wf6(:,70), wf12(:,146), A(:,2179), n3(:,3207), t3x72(:,:,2179), nhel, den(11))
    call Hcont_QA(nsync, wf6(:,40), wf12(:,96), A(:,2180), n3(:,3208), t3x72(:,:,2180), nhel, den(11))
    call Hcont_QA(nsync, wf6(:,40), wf12(:,97), A(:,2181), n3(:,3209), t3x72(:,:,2181), nhel, den(11))
    call Hcont_QA(nsync, wf6(:,40), wf12(:,98), A(:,2182), n3(:,3210), t3x72(:,:,2182), nhel, den(11))
    call Hcont_QA(nsync, wf6(:,40), wf12(:,99), A(:,2183), n3(:,3211), t3x72(:,:,2183), nhel, den(11))
    call Hcont_VV(nsync, wf8(:,6), wf9(:,29), A(:,2184), n3(:,3212), t3x72(:,:,2184), nhel, den(60))
    call Hcont_QA(nsync, wf12(:,14), wf6(:,214), A(:,2185), n3(:,3213), t3x72(:,:,2185), nhel, den(29))
    call Hcont_QA(nsync, wf12(:,14), wf6(:,361), A(:,2186), n3(:,3214), t3x72(:,:,2186), nhel, den(29))
    call Hcont_QA(nsync, wf12(:,14), wf6(:,362), A(:,2187), n3(:,3215), t3x72(:,:,2187), nhel, den(29))
    call Hcont_QA(nsync, wf12(:,14), wf6(:,363), A(:,2188), n3(:,3216), t3x72(:,:,2188), nhel, den(29))
    call Hcont_QA(nsync, wf12(:,14), wf6(:,364), A(:,2189), n3(:,3217), t3x72(:,:,2189), nhel, den(29))
    call Hcont_QA(nsync, wf12(:,28), wf6(:,218), A(:,2190), n3(:,3218), t3x72(:,:,2190), nhel, den(8))
    call Hcont_QA(nsync, wf12(:,28), wf6(:,220), A(:,2191), n3(:,3219), t3x72(:,:,2191), nhel, den(8))
    call Hcont_QA(nsync, wf18(:,171), wf4(:,45), A(:,2192), n3(:,3220), t3x72(:,:,2192), nhel, den(25))
    call Hcont_QA(nsync, wf18(:,171), wf4(:,47), A(:,2193), n3(:,3221), t3x72(:,:,2193), nhel, den(25))
    call Hcont_QA(nsync, wf18(:,172), wf4(:,45), A(:,2194), n3(:,3222), t3x72(:,:,2194), nhel, den(66))
    call Hcont_QA(nsync, wf18(:,172), wf4(:,47), A(:,2195), n3(:,3223), t3x72(:,:,2195), nhel, den(66))
    call Hcont_QA(nsync, wf12(:,109), wf6(:,192), A(:,2196), n3(:,3224), t3x72(:,:,2196), nhel, den(8))
    call Hcont_QA(nsync, wf12(:,42), wf6(:,137), A(:,2197), n3(:,3225), t3x72(:,:,2197), nhel, den(8))
    call Hcont_QA(nsync, wf12(:,42), wf6(:,138), A(:,2198), n3(:,3226), t3x72(:,:,2198), nhel, den(8))
    call Hcont_QA(nsync, wf12(:,42), wf6(:,139), A(:,2199), n3(:,3227), t3x72(:,:,2199), nhel, den(8))
    call Hcont_QA(nsync, wf12(:,42), wf6(:,140), A(:,2200), n3(:,3228), t3x72(:,:,2200), nhel, den(8))
    call Hcont_QA(nsync, wf12(:,111), wf6(:,192), A(:,2201), n3(:,3229), t3x72(:,:,2201), nhel, den(10))
    call Hcont_QA(nsync, wf12(:,44), wf6(:,137), A(:,2202), n3(:,3230), t3x72(:,:,2202), nhel, den(10))
    call Hcont_QA(nsync, wf12(:,44), wf6(:,138), A(:,2203), n3(:,3231), t3x72(:,:,2203), nhel, den(10))
    call Hcont_QA(nsync, wf12(:,44), wf6(:,139), A(:,2204), n3(:,3232), t3x72(:,:,2204), nhel, den(10))
    call Hcont_QA(nsync, wf12(:,44), wf6(:,140), A(:,2205), n3(:,3233), t3x72(:,:,2205), nhel, den(10))
    call Hcont_VV(nsync, wf8(:,16), wf9(:,29), A(:,2206), n3(:,3234), t3x72(:,:,2206), nhel, den(59))
    call Hcont_QA(nsync, wf12(:,29), wf6(:,218), A(:,2207), n3(:,3235), t3x72(:,:,2207), nhel, den(8))
    call Hcont_QA(nsync, wf12(:,29), wf6(:,220), A(:,2208), n3(:,3236), t3x72(:,:,2208), nhel, den(8))
    call Hcont_QA(nsync, wf12(:,17), wf6(:,144), A(:,2209), n3(:,3237), t3x72(:,:,2209), nhel, den(8))
    call Hcont_QA(nsync, wf18(:,175), wf4(:,45), A(:,2210), n3(:,3238), t3x72(:,:,2210), nhel, den(25))
    call Hcont_QA(nsync, wf18(:,175), wf4(:,47), A(:,2211), n3(:,3239), t3x72(:,:,2211), nhel, den(25))
    call Hcont_QA(nsync, wf4(:,10), wf18(:,43), A(:,2212), n3(:,3240), t3x72(:,:,2212), nhel, den(25))
    call Hcont_QA(nsync, wf12(:,113), wf6(:,204), A(:,2213), n3(:,3241), t3x72(:,:,2213), nhel, den(3))
    call Hcont_QA(nsync, wf12(:,113), wf6(:,206), A(:,2214), n3(:,3242), t3x72(:,:,2214), nhel, den(3))
    call Hcont_QA(nsync, wf12(:,49), wf6(:,142), A(:,2215), n3(:,3243), t3x72(:,:,2215), nhel, den(3))
    call Hcont_QA(nsync, wf18(:,176), wf4(:,45), A(:,2216), n3(:,3244), t3x72(:,:,2216), nhel, den(28))
    call Hcont_QA(nsync, wf18(:,176), wf4(:,47), A(:,2217), n3(:,3245), t3x72(:,:,2217), nhel, den(28))
    call Hcont_QA(nsync, wf4(:,10), wf18(:,44), A(:,2218), n3(:,3246), t3x72(:,:,2218), nhel, den(28))
    call Hcont_QA(nsync, wf12(:,115), wf6(:,204), A(:,2219), n3(:,3247), t3x72(:,:,2219), nhel, den(5))
    call Hcont_QA(nsync, wf12(:,115), wf6(:,206), A(:,2220), n3(:,3248), t3x72(:,:,2220), nhel, den(5))
    call Hcont_QA(nsync, wf12(:,51), wf6(:,142), A(:,2221), n3(:,3249), t3x72(:,:,2221), nhel, den(5))
    call Hcont_QA(nsync, wf12(:,108), wf6(:,217), A(:,2222), n3(:,3250), t3x72(:,:,2222), nhel, den(30))
    call Hcont_QA(nsync, wf12(:,108), wf6(:,219), A(:,2223), n3(:,3251), t3x72(:,:,2223), nhel, den(30))
    call Hcont_QA(nsync, wf6(:,35), wf12(:,54), A(:,2224), n3(:,3252), t3x72(:,:,2224), nhel, den(30))
    call Hcont_QA(nsync, wf12(:,30), wf6(:,211), A(:,2225), n3(:,3253), t3x72(:,:,2225), nhel, den(3))
    call Hcont_QA(nsync, wf12(:,18), wf6(:,143), A(:,2226), n3(:,3254), t3x72(:,:,2226), nhel, den(3))
    call Hcont_QA(nsync, wf12(:,30), wf6(:,213), A(:,2227), n3(:,3255), t3x72(:,:,2227), nhel, den(3))
    call Hcont_QA(nsync, wf18(:,173), wf4(:,41), A(:,2228), n3(:,3256), t3x72(:,:,2228), nhel, den(16))
    call Hcont_QA(nsync, wf4(:,9), wf18(:,41), A(:,2229), n3(:,3257), t3x72(:,:,2229), nhel, den(16))
    call Hcont_QA(nsync, wf18(:,173), wf4(:,43), A(:,2230), n3(:,3258), t3x72(:,:,2230), nhel, den(16))
    call Hcont_QA(nsync, wf12(:,109), wf6(:,197), A(:,2231), n3(:,3259), t3x72(:,:,2231), nhel, den(8))
    call Hcont_QA(nsync, wf12(:,42), wf6(:,141), A(:,2232), n3(:,3260), t3x72(:,:,2232), nhel, den(8))
    call Hcont_QA(nsync, wf12(:,109), wf6(:,199), A(:,2233), n3(:,3261), t3x72(:,:,2233), nhel, den(8))
    call Hcont_QA(nsync, wf18(:,174), wf4(:,41), A(:,2234), n3(:,3262), t3x72(:,:,2234), nhel, den(19))
    call Hcont_QA(nsync, wf4(:,9), wf18(:,42), A(:,2235), n3(:,3263), t3x72(:,:,2235), nhel, den(19))
    call Hcont_QA(nsync, wf18(:,174), wf4(:,43), A(:,2236), n3(:,3264), t3x72(:,:,2236), nhel, den(19))
    call Hcont_QA(nsync, wf12(:,111), wf6(:,197), A(:,2237), n3(:,3265), t3x72(:,:,2237), nhel, den(10))
    call Hcont_QA(nsync, wf12(:,44), wf6(:,141), A(:,2238), n3(:,3266), t3x72(:,:,2238), nhel, den(10))
    call Hcont_QA(nsync, wf12(:,111), wf6(:,199), A(:,2239), n3(:,3267), t3x72(:,:,2239), nhel, den(10))
    call Hcont_QA(nsync, wf12(:,105), wf6(:,210), A(:,2240), n3(:,3268), t3x72(:,:,2240), nhel, den(21))
    call Hcont_QA(nsync, wf6(:,33), wf12(:,47), A(:,2241), n3(:,3269), t3x72(:,:,2241), nhel, den(21))
    call Hcont_QA(nsync, wf12(:,105), wf6(:,212), A(:,2242), n3(:,3270), t3x72(:,:,2242), nhel, den(21))
    call Hcont_QA(nsync, wf6(:,67), wf12(:,142), A(:,2243), n3(:,3271), t3x72(:,:,2243), nhel, den(12))
    call Hcont_QA(nsync, wf12(:,86), wf6(:,191), A(:,2244), n3(:,3272), t3x72(:,:,2244), nhel, den(20))
    call Hcont_VV(nsync, wf8(:,1), wf9(:,25), A(:,2245), n3(:,3273), t3x72(:,:,2245), nhel, den(32))
    call Hcont_VV(nsync, wf8(:,1), wf9(:,26), A(:,2246), n3(:,3274), t3x72(:,:,2246), nhel, den(32))
    call Hcont_VV(nsync, wf8(:,2), wf9(:,25), A(:,2247), n3(:,3275), t3x72(:,:,2247), nhel, den(34))
    call Hcont_VV(nsync, wf8(:,2), wf9(:,26), A(:,2248), n3(:,3276), t3x72(:,:,2248), nhel, den(34))
    call Hcont_QA(nsync, wf6(:,72), wf12(:,141), A(:,2249), n3(:,3277), t3x72(:,:,2249), nhel, den(10))
    call Hcont_QA(nsync, wf12(:,81), wf6(:,189), A(:,2250), n3(:,3278), t3x72(:,:,2250), nhel, den(21))
    call Hcont_VV(nsync, wf8(:,1), wf9(:,23), A(:,2251), n3(:,3279), t3x72(:,:,2251), nhel, den(32))
    call Hcont_VV(nsync, wf8(:,1), wf9(:,24), A(:,2252), n3(:,3280), t3x72(:,:,2252), nhel, den(32))
    call Hcont_VV(nsync, wf8(:,2), wf9(:,23), A(:,2253), n3(:,3281), t3x72(:,:,2253), nhel, den(34))
    call Hcont_VV(nsync, wf8(:,2), wf9(:,24), A(:,2254), n3(:,3282), t3x72(:,:,2254), nhel, den(34))
    call Hcont_QA(nsync, wf4(:,2), wf18(:,178), A(:,2255), n3(:,3283), t3x72(:,:,2255), nhel, den(11))
    call Hcont_QA(nsync, wf12(:,100), wf6(:,185), A(:,2256), n3(:,3284), t3x72(:,:,2256), nhel, den(29))
    call Hcont_VV(nsync, wf8(:,3), wf9(:,25), A(:,2257), n3(:,3285), t3x72(:,:,2257), nhel, den(35))
    call Hcont_VV(nsync, wf8(:,3), wf9(:,26), A(:,2258), n3(:,3286), t3x72(:,:,2258), nhel, den(35))
    call Hcont_VV(nsync, wf8(:,4), wf9(:,25), A(:,2259), n3(:,3287), t3x72(:,:,2259), nhel, den(36))
    call Hcont_VV(nsync, wf8(:,4), wf9(:,26), A(:,2260), n3(:,3288), t3x72(:,:,2260), nhel, den(36))
    call Hcont_QA(nsync, wf4(:,2), wf18(:,177), A(:,2261), n3(:,3289), t3x72(:,:,2261), nhel, den(5))
    call Hcont_QA(nsync, wf12(:,95), wf6(:,183), A(:,2262), n3(:,3290), t3x72(:,:,2262), nhel, den(30))
    call Hcont_VV(nsync, wf8(:,3), wf9(:,23), A(:,2263), n3(:,3291), t3x72(:,:,2263), nhel, den(35))
    call Hcont_VV(nsync, wf8(:,3), wf9(:,24), A(:,2264), n3(:,3292), t3x72(:,:,2264), nhel, den(35))
    call Hcont_VV(nsync, wf8(:,4), wf9(:,23), A(:,2265), n3(:,3293), t3x72(:,:,2265), nhel, den(36))
    call Hcont_VV(nsync, wf8(:,4), wf9(:,24), A(:,2266), n3(:,3294), t3x72(:,:,2266), nhel, den(36))
    call Hcont_QA(nsync, wf12(:,22), wf6(:,192), A(:,2267), n3(:,3295), t3x72(:,:,2267), nhel, den(8))
    call Hcont_QA(nsync, wf12(:,26), wf6(:,186), A(:,2268), n3(:,3296), t3x72(:,:,2268), nhel, den(3))
    call Hcont_QA(nsync, wf12(:,24), wf6(:,190), A(:,2269), n3(:,3297), t3x72(:,:,2269), nhel, den(3))
    call Hcont_QA(nsync, wf12(:,28), wf6(:,184), A(:,2270), n3(:,3298), t3x72(:,:,2270), nhel, den(8))
    call Hcont_QA(nsync, wf18(:,161), wf4(:,41), A(:,2271), n3(:,3299), t3x72(:,:,2271), nhel, den(16))
    call Hcont_QA(nsync, wf18(:,161), wf4(:,43), A(:,2272), n3(:,3300), t3x72(:,:,2272), nhel, den(16))
    call Hcont_QA(nsync, wf12(:,5), wf6(:,194), A(:,2273), n3(:,3301), t3x72(:,:,2273), nhel, den(14))
    call Hcont_QA(nsync, wf12(:,5), wf6(:,195), A(:,2274), n3(:,3302), t3x72(:,:,2274), nhel, den(14))
    call Hcont_QA(nsync, wf4(:,20), wf18(:,213), A(:,2275), n3(:,3303), t3x72(:,:,2275), nhel, den(5))
    call Hcont_QA(nsync, wf4(:,14), wf18(:,125), A(:,2276), n3(:,3304), t3x72(:,:,2276), nhel, den(5))
    call Hcont_QA(nsync, wf4(:,14), wf18(:,145), A(:,2277), n3(:,3305), t3x72(:,:,2277), nhel, den(5))
    call Hcont_QA(nsync, wf4(:,14), wf18(:,126), A(:,2278), n3(:,3306), t3x72(:,:,2278), nhel, den(5))
    call Hcont_QA(nsync, wf4(:,14), wf18(:,146), A(:,2279), n3(:,3307), t3x72(:,:,2279), nhel, den(5))
    call Hcont_QA(nsync, wf12(:,5), wf6(:,193), A(:,2280), n3(:,3308), t3x72(:,:,2280), nhel, den(14))
    call Hcont_QA(nsync, wf12(:,5), wf6(:,365), A(:,2281), n3(:,3309), t3x72(:,:,2281), nhel, den(14))
    call Hcont_QA(nsync, wf12(:,5), wf6(:,366), A(:,2282), n3(:,3310), t3x72(:,:,2282), nhel, den(14))
    call Hcont_QA(nsync, wf12(:,5), wf6(:,367), A(:,2283), n3(:,3311), t3x72(:,:,2283), nhel, den(14))
    call Hcont_QA(nsync, wf12(:,5), wf6(:,368), A(:,2284), n3(:,3312), t3x72(:,:,2284), nhel, den(14))
    call Hcont_VV(nsync, wf9(:,3), wf8(:,33), A(:,2285), n3(:,3313), t3x72(:,:,2285), nhel, den(38))
    call Hcont_VV(nsync, wf9(:,3), wf8(:,34), A(:,2286), n3(:,3314), t3x72(:,:,2286), nhel, den(38))
    call Hcont_QA(nsync, wf12(:,86), wf6(:,196), A(:,2287), n3(:,3315), t3x72(:,:,2287), nhel, den(20))
    call Hcont_QA(nsync, wf12(:,86), wf6(:,198), A(:,2288), n3(:,3316), t3x72(:,:,2288), nhel, den(20))
    call Hcont_QA(nsync, wf12(:,8), wf6(:,194), A(:,2289), n3(:,3317), t3x72(:,:,2289), nhel, den(21))
    call Hcont_QA(nsync, wf12(:,8), wf6(:,195), A(:,2290), n3(:,3318), t3x72(:,:,2290), nhel, den(21))
    call Hcont_QA(nsync, wf6(:,55), wf12(:,141), A(:,2291), n3(:,3319), t3x72(:,:,2291), nhel, den(10))
    call Hcont_QA(nsync, wf6(:,39), wf12(:,77), A(:,2292), n3(:,3320), t3x72(:,:,2292), nhel, den(10))
    call Hcont_QA(nsync, wf6(:,39), wf12(:,78), A(:,2293), n3(:,3321), t3x72(:,:,2293), nhel, den(10))
    call Hcont_QA(nsync, wf6(:,39), wf12(:,79), A(:,2294), n3(:,3322), t3x72(:,:,2294), nhel, den(10))
    call Hcont_QA(nsync, wf6(:,39), wf12(:,80), A(:,2295), n3(:,3323), t3x72(:,:,2295), nhel, den(10))
    call Hcont_VV(nsync, wf8(:,5), wf9(:,28), A(:,2296), n3(:,3324), t3x72(:,:,2296), nhel, den(59))
    call Hcont_QA(nsync, wf12(:,8), wf6(:,193), A(:,2297), n3(:,3325), t3x72(:,:,2297), nhel, den(21))
    call Hcont_QA(nsync, wf12(:,8), wf6(:,365), A(:,2298), n3(:,3326), t3x72(:,:,2298), nhel, den(21))
    call Hcont_QA(nsync, wf12(:,8), wf6(:,366), A(:,2299), n3(:,3327), t3x72(:,:,2299), nhel, den(21))
    call Hcont_QA(nsync, wf12(:,8), wf6(:,367), A(:,2300), n3(:,3328), t3x72(:,:,2300), nhel, den(21))
    call Hcont_QA(nsync, wf12(:,8), wf6(:,368), A(:,2301), n3(:,3329), t3x72(:,:,2301), nhel, den(21))
    call Hcont_QA(nsync, wf12(:,22), wf6(:,197), A(:,2302), n3(:,3330), t3x72(:,:,2302), nhel, den(8))
    call Hcont_QA(nsync, wf12(:,22), wf6(:,199), A(:,2303), n3(:,3331), t3x72(:,:,2303), nhel, den(8))
    call Hcont_QA(nsync, wf18(:,162), wf4(:,41), A(:,2304), n3(:,3332), t3x72(:,:,2304), nhel, den(19))
    call Hcont_QA(nsync, wf18(:,162), wf4(:,43), A(:,2305), n3(:,3333), t3x72(:,:,2305), nhel, den(19))
    call Hcont_QA(nsync, wf18(:,163), wf4(:,41), A(:,2306), n3(:,3334), t3x72(:,:,2306), nhel, den(65))
    call Hcont_QA(nsync, wf18(:,163), wf4(:,43), A(:,2307), n3(:,3335), t3x72(:,:,2307), nhel, den(65))
    call Hcont_QA(nsync, wf12(:,29), wf6(:,184), A(:,2308), n3(:,3336), t3x72(:,:,2308), nhel, den(8))
    call Hcont_QA(nsync, wf12(:,17), wf6(:,115), A(:,2309), n3(:,3337), t3x72(:,:,2309), nhel, den(8))
    call Hcont_QA(nsync, wf12(:,17), wf6(:,116), A(:,2310), n3(:,3338), t3x72(:,:,2310), nhel, den(8))
    call Hcont_QA(nsync, wf12(:,17), wf6(:,117), A(:,2311), n3(:,3339), t3x72(:,:,2311), nhel, den(8))
    call Hcont_QA(nsync, wf12(:,17), wf6(:,118), A(:,2312), n3(:,3340), t3x72(:,:,2312), nhel, den(8))
    call Hcont_QA(nsync, wf12(:,107), wf6(:,184), A(:,2313), n3(:,3341), t3x72(:,:,2313), nhel, den(11))
    call Hcont_QA(nsync, wf12(:,53), wf6(:,115), A(:,2314), n3(:,3342), t3x72(:,:,2314), nhel, den(11))
    call Hcont_QA(nsync, wf12(:,53), wf6(:,116), A(:,2315), n3(:,3343), t3x72(:,:,2315), nhel, den(11))
    call Hcont_QA(nsync, wf12(:,53), wf6(:,117), A(:,2316), n3(:,3344), t3x72(:,:,2316), nhel, den(11))
    call Hcont_QA(nsync, wf12(:,53), wf6(:,118), A(:,2317), n3(:,3345), t3x72(:,:,2317), nhel, den(11))
    call Hcont_VV(nsync, wf8(:,13), wf9(:,28), A(:,2318), n3(:,3346), t3x72(:,:,2318), nhel, den(60))
    call Hcont_QA(nsync, wf18(:,164), wf4(:,41), A(:,2319), n3(:,3347), t3x72(:,:,2319), nhel, den(19))
    call Hcont_QA(nsync, wf18(:,164), wf4(:,43), A(:,2320), n3(:,3348), t3x72(:,:,2320), nhel, den(19))
    call Hcont_QA(nsync, wf12(:,6), wf6(:,208), A(:,2321), n3(:,3349), t3x72(:,:,2321), nhel, den(18))
    call Hcont_QA(nsync, wf12(:,6), wf6(:,209), A(:,2322), n3(:,3350), t3x72(:,:,2322), nhel, den(18))
    call Hcont_QA(nsync, wf4(:,20), wf18(:,216), A(:,2323), n3(:,3351), t3x72(:,:,2323), nhel, den(11))
    call Hcont_QA(nsync, wf4(:,14), wf18(:,129), A(:,2324), n3(:,3352), t3x72(:,:,2324), nhel, den(11))
    call Hcont_QA(nsync, wf4(:,14), wf18(:,149), A(:,2325), n3(:,3353), t3x72(:,:,2325), nhel, den(11))
    call Hcont_QA(nsync, wf4(:,14), wf18(:,130), A(:,2326), n3(:,3354), t3x72(:,:,2326), nhel, den(11))
    call Hcont_QA(nsync, wf4(:,14), wf18(:,150), A(:,2327), n3(:,3355), t3x72(:,:,2327), nhel, den(11))
    call Hcont_QA(nsync, wf12(:,6), wf6(:,207), A(:,2328), n3(:,3356), t3x72(:,:,2328), nhel, den(18))
    call Hcont_QA(nsync, wf12(:,6), wf6(:,369), A(:,2329), n3(:,3357), t3x72(:,:,2329), nhel, den(18))
    call Hcont_QA(nsync, wf12(:,6), wf6(:,370), A(:,2330), n3(:,3358), t3x72(:,:,2330), nhel, den(18))
    call Hcont_QA(nsync, wf12(:,6), wf6(:,371), A(:,2331), n3(:,3359), t3x72(:,:,2331), nhel, den(18))
    call Hcont_QA(nsync, wf12(:,6), wf6(:,372), A(:,2332), n3(:,3360), t3x72(:,:,2332), nhel, den(18))
    call Hcont_VV(nsync, wf9(:,4), wf8(:,33), A(:,2333), n3(:,3361), t3x72(:,:,2333), nhel, den(38))
    call Hcont_VV(nsync, wf9(:,4), wf8(:,34), A(:,2334), n3(:,3362), t3x72(:,:,2334), nhel, den(38))
    call Hcont_QA(nsync, wf12(:,81), wf6(:,210), A(:,2335), n3(:,3363), t3x72(:,:,2335), nhel, den(21))
    call Hcont_QA(nsync, wf12(:,81), wf6(:,212), A(:,2336), n3(:,3364), t3x72(:,:,2336), nhel, den(21))
    call Hcont_QA(nsync, wf12(:,7), wf6(:,208), A(:,2337), n3(:,3365), t3x72(:,:,2337), nhel, den(20))
    call Hcont_QA(nsync, wf12(:,7), wf6(:,209), A(:,2338), n3(:,3366), t3x72(:,:,2338), nhel, den(20))
    call Hcont_QA(nsync, wf6(:,60), wf12(:,142), A(:,2339), n3(:,3367), t3x72(:,:,2339), nhel, den(12))
    call Hcont_QA(nsync, wf6(:,44), wf12(:,82), A(:,2340), n3(:,3368), t3x72(:,:,2340), nhel, den(12))
    call Hcont_QA(nsync, wf6(:,44), wf12(:,83), A(:,2341), n3(:,3369), t3x72(:,:,2341), nhel, den(12))
    call Hcont_QA(nsync, wf6(:,44), wf12(:,84), A(:,2342), n3(:,3370), t3x72(:,:,2342), nhel, den(12))
    call Hcont_QA(nsync, wf6(:,44), wf12(:,85), A(:,2343), n3(:,3371), t3x72(:,:,2343), nhel, den(12))
    call Hcont_VV(nsync, wf8(:,5), wf9(:,30), A(:,2344), n3(:,3372), t3x72(:,:,2344), nhel, den(59))
    call Hcont_QA(nsync, wf12(:,7), wf6(:,207), A(:,2345), n3(:,3373), t3x72(:,:,2345), nhel, den(20))
    call Hcont_QA(nsync, wf12(:,7), wf6(:,369), A(:,2346), n3(:,3374), t3x72(:,:,2346), nhel, den(20))
    call Hcont_QA(nsync, wf12(:,7), wf6(:,370), A(:,2347), n3(:,3375), t3x72(:,:,2347), nhel, den(20))
    call Hcont_QA(nsync, wf12(:,7), wf6(:,371), A(:,2348), n3(:,3376), t3x72(:,:,2348), nhel, den(20))
    call Hcont_QA(nsync, wf12(:,7), wf6(:,372), A(:,2349), n3(:,3377), t3x72(:,:,2349), nhel, den(20))
    call Hcont_QA(nsync, wf12(:,24), wf6(:,211), A(:,2350), n3(:,3378), t3x72(:,:,2350), nhel, den(3))
    call Hcont_QA(nsync, wf12(:,24), wf6(:,213), A(:,2351), n3(:,3379), t3x72(:,:,2351), nhel, den(3))
    call Hcont_QA(nsync, wf18(:,165), wf4(:,41), A(:,2352), n3(:,3380), t3x72(:,:,2352), nhel, den(16))
    call Hcont_QA(nsync, wf18(:,165), wf4(:,43), A(:,2353), n3(:,3381), t3x72(:,:,2353), nhel, den(16))
    call Hcont_QA(nsync, wf18(:,166), wf4(:,41), A(:,2354), n3(:,3382), t3x72(:,:,2354), nhel, den(65))
    call Hcont_QA(nsync, wf18(:,166), wf4(:,43), A(:,2355), n3(:,3383), t3x72(:,:,2355), nhel, den(65))
    call Hcont_QA(nsync, wf12(:,113), wf6(:,186), A(:,2356), n3(:,3384), t3x72(:,:,2356), nhel, den(3))
    call Hcont_QA(nsync, wf12(:,49), wf6(:,119), A(:,2357), n3(:,3385), t3x72(:,:,2357), nhel, den(3))
    call Hcont_QA(nsync, wf12(:,49), wf6(:,120), A(:,2358), n3(:,3386), t3x72(:,:,2358), nhel, den(3))
    call Hcont_QA(nsync, wf12(:,49), wf6(:,121), A(:,2359), n3(:,3387), t3x72(:,:,2359), nhel, den(3))
    call Hcont_QA(nsync, wf12(:,49), wf6(:,122), A(:,2360), n3(:,3388), t3x72(:,:,2360), nhel, den(3))
    call Hcont_QA(nsync, wf12(:,115), wf6(:,186), A(:,2361), n3(:,3389), t3x72(:,:,2361), nhel, den(5))
    call Hcont_QA(nsync, wf12(:,51), wf6(:,119), A(:,2362), n3(:,3390), t3x72(:,:,2362), nhel, den(5))
    call Hcont_QA(nsync, wf12(:,51), wf6(:,120), A(:,2363), n3(:,3391), t3x72(:,:,2363), nhel, den(5))
    call Hcont_QA(nsync, wf12(:,51), wf6(:,121), A(:,2364), n3(:,3392), t3x72(:,:,2364), nhel, den(5))
    call Hcont_QA(nsync, wf12(:,51), wf6(:,122), A(:,2365), n3(:,3393), t3x72(:,:,2365), nhel, den(5))
    call Hcont_VV(nsync, wf8(:,13), wf9(:,30), A(:,2366), n3(:,3394), t3x72(:,:,2366), nhel, den(60))
    call Hcont_QA(nsync, wf18(:,167), wf4(:,77), A(:,2367), n3(:,3395), t3x72(:,:,2367), nhel, den(25))
    call Hcont_QA(nsync, wf18(:,167), wf4(:,79), A(:,2368), n3(:,3396), t3x72(:,:,2368), nhel, den(25))
    call Hcont_QA(nsync, wf12(:,10), wf6(:,315), A(:,2369), n3(:,3397), t3x72(:,:,2369), nhel, den(23))
    call Hcont_QA(nsync, wf12(:,10), wf6(:,316), A(:,2370), n3(:,3398), t3x72(:,:,2370), nhel, den(23))
    call Hcont_QA(nsync, wf4(:,22), wf18(:,219), A(:,2371), n3(:,3399), t3x72(:,:,2371), nhel, den(10))
    call Hcont_QA(nsync, wf4(:,16), wf18(:,153), A(:,2372), n3(:,3400), t3x72(:,:,2372), nhel, den(10))
    call Hcont_QA(nsync, wf4(:,16), wf18(:,133), A(:,2373), n3(:,3401), t3x72(:,:,2373), nhel, den(10))
    call Hcont_QA(nsync, wf4(:,16), wf18(:,154), A(:,2374), n3(:,3402), t3x72(:,:,2374), nhel, den(10))
    call Hcont_QA(nsync, wf4(:,16), wf18(:,134), A(:,2375), n3(:,3403), t3x72(:,:,2375), nhel, den(10))
    call Hcont_QA(nsync, wf12(:,10), wf6(:,200), A(:,2376), n3(:,3404), t3x72(:,:,2376), nhel, den(23))
    call Hcont_QA(nsync, wf12(:,10), wf6(:,373), A(:,2377), n3(:,3405), t3x72(:,:,2377), nhel, den(23))
    call Hcont_QA(nsync, wf12(:,10), wf6(:,374), A(:,2378), n3(:,3406), t3x72(:,:,2378), nhel, den(23))
    call Hcont_QA(nsync, wf12(:,10), wf6(:,375), A(:,2379), n3(:,3407), t3x72(:,:,2379), nhel, den(23))
    call Hcont_QA(nsync, wf12(:,10), wf6(:,376), A(:,2380), n3(:,3408), t3x72(:,:,2380), nhel, den(23))
    call Hcont_VV(nsync, wf9(:,5), wf8(:,55), A(:,2381), n3(:,3409), t3x72(:,:,2381), nhel, den(39))
    call Hcont_VV(nsync, wf9(:,5), wf8(:,56), A(:,2382), n3(:,3410), t3x72(:,:,2382), nhel, den(39))
    call Hcont_QA(nsync, wf12(:,100), wf6(:,317), A(:,2383), n3(:,3411), t3x72(:,:,2383), nhel, den(29))
    call Hcont_QA(nsync, wf12(:,100), wf6(:,319), A(:,2384), n3(:,3412), t3x72(:,:,2384), nhel, den(29))
    call Hcont_QA(nsync, wf12(:,16), wf6(:,315), A(:,2385), n3(:,3413), t3x72(:,:,2385), nhel, den(30))
    call Hcont_QA(nsync, wf12(:,16), wf6(:,316), A(:,2386), n3(:,3414), t3x72(:,:,2386), nhel, den(30))
    call Hcont_QA(nsync, wf6(:,65), wf12(:,145), A(:,2387), n3(:,3415), t3x72(:,:,2387), nhel, den(5))
    call Hcont_QA(nsync, wf6(:,51), wf12(:,91), A(:,2388), n3(:,3416), t3x72(:,:,2388), nhel, den(5))
    call Hcont_QA(nsync, wf6(:,51), wf12(:,92), A(:,2389), n3(:,3417), t3x72(:,:,2389), nhel, den(5))
    call Hcont_QA(nsync, wf6(:,51), wf12(:,93), A(:,2390), n3(:,3418), t3x72(:,:,2390), nhel, den(5))
    call Hcont_QA(nsync, wf6(:,51), wf12(:,94), A(:,2391), n3(:,3419), t3x72(:,:,2391), nhel, den(5))
    call Hcont_VV(nsync, wf8(:,6), wf9(:,27), A(:,2392), n3(:,3420), t3x72(:,:,2392), nhel, den(60))
    call Hcont_QA(nsync, wf12(:,16), wf6(:,200), A(:,2393), n3(:,3421), t3x72(:,:,2393), nhel, den(30))
    call Hcont_QA(nsync, wf12(:,16), wf6(:,373), A(:,2394), n3(:,3422), t3x72(:,:,2394), nhel, den(30))
    call Hcont_QA(nsync, wf12(:,16), wf6(:,374), A(:,2395), n3(:,3423), t3x72(:,:,2395), nhel, den(30))
    call Hcont_QA(nsync, wf12(:,16), wf6(:,375), A(:,2396), n3(:,3424), t3x72(:,:,2396), nhel, den(30))
    call Hcont_QA(nsync, wf12(:,16), wf6(:,376), A(:,2397), n3(:,3425), t3x72(:,:,2397), nhel, den(30))
    call Hcont_QA(nsync, wf12(:,26), wf6(:,318), A(:,2398), n3(:,3426), t3x72(:,:,2398), nhel, den(3))
    call Hcont_QA(nsync, wf12(:,26), wf6(:,320), A(:,2399), n3(:,3427), t3x72(:,:,2399), nhel, den(3))
    call Hcont_QA(nsync, wf18(:,168), wf4(:,77), A(:,2400), n3(:,3428), t3x72(:,:,2400), nhel, den(28))
    call Hcont_QA(nsync, wf18(:,168), wf4(:,79), A(:,2401), n3(:,3429), t3x72(:,:,2401), nhel, den(28))
    call Hcont_QA(nsync, wf18(:,169), wf4(:,77), A(:,2402), n3(:,3430), t3x72(:,:,2402), nhel, den(66))
    call Hcont_QA(nsync, wf18(:,169), wf4(:,79), A(:,2403), n3(:,3431), t3x72(:,:,2403), nhel, den(66))
    call Hcont_QA(nsync, wf12(:,30), wf6(:,190), A(:,2404), n3(:,3432), t3x72(:,:,2404), nhel, den(3))
    call Hcont_QA(nsync, wf12(:,20), wf6(:,133), A(:,2405), n3(:,3433), t3x72(:,:,2405), nhel, den(3))
    call Hcont_QA(nsync, wf12(:,20), wf6(:,134), A(:,2406), n3(:,3434), t3x72(:,:,2406), nhel, den(3))
    call Hcont_QA(nsync, wf12(:,20), wf6(:,135), A(:,2407), n3(:,3435), t3x72(:,:,2407), nhel, den(3))
    call Hcont_QA(nsync, wf12(:,20), wf6(:,136), A(:,2408), n3(:,3436), t3x72(:,:,2408), nhel, den(3))
    call Hcont_QA(nsync, wf12(:,104), wf6(:,190), A(:,2409), n3(:,3437), t3x72(:,:,2409), nhel, den(12))
    call Hcont_QA(nsync, wf12(:,62), wf6(:,133), A(:,2410), n3(:,3438), t3x72(:,:,2410), nhel, den(12))
    call Hcont_QA(nsync, wf12(:,62), wf6(:,134), A(:,2411), n3(:,3439), t3x72(:,:,2411), nhel, den(12))
    call Hcont_QA(nsync, wf12(:,62), wf6(:,135), A(:,2412), n3(:,3440), t3x72(:,:,2412), nhel, den(12))
    call Hcont_QA(nsync, wf12(:,62), wf6(:,136), A(:,2413), n3(:,3441), t3x72(:,:,2413), nhel, den(12))
    call Hcont_VV(nsync, wf8(:,16), wf9(:,27), A(:,2414), n3(:,3442), t3x72(:,:,2414), nhel, den(59))
    call Hcont_QA(nsync, wf18(:,170), wf4(:,77), A(:,2415), n3(:,3443), t3x72(:,:,2415), nhel, den(28))
    call Hcont_QA(nsync, wf18(:,170), wf4(:,79), A(:,2416), n3(:,3444), t3x72(:,:,2416), nhel, den(28))
    call Hcont_QA(nsync, wf12(:,12), wf6(:,327), A(:,2417), n3(:,3445), t3x72(:,:,2417), nhel, den(27))
    call Hcont_QA(nsync, wf12(:,12), wf6(:,328), A(:,2418), n3(:,3446), t3x72(:,:,2418), nhel, den(27))
    call Hcont_QA(nsync, wf4(:,22), wf18(:,222), A(:,2419), n3(:,3447), t3x72(:,:,2419), nhel, den(12))
    call Hcont_QA(nsync, wf4(:,16), wf18(:,157), A(:,2420), n3(:,3448), t3x72(:,:,2420), nhel, den(12))
    call Hcont_QA(nsync, wf4(:,16), wf18(:,137), A(:,2421), n3(:,3449), t3x72(:,:,2421), nhel, den(12))
    call Hcont_QA(nsync, wf4(:,16), wf18(:,158), A(:,2422), n3(:,3450), t3x72(:,:,2422), nhel, den(12))
    call Hcont_QA(nsync, wf4(:,16), wf18(:,138), A(:,2423), n3(:,3451), t3x72(:,:,2423), nhel, den(12))
    call Hcont_QA(nsync, wf12(:,12), wf6(:,214), A(:,2424), n3(:,3452), t3x72(:,:,2424), nhel, den(27))
    call Hcont_QA(nsync, wf12(:,12), wf6(:,377), A(:,2425), n3(:,3453), t3x72(:,:,2425), nhel, den(27))
    call Hcont_QA(nsync, wf12(:,12), wf6(:,378), A(:,2426), n3(:,3454), t3x72(:,:,2426), nhel, den(27))
    call Hcont_QA(nsync, wf12(:,12), wf6(:,379), A(:,2427), n3(:,3455), t3x72(:,:,2427), nhel, den(27))
    call Hcont_QA(nsync, wf12(:,12), wf6(:,380), A(:,2428), n3(:,3456), t3x72(:,:,2428), nhel, den(27))
    call Hcont_VV(nsync, wf9(:,6), wf8(:,55), A(:,2429), n3(:,3457), t3x72(:,:,2429), nhel, den(39))
    call Hcont_VV(nsync, wf9(:,6), wf8(:,56), A(:,2430), n3(:,3458), t3x72(:,:,2430), nhel, den(39))
    call Hcont_QA(nsync, wf12(:,95), wf6(:,329), A(:,2431), n3(:,3459), t3x72(:,:,2431), nhel, den(30))
    call Hcont_QA(nsync, wf12(:,95), wf6(:,331), A(:,2432), n3(:,3460), t3x72(:,:,2432), nhel, den(30))
    call Hcont_QA(nsync, wf12(:,14), wf6(:,327), A(:,2433), n3(:,3461), t3x72(:,:,2433), nhel, den(29))
    call Hcont_QA(nsync, wf12(:,14), wf6(:,328), A(:,2434), n3(:,3462), t3x72(:,:,2434), nhel, den(29))
    call Hcont_QA(nsync, wf6(:,70), wf12(:,146), A(:,2435), n3(:,3463), t3x72(:,:,2435), nhel, den(11))
    call Hcont_QA(nsync, wf6(:,48), wf12(:,96), A(:,2436), n3(:,3464), t3x72(:,:,2436), nhel, den(11))
    call Hcont_QA(nsync, wf6(:,48), wf12(:,97), A(:,2437), n3(:,3465), t3x72(:,:,2437), nhel, den(11))
    call Hcont_QA(nsync, wf6(:,48), wf12(:,98), A(:,2438), n3(:,3466), t3x72(:,:,2438), nhel, den(11))
    call Hcont_QA(nsync, wf6(:,48), wf12(:,99), A(:,2439), n3(:,3467), t3x72(:,:,2439), nhel, den(11))
    call Hcont_VV(nsync, wf8(:,6), wf9(:,29), A(:,2440), n3(:,3468), t3x72(:,:,2440), nhel, den(60))
    call Hcont_QA(nsync, wf12(:,14), wf6(:,214), A(:,2441), n3(:,3469), t3x72(:,:,2441), nhel, den(29))
    call Hcont_QA(nsync, wf12(:,14), wf6(:,377), A(:,2442), n3(:,3470), t3x72(:,:,2442), nhel, den(29))
    call Hcont_QA(nsync, wf12(:,14), wf6(:,378), A(:,2443), n3(:,3471), t3x72(:,:,2443), nhel, den(29))
    call Hcont_QA(nsync, wf12(:,14), wf6(:,379), A(:,2444), n3(:,3472), t3x72(:,:,2444), nhel, den(29))
    call Hcont_QA(nsync, wf12(:,14), wf6(:,380), A(:,2445), n3(:,3473), t3x72(:,:,2445), nhel, den(29))
    call Hcont_QA(nsync, wf12(:,28), wf6(:,330), A(:,2446), n3(:,3474), t3x72(:,:,2446), nhel, den(8))
    call Hcont_QA(nsync, wf12(:,28), wf6(:,332), A(:,2447), n3(:,3475), t3x72(:,:,2447), nhel, den(8))
    call Hcont_QA(nsync, wf18(:,171), wf4(:,77), A(:,2448), n3(:,3476), t3x72(:,:,2448), nhel, den(25))
    call Hcont_QA(nsync, wf18(:,171), wf4(:,79), A(:,2449), n3(:,3477), t3x72(:,:,2449), nhel, den(25))
    call Hcont_QA(nsync, wf18(:,172), wf4(:,77), A(:,2450), n3(:,3478), t3x72(:,:,2450), nhel, den(66))
    call Hcont_QA(nsync, wf18(:,172), wf4(:,79), A(:,2451), n3(:,3479), t3x72(:,:,2451), nhel, den(66))
    call Hcont_QA(nsync, wf12(:,109), wf6(:,192), A(:,2452), n3(:,3480), t3x72(:,:,2452), nhel, den(8))
    call Hcont_QA(nsync, wf12(:,58), wf6(:,137), A(:,2453), n3(:,3481), t3x72(:,:,2453), nhel, den(8))
    call Hcont_QA(nsync, wf12(:,58), wf6(:,138), A(:,2454), n3(:,3482), t3x72(:,:,2454), nhel, den(8))
    call Hcont_QA(nsync, wf12(:,58), wf6(:,139), A(:,2455), n3(:,3483), t3x72(:,:,2455), nhel, den(8))
    call Hcont_QA(nsync, wf12(:,58), wf6(:,140), A(:,2456), n3(:,3484), t3x72(:,:,2456), nhel, den(8))
    call Hcont_QA(nsync, wf12(:,111), wf6(:,192), A(:,2457), n3(:,3485), t3x72(:,:,2457), nhel, den(10))
    call Hcont_QA(nsync, wf12(:,60), wf6(:,137), A(:,2458), n3(:,3486), t3x72(:,:,2458), nhel, den(10))
    call Hcont_QA(nsync, wf12(:,60), wf6(:,138), A(:,2459), n3(:,3487), t3x72(:,:,2459), nhel, den(10))
    call Hcont_QA(nsync, wf12(:,60), wf6(:,139), A(:,2460), n3(:,3488), t3x72(:,:,2460), nhel, den(10))
    call Hcont_QA(nsync, wf12(:,60), wf6(:,140), A(:,2461), n3(:,3489), t3x72(:,:,2461), nhel, den(10))
    call Hcont_VV(nsync, wf8(:,16), wf9(:,29), A(:,2462), n3(:,3490), t3x72(:,:,2462), nhel, den(59))
    call Hcont_QA(nsync, wf12(:,29), wf6(:,330), A(:,2463), n3(:,3491), t3x72(:,:,2463), nhel, den(8))
    call Hcont_QA(nsync, wf12(:,29), wf6(:,332), A(:,2464), n3(:,3492), t3x72(:,:,2464), nhel, den(8))
    call Hcont_QA(nsync, wf12(:,19), wf6(:,144), A(:,2465), n3(:,3493), t3x72(:,:,2465), nhel, den(8))
    call Hcont_QA(nsync, wf18(:,175), wf4(:,77), A(:,2466), n3(:,3494), t3x72(:,:,2466), nhel, den(25))
    call Hcont_QA(nsync, wf18(:,175), wf4(:,79), A(:,2467), n3(:,3495), t3x72(:,:,2467), nhel, den(25))
    call Hcont_QA(nsync, wf4(:,10), wf18(:,51), A(:,2468), n3(:,3496), t3x72(:,:,2468), nhel, den(25))
    call Hcont_QA(nsync, wf12(:,113), wf6(:,318), A(:,2469), n3(:,3497), t3x72(:,:,2469), nhel, den(3))
    call Hcont_QA(nsync, wf12(:,113), wf6(:,320), A(:,2470), n3(:,3498), t3x72(:,:,2470), nhel, den(3))
    call Hcont_QA(nsync, wf12(:,65), wf6(:,142), A(:,2471), n3(:,3499), t3x72(:,:,2471), nhel, den(3))
    call Hcont_QA(nsync, wf18(:,176), wf4(:,77), A(:,2472), n3(:,3500), t3x72(:,:,2472), nhel, den(28))
    call Hcont_QA(nsync, wf18(:,176), wf4(:,79), A(:,2473), n3(:,3501), t3x72(:,:,2473), nhel, den(28))
    call Hcont_QA(nsync, wf4(:,10), wf18(:,52), A(:,2474), n3(:,3502), t3x72(:,:,2474), nhel, den(28))
    call Hcont_QA(nsync, wf12(:,115), wf6(:,318), A(:,2475), n3(:,3503), t3x72(:,:,2475), nhel, den(5))
    call Hcont_QA(nsync, wf12(:,115), wf6(:,320), A(:,2476), n3(:,3504), t3x72(:,:,2476), nhel, den(5))
    call Hcont_QA(nsync, wf12(:,67), wf6(:,142), A(:,2477), n3(:,3505), t3x72(:,:,2477), nhel, den(5))
    call Hcont_QA(nsync, wf12(:,108), wf6(:,329), A(:,2478), n3(:,3506), t3x72(:,:,2478), nhel, den(30))
    call Hcont_QA(nsync, wf12(:,108), wf6(:,331), A(:,2479), n3(:,3507), t3x72(:,:,2479), nhel, den(30))
    call Hcont_QA(nsync, wf6(:,35), wf12(:,70), A(:,2480), n3(:,3508), t3x72(:,:,2480), nhel, den(30))
    call Hcont_QA(nsync, wf12(:,30), wf6(:,324), A(:,2481), n3(:,3509), t3x72(:,:,2481), nhel, den(3))
    call Hcont_QA(nsync, wf12(:,20), wf6(:,143), A(:,2482), n3(:,3510), t3x72(:,:,2482), nhel, den(3))
    call Hcont_QA(nsync, wf12(:,30), wf6(:,326), A(:,2483), n3(:,3511), t3x72(:,:,2483), nhel, den(3))
    call Hcont_QA(nsync, wf18(:,173), wf4(:,73), A(:,2484), n3(:,3512), t3x72(:,:,2484), nhel, den(16))
    call Hcont_QA(nsync, wf4(:,9), wf18(:,49), A(:,2485), n3(:,3513), t3x72(:,:,2485), nhel, den(16))
    call Hcont_QA(nsync, wf18(:,173), wf4(:,75), A(:,2486), n3(:,3514), t3x72(:,:,2486), nhel, den(16))
    call Hcont_QA(nsync, wf12(:,109), wf6(:,312), A(:,2487), n3(:,3515), t3x72(:,:,2487), nhel, den(8))
    call Hcont_QA(nsync, wf12(:,58), wf6(:,141), A(:,2488), n3(:,3516), t3x72(:,:,2488), nhel, den(8))
    call Hcont_QA(nsync, wf12(:,109), wf6(:,314), A(:,2489), n3(:,3517), t3x72(:,:,2489), nhel, den(8))
    call Hcont_QA(nsync, wf18(:,174), wf4(:,73), A(:,2490), n3(:,3518), t3x72(:,:,2490), nhel, den(19))
    call Hcont_QA(nsync, wf4(:,9), wf18(:,50), A(:,2491), n3(:,3519), t3x72(:,:,2491), nhel, den(19))
    call Hcont_QA(nsync, wf18(:,174), wf4(:,75), A(:,2492), n3(:,3520), t3x72(:,:,2492), nhel, den(19))
    call Hcont_QA(nsync, wf12(:,111), wf6(:,312), A(:,2493), n3(:,3521), t3x72(:,:,2493), nhel, den(10))
    call Hcont_QA(nsync, wf12(:,60), wf6(:,141), A(:,2494), n3(:,3522), t3x72(:,:,2494), nhel, den(10))
    call Hcont_QA(nsync, wf12(:,111), wf6(:,314), A(:,2495), n3(:,3523), t3x72(:,:,2495), nhel, den(10))
    call Hcont_QA(nsync, wf12(:,105), wf6(:,323), A(:,2496), n3(:,3524), t3x72(:,:,2496), nhel, den(21))
    call Hcont_QA(nsync, wf6(:,33), wf12(:,63), A(:,2497), n3(:,3525), t3x72(:,:,2497), nhel, den(21))
    call Hcont_QA(nsync, wf12(:,105), wf6(:,325), A(:,2498), n3(:,3526), t3x72(:,:,2498), nhel, den(21))
    call Hcont_QA(nsync, wf6(:,67), wf12(:,142), A(:,2499), n3(:,3527), t3x72(:,:,2499), nhel, den(12))
    call Hcont_QA(nsync, wf12(:,86), wf6(:,191), A(:,2500), n3(:,3528), t3x72(:,:,2500), nhel, den(20))
    call Hcont_VV(nsync, wf8(:,1), wf9(:,25), A(:,2501), n3(:,3529), t3x72(:,:,2501), nhel, den(32))
    call Hcont_VV(nsync, wf8(:,1), wf9(:,26), A(:,2502), n3(:,3530), t3x72(:,:,2502), nhel, den(32))
    call Hcont_VV(nsync, wf8(:,2), wf9(:,25), A(:,2503), n3(:,3531), t3x72(:,:,2503), nhel, den(34))
    call Hcont_VV(nsync, wf8(:,2), wf9(:,26), A(:,2504), n3(:,3532), t3x72(:,:,2504), nhel, den(34))
    call Hcont_QA(nsync, wf6(:,72), wf12(:,141), A(:,2505), n3(:,3533), t3x72(:,:,2505), nhel, den(10))
    call Hcont_QA(nsync, wf12(:,81), wf6(:,189), A(:,2506), n3(:,3534), t3x72(:,:,2506), nhel, den(21))
    call Hcont_VV(nsync, wf8(:,1), wf9(:,23), A(:,2507), n3(:,3535), t3x72(:,:,2507), nhel, den(32))
    call Hcont_VV(nsync, wf8(:,1), wf9(:,24), A(:,2508), n3(:,3536), t3x72(:,:,2508), nhel, den(32))
    call Hcont_VV(nsync, wf8(:,2), wf9(:,23), A(:,2509), n3(:,3537), t3x72(:,:,2509), nhel, den(34))
    call Hcont_VV(nsync, wf8(:,2), wf9(:,24), A(:,2510), n3(:,3538), t3x72(:,:,2510), nhel, den(34))
    call Hcont_QA(nsync, wf4(:,2), wf18(:,178), A(:,2511), n3(:,3539), t3x72(:,:,2511), nhel, den(11))
    call Hcont_QA(nsync, wf12(:,100), wf6(:,185), A(:,2512), n3(:,3540), t3x72(:,:,2512), nhel, den(29))
    call Hcont_VV(nsync, wf8(:,3), wf9(:,25), A(:,2513), n3(:,3541), t3x72(:,:,2513), nhel, den(35))
    call Hcont_VV(nsync, wf8(:,3), wf9(:,26), A(:,2514), n3(:,3542), t3x72(:,:,2514), nhel, den(35))
    call Hcont_VV(nsync, wf8(:,4), wf9(:,25), A(:,2515), n3(:,3543), t3x72(:,:,2515), nhel, den(36))
    call Hcont_VV(nsync, wf8(:,4), wf9(:,26), A(:,2516), n3(:,3544), t3x72(:,:,2516), nhel, den(36))
    call Hcont_QA(nsync, wf4(:,2), wf18(:,177), A(:,2517), n3(:,3545), t3x72(:,:,2517), nhel, den(5))
    call Hcont_QA(nsync, wf12(:,95), wf6(:,183), A(:,2518), n3(:,3546), t3x72(:,:,2518), nhel, den(30))
    call Hcont_VV(nsync, wf8(:,3), wf9(:,23), A(:,2519), n3(:,3547), t3x72(:,:,2519), nhel, den(35))
    call Hcont_VV(nsync, wf8(:,3), wf9(:,24), A(:,2520), n3(:,3548), t3x72(:,:,2520), nhel, den(35))
    call Hcont_VV(nsync, wf8(:,4), wf9(:,23), A(:,2521), n3(:,3549), t3x72(:,:,2521), nhel, den(36))
    call Hcont_VV(nsync, wf8(:,4), wf9(:,24), A(:,2522), n3(:,3550), t3x72(:,:,2522), nhel, den(36))
    call Hcont_QA(nsync, wf12(:,22), wf6(:,192), A(:,2523), n3(:,3551), t3x72(:,:,2523), nhel, den(8))
    call Hcont_QA(nsync, wf12(:,26), wf6(:,186), A(:,2524), n3(:,3552), t3x72(:,:,2524), nhel, den(3))
    call Hcont_QA(nsync, wf12(:,24), wf6(:,190), A(:,2525), n3(:,3553), t3x72(:,:,2525), nhel, den(3))
    call Hcont_QA(nsync, wf12(:,28), wf6(:,184), A(:,2526), n3(:,3554), t3x72(:,:,2526), nhel, den(8))
    call Hcont_QA(nsync, wf18(:,161), wf4(:,73), A(:,2527), n3(:,3555), t3x72(:,:,2527), nhel, den(16))
    call Hcont_QA(nsync, wf18(:,161), wf4(:,75), A(:,2528), n3(:,3556), t3x72(:,:,2528), nhel, den(16))
    call Hcont_QA(nsync, wf12(:,5), wf6(:,309), A(:,2529), n3(:,3557), t3x72(:,:,2529), nhel, den(14))
    call Hcont_QA(nsync, wf12(:,5), wf6(:,310), A(:,2530), n3(:,3558), t3x72(:,:,2530), nhel, den(14))
    call Hcont_QA(nsync, wf4(:,20), wf18(:,213), A(:,2531), n3(:,3559), t3x72(:,:,2531), nhel, den(5))
    call Hcont_QA(nsync, wf4(:,18), wf18(:,125), A(:,2532), n3(:,3560), t3x72(:,:,2532), nhel, den(5))
    call Hcont_QA(nsync, wf4(:,18), wf18(:,145), A(:,2533), n3(:,3561), t3x72(:,:,2533), nhel, den(5))
    call Hcont_QA(nsync, wf4(:,18), wf18(:,126), A(:,2534), n3(:,3562), t3x72(:,:,2534), nhel, den(5))
    call Hcont_QA(nsync, wf4(:,18), wf18(:,146), A(:,2535), n3(:,3563), t3x72(:,:,2535), nhel, den(5))
    call Hcont_QA(nsync, wf12(:,5), wf6(:,193), A(:,2536), n3(:,3564), t3x72(:,:,2536), nhel, den(14))
    call Hcont_QA(nsync, wf12(:,5), wf6(:,381), A(:,2537), n3(:,3565), t3x72(:,:,2537), nhel, den(14))
    call Hcont_QA(nsync, wf12(:,5), wf6(:,382), A(:,2538), n3(:,3566), t3x72(:,:,2538), nhel, den(14))
    call Hcont_QA(nsync, wf12(:,5), wf6(:,383), A(:,2539), n3(:,3567), t3x72(:,:,2539), nhel, den(14))
    call Hcont_QA(nsync, wf12(:,5), wf6(:,384), A(:,2540), n3(:,3568), t3x72(:,:,2540), nhel, den(14))
    call Hcont_VV(nsync, wf9(:,3), wf8(:,53), A(:,2541), n3(:,3569), t3x72(:,:,2541), nhel, den(38))
    call Hcont_VV(nsync, wf9(:,3), wf8(:,54), A(:,2542), n3(:,3570), t3x72(:,:,2542), nhel, den(38))
    call Hcont_QA(nsync, wf12(:,86), wf6(:,311), A(:,2543), n3(:,3571), t3x72(:,:,2543), nhel, den(20))
    call Hcont_QA(nsync, wf12(:,86), wf6(:,313), A(:,2544), n3(:,3572), t3x72(:,:,2544), nhel, den(20))
    call Hcont_QA(nsync, wf12(:,8), wf6(:,309), A(:,2545), n3(:,3573), t3x72(:,:,2545), nhel, den(21))
    call Hcont_QA(nsync, wf12(:,8), wf6(:,310), A(:,2546), n3(:,3574), t3x72(:,:,2546), nhel, den(21))
    call Hcont_QA(nsync, wf6(:,55), wf12(:,141), A(:,2547), n3(:,3575), t3x72(:,:,2547), nhel, den(10))
    call Hcont_QA(nsync, wf6(:,47), wf12(:,77), A(:,2548), n3(:,3576), t3x72(:,:,2548), nhel, den(10))
    call Hcont_QA(nsync, wf6(:,47), wf12(:,78), A(:,2549), n3(:,3577), t3x72(:,:,2549), nhel, den(10))
    call Hcont_QA(nsync, wf6(:,47), wf12(:,79), A(:,2550), n3(:,3578), t3x72(:,:,2550), nhel, den(10))
    call Hcont_QA(nsync, wf6(:,47), wf12(:,80), A(:,2551), n3(:,3579), t3x72(:,:,2551), nhel, den(10))
    call Hcont_VV(nsync, wf8(:,5), wf9(:,28), A(:,2552), n3(:,3580), t3x72(:,:,2552), nhel, den(59))
    call Hcont_QA(nsync, wf12(:,8), wf6(:,193), A(:,2553), n3(:,3581), t3x72(:,:,2553), nhel, den(21))
    call Hcont_QA(nsync, wf12(:,8), wf6(:,381), A(:,2554), n3(:,3582), t3x72(:,:,2554), nhel, den(21))
    call Hcont_QA(nsync, wf12(:,8), wf6(:,382), A(:,2555), n3(:,3583), t3x72(:,:,2555), nhel, den(21))
    call Hcont_QA(nsync, wf12(:,8), wf6(:,383), A(:,2556), n3(:,3584), t3x72(:,:,2556), nhel, den(21))
    call Hcont_QA(nsync, wf12(:,8), wf6(:,384), A(:,2557), n3(:,3585), t3x72(:,:,2557), nhel, den(21))
    call Hcont_QA(nsync, wf12(:,22), wf6(:,312), A(:,2558), n3(:,3586), t3x72(:,:,2558), nhel, den(8))
    call Hcont_QA(nsync, wf12(:,22), wf6(:,314), A(:,2559), n3(:,3587), t3x72(:,:,2559), nhel, den(8))
    call Hcont_QA(nsync, wf18(:,162), wf4(:,73), A(:,2560), n3(:,3588), t3x72(:,:,2560), nhel, den(19))
    call Hcont_QA(nsync, wf18(:,162), wf4(:,75), A(:,2561), n3(:,3589), t3x72(:,:,2561), nhel, den(19))
    call Hcont_QA(nsync, wf18(:,163), wf4(:,73), A(:,2562), n3(:,3590), t3x72(:,:,2562), nhel, den(65))
    call Hcont_QA(nsync, wf18(:,163), wf4(:,75), A(:,2563), n3(:,3591), t3x72(:,:,2563), nhel, den(65))
    call Hcont_QA(nsync, wf12(:,29), wf6(:,184), A(:,2564), n3(:,3592), t3x72(:,:,2564), nhel, den(8))
    call Hcont_QA(nsync, wf12(:,19), wf6(:,115), A(:,2565), n3(:,3593), t3x72(:,:,2565), nhel, den(8))
    call Hcont_QA(nsync, wf12(:,19), wf6(:,116), A(:,2566), n3(:,3594), t3x72(:,:,2566), nhel, den(8))
    call Hcont_QA(nsync, wf12(:,19), wf6(:,117), A(:,2567), n3(:,3595), t3x72(:,:,2567), nhel, den(8))
    call Hcont_QA(nsync, wf12(:,19), wf6(:,118), A(:,2568), n3(:,3596), t3x72(:,:,2568), nhel, den(8))
    call Hcont_QA(nsync, wf12(:,107), wf6(:,184), A(:,2569), n3(:,3597), t3x72(:,:,2569), nhel, den(11))
    call Hcont_QA(nsync, wf12(:,69), wf6(:,115), A(:,2570), n3(:,3598), t3x72(:,:,2570), nhel, den(11))
    call Hcont_QA(nsync, wf12(:,69), wf6(:,116), A(:,2571), n3(:,3599), t3x72(:,:,2571), nhel, den(11))
    call Hcont_QA(nsync, wf12(:,69), wf6(:,117), A(:,2572), n3(:,3600), t3x72(:,:,2572), nhel, den(11))
    call Hcont_QA(nsync, wf12(:,69), wf6(:,118), A(:,2573), n3(:,3601), t3x72(:,:,2573), nhel, den(11))
    call Hcont_VV(nsync, wf8(:,13), wf9(:,28), A(:,2574), n3(:,3602), t3x72(:,:,2574), nhel, den(60))
    call Hcont_QA(nsync, wf18(:,164), wf4(:,73), A(:,2575), n3(:,3603), t3x72(:,:,2575), nhel, den(19))
    call Hcont_QA(nsync, wf18(:,164), wf4(:,75), A(:,2576), n3(:,3604), t3x72(:,:,2576), nhel, den(19))
    call Hcont_QA(nsync, wf12(:,6), wf6(:,321), A(:,2577), n3(:,3605), t3x72(:,:,2577), nhel, den(18))
    call Hcont_QA(nsync, wf12(:,6), wf6(:,322), A(:,2578), n3(:,3606), t3x72(:,:,2578), nhel, den(18))
    call Hcont_QA(nsync, wf4(:,20), wf18(:,216), A(:,2579), n3(:,3607), t3x72(:,:,2579), nhel, den(11))
    call Hcont_QA(nsync, wf4(:,18), wf18(:,129), A(:,2580), n3(:,3608), t3x72(:,:,2580), nhel, den(11))
    call Hcont_QA(nsync, wf4(:,18), wf18(:,149), A(:,2581), n3(:,3609), t3x72(:,:,2581), nhel, den(11))
    call Hcont_QA(nsync, wf4(:,18), wf18(:,130), A(:,2582), n3(:,3610), t3x72(:,:,2582), nhel, den(11))
    call Hcont_QA(nsync, wf4(:,18), wf18(:,150), A(:,2583), n3(:,3611), t3x72(:,:,2583), nhel, den(11))
    call Hcont_QA(nsync, wf12(:,6), wf6(:,207), A(:,2584), n3(:,3612), t3x72(:,:,2584), nhel, den(18))
    call Hcont_QA(nsync, wf12(:,6), wf6(:,385), A(:,2585), n3(:,3613), t3x72(:,:,2585), nhel, den(18))
    call Hcont_QA(nsync, wf12(:,6), wf6(:,386), A(:,2586), n3(:,3614), t3x72(:,:,2586), nhel, den(18))
    call Hcont_QA(nsync, wf12(:,6), wf6(:,387), A(:,2587), n3(:,3615), t3x72(:,:,2587), nhel, den(18))
    call Hcont_QA(nsync, wf12(:,6), wf6(:,388), A(:,2588), n3(:,3616), t3x72(:,:,2588), nhel, den(18))
    call Hcont_VV(nsync, wf9(:,4), wf8(:,53), A(:,2589), n3(:,3617), t3x72(:,:,2589), nhel, den(38))
    call Hcont_VV(nsync, wf9(:,4), wf8(:,54), A(:,2590), n3(:,3618), t3x72(:,:,2590), nhel, den(38))
    call Hcont_QA(nsync, wf12(:,81), wf6(:,323), A(:,2591), n3(:,3619), t3x72(:,:,2591), nhel, den(21))
    call Hcont_QA(nsync, wf12(:,81), wf6(:,325), A(:,2592), n3(:,3620), t3x72(:,:,2592), nhel, den(21))
    call Hcont_QA(nsync, wf12(:,7), wf6(:,321), A(:,2593), n3(:,3621), t3x72(:,:,2593), nhel, den(20))
    call Hcont_QA(nsync, wf12(:,7), wf6(:,322), A(:,2594), n3(:,3622), t3x72(:,:,2594), nhel, den(20))
    call Hcont_QA(nsync, wf6(:,60), wf12(:,142), A(:,2595), n3(:,3623), t3x72(:,:,2595), nhel, den(12))
    call Hcont_QA(nsync, wf6(:,52), wf12(:,82), A(:,2596), n3(:,3624), t3x72(:,:,2596), nhel, den(12))
    call Hcont_QA(nsync, wf6(:,52), wf12(:,83), A(:,2597), n3(:,3625), t3x72(:,:,2597), nhel, den(12))
    call Hcont_QA(nsync, wf6(:,52), wf12(:,84), A(:,2598), n3(:,3626), t3x72(:,:,2598), nhel, den(12))
    call Hcont_QA(nsync, wf6(:,52), wf12(:,85), A(:,2599), n3(:,3627), t3x72(:,:,2599), nhel, den(12))
    call Hcont_VV(nsync, wf8(:,5), wf9(:,30), A(:,2600), n3(:,3628), t3x72(:,:,2600), nhel, den(59))
    call Hcont_QA(nsync, wf12(:,7), wf6(:,207), A(:,2601), n3(:,3629), t3x72(:,:,2601), nhel, den(20))
    call Hcont_QA(nsync, wf12(:,7), wf6(:,385), A(:,2602), n3(:,3630), t3x72(:,:,2602), nhel, den(20))
    call Hcont_QA(nsync, wf12(:,7), wf6(:,386), A(:,2603), n3(:,3631), t3x72(:,:,2603), nhel, den(20))
    call Hcont_QA(nsync, wf12(:,7), wf6(:,387), A(:,2604), n3(:,3632), t3x72(:,:,2604), nhel, den(20))
    call Hcont_QA(nsync, wf12(:,7), wf6(:,388), A(:,2605), n3(:,3633), t3x72(:,:,2605), nhel, den(20))
    call Hcont_QA(nsync, wf12(:,24), wf6(:,324), A(:,2606), n3(:,3634), t3x72(:,:,2606), nhel, den(3))
    call Hcont_QA(nsync, wf12(:,24), wf6(:,326), A(:,2607), n3(:,3635), t3x72(:,:,2607), nhel, den(3))
    call Hcont_QA(nsync, wf18(:,165), wf4(:,73), A(:,2608), n3(:,3636), t3x72(:,:,2608), nhel, den(16))
    call Hcont_QA(nsync, wf18(:,165), wf4(:,75), A(:,2609), n3(:,3637), t3x72(:,:,2609), nhel, den(16))
    call Hcont_QA(nsync, wf18(:,166), wf4(:,73), A(:,2610), n3(:,3638), t3x72(:,:,2610), nhel, den(65))
    call Hcont_QA(nsync, wf18(:,166), wf4(:,75), A(:,2611), n3(:,3639), t3x72(:,:,2611), nhel, den(65))
    call Hcont_QA(nsync, wf12(:,113), wf6(:,186), A(:,2612), n3(:,3640), t3x72(:,:,2612), nhel, den(3))
    call Hcont_QA(nsync, wf12(:,65), wf6(:,119), A(:,2613), n3(:,3641), t3x72(:,:,2613), nhel, den(3))
    call Hcont_QA(nsync, wf12(:,65), wf6(:,120), A(:,2614), n3(:,3642), t3x72(:,:,2614), nhel, den(3))
    call Hcont_QA(nsync, wf12(:,65), wf6(:,121), A(:,2615), n3(:,3643), t3x72(:,:,2615), nhel, den(3))
    call Hcont_QA(nsync, wf12(:,65), wf6(:,122), A(:,2616), n3(:,3644), t3x72(:,:,2616), nhel, den(3))
    call Hcont_QA(nsync, wf12(:,115), wf6(:,186), A(:,2617), n3(:,3645), t3x72(:,:,2617), nhel, den(5))
    call Hcont_QA(nsync, wf12(:,67), wf6(:,119), A(:,2618), n3(:,3646), t3x72(:,:,2618), nhel, den(5))
    call Hcont_QA(nsync, wf12(:,67), wf6(:,120), A(:,2619), n3(:,3647), t3x72(:,:,2619), nhel, den(5))
    call Hcont_QA(nsync, wf12(:,67), wf6(:,121), A(:,2620), n3(:,3648), t3x72(:,:,2620), nhel, den(5))
    call Hcont_QA(nsync, wf12(:,67), wf6(:,122), A(:,2621), n3(:,3649), t3x72(:,:,2621), nhel, den(5))
    call Hcont_VV(nsync, wf8(:,13), wf9(:,30), A(:,2622), n3(:,3650), t3x72(:,:,2622), nhel, den(60))
    call Hcont_VV(nsync, wf9(:,1), wf8(:,25), A(:,2623), n3(:,3651), t3x72(:,:,2623), nhel, den(56))
    call Hcont_VV(nsync, wf9(:,2), wf8(:,25), A(:,2624), n3(:,3652), t3x72(:,:,2624), nhel, den(56))
    call Hcont_VV(nsync, wf9(:,1), wf8(:,26), A(:,2625), n3(:,3653), t3x72(:,:,2625), nhel, den(57))
    call Hcont_VV(nsync, wf9(:,2), wf8(:,26), A(:,2626), n3(:,3654), t3x72(:,:,2626), nhel, den(57))
    call Hcont_VV(nsync, wf9(:,1), wf8(:,27), A(:,2627), n3(:,3655), t3x72(:,:,2627), nhel, den(53))
    call Hcont_VV(nsync, wf9(:,2), wf8(:,27), A(:,2628), n3(:,3656), t3x72(:,:,2628), nhel, den(53))
    call Hcont_VV(nsync, wf9(:,1), wf8(:,28), A(:,2629), n3(:,3657), t3x72(:,:,2629), nhel, den(55))
    call Hcont_VV(nsync, wf9(:,2), wf8(:,28), A(:,2630), n3(:,3658), t3x72(:,:,2630), nhel, den(55))
    call Hcont_QA(nsync, wf4(:,20), wf18(:,188), A(:,2631), n3(:,3659), t3x72(:,:,2631), nhel, den(39))
    call Hcont_QA(nsync, wf4(:,14), wf18(:,99), A(:,2632), n3(:,3660), t3x72(:,:,2632), nhel, den(39))
    call Hcont_QA(nsync, wf4(:,12), wf18(:,104), A(:,2633), n3(:,3661), t3x72(:,:,2633), nhel, den(38))
    call Hcont_QA(nsync, wf4(:,22), wf18(:,194), A(:,2634), n3(:,3662), t3x72(:,:,2634), nhel, den(38))
    call Hcont_QA(nsync, wf4(:,12), wf18(:,102), A(:,2635), n3(:,3663), t3x72(:,:,2635), nhel, den(10))
    call Hcont_QA(nsync, wf4(:,22), wf18(:,191), A(:,2636), n3(:,3664), t3x72(:,:,2636), nhel, den(10))
    call Hcont_QA(nsync, wf12(:,29), wf6(:,180), A(:,2637), n3(:,3665), t3x72(:,:,2637), nhel, den(8))
    call Hcont_QA(nsync, wf12(:,17), wf6(:,104), A(:,2638), n3(:,3666), t3x72(:,:,2638), nhel, den(8))
    call Hcont_QA(nsync, wf4(:,20), wf18(:,183), A(:,2639), n3(:,3667), t3x72(:,:,2639), nhel, den(5))
    call Hcont_QA(nsync, wf4(:,14), wf18(:,93), A(:,2640), n3(:,3668), t3x72(:,:,2640), nhel, den(5))
    call Hcont_QA(nsync, wf12(:,107), wf6(:,180), A(:,2641), n3(:,3669), t3x72(:,:,2641), nhel, den(11))
    call Hcont_QA(nsync, wf12(:,53), wf6(:,104), A(:,2642), n3(:,3670), t3x72(:,:,2642), nhel, den(11))
    call Hcont_QA(nsync, wf12(:,18), wf6(:,102), A(:,2643), n3(:,3671), t3x72(:,:,2643), nhel, den(3))
    call Hcont_QA(nsync, wf12(:,30), wf6(:,176), A(:,2644), n3(:,3672), t3x72(:,:,2644), nhel, den(3))
    call Hcont_QA(nsync, wf12(:,46), wf6(:,102), A(:,2645), n3(:,3673), t3x72(:,:,2645), nhel, den(12))
    call Hcont_QA(nsync, wf12(:,104), wf6(:,176), A(:,2646), n3(:,3674), t3x72(:,:,2646), nhel, den(12))
    call Hcont_QA(nsync, wf4(:,20), wf18(:,204), A(:,2647), n3(:,3675), t3x72(:,:,2647), nhel, den(39))
    call Hcont_QA(nsync, wf4(:,14), wf18(:,117), A(:,2648), n3(:,3676), t3x72(:,:,2648), nhel, den(39))
    call Hcont_QA(nsync, wf4(:,12), wf18(:,122), A(:,2649), n3(:,3677), t3x72(:,:,2649), nhel, den(38))
    call Hcont_QA(nsync, wf4(:,22), wf18(:,210), A(:,2650), n3(:,3678), t3x72(:,:,2650), nhel, den(38))
    call Hcont_QA(nsync, wf4(:,12), wf18(:,120), A(:,2651), n3(:,3679), t3x72(:,:,2651), nhel, den(12))
    call Hcont_QA(nsync, wf4(:,22), wf18(:,207), A(:,2652), n3(:,3680), t3x72(:,:,2652), nhel, den(12))
    call Hcont_QA(nsync, wf12(:,113), wf6(:,178), A(:,2653), n3(:,3681), t3x72(:,:,2653), nhel, den(3))
    call Hcont_QA(nsync, wf12(:,49), wf6(:,103), A(:,2654), n3(:,3682), t3x72(:,:,2654), nhel, den(3))
    call Hcont_QA(nsync, wf4(:,20), wf18(:,199), A(:,2655), n3(:,3683), t3x72(:,:,2655), nhel, den(11))
    call Hcont_QA(nsync, wf4(:,14), wf18(:,111), A(:,2656), n3(:,3684), t3x72(:,:,2656), nhel, den(11))
    call Hcont_QA(nsync, wf12(:,115), wf6(:,178), A(:,2657), n3(:,3685), t3x72(:,:,2657), nhel, den(5))
    call Hcont_QA(nsync, wf12(:,51), wf6(:,103), A(:,2658), n3(:,3686), t3x72(:,:,2658), nhel, den(5))
    call Hcont_QA(nsync, wf12(:,42), wf6(:,101), A(:,2659), n3(:,3687), t3x72(:,:,2659), nhel, den(8))
    call Hcont_QA(nsync, wf12(:,109), wf6(:,174), A(:,2660), n3(:,3688), t3x72(:,:,2660), nhel, den(8))
    call Hcont_QA(nsync, wf12(:,44), wf6(:,101), A(:,2661), n3(:,3689), t3x72(:,:,2661), nhel, den(10))
    call Hcont_QA(nsync, wf12(:,111), wf6(:,174), A(:,2662), n3(:,3690), t3x72(:,:,2662), nhel, den(10))
    call Hcont_QA(nsync, wf12(:,27), wf6(:,180), A(:,2663), n3(:,3691), t3x72(:,:,2663), nhel, den(11))
    call Hcont_QA(nsync, wf12(:,100), wf6(:,177), A(:,2664), n3(:,3692), t3x72(:,:,2664), nhel, den(29))
    call Hcont_QA(nsync, wf4(:,12), wf18(:,80), A(:,2665), n3(:,3693), t3x72(:,:,2665), nhel, den(12))
    call Hcont_QA(nsync, wf12(:,26), wf6(:,178), A(:,2666), n3(:,3694), t3x72(:,:,2666), nhel, den(3))
    call Hcont_QA(nsync, wf4(:,12), wf18(:,79), A(:,2667), n3(:,3695), t3x72(:,:,2667), nhel, den(10))
    call Hcont_QA(nsync, wf12(:,28), wf6(:,180), A(:,2668), n3(:,3696), t3x72(:,:,2668), nhel, den(8))
    call Hcont_VV(nsync, wf9(:,1), wf8(:,21), A(:,2669), n3(:,3697), t3x72(:,:,2669), nhel, den(53))
    call Hcont_VV(nsync, wf9(:,2), wf8(:,21), A(:,2670), n3(:,3698), t3x72(:,:,2670), nhel, den(53))
    call Hcont_VV(nsync, wf9(:,1), wf8(:,22), A(:,2671), n3(:,3699), t3x72(:,:,2671), nhel, den(55))
    call Hcont_VV(nsync, wf9(:,2), wf8(:,22), A(:,2672), n3(:,3700), t3x72(:,:,2672), nhel, den(55))
    call Hcont_QA(nsync, wf12(:,23), wf6(:,176), A(:,2673), n3(:,3701), t3x72(:,:,2673), nhel, den(12))
    call Hcont_QA(nsync, wf12(:,86), wf6(:,173), A(:,2674), n3(:,3702), t3x72(:,:,2674), nhel, den(20))
    call Hcont_QA(nsync, wf4(:,14), wf18(:,62), A(:,2675), n3(:,3703), t3x72(:,:,2675), nhel, den(11))
    call Hcont_QA(nsync, wf12(:,22), wf6(:,174), A(:,2676), n3(:,3704), t3x72(:,:,2676), nhel, den(8))
    call Hcont_QA(nsync, wf4(:,14), wf18(:,61), A(:,2677), n3(:,3705), t3x72(:,:,2677), nhel, den(5))
    call Hcont_QA(nsync, wf12(:,24), wf6(:,176), A(:,2678), n3(:,3706), t3x72(:,:,2678), nhel, den(3))
    call Hcont_VV(nsync, wf9(:,1), wf8(:,23), A(:,2679), n3(:,3707), t3x72(:,:,2679), nhel, den(56))
    call Hcont_VV(nsync, wf9(:,2), wf8(:,23), A(:,2680), n3(:,3708), t3x72(:,:,2680), nhel, den(56))
    call Hcont_VV(nsync, wf9(:,1), wf8(:,24), A(:,2681), n3(:,3709), t3x72(:,:,2681), nhel, den(57))
    call Hcont_VV(nsync, wf9(:,2), wf8(:,24), A(:,2682), n3(:,3710), t3x72(:,:,2682), nhel, den(57))
    call Hcont_QA(nsync, wf6(:,40), wf12(:,17), A(:,2683), n3(:,3711), t3x72(:,:,2683), nhel, den(8))
    call Hcont_QA(nsync, wf4(:,12), wf18(:,9), A(:,2684), n3(:,3712), t3x72(:,:,2684), nhel, den(10))
    call Hcont_QA(nsync, wf6(:,44), wf12(:,18), A(:,2685), n3(:,3713), t3x72(:,:,2685), nhel, den(3))
    call Hcont_QA(nsync, wf4(:,12), wf18(:,10), A(:,2686), n3(:,3714), t3x72(:,:,2686), nhel, den(12))
    call Hcont_QA(nsync, wf4(:,14), wf18(:,11), A(:,2687), n3(:,3715), t3x72(:,:,2687), nhel, den(5))
    call Hcont_QA(nsync, wf4(:,14), wf18(:,12), A(:,2688), n3(:,3716), t3x72(:,:,2688), nhel, den(11))
    call Hcont_QA(nsync, wf6(:,48), wf12(:,19), A(:,2689), n3(:,3717), t3x72(:,:,2689), nhel, den(8))
    call Hcont_QA(nsync, wf4(:,16), wf18(:,13), A(:,2690), n3(:,3718), t3x72(:,:,2690), nhel, den(10))
    call Hcont_QA(nsync, wf6(:,52), wf12(:,20), A(:,2691), n3(:,3719), t3x72(:,:,2691), nhel, den(3))
    call Hcont_QA(nsync, wf4(:,16), wf18(:,14), A(:,2692), n3(:,3720), t3x72(:,:,2692), nhel, den(12))
    call Hcont_QA(nsync, wf4(:,18), wf18(:,15), A(:,2693), n3(:,3721), t3x72(:,:,2693), nhel, den(5))
    call Hcont_QA(nsync, wf4(:,18), wf18(:,16), A(:,2694), n3(:,3722), t3x72(:,:,2694), nhel, den(11))
    call Hcont_VV(nsync, wf8(:,1), wf9(:,1), A(:,2695), n3(:,3723), t3x72(:,:,2695), nhel, den(32))
    call Hcont_VV(nsync, wf8(:,1), wf9(:,2), A(:,2696), n3(:,3724), t3x72(:,:,2696), nhel, den(32))
    call Hcont_VV(nsync, wf9(:,1), wf8(:,2), A(:,2697), n3(:,3725), t3x72(:,:,2697), nhel, den(34))
    call Hcont_VV(nsync, wf9(:,2), wf8(:,2), A(:,2698), n3(:,3726), t3x72(:,:,2698), nhel, den(34))
    call Hcont_VV(nsync, wf9(:,1), wf8(:,3), A(:,2699), n3(:,3727), t3x72(:,:,2699), nhel, den(35))
    call Hcont_VV(nsync, wf9(:,2), wf8(:,3), A(:,2700), n3(:,3728), t3x72(:,:,2700), nhel, den(35))
    call Hcont_VV(nsync, wf9(:,1), wf8(:,4), A(:,2701), n3(:,3729), t3x72(:,:,2701), nhel, den(36))
    call Hcont_VV(nsync, wf9(:,2), wf8(:,4), A(:,2702), n3(:,3730), t3x72(:,:,2702), nhel, den(36))
    call Hcont_QA(nsync, wf18(:,17), wf4(:,20), A(:,2703), n3(:,3731), t3x72(:,:,2703), nhel, den(5))
    call Hcont_QA(nsync, wf12(:,5), wf6(:,53), A(:,2704), n3(:,3732), t3x72(:,:,2704), nhel, den(14))
    call Hcont_VV(nsync, wf9(:,3), wf8(:,5), A(:,2705), n3(:,3733), t3x72(:,:,2705), nhel, den(38))
    call Hcont_QA(nsync, wf12(:,21), wf6(:,55), A(:,2706), n3(:,3734), t3x72(:,:,2706), nhel, den(10))
    call Hcont_QA(nsync, wf12(:,8), wf6(:,53), A(:,2707), n3(:,3735), t3x72(:,:,2707), nhel, den(21))
    call Hcont_QA(nsync, wf6(:,55), wf12(:,22), A(:,2708), n3(:,3736), t3x72(:,:,2708), nhel, den(8))
    call Hcont_QA(nsync, wf4(:,20), wf18(:,18), A(:,2709), n3(:,3737), t3x72(:,:,2709), nhel, den(11))
    call Hcont_QA(nsync, wf4(:,20), wf18(:,19), A(:,2710), n3(:,3738), t3x72(:,:,2710), nhel, den(39))
    call Hcont_QA(nsync, wf4(:,20), wf18(:,20), A(:,2711), n3(:,3739), t3x72(:,:,2711), nhel, den(11))
    call Hcont_QA(nsync, wf12(:,6), wf6(:,58), A(:,2712), n3(:,3740), t3x72(:,:,2712), nhel, den(18))
    call Hcont_VV(nsync, wf8(:,5), wf9(:,4), A(:,2713), n3(:,3741), t3x72(:,:,2713), nhel, den(38))
    call Hcont_QA(nsync, wf12(:,23), wf6(:,60), A(:,2714), n3(:,3742), t3x72(:,:,2714), nhel, den(12))
    call Hcont_QA(nsync, wf12(:,7), wf6(:,58), A(:,2715), n3(:,3743), t3x72(:,:,2715), nhel, den(20))
    call Hcont_QA(nsync, wf6(:,60), wf12(:,24), A(:,2716), n3(:,3744), t3x72(:,:,2716), nhel, den(3))
    call Hcont_QA(nsync, wf4(:,20), wf18(:,21), A(:,2717), n3(:,3745), t3x72(:,:,2717), nhel, den(5))
    call Hcont_QA(nsync, wf4(:,20), wf18(:,22), A(:,2718), n3(:,3746), t3x72(:,:,2718), nhel, den(39))
    call Hcont_QA(nsync, wf18(:,23), wf4(:,22), A(:,2719), n3(:,3747), t3x72(:,:,2719), nhel, den(10))
    call Hcont_QA(nsync, wf12(:,10), wf6(:,63), A(:,2720), n3(:,3748), t3x72(:,:,2720), nhel, den(23))
    call Hcont_VV(nsync, wf9(:,5), wf8(:,6), A(:,2721), n3(:,3749), t3x72(:,:,2721), nhel, den(39))
    call Hcont_QA(nsync, wf12(:,25), wf6(:,65), A(:,2722), n3(:,3750), t3x72(:,:,2722), nhel, den(5))
    call Hcont_QA(nsync, wf12(:,16), wf6(:,63), A(:,2723), n3(:,3751), t3x72(:,:,2723), nhel, den(30))
    call Hcont_QA(nsync, wf6(:,65), wf12(:,26), A(:,2724), n3(:,3752), t3x72(:,:,2724), nhel, den(3))
    call Hcont_QA(nsync, wf4(:,22), wf18(:,24), A(:,2725), n3(:,3753), t3x72(:,:,2725), nhel, den(12))
    call Hcont_QA(nsync, wf4(:,22), wf18(:,25), A(:,2726), n3(:,3754), t3x72(:,:,2726), nhel, den(38))
    call Hcont_QA(nsync, wf4(:,22), wf18(:,26), A(:,2727), n3(:,3755), t3x72(:,:,2727), nhel, den(12))
    call Hcont_QA(nsync, wf12(:,12), wf6(:,68), A(:,2728), n3(:,3756), t3x72(:,:,2728), nhel, den(27))
    call Hcont_VV(nsync, wf8(:,6), wf9(:,6), A(:,2729), n3(:,3757), t3x72(:,:,2729), nhel, den(39))
    call Hcont_QA(nsync, wf12(:,27), wf6(:,70), A(:,2730), n3(:,3758), t3x72(:,:,2730), nhel, den(11))
    call Hcont_QA(nsync, wf12(:,14), wf6(:,68), A(:,2731), n3(:,3759), t3x72(:,:,2731), nhel, den(29))
    call Hcont_QA(nsync, wf6(:,70), wf12(:,28), A(:,2732), n3(:,3760), t3x72(:,:,2732), nhel, den(8))
    call Hcont_QA(nsync, wf4(:,22), wf18(:,27), A(:,2733), n3(:,3761), t3x72(:,:,2733), nhel, den(10))
    call Hcont_QA(nsync, wf4(:,22), wf18(:,28), A(:,2734), n3(:,3762), t3x72(:,:,2734), nhel, den(38))
    call Hcont_QA(nsync, wf6(:,70), wf12(:,29), A(:,2735), n3(:,3763), t3x72(:,:,2735), nhel, den(8))
    call Hcont_QA(nsync, wf4(:,22), wf18(:,29), A(:,2736), n3(:,3764), t3x72(:,:,2736), nhel, den(10))
    call Hcont_QA(nsync, wf6(:,60), wf12(:,30), A(:,2737), n3(:,3765), t3x72(:,:,2737), nhel, den(3))
    call Hcont_QA(nsync, wf4(:,22), wf18(:,30), A(:,2738), n3(:,3766), t3x72(:,:,2738), nhel, den(12))
    call Hcont_QA(nsync, wf4(:,20), wf18(:,31), A(:,2739), n3(:,3767), t3x72(:,:,2739), nhel, den(5))
    call Hcont_QA(nsync, wf4(:,20), wf18(:,32), A(:,2740), n3(:,3768), t3x72(:,:,2740), nhel, den(11))
    call Hcont_QA(nsync, wf12(:,23), wf6(:,67), A(:,2741), n3(:,3769), t3x72(:,:,2741), nhel, den(12))
    call Hcont_QA(nsync, wf12(:,21), wf6(:,72), A(:,2742), n3(:,3770), t3x72(:,:,2742), nhel, den(10))
    call Hcont_QA(nsync, wf6(:,57), wf12(:,27), A(:,2743), n3(:,3771), t3x72(:,:,2743), nhel, den(11))
    call Hcont_QA(nsync, wf6(:,62), wf12(:,25), A(:,2744), n3(:,3772), t3x72(:,:,2744), nhel, den(5))
    call Hcont_QA(nsync, wf12(:,22), wf6(:,72), A(:,2745), n3(:,3773), t3x72(:,:,2745), nhel, den(8))
    call Hcont_QA(nsync, wf12(:,24), wf6(:,67), A(:,2746), n3(:,3774), t3x72(:,:,2746), nhel, den(3))
    call Hcont_QA(nsync, wf12(:,17), wf6(:,48), A(:,2747), n3(:,3775), t3x72(:,:,2747), nhel, den(8))
    call Hcont_QA(nsync, wf18(:,9), wf4(:,16), A(:,2748), n3(:,3776), t3x72(:,:,2748), nhel, den(10))
    call Hcont_QA(nsync, wf6(:,44), wf12(:,20), A(:,2749), n3(:,3777), t3x72(:,:,2749), nhel, den(3))
    call Hcont_QA(nsync, wf18(:,10), wf4(:,16), A(:,2750), n3(:,3778), t3x72(:,:,2750), nhel, den(12))
    call Hcont_QA(nsync, wf4(:,14), wf18(:,15), A(:,2751), n3(:,3779), t3x72(:,:,2751), nhel, den(5))
    call Hcont_QA(nsync, wf4(:,14), wf18(:,16), A(:,2752), n3(:,3780), t3x72(:,:,2752), nhel, den(11))
    call Hcont_QA(nsync, wf6(:,40), wf12(:,19), A(:,2753), n3(:,3781), t3x72(:,:,2753), nhel, den(8))
    call Hcont_QA(nsync, wf4(:,12), wf18(:,13), A(:,2754), n3(:,3782), t3x72(:,:,2754), nhel, den(10))
    call Hcont_QA(nsync, wf12(:,18), wf6(:,52), A(:,2755), n3(:,3783), t3x72(:,:,2755), nhel, den(3))
    call Hcont_QA(nsync, wf4(:,12), wf18(:,14), A(:,2756), n3(:,3784), t3x72(:,:,2756), nhel, den(12))
    call Hcont_QA(nsync, wf18(:,11), wf4(:,18), A(:,2757), n3(:,3785), t3x72(:,:,2757), nhel, den(5))
    call Hcont_QA(nsync, wf18(:,12), wf4(:,18), A(:,2758), n3(:,3786), t3x72(:,:,2758), nhel, den(11))
    call Hcont_QA(nsync, wf12(:,41), wf6(:,89), A(:,2759), n3(:,3787), t3x72(:,:,2759), nhel, den(14))
    call Hcont_QA(nsync, wf18(:,41), wf4(:,31), A(:,2760), n3(:,3788), t3x72(:,:,2760), nhel, den(16))
    call Hcont_QA(nsync, wf12(:,43), wf6(:,90), A(:,2761), n3(:,3789), t3x72(:,:,2761), nhel, den(18))
    call Hcont_QA(nsync, wf4(:,31), wf18(:,42), A(:,2762), n3(:,3790), t3x72(:,:,2762), nhel, den(19))
    call Hcont_QA(nsync, wf6(:,90), wf12(:,45), A(:,2763), n3(:,3791), t3x72(:,:,2763), nhel, den(20))
    call Hcont_QA(nsync, wf6(:,89), wf12(:,47), A(:,2764), n3(:,3792), t3x72(:,:,2764), nhel, den(21))
    call Hcont_QA(nsync, wf12(:,48), wf6(:,91), A(:,2765), n3(:,3793), t3x72(:,:,2765), nhel, den(23))
    call Hcont_QA(nsync, wf18(:,43), wf4(:,32), A(:,2766), n3(:,3794), t3x72(:,:,2766), nhel, den(25))
    call Hcont_QA(nsync, wf12(:,50), wf6(:,92), A(:,2767), n3(:,3795), t3x72(:,:,2767), nhel, den(27))
    call Hcont_QA(nsync, wf4(:,32), wf18(:,44), A(:,2768), n3(:,3796), t3x72(:,:,2768), nhel, den(28))
    call Hcont_QA(nsync, wf6(:,92), wf12(:,52), A(:,2769), n3(:,3797), t3x72(:,:,2769), nhel, den(29))
    call Hcont_QA(nsync, wf6(:,91), wf12(:,54), A(:,2770), n3(:,3798), t3x72(:,:,2770), nhel, den(30))
    call Hcont_QA(nsync, wf12(:,57), wf6(:,97), A(:,2771), n3(:,3799), t3x72(:,:,2771), nhel, den(14))
    call Hcont_QA(nsync, wf18(:,49), wf4(:,35), A(:,2772), n3(:,3800), t3x72(:,:,2772), nhel, den(16))
    call Hcont_QA(nsync, wf12(:,59), wf6(:,98), A(:,2773), n3(:,3801), t3x72(:,:,2773), nhel, den(18))
    call Hcont_QA(nsync, wf4(:,35), wf18(:,50), A(:,2774), n3(:,3802), t3x72(:,:,2774), nhel, den(19))
    call Hcont_QA(nsync, wf6(:,98), wf12(:,61), A(:,2775), n3(:,3803), t3x72(:,:,2775), nhel, den(20))
    call Hcont_QA(nsync, wf6(:,97), wf12(:,63), A(:,2776), n3(:,3804), t3x72(:,:,2776), nhel, den(21))
    call Hcont_QA(nsync, wf12(:,64), wf6(:,99), A(:,2777), n3(:,3805), t3x72(:,:,2777), nhel, den(23))
    call Hcont_QA(nsync, wf18(:,51), wf4(:,36), A(:,2778), n3(:,3806), t3x72(:,:,2778), nhel, den(25))
    call Hcont_QA(nsync, wf12(:,66), wf6(:,100), A(:,2779), n3(:,3807), t3x72(:,:,2779), nhel, den(27))
    call Hcont_QA(nsync, wf4(:,36), wf18(:,52), A(:,2780), n3(:,3808), t3x72(:,:,2780), nhel, den(28))
    call Hcont_QA(nsync, wf6(:,100), wf12(:,68), A(:,2781), n3(:,3809), t3x72(:,:,2781), nhel, den(29))
    call Hcont_QA(nsync, wf6(:,99), wf12(:,70), A(:,2782), n3(:,3810), t3x72(:,:,2782), nhel, den(30))
    call Hcont_VV(nsync, wf24(:,9), wf3(:,9), A(:,2783), n3(:,3811), t3x72(:,:,2783), nhel, den(10))
    call Hcont_VV(nsync, wf24(:,9), wf3(:,10), A(:,2784), n3(:,3812), t3x72(:,:,2784), nhel, den(10))
    call Hcont_VV(nsync, wf24(:,9), wf3(:,9), A(:,2785), n3(:,3813), t3x72(:,:,2785), nhel, den(10))
    call Hcont_VV(nsync, wf24(:,9), wf3(:,10), A(:,2786), n3(:,3814), t3x72(:,:,2786), nhel, den(10))
    call Hcont_VV(nsync, wf24(:,10), wf3(:,11), A(:,2787), n3(:,3815), t3x72(:,:,2787), nhel, den(21))
    call Hcont_VV(nsync, wf24(:,10), wf3(:,12), A(:,2788), n3(:,3816), t3x72(:,:,2788), nhel, den(21))
    call Hcont_VV(nsync, wf24(:,10), wf3(:,11), A(:,2789), n3(:,3817), t3x72(:,:,2789), nhel, den(21))
    call Hcont_VV(nsync, wf24(:,10), wf3(:,12), A(:,2790), n3(:,3818), t3x72(:,:,2790), nhel, den(21))
    call Hcont_VV(nsync, wf3(:,9), wf24(:,11), A(:,2791), n3(:,3819), t3x72(:,:,2791), nhel, den(32))
    call Hcont_VV(nsync, wf3(:,10), wf24(:,11), A(:,2792), n3(:,3820), t3x72(:,:,2792), nhel, den(32))
    call Hcont_VV(nsync, wf3(:,11), wf24(:,12), A(:,2793), n3(:,3821), t3x72(:,:,2793), nhel, den(32))
    call Hcont_VV(nsync, wf3(:,12), wf24(:,12), A(:,2794), n3(:,3822), t3x72(:,:,2794), nhel, den(32))
    call Hcont_VV(nsync, wf3(:,9), wf24(:,13), A(:,2795), n3(:,3823), t3x72(:,:,2795), nhel, den(34))
    call Hcont_VV(nsync, wf3(:,10), wf24(:,13), A(:,2796), n3(:,3824), t3x72(:,:,2796), nhel, den(34))
    call Hcont_VV(nsync, wf3(:,11), wf24(:,14), A(:,2797), n3(:,3825), t3x72(:,:,2797), nhel, den(34))
    call Hcont_VV(nsync, wf3(:,12), wf24(:,14), A(:,2798), n3(:,3826), t3x72(:,:,2798), nhel, den(34))
    call Hcont_VV(nsync, wf3(:,9), wf24(:,11), A(:,2799), n3(:,3827), t3x72(:,:,2799), nhel, den(32))
    call Hcont_VV(nsync, wf3(:,10), wf24(:,11), A(:,2800), n3(:,3828), t3x72(:,:,2800), nhel, den(32))
    call Hcont_VV(nsync, wf3(:,11), wf24(:,12), A(:,2801), n3(:,3829), t3x72(:,:,2801), nhel, den(32))
    call Hcont_VV(nsync, wf3(:,12), wf24(:,12), A(:,2802), n3(:,3830), t3x72(:,:,2802), nhel, den(32))
    call Hcont_VV(nsync, wf3(:,9), wf24(:,13), A(:,2803), n3(:,3831), t3x72(:,:,2803), nhel, den(34))
    call Hcont_VV(nsync, wf3(:,10), wf24(:,13), A(:,2804), n3(:,3832), t3x72(:,:,2804), nhel, den(34))
    call Hcont_VV(nsync, wf3(:,11), wf24(:,14), A(:,2805), n3(:,3833), t3x72(:,:,2805), nhel, den(34))
    call Hcont_VV(nsync, wf3(:,12), wf24(:,14), A(:,2806), n3(:,3834), t3x72(:,:,2806), nhel, den(34))
    call Hcont_VV(nsync, wf24(:,15), wf3(:,13), A(:,2807), n3(:,3835), t3x72(:,:,2807), nhel, den(12))
    call Hcont_VV(nsync, wf24(:,15), wf3(:,14), A(:,2808), n3(:,3836), t3x72(:,:,2808), nhel, den(12))
    call Hcont_VV(nsync, wf24(:,15), wf3(:,13), A(:,2809), n3(:,3837), t3x72(:,:,2809), nhel, den(12))
    call Hcont_VV(nsync, wf24(:,15), wf3(:,14), A(:,2810), n3(:,3838), t3x72(:,:,2810), nhel, den(12))
    call Hcont_VV(nsync, wf24(:,16), wf3(:,15), A(:,2811), n3(:,3839), t3x72(:,:,2811), nhel, den(20))
    call Hcont_VV(nsync, wf24(:,16), wf3(:,16), A(:,2812), n3(:,3840), t3x72(:,:,2812), nhel, den(20))
    call Hcont_VV(nsync, wf24(:,16), wf3(:,15), A(:,2813), n3(:,3841), t3x72(:,:,2813), nhel, den(20))
    call Hcont_VV(nsync, wf24(:,16), wf3(:,16), A(:,2814), n3(:,3842), t3x72(:,:,2814), nhel, den(20))
    call Hcont_VV(nsync, wf3(:,13), wf24(:,17), A(:,2815), n3(:,3843), t3x72(:,:,2815), nhel, den(32))
    call Hcont_VV(nsync, wf3(:,14), wf24(:,17), A(:,2816), n3(:,3844), t3x72(:,:,2816), nhel, den(32))
    call Hcont_VV(nsync, wf3(:,15), wf24(:,18), A(:,2817), n3(:,3845), t3x72(:,:,2817), nhel, den(32))
    call Hcont_VV(nsync, wf3(:,16), wf24(:,18), A(:,2818), n3(:,3846), t3x72(:,:,2818), nhel, den(32))
    call Hcont_VV(nsync, wf3(:,13), wf24(:,19), A(:,2819), n3(:,3847), t3x72(:,:,2819), nhel, den(34))
    call Hcont_VV(nsync, wf3(:,14), wf24(:,19), A(:,2820), n3(:,3848), t3x72(:,:,2820), nhel, den(34))
    call Hcont_VV(nsync, wf3(:,15), wf24(:,20), A(:,2821), n3(:,3849), t3x72(:,:,2821), nhel, den(34))
    call Hcont_VV(nsync, wf3(:,16), wf24(:,20), A(:,2822), n3(:,3850), t3x72(:,:,2822), nhel, den(34))
    call Hcont_VV(nsync, wf3(:,13), wf24(:,17), A(:,2823), n3(:,3851), t3x72(:,:,2823), nhel, den(32))
    call Hcont_VV(nsync, wf3(:,14), wf24(:,17), A(:,2824), n3(:,3852), t3x72(:,:,2824), nhel, den(32))
    call Hcont_VV(nsync, wf3(:,15), wf24(:,18), A(:,2825), n3(:,3853), t3x72(:,:,2825), nhel, den(32))
    call Hcont_VV(nsync, wf3(:,16), wf24(:,18), A(:,2826), n3(:,3854), t3x72(:,:,2826), nhel, den(32))
    call Hcont_VV(nsync, wf3(:,13), wf24(:,19), A(:,2827), n3(:,3855), t3x72(:,:,2827), nhel, den(34))
    call Hcont_VV(nsync, wf3(:,14), wf24(:,19), A(:,2828), n3(:,3856), t3x72(:,:,2828), nhel, den(34))
    call Hcont_VV(nsync, wf3(:,15), wf24(:,20), A(:,2829), n3(:,3857), t3x72(:,:,2829), nhel, den(34))
    call Hcont_VV(nsync, wf3(:,16), wf24(:,20), A(:,2830), n3(:,3858), t3x72(:,:,2830), nhel, den(34))
    call Hcont_VV(nsync, wf3(:,11), wf24(:,21), A(:,2831), n3(:,3859), t3x72(:,:,2831), nhel, den(5))
    call Hcont_VV(nsync, wf3(:,12), wf24(:,21), A(:,2832), n3(:,3860), t3x72(:,:,2832), nhel, den(5))
    call Hcont_VV(nsync, wf3(:,11), wf24(:,21), A(:,2833), n3(:,3861), t3x72(:,:,2833), nhel, den(5))
    call Hcont_VV(nsync, wf3(:,12), wf24(:,21), A(:,2834), n3(:,3862), t3x72(:,:,2834), nhel, den(5))
    call Hcont_VV(nsync, wf3(:,9), wf24(:,22), A(:,2835), n3(:,3863), t3x72(:,:,2835), nhel, den(30))
    call Hcont_VV(nsync, wf3(:,10), wf24(:,22), A(:,2836), n3(:,3864), t3x72(:,:,2836), nhel, den(30))
    call Hcont_VV(nsync, wf3(:,9), wf24(:,22), A(:,2837), n3(:,3865), t3x72(:,:,2837), nhel, den(30))
    call Hcont_VV(nsync, wf3(:,10), wf24(:,22), A(:,2838), n3(:,3866), t3x72(:,:,2838), nhel, den(30))
    call Hcont_VV(nsync, wf3(:,9), wf24(:,23), A(:,2839), n3(:,3867), t3x72(:,:,2839), nhel, den(35))
    call Hcont_VV(nsync, wf3(:,10), wf24(:,23), A(:,2840), n3(:,3868), t3x72(:,:,2840), nhel, den(35))
    call Hcont_VV(nsync, wf3(:,11), wf24(:,24), A(:,2841), n3(:,3869), t3x72(:,:,2841), nhel, den(35))
    call Hcont_VV(nsync, wf3(:,12), wf24(:,24), A(:,2842), n3(:,3870), t3x72(:,:,2842), nhel, den(35))
    call Hcont_VV(nsync, wf3(:,9), wf24(:,25), A(:,2843), n3(:,3871), t3x72(:,:,2843), nhel, den(36))
    call Hcont_VV(nsync, wf3(:,10), wf24(:,25), A(:,2844), n3(:,3872), t3x72(:,:,2844), nhel, den(36))
    call Hcont_VV(nsync, wf3(:,11), wf24(:,26), A(:,2845), n3(:,3873), t3x72(:,:,2845), nhel, den(36))
    call Hcont_VV(nsync, wf3(:,12), wf24(:,26), A(:,2846), n3(:,3874), t3x72(:,:,2846), nhel, den(36))
    call Hcont_VV(nsync, wf3(:,9), wf24(:,23), A(:,2847), n3(:,3875), t3x72(:,:,2847), nhel, den(35))
    call Hcont_VV(nsync, wf3(:,10), wf24(:,23), A(:,2848), n3(:,3876), t3x72(:,:,2848), nhel, den(35))
    call Hcont_VV(nsync, wf3(:,11), wf24(:,24), A(:,2849), n3(:,3877), t3x72(:,:,2849), nhel, den(35))
    call Hcont_VV(nsync, wf3(:,12), wf24(:,24), A(:,2850), n3(:,3878), t3x72(:,:,2850), nhel, den(35))
    call Hcont_VV(nsync, wf3(:,9), wf24(:,25), A(:,2851), n3(:,3879), t3x72(:,:,2851), nhel, den(36))
    call Hcont_VV(nsync, wf3(:,10), wf24(:,25), A(:,2852), n3(:,3880), t3x72(:,:,2852), nhel, den(36))
    call Hcont_VV(nsync, wf3(:,11), wf24(:,26), A(:,2853), n3(:,3881), t3x72(:,:,2853), nhel, den(36))
    call Hcont_VV(nsync, wf3(:,12), wf24(:,26), A(:,2854), n3(:,3882), t3x72(:,:,2854), nhel, den(36))
    call Hcont_VV(nsync, wf3(:,15), wf24(:,27), A(:,2855), n3(:,3883), t3x72(:,:,2855), nhel, den(11))
    call Hcont_VV(nsync, wf3(:,16), wf24(:,27), A(:,2856), n3(:,3884), t3x72(:,:,2856), nhel, den(11))
    call Hcont_VV(nsync, wf3(:,15), wf24(:,27), A(:,2857), n3(:,3885), t3x72(:,:,2857), nhel, den(11))
    call Hcont_VV(nsync, wf3(:,16), wf24(:,27), A(:,2858), n3(:,3886), t3x72(:,:,2858), nhel, den(11))
    call Hcont_VV(nsync, wf3(:,13), wf24(:,28), A(:,2859), n3(:,3887), t3x72(:,:,2859), nhel, den(29))
    call Hcont_VV(nsync, wf3(:,14), wf24(:,28), A(:,2860), n3(:,3888), t3x72(:,:,2860), nhel, den(29))
    call Hcont_VV(nsync, wf3(:,13), wf24(:,28), A(:,2861), n3(:,3889), t3x72(:,:,2861), nhel, den(29))
    call Hcont_VV(nsync, wf3(:,14), wf24(:,28), A(:,2862), n3(:,3890), t3x72(:,:,2862), nhel, den(29))
    call Hcont_VV(nsync, wf3(:,13), wf24(:,29), A(:,2863), n3(:,3891), t3x72(:,:,2863), nhel, den(35))
    call Hcont_VV(nsync, wf3(:,14), wf24(:,29), A(:,2864), n3(:,3892), t3x72(:,:,2864), nhel, den(35))
    call Hcont_VV(nsync, wf3(:,15), wf24(:,30), A(:,2865), n3(:,3893), t3x72(:,:,2865), nhel, den(35))
    call Hcont_VV(nsync, wf3(:,16), wf24(:,30), A(:,2866), n3(:,3894), t3x72(:,:,2866), nhel, den(35))
    call Hcont_VV(nsync, wf3(:,13), wf24(:,31), A(:,2867), n3(:,3895), t3x72(:,:,2867), nhel, den(36))
    call Hcont_VV(nsync, wf3(:,14), wf24(:,31), A(:,2868), n3(:,3896), t3x72(:,:,2868), nhel, den(36))
    call Hcont_VV(nsync, wf3(:,15), wf24(:,32), A(:,2869), n3(:,3897), t3x72(:,:,2869), nhel, den(36))
    call Hcont_VV(nsync, wf3(:,16), wf24(:,32), A(:,2870), n3(:,3898), t3x72(:,:,2870), nhel, den(36))
    call Hcont_VV(nsync, wf3(:,13), wf24(:,29), A(:,2871), n3(:,3899), t3x72(:,:,2871), nhel, den(35))
    call Hcont_VV(nsync, wf3(:,14), wf24(:,29), A(:,2872), n3(:,3900), t3x72(:,:,2872), nhel, den(35))
    call Hcont_VV(nsync, wf3(:,15), wf24(:,30), A(:,2873), n3(:,3901), t3x72(:,:,2873), nhel, den(35))
    call Hcont_VV(nsync, wf3(:,16), wf24(:,30), A(:,2874), n3(:,3902), t3x72(:,:,2874), nhel, den(35))
    call Hcont_VV(nsync, wf3(:,13), wf24(:,31), A(:,2875), n3(:,3903), t3x72(:,:,2875), nhel, den(36))
    call Hcont_VV(nsync, wf3(:,14), wf24(:,31), A(:,2876), n3(:,3904), t3x72(:,:,2876), nhel, den(36))
    call Hcont_VV(nsync, wf3(:,15), wf24(:,32), A(:,2877), n3(:,3905), t3x72(:,:,2877), nhel, den(36))
    call Hcont_VV(nsync, wf3(:,16), wf24(:,32), A(:,2878), n3(:,3906), t3x72(:,:,2878), nhel, den(36))
    call Hcont_QA(nsync, wf12(:,87), wf6(:,161), A(:,2879), n3(:,3907), t3x72(:,:,2879), nhel, den(14))
    call Hcont_QA(nsync, wf12(:,87), wf6(:,162), A(:,2880), n3(:,3908), t3x72(:,:,2880), nhel, den(14))
    call Hcont_QA(nsync, wf12(:,87), wf6(:,161), A(:,2881), n3(:,3909), t3x72(:,:,2881), nhel, den(14))
    call Hcont_QA(nsync, wf12(:,87), wf6(:,162), A(:,2882), n3(:,3910), t3x72(:,:,2882), nhel, den(14))
    call Hcont_QA(nsync, wf12(:,101), wf6(:,163), A(:,2883), n3(:,3911), t3x72(:,:,2883), nhel, den(23))
    call Hcont_QA(nsync, wf12(:,101), wf6(:,164), A(:,2884), n3(:,3912), t3x72(:,:,2884), nhel, den(23))
    call Hcont_QA(nsync, wf12(:,101), wf6(:,163), A(:,2885), n3(:,3913), t3x72(:,:,2885), nhel, den(23))
    call Hcont_QA(nsync, wf12(:,101), wf6(:,164), A(:,2886), n3(:,3914), t3x72(:,:,2886), nhel, den(23))
    call Hcont_QA(nsync, wf12(:,89), wf6(:,165), A(:,2887), n3(:,3915), t3x72(:,:,2887), nhel, den(18))
    call Hcont_QA(nsync, wf12(:,89), wf6(:,166), A(:,2888), n3(:,3916), t3x72(:,:,2888), nhel, den(18))
    call Hcont_QA(nsync, wf12(:,89), wf6(:,165), A(:,2889), n3(:,3917), t3x72(:,:,2889), nhel, den(18))
    call Hcont_QA(nsync, wf12(:,89), wf6(:,166), A(:,2890), n3(:,3918), t3x72(:,:,2890), nhel, den(18))
    call Hcont_QA(nsync, wf12(:,102), wf6(:,167), A(:,2891), n3(:,3919), t3x72(:,:,2891), nhel, den(27))
    call Hcont_QA(nsync, wf12(:,102), wf6(:,168), A(:,2892), n3(:,3920), t3x72(:,:,2892), nhel, den(27))
    call Hcont_QA(nsync, wf12(:,102), wf6(:,167), A(:,2893), n3(:,3921), t3x72(:,:,2893), nhel, den(27))
    call Hcont_QA(nsync, wf12(:,102), wf6(:,168), A(:,2894), n3(:,3922), t3x72(:,:,2894), nhel, den(27))
    call Hcont_VV(nsync, wf3(:,9), wf24(:,33), A(:,2895), n3(:,3923), t3x72(:,:,2895), nhel, den(5))
    call Hcont_VV(nsync, wf3(:,10), wf24(:,33), A(:,2896), n3(:,3924), t3x72(:,:,2896), nhel, den(5))
    call Hcont_VV(nsync, wf3(:,9), wf24(:,33), A(:,2897), n3(:,3925), t3x72(:,:,2897), nhel, den(5))
    call Hcont_VV(nsync, wf3(:,10), wf24(:,33), A(:,2898), n3(:,3926), t3x72(:,:,2898), nhel, den(5))
    call Hcont_VV(nsync, wf3(:,9), wf24(:,34), A(:,2899), n3(:,3927), t3x72(:,:,2899), nhel, den(14))
    call Hcont_VV(nsync, wf3(:,10), wf24(:,34), A(:,2900), n3(:,3928), t3x72(:,:,2900), nhel, den(14))
    call Hcont_VV(nsync, wf3(:,9), wf24(:,34), A(:,2901), n3(:,3929), t3x72(:,:,2901), nhel, den(14))
    call Hcont_VV(nsync, wf3(:,10), wf24(:,34), A(:,2902), n3(:,3930), t3x72(:,:,2902), nhel, den(14))
    call Hcont_QA(nsync, wf36(:,1), wf2(:,17), A(:,2903), n3(:,3931), t3x72(:,:,2903), nhel, den(16))
    call Hcont_QA(nsync, wf2(:,17), wf36(:,2), A(:,2904), n3(:,3932), t3x72(:,:,2904), nhel, den(14))
    call Hcont_VV(nsync, wf3(:,9), wf24(:,35), A(:,2905), n3(:,3933), t3x72(:,:,2905), nhel, den(10))
    call Hcont_VV(nsync, wf3(:,10), wf24(:,35), A(:,2906), n3(:,3934), t3x72(:,:,2906), nhel, den(10))
    call Hcont_VV(nsync, wf3(:,9), wf24(:,35), A(:,2907), n3(:,3935), t3x72(:,:,2907), nhel, den(10))
    call Hcont_VV(nsync, wf3(:,10), wf24(:,35), A(:,2908), n3(:,3936), t3x72(:,:,2908), nhel, den(10))
    call Hcont_VV(nsync, wf3(:,9), wf24(:,36), A(:,2909), n3(:,3937), t3x72(:,:,2909), nhel, den(59))
    call Hcont_VV(nsync, wf3(:,10), wf24(:,36), A(:,2910), n3(:,3938), t3x72(:,:,2910), nhel, den(59))
    call Hcont_VV(nsync, wf3(:,9), wf24(:,36), A(:,2911), n3(:,3939), t3x72(:,:,2911), nhel, den(59))
    call Hcont_VV(nsync, wf3(:,10), wf24(:,36), A(:,2912), n3(:,3940), t3x72(:,:,2912), nhel, den(59))
    call Hcont_VV(nsync, wf3(:,9), wf24(:,37), A(:,2913), n3(:,3941), t3x72(:,:,2913), nhel, den(21))
    call Hcont_VV(nsync, wf3(:,10), wf24(:,37), A(:,2914), n3(:,3942), t3x72(:,:,2914), nhel, den(21))
    call Hcont_VV(nsync, wf3(:,9), wf24(:,37), A(:,2915), n3(:,3943), t3x72(:,:,2915), nhel, den(21))
    call Hcont_VV(nsync, wf3(:,10), wf24(:,37), A(:,2916), n3(:,3944), t3x72(:,:,2916), nhel, den(21))
    call Hcont_QA(nsync, wf2(:,17), wf36(:,3), A(:,2917), n3(:,3945), t3x72(:,:,2917), nhel, den(38))
    call Hcont_QA(nsync, wf2(:,17), wf36(:,4), A(:,2918), n3(:,3946), t3x72(:,:,2918), nhel, den(20))
    call Hcont_QA(nsync, wf2(:,17), wf36(:,5), A(:,2919), n3(:,3947), t3x72(:,:,2919), nhel, den(21))
    call Hcont_QA(nsync, wf12(:,106), wf6(:,163), A(:,2920), n3(:,3948), t3x72(:,:,2920), nhel, den(23))
    call Hcont_QA(nsync, wf12(:,106), wf6(:,164), A(:,2921), n3(:,3949), t3x72(:,:,2921), nhel, den(23))
    call Hcont_QA(nsync, wf12(:,106), wf6(:,163), A(:,2922), n3(:,3950), t3x72(:,:,2922), nhel, den(23))
    call Hcont_QA(nsync, wf12(:,106), wf6(:,164), A(:,2923), n3(:,3951), t3x72(:,:,2923), nhel, den(23))
    call Hcont_QA(nsync, wf12(:,108), wf6(:,163), A(:,2924), n3(:,3952), t3x72(:,:,2924), nhel, den(30))
    call Hcont_QA(nsync, wf12(:,108), wf6(:,164), A(:,2925), n3(:,3953), t3x72(:,:,2925), nhel, den(30))
    call Hcont_QA(nsync, wf12(:,108), wf6(:,163), A(:,2926), n3(:,3954), t3x72(:,:,2926), nhel, den(30))
    call Hcont_QA(nsync, wf12(:,108), wf6(:,164), A(:,2927), n3(:,3955), t3x72(:,:,2927), nhel, den(30))
    call Hcont_VV(nsync, wf8(:,13), wf9(:,15), A(:,2928), n3(:,3956), t3x72(:,:,2928), nhel, den(60))
    call Hcont_VV(nsync, wf8(:,13), wf9(:,16), A(:,2929), n3(:,3957), t3x72(:,:,2929), nhel, den(60))
    call Hcont_VV(nsync, wf8(:,13), wf9(:,15), A(:,2930), n3(:,3958), t3x72(:,:,2930), nhel, den(60))
    call Hcont_VV(nsync, wf8(:,13), wf9(:,16), A(:,2931), n3(:,3959), t3x72(:,:,2931), nhel, den(60))
    call Hcont_QA(nsync, wf12(:,89), wf6(:,169), A(:,2932), n3(:,3960), t3x72(:,:,2932), nhel, den(18))
    call Hcont_QA(nsync, wf18(:,162), wf4(:,39), A(:,2933), n3(:,3961), t3x72(:,:,2933), nhel, den(19))
    call Hcont_QA(nsync, wf4(:,39), wf18(:,163), A(:,2934), n3(:,3962), t3x72(:,:,2934), nhel, den(65))
    call Hcont_VV(nsync, wf3(:,13), wf24(:,38), A(:,2935), n3(:,3963), t3x72(:,:,2935), nhel, den(11))
    call Hcont_VV(nsync, wf3(:,14), wf24(:,38), A(:,2936), n3(:,3964), t3x72(:,:,2936), nhel, den(11))
    call Hcont_VV(nsync, wf3(:,13), wf24(:,38), A(:,2937), n3(:,3965), t3x72(:,:,2937), nhel, den(11))
    call Hcont_VV(nsync, wf3(:,14), wf24(:,38), A(:,2938), n3(:,3966), t3x72(:,:,2938), nhel, den(11))
    call Hcont_VV(nsync, wf3(:,13), wf24(:,39), A(:,2939), n3(:,3967), t3x72(:,:,2939), nhel, den(18))
    call Hcont_VV(nsync, wf3(:,14), wf24(:,39), A(:,2940), n3(:,3968), t3x72(:,:,2940), nhel, den(18))
    call Hcont_VV(nsync, wf3(:,13), wf24(:,39), A(:,2941), n3(:,3969), t3x72(:,:,2941), nhel, den(18))
    call Hcont_VV(nsync, wf3(:,14), wf24(:,39), A(:,2942), n3(:,3970), t3x72(:,:,2942), nhel, den(18))
    call Hcont_QA(nsync, wf2(:,17), wf36(:,6), A(:,2943), n3(:,3971), t3x72(:,:,2943), nhel, den(19))
    call Hcont_QA(nsync, wf2(:,17), wf36(:,7), A(:,2944), n3(:,3972), t3x72(:,:,2944), nhel, den(18))
    call Hcont_VV(nsync, wf3(:,13), wf24(:,40), A(:,2945), n3(:,3973), t3x72(:,:,2945), nhel, den(12))
    call Hcont_VV(nsync, wf3(:,14), wf24(:,40), A(:,2946), n3(:,3974), t3x72(:,:,2946), nhel, den(12))
    call Hcont_VV(nsync, wf3(:,13), wf24(:,40), A(:,2947), n3(:,3975), t3x72(:,:,2947), nhel, den(12))
    call Hcont_VV(nsync, wf3(:,14), wf24(:,40), A(:,2948), n3(:,3976), t3x72(:,:,2948), nhel, den(12))
    call Hcont_VV(nsync, wf3(:,13), wf24(:,41), A(:,2949), n3(:,3977), t3x72(:,:,2949), nhel, den(59))
    call Hcont_VV(nsync, wf3(:,14), wf24(:,41), A(:,2950), n3(:,3978), t3x72(:,:,2950), nhel, den(59))
    call Hcont_VV(nsync, wf3(:,13), wf24(:,41), A(:,2951), n3(:,3979), t3x72(:,:,2951), nhel, den(59))
    call Hcont_VV(nsync, wf3(:,14), wf24(:,41), A(:,2952), n3(:,3980), t3x72(:,:,2952), nhel, den(59))
    call Hcont_VV(nsync, wf3(:,13), wf24(:,42), A(:,2953), n3(:,3981), t3x72(:,:,2953), nhel, den(20))
    call Hcont_VV(nsync, wf3(:,14), wf24(:,42), A(:,2954), n3(:,3982), t3x72(:,:,2954), nhel, den(20))
    call Hcont_VV(nsync, wf3(:,13), wf24(:,42), A(:,2955), n3(:,3983), t3x72(:,:,2955), nhel, den(20))
    call Hcont_VV(nsync, wf3(:,14), wf24(:,42), A(:,2956), n3(:,3984), t3x72(:,:,2956), nhel, den(20))
    call Hcont_QA(nsync, wf2(:,17), wf36(:,8), A(:,2957), n3(:,3985), t3x72(:,:,2957), nhel, den(38))
    call Hcont_QA(nsync, wf2(:,17), wf36(:,9), A(:,2958), n3(:,3986), t3x72(:,:,2958), nhel, den(21))
    call Hcont_QA(nsync, wf2(:,17), wf36(:,10), A(:,2959), n3(:,3987), t3x72(:,:,2959), nhel, den(20))
    call Hcont_QA(nsync, wf12(:,114), wf6(:,167), A(:,2960), n3(:,3988), t3x72(:,:,2960), nhel, den(27))
    call Hcont_QA(nsync, wf12(:,114), wf6(:,168), A(:,2961), n3(:,3989), t3x72(:,:,2961), nhel, den(27))
    call Hcont_QA(nsync, wf12(:,114), wf6(:,167), A(:,2962), n3(:,3990), t3x72(:,:,2962), nhel, den(27))
    call Hcont_QA(nsync, wf12(:,114), wf6(:,168), A(:,2963), n3(:,3991), t3x72(:,:,2963), nhel, den(27))
    call Hcont_QA(nsync, wf12(:,116), wf6(:,167), A(:,2964), n3(:,3992), t3x72(:,:,2964), nhel, den(29))
    call Hcont_QA(nsync, wf12(:,116), wf6(:,168), A(:,2965), n3(:,3993), t3x72(:,:,2965), nhel, den(29))
    call Hcont_QA(nsync, wf12(:,116), wf6(:,167), A(:,2966), n3(:,3994), t3x72(:,:,2966), nhel, den(29))
    call Hcont_QA(nsync, wf12(:,116), wf6(:,168), A(:,2967), n3(:,3995), t3x72(:,:,2967), nhel, den(29))
    call Hcont_VV(nsync, wf8(:,13), wf9(:,17), A(:,2968), n3(:,3996), t3x72(:,:,2968), nhel, den(60))
    call Hcont_VV(nsync, wf8(:,13), wf9(:,18), A(:,2969), n3(:,3997), t3x72(:,:,2969), nhel, den(60))
    call Hcont_VV(nsync, wf8(:,13), wf9(:,17), A(:,2970), n3(:,3998), t3x72(:,:,2970), nhel, den(60))
    call Hcont_VV(nsync, wf8(:,13), wf9(:,18), A(:,2971), n3(:,3999), t3x72(:,:,2971), nhel, den(60))
    call Hcont_QA(nsync, wf12(:,87), wf6(:,170), A(:,2972), n3(:,4000), t3x72(:,:,2972), nhel, den(14))
    call Hcont_QA(nsync, wf4(:,39), wf18(:,165), A(:,2973), n3(:,4001), t3x72(:,:,2973), nhel, den(16))
    call Hcont_QA(nsync, wf4(:,39), wf18(:,166), A(:,2974), n3(:,4002), t3x72(:,:,2974), nhel, den(65))
    call Hcont_VV(nsync, wf3(:,11), wf24(:,43), A(:,2975), n3(:,4003), t3x72(:,:,2975), nhel, den(10))
    call Hcont_VV(nsync, wf3(:,12), wf24(:,43), A(:,2976), n3(:,4004), t3x72(:,:,2976), nhel, den(10))
    call Hcont_VV(nsync, wf3(:,11), wf24(:,43), A(:,2977), n3(:,4005), t3x72(:,:,2977), nhel, den(10))
    call Hcont_VV(nsync, wf3(:,12), wf24(:,43), A(:,2978), n3(:,4006), t3x72(:,:,2978), nhel, den(10))
    call Hcont_VV(nsync, wf3(:,11), wf24(:,44), A(:,2979), n3(:,4007), t3x72(:,:,2979), nhel, den(23))
    call Hcont_VV(nsync, wf3(:,12), wf24(:,44), A(:,2980), n3(:,4008), t3x72(:,:,2980), nhel, den(23))
    call Hcont_VV(nsync, wf3(:,11), wf24(:,44), A(:,2981), n3(:,4009), t3x72(:,:,2981), nhel, den(23))
    call Hcont_VV(nsync, wf3(:,12), wf24(:,44), A(:,2982), n3(:,4010), t3x72(:,:,2982), nhel, den(23))
    call Hcont_QA(nsync, wf36(:,11), wf2(:,18), A(:,2983), n3(:,4011), t3x72(:,:,2983), nhel, den(25))
    call Hcont_QA(nsync, wf2(:,18), wf36(:,12), A(:,2984), n3(:,4012), t3x72(:,:,2984), nhel, den(23))
    call Hcont_VV(nsync, wf3(:,11), wf24(:,45), A(:,2985), n3(:,4013), t3x72(:,:,2985), nhel, den(5))
    call Hcont_VV(nsync, wf3(:,12), wf24(:,45), A(:,2986), n3(:,4014), t3x72(:,:,2986), nhel, den(5))
    call Hcont_VV(nsync, wf3(:,11), wf24(:,45), A(:,2987), n3(:,4015), t3x72(:,:,2987), nhel, den(5))
    call Hcont_VV(nsync, wf3(:,12), wf24(:,45), A(:,2988), n3(:,4016), t3x72(:,:,2988), nhel, den(5))
    call Hcont_VV(nsync, wf3(:,11), wf24(:,46), A(:,2989), n3(:,4017), t3x72(:,:,2989), nhel, den(60))
    call Hcont_VV(nsync, wf3(:,12), wf24(:,46), A(:,2990), n3(:,4018), t3x72(:,:,2990), nhel, den(60))
    call Hcont_VV(nsync, wf3(:,11), wf24(:,46), A(:,2991), n3(:,4019), t3x72(:,:,2991), nhel, den(60))
    call Hcont_VV(nsync, wf3(:,12), wf24(:,46), A(:,2992), n3(:,4020), t3x72(:,:,2992), nhel, den(60))
    call Hcont_VV(nsync, wf3(:,11), wf24(:,47), A(:,2993), n3(:,4021), t3x72(:,:,2993), nhel, den(30))
    call Hcont_VV(nsync, wf3(:,12), wf24(:,47), A(:,2994), n3(:,4022), t3x72(:,:,2994), nhel, den(30))
    call Hcont_VV(nsync, wf3(:,11), wf24(:,47), A(:,2995), n3(:,4023), t3x72(:,:,2995), nhel, den(30))
    call Hcont_VV(nsync, wf3(:,12), wf24(:,47), A(:,2996), n3(:,4024), t3x72(:,:,2996), nhel, den(30))
    call Hcont_QA(nsync, wf2(:,18), wf36(:,13), A(:,2997), n3(:,4025), t3x72(:,:,2997), nhel, den(39))
    call Hcont_QA(nsync, wf2(:,18), wf36(:,14), A(:,2998), n3(:,4026), t3x72(:,:,2998), nhel, den(29))
    call Hcont_QA(nsync, wf2(:,18), wf36(:,15), A(:,2999), n3(:,4027), t3x72(:,:,2999), nhel, den(30))
    call Hcont_QA(nsync, wf12(:,103), wf6(:,161), A(:,3000), n3(:,4028), t3x72(:,:,3000), nhel, den(14))
    call Hcont_QA(nsync, wf12(:,103), wf6(:,162), A(:,3001), n3(:,4029), t3x72(:,:,3001), nhel, den(14))
    call Hcont_QA(nsync, wf12(:,103), wf6(:,161), A(:,3002), n3(:,4030), t3x72(:,:,3002), nhel, den(14))
    call Hcont_QA(nsync, wf12(:,103), wf6(:,162), A(:,3003), n3(:,4031), t3x72(:,:,3003), nhel, den(14))
    call Hcont_QA(nsync, wf12(:,105), wf6(:,161), A(:,3004), n3(:,4032), t3x72(:,:,3004), nhel, den(21))
    call Hcont_QA(nsync, wf12(:,105), wf6(:,162), A(:,3005), n3(:,4033), t3x72(:,:,3005), nhel, den(21))
    call Hcont_QA(nsync, wf12(:,105), wf6(:,161), A(:,3006), n3(:,4034), t3x72(:,:,3006), nhel, den(21))
    call Hcont_QA(nsync, wf12(:,105), wf6(:,162), A(:,3007), n3(:,4035), t3x72(:,:,3007), nhel, den(21))
    call Hcont_VV(nsync, wf8(:,16), wf9(:,19), A(:,3008), n3(:,4036), t3x72(:,:,3008), nhel, den(59))
    call Hcont_VV(nsync, wf8(:,16), wf9(:,20), A(:,3009), n3(:,4037), t3x72(:,:,3009), nhel, den(59))
    call Hcont_VV(nsync, wf8(:,16), wf9(:,19), A(:,3010), n3(:,4038), t3x72(:,:,3010), nhel, den(59))
    call Hcont_VV(nsync, wf8(:,16), wf9(:,20), A(:,3011), n3(:,4039), t3x72(:,:,3011), nhel, den(59))
    call Hcont_QA(nsync, wf12(:,102), wf6(:,171), A(:,3012), n3(:,4040), t3x72(:,:,3012), nhel, den(27))
    call Hcont_QA(nsync, wf18(:,168), wf4(:,40), A(:,3013), n3(:,4041), t3x72(:,:,3013), nhel, den(28))
    call Hcont_QA(nsync, wf4(:,40), wf18(:,169), A(:,3014), n3(:,4042), t3x72(:,:,3014), nhel, den(66))
    call Hcont_VV(nsync, wf3(:,15), wf24(:,48), A(:,3015), n3(:,4043), t3x72(:,:,3015), nhel, den(12))
    call Hcont_VV(nsync, wf3(:,16), wf24(:,48), A(:,3016), n3(:,4044), t3x72(:,:,3016), nhel, den(12))
    call Hcont_VV(nsync, wf3(:,15), wf24(:,48), A(:,3017), n3(:,4045), t3x72(:,:,3017), nhel, den(12))
    call Hcont_VV(nsync, wf3(:,16), wf24(:,48), A(:,3018), n3(:,4046), t3x72(:,:,3018), nhel, den(12))
    call Hcont_VV(nsync, wf3(:,15), wf24(:,49), A(:,3019), n3(:,4047), t3x72(:,:,3019), nhel, den(27))
    call Hcont_VV(nsync, wf3(:,16), wf24(:,49), A(:,3020), n3(:,4048), t3x72(:,:,3020), nhel, den(27))
    call Hcont_VV(nsync, wf3(:,15), wf24(:,49), A(:,3021), n3(:,4049), t3x72(:,:,3021), nhel, den(27))
    call Hcont_VV(nsync, wf3(:,16), wf24(:,49), A(:,3022), n3(:,4050), t3x72(:,:,3022), nhel, den(27))
    call Hcont_QA(nsync, wf2(:,18), wf36(:,16), A(:,3023), n3(:,4051), t3x72(:,:,3023), nhel, den(28))
    call Hcont_QA(nsync, wf2(:,18), wf36(:,17), A(:,3024), n3(:,4052), t3x72(:,:,3024), nhel, den(27))
    call Hcont_VV(nsync, wf3(:,15), wf24(:,50), A(:,3025), n3(:,4053), t3x72(:,:,3025), nhel, den(11))
    call Hcont_VV(nsync, wf3(:,16), wf24(:,50), A(:,3026), n3(:,4054), t3x72(:,:,3026), nhel, den(11))
    call Hcont_VV(nsync, wf3(:,15), wf24(:,50), A(:,3027), n3(:,4055), t3x72(:,:,3027), nhel, den(11))
    call Hcont_VV(nsync, wf3(:,16), wf24(:,50), A(:,3028), n3(:,4056), t3x72(:,:,3028), nhel, den(11))
    call Hcont_VV(nsync, wf3(:,15), wf24(:,51), A(:,3029), n3(:,4057), t3x72(:,:,3029), nhel, den(60))
    call Hcont_VV(nsync, wf3(:,16), wf24(:,51), A(:,3030), n3(:,4058), t3x72(:,:,3030), nhel, den(60))
    call Hcont_VV(nsync, wf3(:,15), wf24(:,51), A(:,3031), n3(:,4059), t3x72(:,:,3031), nhel, den(60))
    call Hcont_VV(nsync, wf3(:,16), wf24(:,51), A(:,3032), n3(:,4060), t3x72(:,:,3032), nhel, den(60))
    call Hcont_VV(nsync, wf3(:,15), wf24(:,52), A(:,3033), n3(:,4061), t3x72(:,:,3033), nhel, den(29))
    call Hcont_VV(nsync, wf3(:,16), wf24(:,52), A(:,3034), n3(:,4062), t3x72(:,:,3034), nhel, den(29))
    call Hcont_VV(nsync, wf3(:,15), wf24(:,52), A(:,3035), n3(:,4063), t3x72(:,:,3035), nhel, den(29))
    call Hcont_VV(nsync, wf3(:,16), wf24(:,52), A(:,3036), n3(:,4064), t3x72(:,:,3036), nhel, den(29))
    call Hcont_QA(nsync, wf2(:,18), wf36(:,18), A(:,3037), n3(:,4065), t3x72(:,:,3037), nhel, den(39))
    call Hcont_QA(nsync, wf2(:,18), wf36(:,19), A(:,3038), n3(:,4066), t3x72(:,:,3038), nhel, den(30))
    call Hcont_QA(nsync, wf2(:,18), wf36(:,20), A(:,3039), n3(:,4067), t3x72(:,:,3039), nhel, den(29))
    call Hcont_QA(nsync, wf12(:,110), wf6(:,165), A(:,3040), n3(:,4068), t3x72(:,:,3040), nhel, den(18))
    call Hcont_QA(nsync, wf12(:,110), wf6(:,166), A(:,3041), n3(:,4069), t3x72(:,:,3041), nhel, den(18))
    call Hcont_QA(nsync, wf12(:,110), wf6(:,165), A(:,3042), n3(:,4070), t3x72(:,:,3042), nhel, den(18))
    call Hcont_QA(nsync, wf12(:,110), wf6(:,166), A(:,3043), n3(:,4071), t3x72(:,:,3043), nhel, den(18))
    call Hcont_QA(nsync, wf12(:,112), wf6(:,165), A(:,3044), n3(:,4072), t3x72(:,:,3044), nhel, den(20))
    call Hcont_QA(nsync, wf12(:,112), wf6(:,166), A(:,3045), n3(:,4073), t3x72(:,:,3045), nhel, den(20))
    call Hcont_QA(nsync, wf12(:,112), wf6(:,165), A(:,3046), n3(:,4074), t3x72(:,:,3046), nhel, den(20))
    call Hcont_QA(nsync, wf12(:,112), wf6(:,166), A(:,3047), n3(:,4075), t3x72(:,:,3047), nhel, den(20))
    call Hcont_VV(nsync, wf8(:,16), wf9(:,21), A(:,3048), n3(:,4076), t3x72(:,:,3048), nhel, den(59))
    call Hcont_VV(nsync, wf8(:,16), wf9(:,22), A(:,3049), n3(:,4077), t3x72(:,:,3049), nhel, den(59))
    call Hcont_VV(nsync, wf8(:,16), wf9(:,21), A(:,3050), n3(:,4078), t3x72(:,:,3050), nhel, den(59))
    call Hcont_VV(nsync, wf8(:,16), wf9(:,22), A(:,3051), n3(:,4079), t3x72(:,:,3051), nhel, den(59))
    call Hcont_QA(nsync, wf12(:,101), wf6(:,172), A(:,3052), n3(:,4080), t3x72(:,:,3052), nhel, den(23))
    call Hcont_QA(nsync, wf4(:,40), wf18(:,171), A(:,3053), n3(:,4081), t3x72(:,:,3053), nhel, den(25))
    call Hcont_QA(nsync, wf4(:,40), wf18(:,172), A(:,3054), n3(:,4082), t3x72(:,:,3054), nhel, den(66))
    call Hcont_QA(nsync, wf12(:,103), wf6(:,170), A(:,3055), n3(:,4083), t3x72(:,:,3055), nhel, den(14))
    call Hcont_QA(nsync, wf4(:,39), wf18(:,173), A(:,3056), n3(:,4084), t3x72(:,:,3056), nhel, den(16))
    call Hcont_QA(nsync, wf12(:,110), wf6(:,169), A(:,3057), n3(:,4085), t3x72(:,:,3057), nhel, den(18))
    call Hcont_QA(nsync, wf4(:,39), wf18(:,174), A(:,3058), n3(:,4086), t3x72(:,:,3058), nhel, den(19))
    call Hcont_QA(nsync, wf12(:,112), wf6(:,169), A(:,3059), n3(:,4087), t3x72(:,:,3059), nhel, den(20))
    call Hcont_QA(nsync, wf12(:,105), wf6(:,170), A(:,3060), n3(:,4088), t3x72(:,:,3060), nhel, den(21))
    call Hcont_QA(nsync, wf12(:,106), wf6(:,172), A(:,3061), n3(:,4089), t3x72(:,:,3061), nhel, den(23))
    call Hcont_QA(nsync, wf4(:,40), wf18(:,175), A(:,3062), n3(:,4090), t3x72(:,:,3062), nhel, den(25))
    call Hcont_QA(nsync, wf12(:,114), wf6(:,171), A(:,3063), n3(:,4091), t3x72(:,:,3063), nhel, den(27))
    call Hcont_QA(nsync, wf4(:,40), wf18(:,176), A(:,3064), n3(:,4092), t3x72(:,:,3064), nhel, den(28))
    call Hcont_QA(nsync, wf12(:,116), wf6(:,171), A(:,3065), n3(:,4093), t3x72(:,:,3065), nhel, den(29))
    call Hcont_QA(nsync, wf12(:,108), wf6(:,172), A(:,3066), n3(:,4094), t3x72(:,:,3066), nhel, den(30))
    call Hcont_QA(nsync, wf36(:,1), wf2(:,55), A(:,3067), n3(:,4095), t3x72(:,:,3067), nhel, den(16))
    call Hcont_QA(nsync, wf36(:,2), wf2(:,55), A(:,3068), n3(:,4096), t3x72(:,:,3068), nhel, den(14))
    call Hcont_QA(nsync, wf36(:,3), wf2(:,55), A(:,3069), n3(:,4097), t3x72(:,:,3069), nhel, den(38))
    call Hcont_QA(nsync, wf36(:,4), wf2(:,55), A(:,3070), n3(:,4098), t3x72(:,:,3070), nhel, den(20))
    call Hcont_QA(nsync, wf36(:,5), wf2(:,55), A(:,3071), n3(:,4099), t3x72(:,:,3071), nhel, den(21))
    call Hcont_QA(nsync, wf12(:,89), wf6(:,389), A(:,3072), n3(:,4100), t3x72(:,:,3072), nhel, den(18))
    call Hcont_QA(nsync, wf18(:,162), wf4(:,89), A(:,3073), n3(:,4101), t3x72(:,:,3073), nhel, den(19))
    call Hcont_QA(nsync, wf18(:,163), wf4(:,89), A(:,3074), n3(:,4102), t3x72(:,:,3074), nhel, den(65))
    call Hcont_QA(nsync, wf36(:,6), wf2(:,55), A(:,3075), n3(:,4103), t3x72(:,:,3075), nhel, den(19))
    call Hcont_QA(nsync, wf36(:,7), wf2(:,55), A(:,3076), n3(:,4104), t3x72(:,:,3076), nhel, den(18))
    call Hcont_QA(nsync, wf36(:,8), wf2(:,55), A(:,3077), n3(:,4105), t3x72(:,:,3077), nhel, den(38))
    call Hcont_QA(nsync, wf36(:,9), wf2(:,55), A(:,3078), n3(:,4106), t3x72(:,:,3078), nhel, den(21))
    call Hcont_QA(nsync, wf36(:,10), wf2(:,55), A(:,3079), n3(:,4107), t3x72(:,:,3079), nhel, den(20))
    call Hcont_QA(nsync, wf12(:,87), wf6(:,390), A(:,3080), n3(:,4108), t3x72(:,:,3080), nhel, den(14))
    call Hcont_QA(nsync, wf18(:,165), wf4(:,89), A(:,3081), n3(:,4109), t3x72(:,:,3081), nhel, den(16))
    call Hcont_QA(nsync, wf18(:,166), wf4(:,89), A(:,3082), n3(:,4110), t3x72(:,:,3082), nhel, den(65))
    call Hcont_QA(nsync, wf36(:,11), wf2(:,56), A(:,3083), n3(:,4111), t3x72(:,:,3083), nhel, den(25))
    call Hcont_QA(nsync, wf36(:,12), wf2(:,56), A(:,3084), n3(:,4112), t3x72(:,:,3084), nhel, den(23))
    call Hcont_QA(nsync, wf36(:,13), wf2(:,56), A(:,3085), n3(:,4113), t3x72(:,:,3085), nhel, den(39))
    call Hcont_QA(nsync, wf36(:,14), wf2(:,56), A(:,3086), n3(:,4114), t3x72(:,:,3086), nhel, den(29))
    call Hcont_QA(nsync, wf36(:,15), wf2(:,56), A(:,3087), n3(:,4115), t3x72(:,:,3087), nhel, den(30))
    call Hcont_QA(nsync, wf12(:,102), wf6(:,391), A(:,3088), n3(:,4116), t3x72(:,:,3088), nhel, den(27))
    call Hcont_QA(nsync, wf18(:,168), wf4(:,90), A(:,3089), n3(:,4117), t3x72(:,:,3089), nhel, den(28))
    call Hcont_QA(nsync, wf18(:,169), wf4(:,90), A(:,3090), n3(:,4118), t3x72(:,:,3090), nhel, den(66))
    call Hcont_QA(nsync, wf36(:,16), wf2(:,56), A(:,3091), n3(:,4119), t3x72(:,:,3091), nhel, den(28))
    call Hcont_QA(nsync, wf36(:,17), wf2(:,56), A(:,3092), n3(:,4120), t3x72(:,:,3092), nhel, den(27))
    call Hcont_QA(nsync, wf36(:,18), wf2(:,56), A(:,3093), n3(:,4121), t3x72(:,:,3093), nhel, den(39))
    call Hcont_QA(nsync, wf36(:,19), wf2(:,56), A(:,3094), n3(:,4122), t3x72(:,:,3094), nhel, den(30))
    call Hcont_QA(nsync, wf36(:,20), wf2(:,56), A(:,3095), n3(:,4123), t3x72(:,:,3095), nhel, den(29))
    call Hcont_QA(nsync, wf12(:,101), wf6(:,392), A(:,3096), n3(:,4124), t3x72(:,:,3096), nhel, den(23))
    call Hcont_QA(nsync, wf18(:,171), wf4(:,90), A(:,3097), n3(:,4125), t3x72(:,:,3097), nhel, den(25))
    call Hcont_QA(nsync, wf18(:,172), wf4(:,90), A(:,3098), n3(:,4126), t3x72(:,:,3098), nhel, den(66))
    call Hcont_QA(nsync, wf12(:,103), wf6(:,390), A(:,3099), n3(:,4127), t3x72(:,:,3099), nhel, den(14))
    call Hcont_QA(nsync, wf12(:,41), wf6(:,393), A(:,3100), n3(:,4128), t3x72(:,:,3100), nhel, den(14))
    call Hcont_QA(nsync, wf18(:,173), wf4(:,89), A(:,3101), n3(:,4129), t3x72(:,:,3101), nhel, den(16))
    call Hcont_QA(nsync, wf18(:,41), wf4(:,91), A(:,3102), n3(:,4130), t3x72(:,:,3102), nhel, den(16))
    call Hcont_QA(nsync, wf12(:,110), wf6(:,389), A(:,3103), n3(:,4131), t3x72(:,:,3103), nhel, den(18))
    call Hcont_QA(nsync, wf12(:,43), wf6(:,394), A(:,3104), n3(:,4132), t3x72(:,:,3104), nhel, den(18))
    call Hcont_QA(nsync, wf18(:,174), wf4(:,89), A(:,3105), n3(:,4133), t3x72(:,:,3105), nhel, den(19))
    call Hcont_QA(nsync, wf18(:,42), wf4(:,91), A(:,3106), n3(:,4134), t3x72(:,:,3106), nhel, den(19))
    call Hcont_QA(nsync, wf12(:,112), wf6(:,389), A(:,3107), n3(:,4135), t3x72(:,:,3107), nhel, den(20))
    call Hcont_QA(nsync, wf12(:,45), wf6(:,394), A(:,3108), n3(:,4136), t3x72(:,:,3108), nhel, den(20))
    call Hcont_QA(nsync, wf12(:,105), wf6(:,390), A(:,3109), n3(:,4137), t3x72(:,:,3109), nhel, den(21))
    call Hcont_QA(nsync, wf12(:,47), wf6(:,393), A(:,3110), n3(:,4138), t3x72(:,:,3110), nhel, den(21))
    call Hcont_QA(nsync, wf12(:,48), wf6(:,395), A(:,3111), n3(:,4139), t3x72(:,:,3111), nhel, den(23))
    call Hcont_QA(nsync, wf12(:,106), wf6(:,392), A(:,3112), n3(:,4140), t3x72(:,:,3112), nhel, den(23))
    call Hcont_QA(nsync, wf18(:,43), wf4(:,92), A(:,3113), n3(:,4141), t3x72(:,:,3113), nhel, den(25))
    call Hcont_QA(nsync, wf18(:,175), wf4(:,90), A(:,3114), n3(:,4142), t3x72(:,:,3114), nhel, den(25))
    call Hcont_QA(nsync, wf12(:,50), wf6(:,396), A(:,3115), n3(:,4143), t3x72(:,:,3115), nhel, den(27))
    call Hcont_QA(nsync, wf12(:,114), wf6(:,391), A(:,3116), n3(:,4144), t3x72(:,:,3116), nhel, den(27))
    call Hcont_QA(nsync, wf18(:,44), wf4(:,92), A(:,3117), n3(:,4145), t3x72(:,:,3117), nhel, den(28))
    call Hcont_QA(nsync, wf18(:,176), wf4(:,90), A(:,3118), n3(:,4146), t3x72(:,:,3118), nhel, den(28))
    call Hcont_QA(nsync, wf12(:,52), wf6(:,396), A(:,3119), n3(:,4147), t3x72(:,:,3119), nhel, den(29))
    call Hcont_QA(nsync, wf12(:,116), wf6(:,391), A(:,3120), n3(:,4148), t3x72(:,:,3120), nhel, den(29))
    call Hcont_QA(nsync, wf12(:,54), wf6(:,395), A(:,3121), n3(:,4149), t3x72(:,:,3121), nhel, den(30))
    call Hcont_QA(nsync, wf12(:,108), wf6(:,392), A(:,3122), n3(:,4150), t3x72(:,:,3122), nhel, den(30))
    call Hcont_QA(nsync, wf36(:,1), wf2(:,59), A(:,3123), n3(:,4151), t3x72(:,:,3123), nhel, den(16))
    call Hcont_QA(nsync, wf36(:,2), wf2(:,59), A(:,3124), n3(:,4152), t3x72(:,:,3124), nhel, den(14))
    call Hcont_QA(nsync, wf36(:,3), wf2(:,59), A(:,3125), n3(:,4153), t3x72(:,:,3125), nhel, den(38))
    call Hcont_QA(nsync, wf36(:,4), wf2(:,59), A(:,3126), n3(:,4154), t3x72(:,:,3126), nhel, den(20))
    call Hcont_QA(nsync, wf36(:,5), wf2(:,59), A(:,3127), n3(:,4155), t3x72(:,:,3127), nhel, den(21))
    call Hcont_QA(nsync, wf12(:,89), wf6(:,397), A(:,3128), n3(:,4156), t3x72(:,:,3128), nhel, den(18))
    call Hcont_QA(nsync, wf18(:,162), wf4(:,93), A(:,3129), n3(:,4157), t3x72(:,:,3129), nhel, den(19))
    call Hcont_QA(nsync, wf18(:,163), wf4(:,93), A(:,3130), n3(:,4158), t3x72(:,:,3130), nhel, den(65))
    call Hcont_QA(nsync, wf36(:,6), wf2(:,59), A(:,3131), n3(:,4159), t3x72(:,:,3131), nhel, den(19))
    call Hcont_QA(nsync, wf36(:,7), wf2(:,59), A(:,3132), n3(:,4160), t3x72(:,:,3132), nhel, den(18))
    call Hcont_QA(nsync, wf36(:,8), wf2(:,59), A(:,3133), n3(:,4161), t3x72(:,:,3133), nhel, den(38))
    call Hcont_QA(nsync, wf36(:,9), wf2(:,59), A(:,3134), n3(:,4162), t3x72(:,:,3134), nhel, den(21))
    call Hcont_QA(nsync, wf36(:,10), wf2(:,59), A(:,3135), n3(:,4163), t3x72(:,:,3135), nhel, den(20))
    call Hcont_QA(nsync, wf12(:,87), wf6(:,398), A(:,3136), n3(:,4164), t3x72(:,:,3136), nhel, den(14))
    call Hcont_QA(nsync, wf18(:,165), wf4(:,93), A(:,3137), n3(:,4165), t3x72(:,:,3137), nhel, den(16))
    call Hcont_QA(nsync, wf18(:,166), wf4(:,93), A(:,3138), n3(:,4166), t3x72(:,:,3138), nhel, den(65))
    call Hcont_QA(nsync, wf36(:,11), wf2(:,60), A(:,3139), n3(:,4167), t3x72(:,:,3139), nhel, den(25))
    call Hcont_QA(nsync, wf36(:,12), wf2(:,60), A(:,3140), n3(:,4168), t3x72(:,:,3140), nhel, den(23))
    call Hcont_QA(nsync, wf36(:,13), wf2(:,60), A(:,3141), n3(:,4169), t3x72(:,:,3141), nhel, den(39))
    call Hcont_QA(nsync, wf36(:,14), wf2(:,60), A(:,3142), n3(:,4170), t3x72(:,:,3142), nhel, den(29))
    call Hcont_QA(nsync, wf36(:,15), wf2(:,60), A(:,3143), n3(:,4171), t3x72(:,:,3143), nhel, den(30))
    call Hcont_QA(nsync, wf12(:,102), wf6(:,399), A(:,3144), n3(:,4172), t3x72(:,:,3144), nhel, den(27))
    call Hcont_QA(nsync, wf18(:,168), wf4(:,94), A(:,3145), n3(:,4173), t3x72(:,:,3145), nhel, den(28))
    call Hcont_QA(nsync, wf18(:,169), wf4(:,94), A(:,3146), n3(:,4174), t3x72(:,:,3146), nhel, den(66))
    call Hcont_QA(nsync, wf36(:,16), wf2(:,60), A(:,3147), n3(:,4175), t3x72(:,:,3147), nhel, den(28))
    call Hcont_QA(nsync, wf36(:,17), wf2(:,60), A(:,3148), n3(:,4176), t3x72(:,:,3148), nhel, den(27))
    call Hcont_QA(nsync, wf36(:,18), wf2(:,60), A(:,3149), n3(:,4177), t3x72(:,:,3149), nhel, den(39))
    call Hcont_QA(nsync, wf36(:,19), wf2(:,60), A(:,3150), n3(:,4178), t3x72(:,:,3150), nhel, den(30))
    call Hcont_QA(nsync, wf36(:,20), wf2(:,60), A(:,3151), n3(:,4179), t3x72(:,:,3151), nhel, den(29))
    call Hcont_QA(nsync, wf12(:,101), wf6(:,400), A(:,3152), n3(:,4180), t3x72(:,:,3152), nhel, den(23))
    call Hcont_QA(nsync, wf18(:,171), wf4(:,94), A(:,3153), n3(:,4181), t3x72(:,:,3153), nhel, den(25))
    call Hcont_QA(nsync, wf18(:,172), wf4(:,94), A(:,3154), n3(:,4182), t3x72(:,:,3154), nhel, den(66))
    call Hcont_QA(nsync, wf12(:,103), wf6(:,398), A(:,3155), n3(:,4183), t3x72(:,:,3155), nhel, den(14))
    call Hcont_QA(nsync, wf12(:,57), wf6(:,401), A(:,3156), n3(:,4184), t3x72(:,:,3156), nhel, den(14))
    call Hcont_QA(nsync, wf18(:,173), wf4(:,93), A(:,3157), n3(:,4185), t3x72(:,:,3157), nhel, den(16))
    call Hcont_QA(nsync, wf18(:,49), wf4(:,95), A(:,3158), n3(:,4186), t3x72(:,:,3158), nhel, den(16))
    call Hcont_QA(nsync, wf12(:,110), wf6(:,397), A(:,3159), n3(:,4187), t3x72(:,:,3159), nhel, den(18))
    call Hcont_QA(nsync, wf12(:,59), wf6(:,402), A(:,3160), n3(:,4188), t3x72(:,:,3160), nhel, den(18))
    call Hcont_QA(nsync, wf18(:,174), wf4(:,93), A(:,3161), n3(:,4189), t3x72(:,:,3161), nhel, den(19))
    call Hcont_QA(nsync, wf18(:,50), wf4(:,95), A(:,3162), n3(:,4190), t3x72(:,:,3162), nhel, den(19))
    call Hcont_QA(nsync, wf12(:,112), wf6(:,397), A(:,3163), n3(:,4191), t3x72(:,:,3163), nhel, den(20))
    call Hcont_QA(nsync, wf12(:,61), wf6(:,402), A(:,3164), n3(:,4192), t3x72(:,:,3164), nhel, den(20))
    call Hcont_QA(nsync, wf12(:,105), wf6(:,398), A(:,3165), n3(:,4193), t3x72(:,:,3165), nhel, den(21))
    call Hcont_QA(nsync, wf12(:,63), wf6(:,401), A(:,3166), n3(:,4194), t3x72(:,:,3166), nhel, den(21))
    call Hcont_QA(nsync, wf12(:,64), wf6(:,403), A(:,3167), n3(:,4195), t3x72(:,:,3167), nhel, den(23))
    call Hcont_QA(nsync, wf12(:,106), wf6(:,400), A(:,3168), n3(:,4196), t3x72(:,:,3168), nhel, den(23))
    call Hcont_QA(nsync, wf18(:,51), wf4(:,96), A(:,3169), n3(:,4197), t3x72(:,:,3169), nhel, den(25))
    call Hcont_QA(nsync, wf18(:,175), wf4(:,94), A(:,3170), n3(:,4198), t3x72(:,:,3170), nhel, den(25))
    call Hcont_QA(nsync, wf12(:,66), wf6(:,404), A(:,3171), n3(:,4199), t3x72(:,:,3171), nhel, den(27))
    call Hcont_QA(nsync, wf12(:,114), wf6(:,399), A(:,3172), n3(:,4200), t3x72(:,:,3172), nhel, den(27))
    call Hcont_QA(nsync, wf18(:,52), wf4(:,96), A(:,3173), n3(:,4201), t3x72(:,:,3173), nhel, den(28))
    call Hcont_QA(nsync, wf18(:,176), wf4(:,94), A(:,3174), n3(:,4202), t3x72(:,:,3174), nhel, den(28))
    call Hcont_QA(nsync, wf12(:,68), wf6(:,404), A(:,3175), n3(:,4203), t3x72(:,:,3175), nhel, den(29))
    call Hcont_QA(nsync, wf12(:,116), wf6(:,399), A(:,3176), n3(:,4204), t3x72(:,:,3176), nhel, den(29))
    call Hcont_QA(nsync, wf12(:,70), wf6(:,403), A(:,3177), n3(:,4205), t3x72(:,:,3177), nhel, den(30))
    call Hcont_QA(nsync, wf12(:,108), wf6(:,400), A(:,3178), n3(:,4206), t3x72(:,:,3178), nhel, den(30))
    call Hcont_QA(nsync, wf12(:,57), wf6(:,405), A(:,3179), n3(:,4207), t3x72(:,:,3179), nhel, den(14))
    call Hcont_QA(nsync, wf12(:,41), wf6(:,406), A(:,3180), n3(:,4208), t3x72(:,:,3180), nhel, den(14))
    call Hcont_QA(nsync, wf18(:,49), wf4(:,97), A(:,3181), n3(:,4209), t3x72(:,:,3181), nhel, den(16))
    call Hcont_QA(nsync, wf18(:,41), wf4(:,98), A(:,3182), n3(:,4210), t3x72(:,:,3182), nhel, den(16))
    call Hcont_QA(nsync, wf12(:,59), wf6(:,407), A(:,3183), n3(:,4211), t3x72(:,:,3183), nhel, den(18))
    call Hcont_QA(nsync, wf12(:,43), wf6(:,408), A(:,3184), n3(:,4212), t3x72(:,:,3184), nhel, den(18))
    call Hcont_QA(nsync, wf18(:,50), wf4(:,97), A(:,3185), n3(:,4213), t3x72(:,:,3185), nhel, den(19))
    call Hcont_QA(nsync, wf18(:,42), wf4(:,98), A(:,3186), n3(:,4214), t3x72(:,:,3186), nhel, den(19))
    call Hcont_QA(nsync, wf12(:,61), wf6(:,407), A(:,3187), n3(:,4215), t3x72(:,:,3187), nhel, den(20))
    call Hcont_QA(nsync, wf12(:,45), wf6(:,408), A(:,3188), n3(:,4216), t3x72(:,:,3188), nhel, den(20))
    call Hcont_QA(nsync, wf12(:,63), wf6(:,405), A(:,3189), n3(:,4217), t3x72(:,:,3189), nhel, den(21))
    call Hcont_QA(nsync, wf12(:,47), wf6(:,406), A(:,3190), n3(:,4218), t3x72(:,:,3190), nhel, den(21))
    call Hcont_QA(nsync, wf12(:,64), wf6(:,409), A(:,3191), n3(:,4219), t3x72(:,:,3191), nhel, den(23))
    call Hcont_QA(nsync, wf12(:,48), wf6(:,410), A(:,3192), n3(:,4220), t3x72(:,:,3192), nhel, den(23))
    call Hcont_QA(nsync, wf18(:,51), wf4(:,99), A(:,3193), n3(:,4221), t3x72(:,:,3193), nhel, den(25))
    call Hcont_QA(nsync, wf18(:,43), wf4(:,100), A(:,3194), n3(:,4222), t3x72(:,:,3194), nhel, den(25))
    call Hcont_QA(nsync, wf12(:,66), wf6(:,411), A(:,3195), n3(:,4223), t3x72(:,:,3195), nhel, den(27))
    call Hcont_QA(nsync, wf12(:,50), wf6(:,412), A(:,3196), n3(:,4224), t3x72(:,:,3196), nhel, den(27))
    call Hcont_QA(nsync, wf18(:,52), wf4(:,99), A(:,3197), n3(:,4225), t3x72(:,:,3197), nhel, den(28))
    call Hcont_QA(nsync, wf18(:,44), wf4(:,100), A(:,3198), n3(:,4226), t3x72(:,:,3198), nhel, den(28))
    call Hcont_QA(nsync, wf12(:,68), wf6(:,411), A(:,3199), n3(:,4227), t3x72(:,:,3199), nhel, den(29))
    call Hcont_QA(nsync, wf12(:,52), wf6(:,412), A(:,3200), n3(:,4228), t3x72(:,:,3200), nhel, den(29))
    call Hcont_QA(nsync, wf12(:,70), wf6(:,409), A(:,3201), n3(:,4229), t3x72(:,:,3201), nhel, den(30))
    call Hcont_QA(nsync, wf12(:,54), wf6(:,410), A(:,3202), n3(:,4230), t3x72(:,:,3202), nhel, den(30))
    call Hcont_QA(nsync, wf6(:,101), wf12(:,77), A(:,3203), n3(:,4231), t3x72(:,:,3203), nhel, den(10))
    call Hcont_QA(nsync, wf6(:,101), wf12(:,78), A(:,3204), n3(:,4232), t3x72(:,:,3204), nhel, den(10))
    call Hcont_QA(nsync, wf6(:,101), wf12(:,79), A(:,3205), n3(:,4233), t3x72(:,:,3205), nhel, den(10))
    call Hcont_QA(nsync, wf6(:,101), wf12(:,80), A(:,3206), n3(:,4234), t3x72(:,:,3206), nhel, den(10))
    call Hcont_QA(nsync, wf12(:,81), wf6(:,105), A(:,3207), n3(:,4235), t3x72(:,:,3207), nhel, den(21))
    call Hcont_QA(nsync, wf12(:,81), wf6(:,106), A(:,3208), n3(:,4236), t3x72(:,:,3208), nhel, den(21))
    call Hcont_QA(nsync, wf12(:,81), wf6(:,107), A(:,3209), n3(:,4237), t3x72(:,:,3209), nhel, den(21))
    call Hcont_QA(nsync, wf12(:,81), wf6(:,108), A(:,3210), n3(:,4238), t3x72(:,:,3210), nhel, den(21))
    call Hcont_VV(nsync, wf8(:,5), wf9(:,7), A(:,3211), n3(:,4239), t3x72(:,:,3211), nhel, den(59))
    call Hcont_VV(nsync, wf8(:,5), wf9(:,8), A(:,3212), n3(:,4240), t3x72(:,:,3212), nhel, den(59))
    call Hcont_VV(nsync, wf8(:,5), wf9(:,7), A(:,3213), n3(:,4241), t3x72(:,:,3213), nhel, den(59))
    call Hcont_VV(nsync, wf8(:,5), wf9(:,8), A(:,3214), n3(:,4242), t3x72(:,:,3214), nhel, den(59))
    call Hcont_QA(nsync, wf6(:,102), wf12(:,82), A(:,3215), n3(:,4243), t3x72(:,:,3215), nhel, den(12))
    call Hcont_QA(nsync, wf6(:,102), wf12(:,83), A(:,3216), n3(:,4244), t3x72(:,:,3216), nhel, den(12))
    call Hcont_QA(nsync, wf6(:,102), wf12(:,84), A(:,3217), n3(:,4245), t3x72(:,:,3217), nhel, den(12))
    call Hcont_QA(nsync, wf6(:,102), wf12(:,85), A(:,3218), n3(:,4246), t3x72(:,:,3218), nhel, den(12))
    call Hcont_QA(nsync, wf12(:,86), wf6(:,109), A(:,3219), n3(:,4247), t3x72(:,:,3219), nhel, den(20))
    call Hcont_QA(nsync, wf12(:,86), wf6(:,110), A(:,3220), n3(:,4248), t3x72(:,:,3220), nhel, den(20))
    call Hcont_QA(nsync, wf12(:,86), wf6(:,111), A(:,3221), n3(:,4249), t3x72(:,:,3221), nhel, den(20))
    call Hcont_QA(nsync, wf12(:,86), wf6(:,112), A(:,3222), n3(:,4250), t3x72(:,:,3222), nhel, den(20))
    call Hcont_VV(nsync, wf8(:,5), wf9(:,9), A(:,3223), n3(:,4251), t3x72(:,:,3223), nhel, den(59))
    call Hcont_VV(nsync, wf8(:,5), wf9(:,10), A(:,3224), n3(:,4252), t3x72(:,:,3224), nhel, den(59))
    call Hcont_VV(nsync, wf8(:,5), wf9(:,9), A(:,3225), n3(:,4253), t3x72(:,:,3225), nhel, den(59))
    call Hcont_VV(nsync, wf8(:,5), wf9(:,10), A(:,3226), n3(:,4254), t3x72(:,:,3226), nhel, den(59))
    call Hcont_VV(nsync, wf9(:,2), wf8(:,11), A(:,3227), n3(:,4255), t3x72(:,:,3227), nhel, den(53))
    call Hcont_VV(nsync, wf9(:,1), wf8(:,11), A(:,3228), n3(:,4256), t3x72(:,:,3228), nhel, den(53))
    call Hcont_VV(nsync, wf9(:,2), wf8(:,12), A(:,3229), n3(:,4257), t3x72(:,:,3229), nhel, den(55))
    call Hcont_VV(nsync, wf9(:,1), wf8(:,12), A(:,3230), n3(:,4258), t3x72(:,:,3230), nhel, den(55))
    call Hcont_QA(nsync, wf12(:,86), wf6(:,113), A(:,3231), n3(:,4259), t3x72(:,:,3231), nhel, den(20))
    call Hcont_QA(nsync, wf12(:,81), wf6(:,114), A(:,3232), n3(:,4260), t3x72(:,:,3232), nhel, den(21))
    call Hcont_QA(nsync, wf4(:,20), wf18(:,53), A(:,3233), n3(:,4261), t3x72(:,:,3233), nhel, den(5))
    call Hcont_QA(nsync, wf4(:,20), wf18(:,54), A(:,3234), n3(:,4262), t3x72(:,:,3234), nhel, den(5))
    call Hcont_QA(nsync, wf4(:,20), wf18(:,55), A(:,3235), n3(:,4263), t3x72(:,:,3235), nhel, den(5))
    call Hcont_QA(nsync, wf4(:,20), wf18(:,56), A(:,3236), n3(:,4264), t3x72(:,:,3236), nhel, den(5))
    call Hcont_QA(nsync, wf12(:,74), wf6(:,115), A(:,3237), n3(:,4265), t3x72(:,:,3237), nhel, den(11))
    call Hcont_QA(nsync, wf12(:,74), wf6(:,116), A(:,3238), n3(:,4266), t3x72(:,:,3238), nhel, den(11))
    call Hcont_QA(nsync, wf12(:,74), wf6(:,117), A(:,3239), n3(:,4267), t3x72(:,:,3239), nhel, den(11))
    call Hcont_QA(nsync, wf12(:,74), wf6(:,118), A(:,3240), n3(:,4268), t3x72(:,:,3240), nhel, den(11))
    call Hcont_VV(nsync, wf9(:,7), wf8(:,13), A(:,3241), n3(:,4269), t3x72(:,:,3241), nhel, den(60))
    call Hcont_VV(nsync, wf9(:,8), wf8(:,13), A(:,3242), n3(:,4270), t3x72(:,:,3242), nhel, den(60))
    call Hcont_VV(nsync, wf9(:,7), wf8(:,13), A(:,3243), n3(:,4271), t3x72(:,:,3243), nhel, den(60))
    call Hcont_VV(nsync, wf9(:,8), wf8(:,13), A(:,3244), n3(:,4272), t3x72(:,:,3244), nhel, den(60))
    call Hcont_QA(nsync, wf4(:,20), wf18(:,57), A(:,3245), n3(:,4273), t3x72(:,:,3245), nhel, den(11))
    call Hcont_QA(nsync, wf4(:,20), wf18(:,58), A(:,3246), n3(:,4274), t3x72(:,:,3246), nhel, den(11))
    call Hcont_QA(nsync, wf4(:,20), wf18(:,59), A(:,3247), n3(:,4275), t3x72(:,:,3247), nhel, den(11))
    call Hcont_QA(nsync, wf4(:,20), wf18(:,60), A(:,3248), n3(:,4276), t3x72(:,:,3248), nhel, den(11))
    call Hcont_QA(nsync, wf12(:,73), wf6(:,119), A(:,3249), n3(:,4277), t3x72(:,:,3249), nhel, den(5))
    call Hcont_QA(nsync, wf12(:,73), wf6(:,120), A(:,3250), n3(:,4278), t3x72(:,:,3250), nhel, den(5))
    call Hcont_QA(nsync, wf12(:,73), wf6(:,121), A(:,3251), n3(:,4279), t3x72(:,:,3251), nhel, den(5))
    call Hcont_QA(nsync, wf12(:,73), wf6(:,122), A(:,3252), n3(:,4280), t3x72(:,:,3252), nhel, den(5))
    call Hcont_VV(nsync, wf9(:,9), wf8(:,13), A(:,3253), n3(:,4281), t3x72(:,:,3253), nhel, den(60))
    call Hcont_VV(nsync, wf9(:,10), wf8(:,13), A(:,3254), n3(:,4282), t3x72(:,:,3254), nhel, den(60))
    call Hcont_VV(nsync, wf9(:,9), wf8(:,13), A(:,3255), n3(:,4283), t3x72(:,:,3255), nhel, den(60))
    call Hcont_VV(nsync, wf9(:,10), wf8(:,13), A(:,3256), n3(:,4284), t3x72(:,:,3256), nhel, den(60))
    call Hcont_QA(nsync, wf6(:,105), wf12(:,87), A(:,3257), n3(:,4285), t3x72(:,:,3257), nhel, den(14))
    call Hcont_QA(nsync, wf6(:,106), wf12(:,87), A(:,3258), n3(:,4286), t3x72(:,:,3258), nhel, den(14))
    call Hcont_QA(nsync, wf6(:,107), wf12(:,87), A(:,3259), n3(:,4287), t3x72(:,:,3259), nhel, den(14))
    call Hcont_QA(nsync, wf6(:,108), wf12(:,87), A(:,3260), n3(:,4288), t3x72(:,:,3260), nhel, den(14))
    call Hcont_QA(nsync, wf6(:,115), wf12(:,88), A(:,3261), n3(:,4289), t3x72(:,:,3261), nhel, den(8))
    call Hcont_QA(nsync, wf6(:,116), wf12(:,88), A(:,3262), n3(:,4290), t3x72(:,:,3262), nhel, den(8))
    call Hcont_QA(nsync, wf6(:,117), wf12(:,88), A(:,3263), n3(:,4291), t3x72(:,:,3263), nhel, den(8))
    call Hcont_QA(nsync, wf6(:,118), wf12(:,88), A(:,3264), n3(:,4292), t3x72(:,:,3264), nhel, den(8))
    call Hcont_QA(nsync, wf6(:,109), wf12(:,89), A(:,3265), n3(:,4293), t3x72(:,:,3265), nhel, den(18))
    call Hcont_QA(nsync, wf6(:,110), wf12(:,89), A(:,3266), n3(:,4294), t3x72(:,:,3266), nhel, den(18))
    call Hcont_QA(nsync, wf6(:,111), wf12(:,89), A(:,3267), n3(:,4295), t3x72(:,:,3267), nhel, den(18))
    call Hcont_QA(nsync, wf6(:,112), wf12(:,89), A(:,3268), n3(:,4296), t3x72(:,:,3268), nhel, den(18))
    call Hcont_QA(nsync, wf6(:,119), wf12(:,90), A(:,3269), n3(:,4297), t3x72(:,:,3269), nhel, den(3))
    call Hcont_QA(nsync, wf6(:,120), wf12(:,90), A(:,3270), n3(:,4298), t3x72(:,:,3270), nhel, den(3))
    call Hcont_QA(nsync, wf6(:,121), wf12(:,90), A(:,3271), n3(:,4299), t3x72(:,:,3271), nhel, den(3))
    call Hcont_QA(nsync, wf6(:,122), wf12(:,90), A(:,3272), n3(:,4300), t3x72(:,:,3272), nhel, den(3))
    call Hcont_QA(nsync, wf18(:,61), wf4(:,37), A(:,3273), n3(:,4301), t3x72(:,:,3273), nhel, den(5))
    call Hcont_QA(nsync, wf6(:,114), wf12(:,87), A(:,3274), n3(:,4302), t3x72(:,:,3274), nhel, den(14))
    call Hcont_QA(nsync, wf4(:,37), wf18(:,62), A(:,3275), n3(:,4303), t3x72(:,:,3275), nhel, den(11))
    call Hcont_QA(nsync, wf6(:,113), wf12(:,89), A(:,3276), n3(:,4304), t3x72(:,:,3276), nhel, den(18))
    call Hcont_QA(nsync, wf4(:,9), wf18(:,64), A(:,3277), n3(:,4305), t3x72(:,:,3277), nhel, den(61))
    call Hcont_QA(nsync, wf4(:,9), wf18(:,66), A(:,3278), n3(:,4306), t3x72(:,:,3278), nhel, den(61))
    call Hcont_QA(nsync, wf4(:,9), wf18(:,68), A(:,3279), n3(:,4307), t3x72(:,:,3279), nhel, den(62))
    call Hcont_QA(nsync, wf4(:,9), wf18(:,70), A(:,3280), n3(:,4308), t3x72(:,:,3280), nhel, den(62))
    call Hcont_QA(nsync, wf6(:,103), wf12(:,91), A(:,3281), n3(:,4309), t3x72(:,:,3281), nhel, den(5))
    call Hcont_QA(nsync, wf6(:,103), wf12(:,92), A(:,3282), n3(:,4310), t3x72(:,:,3282), nhel, den(5))
    call Hcont_QA(nsync, wf6(:,103), wf12(:,93), A(:,3283), n3(:,4311), t3x72(:,:,3283), nhel, den(5))
    call Hcont_QA(nsync, wf6(:,103), wf12(:,94), A(:,3284), n3(:,4312), t3x72(:,:,3284), nhel, den(5))
    call Hcont_QA(nsync, wf12(:,95), wf6(:,123), A(:,3285), n3(:,4313), t3x72(:,:,3285), nhel, den(30))
    call Hcont_QA(nsync, wf12(:,95), wf6(:,124), A(:,3286), n3(:,4314), t3x72(:,:,3286), nhel, den(30))
    call Hcont_QA(nsync, wf12(:,95), wf6(:,125), A(:,3287), n3(:,4315), t3x72(:,:,3287), nhel, den(30))
    call Hcont_QA(nsync, wf12(:,95), wf6(:,126), A(:,3288), n3(:,4316), t3x72(:,:,3288), nhel, den(30))
    call Hcont_VV(nsync, wf8(:,6), wf9(:,11), A(:,3289), n3(:,4317), t3x72(:,:,3289), nhel, den(60))
    call Hcont_VV(nsync, wf8(:,6), wf9(:,12), A(:,3290), n3(:,4318), t3x72(:,:,3290), nhel, den(60))
    call Hcont_VV(nsync, wf8(:,6), wf9(:,11), A(:,3291), n3(:,4319), t3x72(:,:,3291), nhel, den(60))
    call Hcont_VV(nsync, wf8(:,6), wf9(:,12), A(:,3292), n3(:,4320), t3x72(:,:,3292), nhel, den(60))
    call Hcont_QA(nsync, wf6(:,104), wf12(:,96), A(:,3293), n3(:,4321), t3x72(:,:,3293), nhel, den(11))
    call Hcont_QA(nsync, wf6(:,104), wf12(:,97), A(:,3294), n3(:,4322), t3x72(:,:,3294), nhel, den(11))
    call Hcont_QA(nsync, wf6(:,104), wf12(:,98), A(:,3295), n3(:,4323), t3x72(:,:,3295), nhel, den(11))
    call Hcont_QA(nsync, wf6(:,104), wf12(:,99), A(:,3296), n3(:,4324), t3x72(:,:,3296), nhel, den(11))
    call Hcont_QA(nsync, wf12(:,100), wf6(:,127), A(:,3297), n3(:,4325), t3x72(:,:,3297), nhel, den(29))
    call Hcont_QA(nsync, wf12(:,100), wf6(:,128), A(:,3298), n3(:,4326), t3x72(:,:,3298), nhel, den(29))
    call Hcont_QA(nsync, wf12(:,100), wf6(:,129), A(:,3299), n3(:,4327), t3x72(:,:,3299), nhel, den(29))
    call Hcont_QA(nsync, wf12(:,100), wf6(:,130), A(:,3300), n3(:,4328), t3x72(:,:,3300), nhel, den(29))
    call Hcont_VV(nsync, wf8(:,6), wf9(:,13), A(:,3301), n3(:,4329), t3x72(:,:,3301), nhel, den(60))
    call Hcont_VV(nsync, wf8(:,6), wf9(:,14), A(:,3302), n3(:,4330), t3x72(:,:,3302), nhel, den(60))
    call Hcont_VV(nsync, wf8(:,6), wf9(:,13), A(:,3303), n3(:,4331), t3x72(:,:,3303), nhel, den(60))
    call Hcont_VV(nsync, wf8(:,6), wf9(:,14), A(:,3304), n3(:,4332), t3x72(:,:,3304), nhel, den(60))
    call Hcont_VV(nsync, wf9(:,2), wf8(:,14), A(:,3305), n3(:,4333), t3x72(:,:,3305), nhel, den(56))
    call Hcont_VV(nsync, wf9(:,1), wf8(:,14), A(:,3306), n3(:,4334), t3x72(:,:,3306), nhel, den(56))
    call Hcont_VV(nsync, wf9(:,2), wf8(:,15), A(:,3307), n3(:,4335), t3x72(:,:,3307), nhel, den(57))
    call Hcont_VV(nsync, wf9(:,1), wf8(:,15), A(:,3308), n3(:,4336), t3x72(:,:,3308), nhel, den(57))
    call Hcont_QA(nsync, wf12(:,100), wf6(:,131), A(:,3309), n3(:,4337), t3x72(:,:,3309), nhel, den(29))
    call Hcont_QA(nsync, wf12(:,95), wf6(:,132), A(:,3310), n3(:,4338), t3x72(:,:,3310), nhel, den(30))
    call Hcont_QA(nsync, wf4(:,22), wf18(:,71), A(:,3311), n3(:,4339), t3x72(:,:,3311), nhel, den(10))
    call Hcont_QA(nsync, wf4(:,22), wf18(:,72), A(:,3312), n3(:,4340), t3x72(:,:,3312), nhel, den(10))
    call Hcont_QA(nsync, wf4(:,22), wf18(:,73), A(:,3313), n3(:,4341), t3x72(:,:,3313), nhel, den(10))
    call Hcont_QA(nsync, wf4(:,22), wf18(:,74), A(:,3314), n3(:,4342), t3x72(:,:,3314), nhel, den(10))
    call Hcont_QA(nsync, wf12(:,72), wf6(:,133), A(:,3315), n3(:,4343), t3x72(:,:,3315), nhel, den(12))
    call Hcont_QA(nsync, wf12(:,72), wf6(:,134), A(:,3316), n3(:,4344), t3x72(:,:,3316), nhel, den(12))
    call Hcont_QA(nsync, wf12(:,72), wf6(:,135), A(:,3317), n3(:,4345), t3x72(:,:,3317), nhel, den(12))
    call Hcont_QA(nsync, wf12(:,72), wf6(:,136), A(:,3318), n3(:,4346), t3x72(:,:,3318), nhel, den(12))
    call Hcont_VV(nsync, wf9(:,11), wf8(:,16), A(:,3319), n3(:,4347), t3x72(:,:,3319), nhel, den(59))
    call Hcont_VV(nsync, wf9(:,12), wf8(:,16), A(:,3320), n3(:,4348), t3x72(:,:,3320), nhel, den(59))
    call Hcont_VV(nsync, wf9(:,11), wf8(:,16), A(:,3321), n3(:,4349), t3x72(:,:,3321), nhel, den(59))
    call Hcont_VV(nsync, wf9(:,12), wf8(:,16), A(:,3322), n3(:,4350), t3x72(:,:,3322), nhel, den(59))
    call Hcont_QA(nsync, wf4(:,22), wf18(:,75), A(:,3323), n3(:,4351), t3x72(:,:,3323), nhel, den(12))
    call Hcont_QA(nsync, wf4(:,22), wf18(:,76), A(:,3324), n3(:,4352), t3x72(:,:,3324), nhel, den(12))
    call Hcont_QA(nsync, wf4(:,22), wf18(:,77), A(:,3325), n3(:,4353), t3x72(:,:,3325), nhel, den(12))
    call Hcont_QA(nsync, wf4(:,22), wf18(:,78), A(:,3326), n3(:,4354), t3x72(:,:,3326), nhel, den(12))
    call Hcont_QA(nsync, wf12(:,71), wf6(:,137), A(:,3327), n3(:,4355), t3x72(:,:,3327), nhel, den(10))
    call Hcont_QA(nsync, wf12(:,71), wf6(:,138), A(:,3328), n3(:,4356), t3x72(:,:,3328), nhel, den(10))
    call Hcont_QA(nsync, wf12(:,71), wf6(:,139), A(:,3329), n3(:,4357), t3x72(:,:,3329), nhel, den(10))
    call Hcont_QA(nsync, wf12(:,71), wf6(:,140), A(:,3330), n3(:,4358), t3x72(:,:,3330), nhel, den(10))
    call Hcont_VV(nsync, wf9(:,13), wf8(:,16), A(:,3331), n3(:,4359), t3x72(:,:,3331), nhel, den(59))
    call Hcont_VV(nsync, wf9(:,14), wf8(:,16), A(:,3332), n3(:,4360), t3x72(:,:,3332), nhel, den(59))
    call Hcont_VV(nsync, wf9(:,13), wf8(:,16), A(:,3333), n3(:,4361), t3x72(:,:,3333), nhel, den(59))
    call Hcont_VV(nsync, wf9(:,14), wf8(:,16), A(:,3334), n3(:,4362), t3x72(:,:,3334), nhel, den(59))
    call Hcont_QA(nsync, wf6(:,123), wf12(:,101), A(:,3335), n3(:,4363), t3x72(:,:,3335), nhel, den(23))
    call Hcont_QA(nsync, wf6(:,124), wf12(:,101), A(:,3336), n3(:,4364), t3x72(:,:,3336), nhel, den(23))
    call Hcont_QA(nsync, wf6(:,125), wf12(:,101), A(:,3337), n3(:,4365), t3x72(:,:,3337), nhel, den(23))
    call Hcont_QA(nsync, wf6(:,126), wf12(:,101), A(:,3338), n3(:,4366), t3x72(:,:,3338), nhel, den(23))
    call Hcont_QA(nsync, wf12(:,75), wf6(:,133), A(:,3339), n3(:,4367), t3x72(:,:,3339), nhel, den(3))
    call Hcont_QA(nsync, wf12(:,75), wf6(:,134), A(:,3340), n3(:,4368), t3x72(:,:,3340), nhel, den(3))
    call Hcont_QA(nsync, wf12(:,75), wf6(:,135), A(:,3341), n3(:,4369), t3x72(:,:,3341), nhel, den(3))
    call Hcont_QA(nsync, wf12(:,75), wf6(:,136), A(:,3342), n3(:,4370), t3x72(:,:,3342), nhel, den(3))
    call Hcont_QA(nsync, wf6(:,127), wf12(:,102), A(:,3343), n3(:,4371), t3x72(:,:,3343), nhel, den(27))
    call Hcont_QA(nsync, wf6(:,128), wf12(:,102), A(:,3344), n3(:,4372), t3x72(:,:,3344), nhel, den(27))
    call Hcont_QA(nsync, wf6(:,129), wf12(:,102), A(:,3345), n3(:,4373), t3x72(:,:,3345), nhel, den(27))
    call Hcont_QA(nsync, wf6(:,130), wf12(:,102), A(:,3346), n3(:,4374), t3x72(:,:,3346), nhel, den(27))
    call Hcont_QA(nsync, wf12(:,76), wf6(:,137), A(:,3347), n3(:,4375), t3x72(:,:,3347), nhel, den(8))
    call Hcont_QA(nsync, wf12(:,76), wf6(:,138), A(:,3348), n3(:,4376), t3x72(:,:,3348), nhel, den(8))
    call Hcont_QA(nsync, wf12(:,76), wf6(:,139), A(:,3349), n3(:,4377), t3x72(:,:,3349), nhel, den(8))
    call Hcont_QA(nsync, wf12(:,76), wf6(:,140), A(:,3350), n3(:,4378), t3x72(:,:,3350), nhel, den(8))
    call Hcont_QA(nsync, wf18(:,79), wf4(:,38), A(:,3351), n3(:,4379), t3x72(:,:,3351), nhel, den(10))
    call Hcont_QA(nsync, wf6(:,132), wf12(:,101), A(:,3352), n3(:,4380), t3x72(:,:,3352), nhel, den(23))
    call Hcont_QA(nsync, wf4(:,38), wf18(:,80), A(:,3353), n3(:,4381), t3x72(:,:,3353), nhel, den(12))
    call Hcont_QA(nsync, wf6(:,131), wf12(:,102), A(:,3354), n3(:,4382), t3x72(:,:,3354), nhel, den(27))
    call Hcont_QA(nsync, wf4(:,10), wf18(:,82), A(:,3355), n3(:,4383), t3x72(:,:,3355), nhel, den(63))
    call Hcont_QA(nsync, wf4(:,10), wf18(:,84), A(:,3356), n3(:,4384), t3x72(:,:,3356), nhel, den(63))
    call Hcont_QA(nsync, wf4(:,10), wf18(:,86), A(:,3357), n3(:,4385), t3x72(:,:,3357), nhel, den(64))
    call Hcont_QA(nsync, wf4(:,10), wf18(:,88), A(:,3358), n3(:,4386), t3x72(:,:,3358), nhel, den(64))
    call Hcont_QA(nsync, wf4(:,20), wf18(:,89), A(:,3359), n3(:,4387), t3x72(:,:,3359), nhel, den(5))
    call Hcont_QA(nsync, wf4(:,20), wf18(:,90), A(:,3360), n3(:,4388), t3x72(:,:,3360), nhel, den(5))
    call Hcont_QA(nsync, wf4(:,20), wf18(:,91), A(:,3361), n3(:,4389), t3x72(:,:,3361), nhel, den(5))
    call Hcont_QA(nsync, wf4(:,20), wf18(:,92), A(:,3362), n3(:,4390), t3x72(:,:,3362), nhel, den(5))
    call Hcont_QA(nsync, wf6(:,105), wf12(:,103), A(:,3363), n3(:,4391), t3x72(:,:,3363), nhel, den(14))
    call Hcont_QA(nsync, wf6(:,106), wf12(:,103), A(:,3364), n3(:,4392), t3x72(:,:,3364), nhel, den(14))
    call Hcont_QA(nsync, wf6(:,107), wf12(:,103), A(:,3365), n3(:,4393), t3x72(:,:,3365), nhel, den(14))
    call Hcont_QA(nsync, wf6(:,108), wf12(:,103), A(:,3366), n3(:,4394), t3x72(:,:,3366), nhel, den(14))
    call Hcont_QA(nsync, wf4(:,37), wf18(:,93), A(:,3367), n3(:,4395), t3x72(:,:,3367), nhel, den(5))
    call Hcont_QA(nsync, wf6(:,114), wf12(:,103), A(:,3368), n3(:,4396), t3x72(:,:,3368), nhel, den(14))
    call Hcont_QA(nsync, wf4(:,22), wf18(:,94), A(:,3369), n3(:,4397), t3x72(:,:,3369), nhel, den(10))
    call Hcont_QA(nsync, wf4(:,22), wf18(:,95), A(:,3370), n3(:,4398), t3x72(:,:,3370), nhel, den(10))
    call Hcont_QA(nsync, wf4(:,22), wf18(:,96), A(:,3371), n3(:,4399), t3x72(:,:,3371), nhel, den(10))
    call Hcont_QA(nsync, wf4(:,22), wf18(:,97), A(:,3372), n3(:,4400), t3x72(:,:,3372), nhel, den(10))
    call Hcont_QA(nsync, wf6(:,105), wf12(:,105), A(:,3373), n3(:,4401), t3x72(:,:,3373), nhel, den(21))
    call Hcont_QA(nsync, wf6(:,106), wf12(:,105), A(:,3374), n3(:,4402), t3x72(:,:,3374), nhel, den(21))
    call Hcont_QA(nsync, wf6(:,107), wf12(:,105), A(:,3375), n3(:,4403), t3x72(:,:,3375), nhel, den(21))
    call Hcont_QA(nsync, wf6(:,108), wf12(:,105), A(:,3376), n3(:,4404), t3x72(:,:,3376), nhel, den(21))
    call Hcont_QA(nsync, wf4(:,22), wf18(:,98), A(:,3377), n3(:,4405), t3x72(:,:,3377), nhel, den(38))
    call Hcont_QA(nsync, wf12(:,71), wf6(:,141), A(:,3378), n3(:,4406), t3x72(:,:,3378), nhel, den(10))
    call Hcont_QA(nsync, wf6(:,114), wf12(:,105), A(:,3379), n3(:,4407), t3x72(:,:,3379), nhel, den(21))
    call Hcont_QA(nsync, wf6(:,123), wf12(:,106), A(:,3380), n3(:,4408), t3x72(:,:,3380), nhel, den(23))
    call Hcont_QA(nsync, wf6(:,124), wf12(:,106), A(:,3381), n3(:,4409), t3x72(:,:,3381), nhel, den(23))
    call Hcont_QA(nsync, wf6(:,125), wf12(:,106), A(:,3382), n3(:,4410), t3x72(:,:,3382), nhel, den(23))
    call Hcont_QA(nsync, wf6(:,126), wf12(:,106), A(:,3383), n3(:,4411), t3x72(:,:,3383), nhel, den(23))
    call Hcont_QA(nsync, wf6(:,123), wf12(:,108), A(:,3384), n3(:,4412), t3x72(:,:,3384), nhel, den(30))
    call Hcont_QA(nsync, wf6(:,124), wf12(:,108), A(:,3385), n3(:,4413), t3x72(:,:,3385), nhel, den(30))
    call Hcont_QA(nsync, wf6(:,125), wf12(:,108), A(:,3386), n3(:,4414), t3x72(:,:,3386), nhel, den(30))
    call Hcont_QA(nsync, wf6(:,126), wf12(:,108), A(:,3387), n3(:,4415), t3x72(:,:,3387), nhel, den(30))
    call Hcont_QA(nsync, wf4(:,37), wf18(:,99), A(:,3388), n3(:,4416), t3x72(:,:,3388), nhel, den(39))
    call Hcont_QA(nsync, wf12(:,76), wf6(:,141), A(:,3389), n3(:,4417), t3x72(:,:,3389), nhel, den(8))
    call Hcont_QA(nsync, wf4(:,9), wf18(:,101), A(:,3390), n3(:,4418), t3x72(:,:,3390), nhel, den(19))
    call Hcont_QA(nsync, wf4(:,38), wf18(:,102), A(:,3391), n3(:,4419), t3x72(:,:,3391), nhel, den(10))
    call Hcont_QA(nsync, wf6(:,132), wf12(:,106), A(:,3392), n3(:,4420), t3x72(:,:,3392), nhel, den(23))
    call Hcont_QA(nsync, wf4(:,20), wf18(:,103), A(:,3393), n3(:,4421), t3x72(:,:,3393), nhel, den(39))
    call Hcont_QA(nsync, wf12(:,73), wf6(:,142), A(:,3394), n3(:,4422), t3x72(:,:,3394), nhel, den(5))
    call Hcont_QA(nsync, wf6(:,132), wf12(:,108), A(:,3395), n3(:,4423), t3x72(:,:,3395), nhel, den(30))
    call Hcont_QA(nsync, wf4(:,38), wf18(:,104), A(:,3396), n3(:,4424), t3x72(:,:,3396), nhel, den(38))
    call Hcont_QA(nsync, wf12(:,90), wf6(:,142), A(:,3397), n3(:,4425), t3x72(:,:,3397), nhel, den(3))
    call Hcont_QA(nsync, wf4(:,10), wf18(:,106), A(:,3398), n3(:,4426), t3x72(:,:,3398), nhel, den(28))
    call Hcont_QA(nsync, wf4(:,20), wf18(:,107), A(:,3399), n3(:,4427), t3x72(:,:,3399), nhel, den(11))
    call Hcont_QA(nsync, wf4(:,20), wf18(:,108), A(:,3400), n3(:,4428), t3x72(:,:,3400), nhel, den(11))
    call Hcont_QA(nsync, wf4(:,20), wf18(:,109), A(:,3401), n3(:,4429), t3x72(:,:,3401), nhel, den(11))
    call Hcont_QA(nsync, wf4(:,20), wf18(:,110), A(:,3402), n3(:,4430), t3x72(:,:,3402), nhel, den(11))
    call Hcont_QA(nsync, wf6(:,109), wf12(:,110), A(:,3403), n3(:,4431), t3x72(:,:,3403), nhel, den(18))
    call Hcont_QA(nsync, wf6(:,110), wf12(:,110), A(:,3404), n3(:,4432), t3x72(:,:,3404), nhel, den(18))
    call Hcont_QA(nsync, wf6(:,111), wf12(:,110), A(:,3405), n3(:,4433), t3x72(:,:,3405), nhel, den(18))
    call Hcont_QA(nsync, wf6(:,112), wf12(:,110), A(:,3406), n3(:,4434), t3x72(:,:,3406), nhel, den(18))
    call Hcont_QA(nsync, wf4(:,37), wf18(:,111), A(:,3407), n3(:,4435), t3x72(:,:,3407), nhel, den(11))
    call Hcont_QA(nsync, wf6(:,113), wf12(:,110), A(:,3408), n3(:,4436), t3x72(:,:,3408), nhel, den(18))
    call Hcont_QA(nsync, wf4(:,22), wf18(:,112), A(:,3409), n3(:,4437), t3x72(:,:,3409), nhel, den(12))
    call Hcont_QA(nsync, wf4(:,22), wf18(:,113), A(:,3410), n3(:,4438), t3x72(:,:,3410), nhel, den(12))
    call Hcont_QA(nsync, wf4(:,22), wf18(:,114), A(:,3411), n3(:,4439), t3x72(:,:,3411), nhel, den(12))
    call Hcont_QA(nsync, wf4(:,22), wf18(:,115), A(:,3412), n3(:,4440), t3x72(:,:,3412), nhel, den(12))
    call Hcont_QA(nsync, wf6(:,109), wf12(:,112), A(:,3413), n3(:,4441), t3x72(:,:,3413), nhel, den(20))
    call Hcont_QA(nsync, wf6(:,110), wf12(:,112), A(:,3414), n3(:,4442), t3x72(:,:,3414), nhel, den(20))
    call Hcont_QA(nsync, wf6(:,111), wf12(:,112), A(:,3415), n3(:,4443), t3x72(:,:,3415), nhel, den(20))
    call Hcont_QA(nsync, wf6(:,112), wf12(:,112), A(:,3416), n3(:,4444), t3x72(:,:,3416), nhel, den(20))
    call Hcont_QA(nsync, wf4(:,22), wf18(:,116), A(:,3417), n3(:,4445), t3x72(:,:,3417), nhel, den(38))
    call Hcont_QA(nsync, wf12(:,72), wf6(:,143), A(:,3418), n3(:,4446), t3x72(:,:,3418), nhel, den(12))
    call Hcont_QA(nsync, wf6(:,113), wf12(:,112), A(:,3419), n3(:,4447), t3x72(:,:,3419), nhel, den(20))
    call Hcont_QA(nsync, wf6(:,127), wf12(:,114), A(:,3420), n3(:,4448), t3x72(:,:,3420), nhel, den(27))
    call Hcont_QA(nsync, wf6(:,128), wf12(:,114), A(:,3421), n3(:,4449), t3x72(:,:,3421), nhel, den(27))
    call Hcont_QA(nsync, wf6(:,129), wf12(:,114), A(:,3422), n3(:,4450), t3x72(:,:,3422), nhel, den(27))
    call Hcont_QA(nsync, wf6(:,130), wf12(:,114), A(:,3423), n3(:,4451), t3x72(:,:,3423), nhel, den(27))
    call Hcont_QA(nsync, wf6(:,127), wf12(:,116), A(:,3424), n3(:,4452), t3x72(:,:,3424), nhel, den(29))
    call Hcont_QA(nsync, wf6(:,128), wf12(:,116), A(:,3425), n3(:,4453), t3x72(:,:,3425), nhel, den(29))
    call Hcont_QA(nsync, wf6(:,129), wf12(:,116), A(:,3426), n3(:,4454), t3x72(:,:,3426), nhel, den(29))
    call Hcont_QA(nsync, wf6(:,130), wf12(:,116), A(:,3427), n3(:,4455), t3x72(:,:,3427), nhel, den(29))
    call Hcont_QA(nsync, wf4(:,37), wf18(:,117), A(:,3428), n3(:,4456), t3x72(:,:,3428), nhel, den(39))
    call Hcont_QA(nsync, wf12(:,75), wf6(:,143), A(:,3429), n3(:,4457), t3x72(:,:,3429), nhel, den(3))
    call Hcont_QA(nsync, wf4(:,9), wf18(:,119), A(:,3430), n3(:,4458), t3x72(:,:,3430), nhel, den(16))
    call Hcont_QA(nsync, wf4(:,38), wf18(:,120), A(:,3431), n3(:,4459), t3x72(:,:,3431), nhel, den(12))
    call Hcont_QA(nsync, wf6(:,131), wf12(:,114), A(:,3432), n3(:,4460), t3x72(:,:,3432), nhel, den(27))
    call Hcont_QA(nsync, wf4(:,20), wf18(:,121), A(:,3433), n3(:,4461), t3x72(:,:,3433), nhel, den(39))
    call Hcont_QA(nsync, wf12(:,74), wf6(:,144), A(:,3434), n3(:,4462), t3x72(:,:,3434), nhel, den(11))
    call Hcont_QA(nsync, wf6(:,131), wf12(:,116), A(:,3435), n3(:,4463), t3x72(:,:,3435), nhel, den(29))
    call Hcont_QA(nsync, wf4(:,38), wf18(:,122), A(:,3436), n3(:,4464), t3x72(:,:,3436), nhel, den(38))
    call Hcont_QA(nsync, wf12(:,88), wf6(:,144), A(:,3437), n3(:,4465), t3x72(:,:,3437), nhel, den(8))
    call Hcont_QA(nsync, wf4(:,10), wf18(:,124), A(:,3438), n3(:,4466), t3x72(:,:,3438), nhel, den(25))
    call Hcont_VV(nsync, wf9(:,2), wf8(:,57), A(:,3439), n3(:,4467), t3x72(:,:,3439), nhel, den(53))
    call Hcont_VV(nsync, wf9(:,1), wf8(:,57), A(:,3440), n3(:,4468), t3x72(:,:,3440), nhel, den(53))
    call Hcont_VV(nsync, wf9(:,2), wf8(:,58), A(:,3441), n3(:,4469), t3x72(:,:,3441), nhel, den(55))
    call Hcont_VV(nsync, wf9(:,1), wf8(:,58), A(:,3442), n3(:,4470), t3x72(:,:,3442), nhel, den(55))
    call Hcont_QA(nsync, wf12(:,86), wf6(:,413), A(:,3443), n3(:,4471), t3x72(:,:,3443), nhel, den(20))
    call Hcont_QA(nsync, wf12(:,81), wf6(:,414), A(:,3444), n3(:,4472), t3x72(:,:,3444), nhel, den(21))
    call Hcont_QA(nsync, wf4(:,29), wf18(:,61), A(:,3445), n3(:,4473), t3x72(:,:,3445), nhel, den(5))
    call Hcont_QA(nsync, wf12(:,87), wf6(:,414), A(:,3446), n3(:,4474), t3x72(:,:,3446), nhel, den(14))
    call Hcont_QA(nsync, wf4(:,29), wf18(:,62), A(:,3447), n3(:,4475), t3x72(:,:,3447), nhel, den(11))
    call Hcont_QA(nsync, wf12(:,89), wf6(:,413), A(:,3448), n3(:,4476), t3x72(:,:,3448), nhel, den(18))
    call Hcont_QA(nsync, wf4(:,5), wf18(:,64), A(:,3449), n3(:,4477), t3x72(:,:,3449), nhel, den(61))
    call Hcont_QA(nsync, wf4(:,5), wf18(:,66), A(:,3450), n3(:,4478), t3x72(:,:,3450), nhel, den(61))
    call Hcont_QA(nsync, wf4(:,5), wf18(:,68), A(:,3451), n3(:,4479), t3x72(:,:,3451), nhel, den(62))
    call Hcont_QA(nsync, wf4(:,5), wf18(:,70), A(:,3452), n3(:,4480), t3x72(:,:,3452), nhel, den(62))
    call Hcont_VV(nsync, wf9(:,2), wf8(:,59), A(:,3453), n3(:,4481), t3x72(:,:,3453), nhel, den(56))
    call Hcont_VV(nsync, wf9(:,1), wf8(:,59), A(:,3454), n3(:,4482), t3x72(:,:,3454), nhel, den(56))
    call Hcont_VV(nsync, wf9(:,2), wf8(:,60), A(:,3455), n3(:,4483), t3x72(:,:,3455), nhel, den(57))
    call Hcont_VV(nsync, wf9(:,1), wf8(:,60), A(:,3456), n3(:,4484), t3x72(:,:,3456), nhel, den(57))
    call Hcont_QA(nsync, wf12(:,100), wf6(:,415), A(:,3457), n3(:,4485), t3x72(:,:,3457), nhel, den(29))
    call Hcont_QA(nsync, wf12(:,95), wf6(:,416), A(:,3458), n3(:,4486), t3x72(:,:,3458), nhel, den(30))
    call Hcont_QA(nsync, wf4(:,30), wf18(:,79), A(:,3459), n3(:,4487), t3x72(:,:,3459), nhel, den(10))
    call Hcont_QA(nsync, wf12(:,101), wf6(:,416), A(:,3460), n3(:,4488), t3x72(:,:,3460), nhel, den(23))
    call Hcont_QA(nsync, wf4(:,30), wf18(:,80), A(:,3461), n3(:,4489), t3x72(:,:,3461), nhel, den(12))
    call Hcont_QA(nsync, wf12(:,102), wf6(:,415), A(:,3462), n3(:,4490), t3x72(:,:,3462), nhel, den(27))
    call Hcont_QA(nsync, wf4(:,6), wf18(:,82), A(:,3463), n3(:,4491), t3x72(:,:,3463), nhel, den(63))
    call Hcont_QA(nsync, wf4(:,6), wf18(:,84), A(:,3464), n3(:,4492), t3x72(:,:,3464), nhel, den(63))
    call Hcont_QA(nsync, wf4(:,6), wf18(:,86), A(:,3465), n3(:,4493), t3x72(:,:,3465), nhel, den(64))
    call Hcont_QA(nsync, wf4(:,6), wf18(:,88), A(:,3466), n3(:,4494), t3x72(:,:,3466), nhel, den(64))
    call Hcont_QA(nsync, wf4(:,14), wf18(:,277), A(:,3467), n3(:,4495), t3x72(:,:,3467), nhel, den(5))
    call Hcont_QA(nsync, wf4(:,14), wf18(:,278), A(:,3468), n3(:,4496), t3x72(:,:,3468), nhel, den(5))
    call Hcont_QA(nsync, wf4(:,14), wf18(:,279), A(:,3469), n3(:,4497), t3x72(:,:,3469), nhel, den(5))
    call Hcont_QA(nsync, wf4(:,14), wf18(:,280), A(:,3470), n3(:,4498), t3x72(:,:,3470), nhel, den(5))
    call Hcont_QA(nsync, wf12(:,41), wf6(:,365), A(:,3471), n3(:,4499), t3x72(:,:,3471), nhel, den(14))
    call Hcont_QA(nsync, wf12(:,41), wf6(:,366), A(:,3472), n3(:,4500), t3x72(:,:,3472), nhel, den(14))
    call Hcont_QA(nsync, wf12(:,41), wf6(:,367), A(:,3473), n3(:,4501), t3x72(:,:,3473), nhel, den(14))
    call Hcont_QA(nsync, wf12(:,41), wf6(:,368), A(:,3474), n3(:,4502), t3x72(:,:,3474), nhel, den(14))
    call Hcont_QA(nsync, wf4(:,29), wf18(:,93), A(:,3475), n3(:,4503), t3x72(:,:,3475), nhel, den(5))
    call Hcont_QA(nsync, wf12(:,103), wf6(:,414), A(:,3476), n3(:,4504), t3x72(:,:,3476), nhel, den(14))
    call Hcont_QA(nsync, wf4(:,12), wf18(:,281), A(:,3477), n3(:,4505), t3x72(:,:,3477), nhel, den(10))
    call Hcont_QA(nsync, wf4(:,12), wf18(:,282), A(:,3478), n3(:,4506), t3x72(:,:,3478), nhel, den(10))
    call Hcont_QA(nsync, wf4(:,12), wf18(:,283), A(:,3479), n3(:,4507), t3x72(:,:,3479), nhel, den(10))
    call Hcont_QA(nsync, wf4(:,12), wf18(:,284), A(:,3480), n3(:,4508), t3x72(:,:,3480), nhel, den(10))
    call Hcont_QA(nsync, wf12(:,47), wf6(:,365), A(:,3481), n3(:,4509), t3x72(:,:,3481), nhel, den(21))
    call Hcont_QA(nsync, wf12(:,47), wf6(:,366), A(:,3482), n3(:,4510), t3x72(:,:,3482), nhel, den(21))
    call Hcont_QA(nsync, wf12(:,47), wf6(:,367), A(:,3483), n3(:,4511), t3x72(:,:,3483), nhel, den(21))
    call Hcont_QA(nsync, wf12(:,47), wf6(:,368), A(:,3484), n3(:,4512), t3x72(:,:,3484), nhel, den(21))
    call Hcont_QA(nsync, wf4(:,22), wf18(:,285), A(:,3485), n3(:,4513), t3x72(:,:,3485), nhel, den(38))
    call Hcont_QA(nsync, wf6(:,87), wf12(:,71), A(:,3486), n3(:,4514), t3x72(:,:,3486), nhel, den(10))
    call Hcont_QA(nsync, wf12(:,105), wf6(:,414), A(:,3487), n3(:,4515), t3x72(:,:,3487), nhel, den(21))
    call Hcont_QA(nsync, wf12(:,48), wf6(:,357), A(:,3488), n3(:,4516), t3x72(:,:,3488), nhel, den(23))
    call Hcont_QA(nsync, wf12(:,48), wf6(:,358), A(:,3489), n3(:,4517), t3x72(:,:,3489), nhel, den(23))
    call Hcont_QA(nsync, wf12(:,48), wf6(:,359), A(:,3490), n3(:,4518), t3x72(:,:,3490), nhel, den(23))
    call Hcont_QA(nsync, wf12(:,48), wf6(:,360), A(:,3491), n3(:,4519), t3x72(:,:,3491), nhel, den(23))
    call Hcont_QA(nsync, wf12(:,54), wf6(:,357), A(:,3492), n3(:,4520), t3x72(:,:,3492), nhel, den(30))
    call Hcont_QA(nsync, wf12(:,54), wf6(:,358), A(:,3493), n3(:,4521), t3x72(:,:,3493), nhel, den(30))
    call Hcont_QA(nsync, wf12(:,54), wf6(:,359), A(:,3494), n3(:,4522), t3x72(:,:,3494), nhel, den(30))
    call Hcont_QA(nsync, wf12(:,54), wf6(:,360), A(:,3495), n3(:,4523), t3x72(:,:,3495), nhel, den(30))
    call Hcont_QA(nsync, wf4(:,29), wf18(:,99), A(:,3496), n3(:,4524), t3x72(:,:,3496), nhel, den(39))
    call Hcont_QA(nsync, wf6(:,87), wf12(:,76), A(:,3497), n3(:,4525), t3x72(:,:,3497), nhel, den(8))
    call Hcont_QA(nsync, wf4(:,5), wf18(:,101), A(:,3498), n3(:,4526), t3x72(:,:,3498), nhel, den(19))
    call Hcont_QA(nsync, wf4(:,30), wf18(:,102), A(:,3499), n3(:,4527), t3x72(:,:,3499), nhel, den(10))
    call Hcont_QA(nsync, wf12(:,106), wf6(:,416), A(:,3500), n3(:,4528), t3x72(:,:,3500), nhel, den(23))
    call Hcont_QA(nsync, wf4(:,20), wf18(:,286), A(:,3501), n3(:,4529), t3x72(:,:,3501), nhel, den(39))
    call Hcont_QA(nsync, wf6(:,85), wf12(:,73), A(:,3502), n3(:,4530), t3x72(:,:,3502), nhel, den(5))
    call Hcont_QA(nsync, wf12(:,108), wf6(:,416), A(:,3503), n3(:,4531), t3x72(:,:,3503), nhel, den(30))
    call Hcont_QA(nsync, wf4(:,30), wf18(:,104), A(:,3504), n3(:,4532), t3x72(:,:,3504), nhel, den(38))
    call Hcont_QA(nsync, wf6(:,85), wf12(:,90), A(:,3505), n3(:,4533), t3x72(:,:,3505), nhel, den(3))
    call Hcont_QA(nsync, wf4(:,6), wf18(:,106), A(:,3506), n3(:,4534), t3x72(:,:,3506), nhel, den(28))
    call Hcont_QA(nsync, wf4(:,14), wf18(:,287), A(:,3507), n3(:,4535), t3x72(:,:,3507), nhel, den(11))
    call Hcont_QA(nsync, wf4(:,14), wf18(:,288), A(:,3508), n3(:,4536), t3x72(:,:,3508), nhel, den(11))
    call Hcont_QA(nsync, wf4(:,14), wf18(:,289), A(:,3509), n3(:,4537), t3x72(:,:,3509), nhel, den(11))
    call Hcont_QA(nsync, wf4(:,14), wf18(:,290), A(:,3510), n3(:,4538), t3x72(:,:,3510), nhel, den(11))
    call Hcont_QA(nsync, wf12(:,43), wf6(:,369), A(:,3511), n3(:,4539), t3x72(:,:,3511), nhel, den(18))
    call Hcont_QA(nsync, wf12(:,43), wf6(:,370), A(:,3512), n3(:,4540), t3x72(:,:,3512), nhel, den(18))
    call Hcont_QA(nsync, wf12(:,43), wf6(:,371), A(:,3513), n3(:,4541), t3x72(:,:,3513), nhel, den(18))
    call Hcont_QA(nsync, wf12(:,43), wf6(:,372), A(:,3514), n3(:,4542), t3x72(:,:,3514), nhel, den(18))
    call Hcont_QA(nsync, wf4(:,29), wf18(:,111), A(:,3515), n3(:,4543), t3x72(:,:,3515), nhel, den(11))
    call Hcont_QA(nsync, wf12(:,110), wf6(:,413), A(:,3516), n3(:,4544), t3x72(:,:,3516), nhel, den(18))
    call Hcont_QA(nsync, wf4(:,12), wf18(:,291), A(:,3517), n3(:,4545), t3x72(:,:,3517), nhel, den(12))
    call Hcont_QA(nsync, wf4(:,12), wf18(:,292), A(:,3518), n3(:,4546), t3x72(:,:,3518), nhel, den(12))
    call Hcont_QA(nsync, wf4(:,12), wf18(:,293), A(:,3519), n3(:,4547), t3x72(:,:,3519), nhel, den(12))
    call Hcont_QA(nsync, wf4(:,12), wf18(:,294), A(:,3520), n3(:,4548), t3x72(:,:,3520), nhel, den(12))
    call Hcont_QA(nsync, wf12(:,45), wf6(:,369), A(:,3521), n3(:,4549), t3x72(:,:,3521), nhel, den(20))
    call Hcont_QA(nsync, wf12(:,45), wf6(:,370), A(:,3522), n3(:,4550), t3x72(:,:,3522), nhel, den(20))
    call Hcont_QA(nsync, wf12(:,45), wf6(:,371), A(:,3523), n3(:,4551), t3x72(:,:,3523), nhel, den(20))
    call Hcont_QA(nsync, wf12(:,45), wf6(:,372), A(:,3524), n3(:,4552), t3x72(:,:,3524), nhel, den(20))
    call Hcont_QA(nsync, wf4(:,22), wf18(:,295), A(:,3525), n3(:,4553), t3x72(:,:,3525), nhel, den(38))
    call Hcont_QA(nsync, wf6(:,86), wf12(:,72), A(:,3526), n3(:,4554), t3x72(:,:,3526), nhel, den(12))
    call Hcont_QA(nsync, wf12(:,112), wf6(:,413), A(:,3527), n3(:,4555), t3x72(:,:,3527), nhel, den(20))
    call Hcont_QA(nsync, wf12(:,50), wf6(:,361), A(:,3528), n3(:,4556), t3x72(:,:,3528), nhel, den(27))
    call Hcont_QA(nsync, wf12(:,50), wf6(:,362), A(:,3529), n3(:,4557), t3x72(:,:,3529), nhel, den(27))
    call Hcont_QA(nsync, wf12(:,50), wf6(:,363), A(:,3530), n3(:,4558), t3x72(:,:,3530), nhel, den(27))
    call Hcont_QA(nsync, wf12(:,50), wf6(:,364), A(:,3531), n3(:,4559), t3x72(:,:,3531), nhel, den(27))
    call Hcont_QA(nsync, wf12(:,52), wf6(:,361), A(:,3532), n3(:,4560), t3x72(:,:,3532), nhel, den(29))
    call Hcont_QA(nsync, wf12(:,52), wf6(:,362), A(:,3533), n3(:,4561), t3x72(:,:,3533), nhel, den(29))
    call Hcont_QA(nsync, wf12(:,52), wf6(:,363), A(:,3534), n3(:,4562), t3x72(:,:,3534), nhel, den(29))
    call Hcont_QA(nsync, wf12(:,52), wf6(:,364), A(:,3535), n3(:,4563), t3x72(:,:,3535), nhel, den(29))
    call Hcont_QA(nsync, wf4(:,29), wf18(:,117), A(:,3536), n3(:,4564), t3x72(:,:,3536), nhel, den(39))
    call Hcont_QA(nsync, wf6(:,86), wf12(:,75), A(:,3537), n3(:,4565), t3x72(:,:,3537), nhel, den(3))
    call Hcont_QA(nsync, wf4(:,5), wf18(:,119), A(:,3538), n3(:,4566), t3x72(:,:,3538), nhel, den(16))
    call Hcont_QA(nsync, wf4(:,30), wf18(:,120), A(:,3539), n3(:,4567), t3x72(:,:,3539), nhel, den(12))
    call Hcont_QA(nsync, wf12(:,114), wf6(:,415), A(:,3540), n3(:,4568), t3x72(:,:,3540), nhel, den(27))
    call Hcont_QA(nsync, wf4(:,20), wf18(:,296), A(:,3541), n3(:,4569), t3x72(:,:,3541), nhel, den(39))
    call Hcont_QA(nsync, wf6(:,88), wf12(:,74), A(:,3542), n3(:,4570), t3x72(:,:,3542), nhel, den(11))
    call Hcont_QA(nsync, wf12(:,116), wf6(:,415), A(:,3543), n3(:,4571), t3x72(:,:,3543), nhel, den(29))
    call Hcont_QA(nsync, wf4(:,30), wf18(:,122), A(:,3544), n3(:,4572), t3x72(:,:,3544), nhel, den(38))
    call Hcont_QA(nsync, wf6(:,88), wf12(:,88), A(:,3545), n3(:,4573), t3x72(:,:,3545), nhel, den(8))
    call Hcont_QA(nsync, wf4(:,6), wf18(:,124), A(:,3546), n3(:,4574), t3x72(:,:,3546), nhel, den(25))
    call Hcont_VV(nsync, wf9(:,2), wf8(:,61), A(:,3547), n3(:,4575), t3x72(:,:,3547), nhel, den(53))
    call Hcont_VV(nsync, wf9(:,1), wf8(:,61), A(:,3548), n3(:,4576), t3x72(:,:,3548), nhel, den(53))
    call Hcont_VV(nsync, wf9(:,2), wf8(:,62), A(:,3549), n3(:,4577), t3x72(:,:,3549), nhel, den(55))
    call Hcont_VV(nsync, wf9(:,1), wf8(:,62), A(:,3550), n3(:,4578), t3x72(:,:,3550), nhel, den(55))
    call Hcont_QA(nsync, wf12(:,86), wf6(:,417), A(:,3551), n3(:,4579), t3x72(:,:,3551), nhel, den(20))
    call Hcont_QA(nsync, wf12(:,81), wf6(:,418), A(:,3552), n3(:,4580), t3x72(:,:,3552), nhel, den(21))
    call Hcont_QA(nsync, wf4(:,33), wf18(:,61), A(:,3553), n3(:,4581), t3x72(:,:,3553), nhel, den(5))
    call Hcont_QA(nsync, wf12(:,87), wf6(:,418), A(:,3554), n3(:,4582), t3x72(:,:,3554), nhel, den(14))
    call Hcont_QA(nsync, wf4(:,33), wf18(:,62), A(:,3555), n3(:,4583), t3x72(:,:,3555), nhel, den(11))
    call Hcont_QA(nsync, wf12(:,89), wf6(:,417), A(:,3556), n3(:,4584), t3x72(:,:,3556), nhel, den(18))
    call Hcont_QA(nsync, wf4(:,7), wf18(:,64), A(:,3557), n3(:,4585), t3x72(:,:,3557), nhel, den(61))
    call Hcont_QA(nsync, wf4(:,7), wf18(:,66), A(:,3558), n3(:,4586), t3x72(:,:,3558), nhel, den(61))
    call Hcont_QA(nsync, wf4(:,7), wf18(:,68), A(:,3559), n3(:,4587), t3x72(:,:,3559), nhel, den(62))
    call Hcont_QA(nsync, wf4(:,7), wf18(:,70), A(:,3560), n3(:,4588), t3x72(:,:,3560), nhel, den(62))
    call Hcont_VV(nsync, wf9(:,2), wf8(:,63), A(:,3561), n3(:,4589), t3x72(:,:,3561), nhel, den(56))
    call Hcont_VV(nsync, wf9(:,1), wf8(:,63), A(:,3562), n3(:,4590), t3x72(:,:,3562), nhel, den(56))
    call Hcont_VV(nsync, wf9(:,2), wf8(:,64), A(:,3563), n3(:,4591), t3x72(:,:,3563), nhel, den(57))
    call Hcont_VV(nsync, wf9(:,1), wf8(:,64), A(:,3564), n3(:,4592), t3x72(:,:,3564), nhel, den(57))
    call Hcont_QA(nsync, wf12(:,100), wf6(:,419), A(:,3565), n3(:,4593), t3x72(:,:,3565), nhel, den(29))
    call Hcont_QA(nsync, wf12(:,95), wf6(:,420), A(:,3566), n3(:,4594), t3x72(:,:,3566), nhel, den(30))
    call Hcont_QA(nsync, wf4(:,34), wf18(:,79), A(:,3567), n3(:,4595), t3x72(:,:,3567), nhel, den(10))
    call Hcont_QA(nsync, wf12(:,101), wf6(:,420), A(:,3568), n3(:,4596), t3x72(:,:,3568), nhel, den(23))
    call Hcont_QA(nsync, wf4(:,34), wf18(:,80), A(:,3569), n3(:,4597), t3x72(:,:,3569), nhel, den(12))
    call Hcont_QA(nsync, wf12(:,102), wf6(:,419), A(:,3570), n3(:,4598), t3x72(:,:,3570), nhel, den(27))
    call Hcont_QA(nsync, wf4(:,8), wf18(:,82), A(:,3571), n3(:,4599), t3x72(:,:,3571), nhel, den(63))
    call Hcont_QA(nsync, wf4(:,8), wf18(:,84), A(:,3572), n3(:,4600), t3x72(:,:,3572), nhel, den(63))
    call Hcont_QA(nsync, wf4(:,8), wf18(:,86), A(:,3573), n3(:,4601), t3x72(:,:,3573), nhel, den(64))
    call Hcont_QA(nsync, wf4(:,8), wf18(:,88), A(:,3574), n3(:,4602), t3x72(:,:,3574), nhel, den(64))
    call Hcont_QA(nsync, wf4(:,18), wf18(:,297), A(:,3575), n3(:,4603), t3x72(:,:,3575), nhel, den(5))
    call Hcont_QA(nsync, wf4(:,18), wf18(:,298), A(:,3576), n3(:,4604), t3x72(:,:,3576), nhel, den(5))
    call Hcont_QA(nsync, wf4(:,18), wf18(:,299), A(:,3577), n3(:,4605), t3x72(:,:,3577), nhel, den(5))
    call Hcont_QA(nsync, wf4(:,18), wf18(:,300), A(:,3578), n3(:,4606), t3x72(:,:,3578), nhel, den(5))
    call Hcont_QA(nsync, wf12(:,57), wf6(:,381), A(:,3579), n3(:,4607), t3x72(:,:,3579), nhel, den(14))
    call Hcont_QA(nsync, wf12(:,57), wf6(:,382), A(:,3580), n3(:,4608), t3x72(:,:,3580), nhel, den(14))
    call Hcont_QA(nsync, wf12(:,57), wf6(:,383), A(:,3581), n3(:,4609), t3x72(:,:,3581), nhel, den(14))
    call Hcont_QA(nsync, wf12(:,57), wf6(:,384), A(:,3582), n3(:,4610), t3x72(:,:,3582), nhel, den(14))
    call Hcont_QA(nsync, wf4(:,33), wf18(:,93), A(:,3583), n3(:,4611), t3x72(:,:,3583), nhel, den(5))
    call Hcont_QA(nsync, wf12(:,103), wf6(:,418), A(:,3584), n3(:,4612), t3x72(:,:,3584), nhel, den(14))
    call Hcont_QA(nsync, wf4(:,16), wf18(:,301), A(:,3585), n3(:,4613), t3x72(:,:,3585), nhel, den(10))
    call Hcont_QA(nsync, wf4(:,16), wf18(:,302), A(:,3586), n3(:,4614), t3x72(:,:,3586), nhel, den(10))
    call Hcont_QA(nsync, wf4(:,16), wf18(:,303), A(:,3587), n3(:,4615), t3x72(:,:,3587), nhel, den(10))
    call Hcont_QA(nsync, wf4(:,16), wf18(:,304), A(:,3588), n3(:,4616), t3x72(:,:,3588), nhel, den(10))
    call Hcont_QA(nsync, wf12(:,63), wf6(:,381), A(:,3589), n3(:,4617), t3x72(:,:,3589), nhel, den(21))
    call Hcont_QA(nsync, wf12(:,63), wf6(:,382), A(:,3590), n3(:,4618), t3x72(:,:,3590), nhel, den(21))
    call Hcont_QA(nsync, wf12(:,63), wf6(:,383), A(:,3591), n3(:,4619), t3x72(:,:,3591), nhel, den(21))
    call Hcont_QA(nsync, wf12(:,63), wf6(:,384), A(:,3592), n3(:,4620), t3x72(:,:,3592), nhel, den(21))
    call Hcont_QA(nsync, wf4(:,22), wf18(:,305), A(:,3593), n3(:,4621), t3x72(:,:,3593), nhel, den(38))
    call Hcont_QA(nsync, wf6(:,95), wf12(:,71), A(:,3594), n3(:,4622), t3x72(:,:,3594), nhel, den(10))
    call Hcont_QA(nsync, wf12(:,105), wf6(:,418), A(:,3595), n3(:,4623), t3x72(:,:,3595), nhel, den(21))
    call Hcont_QA(nsync, wf12(:,64), wf6(:,373), A(:,3596), n3(:,4624), t3x72(:,:,3596), nhel, den(23))
    call Hcont_QA(nsync, wf12(:,64), wf6(:,374), A(:,3597), n3(:,4625), t3x72(:,:,3597), nhel, den(23))
    call Hcont_QA(nsync, wf12(:,64), wf6(:,375), A(:,3598), n3(:,4626), t3x72(:,:,3598), nhel, den(23))
    call Hcont_QA(nsync, wf12(:,64), wf6(:,376), A(:,3599), n3(:,4627), t3x72(:,:,3599), nhel, den(23))
    call Hcont_QA(nsync, wf12(:,70), wf6(:,373), A(:,3600), n3(:,4628), t3x72(:,:,3600), nhel, den(30))
    call Hcont_QA(nsync, wf12(:,70), wf6(:,374), A(:,3601), n3(:,4629), t3x72(:,:,3601), nhel, den(30))
    call Hcont_QA(nsync, wf12(:,70), wf6(:,375), A(:,3602), n3(:,4630), t3x72(:,:,3602), nhel, den(30))
    call Hcont_QA(nsync, wf12(:,70), wf6(:,376), A(:,3603), n3(:,4631), t3x72(:,:,3603), nhel, den(30))
    call Hcont_QA(nsync, wf4(:,33), wf18(:,99), A(:,3604), n3(:,4632), t3x72(:,:,3604), nhel, den(39))
    call Hcont_QA(nsync, wf6(:,95), wf12(:,76), A(:,3605), n3(:,4633), t3x72(:,:,3605), nhel, den(8))
    call Hcont_QA(nsync, wf4(:,7), wf18(:,101), A(:,3606), n3(:,4634), t3x72(:,:,3606), nhel, den(19))
    call Hcont_QA(nsync, wf4(:,34), wf18(:,102), A(:,3607), n3(:,4635), t3x72(:,:,3607), nhel, den(10))
    call Hcont_QA(nsync, wf12(:,106), wf6(:,420), A(:,3608), n3(:,4636), t3x72(:,:,3608), nhel, den(23))
    call Hcont_QA(nsync, wf4(:,20), wf18(:,306), A(:,3609), n3(:,4637), t3x72(:,:,3609), nhel, den(39))
    call Hcont_QA(nsync, wf6(:,93), wf12(:,73), A(:,3610), n3(:,4638), t3x72(:,:,3610), nhel, den(5))
    call Hcont_QA(nsync, wf12(:,108), wf6(:,420), A(:,3611), n3(:,4639), t3x72(:,:,3611), nhel, den(30))
    call Hcont_QA(nsync, wf4(:,34), wf18(:,104), A(:,3612), n3(:,4640), t3x72(:,:,3612), nhel, den(38))
    call Hcont_QA(nsync, wf6(:,93), wf12(:,90), A(:,3613), n3(:,4641), t3x72(:,:,3613), nhel, den(3))
    call Hcont_QA(nsync, wf4(:,8), wf18(:,106), A(:,3614), n3(:,4642), t3x72(:,:,3614), nhel, den(28))
    call Hcont_QA(nsync, wf4(:,18), wf18(:,307), A(:,3615), n3(:,4643), t3x72(:,:,3615), nhel, den(11))
    call Hcont_QA(nsync, wf4(:,18), wf18(:,308), A(:,3616), n3(:,4644), t3x72(:,:,3616), nhel, den(11))
    call Hcont_QA(nsync, wf4(:,18), wf18(:,309), A(:,3617), n3(:,4645), t3x72(:,:,3617), nhel, den(11))
    call Hcont_QA(nsync, wf4(:,18), wf18(:,310), A(:,3618), n3(:,4646), t3x72(:,:,3618), nhel, den(11))
    call Hcont_QA(nsync, wf12(:,59), wf6(:,385), A(:,3619), n3(:,4647), t3x72(:,:,3619), nhel, den(18))
    call Hcont_QA(nsync, wf12(:,59), wf6(:,386), A(:,3620), n3(:,4648), t3x72(:,:,3620), nhel, den(18))
    call Hcont_QA(nsync, wf12(:,59), wf6(:,387), A(:,3621), n3(:,4649), t3x72(:,:,3621), nhel, den(18))
    call Hcont_QA(nsync, wf12(:,59), wf6(:,388), A(:,3622), n3(:,4650), t3x72(:,:,3622), nhel, den(18))
    call Hcont_QA(nsync, wf4(:,33), wf18(:,111), A(:,3623), n3(:,4651), t3x72(:,:,3623), nhel, den(11))
    call Hcont_QA(nsync, wf12(:,110), wf6(:,417), A(:,3624), n3(:,4652), t3x72(:,:,3624), nhel, den(18))
    call Hcont_QA(nsync, wf4(:,16), wf18(:,311), A(:,3625), n3(:,4653), t3x72(:,:,3625), nhel, den(12))
    call Hcont_QA(nsync, wf4(:,16), wf18(:,312), A(:,3626), n3(:,4654), t3x72(:,:,3626), nhel, den(12))
    call Hcont_QA(nsync, wf4(:,16), wf18(:,313), A(:,3627), n3(:,4655), t3x72(:,:,3627), nhel, den(12))
    call Hcont_QA(nsync, wf4(:,16), wf18(:,314), A(:,3628), n3(:,4656), t3x72(:,:,3628), nhel, den(12))
    call Hcont_QA(nsync, wf12(:,61), wf6(:,385), A(:,3629), n3(:,4657), t3x72(:,:,3629), nhel, den(20))
    call Hcont_QA(nsync, wf12(:,61), wf6(:,386), A(:,3630), n3(:,4658), t3x72(:,:,3630), nhel, den(20))
    call Hcont_QA(nsync, wf12(:,61), wf6(:,387), A(:,3631), n3(:,4659), t3x72(:,:,3631), nhel, den(20))
    call Hcont_QA(nsync, wf12(:,61), wf6(:,388), A(:,3632), n3(:,4660), t3x72(:,:,3632), nhel, den(20))
    call Hcont_QA(nsync, wf4(:,22), wf18(:,315), A(:,3633), n3(:,4661), t3x72(:,:,3633), nhel, den(38))
    call Hcont_QA(nsync, wf6(:,94), wf12(:,72), A(:,3634), n3(:,4662), t3x72(:,:,3634), nhel, den(12))
    call Hcont_QA(nsync, wf12(:,112), wf6(:,417), A(:,3635), n3(:,4663), t3x72(:,:,3635), nhel, den(20))
    call Hcont_QA(nsync, wf12(:,66), wf6(:,377), A(:,3636), n3(:,4664), t3x72(:,:,3636), nhel, den(27))
    call Hcont_QA(nsync, wf12(:,66), wf6(:,378), A(:,3637), n3(:,4665), t3x72(:,:,3637), nhel, den(27))
    call Hcont_QA(nsync, wf12(:,66), wf6(:,379), A(:,3638), n3(:,4666), t3x72(:,:,3638), nhel, den(27))
    call Hcont_QA(nsync, wf12(:,66), wf6(:,380), A(:,3639), n3(:,4667), t3x72(:,:,3639), nhel, den(27))
    call Hcont_QA(nsync, wf12(:,68), wf6(:,377), A(:,3640), n3(:,4668), t3x72(:,:,3640), nhel, den(29))
    call Hcont_QA(nsync, wf12(:,68), wf6(:,378), A(:,3641), n3(:,4669), t3x72(:,:,3641), nhel, den(29))
    call Hcont_QA(nsync, wf12(:,68), wf6(:,379), A(:,3642), n3(:,4670), t3x72(:,:,3642), nhel, den(29))
    call Hcont_QA(nsync, wf12(:,68), wf6(:,380), A(:,3643), n3(:,4671), t3x72(:,:,3643), nhel, den(29))
    call Hcont_QA(nsync, wf4(:,33), wf18(:,117), A(:,3644), n3(:,4672), t3x72(:,:,3644), nhel, den(39))
    call Hcont_QA(nsync, wf6(:,94), wf12(:,75), A(:,3645), n3(:,4673), t3x72(:,:,3645), nhel, den(3))
    call Hcont_QA(nsync, wf4(:,7), wf18(:,119), A(:,3646), n3(:,4674), t3x72(:,:,3646), nhel, den(16))
    call Hcont_QA(nsync, wf4(:,34), wf18(:,120), A(:,3647), n3(:,4675), t3x72(:,:,3647), nhel, den(12))
    call Hcont_QA(nsync, wf12(:,114), wf6(:,419), A(:,3648), n3(:,4676), t3x72(:,:,3648), nhel, den(27))
    call Hcont_QA(nsync, wf4(:,20), wf18(:,316), A(:,3649), n3(:,4677), t3x72(:,:,3649), nhel, den(39))
    call Hcont_QA(nsync, wf6(:,96), wf12(:,74), A(:,3650), n3(:,4678), t3x72(:,:,3650), nhel, den(11))
    call Hcont_QA(nsync, wf12(:,116), wf6(:,419), A(:,3651), n3(:,4679), t3x72(:,:,3651), nhel, den(29))
    call Hcont_QA(nsync, wf4(:,34), wf18(:,122), A(:,3652), n3(:,4680), t3x72(:,:,3652), nhel, den(38))
    call Hcont_QA(nsync, wf6(:,96), wf12(:,88), A(:,3653), n3(:,4681), t3x72(:,:,3653), nhel, den(8))
    call Hcont_QA(nsync, wf4(:,8), wf18(:,124), A(:,3654), n3(:,4682), t3x72(:,:,3654), nhel, den(25))
    call Hcont_QA(nsync, wf6(:,40), wf12(:,17), A(:,3655), n3(:,4683), t3x72(:,:,3655), nhel, den(8))
    call Hcont_QA(nsync, wf4(:,12), wf18(:,9), A(:,3656), n3(:,4684), t3x72(:,:,3656), nhel, den(10))
    call Hcont_QA(nsync, wf6(:,44), wf12(:,18), A(:,3657), n3(:,4685), t3x72(:,:,3657), nhel, den(3))
    call Hcont_QA(nsync, wf4(:,12), wf18(:,10), A(:,3658), n3(:,4686), t3x72(:,:,3658), nhel, den(12))
    call Hcont_QA(nsync, wf4(:,14), wf18(:,11), A(:,3659), n3(:,4687), t3x72(:,:,3659), nhel, den(5))
    call Hcont_QA(nsync, wf4(:,14), wf18(:,12), A(:,3660), n3(:,4688), t3x72(:,:,3660), nhel, den(11))
    call Hcont_QA(nsync, wf12(:,17), wf6(:,48), A(:,3661), n3(:,4689), t3x72(:,:,3661), nhel, den(8))
    call Hcont_QA(nsync, wf18(:,9), wf4(:,16), A(:,3662), n3(:,4690), t3x72(:,:,3662), nhel, den(10))
    call Hcont_QA(nsync, wf6(:,44), wf12(:,20), A(:,3663), n3(:,4691), t3x72(:,:,3663), nhel, den(3))
    call Hcont_QA(nsync, wf18(:,10), wf4(:,16), A(:,3664), n3(:,4692), t3x72(:,:,3664), nhel, den(12))
    call Hcont_QA(nsync, wf4(:,14), wf18(:,15), A(:,3665), n3(:,4693), t3x72(:,:,3665), nhel, den(5))
    call Hcont_QA(nsync, wf4(:,14), wf18(:,16), A(:,3666), n3(:,4694), t3x72(:,:,3666), nhel, den(11))
    call Hcont_QA(nsync, wf6(:,40), wf12(:,19), A(:,3667), n3(:,4695), t3x72(:,:,3667), nhel, den(8))
    call Hcont_QA(nsync, wf4(:,12), wf18(:,13), A(:,3668), n3(:,4696), t3x72(:,:,3668), nhel, den(10))
    call Hcont_QA(nsync, wf12(:,18), wf6(:,52), A(:,3669), n3(:,4697), t3x72(:,:,3669), nhel, den(3))
    call Hcont_QA(nsync, wf4(:,12), wf18(:,14), A(:,3670), n3(:,4698), t3x72(:,:,3670), nhel, den(12))
    call Hcont_QA(nsync, wf18(:,11), wf4(:,18), A(:,3671), n3(:,4699), t3x72(:,:,3671), nhel, den(5))
    call Hcont_QA(nsync, wf18(:,12), wf4(:,18), A(:,3672), n3(:,4700), t3x72(:,:,3672), nhel, den(11))
    call Hcont_QA(nsync, wf6(:,48), wf12(:,19), A(:,3673), n3(:,4701), t3x72(:,:,3673), nhel, den(8))
    call Hcont_QA(nsync, wf4(:,16), wf18(:,13), A(:,3674), n3(:,4702), t3x72(:,:,3674), nhel, den(10))
    call Hcont_QA(nsync, wf6(:,52), wf12(:,20), A(:,3675), n3(:,4703), t3x72(:,:,3675), nhel, den(3))
    call Hcont_QA(nsync, wf4(:,16), wf18(:,14), A(:,3676), n3(:,4704), t3x72(:,:,3676), nhel, den(12))
    call Hcont_QA(nsync, wf4(:,18), wf18(:,15), A(:,3677), n3(:,4705), t3x72(:,:,3677), nhel, den(5))
    call Hcont_QA(nsync, wf4(:,18), wf18(:,16), A(:,3678), n3(:,4706), t3x72(:,:,3678), nhel, den(11))
    call Hcont_VV(nsync, wf8(:,1), wf9(:,1), A(:,3679), n3(:,4707), t3x72(:,:,3679), nhel, den(32))
    call Hcont_VV(nsync, wf8(:,1), wf9(:,2), A(:,3680), n3(:,4708), t3x72(:,:,3680), nhel, den(32))
    call Hcont_VV(nsync, wf9(:,1), wf8(:,2), A(:,3681), n3(:,4709), t3x72(:,:,3681), nhel, den(34))
    call Hcont_VV(nsync, wf9(:,2), wf8(:,2), A(:,3682), n3(:,4710), t3x72(:,:,3682), nhel, den(34))
    call Hcont_VV(nsync, wf9(:,1), wf8(:,3), A(:,3683), n3(:,4711), t3x72(:,:,3683), nhel, den(35))
    call Hcont_VV(nsync, wf9(:,2), wf8(:,3), A(:,3684), n3(:,4712), t3x72(:,:,3684), nhel, den(35))
    call Hcont_VV(nsync, wf9(:,1), wf8(:,4), A(:,3685), n3(:,4713), t3x72(:,:,3685), nhel, den(36))
    call Hcont_VV(nsync, wf9(:,2), wf8(:,4), A(:,3686), n3(:,4714), t3x72(:,:,3686), nhel, den(36))
    call Hcont_QA(nsync, wf18(:,17), wf4(:,20), A(:,3687), n3(:,4715), t3x72(:,:,3687), nhel, den(5))
    call Hcont_QA(nsync, wf12(:,5), wf6(:,53), A(:,3688), n3(:,4716), t3x72(:,:,3688), nhel, den(14))
    call Hcont_VV(nsync, wf9(:,3), wf8(:,5), A(:,3689), n3(:,4717), t3x72(:,:,3689), nhel, den(38))
    call Hcont_QA(nsync, wf12(:,21), wf6(:,55), A(:,3690), n3(:,4718), t3x72(:,:,3690), nhel, den(10))
    call Hcont_QA(nsync, wf12(:,8), wf6(:,53), A(:,3691), n3(:,4719), t3x72(:,:,3691), nhel, den(21))
    call Hcont_QA(nsync, wf6(:,55), wf12(:,22), A(:,3692), n3(:,4720), t3x72(:,:,3692), nhel, den(8))
    call Hcont_QA(nsync, wf4(:,20), wf18(:,18), A(:,3693), n3(:,4721), t3x72(:,:,3693), nhel, den(11))
    call Hcont_QA(nsync, wf4(:,20), wf18(:,19), A(:,3694), n3(:,4722), t3x72(:,:,3694), nhel, den(39))
    call Hcont_QA(nsync, wf4(:,20), wf18(:,20), A(:,3695), n3(:,4723), t3x72(:,:,3695), nhel, den(11))
    call Hcont_QA(nsync, wf12(:,6), wf6(:,58), A(:,3696), n3(:,4724), t3x72(:,:,3696), nhel, den(18))
    call Hcont_VV(nsync, wf8(:,5), wf9(:,4), A(:,3697), n3(:,4725), t3x72(:,:,3697), nhel, den(38))
    call Hcont_QA(nsync, wf12(:,23), wf6(:,60), A(:,3698), n3(:,4726), t3x72(:,:,3698), nhel, den(12))
    call Hcont_QA(nsync, wf12(:,7), wf6(:,58), A(:,3699), n3(:,4727), t3x72(:,:,3699), nhel, den(20))
    call Hcont_QA(nsync, wf6(:,60), wf12(:,24), A(:,3700), n3(:,4728), t3x72(:,:,3700), nhel, den(3))
    call Hcont_QA(nsync, wf4(:,20), wf18(:,21), A(:,3701), n3(:,4729), t3x72(:,:,3701), nhel, den(5))
    call Hcont_QA(nsync, wf4(:,20), wf18(:,22), A(:,3702), n3(:,4730), t3x72(:,:,3702), nhel, den(39))
    call Hcont_QA(nsync, wf18(:,23), wf4(:,22), A(:,3703), n3(:,4731), t3x72(:,:,3703), nhel, den(10))
    call Hcont_QA(nsync, wf12(:,10), wf6(:,63), A(:,3704), n3(:,4732), t3x72(:,:,3704), nhel, den(23))
    call Hcont_VV(nsync, wf9(:,5), wf8(:,6), A(:,3705), n3(:,4733), t3x72(:,:,3705), nhel, den(39))
    call Hcont_QA(nsync, wf12(:,25), wf6(:,65), A(:,3706), n3(:,4734), t3x72(:,:,3706), nhel, den(5))
    call Hcont_QA(nsync, wf12(:,16), wf6(:,63), A(:,3707), n3(:,4735), t3x72(:,:,3707), nhel, den(30))
    call Hcont_QA(nsync, wf6(:,65), wf12(:,26), A(:,3708), n3(:,4736), t3x72(:,:,3708), nhel, den(3))
    call Hcont_QA(nsync, wf4(:,22), wf18(:,24), A(:,3709), n3(:,4737), t3x72(:,:,3709), nhel, den(12))
    call Hcont_QA(nsync, wf4(:,22), wf18(:,25), A(:,3710), n3(:,4738), t3x72(:,:,3710), nhel, den(38))
    call Hcont_QA(nsync, wf4(:,22), wf18(:,26), A(:,3711), n3(:,4739), t3x72(:,:,3711), nhel, den(12))
    call Hcont_QA(nsync, wf12(:,12), wf6(:,68), A(:,3712), n3(:,4740), t3x72(:,:,3712), nhel, den(27))
    call Hcont_VV(nsync, wf8(:,6), wf9(:,6), A(:,3713), n3(:,4741), t3x72(:,:,3713), nhel, den(39))
    call Hcont_QA(nsync, wf12(:,27), wf6(:,70), A(:,3714), n3(:,4742), t3x72(:,:,3714), nhel, den(11))
    call Hcont_QA(nsync, wf12(:,14), wf6(:,68), A(:,3715), n3(:,4743), t3x72(:,:,3715), nhel, den(29))
    call Hcont_QA(nsync, wf6(:,70), wf12(:,28), A(:,3716), n3(:,4744), t3x72(:,:,3716), nhel, den(8))
    call Hcont_QA(nsync, wf4(:,22), wf18(:,27), A(:,3717), n3(:,4745), t3x72(:,:,3717), nhel, den(10))
    call Hcont_QA(nsync, wf4(:,22), wf18(:,28), A(:,3718), n3(:,4746), t3x72(:,:,3718), nhel, den(38))
    call Hcont_QA(nsync, wf6(:,70), wf12(:,29), A(:,3719), n3(:,4747), t3x72(:,:,3719), nhel, den(8))
    call Hcont_QA(nsync, wf4(:,22), wf18(:,29), A(:,3720), n3(:,4748), t3x72(:,:,3720), nhel, den(10))
    call Hcont_QA(nsync, wf6(:,60), wf12(:,30), A(:,3721), n3(:,4749), t3x72(:,:,3721), nhel, den(3))
    call Hcont_QA(nsync, wf4(:,22), wf18(:,30), A(:,3722), n3(:,4750), t3x72(:,:,3722), nhel, den(12))
    call Hcont_QA(nsync, wf4(:,20), wf18(:,31), A(:,3723), n3(:,4751), t3x72(:,:,3723), nhel, den(5))
    call Hcont_QA(nsync, wf4(:,20), wf18(:,32), A(:,3724), n3(:,4752), t3x72(:,:,3724), nhel, den(11))
    call Hcont_QA(nsync, wf12(:,23), wf6(:,67), A(:,3725), n3(:,4753), t3x72(:,:,3725), nhel, den(12))
    call Hcont_QA(nsync, wf12(:,21), wf6(:,72), A(:,3726), n3(:,4754), t3x72(:,:,3726), nhel, den(10))
    call Hcont_QA(nsync, wf6(:,57), wf12(:,27), A(:,3727), n3(:,4755), t3x72(:,:,3727), nhel, den(11))
    call Hcont_QA(nsync, wf6(:,62), wf12(:,25), A(:,3728), n3(:,4756), t3x72(:,:,3728), nhel, den(5))
    call Hcont_QA(nsync, wf12(:,22), wf6(:,72), A(:,3729), n3(:,4757), t3x72(:,:,3729), nhel, den(8))
    call Hcont_QA(nsync, wf12(:,24), wf6(:,67), A(:,3730), n3(:,4758), t3x72(:,:,3730), nhel, den(3))

end subroutine diagrams


elemental function diagmap(j, n)
  implicit none
  integer, intent(in) :: j, n
  complex(REALKIND) :: diagmap
  diagmap = A(j,n)%j
end function diagmap

function diagsum(j, pos, neg)
  implicit none
  integer, intent(in) :: j, pos(:), neg(:)
  complex(REALKIND) :: diagsum
  diagsum = sum(diagmap(j, pos)) - sum(diagmap(j, neg))
end function diagsum

subroutine colourvectors(A, j, M1, M2)
  implicit none
  type(Hpolcont) :: A(:,:)
  integer, intent(in) :: j
  type(Hpolcont), intent(out) :: M1(1), M2(1) ! M1helarray(1,nhel)
  integer :: empty(0), i

  M1(1)%j = (A(j,1)%j+A(j,2)%j+A(j,3)%j+A(j,4)%j+A(j,5)%j+A(j,6)%j)*f(1)

  M2(1)%j = (-A(j,155)%j-A(j,156)%j-A(j,157)%j-A(j,158)%j-A(j,159)%j-A(j,160)%j-A(j,161)%j-A(j,162)%j-A(j,163)%j-A(j,164)%j &
       -A(j,165)%j-A(j,166)%j+A(j,167)%j+A(j,168)%j+A(j,169)%j+A(j,170)%j+A(j,171)%j+A(j,172)%j+A(j,173)%j+A(j,174)%j+A(j,175)%j &
       +A(j,176)%j+A(j,177)%j+A(j,178)%j+A(j,179)%j+A(j,180)%j+A(j,181)%j+A(j,182)%j+A(j,183)%j+A(j,184)%j)*f(2)+(-A(j,13)%j &
       -A(j,14)%j-A(j,15)%j-A(j,16)%j-A(j,17)%j-A(j,18)%j)*f(3)+(-A(j,85)%j-A(j,86)%j-A(j,87)%j-A(j,88)%j-A(j,89)%j &
       -A(j,90)%j)*f(4)+(-A(j,25)%j-A(j,26)%j-A(j,27)%j-A(j,28)%j-A(j,29)%j-A(j,30)%j)*f(5)+(-A(j,91)%j-A(j,92)%j-A(j,93)%j &
       -A(j,94)%j-A(j,95)%j-A(j,96)%j)*f(6)+(-A(j,143)%j-A(j,144)%j-A(j,145)%j-A(j,146)%j-A(j,147)%j-A(j,148)%j)*f(7)+(-A(j,97)%j &
       -A(j,98)%j-A(j,99)%j-A(j,100)%j-A(j,101)%j-A(j,102)%j)*f(8)+(-A(j,7)%j-A(j,8)%j-A(j,9)%j-A(j,10)%j-A(j,11)%j &
       -A(j,12)%j)*f(9)+(-A(j,79)%j-A(j,80)%j-A(j,81)%j-A(j,82)%j-A(j,83)%j-A(j,84)%j)*f(10)+(-A(j,19)%j-A(j,20)%j-A(j,21)%j &
       -A(j,22)%j-A(j,23)%j-A(j,24)%j)*f(11)+(-A(j,137)%j-A(j,142)%j)*f(12)+(-A(j,135)%j-A(j,136)%j-A(j,138)%j-A(j,139)%j &
       -A(j,140)%j-A(j,141)%j)*f(13)+(-A(j,121)%j-A(j,126)%j)*f(14)+(-A(j,119)%j-A(j,120)%j-A(j,122)%j-A(j,123)%j-A(j,124)%j &
       -A(j,125)%j)*f(15)+(A(j,55)%j+A(j,56)%j+A(j,59)%j+A(j,60)%j+A(j,63)%j+A(j,64)%j+A(j,67)%j+A(j,68)%j+A(j,71)%j+A(j,72)%j &
       +A(j,75)%j+A(j,76)%j)*f(16)+(-A(j,57)%j-A(j,58)%j-A(j,61)%j-A(j,62)%j-A(j,65)%j-A(j,66)%j-A(j,69)%j-A(j,70)%j-A(j,73)%j &
       -A(j,74)%j-A(j,77)%j-A(j,78)%j)*f(17)+(-A(j,129)%j-A(j,134)%j)*f(18)+(-A(j,127)%j-A(j,128)%j-A(j,130)%j-A(j,131)%j &
       -A(j,132)%j-A(j,133)%j)*f(19)+(-A(j,113)%j-A(j,118)%j)*f(20)+(-A(j,111)%j-A(j,112)%j-A(j,114)%j-A(j,115)%j-A(j,116)%j &
       -A(j,117)%j)*f(21)+(-A(j,149)%j-A(j,150)%j-A(j,151)%j-A(j,152)%j-A(j,153)%j-A(j,154)%j)*f(22)+(-A(j,105)%j-A(j,106)%j &
       -A(j,109)%j-A(j,110)%j)*f(23)+(A(j,103)%j+A(j,104)%j+A(j,107)%j+A(j,108)%j)*f(24)+(A(j,31)%j+A(j,32)%j+A(j,35)%j+A(j,36)%j &
       +A(j,39)%j+A(j,40)%j+A(j,43)%j+A(j,44)%j+A(j,47)%j+A(j,48)%j+A(j,51)%j+A(j,52)%j)*f(25)+(-A(j,33)%j-A(j,34)%j-A(j,37)%j &
       -A(j,38)%j-A(j,41)%j-A(j,42)%j-A(j,45)%j-A(j,46)%j-A(j,49)%j-A(j,50)%j-A(j,53)%j-A(j,54)%j)*f(26)+(A(j,197)%j+A(j,198)%j &
       +A(j,199)%j+A(j,200)%j+A(j,201)%j+A(j,202)%j)*f(27)+(A(j,961)%j+A(j,962)%j+A(j,963)%j+A(j,964)%j+A(j,965)%j &
       +A(j,966)%j)*f(28)+(A(j,215)%j+A(j,216)%j+A(j,217)%j+A(j,218)%j+A(j,219)%j+A(j,220)%j)*f(29)+(A(j,479)%j+A(j,482)%j)*f(30) &
       +(A(j,477)%j+A(j,478)%j+A(j,480)%j+A(j,481)%j+A(j,483)%j+A(j,484)%j)*f(31)+(A(j,439)%j+A(j,442)%j)*f(32)+(A(j,437)%j &
       +A(j,438)%j+A(j,440)%j+A(j,441)%j+A(j,443)%j+A(j,444)%j)*f(33)+(A(j,937)%j+A(j,954)%j)*f(34)+(A(j,923)%j+A(j,924)%j &
       +A(j,938)%j+A(j,939)%j+A(j,952)%j+A(j,953)%j)*f(35)+(A(j,356)%j+A(j,397)%j+A(j,398)%j)*f(36)+(A(j,353)%j+A(j,403)%j)*f(37) &
       +(-A(j,351)%j-A(j,401)%j)*f(38)+(A(j,897)%j+A(j,914)%j)*f(39)+(A(j,883)%j+A(j,884)%j+A(j,898)%j+A(j,899)%j+A(j,912)%j &
       +A(j,913)%j)*f(40)+(A(j,355)%j+A(j,399)%j+A(j,400)%j)*f(41)+(A(j,354)%j+A(j,404)%j)*f(42)+(-A(j,352)%j-A(j,402)%j)*f(43) &
       +(A(j,185)%j+A(j,186)%j+A(j,187)%j+A(j,188)%j+A(j,189)%j+A(j,190)%j)*f(44)+(A(j,191)%j+A(j,192)%j+A(j,193)%j+A(j,194)%j &
       +A(j,195)%j+A(j,196)%j)*f(45)+(A(j,581)%j+A(j,582)%j+A(j,583)%j+A(j,584)%j+A(j,585)%j+A(j,586)%j)*f(46)+(A(j,955)%j &
       +A(j,956)%j+A(j,957)%j+A(j,958)%j+A(j,959)%j+A(j,960)%j)*f(47)+(A(j,203)%j+A(j,204)%j+A(j,205)%j+A(j,206)%j+A(j,207)%j &
       +A(j,208)%j)*f(48)+(A(j,209)%j+A(j,210)%j+A(j,211)%j+A(j,212)%j+A(j,213)%j+A(j,214)%j)*f(49)+(A(j,463)%j+A(j,474)%j)*f(50) &
       +(A(j,453)%j+A(j,454)%j+A(j,464)%j+A(j,465)%j+A(j,475)%j+A(j,476)%j)*f(51)+(A(j,423)%j+A(j,434)%j)*f(52)+(A(j,413)%j &
       +A(j,414)%j+A(j,424)%j+A(j,425)%j+A(j,435)%j+A(j,436)%j)*f(53)+(A(j,857)%j+A(j,874)%j)*f(54)+(A(j,843)%j+A(j,844)%j &
       +A(j,858)%j+A(j,859)%j+A(j,872)%j+A(j,873)%j)*f(55)+(A(j,278)%j+A(j,319)%j+A(j,320)%j)*f(56)+(A(j,276)%j+A(j,326)%j)*f(57) &
       +(-A(j,274)%j-A(j,324)%j)*f(58)+(A(j,817)%j+A(j,834)%j)*f(59)+(A(j,803)%j+A(j,804)%j+A(j,818)%j+A(j,819)%j+A(j,832)%j &
       +A(j,833)%j)*f(60)+(A(j,277)%j+A(j,321)%j+A(j,322)%j)*f(61)+(A(j,275)%j+A(j,325)%j)*f(62)+(-A(j,273)%j-A(j,323)%j)*f(63) &
       +(A(j,570)%j+A(j,572)%j+A(j,574)%j+A(j,576)%j+A(j,578)%j+A(j,580)%j)*f(64)+(-A(j,569)%j-A(j,571)%j-A(j,573)%j-A(j,575)%j &
       -A(j,577)%j-A(j,579)%j)*f(65)+(A(j,931)%j+A(j,932)%j+A(j,950)%j+A(j,951)%j)*f(66)+(A(j,917)%j+A(j,918)%j+A(j,921)%j &
       +A(j,922)%j+A(j,927)%j+A(j,928)%j+A(j,935)%j+A(j,936)%j+A(j,942)%j+A(j,943)%j+A(j,946)%j+A(j,947)%j)*f(67)+(A(j,929)%j &
       +A(j,930)%j+A(j,948)%j+A(j,949)%j)*f(68)+(A(j,915)%j+A(j,916)%j+A(j,919)%j+A(j,920)%j+A(j,925)%j+A(j,926)%j+A(j,933)%j &
       +A(j,934)%j+A(j,940)%j+A(j,941)%j+A(j,944)%j+A(j,945)%j)*f(69)+(A(j,448)%j+A(j,452)%j+A(j,458)%j+A(j,462)%j+A(j,469)%j &
       +A(j,473)%j)*f(70)+(A(j,446)%j+A(j,450)%j+A(j,456)%j+A(j,460)%j+A(j,467)%j+A(j,471)%j)*f(71)+(A(j,350)%j+A(j,380)%j)*f(72) &
       +(A(j,342)%j+A(j,346)%j+A(j,372)%j+A(j,376)%j+A(j,392)%j+A(j,396)%j)*f(73)+(-A(j,340)%j-A(j,374)%j-A(j,394)%j)*f(74) &
       +(A(j,344)%j+A(j,370)%j+A(j,390)%j)*f(75)+(A(j,348)%j+A(j,378)%j)*f(76)+(A(j,546)%j+A(j,548)%j+A(j,550)%j+A(j,552)%j &
       +A(j,554)%j+A(j,556)%j)*f(77)+(-A(j,545)%j-A(j,547)%j-A(j,549)%j-A(j,551)%j-A(j,553)%j-A(j,555)%j)*f(78)+(A(j,851)%j &
       +A(j,852)%j+A(j,870)%j+A(j,871)%j)*f(79)+(A(j,837)%j+A(j,838)%j+A(j,841)%j+A(j,842)%j+A(j,847)%j+A(j,848)%j+A(j,855)%j &
       +A(j,856)%j+A(j,862)%j+A(j,863)%j+A(j,866)%j+A(j,867)%j)*f(80)+(A(j,849)%j+A(j,850)%j+A(j,868)%j+A(j,869)%j)*f(81) &
       +(A(j,835)%j+A(j,836)%j+A(j,839)%j+A(j,840)%j+A(j,845)%j+A(j,846)%j+A(j,853)%j+A(j,854)%j+A(j,860)%j+A(j,861)%j+A(j,864)%j &
       +A(j,865)%j)*f(82)+(A(j,447)%j+A(j,451)%j+A(j,457)%j+A(j,461)%j+A(j,468)%j+A(j,472)%j)*f(83)+(A(j,445)%j+A(j,449)%j &
       +A(j,455)%j+A(j,459)%j+A(j,466)%j+A(j,470)%j)*f(84)+(A(j,271)%j+A(j,301)%j)*f(85)+(A(j,263)%j+A(j,267)%j+A(j,293)%j &
       +A(j,297)%j+A(j,313)%j+A(j,317)%j)*f(86)+(-A(j,261)%j-A(j,295)%j-A(j,315)%j)*f(87)+(A(j,265)%j+A(j,291)%j+A(j,311)%j)*f(88) &
       +(A(j,269)%j+A(j,299)%j)*f(89)+(A(j,709)%j+A(j,710)%j+A(j,713)%j+A(j,714)%j+A(j,757)%j+A(j,758)%j+A(j,761)%j+A(j,762)%j &
       +A(j,789)%j+A(j,790)%j+A(j,793)%j+A(j,794)%j)*f(90)+(A(j,727)%j+A(j,728)%j+A(j,729)%j+A(j,730)%j+A(j,775)%j+A(j,776)%j &
       +A(j,777)%j+A(j,778)%j)*f(91)+(A(j,707)%j+A(j,708)%j+A(j,711)%j+A(j,712)%j+A(j,755)%j+A(j,756)%j+A(j,759)%j+A(j,760)%j &
       +A(j,787)%j+A(j,788)%j+A(j,791)%j+A(j,792)%j)*f(92)+(-A(j,723)%j-A(j,724)%j-A(j,725)%j-A(j,726)%j-A(j,771)%j-A(j,772)%j &
       -A(j,773)%j-A(j,774)%j)*f(93)+(A(j,719)%j+A(j,720)%j+A(j,721)%j+A(j,722)%j+A(j,767)%j+A(j,768)%j+A(j,769)%j &
       +A(j,770)%j)*f(94)+(-A(j,715)%j-A(j,716)%j-A(j,717)%j-A(j,718)%j-A(j,763)%j-A(j,764)%j-A(j,765)%j-A(j,766)%j)*f(95) &
       +(A(j,349)%j+A(j,379)%j)*f(96)+(A(j,341)%j+A(j,345)%j+A(j,371)%j+A(j,375)%j+A(j,391)%j+A(j,395)%j)*f(97)+(-A(j,339)%j &
       -A(j,373)%j-A(j,393)%j)*f(98)+(A(j,343)%j+A(j,369)%j+A(j,389)%j)*f(99)+(A(j,347)%j+A(j,377)%j)*f(100)+(A(j,272)%j &
       +A(j,302)%j)*f(101)+(A(j,264)%j+A(j,268)%j+A(j,294)%j+A(j,298)%j+A(j,314)%j+A(j,318)%j)*f(102)+(-A(j,262)%j-A(j,296)%j &
       -A(j,316)%j)*f(103)+(A(j,266)%j+A(j,292)%j+A(j,312)%j)*f(104)+(A(j,270)%j+A(j,300)%j)*f(105)+(A(j,558)%j+A(j,560)%j &
       +A(j,562)%j+A(j,564)%j+A(j,566)%j+A(j,568)%j)*f(106)+(-A(j,557)%j-A(j,559)%j-A(j,561)%j-A(j,563)%j-A(j,565)%j &
       -A(j,567)%j)*f(107)+(A(j,891)%j+A(j,892)%j+A(j,910)%j+A(j,911)%j)*f(108)+(A(j,877)%j+A(j,878)%j+A(j,881)%j+A(j,882)%j &
       +A(j,887)%j+A(j,888)%j+A(j,895)%j+A(j,896)%j+A(j,902)%j+A(j,903)%j+A(j,906)%j+A(j,907)%j)*f(109)+(A(j,889)%j+A(j,890)%j &
       +A(j,908)%j+A(j,909)%j)*f(110)+(A(j,875)%j+A(j,876)%j+A(j,879)%j+A(j,880)%j+A(j,885)%j+A(j,886)%j+A(j,893)%j+A(j,894)%j &
       +A(j,900)%j+A(j,901)%j+A(j,904)%j+A(j,905)%j)*f(111)+(A(j,222)%j+A(j,236)%j+A(j,248)%j)*f(112)+(A(j,232)%j &
       +A(j,244)%j)*f(113)+(A(j,228)%j+A(j,240)%j)*f(114)+(A(j,408)%j+A(j,412)%j+A(j,418)%j+A(j,422)%j+A(j,429)%j &
       +A(j,433)%j)*f(115)+(A(j,406)%j+A(j,410)%j+A(j,416)%j+A(j,420)%j+A(j,427)%j+A(j,431)%j)*f(116)+(A(j,338)%j &
       +A(j,368)%j)*f(117)+(A(j,330)%j+A(j,334)%j+A(j,360)%j+A(j,364)%j+A(j,384)%j+A(j,388)%j)*f(118)+(-A(j,328)%j-A(j,362)%j &
       -A(j,386)%j)*f(119)+(A(j,332)%j+A(j,358)%j+A(j,382)%j)*f(120)+(A(j,336)%j+A(j,366)%j)*f(121)+(A(j,534)%j+A(j,536)%j &
       +A(j,538)%j+A(j,540)%j+A(j,542)%j+A(j,544)%j)*f(122)+(-A(j,533)%j-A(j,535)%j-A(j,537)%j-A(j,539)%j-A(j,541)%j &
       -A(j,543)%j)*f(123)+(A(j,811)%j+A(j,812)%j+A(j,830)%j+A(j,831)%j)*f(124)+(A(j,797)%j+A(j,798)%j+A(j,801)%j+A(j,802)%j &
       +A(j,807)%j+A(j,808)%j+A(j,815)%j+A(j,816)%j+A(j,822)%j+A(j,823)%j+A(j,826)%j+A(j,827)%j)*f(125)+(A(j,809)%j+A(j,810)%j &
       +A(j,828)%j+A(j,829)%j)*f(126)+(A(j,795)%j+A(j,796)%j+A(j,799)%j+A(j,800)%j+A(j,805)%j+A(j,806)%j+A(j,813)%j+A(j,814)%j &
       +A(j,820)%j+A(j,821)%j+A(j,824)%j+A(j,825)%j)*f(127)+(A(j,224)%j+A(j,234)%j+A(j,246)%j)*f(128)+(A(j,230)%j &
       +A(j,242)%j)*f(129)+(A(j,226)%j+A(j,238)%j)*f(130)+(A(j,407)%j+A(j,411)%j+A(j,417)%j+A(j,421)%j+A(j,428)%j &
       +A(j,432)%j)*f(131)+(A(j,405)%j+A(j,409)%j+A(j,415)%j+A(j,419)%j+A(j,426)%j+A(j,430)%j)*f(132)+(A(j,259)%j &
       +A(j,289)%j)*f(133)+(A(j,251)%j+A(j,255)%j+A(j,281)%j+A(j,285)%j+A(j,305)%j+A(j,309)%j)*f(134)+(-A(j,249)%j-A(j,283)%j &
       -A(j,307)%j)*f(135)+(A(j,253)%j+A(j,279)%j+A(j,303)%j)*f(136)+(A(j,257)%j+A(j,287)%j)*f(137)+(A(j,491)%j+A(j,492)%j &
       +A(j,499)%j+A(j,500)%j+A(j,507)%j+A(j,508)%j+A(j,515)%j+A(j,516)%j+A(j,523)%j+A(j,524)%j+A(j,531)%j+A(j,532)%j)*f(138)+( &
       -A(j,487)%j-A(j,488)%j-A(j,489)%j-A(j,490)%j-A(j,495)%j-A(j,496)%j-A(j,497)%j-A(j,498)%j-A(j,503)%j-A(j,504)%j-A(j,505)%j &
       -A(j,506)%j-A(j,511)%j-A(j,512)%j-A(j,513)%j-A(j,514)%j-A(j,519)%j-A(j,520)%j-A(j,521)%j-A(j,522)%j-A(j,527)%j-A(j,528)%j &
       -A(j,529)%j-A(j,530)%j)*f(139)+(A(j,485)%j+A(j,486)%j+A(j,493)%j+A(j,494)%j+A(j,501)%j+A(j,502)%j+A(j,509)%j+A(j,510)%j &
       +A(j,517)%j+A(j,518)%j+A(j,525)%j+A(j,526)%j)*f(140)+(A(j,685)%j+A(j,686)%j+A(j,689)%j+A(j,690)%j+A(j,733)%j+A(j,734)%j &
       +A(j,737)%j+A(j,738)%j+A(j,781)%j+A(j,782)%j+A(j,785)%j+A(j,786)%j)*f(141)+(A(j,703)%j+A(j,704)%j+A(j,705)%j+A(j,706)%j &
       +A(j,751)%j+A(j,752)%j+A(j,753)%j+A(j,754)%j)*f(142)+(A(j,683)%j+A(j,684)%j+A(j,687)%j+A(j,688)%j+A(j,731)%j+A(j,732)%j &
       +A(j,735)%j+A(j,736)%j+A(j,779)%j+A(j,780)%j+A(j,783)%j+A(j,784)%j)*f(143)+(-A(j,699)%j-A(j,700)%j-A(j,701)%j-A(j,702)%j &
       -A(j,747)%j-A(j,748)%j-A(j,749)%j-A(j,750)%j)*f(144)+(A(j,695)%j+A(j,696)%j+A(j,697)%j+A(j,698)%j+A(j,743)%j+A(j,744)%j &
       +A(j,745)%j+A(j,746)%j)*f(145)+(-A(j,691)%j-A(j,692)%j-A(j,693)%j-A(j,694)%j-A(j,739)%j-A(j,740)%j-A(j,741)%j &
       -A(j,742)%j)*f(146)+(A(j,221)%j+A(j,223)%j+A(j,233)%j+A(j,235)%j+A(j,245)%j+A(j,247)%j)*f(147)+(A(j,229)%j+A(j,231)%j &
       +A(j,241)%j+A(j,243)%j)*f(148)+(A(j,225)%j+A(j,227)%j+A(j,237)%j+A(j,239)%j)*f(149)+(A(j,337)%j+A(j,367)%j)*f(150) &
       +(A(j,329)%j+A(j,333)%j+A(j,359)%j+A(j,363)%j+A(j,383)%j+A(j,387)%j)*f(151)+(-A(j,327)%j-A(j,361)%j-A(j,385)%j)*f(152) &
       +(A(j,331)%j+A(j,357)%j+A(j,381)%j)*f(153)+(A(j,335)%j+A(j,365)%j)*f(154)+(A(j,260)%j+A(j,290)%j)*f(155)+(A(j,252)%j &
       +A(j,256)%j+A(j,282)%j+A(j,286)%j+A(j,306)%j+A(j,310)%j)*f(156)+(-A(j,250)%j-A(j,284)%j-A(j,308)%j)*f(157)+(A(j,254)%j &
       +A(j,280)%j+A(j,304)%j)*f(158)+(A(j,258)%j+A(j,288)%j)*f(159)+(-A(j,2648)%j-A(j,2650)%j)*f(160)+(-A(j,2652)%j-A(j,2654)%j &
       -A(j,2656)%j-A(j,2658)%j-A(j,2660)%j-A(j,2662)%j)*f(161)+(-A(j,2647)%j-A(j,2649)%j)*f(162)+(-A(j,2651)%j-A(j,2653)%j &
       -A(j,2655)%j-A(j,2657)%j-A(j,2659)%j-A(j,2661)%j)*f(163)+(-A(j,2632)%j-A(j,2634)%j)*f(164)+(-A(j,2636)%j-A(j,2638)%j &
       -A(j,2640)%j-A(j,2642)%j-A(j,2644)%j-A(j,2646)%j)*f(165)+(-A(j,2631)%j-A(j,2633)%j)*f(166)+(-A(j,2635)%j-A(j,2637)%j &
       -A(j,2639)%j-A(j,2641)%j-A(j,2643)%j-A(j,2645)%j)*f(167)+(-A(j,2663)%j+A(j,2664)%j+A(j,2665)%j+A(j,2666)%j-A(j,2667)%j &
       -A(j,2668)%j)*f(168)+(A(j,2625)%j-A(j,2626)%j+A(j,2629)%j-A(j,2630)%j)*f(169)+(-A(j,2623)%j+A(j,2624)%j-A(j,2627)%j &
       +A(j,2628)%j)*f(170)+(A(j,2673)%j-A(j,2674)%j-A(j,2675)%j-A(j,2676)%j+A(j,2677)%j+A(j,2678)%j)*f(171)+(A(j,2671)%j &
       -A(j,2672)%j+A(j,2681)%j-A(j,2682)%j)*f(172)+(-A(j,2669)%j+A(j,2670)%j-A(j,2679)%j+A(j,2680)%j)*f(173)+(-A(j,2208)%j &
       -A(j,2211)%j-A(j,2214)%j-A(j,2217)%j-A(j,2220)%j-A(j,2223)%j)*f(174)+(-A(j,2174)%j-A(j,2195)%j)*f(175)+(-A(j,2160)%j &
       -A(j,2162)%j-A(j,2176)%j-A(j,2178)%j-A(j,2191)%j-A(j,2193)%j)*f(176)+(-A(j,2126)%j-A(j,2147)%j)*f(177)+(-A(j,2112)%j &
       -A(j,2114)%j-A(j,2128)%j-A(j,2130)%j-A(j,2143)%j-A(j,2145)%j)*f(178)+(-A(j,2207)%j-A(j,2210)%j-A(j,2213)%j-A(j,2216)%j &
       -A(j,2219)%j-A(j,2222)%j)*f(179)+(-A(j,2173)%j-A(j,2194)%j)*f(180)+(-A(j,2159)%j-A(j,2161)%j-A(j,2175)%j-A(j,2177)%j &
       -A(j,2190)%j-A(j,2192)%j)*f(181)+(-A(j,2125)%j-A(j,2146)%j)*f(182)+(-A(j,2111)%j-A(j,2113)%j-A(j,2127)%j-A(j,2129)%j &
       -A(j,2142)%j-A(j,2144)%j)*f(183)+(-A(j,2209)%j-A(j,2212)%j-A(j,2215)%j-A(j,2218)%j-A(j,2221)%j-A(j,2224)%j)*f(184) &
       +(A(j,2465)%j+A(j,2468)%j+A(j,2471)%j+A(j,2474)%j+A(j,2477)%j+A(j,2480)%j)*f(185)+(-A(j,2463)%j-A(j,2466)%j-A(j,2469)%j &
       -A(j,2472)%j-A(j,2475)%j-A(j,2478)%j)*f(186)+(-A(j,2429)%j-A(j,2450)%j)*f(187)+(-A(j,2415)%j-A(j,2417)%j-A(j,2431)%j &
       -A(j,2433)%j-A(j,2446)%j-A(j,2448)%j)*f(188)+(-A(j,2381)%j-A(j,2402)%j)*f(189)+(-A(j,2367)%j-A(j,2369)%j-A(j,2383)%j &
       -A(j,2385)%j-A(j,2398)%j-A(j,2400)%j)*f(190)+(A(j,2464)%j+A(j,2467)%j+A(j,2470)%j+A(j,2473)%j+A(j,2476)%j &
       +A(j,2479)%j)*f(191)+(A(j,2430)%j+A(j,2451)%j)*f(192)+(A(j,2416)%j+A(j,2418)%j+A(j,2432)%j+A(j,2434)%j+A(j,2447)%j &
       +A(j,2449)%j)*f(193)+(A(j,2382)%j+A(j,2403)%j)*f(194)+(A(j,2368)%j+A(j,2370)%j+A(j,2384)%j+A(j,2386)%j+A(j,2399)%j &
       +A(j,2401)%j)*f(195)+(A(j,2227)%j+A(j,2230)%j+A(j,2233)%j+A(j,2236)%j+A(j,2239)%j+A(j,2242)%j)*f(196)+(A(j,2334)%j &
       +A(j,2355)%j)*f(197)+(A(j,2320)%j+A(j,2322)%j+A(j,2336)%j+A(j,2338)%j+A(j,2351)%j+A(j,2353)%j)*f(198)+(A(j,2286)%j &
       +A(j,2307)%j)*f(199)+(A(j,2272)%j+A(j,2274)%j+A(j,2288)%j+A(j,2290)%j+A(j,2303)%j+A(j,2305)%j)*f(200)+(A(j,2225)%j &
       +A(j,2228)%j+A(j,2231)%j+A(j,2234)%j+A(j,2237)%j+A(j,2240)%j)*f(201)+(A(j,2333)%j+A(j,2354)%j)*f(202)+(A(j,2319)%j &
       +A(j,2321)%j+A(j,2335)%j+A(j,2337)%j+A(j,2350)%j+A(j,2352)%j)*f(203)+(A(j,2285)%j+A(j,2306)%j)*f(204)+(A(j,2271)%j &
       +A(j,2273)%j+A(j,2287)%j+A(j,2289)%j+A(j,2302)%j+A(j,2304)%j)*f(205)+(A(j,2226)%j+A(j,2229)%j+A(j,2232)%j+A(j,2235)%j &
       +A(j,2238)%j+A(j,2241)%j)*f(206)+(-A(j,2482)%j-A(j,2485)%j-A(j,2488)%j-A(j,2491)%j-A(j,2494)%j-A(j,2497)%j)*f(207) &
       +(A(j,2481)%j+A(j,2484)%j+A(j,2487)%j+A(j,2490)%j+A(j,2493)%j+A(j,2496)%j)*f(208)+(A(j,2589)%j+A(j,2610)%j)*f(209) &
       +(A(j,2575)%j+A(j,2577)%j+A(j,2591)%j+A(j,2593)%j+A(j,2606)%j+A(j,2608)%j)*f(210)+(A(j,2541)%j+A(j,2562)%j)*f(211) &
       +(A(j,2527)%j+A(j,2529)%j+A(j,2543)%j+A(j,2545)%j+A(j,2558)%j+A(j,2560)%j)*f(212)+(-A(j,2483)%j-A(j,2486)%j-A(j,2489)%j &
       -A(j,2492)%j-A(j,2495)%j-A(j,2498)%j)*f(213)+(-A(j,2590)%j-A(j,2611)%j)*f(214)+(-A(j,2576)%j-A(j,2578)%j-A(j,2592)%j &
       -A(j,2594)%j-A(j,2607)%j-A(j,2609)%j)*f(215)+(-A(j,2542)%j-A(j,2563)%j)*f(216)+(-A(j,2528)%j-A(j,2530)%j-A(j,2544)%j &
       -A(j,2546)%j-A(j,2559)%j-A(j,2561)%j)*f(217)+(A(j,2184)%j+A(j,2206)%j)*f(218)+(A(j,2163)%j+A(j,2168)%j+A(j,2179)%j &
       +A(j,2185)%j+A(j,2196)%j+A(j,2201)%j)*f(219)+(-A(j,2344)%j-A(j,2366)%j)*f(220)+(-A(j,2323)%j-A(j,2328)%j-A(j,2339)%j &
       -A(j,2345)%j-A(j,2356)%j-A(j,2361)%j)*f(221)+(-A(j,2243)%j+A(j,2244)%j+A(j,2255)%j-A(j,2256)%j+A(j,2267)%j &
       -A(j,2268)%j)*f(222)+(-A(j,2247)%j+A(j,2248)%j-A(j,2259)%j+A(j,2260)%j)*f(223)+(A(j,2245)%j-A(j,2246)%j+A(j,2257)%j &
       -A(j,2258)%j)*f(224)+(-A(j,2166)%j+A(j,2167)%j-A(j,2171)%j+A(j,2172)%j-A(j,2182)%j+A(j,2183)%j-A(j,2188)%j+A(j,2189)%j &
       -A(j,2199)%j+A(j,2200)%j-A(j,2204)%j+A(j,2205)%j)*f(225)+(A(j,2164)%j-A(j,2165)%j+A(j,2169)%j-A(j,2170)%j+A(j,2180)%j &
       -A(j,2181)%j+A(j,2186)%j-A(j,2187)%j+A(j,2197)%j-A(j,2198)%j+A(j,2202)%j-A(j,2203)%j)*f(226)+(A(j,2422)%j-A(j,2423)%j &
       +A(j,2427)%j-A(j,2428)%j+A(j,2438)%j-A(j,2439)%j+A(j,2444)%j-A(j,2445)%j+A(j,2455)%j-A(j,2456)%j+A(j,2460)%j &
       -A(j,2461)%j)*f(227)+(-A(j,2420)%j+A(j,2421)%j-A(j,2425)%j+A(j,2426)%j-A(j,2436)%j+A(j,2437)%j-A(j,2442)%j+A(j,2443)%j &
       -A(j,2453)%j+A(j,2454)%j-A(j,2458)%j+A(j,2459)%j)*f(228)+(-A(j,2326)%j+A(j,2327)%j-A(j,2331)%j+A(j,2332)%j-A(j,2342)%j &
       +A(j,2343)%j-A(j,2348)%j+A(j,2349)%j-A(j,2359)%j+A(j,2360)%j-A(j,2364)%j+A(j,2365)%j)*f(229)+(A(j,2324)%j-A(j,2325)%j &
       +A(j,2329)%j-A(j,2330)%j+A(j,2340)%j-A(j,2341)%j+A(j,2346)%j-A(j,2347)%j+A(j,2357)%j-A(j,2358)%j+A(j,2362)%j &
       -A(j,2363)%j)*f(230)+(A(j,2582)%j-A(j,2583)%j+A(j,2587)%j-A(j,2588)%j+A(j,2598)%j-A(j,2599)%j+A(j,2604)%j-A(j,2605)%j &
       +A(j,2615)%j-A(j,2616)%j+A(j,2620)%j-A(j,2621)%j)*f(231)+(-A(j,2580)%j+A(j,2581)%j-A(j,2585)%j+A(j,2586)%j-A(j,2596)%j &
       +A(j,2597)%j-A(j,2602)%j+A(j,2603)%j-A(j,2613)%j+A(j,2614)%j-A(j,2618)%j+A(j,2619)%j)*f(232)+(A(j,2440)%j &
       +A(j,2462)%j)*f(233)+(A(j,2419)%j+A(j,2424)%j+A(j,2435)%j+A(j,2441)%j+A(j,2452)%j+A(j,2457)%j)*f(234)+(-A(j,2600)%j &
       -A(j,2622)%j)*f(235)+(-A(j,2579)%j-A(j,2584)%j-A(j,2595)%j-A(j,2601)%j-A(j,2612)%j-A(j,2617)%j)*f(236)+(-A(j,2499)%j &
       +A(j,2500)%j+A(j,2511)%j-A(j,2512)%j+A(j,2523)%j-A(j,2524)%j)*f(237)+(-A(j,2503)%j+A(j,2504)%j-A(j,2515)%j &
       +A(j,2516)%j)*f(238)+(A(j,2501)%j-A(j,2502)%j+A(j,2513)%j-A(j,2514)%j)*f(239)+(A(j,2136)%j+A(j,2158)%j)*f(240)+(A(j,2115)%j &
       +A(j,2120)%j+A(j,2131)%j+A(j,2137)%j+A(j,2148)%j+A(j,2153)%j)*f(241)+(-A(j,2296)%j-A(j,2318)%j)*f(242)+(-A(j,2275)%j &
       -A(j,2280)%j-A(j,2291)%j-A(j,2297)%j-A(j,2308)%j-A(j,2313)%j)*f(243)+(-A(j,2249)%j+A(j,2250)%j+A(j,2261)%j-A(j,2262)%j &
       +A(j,2269)%j-A(j,2270)%j)*f(244)+(-A(j,2253)%j+A(j,2254)%j-A(j,2265)%j+A(j,2266)%j)*f(245)+(A(j,2251)%j-A(j,2252)%j &
       +A(j,2263)%j-A(j,2264)%j)*f(246)+(-A(j,2118)%j+A(j,2119)%j-A(j,2123)%j+A(j,2124)%j-A(j,2134)%j+A(j,2135)%j-A(j,2140)%j &
       +A(j,2141)%j-A(j,2151)%j+A(j,2152)%j-A(j,2156)%j+A(j,2157)%j)*f(247)+(A(j,2116)%j-A(j,2117)%j+A(j,2121)%j-A(j,2122)%j &
       +A(j,2132)%j-A(j,2133)%j+A(j,2138)%j-A(j,2139)%j+A(j,2149)%j-A(j,2150)%j+A(j,2154)%j-A(j,2155)%j)*f(248)+(A(j,2374)%j &
       -A(j,2375)%j+A(j,2379)%j-A(j,2380)%j+A(j,2390)%j-A(j,2391)%j+A(j,2396)%j-A(j,2397)%j+A(j,2407)%j-A(j,2408)%j+A(j,2412)%j &
       -A(j,2413)%j)*f(249)+(-A(j,2372)%j+A(j,2373)%j-A(j,2377)%j+A(j,2378)%j-A(j,2388)%j+A(j,2389)%j-A(j,2394)%j+A(j,2395)%j &
       -A(j,2405)%j+A(j,2406)%j-A(j,2410)%j+A(j,2411)%j)*f(250)+(-A(j,2278)%j+A(j,2279)%j-A(j,2283)%j+A(j,2284)%j-A(j,2294)%j &
       +A(j,2295)%j-A(j,2300)%j+A(j,2301)%j-A(j,2311)%j+A(j,2312)%j-A(j,2316)%j+A(j,2317)%j)*f(251)+(A(j,2276)%j-A(j,2277)%j &
       +A(j,2281)%j-A(j,2282)%j+A(j,2292)%j-A(j,2293)%j+A(j,2298)%j-A(j,2299)%j+A(j,2309)%j-A(j,2310)%j+A(j,2314)%j &
       -A(j,2315)%j)*f(252)+(A(j,2534)%j-A(j,2535)%j+A(j,2539)%j-A(j,2540)%j+A(j,2550)%j-A(j,2551)%j+A(j,2556)%j-A(j,2557)%j &
       +A(j,2567)%j-A(j,2568)%j+A(j,2572)%j-A(j,2573)%j)*f(253)+(-A(j,2532)%j+A(j,2533)%j-A(j,2537)%j+A(j,2538)%j-A(j,2548)%j &
       +A(j,2549)%j-A(j,2554)%j+A(j,2555)%j-A(j,2565)%j+A(j,2566)%j-A(j,2570)%j+A(j,2571)%j)*f(254)+(A(j,2392)%j &
       +A(j,2414)%j)*f(255)+(A(j,2371)%j+A(j,2376)%j+A(j,2387)%j+A(j,2393)%j+A(j,2404)%j+A(j,2409)%j)*f(256)+(-A(j,2552)%j &
       -A(j,2574)%j)*f(257)+(-A(j,2531)%j-A(j,2536)%j-A(j,2547)%j-A(j,2553)%j-A(j,2564)%j-A(j,2569)%j)*f(258)+(-A(j,2505)%j &
       +A(j,2506)%j+A(j,2517)%j-A(j,2518)%j+A(j,2525)%j-A(j,2526)%j)*f(259)+(-A(j,2509)%j+A(j,2510)%j-A(j,2521)%j &
       +A(j,2522)%j)*f(260)+(A(j,2507)%j-A(j,2508)%j+A(j,2519)%j-A(j,2520)%j)*f(261)+(A(j,1482)%j+A(j,1486)%j+A(j,1490)%j &
       +A(j,1494)%j+A(j,1498)%j+A(j,1502)%j)*f(262)+(A(j,1551)%j+A(j,1555)%j+A(j,1559)%j+A(j,1563)%j+A(j,1567)%j &
       +A(j,1571)%j)*f(263)+(A(j,1122)%j+A(j,1128)%j)*f(264)+(A(j,1118)%j+A(j,1120)%j+A(j,1124)%j+A(j,1126)%j+A(j,1130)%j &
       +A(j,1132)%j)*f(265)+(A(j,1074)%j+A(j,1080)%j)*f(266)+(A(j,1070)%j+A(j,1072)%j+A(j,1076)%j+A(j,1078)%j+A(j,1082)%j &
       +A(j,1084)%j)*f(267)+(A(j,1479)%j+A(j,1483)%j+A(j,1487)%j+A(j,1491)%j+A(j,1495)%j+A(j,1499)%j)*f(268)+(A(j,2087)%j &
       +A(j,2091)%j+A(j,2095)%j+A(j,2099)%j+A(j,2103)%j+A(j,2107)%j)*f(269)+(A(j,1554)%j+A(j,1558)%j+A(j,1562)%j+A(j,1566)%j &
       +A(j,1570)%j+A(j,1574)%j)*f(270)+(A(j,2090)%j+A(j,2094)%j+A(j,2098)%j+A(j,2102)%j+A(j,2106)%j+A(j,2110)%j)*f(271) &
       +(A(j,1730)%j+A(j,1736)%j)*f(272)+(A(j,1726)%j+A(j,1728)%j+A(j,1732)%j+A(j,1734)%j+A(j,1738)%j+A(j,1740)%j)*f(273) &
       +(A(j,1682)%j+A(j,1688)%j)*f(274)+(A(j,1678)%j+A(j,1680)%j+A(j,1684)%j+A(j,1686)%j+A(j,1690)%j+A(j,1692)%j)*f(275) &
       +(A(j,1432)%j+A(j,1453)%j)*f(276)+(A(j,1417)%j+A(j,1419)%j+A(j,1434)%j+A(j,1436)%j+A(j,1449)%j+A(j,1451)%j)*f(277) &
       +(A(j,2040)%j+A(j,2061)%j)*f(278)+(A(j,2025)%j+A(j,2027)%j+A(j,2042)%j+A(j,2044)%j+A(j,2057)%j+A(j,2059)%j)*f(279)+( &
       -A(j,1121)%j-A(j,1127)%j)*f(280)+(-A(j,1117)%j-A(j,1119)%j-A(j,1123)%j-A(j,1125)%j-A(j,1129)%j-A(j,1131)%j)*f(281) &
       +(A(j,1729)%j+A(j,1735)%j)*f(282)+(A(j,1725)%j+A(j,1727)%j+A(j,1731)%j+A(j,1733)%j+A(j,1737)%j+A(j,1739)%j)*f(283) &
       +(A(j,1384)%j+A(j,1405)%j)*f(284)+(A(j,1369)%j+A(j,1371)%j+A(j,1386)%j+A(j,1388)%j+A(j,1401)%j+A(j,1403)%j)*f(285) &
       +(A(j,1992)%j+A(j,2013)%j)*f(286)+(A(j,1977)%j+A(j,1979)%j+A(j,1994)%j+A(j,1996)%j+A(j,2009)%j+A(j,2011)%j)*f(287)+( &
       -A(j,1073)%j-A(j,1079)%j)*f(288)+(-A(j,1069)%j-A(j,1071)%j-A(j,1075)%j-A(j,1077)%j-A(j,1081)%j-A(j,1083)%j)*f(289) &
       +(A(j,1681)%j+A(j,1687)%j)*f(290)+(A(j,1677)%j+A(j,1679)%j+A(j,1683)%j+A(j,1685)%j+A(j,1689)%j+A(j,1691)%j)*f(291) &
       +(A(j,1214)%j+A(j,1218)%j+A(j,1222)%j+A(j,1226)%j+A(j,1230)%j+A(j,1234)%j)*f(292)+(A(j,1503)%j+A(j,1507)%j+A(j,1511)%j &
       +A(j,1515)%j+A(j,1519)%j+A(j,1523)%j)*f(293)+(A(j,1458)%j+A(j,1462)%j+A(j,1466)%j+A(j,1470)%j+A(j,1474)%j &
       +A(j,1478)%j)*f(294)+(A(j,1527)%j+A(j,1531)%j+A(j,1535)%j+A(j,1539)%j+A(j,1543)%j+A(j,1547)%j)*f(295)+(A(j,1100)%j &
       +A(j,1112)%j)*f(296)+(A(j,1090)%j+A(j,1092)%j+A(j,1102)%j+A(j,1104)%j+A(j,1114)%j+A(j,1116)%j)*f(297)+(A(j,1052)%j &
       +A(j,1064)%j)*f(298)+(A(j,1042)%j+A(j,1044)%j+A(j,1054)%j+A(j,1056)%j+A(j,1066)%j+A(j,1068)%j)*f(299)+(A(j,1211)%j &
       +A(j,1215)%j+A(j,1219)%j+A(j,1223)%j+A(j,1227)%j+A(j,1231)%j)*f(300)+(A(j,1819)%j+A(j,1823)%j+A(j,1827)%j+A(j,1831)%j &
       +A(j,1835)%j+A(j,1839)%j)*f(301)+(A(j,1455)%j+A(j,1459)%j+A(j,1463)%j+A(j,1467)%j+A(j,1471)%j+A(j,1475)%j)*f(302) &
       +(A(j,2063)%j+A(j,2067)%j+A(j,2071)%j+A(j,2075)%j+A(j,2079)%j+A(j,2083)%j)*f(303)+(A(j,1506)%j+A(j,1510)%j+A(j,1514)%j &
       +A(j,1518)%j+A(j,1522)%j+A(j,1526)%j)*f(304)+(A(j,1822)%j+A(j,1826)%j+A(j,1830)%j+A(j,1834)%j+A(j,1838)%j &
       +A(j,1842)%j)*f(305)+(A(j,1530)%j+A(j,1534)%j+A(j,1538)%j+A(j,1542)%j+A(j,1546)%j+A(j,1550)%j)*f(306)+(A(j,2066)%j &
       +A(j,2070)%j+A(j,2074)%j+A(j,2078)%j+A(j,2082)%j+A(j,2086)%j)*f(307)+(A(j,1708)%j+A(j,1720)%j)*f(308)+(A(j,1698)%j &
       +A(j,1700)%j+A(j,1710)%j+A(j,1712)%j+A(j,1722)%j+A(j,1724)%j)*f(309)+(A(j,1660)%j+A(j,1672)%j)*f(310)+(A(j,1650)%j &
       +A(j,1652)%j+A(j,1662)%j+A(j,1664)%j+A(j,1674)%j+A(j,1676)%j)*f(311)+(-A(j,1099)%j-A(j,1111)%j)*f(312)+(-A(j,1089)%j &
       -A(j,1091)%j-A(j,1101)%j-A(j,1103)%j-A(j,1113)%j-A(j,1115)%j)*f(313)+(A(j,1707)%j+A(j,1719)%j)*f(314)+(A(j,1697)%j &
       +A(j,1699)%j+A(j,1709)%j+A(j,1711)%j+A(j,1721)%j+A(j,1723)%j)*f(315)+(A(j,1336)%j+A(j,1357)%j)*f(316)+(A(j,1321)%j &
       +A(j,1323)%j+A(j,1338)%j+A(j,1340)%j+A(j,1353)%j+A(j,1355)%j)*f(317)+(A(j,1944)%j+A(j,1965)%j)*f(318)+(A(j,1929)%j &
       +A(j,1931)%j+A(j,1946)%j+A(j,1948)%j+A(j,1961)%j+A(j,1963)%j)*f(319)+(-A(j,1051)%j-A(j,1063)%j)*f(320)+(-A(j,1041)%j &
       -A(j,1043)%j-A(j,1053)%j-A(j,1055)%j-A(j,1065)%j-A(j,1067)%j)*f(321)+(A(j,1659)%j+A(j,1671)%j)*f(322)+(A(j,1649)%j &
       +A(j,1651)%j+A(j,1661)%j+A(j,1663)%j+A(j,1673)%j+A(j,1675)%j)*f(323)+(A(j,1288)%j+A(j,1309)%j)*f(324)+(A(j,1273)%j &
       +A(j,1275)%j+A(j,1290)%j+A(j,1292)%j+A(j,1305)%j+A(j,1307)%j)*f(325)+(A(j,1896)%j+A(j,1917)%j)*f(326)+(A(j,1881)%j &
       +A(j,1883)%j+A(j,1898)%j+A(j,1900)%j+A(j,1913)%j+A(j,1915)%j)*f(327)+(A(j,1201)%j+A(j,1209)%j)*f(328)+(A(j,1195)%j &
       +A(j,1197)%j+A(j,1199)%j+A(j,1203)%j+A(j,1205)%j+A(j,1207)%j)*f(329)+(A(j,1809)%j+A(j,1817)%j)*f(330)+(A(j,1803)%j &
       +A(j,1805)%j+A(j,1807)%j+A(j,1811)%j+A(j,1813)%j+A(j,1815)%j)*f(331)+(-A(j,1095)%j-A(j,1107)%j)*f(332)+(-A(j,1085)%j &
       -A(j,1087)%j-A(j,1093)%j-A(j,1097)%j-A(j,1105)%j-A(j,1109)%j)*f(333)+(A(j,1703)%j+A(j,1715)%j)*f(334)+(A(j,1693)%j &
       +A(j,1695)%j+A(j,1701)%j+A(j,1705)%j+A(j,1713)%j+A(j,1717)%j)*f(335)+(A(j,1426)%j+A(j,1448)%j)*f(336)+(A(j,1407)%j &
       +A(j,1412)%j+A(j,1421)%j+A(j,1427)%j+A(j,1438)%j+A(j,1443)%j)*f(337)+(A(j,2034)%j+A(j,2056)%j)*f(338)+(A(j,2015)%j &
       +A(j,2020)%j+A(j,2029)%j+A(j,2035)%j+A(j,2046)%j+A(j,2051)%j)*f(339)+(-A(j,1096)%j-A(j,1108)%j)*f(340)+(-A(j,1086)%j &
       -A(j,1088)%j-A(j,1094)%j-A(j,1098)%j-A(j,1106)%j-A(j,1110)%j)*f(341)+(A(j,1704)%j+A(j,1716)%j)*f(342)+(A(j,1694)%j &
       +A(j,1696)%j+A(j,1702)%j+A(j,1706)%j+A(j,1714)%j+A(j,1718)%j)*f(343)+(A(j,1169)%j+A(j,1177)%j)*f(344)+(A(j,1163)%j &
       +A(j,1165)%j+A(j,1167)%j+A(j,1171)%j+A(j,1173)%j+A(j,1175)%j)*f(345)+(A(j,1777)%j+A(j,1785)%j)*f(346)+(A(j,1771)%j &
       +A(j,1773)%j+A(j,1775)%j+A(j,1779)%j+A(j,1781)%j+A(j,1783)%j)*f(347)+(A(j,1330)%j+A(j,1352)%j)*f(348)+(A(j,1311)%j &
       +A(j,1316)%j+A(j,1325)%j+A(j,1331)%j+A(j,1342)%j+A(j,1347)%j)*f(349)+(A(j,1938)%j+A(j,1960)%j)*f(350)+(A(j,1919)%j &
       +A(j,1924)%j+A(j,1933)%j+A(j,1939)%j+A(j,1950)%j+A(j,1955)%j)*f(351)+(-A(j,1015)%j-A(j,1016)%j-A(j,1027)%j-A(j,1028)%j &
       -A(j,1035)%j-A(j,1036)%j)*f(352)+(-A(j,1019)%j-A(j,1020)%j-A(j,1031)%j-A(j,1032)%j)*f(353)+(A(j,1017)%j+A(j,1018)%j &
       +A(j,1029)%j+A(j,1030)%j)*f(354)+(A(j,1623)%j+A(j,1624)%j+A(j,1635)%j+A(j,1636)%j+A(j,1643)%j+A(j,1644)%j)*f(355) &
       +(A(j,1627)%j+A(j,1628)%j+A(j,1639)%j+A(j,1640)%j)*f(356)+(-A(j,1625)%j-A(j,1626)%j-A(j,1637)%j-A(j,1638)%j)*f(357)+( &
       -A(j,987)%j-A(j,988)%j-A(j,999)%j-A(j,1000)%j-A(j,1007)%j-A(j,1008)%j)*f(358)+(-A(j,991)%j-A(j,992)%j-A(j,1003)%j &
       -A(j,1004)%j)*f(359)+(A(j,989)%j+A(j,990)%j+A(j,1001)%j+A(j,1002)%j)*f(360)+(A(j,1595)%j+A(j,1596)%j+A(j,1607)%j &
       +A(j,1608)%j+A(j,1615)%j+A(j,1616)%j)*f(361)+(A(j,1599)%j+A(j,1600)%j+A(j,1611)%j+A(j,1612)%j)*f(362)+(-A(j,1597)%j &
       -A(j,1598)%j-A(j,1609)%j-A(j,1610)%j)*f(363)+(A(j,1241)%j+A(j,1242)%j+A(j,1253)%j+A(j,1254)%j+A(j,1261)%j &
       +A(j,1262)%j)*f(364)+(A(j,1245)%j+A(j,1246)%j+A(j,1257)%j+A(j,1258)%j)*f(365)+(-A(j,1243)%j-A(j,1244)%j-A(j,1255)%j &
       -A(j,1256)%j)*f(366)+(A(j,1849)%j+A(j,1850)%j+A(j,1861)%j+A(j,1862)%j+A(j,1869)%j+A(j,1870)%j)*f(367)+(A(j,1853)%j &
       +A(j,1854)%j+A(j,1865)%j+A(j,1866)%j)*f(368)+(-A(j,1851)%j-A(j,1852)%j-A(j,1863)%j-A(j,1864)%j)*f(369)+(A(j,1185)%j &
       +A(j,1193)%j)*f(370)+(A(j,1179)%j+A(j,1181)%j+A(j,1183)%j+A(j,1187)%j+A(j,1189)%j+A(j,1191)%j)*f(371)+(A(j,1793)%j &
       +A(j,1801)%j)*f(372)+(A(j,1787)%j+A(j,1789)%j+A(j,1791)%j+A(j,1795)%j+A(j,1797)%j+A(j,1799)%j)*f(373)+(-A(j,1047)%j &
       -A(j,1059)%j)*f(374)+(-A(j,1037)%j-A(j,1039)%j-A(j,1045)%j-A(j,1049)%j-A(j,1057)%j-A(j,1061)%j)*f(375)+(A(j,1655)%j &
       +A(j,1667)%j)*f(376)+(A(j,1645)%j+A(j,1647)%j+A(j,1653)%j+A(j,1657)%j+A(j,1665)%j+A(j,1669)%j)*f(377)+(A(j,1378)%j &
       +A(j,1400)%j)*f(378)+(A(j,1359)%j+A(j,1364)%j+A(j,1373)%j+A(j,1379)%j+A(j,1390)%j+A(j,1395)%j)*f(379)+(A(j,1986)%j &
       +A(j,2008)%j)*f(380)+(A(j,1967)%j+A(j,1972)%j+A(j,1981)%j+A(j,1987)%j+A(j,1998)%j+A(j,2003)%j)*f(381)+(-A(j,1048)%j &
       -A(j,1060)%j)*f(382)+(-A(j,1038)%j-A(j,1040)%j-A(j,1046)%j-A(j,1050)%j-A(j,1058)%j-A(j,1062)%j)*f(383)+(A(j,1656)%j &
       +A(j,1668)%j)*f(384)+(A(j,1646)%j+A(j,1648)%j+A(j,1654)%j+A(j,1658)%j+A(j,1666)%j+A(j,1670)%j)*f(385)+(A(j,1153)%j &
       +A(j,1161)%j)*f(386)+(A(j,1147)%j+A(j,1149)%j+A(j,1151)%j+A(j,1155)%j+A(j,1157)%j+A(j,1159)%j)*f(387)+(A(j,1761)%j &
       +A(j,1769)%j)*f(388)+(A(j,1755)%j+A(j,1757)%j+A(j,1759)%j+A(j,1763)%j+A(j,1765)%j+A(j,1767)%j)*f(389)+(A(j,1282)%j &
       +A(j,1304)%j)*f(390)+(A(j,1263)%j+A(j,1268)%j+A(j,1277)%j+A(j,1283)%j+A(j,1294)%j+A(j,1299)%j)*f(391)+(A(j,1890)%j &
       +A(j,1912)%j)*f(392)+(A(j,1871)%j+A(j,1876)%j+A(j,1885)%j+A(j,1891)%j+A(j,1902)%j+A(j,1907)%j)*f(393)+(A(j,967)%j &
       +A(j,968)%j+A(j,973)%j+A(j,974)%j+A(j,979)%j+A(j,980)%j)*f(394)+(A(j,971)%j+A(j,972)%j+A(j,977)%j+A(j,978)%j)*f(395)+( &
       -A(j,969)%j-A(j,970)%j-A(j,975)%j-A(j,976)%j)*f(396)+(A(j,1575)%j+A(j,1576)%j+A(j,1581)%j+A(j,1582)%j+A(j,1587)%j &
       +A(j,1588)%j)*f(397)+(A(j,1579)%j+A(j,1580)%j+A(j,1585)%j+A(j,1586)%j)*f(398)+(-A(j,1577)%j-A(j,1578)%j-A(j,1583)%j &
       -A(j,1584)%j)*f(399)+(-A(j,1009)%j-A(j,1010)%j-A(j,1021)%j-A(j,1022)%j-A(j,1033)%j-A(j,1034)%j)*f(400)+(-A(j,1013)%j &
       -A(j,1014)%j-A(j,1025)%j-A(j,1026)%j)*f(401)+(A(j,1011)%j+A(j,1012)%j+A(j,1023)%j+A(j,1024)%j)*f(402)+(A(j,1617)%j &
       +A(j,1618)%j+A(j,1629)%j+A(j,1630)%j+A(j,1641)%j+A(j,1642)%j)*f(403)+(A(j,1621)%j+A(j,1622)%j+A(j,1633)%j &
       +A(j,1634)%j)*f(404)+(-A(j,1619)%j-A(j,1620)%j-A(j,1631)%j-A(j,1632)%j)*f(405)+(-A(j,981)%j-A(j,982)%j-A(j,993)%j &
       -A(j,994)%j-A(j,1005)%j-A(j,1006)%j)*f(406)+(-A(j,985)%j-A(j,986)%j-A(j,997)%j-A(j,998)%j)*f(407)+(A(j,983)%j+A(j,984)%j &
       +A(j,995)%j+A(j,996)%j)*f(408)+(A(j,1589)%j+A(j,1590)%j+A(j,1601)%j+A(j,1602)%j+A(j,1613)%j+A(j,1614)%j)*f(409) &
       +(A(j,1593)%j+A(j,1594)%j+A(j,1605)%j+A(j,1606)%j)*f(410)+(-A(j,1591)%j-A(j,1592)%j-A(j,1603)%j-A(j,1604)%j)*f(411) &
       +(A(j,1133)%j+A(j,1134)%j+A(j,1139)%j+A(j,1140)%j+A(j,1145)%j+A(j,1146)%j)*f(412)+(A(j,1137)%j+A(j,1138)%j+A(j,1143)%j &
       +A(j,1144)%j)*f(413)+(-A(j,1135)%j-A(j,1136)%j-A(j,1141)%j-A(j,1142)%j)*f(414)+(A(j,1741)%j+A(j,1742)%j+A(j,1747)%j &
       +A(j,1748)%j+A(j,1753)%j+A(j,1754)%j)*f(415)+(A(j,1745)%j+A(j,1746)%j+A(j,1751)%j+A(j,1752)%j)*f(416)+(-A(j,1743)%j &
       -A(j,1744)%j-A(j,1749)%j-A(j,1750)%j)*f(417)+(A(j,1235)%j+A(j,1236)%j+A(j,1247)%j+A(j,1248)%j+A(j,1259)%j &
       +A(j,1260)%j)*f(418)+(A(j,1239)%j+A(j,1240)%j+A(j,1251)%j+A(j,1252)%j)*f(419)+(-A(j,1237)%j-A(j,1238)%j-A(j,1249)%j &
       -A(j,1250)%j)*f(420)+(A(j,1843)%j+A(j,1844)%j+A(j,1855)%j+A(j,1856)%j+A(j,1867)%j+A(j,1868)%j)*f(421)+(A(j,1847)%j &
       +A(j,1848)%j+A(j,1859)%j+A(j,1860)%j)*f(422)+(-A(j,1845)%j-A(j,1846)%j-A(j,1857)%j-A(j,1858)%j)*f(423)+(-A(j,1481)%j &
       -A(j,1485)%j-A(j,1489)%j-A(j,1493)%j-A(j,1497)%j-A(j,1501)%j)*f(424)+(A(j,1553)%j+A(j,1557)%j+A(j,1561)%j+A(j,1565)%j &
       +A(j,1569)%j+A(j,1573)%j)*f(425)+(-A(j,1480)%j-A(j,1484)%j-A(j,1488)%j-A(j,1492)%j-A(j,1496)%j-A(j,1500)%j)*f(426) &
       +(A(j,2088)%j+A(j,2092)%j+A(j,2096)%j+A(j,2100)%j+A(j,2104)%j+A(j,2108)%j)*f(427)+(A(j,1552)%j+A(j,1556)%j+A(j,1560)%j &
       +A(j,1564)%j+A(j,1568)%j+A(j,1572)%j)*f(428)+(A(j,2089)%j+A(j,2093)%j+A(j,2097)%j+A(j,2101)%j+A(j,2105)%j &
       +A(j,2109)%j)*f(429)+(-A(j,1433)%j-A(j,1454)%j)*f(430)+(-A(j,1418)%j-A(j,1420)%j-A(j,1435)%j-A(j,1437)%j-A(j,1450)%j &
       -A(j,1452)%j)*f(431)+(A(j,2041)%j+A(j,2062)%j)*f(432)+(A(j,2026)%j+A(j,2028)%j+A(j,2043)%j+A(j,2045)%j+A(j,2058)%j &
       +A(j,2060)%j)*f(433)+(-A(j,1385)%j-A(j,1406)%j)*f(434)+(-A(j,1370)%j-A(j,1372)%j-A(j,1387)%j-A(j,1389)%j-A(j,1402)%j &
       -A(j,1404)%j)*f(435)+(A(j,1993)%j+A(j,2014)%j)*f(436)+(A(j,1978)%j+A(j,1980)%j+A(j,1995)%j+A(j,1997)%j+A(j,2010)%j &
       +A(j,2012)%j)*f(437)+(-A(j,1212)%j-A(j,1216)%j-A(j,1220)%j-A(j,1224)%j-A(j,1228)%j-A(j,1232)%j)*f(438)+(A(j,1504)%j &
       +A(j,1508)%j+A(j,1512)%j+A(j,1516)%j+A(j,1520)%j+A(j,1524)%j)*f(439)+(-A(j,1213)%j-A(j,1217)%j-A(j,1221)%j-A(j,1225)%j &
       -A(j,1229)%j-A(j,1233)%j)*f(440)+(A(j,1821)%j+A(j,1825)%j+A(j,1829)%j+A(j,1833)%j+A(j,1837)%j+A(j,1841)%j)*f(441) &
       +(A(j,1505)%j+A(j,1509)%j+A(j,1513)%j+A(j,1517)%j+A(j,1521)%j+A(j,1525)%j)*f(442)+(A(j,1820)%j+A(j,1824)%j+A(j,1828)%j &
       +A(j,1832)%j+A(j,1836)%j+A(j,1840)%j)*f(443)+(-A(j,1456)%j-A(j,1460)%j-A(j,1464)%j-A(j,1468)%j-A(j,1472)%j &
       -A(j,1476)%j)*f(444)+(A(j,1529)%j+A(j,1533)%j+A(j,1537)%j+A(j,1541)%j+A(j,1545)%j+A(j,1549)%j)*f(445)+(-A(j,1457)%j &
       -A(j,1461)%j-A(j,1465)%j-A(j,1469)%j-A(j,1473)%j-A(j,1477)%j)*f(446)+(A(j,2065)%j+A(j,2069)%j+A(j,2073)%j+A(j,2077)%j &
       +A(j,2081)%j+A(j,2085)%j)*f(447)+(A(j,1528)%j+A(j,1532)%j+A(j,1536)%j+A(j,1540)%j+A(j,1544)%j+A(j,1548)%j)*f(448) &
       +(A(j,2064)%j+A(j,2068)%j+A(j,2072)%j+A(j,2076)%j+A(j,2080)%j+A(j,2084)%j)*f(449)+(-A(j,1337)%j-A(j,1358)%j)*f(450)+( &
       -A(j,1322)%j-A(j,1324)%j-A(j,1339)%j-A(j,1341)%j-A(j,1354)%j-A(j,1356)%j)*f(451)+(A(j,1945)%j+A(j,1966)%j)*f(452) &
       +(A(j,1930)%j+A(j,1932)%j+A(j,1947)%j+A(j,1949)%j+A(j,1962)%j+A(j,1964)%j)*f(453)+(-A(j,1289)%j-A(j,1310)%j)*f(454)+( &
       -A(j,1274)%j-A(j,1276)%j-A(j,1291)%j-A(j,1293)%j-A(j,1306)%j-A(j,1308)%j)*f(455)+(A(j,1897)%j+A(j,1918)%j)*f(456) &
       +(A(j,1882)%j+A(j,1884)%j+A(j,1899)%j+A(j,1901)%j+A(j,1914)%j+A(j,1916)%j)*f(457)+(-A(j,1202)%j-A(j,1210)%j)*f(458)+( &
       -A(j,1196)%j-A(j,1198)%j-A(j,1200)%j-A(j,1204)%j-A(j,1206)%j-A(j,1208)%j)*f(459)+(A(j,1810)%j+A(j,1818)%j)*f(460) &
       +(A(j,1804)%j+A(j,1806)%j+A(j,1808)%j+A(j,1812)%j+A(j,1814)%j+A(j,1816)%j)*f(461)+(-A(j,1170)%j-A(j,1178)%j)*f(462)+( &
       -A(j,1164)%j-A(j,1166)%j-A(j,1168)%j-A(j,1172)%j-A(j,1174)%j-A(j,1176)%j)*f(463)+(A(j,1778)%j+A(j,1786)%j)*f(464) &
       +(A(j,1772)%j+A(j,1774)%j+A(j,1776)%j+A(j,1780)%j+A(j,1782)%j+A(j,1784)%j)*f(465)+(-A(j,1410)%j-A(j,1411)%j-A(j,1415)%j &
       -A(j,1416)%j-A(j,1424)%j-A(j,1425)%j-A(j,1430)%j-A(j,1431)%j-A(j,1441)%j-A(j,1442)%j-A(j,1446)%j-A(j,1447)%j)*f(466) &
       +(A(j,1408)%j+A(j,1409)%j+A(j,1413)%j+A(j,1414)%j+A(j,1422)%j+A(j,1423)%j+A(j,1428)%j+A(j,1429)%j+A(j,1439)%j+A(j,1440)%j &
       +A(j,1444)%j+A(j,1445)%j)*f(467)+(A(j,2018)%j+A(j,2019)%j+A(j,2023)%j+A(j,2024)%j+A(j,2032)%j+A(j,2033)%j+A(j,2038)%j &
       +A(j,2039)%j+A(j,2049)%j+A(j,2050)%j+A(j,2054)%j+A(j,2055)%j)*f(468)+(-A(j,2016)%j-A(j,2017)%j-A(j,2021)%j-A(j,2022)%j &
       -A(j,2030)%j-A(j,2031)%j-A(j,2036)%j-A(j,2037)%j-A(j,2047)%j-A(j,2048)%j-A(j,2052)%j-A(j,2053)%j)*f(469)+(-A(j,1314)%j &
       -A(j,1315)%j-A(j,1319)%j-A(j,1320)%j-A(j,1328)%j-A(j,1329)%j-A(j,1334)%j-A(j,1335)%j-A(j,1345)%j-A(j,1346)%j-A(j,1350)%j &
       -A(j,1351)%j)*f(470)+(A(j,1312)%j+A(j,1313)%j+A(j,1317)%j+A(j,1318)%j+A(j,1326)%j+A(j,1327)%j+A(j,1332)%j+A(j,1333)%j &
       +A(j,1343)%j+A(j,1344)%j+A(j,1348)%j+A(j,1349)%j)*f(471)+(A(j,1922)%j+A(j,1923)%j+A(j,1927)%j+A(j,1928)%j+A(j,1936)%j &
       +A(j,1937)%j+A(j,1942)%j+A(j,1943)%j+A(j,1953)%j+A(j,1954)%j+A(j,1958)%j+A(j,1959)%j)*f(472)+(-A(j,1920)%j-A(j,1921)%j &
       -A(j,1925)%j-A(j,1926)%j-A(j,1934)%j-A(j,1935)%j-A(j,1940)%j-A(j,1941)%j-A(j,1951)%j-A(j,1952)%j-A(j,1956)%j &
       -A(j,1957)%j)*f(473)+(-A(j,1186)%j-A(j,1194)%j)*f(474)+(-A(j,1180)%j-A(j,1182)%j-A(j,1184)%j-A(j,1188)%j-A(j,1190)%j &
       -A(j,1192)%j)*f(475)+(A(j,1794)%j+A(j,1802)%j)*f(476)+(A(j,1788)%j+A(j,1790)%j+A(j,1792)%j+A(j,1796)%j+A(j,1798)%j &
       +A(j,1800)%j)*f(477)+(-A(j,1154)%j-A(j,1162)%j)*f(478)+(-A(j,1148)%j-A(j,1150)%j-A(j,1152)%j-A(j,1156)%j-A(j,1158)%j &
       -A(j,1160)%j)*f(479)+(A(j,1762)%j+A(j,1770)%j)*f(480)+(A(j,1756)%j+A(j,1758)%j+A(j,1760)%j+A(j,1764)%j+A(j,1766)%j &
       +A(j,1768)%j)*f(481)+(-A(j,1362)%j-A(j,1363)%j-A(j,1367)%j-A(j,1368)%j-A(j,1376)%j-A(j,1377)%j-A(j,1382)%j-A(j,1383)%j &
       -A(j,1393)%j-A(j,1394)%j-A(j,1398)%j-A(j,1399)%j)*f(482)+(A(j,1360)%j+A(j,1361)%j+A(j,1365)%j+A(j,1366)%j+A(j,1374)%j &
       +A(j,1375)%j+A(j,1380)%j+A(j,1381)%j+A(j,1391)%j+A(j,1392)%j+A(j,1396)%j+A(j,1397)%j)*f(483)+(A(j,1970)%j+A(j,1971)%j &
       +A(j,1975)%j+A(j,1976)%j+A(j,1984)%j+A(j,1985)%j+A(j,1990)%j+A(j,1991)%j+A(j,2001)%j+A(j,2002)%j+A(j,2006)%j &
       +A(j,2007)%j)*f(484)+(-A(j,1968)%j-A(j,1969)%j-A(j,1973)%j-A(j,1974)%j-A(j,1982)%j-A(j,1983)%j-A(j,1988)%j-A(j,1989)%j &
       -A(j,1999)%j-A(j,2000)%j-A(j,2004)%j-A(j,2005)%j)*f(485)+(-A(j,1266)%j-A(j,1267)%j-A(j,1271)%j-A(j,1272)%j-A(j,1280)%j &
       -A(j,1281)%j-A(j,1286)%j-A(j,1287)%j-A(j,1297)%j-A(j,1298)%j-A(j,1302)%j-A(j,1303)%j)*f(486)+(A(j,1264)%j+A(j,1265)%j &
       +A(j,1269)%j+A(j,1270)%j+A(j,1278)%j+A(j,1279)%j+A(j,1284)%j+A(j,1285)%j+A(j,1295)%j+A(j,1296)%j+A(j,1300)%j &
       +A(j,1301)%j)*f(487)+(A(j,1874)%j+A(j,1875)%j+A(j,1879)%j+A(j,1880)%j+A(j,1888)%j+A(j,1889)%j+A(j,1894)%j+A(j,1895)%j &
       +A(j,1905)%j+A(j,1906)%j+A(j,1910)%j+A(j,1911)%j)*f(488)+(-A(j,1872)%j-A(j,1873)%j-A(j,1877)%j-A(j,1878)%j-A(j,1886)%j &
       -A(j,1887)%j-A(j,1892)%j-A(j,1893)%j-A(j,1903)%j-A(j,1904)%j-A(j,1908)%j-A(j,1909)%j)*f(489)+(A(j,672)%j+A(j,674)%j &
       +A(j,676)%j+A(j,678)%j+A(j,680)%j+A(j,682)%j)*f(490)+(-A(j,671)%j-A(j,673)%j-A(j,675)%j-A(j,677)%j-A(j,679)%j &
       -A(j,681)%j)*f(491)+(A(j,648)%j+A(j,650)%j+A(j,652)%j+A(j,654)%j+A(j,656)%j+A(j,658)%j)*f(492)+(-A(j,647)%j-A(j,649)%j &
       -A(j,651)%j-A(j,653)%j-A(j,655)%j-A(j,657)%j)*f(493)+(A(j,660)%j+A(j,662)%j+A(j,664)%j+A(j,666)%j+A(j,668)%j &
       +A(j,670)%j)*f(494)+(-A(j,659)%j-A(j,661)%j-A(j,663)%j-A(j,665)%j-A(j,667)%j-A(j,669)%j)*f(495)+(A(j,636)%j+A(j,638)%j &
       +A(j,640)%j+A(j,642)%j+A(j,644)%j+A(j,646)%j)*f(496)+(-A(j,635)%j-A(j,637)%j-A(j,639)%j-A(j,641)%j-A(j,643)%j &
       -A(j,645)%j)*f(497)+(A(j,593)%j+A(j,594)%j+A(j,601)%j+A(j,602)%j+A(j,609)%j+A(j,610)%j+A(j,617)%j+A(j,618)%j+A(j,625)%j &
       +A(j,626)%j+A(j,633)%j+A(j,634)%j)*f(498)+(-A(j,589)%j-A(j,590)%j-A(j,591)%j-A(j,592)%j-A(j,597)%j-A(j,598)%j-A(j,599)%j &
       -A(j,600)%j-A(j,605)%j-A(j,606)%j-A(j,607)%j-A(j,608)%j-A(j,613)%j-A(j,614)%j-A(j,615)%j-A(j,616)%j-A(j,621)%j-A(j,622)%j &
       -A(j,623)%j-A(j,624)%j-A(j,629)%j-A(j,630)%j-A(j,631)%j-A(j,632)%j)*f(499)+(A(j,587)%j+A(j,588)%j+A(j,595)%j+A(j,596)%j &
       +A(j,603)%j+A(j,604)%j+A(j,611)%j+A(j,612)%j+A(j,619)%j+A(j,620)%j+A(j,627)%j+A(j,628)%j)*f(500)+(-A(j,3655)%j-A(j,3656)%j &
       -A(j,3657)%j-A(j,3658)%j-A(j,3659)%j-A(j,3660)%j)*f(501)+(-A(j,3719)%j-A(j,3720)%j-A(j,3721)%j-A(j,3722)%j-A(j,3723)%j &
       -A(j,3724)%j)*f(502)+(-A(j,3667)%j-A(j,3668)%j-A(j,3669)%j-A(j,3670)%j-A(j,3671)%j-A(j,3672)%j)*f(503)+(-A(j,3673)%j &
       -A(j,3674)%j-A(j,3675)%j-A(j,3676)%j-A(j,3677)%j-A(j,3678)%j)*f(504)+(-A(j,3713)%j-A(j,3718)%j)*f(505)+(-A(j,3711)%j &
       -A(j,3712)%j-A(j,3714)%j-A(j,3715)%j-A(j,3716)%j-A(j,3717)%j)*f(506)+(-A(j,3697)%j-A(j,3702)%j)*f(507)+(-A(j,3695)%j &
       -A(j,3696)%j-A(j,3698)%j-A(j,3699)%j-A(j,3700)%j-A(j,3701)%j)*f(508)+(-A(j,3705)%j-A(j,3710)%j)*f(509)+(-A(j,3703)%j &
       -A(j,3704)%j-A(j,3706)%j-A(j,3707)%j-A(j,3708)%j-A(j,3709)%j)*f(510)+(-A(j,3689)%j-A(j,3694)%j)*f(511)+(-A(j,3687)%j &
       -A(j,3688)%j-A(j,3690)%j-A(j,3691)%j-A(j,3692)%j-A(j,3693)%j)*f(512)+(-A(j,3725)%j-A(j,3726)%j-A(j,3727)%j-A(j,3728)%j &
       -A(j,3729)%j-A(j,3730)%j)*f(513)+(-A(j,3681)%j-A(j,3682)%j-A(j,3685)%j-A(j,3686)%j)*f(514)+(A(j,3679)%j+A(j,3680)%j &
       +A(j,3683)%j+A(j,3684)%j)*f(515)+(-A(j,3661)%j-A(j,3662)%j-A(j,3663)%j-A(j,3664)%j-A(j,3665)%j-A(j,3666)%j)*f(516) &
       +(A(j,2765)%j+A(j,2766)%j+A(j,2767)%j+A(j,2768)%j+A(j,2769)%j+A(j,2770)%j)*f(517)+(A(j,3112)%j+A(j,3114)%j+A(j,3116)%j &
       +A(j,3118)%j+A(j,3120)%j+A(j,3122)%j)*f(518)+(A(j,3191)%j+A(j,3193)%j+A(j,3195)%j+A(j,3197)%j+A(j,3199)%j &
       +A(j,3201)%j)*f(519)+(A(j,3093)%j+A(j,3098)%j)*f(520)+(A(j,3091)%j+A(j,3092)%j+A(j,3094)%j+A(j,3095)%j+A(j,3096)%j &
       +A(j,3097)%j)*f(521)+(A(j,3085)%j+A(j,3090)%j)*f(522)+(A(j,3083)%j+A(j,3084)%j+A(j,3086)%j+A(j,3087)%j+A(j,3088)%j &
       +A(j,3089)%j)*f(523)+(A(j,3541)%j+A(j,3544)%j)*f(524)+(A(j,3539)%j+A(j,3540)%j+A(j,3542)%j+A(j,3543)%j+A(j,3545)%j &
       +A(j,3546)%j)*f(525)+(A(j,3501)%j+A(j,3504)%j)*f(526)+(A(j,3499)%j+A(j,3500)%j+A(j,3502)%j+A(j,3503)%j+A(j,3505)%j &
       +A(j,3506)%j)*f(527)+(A(j,3457)%j+A(j,3458)%j+A(j,3459)%j+A(j,3460)%j+A(j,3461)%j+A(j,3462)%j)*f(528)+(A(j,3455)%j &
       +A(j,3456)%j+A(j,3465)%j+A(j,3466)%j)*f(529)+(-A(j,3453)%j-A(j,3454)%j-A(j,3463)%j-A(j,3464)%j)*f(530)+(A(j,3111)%j &
       +A(j,3113)%j+A(j,3115)%j+A(j,3117)%j+A(j,3119)%j+A(j,3121)%j)*f(531)+(A(j,3061)%j+A(j,3062)%j+A(j,3063)%j+A(j,3064)%j &
       +A(j,3065)%j+A(j,3066)%j)*f(532)+(A(j,3167)%j+A(j,3169)%j+A(j,3171)%j+A(j,3173)%j+A(j,3175)%j+A(j,3177)%j)*f(533) &
       +(A(j,3037)%j+A(j,3054)%j)*f(534)+(A(j,3023)%j+A(j,3024)%j+A(j,3038)%j+A(j,3039)%j+A(j,3052)%j+A(j,3053)%j)*f(535) &
       +(A(j,2997)%j+A(j,3014)%j)*f(536)+(A(j,2983)%j+A(j,2984)%j+A(j,2998)%j+A(j,2999)%j+A(j,3012)%j+A(j,3013)%j)*f(537) &
       +(A(j,3433)%j+A(j,3436)%j)*f(538)+(A(j,3431)%j+A(j,3432)%j+A(j,3434)%j+A(j,3435)%j+A(j,3437)%j+A(j,3438)%j)*f(539) &
       +(A(j,3393)%j+A(j,3396)%j)*f(540)+(A(j,3391)%j+A(j,3392)%j+A(j,3394)%j+A(j,3395)%j+A(j,3397)%j+A(j,3398)%j)*f(541) &
       +(A(j,3309)%j+A(j,3310)%j+A(j,3351)%j+A(j,3352)%j+A(j,3353)%j+A(j,3354)%j)*f(542)+(A(j,3307)%j+A(j,3308)%j+A(j,3357)%j &
       +A(j,3358)%j)*f(543)+(-A(j,3305)%j-A(j,3306)%j-A(j,3355)%j-A(j,3356)%j)*f(544)+(A(j,3192)%j+A(j,3194)%j+A(j,3196)%j &
       +A(j,3198)%j+A(j,3200)%j+A(j,3202)%j)*f(545)+(A(j,3168)%j+A(j,3170)%j+A(j,3172)%j+A(j,3174)%j+A(j,3176)%j &
       +A(j,3178)%j)*f(546)+(A(j,2777)%j+A(j,2778)%j+A(j,2779)%j+A(j,2780)%j+A(j,2781)%j+A(j,2782)%j)*f(547)+(A(j,3149)%j &
       +A(j,3154)%j)*f(548)+(A(j,3147)%j+A(j,3148)%j+A(j,3150)%j+A(j,3151)%j+A(j,3152)%j+A(j,3153)%j)*f(549)+(A(j,3141)%j &
       +A(j,3146)%j)*f(550)+(A(j,3139)%j+A(j,3140)%j+A(j,3142)%j+A(j,3143)%j+A(j,3144)%j+A(j,3145)%j)*f(551)+(A(j,3649)%j &
       +A(j,3652)%j)*f(552)+(A(j,3647)%j+A(j,3648)%j+A(j,3650)%j+A(j,3651)%j+A(j,3653)%j+A(j,3654)%j)*f(553)+(A(j,3609)%j &
       +A(j,3612)%j)*f(554)+(A(j,3607)%j+A(j,3608)%j+A(j,3610)%j+A(j,3611)%j+A(j,3613)%j+A(j,3614)%j)*f(555)+(A(j,3565)%j &
       +A(j,3566)%j+A(j,3567)%j+A(j,3568)%j+A(j,3569)%j+A(j,3570)%j)*f(556)+(A(j,3563)%j+A(j,3564)%j+A(j,3573)%j &
       +A(j,3574)%j)*f(557)+(-A(j,3561)%j-A(j,3562)%j-A(j,3571)%j-A(j,3572)%j)*f(558)+(A(j,3525)%j+A(j,3536)%j)*f(559) &
       +(A(j,3515)%j+A(j,3516)%j+A(j,3526)%j+A(j,3527)%j+A(j,3537)%j+A(j,3538)%j)*f(560)+(A(j,3485)%j+A(j,3496)%j)*f(561) &
       +(A(j,3475)%j+A(j,3476)%j+A(j,3486)%j+A(j,3487)%j+A(j,3497)%j+A(j,3498)%j)*f(562)+(A(j,2759)%j+A(j,2760)%j+A(j,2761)%j &
       +A(j,2762)%j+A(j,2763)%j+A(j,2764)%j)*f(563)+(A(j,3099)%j+A(j,3101)%j+A(j,3103)%j+A(j,3105)%j+A(j,3107)%j &
       +A(j,3109)%j)*f(564)+(A(j,3179)%j+A(j,3181)%j+A(j,3183)%j+A(j,3185)%j+A(j,3187)%j+A(j,3189)%j)*f(565)+(A(j,3077)%j &
       +A(j,3082)%j)*f(566)+(A(j,3075)%j+A(j,3076)%j+A(j,3078)%j+A(j,3079)%j+A(j,3080)%j+A(j,3081)%j)*f(567)+(A(j,3069)%j &
       +A(j,3074)%j)*f(568)+(A(j,3067)%j+A(j,3068)%j+A(j,3070)%j+A(j,3071)%j+A(j,3072)%j+A(j,3073)%j)*f(569)+(A(j,3443)%j &
       +A(j,3444)%j+A(j,3445)%j+A(j,3446)%j+A(j,3447)%j+A(j,3448)%j)*f(570)+(A(j,3441)%j+A(j,3442)%j+A(j,3451)%j &
       +A(j,3452)%j)*f(571)+(-A(j,3439)%j-A(j,3440)%j-A(j,3449)%j-A(j,3450)%j)*f(572)+(A(j,3417)%j+A(j,3428)%j)*f(573) &
       +(A(j,3407)%j+A(j,3408)%j+A(j,3418)%j+A(j,3419)%j+A(j,3429)%j+A(j,3430)%j)*f(574)+(A(j,3377)%j+A(j,3388)%j)*f(575) &
       +(A(j,3367)%j+A(j,3368)%j+A(j,3378)%j+A(j,3379)%j+A(j,3389)%j+A(j,3390)%j)*f(576)+(A(j,3100)%j+A(j,3102)%j+A(j,3104)%j &
       +A(j,3106)%j+A(j,3108)%j+A(j,3110)%j)*f(577)+(A(j,3055)%j+A(j,3056)%j+A(j,3057)%j+A(j,3058)%j+A(j,3059)%j &
       +A(j,3060)%j)*f(578)+(A(j,3156)%j+A(j,3158)%j+A(j,3160)%j+A(j,3162)%j+A(j,3164)%j+A(j,3166)%j)*f(579)+(A(j,2957)%j &
       +A(j,2974)%j)*f(580)+(A(j,2943)%j+A(j,2944)%j+A(j,2958)%j+A(j,2959)%j+A(j,2972)%j+A(j,2973)%j)*f(581)+(A(j,2917)%j &
       +A(j,2934)%j)*f(582)+(A(j,2903)%j+A(j,2904)%j+A(j,2918)%j+A(j,2919)%j+A(j,2932)%j+A(j,2933)%j)*f(583)+(A(j,3231)%j &
       +A(j,3232)%j+A(j,3273)%j+A(j,3274)%j+A(j,3275)%j+A(j,3276)%j)*f(584)+(A(j,3229)%j+A(j,3230)%j+A(j,3279)%j &
       +A(j,3280)%j)*f(585)+(-A(j,3227)%j-A(j,3228)%j-A(j,3277)%j-A(j,3278)%j)*f(586)+(A(j,3633)%j+A(j,3644)%j)*f(587) &
       +(A(j,3623)%j+A(j,3624)%j+A(j,3634)%j+A(j,3635)%j+A(j,3645)%j+A(j,3646)%j)*f(588)+(A(j,3593)%j+A(j,3604)%j)*f(589) &
       +(A(j,3583)%j+A(j,3584)%j+A(j,3594)%j+A(j,3595)%j+A(j,3605)%j+A(j,3606)%j)*f(590)+(A(j,3180)%j+A(j,3182)%j+A(j,3184)%j &
       +A(j,3186)%j+A(j,3188)%j+A(j,3190)%j)*f(591)+(A(j,3155)%j+A(j,3157)%j+A(j,3159)%j+A(j,3161)%j+A(j,3163)%j &
       +A(j,3165)%j)*f(592)+(A(j,2771)%j+A(j,2772)%j+A(j,2773)%j+A(j,2774)%j+A(j,2775)%j+A(j,2776)%j)*f(593)+(A(j,3133)%j &
       +A(j,3138)%j)*f(594)+(A(j,3131)%j+A(j,3132)%j+A(j,3134)%j+A(j,3135)%j+A(j,3136)%j+A(j,3137)%j)*f(595)+(A(j,3125)%j &
       +A(j,3130)%j)*f(596)+(A(j,3123)%j+A(j,3124)%j+A(j,3126)%j+A(j,3127)%j+A(j,3128)%j+A(j,3129)%j)*f(597)+(A(j,3551)%j &
       +A(j,3552)%j+A(j,3553)%j+A(j,3554)%j+A(j,3555)%j+A(j,3556)%j)*f(598)+(A(j,3549)%j+A(j,3550)%j+A(j,3559)%j &
       +A(j,3560)%j)*f(599)+(-A(j,3547)%j-A(j,3548)%j-A(j,3557)%j-A(j,3558)%j)*f(600)+(-A(j,3507)%j-A(j,3508)%j-A(j,3511)%j &
       -A(j,3512)%j-A(j,3517)%j-A(j,3518)%j-A(j,3521)%j-A(j,3522)%j-A(j,3528)%j-A(j,3529)%j-A(j,3532)%j-A(j,3533)%j)*f(601) &
       +(A(j,3509)%j+A(j,3510)%j+A(j,3513)%j+A(j,3514)%j+A(j,3519)%j+A(j,3520)%j+A(j,3523)%j+A(j,3524)%j+A(j,3530)%j+A(j,3531)%j &
       +A(j,3534)%j+A(j,3535)%j)*f(602)+(A(j,3399)%j+A(j,3400)%j+A(j,3403)%j+A(j,3404)%j+A(j,3409)%j+A(j,3410)%j+A(j,3413)%j &
       +A(j,3414)%j+A(j,3420)%j+A(j,3421)%j+A(j,3424)%j+A(j,3425)%j)*f(603)+(A(j,3401)%j+A(j,3402)%j+A(j,3405)%j+A(j,3406)%j &
       +A(j,3411)%j+A(j,3412)%j+A(j,3415)%j+A(j,3416)%j+A(j,3422)%j+A(j,3423)%j+A(j,3426)%j+A(j,3427)%j)*f(604)+(-A(j,3615)%j &
       -A(j,3616)%j-A(j,3619)%j-A(j,3620)%j-A(j,3625)%j-A(j,3626)%j-A(j,3629)%j-A(j,3630)%j-A(j,3636)%j-A(j,3637)%j-A(j,3640)%j &
       -A(j,3641)%j)*f(605)+(A(j,3617)%j+A(j,3618)%j+A(j,3621)%j+A(j,3622)%j+A(j,3627)%j+A(j,3628)%j+A(j,3631)%j+A(j,3632)%j &
       +A(j,3638)%j+A(j,3639)%j+A(j,3642)%j+A(j,3643)%j)*f(606)+(-A(j,3293)%j-A(j,3294)%j-A(j,3327)%j-A(j,3328)%j-A(j,3347)%j &
       -A(j,3348)%j)*f(607)+(A(j,3297)%j+A(j,3298)%j+A(j,3323)%j+A(j,3324)%j+A(j,3343)%j+A(j,3344)%j)*f(608)+(A(j,3301)%j &
       +A(j,3302)%j+A(j,3331)%j+A(j,3332)%j)*f(609)+(A(j,3303)%j+A(j,3304)%j+A(j,3333)%j+A(j,3334)%j)*f(610)+(A(j,3295)%j &
       +A(j,3296)%j+A(j,3299)%j+A(j,3300)%j+A(j,3325)%j+A(j,3326)%j+A(j,3329)%j+A(j,3330)%j+A(j,3345)%j+A(j,3346)%j+A(j,3349)%j &
       +A(j,3350)%j)*f(611)+(-A(j,3215)%j-A(j,3216)%j-A(j,3249)%j-A(j,3250)%j-A(j,3269)%j-A(j,3270)%j)*f(612)+(A(j,3219)%j &
       +A(j,3220)%j+A(j,3245)%j+A(j,3246)%j+A(j,3265)%j+A(j,3266)%j)*f(613)+(A(j,3223)%j+A(j,3224)%j+A(j,3253)%j &
       +A(j,3254)%j)*f(614)+(A(j,3225)%j+A(j,3226)%j+A(j,3255)%j+A(j,3256)%j)*f(615)+(A(j,3217)%j+A(j,3218)%j+A(j,3221)%j &
       +A(j,3222)%j+A(j,3247)%j+A(j,3248)%j+A(j,3251)%j+A(j,3252)%j+A(j,3267)%j+A(j,3268)%j+A(j,3271)%j+A(j,3272)%j)*f(616) &
       +(A(j,3029)%j+A(j,3030)%j+A(j,3048)%j+A(j,3049)%j)*f(617)+(A(j,3015)%j+A(j,3016)%j+A(j,3019)%j+A(j,3020)%j+A(j,3025)%j &
       +A(j,3026)%j+A(j,3033)%j+A(j,3034)%j+A(j,3040)%j+A(j,3041)%j+A(j,3044)%j+A(j,3045)%j)*f(618)+(A(j,3031)%j+A(j,3032)%j &
       +A(j,3050)%j+A(j,3051)%j)*f(619)+(A(j,3017)%j+A(j,3018)%j+A(j,3021)%j+A(j,3022)%j+A(j,3027)%j+A(j,3028)%j+A(j,3035)%j &
       +A(j,3036)%j+A(j,3042)%j+A(j,3043)%j+A(j,3046)%j+A(j,3047)%j)*f(620)+(A(j,2949)%j+A(j,2950)%j+A(j,2968)%j &
       +A(j,2969)%j)*f(621)+(A(j,2935)%j+A(j,2936)%j+A(j,2939)%j+A(j,2940)%j+A(j,2945)%j+A(j,2946)%j+A(j,2953)%j+A(j,2954)%j &
       +A(j,2960)%j+A(j,2961)%j+A(j,2964)%j+A(j,2965)%j)*f(622)+(A(j,2951)%j+A(j,2952)%j+A(j,2970)%j+A(j,2971)%j)*f(623) &
       +(A(j,2937)%j+A(j,2938)%j+A(j,2941)%j+A(j,2942)%j+A(j,2947)%j+A(j,2948)%j+A(j,2955)%j+A(j,2956)%j+A(j,2962)%j+A(j,2963)%j &
       +A(j,2966)%j+A(j,2967)%j)*f(624)+(A(j,2807)%j+A(j,2808)%j+A(j,2811)%j+A(j,2812)%j+A(j,2855)%j+A(j,2856)%j+A(j,2859)%j &
       +A(j,2860)%j+A(j,2887)%j+A(j,2888)%j+A(j,2891)%j+A(j,2892)%j)*f(625)+(A(j,2819)%j+A(j,2820)%j+A(j,2821)%j+A(j,2822)%j &
       +A(j,2867)%j+A(j,2868)%j+A(j,2869)%j+A(j,2870)%j)*f(626)+(-A(j,2815)%j-A(j,2816)%j-A(j,2817)%j-A(j,2818)%j-A(j,2863)%j &
       -A(j,2864)%j-A(j,2865)%j-A(j,2866)%j)*f(627)+(A(j,2809)%j+A(j,2810)%j+A(j,2813)%j+A(j,2814)%j+A(j,2857)%j+A(j,2858)%j &
       +A(j,2861)%j+A(j,2862)%j+A(j,2889)%j+A(j,2890)%j+A(j,2893)%j+A(j,2894)%j)*f(628)+(A(j,2827)%j+A(j,2828)%j+A(j,2829)%j &
       +A(j,2830)%j+A(j,2875)%j+A(j,2876)%j+A(j,2877)%j+A(j,2878)%j)*f(629)+(-A(j,2823)%j-A(j,2824)%j-A(j,2825)%j-A(j,2826)%j &
       -A(j,2871)%j-A(j,2872)%j-A(j,2873)%j-A(j,2874)%j)*f(630)+(-A(j,3467)%j-A(j,3468)%j-A(j,3471)%j-A(j,3472)%j-A(j,3477)%j &
       -A(j,3478)%j-A(j,3481)%j-A(j,3482)%j-A(j,3488)%j-A(j,3489)%j-A(j,3492)%j-A(j,3493)%j)*f(631)+(A(j,3469)%j+A(j,3470)%j &
       +A(j,3473)%j+A(j,3474)%j+A(j,3479)%j+A(j,3480)%j+A(j,3483)%j+A(j,3484)%j+A(j,3490)%j+A(j,3491)%j+A(j,3494)%j &
       +A(j,3495)%j)*f(632)+(A(j,3359)%j+A(j,3360)%j+A(j,3363)%j+A(j,3364)%j+A(j,3369)%j+A(j,3370)%j+A(j,3373)%j+A(j,3374)%j &
       +A(j,3380)%j+A(j,3381)%j+A(j,3384)%j+A(j,3385)%j)*f(633)+(A(j,3361)%j+A(j,3362)%j+A(j,3365)%j+A(j,3366)%j+A(j,3371)%j &
       +A(j,3372)%j+A(j,3375)%j+A(j,3376)%j+A(j,3382)%j+A(j,3383)%j+A(j,3386)%j+A(j,3387)%j)*f(634)+(-A(j,3575)%j-A(j,3576)%j &
       -A(j,3579)%j-A(j,3580)%j-A(j,3585)%j-A(j,3586)%j-A(j,3589)%j-A(j,3590)%j-A(j,3596)%j-A(j,3597)%j-A(j,3600)%j &
       -A(j,3601)%j)*f(635)+(A(j,3577)%j+A(j,3578)%j+A(j,3581)%j+A(j,3582)%j+A(j,3587)%j+A(j,3588)%j+A(j,3591)%j+A(j,3592)%j &
       +A(j,3598)%j+A(j,3599)%j+A(j,3602)%j+A(j,3603)%j)*f(636)+(-A(j,3281)%j-A(j,3282)%j-A(j,3315)%j-A(j,3316)%j-A(j,3339)%j &
       -A(j,3340)%j)*f(637)+(A(j,3285)%j+A(j,3286)%j+A(j,3311)%j+A(j,3312)%j+A(j,3335)%j+A(j,3336)%j)*f(638)+(A(j,3289)%j &
       +A(j,3290)%j+A(j,3319)%j+A(j,3320)%j)*f(639)+(A(j,3291)%j+A(j,3292)%j+A(j,3321)%j+A(j,3322)%j)*f(640)+(A(j,3283)%j &
       +A(j,3284)%j+A(j,3287)%j+A(j,3288)%j+A(j,3313)%j+A(j,3314)%j+A(j,3317)%j+A(j,3318)%j+A(j,3337)%j+A(j,3338)%j+A(j,3341)%j &
       +A(j,3342)%j)*f(641)+(-A(j,3203)%j-A(j,3204)%j-A(j,3237)%j-A(j,3238)%j-A(j,3261)%j-A(j,3262)%j)*f(642)+(A(j,3207)%j &
       +A(j,3208)%j+A(j,3233)%j+A(j,3234)%j+A(j,3257)%j+A(j,3258)%j)*f(643)+(A(j,3211)%j+A(j,3212)%j+A(j,3241)%j &
       +A(j,3242)%j)*f(644)+(A(j,3213)%j+A(j,3214)%j+A(j,3243)%j+A(j,3244)%j)*f(645)+(A(j,3205)%j+A(j,3206)%j+A(j,3209)%j &
       +A(j,3210)%j+A(j,3235)%j+A(j,3236)%j+A(j,3239)%j+A(j,3240)%j+A(j,3259)%j+A(j,3260)%j+A(j,3263)%j+A(j,3264)%j)*f(646) &
       +(A(j,2989)%j+A(j,2990)%j+A(j,3008)%j+A(j,3009)%j)*f(647)+(A(j,2975)%j+A(j,2976)%j+A(j,2979)%j+A(j,2980)%j+A(j,2985)%j &
       +A(j,2986)%j+A(j,2993)%j+A(j,2994)%j+A(j,3000)%j+A(j,3001)%j+A(j,3004)%j+A(j,3005)%j)*f(648)+(A(j,2991)%j+A(j,2992)%j &
       +A(j,3010)%j+A(j,3011)%j)*f(649)+(A(j,2977)%j+A(j,2978)%j+A(j,2981)%j+A(j,2982)%j+A(j,2987)%j+A(j,2988)%j+A(j,2995)%j &
       +A(j,2996)%j+A(j,3002)%j+A(j,3003)%j+A(j,3006)%j+A(j,3007)%j)*f(650)+(A(j,2909)%j+A(j,2910)%j+A(j,2928)%j &
       +A(j,2929)%j)*f(651)+(A(j,2895)%j+A(j,2896)%j+A(j,2899)%j+A(j,2900)%j+A(j,2905)%j+A(j,2906)%j+A(j,2913)%j+A(j,2914)%j &
       +A(j,2920)%j+A(j,2921)%j+A(j,2924)%j+A(j,2925)%j)*f(652)+(A(j,2911)%j+A(j,2912)%j+A(j,2930)%j+A(j,2931)%j)*f(653) &
       +(A(j,2897)%j+A(j,2898)%j+A(j,2901)%j+A(j,2902)%j+A(j,2907)%j+A(j,2908)%j+A(j,2915)%j+A(j,2916)%j+A(j,2922)%j+A(j,2923)%j &
       +A(j,2926)%j+A(j,2927)%j)*f(654)+(A(j,2783)%j+A(j,2784)%j+A(j,2787)%j+A(j,2788)%j+A(j,2831)%j+A(j,2832)%j+A(j,2835)%j &
       +A(j,2836)%j+A(j,2879)%j+A(j,2880)%j+A(j,2883)%j+A(j,2884)%j)*f(655)+(A(j,2795)%j+A(j,2796)%j+A(j,2797)%j+A(j,2798)%j &
       +A(j,2843)%j+A(j,2844)%j+A(j,2845)%j+A(j,2846)%j)*f(656)+(-A(j,2791)%j-A(j,2792)%j-A(j,2793)%j-A(j,2794)%j-A(j,2839)%j &
       -A(j,2840)%j-A(j,2841)%j-A(j,2842)%j)*f(657)+(A(j,2785)%j+A(j,2786)%j+A(j,2789)%j+A(j,2790)%j+A(j,2833)%j+A(j,2834)%j &
       +A(j,2837)%j+A(j,2838)%j+A(j,2881)%j+A(j,2882)%j+A(j,2885)%j+A(j,2886)%j)*f(658)+(A(j,2803)%j+A(j,2804)%j+A(j,2805)%j &
       +A(j,2806)%j+A(j,2851)%j+A(j,2852)%j+A(j,2853)%j+A(j,2854)%j)*f(659)+(-A(j,2799)%j-A(j,2800)%j-A(j,2801)%j-A(j,2802)%j &
       -A(j,2847)%j-A(j,2848)%j-A(j,2849)%j-A(j,2850)%j)*f(660)+(-A(j,2683)%j-A(j,2684)%j-A(j,2685)%j-A(j,2686)%j-A(j,2687)%j &
       -A(j,2688)%j)*f(661)+(-A(j,2747)%j-A(j,2748)%j-A(j,2749)%j-A(j,2750)%j-A(j,2751)%j-A(j,2752)%j)*f(662)+(-A(j,2735)%j &
       -A(j,2736)%j-A(j,2737)%j-A(j,2738)%j-A(j,2739)%j-A(j,2740)%j)*f(663)+(-A(j,2753)%j-A(j,2754)%j-A(j,2755)%j-A(j,2756)%j &
       -A(j,2757)%j-A(j,2758)%j)*f(664)+(-A(j,2689)%j-A(j,2690)%j-A(j,2691)%j-A(j,2692)%j-A(j,2693)%j-A(j,2694)%j)*f(665)+( &
       -A(j,2729)%j-A(j,2734)%j)*f(666)+(-A(j,2727)%j-A(j,2728)%j-A(j,2730)%j-A(j,2731)%j-A(j,2732)%j-A(j,2733)%j)*f(667)+( &
       -A(j,2713)%j-A(j,2718)%j)*f(668)+(-A(j,2711)%j-A(j,2712)%j-A(j,2714)%j-A(j,2715)%j-A(j,2716)%j-A(j,2717)%j)*f(669)+( &
       -A(j,2721)%j-A(j,2726)%j)*f(670)+(-A(j,2719)%j-A(j,2720)%j-A(j,2722)%j-A(j,2723)%j-A(j,2724)%j-A(j,2725)%j)*f(671)+( &
       -A(j,2705)%j-A(j,2710)%j)*f(672)+(-A(j,2703)%j-A(j,2704)%j-A(j,2706)%j-A(j,2707)%j-A(j,2708)%j-A(j,2709)%j)*f(673)+( &
       -A(j,2741)%j-A(j,2742)%j-A(j,2743)%j-A(j,2744)%j-A(j,2745)%j-A(j,2746)%j)*f(674)+(-A(j,2697)%j-A(j,2698)%j-A(j,2701)%j &
       -A(j,2702)%j)*f(675)+(A(j,2695)%j+A(j,2696)%j+A(j,2699)%j+A(j,2700)%j)*f(676)


  M1(:)%hf = Hel(j)
  M2(:)%hf = Hel(j)

  !M(i) corresponds to \Gamma_{i} in Fabios thesis

end subroutine colourvectors


! **********************************************************************
subroutine colint(M, M2colint)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K1(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppzzj2loop_ddxzzg_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(1)
  real(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

    do i = 1, 1
      do j = 1, 1
        M2colint = M2colint + real(conjg(M(i))*K1(i,j)*M(j))
      end do
    end do

end subroutine colint

! **********************************************************************
subroutine colint_ct(M, Mct, M2colint_ct, l)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppzzj2loop_ddxzzg_1_/**/REALKIND, only: K2
  implicit none
  complex(REALKIND), intent(in)  :: M(1), Mct(1)
  real(REALKIND),    intent(out) :: M2colint_ct
  integer, intent(in) :: l
  integer ::  i, j

  M2colint_ct = 0

  do i = 1, 1
    do j = 1, 1
      M2colint_ct = M2colint_ct + real(conjg(M(i))*K2(i+1*l,j)*Mct(j))
    end do
  end do

end subroutine colint_ct

! **********************************************************************
subroutine colint_IR(M, M2IRadd)
! M(i)   = <M|Ci> colour component of matrix element
! K1(i,j) = .....
! **********************************************************************
  use ol_colourmatrix_ppzzj2loop_ddxzzg_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(1)
  real(REALKIND),    intent(out) :: M2IRadd(16)
  integer ::  i, j, k, colmatpos

  M2IRadd = 0

  do k = 1, 17-1
    colmatpos = 1*k
    do i = 1, 1
      do j = 1, 1
        M2IRadd(k) = M2IRadd(k) + real(conjg(M(i))*K1(i+colmatpos,j)*M(j))
      end do
    end do
  end do

end subroutine colint_IR

! **********************************************************************
subroutine colintmunu(M1, M2, M2colint)
! M1(i)    = <M1|Ci> colour component of matrix element
! M2(i)    = <M2|Ci> colour component of matrix element
! M2colint = <M1|M2>
!          = Sum_{i,j} <M1|Ci> * <Ci|Cj> * <Cj|M2>
!          = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppzzj2loop_ddxzzg_1_/**/REALKIND, only: K2
  implicit none

  complex(REALKIND), intent(in)  :: M1(1)
  complex(REALKIND), intent(in)  :: M2(1)
  complex(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

  do i = 1, 1
    do j = 1, 1
      M2colint = M2colint + M1(i)*K2(i,j)*conjg(M2(j))
    end do
  end do

end subroutine colintmunu

#if 0 > 0
! **********************************************************************
subroutine colborninterf(M, M0_col, l)
! M(i)         = <M|Ci> colour component of matrix element
! M0_col(i)    = <M2|Ci> colour component of matrix element,
!                see \tilde{M}_{j} in Fabios thesis
! M2colint = Sum_{i} <M1|Ci> * <Ci|Cj>
!          = colour-summed squared matrix element
! KL(i,j) = <Ci|Cj> with elements Cj of 1-loop colour basis
! **********************************************************************
  use ol_colourmatrix_ppzzj2loop_ddxzzg_1_/**/REALKIND, only: KL
  implicit none

  type(Hpolcont), intent(in)  :: M(1)
  type(Hpolcont), intent(out)  :: M0_col(1)
  integer, intent(in) :: l
  integer :: i, j

  do j = 1, 1 !size(KL(1,:))
    M0_col(j)%j = 0
    M0_col(j)%hf = M(1)%hf
    do i = 1, 1 !size(KL(:,1))
      M0_col(j)%j = M0_col(j)%j  + conjg(M(i)%j)*KL(i+1*l,j)
    end do
  end do

end subroutine colborninterf
#endif

end subroutine amp2


! **********************************************************************
#ifdef PRECISION_dp
subroutine hsfamp2(P_scatt, M02, pind_1, pind_2, M2hsf)
#else
subroutine hsfamp2(P_scatt, M02, pind_1, pind_2, M2hsf)
  use ol_loop_storage_ppzzj2loop_ddxzzg_1_/**/DREALKIND, only: &
    & nhflip, helflip, hflip, tsb, pi_flip_bak, pj_flip_bak, nhel
#endif
! M2tree = helicity-summed squared tree matrix element for down anti-down Z Z glue -> 0
! M2hsf  = formula (66) of 1011.3918. Tree level
! spin-correlated hard scattering factor for down anti-down Z Z glue -> 0
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND
  implicit none
  real(DREALKIND), intent(in) :: P_scatt(0:3,5)
  integer, intent(in) :: pind_1, pind_2
  real(REALKIND), intent(out) :: M02, M2hsf
  real(REALKIND)    :: M2add, M2ct_dummy
  integer :: k

  M2add = 0
  M2hsf = 0

  call amp2(P_scatt, M02, .false., M2ct=M2ct_dummy)
  if((pi_flip_bak .ne. pind_1) .or. (pj_flip_bak .ne. pind_2)) then
    call init_flipped_heltables(pind_1,pind_2)
    pi_flip_bak = pind_1
    pj_flip_bak = pind_2
  end if

  do k = 1, nhflip
    call colintHSF(M1helarray(:,helflip(1,k))%j, M1helarray(:,helflip(2,k))%j, M2add)
    M2hsf = M2hsf + M2add
  end do

  contains

subroutine assign_helicity_flip(ext_wf_hf,ext_wf_t,m)
  use ol_debug, only: ol_fatal
  use KIND_TYPES, only: intkind2
  implicit none
  integer(intkind2), intent(in) :: ext_wf_hf(:), ext_wf_t
  integer, intent(in) :: m
  if(.not. allocated(hflip)) allocate(hflip(size(ext_wf_hf),2))
  if(size(ext_wf_hf) == size(hflip,1)) then
    hflip(:,m) = ext_wf_hf
    tsb = tsb + ext_wf_t
  else
    call ol_fatal("Spin-correlated HSF for ppzzj2loop_ddxzzg_1:" &
      & // "trying to flip particles with different number of helicity states")
  end if
end subroutine assign_helicity_flip

subroutine init_flipped_heltables(i,j)
  use KIND_TYPES, only: intkind2
  use ol_external_ppzzj2loop_ddxzzg_1, only: &
    & external_perm_inv_ppzzj2loop_ddxzzg_1
  use ol_h_helicity_bookkeeping_/**/REALKIND, only: &
    & helicity_flip_ij
  implicit none
  integer, intent(in) :: i, j
  integer :: r, k, l=0
  tsb = 0

  if(allocated(hflip)) deallocate(hflip)

  do k = 1, 5
    r = external_perm_inv_ppzzj2loop_ddxzzg_1(k)
    if(r == i .or. r == j) then
      l = l+1
      select case(k)
        case(1)
          call assign_helicity_flip(ex1(:)%hf,ex1(1)%t,l)
        case(2)
          call assign_helicity_flip(ex2(:)%hf,ex2(1)%t,l)
        case(3)
          call assign_helicity_flip(ex3(:)%hf,ex3(1)%t,l)
        case(4)
          call assign_helicity_flip(ex4(:)%hf,ex4(1)%t,l)
        case(5)
          call assign_helicity_flip(ex5(:)%hf,ex5(1)%t,l)
      end select
    end if
  end do
  call helicity_flip_ij(72,nhel, M1helarray(1,:)%hf, hflip, tsb, &
      & nhflip, helflip)

end subroutine init_flipped_heltables

! **********************************************************************
subroutine colintHSF(M, Mflip, Mhfcolint)
! **********************************************************************
  use ol_colourmatrix_ppzzj2loop_ddxzzg_1_/**/REALKIND, only: K1
  implicit none
  complex(REALKIND), intent(in)  :: M(1), Mflip(1)
  real(REALKIND),    intent(out) :: Mhfcolint
  integer :: i, j
  MHfcolint = 0
  do i = 1, 1
    do j = 1, 1
      Mhfcolint = Mhfcolint + real(conjg(Mflip(i))*K1(i,j)*M(j))
    end do
  end do

end subroutine colintHSF

end subroutine hsfamp2

end module ol_loop_ppzzj2loop_ddxzzg_1_/**/REALKIND
