module ol_external_ppzzj2loop_bbxzzg_1
! 
  implicit none
  integer :: dummy_counter
  ! Permutation and inverse permutation of external particles
  integer, save :: external_perm_ppzzj2loop_bbxzzg_1(5) = &
                     [ (dummy_counter, dummy_counter = 1, 5) ]
  integer, save :: external_perm_inv_ppzzj2loop_bbxzzg_1(5) = &
                     [ (dummy_counter, dummy_counter = 1, 5) ]
  integer, save :: extcomb_perm_ppzzj2loop_bbxzzg_1(0:16) = &
                     [ (dummy_counter, dummy_counter = 0, 16) ]
  ! Particle types (mapping of fields to integers is not fixed!)
  integer, save :: particle_types_ppzzj2loop_bbxzzg_1(5) = &
                     [ 1, 2, 3, 3, 4 ]
  ! Colour and helicity average factors per particle
  integer, save :: average_factors_ppzzj2loop_bbxzzg_1(5) = &
                     [ 6, 6, 3, 3, 16 ]
  ! Average factor; initialised to the identity permutation
  integer, save :: average_factor_ppzzj2loop_bbxzzg_1 = &
                     72
  integer, save :: channel_number_ppzzj2loop_bbxzzg_1 = -1
  ! external particle helicities
  logical, save :: hel_not_initialised = .true.
  integer, save :: H(5,72) ! H(i,la) = helicity of particle i in configuration la
  integer, save :: H_HC(72,5)
  integer, save :: POLSEL(5) = 0
  integer, save :: photonid_ppzzj2loop_bbxzzg_1(5) = 0

  
  contains

  subroutine n_external(n) &
      & bind(c,name="ol_f_n_external_ppzzj2loop_bbxzzg_1")
    ! Return the number of external particles
    implicit none
    integer, intent(out) :: n
    n = 5
  end subroutine n_external


  subroutine n_external_c(n) &
      & bind(c,name="ol_n_external_ppzzj2loop_bbxzzg_1")
    use, intrinsic :: iso_c_binding, only: c_int
    implicit none
    integer(c_int) :: n
    n = 5
  end subroutine n_external_c

  subroutine averagefactor_c(avgf) &
      & bind(c,name="ol_averagefactor_ppzzj2loop_bbxzzg_1")
    use KIND_TYPES, only: DREALKIND
    implicit none
    real(DREALKIND), intent(out) :: avgf
    avgf = average_factor_ppzzj2loop_bbxzzg_1
  end subroutine averagefactor_c

  subroutine set_permutation(perm) &
      & bind(c,name="ol_f_set_permutation_ppzzj2loop_bbxzzg_1")
    use ol_parameters_decl_/**/DREALKIND, only: out_symmetry_on
    use ol_external_decl_/**/DREALKIND, only: n_scatt
    use ol_generic, only: factorial
    implicit none
    integer, intent(in) :: perm(5)
    integer :: i, j, ii, jj
    integer :: particle_types_perm_ppzzj2loop_bbxzzg_1(5)
    external_perm_ppzzj2loop_bbxzzg_1 = perm
    do i = 1, 5
      external_perm_inv_ppzzj2loop_bbxzzg_1( &
        external_perm_ppzzj2loop_bbxzzg_1(i)) = i
      particle_types_perm_ppzzj2loop_bbxzzg_1(i) = &
        particle_types_ppzzj2loop_bbxzzg_1( &
        external_perm_ppzzj2loop_bbxzzg_1(i))
    end do
    do i = 1, 5
      do j = 1, i
        if (external_perm_ppzzj2loop_bbxzzg_1(i) >= &
          external_perm_ppzzj2loop_bbxzzg_1(j)) then
          ii = external_perm_ppzzj2loop_bbxzzg_1(i)
          jj = external_perm_ppzzj2loop_bbxzzg_1(j)
        else
          ii = external_perm_ppzzj2loop_bbxzzg_1(j)
          jj = external_perm_ppzzj2loop_bbxzzg_1(i)
        end if
        extcomb_perm_ppzzj2loop_bbxzzg_1((i*(i-1))/2 + j) = (ii*(ii-1))/2 + jj
      end do
    end do
    ! Colour and helicity average factor
    average_factor_ppzzj2loop_bbxzzg_1 = 1
    do i = 1, n_scatt
      average_factor_ppzzj2loop_bbxzzg_1 = &
        average_factor_ppzzj2loop_bbxzzg_1 &
        * average_factors_ppzzj2loop_bbxzzg_1( &
        external_perm_ppzzj2loop_bbxzzg_1(i))
    end do
    ! Symmetry factor for outgoing particles
    if (out_symmetry_on /= 0) then
      do i = 1, 5
        average_factor_ppzzj2loop_bbxzzg_1 = &
          average_factor_ppzzj2loop_bbxzzg_1 &
          * factorial(count(particle_types_perm_ppzzj2loop_bbxzzg_1(n_scatt+1:5) == i))
      end do
    end if
  end subroutine set_permutation


  subroutine set_permutation_c(perm) &
      & bind(c,name="ol_set_permutation_ppzzj2loop_bbxzzg_1")
    use, intrinsic :: iso_c_binding, only: c_int
    implicit none
    integer(c_int), intent(in) :: perm(5)
    integer :: f_perm(5)
    f_perm = perm
    call set_permutation(f_perm)
  end subroutine set_permutation_c


  subroutine get_last_perm(perm) &
      & bind(c,name="ol_f_get_last_perm_ppzzj2loop_bbxzzg_1")
    integer, intent(out) :: perm(5)
    perm = external_perm_ppzzj2loop_bbxzzg_1
  end subroutine get_last_perm


  subroutine get_masses(m_ex) &
      & bind(c,name="ol_f_get_masses_ppzzj2loop_bbxzzg_1")
    ! Return the masses of the external particles in the current permutation.
    use KIND_TYPES, only: DREALKIND
    use ol_parameters_decl_/**/DREALKIND
    implicit none
    real(DREALKIND), intent(out) :: m_ex(5)
    integer        :: i
    real(DREALKIND) :: m_ex_orig(5)
    ! External particle masses for in the identity permutation
    m_ex_orig = [ rMB_unscaled, rMB_unscaled, rMZ_unscaled, rMZ_unscaled, rZERO ]
    do i = 1, 5
      m_ex(i) = m_ex_orig(external_perm_ppzzj2loop_bbxzzg_1(i))
    end do
  end subroutine get_masses


  subroutine get_masses_c(m_ex) &
      & bind(c,name="ol_get_masses_ppzzj2loop_bbxzzg_1")
    use KIND_TYPES, only: DREALKIND
    use, intrinsic :: iso_c_binding, only: c_double
    implicit none
    real(c_double), intent(out) :: m_ex(5)
    real(DREALKIND) :: f_m_ex(5)
    call get_masses(f_m_ex)
    m_ex = f_m_ex
  end subroutine get_masses_c


  subroutine get_types(t_ex) &
      & bind(c,name="ol_f_get_types_ppzzj2loop_bbxzzg_1")
    ! Return the type of the external particles in the current permutation.
    use ol_parameters_decl_/**/DREALKIND
    implicit none
    integer, intent(out) :: t_ex(5)
    integer        :: i
    integer :: t_ex_orig(5)
    ! External particle masses for in the identity permutation
    t_ex_orig = [2,2,0,0,1]
    do i = 1, 5
      t_ex(i) = t_ex_orig(external_perm_ppzzj2loop_bbxzzg_1(i))
    end do
  end subroutine get_types


  subroutine get_types_c(t_ex) &
      & bind(c,name="ol_get_types_ppzzj2loop_bbxzzg_1")
    use, intrinsic :: iso_c_binding, only: c_int
    use, intrinsic :: iso_c_binding, only: c_double
    implicit none
    integer(c_int), intent(out) :: t_ex(5)
    integer :: f_t_ex(5)
    call get_types(f_t_ex)
    t_ex = f_t_ex
  end subroutine get_types_c


  subroutine get_charges(c_ex) &
      & bind(c,name="ol_f_get_charges_ppzzj2loop_bbxzzg_1")
    ! Return the type of the external particles in the current permutation.
    use KIND_TYPES, only: DREALKIND
    use ol_parameters_decl_/**/DREALKIND
    implicit none
    real(DREALKIND), intent(out) :: c_ex(5)
    integer        :: i
    real(DREALKIND) :: c_ex_orig(5)
    ! External particle masses for in the identity permutation
    c_ex_orig = [-1,1,0,0,0]/3._/**/REALKIND
    do i = 1, 5
      c_ex(i) = c_ex_orig(external_perm_ppzzj2loop_bbxzzg_1(i))
    end do
  end subroutine get_charges


  subroutine get_charges_c(c_ex) &
      & bind(c,name="ol_get_charge_ppzzj2loop_bbxzzg_1")
    use KIND_TYPES, only: DREALKIND
    use, intrinsic :: iso_c_binding, only: c_double
    implicit none
    real(c_double), intent(out) :: c_ex(5)
    real(DREALKIND) :: f_c_ex(5)
    call get_charges(f_c_ex)
    c_ex = f_c_ex
  end subroutine get_charges_c



  subroutine rambo(sqrt_s, p_rambo) &
      & bind(c,name="ol_f_rambo_ppzzj2loop_bbxzzg_1")
    use KIND_TYPES, only: DREALKIND
    use ol_kinematics_/**/DREALKIND, only: rambo_generic => rambo
    implicit none
    real(DREALKIND), intent(in) :: sqrt_s
    real(DREALKIND), intent(out) :: p_rambo(0:3,5)
    real(DREALKIND) :: m_ex(5)
    call get_masses(m_ex)
    call rambo_generic(sqrt_s, m_ex, p_rambo)
  end subroutine rambo


  subroutine rambo_c(sqrt_s, p_rambo) &
      & bind(c,name="ol_rambo_ppzzj2loop_bbxzzg_1")
    use KIND_TYPES, only: DREALKIND
    use, intrinsic :: iso_c_binding, only: c_double
    implicit none
    real(c_double), intent(in) :: sqrt_s
    real(c_double), intent(out) :: p_rambo(0:3,5)
    real(DREALKIND) :: f_sqrt_s
    real(DREALKIND) :: f_p_rambo(0:3,5)
    f_sqrt_s = sqrt_s
    call rambo(f_sqrt_s, f_p_rambo)
    p_rambo = f_p_rambo
  end subroutine rambo_c


  subroutine hel_init
    implicit none
    integer :: binpos, flip, binco
    hel_not_initialised = .false.
    ! helicity configurations for this process
  H(:, 1) = [ -1, -1, -1, -1, -1 ]
  H(:, 2) = [ -1, -1, -1, -1,  1 ]
  H(:, 3) = [ -1, -1, -1,  0, -1 ]
  H(:, 4) = [ -1, -1, -1,  0,  1 ]
  H(:, 5) = [ -1, -1, -1,  1, -1 ]
  H(:, 6) = [ -1, -1, -1,  1,  1 ]
  H(:, 7) = [ -1, -1,  0, -1, -1 ]
  H(:, 8) = [ -1, -1,  0, -1,  1 ]
  H(:, 9) = [ -1, -1,  0,  0, -1 ]
  H(:,10) = [ -1, -1,  0,  0,  1 ]
  H(:,11) = [ -1, -1,  0,  1, -1 ]
  H(:,12) = [ -1, -1,  0,  1,  1 ]
  H(:,13) = [ -1, -1,  1, -1, -1 ]
  H(:,14) = [ -1, -1,  1, -1,  1 ]
  H(:,15) = [ -1, -1,  1,  0, -1 ]
  H(:,16) = [ -1, -1,  1,  0,  1 ]
  H(:,17) = [ -1, -1,  1,  1, -1 ]
  H(:,18) = [ -1, -1,  1,  1,  1 ]
  H(:,19) = [ -1,  1, -1, -1, -1 ]
  H(:,20) = [ -1,  1, -1, -1,  1 ]
  H(:,21) = [ -1,  1, -1,  0, -1 ]
  H(:,22) = [ -1,  1, -1,  0,  1 ]
  H(:,23) = [ -1,  1, -1,  1, -1 ]
  H(:,24) = [ -1,  1, -1,  1,  1 ]
  H(:,25) = [ -1,  1,  0, -1, -1 ]
  H(:,26) = [ -1,  1,  0, -1,  1 ]
  H(:,27) = [ -1,  1,  0,  0, -1 ]
  H(:,28) = [ -1,  1,  0,  0,  1 ]
  H(:,29) = [ -1,  1,  0,  1, -1 ]
  H(:,30) = [ -1,  1,  0,  1,  1 ]
  H(:,31) = [ -1,  1,  1, -1, -1 ]
  H(:,32) = [ -1,  1,  1, -1,  1 ]
  H(:,33) = [ -1,  1,  1,  0, -1 ]
  H(:,34) = [ -1,  1,  1,  0,  1 ]
  H(:,35) = [ -1,  1,  1,  1, -1 ]
  H(:,36) = [ -1,  1,  1,  1,  1 ]
  H(:,37) = [  1, -1, -1, -1, -1 ]
  H(:,38) = [  1, -1, -1, -1,  1 ]
  H(:,39) = [  1, -1, -1,  0, -1 ]
  H(:,40) = [  1, -1, -1,  0,  1 ]
  H(:,41) = [  1, -1, -1,  1, -1 ]
  H(:,42) = [  1, -1, -1,  1,  1 ]
  H(:,43) = [  1, -1,  0, -1, -1 ]
  H(:,44) = [  1, -1,  0, -1,  1 ]
  H(:,45) = [  1, -1,  0,  0, -1 ]
  H(:,46) = [  1, -1,  0,  0,  1 ]
  H(:,47) = [  1, -1,  0,  1, -1 ]
  H(:,48) = [  1, -1,  0,  1,  1 ]
  H(:,49) = [  1, -1,  1, -1, -1 ]
  H(:,50) = [  1, -1,  1, -1,  1 ]
  H(:,51) = [  1, -1,  1,  0, -1 ]
  H(:,52) = [  1, -1,  1,  0,  1 ]
  H(:,53) = [  1, -1,  1,  1, -1 ]
  H(:,54) = [  1, -1,  1,  1,  1 ]
  H(:,55) = [  1,  1, -1, -1, -1 ]
  H(:,56) = [  1,  1, -1, -1,  1 ]
  H(:,57) = [  1,  1, -1,  0, -1 ]
  H(:,58) = [  1,  1, -1,  0,  1 ]
  H(:,59) = [  1,  1, -1,  1, -1 ]
  H(:,60) = [  1,  1, -1,  1,  1 ]
  H(:,61) = [  1,  1,  0, -1, -1 ]
  H(:,62) = [  1,  1,  0, -1,  1 ]
  H(:,63) = [  1,  1,  0,  0, -1 ]
  H(:,64) = [  1,  1,  0,  0,  1 ]
  H(:,65) = [  1,  1,  0,  1, -1 ]
  H(:,66) = [  1,  1,  0,  1,  1 ]
  H(:,67) = [  1,  1,  1, -1, -1 ]
  H(:,68) = [  1,  1,  1, -1,  1 ]
  H(:,69) = [  1,  1,  1,  0, -1 ]
  H(:,70) = [  1,  1,  1,  0,  1 ]
  H(:,71) = [  1,  1,  1,  1, -1 ]
  H(:,72) = [  1,  1,  1,  1,  1 ]

  H_HC(:,5) = [ ((((2*(binco-1)+flip)*1+binpos, flip = 0, 1), binpos = 1, 1), binco = 1, 72/1/2) ]
  end subroutine hel_init


  subroutine pol_init(pol) &
      & bind(c,name="ol_f_pol_init_ppzzj2loop_bbxzzg_1")
    implicit none
    integer, intent(in) :: pol(5)
    POLSEL = pol
  end subroutine pol_init


  subroutine set_photons(photon_id) &
      & bind(c,name="ol_f_set_photons_ppzzj2loop_bbxzzg_1")
    implicit none
    integer, intent(in) :: photon_id(5)
    photonid_ppzzj2loop_bbxzzg_1 = photon_id
  end subroutine set_photons




end module ol_external_ppzzj2loop_bbxzzg_1


module ol_settings_ppzzj2loop_bbxzzg_1
  implicit none
  ! Activates optimized helicity bookkeeping. Default=false
    logical, save :: hel_mem_opt = .false.
  ! Calculate loop correlators
    logical, save :: loopcc = .false.

  contains

  subroutine set_hel_mem_opt(set) &
      & bind(c,name="ol_hel_mem_opt_ppzzj2loop_bbxzzg_1")
    implicit none
    logical, intent(in) :: set
    hel_mem_opt = set
  end subroutine set_hel_mem_opt

  subroutine set_loopcc(set,was) &
      & bind(c,name="ol_loopcc_ppzzj2loop_bbxzzg_1")
    implicit none
    logical, intent(in) :: set
    logical :: was
    was = loopcc
    loopcc = set
  end subroutine set_loopcc

end module ol_settings_ppzzj2loop_bbxzzg_1

module colour_basis_ppzzj2loop_bbxzzg_1
  implicit none
  ! tree colour basis
  integer, save :: extcolours(5) = [1,1,0,0,2]
  contains

  pure subroutine tree_colbasis_dim(extcols, ncolb, ncoupl, maxpows, nhel) &
    & bind(c, name="ol_tree_colbasis_dim_ppzzj2loop_bbxzzg_1")
    implicit none
    ! colour representation of external particles: 0=neutral, 1=fundamental, 2=adjoint
    integer, intent(out) :: extcols(5)
    ! number of tree colour basis elements; number of selected couplings, number of selected powers per coupling
    integer, intent(out) :: ncolb, ncoupl, maxpows
    ! number of helicity configurations (all, not just non-vanishing)
    integer, intent(out) :: nhel
    extcols = extcolours
    ncolb = 1
    ncoupl = 1
    maxpows = 1
    nhel = 72
  end subroutine tree_colbasis_dim

  subroutine tree_colbasis(basis, powers) &
    & bind(c, name="ol_tree_colbasis_ppzzj2loop_bbxzzg_1")
    implicit none
    integer, intent(out) :: powers(1,1)
    integer, intent(out) :: basis(3,1)
#if 1 > 0
    ! selected powers for each selected coupling
    powers = reshape([2], [1,1])
#endif
#if 1 > 0
    ! tree colour basis: [[composition_number, permutation_number, *coupling_powers], ...]
    basis = reshape( &
      [1,6,1], &
      [3,1])
#endif
  end subroutine tree_colbasis


  pure subroutine loop_colbasis_dim(extcols, ncolb, ncoupl, maxpows, nhel) &
    & bind(c, name="ol_loop_colbasis_dim_ppzzj2loop_bbxzzg_1")
    implicit none
    ! colour representation of external particles: 0=neutral, 1=fundamental, 2=adjoint
    integer, intent(out) :: extcols(5)
    ! number of loop colour basis elements; number of selected couplings, number of selected powers per coupling
    integer, intent(out) :: ncolb, ncoupl, maxpows
    ! number of helicity configurations (all, not just non-vanishing)
    integer, intent(out) :: nhel
    extcols = extcolours
    ncolb = 1
    ncoupl = 1
    maxpows = 1
    nhel = 72
  end subroutine loop_colbasis_dim

  subroutine loop_colbasis(basis, powers) &
    & bind(c, name="ol_loop_colbasis_ppzzj2loop_bbxzzg_1")
    implicit none
    integer, intent(out) :: powers(1,1)
    integer, intent(out) :: basis(3,1)
#if 1 > 0
    ! selected powers for each selected coupling
    powers = reshape([2], [1,1])
#endif
#if 1 > 0
    basis = 0 ! TODO
    ! loop colour basis: [[composition_number, permutation_number, *coupling_powers], ...]
!    basis = reshape( &
!<\*colourbasis\*>, &
!      [3,1])
#endif
  end subroutine loop_colbasis


end module colour_basis_ppzzj2loop_bbxzzg_1

! **********************************************************************
module ol_heltables_OLR_ppzzj2loop_bbxzzg_1
! **********************************************************************
  use KIND_TYPES, only: intkind2
  implicit none

  logical :: heltables_not_init = .true.

  ! helicity states of external particles
  ! integer, save :: &
  !   H1(2) = [-1,1], &
  !   H2(3) = [-1,0,1]
  !   ...
  integer, save :: &
    H1(2) = [-1,1], &
    H2(2) = [-1,1], &
    H3(3) = [-1,0,1], &
    H4(3) = [-1,0,1], &
    H5(2) = [-1,1]

  ! number of helicity states for wave functions returned by a propagator call: n2(sz)
  ! number of helicity states for wave functions in a v-point vertex call (v >= 3)
  ! or a contraction (v = 3): n<v>(v,sz)
  integer(intkind2), save :: n2(385), n3(3,6642)

  ! helicity tables used in the construction of the h helicity states of a wave function (amplitude)
  ! from an v-point vertex (contraction): t<v>x<h>(v-1,h,sz)
  integer(intkind2), save :: t3x36(2,36,42), t3x9(2,9,86), t3x4(2,4,92), t3x8(2,8,110), t3x24(2,24,136), t3x12(2,12,144), &
    t3x6(2,6,368), t3x18(2,18,378), t3x72(2,72,5286)

  ! change of global-helicity state resulting from flip of individual-particle helicity
  integer(intkind2), save :: eflip(72,5)
  integer,           save :: exthel(72,5)
  integer,           save :: firstpol(5)

  contains

! **********************************************************************
subroutine init_heltables
! **********************************************************************
  use ol_helicity_init, only: heltable
  implicit none

  ! I/O helicity tables for vertices, propagators and contractions;
  ! helicity table for a vertex call: n_in/n_out are the number helicity states of the incoming/outgoing wave functions
  ! call heltable([<n_in1>, <n_in2>, ..., <n_out>], n, t)
  ! propagators only need the number of helicity configurations which is equal for the incoming and outgoing wave function
  ! n = <n>
  call heltable([3,2,6], n3(:,1), t3x6(:,:,1))
  call heltable([2,3,6], n3(:,2), t3x6(:,:,2))
  n2(1) = 6
  n2(2) = 6
  call heltable([2,6,12], n3(:,3), t3x12(:,:,1))
  call heltable([2,2,4], n3(:,4), t3x4(:,:,1))
  n2(3) = 4
  call heltable([3,6,18], n3(:,5), t3x18(:,:,1))
  call heltable([3,2,6], n3(:,6), t3x6(:,:,3))
  call heltable([2,3,6], n3(:,7), t3x6(:,:,4))
  n2(4) = 6
  n2(5) = 6
  call heltable([2,6,12], n3(:,8), t3x12(:,:,2))
  call heltable([2,2,4], n3(:,9), t3x4(:,:,2))
  n2(6) = 4
  call heltable([3,4,12], n3(:,10), t3x12(:,:,3))
  call heltable([3,6,18], n3(:,11), t3x18(:,:,2))
  call heltable([3,4,12], n3(:,12), t3x12(:,:,4))
  call heltable([3,3,9], n3(:,13), t3x9(:,:,1))
  call heltable([2,4,8], n3(:,14), t3x8(:,:,1))
  call heltable([4,2,8], n3(:,15), t3x8(:,:,2))
  n2(7) = 2
  n2(8) = 2
  n2(9) = 12
  call heltable([2,3,6], n3(:,16), t3x6(:,:,5))
  n2(10) = 18
  call heltable([2,2,4], n3(:,17), t3x4(:,:,3))
  n2(11) = 12
  call heltable([2,3,6], n3(:,18), t3x6(:,:,6))
  n2(12) = 18
  call heltable([4,9,36], n3(:,19), t3x36(:,:,1))
  call heltable([2,9,18], n3(:,20), t3x18(:,:,3))
  n2(13) = 18
  n2(14) = 12
  n2(15) = 12
  n2(16) = 2
  call heltable([6,2,12], n3(:,21), t3x12(:,:,5))
  n2(17) = 2
  n2(18) = 12
  call heltable([3,2,6], n3(:,22), t3x6(:,:,7))
  call heltable([6,3,18], n3(:,23), t3x18(:,:,4))
  n2(19) = 18
  call heltable([2,2,4], n3(:,24), t3x4(:,:,4))
  call heltable([6,2,12], n3(:,25), t3x12(:,:,6))
  n2(20) = 12
  call heltable([3,2,6], n3(:,26), t3x6(:,:,8))
  call heltable([6,3,18], n3(:,27), t3x18(:,:,5))
  n2(21) = 18
  call heltable([9,4,36], n3(:,28), t3x36(:,:,2))
  call heltable([9,2,18], n3(:,29), t3x18(:,:,6))
  n2(22) = 18
  call heltable([4,3,12], n3(:,30), t3x12(:,:,7))
  n2(23) = 12
  call heltable([4,3,12], n3(:,31), t3x12(:,:,8))
  n2(24) = 12
  n2(25) = 2
  n2(26) = 2
  call heltable([2,3,6], n3(:,32), t3x6(:,:,9))
  n2(27) = 2
  n2(28) = 2
  call heltable([2,3,6], n3(:,33), t3x6(:,:,10))
  call heltable([2,2,4], n3(:,34), t3x4(:,:,5))
  call heltable([2,2,4], n3(:,35), t3x4(:,:,6))
  call heltable([2,3,6], n3(:,36), t3x6(:,:,11))
  call heltable([2,3,6], n3(:,37), t3x6(:,:,12))
  n2(29) = 2
  n2(30) = 2
  call heltable([3,2,6], n3(:,38), t3x6(:,:,13))
  n2(31) = 2
  n2(32) = 2
  call heltable([3,2,6], n3(:,39), t3x6(:,:,14))
  call heltable([2,2,4], n3(:,40), t3x4(:,:,7))
  call heltable([2,2,4], n3(:,41), t3x4(:,:,8))
  call heltable([3,2,6], n3(:,42), t3x6(:,:,15))
  call heltable([3,2,6], n3(:,43), t3x6(:,:,16))
  n2(33) = 3
  call heltable([6,4,24], n3(:,44), t3x24(:,:,1))
  n2(34) = 3
  n2(35) = 3
  n2(36) = 3
  call heltable([6,4,24], n3(:,45), t3x24(:,:,2))
  call heltable([2,3,6], n3(:,46), t3x6(:,:,17))
  call heltable([2,3,6], n3(:,47), t3x6(:,:,18))
  call heltable([2,3,6], n3(:,48), t3x6(:,:,19))
  call heltable([2,3,6], n3(:,49), t3x6(:,:,20))
  call heltable([4,6,24], n3(:,50), t3x24(:,:,3))
  call heltable([4,6,24], n3(:,51), t3x24(:,:,4))
  call heltable([3,2,6], n3(:,52), t3x6(:,:,21))
  call heltable([3,2,6], n3(:,53), t3x6(:,:,22))
  call heltable([3,2,6], n3(:,54), t3x6(:,:,23))
  call heltable([3,2,6], n3(:,55), t3x6(:,:,24))
  call heltable([3,3,9], n3(:,56), t3x9(:,:,2))
  call heltable([3,3,9], n3(:,57), t3x9(:,:,3))
  n2(37) = 3
  call heltable([6,4,24], n3(:,58), t3x24(:,:,5))
  n2(38) = 3
  n2(39) = 3
  n2(40) = 3
  call heltable([6,4,24], n3(:,59), t3x24(:,:,6))
  call heltable([2,3,6], n3(:,60), t3x6(:,:,25))
  call heltable([2,3,6], n3(:,61), t3x6(:,:,26))
  call heltable([2,3,6], n3(:,62), t3x6(:,:,27))
  call heltable([2,3,6], n3(:,63), t3x6(:,:,28))
  call heltable([4,6,24], n3(:,64), t3x24(:,:,7))
  call heltable([4,6,24], n3(:,65), t3x24(:,:,8))
  call heltable([3,2,6], n3(:,66), t3x6(:,:,29))
  call heltable([3,2,6], n3(:,67), t3x6(:,:,30))
  call heltable([3,2,6], n3(:,68), t3x6(:,:,31))
  call heltable([3,2,6], n3(:,69), t3x6(:,:,32))
  call heltable([3,3,9], n3(:,70), t3x9(:,:,4))
  call heltable([3,3,9], n3(:,71), t3x9(:,:,5))
  n2(41) = 2
  n2(42) = 2
  call heltable([2,3,6], n3(:,72), t3x6(:,:,33))
  call heltable([2,2,4], n3(:,73), t3x4(:,:,9))
  call heltable([2,3,6], n3(:,74), t3x6(:,:,34))
  n2(43) = 2
  n2(44) = 2
  call heltable([3,2,6], n3(:,75), t3x6(:,:,35))
  call heltable([2,2,4], n3(:,76), t3x4(:,:,10))
  call heltable([3,2,6], n3(:,77), t3x6(:,:,36))
  call heltable([2,2,4], n3(:,78), t3x4(:,:,11))
  call heltable([2,9,18], n3(:,79), t3x18(:,:,7))
  n2(45) = 4
  call heltable([2,2,4], n3(:,80), t3x4(:,:,12))
  call heltable([9,2,18], n3(:,81), t3x18(:,:,8))
  n2(46) = 4
  call heltable([2,3,6], n3(:,82), t3x6(:,:,37))
  call heltable([3,2,6], n3(:,83), t3x6(:,:,38))
  n2(47) = 6
  n2(48) = 6
  call heltable([6,2,12], n3(:,84), t3x12(:,:,9))
  call heltable([6,3,18], n3(:,85), t3x18(:,:,9))
  call heltable([3,2,6], n3(:,86), t3x6(:,:,39))
  call heltable([2,3,6], n3(:,87), t3x6(:,:,40))
  n2(49) = 6
  n2(50) = 6
  call heltable([2,6,12], n3(:,88), t3x12(:,:,10))
  call heltable([6,3,18], n3(:,89), t3x18(:,:,10))
  call heltable([3,6,18], n3(:,90), t3x18(:,:,11))
  call heltable([3,6,18], n3(:,91), t3x18(:,:,12))
  call heltable([2,2,4], n3(:,92), t3x4(:,:,13))
  call heltable([2,9,18], n3(:,93), t3x18(:,:,13))
  n2(51) = 4
  call heltable([2,2,4], n3(:,94), t3x4(:,:,14))
  call heltable([2,9,18], n3(:,95), t3x18(:,:,14))
  n2(52) = 4
  call heltable([2,2,4], n3(:,96), t3x4(:,:,15))
  call heltable([9,2,18], n3(:,97), t3x18(:,:,15))
  n2(53) = 4
  call heltable([2,2,4], n3(:,98), t3x4(:,:,16))
  call heltable([9,2,18], n3(:,99), t3x18(:,:,16))
  n2(54) = 4
  call heltable([2,3,6], n3(:,100), t3x6(:,:,41))
  call heltable([3,2,6], n3(:,101), t3x6(:,:,42))
  n2(55) = 6
  n2(56) = 6
  call heltable([6,2,12], n3(:,102), t3x12(:,:,11))
  call heltable([2,3,6], n3(:,103), t3x6(:,:,43))
  call heltable([3,2,6], n3(:,104), t3x6(:,:,44))
  n2(57) = 6
  n2(58) = 6
  call heltable([6,2,12], n3(:,105), t3x12(:,:,12))
  call heltable([6,3,18], n3(:,106), t3x18(:,:,17))
  call heltable([6,3,18], n3(:,107), t3x18(:,:,18))
  call heltable([3,2,6], n3(:,108), t3x6(:,:,45))
  call heltable([2,3,6], n3(:,109), t3x6(:,:,46))
  n2(59) = 6
  n2(60) = 6
  call heltable([2,6,12], n3(:,110), t3x12(:,:,13))
  call heltable([3,2,6], n3(:,111), t3x6(:,:,47))
  call heltable([2,3,6], n3(:,112), t3x6(:,:,48))
  n2(61) = 6
  n2(62) = 6
  call heltable([2,6,12], n3(:,113), t3x12(:,:,14))
  call heltable([6,3,18], n3(:,114), t3x18(:,:,19))
  call heltable([6,3,18], n3(:,115), t3x18(:,:,20))
  call heltable([3,6,18], n3(:,116), t3x18(:,:,21))
  call heltable([3,6,18], n3(:,117), t3x18(:,:,22))
  call heltable([3,6,18], n3(:,118), t3x18(:,:,23))
  call heltable([3,6,18], n3(:,119), t3x18(:,:,24))
  call heltable([3,3,9], n3(:,120), t3x9(:,:,6))
  call heltable([3,3,9], n3(:,121), t3x9(:,:,7))
  call heltable([4,2,8], n3(:,122), t3x8(:,:,3))
  call heltable([3,3,9], n3(:,123), t3x9(:,:,8))
  call heltable([3,3,9], n3(:,124), t3x9(:,:,9))
  call heltable([4,2,8], n3(:,125), t3x8(:,:,4))
  call heltable([2,4,8], n3(:,126), t3x8(:,:,5))
  call heltable([2,4,8], n3(:,127), t3x8(:,:,6))
  call heltable([2,2,4], n3(:,128), t3x4(:,:,17))
  call heltable([3,6,18], n3(:,129), t3x18(:,:,25))
  n2(63) = 4
  call heltable([2,3,6], n3(:,130), t3x6(:,:,49))
  call heltable([3,3,9], n3(:,131), t3x9(:,:,10))
  call heltable([2,4,8], n3(:,132), t3x8(:,:,7))
  call heltable([3,3,9], n3(:,133), t3x9(:,:,11))
  call heltable([4,2,8], n3(:,134), t3x8(:,:,8))
  call heltable([2,3,6], n3(:,135), t3x6(:,:,50))
  call heltable([3,4,12], n3(:,136), t3x12(:,:,15))
  n2(64) = 6
  call heltable([3,2,6], n3(:,137), t3x6(:,:,51))
  n2(65) = 6
  call heltable([2,6,12], n3(:,138), t3x12(:,:,16))
  call heltable([3,6,18], n3(:,139), t3x18(:,:,26))
  call heltable([2,9,18], n3(:,140), t3x18(:,:,27))
  call heltable([9,2,18], n3(:,141), t3x18(:,:,28))
  call heltable([3,6,18], n3(:,142), t3x18(:,:,29))
  call heltable([2,3,6], n3(:,143), t3x6(:,:,52))
  call heltable([3,3,9], n3(:,144), t3x9(:,:,12))
  call heltable([3,3,9], n3(:,145), t3x9(:,:,13))
  call heltable([2,3,6], n3(:,146), t3x6(:,:,53))
  call heltable([3,4,12], n3(:,147), t3x12(:,:,17))
  n2(66) = 6
  call heltable([3,2,6], n3(:,148), t3x6(:,:,54))
  n2(67) = 6
  call heltable([2,6,12], n3(:,149), t3x12(:,:,18))
  call heltable([3,6,18], n3(:,150), t3x18(:,:,30))
  call heltable([2,9,18], n3(:,151), t3x18(:,:,31))
  call heltable([9,2,18], n3(:,152), t3x18(:,:,32))
  call heltable([2,2,4], n3(:,153), t3x4(:,:,18))
  call heltable([6,3,18], n3(:,154), t3x18(:,:,33))
  n2(68) = 4
  call heltable([3,2,6], n3(:,155), t3x6(:,:,55))
  call heltable([3,3,9], n3(:,156), t3x9(:,:,14))
  call heltable([4,2,8], n3(:,157), t3x8(:,:,9))
  call heltable([3,3,9], n3(:,158), t3x9(:,:,15))
  call heltable([2,4,8], n3(:,159), t3x8(:,:,10))
  call heltable([3,2,6], n3(:,160), t3x6(:,:,56))
  call heltable([4,3,12], n3(:,161), t3x12(:,:,19))
  n2(69) = 6
  call heltable([2,3,6], n3(:,162), t3x6(:,:,57))
  n2(70) = 6
  call heltable([6,2,12], n3(:,163), t3x12(:,:,20))
  call heltable([6,3,18], n3(:,164), t3x18(:,:,34))
  call heltable([9,2,18], n3(:,165), t3x18(:,:,35))
  call heltable([2,9,18], n3(:,166), t3x18(:,:,36))
  call heltable([6,3,18], n3(:,167), t3x18(:,:,37))
  call heltable([3,2,6], n3(:,168), t3x6(:,:,58))
  call heltable([3,3,9], n3(:,169), t3x9(:,:,16))
  call heltable([3,3,9], n3(:,170), t3x9(:,:,17))
  call heltable([3,2,6], n3(:,171), t3x6(:,:,59))
  call heltable([4,3,12], n3(:,172), t3x12(:,:,21))
  n2(71) = 6
  call heltable([2,3,6], n3(:,173), t3x6(:,:,60))
  n2(72) = 6
  call heltable([6,2,12], n3(:,174), t3x12(:,:,22))
  call heltable([6,3,18], n3(:,175), t3x18(:,:,38))
  call heltable([9,2,18], n3(:,176), t3x18(:,:,39))
  call heltable([2,9,18], n3(:,177), t3x18(:,:,40))
  call heltable([2,9,18], n3(:,178), t3x18(:,:,41))
  call heltable([9,2,18], n3(:,179), t3x18(:,:,42))
  call heltable([6,2,12], n3(:,180), t3x12(:,:,23))
  call heltable([6,3,18], n3(:,181), t3x18(:,:,43))
  call heltable([2,6,12], n3(:,182), t3x12(:,:,24))
  call heltable([6,3,18], n3(:,183), t3x18(:,:,44))
  call heltable([3,6,18], n3(:,184), t3x18(:,:,45))
  call heltable([3,6,18], n3(:,185), t3x18(:,:,46))
  n2(73) = 4
  n2(74) = 6
  n2(75) = 6
  n2(76) = 6
  n2(77) = 4
  n2(78) = 6
  n2(79) = 9
  call heltable([2,6,12], n3(:,186), t3x12(:,:,25))
  call heltable([3,6,18], n3(:,187), t3x18(:,:,47))
  call heltable([2,6,12], n3(:,188), t3x12(:,:,26))
  call heltable([3,4,12], n3(:,189), t3x12(:,:,27))
  call heltable([3,6,18], n3(:,190), t3x18(:,:,48))
  call heltable([3,4,12], n3(:,191), t3x12(:,:,28))
  call heltable([3,3,9], n3(:,192), t3x9(:,:,18))
  call heltable([2,2,4], n3(:,193), t3x4(:,:,19))
  n2(80) = 4
  call heltable([2,3,6], n3(:,194), t3x6(:,:,61))
  n2(81) = 6
  call heltable([2,4,8], n3(:,195), t3x8(:,:,11))
  call heltable([4,2,8], n3(:,196), t3x8(:,:,12))
  call heltable([2,3,6], n3(:,197), t3x6(:,:,62))
  n2(82) = 6
  call heltable([2,2,4], n3(:,198), t3x4(:,:,20))
  n2(83) = 4
  call heltable([3,4,12], n3(:,199), t3x12(:,:,29))
  call heltable([3,2,6], n3(:,200), t3x6(:,:,63))
  n2(84) = 6
  call heltable([2,6,12], n3(:,201), t3x12(:,:,30))
  call heltable([3,4,12], n3(:,202), t3x12(:,:,31))
  call heltable([4,2,8], n3(:,203), t3x8(:,:,13))
  call heltable([2,4,8], n3(:,204), t3x8(:,:,14))
  call heltable([3,6,18], n3(:,205), t3x18(:,:,49))
  call heltable([3,2,6], n3(:,206), t3x6(:,:,64))
  n2(85) = 6
  call heltable([2,6,12], n3(:,207), t3x12(:,:,32))
  call heltable([3,6,18], n3(:,208), t3x18(:,:,50))
  call heltable([9,2,18], n3(:,209), t3x18(:,:,51))
  n2(86) = 4
  call heltable([2,9,18], n3(:,210), t3x18(:,:,52))
  n2(87) = 4
  n2(88) = 6
  n2(89) = 6
  call heltable([2,6,12], n3(:,211), t3x12(:,:,33))
  call heltable([3,6,18], n3(:,212), t3x18(:,:,53))
  n2(90) = 6
  n2(91) = 6
  call heltable([6,2,12], n3(:,213), t3x12(:,:,34))
  call heltable([3,6,18], n3(:,214), t3x18(:,:,54))
  call heltable([6,3,18], n3(:,215), t3x18(:,:,55))
  call heltable([6,3,18], n3(:,216), t3x18(:,:,56))
  call heltable([4,9,36], n3(:,217), t3x36(:,:,3))
  n2(92) = 2
  n2(93) = 18
  call heltable([2,18,36], n3(:,218), t3x36(:,:,4))
  call heltable([9,4,36], n3(:,219), t3x36(:,:,5))
  n2(94) = 2
  n2(95) = 18
  call heltable([18,2,36], n3(:,220), t3x36(:,:,6))
  n2(96) = 12
  call heltable([2,3,6], n3(:,221), t3x6(:,:,65))
  n2(97) = 18
  call heltable([2,2,4], n3(:,222), t3x4(:,:,21))
  call heltable([2,6,12], n3(:,223), t3x12(:,:,35))
  n2(98) = 12
  call heltable([2,3,6], n3(:,224), t3x6(:,:,66))
  n2(99) = 18
  call heltable([3,4,12], n3(:,225), t3x12(:,:,36))
  n2(100) = 12
  call heltable([3,4,12], n3(:,226), t3x12(:,:,37))
  n2(101) = 12
  n2(102) = 12
  call heltable([3,2,6], n3(:,227), t3x6(:,:,67))
  n2(103) = 18
  call heltable([2,2,4], n3(:,228), t3x4(:,:,22))
  call heltable([6,2,12], n3(:,229), t3x12(:,:,38))
  n2(104) = 12
  call heltable([3,2,6], n3(:,230), t3x6(:,:,68))
  n2(105) = 18
  call heltable([4,3,12], n3(:,231), t3x12(:,:,39))
  n2(106) = 12
  call heltable([4,3,12], n3(:,232), t3x12(:,:,40))
  n2(107) = 12
  call heltable([9,2,18], n3(:,233), t3x18(:,:,57))
  n2(108) = 4
  n2(109) = 2
  call heltable([2,2,4], n3(:,234), t3x4(:,:,23))
  n2(110) = 4
  n2(111) = 2
  call heltable([9,2,18], n3(:,235), t3x18(:,:,58))
  n2(112) = 2
  call heltable([2,2,4], n3(:,236), t3x4(:,:,24))
  n2(113) = 4
  n2(114) = 4
  n2(115) = 2
  call heltable([9,2,18], n3(:,237), t3x18(:,:,59))
  call heltable([9,2,18], n3(:,238), t3x18(:,:,60))
  call heltable([2,9,18], n3(:,239), t3x18(:,:,61))
  n2(116) = 4
  call heltable([2,9,18], n3(:,240), t3x18(:,:,62))
  call heltable([2,2,4], n3(:,241), t3x4(:,:,25))
  n2(117) = 4
  call heltable([2,9,18], n3(:,242), t3x18(:,:,63))
  call heltable([2,9,18], n3(:,243), t3x18(:,:,64))
  call heltable([2,2,4], n3(:,244), t3x4(:,:,26))
  n2(118) = 4
  n2(119) = 4
  n2(120) = 6
  n2(121) = 6
  call heltable([2,6,12], n3(:,245), t3x12(:,:,41))
  call heltable([3,2,6], n3(:,246), t3x6(:,:,69))
  n2(122) = 6
  call heltable([2,6,12], n3(:,247), t3x12(:,:,42))
  call heltable([2,3,6], n3(:,248), t3x6(:,:,70))
  n2(123) = 6
  call heltable([3,2,6], n3(:,249), t3x6(:,:,71))
  n2(124) = 6
  call heltable([2,6,12], n3(:,250), t3x12(:,:,43))
  n2(125) = 6
  call heltable([2,6,12], n3(:,251), t3x12(:,:,44))
  call heltable([2,3,6], n3(:,252), t3x6(:,:,72))
  n2(126) = 6
  n2(127) = 6
  call heltable([3,6,18], n3(:,253), t3x18(:,:,65))
  call heltable([3,6,18], n3(:,254), t3x18(:,:,66))
  call heltable([3,6,18], n3(:,255), t3x18(:,:,67))
  call heltable([3,6,18], n3(:,256), t3x18(:,:,68))
  n2(128) = 6
  n2(129) = 6
  call heltable([6,2,12], n3(:,257), t3x12(:,:,45))
  call heltable([3,2,6], n3(:,258), t3x6(:,:,73))
  n2(130) = 6
  call heltable([2,3,6], n3(:,259), t3x6(:,:,74))
  n2(131) = 6
  call heltable([6,2,12], n3(:,260), t3x12(:,:,46))
  call heltable([3,2,6], n3(:,261), t3x6(:,:,75))
  n2(132) = 6
  n2(133) = 6
  call heltable([2,3,6], n3(:,262), t3x6(:,:,76))
  n2(134) = 6
  call heltable([6,2,12], n3(:,263), t3x12(:,:,47))
  n2(135) = 6
  call heltable([6,2,12], n3(:,264), t3x12(:,:,48))
  call heltable([3,6,18], n3(:,265), t3x18(:,:,69))
  call heltable([3,6,18], n3(:,266), t3x18(:,:,70))
  call heltable([3,6,18], n3(:,267), t3x18(:,:,71))
  call heltable([3,6,18], n3(:,268), t3x18(:,:,72))
  call heltable([6,3,18], n3(:,269), t3x18(:,:,73))
  call heltable([6,3,18], n3(:,270), t3x18(:,:,74))
  call heltable([6,3,18], n3(:,271), t3x18(:,:,75))
  call heltable([6,3,18], n3(:,272), t3x18(:,:,76))
  call heltable([6,3,18], n3(:,273), t3x18(:,:,77))
  call heltable([6,3,18], n3(:,274), t3x18(:,:,78))
  call heltable([6,3,18], n3(:,275), t3x18(:,:,79))
  call heltable([6,3,18], n3(:,276), t3x18(:,:,80))
  call heltable([4,9,36], n3(:,277), t3x36(:,:,7))
  n2(136) = 2
  call heltable([4,9,36], n3(:,278), t3x36(:,:,8))
  n2(137) = 2
  n2(138) = 2
  n2(139) = 2
  n2(140) = 2
  n2(141) = 2
  n2(142) = 2
  n2(143) = 2
  n2(144) = 18
  call heltable([2,18,36], n3(:,279), t3x36(:,:,9))
  n2(145) = 18
  call heltable([2,18,36], n3(:,280), t3x36(:,:,10))
  call heltable([9,4,36], n3(:,281), t3x36(:,:,11))
  n2(146) = 2
  n2(147) = 2
  call heltable([9,4,36], n3(:,282), t3x36(:,:,12))
  n2(148) = 2
  n2(149) = 2
  n2(150) = 2
  n2(151) = 2
  n2(152) = 2
  n2(153) = 2
  n2(154) = 18
  call heltable([18,2,36], n3(:,283), t3x36(:,:,13))
  n2(155) = 18
  call heltable([18,2,36], n3(:,284), t3x36(:,:,14))
  n2(156) = 12
  call heltable([2,3,6], n3(:,285), t3x6(:,:,77))
  n2(157) = 12
  call heltable([2,3,6], n3(:,286), t3x6(:,:,78))
  call heltable([2,3,6], n3(:,287), t3x6(:,:,79))
  call heltable([2,3,6], n3(:,288), t3x6(:,:,80))
  call heltable([2,3,6], n3(:,289), t3x6(:,:,81))
  call heltable([2,3,6], n3(:,290), t3x6(:,:,82))
  call heltable([2,3,6], n3(:,291), t3x6(:,:,83))
  call heltable([2,3,6], n3(:,292), t3x6(:,:,84))
  n2(158) = 18
  call heltable([2,2,4], n3(:,293), t3x4(:,:,27))
  n2(159) = 18
  call heltable([2,2,4], n3(:,294), t3x4(:,:,28))
  call heltable([2,2,4], n3(:,295), t3x4(:,:,29))
  call heltable([2,2,4], n3(:,296), t3x4(:,:,30))
  call heltable([2,2,4], n3(:,297), t3x4(:,:,31))
  call heltable([2,2,4], n3(:,298), t3x4(:,:,32))
  call heltable([2,2,4], n3(:,299), t3x4(:,:,33))
  call heltable([2,2,4], n3(:,300), t3x4(:,:,34))
  call heltable([2,6,12], n3(:,301), t3x12(:,:,49))
  n2(160) = 12
  call heltable([2,3,6], n3(:,302), t3x6(:,:,85))
  call heltable([2,6,12], n3(:,303), t3x12(:,:,50))
  n2(161) = 12
  call heltable([2,3,6], n3(:,304), t3x6(:,:,86))
  call heltable([2,3,6], n3(:,305), t3x6(:,:,87))
  call heltable([2,3,6], n3(:,306), t3x6(:,:,88))
  call heltable([2,3,6], n3(:,307), t3x6(:,:,89))
  call heltable([2,3,6], n3(:,308), t3x6(:,:,90))
  call heltable([2,3,6], n3(:,309), t3x6(:,:,91))
  call heltable([2,3,6], n3(:,310), t3x6(:,:,92))
  n2(162) = 18
  n2(163) = 18
  call heltable([3,4,12], n3(:,311), t3x12(:,:,51))
  n2(164) = 12
  call heltable([3,4,12], n3(:,312), t3x12(:,:,52))
  n2(165) = 12
  call heltable([3,4,12], n3(:,313), t3x12(:,:,53))
  n2(166) = 12
  call heltable([3,4,12], n3(:,314), t3x12(:,:,54))
  n2(167) = 12
  n2(168) = 12
  call heltable([3,2,6], n3(:,315), t3x6(:,:,93))
  call heltable([3,2,6], n3(:,316), t3x6(:,:,94))
  n2(169) = 12
  call heltable([3,2,6], n3(:,317), t3x6(:,:,95))
  call heltable([3,2,6], n3(:,318), t3x6(:,:,96))
  call heltable([3,2,6], n3(:,319), t3x6(:,:,97))
  call heltable([3,2,6], n3(:,320), t3x6(:,:,98))
  call heltable([3,2,6], n3(:,321), t3x6(:,:,99))
  call heltable([3,2,6], n3(:,322), t3x6(:,:,100))
  n2(170) = 18
  call heltable([2,2,4], n3(:,323), t3x4(:,:,35))
  call heltable([2,2,4], n3(:,324), t3x4(:,:,36))
  n2(171) = 18
  call heltable([2,2,4], n3(:,325), t3x4(:,:,37))
  call heltable([2,2,4], n3(:,326), t3x4(:,:,38))
  call heltable([2,2,4], n3(:,327), t3x4(:,:,39))
  call heltable([2,2,4], n3(:,328), t3x4(:,:,40))
  call heltable([2,2,4], n3(:,329), t3x4(:,:,41))
  call heltable([2,2,4], n3(:,330), t3x4(:,:,42))
  call heltable([6,2,12], n3(:,331), t3x12(:,:,55))
  n2(172) = 12
  call heltable([3,2,6], n3(:,332), t3x6(:,:,101))
  call heltable([3,2,6], n3(:,333), t3x6(:,:,102))
  call heltable([6,2,12], n3(:,334), t3x12(:,:,56))
  n2(173) = 12
  call heltable([3,2,6], n3(:,335), t3x6(:,:,103))
  call heltable([3,2,6], n3(:,336), t3x6(:,:,104))
  call heltable([3,2,6], n3(:,337), t3x6(:,:,105))
  call heltable([3,2,6], n3(:,338), t3x6(:,:,106))
  call heltable([3,2,6], n3(:,339), t3x6(:,:,107))
  call heltable([3,2,6], n3(:,340), t3x6(:,:,108))
  n2(174) = 18
  n2(175) = 18
  call heltable([4,3,12], n3(:,341), t3x12(:,:,57))
  n2(176) = 12
  call heltable([4,3,12], n3(:,342), t3x12(:,:,58))
  n2(177) = 12
  call heltable([4,3,12], n3(:,343), t3x12(:,:,59))
  n2(178) = 12
  call heltable([4,3,12], n3(:,344), t3x12(:,:,60))
  n2(179) = 12
  n2(180) = 6
  call heltable([3,4,12], n3(:,345), t3x12(:,:,61))
  n2(181) = 6
  call heltable([3,4,12], n3(:,346), t3x12(:,:,62))
  call heltable([2,4,8], n3(:,347), t3x8(:,:,15))
  call heltable([4,2,8], n3(:,348), t3x8(:,:,16))
  call heltable([4,2,8], n3(:,349), t3x8(:,:,17))
  n2(182) = 6
  call heltable([4,3,12], n3(:,350), t3x12(:,:,63))
  n2(183) = 6
  call heltable([4,3,12], n3(:,351), t3x12(:,:,64))
  call heltable([4,2,8], n3(:,352), t3x8(:,:,18))
  call heltable([2,4,8], n3(:,353), t3x8(:,:,19))
  call heltable([2,4,8], n3(:,354), t3x8(:,:,20))
  call heltable([2,6,12], n3(:,355), t3x12(:,:,65))
  call heltable([2,6,12], n3(:,356), t3x12(:,:,66))
  call heltable([3,4,12], n3(:,357), t3x12(:,:,67))
  call heltable([3,4,12], n3(:,358), t3x12(:,:,68))
  call heltable([3,4,12], n3(:,359), t3x12(:,:,69))
  call heltable([3,4,12], n3(:,360), t3x12(:,:,70))
  n2(184) = 12
  call heltable([2,3,6], n3(:,361), t3x6(:,:,109))
  call heltable([2,3,6], n3(:,362), t3x6(:,:,110))
  call heltable([2,3,6], n3(:,363), t3x6(:,:,111))
  call heltable([2,3,6], n3(:,364), t3x6(:,:,112))
  call heltable([3,3,9], n3(:,365), t3x9(:,:,19))
  call heltable([3,3,9], n3(:,366), t3x9(:,:,20))
  call heltable([3,3,9], n3(:,367), t3x9(:,:,21))
  call heltable([3,3,9], n3(:,368), t3x9(:,:,22))
  call heltable([3,4,12], n3(:,369), t3x12(:,:,71))
  call heltable([3,4,12], n3(:,370), t3x12(:,:,72))
  call heltable([3,4,12], n3(:,371), t3x12(:,:,73))
  call heltable([3,4,12], n3(:,372), t3x12(:,:,74))
  n2(185) = 12
  call heltable([2,3,6], n3(:,373), t3x6(:,:,113))
  call heltable([2,3,6], n3(:,374), t3x6(:,:,114))
  call heltable([2,3,6], n3(:,375), t3x6(:,:,115))
  call heltable([2,3,6], n3(:,376), t3x6(:,:,116))
  call heltable([3,3,9], n3(:,377), t3x9(:,:,23))
  call heltable([3,3,9], n3(:,378), t3x9(:,:,24))
  call heltable([3,3,9], n3(:,379), t3x9(:,:,25))
  call heltable([3,3,9], n3(:,380), t3x9(:,:,26))
  call heltable([2,4,8], n3(:,381), t3x8(:,:,21))
  call heltable([4,2,8], n3(:,382), t3x8(:,:,22))
  call heltable([4,2,8], n3(:,383), t3x8(:,:,23))
  call heltable([2,3,6], n3(:,384), t3x6(:,:,117))
  call heltable([2,3,6], n3(:,385), t3x6(:,:,118))
  call heltable([3,6,18], n3(:,386), t3x18(:,:,81))
  call heltable([3,6,18], n3(:,387), t3x18(:,:,82))
  call heltable([3,6,18], n3(:,388), t3x18(:,:,83))
  call heltable([3,6,18], n3(:,389), t3x18(:,:,84))
  n2(186) = 6
  n2(187) = 6
  n2(188) = 6
  n2(189) = 6
  call heltable([4,2,8], n3(:,390), t3x8(:,:,24))
  call heltable([2,4,8], n3(:,391), t3x8(:,:,25))
  call heltable([3,6,18], n3(:,392), t3x18(:,:,85))
  call heltable([3,6,18], n3(:,393), t3x18(:,:,86))
  call heltable([3,6,18], n3(:,394), t3x18(:,:,87))
  call heltable([3,6,18], n3(:,395), t3x18(:,:,88))
  n2(190) = 6
  n2(191) = 6
  n2(192) = 6
  n2(193) = 6
  n2(194) = 12
  call heltable([6,2,12], n3(:,396), t3x12(:,:,75))
  n2(195) = 12
  call heltable([6,2,12], n3(:,397), t3x12(:,:,76))
  call heltable([3,6,18], n3(:,398), t3x18(:,:,89))
  n2(196) = 4
  call heltable([3,6,18], n3(:,399), t3x18(:,:,90))
  call heltable([2,9,18], n3(:,400), t3x18(:,:,91))
  n2(197) = 18
  call heltable([2,9,18], n3(:,401), t3x18(:,:,92))
  n2(198) = 18
  call heltable([9,2,18], n3(:,402), t3x18(:,:,93))
  n2(199) = 18
  call heltable([9,2,18], n3(:,403), t3x18(:,:,94))
  n2(200) = 18
  call heltable([9,2,18], n3(:,404), t3x18(:,:,95))
  n2(201) = 18
  call heltable([9,2,18], n3(:,405), t3x18(:,:,96))
  n2(202) = 18
  call heltable([4,3,12], n3(:,406), t3x12(:,:,77))
  call heltable([4,3,12], n3(:,407), t3x12(:,:,78))
  call heltable([4,3,12], n3(:,408), t3x12(:,:,79))
  call heltable([4,3,12], n3(:,409), t3x12(:,:,80))
  n2(203) = 12
  call heltable([3,2,6], n3(:,410), t3x6(:,:,119))
  call heltable([3,2,6], n3(:,411), t3x6(:,:,120))
  call heltable([3,2,6], n3(:,412), t3x6(:,:,121))
  call heltable([3,2,6], n3(:,413), t3x6(:,:,122))
  call heltable([3,3,9], n3(:,414), t3x9(:,:,27))
  call heltable([3,3,9], n3(:,415), t3x9(:,:,28))
  call heltable([3,3,9], n3(:,416), t3x9(:,:,29))
  call heltable([3,3,9], n3(:,417), t3x9(:,:,30))
  call heltable([4,3,12], n3(:,418), t3x12(:,:,81))
  call heltable([4,3,12], n3(:,419), t3x12(:,:,82))
  call heltable([4,3,12], n3(:,420), t3x12(:,:,83))
  call heltable([4,3,12], n3(:,421), t3x12(:,:,84))
  n2(204) = 12
  call heltable([3,2,6], n3(:,422), t3x6(:,:,123))
  call heltable([3,2,6], n3(:,423), t3x6(:,:,124))
  call heltable([3,2,6], n3(:,424), t3x6(:,:,125))
  call heltable([3,2,6], n3(:,425), t3x6(:,:,126))
  call heltable([3,3,9], n3(:,426), t3x9(:,:,31))
  call heltable([3,3,9], n3(:,427), t3x9(:,:,32))
  call heltable([3,3,9], n3(:,428), t3x9(:,:,33))
  call heltable([3,3,9], n3(:,429), t3x9(:,:,34))
  call heltable([4,2,8], n3(:,430), t3x8(:,:,26))
  call heltable([2,4,8], n3(:,431), t3x8(:,:,27))
  call heltable([2,4,8], n3(:,432), t3x8(:,:,28))
  call heltable([3,2,6], n3(:,433), t3x6(:,:,127))
  call heltable([3,2,6], n3(:,434), t3x6(:,:,128))
  call heltable([6,3,18], n3(:,435), t3x18(:,:,97))
  call heltable([6,3,18], n3(:,436), t3x18(:,:,98))
  call heltable([6,3,18], n3(:,437), t3x18(:,:,99))
  call heltable([6,3,18], n3(:,438), t3x18(:,:,100))
  n2(205) = 6
  n2(206) = 6
  n2(207) = 6
  n2(208) = 6
  call heltable([2,4,8], n3(:,439), t3x8(:,:,29))
  call heltable([4,2,8], n3(:,440), t3x8(:,:,30))
  call heltable([6,3,18], n3(:,441), t3x18(:,:,101))
  call heltable([6,3,18], n3(:,442), t3x18(:,:,102))
  call heltable([6,3,18], n3(:,443), t3x18(:,:,103))
  call heltable([6,3,18], n3(:,444), t3x18(:,:,104))
  n2(209) = 6
  n2(210) = 6
  n2(211) = 6
  n2(212) = 6
  n2(213) = 12
  n2(214) = 12
  call heltable([6,3,18], n3(:,445), t3x18(:,:,105))
  n2(215) = 4
  call heltable([6,3,18], n3(:,446), t3x18(:,:,106))
  call heltable([9,2,18], n3(:,447), t3x18(:,:,107))
  n2(216) = 18
  call heltable([9,2,18], n3(:,448), t3x18(:,:,108))
  n2(217) = 18
  call heltable([2,9,18], n3(:,449), t3x18(:,:,109))
  n2(218) = 18
  call heltable([2,9,18], n3(:,450), t3x18(:,:,110))
  n2(219) = 18
  call heltable([2,9,18], n3(:,451), t3x18(:,:,111))
  n2(220) = 18
  call heltable([2,9,18], n3(:,452), t3x18(:,:,112))
  n2(221) = 18
  call heltable([3,6,18], n3(:,453), t3x18(:,:,113))
  call heltable([3,6,18], n3(:,454), t3x18(:,:,114))
  call heltable([3,6,18], n3(:,455), t3x18(:,:,115))
  call heltable([3,6,18], n3(:,456), t3x18(:,:,116))
  n2(222) = 12
  call heltable([3,6,18], n3(:,457), t3x18(:,:,117))
  call heltable([6,3,18], n3(:,458), t3x18(:,:,118))
  call heltable([6,3,18], n3(:,459), t3x18(:,:,119))
  call heltable([6,3,18], n3(:,460), t3x18(:,:,120))
  call heltable([6,3,18], n3(:,461), t3x18(:,:,121))
  call heltable([3,4,12], n3(:,462), t3x12(:,:,85))
  n2(223) = 12
  call heltable([9,2,18], n3(:,463), t3x18(:,:,122))
  call heltable([2,9,18], n3(:,464), t3x18(:,:,123))
  n2(224) = 6
  n2(225) = 12
  call heltable([4,3,12], n3(:,465), t3x12(:,:,86))
  n2(226) = 12
  call heltable([2,9,18], n3(:,466), t3x18(:,:,124))
  call heltable([9,2,18], n3(:,467), t3x18(:,:,125))
  call heltable([3,6,18], n3(:,468), t3x18(:,:,126))
  n2(227) = 18
  call heltable([6,3,18], n3(:,469), t3x18(:,:,127))
  call heltable([2,9,18], n3(:,470), t3x18(:,:,128))
  call heltable([9,2,18], n3(:,471), t3x18(:,:,129))
  n2(228) = 6
  call heltable([9,2,18], n3(:,472), t3x18(:,:,130))
  call heltable([2,9,18], n3(:,473), t3x18(:,:,131))
  call heltable([6,3,18], n3(:,474), t3x18(:,:,132))
  n2(229) = 18
  call heltable([3,6,18], n3(:,475), t3x18(:,:,133))
  call heltable([3,6,18], n3(:,476), t3x18(:,:,134))
  call heltable([3,6,18], n3(:,477), t3x18(:,:,135))
  call heltable([3,6,18], n3(:,478), t3x18(:,:,136))
  call heltable([2,6,12], n3(:,479), t3x12(:,:,87))
  n2(230) = 12
  call heltable([3,6,18], n3(:,480), t3x18(:,:,137))
  call heltable([6,3,18], n3(:,481), t3x18(:,:,138))
  call heltable([6,3,18], n3(:,482), t3x18(:,:,139))
  call heltable([6,3,18], n3(:,483), t3x18(:,:,140))
  call heltable([6,3,18], n3(:,484), t3x18(:,:,141))
  call heltable([3,4,12], n3(:,485), t3x12(:,:,88))
  n2(231) = 12
  call heltable([9,2,18], n3(:,486), t3x18(:,:,142))
  call heltable([2,9,18], n3(:,487), t3x18(:,:,143))
  n2(232) = 6
  call heltable([6,2,12], n3(:,488), t3x12(:,:,89))
  n2(233) = 12
  call heltable([4,3,12], n3(:,489), t3x12(:,:,90))
  n2(234) = 12
  call heltable([2,9,18], n3(:,490), t3x18(:,:,144))
  call heltable([9,2,18], n3(:,491), t3x18(:,:,145))
  call heltable([3,6,18], n3(:,492), t3x18(:,:,146))
  n2(235) = 18
  call heltable([6,3,18], n3(:,493), t3x18(:,:,147))
  call heltable([2,9,18], n3(:,494), t3x18(:,:,148))
  call heltable([9,2,18], n3(:,495), t3x18(:,:,149))
  n2(236) = 6
  call heltable([9,2,18], n3(:,496), t3x18(:,:,150))
  call heltable([2,9,18], n3(:,497), t3x18(:,:,151))
  call heltable([6,3,18], n3(:,498), t3x18(:,:,152))
  n2(237) = 18
  call heltable([3,3,9], n3(:,499), t3x9(:,:,35))
  call heltable([3,3,9], n3(:,500), t3x9(:,:,36))
  call heltable([2,6,12], n3(:,501), t3x12(:,:,91))
  call heltable([2,6,12], n3(:,502), t3x12(:,:,92))
  call heltable([2,6,12], n3(:,503), t3x12(:,:,93))
  call heltable([2,6,12], n3(:,504), t3x12(:,:,94))
  call heltable([2,6,12], n3(:,505), t3x12(:,:,95))
  call heltable([2,6,12], n3(:,506), t3x12(:,:,96))
  call heltable([2,6,12], n3(:,507), t3x12(:,:,97))
  call heltable([2,6,12], n3(:,508), t3x12(:,:,98))
  call heltable([3,6,18], n3(:,509), t3x18(:,:,153))
  call heltable([3,6,18], n3(:,510), t3x18(:,:,154))
  call heltable([2,3,6], n3(:,511), t3x6(:,:,129))
  call heltable([2,3,6], n3(:,512), t3x6(:,:,130))
  call heltable([3,6,18], n3(:,513), t3x18(:,:,155))
  call heltable([3,6,18], n3(:,514), t3x18(:,:,156))
  call heltable([2,9,18], n3(:,515), t3x18(:,:,157))
  call heltable([3,6,18], n3(:,516), t3x18(:,:,158))
  call heltable([3,6,18], n3(:,517), t3x18(:,:,159))
  call heltable([2,3,6], n3(:,518), t3x6(:,:,131))
  call heltable([2,3,6], n3(:,519), t3x6(:,:,132))
  call heltable([3,6,18], n3(:,520), t3x18(:,:,160))
  call heltable([3,6,18], n3(:,521), t3x18(:,:,161))
  call heltable([2,9,18], n3(:,522), t3x18(:,:,162))
  call heltable([6,3,18], n3(:,523), t3x18(:,:,163))
  call heltable([6,3,18], n3(:,524), t3x18(:,:,164))
  call heltable([3,2,6], n3(:,525), t3x6(:,:,133))
  call heltable([3,2,6], n3(:,526), t3x6(:,:,134))
  call heltable([6,2,12], n3(:,527), t3x12(:,:,99))
  call heltable([6,2,12], n3(:,528), t3x12(:,:,100))
  call heltable([6,3,18], n3(:,529), t3x18(:,:,165))
  call heltable([6,3,18], n3(:,530), t3x18(:,:,166))
  call heltable([9,2,18], n3(:,531), t3x18(:,:,167))
  call heltable([6,3,18], n3(:,532), t3x18(:,:,168))
  call heltable([6,3,18], n3(:,533), t3x18(:,:,169))
  call heltable([3,2,6], n3(:,534), t3x6(:,:,135))
  call heltable([3,2,6], n3(:,535), t3x6(:,:,136))
  call heltable([6,2,12], n3(:,536), t3x12(:,:,101))
  call heltable([6,2,12], n3(:,537), t3x12(:,:,102))
  call heltable([6,3,18], n3(:,538), t3x18(:,:,170))
  call heltable([6,3,18], n3(:,539), t3x18(:,:,171))
  call heltable([9,2,18], n3(:,540), t3x18(:,:,172))
  call heltable([9,2,18], n3(:,541), t3x18(:,:,173))
  call heltable([2,9,18], n3(:,542), t3x18(:,:,174))
  call heltable([2,6,12], n3(:,543), t3x12(:,:,103))
  call heltable([3,6,18], n3(:,544), t3x18(:,:,175))
  call heltable([6,2,12], n3(:,545), t3x12(:,:,104))
  call heltable([3,6,18], n3(:,546), t3x18(:,:,176))
  call heltable([6,3,18], n3(:,547), t3x18(:,:,177))
  call heltable([6,3,18], n3(:,548), t3x18(:,:,178))
  call heltable([3,3,9], n3(:,549), t3x9(:,:,37))
  call heltable([3,3,9], n3(:,550), t3x9(:,:,38))
  call heltable([3,6,18], n3(:,551), t3x18(:,:,179))
  call heltable([3,6,18], n3(:,552), t3x18(:,:,180))
  call heltable([2,3,6], n3(:,553), t3x6(:,:,137))
  call heltable([2,3,6], n3(:,554), t3x6(:,:,138))
  call heltable([3,6,18], n3(:,555), t3x18(:,:,181))
  call heltable([3,6,18], n3(:,556), t3x18(:,:,182))
  call heltable([2,9,18], n3(:,557), t3x18(:,:,183))
  call heltable([3,6,18], n3(:,558), t3x18(:,:,184))
  call heltable([3,6,18], n3(:,559), t3x18(:,:,185))
  call heltable([2,3,6], n3(:,560), t3x6(:,:,139))
  call heltable([2,3,6], n3(:,561), t3x6(:,:,140))
  call heltable([3,6,18], n3(:,562), t3x18(:,:,186))
  call heltable([3,6,18], n3(:,563), t3x18(:,:,187))
  call heltable([2,9,18], n3(:,564), t3x18(:,:,188))
  call heltable([6,3,18], n3(:,565), t3x18(:,:,189))
  call heltable([6,3,18], n3(:,566), t3x18(:,:,190))
  call heltable([3,2,6], n3(:,567), t3x6(:,:,141))
  call heltable([3,2,6], n3(:,568), t3x6(:,:,142))
  call heltable([6,2,12], n3(:,569), t3x12(:,:,105))
  call heltable([6,2,12], n3(:,570), t3x12(:,:,106))
  call heltable([6,3,18], n3(:,571), t3x18(:,:,191))
  call heltable([6,3,18], n3(:,572), t3x18(:,:,192))
  call heltable([9,2,18], n3(:,573), t3x18(:,:,193))
  call heltable([6,3,18], n3(:,574), t3x18(:,:,194))
  call heltable([6,3,18], n3(:,575), t3x18(:,:,195))
  call heltable([3,2,6], n3(:,576), t3x6(:,:,143))
  call heltable([3,2,6], n3(:,577), t3x6(:,:,144))
  call heltable([6,2,12], n3(:,578), t3x12(:,:,107))
  call heltable([6,2,12], n3(:,579), t3x12(:,:,108))
  call heltable([6,3,18], n3(:,580), t3x18(:,:,196))
  call heltable([6,3,18], n3(:,581), t3x18(:,:,197))
  call heltable([9,2,18], n3(:,582), t3x18(:,:,198))
  call heltable([4,6,24], n3(:,583), t3x24(:,:,9))
  n2(238) = 3
  n2(239) = 3
  call heltable([12,2,24], n3(:,584), t3x24(:,:,10))
  n2(240) = 3
  n2(241) = 3
  call heltable([8,3,24], n3(:,585), t3x24(:,:,11))
  call heltable([8,3,24], n3(:,586), t3x24(:,:,12))
  call heltable([3,8,24], n3(:,587), t3x24(:,:,13))
  call heltable([8,3,24], n3(:,588), t3x24(:,:,14))
  call heltable([3,8,24], n3(:,589), t3x24(:,:,15))
  call heltable([8,3,24], n3(:,590), t3x24(:,:,16))
  call heltable([4,6,24], n3(:,591), t3x24(:,:,17))
  n2(242) = 3
  n2(243) = 3
  call heltable([12,2,24], n3(:,592), t3x24(:,:,18))
  n2(244) = 3
  n2(245) = 3
  call heltable([8,3,24], n3(:,593), t3x24(:,:,19))
  call heltable([8,3,24], n3(:,594), t3x24(:,:,20))
  call heltable([3,8,24], n3(:,595), t3x24(:,:,21))
  call heltable([8,3,24], n3(:,596), t3x24(:,:,22))
  call heltable([3,8,24], n3(:,597), t3x24(:,:,23))
  call heltable([8,3,24], n3(:,598), t3x24(:,:,24))
  call heltable([6,4,24], n3(:,599), t3x24(:,:,25))
  call heltable([2,12,24], n3(:,600), t3x24(:,:,26))
  call heltable([8,3,24], n3(:,601), t3x24(:,:,27))
  call heltable([8,3,24], n3(:,602), t3x24(:,:,28))
  call heltable([3,8,24], n3(:,603), t3x24(:,:,29))
  call heltable([8,3,24], n3(:,604), t3x24(:,:,30))
  call heltable([3,8,24], n3(:,605), t3x24(:,:,31))
  call heltable([8,3,24], n3(:,606), t3x24(:,:,32))
  call heltable([6,4,24], n3(:,607), t3x24(:,:,33))
  call heltable([2,12,24], n3(:,608), t3x24(:,:,34))
  call heltable([8,3,24], n3(:,609), t3x24(:,:,35))
  call heltable([8,3,24], n3(:,610), t3x24(:,:,36))
  call heltable([3,8,24], n3(:,611), t3x24(:,:,37))
  call heltable([8,3,24], n3(:,612), t3x24(:,:,38))
  call heltable([3,8,24], n3(:,613), t3x24(:,:,39))
  call heltable([8,3,24], n3(:,614), t3x24(:,:,40))
  call heltable([2,3,6], n3(:,615), t3x6(:,:,145))
  call heltable([2,3,6], n3(:,616), t3x6(:,:,146))
  call heltable([3,2,6], n3(:,617), t3x6(:,:,147))
  call heltable([3,2,6], n3(:,618), t3x6(:,:,148))
  call heltable([2,3,6], n3(:,619), t3x6(:,:,149))
  call heltable([2,3,6], n3(:,620), t3x6(:,:,150))
  call heltable([3,2,6], n3(:,621), t3x6(:,:,151))
  call heltable([3,2,6], n3(:,622), t3x6(:,:,152))
  call heltable([6,4,24], n3(:,623), t3x24(:,:,41))
  call heltable([12,2,24], n3(:,624), t3x24(:,:,42))
  n2(246) = 18
  call heltable([2,18,36], n3(:,625), t3x36(:,:,15))
  n2(247) = 2
  call heltable([3,12,36], n3(:,626), t3x36(:,:,16))
  call heltable([4,6,24], n3(:,627), t3x24(:,:,43))
  call heltable([8,3,24], n3(:,628), t3x24(:,:,44))
  call heltable([8,3,24], n3(:,629), t3x24(:,:,45))
  call heltable([12,2,24], n3(:,630), t3x24(:,:,46))
  call heltable([4,9,36], n3(:,631), t3x36(:,:,17))
  call heltable([9,4,36], n3(:,632), t3x36(:,:,18))
  call heltable([3,12,36], n3(:,633), t3x36(:,:,19))
  call heltable([3,12,36], n3(:,634), t3x36(:,:,20))
  call heltable([3,3,9], n3(:,635), t3x9(:,:,39))
  call heltable([3,3,9], n3(:,636), t3x9(:,:,40))
  call heltable([3,3,9], n3(:,637), t3x9(:,:,41))
  call heltable([3,3,9], n3(:,638), t3x9(:,:,42))
  call heltable([2,3,6], n3(:,639), t3x6(:,:,153))
  n2(248) = 18
  call heltable([2,2,4], n3(:,640), t3x4(:,:,43))
  n2(249) = 18
  n2(250) = 18
  call heltable([6,4,24], n3(:,641), t3x24(:,:,47))
  call heltable([12,2,24], n3(:,642), t3x24(:,:,48))
  n2(251) = 18
  call heltable([2,18,36], n3(:,643), t3x36(:,:,21))
  call heltable([3,12,36], n3(:,644), t3x36(:,:,22))
  call heltable([4,6,24], n3(:,645), t3x24(:,:,49))
  call heltable([8,3,24], n3(:,646), t3x24(:,:,50))
  call heltable([8,3,24], n3(:,647), t3x24(:,:,51))
  call heltable([12,2,24], n3(:,648), t3x24(:,:,52))
  call heltable([4,9,36], n3(:,649), t3x36(:,:,23))
  call heltable([9,4,36], n3(:,650), t3x36(:,:,24))
  call heltable([3,12,36], n3(:,651), t3x36(:,:,25))
  call heltable([3,12,36], n3(:,652), t3x36(:,:,26))
  call heltable([3,3,9], n3(:,653), t3x9(:,:,43))
  call heltable([3,3,9], n3(:,654), t3x9(:,:,44))
  call heltable([3,3,9], n3(:,655), t3x9(:,:,45))
  call heltable([3,3,9], n3(:,656), t3x9(:,:,46))
  call heltable([2,3,6], n3(:,657), t3x6(:,:,154))
  n2(252) = 18
  n2(253) = 18
  n2(254) = 18
  call heltable([4,6,24], n3(:,658), t3x24(:,:,53))
  call heltable([2,12,24], n3(:,659), t3x24(:,:,54))
  n2(255) = 18
  call heltable([18,2,36], n3(:,660), t3x36(:,:,27))
  n2(256) = 2
  call heltable([12,3,36], n3(:,661), t3x36(:,:,28))
  call heltable([6,4,24], n3(:,662), t3x24(:,:,55))
  call heltable([8,3,24], n3(:,663), t3x24(:,:,56))
  call heltable([3,8,24], n3(:,664), t3x24(:,:,57))
  call heltable([2,12,24], n3(:,665), t3x24(:,:,58))
  call heltable([9,4,36], n3(:,666), t3x36(:,:,29))
  call heltable([4,9,36], n3(:,667), t3x36(:,:,30))
  call heltable([12,3,36], n3(:,668), t3x36(:,:,31))
  call heltable([12,3,36], n3(:,669), t3x36(:,:,32))
  call heltable([3,3,9], n3(:,670), t3x9(:,:,47))
  call heltable([3,3,9], n3(:,671), t3x9(:,:,48))
  call heltable([3,3,9], n3(:,672), t3x9(:,:,49))
  call heltable([3,3,9], n3(:,673), t3x9(:,:,50))
  call heltable([3,2,6], n3(:,674), t3x6(:,:,155))
  n2(257) = 18
  call heltable([2,2,4], n3(:,675), t3x4(:,:,44))
  n2(258) = 18
  n2(259) = 18
  call heltable([4,6,24], n3(:,676), t3x24(:,:,59))
  call heltable([2,12,24], n3(:,677), t3x24(:,:,60))
  n2(260) = 18
  call heltable([18,2,36], n3(:,678), t3x36(:,:,33))
  call heltable([12,3,36], n3(:,679), t3x36(:,:,34))
  call heltable([6,4,24], n3(:,680), t3x24(:,:,61))
  call heltable([8,3,24], n3(:,681), t3x24(:,:,62))
  call heltable([3,8,24], n3(:,682), t3x24(:,:,63))
  call heltable([2,12,24], n3(:,683), t3x24(:,:,64))
  call heltable([9,4,36], n3(:,684), t3x36(:,:,35))
  call heltable([4,9,36], n3(:,685), t3x36(:,:,36))
  call heltable([12,3,36], n3(:,686), t3x36(:,:,37))
  call heltable([12,3,36], n3(:,687), t3x36(:,:,38))
  call heltable([3,3,9], n3(:,688), t3x9(:,:,51))
  call heltable([3,3,9], n3(:,689), t3x9(:,:,52))
  call heltable([3,3,9], n3(:,690), t3x9(:,:,53))
  call heltable([3,3,9], n3(:,691), t3x9(:,:,54))
  call heltable([3,2,6], n3(:,692), t3x6(:,:,156))
  n2(261) = 18
  n2(262) = 18
  n2(263) = 18
  call heltable([4,9,36], n3(:,693), t3x36(:,:,39))
  n2(264) = 18
  call heltable([2,18,36], n3(:,694), t3x36(:,:,40))
  call heltable([9,4,36], n3(:,695), t3x36(:,:,41))
  n2(265) = 18
  call heltable([18,2,36], n3(:,696), t3x36(:,:,42))
  n2(266) = 18
  n2(267) = 18
  n2(268) = 18
  n2(269) = 18
  call heltable([2,3,6], n3(:,697), t3x6(:,:,157))
  n2(270) = 6
  call heltable([3,4,12], n3(:,698), t3x12(:,:,109))
  call heltable([2,3,6], n3(:,699), t3x6(:,:,158))
  n2(271) = 6
  call heltable([3,4,12], n3(:,700), t3x12(:,:,110))
  call heltable([2,4,8], n3(:,701), t3x8(:,:,31))
  call heltable([4,2,8], n3(:,702), t3x8(:,:,32))
  call heltable([4,2,8], n3(:,703), t3x8(:,:,33))
  call heltable([3,2,6], n3(:,704), t3x6(:,:,159))
  n2(272) = 6
  call heltable([4,3,12], n3(:,705), t3x12(:,:,111))
  call heltable([3,2,6], n3(:,706), t3x6(:,:,160))
  n2(273) = 6
  call heltable([4,3,12], n3(:,707), t3x12(:,:,112))
  call heltable([4,2,8], n3(:,708), t3x8(:,:,34))
  call heltable([2,4,8], n3(:,709), t3x8(:,:,35))
  call heltable([2,4,8], n3(:,710), t3x8(:,:,36))
  call heltable([2,6,12], n3(:,711), t3x12(:,:,113))
  call heltable([2,6,12], n3(:,712), t3x12(:,:,114))
  n2(274) = 3
  call heltable([3,4,12], n3(:,713), t3x12(:,:,115))
  n2(275) = 3
  call heltable([2,3,6], n3(:,714), t3x6(:,:,161))
  call heltable([2,4,8], n3(:,715), t3x8(:,:,37))
  call heltable([3,3,9], n3(:,716), t3x9(:,:,55))
  call heltable([3,3,9], n3(:,717), t3x9(:,:,56))
  call heltable([4,2,8], n3(:,718), t3x8(:,:,38))
  call heltable([3,3,9], n3(:,719), t3x9(:,:,57))
  call heltable([3,3,9], n3(:,720), t3x9(:,:,58))
  call heltable([4,2,8], n3(:,721), t3x8(:,:,39))
  n2(276) = 3
  call heltable([3,4,12], n3(:,722), t3x12(:,:,116))
  n2(277) = 3
  call heltable([2,3,6], n3(:,723), t3x6(:,:,162))
  call heltable([3,3,9], n3(:,724), t3x9(:,:,59))
  call heltable([3,3,9], n3(:,725), t3x9(:,:,60))
  call heltable([3,3,9], n3(:,726), t3x9(:,:,61))
  call heltable([3,3,9], n3(:,727), t3x9(:,:,62))
  call heltable([3,6,18], n3(:,728), t3x18(:,:,199))
  call heltable([3,2,6], n3(:,729), t3x6(:,:,163))
  n2(278) = 6
  call heltable([4,2,8], n3(:,730), t3x8(:,:,40))
  call heltable([2,4,8], n3(:,731), t3x8(:,:,41))
  call heltable([2,4,8], n3(:,732), t3x8(:,:,42))
  call heltable([3,6,18], n3(:,733), t3x18(:,:,200))
  call heltable([3,2,6], n3(:,734), t3x6(:,:,164))
  n2(279) = 6
  call heltable([6,2,12], n3(:,735), t3x12(:,:,117))
  call heltable([6,2,12], n3(:,736), t3x12(:,:,118))
  call heltable([4,3,12], n3(:,737), t3x12(:,:,119))
  call heltable([3,2,6], n3(:,738), t3x6(:,:,165))
  call heltable([4,2,8], n3(:,739), t3x8(:,:,43))
  call heltable([2,4,8], n3(:,740), t3x8(:,:,44))
  call heltable([2,4,8], n3(:,741), t3x8(:,:,45))
  call heltable([4,3,12], n3(:,742), t3x12(:,:,120))
  call heltable([3,2,6], n3(:,743), t3x6(:,:,166))
  call heltable([6,3,18], n3(:,744), t3x18(:,:,201))
  call heltable([2,3,6], n3(:,745), t3x6(:,:,167))
  n2(280) = 6
  call heltable([2,4,8], n3(:,746), t3x8(:,:,46))
  call heltable([4,2,8], n3(:,747), t3x8(:,:,47))
  call heltable([4,2,8], n3(:,748), t3x8(:,:,48))
  call heltable([6,3,18], n3(:,749), t3x18(:,:,202))
  call heltable([2,3,6], n3(:,750), t3x6(:,:,168))
  n2(281) = 6
  call heltable([3,6,18], n3(:,751), t3x18(:,:,203))
  call heltable([3,6,18], n3(:,752), t3x18(:,:,204))
  call heltable([2,3,6], n3(:,753), t3x6(:,:,169))
  n2(282) = 2
  call heltable([2,2,4], n3(:,754), t3x4(:,:,45))
  call heltable([3,6,18], n3(:,755), t3x18(:,:,205))
  n2(283) = 4
  n2(284) = 2
  call heltable([2,2,4], n3(:,756), t3x4(:,:,46))
  n2(285) = 4
  call heltable([2,3,6], n3(:,757), t3x6(:,:,170))
  call heltable([2,3,6], n3(:,758), t3x6(:,:,171))
  call heltable([6,3,18], n3(:,759), t3x18(:,:,206))
  call heltable([6,3,18], n3(:,760), t3x18(:,:,207))
  call heltable([3,3,9], n3(:,761), t3x9(:,:,63))
  call heltable([2,4,8], n3(:,762), t3x8(:,:,49))
  call heltable([3,3,9], n3(:,763), t3x9(:,:,64))
  call heltable([2,4,8], n3(:,764), t3x8(:,:,50))
  call heltable([3,3,9], n3(:,765), t3x9(:,:,65))
  call heltable([4,2,8], n3(:,766), t3x8(:,:,51))
  call heltable([3,3,9], n3(:,767), t3x9(:,:,66))
  call heltable([4,2,8], n3(:,768), t3x8(:,:,52))
  call heltable([9,2,18], n3(:,769), t3x18(:,:,208))
  call heltable([9,2,18], n3(:,770), t3x18(:,:,209))
  call heltable([2,9,18], n3(:,771), t3x18(:,:,210))
  call heltable([2,9,18], n3(:,772), t3x18(:,:,211))
  call heltable([2,3,6], n3(:,773), t3x6(:,:,172))
  n2(286) = 6
  call heltable([2,3,6], n3(:,774), t3x6(:,:,173))
  n2(287) = 6
  call heltable([3,2,6], n3(:,775), t3x6(:,:,174))
  call heltable([4,2,8], n3(:,776), t3x8(:,:,53))
  call heltable([4,2,8], n3(:,777), t3x8(:,:,54))
  call heltable([2,4,8], n3(:,778), t3x8(:,:,55))
  call heltable([2,4,8], n3(:,779), t3x8(:,:,56))
  call heltable([2,9,18], n3(:,780), t3x18(:,:,212))
  call heltable([9,2,18], n3(:,781), t3x18(:,:,213))
  call heltable([3,6,18], n3(:,782), t3x18(:,:,214))
  n2(288) = 18
  n2(289) = 2
  call heltable([2,2,4], n3(:,783), t3x4(:,:,47))
  call heltable([6,3,18], n3(:,784), t3x18(:,:,215))
  n2(290) = 4
  n2(291) = 2
  call heltable([2,2,4], n3(:,785), t3x4(:,:,48))
  n2(292) = 4
  call heltable([3,2,6], n3(:,786), t3x6(:,:,175))
  call heltable([3,2,6], n3(:,787), t3x6(:,:,176))
  call heltable([2,9,18], n3(:,788), t3x18(:,:,216))
  call heltable([2,9,18], n3(:,789), t3x18(:,:,217))
  call heltable([9,2,18], n3(:,790), t3x18(:,:,218))
  call heltable([9,2,18], n3(:,791), t3x18(:,:,219))
  call heltable([3,2,6], n3(:,792), t3x6(:,:,177))
  n2(293) = 6
  call heltable([3,2,6], n3(:,793), t3x6(:,:,178))
  n2(294) = 6
  call heltable([9,2,18], n3(:,794), t3x18(:,:,220))
  call heltable([2,9,18], n3(:,795), t3x18(:,:,221))
  call heltable([6,3,18], n3(:,796), t3x18(:,:,222))
  n2(295) = 18
  call heltable([3,6,18], n3(:,797), t3x18(:,:,223))
  call heltable([3,6,18], n3(:,798), t3x18(:,:,224))
  call heltable([2,3,6], n3(:,799), t3x6(:,:,179))
  call heltable([3,6,18], n3(:,800), t3x18(:,:,225))
  call heltable([2,3,6], n3(:,801), t3x6(:,:,180))
  call heltable([2,3,6], n3(:,802), t3x6(:,:,181))
  call heltable([6,3,18], n3(:,803), t3x18(:,:,226))
  call heltable([6,3,18], n3(:,804), t3x18(:,:,227))
  call heltable([3,3,9], n3(:,805), t3x9(:,:,67))
  call heltable([3,3,9], n3(:,806), t3x9(:,:,68))
  call heltable([3,3,9], n3(:,807), t3x9(:,:,69))
  call heltable([3,3,9], n3(:,808), t3x9(:,:,70))
  call heltable([9,2,18], n3(:,809), t3x18(:,:,228))
  call heltable([9,2,18], n3(:,810), t3x18(:,:,229))
  call heltable([2,9,18], n3(:,811), t3x18(:,:,230))
  call heltable([2,9,18], n3(:,812), t3x18(:,:,231))
  call heltable([2,3,6], n3(:,813), t3x6(:,:,182))
  n2(296) = 6
  call heltable([2,3,6], n3(:,814), t3x6(:,:,183))
  n2(297) = 6
  call heltable([3,2,6], n3(:,815), t3x6(:,:,184))
  call heltable([2,9,18], n3(:,816), t3x18(:,:,232))
  call heltable([9,2,18], n3(:,817), t3x18(:,:,233))
  call heltable([3,6,18], n3(:,818), t3x18(:,:,234))
  n2(298) = 18
  call heltable([6,3,18], n3(:,819), t3x18(:,:,235))
  call heltable([3,2,6], n3(:,820), t3x6(:,:,185))
  call heltable([3,2,6], n3(:,821), t3x6(:,:,186))
  call heltable([2,9,18], n3(:,822), t3x18(:,:,236))
  call heltable([2,9,18], n3(:,823), t3x18(:,:,237))
  call heltable([9,2,18], n3(:,824), t3x18(:,:,238))
  call heltable([9,2,18], n3(:,825), t3x18(:,:,239))
  call heltable([3,2,6], n3(:,826), t3x6(:,:,187))
  n2(299) = 6
  call heltable([3,2,6], n3(:,827), t3x6(:,:,188))
  n2(300) = 6
  call heltable([9,2,18], n3(:,828), t3x18(:,:,240))
  call heltable([2,9,18], n3(:,829), t3x18(:,:,241))
  call heltable([6,3,18], n3(:,830), t3x18(:,:,242))
  n2(301) = 18
  call heltable([3,3,9], n3(:,831), t3x9(:,:,71))
  call heltable([3,3,9], n3(:,832), t3x9(:,:,72))
  call heltable([3,3,9], n3(:,833), t3x9(:,:,73))
  call heltable([3,3,9], n3(:,834), t3x9(:,:,74))
  call heltable([2,6,12], n3(:,835), t3x12(:,:,121))
  call heltable([2,6,12], n3(:,836), t3x12(:,:,122))
  call heltable([3,6,18], n3(:,837), t3x18(:,:,243))
  call heltable([2,3,6], n3(:,838), t3x6(:,:,189))
  call heltable([2,3,6], n3(:,839), t3x6(:,:,190))
  call heltable([2,4,8], n3(:,840), t3x8(:,:,57))
  call heltable([2,4,8], n3(:,841), t3x8(:,:,58))
  call heltable([4,2,8], n3(:,842), t3x8(:,:,59))
  call heltable([4,2,8], n3(:,843), t3x8(:,:,60))
  call heltable([3,6,18], n3(:,844), t3x18(:,:,244))
  call heltable([2,9,18], n3(:,845), t3x18(:,:,245))
  call heltable([9,2,18], n3(:,846), t3x18(:,:,246))
  call heltable([3,6,18], n3(:,847), t3x18(:,:,247))
  call heltable([2,3,6], n3(:,848), t3x6(:,:,191))
  call heltable([2,3,6], n3(:,849), t3x6(:,:,192))
  call heltable([3,6,18], n3(:,850), t3x18(:,:,248))
  call heltable([2,9,18], n3(:,851), t3x18(:,:,249))
  call heltable([9,2,18], n3(:,852), t3x18(:,:,250))
  call heltable([6,3,18], n3(:,853), t3x18(:,:,251))
  call heltable([3,2,6], n3(:,854), t3x6(:,:,193))
  call heltable([3,2,6], n3(:,855), t3x6(:,:,194))
  call heltable([4,2,8], n3(:,856), t3x8(:,:,61))
  call heltable([4,2,8], n3(:,857), t3x8(:,:,62))
  call heltable([2,4,8], n3(:,858), t3x8(:,:,63))
  call heltable([2,4,8], n3(:,859), t3x8(:,:,64))
  call heltable([6,2,12], n3(:,860), t3x12(:,:,123))
  call heltable([6,3,18], n3(:,861), t3x18(:,:,252))
  call heltable([9,2,18], n3(:,862), t3x18(:,:,253))
  call heltable([2,9,18], n3(:,863), t3x18(:,:,254))
  call heltable([6,3,18], n3(:,864), t3x18(:,:,255))
  call heltable([3,2,6], n3(:,865), t3x6(:,:,195))
  call heltable([3,2,6], n3(:,866), t3x6(:,:,196))
  call heltable([6,2,12], n3(:,867), t3x12(:,:,124))
  call heltable([6,3,18], n3(:,868), t3x18(:,:,256))
  call heltable([9,2,18], n3(:,869), t3x18(:,:,257))
  call heltable([2,9,18], n3(:,870), t3x18(:,:,258))
  call heltable([9,2,18], n3(:,871), t3x18(:,:,259))
  call heltable([9,2,18], n3(:,872), t3x18(:,:,260))
  call heltable([2,9,18], n3(:,873), t3x18(:,:,261))
  call heltable([2,9,18], n3(:,874), t3x18(:,:,262))
  call heltable([2,6,12], n3(:,875), t3x12(:,:,125))
  call heltable([2,6,12], n3(:,876), t3x12(:,:,126))
  call heltable([3,6,18], n3(:,877), t3x18(:,:,263))
  call heltable([3,6,18], n3(:,878), t3x18(:,:,264))
  call heltable([6,2,12], n3(:,879), t3x12(:,:,127))
  call heltable([6,2,12], n3(:,880), t3x12(:,:,128))
  call heltable([3,6,18], n3(:,881), t3x18(:,:,265))
  call heltable([3,6,18], n3(:,882), t3x18(:,:,266))
  call heltable([6,3,18], n3(:,883), t3x18(:,:,267))
  call heltable([6,3,18], n3(:,884), t3x18(:,:,268))
  call heltable([6,3,18], n3(:,885), t3x18(:,:,269))
  call heltable([6,3,18], n3(:,886), t3x18(:,:,270))
  n2(302) = 3
  n2(303) = 3
  n2(304) = 3
  n2(305) = 3
  call heltable([2,3,6], n3(:,887), t3x6(:,:,197))
  call heltable([3,2,6], n3(:,888), t3x6(:,:,198))
  call heltable([2,3,6], n3(:,889), t3x6(:,:,199))
  call heltable([3,2,6], n3(:,890), t3x6(:,:,200))
  call heltable([6,4,24], n3(:,891), t3x24(:,:,65))
  n2(306) = 3
  n2(307) = 3
  call heltable([6,4,24], n3(:,892), t3x24(:,:,66))
  call heltable([12,2,24], n3(:,893), t3x24(:,:,67))
  call heltable([12,2,24], n3(:,894), t3x24(:,:,68))
  n2(308) = 2
  n2(309) = 2
  call heltable([4,6,24], n3(:,895), t3x24(:,:,69))
  call heltable([4,6,24], n3(:,896), t3x24(:,:,70))
  call heltable([8,3,24], n3(:,897), t3x24(:,:,71))
  call heltable([12,2,24], n3(:,898), t3x24(:,:,72))
  call heltable([12,2,24], n3(:,899), t3x24(:,:,73))
  call heltable([3,2,6], n3(:,900), t3x6(:,:,201))
  call heltable([3,2,6], n3(:,901), t3x6(:,:,202))
  call heltable([3,2,6], n3(:,902), t3x6(:,:,203))
  call heltable([3,2,6], n3(:,903), t3x6(:,:,204))
  call heltable([3,3,9], n3(:,904), t3x9(:,:,75))
  call heltable([3,3,9], n3(:,905), t3x9(:,:,76))
  call heltable([3,3,9], n3(:,906), t3x9(:,:,77))
  call heltable([3,3,9], n3(:,907), t3x9(:,:,78))
  call heltable([2,3,6], n3(:,908), t3x6(:,:,205))
  call heltable([2,3,6], n3(:,909), t3x6(:,:,206))
  call heltable([2,2,4], n3(:,910), t3x4(:,:,49))
  call heltable([2,2,4], n3(:,911), t3x4(:,:,50))
  call heltable([6,4,24], n3(:,912), t3x24(:,:,74))
  n2(310) = 3
  n2(311) = 3
  call heltable([6,4,24], n3(:,913), t3x24(:,:,75))
  call heltable([12,2,24], n3(:,914), t3x24(:,:,76))
  call heltable([12,2,24], n3(:,915), t3x24(:,:,77))
  call heltable([4,6,24], n3(:,916), t3x24(:,:,78))
  call heltable([4,6,24], n3(:,917), t3x24(:,:,79))
  call heltable([8,3,24], n3(:,918), t3x24(:,:,80))
  call heltable([12,2,24], n3(:,919), t3x24(:,:,81))
  call heltable([12,2,24], n3(:,920), t3x24(:,:,82))
  call heltable([3,2,6], n3(:,921), t3x6(:,:,207))
  call heltable([3,2,6], n3(:,922), t3x6(:,:,208))
  call heltable([3,2,6], n3(:,923), t3x6(:,:,209))
  call heltable([3,2,6], n3(:,924), t3x6(:,:,210))
  call heltable([3,3,9], n3(:,925), t3x9(:,:,79))
  call heltable([3,3,9], n3(:,926), t3x9(:,:,80))
  call heltable([3,3,9], n3(:,927), t3x9(:,:,81))
  call heltable([3,3,9], n3(:,928), t3x9(:,:,82))
  call heltable([2,3,6], n3(:,929), t3x6(:,:,211))
  call heltable([2,3,6], n3(:,930), t3x6(:,:,212))
  call heltable([4,6,24], n3(:,931), t3x24(:,:,83))
  call heltable([4,6,24], n3(:,932), t3x24(:,:,84))
  call heltable([2,12,24], n3(:,933), t3x24(:,:,85))
  call heltable([2,12,24], n3(:,934), t3x24(:,:,86))
  n2(312) = 2
  n2(313) = 2
  call heltable([6,4,24], n3(:,935), t3x24(:,:,87))
  call heltable([6,4,24], n3(:,936), t3x24(:,:,88))
  call heltable([8,3,24], n3(:,937), t3x24(:,:,89))
  call heltable([2,12,24], n3(:,938), t3x24(:,:,90))
  call heltable([2,12,24], n3(:,939), t3x24(:,:,91))
  call heltable([2,3,6], n3(:,940), t3x6(:,:,213))
  call heltable([2,3,6], n3(:,941), t3x6(:,:,214))
  call heltable([2,3,6], n3(:,942), t3x6(:,:,215))
  call heltable([2,3,6], n3(:,943), t3x6(:,:,216))
  call heltable([3,3,9], n3(:,944), t3x9(:,:,83))
  call heltable([3,3,9], n3(:,945), t3x9(:,:,84))
  call heltable([3,2,6], n3(:,946), t3x6(:,:,217))
  call heltable([3,2,6], n3(:,947), t3x6(:,:,218))
  call heltable([2,2,4], n3(:,948), t3x4(:,:,51))
  call heltable([2,2,4], n3(:,949), t3x4(:,:,52))
  call heltable([4,6,24], n3(:,950), t3x24(:,:,92))
  call heltable([4,6,24], n3(:,951), t3x24(:,:,93))
  call heltable([2,12,24], n3(:,952), t3x24(:,:,94))
  call heltable([2,12,24], n3(:,953), t3x24(:,:,95))
  call heltable([6,4,24], n3(:,954), t3x24(:,:,96))
  call heltable([6,4,24], n3(:,955), t3x24(:,:,97))
  call heltable([8,3,24], n3(:,956), t3x24(:,:,98))
  call heltable([2,12,24], n3(:,957), t3x24(:,:,99))
  call heltable([2,12,24], n3(:,958), t3x24(:,:,100))
  call heltable([2,3,6], n3(:,959), t3x6(:,:,219))
  call heltable([2,3,6], n3(:,960), t3x6(:,:,220))
  call heltable([2,3,6], n3(:,961), t3x6(:,:,221))
  call heltable([2,3,6], n3(:,962), t3x6(:,:,222))
  call heltable([3,3,9], n3(:,963), t3x9(:,:,85))
  call heltable([3,3,9], n3(:,964), t3x9(:,:,86))
  call heltable([3,2,6], n3(:,965), t3x6(:,:,223))
  call heltable([3,2,6], n3(:,966), t3x6(:,:,224))
  n2(314) = 2
  n2(315) = 2
  n2(316) = 2
  n2(317) = 2
  call heltable([2,3,6], n3(:,967), t3x6(:,:,225))
  call heltable([2,3,6], n3(:,968), t3x6(:,:,226))
  call heltable([2,2,4], n3(:,969), t3x4(:,:,53))
  call heltable([2,2,4], n3(:,970), t3x4(:,:,54))
  call heltable([2,3,6], n3(:,971), t3x6(:,:,227))
  call heltable([2,3,6], n3(:,972), t3x6(:,:,228))
  call heltable([3,2,6], n3(:,973), t3x6(:,:,229))
  call heltable([3,2,6], n3(:,974), t3x6(:,:,230))
  call heltable([2,2,4], n3(:,975), t3x4(:,:,55))
  call heltable([2,2,4], n3(:,976), t3x4(:,:,56))
  call heltable([3,2,6], n3(:,977), t3x6(:,:,231))
  call heltable([3,2,6], n3(:,978), t3x6(:,:,232))
  n2(318) = 2
  n2(319) = 2
  call heltable([2,2,4], n3(:,979), t3x4(:,:,57))
  call heltable([9,2,18], n3(:,980), t3x18(:,:,271))
  n2(320) = 4
  n2(321) = 2
  call heltable([2,2,4], n3(:,981), t3x4(:,:,58))
  n2(322) = 4
  n2(323) = 2
  call heltable([9,2,18], n3(:,982), t3x18(:,:,272))
  call heltable([2,2,4], n3(:,983), t3x4(:,:,59))
  call heltable([2,9,18], n3(:,984), t3x18(:,:,273))
  n2(324) = 4
  call heltable([2,9,18], n3(:,985), t3x18(:,:,274))
  call heltable([2,2,4], n3(:,986), t3x4(:,:,60))
  n2(325) = 4
  call heltable([3,2,6], n3(:,987), t3x6(:,:,233))
  call heltable([2,3,6], n3(:,988), t3x6(:,:,234))
  n2(326) = 6
  n2(327) = 6
  call heltable([2,6,12], n3(:,989), t3x12(:,:,129))
  call heltable([3,2,6], n3(:,990), t3x6(:,:,235))
  n2(328) = 6
  call heltable([2,6,12], n3(:,991), t3x12(:,:,130))
  call heltable([2,3,6], n3(:,992), t3x6(:,:,236))
  n2(329) = 6
  call heltable([3,6,18], n3(:,993), t3x18(:,:,275))
  call heltable([3,6,18], n3(:,994), t3x18(:,:,276))
  call heltable([2,3,6], n3(:,995), t3x6(:,:,237))
  call heltable([3,2,6], n3(:,996), t3x6(:,:,238))
  n2(330) = 6
  n2(331) = 6
  call heltable([6,2,12], n3(:,997), t3x12(:,:,131))
  call heltable([3,2,6], n3(:,998), t3x6(:,:,239))
  n2(332) = 6
  call heltable([2,3,6], n3(:,999), t3x6(:,:,240))
  n2(333) = 6
  call heltable([6,2,12], n3(:,1000), t3x12(:,:,132))
  call heltable([3,6,18], n3(:,1001), t3x18(:,:,277))
  call heltable([3,6,18], n3(:,1002), t3x18(:,:,278))
  call heltable([6,3,18], n3(:,1003), t3x18(:,:,279))
  call heltable([6,3,18], n3(:,1004), t3x18(:,:,280))
  call heltable([6,3,18], n3(:,1005), t3x18(:,:,281))
  call heltable([6,3,18], n3(:,1006), t3x18(:,:,282))
  n2(334) = 2
  n2(335) = 2
  n2(336) = 2
  n2(337) = 2
  n2(338) = 2
  n2(339) = 2
  n2(340) = 2
  n2(341) = 2
  call heltable([2,3,6], n3(:,1007), t3x6(:,:,241))
  call heltable([2,3,6], n3(:,1008), t3x6(:,:,242))
  call heltable([2,3,6], n3(:,1009), t3x6(:,:,243))
  call heltable([2,3,6], n3(:,1010), t3x6(:,:,244))
  call heltable([2,2,4], n3(:,1011), t3x4(:,:,61))
  call heltable([2,2,4], n3(:,1012), t3x4(:,:,62))
  call heltable([2,2,4], n3(:,1013), t3x4(:,:,63))
  call heltable([2,2,4], n3(:,1014), t3x4(:,:,64))
  call heltable([2,3,6], n3(:,1015), t3x6(:,:,245))
  call heltable([2,3,6], n3(:,1016), t3x6(:,:,246))
  call heltable([2,3,6], n3(:,1017), t3x6(:,:,247))
  call heltable([2,3,6], n3(:,1018), t3x6(:,:,248))
  call heltable([3,2,6], n3(:,1019), t3x6(:,:,249))
  call heltable([3,2,6], n3(:,1020), t3x6(:,:,250))
  call heltable([3,2,6], n3(:,1021), t3x6(:,:,251))
  call heltable([3,2,6], n3(:,1022), t3x6(:,:,252))
  call heltable([2,2,4], n3(:,1023), t3x4(:,:,65))
  call heltable([2,2,4], n3(:,1024), t3x4(:,:,66))
  call heltable([2,2,4], n3(:,1025), t3x4(:,:,67))
  call heltable([2,2,4], n3(:,1026), t3x4(:,:,68))
  call heltable([3,2,6], n3(:,1027), t3x6(:,:,253))
  call heltable([3,2,6], n3(:,1028), t3x6(:,:,254))
  call heltable([3,2,6], n3(:,1029), t3x6(:,:,255))
  call heltable([3,2,6], n3(:,1030), t3x6(:,:,256))
  call heltable([2,3,6], n3(:,1031), t3x6(:,:,257))
  n2(342) = 6
  call heltable([3,4,12], n3(:,1032), t3x12(:,:,133))
  call heltable([2,3,6], n3(:,1033), t3x6(:,:,258))
  n2(343) = 6
  call heltable([3,4,12], n3(:,1034), t3x12(:,:,134))
  call heltable([2,4,8], n3(:,1035), t3x8(:,:,65))
  call heltable([4,2,8], n3(:,1036), t3x8(:,:,66))
  call heltable([4,2,8], n3(:,1037), t3x8(:,:,67))
  call heltable([3,2,6], n3(:,1038), t3x6(:,:,259))
  n2(344) = 6
  call heltable([4,3,12], n3(:,1039), t3x12(:,:,135))
  call heltable([3,2,6], n3(:,1040), t3x6(:,:,260))
  n2(345) = 6
  call heltable([4,3,12], n3(:,1041), t3x12(:,:,136))
  call heltable([4,2,8], n3(:,1042), t3x8(:,:,68))
  call heltable([2,4,8], n3(:,1043), t3x8(:,:,69))
  call heltable([2,4,8], n3(:,1044), t3x8(:,:,70))
  call heltable([2,6,12], n3(:,1045), t3x12(:,:,137))
  call heltable([2,6,12], n3(:,1046), t3x12(:,:,138))
  call heltable([2,3,6], n3(:,1047), t3x6(:,:,261))
  call heltable([2,4,8], n3(:,1048), t3x8(:,:,71))
  call heltable([4,2,8], n3(:,1049), t3x8(:,:,72))
  call heltable([4,2,8], n3(:,1050), t3x8(:,:,73))
  call heltable([2,3,6], n3(:,1051), t3x6(:,:,262))
  call heltable([4,2,8], n3(:,1052), t3x8(:,:,74))
  call heltable([2,4,8], n3(:,1053), t3x8(:,:,75))
  call heltable([2,4,8], n3(:,1054), t3x8(:,:,76))
  call heltable([6,2,12], n3(:,1055), t3x12(:,:,139))
  call heltable([6,2,12], n3(:,1056), t3x12(:,:,140))
  call heltable([3,2,6], n3(:,1057), t3x6(:,:,263))
  call heltable([4,2,8], n3(:,1058), t3x8(:,:,77))
  call heltable([2,4,8], n3(:,1059), t3x8(:,:,78))
  call heltable([2,4,8], n3(:,1060), t3x8(:,:,79))
  call heltable([3,2,6], n3(:,1061), t3x6(:,:,264))
  call heltable([2,4,8], n3(:,1062), t3x8(:,:,80))
  call heltable([4,2,8], n3(:,1063), t3x8(:,:,81))
  call heltable([4,2,8], n3(:,1064), t3x8(:,:,82))
  call heltable([3,6,18], n3(:,1065), t3x18(:,:,283))
  n2(346) = 2
  call heltable([2,2,4], n3(:,1066), t3x4(:,:,69))
  call heltable([3,6,18], n3(:,1067), t3x18(:,:,284))
  n2(347) = 4
  n2(348) = 2
  call heltable([2,2,4], n3(:,1068), t3x4(:,:,70))
  n2(349) = 4
  call heltable([2,3,6], n3(:,1069), t3x6(:,:,265))
  call heltable([2,3,6], n3(:,1070), t3x6(:,:,266))
  call heltable([6,3,18], n3(:,1071), t3x18(:,:,285))
  call heltable([2,4,8], n3(:,1072), t3x8(:,:,83))
  call heltable([2,4,8], n3(:,1073), t3x8(:,:,84))
  call heltable([4,2,8], n3(:,1074), t3x8(:,:,85))
  call heltable([4,2,8], n3(:,1075), t3x8(:,:,86))
  call heltable([9,2,18], n3(:,1076), t3x18(:,:,286))
  call heltable([9,2,18], n3(:,1077), t3x18(:,:,287))
  call heltable([2,9,18], n3(:,1078), t3x18(:,:,288))
  call heltable([2,9,18], n3(:,1079), t3x18(:,:,289))
  call heltable([2,3,6], n3(:,1080), t3x6(:,:,267))
  n2(350) = 6
  call heltable([2,3,6], n3(:,1081), t3x6(:,:,268))
  n2(351) = 6
  call heltable([4,2,8], n3(:,1082), t3x8(:,:,87))
  call heltable([4,2,8], n3(:,1083), t3x8(:,:,88))
  call heltable([2,4,8], n3(:,1084), t3x8(:,:,89))
  call heltable([2,4,8], n3(:,1085), t3x8(:,:,90))
  call heltable([2,9,18], n3(:,1086), t3x18(:,:,290))
  call heltable([9,2,18], n3(:,1087), t3x18(:,:,291))
  call heltable([3,6,18], n3(:,1088), t3x18(:,:,292))
  n2(352) = 18
  n2(353) = 2
  call heltable([2,2,4], n3(:,1089), t3x4(:,:,71))
  call heltable([6,3,18], n3(:,1090), t3x18(:,:,293))
  n2(354) = 4
  n2(355) = 2
  call heltable([2,2,4], n3(:,1091), t3x4(:,:,72))
  n2(356) = 4
  call heltable([3,2,6], n3(:,1092), t3x6(:,:,269))
  call heltable([3,2,6], n3(:,1093), t3x6(:,:,270))
  call heltable([2,9,18], n3(:,1094), t3x18(:,:,294))
  call heltable([2,9,18], n3(:,1095), t3x18(:,:,295))
  call heltable([9,2,18], n3(:,1096), t3x18(:,:,296))
  call heltable([9,2,18], n3(:,1097), t3x18(:,:,297))
  call heltable([3,2,6], n3(:,1098), t3x6(:,:,271))
  n2(357) = 6
  call heltable([3,2,6], n3(:,1099), t3x6(:,:,272))
  n2(358) = 6
  call heltable([9,2,18], n3(:,1100), t3x18(:,:,298))
  call heltable([2,9,18], n3(:,1101), t3x18(:,:,299))
  call heltable([6,3,18], n3(:,1102), t3x18(:,:,300))
  n2(359) = 18
  call heltable([3,6,18], n3(:,1103), t3x18(:,:,301))
  call heltable([3,6,18], n3(:,1104), t3x18(:,:,302))
  call heltable([2,3,6], n3(:,1105), t3x6(:,:,273))
  call heltable([2,3,6], n3(:,1106), t3x6(:,:,274))
  call heltable([6,3,18], n3(:,1107), t3x18(:,:,303))
  call heltable([9,2,18], n3(:,1108), t3x18(:,:,304))
  call heltable([9,2,18], n3(:,1109), t3x18(:,:,305))
  call heltable([2,9,18], n3(:,1110), t3x18(:,:,306))
  call heltable([2,9,18], n3(:,1111), t3x18(:,:,307))
  call heltable([2,3,6], n3(:,1112), t3x6(:,:,275))
  n2(360) = 6
  call heltable([2,3,6], n3(:,1113), t3x6(:,:,276))
  n2(361) = 6
  call heltable([2,9,18], n3(:,1114), t3x18(:,:,308))
  call heltable([9,2,18], n3(:,1115), t3x18(:,:,309))
  call heltable([3,6,18], n3(:,1116), t3x18(:,:,310))
  n2(362) = 18
  call heltable([6,3,18], n3(:,1117), t3x18(:,:,311))
  call heltable([3,2,6], n3(:,1118), t3x6(:,:,277))
  call heltable([3,2,6], n3(:,1119), t3x6(:,:,278))
  call heltable([2,9,18], n3(:,1120), t3x18(:,:,312))
  call heltable([2,9,18], n3(:,1121), t3x18(:,:,313))
  call heltable([9,2,18], n3(:,1122), t3x18(:,:,314))
  call heltable([9,2,18], n3(:,1123), t3x18(:,:,315))
  call heltable([3,2,6], n3(:,1124), t3x6(:,:,279))
  n2(363) = 6
  call heltable([3,2,6], n3(:,1125), t3x6(:,:,280))
  n2(364) = 6
  call heltable([9,2,18], n3(:,1126), t3x18(:,:,316))
  call heltable([2,9,18], n3(:,1127), t3x18(:,:,317))
  call heltable([6,3,18], n3(:,1128), t3x18(:,:,318))
  n2(365) = 18
  call heltable([2,3,6], n3(:,1129), t3x6(:,:,281))
  call heltable([2,3,6], n3(:,1130), t3x6(:,:,282))
  call heltable([2,4,8], n3(:,1131), t3x8(:,:,91))
  call heltable([2,4,8], n3(:,1132), t3x8(:,:,92))
  call heltable([4,2,8], n3(:,1133), t3x8(:,:,93))
  call heltable([4,2,8], n3(:,1134), t3x8(:,:,94))
  call heltable([2,3,6], n3(:,1135), t3x6(:,:,283))
  call heltable([2,3,6], n3(:,1136), t3x6(:,:,284))
  call heltable([3,2,6], n3(:,1137), t3x6(:,:,285))
  call heltable([3,2,6], n3(:,1138), t3x6(:,:,286))
  call heltable([4,2,8], n3(:,1139), t3x8(:,:,95))
  call heltable([4,2,8], n3(:,1140), t3x8(:,:,96))
  call heltable([2,4,8], n3(:,1141), t3x8(:,:,97))
  call heltable([2,4,8], n3(:,1142), t3x8(:,:,98))
  call heltable([3,2,6], n3(:,1143), t3x6(:,:,287))
  call heltable([3,2,6], n3(:,1144), t3x6(:,:,288))
  call heltable([9,2,18], n3(:,1145), t3x18(:,:,319))
  call heltable([9,2,18], n3(:,1146), t3x18(:,:,320))
  call heltable([2,9,18], n3(:,1147), t3x18(:,:,321))
  call heltable([2,9,18], n3(:,1148), t3x18(:,:,322))
  call heltable([2,6,12], n3(:,1149), t3x12(:,:,141))
  call heltable([2,6,12], n3(:,1150), t3x12(:,:,142))
  call heltable([3,6,18], n3(:,1151), t3x18(:,:,323))
  call heltable([3,6,18], n3(:,1152), t3x18(:,:,324))
  call heltable([6,2,12], n3(:,1153), t3x12(:,:,143))
  call heltable([6,2,12], n3(:,1154), t3x12(:,:,144))
  call heltable([3,6,18], n3(:,1155), t3x18(:,:,325))
  call heltable([3,6,18], n3(:,1156), t3x18(:,:,326))
  call heltable([6,3,18], n3(:,1157), t3x18(:,:,327))
  call heltable([6,3,18], n3(:,1158), t3x18(:,:,328))
  call heltable([6,3,18], n3(:,1159), t3x18(:,:,329))
  call heltable([6,3,18], n3(:,1160), t3x18(:,:,330))
  call heltable([6,4,24], n3(:,1161), t3x24(:,:,101))
  call heltable([6,4,24], n3(:,1162), t3x24(:,:,102))
  call heltable([12,2,24], n3(:,1163), t3x24(:,:,103))
  call heltable([12,2,24], n3(:,1164), t3x24(:,:,104))
  n2(366) = 2
  n2(367) = 2
  call heltable([4,6,24], n3(:,1165), t3x24(:,:,105))
  call heltable([4,6,24], n3(:,1166), t3x24(:,:,106))
  call heltable([8,3,24], n3(:,1167), t3x24(:,:,107))
  call heltable([12,2,24], n3(:,1168), t3x24(:,:,108))
  call heltable([12,2,24], n3(:,1169), t3x24(:,:,109))
  call heltable([2,3,6], n3(:,1170), t3x6(:,:,289))
  call heltable([2,3,6], n3(:,1171), t3x6(:,:,290))
  call heltable([2,2,4], n3(:,1172), t3x4(:,:,73))
  call heltable([2,2,4], n3(:,1173), t3x4(:,:,74))
  call heltable([6,4,24], n3(:,1174), t3x24(:,:,110))
  call heltable([6,4,24], n3(:,1175), t3x24(:,:,111))
  call heltable([12,2,24], n3(:,1176), t3x24(:,:,112))
  call heltable([12,2,24], n3(:,1177), t3x24(:,:,113))
  call heltable([4,6,24], n3(:,1178), t3x24(:,:,114))
  call heltable([4,6,24], n3(:,1179), t3x24(:,:,115))
  call heltable([8,3,24], n3(:,1180), t3x24(:,:,116))
  call heltable([12,2,24], n3(:,1181), t3x24(:,:,117))
  call heltable([12,2,24], n3(:,1182), t3x24(:,:,118))
  call heltable([2,3,6], n3(:,1183), t3x6(:,:,291))
  call heltable([2,3,6], n3(:,1184), t3x6(:,:,292))
  call heltable([4,6,24], n3(:,1185), t3x24(:,:,119))
  call heltable([4,6,24], n3(:,1186), t3x24(:,:,120))
  call heltable([2,12,24], n3(:,1187), t3x24(:,:,121))
  call heltable([2,12,24], n3(:,1188), t3x24(:,:,122))
  n2(368) = 2
  n2(369) = 2
  call heltable([6,4,24], n3(:,1189), t3x24(:,:,123))
  call heltable([6,4,24], n3(:,1190), t3x24(:,:,124))
  call heltable([8,3,24], n3(:,1191), t3x24(:,:,125))
  call heltable([2,12,24], n3(:,1192), t3x24(:,:,126))
  call heltable([2,12,24], n3(:,1193), t3x24(:,:,127))
  call heltable([3,2,6], n3(:,1194), t3x6(:,:,293))
  call heltable([3,2,6], n3(:,1195), t3x6(:,:,294))
  call heltable([2,2,4], n3(:,1196), t3x4(:,:,75))
  call heltable([2,2,4], n3(:,1197), t3x4(:,:,76))
  call heltable([4,6,24], n3(:,1198), t3x24(:,:,128))
  call heltable([4,6,24], n3(:,1199), t3x24(:,:,129))
  call heltable([2,12,24], n3(:,1200), t3x24(:,:,130))
  call heltable([2,12,24], n3(:,1201), t3x24(:,:,131))
  call heltable([6,4,24], n3(:,1202), t3x24(:,:,132))
  call heltable([6,4,24], n3(:,1203), t3x24(:,:,133))
  call heltable([8,3,24], n3(:,1204), t3x24(:,:,134))
  call heltable([2,12,24], n3(:,1205), t3x24(:,:,135))
  call heltable([2,12,24], n3(:,1206), t3x24(:,:,136))
  call heltable([3,2,6], n3(:,1207), t3x6(:,:,295))
  call heltable([3,2,6], n3(:,1208), t3x6(:,:,296))
  n2(370) = 2
  n2(371) = 2
  n2(372) = 2
  n2(373) = 2
  call heltable([2,3,6], n3(:,1209), t3x6(:,:,297))
  call heltable([2,3,6], n3(:,1210), t3x6(:,:,298))
  call heltable([2,2,4], n3(:,1211), t3x4(:,:,77))
  call heltable([2,2,4], n3(:,1212), t3x4(:,:,78))
  call heltable([2,3,6], n3(:,1213), t3x6(:,:,299))
  call heltable([2,3,6], n3(:,1214), t3x6(:,:,300))
  call heltable([3,2,6], n3(:,1215), t3x6(:,:,301))
  call heltable([3,2,6], n3(:,1216), t3x6(:,:,302))
  call heltable([2,2,4], n3(:,1217), t3x4(:,:,79))
  call heltable([2,2,4], n3(:,1218), t3x4(:,:,80))
  call heltable([3,2,6], n3(:,1219), t3x6(:,:,303))
  call heltable([3,2,6], n3(:,1220), t3x6(:,:,304))
  call heltable([3,2,6], n3(:,1221), t3x6(:,:,305))
  call heltable([3,2,6], n3(:,1222), t3x6(:,:,306))
  call heltable([3,2,6], n3(:,1223), t3x6(:,:,307))
  call heltable([3,2,6], n3(:,1224), t3x6(:,:,308))
  call heltable([3,2,6], n3(:,1225), t3x6(:,:,309))
  call heltable([3,2,6], n3(:,1226), t3x6(:,:,310))
  call heltable([3,2,6], n3(:,1227), t3x6(:,:,311))
  call heltable([3,2,6], n3(:,1228), t3x6(:,:,312))
  call heltable([2,3,6], n3(:,1229), t3x6(:,:,313))
  call heltable([2,3,6], n3(:,1230), t3x6(:,:,314))
  call heltable([2,3,6], n3(:,1231), t3x6(:,:,315))
  call heltable([2,3,6], n3(:,1232), t3x6(:,:,316))
  call heltable([2,3,6], n3(:,1233), t3x6(:,:,317))
  call heltable([2,3,6], n3(:,1234), t3x6(:,:,318))
  call heltable([2,3,6], n3(:,1235), t3x6(:,:,319))
  call heltable([2,3,6], n3(:,1236), t3x6(:,:,320))
  call heltable([3,2,6], n3(:,1237), t3x6(:,:,321))
  call heltable([3,2,6], n3(:,1238), t3x6(:,:,322))
  call heltable([3,2,6], n3(:,1239), t3x6(:,:,323))
  call heltable([3,2,6], n3(:,1240), t3x6(:,:,324))
  call heltable([3,2,6], n3(:,1241), t3x6(:,:,325))
  call heltable([3,2,6], n3(:,1242), t3x6(:,:,326))
  call heltable([3,2,6], n3(:,1243), t3x6(:,:,327))
  call heltable([3,2,6], n3(:,1244), t3x6(:,:,328))
  call heltable([2,3,6], n3(:,1245), t3x6(:,:,329))
  call heltable([2,3,6], n3(:,1246), t3x6(:,:,330))
  call heltable([2,3,6], n3(:,1247), t3x6(:,:,331))
  call heltable([2,3,6], n3(:,1248), t3x6(:,:,332))
  call heltable([2,3,6], n3(:,1249), t3x6(:,:,333))
  call heltable([2,3,6], n3(:,1250), t3x6(:,:,334))
  call heltable([2,3,6], n3(:,1251), t3x6(:,:,335))
  call heltable([2,3,6], n3(:,1252), t3x6(:,:,336))
  n2(374) = 2
  call heltable([2,3,6], n3(:,1253), t3x6(:,:,337))
  call heltable([2,2,4], n3(:,1254), t3x4(:,:,81))
  call heltable([2,3,6], n3(:,1255), t3x6(:,:,338))
  n2(375) = 2
  call heltable([3,2,6], n3(:,1256), t3x6(:,:,339))
  call heltable([2,2,4], n3(:,1257), t3x4(:,:,82))
  call heltable([3,2,6], n3(:,1258), t3x6(:,:,340))
  n2(376) = 2
  n2(377) = 2
  call heltable([2,3,6], n3(:,1259), t3x6(:,:,341))
  call heltable([2,2,4], n3(:,1260), t3x4(:,:,83))
  call heltable([2,3,6], n3(:,1261), t3x6(:,:,342))
  call heltable([3,2,6], n3(:,1262), t3x6(:,:,343))
  call heltable([2,2,4], n3(:,1263), t3x4(:,:,84))
  call heltable([3,2,6], n3(:,1264), t3x6(:,:,344))
  n2(378) = 2
  call heltable([2,3,6], n3(:,1265), t3x6(:,:,345))
  call heltable([2,2,4], n3(:,1266), t3x4(:,:,85))
  call heltable([2,3,6], n3(:,1267), t3x6(:,:,346))
  n2(379) = 2
  call heltable([3,2,6], n3(:,1268), t3x6(:,:,347))
  call heltable([2,2,4], n3(:,1269), t3x4(:,:,86))
  call heltable([3,2,6], n3(:,1270), t3x6(:,:,348))
  n2(380) = 2
  n2(381) = 2
  call heltable([2,3,6], n3(:,1271), t3x6(:,:,349))
  call heltable([2,2,4], n3(:,1272), t3x4(:,:,87))
  call heltable([2,3,6], n3(:,1273), t3x6(:,:,350))
  call heltable([3,2,6], n3(:,1274), t3x6(:,:,351))
  call heltable([2,2,4], n3(:,1275), t3x4(:,:,88))
  call heltable([3,2,6], n3(:,1276), t3x6(:,:,352))
  n2(382) = 2
  n2(383) = 2
  n2(384) = 2
  n2(385) = 2
  call heltable([2,3,6], n3(:,1277), t3x6(:,:,353))
  call heltable([2,3,6], n3(:,1278), t3x6(:,:,354))
  call heltable([2,2,4], n3(:,1279), t3x4(:,:,89))
  call heltable([2,2,4], n3(:,1280), t3x4(:,:,90))
  call heltable([2,3,6], n3(:,1281), t3x6(:,:,355))
  call heltable([2,3,6], n3(:,1282), t3x6(:,:,356))
  call heltable([3,2,6], n3(:,1283), t3x6(:,:,357))
  call heltable([3,2,6], n3(:,1284), t3x6(:,:,358))
  call heltable([2,2,4], n3(:,1285), t3x4(:,:,91))
  call heltable([2,2,4], n3(:,1286), t3x4(:,:,92))
  call heltable([3,2,6], n3(:,1287), t3x6(:,:,359))
  call heltable([3,2,6], n3(:,1288), t3x6(:,:,360))
  call heltable([2,4,8], n3(:,1289), t3x8(:,:,99))
  call heltable([4,2,8], n3(:,1290), t3x8(:,:,100))
  call heltable([4,2,8], n3(:,1291), t3x8(:,:,101))
  call heltable([2,3,6], n3(:,1292), t3x6(:,:,361))
  call heltable([2,3,6], n3(:,1293), t3x6(:,:,362))
  call heltable([4,2,8], n3(:,1294), t3x8(:,:,102))
  call heltable([2,4,8], n3(:,1295), t3x8(:,:,103))
  call heltable([2,4,8], n3(:,1296), t3x8(:,:,104))
  call heltable([3,2,6], n3(:,1297), t3x6(:,:,363))
  call heltable([3,2,6], n3(:,1298), t3x6(:,:,364))
  call heltable([3,6,18], n3(:,1299), t3x18(:,:,331))
  call heltable([3,6,18], n3(:,1300), t3x18(:,:,332))
  call heltable([3,6,18], n3(:,1301), t3x18(:,:,333))
  call heltable([3,6,18], n3(:,1302), t3x18(:,:,334))
  call heltable([6,3,18], n3(:,1303), t3x18(:,:,335))
  call heltable([6,3,18], n3(:,1304), t3x18(:,:,336))
  call heltable([6,3,18], n3(:,1305), t3x18(:,:,337))
  call heltable([6,3,18], n3(:,1306), t3x18(:,:,338))
  call heltable([9,2,18], n3(:,1307), t3x18(:,:,339))
  call heltable([2,9,18], n3(:,1308), t3x18(:,:,340))
  call heltable([2,9,18], n3(:,1309), t3x18(:,:,341))
  call heltable([9,2,18], n3(:,1310), t3x18(:,:,342))
  call heltable([3,6,18], n3(:,1311), t3x18(:,:,343))
  call heltable([3,6,18], n3(:,1312), t3x18(:,:,344))
  call heltable([3,6,18], n3(:,1313), t3x18(:,:,345))
  call heltable([3,6,18], n3(:,1314), t3x18(:,:,346))
  call heltable([6,3,18], n3(:,1315), t3x18(:,:,347))
  call heltable([6,3,18], n3(:,1316), t3x18(:,:,348))
  call heltable([6,3,18], n3(:,1317), t3x18(:,:,349))
  call heltable([6,3,18], n3(:,1318), t3x18(:,:,350))
  call heltable([9,2,18], n3(:,1319), t3x18(:,:,351))
  call heltable([2,9,18], n3(:,1320), t3x18(:,:,352))
  call heltable([2,9,18], n3(:,1321), t3x18(:,:,353))
  call heltable([9,2,18], n3(:,1322), t3x18(:,:,354))
  call heltable([2,4,8], n3(:,1323), t3x8(:,:,105))
  call heltable([4,2,8], n3(:,1324), t3x8(:,:,106))
  call heltable([4,2,8], n3(:,1325), t3x8(:,:,107))
  call heltable([2,3,6], n3(:,1326), t3x6(:,:,365))
  call heltable([2,3,6], n3(:,1327), t3x6(:,:,366))
  call heltable([4,2,8], n3(:,1328), t3x8(:,:,108))
  call heltable([2,4,8], n3(:,1329), t3x8(:,:,109))
  call heltable([2,4,8], n3(:,1330), t3x8(:,:,110))
  call heltable([3,2,6], n3(:,1331), t3x6(:,:,367))
  call heltable([3,2,6], n3(:,1332), t3x6(:,:,368))
  call heltable([3,6,18], n3(:,1333), t3x18(:,:,355))
  call heltable([3,6,18], n3(:,1334), t3x18(:,:,356))
  call heltable([3,6,18], n3(:,1335), t3x18(:,:,357))
  call heltable([3,6,18], n3(:,1336), t3x18(:,:,358))
  call heltable([6,3,18], n3(:,1337), t3x18(:,:,359))
  call heltable([6,3,18], n3(:,1338), t3x18(:,:,360))
  call heltable([6,3,18], n3(:,1339), t3x18(:,:,361))
  call heltable([6,3,18], n3(:,1340), t3x18(:,:,362))
  call heltable([9,2,18], n3(:,1341), t3x18(:,:,363))
  call heltable([2,9,18], n3(:,1342), t3x18(:,:,364))
  call heltable([2,9,18], n3(:,1343), t3x18(:,:,365))
  call heltable([9,2,18], n3(:,1344), t3x18(:,:,366))
  call heltable([3,6,18], n3(:,1345), t3x18(:,:,367))
  call heltable([3,6,18], n3(:,1346), t3x18(:,:,368))
  call heltable([3,6,18], n3(:,1347), t3x18(:,:,369))
  call heltable([3,6,18], n3(:,1348), t3x18(:,:,370))
  call heltable([6,3,18], n3(:,1349), t3x18(:,:,371))
  call heltable([6,3,18], n3(:,1350), t3x18(:,:,372))
  call heltable([6,3,18], n3(:,1351), t3x18(:,:,373))
  call heltable([6,3,18], n3(:,1352), t3x18(:,:,374))
  call heltable([9,2,18], n3(:,1353), t3x18(:,:,375))
  call heltable([2,9,18], n3(:,1354), t3x18(:,:,376))
  call heltable([2,9,18], n3(:,1355), t3x18(:,:,377))
  call heltable([9,2,18], n3(:,1356), t3x18(:,:,378))
  call heltable([6,12,72], n3(:,1357), t3x72(:,:,1))
  call heltable([4,18,72], n3(:,1358), t3x72(:,:,2))
  call heltable([6,12,72], n3(:,1359), t3x72(:,:,3))
  call heltable([6,12,72], n3(:,1360), t3x72(:,:,4))
  call heltable([4,18,72], n3(:,1361), t3x72(:,:,5))
  call heltable([6,12,72], n3(:,1362), t3x72(:,:,6))
  call heltable([9,8,72], n3(:,1363), t3x72(:,:,7))
  call heltable([9,8,72], n3(:,1364), t3x72(:,:,8))
  call heltable([12,6,72], n3(:,1365), t3x72(:,:,9))
  call heltable([18,4,72], n3(:,1366), t3x72(:,:,10))
  call heltable([12,6,72], n3(:,1367), t3x72(:,:,11))
  call heltable([4,18,72], n3(:,1368), t3x72(:,:,12))
  call heltable([2,36,72], n3(:,1369), t3x72(:,:,13))
  call heltable([4,18,72], n3(:,1370), t3x72(:,:,14))
  call heltable([6,12,72], n3(:,1371), t3x72(:,:,15))
  call heltable([6,12,72], n3(:,1372), t3x72(:,:,16))
  call heltable([12,6,72], n3(:,1373), t3x72(:,:,17))
  call heltable([18,4,72], n3(:,1374), t3x72(:,:,18))
  call heltable([12,6,72], n3(:,1375), t3x72(:,:,19))
  call heltable([4,18,72], n3(:,1376), t3x72(:,:,20))
  call heltable([2,36,72], n3(:,1377), t3x72(:,:,21))
  call heltable([4,18,72], n3(:,1378), t3x72(:,:,22))
  call heltable([6,12,72], n3(:,1379), t3x72(:,:,23))
  call heltable([6,12,72], n3(:,1380), t3x72(:,:,24))
  call heltable([12,6,72], n3(:,1381), t3x72(:,:,25))
  call heltable([12,6,72], n3(:,1382), t3x72(:,:,26))
  call heltable([18,4,72], n3(:,1383), t3x72(:,:,27))
  call heltable([18,4,72], n3(:,1384), t3x72(:,:,28))
  call heltable([12,6,72], n3(:,1385), t3x72(:,:,29))
  call heltable([12,6,72], n3(:,1386), t3x72(:,:,30))
  call heltable([18,4,72], n3(:,1387), t3x72(:,:,31))
  call heltable([18,4,72], n3(:,1388), t3x72(:,:,32))
  call heltable([36,2,72], n3(:,1389), t3x72(:,:,33))
  call heltable([36,2,72], n3(:,1390), t3x72(:,:,34))
  call heltable([18,4,72], n3(:,1391), t3x72(:,:,35))
  call heltable([18,4,72], n3(:,1392), t3x72(:,:,36))
  call heltable([12,6,72], n3(:,1393), t3x72(:,:,37))
  call heltable([12,6,72], n3(:,1394), t3x72(:,:,38))
  call heltable([12,6,72], n3(:,1395), t3x72(:,:,39))
  call heltable([12,6,72], n3(:,1396), t3x72(:,:,40))
  call heltable([12,6,72], n3(:,1397), t3x72(:,:,41))
  call heltable([12,6,72], n3(:,1398), t3x72(:,:,42))
  call heltable([18,4,72], n3(:,1399), t3x72(:,:,43))
  call heltable([18,4,72], n3(:,1400), t3x72(:,:,44))
  call heltable([12,6,72], n3(:,1401), t3x72(:,:,45))
  call heltable([12,6,72], n3(:,1402), t3x72(:,:,46))
  call heltable([18,4,72], n3(:,1403), t3x72(:,:,47))
  call heltable([18,4,72], n3(:,1404), t3x72(:,:,48))
  call heltable([36,2,72], n3(:,1405), t3x72(:,:,49))
  call heltable([36,2,72], n3(:,1406), t3x72(:,:,50))
  call heltable([18,4,72], n3(:,1407), t3x72(:,:,51))
  call heltable([18,4,72], n3(:,1408), t3x72(:,:,52))
  call heltable([12,6,72], n3(:,1409), t3x72(:,:,53))
  call heltable([12,6,72], n3(:,1410), t3x72(:,:,54))
  call heltable([12,6,72], n3(:,1411), t3x72(:,:,55))
  call heltable([12,6,72], n3(:,1412), t3x72(:,:,56))
  call heltable([24,3,72], n3(:,1413), t3x72(:,:,57))
  call heltable([24,3,72], n3(:,1414), t3x72(:,:,58))
  call heltable([3,24,72], n3(:,1415), t3x72(:,:,59))
  call heltable([3,24,72], n3(:,1416), t3x72(:,:,60))
  call heltable([12,6,72], n3(:,1417), t3x72(:,:,61))
  call heltable([12,6,72], n3(:,1418), t3x72(:,:,62))
  call heltable([12,6,72], n3(:,1419), t3x72(:,:,63))
  call heltable([12,6,72], n3(:,1420), t3x72(:,:,64))
  call heltable([3,24,72], n3(:,1421), t3x72(:,:,65))
  call heltable([3,24,72], n3(:,1422), t3x72(:,:,66))
  call heltable([3,24,72], n3(:,1423), t3x72(:,:,67))
  call heltable([3,24,72], n3(:,1424), t3x72(:,:,68))
  call heltable([12,6,72], n3(:,1425), t3x72(:,:,69))
  call heltable([12,6,72], n3(:,1426), t3x72(:,:,70))
  call heltable([12,6,72], n3(:,1427), t3x72(:,:,71))
  call heltable([12,6,72], n3(:,1428), t3x72(:,:,72))
  call heltable([12,6,72], n3(:,1429), t3x72(:,:,73))
  call heltable([12,6,72], n3(:,1430), t3x72(:,:,74))
  call heltable([12,6,72], n3(:,1431), t3x72(:,:,75))
  call heltable([12,6,72], n3(:,1432), t3x72(:,:,76))
  call heltable([8,9,72], n3(:,1433), t3x72(:,:,77))
  call heltable([8,9,72], n3(:,1434), t3x72(:,:,78))
  call heltable([12,6,72], n3(:,1435), t3x72(:,:,79))
  call heltable([12,6,72], n3(:,1436), t3x72(:,:,80))
  call heltable([12,6,72], n3(:,1437), t3x72(:,:,81))
  call heltable([12,6,72], n3(:,1438), t3x72(:,:,82))
  call heltable([8,9,72], n3(:,1439), t3x72(:,:,83))
  call heltable([8,9,72], n3(:,1440), t3x72(:,:,84))
  call heltable([24,3,72], n3(:,1441), t3x72(:,:,85))
  call heltable([24,3,72], n3(:,1442), t3x72(:,:,86))
  call heltable([3,24,72], n3(:,1443), t3x72(:,:,87))
  call heltable([3,24,72], n3(:,1444), t3x72(:,:,88))
  call heltable([12,6,72], n3(:,1445), t3x72(:,:,89))
  call heltable([12,6,72], n3(:,1446), t3x72(:,:,90))
  call heltable([12,6,72], n3(:,1447), t3x72(:,:,91))
  call heltable([12,6,72], n3(:,1448), t3x72(:,:,92))
  call heltable([3,24,72], n3(:,1449), t3x72(:,:,93))
  call heltable([3,24,72], n3(:,1450), t3x72(:,:,94))
  call heltable([3,24,72], n3(:,1451), t3x72(:,:,95))
  call heltable([3,24,72], n3(:,1452), t3x72(:,:,96))
  call heltable([12,6,72], n3(:,1453), t3x72(:,:,97))
  call heltable([12,6,72], n3(:,1454), t3x72(:,:,98))
  call heltable([12,6,72], n3(:,1455), t3x72(:,:,99))
  call heltable([12,6,72], n3(:,1456), t3x72(:,:,100))
  call heltable([12,6,72], n3(:,1457), t3x72(:,:,101))
  call heltable([12,6,72], n3(:,1458), t3x72(:,:,102))
  call heltable([12,6,72], n3(:,1459), t3x72(:,:,103))
  call heltable([12,6,72], n3(:,1460), t3x72(:,:,104))
  call heltable([8,9,72], n3(:,1461), t3x72(:,:,105))
  call heltable([8,9,72], n3(:,1462), t3x72(:,:,106))
  call heltable([12,6,72], n3(:,1463), t3x72(:,:,107))
  call heltable([12,6,72], n3(:,1464), t3x72(:,:,108))
  call heltable([12,6,72], n3(:,1465), t3x72(:,:,109))
  call heltable([12,6,72], n3(:,1466), t3x72(:,:,110))
  call heltable([8,9,72], n3(:,1467), t3x72(:,:,111))
  call heltable([8,9,72], n3(:,1468), t3x72(:,:,112))
  call heltable([12,6,72], n3(:,1469), t3x72(:,:,113))
  call heltable([18,4,72], n3(:,1470), t3x72(:,:,114))
  call heltable([12,6,72], n3(:,1471), t3x72(:,:,115))
  call heltable([18,4,72], n3(:,1472), t3x72(:,:,116))
  call heltable([36,2,72], n3(:,1473), t3x72(:,:,117))
  call heltable([18,4,72], n3(:,1474), t3x72(:,:,118))
  call heltable([12,6,72], n3(:,1475), t3x72(:,:,119))
  call heltable([12,6,72], n3(:,1476), t3x72(:,:,120))
  call heltable([12,6,72], n3(:,1477), t3x72(:,:,121))
  call heltable([18,4,72], n3(:,1478), t3x72(:,:,122))
  call heltable([12,6,72], n3(:,1479), t3x72(:,:,123))
  call heltable([18,4,72], n3(:,1480), t3x72(:,:,124))
  call heltable([36,2,72], n3(:,1481), t3x72(:,:,125))
  call heltable([18,4,72], n3(:,1482), t3x72(:,:,126))
  call heltable([12,6,72], n3(:,1483), t3x72(:,:,127))
  call heltable([12,6,72], n3(:,1484), t3x72(:,:,128))
  call heltable([18,4,72], n3(:,1485), t3x72(:,:,129))
  call heltable([18,4,72], n3(:,1486), t3x72(:,:,130))
  call heltable([6,12,72], n3(:,1487), t3x72(:,:,131))
  call heltable([4,18,72], n3(:,1488), t3x72(:,:,132))
  call heltable([6,12,72], n3(:,1489), t3x72(:,:,133))
  call heltable([4,18,72], n3(:,1490), t3x72(:,:,134))
  call heltable([4,18,72], n3(:,1491), t3x72(:,:,135))
  call heltable([4,18,72], n3(:,1492), t3x72(:,:,136))
  call heltable([18,4,72], n3(:,1493), t3x72(:,:,137))
  call heltable([18,4,72], n3(:,1494), t3x72(:,:,138))
  call heltable([18,4,72], n3(:,1495), t3x72(:,:,139))
  call heltable([18,4,72], n3(:,1496), t3x72(:,:,140))
  call heltable([6,12,72], n3(:,1497), t3x72(:,:,141))
  call heltable([6,12,72], n3(:,1498), t3x72(:,:,142))
  call heltable([4,18,72], n3(:,1499), t3x72(:,:,143))
  call heltable([4,18,72], n3(:,1500), t3x72(:,:,144))
  call heltable([6,12,72], n3(:,1501), t3x72(:,:,145))
  call heltable([6,12,72], n3(:,1502), t3x72(:,:,146))
  call heltable([4,18,72], n3(:,1503), t3x72(:,:,147))
  call heltable([4,18,72], n3(:,1504), t3x72(:,:,148))
  call heltable([4,18,72], n3(:,1505), t3x72(:,:,149))
  call heltable([4,18,72], n3(:,1506), t3x72(:,:,150))
  call heltable([4,18,72], n3(:,1507), t3x72(:,:,151))
  call heltable([4,18,72], n3(:,1508), t3x72(:,:,152))
  call heltable([8,9,72], n3(:,1509), t3x72(:,:,153))
  call heltable([8,9,72], n3(:,1510), t3x72(:,:,154))
  call heltable([8,9,72], n3(:,1511), t3x72(:,:,155))
  call heltable([8,9,72], n3(:,1512), t3x72(:,:,156))
  call heltable([9,8,72], n3(:,1513), t3x72(:,:,157))
  call heltable([9,8,72], n3(:,1514), t3x72(:,:,158))
  call heltable([8,9,72], n3(:,1515), t3x72(:,:,159))
  call heltable([8,9,72], n3(:,1516), t3x72(:,:,160))
  call heltable([9,8,72], n3(:,1517), t3x72(:,:,161))
  call heltable([9,8,72], n3(:,1518), t3x72(:,:,162))
  call heltable([9,8,72], n3(:,1519), t3x72(:,:,163))
  call heltable([9,8,72], n3(:,1520), t3x72(:,:,164))
  call heltable([18,4,72], n3(:,1521), t3x72(:,:,165))
  call heltable([12,6,72], n3(:,1522), t3x72(:,:,166))
  call heltable([9,8,72], n3(:,1523), t3x72(:,:,167))
  call heltable([9,8,72], n3(:,1524), t3x72(:,:,168))
  call heltable([12,6,72], n3(:,1525), t3x72(:,:,169))
  call heltable([12,6,72], n3(:,1526), t3x72(:,:,170))
  call heltable([6,12,72], n3(:,1527), t3x72(:,:,171))
  call heltable([4,18,72], n3(:,1528), t3x72(:,:,172))
  call heltable([4,18,72], n3(:,1529), t3x72(:,:,173))
  call heltable([4,18,72], n3(:,1530), t3x72(:,:,174))
  call heltable([4,18,72], n3(:,1531), t3x72(:,:,175))
  call heltable([12,6,72], n3(:,1532), t3x72(:,:,176))
  call heltable([8,9,72], n3(:,1533), t3x72(:,:,177))
  call heltable([8,9,72], n3(:,1534), t3x72(:,:,178))
  call heltable([12,6,72], n3(:,1535), t3x72(:,:,179))
  call heltable([12,6,72], n3(:,1536), t3x72(:,:,180))
  call heltable([6,12,72], n3(:,1537), t3x72(:,:,181))
  call heltable([4,18,72], n3(:,1538), t3x72(:,:,182))
  call heltable([4,18,72], n3(:,1539), t3x72(:,:,183))
  call heltable([4,18,72], n3(:,1540), t3x72(:,:,184))
  call heltable([18,4,72], n3(:,1541), t3x72(:,:,185))
  call heltable([12,6,72], n3(:,1542), t3x72(:,:,186))
  call heltable([9,8,72], n3(:,1543), t3x72(:,:,187))
  call heltable([9,8,72], n3(:,1544), t3x72(:,:,188))
  call heltable([12,6,72], n3(:,1545), t3x72(:,:,189))
  call heltable([12,6,72], n3(:,1546), t3x72(:,:,190))
  call heltable([6,12,72], n3(:,1547), t3x72(:,:,191))
  call heltable([4,18,72], n3(:,1548), t3x72(:,:,192))
  call heltable([4,18,72], n3(:,1549), t3x72(:,:,193))
  call heltable([4,18,72], n3(:,1550), t3x72(:,:,194))
  call heltable([4,18,72], n3(:,1551), t3x72(:,:,195))
  call heltable([12,6,72], n3(:,1552), t3x72(:,:,196))
  call heltable([8,9,72], n3(:,1553), t3x72(:,:,197))
  call heltable([8,9,72], n3(:,1554), t3x72(:,:,198))
  call heltable([12,6,72], n3(:,1555), t3x72(:,:,199))
  call heltable([12,6,72], n3(:,1556), t3x72(:,:,200))
  call heltable([6,12,72], n3(:,1557), t3x72(:,:,201))
  call heltable([4,18,72], n3(:,1558), t3x72(:,:,202))
  call heltable([4,18,72], n3(:,1559), t3x72(:,:,203))
  call heltable([4,18,72], n3(:,1560), t3x72(:,:,204))
  call heltable([4,18,72], n3(:,1561), t3x72(:,:,205))
  call heltable([4,18,72], n3(:,1562), t3x72(:,:,206))
  call heltable([6,12,72], n3(:,1563), t3x72(:,:,207))
  call heltable([4,18,72], n3(:,1564), t3x72(:,:,208))
  call heltable([6,12,72], n3(:,1565), t3x72(:,:,209))
  call heltable([4,18,72], n3(:,1566), t3x72(:,:,210))
  call heltable([4,18,72], n3(:,1567), t3x72(:,:,211))
  call heltable([4,18,72], n3(:,1568), t3x72(:,:,212))
  call heltable([12,6,72], n3(:,1569), t3x72(:,:,213))
  call heltable([12,6,72], n3(:,1570), t3x72(:,:,214))
  call heltable([6,12,72], n3(:,1571), t3x72(:,:,215))
  call heltable([6,12,72], n3(:,1572), t3x72(:,:,216))
  call heltable([12,6,72], n3(:,1573), t3x72(:,:,217))
  call heltable([12,6,72], n3(:,1574), t3x72(:,:,218))
  call heltable([18,4,72], n3(:,1575), t3x72(:,:,219))
  call heltable([18,4,72], n3(:,1576), t3x72(:,:,220))
  call heltable([12,6,72], n3(:,1577), t3x72(:,:,221))
  call heltable([12,6,72], n3(:,1578), t3x72(:,:,222))
  call heltable([12,6,72], n3(:,1579), t3x72(:,:,223))
  call heltable([12,6,72], n3(:,1580), t3x72(:,:,224))
  call heltable([18,4,72], n3(:,1581), t3x72(:,:,225))
  call heltable([12,6,72], n3(:,1582), t3x72(:,:,226))
  call heltable([12,6,72], n3(:,1583), t3x72(:,:,227))
  call heltable([12,6,72], n3(:,1584), t3x72(:,:,228))
  call heltable([18,4,72], n3(:,1585), t3x72(:,:,229))
  call heltable([12,6,72], n3(:,1586), t3x72(:,:,230))
  call heltable([18,4,72], n3(:,1587), t3x72(:,:,231))
  call heltable([8,9,72], n3(:,1588), t3x72(:,:,232))
  call heltable([18,4,72], n3(:,1589), t3x72(:,:,233))
  call heltable([8,9,72], n3(:,1590), t3x72(:,:,234))
  call heltable([6,12,72], n3(:,1591), t3x72(:,:,235))
  call heltable([4,18,72], n3(:,1592), t3x72(:,:,236))
  call heltable([6,12,72], n3(:,1593), t3x72(:,:,237))
  call heltable([6,12,72], n3(:,1594), t3x72(:,:,238))
  call heltable([4,18,72], n3(:,1595), t3x72(:,:,239))
  call heltable([6,12,72], n3(:,1596), t3x72(:,:,240))
  call heltable([8,9,72], n3(:,1597), t3x72(:,:,241))
  call heltable([8,9,72], n3(:,1598), t3x72(:,:,242))
  call heltable([18,4,72], n3(:,1599), t3x72(:,:,243))
  call heltable([12,6,72], n3(:,1600), t3x72(:,:,244))
  call heltable([18,4,72], n3(:,1601), t3x72(:,:,245))
  call heltable([9,8,72], n3(:,1602), t3x72(:,:,246))
  call heltable([9,8,72], n3(:,1603), t3x72(:,:,247))
  call heltable([12,6,72], n3(:,1604), t3x72(:,:,248))
  call heltable([12,6,72], n3(:,1605), t3x72(:,:,249))
  call heltable([12,6,72], n3(:,1606), t3x72(:,:,250))
  call heltable([6,12,72], n3(:,1607), t3x72(:,:,251))
  call heltable([6,12,72], n3(:,1608), t3x72(:,:,252))
  call heltable([6,12,72], n3(:,1609), t3x72(:,:,253))
  call heltable([9,8,72], n3(:,1610), t3x72(:,:,254))
  call heltable([9,8,72], n3(:,1611), t3x72(:,:,255))
  call heltable([4,18,72], n3(:,1612), t3x72(:,:,256))
  call heltable([6,12,72], n3(:,1613), t3x72(:,:,257))
  call heltable([4,18,72], n3(:,1614), t3x72(:,:,258))
  call heltable([18,4,72], n3(:,1615), t3x72(:,:,259))
  call heltable([18,4,72], n3(:,1616), t3x72(:,:,260))
  call heltable([6,12,72], n3(:,1617), t3x72(:,:,261))
  call heltable([4,18,72], n3(:,1618), t3x72(:,:,262))
  call heltable([6,12,72], n3(:,1619), t3x72(:,:,263))
  call heltable([4,18,72], n3(:,1620), t3x72(:,:,264))
  call heltable([4,18,72], n3(:,1621), t3x72(:,:,265))
  call heltable([4,18,72], n3(:,1622), t3x72(:,:,266))
  call heltable([36,2,72], n3(:,1623), t3x72(:,:,267))
  call heltable([2,36,72], n3(:,1624), t3x72(:,:,268))
  call heltable([36,2,72], n3(:,1625), t3x72(:,:,269))
  call heltable([2,36,72], n3(:,1626), t3x72(:,:,270))
  call heltable([12,6,72], n3(:,1627), t3x72(:,:,271))
  call heltable([18,4,72], n3(:,1628), t3x72(:,:,272))
  call heltable([12,6,72], n3(:,1629), t3x72(:,:,273))
  call heltable([4,18,72], n3(:,1630), t3x72(:,:,274))
  call heltable([6,12,72], n3(:,1631), t3x72(:,:,275))
  call heltable([6,12,72], n3(:,1632), t3x72(:,:,276))
  call heltable([12,6,72], n3(:,1633), t3x72(:,:,277))
  call heltable([18,4,72], n3(:,1634), t3x72(:,:,278))
  call heltable([12,6,72], n3(:,1635), t3x72(:,:,279))
  call heltable([4,18,72], n3(:,1636), t3x72(:,:,280))
  call heltable([6,12,72], n3(:,1637), t3x72(:,:,281))
  call heltable([6,12,72], n3(:,1638), t3x72(:,:,282))
  call heltable([18,4,72], n3(:,1639), t3x72(:,:,283))
  call heltable([18,4,72], n3(:,1640), t3x72(:,:,284))
  call heltable([4,18,72], n3(:,1641), t3x72(:,:,285))
  call heltable([4,18,72], n3(:,1642), t3x72(:,:,286))
  call heltable([18,4,72], n3(:,1643), t3x72(:,:,287))
  call heltable([18,4,72], n3(:,1644), t3x72(:,:,288))
  call heltable([18,4,72], n3(:,1645), t3x72(:,:,289))
  call heltable([18,4,72], n3(:,1646), t3x72(:,:,290))
  call heltable([4,18,72], n3(:,1647), t3x72(:,:,291))
  call heltable([4,18,72], n3(:,1648), t3x72(:,:,292))
  call heltable([4,18,72], n3(:,1649), t3x72(:,:,293))
  call heltable([4,18,72], n3(:,1650), t3x72(:,:,294))
  call heltable([4,18,72], n3(:,1651), t3x72(:,:,295))
  call heltable([4,18,72], n3(:,1652), t3x72(:,:,296))
  call heltable([4,18,72], n3(:,1653), t3x72(:,:,297))
  call heltable([4,18,72], n3(:,1654), t3x72(:,:,298))
  call heltable([18,4,72], n3(:,1655), t3x72(:,:,299))
  call heltable([4,18,72], n3(:,1656), t3x72(:,:,300))
  call heltable([18,4,72], n3(:,1657), t3x72(:,:,301))
  call heltable([18,4,72], n3(:,1658), t3x72(:,:,302))
  call heltable([4,18,72], n3(:,1659), t3x72(:,:,303))
  call heltable([4,18,72], n3(:,1660), t3x72(:,:,304))
  call heltable([4,18,72], n3(:,1661), t3x72(:,:,305))
  call heltable([4,18,72], n3(:,1662), t3x72(:,:,306))
  call heltable([18,4,72], n3(:,1663), t3x72(:,:,307))
  call heltable([18,4,72], n3(:,1664), t3x72(:,:,308))
  call heltable([18,4,72], n3(:,1665), t3x72(:,:,309))
  call heltable([18,4,72], n3(:,1666), t3x72(:,:,310))
  call heltable([18,4,72], n3(:,1667), t3x72(:,:,311))
  call heltable([18,4,72], n3(:,1668), t3x72(:,:,312))
  call heltable([18,4,72], n3(:,1669), t3x72(:,:,313))
  call heltable([18,4,72], n3(:,1670), t3x72(:,:,314))
  call heltable([6,12,72], n3(:,1671), t3x72(:,:,315))
  call heltable([6,12,72], n3(:,1672), t3x72(:,:,316))
  call heltable([12,6,72], n3(:,1673), t3x72(:,:,317))
  call heltable([12,6,72], n3(:,1674), t3x72(:,:,318))
  call heltable([6,12,72], n3(:,1675), t3x72(:,:,319))
  call heltable([6,12,72], n3(:,1676), t3x72(:,:,320))
  call heltable([6,12,72], n3(:,1677), t3x72(:,:,321))
  call heltable([6,12,72], n3(:,1678), t3x72(:,:,322))
  call heltable([12,6,72], n3(:,1679), t3x72(:,:,323))
  call heltable([12,6,72], n3(:,1680), t3x72(:,:,324))
  call heltable([12,6,72], n3(:,1681), t3x72(:,:,325))
  call heltable([12,6,72], n3(:,1682), t3x72(:,:,326))
  call heltable([12,6,72], n3(:,1683), t3x72(:,:,327))
  call heltable([12,6,72], n3(:,1684), t3x72(:,:,328))
  call heltable([12,6,72], n3(:,1685), t3x72(:,:,329))
  call heltable([12,6,72], n3(:,1686), t3x72(:,:,330))
  call heltable([4,18,72], n3(:,1687), t3x72(:,:,331))
  call heltable([4,18,72], n3(:,1688), t3x72(:,:,332))
  call heltable([4,18,72], n3(:,1689), t3x72(:,:,333))
  call heltable([4,18,72], n3(:,1690), t3x72(:,:,334))
  call heltable([4,18,72], n3(:,1691), t3x72(:,:,335))
  call heltable([4,18,72], n3(:,1692), t3x72(:,:,336))
  call heltable([4,18,72], n3(:,1693), t3x72(:,:,337))
  call heltable([4,18,72], n3(:,1694), t3x72(:,:,338))
  call heltable([4,18,72], n3(:,1695), t3x72(:,:,339))
  call heltable([4,18,72], n3(:,1696), t3x72(:,:,340))
  call heltable([4,18,72], n3(:,1697), t3x72(:,:,341))
  call heltable([4,18,72], n3(:,1698), t3x72(:,:,342))
  call heltable([4,18,72], n3(:,1699), t3x72(:,:,343))
  call heltable([4,18,72], n3(:,1700), t3x72(:,:,344))
  call heltable([4,18,72], n3(:,1701), t3x72(:,:,345))
  call heltable([4,18,72], n3(:,1702), t3x72(:,:,346))
  call heltable([6,12,72], n3(:,1703), t3x72(:,:,347))
  call heltable([12,6,72], n3(:,1704), t3x72(:,:,348))
  call heltable([6,12,72], n3(:,1705), t3x72(:,:,349))
  call heltable([6,12,72], n3(:,1706), t3x72(:,:,350))
  call heltable([12,6,72], n3(:,1707), t3x72(:,:,351))
  call heltable([12,6,72], n3(:,1708), t3x72(:,:,352))
  call heltable([12,6,72], n3(:,1709), t3x72(:,:,353))
  call heltable([12,6,72], n3(:,1710), t3x72(:,:,354))
  call heltable([6,12,72], n3(:,1711), t3x72(:,:,355))
  call heltable([6,12,72], n3(:,1712), t3x72(:,:,356))
  call heltable([6,12,72], n3(:,1713), t3x72(:,:,357))
  call heltable([6,12,72], n3(:,1714), t3x72(:,:,358))
  call heltable([6,12,72], n3(:,1715), t3x72(:,:,359))
  call heltable([6,12,72], n3(:,1716), t3x72(:,:,360))
  call heltable([6,12,72], n3(:,1717), t3x72(:,:,361))
  call heltable([6,12,72], n3(:,1718), t3x72(:,:,362))
  call heltable([4,18,72], n3(:,1719), t3x72(:,:,363))
  call heltable([4,18,72], n3(:,1720), t3x72(:,:,364))
  call heltable([4,18,72], n3(:,1721), t3x72(:,:,365))
  call heltable([4,18,72], n3(:,1722), t3x72(:,:,366))
  call heltable([4,18,72], n3(:,1723), t3x72(:,:,367))
  call heltable([4,18,72], n3(:,1724), t3x72(:,:,368))
  call heltable([4,18,72], n3(:,1725), t3x72(:,:,369))
  call heltable([4,18,72], n3(:,1726), t3x72(:,:,370))
  call heltable([4,18,72], n3(:,1727), t3x72(:,:,371))
  call heltable([4,18,72], n3(:,1728), t3x72(:,:,372))
  call heltable([4,18,72], n3(:,1729), t3x72(:,:,373))
  call heltable([4,18,72], n3(:,1730), t3x72(:,:,374))
  call heltable([4,18,72], n3(:,1731), t3x72(:,:,375))
  call heltable([4,18,72], n3(:,1732), t3x72(:,:,376))
  call heltable([4,18,72], n3(:,1733), t3x72(:,:,377))
  call heltable([4,18,72], n3(:,1734), t3x72(:,:,378))
  call heltable([4,18,72], n3(:,1735), t3x72(:,:,379))
  call heltable([4,18,72], n3(:,1736), t3x72(:,:,380))
  call heltable([4,18,72], n3(:,1737), t3x72(:,:,381))
  call heltable([4,18,72], n3(:,1738), t3x72(:,:,382))
  call heltable([4,18,72], n3(:,1739), t3x72(:,:,383))
  call heltable([4,18,72], n3(:,1740), t3x72(:,:,384))
  call heltable([4,18,72], n3(:,1741), t3x72(:,:,385))
  call heltable([4,18,72], n3(:,1742), t3x72(:,:,386))
  call heltable([4,18,72], n3(:,1743), t3x72(:,:,387))
  call heltable([4,18,72], n3(:,1744), t3x72(:,:,388))
  call heltable([4,18,72], n3(:,1745), t3x72(:,:,389))
  call heltable([4,18,72], n3(:,1746), t3x72(:,:,390))
  call heltable([4,18,72], n3(:,1747), t3x72(:,:,391))
  call heltable([4,18,72], n3(:,1748), t3x72(:,:,392))
  call heltable([4,18,72], n3(:,1749), t3x72(:,:,393))
  call heltable([4,18,72], n3(:,1750), t3x72(:,:,394))
  call heltable([4,18,72], n3(:,1751), t3x72(:,:,395))
  call heltable([4,18,72], n3(:,1752), t3x72(:,:,396))
  call heltable([4,18,72], n3(:,1753), t3x72(:,:,397))
  call heltable([4,18,72], n3(:,1754), t3x72(:,:,398))
  call heltable([4,18,72], n3(:,1755), t3x72(:,:,399))
  call heltable([4,18,72], n3(:,1756), t3x72(:,:,400))
  call heltable([4,18,72], n3(:,1757), t3x72(:,:,401))
  call heltable([4,18,72], n3(:,1758), t3x72(:,:,402))
  call heltable([4,18,72], n3(:,1759), t3x72(:,:,403))
  call heltable([4,18,72], n3(:,1760), t3x72(:,:,404))
  call heltable([4,18,72], n3(:,1761), t3x72(:,:,405))
  call heltable([4,18,72], n3(:,1762), t3x72(:,:,406))
  call heltable([4,18,72], n3(:,1763), t3x72(:,:,407))
  call heltable([4,18,72], n3(:,1764), t3x72(:,:,408))
  call heltable([4,18,72], n3(:,1765), t3x72(:,:,409))
  call heltable([4,18,72], n3(:,1766), t3x72(:,:,410))
  call heltable([36,2,72], n3(:,1767), t3x72(:,:,411))
  call heltable([2,36,72], n3(:,1768), t3x72(:,:,412))
  call heltable([36,2,72], n3(:,1769), t3x72(:,:,413))
  call heltable([36,2,72], n3(:,1770), t3x72(:,:,414))
  call heltable([36,2,72], n3(:,1771), t3x72(:,:,415))
  call heltable([36,2,72], n3(:,1772), t3x72(:,:,416))
  call heltable([36,2,72], n3(:,1773), t3x72(:,:,417))
  call heltable([36,2,72], n3(:,1774), t3x72(:,:,418))
  call heltable([36,2,72], n3(:,1775), t3x72(:,:,419))
  call heltable([36,2,72], n3(:,1776), t3x72(:,:,420))
  call heltable([36,2,72], n3(:,1777), t3x72(:,:,421))
  call heltable([36,2,72], n3(:,1778), t3x72(:,:,422))
  call heltable([36,2,72], n3(:,1779), t3x72(:,:,423))
  call heltable([36,2,72], n3(:,1780), t3x72(:,:,424))
  call heltable([36,2,72], n3(:,1781), t3x72(:,:,425))
  call heltable([36,2,72], n3(:,1782), t3x72(:,:,426))
  call heltable([2,36,72], n3(:,1783), t3x72(:,:,427))
  call heltable([2,36,72], n3(:,1784), t3x72(:,:,428))
  call heltable([2,36,72], n3(:,1785), t3x72(:,:,429))
  call heltable([2,36,72], n3(:,1786), t3x72(:,:,430))
  call heltable([2,36,72], n3(:,1787), t3x72(:,:,431))
  call heltable([2,36,72], n3(:,1788), t3x72(:,:,432))
  call heltable([2,36,72], n3(:,1789), t3x72(:,:,433))
  call heltable([2,36,72], n3(:,1790), t3x72(:,:,434))
  call heltable([2,36,72], n3(:,1791), t3x72(:,:,435))
  call heltable([2,36,72], n3(:,1792), t3x72(:,:,436))
  call heltable([2,36,72], n3(:,1793), t3x72(:,:,437))
  call heltable([2,36,72], n3(:,1794), t3x72(:,:,438))
  call heltable([2,36,72], n3(:,1795), t3x72(:,:,439))
  call heltable([2,36,72], n3(:,1796), t3x72(:,:,440))
  call heltable([2,36,72], n3(:,1797), t3x72(:,:,441))
  call heltable([2,36,72], n3(:,1798), t3x72(:,:,442))
  call heltable([36,2,72], n3(:,1799), t3x72(:,:,443))
  call heltable([36,2,72], n3(:,1800), t3x72(:,:,444))
  call heltable([2,36,72], n3(:,1801), t3x72(:,:,445))
  call heltable([2,36,72], n3(:,1802), t3x72(:,:,446))
  call heltable([36,2,72], n3(:,1803), t3x72(:,:,447))
  call heltable([36,2,72], n3(:,1804), t3x72(:,:,448))
  call heltable([36,2,72], n3(:,1805), t3x72(:,:,449))
  call heltable([36,2,72], n3(:,1806), t3x72(:,:,450))
  call heltable([36,2,72], n3(:,1807), t3x72(:,:,451))
  call heltable([36,2,72], n3(:,1808), t3x72(:,:,452))
  call heltable([36,2,72], n3(:,1809), t3x72(:,:,453))
  call heltable([36,2,72], n3(:,1810), t3x72(:,:,454))
  call heltable([36,2,72], n3(:,1811), t3x72(:,:,455))
  call heltable([36,2,72], n3(:,1812), t3x72(:,:,456))
  call heltable([36,2,72], n3(:,1813), t3x72(:,:,457))
  call heltable([36,2,72], n3(:,1814), t3x72(:,:,458))
  call heltable([2,36,72], n3(:,1815), t3x72(:,:,459))
  call heltable([2,36,72], n3(:,1816), t3x72(:,:,460))
  call heltable([2,36,72], n3(:,1817), t3x72(:,:,461))
  call heltable([2,36,72], n3(:,1818), t3x72(:,:,462))
  call heltable([2,36,72], n3(:,1819), t3x72(:,:,463))
  call heltable([2,36,72], n3(:,1820), t3x72(:,:,464))
  call heltable([2,36,72], n3(:,1821), t3x72(:,:,465))
  call heltable([2,36,72], n3(:,1822), t3x72(:,:,466))
  call heltable([2,36,72], n3(:,1823), t3x72(:,:,467))
  call heltable([2,36,72], n3(:,1824), t3x72(:,:,468))
  call heltable([2,36,72], n3(:,1825), t3x72(:,:,469))
  call heltable([2,36,72], n3(:,1826), t3x72(:,:,470))
  call heltable([2,36,72], n3(:,1827), t3x72(:,:,471))
  call heltable([2,36,72], n3(:,1828), t3x72(:,:,472))
  call heltable([2,36,72], n3(:,1829), t3x72(:,:,473))
  call heltable([2,36,72], n3(:,1830), t3x72(:,:,474))
  call heltable([12,6,72], n3(:,1831), t3x72(:,:,475))
  call heltable([6,12,72], n3(:,1832), t3x72(:,:,476))
  call heltable([12,6,72], n3(:,1833), t3x72(:,:,477))
  call heltable([12,6,72], n3(:,1834), t3x72(:,:,478))
  call heltable([12,6,72], n3(:,1835), t3x72(:,:,479))
  call heltable([12,6,72], n3(:,1836), t3x72(:,:,480))
  call heltable([12,6,72], n3(:,1837), t3x72(:,:,481))
  call heltable([12,6,72], n3(:,1838), t3x72(:,:,482))
  call heltable([12,6,72], n3(:,1839), t3x72(:,:,483))
  call heltable([12,6,72], n3(:,1840), t3x72(:,:,484))
  call heltable([12,6,72], n3(:,1841), t3x72(:,:,485))
  call heltable([12,6,72], n3(:,1842), t3x72(:,:,486))
  call heltable([12,6,72], n3(:,1843), t3x72(:,:,487))
  call heltable([12,6,72], n3(:,1844), t3x72(:,:,488))
  call heltable([12,6,72], n3(:,1845), t3x72(:,:,489))
  call heltable([12,6,72], n3(:,1846), t3x72(:,:,490))
  call heltable([18,4,72], n3(:,1847), t3x72(:,:,491))
  call heltable([4,18,72], n3(:,1848), t3x72(:,:,492))
  call heltable([18,4,72], n3(:,1849), t3x72(:,:,493))
  call heltable([18,4,72], n3(:,1850), t3x72(:,:,494))
  call heltable([18,4,72], n3(:,1851), t3x72(:,:,495))
  call heltable([18,4,72], n3(:,1852), t3x72(:,:,496))
  call heltable([18,4,72], n3(:,1853), t3x72(:,:,497))
  call heltable([18,4,72], n3(:,1854), t3x72(:,:,498))
  call heltable([18,4,72], n3(:,1855), t3x72(:,:,499))
  call heltable([18,4,72], n3(:,1856), t3x72(:,:,500))
  call heltable([18,4,72], n3(:,1857), t3x72(:,:,501))
  call heltable([18,4,72], n3(:,1858), t3x72(:,:,502))
  call heltable([18,4,72], n3(:,1859), t3x72(:,:,503))
  call heltable([18,4,72], n3(:,1860), t3x72(:,:,504))
  call heltable([18,4,72], n3(:,1861), t3x72(:,:,505))
  call heltable([18,4,72], n3(:,1862), t3x72(:,:,506))
  call heltable([12,6,72], n3(:,1863), t3x72(:,:,507))
  call heltable([6,12,72], n3(:,1864), t3x72(:,:,508))
  call heltable([12,6,72], n3(:,1865), t3x72(:,:,509))
  call heltable([12,6,72], n3(:,1866), t3x72(:,:,510))
  call heltable([12,6,72], n3(:,1867), t3x72(:,:,511))
  call heltable([12,6,72], n3(:,1868), t3x72(:,:,512))
  call heltable([12,6,72], n3(:,1869), t3x72(:,:,513))
  call heltable([12,6,72], n3(:,1870), t3x72(:,:,514))
  call heltable([12,6,72], n3(:,1871), t3x72(:,:,515))
  call heltable([12,6,72], n3(:,1872), t3x72(:,:,516))
  call heltable([12,6,72], n3(:,1873), t3x72(:,:,517))
  call heltable([12,6,72], n3(:,1874), t3x72(:,:,518))
  call heltable([12,6,72], n3(:,1875), t3x72(:,:,519))
  call heltable([12,6,72], n3(:,1876), t3x72(:,:,520))
  call heltable([12,6,72], n3(:,1877), t3x72(:,:,521))
  call heltable([12,6,72], n3(:,1878), t3x72(:,:,522))
  call heltable([4,18,72], n3(:,1879), t3x72(:,:,523))
  call heltable([4,18,72], n3(:,1880), t3x72(:,:,524))
  call heltable([4,18,72], n3(:,1881), t3x72(:,:,525))
  call heltable([4,18,72], n3(:,1882), t3x72(:,:,526))
  call heltable([4,18,72], n3(:,1883), t3x72(:,:,527))
  call heltable([4,18,72], n3(:,1884), t3x72(:,:,528))
  call heltable([4,18,72], n3(:,1885), t3x72(:,:,529))
  call heltable([4,18,72], n3(:,1886), t3x72(:,:,530))
  call heltable([4,18,72], n3(:,1887), t3x72(:,:,531))
  call heltable([4,18,72], n3(:,1888), t3x72(:,:,532))
  call heltable([4,18,72], n3(:,1889), t3x72(:,:,533))
  call heltable([4,18,72], n3(:,1890), t3x72(:,:,534))
  call heltable([4,18,72], n3(:,1891), t3x72(:,:,535))
  call heltable([4,18,72], n3(:,1892), t3x72(:,:,536))
  call heltable([4,18,72], n3(:,1893), t3x72(:,:,537))
  call heltable([4,18,72], n3(:,1894), t3x72(:,:,538))
  call heltable([6,12,72], n3(:,1895), t3x72(:,:,539))
  call heltable([6,12,72], n3(:,1896), t3x72(:,:,540))
  call heltable([6,12,72], n3(:,1897), t3x72(:,:,541))
  call heltable([6,12,72], n3(:,1898), t3x72(:,:,542))
  call heltable([6,12,72], n3(:,1899), t3x72(:,:,543))
  call heltable([6,12,72], n3(:,1900), t3x72(:,:,544))
  call heltable([6,12,72], n3(:,1901), t3x72(:,:,545))
  call heltable([6,12,72], n3(:,1902), t3x72(:,:,546))
  call heltable([6,12,72], n3(:,1903), t3x72(:,:,547))
  call heltable([6,12,72], n3(:,1904), t3x72(:,:,548))
  call heltable([6,12,72], n3(:,1905), t3x72(:,:,549))
  call heltable([6,12,72], n3(:,1906), t3x72(:,:,550))
  call heltable([6,12,72], n3(:,1907), t3x72(:,:,551))
  call heltable([6,12,72], n3(:,1908), t3x72(:,:,552))
  call heltable([6,12,72], n3(:,1909), t3x72(:,:,553))
  call heltable([6,12,72], n3(:,1910), t3x72(:,:,554))
  call heltable([6,12,72], n3(:,1911), t3x72(:,:,555))
  call heltable([6,12,72], n3(:,1912), t3x72(:,:,556))
  call heltable([6,12,72], n3(:,1913), t3x72(:,:,557))
  call heltable([6,12,72], n3(:,1914), t3x72(:,:,558))
  call heltable([6,12,72], n3(:,1915), t3x72(:,:,559))
  call heltable([6,12,72], n3(:,1916), t3x72(:,:,560))
  call heltable([6,12,72], n3(:,1917), t3x72(:,:,561))
  call heltable([6,12,72], n3(:,1918), t3x72(:,:,562))
  call heltable([6,12,72], n3(:,1919), t3x72(:,:,563))
  call heltable([6,12,72], n3(:,1920), t3x72(:,:,564))
  call heltable([6,12,72], n3(:,1921), t3x72(:,:,565))
  call heltable([6,12,72], n3(:,1922), t3x72(:,:,566))
  call heltable([6,12,72], n3(:,1923), t3x72(:,:,567))
  call heltable([6,12,72], n3(:,1924), t3x72(:,:,568))
  call heltable([6,12,72], n3(:,1925), t3x72(:,:,569))
  call heltable([6,12,72], n3(:,1926), t3x72(:,:,570))
  call heltable([12,6,72], n3(:,1927), t3x72(:,:,571))
  call heltable([12,6,72], n3(:,1928), t3x72(:,:,572))
  call heltable([6,12,72], n3(:,1929), t3x72(:,:,573))
  call heltable([6,12,72], n3(:,1930), t3x72(:,:,574))
  call heltable([12,6,72], n3(:,1931), t3x72(:,:,575))
  call heltable([12,6,72], n3(:,1932), t3x72(:,:,576))
  call heltable([12,6,72], n3(:,1933), t3x72(:,:,577))
  call heltable([12,6,72], n3(:,1934), t3x72(:,:,578))
  call heltable([12,6,72], n3(:,1935), t3x72(:,:,579))
  call heltable([12,6,72], n3(:,1936), t3x72(:,:,580))
  call heltable([12,6,72], n3(:,1937), t3x72(:,:,581))
  call heltable([12,6,72], n3(:,1938), t3x72(:,:,582))
  call heltable([12,6,72], n3(:,1939), t3x72(:,:,583))
  call heltable([12,6,72], n3(:,1940), t3x72(:,:,584))
  call heltable([12,6,72], n3(:,1941), t3x72(:,:,585))
  call heltable([12,6,72], n3(:,1942), t3x72(:,:,586))
  call heltable([18,4,72], n3(:,1943), t3x72(:,:,587))
  call heltable([18,4,72], n3(:,1944), t3x72(:,:,588))
  call heltable([4,18,72], n3(:,1945), t3x72(:,:,589))
  call heltable([4,18,72], n3(:,1946), t3x72(:,:,590))
  call heltable([18,4,72], n3(:,1947), t3x72(:,:,591))
  call heltable([18,4,72], n3(:,1948), t3x72(:,:,592))
  call heltable([18,4,72], n3(:,1949), t3x72(:,:,593))
  call heltable([18,4,72], n3(:,1950), t3x72(:,:,594))
  call heltable([18,4,72], n3(:,1951), t3x72(:,:,595))
  call heltable([18,4,72], n3(:,1952), t3x72(:,:,596))
  call heltable([18,4,72], n3(:,1953), t3x72(:,:,597))
  call heltable([18,4,72], n3(:,1954), t3x72(:,:,598))
  call heltable([18,4,72], n3(:,1955), t3x72(:,:,599))
  call heltable([18,4,72], n3(:,1956), t3x72(:,:,600))
  call heltable([18,4,72], n3(:,1957), t3x72(:,:,601))
  call heltable([18,4,72], n3(:,1958), t3x72(:,:,602))
  call heltable([12,6,72], n3(:,1959), t3x72(:,:,603))
  call heltable([12,6,72], n3(:,1960), t3x72(:,:,604))
  call heltable([6,12,72], n3(:,1961), t3x72(:,:,605))
  call heltable([6,12,72], n3(:,1962), t3x72(:,:,606))
  call heltable([12,6,72], n3(:,1963), t3x72(:,:,607))
  call heltable([12,6,72], n3(:,1964), t3x72(:,:,608))
  call heltable([12,6,72], n3(:,1965), t3x72(:,:,609))
  call heltable([12,6,72], n3(:,1966), t3x72(:,:,610))
  call heltable([12,6,72], n3(:,1967), t3x72(:,:,611))
  call heltable([12,6,72], n3(:,1968), t3x72(:,:,612))
  call heltable([12,6,72], n3(:,1969), t3x72(:,:,613))
  call heltable([12,6,72], n3(:,1970), t3x72(:,:,614))
  call heltable([12,6,72], n3(:,1971), t3x72(:,:,615))
  call heltable([12,6,72], n3(:,1972), t3x72(:,:,616))
  call heltable([12,6,72], n3(:,1973), t3x72(:,:,617))
  call heltable([12,6,72], n3(:,1974), t3x72(:,:,618))
  call heltable([4,18,72], n3(:,1975), t3x72(:,:,619))
  call heltable([4,18,72], n3(:,1976), t3x72(:,:,620))
  call heltable([4,18,72], n3(:,1977), t3x72(:,:,621))
  call heltable([4,18,72], n3(:,1978), t3x72(:,:,622))
  call heltable([4,18,72], n3(:,1979), t3x72(:,:,623))
  call heltable([4,18,72], n3(:,1980), t3x72(:,:,624))
  call heltable([4,18,72], n3(:,1981), t3x72(:,:,625))
  call heltable([4,18,72], n3(:,1982), t3x72(:,:,626))
  call heltable([4,18,72], n3(:,1983), t3x72(:,:,627))
  call heltable([4,18,72], n3(:,1984), t3x72(:,:,628))
  call heltable([4,18,72], n3(:,1985), t3x72(:,:,629))
  call heltable([4,18,72], n3(:,1986), t3x72(:,:,630))
  call heltable([4,18,72], n3(:,1987), t3x72(:,:,631))
  call heltable([4,18,72], n3(:,1988), t3x72(:,:,632))
  call heltable([4,18,72], n3(:,1989), t3x72(:,:,633))
  call heltable([4,18,72], n3(:,1990), t3x72(:,:,634))
  call heltable([6,12,72], n3(:,1991), t3x72(:,:,635))
  call heltable([6,12,72], n3(:,1992), t3x72(:,:,636))
  call heltable([6,12,72], n3(:,1993), t3x72(:,:,637))
  call heltable([6,12,72], n3(:,1994), t3x72(:,:,638))
  call heltable([6,12,72], n3(:,1995), t3x72(:,:,639))
  call heltable([6,12,72], n3(:,1996), t3x72(:,:,640))
  call heltable([6,12,72], n3(:,1997), t3x72(:,:,641))
  call heltable([6,12,72], n3(:,1998), t3x72(:,:,642))
  call heltable([6,12,72], n3(:,1999), t3x72(:,:,643))
  call heltable([6,12,72], n3(:,2000), t3x72(:,:,644))
  call heltable([6,12,72], n3(:,2001), t3x72(:,:,645))
  call heltable([6,12,72], n3(:,2002), t3x72(:,:,646))
  call heltable([6,12,72], n3(:,2003), t3x72(:,:,647))
  call heltable([6,12,72], n3(:,2004), t3x72(:,:,648))
  call heltable([6,12,72], n3(:,2005), t3x72(:,:,649))
  call heltable([6,12,72], n3(:,2006), t3x72(:,:,650))
  call heltable([6,12,72], n3(:,2007), t3x72(:,:,651))
  call heltable([6,12,72], n3(:,2008), t3x72(:,:,652))
  call heltable([6,12,72], n3(:,2009), t3x72(:,:,653))
  call heltable([6,12,72], n3(:,2010), t3x72(:,:,654))
  call heltable([6,12,72], n3(:,2011), t3x72(:,:,655))
  call heltable([6,12,72], n3(:,2012), t3x72(:,:,656))
  call heltable([6,12,72], n3(:,2013), t3x72(:,:,657))
  call heltable([6,12,72], n3(:,2014), t3x72(:,:,658))
  call heltable([6,12,72], n3(:,2015), t3x72(:,:,659))
  call heltable([6,12,72], n3(:,2016), t3x72(:,:,660))
  call heltable([6,12,72], n3(:,2017), t3x72(:,:,661))
  call heltable([6,12,72], n3(:,2018), t3x72(:,:,662))
  call heltable([6,12,72], n3(:,2019), t3x72(:,:,663))
  call heltable([6,12,72], n3(:,2020), t3x72(:,:,664))
  call heltable([6,12,72], n3(:,2021), t3x72(:,:,665))
  call heltable([6,12,72], n3(:,2022), t3x72(:,:,666))
  call heltable([6,12,72], n3(:,2023), t3x72(:,:,667))
  call heltable([6,12,72], n3(:,2024), t3x72(:,:,668))
  call heltable([6,12,72], n3(:,2025), t3x72(:,:,669))
  call heltable([6,12,72], n3(:,2026), t3x72(:,:,670))
  call heltable([9,8,72], n3(:,2027), t3x72(:,:,671))
  call heltable([9,8,72], n3(:,2028), t3x72(:,:,672))
  call heltable([9,8,72], n3(:,2029), t3x72(:,:,673))
  call heltable([9,8,72], n3(:,2030), t3x72(:,:,674))
  call heltable([9,8,72], n3(:,2031), t3x72(:,:,675))
  call heltable([9,8,72], n3(:,2032), t3x72(:,:,676))
  call heltable([9,8,72], n3(:,2033), t3x72(:,:,677))
  call heltable([9,8,72], n3(:,2034), t3x72(:,:,678))
  call heltable([9,8,72], n3(:,2035), t3x72(:,:,679))
  call heltable([9,8,72], n3(:,2036), t3x72(:,:,680))
  call heltable([9,8,72], n3(:,2037), t3x72(:,:,681))
  call heltable([9,8,72], n3(:,2038), t3x72(:,:,682))
  call heltable([6,12,72], n3(:,2039), t3x72(:,:,683))
  call heltable([6,12,72], n3(:,2040), t3x72(:,:,684))
  call heltable([6,12,72], n3(:,2041), t3x72(:,:,685))
  call heltable([6,12,72], n3(:,2042), t3x72(:,:,686))
  call heltable([9,8,72], n3(:,2043), t3x72(:,:,687))
  call heltable([9,8,72], n3(:,2044), t3x72(:,:,688))
  call heltable([9,8,72], n3(:,2045), t3x72(:,:,689))
  call heltable([9,8,72], n3(:,2046), t3x72(:,:,690))
  call heltable([9,8,72], n3(:,2047), t3x72(:,:,691))
  call heltable([9,8,72], n3(:,2048), t3x72(:,:,692))
  call heltable([9,8,72], n3(:,2049), t3x72(:,:,693))
  call heltable([9,8,72], n3(:,2050), t3x72(:,:,694))
  call heltable([9,8,72], n3(:,2051), t3x72(:,:,695))
  call heltable([9,8,72], n3(:,2052), t3x72(:,:,696))
  call heltable([9,8,72], n3(:,2053), t3x72(:,:,697))
  call heltable([9,8,72], n3(:,2054), t3x72(:,:,698))
  call heltable([6,12,72], n3(:,2055), t3x72(:,:,699))
  call heltable([6,12,72], n3(:,2056), t3x72(:,:,700))
  call heltable([6,12,72], n3(:,2057), t3x72(:,:,701))
  call heltable([6,12,72], n3(:,2058), t3x72(:,:,702))
  call heltable([6,12,72], n3(:,2059), t3x72(:,:,703))
  call heltable([6,12,72], n3(:,2060), t3x72(:,:,704))
  call heltable([6,12,72], n3(:,2061), t3x72(:,:,705))
  call heltable([6,12,72], n3(:,2062), t3x72(:,:,706))
  call heltable([12,6,72], n3(:,2063), t3x72(:,:,707))
  call heltable([12,6,72], n3(:,2064), t3x72(:,:,708))
  call heltable([12,6,72], n3(:,2065), t3x72(:,:,709))
  call heltable([12,6,72], n3(:,2066), t3x72(:,:,710))
  call heltable([8,9,72], n3(:,2067), t3x72(:,:,711))
  call heltable([8,9,72], n3(:,2068), t3x72(:,:,712))
  call heltable([8,9,72], n3(:,2069), t3x72(:,:,713))
  call heltable([8,9,72], n3(:,2070), t3x72(:,:,714))
  call heltable([8,9,72], n3(:,2071), t3x72(:,:,715))
  call heltable([8,9,72], n3(:,2072), t3x72(:,:,716))
  call heltable([8,9,72], n3(:,2073), t3x72(:,:,717))
  call heltable([8,9,72], n3(:,2074), t3x72(:,:,718))
  call heltable([6,12,72], n3(:,2075), t3x72(:,:,719))
  call heltable([6,12,72], n3(:,2076), t3x72(:,:,720))
  call heltable([6,12,72], n3(:,2077), t3x72(:,:,721))
  call heltable([6,12,72], n3(:,2078), t3x72(:,:,722))
  call heltable([12,6,72], n3(:,2079), t3x72(:,:,723))
  call heltable([12,6,72], n3(:,2080), t3x72(:,:,724))
  call heltable([12,6,72], n3(:,2081), t3x72(:,:,725))
  call heltable([12,6,72], n3(:,2082), t3x72(:,:,726))
  call heltable([8,9,72], n3(:,2083), t3x72(:,:,727))
  call heltable([8,9,72], n3(:,2084), t3x72(:,:,728))
  call heltable([8,9,72], n3(:,2085), t3x72(:,:,729))
  call heltable([8,9,72], n3(:,2086), t3x72(:,:,730))
  call heltable([8,9,72], n3(:,2087), t3x72(:,:,731))
  call heltable([8,9,72], n3(:,2088), t3x72(:,:,732))
  call heltable([8,9,72], n3(:,2089), t3x72(:,:,733))
  call heltable([8,9,72], n3(:,2090), t3x72(:,:,734))
  call heltable([9,8,72], n3(:,2091), t3x72(:,:,735))
  call heltable([9,8,72], n3(:,2092), t3x72(:,:,736))
  call heltable([9,8,72], n3(:,2093), t3x72(:,:,737))
  call heltable([9,8,72], n3(:,2094), t3x72(:,:,738))
  call heltable([9,8,72], n3(:,2095), t3x72(:,:,739))
  call heltable([9,8,72], n3(:,2096), t3x72(:,:,740))
  call heltable([12,6,72], n3(:,2097), t3x72(:,:,741))
  call heltable([12,6,72], n3(:,2098), t3x72(:,:,742))
  call heltable([4,18,72], n3(:,2099), t3x72(:,:,743))
  call heltable([4,18,72], n3(:,2100), t3x72(:,:,744))
  call heltable([4,18,72], n3(:,2101), t3x72(:,:,745))
  call heltable([4,18,72], n3(:,2102), t3x72(:,:,746))
  call heltable([12,6,72], n3(:,2103), t3x72(:,:,747))
  call heltable([12,6,72], n3(:,2104), t3x72(:,:,748))
  call heltable([12,6,72], n3(:,2105), t3x72(:,:,749))
  call heltable([12,6,72], n3(:,2106), t3x72(:,:,750))
  call heltable([9,8,72], n3(:,2107), t3x72(:,:,751))
  call heltable([9,8,72], n3(:,2108), t3x72(:,:,752))
  call heltable([9,8,72], n3(:,2109), t3x72(:,:,753))
  call heltable([9,8,72], n3(:,2110), t3x72(:,:,754))
  call heltable([9,8,72], n3(:,2111), t3x72(:,:,755))
  call heltable([9,8,72], n3(:,2112), t3x72(:,:,756))
  call heltable([9,8,72], n3(:,2113), t3x72(:,:,757))
  call heltable([9,8,72], n3(:,2114), t3x72(:,:,758))
  call heltable([4,18,72], n3(:,2115), t3x72(:,:,759))
  call heltable([4,18,72], n3(:,2116), t3x72(:,:,760))
  call heltable([4,18,72], n3(:,2117), t3x72(:,:,761))
  call heltable([4,18,72], n3(:,2118), t3x72(:,:,762))
  call heltable([12,6,72], n3(:,2119), t3x72(:,:,763))
  call heltable([12,6,72], n3(:,2120), t3x72(:,:,764))
  call heltable([12,6,72], n3(:,2121), t3x72(:,:,765))
  call heltable([12,6,72], n3(:,2122), t3x72(:,:,766))
  call heltable([9,8,72], n3(:,2123), t3x72(:,:,767))
  call heltable([9,8,72], n3(:,2124), t3x72(:,:,768))
  call heltable([9,8,72], n3(:,2125), t3x72(:,:,769))
  call heltable([9,8,72], n3(:,2126), t3x72(:,:,770))
  call heltable([9,8,72], n3(:,2127), t3x72(:,:,771))
  call heltable([9,8,72], n3(:,2128), t3x72(:,:,772))
  call heltable([9,8,72], n3(:,2129), t3x72(:,:,773))
  call heltable([9,8,72], n3(:,2130), t3x72(:,:,774))
  call heltable([6,12,72], n3(:,2131), t3x72(:,:,775))
  call heltable([6,12,72], n3(:,2132), t3x72(:,:,776))
  call heltable([6,12,72], n3(:,2133), t3x72(:,:,777))
  call heltable([6,12,72], n3(:,2134), t3x72(:,:,778))
  call heltable([6,12,72], n3(:,2135), t3x72(:,:,779))
  call heltable([6,12,72], n3(:,2136), t3x72(:,:,780))
  call heltable([6,12,72], n3(:,2137), t3x72(:,:,781))
  call heltable([6,12,72], n3(:,2138), t3x72(:,:,782))
  call heltable([6,12,72], n3(:,2139), t3x72(:,:,783))
  call heltable([6,12,72], n3(:,2140), t3x72(:,:,784))
  call heltable([6,12,72], n3(:,2141), t3x72(:,:,785))
  call heltable([6,12,72], n3(:,2142), t3x72(:,:,786))
  call heltable([6,12,72], n3(:,2143), t3x72(:,:,787))
  call heltable([6,12,72], n3(:,2144), t3x72(:,:,788))
  call heltable([6,12,72], n3(:,2145), t3x72(:,:,789))
  call heltable([6,12,72], n3(:,2146), t3x72(:,:,790))
  call heltable([18,4,72], n3(:,2147), t3x72(:,:,791))
  call heltable([6,12,72], n3(:,2148), t3x72(:,:,792))
  call heltable([4,18,72], n3(:,2149), t3x72(:,:,793))
  call heltable([6,12,72], n3(:,2150), t3x72(:,:,794))
  call heltable([4,18,72], n3(:,2151), t3x72(:,:,795))
  call heltable([4,18,72], n3(:,2152), t3x72(:,:,796))
  call heltable([4,18,72], n3(:,2153), t3x72(:,:,797))
  call heltable([4,18,72], n3(:,2154), t3x72(:,:,798))
  call heltable([4,18,72], n3(:,2155), t3x72(:,:,799))
  call heltable([4,18,72], n3(:,2156), t3x72(:,:,800))
  call heltable([6,12,72], n3(:,2157), t3x72(:,:,801))
  call heltable([6,12,72], n3(:,2158), t3x72(:,:,802))
  call heltable([6,12,72], n3(:,2159), t3x72(:,:,803))
  call heltable([6,12,72], n3(:,2160), t3x72(:,:,804))
  call heltable([12,6,72], n3(:,2161), t3x72(:,:,805))
  call heltable([12,6,72], n3(:,2162), t3x72(:,:,806))
  call heltable([12,6,72], n3(:,2163), t3x72(:,:,807))
  call heltable([12,6,72], n3(:,2164), t3x72(:,:,808))
  call heltable([8,9,72], n3(:,2165), t3x72(:,:,809))
  call heltable([8,9,72], n3(:,2166), t3x72(:,:,810))
  call heltable([8,9,72], n3(:,2167), t3x72(:,:,811))
  call heltable([8,9,72], n3(:,2168), t3x72(:,:,812))
  call heltable([8,9,72], n3(:,2169), t3x72(:,:,813))
  call heltable([8,9,72], n3(:,2170), t3x72(:,:,814))
  call heltable([8,9,72], n3(:,2171), t3x72(:,:,815))
  call heltable([8,9,72], n3(:,2172), t3x72(:,:,816))
  call heltable([6,12,72], n3(:,2173), t3x72(:,:,817))
  call heltable([6,12,72], n3(:,2174), t3x72(:,:,818))
  call heltable([6,12,72], n3(:,2175), t3x72(:,:,819))
  call heltable([6,12,72], n3(:,2176), t3x72(:,:,820))
  call heltable([12,6,72], n3(:,2177), t3x72(:,:,821))
  call heltable([12,6,72], n3(:,2178), t3x72(:,:,822))
  call heltable([12,6,72], n3(:,2179), t3x72(:,:,823))
  call heltable([12,6,72], n3(:,2180), t3x72(:,:,824))
  call heltable([8,9,72], n3(:,2181), t3x72(:,:,825))
  call heltable([8,9,72], n3(:,2182), t3x72(:,:,826))
  call heltable([8,9,72], n3(:,2183), t3x72(:,:,827))
  call heltable([8,9,72], n3(:,2184), t3x72(:,:,828))
  call heltable([8,9,72], n3(:,2185), t3x72(:,:,829))
  call heltable([8,9,72], n3(:,2186), t3x72(:,:,830))
  call heltable([8,9,72], n3(:,2187), t3x72(:,:,831))
  call heltable([8,9,72], n3(:,2188), t3x72(:,:,832))
  call heltable([9,8,72], n3(:,2189), t3x72(:,:,833))
  call heltable([9,8,72], n3(:,2190), t3x72(:,:,834))
  call heltable([9,8,72], n3(:,2191), t3x72(:,:,835))
  call heltable([9,8,72], n3(:,2192), t3x72(:,:,836))
  call heltable([9,8,72], n3(:,2193), t3x72(:,:,837))
  call heltable([9,8,72], n3(:,2194), t3x72(:,:,838))
  call heltable([12,6,72], n3(:,2195), t3x72(:,:,839))
  call heltable([12,6,72], n3(:,2196), t3x72(:,:,840))
  call heltable([4,18,72], n3(:,2197), t3x72(:,:,841))
  call heltable([4,18,72], n3(:,2198), t3x72(:,:,842))
  call heltable([4,18,72], n3(:,2199), t3x72(:,:,843))
  call heltable([4,18,72], n3(:,2200), t3x72(:,:,844))
  call heltable([12,6,72], n3(:,2201), t3x72(:,:,845))
  call heltable([12,6,72], n3(:,2202), t3x72(:,:,846))
  call heltable([12,6,72], n3(:,2203), t3x72(:,:,847))
  call heltable([12,6,72], n3(:,2204), t3x72(:,:,848))
  call heltable([9,8,72], n3(:,2205), t3x72(:,:,849))
  call heltable([9,8,72], n3(:,2206), t3x72(:,:,850))
  call heltable([9,8,72], n3(:,2207), t3x72(:,:,851))
  call heltable([9,8,72], n3(:,2208), t3x72(:,:,852))
  call heltable([9,8,72], n3(:,2209), t3x72(:,:,853))
  call heltable([9,8,72], n3(:,2210), t3x72(:,:,854))
  call heltable([9,8,72], n3(:,2211), t3x72(:,:,855))
  call heltable([9,8,72], n3(:,2212), t3x72(:,:,856))
  call heltable([4,18,72], n3(:,2213), t3x72(:,:,857))
  call heltable([4,18,72], n3(:,2214), t3x72(:,:,858))
  call heltable([4,18,72], n3(:,2215), t3x72(:,:,859))
  call heltable([4,18,72], n3(:,2216), t3x72(:,:,860))
  call heltable([12,6,72], n3(:,2217), t3x72(:,:,861))
  call heltable([12,6,72], n3(:,2218), t3x72(:,:,862))
  call heltable([12,6,72], n3(:,2219), t3x72(:,:,863))
  call heltable([12,6,72], n3(:,2220), t3x72(:,:,864))
  call heltable([9,8,72], n3(:,2221), t3x72(:,:,865))
  call heltable([9,8,72], n3(:,2222), t3x72(:,:,866))
  call heltable([9,8,72], n3(:,2223), t3x72(:,:,867))
  call heltable([9,8,72], n3(:,2224), t3x72(:,:,868))
  call heltable([9,8,72], n3(:,2225), t3x72(:,:,869))
  call heltable([9,8,72], n3(:,2226), t3x72(:,:,870))
  call heltable([9,8,72], n3(:,2227), t3x72(:,:,871))
  call heltable([9,8,72], n3(:,2228), t3x72(:,:,872))
  call heltable([6,12,72], n3(:,2229), t3x72(:,:,873))
  call heltable([6,12,72], n3(:,2230), t3x72(:,:,874))
  call heltable([6,12,72], n3(:,2231), t3x72(:,:,875))
  call heltable([6,12,72], n3(:,2232), t3x72(:,:,876))
  call heltable([12,6,72], n3(:,2233), t3x72(:,:,877))
  call heltable([12,6,72], n3(:,2234), t3x72(:,:,878))
  call heltable([12,6,72], n3(:,2235), t3x72(:,:,879))
  call heltable([12,6,72], n3(:,2236), t3x72(:,:,880))
  call heltable([6,12,72], n3(:,2237), t3x72(:,:,881))
  call heltable([6,12,72], n3(:,2238), t3x72(:,:,882))
  call heltable([6,12,72], n3(:,2239), t3x72(:,:,883))
  call heltable([6,12,72], n3(:,2240), t3x72(:,:,884))
  call heltable([12,6,72], n3(:,2241), t3x72(:,:,885))
  call heltable([12,6,72], n3(:,2242), t3x72(:,:,886))
  call heltable([12,6,72], n3(:,2243), t3x72(:,:,887))
  call heltable([12,6,72], n3(:,2244), t3x72(:,:,888))
  call heltable([18,4,72], n3(:,2245), t3x72(:,:,889))
  call heltable([6,12,72], n3(:,2246), t3x72(:,:,890))
  call heltable([4,18,72], n3(:,2247), t3x72(:,:,891))
  call heltable([6,12,72], n3(:,2248), t3x72(:,:,892))
  call heltable([4,18,72], n3(:,2249), t3x72(:,:,893))
  call heltable([4,18,72], n3(:,2250), t3x72(:,:,894))
  call heltable([4,18,72], n3(:,2251), t3x72(:,:,895))
  call heltable([4,18,72], n3(:,2252), t3x72(:,:,896))
  call heltable([4,18,72], n3(:,2253), t3x72(:,:,897))
  call heltable([4,18,72], n3(:,2254), t3x72(:,:,898))
  call heltable([4,18,72], n3(:,2255), t3x72(:,:,899))
  call heltable([4,18,72], n3(:,2256), t3x72(:,:,900))
  call heltable([4,18,72], n3(:,2257), t3x72(:,:,901))
  call heltable([4,18,72], n3(:,2258), t3x72(:,:,902))
  call heltable([6,12,72], n3(:,2259), t3x72(:,:,903))
  call heltable([6,12,72], n3(:,2260), t3x72(:,:,904))
  call heltable([6,12,72], n3(:,2261), t3x72(:,:,905))
  call heltable([6,12,72], n3(:,2262), t3x72(:,:,906))
  call heltable([4,18,72], n3(:,2263), t3x72(:,:,907))
  call heltable([6,12,72], n3(:,2264), t3x72(:,:,908))
  call heltable([4,18,72], n3(:,2265), t3x72(:,:,909))
  call heltable([4,18,72], n3(:,2266), t3x72(:,:,910))
  call heltable([4,18,72], n3(:,2267), t3x72(:,:,911))
  call heltable([4,18,72], n3(:,2268), t3x72(:,:,912))
  call heltable([9,8,72], n3(:,2269), t3x72(:,:,913))
  call heltable([9,8,72], n3(:,2270), t3x72(:,:,914))
  call heltable([6,12,72], n3(:,2271), t3x72(:,:,915))
  call heltable([6,12,72], n3(:,2272), t3x72(:,:,916))
  call heltable([6,12,72], n3(:,2273), t3x72(:,:,917))
  call heltable([6,12,72], n3(:,2274), t3x72(:,:,918))
  call heltable([4,18,72], n3(:,2275), t3x72(:,:,919))
  call heltable([4,18,72], n3(:,2276), t3x72(:,:,920))
  call heltable([12,6,72], n3(:,2277), t3x72(:,:,921))
  call heltable([6,12,72], n3(:,2278), t3x72(:,:,922))
  call heltable([6,12,72], n3(:,2279), t3x72(:,:,923))
  call heltable([6,12,72], n3(:,2280), t3x72(:,:,924))
  call heltable([6,12,72], n3(:,2281), t3x72(:,:,925))
  call heltable([6,12,72], n3(:,2282), t3x72(:,:,926))
  call heltable([9,8,72], n3(:,2283), t3x72(:,:,927))
  call heltable([9,8,72], n3(:,2284), t3x72(:,:,928))
  call heltable([6,12,72], n3(:,2285), t3x72(:,:,929))
  call heltable([6,12,72], n3(:,2286), t3x72(:,:,930))
  call heltable([6,12,72], n3(:,2287), t3x72(:,:,931))
  call heltable([6,12,72], n3(:,2288), t3x72(:,:,932))
  call heltable([4,18,72], n3(:,2289), t3x72(:,:,933))
  call heltable([4,18,72], n3(:,2290), t3x72(:,:,934))
  call heltable([12,6,72], n3(:,2291), t3x72(:,:,935))
  call heltable([4,18,72], n3(:,2292), t3x72(:,:,936))
  call heltable([4,18,72], n3(:,2293), t3x72(:,:,937))
  call heltable([6,12,72], n3(:,2294), t3x72(:,:,938))
  call heltable([4,18,72], n3(:,2295), t3x72(:,:,939))
  call heltable([4,18,72], n3(:,2296), t3x72(:,:,940))
  call heltable([12,6,72], n3(:,2297), t3x72(:,:,941))
  call heltable([6,12,72], n3(:,2298), t3x72(:,:,942))
  call heltable([4,18,72], n3(:,2299), t3x72(:,:,943))
  call heltable([4,18,72], n3(:,2300), t3x72(:,:,944))
  call heltable([12,6,72], n3(:,2301), t3x72(:,:,945))
  call heltable([4,18,72], n3(:,2302), t3x72(:,:,946))
  call heltable([4,18,72], n3(:,2303), t3x72(:,:,947))
  call heltable([4,18,72], n3(:,2304), t3x72(:,:,948))
  call heltable([4,18,72], n3(:,2305), t3x72(:,:,949))
  call heltable([4,18,72], n3(:,2306), t3x72(:,:,950))
  call heltable([6,12,72], n3(:,2307), t3x72(:,:,951))
  call heltable([6,12,72], n3(:,2308), t3x72(:,:,952))
  call heltable([6,12,72], n3(:,2309), t3x72(:,:,953))
  call heltable([6,12,72], n3(:,2310), t3x72(:,:,954))
  call heltable([4,18,72], n3(:,2311), t3x72(:,:,955))
  call heltable([6,12,72], n3(:,2312), t3x72(:,:,956))
  call heltable([4,18,72], n3(:,2313), t3x72(:,:,957))
  call heltable([4,18,72], n3(:,2314), t3x72(:,:,958))
  call heltable([4,18,72], n3(:,2315), t3x72(:,:,959))
  call heltable([4,18,72], n3(:,2316), t3x72(:,:,960))
  call heltable([9,8,72], n3(:,2317), t3x72(:,:,961))
  call heltable([9,8,72], n3(:,2318), t3x72(:,:,962))
  call heltable([6,12,72], n3(:,2319), t3x72(:,:,963))
  call heltable([6,12,72], n3(:,2320), t3x72(:,:,964))
  call heltable([6,12,72], n3(:,2321), t3x72(:,:,965))
  call heltable([6,12,72], n3(:,2322), t3x72(:,:,966))
  call heltable([4,18,72], n3(:,2323), t3x72(:,:,967))
  call heltable([4,18,72], n3(:,2324), t3x72(:,:,968))
  call heltable([12,6,72], n3(:,2325), t3x72(:,:,969))
  call heltable([6,12,72], n3(:,2326), t3x72(:,:,970))
  call heltable([6,12,72], n3(:,2327), t3x72(:,:,971))
  call heltable([6,12,72], n3(:,2328), t3x72(:,:,972))
  call heltable([6,12,72], n3(:,2329), t3x72(:,:,973))
  call heltable([6,12,72], n3(:,2330), t3x72(:,:,974))
  call heltable([9,8,72], n3(:,2331), t3x72(:,:,975))
  call heltable([9,8,72], n3(:,2332), t3x72(:,:,976))
  call heltable([6,12,72], n3(:,2333), t3x72(:,:,977))
  call heltable([6,12,72], n3(:,2334), t3x72(:,:,978))
  call heltable([6,12,72], n3(:,2335), t3x72(:,:,979))
  call heltable([6,12,72], n3(:,2336), t3x72(:,:,980))
  call heltable([4,18,72], n3(:,2337), t3x72(:,:,981))
  call heltable([4,18,72], n3(:,2338), t3x72(:,:,982))
  call heltable([12,6,72], n3(:,2339), t3x72(:,:,983))
  call heltable([4,18,72], n3(:,2340), t3x72(:,:,984))
  call heltable([4,18,72], n3(:,2341), t3x72(:,:,985))
  call heltable([6,12,72], n3(:,2342), t3x72(:,:,986))
  call heltable([4,18,72], n3(:,2343), t3x72(:,:,987))
  call heltable([4,18,72], n3(:,2344), t3x72(:,:,988))
  call heltable([12,6,72], n3(:,2345), t3x72(:,:,989))
  call heltable([6,12,72], n3(:,2346), t3x72(:,:,990))
  call heltable([4,18,72], n3(:,2347), t3x72(:,:,991))
  call heltable([4,18,72], n3(:,2348), t3x72(:,:,992))
  call heltable([12,6,72], n3(:,2349), t3x72(:,:,993))
  call heltable([4,18,72], n3(:,2350), t3x72(:,:,994))
  call heltable([12,6,72], n3(:,2351), t3x72(:,:,995))
  call heltable([12,6,72], n3(:,2352), t3x72(:,:,996))
  call heltable([12,6,72], n3(:,2353), t3x72(:,:,997))
  call heltable([12,6,72], n3(:,2354), t3x72(:,:,998))
  call heltable([12,6,72], n3(:,2355), t3x72(:,:,999))
  call heltable([12,6,72], n3(:,2356), t3x72(:,:,1000))
  call heltable([12,6,72], n3(:,2357), t3x72(:,:,1001))
  call heltable([12,6,72], n3(:,2358), t3x72(:,:,1002))
  call heltable([12,6,72], n3(:,2359), t3x72(:,:,1003))
  call heltable([12,6,72], n3(:,2360), t3x72(:,:,1004))
  call heltable([12,6,72], n3(:,2361), t3x72(:,:,1005))
  call heltable([12,6,72], n3(:,2362), t3x72(:,:,1006))
  call heltable([12,6,72], n3(:,2363), t3x72(:,:,1007))
  call heltable([12,6,72], n3(:,2364), t3x72(:,:,1008))
  call heltable([12,6,72], n3(:,2365), t3x72(:,:,1009))
  call heltable([12,6,72], n3(:,2366), t3x72(:,:,1010))
  call heltable([8,9,72], n3(:,2367), t3x72(:,:,1011))
  call heltable([8,9,72], n3(:,2368), t3x72(:,:,1012))
  call heltable([6,12,72], n3(:,2369), t3x72(:,:,1013))
  call heltable([6,12,72], n3(:,2370), t3x72(:,:,1014))
  call heltable([6,12,72], n3(:,2371), t3x72(:,:,1015))
  call heltable([6,12,72], n3(:,2372), t3x72(:,:,1016))
  call heltable([6,12,72], n3(:,2373), t3x72(:,:,1017))
  call heltable([6,12,72], n3(:,2374), t3x72(:,:,1018))
  call heltable([6,12,72], n3(:,2375), t3x72(:,:,1019))
  call heltable([6,12,72], n3(:,2376), t3x72(:,:,1020))
  call heltable([6,12,72], n3(:,2377), t3x72(:,:,1021))
  call heltable([6,12,72], n3(:,2378), t3x72(:,:,1022))
  call heltable([6,12,72], n3(:,2379), t3x72(:,:,1023))
  call heltable([6,12,72], n3(:,2380), t3x72(:,:,1024))
  call heltable([6,12,72], n3(:,2381), t3x72(:,:,1025))
  call heltable([6,12,72], n3(:,2382), t3x72(:,:,1026))
  call heltable([6,12,72], n3(:,2383), t3x72(:,:,1027))
  call heltable([6,12,72], n3(:,2384), t3x72(:,:,1028))
  call heltable([8,9,72], n3(:,2385), t3x72(:,:,1029))
  call heltable([8,9,72], n3(:,2386), t3x72(:,:,1030))
  call heltable([6,12,72], n3(:,2387), t3x72(:,:,1031))
  call heltable([6,12,72], n3(:,2388), t3x72(:,:,1032))
  call heltable([6,12,72], n3(:,2389), t3x72(:,:,1033))
  call heltable([6,12,72], n3(:,2390), t3x72(:,:,1034))
  call heltable([6,12,72], n3(:,2391), t3x72(:,:,1035))
  call heltable([6,12,72], n3(:,2392), t3x72(:,:,1036))
  call heltable([6,12,72], n3(:,2393), t3x72(:,:,1037))
  call heltable([6,12,72], n3(:,2394), t3x72(:,:,1038))
  call heltable([6,12,72], n3(:,2395), t3x72(:,:,1039))
  call heltable([6,12,72], n3(:,2396), t3x72(:,:,1040))
  call heltable([6,12,72], n3(:,2397), t3x72(:,:,1041))
  call heltable([6,12,72], n3(:,2398), t3x72(:,:,1042))
  call heltable([6,12,72], n3(:,2399), t3x72(:,:,1043))
  call heltable([6,12,72], n3(:,2400), t3x72(:,:,1044))
  call heltable([6,12,72], n3(:,2401), t3x72(:,:,1045))
  call heltable([6,12,72], n3(:,2402), t3x72(:,:,1046))
  call heltable([4,18,72], n3(:,2403), t3x72(:,:,1047))
  call heltable([4,18,72], n3(:,2404), t3x72(:,:,1048))
  call heltable([12,6,72], n3(:,2405), t3x72(:,:,1049))
  call heltable([12,6,72], n3(:,2406), t3x72(:,:,1050))
  call heltable([12,6,72], n3(:,2407), t3x72(:,:,1051))
  call heltable([12,6,72], n3(:,2408), t3x72(:,:,1052))
  call heltable([9,8,72], n3(:,2409), t3x72(:,:,1053))
  call heltable([12,6,72], n3(:,2410), t3x72(:,:,1054))
  call heltable([12,6,72], n3(:,2411), t3x72(:,:,1055))
  call heltable([6,12,72], n3(:,2412), t3x72(:,:,1056))
  call heltable([6,12,72], n3(:,2413), t3x72(:,:,1057))
  call heltable([4,18,72], n3(:,2414), t3x72(:,:,1058))
  call heltable([4,18,72], n3(:,2415), t3x72(:,:,1059))
  call heltable([4,18,72], n3(:,2416), t3x72(:,:,1060))
  call heltable([4,18,72], n3(:,2417), t3x72(:,:,1061))
  call heltable([4,18,72], n3(:,2418), t3x72(:,:,1062))
  call heltable([12,6,72], n3(:,2419), t3x72(:,:,1063))
  call heltable([12,6,72], n3(:,2420), t3x72(:,:,1064))
  call heltable([12,6,72], n3(:,2421), t3x72(:,:,1065))
  call heltable([12,6,72], n3(:,2422), t3x72(:,:,1066))
  call heltable([9,8,72], n3(:,2423), t3x72(:,:,1067))
  call heltable([12,6,72], n3(:,2424), t3x72(:,:,1068))
  call heltable([12,6,72], n3(:,2425), t3x72(:,:,1069))
  call heltable([6,12,72], n3(:,2426), t3x72(:,:,1070))
  call heltable([6,12,72], n3(:,2427), t3x72(:,:,1071))
  call heltable([4,18,72], n3(:,2428), t3x72(:,:,1072))
  call heltable([4,18,72], n3(:,2429), t3x72(:,:,1073))
  call heltable([4,18,72], n3(:,2430), t3x72(:,:,1074))
  call heltable([4,18,72], n3(:,2431), t3x72(:,:,1075))
  call heltable([4,18,72], n3(:,2432), t3x72(:,:,1076))
  call heltable([12,6,72], n3(:,2433), t3x72(:,:,1077))
  call heltable([12,6,72], n3(:,2434), t3x72(:,:,1078))
  call heltable([12,6,72], n3(:,2435), t3x72(:,:,1079))
  call heltable([12,6,72], n3(:,2436), t3x72(:,:,1080))
  call heltable([9,8,72], n3(:,2437), t3x72(:,:,1081))
  call heltable([12,6,72], n3(:,2438), t3x72(:,:,1082))
  call heltable([12,6,72], n3(:,2439), t3x72(:,:,1083))
  call heltable([6,12,72], n3(:,2440), t3x72(:,:,1084))
  call heltable([6,12,72], n3(:,2441), t3x72(:,:,1085))
  call heltable([4,18,72], n3(:,2442), t3x72(:,:,1086))
  call heltable([4,18,72], n3(:,2443), t3x72(:,:,1087))
  call heltable([4,18,72], n3(:,2444), t3x72(:,:,1088))
  call heltable([4,18,72], n3(:,2445), t3x72(:,:,1089))
  call heltable([4,18,72], n3(:,2446), t3x72(:,:,1090))
  call heltable([12,6,72], n3(:,2447), t3x72(:,:,1091))
  call heltable([12,6,72], n3(:,2448), t3x72(:,:,1092))
  call heltable([12,6,72], n3(:,2449), t3x72(:,:,1093))
  call heltable([12,6,72], n3(:,2450), t3x72(:,:,1094))
  call heltable([9,8,72], n3(:,2451), t3x72(:,:,1095))
  call heltable([12,6,72], n3(:,2452), t3x72(:,:,1096))
  call heltable([12,6,72], n3(:,2453), t3x72(:,:,1097))
  call heltable([6,12,72], n3(:,2454), t3x72(:,:,1098))
  call heltable([6,12,72], n3(:,2455), t3x72(:,:,1099))
  call heltable([4,18,72], n3(:,2456), t3x72(:,:,1100))
  call heltable([4,18,72], n3(:,2457), t3x72(:,:,1101))
  call heltable([4,18,72], n3(:,2458), t3x72(:,:,1102))
  call heltable([4,18,72], n3(:,2459), t3x72(:,:,1103))
  call heltable([4,18,72], n3(:,2460), t3x72(:,:,1104))
  call heltable([6,12,72], n3(:,2461), t3x72(:,:,1105))
  call heltable([4,18,72], n3(:,2462), t3x72(:,:,1106))
  call heltable([6,12,72], n3(:,2463), t3x72(:,:,1107))
  call heltable([4,18,72], n3(:,2464), t3x72(:,:,1108))
  call heltable([4,18,72], n3(:,2465), t3x72(:,:,1109))
  call heltable([4,18,72], n3(:,2466), t3x72(:,:,1110))
  call heltable([12,6,72], n3(:,2467), t3x72(:,:,1111))
  call heltable([12,6,72], n3(:,2468), t3x72(:,:,1112))
  call heltable([12,6,72], n3(:,2469), t3x72(:,:,1113))
  call heltable([12,6,72], n3(:,2470), t3x72(:,:,1114))
  call heltable([12,6,72], n3(:,2471), t3x72(:,:,1115))
  call heltable([12,6,72], n3(:,2472), t3x72(:,:,1116))
  call heltable([12,6,72], n3(:,2473), t3x72(:,:,1117))
  call heltable([12,6,72], n3(:,2474), t3x72(:,:,1118))
  call heltable([12,6,72], n3(:,2475), t3x72(:,:,1119))
  call heltable([12,6,72], n3(:,2476), t3x72(:,:,1120))
  call heltable([12,6,72], n3(:,2477), t3x72(:,:,1121))
  call heltable([12,6,72], n3(:,2478), t3x72(:,:,1122))
  call heltable([12,6,72], n3(:,2479), t3x72(:,:,1123))
  call heltable([12,6,72], n3(:,2480), t3x72(:,:,1124))
  call heltable([12,6,72], n3(:,2481), t3x72(:,:,1125))
  call heltable([12,6,72], n3(:,2482), t3x72(:,:,1126))
  call heltable([8,9,72], n3(:,2483), t3x72(:,:,1127))
  call heltable([8,9,72], n3(:,2484), t3x72(:,:,1128))
  call heltable([6,12,72], n3(:,2485), t3x72(:,:,1129))
  call heltable([6,12,72], n3(:,2486), t3x72(:,:,1130))
  call heltable([6,12,72], n3(:,2487), t3x72(:,:,1131))
  call heltable([6,12,72], n3(:,2488), t3x72(:,:,1132))
  call heltable([6,12,72], n3(:,2489), t3x72(:,:,1133))
  call heltable([6,12,72], n3(:,2490), t3x72(:,:,1134))
  call heltable([6,12,72], n3(:,2491), t3x72(:,:,1135))
  call heltable([6,12,72], n3(:,2492), t3x72(:,:,1136))
  call heltable([6,12,72], n3(:,2493), t3x72(:,:,1137))
  call heltable([6,12,72], n3(:,2494), t3x72(:,:,1138))
  call heltable([6,12,72], n3(:,2495), t3x72(:,:,1139))
  call heltable([6,12,72], n3(:,2496), t3x72(:,:,1140))
  call heltable([6,12,72], n3(:,2497), t3x72(:,:,1141))
  call heltable([6,12,72], n3(:,2498), t3x72(:,:,1142))
  call heltable([6,12,72], n3(:,2499), t3x72(:,:,1143))
  call heltable([6,12,72], n3(:,2500), t3x72(:,:,1144))
  call heltable([8,9,72], n3(:,2501), t3x72(:,:,1145))
  call heltable([8,9,72], n3(:,2502), t3x72(:,:,1146))
  call heltable([6,12,72], n3(:,2503), t3x72(:,:,1147))
  call heltable([6,12,72], n3(:,2504), t3x72(:,:,1148))
  call heltable([6,12,72], n3(:,2505), t3x72(:,:,1149))
  call heltable([6,12,72], n3(:,2506), t3x72(:,:,1150))
  call heltable([6,12,72], n3(:,2507), t3x72(:,:,1151))
  call heltable([6,12,72], n3(:,2508), t3x72(:,:,1152))
  call heltable([6,12,72], n3(:,2509), t3x72(:,:,1153))
  call heltable([6,12,72], n3(:,2510), t3x72(:,:,1154))
  call heltable([6,12,72], n3(:,2511), t3x72(:,:,1155))
  call heltable([6,12,72], n3(:,2512), t3x72(:,:,1156))
  call heltable([6,12,72], n3(:,2513), t3x72(:,:,1157))
  call heltable([6,12,72], n3(:,2514), t3x72(:,:,1158))
  call heltable([6,12,72], n3(:,2515), t3x72(:,:,1159))
  call heltable([6,12,72], n3(:,2516), t3x72(:,:,1160))
  call heltable([6,12,72], n3(:,2517), t3x72(:,:,1161))
  call heltable([6,12,72], n3(:,2518), t3x72(:,:,1162))
  call heltable([4,18,72], n3(:,2519), t3x72(:,:,1163))
  call heltable([4,18,72], n3(:,2520), t3x72(:,:,1164))
  call heltable([12,6,72], n3(:,2521), t3x72(:,:,1165))
  call heltable([12,6,72], n3(:,2522), t3x72(:,:,1166))
  call heltable([12,6,72], n3(:,2523), t3x72(:,:,1167))
  call heltable([12,6,72], n3(:,2524), t3x72(:,:,1168))
  call heltable([9,8,72], n3(:,2525), t3x72(:,:,1169))
  call heltable([12,6,72], n3(:,2526), t3x72(:,:,1170))
  call heltable([12,6,72], n3(:,2527), t3x72(:,:,1171))
  call heltable([6,12,72], n3(:,2528), t3x72(:,:,1172))
  call heltable([6,12,72], n3(:,2529), t3x72(:,:,1173))
  call heltable([4,18,72], n3(:,2530), t3x72(:,:,1174))
  call heltable([4,18,72], n3(:,2531), t3x72(:,:,1175))
  call heltable([4,18,72], n3(:,2532), t3x72(:,:,1176))
  call heltable([4,18,72], n3(:,2533), t3x72(:,:,1177))
  call heltable([4,18,72], n3(:,2534), t3x72(:,:,1178))
  call heltable([12,6,72], n3(:,2535), t3x72(:,:,1179))
  call heltable([12,6,72], n3(:,2536), t3x72(:,:,1180))
  call heltable([12,6,72], n3(:,2537), t3x72(:,:,1181))
  call heltable([12,6,72], n3(:,2538), t3x72(:,:,1182))
  call heltable([9,8,72], n3(:,2539), t3x72(:,:,1183))
  call heltable([12,6,72], n3(:,2540), t3x72(:,:,1184))
  call heltable([12,6,72], n3(:,2541), t3x72(:,:,1185))
  call heltable([6,12,72], n3(:,2542), t3x72(:,:,1186))
  call heltable([6,12,72], n3(:,2543), t3x72(:,:,1187))
  call heltable([4,18,72], n3(:,2544), t3x72(:,:,1188))
  call heltable([4,18,72], n3(:,2545), t3x72(:,:,1189))
  call heltable([4,18,72], n3(:,2546), t3x72(:,:,1190))
  call heltable([4,18,72], n3(:,2547), t3x72(:,:,1191))
  call heltable([4,18,72], n3(:,2548), t3x72(:,:,1192))
  call heltable([12,6,72], n3(:,2549), t3x72(:,:,1193))
  call heltable([12,6,72], n3(:,2550), t3x72(:,:,1194))
  call heltable([12,6,72], n3(:,2551), t3x72(:,:,1195))
  call heltable([12,6,72], n3(:,2552), t3x72(:,:,1196))
  call heltable([9,8,72], n3(:,2553), t3x72(:,:,1197))
  call heltable([12,6,72], n3(:,2554), t3x72(:,:,1198))
  call heltable([12,6,72], n3(:,2555), t3x72(:,:,1199))
  call heltable([6,12,72], n3(:,2556), t3x72(:,:,1200))
  call heltable([6,12,72], n3(:,2557), t3x72(:,:,1201))
  call heltable([4,18,72], n3(:,2558), t3x72(:,:,1202))
  call heltable([4,18,72], n3(:,2559), t3x72(:,:,1203))
  call heltable([4,18,72], n3(:,2560), t3x72(:,:,1204))
  call heltable([4,18,72], n3(:,2561), t3x72(:,:,1205))
  call heltable([4,18,72], n3(:,2562), t3x72(:,:,1206))
  call heltable([12,6,72], n3(:,2563), t3x72(:,:,1207))
  call heltable([12,6,72], n3(:,2564), t3x72(:,:,1208))
  call heltable([12,6,72], n3(:,2565), t3x72(:,:,1209))
  call heltable([12,6,72], n3(:,2566), t3x72(:,:,1210))
  call heltable([9,8,72], n3(:,2567), t3x72(:,:,1211))
  call heltable([12,6,72], n3(:,2568), t3x72(:,:,1212))
  call heltable([12,6,72], n3(:,2569), t3x72(:,:,1213))
  call heltable([6,12,72], n3(:,2570), t3x72(:,:,1214))
  call heltable([6,12,72], n3(:,2571), t3x72(:,:,1215))
  call heltable([4,18,72], n3(:,2572), t3x72(:,:,1216))
  call heltable([4,18,72], n3(:,2573), t3x72(:,:,1217))
  call heltable([4,18,72], n3(:,2574), t3x72(:,:,1218))
  call heltable([24,3,72], n3(:,2575), t3x72(:,:,1219))
  call heltable([24,3,72], n3(:,2576), t3x72(:,:,1220))
  call heltable([24,3,72], n3(:,2577), t3x72(:,:,1221))
  call heltable([24,3,72], n3(:,2578), t3x72(:,:,1222))
  call heltable([24,3,72], n3(:,2579), t3x72(:,:,1223))
  call heltable([24,3,72], n3(:,2580), t3x72(:,:,1224))
  call heltable([24,3,72], n3(:,2581), t3x72(:,:,1225))
  call heltable([24,3,72], n3(:,2582), t3x72(:,:,1226))
  call heltable([3,24,72], n3(:,2583), t3x72(:,:,1227))
  call heltable([3,24,72], n3(:,2584), t3x72(:,:,1228))
  call heltable([3,24,72], n3(:,2585), t3x72(:,:,1229))
  call heltable([3,24,72], n3(:,2586), t3x72(:,:,1230))
  call heltable([3,24,72], n3(:,2587), t3x72(:,:,1231))
  call heltable([3,24,72], n3(:,2588), t3x72(:,:,1232))
  call heltable([3,24,72], n3(:,2589), t3x72(:,:,1233))
  call heltable([3,24,72], n3(:,2590), t3x72(:,:,1234))
  call heltable([3,24,72], n3(:,2591), t3x72(:,:,1235))
  call heltable([3,24,72], n3(:,2592), t3x72(:,:,1236))
  call heltable([3,24,72], n3(:,2593), t3x72(:,:,1237))
  call heltable([3,24,72], n3(:,2594), t3x72(:,:,1238))
  call heltable([3,24,72], n3(:,2595), t3x72(:,:,1239))
  call heltable([3,24,72], n3(:,2596), t3x72(:,:,1240))
  call heltable([3,24,72], n3(:,2597), t3x72(:,:,1241))
  call heltable([3,24,72], n3(:,2598), t3x72(:,:,1242))
  call heltable([3,24,72], n3(:,2599), t3x72(:,:,1243))
  call heltable([3,24,72], n3(:,2600), t3x72(:,:,1244))
  call heltable([3,24,72], n3(:,2601), t3x72(:,:,1245))
  call heltable([3,24,72], n3(:,2602), t3x72(:,:,1246))
  call heltable([3,24,72], n3(:,2603), t3x72(:,:,1247))
  call heltable([3,24,72], n3(:,2604), t3x72(:,:,1248))
  call heltable([3,24,72], n3(:,2605), t3x72(:,:,1249))
  call heltable([3,24,72], n3(:,2606), t3x72(:,:,1250))
  call heltable([24,3,72], n3(:,2607), t3x72(:,:,1251))
  call heltable([24,3,72], n3(:,2608), t3x72(:,:,1252))
  call heltable([24,3,72], n3(:,2609), t3x72(:,:,1253))
  call heltable([24,3,72], n3(:,2610), t3x72(:,:,1254))
  call heltable([24,3,72], n3(:,2611), t3x72(:,:,1255))
  call heltable([24,3,72], n3(:,2612), t3x72(:,:,1256))
  call heltable([24,3,72], n3(:,2613), t3x72(:,:,1257))
  call heltable([24,3,72], n3(:,2614), t3x72(:,:,1258))
  call heltable([3,24,72], n3(:,2615), t3x72(:,:,1259))
  call heltable([3,24,72], n3(:,2616), t3x72(:,:,1260))
  call heltable([3,24,72], n3(:,2617), t3x72(:,:,1261))
  call heltable([3,24,72], n3(:,2618), t3x72(:,:,1262))
  call heltable([3,24,72], n3(:,2619), t3x72(:,:,1263))
  call heltable([3,24,72], n3(:,2620), t3x72(:,:,1264))
  call heltable([3,24,72], n3(:,2621), t3x72(:,:,1265))
  call heltable([3,24,72], n3(:,2622), t3x72(:,:,1266))
  call heltable([3,24,72], n3(:,2623), t3x72(:,:,1267))
  call heltable([3,24,72], n3(:,2624), t3x72(:,:,1268))
  call heltable([3,24,72], n3(:,2625), t3x72(:,:,1269))
  call heltable([3,24,72], n3(:,2626), t3x72(:,:,1270))
  call heltable([3,24,72], n3(:,2627), t3x72(:,:,1271))
  call heltable([3,24,72], n3(:,2628), t3x72(:,:,1272))
  call heltable([3,24,72], n3(:,2629), t3x72(:,:,1273))
  call heltable([3,24,72], n3(:,2630), t3x72(:,:,1274))
  call heltable([3,24,72], n3(:,2631), t3x72(:,:,1275))
  call heltable([3,24,72], n3(:,2632), t3x72(:,:,1276))
  call heltable([3,24,72], n3(:,2633), t3x72(:,:,1277))
  call heltable([3,24,72], n3(:,2634), t3x72(:,:,1278))
  call heltable([3,24,72], n3(:,2635), t3x72(:,:,1279))
  call heltable([3,24,72], n3(:,2636), t3x72(:,:,1280))
  call heltable([3,24,72], n3(:,2637), t3x72(:,:,1281))
  call heltable([3,24,72], n3(:,2638), t3x72(:,:,1282))
  call heltable([3,24,72], n3(:,2639), t3x72(:,:,1283))
  call heltable([3,24,72], n3(:,2640), t3x72(:,:,1284))
  call heltable([3,24,72], n3(:,2641), t3x72(:,:,1285))
  call heltable([3,24,72], n3(:,2642), t3x72(:,:,1286))
  call heltable([3,24,72], n3(:,2643), t3x72(:,:,1287))
  call heltable([3,24,72], n3(:,2644), t3x72(:,:,1288))
  call heltable([3,24,72], n3(:,2645), t3x72(:,:,1289))
  call heltable([3,24,72], n3(:,2646), t3x72(:,:,1290))
  call heltable([3,24,72], n3(:,2647), t3x72(:,:,1291))
  call heltable([3,24,72], n3(:,2648), t3x72(:,:,1292))
  call heltable([3,24,72], n3(:,2649), t3x72(:,:,1293))
  call heltable([3,24,72], n3(:,2650), t3x72(:,:,1294))
  call heltable([3,24,72], n3(:,2651), t3x72(:,:,1295))
  call heltable([3,24,72], n3(:,2652), t3x72(:,:,1296))
  call heltable([3,24,72], n3(:,2653), t3x72(:,:,1297))
  call heltable([3,24,72], n3(:,2654), t3x72(:,:,1298))
  call heltable([3,24,72], n3(:,2655), t3x72(:,:,1299))
  call heltable([3,24,72], n3(:,2656), t3x72(:,:,1300))
  call heltable([3,24,72], n3(:,2657), t3x72(:,:,1301))
  call heltable([3,24,72], n3(:,2658), t3x72(:,:,1302))
  call heltable([3,24,72], n3(:,2659), t3x72(:,:,1303))
  call heltable([3,24,72], n3(:,2660), t3x72(:,:,1304))
  call heltable([3,24,72], n3(:,2661), t3x72(:,:,1305))
  call heltable([3,24,72], n3(:,2662), t3x72(:,:,1306))
  call heltable([3,24,72], n3(:,2663), t3x72(:,:,1307))
  call heltable([3,24,72], n3(:,2664), t3x72(:,:,1308))
  call heltable([3,24,72], n3(:,2665), t3x72(:,:,1309))
  call heltable([3,24,72], n3(:,2666), t3x72(:,:,1310))
  call heltable([3,24,72], n3(:,2667), t3x72(:,:,1311))
  call heltable([3,24,72], n3(:,2668), t3x72(:,:,1312))
  call heltable([3,24,72], n3(:,2669), t3x72(:,:,1313))
  call heltable([3,24,72], n3(:,2670), t3x72(:,:,1314))
  call heltable([3,24,72], n3(:,2671), t3x72(:,:,1315))
  call heltable([3,24,72], n3(:,2672), t3x72(:,:,1316))
  call heltable([3,24,72], n3(:,2673), t3x72(:,:,1317))
  call heltable([3,24,72], n3(:,2674), t3x72(:,:,1318))
  call heltable([3,24,72], n3(:,2675), t3x72(:,:,1319))
  call heltable([3,24,72], n3(:,2676), t3x72(:,:,1320))
  call heltable([3,24,72], n3(:,2677), t3x72(:,:,1321))
  call heltable([3,24,72], n3(:,2678), t3x72(:,:,1322))
  call heltable([3,24,72], n3(:,2679), t3x72(:,:,1323))
  call heltable([3,24,72], n3(:,2680), t3x72(:,:,1324))
  call heltable([3,24,72], n3(:,2681), t3x72(:,:,1325))
  call heltable([3,24,72], n3(:,2682), t3x72(:,:,1326))
  call heltable([3,24,72], n3(:,2683), t3x72(:,:,1327))
  call heltable([3,24,72], n3(:,2684), t3x72(:,:,1328))
  call heltable([3,24,72], n3(:,2685), t3x72(:,:,1329))
  call heltable([3,24,72], n3(:,2686), t3x72(:,:,1330))
  call heltable([3,24,72], n3(:,2687), t3x72(:,:,1331))
  call heltable([3,24,72], n3(:,2688), t3x72(:,:,1332))
  call heltable([3,24,72], n3(:,2689), t3x72(:,:,1333))
  call heltable([3,24,72], n3(:,2690), t3x72(:,:,1334))
  call heltable([3,24,72], n3(:,2691), t3x72(:,:,1335))
  call heltable([3,24,72], n3(:,2692), t3x72(:,:,1336))
  call heltable([3,24,72], n3(:,2693), t3x72(:,:,1337))
  call heltable([3,24,72], n3(:,2694), t3x72(:,:,1338))
  call heltable([3,24,72], n3(:,2695), t3x72(:,:,1339))
  call heltable([3,24,72], n3(:,2696), t3x72(:,:,1340))
  call heltable([3,24,72], n3(:,2697), t3x72(:,:,1341))
  call heltable([3,24,72], n3(:,2698), t3x72(:,:,1342))
  call heltable([3,24,72], n3(:,2699), t3x72(:,:,1343))
  call heltable([3,24,72], n3(:,2700), t3x72(:,:,1344))
  call heltable([3,24,72], n3(:,2701), t3x72(:,:,1345))
  call heltable([3,24,72], n3(:,2702), t3x72(:,:,1346))
  call heltable([12,6,72], n3(:,2703), t3x72(:,:,1347))
  call heltable([12,6,72], n3(:,2704), t3x72(:,:,1348))
  call heltable([12,6,72], n3(:,2705), t3x72(:,:,1349))
  call heltable([12,6,72], n3(:,2706), t3x72(:,:,1350))
  call heltable([12,6,72], n3(:,2707), t3x72(:,:,1351))
  call heltable([12,6,72], n3(:,2708), t3x72(:,:,1352))
  call heltable([12,6,72], n3(:,2709), t3x72(:,:,1353))
  call heltable([12,6,72], n3(:,2710), t3x72(:,:,1354))
  call heltable([12,6,72], n3(:,2711), t3x72(:,:,1355))
  call heltable([12,6,72], n3(:,2712), t3x72(:,:,1356))
  call heltable([12,6,72], n3(:,2713), t3x72(:,:,1357))
  call heltable([12,6,72], n3(:,2714), t3x72(:,:,1358))
  call heltable([12,6,72], n3(:,2715), t3x72(:,:,1359))
  call heltable([12,6,72], n3(:,2716), t3x72(:,:,1360))
  call heltable([12,6,72], n3(:,2717), t3x72(:,:,1361))
  call heltable([12,6,72], n3(:,2718), t3x72(:,:,1362))
  call heltable([3,24,72], n3(:,2719), t3x72(:,:,1363))
  call heltable([3,24,72], n3(:,2720), t3x72(:,:,1364))
  call heltable([3,24,72], n3(:,2721), t3x72(:,:,1365))
  call heltable([3,24,72], n3(:,2722), t3x72(:,:,1366))
  call heltable([3,24,72], n3(:,2723), t3x72(:,:,1367))
  call heltable([3,24,72], n3(:,2724), t3x72(:,:,1368))
  call heltable([3,24,72], n3(:,2725), t3x72(:,:,1369))
  call heltable([3,24,72], n3(:,2726), t3x72(:,:,1370))
  call heltable([36,2,72], n3(:,2727), t3x72(:,:,1371))
  call heltable([2,36,72], n3(:,2728), t3x72(:,:,1372))
  call heltable([3,24,72], n3(:,2729), t3x72(:,:,1373))
  call heltable([3,24,72], n3(:,2730), t3x72(:,:,1374))
  call heltable([3,24,72], n3(:,2731), t3x72(:,:,1375))
  call heltable([3,24,72], n3(:,2732), t3x72(:,:,1376))
  call heltable([3,24,72], n3(:,2733), t3x72(:,:,1377))
  call heltable([3,24,72], n3(:,2734), t3x72(:,:,1378))
  call heltable([3,24,72], n3(:,2735), t3x72(:,:,1379))
  call heltable([3,24,72], n3(:,2736), t3x72(:,:,1380))
  call heltable([3,24,72], n3(:,2737), t3x72(:,:,1381))
  call heltable([3,24,72], n3(:,2738), t3x72(:,:,1382))
  call heltable([3,24,72], n3(:,2739), t3x72(:,:,1383))
  call heltable([3,24,72], n3(:,2740), t3x72(:,:,1384))
  call heltable([3,24,72], n3(:,2741), t3x72(:,:,1385))
  call heltable([3,24,72], n3(:,2742), t3x72(:,:,1386))
  call heltable([3,24,72], n3(:,2743), t3x72(:,:,1387))
  call heltable([3,24,72], n3(:,2744), t3x72(:,:,1388))
  call heltable([2,36,72], n3(:,2745), t3x72(:,:,1389))
  call heltable([2,36,72], n3(:,2746), t3x72(:,:,1390))
  call heltable([2,36,72], n3(:,2747), t3x72(:,:,1391))
  call heltable([2,36,72], n3(:,2748), t3x72(:,:,1392))
  call heltable([12,6,72], n3(:,2749), t3x72(:,:,1393))
  call heltable([12,6,72], n3(:,2750), t3x72(:,:,1394))
  call heltable([12,6,72], n3(:,2751), t3x72(:,:,1395))
  call heltable([12,6,72], n3(:,2752), t3x72(:,:,1396))
  call heltable([12,6,72], n3(:,2753), t3x72(:,:,1397))
  call heltable([12,6,72], n3(:,2754), t3x72(:,:,1398))
  call heltable([12,6,72], n3(:,2755), t3x72(:,:,1399))
  call heltable([12,6,72], n3(:,2756), t3x72(:,:,1400))
  call heltable([8,9,72], n3(:,2757), t3x72(:,:,1401))
  call heltable([8,9,72], n3(:,2758), t3x72(:,:,1402))
  call heltable([8,9,72], n3(:,2759), t3x72(:,:,1403))
  call heltable([8,9,72], n3(:,2760), t3x72(:,:,1404))
  call heltable([8,9,72], n3(:,2761), t3x72(:,:,1405))
  call heltable([8,9,72], n3(:,2762), t3x72(:,:,1406))
  call heltable([8,9,72], n3(:,2763), t3x72(:,:,1407))
  call heltable([8,9,72], n3(:,2764), t3x72(:,:,1408))
  call heltable([12,6,72], n3(:,2765), t3x72(:,:,1409))
  call heltable([18,4,72], n3(:,2766), t3x72(:,:,1410))
  call heltable([4,18,72], n3(:,2767), t3x72(:,:,1411))
  call heltable([4,18,72], n3(:,2768), t3x72(:,:,1412))
  call heltable([3,24,72], n3(:,2769), t3x72(:,:,1413))
  call heltable([3,24,72], n3(:,2770), t3x72(:,:,1414))
  call heltable([3,24,72], n3(:,2771), t3x72(:,:,1415))
  call heltable([3,24,72], n3(:,2772), t3x72(:,:,1416))
  call heltable([3,24,72], n3(:,2773), t3x72(:,:,1417))
  call heltable([3,24,72], n3(:,2774), t3x72(:,:,1418))
  call heltable([3,24,72], n3(:,2775), t3x72(:,:,1419))
  call heltable([3,24,72], n3(:,2776), t3x72(:,:,1420))
  call heltable([2,36,72], n3(:,2777), t3x72(:,:,1421))
  call heltable([2,36,72], n3(:,2778), t3x72(:,:,1422))
  call heltable([3,24,72], n3(:,2779), t3x72(:,:,1423))
  call heltable([3,24,72], n3(:,2780), t3x72(:,:,1424))
  call heltable([3,24,72], n3(:,2781), t3x72(:,:,1425))
  call heltable([3,24,72], n3(:,2782), t3x72(:,:,1426))
  call heltable([3,24,72], n3(:,2783), t3x72(:,:,1427))
  call heltable([3,24,72], n3(:,2784), t3x72(:,:,1428))
  call heltable([3,24,72], n3(:,2785), t3x72(:,:,1429))
  call heltable([3,24,72], n3(:,2786), t3x72(:,:,1430))
  call heltable([3,24,72], n3(:,2787), t3x72(:,:,1431))
  call heltable([3,24,72], n3(:,2788), t3x72(:,:,1432))
  call heltable([3,24,72], n3(:,2789), t3x72(:,:,1433))
  call heltable([3,24,72], n3(:,2790), t3x72(:,:,1434))
  call heltable([3,24,72], n3(:,2791), t3x72(:,:,1435))
  call heltable([3,24,72], n3(:,2792), t3x72(:,:,1436))
  call heltable([3,24,72], n3(:,2793), t3x72(:,:,1437))
  call heltable([3,24,72], n3(:,2794), t3x72(:,:,1438))
  call heltable([2,36,72], n3(:,2795), t3x72(:,:,1439))
  call heltable([2,36,72], n3(:,2796), t3x72(:,:,1440))
  call heltable([2,36,72], n3(:,2797), t3x72(:,:,1441))
  call heltable([2,36,72], n3(:,2798), t3x72(:,:,1442))
  call heltable([12,6,72], n3(:,2799), t3x72(:,:,1443))
  call heltable([12,6,72], n3(:,2800), t3x72(:,:,1444))
  call heltable([12,6,72], n3(:,2801), t3x72(:,:,1445))
  call heltable([12,6,72], n3(:,2802), t3x72(:,:,1446))
  call heltable([12,6,72], n3(:,2803), t3x72(:,:,1447))
  call heltable([12,6,72], n3(:,2804), t3x72(:,:,1448))
  call heltable([12,6,72], n3(:,2805), t3x72(:,:,1449))
  call heltable([12,6,72], n3(:,2806), t3x72(:,:,1450))
  call heltable([8,9,72], n3(:,2807), t3x72(:,:,1451))
  call heltable([8,9,72], n3(:,2808), t3x72(:,:,1452))
  call heltable([8,9,72], n3(:,2809), t3x72(:,:,1453))
  call heltable([8,9,72], n3(:,2810), t3x72(:,:,1454))
  call heltable([8,9,72], n3(:,2811), t3x72(:,:,1455))
  call heltable([8,9,72], n3(:,2812), t3x72(:,:,1456))
  call heltable([8,9,72], n3(:,2813), t3x72(:,:,1457))
  call heltable([8,9,72], n3(:,2814), t3x72(:,:,1458))
  call heltable([12,6,72], n3(:,2815), t3x72(:,:,1459))
  call heltable([4,18,72], n3(:,2816), t3x72(:,:,1460))
  call heltable([4,18,72], n3(:,2817), t3x72(:,:,1461))
  call heltable([4,18,72], n3(:,2818), t3x72(:,:,1462))
  call heltable([3,24,72], n3(:,2819), t3x72(:,:,1463))
  call heltable([3,24,72], n3(:,2820), t3x72(:,:,1464))
  call heltable([3,24,72], n3(:,2821), t3x72(:,:,1465))
  call heltable([3,24,72], n3(:,2822), t3x72(:,:,1466))
  call heltable([3,24,72], n3(:,2823), t3x72(:,:,1467))
  call heltable([3,24,72], n3(:,2824), t3x72(:,:,1468))
  call heltable([3,24,72], n3(:,2825), t3x72(:,:,1469))
  call heltable([3,24,72], n3(:,2826), t3x72(:,:,1470))
  call heltable([36,2,72], n3(:,2827), t3x72(:,:,1471))
  call heltable([2,36,72], n3(:,2828), t3x72(:,:,1472))
  call heltable([3,24,72], n3(:,2829), t3x72(:,:,1473))
  call heltable([3,24,72], n3(:,2830), t3x72(:,:,1474))
  call heltable([3,24,72], n3(:,2831), t3x72(:,:,1475))
  call heltable([3,24,72], n3(:,2832), t3x72(:,:,1476))
  call heltable([3,24,72], n3(:,2833), t3x72(:,:,1477))
  call heltable([3,24,72], n3(:,2834), t3x72(:,:,1478))
  call heltable([3,24,72], n3(:,2835), t3x72(:,:,1479))
  call heltable([3,24,72], n3(:,2836), t3x72(:,:,1480))
  call heltable([3,24,72], n3(:,2837), t3x72(:,:,1481))
  call heltable([3,24,72], n3(:,2838), t3x72(:,:,1482))
  call heltable([3,24,72], n3(:,2839), t3x72(:,:,1483))
  call heltable([3,24,72], n3(:,2840), t3x72(:,:,1484))
  call heltable([3,24,72], n3(:,2841), t3x72(:,:,1485))
  call heltable([3,24,72], n3(:,2842), t3x72(:,:,1486))
  call heltable([3,24,72], n3(:,2843), t3x72(:,:,1487))
  call heltable([3,24,72], n3(:,2844), t3x72(:,:,1488))
  call heltable([2,36,72], n3(:,2845), t3x72(:,:,1489))
  call heltable([2,36,72], n3(:,2846), t3x72(:,:,1490))
  call heltable([2,36,72], n3(:,2847), t3x72(:,:,1491))
  call heltable([2,36,72], n3(:,2848), t3x72(:,:,1492))
  call heltable([12,6,72], n3(:,2849), t3x72(:,:,1493))
  call heltable([12,6,72], n3(:,2850), t3x72(:,:,1494))
  call heltable([12,6,72], n3(:,2851), t3x72(:,:,1495))
  call heltable([12,6,72], n3(:,2852), t3x72(:,:,1496))
  call heltable([12,6,72], n3(:,2853), t3x72(:,:,1497))
  call heltable([12,6,72], n3(:,2854), t3x72(:,:,1498))
  call heltable([12,6,72], n3(:,2855), t3x72(:,:,1499))
  call heltable([12,6,72], n3(:,2856), t3x72(:,:,1500))
  call heltable([8,9,72], n3(:,2857), t3x72(:,:,1501))
  call heltable([8,9,72], n3(:,2858), t3x72(:,:,1502))
  call heltable([8,9,72], n3(:,2859), t3x72(:,:,1503))
  call heltable([8,9,72], n3(:,2860), t3x72(:,:,1504))
  call heltable([8,9,72], n3(:,2861), t3x72(:,:,1505))
  call heltable([8,9,72], n3(:,2862), t3x72(:,:,1506))
  call heltable([8,9,72], n3(:,2863), t3x72(:,:,1507))
  call heltable([8,9,72], n3(:,2864), t3x72(:,:,1508))
  call heltable([12,6,72], n3(:,2865), t3x72(:,:,1509))
  call heltable([18,4,72], n3(:,2866), t3x72(:,:,1510))
  call heltable([4,18,72], n3(:,2867), t3x72(:,:,1511))
  call heltable([4,18,72], n3(:,2868), t3x72(:,:,1512))
  call heltable([3,24,72], n3(:,2869), t3x72(:,:,1513))
  call heltable([3,24,72], n3(:,2870), t3x72(:,:,1514))
  call heltable([3,24,72], n3(:,2871), t3x72(:,:,1515))
  call heltable([3,24,72], n3(:,2872), t3x72(:,:,1516))
  call heltable([3,24,72], n3(:,2873), t3x72(:,:,1517))
  call heltable([3,24,72], n3(:,2874), t3x72(:,:,1518))
  call heltable([3,24,72], n3(:,2875), t3x72(:,:,1519))
  call heltable([3,24,72], n3(:,2876), t3x72(:,:,1520))
  call heltable([2,36,72], n3(:,2877), t3x72(:,:,1521))
  call heltable([2,36,72], n3(:,2878), t3x72(:,:,1522))
  call heltable([3,24,72], n3(:,2879), t3x72(:,:,1523))
  call heltable([3,24,72], n3(:,2880), t3x72(:,:,1524))
  call heltable([3,24,72], n3(:,2881), t3x72(:,:,1525))
  call heltable([3,24,72], n3(:,2882), t3x72(:,:,1526))
  call heltable([3,24,72], n3(:,2883), t3x72(:,:,1527))
  call heltable([3,24,72], n3(:,2884), t3x72(:,:,1528))
  call heltable([3,24,72], n3(:,2885), t3x72(:,:,1529))
  call heltable([3,24,72], n3(:,2886), t3x72(:,:,1530))
  call heltable([3,24,72], n3(:,2887), t3x72(:,:,1531))
  call heltable([3,24,72], n3(:,2888), t3x72(:,:,1532))
  call heltable([3,24,72], n3(:,2889), t3x72(:,:,1533))
  call heltable([3,24,72], n3(:,2890), t3x72(:,:,1534))
  call heltable([3,24,72], n3(:,2891), t3x72(:,:,1535))
  call heltable([3,24,72], n3(:,2892), t3x72(:,:,1536))
  call heltable([3,24,72], n3(:,2893), t3x72(:,:,1537))
  call heltable([3,24,72], n3(:,2894), t3x72(:,:,1538))
  call heltable([2,36,72], n3(:,2895), t3x72(:,:,1539))
  call heltable([2,36,72], n3(:,2896), t3x72(:,:,1540))
  call heltable([2,36,72], n3(:,2897), t3x72(:,:,1541))
  call heltable([2,36,72], n3(:,2898), t3x72(:,:,1542))
  call heltable([12,6,72], n3(:,2899), t3x72(:,:,1543))
  call heltable([12,6,72], n3(:,2900), t3x72(:,:,1544))
  call heltable([12,6,72], n3(:,2901), t3x72(:,:,1545))
  call heltable([12,6,72], n3(:,2902), t3x72(:,:,1546))
  call heltable([12,6,72], n3(:,2903), t3x72(:,:,1547))
  call heltable([12,6,72], n3(:,2904), t3x72(:,:,1548))
  call heltable([12,6,72], n3(:,2905), t3x72(:,:,1549))
  call heltable([12,6,72], n3(:,2906), t3x72(:,:,1550))
  call heltable([8,9,72], n3(:,2907), t3x72(:,:,1551))
  call heltable([8,9,72], n3(:,2908), t3x72(:,:,1552))
  call heltable([8,9,72], n3(:,2909), t3x72(:,:,1553))
  call heltable([8,9,72], n3(:,2910), t3x72(:,:,1554))
  call heltable([8,9,72], n3(:,2911), t3x72(:,:,1555))
  call heltable([8,9,72], n3(:,2912), t3x72(:,:,1556))
  call heltable([8,9,72], n3(:,2913), t3x72(:,:,1557))
  call heltable([8,9,72], n3(:,2914), t3x72(:,:,1558))
  call heltable([12,6,72], n3(:,2915), t3x72(:,:,1559))
  call heltable([4,18,72], n3(:,2916), t3x72(:,:,1560))
  call heltable([4,18,72], n3(:,2917), t3x72(:,:,1561))
  call heltable([4,18,72], n3(:,2918), t3x72(:,:,1562))
  call heltable([2,36,72], n3(:,2919), t3x72(:,:,1563))
  call heltable([2,36,72], n3(:,2920), t3x72(:,:,1564))
  call heltable([2,36,72], n3(:,2921), t3x72(:,:,1565))
  call heltable([2,36,72], n3(:,2922), t3x72(:,:,1566))
  call heltable([12,6,72], n3(:,2923), t3x72(:,:,1567))
  call heltable([4,18,72], n3(:,2924), t3x72(:,:,1568))
  call heltable([12,6,72], n3(:,2925), t3x72(:,:,1569))
  call heltable([4,18,72], n3(:,2926), t3x72(:,:,1570))
  call heltable([12,6,72], n3(:,2927), t3x72(:,:,1571))
  call heltable([12,6,72], n3(:,2928), t3x72(:,:,1572))
  call heltable([12,6,72], n3(:,2929), t3x72(:,:,1573))
  call heltable([4,18,72], n3(:,2930), t3x72(:,:,1574))
  call heltable([12,6,72], n3(:,2931), t3x72(:,:,1575))
  call heltable([4,18,72], n3(:,2932), t3x72(:,:,1576))
  call heltable([12,6,72], n3(:,2933), t3x72(:,:,1577))
  call heltable([12,6,72], n3(:,2934), t3x72(:,:,1578))
  call heltable([6,12,72], n3(:,2935), t3x72(:,:,1579))
  call heltable([6,12,72], n3(:,2936), t3x72(:,:,1580))
  call heltable([9,8,72], n3(:,2937), t3x72(:,:,1581))
  call heltable([9,8,72], n3(:,2938), t3x72(:,:,1582))
  call heltable([9,8,72], n3(:,2939), t3x72(:,:,1583))
  call heltable([9,8,72], n3(:,2940), t3x72(:,:,1584))
  call heltable([9,8,72], n3(:,2941), t3x72(:,:,1585))
  call heltable([9,8,72], n3(:,2942), t3x72(:,:,1586))
  call heltable([6,12,72], n3(:,2943), t3x72(:,:,1587))
  call heltable([6,12,72], n3(:,2944), t3x72(:,:,1588))
  call heltable([9,8,72], n3(:,2945), t3x72(:,:,1589))
  call heltable([9,8,72], n3(:,2946), t3x72(:,:,1590))
  call heltable([9,8,72], n3(:,2947), t3x72(:,:,1591))
  call heltable([9,8,72], n3(:,2948), t3x72(:,:,1592))
  call heltable([9,8,72], n3(:,2949), t3x72(:,:,1593))
  call heltable([9,8,72], n3(:,2950), t3x72(:,:,1594))
  call heltable([6,12,72], n3(:,2951), t3x72(:,:,1595))
  call heltable([6,12,72], n3(:,2952), t3x72(:,:,1596))
  call heltable([6,12,72], n3(:,2953), t3x72(:,:,1597))
  call heltable([12,6,72], n3(:,2954), t3x72(:,:,1598))
  call heltable([8,9,72], n3(:,2955), t3x72(:,:,1599))
  call heltable([8,9,72], n3(:,2956), t3x72(:,:,1600))
  call heltable([8,9,72], n3(:,2957), t3x72(:,:,1601))
  call heltable([8,9,72], n3(:,2958), t3x72(:,:,1602))
  call heltable([9,8,72], n3(:,2959), t3x72(:,:,1603))
  call heltable([9,8,72], n3(:,2960), t3x72(:,:,1604))
  call heltable([6,12,72], n3(:,2961), t3x72(:,:,1605))
  call heltable([12,6,72], n3(:,2962), t3x72(:,:,1606))
  call heltable([8,9,72], n3(:,2963), t3x72(:,:,1607))
  call heltable([8,9,72], n3(:,2964), t3x72(:,:,1608))
  call heltable([8,9,72], n3(:,2965), t3x72(:,:,1609))
  call heltable([8,9,72], n3(:,2966), t3x72(:,:,1610))
  call heltable([8,9,72], n3(:,2967), t3x72(:,:,1611))
  call heltable([8,9,72], n3(:,2968), t3x72(:,:,1612))
  call heltable([4,18,72], n3(:,2969), t3x72(:,:,1613))
  call heltable([12,6,72], n3(:,2970), t3x72(:,:,1614))
  call heltable([9,8,72], n3(:,2971), t3x72(:,:,1615))
  call heltable([9,8,72], n3(:,2972), t3x72(:,:,1616))
  call heltable([9,8,72], n3(:,2973), t3x72(:,:,1617))
  call heltable([9,8,72], n3(:,2974), t3x72(:,:,1618))
  call heltable([9,8,72], n3(:,2975), t3x72(:,:,1619))
  call heltable([9,8,72], n3(:,2976), t3x72(:,:,1620))
  call heltable([4,18,72], n3(:,2977), t3x72(:,:,1621))
  call heltable([12,6,72], n3(:,2978), t3x72(:,:,1622))
  call heltable([9,8,72], n3(:,2979), t3x72(:,:,1623))
  call heltable([9,8,72], n3(:,2980), t3x72(:,:,1624))
  call heltable([9,8,72], n3(:,2981), t3x72(:,:,1625))
  call heltable([9,8,72], n3(:,2982), t3x72(:,:,1626))
  call heltable([9,8,72], n3(:,2983), t3x72(:,:,1627))
  call heltable([9,8,72], n3(:,2984), t3x72(:,:,1628))
  call heltable([12,6,72], n3(:,2985), t3x72(:,:,1629))
  call heltable([6,12,72], n3(:,2986), t3x72(:,:,1630))
  call heltable([12,6,72], n3(:,2987), t3x72(:,:,1631))
  call heltable([6,12,72], n3(:,2988), t3x72(:,:,1632))
  call heltable([6,12,72], n3(:,2989), t3x72(:,:,1633))
  call heltable([12,6,72], n3(:,2990), t3x72(:,:,1634))
  call heltable([9,8,72], n3(:,2991), t3x72(:,:,1635))
  call heltable([9,8,72], n3(:,2992), t3x72(:,:,1636))
  call heltable([9,8,72], n3(:,2993), t3x72(:,:,1637))
  call heltable([9,8,72], n3(:,2994), t3x72(:,:,1638))
  call heltable([9,8,72], n3(:,2995), t3x72(:,:,1639))
  call heltable([9,8,72], n3(:,2996), t3x72(:,:,1640))
  call heltable([6,12,72], n3(:,2997), t3x72(:,:,1641))
  call heltable([12,6,72], n3(:,2998), t3x72(:,:,1642))
  call heltable([9,8,72], n3(:,2999), t3x72(:,:,1643))
  call heltable([9,8,72], n3(:,3000), t3x72(:,:,1644))
  call heltable([9,8,72], n3(:,3001), t3x72(:,:,1645))
  call heltable([9,8,72], n3(:,3002), t3x72(:,:,1646))
  call heltable([9,8,72], n3(:,3003), t3x72(:,:,1647))
  call heltable([9,8,72], n3(:,3004), t3x72(:,:,1648))
  call heltable([4,18,72], n3(:,3005), t3x72(:,:,1649))
  call heltable([12,6,72], n3(:,3006), t3x72(:,:,1650))
  call heltable([9,8,72], n3(:,3007), t3x72(:,:,1651))
  call heltable([9,8,72], n3(:,3008), t3x72(:,:,1652))
  call heltable([9,8,72], n3(:,3009), t3x72(:,:,1653))
  call heltable([9,8,72], n3(:,3010), t3x72(:,:,1654))
  call heltable([9,8,72], n3(:,3011), t3x72(:,:,1655))
  call heltable([9,8,72], n3(:,3012), t3x72(:,:,1656))
  call heltable([4,18,72], n3(:,3013), t3x72(:,:,1657))
  call heltable([12,6,72], n3(:,3014), t3x72(:,:,1658))
  call heltable([9,8,72], n3(:,3015), t3x72(:,:,1659))
  call heltable([9,8,72], n3(:,3016), t3x72(:,:,1660))
  call heltable([9,8,72], n3(:,3017), t3x72(:,:,1661))
  call heltable([9,8,72], n3(:,3018), t3x72(:,:,1662))
  call heltable([9,8,72], n3(:,3019), t3x72(:,:,1663))
  call heltable([9,8,72], n3(:,3020), t3x72(:,:,1664))
  call heltable([12,6,72], n3(:,3021), t3x72(:,:,1665))
  call heltable([12,6,72], n3(:,3022), t3x72(:,:,1666))
  call heltable([12,6,72], n3(:,3023), t3x72(:,:,1667))
  call heltable([12,6,72], n3(:,3024), t3x72(:,:,1668))
  call heltable([4,18,72], n3(:,3025), t3x72(:,:,1669))
  call heltable([4,18,72], n3(:,3026), t3x72(:,:,1670))
  call heltable([12,6,72], n3(:,3027), t3x72(:,:,1671))
  call heltable([12,6,72], n3(:,3028), t3x72(:,:,1672))
  call heltable([18,4,72], n3(:,3029), t3x72(:,:,1673))
  call heltable([18,4,72], n3(:,3030), t3x72(:,:,1674))
  call heltable([12,6,72], n3(:,3031), t3x72(:,:,1675))
  call heltable([12,6,72], n3(:,3032), t3x72(:,:,1676))
  call heltable([4,18,72], n3(:,3033), t3x72(:,:,1677))
  call heltable([4,18,72], n3(:,3034), t3x72(:,:,1678))
  call heltable([9,8,72], n3(:,3035), t3x72(:,:,1679))
  call heltable([9,8,72], n3(:,3036), t3x72(:,:,1680))
  call heltable([9,8,72], n3(:,3037), t3x72(:,:,1681))
  call heltable([9,8,72], n3(:,3038), t3x72(:,:,1682))
  call heltable([12,6,72], n3(:,3039), t3x72(:,:,1683))
  call heltable([12,6,72], n3(:,3040), t3x72(:,:,1684))
  call heltable([4,18,72], n3(:,3041), t3x72(:,:,1685))
  call heltable([4,18,72], n3(:,3042), t3x72(:,:,1686))
  call heltable([4,18,72], n3(:,3043), t3x72(:,:,1687))
  call heltable([4,18,72], n3(:,3044), t3x72(:,:,1688))
  call heltable([12,6,72], n3(:,3045), t3x72(:,:,1689))
  call heltable([12,6,72], n3(:,3046), t3x72(:,:,1690))
  call heltable([12,6,72], n3(:,3047), t3x72(:,:,1691))
  call heltable([12,6,72], n3(:,3048), t3x72(:,:,1692))
  call heltable([12,6,72], n3(:,3049), t3x72(:,:,1693))
  call heltable([12,6,72], n3(:,3050), t3x72(:,:,1694))
  call heltable([9,8,72], n3(:,3051), t3x72(:,:,1695))
  call heltable([9,8,72], n3(:,3052), t3x72(:,:,1696))
  call heltable([9,8,72], n3(:,3053), t3x72(:,:,1697))
  call heltable([9,8,72], n3(:,3054), t3x72(:,:,1698))
  call heltable([12,6,72], n3(:,3055), t3x72(:,:,1699))
  call heltable([12,6,72], n3(:,3056), t3x72(:,:,1700))
  call heltable([4,18,72], n3(:,3057), t3x72(:,:,1701))
  call heltable([4,18,72], n3(:,3058), t3x72(:,:,1702))
  call heltable([4,18,72], n3(:,3059), t3x72(:,:,1703))
  call heltable([4,18,72], n3(:,3060), t3x72(:,:,1704))
  call heltable([12,6,72], n3(:,3061), t3x72(:,:,1705))
  call heltable([12,6,72], n3(:,3062), t3x72(:,:,1706))
  call heltable([4,18,72], n3(:,3063), t3x72(:,:,1707))
  call heltable([4,18,72], n3(:,3064), t3x72(:,:,1708))
  call heltable([18,4,72], n3(:,3065), t3x72(:,:,1709))
  call heltable([18,4,72], n3(:,3066), t3x72(:,:,1710))
  call heltable([12,6,72], n3(:,3067), t3x72(:,:,1711))
  call heltable([12,6,72], n3(:,3068), t3x72(:,:,1712))
  call heltable([4,18,72], n3(:,3069), t3x72(:,:,1713))
  call heltable([4,18,72], n3(:,3070), t3x72(:,:,1714))
  call heltable([4,18,72], n3(:,3071), t3x72(:,:,1715))
  call heltable([4,18,72], n3(:,3072), t3x72(:,:,1716))
  call heltable([12,6,72], n3(:,3073), t3x72(:,:,1717))
  call heltable([12,6,72], n3(:,3074), t3x72(:,:,1718))
  call heltable([12,6,72], n3(:,3075), t3x72(:,:,1719))
  call heltable([12,6,72], n3(:,3076), t3x72(:,:,1720))
  call heltable([4,18,72], n3(:,3077), t3x72(:,:,1721))
  call heltable([4,18,72], n3(:,3078), t3x72(:,:,1722))
  call heltable([4,18,72], n3(:,3079), t3x72(:,:,1723))
  call heltable([4,18,72], n3(:,3080), t3x72(:,:,1724))
  call heltable([12,6,72], n3(:,3081), t3x72(:,:,1725))
  call heltable([12,6,72], n3(:,3082), t3x72(:,:,1726))
  call heltable([4,18,72], n3(:,3083), t3x72(:,:,1727))
  call heltable([4,18,72], n3(:,3084), t3x72(:,:,1728))
  call heltable([4,18,72], n3(:,3085), t3x72(:,:,1729))
  call heltable([4,18,72], n3(:,3086), t3x72(:,:,1730))
  call heltable([12,6,72], n3(:,3087), t3x72(:,:,1731))
  call heltable([12,6,72], n3(:,3088), t3x72(:,:,1732))
  call heltable([4,18,72], n3(:,3089), t3x72(:,:,1733))
  call heltable([4,18,72], n3(:,3090), t3x72(:,:,1734))
  call heltable([12,6,72], n3(:,3091), t3x72(:,:,1735))
  call heltable([12,6,72], n3(:,3092), t3x72(:,:,1736))
  call heltable([4,18,72], n3(:,3093), t3x72(:,:,1737))
  call heltable([4,18,72], n3(:,3094), t3x72(:,:,1738))
  call heltable([8,9,72], n3(:,3095), t3x72(:,:,1739))
  call heltable([8,9,72], n3(:,3096), t3x72(:,:,1740))
  call heltable([8,9,72], n3(:,3097), t3x72(:,:,1741))
  call heltable([8,9,72], n3(:,3098), t3x72(:,:,1742))
  call heltable([12,6,72], n3(:,3099), t3x72(:,:,1743))
  call heltable([12,6,72], n3(:,3100), t3x72(:,:,1744))
  call heltable([4,18,72], n3(:,3101), t3x72(:,:,1745))
  call heltable([4,18,72], n3(:,3102), t3x72(:,:,1746))
  call heltable([4,18,72], n3(:,3103), t3x72(:,:,1747))
  call heltable([4,18,72], n3(:,3104), t3x72(:,:,1748))
  call heltable([12,6,72], n3(:,3105), t3x72(:,:,1749))
  call heltable([12,6,72], n3(:,3106), t3x72(:,:,1750))
  call heltable([12,6,72], n3(:,3107), t3x72(:,:,1751))
  call heltable([12,6,72], n3(:,3108), t3x72(:,:,1752))
  call heltable([12,6,72], n3(:,3109), t3x72(:,:,1753))
  call heltable([12,6,72], n3(:,3110), t3x72(:,:,1754))
  call heltable([8,9,72], n3(:,3111), t3x72(:,:,1755))
  call heltable([8,9,72], n3(:,3112), t3x72(:,:,1756))
  call heltable([8,9,72], n3(:,3113), t3x72(:,:,1757))
  call heltable([8,9,72], n3(:,3114), t3x72(:,:,1758))
  call heltable([12,6,72], n3(:,3115), t3x72(:,:,1759))
  call heltable([12,6,72], n3(:,3116), t3x72(:,:,1760))
  call heltable([4,18,72], n3(:,3117), t3x72(:,:,1761))
  call heltable([4,18,72], n3(:,3118), t3x72(:,:,1762))
  call heltable([4,18,72], n3(:,3119), t3x72(:,:,1763))
  call heltable([4,18,72], n3(:,3120), t3x72(:,:,1764))
  call heltable([12,6,72], n3(:,3121), t3x72(:,:,1765))
  call heltable([12,6,72], n3(:,3122), t3x72(:,:,1766))
  call heltable([4,18,72], n3(:,3123), t3x72(:,:,1767))
  call heltable([4,18,72], n3(:,3124), t3x72(:,:,1768))
  call heltable([4,18,72], n3(:,3125), t3x72(:,:,1769))
  call heltable([4,18,72], n3(:,3126), t3x72(:,:,1770))
  call heltable([12,6,72], n3(:,3127), t3x72(:,:,1771))
  call heltable([12,6,72], n3(:,3128), t3x72(:,:,1772))
  call heltable([4,18,72], n3(:,3129), t3x72(:,:,1773))
  call heltable([4,18,72], n3(:,3130), t3x72(:,:,1774))
  call heltable([4,18,72], n3(:,3131), t3x72(:,:,1775))
  call heltable([4,18,72], n3(:,3132), t3x72(:,:,1776))
  call heltable([12,6,72], n3(:,3133), t3x72(:,:,1777))
  call heltable([12,6,72], n3(:,3134), t3x72(:,:,1778))
  call heltable([12,6,72], n3(:,3135), t3x72(:,:,1779))
  call heltable([12,6,72], n3(:,3136), t3x72(:,:,1780))
  call heltable([4,18,72], n3(:,3137), t3x72(:,:,1781))
  call heltable([4,18,72], n3(:,3138), t3x72(:,:,1782))
  call heltable([4,18,72], n3(:,3139), t3x72(:,:,1783))
  call heltable([4,18,72], n3(:,3140), t3x72(:,:,1784))
  call heltable([12,6,72], n3(:,3141), t3x72(:,:,1785))
  call heltable([12,6,72], n3(:,3142), t3x72(:,:,1786))
  call heltable([4,18,72], n3(:,3143), t3x72(:,:,1787))
  call heltable([4,18,72], n3(:,3144), t3x72(:,:,1788))
  call heltable([12,6,72], n3(:,3145), t3x72(:,:,1789))
  call heltable([12,6,72], n3(:,3146), t3x72(:,:,1790))
  call heltable([8,9,72], n3(:,3147), t3x72(:,:,1791))
  call heltable([8,9,72], n3(:,3148), t3x72(:,:,1792))
  call heltable([8,9,72], n3(:,3149), t3x72(:,:,1793))
  call heltable([8,9,72], n3(:,3150), t3x72(:,:,1794))
  call heltable([8,9,72], n3(:,3151), t3x72(:,:,1795))
  call heltable([8,9,72], n3(:,3152), t3x72(:,:,1796))
  call heltable([6,12,72], n3(:,3153), t3x72(:,:,1797))
  call heltable([6,12,72], n3(:,3154), t3x72(:,:,1798))
  call heltable([8,9,72], n3(:,3155), t3x72(:,:,1799))
  call heltable([8,9,72], n3(:,3156), t3x72(:,:,1800))
  call heltable([8,9,72], n3(:,3157), t3x72(:,:,1801))
  call heltable([8,9,72], n3(:,3158), t3x72(:,:,1802))
  call heltable([8,9,72], n3(:,3159), t3x72(:,:,1803))
  call heltable([8,9,72], n3(:,3160), t3x72(:,:,1804))
  call heltable([6,12,72], n3(:,3161), t3x72(:,:,1805))
  call heltable([6,12,72], n3(:,3162), t3x72(:,:,1806))
  call heltable([4,18,72], n3(:,3163), t3x72(:,:,1807))
  call heltable([4,18,72], n3(:,3164), t3x72(:,:,1808))
  call heltable([12,6,72], n3(:,3165), t3x72(:,:,1809))
  call heltable([12,6,72], n3(:,3166), t3x72(:,:,1810))
  call heltable([12,6,72], n3(:,3167), t3x72(:,:,1811))
  call heltable([12,6,72], n3(:,3168), t3x72(:,:,1812))
  call heltable([9,8,72], n3(:,3169), t3x72(:,:,1813))
  call heltable([9,8,72], n3(:,3170), t3x72(:,:,1814))
  call heltable([9,8,72], n3(:,3171), t3x72(:,:,1815))
  call heltable([9,8,72], n3(:,3172), t3x72(:,:,1816))
  call heltable([12,6,72], n3(:,3173), t3x72(:,:,1817))
  call heltable([12,6,72], n3(:,3174), t3x72(:,:,1818))
  call heltable([6,12,72], n3(:,3175), t3x72(:,:,1819))
  call heltable([6,12,72], n3(:,3176), t3x72(:,:,1820))
  call heltable([4,18,72], n3(:,3177), t3x72(:,:,1821))
  call heltable([4,18,72], n3(:,3178), t3x72(:,:,1822))
  call heltable([4,18,72], n3(:,3179), t3x72(:,:,1823))
  call heltable([4,18,72], n3(:,3180), t3x72(:,:,1824))
  call heltable([4,18,72], n3(:,3181), t3x72(:,:,1825))
  call heltable([4,18,72], n3(:,3182), t3x72(:,:,1826))
  call heltable([4,18,72], n3(:,3183), t3x72(:,:,1827))
  call heltable([4,18,72], n3(:,3184), t3x72(:,:,1828))
  call heltable([12,6,72], n3(:,3185), t3x72(:,:,1829))
  call heltable([12,6,72], n3(:,3186), t3x72(:,:,1830))
  call heltable([12,6,72], n3(:,3187), t3x72(:,:,1831))
  call heltable([12,6,72], n3(:,3188), t3x72(:,:,1832))
  call heltable([9,8,72], n3(:,3189), t3x72(:,:,1833))
  call heltable([9,8,72], n3(:,3190), t3x72(:,:,1834))
  call heltable([9,8,72], n3(:,3191), t3x72(:,:,1835))
  call heltable([9,8,72], n3(:,3192), t3x72(:,:,1836))
  call heltable([12,6,72], n3(:,3193), t3x72(:,:,1837))
  call heltable([12,6,72], n3(:,3194), t3x72(:,:,1838))
  call heltable([6,12,72], n3(:,3195), t3x72(:,:,1839))
  call heltable([6,12,72], n3(:,3196), t3x72(:,:,1840))
  call heltable([4,18,72], n3(:,3197), t3x72(:,:,1841))
  call heltable([4,18,72], n3(:,3198), t3x72(:,:,1842))
  call heltable([4,18,72], n3(:,3199), t3x72(:,:,1843))
  call heltable([4,18,72], n3(:,3200), t3x72(:,:,1844))
  call heltable([4,18,72], n3(:,3201), t3x72(:,:,1845))
  call heltable([4,18,72], n3(:,3202), t3x72(:,:,1846))
  call heltable([4,18,72], n3(:,3203), t3x72(:,:,1847))
  call heltable([4,18,72], n3(:,3204), t3x72(:,:,1848))
  call heltable([12,6,72], n3(:,3205), t3x72(:,:,1849))
  call heltable([12,6,72], n3(:,3206), t3x72(:,:,1850))
  call heltable([12,6,72], n3(:,3207), t3x72(:,:,1851))
  call heltable([12,6,72], n3(:,3208), t3x72(:,:,1852))
  call heltable([9,8,72], n3(:,3209), t3x72(:,:,1853))
  call heltable([9,8,72], n3(:,3210), t3x72(:,:,1854))
  call heltable([9,8,72], n3(:,3211), t3x72(:,:,1855))
  call heltable([9,8,72], n3(:,3212), t3x72(:,:,1856))
  call heltable([12,6,72], n3(:,3213), t3x72(:,:,1857))
  call heltable([12,6,72], n3(:,3214), t3x72(:,:,1858))
  call heltable([6,12,72], n3(:,3215), t3x72(:,:,1859))
  call heltable([6,12,72], n3(:,3216), t3x72(:,:,1860))
  call heltable([4,18,72], n3(:,3217), t3x72(:,:,1861))
  call heltable([4,18,72], n3(:,3218), t3x72(:,:,1862))
  call heltable([4,18,72], n3(:,3219), t3x72(:,:,1863))
  call heltable([4,18,72], n3(:,3220), t3x72(:,:,1864))
  call heltable([4,18,72], n3(:,3221), t3x72(:,:,1865))
  call heltable([4,18,72], n3(:,3222), t3x72(:,:,1866))
  call heltable([4,18,72], n3(:,3223), t3x72(:,:,1867))
  call heltable([4,18,72], n3(:,3224), t3x72(:,:,1868))
  call heltable([12,6,72], n3(:,3225), t3x72(:,:,1869))
  call heltable([12,6,72], n3(:,3226), t3x72(:,:,1870))
  call heltable([12,6,72], n3(:,3227), t3x72(:,:,1871))
  call heltable([12,6,72], n3(:,3228), t3x72(:,:,1872))
  call heltable([9,8,72], n3(:,3229), t3x72(:,:,1873))
  call heltable([9,8,72], n3(:,3230), t3x72(:,:,1874))
  call heltable([9,8,72], n3(:,3231), t3x72(:,:,1875))
  call heltable([9,8,72], n3(:,3232), t3x72(:,:,1876))
  call heltable([12,6,72], n3(:,3233), t3x72(:,:,1877))
  call heltable([12,6,72], n3(:,3234), t3x72(:,:,1878))
  call heltable([6,12,72], n3(:,3235), t3x72(:,:,1879))
  call heltable([6,12,72], n3(:,3236), t3x72(:,:,1880))
  call heltable([4,18,72], n3(:,3237), t3x72(:,:,1881))
  call heltable([4,18,72], n3(:,3238), t3x72(:,:,1882))
  call heltable([4,18,72], n3(:,3239), t3x72(:,:,1883))
  call heltable([4,18,72], n3(:,3240), t3x72(:,:,1884))
  call heltable([4,18,72], n3(:,3241), t3x72(:,:,1885))
  call heltable([4,18,72], n3(:,3242), t3x72(:,:,1886))
  call heltable([4,18,72], n3(:,3243), t3x72(:,:,1887))
  call heltable([4,18,72], n3(:,3244), t3x72(:,:,1888))
  call heltable([4,18,72], n3(:,3245), t3x72(:,:,1889))
  call heltable([4,18,72], n3(:,3246), t3x72(:,:,1890))
  call heltable([4,18,72], n3(:,3247), t3x72(:,:,1891))
  call heltable([4,18,72], n3(:,3248), t3x72(:,:,1892))
  call heltable([4,18,72], n3(:,3249), t3x72(:,:,1893))
  call heltable([4,18,72], n3(:,3250), t3x72(:,:,1894))
  call heltable([6,12,72], n3(:,3251), t3x72(:,:,1895))
  call heltable([6,12,72], n3(:,3252), t3x72(:,:,1896))
  call heltable([6,12,72], n3(:,3253), t3x72(:,:,1897))
  call heltable([6,12,72], n3(:,3254), t3x72(:,:,1898))
  call heltable([4,18,72], n3(:,3255), t3x72(:,:,1899))
  call heltable([4,18,72], n3(:,3256), t3x72(:,:,1900))
  call heltable([4,18,72], n3(:,3257), t3x72(:,:,1901))
  call heltable([4,18,72], n3(:,3258), t3x72(:,:,1902))
  call heltable([6,12,72], n3(:,3259), t3x72(:,:,1903))
  call heltable([6,12,72], n3(:,3260), t3x72(:,:,1904))
  call heltable([6,12,72], n3(:,3261), t3x72(:,:,1905))
  call heltable([6,12,72], n3(:,3262), t3x72(:,:,1906))
  call heltable([4,18,72], n3(:,3263), t3x72(:,:,1907))
  call heltable([4,18,72], n3(:,3264), t3x72(:,:,1908))
  call heltable([4,18,72], n3(:,3265), t3x72(:,:,1909))
  call heltable([4,18,72], n3(:,3266), t3x72(:,:,1910))
  call heltable([4,18,72], n3(:,3267), t3x72(:,:,1911))
  call heltable([4,18,72], n3(:,3268), t3x72(:,:,1912))
  call heltable([4,18,72], n3(:,3269), t3x72(:,:,1913))
  call heltable([4,18,72], n3(:,3270), t3x72(:,:,1914))
  call heltable([4,18,72], n3(:,3271), t3x72(:,:,1915))
  call heltable([4,18,72], n3(:,3272), t3x72(:,:,1916))
  call heltable([4,18,72], n3(:,3273), t3x72(:,:,1917))
  call heltable([4,18,72], n3(:,3274), t3x72(:,:,1918))
  call heltable([24,3,72], n3(:,3275), t3x72(:,:,1919))
  call heltable([24,3,72], n3(:,3276), t3x72(:,:,1920))
  call heltable([24,3,72], n3(:,3277), t3x72(:,:,1921))
  call heltable([24,3,72], n3(:,3278), t3x72(:,:,1922))
  call heltable([24,3,72], n3(:,3279), t3x72(:,:,1923))
  call heltable([24,3,72], n3(:,3280), t3x72(:,:,1924))
  call heltable([24,3,72], n3(:,3281), t3x72(:,:,1925))
  call heltable([24,3,72], n3(:,3282), t3x72(:,:,1926))
  call heltable([24,3,72], n3(:,3283), t3x72(:,:,1927))
  call heltable([24,3,72], n3(:,3284), t3x72(:,:,1928))
  call heltable([24,3,72], n3(:,3285), t3x72(:,:,1929))
  call heltable([24,3,72], n3(:,3286), t3x72(:,:,1930))
  call heltable([24,3,72], n3(:,3287), t3x72(:,:,1931))
  call heltable([24,3,72], n3(:,3288), t3x72(:,:,1932))
  call heltable([24,3,72], n3(:,3289), t3x72(:,:,1933))
  call heltable([24,3,72], n3(:,3290), t3x72(:,:,1934))
  call heltable([24,3,72], n3(:,3291), t3x72(:,:,1935))
  call heltable([24,3,72], n3(:,3292), t3x72(:,:,1936))
  call heltable([24,3,72], n3(:,3293), t3x72(:,:,1937))
  call heltable([24,3,72], n3(:,3294), t3x72(:,:,1938))
  call heltable([24,3,72], n3(:,3295), t3x72(:,:,1939))
  call heltable([24,3,72], n3(:,3296), t3x72(:,:,1940))
  call heltable([24,3,72], n3(:,3297), t3x72(:,:,1941))
  call heltable([24,3,72], n3(:,3298), t3x72(:,:,1942))
  call heltable([24,3,72], n3(:,3299), t3x72(:,:,1943))
  call heltable([24,3,72], n3(:,3300), t3x72(:,:,1944))
  call heltable([24,3,72], n3(:,3301), t3x72(:,:,1945))
  call heltable([24,3,72], n3(:,3302), t3x72(:,:,1946))
  call heltable([24,3,72], n3(:,3303), t3x72(:,:,1947))
  call heltable([24,3,72], n3(:,3304), t3x72(:,:,1948))
  call heltable([24,3,72], n3(:,3305), t3x72(:,:,1949))
  call heltable([24,3,72], n3(:,3306), t3x72(:,:,1950))
  call heltable([12,6,72], n3(:,3307), t3x72(:,:,1951))
  call heltable([12,6,72], n3(:,3308), t3x72(:,:,1952))
  call heltable([12,6,72], n3(:,3309), t3x72(:,:,1953))
  call heltable([12,6,72], n3(:,3310), t3x72(:,:,1954))
  call heltable([24,3,72], n3(:,3311), t3x72(:,:,1955))
  call heltable([24,3,72], n3(:,3312), t3x72(:,:,1956))
  call heltable([24,3,72], n3(:,3313), t3x72(:,:,1957))
  call heltable([3,24,72], n3(:,3314), t3x72(:,:,1958))
  call heltable([3,24,72], n3(:,3315), t3x72(:,:,1959))
  call heltable([24,3,72], n3(:,3316), t3x72(:,:,1960))
  call heltable([3,24,72], n3(:,3317), t3x72(:,:,1961))
  call heltable([3,24,72], n3(:,3318), t3x72(:,:,1962))
  call heltable([3,24,72], n3(:,3319), t3x72(:,:,1963))
  call heltable([3,24,72], n3(:,3320), t3x72(:,:,1964))
  call heltable([36,2,72], n3(:,3321), t3x72(:,:,1965))
  call heltable([36,2,72], n3(:,3322), t3x72(:,:,1966))
  call heltable([36,2,72], n3(:,3323), t3x72(:,:,1967))
  call heltable([36,2,72], n3(:,3324), t3x72(:,:,1968))
  call heltable([24,3,72], n3(:,3325), t3x72(:,:,1969))
  call heltable([3,24,72], n3(:,3326), t3x72(:,:,1970))
  call heltable([3,24,72], n3(:,3327), t3x72(:,:,1971))
  call heltable([3,24,72], n3(:,3328), t3x72(:,:,1972))
  call heltable([3,24,72], n3(:,3329), t3x72(:,:,1973))
  call heltable([24,3,72], n3(:,3330), t3x72(:,:,1974))
  call heltable([3,24,72], n3(:,3331), t3x72(:,:,1975))
  call heltable([3,24,72], n3(:,3332), t3x72(:,:,1976))
  call heltable([24,3,72], n3(:,3333), t3x72(:,:,1977))
  call heltable([24,3,72], n3(:,3334), t3x72(:,:,1978))
  call heltable([3,24,72], n3(:,3335), t3x72(:,:,1979))
  call heltable([3,24,72], n3(:,3336), t3x72(:,:,1980))
  call heltable([3,24,72], n3(:,3337), t3x72(:,:,1981))
  call heltable([3,24,72], n3(:,3338), t3x72(:,:,1982))
  call heltable([36,2,72], n3(:,3339), t3x72(:,:,1983))
  call heltable([36,2,72], n3(:,3340), t3x72(:,:,1984))
  call heltable([36,2,72], n3(:,3341), t3x72(:,:,1985))
  call heltable([36,2,72], n3(:,3342), t3x72(:,:,1986))
  call heltable([36,2,72], n3(:,3343), t3x72(:,:,1987))
  call heltable([36,2,72], n3(:,3344), t3x72(:,:,1988))
  call heltable([36,2,72], n3(:,3345), t3x72(:,:,1989))
  call heltable([36,2,72], n3(:,3346), t3x72(:,:,1990))
  call heltable([12,6,72], n3(:,3347), t3x72(:,:,1991))
  call heltable([12,6,72], n3(:,3348), t3x72(:,:,1992))
  call heltable([12,6,72], n3(:,3349), t3x72(:,:,1993))
  call heltable([12,6,72], n3(:,3350), t3x72(:,:,1994))
  call heltable([12,6,72], n3(:,3351), t3x72(:,:,1995))
  call heltable([12,6,72], n3(:,3352), t3x72(:,:,1996))
  call heltable([12,6,72], n3(:,3353), t3x72(:,:,1997))
  call heltable([12,6,72], n3(:,3354), t3x72(:,:,1998))
  call heltable([12,6,72], n3(:,3355), t3x72(:,:,1999))
  call heltable([12,6,72], n3(:,3356), t3x72(:,:,2000))
  call heltable([8,9,72], n3(:,3357), t3x72(:,:,2001))
  call heltable([8,9,72], n3(:,3358), t3x72(:,:,2002))
  call heltable([8,9,72], n3(:,3359), t3x72(:,:,2003))
  call heltable([8,9,72], n3(:,3360), t3x72(:,:,2004))
  call heltable([12,6,72], n3(:,3361), t3x72(:,:,2005))
  call heltable([12,6,72], n3(:,3362), t3x72(:,:,2006))
  call heltable([18,4,72], n3(:,3363), t3x72(:,:,2007))
  call heltable([18,4,72], n3(:,3364), t3x72(:,:,2008))
  call heltable([18,4,72], n3(:,3365), t3x72(:,:,2009))
  call heltable([18,4,72], n3(:,3366), t3x72(:,:,2010))
  call heltable([18,4,72], n3(:,3367), t3x72(:,:,2011))
  call heltable([18,4,72], n3(:,3368), t3x72(:,:,2012))
  call heltable([24,3,72], n3(:,3369), t3x72(:,:,2013))
  call heltable([24,3,72], n3(:,3370), t3x72(:,:,2014))
  call heltable([24,3,72], n3(:,3371), t3x72(:,:,2015))
  call heltable([3,24,72], n3(:,3372), t3x72(:,:,2016))
  call heltable([3,24,72], n3(:,3373), t3x72(:,:,2017))
  call heltable([24,3,72], n3(:,3374), t3x72(:,:,2018))
  call heltable([3,24,72], n3(:,3375), t3x72(:,:,2019))
  call heltable([3,24,72], n3(:,3376), t3x72(:,:,2020))
  call heltable([3,24,72], n3(:,3377), t3x72(:,:,2021))
  call heltable([3,24,72], n3(:,3378), t3x72(:,:,2022))
  call heltable([36,2,72], n3(:,3379), t3x72(:,:,2023))
  call heltable([36,2,72], n3(:,3380), t3x72(:,:,2024))
  call heltable([36,2,72], n3(:,3381), t3x72(:,:,2025))
  call heltable([36,2,72], n3(:,3382), t3x72(:,:,2026))
  call heltable([24,3,72], n3(:,3383), t3x72(:,:,2027))
  call heltable([3,24,72], n3(:,3384), t3x72(:,:,2028))
  call heltable([3,24,72], n3(:,3385), t3x72(:,:,2029))
  call heltable([3,24,72], n3(:,3386), t3x72(:,:,2030))
  call heltable([3,24,72], n3(:,3387), t3x72(:,:,2031))
  call heltable([24,3,72], n3(:,3388), t3x72(:,:,2032))
  call heltable([3,24,72], n3(:,3389), t3x72(:,:,2033))
  call heltable([3,24,72], n3(:,3390), t3x72(:,:,2034))
  call heltable([24,3,72], n3(:,3391), t3x72(:,:,2035))
  call heltable([24,3,72], n3(:,3392), t3x72(:,:,2036))
  call heltable([3,24,72], n3(:,3393), t3x72(:,:,2037))
  call heltable([3,24,72], n3(:,3394), t3x72(:,:,2038))
  call heltable([3,24,72], n3(:,3395), t3x72(:,:,2039))
  call heltable([3,24,72], n3(:,3396), t3x72(:,:,2040))
  call heltable([36,2,72], n3(:,3397), t3x72(:,:,2041))
  call heltable([36,2,72], n3(:,3398), t3x72(:,:,2042))
  call heltable([36,2,72], n3(:,3399), t3x72(:,:,2043))
  call heltable([36,2,72], n3(:,3400), t3x72(:,:,2044))
  call heltable([36,2,72], n3(:,3401), t3x72(:,:,2045))
  call heltable([36,2,72], n3(:,3402), t3x72(:,:,2046))
  call heltable([36,2,72], n3(:,3403), t3x72(:,:,2047))
  call heltable([36,2,72], n3(:,3404), t3x72(:,:,2048))
  call heltable([12,6,72], n3(:,3405), t3x72(:,:,2049))
  call heltable([12,6,72], n3(:,3406), t3x72(:,:,2050))
  call heltable([12,6,72], n3(:,3407), t3x72(:,:,2051))
  call heltable([12,6,72], n3(:,3408), t3x72(:,:,2052))
  call heltable([12,6,72], n3(:,3409), t3x72(:,:,2053))
  call heltable([12,6,72], n3(:,3410), t3x72(:,:,2054))
  call heltable([12,6,72], n3(:,3411), t3x72(:,:,2055))
  call heltable([12,6,72], n3(:,3412), t3x72(:,:,2056))
  call heltable([12,6,72], n3(:,3413), t3x72(:,:,2057))
  call heltable([12,6,72], n3(:,3414), t3x72(:,:,2058))
  call heltable([8,9,72], n3(:,3415), t3x72(:,:,2059))
  call heltable([8,9,72], n3(:,3416), t3x72(:,:,2060))
  call heltable([8,9,72], n3(:,3417), t3x72(:,:,2061))
  call heltable([8,9,72], n3(:,3418), t3x72(:,:,2062))
  call heltable([12,6,72], n3(:,3419), t3x72(:,:,2063))
  call heltable([12,6,72], n3(:,3420), t3x72(:,:,2064))
  call heltable([18,4,72], n3(:,3421), t3x72(:,:,2065))
  call heltable([18,4,72], n3(:,3422), t3x72(:,:,2066))
  call heltable([18,4,72], n3(:,3423), t3x72(:,:,2067))
  call heltable([18,4,72], n3(:,3424), t3x72(:,:,2068))
  call heltable([18,4,72], n3(:,3425), t3x72(:,:,2069))
  call heltable([18,4,72], n3(:,3426), t3x72(:,:,2070))
  call heltable([24,3,72], n3(:,3427), t3x72(:,:,2071))
  call heltable([3,24,72], n3(:,3428), t3x72(:,:,2072))
  call heltable([3,24,72], n3(:,3429), t3x72(:,:,2073))
  call heltable([3,24,72], n3(:,3430), t3x72(:,:,2074))
  call heltable([3,24,72], n3(:,3431), t3x72(:,:,2075))
  call heltable([24,3,72], n3(:,3432), t3x72(:,:,2076))
  call heltable([3,24,72], n3(:,3433), t3x72(:,:,2077))
  call heltable([3,24,72], n3(:,3434), t3x72(:,:,2078))
  call heltable([3,24,72], n3(:,3435), t3x72(:,:,2079))
  call heltable([3,24,72], n3(:,3436), t3x72(:,:,2080))
  call heltable([36,2,72], n3(:,3437), t3x72(:,:,2081))
  call heltable([36,2,72], n3(:,3438), t3x72(:,:,2082))
  call heltable([36,2,72], n3(:,3439), t3x72(:,:,2083))
  call heltable([36,2,72], n3(:,3440), t3x72(:,:,2084))
  call heltable([24,3,72], n3(:,3441), t3x72(:,:,2085))
  call heltable([3,24,72], n3(:,3442), t3x72(:,:,2086))
  call heltable([3,24,72], n3(:,3443), t3x72(:,:,2087))
  call heltable([3,24,72], n3(:,3444), t3x72(:,:,2088))
  call heltable([3,24,72], n3(:,3445), t3x72(:,:,2089))
  call heltable([24,3,72], n3(:,3446), t3x72(:,:,2090))
  call heltable([3,24,72], n3(:,3447), t3x72(:,:,2091))
  call heltable([3,24,72], n3(:,3448), t3x72(:,:,2092))
  call heltable([24,3,72], n3(:,3449), t3x72(:,:,2093))
  call heltable([24,3,72], n3(:,3450), t3x72(:,:,2094))
  call heltable([3,24,72], n3(:,3451), t3x72(:,:,2095))
  call heltable([3,24,72], n3(:,3452), t3x72(:,:,2096))
  call heltable([3,24,72], n3(:,3453), t3x72(:,:,2097))
  call heltable([3,24,72], n3(:,3454), t3x72(:,:,2098))
  call heltable([36,2,72], n3(:,3455), t3x72(:,:,2099))
  call heltable([36,2,72], n3(:,3456), t3x72(:,:,2100))
  call heltable([36,2,72], n3(:,3457), t3x72(:,:,2101))
  call heltable([36,2,72], n3(:,3458), t3x72(:,:,2102))
  call heltable([36,2,72], n3(:,3459), t3x72(:,:,2103))
  call heltable([36,2,72], n3(:,3460), t3x72(:,:,2104))
  call heltable([36,2,72], n3(:,3461), t3x72(:,:,2105))
  call heltable([36,2,72], n3(:,3462), t3x72(:,:,2106))
  call heltable([12,6,72], n3(:,3463), t3x72(:,:,2107))
  call heltable([12,6,72], n3(:,3464), t3x72(:,:,2108))
  call heltable([12,6,72], n3(:,3465), t3x72(:,:,2109))
  call heltable([12,6,72], n3(:,3466), t3x72(:,:,2110))
  call heltable([12,6,72], n3(:,3467), t3x72(:,:,2111))
  call heltable([12,6,72], n3(:,3468), t3x72(:,:,2112))
  call heltable([12,6,72], n3(:,3469), t3x72(:,:,2113))
  call heltable([12,6,72], n3(:,3470), t3x72(:,:,2114))
  call heltable([12,6,72], n3(:,3471), t3x72(:,:,2115))
  call heltable([12,6,72], n3(:,3472), t3x72(:,:,2116))
  call heltable([8,9,72], n3(:,3473), t3x72(:,:,2117))
  call heltable([8,9,72], n3(:,3474), t3x72(:,:,2118))
  call heltable([8,9,72], n3(:,3475), t3x72(:,:,2119))
  call heltable([8,9,72], n3(:,3476), t3x72(:,:,2120))
  call heltable([12,6,72], n3(:,3477), t3x72(:,:,2121))
  call heltable([12,6,72], n3(:,3478), t3x72(:,:,2122))
  call heltable([18,4,72], n3(:,3479), t3x72(:,:,2123))
  call heltable([18,4,72], n3(:,3480), t3x72(:,:,2124))
  call heltable([18,4,72], n3(:,3481), t3x72(:,:,2125))
  call heltable([18,4,72], n3(:,3482), t3x72(:,:,2126))
  call heltable([18,4,72], n3(:,3483), t3x72(:,:,2127))
  call heltable([18,4,72], n3(:,3484), t3x72(:,:,2128))
  call heltable([24,3,72], n3(:,3485), t3x72(:,:,2129))
  call heltable([3,24,72], n3(:,3486), t3x72(:,:,2130))
  call heltable([3,24,72], n3(:,3487), t3x72(:,:,2131))
  call heltable([3,24,72], n3(:,3488), t3x72(:,:,2132))
  call heltable([3,24,72], n3(:,3489), t3x72(:,:,2133))
  call heltable([24,3,72], n3(:,3490), t3x72(:,:,2134))
  call heltable([3,24,72], n3(:,3491), t3x72(:,:,2135))
  call heltable([3,24,72], n3(:,3492), t3x72(:,:,2136))
  call heltable([3,24,72], n3(:,3493), t3x72(:,:,2137))
  call heltable([3,24,72], n3(:,3494), t3x72(:,:,2138))
  call heltable([36,2,72], n3(:,3495), t3x72(:,:,2139))
  call heltable([36,2,72], n3(:,3496), t3x72(:,:,2140))
  call heltable([36,2,72], n3(:,3497), t3x72(:,:,2141))
  call heltable([36,2,72], n3(:,3498), t3x72(:,:,2142))
  call heltable([24,3,72], n3(:,3499), t3x72(:,:,2143))
  call heltable([3,24,72], n3(:,3500), t3x72(:,:,2144))
  call heltable([3,24,72], n3(:,3501), t3x72(:,:,2145))
  call heltable([3,24,72], n3(:,3502), t3x72(:,:,2146))
  call heltable([3,24,72], n3(:,3503), t3x72(:,:,2147))
  call heltable([24,3,72], n3(:,3504), t3x72(:,:,2148))
  call heltable([3,24,72], n3(:,3505), t3x72(:,:,2149))
  call heltable([3,24,72], n3(:,3506), t3x72(:,:,2150))
  call heltable([24,3,72], n3(:,3507), t3x72(:,:,2151))
  call heltable([24,3,72], n3(:,3508), t3x72(:,:,2152))
  call heltable([3,24,72], n3(:,3509), t3x72(:,:,2153))
  call heltable([3,24,72], n3(:,3510), t3x72(:,:,2154))
  call heltable([3,24,72], n3(:,3511), t3x72(:,:,2155))
  call heltable([3,24,72], n3(:,3512), t3x72(:,:,2156))
  call heltable([36,2,72], n3(:,3513), t3x72(:,:,2157))
  call heltable([36,2,72], n3(:,3514), t3x72(:,:,2158))
  call heltable([36,2,72], n3(:,3515), t3x72(:,:,2159))
  call heltable([36,2,72], n3(:,3516), t3x72(:,:,2160))
  call heltable([36,2,72], n3(:,3517), t3x72(:,:,2161))
  call heltable([36,2,72], n3(:,3518), t3x72(:,:,2162))
  call heltable([36,2,72], n3(:,3519), t3x72(:,:,2163))
  call heltable([36,2,72], n3(:,3520), t3x72(:,:,2164))
  call heltable([12,6,72], n3(:,3521), t3x72(:,:,2165))
  call heltable([12,6,72], n3(:,3522), t3x72(:,:,2166))
  call heltable([12,6,72], n3(:,3523), t3x72(:,:,2167))
  call heltable([12,6,72], n3(:,3524), t3x72(:,:,2168))
  call heltable([12,6,72], n3(:,3525), t3x72(:,:,2169))
  call heltable([12,6,72], n3(:,3526), t3x72(:,:,2170))
  call heltable([12,6,72], n3(:,3527), t3x72(:,:,2171))
  call heltable([12,6,72], n3(:,3528), t3x72(:,:,2172))
  call heltable([12,6,72], n3(:,3529), t3x72(:,:,2173))
  call heltable([12,6,72], n3(:,3530), t3x72(:,:,2174))
  call heltable([8,9,72], n3(:,3531), t3x72(:,:,2175))
  call heltable([8,9,72], n3(:,3532), t3x72(:,:,2176))
  call heltable([8,9,72], n3(:,3533), t3x72(:,:,2177))
  call heltable([8,9,72], n3(:,3534), t3x72(:,:,2178))
  call heltable([12,6,72], n3(:,3535), t3x72(:,:,2179))
  call heltable([12,6,72], n3(:,3536), t3x72(:,:,2180))
  call heltable([18,4,72], n3(:,3537), t3x72(:,:,2181))
  call heltable([18,4,72], n3(:,3538), t3x72(:,:,2182))
  call heltable([18,4,72], n3(:,3539), t3x72(:,:,2183))
  call heltable([18,4,72], n3(:,3540), t3x72(:,:,2184))
  call heltable([18,4,72], n3(:,3541), t3x72(:,:,2185))
  call heltable([18,4,72], n3(:,3542), t3x72(:,:,2186))
  call heltable([36,2,72], n3(:,3543), t3x72(:,:,2187))
  call heltable([36,2,72], n3(:,3544), t3x72(:,:,2188))
  call heltable([36,2,72], n3(:,3545), t3x72(:,:,2189))
  call heltable([36,2,72], n3(:,3546), t3x72(:,:,2190))
  call heltable([36,2,72], n3(:,3547), t3x72(:,:,2191))
  call heltable([36,2,72], n3(:,3548), t3x72(:,:,2192))
  call heltable([36,2,72], n3(:,3549), t3x72(:,:,2193))
  call heltable([36,2,72], n3(:,3550), t3x72(:,:,2194))
  call heltable([36,2,72], n3(:,3551), t3x72(:,:,2195))
  call heltable([36,2,72], n3(:,3552), t3x72(:,:,2196))
  call heltable([36,2,72], n3(:,3553), t3x72(:,:,2197))
  call heltable([36,2,72], n3(:,3554), t3x72(:,:,2198))
  call heltable([36,2,72], n3(:,3555), t3x72(:,:,2199))
  call heltable([36,2,72], n3(:,3556), t3x72(:,:,2200))
  call heltable([36,2,72], n3(:,3557), t3x72(:,:,2201))
  call heltable([36,2,72], n3(:,3558), t3x72(:,:,2202))
  call heltable([12,6,72], n3(:,3559), t3x72(:,:,2203))
  call heltable([12,6,72], n3(:,3560), t3x72(:,:,2204))
  call heltable([12,6,72], n3(:,3561), t3x72(:,:,2205))
  call heltable([12,6,72], n3(:,3562), t3x72(:,:,2206))
  call heltable([18,4,72], n3(:,3563), t3x72(:,:,2207))
  call heltable([18,4,72], n3(:,3564), t3x72(:,:,2208))
  call heltable([18,4,72], n3(:,3565), t3x72(:,:,2209))
  call heltable([18,4,72], n3(:,3566), t3x72(:,:,2210))
  call heltable([12,6,72], n3(:,3567), t3x72(:,:,2211))
  call heltable([12,6,72], n3(:,3568), t3x72(:,:,2212))
  call heltable([12,6,72], n3(:,3569), t3x72(:,:,2213))
  call heltable([12,6,72], n3(:,3570), t3x72(:,:,2214))
  call heltable([18,4,72], n3(:,3571), t3x72(:,:,2215))
  call heltable([18,4,72], n3(:,3572), t3x72(:,:,2216))
  call heltable([18,4,72], n3(:,3573), t3x72(:,:,2217))
  call heltable([18,4,72], n3(:,3574), t3x72(:,:,2218))
  call heltable([12,6,72], n3(:,3575), t3x72(:,:,2219))
  call heltable([12,6,72], n3(:,3576), t3x72(:,:,2220))
  call heltable([12,6,72], n3(:,3577), t3x72(:,:,2221))
  call heltable([12,6,72], n3(:,3578), t3x72(:,:,2222))
  call heltable([12,6,72], n3(:,3579), t3x72(:,:,2223))
  call heltable([12,6,72], n3(:,3580), t3x72(:,:,2224))
  call heltable([12,6,72], n3(:,3581), t3x72(:,:,2225))
  call heltable([12,6,72], n3(:,3582), t3x72(:,:,2226))
  call heltable([12,6,72], n3(:,3583), t3x72(:,:,2227))
  call heltable([12,6,72], n3(:,3584), t3x72(:,:,2228))
  call heltable([12,6,72], n3(:,3585), t3x72(:,:,2229))
  call heltable([12,6,72], n3(:,3586), t3x72(:,:,2230))
  call heltable([18,4,72], n3(:,3587), t3x72(:,:,2231))
  call heltable([18,4,72], n3(:,3588), t3x72(:,:,2232))
  call heltable([18,4,72], n3(:,3589), t3x72(:,:,2233))
  call heltable([18,4,72], n3(:,3590), t3x72(:,:,2234))
  call heltable([12,6,72], n3(:,3591), t3x72(:,:,2235))
  call heltable([12,6,72], n3(:,3592), t3x72(:,:,2236))
  call heltable([12,6,72], n3(:,3593), t3x72(:,:,2237))
  call heltable([12,6,72], n3(:,3594), t3x72(:,:,2238))
  call heltable([18,4,72], n3(:,3595), t3x72(:,:,2239))
  call heltable([18,4,72], n3(:,3596), t3x72(:,:,2240))
  call heltable([18,4,72], n3(:,3597), t3x72(:,:,2241))
  call heltable([18,4,72], n3(:,3598), t3x72(:,:,2242))
  call heltable([12,6,72], n3(:,3599), t3x72(:,:,2243))
  call heltable([12,6,72], n3(:,3600), t3x72(:,:,2244))
  call heltable([12,6,72], n3(:,3601), t3x72(:,:,2245))
  call heltable([12,6,72], n3(:,3602), t3x72(:,:,2246))
  call heltable([12,6,72], n3(:,3603), t3x72(:,:,2247))
  call heltable([12,6,72], n3(:,3604), t3x72(:,:,2248))
  call heltable([12,6,72], n3(:,3605), t3x72(:,:,2249))
  call heltable([12,6,72], n3(:,3606), t3x72(:,:,2250))
  call heltable([18,4,72], n3(:,3607), t3x72(:,:,2251))
  call heltable([18,4,72], n3(:,3608), t3x72(:,:,2252))
  call heltable([4,18,72], n3(:,3609), t3x72(:,:,2253))
  call heltable([4,18,72], n3(:,3610), t3x72(:,:,2254))
  call heltable([18,4,72], n3(:,3611), t3x72(:,:,2255))
  call heltable([4,18,72], n3(:,3612), t3x72(:,:,2256))
  call heltable([18,4,72], n3(:,3613), t3x72(:,:,2257))
  call heltable([18,4,72], n3(:,3614), t3x72(:,:,2258))
  call heltable([6,12,72], n3(:,3615), t3x72(:,:,2259))
  call heltable([6,12,72], n3(:,3616), t3x72(:,:,2260))
  call heltable([12,6,72], n3(:,3617), t3x72(:,:,2261))
  call heltable([12,6,72], n3(:,3618), t3x72(:,:,2262))
  call heltable([4,18,72], n3(:,3619), t3x72(:,:,2263))
  call heltable([4,18,72], n3(:,3620), t3x72(:,:,2264))
  call heltable([4,18,72], n3(:,3621), t3x72(:,:,2265))
  call heltable([4,18,72], n3(:,3622), t3x72(:,:,2266))
  call heltable([6,12,72], n3(:,3623), t3x72(:,:,2267))
  call heltable([12,6,72], n3(:,3624), t3x72(:,:,2268))
  call heltable([6,12,72], n3(:,3625), t3x72(:,:,2269))
  call heltable([6,12,72], n3(:,3626), t3x72(:,:,2270))
  call heltable([4,18,72], n3(:,3627), t3x72(:,:,2271))
  call heltable([4,18,72], n3(:,3628), t3x72(:,:,2272))
  call heltable([4,18,72], n3(:,3629), t3x72(:,:,2273))
  call heltable([4,18,72], n3(:,3630), t3x72(:,:,2274))
  call heltable([4,18,72], n3(:,3631), t3x72(:,:,2275))
  call heltable([4,18,72], n3(:,3632), t3x72(:,:,2276))
  call heltable([4,18,72], n3(:,3633), t3x72(:,:,2277))
  call heltable([4,18,72], n3(:,3634), t3x72(:,:,2278))
  call heltable([4,18,72], n3(:,3635), t3x72(:,:,2279))
  call heltable([4,18,72], n3(:,3636), t3x72(:,:,2280))
  call heltable([4,18,72], n3(:,3637), t3x72(:,:,2281))
  call heltable([4,18,72], n3(:,3638), t3x72(:,:,2282))
  call heltable([36,2,72], n3(:,3639), t3x72(:,:,2283))
  call heltable([36,2,72], n3(:,3640), t3x72(:,:,2284))
  call heltable([36,2,72], n3(:,3641), t3x72(:,:,2285))
  call heltable([36,2,72], n3(:,3642), t3x72(:,:,2286))
  call heltable([36,2,72], n3(:,3643), t3x72(:,:,2287))
  call heltable([36,2,72], n3(:,3644), t3x72(:,:,2288))
  call heltable([36,2,72], n3(:,3645), t3x72(:,:,2289))
  call heltable([36,2,72], n3(:,3646), t3x72(:,:,2290))
  call heltable([36,2,72], n3(:,3647), t3x72(:,:,2291))
  call heltable([36,2,72], n3(:,3648), t3x72(:,:,2292))
  call heltable([36,2,72], n3(:,3649), t3x72(:,:,2293))
  call heltable([36,2,72], n3(:,3650), t3x72(:,:,2294))
  call heltable([36,2,72], n3(:,3651), t3x72(:,:,2295))
  call heltable([36,2,72], n3(:,3652), t3x72(:,:,2296))
  call heltable([36,2,72], n3(:,3653), t3x72(:,:,2297))
  call heltable([36,2,72], n3(:,3654), t3x72(:,:,2298))
  call heltable([12,6,72], n3(:,3655), t3x72(:,:,2299))
  call heltable([12,6,72], n3(:,3656), t3x72(:,:,2300))
  call heltable([12,6,72], n3(:,3657), t3x72(:,:,2301))
  call heltable([12,6,72], n3(:,3658), t3x72(:,:,2302))
  call heltable([18,4,72], n3(:,3659), t3x72(:,:,2303))
  call heltable([18,4,72], n3(:,3660), t3x72(:,:,2304))
  call heltable([18,4,72], n3(:,3661), t3x72(:,:,2305))
  call heltable([18,4,72], n3(:,3662), t3x72(:,:,2306))
  call heltable([12,6,72], n3(:,3663), t3x72(:,:,2307))
  call heltable([12,6,72], n3(:,3664), t3x72(:,:,2308))
  call heltable([12,6,72], n3(:,3665), t3x72(:,:,2309))
  call heltable([12,6,72], n3(:,3666), t3x72(:,:,2310))
  call heltable([18,4,72], n3(:,3667), t3x72(:,:,2311))
  call heltable([18,4,72], n3(:,3668), t3x72(:,:,2312))
  call heltable([18,4,72], n3(:,3669), t3x72(:,:,2313))
  call heltable([18,4,72], n3(:,3670), t3x72(:,:,2314))
  call heltable([12,6,72], n3(:,3671), t3x72(:,:,2315))
  call heltable([12,6,72], n3(:,3672), t3x72(:,:,2316))
  call heltable([12,6,72], n3(:,3673), t3x72(:,:,2317))
  call heltable([12,6,72], n3(:,3674), t3x72(:,:,2318))
  call heltable([12,6,72], n3(:,3675), t3x72(:,:,2319))
  call heltable([12,6,72], n3(:,3676), t3x72(:,:,2320))
  call heltable([12,6,72], n3(:,3677), t3x72(:,:,2321))
  call heltable([12,6,72], n3(:,3678), t3x72(:,:,2322))
  call heltable([12,6,72], n3(:,3679), t3x72(:,:,2323))
  call heltable([12,6,72], n3(:,3680), t3x72(:,:,2324))
  call heltable([12,6,72], n3(:,3681), t3x72(:,:,2325))
  call heltable([12,6,72], n3(:,3682), t3x72(:,:,2326))
  call heltable([18,4,72], n3(:,3683), t3x72(:,:,2327))
  call heltable([18,4,72], n3(:,3684), t3x72(:,:,2328))
  call heltable([18,4,72], n3(:,3685), t3x72(:,:,2329))
  call heltable([18,4,72], n3(:,3686), t3x72(:,:,2330))
  call heltable([12,6,72], n3(:,3687), t3x72(:,:,2331))
  call heltable([12,6,72], n3(:,3688), t3x72(:,:,2332))
  call heltable([12,6,72], n3(:,3689), t3x72(:,:,2333))
  call heltable([12,6,72], n3(:,3690), t3x72(:,:,2334))
  call heltable([18,4,72], n3(:,3691), t3x72(:,:,2335))
  call heltable([18,4,72], n3(:,3692), t3x72(:,:,2336))
  call heltable([18,4,72], n3(:,3693), t3x72(:,:,2337))
  call heltable([18,4,72], n3(:,3694), t3x72(:,:,2338))
  call heltable([12,6,72], n3(:,3695), t3x72(:,:,2339))
  call heltable([12,6,72], n3(:,3696), t3x72(:,:,2340))
  call heltable([12,6,72], n3(:,3697), t3x72(:,:,2341))
  call heltable([12,6,72], n3(:,3698), t3x72(:,:,2342))
  call heltable([12,6,72], n3(:,3699), t3x72(:,:,2343))
  call heltable([12,6,72], n3(:,3700), t3x72(:,:,2344))
  call heltable([12,6,72], n3(:,3701), t3x72(:,:,2345))
  call heltable([12,6,72], n3(:,3702), t3x72(:,:,2346))
  call heltable([6,12,72], n3(:,3703), t3x72(:,:,2347))
  call heltable([6,12,72], n3(:,3704), t3x72(:,:,2348))
  call heltable([9,8,72], n3(:,3705), t3x72(:,:,2349))
  call heltable([9,8,72], n3(:,3706), t3x72(:,:,2350))
  call heltable([9,8,72], n3(:,3707), t3x72(:,:,2351))
  call heltable([9,8,72], n3(:,3708), t3x72(:,:,2352))
  call heltable([9,8,72], n3(:,3709), t3x72(:,:,2353))
  call heltable([9,8,72], n3(:,3710), t3x72(:,:,2354))
  call heltable([6,12,72], n3(:,3711), t3x72(:,:,2355))
  call heltable([6,12,72], n3(:,3712), t3x72(:,:,2356))
  call heltable([9,8,72], n3(:,3713), t3x72(:,:,2357))
  call heltable([9,8,72], n3(:,3714), t3x72(:,:,2358))
  call heltable([9,8,72], n3(:,3715), t3x72(:,:,2359))
  call heltable([9,8,72], n3(:,3716), t3x72(:,:,2360))
  call heltable([9,8,72], n3(:,3717), t3x72(:,:,2361))
  call heltable([9,8,72], n3(:,3718), t3x72(:,:,2362))
  call heltable([6,12,72], n3(:,3719), t3x72(:,:,2363))
  call heltable([6,12,72], n3(:,3720), t3x72(:,:,2364))
  call heltable([12,6,72], n3(:,3721), t3x72(:,:,2365))
  call heltable([12,6,72], n3(:,3722), t3x72(:,:,2366))
  call heltable([9,8,72], n3(:,3723), t3x72(:,:,2367))
  call heltable([9,8,72], n3(:,3724), t3x72(:,:,2368))
  call heltable([9,8,72], n3(:,3725), t3x72(:,:,2369))
  call heltable([9,8,72], n3(:,3726), t3x72(:,:,2370))
  call heltable([9,8,72], n3(:,3727), t3x72(:,:,2371))
  call heltable([9,8,72], n3(:,3728), t3x72(:,:,2372))
  call heltable([12,6,72], n3(:,3729), t3x72(:,:,2373))
  call heltable([12,6,72], n3(:,3730), t3x72(:,:,2374))
  call heltable([9,8,72], n3(:,3731), t3x72(:,:,2375))
  call heltable([9,8,72], n3(:,3732), t3x72(:,:,2376))
  call heltable([9,8,72], n3(:,3733), t3x72(:,:,2377))
  call heltable([9,8,72], n3(:,3734), t3x72(:,:,2378))
  call heltable([9,8,72], n3(:,3735), t3x72(:,:,2379))
  call heltable([9,8,72], n3(:,3736), t3x72(:,:,2380))
  call heltable([4,18,72], n3(:,3737), t3x72(:,:,2381))
  call heltable([6,12,72], n3(:,3738), t3x72(:,:,2382))
  call heltable([9,8,72], n3(:,3739), t3x72(:,:,2383))
  call heltable([9,8,72], n3(:,3740), t3x72(:,:,2384))
  call heltable([9,8,72], n3(:,3741), t3x72(:,:,2385))
  call heltable([9,8,72], n3(:,3742), t3x72(:,:,2386))
  call heltable([9,8,72], n3(:,3743), t3x72(:,:,2387))
  call heltable([9,8,72], n3(:,3744), t3x72(:,:,2388))
  call heltable([4,18,72], n3(:,3745), t3x72(:,:,2389))
  call heltable([6,12,72], n3(:,3746), t3x72(:,:,2390))
  call heltable([9,8,72], n3(:,3747), t3x72(:,:,2391))
  call heltable([9,8,72], n3(:,3748), t3x72(:,:,2392))
  call heltable([9,8,72], n3(:,3749), t3x72(:,:,2393))
  call heltable([9,8,72], n3(:,3750), t3x72(:,:,2394))
  call heltable([9,8,72], n3(:,3751), t3x72(:,:,2395))
  call heltable([9,8,72], n3(:,3752), t3x72(:,:,2396))
  call heltable([12,6,72], n3(:,3753), t3x72(:,:,2397))
  call heltable([6,12,72], n3(:,3754), t3x72(:,:,2398))
  call heltable([12,6,72], n3(:,3755), t3x72(:,:,2399))
  call heltable([6,12,72], n3(:,3756), t3x72(:,:,2400))
  call heltable([12,6,72], n3(:,3757), t3x72(:,:,2401))
  call heltable([12,6,72], n3(:,3758), t3x72(:,:,2402))
  call heltable([9,8,72], n3(:,3759), t3x72(:,:,2403))
  call heltable([9,8,72], n3(:,3760), t3x72(:,:,2404))
  call heltable([9,8,72], n3(:,3761), t3x72(:,:,2405))
  call heltable([9,8,72], n3(:,3762), t3x72(:,:,2406))
  call heltable([9,8,72], n3(:,3763), t3x72(:,:,2407))
  call heltable([9,8,72], n3(:,3764), t3x72(:,:,2408))
  call heltable([12,6,72], n3(:,3765), t3x72(:,:,2409))
  call heltable([12,6,72], n3(:,3766), t3x72(:,:,2410))
  call heltable([9,8,72], n3(:,3767), t3x72(:,:,2411))
  call heltable([9,8,72], n3(:,3768), t3x72(:,:,2412))
  call heltable([9,8,72], n3(:,3769), t3x72(:,:,2413))
  call heltable([9,8,72], n3(:,3770), t3x72(:,:,2414))
  call heltable([9,8,72], n3(:,3771), t3x72(:,:,2415))
  call heltable([9,8,72], n3(:,3772), t3x72(:,:,2416))
  call heltable([4,18,72], n3(:,3773), t3x72(:,:,2417))
  call heltable([6,12,72], n3(:,3774), t3x72(:,:,2418))
  call heltable([9,8,72], n3(:,3775), t3x72(:,:,2419))
  call heltable([9,8,72], n3(:,3776), t3x72(:,:,2420))
  call heltable([9,8,72], n3(:,3777), t3x72(:,:,2421))
  call heltable([9,8,72], n3(:,3778), t3x72(:,:,2422))
  call heltable([9,8,72], n3(:,3779), t3x72(:,:,2423))
  call heltable([9,8,72], n3(:,3780), t3x72(:,:,2424))
  call heltable([4,18,72], n3(:,3781), t3x72(:,:,2425))
  call heltable([6,12,72], n3(:,3782), t3x72(:,:,2426))
  call heltable([9,8,72], n3(:,3783), t3x72(:,:,2427))
  call heltable([9,8,72], n3(:,3784), t3x72(:,:,2428))
  call heltable([9,8,72], n3(:,3785), t3x72(:,:,2429))
  call heltable([9,8,72], n3(:,3786), t3x72(:,:,2430))
  call heltable([9,8,72], n3(:,3787), t3x72(:,:,2431))
  call heltable([9,8,72], n3(:,3788), t3x72(:,:,2432))
  call heltable([12,6,72], n3(:,3789), t3x72(:,:,2433))
  call heltable([6,12,72], n3(:,3790), t3x72(:,:,2434))
  call heltable([12,6,72], n3(:,3791), t3x72(:,:,2435))
  call heltable([6,12,72], n3(:,3792), t3x72(:,:,2436))
  call heltable([4,18,72], n3(:,3793), t3x72(:,:,2437))
  call heltable([4,18,72], n3(:,3794), t3x72(:,:,2438))
  call heltable([12,6,72], n3(:,3795), t3x72(:,:,2439))
  call heltable([12,6,72], n3(:,3796), t3x72(:,:,2440))
  call heltable([18,4,72], n3(:,3797), t3x72(:,:,2441))
  call heltable([18,4,72], n3(:,3798), t3x72(:,:,2442))
  call heltable([12,6,72], n3(:,3799), t3x72(:,:,2443))
  call heltable([12,6,72], n3(:,3800), t3x72(:,:,2444))
  call heltable([4,18,72], n3(:,3801), t3x72(:,:,2445))
  call heltable([4,18,72], n3(:,3802), t3x72(:,:,2446))
  call heltable([9,8,72], n3(:,3803), t3x72(:,:,2447))
  call heltable([9,8,72], n3(:,3804), t3x72(:,:,2448))
  call heltable([9,8,72], n3(:,3805), t3x72(:,:,2449))
  call heltable([9,8,72], n3(:,3806), t3x72(:,:,2450))
  call heltable([12,6,72], n3(:,3807), t3x72(:,:,2451))
  call heltable([12,6,72], n3(:,3808), t3x72(:,:,2452))
  call heltable([4,18,72], n3(:,3809), t3x72(:,:,2453))
  call heltable([4,18,72], n3(:,3810), t3x72(:,:,2454))
  call heltable([4,18,72], n3(:,3811), t3x72(:,:,2455))
  call heltable([4,18,72], n3(:,3812), t3x72(:,:,2456))
  call heltable([12,6,72], n3(:,3813), t3x72(:,:,2457))
  call heltable([12,6,72], n3(:,3814), t3x72(:,:,2458))
  call heltable([12,6,72], n3(:,3815), t3x72(:,:,2459))
  call heltable([12,6,72], n3(:,3816), t3x72(:,:,2460))
  call heltable([12,6,72], n3(:,3817), t3x72(:,:,2461))
  call heltable([12,6,72], n3(:,3818), t3x72(:,:,2462))
  call heltable([9,8,72], n3(:,3819), t3x72(:,:,2463))
  call heltable([9,8,72], n3(:,3820), t3x72(:,:,2464))
  call heltable([9,8,72], n3(:,3821), t3x72(:,:,2465))
  call heltable([9,8,72], n3(:,3822), t3x72(:,:,2466))
  call heltable([12,6,72], n3(:,3823), t3x72(:,:,2467))
  call heltable([12,6,72], n3(:,3824), t3x72(:,:,2468))
  call heltable([4,18,72], n3(:,3825), t3x72(:,:,2469))
  call heltable([4,18,72], n3(:,3826), t3x72(:,:,2470))
  call heltable([4,18,72], n3(:,3827), t3x72(:,:,2471))
  call heltable([4,18,72], n3(:,3828), t3x72(:,:,2472))
  call heltable([12,6,72], n3(:,3829), t3x72(:,:,2473))
  call heltable([12,6,72], n3(:,3830), t3x72(:,:,2474))
  call heltable([4,18,72], n3(:,3831), t3x72(:,:,2475))
  call heltable([4,18,72], n3(:,3832), t3x72(:,:,2476))
  call heltable([18,4,72], n3(:,3833), t3x72(:,:,2477))
  call heltable([18,4,72], n3(:,3834), t3x72(:,:,2478))
  call heltable([12,6,72], n3(:,3835), t3x72(:,:,2479))
  call heltable([12,6,72], n3(:,3836), t3x72(:,:,2480))
  call heltable([4,18,72], n3(:,3837), t3x72(:,:,2481))
  call heltable([4,18,72], n3(:,3838), t3x72(:,:,2482))
  call heltable([4,18,72], n3(:,3839), t3x72(:,:,2483))
  call heltable([4,18,72], n3(:,3840), t3x72(:,:,2484))
  call heltable([12,6,72], n3(:,3841), t3x72(:,:,2485))
  call heltable([12,6,72], n3(:,3842), t3x72(:,:,2486))
  call heltable([12,6,72], n3(:,3843), t3x72(:,:,2487))
  call heltable([12,6,72], n3(:,3844), t3x72(:,:,2488))
  call heltable([4,18,72], n3(:,3845), t3x72(:,:,2489))
  call heltable([4,18,72], n3(:,3846), t3x72(:,:,2490))
  call heltable([4,18,72], n3(:,3847), t3x72(:,:,2491))
  call heltable([4,18,72], n3(:,3848), t3x72(:,:,2492))
  call heltable([12,6,72], n3(:,3849), t3x72(:,:,2493))
  call heltable([12,6,72], n3(:,3850), t3x72(:,:,2494))
  call heltable([4,18,72], n3(:,3851), t3x72(:,:,2495))
  call heltable([4,18,72], n3(:,3852), t3x72(:,:,2496))
  call heltable([4,18,72], n3(:,3853), t3x72(:,:,2497))
  call heltable([4,18,72], n3(:,3854), t3x72(:,:,2498))
  call heltable([12,6,72], n3(:,3855), t3x72(:,:,2499))
  call heltable([12,6,72], n3(:,3856), t3x72(:,:,2500))
  call heltable([4,18,72], n3(:,3857), t3x72(:,:,2501))
  call heltable([4,18,72], n3(:,3858), t3x72(:,:,2502))
  call heltable([12,6,72], n3(:,3859), t3x72(:,:,2503))
  call heltable([12,6,72], n3(:,3860), t3x72(:,:,2504))
  call heltable([4,18,72], n3(:,3861), t3x72(:,:,2505))
  call heltable([4,18,72], n3(:,3862), t3x72(:,:,2506))
  call heltable([9,8,72], n3(:,3863), t3x72(:,:,2507))
  call heltable([9,8,72], n3(:,3864), t3x72(:,:,2508))
  call heltable([9,8,72], n3(:,3865), t3x72(:,:,2509))
  call heltable([9,8,72], n3(:,3866), t3x72(:,:,2510))
  call heltable([12,6,72], n3(:,3867), t3x72(:,:,2511))
  call heltable([12,6,72], n3(:,3868), t3x72(:,:,2512))
  call heltable([4,18,72], n3(:,3869), t3x72(:,:,2513))
  call heltable([4,18,72], n3(:,3870), t3x72(:,:,2514))
  call heltable([4,18,72], n3(:,3871), t3x72(:,:,2515))
  call heltable([4,18,72], n3(:,3872), t3x72(:,:,2516))
  call heltable([12,6,72], n3(:,3873), t3x72(:,:,2517))
  call heltable([12,6,72], n3(:,3874), t3x72(:,:,2518))
  call heltable([12,6,72], n3(:,3875), t3x72(:,:,2519))
  call heltable([12,6,72], n3(:,3876), t3x72(:,:,2520))
  call heltable([12,6,72], n3(:,3877), t3x72(:,:,2521))
  call heltable([12,6,72], n3(:,3878), t3x72(:,:,2522))
  call heltable([9,8,72], n3(:,3879), t3x72(:,:,2523))
  call heltable([9,8,72], n3(:,3880), t3x72(:,:,2524))
  call heltable([9,8,72], n3(:,3881), t3x72(:,:,2525))
  call heltable([9,8,72], n3(:,3882), t3x72(:,:,2526))
  call heltable([12,6,72], n3(:,3883), t3x72(:,:,2527))
  call heltable([12,6,72], n3(:,3884), t3x72(:,:,2528))
  call heltable([4,18,72], n3(:,3885), t3x72(:,:,2529))
  call heltable([4,18,72], n3(:,3886), t3x72(:,:,2530))
  call heltable([4,18,72], n3(:,3887), t3x72(:,:,2531))
  call heltable([4,18,72], n3(:,3888), t3x72(:,:,2532))
  call heltable([12,6,72], n3(:,3889), t3x72(:,:,2533))
  call heltable([12,6,72], n3(:,3890), t3x72(:,:,2534))
  call heltable([4,18,72], n3(:,3891), t3x72(:,:,2535))
  call heltable([4,18,72], n3(:,3892), t3x72(:,:,2536))
  call heltable([4,18,72], n3(:,3893), t3x72(:,:,2537))
  call heltable([4,18,72], n3(:,3894), t3x72(:,:,2538))
  call heltable([12,6,72], n3(:,3895), t3x72(:,:,2539))
  call heltable([12,6,72], n3(:,3896), t3x72(:,:,2540))
  call heltable([4,18,72], n3(:,3897), t3x72(:,:,2541))
  call heltable([4,18,72], n3(:,3898), t3x72(:,:,2542))
  call heltable([4,18,72], n3(:,3899), t3x72(:,:,2543))
  call heltable([4,18,72], n3(:,3900), t3x72(:,:,2544))
  call heltable([12,6,72], n3(:,3901), t3x72(:,:,2545))
  call heltable([12,6,72], n3(:,3902), t3x72(:,:,2546))
  call heltable([12,6,72], n3(:,3903), t3x72(:,:,2547))
  call heltable([12,6,72], n3(:,3904), t3x72(:,:,2548))
  call heltable([4,18,72], n3(:,3905), t3x72(:,:,2549))
  call heltable([4,18,72], n3(:,3906), t3x72(:,:,2550))
  call heltable([4,18,72], n3(:,3907), t3x72(:,:,2551))
  call heltable([4,18,72], n3(:,3908), t3x72(:,:,2552))
  call heltable([12,6,72], n3(:,3909), t3x72(:,:,2553))
  call heltable([12,6,72], n3(:,3910), t3x72(:,:,2554))
  call heltable([4,18,72], n3(:,3911), t3x72(:,:,2555))
  call heltable([4,18,72], n3(:,3912), t3x72(:,:,2556))
  call heltable([12,6,72], n3(:,3913), t3x72(:,:,2557))
  call heltable([12,6,72], n3(:,3914), t3x72(:,:,2558))
  call heltable([8,9,72], n3(:,3915), t3x72(:,:,2559))
  call heltable([8,9,72], n3(:,3916), t3x72(:,:,2560))
  call heltable([8,9,72], n3(:,3917), t3x72(:,:,2561))
  call heltable([8,9,72], n3(:,3918), t3x72(:,:,2562))
  call heltable([8,9,72], n3(:,3919), t3x72(:,:,2563))
  call heltable([8,9,72], n3(:,3920), t3x72(:,:,2564))
  call heltable([6,12,72], n3(:,3921), t3x72(:,:,2565))
  call heltable([6,12,72], n3(:,3922), t3x72(:,:,2566))
  call heltable([8,9,72], n3(:,3923), t3x72(:,:,2567))
  call heltable([8,9,72], n3(:,3924), t3x72(:,:,2568))
  call heltable([8,9,72], n3(:,3925), t3x72(:,:,2569))
  call heltable([8,9,72], n3(:,3926), t3x72(:,:,2570))
  call heltable([8,9,72], n3(:,3927), t3x72(:,:,2571))
  call heltable([8,9,72], n3(:,3928), t3x72(:,:,2572))
  call heltable([6,12,72], n3(:,3929), t3x72(:,:,2573))
  call heltable([6,12,72], n3(:,3930), t3x72(:,:,2574))
  call heltable([18,4,72], n3(:,3931), t3x72(:,:,2575))
  call heltable([18,4,72], n3(:,3932), t3x72(:,:,2576))
  call heltable([12,6,72], n3(:,3933), t3x72(:,:,2577))
  call heltable([12,6,72], n3(:,3934), t3x72(:,:,2578))
  call heltable([12,6,72], n3(:,3935), t3x72(:,:,2579))
  call heltable([12,6,72], n3(:,3936), t3x72(:,:,2580))
  call heltable([9,8,72], n3(:,3937), t3x72(:,:,2581))
  call heltable([9,8,72], n3(:,3938), t3x72(:,:,2582))
  call heltable([9,8,72], n3(:,3939), t3x72(:,:,2583))
  call heltable([9,8,72], n3(:,3940), t3x72(:,:,2584))
  call heltable([12,6,72], n3(:,3941), t3x72(:,:,2585))
  call heltable([12,6,72], n3(:,3942), t3x72(:,:,2586))
  call heltable([12,6,72], n3(:,3943), t3x72(:,:,2587))
  call heltable([12,6,72], n3(:,3944), t3x72(:,:,2588))
  call heltable([18,4,72], n3(:,3945), t3x72(:,:,2589))
  call heltable([18,4,72], n3(:,3946), t3x72(:,:,2590))
  call heltable([18,4,72], n3(:,3947), t3x72(:,:,2591))
  call heltable([18,4,72], n3(:,3948), t3x72(:,:,2592))
  call heltable([18,4,72], n3(:,3949), t3x72(:,:,2593))
  call heltable([18,4,72], n3(:,3950), t3x72(:,:,2594))
  call heltable([18,4,72], n3(:,3951), t3x72(:,:,2595))
  call heltable([18,4,72], n3(:,3952), t3x72(:,:,2596))
  call heltable([12,6,72], n3(:,3953), t3x72(:,:,2597))
  call heltable([12,6,72], n3(:,3954), t3x72(:,:,2598))
  call heltable([12,6,72], n3(:,3955), t3x72(:,:,2599))
  call heltable([12,6,72], n3(:,3956), t3x72(:,:,2600))
  call heltable([9,8,72], n3(:,3957), t3x72(:,:,2601))
  call heltable([9,8,72], n3(:,3958), t3x72(:,:,2602))
  call heltable([9,8,72], n3(:,3959), t3x72(:,:,2603))
  call heltable([9,8,72], n3(:,3960), t3x72(:,:,2604))
  call heltable([12,6,72], n3(:,3961), t3x72(:,:,2605))
  call heltable([12,6,72], n3(:,3962), t3x72(:,:,2606))
  call heltable([12,6,72], n3(:,3963), t3x72(:,:,2607))
  call heltable([12,6,72], n3(:,3964), t3x72(:,:,2608))
  call heltable([18,4,72], n3(:,3965), t3x72(:,:,2609))
  call heltable([18,4,72], n3(:,3966), t3x72(:,:,2610))
  call heltable([18,4,72], n3(:,3967), t3x72(:,:,2611))
  call heltable([18,4,72], n3(:,3968), t3x72(:,:,2612))
  call heltable([18,4,72], n3(:,3969), t3x72(:,:,2613))
  call heltable([18,4,72], n3(:,3970), t3x72(:,:,2614))
  call heltable([18,4,72], n3(:,3971), t3x72(:,:,2615))
  call heltable([18,4,72], n3(:,3972), t3x72(:,:,2616))
  call heltable([12,6,72], n3(:,3973), t3x72(:,:,2617))
  call heltable([12,6,72], n3(:,3974), t3x72(:,:,2618))
  call heltable([12,6,72], n3(:,3975), t3x72(:,:,2619))
  call heltable([12,6,72], n3(:,3976), t3x72(:,:,2620))
  call heltable([9,8,72], n3(:,3977), t3x72(:,:,2621))
  call heltable([9,8,72], n3(:,3978), t3x72(:,:,2622))
  call heltable([9,8,72], n3(:,3979), t3x72(:,:,2623))
  call heltable([9,8,72], n3(:,3980), t3x72(:,:,2624))
  call heltable([12,6,72], n3(:,3981), t3x72(:,:,2625))
  call heltable([12,6,72], n3(:,3982), t3x72(:,:,2626))
  call heltable([12,6,72], n3(:,3983), t3x72(:,:,2627))
  call heltable([12,6,72], n3(:,3984), t3x72(:,:,2628))
  call heltable([18,4,72], n3(:,3985), t3x72(:,:,2629))
  call heltable([18,4,72], n3(:,3986), t3x72(:,:,2630))
  call heltable([18,4,72], n3(:,3987), t3x72(:,:,2631))
  call heltable([18,4,72], n3(:,3988), t3x72(:,:,2632))
  call heltable([18,4,72], n3(:,3989), t3x72(:,:,2633))
  call heltable([18,4,72], n3(:,3990), t3x72(:,:,2634))
  call heltable([18,4,72], n3(:,3991), t3x72(:,:,2635))
  call heltable([18,4,72], n3(:,3992), t3x72(:,:,2636))
  call heltable([12,6,72], n3(:,3993), t3x72(:,:,2637))
  call heltable([12,6,72], n3(:,3994), t3x72(:,:,2638))
  call heltable([12,6,72], n3(:,3995), t3x72(:,:,2639))
  call heltable([12,6,72], n3(:,3996), t3x72(:,:,2640))
  call heltable([9,8,72], n3(:,3997), t3x72(:,:,2641))
  call heltable([9,8,72], n3(:,3998), t3x72(:,:,2642))
  call heltable([9,8,72], n3(:,3999), t3x72(:,:,2643))
  call heltable([9,8,72], n3(:,4000), t3x72(:,:,2644))
  call heltable([12,6,72], n3(:,4001), t3x72(:,:,2645))
  call heltable([12,6,72], n3(:,4002), t3x72(:,:,2646))
  call heltable([12,6,72], n3(:,4003), t3x72(:,:,2647))
  call heltable([12,6,72], n3(:,4004), t3x72(:,:,2648))
  call heltable([18,4,72], n3(:,4005), t3x72(:,:,2649))
  call heltable([18,4,72], n3(:,4006), t3x72(:,:,2650))
  call heltable([18,4,72], n3(:,4007), t3x72(:,:,2651))
  call heltable([18,4,72], n3(:,4008), t3x72(:,:,2652))
  call heltable([18,4,72], n3(:,4009), t3x72(:,:,2653))
  call heltable([18,4,72], n3(:,4010), t3x72(:,:,2654))
  call heltable([4,18,72], n3(:,4011), t3x72(:,:,2655))
  call heltable([4,18,72], n3(:,4012), t3x72(:,:,2656))
  call heltable([4,18,72], n3(:,4013), t3x72(:,:,2657))
  call heltable([4,18,72], n3(:,4014), t3x72(:,:,2658))
  call heltable([4,18,72], n3(:,4015), t3x72(:,:,2659))
  call heltable([4,18,72], n3(:,4016), t3x72(:,:,2660))
  call heltable([4,18,72], n3(:,4017), t3x72(:,:,2661))
  call heltable([4,18,72], n3(:,4018), t3x72(:,:,2662))
  call heltable([6,12,72], n3(:,4019), t3x72(:,:,2663))
  call heltable([6,12,72], n3(:,4020), t3x72(:,:,2664))
  call heltable([6,12,72], n3(:,4021), t3x72(:,:,2665))
  call heltable([6,12,72], n3(:,4022), t3x72(:,:,2666))
  call heltable([4,18,72], n3(:,4023), t3x72(:,:,2667))
  call heltable([4,18,72], n3(:,4024), t3x72(:,:,2668))
  call heltable([4,18,72], n3(:,4025), t3x72(:,:,2669))
  call heltable([4,18,72], n3(:,4026), t3x72(:,:,2670))
  call heltable([6,12,72], n3(:,4027), t3x72(:,:,2671))
  call heltable([6,12,72], n3(:,4028), t3x72(:,:,2672))
  call heltable([6,12,72], n3(:,4029), t3x72(:,:,2673))
  call heltable([6,12,72], n3(:,4030), t3x72(:,:,2674))
  call heltable([4,18,72], n3(:,4031), t3x72(:,:,2675))
  call heltable([4,18,72], n3(:,4032), t3x72(:,:,2676))
  call heltable([4,18,72], n3(:,4033), t3x72(:,:,2677))
  call heltable([4,18,72], n3(:,4034), t3x72(:,:,2678))
  call heltable([4,18,72], n3(:,4035), t3x72(:,:,2679))
  call heltable([4,18,72], n3(:,4036), t3x72(:,:,2680))
  call heltable([4,18,72], n3(:,4037), t3x72(:,:,2681))
  call heltable([4,18,72], n3(:,4038), t3x72(:,:,2682))
  call heltable([4,18,72], n3(:,4039), t3x72(:,:,2683))
  call heltable([4,18,72], n3(:,4040), t3x72(:,:,2684))
  call heltable([4,18,72], n3(:,4041), t3x72(:,:,2685))
  call heltable([4,18,72], n3(:,4042), t3x72(:,:,2686))
  call heltable([24,3,72], n3(:,4043), t3x72(:,:,2687))
  call heltable([24,3,72], n3(:,4044), t3x72(:,:,2688))
  call heltable([24,3,72], n3(:,4045), t3x72(:,:,2689))
  call heltable([24,3,72], n3(:,4046), t3x72(:,:,2690))
  call heltable([24,3,72], n3(:,4047), t3x72(:,:,2691))
  call heltable([24,3,72], n3(:,4048), t3x72(:,:,2692))
  call heltable([24,3,72], n3(:,4049), t3x72(:,:,2693))
  call heltable([24,3,72], n3(:,4050), t3x72(:,:,2694))
  call heltable([24,3,72], n3(:,4051), t3x72(:,:,2695))
  call heltable([24,3,72], n3(:,4052), t3x72(:,:,2696))
  call heltable([24,3,72], n3(:,4053), t3x72(:,:,2697))
  call heltable([24,3,72], n3(:,4054), t3x72(:,:,2698))
  call heltable([24,3,72], n3(:,4055), t3x72(:,:,2699))
  call heltable([24,3,72], n3(:,4056), t3x72(:,:,2700))
  call heltable([24,3,72], n3(:,4057), t3x72(:,:,2701))
  call heltable([24,3,72], n3(:,4058), t3x72(:,:,2702))
  call heltable([24,3,72], n3(:,4059), t3x72(:,:,2703))
  call heltable([24,3,72], n3(:,4060), t3x72(:,:,2704))
  call heltable([24,3,72], n3(:,4061), t3x72(:,:,2705))
  call heltable([24,3,72], n3(:,4062), t3x72(:,:,2706))
  call heltable([24,3,72], n3(:,4063), t3x72(:,:,2707))
  call heltable([24,3,72], n3(:,4064), t3x72(:,:,2708))
  call heltable([24,3,72], n3(:,4065), t3x72(:,:,2709))
  call heltable([24,3,72], n3(:,4066), t3x72(:,:,2710))
  call heltable([24,3,72], n3(:,4067), t3x72(:,:,2711))
  call heltable([24,3,72], n3(:,4068), t3x72(:,:,2712))
  call heltable([24,3,72], n3(:,4069), t3x72(:,:,2713))
  call heltable([24,3,72], n3(:,4070), t3x72(:,:,2714))
  call heltable([24,3,72], n3(:,4071), t3x72(:,:,2715))
  call heltable([24,3,72], n3(:,4072), t3x72(:,:,2716))
  call heltable([24,3,72], n3(:,4073), t3x72(:,:,2717))
  call heltable([24,3,72], n3(:,4074), t3x72(:,:,2718))
  call heltable([12,6,72], n3(:,4075), t3x72(:,:,2719))
  call heltable([12,6,72], n3(:,4076), t3x72(:,:,2720))
  call heltable([12,6,72], n3(:,4077), t3x72(:,:,2721))
  call heltable([12,6,72], n3(:,4078), t3x72(:,:,2722))
  call heltable([24,3,72], n3(:,4079), t3x72(:,:,2723))
  call heltable([3,24,72], n3(:,4080), t3x72(:,:,2724))
  call heltable([3,24,72], n3(:,4081), t3x72(:,:,2725))
  call heltable([3,24,72], n3(:,4082), t3x72(:,:,2726))
  call heltable([3,24,72], n3(:,4083), t3x72(:,:,2727))
  call heltable([24,3,72], n3(:,4084), t3x72(:,:,2728))
  call heltable([3,24,72], n3(:,4085), t3x72(:,:,2729))
  call heltable([3,24,72], n3(:,4086), t3x72(:,:,2730))
  call heltable([3,24,72], n3(:,4087), t3x72(:,:,2731))
  call heltable([3,24,72], n3(:,4088), t3x72(:,:,2732))
  call heltable([36,2,72], n3(:,4089), t3x72(:,:,2733))
  call heltable([36,2,72], n3(:,4090), t3x72(:,:,2734))
  call heltable([36,2,72], n3(:,4091), t3x72(:,:,2735))
  call heltable([36,2,72], n3(:,4092), t3x72(:,:,2736))
  call heltable([24,3,72], n3(:,4093), t3x72(:,:,2737))
  call heltable([3,24,72], n3(:,4094), t3x72(:,:,2738))
  call heltable([3,24,72], n3(:,4095), t3x72(:,:,2739))
  call heltable([3,24,72], n3(:,4096), t3x72(:,:,2740))
  call heltable([3,24,72], n3(:,4097), t3x72(:,:,2741))
  call heltable([24,3,72], n3(:,4098), t3x72(:,:,2742))
  call heltable([3,24,72], n3(:,4099), t3x72(:,:,2743))
  call heltable([3,24,72], n3(:,4100), t3x72(:,:,2744))
  call heltable([24,3,72], n3(:,4101), t3x72(:,:,2745))
  call heltable([24,3,72], n3(:,4102), t3x72(:,:,2746))
  call heltable([3,24,72], n3(:,4103), t3x72(:,:,2747))
  call heltable([3,24,72], n3(:,4104), t3x72(:,:,2748))
  call heltable([3,24,72], n3(:,4105), t3x72(:,:,2749))
  call heltable([3,24,72], n3(:,4106), t3x72(:,:,2750))
  call heltable([36,2,72], n3(:,4107), t3x72(:,:,2751))
  call heltable([36,2,72], n3(:,4108), t3x72(:,:,2752))
  call heltable([36,2,72], n3(:,4109), t3x72(:,:,2753))
  call heltable([36,2,72], n3(:,4110), t3x72(:,:,2754))
  call heltable([36,2,72], n3(:,4111), t3x72(:,:,2755))
  call heltable([36,2,72], n3(:,4112), t3x72(:,:,2756))
  call heltable([36,2,72], n3(:,4113), t3x72(:,:,2757))
  call heltable([36,2,72], n3(:,4114), t3x72(:,:,2758))
  call heltable([12,6,72], n3(:,4115), t3x72(:,:,2759))
  call heltable([12,6,72], n3(:,4116), t3x72(:,:,2760))
  call heltable([12,6,72], n3(:,4117), t3x72(:,:,2761))
  call heltable([12,6,72], n3(:,4118), t3x72(:,:,2762))
  call heltable([12,6,72], n3(:,4119), t3x72(:,:,2763))
  call heltable([12,6,72], n3(:,4120), t3x72(:,:,2764))
  call heltable([12,6,72], n3(:,4121), t3x72(:,:,2765))
  call heltable([12,6,72], n3(:,4122), t3x72(:,:,2766))
  call heltable([12,6,72], n3(:,4123), t3x72(:,:,2767))
  call heltable([12,6,72], n3(:,4124), t3x72(:,:,2768))
  call heltable([8,9,72], n3(:,4125), t3x72(:,:,2769))
  call heltable([9,8,72], n3(:,4126), t3x72(:,:,2770))
  call heltable([9,8,72], n3(:,4127), t3x72(:,:,2771))
  call heltable([8,9,72], n3(:,4128), t3x72(:,:,2772))
  call heltable([12,6,72], n3(:,4129), t3x72(:,:,2773))
  call heltable([12,6,72], n3(:,4130), t3x72(:,:,2774))
  call heltable([18,4,72], n3(:,4131), t3x72(:,:,2775))
  call heltable([18,4,72], n3(:,4132), t3x72(:,:,2776))
  call heltable([18,4,72], n3(:,4133), t3x72(:,:,2777))
  call heltable([18,4,72], n3(:,4134), t3x72(:,:,2778))
  call heltable([18,4,72], n3(:,4135), t3x72(:,:,2779))
  call heltable([18,4,72], n3(:,4136), t3x72(:,:,2780))
  call heltable([24,3,72], n3(:,4137), t3x72(:,:,2781))
  call heltable([3,24,72], n3(:,4138), t3x72(:,:,2782))
  call heltable([3,24,72], n3(:,4139), t3x72(:,:,2783))
  call heltable([3,24,72], n3(:,4140), t3x72(:,:,2784))
  call heltable([3,24,72], n3(:,4141), t3x72(:,:,2785))
  call heltable([24,3,72], n3(:,4142), t3x72(:,:,2786))
  call heltable([3,24,72], n3(:,4143), t3x72(:,:,2787))
  call heltable([3,24,72], n3(:,4144), t3x72(:,:,2788))
  call heltable([3,24,72], n3(:,4145), t3x72(:,:,2789))
  call heltable([3,24,72], n3(:,4146), t3x72(:,:,2790))
  call heltable([36,2,72], n3(:,4147), t3x72(:,:,2791))
  call heltable([36,2,72], n3(:,4148), t3x72(:,:,2792))
  call heltable([36,2,72], n3(:,4149), t3x72(:,:,2793))
  call heltable([36,2,72], n3(:,4150), t3x72(:,:,2794))
  call heltable([24,3,72], n3(:,4151), t3x72(:,:,2795))
  call heltable([3,24,72], n3(:,4152), t3x72(:,:,2796))
  call heltable([3,24,72], n3(:,4153), t3x72(:,:,2797))
  call heltable([3,24,72], n3(:,4154), t3x72(:,:,2798))
  call heltable([3,24,72], n3(:,4155), t3x72(:,:,2799))
  call heltable([24,3,72], n3(:,4156), t3x72(:,:,2800))
  call heltable([3,24,72], n3(:,4157), t3x72(:,:,2801))
  call heltable([3,24,72], n3(:,4158), t3x72(:,:,2802))
  call heltable([24,3,72], n3(:,4159), t3x72(:,:,2803))
  call heltable([24,3,72], n3(:,4160), t3x72(:,:,2804))
  call heltable([3,24,72], n3(:,4161), t3x72(:,:,2805))
  call heltable([3,24,72], n3(:,4162), t3x72(:,:,2806))
  call heltable([3,24,72], n3(:,4163), t3x72(:,:,2807))
  call heltable([3,24,72], n3(:,4164), t3x72(:,:,2808))
  call heltable([36,2,72], n3(:,4165), t3x72(:,:,2809))
  call heltable([36,2,72], n3(:,4166), t3x72(:,:,2810))
  call heltable([36,2,72], n3(:,4167), t3x72(:,:,2811))
  call heltable([36,2,72], n3(:,4168), t3x72(:,:,2812))
  call heltable([36,2,72], n3(:,4169), t3x72(:,:,2813))
  call heltable([36,2,72], n3(:,4170), t3x72(:,:,2814))
  call heltable([36,2,72], n3(:,4171), t3x72(:,:,2815))
  call heltable([36,2,72], n3(:,4172), t3x72(:,:,2816))
  call heltable([12,6,72], n3(:,4173), t3x72(:,:,2817))
  call heltable([12,6,72], n3(:,4174), t3x72(:,:,2818))
  call heltable([12,6,72], n3(:,4175), t3x72(:,:,2819))
  call heltable([12,6,72], n3(:,4176), t3x72(:,:,2820))
  call heltable([12,6,72], n3(:,4177), t3x72(:,:,2821))
  call heltable([12,6,72], n3(:,4178), t3x72(:,:,2822))
  call heltable([12,6,72], n3(:,4179), t3x72(:,:,2823))
  call heltable([12,6,72], n3(:,4180), t3x72(:,:,2824))
  call heltable([12,6,72], n3(:,4181), t3x72(:,:,2825))
  call heltable([12,6,72], n3(:,4182), t3x72(:,:,2826))
  call heltable([8,9,72], n3(:,4183), t3x72(:,:,2827))
  call heltable([9,8,72], n3(:,4184), t3x72(:,:,2828))
  call heltable([9,8,72], n3(:,4185), t3x72(:,:,2829))
  call heltable([8,9,72], n3(:,4186), t3x72(:,:,2830))
  call heltable([12,6,72], n3(:,4187), t3x72(:,:,2831))
  call heltable([12,6,72], n3(:,4188), t3x72(:,:,2832))
  call heltable([18,4,72], n3(:,4189), t3x72(:,:,2833))
  call heltable([18,4,72], n3(:,4190), t3x72(:,:,2834))
  call heltable([18,4,72], n3(:,4191), t3x72(:,:,2835))
  call heltable([18,4,72], n3(:,4192), t3x72(:,:,2836))
  call heltable([18,4,72], n3(:,4193), t3x72(:,:,2837))
  call heltable([18,4,72], n3(:,4194), t3x72(:,:,2838))
  call heltable([24,3,72], n3(:,4195), t3x72(:,:,2839))
  call heltable([3,24,72], n3(:,4196), t3x72(:,:,2840))
  call heltable([3,24,72], n3(:,4197), t3x72(:,:,2841))
  call heltable([3,24,72], n3(:,4198), t3x72(:,:,2842))
  call heltable([3,24,72], n3(:,4199), t3x72(:,:,2843))
  call heltable([24,3,72], n3(:,4200), t3x72(:,:,2844))
  call heltable([3,24,72], n3(:,4201), t3x72(:,:,2845))
  call heltable([3,24,72], n3(:,4202), t3x72(:,:,2846))
  call heltable([3,24,72], n3(:,4203), t3x72(:,:,2847))
  call heltable([3,24,72], n3(:,4204), t3x72(:,:,2848))
  call heltable([36,2,72], n3(:,4205), t3x72(:,:,2849))
  call heltable([36,2,72], n3(:,4206), t3x72(:,:,2850))
  call heltable([36,2,72], n3(:,4207), t3x72(:,:,2851))
  call heltable([36,2,72], n3(:,4208), t3x72(:,:,2852))
  call heltable([24,3,72], n3(:,4209), t3x72(:,:,2853))
  call heltable([3,24,72], n3(:,4210), t3x72(:,:,2854))
  call heltable([3,24,72], n3(:,4211), t3x72(:,:,2855))
  call heltable([3,24,72], n3(:,4212), t3x72(:,:,2856))
  call heltable([3,24,72], n3(:,4213), t3x72(:,:,2857))
  call heltable([24,3,72], n3(:,4214), t3x72(:,:,2858))
  call heltable([3,24,72], n3(:,4215), t3x72(:,:,2859))
  call heltable([3,24,72], n3(:,4216), t3x72(:,:,2860))
  call heltable([24,3,72], n3(:,4217), t3x72(:,:,2861))
  call heltable([24,3,72], n3(:,4218), t3x72(:,:,2862))
  call heltable([3,24,72], n3(:,4219), t3x72(:,:,2863))
  call heltable([3,24,72], n3(:,4220), t3x72(:,:,2864))
  call heltable([3,24,72], n3(:,4221), t3x72(:,:,2865))
  call heltable([3,24,72], n3(:,4222), t3x72(:,:,2866))
  call heltable([36,2,72], n3(:,4223), t3x72(:,:,2867))
  call heltable([36,2,72], n3(:,4224), t3x72(:,:,2868))
  call heltable([36,2,72], n3(:,4225), t3x72(:,:,2869))
  call heltable([36,2,72], n3(:,4226), t3x72(:,:,2870))
  call heltable([36,2,72], n3(:,4227), t3x72(:,:,2871))
  call heltable([36,2,72], n3(:,4228), t3x72(:,:,2872))
  call heltable([36,2,72], n3(:,4229), t3x72(:,:,2873))
  call heltable([36,2,72], n3(:,4230), t3x72(:,:,2874))
  call heltable([12,6,72], n3(:,4231), t3x72(:,:,2875))
  call heltable([12,6,72], n3(:,4232), t3x72(:,:,2876))
  call heltable([12,6,72], n3(:,4233), t3x72(:,:,2877))
  call heltable([12,6,72], n3(:,4234), t3x72(:,:,2878))
  call heltable([12,6,72], n3(:,4235), t3x72(:,:,2879))
  call heltable([12,6,72], n3(:,4236), t3x72(:,:,2880))
  call heltable([12,6,72], n3(:,4237), t3x72(:,:,2881))
  call heltable([12,6,72], n3(:,4238), t3x72(:,:,2882))
  call heltable([12,6,72], n3(:,4239), t3x72(:,:,2883))
  call heltable([12,6,72], n3(:,4240), t3x72(:,:,2884))
  call heltable([8,9,72], n3(:,4241), t3x72(:,:,2885))
  call heltable([9,8,72], n3(:,4242), t3x72(:,:,2886))
  call heltable([9,8,72], n3(:,4243), t3x72(:,:,2887))
  call heltable([8,9,72], n3(:,4244), t3x72(:,:,2888))
  call heltable([12,6,72], n3(:,4245), t3x72(:,:,2889))
  call heltable([12,6,72], n3(:,4246), t3x72(:,:,2890))
  call heltable([18,4,72], n3(:,4247), t3x72(:,:,2891))
  call heltable([18,4,72], n3(:,4248), t3x72(:,:,2892))
  call heltable([18,4,72], n3(:,4249), t3x72(:,:,2893))
  call heltable([18,4,72], n3(:,4250), t3x72(:,:,2894))
  call heltable([18,4,72], n3(:,4251), t3x72(:,:,2895))
  call heltable([18,4,72], n3(:,4252), t3x72(:,:,2896))
  call heltable([24,3,72], n3(:,4253), t3x72(:,:,2897))
  call heltable([3,24,72], n3(:,4254), t3x72(:,:,2898))
  call heltable([3,24,72], n3(:,4255), t3x72(:,:,2899))
  call heltable([3,24,72], n3(:,4256), t3x72(:,:,2900))
  call heltable([3,24,72], n3(:,4257), t3x72(:,:,2901))
  call heltable([24,3,72], n3(:,4258), t3x72(:,:,2902))
  call heltable([3,24,72], n3(:,4259), t3x72(:,:,2903))
  call heltable([3,24,72], n3(:,4260), t3x72(:,:,2904))
  call heltable([3,24,72], n3(:,4261), t3x72(:,:,2905))
  call heltable([3,24,72], n3(:,4262), t3x72(:,:,2906))
  call heltable([36,2,72], n3(:,4263), t3x72(:,:,2907))
  call heltable([36,2,72], n3(:,4264), t3x72(:,:,2908))
  call heltable([36,2,72], n3(:,4265), t3x72(:,:,2909))
  call heltable([36,2,72], n3(:,4266), t3x72(:,:,2910))
  call heltable([24,3,72], n3(:,4267), t3x72(:,:,2911))
  call heltable([3,24,72], n3(:,4268), t3x72(:,:,2912))
  call heltable([3,24,72], n3(:,4269), t3x72(:,:,2913))
  call heltable([3,24,72], n3(:,4270), t3x72(:,:,2914))
  call heltable([3,24,72], n3(:,4271), t3x72(:,:,2915))
  call heltable([24,3,72], n3(:,4272), t3x72(:,:,2916))
  call heltable([3,24,72], n3(:,4273), t3x72(:,:,2917))
  call heltable([3,24,72], n3(:,4274), t3x72(:,:,2918))
  call heltable([24,3,72], n3(:,4275), t3x72(:,:,2919))
  call heltable([24,3,72], n3(:,4276), t3x72(:,:,2920))
  call heltable([3,24,72], n3(:,4277), t3x72(:,:,2921))
  call heltable([3,24,72], n3(:,4278), t3x72(:,:,2922))
  call heltable([3,24,72], n3(:,4279), t3x72(:,:,2923))
  call heltable([3,24,72], n3(:,4280), t3x72(:,:,2924))
  call heltable([36,2,72], n3(:,4281), t3x72(:,:,2925))
  call heltable([36,2,72], n3(:,4282), t3x72(:,:,2926))
  call heltable([36,2,72], n3(:,4283), t3x72(:,:,2927))
  call heltable([36,2,72], n3(:,4284), t3x72(:,:,2928))
  call heltable([36,2,72], n3(:,4285), t3x72(:,:,2929))
  call heltable([36,2,72], n3(:,4286), t3x72(:,:,2930))
  call heltable([36,2,72], n3(:,4287), t3x72(:,:,2931))
  call heltable([36,2,72], n3(:,4288), t3x72(:,:,2932))
  call heltable([12,6,72], n3(:,4289), t3x72(:,:,2933))
  call heltable([12,6,72], n3(:,4290), t3x72(:,:,2934))
  call heltable([12,6,72], n3(:,4291), t3x72(:,:,2935))
  call heltable([12,6,72], n3(:,4292), t3x72(:,:,2936))
  call heltable([12,6,72], n3(:,4293), t3x72(:,:,2937))
  call heltable([12,6,72], n3(:,4294), t3x72(:,:,2938))
  call heltable([12,6,72], n3(:,4295), t3x72(:,:,2939))
  call heltable([12,6,72], n3(:,4296), t3x72(:,:,2940))
  call heltable([12,6,72], n3(:,4297), t3x72(:,:,2941))
  call heltable([12,6,72], n3(:,4298), t3x72(:,:,2942))
  call heltable([8,9,72], n3(:,4299), t3x72(:,:,2943))
  call heltable([9,8,72], n3(:,4300), t3x72(:,:,2944))
  call heltable([9,8,72], n3(:,4301), t3x72(:,:,2945))
  call heltable([8,9,72], n3(:,4302), t3x72(:,:,2946))
  call heltable([12,6,72], n3(:,4303), t3x72(:,:,2947))
  call heltable([12,6,72], n3(:,4304), t3x72(:,:,2948))
  call heltable([18,4,72], n3(:,4305), t3x72(:,:,2949))
  call heltable([18,4,72], n3(:,4306), t3x72(:,:,2950))
  call heltable([18,4,72], n3(:,4307), t3x72(:,:,2951))
  call heltable([18,4,72], n3(:,4308), t3x72(:,:,2952))
  call heltable([18,4,72], n3(:,4309), t3x72(:,:,2953))
  call heltable([18,4,72], n3(:,4310), t3x72(:,:,2954))
  call heltable([36,2,72], n3(:,4311), t3x72(:,:,2955))
  call heltable([36,2,72], n3(:,4312), t3x72(:,:,2956))
  call heltable([36,2,72], n3(:,4313), t3x72(:,:,2957))
  call heltable([36,2,72], n3(:,4314), t3x72(:,:,2958))
  call heltable([36,2,72], n3(:,4315), t3x72(:,:,2959))
  call heltable([36,2,72], n3(:,4316), t3x72(:,:,2960))
  call heltable([36,2,72], n3(:,4317), t3x72(:,:,2961))
  call heltable([36,2,72], n3(:,4318), t3x72(:,:,2962))
  call heltable([36,2,72], n3(:,4319), t3x72(:,:,2963))
  call heltable([36,2,72], n3(:,4320), t3x72(:,:,2964))
  call heltable([36,2,72], n3(:,4321), t3x72(:,:,2965))
  call heltable([36,2,72], n3(:,4322), t3x72(:,:,2966))
  call heltable([36,2,72], n3(:,4323), t3x72(:,:,2967))
  call heltable([36,2,72], n3(:,4324), t3x72(:,:,2968))
  call heltable([36,2,72], n3(:,4325), t3x72(:,:,2969))
  call heltable([36,2,72], n3(:,4326), t3x72(:,:,2970))
  call heltable([12,6,72], n3(:,4327), t3x72(:,:,2971))
  call heltable([12,6,72], n3(:,4328), t3x72(:,:,2972))
  call heltable([12,6,72], n3(:,4329), t3x72(:,:,2973))
  call heltable([12,6,72], n3(:,4330), t3x72(:,:,2974))
  call heltable([18,4,72], n3(:,4331), t3x72(:,:,2975))
  call heltable([18,4,72], n3(:,4332), t3x72(:,:,2976))
  call heltable([18,4,72], n3(:,4333), t3x72(:,:,2977))
  call heltable([18,4,72], n3(:,4334), t3x72(:,:,2978))
  call heltable([12,6,72], n3(:,4335), t3x72(:,:,2979))
  call heltable([12,6,72], n3(:,4336), t3x72(:,:,2980))
  call heltable([12,6,72], n3(:,4337), t3x72(:,:,2981))
  call heltable([12,6,72], n3(:,4338), t3x72(:,:,2982))
  call heltable([18,4,72], n3(:,4339), t3x72(:,:,2983))
  call heltable([18,4,72], n3(:,4340), t3x72(:,:,2984))
  call heltable([18,4,72], n3(:,4341), t3x72(:,:,2985))
  call heltable([18,4,72], n3(:,4342), t3x72(:,:,2986))
  call heltable([12,6,72], n3(:,4343), t3x72(:,:,2987))
  call heltable([12,6,72], n3(:,4344), t3x72(:,:,2988))
  call heltable([12,6,72], n3(:,4345), t3x72(:,:,2989))
  call heltable([12,6,72], n3(:,4346), t3x72(:,:,2990))
  call heltable([12,6,72], n3(:,4347), t3x72(:,:,2991))
  call heltable([12,6,72], n3(:,4348), t3x72(:,:,2992))
  call heltable([12,6,72], n3(:,4349), t3x72(:,:,2993))
  call heltable([12,6,72], n3(:,4350), t3x72(:,:,2994))
  call heltable([12,6,72], n3(:,4351), t3x72(:,:,2995))
  call heltable([12,6,72], n3(:,4352), t3x72(:,:,2996))
  call heltable([12,6,72], n3(:,4353), t3x72(:,:,2997))
  call heltable([12,6,72], n3(:,4354), t3x72(:,:,2998))
  call heltable([18,4,72], n3(:,4355), t3x72(:,:,2999))
  call heltable([18,4,72], n3(:,4356), t3x72(:,:,3000))
  call heltable([18,4,72], n3(:,4357), t3x72(:,:,3001))
  call heltable([18,4,72], n3(:,4358), t3x72(:,:,3002))
  call heltable([12,6,72], n3(:,4359), t3x72(:,:,3003))
  call heltable([12,6,72], n3(:,4360), t3x72(:,:,3004))
  call heltable([12,6,72], n3(:,4361), t3x72(:,:,3005))
  call heltable([12,6,72], n3(:,4362), t3x72(:,:,3006))
  call heltable([18,4,72], n3(:,4363), t3x72(:,:,3007))
  call heltable([18,4,72], n3(:,4364), t3x72(:,:,3008))
  call heltable([18,4,72], n3(:,4365), t3x72(:,:,3009))
  call heltable([18,4,72], n3(:,4366), t3x72(:,:,3010))
  call heltable([12,6,72], n3(:,4367), t3x72(:,:,3011))
  call heltable([12,6,72], n3(:,4368), t3x72(:,:,3012))
  call heltable([12,6,72], n3(:,4369), t3x72(:,:,3013))
  call heltable([12,6,72], n3(:,4370), t3x72(:,:,3014))
  call heltable([12,6,72], n3(:,4371), t3x72(:,:,3015))
  call heltable([12,6,72], n3(:,4372), t3x72(:,:,3016))
  call heltable([12,6,72], n3(:,4373), t3x72(:,:,3017))
  call heltable([12,6,72], n3(:,4374), t3x72(:,:,3018))
  call heltable([18,4,72], n3(:,4375), t3x72(:,:,3019))
  call heltable([18,4,72], n3(:,4376), t3x72(:,:,3020))
  call heltable([12,6,72], n3(:,4377), t3x72(:,:,3021))
  call heltable([12,6,72], n3(:,4378), t3x72(:,:,3022))
  call heltable([4,18,72], n3(:,4379), t3x72(:,:,3023))
  call heltable([4,18,72], n3(:,4380), t3x72(:,:,3024))
  call heltable([4,18,72], n3(:,4381), t3x72(:,:,3025))
  call heltable([4,18,72], n3(:,4382), t3x72(:,:,3026))
  call heltable([4,18,72], n3(:,4383), t3x72(:,:,3027))
  call heltable([12,6,72], n3(:,4384), t3x72(:,:,3028))
  call heltable([12,6,72], n3(:,4385), t3x72(:,:,3029))
  call heltable([12,6,72], n3(:,4386), t3x72(:,:,3030))
  call heltable([12,6,72], n3(:,4387), t3x72(:,:,3031))
  call heltable([12,6,72], n3(:,4388), t3x72(:,:,3032))
  call heltable([9,8,72], n3(:,4389), t3x72(:,:,3033))
  call heltable([9,8,72], n3(:,4390), t3x72(:,:,3034))
  call heltable([9,8,72], n3(:,4391), t3x72(:,:,3035))
  call heltable([9,8,72], n3(:,4392), t3x72(:,:,3036))
  call heltable([12,6,72], n3(:,4393), t3x72(:,:,3037))
  call heltable([12,6,72], n3(:,4394), t3x72(:,:,3038))
  call heltable([12,6,72], n3(:,4395), t3x72(:,:,3039))
  call heltable([12,6,72], n3(:,4396), t3x72(:,:,3040))
  call heltable([6,12,72], n3(:,4397), t3x72(:,:,3041))
  call heltable([6,12,72], n3(:,4398), t3x72(:,:,3042))
  call heltable([6,12,72], n3(:,4399), t3x72(:,:,3043))
  call heltable([6,12,72], n3(:,4400), t3x72(:,:,3044))
  call heltable([6,12,72], n3(:,4401), t3x72(:,:,3045))
  call heltable([8,9,72], n3(:,4402), t3x72(:,:,3046))
  call heltable([9,8,72], n3(:,4403), t3x72(:,:,3047))
  call heltable([9,8,72], n3(:,4404), t3x72(:,:,3048))
  call heltable([8,9,72], n3(:,4405), t3x72(:,:,3049))
  call heltable([12,6,72], n3(:,4406), t3x72(:,:,3050))
  call heltable([12,6,72], n3(:,4407), t3x72(:,:,3051))
  call heltable([12,6,72], n3(:,4408), t3x72(:,:,3052))
  call heltable([12,6,72], n3(:,4409), t3x72(:,:,3053))
  call heltable([12,6,72], n3(:,4410), t3x72(:,:,3054))
  call heltable([12,6,72], n3(:,4411), t3x72(:,:,3055))
  call heltable([12,6,72], n3(:,4412), t3x72(:,:,3056))
  call heltable([18,4,72], n3(:,4413), t3x72(:,:,3057))
  call heltable([18,4,72], n3(:,4414), t3x72(:,:,3058))
  call heltable([18,4,72], n3(:,4415), t3x72(:,:,3059))
  call heltable([18,4,72], n3(:,4416), t3x72(:,:,3060))
  call heltable([18,4,72], n3(:,4417), t3x72(:,:,3061))
  call heltable([18,4,72], n3(:,4418), t3x72(:,:,3062))
  call heltable([12,6,72], n3(:,4419), t3x72(:,:,3063))
  call heltable([12,6,72], n3(:,4420), t3x72(:,:,3064))
  call heltable([12,6,72], n3(:,4421), t3x72(:,:,3065))
  call heltable([12,6,72], n3(:,4422), t3x72(:,:,3066))
  call heltable([12,6,72], n3(:,4423), t3x72(:,:,3067))
  call heltable([12,6,72], n3(:,4424), t3x72(:,:,3068))
  call heltable([12,6,72], n3(:,4425), t3x72(:,:,3069))
  call heltable([12,6,72], n3(:,4426), t3x72(:,:,3070))
  call heltable([12,6,72], n3(:,4427), t3x72(:,:,3071))
  call heltable([12,6,72], n3(:,4428), t3x72(:,:,3072))
  call heltable([8,9,72], n3(:,4429), t3x72(:,:,3073))
  call heltable([9,8,72], n3(:,4430), t3x72(:,:,3074))
  call heltable([9,8,72], n3(:,4431), t3x72(:,:,3075))
  call heltable([8,9,72], n3(:,4432), t3x72(:,:,3076))
  call heltable([18,4,72], n3(:,4433), t3x72(:,:,3077))
  call heltable([18,4,72], n3(:,4434), t3x72(:,:,3078))
  call heltable([12,6,72], n3(:,4435), t3x72(:,:,3079))
  call heltable([12,6,72], n3(:,4436), t3x72(:,:,3080))
  call heltable([4,18,72], n3(:,4437), t3x72(:,:,3081))
  call heltable([4,18,72], n3(:,4438), t3x72(:,:,3082))
  call heltable([4,18,72], n3(:,4439), t3x72(:,:,3083))
  call heltable([4,18,72], n3(:,4440), t3x72(:,:,3084))
  call heltable([4,18,72], n3(:,4441), t3x72(:,:,3085))
  call heltable([12,6,72], n3(:,4442), t3x72(:,:,3086))
  call heltable([12,6,72], n3(:,4443), t3x72(:,:,3087))
  call heltable([12,6,72], n3(:,4444), t3x72(:,:,3088))
  call heltable([12,6,72], n3(:,4445), t3x72(:,:,3089))
  call heltable([12,6,72], n3(:,4446), t3x72(:,:,3090))
  call heltable([9,8,72], n3(:,4447), t3x72(:,:,3091))
  call heltable([9,8,72], n3(:,4448), t3x72(:,:,3092))
  call heltable([9,8,72], n3(:,4449), t3x72(:,:,3093))
  call heltable([9,8,72], n3(:,4450), t3x72(:,:,3094))
  call heltable([12,6,72], n3(:,4451), t3x72(:,:,3095))
  call heltable([12,6,72], n3(:,4452), t3x72(:,:,3096))
  call heltable([12,6,72], n3(:,4453), t3x72(:,:,3097))
  call heltable([12,6,72], n3(:,4454), t3x72(:,:,3098))
  call heltable([6,12,72], n3(:,4455), t3x72(:,:,3099))
  call heltable([6,12,72], n3(:,4456), t3x72(:,:,3100))
  call heltable([6,12,72], n3(:,4457), t3x72(:,:,3101))
  call heltable([6,12,72], n3(:,4458), t3x72(:,:,3102))
  call heltable([6,12,72], n3(:,4459), t3x72(:,:,3103))
  call heltable([8,9,72], n3(:,4460), t3x72(:,:,3104))
  call heltable([9,8,72], n3(:,4461), t3x72(:,:,3105))
  call heltable([9,8,72], n3(:,4462), t3x72(:,:,3106))
  call heltable([8,9,72], n3(:,4463), t3x72(:,:,3107))
  call heltable([12,6,72], n3(:,4464), t3x72(:,:,3108))
  call heltable([12,6,72], n3(:,4465), t3x72(:,:,3109))
  call heltable([12,6,72], n3(:,4466), t3x72(:,:,3110))
  call heltable([12,6,72], n3(:,4467), t3x72(:,:,3111))
  call heltable([12,6,72], n3(:,4468), t3x72(:,:,3112))
  call heltable([12,6,72], n3(:,4469), t3x72(:,:,3113))
  call heltable([12,6,72], n3(:,4470), t3x72(:,:,3114))
  call heltable([18,4,72], n3(:,4471), t3x72(:,:,3115))
  call heltable([18,4,72], n3(:,4472), t3x72(:,:,3116))
  call heltable([18,4,72], n3(:,4473), t3x72(:,:,3117))
  call heltable([18,4,72], n3(:,4474), t3x72(:,:,3118))
  call heltable([18,4,72], n3(:,4475), t3x72(:,:,3119))
  call heltable([18,4,72], n3(:,4476), t3x72(:,:,3120))
  call heltable([12,6,72], n3(:,4477), t3x72(:,:,3121))
  call heltable([12,6,72], n3(:,4478), t3x72(:,:,3122))
  call heltable([12,6,72], n3(:,4479), t3x72(:,:,3123))
  call heltable([12,6,72], n3(:,4480), t3x72(:,:,3124))
  call heltable([12,6,72], n3(:,4481), t3x72(:,:,3125))
  call heltable([12,6,72], n3(:,4482), t3x72(:,:,3126))
  call heltable([12,6,72], n3(:,4483), t3x72(:,:,3127))
  call heltable([12,6,72], n3(:,4484), t3x72(:,:,3128))
  call heltable([12,6,72], n3(:,4485), t3x72(:,:,3129))
  call heltable([12,6,72], n3(:,4486), t3x72(:,:,3130))
  call heltable([8,9,72], n3(:,4487), t3x72(:,:,3131))
  call heltable([9,8,72], n3(:,4488), t3x72(:,:,3132))
  call heltable([9,8,72], n3(:,4489), t3x72(:,:,3133))
  call heltable([8,9,72], n3(:,4490), t3x72(:,:,3134))
  call heltable([4,18,72], n3(:,4491), t3x72(:,:,3135))
  call heltable([4,18,72], n3(:,4492), t3x72(:,:,3136))
  call heltable([4,18,72], n3(:,4493), t3x72(:,:,3137))
  call heltable([18,4,72], n3(:,4494), t3x72(:,:,3138))
  call heltable([18,4,72], n3(:,4495), t3x72(:,:,3139))
  call heltable([4,18,72], n3(:,4496), t3x72(:,:,3140))
  call heltable([4,18,72], n3(:,4497), t3x72(:,:,3141))
  call heltable([4,18,72], n3(:,4498), t3x72(:,:,3142))
  call heltable([4,18,72], n3(:,4499), t3x72(:,:,3143))
  call heltable([18,4,72], n3(:,4500), t3x72(:,:,3144))
  call heltable([4,18,72], n3(:,4501), t3x72(:,:,3145))
  call heltable([18,4,72], n3(:,4502), t3x72(:,:,3146))
  call heltable([12,6,72], n3(:,4503), t3x72(:,:,3147))
  call heltable([12,6,72], n3(:,4504), t3x72(:,:,3148))
  call heltable([12,6,72], n3(:,4505), t3x72(:,:,3149))
  call heltable([18,4,72], n3(:,4506), t3x72(:,:,3150))
  call heltable([18,4,72], n3(:,4507), t3x72(:,:,3151))
  call heltable([4,18,72], n3(:,4508), t3x72(:,:,3152))
  call heltable([12,6,72], n3(:,4509), t3x72(:,:,3153))
  call heltable([12,6,72], n3(:,4510), t3x72(:,:,3154))
  call heltable([12,6,72], n3(:,4511), t3x72(:,:,3155))
  call heltable([18,4,72], n3(:,4512), t3x72(:,:,3156))
  call heltable([18,4,72], n3(:,4513), t3x72(:,:,3157))
  call heltable([4,18,72], n3(:,4514), t3x72(:,:,3158))
  call heltable([12,6,72], n3(:,4515), t3x72(:,:,3159))
  call heltable([12,6,72], n3(:,4516), t3x72(:,:,3160))
  call heltable([12,6,72], n3(:,4517), t3x72(:,:,3161))
  call heltable([12,6,72], n3(:,4518), t3x72(:,:,3162))
  call heltable([12,6,72], n3(:,4519), t3x72(:,:,3163))
  call heltable([6,12,72], n3(:,4520), t3x72(:,:,3164))
  call heltable([12,6,72], n3(:,4521), t3x72(:,:,3165))
  call heltable([12,6,72], n3(:,4522), t3x72(:,:,3166))
  call heltable([12,6,72], n3(:,4523), t3x72(:,:,3167))
  call heltable([18,4,72], n3(:,4524), t3x72(:,:,3168))
  call heltable([4,18,72], n3(:,4525), t3x72(:,:,3169))
  call heltable([18,4,72], n3(:,4526), t3x72(:,:,3170))
  call heltable([12,6,72], n3(:,4527), t3x72(:,:,3171))
  call heltable([12,6,72], n3(:,4528), t3x72(:,:,3172))
  call heltable([12,6,72], n3(:,4529), t3x72(:,:,3173))
  call heltable([18,4,72], n3(:,4530), t3x72(:,:,3174))
  call heltable([4,18,72], n3(:,4531), t3x72(:,:,3175))
  call heltable([18,4,72], n3(:,4532), t3x72(:,:,3176))
  call heltable([12,6,72], n3(:,4533), t3x72(:,:,3177))
  call heltable([12,6,72], n3(:,4534), t3x72(:,:,3178))
  call heltable([12,6,72], n3(:,4535), t3x72(:,:,3179))
  call heltable([12,6,72], n3(:,4536), t3x72(:,:,3180))
  call heltable([6,12,72], n3(:,4537), t3x72(:,:,3181))
  call heltable([12,6,72], n3(:,4538), t3x72(:,:,3182))
  call heltable([6,12,72], n3(:,4539), t3x72(:,:,3183))
  call heltable([12,6,72], n3(:,4540), t3x72(:,:,3184))
  call heltable([8,9,72], n3(:,4541), t3x72(:,:,3185))
  call heltable([8,9,72], n3(:,4542), t3x72(:,:,3186))
  call heltable([8,9,72], n3(:,4543), t3x72(:,:,3187))
  call heltable([8,9,72], n3(:,4544), t3x72(:,:,3188))
  call heltable([8,9,72], n3(:,4545), t3x72(:,:,3189))
  call heltable([8,9,72], n3(:,4546), t3x72(:,:,3190))
  call heltable([6,12,72], n3(:,4547), t3x72(:,:,3191))
  call heltable([12,6,72], n3(:,4548), t3x72(:,:,3192))
  call heltable([8,9,72], n3(:,4549), t3x72(:,:,3193))
  call heltable([8,9,72], n3(:,4550), t3x72(:,:,3194))
  call heltable([8,9,72], n3(:,4551), t3x72(:,:,3195))
  call heltable([8,9,72], n3(:,4552), t3x72(:,:,3196))
  call heltable([8,9,72], n3(:,4553), t3x72(:,:,3197))
  call heltable([8,9,72], n3(:,4554), t3x72(:,:,3198))
  call heltable([4,18,72], n3(:,4555), t3x72(:,:,3199))
  call heltable([12,6,72], n3(:,4556), t3x72(:,:,3200))
  call heltable([8,9,72], n3(:,4557), t3x72(:,:,3201))
  call heltable([8,9,72], n3(:,4558), t3x72(:,:,3202))
  call heltable([8,9,72], n3(:,4559), t3x72(:,:,3203))
  call heltable([8,9,72], n3(:,4560), t3x72(:,:,3204))
  call heltable([8,9,72], n3(:,4561), t3x72(:,:,3205))
  call heltable([8,9,72], n3(:,4562), t3x72(:,:,3206))
  call heltable([4,18,72], n3(:,4563), t3x72(:,:,3207))
  call heltable([12,6,72], n3(:,4564), t3x72(:,:,3208))
  call heltable([8,9,72], n3(:,4565), t3x72(:,:,3209))
  call heltable([8,9,72], n3(:,4566), t3x72(:,:,3210))
  call heltable([8,9,72], n3(:,4567), t3x72(:,:,3211))
  call heltable([8,9,72], n3(:,4568), t3x72(:,:,3212))
  call heltable([8,9,72], n3(:,4569), t3x72(:,:,3213))
  call heltable([8,9,72], n3(:,4570), t3x72(:,:,3214))
  call heltable([12,6,72], n3(:,4571), t3x72(:,:,3215))
  call heltable([12,6,72], n3(:,4572), t3x72(:,:,3216))
  call heltable([12,6,72], n3(:,4573), t3x72(:,:,3217))
  call heltable([12,6,72], n3(:,4574), t3x72(:,:,3218))
  call heltable([18,4,72], n3(:,4575), t3x72(:,:,3219))
  call heltable([18,4,72], n3(:,4576), t3x72(:,:,3220))
  call heltable([12,6,72], n3(:,4577), t3x72(:,:,3221))
  call heltable([12,6,72], n3(:,4578), t3x72(:,:,3222))
  call heltable([4,18,72], n3(:,4579), t3x72(:,:,3223))
  call heltable([4,18,72], n3(:,4580), t3x72(:,:,3224))
  call heltable([4,18,72], n3(:,4581), t3x72(:,:,3225))
  call heltable([4,18,72], n3(:,4582), t3x72(:,:,3226))
  call heltable([4,18,72], n3(:,4583), t3x72(:,:,3227))
  call heltable([12,6,72], n3(:,4584), t3x72(:,:,3228))
  call heltable([12,6,72], n3(:,4585), t3x72(:,:,3229))
  call heltable([12,6,72], n3(:,4586), t3x72(:,:,3230))
  call heltable([12,6,72], n3(:,4587), t3x72(:,:,3231))
  call heltable([12,6,72], n3(:,4588), t3x72(:,:,3232))
  call heltable([9,8,72], n3(:,4589), t3x72(:,:,3233))
  call heltable([9,8,72], n3(:,4590), t3x72(:,:,3234))
  call heltable([9,8,72], n3(:,4591), t3x72(:,:,3235))
  call heltable([9,8,72], n3(:,4592), t3x72(:,:,3236))
  call heltable([12,6,72], n3(:,4593), t3x72(:,:,3237))
  call heltable([12,6,72], n3(:,4594), t3x72(:,:,3238))
  call heltable([12,6,72], n3(:,4595), t3x72(:,:,3239))
  call heltable([12,6,72], n3(:,4596), t3x72(:,:,3240))
  call heltable([6,12,72], n3(:,4597), t3x72(:,:,3241))
  call heltable([6,12,72], n3(:,4598), t3x72(:,:,3242))
  call heltable([6,12,72], n3(:,4599), t3x72(:,:,3243))
  call heltable([6,12,72], n3(:,4600), t3x72(:,:,3244))
  call heltable([6,12,72], n3(:,4601), t3x72(:,:,3245))
  call heltable([8,9,72], n3(:,4602), t3x72(:,:,3246))
  call heltable([9,8,72], n3(:,4603), t3x72(:,:,3247))
  call heltable([9,8,72], n3(:,4604), t3x72(:,:,3248))
  call heltable([8,9,72], n3(:,4605), t3x72(:,:,3249))
  call heltable([12,6,72], n3(:,4606), t3x72(:,:,3250))
  call heltable([12,6,72], n3(:,4607), t3x72(:,:,3251))
  call heltable([12,6,72], n3(:,4608), t3x72(:,:,3252))
  call heltable([12,6,72], n3(:,4609), t3x72(:,:,3253))
  call heltable([12,6,72], n3(:,4610), t3x72(:,:,3254))
  call heltable([12,6,72], n3(:,4611), t3x72(:,:,3255))
  call heltable([12,6,72], n3(:,4612), t3x72(:,:,3256))
  call heltable([18,4,72], n3(:,4613), t3x72(:,:,3257))
  call heltable([18,4,72], n3(:,4614), t3x72(:,:,3258))
  call heltable([18,4,72], n3(:,4615), t3x72(:,:,3259))
  call heltable([18,4,72], n3(:,4616), t3x72(:,:,3260))
  call heltable([18,4,72], n3(:,4617), t3x72(:,:,3261))
  call heltable([18,4,72], n3(:,4618), t3x72(:,:,3262))
  call heltable([12,6,72], n3(:,4619), t3x72(:,:,3263))
  call heltable([12,6,72], n3(:,4620), t3x72(:,:,3264))
  call heltable([12,6,72], n3(:,4621), t3x72(:,:,3265))
  call heltable([12,6,72], n3(:,4622), t3x72(:,:,3266))
  call heltable([12,6,72], n3(:,4623), t3x72(:,:,3267))
  call heltable([12,6,72], n3(:,4624), t3x72(:,:,3268))
  call heltable([12,6,72], n3(:,4625), t3x72(:,:,3269))
  call heltable([12,6,72], n3(:,4626), t3x72(:,:,3270))
  call heltable([12,6,72], n3(:,4627), t3x72(:,:,3271))
  call heltable([12,6,72], n3(:,4628), t3x72(:,:,3272))
  call heltable([8,9,72], n3(:,4629), t3x72(:,:,3273))
  call heltable([9,8,72], n3(:,4630), t3x72(:,:,3274))
  call heltable([9,8,72], n3(:,4631), t3x72(:,:,3275))
  call heltable([8,9,72], n3(:,4632), t3x72(:,:,3276))
  call heltable([18,4,72], n3(:,4633), t3x72(:,:,3277))
  call heltable([18,4,72], n3(:,4634), t3x72(:,:,3278))
  call heltable([12,6,72], n3(:,4635), t3x72(:,:,3279))
  call heltable([12,6,72], n3(:,4636), t3x72(:,:,3280))
  call heltable([4,18,72], n3(:,4637), t3x72(:,:,3281))
  call heltable([4,18,72], n3(:,4638), t3x72(:,:,3282))
  call heltable([4,18,72], n3(:,4639), t3x72(:,:,3283))
  call heltable([4,18,72], n3(:,4640), t3x72(:,:,3284))
  call heltable([4,18,72], n3(:,4641), t3x72(:,:,3285))
  call heltable([12,6,72], n3(:,4642), t3x72(:,:,3286))
  call heltable([12,6,72], n3(:,4643), t3x72(:,:,3287))
  call heltable([12,6,72], n3(:,4644), t3x72(:,:,3288))
  call heltable([12,6,72], n3(:,4645), t3x72(:,:,3289))
  call heltable([12,6,72], n3(:,4646), t3x72(:,:,3290))
  call heltable([9,8,72], n3(:,4647), t3x72(:,:,3291))
  call heltable([9,8,72], n3(:,4648), t3x72(:,:,3292))
  call heltable([9,8,72], n3(:,4649), t3x72(:,:,3293))
  call heltable([9,8,72], n3(:,4650), t3x72(:,:,3294))
  call heltable([12,6,72], n3(:,4651), t3x72(:,:,3295))
  call heltable([12,6,72], n3(:,4652), t3x72(:,:,3296))
  call heltable([12,6,72], n3(:,4653), t3x72(:,:,3297))
  call heltable([12,6,72], n3(:,4654), t3x72(:,:,3298))
  call heltable([6,12,72], n3(:,4655), t3x72(:,:,3299))
  call heltable([6,12,72], n3(:,4656), t3x72(:,:,3300))
  call heltable([6,12,72], n3(:,4657), t3x72(:,:,3301))
  call heltable([6,12,72], n3(:,4658), t3x72(:,:,3302))
  call heltable([6,12,72], n3(:,4659), t3x72(:,:,3303))
  call heltable([8,9,72], n3(:,4660), t3x72(:,:,3304))
  call heltable([9,8,72], n3(:,4661), t3x72(:,:,3305))
  call heltable([9,8,72], n3(:,4662), t3x72(:,:,3306))
  call heltable([8,9,72], n3(:,4663), t3x72(:,:,3307))
  call heltable([12,6,72], n3(:,4664), t3x72(:,:,3308))
  call heltable([12,6,72], n3(:,4665), t3x72(:,:,3309))
  call heltable([12,6,72], n3(:,4666), t3x72(:,:,3310))
  call heltable([12,6,72], n3(:,4667), t3x72(:,:,3311))
  call heltable([12,6,72], n3(:,4668), t3x72(:,:,3312))
  call heltable([12,6,72], n3(:,4669), t3x72(:,:,3313))
  call heltable([12,6,72], n3(:,4670), t3x72(:,:,3314))
  call heltable([18,4,72], n3(:,4671), t3x72(:,:,3315))
  call heltable([18,4,72], n3(:,4672), t3x72(:,:,3316))
  call heltable([18,4,72], n3(:,4673), t3x72(:,:,3317))
  call heltable([18,4,72], n3(:,4674), t3x72(:,:,3318))
  call heltable([18,4,72], n3(:,4675), t3x72(:,:,3319))
  call heltable([18,4,72], n3(:,4676), t3x72(:,:,3320))
  call heltable([12,6,72], n3(:,4677), t3x72(:,:,3321))
  call heltable([12,6,72], n3(:,4678), t3x72(:,:,3322))
  call heltable([12,6,72], n3(:,4679), t3x72(:,:,3323))
  call heltable([12,6,72], n3(:,4680), t3x72(:,:,3324))
  call heltable([12,6,72], n3(:,4681), t3x72(:,:,3325))
  call heltable([12,6,72], n3(:,4682), t3x72(:,:,3326))
  call heltable([12,6,72], n3(:,4683), t3x72(:,:,3327))
  call heltable([12,6,72], n3(:,4684), t3x72(:,:,3328))
  call heltable([12,6,72], n3(:,4685), t3x72(:,:,3329))
  call heltable([12,6,72], n3(:,4686), t3x72(:,:,3330))
  call heltable([8,9,72], n3(:,4687), t3x72(:,:,3331))
  call heltable([9,8,72], n3(:,4688), t3x72(:,:,3332))
  call heltable([9,8,72], n3(:,4689), t3x72(:,:,3333))
  call heltable([8,9,72], n3(:,4690), t3x72(:,:,3334))
  call heltable([18,4,72], n3(:,4691), t3x72(:,:,3335))
  call heltable([18,4,72], n3(:,4692), t3x72(:,:,3336))
  call heltable([12,6,72], n3(:,4693), t3x72(:,:,3337))
  call heltable([12,6,72], n3(:,4694), t3x72(:,:,3338))
  call heltable([4,18,72], n3(:,4695), t3x72(:,:,3339))
  call heltable([4,18,72], n3(:,4696), t3x72(:,:,3340))
  call heltable([4,18,72], n3(:,4697), t3x72(:,:,3341))
  call heltable([4,18,72], n3(:,4698), t3x72(:,:,3342))
  call heltable([4,18,72], n3(:,4699), t3x72(:,:,3343))
  call heltable([12,6,72], n3(:,4700), t3x72(:,:,3344))
  call heltable([12,6,72], n3(:,4701), t3x72(:,:,3345))
  call heltable([12,6,72], n3(:,4702), t3x72(:,:,3346))
  call heltable([12,6,72], n3(:,4703), t3x72(:,:,3347))
  call heltable([12,6,72], n3(:,4704), t3x72(:,:,3348))
  call heltable([9,8,72], n3(:,4705), t3x72(:,:,3349))
  call heltable([9,8,72], n3(:,4706), t3x72(:,:,3350))
  call heltable([9,8,72], n3(:,4707), t3x72(:,:,3351))
  call heltable([9,8,72], n3(:,4708), t3x72(:,:,3352))
  call heltable([12,6,72], n3(:,4709), t3x72(:,:,3353))
  call heltable([12,6,72], n3(:,4710), t3x72(:,:,3354))
  call heltable([12,6,72], n3(:,4711), t3x72(:,:,3355))
  call heltable([12,6,72], n3(:,4712), t3x72(:,:,3356))
  call heltable([6,12,72], n3(:,4713), t3x72(:,:,3357))
  call heltable([6,12,72], n3(:,4714), t3x72(:,:,3358))
  call heltable([6,12,72], n3(:,4715), t3x72(:,:,3359))
  call heltable([6,12,72], n3(:,4716), t3x72(:,:,3360))
  call heltable([6,12,72], n3(:,4717), t3x72(:,:,3361))
  call heltable([8,9,72], n3(:,4718), t3x72(:,:,3362))
  call heltable([9,8,72], n3(:,4719), t3x72(:,:,3363))
  call heltable([9,8,72], n3(:,4720), t3x72(:,:,3364))
  call heltable([8,9,72], n3(:,4721), t3x72(:,:,3365))
  call heltable([12,6,72], n3(:,4722), t3x72(:,:,3366))
  call heltable([12,6,72], n3(:,4723), t3x72(:,:,3367))
  call heltable([12,6,72], n3(:,4724), t3x72(:,:,3368))
  call heltable([12,6,72], n3(:,4725), t3x72(:,:,3369))
  call heltable([12,6,72], n3(:,4726), t3x72(:,:,3370))
  call heltable([12,6,72], n3(:,4727), t3x72(:,:,3371))
  call heltable([12,6,72], n3(:,4728), t3x72(:,:,3372))
  call heltable([18,4,72], n3(:,4729), t3x72(:,:,3373))
  call heltable([18,4,72], n3(:,4730), t3x72(:,:,3374))
  call heltable([18,4,72], n3(:,4731), t3x72(:,:,3375))
  call heltable([18,4,72], n3(:,4732), t3x72(:,:,3376))
  call heltable([18,4,72], n3(:,4733), t3x72(:,:,3377))
  call heltable([18,4,72], n3(:,4734), t3x72(:,:,3378))
  call heltable([12,6,72], n3(:,4735), t3x72(:,:,3379))
  call heltable([12,6,72], n3(:,4736), t3x72(:,:,3380))
  call heltable([12,6,72], n3(:,4737), t3x72(:,:,3381))
  call heltable([12,6,72], n3(:,4738), t3x72(:,:,3382))
  call heltable([12,6,72], n3(:,4739), t3x72(:,:,3383))
  call heltable([12,6,72], n3(:,4740), t3x72(:,:,3384))
  call heltable([12,6,72], n3(:,4741), t3x72(:,:,3385))
  call heltable([12,6,72], n3(:,4742), t3x72(:,:,3386))
  call heltable([12,6,72], n3(:,4743), t3x72(:,:,3387))
  call heltable([12,6,72], n3(:,4744), t3x72(:,:,3388))
  call heltable([8,9,72], n3(:,4745), t3x72(:,:,3389))
  call heltable([9,8,72], n3(:,4746), t3x72(:,:,3390))
  call heltable([9,8,72], n3(:,4747), t3x72(:,:,3391))
  call heltable([8,9,72], n3(:,4748), t3x72(:,:,3392))
  call heltable([18,4,72], n3(:,4749), t3x72(:,:,3393))
  call heltable([18,4,72], n3(:,4750), t3x72(:,:,3394))
  call heltable([12,6,72], n3(:,4751), t3x72(:,:,3395))
  call heltable([12,6,72], n3(:,4752), t3x72(:,:,3396))
  call heltable([4,18,72], n3(:,4753), t3x72(:,:,3397))
  call heltable([4,18,72], n3(:,4754), t3x72(:,:,3398))
  call heltable([4,18,72], n3(:,4755), t3x72(:,:,3399))
  call heltable([4,18,72], n3(:,4756), t3x72(:,:,3400))
  call heltable([4,18,72], n3(:,4757), t3x72(:,:,3401))
  call heltable([12,6,72], n3(:,4758), t3x72(:,:,3402))
  call heltable([12,6,72], n3(:,4759), t3x72(:,:,3403))
  call heltable([12,6,72], n3(:,4760), t3x72(:,:,3404))
  call heltable([12,6,72], n3(:,4761), t3x72(:,:,3405))
  call heltable([12,6,72], n3(:,4762), t3x72(:,:,3406))
  call heltable([9,8,72], n3(:,4763), t3x72(:,:,3407))
  call heltable([9,8,72], n3(:,4764), t3x72(:,:,3408))
  call heltable([9,8,72], n3(:,4765), t3x72(:,:,3409))
  call heltable([9,8,72], n3(:,4766), t3x72(:,:,3410))
  call heltable([12,6,72], n3(:,4767), t3x72(:,:,3411))
  call heltable([12,6,72], n3(:,4768), t3x72(:,:,3412))
  call heltable([12,6,72], n3(:,4769), t3x72(:,:,3413))
  call heltable([12,6,72], n3(:,4770), t3x72(:,:,3414))
  call heltable([6,12,72], n3(:,4771), t3x72(:,:,3415))
  call heltable([6,12,72], n3(:,4772), t3x72(:,:,3416))
  call heltable([6,12,72], n3(:,4773), t3x72(:,:,3417))
  call heltable([6,12,72], n3(:,4774), t3x72(:,:,3418))
  call heltable([6,12,72], n3(:,4775), t3x72(:,:,3419))
  call heltable([8,9,72], n3(:,4776), t3x72(:,:,3420))
  call heltable([9,8,72], n3(:,4777), t3x72(:,:,3421))
  call heltable([9,8,72], n3(:,4778), t3x72(:,:,3422))
  call heltable([8,9,72], n3(:,4779), t3x72(:,:,3423))
  call heltable([12,6,72], n3(:,4780), t3x72(:,:,3424))
  call heltable([12,6,72], n3(:,4781), t3x72(:,:,3425))
  call heltable([12,6,72], n3(:,4782), t3x72(:,:,3426))
  call heltable([12,6,72], n3(:,4783), t3x72(:,:,3427))
  call heltable([12,6,72], n3(:,4784), t3x72(:,:,3428))
  call heltable([12,6,72], n3(:,4785), t3x72(:,:,3429))
  call heltable([12,6,72], n3(:,4786), t3x72(:,:,3430))
  call heltable([18,4,72], n3(:,4787), t3x72(:,:,3431))
  call heltable([18,4,72], n3(:,4788), t3x72(:,:,3432))
  call heltable([18,4,72], n3(:,4789), t3x72(:,:,3433))
  call heltable([18,4,72], n3(:,4790), t3x72(:,:,3434))
  call heltable([18,4,72], n3(:,4791), t3x72(:,:,3435))
  call heltable([18,4,72], n3(:,4792), t3x72(:,:,3436))
  call heltable([12,6,72], n3(:,4793), t3x72(:,:,3437))
  call heltable([12,6,72], n3(:,4794), t3x72(:,:,3438))
  call heltable([12,6,72], n3(:,4795), t3x72(:,:,3439))
  call heltable([12,6,72], n3(:,4796), t3x72(:,:,3440))
  call heltable([12,6,72], n3(:,4797), t3x72(:,:,3441))
  call heltable([12,6,72], n3(:,4798), t3x72(:,:,3442))
  call heltable([12,6,72], n3(:,4799), t3x72(:,:,3443))
  call heltable([12,6,72], n3(:,4800), t3x72(:,:,3444))
  call heltable([12,6,72], n3(:,4801), t3x72(:,:,3445))
  call heltable([12,6,72], n3(:,4802), t3x72(:,:,3446))
  call heltable([8,9,72], n3(:,4803), t3x72(:,:,3447))
  call heltable([9,8,72], n3(:,4804), t3x72(:,:,3448))
  call heltable([9,8,72], n3(:,4805), t3x72(:,:,3449))
  call heltable([8,9,72], n3(:,4806), t3x72(:,:,3450))
  call heltable([4,18,72], n3(:,4807), t3x72(:,:,3451))
  call heltable([4,18,72], n3(:,4808), t3x72(:,:,3452))
  call heltable([4,18,72], n3(:,4809), t3x72(:,:,3453))
  call heltable([18,4,72], n3(:,4810), t3x72(:,:,3454))
  call heltable([18,4,72], n3(:,4811), t3x72(:,:,3455))
  call heltable([4,18,72], n3(:,4812), t3x72(:,:,3456))
  call heltable([4,18,72], n3(:,4813), t3x72(:,:,3457))
  call heltable([4,18,72], n3(:,4814), t3x72(:,:,3458))
  call heltable([4,18,72], n3(:,4815), t3x72(:,:,3459))
  call heltable([18,4,72], n3(:,4816), t3x72(:,:,3460))
  call heltable([4,18,72], n3(:,4817), t3x72(:,:,3461))
  call heltable([18,4,72], n3(:,4818), t3x72(:,:,3462))
  call heltable([12,6,72], n3(:,4819), t3x72(:,:,3463))
  call heltable([12,6,72], n3(:,4820), t3x72(:,:,3464))
  call heltable([12,6,72], n3(:,4821), t3x72(:,:,3465))
  call heltable([18,4,72], n3(:,4822), t3x72(:,:,3466))
  call heltable([18,4,72], n3(:,4823), t3x72(:,:,3467))
  call heltable([4,18,72], n3(:,4824), t3x72(:,:,3468))
  call heltable([12,6,72], n3(:,4825), t3x72(:,:,3469))
  call heltable([12,6,72], n3(:,4826), t3x72(:,:,3470))
  call heltable([12,6,72], n3(:,4827), t3x72(:,:,3471))
  call heltable([18,4,72], n3(:,4828), t3x72(:,:,3472))
  call heltable([18,4,72], n3(:,4829), t3x72(:,:,3473))
  call heltable([4,18,72], n3(:,4830), t3x72(:,:,3474))
  call heltable([12,6,72], n3(:,4831), t3x72(:,:,3475))
  call heltable([12,6,72], n3(:,4832), t3x72(:,:,3476))
  call heltable([12,6,72], n3(:,4833), t3x72(:,:,3477))
  call heltable([12,6,72], n3(:,4834), t3x72(:,:,3478))
  call heltable([12,6,72], n3(:,4835), t3x72(:,:,3479))
  call heltable([6,12,72], n3(:,4836), t3x72(:,:,3480))
  call heltable([12,6,72], n3(:,4837), t3x72(:,:,3481))
  call heltable([12,6,72], n3(:,4838), t3x72(:,:,3482))
  call heltable([12,6,72], n3(:,4839), t3x72(:,:,3483))
  call heltable([18,4,72], n3(:,4840), t3x72(:,:,3484))
  call heltable([4,18,72], n3(:,4841), t3x72(:,:,3485))
  call heltable([18,4,72], n3(:,4842), t3x72(:,:,3486))
  call heltable([12,6,72], n3(:,4843), t3x72(:,:,3487))
  call heltable([12,6,72], n3(:,4844), t3x72(:,:,3488))
  call heltable([12,6,72], n3(:,4845), t3x72(:,:,3489))
  call heltable([18,4,72], n3(:,4846), t3x72(:,:,3490))
  call heltable([4,18,72], n3(:,4847), t3x72(:,:,3491))
  call heltable([18,4,72], n3(:,4848), t3x72(:,:,3492))
  call heltable([12,6,72], n3(:,4849), t3x72(:,:,3493))
  call heltable([12,6,72], n3(:,4850), t3x72(:,:,3494))
  call heltable([12,6,72], n3(:,4851), t3x72(:,:,3495))
  call heltable([12,6,72], n3(:,4852), t3x72(:,:,3496))
  call heltable([6,12,72], n3(:,4853), t3x72(:,:,3497))
  call heltable([12,6,72], n3(:,4854), t3x72(:,:,3498))
  call heltable([6,12,72], n3(:,4855), t3x72(:,:,3499))
  call heltable([12,6,72], n3(:,4856), t3x72(:,:,3500))
  call heltable([8,9,72], n3(:,4857), t3x72(:,:,3501))
  call heltable([8,9,72], n3(:,4858), t3x72(:,:,3502))
  call heltable([8,9,72], n3(:,4859), t3x72(:,:,3503))
  call heltable([8,9,72], n3(:,4860), t3x72(:,:,3504))
  call heltable([8,9,72], n3(:,4861), t3x72(:,:,3505))
  call heltable([8,9,72], n3(:,4862), t3x72(:,:,3506))
  call heltable([6,12,72], n3(:,4863), t3x72(:,:,3507))
  call heltable([12,6,72], n3(:,4864), t3x72(:,:,3508))
  call heltable([8,9,72], n3(:,4865), t3x72(:,:,3509))
  call heltable([8,9,72], n3(:,4866), t3x72(:,:,3510))
  call heltable([8,9,72], n3(:,4867), t3x72(:,:,3511))
  call heltable([8,9,72], n3(:,4868), t3x72(:,:,3512))
  call heltable([8,9,72], n3(:,4869), t3x72(:,:,3513))
  call heltable([8,9,72], n3(:,4870), t3x72(:,:,3514))
  call heltable([4,18,72], n3(:,4871), t3x72(:,:,3515))
  call heltable([12,6,72], n3(:,4872), t3x72(:,:,3516))
  call heltable([8,9,72], n3(:,4873), t3x72(:,:,3517))
  call heltable([8,9,72], n3(:,4874), t3x72(:,:,3518))
  call heltable([8,9,72], n3(:,4875), t3x72(:,:,3519))
  call heltable([8,9,72], n3(:,4876), t3x72(:,:,3520))
  call heltable([8,9,72], n3(:,4877), t3x72(:,:,3521))
  call heltable([8,9,72], n3(:,4878), t3x72(:,:,3522))
  call heltable([4,18,72], n3(:,4879), t3x72(:,:,3523))
  call heltable([12,6,72], n3(:,4880), t3x72(:,:,3524))
  call heltable([8,9,72], n3(:,4881), t3x72(:,:,3525))
  call heltable([8,9,72], n3(:,4882), t3x72(:,:,3526))
  call heltable([8,9,72], n3(:,4883), t3x72(:,:,3527))
  call heltable([8,9,72], n3(:,4884), t3x72(:,:,3528))
  call heltable([8,9,72], n3(:,4885), t3x72(:,:,3529))
  call heltable([8,9,72], n3(:,4886), t3x72(:,:,3530))
  call heltable([12,6,72], n3(:,4887), t3x72(:,:,3531))
  call heltable([12,6,72], n3(:,4888), t3x72(:,:,3532))
  call heltable([12,6,72], n3(:,4889), t3x72(:,:,3533))
  call heltable([12,6,72], n3(:,4890), t3x72(:,:,3534))
  call heltable([18,4,72], n3(:,4891), t3x72(:,:,3535))
  call heltable([18,4,72], n3(:,4892), t3x72(:,:,3536))
  call heltable([12,6,72], n3(:,4893), t3x72(:,:,3537))
  call heltable([12,6,72], n3(:,4894), t3x72(:,:,3538))
  call heltable([4,18,72], n3(:,4895), t3x72(:,:,3539))
  call heltable([4,18,72], n3(:,4896), t3x72(:,:,3540))
  call heltable([4,18,72], n3(:,4897), t3x72(:,:,3541))
  call heltable([4,18,72], n3(:,4898), t3x72(:,:,3542))
  call heltable([4,18,72], n3(:,4899), t3x72(:,:,3543))
  call heltable([12,6,72], n3(:,4900), t3x72(:,:,3544))
  call heltable([12,6,72], n3(:,4901), t3x72(:,:,3545))
  call heltable([12,6,72], n3(:,4902), t3x72(:,:,3546))
  call heltable([12,6,72], n3(:,4903), t3x72(:,:,3547))
  call heltable([12,6,72], n3(:,4904), t3x72(:,:,3548))
  call heltable([9,8,72], n3(:,4905), t3x72(:,:,3549))
  call heltable([9,8,72], n3(:,4906), t3x72(:,:,3550))
  call heltable([9,8,72], n3(:,4907), t3x72(:,:,3551))
  call heltable([9,8,72], n3(:,4908), t3x72(:,:,3552))
  call heltable([12,6,72], n3(:,4909), t3x72(:,:,3553))
  call heltable([12,6,72], n3(:,4910), t3x72(:,:,3554))
  call heltable([12,6,72], n3(:,4911), t3x72(:,:,3555))
  call heltable([12,6,72], n3(:,4912), t3x72(:,:,3556))
  call heltable([6,12,72], n3(:,4913), t3x72(:,:,3557))
  call heltable([6,12,72], n3(:,4914), t3x72(:,:,3558))
  call heltable([6,12,72], n3(:,4915), t3x72(:,:,3559))
  call heltable([6,12,72], n3(:,4916), t3x72(:,:,3560))
  call heltable([6,12,72], n3(:,4917), t3x72(:,:,3561))
  call heltable([8,9,72], n3(:,4918), t3x72(:,:,3562))
  call heltable([9,8,72], n3(:,4919), t3x72(:,:,3563))
  call heltable([9,8,72], n3(:,4920), t3x72(:,:,3564))
  call heltable([8,9,72], n3(:,4921), t3x72(:,:,3565))
  call heltable([12,6,72], n3(:,4922), t3x72(:,:,3566))
  call heltable([12,6,72], n3(:,4923), t3x72(:,:,3567))
  call heltable([12,6,72], n3(:,4924), t3x72(:,:,3568))
  call heltable([12,6,72], n3(:,4925), t3x72(:,:,3569))
  call heltable([12,6,72], n3(:,4926), t3x72(:,:,3570))
  call heltable([12,6,72], n3(:,4927), t3x72(:,:,3571))
  call heltable([12,6,72], n3(:,4928), t3x72(:,:,3572))
  call heltable([18,4,72], n3(:,4929), t3x72(:,:,3573))
  call heltable([18,4,72], n3(:,4930), t3x72(:,:,3574))
  call heltable([18,4,72], n3(:,4931), t3x72(:,:,3575))
  call heltable([18,4,72], n3(:,4932), t3x72(:,:,3576))
  call heltable([18,4,72], n3(:,4933), t3x72(:,:,3577))
  call heltable([18,4,72], n3(:,4934), t3x72(:,:,3578))
  call heltable([12,6,72], n3(:,4935), t3x72(:,:,3579))
  call heltable([12,6,72], n3(:,4936), t3x72(:,:,3580))
  call heltable([12,6,72], n3(:,4937), t3x72(:,:,3581))
  call heltable([12,6,72], n3(:,4938), t3x72(:,:,3582))
  call heltable([12,6,72], n3(:,4939), t3x72(:,:,3583))
  call heltable([12,6,72], n3(:,4940), t3x72(:,:,3584))
  call heltable([12,6,72], n3(:,4941), t3x72(:,:,3585))
  call heltable([12,6,72], n3(:,4942), t3x72(:,:,3586))
  call heltable([12,6,72], n3(:,4943), t3x72(:,:,3587))
  call heltable([12,6,72], n3(:,4944), t3x72(:,:,3588))
  call heltable([8,9,72], n3(:,4945), t3x72(:,:,3589))
  call heltable([9,8,72], n3(:,4946), t3x72(:,:,3590))
  call heltable([9,8,72], n3(:,4947), t3x72(:,:,3591))
  call heltable([8,9,72], n3(:,4948), t3x72(:,:,3592))
  call heltable([18,4,72], n3(:,4949), t3x72(:,:,3593))
  call heltable([18,4,72], n3(:,4950), t3x72(:,:,3594))
  call heltable([12,6,72], n3(:,4951), t3x72(:,:,3595))
  call heltable([12,6,72], n3(:,4952), t3x72(:,:,3596))
  call heltable([4,18,72], n3(:,4953), t3x72(:,:,3597))
  call heltable([4,18,72], n3(:,4954), t3x72(:,:,3598))
  call heltable([4,18,72], n3(:,4955), t3x72(:,:,3599))
  call heltable([4,18,72], n3(:,4956), t3x72(:,:,3600))
  call heltable([4,18,72], n3(:,4957), t3x72(:,:,3601))
  call heltable([12,6,72], n3(:,4958), t3x72(:,:,3602))
  call heltable([12,6,72], n3(:,4959), t3x72(:,:,3603))
  call heltable([12,6,72], n3(:,4960), t3x72(:,:,3604))
  call heltable([12,6,72], n3(:,4961), t3x72(:,:,3605))
  call heltable([12,6,72], n3(:,4962), t3x72(:,:,3606))
  call heltable([9,8,72], n3(:,4963), t3x72(:,:,3607))
  call heltable([9,8,72], n3(:,4964), t3x72(:,:,3608))
  call heltable([9,8,72], n3(:,4965), t3x72(:,:,3609))
  call heltable([9,8,72], n3(:,4966), t3x72(:,:,3610))
  call heltable([12,6,72], n3(:,4967), t3x72(:,:,3611))
  call heltable([12,6,72], n3(:,4968), t3x72(:,:,3612))
  call heltable([12,6,72], n3(:,4969), t3x72(:,:,3613))
  call heltable([12,6,72], n3(:,4970), t3x72(:,:,3614))
  call heltable([6,12,72], n3(:,4971), t3x72(:,:,3615))
  call heltable([6,12,72], n3(:,4972), t3x72(:,:,3616))
  call heltable([6,12,72], n3(:,4973), t3x72(:,:,3617))
  call heltable([6,12,72], n3(:,4974), t3x72(:,:,3618))
  call heltable([6,12,72], n3(:,4975), t3x72(:,:,3619))
  call heltable([8,9,72], n3(:,4976), t3x72(:,:,3620))
  call heltable([9,8,72], n3(:,4977), t3x72(:,:,3621))
  call heltable([9,8,72], n3(:,4978), t3x72(:,:,3622))
  call heltable([8,9,72], n3(:,4979), t3x72(:,:,3623))
  call heltable([12,6,72], n3(:,4980), t3x72(:,:,3624))
  call heltable([12,6,72], n3(:,4981), t3x72(:,:,3625))
  call heltable([12,6,72], n3(:,4982), t3x72(:,:,3626))
  call heltable([12,6,72], n3(:,4983), t3x72(:,:,3627))
  call heltable([12,6,72], n3(:,4984), t3x72(:,:,3628))
  call heltable([12,6,72], n3(:,4985), t3x72(:,:,3629))
  call heltable([12,6,72], n3(:,4986), t3x72(:,:,3630))
  call heltable([18,4,72], n3(:,4987), t3x72(:,:,3631))
  call heltable([18,4,72], n3(:,4988), t3x72(:,:,3632))
  call heltable([18,4,72], n3(:,4989), t3x72(:,:,3633))
  call heltable([18,4,72], n3(:,4990), t3x72(:,:,3634))
  call heltable([18,4,72], n3(:,4991), t3x72(:,:,3635))
  call heltable([18,4,72], n3(:,4992), t3x72(:,:,3636))
  call heltable([12,6,72], n3(:,4993), t3x72(:,:,3637))
  call heltable([12,6,72], n3(:,4994), t3x72(:,:,3638))
  call heltable([12,6,72], n3(:,4995), t3x72(:,:,3639))
  call heltable([12,6,72], n3(:,4996), t3x72(:,:,3640))
  call heltable([12,6,72], n3(:,4997), t3x72(:,:,3641))
  call heltable([12,6,72], n3(:,4998), t3x72(:,:,3642))
  call heltable([12,6,72], n3(:,4999), t3x72(:,:,3643))
  call heltable([12,6,72], n3(:,5000), t3x72(:,:,3644))
  call heltable([12,6,72], n3(:,5001), t3x72(:,:,3645))
  call heltable([12,6,72], n3(:,5002), t3x72(:,:,3646))
  call heltable([8,9,72], n3(:,5003), t3x72(:,:,3647))
  call heltable([9,8,72], n3(:,5004), t3x72(:,:,3648))
  call heltable([9,8,72], n3(:,5005), t3x72(:,:,3649))
  call heltable([8,9,72], n3(:,5006), t3x72(:,:,3650))
  call heltable([9,8,72], n3(:,5007), t3x72(:,:,3651))
  call heltable([9,8,72], n3(:,5008), t3x72(:,:,3652))
  call heltable([9,8,72], n3(:,5009), t3x72(:,:,3653))
  call heltable([9,8,72], n3(:,5010), t3x72(:,:,3654))
  call heltable([9,8,72], n3(:,5011), t3x72(:,:,3655))
  call heltable([9,8,72], n3(:,5012), t3x72(:,:,3656))
  call heltable([9,8,72], n3(:,5013), t3x72(:,:,3657))
  call heltable([9,8,72], n3(:,5014), t3x72(:,:,3658))
  call heltable([9,8,72], n3(:,5015), t3x72(:,:,3659))
  call heltable([9,8,72], n3(:,5016), t3x72(:,:,3660))
  call heltable([9,8,72], n3(:,5017), t3x72(:,:,3661))
  call heltable([9,8,72], n3(:,5018), t3x72(:,:,3662))
  call heltable([4,18,72], n3(:,5019), t3x72(:,:,3663))
  call heltable([4,18,72], n3(:,5020), t3x72(:,:,3664))
  call heltable([4,18,72], n3(:,5021), t3x72(:,:,3665))
  call heltable([4,18,72], n3(:,5022), t3x72(:,:,3666))
  call heltable([4,18,72], n3(:,5023), t3x72(:,:,3667))
  call heltable([4,18,72], n3(:,5024), t3x72(:,:,3668))
  call heltable([4,18,72], n3(:,5025), t3x72(:,:,3669))
  call heltable([4,18,72], n3(:,5026), t3x72(:,:,3670))
  call heltable([4,18,72], n3(:,5027), t3x72(:,:,3671))
  call heltable([4,18,72], n3(:,5028), t3x72(:,:,3672))
  call heltable([12,6,72], n3(:,5029), t3x72(:,:,3673))
  call heltable([12,6,72], n3(:,5030), t3x72(:,:,3674))
  call heltable([4,18,72], n3(:,5031), t3x72(:,:,3675))
  call heltable([4,18,72], n3(:,5032), t3x72(:,:,3676))
  call heltable([12,6,72], n3(:,5033), t3x72(:,:,3677))
  call heltable([12,6,72], n3(:,5034), t3x72(:,:,3678))
  call heltable([12,6,72], n3(:,5035), t3x72(:,:,3679))
  call heltable([12,6,72], n3(:,5036), t3x72(:,:,3680))
  call heltable([12,6,72], n3(:,5037), t3x72(:,:,3681))
  call heltable([12,6,72], n3(:,5038), t3x72(:,:,3682))
  call heltable([4,18,72], n3(:,5039), t3x72(:,:,3683))
  call heltable([4,18,72], n3(:,5040), t3x72(:,:,3684))
  call heltable([4,18,72], n3(:,5041), t3x72(:,:,3685))
  call heltable([4,18,72], n3(:,5042), t3x72(:,:,3686))
  call heltable([4,18,72], n3(:,5043), t3x72(:,:,3687))
  call heltable([4,18,72], n3(:,5044), t3x72(:,:,3688))
  call heltable([4,18,72], n3(:,5045), t3x72(:,:,3689))
  call heltable([4,18,72], n3(:,5046), t3x72(:,:,3690))
  call heltable([4,18,72], n3(:,5047), t3x72(:,:,3691))
  call heltable([4,18,72], n3(:,5048), t3x72(:,:,3692))
  call heltable([12,6,72], n3(:,5049), t3x72(:,:,3693))
  call heltable([12,6,72], n3(:,5050), t3x72(:,:,3694))
  call heltable([4,18,72], n3(:,5051), t3x72(:,:,3695))
  call heltable([4,18,72], n3(:,5052), t3x72(:,:,3696))
  call heltable([12,6,72], n3(:,5053), t3x72(:,:,3697))
  call heltable([12,6,72], n3(:,5054), t3x72(:,:,3698))
  call heltable([12,6,72], n3(:,5055), t3x72(:,:,3699))
  call heltable([12,6,72], n3(:,5056), t3x72(:,:,3700))
  call heltable([12,6,72], n3(:,5057), t3x72(:,:,3701))
  call heltable([12,6,72], n3(:,5058), t3x72(:,:,3702))
  call heltable([12,6,72], n3(:,5059), t3x72(:,:,3703))
  call heltable([12,6,72], n3(:,5060), t3x72(:,:,3704))
  call heltable([4,18,72], n3(:,5061), t3x72(:,:,3705))
  call heltable([12,6,72], n3(:,5062), t3x72(:,:,3706))
  call heltable([4,18,72], n3(:,5063), t3x72(:,:,3707))
  call heltable([12,6,72], n3(:,5064), t3x72(:,:,3708))
  call heltable([9,8,72], n3(:,5065), t3x72(:,:,3709))
  call heltable([9,8,72], n3(:,5066), t3x72(:,:,3710))
  call heltable([9,8,72], n3(:,5067), t3x72(:,:,3711))
  call heltable([9,8,72], n3(:,5068), t3x72(:,:,3712))
  call heltable([9,8,72], n3(:,5069), t3x72(:,:,3713))
  call heltable([9,8,72], n3(:,5070), t3x72(:,:,3714))
  call heltable([12,6,72], n3(:,5071), t3x72(:,:,3715))
  call heltable([12,6,72], n3(:,5072), t3x72(:,:,3716))
  call heltable([4,18,72], n3(:,5073), t3x72(:,:,3717))
  call heltable([12,6,72], n3(:,5074), t3x72(:,:,3718))
  call heltable([4,18,72], n3(:,5075), t3x72(:,:,3719))
  call heltable([12,6,72], n3(:,5076), t3x72(:,:,3720))
  call heltable([9,8,72], n3(:,5077), t3x72(:,:,3721))
  call heltable([9,8,72], n3(:,5078), t3x72(:,:,3722))
  call heltable([9,8,72], n3(:,5079), t3x72(:,:,3723))
  call heltable([9,8,72], n3(:,5080), t3x72(:,:,3724))
  call heltable([9,8,72], n3(:,5081), t3x72(:,:,3725))
  call heltable([9,8,72], n3(:,5082), t3x72(:,:,3726))
  call heltable([18,4,72], n3(:,5083), t3x72(:,:,3727))
  call heltable([18,4,72], n3(:,5084), t3x72(:,:,3728))
  call heltable([6,12,72], n3(:,5085), t3x72(:,:,3729))
  call heltable([4,18,72], n3(:,5086), t3x72(:,:,3730))
  call heltable([6,12,72], n3(:,5087), t3x72(:,:,3731))
  call heltable([4,18,72], n3(:,5088), t3x72(:,:,3732))
  call heltable([4,18,72], n3(:,5089), t3x72(:,:,3733))
  call heltable([4,18,72], n3(:,5090), t3x72(:,:,3734))
  call heltable([18,4,72], n3(:,5091), t3x72(:,:,3735))
  call heltable([18,4,72], n3(:,5092), t3x72(:,:,3736))
  call heltable([6,12,72], n3(:,5093), t3x72(:,:,3737))
  call heltable([4,18,72], n3(:,5094), t3x72(:,:,3738))
  call heltable([6,12,72], n3(:,5095), t3x72(:,:,3739))
  call heltable([4,18,72], n3(:,5096), t3x72(:,:,3740))
  call heltable([4,18,72], n3(:,5097), t3x72(:,:,3741))
  call heltable([4,18,72], n3(:,5098), t3x72(:,:,3742))
  call heltable([8,9,72], n3(:,5099), t3x72(:,:,3743))
  call heltable([8,9,72], n3(:,5100), t3x72(:,:,3744))
  call heltable([8,9,72], n3(:,5101), t3x72(:,:,3745))
  call heltable([8,9,72], n3(:,5102), t3x72(:,:,3746))
  call heltable([9,8,72], n3(:,5103), t3x72(:,:,3747))
  call heltable([9,8,72], n3(:,5104), t3x72(:,:,3748))
  call heltable([8,9,72], n3(:,5105), t3x72(:,:,3749))
  call heltable([8,9,72], n3(:,5106), t3x72(:,:,3750))
  call heltable([9,8,72], n3(:,5107), t3x72(:,:,3751))
  call heltable([9,8,72], n3(:,5108), t3x72(:,:,3752))
  call heltable([9,8,72], n3(:,5109), t3x72(:,:,3753))
  call heltable([9,8,72], n3(:,5110), t3x72(:,:,3754))
  call heltable([18,4,72], n3(:,5111), t3x72(:,:,3755))
  call heltable([12,6,72], n3(:,5112), t3x72(:,:,3756))
  call heltable([9,8,72], n3(:,5113), t3x72(:,:,3757))
  call heltable([9,8,72], n3(:,5114), t3x72(:,:,3758))
  call heltable([12,6,72], n3(:,5115), t3x72(:,:,3759))
  call heltable([12,6,72], n3(:,5116), t3x72(:,:,3760))
  call heltable([6,12,72], n3(:,5117), t3x72(:,:,3761))
  call heltable([4,18,72], n3(:,5118), t3x72(:,:,3762))
  call heltable([4,18,72], n3(:,5119), t3x72(:,:,3763))
  call heltable([4,18,72], n3(:,5120), t3x72(:,:,3764))
  call heltable([4,18,72], n3(:,5121), t3x72(:,:,3765))
  call heltable([12,6,72], n3(:,5122), t3x72(:,:,3766))
  call heltable([8,9,72], n3(:,5123), t3x72(:,:,3767))
  call heltable([8,9,72], n3(:,5124), t3x72(:,:,3768))
  call heltable([12,6,72], n3(:,5125), t3x72(:,:,3769))
  call heltable([12,6,72], n3(:,5126), t3x72(:,:,3770))
  call heltable([6,12,72], n3(:,5127), t3x72(:,:,3771))
  call heltable([4,18,72], n3(:,5128), t3x72(:,:,3772))
  call heltable([4,18,72], n3(:,5129), t3x72(:,:,3773))
  call heltable([4,18,72], n3(:,5130), t3x72(:,:,3774))
  call heltable([18,4,72], n3(:,5131), t3x72(:,:,3775))
  call heltable([12,6,72], n3(:,5132), t3x72(:,:,3776))
  call heltable([9,8,72], n3(:,5133), t3x72(:,:,3777))
  call heltable([9,8,72], n3(:,5134), t3x72(:,:,3778))
  call heltable([12,6,72], n3(:,5135), t3x72(:,:,3779))
  call heltable([12,6,72], n3(:,5136), t3x72(:,:,3780))
  call heltable([6,12,72], n3(:,5137), t3x72(:,:,3781))
  call heltable([4,18,72], n3(:,5138), t3x72(:,:,3782))
  call heltable([4,18,72], n3(:,5139), t3x72(:,:,3783))
  call heltable([4,18,72], n3(:,5140), t3x72(:,:,3784))
  call heltable([4,18,72], n3(:,5141), t3x72(:,:,3785))
  call heltable([12,6,72], n3(:,5142), t3x72(:,:,3786))
  call heltable([8,9,72], n3(:,5143), t3x72(:,:,3787))
  call heltable([8,9,72], n3(:,5144), t3x72(:,:,3788))
  call heltable([12,6,72], n3(:,5145), t3x72(:,:,3789))
  call heltable([12,6,72], n3(:,5146), t3x72(:,:,3790))
  call heltable([6,12,72], n3(:,5147), t3x72(:,:,3791))
  call heltable([4,18,72], n3(:,5148), t3x72(:,:,3792))
  call heltable([4,18,72], n3(:,5149), t3x72(:,:,3793))
  call heltable([4,18,72], n3(:,5150), t3x72(:,:,3794))
  call heltable([4,18,72], n3(:,5151), t3x72(:,:,3795))
  call heltable([4,18,72], n3(:,5152), t3x72(:,:,3796))
  call heltable([6,12,72], n3(:,5153), t3x72(:,:,3797))
  call heltable([4,18,72], n3(:,5154), t3x72(:,:,3798))
  call heltable([6,12,72], n3(:,5155), t3x72(:,:,3799))
  call heltable([4,18,72], n3(:,5156), t3x72(:,:,3800))
  call heltable([4,18,72], n3(:,5157), t3x72(:,:,3801))
  call heltable([4,18,72], n3(:,5158), t3x72(:,:,3802))
  call heltable([12,6,72], n3(:,5159), t3x72(:,:,3803))
  call heltable([12,6,72], n3(:,5160), t3x72(:,:,3804))
  call heltable([6,12,72], n3(:,5161), t3x72(:,:,3805))
  call heltable([6,12,72], n3(:,5162), t3x72(:,:,3806))
  call heltable([12,6,72], n3(:,5163), t3x72(:,:,3807))
  call heltable([12,6,72], n3(:,5164), t3x72(:,:,3808))
  call heltable([4,18,72], n3(:,5165), t3x72(:,:,3809))
  call heltable([18,4,72], n3(:,5166), t3x72(:,:,3810))
  call heltable([12,6,72], n3(:,5167), t3x72(:,:,3811))
  call heltable([18,4,72], n3(:,5168), t3x72(:,:,3812))
  call heltable([6,12,72], n3(:,5169), t3x72(:,:,3813))
  call heltable([18,4,72], n3(:,5170), t3x72(:,:,3814))
  call heltable([4,18,72], n3(:,5171), t3x72(:,:,3815))
  call heltable([4,18,72], n3(:,5172), t3x72(:,:,3816))
  call heltable([18,4,72], n3(:,5173), t3x72(:,:,3817))
  call heltable([4,18,72], n3(:,5174), t3x72(:,:,3818))
  call heltable([6,12,72], n3(:,5175), t3x72(:,:,3819))
  call heltable([4,18,72], n3(:,5176), t3x72(:,:,3820))
  call heltable([12,6,72], n3(:,5177), t3x72(:,:,3821))
  call heltable([4,18,72], n3(:,5178), t3x72(:,:,3822))
  call heltable([18,4,72], n3(:,5179), t3x72(:,:,3823))
  call heltable([18,4,72], n3(:,5180), t3x72(:,:,3824))
  call heltable([36,2,72], n3(:,5181), t3x72(:,:,3825))
  call heltable([2,36,72], n3(:,5182), t3x72(:,:,3826))
  call heltable([36,2,72], n3(:,5183), t3x72(:,:,3827))
  call heltable([2,36,72], n3(:,5184), t3x72(:,:,3828))
  call heltable([12,6,72], n3(:,5185), t3x72(:,:,3829))
  call heltable([18,4,72], n3(:,5186), t3x72(:,:,3830))
  call heltable([12,6,72], n3(:,5187), t3x72(:,:,3831))
  call heltable([4,18,72], n3(:,5188), t3x72(:,:,3832))
  call heltable([6,12,72], n3(:,5189), t3x72(:,:,3833))
  call heltable([6,12,72], n3(:,5190), t3x72(:,:,3834))
  call heltable([12,6,72], n3(:,5191), t3x72(:,:,3835))
  call heltable([18,4,72], n3(:,5192), t3x72(:,:,3836))
  call heltable([12,6,72], n3(:,5193), t3x72(:,:,3837))
  call heltable([4,18,72], n3(:,5194), t3x72(:,:,3838))
  call heltable([6,12,72], n3(:,5195), t3x72(:,:,3839))
  call heltable([6,12,72], n3(:,5196), t3x72(:,:,3840))
  call heltable([36,2,72], n3(:,5197), t3x72(:,:,3841))
  call heltable([2,36,72], n3(:,5198), t3x72(:,:,3842))
  call heltable([36,2,72], n3(:,5199), t3x72(:,:,3843))
  call heltable([36,2,72], n3(:,5200), t3x72(:,:,3844))
  call heltable([36,2,72], n3(:,5201), t3x72(:,:,3845))
  call heltable([36,2,72], n3(:,5202), t3x72(:,:,3846))
  call heltable([36,2,72], n3(:,5203), t3x72(:,:,3847))
  call heltable([36,2,72], n3(:,5204), t3x72(:,:,3848))
  call heltable([36,2,72], n3(:,5205), t3x72(:,:,3849))
  call heltable([36,2,72], n3(:,5206), t3x72(:,:,3850))
  call heltable([36,2,72], n3(:,5207), t3x72(:,:,3851))
  call heltable([36,2,72], n3(:,5208), t3x72(:,:,3852))
  call heltable([36,2,72], n3(:,5209), t3x72(:,:,3853))
  call heltable([36,2,72], n3(:,5210), t3x72(:,:,3854))
  call heltable([36,2,72], n3(:,5211), t3x72(:,:,3855))
  call heltable([36,2,72], n3(:,5212), t3x72(:,:,3856))
  call heltable([2,36,72], n3(:,5213), t3x72(:,:,3857))
  call heltable([2,36,72], n3(:,5214), t3x72(:,:,3858))
  call heltable([2,36,72], n3(:,5215), t3x72(:,:,3859))
  call heltable([2,36,72], n3(:,5216), t3x72(:,:,3860))
  call heltable([2,36,72], n3(:,5217), t3x72(:,:,3861))
  call heltable([2,36,72], n3(:,5218), t3x72(:,:,3862))
  call heltable([2,36,72], n3(:,5219), t3x72(:,:,3863))
  call heltable([2,36,72], n3(:,5220), t3x72(:,:,3864))
  call heltable([2,36,72], n3(:,5221), t3x72(:,:,3865))
  call heltable([2,36,72], n3(:,5222), t3x72(:,:,3866))
  call heltable([2,36,72], n3(:,5223), t3x72(:,:,3867))
  call heltable([2,36,72], n3(:,5224), t3x72(:,:,3868))
  call heltable([2,36,72], n3(:,5225), t3x72(:,:,3869))
  call heltable([2,36,72], n3(:,5226), t3x72(:,:,3870))
  call heltable([2,36,72], n3(:,5227), t3x72(:,:,3871))
  call heltable([2,36,72], n3(:,5228), t3x72(:,:,3872))
  call heltable([36,2,72], n3(:,5229), t3x72(:,:,3873))
  call heltable([36,2,72], n3(:,5230), t3x72(:,:,3874))
  call heltable([2,36,72], n3(:,5231), t3x72(:,:,3875))
  call heltable([2,36,72], n3(:,5232), t3x72(:,:,3876))
  call heltable([36,2,72], n3(:,5233), t3x72(:,:,3877))
  call heltable([36,2,72], n3(:,5234), t3x72(:,:,3878))
  call heltable([36,2,72], n3(:,5235), t3x72(:,:,3879))
  call heltable([36,2,72], n3(:,5236), t3x72(:,:,3880))
  call heltable([36,2,72], n3(:,5237), t3x72(:,:,3881))
  call heltable([36,2,72], n3(:,5238), t3x72(:,:,3882))
  call heltable([36,2,72], n3(:,5239), t3x72(:,:,3883))
  call heltable([36,2,72], n3(:,5240), t3x72(:,:,3884))
  call heltable([36,2,72], n3(:,5241), t3x72(:,:,3885))
  call heltable([36,2,72], n3(:,5242), t3x72(:,:,3886))
  call heltable([36,2,72], n3(:,5243), t3x72(:,:,3887))
  call heltable([36,2,72], n3(:,5244), t3x72(:,:,3888))
  call heltable([2,36,72], n3(:,5245), t3x72(:,:,3889))
  call heltable([2,36,72], n3(:,5246), t3x72(:,:,3890))
  call heltable([2,36,72], n3(:,5247), t3x72(:,:,3891))
  call heltable([2,36,72], n3(:,5248), t3x72(:,:,3892))
  call heltable([2,36,72], n3(:,5249), t3x72(:,:,3893))
  call heltable([2,36,72], n3(:,5250), t3x72(:,:,3894))
  call heltable([2,36,72], n3(:,5251), t3x72(:,:,3895))
  call heltable([2,36,72], n3(:,5252), t3x72(:,:,3896))
  call heltable([2,36,72], n3(:,5253), t3x72(:,:,3897))
  call heltable([2,36,72], n3(:,5254), t3x72(:,:,3898))
  call heltable([2,36,72], n3(:,5255), t3x72(:,:,3899))
  call heltable([2,36,72], n3(:,5256), t3x72(:,:,3900))
  call heltable([2,36,72], n3(:,5257), t3x72(:,:,3901))
  call heltable([2,36,72], n3(:,5258), t3x72(:,:,3902))
  call heltable([2,36,72], n3(:,5259), t3x72(:,:,3903))
  call heltable([2,36,72], n3(:,5260), t3x72(:,:,3904))
  call heltable([12,6,72], n3(:,5261), t3x72(:,:,3905))
  call heltable([6,12,72], n3(:,5262), t3x72(:,:,3906))
  call heltable([12,6,72], n3(:,5263), t3x72(:,:,3907))
  call heltable([12,6,72], n3(:,5264), t3x72(:,:,3908))
  call heltable([12,6,72], n3(:,5265), t3x72(:,:,3909))
  call heltable([12,6,72], n3(:,5266), t3x72(:,:,3910))
  call heltable([12,6,72], n3(:,5267), t3x72(:,:,3911))
  call heltable([12,6,72], n3(:,5268), t3x72(:,:,3912))
  call heltable([12,6,72], n3(:,5269), t3x72(:,:,3913))
  call heltable([12,6,72], n3(:,5270), t3x72(:,:,3914))
  call heltable([12,6,72], n3(:,5271), t3x72(:,:,3915))
  call heltable([12,6,72], n3(:,5272), t3x72(:,:,3916))
  call heltable([12,6,72], n3(:,5273), t3x72(:,:,3917))
  call heltable([12,6,72], n3(:,5274), t3x72(:,:,3918))
  call heltable([12,6,72], n3(:,5275), t3x72(:,:,3919))
  call heltable([12,6,72], n3(:,5276), t3x72(:,:,3920))
  call heltable([18,4,72], n3(:,5277), t3x72(:,:,3921))
  call heltable([4,18,72], n3(:,5278), t3x72(:,:,3922))
  call heltable([18,4,72], n3(:,5279), t3x72(:,:,3923))
  call heltable([18,4,72], n3(:,5280), t3x72(:,:,3924))
  call heltable([18,4,72], n3(:,5281), t3x72(:,:,3925))
  call heltable([18,4,72], n3(:,5282), t3x72(:,:,3926))
  call heltable([18,4,72], n3(:,5283), t3x72(:,:,3927))
  call heltable([18,4,72], n3(:,5284), t3x72(:,:,3928))
  call heltable([18,4,72], n3(:,5285), t3x72(:,:,3929))
  call heltable([18,4,72], n3(:,5286), t3x72(:,:,3930))
  call heltable([18,4,72], n3(:,5287), t3x72(:,:,3931))
  call heltable([18,4,72], n3(:,5288), t3x72(:,:,3932))
  call heltable([18,4,72], n3(:,5289), t3x72(:,:,3933))
  call heltable([18,4,72], n3(:,5290), t3x72(:,:,3934))
  call heltable([18,4,72], n3(:,5291), t3x72(:,:,3935))
  call heltable([18,4,72], n3(:,5292), t3x72(:,:,3936))
  call heltable([12,6,72], n3(:,5293), t3x72(:,:,3937))
  call heltable([6,12,72], n3(:,5294), t3x72(:,:,3938))
  call heltable([12,6,72], n3(:,5295), t3x72(:,:,3939))
  call heltable([12,6,72], n3(:,5296), t3x72(:,:,3940))
  call heltable([12,6,72], n3(:,5297), t3x72(:,:,3941))
  call heltable([12,6,72], n3(:,5298), t3x72(:,:,3942))
  call heltable([12,6,72], n3(:,5299), t3x72(:,:,3943))
  call heltable([12,6,72], n3(:,5300), t3x72(:,:,3944))
  call heltable([12,6,72], n3(:,5301), t3x72(:,:,3945))
  call heltable([12,6,72], n3(:,5302), t3x72(:,:,3946))
  call heltable([12,6,72], n3(:,5303), t3x72(:,:,3947))
  call heltable([12,6,72], n3(:,5304), t3x72(:,:,3948))
  call heltable([12,6,72], n3(:,5305), t3x72(:,:,3949))
  call heltable([12,6,72], n3(:,5306), t3x72(:,:,3950))
  call heltable([12,6,72], n3(:,5307), t3x72(:,:,3951))
  call heltable([12,6,72], n3(:,5308), t3x72(:,:,3952))
  call heltable([4,18,72], n3(:,5309), t3x72(:,:,3953))
  call heltable([4,18,72], n3(:,5310), t3x72(:,:,3954))
  call heltable([4,18,72], n3(:,5311), t3x72(:,:,3955))
  call heltable([4,18,72], n3(:,5312), t3x72(:,:,3956))
  call heltable([4,18,72], n3(:,5313), t3x72(:,:,3957))
  call heltable([4,18,72], n3(:,5314), t3x72(:,:,3958))
  call heltable([4,18,72], n3(:,5315), t3x72(:,:,3959))
  call heltable([4,18,72], n3(:,5316), t3x72(:,:,3960))
  call heltable([4,18,72], n3(:,5317), t3x72(:,:,3961))
  call heltable([4,18,72], n3(:,5318), t3x72(:,:,3962))
  call heltable([4,18,72], n3(:,5319), t3x72(:,:,3963))
  call heltable([4,18,72], n3(:,5320), t3x72(:,:,3964))
  call heltable([4,18,72], n3(:,5321), t3x72(:,:,3965))
  call heltable([4,18,72], n3(:,5322), t3x72(:,:,3966))
  call heltable([4,18,72], n3(:,5323), t3x72(:,:,3967))
  call heltable([4,18,72], n3(:,5324), t3x72(:,:,3968))
  call heltable([6,12,72], n3(:,5325), t3x72(:,:,3969))
  call heltable([6,12,72], n3(:,5326), t3x72(:,:,3970))
  call heltable([6,12,72], n3(:,5327), t3x72(:,:,3971))
  call heltable([6,12,72], n3(:,5328), t3x72(:,:,3972))
  call heltable([6,12,72], n3(:,5329), t3x72(:,:,3973))
  call heltable([6,12,72], n3(:,5330), t3x72(:,:,3974))
  call heltable([6,12,72], n3(:,5331), t3x72(:,:,3975))
  call heltable([6,12,72], n3(:,5332), t3x72(:,:,3976))
  call heltable([6,12,72], n3(:,5333), t3x72(:,:,3977))
  call heltable([6,12,72], n3(:,5334), t3x72(:,:,3978))
  call heltable([6,12,72], n3(:,5335), t3x72(:,:,3979))
  call heltable([6,12,72], n3(:,5336), t3x72(:,:,3980))
  call heltable([6,12,72], n3(:,5337), t3x72(:,:,3981))
  call heltable([6,12,72], n3(:,5338), t3x72(:,:,3982))
  call heltable([6,12,72], n3(:,5339), t3x72(:,:,3983))
  call heltable([6,12,72], n3(:,5340), t3x72(:,:,3984))
  call heltable([6,12,72], n3(:,5341), t3x72(:,:,3985))
  call heltable([6,12,72], n3(:,5342), t3x72(:,:,3986))
  call heltable([6,12,72], n3(:,5343), t3x72(:,:,3987))
  call heltable([6,12,72], n3(:,5344), t3x72(:,:,3988))
  call heltable([6,12,72], n3(:,5345), t3x72(:,:,3989))
  call heltable([6,12,72], n3(:,5346), t3x72(:,:,3990))
  call heltable([6,12,72], n3(:,5347), t3x72(:,:,3991))
  call heltable([6,12,72], n3(:,5348), t3x72(:,:,3992))
  call heltable([6,12,72], n3(:,5349), t3x72(:,:,3993))
  call heltable([6,12,72], n3(:,5350), t3x72(:,:,3994))
  call heltable([6,12,72], n3(:,5351), t3x72(:,:,3995))
  call heltable([6,12,72], n3(:,5352), t3x72(:,:,3996))
  call heltable([6,12,72], n3(:,5353), t3x72(:,:,3997))
  call heltable([6,12,72], n3(:,5354), t3x72(:,:,3998))
  call heltable([6,12,72], n3(:,5355), t3x72(:,:,3999))
  call heltable([6,12,72], n3(:,5356), t3x72(:,:,4000))
  call heltable([12,6,72], n3(:,5357), t3x72(:,:,4001))
  call heltable([12,6,72], n3(:,5358), t3x72(:,:,4002))
  call heltable([6,12,72], n3(:,5359), t3x72(:,:,4003))
  call heltable([6,12,72], n3(:,5360), t3x72(:,:,4004))
  call heltable([12,6,72], n3(:,5361), t3x72(:,:,4005))
  call heltable([12,6,72], n3(:,5362), t3x72(:,:,4006))
  call heltable([12,6,72], n3(:,5363), t3x72(:,:,4007))
  call heltable([12,6,72], n3(:,5364), t3x72(:,:,4008))
  call heltable([12,6,72], n3(:,5365), t3x72(:,:,4009))
  call heltable([12,6,72], n3(:,5366), t3x72(:,:,4010))
  call heltable([12,6,72], n3(:,5367), t3x72(:,:,4011))
  call heltable([12,6,72], n3(:,5368), t3x72(:,:,4012))
  call heltable([12,6,72], n3(:,5369), t3x72(:,:,4013))
  call heltable([12,6,72], n3(:,5370), t3x72(:,:,4014))
  call heltable([12,6,72], n3(:,5371), t3x72(:,:,4015))
  call heltable([12,6,72], n3(:,5372), t3x72(:,:,4016))
  call heltable([18,4,72], n3(:,5373), t3x72(:,:,4017))
  call heltable([18,4,72], n3(:,5374), t3x72(:,:,4018))
  call heltable([4,18,72], n3(:,5375), t3x72(:,:,4019))
  call heltable([4,18,72], n3(:,5376), t3x72(:,:,4020))
  call heltable([18,4,72], n3(:,5377), t3x72(:,:,4021))
  call heltable([18,4,72], n3(:,5378), t3x72(:,:,4022))
  call heltable([18,4,72], n3(:,5379), t3x72(:,:,4023))
  call heltable([18,4,72], n3(:,5380), t3x72(:,:,4024))
  call heltable([18,4,72], n3(:,5381), t3x72(:,:,4025))
  call heltable([18,4,72], n3(:,5382), t3x72(:,:,4026))
  call heltable([18,4,72], n3(:,5383), t3x72(:,:,4027))
  call heltable([18,4,72], n3(:,5384), t3x72(:,:,4028))
  call heltable([18,4,72], n3(:,5385), t3x72(:,:,4029))
  call heltable([18,4,72], n3(:,5386), t3x72(:,:,4030))
  call heltable([18,4,72], n3(:,5387), t3x72(:,:,4031))
  call heltable([18,4,72], n3(:,5388), t3x72(:,:,4032))
  call heltable([12,6,72], n3(:,5389), t3x72(:,:,4033))
  call heltable([12,6,72], n3(:,5390), t3x72(:,:,4034))
  call heltable([6,12,72], n3(:,5391), t3x72(:,:,4035))
  call heltable([6,12,72], n3(:,5392), t3x72(:,:,4036))
  call heltable([12,6,72], n3(:,5393), t3x72(:,:,4037))
  call heltable([12,6,72], n3(:,5394), t3x72(:,:,4038))
  call heltable([12,6,72], n3(:,5395), t3x72(:,:,4039))
  call heltable([12,6,72], n3(:,5396), t3x72(:,:,4040))
  call heltable([12,6,72], n3(:,5397), t3x72(:,:,4041))
  call heltable([12,6,72], n3(:,5398), t3x72(:,:,4042))
  call heltable([12,6,72], n3(:,5399), t3x72(:,:,4043))
  call heltable([12,6,72], n3(:,5400), t3x72(:,:,4044))
  call heltable([12,6,72], n3(:,5401), t3x72(:,:,4045))
  call heltable([12,6,72], n3(:,5402), t3x72(:,:,4046))
  call heltable([12,6,72], n3(:,5403), t3x72(:,:,4047))
  call heltable([12,6,72], n3(:,5404), t3x72(:,:,4048))
  call heltable([4,18,72], n3(:,5405), t3x72(:,:,4049))
  call heltable([4,18,72], n3(:,5406), t3x72(:,:,4050))
  call heltable([4,18,72], n3(:,5407), t3x72(:,:,4051))
  call heltable([4,18,72], n3(:,5408), t3x72(:,:,4052))
  call heltable([4,18,72], n3(:,5409), t3x72(:,:,4053))
  call heltable([4,18,72], n3(:,5410), t3x72(:,:,4054))
  call heltable([4,18,72], n3(:,5411), t3x72(:,:,4055))
  call heltable([4,18,72], n3(:,5412), t3x72(:,:,4056))
  call heltable([4,18,72], n3(:,5413), t3x72(:,:,4057))
  call heltable([4,18,72], n3(:,5414), t3x72(:,:,4058))
  call heltable([4,18,72], n3(:,5415), t3x72(:,:,4059))
  call heltable([4,18,72], n3(:,5416), t3x72(:,:,4060))
  call heltable([4,18,72], n3(:,5417), t3x72(:,:,4061))
  call heltable([4,18,72], n3(:,5418), t3x72(:,:,4062))
  call heltable([4,18,72], n3(:,5419), t3x72(:,:,4063))
  call heltable([4,18,72], n3(:,5420), t3x72(:,:,4064))
  call heltable([6,12,72], n3(:,5421), t3x72(:,:,4065))
  call heltable([6,12,72], n3(:,5422), t3x72(:,:,4066))
  call heltable([6,12,72], n3(:,5423), t3x72(:,:,4067))
  call heltable([6,12,72], n3(:,5424), t3x72(:,:,4068))
  call heltable([6,12,72], n3(:,5425), t3x72(:,:,4069))
  call heltable([6,12,72], n3(:,5426), t3x72(:,:,4070))
  call heltable([6,12,72], n3(:,5427), t3x72(:,:,4071))
  call heltable([6,12,72], n3(:,5428), t3x72(:,:,4072))
  call heltable([6,12,72], n3(:,5429), t3x72(:,:,4073))
  call heltable([6,12,72], n3(:,5430), t3x72(:,:,4074))
  call heltable([6,12,72], n3(:,5431), t3x72(:,:,4075))
  call heltable([6,12,72], n3(:,5432), t3x72(:,:,4076))
  call heltable([6,12,72], n3(:,5433), t3x72(:,:,4077))
  call heltable([6,12,72], n3(:,5434), t3x72(:,:,4078))
  call heltable([6,12,72], n3(:,5435), t3x72(:,:,4079))
  call heltable([6,12,72], n3(:,5436), t3x72(:,:,4080))
  call heltable([6,12,72], n3(:,5437), t3x72(:,:,4081))
  call heltable([6,12,72], n3(:,5438), t3x72(:,:,4082))
  call heltable([6,12,72], n3(:,5439), t3x72(:,:,4083))
  call heltable([6,12,72], n3(:,5440), t3x72(:,:,4084))
  call heltable([6,12,72], n3(:,5441), t3x72(:,:,4085))
  call heltable([6,12,72], n3(:,5442), t3x72(:,:,4086))
  call heltable([6,12,72], n3(:,5443), t3x72(:,:,4087))
  call heltable([6,12,72], n3(:,5444), t3x72(:,:,4088))
  call heltable([6,12,72], n3(:,5445), t3x72(:,:,4089))
  call heltable([6,12,72], n3(:,5446), t3x72(:,:,4090))
  call heltable([6,12,72], n3(:,5447), t3x72(:,:,4091))
  call heltable([6,12,72], n3(:,5448), t3x72(:,:,4092))
  call heltable([6,12,72], n3(:,5449), t3x72(:,:,4093))
  call heltable([6,12,72], n3(:,5450), t3x72(:,:,4094))
  call heltable([6,12,72], n3(:,5451), t3x72(:,:,4095))
  call heltable([6,12,72], n3(:,5452), t3x72(:,:,4096))
  call heltable([24,3,72], n3(:,5453), t3x72(:,:,4097))
  call heltable([24,3,72], n3(:,5454), t3x72(:,:,4098))
  call heltable([24,3,72], n3(:,5455), t3x72(:,:,4099))
  call heltable([24,3,72], n3(:,5456), t3x72(:,:,4100))
  call heltable([24,3,72], n3(:,5457), t3x72(:,:,4101))
  call heltable([24,3,72], n3(:,5458), t3x72(:,:,4102))
  call heltable([24,3,72], n3(:,5459), t3x72(:,:,4103))
  call heltable([24,3,72], n3(:,5460), t3x72(:,:,4104))
  call heltable([3,24,72], n3(:,5461), t3x72(:,:,4105))
  call heltable([3,24,72], n3(:,5462), t3x72(:,:,4106))
  call heltable([3,24,72], n3(:,5463), t3x72(:,:,4107))
  call heltable([3,24,72], n3(:,5464), t3x72(:,:,4108))
  call heltable([3,24,72], n3(:,5465), t3x72(:,:,4109))
  call heltable([3,24,72], n3(:,5466), t3x72(:,:,4110))
  call heltable([3,24,72], n3(:,5467), t3x72(:,:,4111))
  call heltable([3,24,72], n3(:,5468), t3x72(:,:,4112))
  call heltable([3,24,72], n3(:,5469), t3x72(:,:,4113))
  call heltable([3,24,72], n3(:,5470), t3x72(:,:,4114))
  call heltable([3,24,72], n3(:,5471), t3x72(:,:,4115))
  call heltable([3,24,72], n3(:,5472), t3x72(:,:,4116))
  call heltable([3,24,72], n3(:,5473), t3x72(:,:,4117))
  call heltable([3,24,72], n3(:,5474), t3x72(:,:,4118))
  call heltable([3,24,72], n3(:,5475), t3x72(:,:,4119))
  call heltable([3,24,72], n3(:,5476), t3x72(:,:,4120))
  call heltable([3,24,72], n3(:,5477), t3x72(:,:,4121))
  call heltable([3,24,72], n3(:,5478), t3x72(:,:,4122))
  call heltable([3,24,72], n3(:,5479), t3x72(:,:,4123))
  call heltable([3,24,72], n3(:,5480), t3x72(:,:,4124))
  call heltable([3,24,72], n3(:,5481), t3x72(:,:,4125))
  call heltable([3,24,72], n3(:,5482), t3x72(:,:,4126))
  call heltable([3,24,72], n3(:,5483), t3x72(:,:,4127))
  call heltable([3,24,72], n3(:,5484), t3x72(:,:,4128))
  call heltable([24,3,72], n3(:,5485), t3x72(:,:,4129))
  call heltable([24,3,72], n3(:,5486), t3x72(:,:,4130))
  call heltable([24,3,72], n3(:,5487), t3x72(:,:,4131))
  call heltable([24,3,72], n3(:,5488), t3x72(:,:,4132))
  call heltable([24,3,72], n3(:,5489), t3x72(:,:,4133))
  call heltable([24,3,72], n3(:,5490), t3x72(:,:,4134))
  call heltable([24,3,72], n3(:,5491), t3x72(:,:,4135))
  call heltable([24,3,72], n3(:,5492), t3x72(:,:,4136))
  call heltable([3,24,72], n3(:,5493), t3x72(:,:,4137))
  call heltable([3,24,72], n3(:,5494), t3x72(:,:,4138))
  call heltable([3,24,72], n3(:,5495), t3x72(:,:,4139))
  call heltable([3,24,72], n3(:,5496), t3x72(:,:,4140))
  call heltable([3,24,72], n3(:,5497), t3x72(:,:,4141))
  call heltable([3,24,72], n3(:,5498), t3x72(:,:,4142))
  call heltable([3,24,72], n3(:,5499), t3x72(:,:,4143))
  call heltable([3,24,72], n3(:,5500), t3x72(:,:,4144))
  call heltable([3,24,72], n3(:,5501), t3x72(:,:,4145))
  call heltable([3,24,72], n3(:,5502), t3x72(:,:,4146))
  call heltable([3,24,72], n3(:,5503), t3x72(:,:,4147))
  call heltable([3,24,72], n3(:,5504), t3x72(:,:,4148))
  call heltable([3,24,72], n3(:,5505), t3x72(:,:,4149))
  call heltable([3,24,72], n3(:,5506), t3x72(:,:,4150))
  call heltable([3,24,72], n3(:,5507), t3x72(:,:,4151))
  call heltable([3,24,72], n3(:,5508), t3x72(:,:,4152))
  call heltable([3,24,72], n3(:,5509), t3x72(:,:,4153))
  call heltable([3,24,72], n3(:,5510), t3x72(:,:,4154))
  call heltable([3,24,72], n3(:,5511), t3x72(:,:,4155))
  call heltable([3,24,72], n3(:,5512), t3x72(:,:,4156))
  call heltable([3,24,72], n3(:,5513), t3x72(:,:,4157))
  call heltable([3,24,72], n3(:,5514), t3x72(:,:,4158))
  call heltable([3,24,72], n3(:,5515), t3x72(:,:,4159))
  call heltable([3,24,72], n3(:,5516), t3x72(:,:,4160))
  call heltable([3,24,72], n3(:,5517), t3x72(:,:,4161))
  call heltable([3,24,72], n3(:,5518), t3x72(:,:,4162))
  call heltable([3,24,72], n3(:,5519), t3x72(:,:,4163))
  call heltable([3,24,72], n3(:,5520), t3x72(:,:,4164))
  call heltable([3,24,72], n3(:,5521), t3x72(:,:,4165))
  call heltable([3,24,72], n3(:,5522), t3x72(:,:,4166))
  call heltable([3,24,72], n3(:,5523), t3x72(:,:,4167))
  call heltable([3,24,72], n3(:,5524), t3x72(:,:,4168))
  call heltable([3,24,72], n3(:,5525), t3x72(:,:,4169))
  call heltable([3,24,72], n3(:,5526), t3x72(:,:,4170))
  call heltable([3,24,72], n3(:,5527), t3x72(:,:,4171))
  call heltable([3,24,72], n3(:,5528), t3x72(:,:,4172))
  call heltable([3,24,72], n3(:,5529), t3x72(:,:,4173))
  call heltable([3,24,72], n3(:,5530), t3x72(:,:,4174))
  call heltable([3,24,72], n3(:,5531), t3x72(:,:,4175))
  call heltable([3,24,72], n3(:,5532), t3x72(:,:,4176))
  call heltable([3,24,72], n3(:,5533), t3x72(:,:,4177))
  call heltable([3,24,72], n3(:,5534), t3x72(:,:,4178))
  call heltable([3,24,72], n3(:,5535), t3x72(:,:,4179))
  call heltable([3,24,72], n3(:,5536), t3x72(:,:,4180))
  call heltable([3,24,72], n3(:,5537), t3x72(:,:,4181))
  call heltable([3,24,72], n3(:,5538), t3x72(:,:,4182))
  call heltable([3,24,72], n3(:,5539), t3x72(:,:,4183))
  call heltable([3,24,72], n3(:,5540), t3x72(:,:,4184))
  call heltable([3,24,72], n3(:,5541), t3x72(:,:,4185))
  call heltable([3,24,72], n3(:,5542), t3x72(:,:,4186))
  call heltable([3,24,72], n3(:,5543), t3x72(:,:,4187))
  call heltable([3,24,72], n3(:,5544), t3x72(:,:,4188))
  call heltable([3,24,72], n3(:,5545), t3x72(:,:,4189))
  call heltable([3,24,72], n3(:,5546), t3x72(:,:,4190))
  call heltable([3,24,72], n3(:,5547), t3x72(:,:,4191))
  call heltable([3,24,72], n3(:,5548), t3x72(:,:,4192))
  call heltable([3,24,72], n3(:,5549), t3x72(:,:,4193))
  call heltable([3,24,72], n3(:,5550), t3x72(:,:,4194))
  call heltable([3,24,72], n3(:,5551), t3x72(:,:,4195))
  call heltable([3,24,72], n3(:,5552), t3x72(:,:,4196))
  call heltable([3,24,72], n3(:,5553), t3x72(:,:,4197))
  call heltable([3,24,72], n3(:,5554), t3x72(:,:,4198))
  call heltable([3,24,72], n3(:,5555), t3x72(:,:,4199))
  call heltable([3,24,72], n3(:,5556), t3x72(:,:,4200))
  call heltable([3,24,72], n3(:,5557), t3x72(:,:,4201))
  call heltable([3,24,72], n3(:,5558), t3x72(:,:,4202))
  call heltable([3,24,72], n3(:,5559), t3x72(:,:,4203))
  call heltable([3,24,72], n3(:,5560), t3x72(:,:,4204))
  call heltable([3,24,72], n3(:,5561), t3x72(:,:,4205))
  call heltable([3,24,72], n3(:,5562), t3x72(:,:,4206))
  call heltable([3,24,72], n3(:,5563), t3x72(:,:,4207))
  call heltable([3,24,72], n3(:,5564), t3x72(:,:,4208))
  call heltable([3,24,72], n3(:,5565), t3x72(:,:,4209))
  call heltable([3,24,72], n3(:,5566), t3x72(:,:,4210))
  call heltable([3,24,72], n3(:,5567), t3x72(:,:,4211))
  call heltable([3,24,72], n3(:,5568), t3x72(:,:,4212))
  call heltable([3,24,72], n3(:,5569), t3x72(:,:,4213))
  call heltable([3,24,72], n3(:,5570), t3x72(:,:,4214))
  call heltable([3,24,72], n3(:,5571), t3x72(:,:,4215))
  call heltable([3,24,72], n3(:,5572), t3x72(:,:,4216))
  call heltable([3,24,72], n3(:,5573), t3x72(:,:,4217))
  call heltable([3,24,72], n3(:,5574), t3x72(:,:,4218))
  call heltable([3,24,72], n3(:,5575), t3x72(:,:,4219))
  call heltable([3,24,72], n3(:,5576), t3x72(:,:,4220))
  call heltable([3,24,72], n3(:,5577), t3x72(:,:,4221))
  call heltable([3,24,72], n3(:,5578), t3x72(:,:,4222))
  call heltable([3,24,72], n3(:,5579), t3x72(:,:,4223))
  call heltable([3,24,72], n3(:,5580), t3x72(:,:,4224))
  call heltable([12,6,72], n3(:,5581), t3x72(:,:,4225))
  call heltable([12,6,72], n3(:,5582), t3x72(:,:,4226))
  call heltable([12,6,72], n3(:,5583), t3x72(:,:,4227))
  call heltable([12,6,72], n3(:,5584), t3x72(:,:,4228))
  call heltable([12,6,72], n3(:,5585), t3x72(:,:,4229))
  call heltable([12,6,72], n3(:,5586), t3x72(:,:,4230))
  call heltable([12,6,72], n3(:,5587), t3x72(:,:,4231))
  call heltable([12,6,72], n3(:,5588), t3x72(:,:,4232))
  call heltable([12,6,72], n3(:,5589), t3x72(:,:,4233))
  call heltable([12,6,72], n3(:,5590), t3x72(:,:,4234))
  call heltable([12,6,72], n3(:,5591), t3x72(:,:,4235))
  call heltable([12,6,72], n3(:,5592), t3x72(:,:,4236))
  call heltable([12,6,72], n3(:,5593), t3x72(:,:,4237))
  call heltable([12,6,72], n3(:,5594), t3x72(:,:,4238))
  call heltable([12,6,72], n3(:,5595), t3x72(:,:,4239))
  call heltable([12,6,72], n3(:,5596), t3x72(:,:,4240))
  call heltable([3,24,72], n3(:,5597), t3x72(:,:,4241))
  call heltable([3,24,72], n3(:,5598), t3x72(:,:,4242))
  call heltable([3,24,72], n3(:,5599), t3x72(:,:,4243))
  call heltable([3,24,72], n3(:,5600), t3x72(:,:,4244))
  call heltable([3,24,72], n3(:,5601), t3x72(:,:,4245))
  call heltable([3,24,72], n3(:,5602), t3x72(:,:,4246))
  call heltable([3,24,72], n3(:,5603), t3x72(:,:,4247))
  call heltable([3,24,72], n3(:,5604), t3x72(:,:,4248))
  call heltable([36,2,72], n3(:,5605), t3x72(:,:,4249))
  call heltable([2,36,72], n3(:,5606), t3x72(:,:,4250))
  call heltable([3,24,72], n3(:,5607), t3x72(:,:,4251))
  call heltable([3,24,72], n3(:,5608), t3x72(:,:,4252))
  call heltable([3,24,72], n3(:,5609), t3x72(:,:,4253))
  call heltable([3,24,72], n3(:,5610), t3x72(:,:,4254))
  call heltable([3,24,72], n3(:,5611), t3x72(:,:,4255))
  call heltable([3,24,72], n3(:,5612), t3x72(:,:,4256))
  call heltable([3,24,72], n3(:,5613), t3x72(:,:,4257))
  call heltable([3,24,72], n3(:,5614), t3x72(:,:,4258))
  call heltable([3,24,72], n3(:,5615), t3x72(:,:,4259))
  call heltable([3,24,72], n3(:,5616), t3x72(:,:,4260))
  call heltable([3,24,72], n3(:,5617), t3x72(:,:,4261))
  call heltable([3,24,72], n3(:,5618), t3x72(:,:,4262))
  call heltable([3,24,72], n3(:,5619), t3x72(:,:,4263))
  call heltable([3,24,72], n3(:,5620), t3x72(:,:,4264))
  call heltable([3,24,72], n3(:,5621), t3x72(:,:,4265))
  call heltable([3,24,72], n3(:,5622), t3x72(:,:,4266))
  call heltable([2,36,72], n3(:,5623), t3x72(:,:,4267))
  call heltable([2,36,72], n3(:,5624), t3x72(:,:,4268))
  call heltable([2,36,72], n3(:,5625), t3x72(:,:,4269))
  call heltable([2,36,72], n3(:,5626), t3x72(:,:,4270))
  call heltable([12,6,72], n3(:,5627), t3x72(:,:,4271))
  call heltable([12,6,72], n3(:,5628), t3x72(:,:,4272))
  call heltable([12,6,72], n3(:,5629), t3x72(:,:,4273))
  call heltable([12,6,72], n3(:,5630), t3x72(:,:,4274))
  call heltable([12,6,72], n3(:,5631), t3x72(:,:,4275))
  call heltable([12,6,72], n3(:,5632), t3x72(:,:,4276))
  call heltable([12,6,72], n3(:,5633), t3x72(:,:,4277))
  call heltable([12,6,72], n3(:,5634), t3x72(:,:,4278))
  call heltable([8,9,72], n3(:,5635), t3x72(:,:,4279))
  call heltable([8,9,72], n3(:,5636), t3x72(:,:,4280))
  call heltable([8,9,72], n3(:,5637), t3x72(:,:,4281))
  call heltable([8,9,72], n3(:,5638), t3x72(:,:,4282))
  call heltable([8,9,72], n3(:,5639), t3x72(:,:,4283))
  call heltable([8,9,72], n3(:,5640), t3x72(:,:,4284))
  call heltable([8,9,72], n3(:,5641), t3x72(:,:,4285))
  call heltable([8,9,72], n3(:,5642), t3x72(:,:,4286))
  call heltable([12,6,72], n3(:,5643), t3x72(:,:,4287))
  call heltable([18,4,72], n3(:,5644), t3x72(:,:,4288))
  call heltable([4,18,72], n3(:,5645), t3x72(:,:,4289))
  call heltable([4,18,72], n3(:,5646), t3x72(:,:,4290))
  call heltable([3,24,72], n3(:,5647), t3x72(:,:,4291))
  call heltable([3,24,72], n3(:,5648), t3x72(:,:,4292))
  call heltable([3,24,72], n3(:,5649), t3x72(:,:,4293))
  call heltable([3,24,72], n3(:,5650), t3x72(:,:,4294))
  call heltable([3,24,72], n3(:,5651), t3x72(:,:,4295))
  call heltable([3,24,72], n3(:,5652), t3x72(:,:,4296))
  call heltable([3,24,72], n3(:,5653), t3x72(:,:,4297))
  call heltable([3,24,72], n3(:,5654), t3x72(:,:,4298))
  call heltable([2,36,72], n3(:,5655), t3x72(:,:,4299))
  call heltable([2,36,72], n3(:,5656), t3x72(:,:,4300))
  call heltable([3,24,72], n3(:,5657), t3x72(:,:,4301))
  call heltable([3,24,72], n3(:,5658), t3x72(:,:,4302))
  call heltable([3,24,72], n3(:,5659), t3x72(:,:,4303))
  call heltable([3,24,72], n3(:,5660), t3x72(:,:,4304))
  call heltable([3,24,72], n3(:,5661), t3x72(:,:,4305))
  call heltable([3,24,72], n3(:,5662), t3x72(:,:,4306))
  call heltable([3,24,72], n3(:,5663), t3x72(:,:,4307))
  call heltable([3,24,72], n3(:,5664), t3x72(:,:,4308))
  call heltable([3,24,72], n3(:,5665), t3x72(:,:,4309))
  call heltable([3,24,72], n3(:,5666), t3x72(:,:,4310))
  call heltable([3,24,72], n3(:,5667), t3x72(:,:,4311))
  call heltable([3,24,72], n3(:,5668), t3x72(:,:,4312))
  call heltable([3,24,72], n3(:,5669), t3x72(:,:,4313))
  call heltable([3,24,72], n3(:,5670), t3x72(:,:,4314))
  call heltable([3,24,72], n3(:,5671), t3x72(:,:,4315))
  call heltable([3,24,72], n3(:,5672), t3x72(:,:,4316))
  call heltable([2,36,72], n3(:,5673), t3x72(:,:,4317))
  call heltable([2,36,72], n3(:,5674), t3x72(:,:,4318))
  call heltable([2,36,72], n3(:,5675), t3x72(:,:,4319))
  call heltable([2,36,72], n3(:,5676), t3x72(:,:,4320))
  call heltable([12,6,72], n3(:,5677), t3x72(:,:,4321))
  call heltable([12,6,72], n3(:,5678), t3x72(:,:,4322))
  call heltable([12,6,72], n3(:,5679), t3x72(:,:,4323))
  call heltable([12,6,72], n3(:,5680), t3x72(:,:,4324))
  call heltable([12,6,72], n3(:,5681), t3x72(:,:,4325))
  call heltable([12,6,72], n3(:,5682), t3x72(:,:,4326))
  call heltable([12,6,72], n3(:,5683), t3x72(:,:,4327))
  call heltable([12,6,72], n3(:,5684), t3x72(:,:,4328))
  call heltable([8,9,72], n3(:,5685), t3x72(:,:,4329))
  call heltable([8,9,72], n3(:,5686), t3x72(:,:,4330))
  call heltable([8,9,72], n3(:,5687), t3x72(:,:,4331))
  call heltable([8,9,72], n3(:,5688), t3x72(:,:,4332))
  call heltable([8,9,72], n3(:,5689), t3x72(:,:,4333))
  call heltable([8,9,72], n3(:,5690), t3x72(:,:,4334))
  call heltable([8,9,72], n3(:,5691), t3x72(:,:,4335))
  call heltable([8,9,72], n3(:,5692), t3x72(:,:,4336))
  call heltable([12,6,72], n3(:,5693), t3x72(:,:,4337))
  call heltable([4,18,72], n3(:,5694), t3x72(:,:,4338))
  call heltable([4,18,72], n3(:,5695), t3x72(:,:,4339))
  call heltable([4,18,72], n3(:,5696), t3x72(:,:,4340))
  call heltable([3,24,72], n3(:,5697), t3x72(:,:,4341))
  call heltable([3,24,72], n3(:,5698), t3x72(:,:,4342))
  call heltable([3,24,72], n3(:,5699), t3x72(:,:,4343))
  call heltable([3,24,72], n3(:,5700), t3x72(:,:,4344))
  call heltable([3,24,72], n3(:,5701), t3x72(:,:,4345))
  call heltable([3,24,72], n3(:,5702), t3x72(:,:,4346))
  call heltable([3,24,72], n3(:,5703), t3x72(:,:,4347))
  call heltable([3,24,72], n3(:,5704), t3x72(:,:,4348))
  call heltable([36,2,72], n3(:,5705), t3x72(:,:,4349))
  call heltable([2,36,72], n3(:,5706), t3x72(:,:,4350))
  call heltable([3,24,72], n3(:,5707), t3x72(:,:,4351))
  call heltable([3,24,72], n3(:,5708), t3x72(:,:,4352))
  call heltable([3,24,72], n3(:,5709), t3x72(:,:,4353))
  call heltable([3,24,72], n3(:,5710), t3x72(:,:,4354))
  call heltable([3,24,72], n3(:,5711), t3x72(:,:,4355))
  call heltable([3,24,72], n3(:,5712), t3x72(:,:,4356))
  call heltable([3,24,72], n3(:,5713), t3x72(:,:,4357))
  call heltable([3,24,72], n3(:,5714), t3x72(:,:,4358))
  call heltable([3,24,72], n3(:,5715), t3x72(:,:,4359))
  call heltable([3,24,72], n3(:,5716), t3x72(:,:,4360))
  call heltable([3,24,72], n3(:,5717), t3x72(:,:,4361))
  call heltable([3,24,72], n3(:,5718), t3x72(:,:,4362))
  call heltable([3,24,72], n3(:,5719), t3x72(:,:,4363))
  call heltable([3,24,72], n3(:,5720), t3x72(:,:,4364))
  call heltable([3,24,72], n3(:,5721), t3x72(:,:,4365))
  call heltable([3,24,72], n3(:,5722), t3x72(:,:,4366))
  call heltable([2,36,72], n3(:,5723), t3x72(:,:,4367))
  call heltable([2,36,72], n3(:,5724), t3x72(:,:,4368))
  call heltable([2,36,72], n3(:,5725), t3x72(:,:,4369))
  call heltable([2,36,72], n3(:,5726), t3x72(:,:,4370))
  call heltable([12,6,72], n3(:,5727), t3x72(:,:,4371))
  call heltable([12,6,72], n3(:,5728), t3x72(:,:,4372))
  call heltable([12,6,72], n3(:,5729), t3x72(:,:,4373))
  call heltable([12,6,72], n3(:,5730), t3x72(:,:,4374))
  call heltable([12,6,72], n3(:,5731), t3x72(:,:,4375))
  call heltable([12,6,72], n3(:,5732), t3x72(:,:,4376))
  call heltable([12,6,72], n3(:,5733), t3x72(:,:,4377))
  call heltable([12,6,72], n3(:,5734), t3x72(:,:,4378))
  call heltable([8,9,72], n3(:,5735), t3x72(:,:,4379))
  call heltable([8,9,72], n3(:,5736), t3x72(:,:,4380))
  call heltable([8,9,72], n3(:,5737), t3x72(:,:,4381))
  call heltable([8,9,72], n3(:,5738), t3x72(:,:,4382))
  call heltable([8,9,72], n3(:,5739), t3x72(:,:,4383))
  call heltable([8,9,72], n3(:,5740), t3x72(:,:,4384))
  call heltable([8,9,72], n3(:,5741), t3x72(:,:,4385))
  call heltable([8,9,72], n3(:,5742), t3x72(:,:,4386))
  call heltable([12,6,72], n3(:,5743), t3x72(:,:,4387))
  call heltable([18,4,72], n3(:,5744), t3x72(:,:,4388))
  call heltable([4,18,72], n3(:,5745), t3x72(:,:,4389))
  call heltable([4,18,72], n3(:,5746), t3x72(:,:,4390))
  call heltable([3,24,72], n3(:,5747), t3x72(:,:,4391))
  call heltable([3,24,72], n3(:,5748), t3x72(:,:,4392))
  call heltable([3,24,72], n3(:,5749), t3x72(:,:,4393))
  call heltable([3,24,72], n3(:,5750), t3x72(:,:,4394))
  call heltable([3,24,72], n3(:,5751), t3x72(:,:,4395))
  call heltable([3,24,72], n3(:,5752), t3x72(:,:,4396))
  call heltable([3,24,72], n3(:,5753), t3x72(:,:,4397))
  call heltable([3,24,72], n3(:,5754), t3x72(:,:,4398))
  call heltable([2,36,72], n3(:,5755), t3x72(:,:,4399))
  call heltable([2,36,72], n3(:,5756), t3x72(:,:,4400))
  call heltable([3,24,72], n3(:,5757), t3x72(:,:,4401))
  call heltable([3,24,72], n3(:,5758), t3x72(:,:,4402))
  call heltable([3,24,72], n3(:,5759), t3x72(:,:,4403))
  call heltable([3,24,72], n3(:,5760), t3x72(:,:,4404))
  call heltable([3,24,72], n3(:,5761), t3x72(:,:,4405))
  call heltable([3,24,72], n3(:,5762), t3x72(:,:,4406))
  call heltable([3,24,72], n3(:,5763), t3x72(:,:,4407))
  call heltable([3,24,72], n3(:,5764), t3x72(:,:,4408))
  call heltable([3,24,72], n3(:,5765), t3x72(:,:,4409))
  call heltable([3,24,72], n3(:,5766), t3x72(:,:,4410))
  call heltable([3,24,72], n3(:,5767), t3x72(:,:,4411))
  call heltable([3,24,72], n3(:,5768), t3x72(:,:,4412))
  call heltable([3,24,72], n3(:,5769), t3x72(:,:,4413))
  call heltable([3,24,72], n3(:,5770), t3x72(:,:,4414))
  call heltable([3,24,72], n3(:,5771), t3x72(:,:,4415))
  call heltable([3,24,72], n3(:,5772), t3x72(:,:,4416))
  call heltable([2,36,72], n3(:,5773), t3x72(:,:,4417))
  call heltable([2,36,72], n3(:,5774), t3x72(:,:,4418))
  call heltable([2,36,72], n3(:,5775), t3x72(:,:,4419))
  call heltable([2,36,72], n3(:,5776), t3x72(:,:,4420))
  call heltable([12,6,72], n3(:,5777), t3x72(:,:,4421))
  call heltable([12,6,72], n3(:,5778), t3x72(:,:,4422))
  call heltable([12,6,72], n3(:,5779), t3x72(:,:,4423))
  call heltable([12,6,72], n3(:,5780), t3x72(:,:,4424))
  call heltable([12,6,72], n3(:,5781), t3x72(:,:,4425))
  call heltable([12,6,72], n3(:,5782), t3x72(:,:,4426))
  call heltable([12,6,72], n3(:,5783), t3x72(:,:,4427))
  call heltable([12,6,72], n3(:,5784), t3x72(:,:,4428))
  call heltable([8,9,72], n3(:,5785), t3x72(:,:,4429))
  call heltable([8,9,72], n3(:,5786), t3x72(:,:,4430))
  call heltable([8,9,72], n3(:,5787), t3x72(:,:,4431))
  call heltable([8,9,72], n3(:,5788), t3x72(:,:,4432))
  call heltable([8,9,72], n3(:,5789), t3x72(:,:,4433))
  call heltable([8,9,72], n3(:,5790), t3x72(:,:,4434))
  call heltable([8,9,72], n3(:,5791), t3x72(:,:,4435))
  call heltable([8,9,72], n3(:,5792), t3x72(:,:,4436))
  call heltable([12,6,72], n3(:,5793), t3x72(:,:,4437))
  call heltable([4,18,72], n3(:,5794), t3x72(:,:,4438))
  call heltable([4,18,72], n3(:,5795), t3x72(:,:,4439))
  call heltable([4,18,72], n3(:,5796), t3x72(:,:,4440))
  call heltable([2,36,72], n3(:,5797), t3x72(:,:,4441))
  call heltable([2,36,72], n3(:,5798), t3x72(:,:,4442))
  call heltable([2,36,72], n3(:,5799), t3x72(:,:,4443))
  call heltable([2,36,72], n3(:,5800), t3x72(:,:,4444))
  call heltable([12,6,72], n3(:,5801), t3x72(:,:,4445))
  call heltable([4,18,72], n3(:,5802), t3x72(:,:,4446))
  call heltable([12,6,72], n3(:,5803), t3x72(:,:,4447))
  call heltable([4,18,72], n3(:,5804), t3x72(:,:,4448))
  call heltable([12,6,72], n3(:,5805), t3x72(:,:,4449))
  call heltable([12,6,72], n3(:,5806), t3x72(:,:,4450))
  call heltable([12,6,72], n3(:,5807), t3x72(:,:,4451))
  call heltable([4,18,72], n3(:,5808), t3x72(:,:,4452))
  call heltable([12,6,72], n3(:,5809), t3x72(:,:,4453))
  call heltable([4,18,72], n3(:,5810), t3x72(:,:,4454))
  call heltable([12,6,72], n3(:,5811), t3x72(:,:,4455))
  call heltable([12,6,72], n3(:,5812), t3x72(:,:,4456))
  call heltable([36,2,72], n3(:,5813), t3x72(:,:,4457))
  call heltable([36,2,72], n3(:,5814), t3x72(:,:,4458))
  call heltable([36,2,72], n3(:,5815), t3x72(:,:,4459))
  call heltable([36,2,72], n3(:,5816), t3x72(:,:,4460))
  call heltable([36,2,72], n3(:,5817), t3x72(:,:,4461))
  call heltable([36,2,72], n3(:,5818), t3x72(:,:,4462))
  call heltable([12,6,72], n3(:,5819), t3x72(:,:,4463))
  call heltable([18,4,72], n3(:,5820), t3x72(:,:,4464))
  call heltable([18,4,72], n3(:,5821), t3x72(:,:,4465))
  call heltable([18,4,72], n3(:,5822), t3x72(:,:,4466))
  call heltable([36,2,72], n3(:,5823), t3x72(:,:,4467))
  call heltable([36,2,72], n3(:,5824), t3x72(:,:,4468))
  call heltable([36,2,72], n3(:,5825), t3x72(:,:,4469))
  call heltable([36,2,72], n3(:,5826), t3x72(:,:,4470))
  call heltable([36,2,72], n3(:,5827), t3x72(:,:,4471))
  call heltable([36,2,72], n3(:,5828), t3x72(:,:,4472))
  call heltable([12,6,72], n3(:,5829), t3x72(:,:,4473))
  call heltable([18,4,72], n3(:,5830), t3x72(:,:,4474))
  call heltable([18,4,72], n3(:,5831), t3x72(:,:,4475))
  call heltable([18,4,72], n3(:,5832), t3x72(:,:,4476))
  call heltable([36,2,72], n3(:,5833), t3x72(:,:,4477))
  call heltable([36,2,72], n3(:,5834), t3x72(:,:,4478))
  call heltable([36,2,72], n3(:,5835), t3x72(:,:,4479))
  call heltable([36,2,72], n3(:,5836), t3x72(:,:,4480))
  call heltable([36,2,72], n3(:,5837), t3x72(:,:,4481))
  call heltable([36,2,72], n3(:,5838), t3x72(:,:,4482))
  call heltable([12,6,72], n3(:,5839), t3x72(:,:,4483))
  call heltable([18,4,72], n3(:,5840), t3x72(:,:,4484))
  call heltable([18,4,72], n3(:,5841), t3x72(:,:,4485))
  call heltable([18,4,72], n3(:,5842), t3x72(:,:,4486))
  call heltable([36,2,72], n3(:,5843), t3x72(:,:,4487))
  call heltable([36,2,72], n3(:,5844), t3x72(:,:,4488))
  call heltable([36,2,72], n3(:,5845), t3x72(:,:,4489))
  call heltable([36,2,72], n3(:,5846), t3x72(:,:,4490))
  call heltable([36,2,72], n3(:,5847), t3x72(:,:,4491))
  call heltable([36,2,72], n3(:,5848), t3x72(:,:,4492))
  call heltable([12,6,72], n3(:,5849), t3x72(:,:,4493))
  call heltable([18,4,72], n3(:,5850), t3x72(:,:,4494))
  call heltable([18,4,72], n3(:,5851), t3x72(:,:,4495))
  call heltable([18,4,72], n3(:,5852), t3x72(:,:,4496))
  call heltable([36,2,72], n3(:,5853), t3x72(:,:,4497))
  call heltable([36,2,72], n3(:,5854), t3x72(:,:,4498))
  call heltable([36,2,72], n3(:,5855), t3x72(:,:,4499))
  call heltable([36,2,72], n3(:,5856), t3x72(:,:,4500))
  call heltable([36,2,72], n3(:,5857), t3x72(:,:,4501))
  call heltable([36,2,72], n3(:,5858), t3x72(:,:,4502))
  call heltable([36,2,72], n3(:,5859), t3x72(:,:,4503))
  call heltable([36,2,72], n3(:,5860), t3x72(:,:,4504))
  call heltable([12,6,72], n3(:,5861), t3x72(:,:,4505))
  call heltable([12,6,72], n3(:,5862), t3x72(:,:,4506))
  call heltable([18,4,72], n3(:,5863), t3x72(:,:,4507))
  call heltable([18,4,72], n3(:,5864), t3x72(:,:,4508))
  call heltable([12,6,72], n3(:,5865), t3x72(:,:,4509))
  call heltable([12,6,72], n3(:,5866), t3x72(:,:,4510))
  call heltable([18,4,72], n3(:,5867), t3x72(:,:,4511))
  call heltable([18,4,72], n3(:,5868), t3x72(:,:,4512))
  call heltable([12,6,72], n3(:,5869), t3x72(:,:,4513))
  call heltable([12,6,72], n3(:,5870), t3x72(:,:,4514))
  call heltable([12,6,72], n3(:,5871), t3x72(:,:,4515))
  call heltable([12,6,72], n3(:,5872), t3x72(:,:,4516))
  call heltable([12,6,72], n3(:,5873), t3x72(:,:,4517))
  call heltable([12,6,72], n3(:,5874), t3x72(:,:,4518))
  call heltable([18,4,72], n3(:,5875), t3x72(:,:,4519))
  call heltable([18,4,72], n3(:,5876), t3x72(:,:,4520))
  call heltable([12,6,72], n3(:,5877), t3x72(:,:,4521))
  call heltable([12,6,72], n3(:,5878), t3x72(:,:,4522))
  call heltable([18,4,72], n3(:,5879), t3x72(:,:,4523))
  call heltable([18,4,72], n3(:,5880), t3x72(:,:,4524))
  call heltable([12,6,72], n3(:,5881), t3x72(:,:,4525))
  call heltable([12,6,72], n3(:,5882), t3x72(:,:,4526))
  call heltable([12,6,72], n3(:,5883), t3x72(:,:,4527))
  call heltable([12,6,72], n3(:,5884), t3x72(:,:,4528))
  call heltable([36,2,72], n3(:,5885), t3x72(:,:,4529))
  call heltable([36,2,72], n3(:,5886), t3x72(:,:,4530))
  call heltable([36,2,72], n3(:,5887), t3x72(:,:,4531))
  call heltable([36,2,72], n3(:,5888), t3x72(:,:,4532))
  call heltable([36,2,72], n3(:,5889), t3x72(:,:,4533))
  call heltable([36,2,72], n3(:,5890), t3x72(:,:,4534))
  call heltable([12,6,72], n3(:,5891), t3x72(:,:,4535))
  call heltable([18,4,72], n3(:,5892), t3x72(:,:,4536))
  call heltable([18,4,72], n3(:,5893), t3x72(:,:,4537))
  call heltable([18,4,72], n3(:,5894), t3x72(:,:,4538))
  call heltable([36,2,72], n3(:,5895), t3x72(:,:,4539))
  call heltable([36,2,72], n3(:,5896), t3x72(:,:,4540))
  call heltable([36,2,72], n3(:,5897), t3x72(:,:,4541))
  call heltable([36,2,72], n3(:,5898), t3x72(:,:,4542))
  call heltable([36,2,72], n3(:,5899), t3x72(:,:,4543))
  call heltable([36,2,72], n3(:,5900), t3x72(:,:,4544))
  call heltable([12,6,72], n3(:,5901), t3x72(:,:,4545))
  call heltable([18,4,72], n3(:,5902), t3x72(:,:,4546))
  call heltable([18,4,72], n3(:,5903), t3x72(:,:,4547))
  call heltable([18,4,72], n3(:,5904), t3x72(:,:,4548))
  call heltable([36,2,72], n3(:,5905), t3x72(:,:,4549))
  call heltable([36,2,72], n3(:,5906), t3x72(:,:,4550))
  call heltable([36,2,72], n3(:,5907), t3x72(:,:,4551))
  call heltable([36,2,72], n3(:,5908), t3x72(:,:,4552))
  call heltable([36,2,72], n3(:,5909), t3x72(:,:,4553))
  call heltable([36,2,72], n3(:,5910), t3x72(:,:,4554))
  call heltable([12,6,72], n3(:,5911), t3x72(:,:,4555))
  call heltable([18,4,72], n3(:,5912), t3x72(:,:,4556))
  call heltable([18,4,72], n3(:,5913), t3x72(:,:,4557))
  call heltable([18,4,72], n3(:,5914), t3x72(:,:,4558))
  call heltable([36,2,72], n3(:,5915), t3x72(:,:,4559))
  call heltable([36,2,72], n3(:,5916), t3x72(:,:,4560))
  call heltable([36,2,72], n3(:,5917), t3x72(:,:,4561))
  call heltable([36,2,72], n3(:,5918), t3x72(:,:,4562))
  call heltable([36,2,72], n3(:,5919), t3x72(:,:,4563))
  call heltable([36,2,72], n3(:,5920), t3x72(:,:,4564))
  call heltable([12,6,72], n3(:,5921), t3x72(:,:,4565))
  call heltable([18,4,72], n3(:,5922), t3x72(:,:,4566))
  call heltable([18,4,72], n3(:,5923), t3x72(:,:,4567))
  call heltable([18,4,72], n3(:,5924), t3x72(:,:,4568))
  call heltable([36,2,72], n3(:,5925), t3x72(:,:,4569))
  call heltable([36,2,72], n3(:,5926), t3x72(:,:,4570))
  call heltable([36,2,72], n3(:,5927), t3x72(:,:,4571))
  call heltable([36,2,72], n3(:,5928), t3x72(:,:,4572))
  call heltable([36,2,72], n3(:,5929), t3x72(:,:,4573))
  call heltable([36,2,72], n3(:,5930), t3x72(:,:,4574))
  call heltable([36,2,72], n3(:,5931), t3x72(:,:,4575))
  call heltable([36,2,72], n3(:,5932), t3x72(:,:,4576))
  call heltable([12,6,72], n3(:,5933), t3x72(:,:,4577))
  call heltable([12,6,72], n3(:,5934), t3x72(:,:,4578))
  call heltable([18,4,72], n3(:,5935), t3x72(:,:,4579))
  call heltable([18,4,72], n3(:,5936), t3x72(:,:,4580))
  call heltable([12,6,72], n3(:,5937), t3x72(:,:,4581))
  call heltable([12,6,72], n3(:,5938), t3x72(:,:,4582))
  call heltable([18,4,72], n3(:,5939), t3x72(:,:,4583))
  call heltable([18,4,72], n3(:,5940), t3x72(:,:,4584))
  call heltable([12,6,72], n3(:,5941), t3x72(:,:,4585))
  call heltable([12,6,72], n3(:,5942), t3x72(:,:,4586))
  call heltable([12,6,72], n3(:,5943), t3x72(:,:,4587))
  call heltable([12,6,72], n3(:,5944), t3x72(:,:,4588))
  call heltable([12,6,72], n3(:,5945), t3x72(:,:,4589))
  call heltable([12,6,72], n3(:,5946), t3x72(:,:,4590))
  call heltable([18,4,72], n3(:,5947), t3x72(:,:,4591))
  call heltable([18,4,72], n3(:,5948), t3x72(:,:,4592))
  call heltable([12,6,72], n3(:,5949), t3x72(:,:,4593))
  call heltable([12,6,72], n3(:,5950), t3x72(:,:,4594))
  call heltable([18,4,72], n3(:,5951), t3x72(:,:,4595))
  call heltable([18,4,72], n3(:,5952), t3x72(:,:,4596))
  call heltable([12,6,72], n3(:,5953), t3x72(:,:,4597))
  call heltable([12,6,72], n3(:,5954), t3x72(:,:,4598))
  call heltable([12,6,72], n3(:,5955), t3x72(:,:,4599))
  call heltable([12,6,72], n3(:,5956), t3x72(:,:,4600))
  call heltable([36,2,72], n3(:,5957), t3x72(:,:,4601))
  call heltable([36,2,72], n3(:,5958), t3x72(:,:,4602))
  call heltable([36,2,72], n3(:,5959), t3x72(:,:,4603))
  call heltable([36,2,72], n3(:,5960), t3x72(:,:,4604))
  call heltable([36,2,72], n3(:,5961), t3x72(:,:,4605))
  call heltable([36,2,72], n3(:,5962), t3x72(:,:,4606))
  call heltable([36,2,72], n3(:,5963), t3x72(:,:,4607))
  call heltable([36,2,72], n3(:,5964), t3x72(:,:,4608))
  call heltable([12,6,72], n3(:,5965), t3x72(:,:,4609))
  call heltable([12,6,72], n3(:,5966), t3x72(:,:,4610))
  call heltable([18,4,72], n3(:,5967), t3x72(:,:,4611))
  call heltable([18,4,72], n3(:,5968), t3x72(:,:,4612))
  call heltable([12,6,72], n3(:,5969), t3x72(:,:,4613))
  call heltable([12,6,72], n3(:,5970), t3x72(:,:,4614))
  call heltable([18,4,72], n3(:,5971), t3x72(:,:,4615))
  call heltable([18,4,72], n3(:,5972), t3x72(:,:,4616))
  call heltable([12,6,72], n3(:,5973), t3x72(:,:,4617))
  call heltable([12,6,72], n3(:,5974), t3x72(:,:,4618))
  call heltable([12,6,72], n3(:,5975), t3x72(:,:,4619))
  call heltable([12,6,72], n3(:,5976), t3x72(:,:,4620))
  call heltable([12,6,72], n3(:,5977), t3x72(:,:,4621))
  call heltable([12,6,72], n3(:,5978), t3x72(:,:,4622))
  call heltable([18,4,72], n3(:,5979), t3x72(:,:,4623))
  call heltable([18,4,72], n3(:,5980), t3x72(:,:,4624))
  call heltable([12,6,72], n3(:,5981), t3x72(:,:,4625))
  call heltable([12,6,72], n3(:,5982), t3x72(:,:,4626))
  call heltable([18,4,72], n3(:,5983), t3x72(:,:,4627))
  call heltable([18,4,72], n3(:,5984), t3x72(:,:,4628))
  call heltable([12,6,72], n3(:,5985), t3x72(:,:,4629))
  call heltable([12,6,72], n3(:,5986), t3x72(:,:,4630))
  call heltable([12,6,72], n3(:,5987), t3x72(:,:,4631))
  call heltable([12,6,72], n3(:,5988), t3x72(:,:,4632))
  call heltable([6,12,72], n3(:,5989), t3x72(:,:,4633))
  call heltable([6,12,72], n3(:,5990), t3x72(:,:,4634))
  call heltable([6,12,72], n3(:,5991), t3x72(:,:,4635))
  call heltable([6,12,72], n3(:,5992), t3x72(:,:,4636))
  call heltable([12,6,72], n3(:,5993), t3x72(:,:,4637))
  call heltable([12,6,72], n3(:,5994), t3x72(:,:,4638))
  call heltable([12,6,72], n3(:,5995), t3x72(:,:,4639))
  call heltable([12,6,72], n3(:,5996), t3x72(:,:,4640))
  call heltable([8,9,72], n3(:,5997), t3x72(:,:,4641))
  call heltable([8,9,72], n3(:,5998), t3x72(:,:,4642))
  call heltable([8,9,72], n3(:,5999), t3x72(:,:,4643))
  call heltable([8,9,72], n3(:,6000), t3x72(:,:,4644))
  call heltable([8,9,72], n3(:,6001), t3x72(:,:,4645))
  call heltable([8,9,72], n3(:,6002), t3x72(:,:,4646))
  call heltable([8,9,72], n3(:,6003), t3x72(:,:,4647))
  call heltable([8,9,72], n3(:,6004), t3x72(:,:,4648))
  call heltable([6,12,72], n3(:,6005), t3x72(:,:,4649))
  call heltable([6,12,72], n3(:,6006), t3x72(:,:,4650))
  call heltable([6,12,72], n3(:,6007), t3x72(:,:,4651))
  call heltable([6,12,72], n3(:,6008), t3x72(:,:,4652))
  call heltable([12,6,72], n3(:,6009), t3x72(:,:,4653))
  call heltable([12,6,72], n3(:,6010), t3x72(:,:,4654))
  call heltable([12,6,72], n3(:,6011), t3x72(:,:,4655))
  call heltable([12,6,72], n3(:,6012), t3x72(:,:,4656))
  call heltable([8,9,72], n3(:,6013), t3x72(:,:,4657))
  call heltable([8,9,72], n3(:,6014), t3x72(:,:,4658))
  call heltable([8,9,72], n3(:,6015), t3x72(:,:,4659))
  call heltable([8,9,72], n3(:,6016), t3x72(:,:,4660))
  call heltable([8,9,72], n3(:,6017), t3x72(:,:,4661))
  call heltable([8,9,72], n3(:,6018), t3x72(:,:,4662))
  call heltable([8,9,72], n3(:,6019), t3x72(:,:,4663))
  call heltable([8,9,72], n3(:,6020), t3x72(:,:,4664))
  call heltable([9,8,72], n3(:,6021), t3x72(:,:,4665))
  call heltable([9,8,72], n3(:,6022), t3x72(:,:,4666))
  call heltable([9,8,72], n3(:,6023), t3x72(:,:,4667))
  call heltable([9,8,72], n3(:,6024), t3x72(:,:,4668))
  call heltable([9,8,72], n3(:,6025), t3x72(:,:,4669))
  call heltable([9,8,72], n3(:,6026), t3x72(:,:,4670))
  call heltable([12,6,72], n3(:,6027), t3x72(:,:,4671))
  call heltable([12,6,72], n3(:,6028), t3x72(:,:,4672))
  call heltable([4,18,72], n3(:,6029), t3x72(:,:,4673))
  call heltable([4,18,72], n3(:,6030), t3x72(:,:,4674))
  call heltable([4,18,72], n3(:,6031), t3x72(:,:,4675))
  call heltable([4,18,72], n3(:,6032), t3x72(:,:,4676))
  call heltable([12,6,72], n3(:,6033), t3x72(:,:,4677))
  call heltable([12,6,72], n3(:,6034), t3x72(:,:,4678))
  call heltable([12,6,72], n3(:,6035), t3x72(:,:,4679))
  call heltable([12,6,72], n3(:,6036), t3x72(:,:,4680))
  call heltable([9,8,72], n3(:,6037), t3x72(:,:,4681))
  call heltable([9,8,72], n3(:,6038), t3x72(:,:,4682))
  call heltable([9,8,72], n3(:,6039), t3x72(:,:,4683))
  call heltable([9,8,72], n3(:,6040), t3x72(:,:,4684))
  call heltable([9,8,72], n3(:,6041), t3x72(:,:,4685))
  call heltable([9,8,72], n3(:,6042), t3x72(:,:,4686))
  call heltable([9,8,72], n3(:,6043), t3x72(:,:,4687))
  call heltable([9,8,72], n3(:,6044), t3x72(:,:,4688))
  call heltable([4,18,72], n3(:,6045), t3x72(:,:,4689))
  call heltable([4,18,72], n3(:,6046), t3x72(:,:,4690))
  call heltable([4,18,72], n3(:,6047), t3x72(:,:,4691))
  call heltable([4,18,72], n3(:,6048), t3x72(:,:,4692))
  call heltable([12,6,72], n3(:,6049), t3x72(:,:,4693))
  call heltable([12,6,72], n3(:,6050), t3x72(:,:,4694))
  call heltable([12,6,72], n3(:,6051), t3x72(:,:,4695))
  call heltable([12,6,72], n3(:,6052), t3x72(:,:,4696))
  call heltable([9,8,72], n3(:,6053), t3x72(:,:,4697))
  call heltable([9,8,72], n3(:,6054), t3x72(:,:,4698))
  call heltable([9,8,72], n3(:,6055), t3x72(:,:,4699))
  call heltable([9,8,72], n3(:,6056), t3x72(:,:,4700))
  call heltable([9,8,72], n3(:,6057), t3x72(:,:,4701))
  call heltable([9,8,72], n3(:,6058), t3x72(:,:,4702))
  call heltable([9,8,72], n3(:,6059), t3x72(:,:,4703))
  call heltable([9,8,72], n3(:,6060), t3x72(:,:,4704))
  call heltable([6,12,72], n3(:,6061), t3x72(:,:,4705))
  call heltable([6,12,72], n3(:,6062), t3x72(:,:,4706))
  call heltable([6,12,72], n3(:,6063), t3x72(:,:,4707))
  call heltable([6,12,72], n3(:,6064), t3x72(:,:,4708))
  call heltable([6,12,72], n3(:,6065), t3x72(:,:,4709))
  call heltable([6,12,72], n3(:,6066), t3x72(:,:,4710))
  call heltable([6,12,72], n3(:,6067), t3x72(:,:,4711))
  call heltable([6,12,72], n3(:,6068), t3x72(:,:,4712))
  call heltable([6,12,72], n3(:,6069), t3x72(:,:,4713))
  call heltable([6,12,72], n3(:,6070), t3x72(:,:,4714))
  call heltable([6,12,72], n3(:,6071), t3x72(:,:,4715))
  call heltable([6,12,72], n3(:,6072), t3x72(:,:,4716))
  call heltable([6,12,72], n3(:,6073), t3x72(:,:,4717))
  call heltable([6,12,72], n3(:,6074), t3x72(:,:,4718))
  call heltable([6,12,72], n3(:,6075), t3x72(:,:,4719))
  call heltable([6,12,72], n3(:,6076), t3x72(:,:,4720))
  call heltable([18,4,72], n3(:,6077), t3x72(:,:,4721))
  call heltable([6,12,72], n3(:,6078), t3x72(:,:,4722))
  call heltable([4,18,72], n3(:,6079), t3x72(:,:,4723))
  call heltable([6,12,72], n3(:,6080), t3x72(:,:,4724))
  call heltable([4,18,72], n3(:,6081), t3x72(:,:,4725))
  call heltable([4,18,72], n3(:,6082), t3x72(:,:,4726))
  call heltable([4,18,72], n3(:,6083), t3x72(:,:,4727))
  call heltable([4,18,72], n3(:,6084), t3x72(:,:,4728))
  call heltable([4,18,72], n3(:,6085), t3x72(:,:,4729))
  call heltable([4,18,72], n3(:,6086), t3x72(:,:,4730))
  call heltable([6,12,72], n3(:,6087), t3x72(:,:,4731))
  call heltable([6,12,72], n3(:,6088), t3x72(:,:,4732))
  call heltable([6,12,72], n3(:,6089), t3x72(:,:,4733))
  call heltable([6,12,72], n3(:,6090), t3x72(:,:,4734))
  call heltable([12,6,72], n3(:,6091), t3x72(:,:,4735))
  call heltable([12,6,72], n3(:,6092), t3x72(:,:,4736))
  call heltable([12,6,72], n3(:,6093), t3x72(:,:,4737))
  call heltable([12,6,72], n3(:,6094), t3x72(:,:,4738))
  call heltable([8,9,72], n3(:,6095), t3x72(:,:,4739))
  call heltable([8,9,72], n3(:,6096), t3x72(:,:,4740))
  call heltable([8,9,72], n3(:,6097), t3x72(:,:,4741))
  call heltable([8,9,72], n3(:,6098), t3x72(:,:,4742))
  call heltable([8,9,72], n3(:,6099), t3x72(:,:,4743))
  call heltable([8,9,72], n3(:,6100), t3x72(:,:,4744))
  call heltable([8,9,72], n3(:,6101), t3x72(:,:,4745))
  call heltable([8,9,72], n3(:,6102), t3x72(:,:,4746))
  call heltable([6,12,72], n3(:,6103), t3x72(:,:,4747))
  call heltable([6,12,72], n3(:,6104), t3x72(:,:,4748))
  call heltable([6,12,72], n3(:,6105), t3x72(:,:,4749))
  call heltable([6,12,72], n3(:,6106), t3x72(:,:,4750))
  call heltable([12,6,72], n3(:,6107), t3x72(:,:,4751))
  call heltable([12,6,72], n3(:,6108), t3x72(:,:,4752))
  call heltable([12,6,72], n3(:,6109), t3x72(:,:,4753))
  call heltable([12,6,72], n3(:,6110), t3x72(:,:,4754))
  call heltable([8,9,72], n3(:,6111), t3x72(:,:,4755))
  call heltable([8,9,72], n3(:,6112), t3x72(:,:,4756))
  call heltable([8,9,72], n3(:,6113), t3x72(:,:,4757))
  call heltable([8,9,72], n3(:,6114), t3x72(:,:,4758))
  call heltable([8,9,72], n3(:,6115), t3x72(:,:,4759))
  call heltable([8,9,72], n3(:,6116), t3x72(:,:,4760))
  call heltable([8,9,72], n3(:,6117), t3x72(:,:,4761))
  call heltable([8,9,72], n3(:,6118), t3x72(:,:,4762))
  call heltable([9,8,72], n3(:,6119), t3x72(:,:,4763))
  call heltable([9,8,72], n3(:,6120), t3x72(:,:,4764))
  call heltable([9,8,72], n3(:,6121), t3x72(:,:,4765))
  call heltable([9,8,72], n3(:,6122), t3x72(:,:,4766))
  call heltable([9,8,72], n3(:,6123), t3x72(:,:,4767))
  call heltable([9,8,72], n3(:,6124), t3x72(:,:,4768))
  call heltable([12,6,72], n3(:,6125), t3x72(:,:,4769))
  call heltable([12,6,72], n3(:,6126), t3x72(:,:,4770))
  call heltable([4,18,72], n3(:,6127), t3x72(:,:,4771))
  call heltable([4,18,72], n3(:,6128), t3x72(:,:,4772))
  call heltable([4,18,72], n3(:,6129), t3x72(:,:,4773))
  call heltable([4,18,72], n3(:,6130), t3x72(:,:,4774))
  call heltable([12,6,72], n3(:,6131), t3x72(:,:,4775))
  call heltable([12,6,72], n3(:,6132), t3x72(:,:,4776))
  call heltable([12,6,72], n3(:,6133), t3x72(:,:,4777))
  call heltable([12,6,72], n3(:,6134), t3x72(:,:,4778))
  call heltable([9,8,72], n3(:,6135), t3x72(:,:,4779))
  call heltable([9,8,72], n3(:,6136), t3x72(:,:,4780))
  call heltable([9,8,72], n3(:,6137), t3x72(:,:,4781))
  call heltable([9,8,72], n3(:,6138), t3x72(:,:,4782))
  call heltable([9,8,72], n3(:,6139), t3x72(:,:,4783))
  call heltable([9,8,72], n3(:,6140), t3x72(:,:,4784))
  call heltable([9,8,72], n3(:,6141), t3x72(:,:,4785))
  call heltable([9,8,72], n3(:,6142), t3x72(:,:,4786))
  call heltable([4,18,72], n3(:,6143), t3x72(:,:,4787))
  call heltable([4,18,72], n3(:,6144), t3x72(:,:,4788))
  call heltable([4,18,72], n3(:,6145), t3x72(:,:,4789))
  call heltable([4,18,72], n3(:,6146), t3x72(:,:,4790))
  call heltable([12,6,72], n3(:,6147), t3x72(:,:,4791))
  call heltable([12,6,72], n3(:,6148), t3x72(:,:,4792))
  call heltable([12,6,72], n3(:,6149), t3x72(:,:,4793))
  call heltable([12,6,72], n3(:,6150), t3x72(:,:,4794))
  call heltable([9,8,72], n3(:,6151), t3x72(:,:,4795))
  call heltable([9,8,72], n3(:,6152), t3x72(:,:,4796))
  call heltable([9,8,72], n3(:,6153), t3x72(:,:,4797))
  call heltable([9,8,72], n3(:,6154), t3x72(:,:,4798))
  call heltable([9,8,72], n3(:,6155), t3x72(:,:,4799))
  call heltable([9,8,72], n3(:,6156), t3x72(:,:,4800))
  call heltable([9,8,72], n3(:,6157), t3x72(:,:,4801))
  call heltable([9,8,72], n3(:,6158), t3x72(:,:,4802))
  call heltable([6,12,72], n3(:,6159), t3x72(:,:,4803))
  call heltable([6,12,72], n3(:,6160), t3x72(:,:,4804))
  call heltable([6,12,72], n3(:,6161), t3x72(:,:,4805))
  call heltable([6,12,72], n3(:,6162), t3x72(:,:,4806))
  call heltable([12,6,72], n3(:,6163), t3x72(:,:,4807))
  call heltable([12,6,72], n3(:,6164), t3x72(:,:,4808))
  call heltable([12,6,72], n3(:,6165), t3x72(:,:,4809))
  call heltable([12,6,72], n3(:,6166), t3x72(:,:,4810))
  call heltable([6,12,72], n3(:,6167), t3x72(:,:,4811))
  call heltable([6,12,72], n3(:,6168), t3x72(:,:,4812))
  call heltable([6,12,72], n3(:,6169), t3x72(:,:,4813))
  call heltable([6,12,72], n3(:,6170), t3x72(:,:,4814))
  call heltable([12,6,72], n3(:,6171), t3x72(:,:,4815))
  call heltable([12,6,72], n3(:,6172), t3x72(:,:,4816))
  call heltable([12,6,72], n3(:,6173), t3x72(:,:,4817))
  call heltable([12,6,72], n3(:,6174), t3x72(:,:,4818))
  call heltable([18,4,72], n3(:,6175), t3x72(:,:,4819))
  call heltable([6,12,72], n3(:,6176), t3x72(:,:,4820))
  call heltable([4,18,72], n3(:,6177), t3x72(:,:,4821))
  call heltable([6,12,72], n3(:,6178), t3x72(:,:,4822))
  call heltable([4,18,72], n3(:,6179), t3x72(:,:,4823))
  call heltable([4,18,72], n3(:,6180), t3x72(:,:,4824))
  call heltable([4,18,72], n3(:,6181), t3x72(:,:,4825))
  call heltable([4,18,72], n3(:,6182), t3x72(:,:,4826))
  call heltable([4,18,72], n3(:,6183), t3x72(:,:,4827))
  call heltable([4,18,72], n3(:,6184), t3x72(:,:,4828))
  call heltable([4,18,72], n3(:,6185), t3x72(:,:,4829))
  call heltable([4,18,72], n3(:,6186), t3x72(:,:,4830))
  call heltable([4,18,72], n3(:,6187), t3x72(:,:,4831))
  call heltable([4,18,72], n3(:,6188), t3x72(:,:,4832))
  call heltable([6,12,72], n3(:,6189), t3x72(:,:,4833))
  call heltable([6,12,72], n3(:,6190), t3x72(:,:,4834))
  call heltable([6,12,72], n3(:,6191), t3x72(:,:,4835))
  call heltable([6,12,72], n3(:,6192), t3x72(:,:,4836))
  call heltable([4,18,72], n3(:,6193), t3x72(:,:,4837))
  call heltable([6,12,72], n3(:,6194), t3x72(:,:,4838))
  call heltable([4,18,72], n3(:,6195), t3x72(:,:,4839))
  call heltable([4,18,72], n3(:,6196), t3x72(:,:,4840))
  call heltable([4,18,72], n3(:,6197), t3x72(:,:,4841))
  call heltable([4,18,72], n3(:,6198), t3x72(:,:,4842))
  call heltable([9,8,72], n3(:,6199), t3x72(:,:,4843))
  call heltable([9,8,72], n3(:,6200), t3x72(:,:,4844))
  call heltable([6,12,72], n3(:,6201), t3x72(:,:,4845))
  call heltable([6,12,72], n3(:,6202), t3x72(:,:,4846))
  call heltable([6,12,72], n3(:,6203), t3x72(:,:,4847))
  call heltable([6,12,72], n3(:,6204), t3x72(:,:,4848))
  call heltable([4,18,72], n3(:,6205), t3x72(:,:,4849))
  call heltable([4,18,72], n3(:,6206), t3x72(:,:,4850))
  call heltable([12,6,72], n3(:,6207), t3x72(:,:,4851))
  call heltable([6,12,72], n3(:,6208), t3x72(:,:,4852))
  call heltable([6,12,72], n3(:,6209), t3x72(:,:,4853))
  call heltable([6,12,72], n3(:,6210), t3x72(:,:,4854))
  call heltable([6,12,72], n3(:,6211), t3x72(:,:,4855))
  call heltable([6,12,72], n3(:,6212), t3x72(:,:,4856))
  call heltable([9,8,72], n3(:,6213), t3x72(:,:,4857))
  call heltable([9,8,72], n3(:,6214), t3x72(:,:,4858))
  call heltable([6,12,72], n3(:,6215), t3x72(:,:,4859))
  call heltable([6,12,72], n3(:,6216), t3x72(:,:,4860))
  call heltable([6,12,72], n3(:,6217), t3x72(:,:,4861))
  call heltable([6,12,72], n3(:,6218), t3x72(:,:,4862))
  call heltable([4,18,72], n3(:,6219), t3x72(:,:,4863))
  call heltable([4,18,72], n3(:,6220), t3x72(:,:,4864))
  call heltable([12,6,72], n3(:,6221), t3x72(:,:,4865))
  call heltable([4,18,72], n3(:,6222), t3x72(:,:,4866))
  call heltable([4,18,72], n3(:,6223), t3x72(:,:,4867))
  call heltable([6,12,72], n3(:,6224), t3x72(:,:,4868))
  call heltable([4,18,72], n3(:,6225), t3x72(:,:,4869))
  call heltable([4,18,72], n3(:,6226), t3x72(:,:,4870))
  call heltable([12,6,72], n3(:,6227), t3x72(:,:,4871))
  call heltable([6,12,72], n3(:,6228), t3x72(:,:,4872))
  call heltable([4,18,72], n3(:,6229), t3x72(:,:,4873))
  call heltable([4,18,72], n3(:,6230), t3x72(:,:,4874))
  call heltable([12,6,72], n3(:,6231), t3x72(:,:,4875))
  call heltable([4,18,72], n3(:,6232), t3x72(:,:,4876))
  call heltable([4,18,72], n3(:,6233), t3x72(:,:,4877))
  call heltable([4,18,72], n3(:,6234), t3x72(:,:,4878))
  call heltable([4,18,72], n3(:,6235), t3x72(:,:,4879))
  call heltable([4,18,72], n3(:,6236), t3x72(:,:,4880))
  call heltable([6,12,72], n3(:,6237), t3x72(:,:,4881))
  call heltable([6,12,72], n3(:,6238), t3x72(:,:,4882))
  call heltable([6,12,72], n3(:,6239), t3x72(:,:,4883))
  call heltable([6,12,72], n3(:,6240), t3x72(:,:,4884))
  call heltable([4,18,72], n3(:,6241), t3x72(:,:,4885))
  call heltable([6,12,72], n3(:,6242), t3x72(:,:,4886))
  call heltable([4,18,72], n3(:,6243), t3x72(:,:,4887))
  call heltable([4,18,72], n3(:,6244), t3x72(:,:,4888))
  call heltable([4,18,72], n3(:,6245), t3x72(:,:,4889))
  call heltable([4,18,72], n3(:,6246), t3x72(:,:,4890))
  call heltable([9,8,72], n3(:,6247), t3x72(:,:,4891))
  call heltable([9,8,72], n3(:,6248), t3x72(:,:,4892))
  call heltable([6,12,72], n3(:,6249), t3x72(:,:,4893))
  call heltable([6,12,72], n3(:,6250), t3x72(:,:,4894))
  call heltable([6,12,72], n3(:,6251), t3x72(:,:,4895))
  call heltable([6,12,72], n3(:,6252), t3x72(:,:,4896))
  call heltable([4,18,72], n3(:,6253), t3x72(:,:,4897))
  call heltable([4,18,72], n3(:,6254), t3x72(:,:,4898))
  call heltable([12,6,72], n3(:,6255), t3x72(:,:,4899))
  call heltable([6,12,72], n3(:,6256), t3x72(:,:,4900))
  call heltable([6,12,72], n3(:,6257), t3x72(:,:,4901))
  call heltable([6,12,72], n3(:,6258), t3x72(:,:,4902))
  call heltable([6,12,72], n3(:,6259), t3x72(:,:,4903))
  call heltable([6,12,72], n3(:,6260), t3x72(:,:,4904))
  call heltable([9,8,72], n3(:,6261), t3x72(:,:,4905))
  call heltable([9,8,72], n3(:,6262), t3x72(:,:,4906))
  call heltable([6,12,72], n3(:,6263), t3x72(:,:,4907))
  call heltable([6,12,72], n3(:,6264), t3x72(:,:,4908))
  call heltable([6,12,72], n3(:,6265), t3x72(:,:,4909))
  call heltable([6,12,72], n3(:,6266), t3x72(:,:,4910))
  call heltable([4,18,72], n3(:,6267), t3x72(:,:,4911))
  call heltable([4,18,72], n3(:,6268), t3x72(:,:,4912))
  call heltable([12,6,72], n3(:,6269), t3x72(:,:,4913))
  call heltable([4,18,72], n3(:,6270), t3x72(:,:,4914))
  call heltable([4,18,72], n3(:,6271), t3x72(:,:,4915))
  call heltable([6,12,72], n3(:,6272), t3x72(:,:,4916))
  call heltable([4,18,72], n3(:,6273), t3x72(:,:,4917))
  call heltable([4,18,72], n3(:,6274), t3x72(:,:,4918))
  call heltable([12,6,72], n3(:,6275), t3x72(:,:,4919))
  call heltable([6,12,72], n3(:,6276), t3x72(:,:,4920))
  call heltable([4,18,72], n3(:,6277), t3x72(:,:,4921))
  call heltable([4,18,72], n3(:,6278), t3x72(:,:,4922))
  call heltable([12,6,72], n3(:,6279), t3x72(:,:,4923))
  call heltable([4,18,72], n3(:,6280), t3x72(:,:,4924))
  call heltable([9,8,72], n3(:,6281), t3x72(:,:,4925))
  call heltable([9,8,72], n3(:,6282), t3x72(:,:,4926))
  call heltable([9,8,72], n3(:,6283), t3x72(:,:,4927))
  call heltable([9,8,72], n3(:,6284), t3x72(:,:,4928))
  call heltable([9,8,72], n3(:,6285), t3x72(:,:,4929))
  call heltable([9,8,72], n3(:,6286), t3x72(:,:,4930))
  call heltable([12,6,72], n3(:,6287), t3x72(:,:,4931))
  call heltable([12,6,72], n3(:,6288), t3x72(:,:,4932))
  call heltable([4,18,72], n3(:,6289), t3x72(:,:,4933))
  call heltable([12,6,72], n3(:,6290), t3x72(:,:,4934))
  call heltable([4,18,72], n3(:,6291), t3x72(:,:,4935))
  call heltable([12,6,72], n3(:,6292), t3x72(:,:,4936))
  call heltable([4,18,72], n3(:,6293), t3x72(:,:,4937))
  call heltable([4,18,72], n3(:,6294), t3x72(:,:,4938))
  call heltable([4,18,72], n3(:,6295), t3x72(:,:,4939))
  call heltable([4,18,72], n3(:,6296), t3x72(:,:,4940))
  call heltable([4,18,72], n3(:,6297), t3x72(:,:,4941))
  call heltable([4,18,72], n3(:,6298), t3x72(:,:,4942))
  call heltable([9,8,72], n3(:,6299), t3x72(:,:,4943))
  call heltable([9,8,72], n3(:,6300), t3x72(:,:,4944))
  call heltable([9,8,72], n3(:,6301), t3x72(:,:,4945))
  call heltable([9,8,72], n3(:,6302), t3x72(:,:,4946))
  call heltable([9,8,72], n3(:,6303), t3x72(:,:,4947))
  call heltable([9,8,72], n3(:,6304), t3x72(:,:,4948))
  call heltable([12,6,72], n3(:,6305), t3x72(:,:,4949))
  call heltable([12,6,72], n3(:,6306), t3x72(:,:,4950))
  call heltable([4,18,72], n3(:,6307), t3x72(:,:,4951))
  call heltable([12,6,72], n3(:,6308), t3x72(:,:,4952))
  call heltable([4,18,72], n3(:,6309), t3x72(:,:,4953))
  call heltable([12,6,72], n3(:,6310), t3x72(:,:,4954))
  call heltable([4,18,72], n3(:,6311), t3x72(:,:,4955))
  call heltable([4,18,72], n3(:,6312), t3x72(:,:,4956))
  call heltable([4,18,72], n3(:,6313), t3x72(:,:,4957))
  call heltable([4,18,72], n3(:,6314), t3x72(:,:,4958))
  call heltable([4,18,72], n3(:,6315), t3x72(:,:,4959))
  call heltable([4,18,72], n3(:,6316), t3x72(:,:,4960))
  call heltable([4,18,72], n3(:,6317), t3x72(:,:,4961))
  call heltable([4,18,72], n3(:,6318), t3x72(:,:,4962))
  call heltable([4,18,72], n3(:,6319), t3x72(:,:,4963))
  call heltable([4,18,72], n3(:,6320), t3x72(:,:,4964))
  call heltable([12,6,72], n3(:,6321), t3x72(:,:,4965))
  call heltable([12,6,72], n3(:,6322), t3x72(:,:,4966))
  call heltable([12,6,72], n3(:,6323), t3x72(:,:,4967))
  call heltable([12,6,72], n3(:,6324), t3x72(:,:,4968))
  call heltable([4,18,72], n3(:,6325), t3x72(:,:,4969))
  call heltable([12,6,72], n3(:,6326), t3x72(:,:,4970))
  call heltable([4,18,72], n3(:,6327), t3x72(:,:,4971))
  call heltable([4,18,72], n3(:,6328), t3x72(:,:,4972))
  call heltable([4,18,72], n3(:,6329), t3x72(:,:,4973))
  call heltable([4,18,72], n3(:,6330), t3x72(:,:,4974))
  call heltable([9,8,72], n3(:,6331), t3x72(:,:,4975))
  call heltable([9,8,72], n3(:,6332), t3x72(:,:,4976))
  call heltable([12,6,72], n3(:,6333), t3x72(:,:,4977))
  call heltable([12,6,72], n3(:,6334), t3x72(:,:,4978))
  call heltable([12,6,72], n3(:,6335), t3x72(:,:,4979))
  call heltable([12,6,72], n3(:,6336), t3x72(:,:,4980))
  call heltable([4,18,72], n3(:,6337), t3x72(:,:,4981))
  call heltable([4,18,72], n3(:,6338), t3x72(:,:,4982))
  call heltable([6,12,72], n3(:,6339), t3x72(:,:,4983))
  call heltable([12,6,72], n3(:,6340), t3x72(:,:,4984))
  call heltable([12,6,72], n3(:,6341), t3x72(:,:,4985))
  call heltable([12,6,72], n3(:,6342), t3x72(:,:,4986))
  call heltable([12,6,72], n3(:,6343), t3x72(:,:,4987))
  call heltable([12,6,72], n3(:,6344), t3x72(:,:,4988))
  call heltable([9,8,72], n3(:,6345), t3x72(:,:,4989))
  call heltable([9,8,72], n3(:,6346), t3x72(:,:,4990))
  call heltable([12,6,72], n3(:,6347), t3x72(:,:,4991))
  call heltable([12,6,72], n3(:,6348), t3x72(:,:,4992))
  call heltable([12,6,72], n3(:,6349), t3x72(:,:,4993))
  call heltable([12,6,72], n3(:,6350), t3x72(:,:,4994))
  call heltable([4,18,72], n3(:,6351), t3x72(:,:,4995))
  call heltable([4,18,72], n3(:,6352), t3x72(:,:,4996))
  call heltable([6,12,72], n3(:,6353), t3x72(:,:,4997))
  call heltable([4,18,72], n3(:,6354), t3x72(:,:,4998))
  call heltable([4,18,72], n3(:,6355), t3x72(:,:,4999))
  call heltable([12,6,72], n3(:,6356), t3x72(:,:,5000))
  call heltable([4,18,72], n3(:,6357), t3x72(:,:,5001))
  call heltable([4,18,72], n3(:,6358), t3x72(:,:,5002))
  call heltable([6,12,72], n3(:,6359), t3x72(:,:,5003))
  call heltable([12,6,72], n3(:,6360), t3x72(:,:,5004))
  call heltable([4,18,72], n3(:,6361), t3x72(:,:,5005))
  call heltable([4,18,72], n3(:,6362), t3x72(:,:,5006))
  call heltable([6,12,72], n3(:,6363), t3x72(:,:,5007))
  call heltable([4,18,72], n3(:,6364), t3x72(:,:,5008))
  call heltable([4,18,72], n3(:,6365), t3x72(:,:,5009))
  call heltable([4,18,72], n3(:,6366), t3x72(:,:,5010))
  call heltable([4,18,72], n3(:,6367), t3x72(:,:,5011))
  call heltable([4,18,72], n3(:,6368), t3x72(:,:,5012))
  call heltable([12,6,72], n3(:,6369), t3x72(:,:,5013))
  call heltable([12,6,72], n3(:,6370), t3x72(:,:,5014))
  call heltable([12,6,72], n3(:,6371), t3x72(:,:,5015))
  call heltable([12,6,72], n3(:,6372), t3x72(:,:,5016))
  call heltable([4,18,72], n3(:,6373), t3x72(:,:,5017))
  call heltable([12,6,72], n3(:,6374), t3x72(:,:,5018))
  call heltable([4,18,72], n3(:,6375), t3x72(:,:,5019))
  call heltable([4,18,72], n3(:,6376), t3x72(:,:,5020))
  call heltable([4,18,72], n3(:,6377), t3x72(:,:,5021))
  call heltable([4,18,72], n3(:,6378), t3x72(:,:,5022))
  call heltable([9,8,72], n3(:,6379), t3x72(:,:,5023))
  call heltable([9,8,72], n3(:,6380), t3x72(:,:,5024))
  call heltable([12,6,72], n3(:,6381), t3x72(:,:,5025))
  call heltable([12,6,72], n3(:,6382), t3x72(:,:,5026))
  call heltable([12,6,72], n3(:,6383), t3x72(:,:,5027))
  call heltable([12,6,72], n3(:,6384), t3x72(:,:,5028))
  call heltable([4,18,72], n3(:,6385), t3x72(:,:,5029))
  call heltable([4,18,72], n3(:,6386), t3x72(:,:,5030))
  call heltable([6,12,72], n3(:,6387), t3x72(:,:,5031))
  call heltable([12,6,72], n3(:,6388), t3x72(:,:,5032))
  call heltable([12,6,72], n3(:,6389), t3x72(:,:,5033))
  call heltable([12,6,72], n3(:,6390), t3x72(:,:,5034))
  call heltable([12,6,72], n3(:,6391), t3x72(:,:,5035))
  call heltable([12,6,72], n3(:,6392), t3x72(:,:,5036))
  call heltable([9,8,72], n3(:,6393), t3x72(:,:,5037))
  call heltable([9,8,72], n3(:,6394), t3x72(:,:,5038))
  call heltable([12,6,72], n3(:,6395), t3x72(:,:,5039))
  call heltable([12,6,72], n3(:,6396), t3x72(:,:,5040))
  call heltable([12,6,72], n3(:,6397), t3x72(:,:,5041))
  call heltable([12,6,72], n3(:,6398), t3x72(:,:,5042))
  call heltable([4,18,72], n3(:,6399), t3x72(:,:,5043))
  call heltable([4,18,72], n3(:,6400), t3x72(:,:,5044))
  call heltable([6,12,72], n3(:,6401), t3x72(:,:,5045))
  call heltable([4,18,72], n3(:,6402), t3x72(:,:,5046))
  call heltable([4,18,72], n3(:,6403), t3x72(:,:,5047))
  call heltable([12,6,72], n3(:,6404), t3x72(:,:,5048))
  call heltable([4,18,72], n3(:,6405), t3x72(:,:,5049))
  call heltable([4,18,72], n3(:,6406), t3x72(:,:,5050))
  call heltable([6,12,72], n3(:,6407), t3x72(:,:,5051))
  call heltable([12,6,72], n3(:,6408), t3x72(:,:,5052))
  call heltable([4,18,72], n3(:,6409), t3x72(:,:,5053))
  call heltable([4,18,72], n3(:,6410), t3x72(:,:,5054))
  call heltable([6,12,72], n3(:,6411), t3x72(:,:,5055))
  call heltable([4,18,72], n3(:,6412), t3x72(:,:,5056))
  call heltable([9,8,72], n3(:,6413), t3x72(:,:,5057))
  call heltable([9,8,72], n3(:,6414), t3x72(:,:,5058))
  call heltable([9,8,72], n3(:,6415), t3x72(:,:,5059))
  call heltable([9,8,72], n3(:,6416), t3x72(:,:,5060))
  call heltable([9,8,72], n3(:,6417), t3x72(:,:,5061))
  call heltable([9,8,72], n3(:,6418), t3x72(:,:,5062))
  call heltable([12,6,72], n3(:,6419), t3x72(:,:,5063))
  call heltable([12,6,72], n3(:,6420), t3x72(:,:,5064))
  call heltable([4,18,72], n3(:,6421), t3x72(:,:,5065))
  call heltable([12,6,72], n3(:,6422), t3x72(:,:,5066))
  call heltable([4,18,72], n3(:,6423), t3x72(:,:,5067))
  call heltable([12,6,72], n3(:,6424), t3x72(:,:,5068))
  call heltable([4,18,72], n3(:,6425), t3x72(:,:,5069))
  call heltable([4,18,72], n3(:,6426), t3x72(:,:,5070))
  call heltable([4,18,72], n3(:,6427), t3x72(:,:,5071))
  call heltable([4,18,72], n3(:,6428), t3x72(:,:,5072))
  call heltable([4,18,72], n3(:,6429), t3x72(:,:,5073))
  call heltable([4,18,72], n3(:,6430), t3x72(:,:,5074))
  call heltable([9,8,72], n3(:,6431), t3x72(:,:,5075))
  call heltable([9,8,72], n3(:,6432), t3x72(:,:,5076))
  call heltable([9,8,72], n3(:,6433), t3x72(:,:,5077))
  call heltable([9,8,72], n3(:,6434), t3x72(:,:,5078))
  call heltable([9,8,72], n3(:,6435), t3x72(:,:,5079))
  call heltable([9,8,72], n3(:,6436), t3x72(:,:,5080))
  call heltable([12,6,72], n3(:,6437), t3x72(:,:,5081))
  call heltable([12,6,72], n3(:,6438), t3x72(:,:,5082))
  call heltable([4,18,72], n3(:,6439), t3x72(:,:,5083))
  call heltable([12,6,72], n3(:,6440), t3x72(:,:,5084))
  call heltable([4,18,72], n3(:,6441), t3x72(:,:,5085))
  call heltable([12,6,72], n3(:,6442), t3x72(:,:,5086))
  call heltable([4,18,72], n3(:,6443), t3x72(:,:,5087))
  call heltable([4,18,72], n3(:,6444), t3x72(:,:,5088))
  call heltable([4,18,72], n3(:,6445), t3x72(:,:,5089))
  call heltable([4,18,72], n3(:,6446), t3x72(:,:,5090))
  call heltable([4,18,72], n3(:,6447), t3x72(:,:,5091))
  call heltable([4,18,72], n3(:,6448), t3x72(:,:,5092))
  call heltable([4,18,72], n3(:,6449), t3x72(:,:,5093))
  call heltable([4,18,72], n3(:,6450), t3x72(:,:,5094))
  call heltable([4,18,72], n3(:,6451), t3x72(:,:,5095))
  call heltable([4,18,72], n3(:,6452), t3x72(:,:,5096))
  call heltable([12,6,72], n3(:,6453), t3x72(:,:,5097))
  call heltable([12,6,72], n3(:,6454), t3x72(:,:,5098))
  call heltable([12,6,72], n3(:,6455), t3x72(:,:,5099))
  call heltable([12,6,72], n3(:,6456), t3x72(:,:,5100))
  call heltable([4,18,72], n3(:,6457), t3x72(:,:,5101))
  call heltable([12,6,72], n3(:,6458), t3x72(:,:,5102))
  call heltable([4,18,72], n3(:,6459), t3x72(:,:,5103))
  call heltable([4,18,72], n3(:,6460), t3x72(:,:,5104))
  call heltable([4,18,72], n3(:,6461), t3x72(:,:,5105))
  call heltable([4,18,72], n3(:,6462), t3x72(:,:,5106))
  call heltable([9,8,72], n3(:,6463), t3x72(:,:,5107))
  call heltable([9,8,72], n3(:,6464), t3x72(:,:,5108))
  call heltable([12,6,72], n3(:,6465), t3x72(:,:,5109))
  call heltable([12,6,72], n3(:,6466), t3x72(:,:,5110))
  call heltable([12,6,72], n3(:,6467), t3x72(:,:,5111))
  call heltable([12,6,72], n3(:,6468), t3x72(:,:,5112))
  call heltable([4,18,72], n3(:,6469), t3x72(:,:,5113))
  call heltable([4,18,72], n3(:,6470), t3x72(:,:,5114))
  call heltable([6,12,72], n3(:,6471), t3x72(:,:,5115))
  call heltable([12,6,72], n3(:,6472), t3x72(:,:,5116))
  call heltable([12,6,72], n3(:,6473), t3x72(:,:,5117))
  call heltable([12,6,72], n3(:,6474), t3x72(:,:,5118))
  call heltable([12,6,72], n3(:,6475), t3x72(:,:,5119))
  call heltable([12,6,72], n3(:,6476), t3x72(:,:,5120))
  call heltable([9,8,72], n3(:,6477), t3x72(:,:,5121))
  call heltable([9,8,72], n3(:,6478), t3x72(:,:,5122))
  call heltable([12,6,72], n3(:,6479), t3x72(:,:,5123))
  call heltable([12,6,72], n3(:,6480), t3x72(:,:,5124))
  call heltable([12,6,72], n3(:,6481), t3x72(:,:,5125))
  call heltable([12,6,72], n3(:,6482), t3x72(:,:,5126))
  call heltable([4,18,72], n3(:,6483), t3x72(:,:,5127))
  call heltable([4,18,72], n3(:,6484), t3x72(:,:,5128))
  call heltable([6,12,72], n3(:,6485), t3x72(:,:,5129))
  call heltable([4,18,72], n3(:,6486), t3x72(:,:,5130))
  call heltable([4,18,72], n3(:,6487), t3x72(:,:,5131))
  call heltable([12,6,72], n3(:,6488), t3x72(:,:,5132))
  call heltable([4,18,72], n3(:,6489), t3x72(:,:,5133))
  call heltable([4,18,72], n3(:,6490), t3x72(:,:,5134))
  call heltable([6,12,72], n3(:,6491), t3x72(:,:,5135))
  call heltable([12,6,72], n3(:,6492), t3x72(:,:,5136))
  call heltable([4,18,72], n3(:,6493), t3x72(:,:,5137))
  call heltable([4,18,72], n3(:,6494), t3x72(:,:,5138))
  call heltable([6,12,72], n3(:,6495), t3x72(:,:,5139))
  call heltable([4,18,72], n3(:,6496), t3x72(:,:,5140))
  call heltable([4,18,72], n3(:,6497), t3x72(:,:,5141))
  call heltable([4,18,72], n3(:,6498), t3x72(:,:,5142))
  call heltable([4,18,72], n3(:,6499), t3x72(:,:,5143))
  call heltable([4,18,72], n3(:,6500), t3x72(:,:,5144))
  call heltable([12,6,72], n3(:,6501), t3x72(:,:,5145))
  call heltable([12,6,72], n3(:,6502), t3x72(:,:,5146))
  call heltable([12,6,72], n3(:,6503), t3x72(:,:,5147))
  call heltable([12,6,72], n3(:,6504), t3x72(:,:,5148))
  call heltable([4,18,72], n3(:,6505), t3x72(:,:,5149))
  call heltable([12,6,72], n3(:,6506), t3x72(:,:,5150))
  call heltable([4,18,72], n3(:,6507), t3x72(:,:,5151))
  call heltable([4,18,72], n3(:,6508), t3x72(:,:,5152))
  call heltable([4,18,72], n3(:,6509), t3x72(:,:,5153))
  call heltable([4,18,72], n3(:,6510), t3x72(:,:,5154))
  call heltable([9,8,72], n3(:,6511), t3x72(:,:,5155))
  call heltable([9,8,72], n3(:,6512), t3x72(:,:,5156))
  call heltable([12,6,72], n3(:,6513), t3x72(:,:,5157))
  call heltable([12,6,72], n3(:,6514), t3x72(:,:,5158))
  call heltable([12,6,72], n3(:,6515), t3x72(:,:,5159))
  call heltable([12,6,72], n3(:,6516), t3x72(:,:,5160))
  call heltable([4,18,72], n3(:,6517), t3x72(:,:,5161))
  call heltable([4,18,72], n3(:,6518), t3x72(:,:,5162))
  call heltable([6,12,72], n3(:,6519), t3x72(:,:,5163))
  call heltable([12,6,72], n3(:,6520), t3x72(:,:,5164))
  call heltable([12,6,72], n3(:,6521), t3x72(:,:,5165))
  call heltable([12,6,72], n3(:,6522), t3x72(:,:,5166))
  call heltable([12,6,72], n3(:,6523), t3x72(:,:,5167))
  call heltable([12,6,72], n3(:,6524), t3x72(:,:,5168))
  call heltable([9,8,72], n3(:,6525), t3x72(:,:,5169))
  call heltable([9,8,72], n3(:,6526), t3x72(:,:,5170))
  call heltable([12,6,72], n3(:,6527), t3x72(:,:,5171))
  call heltable([12,6,72], n3(:,6528), t3x72(:,:,5172))
  call heltable([12,6,72], n3(:,6529), t3x72(:,:,5173))
  call heltable([12,6,72], n3(:,6530), t3x72(:,:,5174))
  call heltable([4,18,72], n3(:,6531), t3x72(:,:,5175))
  call heltable([4,18,72], n3(:,6532), t3x72(:,:,5176))
  call heltable([6,12,72], n3(:,6533), t3x72(:,:,5177))
  call heltable([4,18,72], n3(:,6534), t3x72(:,:,5178))
  call heltable([4,18,72], n3(:,6535), t3x72(:,:,5179))
  call heltable([12,6,72], n3(:,6536), t3x72(:,:,5180))
  call heltable([4,18,72], n3(:,6537), t3x72(:,:,5181))
  call heltable([4,18,72], n3(:,6538), t3x72(:,:,5182))
  call heltable([6,12,72], n3(:,6539), t3x72(:,:,5183))
  call heltable([12,6,72], n3(:,6540), t3x72(:,:,5184))
  call heltable([4,18,72], n3(:,6541), t3x72(:,:,5185))
  call heltable([4,18,72], n3(:,6542), t3x72(:,:,5186))
  call heltable([6,12,72], n3(:,6543), t3x72(:,:,5187))
  call heltable([4,18,72], n3(:,6544), t3x72(:,:,5188))
  call heltable([18,4,72], n3(:,6545), t3x72(:,:,5189))
  call heltable([18,4,72], n3(:,6546), t3x72(:,:,5190))
  call heltable([6,12,72], n3(:,6547), t3x72(:,:,5191))
  call heltable([4,18,72], n3(:,6548), t3x72(:,:,5192))
  call heltable([6,12,72], n3(:,6549), t3x72(:,:,5193))
  call heltable([4,18,72], n3(:,6550), t3x72(:,:,5194))
  call heltable([4,18,72], n3(:,6551), t3x72(:,:,5195))
  call heltable([4,18,72], n3(:,6552), t3x72(:,:,5196))
  call heltable([4,18,72], n3(:,6553), t3x72(:,:,5197))
  call heltable([18,4,72], n3(:,6554), t3x72(:,:,5198))
  call heltable([12,6,72], n3(:,6555), t3x72(:,:,5199))
  call heltable([18,4,72], n3(:,6556), t3x72(:,:,5200))
  call heltable([6,12,72], n3(:,6557), t3x72(:,:,5201))
  call heltable([18,4,72], n3(:,6558), t3x72(:,:,5202))
  call heltable([4,18,72], n3(:,6559), t3x72(:,:,5203))
  call heltable([4,18,72], n3(:,6560), t3x72(:,:,5204))
  call heltable([18,4,72], n3(:,6561), t3x72(:,:,5205))
  call heltable([4,18,72], n3(:,6562), t3x72(:,:,5206))
  call heltable([6,12,72], n3(:,6563), t3x72(:,:,5207))
  call heltable([4,18,72], n3(:,6564), t3x72(:,:,5208))
  call heltable([12,6,72], n3(:,6565), t3x72(:,:,5209))
  call heltable([4,18,72], n3(:,6566), t3x72(:,:,5210))
  call heltable([18,4,72], n3(:,6567), t3x72(:,:,5211))
  call heltable([18,4,72], n3(:,6568), t3x72(:,:,5212))
  call heltable([18,4,72], n3(:,6569), t3x72(:,:,5213))
  call heltable([18,4,72], n3(:,6570), t3x72(:,:,5214))
  call heltable([6,12,72], n3(:,6571), t3x72(:,:,5215))
  call heltable([4,18,72], n3(:,6572), t3x72(:,:,5216))
  call heltable([6,12,72], n3(:,6573), t3x72(:,:,5217))
  call heltable([4,18,72], n3(:,6574), t3x72(:,:,5218))
  call heltable([4,18,72], n3(:,6575), t3x72(:,:,5219))
  call heltable([4,18,72], n3(:,6576), t3x72(:,:,5220))
  call heltable([8,9,72], n3(:,6577), t3x72(:,:,5221))
  call heltable([8,9,72], n3(:,6578), t3x72(:,:,5222))
  call heltable([8,9,72], n3(:,6579), t3x72(:,:,5223))
  call heltable([8,9,72], n3(:,6580), t3x72(:,:,5224))
  call heltable([9,8,72], n3(:,6581), t3x72(:,:,5225))
  call heltable([9,8,72], n3(:,6582), t3x72(:,:,5226))
  call heltable([8,9,72], n3(:,6583), t3x72(:,:,5227))
  call heltable([8,9,72], n3(:,6584), t3x72(:,:,5228))
  call heltable([9,8,72], n3(:,6585), t3x72(:,:,5229))
  call heltable([9,8,72], n3(:,6586), t3x72(:,:,5230))
  call heltable([9,8,72], n3(:,6587), t3x72(:,:,5231))
  call heltable([9,8,72], n3(:,6588), t3x72(:,:,5232))
  call heltable([18,4,72], n3(:,6589), t3x72(:,:,5233))
  call heltable([12,6,72], n3(:,6590), t3x72(:,:,5234))
  call heltable([9,8,72], n3(:,6591), t3x72(:,:,5235))
  call heltable([9,8,72], n3(:,6592), t3x72(:,:,5236))
  call heltable([12,6,72], n3(:,6593), t3x72(:,:,5237))
  call heltable([12,6,72], n3(:,6594), t3x72(:,:,5238))
  call heltable([6,12,72], n3(:,6595), t3x72(:,:,5239))
  call heltable([4,18,72], n3(:,6596), t3x72(:,:,5240))
  call heltable([4,18,72], n3(:,6597), t3x72(:,:,5241))
  call heltable([4,18,72], n3(:,6598), t3x72(:,:,5242))
  call heltable([4,18,72], n3(:,6599), t3x72(:,:,5243))
  call heltable([12,6,72], n3(:,6600), t3x72(:,:,5244))
  call heltable([8,9,72], n3(:,6601), t3x72(:,:,5245))
  call heltable([8,9,72], n3(:,6602), t3x72(:,:,5246))
  call heltable([12,6,72], n3(:,6603), t3x72(:,:,5247))
  call heltable([12,6,72], n3(:,6604), t3x72(:,:,5248))
  call heltable([6,12,72], n3(:,6605), t3x72(:,:,5249))
  call heltable([4,18,72], n3(:,6606), t3x72(:,:,5250))
  call heltable([4,18,72], n3(:,6607), t3x72(:,:,5251))
  call heltable([4,18,72], n3(:,6608), t3x72(:,:,5252))
  call heltable([18,4,72], n3(:,6609), t3x72(:,:,5253))
  call heltable([12,6,72], n3(:,6610), t3x72(:,:,5254))
  call heltable([9,8,72], n3(:,6611), t3x72(:,:,5255))
  call heltable([9,8,72], n3(:,6612), t3x72(:,:,5256))
  call heltable([12,6,72], n3(:,6613), t3x72(:,:,5257))
  call heltable([12,6,72], n3(:,6614), t3x72(:,:,5258))
  call heltable([6,12,72], n3(:,6615), t3x72(:,:,5259))
  call heltable([4,18,72], n3(:,6616), t3x72(:,:,5260))
  call heltable([4,18,72], n3(:,6617), t3x72(:,:,5261))
  call heltable([4,18,72], n3(:,6618), t3x72(:,:,5262))
  call heltable([4,18,72], n3(:,6619), t3x72(:,:,5263))
  call heltable([12,6,72], n3(:,6620), t3x72(:,:,5264))
  call heltable([8,9,72], n3(:,6621), t3x72(:,:,5265))
  call heltable([8,9,72], n3(:,6622), t3x72(:,:,5266))
  call heltable([12,6,72], n3(:,6623), t3x72(:,:,5267))
  call heltable([12,6,72], n3(:,6624), t3x72(:,:,5268))
  call heltable([6,12,72], n3(:,6625), t3x72(:,:,5269))
  call heltable([4,18,72], n3(:,6626), t3x72(:,:,5270))
  call heltable([4,18,72], n3(:,6627), t3x72(:,:,5271))
  call heltable([4,18,72], n3(:,6628), t3x72(:,:,5272))
  call heltable([4,18,72], n3(:,6629), t3x72(:,:,5273))
  call heltable([4,18,72], n3(:,6630), t3x72(:,:,5274))
  call heltable([6,12,72], n3(:,6631), t3x72(:,:,5275))
  call heltable([4,18,72], n3(:,6632), t3x72(:,:,5276))
  call heltable([6,12,72], n3(:,6633), t3x72(:,:,5277))
  call heltable([4,18,72], n3(:,6634), t3x72(:,:,5278))
  call heltable([4,18,72], n3(:,6635), t3x72(:,:,5279))
  call heltable([4,18,72], n3(:,6636), t3x72(:,:,5280))
  call heltable([12,6,72], n3(:,6637), t3x72(:,:,5281))
  call heltable([12,6,72], n3(:,6638), t3x72(:,:,5282))
  call heltable([6,12,72], n3(:,6639), t3x72(:,:,5283))
  call heltable([6,12,72], n3(:,6640), t3x72(:,:,5284))
  call heltable([12,6,72], n3(:,6641), t3x72(:,:,5285))
  call heltable([12,6,72], n3(:,6642), t3x72(:,:,5286))

  heltables_not_init = .false.

end subroutine init_heltables

end module ol_heltables_OLR_ppzzj2loop_bbxzzg_1
