
module ol_vamp_1_ppzwj_ew_udxzwg_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppzwj_ew_udxzwg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppzwj_ew_udxzwg_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_ppzwj_ew_udxzwg_1_/**/DREALKIND
  use ol_tensor_sum_storage_ppzwj_ew_udxzwg_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_ppzwj_ew_udxzwg_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_ppzwj_ew_udxzwg_1_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL, hel_states
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(hel_states)
  type(Hpolcont), intent(in) :: M(2,hel_states)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel(1:hel_states)
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel(1:hel_states)
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

  Gcoeff(:)%j = (-(c(29)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(1),h0tab(:,1),[16,4,1,2,8],[0,0,0,0,0],5,0)
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,1),heltab2x72(:,:,1))
  call Hloop_A_Q(ntryL,G0H36(1),16,0,G1H36(1),n2h36(1))
  Gcoeff(:)%j = (c(33)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(2),h0tab(:,2),[16,4,1,2,8],[0,0,nMZ,0,0],5,0)
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,2),heltab2x72(:,:,2))
  call Hloop_A_Q(ntryL,G0H36(1),16,0,G1H36(2),n2h36(2))
  Gcoeff(:)%j = (-(c(35)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(3),h0tab(:,3),[16,4,1,2,8],[0,0,0,0,0],5,0)
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,3),heltab2x72(:,:,3))
  call Hloop_A_Q(ntryL,G0H36(1),16,0,G1H36(3),n2h36(3))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(4),h0tab(:,4),[16,2,1,4,8],[0,0,0,0,0],5,0)
  call Hloop_QV_A(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,4),heltab2x72(:,:,4))
  call Hloop_Q_A(ntryL,G0H36(1),16,0,G1H36(4),n2h36(4))
  Gcoeff(:)%j = (c(33)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(5),h0tab(:,5),[16,2,1,4,8],[0,nMZ,0,0,0],5,0)
  call Hloop_QV_A(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,5),heltab2x72(:,:,5))
  call Hloop_Q_A(ntryL,G0H36(1),16,0,G1H36(5),n2h36(5))
  Gcoeff(:)%j = (-(c(35)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(6),h0tab(:,6),[16,2,1,4,8],[0,0,0,0,0],5,0)
  call Hloop_QV_A(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,6),heltab2x72(:,:,6))
  call Hloop_Q_A(ntryL,G0H36(1),16,0,G1H36(6),n2h36(6))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(7),h0tab(:,7),[16,4,2,1,8],[0,0,0,0,0],5,0)
  call Hloop_QV_A(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,7),heltab2x72(:,:,7))
  call Hloop_Q_A(ntryL,G0H36(1),16,0,G1H36(7),n2h36(7))
  Gcoeff(:)%j = (c(33)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(8),h0tab(:,8),[16,4,2,1,8],[0,0,nMZ,0,0],5,0)
  call Hloop_QV_A(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,8),heltab2x72(:,:,8))
  call Hloop_Q_A(ntryL,G0H36(1),16,0,G1H36(8),n2h36(8))
  Gcoeff(:)%j = (-(c(35)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(9),h0tab(:,9),[16,4,2,1,8],[0,0,0,0,0],5,0)
  call Hloop_QV_A(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,9),heltab2x72(:,:,9))
  call Hloop_Q_A(ntryL,G0H36(1),16,0,G1H36(9),n2h36(9))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(10),h0tab(:,10),[16,2,1,8,4],[0,0,0,0,0],5,0)
  call Hloop_QV_A(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,10),heltab2x72(:,:,10))
  call Hloop_Q_A(ntryL,G0H36(1),16,0,G1H36(10),n2h36(10))
  Gcoeff(:)%j = (c(33)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(11),h0tab(:,11),[16,2,1,8,4],[0,nMZ,0,0,0],5,0)
  call Hloop_QV_A(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,11),heltab2x72(:,:,11))
  call Hloop_Q_A(ntryL,G0H36(1),16,0,G1H36(11),n2h36(11))
  Gcoeff(:)%j = (-(c(35)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(12),h0tab(:,12),[16,2,1,8,4],[0,0,0,0,0],5,0)
  call Hloop_QV_A(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,12),heltab2x72(:,:,12))
  call Hloop_Q_A(ntryL,G0H36(1),16,0,G1H36(12),n2h36(12))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(13),h0tab(:,13),[16,1,2,4,8],[0,0,0,0,0],5,0)
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,13),heltab2x72(:,:,13))
  call Hloop_A_Q(ntryL,G0H36(1),16,0,G1H36(13),n2h36(13))
  Gcoeff(:)%j = (c(33)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(14),h0tab(:,14),[16,1,2,4,8],[0,nMZ,0,0,0],5,0)
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,14),heltab2x72(:,:,14))
  call Hloop_A_Q(ntryL,G0H36(1),16,0,G1H36(14),n2h36(14))
  Gcoeff(:)%j = (-(c(35)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(15),h0tab(:,15),[16,1,2,4,8],[0,0,0,0,0],5,0)
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,15),heltab2x72(:,:,15))
  call Hloop_A_Q(ntryL,G0H36(1),16,0,G1H36(15),n2h36(15))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(16),h0tab(:,16),[16,1,2,8,4],[0,0,0,0,0],5,0)
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,16),heltab2x72(:,:,16))
  call Hloop_A_Q(ntryL,G0H36(1),16,0,G1H36(16),n2h36(16))
  Gcoeff(:)%j = (c(33)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(17),h0tab(:,17),[16,1,2,8,4],[0,nMZ,0,0,0],5,0)
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,17),heltab2x72(:,:,17))
  call Hloop_A_Q(ntryL,G0H36(1),16,0,G1H36(17),n2h36(17))
  Gcoeff(:)%j = (-(c(35)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(18),h0tab(:,18),[16,1,2,8,4],[0,0,0,0,0],5,0)
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,18),heltab2x72(:,:,18))
  call Hloop_A_Q(ntryL,G0H36(1),16,0,G1H36(18),n2h36(18))
  Gcoeff(:)%j = (c(32)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(19),h0tab(:,19),[16,2,8,1,4],[0,nMW,0,0,0],5,0)
  call Hloop_QV_A(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,19),heltab2x72(:,:,19))
  call Hloop_Q_A(ntryL,G0H36(1),16,0,G1H36(19),n2h36(19))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(20),h0tab(:,20),[16,2,8,1,4],[0,0,nMW,0,0],5,0)
  call Hloop_QV_A(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,20),heltab2x72(:,:,20))
  call Hloop_Q_A(ntryL,G0H36(1),16,0,G1H36(20),n2h36(20))
  Gcoeff(:)%j = (c(20)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(21),h0tab(:,21),[16,2,8,1,4],[0,nMW,nMZ,0,0],5,0)
  call Hloop_QV_A(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,21),heltab2x72(:,:,21))
  call Hloop_Q_A(ntryL,G0H36(1),16,0,G1H36(21),n2h36(21))
  Gcoeff(:)%j = (c(20)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(22),h0tab(:,22),[16,2,8,1,4],[0,nMZ,nMW,0,0],5,0)
  call Hloop_QV_A(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,22),heltab2x72(:,:,22))
  call Hloop_Q_A(ntryL,G0H36(1),16,0,G1H36(22),n2h36(22))
  Gcoeff(:)%j = (-(c(34)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(23),h0tab(:,23),[16,1,4,8,2],[0,0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H72(1),0,ex5(:),16,G1H36(23),m3h2x36(:,23),heltab2x72(:,:,23))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(24),h0tab(:,24),[16,1,4,8,2],[0,nMW,nMW,0,0],5,0)
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,24),heltab2x72(:,:,24))
  call Hloop_A_Q(ntryL,G0H36(1),16,0,G1H36(24),n2h36(23))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(25),h0tab(:,25),[16,1,4,8,2],[0,nMZ,nMH,nMW,0],5,0)
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,25),heltab2x72(:,:,25))
  call Hloop_A_Q(ntryL,G0H36(1),16,0,G1H36(25),n2h36(24))
  Gcoeff(:)%j = (-(c(37)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(26),h0tab(:,26),[16,1,4,8,2],[0,nMW,nMW,nMZ,0],5,0)
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,26),heltab2x72(:,:,26))
  call Hloop_A_Q(ntryL,G0H36(1),16,0,G1H36(26),n2h36(25))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(27),h0tab(:,27),[16,1,4,8,2],[0,nMW,nMW,0,0],5,0)
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,27),heltab2x72(:,:,27))
  call Hloop_A_Q(ntryL,G0H36(1),16,0,G1H36(27),n2h36(26))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(28),h0tab(:,28),[16,1,4,8,2],[0,nMW,nMW,nMZ,0],5,0)
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,28),heltab2x72(:,:,28))
  call Hloop_A_Q(ntryL,G0H36(1),16,0,G1H36(28),n2h36(27))
  Gcoeff(:)%j = (c(32)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(29),h0tab(:,29),[16,1,8,2,4],[0,0,nMW,0,0],5,0)
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,29),heltab2x72(:,:,29))
  call Hloop_A_Q(ntryL,G0H36(1),16,0,G1H36(29),n2h36(28))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(30),h0tab(:,30),[16,1,8,2,4],[0,nMW,0,0,0],5,0)
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,30),heltab2x72(:,:,30))
  call Hloop_A_Q(ntryL,G0H36(1),16,0,G1H36(30),n2h36(29))
  Gcoeff(:)%j = (c(20)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(31),h0tab(:,31),[16,1,8,2,4],[0,nMZ,nMW,0,0],5,0)
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,31),heltab2x72(:,:,31))
  call Hloop_A_Q(ntryL,G0H36(1),16,0,G1H36(31),n2h36(30))
  Gcoeff(:)%j = (c(20)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(32),h0tab(:,32),[16,1,8,2,4],[0,nMW,nMZ,0,0],5,0)
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,32),heltab2x72(:,:,32))
  call Hloop_A_Q(ntryL,G0H36(1),16,0,G1H36(32),n2h36(31))
  Gcoeff(:)%j = (-(c(34)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(33),h0tab(:,33),[16,1,8,4,2],[0,0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H72(1),0,ex5(:),16,G1H36(33),m3h2x36(:,33),heltab2x72(:,:,33))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(34),h0tab(:,34),[16,1,8,4,2],[0,0,nMW,nMW,0],5,0)
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,34),heltab2x72(:,:,34))
  call Hloop_A_Q(ntryL,G0H36(1),16,0,G1H36(34),n2h36(32))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(35),h0tab(:,35),[16,1,8,4,2],[0,nMW,nMH,nMZ,0],5,0)
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,35),heltab2x72(:,:,35))
  call Hloop_A_Q(ntryL,G0H36(1),16,0,G1H36(35),n2h36(33))
  Gcoeff(:)%j = (-(c(37)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(36),h0tab(:,36),[16,1,8,4,2],[0,nMZ,nMW,nMW,0],5,0)
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,36),heltab2x72(:,:,36))
  call Hloop_A_Q(ntryL,G0H36(1),16,0,G1H36(36),n2h36(34))
  Gcoeff(:)%j = (c(19)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(37),h0tab(:,37),[16,1,8,4,2],[0,0,nMW,nMW,0],5,0)
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,37),heltab2x72(:,:,37))
  call Hloop_A_Q(ntryL,G0H36(1),16,0,G1H36(37),n2h36(35))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(38),h0tab(:,38),[16,1,8,4,2],[0,nMZ,nMW,nMW,0],5,0)
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,38),heltab2x72(:,:,38))
  call Hloop_A_Q(ntryL,G0H36(1),16,0,G1H36(38),n2h36(36))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H36(3),[G1H36(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H36(6),[G1H36(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H36(9),[G1H36(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H36(12),[G1H36(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H36(15),[G1H36(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H36(18),[G1H36(16)])
  call Hloop_AZ_Q(ntryL,G1H36(3),ex3(:),G1H12(1),ngZu,m3h3x12(:,1),heltab2x36(:,:,1))
  call Hloop_A_Q(ntryL,G1H12(1),20,0,G2H12(1),n2h12(1))
  call Hloop_AZ_Q(ntryL,G1H36(2),ex3(:),G1H12(1),ngZu,m3h3x12(:,2),heltab2x36(:,:,2))
  call Hloop_A_Q(ntryL,G1H12(1),20,0,G2H12(2),n2h12(2))
  call Hloop_QA_V(ntryL,G1H36(6),ex2(:),G1H18(1),m3h2x18(:,1),heltab2x36(:,:,3))
  call Hloop_QA_Z(ntryL,G1H36(5),ex2(:),G1H18(2),ngZd,m3h2x18(:,2),heltab2x36(:,:,4))
  call Hloop_QZ_A(ntryL,G1H36(9),ex3(:),G1H12(1),ngZd,m3h3x12(:,3),heltab2x36(:,:,5))
  call Hloop_Q_A(ntryL,G1H12(1),20,0,G2H12(3),n2h12(3))
  call Hloop_QZ_A(ntryL,G1H36(8),ex3(:),G1H12(1),ngZd,m3h3x12(:,4),heltab2x36(:,:,6))
  call Hloop_Q_A(ntryL,G1H12(1),20,0,G2H12(4),n2h12(4))
  call Hloop_QA_V(ntryL,G1H36(12),ex2(:),G1H18(3),m3h2x18(:,3),heltab2x36(:,:,7))
  call Hloop_QA_Z(ntryL,G1H36(11),ex2(:),G1H18(4),ngZd,m3h2x18(:,4),heltab2x36(:,:,8))
  call Hloop_AQ_V(ntryL,G1H36(15),ex1(:),G1H18(5),m3h2x18(:,5),heltab2x36(:,:,9))
  call Hloop_AQ_Z(ntryL,G1H36(14),ex1(:),G1H18(6),ngZu,m3h2x18(:,6),heltab2x36(:,:,10))
  call Hloop_AQ_V(ntryL,G1H36(18),ex1(:),G1H18(7),m3h2x18(:,7),heltab2x36(:,:,11))
  call Hloop_AQ_Z(ntryL,G1H36(17),ex1(:),G1H18(8),ngZu,m3h2x18(:,8),heltab2x36(:,:,12))
  call Hloop_QA_W(ntryL,G1H36(19),ex2(:),G1H18(9),m3h2x18(:,9),heltab2x36(:,:,13))
  call Hloop_QA_V(ntryL,G1H36(20),ex2(:),G1H18(10),m3h2x18(:,10),heltab2x36(:,:,14))
  call Hloop_QA_W(ntryL,G1H36(21),ex2(:),G1H18(11),m3h2x18(:,11),heltab2x36(:,:,15))
  call Hloop_QA_Z(ntryL,G1H36(22),ex2(:),G1H18(12),ngZd,m3h2x18(:,12),heltab2x36(:,:,16))
  call Hloop_VQ_A(ntryL,G1H36(23),ex1(:),G1H18(13),m3h2x18(:,13),heltab2x36(:,:,17))
  call Hloop_Q_A(ntryL,G1H18(13),17,0,G2H18(1),n2h18(1))
  call Hloop_AQ_W(ntryL,G1H36(24),ex1(:),G1H18(13),m3h2x18(:,14),heltab2x36(:,:,18))
  call Hloop_AQ_Z(ntryL,G1H36(25),ex1(:),G1H18(14),ngZu,m3h2x18(:,15),heltab2x36(:,:,19))
  call Hloop_AQ_W(ntryL,G1H36(26),ex1(:),G1H18(15),m3h2x18(:,16),heltab2x36(:,:,20))
  call Hloop_AQ_W(ntryL,G1H36(27),ex1(:),G1H18(16),m3h2x18(:,17),heltab2x36(:,:,21))
  call Hloop_AQ_W(ntryL,G1H36(28),ex1(:),G1H18(17),m3h2x18(:,18),heltab2x36(:,:,22))
  call Hloop_AQ_V(ntryL,G1H36(29),ex1(:),G1H18(18),m3h2x18(:,19),heltab2x36(:,:,23))
  call Hloop_AQ_W(ntryL,G1H36(30),ex1(:),G1H18(19),m3h2x18(:,20),heltab2x36(:,:,24))
  call Hloop_AQ_Z(ntryL,G1H36(31),ex1(:),G1H18(20),ngZu,m3h2x18(:,21),heltab2x36(:,:,25))
  call Hloop_AQ_W(ntryL,G1H36(32),ex1(:),G1H18(21),m3h2x18(:,22),heltab2x36(:,:,26))
  call Hloop_VQ_A(ntryL,G1H36(33),ex1(:),G1H18(22),m3h2x18(:,23),heltab2x36(:,:,27))
  call Hloop_Q_A(ntryL,G1H18(22),17,0,G2H18(2),n2h18(2))
  call Hloop_AQ_V(ntryL,G1H36(34),ex1(:),G1H18(22),m3h2x18(:,24),heltab2x36(:,:,28))
  call Hloop_AQ_W(ntryL,G1H36(35),ex1(:),G1H18(23),m3h2x18(:,25),heltab2x36(:,:,29))
  call Hloop_AQ_Z(ntryL,G1H36(36),ex1(:),G1H18(24),ngZu,m3h2x18(:,26),heltab2x36(:,:,30))
  call Hloop_AQ_V(ntryL,G1H36(37),ex1(:),G1H18(25),m3h2x18(:,27),heltab2x36(:,:,31))
  call Hloop_AQ_Z(ntryL,G1H36(38),ex1(:),G1H18(26),ngZu,m3h2x18(:,28),heltab2x36(:,:,32))
  call Hloop_AQ_V(ntryL,G2H12(1),ex1(:),G2H6(1),m3h2x6(:,1),heltab2x12(:,:,1))
  call Hloop_AQ_Z(ntryL,G2H12(2),ex1(:),G2H6(2),ngZu,m3h2x6(:,2),heltab2x12(:,:,2))
  call Hloop_VQ_A(ntryL,G1H18(1),ex1(:),G1H9(1),m3h2x9(:,1),heltab2x18(:,:,1))
  call Hloop_Q_A(ntryL,G1H9(1),19,0,G2H9(1),n2h9(1))
  call Hloop_ZQ_A(ntryL,G1H18(2),ex1(:),G1H9(1),ngZu,m3h2x9(:,2),heltab2x18(:,:,2))
  call Hloop_Q_A(ntryL,G1H9(1),19,0,G2H9(2),n2h9(2))
  call Hloop_QA_V(ntryL,G2H12(3),ex2(:),G2H6(3),m3h2x6(:,3),heltab2x12(:,:,3))
  call Hloop_QA_Z(ntryL,G2H12(4),ex2(:),G2H6(4),ngZd,m3h2x6(:,4),heltab2x12(:,:,4))
  call Hloop_VQ_A(ntryL,G1H18(3),ex1(:),G1H9(1),m3h2x9(:,3),heltab2x18(:,:,3))
  call Hloop_Q_A(ntryL,G1H9(1),19,0,G2H9(3),n2h9(3))
  call Hloop_ZQ_A(ntryL,G1H18(4),ex1(:),G1H9(1),ngZu,m3h2x9(:,4),heltab2x18(:,:,4))
  call Hloop_Q_A(ntryL,G1H9(1),19,0,G2H9(4),n2h9(4))
  call Hloop_VA_Q(ntryL,G1H18(5),ex2(:),G1H9(1),m3h2x9(:,5),heltab2x18(:,:,5))
  call Hloop_A_Q(ntryL,G1H9(1),19,0,G2H9(5),n2h9(5))
  call Hloop_ZA_Q(ntryL,G1H18(6),ex2(:),G1H9(1),ngZd,m3h2x9(:,6),heltab2x18(:,:,6))
  call Hloop_A_Q(ntryL,G1H9(1),19,0,G2H9(6),n2h9(6))
  call Hloop_VA_Q(ntryL,G1H18(7),ex2(:),G1H9(1),m3h2x9(:,7),heltab2x18(:,:,7))
  call Hloop_A_Q(ntryL,G1H9(1),19,0,G2H9(7),n2h9(7))
  call Hloop_ZA_Q(ntryL,G1H18(8),ex2(:),G1H9(1),ngZd,m3h2x9(:,8),heltab2x18(:,:,8))
  call Hloop_A_Q(ntryL,G1H9(1),19,0,G2H9(8),n2h9(8))
  call Hloop_UV_W(ntryL,G1H18(9),18,ex4(:),8,G2H6(5),m3h3x6(:,1),heltab2x18(:,:,9))
  call Hloop_UW_V(ntryL,G1H18(10),18,ex4(:),8,G2H6(6),m3h3x6(:,2),heltab2x18(:,:,10))
  call Hloop_UV_W(ntryL,G1H18(11),18,ex4(:),8,G2H6(7),m3h3x6(:,3),heltab2x18(:,:,11))
  call Hloop_UW_V(ntryL,G1H18(12),18,ex4(:),8,G2H6(8),m3h3x6(:,4),heltab2x18(:,:,12))
  call Hotf_5pt_reduction(G2H18(1),RedSet_5(1),mass5set(:,1),  & 
G1H18(1),G1H18(2),G1H18(3),G1H18(4),G1H18(5),G1H18(6),18)
  call HG1shiftOLR(G1H18(2),2,18)
  call Hloop_VV_S(ntryL,G1H18(13),ex3(:),G1H6(1),m3h3x6(:,5),heltab2x18(:,:,13))
  call Hloop_VV_S(ntryL,G1H18(14),ex3(:),G1H6(2),m3h3x6(:,6),heltab2x18(:,:,14))
  call Hloop_VV_S(ntryL,G1H18(15),ex3(:),G1H6(3),m3h3x6(:,7),heltab2x18(:,:,15))
  call Hloop_UW_V(ntryL,G1H18(16),17,ex3(:),4,G2H6(9),m3h3x6(:,8),heltab2x18(:,:,16))
  call Hloop_UW_V(ntryL,G1H18(17),17,ex3(:),4,G2H6(10),m3h3x6(:,9),heltab2x18(:,:,17))
  call Hloop_UW_V(ntryL,G1H18(18),17,ex4(:),8,G2H6(11),m3h3x6(:,10),heltab2x18(:,:,18))
  call Hloop_UV_W(ntryL,G1H18(19),17,ex4(:),8,G2H6(12),m3h3x6(:,11),heltab2x18(:,:,19))
  call Hloop_UW_V(ntryL,G1H18(20),17,ex4(:),8,G2H6(13),m3h3x6(:,12),heltab2x18(:,:,20))
  call Hloop_UV_W(ntryL,G1H18(21),17,ex4(:),8,G2H6(14),m3h3x6(:,13),heltab2x18(:,:,21))
  call Hotf_5pt_reduction(G2H18(2),RedSet_5(2),mass5set(:,1),  & 
G1H18(7),G1H18(8),G1H18(9),G1H18(10),G1H18(11),G1H18(12),18)
  call HG1shiftOLR(G1H18(8),2,18)
  call Hloop_VV_S(ntryL,G1H18(22),ex4(:),G1H6(4),m3h3x6(:,14),heltab2x18(:,:,22))
  call Hloop_VV_S(ntryL,G1H18(23),ex4(:),G1H6(5),m3h3x6(:,15),heltab2x18(:,:,23))
  call Hloop_VV_S(ntryL,G1H18(24),ex4(:),G1H6(6),m3h3x6(:,16),heltab2x18(:,:,24))
  call Hloop_UW_V(ntryL,G1H18(25),17,ex4(:),8,G2H6(15),m3h3x6(:,17),heltab2x18(:,:,25))
  call Hloop_UW_V(ntryL,G1H18(26),17,ex4(:),8,G2H6(16),m3h3x6(:,18),heltab2x18(:,:,26))
  call Hloop_QZ_A(ntryL,G1H18(1),ex3(:),G1H6(7),ngZu,m3h3x6(:,19),heltab2x18(:,:,27))
  call Hloop_Q_A(ntryL,G1H6(7),21,0,G2H6(17),n2h6(1))
call HGT_raise_alpha_OLR(G1H18(2),1,1,18)
call HGT_raise_alpha_invQ_OLR(G1H18(2),2,5,18)
  call Hloop_VA_Q(ntryL,G1H18(2),ex2(:),G1H9(1),m3h2x9(:,9),heltab2x18(:,:,28))
  call Hloop_QZ_A(ntryL,G1H18(4),ex3(:),G1H6(7),ngZu,m3h3x6(:,20),heltab2x18(:,:,29))
  call Hloop_Q_A(ntryL,G1H6(7),21,0,G2H6(18),n2h6(2))
  call Hloop_QZ_A(ntryL,G1H18(5),ex3(:),G1H6(7),ngZu,m3h3x6(:,21),heltab2x18(:,:,30))
  call Hloop_Q_A(ntryL,G1H6(7),21,0,G2H6(19),n2h6(3))
  call Hloop_QZ_A(ntryL,G1H18(6),ex3(:),G1H6(7),ngZu,m3h3x6(:,22),heltab2x18(:,:,31))
  call Hloop_Q_A(ntryL,G1H6(7),21,0,G2H6(20),n2h6(4))
  call Hloop_QW_A(ntryL,G1H18(7),ex4(:),G1H6(7),m3h3x6(:,23),heltab2x18(:,:,32))
  call Hloop_Q_A(ntryL,G1H6(7),25,0,G2H6(21),n2h6(5))
call HGT_raise_alpha_OLR(G1H18(8),1,1,18)
call HGT_raise_alpha_invQ_OLR(G1H18(8),2,5,18)
  call Hloop_VA_Q(ntryL,G1H18(8),ex2(:),G1H9(2),m3h2x9(:,10),heltab2x18(:,:,33))
  call Hloop_QW_A(ntryL,G1H18(10),ex4(:),G1H6(7),m3h3x6(:,24),heltab2x18(:,:,34))
  call Hloop_Q_A(ntryL,G1H6(7),25,0,G2H6(22),n2h6(6))
  call Hloop_QW_A(ntryL,G1H18(11),ex4(:),G1H6(7),m3h3x6(:,25),heltab2x18(:,:,35))
  call Hloop_Q_A(ntryL,G1H6(7),25,0,G2H6(23),n2h6(7))
  call Hloop_QW_A(ntryL,G1H18(12),ex4(:),G1H6(7),m3h3x6(:,26),heltab2x18(:,:,36))
  call Hloop_Q_A(ntryL,G1H6(7),25,0,G2H6(24),n2h6(8))
  call Hotf_5pt_reduction(G2H6(1),RedSet_5(3),mass5set(:,1),  & 
G1H6(7),G1H6(8),G1H6(9),G1H6(10),G1H6(11),G1H6(12),6)
  call HG1shiftOLR(G1H6(8),8,6)
  call Hotf_5pt_reduction(G2H6(2),RedSet_5(3),mass5set(:,2),  & 
G1H6(13),G1H6(14),G1H6(15),G1H6(16),G1H6(17),G1H6(18),6)
  call HG1shiftOLR(G1H6(14),8,6)
  call Hotf_5pt_reduction(G2H9(1),RedSet_5(4),mass5set(:,1),  & 
G1H9(3),G1H9(4),G1H9(5),G1H9(6),G1H9(7),G1H9(8),9)
  call HG1shiftOLR(G1H9(4),8,9)
  call Hotf_5pt_reduction(G2H9(2),RedSet_5(4),mass5set(:,3),  & 
G1H9(9),G1H9(10),G1H9(11),G1H9(12),G1H9(13),G1H9(14),9)
  call HG1shiftOLR(G1H9(10),8,9)
  call Hotf_5pt_reduction(G2H6(3),RedSet_5(5),mass5set(:,1),  & 
G1H6(19),G1H6(20),G1H6(21),G1H6(22),G1H6(23),G1H6(24),6)
  call HG1shiftOLR(G1H6(20),8,6)
  call Hotf_5pt_reduction(G2H6(4),RedSet_5(5),mass5set(:,2),  & 
G1H6(25),G1H6(26),G1H6(27),G1H6(28),G1H6(29),G1H6(30),6)
  call HG1shiftOLR(G1H6(26),8,6)
  call Hotf_5pt_reduction(G2H9(3),RedSet_5(6),mass5set(:,1),  & 
G1H9(15),G1H9(16),G1H9(17),G1H9(18),G1H9(19),G1H9(20),9)
  call HG1shiftOLR(G1H9(16),4,9)
  call Hotf_5pt_reduction(G2H9(4),RedSet_5(6),mass5set(:,3),  & 
G1H9(21),G1H9(22),G1H9(23),G1H9(24),G1H9(25),G1H9(26),9)
  call HG1shiftOLR(G1H9(22),4,9)
  call Hotf_5pt_reduction(G2H9(5),RedSet_5(7),mass5set(:,1),  & 
G1H9(27),G1H9(28),G1H9(29),G1H9(30),G1H9(31),G1H9(32),9)
  call HG1shiftOLR(G1H9(28),8,9)
  call Hotf_5pt_reduction(G2H9(6),RedSet_5(7),mass5set(:,3),  & 
G1H9(33),G1H9(34),G1H9(35),G1H9(36),G1H9(37),G1H9(38),9)
  call HG1shiftOLR(G1H9(34),8,9)
  call Hotf_5pt_reduction(G2H9(7),RedSet_5(8),mass5set(:,1),  & 
G1H9(39),G1H9(40),G1H9(41),G1H9(42),G1H9(43),G1H9(44),9)
  call HG1shiftOLR(G1H9(40),4,9)
  call Hotf_5pt_reduction(G2H9(8),RedSet_5(8),mass5set(:,3),  & 
G1H9(45),G1H9(46),G1H9(47),G1H9(48),G1H9(49),G1H9(50),9)
  call HG1shiftOLR(G1H9(46),4,9)
  call Hotf_5pt_reduction(G2H6(5),RedSet_5(9),mass5set(:,4),  & 
G1H6(31),G1H6(32),G1H6(33),G1H6(34),G1H6(35),G1H6(36),6)
  call HG1shiftOLR(G1H6(32),4,6)
  call Hotf_5pt_reduction(G2H6(6),RedSet_5(9),mass5set(:,5),  & 
G1H6(37),G1H6(38),G1H6(39),G1H6(40),G1H6(41),G1H6(42),6)
  call HG1shiftOLR(G1H6(38),4,6)
  call Hotf_5pt_reduction(G2H6(7),RedSet_5(9),mass5set(:,6),  & 
G1H6(43),G1H6(44),G1H6(45),G1H6(46),G1H6(47),G1H6(48),6)
  call HG1shiftOLR(G1H6(44),4,6)
  call Hotf_5pt_reduction(G2H6(8),RedSet_5(9),mass5set(:,7),  & 
G1H6(49),G1H6(50),G1H6(51),G1H6(52),G1H6(53),G1H6(54),6)
  call HG1shiftOLR(G1H6(50),4,6)
  call Hloop_SV_V(ntryL,G1H6(1),ex4(:),G1H2(1),m3h3x2(:,1),heltab2x6(:,:,1))
  call Hloop_SV_V(ntryL,G1H6(2),ex4(:),G1H2(2),m3h3x2(:,2),heltab2x6(:,:,2))
  call Hloop_SV_V(ntryL,G1H6(3),ex4(:),G1H2(3),m3h3x2(:,3),heltab2x6(:,:,3))
  call Hotf_5pt_reduction(G2H6(9),RedSet_5(1),mass5set(:,8),  & 
G1H6(1),G1H6(2),G1H6(3),G1H6(55),G1H6(56),G1H6(57),6)
  call HG1shiftOLR(G1H6(2),2,6)
  call Hotf_5pt_reduction(G2H6(10),RedSet_5(1),mass5set(:,9),  & 
G1H6(58),G1H6(59),G1H6(60),G1H6(61),G1H6(62),G1H6(63),6)
  call HG1shiftOLR(G1H6(59),2,6)
  call Hotf_5pt_reduction(G2H6(11),RedSet_5(10),mass5set(:,5),  & 
G1H6(64),G1H6(65),G1H6(66),G1H6(67),G1H6(68),G1H6(69),6)
  call HG1shiftOLR(G1H6(65),4,6)
  call Hotf_5pt_reduction(G2H6(12),RedSet_5(10),mass5set(:,4),  & 
G1H6(70),G1H6(71),G1H6(72),G1H6(73),G1H6(74),G1H6(75),6)
  call HG1shiftOLR(G1H6(71),4,6)
  call Hotf_5pt_reduction(G2H6(13),RedSet_5(10),mass5set(:,7),  & 
G1H6(76),G1H6(77),G1H6(78),G1H6(79),G1H6(80),G1H6(81),6)
  call HG1shiftOLR(G1H6(77),4,6)
  call Hotf_5pt_reduction(G2H6(14),RedSet_5(10),mass5set(:,6),  & 
G1H6(82),G1H6(83),G1H6(84),G1H6(85),G1H6(86),G1H6(87),6)
  call HG1shiftOLR(G1H6(83),4,6)
  call Hloop_SV_V(ntryL,G1H6(4),ex3(:),G1H2(4),m3h3x2(:,4),heltab2x6(:,:,4))
  call Hloop_SV_V(ntryL,G1H6(5),ex3(:),G1H2(5),m3h3x2(:,5),heltab2x6(:,:,5))
  call Hloop_SV_V(ntryL,G1H6(6),ex3(:),G1H2(6),m3h3x2(:,6),heltab2x6(:,:,6))
  call Hotf_5pt_reduction(G2H6(15),RedSet_5(2),mass5set(:,10),  & 
G1H6(4),G1H6(5),G1H6(6),G1H6(88),G1H6(89),G1H6(90),6)
  call HG1shiftOLR(G1H6(5),2,6)
  call Hotf_5pt_reduction(G2H6(16),RedSet_5(2),mass5set(:,11),  & 
G1H6(91),G1H6(92),G1H6(93),G1H6(94),G1H6(95),G1H6(96),6)
  call HG1shiftOLR(G1H6(92),2,6)
  call Hotf_5pt_reduction(G2H6(17),RedSet_5(1),mass5set(:,1),  & 
G1H6(97),G1H6(98),G1H6(99),G1H6(100),G1H6(101),G1H6(102),6)
  call HG1shiftOLR(G1H6(98),2,6)
  call Hotf_4pt_reduction(G2H6(19),RedSet_4(1),mass4set(:,1),  & 
G1H6(103),G1H6(104),G1H6(105),G1H6(106),G1H6(107),6)
  call HG1shiftOLR(G1H6(104),2,6)
  call Hotf_4pt_reduction(G2H6(20),RedSet_4(2),mass4set(:,1),  & 
G1H6(108),G1H6(109),G1H6(110),G1H6(111),G1H6(112),6)
  call HG1shiftOLR(G1H6(109),10,6)
  call Hotf_5pt_reduction(G2H6(21),RedSet_5(2),mass5set(:,1),  & 
G1H6(113),G1H6(114),G1H6(115),G1H6(116),G1H6(117),G1H6(118),6)
  call HG1shiftOLR(G1H6(114),2,6)
  call Hotf_4pt_reduction(G2H6(23),RedSet_4(1),mass4set(:,1),  & 
G1H6(119),G1H6(120),G1H6(121),G1H6(122),G1H6(123),6)
  call HG1shiftOLR(G1H6(120),2,6)
  call Hotf_4pt_reduction(G2H6(24),RedSet_4(3),mass4set(:,1),  & 
G1H6(124),G1H6(125),G1H6(126),G1H6(127),G1H6(128),6)
  call HG1shiftOLR(G1H6(125),6,6)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(103),[G1H6(101)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(108),[G1H6(102)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(119),[G1H6(117)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(124),[G1H6(118)])
  call Hloop_VA_Q(ntryL,G1H6(7),ex2(:),G1H3(1),m3h2x3(:,1),heltab2x6(:,:,7))
  call Hloop_A_Q(ntryL,G1H3(1),23,0,G2H3(1),n2h3(1))
call HGT_OLR(G1H6(8),1,1,6)
call HGT_invQ_OLR(G1H6(8),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(8),-8,0,G2H6(1),n2h6(9))
  call Hloop_QW_A(ntryL,G2H6(1),ex4(:),G2H2(1),m3h3x2(:,7),heltab2x6(:,:,8))
  call Hloop_VA_Q(ntryL,G1H6(11),ex2(:),G1H3(1),m3h2x3(:,2),heltab2x6(:,:,9))
  call Hloop_A_Q(ntryL,G1H3(1),23,0,G2H3(2),n2h3(2))
  call Hloop_VA_Q(ntryL,G1H6(12),ex2(:),G1H3(1),m3h2x3(:,3),heltab2x6(:,:,10))
  call Hloop_A_Q(ntryL,G1H3(1),23,0,G2H3(3),n2h3(3))
  call Hloop_ZA_Q(ntryL,G1H6(13),ex2(:),G1H3(1),ngZd,m3h2x3(:,4),heltab2x6(:,:,11))
  call Hloop_A_Q(ntryL,G1H3(1),23,0,G2H3(4),n2h3(4))
call HGT_OLR(G1H6(14),1,1,6)
call HGT_invQ_OLR(G1H6(14),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(14),-8,0,G2H6(2),n2h6(10))
  call Hloop_QW_A(ntryL,G2H6(2),ex4(:),G2H2(2),m3h3x2(:,8),heltab2x6(:,:,12))
  call Hloop_ZA_Q(ntryL,G1H6(17),ex2(:),G1H3(1),ngZd,m3h2x3(:,5),heltab2x6(:,:,13))
  call Hloop_A_Q(ntryL,G1H3(1),23,0,G2H3(5),n2h3(5))
  call Hloop_ZA_Q(ntryL,G1H6(18),ex2(:),G1H3(1),ngZd,m3h2x3(:,6),heltab2x6(:,:,14))
  call Hloop_A_Q(ntryL,G1H3(1),23,0,G2H3(6),n2h3(6))
  call Hloop_QZ_A(ntryL,G1H9(3),ex3(:),G1H3(1),ngZu,m3h3x3(:,1),heltab2x9(:,:,1))
  call Hloop_Q_A(ntryL,G1H3(1),23,0,G2H3(7),n2h3(7))
call HGT_OLR(G1H9(4),1,1,9)
call HGT_invQ_OLR(G1H9(4),2,5,9)
  call Hloop_A_Q(ntryL,G1H9(4),-8,0,G2H9(1),n2h9(9))
  call Hloop_AW_Q(ntryL,G2H9(1),ex4(:),G2H3(8),m3h3x3(:,2),heltab2x9(:,:,2))
  call Hloop_QZ_A(ntryL,G1H9(7),ex3(:),G1H3(1),ngZu,m3h3x3(:,3),heltab2x9(:,:,3))
  call Hloop_Q_A(ntryL,G1H3(1),23,0,G2H3(9),n2h3(8))
  call Hloop_QZ_A(ntryL,G1H9(8),ex3(:),G1H3(1),ngZu,m3h3x3(:,4),heltab2x9(:,:,4))
  call Hloop_Q_A(ntryL,G1H3(1),23,0,G2H3(10),n2h3(9))
  call Hloop_QZ_A(ntryL,G1H9(9),ex3(:),G1H3(1),ngZu,m3h3x3(:,5),heltab2x9(:,:,5))
  call Hloop_Q_A(ntryL,G1H3(1),23,0,G2H3(11),n2h3(10))
call HGT_OLR(G1H9(10),1,1,9)
call HGT_invQ_OLR(G1H9(10),2,5,9)
  call Hloop_A_Q(ntryL,G1H9(10),-8,0,G2H9(2),n2h9(10))
  call Hloop_AW_Q(ntryL,G2H9(2),ex4(:),G2H3(12),m3h3x3(:,6),heltab2x9(:,:,6))
  call Hloop_QZ_A(ntryL,G1H9(13),ex3(:),G1H3(1),ngZu,m3h3x3(:,7),heltab2x9(:,:,7))
  call Hloop_Q_A(ntryL,G1H3(1),23,0,G2H3(13),n2h3(11))
  call Hloop_QZ_A(ntryL,G1H9(14),ex3(:),G1H3(1),ngZu,m3h3x3(:,8),heltab2x9(:,:,8))
  call Hloop_Q_A(ntryL,G1H3(1),23,0,G2H3(14),n2h3(12))
  call Hloop_VQ_A(ntryL,G1H6(19),ex1(:),G1H3(1),m3h2x3(:,7),heltab2x6(:,:,15))
  call Hloop_Q_A(ntryL,G1H3(1),23,0,G2H3(15),n2h3(13))
call HGT_OLR(G1H6(20),1,1,6)
call HGT_invQ_OLR(G1H6(20),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(20),-8,0,G2H6(3),n2h6(11))
  call Hloop_AW_Q(ntryL,G2H6(3),ex4(:),G2H2(3),m3h3x2(:,9),heltab2x6(:,:,16))
  call Hloop_VQ_A(ntryL,G1H6(23),ex1(:),G1H3(1),m3h2x3(:,8),heltab2x6(:,:,17))
  call Hloop_Q_A(ntryL,G1H3(1),23,0,G2H3(16),n2h3(14))
  call Hloop_VQ_A(ntryL,G1H6(24),ex1(:),G1H3(1),m3h2x3(:,9),heltab2x6(:,:,18))
  call Hloop_Q_A(ntryL,G1H3(1),23,0,G2H3(17),n2h3(15))
  call Hloop_ZQ_A(ntryL,G1H6(25),ex1(:),G1H3(1),ngZu,m3h2x3(:,10),heltab2x6(:,:,19))
  call Hloop_Q_A(ntryL,G1H3(1),23,0,G2H3(18),n2h3(16))
call HGT_OLR(G1H6(26),1,1,6)
call HGT_invQ_OLR(G1H6(26),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(26),-8,0,G2H6(4),n2h6(12))
  call Hloop_AW_Q(ntryL,G2H6(4),ex4(:),G2H2(4),m3h3x2(:,10),heltab2x6(:,:,20))
  call Hloop_ZQ_A(ntryL,G1H6(29),ex1(:),G1H3(1),ngZu,m3h2x3(:,11),heltab2x6(:,:,21))
  call Hloop_Q_A(ntryL,G1H3(1),23,0,G2H3(19),n2h3(17))
  call Hloop_ZQ_A(ntryL,G1H6(30),ex1(:),G1H3(1),ngZu,m3h2x3(:,12),heltab2x6(:,:,22))
  call Hloop_Q_A(ntryL,G1H3(1),23,0,G2H3(20),n2h3(18))
  call Hloop_QW_A(ntryL,G1H9(15),ex4(:),G1H3(1),m3h3x3(:,9),heltab2x9(:,:,9))
  call Hloop_Q_A(ntryL,G1H3(1),27,0,G2H3(21),n2h3(19))
call HGT_OLR(G1H9(16),1,1,9)
call HGT_invQ_OLR(G1H9(16),2,5,9)
  call Hloop_A_Q(ntryL,G1H9(16),-4,0,G2H9(3),n2h9(11))
  call Hloop_AZ_Q(ntryL,G2H9(3),ex3(:),G2H3(22),ngZd,m3h3x3(:,10),heltab2x9(:,:,10))
  call Hloop_QW_A(ntryL,G1H9(19),ex4(:),G1H3(1),m3h3x3(:,11),heltab2x9(:,:,11))
  call Hloop_Q_A(ntryL,G1H3(1),27,0,G2H3(23),n2h3(20))
  call Hloop_QW_A(ntryL,G1H9(20),ex4(:),G1H3(1),m3h3x3(:,12),heltab2x9(:,:,12))
  call Hloop_Q_A(ntryL,G1H3(1),27,0,G2H3(24),n2h3(21))
  call Hloop_QW_A(ntryL,G1H9(21),ex4(:),G1H3(1),m3h3x3(:,13),heltab2x9(:,:,13))
  call Hloop_Q_A(ntryL,G1H3(1),27,0,G2H3(25),n2h3(22))
call HGT_OLR(G1H9(22),1,1,9)
call HGT_invQ_OLR(G1H9(22),2,5,9)
  call Hloop_A_Q(ntryL,G1H9(22),-4,0,G2H9(4),n2h9(12))
  call Hloop_AZ_Q(ntryL,G2H9(4),ex3(:),G2H3(26),ngZd,m3h3x3(:,14),heltab2x9(:,:,14))
  call Hloop_QW_A(ntryL,G1H9(25),ex4(:),G1H3(1),m3h3x3(:,15),heltab2x9(:,:,15))
  call Hloop_Q_A(ntryL,G1H3(1),27,0,G2H3(27),n2h3(23))
  call Hloop_QW_A(ntryL,G1H9(26),ex4(:),G1H3(1),m3h3x3(:,16),heltab2x9(:,:,16))
  call Hloop_Q_A(ntryL,G1H3(1),27,0,G2H3(28),n2h3(24))
  call Hloop_AZ_Q(ntryL,G1H9(27),ex3(:),G1H3(1),ngZd,m3h3x3(:,17),heltab2x9(:,:,17))
  call Hloop_A_Q(ntryL,G1H3(1),23,0,G2H3(29),n2h3(25))
call HGT_OLR(G1H9(28),1,1,9)
call HGT_invQ_OLR(G1H9(28),2,5,9)
  call Hloop_Q_A(ntryL,G1H9(28),-8,0,G2H9(5),n2h9(13))
  call Hloop_QW_A(ntryL,G2H9(5),ex4(:),G2H3(30),m3h3x3(:,18),heltab2x9(:,:,18))
  call Hloop_AZ_Q(ntryL,G1H9(31),ex3(:),G1H3(1),ngZd,m3h3x3(:,19),heltab2x9(:,:,19))
  call Hloop_A_Q(ntryL,G1H3(1),23,0,G2H3(31),n2h3(26))
  call Hloop_AZ_Q(ntryL,G1H9(32),ex3(:),G1H3(1),ngZd,m3h3x3(:,20),heltab2x9(:,:,20))
  call Hloop_A_Q(ntryL,G1H3(1),23,0,G2H3(32),n2h3(27))
  call Hloop_AZ_Q(ntryL,G1H9(33),ex3(:),G1H3(1),ngZd,m3h3x3(:,21),heltab2x9(:,:,21))
  call Hloop_A_Q(ntryL,G1H3(1),23,0,G2H3(33),n2h3(28))
call HGT_OLR(G1H9(34),1,1,9)
call HGT_invQ_OLR(G1H9(34),2,5,9)
  call Hloop_Q_A(ntryL,G1H9(34),-8,0,G2H9(6),n2h9(14))
  call Hloop_QW_A(ntryL,G2H9(6),ex4(:),G2H3(34),m3h3x3(:,22),heltab2x9(:,:,22))
  call Hloop_AZ_Q(ntryL,G1H9(37),ex3(:),G1H3(1),ngZd,m3h3x3(:,23),heltab2x9(:,:,23))
  call Hloop_A_Q(ntryL,G1H3(1),23,0,G2H3(35),n2h3(29))
  call Hloop_AZ_Q(ntryL,G1H9(38),ex3(:),G1H3(1),ngZd,m3h3x3(:,24),heltab2x9(:,:,24))
  call Hloop_A_Q(ntryL,G1H3(1),23,0,G2H3(36),n2h3(30))
  call Hloop_AW_Q(ntryL,G1H9(39),ex4(:),G1H3(1),m3h3x3(:,25),heltab2x9(:,:,25))
  call Hloop_A_Q(ntryL,G1H3(1),27,0,G2H3(37),n2h3(31))
call HGT_OLR(G1H9(40),1,1,9)
call HGT_invQ_OLR(G1H9(40),2,5,9)
  call Hloop_Q_A(ntryL,G1H9(40),-4,0,G2H9(7),n2h9(15))
  call Hloop_QZ_A(ntryL,G2H9(7),ex3(:),G2H3(38),ngZu,m3h3x3(:,26),heltab2x9(:,:,26))
  call Hloop_AW_Q(ntryL,G1H9(43),ex4(:),G1H3(1),m3h3x3(:,27),heltab2x9(:,:,27))
  call Hloop_A_Q(ntryL,G1H3(1),27,0,G2H3(39),n2h3(32))
  call Hloop_AW_Q(ntryL,G1H9(44),ex4(:),G1H3(1),m3h3x3(:,28),heltab2x9(:,:,28))
  call Hloop_A_Q(ntryL,G1H3(1),27,0,G2H3(40),n2h3(33))
  call Hloop_AW_Q(ntryL,G1H9(45),ex4(:),G1H3(1),m3h3x3(:,29),heltab2x9(:,:,29))
  call Hloop_A_Q(ntryL,G1H3(1),27,0,G2H3(41),n2h3(34))
call HGT_OLR(G1H9(46),1,1,9)
call HGT_invQ_OLR(G1H9(46),2,5,9)
  call Hloop_Q_A(ntryL,G1H9(46),-4,0,G2H9(8),n2h9(16))
  call Hloop_QZ_A(ntryL,G2H9(8),ex3(:),G2H3(42),ngZu,m3h3x3(:,30),heltab2x9(:,:,30))
  call Hloop_AW_Q(ntryL,G1H9(49),ex4(:),G1H3(1),m3h3x3(:,31),heltab2x9(:,:,31))
  call Hloop_A_Q(ntryL,G1H3(1),27,0,G2H3(43),n2h3(35))
  call Hloop_AW_Q(ntryL,G1H9(50),ex4(:),G1H3(1),m3h3x3(:,32),heltab2x9(:,:,32))
  call Hloop_A_Q(ntryL,G1H3(1),27,0,G2H3(44),n2h3(36))
  call Hloop_VQ_A(ntryL,G1H6(31),ex1(:),G1H3(1),m3h2x3(:,13),heltab2x6(:,:,23))
  call Hloop_Q_A(ntryL,G1H3(1),27,0,G2H3(45),n2h3(37))
call HGT_OLR(G1H6(32),1,1,6)
call HGT_invQ_OLR(G1H6(32),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(32),-4,0,G2H6(5),n2h6(13))
  call Hloop_AZ_Q(ntryL,G2H6(5),ex3(:),G2H2(5),ngZu,m3h3x2(:,11),heltab2x6(:,:,24))
  call Hloop_VQ_A(ntryL,G1H6(35),ex1(:),G1H3(1),m3h2x3(:,14),heltab2x6(:,:,25))
  call Hloop_Q_A(ntryL,G1H3(1),27,0,G2H3(46),n2h3(38))
  call Hloop_VQ_A(ntryL,G1H6(36),ex1(:),G1H3(1),m3h2x3(:,15),heltab2x6(:,:,26))
  call Hloop_Q_A(ntryL,G1H3(1),27,0,G2H3(47),n2h3(39))
  call Hloop_WQ_A(ntryL,G1H6(37),ex1(:),G1H3(1),m3h2x3(:,16),heltab2x6(:,:,27))
  call Hloop_Q_A(ntryL,G1H3(1),27,0,G2H3(48),n2h3(40))
call HGT_OLR(G1H6(38),1,1,6)
call HGT_invQ_OLR(G1H6(38),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(38),-4,0,G2H6(6),n2h6(14))
  call Hloop_AZ_Q(ntryL,G2H6(6),ex3(:),G2H2(6),ngZd,m3h3x2(:,12),heltab2x6(:,:,28))
  call Hloop_WQ_A(ntryL,G1H6(41),ex1(:),G1H3(1),m3h2x3(:,17),heltab2x6(:,:,29))
  call Hloop_Q_A(ntryL,G1H3(1),27,0,G2H3(49),n2h3(41))
  call Hloop_WQ_A(ntryL,G1H6(42),ex1(:),G1H3(1),m3h2x3(:,18),heltab2x6(:,:,30))
  call Hloop_Q_A(ntryL,G1H3(1),27,0,G2H3(50),n2h3(42))
  call Hloop_ZQ_A(ntryL,G1H6(43),ex1(:),G1H3(1),ngZu,m3h2x3(:,19),heltab2x6(:,:,31))
  call Hloop_Q_A(ntryL,G1H3(1),27,0,G2H3(51),n2h3(43))
call HGT_OLR(G1H6(44),1,1,6)
call HGT_invQ_OLR(G1H6(44),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(44),-4,0,G2H6(7),n2h6(15))
  call Hloop_AZ_Q(ntryL,G2H6(7),ex3(:),G2H2(7),ngZu,m3h3x2(:,13),heltab2x6(:,:,32))
  call Hloop_ZQ_A(ntryL,G1H6(47),ex1(:),G1H3(1),ngZu,m3h2x3(:,20),heltab2x6(:,:,33))
  call Hloop_Q_A(ntryL,G1H3(1),27,0,G2H3(52),n2h3(44))
  call Hloop_ZQ_A(ntryL,G1H6(48),ex1(:),G1H3(1),ngZu,m3h2x3(:,21),heltab2x6(:,:,34))
  call Hloop_Q_A(ntryL,G1H3(1),27,0,G2H3(53),n2h3(45))
  call Hloop_WQ_A(ntryL,G1H6(49),ex1(:),G1H3(1),m3h2x3(:,22),heltab2x6(:,:,35))
  call Hloop_Q_A(ntryL,G1H3(1),27,0,G2H3(54),n2h3(46))
call HGT_OLR(G1H6(50),1,1,6)
call HGT_invQ_OLR(G1H6(50),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(50),-4,0,G2H6(8),n2h6(16))
  call Hloop_AZ_Q(ntryL,G2H6(8),ex3(:),G2H2(8),ngZd,m3h3x2(:,14),heltab2x6(:,:,36))
  call Hloop_WQ_A(ntryL,G1H6(53),ex1(:),G1H3(1),m3h2x3(:,23),heltab2x6(:,:,37))
  call Hloop_Q_A(ntryL,G1H3(1),27,0,G2H3(55),n2h3(47))
  call Hloop_WQ_A(ntryL,G1H6(54),ex1(:),G1H3(1),m3h2x3(:,24),heltab2x6(:,:,38))
  call Hloop_Q_A(ntryL,G1H3(1),27,0,G2H3(56),n2h3(48))
  call Hloop_UV_W(ntryL,G1H6(1),21,ex4(:),8,G2H2(9),m3h3x2(:,15),heltab2x6(:,:,39))
call HGT_OLR(G1H6(2),1,1,6)
call HGT_invQ_OLR(G1H6(2),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(2),-2,0,G2H6(9),n2h6(17))
  call Hloop_QA_V(ntryL,G2H6(9),ex2(:),G2H3(57),m3h2x3(:,25),heltab2x6(:,:,40))
  call Hloop_UV_W(ntryL,G1H6(56),21,ex4(:),8,G2H2(10),m3h3x2(:,16),heltab2x6(:,:,41))
  call Hloop_UV_W(ntryL,G1H6(57),21,ex4(:),8,G2H2(11),m3h3x2(:,17),heltab2x6(:,:,42))
  call Hloop_UV_W(ntryL,G1H6(58),21,ex4(:),8,G2H2(12),m3h3x2(:,18),heltab2x6(:,:,43))
call HGT_OLR(G1H6(59),1,1,6)
call HGT_invQ_OLR(G1H6(59),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(59),-2,0,G2H6(10),n2h6(18))
  call Hloop_QA_Z(ntryL,G2H6(10),ex2(:),G2H3(58),ngZd,m3h2x3(:,26),heltab2x6(:,:,44))
  call Hloop_UV_W(ntryL,G1H6(62),21,ex4(:),8,G2H2(13),m3h3x2(:,19),heltab2x6(:,:,45))
  call Hloop_UV_W(ntryL,G1H6(63),21,ex4(:),8,G2H2(14),m3h3x2(:,20),heltab2x6(:,:,46))
  call Hloop_WA_Q(ntryL,G1H6(64),ex2(:),G1H3(1),m3h2x3(:,27),heltab2x6(:,:,47))
  call Hloop_A_Q(ntryL,G1H3(1),27,0,G2H3(59),n2h3(49))
call HGT_OLR(G1H6(65),1,1,6)
call HGT_invQ_OLR(G1H6(65),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(65),-4,0,G2H6(11),n2h6(19))
  call Hloop_QZ_A(ntryL,G2H6(11),ex3(:),G2H2(15),ngZu,m3h3x2(:,21),heltab2x6(:,:,48))
  call Hloop_WA_Q(ntryL,G1H6(68),ex2(:),G1H3(1),m3h2x3(:,28),heltab2x6(:,:,49))
  call Hloop_A_Q(ntryL,G1H3(1),27,0,G2H3(60),n2h3(50))
  call Hloop_WA_Q(ntryL,G1H6(69),ex2(:),G1H3(1),m3h2x3(:,29),heltab2x6(:,:,50))
  call Hloop_A_Q(ntryL,G1H3(1),27,0,G2H3(61),n2h3(51))
  call Hloop_VA_Q(ntryL,G1H6(70),ex2(:),G1H3(1),m3h2x3(:,30),heltab2x6(:,:,51))
  call Hloop_A_Q(ntryL,G1H3(1),27,0,G2H3(62),n2h3(52))
call HGT_OLR(G1H6(71),1,1,6)
call HGT_invQ_OLR(G1H6(71),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(71),-4,0,G2H6(12),n2h6(20))
  call Hloop_QZ_A(ntryL,G2H6(12),ex3(:),G2H2(16),ngZd,m3h3x2(:,22),heltab2x6(:,:,52))
  call Hloop_VA_Q(ntryL,G1H6(74),ex2(:),G1H3(1),m3h2x3(:,31),heltab2x6(:,:,53))
  call Hloop_A_Q(ntryL,G1H3(1),27,0,G2H3(63),n2h3(53))
  call Hloop_VA_Q(ntryL,G1H6(75),ex2(:),G1H3(1),m3h2x3(:,32),heltab2x6(:,:,54))
  call Hloop_A_Q(ntryL,G1H3(1),27,0,G2H3(64),n2h3(54))
  call Hloop_WA_Q(ntryL,G1H6(76),ex2(:),G1H3(1),m3h2x3(:,33),heltab2x6(:,:,55))
  call Hloop_A_Q(ntryL,G1H3(1),27,0,G2H3(65),n2h3(55))
call HGT_OLR(G1H6(77),1,1,6)
call HGT_invQ_OLR(G1H6(77),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(77),-4,0,G2H6(13),n2h6(21))
  call Hloop_QZ_A(ntryL,G2H6(13),ex3(:),G2H2(17),ngZu,m3h3x2(:,23),heltab2x6(:,:,56))
  call Hloop_WA_Q(ntryL,G1H6(80),ex2(:),G1H3(1),m3h2x3(:,34),heltab2x6(:,:,57))
  call Hloop_A_Q(ntryL,G1H3(1),27,0,G2H3(66),n2h3(56))
  call Hloop_WA_Q(ntryL,G1H6(81),ex2(:),G1H3(1),m3h2x3(:,35),heltab2x6(:,:,58))
  call Hloop_A_Q(ntryL,G1H3(1),27,0,G2H3(67),n2h3(57))
  call Hloop_ZA_Q(ntryL,G1H6(82),ex2(:),G1H3(1),ngZd,m3h2x3(:,36),heltab2x6(:,:,59))
  call Hloop_A_Q(ntryL,G1H3(1),27,0,G2H3(68),n2h3(58))
call HGT_OLR(G1H6(83),1,1,6)
call HGT_invQ_OLR(G1H6(83),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(83),-4,0,G2H6(14),n2h6(22))
  call Hloop_QZ_A(ntryL,G2H6(14),ex3(:),G2H2(18),ngZd,m3h3x2(:,24),heltab2x6(:,:,60))
  call Hloop_ZA_Q(ntryL,G1H6(86),ex2(:),G1H3(1),ngZd,m3h2x3(:,37),heltab2x6(:,:,61))
  call Hloop_A_Q(ntryL,G1H3(1),27,0,G2H3(69),n2h3(59))
  call Hloop_ZA_Q(ntryL,G1H6(87),ex2(:),G1H3(1),ngZd,m3h2x3(:,38),heltab2x6(:,:,62))
  call Hloop_A_Q(ntryL,G1H3(1),27,0,G2H3(70),n2h3(60))
  call Hloop_UV_W(ntryL,G1H6(4),25,ex3(:),4,G2H2(19),m3h3x2(:,25),heltab2x6(:,:,63))
call HGT_OLR(G1H6(5),1,1,6)
call HGT_invQ_OLR(G1H6(5),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(5),-2,0,G2H6(15),n2h6(23))
  call Hloop_QA_W(ntryL,G2H6(15),ex2(:),G2H3(71),m3h2x3(:,39),heltab2x6(:,:,64))
  call Hloop_UV_W(ntryL,G1H6(89),25,ex3(:),4,G2H2(20),m3h3x2(:,26),heltab2x6(:,:,65))
  call Hloop_UV_W(ntryL,G1H6(90),25,ex3(:),4,G2H2(21),m3h3x2(:,27),heltab2x6(:,:,66))
  call Hloop_UV_W(ntryL,G1H6(91),25,ex3(:),4,G2H2(22),m3h3x2(:,28),heltab2x6(:,:,67))
call HGT_OLR(G1H6(92),1,1,6)
call HGT_invQ_OLR(G1H6(92),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(92),-2,0,G2H6(16),n2h6(24))
  call Hloop_QA_W(ntryL,G2H6(16),ex2(:),G2H3(72),m3h2x3(:,40),heltab2x6(:,:,68))
  call Hloop_UV_W(ntryL,G1H6(95),25,ex3(:),4,G2H2(23),m3h3x2(:,29),heltab2x6(:,:,69))
  call Hloop_UV_W(ntryL,G1H6(96),25,ex3(:),4,G2H2(24),m3h3x2(:,30),heltab2x6(:,:,70))
  call Hloop_QW_A(ntryL,G1H6(97),ex4(:),G1H2(7),m3h3x2(:,31),heltab2x6(:,:,71))
  call Hloop_Q_A(ntryL,G1H2(7),29,0,G2H2(25),n2h2(1))
call HGT_raise_alpha_OLR(G1H6(98),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(98),2,5,6)
  call Hloop_VA_Q(ntryL,G1H6(98),ex2(:),G1H3(1),m3h2x3(:,41),heltab2x6(:,:,72))
  call Hloop_QW_A(ntryL,G1H6(103),ex4(:),G1H2(7),m3h3x2(:,32),heltab2x6(:,:,73))
  call Hloop_Q_A(ntryL,G1H2(7),29,0,G2H2(26),n2h2(2))
  call Hloop_QW_A(ntryL,G1H6(108),ex4(:),G1H2(7),m3h3x2(:,33),heltab2x6(:,:,74))
  call Hloop_Q_A(ntryL,G1H2(7),29,0,G2H2(27),n2h2(3))
call HGT_raise_alpha_OLR(G1H6(104),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(104),2,5,6)
  call Hloop_VA_Q(ntryL,G1H6(104),ex2(:),G1H3(2),m3h2x3(:,42),heltab2x6(:,:,75))
  call Hloop_QW_A(ntryL,G1H6(107),ex4(:),G1H2(7),m3h3x2(:,34),heltab2x6(:,:,76))
  call Hloop_Q_A(ntryL,G1H2(7),29,0,G2H2(28),n2h2(4))
call HGT_raise_alpha_OLR(G1H6(109),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(109),2,5,6)
  call Hloop_VA_Q(ntryL,G1H6(109),ex2(:),G1H3(3),m3h2x3(:,43),heltab2x6(:,:,77))
  call Hloop_QW_A(ntryL,G1H6(112),ex4(:),G1H2(7),m3h3x2(:,35),heltab2x6(:,:,78))
  call Hloop_Q_A(ntryL,G1H2(7),29,0,G2H2(29),n2h2(5))
  call Hloop_QZ_A(ntryL,G1H6(113),ex3(:),G1H2(7),ngZd,m3h3x2(:,36),heltab2x6(:,:,79))
  call Hloop_Q_A(ntryL,G1H2(7),29,0,G2H2(30),n2h2(6))
call HGT_raise_alpha_OLR(G1H6(114),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(114),2,5,6)
  call Hloop_VA_Q(ntryL,G1H6(114),ex2(:),G1H3(4),m3h2x3(:,44),heltab2x6(:,:,80))
  call Hloop_QZ_A(ntryL,G1H6(119),ex3(:),G1H2(7),ngZd,m3h3x2(:,37),heltab2x6(:,:,81))
  call Hloop_Q_A(ntryL,G1H2(7),29,0,G2H2(31),n2h2(7))
  call Hloop_QZ_A(ntryL,G1H6(124),ex3(:),G1H2(7),ngZd,m3h3x2(:,38),heltab2x6(:,:,82))
  call Hloop_Q_A(ntryL,G1H2(7),29,0,G2H2(32),n2h2(8))
call HGT_raise_alpha_OLR(G1H6(120),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(120),2,5,6)
  call Hloop_VA_Q(ntryL,G1H6(120),ex2(:),G1H3(5),m3h2x3(:,45),heltab2x6(:,:,83))
  call Hloop_QZ_A(ntryL,G1H6(123),ex3(:),G1H2(7),ngZd,m3h3x2(:,39),heltab2x6(:,:,84))
  call Hloop_Q_A(ntryL,G1H2(7),29,0,G2H2(33),n2h2(9))
call HGT_raise_alpha_OLR(G1H6(125),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(125),2,5,6)
  call Hloop_VA_Q(ntryL,G1H6(125),ex2(:),G1H3(6),m3h2x3(:,46),heltab2x6(:,:,85))
  call Hloop_QZ_A(ntryL,G1H6(128),ex3(:),G1H2(7),ngZd,m3h3x2(:,40),heltab2x6(:,:,86))
  call Hloop_Q_A(ntryL,G1H2(7),29,0,G2H2(34),n2h2(10))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(9),[G1H2(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(12),[G1H2(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(19),[G1H2(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(22),[G1H2(6)])
  call Hotf_5pt_reduction(G2H2(9),RedSet_5(1),mass5set(:,8),  & 
G1H2(7),G1H2(1),G1H2(3),G1H2(4),G1H2(6),G1H2(8),2)
  call HG1shiftOLR(G1H2(1),2,2)
  call Hloop_WA_Q(ntryL,G1H2(2),ex2(:),G1H1(1),m3h2x1(:,1),heltab2x2(:,:,1))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(1),n2h1(1))
  call Hotf_5pt_reduction(G2H2(12),RedSet_5(1),mass5set(:,9),  & 
G1H2(2),G1H2(9),G1H2(10),G1H2(11),G1H2(12),G1H2(13),2)
  call HG1shiftOLR(G1H2(9),2,2)
  call Hotf_5pt_reduction(G2H2(19),RedSet_5(2),mass5set(:,10),  & 
G1H2(14),G1H2(15),G1H2(16),G1H2(17),G1H2(18),G1H2(19),2)
  call HG1shiftOLR(G1H2(15),2,2)
  call Hloop_ZA_Q(ntryL,G1H2(5),ex2(:),G1H1(1),ngZd,m3h2x1(:,2),heltab2x2(:,:,2))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(2),n2h1(2))
  call Hotf_5pt_reduction(G2H2(22),RedSet_5(2),mass5set(:,11),  & 
G1H2(5),G1H2(20),G1H2(21),G1H2(22),G1H2(23),G1H2(24),2)
  call HG1shiftOLR(G1H2(20),2,2)
  call Hotf_5pt_reduction(G2H3(1),RedSet_5(3),mass5set(:,1),  & 
G1H3(7),G1H3(8),G1H3(9),G1H3(10),G1H3(11),G1H3(12),3)
  call HG1shiftOLR(G1H3(8),8,3)
  call Hotf_4pt_reduction(G2H3(3),RedSet_4(4),mass4set(:,1),  & 
G1H3(13),G1H3(14),G1H3(15),G1H3(16),G1H3(17),3)
  call HG1shiftOLR(G1H3(14),10,3)
  call Hotf_5pt_reduction(G2H3(4),RedSet_5(3),mass5set(:,2),  & 
G1H3(18),G1H3(19),G1H3(20),G1H3(21),G1H3(22),G1H3(23),3)
  call HG1shiftOLR(G1H3(19),8,3)
  call Hotf_4pt_reduction(G2H3(6),RedSet_4(4),mass4set(:,2),  & 
G1H3(24),G1H3(25),G1H3(26),G1H3(27),G1H3(28),3)
  call HG1shiftOLR(G1H3(25),10,3)
  call Hotf_5pt_reduction(G2H3(7),RedSet_5(4),mass5set(:,1),  & 
G1H3(29),G1H3(30),G1H3(31),G1H3(32),G1H3(33),G1H3(34),3)
  call HG1shiftOLR(G1H3(30),8,3)
  call Hotf_4pt_reduction(G2H3(10),RedSet_4(5),mass4set(:,1),  & 
G1H3(35),G1H3(36),G1H3(37),G1H3(38),G1H3(39),3)
  call HG1shiftOLR(G1H3(36),12,3)
  call Hotf_5pt_reduction(G2H3(11),RedSet_5(4),mass5set(:,3),  & 
G1H3(40),G1H3(41),G1H3(42),G1H3(43),G1H3(44),G1H3(45),3)
  call HG1shiftOLR(G1H3(41),8,3)
  call Hotf_4pt_reduction(G2H3(14),RedSet_4(5),mass4set(:,3),  & 
G1H3(46),G1H3(47),G1H3(48),G1H3(49),G1H3(50),3)
  call HG1shiftOLR(G1H3(47),12,3)
  call Hotf_5pt_reduction(G2H3(15),RedSet_5(5),mass5set(:,1),  & 
G1H3(51),G1H3(52),G1H3(53),G1H3(54),G1H3(55),G1H3(56),3)
  call HG1shiftOLR(G1H3(52),8,3)
  call Hotf_4pt_reduction(G2H3(17),RedSet_4(6),mass4set(:,1),  & 
G1H3(57),G1H3(58),G1H3(59),G1H3(60),G1H3(61),3)
  call HG1shiftOLR(G1H3(58),9,3)
  call Hotf_5pt_reduction(G2H3(18),RedSet_5(5),mass5set(:,2),  & 
G1H3(62),G1H3(63),G1H3(64),G1H3(65),G1H3(66),G1H3(67),3)
  call HG1shiftOLR(G1H3(63),8,3)
  call Hotf_4pt_reduction(G2H3(20),RedSet_4(6),mass4set(:,2),  & 
G1H3(68),G1H3(69),G1H3(70),G1H3(71),G1H3(72),3)
  call HG1shiftOLR(G1H3(69),9,3)
  call Hotf_5pt_reduction(G2H3(21),RedSet_5(6),mass5set(:,1),  & 
G1H3(73),G1H3(74),G1H3(75),G1H3(76),G1H3(77),G1H3(78),3)
  call HG1shiftOLR(G1H3(74),4,3)
  call Hotf_4pt_reduction(G2H3(24),RedSet_4(5),mass4set(:,1),  & 
G1H3(79),G1H3(80),G1H3(81),G1H3(82),G1H3(83),3)
  call HG1shiftOLR(G1H3(80),12,3)
  call Hotf_5pt_reduction(G2H3(25),RedSet_5(6),mass5set(:,3),  & 
G1H3(84),G1H3(85),G1H3(86),G1H3(87),G1H3(88),G1H3(89),3)
  call HG1shiftOLR(G1H3(85),4,3)
  call Hotf_4pt_reduction(G2H3(28),RedSet_4(5),mass4set(:,3),  & 
G1H3(90),G1H3(91),G1H3(92),G1H3(93),G1H3(94),3)
  call HG1shiftOLR(G1H3(91),12,3)
  call Hotf_5pt_reduction(G2H3(29),RedSet_5(7),mass5set(:,1),  & 
G1H3(95),G1H3(96),G1H3(97),G1H3(98),G1H3(99),G1H3(100),3)
  call HG1shiftOLR(G1H3(96),8,3)
  call Hotf_4pt_reduction(G2H3(32),RedSet_4(7),mass4set(:,1),  & 
G1H3(101),G1H3(102),G1H3(103),G1H3(104),G1H3(105),3)
  call HG1shiftOLR(G1H3(102),12,3)
  call Hotf_5pt_reduction(G2H3(33),RedSet_5(7),mass5set(:,3),  & 
G1H3(106),G1H3(107),G1H3(108),G1H3(109),G1H3(110),G1H3(111),3)
  call HG1shiftOLR(G1H3(107),8,3)
  call Hotf_4pt_reduction(G2H3(36),RedSet_4(7),mass4set(:,3),  & 
G1H3(112),G1H3(113),G1H3(114),G1H3(115),G1H3(116),3)
  call HG1shiftOLR(G1H3(113),12,3)
  call Hotf_5pt_reduction(G2H3(37),RedSet_5(8),mass5set(:,1),  & 
G1H3(117),G1H3(118),G1H3(119),G1H3(120),G1H3(121),G1H3(122),3)
  call HG1shiftOLR(G1H3(118),4,3)
  call Hotf_4pt_reduction(G2H3(40),RedSet_4(7),mass4set(:,1),  & 
G1H3(123),G1H3(124),G1H3(125),G1H3(126),G1H3(127),3)
  call HG1shiftOLR(G1H3(124),12,3)
  call Hotf_5pt_reduction(G2H3(41),RedSet_5(8),mass5set(:,3),  & 
G1H3(128),G1H3(129),G1H3(130),G1H3(131),G1H3(132),G1H3(133),3)
  call HG1shiftOLR(G1H3(129),4,3)
  call Hotf_4pt_reduction(G2H3(44),RedSet_4(7),mass4set(:,3),  & 
G1H3(134),G1H3(135),G1H3(136),G1H3(137),G1H3(138),3)
  call HG1shiftOLR(G1H3(135),12,3)
  call Hotf_5pt_reduction(G2H3(45),RedSet_5(9),mass5set(:,4),  & 
G1H3(139),G1H3(140),G1H3(141),G1H3(142),G1H3(143),G1H3(144),3)
  call HG1shiftOLR(G1H3(140),4,3)
  call Hotf_4pt_reduction(G2H3(47),RedSet_4(8),mass4set(:,4),  & 
G1H3(145),G1H3(146),G1H3(147),G1H3(148),G1H3(149),3)
  call HG1shiftOLR(G1H3(146),5,3)
  call Hotf_5pt_reduction(G2H3(48),RedSet_5(9),mass5set(:,5),  & 
G1H3(150),G1H3(151),G1H3(152),G1H3(153),G1H3(154),G1H3(155),3)
  call HG1shiftOLR(G1H3(151),4,3)
  call Hotf_4pt_reduction(G2H3(50),RedSet_4(8),mass4set(:,5),  & 
G1H3(156),G1H3(157),G1H3(158),G1H3(159),G1H3(160),3)
  call HG1shiftOLR(G1H3(157),5,3)
  call Hotf_5pt_reduction(G2H3(51),RedSet_5(9),mass5set(:,6),  & 
G1H3(161),G1H3(162),G1H3(163),G1H3(164),G1H3(165),G1H3(166),3)
  call HG1shiftOLR(G1H3(162),4,3)
  call Hotf_4pt_reduction(G2H3(53),RedSet_4(8),mass4set(:,6),  & 
G1H3(167),G1H3(168),G1H3(169),G1H3(170),G1H3(171),3)
  call HG1shiftOLR(G1H3(168),5,3)
  call Hotf_5pt_reduction(G2H3(54),RedSet_5(9),mass5set(:,7),  & 
G1H3(172),G1H3(173),G1H3(174),G1H3(175),G1H3(176),G1H3(177),3)
  call HG1shiftOLR(G1H3(173),4,3)
  call Hotf_4pt_reduction(G2H3(56),RedSet_4(8),mass4set(:,7),  & 
G1H3(178),G1H3(179),G1H3(180),G1H3(181),G1H3(182),3)
  call HG1shiftOLR(G1H3(179),5,3)
  call Hotf_4pt_reduction(G2H2(11),RedSet_4(2),mass4set(:,8),  & 
G1H2(25),G1H2(26),G1H2(27),G1H2(28),G1H2(29),2)
  call HG1shiftOLR(G1H2(26),10,2)
  call Hotf_4pt_reduction(G2H2(14),RedSet_4(2),mass4set(:,8),  & 
G1H2(30),G1H2(31),G1H2(32),G1H2(33),G1H2(34),2)
  call HG1shiftOLR(G1H2(31),10,2)
  call Hotf_5pt_reduction(G2H3(59),RedSet_5(10),mass5set(:,5),  & 
G1H3(183),G1H3(184),G1H3(185),G1H3(186),G1H3(187),G1H3(188),3)
  call HG1shiftOLR(G1H3(184),4,3)
  call Hotf_4pt_reduction(G2H3(61),RedSet_4(3),mass4set(:,5),  & 
G1H3(189),G1H3(190),G1H3(191),G1H3(192),G1H3(193),3)
  call HG1shiftOLR(G1H3(190),6,3)
  call Hotf_5pt_reduction(G2H3(62),RedSet_5(10),mass5set(:,4),  & 
G1H3(194),G1H3(195),G1H3(196),G1H3(197),G1H3(198),G1H3(199),3)
  call HG1shiftOLR(G1H3(195),4,3)
  call Hotf_4pt_reduction(G2H3(64),RedSet_4(3),mass4set(:,4),  & 
G1H3(200),G1H3(201),G1H3(202),G1H3(203),G1H3(204),3)
  call HG1shiftOLR(G1H3(201),6,3)
  call Hotf_5pt_reduction(G2H3(65),RedSet_5(10),mass5set(:,7),  & 
G1H3(205),G1H3(206),G1H3(207),G1H3(208),G1H3(209),G1H3(210),3)
  call HG1shiftOLR(G1H3(206),4,3)
  call Hotf_4pt_reduction(G2H3(67),RedSet_4(3),mass4set(:,7),  & 
G1H3(211),G1H3(212),G1H3(213),G1H3(214),G1H3(215),3)
  call HG1shiftOLR(G1H3(212),6,3)
  call Hotf_5pt_reduction(G2H3(68),RedSet_5(10),mass5set(:,6),  & 
G1H3(216),G1H3(217),G1H3(218),G1H3(219),G1H3(220),G1H3(221),3)
  call HG1shiftOLR(G1H3(217),4,3)
  call Hotf_4pt_reduction(G2H3(70),RedSet_4(3),mass4set(:,6),  & 
G1H3(222),G1H3(223),G1H3(224),G1H3(225),G1H3(226),3)
  call HG1shiftOLR(G1H3(223),6,3)
  call Hotf_4pt_reduction(G2H2(21),RedSet_4(3),mass4set(:,5),  & 
G1H2(35),G1H2(36),G1H2(37),G1H2(38),G1H2(39),2)
  call HG1shiftOLR(G1H2(36),6,2)
  call Hotf_4pt_reduction(G2H2(24),RedSet_4(3),mass4set(:,7),  & 
G1H2(40),G1H2(41),G1H2(42),G1H2(43),G1H2(44),2)
  call HG1shiftOLR(G1H2(41),6,2)
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(25),ex2(:),G2tensor(3),m3h2x1(:,3),heltab2x2(:,:,3))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(27),ex2(:),G2tensor(4),m3h2x1(:,4),heltab2x2(:,:,4))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(30),ex2(:),G2tensor(5),m3h2x1(:,5),heltab2x2(:,:,5))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(32),ex2(:),G2tensor(6),m3h2x1(:,6),heltab2x2(:,:,6))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(25),[G1H2(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(30),[G1H2(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(35),[G1H2(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(40),[G1H2(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(13),[G1H3(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(24),[G1H3(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(35),[G1H3(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(46),[G1H3(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(57),[G1H3(56)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(68),[G1H3(67)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(79),[G1H3(78)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(90),[G1H3(89)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(101),[G1H3(100)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(112),[G1H3(111)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(123),[G1H3(122)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(134),[G1H3(133)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(145),[G1H3(144)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(156),[G1H3(155)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(167),[G1H3(166)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(178),[G1H3(177)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(189),[G1H3(188)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(200),[G1H3(199)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(211),[G1H3(210)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(222),[G1H3(221)])
  call Hloop_VA_Q(ntryL,G1H2(7),ex2(:),G1H1(1),m3h2x1(:,7),heltab2x2(:,:,7))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(7),n2h1(3))
  call Hloop_VA_Q(ntryL,G1H2(1),ex2(:),G1H1(1),m3h2x1(:,8),heltab2x2(:,:,8))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(8),n2h1(4))
  call Hloop_VA_Q(ntryL,G1H2(25),ex2(:),G1H1(1),m3h2x1(:,9),heltab2x2(:,:,9))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(9),n2h1(5))
  call Hloop_ZA_Q(ntryL,G1H2(2),ex2(:),G1H1(1),ngZd,m3h2x1(:,10),heltab2x2(:,:,10))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(10),n2h1(6))
  call Hloop_ZA_Q(ntryL,G1H2(9),ex2(:),G1H1(1),ngZd,m3h2x1(:,11),heltab2x2(:,:,11))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(11),n2h1(7))
  call Hloop_ZA_Q(ntryL,G1H2(30),ex2(:),G1H1(1),ngZd,m3h2x1(:,12),heltab2x2(:,:,12))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(12),n2h1(8))
  call Hloop_WA_Q(ntryL,G1H2(14),ex2(:),G1H1(1),m3h2x1(:,13),heltab2x2(:,:,13))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(13),n2h1(9))
  call Hloop_WA_Q(ntryL,G1H2(15),ex2(:),G1H1(1),m3h2x1(:,14),heltab2x2(:,:,14))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(14),n2h1(10))
  call Hloop_WA_Q(ntryL,G1H2(35),ex2(:),G1H1(1),m3h2x1(:,15),heltab2x2(:,:,15))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(15),n2h1(11))
  call Hloop_WA_Q(ntryL,G1H2(5),ex2(:),G1H1(1),m3h2x1(:,16),heltab2x2(:,:,16))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(16),n2h1(12))
  call Hloop_WA_Q(ntryL,G1H2(20),ex2(:),G1H1(1),m3h2x1(:,17),heltab2x2(:,:,17))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(17),n2h1(13))
  call Hloop_WA_Q(ntryL,G1H2(40),ex2(:),G1H1(1),m3h2x1(:,18),heltab2x2(:,:,18))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(18),n2h1(14))
  call Hloop_AW_Q(ntryL,G1H3(7),ex4(:),G1H1(1),m3h3x1(:,1),heltab2x3(:,:,1))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(19),n2h1(15))
  call Hloop_AW_Q(ntryL,G1H3(8),ex4(:),G1H1(1),m3h3x1(:,2),heltab2x3(:,:,2))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(20),n2h1(16))
  call Hloop_AW_Q(ntryL,G1H3(13),ex4(:),G1H1(1),m3h3x1(:,3),heltab2x3(:,:,3))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(21),n2h1(17))
  call Hloop_AW_Q(ntryL,G1H3(14),ex4(:),G1H1(1),m3h3x1(:,4),heltab2x3(:,:,4))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,0,G2tensor(22),n2h1(18))
  call Hloop_AW_Q(ntryL,G1H3(18),ex4(:),G1H1(1),m3h3x1(:,5),heltab2x3(:,:,5))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(23),n2h1(19))
  call Hloop_AW_Q(ntryL,G1H3(19),ex4(:),G1H1(1),m3h3x1(:,6),heltab2x3(:,:,6))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(24),n2h1(20))
  call Hloop_AW_Q(ntryL,G1H3(24),ex4(:),G1H1(1),m3h3x1(:,7),heltab2x3(:,:,7))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(25),n2h1(21))
  call Hloop_AW_Q(ntryL,G1H3(25),ex4(:),G1H1(1),m3h3x1(:,8),heltab2x3(:,:,8))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,0,G2tensor(26),n2h1(22))
  call Hloop_QW_A(ntryL,G1H3(29),ex4(:),G1H1(1),m3h3x1(:,9),heltab2x3(:,:,9))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(27),n2h1(23))
  call Hloop_QW_A(ntryL,G1H3(30),ex4(:),G1H1(1),m3h3x1(:,10),heltab2x3(:,:,10))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(28),n2h1(24))
  call Hloop_QW_A(ntryL,G1H3(35),ex4(:),G1H1(1),m3h3x1(:,11),heltab2x3(:,:,11))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(29),n2h1(25))
  call Hloop_QW_A(ntryL,G1H3(36),ex4(:),G1H1(1),m3h3x1(:,12),heltab2x3(:,:,12))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(30),n2h1(26))
  call Hloop_QW_A(ntryL,G1H3(40),ex4(:),G1H1(1),m3h3x1(:,13),heltab2x3(:,:,13))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(31),n2h1(27))
  call Hloop_QW_A(ntryL,G1H3(41),ex4(:),G1H1(1),m3h3x1(:,14),heltab2x3(:,:,14))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(32),n2h1(28))
  call Hloop_QW_A(ntryL,G1H3(46),ex4(:),G1H1(1),m3h3x1(:,15),heltab2x3(:,:,15))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(33),n2h1(29))
  call Hloop_QW_A(ntryL,G1H3(47),ex4(:),G1H1(1),m3h3x1(:,16),heltab2x3(:,:,16))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(34),n2h1(30))
  call Hloop_QW_A(ntryL,G1H3(51),ex4(:),G1H1(1),m3h3x1(:,17),heltab2x3(:,:,17))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(35),n2h1(31))
  call Hloop_QW_A(ntryL,G1H3(52),ex4(:),G1H1(1),m3h3x1(:,18),heltab2x3(:,:,18))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(36),n2h1(32))
  call Hloop_QW_A(ntryL,G1H3(57),ex4(:),G1H1(1),m3h3x1(:,19),heltab2x3(:,:,19))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(37),n2h1(33))
  call Hloop_QW_A(ntryL,G1H3(58),ex4(:),G1H1(1),m3h3x1(:,20),heltab2x3(:,:,20))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,0,G2tensor(38),n2h1(34))
  call Hloop_QW_A(ntryL,G1H3(62),ex4(:),G1H1(1),m3h3x1(:,21),heltab2x3(:,:,21))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(39),n2h1(35))
  call Hloop_QW_A(ntryL,G1H3(63),ex4(:),G1H1(1),m3h3x1(:,22),heltab2x3(:,:,22))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(40),n2h1(36))
  call Hloop_QW_A(ntryL,G1H3(68),ex4(:),G1H1(1),m3h3x1(:,23),heltab2x3(:,:,23))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(41),n2h1(37))
  call Hloop_QW_A(ntryL,G1H3(69),ex4(:),G1H1(1),m3h3x1(:,24),heltab2x3(:,:,24))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,0,G2tensor(42),n2h1(38))
  call Hloop_QZ_A(ntryL,G1H3(73),ex3(:),G1H1(1),ngZd,m3h3x1(:,25),heltab2x3(:,:,25))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(43),n2h1(39))
  call Hloop_QZ_A(ntryL,G1H3(74),ex3(:),G1H1(1),ngZd,m3h3x1(:,26),heltab2x3(:,:,26))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(44),n2h1(40))
  call Hloop_QZ_A(ntryL,G1H3(79),ex3(:),G1H1(1),ngZd,m3h3x1(:,27),heltab2x3(:,:,27))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(45),n2h1(41))
  call Hloop_QZ_A(ntryL,G1H3(80),ex3(:),G1H1(1),ngZd,m3h3x1(:,28),heltab2x3(:,:,28))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(46),n2h1(42))
  call Hloop_QZ_A(ntryL,G1H3(84),ex3(:),G1H1(1),ngZd,m3h3x1(:,29),heltab2x3(:,:,29))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(47),n2h1(43))
  call Hloop_QZ_A(ntryL,G1H3(85),ex3(:),G1H1(1),ngZd,m3h3x1(:,30),heltab2x3(:,:,30))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(48),n2h1(44))
  call Hloop_QZ_A(ntryL,G1H3(90),ex3(:),G1H1(1),ngZd,m3h3x1(:,31),heltab2x3(:,:,31))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(49),n2h1(45))
  call Hloop_QZ_A(ntryL,G1H3(91),ex3(:),G1H1(1),ngZd,m3h3x1(:,32),heltab2x3(:,:,32))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(50),n2h1(46))
  call Hloop_AW_Q(ntryL,G1H3(95),ex4(:),G1H1(1),m3h3x1(:,33),heltab2x3(:,:,33))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(51),n2h1(47))
  call Hloop_AW_Q(ntryL,G1H3(96),ex4(:),G1H1(1),m3h3x1(:,34),heltab2x3(:,:,34))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(52),n2h1(48))
  call Hloop_AW_Q(ntryL,G1H3(101),ex4(:),G1H1(1),m3h3x1(:,35),heltab2x3(:,:,35))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(53),n2h1(49))
  call Hloop_AW_Q(ntryL,G1H3(102),ex4(:),G1H1(1),m3h3x1(:,36),heltab2x3(:,:,36))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,0,G2tensor(54),n2h1(50))
  call Hloop_AW_Q(ntryL,G1H3(106),ex4(:),G1H1(1),m3h3x1(:,37),heltab2x3(:,:,37))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(55),n2h1(51))
  call Hloop_AW_Q(ntryL,G1H3(107),ex4(:),G1H1(1),m3h3x1(:,38),heltab2x3(:,:,38))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(56),n2h1(52))
  call Hloop_AW_Q(ntryL,G1H3(112),ex4(:),G1H1(1),m3h3x1(:,39),heltab2x3(:,:,39))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(57),n2h1(53))
  call Hloop_AW_Q(ntryL,G1H3(113),ex4(:),G1H1(1),m3h3x1(:,40),heltab2x3(:,:,40))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,0,G2tensor(58),n2h1(54))
  call Hloop_AZ_Q(ntryL,G1H3(117),ex3(:),G1H1(1),ngZu,m3h3x1(:,41),heltab2x3(:,:,41))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(59),n2h1(55))
  call Hloop_AZ_Q(ntryL,G1H3(118),ex3(:),G1H1(1),ngZu,m3h3x1(:,42),heltab2x3(:,:,42))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(60),n2h1(56))
  call Hloop_AZ_Q(ntryL,G1H3(123),ex3(:),G1H1(1),ngZu,m3h3x1(:,43),heltab2x3(:,:,43))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(61),n2h1(57))
  call Hloop_AZ_Q(ntryL,G1H3(124),ex3(:),G1H1(1),ngZu,m3h3x1(:,44),heltab2x3(:,:,44))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,0,G2tensor(62),n2h1(58))
  call Hloop_AZ_Q(ntryL,G1H3(128),ex3(:),G1H1(1),ngZu,m3h3x1(:,45),heltab2x3(:,:,45))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(63),n2h1(59))
  call Hloop_AZ_Q(ntryL,G1H3(129),ex3(:),G1H1(1),ngZu,m3h3x1(:,46),heltab2x3(:,:,46))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(64),n2h1(60))
  call Hloop_AZ_Q(ntryL,G1H3(134),ex3(:),G1H1(1),ngZu,m3h3x1(:,47),heltab2x3(:,:,47))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(65),n2h1(61))
  call Hloop_AZ_Q(ntryL,G1H3(135),ex3(:),G1H1(1),ngZu,m3h3x1(:,48),heltab2x3(:,:,48))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,0,G2tensor(66),n2h1(62))
  call Hloop_QZ_A(ntryL,G1H3(139),ex3(:),G1H1(1),ngZu,m3h3x1(:,49),heltab2x3(:,:,49))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(67),n2h1(63))
  call Hloop_QZ_A(ntryL,G1H3(140),ex3(:),G1H1(1),ngZu,m3h3x1(:,50),heltab2x3(:,:,50))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(68),n2h1(64))
  call Hloop_QZ_A(ntryL,G1H3(145),ex3(:),G1H1(1),ngZu,m3h3x1(:,51),heltab2x3(:,:,51))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(69),n2h1(65))
  call Hloop_QZ_A(ntryL,G1H3(146),ex3(:),G1H1(1),ngZu,m3h3x1(:,52),heltab2x3(:,:,52))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),5,0,G2tensor(70),n2h1(66))
  call Hloop_QZ_A(ntryL,G1H3(150),ex3(:),G1H1(1),ngZd,m3h3x1(:,53),heltab2x3(:,:,53))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(71),n2h1(67))
  call Hloop_QZ_A(ntryL,G1H3(151),ex3(:),G1H1(1),ngZd,m3h3x1(:,54),heltab2x3(:,:,54))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(72),n2h1(68))
  call Hloop_QZ_A(ntryL,G1H3(156),ex3(:),G1H1(1),ngZd,m3h3x1(:,55),heltab2x3(:,:,55))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(73),n2h1(69))
  call Hloop_QZ_A(ntryL,G1H3(157),ex3(:),G1H1(1),ngZd,m3h3x1(:,56),heltab2x3(:,:,56))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),5,0,G2tensor(74),n2h1(70))
  call Hloop_QZ_A(ntryL,G1H3(161),ex3(:),G1H1(1),ngZu,m3h3x1(:,57),heltab2x3(:,:,57))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(75),n2h1(71))
  call Hloop_QZ_A(ntryL,G1H3(162),ex3(:),G1H1(1),ngZu,m3h3x1(:,58),heltab2x3(:,:,58))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(76),n2h1(72))
  call Hloop_QZ_A(ntryL,G1H3(167),ex3(:),G1H1(1),ngZu,m3h3x1(:,59),heltab2x3(:,:,59))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(77),n2h1(73))
  call Hloop_QZ_A(ntryL,G1H3(168),ex3(:),G1H1(1),ngZu,m3h3x1(:,60),heltab2x3(:,:,60))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),5,0,G2tensor(78),n2h1(74))
  call Hloop_QZ_A(ntryL,G1H3(172),ex3(:),G1H1(1),ngZd,m3h3x1(:,61),heltab2x3(:,:,61))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(79),n2h1(75))
  call Hloop_QZ_A(ntryL,G1H3(173),ex3(:),G1H1(1),ngZd,m3h3x1(:,62),heltab2x3(:,:,62))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(80),n2h1(76))
  call Hloop_QZ_A(ntryL,G1H3(178),ex3(:),G1H1(1),ngZd,m3h3x1(:,63),heltab2x3(:,:,63))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(81),n2h1(77))
  call Hloop_QZ_A(ntryL,G1H3(179),ex3(:),G1H1(1),ngZd,m3h3x1(:,64),heltab2x3(:,:,64))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),5,0,G2tensor(82),n2h1(78))
  call Hloop_VA_Q(ntryL,G1H2(26),ex2(:),G1H1(1),m3h2x1(:,19),heltab2x2(:,:,19))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,0,G2tensor(83),n2h1(79))
  call Hloop_ZA_Q(ntryL,G1H2(31),ex2(:),G1H1(1),ngZd,m3h2x1(:,20),heltab2x2(:,:,20))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,0,G2tensor(84),n2h1(80))
  call Hloop_AZ_Q(ntryL,G1H3(183),ex3(:),G1H1(1),ngZu,m3h3x1(:,65),heltab2x3(:,:,65))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(85),n2h1(81))
  call Hloop_AZ_Q(ntryL,G1H3(184),ex3(:),G1H1(1),ngZu,m3h3x1(:,66),heltab2x3(:,:,66))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(86),n2h1(82))
  call Hloop_AZ_Q(ntryL,G1H3(189),ex3(:),G1H1(1),ngZu,m3h3x1(:,67),heltab2x3(:,:,67))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(87),n2h1(83))
  call Hloop_AZ_Q(ntryL,G1H3(190),ex3(:),G1H1(1),ngZu,m3h3x1(:,68),heltab2x3(:,:,68))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),6,0,G2tensor(88),n2h1(84))
  call Hloop_AZ_Q(ntryL,G1H3(194),ex3(:),G1H1(1),ngZd,m3h3x1(:,69),heltab2x3(:,:,69))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(89),n2h1(85))
  call Hloop_AZ_Q(ntryL,G1H3(195),ex3(:),G1H1(1),ngZd,m3h3x1(:,70),heltab2x3(:,:,70))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(90),n2h1(86))
  call Hloop_AZ_Q(ntryL,G1H3(200),ex3(:),G1H1(1),ngZd,m3h3x1(:,71),heltab2x3(:,:,71))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(91),n2h1(87))
  call Hloop_AZ_Q(ntryL,G1H3(201),ex3(:),G1H1(1),ngZd,m3h3x1(:,72),heltab2x3(:,:,72))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),6,0,G2tensor(92),n2h1(88))
  call Hloop_AZ_Q(ntryL,G1H3(205),ex3(:),G1H1(1),ngZu,m3h3x1(:,73),heltab2x3(:,:,73))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(93),n2h1(89))
  call Hloop_AZ_Q(ntryL,G1H3(206),ex3(:),G1H1(1),ngZu,m3h3x1(:,74),heltab2x3(:,:,74))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(94),n2h1(90))
  call Hloop_AZ_Q(ntryL,G1H3(211),ex3(:),G1H1(1),ngZu,m3h3x1(:,75),heltab2x3(:,:,75))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(95),n2h1(91))
  call Hloop_AZ_Q(ntryL,G1H3(212),ex3(:),G1H1(1),ngZu,m3h3x1(:,76),heltab2x3(:,:,76))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),6,0,G2tensor(96),n2h1(92))
  call Hloop_AZ_Q(ntryL,G1H3(216),ex3(:),G1H1(1),ngZd,m3h3x1(:,77),heltab2x3(:,:,77))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(97),n2h1(93))
  call Hloop_AZ_Q(ntryL,G1H3(217),ex3(:),G1H1(1),ngZd,m3h3x1(:,78),heltab2x3(:,:,78))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(98),n2h1(94))
  call Hloop_AZ_Q(ntryL,G1H3(222),ex3(:),G1H1(1),ngZd,m3h3x1(:,79),heltab2x3(:,:,79))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(99),n2h1(95))
  call Hloop_AZ_Q(ntryL,G1H3(223),ex3(:),G1H1(1),ngZd,m3h3x1(:,80),heltab2x3(:,:,80))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),6,0,G2tensor(100),n2h1(96))
  call Hloop_WA_Q(ntryL,G1H2(36),ex2(:),G1H1(1),m3h2x1(:,21),heltab2x2(:,:,21))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),6,0,G2tensor(101),n2h1(97))
  call Hloop_WA_Q(ntryL,G1H2(41),ex2(:),G1H1(1),m3h2x1(:,22),heltab2x2(:,:,22))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),6,0,G2tensor(102),n2h1(98))
  call Hotf_5pt_reduction_last(G2tensor(1),RedSet_5(1),mass5set(:,12),  & 
G1tensor(1),G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(5),G1tensor(6))
  call G_TensorShift(G1tensor(2),2)
  call Hotf_5pt_reduction_last(G2tensor(2),RedSet_5(2),mass5set(:,13),  & 
G1tensor(7),G1tensor(8),G1tensor(9),G1tensor(10),G1tensor(11),G1tensor(12))
  call G_TensorShift(G1tensor(8),2)
  call Hotf_5pt_reduction_last(G2tensor(3),RedSet_5(1),mass5set(:,1),  & 
G1tensor(13),G1tensor(14),G1tensor(15),G1tensor(16),G1tensor(17),G1tensor(18))
  call G_TensorShift(G1tensor(14),2)
  call Hotf_5pt_reduction_last(G2tensor(5),RedSet_5(2),mass5set(:,1),  & 
G1tensor(19),G1tensor(20),G1tensor(21),G1tensor(22),G1tensor(23),G1tensor(24))
  call G_TensorShift(G1tensor(20),2)
  call Hotf_5pt_reduction_last(G2tensor(7),RedSet_5(1),mass5set(:,8),  & 
G1tensor(25),G1tensor(26),G1tensor(27),G1tensor(28),G1tensor(29),G1tensor(30))
  call G_TensorShift(G1tensor(26),2)
  call Hotf_5pt_reduction_last(G2tensor(10),RedSet_5(1),mass5set(:,9),  & 
G1tensor(31),G1tensor(32),G1tensor(33),G1tensor(34),G1tensor(35),G1tensor(36))
  call G_TensorShift(G1tensor(32),2)
  call Hotf_5pt_reduction_last(G2tensor(13),RedSet_5(2),mass5set(:,10),  & 
G1tensor(37),G1tensor(38),G1tensor(39),G1tensor(40),G1tensor(41),G1tensor(42))
  call G_TensorShift(G1tensor(38),2)
  call Hotf_5pt_reduction_last(G2tensor(16),RedSet_5(2),mass5set(:,11),  & 
G1tensor(43),G1tensor(44),G1tensor(45),G1tensor(46),G1tensor(47),G1tensor(48))
  call G_TensorShift(G1tensor(44),2)
  call Hotf_5pt_reduction_last(G2tensor(19),RedSet_5(3),mass5set(:,1),  & 
G1tensor(49),G1tensor(50),G1tensor(51),G1tensor(52),G1tensor(53),G1tensor(54))
  call G_TensorShift(G1tensor(50),8)
  call Hotf_5pt_reduction_last(G2tensor(23),RedSet_5(3),mass5set(:,2),  & 
G1tensor(55),G1tensor(56),G1tensor(57),G1tensor(58),G1tensor(59),G1tensor(60))
  call G_TensorShift(G1tensor(56),8)
  call Hotf_5pt_reduction_last(G2tensor(27),RedSet_5(4),mass5set(:,1),  & 
G1tensor(61),G1tensor(62),G1tensor(63),G1tensor(64),G1tensor(65),G1tensor(66))
  call G_TensorShift(G1tensor(62),8)
  call Hotf_5pt_reduction_last(G2tensor(31),RedSet_5(4),mass5set(:,3),  & 
G1tensor(67),G1tensor(68),G1tensor(69),G1tensor(70),G1tensor(71),G1tensor(72))
  call G_TensorShift(G1tensor(68),8)
  call Hotf_5pt_reduction_last(G2tensor(35),RedSet_5(5),mass5set(:,1),  & 
G1tensor(73),G1tensor(74),G1tensor(75),G1tensor(76),G1tensor(77),G1tensor(78))
  call G_TensorShift(G1tensor(74),8)
  call Hotf_5pt_reduction_last(G2tensor(39),RedSet_5(5),mass5set(:,2),  & 
G1tensor(79),G1tensor(80),G1tensor(81),G1tensor(82),G1tensor(83),G1tensor(84))
  call G_TensorShift(G1tensor(80),8)
  call Hotf_5pt_reduction_last(G2tensor(43),RedSet_5(6),mass5set(:,1),  & 
G1tensor(85),G1tensor(86),G1tensor(87),G1tensor(88),G1tensor(89),G1tensor(90))
  call G_TensorShift(G1tensor(86),4)
  call Hotf_5pt_reduction_last(G2tensor(47),RedSet_5(6),mass5set(:,3),  & 
G1tensor(91),G1tensor(92),G1tensor(93),G1tensor(94),G1tensor(95),G1tensor(96))
  call G_TensorShift(G1tensor(92),4)
  call Hotf_5pt_reduction_last(G2tensor(51),RedSet_5(7),mass5set(:,1),  & 
G1tensor(97),G1tensor(98),G1tensor(99),G1tensor(100),G1tensor(101),G1tensor(102))
  call G_TensorShift(G1tensor(98),8)
  call Hotf_5pt_reduction_last(G2tensor(55),RedSet_5(7),mass5set(:,3),  & 
G1tensor(103),G1tensor(104),G1tensor(105),G1tensor(106),G1tensor(107),G1tensor(108))
  call G_TensorShift(G1tensor(104),8)
  call Hotf_5pt_reduction_last(G2tensor(59),RedSet_5(8),mass5set(:,1),  & 
G1tensor(109),G1tensor(110),G1tensor(111),G1tensor(112),G1tensor(113),G1tensor(114))
  call G_TensorShift(G1tensor(110),4)
  call Hotf_5pt_reduction_last(G2tensor(63),RedSet_5(8),mass5set(:,3),  & 
G1tensor(115),G1tensor(116),G1tensor(117),G1tensor(118),G1tensor(119),G1tensor(120))
  call G_TensorShift(G1tensor(116),4)
  call Hotf_5pt_reduction_last(G2tensor(67),RedSet_5(9),mass5set(:,4),  & 
G1tensor(121),G1tensor(122),G1tensor(123),G1tensor(124),G1tensor(125),G1tensor(126))
  call G_TensorShift(G1tensor(122),4)
  call Hotf_5pt_reduction_last(G2tensor(71),RedSet_5(9),mass5set(:,5),  & 
G1tensor(127),G1tensor(128),G1tensor(129),G1tensor(130),G1tensor(131),G1tensor(132))
  call G_TensorShift(G1tensor(128),4)
  call Hotf_5pt_reduction_last(G2tensor(75),RedSet_5(9),mass5set(:,6),  & 
G1tensor(133),G1tensor(134),G1tensor(135),G1tensor(136),G1tensor(137),G1tensor(138))
  call G_TensorShift(G1tensor(134),4)
  call Hotf_5pt_reduction_last(G2tensor(79),RedSet_5(9),mass5set(:,7),  & 
G1tensor(139),G1tensor(140),G1tensor(141),G1tensor(142),G1tensor(143),G1tensor(144))
  call G_TensorShift(G1tensor(140),4)
  call Hotf_5pt_reduction_last(G2tensor(85),RedSet_5(10),mass5set(:,5),  & 
G1tensor(145),G1tensor(146),G1tensor(147),G1tensor(148),G1tensor(149),G1tensor(150))
  call G_TensorShift(G1tensor(146),4)
  call Hotf_5pt_reduction_last(G2tensor(89),RedSet_5(10),mass5set(:,4),  & 
G1tensor(151),G1tensor(152),G1tensor(153),G1tensor(154),G1tensor(155),G1tensor(156))
  call G_TensorShift(G1tensor(152),4)
  call Hotf_5pt_reduction_last(G2tensor(93),RedSet_5(10),mass5set(:,7),  & 
G1tensor(157),G1tensor(158),G1tensor(159),G1tensor(160),G1tensor(161),G1tensor(162))
  call G_TensorShift(G1tensor(158),4)
  call Hotf_5pt_reduction_last(G2tensor(97),RedSet_5(10),mass5set(:,6),  & 
G1tensor(163),G1tensor(164),G1tensor(165),G1tensor(166),G1tensor(167),G1tensor(168))
  call G_TensorShift(G1tensor(164),4)
  call ol_merge_tensors(T1sum(1),[G1tensor(1)])
  call ol_merge_tensors(T1sum(2),[G1tensor(7)])
  call ol_merge_tensors(T1sum(3),[G1tensor(13)])
  call ol_merge_tensors(T1sum(4),[G1tensor(19)])
  call ol_merge_tensors(T1sum(5),[G1tensor(25)])
  call ol_merge_tensors(T1sum(6),[G1tensor(31)])
  call ol_merge_tensors(T1sum(7),[G1tensor(37)])
  call ol_merge_tensors(T1sum(8),[G1tensor(43)])
  call ol_merge_tensors(T1sum(9),[G1tensor(49)])
  call ol_merge_tensors(T1sum(10),[G1tensor(55)])
  call ol_merge_tensors(T1sum(11),[G1tensor(61)])
  call ol_merge_tensors(T1sum(12),[G1tensor(67)])
  call ol_merge_tensors(T1sum(13),[G1tensor(73)])
  call ol_merge_tensors(T1sum(14),[G1tensor(79)])
  call ol_merge_tensors(T1sum(15),[G1tensor(85)])
  call ol_merge_tensors(T1sum(16),[G1tensor(91)])
  call ol_merge_tensors(T1sum(17),[G1tensor(97)])
  call ol_merge_tensors(T1sum(18),[G1tensor(103)])
  call ol_merge_tensors(T1sum(19),[G1tensor(109)])
  call ol_merge_tensors(T1sum(20),[G1tensor(115)])
  call ol_merge_tensors(T1sum(21),[G1tensor(121)])
  call ol_merge_tensors(T1sum(22),[G1tensor(127)])
  call ol_merge_tensors(T1sum(23),[G1tensor(133)])
  call ol_merge_tensors(T1sum(24),[G1tensor(139)])
  call ol_merge_tensors(T1sum(25),[G1tensor(145)])
  call ol_merge_tensors(T1sum(26),[G1tensor(151)])
  call ol_merge_tensors(T1sum(27),[G1tensor(157)])
  call ol_merge_tensors(T1sum(28),[G1tensor(163)])
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(39),h0tab(:,39),[16,1,12,2],[0,0,nMW,0],5,0)
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,39),heltab2x72(:,:,39))
  call Hloop_A_Q(ntryL,G0H36(1),16,0,G1H36(1),n2h36(37))
  Gcoeff(:)%j = (c(17)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(40),h0tab(:,40),[16,1,12,2],[0,nMW,0,0],5,0)
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,40),heltab2x72(:,:,40))
  call Hloop_A_Q(ntryL,G0H36(1),16,0,G1H36(4),n2h36(38))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(41),h0tab(:,41),[16,1,12,2],[0,nMZ,nMW,0],5,0)
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,41),heltab2x72(:,:,41))
  call Hloop_A_Q(ntryL,G0H36(1),16,0,G1H36(7),n2h36(39))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(42),h0tab(:,42),[16,1,12,2],[0,nMW,nMZ,0],5,0)
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,42),heltab2x72(:,:,42))
  call Hloop_A_Q(ntryL,G0H36(1),16,0,G1H36(10),n2h36(40))
  Gcoeff(:)%j = (c(34)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(43),h0tab(:,43),[16,2,8,5],[0,0,0,0],4,1,wf6(:,3))
  call Hloop_UV_W(ntryL,G0H72(1),0,ex5(:),16,G1H36(13),m3h2x36(:,43),heltab2x72(:,:,43))
  Gcoeff(:)%j = (c(32)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(44),h0tab(:,44),[16,2,8,5],[0,nMW,0,0],4,1,wf6(:,3))
  call Hloop_QV_A(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,44),heltab2x72(:,:,44))
  call Hloop_Q_A(ntryL,G0H36(1),16,0,G1H36(16),n2h36(41))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(45),h0tab(:,45),[16,2,8,5],[0,0,nMW,0],4,1,wf6(:,3))
  call Hloop_QV_A(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,45),heltab2x72(:,:,45))
  call Hloop_Q_A(ntryL,G0H36(1),16,0,G1H36(3),n2h36(42))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(46),h0tab(:,46),[16,2,8,5],[0,nMW,nMZ,0],4,1,wf6(:,3))
  call Hloop_QV_A(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,46),heltab2x72(:,:,46))
  call Hloop_Q_A(ntryL,G0H36(1),16,0,G1H36(2),n2h36(43))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(47),h0tab(:,47),[16,2,8,5],[0,nMZ,nMW,0],4,1,wf6(:,3))
  call Hloop_QV_A(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,47),heltab2x72(:,:,47))
  call Hloop_Q_A(ntryL,G0H36(1),16,0,G1H36(6),n2h36(44))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(48),h0tab(:,48),[16,5,2,8],[0,0,0,0],4,1,wf6(:,3))
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,48),heltab2x72(:,:,48))
  call Hloop_A_Q(ntryL,G0H36(1),16,0,G1H36(5),n2h36(45))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(49),h0tab(:,49),[16,5,2,8],[0,nMZ,0,0],4,1,wf6(:,3))
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,49),heltab2x72(:,:,49))
  call Hloop_A_Q(ntryL,G0H36(1),16,0,G1H36(9),n2h36(46))
  Gcoeff(:)%j = (-(c(35)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(50),h0tab(:,50),[16,5,2,8],[0,0,0,0],4,1,wf6(:,3))
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,50),heltab2x72(:,:,50))
  call Hloop_A_Q(ntryL,G0H36(1),16,0,G1H36(8),n2h36(47))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(51),h0tab(:,51),[16,2,5,8],[0,0,0,0],4,1,wf6(:,3))
  call Hloop_QV_A(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,51),heltab2x72(:,:,51))
  call Hloop_Q_A(ntryL,G0H36(1),16,0,G1H36(12),n2h36(48))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(52),h0tab(:,52),[16,2,5,8],[0,nMZ,0,0],4,1,wf6(:,3))
  call Hloop_QV_A(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,52),heltab2x72(:,:,52))
  call Hloop_Q_A(ntryL,G0H36(1),16,0,G1H36(11),n2h36(49))
  Gcoeff(:)%j = (-(c(35)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(53),h0tab(:,53),[16,2,5,8],[0,0,0,0],4,1,wf6(:,3))
  call Hloop_QV_A(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,53),heltab2x72(:,:,53))
  call Hloop_Q_A(ntryL,G0H36(1),16,0,G1H36(15),n2h36(50))
  Gcoeff(:)%j = (-(c(34)*M(2,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(54),h0tab(:,54),[16,1,8,6],[0,0,0,0],4,1,wf6(:,8))
  call Hloop_UV_W(ntryL,G0H72(1),0,ex5(:),16,G1H36(14),m3h2x36(:,54),heltab2x72(:,:,54))
  Gcoeff(:)%j = (c(32)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(55),h0tab(:,55),[16,1,8,6],[0,0,nMW,0],4,1,wf6(:,8))
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,55),heltab2x72(:,:,55))
  call Hloop_A_Q(ntryL,G0H36(1),16,0,G1H36(18),n2h36(51))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(56),h0tab(:,56),[16,1,8,6],[0,nMW,0,0],4,1,wf6(:,8))
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,56),heltab2x72(:,:,56))
  call Hloop_A_Q(ntryL,G0H36(1),16,0,G1H36(17),n2h36(52))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(57),h0tab(:,57),[16,1,8,6],[0,nMZ,nMW,0],4,1,wf6(:,8))
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,57),heltab2x72(:,:,57))
  call Hloop_A_Q(ntryL,G0H36(1),16,0,G1H36(19),n2h36(53))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(58),h0tab(:,58),[16,1,8,6],[0,nMW,nMZ,0],4,1,wf6(:,8))
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,58),heltab2x72(:,:,58))
  call Hloop_A_Q(ntryL,G0H36(1),16,0,G1H36(20),n2h36(54))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(59),h0tab(:,59),[16,6,1,8],[0,0,0,0],4,1,wf6(:,8))
  call Hloop_QV_A(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,59),heltab2x72(:,:,59))
  call Hloop_Q_A(ntryL,G0H36(1),16,0,G1H36(21),n2h36(55))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(60),h0tab(:,60),[16,6,1,8],[0,nMZ,0,0],4,1,wf6(:,8))
  call Hloop_QV_A(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,60),heltab2x72(:,:,60))
  call Hloop_Q_A(ntryL,G0H36(1),16,0,G1H36(22),n2h36(56))
  Gcoeff(:)%j = (-(c(35)*M(2,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(61),h0tab(:,61),[16,6,1,8],[0,0,0,0],4,1,wf6(:,8))
  call Hloop_QV_A(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,61),heltab2x72(:,:,61))
  call Hloop_Q_A(ntryL,G0H36(1),16,0,G1H36(23),n2h36(57))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(62),h0tab(:,62),[16,1,6,8],[0,0,0,0],4,1,wf6(:,8))
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,62),heltab2x72(:,:,62))
  call Hloop_A_Q(ntryL,G0H36(1),16,0,G1H36(24),n2h36(58))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(63),h0tab(:,63),[16,1,6,8],[0,nMZ,0,0],4,1,wf6(:,8))
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,63),heltab2x72(:,:,63))
  call Hloop_A_Q(ntryL,G0H36(1),16,0,G1H36(25),n2h36(59))
  Gcoeff(:)%j = (-(c(35)*M(2,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(64),h0tab(:,64),[16,1,6,8],[0,0,0,0],4,1,wf6(:,8))
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,64),heltab2x72(:,:,64))
  call Hloop_A_Q(ntryL,G0H36(1),16,0,G1H36(26),n2h36(60))
  Gcoeff(:)%j = (c(34)*M(2,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(65),h0tab(:,65),[16,2,4,9],[0,0,0,0],4,1,wf6(:,7))
  call Hloop_UV_W(ntryL,G0H72(1),0,ex5(:),16,G1H36(27),m3h2x36(:,65),heltab2x72(:,:,65))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(66),h0tab(:,66),[16,2,4,9],[0,nMW,nMW,0],4,1,wf6(:,7))
  call Hloop_QV_A(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,66),heltab2x72(:,:,66))
  call Hloop_Q_A(ntryL,G0H36(1),16,0,G1H36(28),n2h36(61))
  Gcoeff(:)%j = (c(28)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(67),h0tab(:,67),[16,4,2,9],[0,0,0,0],4,1,wf6(:,7))
  call Hloop_QV_A(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,67),heltab2x72(:,:,67))
  call Hloop_Q_A(ntryL,G0H36(1),16,0,G1H36(29),n2h36(62))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(68),h0tab(:,68),[16,4,2,9],[0,0,nMZ,0],4,1,wf6(:,7))
  call Hloop_QV_A(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,68),heltab2x72(:,:,68))
  call Hloop_Q_A(ntryL,G0H36(1),16,0,G1H36(30),n2h36(63))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(69),h0tab(:,69),[16,4,2,9],[0,0,nMW,0],4,1,wf6(:,7))
  call Hloop_QV_A(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,69),heltab2x72(:,:,69))
  call Hloop_Q_A(ntryL,G0H36(1),16,0,G1H36(31),n2h36(64))
  Gcoeff(:)%j = (-(c(35)*M(2,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(70),h0tab(:,70),[16,4,2,9],[0,0,0,0],4,1,wf6(:,7))
  call Hloop_QV_A(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,70),heltab2x72(:,:,70))
  call Hloop_Q_A(ntryL,G0H36(1),16,0,G1H36(32),n2h36(65))
  Gcoeff(:)%j = (c(28)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(71),h0tab(:,71),[16,2,9,4],[0,0,0,0],4,1,wf6(:,7))
  call Hloop_QV_A(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,71),heltab2x72(:,:,71))
  call Hloop_Q_A(ntryL,G0H36(1),16,0,G1H36(33),n2h36(66))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(72),h0tab(:,72),[16,2,9,4],[0,nMZ,0,0],4,1,wf6(:,7))
  call Hloop_QV_A(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,72),heltab2x72(:,:,72))
  call Hloop_Q_A(ntryL,G0H36(1),16,0,G1H36(34),n2h36(67))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(73),h0tab(:,73),[16,2,9,4],[0,nMW,0,0],4,1,wf6(:,7))
  call Hloop_QV_A(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,73),heltab2x72(:,:,73))
  call Hloop_Q_A(ntryL,G0H36(1),16,0,G1H36(35),n2h36(68))
  Gcoeff(:)%j = (-(c(35)*M(2,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(74),h0tab(:,74),[16,2,9,4],[0,0,0,0],4,1,wf6(:,7))
  call Hloop_QV_A(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,74),heltab2x72(:,:,74))
  call Hloop_Q_A(ntryL,G0H36(1),16,0,G1H36(36),n2h36(69))
  Gcoeff(:)%j = (-(c(34)*M(2,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(75),h0tab(:,75),[16,1,4,10],[0,0,0,0],4,1,wf6(:,4))
  call Hloop_UV_W(ntryL,G0H72(1),0,ex5(:),16,G1H36(37),m3h2x36(:,75),heltab2x72(:,:,75))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(76),h0tab(:,76),[16,1,4,10],[0,nMW,nMW,0],4,1,wf6(:,4))
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,76),heltab2x72(:,:,76))
  call Hloop_A_Q(ntryL,G0H36(1),16,0,G1H36(38),n2h36(70))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(77),h0tab(:,77),[16,4,1,10],[0,0,0,0],4,1,wf6(:,4))
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,77),heltab2x72(:,:,77))
  call Hloop_A_Q(ntryL,G0H36(1),16,0,G1H36(39),n2h36(71))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(78),h0tab(:,78),[16,4,1,10],[0,0,nMZ,0],4,1,wf6(:,4))
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,78),heltab2x72(:,:,78))
  call Hloop_A_Q(ntryL,G0H36(1),16,0,G1H36(40),n2h36(72))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(79),h0tab(:,79),[16,4,1,10],[0,0,nMW,0],4,1,wf6(:,4))
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,79),heltab2x72(:,:,79))
  call Hloop_A_Q(ntryL,G0H36(1),16,0,G1H36(41),n2h36(73))
  Gcoeff(:)%j = (-(c(35)*M(2,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(80),h0tab(:,80),[16,4,1,10],[0,0,0,0],4,1,wf6(:,4))
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,80),heltab2x72(:,:,80))
  call Hloop_A_Q(ntryL,G0H36(1),16,0,G1H36(42),n2h36(74))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(81),h0tab(:,81),[16,1,10,4],[0,0,0,0],4,1,wf6(:,4))
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,81),heltab2x72(:,:,81))
  call Hloop_A_Q(ntryL,G0H36(1),16,0,G1H36(43),n2h36(75))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(82),h0tab(:,82),[16,1,10,4],[0,nMZ,0,0],4,1,wf6(:,4))
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,82),heltab2x72(:,:,82))
  call Hloop_A_Q(ntryL,G0H36(1),16,0,G1H36(44),n2h36(76))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(83),h0tab(:,83),[16,1,10,4],[0,nMW,0,0],4,1,wf6(:,4))
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,83),heltab2x72(:,:,83))
  call Hloop_A_Q(ntryL,G0H36(1),16,0,G1H36(45),n2h36(77))
  Gcoeff(:)%j = (-(c(35)*M(2,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(84),h0tab(:,84),[16,1,10,4],[0,0,0,0],4,1,wf6(:,4))
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,84),heltab2x72(:,:,84))
  call Hloop_A_Q(ntryL,G0H36(1),16,0,G1H36(46),n2h36(78))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(85),h0tab(:,85),[16,1,2,12],[0,0,0,0],4,1,wf9(:,1))
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,85),heltab2x72(:,:,85))
  call Hloop_A_Q(ntryL,G0H36(1),16,0,G1H36(47),n2h36(79))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(86),h0tab(:,86),[16,1,2,12],[0,nMZ,0,0],4,1,wf9(:,1))
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,86),heltab2x72(:,:,86))
  call Hloop_A_Q(ntryL,G0H36(1),16,0,G1H36(48),n2h36(80))
  Gcoeff(:)%j = (-(c(22)*M(2,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(87),h0tab(:,87),[16,1,2,12],[0,0,0,0],4,1,wf9(:,1))
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,87),heltab2x72(:,:,87))
  call Hloop_A_Q(ntryL,G0H36(1),16,0,G1H36(49),n2h36(81))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(88),h0tab(:,88),[16,2,1,12],[0,0,0,0],4,1,wf9(:,1))
  call Hloop_QV_A(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,88),heltab2x72(:,:,88))
  call Hloop_Q_A(ntryL,G0H36(1),16,0,G1H36(50),n2h36(82))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(89),h0tab(:,89),[16,2,1,12],[0,nMZ,0,0],4,1,wf9(:,1))
  call Hloop_QV_A(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,89),heltab2x72(:,:,89))
  call Hloop_Q_A(ntryL,G0H36(1),16,0,G1H36(51),n2h36(83))
  Gcoeff(:)%j = (-(c(22)*M(2,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(90),h0tab(:,90),[16,2,1,12],[0,0,0,0],4,1,wf9(:,1))
  call Hloop_QV_A(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,90),heltab2x72(:,:,90))
  call Hloop_Q_A(ntryL,G0H36(1),16,0,G1H36(52),n2h36(84))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(91),h0tab(:,91),[16,1,12,2],[0,0,nMW,0],4,1,wf9(:,3))
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,91),heltab2x72(:,:,91))
  call Hloop_A_Q(ntryL,G0H36(1),16,0,G1H36(53),n2h36(85))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(92),h0tab(:,92),[16,1,12,2],[0,nMW,0,0],4,1,wf9(:,3))
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,92),heltab2x72(:,:,92))
  call Hloop_A_Q(ntryL,G0H36(1),16,0,G1H36(54),n2h36(86))
  Gcoeff(:)%j = (-(c(37)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(93),h0tab(:,93),[16,1,12,2],[0,nMZ,nMW,0],4,1,wf9(:,3))
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,93),heltab2x72(:,:,93))
  call Hloop_A_Q(ntryL,G0H36(1),16,0,G1H36(55),n2h36(87))
  Gcoeff(:)%j = (-(c(37)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(94),h0tab(:,94),[16,1,12,2],[0,nMW,nMZ,0],4,1,wf9(:,3))
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,94),heltab2x72(:,:,94))
  call Hloop_A_Q(ntryL,G0H36(1),16,0,G1H36(56),n2h36(88))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(95),h0tab(:,95),[16,1,12,2],[0,0,nMW,0],4,1,wf9(:,1))
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,95),heltab2x72(:,:,95))
  call Hloop_A_Q(ntryL,G0H36(1),16,0,G1H36(57),n2h36(89))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(96),h0tab(:,96),[16,1,12,2],[0,nMW,0,0],4,1,wf9(:,1))
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,96),heltab2x72(:,:,96))
  call Hloop_A_Q(ntryL,G0H36(1),16,0,G1H36(58),n2h36(90))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(97),h0tab(:,97),[16,1,12,2],[0,nMZ,nMW,0],4,1,wf9(:,1))
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,97),heltab2x72(:,:,97))
  call Hloop_A_Q(ntryL,G0H36(1),16,0,G1H36(59),n2h36(91))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(98),h0tab(:,98),[16,1,12,2],[0,nMW,nMZ,0],4,1,wf9(:,1))
  call Hloop_AV_Q(ntryL,G0H72(1),ex5(:),G0H36(1),m3h2x36(:,98),heltab2x72(:,:,98))
  call Hloop_A_Q(ntryL,G0H36(1),16,0,G1H36(60),n2h36(92))
  Gcoeff(:)%j = (-(c(21)*M(2,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(99),h0tab(:,99),[16,1,12,2],[0,0,0,0],4,1,wf9(:,1))
  call Hloop_UV_W(ntryL,G0H72(1),0,ex5(:),16,G1H36(61),m3h2x36(:,99),heltab2x72(:,:,99))
  Gcoeff(:)%j = (c(32)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(100),h0tab(:,100),[17,4,2,8],[0,0,nMW,0],4,1,wf4(:,4))
  call Hloop_VQ_A(ntryL,G0H72(1),wf4(:,4),G0H18(1),m3h4x18(:,1),heltab2x72(:,:,100))
  call Hloop_Q_A(ntryL,G0H18(1),17,0,G1H18(13),n2h18(5))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(101),h0tab(:,101),[17,4,2,8],[0,0,0,nMW],4,1,wf4(:,4))
  call Hloop_WQ_A(ntryL,G0H72(1),wf4(:,4),G0H18(1),m3h4x18(:,2),heltab2x72(:,:,101))
  call Hloop_Q_A(ntryL,G0H18(1),17,0,G1H18(14),n2h18(6))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(102),h0tab(:,102),[17,4,2,8],[0,0,nMW,nMZ],4,1,wf4(:,4))
  call Hloop_ZQ_A(ntryL,G0H72(1),wf4(:,4),G0H18(1),ngZu,m3h4x18(:,3),heltab2x72(:,:,102))
  call Hloop_Q_A(ntryL,G0H18(1),17,0,G1H18(15),n2h18(7))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(103),h0tab(:,103),[17,4,2,8],[0,0,nMZ,nMW],4,1,wf4(:,4))
  call Hloop_WQ_A(ntryL,G0H72(1),wf4(:,4),G0H18(1),m3h4x18(:,4),heltab2x72(:,:,103))
  call Hloop_Q_A(ntryL,G0H18(1),17,0,G1H18(16),n2h18(8))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(104),h0tab(:,104),[17,2,4,8],[0,0,0,0],4,1,wf4(:,4))
  call Hloop_AQ_V(ntryL,G0H72(1),wf4(:,4),G0H18(1),m3h4x18(:,5),heltab2x72(:,:,104))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(105),h0tab(:,105),[17,2,4,8],[nMZ,0,0,0],4,1,wf4(:,4))
  call Hloop_AQ_Z(ntryL,G0H72(1),wf4(:,4),G0H18(2),ngZu,m3h4x18(:,6),heltab2x72(:,:,105))
  Gcoeff(:)%j = (c(36)*M(2,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(106),h0tab(:,106),[17,2,4,8],[0,0,0,0],4,1,wf4(:,4))
  call Hloop_AQ_V(ntryL,G0H72(1),wf4(:,4),G0H18(3),m3h4x18(:,7),heltab2x72(:,:,106))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(107),h0tab(:,107),[17,2,4,8],[0,nMW,nMW,0],4,1,wf4(:,4))
  call Hloop_VQ_A(ntryL,G0H72(1),wf4(:,4),G0H18(4),m3h4x18(:,8),heltab2x72(:,:,107))
  call Hloop_Q_A(ntryL,G0H18(4),17,0,G1H18(17),n2h18(9))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(108),h0tab(:,108),[17,2,4,8],[0,nMZ,nMH,nMW],4,1,wf4(:,4))
  call Hloop_WQ_A(ntryL,G0H72(1),wf4(:,4),G0H18(4),m3h4x18(:,9),heltab2x72(:,:,108))
  call Hloop_Q_A(ntryL,G0H18(4),17,0,G1H18(18),n2h18(10))
  Gcoeff(:)%j = (-(c(37)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(109),h0tab(:,109),[17,2,4,8],[0,nMW,nMW,nMZ],4,1,wf4(:,4))
  call Hloop_ZQ_A(ntryL,G0H72(1),wf4(:,4),G0H18(4),ngZu,m3h4x18(:,10),heltab2x72(:,:,109))
  call Hloop_Q_A(ntryL,G0H18(4),17,0,G1H18(19),n2h18(11))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(110),h0tab(:,110),[17,2,4,8],[0,nMW,nMW,0],4,1,wf4(:,4))
  call Hloop_VQ_A(ntryL,G0H72(1),wf4(:,4),G0H18(4),m3h4x18(:,11),heltab2x72(:,:,110))
  call Hloop_Q_A(ntryL,G0H18(4),17,0,G1H18(20),n2h18(12))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(111),h0tab(:,111),[17,2,4,8],[0,nMW,nMW,nMZ],4,1,wf4(:,4))
  call Hloop_ZQ_A(ntryL,G0H72(1),wf4(:,4),G0H18(4),ngZu,m3h4x18(:,12),heltab2x72(:,:,111))
  call Hloop_Q_A(ntryL,G0H18(4),17,0,G1H18(21),n2h18(13))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(112),h0tab(:,112),[17,2,8,4],[0,0,0,0],4,1,wf4(:,4))
  call Hloop_AQ_V(ntryL,G0H72(1),wf4(:,4),G0H18(4),m3h4x18(:,13),heltab2x72(:,:,112))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(113),h0tab(:,113),[17,2,8,4],[nMZ,0,0,0],4,1,wf4(:,4))
  call Hloop_AQ_Z(ntryL,G0H72(1),wf4(:,4),G0H18(5),ngZu,m3h4x18(:,14),heltab2x72(:,:,113))
  Gcoeff(:)%j = (c(36)*M(2,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(114),h0tab(:,114),[17,2,8,4],[0,0,0,0],4,1,wf4(:,4))
  call Hloop_AQ_V(ntryL,G0H72(1),wf4(:,4),G0H18(6),m3h4x18(:,15),heltab2x72(:,:,114))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(115),h0tab(:,115),[17,2,8,4],[0,0,nMW,nMW],4,1,wf4(:,4))
  call Hloop_WQ_A(ntryL,G0H72(1),wf4(:,4),G0H18(7),m3h4x18(:,16),heltab2x72(:,:,115))
  call Hloop_Q_A(ntryL,G0H18(7),17,0,G1H18(22),n2h18(14))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(116),h0tab(:,116),[17,2,8,4],[0,nMW,nMH,nMZ],4,1,wf4(:,4))
  call Hloop_ZQ_A(ntryL,G0H72(1),wf4(:,4),G0H18(7),ngZu,m3h4x18(:,17),heltab2x72(:,:,116))
  call Hloop_Q_A(ntryL,G0H18(7),17,0,G1H18(23),n2h18(15))
  Gcoeff(:)%j = (-(c(37)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(117),h0tab(:,117),[17,2,8,4],[0,nMZ,nMW,nMW],4,1,wf4(:,4))
  call Hloop_WQ_A(ntryL,G0H72(1),wf4(:,4),G0H18(7),m3h4x18(:,18),heltab2x72(:,:,117))
  call Hloop_Q_A(ntryL,G0H18(7),17,0,G1H18(24),n2h18(16))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(118),h0tab(:,118),[17,2,8,4],[0,0,nMW,nMW],4,1,wf4(:,4))
  call Hloop_WQ_A(ntryL,G0H72(1),wf4(:,4),G0H18(7),m3h4x18(:,19),heltab2x72(:,:,118))
  call Hloop_Q_A(ntryL,G0H18(7),17,0,G1H18(25),n2h18(17))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(119),h0tab(:,119),[17,2,8,4],[0,nMZ,nMW,nMW],4,1,wf4(:,4))
  call Hloop_WQ_A(ntryL,G0H72(1),wf4(:,4),G0H18(7),m3h4x18(:,20),heltab2x72(:,:,119))
  call Hloop_Q_A(ntryL,G0H18(7),17,0,G1H18(26),n2h18(18))
  Gcoeff(:)%j = (c(32)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(120),h0tab(:,120),[18,4,1,8],[0,0,0,nMW],4,1,wf4(:,2))
  call Hloop_WA_Q(ntryL,G0H72(1),wf4(:,2),G0H18(7),m3h4x18(:,21),heltab2x72(:,:,120))
  call Hloop_A_Q(ntryL,G0H18(7),18,0,G1H18(1),n2h18(19))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(121),h0tab(:,121),[18,4,1,8],[0,0,nMW,0],4,1,wf4(:,2))
  call Hloop_VA_Q(ntryL,G0H72(1),wf4(:,2),G0H18(7),m3h4x18(:,22),heltab2x72(:,:,121))
  call Hloop_A_Q(ntryL,G0H18(7),18,0,G1H18(2),n2h18(20))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(122),h0tab(:,122),[18,4,1,8],[0,0,nMZ,nMW],4,1,wf4(:,2))
  call Hloop_WA_Q(ntryL,G0H72(1),wf4(:,2),G0H18(7),m3h4x18(:,23),heltab2x72(:,:,122))
  call Hloop_A_Q(ntryL,G0H18(7),18,0,G1H18(4),n2h18(21))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(123),h0tab(:,123),[18,4,1,8],[0,0,nMW,nMZ],4,1,wf4(:,2))
  call Hloop_ZA_Q(ntryL,G0H72(1),wf4(:,2),G0H18(7),ngZd,m3h4x18(:,24),heltab2x72(:,:,123))
  call Hloop_A_Q(ntryL,G0H18(7),18,0,G1H18(5),n2h18(22))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(124),h0tab(:,124),[18,1,4,8],[0,0,0,0],4,1,wf4(:,2))
  call Hloop_QA_V(ntryL,G0H72(1),wf4(:,2),G0H18(7),m3h4x18(:,25),heltab2x72(:,:,124))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(125),h0tab(:,125),[18,1,4,8],[nMZ,0,0,0],4,1,wf4(:,2))
  call Hloop_QA_Z(ntryL,G0H72(1),wf4(:,2),G0H18(8),ngZd,m3h4x18(:,26),heltab2x72(:,:,125))
  Gcoeff(:)%j = (c(36)*M(2,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(126),h0tab(:,126),[18,1,4,8],[0,0,0,0],4,1,wf4(:,2))
  call Hloop_QA_V(ntryL,G0H72(1),wf4(:,2),G0H18(9),m3h4x18(:,27),heltab2x72(:,:,126))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(127),h0tab(:,127),[18,1,4,8],[0,nMW,nMW,0],4,1,wf4(:,2))
  call Hloop_VA_Q(ntryL,G0H72(1),wf4(:,2),G0H18(10),m3h4x18(:,28),heltab2x72(:,:,127))
  call Hloop_A_Q(ntryL,G0H18(10),18,0,G1H18(6),n2h18(23))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(128),h0tab(:,128),[18,1,4,8],[0,nMZ,nMH,nMW],4,1,wf4(:,2))
  call Hloop_WA_Q(ntryL,G0H72(1),wf4(:,2),G0H18(10),m3h4x18(:,29),heltab2x72(:,:,128))
  call Hloop_A_Q(ntryL,G0H18(10),18,0,G1H18(7),n2h18(24))
  Gcoeff(:)%j = (-(c(37)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(129),h0tab(:,129),[18,1,4,8],[0,nMW,nMW,nMZ],4,1,wf4(:,2))
  call Hloop_ZA_Q(ntryL,G0H72(1),wf4(:,2),G0H18(10),ngZd,m3h4x18(:,30),heltab2x72(:,:,129))
  call Hloop_A_Q(ntryL,G0H18(10),18,0,G1H18(8),n2h18(25))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(130),h0tab(:,130),[18,1,4,8],[0,nMW,nMW,0],4,1,wf4(:,2))
  call Hloop_VA_Q(ntryL,G0H72(1),wf4(:,2),G0H18(10),m3h4x18(:,31),heltab2x72(:,:,130))
  call Hloop_A_Q(ntryL,G0H18(10),18,0,G1H18(10),n2h18(26))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(131),h0tab(:,131),[18,1,4,8],[0,nMW,nMW,nMZ],4,1,wf4(:,2))
  call Hloop_ZA_Q(ntryL,G0H72(1),wf4(:,2),G0H18(10),ngZd,m3h4x18(:,32),heltab2x72(:,:,131))
  call Hloop_A_Q(ntryL,G0H18(10),18,0,G1H18(11),n2h18(27))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(132),h0tab(:,132),[18,1,8,4],[0,0,0,0],4,1,wf4(:,2))
  call Hloop_QA_V(ntryL,G0H72(1),wf4(:,2),G0H18(10),m3h4x18(:,33),heltab2x72(:,:,132))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(133),h0tab(:,133),[18,1,8,4],[nMZ,0,0,0],4,1,wf4(:,2))
  call Hloop_QA_Z(ntryL,G0H72(1),wf4(:,2),G0H18(11),ngZd,m3h4x18(:,34),heltab2x72(:,:,133))
  Gcoeff(:)%j = (c(36)*M(2,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(134),h0tab(:,134),[18,1,8,4],[0,0,0,0],4,1,wf4(:,2))
  call Hloop_QA_V(ntryL,G0H72(1),wf4(:,2),G0H18(12),m3h4x18(:,35),heltab2x72(:,:,134))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(135),h0tab(:,135),[18,1,8,4],[0,0,nMW,nMW],4,1,wf4(:,2))
  call Hloop_WA_Q(ntryL,G0H72(1),wf4(:,2),G0H18(13),m3h4x18(:,36),heltab2x72(:,:,135))
  call Hloop_A_Q(ntryL,G0H18(13),18,0,G1H18(12),n2h18(28))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(136),h0tab(:,136),[18,1,8,4],[0,nMW,nMH,nMZ],4,1,wf4(:,2))
  call Hloop_ZA_Q(ntryL,G0H72(1),wf4(:,2),G0H18(13),ngZd,m3h4x18(:,37),heltab2x72(:,:,136))
  call Hloop_A_Q(ntryL,G0H18(13),18,0,G1H18(27),n2h18(29))
  Gcoeff(:)%j = (-(c(37)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(137),h0tab(:,137),[18,1,8,4],[0,nMZ,nMW,nMW],4,1,wf4(:,2))
  call Hloop_WA_Q(ntryL,G0H72(1),wf4(:,2),G0H18(13),m3h4x18(:,38),heltab2x72(:,:,137))
  call Hloop_A_Q(ntryL,G0H18(13),18,0,G1H18(28),n2h18(30))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(138),h0tab(:,138),[18,1,8,4],[0,0,nMW,nMW],4,1,wf4(:,2))
  call Hloop_WA_Q(ntryL,G0H72(1),wf4(:,2),G0H18(13),m3h4x18(:,39),heltab2x72(:,:,138))
  call Hloop_A_Q(ntryL,G0H18(13),18,0,G1H18(29),n2h18(31))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H72(1),m0h(139),h0tab(:,139),[18,1,8,4],[0,nMZ,nMW,nMW],4,1,wf4(:,2))
  call Hloop_WA_Q(ntryL,G0H72(1),wf4(:,2),G0H18(13),m3h4x18(:,40),heltab2x72(:,:,139))
  call Hloop_A_Q(ntryL,G0H18(13),18,0,G1H18(30),n2h18(32))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H36(8),[G1H36(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H36(15),[G1H36(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H36(23),[G1H36(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H36(26),[G1H36(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H36(32),[G1H36(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H36(36),[G1H36(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H36(42),[G1H36(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H36(46),[G1H36(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H36(49),[G1H36(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H36(52),[G1H36(50)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H18(3),[G0H18(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H18(6),[G0H18(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H18(9),[G0H18(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H18(12),[G0H18(10)])
  call Hloop_QZ_A(ntryL,G1H18(3),ex3(:),G1H6(101),ngZu,m3h3x6(:,27),heltab2x18(:,:,37))
  call Hloop_Q_A(ntryL,G1H6(101),21,0,G2H6(17),n2h6(31))
  call Hloop_QW_A(ntryL,G1H18(9),ex4(:),G1H6(102),m3h3x6(:,28),heltab2x18(:,:,38))
  call Hloop_Q_A(ntryL,G1H6(102),25,0,G2H6(19),n2h6(32))
  call Hloop_AQ_V(ntryL,G1H36(1),ex1(:),G1H18(3),m3h2x18(:,29),heltab2x36(:,:,33))
  call Hloop_AQ_W(ntryL,G1H36(4),ex1(:),G1H18(9),m3h2x18(:,30),heltab2x36(:,:,34))
  call Hloop_AQ_Z(ntryL,G1H36(7),ex1(:),G1H18(31),ngZu,m3h2x18(:,31),heltab2x36(:,:,35))
  call Hloop_AQ_W(ntryL,G1H36(10),ex1(:),G1H18(32),m3h2x18(:,32),heltab2x36(:,:,36))
  call Hloop_VA_Q(ntryL,G1H36(13),ex2(:),G1H18(33),m3h2x18(:,33),heltab2x36(:,:,37))
  call Hloop_A_Q(ntryL,G1H18(33),18,0,G2H18(1),n2h18(33))
  call Hloop_QA_W(ntryL,G1H36(16),ex2(:),G1H18(33),m3h2x18(:,34),heltab2x36(:,:,38))
  call Hloop_QA_V(ntryL,G1H36(3),ex2(:),G1H18(34),m3h2x18(:,35),heltab2x36(:,:,39))
  call Hloop_QA_W(ntryL,G1H36(2),ex2(:),G1H18(35),m3h2x18(:,36),heltab2x36(:,:,40))
  call Hloop_QA_Z(ntryL,G1H36(6),ex2(:),G1H18(36),ngZd,m3h2x18(:,37),heltab2x36(:,:,41))
  call Hloop_AQ_V(ntryL,G1H36(8),wf6(:,3),G1H6(117),m3h6x6(:,1),heltab2x36(:,:,42))
  call Hloop_AQ_Z(ntryL,G1H36(9),wf6(:,3),G1H6(118),ngZu,m3h6x6(:,2),heltab2x36(:,:,43))
  call Hloop_QA_V(ntryL,G1H36(15),ex2(:),G1H18(37),m3h2x18(:,38),heltab2x36(:,:,44))
  call Hloop_QA_Z(ntryL,G1H36(11),ex2(:),G1H18(38),ngZd,m3h2x18(:,39),heltab2x36(:,:,45))
  call Hloop_VQ_A(ntryL,G1H36(14),ex1(:),G1H18(39),m3h2x18(:,40),heltab2x36(:,:,46))
  call Hloop_Q_A(ntryL,G1H18(39),17,0,G2H18(2),n2h18(34))
  call Hloop_AQ_V(ntryL,G1H36(18),ex1(:),G1H18(39),m3h2x18(:,41),heltab2x36(:,:,47))
  call Hloop_AQ_W(ntryL,G1H36(17),ex1(:),G1H18(40),m3h2x18(:,42),heltab2x36(:,:,48))
  call Hloop_AQ_Z(ntryL,G1H36(19),ex1(:),G1H18(41),ngZu,m3h2x18(:,43),heltab2x36(:,:,49))
  call Hloop_AQ_W(ntryL,G1H36(20),ex1(:),G1H18(42),m3h2x18(:,44),heltab2x36(:,:,50))
  call Hloop_QA_V(ntryL,G1H36(23),wf6(:,8),G1H6(7),m3h6x6(:,3),heltab2x36(:,:,51))
  call Hloop_QA_Z(ntryL,G1H36(22),wf6(:,8),G1H6(8),ngZd,m3h6x6(:,4),heltab2x36(:,:,52))
  call Hloop_AQ_V(ntryL,G1H36(26),ex1(:),G1H18(43),m3h2x18(:,45),heltab2x36(:,:,53))
  call Hloop_AQ_Z(ntryL,G1H36(25),ex1(:),G1H18(44),ngZu,m3h2x18(:,46),heltab2x36(:,:,54))
  call Hloop_VA_Q(ntryL,G1H36(27),ex2(:),G1H18(45),m3h2x18(:,47),heltab2x36(:,:,55))
  call Hloop_A_Q(ntryL,G1H18(45),18,0,G2H18(3),n2h18(35))
  call Hloop_QA_W(ntryL,G1H36(28),ex2(:),G1H18(45),m3h2x18(:,48),heltab2x36(:,:,56))
  call Hloop_QZ_A(ntryL,G1H36(32),ex3(:),G1H12(1),ngZd,m3h3x12(:,5),heltab2x36(:,:,57))
  call Hloop_Q_A(ntryL,G1H12(1),20,0,G2H12(1),n2h12(5))
  call Hloop_QZ_A(ntryL,G1H36(30),ex3(:),G1H12(1),ngZd,m3h3x12(:,6),heltab2x36(:,:,58))
  call Hloop_Q_A(ntryL,G1H12(1),20,0,G2H12(2),n2h12(6))
  call Hloop_QZ_A(ntryL,G1H36(31),ex3(:),G1H12(1),ngZu,m3h3x12(:,7),heltab2x36(:,:,59))
  call Hloop_Q_A(ntryL,G1H12(1),20,0,G2H12(3),n2h12(7))
  call Hloop_QA_V(ntryL,G1H36(36),ex2(:),G1H18(46),m3h2x18(:,49),heltab2x36(:,:,60))
  call Hloop_QA_Z(ntryL,G1H36(34),ex2(:),G1H18(47),ngZd,m3h2x18(:,50),heltab2x36(:,:,61))
  call Hloop_QA_W(ntryL,G1H36(35),ex2(:),G1H18(48),m3h2x18(:,51),heltab2x36(:,:,62))
  call Hloop_VQ_A(ntryL,G1H36(37),ex1(:),G1H18(49),m3h2x18(:,52),heltab2x36(:,:,63))
  call Hloop_Q_A(ntryL,G1H18(49),17,0,G2H18(4),n2h18(36))
  call Hloop_AQ_W(ntryL,G1H36(38),ex1(:),G1H18(49),m3h2x18(:,53),heltab2x36(:,:,64))
  call Hloop_AZ_Q(ntryL,G1H36(42),ex3(:),G1H12(1),ngZu,m3h3x12(:,8),heltab2x36(:,:,65))
  call Hloop_A_Q(ntryL,G1H12(1),20,0,G2H12(4),n2h12(8))
  call Hloop_AZ_Q(ntryL,G1H36(40),ex3(:),G1H12(1),ngZu,m3h3x12(:,9),heltab2x36(:,:,66))
  call Hloop_A_Q(ntryL,G1H12(1),20,0,G2H12(5),n2h12(9))
  call Hloop_AZ_Q(ntryL,G1H36(41),ex3(:),G1H12(1),ngZd,m3h3x12(:,10),heltab2x36(:,:,67))
  call Hloop_A_Q(ntryL,G1H12(1),20,0,G2H12(6),n2h12(10))
  call Hloop_AQ_V(ntryL,G1H36(46),ex1(:),G1H18(50),m3h2x18(:,54),heltab2x36(:,:,68))
  call Hloop_AQ_Z(ntryL,G1H36(44),ex1(:),G1H18(51),ngZu,m3h2x18(:,55),heltab2x36(:,:,69))
  call Hloop_AQ_W(ntryL,G1H36(45),ex1(:),G1H18(52),m3h2x18(:,56),heltab2x36(:,:,70))
  call Hloop_AQ_V(ntryL,G1H36(49),ex1(:),G1H18(53),m3h2x18(:,57),heltab2x36(:,:,71))
  call Hloop_AQ_Z(ntryL,G1H36(48),ex1(:),G1H18(54),ngZu,m3h2x18(:,58),heltab2x36(:,:,72))
  call Hloop_QA_V(ntryL,G1H36(52),ex2(:),G1H18(55),m3h2x18(:,59),heltab2x36(:,:,73))
  call Hloop_QA_Z(ntryL,G1H36(51),ex2(:),G1H18(56),ngZd,m3h2x18(:,60),heltab2x36(:,:,74))
  call Hloop_AQ_V(ntryL,G1H36(53),ex1(:),G1H18(57),m3h2x18(:,61),heltab2x36(:,:,75))
  call Hloop_AQ_W(ntryL,G1H36(54),ex1(:),G1H18(58),m3h2x18(:,62),heltab2x36(:,:,76))
  call Hloop_AQ_Z(ntryL,G1H36(55),ex1(:),G1H18(59),ngZu,m3h2x18(:,63),heltab2x36(:,:,77))
  call Hloop_AQ_W(ntryL,G1H36(56),ex1(:),G1H18(60),m3h2x18(:,64),heltab2x36(:,:,78))
  call Hloop_AQ_V(ntryL,G1H36(57),ex1(:),G1H18(61),m3h2x18(:,65),heltab2x36(:,:,79))
  call Hloop_AQ_W(ntryL,G1H36(58),ex1(:),G1H18(62),m3h2x18(:,66),heltab2x36(:,:,80))
  call Hloop_AQ_Z(ntryL,G1H36(59),ex1(:),G1H18(63),ngZu,m3h2x18(:,67),heltab2x36(:,:,81))
  call Hloop_AQ_W(ntryL,G1H36(60),ex1(:),G1H18(64),m3h2x18(:,68),heltab2x36(:,:,82))
  call Hloop_VQ_A(ntryL,G1H36(61),ex1(:),G1H18(65),m3h2x18(:,69),heltab2x36(:,:,83))
  call Hloop_Q_A(ntryL,G1H18(65),17,0,G2H18(5),n2h18(37))
  call Hloop_QZ_A(ntryL,G1H18(13),ex3(:),G1H6(11),ngZu,m3h3x6(:,29),heltab2x18(:,:,39))
  call Hloop_Q_A(ntryL,G1H6(11),21,0,G2H6(20),n2h6(33))
  call Hloop_QZ_A(ntryL,G1H18(14),ex3(:),G1H6(12),ngZd,m3h3x6(:,30),heltab2x18(:,:,40))
  call Hloop_Q_A(ntryL,G1H6(12),21,0,G2H6(21),n2h6(34))
  call Hloop_QZ_A(ntryL,G1H18(15),ex3(:),G1H6(13),ngZu,m3h3x6(:,31),heltab2x18(:,:,41))
  call Hloop_Q_A(ntryL,G1H6(13),21,0,G2H6(23),n2h6(35))
  call Hloop_QZ_A(ntryL,G1H18(16),ex3(:),G1H6(14),ngZd,m3h3x6(:,32),heltab2x18(:,:,42))
  call Hloop_Q_A(ntryL,G1H6(14),21,0,G2H6(24),n2h6(36))
  call Hloop_VA_Q(ntryL,G0H18(3),ex2(:),G0H9(1),m3h2x9(:,11),heltab2x18(:,:,43))
  call Hloop_A_Q(ntryL,G0H9(1),19,0,G1H9(3),n2h9(17))
  call Hloop_ZA_Q(ntryL,G0H18(2),ex2(:),G0H9(1),ngZd,m3h2x9(:,12),heltab2x18(:,:,44))
  call Hloop_A_Q(ntryL,G0H9(1),19,0,G1H9(4),n2h9(18))
  call Hloop_QA_W(ntryL,G1H18(17),ex2(:),G1H9(7),m3h2x9(:,13),heltab2x18(:,:,45))
  call Hloop_QA_Z(ntryL,G1H18(18),ex2(:),G1H9(8),ngZd,m3h2x9(:,14),heltab2x18(:,:,46))
  call Hloop_QA_W(ntryL,G1H18(19),ex2(:),G1H9(9),m3h2x9(:,15),heltab2x18(:,:,47))
  call Hloop_QA_W(ntryL,G1H18(20),ex2(:),G1H9(10),m3h2x9(:,16),heltab2x18(:,:,48))
  call Hloop_QA_W(ntryL,G1H18(21),ex2(:),G1H9(13),m3h2x9(:,17),heltab2x18(:,:,49))
  call Hloop_VA_Q(ntryL,G0H18(6),ex2(:),G0H9(1),m3h2x9(:,18),heltab2x18(:,:,50))
  call Hloop_A_Q(ntryL,G0H9(1),19,0,G1H9(14),n2h9(19))
  call Hloop_ZA_Q(ntryL,G0H18(5),ex2(:),G0H9(1),ngZd,m3h2x9(:,19),heltab2x18(:,:,51))
  call Hloop_A_Q(ntryL,G0H9(1),19,0,G1H9(15),n2h9(20))
  call Hloop_QA_V(ntryL,G1H18(22),ex2(:),G1H9(16),m3h2x9(:,20),heltab2x18(:,:,52))
  call Hloop_QA_W(ntryL,G1H18(23),ex2(:),G1H9(19),m3h2x9(:,21),heltab2x18(:,:,53))
  call Hloop_QA_Z(ntryL,G1H18(24),ex2(:),G1H9(20),ngZd,m3h2x9(:,22),heltab2x18(:,:,54))
  call Hloop_QA_V(ntryL,G1H18(25),ex2(:),G1H9(21),m3h2x9(:,23),heltab2x18(:,:,55))
  call Hloop_QA_Z(ntryL,G1H18(26),ex2(:),G1H9(22),ngZd,m3h2x9(:,24),heltab2x18(:,:,56))
  call Hloop_AZ_Q(ntryL,G1H18(1),ex3(:),G1H6(17),ngZu,m3h3x6(:,33),heltab2x18(:,:,57))
  call Hloop_A_Q(ntryL,G1H6(17),22,0,G2H6(1),n2h6(37))
  call Hloop_AZ_Q(ntryL,G1H18(2),ex3(:),G1H6(18),ngZd,m3h3x6(:,34),heltab2x18(:,:,58))
  call Hloop_A_Q(ntryL,G1H6(18),22,0,G2H6(2),n2h6(38))
  call Hloop_AZ_Q(ntryL,G1H18(4),ex3(:),G1H6(19),ngZu,m3h3x6(:,35),heltab2x18(:,:,59))
  call Hloop_A_Q(ntryL,G1H6(19),22,0,G2H6(3),n2h6(39))
  call Hloop_AZ_Q(ntryL,G1H18(5),ex3(:),G1H6(20),ngZd,m3h3x6(:,36),heltab2x18(:,:,60))
  call Hloop_A_Q(ntryL,G1H6(20),22,0,G2H6(4),n2h6(40))
  call Hloop_VQ_A(ntryL,G0H18(9),ex1(:),G0H9(1),m3h2x9(:,25),heltab2x18(:,:,61))
  call Hloop_Q_A(ntryL,G0H9(1),19,0,G1H9(25),n2h9(21))
  call Hloop_ZQ_A(ntryL,G0H18(8),ex1(:),G0H9(1),ngZu,m3h2x9(:,26),heltab2x18(:,:,62))
  call Hloop_Q_A(ntryL,G0H9(1),19,0,G1H9(26),n2h9(22))
  call Hloop_AQ_W(ntryL,G1H18(6),ex1(:),G1H9(27),m3h2x9(:,27),heltab2x18(:,:,63))
  call Hloop_AQ_Z(ntryL,G1H18(7),ex1(:),G1H9(28),ngZu,m3h2x9(:,28),heltab2x18(:,:,64))
  call Hloop_AQ_W(ntryL,G1H18(8),ex1(:),G1H9(31),m3h2x9(:,29),heltab2x18(:,:,65))
  call Hloop_AQ_W(ntryL,G1H18(10),ex1(:),G1H9(32),m3h2x9(:,30),heltab2x18(:,:,66))
  call Hloop_AQ_W(ntryL,G1H18(11),ex1(:),G1H9(33),m3h2x9(:,31),heltab2x18(:,:,67))
  call Hloop_VQ_A(ntryL,G0H18(12),ex1(:),G0H9(1),m3h2x9(:,32),heltab2x18(:,:,68))
  call Hloop_Q_A(ntryL,G0H9(1),19,0,G1H9(34),n2h9(23))
  call Hloop_ZQ_A(ntryL,G0H18(11),ex1(:),G0H9(1),ngZu,m3h2x9(:,33),heltab2x18(:,:,69))
  call Hloop_Q_A(ntryL,G0H9(1),19,0,G1H9(37),n2h9(24))
  call Hloop_AQ_V(ntryL,G1H18(12),ex1(:),G1H9(38),m3h2x9(:,34),heltab2x18(:,:,70))
  call Hloop_AQ_W(ntryL,G1H18(27),ex1(:),G1H9(39),m3h2x9(:,35),heltab2x18(:,:,71))
  call Hloop_AQ_Z(ntryL,G1H18(28),ex1(:),G1H9(40),ngZu,m3h2x9(:,36),heltab2x18(:,:,72))
  call Hloop_AQ_V(ntryL,G1H18(29),ex1(:),G1H9(43),m3h2x9(:,37),heltab2x18(:,:,73))
  call Hloop_AQ_Z(ntryL,G1H18(30),ex1(:),G1H9(44),ngZu,m3h2x9(:,38),heltab2x18(:,:,74))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H9(25),[G1H9(5)])
call HGT_w2_OLR(G1H9(1),1,1,9)
call HGT_w2_invQ_OLR(G1H9(1),2,5,9)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H9(1),[G1H9(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(18),[G1H6(100)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H9(34),[G1H9(17)])
call HGT_w2_OLR(G1H9(2),1,1,9)
call HGT_w2_invQ_OLR(G1H9(2),2,5,9)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H9(2),[G1H9(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(22),[G1H6(116)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(117),[G1H6(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(118),[G1H6(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H9(12),[G1H9(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H9(26),[G1H9(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(7),[G1H6(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(8),[G1H6(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H9(24),[G1H9(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H9(37),[G1H9(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H9(3),[G1H9(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H9(36),[G1H9(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H9(4),[G1H9(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H9(14),[G1H9(41)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H9(48),[G1H9(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H9(15),[G1H9(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(52),[G1H6(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(79),[G1H6(67)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(94),[G1H6(88)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(17),[G1H6(99)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(19),[G1H6(115)])
  call Hloop_QZ_A(ntryL,G1H9(1),ex3(:),G1H3(12),ngZu,m3h3x3(:,33),heltab2x9(:,:,33))
  call Hloop_Q_A(ntryL,G1H3(12),23,0,G2H3(1),n2h3(61))
  call Hotf_4pt_reduction(G2H6(18),RedSet_4(10),mass4set(:,1),  & 
G1H6(23),G1H6(24),G1H6(25),G1H6(26),G1H6(29),6)
  call HG1shiftOLR(G1H6(24),2,6)
  call Hloop_QW_A(ntryL,G1H9(2),ex4(:),G1H3(23),m3h3x3(:,34),heltab2x9(:,:,34))
  call Hloop_Q_A(ntryL,G1H3(23),27,0,G2H3(3),n2h3(62))
  call Hotf_4pt_reduction(G2H6(22),RedSet_4(13),mass4set(:,1),  & 
G1H6(30),G1H6(31),G1H6(32),G1H6(35),G1H6(36),6)
  call HG1shiftOLR(G1H6(31),2,6)
  call Hloop_VA_Q(ntryL,G1H6(9),ex2(:),G1H3(34),m3h2x3(:,47),heltab2x6(:,:,87))
  call Hloop_A_Q(ntryL,G1H3(34),23,0,G2H3(4),n2h3(63))
  call Hloop_VA_Q(ntryL,G1H6(117),ex2(:),G1H3(45),m3h2x3(:,48),heltab2x6(:,:,88))
  call Hloop_A_Q(ntryL,G1H3(45),23,0,G2H3(6),n2h3(64))
  call Hloop_ZA_Q(ntryL,G1H6(15),ex2(:),G1H3(56),ngZd,m3h2x3(:,49),heltab2x6(:,:,89))
  call Hloop_A_Q(ntryL,G1H3(56),23,0,G2H3(7),n2h3(65))
  call Hloop_ZA_Q(ntryL,G1H6(118),ex2(:),G1H3(67),ngZd,m3h2x3(:,50),heltab2x6(:,:,90))
  call Hloop_A_Q(ntryL,G1H3(67),23,0,G2H3(10),n2h3(66))
  call Hloop_QZ_A(ntryL,G1H9(12),ex3(:),G1H3(78),ngZu,m3h3x3(:,35),heltab2x9(:,:,35))
  call Hloop_Q_A(ntryL,G1H3(78),23,0,G2H3(11),n2h3(67))
  call Hloop_QZ_A(ntryL,G1H9(26),ex3(:),G1H3(89),ngZu,m3h3x3(:,36),heltab2x9(:,:,36))
  call Hloop_Q_A(ntryL,G1H3(89),23,0,G2H3(14),n2h3(68))
  call Hloop_VQ_A(ntryL,G1H6(21),ex1(:),G1H3(100),m3h2x3(:,51),heltab2x6(:,:,91))
  call Hloop_Q_A(ntryL,G1H3(100),23,0,G2H3(15),n2h3(69))
  call Hloop_VQ_A(ntryL,G1H6(7),ex1(:),G1H3(111),m3h2x3(:,52),heltab2x6(:,:,92))
  call Hloop_Q_A(ntryL,G1H3(111),23,0,G2H3(17),n2h3(70))
  call Hloop_ZQ_A(ntryL,G1H6(27),ex1(:),G1H3(122),ngZu,m3h2x3(:,53),heltab2x6(:,:,93))
  call Hloop_Q_A(ntryL,G1H3(122),23,0,G2H3(18),n2h3(71))
  call Hloop_ZQ_A(ntryL,G1H6(8),ex1(:),G1H3(133),ngZu,m3h2x3(:,54),heltab2x6(:,:,94))
  call Hloop_Q_A(ntryL,G1H3(133),23,0,G2H3(20),n2h3(72))
  call Hloop_QW_A(ntryL,G1H9(24),ex4(:),G1H3(144),m3h3x3(:,37),heltab2x9(:,:,37))
  call Hloop_Q_A(ntryL,G1H3(144),27,0,G2H3(21),n2h3(73))
  call Hloop_QW_A(ntryL,G1H9(37),ex4(:),G1H3(155),m3h3x3(:,38),heltab2x9(:,:,38))
  call Hloop_Q_A(ntryL,G1H3(155),27,0,G2H3(24),n2h3(74))
  call Hloop_AZ_Q(ntryL,G1H9(3),ex3(:),G1H3(166),ngZd,m3h3x3(:,39),heltab2x9(:,:,39))
  call Hloop_A_Q(ntryL,G1H3(166),23,0,G2H3(25),n2h3(75))
  call Hloop_AZ_Q(ntryL,G1H9(36),ex3(:),G1H3(177),ngZd,m3h3x3(:,40),heltab2x9(:,:,40))
  call Hloop_A_Q(ntryL,G1H3(177),23,0,G2H3(28),n2h3(76))
  call Hloop_AZ_Q(ntryL,G1H9(4),ex3(:),G1H3(188),ngZd,m3h3x3(:,41),heltab2x9(:,:,41))
  call Hloop_A_Q(ntryL,G1H3(188),23,0,G2H3(29),n2h3(77))
  call Hloop_AW_Q(ntryL,G1H9(14),ex4(:),G1H3(199),m3h3x3(:,42),heltab2x9(:,:,42))
  call Hloop_A_Q(ntryL,G1H3(199),27,0,G2H3(32),n2h3(78))
  call Hloop_AW_Q(ntryL,G1H9(48),ex4(:),G1H3(210),m3h3x3(:,43),heltab2x9(:,:,43))
  call Hloop_A_Q(ntryL,G1H3(210),27,0,G2H3(33),n2h3(79))
  call Hloop_AW_Q(ntryL,G1H9(15),ex4(:),G1H3(221),m3h3x3(:,44),heltab2x9(:,:,44))
  call Hloop_A_Q(ntryL,G1H3(221),27,0,G2H3(36),n2h3(80))
  call Hloop_VQ_A(ntryL,G1H6(33),ex1(:),G1H3(7),m3h2x3(:,55),heltab2x6(:,:,95))
  call Hloop_Q_A(ntryL,G1H3(7),27,0,G2H3(37),n2h3(81))
  call Hloop_VQ_A(ntryL,G1H6(34),ex1(:),G1H3(8),m3h2x3(:,56),heltab2x6(:,:,96))
  call Hloop_Q_A(ntryL,G1H3(8),27,0,G2H3(40),n2h3(82))
  call Hloop_WQ_A(ntryL,G1H6(39),ex1(:),G1H3(13),m3h2x3(:,57),heltab2x6(:,:,97))
  call Hloop_Q_A(ntryL,G1H3(13),27,0,G2H3(41),n2h3(83))
  call Hloop_WQ_A(ntryL,G1H6(52),ex1(:),G1H3(14),m3h2x3(:,58),heltab2x6(:,:,98))
  call Hloop_Q_A(ntryL,G1H3(14),27,0,G2H3(44),n2h3(84))
  call Hloop_ZQ_A(ntryL,G1H6(45),ex1(:),G1H3(18),ngZu,m3h2x3(:,59),heltab2x6(:,:,99))
  call Hloop_Q_A(ntryL,G1H3(18),27,0,G2H3(45),n2h3(85))
  call Hloop_ZQ_A(ntryL,G1H6(46),ex1(:),G1H3(19),ngZu,m3h2x3(:,60),heltab2x6(:,:,100))
  call Hloop_Q_A(ntryL,G1H3(19),27,0,G2H3(47),n2h3(86))
  call Hloop_WQ_A(ntryL,G1H6(51),ex1(:),G1H3(24),m3h2x3(:,61),heltab2x6(:,:,101))
  call Hloop_Q_A(ntryL,G1H3(24),27,0,G2H3(48),n2h3(87))
  call Hloop_UV_W(ntryL,G1H6(3),21,ex4(:),8,G2H2(9),m3h3x2(:,41),heltab2x6(:,:,102))
  call Hloop_UV_W(ntryL,G1H6(55),21,ex4(:),8,G2H2(12),m3h3x2(:,42),heltab2x6(:,:,103))
  call Hloop_UV_W(ntryL,G1H6(60),21,ex4(:),8,G2H2(19),m3h3x2(:,43),heltab2x6(:,:,104))
  call Hloop_UV_W(ntryL,G1H6(61),21,ex4(:),8,G2H2(22),m3h3x2(:,44),heltab2x6(:,:,105))
  call Hloop_WA_Q(ntryL,G1H6(66),ex2(:),G1H3(25),m3h2x3(:,62),heltab2x6(:,:,106))
  call Hloop_A_Q(ntryL,G1H3(25),27,0,G2H3(50),n2h3(88))
  call Hloop_WA_Q(ntryL,G1H6(79),ex2(:),G1H3(29),m3h2x3(:,63),heltab2x6(:,:,107))
  call Hloop_A_Q(ntryL,G1H3(29),27,0,G2H3(51),n2h3(89))
  call Hloop_VA_Q(ntryL,G1H6(72),ex2(:),G1H3(30),m3h2x3(:,64),heltab2x6(:,:,108))
  call Hloop_A_Q(ntryL,G1H3(30),27,0,G2H3(53),n2h3(90))
  call Hloop_VA_Q(ntryL,G1H6(73),ex2(:),G1H3(35),m3h2x3(:,65),heltab2x6(:,:,109))
  call Hloop_A_Q(ntryL,G1H3(35),27,0,G2H3(54),n2h3(91))
  call Hloop_WA_Q(ntryL,G1H6(78),ex2(:),G1H3(36),m3h2x3(:,66),heltab2x6(:,:,110))
  call Hloop_A_Q(ntryL,G1H3(36),27,0,G2H3(56),n2h3(92))
  call Hloop_ZA_Q(ntryL,G1H6(84),ex2(:),G1H3(40),ngZd,m3h2x3(:,67),heltab2x6(:,:,111))
  call Hloop_A_Q(ntryL,G1H3(40),27,0,G2H3(59),n2h3(93))
  call Hloop_ZA_Q(ntryL,G1H6(85),ex2(:),G1H3(41),ngZd,m3h2x3(:,68),heltab2x6(:,:,112))
  call Hloop_A_Q(ntryL,G1H3(41),27,0,G2H3(61),n2h3(94))
  call Hloop_UV_W(ntryL,G1H6(6),25,ex3(:),4,G2H2(11),m3h3x2(:,45),heltab2x6(:,:,113))
  call Hloop_UV_W(ntryL,G1H6(94),25,ex3(:),4,G2H2(14),m3h3x2(:,46),heltab2x6(:,:,114))
  call Hloop_UV_W(ntryL,G1H6(93),25,ex3(:),4,G2H2(21),m3h3x2(:,47),heltab2x6(:,:,115))
  call Hotf_4pt_reduction(G2H6(17),RedSet_4(9),mass4set(:,1),  & 
G1H6(37),G1H6(38),G1H6(41),G1H6(42),G1H6(43),6)
  call HG1shiftOLR(G1H6(38),2,6)
  call Hloop_QW_A(ntryL,G1H6(105),ex4(:),G1H2(8),m3h3x2(:,48),heltab2x6(:,:,116))
  call Hloop_Q_A(ntryL,G1H2(8),29,0,G2H2(24),n2h2(11))
  call Hloop_QW_A(ntryL,G1H6(106),ex4(:),G1H2(13),m3h3x2(:,49),heltab2x6(:,:,117))
  call Hloop_Q_A(ntryL,G1H2(13),29,0,G2H2(25),n2h2(12))
  call Hloop_QW_A(ntryL,G1H6(110),ex4(:),G1H2(19),m3h3x2(:,50),heltab2x6(:,:,118))
  call Hloop_Q_A(ntryL,G1H2(19),29,0,G2H2(27),n2h2(13))
  call Hloop_QW_A(ntryL,G1H6(111),ex4(:),G1H2(24),m3h3x2(:,51),heltab2x6(:,:,119))
  call Hloop_Q_A(ntryL,G1H2(24),29,0,G2H2(30),n2h2(14))
  call Hotf_4pt_reduction(G2H6(19),RedSet_4(12),mass4set(:,1),  & 
G1H6(44),G1H6(47),G1H6(48),G1H6(49),G1H6(50),6)
  call HG1shiftOLR(G1H6(47),2,6)
  call Hloop_QZ_A(ntryL,G1H6(121),ex3(:),G1H2(7),ngZd,m3h3x2(:,52),heltab2x6(:,:,120))
  call Hloop_Q_A(ntryL,G1H2(7),29,0,G2H2(32),n2h2(15))
  call Hloop_QZ_A(ntryL,G1H6(122),ex3(:),G1H2(1),ngZd,m3h3x2(:,53),heltab2x6(:,:,121))
  call Hloop_Q_A(ntryL,G1H2(1),29,0,G2H2(35),n2h2(16))
  call Hloop_QZ_A(ntryL,G1H6(126),ex3(:),G1H2(25),ngZd,m3h3x2(:,54),heltab2x6(:,:,122))
  call Hloop_Q_A(ntryL,G1H2(25),29,0,G2H2(36),n2h2(17))
  call Hloop_QZ_A(ntryL,G1H6(127),ex3(:),G1H2(2),ngZd,m3h3x2(:,55),heltab2x6(:,:,123))
  call Hloop_Q_A(ntryL,G1H2(2),29,0,G2H2(37),n2h2(18))
  call Hloop_WWV_V(ntryL,G1H18(3),ex3(:),ex4(:),G1H2(9),m4h3x3x2(:,1),heltab3x18(:,:,1))
  call Hloop_WWV_V(ntryL,G1H18(9),ex4(:),ex3(:),G1H2(30),m4h3x3x2(:,2),heltab3x18(:,:,2))
  call Hloop_WWV_V(ntryL,G1H18(31),ex3(:),ex4(:),G1H2(14),m4h3x3x2(:,3),heltab3x18(:,:,3))
  call Hloop_WWV_V(ntryL,G1H18(32),ex4(:),ex3(:),G1H2(15),m4h3x3x2(:,4),heltab3x18(:,:,4))
  call Hotf_4pt_reduction(G2H18(1),RedSet_4(8),mass4set(:,1),  & 
G1H18(65),G1H18(13),G1H18(14),G1H18(15),G1H18(16),18)
  call HG1shiftOLR(G1H18(13),5,18)
  call Hloop_UV_W(ntryL,G1H18(33),18,ex4(:),8,G2H6(5),m3h3x6(:,37),heltab2x18(:,:,75))
  call Hloop_UW_V(ntryL,G1H18(34),18,ex4(:),8,G2H6(6),m3h3x6(:,38),heltab2x18(:,:,76))
  call Hloop_UV_W(ntryL,G1H18(35),18,ex4(:),8,G2H6(7),m3h3x6(:,39),heltab2x18(:,:,77))
  call Hloop_UW_V(ntryL,G1H18(36),18,ex4(:),8,G2H6(8),m3h3x6(:,40),heltab2x18(:,:,78))
  call Hloop_VQ_A(ntryL,G1H18(37),wf6(:,3),G1H3(46),m3h6x3(:,1),heltab2x18(:,:,79))
  call Hloop_Q_A(ntryL,G1H3(46),23,0,G2H3(62),n2h3(95))
  call Hloop_ZQ_A(ntryL,G1H18(38),wf6(:,3),G1H3(47),ngZu,m3h6x3(:,2),heltab2x18(:,:,80))
  call Hloop_Q_A(ntryL,G1H3(47),23,0,G2H3(64),n2h3(96))
  call Hotf_4pt_reduction(G2H18(2),RedSet_4(3),mass4set(:,1),  & 
G1H18(17),G1H18(18),G1H18(19),G1H18(20),G1H18(21),18)
  call HG1shiftOLR(G1H18(18),6,18)
  call Hloop_UW_V(ntryL,G1H18(39),17,ex4(:),8,G2H6(9),m3h3x6(:,41),heltab2x18(:,:,81))
  call Hloop_UV_W(ntryL,G1H18(40),17,ex4(:),8,G2H6(10),m3h3x6(:,42),heltab2x18(:,:,82))
  call Hloop_UW_V(ntryL,G1H18(41),17,ex4(:),8,G2H6(11),m3h3x6(:,43),heltab2x18(:,:,83))
  call Hloop_UV_W(ntryL,G1H18(42),17,ex4(:),8,G2H6(12),m3h3x6(:,44),heltab2x18(:,:,84))
  call Hloop_VA_Q(ntryL,G1H18(43),wf6(:,8),G1H3(51),m3h6x3(:,3),heltab2x18(:,:,85))
  call Hloop_A_Q(ntryL,G1H3(51),23,0,G2H3(65),n2h3(97))
  call Hloop_ZA_Q(ntryL,G1H18(44),wf6(:,8),G1H3(52),ngZd,m3h6x3(:,4),heltab2x18(:,:,86))
  call Hloop_A_Q(ntryL,G1H3(52),23,0,G2H3(67),n2h3(98))
  call Hotf_4pt_reduction(G2H18(3),RedSet_4(42),mass4set(:,1),  & 
G1H18(22),G1H18(23),G1H18(24),G1H18(25),G1H18(26),18)
  call HG1shiftOLR(G1H18(23),9,18)
  call Hloop_UW_V(ntryL,G1H18(45),18,ex3(:),4,G2H6(13),m3h3x6(:,45),heltab2x18(:,:,87))
  call Hloop_QA_V(ntryL,G2H12(1),ex2(:),G2H6(14),m3h2x6(:,5),heltab2x12(:,:,5))
  call Hloop_QA_Z(ntryL,G2H12(2),ex2(:),G2H6(15),ngZd,m3h2x6(:,6),heltab2x12(:,:,6))
  call Hloop_QA_W(ntryL,G2H12(3),ex2(:),G2H6(16),m3h2x6(:,7),heltab2x12(:,:,7))
  call Hloop_VQ_A(ntryL,G1H18(46),wf6(:,7),G1H3(57),m3h6x3(:,5),heltab2x18(:,:,88))
  call Hloop_Q_A(ntryL,G1H3(57),27,0,G2H3(68),n2h3(99))
  call Hloop_ZQ_A(ntryL,G1H18(47),wf6(:,7),G1H3(58),ngZd,m3h6x3(:,6),heltab2x18(:,:,89))
  call Hloop_Q_A(ntryL,G1H3(58),27,0,G2H3(70),n2h3(100))
  call Hloop_WQ_A(ntryL,G1H18(48),wf6(:,7),G1H3(62),m3h6x3(:,7),heltab2x18(:,:,90))
  call Hloop_Q_A(ntryL,G1H3(62),27,0,G2H3(73),n2h3(101))
  call Hotf_4pt_reduction(G2H18(4),RedSet_4(2),mass4set(:,1),  & 
G1H18(1),G1H18(2),G1H18(4),G1H18(5),G1H18(6),18)
  call HG1shiftOLR(G1H18(2),10,18)
  call Hloop_UW_V(ntryL,G1H18(49),17,ex3(:),4,G2H6(18),m3h3x6(:,46),heltab2x18(:,:,91))
  call Hloop_AQ_V(ntryL,G2H12(4),ex1(:),G2H6(22),m3h2x6(:,8),heltab2x12(:,:,8))
  call Hloop_AQ_Z(ntryL,G2H12(5),ex1(:),G2H6(17),ngZu,m3h2x6(:,9),heltab2x12(:,:,9))
  call Hloop_AQ_W(ntryL,G2H12(6),ex1(:),G2H6(19),m3h2x6(:,10),heltab2x12(:,:,10))
  call Hloop_VA_Q(ntryL,G1H18(50),wf6(:,4),G1H3(63),m3h6x3(:,8),heltab2x18(:,:,92))
  call Hloop_A_Q(ntryL,G1H3(63),27,0,G2H3(74),n2h3(102))
  call Hloop_ZA_Q(ntryL,G1H18(51),wf6(:,4),G1H3(68),ngZu,m3h6x3(:,9),heltab2x18(:,:,93))
  call Hloop_A_Q(ntryL,G1H3(68),27,0,G2H3(75),n2h3(103))
  call Hloop_WA_Q(ntryL,G1H18(52),wf6(:,4),G1H3(69),m3h6x3(:,10),heltab2x18(:,:,94))
  call Hloop_A_Q(ntryL,G1H3(69),27,0,G2H3(76),n2h3(104))
  call Hloop_VA_Q(ntryL,G1H18(53),ex2(:),G1H9(45),m3h2x9(:,39),heltab2x18(:,:,95))
  call Hloop_A_Q(ntryL,G1H9(45),19,0,G2H9(1),n2h9(25))
  call Hloop_ZA_Q(ntryL,G1H18(54),ex2(:),G1H9(46),ngZd,m3h2x9(:,40),heltab2x18(:,:,96))
  call Hloop_A_Q(ntryL,G1H9(46),19,0,G2H9(2),n2h9(26))
  call Hloop_VQ_A(ntryL,G1H18(55),ex1(:),G1H9(49),m3h2x9(:,41),heltab2x18(:,:,97))
  call Hloop_Q_A(ntryL,G1H9(49),19,0,G2H9(3),n2h9(27))
  call Hloop_ZQ_A(ntryL,G1H18(56),ex1(:),G1H9(50),ngZu,m3h2x9(:,42),heltab2x18(:,:,98))
  call Hloop_Q_A(ntryL,G1H9(50),19,0,G2H9(4),n2h9(28))
  call Hloop_VS_V(ntryL,G1H18(57),wf9(:,3),G1H2(35),m3h9x2(:,1),heltab2x18(:,:,99))
  call Hloop_VS_V(ntryL,G1H18(58),wf9(:,3),G1H2(5),m3h9x2(:,2),heltab2x18(:,:,100))
  call Hloop_VS_V(ntryL,G1H18(59),wf9(:,3),G1H2(20),m3h9x2(:,3),heltab2x18(:,:,101))
  call Hloop_VS_V(ntryL,G1H18(60),wf9(:,3),G1H2(40),m3h9x2(:,4),heltab2x18(:,:,102))
  call Hloop_UW_V(ntryL,G1H18(61),17,wf9(:,1),12,G2H2(38),m3h9x2(:,5),heltab2x18(:,:,103))
  call Hloop_UV_W(ntryL,G1H18(62),17,wf9(:,1),12,G2H2(39),m3h9x2(:,6),heltab2x18(:,:,104))
  call Hloop_UW_V(ntryL,G1H18(63),17,wf9(:,1),12,G2H2(40),m3h9x2(:,7),heltab2x18(:,:,105))
  call Hloop_UV_W(ntryL,G1H18(64),17,wf9(:,1),12,G2H2(41),m3h9x2(:,8),heltab2x18(:,:,106))
  call Hotf_4pt_reduction(G2H18(5),RedSet_4(1),mass4set(:,1),  & 
G1H18(7),G1H18(8),G1H18(10),G1H18(11),G1H18(12),18)
  call HG1shiftOLR(G1H18(8),2,18)
  call Hloop_QA_W(ntryL,G2H6(20),ex2(:),G2H3(77),m3h2x3(:,69),heltab2x6(:,:,124))
  call Hloop_QA_V(ntryL,G2H6(21),ex2(:),G2H3(78),m3h2x3(:,70),heltab2x6(:,:,125))
  call Hloop_QA_W(ntryL,G2H6(23),ex2(:),G2H3(79),m3h2x3(:,71),heltab2x6(:,:,126))
  call Hloop_QA_Z(ntryL,G2H6(24),ex2(:),G2H3(80),ngZd,m3h2x3(:,72),heltab2x6(:,:,127))
  call Hloop_VV_S(ntryL,G1H9(7),ex3(:),G1H3(73),m3h3x3(:,45),heltab2x9(:,:,45))
  call Hloop_VV_S(ntryL,G1H9(8),ex3(:),G1H3(74),m3h3x3(:,46),heltab2x9(:,:,46))
  call Hloop_VV_S(ntryL,G1H9(9),ex3(:),G1H3(79),m3h3x3(:,47),heltab2x9(:,:,47))
  call Hloop_UW_V(ntryL,G1H9(10),19,ex3(:),4,G2H3(81),m3h3x3(:,48),heltab2x9(:,:,48))
  call Hloop_UW_V(ntryL,G1H9(13),19,ex3(:),4,G2H3(82),m3h3x3(:,49),heltab2x9(:,:,49))
  call Hloop_VV_S(ntryL,G1H9(16),ex4(:),G1H3(80),m3h3x3(:,50),heltab2x9(:,:,50))
  call Hloop_VV_S(ntryL,G1H9(19),ex4(:),G1H3(84),m3h3x3(:,51),heltab2x9(:,:,51))
  call Hloop_VV_S(ntryL,G1H9(20),ex4(:),G1H3(85),m3h3x3(:,52),heltab2x9(:,:,52))
  call Hloop_UW_V(ntryL,G1H9(21),19,ex4(:),8,G2H3(83),m3h3x3(:,53),heltab2x9(:,:,53))
  call Hloop_UW_V(ntryL,G1H9(22),19,ex4(:),8,G2H3(84),m3h3x3(:,54),heltab2x9(:,:,54))
  call Hloop_AQ_V(ntryL,G2H6(1),ex1(:),G2H3(85),m3h2x3(:,73),heltab2x6(:,:,128))
  call Hloop_AQ_W(ntryL,G2H6(2),ex1(:),G2H3(86),m3h2x3(:,74),heltab2x6(:,:,129))
  call Hloop_AQ_Z(ntryL,G2H6(3),ex1(:),G2H3(87),ngZu,m3h2x3(:,75),heltab2x6(:,:,130))
  call Hloop_AQ_W(ntryL,G2H6(4),ex1(:),G2H3(88),m3h2x3(:,76),heltab2x6(:,:,131))
  call Hloop_VV_S(ntryL,G1H9(27),ex3(:),G1H3(90),m3h3x3(:,55),heltab2x9(:,:,55))
  call Hloop_VV_S(ntryL,G1H9(28),ex3(:),G1H3(91),m3h3x3(:,56),heltab2x9(:,:,56))
  call Hloop_VV_S(ntryL,G1H9(31),ex3(:),G1H3(95),m3h3x3(:,57),heltab2x9(:,:,57))
  call Hloop_UW_V(ntryL,G1H9(32),19,ex3(:),4,G2H3(89),m3h3x3(:,58),heltab2x9(:,:,58))
  call Hloop_UW_V(ntryL,G1H9(33),19,ex3(:),4,G2H3(90),m3h3x3(:,59),heltab2x9(:,:,59))
  call Hloop_VV_S(ntryL,G1H9(38),ex4(:),G1H3(96),m3h3x3(:,60),heltab2x9(:,:,60))
  call Hloop_VV_S(ntryL,G1H9(39),ex4(:),G1H3(101),m3h3x3(:,61),heltab2x9(:,:,61))
  call Hloop_VV_S(ntryL,G1H9(40),ex4(:),G1H3(102),m3h3x3(:,62),heltab2x9(:,:,62))
  call Hloop_UW_V(ntryL,G1H9(43),19,ex4(:),8,G2H3(91),m3h3x3(:,63),heltab2x9(:,:,63))
  call Hloop_UW_V(ntryL,G1H9(44),19,ex4(:),8,G2H3(92),m3h3x3(:,64),heltab2x9(:,:,64))
  call Hloop_QW_A(ntryL,G1H6(23),ex4(:),G1H2(26),m3h3x2(:,56),heltab2x6(:,:,132))
  call Hloop_Q_A(ntryL,G1H2(26),29,0,G2H2(42),n2h2(19))
call HGT_raise_alpha_OLR(G1H6(24),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(24),2,5,6)
  call Hloop_VA_Q(ntryL,G1H6(24),ex2(:),G1H3(106),m3h2x3(:,77),heltab2x6(:,:,133))
  call Hloop_QW_A(ntryL,G1H6(26),ex4(:),G1H2(31),m3h3x2(:,57),heltab2x6(:,:,134))
  call Hloop_Q_A(ntryL,G1H2(31),29,0,G2H2(43),n2h2(20))
  call Hloop_QW_A(ntryL,G1H6(29),ex4(:),G1H2(36),m3h3x2(:,58),heltab2x6(:,:,135))
  call Hloop_Q_A(ntryL,G1H2(36),29,0,G2H2(44),n2h2(21))
  call Hloop_QZ_A(ntryL,G1H6(30),ex3(:),G1H2(41),ngZd,m3h3x2(:,59),heltab2x6(:,:,136))
  call Hloop_Q_A(ntryL,G1H2(41),29,0,G2H2(45),n2h2(22))
call HGT_raise_alpha_OLR(G1H6(31),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(31),2,5,6)
  call Hloop_VA_Q(ntryL,G1H6(31),ex2(:),G1H3(107),m3h2x3(:,78),heltab2x6(:,:,137))
  call Hloop_QZ_A(ntryL,G1H6(35),ex3(:),G1H2(8),ngZd,m3h3x2(:,60),heltab2x6(:,:,138))
  call Hloop_Q_A(ntryL,G1H2(8),29,0,G2H2(46),n2h2(23))
  call Hloop_QZ_A(ntryL,G1H6(36),ex3(:),G1H2(13),ngZd,m3h3x2(:,61),heltab2x6(:,:,139))
  call Hloop_Q_A(ntryL,G1H2(13),29,0,G2H2(47),n2h2(24))
  call Hloop_QW_A(ntryL,G1H6(37),ex4(:),G1H2(19),m3h3x2(:,62),heltab2x6(:,:,140))
  call Hloop_Q_A(ntryL,G1H2(19),29,0,G2H2(48),n2h2(25))
call HGT_raise_alpha_OLR(G1H6(38),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(38),2,5,6)
  call Hloop_VA_Q(ntryL,G1H6(38),ex2(:),G1H3(112),m3h2x3(:,79),heltab2x6(:,:,141))
  call Hloop_QW_A(ntryL,G1H6(42),ex4(:),G1H2(24),m3h3x2(:,63),heltab2x6(:,:,142))
  call Hloop_Q_A(ntryL,G1H2(24),29,0,G2H2(49),n2h2(26))
  call Hloop_QW_A(ntryL,G1H6(43),ex4(:),G1H2(7),m3h3x2(:,64),heltab2x6(:,:,143))
  call Hloop_Q_A(ntryL,G1H2(7),29,0,G2H2(50),n2h2(27))
  call Hloop_QZ_A(ntryL,G1H6(44),ex3(:),G1H2(1),ngZd,m3h3x2(:,65),heltab2x6(:,:,144))
  call Hloop_Q_A(ntryL,G1H2(1),29,0,G2H2(51),n2h2(28))
call HGT_raise_alpha_OLR(G1H6(47),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(47),2,5,6)
  call Hloop_VA_Q(ntryL,G1H6(47),ex2(:),G1H3(113),m3h2x3(:,80),heltab2x6(:,:,145))
  call Hloop_QZ_A(ntryL,G1H6(49),ex3(:),G1H2(25),ngZd,m3h3x2(:,66),heltab2x6(:,:,146))
  call Hloop_Q_A(ntryL,G1H2(25),29,0,G2H2(52),n2h2(29))
  call Hloop_QZ_A(ntryL,G1H6(50),ex3(:),G1H2(2),ngZd,m3h3x2(:,67),heltab2x6(:,:,147))
  call Hloop_Q_A(ntryL,G1H2(2),29,0,G2H2(53),n2h2(30))
  call Hloop_AW_Q(ntryL,G1H18(65),ex4(:),G1H6(53),m3h3x6(:,47),heltab2x18(:,:,107))
  call Hloop_A_Q(ntryL,G1H6(53),26,0,G2H6(20),n2h6(45))
call HGT_raise_alpha_OLR(G1H18(13),1,1,18)
call HGT_raise_alpha_invQ_OLR(G1H18(13),2,5,18)
  call Hloop_VQ_A(ntryL,G1H18(13),wf6(:,3),G1H3(117),m3h6x3(:,11),heltab2x18(:,:,108))
  call Hloop_AW_Q(ntryL,G1H18(15),ex4(:),G1H6(54),m3h3x6(:,48),heltab2x18(:,:,109))
  call Hloop_A_Q(ntryL,G1H6(54),26,0,G2H6(21),n2h6(46))
  call Hloop_AW_Q(ntryL,G1H18(16),ex4(:),G1H6(1),m3h3x6(:,49),heltab2x18(:,:,110))
  call Hloop_A_Q(ntryL,G1H6(1),26,0,G2H6(23),n2h6(47))
  call Hloop_QW_A(ntryL,G1H18(17),ex4(:),G1H6(2),m3h3x6(:,50),heltab2x18(:,:,111))
  call Hloop_Q_A(ntryL,G1H6(2),25,0,G2H6(24),n2h6(48))
call HGT_raise_alpha_OLR(G1H18(18),1,1,18)
call HGT_raise_alpha_invQ_OLR(G1H18(18),2,5,18)
  call Hloop_VA_Q(ntryL,G1H18(18),wf6(:,8),G1H3(118),m3h6x3(:,12),heltab2x18(:,:,112))
  call Hloop_QW_A(ntryL,G1H18(20),ex4(:),G1H6(56),m3h3x6(:,51),heltab2x18(:,:,113))
  call Hloop_Q_A(ntryL,G1H6(56),25,0,G2H6(1),n2h6(49))
  call Hloop_QW_A(ntryL,G1H18(21),ex4(:),G1H6(57),m3h3x6(:,52),heltab2x18(:,:,114))
  call Hloop_Q_A(ntryL,G1H6(57),25,0,G2H6(2),n2h6(50))
  call Hloop_AZ_Q(ntryL,G1H18(22),ex3(:),G1H6(58),ngZd,m3h3x6(:,53),heltab2x18(:,:,115))
  call Hloop_A_Q(ntryL,G1H6(58),22,0,G2H6(3),n2h6(51))
call HGT_raise_alpha_OLR(G1H18(23),1,1,18)
call HGT_raise_alpha_invQ_OLR(G1H18(23),2,5,18)
  call Hloop_VQ_A(ntryL,G1H18(23),wf6(:,7),G1H3(123),m3h6x3(:,13),heltab2x18(:,:,116))
  call Hloop_AZ_Q(ntryL,G1H18(25),ex3(:),G1H6(59),ngZd,m3h3x6(:,54),heltab2x18(:,:,117))
  call Hloop_A_Q(ntryL,G1H6(59),22,0,G2H6(4),n2h6(52))
  call Hloop_AZ_Q(ntryL,G1H18(26),ex3(:),G1H6(62),ngZd,m3h3x6(:,55),heltab2x18(:,:,118))
  call Hloop_A_Q(ntryL,G1H6(62),22,0,G2H6(25),n2h6(53))
  call Hloop_QZ_A(ntryL,G1H18(1),ex3(:),G1H6(63),ngZu,m3h3x6(:,56),heltab2x18(:,:,119))
  call Hloop_Q_A(ntryL,G1H6(63),21,0,G2H6(26),n2h6(54))
call HGT_raise_alpha_OLR(G1H18(2),1,1,18)
call HGT_raise_alpha_invQ_OLR(G1H18(2),2,5,18)
  call Hloop_VA_Q(ntryL,G1H18(2),wf6(:,4),G1H3(124),m3h6x3(:,14),heltab2x18(:,:,120))
  call Hloop_QZ_A(ntryL,G1H18(5),ex3(:),G1H6(64),ngZu,m3h3x6(:,57),heltab2x18(:,:,121))
  call Hloop_Q_A(ntryL,G1H6(64),21,0,G2H6(27),n2h6(55))
  call Hloop_QZ_A(ntryL,G1H18(6),ex3(:),G1H6(65),ngZu,m3h3x6(:,58),heltab2x18(:,:,122))
  call Hloop_Q_A(ntryL,G1H6(65),21,0,G2H6(28),n2h6(56))
  call Hloop_QW_A(ntryL,G1H18(7),wf9(:,1),G1H2(26),m3h9x2(:,9),heltab2x18(:,:,123))
  call Hloop_Q_A(ntryL,G1H2(26),29,0,G2H2(54),n2h2(31))
call HGT_raise_alpha_OLR(G1H18(8),1,1,18)
call HGT_raise_alpha_invQ_OLR(G1H18(8),2,5,18)
  call Hloop_VA_Q(ntryL,G1H18(8),ex2(:),G1H9(5),m3h2x9(:,43),heltab2x18(:,:,124))
  call Hloop_QW_A(ntryL,G1H18(11),wf9(:,1),G1H2(31),m3h9x2(:,10),heltab2x18(:,:,125))
  call Hloop_Q_A(ntryL,G1H2(31),29,0,G2H2(55),n2h2(32))
  call Hloop_QW_A(ntryL,G1H18(12),wf9(:,1),G1H2(36),m3h9x2(:,11),heltab2x18(:,:,126))
  call Hloop_Q_A(ntryL,G1H2(36),29,0,G2H2(56),n2h2(33))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(5),[G2H3(2),G1H3(22),G1H3(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(62),[G2H3(9),G1H3(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(64),[G2H3(13),G1H3(44)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(19),[G2H3(16),G1H3(66),G1H3(55)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(15),[G1H3(53)])
call HGT_OLR(G2H3(22),1,1,3)
call HGT_invQ_OLR(G2H3(22),2,5,3)
call HGT_OLR(G2H3(22),6,15,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(22),[G2H3(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(68),[G2H3(49),G2H3(23),G1H3(154),G1H3(77)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(18),[G1H3(64)])
call HGT_OLR(G2H3(26),1,1,3)
call HGT_invQ_OLR(G2H3(26),2,5,3)
call HGT_OLR(G2H3(26),6,15,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(26),[G2H3(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(70),[G2H3(55),G2H3(27),G1H3(176),G1H3(88)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(65),[G2H3(31),G1H3(99)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(67),[G2H3(35),G1H3(110)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(4),[G1H3(9)])
call HGT_OLR(G2H3(38),1,1,3)
call HGT_invQ_OLR(G2H3(38),2,5,3)
call HGT_OLR(G2H3(38),6,15,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(38),[G2H3(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(74),[G2H3(60),G2H3(39),G1H3(187),G1H3(121)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(7),[G1H3(20)])
call HGT_OLR(G2H3(42),1,1,3)
call HGT_invQ_OLR(G2H3(42),2,5,3)
call HGT_OLR(G2H3(42),6,15,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(42),[G2H3(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(75),[G2H3(66),G2H3(43),G1H3(209),G1H3(132)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(73),[G2H3(52),G2H3(46),G1H3(165),G1H3(143)])
call HGT_lower_alpha_w2_OLR(G2H3(57),1,1,3)
call HGT_lower_alpha_w2_invQ_OLR(G2H3(57),2,5,3)
call HGT_lower_alpha_w2_OLR(G2H3(57),6,15,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(57),[G2H3(89)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(39),[G2H2(10),G1H2(5),G1H2(30),G1H2(6)])
call HGT_lower_alpha_w2_OLR(G2H3(58),1,1,3)
call HGT_lower_alpha_w2_invQ_OLR(G2H3(58),2,5,3)
call HGT_lower_alpha_w2_OLR(G2H3(58),6,15,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(58),[G2H3(90)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(41),[G2H2(13),G1H2(40),G1H2(15),G1H2(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(76),[G2H3(69),G2H3(63),G1H3(220),G1H3(198)])
call HGT_lower_alpha_w2_OLR(G2H3(71),1,1,3)
call HGT_lower_alpha_w2_invQ_OLR(G2H3(71),2,5,3)
call HGT_lower_alpha_w2_OLR(G2H3(71),6,15,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(71),[G2H3(91)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(38),[G2H2(20),G1H2(35),G1H2(9),G1H2(18)])
call HGT_lower_alpha_w2_OLR(G2H3(72),1,1,3)
call HGT_lower_alpha_w2_invQ_OLR(G2H3(72),2,5,3)
call HGT_lower_alpha_w2_OLR(G2H3(72),6,15,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(72),[G2H3(92)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(40),[G2H2(23),G1H2(20),G1H2(14),G1H2(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(1),[G1H3(31)])
call HGT_w2_OLR(G1H3(1),1,1,3)
call HGT_w2_invQ_OLR(G1H3(1),2,5,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(1),[G1H3(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(54),[G2H2(31),G2H2(26)])
call HGT_w2_OLR(G1H3(2),1,1,3)
call HGT_w2_invQ_OLR(G1H3(2),2,5,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(2),[G1H3(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(56),[G2H2(34),G2H2(33),G2H2(29),G2H2(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(3),[G1H3(75)])
call HGT_w2_OLR(G1H3(4),1,1,3)
call HGT_w2_invQ_OLR(G1H3(4),2,5,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(3),[G1H3(4)])
call HGT_w2_OLR(G1H3(5),1,1,3)
call HGT_w2_invQ_OLR(G1H3(5),2,5,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(5),[G1H3(81)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(9),[G1H2(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(12),[G1H2(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(19),[G1H2(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(22),[G1H2(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(11),[G1H2(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(14),[G1H2(22),G1H2(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(21),[G1H2(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(6),[G1H3(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(28),[G1H3(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(10),[G1H3(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(11),[G1H3(43),G1H3(32)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(49),[G1H3(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(14),[G1H3(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(17),[G1H3(54)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(72),[G1H3(61)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(20),[G1H3(65)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(21),[G1H3(87),G1H3(76)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(93),[G1H3(82)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(160),[G1H3(83)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(24),[G1H3(86)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(182),[G1H3(94)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(25),[G1H3(97)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(28),[G1H3(109),G1H3(98)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(115),[G1H3(104)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(29),[G1H3(108)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(32),[G1H3(119)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(33),[G1H3(131),G1H3(120)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(137),[G1H3(126)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(193),[G1H3(127)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(36),[G1H3(130)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(215),[G1H3(138)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(37),[G1H3(141)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(40),[G1H3(142)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(171),[G1H3(149)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(41),[G1H3(152)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(44),[G1H3(175),G1H3(153)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(181),[G1H3(159)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(45),[G1H3(163)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(47),[G1H3(164)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(48),[G1H3(174)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(50),[G1H3(185)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(51),[G1H3(208),G1H3(186)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(214),[G1H3(192)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(53),[G1H3(196)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(54),[G1H3(197)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(226),[G1H3(204)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(56),[G1H3(207)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(59),[G1H3(218)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(61),[G1H3(219)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(43),[G1H2(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(50),[G2H2(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(44),[G2H2(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(53),[G2H2(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(47),[G2H2(37)])
call HGT_OLR(G2H2(1),1,1,2)
call HGT_invQ_OLR(G2H2(1),2,5,2)
call HGT_OLR(G2H2(1),6,15,2)
  call Hotf_4pt_reduction(G2H2(1),RedSet_4(43),mass4set(:,1),  & 
G1H2(41),G1H2(8),G1H2(13),G1H2(19),G1H2(24),2)
  call HG1shiftOLR(G1H2(8),2,2)
  call Hotf_4pt_reduction(G2H3(5),RedSet_4(17),mass4set(:,1),  & 
G1H3(128),G1H3(129),G1H3(134),G1H3(135),G1H3(139),3)
  call HG1shiftOLR(G1H3(129),8,3)
call HGT_OLR(G2H2(2),1,1,2)
call HGT_invQ_OLR(G2H2(2),2,5,2)
call HGT_OLR(G2H2(2),6,15,2)
  call Hotf_4pt_reduction(G2H2(2),RedSet_4(43),mass4set(:,2),  & 
G1H2(7),G1H2(1),G1H2(25),G1H2(2),G1H2(26),2)
  call HG1shiftOLR(G1H2(1),2,2)
call HGT_OLR(G2H3(8),1,1,3)
call HGT_invQ_OLR(G2H3(8),2,5,3)
call HGT_OLR(G2H3(8),6,15,3)
  call Hotf_4pt_reduction(G2H3(8),RedSet_4(44),mass4set(:,1),  & 
G1H3(140),G1H3(145),G1H3(146),G1H3(150),G1H3(151),3)
  call HG1shiftOLR(G1H3(145),4,3)
  call Hotf_4pt_reduction(G2H3(62),RedSet_4(21),mass4set(:,1),  & 
G1H3(156),G1H3(157),G1H3(161),G1H3(162),G1H3(167),3)
  call HG1shiftOLR(G1H3(157),8,3)
call HGT_OLR(G2H3(12),1,1,3)
call HGT_invQ_OLR(G2H3(12),2,5,3)
call HGT_OLR(G2H3(12),6,15,3)
  call Hotf_4pt_reduction(G2H3(12),RedSet_4(44),mass4set(:,3),  & 
G1H3(168),G1H3(172),G1H3(173),G1H3(178),G1H3(179),3)
  call HG1shiftOLR(G1H3(172),4,3)
  call Hotf_4pt_reduction(G2H3(64),RedSet_4(21),mass4set(:,3),  & 
G1H3(183),G1H3(184),G1H3(189),G1H3(190),G1H3(194),3)
  call HG1shiftOLR(G1H3(184),8,3)
call HGT_OLR(G2H2(3),1,1,2)
call HGT_invQ_OLR(G2H2(3),2,5,2)
call HGT_OLR(G2H2(3),6,15,2)
  call Hotf_4pt_reduction(G2H2(3),RedSet_4(45),mass4set(:,1),  & 
G1H2(31),G1H2(36),G1H2(5),G1H2(30),G1H2(6),2)
  call HG1shiftOLR(G1H2(36),1,2)
  call Hotf_4pt_reduction(G2H3(19),RedSet_4(17),mass4set(:,1),  & 
G1H3(195),G1H3(200),G1H3(201),G1H3(205),G1H3(206),3)
  call HG1shiftOLR(G1H3(200),8,3)
call HGT_OLR(G2H2(4),1,1,2)
call HGT_invQ_OLR(G2H2(4),2,5,2)
call HGT_OLR(G2H2(4),6,15,2)
  call Hotf_4pt_reduction(G2H2(4),RedSet_4(45),mass4set(:,2),  & 
G1H2(40),G1H2(15),G1H2(12),G1H2(35),G1H2(9),2)
  call HG1shiftOLR(G1H2(15),1,2)
  call Hotf_4pt_reduction(G2H3(22),RedSet_4(23),mass4set(:,1),  & 
G1H3(211),G1H3(212),G1H3(216),G1H3(217),G1H3(222),3)
  call HG1shiftOLR(G1H3(212),8,3)
  call Hotf_4pt_reduction(G2H3(68),RedSet_4(28),mass4set(:,1),  & 
G1H3(223),G1H3(12),G1H3(23),G1H3(34),G1H3(45),3)
  call HG1shiftOLR(G1H3(12),4,3)
  call Hotf_4pt_reduction(G2H3(26),RedSet_4(23),mass4set(:,3),  & 
G1H3(56),G1H3(67),G1H3(78),G1H3(89),G1H3(100),3)
  call HG1shiftOLR(G1H3(67),8,3)
  call Hotf_4pt_reduction(G2H3(70),RedSet_4(28),mass4set(:,3),  & 
G1H3(111),G1H3(122),G1H3(133),G1H3(144),G1H3(155),3)
  call HG1shiftOLR(G1H3(122),4,3)
call HGT_OLR(G2H3(30),1,1,3)
call HGT_invQ_OLR(G2H3(30),2,5,3)
call HGT_OLR(G2H3(30),6,15,3)
  call Hotf_4pt_reduction(G2H3(30),RedSet_4(46),mass4set(:,1),  & 
G1H3(166),G1H3(177),G1H3(188),G1H3(199),G1H3(210),3)
  call HG1shiftOLR(G1H3(177),4,3)
  call Hotf_4pt_reduction(G2H3(65),RedSet_4(31),mass4set(:,1),  & 
G1H3(221),G1H3(7),G1H3(8),G1H3(13),G1H3(14),3)
  call HG1shiftOLR(G1H3(7),8,3)
call HGT_OLR(G2H3(34),1,1,3)
call HGT_invQ_OLR(G2H3(34),2,5,3)
call HGT_OLR(G2H3(34),6,15,3)
  call Hotf_4pt_reduction(G2H3(34),RedSet_4(46),mass4set(:,3),  & 
G1H3(18),G1H3(19),G1H3(24),G1H3(25),G1H3(29),3)
  call HG1shiftOLR(G1H3(19),4,3)
  call Hotf_4pt_reduction(G2H3(67),RedSet_4(31),mass4set(:,3),  & 
G1H3(30),G1H3(35),G1H3(36),G1H3(40),G1H3(41),3)
  call HG1shiftOLR(G1H3(35),8,3)
  call Hotf_4pt_reduction(G2H3(38),RedSet_4(15),mass4set(:,1),  & 
G1H3(46),G1H3(47),G1H3(51),G1H3(52),G1H3(57),3)
  call HG1shiftOLR(G1H3(47),8,3)
  call Hotf_4pt_reduction(G2H3(74),RedSet_4(34),mass4set(:,1),  & 
G1H3(58),G1H3(62),G1H3(63),G1H3(68),G1H3(69),3)
  call HG1shiftOLR(G1H3(62),4,3)
  call Hotf_4pt_reduction(G2H3(42),RedSet_4(15),mass4set(:,3),  & 
G1H3(22),G1H3(11),G1H3(33),G1H3(44),G1H3(66),3)
  call HG1shiftOLR(G1H3(11),8,3)
  call Hotf_4pt_reduction(G2H3(75),RedSet_4(34),mass4set(:,3),  & 
G1H3(55),G1H3(53),G1H3(154),G1H3(77),G1H3(64),3)
  call HG1shiftOLR(G1H3(53),4,3)
call HGT_OLR(G2H2(5),1,1,2)
call HGT_invQ_OLR(G2H2(5),2,5,2)
call HGT_OLR(G2H2(5),6,15,2)
  call Hotf_4pt_reduction(G2H2(5),RedSet_4(47),mass4set(:,4),  & 
G1H2(18),G1H2(20),G1H2(14),G1H2(23),G1H2(3),2)
  call HG1shiftOLR(G1H2(20),1,2)
  call Hotf_4pt_reduction(G2H3(73),RedSet_4(28),mass4set(:,4),  & 
G1H3(176),G1H3(88),G1H3(99),G1H3(110),G1H3(9),3)
  call HG1shiftOLR(G1H3(88),4,3)
call HGT_OLR(G2H2(6),1,1,2)
call HGT_invQ_OLR(G2H2(6),2,5,2)
call HGT_OLR(G2H2(6),6,15,2)
  call Hotf_4pt_reduction(G2H2(6),RedSet_4(47),mass4set(:,5),  & 
G1H2(4),G1H2(10),G1H2(11),G1H2(16),G1H2(22),2)
  call HG1shiftOLR(G1H2(10),1,2)
call HGT_OLR(G2H2(7),1,1,2)
call HGT_invQ_OLR(G2H2(7),2,5,2)
call HGT_OLR(G2H2(7),6,15,2)
  call Hotf_4pt_reduction(G2H2(7),RedSet_4(47),mass4set(:,6),  & 
G1H2(17),G1H2(21),G1H2(38),G1H2(45),G1H2(46),2)
  call HG1shiftOLR(G1H2(21),1,2)
call HGT_OLR(G2H2(8),1,1,2)
call HGT_invQ_OLR(G2H2(8),2,5,2)
call HGT_OLR(G2H2(8),6,15,2)
  call Hotf_4pt_reduction(G2H2(8),RedSet_4(47),mass4set(:,7),  & 
G1H2(47),G1H2(48),G1H2(49),G1H2(50),G1H2(51),2)
  call HG1shiftOLR(G1H2(48),1,2)
  call Hotf_4pt_reduction(G2H3(57),RedSet_4(19),mass4set(:,8),  & 
G1H3(187),G1H3(121),G1H3(20),G1H3(209),G1H3(132),3)
  call HG1shiftOLR(G1H3(121),8,3)
  call Hotf_4pt_reduction(G2H2(39),RedSet_4(1),mass4set(:,4),  & 
G1H2(52),G1H2(53),G1H2(54),G1H2(55),G1H2(56),2)
  call HG1shiftOLR(G1H2(53),2,2)
  call Hotf_4pt_reduction(G2H3(58),RedSet_4(19),mass4set(:,9),  & 
G1H3(165),G1H3(143),G1H3(220),G1H3(198),G1H3(31),3)
  call HG1shiftOLR(G1H3(143),8,3)
  call Hotf_4pt_reduction(G2H2(41),RedSet_4(1),mass4set(:,6),  & 
G1H2(57),G1H2(58),G1H2(59),G1H2(60),G1H2(61),2)
  call HG1shiftOLR(G1H2(58),2,2)
call HGT_OLR(G2H2(15),1,1,2)
call HGT_invQ_OLR(G2H2(15),2,5,2)
call HGT_OLR(G2H2(15),6,15,2)
  call Hotf_4pt_reduction(G2H2(15),RedSet_4(48),mass4set(:,5),  & 
G1H2(62),G1H2(63),G1H2(64),G1H2(65),G1H2(66),2)
  call HG1shiftOLR(G1H2(63),2,2)
call HGT_OLR(G2H2(16),1,1,2)
call HGT_invQ_OLR(G2H2(16),2,5,2)
call HGT_OLR(G2H2(16),6,15,2)
  call Hotf_4pt_reduction(G2H2(16),RedSet_4(48),mass4set(:,4),  & 
G1H2(67),G1H2(68),G1H2(69),G1H2(70),G1H2(71),2)
  call HG1shiftOLR(G1H2(68),2,2)
  call Hotf_4pt_reduction(G2H3(76),RedSet_4(34),mass4set(:,4),  & 
G1H3(1),G1H3(37),G1H3(75),G1H3(4),G1H3(81),3)
  call HG1shiftOLR(G1H3(37),4,3)
call HGT_OLR(G2H2(17),1,1,2)
call HGT_invQ_OLR(G2H2(17),2,5,2)
call HGT_OLR(G2H2(17),6,15,2)
  call Hotf_4pt_reduction(G2H2(17),RedSet_4(48),mass4set(:,7),  & 
G1H2(72),G1H2(73),G1H2(74),G1H2(75),G1H2(76),2)
  call HG1shiftOLR(G1H2(73),2,2)
call HGT_OLR(G2H2(18),1,1,2)
call HGT_invQ_OLR(G2H2(18),2,5,2)
call HGT_OLR(G2H2(18),6,15,2)
  call Hotf_4pt_reduction(G2H2(18),RedSet_4(48),mass4set(:,6),  & 
G1H2(77),G1H2(78),G1H2(79),G1H2(80),G1H2(81),2)
  call HG1shiftOLR(G1H2(78),2,2)
  call Hotf_4pt_reduction(G2H3(71),RedSet_4(26),mass4set(:,10),  & 
G1H3(10),G1H3(17),G1H3(21),G1H3(43),G1H3(32),3)
  call HG1shiftOLR(G1H3(17),4,3)
  call Hotf_4pt_reduction(G2H2(38),RedSet_4(1),mass4set(:,5),  & 
G1H2(82),G1H2(83),G1H2(84),G1H2(85),G1H2(86),2)
  call HG1shiftOLR(G1H2(83),2,2)
  call Hotf_4pt_reduction(G2H3(72),RedSet_4(26),mass4set(:,11),  & 
G1H3(38),G1H3(42),G1H3(54),G1H3(61),G1H3(65),3)
  call HG1shiftOLR(G1H3(42),4,3)
  call Hotf_4pt_reduction(G2H2(40),RedSet_4(1),mass4set(:,7),  & 
G1H2(87),G1H2(88),G1H2(89),G1H2(90),G1H2(91),2)
  call HG1shiftOLR(G1H2(88),2,2)
  call Hotf_4pt_reduction(G2H3(1),RedSet_4(19),mass4set(:,1),  & 
G1H3(87),G1H3(76),G1H3(82),G1H3(83),G1H3(86),3)
  call HG1shiftOLR(G1H3(76),8,3)
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(54),ex2(:),G2tensor(1),m3h2x1(:,23),heltab2x2(:,:,23))
  call Hloop_QW_A(ntryL,G1H3(2),ex4(:),G1H1(1),m3h3x1(:,81),heltab2x3(:,:,81))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(2),n2h1(99))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(56),ex2(:),G2tensor(3),m3h2x1(:,24),heltab2x2(:,:,24))
call HGT_w2_OLR(G1H3(3),1,1,3)
call HGT_w2_invQ_OLR(G1H3(3),2,5,3)
  call Hloop_QW_A(ntryL,G1H3(3),ex4(:),G1H1(1),m3h3x1(:,82),heltab2x3(:,:,82))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(5),n2h1(100))
  call Hotf_4pt_reduction(G2H3(3),RedSet_4(26),mass4set(:,1),  & 
G1H3(94),G1H3(97),G1H3(109),G1H3(98),G1H3(104),3)
  call HG1shiftOLR(G1H3(97),4,3)
  call Hloop_QZ_A(ntryL,G1H3(5),ex3(:),G1H1(1),ngZd,m3h3x1(:,83),heltab2x3(:,:,83))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(7),n2h1(101))
call HGT_w2_OLR(G1H3(6),1,1,3)
call HGT_w2_invQ_OLR(G1H3(6),2,5,3)
  call Hloop_QZ_A(ntryL,G1H3(6),ex3(:),G1H1(1),ngZd,m3h3x1(:,84),heltab2x3(:,:,84))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(10),n2h1(102))
  call Hotf_4pt_reduction(G2H2(9),RedSet_4(9),mass4set(:,12),  & 
G1H2(92),G1H2(93),G1H2(94),G1H2(95),G1H2(96),2)
  call HG1shiftOLR(G1H2(93),2,2)
  call Hotf_4pt_reduction(G2H2(12),RedSet_4(10),mass4set(:,4),  & 
G1H2(97),G1H2(98),G1H2(99),G1H2(100),G1H2(101),2)
  call HG1shiftOLR(G1H2(98),2,2)
  call Hotf_4pt_reduction(G2H2(19),RedSet_4(9),mass4set(:,13),  & 
G1H2(102),G1H2(103),G1H2(104),G1H2(105),G1H2(106),2)
  call HG1shiftOLR(G1H2(103),2,2)
  call Hotf_4pt_reduction(G2H2(22),RedSet_4(10),mass4set(:,6),  & 
G1H2(107),G1H2(108),G1H2(109),G1H2(110),G1H2(111),2)
  call HG1shiftOLR(G1H2(108),2,2)
  call Hotf_4pt_reduction(G2H2(11),RedSet_4(12),mass4set(:,8),  & 
G1H2(112),G1H2(113),G1H2(114),G1H2(115),G1H2(116),2)
  call HG1shiftOLR(G1H2(113),2,2)
  call Hotf_4pt_reduction(G2H2(14),RedSet_4(13),mass4set(:,8),  & 
G1H2(117),G1H2(118),G1H2(119),G1H2(120),G1H2(121),2)
  call HG1shiftOLR(G1H2(118),2,2)
  call Hotf_4pt_reduction(G2H2(21),RedSet_4(12),mass4set(:,14),  & 
G1H2(122),G1H2(123),G1H2(124),G1H2(125),G1H2(126),2)
  call HG1shiftOLR(G1H2(123),2,2)
  call Hotf_4pt_reduction(G2H3(6),RedSet_4(16),mass4set(:,1),  & 
G1H3(108),G1H3(119),G1H3(131),G1H3(120),G1H3(126),3)
  call HG1shiftOLR(G1H3(119),8,3)
  call Hloop_AW_Q(ntryL,G1H3(15),ex4(:),G1H1(1),m3h3x1(:,85),heltab2x3(:,:,85))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(13),n2h1(103))
  call Hloop_AW_Q(ntryL,G1H3(16),ex4(:),G1H1(1),m3h3x1(:,86),heltab2x3(:,:,86))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(16),n2h1(104))
  call Hloop_AW_Q(ntryL,G1H3(28),ex4(:),G1H1(1),m3h3x1(:,87),heltab2x3(:,:,87))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(19),n2h1(105))
  call Hotf_4pt_reduction(G2H3(10),RedSet_4(16),mass4set(:,3),  & 
G1H3(127),G1H3(130),G1H3(138),G1H3(141),G1H3(142),3)
  call HG1shiftOLR(G1H3(130),8,3)
  call Hloop_AW_Q(ntryL,G1H3(26),ex4(:),G1H1(1),m3h3x1(:,88),heltab2x3(:,:,88))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(23),n2h1(106))
  call Hloop_AW_Q(ntryL,G1H3(27),ex4(:),G1H1(1),m3h3x1(:,89),heltab2x3(:,:,89))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(27),n2h1(107))
  call Hotf_4pt_reduction(G2H3(11),RedSet_4(20),mass4set(:,1),  & 
G1H3(149),G1H3(152),G1H3(175),G1H3(153),G1H3(159),3)
  call HG1shiftOLR(G1H3(152),8,3)
  call Hloop_QW_A(ntryL,G1H3(49),ex4(:),G1H1(1),m3h3x1(:,90),heltab2x3(:,:,90))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(31),n2h1(108))
  call Hloop_QW_A(ntryL,G1H3(39),ex4(:),G1H1(1),m3h3x1(:,91),heltab2x3(:,:,91))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(35),n2h1(109))
  call Hotf_4pt_reduction(G2H3(14),RedSet_4(19),mass4set(:,15),  & 
G1H3(163),G1H3(164),G1H3(174),G1H3(185),G1H3(208),3)
  call HG1shiftOLR(G1H3(164),8,3)
  call Hloop_QW_A(ntryL,G1H3(48),ex4(:),G1H1(1),m3h3x1(:,92),heltab2x3(:,:,92))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(39),n2h1(110))
  call Hloop_QW_A(ntryL,G1H3(50),ex4(:),G1H1(1),m3h3x1(:,93),heltab2x3(:,:,93))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(43),n2h1(111))
  call Hotf_4pt_reduction(G2H3(17),RedSet_4(24),mass4set(:,1),  & 
G1H3(186),G1H3(192),G1H3(196),G1H3(197),G1H3(204),3)
  call HG1shiftOLR(G1H3(192),8,3)
  call Hloop_QW_A(ntryL,G1H3(59),ex4(:),G1H1(1),m3h3x1(:,94),heltab2x3(:,:,94))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(47),n2h1(112))
  call Hloop_QW_A(ntryL,G1H3(60),ex4(:),G1H1(1),m3h3x1(:,95),heltab2x3(:,:,95))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(51),n2h1(113))
  call Hloop_QW_A(ntryL,G1H3(72),ex4(:),G1H1(1),m3h3x1(:,96),heltab2x3(:,:,96))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(55),n2h1(114))
  call Hotf_4pt_reduction(G2H3(20),RedSet_4(24),mass4set(:,3),  & 
G1H3(207),G1H3(218),G1H3(219),G1H3(2),G1H3(3),3)
  call HG1shiftOLR(G1H3(218),8,3)
  call Hloop_QW_A(ntryL,G1H3(70),ex4(:),G1H1(1),m3h3x1(:,97),heltab2x3(:,:,97))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(59),n2h1(115))
  call Hloop_QW_A(ntryL,G1H3(71),ex4(:),G1H1(1),m3h3x1(:,98),heltab2x3(:,:,98))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(63),n2h1(116))
  call Hotf_4pt_reduction(G2H3(21),RedSet_4(27),mass4set(:,1),  & 
G1H3(5),G1H3(6),G1H3(15),G1H3(16),G1H3(28),3)
  call HG1shiftOLR(G1H3(6),4,3)
  call Hloop_QZ_A(ntryL,G1H3(93),ex3(:),G1H1(1),ngZd,m3h3x1(:,99),heltab2x3(:,:,99))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(67),n2h1(117))
  call Hloop_QZ_A(ntryL,G1H3(160),ex3(:),G1H1(1),ngZd,m3h3x1(:,100),heltab2x3(:,:,100))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(71),n2h1(118))
  call Hotf_4pt_reduction(G2H3(24),RedSet_4(26),mass4set(:,15),  & 
G1H3(26),G1H3(27),G1H3(49),G1H3(39),G1H3(48),3)
  call HG1shiftOLR(G1H3(27),4,3)
  call Hloop_QZ_A(ntryL,G1H3(92),ex3(:),G1H1(1),ngZd,m3h3x1(:,101),heltab2x3(:,:,101))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(75),n2h1(119))
  call Hloop_QZ_A(ntryL,G1H3(182),ex3(:),G1H1(1),ngZd,m3h3x1(:,102),heltab2x3(:,:,102))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(79),n2h1(120))
  call Hotf_4pt_reduction(G2H3(25),RedSet_4(30),mass4set(:,1),  & 
G1H3(50),G1H3(59),G1H3(60),G1H3(72),G1H3(70),3)
  call HG1shiftOLR(G1H3(59),8,3)
  call Hotf_4pt_reduction(G2H3(28),RedSet_4(20),mass4set(:,1),  & 
G1H3(71),G1H3(93),G1H3(160),G1H3(92),G1H3(182),3)
  call HG1shiftOLR(G1H3(93),8,3)
  call Hloop_AW_Q(ntryL,G1H3(103),ex4(:),G1H1(1),m3h3x1(:,103),heltab2x3(:,:,103))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(85),n2h1(121))
  call Hloop_AW_Q(ntryL,G1H3(115),ex4(:),G1H1(1),m3h3x1(:,104),heltab2x3(:,:,104))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(89),n2h1(122))
  call Hloop_AW_Q(ntryL,G1H3(105),ex4(:),G1H1(1),m3h3x1(:,105),heltab2x3(:,:,105))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(93),n2h1(123))
  call Hotf_4pt_reduction(G2H3(29),RedSet_4(30),mass4set(:,15),  & 
G1H3(103),G1H3(115),G1H3(105),G1H3(227),G1H3(228),3)
  call HG1shiftOLR(G1H3(115),8,3)
  call Hloop_AW_Q(ntryL,G1H3(114),ex4(:),G1H1(1),m3h3x1(:,106),heltab2x3(:,:,106))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(97),n2h1(124))
  call Hloop_AW_Q(ntryL,G1H3(116),ex4(:),G1H1(1),m3h3x1(:,107),heltab2x3(:,:,107))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(103),n2h1(125))
  call Hotf_4pt_reduction(G2H3(32),RedSet_4(33),mass4set(:,1),  & 
G1H3(114),G1H3(116),G1H3(229),G1H3(230),G1H3(231),3)
  call HG1shiftOLR(G1H3(116),4,3)
  call Hotf_4pt_reduction(G2H3(33),RedSet_4(27),mass4set(:,1),  & 
G1H3(232),G1H3(233),G1H3(234),G1H3(235),G1H3(236),3)
  call HG1shiftOLR(G1H3(233),4,3)
  call Hloop_AZ_Q(ntryL,G1H3(125),ex3(:),G1H1(1),ngZu,m3h3x1(:,108),heltab2x3(:,:,108))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(104),n2h1(126))
  call Hloop_AZ_Q(ntryL,G1H3(137),ex3(:),G1H1(1),ngZu,m3h3x1(:,109),heltab2x3(:,:,109))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(105),n2h1(127))
  call Hloop_AZ_Q(ntryL,G1H3(193),ex3(:),G1H1(1),ngZu,m3h3x1(:,110),heltab2x3(:,:,110))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(106),n2h1(128))
  call Hotf_4pt_reduction(G2H3(36),RedSet_4(33),mass4set(:,15),  & 
G1H3(125),G1H3(137),G1H3(193),G1H3(237),G1H3(238),3)
  call HG1shiftOLR(G1H3(137),4,3)
  call Hloop_AZ_Q(ntryL,G1H3(136),ex3(:),G1H1(1),ngZu,m3h3x1(:,111),heltab2x3(:,:,111))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(107),n2h1(129))
  call Hloop_AZ_Q(ntryL,G1H3(215),ex3(:),G1H1(1),ngZu,m3h3x1(:,112),heltab2x3(:,:,112))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(108),n2h1(130))
  call Hotf_4pt_reduction(G2H3(37),RedSet_4(36),mass4set(:,16),  & 
G1H3(136),G1H3(215),G1H3(239),G1H3(240),G1H3(241),3)
  call HG1shiftOLR(G1H3(215),4,3)
  call Hotf_4pt_reduction(G2H3(40),RedSet_4(37),mass4set(:,1),  & 
G1H3(242),G1H3(243),G1H3(244),G1H3(245),G1H3(246),3)
  call HG1shiftOLR(G1H3(243),4,3)
  call Hloop_QZ_A(ntryL,G1H3(147),ex3(:),G1H1(1),ngZu,m3h3x1(:,113),heltab2x3(:,:,113))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(109),n2h1(131))
  call Hloop_QZ_A(ntryL,G1H3(148),ex3(:),G1H1(1),ngZu,m3h3x1(:,114),heltab2x3(:,:,114))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(110),n2h1(132))
  call Hloop_QZ_A(ntryL,G1H3(171),ex3(:),G1H1(1),ngZu,m3h3x1(:,115),heltab2x3(:,:,115))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(111),n2h1(133))
  call Hotf_4pt_reduction(G2H3(41),RedSet_4(36),mass4set(:,4),  & 
G1H3(147),G1H3(148),G1H3(171),G1H3(247),G1H3(248),3)
  call HG1shiftOLR(G1H3(148),4,3)
  call Hotf_4pt_reduction(G2H3(44),RedSet_4(37),mass4set(:,4),  & 
G1H3(249),G1H3(250),G1H3(251),G1H3(252),G1H3(253),3)
  call HG1shiftOLR(G1H3(250),4,3)
  call Hloop_QZ_A(ntryL,G1H3(158),ex3(:),G1H1(1),ngZd,m3h3x1(:,116),heltab2x3(:,:,116))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(112),n2h1(134))
  call Hloop_QZ_A(ntryL,G1H3(181),ex3(:),G1H1(1),ngZd,m3h3x1(:,117),heltab2x3(:,:,117))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(113),n2h1(135))
  call Hotf_4pt_reduction(G2H3(45),RedSet_4(36),mass4set(:,17),  & 
G1H3(158),G1H3(181),G1H3(254),G1H3(255),G1H3(256),3)
  call HG1shiftOLR(G1H3(181),4,3)
  call Hotf_4pt_reduction(G2H3(47),RedSet_4(37),mass4set(:,3),  & 
G1H3(257),G1H3(258),G1H3(259),G1H3(260),G1H3(261),3)
  call HG1shiftOLR(G1H3(258),4,3)
  call Hloop_QZ_A(ntryL,G1H3(169),ex3(:),G1H1(1),ngZu,m3h3x1(:,118),heltab2x3(:,:,118))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(114),n2h1(136))
  call Hloop_QZ_A(ntryL,G1H3(170),ex3(:),G1H1(1),ngZu,m3h3x1(:,119),heltab2x3(:,:,119))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(115),n2h1(137))
  call Hotf_4pt_reduction(G2H3(48),RedSet_4(36),mass4set(:,18),  & 
G1H3(169),G1H3(170),G1H3(262),G1H3(263),G1H3(264),3)
  call HG1shiftOLR(G1H3(170),4,3)
  call Hloop_QZ_A(ntryL,G1H3(180),ex3(:),G1H1(1),ngZd,m3h3x1(:,120),heltab2x3(:,:,120))



end subroutine vamp_1

end module ol_vamp_1_ppzwj_ew_udxzwg_1_/**/REALKIND
