
module ol_vamp_1_ppzttj_ttxzggg_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppzttj_ttxzggg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppzttj_ttxzggg_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_ppzttj_ttxzggg_1_/**/DREALKIND
  use ol_tensor_sum_storage_ppzttj_ttxzggg_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_ppzttj_ttxzggg_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_ppzttj_ttxzggg_1_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(96)
  type(Hpolcont), intent(in) :: M(11,96)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

  Gcoeff(:)%j = (c(12)*M(2,:)%j-c(13)*M(11,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1),h0tab(:,1),[32,8,2,1,4,16],[nMT,nMT,0,nMT,nMT,nMT],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,1),heltab2x96(:,:,1))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(1),n2h48(1))
  Gcoeff(:)%j = (c(12)*M(1,:)%j-c(13)*M(10,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2),h0tab(:,2),[32,4,1,2,8,16],[nMT,nMT,0,nMT,nMT,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,2),heltab2x96(:,:,2))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(2),n2h48(2))
  Gcoeff(:)%j = (c(12)*M(4,:)%j-c(13)*M(10,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(3),h0tab(:,3),[32,8,4,1,2,16],[nMT,nMT,nMT,0,nMT,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,3),heltab2x96(:,:,3))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(3),n2h48(3))
  Gcoeff(:)%j = (c(12)*M(3,:)%j-c(13)*M(11,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4),h0tab(:,4),[32,4,1,2,16,8],[nMT,nMT,0,nMT,nMT,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,4),heltab2x96(:,:,4))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(4),n2h48(4))
  Gcoeff(:)%j = (c(12)*M(6,:)%j-c(13)*M(11,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5),h0tab(:,5),[32,2,1,4,8,16],[nMT,0,nMT,nMT,nMT,nMT],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,5),heltab2x96(:,:,5))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(5),n2h48(5))
  Gcoeff(:)%j = (c(12)*M(5,:)%j-c(13)*M(10,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(6),h0tab(:,6),[32,2,1,4,16,8],[nMT,0,nMT,nMT,nMT,nMT],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,6),heltab2x96(:,:,6))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(6),n2h48(6))
  Gcoeff(:)%j = (c(12)*M(4,:)%j-c(13)*M(10,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(7),h0tab(:,7),[32,8,1,2,4,16],[nMT,nMT,0,nMT,nMT,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,7),heltab2x96(:,:,7))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(7),n2h48(7))
  Gcoeff(:)%j = (c(12)*M(6,:)%j-c(13)*M(11,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(8),h0tab(:,8),[32,4,2,1,8,16],[nMT,nMT,0,nMT,nMT,nMT],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,8),heltab2x96(:,:,8))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(8),n2h48(8))
  Gcoeff(:)%j = (c(12)*M(4,:)%j-c(13)*M(10,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(9),h0tab(:,9),[32,4,8,1,2,16],[nMT,nMT,nMT,0,nMT,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,9),heltab2x96(:,:,9))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(9),n2h48(9))
  Gcoeff(:)%j = (c(12)*M(4,:)%j-c(13)*M(10,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(10),h0tab(:,10),[32,4,16,2,1,8],[nMT,nMT,nMT,0,nMT,nMT],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,10),heltab2x96(:,:,10))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(10),n2h48(10))
  Gcoeff(:)%j = (c(12)*M(6,:)%j-c(13)*M(11,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(11),h0tab(:,11),[32,2,1,8,4,16],[nMT,0,nMT,nMT,nMT,nMT],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,11),heltab2x96(:,:,11))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(11),n2h48(11))
  Gcoeff(:)%j = (c(12)*M(6,:)%j-c(13)*M(11,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(12),h0tab(:,12),[32,2,1,8,16,4],[nMT,0,nMT,nMT,nMT,nMT],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,12),heltab2x96(:,:,12))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(12),n2h48(12))
  Gcoeff(:)%j = (c(12)*M(2,:)%j-c(13)*M(11,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(13),h0tab(:,13),[32,8,4,2,1,16],[nMT,nMT,nMT,0,nMT,nMT],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,13),heltab2x96(:,:,13))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(13),n2h48(13))
  Gcoeff(:)%j = (c(12)*M(5,:)%j-c(13)*M(10,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(14),h0tab(:,14),[32,4,2,1,16,8],[nMT,nMT,0,nMT,nMT,nMT],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,14),heltab2x96(:,:,14))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(14),n2h48(14))
  Gcoeff(:)%j = (c(12)*M(2,:)%j-c(13)*M(11,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(15),h0tab(:,15),[32,4,8,2,1,16],[nMT,nMT,nMT,0,nMT,nMT],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,15),heltab2x96(:,:,15))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(15),n2h48(15))
  Gcoeff(:)%j = (c(12)*M(2,:)%j-c(13)*M(11,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(16),h0tab(:,16),[32,4,16,1,2,8],[nMT,nMT,nMT,0,nMT,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,16),heltab2x96(:,:,16))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(16),n2h48(16))
  Gcoeff(:)%j = (c(12)*M(5,:)%j-c(13)*M(10,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(17),h0tab(:,17),[32,2,1,16,4,8],[nMT,0,nMT,nMT,nMT,nMT],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,17),heltab2x96(:,:,17))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(17),n2h48(17))
  Gcoeff(:)%j = (c(12)*M(5,:)%j-c(13)*M(10,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(18),h0tab(:,18),[32,2,1,16,8,4],[nMT,0,nMT,nMT,nMT,nMT],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,18),heltab2x96(:,:,18))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(18),n2h48(18))
  Gcoeff(:)%j = (c(12)*M(1,:)%j-c(13)*M(10,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(19),h0tab(:,19),[32,1,2,4,8,16],[nMT,0,nMT,nMT,nMT,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,19),heltab2x96(:,:,19))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(19),n2h48(19))
  Gcoeff(:)%j = (c(12)*M(3,:)%j-c(13)*M(11,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(20),h0tab(:,20),[32,1,2,4,16,8],[nMT,0,nMT,nMT,nMT,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,20),heltab2x96(:,:,20))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(20),n2h48(20))
  Gcoeff(:)%j = (c(12)*M(1,:)%j-c(13)*M(10,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(21),h0tab(:,21),[32,1,2,8,4,16],[nMT,0,nMT,nMT,nMT,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,21),heltab2x96(:,:,21))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(21),n2h48(21))
  Gcoeff(:)%j = (c(12)*M(1,:)%j-c(13)*M(10,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(22),h0tab(:,22),[32,1,2,8,16,4],[nMT,0,nMT,nMT,nMT,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,22),heltab2x96(:,:,22))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(22),n2h48(22))
  Gcoeff(:)%j = (c(12)*M(3,:)%j-c(13)*M(11,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(23),h0tab(:,23),[32,1,2,16,4,8],[nMT,0,nMT,nMT,nMT,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,23),heltab2x96(:,:,23))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(23),n2h48(23))
  Gcoeff(:)%j = (c(12)*M(3,:)%j-c(13)*M(11,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(24),h0tab(:,24),[32,1,2,16,8,4],[nMT,0,nMT,nMT,nMT,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,24),heltab2x96(:,:,24))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(24),n2h48(24))
  Gcoeff(:)%j = (c(6)*M(4,:)%j+c(4)*(M(7,:)%j+M(8,:)%j+M(9,:)%j-M(11,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(25),h0tab(:,25),[32,8,1,4,2,16],[0,0,nMT,nMT,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(25),m3h2x48(:,25),heltab2x96(:,:,25))
  Gcoeff(:)%j = (-(c(6)*M(6,:)%j)+c(4)*(-M(7,:)%j-M(8,:)%j-M(9,:)%j+M(10,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(26),h0tab(:,26),[32,2,4,1,8,16],[0,nMT,nMT,0,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(26),m3h2x48(:,26),heltab2x96(:,:,26))
  Gcoeff(:)%j = (c(4)*(-M(9,:)%j+M(10,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(27),h0tab(:,27),[32,4,1,8,2,16],[nMT,nMT,0,0,nMT,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,27),heltab2x96(:,:,27))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(27),n2h48(25))
  Gcoeff(:)%j = (c(4)*(M(9,:)%j-M(11,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(28),h0tab(:,28),[32,2,8,1,4,16],[nMT,0,0,nMT,nMT,nMT],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,28),heltab2x96(:,:,28))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(28),n2h48(26))
  Gcoeff(:)%j = (c(13)*(M(7,:)%j+M(9,:)%j-M(11,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(29),h0tab(:,29),[32,2,16,4,1,8],[0,nMT,nMT,nMT,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(29),m3h2x48(:,29),heltab2x96(:,:,29))
  Gcoeff(:)%j = (c(13)*(M(8,:)%j+M(9,:)%j-M(10,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(30),h0tab(:,30),[32,2,16,8,1,4],[nMT,0,0,0,nMT,nMT],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,30),heltab2x96(:,:,30))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(30),n2h48(27))
  Gcoeff(:)%j = (-(c(6)*M(2,:)%j)+c(4)*(-M(7,:)%j-M(8,:)%j-M(9,:)%j+M(10,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(31),h0tab(:,31),[32,8,2,4,1,16],[0,0,nMT,nMT,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(31),m3h2x48(:,31),heltab2x96(:,:,31))
  Gcoeff(:)%j = (-(c(6)*M(5,:)%j)+c(4)*(-M(7,:)%j-M(8,:)%j-M(9,:)%j+M(11,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(32),h0tab(:,32),[32,2,4,1,16,8],[0,nMT,nMT,0,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(32),m3h2x48(:,32),heltab2x96(:,:,32))
  Gcoeff(:)%j = (c(4)*(-M(8,:)%j+M(11,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(33),h0tab(:,33),[32,4,1,16,2,8],[nMT,nMT,0,0,nMT,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,33),heltab2x96(:,:,33))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(33),n2h48(28))
  Gcoeff(:)%j = (c(13)*(M(7,:)%j+M(8,:)%j-M(10,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(34),h0tab(:,34),[32,2,8,4,1,16],[0,nMT,nMT,nMT,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(34),m3h2x48(:,34),heltab2x96(:,:,34))
  Gcoeff(:)%j = (c(13)*(M(8,:)%j+M(9,:)%j-M(11,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(35),h0tab(:,35),[32,2,8,16,1,4],[nMT,0,0,0,nMT,nMT],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,35),heltab2x96(:,:,35))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(35),n2h48(29))
  Gcoeff(:)%j = (c(4)*(M(8,:)%j-M(10,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(36),h0tab(:,36),[32,2,16,1,4,8],[nMT,0,0,nMT,nMT,nMT],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,36),heltab2x96(:,:,36))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(36),n2h48(30))
  Gcoeff(:)%j = (c(6)*M(1,:)%j+c(4)*(M(7,:)%j+M(8,:)%j+M(9,:)%j-M(11,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(37),h0tab(:,37),[32,1,4,2,8,16],[0,nMT,nMT,0,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(37),m3h2x48(:,37),heltab2x96(:,:,37))
  Gcoeff(:)%j = (c(6)*M(3,:)%j+c(4)*(M(7,:)%j+M(8,:)%j+M(9,:)%j-M(10,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(38),h0tab(:,38),[32,1,4,2,16,8],[0,nMT,nMT,0,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(38),m3h2x48(:,38),heltab2x96(:,:,38))
  Gcoeff(:)%j = (c(13)*(M(7,:)%j+M(8,:)%j-M(11,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(39),h0tab(:,39),[32,1,4,8,2,16],[0,nMT,nMT,nMT,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(39),m3h2x48(:,39),heltab2x96(:,:,39))
  Gcoeff(:)%j = (c(13)*(M(7,:)%j+M(9,:)%j-M(10,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(40),h0tab(:,40),[32,1,4,16,2,8],[0,nMT,nMT,nMT,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(40),m3h2x48(:,40),heltab2x96(:,:,40))
  Gcoeff(:)%j = (c(4)*(M(7,:)%j-M(10,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(41),h0tab(:,41),[32,1,4,16,8,2],[0,nMT,nMT,nMT,nMT,0],6,0)
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(41),m3h2x48(:,41),heltab2x96(:,:,41))
  Gcoeff(:)%j = (c(4)*(M(7,:)%j-M(11,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(42),h0tab(:,42),[32,1,4,8,16,2],[0,nMT,nMT,nMT,nMT,0],6,0)
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(42),m3h2x48(:,42),heltab2x96(:,:,42))
  Gcoeff(:)%j = (c(4)*(M(9,:)%j-M(11,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(43),h0tab(:,43),[32,4,2,8,1,16],[nMT,nMT,0,0,nMT,nMT],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,43),heltab2x96(:,:,43))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(43),n2h48(31))
  Gcoeff(:)%j = (c(4)*(M(8,:)%j-M(10,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(44),h0tab(:,44),[32,4,2,16,1,8],[nMT,nMT,0,0,nMT,nMT],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,44),heltab2x96(:,:,44))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(44),n2h48(32))
  Gcoeff(:)%j = (c(13)*(M(7,:)%j+M(8,:)%j-M(10,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(45),h0tab(:,45),[32,2,4,8,1,16],[0,nMT,nMT,nMT,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(45),m3h2x48(:,45),heltab2x96(:,:,45))
  Gcoeff(:)%j = (c(13)*(M(7,:)%j+M(9,:)%j-M(11,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(46),h0tab(:,46),[32,2,4,16,1,8],[0,nMT,nMT,nMT,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(46),m3h2x48(:,46),heltab2x96(:,:,46))
  Gcoeff(:)%j = (c(4)*(M(9,:)%j-M(11,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(47),h0tab(:,47),[32,2,8,1,16,4],[nMT,0,0,nMT,nMT,nMT],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,47),heltab2x96(:,:,47))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(47),n2h48(33))
  Gcoeff(:)%j = (c(4)*(M(8,:)%j-M(10,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(48),h0tab(:,48),[32,2,16,1,8,4],[nMT,0,0,nMT,nMT,nMT],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,48),heltab2x96(:,:,48))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(48),n2h48(34))
  Gcoeff(:)%j = (c(4)*(-M(9,:)%j+M(10,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(49),h0tab(:,49),[32,1,8,2,4,16],[nMT,0,0,nMT,nMT,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,49),heltab2x96(:,:,49))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(49),n2h48(35))
  Gcoeff(:)%j = (c(13)*(M(7,:)%j+M(8,:)%j-M(11,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(50),h0tab(:,50),[32,1,8,4,2,16],[0,nMT,nMT,nMT,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(50),m3h2x48(:,50),heltab2x96(:,:,50))
  Gcoeff(:)%j = (c(13)*(M(8,:)%j+M(9,:)%j-M(10,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(51),h0tab(:,51),[32,1,8,16,2,4],[nMT,0,0,0,nMT,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,51),heltab2x96(:,:,51))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(51),n2h48(36))
  Gcoeff(:)%j = (c(4)*(M(7,:)%j-M(11,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(52),h0tab(:,52),[32,1,8,16,4,2],[0,nMT,nMT,nMT,nMT,0],6,0)
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(52),m3h2x48(:,52),heltab2x96(:,:,52))
  Gcoeff(:)%j = (c(4)*(-M(9,:)%j+M(10,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(53),h0tab(:,53),[32,1,8,2,16,4],[nMT,0,0,nMT,nMT,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,53),heltab2x96(:,:,53))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(53),n2h48(37))
  Gcoeff(:)%j = (c(4)*(M(7,:)%j-M(11,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(54),h0tab(:,54),[32,1,8,4,16,2],[0,nMT,nMT,nMT,nMT,0],6,0)
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(54),m3h2x48(:,54),heltab2x96(:,:,54))
  Gcoeff(:)%j = (c(13)*(M(7,:)%j+M(9,:)%j-M(10,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(55),h0tab(:,55),[32,1,16,4,2,8],[0,nMT,nMT,nMT,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(55),m3h2x48(:,55),heltab2x96(:,:,55))
  Gcoeff(:)%j = (c(13)*(M(8,:)%j+M(9,:)%j-M(11,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(56),h0tab(:,56),[32,1,16,8,2,4],[nMT,0,0,0,nMT,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,56),heltab2x96(:,:,56))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(56),n2h48(38))
  Gcoeff(:)%j = (c(4)*(-M(8,:)%j+M(11,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(57),h0tab(:,57),[32,1,16,2,4,8],[nMT,0,0,nMT,nMT,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,57),heltab2x96(:,:,57))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(57),n2h48(39))
  Gcoeff(:)%j = (c(4)*(M(7,:)%j-M(10,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(58),h0tab(:,58),[32,1,16,8,4,2],[0,nMT,nMT,nMT,nMT,0],6,0)
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(58),m3h2x48(:,58),heltab2x96(:,:,58))
  Gcoeff(:)%j = (c(4)*(-M(8,:)%j+M(11,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(59),h0tab(:,59),[32,1,16,2,8,4],[nMT,0,0,nMT,nMT,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,59),heltab2x96(:,:,59))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(59),n2h48(40))
  Gcoeff(:)%j = (c(4)*(M(7,:)%j-M(10,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(60),h0tab(:,60),[32,1,16,4,8,2],[0,nMT,nMT,nMT,nMT,0],6,0)
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(60),m3h2x48(:,60),heltab2x96(:,:,60))
  call Hloop_QV_A(ntryL,G1H48(1),ex4(:),G1H24(1),m3h2x24(:,1),heltab2x48(:,:,1))
  call Hloop_Q_A(ntryL,G1H24(1),40,nMT,G2H24(1),n2h24(1))
  call Hloop_AZ_Q(ntryL,G1H48(2),ex3(:),G1H16(1),ngZu,m3h3x16(:,1),heltab2x48(:,:,2))
  call Hloop_A_Q(ntryL,G1H16(1),36,nMT,G2H16(1),n2h16(1))
  call Hloop_AV_Q(ntryL,G1H48(3),ex4(:),G1H24(1),m3h2x24(:,2),heltab2x48(:,:,3))
  call Hloop_A_Q(ntryL,G1H24(1),40,nMT,G2H24(2),n2h24(2))
  call Hloop_AZ_Q(ntryL,G1H48(4),ex3(:),G1H16(1),ngZu,m3h3x16(:,2),heltab2x48(:,:,4))
  call Hloop_A_Q(ntryL,G1H16(1),36,nMT,G2H16(2),n2h16(2))
  call Hloop_QA_V(ntryL,G1H48(5),ex2(:),G1H24(1),m3h2x24(:,3),heltab2x48(:,:,5))
  call Hloop_QA_V(ntryL,G1H48(6),ex2(:),G1H24(2),m3h2x24(:,4),heltab2x48(:,:,6))
  call Hloop_AV_Q(ntryL,G1H48(7),ex4(:),G1H24(3),m3h2x24(:,5),heltab2x48(:,:,7))
  call Hloop_A_Q(ntryL,G1H24(3),40,nMT,G2H24(3),n2h24(3))
  call Hloop_QZ_A(ntryL,G1H48(8),ex3(:),G1H16(1),ngZu,m3h3x16(:,3),heltab2x48(:,:,8))
  call Hloop_Q_A(ntryL,G1H16(1),36,nMT,G2H16(3),n2h16(3))
  call Hloop_AZ_Q(ntryL,G1H48(9),ex3(:),G1H16(1),ngZu,m3h3x16(:,4),heltab2x48(:,:,9))
  call Hloop_A_Q(ntryL,G1H16(1),36,nMT,G2H16(4),n2h16(4))
  call Hloop_QZ_A(ntryL,G1H48(10),ex3(:),G1H16(1),ngZu,m3h3x16(:,5),heltab2x48(:,:,10))
  call Hloop_Q_A(ntryL,G1H16(1),36,nMT,G2H16(5),n2h16(5))
  call Hloop_QA_V(ntryL,G1H48(11),ex2(:),G1H24(3),m3h2x24(:,6),heltab2x48(:,:,11))
  call Hloop_QA_V(ntryL,G1H48(12),ex2(:),G1H24(4),m3h2x24(:,7),heltab2x48(:,:,12))
  call Hloop_QV_A(ntryL,G1H48(13),ex4(:),G1H24(5),m3h2x24(:,8),heltab2x48(:,:,13))
  call Hloop_Q_A(ntryL,G1H24(5),40,nMT,G2H24(4),n2h24(4))
  call Hloop_QZ_A(ntryL,G1H48(14),ex3(:),G1H16(1),ngZu,m3h3x16(:,6),heltab2x48(:,:,14))
  call Hloop_Q_A(ntryL,G1H16(1),36,nMT,G2H16(6),n2h16(6))
  call Hloop_QZ_A(ntryL,G1H48(15),ex3(:),G1H16(1),ngZu,m3h3x16(:,7),heltab2x48(:,:,15))
  call Hloop_Q_A(ntryL,G1H16(1),36,nMT,G2H16(7),n2h16(7))
  call Hloop_AZ_Q(ntryL,G1H48(16),ex3(:),G1H16(1),ngZu,m3h3x16(:,8),heltab2x48(:,:,16))
  call Hloop_A_Q(ntryL,G1H16(1),36,nMT,G2H16(8),n2h16(8))
  call Hloop_QA_V(ntryL,G1H48(17),ex2(:),G1H24(5),m3h2x24(:,9),heltab2x48(:,:,17))
  call Hloop_QA_V(ntryL,G1H48(18),ex2(:),G1H24(6),m3h2x24(:,10),heltab2x48(:,:,18))
  call Hloop_AQ_V(ntryL,G1H48(19),ex1(:),G1H24(7),m3h2x24(:,11),heltab2x48(:,:,19))
  call Hloop_AQ_V(ntryL,G1H48(20),ex1(:),G1H24(8),m3h2x24(:,12),heltab2x48(:,:,20))
  call Hloop_AQ_V(ntryL,G1H48(21),ex1(:),G1H24(9),m3h2x24(:,13),heltab2x48(:,:,21))
  call Hloop_AQ_V(ntryL,G1H48(22),ex1(:),G1H24(10),m3h2x24(:,14),heltab2x48(:,:,22))
  call Hloop_AQ_V(ntryL,G1H48(23),ex1(:),G1H24(11),m3h2x24(:,15),heltab2x48(:,:,23))
  call Hloop_AQ_V(ntryL,G1H48(24),ex1(:),G1H24(12),m3h2x24(:,16),heltab2x48(:,:,24))
  call Hloop_UV_W(ntryL,G1H48(25),32,ex4(:),8,G2H24(5),m3h2x24(:,17),heltab2x48(:,:,25))
  call Hloop_VA_Q(ntryL,G1H48(26),ex2(:),G1H24(13),m3h2x24(:,18),heltab2x48(:,:,26))
  call Hloop_A_Q(ntryL,G1H24(13),34,nMT,G2H24(6),n2h24(5))
  call Hloop_AZ_Q(ntryL,G1H48(27),ex3(:),G1H16(1),ngZu,m3h3x16(:,9),heltab2x48(:,:,27))
  call Hloop_A_Q(ntryL,G1H16(1),36,nMT,G2H16(9),n2h16(9))
  call Hloop_QA_V(ntryL,G1H48(28),ex2(:),G1H24(13),m3h2x24(:,19),heltab2x48(:,:,28))
  call Hloop_VA_Q(ntryL,G1H48(29),ex2(:),G1H24(14),m3h2x24(:,20),heltab2x48(:,:,29))
  call Hloop_A_Q(ntryL,G1H24(14),34,nMT,G2H24(7),n2h24(6))
  call Hloop_QA_V(ntryL,G1H48(30),ex2(:),G1H24(14),m3h2x24(:,21),heltab2x48(:,:,30))
  call Hloop_UV_W(ntryL,G1H48(31),32,ex4(:),8,G2H24(8),m3h2x24(:,22),heltab2x48(:,:,31))
  call Hloop_VA_Q(ntryL,G1H48(32),ex2(:),G1H24(15),m3h2x24(:,23),heltab2x48(:,:,32))
  call Hloop_A_Q(ntryL,G1H24(15),34,nMT,G2H24(9),n2h24(7))
  call Hloop_AZ_Q(ntryL,G1H48(33),ex3(:),G1H16(1),ngZu,m3h3x16(:,10),heltab2x48(:,:,33))
  call Hloop_A_Q(ntryL,G1H16(1),36,nMT,G2H16(10),n2h16(10))
  call Hloop_VA_Q(ntryL,G1H48(34),ex2(:),G1H24(15),m3h2x24(:,24),heltab2x48(:,:,34))
  call Hloop_A_Q(ntryL,G1H24(15),34,nMT,G2H24(10),n2h24(8))
  call Hloop_QA_V(ntryL,G1H48(35),ex2(:),G1H24(15),m3h2x24(:,25),heltab2x48(:,:,35))
  call Hloop_QA_V(ntryL,G1H48(36),ex2(:),G1H24(16),m3h2x24(:,26),heltab2x48(:,:,36))
  call Hloop_VQ_A(ntryL,G1H48(37),ex1(:),G1H24(17),m3h2x24(:,27),heltab2x48(:,:,37))
  call Hloop_Q_A(ntryL,G1H24(17),33,nMT,G2H24(11),n2h24(9))
  call Hloop_VQ_A(ntryL,G1H48(38),ex1(:),G1H24(17),m3h2x24(:,28),heltab2x48(:,:,38))
  call Hloop_Q_A(ntryL,G1H24(17),33,nMT,G2H24(12),n2h24(10))
  call Hloop_VQ_A(ntryL,G1H48(39),ex1(:),G1H24(17),m3h2x24(:,29),heltab2x48(:,:,39))
  call Hloop_Q_A(ntryL,G1H24(17),33,nMT,G2H24(13),n2h24(11))
  call Hloop_VQ_A(ntryL,G1H48(40),ex1(:),G1H24(17),m3h2x24(:,30),heltab2x48(:,:,40))
  call Hloop_Q_A(ntryL,G1H24(17),33,nMT,G2H24(14),n2h24(12))
  call Hloop_VQ_A(ntryL,G1H48(41),ex1(:),G1H24(17),m3h2x24(:,31),heltab2x48(:,:,41))
  call Hloop_Q_A(ntryL,G1H24(17),33,nMT,G2H24(15),n2h24(13))
  call Hloop_VQ_A(ntryL,G1H48(42),ex1(:),G1H24(17),m3h2x24(:,32),heltab2x48(:,:,42))
  call Hloop_Q_A(ntryL,G1H24(17),33,nMT,G2H24(16),n2h24(14))
  call Hloop_QZ_A(ntryL,G1H48(43),ex3(:),G1H16(1),ngZu,m3h3x16(:,11),heltab2x48(:,:,43))
  call Hloop_Q_A(ntryL,G1H16(1),36,nMT,G2H16(11),n2h16(11))
  call Hloop_QZ_A(ntryL,G1H48(44),ex3(:),G1H16(1),ngZu,m3h3x16(:,12),heltab2x48(:,:,44))
  call Hloop_Q_A(ntryL,G1H16(1),36,nMT,G2H16(12),n2h16(12))
  call Hloop_VA_Q(ntryL,G1H48(45),ex2(:),G1H24(17),m3h2x24(:,33),heltab2x48(:,:,45))
  call Hloop_A_Q(ntryL,G1H24(17),34,nMT,G2H24(17),n2h24(15))
  call Hloop_VA_Q(ntryL,G1H48(46),ex2(:),G1H24(17),m3h2x24(:,34),heltab2x48(:,:,46))
  call Hloop_A_Q(ntryL,G1H24(17),34,nMT,G2H24(18),n2h24(16))
  call Hloop_QA_V(ntryL,G1H48(47),ex2(:),G1H24(17),m3h2x24(:,35),heltab2x48(:,:,47))
  call Hloop_QA_V(ntryL,G1H48(48),ex2(:),G1H24(18),m3h2x24(:,36),heltab2x48(:,:,48))
  call Hloop_AQ_V(ntryL,G1H48(49),ex1(:),G1H24(19),m3h2x24(:,37),heltab2x48(:,:,49))
  call Hloop_VQ_A(ntryL,G1H48(50),ex1(:),G1H24(20),m3h2x24(:,38),heltab2x48(:,:,50))
  call Hloop_Q_A(ntryL,G1H24(20),33,nMT,G2H24(19),n2h24(17))
  call Hloop_AQ_V(ntryL,G1H48(51),ex1(:),G1H24(20),m3h2x24(:,39),heltab2x48(:,:,51))
  call Hloop_VQ_A(ntryL,G1H48(52),ex1(:),G1H24(21),m3h2x24(:,40),heltab2x48(:,:,52))
  call Hloop_Q_A(ntryL,G1H24(21),33,nMT,G2H24(20),n2h24(18))
  call Hloop_AQ_V(ntryL,G1H48(53),ex1(:),G1H24(21),m3h2x24(:,41),heltab2x48(:,:,53))
  call Hloop_VQ_A(ntryL,G1H48(54),ex1(:),G1H24(22),m3h2x24(:,42),heltab2x48(:,:,54))
  call Hloop_Q_A(ntryL,G1H24(22),33,nMT,G2H24(21),n2h24(19))
  call Hloop_VQ_A(ntryL,G1H48(55),ex1(:),G1H24(22),m3h2x24(:,43),heltab2x48(:,:,55))
  call Hloop_Q_A(ntryL,G1H24(22),33,nMT,G2H24(22),n2h24(20))
  call Hloop_AQ_V(ntryL,G1H48(56),ex1(:),G1H24(22),m3h2x24(:,44),heltab2x48(:,:,56))
  call Hloop_AQ_V(ntryL,G1H48(57),ex1(:),G1H24(23),m3h2x24(:,45),heltab2x48(:,:,57))
  call Hloop_VQ_A(ntryL,G1H48(58),ex1(:),G1H24(24),m3h2x24(:,46),heltab2x48(:,:,58))
  call Hloop_Q_A(ntryL,G1H24(24),33,nMT,G2H24(23),n2h24(21))
  call Hloop_AQ_V(ntryL,G1H48(59),ex1(:),G1H24(24),m3h2x24(:,47),heltab2x48(:,:,59))
  call Hloop_VQ_A(ntryL,G1H48(60),ex1(:),G1H24(25),m3h2x24(:,48),heltab2x48(:,:,60))
  call Hloop_Q_A(ntryL,G1H24(25),33,nMT,G2H24(24),n2h24(22))
  call Hloop_QA_V(ntryL,G2H24(1),ex2(:),G2H12(1),m3h2x12(:,1),heltab2x24(:,:,1))
  call Hloop_AQ_V(ntryL,G2H16(1),ex1(:),G2H8(1),m3h2x8(:,1),heltab2x16(:,:,1))
  call Hotf_5pt_reduction(G2H24(2),RedSet_5(1),mass5set(:,1),  & 
G1H24(25),G1H24(26),G1H24(27),G1H24(28),G1H24(29),G1H24(30),24)
  call HG1shiftOLR(G1H24(26),16,24)
  call Hloop_AQ_V(ntryL,G2H16(2),ex1(:),G2H8(2),m3h2x8(:,2),heltab2x16(:,:,2))
  call Hloop_VQ_A(ntryL,G1H24(1),ex1(:),G1H12(1),m3h2x12(:,2),heltab2x24(:,:,2))
  call Hloop_Q_A(ntryL,G1H12(1),35,nMT,G2H12(2),n2h12(1))
  call Hloop_VQ_A(ntryL,G1H24(2),ex1(:),G1H12(1),m3h2x12(:,3),heltab2x24(:,:,3))
  call Hloop_Q_A(ntryL,G1H12(1),35,nMT,G2H12(3),n2h12(2))
  call Hloop_AQ_V(ntryL,G2H24(3),ex1(:),G2H12(4),m3h2x12(:,4),heltab2x24(:,:,4))
  call Hloop_QA_V(ntryL,G2H16(3),ex2(:),G2H8(3),m3h2x8(:,3),heltab2x16(:,:,3))
  call Hotf_5pt_reduction(G2H16(4),RedSet_5(2),mass5set(:,1),  & 
G1H16(1),G1H16(2),G1H16(3),G1H16(4),G1H16(5),G1H16(6),16)
  call HG1shiftOLR(G1H16(2),16,16)
  call Hotf_5pt_reduction(G2H16(5),RedSet_5(3),mass5set(:,1),  & 
G1H16(7),G1H16(8),G1H16(9),G1H16(10),G1H16(11),G1H16(12),16)
  call HG1shiftOLR(G1H16(8),8,16)
  call Hloop_VQ_A(ntryL,G1H24(3),ex1(:),G1H12(1),m3h2x12(:,5),heltab2x24(:,:,5))
  call Hloop_Q_A(ntryL,G1H12(1),35,nMT,G2H12(5),n2h12(3))
  call Hloop_VQ_A(ntryL,G1H24(4),ex1(:),G1H12(1),m3h2x12(:,6),heltab2x24(:,:,6))
  call Hloop_Q_A(ntryL,G1H12(1),35,nMT,G2H12(6),n2h12(4))
  call Hotf_5pt_reduction(G2H24(4),RedSet_5(4),mass5set(:,1),  & 
G1H24(1),G1H24(2),G1H24(3),G1H24(4),G1H24(31),G1H24(32),24)
  call HG1shiftOLR(G1H24(2),16,24)
  call Hloop_QA_V(ntryL,G2H16(6),ex2(:),G2H8(4),m3h2x8(:,4),heltab2x16(:,:,4))
  call Hotf_5pt_reduction(G2H16(7),RedSet_5(5),mass5set(:,1),  & 
G1H16(13),G1H16(14),G1H16(15),G1H16(16),G1H16(17),G1H16(18),16)
  call HG1shiftOLR(G1H16(14),16,16)
  call Hotf_5pt_reduction(G2H16(8),RedSet_5(6),mass5set(:,1),  & 
G1H16(19),G1H16(20),G1H16(21),G1H16(22),G1H16(23),G1H16(24),16)
  call HG1shiftOLR(G1H16(20),8,16)
  call Hloop_VQ_A(ntryL,G1H24(5),ex1(:),G1H12(1),m3h2x12(:,7),heltab2x24(:,:,7))
  call Hloop_Q_A(ntryL,G1H12(1),35,nMT,G2H12(7),n2h12(5))
  call Hloop_VQ_A(ntryL,G1H24(6),ex1(:),G1H12(1),m3h2x12(:,8),heltab2x24(:,:,8))
  call Hloop_Q_A(ntryL,G1H12(1),35,nMT,G2H12(8),n2h12(6))
  call Hloop_VA_Q(ntryL,G1H24(7),ex2(:),G1H12(1),m3h2x12(:,9),heltab2x24(:,:,9))
  call Hloop_A_Q(ntryL,G1H12(1),35,nMT,G2H12(9),n2h12(7))
  call Hloop_VA_Q(ntryL,G1H24(8),ex2(:),G1H12(1),m3h2x12(:,10),heltab2x24(:,:,10))
  call Hloop_A_Q(ntryL,G1H12(1),35,nMT,G2H12(10),n2h12(8))
  call Hloop_VA_Q(ntryL,G1H24(9),ex2(:),G1H12(1),m3h2x12(:,11),heltab2x24(:,:,11))
  call Hloop_A_Q(ntryL,G1H12(1),35,nMT,G2H12(11),n2h12(9))
  call Hloop_VA_Q(ntryL,G1H24(10),ex2(:),G1H12(1),m3h2x12(:,12),heltab2x24(:,:,12))
  call Hloop_A_Q(ntryL,G1H12(1),35,nMT,G2H12(12),n2h12(10))
  call Hloop_VA_Q(ntryL,G1H24(11),ex2(:),G1H12(1),m3h2x12(:,13),heltab2x24(:,:,13))
  call Hloop_A_Q(ntryL,G1H12(1),35,nMT,G2H12(13),n2h12(11))
  call Hloop_VA_Q(ntryL,G1H24(12),ex2(:),G1H12(1),m3h2x12(:,14),heltab2x24(:,:,14))
  call Hloop_A_Q(ntryL,G1H12(1),35,nMT,G2H12(14),n2h12(12))
  call Hotf_5pt_reduction(G2H24(5),RedSet_5(7),mass5set(:,2),  & 
G1H24(5),G1H24(6),G1H24(7),G1H24(8),G1H24(9),G1H24(10),24)
  call HG1shiftOLR(G1H24(6),16,24)
  call Hotf_5pt_reduction(G2H24(6),RedSet_5(8),mass5set(:,3),  & 
G1H24(11),G1H24(12),G1H24(33),G1H24(34),G1H24(35),G1H24(36),24)
  call HG1shiftOLR(G1H24(12),16,24)
  call Hloop_AQ_V(ntryL,G2H16(9),ex1(:),G2H8(5),m3h2x8(:,5),heltab2x16(:,:,5))
  call Hloop_UV_W(ntryL,G1H24(13),34,ex4(:),8,G2H12(15),m3h2x12(:,15),heltab2x24(:,:,15))
  call Hotf_5pt_reduction(G2H24(7),RedSet_5(9),mass5set(:,4),  & 
G1H24(13),G1H24(37),G1H24(38),G1H24(39),G1H24(40),G1H24(41),24)
  call HG1shiftOLR(G1H24(37),8,24)
  call Hloop_UV_W(ntryL,G1H24(14),34,ex5(:),16,G2H12(16),m3h2x12(:,16),heltab2x24(:,:,16))
  call Hotf_5pt_reduction(G2H24(8),RedSet_5(10),mass5set(:,2),  & 
G1H24(14),G1H24(42),G1H24(43),G1H24(44),G1H24(45),G1H24(46),24)
  call HG1shiftOLR(G1H24(42),16,24)
  call Hotf_5pt_reduction(G2H24(9),RedSet_5(8),mass5set(:,3),  & 
G1H24(47),G1H24(48),G1H24(49),G1H24(50),G1H24(51),G1H24(52),24)
  call HG1shiftOLR(G1H24(48),8,24)
  call Hloop_AQ_V(ntryL,G2H16(10),ex1(:),G2H8(6),m3h2x8(:,6),heltab2x16(:,:,6))
  call Hotf_5pt_reduction(G2H24(10),RedSet_5(11),mass5set(:,4),  & 
G1H24(53),G1H24(54),G1H24(55),G1H24(56),G1H24(57),G1H24(58),24)
  call HG1shiftOLR(G1H24(54),16,24)
  call Hloop_UV_W(ntryL,G1H24(15),34,ex4(:),8,G2H12(17),m3h2x12(:,17),heltab2x24(:,:,17))
  call Hloop_UV_W(ntryL,G1H24(16),34,ex5(:),16,G2H12(18),m3h2x12(:,18),heltab2x24(:,:,18))
  call Hotf_5pt_reduction(G2H24(11),RedSet_5(12),mass5set(:,3),  & 
G1H24(15),G1H24(16),G1H24(59),G1H24(60),G1H24(61),G1H24(62),24)
  call HG1shiftOLR(G1H24(16),16,24)
  call Hotf_5pt_reduction(G2H24(12),RedSet_5(12),mass5set(:,3),  & 
G1H24(63),G1H24(64),G1H24(65),G1H24(66),G1H24(67),G1H24(68),24)
  call HG1shiftOLR(G1H24(64),8,24)
  call Hotf_5pt_reduction(G2H24(13),RedSet_5(13),mass5set(:,4),  & 
G1H24(69),G1H24(70),G1H24(71),G1H24(72),G1H24(73),G1H24(74),24)
  call HG1shiftOLR(G1H24(70),16,24)
  call Hotf_5pt_reduction(G2H24(14),RedSet_5(14),mass5set(:,4),  & 
G1H24(75),G1H24(76),G1H24(77),G1H24(78),G1H24(79),G1H24(80),24)
  call HG1shiftOLR(G1H24(76),8,24)
  call Hotf_5pt_reduction(G2H24(15),RedSet_5(14),mass5set(:,4),  & 
G1H24(81),G1H24(82),G1H24(83),G1H24(84),G1H24(85),G1H24(86),24)
  call HG1shiftOLR(G1H24(82),2,24)
  call Hotf_5pt_reduction(G2H24(16),RedSet_5(13),mass5set(:,4),  & 
G1H24(87),G1H24(88),G1H24(89),G1H24(90),G1H24(91),G1H24(92),24)
  call HG1shiftOLR(G1H24(88),2,24)
  call Hloop_QA_V(ntryL,G2H16(11),ex2(:),G2H8(7),m3h2x8(:,7),heltab2x16(:,:,7))
  call Hloop_QA_V(ntryL,G2H16(12),ex2(:),G2H8(8),m3h2x8(:,8),heltab2x16(:,:,8))
  call Hotf_5pt_reduction(G2H24(17),RedSet_5(15),mass5set(:,4),  & 
G1H24(93),G1H24(94),G1H24(95),G1H24(96),G1H24(97),G1H24(98),24)
  call HG1shiftOLR(G1H24(94),16,24)
  call Hotf_5pt_reduction(G2H24(18),RedSet_5(16),mass5set(:,4),  & 
G1H24(99),G1H24(100),G1H24(101),G1H24(102),G1H24(103),G1H24(104),24)
  call HG1shiftOLR(G1H24(100),8,24)
  call Hloop_UV_W(ntryL,G1H24(17),34,ex4(:),8,G2H12(19),m3h2x12(:,19),heltab2x24(:,:,19))
  call Hloop_UV_W(ntryL,G1H24(18),34,ex5(:),16,G2H12(20),m3h2x12(:,20),heltab2x24(:,:,20))
  call Hloop_UV_W(ntryL,G1H24(19),33,ex4(:),8,G2H12(21),m3h2x12(:,21),heltab2x24(:,:,21))
  call Hotf_5pt_reduction(G2H24(19),RedSet_5(17),mass5set(:,4),  & 
G1H24(17),G1H24(18),G1H24(19),G1H24(105),G1H24(106),G1H24(107),24)
  call HG1shiftOLR(G1H24(18),16,24)
  call Hloop_UV_W(ntryL,G1H24(20),33,ex4(:),8,G2H12(22),m3h2x12(:,22),heltab2x24(:,:,22))
  call Hotf_5pt_reduction(G2H24(20),RedSet_5(18),mass5set(:,4),  & 
G1H24(20),G1H24(108),G1H24(109),G1H24(110),G1H24(111),G1H24(112),24)
  call HG1shiftOLR(G1H24(108),2,24)
  call Hloop_UV_W(ntryL,G1H24(21),33,ex4(:),8,G2H12(23),m3h2x12(:,23),heltab2x24(:,:,23))
  call Hotf_5pt_reduction(G2H24(21),RedSet_5(17),mass5set(:,4),  & 
G1H24(21),G1H24(113),G1H24(114),G1H24(115),G1H24(116),G1H24(117),24)
  call HG1shiftOLR(G1H24(113),2,24)
  call Hotf_5pt_reduction(G2H24(22),RedSet_5(19),mass5set(:,4),  & 
G1H24(118),G1H24(119),G1H24(120),G1H24(121),G1H24(122),G1H24(123),24)
  call HG1shiftOLR(G1H24(119),8,24)
  call Hloop_UV_W(ntryL,G1H24(22),33,ex5(:),16,G2H12(24),m3h2x12(:,24),heltab2x24(:,:,24))
  call Hloop_UV_W(ntryL,G1H24(23),33,ex5(:),16,G2H12(25),m3h2x12(:,25),heltab2x24(:,:,25))
  call Hotf_5pt_reduction(G2H24(23),RedSet_5(20),mass5set(:,4),  & 
G1H24(22),G1H24(23),G1H24(124),G1H24(125),G1H24(126),G1H24(127),24)
  call HG1shiftOLR(G1H24(23),2,24)
  call Hloop_UV_W(ntryL,G1H24(24),33,ex5(:),16,G2H12(26),m3h2x12(:,26),heltab2x24(:,:,26))
  call Hotf_5pt_reduction(G2H24(24),RedSet_5(19),mass5set(:,4),  & 
G1H24(24),G1H24(128),G1H24(129),G1H24(130),G1H24(131),G1H24(132),24)
  call HG1shiftOLR(G1H24(128),2,24)
  call Hloop_AZ_Q(ntryL,G1H24(25),ex3(:),G1H8(1),ngZu,m3h3x8(:,1),heltab2x24(:,:,27))
  call Hloop_A_Q(ntryL,G1H8(1),44,nMT,G2H8(9),n2h8(1))
call HGT_OLR(G1H24(26),1,1,24)
call HGT_invQ_OLR(G1H24(26),2,5,24)
  call Hloop_Q_A(ntryL,G1H24(26),-16,nMT,G2H24(1),n2h24(23))
  call Hloop_QV_A(ntryL,G2H24(1),ex5(:),G2H12(27),m3h2x12(:,27),heltab2x24(:,:,28))
  call Hloop_AZ_Q(ntryL,G1H24(28),ex3(:),G1H8(1),ngZu,m3h3x8(:,2),heltab2x24(:,:,29))
  call Hloop_A_Q(ntryL,G1H8(1),44,nMT,G2H8(10),n2h8(2))
  call Hloop_AZ_Q(ntryL,G1H24(29),ex3(:),G1H8(1),ngZu,m3h3x8(:,3),heltab2x24(:,:,30))
  call Hloop_A_Q(ntryL,G1H8(1),44,nMT,G2H8(11),n2h8(3))
  call Hloop_AZ_Q(ntryL,G1H24(30),ex3(:),G1H8(1),ngZu,m3h3x8(:,4),heltab2x24(:,:,31))
  call Hloop_A_Q(ntryL,G1H8(1),44,nMT,G2H8(12),n2h8(4))
  call Hloop_AV_Q(ntryL,G1H16(1),ex4(:),G1H8(1),m3h2x8(:,9),heltab2x16(:,:,9))
  call Hloop_A_Q(ntryL,G1H8(1),44,nMT,G2H8(13),n2h8(5))
call HGT_OLR(G1H16(2),1,1,16)
call HGT_invQ_OLR(G1H16(2),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(2),-16,nMT,G2H16(1),n2h16(13))
  call Hloop_QV_A(ntryL,G2H16(1),ex5(:),G2H8(14),m3h2x8(:,10),heltab2x16(:,:,10))
  call Hloop_AV_Q(ntryL,G1H16(4),ex4(:),G1H8(1),m3h2x8(:,11),heltab2x16(:,:,11))
  call Hloop_A_Q(ntryL,G1H8(1),44,nMT,G2H8(15),n2h8(6))
  call Hloop_AV_Q(ntryL,G1H16(5),ex4(:),G1H8(1),m3h2x8(:,12),heltab2x16(:,:,12))
  call Hloop_A_Q(ntryL,G1H8(1),44,nMT,G2H8(16),n2h8(7))
  call Hloop_AV_Q(ntryL,G1H16(6),ex4(:),G1H8(1),m3h2x8(:,13),heltab2x16(:,:,13))
  call Hloop_A_Q(ntryL,G1H8(1),44,nMT,G2H8(17),n2h8(8))
  call Hloop_QV_A(ntryL,G1H16(7),ex5(:),G1H8(1),m3h2x8(:,14),heltab2x16(:,:,14))
  call Hloop_Q_A(ntryL,G1H8(1),52,nMT,G2H8(18),n2h8(9))
call HGT_OLR(G1H16(8),1,1,16)
call HGT_invQ_OLR(G1H16(8),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(8),-8,nMT,G2H16(2),n2h16(14))
  call Hloop_AV_Q(ntryL,G2H16(2),ex4(:),G2H8(19),m3h2x8(:,15),heltab2x16(:,:,15))
  call Hloop_QV_A(ntryL,G1H16(10),ex5(:),G1H8(1),m3h2x8(:,16),heltab2x16(:,:,16))
  call Hloop_Q_A(ntryL,G1H8(1),52,nMT,G2H8(20),n2h8(10))
  call Hloop_QV_A(ntryL,G1H16(11),ex5(:),G1H8(1),m3h2x8(:,17),heltab2x16(:,:,17))
  call Hloop_Q_A(ntryL,G1H8(1),52,nMT,G2H8(21),n2h8(11))
  call Hloop_QV_A(ntryL,G1H16(12),ex5(:),G1H8(1),m3h2x8(:,18),heltab2x16(:,:,18))
  call Hloop_Q_A(ntryL,G1H8(1),52,nMT,G2H8(22),n2h8(12))
  call Hloop_QZ_A(ntryL,G1H24(1),ex3(:),G1H8(1),ngZu,m3h3x8(:,5),heltab2x24(:,:,32))
  call Hloop_Q_A(ntryL,G1H8(1),44,nMT,G2H8(23),n2h8(13))
call HGT_OLR(G1H24(2),1,1,24)
call HGT_invQ_OLR(G1H24(2),2,5,24)
  call Hloop_A_Q(ntryL,G1H24(2),-16,nMT,G2H24(2),n2h24(24))
  call Hloop_AV_Q(ntryL,G2H24(2),ex5(:),G2H12(28),m3h2x12(:,28),heltab2x24(:,:,33))
  call Hloop_QZ_A(ntryL,G1H24(4),ex3(:),G1H8(1),ngZu,m3h3x8(:,6),heltab2x24(:,:,34))
  call Hloop_Q_A(ntryL,G1H8(1),44,nMT,G2H8(24),n2h8(14))
  call Hloop_QZ_A(ntryL,G1H24(31),ex3(:),G1H8(1),ngZu,m3h3x8(:,7),heltab2x24(:,:,35))
  call Hloop_Q_A(ntryL,G1H8(1),44,nMT,G2H8(25),n2h8(15))
  call Hloop_QZ_A(ntryL,G1H24(32),ex3(:),G1H8(1),ngZu,m3h3x8(:,8),heltab2x24(:,:,36))
  call Hloop_Q_A(ntryL,G1H8(1),44,nMT,G2H8(26),n2h8(16))
  call Hloop_QV_A(ntryL,G1H16(13),ex4(:),G1H8(1),m3h2x8(:,19),heltab2x16(:,:,19))
  call Hloop_Q_A(ntryL,G1H8(1),44,nMT,G2H8(27),n2h8(17))
call HGT_OLR(G1H16(14),1,1,16)
call HGT_invQ_OLR(G1H16(14),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(14),-16,nMT,G2H16(3),n2h16(15))
  call Hloop_AV_Q(ntryL,G2H16(3),ex5(:),G2H8(28),m3h2x8(:,20),heltab2x16(:,:,20))
  call Hloop_QV_A(ntryL,G1H16(16),ex4(:),G1H8(1),m3h2x8(:,21),heltab2x16(:,:,21))
  call Hloop_Q_A(ntryL,G1H8(1),44,nMT,G2H8(29),n2h8(18))
  call Hloop_QV_A(ntryL,G1H16(17),ex4(:),G1H8(1),m3h2x8(:,22),heltab2x16(:,:,22))
  call Hloop_Q_A(ntryL,G1H8(1),44,nMT,G2H8(30),n2h8(19))
  call Hloop_QV_A(ntryL,G1H16(18),ex4(:),G1H8(1),m3h2x8(:,23),heltab2x16(:,:,23))
  call Hloop_Q_A(ntryL,G1H8(1),44,nMT,G2H8(31),n2h8(20))
  call Hloop_AV_Q(ntryL,G1H16(19),ex5(:),G1H8(1),m3h2x8(:,24),heltab2x16(:,:,24))
  call Hloop_A_Q(ntryL,G1H8(1),52,nMT,G2H8(32),n2h8(21))
call HGT_OLR(G1H16(20),1,1,16)
call HGT_invQ_OLR(G1H16(20),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(20),-8,nMT,G2H16(4),n2h16(16))
  call Hloop_QV_A(ntryL,G2H16(4),ex4(:),G2H8(33),m3h2x8(:,25),heltab2x16(:,:,25))
  call Hloop_AV_Q(ntryL,G1H16(22),ex5(:),G1H8(1),m3h2x8(:,26),heltab2x16(:,:,26))
  call Hloop_A_Q(ntryL,G1H8(1),52,nMT,G2H8(34),n2h8(22))
  call Hloop_AV_Q(ntryL,G1H16(23),ex5(:),G1H8(1),m3h2x8(:,27),heltab2x16(:,:,27))
  call Hloop_A_Q(ntryL,G1H8(1),52,nMT,G2H8(35),n2h8(23))
  call Hloop_AV_Q(ntryL,G1H16(24),ex5(:),G1H8(1),m3h2x8(:,28),heltab2x16(:,:,28))
  call Hloop_A_Q(ntryL,G1H8(1),52,nMT,G2H8(36),n2h8(24))
  call Hloop_VQ_A(ntryL,G1H24(5),ex1(:),G1H12(1),m3h2x12(:,29),heltab2x24(:,:,37))
  call Hloop_Q_A(ntryL,G1H12(1),41,nMT,G2H12(29),n2h12(13))
call HGT_raise_alpha_OLR(G1H24(6),1,1,24)
call HGT_raise_alpha_invQ_OLR(G1H24(6),2,5,24)
  call Hloop_UV_W(ntryL,G1H24(6),-16,ex5(:),16,G2H12(30),m3h2x12(:,30),heltab2x24(:,:,38))
call signflip_OLR(G2H12(30))
  call Hloop_VQ_A(ntryL,G1H24(8),ex1(:),G1H12(1),m3h2x12(:,31),heltab2x24(:,:,39))
  call Hloop_Q_A(ntryL,G1H12(1),41,nMT,G2H12(31),n2h12(14))
  call Hloop_VQ_A(ntryL,G1H24(9),ex1(:),G1H12(1),m3h2x12(:,32),heltab2x24(:,:,40))
  call Hloop_Q_A(ntryL,G1H12(1),41,nMT,G2H12(32),n2h12(15))
  call Hloop_VQ_A(ntryL,G1H24(10),ex1(:),G1H12(1),m3h2x12(:,33),heltab2x24(:,:,41))
  call Hloop_Q_A(ntryL,G1H12(1),41,nMT,G2H12(33),n2h12(16))
  call Hloop_AZ_Q(ntryL,G1H24(11),ex3(:),G1H8(1),ngZu,m3h3x8(:,9),heltab2x24(:,:,42))
  call Hloop_A_Q(ntryL,G1H8(1),38,nMT,G2H8(37),n2h8(25))
call HGT_raise_alpha_OLR(G1H24(12),1,1,24)
call HGT_raise_alpha_invQ_OLR(G1H24(12),2,5,24)
  call Hloop_UV_W(ntryL,G1H24(12),-16,ex5(:),16,G2H12(34),m3h2x12(:,34),heltab2x24(:,:,43))
call signflip_OLR(G2H12(34))
  call Hloop_AZ_Q(ntryL,G1H24(34),ex3(:),G1H8(1),ngZu,m3h3x8(:,10),heltab2x24(:,:,44))
  call Hloop_A_Q(ntryL,G1H8(1),38,nMT,G2H8(38),n2h8(26))
  call Hloop_AZ_Q(ntryL,G1H24(35),ex3(:),G1H8(1),ngZu,m3h3x8(:,11),heltab2x24(:,:,45))
  call Hloop_A_Q(ntryL,G1H8(1),38,nMT,G2H8(39),n2h8(27))
  call Hloop_AZ_Q(ntryL,G1H24(36),ex3(:),G1H8(1),ngZu,m3h3x8(:,12),heltab2x24(:,:,46))
  call Hloop_A_Q(ntryL,G1H8(1),38,nMT,G2H8(40),n2h8(28))
  call Hloop_AV_Q(ntryL,G1H24(13),ex5(:),G1H12(1),m3h2x12(:,35),heltab2x24(:,:,47))
  call Hloop_A_Q(ntryL,G1H12(1),50,nMT,G2H12(35),n2h12(17))
call HGT_raise_alpha_OLR(G1H24(37),1,1,24)
call HGT_raise_alpha_invQ_OLR(G1H24(37),2,5,24)
  call Hloop_UV_W(ntryL,G1H24(37),-8,ex4(:),8,G2H12(36),m3h2x12(:,36),heltab2x24(:,:,48))
call signflip_OLR(G2H12(36))
  call Hloop_AV_Q(ntryL,G1H24(39),ex5(:),G1H12(1),m3h2x12(:,37),heltab2x24(:,:,49))
  call Hloop_A_Q(ntryL,G1H12(1),50,nMT,G2H12(37),n2h12(18))
  call Hloop_AV_Q(ntryL,G1H24(40),ex5(:),G1H12(1),m3h2x12(:,38),heltab2x24(:,:,50))
  call Hloop_A_Q(ntryL,G1H12(1),50,nMT,G2H12(38),n2h12(19))
  call Hloop_AV_Q(ntryL,G1H24(41),ex5(:),G1H12(1),m3h2x12(:,39),heltab2x24(:,:,51))
  call Hloop_A_Q(ntryL,G1H12(1),50,nMT,G2H12(39),n2h12(20))
  call Hloop_VA_Q(ntryL,G1H24(14),ex2(:),G1H12(1),m3h2x12(:,40),heltab2x24(:,:,52))
  call Hloop_A_Q(ntryL,G1H12(1),42,nMT,G2H12(40),n2h12(21))
call HGT_raise_alpha_OLR(G1H24(42),1,1,24)
call HGT_raise_alpha_invQ_OLR(G1H24(42),2,5,24)
  call Hloop_UV_W(ntryL,G1H24(42),-16,ex5(:),16,G2H12(41),m3h2x12(:,41),heltab2x24(:,:,53))
call signflip_OLR(G2H12(41))
  call Hloop_VA_Q(ntryL,G1H24(44),ex2(:),G1H12(1),m3h2x12(:,42),heltab2x24(:,:,54))
  call Hloop_A_Q(ntryL,G1H12(1),42,nMT,G2H12(42),n2h12(22))
  call Hloop_VA_Q(ntryL,G1H24(45),ex2(:),G1H12(1),m3h2x12(:,43),heltab2x24(:,:,55))
  call Hloop_A_Q(ntryL,G1H12(1),42,nMT,G2H12(43),n2h12(23))
  call Hloop_VA_Q(ntryL,G1H24(46),ex2(:),G1H12(1),m3h2x12(:,44),heltab2x24(:,:,56))
  call Hloop_A_Q(ntryL,G1H12(1),42,nMT,G2H12(44),n2h12(24))
  call Hloop_AZ_Q(ntryL,G1H24(47),ex3(:),G1H8(1),ngZu,m3h3x8(:,13),heltab2x24(:,:,57))
  call Hloop_A_Q(ntryL,G1H8(1),38,nMT,G2H8(41),n2h8(29))
call HGT_raise_alpha_OLR(G1H24(48),1,1,24)
call HGT_raise_alpha_invQ_OLR(G1H24(48),2,5,24)
  call Hloop_UV_W(ntryL,G1H24(48),-8,ex4(:),8,G2H12(45),m3h2x12(:,45),heltab2x24(:,:,58))
call signflip_OLR(G2H12(45))
  call Hloop_AZ_Q(ntryL,G1H24(50),ex3(:),G1H8(1),ngZu,m3h3x8(:,14),heltab2x24(:,:,59))
  call Hloop_A_Q(ntryL,G1H8(1),38,nMT,G2H8(42),n2h8(30))
  call Hloop_AZ_Q(ntryL,G1H24(51),ex3(:),G1H8(1),ngZu,m3h3x8(:,15),heltab2x24(:,:,60))
  call Hloop_A_Q(ntryL,G1H8(1),38,nMT,G2H8(43),n2h8(31))
  call Hloop_AZ_Q(ntryL,G1H24(52),ex3(:),G1H8(1),ngZu,m3h3x8(:,16),heltab2x24(:,:,61))
  call Hloop_A_Q(ntryL,G1H8(1),38,nMT,G2H8(44),n2h8(32))
  call Hloop_AV_Q(ntryL,G1H24(53),ex4(:),G1H12(1),m3h2x12(:,46),heltab2x24(:,:,62))
  call Hloop_A_Q(ntryL,G1H12(1),42,nMT,G2H12(46),n2h12(25))
call HGT_raise_alpha_OLR(G1H24(54),1,1,24)
call HGT_raise_alpha_invQ_OLR(G1H24(54),2,5,24)
  call Hloop_UV_W(ntryL,G1H24(54),-16,ex5(:),16,G2H12(47),m3h2x12(:,47),heltab2x24(:,:,63))
call signflip_OLR(G2H12(47))
  call Hloop_AV_Q(ntryL,G1H24(56),ex4(:),G1H12(1),m3h2x12(:,48),heltab2x24(:,:,64))
  call Hloop_A_Q(ntryL,G1H12(1),42,nMT,G2H12(48),n2h12(26))
  call Hloop_AV_Q(ntryL,G1H24(57),ex4(:),G1H12(1),m3h2x12(:,49),heltab2x24(:,:,65))
  call Hloop_A_Q(ntryL,G1H12(1),42,nMT,G2H12(49),n2h12(27))
  call Hloop_AV_Q(ntryL,G1H24(58),ex4(:),G1H12(1),m3h2x12(:,50),heltab2x24(:,:,66))
  call Hloop_A_Q(ntryL,G1H12(1),42,nMT,G2H12(50),n2h12(28))
  call Hloop_QZ_A(ntryL,G1H24(15),ex3(:),G1H8(1),ngZu,m3h3x8(:,17),heltab2x24(:,:,67))
  call Hloop_Q_A(ntryL,G1H8(1),37,nMT,G2H8(45),n2h8(33))
call HGT_raise_alpha_OLR(G1H24(16),1,1,24)
call HGT_raise_alpha_invQ_OLR(G1H24(16),2,5,24)
  call Hloop_UV_W(ntryL,G1H24(16),-16,ex5(:),16,G2H12(51),m3h2x12(:,51),heltab2x24(:,:,68))
call signflip_OLR(G2H12(51))
  call Hloop_QZ_A(ntryL,G1H24(60),ex3(:),G1H8(1),ngZu,m3h3x8(:,18),heltab2x24(:,:,69))
  call Hloop_Q_A(ntryL,G1H8(1),37,nMT,G2H8(46),n2h8(34))
  call Hloop_QZ_A(ntryL,G1H24(61),ex3(:),G1H8(1),ngZu,m3h3x8(:,19),heltab2x24(:,:,70))
  call Hloop_Q_A(ntryL,G1H8(1),37,nMT,G2H8(47),n2h8(35))
  call Hloop_QZ_A(ntryL,G1H24(62),ex3(:),G1H8(1),ngZu,m3h3x8(:,20),heltab2x24(:,:,71))
  call Hloop_Q_A(ntryL,G1H8(1),37,nMT,G2H8(48),n2h8(36))
  call Hloop_QZ_A(ntryL,G1H24(63),ex3(:),G1H8(1),ngZu,m3h3x8(:,21),heltab2x24(:,:,72))
  call Hloop_Q_A(ntryL,G1H8(1),37,nMT,G2H8(49),n2h8(37))
call HGT_raise_alpha_OLR(G1H24(64),1,1,24)
call HGT_raise_alpha_invQ_OLR(G1H24(64),2,5,24)
  call Hloop_UV_W(ntryL,G1H24(64),-8,ex4(:),8,G2H12(52),m3h2x12(:,52),heltab2x24(:,:,73))
call signflip_OLR(G2H12(52))
  call Hloop_QZ_A(ntryL,G1H24(66),ex3(:),G1H8(1),ngZu,m3h3x8(:,22),heltab2x24(:,:,74))
  call Hloop_Q_A(ntryL,G1H8(1),37,nMT,G2H8(50),n2h8(38))
  call Hloop_QZ_A(ntryL,G1H24(67),ex3(:),G1H8(1),ngZu,m3h3x8(:,23),heltab2x24(:,:,75))
  call Hloop_Q_A(ntryL,G1H8(1),37,nMT,G2H8(51),n2h8(39))
  call Hloop_QZ_A(ntryL,G1H24(68),ex3(:),G1H8(1),ngZu,m3h3x8(:,24),heltab2x24(:,:,76))
  call Hloop_Q_A(ntryL,G1H8(1),37,nMT,G2H8(52),n2h8(40))
  call Hloop_QZ_A(ntryL,G1H24(69),ex3(:),G1H8(1),ngZu,m3h3x8(:,25),heltab2x24(:,:,77))
  call Hloop_Q_A(ntryL,G1H8(1),37,nMT,G2H8(53),n2h8(41))
call HGT_raise_alpha_OLR(G1H24(70),1,1,24)
call HGT_raise_alpha_invQ_OLR(G1H24(70),2,5,24)
  call Hloop_UV_W(ntryL,G1H24(70),-16,ex5(:),16,G2H12(53),m3h2x12(:,53),heltab2x24(:,:,78))
call signflip_OLR(G2H12(53))
  call Hloop_QZ_A(ntryL,G1H24(72),ex3(:),G1H8(1),ngZu,m3h3x8(:,26),heltab2x24(:,:,79))
  call Hloop_Q_A(ntryL,G1H8(1),37,nMT,G2H8(54),n2h8(42))
  call Hloop_QZ_A(ntryL,G1H24(73),ex3(:),G1H8(1),ngZu,m3h3x8(:,27),heltab2x24(:,:,80))
  call Hloop_Q_A(ntryL,G1H8(1),37,nMT,G2H8(55),n2h8(43))
  call Hloop_QZ_A(ntryL,G1H24(74),ex3(:),G1H8(1),ngZu,m3h3x8(:,28),heltab2x24(:,:,81))
  call Hloop_Q_A(ntryL,G1H8(1),37,nMT,G2H8(56),n2h8(44))
  call Hloop_QZ_A(ntryL,G1H24(75),ex3(:),G1H8(1),ngZu,m3h3x8(:,29),heltab2x24(:,:,82))
  call Hloop_Q_A(ntryL,G1H8(1),37,nMT,G2H8(57),n2h8(45))
call HGT_raise_alpha_OLR(G1H24(76),1,1,24)
call HGT_raise_alpha_invQ_OLR(G1H24(76),2,5,24)
  call Hloop_UV_W(ntryL,G1H24(76),-8,ex4(:),8,G2H12(54),m3h2x12(:,54),heltab2x24(:,:,83))
call signflip_OLR(G2H12(54))
  call Hloop_QZ_A(ntryL,G1H24(78),ex3(:),G1H8(1),ngZu,m3h3x8(:,30),heltab2x24(:,:,84))
  call Hloop_Q_A(ntryL,G1H8(1),37,nMT,G2H8(58),n2h8(46))
  call Hloop_QZ_A(ntryL,G1H24(79),ex3(:),G1H8(1),ngZu,m3h3x8(:,31),heltab2x24(:,:,85))
  call Hloop_Q_A(ntryL,G1H8(1),37,nMT,G2H8(59),n2h8(47))
  call Hloop_QZ_A(ntryL,G1H24(80),ex3(:),G1H8(1),ngZu,m3h3x8(:,32),heltab2x24(:,:,86))
  call Hloop_Q_A(ntryL,G1H8(1),37,nMT,G2H8(60),n2h8(48))
  call Hloop_QZ_A(ntryL,G1H24(81),ex3(:),G1H8(1),ngZu,m3h3x8(:,33),heltab2x24(:,:,87))
  call Hloop_Q_A(ntryL,G1H8(1),37,nMT,G2H8(61),n2h8(49))
call HGT_raise_alpha_OLR(G1H24(82),1,1,24)
call HGT_raise_alpha_invQ_OLR(G1H24(82),2,5,24)
  call Hloop_VA_Q(ntryL,G1H24(82),ex2(:),G1H12(1),m3h2x12(:,55),heltab2x24(:,:,88))
  call Hloop_QZ_A(ntryL,G1H24(84),ex3(:),G1H8(1),ngZu,m3h3x8(:,34),heltab2x24(:,:,89))
  call Hloop_Q_A(ntryL,G1H8(1),37,nMT,G2H8(62),n2h8(50))
  call Hloop_QZ_A(ntryL,G1H24(85),ex3(:),G1H8(1),ngZu,m3h3x8(:,35),heltab2x24(:,:,90))
  call Hloop_Q_A(ntryL,G1H8(1),37,nMT,G2H8(63),n2h8(51))
  call Hloop_QZ_A(ntryL,G1H24(86),ex3(:),G1H8(1),ngZu,m3h3x8(:,36),heltab2x24(:,:,91))
  call Hloop_Q_A(ntryL,G1H8(1),37,nMT,G2H8(64),n2h8(52))
  call Hloop_QZ_A(ntryL,G1H24(87),ex3(:),G1H8(1),ngZu,m3h3x8(:,37),heltab2x24(:,:,92))
  call Hloop_Q_A(ntryL,G1H8(1),37,nMT,G2H8(65),n2h8(53))
call HGT_raise_alpha_OLR(G1H24(88),1,1,24)
call HGT_raise_alpha_invQ_OLR(G1H24(88),2,5,24)
  call Hloop_VA_Q(ntryL,G1H24(88),ex2(:),G1H12(2),m3h2x12(:,56),heltab2x24(:,:,93))
  call Hloop_QZ_A(ntryL,G1H24(90),ex3(:),G1H8(1),ngZu,m3h3x8(:,38),heltab2x24(:,:,94))
  call Hloop_Q_A(ntryL,G1H8(1),37,nMT,G2H8(66),n2h8(54))
  call Hloop_QZ_A(ntryL,G1H24(91),ex3(:),G1H8(1),ngZu,m3h3x8(:,39),heltab2x24(:,:,95))
  call Hloop_Q_A(ntryL,G1H8(1),37,nMT,G2H8(67),n2h8(55))
  call Hloop_QZ_A(ntryL,G1H24(92),ex3(:),G1H8(1),ngZu,m3h3x8(:,40),heltab2x24(:,:,96))
  call Hloop_Q_A(ntryL,G1H8(1),37,nMT,G2H8(68),n2h8(56))
  call Hloop_AZ_Q(ntryL,G1H24(93),ex3(:),G1H8(1),ngZu,m3h3x8(:,41),heltab2x24(:,:,97))
  call Hloop_A_Q(ntryL,G1H8(1),38,nMT,G2H8(69),n2h8(57))
call HGT_raise_alpha_OLR(G1H24(94),1,1,24)
call HGT_raise_alpha_invQ_OLR(G1H24(94),2,5,24)
  call Hloop_UV_W(ntryL,G1H24(94),-16,ex5(:),16,G2H12(55),m3h2x12(:,57),heltab2x24(:,:,98))
call signflip_OLR(G2H12(55))
  call Hloop_AZ_Q(ntryL,G1H24(96),ex3(:),G1H8(1),ngZu,m3h3x8(:,42),heltab2x24(:,:,99))
  call Hloop_A_Q(ntryL,G1H8(1),38,nMT,G2H8(70),n2h8(58))
  call Hloop_AZ_Q(ntryL,G1H24(97),ex3(:),G1H8(1),ngZu,m3h3x8(:,43),heltab2x24(:,:,100))
  call Hloop_A_Q(ntryL,G1H8(1),38,nMT,G2H8(71),n2h8(59))
  call Hloop_AZ_Q(ntryL,G1H24(98),ex3(:),G1H8(1),ngZu,m3h3x8(:,44),heltab2x24(:,:,101))
  call Hloop_A_Q(ntryL,G1H8(1),38,nMT,G2H8(72),n2h8(60))
  call Hloop_AZ_Q(ntryL,G1H24(99),ex3(:),G1H8(1),ngZu,m3h3x8(:,45),heltab2x24(:,:,102))
  call Hloop_A_Q(ntryL,G1H8(1),38,nMT,G2H8(73),n2h8(61))
call HGT_raise_alpha_OLR(G1H24(100),1,1,24)
call HGT_raise_alpha_invQ_OLR(G1H24(100),2,5,24)
  call Hloop_UV_W(ntryL,G1H24(100),-8,ex4(:),8,G2H12(56),m3h2x12(:,58),heltab2x24(:,:,103))
call signflip_OLR(G2H12(56))
  call Hloop_AZ_Q(ntryL,G1H24(102),ex3(:),G1H8(1),ngZu,m3h3x8(:,46),heltab2x24(:,:,104))
  call Hloop_A_Q(ntryL,G1H8(1),38,nMT,G2H8(74),n2h8(62))
  call Hloop_AZ_Q(ntryL,G1H24(103),ex3(:),G1H8(1),ngZu,m3h3x8(:,47),heltab2x24(:,:,105))
  call Hloop_A_Q(ntryL,G1H8(1),38,nMT,G2H8(75),n2h8(63))
  call Hloop_AZ_Q(ntryL,G1H24(104),ex3(:),G1H8(1),ngZu,m3h3x8(:,48),heltab2x24(:,:,106))
  call Hloop_A_Q(ntryL,G1H8(1),38,nMT,G2H8(76),n2h8(64))
  call Hloop_QV_A(ntryL,G1H24(17),ex4(:),G1H12(3),m3h2x12(:,59),heltab2x24(:,:,107))
  call Hloop_Q_A(ntryL,G1H12(3),41,nMT,G2H12(57),n2h12(29))
call HGT_raise_alpha_OLR(G1H24(18),1,1,24)
call HGT_raise_alpha_invQ_OLR(G1H24(18),2,5,24)
  call Hloop_UV_W(ntryL,G1H24(18),-16,ex5(:),16,G2H12(58),m3h2x12(:,60),heltab2x24(:,:,108))
call signflip_OLR(G2H12(58))
  call Hloop_QV_A(ntryL,G1H24(105),ex4(:),G1H12(3),m3h2x12(:,61),heltab2x24(:,:,109))
  call Hloop_Q_A(ntryL,G1H12(3),41,nMT,G2H12(59),n2h12(30))
  call Hloop_QV_A(ntryL,G1H24(106),ex4(:),G1H12(3),m3h2x12(:,62),heltab2x24(:,:,110))
  call Hloop_Q_A(ntryL,G1H12(3),41,nMT,G2H12(60),n2h12(31))
  call Hloop_QV_A(ntryL,G1H24(107),ex4(:),G1H12(3),m3h2x12(:,63),heltab2x24(:,:,111))
  call Hloop_Q_A(ntryL,G1H12(3),41,nMT,G2H12(61),n2h12(32))
  call Hloop_QV_A(ntryL,G1H24(20),ex4(:),G1H12(3),m3h2x12(:,64),heltab2x24(:,:,112))
  call Hloop_Q_A(ntryL,G1H12(3),41,nMT,G2H12(62),n2h12(33))
call HGT_raise_alpha_OLR(G1H24(108),1,1,24)
call HGT_raise_alpha_invQ_OLR(G1H24(108),2,5,24)
  call Hloop_VA_Q(ntryL,G1H24(108),ex2(:),G1H12(3),m3h2x12(:,65),heltab2x24(:,:,113))
  call Hloop_QV_A(ntryL,G1H24(110),ex4(:),G1H12(4),m3h2x12(:,66),heltab2x24(:,:,114))
  call Hloop_Q_A(ntryL,G1H12(4),41,nMT,G2H12(63),n2h12(34))
  call Hloop_QV_A(ntryL,G1H24(111),ex4(:),G1H12(4),m3h2x12(:,67),heltab2x24(:,:,115))
  call Hloop_Q_A(ntryL,G1H12(4),41,nMT,G2H12(64),n2h12(35))
  call Hloop_QV_A(ntryL,G1H24(112),ex4(:),G1H12(4),m3h2x12(:,68),heltab2x24(:,:,116))
  call Hloop_Q_A(ntryL,G1H12(4),41,nMT,G2H12(65),n2h12(36))
  call Hloop_QV_A(ntryL,G1H24(21),ex4(:),G1H12(4),m3h2x12(:,69),heltab2x24(:,:,117))
  call Hloop_Q_A(ntryL,G1H12(4),41,nMT,G2H12(66),n2h12(37))
call HGT_raise_alpha_OLR(G1H24(113),1,1,24)
call HGT_raise_alpha_invQ_OLR(G1H24(113),2,5,24)
  call Hloop_VA_Q(ntryL,G1H24(113),ex2(:),G1H12(4),m3h2x12(:,70),heltab2x24(:,:,118))
  call Hloop_QV_A(ntryL,G1H24(115),ex4(:),G1H12(5),m3h2x12(:,71),heltab2x24(:,:,119))
  call Hloop_Q_A(ntryL,G1H12(5),41,nMT,G2H12(67),n2h12(38))
  call Hloop_QV_A(ntryL,G1H24(116),ex4(:),G1H12(5),m3h2x12(:,72),heltab2x24(:,:,120))
  call Hloop_Q_A(ntryL,G1H12(5),41,nMT,G2H12(68),n2h12(39))
  call Hloop_QV_A(ntryL,G1H24(117),ex4(:),G1H12(5),m3h2x12(:,73),heltab2x24(:,:,121))
  call Hloop_Q_A(ntryL,G1H12(5),41,nMT,G2H12(69),n2h12(40))
  call Hloop_QV_A(ntryL,G1H24(118),ex5(:),G1H12(5),m3h2x12(:,74),heltab2x24(:,:,122))
  call Hloop_Q_A(ntryL,G1H12(5),49,nMT,G2H12(70),n2h12(41))
call HGT_raise_alpha_OLR(G1H24(119),1,1,24)
call HGT_raise_alpha_invQ_OLR(G1H24(119),2,5,24)
  call Hloop_UV_W(ntryL,G1H24(119),-8,ex4(:),8,G2H12(71),m3h2x12(:,75),heltab2x24(:,:,123))
call signflip_OLR(G2H12(71))
  call Hloop_QV_A(ntryL,G1H24(121),ex5(:),G1H12(5),m3h2x12(:,76),heltab2x24(:,:,124))
  call Hloop_Q_A(ntryL,G1H12(5),49,nMT,G2H12(72),n2h12(42))
  call Hloop_QV_A(ntryL,G1H24(122),ex5(:),G1H12(5),m3h2x12(:,77),heltab2x24(:,:,125))
  call Hloop_Q_A(ntryL,G1H12(5),49,nMT,G2H12(73),n2h12(43))
  call Hloop_QV_A(ntryL,G1H24(123),ex5(:),G1H12(5),m3h2x12(:,78),heltab2x24(:,:,126))
  call Hloop_Q_A(ntryL,G1H12(5),49,nMT,G2H12(74),n2h12(44))
  call Hloop_QV_A(ntryL,G1H24(22),ex5(:),G1H12(5),m3h2x12(:,79),heltab2x24(:,:,127))
  call Hloop_Q_A(ntryL,G1H12(5),49,nMT,G2H12(75),n2h12(45))
call HGT_raise_alpha_OLR(G1H24(23),1,1,24)
call HGT_raise_alpha_invQ_OLR(G1H24(23),2,5,24)
  call Hloop_VA_Q(ntryL,G1H24(23),ex2(:),G1H12(5),m3h2x12(:,80),heltab2x24(:,:,128))
  call Hloop_QV_A(ntryL,G1H24(125),ex5(:),G1H12(6),m3h2x12(:,81),heltab2x24(:,:,129))
  call Hloop_Q_A(ntryL,G1H12(6),49,nMT,G2H12(76),n2h12(46))
  call Hloop_QV_A(ntryL,G1H24(126),ex5(:),G1H12(6),m3h2x12(:,82),heltab2x24(:,:,130))
  call Hloop_Q_A(ntryL,G1H12(6),49,nMT,G2H12(77),n2h12(47))
  call Hloop_QV_A(ntryL,G1H24(127),ex5(:),G1H12(6),m3h2x12(:,83),heltab2x24(:,:,131))
  call Hloop_Q_A(ntryL,G1H12(6),49,nMT,G2H12(78),n2h12(48))
  call Hloop_QV_A(ntryL,G1H24(24),ex5(:),G1H12(6),m3h2x12(:,84),heltab2x24(:,:,132))
  call Hloop_Q_A(ntryL,G1H12(6),49,nMT,G2H12(79),n2h12(49))
call HGT_raise_alpha_OLR(G1H24(128),1,1,24)
call HGT_raise_alpha_invQ_OLR(G1H24(128),2,5,24)
  call Hloop_VA_Q(ntryL,G1H24(128),ex2(:),G1H12(6),m3h2x12(:,85),heltab2x24(:,:,133))
  call Hloop_QV_A(ntryL,G1H24(130),ex5(:),G1H12(7),m3h2x12(:,86),heltab2x24(:,:,134))
  call Hloop_Q_A(ntryL,G1H12(7),49,nMT,G2H12(80),n2h12(50))
  call Hloop_QV_A(ntryL,G1H24(131),ex5(:),G1H12(7),m3h2x12(:,87),heltab2x24(:,:,135))
  call Hloop_Q_A(ntryL,G1H12(7),49,nMT,G2H12(81),n2h12(51))
  call Hloop_QV_A(ntryL,G1H24(132),ex5(:),G1H12(7),m3h2x12(:,88),heltab2x24(:,:,136))
  call Hloop_Q_A(ntryL,G1H12(7),49,nMT,G2H12(82),n2h12(52))
  call Hotf_5pt_reduction(G2H12(1),RedSet_5(21),mass5set(:,5),  & 
G1H12(7),G1H12(8),G1H12(9),G1H12(10),G1H12(11),G1H12(12),12)
  call HG1shiftOLR(G1H12(8),16,12)
  call Hotf_5pt_reduction(G2H8(1),RedSet_5(22),mass5set(:,5),  & 
G1H8(1),G1H8(2),G1H8(3),G1H8(4),G1H8(5),G1H8(6),8)
  call HG1shiftOLR(G1H8(2),16,8)
  call Hotf_5pt_reduction(G2H8(2),RedSet_5(22),mass5set(:,5),  & 
G1H8(7),G1H8(8),G1H8(9),G1H8(10),G1H8(11),G1H8(12),8)
  call HG1shiftOLR(G1H8(8),8,8)
  call Hotf_5pt_reduction(G2H12(2),RedSet_5(23),mass5set(:,6),  & 
G1H12(13),G1H12(14),G1H12(15),G1H12(16),G1H12(17),G1H12(18),12)
  call HG1shiftOLR(G1H12(14),16,12)
  call Hotf_5pt_reduction(G2H12(3),RedSet_5(23),mass5set(:,6),  & 
G1H12(19),G1H12(20),G1H12(21),G1H12(22),G1H12(23),G1H12(24),12)
  call HG1shiftOLR(G1H12(20),8,12)
  call Hotf_5pt_reduction(G2H12(4),RedSet_5(24),mass5set(:,5),  & 
G1H12(25),G1H12(26),G1H12(27),G1H12(28),G1H12(29),G1H12(30),12)
  call HG1shiftOLR(G1H12(26),16,12)
  call Hotf_5pt_reduction(G2H8(3),RedSet_5(25),mass5set(:,5),  & 
G1H8(13),G1H8(14),G1H8(15),G1H8(16),G1H8(17),G1H8(18),8)
  call HG1shiftOLR(G1H8(14),16,8)
  call Hotf_5pt_reduction(G2H12(5),RedSet_5(26),mass5set(:,6),  & 
G1H12(31),G1H12(32),G1H12(33),G1H12(34),G1H12(35),G1H12(36),12)
  call HG1shiftOLR(G1H12(32),16,12)
  call Hotf_5pt_reduction(G2H12(6),RedSet_5(26),mass5set(:,6),  & 
G1H12(37),G1H12(38),G1H12(39),G1H12(40),G1H12(41),G1H12(42),12)
  call HG1shiftOLR(G1H12(38),4,12)
  call Hotf_5pt_reduction(G2H8(4),RedSet_5(25),mass5set(:,5),  & 
G1H8(19),G1H8(20),G1H8(21),G1H8(22),G1H8(23),G1H8(24),8)
  call HG1shiftOLR(G1H8(20),8,8)
  call Hotf_5pt_reduction(G2H12(7),RedSet_5(27),mass5set(:,6),  & 
G1H12(43),G1H12(44),G1H12(45),G1H12(46),G1H12(47),G1H12(48),12)
  call HG1shiftOLR(G1H12(44),8,12)
  call Hotf_5pt_reduction(G2H12(8),RedSet_5(27),mass5set(:,6),  & 
G1H12(49),G1H12(50),G1H12(51),G1H12(52),G1H12(53),G1H12(54),12)
  call HG1shiftOLR(G1H12(50),4,12)
  call Hotf_5pt_reduction(G2H12(9),RedSet_5(28),mass5set(:,6),  & 
G1H12(55),G1H12(56),G1H12(57),G1H12(58),G1H12(59),G1H12(60),12)
  call HG1shiftOLR(G1H12(56),16,12)
  call Hotf_5pt_reduction(G2H12(10),RedSet_5(28),mass5set(:,6),  & 
G1H12(61),G1H12(62),G1H12(63),G1H12(64),G1H12(65),G1H12(66),12)
  call HG1shiftOLR(G1H12(62),8,12)
  call Hotf_5pt_reduction(G2H12(11),RedSet_5(29),mass5set(:,6),  & 
G1H12(67),G1H12(68),G1H12(69),G1H12(70),G1H12(71),G1H12(72),12)
  call HG1shiftOLR(G1H12(68),16,12)
  call Hotf_5pt_reduction(G2H12(12),RedSet_5(29),mass5set(:,6),  & 
G1H12(73),G1H12(74),G1H12(75),G1H12(76),G1H12(77),G1H12(78),12)
  call HG1shiftOLR(G1H12(74),4,12)
  call Hotf_5pt_reduction(G2H12(13),RedSet_5(30),mass5set(:,6),  & 
G1H12(79),G1H12(80),G1H12(81),G1H12(82),G1H12(83),G1H12(84),12)
  call HG1shiftOLR(G1H12(80),8,12)
  call Hotf_5pt_reduction(G2H12(14),RedSet_5(30),mass5set(:,6),  & 
G1H12(85),G1H12(86),G1H12(87),G1H12(88),G1H12(89),G1H12(90),12)
  call HG1shiftOLR(G1H12(86),4,12)
  call Hotf_5pt_reduction(G2H8(5),RedSet_5(31),mass5set(:,7),  & 
G1H8(25),G1H8(26),G1H8(27),G1H8(28),G1H8(29),G1H8(30),8)
  call HG1shiftOLR(G1H8(26),16,8)
  call Hotf_5pt_reduction(G2H12(15),RedSet_5(32),mass5set(:,8),  & 
G1H12(91),G1H12(92),G1H12(93),G1H12(94),G1H12(95),G1H12(96),12)
  call HG1shiftOLR(G1H12(92),16,12)
  call Hotf_5pt_reduction(G2H12(16),RedSet_5(33),mass5set(:,9),  & 
G1H12(97),G1H12(98),G1H12(99),G1H12(100),G1H12(101),G1H12(102),12)
  call HG1shiftOLR(G1H12(98),4,12)
  call Hotf_5pt_reduction(G2H8(6),RedSet_5(34),mass5set(:,7),  & 
G1H8(31),G1H8(32),G1H8(33),G1H8(34),G1H8(35),G1H8(36),8)
  call HG1shiftOLR(G1H8(32),8,8)
  call Hotf_5pt_reduction(G2H12(17),RedSet_5(35),mass5set(:,9),  & 
G1H12(103),G1H12(104),G1H12(105),G1H12(106),G1H12(107),G1H12(108),12)
  call HG1shiftOLR(G1H12(104),4,12)
  call Hotf_5pt_reduction(G2H12(18),RedSet_5(36),mass5set(:,8),  & 
G1H12(109),G1H12(110),G1H12(111),G1H12(112),G1H12(113),G1H12(114),12)
  call HG1shiftOLR(G1H12(110),8,12)
  call Hotf_5pt_reduction(G2H8(7),RedSet_5(37),mass5set(:,7),  & 
G1H8(37),G1H8(38),G1H8(39),G1H8(40),G1H8(41),G1H8(42),8)
  call HG1shiftOLR(G1H8(38),16,8)
  call Hotf_5pt_reduction(G2H8(8),RedSet_5(38),mass5set(:,7),  & 
G1H8(43),G1H8(44),G1H8(45),G1H8(46),G1H8(47),G1H8(48),8)
  call HG1shiftOLR(G1H8(44),8,8)
  call Hotf_5pt_reduction(G2H12(19),RedSet_5(32),mass5set(:,8),  & 
G1H12(115),G1H12(116),G1H12(117),G1H12(118),G1H12(119),G1H12(120),12)
  call HG1shiftOLR(G1H12(116),4,12)
  call Hotf_5pt_reduction(G2H12(20),RedSet_5(36),mass5set(:,8),  & 
G1H12(121),G1H12(122),G1H12(123),G1H12(124),G1H12(125),G1H12(126),12)
  call HG1shiftOLR(G1H12(122),4,12)
  call Hotf_5pt_reduction(G2H12(21),RedSet_5(39),mass5set(:,8),  & 
G1H12(127),G1H12(128),G1H12(129),G1H12(130),G1H12(131),G1H12(132),12)
  call HG1shiftOLR(G1H12(128),16,12)
  call Hotf_5pt_reduction(G2H12(22),RedSet_5(18),mass5set(:,9),  & 
G1H12(133),G1H12(134),G1H12(135),G1H12(136),G1H12(137),G1H12(138),12)
  call HG1shiftOLR(G1H12(134),4,12)
  call Hotf_5pt_reduction(G2H12(23),RedSet_5(39),mass5set(:,8),  & 
G1H12(139),G1H12(140),G1H12(141),G1H12(142),G1H12(143),G1H12(144),12)
  call HG1shiftOLR(G1H12(140),4,12)
  call Hotf_5pt_reduction(G2H12(24),RedSet_5(20),mass5set(:,9),  & 
G1H12(145),G1H12(146),G1H12(147),G1H12(148),G1H12(149),G1H12(150),12)
  call HG1shiftOLR(G1H12(146),4,12)
  call Hotf_5pt_reduction(G2H12(25),RedSet_5(40),mass5set(:,8),  & 
G1H12(151),G1H12(152),G1H12(153),G1H12(154),G1H12(155),G1H12(156),12)
  call HG1shiftOLR(G1H12(152),8,12)
  call Hotf_5pt_reduction(G2H12(26),RedSet_5(40),mass5set(:,8),  & 
G1H12(157),G1H12(158),G1H12(159),G1H12(160),G1H12(161),G1H12(162),12)
  call HG1shiftOLR(G1H12(158),4,12)
  call Hloop_AQ_V(ntryL,G2H8(9),ex1(:),G2H4(1),m3h2x4(:,1),heltab2x8(:,:,1))
  call Hloop_AQ_V(ntryL,G2H8(11),ex1(:),G2H4(2),m3h2x4(:,2),heltab2x8(:,:,2))
  call Hloop_AQ_V(ntryL,G2H8(12),ex1(:),G2H4(3),m3h2x4(:,3),heltab2x8(:,:,3))
  call Hloop_AQ_V(ntryL,G2H8(13),ex1(:),G2H4(4),m3h2x4(:,4),heltab2x8(:,:,4))
  call Hloop_AQ_V(ntryL,G2H8(16),ex1(:),G2H4(5),m3h2x4(:,5),heltab2x8(:,:,5))
  call Hloop_AQ_V(ntryL,G2H8(17),ex1(:),G2H4(6),m3h2x4(:,6),heltab2x8(:,:,6))
  call Hloop_QA_V(ntryL,G2H8(18),ex2(:),G2H4(7),m3h2x4(:,7),heltab2x8(:,:,7))
  call Hloop_QA_V(ntryL,G2H8(21),ex2(:),G2H4(8),m3h2x4(:,8),heltab2x8(:,:,8))
  call Hloop_QA_V(ntryL,G2H8(22),ex2(:),G2H4(9),m3h2x4(:,9),heltab2x8(:,:,9))
  call Hloop_QA_V(ntryL,G2H8(23),ex2(:),G2H4(10),m3h2x4(:,10),heltab2x8(:,:,10))
  call Hloop_QA_V(ntryL,G2H8(25),ex2(:),G2H4(11),m3h2x4(:,11),heltab2x8(:,:,11))
  call Hloop_QA_V(ntryL,G2H8(26),ex2(:),G2H4(12),m3h2x4(:,12),heltab2x8(:,:,12))
  call Hloop_QA_V(ntryL,G2H8(27),ex2(:),G2H4(13),m3h2x4(:,13),heltab2x8(:,:,13))
  call Hloop_QA_V(ntryL,G2H8(30),ex2(:),G2H4(14),m3h2x4(:,14),heltab2x8(:,:,14))
  call Hloop_QA_V(ntryL,G2H8(31),ex2(:),G2H4(15),m3h2x4(:,15),heltab2x8(:,:,15))
  call Hloop_AQ_V(ntryL,G2H8(32),ex1(:),G2H4(16),m3h2x4(:,16),heltab2x8(:,:,16))
  call Hloop_AQ_V(ntryL,G2H8(35),ex1(:),G2H4(17),m3h2x4(:,17),heltab2x8(:,:,17))
  call Hloop_AQ_V(ntryL,G2H8(36),ex1(:),G2H4(18),m3h2x4(:,18),heltab2x8(:,:,18))
  call Hotf_5pt_reduction(G2H12(29),RedSet_5(7),mass5set(:,2),  & 
G1H12(163),G1H12(164),G1H12(165),G1H12(166),G1H12(167),G1H12(168),12)
  call HG1shiftOLR(G1H12(164),16,12)
  call Hotf_5pt_reduction(G2H12(32),RedSet_5(41),mass5set(:,10),  & 
G1H12(169),G1H12(170),G1H12(171),G1H12(172),G1H12(173),G1H12(174),12)
  call HG1shiftOLR(G1H12(170),16,12)
  call Hotf_5pt_reduction(G2H12(33),RedSet_5(42),mass5set(:,10),  & 
G1H12(175),G1H12(176),G1H12(177),G1H12(178),G1H12(179),G1H12(180),12)
  call HG1shiftOLR(G1H12(176),16,12)
  call Hloop_AQ_V(ntryL,G2H8(37),ex1(:),G2H4(19),m3h2x4(:,19),heltab2x8(:,:,19))
  call Hloop_AQ_V(ntryL,G2H8(39),ex1(:),G2H4(20),m3h2x4(:,20),heltab2x8(:,:,20))
  call Hloop_AQ_V(ntryL,G2H8(40),ex1(:),G2H4(21),m3h2x4(:,21),heltab2x8(:,:,21))
  call Hotf_5pt_reduction(G2H12(35),RedSet_5(9),mass5set(:,4),  & 
G1H12(181),G1H12(182),G1H12(183),G1H12(184),G1H12(185),G1H12(186),12)
  call HG1shiftOLR(G1H12(182),8,12)
  call Hotf_5pt_reduction(G2H12(38),RedSet_5(43),mass5set(:,3),  & 
G1H12(187),G1H12(188),G1H12(189),G1H12(190),G1H12(191),G1H12(192),12)
  call HG1shiftOLR(G1H12(188),8,12)
  call Hotf_5pt_reduction(G2H12(39),RedSet_5(44),mass5set(:,3),  & 
G1H12(193),G1H12(194),G1H12(195),G1H12(196),G1H12(197),G1H12(198),12)
  call HG1shiftOLR(G1H12(194),8,12)
  call Hotf_5pt_reduction(G2H12(40),RedSet_5(10),mass5set(:,2),  & 
G1H12(199),G1H12(200),G1H12(201),G1H12(202),G1H12(203),G1H12(204),12)
  call HG1shiftOLR(G1H12(200),16,12)
  call Hotf_5pt_reduction(G2H12(43),RedSet_5(45),mass5set(:,10),  & 
G1H12(205),G1H12(206),G1H12(207),G1H12(208),G1H12(209),G1H12(210),12)
  call HG1shiftOLR(G1H12(206),16,12)
  call Hotf_5pt_reduction(G2H12(44),RedSet_5(46),mass5set(:,10),  & 
G1H12(211),G1H12(212),G1H12(213),G1H12(214),G1H12(215),G1H12(216),12)
  call HG1shiftOLR(G1H12(212),16,12)
  call Hloop_AQ_V(ntryL,G2H8(41),ex1(:),G2H4(22),m3h2x4(:,22),heltab2x8(:,:,22))
  call Hloop_AQ_V(ntryL,G2H8(43),ex1(:),G2H4(23),m3h2x4(:,23),heltab2x8(:,:,23))
  call Hloop_AQ_V(ntryL,G2H8(44),ex1(:),G2H4(24),m3h2x4(:,24),heltab2x8(:,:,24))
  call Hotf_5pt_reduction(G2H12(46),RedSet_5(11),mass5set(:,4),  & 
G1H12(217),G1H12(218),G1H12(219),G1H12(220),G1H12(221),G1H12(222),12)
  call HG1shiftOLR(G1H12(218),16,12)
  call Hotf_5pt_reduction(G2H12(49),RedSet_5(47),mass5set(:,3),  & 
G1H12(223),G1H12(224),G1H12(225),G1H12(226),G1H12(227),G1H12(228),12)
  call HG1shiftOLR(G1H12(224),16,12)
  call Hotf_5pt_reduction(G2H12(50),RedSet_5(48),mass5set(:,3),  & 
G1H12(229),G1H12(230),G1H12(231),G1H12(232),G1H12(233),G1H12(234),12)
  call HG1shiftOLR(G1H12(230),16,12)
  call Hloop_QA_V(ntryL,G2H8(45),ex2(:),G2H4(25),m3h2x4(:,25),heltab2x8(:,:,25))
  call Hloop_QA_V(ntryL,G2H8(47),ex2(:),G2H4(26),m3h2x4(:,26),heltab2x8(:,:,26))
  call Hloop_QA_V(ntryL,G2H8(48),ex2(:),G2H4(27),m3h2x4(:,27),heltab2x8(:,:,27))
  call Hloop_QA_V(ntryL,G2H8(49),ex2(:),G2H4(28),m3h2x4(:,28),heltab2x8(:,:,28))
  call Hloop_QA_V(ntryL,G2H8(51),ex2(:),G2H4(29),m3h2x4(:,29),heltab2x8(:,:,29))
  call Hloop_QA_V(ntryL,G2H8(52),ex2(:),G2H4(30),m3h2x4(:,30),heltab2x8(:,:,30))
  call Hotf_5pt_reduction(G2H8(53),RedSet_5(13),mass5set(:,4),  & 
G1H8(49),G1H8(50),G1H8(51),G1H8(52),G1H8(53),G1H8(54),8)
  call HG1shiftOLR(G1H8(50),16,8)
  call Hotf_5pt_reduction(G2H8(55),RedSet_5(49),mass5set(:,3),  & 
G1H8(55),G1H8(56),G1H8(57),G1H8(58),G1H8(59),G1H8(60),8)
  call HG1shiftOLR(G1H8(56),16,8)
  call Hotf_5pt_reduction(G2H8(56),RedSet_5(50),mass5set(:,3),  & 
G1H8(61),G1H8(62),G1H8(63),G1H8(64),G1H8(65),G1H8(66),8)
  call HG1shiftOLR(G1H8(62),16,8)
  call Hotf_5pt_reduction(G2H8(57),RedSet_5(14),mass5set(:,4),  & 
G1H8(67),G1H8(68),G1H8(69),G1H8(70),G1H8(71),G1H8(72),8)
  call HG1shiftOLR(G1H8(68),8,8)
  call Hotf_5pt_reduction(G2H8(59),RedSet_5(51),mass5set(:,3),  & 
G1H8(73),G1H8(74),G1H8(75),G1H8(76),G1H8(77),G1H8(78),8)
  call HG1shiftOLR(G1H8(74),8,8)
  call Hotf_5pt_reduction(G2H8(60),RedSet_5(52),mass5set(:,3),  & 
G1H8(79),G1H8(80),G1H8(81),G1H8(82),G1H8(83),G1H8(84),8)
  call HG1shiftOLR(G1H8(80),8,8)
  call Hotf_5pt_reduction(G2H8(61),RedSet_5(14),mass5set(:,4),  & 
G1H8(85),G1H8(86),G1H8(87),G1H8(88),G1H8(89),G1H8(90),8)
  call HG1shiftOLR(G1H8(86),2,8)
  call Hotf_5pt_reduction(G2H8(63),RedSet_5(53),mass5set(:,4),  & 
G1H8(91),G1H8(92),G1H8(93),G1H8(94),G1H8(95),G1H8(96),8)
  call HG1shiftOLR(G1H8(92),2,8)
  call Hotf_5pt_reduction(G2H8(64),RedSet_5(54),mass5set(:,4),  & 
G1H8(97),G1H8(98),G1H8(99),G1H8(100),G1H8(101),G1H8(102),8)
  call HG1shiftOLR(G1H8(98),2,8)
  call Hotf_5pt_reduction(G2H8(65),RedSet_5(13),mass5set(:,4),  & 
G1H8(103),G1H8(104),G1H8(105),G1H8(106),G1H8(107),G1H8(108),8)
  call HG1shiftOLR(G1H8(104),2,8)
  call Hotf_5pt_reduction(G2H8(67),RedSet_5(55),mass5set(:,4),  & 
G1H8(109),G1H8(110),G1H8(111),G1H8(112),G1H8(113),G1H8(114),8)
  call HG1shiftOLR(G1H8(110),2,8)
  call Hotf_5pt_reduction(G2H8(68),RedSet_5(54),mass5set(:,4),  & 
G1H8(115),G1H8(116),G1H8(117),G1H8(118),G1H8(119),G1H8(120),8)
  call HG1shiftOLR(G1H8(116),2,8)
  call Hotf_5pt_reduction(G2H8(69),RedSet_5(15),mass5set(:,4),  & 
G1H8(121),G1H8(122),G1H8(123),G1H8(124),G1H8(125),G1H8(126),8)
  call HG1shiftOLR(G1H8(122),16,8)
  call Hotf_5pt_reduction(G2H8(71),RedSet_5(47),mass5set(:,3),  & 
G1H8(127),G1H8(128),G1H8(129),G1H8(130),G1H8(131),G1H8(132),8)
  call HG1shiftOLR(G1H8(128),16,8)
  call Hotf_5pt_reduction(G2H8(72),RedSet_5(56),mass5set(:,3),  & 
G1H8(133),G1H8(134),G1H8(135),G1H8(136),G1H8(137),G1H8(138),8)
  call HG1shiftOLR(G1H8(134),16,8)
  call Hotf_5pt_reduction(G2H8(73),RedSet_5(16),mass5set(:,4),  & 
G1H8(139),G1H8(140),G1H8(141),G1H8(142),G1H8(143),G1H8(144),8)
  call HG1shiftOLR(G1H8(140),8,8)
  call Hotf_5pt_reduction(G2H8(75),RedSet_5(43),mass5set(:,3),  & 
G1H8(145),G1H8(146),G1H8(147),G1H8(148),G1H8(149),G1H8(150),8)
  call HG1shiftOLR(G1H8(146),8,8)
  call Hotf_5pt_reduction(G2H8(76),RedSet_5(57),mass5set(:,3),  & 
G1H8(151),G1H8(152),G1H8(153),G1H8(154),G1H8(155),G1H8(156),8)
  call HG1shiftOLR(G1H8(152),8,8)
  call Hotf_5pt_reduction(G2H12(57),RedSet_5(17),mass5set(:,4),  & 
G1H12(235),G1H12(236),G1H12(237),G1H12(238),G1H12(239),G1H12(240),12)
  call HG1shiftOLR(G1H12(236),16,12)
  call Hotf_5pt_reduction(G2H12(60),RedSet_5(49),mass5set(:,3),  & 
G1H12(241),G1H12(242),G1H12(243),G1H12(244),G1H12(245),G1H12(246),12)
  call HG1shiftOLR(G1H12(242),16,12)
  call Hotf_5pt_reduction(G2H12(61),RedSet_5(58),mass5set(:,3),  & 
G1H12(247),G1H12(248),G1H12(249),G1H12(250),G1H12(251),G1H12(252),12)
  call HG1shiftOLR(G1H12(248),16,12)
  call Hotf_5pt_reduction(G2H12(62),RedSet_5(18),mass5set(:,4),  & 
G1H12(253),G1H12(254),G1H12(255),G1H12(256),G1H12(257),G1H12(258),12)
  call HG1shiftOLR(G1H12(254),2,12)
  call Hotf_5pt_reduction(G2H12(64),RedSet_5(59),mass5set(:,4),  & 
G1H12(259),G1H12(260),G1H12(261),G1H12(262),G1H12(263),G1H12(264),12)
  call HG1shiftOLR(G1H12(260),2,12)
  call Hotf_5pt_reduction(G2H12(65),RedSet_5(60),mass5set(:,4),  & 
G1H12(265),G1H12(266),G1H12(267),G1H12(268),G1H12(269),G1H12(270),12)
  call HG1shiftOLR(G1H12(266),2,12)
  call Hotf_5pt_reduction(G2H12(66),RedSet_5(17),mass5set(:,4),  & 
G1H12(271),G1H12(272),G1H12(273),G1H12(274),G1H12(275),G1H12(276),12)
  call HG1shiftOLR(G1H12(272),2,12)
  call Hotf_5pt_reduction(G2H12(68),RedSet_5(55),mass5set(:,4),  & 
G1H12(277),G1H12(278),G1H12(279),G1H12(280),G1H12(281),G1H12(282),12)
  call HG1shiftOLR(G1H12(278),2,12)
  call Hotf_5pt_reduction(G2H12(69),RedSet_5(60),mass5set(:,4),  & 
G1H12(283),G1H12(284),G1H12(285),G1H12(286),G1H12(287),G1H12(288),12)
  call HG1shiftOLR(G1H12(284),2,12)
  call Hotf_5pt_reduction(G2H12(70),RedSet_5(19),mass5set(:,4),  & 
G1H12(289),G1H12(290),G1H12(291),G1H12(292),G1H12(293),G1H12(294),12)
  call HG1shiftOLR(G1H12(290),8,12)
  call Hotf_5pt_reduction(G2H12(73),RedSet_5(51),mass5set(:,3),  & 
G1H12(295),G1H12(296),G1H12(297),G1H12(298),G1H12(299),G1H12(300),12)
  call HG1shiftOLR(G1H12(296),8,12)
  call Hotf_5pt_reduction(G2H12(74),RedSet_5(61),mass5set(:,3),  & 
G1H12(301),G1H12(302),G1H12(303),G1H12(304),G1H12(305),G1H12(306),12)
  call HG1shiftOLR(G1H12(302),8,12)
  call Hotf_5pt_reduction(G2H12(75),RedSet_5(20),mass5set(:,4),  & 
G1H12(307),G1H12(308),G1H12(309),G1H12(310),G1H12(311),G1H12(312),12)
  call HG1shiftOLR(G1H12(308),2,12)
  call Hotf_5pt_reduction(G2H12(77),RedSet_5(59),mass5set(:,4),  & 
G1H12(313),G1H12(314),G1H12(315),G1H12(316),G1H12(317),G1H12(318),12)
  call HG1shiftOLR(G1H12(314),2,12)
  call Hotf_5pt_reduction(G2H12(78),RedSet_5(62),mass5set(:,4),  & 
G1H12(319),G1H12(320),G1H12(321),G1H12(322),G1H12(323),G1H12(324),12)
  call HG1shiftOLR(G1H12(320),2,12)
  call Hotf_5pt_reduction(G2H12(79),RedSet_5(19),mass5set(:,4),  & 
G1H12(325),G1H12(326),G1H12(327),G1H12(328),G1H12(329),G1H12(330),12)
  call HG1shiftOLR(G1H12(326),2,12)
  call Hotf_5pt_reduction(G2H12(81),RedSet_5(53),mass5set(:,4),  & 
G1H12(331),G1H12(332),G1H12(333),G1H12(334),G1H12(335),G1H12(336),12)
  call HG1shiftOLR(G1H12(332),2,12)
  call Hotf_5pt_reduction(G2H12(82),RedSet_5(62),mass5set(:,4),  & 
G1H12(337),G1H12(338),G1H12(339),G1H12(340),G1H12(341),G1H12(342),12)
  call HG1shiftOLR(G1H12(338),2,12)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(169),[G1H12(167)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(175),[G1H12(168)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(187),[G1H12(185)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(193),[G1H12(186)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(205),[G1H12(203)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(211),[G1H12(204)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(223),[G1H12(221)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(229),[G1H12(222)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(55),[G1H8(53)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(61),[G1H8(54)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(73),[G1H8(71)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(79),[G1H8(72)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(91),[G1H8(89)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(97),[G1H8(90)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(109),[G1H8(107)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(115),[G1H8(108)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(127),[G1H8(125)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(133),[G1H8(126)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(145),[G1H8(143)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(151),[G1H8(144)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(241),[G1H12(239)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(247),[G1H12(240)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(259),[G1H12(257)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(265),[G1H12(258)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(277),[G1H12(275)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(283),[G1H12(276)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(295),[G1H12(293)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(301),[G1H12(294)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(313),[G1H12(311)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(319),[G1H12(312)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(331),[G1H12(329)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(337),[G1H12(330)])
  call Hloop_VQ_A(ntryL,G1H12(7),ex1(:),G1H6(1),m3h2x6(:,1),heltab2x12(:,:,1))
  call Hloop_Q_A(ntryL,G1H6(1),43,nMT,G2H6(1),n2h6(1))
call HGT_OLR(G1H12(8),1,1,12)
call HGT_invQ_OLR(G1H12(8),2,5,12)
  call Hloop_A_Q(ntryL,G1H12(8),-16,nMT,G2H12(1),n2h12(53))
  call Hloop_AV_Q(ntryL,G2H12(1),ex5(:),G2H6(2),m3h2x6(:,2),heltab2x12(:,:,2))
  call Hloop_VQ_A(ntryL,G1H12(11),ex1(:),G1H6(1),m3h2x6(:,3),heltab2x12(:,:,3))
  call Hloop_Q_A(ntryL,G1H6(1),43,nMT,G2H6(3),n2h6(2))
  call Hloop_VQ_A(ntryL,G1H12(12),ex1(:),G1H6(1),m3h2x6(:,4),heltab2x12(:,:,4))
  call Hloop_Q_A(ntryL,G1H6(1),43,nMT,G2H6(4),n2h6(3))
  call Hloop_VA_Q(ntryL,G1H8(1),ex2(:),G1H4(1),m3h2x4(:,31),heltab2x8(:,:,31))
  call Hloop_A_Q(ntryL,G1H4(1),39,nMT,G2H4(31),n2h4(1))
call HGT_OLR(G1H8(2),1,1,8)
call HGT_invQ_OLR(G1H8(2),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(2),-16,nMT,G2H8(1),n2h8(65))
  call Hloop_QV_A(ntryL,G2H8(1),ex5(:),G2H4(32),m3h2x4(:,32),heltab2x8(:,:,32))
  call Hloop_VA_Q(ntryL,G1H8(5),ex2(:),G1H4(1),m3h2x4(:,33),heltab2x8(:,:,33))
  call Hloop_A_Q(ntryL,G1H4(1),39,nMT,G2H4(33),n2h4(2))
  call Hloop_VA_Q(ntryL,G1H8(6),ex2(:),G1H4(1),m3h2x4(:,34),heltab2x8(:,:,34))
  call Hloop_A_Q(ntryL,G1H4(1),39,nMT,G2H4(34),n2h4(3))
  call Hloop_VA_Q(ntryL,G1H8(7),ex2(:),G1H4(1),m3h2x4(:,35),heltab2x8(:,:,35))
  call Hloop_A_Q(ntryL,G1H4(1),39,nMT,G2H4(35),n2h4(4))
call HGT_OLR(G1H8(8),1,1,8)
call HGT_invQ_OLR(G1H8(8),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(8),-8,nMT,G2H8(2),n2h8(66))
  call Hloop_QV_A(ntryL,G2H8(2),ex4(:),G2H4(36),m3h2x4(:,36),heltab2x8(:,:,36))
  call Hloop_VA_Q(ntryL,G1H8(11),ex2(:),G1H4(1),m3h2x4(:,37),heltab2x8(:,:,37))
  call Hloop_A_Q(ntryL,G1H4(1),39,nMT,G2H4(37),n2h4(5))
  call Hloop_VA_Q(ntryL,G1H8(12),ex2(:),G1H4(1),m3h2x4(:,38),heltab2x8(:,:,38))
  call Hloop_A_Q(ntryL,G1H4(1),39,nMT,G2H4(38),n2h4(6))
  call Hloop_QZ_A(ntryL,G1H12(13),ex3(:),G1H4(1),ngZu,m3h3x4(:,1),heltab2x12(:,:,5))
  call Hloop_Q_A(ntryL,G1H4(1),39,nMT,G2H4(39),n2h4(7))
call HGT_OLR(G1H12(14),1,1,12)
call HGT_invQ_OLR(G1H12(14),2,5,12)
  call Hloop_A_Q(ntryL,G1H12(14),-16,nMT,G2H12(2),n2h12(54))
  call Hloop_AV_Q(ntryL,G2H12(2),ex5(:),G2H6(5),m3h2x6(:,5),heltab2x12(:,:,6))
  call Hloop_QZ_A(ntryL,G1H12(17),ex3(:),G1H4(1),ngZu,m3h3x4(:,2),heltab2x12(:,:,7))
  call Hloop_Q_A(ntryL,G1H4(1),39,nMT,G2H4(40),n2h4(8))
  call Hloop_QZ_A(ntryL,G1H12(18),ex3(:),G1H4(1),ngZu,m3h3x4(:,3),heltab2x12(:,:,8))
  call Hloop_Q_A(ntryL,G1H4(1),39,nMT,G2H4(41),n2h4(9))
  call Hloop_QZ_A(ntryL,G1H12(19),ex3(:),G1H4(1),ngZu,m3h3x4(:,4),heltab2x12(:,:,9))
  call Hloop_Q_A(ntryL,G1H4(1),39,nMT,G2H4(42),n2h4(10))
call HGT_OLR(G1H12(20),1,1,12)
call HGT_invQ_OLR(G1H12(20),2,5,12)
  call Hloop_A_Q(ntryL,G1H12(20),-8,nMT,G2H12(3),n2h12(55))
  call Hloop_AV_Q(ntryL,G2H12(3),ex4(:),G2H6(6),m3h2x6(:,6),heltab2x12(:,:,10))
  call Hloop_QZ_A(ntryL,G1H12(23),ex3(:),G1H4(1),ngZu,m3h3x4(:,5),heltab2x12(:,:,11))
  call Hloop_Q_A(ntryL,G1H4(1),39,nMT,G2H4(43),n2h4(11))
  call Hloop_QZ_A(ntryL,G1H12(24),ex3(:),G1H4(1),ngZu,m3h3x4(:,6),heltab2x12(:,:,12))
  call Hloop_Q_A(ntryL,G1H4(1),39,nMT,G2H4(44),n2h4(12))
  call Hloop_VA_Q(ntryL,G1H12(25),ex2(:),G1H6(1),m3h2x6(:,7),heltab2x12(:,:,13))
  call Hloop_A_Q(ntryL,G1H6(1),43,nMT,G2H6(7),n2h6(4))
call HGT_OLR(G1H12(26),1,1,12)
call HGT_invQ_OLR(G1H12(26),2,5,12)
  call Hloop_Q_A(ntryL,G1H12(26),-16,nMT,G2H12(4),n2h12(56))
  call Hloop_QV_A(ntryL,G2H12(4),ex5(:),G2H6(8),m3h2x6(:,8),heltab2x12(:,:,14))
  call Hloop_VA_Q(ntryL,G1H12(29),ex2(:),G1H6(1),m3h2x6(:,9),heltab2x12(:,:,15))
  call Hloop_A_Q(ntryL,G1H6(1),43,nMT,G2H6(9),n2h6(5))
  call Hloop_VA_Q(ntryL,G1H12(30),ex2(:),G1H6(1),m3h2x6(:,10),heltab2x12(:,:,16))
  call Hloop_A_Q(ntryL,G1H6(1),43,nMT,G2H6(10),n2h6(6))
  call Hloop_VQ_A(ntryL,G1H8(13),ex1(:),G1H4(1),m3h2x4(:,39),heltab2x8(:,:,39))
  call Hloop_Q_A(ntryL,G1H4(1),39,nMT,G2H4(45),n2h4(13))
call HGT_OLR(G1H8(14),1,1,8)
call HGT_invQ_OLR(G1H8(14),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(14),-16,nMT,G2H8(3),n2h8(67))
  call Hloop_AV_Q(ntryL,G2H8(3),ex5(:),G2H4(46),m3h2x4(:,40),heltab2x8(:,:,40))
  call Hloop_VQ_A(ntryL,G1H8(17),ex1(:),G1H4(1),m3h2x4(:,41),heltab2x8(:,:,41))
  call Hloop_Q_A(ntryL,G1H4(1),39,nMT,G2H4(47),n2h4(14))
  call Hloop_VQ_A(ntryL,G1H8(18),ex1(:),G1H4(1),m3h2x4(:,42),heltab2x8(:,:,42))
  call Hloop_Q_A(ntryL,G1H4(1),39,nMT,G2H4(48),n2h4(15))
  call Hloop_QV_A(ntryL,G1H12(31),ex4(:),G1H6(1),m3h2x6(:,11),heltab2x12(:,:,17))
  call Hloop_Q_A(ntryL,G1H6(1),43,nMT,G2H6(11),n2h6(7))
call HGT_OLR(G1H12(32),1,1,12)
call HGT_invQ_OLR(G1H12(32),2,5,12)
  call Hloop_A_Q(ntryL,G1H12(32),-16,nMT,G2H12(5),n2h12(57))
  call Hloop_AV_Q(ntryL,G2H12(5),ex5(:),G2H6(12),m3h2x6(:,12),heltab2x12(:,:,18))
  call Hloop_QV_A(ntryL,G1H12(35),ex4(:),G1H6(1),m3h2x6(:,13),heltab2x12(:,:,19))
  call Hloop_Q_A(ntryL,G1H6(1),43,nMT,G2H6(13),n2h6(8))
  call Hloop_QV_A(ntryL,G1H12(36),ex4(:),G1H6(1),m3h2x6(:,14),heltab2x12(:,:,20))
  call Hloop_Q_A(ntryL,G1H6(1),43,nMT,G2H6(14),n2h6(9))
  call Hloop_QV_A(ntryL,G1H12(37),ex4(:),G1H6(1),m3h2x6(:,15),heltab2x12(:,:,21))
  call Hloop_Q_A(ntryL,G1H6(1),43,nMT,G2H6(15),n2h6(10))
call HGT_OLR(G1H12(38),1,1,12)
call HGT_invQ_OLR(G1H12(38),2,5,12)
  call Hloop_A_Q(ntryL,G1H12(38),-4,nMT,G2H12(6),n2h12(58))
  call Hloop_AZ_Q(ntryL,G2H12(6),ex3(:),G2H4(49),ngZu,m3h3x4(:,7),heltab2x12(:,:,22))
  call Hloop_QV_A(ntryL,G1H12(41),ex4(:),G1H6(1),m3h2x6(:,16),heltab2x12(:,:,23))
  call Hloop_Q_A(ntryL,G1H6(1),43,nMT,G2H6(16),n2h6(11))
  call Hloop_QV_A(ntryL,G1H12(42),ex4(:),G1H6(1),m3h2x6(:,17),heltab2x12(:,:,24))
  call Hloop_Q_A(ntryL,G1H6(1),43,nMT,G2H6(17),n2h6(12))
  call Hloop_VQ_A(ntryL,G1H8(19),ex1(:),G1H4(1),m3h2x4(:,43),heltab2x8(:,:,43))
  call Hloop_Q_A(ntryL,G1H4(1),39,nMT,G2H4(50),n2h4(16))
call HGT_OLR(G1H8(20),1,1,8)
call HGT_invQ_OLR(G1H8(20),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(20),-8,nMT,G2H8(4),n2h8(68))
  call Hloop_AV_Q(ntryL,G2H8(4),ex4(:),G2H4(51),m3h2x4(:,44),heltab2x8(:,:,44))
  call Hloop_VQ_A(ntryL,G1H8(23),ex1(:),G1H4(1),m3h2x4(:,45),heltab2x8(:,:,45))
  call Hloop_Q_A(ntryL,G1H4(1),39,nMT,G2H4(52),n2h4(17))
  call Hloop_VQ_A(ntryL,G1H8(24),ex1(:),G1H4(1),m3h2x4(:,46),heltab2x8(:,:,46))
  call Hloop_Q_A(ntryL,G1H4(1),39,nMT,G2H4(53),n2h4(18))
  call Hloop_QV_A(ntryL,G1H12(43),ex5(:),G1H6(1),m3h2x6(:,18),heltab2x12(:,:,25))
  call Hloop_Q_A(ntryL,G1H6(1),51,nMT,G2H6(18),n2h6(13))
call HGT_OLR(G1H12(44),1,1,12)
call HGT_invQ_OLR(G1H12(44),2,5,12)
  call Hloop_A_Q(ntryL,G1H12(44),-8,nMT,G2H12(7),n2h12(59))
  call Hloop_AV_Q(ntryL,G2H12(7),ex4(:),G2H6(19),m3h2x6(:,19),heltab2x12(:,:,26))
  call Hloop_QV_A(ntryL,G1H12(47),ex5(:),G1H6(1),m3h2x6(:,20),heltab2x12(:,:,27))
  call Hloop_Q_A(ntryL,G1H6(1),51,nMT,G2H6(20),n2h6(14))
  call Hloop_QV_A(ntryL,G1H12(48),ex5(:),G1H6(1),m3h2x6(:,21),heltab2x12(:,:,28))
  call Hloop_Q_A(ntryL,G1H6(1),51,nMT,G2H6(21),n2h6(15))
  call Hloop_QV_A(ntryL,G1H12(49),ex5(:),G1H6(1),m3h2x6(:,22),heltab2x12(:,:,29))
  call Hloop_Q_A(ntryL,G1H6(1),51,nMT,G2H6(22),n2h6(16))
call HGT_OLR(G1H12(50),1,1,12)
call HGT_invQ_OLR(G1H12(50),2,5,12)
  call Hloop_A_Q(ntryL,G1H12(50),-4,nMT,G2H12(8),n2h12(60))
  call Hloop_AZ_Q(ntryL,G2H12(8),ex3(:),G2H4(54),ngZu,m3h3x4(:,8),heltab2x12(:,:,30))
  call Hloop_QV_A(ntryL,G1H12(53),ex5(:),G1H6(1),m3h2x6(:,23),heltab2x12(:,:,31))
  call Hloop_Q_A(ntryL,G1H6(1),51,nMT,G2H6(23),n2h6(17))
  call Hloop_QV_A(ntryL,G1H12(54),ex5(:),G1H6(1),m3h2x6(:,24),heltab2x12(:,:,32))
  call Hloop_Q_A(ntryL,G1H6(1),51,nMT,G2H6(24),n2h6(18))
  call Hloop_AZ_Q(ntryL,G1H12(55),ex3(:),G1H4(1),ngZu,m3h3x4(:,9),heltab2x12(:,:,33))
  call Hloop_A_Q(ntryL,G1H4(1),39,nMT,G2H4(55),n2h4(19))
call HGT_OLR(G1H12(56),1,1,12)
call HGT_invQ_OLR(G1H12(56),2,5,12)
  call Hloop_Q_A(ntryL,G1H12(56),-16,nMT,G2H12(9),n2h12(61))
  call Hloop_QV_A(ntryL,G2H12(9),ex5(:),G2H6(25),m3h2x6(:,25),heltab2x12(:,:,34))
  call Hloop_AZ_Q(ntryL,G1H12(59),ex3(:),G1H4(1),ngZu,m3h3x4(:,10),heltab2x12(:,:,35))
  call Hloop_A_Q(ntryL,G1H4(1),39,nMT,G2H4(56),n2h4(20))
  call Hloop_AZ_Q(ntryL,G1H12(60),ex3(:),G1H4(1),ngZu,m3h3x4(:,11),heltab2x12(:,:,36))
  call Hloop_A_Q(ntryL,G1H4(1),39,nMT,G2H4(57),n2h4(21))
  call Hloop_AZ_Q(ntryL,G1H12(61),ex3(:),G1H4(1),ngZu,m3h3x4(:,12),heltab2x12(:,:,37))
  call Hloop_A_Q(ntryL,G1H4(1),39,nMT,G2H4(58),n2h4(22))
call HGT_OLR(G1H12(62),1,1,12)
call HGT_invQ_OLR(G1H12(62),2,5,12)
  call Hloop_Q_A(ntryL,G1H12(62),-8,nMT,G2H12(10),n2h12(62))
  call Hloop_QV_A(ntryL,G2H12(10),ex4(:),G2H6(26),m3h2x6(:,26),heltab2x12(:,:,38))
  call Hloop_AZ_Q(ntryL,G1H12(65),ex3(:),G1H4(1),ngZu,m3h3x4(:,13),heltab2x12(:,:,39))
  call Hloop_A_Q(ntryL,G1H4(1),39,nMT,G2H4(59),n2h4(23))
  call Hloop_AZ_Q(ntryL,G1H12(66),ex3(:),G1H4(1),ngZu,m3h3x4(:,14),heltab2x12(:,:,40))
  call Hloop_A_Q(ntryL,G1H4(1),39,nMT,G2H4(60),n2h4(24))
  call Hloop_AV_Q(ntryL,G1H12(67),ex4(:),G1H6(1),m3h2x6(:,27),heltab2x12(:,:,41))
  call Hloop_A_Q(ntryL,G1H6(1),43,nMT,G2H6(27),n2h6(19))
call HGT_OLR(G1H12(68),1,1,12)
call HGT_invQ_OLR(G1H12(68),2,5,12)
  call Hloop_Q_A(ntryL,G1H12(68),-16,nMT,G2H12(11),n2h12(63))
  call Hloop_QV_A(ntryL,G2H12(11),ex5(:),G2H6(28),m3h2x6(:,28),heltab2x12(:,:,42))
  call Hloop_AV_Q(ntryL,G1H12(71),ex4(:),G1H6(1),m3h2x6(:,29),heltab2x12(:,:,43))
  call Hloop_A_Q(ntryL,G1H6(1),43,nMT,G2H6(29),n2h6(20))
  call Hloop_AV_Q(ntryL,G1H12(72),ex4(:),G1H6(1),m3h2x6(:,30),heltab2x12(:,:,44))
  call Hloop_A_Q(ntryL,G1H6(1),43,nMT,G2H6(30),n2h6(21))
  call Hloop_AV_Q(ntryL,G1H12(73),ex4(:),G1H6(1),m3h2x6(:,31),heltab2x12(:,:,45))
  call Hloop_A_Q(ntryL,G1H6(1),43,nMT,G2H6(31),n2h6(22))
call HGT_OLR(G1H12(74),1,1,12)
call HGT_invQ_OLR(G1H12(74),2,5,12)
  call Hloop_Q_A(ntryL,G1H12(74),-4,nMT,G2H12(12),n2h12(64))
  call Hloop_QZ_A(ntryL,G2H12(12),ex3(:),G2H4(61),ngZu,m3h3x4(:,15),heltab2x12(:,:,46))
  call Hloop_AV_Q(ntryL,G1H12(77),ex4(:),G1H6(1),m3h2x6(:,32),heltab2x12(:,:,47))
  call Hloop_A_Q(ntryL,G1H6(1),43,nMT,G2H6(32),n2h6(23))
  call Hloop_AV_Q(ntryL,G1H12(78),ex4(:),G1H6(1),m3h2x6(:,33),heltab2x12(:,:,48))
  call Hloop_A_Q(ntryL,G1H6(1),43,nMT,G2H6(33),n2h6(24))
  call Hloop_AV_Q(ntryL,G1H12(79),ex5(:),G1H6(1),m3h2x6(:,34),heltab2x12(:,:,49))
  call Hloop_A_Q(ntryL,G1H6(1),51,nMT,G2H6(34),n2h6(25))
call HGT_OLR(G1H12(80),1,1,12)
call HGT_invQ_OLR(G1H12(80),2,5,12)
  call Hloop_Q_A(ntryL,G1H12(80),-8,nMT,G2H12(13),n2h12(65))
  call Hloop_QV_A(ntryL,G2H12(13),ex4(:),G2H6(35),m3h2x6(:,35),heltab2x12(:,:,50))
  call Hloop_AV_Q(ntryL,G1H12(83),ex5(:),G1H6(1),m3h2x6(:,36),heltab2x12(:,:,51))
  call Hloop_A_Q(ntryL,G1H6(1),51,nMT,G2H6(36),n2h6(26))
  call Hloop_AV_Q(ntryL,G1H12(84),ex5(:),G1H6(1),m3h2x6(:,37),heltab2x12(:,:,52))
  call Hloop_A_Q(ntryL,G1H6(1),51,nMT,G2H6(37),n2h6(27))
  call Hloop_AV_Q(ntryL,G1H12(85),ex5(:),G1H6(1),m3h2x6(:,38),heltab2x12(:,:,53))
  call Hloop_A_Q(ntryL,G1H6(1),51,nMT,G2H6(38),n2h6(28))
call HGT_OLR(G1H12(86),1,1,12)
call HGT_invQ_OLR(G1H12(86),2,5,12)
  call Hloop_Q_A(ntryL,G1H12(86),-4,nMT,G2H12(14),n2h12(66))
  call Hloop_QZ_A(ntryL,G2H12(14),ex3(:),G2H4(62),ngZu,m3h3x4(:,16),heltab2x12(:,:,54))
  call Hloop_AV_Q(ntryL,G1H12(89),ex5(:),G1H6(1),m3h2x6(:,39),heltab2x12(:,:,55))
  call Hloop_A_Q(ntryL,G1H6(1),51,nMT,G2H6(39),n2h6(29))
  call Hloop_AV_Q(ntryL,G1H12(90),ex5(:),G1H6(1),m3h2x6(:,40),heltab2x12(:,:,56))
  call Hloop_A_Q(ntryL,G1H6(1),51,nMT,G2H6(40),n2h6(30))
  call Hloop_UV_W(ntryL,G1H8(25),37,ex4(:),8,G2H4(63),m3h2x4(:,47),heltab2x8(:,:,47))
call HGT_OLR(G1H8(26),1,1,8)
call HGT_invQ_OLR(G1H8(26),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(26),-16,nMT,G2H8(5),n2h8(69))
  call Hloop_QV_A(ntryL,G2H8(5),ex5(:),G2H4(64),m3h2x4(:,48),heltab2x8(:,:,48))
  call Hloop_UV_W(ntryL,G1H8(29),37,ex4(:),8,G2H4(65),m3h2x4(:,49),heltab2x8(:,:,49))
  call Hloop_UV_W(ntryL,G1H8(30),37,ex4(:),8,G2H4(66),m3h2x4(:,50),heltab2x8(:,:,50))
  call Hloop_VQ_A(ntryL,G1H12(91),ex1(:),G1H6(1),m3h2x6(:,41),heltab2x12(:,:,57))
  call Hloop_Q_A(ntryL,G1H6(1),43,nMT,G2H6(41),n2h6(31))
call HGT_OLR(G1H12(92),1,1,12)
call HGT_invQ_OLR(G1H12(92),2,5,12)
  call Hloop_A_Q(ntryL,G1H12(92),-16,nMT,G2H12(15),n2h12(67))
  call Hloop_AV_Q(ntryL,G2H12(15),ex5(:),G2H6(42),m3h2x6(:,42),heltab2x12(:,:,58))
  call Hloop_VQ_A(ntryL,G1H12(95),ex1(:),G1H6(1),m3h2x6(:,43),heltab2x12(:,:,59))
  call Hloop_Q_A(ntryL,G1H6(1),43,nMT,G2H6(43),n2h6(32))
  call Hloop_VQ_A(ntryL,G1H12(96),ex1(:),G1H6(1),m3h2x6(:,44),heltab2x12(:,:,60))
  call Hloop_Q_A(ntryL,G1H6(1),43,nMT,G2H6(44),n2h6(33))
  call Hloop_UV_W(ntryL,G1H12(97),50,ex4(:),8,G2H6(45),m3h2x6(:,45),heltab2x12(:,:,61))
call HGT_OLR(G1H12(98),1,1,12)
call HGT_invQ_OLR(G1H12(98),2,5,12)
  call Hloop_A_Q(ntryL,G1H12(98),-4,nMT,G2H12(16),n2h12(68))
  call Hloop_AZ_Q(ntryL,G2H12(16),ex3(:),G2H4(67),ngZu,m3h3x4(:,17),heltab2x12(:,:,62))
  call Hloop_UV_W(ntryL,G1H12(101),50,ex4(:),8,G2H6(46),m3h2x6(:,46),heltab2x12(:,:,63))
  call Hloop_UV_W(ntryL,G1H12(102),50,ex4(:),8,G2H6(47),m3h2x6(:,47),heltab2x12(:,:,64))
  call Hloop_UV_W(ntryL,G1H8(31),37,ex5(:),16,G2H4(68),m3h2x4(:,51),heltab2x8(:,:,51))
call HGT_OLR(G1H8(32),1,1,8)
call HGT_invQ_OLR(G1H8(32),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(32),-8,nMT,G2H8(6),n2h8(70))
  call Hloop_QV_A(ntryL,G2H8(6),ex4(:),G2H4(69),m3h2x4(:,52),heltab2x8(:,:,52))
  call Hloop_UV_W(ntryL,G1H8(35),37,ex5(:),16,G2H4(70),m3h2x4(:,53),heltab2x8(:,:,53))
  call Hloop_UV_W(ntryL,G1H8(36),37,ex5(:),16,G2H4(71),m3h2x4(:,54),heltab2x8(:,:,54))
  call Hloop_UV_W(ntryL,G1H12(103),42,ex5(:),16,G2H6(48),m3h2x6(:,48),heltab2x12(:,:,65))
call HGT_OLR(G1H12(104),1,1,12)
call HGT_invQ_OLR(G1H12(104),2,5,12)
  call Hloop_A_Q(ntryL,G1H12(104),-4,nMT,G2H12(17),n2h12(69))
  call Hloop_AZ_Q(ntryL,G2H12(17),ex3(:),G2H4(72),ngZu,m3h3x4(:,18),heltab2x12(:,:,66))
  call Hloop_UV_W(ntryL,G1H12(107),42,ex5(:),16,G2H6(49),m3h2x6(:,49),heltab2x12(:,:,67))
  call Hloop_UV_W(ntryL,G1H12(108),42,ex5(:),16,G2H6(50),m3h2x6(:,50),heltab2x12(:,:,68))
  call Hloop_VQ_A(ntryL,G1H12(109),ex1(:),G1H6(1),m3h2x6(:,51),heltab2x12(:,:,69))
  call Hloop_Q_A(ntryL,G1H6(1),51,nMT,G2H6(51),n2h6(34))
call HGT_OLR(G1H12(110),1,1,12)
call HGT_invQ_OLR(G1H12(110),2,5,12)
  call Hloop_A_Q(ntryL,G1H12(110),-8,nMT,G2H12(18),n2h12(70))
  call Hloop_AV_Q(ntryL,G2H12(18),ex4(:),G2H6(52),m3h2x6(:,52),heltab2x12(:,:,70))
  call Hloop_VQ_A(ntryL,G1H12(113),ex1(:),G1H6(1),m3h2x6(:,53),heltab2x12(:,:,71))
  call Hloop_Q_A(ntryL,G1H6(1),51,nMT,G2H6(53),n2h6(35))
  call Hloop_VQ_A(ntryL,G1H12(114),ex1(:),G1H6(1),m3h2x6(:,54),heltab2x12(:,:,72))
  call Hloop_Q_A(ntryL,G1H6(1),51,nMT,G2H6(54),n2h6(36))
  call Hloop_UV_W(ntryL,G1H8(37),38,ex4(:),8,G2H4(73),m3h2x4(:,55),heltab2x8(:,:,55))
call HGT_OLR(G1H8(38),1,1,8)
call HGT_invQ_OLR(G1H8(38),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(38),-16,nMT,G2H8(7),n2h8(71))
  call Hloop_AV_Q(ntryL,G2H8(7),ex5(:),G2H4(74),m3h2x4(:,56),heltab2x8(:,:,56))
  call Hloop_UV_W(ntryL,G1H8(41),38,ex4(:),8,G2H4(75),m3h2x4(:,57),heltab2x8(:,:,57))
  call Hloop_UV_W(ntryL,G1H8(42),38,ex4(:),8,G2H4(76),m3h2x4(:,58),heltab2x8(:,:,58))
  call Hloop_UV_W(ntryL,G1H8(43),38,ex5(:),16,G2H4(77),m3h2x4(:,59),heltab2x8(:,:,59))
call HGT_OLR(G1H8(44),1,1,8)
call HGT_invQ_OLR(G1H8(44),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(44),-8,nMT,G2H8(8),n2h8(72))
  call Hloop_AV_Q(ntryL,G2H8(8),ex4(:),G2H4(78),m3h2x4(:,60),heltab2x8(:,:,60))
  call Hloop_UV_W(ntryL,G1H8(47),38,ex5(:),16,G2H4(79),m3h2x4(:,61),heltab2x8(:,:,61))
  call Hloop_UV_W(ntryL,G1H8(48),38,ex5(:),16,G2H4(80),m3h2x4(:,62),heltab2x8(:,:,62))
  call Hloop_VQ_A(ntryL,G1H12(115),ex1(:),G1H6(1),m3h2x6(:,55),heltab2x12(:,:,73))
  call Hloop_Q_A(ntryL,G1H6(1),43,nMT,G2H6(55),n2h6(37))
call HGT_OLR(G1H12(116),1,1,12)
call HGT_invQ_OLR(G1H12(116),2,5,12)
  call Hloop_A_Q(ntryL,G1H12(116),-4,nMT,G2H12(19),n2h12(71))
  call Hloop_AZ_Q(ntryL,G2H12(19),ex3(:),G2H4(81),ngZu,m3h3x4(:,19),heltab2x12(:,:,74))
  call Hloop_VQ_A(ntryL,G1H12(119),ex1(:),G1H6(1),m3h2x6(:,56),heltab2x12(:,:,75))
  call Hloop_Q_A(ntryL,G1H6(1),43,nMT,G2H6(56),n2h6(38))
  call Hloop_VQ_A(ntryL,G1H12(120),ex1(:),G1H6(1),m3h2x6(:,57),heltab2x12(:,:,76))
  call Hloop_Q_A(ntryL,G1H6(1),43,nMT,G2H6(57),n2h6(39))
  call Hloop_VQ_A(ntryL,G1H12(121),ex1(:),G1H6(1),m3h2x6(:,58),heltab2x12(:,:,77))
  call Hloop_Q_A(ntryL,G1H6(1),51,nMT,G2H6(58),n2h6(40))
call HGT_OLR(G1H12(122),1,1,12)
call HGT_invQ_OLR(G1H12(122),2,5,12)
  call Hloop_A_Q(ntryL,G1H12(122),-4,nMT,G2H12(20),n2h12(72))
  call Hloop_AZ_Q(ntryL,G2H12(20),ex3(:),G2H4(82),ngZu,m3h3x4(:,20),heltab2x12(:,:,78))
  call Hloop_VQ_A(ntryL,G1H12(125),ex1(:),G1H6(1),m3h2x6(:,59),heltab2x12(:,:,79))
  call Hloop_Q_A(ntryL,G1H6(1),51,nMT,G2H6(59),n2h6(41))
  call Hloop_VQ_A(ntryL,G1H12(126),ex1(:),G1H6(1),m3h2x6(:,60),heltab2x12(:,:,80))
  call Hloop_Q_A(ntryL,G1H6(1),51,nMT,G2H6(60),n2h6(42))
  call Hloop_VA_Q(ntryL,G1H12(127),ex2(:),G1H6(1),m3h2x6(:,61),heltab2x12(:,:,81))
  call Hloop_A_Q(ntryL,G1H6(1),43,nMT,G2H6(61),n2h6(43))
call HGT_OLR(G1H12(128),1,1,12)
call HGT_invQ_OLR(G1H12(128),2,5,12)
  call Hloop_Q_A(ntryL,G1H12(128),-16,nMT,G2H12(21),n2h12(73))
  call Hloop_QV_A(ntryL,G2H12(21),ex5(:),G2H6(62),m3h2x6(:,62),heltab2x12(:,:,82))
  call Hloop_VA_Q(ntryL,G1H12(131),ex2(:),G1H6(1),m3h2x6(:,63),heltab2x12(:,:,83))
  call Hloop_A_Q(ntryL,G1H6(1),43,nMT,G2H6(63),n2h6(44))
  call Hloop_VA_Q(ntryL,G1H12(132),ex2(:),G1H6(1),m3h2x6(:,64),heltab2x12(:,:,84))
  call Hloop_A_Q(ntryL,G1H6(1),43,nMT,G2H6(64),n2h6(45))
  call Hloop_UV_W(ntryL,G1H12(133),41,ex5(:),16,G2H6(65),m3h2x6(:,65),heltab2x12(:,:,85))
call HGT_OLR(G1H12(134),1,1,12)
call HGT_invQ_OLR(G1H12(134),2,5,12)
  call Hloop_Q_A(ntryL,G1H12(134),-4,nMT,G2H12(22),n2h12(74))
  call Hloop_QZ_A(ntryL,G2H12(22),ex3(:),G2H4(83),ngZu,m3h3x4(:,21),heltab2x12(:,:,86))
  call Hloop_UV_W(ntryL,G1H12(137),41,ex5(:),16,G2H6(66),m3h2x6(:,66),heltab2x12(:,:,87))
  call Hloop_UV_W(ntryL,G1H12(138),41,ex5(:),16,G2H6(67),m3h2x6(:,67),heltab2x12(:,:,88))
  call Hloop_VA_Q(ntryL,G1H12(139),ex2(:),G1H6(1),m3h2x6(:,68),heltab2x12(:,:,89))
  call Hloop_A_Q(ntryL,G1H6(1),43,nMT,G2H6(68),n2h6(46))
call HGT_OLR(G1H12(140),1,1,12)
call HGT_invQ_OLR(G1H12(140),2,5,12)
  call Hloop_Q_A(ntryL,G1H12(140),-4,nMT,G2H12(23),n2h12(75))
  call Hloop_QZ_A(ntryL,G2H12(23),ex3(:),G2H4(84),ngZu,m3h3x4(:,22),heltab2x12(:,:,90))
  call Hloop_VA_Q(ntryL,G1H12(143),ex2(:),G1H6(1),m3h2x6(:,69),heltab2x12(:,:,91))
  call Hloop_A_Q(ntryL,G1H6(1),43,nMT,G2H6(69),n2h6(47))
  call Hloop_VA_Q(ntryL,G1H12(144),ex2(:),G1H6(1),m3h2x6(:,70),heltab2x12(:,:,92))
  call Hloop_A_Q(ntryL,G1H6(1),43,nMT,G2H6(70),n2h6(48))
  call Hloop_UV_W(ntryL,G1H12(145),49,ex4(:),8,G2H6(71),m3h2x6(:,71),heltab2x12(:,:,93))
call HGT_OLR(G1H12(146),1,1,12)
call HGT_invQ_OLR(G1H12(146),2,5,12)
  call Hloop_Q_A(ntryL,G1H12(146),-4,nMT,G2H12(24),n2h12(76))
  call Hloop_QZ_A(ntryL,G2H12(24),ex3(:),G2H4(85),ngZu,m3h3x4(:,23),heltab2x12(:,:,94))
  call Hloop_UV_W(ntryL,G1H12(149),49,ex4(:),8,G2H6(72),m3h2x6(:,72),heltab2x12(:,:,95))
  call Hloop_UV_W(ntryL,G1H12(150),49,ex4(:),8,G2H6(73),m3h2x6(:,73),heltab2x12(:,:,96))
  call Hloop_VA_Q(ntryL,G1H12(151),ex2(:),G1H6(1),m3h2x6(:,74),heltab2x12(:,:,97))
  call Hloop_A_Q(ntryL,G1H6(1),51,nMT,G2H6(74),n2h6(49))
call HGT_OLR(G1H12(152),1,1,12)
call HGT_invQ_OLR(G1H12(152),2,5,12)
  call Hloop_Q_A(ntryL,G1H12(152),-8,nMT,G2H12(25),n2h12(77))
  call Hloop_QV_A(ntryL,G2H12(25),ex4(:),G2H6(75),m3h2x6(:,75),heltab2x12(:,:,98))
  call Hloop_VA_Q(ntryL,G1H12(155),ex2(:),G1H6(1),m3h2x6(:,76),heltab2x12(:,:,99))
  call Hloop_A_Q(ntryL,G1H6(1),51,nMT,G2H6(76),n2h6(50))
  call Hloop_VA_Q(ntryL,G1H12(156),ex2(:),G1H6(1),m3h2x6(:,77),heltab2x12(:,:,100))
  call Hloop_A_Q(ntryL,G1H6(1),51,nMT,G2H6(77),n2h6(51))
  call Hloop_VA_Q(ntryL,G1H12(157),ex2(:),G1H6(1),m3h2x6(:,78),heltab2x12(:,:,101))
  call Hloop_A_Q(ntryL,G1H6(1),51,nMT,G2H6(78),n2h6(52))
call HGT_OLR(G1H12(158),1,1,12)
call HGT_invQ_OLR(G1H12(158),2,5,12)
  call Hloop_Q_A(ntryL,G1H12(158),-4,nMT,G2H12(26),n2h12(78))
  call Hloop_QZ_A(ntryL,G2H12(26),ex3(:),G2H4(86),ngZu,m3h3x4(:,24),heltab2x12(:,:,102))
  call Hloop_VA_Q(ntryL,G1H12(161),ex2(:),G1H6(1),m3h2x6(:,79),heltab2x12(:,:,103))
  call Hloop_A_Q(ntryL,G1H6(1),51,nMT,G2H6(79),n2h6(53))
  call Hloop_VA_Q(ntryL,G1H12(162),ex2(:),G1H6(1),m3h2x6(:,80),heltab2x12(:,:,104))
  call Hloop_A_Q(ntryL,G1H6(1),51,nMT,G2H6(80),n2h6(54))
  call Hloop_QZ_A(ntryL,G1H12(163),ex3(:),G1H4(1),ngZu,m3h3x4(:,25),heltab2x12(:,:,105))
  call Hloop_Q_A(ntryL,G1H4(1),45,nMT,G2H4(87),n2h4(25))
call HGT_raise_alpha_OLR(G1H12(164),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(164),2,5,12)
  call Hloop_UV_W(ntryL,G1H12(164),-16,ex5(:),16,G2H6(81),m3h2x6(:,81),heltab2x12(:,:,106))
call signflip_OLR(G2H6(81))
  call Hloop_QZ_A(ntryL,G1H12(169),ex3(:),G1H4(1),ngZu,m3h3x4(:,26),heltab2x12(:,:,107))
  call Hloop_Q_A(ntryL,G1H4(1),45,nMT,G2H4(88),n2h4(26))
  call Hloop_QZ_A(ntryL,G1H12(175),ex3(:),G1H4(1),ngZu,m3h3x4(:,27),heltab2x12(:,:,108))
  call Hloop_Q_A(ntryL,G1H4(1),45,nMT,G2H4(89),n2h4(27))
call HGT_raise_alpha_OLR(G1H12(170),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(170),2,5,12)
  call Hloop_UV_W(ntryL,G1H12(170),-16,ex5(:),16,G2H6(82),m3h2x6(:,82),heltab2x12(:,:,109))
call signflip_OLR(G2H6(82))
  call Hloop_QZ_A(ntryL,G1H12(173),ex3(:),G1H4(1),ngZu,m3h3x4(:,28),heltab2x12(:,:,110))
  call Hloop_Q_A(ntryL,G1H4(1),45,nMT,G2H4(90),n2h4(28))
  call Hloop_QZ_A(ntryL,G1H12(174),ex3(:),G1H4(1),ngZu,m3h3x4(:,29),heltab2x12(:,:,111))
  call Hloop_Q_A(ntryL,G1H4(1),45,nMT,G2H4(91),n2h4(29))
call HGT_raise_alpha_OLR(G1H12(176),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(176),2,5,12)
  call Hloop_UV_W(ntryL,G1H12(176),-16,ex5(:),16,G2H6(83),m3h2x6(:,83),heltab2x12(:,:,112))
call signflip_OLR(G2H6(83))
  call Hloop_QZ_A(ntryL,G1H12(179),ex3(:),G1H4(1),ngZu,m3h3x4(:,30),heltab2x12(:,:,113))
  call Hloop_Q_A(ntryL,G1H4(1),45,nMT,G2H4(92),n2h4(30))
  call Hloop_QZ_A(ntryL,G1H12(180),ex3(:),G1H4(1),ngZu,m3h3x4(:,31),heltab2x12(:,:,114))
  call Hloop_Q_A(ntryL,G1H4(1),45,nMT,G2H4(93),n2h4(31))
  call Hloop_AZ_Q(ntryL,G1H12(181),ex3(:),G1H4(1),ngZu,m3h3x4(:,32),heltab2x12(:,:,115))
  call Hloop_A_Q(ntryL,G1H4(1),54,nMT,G2H4(94),n2h4(32))
call HGT_raise_alpha_OLR(G1H12(182),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(182),2,5,12)
  call Hloop_UV_W(ntryL,G1H12(182),-8,ex4(:),8,G2H6(84),m3h2x6(:,84),heltab2x12(:,:,116))
call signflip_OLR(G2H6(84))
  call Hloop_AZ_Q(ntryL,G1H12(187),ex3(:),G1H4(1),ngZu,m3h3x4(:,33),heltab2x12(:,:,117))
  call Hloop_A_Q(ntryL,G1H4(1),54,nMT,G2H4(95),n2h4(33))
  call Hloop_AZ_Q(ntryL,G1H12(193),ex3(:),G1H4(1),ngZu,m3h3x4(:,34),heltab2x12(:,:,118))
  call Hloop_A_Q(ntryL,G1H4(1),54,nMT,G2H4(96),n2h4(34))
call HGT_raise_alpha_OLR(G1H12(188),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(188),2,5,12)
  call Hloop_UV_W(ntryL,G1H12(188),-8,ex4(:),8,G2H6(85),m3h2x6(:,85),heltab2x12(:,:,119))
call signflip_OLR(G2H6(85))
  call Hloop_AZ_Q(ntryL,G1H12(191),ex3(:),G1H4(1),ngZu,m3h3x4(:,35),heltab2x12(:,:,120))
  call Hloop_A_Q(ntryL,G1H4(1),54,nMT,G2H4(97),n2h4(35))
  call Hloop_AZ_Q(ntryL,G1H12(192),ex3(:),G1H4(1),ngZu,m3h3x4(:,36),heltab2x12(:,:,121))
  call Hloop_A_Q(ntryL,G1H4(1),54,nMT,G2H4(98),n2h4(36))
call HGT_raise_alpha_OLR(G1H12(194),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(194),2,5,12)
  call Hloop_UV_W(ntryL,G1H12(194),-8,ex4(:),8,G2H6(86),m3h2x6(:,86),heltab2x12(:,:,122))
call signflip_OLR(G2H6(86))
  call Hloop_AZ_Q(ntryL,G1H12(197),ex3(:),G1H4(1),ngZu,m3h3x4(:,37),heltab2x12(:,:,123))
  call Hloop_A_Q(ntryL,G1H4(1),54,nMT,G2H4(99),n2h4(37))
  call Hloop_AZ_Q(ntryL,G1H12(198),ex3(:),G1H4(1),ngZu,m3h3x4(:,38),heltab2x12(:,:,124))
  call Hloop_A_Q(ntryL,G1H4(1),54,nMT,G2H4(100),n2h4(38))
  call Hloop_AZ_Q(ntryL,G1H12(199),ex3(:),G1H4(1),ngZu,m3h3x4(:,39),heltab2x12(:,:,125))
  call Hloop_A_Q(ntryL,G1H4(1),46,nMT,G2H4(101),n2h4(39))
call HGT_raise_alpha_OLR(G1H12(200),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(200),2,5,12)
  call Hloop_UV_W(ntryL,G1H12(200),-16,ex5(:),16,G2H6(87),m3h2x6(:,87),heltab2x12(:,:,126))
call signflip_OLR(G2H6(87))
  call Hloop_AZ_Q(ntryL,G1H12(205),ex3(:),G1H4(1),ngZu,m3h3x4(:,40),heltab2x12(:,:,127))
  call Hloop_A_Q(ntryL,G1H4(1),46,nMT,G2H4(102),n2h4(40))
  call Hloop_AZ_Q(ntryL,G1H12(211),ex3(:),G1H4(1),ngZu,m3h3x4(:,41),heltab2x12(:,:,128))
  call Hloop_A_Q(ntryL,G1H4(1),46,nMT,G2H4(103),n2h4(41))
call HGT_raise_alpha_OLR(G1H12(206),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(206),2,5,12)
  call Hloop_UV_W(ntryL,G1H12(206),-16,ex5(:),16,G2H6(88),m3h2x6(:,88),heltab2x12(:,:,129))
call signflip_OLR(G2H6(88))
  call Hloop_AZ_Q(ntryL,G1H12(209),ex3(:),G1H4(1),ngZu,m3h3x4(:,42),heltab2x12(:,:,130))
  call Hloop_A_Q(ntryL,G1H4(1),46,nMT,G2H4(104),n2h4(42))
  call Hloop_AZ_Q(ntryL,G1H12(210),ex3(:),G1H4(1),ngZu,m3h3x4(:,43),heltab2x12(:,:,131))
  call Hloop_A_Q(ntryL,G1H4(1),46,nMT,G2H4(105),n2h4(43))
call HGT_raise_alpha_OLR(G1H12(212),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(212),2,5,12)
  call Hloop_UV_W(ntryL,G1H12(212),-16,ex5(:),16,G2H6(89),m3h2x6(:,89),heltab2x12(:,:,132))
call signflip_OLR(G2H6(89))
  call Hloop_AZ_Q(ntryL,G1H12(215),ex3(:),G1H4(1),ngZu,m3h3x4(:,44),heltab2x12(:,:,133))
  call Hloop_A_Q(ntryL,G1H4(1),46,nMT,G2H4(106),n2h4(44))
  call Hloop_AZ_Q(ntryL,G1H12(216),ex3(:),G1H4(1),ngZu,m3h3x4(:,45),heltab2x12(:,:,134))
  call Hloop_A_Q(ntryL,G1H4(1),46,nMT,G2H4(107),n2h4(45))
  call Hloop_AZ_Q(ntryL,G1H12(217),ex3(:),G1H4(1),ngZu,m3h3x4(:,46),heltab2x12(:,:,135))
  call Hloop_A_Q(ntryL,G1H4(1),46,nMT,G2H4(108),n2h4(46))
call HGT_raise_alpha_OLR(G1H12(218),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(218),2,5,12)
  call Hloop_UV_W(ntryL,G1H12(218),-16,ex5(:),16,G2H6(90),m3h2x6(:,90),heltab2x12(:,:,136))
call signflip_OLR(G2H6(90))
  call Hloop_AZ_Q(ntryL,G1H12(223),ex3(:),G1H4(1),ngZu,m3h3x4(:,47),heltab2x12(:,:,137))
  call Hloop_A_Q(ntryL,G1H4(1),46,nMT,G2H4(109),n2h4(47))
  call Hloop_AZ_Q(ntryL,G1H12(229),ex3(:),G1H4(1),ngZu,m3h3x4(:,48),heltab2x12(:,:,138))
  call Hloop_A_Q(ntryL,G1H4(1),46,nMT,G2H4(110),n2h4(48))
call HGT_raise_alpha_OLR(G1H12(224),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(224),2,5,12)
  call Hloop_UV_W(ntryL,G1H12(224),-16,ex5(:),16,G2H6(91),m3h2x6(:,91),heltab2x12(:,:,139))
call signflip_OLR(G2H6(91))
  call Hloop_AZ_Q(ntryL,G1H12(227),ex3(:),G1H4(1),ngZu,m3h3x4(:,49),heltab2x12(:,:,140))
  call Hloop_A_Q(ntryL,G1H4(1),46,nMT,G2H4(111),n2h4(49))
  call Hloop_AZ_Q(ntryL,G1H12(228),ex3(:),G1H4(1),ngZu,m3h3x4(:,50),heltab2x12(:,:,141))
  call Hloop_A_Q(ntryL,G1H4(1),46,nMT,G2H4(112),n2h4(50))
call HGT_raise_alpha_OLR(G1H12(230),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(230),2,5,12)
  call Hloop_UV_W(ntryL,G1H12(230),-16,ex5(:),16,G2H6(92),m3h2x6(:,92),heltab2x12(:,:,142))
call signflip_OLR(G2H6(92))
  call Hloop_AZ_Q(ntryL,G1H12(233),ex3(:),G1H4(1),ngZu,m3h3x4(:,51),heltab2x12(:,:,143))
  call Hloop_A_Q(ntryL,G1H4(1),46,nMT,G2H4(113),n2h4(51))
  call Hloop_AZ_Q(ntryL,G1H12(234),ex3(:),G1H4(1),ngZu,m3h3x4(:,52),heltab2x12(:,:,144))
  call Hloop_A_Q(ntryL,G1H4(1),46,nMT,G2H4(114),n2h4(52))
  call Hloop_QV_A(ntryL,G1H8(49),ex4(:),G1H4(1),m3h2x4(:,63),heltab2x8(:,:,63))
  call Hloop_Q_A(ntryL,G1H4(1),45,nMT,G2H4(115),n2h4(53))
call HGT_raise_alpha_OLR(G1H8(50),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(50),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(50),-16,ex5(:),16,G2H4(116),m3h2x4(:,64),heltab2x8(:,:,64))
call signflip_OLR(G2H4(116))
  call Hloop_QV_A(ntryL,G1H8(55),ex4(:),G1H4(1),m3h2x4(:,65),heltab2x8(:,:,65))
  call Hloop_Q_A(ntryL,G1H4(1),45,nMT,G2H4(117),n2h4(54))
  call Hloop_QV_A(ntryL,G1H8(61),ex4(:),G1H4(1),m3h2x4(:,66),heltab2x8(:,:,66))
  call Hloop_Q_A(ntryL,G1H4(1),45,nMT,G2H4(118),n2h4(55))
call HGT_raise_alpha_OLR(G1H8(56),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(56),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(56),-16,ex5(:),16,G2H4(119),m3h2x4(:,67),heltab2x8(:,:,67))
call signflip_OLR(G2H4(119))
  call Hloop_QV_A(ntryL,G1H8(59),ex4(:),G1H4(1),m3h2x4(:,68),heltab2x8(:,:,68))
  call Hloop_Q_A(ntryL,G1H4(1),45,nMT,G2H4(120),n2h4(56))
  call Hloop_QV_A(ntryL,G1H8(60),ex4(:),G1H4(1),m3h2x4(:,69),heltab2x8(:,:,69))
  call Hloop_Q_A(ntryL,G1H4(1),45,nMT,G2H4(121),n2h4(57))
call HGT_raise_alpha_OLR(G1H8(62),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(62),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(62),-16,ex5(:),16,G2H4(122),m3h2x4(:,70),heltab2x8(:,:,70))
call signflip_OLR(G2H4(122))
  call Hloop_QV_A(ntryL,G1H8(65),ex4(:),G1H4(1),m3h2x4(:,71),heltab2x8(:,:,71))
  call Hloop_Q_A(ntryL,G1H4(1),45,nMT,G2H4(123),n2h4(58))
  call Hloop_QV_A(ntryL,G1H8(66),ex4(:),G1H4(1),m3h2x4(:,72),heltab2x8(:,:,72))
  call Hloop_Q_A(ntryL,G1H4(1),45,nMT,G2H4(124),n2h4(59))
  call Hloop_QV_A(ntryL,G1H8(67),ex5(:),G1H4(1),m3h2x4(:,73),heltab2x8(:,:,73))
  call Hloop_Q_A(ntryL,G1H4(1),53,nMT,G2H4(125),n2h4(60))
call HGT_raise_alpha_OLR(G1H8(68),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(68),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(68),-8,ex4(:),8,G2H4(126),m3h2x4(:,74),heltab2x8(:,:,74))
call signflip_OLR(G2H4(126))
  call Hloop_QV_A(ntryL,G1H8(73),ex5(:),G1H4(1),m3h2x4(:,75),heltab2x8(:,:,75))
  call Hloop_Q_A(ntryL,G1H4(1),53,nMT,G2H4(127),n2h4(61))
  call Hloop_QV_A(ntryL,G1H8(79),ex5(:),G1H4(1),m3h2x4(:,76),heltab2x8(:,:,76))
  call Hloop_Q_A(ntryL,G1H4(1),53,nMT,G2H4(128),n2h4(62))
call HGT_raise_alpha_OLR(G1H8(74),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(74),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(74),-8,ex4(:),8,G2H4(129),m3h2x4(:,77),heltab2x8(:,:,77))
call signflip_OLR(G2H4(129))
  call Hloop_QV_A(ntryL,G1H8(77),ex5(:),G1H4(1),m3h2x4(:,78),heltab2x8(:,:,78))
  call Hloop_Q_A(ntryL,G1H4(1),53,nMT,G2H4(130),n2h4(63))
  call Hloop_QV_A(ntryL,G1H8(78),ex5(:),G1H4(1),m3h2x4(:,79),heltab2x8(:,:,79))
  call Hloop_Q_A(ntryL,G1H4(1),53,nMT,G2H4(131),n2h4(64))
call HGT_raise_alpha_OLR(G1H8(80),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(80),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(80),-8,ex4(:),8,G2H4(132),m3h2x4(:,80),heltab2x8(:,:,80))
call signflip_OLR(G2H4(132))
  call Hloop_QV_A(ntryL,G1H8(83),ex5(:),G1H4(1),m3h2x4(:,81),heltab2x8(:,:,81))
  call Hloop_Q_A(ntryL,G1H4(1),53,nMT,G2H4(133),n2h4(65))
  call Hloop_QV_A(ntryL,G1H8(84),ex5(:),G1H4(1),m3h2x4(:,82),heltab2x8(:,:,82))
  call Hloop_Q_A(ntryL,G1H4(1),53,nMT,G2H4(134),n2h4(66))
  call Hloop_QV_A(ntryL,G1H8(85),ex5(:),G1H4(1),m3h2x4(:,83),heltab2x8(:,:,83))
  call Hloop_Q_A(ntryL,G1H4(1),53,nMT,G2H4(135),n2h4(67))
call HGT_raise_alpha_OLR(G1H8(86),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(86),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(86),ex2(:),G1H4(1),m3h2x4(:,84),heltab2x8(:,:,84))
  call Hloop_QV_A(ntryL,G1H8(91),ex5(:),G1H4(2),m3h2x4(:,85),heltab2x8(:,:,85))
  call Hloop_Q_A(ntryL,G1H4(2),53,nMT,G2H4(136),n2h4(68))
  call Hloop_QV_A(ntryL,G1H8(97),ex5(:),G1H4(2),m3h2x4(:,86),heltab2x8(:,:,86))
  call Hloop_Q_A(ntryL,G1H4(2),53,nMT,G2H4(137),n2h4(69))
call HGT_raise_alpha_OLR(G1H8(92),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(92),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(92),ex2(:),G1H4(2),m3h2x4(:,87),heltab2x8(:,:,87))
  call Hloop_QV_A(ntryL,G1H8(95),ex5(:),G1H4(3),m3h2x4(:,88),heltab2x8(:,:,88))
  call Hloop_Q_A(ntryL,G1H4(3),53,nMT,G2H4(138),n2h4(70))
  call Hloop_QV_A(ntryL,G1H8(96),ex5(:),G1H4(3),m3h2x4(:,89),heltab2x8(:,:,89))
  call Hloop_Q_A(ntryL,G1H4(3),53,nMT,G2H4(139),n2h4(71))
call HGT_raise_alpha_OLR(G1H8(98),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(98),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(98),ex2(:),G1H4(3),m3h2x4(:,90),heltab2x8(:,:,90))
  call Hloop_QV_A(ntryL,G1H8(101),ex5(:),G1H4(4),m3h2x4(:,91),heltab2x8(:,:,91))
  call Hloop_Q_A(ntryL,G1H4(4),53,nMT,G2H4(140),n2h4(72))
  call Hloop_QV_A(ntryL,G1H8(102),ex5(:),G1H4(4),m3h2x4(:,92),heltab2x8(:,:,92))
  call Hloop_Q_A(ntryL,G1H4(4),53,nMT,G2H4(141),n2h4(73))
  call Hloop_QV_A(ntryL,G1H8(103),ex4(:),G1H4(4),m3h2x4(:,93),heltab2x8(:,:,93))
  call Hloop_Q_A(ntryL,G1H4(4),45,nMT,G2H4(142),n2h4(74))
call HGT_raise_alpha_OLR(G1H8(104),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(104),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(104),ex2(:),G1H4(4),m3h2x4(:,94),heltab2x8(:,:,94))
  call Hloop_QV_A(ntryL,G1H8(109),ex4(:),G1H4(5),m3h2x4(:,95),heltab2x8(:,:,95))
  call Hloop_Q_A(ntryL,G1H4(5),45,nMT,G2H4(143),n2h4(75))
  call Hloop_QV_A(ntryL,G1H8(115),ex4(:),G1H4(5),m3h2x4(:,96),heltab2x8(:,:,96))
  call Hloop_Q_A(ntryL,G1H4(5),45,nMT,G2H4(144),n2h4(76))
call HGT_raise_alpha_OLR(G1H8(110),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(110),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(110),ex2(:),G1H4(5),m3h2x4(:,97),heltab2x8(:,:,97))
  call Hloop_QV_A(ntryL,G1H8(113),ex4(:),G1H4(6),m3h2x4(:,98),heltab2x8(:,:,98))
  call Hloop_Q_A(ntryL,G1H4(6),45,nMT,G2H4(145),n2h4(77))
  call Hloop_QV_A(ntryL,G1H8(114),ex4(:),G1H4(6),m3h2x4(:,99),heltab2x8(:,:,99))
  call Hloop_Q_A(ntryL,G1H4(6),45,nMT,G2H4(146),n2h4(78))
call HGT_raise_alpha_OLR(G1H8(116),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(116),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(116),ex2(:),G1H4(6),m3h2x4(:,100),heltab2x8(:,:,100))
  call Hloop_QV_A(ntryL,G1H8(119),ex4(:),G1H4(7),m3h2x4(:,101),heltab2x8(:,:,101))
  call Hloop_Q_A(ntryL,G1H4(7),45,nMT,G2H4(147),n2h4(79))
  call Hloop_QV_A(ntryL,G1H8(120),ex4(:),G1H4(7),m3h2x4(:,102),heltab2x8(:,:,102))
  call Hloop_Q_A(ntryL,G1H4(7),45,nMT,G2H4(148),n2h4(80))
  call Hloop_AV_Q(ntryL,G1H8(121),ex4(:),G1H4(7),m3h2x4(:,103),heltab2x8(:,:,103))
  call Hloop_A_Q(ntryL,G1H4(7),46,nMT,G2H4(149),n2h4(81))
call HGT_raise_alpha_OLR(G1H8(122),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(122),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(122),-16,ex5(:),16,G2H4(150),m3h2x4(:,104),heltab2x8(:,:,104))
call signflip_OLR(G2H4(150))
  call Hloop_AV_Q(ntryL,G1H8(127),ex4(:),G1H4(7),m3h2x4(:,105),heltab2x8(:,:,105))
  call Hloop_A_Q(ntryL,G1H4(7),46,nMT,G2H4(151),n2h4(82))
  call Hloop_AV_Q(ntryL,G1H8(133),ex4(:),G1H4(7),m3h2x4(:,106),heltab2x8(:,:,106))
  call Hloop_A_Q(ntryL,G1H4(7),46,nMT,G2H4(152),n2h4(83))
call HGT_raise_alpha_OLR(G1H8(128),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(128),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(128),-16,ex5(:),16,G2H4(153),m3h2x4(:,107),heltab2x8(:,:,107))
call signflip_OLR(G2H4(153))
  call Hloop_AV_Q(ntryL,G1H8(131),ex4(:),G1H4(7),m3h2x4(:,108),heltab2x8(:,:,108))
  call Hloop_A_Q(ntryL,G1H4(7),46,nMT,G2H4(154),n2h4(84))
  call Hloop_AV_Q(ntryL,G1H8(132),ex4(:),G1H4(7),m3h2x4(:,109),heltab2x8(:,:,109))
  call Hloop_A_Q(ntryL,G1H4(7),46,nMT,G2H4(155),n2h4(85))
call HGT_raise_alpha_OLR(G1H8(134),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(134),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(134),-16,ex5(:),16,G2H4(156),m3h2x4(:,110),heltab2x8(:,:,110))
call signflip_OLR(G2H4(156))
  call Hloop_AV_Q(ntryL,G1H8(137),ex4(:),G1H4(7),m3h2x4(:,111),heltab2x8(:,:,111))
  call Hloop_A_Q(ntryL,G1H4(7),46,nMT,G2H4(157),n2h4(86))
  call Hloop_AV_Q(ntryL,G1H8(138),ex4(:),G1H4(7),m3h2x4(:,112),heltab2x8(:,:,112))
  call Hloop_A_Q(ntryL,G1H4(7),46,nMT,G2H4(158),n2h4(87))
  call Hloop_AV_Q(ntryL,G1H8(139),ex5(:),G1H4(7),m3h2x4(:,113),heltab2x8(:,:,113))
  call Hloop_A_Q(ntryL,G1H4(7),54,nMT,G2H4(159),n2h4(88))
call HGT_raise_alpha_OLR(G1H8(140),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(140),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(140),-8,ex4(:),8,G2H4(160),m3h2x4(:,114),heltab2x8(:,:,114))
call signflip_OLR(G2H4(160))
  call Hloop_AV_Q(ntryL,G1H8(145),ex5(:),G1H4(7),m3h2x4(:,115),heltab2x8(:,:,115))
  call Hloop_A_Q(ntryL,G1H4(7),54,nMT,G2H4(161),n2h4(89))
  call Hloop_AV_Q(ntryL,G1H8(151),ex5(:),G1H4(7),m3h2x4(:,116),heltab2x8(:,:,116))
  call Hloop_A_Q(ntryL,G1H4(7),54,nMT,G2H4(162),n2h4(90))
call HGT_raise_alpha_OLR(G1H8(146),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(146),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(146),-8,ex4(:),8,G2H4(163),m3h2x4(:,117),heltab2x8(:,:,117))
call signflip_OLR(G2H4(163))
  call Hloop_AV_Q(ntryL,G1H8(149),ex5(:),G1H4(7),m3h2x4(:,118),heltab2x8(:,:,118))
  call Hloop_A_Q(ntryL,G1H4(7),54,nMT,G2H4(164),n2h4(91))
  call Hloop_AV_Q(ntryL,G1H8(150),ex5(:),G1H4(7),m3h2x4(:,119),heltab2x8(:,:,119))
  call Hloop_A_Q(ntryL,G1H4(7),54,nMT,G2H4(165),n2h4(92))
call HGT_raise_alpha_OLR(G1H8(152),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(152),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(152),-8,ex4(:),8,G2H4(166),m3h2x4(:,120),heltab2x8(:,:,120))
call signflip_OLR(G2H4(166))
  call Hloop_AV_Q(ntryL,G1H8(155),ex5(:),G1H4(7),m3h2x4(:,121),heltab2x8(:,:,121))
  call Hloop_A_Q(ntryL,G1H4(7),54,nMT,G2H4(167),n2h4(93))
  call Hloop_AV_Q(ntryL,G1H8(156),ex5(:),G1H4(7),m3h2x4(:,122),heltab2x8(:,:,122))
  call Hloop_A_Q(ntryL,G1H4(7),54,nMT,G2H4(168),n2h4(94))
  call Hloop_QZ_A(ntryL,G1H12(235),ex3(:),G1H4(7),ngZu,m3h3x4(:,53),heltab2x12(:,:,145))
  call Hloop_Q_A(ntryL,G1H4(7),45,nMT,G2H4(169),n2h4(95))
call HGT_raise_alpha_OLR(G1H12(236),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(236),2,5,12)
  call Hloop_UV_W(ntryL,G1H12(236),-16,ex5(:),16,G2H6(93),m3h2x6(:,93),heltab2x12(:,:,146))
call signflip_OLR(G2H6(93))
  call Hloop_QZ_A(ntryL,G1H12(241),ex3(:),G1H4(7),ngZu,m3h3x4(:,54),heltab2x12(:,:,147))
  call Hloop_Q_A(ntryL,G1H4(7),45,nMT,G2H4(170),n2h4(96))
  call Hloop_QZ_A(ntryL,G1H12(247),ex3(:),G1H4(7),ngZu,m3h3x4(:,55),heltab2x12(:,:,148))
  call Hloop_Q_A(ntryL,G1H4(7),45,nMT,G2H4(171),n2h4(97))
call HGT_raise_alpha_OLR(G1H12(242),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(242),2,5,12)
  call Hloop_UV_W(ntryL,G1H12(242),-16,ex5(:),16,G2H6(94),m3h2x6(:,94),heltab2x12(:,:,149))
call signflip_OLR(G2H6(94))
  call Hloop_QZ_A(ntryL,G1H12(245),ex3(:),G1H4(7),ngZu,m3h3x4(:,56),heltab2x12(:,:,150))
  call Hloop_Q_A(ntryL,G1H4(7),45,nMT,G2H4(172),n2h4(98))
  call Hloop_QZ_A(ntryL,G1H12(246),ex3(:),G1H4(7),ngZu,m3h3x4(:,57),heltab2x12(:,:,151))
  call Hloop_Q_A(ntryL,G1H4(7),45,nMT,G2H4(173),n2h4(99))
call HGT_raise_alpha_OLR(G1H12(248),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(248),2,5,12)
  call Hloop_UV_W(ntryL,G1H12(248),-16,ex5(:),16,G2H6(95),m3h2x6(:,95),heltab2x12(:,:,152))
call signflip_OLR(G2H6(95))
  call Hloop_QZ_A(ntryL,G1H12(251),ex3(:),G1H4(7),ngZu,m3h3x4(:,58),heltab2x12(:,:,153))
  call Hloop_Q_A(ntryL,G1H4(7),45,nMT,G2H4(174),n2h4(100))
  call Hloop_QZ_A(ntryL,G1H12(252),ex3(:),G1H4(7),ngZu,m3h3x4(:,59),heltab2x12(:,:,154))
  call Hloop_Q_A(ntryL,G1H4(7),45,nMT,G2H4(175),n2h4(101))
  call Hloop_QV_A(ntryL,G1H12(253),ex5(:),G1H6(1),m3h2x6(:,96),heltab2x12(:,:,155))
  call Hloop_Q_A(ntryL,G1H6(1),57,nMT,G2H6(96),n2h6(55))
call HGT_raise_alpha_OLR(G1H12(254),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(254),2,5,12)
  call Hloop_VA_Q(ntryL,G1H12(254),ex2(:),G1H6(1),m3h2x6(:,97),heltab2x12(:,:,156))
  call Hloop_QV_A(ntryL,G1H12(259),ex5(:),G1H6(2),m3h2x6(:,98),heltab2x12(:,:,157))
  call Hloop_Q_A(ntryL,G1H6(2),57,nMT,G2H6(97),n2h6(56))
  call Hloop_QV_A(ntryL,G1H12(265),ex5(:),G1H6(2),m3h2x6(:,99),heltab2x12(:,:,158))
  call Hloop_Q_A(ntryL,G1H6(2),57,nMT,G2H6(98),n2h6(57))
call HGT_raise_alpha_OLR(G1H12(260),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(260),2,5,12)
  call Hloop_VA_Q(ntryL,G1H12(260),ex2(:),G1H6(2),m3h2x6(:,100),heltab2x12(:,:,159))
  call Hloop_QV_A(ntryL,G1H12(263),ex5(:),G1H6(3),m3h2x6(:,101),heltab2x12(:,:,160))
  call Hloop_Q_A(ntryL,G1H6(3),57,nMT,G2H6(99),n2h6(58))
  call Hloop_QV_A(ntryL,G1H12(264),ex5(:),G1H6(3),m3h2x6(:,102),heltab2x12(:,:,161))
  call Hloop_Q_A(ntryL,G1H6(3),57,nMT,G2H6(100),n2h6(59))
call HGT_raise_alpha_OLR(G1H12(266),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(266),2,5,12)
  call Hloop_VA_Q(ntryL,G1H12(266),ex2(:),G1H6(3),m3h2x6(:,103),heltab2x12(:,:,162))
  call Hloop_QV_A(ntryL,G1H12(269),ex5(:),G1H6(4),m3h2x6(:,104),heltab2x12(:,:,163))
  call Hloop_Q_A(ntryL,G1H6(4),57,nMT,G2H6(101),n2h6(60))
  call Hloop_QV_A(ntryL,G1H12(270),ex5(:),G1H6(4),m3h2x6(:,105),heltab2x12(:,:,164))
  call Hloop_Q_A(ntryL,G1H6(4),57,nMT,G2H6(102),n2h6(61))
  call Hloop_QZ_A(ntryL,G1H12(271),ex3(:),G1H4(7),ngZu,m3h3x4(:,60),heltab2x12(:,:,165))
  call Hloop_Q_A(ntryL,G1H4(7),45,nMT,G2H4(176),n2h4(102))
call HGT_raise_alpha_OLR(G1H12(272),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(272),2,5,12)
  call Hloop_VA_Q(ntryL,G1H12(272),ex2(:),G1H6(4),m3h2x6(:,106),heltab2x12(:,:,166))
  call Hloop_QZ_A(ntryL,G1H12(277),ex3(:),G1H4(7),ngZu,m3h3x4(:,61),heltab2x12(:,:,167))
  call Hloop_Q_A(ntryL,G1H4(7),45,nMT,G2H4(177),n2h4(103))
  call Hloop_QZ_A(ntryL,G1H12(283),ex3(:),G1H4(7),ngZu,m3h3x4(:,62),heltab2x12(:,:,168))
  call Hloop_Q_A(ntryL,G1H4(7),45,nMT,G2H4(178),n2h4(104))
call HGT_raise_alpha_OLR(G1H12(278),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(278),2,5,12)
  call Hloop_VA_Q(ntryL,G1H12(278),ex2(:),G1H6(5),m3h2x6(:,107),heltab2x12(:,:,169))
  call Hloop_QZ_A(ntryL,G1H12(281),ex3(:),G1H4(7),ngZu,m3h3x4(:,63),heltab2x12(:,:,170))
  call Hloop_Q_A(ntryL,G1H4(7),45,nMT,G2H4(179),n2h4(105))
  call Hloop_QZ_A(ntryL,G1H12(282),ex3(:),G1H4(7),ngZu,m3h3x4(:,64),heltab2x12(:,:,171))
  call Hloop_Q_A(ntryL,G1H4(7),45,nMT,G2H4(180),n2h4(106))
call HGT_raise_alpha_OLR(G1H12(284),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(284),2,5,12)
  call Hloop_VA_Q(ntryL,G1H12(284),ex2(:),G1H6(6),m3h2x6(:,108),heltab2x12(:,:,172))
  call Hloop_QZ_A(ntryL,G1H12(287),ex3(:),G1H4(7),ngZu,m3h3x4(:,65),heltab2x12(:,:,173))
  call Hloop_Q_A(ntryL,G1H4(7),45,nMT,G2H4(181),n2h4(107))
  call Hloop_QZ_A(ntryL,G1H12(288),ex3(:),G1H4(7),ngZu,m3h3x4(:,66),heltab2x12(:,:,174))
  call Hloop_Q_A(ntryL,G1H4(7),45,nMT,G2H4(182),n2h4(108))
  call Hloop_QZ_A(ntryL,G1H12(289),ex3(:),G1H4(7),ngZu,m3h3x4(:,67),heltab2x12(:,:,175))
  call Hloop_Q_A(ntryL,G1H4(7),53,nMT,G2H4(183),n2h4(109))
call HGT_raise_alpha_OLR(G1H12(290),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(290),2,5,12)
  call Hloop_UV_W(ntryL,G1H12(290),-8,ex4(:),8,G2H6(103),m3h2x6(:,109),heltab2x12(:,:,176))
call signflip_OLR(G2H6(103))
  call Hloop_QZ_A(ntryL,G1H12(295),ex3(:),G1H4(7),ngZu,m3h3x4(:,68),heltab2x12(:,:,177))
  call Hloop_Q_A(ntryL,G1H4(7),53,nMT,G2H4(184),n2h4(110))
  call Hloop_QZ_A(ntryL,G1H12(301),ex3(:),G1H4(7),ngZu,m3h3x4(:,69),heltab2x12(:,:,178))
  call Hloop_Q_A(ntryL,G1H4(7),53,nMT,G2H4(185),n2h4(111))
call HGT_raise_alpha_OLR(G1H12(296),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(296),2,5,12)
  call Hloop_UV_W(ntryL,G1H12(296),-8,ex4(:),8,G2H6(104),m3h2x6(:,110),heltab2x12(:,:,179))
call signflip_OLR(G2H6(104))
  call Hloop_QZ_A(ntryL,G1H12(299),ex3(:),G1H4(7),ngZu,m3h3x4(:,70),heltab2x12(:,:,180))
  call Hloop_Q_A(ntryL,G1H4(7),53,nMT,G2H4(186),n2h4(112))
  call Hloop_QZ_A(ntryL,G1H12(300),ex3(:),G1H4(7),ngZu,m3h3x4(:,71),heltab2x12(:,:,181))
  call Hloop_Q_A(ntryL,G1H4(7),53,nMT,G2H4(187),n2h4(113))
call HGT_raise_alpha_OLR(G1H12(302),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(302),2,5,12)
  call Hloop_UV_W(ntryL,G1H12(302),-8,ex4(:),8,G2H6(105),m3h2x6(:,111),heltab2x12(:,:,182))
call signflip_OLR(G2H6(105))
  call Hloop_QZ_A(ntryL,G1H12(305),ex3(:),G1H4(7),ngZu,m3h3x4(:,72),heltab2x12(:,:,183))
  call Hloop_Q_A(ntryL,G1H4(7),53,nMT,G2H4(188),n2h4(114))
  call Hloop_QZ_A(ntryL,G1H12(306),ex3(:),G1H4(7),ngZu,m3h3x4(:,73),heltab2x12(:,:,184))
  call Hloop_Q_A(ntryL,G1H4(7),53,nMT,G2H4(189),n2h4(115))
  call Hloop_QV_A(ntryL,G1H12(307),ex4(:),G1H6(7),m3h2x6(:,112),heltab2x12(:,:,185))
  call Hloop_Q_A(ntryL,G1H6(7),57,nMT,G2H6(106),n2h6(62))
call HGT_raise_alpha_OLR(G1H12(308),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(308),2,5,12)
  call Hloop_VA_Q(ntryL,G1H12(308),ex2(:),G1H6(7),m3h2x6(:,113),heltab2x12(:,:,186))
  call Hloop_QV_A(ntryL,G1H12(313),ex4(:),G1H6(8),m3h2x6(:,114),heltab2x12(:,:,187))
  call Hloop_Q_A(ntryL,G1H6(8),57,nMT,G2H6(107),n2h6(63))
  call Hloop_QV_A(ntryL,G1H12(319),ex4(:),G1H6(8),m3h2x6(:,115),heltab2x12(:,:,188))
  call Hloop_Q_A(ntryL,G1H6(8),57,nMT,G2H6(108),n2h6(64))
call HGT_raise_alpha_OLR(G1H12(314),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(314),2,5,12)
  call Hloop_VA_Q(ntryL,G1H12(314),ex2(:),G1H6(8),m3h2x6(:,116),heltab2x12(:,:,189))
  call Hloop_QV_A(ntryL,G1H12(317),ex4(:),G1H6(9),m3h2x6(:,117),heltab2x12(:,:,190))
  call Hloop_Q_A(ntryL,G1H6(9),57,nMT,G2H6(109),n2h6(65))
  call Hloop_QV_A(ntryL,G1H12(318),ex4(:),G1H6(9),m3h2x6(:,118),heltab2x12(:,:,191))
  call Hloop_Q_A(ntryL,G1H6(9),57,nMT,G2H6(110),n2h6(66))
call HGT_raise_alpha_OLR(G1H12(320),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(320),2,5,12)
  call Hloop_VA_Q(ntryL,G1H12(320),ex2(:),G1H6(9),m3h2x6(:,119),heltab2x12(:,:,192))
  call Hloop_QV_A(ntryL,G1H12(323),ex4(:),G1H6(10),m3h2x6(:,120),heltab2x12(:,:,193))
  call Hloop_Q_A(ntryL,G1H6(10),57,nMT,G2H6(111),n2h6(67))
  call Hloop_QV_A(ntryL,G1H12(324),ex4(:),G1H6(10),m3h2x6(:,121),heltab2x12(:,:,194))
  call Hloop_Q_A(ntryL,G1H6(10),57,nMT,G2H6(112),n2h6(68))
  call Hloop_QZ_A(ntryL,G1H12(325),ex3(:),G1H4(7),ngZu,m3h3x4(:,74),heltab2x12(:,:,195))
  call Hloop_Q_A(ntryL,G1H4(7),53,nMT,G2H4(190),n2h4(116))
call HGT_raise_alpha_OLR(G1H12(326),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(326),2,5,12)
  call Hloop_VA_Q(ntryL,G1H12(326),ex2(:),G1H6(10),m3h2x6(:,122),heltab2x12(:,:,196))
  call Hloop_QZ_A(ntryL,G1H12(331),ex3(:),G1H4(7),ngZu,m3h3x4(:,75),heltab2x12(:,:,197))
  call Hloop_Q_A(ntryL,G1H4(7),53,nMT,G2H4(191),n2h4(117))
  call Hloop_QZ_A(ntryL,G1H12(337),ex3(:),G1H4(7),ngZu,m3h3x4(:,76),heltab2x12(:,:,198))
  call Hloop_Q_A(ntryL,G1H4(7),53,nMT,G2H4(192),n2h4(118))
call HGT_raise_alpha_OLR(G1H12(332),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(332),2,5,12)
  call Hloop_VA_Q(ntryL,G1H12(332),ex2(:),G1H6(11),m3h2x6(:,123),heltab2x12(:,:,199))
  call Hloop_QZ_A(ntryL,G1H12(335),ex3(:),G1H4(7),ngZu,m3h3x4(:,77),heltab2x12(:,:,200))
  call Hloop_Q_A(ntryL,G1H4(7),53,nMT,G2H4(193),n2h4(119))
  call Hloop_QZ_A(ntryL,G1H12(336),ex3(:),G1H4(7),ngZu,m3h3x4(:,78),heltab2x12(:,:,201))
  call Hloop_Q_A(ntryL,G1H4(7),53,nMT,G2H4(194),n2h4(120))
call HGT_raise_alpha_OLR(G1H12(338),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(338),2,5,12)
  call Hloop_VA_Q(ntryL,G1H12(338),ex2(:),G1H6(12),m3h2x6(:,124),heltab2x12(:,:,202))
  call Hloop_QZ_A(ntryL,G1H12(341),ex3(:),G1H4(7),ngZu,m3h3x4(:,79),heltab2x12(:,:,203))
  call Hloop_Q_A(ntryL,G1H4(7),53,nMT,G2H4(195),n2h4(121))
  call Hloop_QZ_A(ntryL,G1H12(342),ex3(:),G1H4(7),ngZu,m3h3x4(:,80),heltab2x12(:,:,204))
  call Hloop_Q_A(ntryL,G1H4(7),53,nMT,G2H4(196),n2h4(122))
  call Hotf_5pt_reduction(G2H4(1),RedSet_5(1),mass5set(:,1),  & 
G1H4(7),G1H4(8),G1H4(9),G1H4(10),G1H4(11),G1H4(12),4)
  call HG1shiftOLR(G1H4(8),16,4)
  call Hotf_5pt_reduction(G2H4(3),RedSet_5(63),mass5set(:,11),  & 
G1H4(13),G1H4(14),G1H4(15),G1H4(16),G1H4(17),G1H4(18),4)
  call HG1shiftOLR(G1H4(14),16,4)
  call Hotf_5pt_reduction(G2H4(4),RedSet_5(2),mass5set(:,1),  & 
G1H4(19),G1H4(20),G1H4(21),G1H4(22),G1H4(23),G1H4(24),4)
  call HG1shiftOLR(G1H4(20),16,4)
  call Hotf_5pt_reduction(G2H4(6),RedSet_5(64),mass5set(:,11),  & 
G1H4(25),G1H4(26),G1H4(27),G1H4(28),G1H4(29),G1H4(30),4)
  call HG1shiftOLR(G1H4(26),16,4)
  call Hotf_5pt_reduction(G2H4(7),RedSet_5(3),mass5set(:,1),  & 
G1H4(31),G1H4(32),G1H4(33),G1H4(34),G1H4(35),G1H4(36),4)
  call HG1shiftOLR(G1H4(32),8,4)
  call Hotf_5pt_reduction(G2H4(9),RedSet_5(65),mass5set(:,11),  & 
G1H4(37),G1H4(38),G1H4(39),G1H4(40),G1H4(41),G1H4(42),4)
  call HG1shiftOLR(G1H4(38),8,4)
  call Hotf_5pt_reduction(G2H4(10),RedSet_5(4),mass5set(:,1),  & 
G1H4(43),G1H4(44),G1H4(45),G1H4(46),G1H4(47),G1H4(48),4)
  call HG1shiftOLR(G1H4(44),16,4)
  call Hotf_5pt_reduction(G2H4(12),RedSet_5(63),mass5set(:,11),  & 
G1H4(49),G1H4(50),G1H4(51),G1H4(52),G1H4(53),G1H4(54),4)
  call HG1shiftOLR(G1H4(50),16,4)
  call Hotf_5pt_reduction(G2H4(13),RedSet_5(5),mass5set(:,1),  & 
G1H4(55),G1H4(56),G1H4(57),G1H4(58),G1H4(59),G1H4(60),4)
  call HG1shiftOLR(G1H4(56),16,4)
  call Hotf_5pt_reduction(G2H4(15),RedSet_5(64),mass5set(:,11),  & 
G1H4(61),G1H4(62),G1H4(63),G1H4(64),G1H4(65),G1H4(66),4)
  call HG1shiftOLR(G1H4(62),16,4)
  call Hotf_5pt_reduction(G2H4(16),RedSet_5(6),mass5set(:,1),  & 
G1H4(67),G1H4(68),G1H4(69),G1H4(70),G1H4(71),G1H4(72),4)
  call HG1shiftOLR(G1H4(68),8,4)
  call Hotf_5pt_reduction(G2H4(18),RedSet_5(65),mass5set(:,11),  & 
G1H4(73),G1H4(74),G1H4(75),G1H4(76),G1H4(77),G1H4(78),4)
  call HG1shiftOLR(G1H4(74),8,4)
  call Hotf_5pt_reduction(G2H4(19),RedSet_5(8),mass5set(:,3),  & 
G1H4(79),G1H4(80),G1H4(81),G1H4(82),G1H4(83),G1H4(84),4)
  call HG1shiftOLR(G1H4(80),16,4)
  call Hotf_5pt_reduction(G2H4(21),RedSet_5(56),mass5set(:,3),  & 
G1H4(85),G1H4(86),G1H4(87),G1H4(88),G1H4(89),G1H4(90),4)
  call HG1shiftOLR(G1H4(86),16,4)
  call Hotf_5pt_reduction(G2H4(22),RedSet_5(8),mass5set(:,3),  & 
G1H4(91),G1H4(92),G1H4(93),G1H4(94),G1H4(95),G1H4(96),4)
  call HG1shiftOLR(G1H4(92),8,4)
  call Hotf_5pt_reduction(G2H4(24),RedSet_5(57),mass5set(:,3),  & 
G1H4(97),G1H4(98),G1H4(99),G1H4(100),G1H4(101),G1H4(102),4)
  call HG1shiftOLR(G1H4(98),8,4)
  call Hotf_5pt_reduction(G2H4(25),RedSet_5(12),mass5set(:,3),  & 
G1H4(103),G1H4(104),G1H4(105),G1H4(106),G1H4(107),G1H4(108),4)
  call HG1shiftOLR(G1H4(104),16,4)
  call Hotf_5pt_reduction(G2H4(27),RedSet_5(50),mass5set(:,3),  & 
G1H4(109),G1H4(110),G1H4(111),G1H4(112),G1H4(113),G1H4(114),4)
  call HG1shiftOLR(G1H4(110),16,4)
  call Hotf_5pt_reduction(G2H4(28),RedSet_5(12),mass5set(:,3),  & 
G1H4(115),G1H4(116),G1H4(117),G1H4(118),G1H4(119),G1H4(120),4)
  call HG1shiftOLR(G1H4(116),8,4)
  call Hotf_5pt_reduction(G2H4(30),RedSet_5(52),mass5set(:,3),  & 
G1H4(121),G1H4(122),G1H4(123),G1H4(124),G1H4(125),G1H4(126),4)
  call HG1shiftOLR(G1H4(122),8,4)
  call Hotf_5pt_reduction(G2H6(1),RedSet_5(21),mass5set(:,5),  & 
G1H6(13),G1H6(14),G1H6(15),G1H6(16),G1H6(17),G1H6(18),6)
  call HG1shiftOLR(G1H6(14),16,6)
  call Hotf_5pt_reduction(G2H6(4),RedSet_5(46),mass5set(:,5),  & 
G1H6(19),G1H6(20),G1H6(21),G1H6(22),G1H6(23),G1H6(24),6)
  call HG1shiftOLR(G1H6(20),16,6)
  call Hotf_5pt_reduction(G2H4(31),RedSet_5(22),mass5set(:,5),  & 
G1H4(127),G1H4(128),G1H4(129),G1H4(130),G1H4(131),G1H4(132),4)
  call HG1shiftOLR(G1H4(128),16,4)
  call Hotf_5pt_reduction(G2H4(34),RedSet_5(66),mass5set(:,5),  & 
G1H4(133),G1H4(134),G1H4(135),G1H4(136),G1H4(137),G1H4(138),4)
  call HG1shiftOLR(G1H4(134),16,4)
  call Hotf_5pt_reduction(G2H4(35),RedSet_5(22),mass5set(:,5),  & 
G1H4(139),G1H4(140),G1H4(141),G1H4(142),G1H4(143),G1H4(144),4)
  call HG1shiftOLR(G1H4(140),8,4)
  call Hotf_5pt_reduction(G2H4(38),RedSet_5(67),mass5set(:,5),  & 
G1H4(145),G1H4(146),G1H4(147),G1H4(148),G1H4(149),G1H4(150),4)
  call HG1shiftOLR(G1H4(146),8,4)
  call Hotf_5pt_reduction(G2H4(39),RedSet_5(23),mass5set(:,6),  & 
G1H4(151),G1H4(152),G1H4(153),G1H4(154),G1H4(155),G1H4(156),4)
  call HG1shiftOLR(G1H4(152),16,4)
  call Hotf_5pt_reduction(G2H4(41),RedSet_5(68),mass5set(:,6),  & 
G1H4(157),G1H4(158),G1H4(159),G1H4(160),G1H4(161),G1H4(162),4)
  call HG1shiftOLR(G1H4(158),16,4)
  call Hotf_5pt_reduction(G2H4(42),RedSet_5(23),mass5set(:,6),  & 
G1H4(163),G1H4(164),G1H4(165),G1H4(166),G1H4(167),G1H4(168),4)
  call HG1shiftOLR(G1H4(164),8,4)
  call Hotf_5pt_reduction(G2H4(44),RedSet_5(69),mass5set(:,6),  & 
G1H4(169),G1H4(170),G1H4(171),G1H4(172),G1H4(173),G1H4(174),4)
  call HG1shiftOLR(G1H4(170),8,4)
  call Hotf_5pt_reduction(G2H6(7),RedSet_5(24),mass5set(:,5),  & 
G1H6(25),G1H6(26),G1H6(27),G1H6(28),G1H6(29),G1H6(30),6)
  call HG1shiftOLR(G1H6(26),16,6)
  call Hotf_5pt_reduction(G2H6(10),RedSet_5(42),mass5set(:,5),  & 
G1H6(31),G1H6(32),G1H6(33),G1H6(34),G1H6(35),G1H6(36),6)
  call HG1shiftOLR(G1H6(32),16,6)
  call Hotf_5pt_reduction(G2H4(45),RedSet_5(25),mass5set(:,5),  & 
G1H4(175),G1H4(176),G1H4(177),G1H4(178),G1H4(179),G1H4(180),4)
  call HG1shiftOLR(G1H4(176),16,4)
  call Hotf_5pt_reduction(G2H4(48),RedSet_5(70),mass5set(:,5),  & 
G1H4(181),G1H4(182),G1H4(183),G1H4(184),G1H4(185),G1H4(186),4)
  call HG1shiftOLR(G1H4(182),16,4)
  call Hotf_5pt_reduction(G2H6(11),RedSet_5(26),mass5set(:,6),  & 
G1H6(37),G1H6(38),G1H6(39),G1H6(40),G1H6(41),G1H6(42),6)
  call HG1shiftOLR(G1H6(38),16,6)
  call Hotf_5pt_reduction(G2H6(14),RedSet_5(68),mass5set(:,6),  & 
G1H6(43),G1H6(44),G1H6(45),G1H6(46),G1H6(47),G1H6(48),6)
  call HG1shiftOLR(G1H6(44),16,6)
  call Hotf_5pt_reduction(G2H6(15),RedSet_5(26),mass5set(:,6),  & 
G1H6(49),G1H6(50),G1H6(51),G1H6(52),G1H6(53),G1H6(54),6)
  call HG1shiftOLR(G1H6(50),4,6)
  call Hotf_5pt_reduction(G2H6(17),RedSet_5(71),mass5set(:,6),  & 
G1H6(55),G1H6(56),G1H6(57),G1H6(58),G1H6(59),G1H6(60),6)
  call HG1shiftOLR(G1H6(56),4,6)
  call Hotf_5pt_reduction(G2H4(50),RedSet_5(25),mass5set(:,5),  & 
G1H4(187),G1H4(188),G1H4(189),G1H4(190),G1H4(191),G1H4(192),4)
  call HG1shiftOLR(G1H4(188),8,4)
  call Hotf_5pt_reduction(G2H4(53),RedSet_5(72),mass5set(:,5),  & 
G1H4(193),G1H4(194),G1H4(195),G1H4(196),G1H4(197),G1H4(198),4)
  call HG1shiftOLR(G1H4(194),8,4)
  call Hotf_5pt_reduction(G2H6(18),RedSet_5(27),mass5set(:,6),  & 
G1H6(61),G1H6(62),G1H6(63),G1H6(64),G1H6(65),G1H6(66),6)
  call HG1shiftOLR(G1H6(62),8,6)
  call Hotf_5pt_reduction(G2H6(21),RedSet_5(69),mass5set(:,6),  & 
G1H6(67),G1H6(68),G1H6(69),G1H6(70),G1H6(71),G1H6(72),6)
  call HG1shiftOLR(G1H6(68),8,6)
  call Hotf_5pt_reduction(G2H6(22),RedSet_5(27),mass5set(:,6),  & 
G1H6(73),G1H6(74),G1H6(75),G1H6(76),G1H6(77),G1H6(78),6)
  call HG1shiftOLR(G1H6(74),4,6)
  call Hotf_5pt_reduction(G2H6(24),RedSet_5(71),mass5set(:,6),  & 
G1H6(79),G1H6(80),G1H6(81),G1H6(82),G1H6(83),G1H6(84),6)
  call HG1shiftOLR(G1H6(80),4,6)
  call Hotf_5pt_reduction(G2H4(55),RedSet_5(28),mass5set(:,6),  & 
G1H4(199),G1H4(200),G1H4(201),G1H4(202),G1H4(203),G1H4(204),4)
  call HG1shiftOLR(G1H4(200),16,4)
  call Hotf_5pt_reduction(G2H4(57),RedSet_5(73),mass5set(:,6),  & 
G1H4(205),G1H4(206),G1H4(207),G1H4(208),G1H4(209),G1H4(210),4)
  call HG1shiftOLR(G1H4(206),16,4)
  call Hotf_5pt_reduction(G2H4(58),RedSet_5(28),mass5set(:,6),  & 
G1H4(211),G1H4(212),G1H4(213),G1H4(214),G1H4(215),G1H4(216),4)
  call HG1shiftOLR(G1H4(212),8,4)
  call Hotf_5pt_reduction(G2H4(60),RedSet_5(74),mass5set(:,6),  & 
G1H4(217),G1H4(218),G1H4(219),G1H4(220),G1H4(221),G1H4(222),4)
  call HG1shiftOLR(G1H4(218),8,4)
  call Hotf_5pt_reduction(G2H6(27),RedSet_5(29),mass5set(:,6),  & 
G1H6(85),G1H6(86),G1H6(87),G1H6(88),G1H6(89),G1H6(90),6)
  call HG1shiftOLR(G1H6(86),16,6)
  call Hotf_5pt_reduction(G2H6(30),RedSet_5(73),mass5set(:,6),  & 
G1H6(91),G1H6(92),G1H6(93),G1H6(94),G1H6(95),G1H6(96),6)
  call HG1shiftOLR(G1H6(92),16,6)
  call Hotf_5pt_reduction(G2H6(31),RedSet_5(29),mass5set(:,6),  & 
G1H6(97),G1H6(98),G1H6(99),G1H6(100),G1H6(101),G1H6(102),6)
  call HG1shiftOLR(G1H6(98),4,6)
  call Hotf_5pt_reduction(G2H6(33),RedSet_5(75),mass5set(:,6),  & 
G1H6(103),G1H6(104),G1H6(105),G1H6(106),G1H6(107),G1H6(108),6)
  call HG1shiftOLR(G1H6(104),4,6)
  call Hotf_5pt_reduction(G2H6(34),RedSet_5(30),mass5set(:,6),  & 
G1H6(109),G1H6(110),G1H6(111),G1H6(112),G1H6(113),G1H6(114),6)
  call HG1shiftOLR(G1H6(110),8,6)
  call Hotf_5pt_reduction(G2H6(37),RedSet_5(74),mass5set(:,6),  & 
G1H6(115),G1H6(116),G1H6(117),G1H6(118),G1H6(119),G1H6(120),6)
  call HG1shiftOLR(G1H6(116),8,6)
  call Hotf_5pt_reduction(G2H6(38),RedSet_5(30),mass5set(:,6),  & 
G1H6(121),G1H6(122),G1H6(123),G1H6(124),G1H6(125),G1H6(126),6)
  call HG1shiftOLR(G1H6(122),4,6)
  call Hotf_5pt_reduction(G2H6(40),RedSet_5(75),mass5set(:,6),  & 
G1H6(127),G1H6(128),G1H6(129),G1H6(130),G1H6(131),G1H6(132),6)
  call HG1shiftOLR(G1H6(128),4,6)
  call Hotf_5pt_reduction(G2H4(63),RedSet_5(31),mass5set(:,7),  & 
G1H4(223),G1H4(224),G1H4(225),G1H4(226),G1H4(227),G1H4(228),4)
  call HG1shiftOLR(G1H4(224),16,4)
  call Hotf_5pt_reduction(G2H4(66),RedSet_5(66),mass5set(:,5),  & 
G1H4(229),G1H4(230),G1H4(231),G1H4(232),G1H4(233),G1H4(234),4)
  call HG1shiftOLR(G1H4(230),16,4)
  call Hotf_5pt_reduction(G2H6(41),RedSet_5(32),mass5set(:,8),  & 
G1H6(133),G1H6(134),G1H6(135),G1H6(136),G1H6(137),G1H6(138),6)
  call HG1shiftOLR(G1H6(134),16,6)
  call Hotf_5pt_reduction(G2H6(44),RedSet_5(48),mass5set(:,8),  & 
G1H6(139),G1H6(140),G1H6(141),G1H6(142),G1H6(143),G1H6(144),6)
  call HG1shiftOLR(G1H6(140),16,6)
  call Hotf_5pt_reduction(G2H6(45),RedSet_5(33),mass5set(:,9),  & 
G1H6(145),G1H6(146),G1H6(147),G1H6(148),G1H6(149),G1H6(150),6)
  call HG1shiftOLR(G1H6(146),4,6)
  call Hotf_5pt_reduction(G2H6(47),RedSet_5(76),mass5set(:,8),  & 
G1H6(151),G1H6(152),G1H6(153),G1H6(154),G1H6(155),G1H6(156),6)
  call HG1shiftOLR(G1H6(152),4,6)
  call Hotf_5pt_reduction(G2H4(68),RedSet_5(34),mass5set(:,7),  & 
G1H4(235),G1H4(236),G1H4(237),G1H4(238),G1H4(239),G1H4(240),4)
  call HG1shiftOLR(G1H4(236),8,4)
  call Hotf_5pt_reduction(G2H4(71),RedSet_5(67),mass5set(:,5),  & 
G1H4(241),G1H4(242),G1H4(243),G1H4(244),G1H4(245),G1H4(246),4)
  call HG1shiftOLR(G1H4(242),8,4)
  call Hotf_5pt_reduction(G2H6(48),RedSet_5(35),mass5set(:,9),  & 
G1H6(157),G1H6(158),G1H6(159),G1H6(160),G1H6(161),G1H6(162),6)
  call HG1shiftOLR(G1H6(158),4,6)
  call Hotf_5pt_reduction(G2H6(50),RedSet_5(77),mass5set(:,8),  & 
G1H6(163),G1H6(164),G1H6(165),G1H6(166),G1H6(167),G1H6(168),6)
  call HG1shiftOLR(G1H6(164),4,6)
  call Hotf_5pt_reduction(G2H6(51),RedSet_5(36),mass5set(:,8),  & 
G1H6(169),G1H6(170),G1H6(171),G1H6(172),G1H6(173),G1H6(174),6)
  call HG1shiftOLR(G1H6(170),8,6)
  call Hotf_5pt_reduction(G2H6(54),RedSet_5(44),mass5set(:,8),  & 
G1H6(175),G1H6(176),G1H6(177),G1H6(178),G1H6(179),G1H6(180),6)
  call HG1shiftOLR(G1H6(176),8,6)
  call Hotf_5pt_reduction(G2H4(73),RedSet_5(37),mass5set(:,7),  & 
G1H4(247),G1H4(248),G1H4(249),G1H4(250),G1H4(251),G1H4(252),4)
  call HG1shiftOLR(G1H4(248),16,4)
  call Hotf_5pt_reduction(G2H4(76),RedSet_5(70),mass5set(:,5),  & 
G1H4(253),G1H4(254),G1H4(255),G1H4(256),G1H4(257),G1H4(258),4)
  call HG1shiftOLR(G1H4(254),16,4)
  call Hotf_5pt_reduction(G2H4(77),RedSet_5(38),mass5set(:,7),  & 
G1H4(259),G1H4(260),G1H4(261),G1H4(262),G1H4(263),G1H4(264),4)
  call HG1shiftOLR(G1H4(260),8,4)
  call Hotf_5pt_reduction(G2H4(80),RedSet_5(72),mass5set(:,5),  & 
G1H4(265),G1H4(266),G1H4(267),G1H4(268),G1H4(269),G1H4(270),4)
  call HG1shiftOLR(G1H4(266),8,4)
  call Hotf_5pt_reduction(G2H6(55),RedSet_5(32),mass5set(:,8),  & 
G1H6(181),G1H6(182),G1H6(183),G1H6(184),G1H6(185),G1H6(186),6)
  call HG1shiftOLR(G1H6(182),4,6)
  call Hotf_5pt_reduction(G2H6(57),RedSet_5(77),mass5set(:,8),  & 
G1H6(187),G1H6(188),G1H6(189),G1H6(190),G1H6(191),G1H6(192),6)
  call HG1shiftOLR(G1H6(188),4,6)
  call Hotf_5pt_reduction(G2H6(58),RedSet_5(36),mass5set(:,8),  & 
G1H6(193),G1H6(194),G1H6(195),G1H6(196),G1H6(197),G1H6(198),6)
  call HG1shiftOLR(G1H6(194),4,6)
  call Hotf_5pt_reduction(G2H6(60),RedSet_5(76),mass5set(:,8),  & 
G1H6(199),G1H6(200),G1H6(201),G1H6(202),G1H6(203),G1H6(204),6)
  call HG1shiftOLR(G1H6(200),4,6)
  call Hotf_5pt_reduction(G2H6(61),RedSet_5(39),mass5set(:,8),  & 
G1H6(205),G1H6(206),G1H6(207),G1H6(208),G1H6(209),G1H6(210),6)
  call HG1shiftOLR(G1H6(206),16,6)
  call Hotf_5pt_reduction(G2H6(64),RedSet_5(58),mass5set(:,8),  & 
G1H6(211),G1H6(212),G1H6(213),G1H6(214),G1H6(215),G1H6(216),6)
  call HG1shiftOLR(G1H6(212),16,6)
  call Hotf_5pt_reduction(G2H6(65),RedSet_5(18),mass5set(:,9),  & 
G1H6(217),G1H6(218),G1H6(219),G1H6(220),G1H6(221),G1H6(222),6)
  call HG1shiftOLR(G1H6(218),4,6)
  call Hotf_5pt_reduction(G2H6(67),RedSet_5(78),mass5set(:,8),  & 
G1H6(223),G1H6(224),G1H6(225),G1H6(226),G1H6(227),G1H6(228),6)
  call HG1shiftOLR(G1H6(224),4,6)
  call Hotf_5pt_reduction(G2H6(68),RedSet_5(39),mass5set(:,8),  & 
G1H6(229),G1H6(230),G1H6(231),G1H6(232),G1H6(233),G1H6(234),6)
  call HG1shiftOLR(G1H6(230),4,6)
  call Hotf_5pt_reduction(G2H6(70),RedSet_5(78),mass5set(:,8),  & 
G1H6(235),G1H6(236),G1H6(237),G1H6(238),G1H6(239),G1H6(240),6)
  call HG1shiftOLR(G1H6(236),4,6)
  call Hotf_5pt_reduction(G2H6(71),RedSet_5(20),mass5set(:,9),  & 
G1H6(241),G1H6(242),G1H6(243),G1H6(244),G1H6(245),G1H6(246),6)
  call HG1shiftOLR(G1H6(242),4,6)
  call Hotf_5pt_reduction(G2H6(73),RedSet_5(79),mass5set(:,8),  & 
G1H6(247),G1H6(248),G1H6(249),G1H6(250),G1H6(251),G1H6(252),6)
  call HG1shiftOLR(G1H6(248),4,6)
  call Hotf_5pt_reduction(G2H6(74),RedSet_5(40),mass5set(:,8),  & 
G1H6(253),G1H6(254),G1H6(255),G1H6(256),G1H6(257),G1H6(258),6)
  call HG1shiftOLR(G1H6(254),8,6)
  call Hotf_5pt_reduction(G2H6(77),RedSet_5(61),mass5set(:,8),  & 
G1H6(259),G1H6(260),G1H6(261),G1H6(262),G1H6(263),G1H6(264),6)
  call HG1shiftOLR(G1H6(260),8,6)
  call Hotf_5pt_reduction(G2H6(78),RedSet_5(40),mass5set(:,8),  & 
G1H6(265),G1H6(266),G1H6(267),G1H6(268),G1H6(269),G1H6(270),6)
  call HG1shiftOLR(G1H6(266),4,6)
  call Hotf_5pt_reduction(G2H6(80),RedSet_5(79),mass5set(:,8),  & 
G1H6(271),G1H6(272),G1H6(273),G1H6(274),G1H6(275),G1H6(276),6)
  call HG1shiftOLR(G1H6(272),4,6)
  call Hloop_QA_V(ntryL,G2H4(87),ex2(:),G2H2(1),m3h2x2(:,1),heltab2x4(:,:,1))
  call Hloop_QA_V(ntryL,G2H4(89),ex2(:),G2H2(2),m3h2x2(:,2),heltab2x4(:,:,2))
  call Hloop_QA_V(ntryL,G2H4(93),ex2(:),G2H2(3),m3h2x2(:,3),heltab2x4(:,:,3))
  call Hloop_AQ_V(ntryL,G2H4(94),ex1(:),G2H2(4),m3h2x2(:,4),heltab2x4(:,:,4))
  call Hloop_AQ_V(ntryL,G2H4(96),ex1(:),G2H2(5),m3h2x2(:,5),heltab2x4(:,:,5))
  call Hloop_AQ_V(ntryL,G2H4(100),ex1(:),G2H2(6),m3h2x2(:,6),heltab2x4(:,:,6))
  call Hloop_AQ_V(ntryL,G2H4(101),ex1(:),G2H2(7),m3h2x2(:,7),heltab2x4(:,:,7))
  call Hloop_AQ_V(ntryL,G2H4(103),ex1(:),G2H2(8),m3h2x2(:,8),heltab2x4(:,:,8))
  call Hloop_AQ_V(ntryL,G2H4(107),ex1(:),G2H2(9),m3h2x2(:,9),heltab2x4(:,:,9))
  call Hloop_AQ_V(ntryL,G2H4(108),ex1(:),G2H2(10),m3h2x2(:,10),heltab2x4(:,:,10))
  call Hloop_AQ_V(ntryL,G2H4(110),ex1(:),G2H2(11),m3h2x2(:,11),heltab2x4(:,:,11))
  call Hloop_AQ_V(ntryL,G2H4(114),ex1(:),G2H2(12),m3h2x2(:,12),heltab2x4(:,:,12))
  call Hloop_QA_V(ntryL,G2H4(115),ex2(:),G2H2(13),m3h2x2(:,13),heltab2x4(:,:,13))
  call Hloop_QA_V(ntryL,G2H4(118),ex2(:),G2H2(14),m3h2x2(:,14),heltab2x4(:,:,14))
  call Hloop_QA_V(ntryL,G2H4(124),ex2(:),G2H2(15),m3h2x2(:,15),heltab2x4(:,:,15))
  call Hloop_QA_V(ntryL,G2H4(125),ex2(:),G2H2(16),m3h2x2(:,16),heltab2x4(:,:,16))
  call Hloop_QA_V(ntryL,G2H4(128),ex2(:),G2H2(17),m3h2x2(:,17),heltab2x4(:,:,17))
  call Hloop_QA_V(ntryL,G2H4(134),ex2(:),G2H2(18),m3h2x2(:,18),heltab2x4(:,:,18))
  call Hotf_5pt_reduction(G2H4(135),RedSet_5(14),mass5set(:,4),  & 
G1H4(271),G1H4(272),G1H4(273),G1H4(274),G1H4(275),G1H4(276),4)
  call HG1shiftOLR(G1H4(272),2,4)
  call Hotf_5pt_reduction(G2H4(137),RedSet_5(54),mass5set(:,4),  & 
G1H4(277),G1H4(278),G1H4(279),G1H4(280),G1H4(281),G1H4(282),4)
  call HG1shiftOLR(G1H4(278),2,4)
  call Hotf_4pt_reduction(G2H4(141),RedSet_4(1),mass4set(:,1),  & 
G1H4(283),G1H4(284),G1H4(285),G1H4(286),G1H4(287),4)
  call HG1shiftOLR(G1H4(284),26,4)
  call Hotf_5pt_reduction(G2H4(142),RedSet_5(13),mass5set(:,4),  & 
G1H4(288),G1H4(289),G1H4(290),G1H4(291),G1H4(292),G1H4(293),4)
  call HG1shiftOLR(G1H4(289),2,4)
  call Hotf_5pt_reduction(G2H4(144),RedSet_5(54),mass5set(:,4),  & 
G1H4(294),G1H4(295),G1H4(296),G1H4(297),G1H4(298),G1H4(299),4)
  call HG1shiftOLR(G1H4(295),2,4)
  call Hotf_4pt_reduction(G2H4(148),RedSet_4(1),mass4set(:,1),  & 
G1H4(300),G1H4(301),G1H4(302),G1H4(303),G1H4(304),4)
  call HG1shiftOLR(G1H4(301),26,4)
  call Hloop_AQ_V(ntryL,G2H4(149),ex1(:),G2H2(19),m3h2x2(:,19),heltab2x4(:,:,19))
  call Hloop_AQ_V(ntryL,G2H4(152),ex1(:),G2H2(20),m3h2x2(:,20),heltab2x4(:,:,20))
  call Hloop_AQ_V(ntryL,G2H4(158),ex1(:),G2H2(21),m3h2x2(:,21),heltab2x4(:,:,21))
  call Hloop_AQ_V(ntryL,G2H4(159),ex1(:),G2H2(22),m3h2x2(:,22),heltab2x4(:,:,22))
  call Hloop_AQ_V(ntryL,G2H4(162),ex1(:),G2H2(23),m3h2x2(:,23),heltab2x4(:,:,23))
  call Hloop_AQ_V(ntryL,G2H4(168),ex1(:),G2H2(24),m3h2x2(:,24),heltab2x4(:,:,24))
  call Hloop_QA_V(ntryL,G2H4(169),ex2(:),G2H2(25),m3h2x2(:,25),heltab2x4(:,:,25))
  call Hloop_QA_V(ntryL,G2H4(171),ex2(:),G2H2(26),m3h2x2(:,26),heltab2x4(:,:,26))
  call Hloop_QA_V(ntryL,G2H4(175),ex2(:),G2H2(27),m3h2x2(:,27),heltab2x4(:,:,27))
  call Hotf_5pt_reduction(G2H6(96),RedSet_5(18),mass5set(:,4),  & 
G1H6(277),G1H6(278),G1H6(279),G1H6(280),G1H6(281),G1H6(282),6)
  call HG1shiftOLR(G1H6(278),2,6)
  call Hotf_5pt_reduction(G2H6(98),RedSet_5(60),mass5set(:,4),  & 
G1H6(283),G1H6(284),G1H6(285),G1H6(286),G1H6(287),G1H6(288),6)
  call HG1shiftOLR(G1H6(284),2,6)
  call Hotf_4pt_reduction(G2H6(102),RedSet_4(2),mass4set(:,1),  & 
G1H6(289),G1H6(290),G1H6(291),G1H6(292),G1H6(293),6)
  call HG1shiftOLR(G1H6(290),22,6)
  call Hotf_5pt_reduction(G2H4(176),RedSet_5(17),mass5set(:,4),  & 
G1H4(305),G1H4(306),G1H4(307),G1H4(308),G1H4(309),G1H4(310),4)
  call HG1shiftOLR(G1H4(306),2,4)
  call Hotf_5pt_reduction(G2H4(178),RedSet_5(60),mass5set(:,4),  & 
G1H4(311),G1H4(312),G1H4(313),G1H4(314),G1H4(315),G1H4(316),4)
  call HG1shiftOLR(G1H4(312),2,4)
  call Hotf_4pt_reduction(G2H4(182),RedSet_4(2),mass4set(:,1),  & 
G1H4(317),G1H4(318),G1H4(319),G1H4(320),G1H4(321),4)
  call HG1shiftOLR(G1H4(318),22,4)
  call Hloop_QA_V(ntryL,G2H4(183),ex2(:),G2H2(28),m3h2x2(:,28),heltab2x4(:,:,28))
  call Hloop_QA_V(ntryL,G2H4(185),ex2(:),G2H2(29),m3h2x2(:,29),heltab2x4(:,:,29))
  call Hloop_QA_V(ntryL,G2H4(189),ex2(:),G2H2(30),m3h2x2(:,30),heltab2x4(:,:,30))
  call Hotf_5pt_reduction(G2H6(106),RedSet_5(20),mass5set(:,4),  & 
G1H6(294),G1H6(295),G1H6(296),G1H6(297),G1H6(298),G1H6(299),6)
  call HG1shiftOLR(G1H6(295),2,6)
  call Hotf_5pt_reduction(G2H6(108),RedSet_5(62),mass5set(:,4),  & 
G1H6(300),G1H6(301),G1H6(302),G1H6(303),G1H6(304),G1H6(305),6)
  call HG1shiftOLR(G1H6(301),2,6)
  call Hotf_4pt_reduction(G2H6(112),RedSet_4(3),mass4set(:,1),  & 
G1H6(306),G1H6(307),G1H6(308),G1H6(309),G1H6(310),6)
  call HG1shiftOLR(G1H6(307),14,6)
  call Hotf_5pt_reduction(G2H4(190),RedSet_5(19),mass5set(:,4),  & 
G1H4(322),G1H4(323),G1H4(324),G1H4(325),G1H4(326),G1H4(327),4)
  call HG1shiftOLR(G1H4(323),2,4)
  call Hotf_5pt_reduction(G2H4(192),RedSet_5(62),mass5set(:,4),  & 
G1H4(328),G1H4(329),G1H4(330),G1H4(331),G1H4(332),G1H4(333),4)
  call HG1shiftOLR(G1H4(329),2,4)
  call Hotf_4pt_reduction(G2H4(196),RedSet_4(3),mass4set(:,1),  & 
G1H4(334),G1H4(335),G1H4(336),G1H4(337),G1H4(338),4)
  call HG1shiftOLR(G1H4(335),14,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(13),[G1H4(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(25),[G1H4(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(37),[G1H4(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(49),[G1H4(48)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(61),[G1H4(60)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(73),[G1H4(72)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(85),[G1H4(84)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(97),[G1H4(96)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(109),[G1H4(108)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(121),[G1H4(120)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(19),[G1H6(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(133),[G1H4(132)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(145),[G1H4(144)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(157),[G1H4(156)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(169),[G1H4(168)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(31),[G1H6(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(181),[G1H4(180)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(43),[G1H6(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(55),[G1H6(54)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(193),[G1H4(192)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(67),[G1H6(66)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(79),[G1H6(78)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(205),[G1H4(204)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(217),[G1H4(216)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(91),[G1H6(90)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(103),[G1H6(102)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(115),[G1H6(114)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(127),[G1H6(126)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(229),[G1H4(228)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(139),[G1H6(138)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(151),[G1H6(150)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(241),[G1H4(240)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(163),[G1H6(162)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(175),[G1H6(174)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(253),[G1H4(252)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(265),[G1H4(264)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(187),[G1H6(186)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(199),[G1H6(198)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(211),[G1H6(210)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(223),[G1H6(222)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(235),[G1H6(234)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(247),[G1H6(246)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(259),[G1H6(258)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(271),[G1H6(270)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(277),[G1H4(276)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(283),[G1H4(282)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(294),[G1H4(293)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(300),[G1H4(299)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(283),[G1H6(282)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(289),[G1H6(288)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(311),[G1H4(310)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(317),[G1H4(316)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(300),[G1H6(299)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(306),[G1H6(305)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(328),[G1H4(327)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(334),[G1H4(333)])
  call Hloop_VA_Q(ntryL,G1H4(7),ex2(:),G1H2(1),m3h2x2(:,31),heltab2x4(:,:,31))
  call Hloop_A_Q(ntryL,G1H2(1),47,nMT,G2H2(31),n2h2(1))
call HGT_OLR(G1H4(8),1,1,4)
call HGT_invQ_OLR(G1H4(8),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(8),-16,nMT,G2H4(1),n2h4(123))
  call Hloop_QV_A(ntryL,G2H4(1),ex5(:),G2H2(32),m3h2x2(:,32),heltab2x4(:,:,32))
  call Hloop_VA_Q(ntryL,G1H4(13),ex2(:),G1H2(1),m3h2x2(:,33),heltab2x4(:,:,33))
  call Hloop_A_Q(ntryL,G1H2(1),47,nMT,G2H2(33),n2h2(2))
call HGT_OLR(G1H4(14),1,1,4)
call HGT_invQ_OLR(G1H4(14),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(14),-16,nMT,G2H4(3),n2h4(124))
  call Hloop_QV_A(ntryL,G2H4(3),ex5(:),G2H2(34),m3h2x2(:,34),heltab2x4(:,:,34))
  call Hloop_VA_Q(ntryL,G1H4(18),ex2(:),G1H2(1),m3h2x2(:,35),heltab2x4(:,:,35))
  call Hloop_A_Q(ntryL,G1H2(1),47,nMT,G2H2(35),n2h2(3))
  call Hloop_VA_Q(ntryL,G1H4(19),ex2(:),G1H2(1),m3h2x2(:,36),heltab2x4(:,:,36))
  call Hloop_A_Q(ntryL,G1H2(1),47,nMT,G2H2(36),n2h2(4))
call HGT_OLR(G1H4(20),1,1,4)
call HGT_invQ_OLR(G1H4(20),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(20),-16,nMT,G2H4(4),n2h4(125))
  call Hloop_QV_A(ntryL,G2H4(4),ex5(:),G2H2(37),m3h2x2(:,37),heltab2x4(:,:,37))
  call Hloop_VA_Q(ntryL,G1H4(25),ex2(:),G1H2(1),m3h2x2(:,38),heltab2x4(:,:,38))
  call Hloop_A_Q(ntryL,G1H2(1),47,nMT,G2H2(38),n2h2(5))
call HGT_OLR(G1H4(26),1,1,4)
call HGT_invQ_OLR(G1H4(26),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(26),-16,nMT,G2H4(6),n2h4(126))
  call Hloop_QV_A(ntryL,G2H4(6),ex5(:),G2H2(39),m3h2x2(:,39),heltab2x4(:,:,39))
  call Hloop_VA_Q(ntryL,G1H4(30),ex2(:),G1H2(1),m3h2x2(:,40),heltab2x4(:,:,40))
  call Hloop_A_Q(ntryL,G1H2(1),47,nMT,G2H2(40),n2h2(6))
  call Hloop_VQ_A(ntryL,G1H4(31),ex1(:),G1H2(1),m3h2x2(:,41),heltab2x4(:,:,41))
  call Hloop_Q_A(ntryL,G1H2(1),55,nMT,G2H2(41),n2h2(7))
call HGT_OLR(G1H4(32),1,1,4)
call HGT_invQ_OLR(G1H4(32),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(32),-8,nMT,G2H4(7),n2h4(127))
  call Hloop_AV_Q(ntryL,G2H4(7),ex4(:),G2H2(42),m3h2x2(:,42),heltab2x4(:,:,42))
  call Hloop_VQ_A(ntryL,G1H4(37),ex1(:),G1H2(1),m3h2x2(:,43),heltab2x4(:,:,43))
  call Hloop_Q_A(ntryL,G1H2(1),55,nMT,G2H2(43),n2h2(8))
call HGT_OLR(G1H4(38),1,1,4)
call HGT_invQ_OLR(G1H4(38),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(38),-8,nMT,G2H4(9),n2h4(128))
  call Hloop_AV_Q(ntryL,G2H4(9),ex4(:),G2H2(44),m3h2x2(:,44),heltab2x4(:,:,44))
  call Hloop_VQ_A(ntryL,G1H4(42),ex1(:),G1H2(1),m3h2x2(:,45),heltab2x4(:,:,45))
  call Hloop_Q_A(ntryL,G1H2(1),55,nMT,G2H2(45),n2h2(9))
  call Hloop_VQ_A(ntryL,G1H4(43),ex1(:),G1H2(1),m3h2x2(:,46),heltab2x4(:,:,46))
  call Hloop_Q_A(ntryL,G1H2(1),47,nMT,G2H2(46),n2h2(10))
call HGT_OLR(G1H4(44),1,1,4)
call HGT_invQ_OLR(G1H4(44),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(44),-16,nMT,G2H4(10),n2h4(129))
  call Hloop_AV_Q(ntryL,G2H4(10),ex5(:),G2H2(47),m3h2x2(:,47),heltab2x4(:,:,47))
  call Hloop_VQ_A(ntryL,G1H4(49),ex1(:),G1H2(1),m3h2x2(:,48),heltab2x4(:,:,48))
  call Hloop_Q_A(ntryL,G1H2(1),47,nMT,G2H2(48),n2h2(11))
call HGT_OLR(G1H4(50),1,1,4)
call HGT_invQ_OLR(G1H4(50),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(50),-16,nMT,G2H4(12),n2h4(130))
  call Hloop_AV_Q(ntryL,G2H4(12),ex5(:),G2H2(49),m3h2x2(:,49),heltab2x4(:,:,49))
  call Hloop_VQ_A(ntryL,G1H4(54),ex1(:),G1H2(1),m3h2x2(:,50),heltab2x4(:,:,50))
  call Hloop_Q_A(ntryL,G1H2(1),47,nMT,G2H2(50),n2h2(12))
  call Hloop_VQ_A(ntryL,G1H4(55),ex1(:),G1H2(1),m3h2x2(:,51),heltab2x4(:,:,51))
  call Hloop_Q_A(ntryL,G1H2(1),47,nMT,G2H2(51),n2h2(13))
call HGT_OLR(G1H4(56),1,1,4)
call HGT_invQ_OLR(G1H4(56),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(56),-16,nMT,G2H4(13),n2h4(131))
  call Hloop_AV_Q(ntryL,G2H4(13),ex5(:),G2H2(52),m3h2x2(:,52),heltab2x4(:,:,52))
  call Hloop_VQ_A(ntryL,G1H4(61),ex1(:),G1H2(1),m3h2x2(:,53),heltab2x4(:,:,53))
  call Hloop_Q_A(ntryL,G1H2(1),47,nMT,G2H2(53),n2h2(14))
call HGT_OLR(G1H4(62),1,1,4)
call HGT_invQ_OLR(G1H4(62),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(62),-16,nMT,G2H4(15),n2h4(132))
  call Hloop_AV_Q(ntryL,G2H4(15),ex5(:),G2H2(54),m3h2x2(:,54),heltab2x4(:,:,54))
  call Hloop_VQ_A(ntryL,G1H4(66),ex1(:),G1H2(1),m3h2x2(:,55),heltab2x4(:,:,55))
  call Hloop_Q_A(ntryL,G1H2(1),47,nMT,G2H2(55),n2h2(15))
  call Hloop_VA_Q(ntryL,G1H4(67),ex2(:),G1H2(1),m3h2x2(:,56),heltab2x4(:,:,56))
  call Hloop_A_Q(ntryL,G1H2(1),55,nMT,G2H2(56),n2h2(16))
call HGT_OLR(G1H4(68),1,1,4)
call HGT_invQ_OLR(G1H4(68),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(68),-8,nMT,G2H4(16),n2h4(133))
  call Hloop_QV_A(ntryL,G2H4(16),ex4(:),G2H2(57),m3h2x2(:,57),heltab2x4(:,:,57))
  call Hloop_VA_Q(ntryL,G1H4(73),ex2(:),G1H2(1),m3h2x2(:,58),heltab2x4(:,:,58))
  call Hloop_A_Q(ntryL,G1H2(1),55,nMT,G2H2(58),n2h2(17))
call HGT_OLR(G1H4(74),1,1,4)
call HGT_invQ_OLR(G1H4(74),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(74),-8,nMT,G2H4(18),n2h4(134))
  call Hloop_QV_A(ntryL,G2H4(18),ex4(:),G2H2(59),m3h2x2(:,59),heltab2x4(:,:,59))
  call Hloop_VA_Q(ntryL,G1H4(78),ex2(:),G1H2(1),m3h2x2(:,60),heltab2x4(:,:,60))
  call Hloop_A_Q(ntryL,G1H2(1),55,nMT,G2H2(60),n2h2(18))
  call Hloop_UV_W(ntryL,G1H4(79),39,ex4(:),8,G2H2(61),m3h2x2(:,61),heltab2x4(:,:,61))
call HGT_raise_alpha_OLR(G1H4(80),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(80),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(80),-16,ex5(:),16,G2H2(62),m3h2x2(:,62),heltab2x4(:,:,62))
call signflip_OLR(G2H2(62))
  call Hloop_UV_W(ntryL,G1H4(85),39,ex4(:),8,G2H2(63),m3h2x2(:,63),heltab2x4(:,:,63))
call HGT_raise_alpha_OLR(G1H4(86),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(86),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(86),-16,ex5(:),16,G2H2(64),m3h2x2(:,64),heltab2x4(:,:,64))
call signflip_OLR(G2H2(64))
  call Hloop_UV_W(ntryL,G1H4(90),39,ex4(:),8,G2H2(65),m3h2x2(:,65),heltab2x4(:,:,65))
  call Hloop_UV_W(ntryL,G1H4(91),39,ex5(:),16,G2H2(66),m3h2x2(:,66),heltab2x4(:,:,66))
call HGT_raise_alpha_OLR(G1H4(92),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(92),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(92),-8,ex4(:),8,G2H2(67),m3h2x2(:,67),heltab2x4(:,:,67))
call signflip_OLR(G2H2(67))
  call Hloop_UV_W(ntryL,G1H4(97),39,ex5(:),16,G2H2(68),m3h2x2(:,68),heltab2x4(:,:,68))
call HGT_raise_alpha_OLR(G1H4(98),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(98),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(98),-8,ex4(:),8,G2H2(69),m3h2x2(:,69),heltab2x4(:,:,69))
call signflip_OLR(G2H2(69))
  call Hloop_UV_W(ntryL,G1H4(102),39,ex5(:),16,G2H2(70),m3h2x2(:,70),heltab2x4(:,:,70))
  call Hloop_UV_W(ntryL,G1H4(103),39,ex4(:),8,G2H2(71),m3h2x2(:,71),heltab2x4(:,:,71))
call HGT_raise_alpha_OLR(G1H4(104),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(104),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(104),-16,ex5(:),16,G2H2(72),m3h2x2(:,72),heltab2x4(:,:,72))
call signflip_OLR(G2H2(72))
  call Hloop_UV_W(ntryL,G1H4(109),39,ex4(:),8,G2H2(73),m3h2x2(:,73),heltab2x4(:,:,73))
call HGT_raise_alpha_OLR(G1H4(110),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(110),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(110),-16,ex5(:),16,G2H2(74),m3h2x2(:,74),heltab2x4(:,:,74))
call signflip_OLR(G2H2(74))
  call Hloop_UV_W(ntryL,G1H4(114),39,ex4(:),8,G2H2(75),m3h2x2(:,75),heltab2x4(:,:,75))
  call Hloop_UV_W(ntryL,G1H4(115),39,ex5(:),16,G2H2(76),m3h2x2(:,76),heltab2x4(:,:,76))
call HGT_raise_alpha_OLR(G1H4(116),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(116),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(116),-8,ex4(:),8,G2H2(77),m3h2x2(:,77),heltab2x4(:,:,77))
call signflip_OLR(G2H2(77))
  call Hloop_UV_W(ntryL,G1H4(121),39,ex5(:),16,G2H2(78),m3h2x2(:,78),heltab2x4(:,:,78))
call HGT_raise_alpha_OLR(G1H4(122),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(122),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(122),-8,ex4(:),8,G2H2(79),m3h2x2(:,79),heltab2x4(:,:,79))
call signflip_OLR(G2H2(79))
  call Hloop_UV_W(ntryL,G1H4(126),39,ex5(:),16,G2H2(80),m3h2x2(:,80),heltab2x4(:,:,80))
  call Hloop_QZ_A(ntryL,G1H6(13),ex3(:),G1H2(1),ngZu,m3h3x2(:,1),heltab2x6(:,:,1))
  call Hloop_Q_A(ntryL,G1H2(1),47,nMT,G2H2(81),n2h2(19))
call HGT_OLR(G1H6(14),1,1,6)
call HGT_invQ_OLR(G1H6(14),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(14),-16,nMT,G2H6(1),n2h6(69))
  call Hloop_AV_Q(ntryL,G2H6(1),ex5(:),G2H3(1),m3h2x3(:,1),heltab2x6(:,:,2))
  call Hloop_QZ_A(ntryL,G1H6(19),ex3(:),G1H2(1),ngZu,m3h3x2(:,2),heltab2x6(:,:,3))
  call Hloop_Q_A(ntryL,G1H2(1),47,nMT,G2H2(82),n2h2(20))
call HGT_OLR(G1H6(20),1,1,6)
call HGT_invQ_OLR(G1H6(20),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(20),-16,nMT,G2H6(4),n2h6(70))
  call Hloop_AV_Q(ntryL,G2H6(4),ex5(:),G2H3(2),m3h2x3(:,2),heltab2x6(:,:,4))
  call Hloop_QZ_A(ntryL,G1H6(24),ex3(:),G1H2(1),ngZu,m3h3x2(:,3),heltab2x6(:,:,5))
  call Hloop_Q_A(ntryL,G1H2(1),47,nMT,G2H2(83),n2h2(21))
  call Hloop_AV_Q(ntryL,G1H4(127),ex4(:),G1H2(1),m3h2x2(:,81),heltab2x4(:,:,81))
  call Hloop_A_Q(ntryL,G1H2(1),47,nMT,G2H2(84),n2h2(22))
call HGT_OLR(G1H4(128),1,1,4)
call HGT_invQ_OLR(G1H4(128),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(128),-16,nMT,G2H4(19),n2h4(143))
  call Hloop_QV_A(ntryL,G2H4(19),ex5(:),G2H2(85),m3h2x2(:,82),heltab2x4(:,:,82))
  call Hloop_AV_Q(ntryL,G1H4(133),ex4(:),G1H2(1),m3h2x2(:,83),heltab2x4(:,:,83))
  call Hloop_A_Q(ntryL,G1H2(1),47,nMT,G2H2(86),n2h2(23))
call HGT_OLR(G1H4(134),1,1,4)
call HGT_invQ_OLR(G1H4(134),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(134),-16,nMT,G2H4(21),n2h4(144))
  call Hloop_QV_A(ntryL,G2H4(21),ex5(:),G2H2(87),m3h2x2(:,84),heltab2x4(:,:,84))
  call Hloop_AV_Q(ntryL,G1H4(138),ex4(:),G1H2(1),m3h2x2(:,85),heltab2x4(:,:,85))
  call Hloop_A_Q(ntryL,G1H2(1),47,nMT,G2H2(88),n2h2(24))
  call Hloop_AV_Q(ntryL,G1H4(139),ex5(:),G1H2(1),m3h2x2(:,86),heltab2x4(:,:,86))
  call Hloop_A_Q(ntryL,G1H2(1),55,nMT,G2H2(89),n2h2(25))
call HGT_OLR(G1H4(140),1,1,4)
call HGT_invQ_OLR(G1H4(140),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(140),-8,nMT,G2H4(22),n2h4(145))
  call Hloop_QV_A(ntryL,G2H4(22),ex4(:),G2H2(90),m3h2x2(:,87),heltab2x4(:,:,87))
  call Hloop_AV_Q(ntryL,G1H4(145),ex5(:),G1H2(1),m3h2x2(:,88),heltab2x4(:,:,88))
  call Hloop_A_Q(ntryL,G1H2(1),55,nMT,G2H2(91),n2h2(26))
call HGT_OLR(G1H4(146),1,1,4)
call HGT_invQ_OLR(G1H4(146),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(146),-8,nMT,G2H4(24),n2h4(146))
  call Hloop_QV_A(ntryL,G2H4(24),ex4(:),G2H2(92),m3h2x2(:,89),heltab2x4(:,:,89))
  call Hloop_AV_Q(ntryL,G1H4(150),ex5(:),G1H2(1),m3h2x2(:,90),heltab2x4(:,:,90))
  call Hloop_A_Q(ntryL,G1H2(1),55,nMT,G2H2(93),n2h2(27))
  call Hloop_QV_A(ntryL,G1H4(151),ex4(:),G1H2(1),m3h2x2(:,91),heltab2x4(:,:,91))
  call Hloop_Q_A(ntryL,G1H2(1),47,nMT,G2H2(94),n2h2(28))
call HGT_OLR(G1H4(152),1,1,4)
call HGT_invQ_OLR(G1H4(152),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(152),-16,nMT,G2H4(25),n2h4(147))
  call Hloop_AV_Q(ntryL,G2H4(25),ex5(:),G2H2(95),m3h2x2(:,92),heltab2x4(:,:,92))
  call Hloop_QV_A(ntryL,G1H4(157),ex4(:),G1H2(1),m3h2x2(:,93),heltab2x4(:,:,93))
  call Hloop_Q_A(ntryL,G1H2(1),47,nMT,G2H2(96),n2h2(29))
call HGT_OLR(G1H4(158),1,1,4)
call HGT_invQ_OLR(G1H4(158),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(158),-16,nMT,G2H4(27),n2h4(148))
  call Hloop_AV_Q(ntryL,G2H4(27),ex5(:),G2H2(97),m3h2x2(:,94),heltab2x4(:,:,94))
  call Hloop_QV_A(ntryL,G1H4(162),ex4(:),G1H2(1),m3h2x2(:,95),heltab2x4(:,:,95))
  call Hloop_Q_A(ntryL,G1H2(1),47,nMT,G2H2(98),n2h2(30))
  call Hloop_QV_A(ntryL,G1H4(163),ex5(:),G1H2(1),m3h2x2(:,96),heltab2x4(:,:,96))
  call Hloop_Q_A(ntryL,G1H2(1),55,nMT,G2H2(99),n2h2(31))
call HGT_OLR(G1H4(164),1,1,4)
call HGT_invQ_OLR(G1H4(164),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(164),-8,nMT,G2H4(28),n2h4(149))
  call Hloop_AV_Q(ntryL,G2H4(28),ex4(:),G2H2(100),m3h2x2(:,97),heltab2x4(:,:,97))
  call Hloop_QV_A(ntryL,G1H4(169),ex5(:),G1H2(1),m3h2x2(:,98),heltab2x4(:,:,98))
  call Hloop_Q_A(ntryL,G1H2(1),55,nMT,G2H2(101),n2h2(32))
call HGT_OLR(G1H4(170),1,1,4)
call HGT_invQ_OLR(G1H4(170),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(170),-8,nMT,G2H4(30),n2h4(150))
  call Hloop_AV_Q(ntryL,G2H4(30),ex4(:),G2H2(102),m3h2x2(:,99),heltab2x4(:,:,99))
  call Hloop_QV_A(ntryL,G1H4(174),ex5(:),G1H2(1),m3h2x2(:,100),heltab2x4(:,:,100))
  call Hloop_Q_A(ntryL,G1H2(1),55,nMT,G2H2(103),n2h2(33))
  call Hloop_AZ_Q(ntryL,G1H6(25),ex3(:),G1H2(1),ngZu,m3h3x2(:,4),heltab2x6(:,:,6))
  call Hloop_A_Q(ntryL,G1H2(1),47,nMT,G2H2(104),n2h2(34))
call HGT_OLR(G1H6(26),1,1,6)
call HGT_invQ_OLR(G1H6(26),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(26),-16,nMT,G2H6(7),n2h6(71))
  call Hloop_QV_A(ntryL,G2H6(7),ex5(:),G2H3(3),m3h2x3(:,3),heltab2x6(:,:,7))
  call Hloop_AZ_Q(ntryL,G1H6(31),ex3(:),G1H2(1),ngZu,m3h3x2(:,5),heltab2x6(:,:,8))
  call Hloop_A_Q(ntryL,G1H2(1),47,nMT,G2H2(105),n2h2(35))
call HGT_OLR(G1H6(32),1,1,6)
call HGT_invQ_OLR(G1H6(32),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(32),-16,nMT,G2H6(10),n2h6(72))
  call Hloop_QV_A(ntryL,G2H6(10),ex5(:),G2H3(4),m3h2x3(:,4),heltab2x6(:,:,9))
  call Hloop_AZ_Q(ntryL,G1H6(36),ex3(:),G1H2(1),ngZu,m3h3x2(:,6),heltab2x6(:,:,10))
  call Hloop_A_Q(ntryL,G1H2(1),47,nMT,G2H2(106),n2h2(36))
  call Hloop_QV_A(ntryL,G1H4(175),ex4(:),G1H2(1),m3h2x2(:,101),heltab2x4(:,:,101))
  call Hloop_Q_A(ntryL,G1H2(1),47,nMT,G2H2(107),n2h2(37))
call HGT_OLR(G1H4(176),1,1,4)
call HGT_invQ_OLR(G1H4(176),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(176),-16,nMT,G2H4(31),n2h4(151))
  call Hloop_AV_Q(ntryL,G2H4(31),ex5(:),G2H2(108),m3h2x2(:,102),heltab2x4(:,:,102))
  call Hloop_QV_A(ntryL,G1H4(181),ex4(:),G1H2(1),m3h2x2(:,103),heltab2x4(:,:,103))
  call Hloop_Q_A(ntryL,G1H2(1),47,nMT,G2H2(109),n2h2(38))
call HGT_OLR(G1H4(182),1,1,4)
call HGT_invQ_OLR(G1H4(182),2,5,4)



end subroutine vamp_1

end module ol_vamp_1_ppzttj_ttxzggg_1_/**/REALKIND
