
module ol_vamp_1_ppzttj_ttxbbxzg_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppzttj_ttxbbxzg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppzttj_ttxbbxzg_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_ppzttj_ttxbbxzg_1_/**/DREALKIND
  use ol_tensor_sum_storage_ppzttj_ttxbbxzg_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_ppzttj_ttxbbxzg_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_ppzttj_ttxbbxzg_1_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(96)
  type(Hpolcont), intent(in) :: M(4,96)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)+c(11)*(M(2,:)%j+M(3,:)%j)-c(10)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1),h0tab(:,1),[32,8,2,1,4,16],[nMB,0,nMT,0,nMB,nMB],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,1),heltab2x96(:,:,1))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMB,G1H48(1),n2h48(1))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)+c(11)*(M(2,:)%j+M(3,:)%j)-c(10)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2),h0tab(:,2),[32,4,1,2,8,16],[nMB,0,nMT,0,nMB,nMB],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,2),heltab2x96(:,:,2))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMB,G1H48(2),n2h48(2))
  Gcoeff(:)%j = (c(3)*(M(2,:)%j-M(3,:)%j)+c(4)*(-M(1,:)%j+M(4,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(3),h0tab(:,3),[32,2,1,4,16,8],[0,nMT,0,nMB,nMB,0],6,0)
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(3),m3h2x48(:,3),heltab2x96(:,:,3))
  Gcoeff(:)%j = (c(11)*(M(2,:)%j+M(3,:)%j)-c(10)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4),h0tab(:,4),[32,8,1,2,4,16],[nMB,0,nMT,0,nMB,nMB],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,4),heltab2x96(:,:,4))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMB,G1H48(4),n2h48(3))
  Gcoeff(:)%j = (c(11)*(M(2,:)%j+M(3,:)%j)-c(10)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5),h0tab(:,5),[32,4,2,1,8,16],[nMB,0,nMT,0,nMB,nMB],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,5),heltab2x96(:,:,5))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMB,G1H48(5),n2h48(4))
  Gcoeff(:)%j = (-(c(5)*M(2,:)%j)-c(3)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(6),h0tab(:,6),[32,2,1,8,16,4],[0,nMT,0,nMB,nMB,0],6,0)
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(6),m3h2x48(:,6),heltab2x96(:,:,6))
  Gcoeff(:)%j = (c(3)*M(2,:)%j+c(5)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(7),h0tab(:,7),[32,1,2,4,16,8],[0,nMT,0,nMB,nMB,0],6,0)
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(7),m3h2x48(:,7),heltab2x96(:,:,7))
  Gcoeff(:)%j = (c(3)*(M(2,:)%j-M(3,:)%j)+c(4)*(M(1,:)%j-M(4,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(8),h0tab(:,8),[32,1,2,8,16,4],[0,nMT,0,nMB,nMB,0],6,0)
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(8),m3h2x48(:,8),heltab2x96(:,:,8))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)+c(11)*(M(2,:)%j+M(3,:)%j)-c(10)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(9),h0tab(:,9),[32,4,1,16,2,8],[nMB,0,nMT,nMT,0,nMB],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,9),heltab2x96(:,:,9))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMB,G1H48(9),n2h48(5))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)+c(11)*(M(2,:)%j+M(3,:)%j)-c(14)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(10),h0tab(:,10),[32,2,8,4,1,16],[nMT,0,nMB,0,nMT,nMT],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,10),heltab2x96(:,:,10))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(10),n2h48(6))
  Gcoeff(:)%j = (c(3)*(M(2,:)%j-M(3,:)%j)+c(4)*(-M(1,:)%j+M(4,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(11),h0tab(:,11),[32,2,16,1,4,8],[0,nMT,nMT,0,nMB,0],6,0)
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(11),m3h2x48(:,11),heltab2x96(:,:,11))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)+c(11)*(M(2,:)%j+M(3,:)%j)-c(14)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(12),h0tab(:,12),[32,1,4,8,2,16],[nMT,0,nMB,0,nMT,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,12),heltab2x96(:,:,12))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(12),n2h48(7))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)+c(11)*(M(2,:)%j+M(3,:)%j)-c(14)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(13),h0tab(:,13),[32,1,4,16,8,2],[nMT,0,nMB,nMB,0,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,13),heltab2x96(:,:,13))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(13),n2h48(8))
  Gcoeff(:)%j = (c(11)*(M(2,:)%j+M(3,:)%j)-c(10)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(14),h0tab(:,14),[32,4,2,16,1,8],[nMB,0,nMT,nMT,0,nMB],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,14),heltab2x96(:,:,14))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMB,G1H48(14),n2h48(9))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)+c(11)*(M(2,:)%j+M(3,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(15),h0tab(:,15),[32,2,4,8,1,16],[nMT,0,nMB,0,nMT,nMT],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,15),heltab2x96(:,:,15))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(15),n2h48(10))
  Gcoeff(:)%j = (-(c(5)*M(2,:)%j)-c(3)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(16),h0tab(:,16),[32,2,16,1,8,4],[0,nMT,nMT,0,nMB,0],6,0)
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(16),m3h2x48(:,16),heltab2x96(:,:,16))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)+c(11)*(M(2,:)%j+M(3,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(17),h0tab(:,17),[32,1,8,4,2,16],[nMT,0,nMB,0,nMT,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,17),heltab2x96(:,:,17))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(17),n2h48(11))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)+c(11)*(M(2,:)%j+M(3,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(18),h0tab(:,18),[32,1,8,16,4,2],[nMT,0,nMB,nMB,0,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,18),heltab2x96(:,:,18))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(18),n2h48(12))
  Gcoeff(:)%j = (c(3)*M(2,:)%j+c(5)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(19),h0tab(:,19),[32,1,16,2,4,8],[0,nMT,nMT,0,nMB,0],6,0)
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(19),m3h2x48(:,19),heltab2x96(:,:,19))
  Gcoeff(:)%j = (c(3)*(M(2,:)%j-M(3,:)%j)+c(4)*(M(1,:)%j-M(4,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(20),h0tab(:,20),[32,1,16,2,8,4],[0,nMT,nMT,0,nMB,0],6,0)
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(20),m3h2x48(:,20),heltab2x96(:,:,20))
  call Hloop_QA_V(ntryL,G1H48(1),ex4(:),G1H24(1),m3h2x24(:,1),heltab2x48(:,:,1))
  call Hloop_AQ_V(ntryL,G1H48(2),ex3(:),G1H24(2),m3h2x24(:,2),heltab2x48(:,:,2))
  call Hloop_VA_Q(ntryL,G1H48(3),ex2(:),G1H24(3),m3h2x24(:,3),heltab2x48(:,:,3))
  call Hloop_A_Q(ntryL,G1H24(3),34,nMT,G2H24(1),n2h24(1))
  call Hloop_QA_V(ntryL,G1H48(4),ex4(:),G1H24(3),m3h2x24(:,4),heltab2x48(:,:,4))
  call Hloop_AQ_V(ntryL,G1H48(5),ex3(:),G1H24(4),m3h2x24(:,5),heltab2x48(:,:,5))
  call Hloop_VA_Q(ntryL,G1H48(6),ex2(:),G1H24(5),m3h2x24(:,6),heltab2x48(:,:,6))
  call Hloop_A_Q(ntryL,G1H24(5),34,nMT,G2H24(2),n2h24(2))
  call Hloop_VQ_A(ntryL,G1H48(7),ex1(:),G1H24(5),m3h2x24(:,7),heltab2x48(:,:,7))
  call Hloop_Q_A(ntryL,G1H24(5),33,nMT,G2H24(3),n2h24(3))
  call Hloop_VQ_A(ntryL,G1H48(8),ex1(:),G1H24(5),m3h2x24(:,8),heltab2x48(:,:,8))
  call Hloop_Q_A(ntryL,G1H24(5),33,nMT,G2H24(4),n2h24(4))
  call Hloop_AQ_V(ntryL,G1H48(9),ex3(:),G1H24(5),m3h2x24(:,9),heltab2x48(:,:,9))
  call Hloop_QA_V(ntryL,G1H48(10),ex2(:),G1H24(6),m3h2x24(:,10),heltab2x48(:,:,10))
  call Hloop_VA_Q(ntryL,G1H48(11),ex2(:),G1H24(7),m3h2x24(:,11),heltab2x48(:,:,11))
  call Hloop_A_Q(ntryL,G1H24(7),34,nMT,G2H24(5),n2h24(5))
  call Hloop_AQ_V(ntryL,G1H48(12),ex1(:),G1H24(7),m3h2x24(:,12),heltab2x48(:,:,12))
  call Hloop_AQ_V(ntryL,G1H48(13),ex1(:),G1H24(8),m3h2x24(:,13),heltab2x48(:,:,13))
  call Hloop_AQ_V(ntryL,G1H48(14),ex3(:),G1H24(9),m3h2x24(:,14),heltab2x48(:,:,14))
  call Hloop_QA_V(ntryL,G1H48(15),ex2(:),G1H24(10),m3h2x24(:,15),heltab2x48(:,:,15))
  call Hloop_VA_Q(ntryL,G1H48(16),ex2(:),G1H24(11),m3h2x24(:,16),heltab2x48(:,:,16))
  call Hloop_A_Q(ntryL,G1H24(11),34,nMT,G2H24(6),n2h24(6))
  call Hloop_AQ_V(ntryL,G1H48(17),ex1(:),G1H24(11),m3h2x24(:,17),heltab2x48(:,:,17))
  call Hloop_AQ_V(ntryL,G1H48(18),ex1(:),G1H24(12),m3h2x24(:,18),heltab2x48(:,:,18))
  call Hloop_VQ_A(ntryL,G1H48(19),ex1(:),G1H24(13),m3h2x24(:,19),heltab2x48(:,:,19))
  call Hloop_Q_A(ntryL,G1H24(13),33,nMT,G2H24(7),n2h24(7))
  call Hloop_VQ_A(ntryL,G1H48(20),ex1(:),G1H24(13),m3h2x24(:,20),heltab2x48(:,:,20))
  call Hloop_Q_A(ntryL,G1H24(13),33,nMT,G2H24(8),n2h24(8))
  call Hloop_VA_Q(ntryL,G1H24(1),ex2(:),G1H12(1),m3h2x12(:,1),heltab2x24(:,:,1))
  call Hloop_A_Q(ntryL,G1H12(1),42,nMT,G2H12(1),n2h12(1))
  call Hloop_VQ_A(ntryL,G1H24(2),ex1(:),G1H12(1),m3h2x12(:,2),heltab2x24(:,:,2))
  call Hloop_Q_A(ntryL,G1H12(1),37,nMT,G2H12(2),n2h12(2))
  call Hloop_AQ_V(ntryL,G2H24(1),ex1(:),G2H12(3),m3h2x12(:,3),heltab2x24(:,:,3))
  call Hloop_VQ_A(ntryL,G1H24(3),ex1(:),G1H12(1),m3h2x12(:,4),heltab2x24(:,:,4))
  call Hloop_Q_A(ntryL,G1H12(1),41,nMT,G2H12(4),n2h12(3))
  call Hloop_VA_Q(ntryL,G1H24(4),ex2(:),G1H12(1),m3h2x12(:,5),heltab2x24(:,:,5))
  call Hloop_A_Q(ntryL,G1H12(1),38,nMT,G2H12(5),n2h12(4))
  call Hloop_AQ_V(ntryL,G2H24(2),ex1(:),G2H12(6),m3h2x12(:,6),heltab2x24(:,:,6))
  call Hloop_QA_V(ntryL,G2H24(3),ex2(:),G2H12(7),m3h2x12(:,7),heltab2x24(:,:,7))
  call Hloop_QA_V(ntryL,G2H24(4),ex2(:),G2H12(8),m3h2x12(:,8),heltab2x24(:,:,8))
  call Hloop_VQ_A(ntryL,G1H24(5),ex1(:),G1H12(1),m3h2x12(:,9),heltab2x24(:,:,9))
  call Hloop_Q_A(ntryL,G1H12(1),37,nMT,G2H12(9),n2h12(5))
  call Hloop_VA_Q(ntryL,G1H24(6),ex4(:),G1H12(1),m3h2x12(:,10),heltab2x24(:,:,10))
  call Hloop_A_Q(ntryL,G1H12(1),42,nMB,G2H12(10),n2h12(6))
  call Hotf_5pt_reduction(G2H24(5),RedSet_5(1),mass5set(:,1),  & 
G1H24(13),G1H24(1),G1H24(2),G1H24(3),G1H24(4),G1H24(5),24)
  call HG1shiftOLR(G1H24(1),8,24)
  call Hloop_VQ_A(ntryL,G1H24(7),ex3(:),G1H12(1),m3h2x12(:,11),heltab2x24(:,:,11))
  call Hloop_Q_A(ntryL,G1H12(1),37,nMB,G2H12(11),n2h12(7))
  call Hloop_VQ_A(ntryL,G1H24(8),ex3(:),G1H12(1),m3h2x12(:,12),heltab2x24(:,:,12))
  call Hloop_Q_A(ntryL,G1H12(1),37,nMB,G2H12(12),n2h12(8))
  call Hloop_VA_Q(ntryL,G1H24(9),ex2(:),G1H12(1),m3h2x12(:,13),heltab2x24(:,:,13))
  call Hloop_A_Q(ntryL,G1H12(1),38,nMT,G2H12(13),n2h12(9))
  call Hloop_VQ_A(ntryL,G1H24(10),ex3(:),G1H12(1),m3h2x12(:,14),heltab2x24(:,:,14))
  call Hloop_Q_A(ntryL,G1H12(1),38,nMB,G2H12(14),n2h12(10))
  call Hotf_5pt_reduction(G2H24(6),RedSet_5(1),mass5set(:,1),  & 
G1H24(6),G1H24(7),G1H24(8),G1H24(9),G1H24(10),G1H24(14),24)
  call HG1shiftOLR(G1H24(7),4,24)
  call Hloop_VA_Q(ntryL,G1H24(11),ex4(:),G1H12(1),m3h2x12(:,15),heltab2x24(:,:,15))
  call Hloop_A_Q(ntryL,G1H12(1),41,nMB,G2H12(15),n2h12(11))
  call Hloop_VA_Q(ntryL,G1H24(12),ex4(:),G1H12(1),m3h2x12(:,16),heltab2x24(:,:,16))
  call Hloop_A_Q(ntryL,G1H12(1),41,nMB,G2H12(16),n2h12(12))
  call Hotf_5pt_reduction(G2H24(7),RedSet_5(2),mass5set(:,1),  & 
G1H24(11),G1H24(12),G1H24(15),G1H24(16),G1H24(17),G1H24(18),24)
  call HG1shiftOLR(G1H24(12),8,24)
  call Hotf_5pt_reduction(G2H24(8),RedSet_5(2),mass5set(:,1),  & 
G1H24(19),G1H24(20),G1H24(21),G1H24(22),G1H24(23),G1H24(24),24)
  call HG1shiftOLR(G1H24(20),4,24)
  call Hloop_AZ_Q(ntryL,G1H24(13),ex5(:),G1H8(1),ngZu,m3h3x8(:,1),heltab2x24(:,:,17))
  call Hloop_A_Q(ntryL,G1H8(1),50,nMT,G2H8(1),n2h8(1))
call HGT_raise_alpha_OLR(G1H24(1),1,1,24)
call HGT_raise_alpha_invQ_OLR(G1H24(1),2,5,24)
  call Hloop_VA_Q(ntryL,G1H24(1),ex4(:),G1H12(1),m3h2x12(:,17),heltab2x24(:,:,18))
  call Hloop_AZ_Q(ntryL,G1H24(3),ex5(:),G1H8(1),ngZu,m3h3x8(:,2),heltab2x24(:,:,19))
  call Hloop_A_Q(ntryL,G1H8(1),50,nMT,G2H8(2),n2h8(2))
  call Hloop_AZ_Q(ntryL,G1H24(4),ex5(:),G1H8(1),ngZu,m3h3x8(:,3),heltab2x24(:,:,20))
  call Hloop_A_Q(ntryL,G1H8(1),50,nMT,G2H8(3),n2h8(3))
  call Hloop_AZ_Q(ntryL,G1H24(5),ex5(:),G1H8(1),ngZu,m3h3x8(:,4),heltab2x24(:,:,21))
  call Hloop_A_Q(ntryL,G1H8(1),50,nMT,G2H8(4),n2h8(4))
  call Hloop_AZ_Q(ntryL,G1H24(6),ex5(:),G1H8(1),ngZu,m3h3x8(:,5),heltab2x24(:,:,22))
  call Hloop_A_Q(ntryL,G1H8(1),50,nMT,G2H8(5),n2h8(5))
call HGT_raise_alpha_OLR(G1H24(7),1,1,24)
call HGT_raise_alpha_invQ_OLR(G1H24(7),2,5,24)
  call Hloop_VQ_A(ntryL,G1H24(7),ex3(:),G1H12(2),m3h2x12(:,18),heltab2x24(:,:,23))
  call Hloop_AZ_Q(ntryL,G1H24(9),ex5(:),G1H8(1),ngZu,m3h3x8(:,6),heltab2x24(:,:,24))
  call Hloop_A_Q(ntryL,G1H8(1),50,nMT,G2H8(6),n2h8(6))
  call Hloop_AZ_Q(ntryL,G1H24(10),ex5(:),G1H8(1),ngZu,m3h3x8(:,7),heltab2x24(:,:,25))
  call Hloop_A_Q(ntryL,G1H8(1),50,nMT,G2H8(7),n2h8(7))
  call Hloop_AZ_Q(ntryL,G1H24(14),ex5(:),G1H8(1),ngZu,m3h3x8(:,8),heltab2x24(:,:,26))
  call Hloop_A_Q(ntryL,G1H8(1),50,nMT,G2H8(8),n2h8(8))
  call Hloop_QZ_A(ntryL,G1H24(11),ex5(:),G1H8(1),ngZu,m3h3x8(:,9),heltab2x24(:,:,27))
  call Hloop_Q_A(ntryL,G1H8(1),49,nMT,G2H8(9),n2h8(9))
call HGT_raise_alpha_OLR(G1H24(12),1,1,24)
call HGT_raise_alpha_invQ_OLR(G1H24(12),2,5,24)
  call Hloop_VA_Q(ntryL,G1H24(12),ex4(:),G1H12(3),m3h2x12(:,19),heltab2x24(:,:,28))
  call Hloop_QZ_A(ntryL,G1H24(16),ex5(:),G1H8(1),ngZu,m3h3x8(:,10),heltab2x24(:,:,29))
  call Hloop_Q_A(ntryL,G1H8(1),49,nMT,G2H8(10),n2h8(10))
  call Hloop_QZ_A(ntryL,G1H24(17),ex5(:),G1H8(1),ngZu,m3h3x8(:,11),heltab2x24(:,:,30))
  call Hloop_Q_A(ntryL,G1H8(1),49,nMT,G2H8(11),n2h8(11))
  call Hloop_QZ_A(ntryL,G1H24(18),ex5(:),G1H8(1),ngZu,m3h3x8(:,12),heltab2x24(:,:,31))
  call Hloop_Q_A(ntryL,G1H8(1),49,nMT,G2H8(12),n2h8(12))
  call Hloop_QZ_A(ntryL,G1H24(19),ex5(:),G1H8(1),ngZu,m3h3x8(:,13),heltab2x24(:,:,32))
  call Hloop_Q_A(ntryL,G1H8(1),49,nMT,G2H8(13),n2h8(13))
call HGT_raise_alpha_OLR(G1H24(20),1,1,24)
call HGT_raise_alpha_invQ_OLR(G1H24(20),2,5,24)
  call Hloop_VQ_A(ntryL,G1H24(20),ex3(:),G1H12(4),m3h2x12(:,20),heltab2x24(:,:,33))
  call Hloop_QZ_A(ntryL,G1H24(22),ex5(:),G1H8(1),ngZu,m3h3x8(:,14),heltab2x24(:,:,34))
  call Hloop_Q_A(ntryL,G1H8(1),49,nMT,G2H8(14),n2h8(14))
  call Hloop_QZ_A(ntryL,G1H24(23),ex5(:),G1H8(1),ngZu,m3h3x8(:,15),heltab2x24(:,:,35))
  call Hloop_Q_A(ntryL,G1H8(1),49,nMT,G2H8(15),n2h8(15))
  call Hloop_QZ_A(ntryL,G1H24(24),ex5(:),G1H8(1),ngZu,m3h3x8(:,16),heltab2x24(:,:,36))
  call Hloop_Q_A(ntryL,G1H8(1),49,nMT,G2H8(16),n2h8(16))
  call Hloop_AQ_V(ntryL,G2H12(1),ex1(:),G2H6(1),m3h2x6(:,1),heltab2x12(:,:,1))
  call Hloop_QA_V(ntryL,G2H12(2),ex2(:),G2H6(2),m3h2x6(:,2),heltab2x12(:,:,2))
  call Hotf_5pt_reduction(G2H12(3),RedSet_5(3),mass5set(:,2),  & 
G1H12(5),G1H12(6),G1H12(7),G1H12(8),G1H12(9),G1H12(10),12)
  call HG1shiftOLR(G1H12(6),8,12)
  call Hloop_QA_V(ntryL,G2H12(4),ex2(:),G2H6(3),m3h2x6(:,3),heltab2x12(:,:,3))
  call Hloop_AQ_V(ntryL,G2H12(5),ex1(:),G2H6(4),m3h2x6(:,4),heltab2x12(:,:,4))
  call Hotf_5pt_reduction(G2H12(6),RedSet_5(4),mass5set(:,2),  & 
G1H12(11),G1H12(12),G1H12(13),G1H12(14),G1H12(15),G1H12(16),12)
  call HG1shiftOLR(G1H12(12),4,12)
  call Hotf_5pt_reduction(G2H12(7),RedSet_5(5),mass5set(:,2),  & 
G1H12(17),G1H12(18),G1H12(19),G1H12(20),G1H12(21),G1H12(22),12)
  call HG1shiftOLR(G1H12(18),8,12)
  call Hotf_5pt_reduction(G2H12(8),RedSet_5(6),mass5set(:,2),  & 
G1H12(23),G1H12(24),G1H12(25),G1H12(26),G1H12(27),G1H12(28),12)
  call HG1shiftOLR(G1H12(24),4,12)
  call Hotf_5pt_reduction(G2H12(9),RedSet_5(7),mass5set(:,3),  & 
G1H12(29),G1H12(30),G1H12(31),G1H12(32),G1H12(33),G1H12(34),12)
  call HG1shiftOLR(G1H12(30),8,12)
  call Hloop_AQ_V(ntryL,G2H12(10),ex3(:),G2H6(5),m3h2x6(:,5),heltab2x12(:,:,5))
  call Hloop_QA_V(ntryL,G2H12(11),ex4(:),G2H6(6),m3h2x6(:,6),heltab2x12(:,:,6))
  call Hotf_5pt_reduction(G2H12(12),RedSet_5(8),mass5set(:,4),  & 
G1H12(35),G1H12(36),G1H12(37),G1H12(38),G1H12(39),G1H12(40),12)
  call HG1shiftOLR(G1H12(36),2,12)
  call Hotf_5pt_reduction(G2H12(13),RedSet_5(9),mass5set(:,3),  & 
G1H12(41),G1H12(42),G1H12(43),G1H12(44),G1H12(45),G1H12(46),12)
  call HG1shiftOLR(G1H12(42),8,12)
  call Hloop_QA_V(ntryL,G2H12(14),ex4(:),G2H6(7),m3h2x6(:,7),heltab2x12(:,:,7))
  call Hloop_AQ_V(ntryL,G2H12(15),ex3(:),G2H6(8),m3h2x6(:,8),heltab2x12(:,:,8))
  call Hotf_5pt_reduction(G2H12(16),RedSet_5(10),mass5set(:,4),  & 
G1H12(47),G1H12(48),G1H12(49),G1H12(50),G1H12(51),G1H12(52),12)
  call HG1shiftOLR(G1H12(48),2,12)
  call Hloop_AQ_V(ntryL,G2H8(1),ex1(:),G2H4(1),m3h2x4(:,1),heltab2x8(:,:,1))
  call Hloop_AQ_V(ntryL,G2H8(3),ex1(:),G2H4(2),m3h2x4(:,2),heltab2x8(:,:,2))
  call Hloop_AQ_V(ntryL,G2H8(4),ex1(:),G2H4(3),m3h2x4(:,3),heltab2x8(:,:,3))
  call Hloop_AQ_V(ntryL,G2H8(5),ex1(:),G2H4(4),m3h2x4(:,4),heltab2x8(:,:,4))
  call Hloop_AQ_V(ntryL,G2H8(7),ex1(:),G2H4(5),m3h2x4(:,5),heltab2x8(:,:,5))
  call Hloop_AQ_V(ntryL,G2H8(8),ex1(:),G2H4(6),m3h2x4(:,6),heltab2x8(:,:,6))
  call Hloop_QA_V(ntryL,G2H8(9),ex2(:),G2H4(7),m3h2x4(:,7),heltab2x8(:,:,7))
  call Hloop_QA_V(ntryL,G2H8(11),ex2(:),G2H4(8),m3h2x4(:,8),heltab2x8(:,:,8))
  call Hloop_QA_V(ntryL,G2H8(12),ex2(:),G2H4(9),m3h2x4(:,9),heltab2x8(:,:,9))
  call Hloop_QA_V(ntryL,G2H8(13),ex2(:),G2H4(10),m3h2x4(:,10),heltab2x8(:,:,10))
  call Hloop_QA_V(ntryL,G2H8(15),ex2(:),G2H4(11),m3h2x4(:,11),heltab2x8(:,:,11))
  call Hloop_QA_V(ntryL,G2H8(16),ex2(:),G2H4(12),m3h2x4(:,12),heltab2x8(:,:,12))
  call Hloop_VQ_A(ntryL,G1H12(5),ex3(:),G1H6(1),m3h2x6(:,9),heltab2x12(:,:,9))
  call Hloop_Q_A(ntryL,G1H6(1),39,nMB,G2H6(9),n2h6(1))
call HGT_raise_alpha_OLR(G1H12(6),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(6),2,5,12)
  call Hloop_VA_Q(ntryL,G1H12(6),ex4(:),G1H6(1),m3h2x6(:,10),heltab2x12(:,:,10))
  call Hloop_VQ_A(ntryL,G1H12(9),ex3(:),G1H6(2),m3h2x6(:,11),heltab2x12(:,:,11))
  call Hloop_Q_A(ntryL,G1H6(2),39,nMB,G2H6(10),n2h6(2))
  call Hloop_VQ_A(ntryL,G1H12(10),ex3(:),G1H6(2),m3h2x6(:,12),heltab2x12(:,:,12))
  call Hloop_Q_A(ntryL,G1H6(2),39,nMB,G2H6(11),n2h6(3))
  call Hloop_VA_Q(ntryL,G1H12(11),ex4(:),G1H6(2),m3h2x6(:,13),heltab2x12(:,:,13))
  call Hloop_A_Q(ntryL,G1H6(2),43,nMB,G2H6(12),n2h6(4))
call HGT_raise_alpha_OLR(G1H12(12),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(12),2,5,12)
  call Hloop_VQ_A(ntryL,G1H12(12),ex3(:),G1H6(2),m3h2x6(:,14),heltab2x12(:,:,14))
  call Hloop_VA_Q(ntryL,G1H12(15),ex4(:),G1H6(3),m3h2x6(:,15),heltab2x12(:,:,15))
  call Hloop_A_Q(ntryL,G1H6(3),43,nMB,G2H6(13),n2h6(5))
  call Hloop_VA_Q(ntryL,G1H12(16),ex4(:),G1H6(3),m3h2x6(:,16),heltab2x12(:,:,16))
  call Hloop_A_Q(ntryL,G1H6(3),43,nMB,G2H6(14),n2h6(6))
  call Hloop_VQ_A(ntryL,G1H12(17),ex3(:),G1H6(3),m3h2x6(:,17),heltab2x12(:,:,17))
  call Hloop_Q_A(ntryL,G1H6(3),39,nMB,G2H6(15),n2h6(7))
call HGT_raise_alpha_OLR(G1H12(18),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(18),2,5,12)
  call Hloop_VA_Q(ntryL,G1H12(18),ex4(:),G1H6(3),m3h2x6(:,18),heltab2x12(:,:,18))
  call Hloop_VQ_A(ntryL,G1H12(21),ex3(:),G1H6(4),m3h2x6(:,19),heltab2x12(:,:,19))
  call Hloop_Q_A(ntryL,G1H6(4),39,nMB,G2H6(16),n2h6(8))
  call Hloop_VQ_A(ntryL,G1H12(22),ex3(:),G1H6(4),m3h2x6(:,20),heltab2x12(:,:,20))
  call Hloop_Q_A(ntryL,G1H6(4),39,nMB,G2H6(17),n2h6(9))
  call Hloop_VA_Q(ntryL,G1H12(23),ex4(:),G1H6(4),m3h2x6(:,21),heltab2x12(:,:,21))
  call Hloop_A_Q(ntryL,G1H6(4),43,nMB,G2H6(18),n2h6(10))
call HGT_raise_alpha_OLR(G1H12(24),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(24),2,5,12)
  call Hloop_VQ_A(ntryL,G1H12(24),ex3(:),G1H6(4),m3h2x6(:,22),heltab2x12(:,:,22))
  call Hloop_VA_Q(ntryL,G1H12(27),ex4(:),G1H6(5),m3h2x6(:,23),heltab2x12(:,:,23))
  call Hloop_A_Q(ntryL,G1H6(5),43,nMB,G2H6(19),n2h6(11))
  call Hloop_VA_Q(ntryL,G1H12(28),ex4(:),G1H6(5),m3h2x6(:,24),heltab2x12(:,:,24))
  call Hloop_A_Q(ntryL,G1H6(5),43,nMB,G2H6(20),n2h6(12))
  call Hloop_QZ_A(ntryL,G1H12(29),ex5(:),G1H4(1),ngZu,m3h3x4(:,1),heltab2x12(:,:,25))
  call Hloop_Q_A(ntryL,G1H4(1),53,nMT,G2H4(13),n2h4(1))
call HGT_OLR(G1H12(30),1,1,12)
call HGT_invQ_OLR(G1H12(30),2,5,12)
  call Hloop_Q_A(ntryL,G1H12(30),-8,nMB,G2H12(1),n2h12(17))
  call Hloop_QA_V(ntryL,G2H12(1),ex4(:),G2H6(21),m3h2x6(:,25),heltab2x12(:,:,26))
  call Hloop_QZ_A(ntryL,G1H12(33),ex5(:),G1H4(1),ngZu,m3h3x4(:,2),heltab2x12(:,:,27))
  call Hloop_Q_A(ntryL,G1H4(1),53,nMT,G2H4(14),n2h4(2))
  call Hloop_QZ_A(ntryL,G1H12(34),ex5(:),G1H4(1),ngZu,m3h3x4(:,3),heltab2x12(:,:,28))
  call Hloop_Q_A(ntryL,G1H4(1),53,nMT,G2H4(15),n2h4(3))
  call Hloop_QZ_A(ntryL,G1H12(35),ex5(:),G1H4(1),ngZd,m3h3x4(:,4),heltab2x12(:,:,29))
  call Hloop_Q_A(ntryL,G1H4(1),53,nMB,G2H4(16),n2h4(4))
call HGT_OLR(G1H12(36),1,1,12)
call HGT_invQ_OLR(G1H12(36),2,5,12)
  call Hloop_Q_A(ntryL,G1H12(36),-2,nMT,G2H12(2),n2h12(18))
  call Hloop_QA_V(ntryL,G2H12(2),ex2(:),G2H6(22),m3h2x6(:,26),heltab2x12(:,:,30))
  call Hloop_QZ_A(ntryL,G1H12(39),ex5(:),G1H4(1),ngZd,m3h3x4(:,5),heltab2x12(:,:,31))
  call Hloop_Q_A(ntryL,G1H4(1),53,nMB,G2H4(17),n2h4(5))
  call Hloop_QZ_A(ntryL,G1H12(40),ex5(:),G1H4(1),ngZd,m3h3x4(:,6),heltab2x12(:,:,32))
  call Hloop_Q_A(ntryL,G1H4(1),53,nMB,G2H4(18),n2h4(6))
  call Hloop_AZ_Q(ntryL,G1H12(41),ex5(:),G1H4(1),ngZu,m3h3x4(:,7),heltab2x12(:,:,33))
  call Hloop_A_Q(ntryL,G1H4(1),54,nMT,G2H4(19),n2h4(7))
call HGT_OLR(G1H12(42),1,1,12)
call HGT_invQ_OLR(G1H12(42),2,5,12)
  call Hloop_Q_A(ntryL,G1H12(42),-8,nMB,G2H12(3),n2h12(19))
  call Hloop_QA_V(ntryL,G2H12(3),ex4(:),G2H6(23),m3h2x6(:,27),heltab2x12(:,:,34))
  call Hloop_AZ_Q(ntryL,G1H12(45),ex5(:),G1H4(1),ngZu,m3h3x4(:,8),heltab2x12(:,:,35))
  call Hloop_A_Q(ntryL,G1H4(1),54,nMT,G2H4(20),n2h4(8))
  call Hloop_AZ_Q(ntryL,G1H12(46),ex5(:),G1H4(1),ngZu,m3h3x4(:,9),heltab2x12(:,:,36))
  call Hloop_A_Q(ntryL,G1H4(1),54,nMT,G2H4(21),n2h4(9))
  call Hloop_AZ_Q(ntryL,G1H12(47),ex5(:),G1H4(1),ngZd,m3h3x4(:,10),heltab2x12(:,:,37))
  call Hloop_A_Q(ntryL,G1H4(1),57,nMB,G2H4(22),n2h4(10))
call HGT_OLR(G1H12(48),1,1,12)
call HGT_invQ_OLR(G1H12(48),2,5,12)
  call Hloop_Q_A(ntryL,G1H12(48),-2,nMT,G2H12(4),n2h12(20))
  call Hloop_QA_V(ntryL,G2H12(4),ex2(:),G2H6(24),m3h2x6(:,28),heltab2x12(:,:,38))
  call Hloop_AZ_Q(ntryL,G1H12(51),ex5(:),G1H4(1),ngZd,m3h3x4(:,11),heltab2x12(:,:,39))
  call Hloop_A_Q(ntryL,G1H4(1),57,nMB,G2H4(23),n2h4(11))
  call Hloop_AZ_Q(ntryL,G1H12(52),ex5(:),G1H4(1),ngZd,m3h3x4(:,12),heltab2x12(:,:,40))
  call Hloop_A_Q(ntryL,G1H4(1),57,nMB,G2H4(24),n2h4(12))
  call Hotf_5pt_reduction(G2H6(1),RedSet_5(11),mass5set(:,5),  & 
G1H6(5),G1H6(6),G1H6(7),G1H6(8),G1H6(9),G1H6(10),6)
  call HG1shiftOLR(G1H6(6),16,6)
  call Hotf_5pt_reduction(G2H6(2),RedSet_5(12),mass5set(:,5),  & 
G1H6(11),G1H6(12),G1H6(13),G1H6(14),G1H6(15),G1H6(16),6)
  call HG1shiftOLR(G1H6(12),16,6)
  call Hotf_5pt_reduction(G2H6(3),RedSet_5(13),mass5set(:,5),  & 
G1H6(17),G1H6(18),G1H6(19),G1H6(20),G1H6(21),G1H6(22),6)
  call HG1shiftOLR(G1H6(18),16,6)
  call Hotf_5pt_reduction(G2H6(4),RedSet_5(14),mass5set(:,5),  & 
G1H6(23),G1H6(24),G1H6(25),G1H6(26),G1H6(27),G1H6(28),6)
  call HG1shiftOLR(G1H6(24),16,6)
  call Hotf_5pt_reduction(G2H6(5),RedSet_5(15),mass5set(:,6),  & 
G1H6(29),G1H6(30),G1H6(31),G1H6(32),G1H6(33),G1H6(34),6)
  call HG1shiftOLR(G1H6(30),16,6)
  call Hotf_5pt_reduction(G2H6(6),RedSet_5(16),mass5set(:,6),  & 
G1H6(35),G1H6(36),G1H6(37),G1H6(38),G1H6(39),G1H6(40),6)
  call HG1shiftOLR(G1H6(36),16,6)
  call Hotf_5pt_reduction(G2H6(7),RedSet_5(17),mass5set(:,6),  & 
G1H6(41),G1H6(42),G1H6(43),G1H6(44),G1H6(45),G1H6(46),6)
  call HG1shiftOLR(G1H6(42),16,6)
  call Hotf_5pt_reduction(G2H6(8),RedSet_5(18),mass5set(:,6),  & 
G1H6(47),G1H6(48),G1H6(49),G1H6(50),G1H6(51),G1H6(52),6)
  call HG1shiftOLR(G1H6(48),16,6)
  call Hotf_5pt_reduction(G2H4(1),RedSet_5(1),mass5set(:,1),  & 
G1H4(1),G1H4(2),G1H4(3),G1H4(4),G1H4(5),G1H4(6),4)
  call HG1shiftOLR(G1H4(2),8,4)
  call Hotf_5pt_reduction(G2H4(3),RedSet_5(19),mass5set(:,7),  & 
G1H4(7),G1H4(8),G1H4(9),G1H4(10),G1H4(11),G1H4(12),4)
  call HG1shiftOLR(G1H4(8),8,4)
  call Hotf_5pt_reduction(G2H4(4),RedSet_5(1),mass5set(:,1),  & 
G1H4(13),G1H4(14),G1H4(15),G1H4(16),G1H4(17),G1H4(18),4)
  call HG1shiftOLR(G1H4(14),4,4)
  call Hotf_5pt_reduction(G2H4(6),RedSet_5(20),mass5set(:,7),  & 
G1H4(19),G1H4(20),G1H4(21),G1H4(22),G1H4(23),G1H4(24),4)
  call HG1shiftOLR(G1H4(20),4,4)
  call Hotf_5pt_reduction(G2H4(7),RedSet_5(2),mass5set(:,1),  & 
G1H4(25),G1H4(26),G1H4(27),G1H4(28),G1H4(29),G1H4(30),4)
  call HG1shiftOLR(G1H4(26),8,4)
  call Hotf_5pt_reduction(G2H4(9),RedSet_5(21),mass5set(:,7),  & 
G1H4(31),G1H4(32),G1H4(33),G1H4(34),G1H4(35),G1H4(36),4)
  call HG1shiftOLR(G1H4(32),8,4)
  call Hotf_5pt_reduction(G2H4(10),RedSet_5(2),mass5set(:,1),  & 
G1H4(37),G1H4(38),G1H4(39),G1H4(40),G1H4(41),G1H4(42),4)
  call HG1shiftOLR(G1H4(38),4,4)
  call Hotf_5pt_reduction(G2H4(12),RedSet_5(22),mass5set(:,7),  & 
G1H4(43),G1H4(44),G1H4(45),G1H4(46),G1H4(47),G1H4(48),4)
  call HG1shiftOLR(G1H4(44),4,4)
  call Hotf_5pt_reduction(G2H6(9),RedSet_5(3),mass5set(:,2),  & 
G1H6(53),G1H6(54),G1H6(55),G1H6(56),G1H6(57),G1H6(58),6)
  call HG1shiftOLR(G1H6(54),8,6)
  call Hotf_5pt_reduction(G2H6(11),RedSet_5(23),mass5set(:,2),  & 
G1H6(59),G1H6(60),G1H6(61),G1H6(62),G1H6(63),G1H6(64),6)
  call HG1shiftOLR(G1H6(60),8,6)
  call Hotf_5pt_reduction(G2H6(12),RedSet_5(4),mass5set(:,2),  & 
G1H6(65),G1H6(66),G1H6(67),G1H6(68),G1H6(69),G1H6(70),6)
  call HG1shiftOLR(G1H6(66),4,6)
  call Hotf_5pt_reduction(G2H6(14),RedSet_5(24),mass5set(:,2),  & 
G1H6(71),G1H6(72),G1H6(73),G1H6(74),G1H6(75),G1H6(76),6)
  call HG1shiftOLR(G1H6(72),4,6)
  call Hotf_5pt_reduction(G2H6(15),RedSet_5(5),mass5set(:,2),  & 
G1H6(77),G1H6(78),G1H6(79),G1H6(80),G1H6(81),G1H6(82),6)
  call HG1shiftOLR(G1H6(78),8,6)
  call Hotf_5pt_reduction(G2H6(17),RedSet_5(25),mass5set(:,2),  & 
G1H6(83),G1H6(84),G1H6(85),G1H6(86),G1H6(87),G1H6(88),6)
  call HG1shiftOLR(G1H6(84),8,6)
  call Hotf_5pt_reduction(G2H6(18),RedSet_5(6),mass5set(:,2),  & 
G1H6(89),G1H6(90),G1H6(91),G1H6(92),G1H6(93),G1H6(94),6)
  call HG1shiftOLR(G1H6(90),4,6)
  call Hotf_5pt_reduction(G2H6(20),RedSet_5(26),mass5set(:,2),  & 
G1H6(95),G1H6(96),G1H6(97),G1H6(98),G1H6(99),G1H6(100),6)
  call HG1shiftOLR(G1H6(96),4,6)
  call Hloop_QA_V(ntryL,G2H4(13),ex2(:),G2H2(1),m3h2x2(:,1),heltab2x4(:,:,1))
  call Hloop_QA_V(ntryL,G2H4(15),ex2(:),G2H2(2),m3h2x2(:,2),heltab2x4(:,:,2))
  call Hloop_QA_V(ntryL,G2H4(16),ex4(:),G2H2(3),m3h2x2(:,3),heltab2x4(:,:,3))
  call Hloop_QA_V(ntryL,G2H4(18),ex4(:),G2H2(4),m3h2x2(:,4),heltab2x4(:,:,4))
  call Hloop_AQ_V(ntryL,G2H4(19),ex1(:),G2H2(5),m3h2x2(:,5),heltab2x4(:,:,5))
  call Hloop_AQ_V(ntryL,G2H4(21),ex1(:),G2H2(6),m3h2x2(:,6),heltab2x4(:,:,6))
  call Hloop_AQ_V(ntryL,G2H4(22),ex3(:),G2H2(7),m3h2x2(:,7),heltab2x4(:,:,7))
  call Hloop_AQ_V(ntryL,G2H4(24),ex3(:),G2H2(8),m3h2x2(:,8),heltab2x4(:,:,8))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(7),[G1H4(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(19),[G1H4(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(31),[G1H4(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(43),[G1H4(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(59),[G1H6(58)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(71),[G1H6(70)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(83),[G1H6(82)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(95),[G1H6(94)])
  call Hloop_VQ_A(ntryL,G1H6(5),ex3(:),G1H3(1),m3h2x3(:,1),heltab2x6(:,:,1))
  call Hloop_Q_A(ntryL,G1H3(1),47,nMB,G2H3(1),n2h3(1))
call HGT_OLR(G1H6(6),1,1,6)
call HGT_invQ_OLR(G1H6(6),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(6),-16,nMB,G2H6(1),n2h6(13))
  call Hloop_AZ_Q(ntryL,G2H6(1),ex5(:),G2H2(9),ngZd,m3h3x2(:,1),heltab2x6(:,:,2))
  call Hloop_VQ_A(ntryL,G1H6(10),ex3(:),G1H3(1),m3h2x3(:,2),heltab2x6(:,:,3))
  call Hloop_Q_A(ntryL,G1H3(1),47,nMB,G2H3(2),n2h3(2))
  call Hloop_VA_Q(ntryL,G1H6(11),ex4(:),G1H3(1),m3h2x3(:,3),heltab2x6(:,:,4))
  call Hloop_A_Q(ntryL,G1H3(1),47,nMB,G2H3(3),n2h3(3))
call HGT_OLR(G1H6(12),1,1,6)
call HGT_invQ_OLR(G1H6(12),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(12),-16,nMB,G2H6(2),n2h6(14))
  call Hloop_QZ_A(ntryL,G2H6(2),ex5(:),G2H2(10),ngZd,m3h3x2(:,2),heltab2x6(:,:,5))
  call Hloop_VA_Q(ntryL,G1H6(16),ex4(:),G1H3(1),m3h2x3(:,4),heltab2x6(:,:,6))
  call Hloop_A_Q(ntryL,G1H3(1),47,nMB,G2H3(4),n2h3(4))
  call Hloop_VQ_A(ntryL,G1H6(17),ex3(:),G1H3(1),m3h2x3(:,5),heltab2x6(:,:,7))
  call Hloop_Q_A(ntryL,G1H3(1),47,nMB,G2H3(5),n2h3(5))
call HGT_OLR(G1H6(18),1,1,6)
call HGT_invQ_OLR(G1H6(18),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(18),-16,nMB,G2H6(3),n2h6(15))
  call Hloop_AZ_Q(ntryL,G2H6(3),ex5(:),G2H2(11),ngZd,m3h3x2(:,3),heltab2x6(:,:,8))
  call Hloop_VQ_A(ntryL,G1H6(22),ex3(:),G1H3(1),m3h2x3(:,6),heltab2x6(:,:,9))
  call Hloop_Q_A(ntryL,G1H3(1),47,nMB,G2H3(6),n2h3(6))
  call Hloop_VA_Q(ntryL,G1H6(23),ex4(:),G1H3(1),m3h2x3(:,7),heltab2x6(:,:,10))
  call Hloop_A_Q(ntryL,G1H3(1),47,nMB,G2H3(7),n2h3(7))
call HGT_OLR(G1H6(24),1,1,6)
call HGT_invQ_OLR(G1H6(24),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(24),-16,nMB,G2H6(4),n2h6(16))
  call Hloop_QZ_A(ntryL,G2H6(4),ex5(:),G2H2(12),ngZd,m3h3x2(:,4),heltab2x6(:,:,11))
  call Hloop_VA_Q(ntryL,G1H6(28),ex4(:),G1H3(1),m3h2x3(:,8),heltab2x6(:,:,12))
  call Hloop_A_Q(ntryL,G1H3(1),47,nMB,G2H3(8),n2h3(8))
  call Hloop_VQ_A(ntryL,G1H6(29),ex1(:),G1H3(1),m3h2x3(:,9),heltab2x6(:,:,13))
  call Hloop_Q_A(ntryL,G1H3(1),47,nMT,G2H3(9),n2h3(9))
call HGT_OLR(G1H6(30),1,1,6)
call HGT_invQ_OLR(G1H6(30),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(30),-16,nMT,G2H6(5),n2h6(17))
  call Hloop_AZ_Q(ntryL,G2H6(5),ex5(:),G2H2(13),ngZu,m3h3x2(:,5),heltab2x6(:,:,14))
  call Hloop_VQ_A(ntryL,G1H6(34),ex1(:),G1H3(1),m3h2x3(:,10),heltab2x6(:,:,15))
  call Hloop_Q_A(ntryL,G1H3(1),47,nMT,G2H3(10),n2h3(10))
  call Hloop_VA_Q(ntryL,G1H6(35),ex2(:),G1H3(1),m3h2x3(:,11),heltab2x6(:,:,16))
  call Hloop_A_Q(ntryL,G1H3(1),47,nMT,G2H3(11),n2h3(11))
call HGT_OLR(G1H6(36),1,1,6)
call HGT_invQ_OLR(G1H6(36),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(36),-16,nMT,G2H6(6),n2h6(18))
  call Hloop_QZ_A(ntryL,G2H6(6),ex5(:),G2H2(14),ngZu,m3h3x2(:,6),heltab2x6(:,:,17))
  call Hloop_VA_Q(ntryL,G1H6(40),ex2(:),G1H3(1),m3h2x3(:,12),heltab2x6(:,:,18))
  call Hloop_A_Q(ntryL,G1H3(1),47,nMT,G2H3(12),n2h3(12))
  call Hloop_VQ_A(ntryL,G1H6(41),ex1(:),G1H3(1),m3h2x3(:,13),heltab2x6(:,:,19))
  call Hloop_Q_A(ntryL,G1H3(1),47,nMT,G2H3(13),n2h3(13))
call HGT_OLR(G1H6(42),1,1,6)
call HGT_invQ_OLR(G1H6(42),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(42),-16,nMT,G2H6(7),n2h6(19))
  call Hloop_AZ_Q(ntryL,G2H6(7),ex5(:),G2H2(15),ngZu,m3h3x2(:,7),heltab2x6(:,:,20))
  call Hloop_VQ_A(ntryL,G1H6(46),ex1(:),G1H3(1),m3h2x3(:,14),heltab2x6(:,:,21))
  call Hloop_Q_A(ntryL,G1H3(1),47,nMT,G2H3(14),n2h3(14))
  call Hloop_VA_Q(ntryL,G1H6(47),ex2(:),G1H3(1),m3h2x3(:,15),heltab2x6(:,:,22))
  call Hloop_A_Q(ntryL,G1H3(1),47,nMT,G2H3(15),n2h3(15))
call HGT_OLR(G1H6(48),1,1,6)
call HGT_invQ_OLR(G1H6(48),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(48),-16,nMT,G2H6(8),n2h6(20))
  call Hloop_QZ_A(ntryL,G2H6(8),ex5(:),G2H2(16),ngZu,m3h3x2(:,8),heltab2x6(:,:,23))
  call Hloop_VA_Q(ntryL,G1H6(52),ex2(:),G1H3(1),m3h2x3(:,16),heltab2x6(:,:,24))
  call Hloop_A_Q(ntryL,G1H3(1),47,nMT,G2H3(16),n2h3(16))
  call Hloop_VQ_A(ntryL,G1H4(1),ex3(:),G1H2(1),m3h2x2(:,9),heltab2x4(:,:,9))
  call Hloop_Q_A(ntryL,G1H2(1),55,nMB,G2H2(17),n2h2(1))
call HGT_raise_alpha_OLR(G1H4(2),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(2),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(2),ex4(:),G1H2(1),m3h2x2(:,10),heltab2x4(:,:,10))
  call Hloop_VQ_A(ntryL,G1H4(7),ex3(:),G1H2(2),m3h2x2(:,11),heltab2x4(:,:,11))
  call Hloop_Q_A(ntryL,G1H2(2),55,nMB,G2H2(18),n2h2(2))
call HGT_raise_alpha_OLR(G1H4(8),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(8),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(8),ex4(:),G1H2(2),m3h2x2(:,12),heltab2x4(:,:,12))
  call Hloop_VQ_A(ntryL,G1H4(12),ex3(:),G1H2(3),m3h2x2(:,13),heltab2x4(:,:,13))
  call Hloop_Q_A(ntryL,G1H2(3),55,nMB,G2H2(19),n2h2(3))
  call Hloop_VA_Q(ntryL,G1H4(13),ex4(:),G1H2(3),m3h2x2(:,14),heltab2x4(:,:,14))
  call Hloop_A_Q(ntryL,G1H2(3),59,nMB,G2H2(20),n2h2(4))
call HGT_raise_alpha_OLR(G1H4(14),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(14),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(14),ex3(:),G1H2(3),m3h2x2(:,15),heltab2x4(:,:,15))
  call Hloop_VA_Q(ntryL,G1H4(19),ex4(:),G1H2(4),m3h2x2(:,16),heltab2x4(:,:,16))
  call Hloop_A_Q(ntryL,G1H2(4),59,nMB,G2H2(21),n2h2(5))
call HGT_raise_alpha_OLR(G1H4(20),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(20),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(20),ex3(:),G1H2(4),m3h2x2(:,17),heltab2x4(:,:,17))
  call Hloop_VA_Q(ntryL,G1H4(24),ex4(:),G1H2(5),m3h2x2(:,18),heltab2x4(:,:,18))
  call Hloop_A_Q(ntryL,G1H2(5),59,nMB,G2H2(22),n2h2(6))
  call Hloop_VQ_A(ntryL,G1H4(25),ex3(:),G1H2(5),m3h2x2(:,19),heltab2x4(:,:,19))
  call Hloop_Q_A(ntryL,G1H2(5),55,nMB,G2H2(23),n2h2(7))
call HGT_raise_alpha_OLR(G1H4(26),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(26),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(26),ex4(:),G1H2(5),m3h2x2(:,20),heltab2x4(:,:,20))
  call Hloop_VQ_A(ntryL,G1H4(31),ex3(:),G1H2(6),m3h2x2(:,21),heltab2x4(:,:,21))
  call Hloop_Q_A(ntryL,G1H2(6),55,nMB,G2H2(24),n2h2(8))
call HGT_raise_alpha_OLR(G1H4(32),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(32),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(32),ex4(:),G1H2(6),m3h2x2(:,22),heltab2x4(:,:,22))
  call Hloop_VQ_A(ntryL,G1H4(36),ex3(:),G1H2(7),m3h2x2(:,23),heltab2x4(:,:,23))
  call Hloop_Q_A(ntryL,G1H2(7),55,nMB,G2H2(25),n2h2(9))
  call Hloop_VA_Q(ntryL,G1H4(37),ex4(:),G1H2(7),m3h2x2(:,24),heltab2x4(:,:,24))
  call Hloop_A_Q(ntryL,G1H2(7),59,nMB,G2H2(26),n2h2(10))
call HGT_raise_alpha_OLR(G1H4(38),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(38),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(38),ex3(:),G1H2(7),m3h2x2(:,25),heltab2x4(:,:,25))
  call Hloop_VA_Q(ntryL,G1H4(43),ex4(:),G1H2(8),m3h2x2(:,26),heltab2x4(:,:,26))
  call Hloop_A_Q(ntryL,G1H2(8),59,nMB,G2H2(27),n2h2(11))
call HGT_raise_alpha_OLR(G1H4(44),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(44),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(44),ex3(:),G1H2(8),m3h2x2(:,27),heltab2x4(:,:,27))
  call Hloop_VA_Q(ntryL,G1H4(48),ex4(:),G1H2(9),m3h2x2(:,28),heltab2x4(:,:,28))
  call Hloop_A_Q(ntryL,G1H2(9),59,nMB,G2H2(28),n2h2(12))
  call Hloop_QZ_A(ntryL,G1H6(53),ex5(:),G1H2(9),ngZd,m3h3x2(:,9),heltab2x6(:,:,25))
  call Hloop_Q_A(ntryL,G1H2(9),55,nMB,G2H2(29),n2h2(13))
call HGT_raise_alpha_OLR(G1H6(54),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(54),2,5,6)
  call Hloop_VA_Q(ntryL,G1H6(54),ex4(:),G1H3(1),m3h2x3(:,17),heltab2x6(:,:,26))
  call Hloop_QZ_A(ntryL,G1H6(59),ex5(:),G1H2(9),ngZd,m3h3x2(:,10),heltab2x6(:,:,27))
  call Hloop_Q_A(ntryL,G1H2(9),55,nMB,G2H2(30),n2h2(14))
call HGT_raise_alpha_OLR(G1H6(60),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(60),2,5,6)
  call Hloop_VA_Q(ntryL,G1H6(60),ex4(:),G1H3(2),m3h2x3(:,18),heltab2x6(:,:,28))
  call Hloop_QZ_A(ntryL,G1H6(64),ex5(:),G1H2(9),ngZd,m3h3x2(:,11),heltab2x6(:,:,29))
  call Hloop_Q_A(ntryL,G1H2(9),55,nMB,G2H2(31),n2h2(15))
  call Hloop_AZ_Q(ntryL,G1H6(65),ex5(:),G1H2(9),ngZd,m3h3x2(:,12),heltab2x6(:,:,30))
  call Hloop_A_Q(ntryL,G1H2(9),59,nMB,G2H2(32),n2h2(16))
call HGT_raise_alpha_OLR(G1H6(66),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(66),2,5,6)
  call Hloop_VQ_A(ntryL,G1H6(66),ex3(:),G1H3(3),m3h2x3(:,19),heltab2x6(:,:,31))
  call Hloop_AZ_Q(ntryL,G1H6(71),ex5(:),G1H2(9),ngZd,m3h3x2(:,13),heltab2x6(:,:,32))
  call Hloop_A_Q(ntryL,G1H2(9),59,nMB,G2H2(33),n2h2(17))
call HGT_raise_alpha_OLR(G1H6(72),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(72),2,5,6)
  call Hloop_VQ_A(ntryL,G1H6(72),ex3(:),G1H3(4),m3h2x3(:,20),heltab2x6(:,:,33))
  call Hloop_AZ_Q(ntryL,G1H6(76),ex5(:),G1H2(9),ngZd,m3h3x2(:,14),heltab2x6(:,:,34))
  call Hloop_A_Q(ntryL,G1H2(9),59,nMB,G2H2(34),n2h2(18))
  call Hloop_QZ_A(ntryL,G1H6(77),ex5(:),G1H2(9),ngZd,m3h3x2(:,15),heltab2x6(:,:,35))
  call Hloop_Q_A(ntryL,G1H2(9),55,nMB,G2H2(35),n2h2(19))
call HGT_raise_alpha_OLR(G1H6(78),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(78),2,5,6)
  call Hloop_VA_Q(ntryL,G1H6(78),ex4(:),G1H3(5),m3h2x3(:,21),heltab2x6(:,:,36))
  call Hloop_QZ_A(ntryL,G1H6(83),ex5(:),G1H2(9),ngZd,m3h3x2(:,16),heltab2x6(:,:,37))
  call Hloop_Q_A(ntryL,G1H2(9),55,nMB,G2H2(36),n2h2(20))
call HGT_raise_alpha_OLR(G1H6(84),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(84),2,5,6)
  call Hloop_VA_Q(ntryL,G1H6(84),ex4(:),G1H3(6),m3h2x3(:,22),heltab2x6(:,:,38))
  call Hloop_QZ_A(ntryL,G1H6(88),ex5(:),G1H2(9),ngZd,m3h3x2(:,17),heltab2x6(:,:,39))
  call Hloop_Q_A(ntryL,G1H2(9),55,nMB,G2H2(37),n2h2(21))
  call Hloop_AZ_Q(ntryL,G1H6(89),ex5(:),G1H2(9),ngZd,m3h3x2(:,18),heltab2x6(:,:,40))
  call Hloop_A_Q(ntryL,G1H2(9),59,nMB,G2H2(38),n2h2(22))
call HGT_raise_alpha_OLR(G1H6(90),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(90),2,5,6)
  call Hloop_VQ_A(ntryL,G1H6(90),ex3(:),G1H3(7),m3h2x3(:,23),heltab2x6(:,:,41))
  call Hloop_AZ_Q(ntryL,G1H6(95),ex5(:),G1H2(9),ngZd,m3h3x2(:,19),heltab2x6(:,:,42))
  call Hloop_A_Q(ntryL,G1H2(9),59,nMB,G2H2(39),n2h2(23))
call HGT_raise_alpha_OLR(G1H6(96),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(96),2,5,6)
  call Hloop_VQ_A(ntryL,G1H6(96),ex3(:),G1H3(8),m3h2x3(:,24),heltab2x6(:,:,43))
  call Hloop_AZ_Q(ntryL,G1H6(100),ex5(:),G1H2(9),ngZd,m3h3x2(:,20),heltab2x6(:,:,44))
  call Hloop_A_Q(ntryL,G1H2(9),59,nMB,G2H2(40),n2h2(24))
  call Hotf_5pt_reduction(G2H2(1),RedSet_5(7),mass5set(:,3),  & 
G1H2(9),G1H2(10),G1H2(11),G1H2(12),G1H2(13),G1H2(14),2)
  call HG1shiftOLR(G1H2(10),8,2)
  call Hotf_5pt_reduction(G2H2(3),RedSet_5(8),mass5set(:,4),  & 
G1H2(15),G1H2(16),G1H2(17),G1H2(18),G1H2(19),G1H2(20),2)
  call HG1shiftOLR(G1H2(16),2,2)
  call Hotf_5pt_reduction(G2H2(5),RedSet_5(9),mass5set(:,3),  & 
G1H2(21),G1H2(22),G1H2(23),G1H2(24),G1H2(25),G1H2(26),2)
  call HG1shiftOLR(G1H2(22),8,2)
  call Hotf_5pt_reduction(G2H2(7),RedSet_5(10),mass5set(:,4),  & 
G1H2(27),G1H2(28),G1H2(29),G1H2(30),G1H2(31),G1H2(32),2)
  call HG1shiftOLR(G1H2(28),2,2)
  call Hotf_5pt_reduction(G2H3(1),RedSet_5(11),mass5set(:,5),  & 
G1H3(9),G1H3(10),G1H3(11),G1H3(12),G1H3(13),G1H3(14),3)
  call HG1shiftOLR(G1H3(10),16,3)
  call Hotf_5pt_reduction(G2H3(3),RedSet_5(12),mass5set(:,5),  & 
G1H3(15),G1H3(16),G1H3(17),G1H3(18),G1H3(19),G1H3(20),3)
  call HG1shiftOLR(G1H3(16),16,3)
  call Hotf_5pt_reduction(G2H3(5),RedSet_5(13),mass5set(:,5),  & 
G1H3(21),G1H3(22),G1H3(23),G1H3(24),G1H3(25),G1H3(26),3)
  call HG1shiftOLR(G1H3(22),16,3)
  call Hotf_5pt_reduction(G2H3(7),RedSet_5(14),mass5set(:,5),  & 
G1H3(27),G1H3(28),G1H3(29),G1H3(30),G1H3(31),G1H3(32),3)
  call HG1shiftOLR(G1H3(28),16,3)
  call Hotf_5pt_reduction(G2H3(9),RedSet_5(15),mass5set(:,6),  & 
G1H3(33),G1H3(34),G1H3(35),G1H3(36),G1H3(37),G1H3(38),3)
  call HG1shiftOLR(G1H3(34),16,3)
  call Hotf_5pt_reduction(G2H3(11),RedSet_5(16),mass5set(:,6),  & 
G1H3(39),G1H3(40),G1H3(41),G1H3(42),G1H3(43),G1H3(44),3)
  call HG1shiftOLR(G1H3(40),16,3)
  call Hotf_5pt_reduction(G2H3(13),RedSet_5(17),mass5set(:,6),  & 
G1H3(45),G1H3(46),G1H3(47),G1H3(48),G1H3(49),G1H3(50),3)
  call HG1shiftOLR(G1H3(46),16,3)
  call Hotf_5pt_reduction(G2H3(15),RedSet_5(18),mass5set(:,6),  & 
G1H3(51),G1H3(52),G1H3(53),G1H3(54),G1H3(55),G1H3(56),3)
  call HG1shiftOLR(G1H3(52),16,3)
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(17),ex4(:),G2tensor(1),m3h2x1(:,1),heltab2x2(:,:,1))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(20),ex3(:),G2tensor(2),m3h2x1(:,2),heltab2x2(:,:,2))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(23),ex4(:),G2tensor(3),m3h2x1(:,3),heltab2x2(:,:,3))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(26),ex3(:),G2tensor(4),m3h2x1(:,4),heltab2x2(:,:,4))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(29),ex4(:),G2tensor(5),m3h2x1(:,5),heltab2x2(:,:,5))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(32),ex3(:),G2tensor(6),m3h2x1(:,6),heltab2x2(:,:,6))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(35),ex4(:),G2tensor(7),m3h2x1(:,7),heltab2x2(:,:,7))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(38),ex3(:),G2tensor(8),m3h2x1(:,8),heltab2x2(:,:,8))
  call Hloop_VA_Q(ntryL,G1H2(9),ex4(:),G1H1(1),m3h2x1(:,9),heltab2x2(:,:,9))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(9),n2h1(1))
  call Hloop_VA_Q(ntryL,G1H2(10),ex4(:),G1H1(1),m3h2x1(:,10),heltab2x2(:,:,10))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(10),n2h1(2))
  call Hloop_VA_Q(ntryL,G1H2(15),ex2(:),G1H1(1),m3h2x1(:,11),heltab2x2(:,:,11))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(11),n2h1(3))
  call Hloop_VA_Q(ntryL,G1H2(16),ex2(:),G1H1(1),m3h2x1(:,12),heltab2x2(:,:,12))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMT,G2tensor(12),n2h1(4))
  call Hloop_VA_Q(ntryL,G1H2(21),ex4(:),G1H1(1),m3h2x1(:,13),heltab2x2(:,:,13))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(13),n2h1(5))
  call Hloop_VA_Q(ntryL,G1H2(22),ex4(:),G1H1(1),m3h2x1(:,14),heltab2x2(:,:,14))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(14),n2h1(6))
  call Hloop_VA_Q(ntryL,G1H2(27),ex2(:),G1H1(1),m3h2x1(:,15),heltab2x2(:,:,15))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(15),n2h1(7))
  call Hloop_VA_Q(ntryL,G1H2(28),ex2(:),G1H1(1),m3h2x1(:,16),heltab2x2(:,:,16))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMT,G2tensor(16),n2h1(8))
  call Hloop_QZ_A(ntryL,G1H3(9),ex5(:),G1H1(1),ngZd,m3h3x1(:,1),heltab2x3(:,:,1))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(17),n2h1(9))
  call Hloop_QZ_A(ntryL,G1H3(10),ex5(:),G1H1(1),ngZd,m3h3x1(:,2),heltab2x3(:,:,2))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(18),n2h1(10))
  call Hloop_AZ_Q(ntryL,G1H3(15),ex5(:),G1H1(1),ngZd,m3h3x1(:,3),heltab2x3(:,:,3))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(19),n2h1(11))
  call Hloop_AZ_Q(ntryL,G1H3(16),ex5(:),G1H1(1),ngZd,m3h3x1(:,4),heltab2x3(:,:,4))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(20),n2h1(12))
  call Hloop_QZ_A(ntryL,G1H3(21),ex5(:),G1H1(1),ngZd,m3h3x1(:,5),heltab2x3(:,:,5))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(21),n2h1(13))
  call Hloop_QZ_A(ntryL,G1H3(22),ex5(:),G1H1(1),ngZd,m3h3x1(:,6),heltab2x3(:,:,6))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(22),n2h1(14))
  call Hloop_AZ_Q(ntryL,G1H3(27),ex5(:),G1H1(1),ngZd,m3h3x1(:,7),heltab2x3(:,:,7))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(23),n2h1(15))
  call Hloop_AZ_Q(ntryL,G1H3(28),ex5(:),G1H1(1),ngZd,m3h3x1(:,8),heltab2x3(:,:,8))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(24),n2h1(16))
  call Hloop_QZ_A(ntryL,G1H3(33),ex5(:),G1H1(1),ngZu,m3h3x1(:,9),heltab2x3(:,:,9))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(25),n2h1(17))
  call Hloop_QZ_A(ntryL,G1H3(34),ex5(:),G1H1(1),ngZu,m3h3x1(:,10),heltab2x3(:,:,10))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMT,G2tensor(26),n2h1(18))
  call Hloop_AZ_Q(ntryL,G1H3(39),ex5(:),G1H1(1),ngZu,m3h3x1(:,11),heltab2x3(:,:,11))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(27),n2h1(19))
  call Hloop_AZ_Q(ntryL,G1H3(40),ex5(:),G1H1(1),ngZu,m3h3x1(:,12),heltab2x3(:,:,12))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nMT,G2tensor(28),n2h1(20))
  call Hloop_QZ_A(ntryL,G1H3(45),ex5(:),G1H1(1),ngZu,m3h3x1(:,13),heltab2x3(:,:,13))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(29),n2h1(21))
  call Hloop_QZ_A(ntryL,G1H3(46),ex5(:),G1H1(1),ngZu,m3h3x1(:,14),heltab2x3(:,:,14))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMT,G2tensor(30),n2h1(22))
  call Hloop_AZ_Q(ntryL,G1H3(51),ex5(:),G1H1(1),ngZu,m3h3x1(:,15),heltab2x3(:,:,15))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(31),n2h1(23))
  call Hloop_AZ_Q(ntryL,G1H3(52),ex5(:),G1H1(1),ngZu,m3h3x1(:,16),heltab2x3(:,:,16))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nMT,G2tensor(32),n2h1(24))
  call Hotf_5pt_reduction_last(G2tensor(1),RedSet_5(1),mass5set(:,1),  & 
G1tensor(1),G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(5),G1tensor(6))
  call G_TensorShift(G1tensor(2),8)
  call Hotf_5pt_reduction_last(G2tensor(2),RedSet_5(1),mass5set(:,1),  & 
G1tensor(7),G1tensor(8),G1tensor(9),G1tensor(10),G1tensor(11),G1tensor(12))
  call G_TensorShift(G1tensor(8),4)
  call Hotf_5pt_reduction_last(G2tensor(3),RedSet_5(2),mass5set(:,1),  & 
G1tensor(13),G1tensor(14),G1tensor(15),G1tensor(16),G1tensor(17),G1tensor(18))
  call G_TensorShift(G1tensor(14),8)
  call Hotf_5pt_reduction_last(G2tensor(4),RedSet_5(2),mass5set(:,1),  & 
G1tensor(19),G1tensor(20),G1tensor(21),G1tensor(22),G1tensor(23),G1tensor(24))
  call G_TensorShift(G1tensor(20),4)
  call Hotf_5pt_reduction_last(G2tensor(5),RedSet_5(3),mass5set(:,2),  & 
G1tensor(25),G1tensor(26),G1tensor(27),G1tensor(28),G1tensor(29),G1tensor(30))
  call G_TensorShift(G1tensor(26),8)
  call Hotf_5pt_reduction_last(G2tensor(6),RedSet_5(4),mass5set(:,2),  & 
G1tensor(31),G1tensor(32),G1tensor(33),G1tensor(34),G1tensor(35),G1tensor(36))
  call G_TensorShift(G1tensor(32),4)
  call Hotf_5pt_reduction_last(G2tensor(7),RedSet_5(5),mass5set(:,2),  & 
G1tensor(37),G1tensor(38),G1tensor(39),G1tensor(40),G1tensor(41),G1tensor(42))
  call G_TensorShift(G1tensor(38),8)
  call Hotf_5pt_reduction_last(G2tensor(8),RedSet_5(6),mass5set(:,2),  & 
G1tensor(43),G1tensor(44),G1tensor(45),G1tensor(46),G1tensor(47),G1tensor(48))
  call G_TensorShift(G1tensor(44),4)
  call Hotf_5pt_reduction_last(G2tensor(9),RedSet_5(7),mass5set(:,3),  & 
G1tensor(49),G1tensor(50),G1tensor(51),G1tensor(52),G1tensor(53),G1tensor(54))
  call G_TensorShift(G1tensor(50),8)
  call Hotf_5pt_reduction_last(G2tensor(11),RedSet_5(8),mass5set(:,4),  & 
G1tensor(55),G1tensor(56),G1tensor(57),G1tensor(58),G1tensor(59),G1tensor(60))
  call G_TensorShift(G1tensor(56),2)
  call Hotf_5pt_reduction_last(G2tensor(13),RedSet_5(9),mass5set(:,3),  & 
G1tensor(61),G1tensor(62),G1tensor(63),G1tensor(64),G1tensor(65),G1tensor(66))
  call G_TensorShift(G1tensor(62),8)
  call Hotf_5pt_reduction_last(G2tensor(15),RedSet_5(10),mass5set(:,4),  & 
G1tensor(67),G1tensor(68),G1tensor(69),G1tensor(70),G1tensor(71),G1tensor(72))
  call G_TensorShift(G1tensor(68),2)
  call Hotf_5pt_reduction_last(G2tensor(17),RedSet_5(11),mass5set(:,5),  & 
G1tensor(73),G1tensor(74),G1tensor(75),G1tensor(76),G1tensor(77),G1tensor(78))
  call G_TensorShift(G1tensor(74),16)
  call Hotf_5pt_reduction_last(G2tensor(19),RedSet_5(12),mass5set(:,5),  & 
G1tensor(79),G1tensor(80),G1tensor(81),G1tensor(82),G1tensor(83),G1tensor(84))
  call G_TensorShift(G1tensor(80),16)
  call Hotf_5pt_reduction_last(G2tensor(21),RedSet_5(13),mass5set(:,5),  & 
G1tensor(85),G1tensor(86),G1tensor(87),G1tensor(88),G1tensor(89),G1tensor(90))
  call G_TensorShift(G1tensor(86),16)
  call Hotf_5pt_reduction_last(G2tensor(23),RedSet_5(14),mass5set(:,5),  & 
G1tensor(91),G1tensor(92),G1tensor(93),G1tensor(94),G1tensor(95),G1tensor(96))
  call G_TensorShift(G1tensor(92),16)
  call Hotf_5pt_reduction_last(G2tensor(25),RedSet_5(15),mass5set(:,6),  & 
G1tensor(97),G1tensor(98),G1tensor(99),G1tensor(100),G1tensor(101),G1tensor(102))
  call G_TensorShift(G1tensor(98),16)
  call Hotf_5pt_reduction_last(G2tensor(27),RedSet_5(16),mass5set(:,6),  & 
G1tensor(103),G1tensor(104),G1tensor(105),G1tensor(106),G1tensor(107),G1tensor(108))
  call G_TensorShift(G1tensor(104),16)
  call Hotf_5pt_reduction_last(G2tensor(29),RedSet_5(17),mass5set(:,6),  & 
G1tensor(109),G1tensor(110),G1tensor(111),G1tensor(112),G1tensor(113),G1tensor(114))
  call G_TensorShift(G1tensor(110),16)
  call Hotf_5pt_reduction_last(G2tensor(31),RedSet_5(18),mass5set(:,6),  & 
G1tensor(115),G1tensor(116),G1tensor(117),G1tensor(118),G1tensor(119),G1tensor(120))
  call G_TensorShift(G1tensor(116),16)
  call ol_merge_tensors(T1sum(1),[G1tensor(1)])
  call ol_merge_tensors(T1sum(2),[G1tensor(7)])
  call ol_merge_tensors(T1sum(3),[G1tensor(13)])
  call ol_merge_tensors(T1sum(4),[G1tensor(19)])
  call ol_merge_tensors(T1sum(5),[G1tensor(25)])
  call ol_merge_tensors(T1sum(6),[G1tensor(31)])
  call ol_merge_tensors(T1sum(7),[G1tensor(37)])
  call ol_merge_tensors(T1sum(8),[G1tensor(43)])
  call ol_merge_tensors(T1sum(9),[G1tensor(49)])
  call ol_merge_tensors(T1sum(10),[G1tensor(55)])
  call ol_merge_tensors(T1sum(11),[G1tensor(61)])
  call ol_merge_tensors(T1sum(12),[G1tensor(67)])
  call ol_merge_tensors(T1sum(13),[G1tensor(73)])
  call ol_merge_tensors(T1sum(14),[G1tensor(79)])
  call ol_merge_tensors(T1sum(15),[G1tensor(85)])
  call ol_merge_tensors(T1sum(16),[G1tensor(91)])
  call ol_merge_tensors(T1sum(17),[G1tensor(97)])
  call ol_merge_tensors(T1sum(18),[G1tensor(103)])
  call ol_merge_tensors(T1sum(19),[G1tensor(109)])
  call ol_merge_tensors(T1sum(20),[G1tensor(115)])
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)+c(11)*M(3,:)%j-c(10)*M(4,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(21),h0tab(:,21),[32,3,16,4,8],[nMB,nMB,nMB,0,nMB],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,21),heltab2x96(:,:,21))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMB,G1H48(1),n2h48(13))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)+c(11)*M(2,:)%j-c(10)*M(4,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(22),h0tab(:,22),[32,3,8,4,16],[nMB,nMB,0,nMB,nMB],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,22),heltab2x96(:,:,22))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMB,G1H48(2),n2h48(14))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)+c(11)*M(2,:)%j-c(10)*M(4,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(23),h0tab(:,23),[32,3,16,8,4],[nMB,nMB,nMB,0,nMB],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,23),heltab2x96(:,:,23))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMB,G1H48(3),n2h48(15))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)+c(11)*M(2,:)%j-c(10)*M(4,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(24),h0tab(:,24),[32,4,8,3,16],[nMB,0,nMB,nMB,nMB],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,24),heltab2x96(:,:,24))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMB,G1H48(4),n2h48(16))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)+c(11)*M(3,:)%j-c(10)*M(4,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(25),h0tab(:,25),[32,3,4,8,16],[nMB,nMB,0,nMB,nMB],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,25),heltab2x96(:,:,25))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMB,G1H48(5),n2h48(17))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)+c(11)*M(3,:)%j-c(10)*M(4,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(26),h0tab(:,26),[32,8,4,3,16],[nMB,0,nMB,nMB,nMB],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,26),heltab2x96(:,:,26))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMB,G1H48(6),n2h48(18))
  Gcoeff(:)%j = (-(c(19)*M(2,:)%j)+c(14)*(-M(1,:)%j+M(4,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(27),h0tab(:,27),[32,3,8,16,4],[0,0,nMB,nMB,0],5,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(7),m3h2x48(:,27),heltab2x96(:,:,27))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(28),h0tab(:,28),[32,4,16,3,8],[0,nMB,nMB,nMB,0],5,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(8),m3h2x48(:,28),heltab2x96(:,:,28))
  Gcoeff(:)%j = (-(c(19)*M(3,:)%j)+c(14)*(-M(1,:)%j+M(4,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(29),h0tab(:,29),[32,3,4,16,8],[0,0,nMB,nMB,0],5,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(9),m3h2x48(:,29),heltab2x96(:,:,29))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(30),h0tab(:,30),[32,8,3,4,16],[nMB,0,0,nMB,nMB],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,30),heltab2x96(:,:,30))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMB,G1H48(10),n2h48(19))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(31),h0tab(:,31),[32,4,3,16,8],[0,nMB,nMB,nMB,0],5,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(11),m3h2x48(:,31),heltab2x96(:,:,31))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(32),h0tab(:,32),[32,4,3,8,16],[nMB,0,0,nMB,nMB],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,32),heltab2x96(:,:,32))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMB,G1H48(12),n2h48(20))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)+c(11)*M(2,:)%j-c(14)*M(4,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(33),h0tab(:,33),[32,2,1,16,12],[nMT,0,nMT,nMT,nMT],5,1,wf4(:,7))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,33),heltab2x96(:,:,33))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(13),n2h48(21))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)+c(11)*M(3,:)%j-c(14)*M(4,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(34),h0tab(:,34),[32,12,2,1,16],[nMT,nMT,0,nMT,nMT],5,1,wf4(:,7))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,34),heltab2x96(:,:,34))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(14),n2h48(22))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)+c(11)*M(3,:)%j-c(14)*M(4,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(35),h0tab(:,35),[32,1,2,16,12],[nMT,0,nMT,nMT,nMT],5,1,wf4(:,7))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,35),heltab2x96(:,:,35))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(15),n2h48(23))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)+c(11)*M(3,:)%j-c(14)*M(4,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(36),h0tab(:,36),[32,1,2,12,16],[nMT,0,nMT,nMT,nMT],5,1,wf4(:,7))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,36),heltab2x96(:,:,36))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(16),n2h48(24))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)+c(11)*M(2,:)%j-c(14)*M(4,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(37),h0tab(:,37),[32,12,1,2,16],[nMT,nMT,0,nMT,nMT],5,1,wf4(:,7))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,37),heltab2x96(:,:,37))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(17),n2h48(25))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)+c(11)*M(2,:)%j-c(14)*M(4,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(38),h0tab(:,38),[32,2,1,12,16],[nMT,0,nMT,nMT,nMT],5,1,wf4(:,7))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,38),heltab2x96(:,:,38))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(18),n2h48(26))
  Gcoeff(:)%j = (-(c(19)*M(3,:)%j)+c(14)*(M(1,:)%j-M(4,:)%j)) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(39),h0tab(:,39),[32,1,16,2,12],[0,nMT,nMT,0,0],5,1,wf4(:,7))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(19),m3h2x48(:,39),heltab2x96(:,:,39))
  Gcoeff(:)%j = (-(c(4)*M(4,:)%j)) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(40),h0tab(:,40),[32,1,16,12,2],[0,nMT,nMT,nMT,0],5,1,wf4(:,7))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(20),m3h2x48(:,40),heltab2x96(:,:,40))
  Gcoeff(:)%j = (-(c(19)*M(2,:)%j)+c(14)*(M(1,:)%j-M(4,:)%j)) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(41),h0tab(:,41),[32,2,16,1,12],[0,nMT,nMT,0,0],5,1,wf4(:,7))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(21),m3h2x48(:,41),heltab2x96(:,:,41))
  Gcoeff(:)%j = (-(c(4)*M(4,:)%j)) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(42),h0tab(:,42),[32,2,12,1,16],[nMT,0,0,nMT,nMT],5,1,wf4(:,7))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,42),heltab2x96(:,:,42))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(22),n2h48(27))
  Gcoeff(:)%j = (-(c(4)*M(4,:)%j)) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(43),h0tab(:,43),[32,1,12,16,2],[0,nMT,nMT,nMT,0],5,1,wf4(:,7))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(23),m3h2x48(:,43),heltab2x96(:,:,43))
  Gcoeff(:)%j = (c(4)*M(4,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(44),h0tab(:,44),[32,1,12,2,16],[nMT,0,0,nMT,nMT],5,1,wf4(:,7))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,44),heltab2x96(:,:,44))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(24),n2h48(28))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)+c(11)*(M(2,:)%j+M(3,:)%j)) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(45),h0tab(:,45),[32,2,4,8,17],[nMT,0,nMB,0,nMT],5,1,wf6(:,6))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,45),heltab2x96(:,:,45))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(25),n2h48(29))
  Gcoeff(:)%j = (-(c(3)*M(2,:)%j)-c(5)*M(3,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(46),h0tab(:,46),[32,8,4,2,17],[0,nMB,0,nMT,0],5,1,wf6(:,6))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(26),m3h2x48(:,46),heltab2x96(:,:,46))
  Gcoeff(:)%j = (c(11)*(M(2,:)%j+M(3,:)%j)-c(10)*M(4,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(47),h0tab(:,47),[32,4,2,17,8],[nMB,0,nMT,0,nMB],5,1,wf6(:,6))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,47),heltab2x96(:,:,47))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMB,G1H48(27),n2h48(30))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)+c(11)*(M(2,:)%j+M(3,:)%j)-c(14)*M(4,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(48),h0tab(:,48),[32,2,8,4,17],[nMT,0,nMB,0,nMT],5,1,wf6(:,6))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,48),heltab2x96(:,:,48))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(28),n2h48(31))
  Gcoeff(:)%j = (c(3)*(-M(2,:)%j+M(3,:)%j)+c(4)*(-M(1,:)%j+M(4,:)%j)) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(49),h0tab(:,49),[32,4,8,2,17],[0,nMB,0,nMT,0],5,1,wf6(:,6))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(29),m3h2x48(:,49),heltab2x96(:,:,49))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)+c(11)*(M(2,:)%j+M(3,:)%j)-c(10)*M(4,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(50),h0tab(:,50),[32,4,17,2,8],[nMB,0,nMT,0,nMB],5,1,wf6(:,6))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,50),heltab2x96(:,:,50))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMB,G1H48(30),n2h48(32))
  Gcoeff(:)%j = (-(c(5)*M(2,:)%j)-c(3)*M(3,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(51),h0tab(:,51),[32,2,17,8,4],[0,nMT,0,nMB,0],5,1,wf6(:,6))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(31),m3h2x48(:,51),heltab2x96(:,:,51))
  Gcoeff(:)%j = (c(3)*(M(2,:)%j-M(3,:)%j)+c(4)*(-M(1,:)%j+M(4,:)%j)) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(52),h0tab(:,52),[32,2,17,4,8],[0,nMT,0,nMB,0],5,1,wf6(:,6))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(32),m3h2x48(:,52),heltab2x96(:,:,52))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)+c(11)*(M(2,:)%j+M(3,:)%j)-c(14)*M(4,:)%j) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(53),h0tab(:,53),[32,1,4,8,18],[nMT,0,nMB,0,nMT],5,1,wf6(:,8))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,53),heltab2x96(:,:,53))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(33),n2h48(33))
  Gcoeff(:)%j = (c(3)*(-M(2,:)%j+M(3,:)%j)+c(4)*(M(1,:)%j-M(4,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(54),h0tab(:,54),[32,8,4,1,18],[0,nMB,0,nMT,0],5,1,wf6(:,8))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(34),m3h2x48(:,54),heltab2x96(:,:,54))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)+c(11)*(M(2,:)%j+M(3,:)%j)-c(10)*M(4,:)%j) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(55),h0tab(:,55),[32,4,1,18,8],[nMB,0,nMT,0,nMB],5,1,wf6(:,8))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,55),heltab2x96(:,:,55))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMB,G1H48(35),n2h48(34))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)+c(11)*(M(2,:)%j+M(3,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(56),h0tab(:,56),[32,1,8,4,18],[nMT,0,nMB,0,nMT],5,1,wf6(:,8))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,56),heltab2x96(:,:,56))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(36),n2h48(35))
  Gcoeff(:)%j = (c(5)*M(2,:)%j+c(3)*M(3,:)%j) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(57),h0tab(:,57),[32,4,8,1,18],[0,nMB,0,nMT,0],5,1,wf6(:,8))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(37),m3h2x48(:,57),heltab2x96(:,:,57))
  Gcoeff(:)%j = (c(11)*(M(2,:)%j+M(3,:)%j)-c(10)*M(4,:)%j) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(58),h0tab(:,58),[32,4,18,1,8],[nMB,0,nMT,0,nMB],5,1,wf6(:,8))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,58),heltab2x96(:,:,58))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMB,G1H48(38),n2h48(36))
  Gcoeff(:)%j = (c(3)*(M(2,:)%j-M(3,:)%j)+c(4)*(M(1,:)%j-M(4,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(59),h0tab(:,59),[32,1,18,8,4],[0,nMT,0,nMB,0],5,1,wf6(:,8))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(39),m3h2x48(:,59),heltab2x96(:,:,59))
  Gcoeff(:)%j = (c(3)*M(2,:)%j+c(5)*M(3,:)%j) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(60),h0tab(:,60),[32,1,18,4,8],[0,nMT,0,nMB,0],5,1,wf6(:,8))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(40),m3h2x48(:,60),heltab2x96(:,:,60))
  Gcoeff(:)%j = (-(c(5)*M(2,:)%j)-c(3)*M(3,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(61),h0tab(:,61),[32,2,1,8,20],[0,nMT,0,nMB,0],5,1,wf6(:,2))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(41),m3h2x48(:,61),heltab2x96(:,:,61))
  Gcoeff(:)%j = (c(11)*(M(2,:)%j+M(3,:)%j)-c(10)*M(4,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(62),h0tab(:,62),[32,8,1,2,20],[nMB,0,nMT,0,nMB],5,1,wf6(:,2))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,62),heltab2x96(:,:,62))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMB,G1H48(42),n2h48(37))
  Gcoeff(:)%j = (c(3)*(M(2,:)%j-M(3,:)%j)+c(4)*(M(1,:)%j-M(4,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(63),h0tab(:,63),[32,1,2,8,20],[0,nMT,0,nMB,0],5,1,wf6(:,2))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(43),m3h2x48(:,63),heltab2x96(:,:,63))
  Gcoeff(:)%j = (c(3)*M(2,:)%j+c(5)*M(3,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(64),h0tab(:,64),[32,1,2,20,8],[0,nMT,0,nMB,0],5,1,wf6(:,2))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(44),m3h2x48(:,64),heltab2x96(:,:,64))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)+c(11)*(M(2,:)%j+M(3,:)%j)-c(10)*M(4,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(65),h0tab(:,65),[32,8,2,1,20],[nMB,0,nMT,0,nMB],5,1,wf6(:,2))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,65),heltab2x96(:,:,65))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMB,G1H48(45),n2h48(38))
  Gcoeff(:)%j = (c(3)*(M(2,:)%j-M(3,:)%j)+c(4)*(-M(1,:)%j+M(4,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(66),h0tab(:,66),[32,2,1,20,8],[0,nMT,0,nMB,0],5,1,wf6(:,2))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(46),m3h2x48(:,66),heltab2x96(:,:,66))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)+c(11)*(M(2,:)%j+M(3,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(67),h0tab(:,67),[32,1,8,20,2],[nMT,0,nMB,0,nMT],5,1,wf6(:,2))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,67),heltab2x96(:,:,67))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(47),n2h48(39))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)+c(11)*(M(2,:)%j+M(3,:)%j)-c(14)*M(4,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(68),h0tab(:,68),[32,1,20,8,2],[nMT,0,nMB,0,nMT],5,1,wf6(:,2))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,68),heltab2x96(:,:,68))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(48),n2h48(40))
  Gcoeff(:)%j = (c(3)*(M(2,:)%j-M(3,:)%j)+c(4)*(-M(1,:)%j+M(4,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(69),h0tab(:,69),[32,2,1,4,24],[0,nMT,0,nMB,0],5,1,wf6(:,4))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(49),m3h2x48(:,69),heltab2x96(:,:,69))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)+c(11)*(M(2,:)%j+M(3,:)%j)-c(10)*M(4,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(70),h0tab(:,70),[32,4,1,2,24],[nMB,0,nMT,0,nMB],5,1,wf6(:,4))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,70),heltab2x96(:,:,70))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMB,G1H48(50),n2h48(41))
  Gcoeff(:)%j = (c(3)*M(2,:)%j+c(5)*M(3,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(71),h0tab(:,71),[32,1,2,4,24],[0,nMT,0,nMB,0],5,1,wf6(:,4))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(51),m3h2x48(:,71),heltab2x96(:,:,71))
  Gcoeff(:)%j = (c(3)*(M(2,:)%j-M(3,:)%j)+c(4)*(M(1,:)%j-M(4,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(72),h0tab(:,72),[32,1,2,24,4],[0,nMT,0,nMB,0],5,1,wf6(:,4))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(52),m3h2x48(:,72),heltab2x96(:,:,72))
  Gcoeff(:)%j = (c(11)*(M(2,:)%j+M(3,:)%j)-c(10)*M(4,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(73),h0tab(:,73),[32,4,2,1,24],[nMB,0,nMT,0,nMB],5,1,wf6(:,4))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,73),heltab2x96(:,:,73))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMB,G1H48(53),n2h48(42))
  Gcoeff(:)%j = (-(c(5)*M(2,:)%j)-c(3)*M(3,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(74),h0tab(:,74),[32,2,1,24,4],[0,nMT,0,nMB,0],5,1,wf6(:,4))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(54),m3h2x48(:,74),heltab2x96(:,:,74))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)+c(11)*(M(2,:)%j+M(3,:)%j)-c(14)*M(4,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(75),h0tab(:,75),[32,1,4,24,2],[nMT,0,nMB,0,nMT],5,1,wf6(:,4))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,75),heltab2x96(:,:,75))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(55),n2h48(43))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)+c(11)*(M(2,:)%j+M(3,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(76),h0tab(:,76),[32,1,24,4,2],[nMT,0,nMB,0,nMT],5,1,wf6(:,4))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,76),heltab2x96(:,:,76))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(56),n2h48(44))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)-c(17)*M(3,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(77),h0tab(:,77),[33,8,4,2,16],[0,nMB,0,nMT,nMT],5,1,wf4(:,10))
  call Hloop_AQ_V(ntryL,G0H96(1),wf4(:,10),G0H24(1),m3h4x24(:,1),heltab2x96(:,:,77))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)-c(17)*M(3,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(78),h0tab(:,78),[33,2,4,16,8],[nMT,0,nMB,nMB,0],5,1,wf4(:,10))
  call Hloop_VQ_A(ntryL,G0H96(1),wf4(:,10),G0H24(2),m3h4x24(:,2),heltab2x96(:,:,78))
  call Hloop_Q_A(ntryL,G0H24(2),33,nMT,G1H24(13),n2h24(13))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)+c(12)*M(3,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(79),h0tab(:,79),[33,4,8,2,16],[0,nMB,0,nMT,nMT],5,1,wf4(:,10))
  call Hloop_AQ_V(ntryL,G0H96(1),wf4(:,10),G0H24(2),m3h4x24(:,3),heltab2x96(:,:,79))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)+c(12)*M(3,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(80),h0tab(:,80),[33,2,8,16,4],[nMT,0,nMB,nMB,0],5,1,wf4(:,10))
  call Hloop_VQ_A(ntryL,G0H96(1),wf4(:,10),G0H24(3),m3h4x24(:,4),heltab2x96(:,:,80))
  call Hloop_Q_A(ntryL,G0H24(3),33,nMT,G1H24(1),n2h24(14))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)+c(12)*M(2,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(81),h0tab(:,81),[34,8,4,1,16],[0,nMB,0,nMT,nMT],5,1,wf4(:,8))
  call Hloop_QA_V(ntryL,G0H96(1),wf4(:,8),G0H24(3),m3h4x24(:,5),heltab2x96(:,:,81))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)+c(12)*M(2,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(82),h0tab(:,82),[34,1,4,16,8],[nMT,0,nMB,nMB,0],5,1,wf4(:,8))
  call Hloop_VA_Q(ntryL,G0H96(1),wf4(:,8),G0H24(4),m3h4x24(:,6),heltab2x96(:,:,82))
  call Hloop_A_Q(ntryL,G0H24(4),34,nMT,G1H24(3),n2h24(15))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)-c(17)*M(2,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(83),h0tab(:,83),[34,4,8,1,16],[0,nMB,0,nMT,nMT],5,1,wf4(:,8))
  call Hloop_QA_V(ntryL,G0H96(1),wf4(:,8),G0H24(4),m3h4x24(:,7),heltab2x96(:,:,83))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)-c(17)*M(2,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(84),h0tab(:,84),[34,1,8,16,4],[nMT,0,nMB,nMB,0],5,1,wf4(:,8))
  call Hloop_VA_Q(ntryL,G0H96(1),wf4(:,8),G0H24(5),m3h4x24(:,8),heltab2x96(:,:,84))
  call Hloop_A_Q(ntryL,G0H24(5),34,nMT,G1H24(4),n2h24(16))
  Gcoeff(:)%j = (-(c(17)*M(2,:)%j)-c(10)*M(4,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(85),h0tab(:,85),[36,2,1,8,16],[0,nMT,0,nMB,nMB],5,1,wf4(:,5))
  call Hloop_AQ_V(ntryL,G0H96(1),wf4(:,5),G0H24(5),m3h4x24(:,9),heltab2x96(:,:,85))
  Gcoeff(:)%j = (c(12)*M(2,:)%j-c(15)*M(4,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(86),h0tab(:,86),[36,1,2,8,16],[0,nMT,0,nMB,nMB],5,1,wf4(:,5))
  call Hloop_AQ_V(ntryL,G0H96(1),wf4(:,5),G0H24(6),m3h4x24(:,10),heltab2x96(:,:,86))
  Gcoeff(:)%j = (-(c(17)*M(2,:)%j)-c(10)*M(4,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(87),h0tab(:,87),[36,2,16,1,8],[0,nMT,nMT,0,nMB],5,1,wf4(:,5))
  call Hloop_AQ_V(ntryL,G0H96(1),wf4(:,5),G0H24(7),m3h4x24(:,11),heltab2x96(:,:,87))
  Gcoeff(:)%j = (c(12)*M(2,:)%j-c(15)*M(4,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(88),h0tab(:,88),[36,1,16,2,8],[0,nMT,nMT,0,nMB],5,1,wf4(:,5))
  call Hloop_AQ_V(ntryL,G0H96(1),wf4(:,5),G0H24(8),m3h4x24(:,12),heltab2x96(:,:,88))
  Gcoeff(:)%j = (c(12)*M(3,:)%j-c(15)*M(4,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(89),h0tab(:,89),[40,2,1,4,16],[0,nMT,0,nMB,nMB],5,1,wf4(:,3))
  call Hloop_QA_V(ntryL,G0H96(1),wf4(:,3),G0H24(9),m3h4x24(:,13),heltab2x96(:,:,89))
  Gcoeff(:)%j = (-(c(17)*M(3,:)%j)-c(10)*M(4,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(90),h0tab(:,90),[40,1,2,4,16],[0,nMT,0,nMB,nMB],5,1,wf4(:,3))
  call Hloop_QA_V(ntryL,G0H96(1),wf4(:,3),G0H24(10),m3h4x24(:,14),heltab2x96(:,:,90))
  Gcoeff(:)%j = (c(12)*M(3,:)%j-c(15)*M(4,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(91),h0tab(:,91),[40,2,16,1,4],[0,nMT,nMT,0,nMB],5,1,wf4(:,3))
  call Hloop_QA_V(ntryL,G0H96(1),wf4(:,3),G0H24(11),m3h4x24(:,15),heltab2x96(:,:,91))
  Gcoeff(:)%j = (-(c(17)*M(3,:)%j)-c(10)*M(4,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(92),h0tab(:,92),[40,1,16,2,4],[0,nMT,nMT,0,nMB],5,1,wf4(:,3))
  call Hloop_QA_V(ntryL,G0H96(1),wf4(:,3),G0H24(12),m3h4x24(:,16),heltab2x96(:,:,92))
  call Hloop_AZ_Q(ntryL,G1H24(2),ex5(:),G1H8(1),ngZu,m3h3x8(:,17),heltab2x24(:,:,37))
  call Hloop_A_Q(ntryL,G1H8(1),50,nMT,G2H8(1),n2h8(17))
  call Hloop_AZ_Q(ntryL,G1H24(8),ex5(:),G1H8(1),ngZu,m3h3x8(:,18),heltab2x24(:,:,38))
  call Hloop_A_Q(ntryL,G1H8(1),50,nMT,G2H8(3),n2h8(18))
  call Hloop_QZ_A(ntryL,G1H24(15),ex5(:),G1H8(1),ngZu,m3h3x8(:,19),heltab2x24(:,:,39))
  call Hloop_Q_A(ntryL,G1H8(1),49,nMT,G2H8(4),n2h8(19))
  call Hloop_QZ_A(ntryL,G1H24(21),ex5(:),G1H8(1),ngZu,m3h3x8(:,20),heltab2x24(:,:,40))
  call Hloop_Q_A(ntryL,G1H8(1),49,nMT,G2H8(5),n2h8(20))
  call Hloop_AV_Q(ntryL,G1H48(1),wf4(:,1),G1H12(5),m3h4x12(:,1),heltab2x48(:,:,21))
  call Hloop_A_Q(ntryL,G1H12(5),35,nMB,G2H12(5),n2h12(21))
  call Hloop_QV_A(ntryL,G1H48(2),wf4(:,1),G1H12(6),m3h4x12(:,2),heltab2x48(:,:,22))
  call Hloop_Q_A(ntryL,G1H12(6),35,nMB,G2H12(6),n2h12(22))
  call Hloop_QV_A(ntryL,G1H48(3),wf4(:,1),G1H12(9),m3h4x12(:,3),heltab2x48(:,:,23))
  call Hloop_Q_A(ntryL,G1H12(9),35,nMB,G2H12(7),n2h12(23))
  call Hloop_AQ_V(ntryL,G1H48(4),ex3(:),G1H24(5),m3h2x24(:,21),heltab2x48(:,:,24))
  call Hloop_AV_Q(ntryL,G1H48(5),wf4(:,1),G1H12(10),m3h4x12(:,4),heltab2x48(:,:,25))
  call Hloop_A_Q(ntryL,G1H12(10),35,nMB,G2H12(8),n2h12(24))
  call Hloop_QA_V(ntryL,G1H48(6),ex4(:),G1H24(6),m3h2x24(:,22),heltab2x48(:,:,26))
  call Hloop_UV_W(ntryL,G1H48(7),32,wf4(:,1),3,G2H12(9),m3h4x12(:,5),heltab2x48(:,:,27))
  call Hloop_VQ_A(ntryL,G1H48(8),ex3(:),G1H24(7),m3h2x24(:,23),heltab2x48(:,:,28))
  call Hloop_Q_A(ntryL,G1H24(7),36,nMB,G2H24(1),n2h24(17))
  call Hloop_UV_W(ntryL,G1H48(9),32,wf4(:,1),3,G2H12(10),m3h4x12(:,6),heltab2x48(:,:,29))
  call Hloop_QA_V(ntryL,G1H48(10),ex4(:),G1H24(9),m3h2x24(:,24),heltab2x48(:,:,30))
  call Hloop_VQ_A(ntryL,G1H48(11),ex3(:),G1H24(10),m3h2x24(:,25),heltab2x48(:,:,31))
  call Hloop_Q_A(ntryL,G1H24(10),36,nMB,G2H24(2),n2h24(18))
  call Hloop_AQ_V(ntryL,G1H48(12),ex3(:),G1H24(14),m3h2x24(:,26),heltab2x48(:,:,32))
  call Hloop_QA_V(ntryL,G1H48(13),ex2(:),G1H24(11),m3h2x24(:,27),heltab2x48(:,:,33))
  call Hloop_QV_A(ntryL,G1H48(14),wf4(:,7),G1H12(11),m3h4x12(:,7),heltab2x48(:,:,34))
  call Hloop_Q_A(ntryL,G1H12(11),44,nMT,G2H12(11),n2h12(25))
  call Hloop_AQ_V(ntryL,G1H48(15),ex1(:),G1H24(12),m3h2x24(:,28),heltab2x48(:,:,35))
  call Hloop_AQ_V(ntryL,G1H48(16),ex1(:),G1H24(16),m3h2x24(:,29),heltab2x48(:,:,36))
  call Hloop_AV_Q(ntryL,G1H48(17),wf4(:,7),G1H12(12),m3h4x12(:,8),heltab2x48(:,:,37))
  call Hloop_A_Q(ntryL,G1H12(12),44,nMT,G2H12(12),n2h12(26))
  call Hloop_QA_V(ntryL,G1H48(18),ex2(:),G1H24(17),m3h2x24(:,30),heltab2x48(:,:,38))
  call Hloop_VQ_A(ntryL,G1H48(19),ex1(:),G1H24(18),m3h2x24(:,31),heltab2x48(:,:,39))
  call Hloop_Q_A(ntryL,G1H24(18),33,nMT,G2H24(3),n2h24(19))
  call Hloop_VQ_A(ntryL,G1H48(20),ex1(:),G1H24(19),m3h2x24(:,32),heltab2x48(:,:,40))
  call Hloop_Q_A(ntryL,G1H24(19),33,nMT,G2H24(4),n2h24(20))
  call Hloop_VA_Q(ntryL,G1H48(21),ex2(:),G1H24(20),m3h2x24(:,33),heltab2x48(:,:,41))
  call Hloop_A_Q(ntryL,G1H24(20),34,nMT,G2H24(5),n2h24(21))
  call Hloop_QA_V(ntryL,G1H48(22),ex2(:),G1H24(22),m3h2x24(:,34),heltab2x48(:,:,42))
  call Hloop_VQ_A(ntryL,G1H48(23),ex1(:),G1H24(23),m3h2x24(:,35),heltab2x48(:,:,43))
  call Hloop_Q_A(ntryL,G1H24(23),33,nMT,G2H24(6),n2h24(22))
  call Hloop_AQ_V(ntryL,G1H48(24),ex1(:),G1H24(24),m3h2x24(:,36),heltab2x48(:,:,44))
  call Hloop_QA_V(ntryL,G1H48(25),ex2(:),G1H24(2),m3h2x24(:,37),heltab2x48(:,:,45))
  call Hloop_VA_Q(ntryL,G1H48(26),ex4(:),G1H24(8),m3h2x24(:,38),heltab2x48(:,:,46))
  call Hloop_A_Q(ntryL,G1H24(8),40,nMB,G2H24(7),n2h24(23))
  call Hloop_AQ_V(ntryL,G1H48(27),ex3(:),G1H24(15),m3h2x24(:,39),heltab2x48(:,:,47))
  call Hloop_QA_V(ntryL,G1H48(28),ex2(:),G1H24(21),m3h2x24(:,40),heltab2x48(:,:,48))
  call Hloop_VQ_A(ntryL,G1H48(29),ex3(:),G1H24(7),m3h2x24(:,41),heltab2x48(:,:,49))
  call Hloop_Q_A(ntryL,G1H24(7),36,nMB,G2H24(8),n2h24(24))
  call Hloop_AQ_V(ntryL,G1H48(30),ex3(:),G1H24(10),m3h2x24(:,42),heltab2x48(:,:,50))
  call Hloop_VA_Q(ntryL,G1H48(31),ex2(:),G1H24(18),m3h2x24(:,43),heltab2x48(:,:,51))
  call Hloop_A_Q(ntryL,G1H24(18),34,nMT,G2H24(9),n2h24(25))
  call Hloop_VA_Q(ntryL,G1H48(32),ex2(:),G1H24(19),m3h2x24(:,44),heltab2x48(:,:,52))
  call Hloop_A_Q(ntryL,G1H24(19),34,nMT,G2H24(10),n2h24(26))
  call Hloop_AQ_V(ntryL,G1H48(33),ex1(:),G1H24(20),m3h2x24(:,45),heltab2x48(:,:,53))
  call Hloop_VA_Q(ntryL,G1H48(34),ex4(:),G1H24(23),m3h2x24(:,46),heltab2x48(:,:,54))
  call Hloop_A_Q(ntryL,G1H24(23),40,nMB,G2H24(11),n2h24(27))
  call Hloop_AQ_V(ntryL,G1H48(35),ex3(:),G1H24(8),m3h2x24(:,47),heltab2x48(:,:,55))
  call Hloop_AQ_V(ntryL,G1H48(36),ex1(:),G1H24(7),m3h2x24(:,48),heltab2x48(:,:,56))
  call Hloop_VQ_A(ntryL,G1H48(37),ex3(:),G1H24(18),m3h2x24(:,49),heltab2x48(:,:,57))
  call Hloop_Q_A(ntryL,G1H24(18),36,nMB,G2H24(12),n2h24(28))
  call Hloop_AQ_V(ntryL,G1H48(38),ex3(:),G1H24(19),m3h2x24(:,50),heltab2x48(:,:,58))
  call Hloop_VQ_A(ntryL,G1H48(39),ex1(:),G1H24(23),m3h2x24(:,51),heltab2x48(:,:,59))
  call Hloop_Q_A(ntryL,G1H24(23),33,nMT,G2H24(13),n2h24(29))
  call Hloop_VQ_A(ntryL,G1H48(40),ex1(:),G1H24(18),m3h2x24(:,52),heltab2x48(:,:,60))
  call Hloop_Q_A(ntryL,G1H24(18),33,nMT,G2H24(14),n2h24(30))
  call Hloop_VA_Q(ntryL,G1H48(41),ex2(:),G1H24(23),m3h2x24(:,53),heltab2x48(:,:,61))
  call Hloop_A_Q(ntryL,G1H24(23),34,nMT,G2H24(15),n2h24(31))
  call Hloop_QA_V(ntryL,G1H48(42),ex4(:),G1H24(18),m3h2x24(:,54),heltab2x48(:,:,62))
  call Hloop_VQ_A(ntryL,G1H48(43),ex1(:),G1H24(23),m3h2x24(:,55),heltab2x48(:,:,63))
  call Hloop_Q_A(ntryL,G1H24(23),33,nMT,G2H24(16),n2h24(32))
  call Hloop_VQ_A(ntryL,G1H48(44),ex1(:),G1H24(23),m3h2x24(:,56),heltab2x48(:,:,64))
  call Hloop_Q_A(ntryL,G1H24(23),33,nMT,G2H24(17),n2h24(33))
  call Hloop_QA_V(ntryL,G1H48(45),ex4(:),G1H24(23),m3h2x24(:,57),heltab2x48(:,:,65))
  call Hloop_VA_Q(ntryL,G1H48(46),ex2(:),G1H24(25),m3h2x24(:,58),heltab2x48(:,:,66))
  call Hloop_A_Q(ntryL,G1H24(25),34,nMT,G2H24(18),n2h24(34))
  call Hloop_AQ_V(ntryL,G1H48(47),ex1(:),G1H24(25),m3h2x24(:,59),heltab2x48(:,:,67))
  call Hloop_AQ_V(ntryL,G1H48(48),ex1(:),G1H24(26),m3h2x24(:,60),heltab2x48(:,:,68))
  call Hloop_VA_Q(ntryL,G1H48(49),ex2(:),G1H24(27),m3h2x24(:,61),heltab2x48(:,:,69))
  call Hloop_A_Q(ntryL,G1H24(27),34,nMT,G2H24(19),n2h24(35))
  call Hloop_AQ_V(ntryL,G1H48(50),ex3(:),G1H24(27),m3h2x24(:,62),heltab2x48(:,:,70))
  call Hloop_VQ_A(ntryL,G1H48(51),ex1(:),G1H24(28),m3h2x24(:,63),heltab2x48(:,:,71))
  call Hloop_Q_A(ntryL,G1H24(28),33,nMT,G2H24(20),n2h24(36))
  call Hloop_VQ_A(ntryL,G1H48(52),ex1(:),G1H24(28),m3h2x24(:,64),heltab2x48(:,:,72))
  call Hloop_Q_A(ntryL,G1H24(28),33,nMT,G2H24(21),n2h24(37))
  call Hloop_AQ_V(ntryL,G1H48(53),ex3(:),G1H24(28),m3h2x24(:,65),heltab2x48(:,:,73))
  call Hloop_VA_Q(ntryL,G1H48(54),ex2(:),G1H24(29),m3h2x24(:,66),heltab2x48(:,:,74))
  call Hloop_A_Q(ntryL,G1H24(29),34,nMT,G2H24(22),n2h24(38))
  call Hloop_AQ_V(ntryL,G1H48(55),ex1(:),G1H24(29),m3h2x24(:,67),heltab2x48(:,:,75))
  call Hloop_AQ_V(ntryL,G1H48(56),ex1(:),G1H24(30),m3h2x24(:,68),heltab2x48(:,:,76))
  call Hloop_VA_Q(ntryL,G0H24(1),ex4(:),G0H12(1),m3h2x12(:,21),heltab2x24(:,:,41))
  call Hloop_A_Q(ntryL,G0H12(1),41,nMB,G1H12(15),n2h12(27))
  call Hloop_QA_V(ntryL,G1H24(13),ex2(:),G1H12(16),m3h2x12(:,22),heltab2x24(:,:,42))
  call Hloop_VQ_A(ntryL,G0H24(2),ex3(:),G0H12(1),m3h2x12(:,23),heltab2x24(:,:,43))
  call Hloop_Q_A(ntryL,G0H12(1),37,nMB,G1H12(17),n2h12(28))
  call Hloop_QA_V(ntryL,G1H24(1),ex2(:),G1H12(18),m3h2x12(:,24),heltab2x24(:,:,44))
  call Hloop_VA_Q(ntryL,G0H24(3),ex4(:),G0H12(1),m3h2x12(:,25),heltab2x24(:,:,45))
  call Hloop_A_Q(ntryL,G0H12(1),42,nMB,G1H12(21),n2h12(29))
  call Hloop_AQ_V(ntryL,G1H24(3),ex1(:),G1H12(22),m3h2x12(:,26),heltab2x24(:,:,46))
  call Hloop_VQ_A(ntryL,G0H24(4),ex3(:),G0H12(1),m3h2x12(:,27),heltab2x24(:,:,47))
  call Hloop_Q_A(ntryL,G0H12(1),38,nMB,G1H12(23),n2h12(30))
  call Hloop_AQ_V(ntryL,G1H24(4),ex1(:),G1H12(24),m3h2x12(:,28),heltab2x24(:,:,48))
  call Hloop_VA_Q(ntryL,G0H24(5),ex2(:),G0H12(1),m3h2x12(:,29),heltab2x24(:,:,49))
  call Hloop_A_Q(ntryL,G0H12(1),38,nMT,G1H12(27),n2h12(31))
  call Hloop_VQ_A(ntryL,G0H24(6),ex1(:),G0H12(1),m3h2x12(:,30),heltab2x24(:,:,50))
  call Hloop_Q_A(ntryL,G0H12(1),37,nMT,G1H12(28),n2h12(32))
  call Hloop_VA_Q(ntryL,G0H24(7),ex2(:),G0H12(1),m3h2x12(:,31),heltab2x24(:,:,51))
  call Hloop_A_Q(ntryL,G0H12(1),38,nMT,G1H12(29),n2h12(33))
  call Hloop_VQ_A(ntryL,G0H24(8),ex1(:),G0H12(1),m3h2x12(:,32),heltab2x24(:,:,52))
  call Hloop_Q_A(ntryL,G0H12(1),37,nMT,G1H12(30),n2h12(34))
  call Hloop_VA_Q(ntryL,G0H24(9),ex2(:),G0H12(1),m3h2x12(:,33),heltab2x24(:,:,53))
  call Hloop_A_Q(ntryL,G0H12(1),42,nMT,G1H12(33),n2h12(35))
  call Hloop_VQ_A(ntryL,G0H24(10),ex1(:),G0H12(1),m3h2x12(:,34),heltab2x24(:,:,54))
  call Hloop_Q_A(ntryL,G0H12(1),41,nMT,G1H12(34),n2h12(36))
  call Hloop_VA_Q(ntryL,G0H24(11),ex2(:),G0H12(1),m3h2x12(:,35),heltab2x24(:,:,55))
  call Hloop_A_Q(ntryL,G0H12(1),42,nMT,G1H12(35),n2h12(37))
  call Hloop_VQ_A(ntryL,G0H24(12),ex1(:),G0H12(1),m3h2x12(:,36),heltab2x24(:,:,56))
  call Hloop_Q_A(ntryL,G0H12(1),41,nMT,G1H12(36),n2h12(38))
call HGT_w2_OLR(G1H12(1),1,1,12)
call HGT_w2_invQ_OLR(G1H12(1),2,5,12)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(1),[G1H12(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(29),[G1H12(43)])
call HGT_w2_OLR(G1H12(2),1,1,12)
call HGT_w2_invQ_OLR(G1H12(2),2,5,12)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(2),[G1H12(29)])
call HGT_w2_OLR(G1H12(3),1,1,12)
call HGT_w2_invQ_OLR(G1H12(3),2,5,12)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(3),[G1H12(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(30),[G1H12(31)])
call HGT_w2_OLR(G1H12(4),1,1,12)
call HGT_w2_invQ_OLR(G1H12(4),2,5,12)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(4),[G1H12(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(22),[G1H12(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(10),[G1H12(20),G1H12(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(24),[G1H12(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(9),[G1H12(26),G1H12(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(16),[G1H12(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(18),[G1H12(25)])
  call Hloop_AZ_Q(ntryL,G1H12(1),ex5(:),G1H4(6),ngZu,m3h3x4(:,13),heltab2x12(:,:,41))
  call Hloop_A_Q(ntryL,G1H4(6),58,nMT,G2H4(1),n2h4(21))
  call Hloop_AQ_V(ntryL,G2H8(2),ex1(:),G2H4(3),m3h2x4(:,13),heltab2x8(:,:,13))
  call Hloop_AZ_Q(ntryL,G1H12(2),ex5(:),G1H4(18),ngZu,m3h3x4(:,14),heltab2x12(:,:,42))
  call Hloop_A_Q(ntryL,G1H4(18),54,nMT,G2H4(4),n2h4(22))
  call Hloop_AQ_V(ntryL,G2H8(6),ex1(:),G2H4(6),m3h2x4(:,14),heltab2x8(:,:,14))
  call Hloop_QZ_A(ntryL,G1H12(3),ex5(:),G1H4(30),ngZu,m3h3x4(:,15),heltab2x12(:,:,43))
  call Hloop_Q_A(ntryL,G1H4(30),57,nMT,G2H4(7),n2h4(23))
  call Hloop_QA_V(ntryL,G2H8(10),ex2(:),G2H4(9),m3h2x4(:,15),heltab2x8(:,:,15))
  call Hloop_QZ_A(ntryL,G1H12(4),ex5(:),G1H4(42),ngZu,m3h3x4(:,16),heltab2x12(:,:,44))
  call Hloop_Q_A(ntryL,G1H4(42),53,nMT,G2H4(10),n2h4(24))
  call Hloop_QA_V(ntryL,G2H8(14),ex2(:),G2H4(12),m3h2x4(:,16),heltab2x8(:,:,16))
  call Hloop_VQ_A(ntryL,G1H12(22),ex3(:),G1H6(58),m3h2x6(:,29),heltab2x12(:,:,45))
  call Hloop_Q_A(ntryL,G1H6(58),39,nMB,G2H6(9),n2h6(29))
  call Hotf_5pt_reduction(G2H12(10),RedSet_5(27),mass5set(:,8),  & 
G1H12(39),G1H12(40),G1H12(41),G1H12(42),G1H12(45),G1H12(46),12)
  call HG1shiftOLR(G1H12(40),8,12)
  call Hloop_VA_Q(ntryL,G1H12(24),ex4(:),G1H6(70),m3h2x6(:,30),heltab2x12(:,:,46))
  call Hloop_A_Q(ntryL,G1H6(70),43,nMB,G2H6(11),n2h6(30))
  call Hotf_5pt_reduction(G2H12(9),RedSet_5(28),mass5set(:,8),  & 
G1H12(47),G1H12(48),G1H12(51),G1H12(52),G1H12(5),G1H12(6),12)
  call HG1shiftOLR(G1H12(48),4,12)
  call Hloop_VQ_A(ntryL,G1H12(16),ex3(:),G1H6(82),m3h2x6(:,31),heltab2x12(:,:,47))
  call Hloop_Q_A(ntryL,G1H6(82),39,nMB,G2H6(12),n2h6(31))
  call Hloop_VA_Q(ntryL,G1H12(18),ex4(:),G1H6(94),m3h2x6(:,32),heltab2x12(:,:,48))
  call Hloop_A_Q(ntryL,G1H6(94),43,nMB,G2H6(14),n2h6(32))
  call Hloop_QZ_A(ntryL,G1H12(32),ex5(:),G1H4(1),ngZu,m3h3x4(:,17),heltab2x12(:,:,49))
  call Hloop_Q_A(ntryL,G1H4(1),53,nMT,G2H4(13),n2h4(25))
  call Hloop_QZ_A(ntryL,G1H12(37),ex5(:),G1H4(2),ngZd,m3h3x4(:,18),heltab2x12(:,:,50))
  call Hloop_Q_A(ntryL,G1H4(2),53,nMB,G2H4(15),n2h4(26))
  call Hloop_QZ_A(ntryL,G1H12(38),ex5(:),G1H4(7),ngZd,m3h3x4(:,19),heltab2x12(:,:,51))
  call Hloop_Q_A(ntryL,G1H4(7),53,nMB,G2H4(16),n2h4(27))
  call Hloop_AZ_Q(ntryL,G1H12(44),ex5(:),G1H4(8),ngZu,m3h3x4(:,20),heltab2x12(:,:,52))
  call Hloop_A_Q(ntryL,G1H4(8),54,nMT,G2H4(18),n2h4(28))
  call Hloop_AZ_Q(ntryL,G1H12(49),ex5(:),G1H4(12),ngZd,m3h3x4(:,21),heltab2x12(:,:,53))
  call Hloop_A_Q(ntryL,G1H4(12),57,nMB,G2H4(19),n2h4(29))
  call Hloop_AZ_Q(ntryL,G1H12(50),ex5(:),G1H4(13),ngZd,m3h3x4(:,22),heltab2x12(:,:,54))
  call Hloop_A_Q(ntryL,G1H4(13),57,nMB,G2H4(21),n2h4(30))
  call Hloop_AQ_V(ntryL,G2H8(1),ex1(:),G2H4(22),m3h2x4(:,17),heltab2x8(:,:,17))
  call Hloop_AQ_V(ntryL,G2H8(3),ex1(:),G2H4(24),m3h2x4(:,18),heltab2x8(:,:,18))
  call Hloop_QA_V(ntryL,G2H8(4),ex2(:),G2H4(25),m3h2x4(:,19),heltab2x8(:,:,19))
  call Hloop_QA_V(ntryL,G2H8(5),ex2(:),G2H4(26),m3h2x4(:,20),heltab2x8(:,:,20))
  call Hotf_5pt_reduction(G2H12(5),RedSet_5(29),mass5set(:,9),  & 
G1H12(9),G1H12(10),G1H12(11),G1H12(12),G1H12(35),G1H12(43),12)
  call HG1shiftOLR(G1H12(10),8,12)
  call Hloop_QA_V(ntryL,G2H12(6),ex4(:),G2H6(15),m3h2x6(:,33),heltab2x12(:,:,55))
  call Hotf_5pt_reduction(G2H12(7),RedSet_5(30),mass5set(:,9),  & 
G1H12(29),G1H12(36),G1H12(31),G1H12(30),G1H12(7),G1H12(20),12)
  call HG1shiftOLR(G1H12(36),4,12)
  call Hloop_VA_Q(ntryL,G1H24(5),ex4(:),G1H12(8),m3h2x12(:,37),heltab2x24(:,:,57))
  call Hloop_A_Q(ntryL,G1H12(8),44,nMB,G2H12(13),n2h12(39))
  call Hloop_AQ_V(ntryL,G2H12(8),ex3(:),G2H6(17),m3h2x6(:,34),heltab2x12(:,:,56))
  call Hloop_VQ_A(ntryL,G1H24(6),ex3(:),G1H12(13),m3h2x12(:,38),heltab2x24(:,:,58))
  call Hloop_Q_A(ntryL,G1H12(13),44,nMB,G2H12(14),n2h12(40))
  call Hotf_5pt_reduction(G2H24(1),RedSet_5(31),mass5set(:,10),  & 
G1H24(13),G1H24(1),G1H24(3),G1H24(4),G1H24(5),G1H24(6),24)
  call HG1shiftOLR(G1H24(1),8,24)
  call Hloop_UV_W(ntryL,G1H24(9),40,wf4(:,1),3,G2H6(18),m3h4x6(:,1),heltab2x24(:,:,59))
  call Hotf_5pt_reduction(G2H24(2),RedSet_5(32),mass5set(:,10),  & 
G1H24(9),G1H24(31),G1H24(32),G1H24(33),G1H24(34),G1H24(35),24)
  call HG1shiftOLR(G1H24(31),8,24)
  call Hloop_UV_W(ntryL,G1H24(14),36,wf4(:,1),3,G2H6(20),m3h4x6(:,2),heltab2x24(:,:,60))
  call Hloop_VQ_A(ntryL,G1H24(11),ex1(:),G1H12(26),m3h2x12(:,39),heltab2x24(:,:,61))
  call Hloop_Q_A(ntryL,G1H12(26),35,nMT,G2H12(15),n2h12(41))
  call Hloop_QA_V(ntryL,G2H12(11),ex2(:),G2H6(1),m3h2x6(:,35),heltab2x12(:,:,57))
  call Hloop_VA_Q(ntryL,G1H24(12),ex2(:),G1H12(14),m3h2x12(:,40),heltab2x24(:,:,62))
  call Hloop_A_Q(ntryL,G1H12(14),35,nMT,G2H12(16),n2h12(42))
  call Hloop_VA_Q(ntryL,G1H24(16),ex2(:),G1H12(19),m3h2x12(:,41),heltab2x24(:,:,63))
  call Hloop_A_Q(ntryL,G1H12(19),35,nMT,G2H12(1),n2h12(43))
  call Hloop_AQ_V(ntryL,G2H12(12),ex1(:),G2H6(2),m3h2x6(:,36),heltab2x12(:,:,58))
  call Hloop_VQ_A(ntryL,G1H24(17),ex1(:),G1H12(25),m3h2x12(:,42),heltab2x24(:,:,64))
  call Hloop_Q_A(ntryL,G1H12(25),35,nMT,G2H12(2),n2h12(44))
  call Hotf_5pt_reduction(G2H24(3),RedSet_5(2),mass5set(:,1),  & 
G1H24(14),G1H24(11),G1H24(12),G1H24(16),G1H24(17),G1H24(36),24)
  call HG1shiftOLR(G1H24(11),12,24)
  call Hotf_5pt_reduction(G2H24(4),RedSet_5(33),mass5set(:,11),  & 
G1H24(37),G1H24(38),G1H24(39),G1H24(40),G1H24(41),G1H24(42),24)
  call HG1shiftOLR(G1H24(38),2,24)
  call Hotf_5pt_reduction(G2H24(5),RedSet_5(1),mass5set(:,1),  & 
G1H24(43),G1H24(44),G1H24(45),G1H24(46),G1H24(47),G1H24(48),24)
  call HG1shiftOLR(G1H24(44),12,24)
  call Hloop_UV_W(ntryL,G1H24(22),34,wf4(:,7),12,G2H6(3),m3h4x6(:,3),heltab2x24(:,:,65))
  call Hotf_5pt_reduction(G2H24(6),RedSet_5(34),mass5set(:,11),  & 
G1H24(22),G1H24(49),G1H24(50),G1H24(51),G1H24(52),G1H24(53),24)
  call HG1shiftOLR(G1H24(49),2,24)
  call Hloop_UV_W(ntryL,G1H24(24),33,wf4(:,7),12,G2H6(4),m3h4x6(:,4),heltab2x24(:,:,66))
  call Hloop_VQ_A(ntryL,G1H24(2),ex3(:),G1H12(1),m3h2x12(:,43),heltab2x24(:,:,67))
  call Hloop_Q_A(ntryL,G1H12(1),38,nMB,G2H12(3),n2h12(45))
  call Hloop_AQ_V(ntryL,G2H24(7),ex3(:),G2H12(4),m3h2x12(:,44),heltab2x24(:,:,68))
  call Hloop_VA_Q(ntryL,G1H24(15),ex2(:),G1H12(2),m3h2x12(:,45),heltab2x24(:,:,69))
  call Hloop_A_Q(ntryL,G1H12(2),38,nMT,G2H12(10),n2h12(46))
  call Hloop_VA_Q(ntryL,G1H24(21),ex4(:),G1H12(3),m3h2x12(:,46),heltab2x24(:,:,70))
  call Hloop_A_Q(ntryL,G1H12(3),42,nMB,G2H12(9),n2h12(47))
  call Hloop_QA_V(ntryL,G2H24(8),ex4(:),G2H12(5),m3h2x12(:,47),heltab2x24(:,:,71))
  call Hloop_VQ_A(ntryL,G1H24(10),wf6(:,6),G1H4(14),m3h6x4(:,1),heltab2x24(:,:,72))
  call Hloop_Q_A(ntryL,G1H4(14),53,nMT,G2H4(27),n2h4(31))
  call Hloop_AQ_V(ntryL,G2H24(9),wf6(:,6),G2H4(28),m3h6x4(:,2),heltab2x24(:,:,73))
  call Hloop_AQ_V(ntryL,G2H24(10),wf6(:,6),G2H4(29),m3h6x4(:,3),heltab2x24(:,:,74))
  call Hloop_VQ_A(ntryL,G1H24(20),ex3(:),G1H12(4),m3h2x12(:,48),heltab2x24(:,:,75))
  call Hloop_Q_A(ntryL,G1H12(4),37,nMB,G2H12(6),n2h12(48))
  call Hloop_AQ_V(ntryL,G2H24(11),ex3(:),G2H12(7),m3h2x12(:,49),heltab2x24(:,:,76))
  call Hloop_VQ_A(ntryL,G1H24(8),ex1(:),G1H12(22),m3h2x12(:,50),heltab2x24(:,:,77))
  call Hloop_Q_A(ntryL,G1H12(22),37,nMT,G2H12(8),n2h12(49))
  call Hloop_VA_Q(ntryL,G1H24(7),ex4(:),G1H12(24),m3h2x12(:,51),heltab2x24(:,:,78))
  call Hloop_A_Q(ntryL,G1H12(24),41,nMB,G2H12(11),n2h12(50))
  call Hloop_QA_V(ntryL,G2H24(12),ex4(:),G2H12(12),m3h2x12(:,52),heltab2x24(:,:,79))
  call Hloop_VA_Q(ntryL,G1H24(19),wf6(:,8),G1H4(19),m3h6x4(:,4),heltab2x24(:,:,80))
  call Hloop_A_Q(ntryL,G1H4(19),54,nMT,G2H4(30),n2h4(32))
  call Hloop_QA_V(ntryL,G2H24(13),wf6(:,8),G2H4(31),m3h6x4(:,5),heltab2x24(:,:,81))
  call Hloop_QA_V(ntryL,G2H24(14),wf6(:,8),G2H4(32),m3h6x4(:,6),heltab2x24(:,:,82))
  call Hloop_AQ_V(ntryL,G2H24(15),ex1(:),G2H12(17),m3h2x12(:,53),heltab2x24(:,:,83))
  call Hloop_VQ_A(ntryL,G1H24(18),ex1(:),G1H12(16),m3h2x12(:,54),heltab2x24(:,:,84))
  call Hloop_Q_A(ntryL,G1H12(16),41,nMT,G2H12(18),n2h12(51))
  call Hloop_QA_V(ntryL,G2H24(16),ex2(:),G2H12(19),m3h2x12(:,55),heltab2x24(:,:,85))
  call Hloop_QA_V(ntryL,G2H24(17),ex2(:),G2H12(20),m3h2x12(:,56),heltab2x24(:,:,86))
  call Hloop_VA_Q(ntryL,G1H24(23),ex2(:),G1H12(18),m3h2x12(:,57),heltab2x24(:,:,87))
  call Hloop_A_Q(ntryL,G1H12(18),42,nMT,G2H12(21),n2h12(52))
  call Hloop_AQ_V(ntryL,G2H24(18),ex1(:),G2H12(22),m3h2x12(:,58),heltab2x24(:,:,88))
  call Hloop_VA_Q(ntryL,G1H24(25),ex4(:),G1H12(32),m3h2x12(:,59),heltab2x24(:,:,89))
  call Hloop_A_Q(ntryL,G1H12(32),41,nMB,G2H12(23),n2h12(53))
  call Hloop_VQ_A(ntryL,G1H24(26),wf6(:,2),G1H4(20),m3h6x4(:,7),heltab2x24(:,:,90))
  call Hloop_Q_A(ntryL,G1H4(20),53,nMB,G2H4(33),n2h4(33))
  call Hloop_AQ_V(ntryL,G2H24(19),ex1(:),G2H12(24),m3h2x12(:,60),heltab2x24(:,:,91))
  call Hloop_VQ_A(ntryL,G1H24(27),ex1(:),G1H12(37),m3h2x12(:,61),heltab2x24(:,:,92))
  call Hloop_Q_A(ntryL,G1H12(37),37,nMT,G2H12(25),n2h12(54))
  call Hloop_QA_V(ntryL,G2H24(20),ex2(:),G2H12(26),m3h2x12(:,62),heltab2x24(:,:,93))
  call Hloop_QA_V(ntryL,G2H24(21),ex2(:),G2H12(27),m3h2x12(:,63),heltab2x24(:,:,94))
  call Hloop_VA_Q(ntryL,G1H24(28),ex2(:),G1H12(38),m3h2x12(:,64),heltab2x24(:,:,95))
  call Hloop_A_Q(ntryL,G1H12(38),38,nMT,G2H12(28),n2h12(55))
  call Hloop_AQ_V(ntryL,G2H24(22),ex1(:),G2H12(29),m3h2x12(:,65),heltab2x24(:,:,96))
  call Hloop_VQ_A(ntryL,G1H24(29),ex3(:),G1H12(44),m3h2x12(:,66),heltab2x24(:,:,97))
  call Hloop_Q_A(ntryL,G1H12(44),37,nMB,G2H12(30),n2h12(56))
  call Hloop_VA_Q(ntryL,G1H24(30),wf6(:,4),G1H4(24),m3h6x4(:,8),heltab2x24(:,:,98))
  call Hloop_A_Q(ntryL,G1H4(24),57,nMB,G2H4(34),n2h4(34))
  call Hloop_AQ_V(ntryL,G1H12(15),ex3(:),G1H6(5),m3h2x6(:,37),heltab2x12(:,:,59))
  call Hloop_QA_V(ntryL,G1H12(17),ex4(:),G1H6(6),m3h2x6(:,38),heltab2x12(:,:,60))
  call Hloop_AQ_V(ntryL,G1H12(21),ex3(:),G1H6(10),m3h2x6(:,39),heltab2x12(:,:,61))
  call Hloop_QA_V(ntryL,G1H12(23),ex4(:),G1H6(11),m3h2x6(:,40),heltab2x12(:,:,62))
  call Hloop_AQ_V(ntryL,G1H12(27),ex1(:),G1H6(12),m3h2x6(:,41),heltab2x12(:,:,63))
  call Hloop_QA_V(ntryL,G1H12(28),ex2(:),G1H6(16),m3h2x6(:,42),heltab2x12(:,:,64))
  call Hloop_AQ_V(ntryL,G1H12(33),ex1(:),G1H6(17),m3h2x6(:,43),heltab2x12(:,:,65))
  call Hloop_QA_V(ntryL,G1H12(34),ex2(:),G1H6(18),m3h2x6(:,44),heltab2x12(:,:,66))
  call Hloop_VQ_A(ntryL,G1H12(39),ex3(:),G1H6(22),m3h2x6(:,45),heltab2x12(:,:,67))
  call Hloop_Q_A(ntryL,G1H6(22),39,nMB,G2H6(5),n2h6(33))
call HGT_raise_alpha_OLR(G1H12(40),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(40),2,5,12)
  call Hloop_VA_Q(ntryL,G1H12(40),ex4(:),G1H6(23),m3h2x6(:,46),heltab2x12(:,:,68))
  call Hloop_VQ_A(ntryL,G1H12(42),ex3(:),G1H6(24),m3h2x6(:,47),heltab2x12(:,:,69))
  call Hloop_Q_A(ntryL,G1H6(24),39,nMB,G2H6(6),n2h6(34))
  call Hloop_VQ_A(ntryL,G1H12(45),ex3(:),G1H6(28),m3h2x6(:,48),heltab2x12(:,:,70))
  call Hloop_Q_A(ntryL,G1H6(28),39,nMB,G2H6(7),n2h6(35))
  call Hloop_VQ_A(ntryL,G1H12(46),ex3(:),G1H6(29),m3h2x6(:,49),heltab2x12(:,:,71))
  call Hloop_Q_A(ntryL,G1H6(29),39,nMB,G2H6(8),n2h6(36))
  call Hloop_VA_Q(ntryL,G1H12(47),ex4(:),G1H6(30),m3h2x6(:,50),heltab2x12(:,:,72))
  call Hloop_A_Q(ntryL,G1H6(30),43,nMB,G2H6(25),n2h6(37))
call HGT_raise_alpha_OLR(G1H12(48),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(48),2,5,12)
  call Hloop_VQ_A(ntryL,G1H12(48),ex3(:),G1H6(34),m3h2x6(:,51),heltab2x12(:,:,73))
  call Hloop_VA_Q(ntryL,G1H12(52),ex4(:),G1H6(35),m3h2x6(:,52),heltab2x12(:,:,74))
  call Hloop_A_Q(ntryL,G1H6(35),43,nMB,G2H6(26),n2h6(38))
  call Hloop_VA_Q(ntryL,G1H12(5),ex4(:),G1H6(36),m3h2x6(:,53),heltab2x12(:,:,75))
  call Hloop_A_Q(ntryL,G1H6(36),43,nMB,G2H6(27),n2h6(39))
  call Hloop_VA_Q(ntryL,G1H12(6),ex4(:),G1H6(40),m3h2x6(:,54),heltab2x12(:,:,76))
  call Hloop_A_Q(ntryL,G1H6(40),43,nMB,G2H6(28),n2h6(40))
  call Hloop_AZ_Q(ntryL,G1H12(9),ex5(:),G1H4(25),ngZd,m3h3x4(:,23),heltab2x12(:,:,77))
  call Hloop_A_Q(ntryL,G1H4(25),51,nMB,G2H4(35),n2h4(35))
call HGT_OLR(G1H12(10),1,1,12)
call HGT_invQ_OLR(G1H12(10),2,5,12)
  call Hloop_Q_A(ntryL,G1H12(10),-8,nMB,G2H12(31),n2h12(59))
  call Hloop_QA_V(ntryL,G2H12(31),ex4(:),G2H6(29),m3h2x6(:,55),heltab2x12(:,:,78))
  call Hloop_AZ_Q(ntryL,G1H12(12),ex5(:),G1H4(26),ngZd,m3h3x4(:,24),heltab2x12(:,:,79))
  call Hloop_A_Q(ntryL,G1H4(26),51,nMB,G2H4(36),n2h4(36))
  call Hloop_AZ_Q(ntryL,G1H12(35),ex5(:),G1H4(31),ngZd,m3h3x4(:,25),heltab2x12(:,:,80))
  call Hloop_A_Q(ntryL,G1H4(31),51,nMB,G2H4(37),n2h4(37))
  call Hloop_AZ_Q(ntryL,G1H12(43),ex5(:),G1H4(32),ngZd,m3h3x4(:,26),heltab2x12(:,:,81))
  call Hloop_A_Q(ntryL,G1H4(32),51,nMB,G2H4(38),n2h4(38))
  call Hloop_QZ_A(ntryL,G1H12(29),ex5(:),G1H4(36),ngZd,m3h3x4(:,27),heltab2x12(:,:,82))
  call Hloop_Q_A(ntryL,G1H4(36),51,nMB,G2H4(39),n2h4(39))
call HGT_OLR(G1H12(36),1,1,12)
call HGT_invQ_OLR(G1H12(36),2,5,12)
  call Hloop_A_Q(ntryL,G1H12(36),-4,nMB,G2H12(31),n2h12(60))
  call Hloop_AQ_V(ntryL,G2H12(31),ex3(:),G2H6(30),m3h2x6(:,56),heltab2x12(:,:,83))
  call Hloop_QZ_A(ntryL,G1H12(30),ex5(:),G1H4(37),ngZd,m3h3x4(:,28),heltab2x12(:,:,84))
  call Hloop_Q_A(ntryL,G1H4(37),51,nMB,G2H4(40),n2h4(40))
  call Hloop_QZ_A(ntryL,G1H12(7),ex5(:),G1H4(38),ngZd,m3h3x4(:,29),heltab2x12(:,:,85))
  call Hloop_Q_A(ntryL,G1H4(38),51,nMB,G2H4(41),n2h4(41))
  call Hloop_QZ_A(ntryL,G1H12(20),ex5(:),G1H4(43),ngZd,m3h3x4(:,30),heltab2x12(:,:,86))
  call Hloop_Q_A(ntryL,G1H4(43),51,nMB,G2H4(42),n2h4(42))
  call Hloop_QZ_A(ntryL,G1H24(13),ex5(:),G1H8(1),ngZd,m3h3x8(:,21),heltab2x24(:,:,99))
  call Hloop_Q_A(ntryL,G1H8(1),52,nMB,G2H8(7),n2h8(21))
call HGT_raise_alpha_OLR(G1H24(1),1,1,24)
call HGT_raise_alpha_invQ_OLR(G1H24(1),2,5,24)
  call Hloop_VA_Q(ntryL,G1H24(1),ex4(:),G1H12(49),m3h2x12(:,67),heltab2x24(:,:,100))
  call Hloop_QZ_A(ntryL,G1H24(4),ex5(:),G1H8(1),ngZd,m3h3x8(:,22),heltab2x24(:,:,101))
  call Hloop_Q_A(ntryL,G1H8(1),52,nMB,G2H8(8),n2h8(22))
  call Hloop_QZ_A(ntryL,G1H24(5),ex5(:),G1H8(1),ngZd,m3h3x8(:,23),heltab2x24(:,:,102))
  call Hloop_Q_A(ntryL,G1H8(1),52,nMB,G2H8(9),n2h8(23))
  call Hloop_QZ_A(ntryL,G1H24(6),ex5(:),G1H8(1),ngZd,m3h3x8(:,24),heltab2x24(:,:,103))
  call Hloop_Q_A(ntryL,G1H8(1),52,nMB,G2H8(11),n2h8(24))
  call Hloop_QV_A(ntryL,G1H24(9),wf4(:,1),G1H6(41),m3h4x6(:,5),heltab2x24(:,:,104))
  call Hloop_Q_A(ntryL,G1H6(41),39,nMB,G2H6(31),n2h6(41))
call HGT_raise_alpha_OLR(G1H24(31),1,1,24)
call HGT_raise_alpha_invQ_OLR(G1H24(31),2,5,24)
  call Hloop_VA_Q(ntryL,G1H24(31),ex4(:),G1H12(50),m3h2x12(:,68),heltab2x24(:,:,105))
  call Hloop_QV_A(ntryL,G1H24(33),wf4(:,1),G1H6(42),m3h4x6(:,6),heltab2x24(:,:,106))
  call Hloop_Q_A(ntryL,G1H6(42),39,nMB,G2H6(32),n2h6(42))
  call Hloop_QV_A(ntryL,G1H24(34),wf4(:,1),G1H6(46),m3h4x6(:,7),heltab2x24(:,:,107))
  call Hloop_Q_A(ntryL,G1H6(46),39,nMB,G2H6(33),n2h6(43))
  call Hloop_QV_A(ntryL,G1H24(35),wf4(:,1),G1H6(47),m3h4x6(:,8),heltab2x24(:,:,108))
  call Hloop_Q_A(ntryL,G1H6(47),39,nMB,G2H6(34),n2h6(44))
  call Hloop_QZ_A(ntryL,G1H24(14),ex5(:),G1H8(1),ngZu,m3h3x8(:,25),heltab2x24(:,:,109))
  call Hloop_Q_A(ntryL,G1H8(1),49,nMT,G2H8(12),n2h8(25))
call HGT_raise_alpha_OLR(G1H24(11),1,1,24)
call HGT_raise_alpha_invQ_OLR(G1H24(11),2,5,24)
  call Hloop_UV_W(ntryL,G1H24(11),-12,wf4(:,7),12,G2H6(35),m3h4x6(:,9),heltab2x24(:,:,110))
call signflip_OLR(G2H6(35))
  call Hloop_QZ_A(ntryL,G1H24(16),ex5(:),G1H8(1),ngZu,m3h3x8(:,26),heltab2x24(:,:,111))
  call Hloop_Q_A(ntryL,G1H8(1),49,nMT,G2H8(13),n2h8(26))
  call Hloop_QZ_A(ntryL,G1H24(17),ex5(:),G1H8(1),ngZu,m3h3x8(:,27),heltab2x24(:,:,112))
  call Hloop_Q_A(ntryL,G1H8(1),49,nMT,G2H8(15),n2h8(27))
  call Hloop_QZ_A(ntryL,G1H24(36),ex5(:),G1H8(1),ngZu,m3h3x8(:,28),heltab2x24(:,:,113))
  call Hloop_Q_A(ntryL,G1H8(1),49,nMT,G2H8(16),n2h8(28))
  call Hloop_QZ_A(ntryL,G1H24(37),ex5(:),G1H8(1),ngZu,m3h3x8(:,29),heltab2x24(:,:,114))
  call Hloop_Q_A(ntryL,G1H8(1),49,nMT,G2H8(2),n2h8(29))
call HGT_raise_alpha_OLR(G1H24(38),1,1,24)
call HGT_raise_alpha_invQ_OLR(G1H24(38),2,5,24)
  call Hloop_VA_Q(ntryL,G1H24(38),ex2(:),G1H12(8),m3h2x12(:,69),heltab2x24(:,:,115))
  call Hloop_QZ_A(ntryL,G1H24(40),ex5(:),G1H8(1),ngZu,m3h3x8(:,30),heltab2x24(:,:,116))
  call Hloop_Q_A(ntryL,G1H8(1),49,nMT,G2H8(6),n2h8(30))
  call Hloop_QZ_A(ntryL,G1H24(41),ex5(:),G1H8(1),ngZu,m3h3x8(:,31),heltab2x24(:,:,117))
  call Hloop_Q_A(ntryL,G1H8(1),49,nMT,G2H8(10),n2h8(31))
  call Hloop_QZ_A(ntryL,G1H24(42),ex5(:),G1H8(1),ngZu,m3h3x8(:,32),heltab2x24(:,:,118))
  call Hloop_Q_A(ntryL,G1H8(1),49,nMT,G2H8(14),n2h8(32))
  call Hloop_AZ_Q(ntryL,G1H24(43),ex5(:),G1H8(1),ngZu,m3h3x8(:,33),heltab2x24(:,:,119))
  call Hloop_A_Q(ntryL,G1H8(1),50,nMT,G2H8(1),n2h8(33))
call HGT_raise_alpha_OLR(G1H24(44),1,1,24)
call HGT_raise_alpha_invQ_OLR(G1H24(44),2,5,24)
  call Hloop_UV_W(ntryL,G1H24(44),-12,wf4(:,7),12,G2H6(36),m3h4x6(:,10),heltab2x24(:,:,120))
call signflip_OLR(G2H6(36))
  call Hloop_AZ_Q(ntryL,G1H24(46),ex5(:),G1H8(1),ngZu,m3h3x8(:,34),heltab2x24(:,:,121))
  call Hloop_A_Q(ntryL,G1H8(1),50,nMT,G2H8(3),n2h8(34))
  call Hloop_AZ_Q(ntryL,G1H24(47),ex5(:),G1H8(1),ngZu,m3h3x8(:,35),heltab2x24(:,:,122))
  call Hloop_A_Q(ntryL,G1H8(1),50,nMT,G2H8(4),n2h8(35))
  call Hloop_AZ_Q(ntryL,G1H24(48),ex5(:),G1H8(1),ngZu,m3h3x8(:,36),heltab2x24(:,:,123))
  call Hloop_A_Q(ntryL,G1H8(1),50,nMT,G2H8(5),n2h8(36))
  call Hloop_QV_A(ntryL,G1H24(22),wf4(:,7),G1H6(48),m3h4x6(:,11),heltab2x24(:,:,124))
  call Hloop_Q_A(ntryL,G1H6(48),45,nMT,G2H6(37),n2h6(45))
call HGT_raise_alpha_OLR(G1H24(49),1,1,24)
call HGT_raise_alpha_invQ_OLR(G1H24(49),2,5,24)
  call Hloop_VA_Q(ntryL,G1H24(49),ex2(:),G1H12(13),m3h2x12(:,70),heltab2x24(:,:,125))
  call Hloop_QV_A(ntryL,G1H24(51),wf4(:,7),G1H6(52),m3h4x6(:,12),heltab2x24(:,:,126))
  call Hloop_Q_A(ntryL,G1H6(52),45,nMT,G2H6(38),n2h6(46))
  call Hloop_QV_A(ntryL,G1H24(52),wf4(:,7),G1H6(53),m3h4x6(:,13),heltab2x24(:,:,127))
  call Hloop_Q_A(ntryL,G1H6(53),45,nMT,G2H6(39),n2h6(47))
  call Hloop_QV_A(ntryL,G1H24(53),wf4(:,7),G1H6(54),m3h4x6(:,14),heltab2x24(:,:,128))
  call Hloop_Q_A(ntryL,G1H6(54),45,nMT,G2H6(40),n2h6(48))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(29),[G2H4(2),G1H4(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(28),[G2H4(5),G1H4(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(32),[G2H4(8),G1H4(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(31),[G2H4(11),G1H4(41)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(17),[G1H6(7)])
call HGT_w2_OLR(G1H6(1),1,1,6)
call HGT_w2_invQ_OLR(G1H6(1),2,5,6)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(1),[G1H6(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(10),[G1H6(57)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(12),[G1H6(25)])
call HGT_w2_OLR(G1H6(2),1,1,6)
call HGT_w2_invQ_OLR(G1H6(2),2,5,6)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(2),[G1H6(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(13),[G1H6(69)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(18),[G1H6(19)])
call HGT_w2_OLR(G1H6(3),1,1,6)
call HGT_w2_invQ_OLR(G1H6(3),2,5,6)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(3),[G1H6(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(16),[G1H6(81)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(16),[G1H6(13)])
call HGT_w2_OLR(G1H6(4),1,1,6)
call HGT_w2_invQ_OLR(G1H6(4),2,5,6)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(4),[G1H6(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(19),[G1H6(93)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(27),[G2H4(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(9),[G1H6(55)])
call HGT_lower_alpha_w2_OLR(G2H6(22),1,1,6)
call HGT_lower_alpha_w2_invQ_OLR(G2H6(22),2,5,6)
call HGT_lower_alpha_w2_OLR(G2H6(22),6,15,6)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(22),[G2H6(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(33),[G2H4(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(30),[G2H4(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(11),[G1H6(67)])
call HGT_lower_alpha_w2_OLR(G2H6(24),1,1,6)
call HGT_lower_alpha_w2_invQ_OLR(G2H6(24),2,5,6)
call HGT_lower_alpha_w2_OLR(G2H6(24),6,15,6)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(24),[G2H6(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(34),[G2H4(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(18),[G1H6(21),G1H6(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(20),[G1H6(27),G1H6(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(10),[G1H6(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(3),[G1H6(45),G1H6(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(6),[G1H6(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(4),[G1H6(51),G1H6(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(11),[G1H6(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(5),[G1H6(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(22),[G1H4(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(3),[G1H4(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(24),[G1H4(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(6),[G1H4(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(25),[G1H4(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(9),[G1H4(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(26),[G1H4(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(12),[G1H4(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(5),[G1H6(80),G1H6(56)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(7),[G1H6(86),G1H6(62)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(25),[G1H6(92),G1H6(68)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(27),[G1H6(98),G1H6(74)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(12),[G1H6(79)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(14),[G1H6(91)])
  call Hotf_5pt_reduction(G2H4(29),RedSet_5(35),mass5set(:,2),  & 
G1H4(44),G1H4(48),G1H4(6),G1H4(18),G1H4(30),G1H4(42),4)
  call HG1shiftOLR(G1H4(48),8,4)
  call Hotf_5pt_reduction(G2H4(28),RedSet_5(36),mass5set(:,2),  & 
G1H4(1),G1H4(2),G1H4(7),G1H4(8),G1H4(12),G1H4(13),4)
  call HG1shiftOLR(G1H4(2),4,4)
  call Hotf_5pt_reduction(G2H4(32),RedSet_5(37),mass5set(:,2),  & 
G1H4(14),G1H4(19),G1H4(20),G1H4(24),G1H4(25),G1H4(26),4)
  call HG1shiftOLR(G1H4(19),8,4)
  call Hotf_5pt_reduction(G2H4(31),RedSet_5(38),mass5set(:,2),  & 
G1H4(31),G1H4(32),G1H4(36),G1H4(37),G1H4(38),G1H4(43),4)
  call HG1shiftOLR(G1H4(32),4,4)
  call Hloop_VQ_A(ntryL,G1H6(1),ex3(:),G1H3(9),m3h2x3(:,25),heltab2x6(:,:,45))
  call Hloop_Q_A(ntryL,G1H3(9),47,nMB,G2H3(1),n2h3(17))
  call Hotf_5pt_reduction(G2H6(10),RedSet_5(39),mass5set(:,12),  & 
G1H6(59),G1H6(60),G1H6(64),G1H6(65),G1H6(66),G1H6(71),6)
  call HG1shiftOLR(G1H6(60),8,6)
  call Hloop_VA_Q(ntryL,G1H6(2),ex4(:),G1H3(10),m3h2x3(:,26),heltab2x6(:,:,46))
  call Hloop_A_Q(ntryL,G1H3(10),47,nMB,G2H3(3),n2h3(18))
  call Hotf_5pt_reduction(G2H6(13),RedSet_5(40),mass5set(:,12),  & 
G1H6(72),G1H6(76),G1H6(77),G1H6(78),G1H6(83),G1H6(84),6)
  call HG1shiftOLR(G1H6(76),4,6)
  call Hloop_VQ_A(ntryL,G1H6(3),ex3(:),G1H3(15),m3h2x3(:,27),heltab2x6(:,:,47))
  call Hloop_Q_A(ntryL,G1H3(15),47,nMB,G2H3(5),n2h3(19))
  call Hotf_5pt_reduction(G2H6(16),RedSet_5(41),mass5set(:,12),  & 
G1H6(88),G1H6(89),G1H6(90),G1H6(95),G1H6(96),G1H6(100),6)
  call HG1shiftOLR(G1H6(89),8,6)
  call Hloop_VA_Q(ntryL,G1H6(4),ex4(:),G1H3(16),m3h2x3(:,28),heltab2x6(:,:,48))
  call Hloop_A_Q(ntryL,G1H3(16),47,nMB,G2H3(7),n2h3(20))
  call Hotf_5pt_reduction(G2H6(19),RedSet_5(42),mass5set(:,12),  & 
G1H6(58),G1H6(70),G1H6(82),G1H6(94),G1H6(22),G1H6(24),6)
  call HG1shiftOLR(G1H6(70),4,6)
call HGT_lower_alpha_w2_OLR(G2H6(21),1,1,6)
call HGT_lower_alpha_w2_invQ_OLR(G2H6(21),2,5,6)
call HGT_lower_alpha_w2_OLR(G2H6(21),6,15,6)
  call Hotf_5pt_reduction(G2H6(21),RedSet_5(43),mass5set(:,13),  & 
G1H6(28),G1H6(29),G1H6(30),G1H6(35),G1H6(36),G1H6(40),6)
  call HG1shiftOLR(G1H6(29),2,6)
  call Hloop_QA_V(ntryL,G2H4(27),ex2(:),G2H2(1),m3h2x2(:,29),heltab2x4(:,:,29))
  call Hotf_5pt_reduction(G2H6(22),RedSet_5(44),mass5set(:,14),  & 
G1H6(41),G1H6(42),G1H6(46),G1H6(47),G1H6(48),G1H6(52),6)
  call HG1shiftOLR(G1H6(42),8,6)
  call Hloop_QA_V(ntryL,G2H4(33),ex4(:),G2H2(3),m3h2x2(:,30),heltab2x4(:,:,30))
call HGT_lower_alpha_w2_OLR(G2H6(23),1,1,6)
call HGT_lower_alpha_w2_invQ_OLR(G2H6(23),2,5,6)
call HGT_lower_alpha_w2_OLR(G2H6(23),6,15,6)
  call Hotf_5pt_reduction(G2H6(23),RedSet_5(45),mass5set(:,13),  & 
G1H6(53),G1H6(54),G1H6(7),G1H6(17),G1H6(57),G1H6(25),6)
  call HG1shiftOLR(G1H6(54),1,6)
  call Hloop_AQ_V(ntryL,G2H4(30),ex1(:),G2H2(5),m3h2x2(:,31),heltab2x4(:,:,31))
  call Hotf_5pt_reduction(G2H6(24),RedSet_5(46),mass5set(:,14),  & 
G1H6(12),G1H6(69),G1H6(19),G1H6(18),G1H6(81),G1H6(13),6)
  call HG1shiftOLR(G1H6(69),4,6)
  call Hloop_AQ_V(ntryL,G2H4(34),ex3(:),G2H2(7),m3h2x2(:,32),heltab2x4(:,:,32))
  call Hloop_VQ_A(ntryL,G1H6(8),ex3(:),G1H3(21),m3h2x3(:,29),heltab2x6(:,:,49))
  call Hloop_Q_A(ntryL,G1H3(21),47,nMB,G2H3(9),n2h3(21))
  call Hotf_5pt_reduction(G2H6(18),RedSet_5(47),mass5set(:,15),  & 
G1H6(16),G1H6(93),G1H6(55),G1H6(67),G1H6(21),G1H6(9),6)
  call HG1shiftOLR(G1H6(93),16,6)
  call Hloop_VA_Q(ntryL,G1H6(14),ex4(:),G1H3(22),m3h2x3(:,30),heltab2x6(:,:,50))
  call Hloop_A_Q(ntryL,G1H3(22),47,nMB,G2H3(11),n2h3(22))
  call Hotf_5pt_reduction(G2H6(20),RedSet_5(48),mass5set(:,15),  & 
G1H6(27),G1H6(15),G1H6(31),G1H6(45),G1H6(33),G1H6(37),6)
  call HG1shiftOLR(G1H6(15),16,6)
  call Hloop_VQ_A(ntryL,G1H6(20),ex3(:),G1H3(27),m3h2x3(:,31),heltab2x6(:,:,51))
  call Hloop_Q_A(ntryL,G1H3(27),47,nMB,G2H3(13),n2h3(23))
  call Hloop_VA_Q(ntryL,G1H6(26),ex4(:),G1H3(28),m3h2x3(:,32),heltab2x6(:,:,52))
  call Hloop_A_Q(ntryL,G1H3(28),47,nMB,G2H3(15),n2h3(24))
  call Hloop_VQ_A(ntryL,G1H6(10),ex1(:),G1H3(33),m3h2x3(:,33),heltab2x6(:,:,53))
  call Hloop_Q_A(ntryL,G1H3(33),47,nMT,G2H3(17),n2h3(25))
  call Hloop_VQ_A(ntryL,G1H6(32),ex1(:),G1H3(34),m3h2x3(:,34),heltab2x6(:,:,54))
  call Hloop_Q_A(ntryL,G1H3(34),47,nMT,G2H3(18),n2h3(26))
  call Hotf_5pt_reduction(G2H6(3),RedSet_5(49),mass5set(:,16),  & 
G1H6(51),G1H6(39),G1H6(43),G1H6(49),G1H6(80),G1H6(56),6)
  call HG1shiftOLR(G1H6(39),16,6)
  call Hloop_VA_Q(ntryL,G1H6(6),ex2(:),G1H3(39),m3h2x3(:,35),heltab2x6(:,:,55))
  call Hloop_A_Q(ntryL,G1H3(39),47,nMT,G2H3(19),n2h3(27))
  call Hloop_VA_Q(ntryL,G1H6(38),ex2(:),G1H3(40),m3h2x3(:,36),heltab2x6(:,:,56))
  call Hloop_A_Q(ntryL,G1H3(40),47,nMT,G2H3(20),n2h3(28))
  call Hotf_5pt_reduction(G2H6(4),RedSet_5(50),mass5set(:,16),  & 
G1H6(86),G1H6(62),G1H6(92),G1H6(68),G1H6(98),G1H6(74),6)
  call HG1shiftOLR(G1H6(62),16,6)
  call Hloop_VQ_A(ntryL,G1H6(11),ex1(:),G1H3(45),m3h2x3(:,37),heltab2x6(:,:,57))
  call Hloop_Q_A(ntryL,G1H3(45),47,nMT,G2H3(21),n2h3(29))
  call Hloop_VQ_A(ntryL,G1H6(44),ex1(:),G1H3(46),m3h2x3(:,38),heltab2x6(:,:,58))
  call Hloop_Q_A(ntryL,G1H3(46),47,nMT,G2H3(22),n2h3(30))
  call Hloop_VA_Q(ntryL,G1H6(5),ex2(:),G1H3(51),m3h2x3(:,39),heltab2x6(:,:,59))
  call Hloop_A_Q(ntryL,G1H3(51),47,nMT,G2H3(23),n2h3(31))
  call Hloop_VA_Q(ntryL,G1H6(50),ex2(:),G1H3(52),m3h2x3(:,40),heltab2x6(:,:,60))
  call Hloop_A_Q(ntryL,G1H3(52),47,nMT,G2H3(24),n2h3(32))
  call Hotf_5pt_reduction(G2H4(22),RedSet_5(51),mass5set(:,17),  & 
G1H4(5),G1H4(17),G1H4(29),G1H4(41),G1H4(3),G1H4(4),4)
  call HG1shiftOLR(G1H4(17),8,4)
  call Hotf_5pt_reduction(G2H4(3),RedSet_5(52),mass5set(:,2),  & 
G1H4(15),G1H4(16),G1H4(27),G1H4(28),G1H4(39),G1H4(40),4)
  call HG1shiftOLR(G1H4(16),8,4)
  call Hloop_VQ_A(ntryL,G1H4(9),ex3(:),G1H2(9),m3h2x2(:,33),heltab2x4(:,:,33))
  call Hloop_Q_A(ntryL,G1H2(9),55,nMB,G2H2(17),n2h2(25))
  call Hloop_VQ_A(ntryL,G1H4(10),ex3(:),G1H2(10),m3h2x2(:,34),heltab2x4(:,:,34))
  call Hloop_Q_A(ntryL,G1H2(10),55,nMB,G2H2(20),n2h2(26))
  call Hloop_VQ_A(ntryL,G1H4(11),ex3(:),G1H2(15),m3h2x2(:,35),heltab2x4(:,:,35))
  call Hloop_Q_A(ntryL,G1H2(15),55,nMB,G2H2(23),n2h2(27))
  call Hotf_5pt_reduction(G2H4(24),RedSet_5(53),mass5set(:,17),  & 
G1H4(9),G1H4(10),G1H4(11),G1H4(49),G1H4(50),G1H4(51),4)
  call HG1shiftOLR(G1H4(10),4,4)
  call Hotf_5pt_reduction(G2H4(6),RedSet_5(54),mass5set(:,2),  & 
G1H4(52),G1H4(53),G1H4(54),G1H4(55),G1H4(56),G1H4(57),4)
  call HG1shiftOLR(G1H4(53),4,4)
  call Hloop_VA_Q(ntryL,G1H4(21),ex4(:),G1H2(16),m3h2x2(:,36),heltab2x4(:,:,36))
  call Hloop_A_Q(ntryL,G1H2(16),59,nMB,G2H2(26),n2h2(28))
  call Hloop_VA_Q(ntryL,G1H4(22),ex4(:),G1H2(21),m3h2x2(:,37),heltab2x4(:,:,37))
  call Hloop_A_Q(ntryL,G1H2(21),59,nMB,G2H2(29),n2h2(29))
  call Hloop_VA_Q(ntryL,G1H4(23),ex4(:),G1H2(22),m3h2x2(:,38),heltab2x4(:,:,38))
  call Hloop_A_Q(ntryL,G1H2(22),59,nMB,G2H2(32),n2h2(30))
  call Hotf_5pt_reduction(G2H4(25),RedSet_5(55),mass5set(:,17),  & 
G1H4(21),G1H4(22),G1H4(23),G1H4(58),G1H4(59),G1H4(60),4)
  call HG1shiftOLR(G1H4(22),8,4)
  call Hotf_5pt_reduction(G2H4(9),RedSet_5(56),mass5set(:,2),  & 
G1H4(61),G1H4(62),G1H4(63),G1H4(64),G1H4(65),G1H4(66),4)
  call HG1shiftOLR(G1H4(62),8,4)
  call Hloop_VQ_A(ntryL,G1H4(33),ex3(:),G1H2(27),m3h2x2(:,39),heltab2x4(:,:,39))
  call Hloop_Q_A(ntryL,G1H2(27),55,nMB,G2H2(35),n2h2(31))
  call Hloop_VQ_A(ntryL,G1H4(34),ex3(:),G1H2(28),m3h2x2(:,40),heltab2x4(:,:,40))
  call Hloop_Q_A(ntryL,G1H2(28),55,nMB,G2H2(38),n2h2(32))
  call Hloop_VQ_A(ntryL,G1H4(35),ex3(:),G1H2(9),m3h2x2(:,41),heltab2x4(:,:,41))
  call Hloop_Q_A(ntryL,G1H2(9),55,nMB,G2H2(41),n2h2(33))
  call Hotf_5pt_reduction(G2H4(26),RedSet_5(57),mass5set(:,17),  & 
G1H4(33),G1H4(34),G1H4(35),G1H4(67),G1H4(68),G1H4(69),4)
  call HG1shiftOLR(G1H4(34),4,4)
  call Hotf_5pt_reduction(G2H4(12),RedSet_5(58),mass5set(:,2),  & 
G1H4(70),G1H4(71),G1H4(72),G1H4(73),G1H4(74),G1H4(75),4)
  call HG1shiftOLR(G1H4(71),4,4)
  call Hloop_VA_Q(ntryL,G1H4(45),ex4(:),G1H2(10),m3h2x2(:,42),heltab2x4(:,:,42))
  call Hloop_A_Q(ntryL,G1H2(10),59,nMB,G2H2(42),n2h2(34))
  call Hloop_VA_Q(ntryL,G1H4(46),ex4(:),G1H2(15),m3h2x2(:,43),heltab2x4(:,:,43))
  call Hloop_A_Q(ntryL,G1H2(15),59,nMB,G2H2(43),n2h2(35))
  call Hloop_VA_Q(ntryL,G1H4(47),ex4(:),G1H2(16),m3h2x2(:,44),heltab2x4(:,:,44))
  call Hloop_A_Q(ntryL,G1H2(16),59,nMB,G2H2(44),n2h2(36))
  call Hotf_5pt_reduction(G2H6(5),RedSet_5(27),mass5set(:,8),  & 
G1H6(79),G1H6(91),G1H6(1),G1H6(2),G1H6(3),G1H6(4),6)
  call HG1shiftOLR(G1H6(91),8,6)
  call Hloop_QZ_A(ntryL,G1H6(61),ex5(:),G1H2(21),ngZd,m3h3x2(:,21),heltab2x6(:,:,61))
  call Hloop_Q_A(ntryL,G1H2(21),55,nMB,G2H2(45),n2h2(37))
  call Hotf_4pt_reduction(G2H6(7),RedSet_4(55),mass4set(:,1),  & 
G1H6(8),G1H6(14),G1H6(20),G1H6(26),G1H6(10),6)
  call HG1shiftOLR(G1H6(14),8,6)
  call Hloop_QZ_A(ntryL,G1H6(63),ex5(:),G1H2(22),ngZd,m3h3x2(:,22),heltab2x6(:,:,62))
  call Hloop_Q_A(ntryL,G1H2(22),55,nMB,G2H2(46),n2h2(38))
  call Hotf_5pt_reduction(G2H6(25),RedSet_5(28),mass5set(:,8),  & 
G1H6(32),G1H6(6),G1H6(38),G1H6(11),G1H6(44),G1H6(5),6)
  call HG1shiftOLR(G1H6(6),4,6)
  call Hloop_AZ_Q(ntryL,G1H6(73),ex5(:),G1H2(27),ngZd,m3h3x2(:,23),heltab2x6(:,:,63))
  call Hloop_A_Q(ntryL,G1H2(27),59,nMB,G2H2(47),n2h2(39))
  call Hotf_4pt_reduction(G2H6(27),RedSet_4(69),mass4set(:,1),  & 
G1H6(50),G1H6(61),G1H6(63),G1H6(73),G1H6(101),6)
  call HG1shiftOLR(G1H6(61),4,6)
  call Hloop_AZ_Q(ntryL,G1H6(75),ex5(:),G1H2(28),ngZd,m3h3x2(:,24),heltab2x6(:,:,64))
  call Hloop_A_Q(ntryL,G1H2(28),59,nMB,G2H2(48),n2h2(40))
  call Hotf_5pt_reduction(G2H6(12),RedSet_5(59),mass5set(:,14),  & 
G1H6(75),G1H6(102),G1H6(103),G1H6(104),G1H6(105),G1H6(106),6)
  call HG1shiftOLR(G1H6(102),8,6)
  call Hloop_QZ_A(ntryL,G1H6(85),ex5(:),G1H2(9),ngZd,m3h3x2(:,25),heltab2x6(:,:,65))
  call Hloop_Q_A(ntryL,G1H2(9),55,nMB,G2H2(49),n2h2(41))
  call Hloop_QZ_A(ntryL,G1H6(87),ex5(:),G1H2(10),ngZd,m3h3x2(:,26),heltab2x6(:,:,66))
  call Hloop_Q_A(ntryL,G1H2(10),55,nMB,G2H2(50),n2h2(42))
  call Hotf_5pt_reduction(G2H6(14),RedSet_5(60),mass5set(:,14),  & 
G1H6(85),G1H6(87),G1H6(107),G1H6(108),G1H6(109),G1H6(110),6)
  call HG1shiftOLR(G1H6(87),4,6)
  call Hloop_AZ_Q(ntryL,G1H6(97),ex5(:),G1H2(15),ngZd,m3h3x2(:,27),heltab2x6(:,:,67))
  call Hloop_A_Q(ntryL,G1H2(15),59,nMB,G2H2(51),n2h2(43))
  call Hloop_AZ_Q(ntryL,G1H6(99),ex5(:),G1H2(16),ngZd,m3h3x2(:,28),heltab2x6(:,:,68))
  call Hloop_A_Q(ntryL,G1H2(16),59,nMB,G2H2(52),n2h2(44))
  call Hloop_AQ_V(ntryL,G2H4(1),ex1(:),G2H2(53),m3h2x2(:,45),heltab2x4(:,:,45))
  call Hloop_AQ_V(ntryL,G2H4(4),ex1(:),G2H2(54),m3h2x2(:,46),heltab2x4(:,:,46))
  call Hloop_QA_V(ntryL,G2H4(7),ex2(:),G2H2(55),m3h2x2(:,47),heltab2x4(:,:,47))
  call Hloop_QA_V(ntryL,G2H4(10),ex2(:),G2H2(56),m3h2x2(:,48),heltab2x4(:,:,48))
  call Hloop_QA_V(ntryL,G2H4(13),ex2(:),G2H2(57),m3h2x2(:,49),heltab2x4(:,:,49))
  call Hloop_QA_V(ntryL,G2H4(15),ex4(:),G2H2(58),m3h2x2(:,50),heltab2x4(:,:,50))
  call Hloop_QA_V(ntryL,G2H4(16),ex4(:),G2H2(59),m3h2x2(:,51),heltab2x4(:,:,51))
  call Hloop_AQ_V(ntryL,G2H4(18),ex1(:),G2H2(60),m3h2x2(:,52),heltab2x4(:,:,52))
  call Hloop_AQ_V(ntryL,G2H4(19),ex3(:),G2H2(61),m3h2x2(:,53),heltab2x4(:,:,53))
  call Hloop_AQ_V(ntryL,G2H4(21),ex3(:),G2H2(62),m3h2x2(:,54),heltab2x4(:,:,54))
  call Hotf_5pt_reduction(G2H6(15),RedSet_5(61),mass5set(:,18),  & 
G1H6(97),G1H6(99),G1H6(111),G1H6(112),G1H6(113),G1H6(114),6)
  call HG1shiftOLR(G1H6(99),16,6)
  call Hotf_5pt_reduction(G2H12(13),RedSet_5(62),mass5set(:,19),  & 
G1H12(26),G1H12(14),G1H12(19),G1H12(25),G1H12(1),G1H12(2),12)
  call HG1shiftOLR(G1H12(14),16,12)
  call Hotf_5pt_reduction(G2H6(17),RedSet_5(63),mass5set(:,18),  & 
G1H6(115),G1H6(116),G1H6(117),G1H6(118),G1H6(119),G1H6(120),6)
  call HG1shiftOLR(G1H6(116),16,6)
  call Hotf_5pt_reduction(G2H12(14),RedSet_5(64),mass5set(:,19),  & 
G1H12(3),G1H12(4),G1H12(22),G1H12(24),G1H12(16),G1H12(18),12)
  call HG1shiftOLR(G1H12(4),16,12)
  call Hotf_5pt_reduction(G2H12(15),RedSet_5(65),mass5set(:,20),  & 
G1H12(32),G1H12(37),G1H12(38),G1H12(44),G1H12(15),G1H12(17),12)
  call HG1shiftOLR(G1H12(37),12,12)
  call Hotf_5pt_reduction(G2H6(1),RedSet_5(66),mass5set(:,21),  & 
G1H6(121),G1H6(122),G1H6(123),G1H6(124),G1H6(125),G1H6(126),6)
  call HG1shiftOLR(G1H6(122),16,6)
  call Hotf_5pt_reduction(G2H12(16),RedSet_5(67),mass5set(:,20),  & 
G1H12(21),G1H12(23),G1H12(27),G1H12(28),G1H12(33),G1H12(34),12)
  call HG1shiftOLR(G1H12(23),12,12)
  call Hotf_5pt_reduction(G2H12(1),RedSet_5(68),mass5set(:,20),  & 
G1H12(39),G1H12(40),G1H12(42),G1H12(45),G1H12(46),G1H12(47),12)
  call HG1shiftOLR(G1H12(40),16,12)
  call Hotf_5pt_reduction(G2H6(2),RedSet_5(69),mass5set(:,21),  & 
G1H6(127),G1H6(128),G1H6(129),G1H6(130),G1H6(131),G1H6(132),6)
  call HG1shiftOLR(G1H6(128),16,6)
  call Hotf_5pt_reduction(G2H12(2),RedSet_5(70),mass5set(:,20),  & 
G1H12(48),G1H12(52),G1H12(5),G1H12(6),G1H12(9),G1H12(10),12)
  call HG1shiftOLR(G1H12(52),16,12)
  call Hloop_QA_V(ntryL,G2H12(3),ex4(:),G2H6(9),m3h2x6(:,57),heltab2x12(:,:,87))
  call Hotf_5pt_reduction(G2H12(4),RedSet_5(71),mass5set(:,22),  & 
G1H12(12),G1H12(35),G1H12(43),G1H12(29),G1H12(36),G1H12(30),12)
  call HG1shiftOLR(G1H12(35),17,12)
  call Hloop_AQ_V(ntryL,G2H12(10),wf6(:,6),G2H2(63),m3h6x2(:,1),heltab2x12(:,:,88))
  call Hloop_AQ_V(ntryL,G2H12(9),ex3(:),G2H6(11),m3h2x6(:,58),heltab2x12(:,:,89))
  call Hotf_5pt_reduction(G2H12(5),RedSet_5(72),mass5set(:,22),  & 
G1H12(7),G1H12(20),G1H12(53),G1H12(54),G1H12(55),G1H12(56),12)
  call HG1shiftOLR(G1H12(20),17,12)
  call Hloop_QA_V(ntryL,G2H12(6),ex4(:),G2H6(10),m3h2x6(:,59),heltab2x12(:,:,90))
  call Hotf_5pt_reduction(G2H12(7),RedSet_5(73),mass5set(:,22),  & 
G1H12(57),G1H12(58),G1H12(59),G1H12(60),G1H12(61),G1H12(62),12)
  call HG1shiftOLR(G1H12(58),18,12)
  call Hloop_QA_V(ntryL,G2H12(8),wf6(:,8),G2H2(64),m3h6x2(:,2),heltab2x12(:,:,91))
  call Hloop_AQ_V(ntryL,G2H12(11),ex3(:),G2H6(13),m3h2x6(:,60),heltab2x12(:,:,92))
  call Hotf_5pt_reduction(G2H12(12),RedSet_5(74),mass5set(:,22),  & 
G1H12(63),G1H12(64),G1H12(65),G1H12(66),G1H12(67),G1H12(68),12)
  call HG1shiftOLR(G1H12(64),18,12)
  call Hotf_5pt_reduction(G2H12(17),RedSet_5(4),mass5set(:,2),  & 
G1H12(69),G1H12(70),G1H12(71),G1H12(72),G1H12(73),G1H12(74),12)
  call HG1shiftOLR(G1H12(70),20,12)
  call Hloop_QA_V(ntryL,G2H12(18),ex2(:),G2H6(16),m3h2x6(:,61),heltab2x12(:,:,93))
  call Hotf_5pt_reduction(G2H12(19),RedSet_5(6),mass5set(:,2),  & 
G1H12(75),G1H12(76),G1H12(77),G1H12(78),G1H12(79),G1H12(80),12)
  call HG1shiftOLR(G1H12(76),20,12)
  call Hotf_5pt_reduction(G2H12(20),RedSet_5(25),mass5set(:,2),  & 
G1H12(81),G1H12(82),G1H12(83),G1H12(84),G1H12(85),G1H12(86),12)
  call HG1shiftOLR(G1H12(82),8,12)
  call Hloop_AQ_V(ntryL,G2H12(21),ex1(:),G2H6(19),m3h2x6(:,62),heltab2x12(:,:,94))
  call Hotf_5pt_reduction(G2H12(22),RedSet_5(23),mass5set(:,2),  & 
G1H12(87),G1H12(88),G1H12(89),G1H12(90),G1H12(91),G1H12(92),12)
  call HG1shiftOLR(G1H12(88),8,12)
  call Hloop_AQ_V(ntryL,G2H12(23),wf6(:,2),G2H2(65),m3h6x2(:,3),heltab2x12(:,:,95))
  call Hotf_5pt_reduction(G2H12(24),RedSet_5(3),mass5set(:,2),  & 
G1H12(93),G1H12(94),G1H12(95),G1H12(96),G1H12(97),G1H12(98),12)
  call HG1shiftOLR(G1H12(94),24,12)
  call Hloop_QA_V(ntryL,G2H12(25),ex2(:),G2H6(21),m3h2x6(:,63),heltab2x12(:,:,96))
  call Hotf_5pt_reduction(G2H12(26),RedSet_5(5),mass5set(:,2),  & 
G1H12(99),G1H12(100),G1H12(101),G1H12(102),G1H12(103),G1H12(104),12)
  call HG1shiftOLR(G1H12(100),24,12)
  call Hotf_5pt_reduction(G2H12(27),RedSet_5(26),mass5set(:,2),  & 
G1H12(105),G1H12(106),G1H12(107),G1H12(108),G1H12(109),G1H12(110),12)
  call HG1shiftOLR(G1H12(106),4,12)
  call Hloop_AQ_V(ntryL,G2H12(28),ex1(:),G2H6(22),m3h2x6(:,64),heltab2x12(:,:,97))
  call Hotf_5pt_reduction(G2H12(29),RedSet_5(24),mass5set(:,2),  & 
G1H12(111),G1H12(112),G1H12(113),G1H12(114),G1H12(115),G1H12(116),12)
  call HG1shiftOLR(G1H12(112),4,12)
  call Hloop_QA_V(ntryL,G2H12(30),wf6(:,4),G2H2(66),m3h6x2(:,4),heltab2x12(:,:,98))
  call Hotf_4pt_reduction(G2H6(8),RedSet_4(56),mass4set(:,1),  & 
G1H6(133),G1H6(134),G1H6(135),G1H6(136),G1H6(137),6)
  call HG1shiftOLR(G1H6(134),24,6)
  call Hotf_4pt_reduction(G2H6(28),RedSet_4(70),mass4set(:,1),  & 
G1H6(138),G1H6(139),G1H6(140),G1H6(141),G1H6(142),6)
  call HG1shiftOLR(G1H6(139),20,6)
  call Hloop_AQ_V(ntryL,G2H4(35),ex3(:),G2H2(67),m3h2x2(:,55),heltab2x4(:,:,55))
  call Hloop_AQ_V(ntryL,G2H4(37),ex3(:),G2H2(68),m3h2x2(:,56),heltab2x4(:,:,56))
  call Hloop_AQ_V(ntryL,G2H4(38),ex3(:),G2H2(69),m3h2x2(:,57),heltab2x4(:,:,57))
  call Hloop_QA_V(ntryL,G2H4(39),ex4(:),G2H2(70),m3h2x2(:,58),heltab2x4(:,:,58))
  call Hloop_QA_V(ntryL,G2H4(41),ex4(:),G2H2(71),m3h2x2(:,59),heltab2x4(:,:,59))
  call Hloop_QA_V(ntryL,G2H4(42),ex4(:),G2H2(72),m3h2x2(:,60),heltab2x4(:,:,60))
  call Hotf_5pt_reduction(G2H8(7),RedSet_5(31),mass5set(:,10),  & 
G1H8(1),G1H8(2),G1H8(3),G1H8(4),G1H8(5),G1H8(6),8)
  call HG1shiftOLR(G1H8(2),8,8)
  call Hotf_4pt_reduction(G2H8(9),RedSet_4(101),mass4set(:,2),  & 
G1H8(7),G1H8(8),G1H8(9),G1H8(10),G1H8(11),8)
  call HG1shiftOLR(G1H8(8),8,8)
  call Hotf_4pt_reduction(G2H8(11),RedSet_4(234),mass4set(:,2),  & 
G1H8(12),G1H8(13),G1H8(14),G1H8(15),G1H8(16),8)
  call HG1shiftOLR(G1H8(13),11,8)
  call Hotf_5pt_reduction(G2H6(31),RedSet_5(32),mass5set(:,10),  & 
G1H6(143),G1H6(144),G1H6(145),G1H6(146),G1H6(147),G1H6(148),6)
  call HG1shiftOLR(G1H6(144),8,6)
  call Hotf_4pt_reduction(G2H6(33),RedSet_4(101),mass4set(:,2),  & 
G1H6(149),G1H6(150),G1H6(151),G1H6(152),G1H6(153),6)
  call HG1shiftOLR(G1H6(150),8,6)
  call Hotf_4pt_reduction(G2H6(34),RedSet_4(169),mass4set(:,2),  & 
G1H6(154),G1H6(155),G1H6(156),G1H6(157),G1H6(158),6)
  call HG1shiftOLR(G1H6(155),24,6)
  call Hloop_QA_V(ntryL,G2H8(12),ex2(:),G2H4(2),m3h2x4(:,21),heltab2x8(:,:,21))
  call Hloop_QA_V(ntryL,G2H8(15),ex2(:),G2H4(5),m3h2x4(:,22),heltab2x8(:,:,22))
  call Hloop_QA_V(ntryL,G2H8(16),ex2(:),G2H4(8),m3h2x4(:,23),heltab2x8(:,:,23))
  call Hotf_5pt_reduction(G2H8(2),RedSet_5(33),mass5set(:,11),  & 
G1H8(17),G1H8(18),G1H8(19),G1H8(20),G1H8(21),G1H8(22),8)
  call HG1shiftOLR(G1H8(18),2,8)
  call Hotf_4pt_reduction(G2H8(10),RedSet_4(115),mass4set(:,3),  & 
G1H8(23),G1H8(24),G1H8(25),G1H8(26),G1H8(27),8)
  call HG1shiftOLR(G1H8(24),2,8)
  call Hotf_4pt_reduction(G2H8(14),RedSet_4(37),mass4set(:,3),  & 
G1H8(28),G1H8(29),G1H8(30),G1H8(31),G1H8(32),8)
  call HG1shiftOLR(G1H8(29),14,8)
  call Hloop_AQ_V(ntryL,G2H8(1),ex1(:),G2H4(11),m3h2x4(:,24),heltab2x8(:,:,24))
  call Hloop_AQ_V(ntryL,G2H8(4),ex1(:),G2H4(14),m3h2x4(:,25),heltab2x8(:,:,25))
  call Hloop_AQ_V(ntryL,G2H8(5),ex1(:),G2H4(17),m3h2x4(:,26),heltab2x8(:,:,26))
  call Hotf_5pt_reduction(G2H6(37),RedSet_5(34),mass5set(:,11),  & 
G1H6(159),G1H6(160),G1H6(161),G1H6(162),G1H6(163),G1H6(164),6)
  call HG1shiftOLR(G1H6(160),2,6)
  call Hotf_4pt_reduction(G2H6(39),RedSet_4(115),mass4set(:,3),  & 
G1H6(165),G1H6(166),G1H6(167),G1H6(168),G1H6(169),6)
  call HG1shiftOLR(G1H6(166),2,6)
  call Hotf_4pt_reduction(G2H6(40),RedSet_4(213),mass4set(:,3),  & 
G1H6(170),G1H6(171),G1H6(172),G1H6(173),G1H6(174),6)
  call HG1shiftOLR(G1H6(171),18,6)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(8),[G1H6(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(133),[G1H6(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(50),[G1H6(44)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(138),[G1H6(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(7),[G1H8(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(12),[G1H8(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(149),[G1H6(147)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(154),[G1H6(148)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(23),[G1H8(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(28),[G1H8(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(165),[G1H6(163)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(170),[G1H6(164)])
  call Hloop_VQ_A(ntryL,G1H4(44),ex3(:),G1H2(21),m3h2x2(:,61),heltab2x4(:,:,61))
  call Hloop_Q_A(ntryL,G1H2(21),55,nMB,G2H2(73),n2h2(45))
call HGT_raise_alpha_OLR(G1H4(48),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(48),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(48),ex4(:),G1H2(22),m3h2x2(:,62),heltab2x4(:,:,62))
  call Hloop_VQ_A(ntryL,G1H4(30),ex3(:),G1H2(27),m3h2x2(:,63),heltab2x4(:,:,63))
  call Hloop_Q_A(ntryL,G1H2(27),55,nMB,G2H2(74),n2h2(46))
  call Hloop_VQ_A(ntryL,G1H4(42),ex3(:),G1H2(28),m3h2x2(:,64),heltab2x4(:,:,64))
  call Hloop_Q_A(ntryL,G1H2(28),55,nMB,G2H2(75),n2h2(47))
  call Hloop_VA_Q(ntryL,G1H4(1),ex4(:),G1H2(9),m3h2x2(:,65),heltab2x4(:,:,65))
  call Hloop_A_Q(ntryL,G1H2(9),59,nMB,G2H2(76),n2h2(48))
call HGT_raise_alpha_OLR(G1H4(2),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(2),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(2),ex3(:),G1H2(10),m3h2x2(:,66),heltab2x4(:,:,66))
  call Hloop_VA_Q(ntryL,G1H4(12),ex4(:),G1H2(15),m3h2x2(:,67),heltab2x4(:,:,67))
  call Hloop_A_Q(ntryL,G1H2(15),59,nMB,G2H2(77),n2h2(49))
  call Hloop_VA_Q(ntryL,G1H4(13),ex4(:),G1H2(16),m3h2x2(:,68),heltab2x4(:,:,68))
  call Hloop_A_Q(ntryL,G1H2(16),59,nMB,G2H2(78),n2h2(50))
  call Hloop_VQ_A(ntryL,G1H4(14),ex3(:),G1H2(21),m3h2x2(:,69),heltab2x4(:,:,69))
  call Hloop_Q_A(ntryL,G1H2(21),55,nMB,G2H2(79),n2h2(51))
call HGT_raise_alpha_OLR(G1H4(19),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(19),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(19),ex4(:),G1H2(27),m3h2x2(:,70),heltab2x4(:,:,70))
  call Hloop_VQ_A(ntryL,G1H4(25),ex3(:),G1H2(28),m3h2x2(:,71),heltab2x4(:,:,71))
  call Hloop_Q_A(ntryL,G1H2(28),55,nMB,G2H2(80),n2h2(52))
  call Hloop_VQ_A(ntryL,G1H4(26),ex3(:),G1H2(9),m3h2x2(:,72),heltab2x4(:,:,72))
  call Hloop_Q_A(ntryL,G1H2(9),55,nMB,G2H2(81),n2h2(53))
  call Hloop_VA_Q(ntryL,G1H4(31),ex4(:),G1H2(15),m3h2x2(:,73),heltab2x4(:,:,73))
  call Hloop_A_Q(ntryL,G1H2(15),59,nMB,G2H2(82),n2h2(54))
call HGT_raise_alpha_OLR(G1H4(32),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(32),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(32),ex3(:),G1H2(16),m3h2x2(:,74),heltab2x4(:,:,74))
  call Hloop_VA_Q(ntryL,G1H4(38),ex4(:),G1H2(21),m3h2x2(:,75),heltab2x4(:,:,75))
  call Hloop_A_Q(ntryL,G1H2(21),59,nMB,G2H2(83),n2h2(55))
  call Hloop_VA_Q(ntryL,G1H4(43),ex4(:),G1H2(28),m3h2x2(:,76),heltab2x4(:,:,76))
  call Hloop_A_Q(ntryL,G1H2(28),59,nMB,G2H2(84),n2h2(56))
  call Hloop_QZ_A(ntryL,G1H6(59),ex5(:),G1H2(9),ngZd,m3h3x2(:,29),heltab2x6(:,:,69))
  call Hloop_Q_A(ntryL,G1H2(9),55,nMB,G2H2(85),n2h2(57))
call HGT_raise_alpha_OLR(G1H6(60),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(60),2,5,6)
  call Hloop_VA_Q(ntryL,G1H6(60),ex4(:),G1H3(9),m3h2x3(:,41),heltab2x6(:,:,70))
  call Hloop_QZ_A(ntryL,G1H6(66),ex5(:),G1H2(15),ngZd,m3h3x2(:,30),heltab2x6(:,:,71))
  call Hloop_Q_A(ntryL,G1H2(15),55,nMB,G2H2(86),n2h2(58))
  call Hloop_QZ_A(ntryL,G1H6(71),ex5(:),G1H2(21),ngZd,m3h3x2(:,31),heltab2x6(:,:,72))
  call Hloop_Q_A(ntryL,G1H2(21),55,nMB,G2H2(87),n2h2(59))
  call Hloop_AZ_Q(ntryL,G1H6(72),ex5(:),G1H2(28),ngZd,m3h3x2(:,32),heltab2x6(:,:,73))
  call Hloop_A_Q(ntryL,G1H2(28),59,nMB,G2H2(88),n2h2(60))
call HGT_raise_alpha_OLR(G1H6(76),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(76),2,5,6)
  call Hloop_VQ_A(ntryL,G1H6(76),ex3(:),G1H3(10),m3h2x3(:,42),heltab2x6(:,:,74))
  call Hloop_AZ_Q(ntryL,G1H6(83),ex5(:),G1H2(9),ngZd,m3h3x2(:,33),heltab2x6(:,:,75))
  call Hloop_A_Q(ntryL,G1H2(9),59,nMB,G2H2(89),n2h2(61))
  call Hloop_AZ_Q(ntryL,G1H6(84),ex5(:),G1H2(15),ngZd,m3h3x2(:,34),heltab2x6(:,:,76))
  call Hloop_A_Q(ntryL,G1H2(15),59,nMB,G2H2(90),n2h2(62))
  call Hloop_QZ_A(ntryL,G1H6(88),ex5(:),G1H2(21),ngZd,m3h3x2(:,35),heltab2x6(:,:,77))
  call Hloop_Q_A(ntryL,G1H2(21),55,nMB,G2H2(91),n2h2(63))
call HGT_raise_alpha_OLR(G1H6(89),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(89),2,5,6)
  call Hloop_VA_Q(ntryL,G1H6(89),ex4(:),G1H3(15),m3h2x3(:,43),heltab2x6(:,:,78))
  call Hloop_QZ_A(ntryL,G1H6(96),ex5(:),G1H2(28),ngZd,m3h3x2(:,36),heltab2x6(:,:,79))
  call Hloop_Q_A(ntryL,G1H2(28),55,nMB,G2H2(92),n2h2(64))
  call Hloop_QZ_A(ntryL,G1H6(100),ex5(:),G1H2(9),ngZd,m3h3x2(:,37),heltab2x6(:,:,80))
  call Hloop_Q_A(ntryL,G1H2(9),55,nMB,G2H2(93),n2h2(65))
  call Hloop_AZ_Q(ntryL,G1H6(58),ex5(:),G1H2(15),ngZd,m3h3x2(:,38),heltab2x6(:,:,81))
  call Hloop_A_Q(ntryL,G1H2(15),59,nMB,G2H2(94),n2h2(66))
call HGT_raise_alpha_OLR(G1H6(70),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(70),2,5,6)
  call Hloop_VQ_A(ntryL,G1H6(70),ex3(:),G1H3(16),m3h2x3(:,44),heltab2x6(:,:,82))
  call Hloop_AZ_Q(ntryL,G1H6(22),ex5(:),G1H2(21),ngZd,m3h3x2(:,39),heltab2x6(:,:,83))
  call Hloop_A_Q(ntryL,G1H2(21),59,nMB,G2H2(95),n2h2(67))
  call Hloop_AZ_Q(ntryL,G1H6(24),ex5(:),G1H2(28),ngZd,m3h3x2(:,40),heltab2x6(:,:,84))
  call Hloop_A_Q(ntryL,G1H2(28),59,nMB,G2H2(96),n2h2(68))
  call Hloop_QZ_A(ntryL,G1H6(28),ex5(:),G1H2(9),ngZu,m3h3x2(:,41),heltab2x6(:,:,85))
  call Hloop_Q_A(ntryL,G1H2(9),61,nMT,G2H2(97),n2h2(69))
call HGT_raise_alpha_OLR(G1H6(29),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(29),2,5,6)
  call Hloop_VA_Q(ntryL,G1H6(29),ex2(:),G1H3(21),m3h2x3(:,45),heltab2x6(:,:,86))
  call Hloop_QZ_A(ntryL,G1H6(36),ex5(:),G1H2(15),ngZu,m3h3x2(:,42),heltab2x6(:,:,87))
  call Hloop_Q_A(ntryL,G1H2(15),61,nMT,G2H2(98),n2h2(70))
  call Hloop_QZ_A(ntryL,G1H6(40),ex5(:),G1H2(21),ngZu,m3h3x2(:,43),heltab2x6(:,:,88))
  call Hloop_Q_A(ntryL,G1H2(21),61,nMT,G2H2(99),n2h2(71))
  call Hloop_QZ_A(ntryL,G1H6(41),ex5(:),G1H2(28),ngZd,m3h3x2(:,44),heltab2x6(:,:,89))
  call Hloop_Q_A(ntryL,G1H2(28),55,nMB,G2H2(100),n2h2(72))
call HGT_raise_alpha_OLR(G1H6(42),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(42),2,5,6)
  call Hloop_VA_Q(ntryL,G1H6(42),ex4(:),G1H3(22),m3h2x3(:,46),heltab2x6(:,:,90))
  call Hloop_QZ_A(ntryL,G1H6(48),ex5(:),G1H2(9),ngZd,m3h3x2(:,45),heltab2x6(:,:,91))
  call Hloop_Q_A(ntryL,G1H2(9),55,nMB,G2H2(101),n2h2(73))
  call Hloop_QZ_A(ntryL,G1H6(52),ex5(:),G1H2(15),ngZd,m3h3x2(:,46),heltab2x6(:,:,92))
  call Hloop_Q_A(ntryL,G1H2(15),55,nMB,G2H2(102),n2h2(74))
  call Hloop_AZ_Q(ntryL,G1H6(53),ex5(:),G1H2(21),ngZu,m3h3x2(:,47),heltab2x6(:,:,93))
  call Hloop_A_Q(ntryL,G1H2(21),62,nMT,G2H2(103),n2h2(75))
call HGT_raise_alpha_OLR(G1H6(54),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(54),2,5,6)
  call Hloop_VQ_A(ntryL,G1H6(54),ex1(:),G1H3(27),m3h2x3(:,47),heltab2x6(:,:,94))
  call Hloop_AZ_Q(ntryL,G1H6(57),ex5(:),G1H2(28),ngZu,m3h3x2(:,48),heltab2x6(:,:,95))
  call Hloop_A_Q(ntryL,G1H2(28),62,nMT,G2H2(104),n2h2(76))
  call Hloop_AZ_Q(ntryL,G1H6(25),ex5(:),G1H2(9),ngZu,m3h3x2(:,49),heltab2x6(:,:,96))
  call Hloop_A_Q(ntryL,G1H2(9),62,nMT,G2H2(105),n2h2(77))
  call Hloop_AZ_Q(ntryL,G1H6(12),ex5(:),G1H2(15),ngZd,m3h3x2(:,50),heltab2x6(:,:,97))
  call Hloop_A_Q(ntryL,G1H2(15),59,nMB,G2H2(106),n2h2(78))
call HGT_raise_alpha_OLR(G1H6(69),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(69),2,5,6)
  call Hloop_VQ_A(ntryL,G1H6(69),ex3(:),G1H3(28),m3h2x3(:,48),heltab2x6(:,:,98))
  call Hloop_AZ_Q(ntryL,G1H6(81),ex5(:),G1H2(21),ngZd,m3h3x2(:,51),heltab2x6(:,:,99))
  call Hloop_A_Q(ntryL,G1H2(21),59,nMB,G2H2(107),n2h2(79))
  call Hloop_AZ_Q(ntryL,G1H6(13),ex5(:),G1H2(28),ngZd,m3h3x2(:,52),heltab2x6(:,:,100))
  call Hloop_A_Q(ntryL,G1H2(28),59,nMB,G2H2(108),n2h2(80))
  call Hloop_VQ_A(ntryL,G1H6(16),ex3(:),G1H3(33),m3h2x3(:,49),heltab2x6(:,:,101))
  call Hloop_Q_A(ntryL,G1H3(33),47,nMB,G2H3(25),n2h3(33))
call HGT_OLR(G1H6(93),1,1,6)
call HGT_invQ_OLR(G1H6(93),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(93),-16,nMB,G2H6(23),n2h6(57))
  call Hloop_AZ_Q(ntryL,G2H6(23),ex5(:),G2H2(109),ngZd,m3h3x2(:,53),heltab2x6(:,:,102))
  call Hloop_VQ_A(ntryL,G1H6(21),ex3(:),G1H3(34),m3h2x3(:,50),heltab2x6(:,:,103))
  call Hloop_Q_A(ntryL,G1H3(34),47,nMB,G2H3(26),n2h3(34))
  call Hloop_VQ_A(ntryL,G1H6(9),ex3(:),G1H3(39),m3h2x3(:,51),heltab2x6(:,:,104))
  call Hloop_Q_A(ntryL,G1H3(39),47,nMB,G2H3(27),n2h3(35))
  call Hloop_VA_Q(ntryL,G1H6(27),ex4(:),G1H3(40),m3h2x3(:,52),heltab2x6(:,:,105))
  call Hloop_A_Q(ntryL,G1H3(40),47,nMB,G2H3(28),n2h3(36))
call HGT_OLR(G1H6(15),1,1,6)
call HGT_invQ_OLR(G1H6(15),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(15),-16,nMB,G2H6(24),n2h6(58))
  call Hloop_QZ_A(ntryL,G2H6(24),ex5(:),G2H2(110),ngZd,m3h3x2(:,54),heltab2x6(:,:,106))
  call Hloop_VA_Q(ntryL,G1H6(33),ex4(:),G1H3(45),m3h2x3(:,53),heltab2x6(:,:,107))
  call Hloop_A_Q(ntryL,G1H3(45),47,nMB,G2H3(29),n2h3(37))
  call Hloop_VA_Q(ntryL,G1H6(37),ex4(:),G1H3(46),m3h2x3(:,54),heltab2x6(:,:,108))
  call Hloop_A_Q(ntryL,G1H3(46),47,nMB,G2H3(30),n2h3(38))
  call Hloop_VQ_A(ntryL,G1H6(51),ex1(:),G1H3(51),m3h2x3(:,55),heltab2x6(:,:,109))
  call Hloop_Q_A(ntryL,G1H3(51),47,nMT,G2H3(31),n2h3(39))
call HGT_OLR(G1H6(39),1,1,6)
call HGT_invQ_OLR(G1H6(39),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(39),-16,nMT,G2H6(18),n2h6(59))
  call Hloop_AZ_Q(ntryL,G2H6(18),ex5(:),G2H2(111),ngZu,m3h3x2(:,55),heltab2x6(:,:,110))
  call Hloop_VQ_A(ntryL,G1H6(80),ex1(:),G1H3(52),m3h2x3(:,56),heltab2x6(:,:,111))
  call Hloop_Q_A(ntryL,G1H3(52),47,nMT,G2H3(32),n2h3(40))
  call Hloop_VQ_A(ntryL,G1H6(56),ex1(:),G1H3(33),m3h2x3(:,57),heltab2x6(:,:,112))
  call Hloop_Q_A(ntryL,G1H3(33),47,nMT,G2H3(33),n2h3(41))
  call Hloop_VA_Q(ntryL,G1H6(86),ex2(:),G1H3(34),m3h2x3(:,58),heltab2x6(:,:,113))
  call Hloop_A_Q(ntryL,G1H3(34),47,nMT,G2H3(34),n2h3(42))
call HGT_OLR(G1H6(62),1,1,6)
call HGT_invQ_OLR(G1H6(62),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(62),-16,nMT,G2H6(20),n2h6(60))
  call Hloop_QZ_A(ntryL,G2H6(20),ex5(:),G2H2(112),ngZu,m3h3x2(:,56),heltab2x6(:,:,114))
  call Hloop_VA_Q(ntryL,G1H6(98),ex2(:),G1H3(39),m3h2x3(:,59),heltab2x6(:,:,115))
  call Hloop_A_Q(ntryL,G1H3(39),47,nMT,G2H3(35),n2h3(43))
  call Hloop_VA_Q(ntryL,G1H6(74),ex2(:),G1H3(40),m3h2x3(:,60),heltab2x6(:,:,116))
  call Hloop_A_Q(ntryL,G1H3(40),47,nMT,G2H3(36),n2h3(44))
  call Hloop_VQ_A(ntryL,G1H4(5),ex3(:),G1H2(9),m3h2x2(:,77),heltab2x4(:,:,77))
  call Hloop_Q_A(ntryL,G1H2(9),55,nMB,G2H2(113),n2h2(81))
call HGT_raise_alpha_OLR(G1H4(17),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(17),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(17),ex4(:),G1H2(15),m3h2x2(:,78),heltab2x4(:,:,78))
  call Hloop_VQ_A(ntryL,G1H4(3),ex3(:),G1H2(21),m3h2x2(:,79),heltab2x4(:,:,79))
  call Hloop_Q_A(ntryL,G1H2(21),55,nMB,G2H2(114),n2h2(82))
  call Hloop_VQ_A(ntryL,G1H4(4),ex3(:),G1H2(28),m3h2x2(:,80),heltab2x4(:,:,80))
  call Hloop_Q_A(ntryL,G1H2(28),55,nMB,G2H2(115),n2h2(83))
  call Hloop_VQ_A(ntryL,G1H4(15),ex3(:),G1H2(9),m3h2x2(:,81),heltab2x4(:,:,81))
  call Hloop_Q_A(ntryL,G1H2(9),55,nMB,G2H2(116),n2h2(84))
call HGT_raise_alpha_OLR(G1H4(16),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(16),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(16),ex4(:),G1H2(21),m3h2x2(:,82),heltab2x4(:,:,82))
  call Hloop_VQ_A(ntryL,G1H4(39),ex3(:),G1H2(28),m3h2x2(:,83),heltab2x4(:,:,83))
  call Hloop_Q_A(ntryL,G1H2(28),55,nMB,G2H2(117),n2h2(85))
  call Hloop_VQ_A(ntryL,G1H4(40),ex3(:),G1H2(9),m3h2x2(:,84),heltab2x4(:,:,84))
  call Hloop_Q_A(ntryL,G1H2(9),55,nMB,G2H2(118),n2h2(86))
  call Hloop_VA_Q(ntryL,G1H4(9),ex4(:),G1H2(28),m3h2x2(:,85),heltab2x4(:,:,85))
  call Hloop_A_Q(ntryL,G1H2(28),59,nMB,G2H2(119),n2h2(87))
call HGT_raise_alpha_OLR(G1H4(10),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(10),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(10),ex3(:),G1H2(9),m3h2x2(:,86),heltab2x4(:,:,86))
  call Hloop_VA_Q(ntryL,G1H4(50),ex4(:),G1H2(28),m3h2x2(:,87),heltab2x4(:,:,87))
  call Hloop_A_Q(ntryL,G1H2(28),59,nMB,G2H2(120),n2h2(88))
  call Hloop_VA_Q(ntryL,G1H4(51),ex4(:),G1H2(28),m3h2x2(:,88),heltab2x4(:,:,88))
  call Hloop_A_Q(ntryL,G1H2(28),59,nMB,G2H2(121),n2h2(89))
  call Hloop_VA_Q(ntryL,G1H4(52),ex4(:),G1H2(28),m3h2x2(:,89),heltab2x4(:,:,89))
  call Hloop_A_Q(ntryL,G1H2(28),59,nMB,G2H2(122),n2h2(90))
call HGT_raise_alpha_OLR(G1H4(53),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(53),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(53),ex3(:),G1H2(28),m3h2x2(:,90),heltab2x4(:,:,90))
  call Hloop_VA_Q(ntryL,G1H4(56),ex4(:),G1H2(33),m3h2x2(:,91),heltab2x4(:,:,91))
  call Hloop_A_Q(ntryL,G1H2(33),59,nMB,G2H2(123),n2h2(91))
  call Hloop_VA_Q(ntryL,G1H4(57),ex4(:),G1H2(33),m3h2x2(:,92),heltab2x4(:,:,92))
  call Hloop_A_Q(ntryL,G1H2(33),59,nMB,G2H2(124),n2h2(92))
  call Hloop_VQ_A(ntryL,G1H4(21),ex3(:),G1H2(33),m3h2x2(:,93),heltab2x4(:,:,93))
  call Hloop_Q_A(ntryL,G1H2(33),55,nMB,G2H2(125),n2h2(93))
call HGT_raise_alpha_OLR(G1H4(22),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(22),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(22),ex4(:),G1H2(33),m3h2x2(:,94),heltab2x4(:,:,94))
  call Hloop_VQ_A(ntryL,G1H4(59),ex3(:),G1H2(34),m3h2x2(:,95),heltab2x4(:,:,95))
  call Hloop_Q_A(ntryL,G1H2(34),55,nMB,G2H2(126),n2h2(94))
  call Hloop_VQ_A(ntryL,G1H4(60),ex3(:),G1H2(34),m3h2x2(:,96),heltab2x4(:,:,96))
  call Hloop_Q_A(ntryL,G1H2(34),55,nMB,G2H2(127),n2h2(95))
  call Hloop_VQ_A(ntryL,G1H4(61),ex3(:),G1H2(34),m3h2x2(:,97),heltab2x4(:,:,97))
  call Hloop_Q_A(ntryL,G1H2(34),55,nMB,G2H2(128),n2h2(96))
call HGT_raise_alpha_OLR(G1H4(62),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(62),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(62),ex4(:),G1H2(34),m3h2x2(:,98),heltab2x4(:,:,98))
  call Hloop_VQ_A(ntryL,G1H4(65),ex3(:),G1H2(35),m3h2x2(:,99),heltab2x4(:,:,99))
  call Hloop_Q_A(ntryL,G1H2(35),55,nMB,G2H2(129),n2h2(97))
  call Hloop_VQ_A(ntryL,G1H4(66),ex3(:),G1H2(35),m3h2x2(:,100),heltab2x4(:,:,100))
  call Hloop_Q_A(ntryL,G1H2(35),55,nMB,G2H2(130),n2h2(98))
  call Hloop_VA_Q(ntryL,G1H4(33),ex4(:),G1H2(35),m3h2x2(:,101),heltab2x4(:,:,101))
  call Hloop_A_Q(ntryL,G1H2(35),59,nMB,G2H2(131),n2h2(99))
call HGT_raise_alpha_OLR(G1H4(34),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(34),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(34),ex3(:),G1H2(35),m3h2x2(:,102),heltab2x4(:,:,102))
  call Hloop_VA_Q(ntryL,G1H4(68),ex4(:),G1H2(36),m3h2x2(:,103),heltab2x4(:,:,103))
  call Hloop_A_Q(ntryL,G1H2(36),59,nMB,G2H2(132),n2h2(100))
  call Hloop_VA_Q(ntryL,G1H4(69),ex4(:),G1H2(36),m3h2x2(:,104),heltab2x4(:,:,104))
  call Hloop_A_Q(ntryL,G1H2(36),59,nMB,G2H2(133),n2h2(101))
  call Hloop_VA_Q(ntryL,G1H4(70),ex4(:),G1H2(36),m3h2x2(:,105),heltab2x4(:,:,105))
  call Hloop_A_Q(ntryL,G1H2(36),59,nMB,G2H2(134),n2h2(102))
call HGT_raise_alpha_OLR(G1H4(71),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(71),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(71),ex3(:),G1H2(36),m3h2x2(:,106),heltab2x4(:,:,106))
  call Hloop_VA_Q(ntryL,G1H4(74),ex4(:),G1H2(37),m3h2x2(:,107),heltab2x4(:,:,107))
  call Hloop_A_Q(ntryL,G1H2(37),59,nMB,G2H2(135),n2h2(103))
  call Hloop_VA_Q(ntryL,G1H4(75),ex4(:),G1H2(37),m3h2x2(:,108),heltab2x4(:,:,108))
  call Hloop_A_Q(ntryL,G1H2(37),59,nMB,G2H2(136),n2h2(104))
  call Hloop_QZ_A(ntryL,G1H6(79),ex5(:),G1H2(37),ngZd,m3h3x2(:,57),heltab2x6(:,:,117))
  call Hloop_Q_A(ntryL,G1H2(37),55,nMB,G2H2(137),n2h2(105))
call HGT_raise_alpha_OLR(G1H6(91),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(91),2,5,6)
  call Hloop_VA_Q(ntryL,G1H6(91),ex4(:),G1H3(45),m3h2x3(:,61),heltab2x6(:,:,118))
  call Hloop_QZ_A(ntryL,G1H6(8),ex5(:),G1H2(37),ngZd,m3h3x2(:,58),heltab2x6(:,:,119))
  call Hloop_Q_A(ntryL,G1H2(37),55,nMB,G2H2(138),n2h2(106))
  call Hloop_QZ_A(ntryL,G1H6(133),ex5(:),G1H2(37),ngZd,m3h3x2(:,59),heltab2x6(:,:,120))
  call Hloop_Q_A(ntryL,G1H2(37),55,nMB,G2H2(139),n2h2(107))
call HGT_raise_alpha_OLR(G1H6(14),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(14),2,5,6)
  call Hloop_VA_Q(ntryL,G1H6(14),ex4(:),G1H3(46),m3h2x3(:,62),heltab2x6(:,:,121))
  call Hloop_QZ_A(ntryL,G1H6(10),ex5(:),G1H2(37),ngZd,m3h3x2(:,60),heltab2x6(:,:,122))
  call Hloop_Q_A(ntryL,G1H2(37),55,nMB,G2H2(140),n2h2(108))
  call Hloop_AZ_Q(ntryL,G1H6(32),ex5(:),G1H2(37),ngZd,m3h3x2(:,61),heltab2x6(:,:,123))
  call Hloop_A_Q(ntryL,G1H2(37),59,nMB,G2H2(141),n2h2(109))
call HGT_raise_alpha_OLR(G1H6(6),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(6),2,5,6)
  call Hloop_VQ_A(ntryL,G1H6(6),ex3(:),G1H3(51),m3h2x3(:,63),heltab2x6(:,:,124))
  call Hloop_AZ_Q(ntryL,G1H6(50),ex5(:),G1H2(37),ngZd,m3h3x2(:,62),heltab2x6(:,:,125))
  call Hloop_A_Q(ntryL,G1H2(37),59,nMB,G2H2(142),n2h2(110))
  call Hloop_AZ_Q(ntryL,G1H6(138),ex5(:),G1H2(37),ngZd,m3h3x2(:,63),heltab2x6(:,:,126))
  call Hloop_A_Q(ntryL,G1H2(37),59,nMB,G2H2(143),n2h2(111))
call HGT_raise_alpha_OLR(G1H6(61),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(61),2,5,6)
  call Hloop_VQ_A(ntryL,G1H6(61),ex3(:),G1H3(52),m3h2x3(:,64),heltab2x6(:,:,127))
  call Hloop_AZ_Q(ntryL,G1H6(101),ex5(:),G1H2(37),ngZd,m3h3x2(:,64),heltab2x6(:,:,128))
  call Hloop_A_Q(ntryL,G1H2(37),59,nMB,G2H2(144),n2h2(112))
  call Hloop_QZ_A(ntryL,G1H6(75),ex5(:),G1H2(37),ngZd,m3h3x2(:,65),heltab2x6(:,:,129))
  call Hloop_Q_A(ntryL,G1H2(37),55,nMB,G2H2(145),n2h2(113))
call HGT_raise_alpha_OLR(G1H6(102),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(102),2,5,6)
  call Hloop_VA_Q(ntryL,G1H6(102),ex4(:),G1H3(33),m3h2x3(:,65),heltab2x6(:,:,130))
  call Hloop_QZ_A(ntryL,G1H6(105),ex5(:),G1H2(37),ngZd,m3h3x2(:,66),heltab2x6(:,:,131))
  call Hloop_Q_A(ntryL,G1H2(37),55,nMB,G2H2(146),n2h2(114))
  call Hloop_QZ_A(ntryL,G1H6(106),ex5(:),G1H2(37),ngZd,m3h3x2(:,67),heltab2x6(:,:,132))
  call Hloop_Q_A(ntryL,G1H2(37),55,nMB,G2H2(147),n2h2(115))
  call Hloop_AZ_Q(ntryL,G1H6(85),ex5(:),G1H2(37),ngZd,m3h3x2(:,68),heltab2x6(:,:,133))
  call Hloop_A_Q(ntryL,G1H2(37),59,nMB,G2H2(148),n2h2(116))
call HGT_raise_alpha_OLR(G1H6(87),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(87),2,5,6)
  call Hloop_VQ_A(ntryL,G1H6(87),ex3(:),G1H3(34),m3h2x3(:,66),heltab2x6(:,:,134))
  call Hloop_AZ_Q(ntryL,G1H6(109),ex5(:),G1H2(37),ngZd,m3h3x2(:,69),heltab2x6(:,:,135))
  call Hloop_A_Q(ntryL,G1H2(37),59,nMB,G2H2(149),n2h2(117))
  call Hloop_AZ_Q(ntryL,G1H6(110),ex5(:),G1H2(37),ngZd,m3h3x2(:,70),heltab2x6(:,:,136))
  call Hloop_A_Q(ntryL,G1H2(37),59,nMB,G2H2(150),n2h2(118))
  call Hloop_VQ_A(ntryL,G1H6(97),ex3(:),G1H3(39),m3h2x3(:,67),heltab2x6(:,:,137))
  call Hloop_Q_A(ntryL,G1H3(39),47,nMB,G2H3(37),n2h3(45))
call HGT_OLR(G1H6(99),1,1,6)
call HGT_invQ_OLR(G1H6(99),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(99),-16,nMB,G2H6(3),n2h6(67))
  call Hloop_AZ_Q(ntryL,G2H6(3),ex5(:),G2H2(151),ngZd,m3h3x2(:,71),heltab2x6(:,:,138))
  call Hloop_VQ_A(ntryL,G1H6(113),ex3(:),G1H3(40),m3h2x3(:,68),heltab2x6(:,:,139))
  call Hloop_Q_A(ntryL,G1H3(40),47,nMB,G2H3(38),n2h3(46))
  call Hloop_VQ_A(ntryL,G1H6(114),ex3(:),G1H3(39),m3h2x3(:,69),heltab2x6(:,:,140))
  call Hloop_Q_A(ntryL,G1H3(39),47,nMB,G2H3(39),n2h3(47))
  call Hloop_AV_Q(ntryL,G1H12(26),wf4(:,1),G1H3(40),m3h4x3(:,1),heltab2x12(:,:,99))
  call Hloop_A_Q(ntryL,G1H3(40),47,nMB,G2H3(40),n2h3(48))
call HGT_OLR(G1H12(14),1,1,12)
call HGT_invQ_OLR(G1H12(14),2,5,12)
  call Hloop_Q_A(ntryL,G1H12(14),-16,nMB,G2H12(31),n2h12(61))
  call Hloop_QZ_A(ntryL,G2H12(31),ex5(:),G2H4(20),ngZd,m3h3x4(:,31),heltab2x12(:,:,100))
  call Hloop_AV_Q(ntryL,G1H12(1),wf4(:,1),G1H3(39),m3h4x3(:,2),heltab2x12(:,:,101))
  call Hloop_A_Q(ntryL,G1H3(39),47,nMB,G2H3(41),n2h3(49))
  call Hloop_AV_Q(ntryL,G1H12(2),wf4(:,1),G1H3(40),m3h4x3(:,3),heltab2x12(:,:,102))
  call Hloop_A_Q(ntryL,G1H3(40),47,nMB,G2H3(42),n2h3(50))
  call Hloop_VA_Q(ntryL,G1H6(115),ex4(:),G1H3(39),m3h2x3(:,70),heltab2x6(:,:,141))
  call Hloop_A_Q(ntryL,G1H3(39),47,nMB,G2H3(43),n2h3(51))
call HGT_OLR(G1H6(116),1,1,6)
call HGT_invQ_OLR(G1H6(116),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(116),-16,nMB,G2H6(4),n2h6(68))
  call Hloop_QZ_A(ntryL,G2H6(4),ex5(:),G2H2(152),ngZd,m3h3x2(:,72),heltab2x6(:,:,142))
  call Hloop_VA_Q(ntryL,G1H6(119),ex4(:),G1H3(40),m3h2x3(:,71),heltab2x6(:,:,143))
  call Hloop_A_Q(ntryL,G1H3(40),47,nMB,G2H3(44),n2h3(52))
  call Hloop_VA_Q(ntryL,G1H6(120),ex4(:),G1H3(39),m3h2x3(:,72),heltab2x6(:,:,144))
  call Hloop_A_Q(ntryL,G1H3(39),47,nMB,G2H3(45),n2h3(53))
  call Hloop_QV_A(ntryL,G1H12(3),wf4(:,1),G1H3(40),m3h4x3(:,4),heltab2x12(:,:,103))
  call Hloop_Q_A(ntryL,G1H3(40),47,nMB,G2H3(46),n2h3(54))
call HGT_OLR(G1H12(4),1,1,12)
call HGT_invQ_OLR(G1H12(4),2,5,12)
  call Hloop_A_Q(ntryL,G1H12(4),-16,nMB,G2H12(13),n2h12(62))
  call Hloop_AZ_Q(ntryL,G2H12(13),ex5(:),G2H4(23),ngZd,m3h3x4(:,32),heltab2x12(:,:,104))
  call Hloop_QV_A(ntryL,G1H12(16),wf4(:,1),G1H3(39),m3h4x3(:,5),heltab2x12(:,:,105))
  call Hloop_Q_A(ntryL,G1H3(39),47,nMB,G2H3(47),n2h3(55))
  call Hloop_QV_A(ntryL,G1H12(18),wf4(:,1),G1H3(40),m3h4x3(:,6),heltab2x12(:,:,106))
  call Hloop_Q_A(ntryL,G1H3(40),47,nMB,G2H3(48),n2h3(56))
  call Hloop_QZ_A(ntryL,G1H12(32),ex5(:),G1H4(45),ngZu,m3h3x4(:,33),heltab2x12(:,:,107))
  call Hloop_Q_A(ntryL,G1H4(45),51,nMT,G2H4(29),n2h4(55))
call HGT_OLR(G1H12(37),1,1,12)
call HGT_invQ_OLR(G1H12(37),2,5,12)
  call Hloop_A_Q(ntryL,G1H12(37),-12,nMT,G2H12(14),n2h12(63))
  call Hloop_AV_Q(ntryL,G2H12(14),wf4(:,7),G2H3(49),m3h4x3(:,7),heltab2x12(:,:,108))
  call Hloop_QZ_A(ntryL,G1H12(15),ex5(:),G1H4(46),ngZu,m3h3x4(:,34),heltab2x12(:,:,109))
  call Hloop_Q_A(ntryL,G1H4(46),51,nMT,G2H4(28),n2h4(56))
  call Hloop_QZ_A(ntryL,G1H12(17),ex5(:),G1H4(47),ngZu,m3h3x4(:,35),heltab2x12(:,:,110))
  call Hloop_Q_A(ntryL,G1H4(47),51,nMT,G2H4(32),n2h4(57))
  call Hloop_VQ_A(ntryL,G1H6(121),ex1(:),G1H3(39),m3h2x3(:,73),heltab2x6(:,:,145))
  call Hloop_Q_A(ntryL,G1H3(39),47,nMT,G2H3(50),n2h3(57))
call HGT_OLR(G1H6(122),1,1,6)
call HGT_invQ_OLR(G1H6(122),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(122),-16,nMT,G2H6(5),n2h6(69))
  call Hloop_AZ_Q(ntryL,G2H6(5),ex5(:),G2H2(153),ngZu,m3h3x2(:,73),heltab2x6(:,:,146))
  call Hloop_VQ_A(ntryL,G1H6(125),ex1(:),G1H3(40),m3h2x3(:,74),heltab2x6(:,:,147))
  call Hloop_Q_A(ntryL,G1H3(40),47,nMT,G2H3(51),n2h3(58))
  call Hloop_VQ_A(ntryL,G1H6(126),ex1(:),G1H3(39),m3h2x3(:,75),heltab2x6(:,:,148))
  call Hloop_Q_A(ntryL,G1H3(39),47,nMT,G2H3(52),n2h3(59))
  call Hloop_AZ_Q(ntryL,G1H12(21),ex5(:),G1H4(44),ngZu,m3h3x4(:,36),heltab2x12(:,:,111))
  call Hloop_A_Q(ntryL,G1H4(44),51,nMT,G2H4(31),n2h4(58))
call HGT_OLR(G1H12(23),1,1,12)
call HGT_invQ_OLR(G1H12(23),2,5,12)
  call Hloop_Q_A(ntryL,G1H12(23),-12,nMT,G2H12(15),n2h12(64))
  call Hloop_QV_A(ntryL,G2H12(15),wf4(:,7),G2H3(53),m3h4x3(:,8),heltab2x12(:,:,112))
  call Hloop_AZ_Q(ntryL,G1H12(33),ex5(:),G1H4(48),ngZu,m3h3x4(:,37),heltab2x12(:,:,113))
  call Hloop_A_Q(ntryL,G1H4(48),51,nMT,G2H4(27),n2h4(59))
  call Hloop_AZ_Q(ntryL,G1H12(34),ex5(:),G1H4(30),ngZu,m3h3x4(:,38),heltab2x12(:,:,114))
  call Hloop_A_Q(ntryL,G1H4(30),51,nMT,G2H4(33),n2h4(60))
  call Hloop_AV_Q(ntryL,G1H12(39),wf4(:,7),G1H3(40),m3h4x3(:,9),heltab2x12(:,:,115))
  call Hloop_A_Q(ntryL,G1H3(40),47,nMT,G2H3(54),n2h3(60))
call HGT_OLR(G1H12(40),1,1,12)
call HGT_invQ_OLR(G1H12(40),2,5,12)
  call Hloop_Q_A(ntryL,G1H12(40),-16,nMT,G2H12(16),n2h12(65))
  call Hloop_QZ_A(ntryL,G2H12(16),ex5(:),G2H4(30),ngZu,m3h3x4(:,39),heltab2x12(:,:,116))
  call Hloop_AV_Q(ntryL,G1H12(46),wf4(:,7),G1H3(39),m3h4x3(:,10),heltab2x12(:,:,117))
  call Hloop_A_Q(ntryL,G1H3(39),47,nMT,G2H3(55),n2h3(61))
  call Hloop_AV_Q(ntryL,G1H12(47),wf4(:,7),G1H3(40),m3h4x3(:,11),heltab2x12(:,:,118))
  call Hloop_A_Q(ntryL,G1H3(40),47,nMT,G2H3(56),n2h3(62))
  call Hloop_VA_Q(ntryL,G1H6(127),ex2(:),G1H3(39),m3h2x3(:,76),heltab2x6(:,:,149))
  call Hloop_A_Q(ntryL,G1H3(39),47,nMT,G2H3(57),n2h3(63))
call HGT_OLR(G1H6(128),1,1,6)
call HGT_invQ_OLR(G1H6(128),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(128),-16,nMT,G2H6(7),n2h6(70))
  call Hloop_QZ_A(ntryL,G2H6(7),ex5(:),G2H2(154),ngZu,m3h3x2(:,74),heltab2x6(:,:,150))
  call Hloop_VA_Q(ntryL,G1H6(131),ex2(:),G1H3(40),m3h2x3(:,77),heltab2x6(:,:,151))
  call Hloop_A_Q(ntryL,G1H3(40),47,nMT,G2H3(58),n2h3(64))
  call Hloop_VA_Q(ntryL,G1H6(132),ex2(:),G1H3(39),m3h2x3(:,78),heltab2x6(:,:,152))
  call Hloop_A_Q(ntryL,G1H3(39),47,nMT,G2H3(59),n2h3(65))
  call Hloop_QV_A(ntryL,G1H12(48),wf4(:,7),G1H3(40),m3h4x3(:,12),heltab2x12(:,:,119))
  call Hloop_Q_A(ntryL,G1H3(40),47,nMT,G2H3(60),n2h3(66))
call HGT_OLR(G1H12(52),1,1,12)
call HGT_invQ_OLR(G1H12(52),2,5,12)
  call Hloop_A_Q(ntryL,G1H12(52),-16,nMT,G2H12(1),n2h12(66))
  call Hloop_AZ_Q(ntryL,G2H12(1),ex5(:),G2H4(34),ngZu,m3h3x4(:,40),heltab2x12(:,:,120))
  call Hloop_QV_A(ntryL,G1H12(9),wf4(:,7),G1H3(39),m3h4x3(:,13),heltab2x12(:,:,121))
  call Hloop_Q_A(ntryL,G1H3(39),47,nMT,G2H3(61),n2h3(67))
  call Hloop_QV_A(ntryL,G1H12(10),wf4(:,7),G1H3(40),m3h4x3(:,14),heltab2x12(:,:,122))
  call Hloop_Q_A(ntryL,G1H3(40),47,nMT,G2H3(62),n2h3(68))
  call Hloop_VA_Q(ntryL,G1H12(12),ex2(:),G1H6(3),m3h2x6(:,65),heltab2x12(:,:,123))
  call Hloop_A_Q(ntryL,G1H6(3),46,nMT,G2H6(25),n2h6(71))
call HGT_raise_alpha_OLR(G1H12(35),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(35),2,5,12)
  call Hloop_VQ_A(ntryL,G1H12(35),wf6(:,6),G1H2(37),m3h6x2(:,5),heltab2x12(:,:,124))
  call Hloop_VA_Q(ntryL,G1H12(36),ex2(:),G1H6(4),m3h2x6(:,66),heltab2x12(:,:,125))
  call Hloop_A_Q(ntryL,G1H6(4),46,nMT,G2H6(27),n2h6(72))
  call Hloop_VA_Q(ntryL,G1H12(30),ex2(:),G1H6(44),m3h2x6(:,67),heltab2x12(:,:,126))
  call Hloop_A_Q(ntryL,G1H6(44),46,nMT,G2H6(12),n2h6(73))
  call Hloop_VA_Q(ntryL,G1H12(7),ex2(:),G1H6(5),m3h2x6(:,68),heltab2x12(:,:,127))
  call Hloop_A_Q(ntryL,G1H6(5),46,nMT,G2H6(14),n2h6(74))
call HGT_raise_alpha_OLR(G1H12(20),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(20),2,5,12)
  call Hloop_VQ_A(ntryL,G1H12(20),wf6(:,6),G1H2(38),m3h6x2(:,6),heltab2x12(:,:,128))
  call Hloop_VA_Q(ntryL,G1H12(55),ex2(:),G1H6(147),m3h2x6(:,69),heltab2x12(:,:,129))
  call Hloop_A_Q(ntryL,G1H6(147),46,nMT,G2H6(15),n2h6(75))
  call Hloop_VA_Q(ntryL,G1H12(56),ex2(:),G1H6(148),m3h2x6(:,70),heltab2x12(:,:,130))
  call Hloop_A_Q(ntryL,G1H6(148),46,nMT,G2H6(17),n2h6(76))
  call Hloop_VQ_A(ntryL,G1H12(57),ex1(:),G1H6(163),m3h2x6(:,71),heltab2x12(:,:,131))
  call Hloop_Q_A(ntryL,G1H6(163),45,nMT,G2H6(1),n2h6(77))
call HGT_raise_alpha_OLR(G1H12(58),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(58),2,5,12)
  call Hloop_VA_Q(ntryL,G1H12(58),wf6(:,8),G1H2(39),m3h6x2(:,7),heltab2x12(:,:,132))
  call Hloop_VQ_A(ntryL,G1H12(61),ex1(:),G1H6(164),m3h2x6(:,72),heltab2x12(:,:,133))
  call Hloop_Q_A(ntryL,G1H6(164),45,nMT,G2H6(2),n2h6(78))
  call Hloop_VQ_A(ntryL,G1H12(62),ex1(:),G1H6(59),m3h2x6(:,73),heltab2x12(:,:,134))
  call Hloop_Q_A(ntryL,G1H6(59),45,nMT,G2H6(8),n2h6(79))
  call Hloop_VQ_A(ntryL,G1H12(63),ex1(:),G1H6(60),m3h2x6(:,74),heltab2x12(:,:,135))
  call Hloop_Q_A(ntryL,G1H6(60),45,nMT,G2H6(28),n2h6(80))
call HGT_raise_alpha_OLR(G1H12(64),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(64),2,5,12)
  call Hloop_VA_Q(ntryL,G1H12(64),wf6(:,8),G1H2(40),m3h6x2(:,8),heltab2x12(:,:,136))
  call Hloop_VQ_A(ntryL,G1H12(67),ex1(:),G1H6(66),m3h2x6(:,75),heltab2x12(:,:,137))
  call Hloop_Q_A(ntryL,G1H6(66),45,nMT,G2H6(31),n2h6(81))
  call Hloop_VQ_A(ntryL,G1H12(68),ex1(:),G1H6(71),m3h2x6(:,76),heltab2x12(:,:,138))
  call Hloop_Q_A(ntryL,G1H6(71),45,nMT,G2H6(33),n2h6(82))
  call Hloop_VA_Q(ntryL,G1H12(69),ex4(:),G1H6(72),m3h2x6(:,77),heltab2x12(:,:,139))
  call Hloop_A_Q(ntryL,G1H6(72),43,nMB,G2H6(34),n2h6(83))
call HGT_raise_alpha_OLR(G1H12(70),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(70),2,5,12)
  call Hloop_VQ_A(ntryL,G1H12(70),wf6(:,2),G1H2(41),m3h6x2(:,9),heltab2x12(:,:,140))
  call Hloop_VA_Q(ntryL,G1H12(73),ex4(:),G1H6(76),m3h2x6(:,78),heltab2x12(:,:,141))
  call Hloop_A_Q(ntryL,G1H6(76),43,nMB,G2H6(37),n2h6(84))
  call Hloop_VA_Q(ntryL,G1H12(74),ex4(:),G1H6(83),m3h2x6(:,79),heltab2x12(:,:,142))
  call Hloop_A_Q(ntryL,G1H6(83),43,nMB,G2H6(39),n2h6(85))
  call Hloop_VA_Q(ntryL,G1H12(75),ex4(:),G1H6(84),m3h2x6(:,80),heltab2x12(:,:,143))
  call Hloop_A_Q(ntryL,G1H6(84),43,nMB,G2H6(40),n2h6(86))
call HGT_raise_alpha_OLR(G1H12(76),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(76),2,5,12)
  call Hloop_VQ_A(ntryL,G1H12(76),wf6(:,2),G1H2(42),m3h6x2(:,10),heltab2x12(:,:,144))
  call Hloop_VA_Q(ntryL,G1H12(79),ex4(:),G1H6(88),m3h2x6(:,81),heltab2x12(:,:,145))
  call Hloop_A_Q(ntryL,G1H6(88),43,nMB,G2H6(23),n2h6(87))
  call Hloop_VA_Q(ntryL,G1H12(80),ex4(:),G1H6(89),m3h2x6(:,82),heltab2x12(:,:,146))
  call Hloop_A_Q(ntryL,G1H6(89),43,nMB,G2H6(24),n2h6(88))
  call Hloop_VQ_A(ntryL,G1H12(81),wf6(:,2),G1H2(43),m3h6x2(:,11),heltab2x12(:,:,147))
  call Hloop_Q_A(ntryL,G1H2(43),55,nMB,G2H2(155),n2h2(119))
call HGT_raise_alpha_OLR(G1H12(82),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(82),2,5,12)
  call Hloop_VA_Q(ntryL,G1H12(82),ex4(:),G1H6(96),m3h2x6(:,83),heltab2x12(:,:,148))
  call Hloop_VQ_A(ntryL,G1H12(85),wf6(:,2),G1H2(43),m3h6x2(:,12),heltab2x12(:,:,149))
  call Hloop_Q_A(ntryL,G1H2(43),55,nMB,G2H2(156),n2h2(120))
  call Hloop_VQ_A(ntryL,G1H12(86),wf6(:,2),G1H2(43),m3h6x2(:,13),heltab2x12(:,:,150))
  call Hloop_Q_A(ntryL,G1H2(43),55,nMB,G2H2(157),n2h2(121))
  call Hloop_VQ_A(ntryL,G1H12(87),wf6(:,2),G1H2(43),m3h6x2(:,14),heltab2x12(:,:,151))
  call Hloop_Q_A(ntryL,G1H2(43),55,nMB,G2H2(158),n2h2(122))
call HGT_raise_alpha_OLR(G1H12(88),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(88),2,5,12)
  call Hloop_VA_Q(ntryL,G1H12(88),ex4(:),G1H6(100),m3h2x6(:,84),heltab2x12(:,:,152))
  call Hloop_VQ_A(ntryL,G1H12(91),wf6(:,2),G1H2(43),m3h6x2(:,15),heltab2x12(:,:,153))
  call Hloop_Q_A(ntryL,G1H2(43),55,nMB,G2H2(159),n2h2(123))
  call Hloop_VQ_A(ntryL,G1H12(92),wf6(:,2),G1H2(43),m3h6x2(:,16),heltab2x12(:,:,154))
  call Hloop_Q_A(ntryL,G1H2(43),55,nMB,G2H2(160),n2h2(124))
  call Hloop_VQ_A(ntryL,G1H12(93),ex3(:),G1H6(58),m3h2x6(:,85),heltab2x12(:,:,155))
  call Hloop_Q_A(ntryL,G1H6(58),39,nMB,G2H6(18),n2h6(89))
call HGT_raise_alpha_OLR(G1H12(94),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(94),2,5,12)
  call Hloop_VA_Q(ntryL,G1H12(94),wf6(:,4),G1H2(43),m3h6x2(:,17),heltab2x12(:,:,156))
  call Hloop_VQ_A(ntryL,G1H12(97),ex3(:),G1H6(70),m3h2x6(:,86),heltab2x12(:,:,157))
  call Hloop_Q_A(ntryL,G1H6(70),39,nMB,G2H6(20),n2h6(90))
  call Hloop_VQ_A(ntryL,G1H12(98),ex3(:),G1H6(22),m3h2x6(:,87),heltab2x12(:,:,158))
  call Hloop_Q_A(ntryL,G1H6(22),39,nMB,G2H6(3),n2h6(91))
  call Hloop_VQ_A(ntryL,G1H12(99),ex3(:),G1H6(24),m3h2x6(:,88),heltab2x12(:,:,159))
  call Hloop_Q_A(ntryL,G1H6(24),39,nMB,G2H6(4),n2h6(92))
call HGT_raise_alpha_OLR(G1H12(100),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(100),2,5,12)
  call Hloop_VA_Q(ntryL,G1H12(100),wf6(:,4),G1H2(44),m3h6x2(:,18),heltab2x12(:,:,160))
  call Hloop_VQ_A(ntryL,G1H12(103),ex3(:),G1H6(28),m3h2x6(:,89),heltab2x12(:,:,161))
  call Hloop_Q_A(ntryL,G1H6(28),39,nMB,G2H6(5),n2h6(93))
  call Hloop_VQ_A(ntryL,G1H12(104),ex3(:),G1H6(29),m3h2x6(:,90),heltab2x12(:,:,162))
  call Hloop_Q_A(ntryL,G1H6(29),39,nMB,G2H6(7),n2h6(94))
  call Hloop_VA_Q(ntryL,G1H12(105),wf6(:,4),G1H2(45),m3h6x2(:,19),heltab2x12(:,:,163))
  call Hloop_A_Q(ntryL,G1H2(45),59,nMB,G2H2(161),n2h2(125))
call HGT_raise_alpha_OLR(G1H12(106),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(106),2,5,12)
  call Hloop_VQ_A(ntryL,G1H12(106),ex3(:),G1H6(36),m3h2x6(:,91),heltab2x12(:,:,164))
  call Hloop_VA_Q(ntryL,G1H12(109),wf6(:,4),G1H2(45),m3h6x2(:,20),heltab2x12(:,:,165))
  call Hloop_A_Q(ntryL,G1H2(45),59,nMB,G2H2(162),n2h2(126))
  call Hloop_VA_Q(ntryL,G1H12(110),wf6(:,4),G1H2(45),m3h6x2(:,21),heltab2x12(:,:,166))
  call Hloop_A_Q(ntryL,G1H2(45),59,nMB,G2H2(163),n2h2(127))
  call Hloop_VA_Q(ntryL,G1H12(111),wf6(:,4),G1H2(45),m3h6x2(:,22),heltab2x12(:,:,167))
  call Hloop_A_Q(ntryL,G1H2(45),59,nMB,G2H2(164),n2h2(128))
call HGT_raise_alpha_OLR(G1H12(112),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(112),2,5,12)
  call Hloop_VQ_A(ntryL,G1H12(112),ex3(:),G1H6(40),m3h2x6(:,92),heltab2x12(:,:,168))
  call Hloop_VA_Q(ntryL,G1H12(115),wf6(:,4),G1H2(45),m3h6x2(:,23),heltab2x12(:,:,169))
  call Hloop_A_Q(ntryL,G1H2(45),59,nMB,G2H2(165),n2h2(129))
  call Hloop_VA_Q(ntryL,G1H12(116),wf6(:,4),G1H2(45),m3h6x2(:,24),heltab2x12(:,:,170))
  call Hloop_A_Q(ntryL,G1H2(45),59,nMB,G2H2(166),n2h2(130))
call HGT_raise_alpha_OLR(G1H6(134),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(134),2,5,6)
  call Hloop_VA_Q(ntryL,G1H6(134),ex4(:),G1H3(39),m3h2x3(:,79),heltab2x6(:,:,153))
  call Hloop_QZ_A(ntryL,G1H6(137),ex5(:),G1H2(45),ngZd,m3h3x2(:,75),heltab2x6(:,:,154))
  call Hloop_Q_A(ntryL,G1H2(45),55,nMB,G2H2(167),n2h2(131))
call HGT_raise_alpha_OLR(G1H6(139),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(139),2,5,6)
  call Hloop_VQ_A(ntryL,G1H6(139),ex3(:),G1H3(40),m3h2x3(:,80),heltab2x6(:,:,155))
  call Hloop_AZ_Q(ntryL,G1H6(142),ex5(:),G1H2(45),ngZd,m3h3x2(:,76),heltab2x6(:,:,156))
  call Hloop_A_Q(ntryL,G1H2(45),59,nMB,G2H2(168),n2h2(132))
  call Hloop_QV_A(ntryL,G1H8(1),wf4(:,1),G1H2(45),m3h4x2(:,1),heltab2x8(:,:,27))
  call Hloop_Q_A(ntryL,G1H2(45),55,nMB,G2H2(169),n2h2(133))
call HGT_raise_alpha_OLR(G1H8(2),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(2),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(2),ex4(:),G1H4(42),m3h2x4(:,27),heltab2x8(:,:,28))
  call Hloop_QV_A(ntryL,G1H8(7),wf4(:,1),G1H2(45),m3h4x2(:,2),heltab2x8(:,:,29))
  call Hloop_Q_A(ntryL,G1H2(45),55,nMB,G2H2(170),n2h2(134))
  call Hloop_QV_A(ntryL,G1H8(12),wf4(:,1),G1H2(45),m3h4x2(:,3),heltab2x8(:,:,30))
  call Hloop_Q_A(ntryL,G1H2(45),55,nMB,G2H2(171),n2h2(135))
call HGT_raise_alpha_OLR(G1H8(8),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(8),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(8),ex4(:),G1H4(1),m3h2x4(:,28),heltab2x8(:,:,31))
  call Hloop_QV_A(ntryL,G1H8(11),wf4(:,1),G1H2(45),m3h4x2(:,4),heltab2x8(:,:,32))
  call Hloop_Q_A(ntryL,G1H2(45),55,nMB,G2H2(172),n2h2(136))
call HGT_raise_alpha_OLR(G1H8(13),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(13),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(13),ex4(:),G1H4(2),m3h2x4(:,29),heltab2x8(:,:,33))
  call Hloop_QV_A(ntryL,G1H8(16),wf4(:,1),G1H2(45),m3h4x2(:,5),heltab2x8(:,:,34))
  call Hloop_Q_A(ntryL,G1H2(45),55,nMB,G2H2(173),n2h2(137))
  call Hloop_QZ_A(ntryL,G1H6(143),ex5(:),G1H2(45),ngZd,m3h3x2(:,77),heltab2x6(:,:,157))
  call Hloop_Q_A(ntryL,G1H2(45),55,nMB,G2H2(174),n2h2(138))
call HGT_raise_alpha_OLR(G1H6(144),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(144),2,5,6)
  call Hloop_VA_Q(ntryL,G1H6(144),ex4(:),G1H3(57),m3h2x3(:,81),heltab2x6(:,:,158))
  call Hloop_QZ_A(ntryL,G1H6(149),ex5(:),G1H2(45),ngZd,m3h3x2(:,78),heltab2x6(:,:,159))
  call Hloop_Q_A(ntryL,G1H2(45),55,nMB,G2H2(175),n2h2(139))
  call Hloop_QZ_A(ntryL,G1H6(154),ex5(:),G1H2(45),ngZd,m3h3x2(:,79),heltab2x6(:,:,160))
  call Hloop_Q_A(ntryL,G1H2(45),55,nMB,G2H2(176),n2h2(140))
call HGT_raise_alpha_OLR(G1H6(150),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(150),2,5,6)
  call Hloop_VA_Q(ntryL,G1H6(150),ex4(:),G1H3(58),m3h2x3(:,82),heltab2x6(:,:,161))
  call Hloop_QZ_A(ntryL,G1H6(153),ex5(:),G1H2(45),ngZd,m3h3x2(:,80),heltab2x6(:,:,162))
  call Hloop_Q_A(ntryL,G1H2(45),55,nMB,G2H2(177),n2h2(141))
call HGT_raise_alpha_OLR(G1H6(155),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(155),2,5,6)
  call Hloop_VA_Q(ntryL,G1H6(155),ex4(:),G1H3(59),m3h2x3(:,83),heltab2x6(:,:,163))
  call Hloop_QZ_A(ntryL,G1H6(158),ex5(:),G1H2(45),ngZd,m3h3x2(:,81),heltab2x6(:,:,164))
  call Hloop_Q_A(ntryL,G1H2(45),55,nMB,G2H2(178),n2h2(142))
  call Hloop_QV_A(ntryL,G1H8(17),wf4(:,7),G1H2(45),m3h4x2(:,6),heltab2x8(:,:,35))
  call Hloop_Q_A(ntryL,G1H2(45),61,nMT,G2H2(179),n2h2(143))



end subroutine vamp_1

end module ol_vamp_1_ppzttj_ttxbbxzg_1_/**/REALKIND
