
module ol_vamp_1_ppztt_ew_uuxttxz_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppztt_ew_uuxttxz_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppztt_ew_uuxttxz_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_ppztt_ew_uuxttxz_1_/**/DREALKIND
  use ol_tensor_sum_storage_ppztt_ew_uuxttxz_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_ppztt_ew_uuxttxz_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_ppztt_ew_uuxttxz_1_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(48)
  type(Hpolcont), intent(in) :: M(4,48)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)+c(1)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(1),h0tab(:,1),[16,4,1,2,8],[nMT,0,0,0,nMT],5,0)
  call Hloop_AZ_Q(ntryL,G0H48(1),ex5(:),G0H16(1),ngZu,m3h3x16(:,1),heltab2x48(:,:,1))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(1),n2h16(1))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)+c(1)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(2),h0tab(:,2),[16,4,1,2,8],[nMT,0,0,0,nMT],5,0)
  call Hloop_AZ_Q(ntryL,G0H48(1),ex5(:),G0H16(1),ngZu,m3h3x16(:,2),heltab2x48(:,:,2))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(2),n2h16(2))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)+c(4)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(3),h0tab(:,3),[16,4,1,2,8],[nMT,nMZ,0,0,nMT],5,0)
  call Hloop_AZ_Q(ntryL,G0H48(1),ex5(:),G0H16(1),ngZu,m3h3x16(:,3),heltab2x48(:,:,3))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(3),n2h16(3))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)+c(4)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(4),h0tab(:,4),[16,4,1,2,8],[nMT,0,0,nMZ,nMT],5,0)
  call Hloop_AZ_Q(ntryL,G0H48(1),ex5(:),G0H16(1),ngZu,m3h3x16(:,4),heltab2x48(:,:,4))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(4),n2h16(4))
  Gcoeff(:)%j = (c(13)*M(2,:)%j-c(15)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(5),h0tab(:,5),[16,4,1,2,8],[nMT,0,0,0,nMT],5,0)
  call Hloop_AZ_Q(ntryL,G0H48(1),ex5(:),G0H16(1),ngZu,m3h3x16(:,5),heltab2x48(:,:,5))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(5),n2h16(5))
  Gcoeff(:)%j = (c(27)*M(1,:)%j-c(26)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(6),h0tab(:,6),[16,2,1,4,8],[nMZ,0,0,nMT,nMH],5,0)
  call Hloop_SV_V(ntryL,G0H48(1),ex5(:),G0H16(1),m3h3x16(:,6),heltab2x48(:,:,6))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)+c(1)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(7),h0tab(:,7),[16,4,2,1,8],[nMT,0,0,0,nMT],5,0)
  call Hloop_AZ_Q(ntryL,G0H48(1),ex5(:),G0H16(2),ngZu,m3h3x16(:,7),heltab2x48(:,:,7))
  call Hloop_A_Q(ntryL,G0H16(2),16,nMT,G1H16(6),n2h16(6))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)+c(1)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(8),h0tab(:,8),[16,4,2,1,8],[nMT,0,0,0,nMT],5,0)
  call Hloop_AZ_Q(ntryL,G0H48(1),ex5(:),G0H16(2),ngZu,m3h3x16(:,8),heltab2x48(:,:,8))
  call Hloop_A_Q(ntryL,G0H16(2),16,nMT,G1H16(7),n2h16(7))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)+c(4)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(9),h0tab(:,9),[16,4,2,1,8],[nMT,0,0,nMZ,nMT],5,0)
  call Hloop_AZ_Q(ntryL,G0H48(1),ex5(:),G0H16(2),ngZu,m3h3x16(:,9),heltab2x48(:,:,9))
  call Hloop_A_Q(ntryL,G0H16(2),16,nMT,G1H16(8),n2h16(8))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)+c(4)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(10),h0tab(:,10),[16,4,2,1,8],[nMT,nMZ,0,0,nMT],5,0)
  call Hloop_AZ_Q(ntryL,G0H48(1),ex5(:),G0H16(2),ngZu,m3h3x16(:,10),heltab2x48(:,:,10))
  call Hloop_A_Q(ntryL,G0H16(2),16,nMT,G1H16(9),n2h16(9))
  Gcoeff(:)%j = (-(c(17)*M(2,:)%j)-c(11)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(11),h0tab(:,11),[16,4,2,1,8],[nMT,0,0,0,nMT],5,0)
  call Hloop_AZ_Q(ntryL,G0H48(1),ex5(:),G0H16(2),ngZu,m3h3x16(:,11),heltab2x48(:,:,11))
  call Hloop_A_Q(ntryL,G0H16(2),16,nMT,G1H16(10),n2h16(10))
  Gcoeff(:)%j = (c(27)*M(1,:)%j-c(26)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(12),h0tab(:,12),[16,2,1,8,4],[nMZ,0,0,nMT,nMH],5,0)
  call Hloop_SV_V(ntryL,G0H48(1),ex5(:),G0H16(2),m3h3x16(:,12),heltab2x48(:,:,12))
  Gcoeff(:)%j = (c(27)*M(1,:)%j-c(26)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(13),h0tab(:,13),[16,1,2,4,8],[nMZ,0,0,nMT,nMH],5,0)
  call Hloop_SV_V(ntryL,G0H48(1),ex5(:),G0H16(3),m3h3x16(:,13),heltab2x48(:,:,13))
  Gcoeff(:)%j = (c(27)*M(1,:)%j-c(26)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(14),h0tab(:,14),[16,1,2,8,4],[nMZ,0,0,nMT,nMH],5,0)
  call Hloop_SV_V(ntryL,G0H48(1),ex5(:),G0H16(4),m3h3x16(:,14),heltab2x48(:,:,14))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)+c(1)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(15),h0tab(:,15),[16,1,4,8,2],[0,0,nMT,0,0],5,0)
  call Hloop_AZ_Q(ntryL,G0H48(1),ex5(:),G0H16(5),ngZu,m3h3x16(:,15),heltab2x48(:,:,15))
  call Hloop_A_Q(ntryL,G0H16(5),16,0,G1H16(11),n2h16(11))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)+c(1)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(16),h0tab(:,16),[16,1,4,8,2],[0,0,nMT,0,0],5,0)
  call Hloop_AZ_Q(ntryL,G0H48(1),ex5(:),G0H16(5),ngZu,m3h3x16(:,16),heltab2x48(:,:,16))
  call Hloop_A_Q(ntryL,G0H16(5),16,0,G1H16(12),n2h16(12))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)+c(4)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(17),h0tab(:,17),[16,1,4,8,2],[0,nMZ,nMT,0,0],5,0)
  call Hloop_AZ_Q(ntryL,G0H48(1),ex5(:),G0H16(5),ngZu,m3h3x16(:,17),heltab2x48(:,:,17))
  call Hloop_A_Q(ntryL,G0H16(5),16,0,G1H16(13),n2h16(13))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)+c(4)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(18),h0tab(:,18),[16,1,4,8,2],[0,0,nMT,nMZ,0],5,0)
  call Hloop_AZ_Q(ntryL,G0H48(1),ex5(:),G0H16(5),ngZu,m3h3x16(:,18),heltab2x48(:,:,18))
  call Hloop_A_Q(ntryL,G0H16(5),16,0,G1H16(14),n2h16(14))
  Gcoeff(:)%j = (c(13)*M(2,:)%j-c(15)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(19),h0tab(:,19),[16,1,4,8,2],[0,0,nMT,0,0],5,0)
  call Hloop_AZ_Q(ntryL,G0H48(1),ex5(:),G0H16(5),ngZu,m3h3x16(:,19),heltab2x48(:,:,19))
  call Hloop_A_Q(ntryL,G0H16(5),16,0,G1H16(15),n2h16(15))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)+c(1)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(20),h0tab(:,20),[16,1,8,4,2],[0,0,nMT,0,0],5,0)
  call Hloop_AZ_Q(ntryL,G0H48(1),ex5(:),G0H16(5),ngZu,m3h3x16(:,20),heltab2x48(:,:,20))
  call Hloop_A_Q(ntryL,G0H16(5),16,0,G1H16(16),n2h16(16))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)+c(1)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(21),h0tab(:,21),[16,1,8,4,2],[0,0,nMT,0,0],5,0)
  call Hloop_AZ_Q(ntryL,G0H48(1),ex5(:),G0H16(5),ngZu,m3h3x16(:,21),heltab2x48(:,:,21))
  call Hloop_A_Q(ntryL,G0H16(5),16,0,G1H16(17),n2h16(17))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)+c(4)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(22),h0tab(:,22),[16,1,8,4,2],[0,nMZ,nMT,0,0],5,0)
  call Hloop_AZ_Q(ntryL,G0H48(1),ex5(:),G0H16(5),ngZu,m3h3x16(:,22),heltab2x48(:,:,22))
  call Hloop_A_Q(ntryL,G0H16(5),16,0,G1H16(18),n2h16(18))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)+c(4)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(23),h0tab(:,23),[16,1,8,4,2],[0,0,nMT,nMZ,0],5,0)
  call Hloop_AZ_Q(ntryL,G0H48(1),ex5(:),G0H16(5),ngZu,m3h3x16(:,23),heltab2x48(:,:,23))
  call Hloop_A_Q(ntryL,G0H16(5),16,0,G1H16(19),n2h16(19))
  Gcoeff(:)%j = (-(c(17)*M(2,:)%j)-c(11)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(24),h0tab(:,24),[16,1,8,4,2],[0,0,nMT,0,0],5,0)
  call Hloop_AZ_Q(ntryL,G0H48(1),ex5(:),G0H16(5),ngZu,m3h3x16(:,24),heltab2x48(:,:,24))
  call Hloop_A_Q(ntryL,G0H16(5),16,0,G1H16(20),n2h16(20))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(5),[G1H16(2),G1H16(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(10),[G1H16(7),G1H16(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(15),[G1H16(12),G1H16(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(20),[G1H16(17),G1H16(16)])
  call Hloop_AQ_V(ntryL,G1H16(5),ex3(:),G1H8(1),m3h2x8(:,1),heltab2x16(:,:,1))
  call Hloop_AQ_Z(ntryL,G1H16(3),ex3(:),G1H8(2),ngZu,m3h2x8(:,2),heltab2x16(:,:,2))
  call Hloop_AQ_V(ntryL,G1H16(4),ex3(:),G1H8(3),m3h2x8(:,3),heltab2x16(:,:,3))
  call Hloop_ZA_Q(ntryL,G0H16(1),ex2(:),G0H8(1),ngZu,m3h2x8(:,4),heltab2x16(:,:,4))
  call Hloop_A_Q(ntryL,G0H8(1),18,0,G1H8(4),n2h8(1))
  call Hloop_AQ_V(ntryL,G1H16(10),ex3(:),G1H8(5),m3h2x8(:,5),heltab2x16(:,:,5))
  call Hloop_AQ_V(ntryL,G1H16(8),ex3(:),G1H8(6),m3h2x8(:,6),heltab2x16(:,:,6))
  call Hloop_AQ_Z(ntryL,G1H16(9),ex3(:),G1H8(7),ngZu,m3h2x8(:,7),heltab2x16(:,:,7))
  call Hloop_ZA_Q(ntryL,G0H16(2),ex2(:),G0H8(1),ngZu,m3h2x8(:,8),heltab2x16(:,:,8))
  call Hloop_A_Q(ntryL,G0H8(1),18,0,G1H8(8),n2h8(2))
  call Hloop_ZQ_A(ntryL,G0H16(3),ex1(:),G0H8(1),ngZu,m3h2x8(:,9),heltab2x16(:,:,9))
  call Hloop_Q_A(ntryL,G0H8(1),17,0,G1H8(9),n2h8(3))
  call Hloop_ZQ_A(ntryL,G0H16(4),ex1(:),G0H8(1),ngZu,m3h2x8(:,10),heltab2x16(:,:,10))
  call Hloop_Q_A(ntryL,G0H8(1),17,0,G1H8(10),n2h8(4))
  call Hloop_AQ_V(ntryL,G1H16(15),ex1(:),G1H8(11),m3h2x8(:,11),heltab2x16(:,:,11))
  call Hloop_AQ_Z(ntryL,G1H16(13),ex1(:),G1H8(12),ngZu,m3h2x8(:,12),heltab2x16(:,:,12))
  call Hloop_AQ_V(ntryL,G1H16(14),ex1(:),G1H8(13),m3h2x8(:,13),heltab2x16(:,:,13))
  call Hloop_AQ_V(ntryL,G1H16(20),ex1(:),G1H8(14),m3h2x8(:,14),heltab2x16(:,:,14))
  call Hloop_AQ_Z(ntryL,G1H16(18),ex1(:),G1H8(15),ngZu,m3h2x8(:,15),heltab2x16(:,:,15))
  call Hloop_AQ_V(ntryL,G1H16(19),ex1(:),G1H8(16),m3h2x8(:,16),heltab2x16(:,:,16))
  call Hloop_VQ_A(ntryL,G1H8(1),ex1(:),G1H4(1),m3h2x4(:,1),heltab2x8(:,:,1))
  call Hloop_Q_A(ntryL,G1H4(1),21,0,G2H4(1),n2h4(1))
  call Hloop_ZQ_A(ntryL,G1H8(2),ex1(:),G1H4(1),ngZu,m3h2x4(:,2),heltab2x8(:,:,2))
  call Hloop_Q_A(ntryL,G1H4(1),21,0,G2H4(2),n2h4(2))
  call Hloop_VQ_A(ntryL,G1H8(3),ex1(:),G1H4(1),m3h2x4(:,3),heltab2x8(:,:,3))
  call Hloop_Q_A(ntryL,G1H4(1),21,0,G2H4(3),n2h4(3))
  call Hloop_AQ_V(ntryL,G1H8(4),ex1(:),G1H4(1),m3h2x4(:,4),heltab2x8(:,:,4))
  call Hloop_VA_Q(ntryL,G1H8(5),ex2(:),G1H4(2),m3h2x4(:,5),heltab2x8(:,:,5))
  call Hloop_A_Q(ntryL,G1H4(2),22,0,G2H4(4),n2h4(4))
  call Hloop_VA_Q(ntryL,G1H8(6),ex2(:),G1H4(2),m3h2x4(:,6),heltab2x8(:,:,6))
  call Hloop_A_Q(ntryL,G1H4(2),22,0,G2H4(5),n2h4(5))
  call Hloop_ZA_Q(ntryL,G1H8(7),ex2(:),G1H4(2),ngZu,m3h2x4(:,7),heltab2x8(:,:,7))
  call Hloop_A_Q(ntryL,G1H4(2),22,0,G2H4(6),n2h4(6))
  call Hloop_AQ_V(ntryL,G1H8(8),ex1(:),G1H4(2),m3h2x4(:,8),heltab2x8(:,:,8))
  call Hloop_QA_V(ntryL,G1H8(9),ex2(:),G1H4(3),m3h2x4(:,9),heltab2x8(:,:,9))
  call Hloop_QA_V(ntryL,G1H8(10),ex2(:),G1H4(4),m3h2x4(:,10),heltab2x8(:,:,10))
  call Hloop_VQ_A(ntryL,G1H8(11),ex3(:),G1H4(5),m3h2x4(:,11),heltab2x8(:,:,11))
  call Hloop_Q_A(ntryL,G1H4(5),21,nMT,G2H4(7),n2h4(7))
  call Hloop_ZQ_A(ntryL,G1H8(12),ex3(:),G1H4(5),ngZu,m3h2x4(:,12),heltab2x8(:,:,12))
  call Hloop_Q_A(ntryL,G1H4(5),21,nMT,G2H4(8),n2h4(8))
  call Hloop_VQ_A(ntryL,G1H8(13),ex3(:),G1H4(5),m3h2x4(:,13),heltab2x8(:,:,13))
  call Hloop_Q_A(ntryL,G1H4(5),21,nMT,G2H4(9),n2h4(9))
  call Hloop_VA_Q(ntryL,G1H8(14),ex4(:),G1H4(5),m3h2x4(:,14),heltab2x8(:,:,14))
  call Hloop_A_Q(ntryL,G1H4(5),25,nMT,G2H4(10),n2h4(10))
  call Hloop_ZA_Q(ntryL,G1H8(15),ex4(:),G1H4(5),ngZu,m3h2x4(:,15),heltab2x8(:,:,15))
  call Hloop_A_Q(ntryL,G1H4(5),25,nMT,G2H4(11),n2h4(11))
  call Hloop_VA_Q(ntryL,G1H8(16),ex4(:),G1H4(5),m3h2x4(:,16),heltab2x8(:,:,16))
  call Hloop_A_Q(ntryL,G1H4(5),25,nMT,G2H4(12),n2h4(12))
  call Hloop_QA_V(ntryL,G2H4(1),ex2(:),G2H2(1),m3h2x2(:,1),heltab2x4(:,:,1))
  call Hloop_QA_V(ntryL,G2H4(2),ex2(:),G2H2(2),m3h2x2(:,2),heltab2x4(:,:,2))
  call Hloop_QA_Z(ntryL,G2H4(3),ex2(:),G2H2(3),ngZu,m3h2x2(:,3),heltab2x4(:,:,3))
  call Hloop_VQ_A(ntryL,G1H4(1),ex3(:),G1H2(1),m3h2x2(:,4),heltab2x4(:,:,4))
  call Hloop_Q_A(ntryL,G1H2(1),23,nMT,G2H2(4),n2h2(1))
  call Hloop_AQ_V(ntryL,G2H4(4),ex1(:),G2H2(5),m3h2x2(:,5),heltab2x4(:,:,5))
  call Hloop_AQ_Z(ntryL,G2H4(5),ex1(:),G2H2(6),ngZu,m3h2x2(:,6),heltab2x4(:,:,6))
  call Hloop_AQ_V(ntryL,G2H4(6),ex1(:),G2H2(7),m3h2x2(:,7),heltab2x4(:,:,7))
  call Hloop_VA_Q(ntryL,G1H4(2),ex4(:),G1H2(1),m3h2x2(:,8),heltab2x4(:,:,8))
  call Hloop_A_Q(ntryL,G1H2(1),27,nMT,G2H2(8),n2h2(2))
  call Hloop_VQ_A(ntryL,G1H4(3),ex3(:),G1H2(1),m3h2x2(:,9),heltab2x4(:,:,9))
  call Hloop_Q_A(ntryL,G1H2(1),23,nMT,G2H2(9),n2h2(3))
  call Hloop_VA_Q(ntryL,G1H4(4),ex4(:),G1H2(1),m3h2x2(:,10),heltab2x4(:,:,10))
  call Hloop_A_Q(ntryL,G1H2(1),27,nMT,G2H2(10),n2h2(4))
  call Hloop_QA_V(ntryL,G2H4(7),ex4(:),G2H2(11),m3h2x2(:,11),heltab2x4(:,:,11))
  call Hloop_QA_V(ntryL,G2H4(8),ex4(:),G2H2(12),m3h2x2(:,12),heltab2x4(:,:,12))
  call Hloop_QA_Z(ntryL,G2H4(9),ex4(:),G2H2(13),ngZu,m3h2x2(:,13),heltab2x4(:,:,13))
  call Hloop_AQ_V(ntryL,G2H4(10),ex3(:),G2H2(14),m3h2x2(:,14),heltab2x4(:,:,14))
  call Hloop_AQ_V(ntryL,G2H4(11),ex3(:),G2H2(15),m3h2x2(:,15),heltab2x4(:,:,15))
  call Hloop_AQ_Z(ntryL,G2H4(12),ex3(:),G2H2(16),ngZu,m3h2x2(:,16),heltab2x4(:,:,16))
  call Hotf_5pt_reduction(G2H2(1),RedSet_5(1),mass5set(:,1),  & 
G1H2(1),G1H2(2),G1H2(3),G1H2(4),G1H2(5),G1H2(6),2)
  call HG1shiftOLR(G1H2(2),8,2)
  call Hotf_5pt_reduction(G2H2(2),RedSet_5(1),mass5set(:,2),  & 
G1H2(7),G1H2(8),G1H2(9),G1H2(10),G1H2(11),G1H2(12),2)
  call HG1shiftOLR(G1H2(8),8,2)
  call Hotf_5pt_reduction(G2H2(3),RedSet_5(1),mass5set(:,3),  & 
G1H2(13),G1H2(14),G1H2(15),G1H2(16),G1H2(17),G1H2(18),2)
  call HG1shiftOLR(G1H2(14),8,2)
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(4),ex4(:),G2tensor(1),ngH,m3h2x1(:,1),heltab2x2(:,:,1))
  call Hotf_5pt_reduction(G2H2(5),RedSet_5(2),mass5set(:,1),  & 
G1H2(19),G1H2(20),G1H2(21),G1H2(22),G1H2(23),G1H2(24),2)
  call HG1shiftOLR(G1H2(20),8,2)
  call Hotf_5pt_reduction(G2H2(6),RedSet_5(2),mass5set(:,3),  & 
G1H2(25),G1H2(26),G1H2(27),G1H2(28),G1H2(29),G1H2(30),2)
  call HG1shiftOLR(G1H2(26),8,2)
  call Hotf_5pt_reduction(G2H2(7),RedSet_5(2),mass5set(:,2),  & 
G1H2(31),G1H2(32),G1H2(33),G1H2(34),G1H2(35),G1H2(36),2)
  call HG1shiftOLR(G1H2(32),8,2)
  call Hcheck_last_AQ_S(ntryL,l_switch,G2H2(8),ex3(:),G2tensor(2),ngH,m3h2x1(:,2),heltab2x2(:,:,2))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(9),ex4(:),G2tensor(3),ngH,m3h2x1(:,3),heltab2x2(:,:,3))
  call Hcheck_last_AQ_S(ntryL,l_switch,G2H2(10),ex3(:),G2tensor(4),ngH,m3h2x1(:,4),heltab2x2(:,:,4))
  call Hotf_5pt_reduction(G2H2(11),RedSet_5(3),mass5set(:,4),  & 
G1H2(37),G1H2(38),G1H2(39),G1H2(40),G1H2(41),G1H2(42),2)
  call HG1shiftOLR(G1H2(38),2,2)
  call Hotf_5pt_reduction(G2H2(12),RedSet_5(3),mass5set(:,5),  & 
G1H2(43),G1H2(44),G1H2(45),G1H2(46),G1H2(47),G1H2(48),2)
  call HG1shiftOLR(G1H2(44),2,2)
  call Hotf_5pt_reduction(G2H2(13),RedSet_5(3),mass5set(:,6),  & 
G1H2(49),G1H2(50),G1H2(51),G1H2(52),G1H2(53),G1H2(54),2)
  call HG1shiftOLR(G1H2(50),2,2)
  call Hotf_5pt_reduction(G2H2(14),RedSet_5(4),mass5set(:,4),  & 
G1H2(55),G1H2(56),G1H2(57),G1H2(58),G1H2(59),G1H2(60),2)
  call HG1shiftOLR(G1H2(56),2,2)
  call Hotf_5pt_reduction(G2H2(15),RedSet_5(4),mass5set(:,5),  & 
G1H2(61),G1H2(62),G1H2(63),G1H2(64),G1H2(65),G1H2(66),2)
  call HG1shiftOLR(G1H2(62),2,2)
  call Hotf_5pt_reduction(G2H2(16),RedSet_5(4),mass5set(:,6),  & 
G1H2(67),G1H2(68),G1H2(69),G1H2(70),G1H2(71),G1H2(72),2)
  call HG1shiftOLR(G1H2(68),2,2)
  call Hloop_VA_Q(ntryL,G1H2(1),ex4(:),G1H1(1),m3h2x1(:,5),heltab2x2(:,:,5))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(5),n2h1(1))
  call Hloop_VA_Q(ntryL,G1H2(2),ex4(:),G1H1(1),m3h2x1(:,6),heltab2x2(:,:,6))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(6),n2h1(2))
  call Hloop_VA_Q(ntryL,G1H2(6),ex4(:),G1H1(1),m3h2x1(:,7),heltab2x2(:,:,7))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(7),n2h1(3))
  call Hloop_VA_Q(ntryL,G1H2(7),ex4(:),G1H1(1),m3h2x1(:,8),heltab2x2(:,:,8))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(8),n2h1(4))
  call Hloop_VA_Q(ntryL,G1H2(8),ex4(:),G1H1(1),m3h2x1(:,9),heltab2x2(:,:,9))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(9),n2h1(5))
  call Hloop_VA_Q(ntryL,G1H2(12),ex4(:),G1H1(1),m3h2x1(:,10),heltab2x2(:,:,10))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(10),n2h1(6))
  call Hloop_ZA_Q(ntryL,G1H2(13),ex4(:),G1H1(1),ngZu,m3h2x1(:,11),heltab2x2(:,:,11))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(11),n2h1(7))
  call Hloop_ZA_Q(ntryL,G1H2(14),ex4(:),G1H1(1),ngZu,m3h2x1(:,12),heltab2x2(:,:,12))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(12),n2h1(8))
  call Hloop_ZA_Q(ntryL,G1H2(18),ex4(:),G1H1(1),ngZu,m3h2x1(:,13),heltab2x2(:,:,13))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(13),n2h1(9))
  call Hloop_VA_Q(ntryL,G1H2(19),ex4(:),G1H1(1),m3h2x1(:,14),heltab2x2(:,:,14))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(14),n2h1(10))
  call Hloop_VA_Q(ntryL,G1H2(20),ex4(:),G1H1(1),m3h2x1(:,15),heltab2x2(:,:,15))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(15),n2h1(11))
  call Hloop_VA_Q(ntryL,G1H2(24),ex4(:),G1H1(1),m3h2x1(:,16),heltab2x2(:,:,16))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(16),n2h1(12))
  call Hloop_ZA_Q(ntryL,G1H2(25),ex4(:),G1H1(1),ngZu,m3h2x1(:,17),heltab2x2(:,:,17))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(17),n2h1(13))
  call Hloop_ZA_Q(ntryL,G1H2(26),ex4(:),G1H1(1),ngZu,m3h2x1(:,18),heltab2x2(:,:,18))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(18),n2h1(14))
  call Hloop_ZA_Q(ntryL,G1H2(30),ex4(:),G1H1(1),ngZu,m3h2x1(:,19),heltab2x2(:,:,19))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(19),n2h1(15))
  call Hloop_VA_Q(ntryL,G1H2(31),ex4(:),G1H1(1),m3h2x1(:,20),heltab2x2(:,:,20))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(20),n2h1(16))
  call Hloop_VA_Q(ntryL,G1H2(32),ex4(:),G1H1(1),m3h2x1(:,21),heltab2x2(:,:,21))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(21),n2h1(17))
  call Hloop_VA_Q(ntryL,G1H2(36),ex4(:),G1H1(1),m3h2x1(:,22),heltab2x2(:,:,22))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(22),n2h1(18))
  call Hloop_VA_Q(ntryL,G1H2(37),ex2(:),G1H1(1),m3h2x1(:,23),heltab2x2(:,:,23))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(23),n2h1(19))
  call Hloop_VA_Q(ntryL,G1H2(38),ex2(:),G1H1(1),m3h2x1(:,24),heltab2x2(:,:,24))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(24),n2h1(20))
  call Hloop_VA_Q(ntryL,G1H2(42),ex2(:),G1H1(1),m3h2x1(:,25),heltab2x2(:,:,25))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(25),n2h1(21))
  call Hloop_VA_Q(ntryL,G1H2(43),ex2(:),G1H1(1),m3h2x1(:,26),heltab2x2(:,:,26))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(26),n2h1(22))
  call Hloop_VA_Q(ntryL,G1H2(44),ex2(:),G1H1(1),m3h2x1(:,27),heltab2x2(:,:,27))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(27),n2h1(23))
  call Hloop_VA_Q(ntryL,G1H2(48),ex2(:),G1H1(1),m3h2x1(:,28),heltab2x2(:,:,28))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(28),n2h1(24))
  call Hloop_ZA_Q(ntryL,G1H2(49),ex2(:),G1H1(1),ngZu,m3h2x1(:,29),heltab2x2(:,:,29))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(29),n2h1(25))
  call Hloop_ZA_Q(ntryL,G1H2(50),ex2(:),G1H1(1),ngZu,m3h2x1(:,30),heltab2x2(:,:,30))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(30),n2h1(26))
  call Hloop_ZA_Q(ntryL,G1H2(54),ex2(:),G1H1(1),ngZu,m3h2x1(:,31),heltab2x2(:,:,31))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(31),n2h1(27))
  call Hloop_VA_Q(ntryL,G1H2(55),ex2(:),G1H1(1),m3h2x1(:,32),heltab2x2(:,:,32))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(32),n2h1(28))
  call Hloop_VA_Q(ntryL,G1H2(56),ex2(:),G1H1(1),m3h2x1(:,33),heltab2x2(:,:,33))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(33),n2h1(29))
  call Hloop_VA_Q(ntryL,G1H2(60),ex2(:),G1H1(1),m3h2x1(:,34),heltab2x2(:,:,34))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(34),n2h1(30))
  call Hloop_VA_Q(ntryL,G1H2(61),ex2(:),G1H1(1),m3h2x1(:,35),heltab2x2(:,:,35))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(35),n2h1(31))
  call Hloop_VA_Q(ntryL,G1H2(62),ex2(:),G1H1(1),m3h2x1(:,36),heltab2x2(:,:,36))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(36),n2h1(32))
  call Hloop_VA_Q(ntryL,G1H2(66),ex2(:),G1H1(1),m3h2x1(:,37),heltab2x2(:,:,37))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(37),n2h1(33))
  call Hloop_ZA_Q(ntryL,G1H2(67),ex2(:),G1H1(1),ngZu,m3h2x1(:,38),heltab2x2(:,:,38))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(38),n2h1(34))
  call Hloop_ZA_Q(ntryL,G1H2(68),ex2(:),G1H1(1),ngZu,m3h2x1(:,39),heltab2x2(:,:,39))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(39),n2h1(35))
  call Hloop_ZA_Q(ntryL,G1H2(72),ex2(:),G1H1(1),ngZu,m3h2x1(:,40),heltab2x2(:,:,40))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(40),n2h1(36))
  call Hotf_5pt_reduction_last(G2tensor(1),RedSet_5(5),mass5set(:,7),  & 
G1tensor(1),G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(5),G1tensor(6))
  call G_TensorShift(G1tensor(2),8)
  call Hotf_5pt_reduction_last(G2tensor(2),RedSet_5(6),mass5set(:,7),  & 
G1tensor(7),G1tensor(8),G1tensor(9),G1tensor(10),G1tensor(11),G1tensor(12))
  call G_TensorShift(G1tensor(8),4)
  call Hotf_5pt_reduction_last(G2tensor(3),RedSet_5(7),mass5set(:,7),  & 
G1tensor(13),G1tensor(14),G1tensor(15),G1tensor(16),G1tensor(17),G1tensor(18))
  call G_TensorShift(G1tensor(14),8)
  call Hotf_5pt_reduction_last(G2tensor(4),RedSet_5(8),mass5set(:,7),  & 
G1tensor(19),G1tensor(20),G1tensor(21),G1tensor(22),G1tensor(23),G1tensor(24))
  call G_TensorShift(G1tensor(20),4)
  call Hotf_5pt_reduction_last(G2tensor(5),RedSet_5(1),mass5set(:,1),  & 
G1tensor(25),G1tensor(26),G1tensor(27),G1tensor(28),G1tensor(29),G1tensor(30))
  call G_TensorShift(G1tensor(26),8)
  call Hotf_5pt_reduction_last(G2tensor(8),RedSet_5(1),mass5set(:,2),  & 
G1tensor(31),G1tensor(32),G1tensor(33),G1tensor(34),G1tensor(35),G1tensor(36))
  call G_TensorShift(G1tensor(32),8)
  call Hotf_5pt_reduction_last(G2tensor(11),RedSet_5(1),mass5set(:,3),  & 
G1tensor(37),G1tensor(38),G1tensor(39),G1tensor(40),G1tensor(41),G1tensor(42))
  call G_TensorShift(G1tensor(38),8)
  call Hotf_5pt_reduction_last(G2tensor(14),RedSet_5(2),mass5set(:,1),  & 
G1tensor(43),G1tensor(44),G1tensor(45),G1tensor(46),G1tensor(47),G1tensor(48))
  call G_TensorShift(G1tensor(44),8)
  call Hotf_5pt_reduction_last(G2tensor(17),RedSet_5(2),mass5set(:,3),  & 
G1tensor(49),G1tensor(50),G1tensor(51),G1tensor(52),G1tensor(53),G1tensor(54))
  call G_TensorShift(G1tensor(50),8)
  call Hotf_5pt_reduction_last(G2tensor(20),RedSet_5(2),mass5set(:,2),  & 
G1tensor(55),G1tensor(56),G1tensor(57),G1tensor(58),G1tensor(59),G1tensor(60))
  call G_TensorShift(G1tensor(56),8)
  call Hotf_5pt_reduction_last(G2tensor(23),RedSet_5(3),mass5set(:,4),  & 
G1tensor(61),G1tensor(62),G1tensor(63),G1tensor(64),G1tensor(65),G1tensor(66))
  call G_TensorShift(G1tensor(62),2)
  call Hotf_5pt_reduction_last(G2tensor(26),RedSet_5(3),mass5set(:,5),  & 
G1tensor(67),G1tensor(68),G1tensor(69),G1tensor(70),G1tensor(71),G1tensor(72))
  call G_TensorShift(G1tensor(68),2)
  call Hotf_5pt_reduction_last(G2tensor(29),RedSet_5(3),mass5set(:,6),  & 
G1tensor(73),G1tensor(74),G1tensor(75),G1tensor(76),G1tensor(77),G1tensor(78))
  call G_TensorShift(G1tensor(74),2)
  call Hotf_5pt_reduction_last(G2tensor(32),RedSet_5(4),mass5set(:,4),  & 
G1tensor(79),G1tensor(80),G1tensor(81),G1tensor(82),G1tensor(83),G1tensor(84))
  call G_TensorShift(G1tensor(80),2)
  call Hotf_5pt_reduction_last(G2tensor(35),RedSet_5(4),mass5set(:,5),  & 
G1tensor(85),G1tensor(86),G1tensor(87),G1tensor(88),G1tensor(89),G1tensor(90))
  call G_TensorShift(G1tensor(86),2)
  call Hotf_5pt_reduction_last(G2tensor(38),RedSet_5(4),mass5set(:,6),  & 
G1tensor(91),G1tensor(92),G1tensor(93),G1tensor(94),G1tensor(95),G1tensor(96))
  call G_TensorShift(G1tensor(92),2)
  call ol_merge_tensors(T1sum(1),[G1tensor(1)])
  call ol_merge_tensors(T1sum(2),[G1tensor(7)])
  call ol_merge_tensors(T1sum(3),[G1tensor(13)])
  call ol_merge_tensors(T1sum(4),[G1tensor(19)])
  call ol_merge_tensors(T1sum(5),[G1tensor(25)])
  call ol_merge_tensors(T1sum(6),[G1tensor(31)])
  call ol_merge_tensors(T1sum(7),[G1tensor(37)])
  call ol_merge_tensors(T1sum(8),[G1tensor(43)])
  call ol_merge_tensors(T1sum(9),[G1tensor(49)])
  call ol_merge_tensors(T1sum(10),[G1tensor(55)])
  call ol_merge_tensors(T1sum(11),[G1tensor(61)])
  call ol_merge_tensors(T1sum(12),[G1tensor(67)])
  call ol_merge_tensors(T1sum(13),[G1tensor(73)])
  call ol_merge_tensors(T1sum(14),[G1tensor(79)])
  call ol_merge_tensors(T1sum(15),[G1tensor(85)])
  call ol_merge_tensors(T1sum(16),[G1tensor(91)])
  Gcoeff(:)%j = (c(32)*M(1,:)%j-c(31)*M(3,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(25),h0tab(:,25),[16,3,8,4],[nMT,nMT,nMH,nMT],4,1,wf4(:,3))
  call Hloop_QZ_A(ntryL,G0H48(1),ex5(:),G0H16(5),ngZu,m3h3x16(:,25),heltab2x48(:,:,25))
  call Hloop_Q_A(ntryL,G0H16(5),16,nMT,G1H16(2),n2h16(21))
  Gcoeff(:)%j = (-(c(32)*M(1,:)%j)+c(31)*M(3,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(26),h0tab(:,26),[16,3,8,4],[nMT,nMT,nMZ,nMT],4,1,wf4(:,3))
  call Hloop_QZ_A(ntryL,G0H48(1),ex5(:),G0H16(1),ngZu,m3h3x16(:,26),heltab2x48(:,:,26))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(1),n2h16(22))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j)+c(29)*M(3,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(27),h0tab(:,27),[16,3,8,4],[nMB,nMB,nMW,nMB],4,1,wf4(:,3))
  call Hloop_QZ_A(ntryL,G0H48(1),ex5(:),G0H16(2),ngZd,m3h3x16(:,27),heltab2x48(:,:,27))
  call Hloop_Q_A(ntryL,G0H16(2),16,nMB,G1H16(7),n2h16(23))
  Gcoeff(:)%j = (-(c(3)*M(3,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(28),h0tab(:,28),[16,3,8,4],[nMT,nMT,0,nMT],4,1,wf4(:,3))
  call Hloop_QZ_A(ntryL,G0H48(1),ex5(:),G0H16(3),ngZu,m3h3x16(:,28),heltab2x48(:,:,28))
  call Hloop_Q_A(ntryL,G0H16(3),16,nMT,G1H16(6),n2h16(24))
  Gcoeff(:)%j = (-(c(6)*M(3,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(29),h0tab(:,29),[16,3,8,4],[nMT,nMT,0,nMT],4,1,wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H48(1),ex5(:),G0H16(4),ngZu,m3h3x16(:,29),heltab2x48(:,:,29))
  call Hloop_Q_A(ntryL,G0H16(4),16,nMT,G1H16(12),n2h16(25))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)+c(1)*M(3,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(30),h0tab(:,30),[16,3,8,4],[nMT,nMT,0,nMT],4,1,wf4(:,3))
  call Hloop_QZ_A(ntryL,G0H48(1),ex5(:),G0H16(5),ngZu,m3h3x16(:,30),heltab2x48(:,:,30))
  call Hloop_Q_A(ntryL,G0H16(5),16,nMT,G1H16(11),n2h16(26))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)+c(4)*M(3,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(31),h0tab(:,31),[16,3,8,4],[nMT,nMT,nMZ,nMT],4,1,wf4(:,3))
  call Hloop_QZ_A(ntryL,G0H48(1),ex5(:),G0H16(1),ngZu,m3h3x16(:,31),heltab2x48(:,:,31))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(17),n2h16(27))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)+c(24)*M(3,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(32),h0tab(:,32),[16,3,8,4],[nMB,nMB,nMW,nMB],4,1,wf4(:,3))
  call Hloop_QZ_A(ntryL,G0H48(1),ex5(:),G0H16(2),ngZd,m3h3x16(:,32),heltab2x48(:,:,32))
  call Hloop_Q_A(ntryL,G0H16(2),16,nMB,G1H16(16),n2h16(28))
  Gcoeff(:)%j = (c(12)*M(2,:)%j-c(11)*M(4,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(33),h0tab(:,33),[16,3,8,4],[nMT,nMT,0,nMT],4,1,wf4(:,3))
  call Hloop_QZ_A(ntryL,G0H48(1),ex5(:),G0H16(3),ngZu,m3h3x16(:,33),heltab2x48(:,:,33))
  call Hloop_Q_A(ntryL,G0H16(3),16,nMT,G1H16(5),n2h16(29))
  Gcoeff(:)%j = (c(32)*M(1,:)%j-c(31)*M(3,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(34),h0tab(:,34),[16,3,4,8],[nMT,nMT,nMH,nMT],4,1,wf4(:,3))
  call Hloop_AZ_Q(ntryL,G0H48(1),ex5(:),G0H16(4),ngZu,m3h3x16(:,34),heltab2x48(:,:,34))
  call Hloop_A_Q(ntryL,G0H16(4),16,nMT,G1H16(3),n2h16(30))
  Gcoeff(:)%j = (-(c(32)*M(1,:)%j)+c(31)*M(3,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(35),h0tab(:,35),[16,3,4,8],[nMT,nMT,nMZ,nMT],4,1,wf4(:,3))
  call Hloop_AZ_Q(ntryL,G0H48(1),ex5(:),G0H16(5),ngZu,m3h3x16(:,35),heltab2x48(:,:,35))
  call Hloop_A_Q(ntryL,G0H16(5),16,nMT,G1H16(4),n2h16(31))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j)+c(29)*M(3,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(36),h0tab(:,36),[16,3,4,8],[nMB,nMB,nMW,nMB],4,1,wf4(:,3))
  call Hloop_AZ_Q(ntryL,G0H48(1),ex5(:),G0H16(1),ngZd,m3h3x16(:,36),heltab2x48(:,:,36))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(10),n2h16(32))
  Gcoeff(:)%j = (-(c(3)*M(3,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(37),h0tab(:,37),[16,3,4,8],[nMT,nMT,0,nMT],4,1,wf4(:,3))
  call Hloop_AZ_Q(ntryL,G0H48(1),ex5(:),G0H16(2),ngZu,m3h3x16(:,37),heltab2x48(:,:,37))
  call Hloop_A_Q(ntryL,G0H16(2),16,nMT,G1H16(8),n2h16(33))
  Gcoeff(:)%j = (-(c(6)*M(3,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(38),h0tab(:,38),[16,3,4,8],[nMT,nMT,0,nMT],4,1,wf4(:,1))
  call Hloop_AZ_Q(ntryL,G0H48(1),ex5(:),G0H16(3),ngZu,m3h3x16(:,38),heltab2x48(:,:,38))
  call Hloop_A_Q(ntryL,G0H16(3),16,nMT,G1H16(9),n2h16(34))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)+c(1)*M(3,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(39),h0tab(:,39),[16,3,4,8],[nMT,nMT,0,nMT],4,1,wf4(:,3))
  call Hloop_AZ_Q(ntryL,G0H48(1),ex5(:),G0H16(4),ngZu,m3h3x16(:,39),heltab2x48(:,:,39))
  call Hloop_A_Q(ntryL,G0H16(4),16,nMT,G1H16(15),n2h16(35))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)+c(4)*M(3,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(40),h0tab(:,40),[16,3,4,8],[nMT,nMT,nMZ,nMT],4,1,wf4(:,3))
  call Hloop_AZ_Q(ntryL,G0H48(1),ex5(:),G0H16(5),ngZu,m3h3x16(:,40),heltab2x48(:,:,40))
  call Hloop_A_Q(ntryL,G0H16(5),16,nMT,G1H16(13),n2h16(36))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)+c(24)*M(3,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(41),h0tab(:,41),[16,3,4,8],[nMB,nMB,nMW,nMB],4,1,wf4(:,3))
  call Hloop_AZ_Q(ntryL,G0H48(1),ex5(:),G0H16(1),ngZd,m3h3x16(:,41),heltab2x48(:,:,41))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(14),n2h16(37))
  Gcoeff(:)%j = (c(12)*M(2,:)%j-c(11)*M(4,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(42),h0tab(:,42),[16,3,4,8],[nMT,nMT,0,nMT],4,1,wf4(:,3))
  call Hloop_AZ_Q(ntryL,G0H48(1),ex5(:),G0H16(2),ngZu,m3h3x16(:,42),heltab2x48(:,:,42))
  call Hloop_A_Q(ntryL,G0H16(2),16,nMT,G1H16(20),n2h16(38))
  Gcoeff(:)%j = (c(23)*M(1,:)%j-c(22)*M(3,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(43),h0tab(:,43),[16,4,3,8],[nMH,nMT,nMT,nMZ],4,1,wf4(:,3))
  call Hloop_SV_T(ntryL,G0H48(1),0,ex5(:),16,G1H16(18),m3h3x16(:,43),heltab2x48(:,:,43))
  Gcoeff(:)%j = (c(23)*M(1,:)%j-c(22)*M(3,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(44),h0tab(:,44),[16,4,3,8],[nMZ,nMT,nMT,nMH],4,1,wf4(:,3))
  call Hloop_TV_S(ntryL,G0H48(1),0,ex5(:),16,G1H16(19),m3h3x16(:,44),heltab2x48(:,:,44))
  Gcoeff(:)%j = (c(36)*M(1,:)%j-c(35)*M(3,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(45),h0tab(:,45),[16,4,3,8],[nMW,nMB,nMB,nMW],4,1,wf4(:,3))
  call Hloop_TV_S(ntryL,G0H48(1),0,ex5(:),16,G1H16(21),m3h3x16(:,45),heltab2x48(:,:,45))
  Gcoeff(:)%j = (c(27)*M(1,:)%j-c(26)*M(3,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(46),h0tab(:,46),[16,4,3,8],[nMH,nMT,nMT,nMZ],4,1,wf4(:,3))
  call Hloop_VV_S(ntryL,G0H48(1),ex5(:),G0H16(3),m3h3x16(:,46),heltab2x48(:,:,46))
  Gcoeff(:)%j = (-(c(34)*M(1,:)%j)+c(33)*M(3,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(47),h0tab(:,47),[16,4,3,8],[nMW,nMB,nMB,nMW],4,1,wf4(:,3))
  call Hloop_VV_S(ntryL,G0H48(1),ex5(:),G0H16(4),m3h3x16(:,47),heltab2x48(:,:,47))
  Gcoeff(:)%j = (c(27)*M(1,:)%j-c(26)*M(3,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(48),h0tab(:,48),[16,4,3,8],[nMZ,nMT,nMT,nMH],4,1,wf4(:,3))
  call Hloop_SV_V(ntryL,G0H48(1),ex5(:),G0H16(5),m3h3x16(:,48),heltab2x48(:,:,48))
  Gcoeff(:)%j = (c(34)*M(1,:)%j-c(33)*M(3,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(49),h0tab(:,49),[16,4,3,8],[nMW,nMB,nMB,nMW],4,1,wf4(:,3))
  call Hloop_SV_V(ntryL,G0H48(1),ex5(:),G0H16(1),m3h3x16(:,49),heltab2x48(:,:,49))
  Gcoeff(:)%j = (-(c(8)*M(2,:)%j)+c(7)*M(4,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(50),h0tab(:,50),[16,4,3,8],[nMT,0,0,nMT],4,1,wf4(:,3))
  call Hloop_AZ_Q(ntryL,G0H48(1),ex5(:),G0H16(2),ngZu,m3h3x16(:,50),heltab2x48(:,:,50))
  call Hloop_A_Q(ntryL,G0H16(2),16,nMT,G1H16(22),n2h16(39))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)+c(20)*M(3,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(51),h0tab(:,51),[16,4,3,8],[nMW,nMB,nMB,nMW],4,1,wf4(:,3))
  call Hloop_UV_W(ntryL,G0H48(1),0,ex5(:),16,G1H16(23),m3h3x16(:,51),heltab2x48(:,:,51))
  Gcoeff(:)%j = (-(c(3)*M(3,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(52),h0tab(:,52),[16,1,2,12],[0,0,0,0],4,1,wf4(:,4))
  call Hloop_AZ_Q(ntryL,G0H48(1),ex5(:),G0H16(2),ngZu,m3h3x16(:,52),heltab2x48(:,:,52))
  call Hloop_A_Q(ntryL,G0H16(2),16,0,G1H16(24),n2h16(40))
  Gcoeff(:)%j = (-(c(6)*M(3,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(53),h0tab(:,53),[16,1,2,12],[0,0,0,0],4,1,wf4(:,5))
  call Hloop_AZ_Q(ntryL,G0H48(1),ex5(:),G0H16(2),ngZu,m3h3x16(:,53),heltab2x48(:,:,53))
  call Hloop_A_Q(ntryL,G0H16(2),16,0,G1H16(25),n2h16(41))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)+c(1)*M(3,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(54),h0tab(:,54),[16,1,2,12],[0,0,0,0],4,1,wf4(:,4))
  call Hloop_AZ_Q(ntryL,G0H48(1),ex5(:),G0H16(2),ngZu,m3h3x16(:,54),heltab2x48(:,:,54))
  call Hloop_A_Q(ntryL,G0H16(2),16,0,G1H16(26),n2h16(42))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)+c(4)*M(3,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(55),h0tab(:,55),[16,1,2,12],[0,nMZ,0,0],4,1,wf4(:,4))
  call Hloop_AZ_Q(ntryL,G0H48(1),ex5(:),G0H16(2),ngZu,m3h3x16(:,55),heltab2x48(:,:,55))
  call Hloop_A_Q(ntryL,G0H16(2),16,0,G1H16(27),n2h16(43))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)+c(24)*M(3,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(56),h0tab(:,56),[16,1,2,12],[0,nMW,0,0],4,1,wf4(:,4))
  call Hloop_AZ_Q(ntryL,G0H48(1),ex5(:),G0H16(2),ngZd,m3h3x16(:,56),heltab2x48(:,:,56))
  call Hloop_A_Q(ntryL,G0H16(2),16,0,G1H16(28),n2h16(44))
  Gcoeff(:)%j = (c(12)*M(2,:)%j-c(11)*M(4,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(57),h0tab(:,57),[16,1,2,12],[0,0,0,0],4,1,wf4(:,4))
  call Hloop_AZ_Q(ntryL,G0H48(1),ex5(:),G0H16(2),ngZu,m3h3x16(:,57),heltab2x48(:,:,57))
  call Hloop_A_Q(ntryL,G0H16(2),16,0,G1H16(29),n2h16(45))
  Gcoeff(:)%j = (-(c(3)*M(3,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(58),h0tab(:,58),[16,2,1,12],[0,0,0,0],4,1,wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H48(1),ex5(:),G0H16(2),ngZu,m3h3x16(:,58),heltab2x48(:,:,58))
  call Hloop_Q_A(ntryL,G0H16(2),16,0,G1H16(30),n2h16(46))
  Gcoeff(:)%j = (-(c(6)*M(3,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(59),h0tab(:,59),[16,2,1,12],[0,0,0,0],4,1,wf4(:,5))
  call Hloop_QZ_A(ntryL,G0H48(1),ex5(:),G0H16(2),ngZu,m3h3x16(:,59),heltab2x48(:,:,59))
  call Hloop_Q_A(ntryL,G0H16(2),16,0,G1H16(31),n2h16(47))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)+c(1)*M(3,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(60),h0tab(:,60),[16,2,1,12],[0,0,0,0],4,1,wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H48(1),ex5(:),G0H16(2),ngZu,m3h3x16(:,60),heltab2x48(:,:,60))
  call Hloop_Q_A(ntryL,G0H16(2),16,0,G1H16(32),n2h16(48))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)+c(4)*M(3,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(61),h0tab(:,61),[16,2,1,12],[0,nMZ,0,0],4,1,wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H48(1),ex5(:),G0H16(2),ngZu,m3h3x16(:,61),heltab2x48(:,:,61))
  call Hloop_Q_A(ntryL,G0H16(2),16,0,G1H16(33),n2h16(49))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)+c(24)*M(3,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(62),h0tab(:,62),[16,2,1,12],[0,nMW,0,0],4,1,wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H48(1),ex5(:),G0H16(2),ngZd,m3h3x16(:,62),heltab2x48(:,:,62))
  call Hloop_Q_A(ntryL,G0H16(2),16,0,G1H16(34),n2h16(50))
  Gcoeff(:)%j = (c(12)*M(2,:)%j-c(11)*M(4,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(63),h0tab(:,63),[16,2,1,12],[0,0,0,0],4,1,wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H48(1),ex5(:),G0H16(2),ngZu,m3h3x16(:,63),heltab2x48(:,:,63))
  call Hloop_Q_A(ntryL,G0H16(2),16,0,G1H16(35),n2h16(51))
  Gcoeff(:)%j = (-(c(8)*M(2,:)%j)+c(7)*M(4,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(64),h0tab(:,64),[16,1,12,2],[0,0,0,0],4,1,wf4(:,4))
  call Hloop_AZ_Q(ntryL,G0H48(1),ex5(:),G0H16(2),ngZu,m3h3x16(:,64),heltab2x48(:,:,64))
  call Hloop_A_Q(ntryL,G0H16(2),16,0,G1H16(36),n2h16(52))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)+c(20)*M(3,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(65),h0tab(:,65),[16,1,12,2],[nMW,0,0,nMW],4,1,wf4(:,4))
  call Hloop_UV_W(ntryL,G0H48(1),0,ex5(:),16,G1H16(37),m3h3x16(:,65),heltab2x48(:,:,65))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)+c(1)*M(3,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(66),h0tab(:,66),[17,2,4,8],[0,0,nMT,0],4,1,wf6(:,6))
  call Hloop_VQ_A(ntryL,G0H48(1),wf6(:,6),G0H8(1),m3h6x8(:,1),heltab2x48(:,:,66))
  call Hloop_Q_A(ntryL,G0H8(1),17,0,G1H8(1),n2h8(5))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)+c(1)*M(3,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(67),h0tab(:,67),[17,2,4,8],[0,0,nMT,0],4,1,wf6(:,6))
  call Hloop_VQ_A(ntryL,G0H48(1),wf6(:,6),G0H8(1),m3h6x8(:,2),heltab2x48(:,:,67))
  call Hloop_Q_A(ntryL,G0H8(1),17,0,G1H8(2),n2h8(6))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)+c(4)*M(3,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(68),h0tab(:,68),[17,2,4,8],[0,nMZ,nMT,0],4,1,wf6(:,6))
  call Hloop_VQ_A(ntryL,G0H48(1),wf6(:,6),G0H8(1),m3h6x8(:,3),heltab2x48(:,:,68))
  call Hloop_Q_A(ntryL,G0H8(1),17,0,G1H8(3),n2h8(7))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)+c(4)*M(3,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(69),h0tab(:,69),[17,2,4,8],[0,0,nMT,nMZ],4,1,wf6(:,6))
  call Hloop_ZQ_A(ntryL,G0H48(1),wf6(:,6),G0H8(1),ngZu,m3h6x8(:,4),heltab2x48(:,:,69))
  call Hloop_Q_A(ntryL,G0H8(1),17,0,G1H8(4),n2h8(8))
  Gcoeff(:)%j = (-(c(17)*M(2,:)%j)-c(11)*M(4,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(70),h0tab(:,70),[17,2,4,8],[0,0,nMT,0],4,1,wf6(:,6))
  call Hloop_VQ_A(ntryL,G0H48(1),wf6(:,6),G0H8(1),m3h6x8(:,5),heltab2x48(:,:,70))
  call Hloop_Q_A(ntryL,G0H8(1),17,0,G1H8(5),n2h8(9))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)+c(1)*M(3,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(71),h0tab(:,71),[17,2,8,4],[0,0,nMT,0],4,1,wf6(:,6))
  call Hloop_VQ_A(ntryL,G0H48(1),wf6(:,6),G0H8(1),m3h6x8(:,6),heltab2x48(:,:,71))
  call Hloop_Q_A(ntryL,G0H8(1),17,0,G1H8(6),n2h8(10))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)+c(1)*M(3,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(72),h0tab(:,72),[17,2,8,4],[0,0,nMT,0],4,1,wf6(:,6))
  call Hloop_VQ_A(ntryL,G0H48(1),wf6(:,6),G0H8(1),m3h6x8(:,7),heltab2x48(:,:,72))
  call Hloop_Q_A(ntryL,G0H8(1),17,0,G1H8(7),n2h8(11))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)+c(4)*M(3,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(73),h0tab(:,73),[17,2,8,4],[0,nMZ,nMT,0],4,1,wf6(:,6))
  call Hloop_VQ_A(ntryL,G0H48(1),wf6(:,6),G0H8(1),m3h6x8(:,8),heltab2x48(:,:,73))
  call Hloop_Q_A(ntryL,G0H8(1),17,0,G1H8(8),n2h8(12))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)+c(4)*M(3,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(74),h0tab(:,74),[17,2,8,4],[0,0,nMT,nMZ],4,1,wf6(:,6))
  call Hloop_ZQ_A(ntryL,G0H48(1),wf6(:,6),G0H8(1),ngZu,m3h6x8(:,9),heltab2x48(:,:,74))
  call Hloop_Q_A(ntryL,G0H8(1),17,0,G1H8(9),n2h8(13))
  Gcoeff(:)%j = (c(13)*M(2,:)%j-c(15)*M(4,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(75),h0tab(:,75),[17,2,8,4],[0,0,nMT,0],4,1,wf6(:,6))
  call Hloop_VQ_A(ntryL,G0H48(1),wf6(:,6),G0H8(1),m3h6x8(:,10),heltab2x48(:,:,75))
  call Hloop_Q_A(ntryL,G0H8(1),17,0,G1H8(10),n2h8(14))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)+c(1)*M(3,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(76),h0tab(:,76),[18,1,4,8],[0,0,nMT,0],4,1,wf6(:,8))
  call Hloop_VA_Q(ntryL,G0H48(1),wf6(:,8),G0H8(1),m3h6x8(:,11),heltab2x48(:,:,76))
  call Hloop_A_Q(ntryL,G0H8(1),18,0,G1H8(11),n2h8(15))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)+c(1)*M(3,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(77),h0tab(:,77),[18,1,4,8],[0,0,nMT,0],4,1,wf6(:,8))
  call Hloop_VA_Q(ntryL,G0H48(1),wf6(:,8),G0H8(1),m3h6x8(:,12),heltab2x48(:,:,77))
  call Hloop_A_Q(ntryL,G0H8(1),18,0,G1H8(12),n2h8(16))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)+c(4)*M(3,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(78),h0tab(:,78),[18,1,4,8],[0,nMZ,nMT,0],4,1,wf6(:,8))
  call Hloop_VA_Q(ntryL,G0H48(1),wf6(:,8),G0H8(1),m3h6x8(:,13),heltab2x48(:,:,78))
  call Hloop_A_Q(ntryL,G0H8(1),18,0,G1H8(13),n2h8(17))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)+c(4)*M(3,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(79),h0tab(:,79),[18,1,4,8],[0,0,nMT,nMZ],4,1,wf6(:,8))
  call Hloop_ZA_Q(ntryL,G0H48(1),wf6(:,8),G0H8(1),ngZu,m3h6x8(:,14),heltab2x48(:,:,79))
  call Hloop_A_Q(ntryL,G0H8(1),18,0,G1H8(14),n2h8(18))
  Gcoeff(:)%j = (c(13)*M(2,:)%j-c(15)*M(4,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(80),h0tab(:,80),[18,1,4,8],[0,0,nMT,0],4,1,wf6(:,8))
  call Hloop_VA_Q(ntryL,G0H48(1),wf6(:,8),G0H8(1),m3h6x8(:,15),heltab2x48(:,:,80))
  call Hloop_A_Q(ntryL,G0H8(1),18,0,G1H8(15),n2h8(19))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)+c(1)*M(3,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(81),h0tab(:,81),[18,1,8,4],[0,0,nMT,0],4,1,wf6(:,8))
  call Hloop_VA_Q(ntryL,G0H48(1),wf6(:,8),G0H8(1),m3h6x8(:,16),heltab2x48(:,:,81))
  call Hloop_A_Q(ntryL,G0H8(1),18,0,G1H8(16),n2h8(20))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)+c(1)*M(3,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(82),h0tab(:,82),[18,1,8,4],[0,0,nMT,0],4,1,wf6(:,8))
  call Hloop_VA_Q(ntryL,G0H48(1),wf6(:,8),G0H8(1),m3h6x8(:,17),heltab2x48(:,:,82))
  call Hloop_A_Q(ntryL,G0H8(1),18,0,G1H8(17),n2h8(21))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)+c(4)*M(3,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(83),h0tab(:,83),[18,1,8,4],[0,nMZ,nMT,0],4,1,wf6(:,8))
  call Hloop_VA_Q(ntryL,G0H48(1),wf6(:,8),G0H8(1),m3h6x8(:,18),heltab2x48(:,:,83))
  call Hloop_A_Q(ntryL,G0H8(1),18,0,G1H8(18),n2h8(22))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)+c(4)*M(3,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(84),h0tab(:,84),[18,1,8,4],[0,0,nMT,nMZ],4,1,wf6(:,8))
  call Hloop_ZA_Q(ntryL,G0H48(1),wf6(:,8),G0H8(1),ngZu,m3h6x8(:,19),heltab2x48(:,:,84))
  call Hloop_A_Q(ntryL,G0H8(1),18,0,G1H8(19),n2h8(23))
  Gcoeff(:)%j = (-(c(17)*M(2,:)%j)-c(11)*M(4,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(85),h0tab(:,85),[18,1,8,4],[0,0,nMT,0],4,1,wf6(:,8))
  call Hloop_VA_Q(ntryL,G0H48(1),wf6(:,8),G0H8(1),m3h6x8(:,20),heltab2x48(:,:,85))
  call Hloop_A_Q(ntryL,G0H8(1),18,0,G1H8(20),n2h8(24))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)+c(1)*M(3,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(86),h0tab(:,86),[20,2,1,8],[0,0,0,nMT],4,1,wf6(:,2))
  call Hloop_AQ_V(ntryL,G0H48(1),wf6(:,2),G0H8(1),m3h6x8(:,21),heltab2x48(:,:,86))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)+c(1)*M(3,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(87),h0tab(:,87),[20,2,1,8],[0,0,0,nMT],4,1,wf6(:,2))
  call Hloop_AQ_V(ntryL,G0H48(1),wf6(:,2),G0H8(2),m3h6x8(:,22),heltab2x48(:,:,87))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)+c(4)*M(3,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(88),h0tab(:,88),[20,2,1,8],[0,0,nMZ,nMT],4,1,wf6(:,2))
  call Hloop_AQ_V(ntryL,G0H48(1),wf6(:,2),G0H8(3),m3h6x8(:,23),heltab2x48(:,:,88))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)+c(4)*M(3,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(89),h0tab(:,89),[20,2,1,8],[nMZ,0,0,nMT],4,1,wf6(:,2))
  call Hloop_AQ_Z(ntryL,G0H48(1),wf6(:,2),G0H8(4),ngZu,m3h6x8(:,24),heltab2x48(:,:,89))
  Gcoeff(:)%j = (-(c(17)*M(2,:)%j)-c(11)*M(4,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(90),h0tab(:,90),[20,2,1,8],[0,0,0,nMT],4,1,wf6(:,2))
  call Hloop_AQ_V(ntryL,G0H48(1),wf6(:,2),G0H8(5),m3h6x8(:,25),heltab2x48(:,:,90))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)+c(1)*M(3,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(91),h0tab(:,91),[20,1,2,8],[0,0,0,nMT],4,1,wf6(:,2))
  call Hloop_AQ_V(ntryL,G0H48(1),wf6(:,2),G0H8(6),m3h6x8(:,26),heltab2x48(:,:,91))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)+c(1)*M(3,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(92),h0tab(:,92),[20,1,2,8],[0,0,0,nMT],4,1,wf6(:,2))
  call Hloop_AQ_V(ntryL,G0H48(1),wf6(:,2),G0H8(7),m3h6x8(:,27),heltab2x48(:,:,92))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)+c(4)*M(3,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(93),h0tab(:,93),[20,1,2,8],[nMZ,0,0,nMT],4,1,wf6(:,2))
  call Hloop_AQ_Z(ntryL,G0H48(1),wf6(:,2),G0H8(8),ngZu,m3h6x8(:,28),heltab2x48(:,:,93))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)+c(4)*M(3,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(94),h0tab(:,94),[20,1,2,8],[0,0,nMZ,nMT],4,1,wf6(:,2))
  call Hloop_AQ_V(ntryL,G0H48(1),wf6(:,2),G0H8(9),m3h6x8(:,29),heltab2x48(:,:,94))
  Gcoeff(:)%j = (c(13)*M(2,:)%j-c(15)*M(4,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(95),h0tab(:,95),[20,1,2,8],[0,0,0,nMT],4,1,wf6(:,2))
  call Hloop_AQ_V(ntryL,G0H48(1),wf6(:,2),G0H8(10),m3h6x8(:,30),heltab2x48(:,:,95))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)+c(1)*M(3,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(96),h0tab(:,96),[24,2,1,4],[0,0,0,nMT],4,1,wf6(:,4))
  call Hloop_QA_V(ntryL,G0H48(1),wf6(:,4),G0H8(11),m3h6x8(:,31),heltab2x48(:,:,96))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)+c(1)*M(3,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(97),h0tab(:,97),[24,2,1,4],[0,0,0,nMT],4,1,wf6(:,4))
  call Hloop_QA_V(ntryL,G0H48(1),wf6(:,4),G0H8(12),m3h6x8(:,32),heltab2x48(:,:,97))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)+c(4)*M(3,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(98),h0tab(:,98),[24,2,1,4],[0,0,nMZ,nMT],4,1,wf6(:,4))
  call Hloop_QA_V(ntryL,G0H48(1),wf6(:,4),G0H8(13),m3h6x8(:,33),heltab2x48(:,:,98))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)+c(4)*M(3,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(99),h0tab(:,99),[24,2,1,4],[nMZ,0,0,nMT],4,1,wf6(:,4))
  call Hloop_QA_Z(ntryL,G0H48(1),wf6(:,4),G0H8(14),ngZu,m3h6x8(:,34),heltab2x48(:,:,99))
  Gcoeff(:)%j = (c(13)*M(2,:)%j-c(15)*M(4,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(100),h0tab(:,100),[24,2,1,4],[0,0,0,nMT],4,1,wf6(:,4))
  call Hloop_QA_V(ntryL,G0H48(1),wf6(:,4),G0H8(15),m3h6x8(:,35),heltab2x48(:,:,100))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)+c(1)*M(3,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(101),h0tab(:,101),[24,1,2,4],[0,0,0,nMT],4,1,wf6(:,4))
  call Hloop_QA_V(ntryL,G0H48(1),wf6(:,4),G0H8(16),m3h6x8(:,36),heltab2x48(:,:,101))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)+c(1)*M(3,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(102),h0tab(:,102),[24,1,2,4],[0,0,0,nMT],4,1,wf6(:,4))
  call Hloop_QA_V(ntryL,G0H48(1),wf6(:,4),G0H8(17),m3h6x8(:,37),heltab2x48(:,:,102))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)+c(4)*M(3,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(103),h0tab(:,103),[24,1,2,4],[nMZ,0,0,nMT],4,1,wf6(:,4))
  call Hloop_QA_Z(ntryL,G0H48(1),wf6(:,4),G0H8(18),ngZu,m3h6x8(:,38),heltab2x48(:,:,103))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)+c(4)*M(3,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(104),h0tab(:,104),[24,1,2,4],[0,0,nMZ,nMT],4,1,wf6(:,4))
  call Hloop_QA_V(ntryL,G0H48(1),wf6(:,4),G0H8(19),m3h6x8(:,39),heltab2x48(:,:,104))
  Gcoeff(:)%j = (-(c(17)*M(2,:)%j)-c(11)*M(4,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(105),h0tab(:,105),[24,1,2,4],[0,0,0,nMT],4,1,wf6(:,4))
  call Hloop_QA_V(ntryL,G0H48(1),wf6(:,4),G0H8(20),m3h6x8(:,40),heltab2x48(:,:,105))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(5),[G1H16(11),G1H16(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(20),[G1H16(15),G1H16(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(29),[G1H16(26),G1H16(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(35),[G1H16(32),G1H16(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(5),[G1H8(2),G1H8(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(10),[G1H8(7),G1H8(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(15),[G1H8(12),G1H8(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(20),[G1H8(17),G1H8(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(5),[G0H8(2),G0H8(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(10),[G0H8(7),G0H8(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(15),[G0H8(12),G0H8(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(20),[G0H8(17),G0H8(16)])
  call Hloop_QV_A(ntryL,G1H16(2),wf4(:,3),G1H4(5),m3h4x4(:,1),heltab2x16(:,:,17))
  call Hloop_Q_A(ntryL,G1H4(5),19,nMT,G2H4(1),n2h4(13))
  call Hloop_QV_A(ntryL,G1H16(1),wf4(:,3),G1H4(1),m3h4x4(:,2),heltab2x16(:,:,18))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMT,G2H4(2),n2h4(14))
  call Hloop_QV_A(ntryL,G1H16(7),wf4(:,3),G1H4(2),m3h4x4(:,3),heltab2x16(:,:,19))
  call Hloop_Q_A(ntryL,G1H4(2),19,nMB,G2H4(3),n2h4(15))
  call Hloop_QV_A(ntryL,G1H16(5),wf4(:,3),G1H4(3),m3h4x4(:,4),heltab2x16(:,:,20))
  call Hloop_Q_A(ntryL,G1H4(3),19,nMT,G2H4(4),n2h4(16))
  call Hloop_QZ_A(ntryL,G1H16(12),wf4(:,1),G1H4(4),ngZu,m3h4x4(:,5),heltab2x16(:,:,21))
  call Hloop_Q_A(ntryL,G1H4(4),19,nMT,G2H4(5),n2h4(17))
  call Hloop_QV_A(ntryL,G1H16(17),wf4(:,3),G1H4(5),m3h4x4(:,6),heltab2x16(:,:,22))
  call Hloop_Q_A(ntryL,G1H4(5),19,nMT,G2H4(6),n2h4(18))
  call Hloop_QV_A(ntryL,G1H16(16),wf4(:,3),G1H4(1),m3h4x4(:,7),heltab2x16(:,:,23))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMB,G2H4(7),n2h4(19))
  call Hloop_AV_Q(ntryL,G1H16(3),wf4(:,3),G1H4(2),m3h4x4(:,8),heltab2x16(:,:,24))
  call Hloop_A_Q(ntryL,G1H4(2),19,nMT,G2H4(8),n2h4(20))
  call Hloop_AV_Q(ntryL,G1H16(4),wf4(:,3),G1H4(3),m3h4x4(:,9),heltab2x16(:,:,25))
  call Hloop_A_Q(ntryL,G1H4(3),19,nMT,G2H4(9),n2h4(21))
  call Hloop_AV_Q(ntryL,G1H16(10),wf4(:,3),G1H4(4),m3h4x4(:,10),heltab2x16(:,:,26))
  call Hloop_A_Q(ntryL,G1H4(4),19,nMB,G2H4(10),n2h4(22))
  call Hloop_AV_Q(ntryL,G1H16(20),wf4(:,3),G1H4(5),m3h4x4(:,11),heltab2x16(:,:,27))
  call Hloop_A_Q(ntryL,G1H4(5),19,nMT,G2H4(11),n2h4(23))
  call Hloop_AZ_Q(ntryL,G1H16(9),wf4(:,1),G1H4(1),ngZu,m3h4x4(:,12),heltab2x16(:,:,28))
  call Hloop_A_Q(ntryL,G1H4(1),19,nMT,G2H4(12),n2h4(24))
  call Hloop_AV_Q(ntryL,G1H16(13),wf4(:,3),G1H4(2),m3h4x4(:,13),heltab2x16(:,:,29))
  call Hloop_A_Q(ntryL,G1H4(2),19,nMT,G2H4(13),n2h4(25))
  call Hloop_AV_Q(ntryL,G1H16(14),wf4(:,3),G1H4(3),m3h4x4(:,14),heltab2x16(:,:,30))
  call Hloop_A_Q(ntryL,G1H4(3),19,nMB,G2H4(14),n2h4(26))
  call Hloop_SQ_A(ntryL,G1H16(18),ex3(:),G1H8(2),ngH,m3h2x8(:,17),heltab2x16(:,:,31))
  call Hloop_Q_A(ntryL,G1H8(2),20,nMT,G2H8(1),n2h8(25))
  call Hloop_SQ_A(ntryL,G1H16(19),ex3(:),G1H8(1),ngX,m3h2x8(:,18),heltab2x16(:,:,32))
  call Hloop_Q_A(ntryL,G1H8(1),20,nMT,G2H8(2),n2h8(26))
  call Hloop_SQ_A(ntryL,G1H16(21),ex3(:),G1H8(7),ngPbt,m3h2x8(:,19),heltab2x16(:,:,33))
  call Hloop_Q_A(ntryL,G1H8(7),20,nMB,G2H8(3),n2h8(27))
  call Hloop_SQ_A(ntryL,G0H16(3),ex3(:),G0H8(2),ngH,m3h2x8(:,20),heltab2x16(:,:,34))
  call Hloop_Q_A(ntryL,G0H8(2),20,nMT,G1H8(6),n2h8(28))
  call Hloop_SQ_A(ntryL,G0H16(4),ex3(:),G0H8(1),ngPbt,m3h2x8(:,21),heltab2x16(:,:,35))
  call Hloop_Q_A(ntryL,G0H8(1),20,nMB,G1H8(12),n2h8(29))
  call Hloop_ZQ_A(ntryL,G0H16(5),ex3(:),G0H8(7),ngZu,m3h2x8(:,22),heltab2x16(:,:,36))
  call Hloop_Q_A(ntryL,G0H8(7),20,nMT,G1H8(11),n2h8(30))
  call Hloop_WQ_A(ntryL,G0H16(1),ex3(:),G0H8(6),m3h2x8(:,23),heltab2x16(:,:,37))
  call Hloop_Q_A(ntryL,G0H8(6),20,nMB,G1H8(17),n2h8(31))
  call Hloop_AQ_V(ntryL,G1H16(22),ex3(:),G1H8(16),m3h2x8(:,24),heltab2x16(:,:,38))
  call Hloop_WQ_A(ntryL,G1H16(23),ex3(:),G1H8(2),m3h2x8(:,25),heltab2x16(:,:,39))
  call Hloop_Q_A(ntryL,G1H8(2),20,nMB,G2H8(4),n2h8(32))
  call Hloop_AQ_V(ntryL,G1H16(29),ex1(:),G1H8(1),m3h2x8(:,26),heltab2x16(:,:,40))
  call Hloop_AQ_V(ntryL,G1H16(25),ex1(:),G1H8(7),m3h2x8(:,27),heltab2x16(:,:,41))
  call Hloop_AQ_Z(ntryL,G1H16(27),ex1(:),G1H8(2),ngZu,m3h2x8(:,28),heltab2x16(:,:,42))
  call Hloop_AQ_W(ntryL,G1H16(28),ex1(:),G1H8(21),m3h2x8(:,29),heltab2x16(:,:,43))
  call Hloop_QA_V(ntryL,G1H16(35),ex2(:),G1H8(22),m3h2x8(:,30),heltab2x16(:,:,44))
  call Hloop_QA_V(ntryL,G1H16(31),ex2(:),G1H8(23),m3h2x8(:,31),heltab2x16(:,:,45))
  call Hloop_QA_Z(ntryL,G1H16(33),ex2(:),G1H8(24),ngZu,m3h2x8(:,32),heltab2x16(:,:,46))
  call Hloop_QA_W(ntryL,G1H16(34),ex2(:),G1H8(25),m3h2x8(:,33),heltab2x16(:,:,47))
  call Hloop_AQ_V(ntryL,G1H16(36),ex1(:),G1H8(26),m3h2x8(:,34),heltab2x16(:,:,48))
  call Hloop_WQ_A(ntryL,G1H16(37),ex1(:),G1H8(27),m3h2x8(:,35),heltab2x16(:,:,49))
  call Hloop_Q_A(ntryL,G1H8(27),17,0,G2H8(5),n2h8(33))
  call Hloop_QA_V(ntryL,G1H8(5),ex2(:),G1H4(4),m3h2x4(:,17),heltab2x8(:,:,17))
  call Hloop_QA_Z(ntryL,G1H8(3),ex2(:),G1H4(5),ngZu,m3h2x4(:,18),heltab2x8(:,:,18))
  call Hloop_QA_V(ntryL,G1H8(4),ex2(:),G1H4(1),m3h2x4(:,19),heltab2x8(:,:,19))
  call Hloop_QA_V(ntryL,G1H8(10),ex2(:),G1H4(2),m3h2x4(:,20),heltab2x8(:,:,20))
  call Hloop_QA_Z(ntryL,G1H8(8),ex2(:),G1H4(3),ngZu,m3h2x4(:,21),heltab2x8(:,:,21))
  call Hloop_QA_V(ntryL,G1H8(9),ex2(:),G1H4(6),m3h2x4(:,22),heltab2x8(:,:,22))
  call Hloop_AQ_V(ntryL,G1H8(15),ex1(:),G1H4(7),m3h2x4(:,23),heltab2x8(:,:,23))
  call Hloop_AQ_Z(ntryL,G1H8(13),ex1(:),G1H4(8),ngZu,m3h2x4(:,24),heltab2x8(:,:,24))
  call Hloop_AQ_V(ntryL,G1H8(14),ex1(:),G1H4(9),m3h2x4(:,25),heltab2x8(:,:,25))
  call Hloop_AQ_V(ntryL,G1H8(20),ex1(:),G1H4(10),m3h2x4(:,26),heltab2x8(:,:,26))
  call Hloop_AQ_Z(ntryL,G1H8(18),ex1(:),G1H4(11),ngZu,m3h2x4(:,27),heltab2x8(:,:,27))
  call Hloop_AQ_V(ntryL,G1H8(19),ex1(:),G1H4(12),m3h2x4(:,28),heltab2x8(:,:,28))
  call Hloop_VA_Q(ntryL,G0H8(5),ex2(:),G0H4(1),m3h2x4(:,29),heltab2x8(:,:,29))
  call Hloop_A_Q(ntryL,G0H4(1),22,0,G1H4(13),n2h4(27))
  call Hloop_VA_Q(ntryL,G0H8(3),ex2(:),G0H4(1),m3h2x4(:,30),heltab2x8(:,:,30))
  call Hloop_A_Q(ntryL,G0H4(1),22,0,G1H4(14),n2h4(28))
  call Hloop_ZA_Q(ntryL,G0H8(4),ex2(:),G0H4(1),ngZu,m3h2x4(:,31),heltab2x8(:,:,31))
  call Hloop_A_Q(ntryL,G0H4(1),22,0,G1H4(15),n2h4(29))
  call Hloop_VQ_A(ntryL,G0H8(10),ex1(:),G0H4(1),m3h2x4(:,32),heltab2x8(:,:,32))
  call Hloop_Q_A(ntryL,G0H4(1),21,0,G1H4(16),n2h4(30))
  call Hloop_ZQ_A(ntryL,G0H8(8),ex1(:),G0H4(1),ngZu,m3h2x4(:,33),heltab2x8(:,:,33))
  call Hloop_Q_A(ntryL,G0H4(1),21,0,G1H4(17),n2h4(31))
  call Hloop_VQ_A(ntryL,G0H8(9),ex1(:),G0H4(1),m3h2x4(:,34),heltab2x8(:,:,34))
  call Hloop_Q_A(ntryL,G0H4(1),21,0,G1H4(18),n2h4(32))
  call Hloop_VA_Q(ntryL,G0H8(15),ex2(:),G0H4(1),m3h2x4(:,35),heltab2x8(:,:,35))
  call Hloop_A_Q(ntryL,G0H4(1),26,0,G1H4(19),n2h4(33))
  call Hloop_VA_Q(ntryL,G0H8(13),ex2(:),G0H4(1),m3h2x4(:,36),heltab2x8(:,:,36))
  call Hloop_A_Q(ntryL,G0H4(1),26,0,G1H4(20),n2h4(34))
  call Hloop_ZA_Q(ntryL,G0H8(14),ex2(:),G0H4(1),ngZu,m3h2x4(:,37),heltab2x8(:,:,37))
  call Hloop_A_Q(ntryL,G0H4(1),26,0,G1H4(21),n2h4(35))
  call Hloop_VQ_A(ntryL,G0H8(20),ex1(:),G0H4(1),m3h2x4(:,38),heltab2x8(:,:,38))
  call Hloop_Q_A(ntryL,G0H4(1),25,0,G1H4(22),n2h4(36))
  call Hloop_ZQ_A(ntryL,G0H8(18),ex1(:),G0H4(1),ngZu,m3h2x4(:,39),heltab2x8(:,:,39))
  call Hloop_Q_A(ntryL,G0H4(1),25,0,G1H4(23),n2h4(37))
  call Hloop_VQ_A(ntryL,G0H8(19),ex1(:),G0H4(1),m3h2x4(:,40),heltab2x8(:,:,40))
  call Hloop_Q_A(ntryL,G0H4(1),25,0,G1H4(24),n2h4(38))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(5),[G2H4(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(12),[G2H4(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(2),[G1H8(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(3),[G1H8(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(4),[G1H8(12)])
  call Hloop_QA_S(ntryL,G2H4(1),ex4(:),G2H2(1),ngH,m3h2x2(:,17),heltab2x4(:,:,17))
  call Hloop_QA_S(ntryL,G2H4(2),ex4(:),G2H2(2),ngX,m3h2x2(:,18),heltab2x4(:,:,18))
  call Hloop_QA_S(ntryL,G2H4(3),ex4(:),G2H2(3),ngPtb,m3h2x2(:,19),heltab2x4(:,:,19))
  call Hloop_QA_V(ntryL,G2H4(5),ex4(:),G2H2(4),m3h2x2(:,20),heltab2x4(:,:,20))
  call Hloop_QA_Z(ntryL,G2H4(6),ex4(:),G2H2(5),ngZu,m3h2x2(:,21),heltab2x4(:,:,21))
  call Hloop_QA_W(ntryL,G2H4(7),ex4(:),G2H2(6),m3h2x2(:,22),heltab2x4(:,:,22))
  call Hloop_AQ_S(ntryL,G2H4(8),ex3(:),G2H2(7),ngH,m3h2x2(:,23),heltab2x4(:,:,23))
  call Hloop_AQ_S(ntryL,G2H4(9),ex3(:),G2H2(8),ngX,m3h2x2(:,24),heltab2x4(:,:,24))
  call Hloop_AQ_S(ntryL,G2H4(10),ex3(:),G2H2(9),ngPbt,m3h2x2(:,25),heltab2x4(:,:,25))
  call Hloop_AQ_V(ntryL,G2H4(12),ex3(:),G2H2(10),m3h2x2(:,26),heltab2x4(:,:,26))
  call Hloop_AQ_Z(ntryL,G2H4(13),ex3(:),G2H2(11),ngZu,m3h2x2(:,27),heltab2x4(:,:,27))
  call Hloop_AQ_W(ntryL,G2H4(14),ex3(:),G2H2(12),m3h2x2(:,28),heltab2x4(:,:,28))
  call Hotf_4pt_reduction(G2H8(1),RedSet_4(19),mass4set(:,1),  & 
G1H8(27),G1H8(5),G1H8(3),G1H8(4),G1H8(10),8)
  call HG1shiftOLR(G1H8(5),8,8)
  call Hotf_4pt_reduction(G2H8(2),RedSet_4(19),mass4set(:,2),  & 
G1H8(8),G1H8(9),G1H8(15),G1H8(13),G1H8(14),8)
  call HG1shiftOLR(G1H8(9),8,8)
  call Hotf_4pt_reduction(G2H8(3),RedSet_4(19),mass4set(:,3),  & 
G1H8(20),G1H8(18),G1H8(19),G1H8(11),G1H8(17),8)
  call HG1shiftOLR(G1H8(18),8,8)
  call Hloop_QV_A(ntryL,G1H8(6),wf4(:,3),G1H2(1),m3h4x2(:,1),heltab2x8(:,:,41))
  call Hloop_Q_A(ntryL,G1H2(1),23,nMT,G2H2(13),n2h2(5))
  call Hotf_4pt_reduction(G2H8(4),RedSet_4(19),mass4set(:,3),  & 
G1H8(12),G1H8(6),G1H8(28),G1H8(29),G1H8(30),8)
  call HG1shiftOLR(G1H8(6),8,8)
  call Hloop_UV_W(ntryL,G1H8(16),20,wf4(:,3),3,G2H2(14),m3h4x2(:,2),heltab2x8(:,:,42))
  call Hloop_VA_Q(ntryL,G1H8(1),ex2(:),G1H4(25),m3h2x4(:,41),heltab2x8(:,:,43))
  call Hloop_A_Q(ntryL,G1H4(25),19,0,G2H4(4),n2h4(39))
  call Hloop_VA_Q(ntryL,G1H8(7),ex2(:),G1H4(25),m3h2x4(:,42),heltab2x8(:,:,44))
  call Hloop_A_Q(ntryL,G1H4(25),19,0,G2H4(11),n2h4(40))
  call Hloop_ZA_Q(ntryL,G1H8(2),ex2(:),G1H4(25),ngZu,m3h2x4(:,43),heltab2x8(:,:,45))
  call Hloop_A_Q(ntryL,G1H4(25),19,0,G2H4(1),n2h4(41))
  call Hloop_WA_Q(ntryL,G1H8(21),ex2(:),G1H4(25),m3h2x4(:,44),heltab2x8(:,:,46))
  call Hloop_A_Q(ntryL,G1H4(25),19,0,G2H4(2),n2h4(42))
  call Hloop_VQ_A(ntryL,G1H8(22),ex1(:),G1H4(25),m3h2x4(:,45),heltab2x8(:,:,47))
  call Hloop_Q_A(ntryL,G1H4(25),19,0,G2H4(3),n2h4(43))
  call Hloop_VQ_A(ntryL,G1H8(23),ex1(:),G1H4(25),m3h2x4(:,46),heltab2x8(:,:,48))
  call Hloop_Q_A(ntryL,G1H4(25),19,0,G2H4(5),n2h4(44))
  call Hloop_ZQ_A(ntryL,G1H8(24),ex1(:),G1H4(25),ngZu,m3h2x4(:,47),heltab2x8(:,:,49))
  call Hloop_Q_A(ntryL,G1H4(25),19,0,G2H4(6),n2h4(45))
  call Hloop_WQ_A(ntryL,G1H8(25),ex1(:),G1H4(25),m3h2x4(:,48),heltab2x8(:,:,50))
  call Hloop_Q_A(ntryL,G1H4(25),19,0,G2H4(7),n2h4(46))
  call Hloop_UV_W(ntryL,G1H8(26),17,wf4(:,4),12,G2H2(15),m3h4x2(:,3),heltab2x8(:,:,51))
  call Hotf_4pt_reduction(G2H8(5),RedSet_4(28),mass4set(:,4),  & 
G1H8(16),G1H8(1),G1H8(7),G1H8(2),G1H8(21),8)
  call HG1shiftOLR(G1H8(1),2,8)
  call Hloop_VQ_A(ntryL,G1H4(4),ex3(:),G1H2(2),m3h2x2(:,29),heltab2x4(:,:,29))
  call Hloop_Q_A(ntryL,G1H2(2),23,nMT,G2H2(16),n2h2(6))
  call Hloop_ZQ_A(ntryL,G1H4(5),ex3(:),G1H2(6),ngZu,m3h2x2(:,30),heltab2x4(:,:,30))
  call Hloop_Q_A(ntryL,G1H2(6),23,nMT,G2H2(17),n2h2(7))
  call Hloop_VQ_A(ntryL,G1H4(1),ex3(:),G1H2(7),m3h2x2(:,31),heltab2x4(:,:,31))
  call Hloop_Q_A(ntryL,G1H2(7),23,nMT,G2H2(18),n2h2(8))
  call Hloop_VA_Q(ntryL,G1H4(2),ex4(:),G1H2(8),m3h2x2(:,32),heltab2x4(:,:,32))
  call Hloop_A_Q(ntryL,G1H2(8),27,nMT,G2H2(19),n2h2(9))
  call Hloop_ZA_Q(ntryL,G1H4(3),ex4(:),G1H2(12),ngZu,m3h2x2(:,33),heltab2x4(:,:,33))
  call Hloop_A_Q(ntryL,G1H2(12),27,nMT,G2H2(20),n2h2(10))
  call Hloop_VA_Q(ntryL,G1H4(6),ex4(:),G1H2(13),m3h2x2(:,34),heltab2x4(:,:,34))
  call Hloop_A_Q(ntryL,G1H2(13),27,nMT,G2H2(21),n2h2(11))
  call Hloop_VQ_A(ntryL,G1H4(7),ex3(:),G1H2(14),m3h2x2(:,35),heltab2x4(:,:,35))
  call Hloop_Q_A(ntryL,G1H2(14),23,nMT,G2H2(22),n2h2(12))
  call Hloop_ZQ_A(ntryL,G1H4(8),ex3(:),G1H2(18),ngZu,m3h2x2(:,36),heltab2x4(:,:,36))
  call Hloop_Q_A(ntryL,G1H2(18),23,nMT,G2H2(23),n2h2(13))
  call Hloop_VQ_A(ntryL,G1H4(9),ex3(:),G1H2(19),m3h2x2(:,37),heltab2x4(:,:,37))
  call Hloop_Q_A(ntryL,G1H2(19),23,nMT,G2H2(24),n2h2(14))
  call Hloop_VA_Q(ntryL,G1H4(10),ex4(:),G1H2(20),m3h2x2(:,38),heltab2x4(:,:,38))
  call Hloop_A_Q(ntryL,G1H2(20),27,nMT,G2H2(25),n2h2(15))
  call Hloop_ZA_Q(ntryL,G1H4(11),ex4(:),G1H2(24),ngZu,m3h2x2(:,39),heltab2x4(:,:,39))
  call Hloop_A_Q(ntryL,G1H2(24),27,nMT,G2H2(26),n2h2(16))
  call Hloop_VA_Q(ntryL,G1H4(12),ex4(:),G1H2(25),m3h2x2(:,40),heltab2x4(:,:,40))
  call Hloop_A_Q(ntryL,G1H2(25),27,nMT,G2H2(27),n2h2(17))
  call Hloop_AQ_V(ntryL,G1H4(13),ex1(:),G1H2(26),m3h2x2(:,41),heltab2x4(:,:,41))
  call Hloop_AQ_Z(ntryL,G1H4(14),ex1(:),G1H2(30),ngZu,m3h2x2(:,42),heltab2x4(:,:,42))
  call Hloop_AQ_V(ntryL,G1H4(15),ex1(:),G1H2(31),m3h2x2(:,43),heltab2x4(:,:,43))
  call Hloop_QA_V(ntryL,G1H4(16),ex2(:),G1H2(32),m3h2x2(:,44),heltab2x4(:,:,44))
  call Hloop_QA_V(ntryL,G1H4(17),ex2(:),G1H2(36),m3h2x2(:,45),heltab2x4(:,:,45))
  call Hloop_QA_Z(ntryL,G1H4(18),ex2(:),G1H2(37),ngZu,m3h2x2(:,46),heltab2x4(:,:,46))
  call Hloop_AQ_V(ntryL,G1H4(19),ex1(:),G1H2(38),m3h2x2(:,47),heltab2x4(:,:,47))
  call Hloop_AQ_Z(ntryL,G1H4(20),ex1(:),G1H2(42),ngZu,m3h2x2(:,48),heltab2x4(:,:,48))
  call Hloop_AQ_V(ntryL,G1H4(21),ex1(:),G1H2(43),m3h2x2(:,49),heltab2x4(:,:,49))
  call Hloop_QA_V(ntryL,G1H4(22),ex2(:),G1H2(44),m3h2x2(:,50),heltab2x4(:,:,50))
  call Hloop_QA_V(ntryL,G1H4(23),ex2(:),G1H2(48),m3h2x2(:,51),heltab2x4(:,:,51))
  call Hloop_QA_Z(ntryL,G1H4(24),ex2(:),G1H2(49),ngZu,m3h2x2(:,52),heltab2x4(:,:,52))
  call Hloop_QV_A(ntryL,G1H8(27),wf4(:,3),G1H2(50),m3h4x2(:,4),heltab2x8(:,:,52))
  call Hloop_Q_A(ntryL,G1H2(50),23,nMT,G2H2(28),n2h2(18))
call HGT_OLR(G1H8(5),1,1,8)
call HGT_invQ_OLR(G1H8(5),2,5,8)
  call Hloop_SA_Q(ntryL,G1H8(5),ex4(:),G1H4(25),ngX,m3h2x4(:,49),heltab2x8(:,:,53))
  call Hloop_QV_A(ntryL,G1H8(4),wf4(:,3),G1H2(54),m3h4x2(:,5),heltab2x8(:,:,54))
  call Hloop_Q_A(ntryL,G1H2(54),23,nMT,G2H2(29),n2h2(19))
  call Hloop_QV_A(ntryL,G1H8(10),wf4(:,3),G1H2(55),m3h4x2(:,6),heltab2x8(:,:,55))
  call Hloop_Q_A(ntryL,G1H2(55),23,nMT,G2H2(30),n2h2(20))
  call Hloop_QV_A(ntryL,G1H8(8),wf4(:,3),G1H2(56),m3h4x2(:,7),heltab2x8(:,:,56))
  call Hloop_Q_A(ntryL,G1H2(56),23,nMT,G2H2(31),n2h2(21))
call HGT_OLR(G1H8(9),1,1,8)
call HGT_invQ_OLR(G1H8(9),2,5,8)
  call Hloop_SA_Q(ntryL,G1H8(9),ex4(:),G1H4(4),ngH,m3h2x4(:,50),heltab2x8(:,:,57))
  call Hloop_QV_A(ntryL,G1H8(13),wf4(:,3),G1H2(60),m3h4x2(:,8),heltab2x8(:,:,58))
  call Hloop_Q_A(ntryL,G1H2(60),23,nMT,G2H2(32),n2h2(22))
  call Hloop_QV_A(ntryL,G1H8(14),wf4(:,3),G1H2(61),m3h4x2(:,9),heltab2x8(:,:,59))
  call Hloop_Q_A(ntryL,G1H2(61),23,nMT,G2H2(33),n2h2(23))
  call Hloop_QV_A(ntryL,G1H8(20),wf4(:,3),G1H2(62),m3h4x2(:,10),heltab2x8(:,:,60))
  call Hloop_Q_A(ntryL,G1H2(62),23,nMB,G2H2(34),n2h2(24))
call HGT_OLR(G1H8(18),1,1,8)
call HGT_invQ_OLR(G1H8(18),2,5,8)
  call Hloop_SA_Q(ntryL,G1H8(18),ex4(:),G1H4(5),ngPtb,m3h2x4(:,51),heltab2x8(:,:,61))
  call Hloop_QV_A(ntryL,G1H8(11),wf4(:,3),G1H2(66),m3h4x2(:,11),heltab2x8(:,:,62))
  call Hloop_Q_A(ntryL,G1H2(66),23,nMB,G2H2(35),n2h2(25))
  call Hloop_QV_A(ntryL,G1H8(17),wf4(:,3),G1H2(67),m3h4x2(:,12),heltab2x8(:,:,63))
  call Hloop_Q_A(ntryL,G1H2(67),23,nMB,G2H2(36),n2h2(26))
  call Hloop_QV_A(ntryL,G1H8(12),wf4(:,3),G1H2(68),m3h4x2(:,13),heltab2x8(:,:,64))
  call Hloop_Q_A(ntryL,G1H2(68),23,nMB,G2H2(37),n2h2(27))
call HGT_raise_alpha_OLR(G1H8(6),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(6),2,5,8)
  call Hloop_WA_Q(ntryL,G1H8(6),ex4(:),G1H4(1),m3h2x4(:,52),heltab2x8(:,:,65))
  call Hloop_QV_A(ntryL,G1H8(29),wf4(:,3),G1H2(72),m3h4x2(:,14),heltab2x8(:,:,66))
  call Hloop_Q_A(ntryL,G1H2(72),23,nMB,G2H2(38),n2h2(28))
  call Hloop_QV_A(ntryL,G1H8(30),wf4(:,3),G1H2(1),m3h4x2(:,15),heltab2x8(:,:,67))
  call Hloop_Q_A(ntryL,G1H2(1),23,nMB,G2H2(39),n2h2(29))
  call Hloop_QV_A(ntryL,G1H8(16),wf4(:,4),G1H2(2),m3h4x2(:,16),heltab2x8(:,:,68))
  call Hloop_Q_A(ntryL,G1H2(2),29,0,G2H2(40),n2h2(30))
call HGT_raise_alpha_OLR(G1H8(1),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(1),2,5,8)
  call Hloop_WA_Q(ntryL,G1H8(1),ex2(:),G1H4(2),m3h2x4(:,53),heltab2x8(:,:,69))
  call Hloop_QV_A(ntryL,G1H8(2),wf4(:,4),G1H2(6),m3h4x2(:,17),heltab2x8(:,:,70))
  call Hloop_Q_A(ntryL,G1H2(6),29,0,G2H2(41),n2h2(31))
  call Hloop_QV_A(ntryL,G1H8(21),wf4(:,4),G1H2(7),m3h4x2(:,18),heltab2x8(:,:,71))
  call Hloop_Q_A(ntryL,G1H2(7),29,0,G2H2(42),n2h2(32))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(32),[G1H2(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(10),[G1H2(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(14),[G1H2(23),G1H2(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(36),[G1H2(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(35),[G1H2(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(37),[G1H2(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(29),[G1H2(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(26),[G1H2(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(34),[G1H2(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(30),[G1H2(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(31),[G1H2(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(46),[G1H2(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(15),[G1H2(59),G1H2(41)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(65),[G1H2(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(71),[G1H2(53)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(64),[G1H2(58)])
  call Hloop_VA_Q(ntryL,G1H2(32),ex4(:),G1H1(1),m3h2x1(:,41),heltab2x2(:,:,41))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(1),n2h1(37))
  call Hloop_VA_Q(ntryL,G1H2(10),ex4(:),G1H1(1),m3h2x1(:,42),heltab2x2(:,:,42))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(2),n2h1(38))
  call Hotf_4pt_reduction(G2H2(14),RedSet_4(19),mass4set(:,5),  & 
G1H2(8),G1H2(12),G1H2(13),G1H2(14),G1H2(18),2)
  call HG1shiftOLR(G1H2(12),8,2)
  call Hloop_VA_Q(ntryL,G1H2(36),ex4(:),G1H1(1),m3h2x1(:,43),heltab2x2(:,:,43))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(3),n2h1(39))
  call Hloop_VA_Q(ntryL,G1H2(35),ex4(:),G1H1(1),m3h2x1(:,44),heltab2x2(:,:,44))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(4),n2h1(40))
  call Hloop_ZA_Q(ntryL,G1H2(37),ex4(:),G1H1(1),ngZu,m3h2x1(:,45),heltab2x2(:,:,45))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(5),n2h1(41))
  call Hloop_ZA_Q(ntryL,G1H2(16),ex4(:),G1H1(1),ngZu,m3h2x1(:,46),heltab2x2(:,:,46))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(8),n2h1(42))
  call Hloop_ZA_Q(ntryL,G1H2(29),ex4(:),G1H1(1),ngZu,m3h2x1(:,47),heltab2x2(:,:,47))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(11),n2h1(43))
  call Hloop_VA_Q(ntryL,G1H2(26),ex4(:),G1H1(1),m3h2x1(:,48),heltab2x2(:,:,48))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(14),n2h1(44))
  call Hloop_VA_Q(ntryL,G1H2(34),ex4(:),G1H1(1),m3h2x1(:,49),heltab2x2(:,:,49))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(17),n2h1(45))
  call Hloop_ZA_Q(ntryL,G1H2(30),ex4(:),G1H1(1),ngZu,m3h2x1(:,50),heltab2x2(:,:,50))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(20),n2h1(46))
  call Hloop_ZA_Q(ntryL,G1H2(28),ex4(:),G1H1(1),ngZu,m3h2x1(:,51),heltab2x2(:,:,51))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(23),n2h1(47))
  call Hloop_VA_Q(ntryL,G1H2(31),ex4(:),G1H1(1),m3h2x1(:,52),heltab2x2(:,:,52))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(26),n2h1(48))
  call Hloop_VA_Q(ntryL,G1H2(39),ex2(:),G1H1(1),m3h2x1(:,53),heltab2x2(:,:,53))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(29),n2h1(49))
  call Hloop_VA_Q(ntryL,G1H2(46),ex2(:),G1H1(1),m3h2x1(:,54),heltab2x2(:,:,54))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(32),n2h1(50))
  call Hotf_4pt_reduction(G2H2(15),RedSet_4(28),mass4set(:,6),  & 
G1H2(19),G1H2(20),G1H2(24),G1H2(25),G1H2(50),2)
  call HG1shiftOLR(G1H2(20),2,2)
  call Hloop_VA_Q(ntryL,G1H2(45),ex2(:),G1H1(1),m3h2x1(:,55),heltab2x2(:,:,55))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(35),n2h1(51))
  call Hloop_VA_Q(ntryL,G1H2(65),ex2(:),G1H1(1),m3h2x1(:,56),heltab2x2(:,:,56))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(38),n2h1(52))
  call Hloop_ZA_Q(ntryL,G1H2(51),ex2(:),G1H1(1),ngZu,m3h2x1(:,57),heltab2x2(:,:,57))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(41),n2h1(53))
  call Hloop_ZA_Q(ntryL,G1H2(52),ex2(:),G1H1(1),ngZu,m3h2x1(:,58),heltab2x2(:,:,58))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(42),n2h1(54))
  call Hloop_ZA_Q(ntryL,G1H2(71),ex2(:),G1H1(1),ngZu,m3h2x1(:,59),heltab2x2(:,:,59))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(43),n2h1(55))
  call Hloop_VA_Q(ntryL,G1H2(57),ex2(:),G1H1(1),m3h2x1(:,60),heltab2x2(:,:,60))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(44),n2h1(56))
  call Hloop_VA_Q(ntryL,G1H2(64),ex2(:),G1H1(1),m3h2x1(:,61),heltab2x2(:,:,61))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(45),n2h1(57))
  call Hloop_VA_Q(ntryL,G1H2(63),ex2(:),G1H1(1),m3h2x1(:,62),heltab2x2(:,:,62))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(46),n2h1(58))
  call Hloop_ZA_Q(ntryL,G1H2(69),ex2(:),G1H1(1),ngZu,m3h2x1(:,63),heltab2x2(:,:,63))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(47),n2h1(59))
  call Hloop_ZA_Q(ntryL,G1H2(70),ex2(:),G1H1(1),ngZu,m3h2x1(:,64),heltab2x2(:,:,64))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(48),n2h1(60))
  call Hotf_4pt_reduction(G2H2(1),RedSet_4(7),mass4set(:,7),  & 
G1H2(54),G1H2(55),G1H2(56),G1H2(60),G1H2(61),2)
  call HG1shiftOLR(G1H2(55),4,2)
  call Hotf_4pt_reduction(G2H2(2),RedSet_4(7),mass4set(:,8),  & 
G1H2(62),G1H2(66),G1H2(67),G1H2(68),G1H2(72),2)
  call HG1shiftOLR(G1H2(66),4,2)
  call Hotf_4pt_reduction(G2H2(3),RedSet_4(7),mass4set(:,9),  & 
G1H2(1),G1H2(2),G1H2(6),G1H2(7),G1H2(3),2)
  call HG1shiftOLR(G1H2(2),4,2)
  call Hotf_4pt_reduction(G2H2(4),RedSet_4(7),mass4set(:,10),  & 
G1H2(4),G1H2(23),G1H2(5),G1H2(9),G1H2(11),2)
  call HG1shiftOLR(G1H2(23),4,2)
  call Hotf_4pt_reduction(G2H2(5),RedSet_4(7),mass4set(:,8),  & 
G1H2(15),G1H2(17),G1H2(21),G1H2(22),G1H2(27),2)
  call HG1shiftOLR(G1H2(17),4,2)
  call Hotf_4pt_reduction(G2H2(6),RedSet_4(7),mass4set(:,9),  & 
G1H2(33),G1H2(40),G1H2(59),G1H2(41),G1H2(47),2)
  call HG1shiftOLR(G1H2(40),4,2)
  call Hotf_4pt_reduction(G2H2(7),RedSet_4(2),mass4set(:,7),  & 
G1H2(53),G1H2(58),G1H2(32),G1H2(10),G1H2(36),2)
  call HG1shiftOLR(G1H2(58),8,2)
  call Hotf_4pt_reduction(G2H2(8),RedSet_4(2),mass4set(:,8),  & 
G1H2(35),G1H2(37),G1H2(16),G1H2(29),G1H2(26),2)
  call HG1shiftOLR(G1H2(37),8,2)
  call Hotf_4pt_reduction(G2H2(9),RedSet_4(2),mass4set(:,9),  & 
G1H2(34),G1H2(30),G1H2(28),G1H2(31),G1H2(39),2)
  call HG1shiftOLR(G1H2(30),8,2)
  call Hotf_4pt_reduction(G2H2(10),RedSet_4(2),mass4set(:,10),  & 
G1H2(46),G1H2(45),G1H2(65),G1H2(51),G1H2(52),2)
  call HG1shiftOLR(G1H2(45),8,2)
  call Hotf_4pt_reduction(G2H2(11),RedSet_4(2),mass4set(:,8),  & 
G1H2(71),G1H2(57),G1H2(64),G1H2(63),G1H2(69),2)
  call HG1shiftOLR(G1H2(57),8,2)
  call Hotf_4pt_reduction(G2H2(12),RedSet_4(2),mass4set(:,9),  & 
G1H2(70),G1H2(73),G1H2(74),G1H2(75),G1H2(76),2)
  call HG1shiftOLR(G1H2(73),8,2)
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(13),ex4(:),G2tensor(49),ngZu,m3h2x1(:,65),heltab2x2(:,:,65))
  call Hotf_4pt_reduction(G2H4(4),RedSet_4(12),mass4set(:,6),  & 
G1H4(3),G1H4(6),G1H4(7),G1H4(8),G1H4(9),4)
  call HG1shiftOLR(G1H4(6),12,4)
  call Hotf_4pt_reduction(G2H4(11),RedSet_4(12),mass4set(:,6),  & 
G1H4(10),G1H4(11),G1H4(12),G1H4(13),G1H4(14),4)
  call HG1shiftOLR(G1H4(11),12,4)
  call Hotf_4pt_reduction(G2H4(1),RedSet_4(12),mass4set(:,11),  & 
G1H4(15),G1H4(16),G1H4(17),G1H4(18),G1H4(19),4)
  call HG1shiftOLR(G1H4(16),12,4)
  call Hotf_4pt_reduction(G2H4(2),RedSet_4(12),mass4set(:,12),  & 
G1H4(20),G1H4(21),G1H4(22),G1H4(23),G1H4(24),4)
  call HG1shiftOLR(G1H4(21),12,4)
  call Hotf_4pt_reduction(G2H4(3),RedSet_4(4),mass4set(:,6),  & 
G1H4(26),G1H4(27),G1H4(28),G1H4(29),G1H4(30),4)
  call HG1shiftOLR(G1H4(27),12,4)
  call Hotf_4pt_reduction(G2H4(5),RedSet_4(4),mass4set(:,6),  & 
G1H4(31),G1H4(32),G1H4(33),G1H4(34),G1H4(35),4)
  call HG1shiftOLR(G1H4(32),12,4)
  call Hotf_4pt_reduction(G2H4(6),RedSet_4(4),mass4set(:,11),  & 
G1H4(36),G1H4(37),G1H4(38),G1H4(39),G1H4(40),4)
  call HG1shiftOLR(G1H4(37),12,4)
  call Hotf_4pt_reduction(G2H4(7),RedSet_4(4),mass4set(:,12),  & 
G1H4(41),G1H4(42),G1H4(43),G1H4(44),G1H4(45),4)
  call HG1shiftOLR(G1H4(42),12,4)
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(16),ex4(:),G2tensor(50),m3h2x1(:,66),heltab2x2(:,:,66))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(17),ex4(:),G2tensor(51),m3h2x1(:,67),heltab2x2(:,:,67))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(18),ex4(:),G2tensor(52),ngZu,m3h2x1(:,68),heltab2x2(:,:,68))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(19),ex3(:),G2tensor(53),m3h2x1(:,69),heltab2x2(:,:,69))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(20),ex3(:),G2tensor(54),m3h2x1(:,70),heltab2x2(:,:,70))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(21),ex3(:),G2tensor(55),ngZu,m3h2x1(:,71),heltab2x2(:,:,71))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(22),ex4(:),G2tensor(56),m3h2x1(:,72),heltab2x2(:,:,72))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(23),ex4(:),G2tensor(57),m3h2x1(:,73),heltab2x2(:,:,73))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(24),ex4(:),G2tensor(58),ngZu,m3h2x1(:,74),heltab2x2(:,:,74))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(25),ex3(:),G2tensor(59),m3h2x1(:,75),heltab2x2(:,:,75))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(26),ex3(:),G2tensor(60),m3h2x1(:,76),heltab2x2(:,:,76))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(27),ex3(:),G2tensor(61),ngZu,m3h2x1(:,77),heltab2x2(:,:,77))
  call Hloop_VQ_A(ntryL,G1H2(38),ex3(:),G1H1(1),m3h2x1(:,78),heltab2x2(:,:,78))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(62),n2h1(61))
  call Hloop_ZQ_A(ntryL,G1H2(42),ex3(:),G1H1(1),ngZu,m3h2x1(:,79),heltab2x2(:,:,79))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(63),n2h1(62))
  call Hloop_VQ_A(ntryL,G1H2(43),ex3(:),G1H1(1),m3h2x1(:,80),heltab2x2(:,:,80))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(64),n2h1(63))
  call Hloop_VQ_A(ntryL,G1H2(44),ex3(:),G1H1(1),m3h2x1(:,81),heltab2x2(:,:,81))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(65),n2h1(64))
  call Hloop_VQ_A(ntryL,G1H2(48),ex3(:),G1H1(1),m3h2x1(:,82),heltab2x2(:,:,82))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(66),n2h1(65))
  call Hloop_ZQ_A(ntryL,G1H2(49),ex3(:),G1H1(1),ngZu,m3h2x1(:,83),heltab2x2(:,:,83))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(67),n2h1(66))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(28),ex4(:),G2tensor(68),ngX,m3h2x1(:,84),heltab2x2(:,:,84))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(30),ex4(:),G2tensor(69),ngX,m3h2x1(:,85),heltab2x2(:,:,85))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(31),ex4(:),G2tensor(70),ngH,m3h2x1(:,86),heltab2x2(:,:,86))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(33),ex4(:),G2tensor(71),ngH,m3h2x1(:,87),heltab2x2(:,:,87))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(34),ex4(:),G2tensor(72),ngPtb,m3h2x1(:,88),heltab2x2(:,:,88))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(36),ex4(:),G2tensor(73),ngPtb,m3h2x1(:,89),heltab2x2(:,:,89))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(37),ex4(:),G2tensor(74),m3h2x1(:,90),heltab2x2(:,:,90))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(39),ex4(:),G2tensor(75),m3h2x1(:,91),heltab2x2(:,:,91))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(40),ex2(:),G2tensor(76),m3h2x1(:,92),heltab2x2(:,:,92))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(42),ex2(:),G2tensor(77),m3h2x1(:,93),heltab2x2(:,:,93))
  call Hloop_VA_Q(ntryL,G1H2(8),ex4(:),G1H1(1),m3h2x1(:,94),heltab2x2(:,:,94))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(78),n2h1(67))
  call Hloop_VA_Q(ntryL,G1H2(12),ex4(:),G1H1(1),m3h2x1(:,95),heltab2x2(:,:,95))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(79),n2h1(68))
  call Hloop_VA_Q(ntryL,G1H2(18),ex4(:),G1H1(1),m3h2x1(:,96),heltab2x2(:,:,96))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(80),n2h1(69))
  call Hloop_VA_Q(ntryL,G1H2(19),ex2(:),G1H1(1),m3h2x1(:,97),heltab2x2(:,:,97))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(81),n2h1(70))
  call Hloop_VA_Q(ntryL,G1H2(20),ex2(:),G1H1(1),m3h2x1(:,98),heltab2x2(:,:,98))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(82),n2h1(71))
  call Hloop_VA_Q(ntryL,G1H2(50),ex2(:),G1H1(1),m3h2x1(:,99),heltab2x2(:,:,99))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(83),n2h1(72))
  call Hloop_SQ_A(ntryL,G1H2(54),ex3(:),G1H1(1),ngH,m3h2x1(:,100),heltab2x2(:,:,100))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(84),n2h1(73))
  call Hloop_SQ_A(ntryL,G1H2(55),ex3(:),G1H1(1),ngH,m3h2x1(:,101),heltab2x2(:,:,101))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(85),n2h1(74))
  call Hloop_SQ_A(ntryL,G1H2(61),ex3(:),G1H1(1),ngH,m3h2x1(:,102),heltab2x2(:,:,102))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(86),n2h1(75))
  call Hloop_SQ_A(ntryL,G1H2(62),ex3(:),G1H1(1),ngX,m3h2x1(:,103),heltab2x2(:,:,103))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(87),n2h1(76))
  call Hloop_SQ_A(ntryL,G1H2(66),ex3(:),G1H1(1),ngX,m3h2x1(:,104),heltab2x2(:,:,104))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(88),n2h1(77))
  call Hloop_SQ_A(ntryL,G1H2(72),ex3(:),G1H1(1),ngX,m3h2x1(:,105),heltab2x2(:,:,105))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(89),n2h1(78))
  call Hloop_SQ_A(ntryL,G1H2(1),ex3(:),G1H1(1),ngPbt,m3h2x1(:,106),heltab2x2(:,:,106))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(90),n2h1(79))
  call Hloop_SQ_A(ntryL,G1H2(2),ex3(:),G1H1(1),ngPbt,m3h2x1(:,107),heltab2x2(:,:,107))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(91),n2h1(80))
  call Hloop_SQ_A(ntryL,G1H2(3),ex3(:),G1H1(1),ngPbt,m3h2x1(:,108),heltab2x2(:,:,108))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(92),n2h1(81))
  call Hloop_VQ_A(ntryL,G1H2(4),ex3(:),G1H1(1),m3h2x1(:,109),heltab2x2(:,:,109))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(93),n2h1(82))
  call Hloop_VQ_A(ntryL,G1H2(23),ex3(:),G1H1(1),m3h2x1(:,110),heltab2x2(:,:,110))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(94),n2h1(83))
  call Hloop_VQ_A(ntryL,G1H2(11),ex3(:),G1H1(1),m3h2x1(:,111),heltab2x2(:,:,111))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(95),n2h1(84))
  call Hloop_ZQ_A(ntryL,G1H2(15),ex3(:),G1H1(1),ngZu,m3h2x1(:,112),heltab2x2(:,:,112))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(96),n2h1(85))
  call Hloop_ZQ_A(ntryL,G1H2(17),ex3(:),G1H1(1),ngZu,m3h2x1(:,113),heltab2x2(:,:,113))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(97),n2h1(86))
  call Hloop_ZQ_A(ntryL,G1H2(27),ex3(:),G1H1(1),ngZu,m3h2x1(:,114),heltab2x2(:,:,114))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(98),n2h1(87))
  call Hloop_WQ_A(ntryL,G1H2(33),ex3(:),G1H1(1),m3h2x1(:,115),heltab2x2(:,:,115))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(99),n2h1(88))
  call Hloop_WQ_A(ntryL,G1H2(40),ex3(:),G1H1(1),m3h2x1(:,116),heltab2x2(:,:,116))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(100),n2h1(89))
  call Hloop_WQ_A(ntryL,G1H2(47),ex3(:),G1H1(1),m3h2x1(:,117),heltab2x2(:,:,117))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(101),n2h1(90))
  call Hloop_SA_Q(ntryL,G1H2(53),ex4(:),G1H1(1),ngH,m3h2x1(:,118),heltab2x2(:,:,118))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(102),n2h1(91))
  call Hloop_SA_Q(ntryL,G1H2(58),ex4(:),G1H1(1),ngH,m3h2x1(:,119),heltab2x2(:,:,119))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(103),n2h1(92))
  call Hloop_SA_Q(ntryL,G1H2(36),ex4(:),G1H1(1),ngH,m3h2x1(:,120),heltab2x2(:,:,120))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(104),n2h1(93))
  call Hloop_SA_Q(ntryL,G1H2(35),ex4(:),G1H1(1),ngX,m3h2x1(:,121),heltab2x2(:,:,121))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(105),n2h1(94))
  call Hloop_SA_Q(ntryL,G1H2(37),ex4(:),G1H1(1),ngX,m3h2x1(:,122),heltab2x2(:,:,122))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(106),n2h1(95))
  call Hloop_SA_Q(ntryL,G1H2(26),ex4(:),G1H1(1),ngX,m3h2x1(:,123),heltab2x2(:,:,123))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(107),n2h1(96))
  call Hloop_SA_Q(ntryL,G1H2(34),ex4(:),G1H1(1),ngPtb,m3h2x1(:,124),heltab2x2(:,:,124))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(108),n2h1(97))
  call Hloop_SA_Q(ntryL,G1H2(30),ex4(:),G1H1(1),ngPtb,m3h2x1(:,125),heltab2x2(:,:,125))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(109),n2h1(98))
  call Hloop_SA_Q(ntryL,G1H2(39),ex4(:),G1H1(1),ngPtb,m3h2x1(:,126),heltab2x2(:,:,126))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(110),n2h1(99))
  call Hloop_VA_Q(ntryL,G1H2(46),ex4(:),G1H1(1),m3h2x1(:,127),heltab2x2(:,:,127))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(111),n2h1(100))
  call Hloop_VA_Q(ntryL,G1H2(45),ex4(:),G1H1(1),m3h2x1(:,128),heltab2x2(:,:,128))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(112),n2h1(101))
  call Hloop_VA_Q(ntryL,G1H2(52),ex4(:),G1H1(1),m3h2x1(:,129),heltab2x2(:,:,129))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(113),n2h1(102))
  call Hloop_ZA_Q(ntryL,G1H2(71),ex4(:),G1H1(1),ngZu,m3h2x1(:,130),heltab2x2(:,:,130))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(114),n2h1(103))
  call Hloop_ZA_Q(ntryL,G1H2(57),ex4(:),G1H1(1),ngZu,m3h2x1(:,131),heltab2x2(:,:,131))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(115),n2h1(104))
  call Hloop_ZA_Q(ntryL,G1H2(69),ex4(:),G1H1(1),ngZu,m3h2x1(:,132),heltab2x2(:,:,132))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(116),n2h1(105))
  call Hloop_WA_Q(ntryL,G1H2(70),ex4(:),G1H1(1),m3h2x1(:,133),heltab2x2(:,:,133))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(117),n2h1(106))
  call Hloop_WA_Q(ntryL,G1H2(73),ex4(:),G1H1(1),m3h2x1(:,134),heltab2x2(:,:,134))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(118),n2h1(107))
  call Hloop_WA_Q(ntryL,G1H2(76),ex4(:),G1H1(1),m3h2x1(:,135),heltab2x2(:,:,135))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(119),n2h1(108))
  call Hloop_AV_Q(ntryL,G1H4(3),wf4(:,4),G1H1(1),m3h4x1(:,1),heltab2x4(:,:,53))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(120),n2h1(109))
  call Hloop_AV_Q(ntryL,G1H4(6),wf4(:,4),G1H1(1),m3h4x1(:,2),heltab2x4(:,:,54))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,0,G2tensor(121),n2h1(110))
  call Hloop_AV_Q(ntryL,G1H4(9),wf4(:,4),G1H1(1),m3h4x1(:,3),heltab2x4(:,:,55))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(122),n2h1(111))
  call Hloop_AZ_Q(ntryL,G1H4(10),wf4(:,5),G1H1(1),ngZu,m3h4x1(:,4),heltab2x4(:,:,56))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(123),n2h1(112))
  call Hloop_AZ_Q(ntryL,G1H4(11),wf4(:,5),G1H1(1),ngZu,m3h4x1(:,5),heltab2x4(:,:,57))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,0,G2tensor(124),n2h1(113))
  call Hloop_AZ_Q(ntryL,G1H4(14),wf4(:,5),G1H1(1),ngZu,m3h4x1(:,6),heltab2x4(:,:,58))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(125),n2h1(114))
  call Hloop_AV_Q(ntryL,G1H4(15),wf4(:,4),G1H1(1),m3h4x1(:,7),heltab2x4(:,:,59))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(126),n2h1(115))
  call Hloop_AV_Q(ntryL,G1H4(16),wf4(:,4),G1H1(1),m3h4x1(:,8),heltab2x4(:,:,60))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,0,G2tensor(127),n2h1(116))
  call Hloop_AV_Q(ntryL,G1H4(19),wf4(:,4),G1H1(1),m3h4x1(:,9),heltab2x4(:,:,61))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(128),n2h1(117))
  call Hloop_AV_Q(ntryL,G1H4(20),wf4(:,4),G1H1(1),m3h4x1(:,10),heltab2x4(:,:,62))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(129),n2h1(118))
  call Hloop_AV_Q(ntryL,G1H4(21),wf4(:,4),G1H1(1),m3h4x1(:,11),heltab2x4(:,:,63))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,0,G2tensor(130),n2h1(119))
  call Hloop_AV_Q(ntryL,G1H4(24),wf4(:,4),G1H1(1),m3h4x1(:,12),heltab2x4(:,:,64))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(131),n2h1(120))
  call Hloop_QV_A(ntryL,G1H4(26),wf4(:,4),G1H1(1),m3h4x1(:,13),heltab2x4(:,:,65))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(132),n2h1(121))
  call Hloop_QV_A(ntryL,G1H4(27),wf4(:,4),G1H1(1),m3h4x1(:,14),heltab2x4(:,:,66))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(133),n2h1(122))
  call Hloop_QV_A(ntryL,G1H4(30),wf4(:,4),G1H1(1),m3h4x1(:,15),heltab2x4(:,:,67))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(134),n2h1(123))
  call Hloop_QZ_A(ntryL,G1H4(31),wf4(:,5),G1H1(1),ngZu,m3h4x1(:,16),heltab2x4(:,:,68))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(135),n2h1(124))
  call Hloop_QZ_A(ntryL,G1H4(32),wf4(:,5),G1H1(1),ngZu,m3h4x1(:,17),heltab2x4(:,:,69))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(136),n2h1(125))
  call Hloop_QZ_A(ntryL,G1H4(35),wf4(:,5),G1H1(1),ngZu,m3h4x1(:,18),heltab2x4(:,:,70))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(137),n2h1(126))
  call Hloop_QV_A(ntryL,G1H4(36),wf4(:,4),G1H1(1),m3h4x1(:,19),heltab2x4(:,:,71))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(138),n2h1(127))
  call Hloop_QV_A(ntryL,G1H4(37),wf4(:,4),G1H1(1),m3h4x1(:,20),heltab2x4(:,:,72))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(139),n2h1(128))
  call Hloop_QV_A(ntryL,G1H4(40),wf4(:,4),G1H1(1),m3h4x1(:,21),heltab2x4(:,:,73))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(140),n2h1(129))
  call Hloop_QV_A(ntryL,G1H4(41),wf4(:,4),G1H1(1),m3h4x1(:,22),heltab2x4(:,:,74))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(141),n2h1(130))
  call Hloop_QV_A(ntryL,G1H4(42),wf4(:,4),G1H1(1),m3h4x1(:,23),heltab2x4(:,:,75))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(142),n2h1(131))
  call Hloop_QV_A(ntryL,G1H4(45),wf4(:,4),G1H1(1),m3h4x1(:,24),heltab2x4(:,:,76))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(143),n2h1(132))
  call ol_merge_tensors(G2tensor(6),[G1tensor(26)])
  call ol_merge_tensors(G2tensor(13),[G2tensor(7),G1tensor(42),G1tensor(30)])
  call ol_merge_tensors(G2tensor(9),[G1tensor(32)])
  call ol_merge_tensors(G2tensor(10),[G1tensor(36)])
  call ol_merge_tensors(G2tensor(12),[G1tensor(38)])
  call ol_merge_tensors(G2tensor(15),[G1tensor(44)])
  call ol_merge_tensors(G2tensor(19),[G2tensor(16),G1tensor(54),G1tensor(48)])
  call ol_merge_tensors(G2tensor(18),[G1tensor(50)])
  call ol_merge_tensors(G2tensor(21),[G1tensor(56)])
  call ol_merge_tensors(G2tensor(22),[G1tensor(60)])
  call ol_merge_tensors(G2tensor(56),[G2tensor(24),G1tensor(62)])
  call ol_merge_tensors(G2tensor(31),[G2tensor(25),G1tensor(78),G1tensor(66)])
  call ol_merge_tensors(G2tensor(57),[G2tensor(27),G1tensor(68)])
  call ol_merge_tensors(G2tensor(28),[G1tensor(72)])
  call ol_merge_tensors(G2tensor(58),[G2tensor(30),G1tensor(74)])
  call ol_merge_tensors(G2tensor(59),[G2tensor(33),G1tensor(80)])
  call ol_merge_tensors(G2tensor(40),[G2tensor(34),G1tensor(96),G1tensor(84)])
  call ol_merge_tensors(G2tensor(60),[G2tensor(36),G1tensor(86)])
  call ol_merge_tensors(G2tensor(37),[G1tensor(90)])
  call ol_merge_tensors(G2tensor(61),[G2tensor(39),G1tensor(92)])
  call ol_merge_tensors(G2tensor(64),[G1tensor(2)])
  call ol_merge_tensors(G1tensor(16),[G1tensor(4)])
  call ol_merge_tensors(G1tensor(12),[G1tensor(6)])
  call ol_merge_tensors(G2tensor(26),[G1tensor(57),G1tensor(8)])
  call ol_merge_tensors(G1tensor(22),[G1tensor(10)])
  call ol_merge_tensors(G2tensor(66),[G1tensor(14)])
  call ol_merge_tensors(G1tensor(24),[G1tensor(18)])
  call ol_merge_tensors(G2tensor(3),[G1tensor(33),G1tensor(20)])
  call ol_merge_tensors(G2tensor(1),[G1tensor(27)])
  call ol_merge_tensors(G2tensor(2),[G1tensor(34),G1tensor(28)])
  call ol_merge_tensors(G2tensor(78),[G1tensor(47),G1tensor(29)])
  call ol_merge_tensors(G2tensor(4),[G1tensor(59),G1tensor(35)])
  call ol_merge_tensors(G2tensor(5),[G1tensor(39)])
  call ol_merge_tensors(G2tensor(8),[G1tensor(40)])
  call ol_merge_tensors(G2tensor(11),[G1tensor(53),G1tensor(41)])
  call ol_merge_tensors(G2tensor(14),[G1tensor(45)])
  call ol_merge_tensors(G2tensor(17),[G1tensor(58),G1tensor(46)])
  call ol_merge_tensors(G2tensor(20),[G1tensor(51)])
  call ol_merge_tensors(G2tensor(23),[G1tensor(52)])
  call ol_merge_tensors(G2tensor(29),[G1tensor(63)])
  call ol_merge_tensors(G2tensor(32),[G1tensor(70),G1tensor(64)])
  call ol_merge_tensors(G2tensor(81),[G1tensor(83),G1tensor(65)])
  call ol_merge_tensors(G2tensor(35),[G1tensor(69)])
  call ol_merge_tensors(G2tensor(38),[G1tensor(89),G1tensor(71)])
  call ol_merge_tensors(G2tensor(41),[G1tensor(75)])
  call ol_merge_tensors(G2tensor(42),[G1tensor(76)])
  call ol_merge_tensors(G2tensor(43),[G1tensor(95),G1tensor(77)])
  call ol_merge_tensors(G2tensor(44),[G1tensor(81)])
  call ol_merge_tensors(G2tensor(45),[G1tensor(88),G1tensor(82)])
  call ol_merge_tensors(G2tensor(46),[G1tensor(87)])
  call ol_merge_tensors(G2tensor(47),[G1tensor(93)])
  call ol_merge_tensors(G2tensor(48),[G1tensor(94)])
  call ol_merge_tensors(G2tensor(68),[G2tensor(49)])
  call ol_merge_tensors(G2tensor(74),[G2tensor(72)])
  call ol_merge_tensors(G2tensor(96),[G2tensor(87)])
  call ol_merge_tensors(G2tensor(99),[G2tensor(90)])
  call ol_merge_tensors(G2tensor(114),[G2tensor(105)])
  call ol_merge_tensors(G2tensor(117),[G2tensor(108)])
  call ol_merge_tensors(G2tensor(123),[G2tensor(120)])
  call ol_merge_tensors(G2tensor(135),[G2tensor(132)])
  call Hotf_4pt_reduction_last(G2tensor(6),RedSet_4(35),mass4set(:,13),  & 
G1tensor(1),G1tensor(7),G1tensor(13),G1tensor(19),G1tensor(25))
  call G_TensorShift(G1tensor(7),2)
  call Hotf_4pt_reduction_last(G2tensor(13),RedSet_4(20),mass4set(:,5),  & 
G1tensor(31),G1tensor(37),G1tensor(43),G1tensor(49),G1tensor(55))
  call G_TensorShift(G1tensor(37),10)
  call Hotf_4pt_reduction_last(G2tensor(9),RedSet_4(35),mass4set(:,14),  & 
G1tensor(61),G1tensor(67),G1tensor(73),G1tensor(79),G1tensor(85))
  call G_TensorShift(G1tensor(67),2)
  call Hotf_4pt_reduction_last(G2tensor(10),RedSet_4(20),mass4set(:,15),  & 
G1tensor(91),G1tensor(26),G1tensor(42),G1tensor(30),G1tensor(32))
  call G_TensorShift(G1tensor(26),10)
  call Hotf_4pt_reduction_last(G2tensor(12),RedSet_4(35),mass4set(:,16),  & 
G1tensor(36),G1tensor(38),G1tensor(44),G1tensor(54),G1tensor(48))
  call G_TensorShift(G1tensor(38),2)
  call Hotf_4pt_reduction_last(G2tensor(15),RedSet_4(36),mass4set(:,13),  & 
G1tensor(50),G1tensor(56),G1tensor(60),G1tensor(62),G1tensor(78))
  call G_TensorShift(G1tensor(56),1)
  call Hotf_4pt_reduction_last(G2tensor(19),RedSet_4(24),mass4set(:,5),  & 
G1tensor(66),G1tensor(68),G1tensor(72),G1tensor(74),G1tensor(80))
  call G_TensorShift(G1tensor(68),9)
  call Hotf_4pt_reduction_last(G2tensor(18),RedSet_4(36),mass4set(:,16),  & 
G1tensor(96),G1tensor(84),G1tensor(86),G1tensor(90),G1tensor(92))
  call G_TensorShift(G1tensor(84),1)
  call Hotf_4pt_reduction_last(G2tensor(21),RedSet_4(36),mass4set(:,14),  & 
G1tensor(2),G1tensor(4),G1tensor(6),G1tensor(57),G1tensor(8))
  call G_TensorShift(G1tensor(4),1)
  call Hotf_4pt_reduction_last(G2tensor(22),RedSet_4(24),mass4set(:,15),  & 
G1tensor(10),G1tensor(14),G1tensor(18),G1tensor(33),G1tensor(20))
  call G_TensorShift(G1tensor(14),9)
  call Hotf_4pt_reduction_last(G2tensor(56),RedSet_4(1),mass4set(:,17),  & 
G1tensor(27),G1tensor(34),G1tensor(28),G1tensor(47),G1tensor(29))
  call G_TensorShift(G1tensor(34),8)
  call Hotf_4pt_reduction_last(G2tensor(31),RedSet_4(29),mass4set(:,17),  & 
G1tensor(59),G1tensor(35),G1tensor(39),G1tensor(40),G1tensor(53))
  call G_TensorShift(G1tensor(35),10)
  call Hotf_4pt_reduction_last(G2tensor(57),RedSet_4(1),mass4set(:,18),  & 
G1tensor(41),G1tensor(45),G1tensor(58),G1tensor(46),G1tensor(51))
  call G_TensorShift(G1tensor(45),8)
  call Hotf_4pt_reduction_last(G2tensor(28),RedSet_4(29),mass4set(:,18),  & 
G1tensor(52),G1tensor(63),G1tensor(70),G1tensor(64),G1tensor(83))
  call G_TensorShift(G1tensor(63),10)
  call Hotf_4pt_reduction_last(G2tensor(58),RedSet_4(1),mass4set(:,19),  & 
G1tensor(65),G1tensor(69),G1tensor(89),G1tensor(71),G1tensor(75))
  call G_TensorShift(G1tensor(69),8)
  call Hotf_4pt_reduction_last(G2tensor(59),RedSet_4(6),mass4set(:,17),  & 
G1tensor(76),G1tensor(95),G1tensor(77),G1tensor(81),G1tensor(88))
  call G_TensorShift(G1tensor(95),4)
  call Hotf_4pt_reduction_last(G2tensor(40),RedSet_4(33),mass4set(:,17),  & 
G1tensor(82),G1tensor(87),G1tensor(93),G1tensor(94),G1tensor(97))
  call G_TensorShift(G1tensor(87),6)
  call Hotf_4pt_reduction_last(G2tensor(60),RedSet_4(6),mass4set(:,18),  & 
G1tensor(98),G1tensor(99),G1tensor(100),G1tensor(101),G1tensor(102))
  call G_TensorShift(G1tensor(99),4)
  call Hotf_4pt_reduction_last(G2tensor(37),RedSet_4(33),mass4set(:,18),  & 
G1tensor(103),G1tensor(104),G1tensor(105),G1tensor(106),G1tensor(107))
  call G_TensorShift(G1tensor(104),6)
  call Hotf_4pt_reduction_last(G2tensor(61),RedSet_4(6),mass4set(:,19),  & 
G1tensor(108),G1tensor(109),G1tensor(110),G1tensor(111),G1tensor(112))
  call G_TensorShift(G1tensor(109),4)
  call Hotf_4pt_reduction_last(G2tensor(64),RedSet_4(37),mass4set(:,20),  & 
G1tensor(113),G1tensor(114),G1tensor(115),G1tensor(116),G1tensor(117))
  call G_TensorShift(G1tensor(114),4)
  call Hotf_4pt_reduction_last(G2tensor(26),RedSet_4(22),mass4set(:,20),  & 
G1tensor(118),G1tensor(119),G1tensor(120),G1tensor(121),G1tensor(122))
  call G_TensorShift(G1tensor(119),8)
  call Hotf_4pt_reduction_last(G2tensor(66),RedSet_4(38),mass4set(:,20),  & 
G1tensor(123),G1tensor(124),G1tensor(125),G1tensor(126),G1tensor(127))
  call G_TensorShift(G1tensor(124),4)
  call Hotf_4pt_reduction_last(G2tensor(3),RedSet_4(17),mass4set(:,20),  & 
G1tensor(128),G1tensor(129),G1tensor(130),G1tensor(131),G1tensor(132))
  call G_TensorShift(G1tensor(129),8)
  call Hotf_4pt_reduction_last(G2tensor(1),RedSet_4(17),mass4set(:,21),  & 
G1tensor(133),G1tensor(134),G1tensor(135),G1tensor(136),G1tensor(137))
  call G_TensorShift(G1tensor(134),8)
  call Hotf_4pt_reduction_last(G2tensor(2),RedSet_4(18),mass4set(:,5),  & 
G1tensor(138),G1tensor(139),G1tensor(140),G1tensor(141),G1tensor(142))
  call G_TensorShift(G1tensor(139),8)
  call Hotf_4pt_reduction_last(G2tensor(78),RedSet_4(19),mass4set(:,5),  & 
G1tensor(143),G1tensor(144),G1tensor(145),G1tensor(146),G1tensor(147))
  call G_TensorShift(G1tensor(144),8)
  call Hotf_4pt_reduction_last(G2tensor(4),RedSet_4(19),mass4set(:,15),  & 
G1tensor(148),G1tensor(149),G1tensor(150),G1tensor(151),G1tensor(152))
  call G_TensorShift(G1tensor(149),8)
  call Hotf_4pt_reduction_last(G2tensor(5),RedSet_4(17),mass4set(:,22),  & 
G1tensor(153),G1tensor(154),G1tensor(155),G1tensor(156),G1tensor(157))
  call G_TensorShift(G1tensor(154),8)
  call Hotf_4pt_reduction_last(G2tensor(8),RedSet_4(18),mass4set(:,23),  & 
G1tensor(158),G1tensor(159),G1tensor(160),G1tensor(161),G1tensor(162))
  call G_TensorShift(G1tensor(159),8)
  call Hotf_4pt_reduction_last(G2tensor(11),RedSet_4(19),mass4set(:,23),  & 
G1tensor(163),G1tensor(164),G1tensor(165),G1tensor(166),G1tensor(167))
  call G_TensorShift(G1tensor(164),8)
  call Hotf_4pt_reduction_last(G2tensor(14),RedSet_4(22),mass4set(:,21),  & 
G1tensor(168),G1tensor(169),G1tensor(170),G1tensor(171),G1tensor(172))
  call G_TensorShift(G1tensor(169),8)
  call Hotf_4pt_reduction_last(G2tensor(17),RedSet_4(23),mass4set(:,5),  & 
G1tensor(173),G1tensor(174),G1tensor(175),G1tensor(176),G1tensor(177))
  call G_TensorShift(G1tensor(174),8)
  call Hotf_4pt_reduction_last(G2tensor(20),RedSet_4(22),mass4set(:,22),  & 
G1tensor(178),G1tensor(179),G1tensor(180),G1tensor(181),G1tensor(182))
  call G_TensorShift(G1tensor(179),8)
  call Hotf_4pt_reduction_last(G2tensor(23),RedSet_4(23),mass4set(:,23),  & 
G1tensor(183),G1tensor(184),G1tensor(185),G1tensor(186),G1tensor(187))
  call G_TensorShift(G1tensor(184),8)
  call Hotf_4pt_reduction_last(G2tensor(29),RedSet_4(26),mass4set(:,24),  & 
G1tensor(188),G1tensor(189),G1tensor(190),G1tensor(191),G1tensor(192))
  call G_TensorShift(G1tensor(189),2)
  call Hotf_4pt_reduction_last(G2tensor(32),RedSet_4(27),mass4set(:,24),  & 
G1tensor(193),G1tensor(194),G1tensor(195),G1tensor(196),G1tensor(197))
  call G_TensorShift(G1tensor(194),2)
  call Hotf_4pt_reduction_last(G2tensor(81),RedSet_4(28),mass4set(:,6),  & 
G1tensor(198),G1tensor(199),G1tensor(200),G1tensor(201),G1tensor(202))
  call G_TensorShift(G1tensor(199),2)
  call Hotf_4pt_reduction_last(G2tensor(35),RedSet_4(26),mass4set(:,25),  & 
G1tensor(203),G1tensor(204),G1tensor(205),G1tensor(206),G1tensor(207))
  call G_TensorShift(G1tensor(204),2)
  call Hotf_4pt_reduction_last(G2tensor(38),RedSet_4(28),mass4set(:,11),  & 
G1tensor(208),G1tensor(209),G1tensor(210),G1tensor(211),G1tensor(212))
  call G_TensorShift(G1tensor(209),2)
  call Hotf_4pt_reduction_last(G2tensor(41),RedSet_4(26),mass4set(:,26),  & 
G1tensor(213),G1tensor(214),G1tensor(215),G1tensor(216),G1tensor(217))
  call G_TensorShift(G1tensor(214),2)
  call Hotf_4pt_reduction_last(G2tensor(42),RedSet_4(27),mass4set(:,26),  & 
G1tensor(218),G1tensor(219),G1tensor(220),G1tensor(221),G1tensor(222))
  call G_TensorShift(G1tensor(219),2)
  call Hotf_4pt_reduction_last(G2tensor(43),RedSet_4(28),mass4set(:,27),  & 
G1tensor(223),G1tensor(224),G1tensor(225),G1tensor(226),G1tensor(227))
  call G_TensorShift(G1tensor(224),2)
  call Hotf_4pt_reduction_last(G2tensor(44),RedSet_4(31),mass4set(:,24),  & 
G1tensor(228),G1tensor(229),G1tensor(230),G1tensor(231),G1tensor(232))
  call G_TensorShift(G1tensor(229),2)
  call Hotf_4pt_reduction_last(G2tensor(45),RedSet_4(32),mass4set(:,24),  & 
G1tensor(233),G1tensor(234),G1tensor(235),G1tensor(236),G1tensor(237))
  call G_TensorShift(G1tensor(234),2)
  call Hotf_4pt_reduction_last(G2tensor(46),RedSet_4(31),mass4set(:,25),  & 
G1tensor(238),G1tensor(239),G1tensor(240),G1tensor(241),G1tensor(242))
  call G_TensorShift(G1tensor(239),2)
  call Hotf_4pt_reduction_last(G2tensor(47),RedSet_4(31),mass4set(:,26),  & 
G1tensor(243),G1tensor(244),G1tensor(245),G1tensor(246),G1tensor(247))
  call G_TensorShift(G1tensor(244),2)
  call Hotf_4pt_reduction_last(G2tensor(48),RedSet_4(32),mass4set(:,26),  & 
G1tensor(248),G1tensor(249),G1tensor(250),G1tensor(251),G1tensor(252))
  call G_TensorShift(G1tensor(249),2)
  call Hotf_4pt_reduction_last(G2tensor(68),RedSet_4(19),mass4set(:,1),  & 
G1tensor(253),G1tensor(254),G1tensor(255),G1tensor(256),G1tensor(257))
  call G_TensorShift(G1tensor(254),8)
  call Hotf_4pt_reduction_last(G2tensor(50),RedSet_4(10),mass4set(:,17),  & 
G1tensor(258),G1tensor(259),G1tensor(260),G1tensor(261),G1tensor(262))
  call G_TensorShift(G1tensor(259),8)
  call Hotf_4pt_reduction_last(G2tensor(51),RedSet_4(10),mass4set(:,18),  & 
G1tensor(263),G1tensor(264),G1tensor(265),G1tensor(266),G1tensor(267))
  call G_TensorShift(G1tensor(264),8)
  call Hotf_4pt_reduction_last(G2tensor(52),RedSet_4(10),mass4set(:,19),  & 
G1tensor(268),G1tensor(269),G1tensor(270),G1tensor(271),G1tensor(272))
  call G_TensorShift(G1tensor(269),8)
  call Hotf_4pt_reduction_last(G2tensor(53),RedSet_4(14),mass4set(:,17),  & 
G1tensor(273),G1tensor(274),G1tensor(275),G1tensor(276),G1tensor(277))
  call G_TensorShift(G1tensor(274),4)
  call Hotf_4pt_reduction_last(G2tensor(54),RedSet_4(14),mass4set(:,18),  & 
G1tensor(278),G1tensor(279),G1tensor(280),G1tensor(281),G1tensor(282))
  call G_TensorShift(G1tensor(279),4)
  call Hotf_4pt_reduction_last(G2tensor(55),RedSet_4(14),mass4set(:,19),  & 
G1tensor(283),G1tensor(284),G1tensor(285),G1tensor(286),G1tensor(287))
  call G_TensorShift(G1tensor(284),4)
  call Hotf_4pt_reduction_last(G2tensor(62),RedSet_4(37),mass4set(:,21),  & 
G1tensor(288),G1tensor(289),G1tensor(290),G1tensor(291),G1tensor(292))
  call G_TensorShift(G1tensor(289),4)
  call Hotf_4pt_reduction_last(G2tensor(63),RedSet_4(37),mass4set(:,22),  & 
G1tensor(293),G1tensor(294),G1tensor(295),G1tensor(296),G1tensor(297))
  call G_TensorShift(G1tensor(294),4)
  call Hotf_4pt_reduction_last(G2tensor(65),RedSet_4(38),mass4set(:,21),  & 
G1tensor(298),G1tensor(299),G1tensor(300),G1tensor(301),G1tensor(302))
  call G_TensorShift(G1tensor(299),4)
  call Hotf_4pt_reduction_last(G2tensor(67),RedSet_4(38),mass4set(:,22),  & 
G1tensor(303),G1tensor(304),G1tensor(305),G1tensor(306),G1tensor(307))
  call G_TensorShift(G1tensor(304),4)
  call Hotf_4pt_reduction_last(G2tensor(70),RedSet_4(19),mass4set(:,2),  & 
G1tensor(308),G1tensor(309),G1tensor(310),G1tensor(311),G1tensor(312))
  call G_TensorShift(G1tensor(309),8)
  call Hotf_4pt_reduction_last(G2tensor(74),RedSet_4(19),mass4set(:,3),  & 
G1tensor(313),G1tensor(314),G1tensor(315),G1tensor(316),G1tensor(317))
  call G_TensorShift(G1tensor(314),8)
  call Hotf_4pt_reduction_last(G2tensor(76),RedSet_4(28),mass4set(:,4),  & 
G1tensor(318),G1tensor(319),G1tensor(320),G1tensor(321),G1tensor(322))
  call G_TensorShift(G1tensor(319),2)
  call Hotf_4pt_reduction_last(G2tensor(84),RedSet_4(7),mass4set(:,7),  & 
G1tensor(323),G1tensor(324),G1tensor(325),G1tensor(326),G1tensor(327))
  call G_TensorShift(G1tensor(324),4)
  call Hotf_4pt_reduction_last(G2tensor(96),RedSet_4(7),mass4set(:,8),  & 
G1tensor(328),G1tensor(329),G1tensor(330),G1tensor(331),G1tensor(332))
  call G_TensorShift(G1tensor(329),4)
  call Hotf_4pt_reduction_last(G2tensor(99),RedSet_4(7),mass4set(:,9),  & 
G1tensor(333),G1tensor(334),G1tensor(335),G1tensor(336),G1tensor(337))
  call G_TensorShift(G1tensor(334),4)
  call Hotf_4pt_reduction_last(G2tensor(93),RedSet_4(7),mass4set(:,10),  & 
G1tensor(338),G1tensor(339),G1tensor(340),G1tensor(341),G1tensor(342))
  call G_TensorShift(G1tensor(339),4)
  call Hotf_4pt_reduction_last(G2tensor(102),RedSet_4(2),mass4set(:,7),  & 
G1tensor(343),G1tensor(344),G1tensor(345),G1tensor(346),G1tensor(347))
  call G_TensorShift(G1tensor(344),8)
  call Hotf_4pt_reduction_last(G2tensor(114),RedSet_4(2),mass4set(:,8),  & 
G1tensor(348),G1tensor(349),G1tensor(350),G1tensor(351),G1tensor(352))
  call G_TensorShift(G1tensor(349),8)
  call Hotf_4pt_reduction_last(G2tensor(117),RedSet_4(2),mass4set(:,9),  & 
G1tensor(353),G1tensor(354),G1tensor(355),G1tensor(356),G1tensor(357))
  call G_TensorShift(G1tensor(354),8)
  call Hotf_4pt_reduction_last(G2tensor(111),RedSet_4(2),mass4set(:,10),  & 
G1tensor(358),G1tensor(359),G1tensor(360),G1tensor(361),G1tensor(362))
  call G_TensorShift(G1tensor(359),8)
  call Hotf_4pt_reduction_last(G2tensor(123),RedSet_4(12),mass4set(:,6),  & 
G1tensor(363),G1tensor(364),G1tensor(365),G1tensor(366),G1tensor(367))
  call G_TensorShift(G1tensor(364),12)
  call Hotf_4pt_reduction_last(G2tensor(126),RedSet_4(12),mass4set(:,11),  & 
G1tensor(368),G1tensor(369),G1tensor(370),G1tensor(371),G1tensor(372))
  call G_TensorShift(G1tensor(369),12)
  call Hotf_4pt_reduction_last(G2tensor(129),RedSet_4(12),mass4set(:,12),  & 
G1tensor(373),G1tensor(374),G1tensor(375),G1tensor(376),G1tensor(377))
  call G_TensorShift(G1tensor(374),12)
  call Hotf_4pt_reduction_last(G2tensor(135),RedSet_4(4),mass4set(:,6),  & 
G1tensor(378),G1tensor(379),G1tensor(380),G1tensor(381),G1tensor(382))
  call G_TensorShift(G1tensor(379),12)
  call Hotf_4pt_reduction_last(G2tensor(138),RedSet_4(4),mass4set(:,11),  & 
G1tensor(383),G1tensor(384),G1tensor(385),G1tensor(386),G1tensor(387))
  call G_TensorShift(G1tensor(384),12)
  call Hotf_4pt_reduction_last(G2tensor(141),RedSet_4(4),mass4set(:,12),  & 
G1tensor(388),G1tensor(389),G1tensor(390),G1tensor(391),G1tensor(392))
  call G_TensorShift(G1tensor(389),12)
  call Hotf_4pt_reduction_last(G1tensor(1),RedSet_4(35),mass4set(:,13),  & 
G0tensor(1),G0tensor(2),G0tensor(3),G0tensor(4),G0tensor(5))
  call Hotf_4pt_reduction_last(G1tensor(31),RedSet_4(20),mass4set(:,5),  & 
G0tensor(6),G0tensor(7),G0tensor(8),G0tensor(9),G0tensor(10))
  call Hotf_4pt_reduction_last(G1tensor(61),RedSet_4(35),mass4set(:,14),  & 
G0tensor(11),G0tensor(12),G0tensor(13),G0tensor(14),G0tensor(15))
  call Hotf_4pt_reduction_last(G1tensor(91),RedSet_4(20),mass4set(:,15),  & 
G0tensor(16),G0tensor(17),G0tensor(18),G0tensor(19),G0tensor(20))
  call Hotf_4pt_reduction_last(G1tensor(36),RedSet_4(35),mass4set(:,16),  & 
G0tensor(21),G0tensor(22),G0tensor(23),G0tensor(24),G0tensor(25))
  call Hotf_4pt_reduction_last(G1tensor(50),RedSet_4(36),mass4set(:,13),  & 
G0tensor(26),G0tensor(27),G0tensor(28),G0tensor(29),G0tensor(30))
  call Hotf_4pt_reduction_last(G1tensor(66),RedSet_4(24),mass4set(:,5),  & 
G0tensor(31),G0tensor(32),G0tensor(33),G0tensor(34),G0tensor(35))
  call Hotf_4pt_reduction_last(G1tensor(96),RedSet_4(36),mass4set(:,16),  & 
G0tensor(36),G0tensor(37),G0tensor(38),G0tensor(39),G0tensor(40))
  call Hotf_4pt_reduction_last(G1tensor(2),RedSet_4(36),mass4set(:,14),  & 
G0tensor(41),G0tensor(42),G0tensor(43),G0tensor(44),G0tensor(45))
  call Hotf_4pt_reduction_last(G1tensor(10),RedSet_4(24),mass4set(:,15),  & 
G0tensor(46),G0tensor(47),G0tensor(48),G0tensor(49),G0tensor(50))
  call Hotf_4pt_reduction_last(G1tensor(27),RedSet_4(1),mass4set(:,17),  & 
G0tensor(51),G0tensor(52),G0tensor(53),G0tensor(54),G0tensor(55))
  call Hotf_4pt_reduction_last(G1tensor(59),RedSet_4(29),mass4set(:,17),  & 
G0tensor(56),G0tensor(57),G0tensor(58),G0tensor(59),G0tensor(60))
  call Hotf_4pt_reduction_last(G1tensor(41),RedSet_4(1),mass4set(:,18),  & 
G0tensor(61),G0tensor(62),G0tensor(63),G0tensor(64),G0tensor(65))
  call Hotf_4pt_reduction_last(G1tensor(52),RedSet_4(29),mass4set(:,18),  & 
G0tensor(66),G0tensor(67),G0tensor(68),G0tensor(69),G0tensor(70))
  call Hotf_4pt_reduction_last(G1tensor(65),RedSet_4(1),mass4set(:,19),  & 
G0tensor(71),G0tensor(72),G0tensor(73),G0tensor(74),G0tensor(75))
  call Hotf_4pt_reduction_last(G1tensor(76),RedSet_4(6),mass4set(:,17),  & 
G0tensor(76),G0tensor(77),G0tensor(78),G0tensor(79),G0tensor(80))
  call Hotf_4pt_reduction_last(G1tensor(82),RedSet_4(33),mass4set(:,17),  & 
G0tensor(81),G0tensor(82),G0tensor(83),G0tensor(84),G0tensor(85))
  call Hotf_4pt_reduction_last(G1tensor(98),RedSet_4(6),mass4set(:,18),  & 
G0tensor(86),G0tensor(87),G0tensor(88),G0tensor(89),G0tensor(90))
  call Hotf_4pt_reduction_last(G1tensor(103),RedSet_4(33),mass4set(:,18),  & 
G0tensor(91),G0tensor(92),G0tensor(93),G0tensor(94),G0tensor(95))
  call Hotf_4pt_reduction_last(G1tensor(108),RedSet_4(6),mass4set(:,19),  & 
G0tensor(96),G0tensor(97),G0tensor(98),G0tensor(99),G0tensor(100))
  call Hotf_4pt_reduction_last(G1tensor(113),RedSet_4(37),mass4set(:,20),  & 
G0tensor(101),G0tensor(102),G0tensor(103),G0tensor(104),G0tensor(105))
  call Hotf_4pt_reduction_last(G1tensor(3),RedSet_4(1),mass4set(:,28),  & 
G0tensor(106),G0tensor(107),G0tensor(108),G0tensor(109),G0tensor(110))
  call Hotf_4pt_reduction_last(G1tensor(16),RedSet_4(2),mass4set(:,29),  & 
G0tensor(111),G0tensor(112),G0tensor(113),G0tensor(114),G0tensor(115))
  call Hotf_4pt_reduction_last(G1tensor(5),RedSet_4(3),mass4set(:,29),  & 
G0tensor(116),G0tensor(117),G0tensor(118),G0tensor(119),G0tensor(120))
  call Hotf_4pt_reduction_last(G1tensor(12),RedSet_4(4),mass4set(:,30),  & 
G0tensor(121),G0tensor(122),G0tensor(123),G0tensor(124),G0tensor(125))
  call Hotf_4pt_reduction_last(G1tensor(118),RedSet_4(22),mass4set(:,20),  & 
G0tensor(126),G0tensor(127),G0tensor(128),G0tensor(129),G0tensor(130))
  call Hotf_4pt_reduction_last(G1tensor(9),RedSet_4(6),mass4set(:,28),  & 
G0tensor(131),G0tensor(132),G0tensor(133),G0tensor(134),G0tensor(135))
  call Hotf_4pt_reduction_last(G1tensor(22),RedSet_4(7),mass4set(:,29),  & 
G0tensor(136),G0tensor(137),G0tensor(138),G0tensor(139),G0tensor(140))
  call Hotf_4pt_reduction_last(G1tensor(11),RedSet_4(8),mass4set(:,29),  & 
G0tensor(141),G0tensor(142),G0tensor(143),G0tensor(144),G0tensor(145))
  call Hotf_4pt_reduction_last(G1tensor(123),RedSet_4(38),mass4set(:,20),  & 
G0tensor(146),G0tensor(147),G0tensor(148),G0tensor(149),G0tensor(150))
  call Hotf_4pt_reduction_last(G1tensor(15),RedSet_4(10),mass4set(:,28),  & 
G0tensor(151),G0tensor(152),G0tensor(153),G0tensor(154),G0tensor(155))
  call Hotf_4pt_reduction_last(G1tensor(17),RedSet_4(11),mass4set(:,29),  & 
G0tensor(156),G0tensor(157),G0tensor(158),G0tensor(159),G0tensor(160))
  call Hotf_4pt_reduction_last(G1tensor(24),RedSet_4(12),mass4set(:,30),  & 
G0tensor(161),G0tensor(162),G0tensor(163),G0tensor(164),G0tensor(165))
  call Hotf_4pt_reduction_last(G1tensor(128),RedSet_4(17),mass4set(:,20),  & 
G0tensor(166),G0tensor(167),G0tensor(168),G0tensor(169),G0tensor(170))
  call Hotf_4pt_reduction_last(G1tensor(21),RedSet_4(14),mass4set(:,28),  & 
G0tensor(171),G0tensor(172),G0tensor(173),G0tensor(174),G0tensor(175))
  call Hotf_4pt_reduction_last(G1tensor(23),RedSet_4(15),mass4set(:,29),  & 
G0tensor(176),G0tensor(177),G0tensor(178),G0tensor(179),G0tensor(180))
  call Hotf_4pt_reduction_last(G1tensor(133),RedSet_4(17),mass4set(:,21),  & 
G0tensor(181),G0tensor(182),G0tensor(183),G0tensor(184),G0tensor(185))
  call Hotf_4pt_reduction_last(G1tensor(138),RedSet_4(18),mass4set(:,5),  & 
G0tensor(186),G0tensor(187),G0tensor(188),G0tensor(189),G0tensor(190))
  call Hotf_4pt_reduction_last(G1tensor(143),RedSet_4(19),mass4set(:,5),  & 
G0tensor(191),G0tensor(192),G0tensor(193),G0tensor(194),G0tensor(195))
  call Hotf_4pt_reduction_last(G1tensor(148),RedSet_4(19),mass4set(:,15),  & 
G0tensor(196),G0tensor(197),G0tensor(198),G0tensor(199),G0tensor(200))
  call Hotf_4pt_reduction_last(G1tensor(153),RedSet_4(17),mass4set(:,22),  & 
G0tensor(201),G0tensor(202),G0tensor(203),G0tensor(204),G0tensor(205))
  call Hotf_4pt_reduction_last(G1tensor(158),RedSet_4(18),mass4set(:,23),  & 
G0tensor(206),G0tensor(207),G0tensor(208),G0tensor(209),G0tensor(210))
  call Hotf_4pt_reduction_last(G1tensor(163),RedSet_4(19),mass4set(:,23),  & 
G0tensor(211),G0tensor(212),G0tensor(213),G0tensor(214),G0tensor(215))
  call Hotf_4pt_reduction_last(G1tensor(168),RedSet_4(22),mass4set(:,21),  & 
G0tensor(216),G0tensor(217),G0tensor(218),G0tensor(219),G0tensor(220))
  call Hotf_4pt_reduction_last(G1tensor(173),RedSet_4(23),mass4set(:,5),  & 
G0tensor(221),G0tensor(222),G0tensor(223),G0tensor(224),G0tensor(225))
  call Hotf_4pt_reduction_last(G1tensor(178),RedSet_4(22),mass4set(:,22),  & 
G0tensor(226),G0tensor(227),G0tensor(228),G0tensor(229),G0tensor(230))
  call Hotf_4pt_reduction_last(G1tensor(183),RedSet_4(23),mass4set(:,23),  & 
G0tensor(231),G0tensor(232),G0tensor(233),G0tensor(234),G0tensor(235))
  call Hotf_4pt_reduction_last(G1tensor(188),RedSet_4(26),mass4set(:,24),  & 
G0tensor(236),G0tensor(237),G0tensor(238),G0tensor(239),G0tensor(240))
  call Hotf_4pt_reduction_last(G1tensor(193),RedSet_4(27),mass4set(:,24),  & 
G0tensor(241),G0tensor(242),G0tensor(243),G0tensor(244),G0tensor(245))
  call Hotf_4pt_reduction_last(G1tensor(198),RedSet_4(28),mass4set(:,6),  & 
G0tensor(246),G0tensor(247),G0tensor(248),G0tensor(249),G0tensor(250))
  call Hotf_4pt_reduction_last(G1tensor(203),RedSet_4(26),mass4set(:,25),  & 
G0tensor(251),G0tensor(252),G0tensor(253),G0tensor(254),G0tensor(255))
  call Hotf_4pt_reduction_last(G1tensor(208),RedSet_4(28),mass4set(:,11),  & 
G0tensor(256),G0tensor(257),G0tensor(258),G0tensor(259),G0tensor(260))
  call Hotf_4pt_reduction_last(G1tensor(213),RedSet_4(26),mass4set(:,26),  & 
G0tensor(261),G0tensor(262),G0tensor(263),G0tensor(264),G0tensor(265))
  call Hotf_4pt_reduction_last(G1tensor(218),RedSet_4(27),mass4set(:,26),  & 
G0tensor(266),G0tensor(267),G0tensor(268),G0tensor(269),G0tensor(270))
  call Hotf_4pt_reduction_last(G1tensor(223),RedSet_4(28),mass4set(:,27),  & 
G0tensor(271),G0tensor(272),G0tensor(273),G0tensor(274),G0tensor(275))
  call Hotf_4pt_reduction_last(G1tensor(228),RedSet_4(31),mass4set(:,24),  & 
G0tensor(276),G0tensor(277),G0tensor(278),G0tensor(279),G0tensor(280))
  call Hotf_4pt_reduction_last(G1tensor(233),RedSet_4(32),mass4set(:,24),  & 
G0tensor(281),G0tensor(282),G0tensor(283),G0tensor(284),G0tensor(285))
  call Hotf_4pt_reduction_last(G1tensor(238),RedSet_4(31),mass4set(:,25),  & 
G0tensor(286),G0tensor(287),G0tensor(288),G0tensor(289),G0tensor(290))
  call Hotf_4pt_reduction_last(G1tensor(243),RedSet_4(31),mass4set(:,26),  & 
G0tensor(291),G0tensor(292),G0tensor(293),G0tensor(294),G0tensor(295))
  call Hotf_4pt_reduction_last(G1tensor(248),RedSet_4(32),mass4set(:,26),  & 
G0tensor(296),G0tensor(297),G0tensor(298),G0tensor(299),G0tensor(300))
  call Hotf_4pt_reduction_last(G1tensor(253),RedSet_4(19),mass4set(:,1),  & 
G0tensor(301),G0tensor(302),G0tensor(303),G0tensor(304),G0tensor(305))
  call Hotf_4pt_reduction_last(G1tensor(258),RedSet_4(10),mass4set(:,17),  & 
G0tensor(306),G0tensor(307),G0tensor(308),G0tensor(309),G0tensor(310))
  call Hotf_4pt_reduction_last(G1tensor(263),RedSet_4(10),mass4set(:,18),  & 
G0tensor(311),G0tensor(312),G0tensor(313),G0tensor(314),G0tensor(315))
  call Hotf_4pt_reduction_last(G1tensor(268),RedSet_4(10),mass4set(:,19),  & 
G0tensor(316),G0tensor(317),G0tensor(318),G0tensor(319),G0tensor(320))
  call Hotf_4pt_reduction_last(G1tensor(273),RedSet_4(14),mass4set(:,17),  & 
G0tensor(321),G0tensor(322),G0tensor(323),G0tensor(324),G0tensor(325))
  call Hotf_4pt_reduction_last(G1tensor(278),RedSet_4(14),mass4set(:,18),  & 
G0tensor(326),G0tensor(327),G0tensor(328),G0tensor(329),G0tensor(330))
  call Hotf_4pt_reduction_last(G1tensor(283),RedSet_4(14),mass4set(:,19),  & 
G0tensor(331),G0tensor(332),G0tensor(333),G0tensor(334),G0tensor(335))
  call Hotf_4pt_reduction_last(G1tensor(288),RedSet_4(37),mass4set(:,21),  & 
G0tensor(336),G0tensor(337),G0tensor(338),G0tensor(339),G0tensor(340))
  call Hotf_4pt_reduction_last(G1tensor(293),RedSet_4(37),mass4set(:,22),  & 
G0tensor(341),G0tensor(342),G0tensor(343),G0tensor(344),G0tensor(345))
  call Hotf_4pt_reduction_last(G1tensor(298),RedSet_4(38),mass4set(:,21),  & 
G0tensor(346),G0tensor(347),G0tensor(348),G0tensor(349),G0tensor(350))
  call Hotf_4pt_reduction_last(G1tensor(303),RedSet_4(38),mass4set(:,22),  & 
G0tensor(351),G0tensor(352),G0tensor(353),G0tensor(354),G0tensor(355))
  call Hotf_4pt_reduction_last(G1tensor(308),RedSet_4(19),mass4set(:,2),  & 
G0tensor(356),G0tensor(357),G0tensor(358),G0tensor(359),G0tensor(360))
  call Hotf_4pt_reduction_last(G1tensor(313),RedSet_4(19),mass4set(:,3),  & 
G0tensor(361),G0tensor(362),G0tensor(363),G0tensor(364),G0tensor(365))
  call Hotf_4pt_reduction_last(G1tensor(318),RedSet_4(28),mass4set(:,4),  & 
G0tensor(366),G0tensor(367),G0tensor(368),G0tensor(369),G0tensor(370))
  call Hotf_4pt_reduction_last(G1tensor(323),RedSet_4(7),mass4set(:,7),  & 
G0tensor(371),G0tensor(372),G0tensor(373),G0tensor(374),G0tensor(375))
  call Hotf_4pt_reduction_last(G1tensor(328),RedSet_4(7),mass4set(:,8),  & 
G0tensor(376),G0tensor(377),G0tensor(378),G0tensor(379),G0tensor(380))
  call Hotf_4pt_reduction_last(G1tensor(333),RedSet_4(7),mass4set(:,9),  & 
G0tensor(381),G0tensor(382),G0tensor(383),G0tensor(384),G0tensor(385))
  call Hotf_4pt_reduction_last(G1tensor(338),RedSet_4(7),mass4set(:,10),  & 
G0tensor(386),G0tensor(387),G0tensor(388),G0tensor(389),G0tensor(390))
  call Hotf_4pt_reduction_last(G1tensor(343),RedSet_4(2),mass4set(:,7),  & 
G0tensor(391),G0tensor(392),G0tensor(393),G0tensor(394),G0tensor(395))
  call Hotf_4pt_reduction_last(G1tensor(348),RedSet_4(2),mass4set(:,8),  & 
G0tensor(396),G0tensor(397),G0tensor(398),G0tensor(399),G0tensor(400))
  call Hotf_4pt_reduction_last(G1tensor(353),RedSet_4(2),mass4set(:,9),  & 
G0tensor(401),G0tensor(402),G0tensor(403),G0tensor(404),G0tensor(405))
  call Hotf_4pt_reduction_last(G1tensor(358),RedSet_4(2),mass4set(:,10),  & 
G0tensor(406),G0tensor(407),G0tensor(408),G0tensor(409),G0tensor(410))
  call Hotf_4pt_reduction_last(G1tensor(363),RedSet_4(12),mass4set(:,6),  & 
G0tensor(411),G0tensor(412),G0tensor(413),G0tensor(414),G0tensor(415))
  call Hotf_4pt_reduction_last(G1tensor(368),RedSet_4(12),mass4set(:,11),  & 
G0tensor(416),G0tensor(417),G0tensor(418),G0tensor(419),G0tensor(420))
  call Hotf_4pt_reduction_last(G1tensor(373),RedSet_4(12),mass4set(:,12),  & 
G0tensor(421),G0tensor(422),G0tensor(423),G0tensor(424),G0tensor(425))
  call Hotf_4pt_reduction_last(G1tensor(378),RedSet_4(4),mass4set(:,6),  & 
G0tensor(426),G0tensor(427),G0tensor(428),G0tensor(429),G0tensor(430))
  call Hotf_4pt_reduction_last(G1tensor(383),RedSet_4(4),mass4set(:,11),  & 
G0tensor(431),G0tensor(432),G0tensor(433),G0tensor(434),G0tensor(435))
  call Hotf_4pt_reduction_last(G1tensor(388),RedSet_4(4),mass4set(:,12),  & 
G0tensor(436),G0tensor(437),G0tensor(438),G0tensor(439),G0tensor(440))
  call ol_merge_tensors(T0sum(1),[G0tensor(1)])
  call ol_merge_tensors(T0sum(2),[G0tensor(6)])
  call ol_merge_tensors(T0sum(3),[G0tensor(11)])
  call ol_merge_tensors(T0sum(4),[G0tensor(16)])
  call ol_merge_tensors(T0sum(5),[G0tensor(21)])
  call ol_merge_tensors(T0sum(6),[G0tensor(26)])
  call ol_merge_tensors(T0sum(7),[G0tensor(31)])
  call ol_merge_tensors(T0sum(8),[G0tensor(36)])
  call ol_merge_tensors(T0sum(9),[G0tensor(41)])
  call ol_merge_tensors(T0sum(10),[G0tensor(46)])
  call ol_merge_tensors(T0sum(11),[G0tensor(51)])
  call ol_merge_tensors(T0sum(12),[G0tensor(56)])
  call ol_merge_tensors(T0sum(13),[G0tensor(61)])
  call ol_merge_tensors(T0sum(14),[G0tensor(66)])
  call ol_merge_tensors(T0sum(15),[G0tensor(71)])
  call ol_merge_tensors(T0sum(16),[G0tensor(76)])
  call ol_merge_tensors(T0sum(17),[G0tensor(81)])
  call ol_merge_tensors(T0sum(18),[G0tensor(86)])
  call ol_merge_tensors(T0sum(19),[G0tensor(91)])
  call ol_merge_tensors(T0sum(20),[G0tensor(96)])
  call ol_merge_tensors(T0sum(21),[G0tensor(101)])
  call ol_merge_tensors(T0sum(22),[G0tensor(106)])
  call ol_merge_tensors(T0sum(23),[G0tensor(111)])
  call ol_merge_tensors(T0sum(24),[G0tensor(116)])
  call ol_merge_tensors(T0sum(25),[G0tensor(121)])
  call ol_merge_tensors(T0sum(26),[G0tensor(126)])
  call ol_merge_tensors(T0sum(27),[G0tensor(131)])
  call ol_merge_tensors(T0sum(28),[G0tensor(136)])
  call ol_merge_tensors(T0sum(29),[G0tensor(141)])
  call ol_merge_tensors(T0sum(30),[G0tensor(146)])
  call ol_merge_tensors(T0sum(31),[G0tensor(151)])
  call ol_merge_tensors(T0sum(32),[G0tensor(156)])
  call ol_merge_tensors(T0sum(33),[G0tensor(161)])
  call ol_merge_tensors(T0sum(34),[G0tensor(166)])
  call ol_merge_tensors(T0sum(35),[G0tensor(171)])
  call ol_merge_tensors(T0sum(36),[G0tensor(176)])
  call ol_merge_tensors(T0sum(37),[G0tensor(181)])
  call ol_merge_tensors(T0sum(38),[G0tensor(186)])
  call ol_merge_tensors(T0sum(39),[G0tensor(191)])
  call ol_merge_tensors(T0sum(40),[G0tensor(196)])
  call ol_merge_tensors(T0sum(41),[G0tensor(201)])
  call ol_merge_tensors(T0sum(42),[G0tensor(206)])
  call ol_merge_tensors(T0sum(43),[G0tensor(211)])
  call ol_merge_tensors(T0sum(44),[G0tensor(216)])
  call ol_merge_tensors(T0sum(45),[G0tensor(221)])
  call ol_merge_tensors(T0sum(46),[G0tensor(226)])
  call ol_merge_tensors(T0sum(47),[G0tensor(231)])
  call ol_merge_tensors(T0sum(48),[G0tensor(236)])
  call ol_merge_tensors(T0sum(49),[G0tensor(241)])
  call ol_merge_tensors(T0sum(50),[G0tensor(246)])
  call ol_merge_tensors(T0sum(51),[G0tensor(251)])
  call ol_merge_tensors(T0sum(52),[G0tensor(256)])
  call ol_merge_tensors(T0sum(53),[G0tensor(261)])
  call ol_merge_tensors(T0sum(54),[G0tensor(266)])
  call ol_merge_tensors(T0sum(55),[G0tensor(271)])
  call ol_merge_tensors(T0sum(56),[G0tensor(276)])
  call ol_merge_tensors(T0sum(57),[G0tensor(281)])
  call ol_merge_tensors(T0sum(58),[G0tensor(286)])
  call ol_merge_tensors(T0sum(59),[G0tensor(291)])
  call ol_merge_tensors(T0sum(60),[G0tensor(296)])
  call ol_merge_tensors(T0sum(61),[G0tensor(301)])
  call ol_merge_tensors(T0sum(62),[G0tensor(306)])
  call ol_merge_tensors(T0sum(63),[G0tensor(311)])
  call ol_merge_tensors(T0sum(64),[G0tensor(316)])
  call ol_merge_tensors(T0sum(65),[G0tensor(321)])
  call ol_merge_tensors(T0sum(66),[G0tensor(326)])
  call ol_merge_tensors(T0sum(67),[G0tensor(331)])
  call ol_merge_tensors(T0sum(68),[G0tensor(336)])
  call ol_merge_tensors(T0sum(69),[G0tensor(341)])
  call ol_merge_tensors(T0sum(70),[G0tensor(346)])
  call ol_merge_tensors(T0sum(71),[G0tensor(351)])
  call ol_merge_tensors(T0sum(72),[G0tensor(356)])
  call ol_merge_tensors(T0sum(73),[G0tensor(361)])
  call ol_merge_tensors(T0sum(74),[G0tensor(366)])
  call ol_merge_tensors(T0sum(75),[G0tensor(371)])
  call ol_merge_tensors(T0sum(76),[G0tensor(376)])
  call ol_merge_tensors(T0sum(77),[G0tensor(381)])
  call ol_merge_tensors(T0sum(78),[G0tensor(386)])
  call ol_merge_tensors(T0sum(79),[G0tensor(391)])
  call ol_merge_tensors(T0sum(80),[G0tensor(396)])
  call ol_merge_tensors(T0sum(81),[G0tensor(401)])
  call ol_merge_tensors(T0sum(82),[G0tensor(406)])
  call ol_merge_tensors(T0sum(83),[G0tensor(411)])
  call ol_merge_tensors(T0sum(84),[G0tensor(416)])
  call ol_merge_tensors(T0sum(85),[G0tensor(421)])
  call ol_merge_tensors(T0sum(86),[G0tensor(426)])
  call ol_merge_tensors(T0sum(87),[G0tensor(431)])
  call ol_merge_tensors(T0sum(88),[G0tensor(436)])
  Gcoeff(:)%j = (c(40)*M(2,:)%j-c(39)*M(4,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(106),h0tab(:,106),[16,3,12],[0,0,0],3,2,wf4(:,3),wf4(:,4))
  call Hloop_AZ_Q(ntryL,G0H48(1),ex5(:),G0H16(2),ngZu,m3h3x16(:,66),heltab2x48(:,:,106))
  call Hloop_A_Q(ntryL,G0H16(2),16,0,G1H16(11),n2h16(53))
  Gcoeff(:)%j = (c(38)*M(2,:)%j-c(37)*M(4,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(107),h0tab(:,107),[16,3,12],[nMT,nMT,nMT],3,2,wf4(:,3),wf4(:,4))
  call Hloop_AZ_Q(ntryL,G0H48(1),ex5(:),G0H16(3),ngZu,m3h3x16(:,67),heltab2x48(:,:,107))
  call Hloop_A_Q(ntryL,G0H16(3),16,nMT,G1H16(6),n2h16(54))
  Gcoeff(:)%j = (c(40)*M(2,:)%j-c(39)*M(4,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(108),h0tab(:,108),[16,3,12],[0,0,0],3,2,wf4(:,3),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H48(1),ex5(:),G0H16(4),ngZu,m3h3x16(:,68),heltab2x48(:,:,108))
  call Hloop_Q_A(ntryL,G0H16(4),16,0,G1H16(15),n2h16(55))
  Gcoeff(:)%j = (c(38)*M(2,:)%j-c(37)*M(4,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(109),h0tab(:,109),[16,3,12],[nMT,nMT,nMT],3,2,wf4(:,3),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H48(1),ex5(:),G0H16(5),ngZu,m3h3x16(:,69),heltab2x48(:,:,109))
  call Hloop_Q_A(ntryL,G0H16(5),16,nMT,G1H16(8),n2h16(56))
  Gcoeff(:)%j = (c(40)*M(2,:)%j-c(39)*M(4,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(110),h0tab(:,110),[16,3,12],[0,0,0],3,2,wf4(:,3),wf4(:,4))
  call Hloop_AZ_Q(ntryL,G0H48(1),ex5(:),G0H16(1),ngZd,m3h3x16(:,70),heltab2x48(:,:,110))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(26),n2h16(57))
  Gcoeff(:)%j = (c(38)*M(2,:)%j-c(37)*M(4,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(111),h0tab(:,111),[16,3,12],[nMB,nMB,nMB],3,2,wf4(:,3),wf4(:,4))
  call Hloop_AZ_Q(ntryL,G0H48(1),ex5(:),G0H16(2),ngZd,m3h3x16(:,71),heltab2x48(:,:,111))
  call Hloop_A_Q(ntryL,G0H16(2),16,nMB,G1H16(24),n2h16(58))
  Gcoeff(:)%j = (c(40)*M(2,:)%j-c(39)*M(4,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(112),h0tab(:,112),[16,3,12],[0,0,0],3,2,wf4(:,3),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H48(1),ex5(:),G0H16(3),ngZd,m3h3x16(:,72),heltab2x48(:,:,112))
  call Hloop_Q_A(ntryL,G0H16(3),16,0,G1H16(32),n2h16(59))
  Gcoeff(:)%j = (c(38)*M(2,:)%j-c(37)*M(4,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(113),h0tab(:,113),[16,3,12],[nMB,nMB,nMB],3,2,wf4(:,3),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H48(1),ex5(:),G0H16(4),ngZd,m3h3x16(:,73),heltab2x48(:,:,113))
  call Hloop_Q_A(ntryL,G0H16(4),16,nMB,G1H16(30),n2h16(60))
  Gcoeff(:)%j = (c(32)*M(1,:)%j-c(31)*M(3,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(114),h0tab(:,114),[20,3,8],[nMT,nMT,nMH],3,2,wf6(:,2),wf4(:,3))
  call Hloop_SQ_A(ntryL,G0H48(1),wf6(:,2),G0H8(12),ngH,m3h6x8(:,41),heltab2x48(:,:,114))
  call Hloop_Q_A(ntryL,G0H8(12),20,nMT,G1H8(22),n2h8(39))
  Gcoeff(:)%j = (-(c(32)*M(1,:)%j)+c(31)*M(3,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(115),h0tab(:,115),[20,3,8],[nMT,nMT,nMZ],3,2,wf6(:,2),wf4(:,3))
  call Hloop_SQ_A(ntryL,G0H48(1),wf6(:,2),G0H8(11),ngX,m3h6x8(:,42),heltab2x48(:,:,115))
  call Hloop_Q_A(ntryL,G0H8(11),20,nMT,G1H8(23),n2h8(40))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j)+c(29)*M(3,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(116),h0tab(:,116),[20,3,8],[nMB,nMB,nMW],3,2,wf6(:,2),wf4(:,3))
  call Hloop_SQ_A(ntryL,G0H48(1),wf6(:,2),G0H8(17),ngPbt,m3h6x8(:,43),heltab2x48(:,:,116))
  call Hloop_Q_A(ntryL,G0H8(17),20,nMB,G1H8(24),n2h8(41))
  Gcoeff(:)%j = (-(c(3)*M(3,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(117),h0tab(:,117),[20,3,8],[nMT,nMT,0],3,2,wf6(:,2),wf4(:,3))
  call Hloop_VQ_A(ntryL,G0H48(1),wf6(:,2),G0H8(16),m3h6x8(:,44),heltab2x48(:,:,117))
  call Hloop_Q_A(ntryL,G0H8(16),20,nMT,G1H8(25),n2h8(42))
  Gcoeff(:)%j = (-(c(6)*M(3,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(118),h0tab(:,118),[20,3,8],[nMT,nMT,0],3,2,wf6(:,2),wf4(:,1))
  call Hloop_VQ_A(ntryL,G0H48(1),wf6(:,2),G0H8(2),m3h6x8(:,45),heltab2x48(:,:,118))
  call Hloop_Q_A(ntryL,G0H8(2),20,nMT,G1H8(26),n2h8(43))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)+c(1)*M(3,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(119),h0tab(:,119),[20,3,8],[nMT,nMT,0],3,2,wf6(:,2),wf4(:,3))
  call Hloop_VQ_A(ntryL,G0H48(1),wf6(:,2),G0H8(1),m3h6x8(:,46),heltab2x48(:,:,119))
  call Hloop_Q_A(ntryL,G0H8(1),20,nMT,G1H8(27),n2h8(44))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)+c(4)*M(3,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(120),h0tab(:,120),[20,3,8],[nMT,nMT,nMZ],3,2,wf6(:,2),wf4(:,3))
  call Hloop_ZQ_A(ntryL,G0H48(1),wf6(:,2),G0H8(7),ngZu,m3h6x8(:,47),heltab2x48(:,:,120))
  call Hloop_Q_A(ntryL,G0H8(7),20,nMT,G1H8(5),n2h8(45))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)+c(24)*M(3,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(121),h0tab(:,121),[20,3,8],[nMB,nMB,nMW],3,2,wf6(:,2),wf4(:,3))
  call Hloop_WQ_A(ntryL,G0H48(1),wf6(:,2),G0H8(6),m3h6x8(:,48),heltab2x48(:,:,121))
  call Hloop_Q_A(ntryL,G0H8(6),20,nMB,G1H8(4),n2h8(46))
  Gcoeff(:)%j = (c(12)*M(2,:)%j-c(11)*M(4,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(122),h0tab(:,122),[20,3,8],[nMT,nMT,0],3,2,wf6(:,2),wf4(:,3))
  call Hloop_VQ_A(ntryL,G0H48(1),wf6(:,2),G0H8(5),m3h6x8(:,49),heltab2x48(:,:,122))
  call Hloop_Q_A(ntryL,G0H8(5),20,nMT,G1H8(10),n2h8(47))
  Gcoeff(:)%j = (-(c(8)*M(2,:)%j)+c(7)*M(4,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(123),h0tab(:,123),[20,3,8],[0,0,nMT],3,2,wf6(:,2),wf4(:,3))
  call Hloop_AQ_V(ntryL,G0H48(1),wf6(:,2),G0H8(3),m3h6x8(:,50),heltab2x48(:,:,123))
  Gcoeff(:)%j = (c(32)*M(1,:)%j-c(31)*M(3,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(124),h0tab(:,124),[24,3,4],[nMT,nMT,nMH],3,2,wf6(:,4),wf4(:,3))
  call Hloop_SA_Q(ntryL,G0H48(1),wf6(:,4),G0H8(4),ngH,m3h6x8(:,51),heltab2x48(:,:,124))
  call Hloop_A_Q(ntryL,G0H8(4),24,nMT,G1H8(8),n2h8(48))
  Gcoeff(:)%j = (-(c(32)*M(1,:)%j)+c(31)*M(3,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(125),h0tab(:,125),[24,3,4],[nMT,nMT,nMZ],3,2,wf6(:,4),wf4(:,3))
  call Hloop_SA_Q(ntryL,G0H48(1),wf6(:,4),G0H8(10),ngX,m3h6x8(:,52),heltab2x48(:,:,125))
  call Hloop_A_Q(ntryL,G0H8(10),24,nMT,G1H8(9),n2h8(49))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j)+c(29)*M(3,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(126),h0tab(:,126),[24,3,4],[nMB,nMB,nMW],3,2,wf6(:,4),wf4(:,3))
  call Hloop_SA_Q(ntryL,G0H48(1),wf6(:,4),G0H8(8),ngPtb,m3h6x8(:,53),heltab2x48(:,:,126))
  call Hloop_A_Q(ntryL,G0H8(8),24,nMB,G1H8(13),n2h8(50))
  Gcoeff(:)%j = (-(c(3)*M(3,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(127),h0tab(:,127),[24,3,4],[nMT,nMT,0],3,2,wf6(:,4),wf4(:,3))
  call Hloop_VA_Q(ntryL,G0H48(1),wf6(:,4),G0H8(9),m3h6x8(:,54),heltab2x48(:,:,127))
  call Hloop_A_Q(ntryL,G0H8(9),24,nMT,G1H8(14),n2h8(51))
  Gcoeff(:)%j = (-(c(6)*M(3,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(128),h0tab(:,128),[24,3,4],[nMT,nMT,0],3,2,wf6(:,4),wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H48(1),wf6(:,4),G0H8(15),m3h6x8(:,55),heltab2x48(:,:,128))
  call Hloop_A_Q(ntryL,G0H8(15),24,nMT,G1H8(20),n2h8(52))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)+c(1)*M(3,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(129),h0tab(:,129),[24,3,4],[nMT,nMT,0],3,2,wf6(:,4),wf4(:,3))
  call Hloop_VA_Q(ntryL,G0H48(1),wf6(:,4),G0H8(13),m3h6x8(:,56),heltab2x48(:,:,129))
  call Hloop_A_Q(ntryL,G0H8(13),24,nMT,G1H8(18),n2h8(53))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)+c(4)*M(3,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(130),h0tab(:,130),[24,3,4],[nMT,nMT,nMZ],3,2,wf6(:,4),wf4(:,3))
  call Hloop_ZA_Q(ntryL,G0H48(1),wf6(:,4),G0H8(14),ngZu,m3h6x8(:,57),heltab2x48(:,:,130))
  call Hloop_A_Q(ntryL,G0H8(14),24,nMT,G1H8(11),n2h8(54))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)+c(24)*M(3,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(131),h0tab(:,131),[24,3,4],[nMB,nMB,nMW],3,2,wf6(:,4),wf4(:,3))
  call Hloop_WA_Q(ntryL,G0H48(1),wf6(:,4),G0H8(20),m3h6x8(:,58),heltab2x48(:,:,131))
  call Hloop_A_Q(ntryL,G0H8(20),24,nMB,G1H8(17),n2h8(55))
  Gcoeff(:)%j = (c(12)*M(2,:)%j-c(11)*M(4,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(132),h0tab(:,132),[24,3,4],[nMT,nMT,0],3,2,wf6(:,4),wf4(:,3))
  call Hloop_VA_Q(ntryL,G0H48(1),wf6(:,4),G0H8(18),m3h6x8(:,59),heltab2x48(:,:,132))
  call Hloop_A_Q(ntryL,G0H8(18),24,nMT,G1H8(12),n2h8(56))
  Gcoeff(:)%j = (c(8)*M(2,:)%j-c(7)*M(4,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(133),h0tab(:,133),[24,3,4],[0,0,nMT],3,2,wf6(:,4),wf4(:,3))
  call Hloop_QA_V(ntryL,G0H48(1),wf6(:,4),G0H8(19),m3h6x8(:,60),heltab2x48(:,:,133))
  Gcoeff(:)%j = (c(32)*M(1,:)%j-c(31)*M(3,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(134),h0tab(:,134),[16,7,8],[nMT,nMH,nMT],3,1,wf8(:,19))
  call Hloop_AZ_Q(ntryL,G0H48(1),ex5(:),G0H16(5),ngZu,m3h3x16(:,74),heltab2x48(:,:,134))
  call Hloop_A_Q(ntryL,G0H16(5),16,nMT,G1H16(2),n2h16(61))
  Gcoeff(:)%j = (-(c(32)*M(1,:)%j)+c(31)*M(3,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(135),h0tab(:,135),[16,7,8],[nMT,nMZ,nMT],3,1,wf8(:,19))
  call Hloop_AZ_Q(ntryL,G0H48(1),ex5(:),G0H16(1),ngZu,m3h3x16(:,75),heltab2x48(:,:,135))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(1),n2h16(62))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j)+c(29)*M(3,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(136),h0tab(:,136),[16,7,8],[nMB,nMW,nMB],3,1,wf8(:,19))
  call Hloop_AZ_Q(ntryL,G0H48(1),ex5(:),G0H16(2),ngZd,m3h3x16(:,76),heltab2x48(:,:,136))
  call Hloop_A_Q(ntryL,G0H16(2),16,nMB,G1H16(7),n2h16(63))
  Gcoeff(:)%j = (c(23)*M(1,:)%j-c(22)*M(3,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(137),h0tab(:,137),[16,7,8],[nMZ,nMT,nMH],3,1,wf8(:,19))
  call Hloop_TV_S(ntryL,G0H48(1),0,ex5(:),16,G1H16(5),m3h3x16(:,77),heltab2x48(:,:,137))
  Gcoeff(:)%j = (c(23)*M(1,:)%j-c(22)*M(3,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(138),h0tab(:,138),[16,7,8],[nMH,nMT,nMZ],3,1,wf8(:,19))
  call Hloop_SV_T(ntryL,G0H48(1),0,ex5(:),16,G1H16(12),m3h3x16(:,78),heltab2x48(:,:,138))
  Gcoeff(:)%j = (c(36)*M(1,:)%j-c(35)*M(3,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(139),h0tab(:,139),[16,7,8],[nMW,nMB,nMW],3,1,wf8(:,19))
  call Hloop_TV_S(ntryL,G0H48(1),0,ex5(:),16,G1H16(17),m3h3x16(:,79),heltab2x48(:,:,139))
  Gcoeff(:)%j = (-(c(3)*M(3,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(140),h0tab(:,140),[16,7,8],[nMT,0,nMT],3,1,wf8(:,19))
  call Hloop_AZ_Q(ntryL,G0H48(1),ex5(:),G0H16(3),ngZu,m3h3x16(:,80),heltab2x48(:,:,140))
  call Hloop_A_Q(ntryL,G0H16(3),16,nMT,G1H16(16),n2h16(64))
  Gcoeff(:)%j = (-(c(6)*M(3,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(141),h0tab(:,141),[16,7,8],[nMT,0,nMT],3,1,wf8(:,20))
  call Hloop_AZ_Q(ntryL,G0H48(1),ex5(:),G0H16(4),ngZu,m3h3x16(:,81),heltab2x48(:,:,141))
  call Hloop_A_Q(ntryL,G0H16(4),16,nMT,G1H16(3),n2h16(65))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)+c(1)*M(3,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(142),h0tab(:,142),[16,7,8],[nMT,0,nMT],3,1,wf8(:,19))
  call Hloop_AZ_Q(ntryL,G0H48(1),ex5(:),G0H16(5),ngZu,m3h3x16(:,82),heltab2x48(:,:,142))
  call Hloop_A_Q(ntryL,G0H16(5),16,nMT,G1H16(4),n2h16(66))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)+c(4)*M(3,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(143),h0tab(:,143),[16,7,8],[nMT,nMZ,nMT],3,1,wf8(:,19))
  call Hloop_AZ_Q(ntryL,G0H48(1),ex5(:),G0H16(1),ngZu,m3h3x16(:,83),heltab2x48(:,:,143))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(10),n2h16(67))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)+c(24)*M(3,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(144),h0tab(:,144),[16,7,8],[nMB,nMW,nMB],3,1,wf8(:,19))
  call Hloop_AZ_Q(ntryL,G0H48(1),ex5(:),G0H16(2),ngZd,m3h3x16(:,84),heltab2x48(:,:,144))
  call Hloop_A_Q(ntryL,G0H16(2),16,nMB,G1H16(20),n2h16(68))
  Gcoeff(:)%j = (-(c(18)*M(2,:)%j)+c(14)*M(4,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(145),h0tab(:,145),[16,7,8],[nMT,0,nMT],3,1,wf8(:,19))
  call Hloop_AZ_Q(ntryL,G0H48(1),ex5(:),G0H16(3),ngZu,m3h3x16(:,85),heltab2x48(:,:,145))
  call Hloop_A_Q(ntryL,G0H16(3),16,nMT,G1H16(9),n2h16(69))
  Gcoeff(:)%j = (c(27)*M(1,:)%j-c(26)*M(3,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(146),h0tab(:,146),[16,7,8],[nMZ,nMT,nMH],3,1,wf8(:,19))
  call Hloop_SV_V(ntryL,G0H48(1),ex5(:),G0H16(4),m3h3x16(:,86),heltab2x48(:,:,146))
  Gcoeff(:)%j = (c(34)*M(1,:)%j-c(33)*M(3,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(147),h0tab(:,147),[16,7,8],[nMW,nMB,nMW],3,1,wf8(:,19))
  call Hloop_SV_V(ntryL,G0H48(1),ex5(:),G0H16(5),m3h3x16(:,87),heltab2x48(:,:,147))
  Gcoeff(:)%j = (c(27)*M(1,:)%j-c(26)*M(3,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(148),h0tab(:,148),[16,7,8],[nMH,nMT,nMZ],3,1,wf8(:,19))
  call Hloop_VV_S(ntryL,G0H48(1),ex5(:),G0H16(1),m3h3x16(:,88),heltab2x48(:,:,148))
  Gcoeff(:)%j = (-(c(34)*M(1,:)%j)+c(33)*M(3,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(149),h0tab(:,149),[16,7,8],[nMW,nMB,nMW],3,1,wf8(:,19))
  call Hloop_VV_S(ntryL,G0H48(1),ex5(:),G0H16(2),m3h3x16(:,89),heltab2x48(:,:,149))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)+c(20)*M(3,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(150),h0tab(:,150),[16,7,8],[nMW,nMB,nMW],3,1,wf8(:,19))
  call Hloop_UV_W(ntryL,G0H48(1),0,ex5(:),16,G1H16(13),m3h3x16(:,90),heltab2x48(:,:,150))
  Gcoeff(:)%j = (c(32)*M(1,:)%j-c(31)*M(3,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(151),h0tab(:,151),[16,4,11],[nMT,nMH,nMT],3,1,wf8(:,17))
  call Hloop_AZ_Q(ntryL,G0H48(1),ex5(:),G0H16(3),ngZu,m3h3x16(:,91),heltab2x48(:,:,151))
  call Hloop_A_Q(ntryL,G0H16(3),16,nMT,G1H16(14),n2h16(70))
  Gcoeff(:)%j = (-(c(32)*M(1,:)%j)+c(31)*M(3,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(152),h0tab(:,152),[16,4,11],[nMT,nMZ,nMT],3,1,wf8(:,17))
  call Hloop_AZ_Q(ntryL,G0H48(1),ex5(:),G0H16(3),ngZu,m3h3x16(:,92),heltab2x48(:,:,152))
  call Hloop_A_Q(ntryL,G0H16(3),16,nMT,G1H16(18),n2h16(71))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j)+c(29)*M(3,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(153),h0tab(:,153),[16,4,11],[nMB,nMW,nMB],3,1,wf8(:,17))
  call Hloop_AZ_Q(ntryL,G0H48(1),ex5(:),G0H16(3),ngZd,m3h3x16(:,93),heltab2x48(:,:,153))
  call Hloop_A_Q(ntryL,G0H16(3),16,nMB,G1H16(19),n2h16(72))
  Gcoeff(:)%j = (c(23)*M(1,:)%j-c(22)*M(3,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(154),h0tab(:,154),[16,4,11],[nMH,nMT,nMZ],3,1,wf8(:,17))
  call Hloop_SV_T(ntryL,G0H48(1),0,ex5(:),16,G1H16(21),m3h3x16(:,94),heltab2x48(:,:,154))
  Gcoeff(:)%j = (c(23)*M(1,:)%j-c(22)*M(3,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(155),h0tab(:,155),[16,4,11],[nMZ,nMT,nMH],3,1,wf8(:,17))
  call Hloop_TV_S(ntryL,G0H48(1),0,ex5(:),16,G1H16(22),m3h3x16(:,95),heltab2x48(:,:,155))
  Gcoeff(:)%j = (c(36)*M(1,:)%j-c(35)*M(3,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(156),h0tab(:,156),[16,4,11],[nMW,nMB,nMW],3,1,wf8(:,17))
  call Hloop_TV_S(ntryL,G0H48(1),0,ex5(:),16,G1H16(23),m3h3x16(:,96),heltab2x48(:,:,156))
  Gcoeff(:)%j = (-(c(3)*M(3,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(157),h0tab(:,157),[16,4,11],[nMT,0,nMT],3,1,wf8(:,17))
  call Hloop_AZ_Q(ntryL,G0H48(1),ex5(:),G0H16(3),ngZu,m3h3x16(:,97),heltab2x48(:,:,157))
  call Hloop_A_Q(ntryL,G0H16(3),16,nMT,G1H16(29),n2h16(73))
  Gcoeff(:)%j = (-(c(6)*M(3,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(158),h0tab(:,158),[16,4,11],[nMT,0,nMT],3,1,wf8(:,18))
  call Hloop_AZ_Q(ntryL,G0H48(1),ex5(:),G0H16(3),ngZu,m3h3x16(:,98),heltab2x48(:,:,158))
  call Hloop_A_Q(ntryL,G0H16(3),16,nMT,G1H16(25),n2h16(74))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)+c(1)*M(3,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(159),h0tab(:,159),[16,4,11],[nMT,0,nMT],3,1,wf8(:,17))
  call Hloop_AZ_Q(ntryL,G0H48(1),ex5(:),G0H16(3),ngZu,m3h3x16(:,99),heltab2x48(:,:,159))
  call Hloop_A_Q(ntryL,G0H16(3),16,nMT,G1H16(27),n2h16(75))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)+c(4)*M(3,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(160),h0tab(:,160),[16,4,11],[nMT,nMZ,nMT],3,1,wf8(:,17))
  call Hloop_AZ_Q(ntryL,G0H48(1),ex5(:),G0H16(3),ngZu,m3h3x16(:,100),heltab2x48(:,:,160))
  call Hloop_A_Q(ntryL,G0H16(3),16,nMT,G1H16(28),n2h16(76))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)+c(24)*M(3,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(161),h0tab(:,161),[16,4,11],[nMB,nMW,nMB],3,1,wf8(:,17))
  call Hloop_AZ_Q(ntryL,G0H48(1),ex5(:),G0H16(3),ngZd,m3h3x16(:,101),heltab2x48(:,:,161))
  call Hloop_A_Q(ntryL,G0H16(3),16,nMB,G1H16(35),n2h16(77))
  Gcoeff(:)%j = (-(c(18)*M(2,:)%j)+c(14)*M(4,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(162),h0tab(:,162),[16,4,11],[nMT,0,nMT],3,1,wf8(:,17))
  call Hloop_AZ_Q(ntryL,G0H48(1),ex5(:),G0H16(3),ngZu,m3h3x16(:,102),heltab2x48(:,:,162))
  call Hloop_A_Q(ntryL,G0H16(3),16,nMT,G1H16(31),n2h16(78))
  Gcoeff(:)%j = (c(27)*M(1,:)%j-c(26)*M(3,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(163),h0tab(:,163),[16,4,11],[nMH,nMT,nMZ],3,1,wf8(:,17))
  call Hloop_VV_S(ntryL,G0H48(1),ex5(:),G0H16(3),m3h3x16(:,103),heltab2x48(:,:,163))
  Gcoeff(:)%j = (-(c(34)*M(1,:)%j)+c(33)*M(3,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(164),h0tab(:,164),[16,4,11],[nMW,nMB,nMW],3,1,wf8(:,17))
  call Hloop_VV_S(ntryL,G0H48(1),ex5(:),G0H16(6),m3h3x16(:,104),heltab2x48(:,:,164))
  Gcoeff(:)%j = (c(27)*M(1,:)%j-c(26)*M(3,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(165),h0tab(:,165),[16,4,11],[nMZ,nMT,nMH],3,1,wf8(:,17))
  call Hloop_SV_V(ntryL,G0H48(1),ex5(:),G0H16(7),m3h3x16(:,105),heltab2x48(:,:,165))
  Gcoeff(:)%j = (c(34)*M(1,:)%j-c(33)*M(3,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(166),h0tab(:,166),[16,4,11],[nMW,nMB,nMW],3,1,wf8(:,17))
  call Hloop_SV_V(ntryL,G0H48(1),ex5(:),G0H16(8),m3h3x16(:,106),heltab2x48(:,:,166))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)+c(20)*M(3,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(167),h0tab(:,167),[16,4,11],[nMW,nMB,nMW],3,1,wf8(:,17))
  call Hloop_UV_W(ntryL,G0H48(1),0,ex5(:),16,G1H16(33),m3h3x16(:,107),heltab2x48(:,:,167))
  Gcoeff(:)%j = (c(28)*M(3,:)%j) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(168),h0tab(:,168),[19,4,8],[nMT,0,nMT],3,1,wf12(:,1))
  call Hloop_AS_Q(ntryL,G0H48(1),wf12(:,1),G0H4(1),ngH,m3h12x4(:,1),heltab2x48(:,:,168))
  call Hloop_A_Q(ntryL,G0H4(1),19,nMT,G1H4(3),n2h4(47))
  Gcoeff(:)%j = (-(c(3)*M(3,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(169),h0tab(:,169),[17,2,12],[0,0,0],3,2,wf6(:,6),wf4(:,4))
  call Hloop_AQ_V(ntryL,G0H48(1),wf6(:,6),G0H8(12),m3h6x8(:,61),heltab2x48(:,:,169))
  Gcoeff(:)%j = (-(c(6)*M(3,:)%j)) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(170),h0tab(:,170),[17,2,12],[0,0,0],3,2,wf6(:,6),wf4(:,5))
  call Hloop_AQ_V(ntryL,G0H48(1),wf6(:,6),G0H8(11),m3h6x8(:,62),heltab2x48(:,:,170))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)+c(1)*M(3,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(171),h0tab(:,171),[17,2,12],[0,0,0],3,2,wf6(:,6),wf4(:,4))
  call Hloop_AQ_V(ntryL,G0H48(1),wf6(:,6),G0H8(17),m3h6x8(:,63),heltab2x48(:,:,171))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)+c(4)*M(3,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(172),h0tab(:,172),[17,2,12],[nMZ,0,0],3,2,wf6(:,6),wf4(:,4))
  call Hloop_AQ_Z(ntryL,G0H48(1),wf6(:,6),G0H8(16),ngZu,m3h6x8(:,64),heltab2x48(:,:,172))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)+c(24)*M(3,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(173),h0tab(:,173),[17,2,12],[nMW,0,0],3,2,wf6(:,6),wf4(:,4))
  call Hloop_AQ_W(ntryL,G0H48(1),wf6(:,6),G0H8(2),m3h6x8(:,65),heltab2x48(:,:,173))
  Gcoeff(:)%j = (c(12)*M(2,:)%j-c(11)*M(4,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(174),h0tab(:,174),[17,2,12],[0,0,0],3,2,wf6(:,6),wf4(:,4))
  call Hloop_AQ_V(ntryL,G0H48(1),wf6(:,6),G0H8(1),m3h6x8(:,66),heltab2x48(:,:,174))
  Gcoeff(:)%j = (c(8)*M(2,:)%j-c(7)*M(4,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(175),h0tab(:,175),[17,2,12],[0,0,0],3,2,wf6(:,6),wf4(:,4))
  call Hloop_VQ_A(ntryL,G0H48(1),wf6(:,6),G0H8(7),m3h6x8(:,67),heltab2x48(:,:,175))
  call Hloop_Q_A(ntryL,G0H8(7),17,0,G1H8(6),n2h8(57))
  Gcoeff(:)%j = (-(c(3)*M(3,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(176),h0tab(:,176),[18,1,12],[0,0,0],3,2,wf6(:,8),wf4(:,4))
  call Hloop_QA_V(ntryL,G0H48(1),wf6(:,8),G0H8(6),m3h6x8(:,68),heltab2x48(:,:,176))
  Gcoeff(:)%j = (-(c(6)*M(3,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(177),h0tab(:,177),[18,1,12],[0,0,0],3,2,wf6(:,8),wf4(:,5))
  call Hloop_QA_V(ntryL,G0H48(1),wf6(:,8),G0H8(5),m3h6x8(:,69),heltab2x48(:,:,177))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)+c(1)*M(3,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(178),h0tab(:,178),[18,1,12],[0,0,0],3,2,wf6(:,8),wf4(:,4))
  call Hloop_QA_V(ntryL,G0H48(1),wf6(:,8),G0H8(4),m3h6x8(:,70),heltab2x48(:,:,178))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)+c(4)*M(3,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(179),h0tab(:,179),[18,1,12],[nMZ,0,0],3,2,wf6(:,8),wf4(:,4))
  call Hloop_QA_Z(ntryL,G0H48(1),wf6(:,8),G0H8(10),ngZu,m3h6x8(:,71),heltab2x48(:,:,179))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)+c(24)*M(3,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(180),h0tab(:,180),[18,1,12],[nMW,0,0],3,2,wf6(:,8),wf4(:,4))
  call Hloop_QA_W(ntryL,G0H48(1),wf6(:,8),G0H8(8),m3h6x8(:,72),heltab2x48(:,:,180))
  Gcoeff(:)%j = (c(12)*M(2,:)%j-c(11)*M(4,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(181),h0tab(:,181),[18,1,12],[0,0,0],3,2,wf6(:,8),wf4(:,4))
  call Hloop_QA_V(ntryL,G0H48(1),wf6(:,8),G0H8(9),m3h6x8(:,73),heltab2x48(:,:,181))
  Gcoeff(:)%j = (-(c(8)*M(2,:)%j)+c(7)*M(4,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(182),h0tab(:,182),[18,1,12],[0,0,0],3,2,wf6(:,8),wf4(:,4))
  call Hloop_VA_Q(ntryL,G0H48(1),wf6(:,8),G0H8(15),m3h6x8(:,74),heltab2x48(:,:,182))
  call Hloop_A_Q(ntryL,G0H8(15),18,0,G1H8(29),n2h8(58))
  Gcoeff(:)%j = (-(c(3)*M(3,:)%j)) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(183),h0tab(:,183),[16,2,13],[0,0,0],3,1,wf8(:,26))
  call Hloop_QZ_A(ntryL,G0H48(1),ex5(:),G0H16(9),ngZu,m3h3x16(:,108),heltab2x48(:,:,183))
  call Hloop_Q_A(ntryL,G0H16(9),16,0,G1H16(34),n2h16(79))
  Gcoeff(:)%j = (-(c(6)*M(3,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(184),h0tab(:,184),[16,2,13],[0,0,0],3,1,wf8(:,28))
  call Hloop_QZ_A(ntryL,G0H48(1),ex5(:),G0H16(9),ngZu,m3h3x16(:,109),heltab2x48(:,:,184))
  call Hloop_Q_A(ntryL,G0H16(9),16,0,G1H16(36),n2h16(80))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)+c(1)*M(3,:)%j) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(185),h0tab(:,185),[16,2,13],[0,0,0],3,1,wf8(:,26))
  call Hloop_QZ_A(ntryL,G0H48(1),ex5(:),G0H16(9),ngZu,m3h3x16(:,110),heltab2x48(:,:,185))
  call Hloop_Q_A(ntryL,G0H16(9),16,0,G1H16(37),n2h16(81))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)+c(4)*M(3,:)%j) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(186),h0tab(:,186),[16,2,13],[0,nMZ,0],3,1,wf8(:,26))
  call Hloop_QZ_A(ntryL,G0H48(1),ex5(:),G0H16(9),ngZu,m3h3x16(:,111),heltab2x48(:,:,186))
  call Hloop_Q_A(ntryL,G0H16(9),16,0,G1H16(38),n2h16(82))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)+c(24)*M(3,:)%j) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(187),h0tab(:,187),[16,2,13],[0,nMW,0],3,1,wf8(:,26))
  call Hloop_QZ_A(ntryL,G0H48(1),ex5(:),G0H16(9),ngZd,m3h3x16(:,112),heltab2x48(:,:,187))
  call Hloop_Q_A(ntryL,G0H16(9),16,0,G1H16(39),n2h16(83))
  Gcoeff(:)%j = (-(c(18)*M(2,:)%j)+c(14)*M(4,:)%j) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(188),h0tab(:,188),[16,2,13],[0,0,0],3,1,wf8(:,26))
  call Hloop_QZ_A(ntryL,G0H48(1),ex5(:),G0H16(9),ngZu,m3h3x16(:,113),heltab2x48(:,:,188))
  call Hloop_Q_A(ntryL,G0H16(9),16,0,G1H16(40),n2h16(84))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)+c(20)*M(3,:)%j) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(189),h0tab(:,189),[16,2,13],[nMW,0,nMW],3,1,wf8(:,26))
  call Hloop_UW_V(ntryL,G0H48(1),0,ex5(:),16,G1H16(41),m3h3x16(:,114),heltab2x48(:,:,189))
  Gcoeff(:)%j = (-(c(3)*M(3,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(190),h0tab(:,190),[16,1,14],[0,0,0],3,1,wf8(:,22))
  call Hloop_AZ_Q(ntryL,G0H48(1),ex5(:),G0H16(9),ngZu,m3h3x16(:,115),heltab2x48(:,:,190))
  call Hloop_A_Q(ntryL,G0H16(9),16,0,G1H16(42),n2h16(85))
  Gcoeff(:)%j = (-(c(6)*M(3,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(191),h0tab(:,191),[16,1,14],[0,0,0],3,1,wf8(:,24))
  call Hloop_AZ_Q(ntryL,G0H48(1),ex5(:),G0H16(9),ngZu,m3h3x16(:,116),heltab2x48(:,:,191))
  call Hloop_A_Q(ntryL,G0H16(9),16,0,G1H16(43),n2h16(86))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)+c(1)*M(3,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(192),h0tab(:,192),[16,1,14],[0,0,0],3,1,wf8(:,22))
  call Hloop_AZ_Q(ntryL,G0H48(1),ex5(:),G0H16(9),ngZu,m3h3x16(:,117),heltab2x48(:,:,192))
  call Hloop_A_Q(ntryL,G0H16(9),16,0,G1H16(44),n2h16(87))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)+c(4)*M(3,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(193),h0tab(:,193),[16,1,14],[0,nMZ,0],3,1,wf8(:,22))
  call Hloop_AZ_Q(ntryL,G0H48(1),ex5(:),G0H16(9),ngZu,m3h3x16(:,118),heltab2x48(:,:,193))
  call Hloop_A_Q(ntryL,G0H16(9),16,0,G1H16(45),n2h16(88))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)+c(24)*M(3,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(194),h0tab(:,194),[16,1,14],[0,nMW,0],3,1,wf8(:,22))
  call Hloop_AZ_Q(ntryL,G0H48(1),ex5(:),G0H16(9),ngZd,m3h3x16(:,119),heltab2x48(:,:,194))
  call Hloop_A_Q(ntryL,G0H16(9),16,0,G1H16(46),n2h16(89))
  Gcoeff(:)%j = (-(c(18)*M(2,:)%j)+c(14)*M(4,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(195),h0tab(:,195),[16,1,14],[0,0,0],3,1,wf8(:,22))
  call Hloop_AZ_Q(ntryL,G0H48(1),ex5(:),G0H16(9),ngZu,m3h3x16(:,120),heltab2x48(:,:,195))
  call Hloop_A_Q(ntryL,G0H16(9),16,0,G1H16(47),n2h16(90))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)+c(20)*M(3,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(196),h0tab(:,196),[16,1,14],[nMW,0,nMW],3,1,wf8(:,22))
  call Hloop_UV_W(ntryL,G0H48(1),0,ex5(:),16,G1H16(48),m3h3x16(:,121),heltab2x48(:,:,196))
  Gcoeff(:)%j = (c(28)*M(3,:)%j) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(197),h0tab(:,197),[28,1,2],[0,0,0],3,1,wf12(:,22))
  call Hloop_AZ_Q(ntryL,G0H48(1),wf12(:,22),G0H4(1),ngZu,m3h12x4(:,2),heltab2x48(:,:,197))
  call Hloop_A_Q(ntryL,G0H4(1),28,0,G1H4(6),n2h4(48))
  Gcoeff(:)%j = (c(32)*M(1,:)%j-c(31)*M(3,:)%j) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(198),h0tab(:,198),[19,4,8],[nMT,nMH,nMT],3,1,wf12(:,2))
  call Hloop_AV_Q(ntryL,G0H48(1),wf12(:,2),G0H4(1),m3h12x4(:,3),heltab2x48(:,:,198))
  call Hloop_A_Q(ntryL,G0H4(1),19,nMT,G1H4(9),n2h4(49))
  Gcoeff(:)%j = (-(c(32)*M(1,:)%j)+c(31)*M(3,:)%j) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(199),h0tab(:,199),[19,4,8],[nMT,nMZ,nMT],3,1,wf12(:,2))
  call Hloop_AV_Q(ntryL,G0H48(1),wf12(:,2),G0H4(1),m3h12x4(:,4),heltab2x48(:,:,199))
  call Hloop_A_Q(ntryL,G0H4(1),19,nMT,G1H4(10),n2h4(50))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j)+c(29)*M(3,:)%j) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(200),h0tab(:,200),[19,4,8],[nMB,nMW,nMB],3,1,wf12(:,2))
  call Hloop_AV_Q(ntryL,G0H48(1),wf12(:,2),G0H4(1),m3h12x4(:,5),heltab2x48(:,:,200))
  call Hloop_A_Q(ntryL,G0H4(1),19,nMB,G1H4(11),n2h4(51))
  Gcoeff(:)%j = (-(c(3)*M(3,:)%j)) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(201),h0tab(:,201),[19,4,8],[nMT,0,nMT],3,1,wf12(:,2))
  call Hloop_AV_Q(ntryL,G0H48(1),wf12(:,2),G0H4(1),m3h12x4(:,6),heltab2x48(:,:,201))
  call Hloop_A_Q(ntryL,G0H4(1),19,nMT,G1H4(14),n2h4(52))
  Gcoeff(:)%j = (-(c(6)*M(3,:)%j)) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(202),h0tab(:,202),[19,4,8],[nMT,0,nMT],3,1,wf12(:,3))
  call Hloop_AZ_Q(ntryL,G0H48(1),wf12(:,3),G0H4(1),ngZu,m3h12x4(:,7),heltab2x48(:,:,202))
  call Hloop_A_Q(ntryL,G0H4(1),19,nMT,G1H4(15),n2h4(53))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)+c(1)*M(3,:)%j) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(203),h0tab(:,203),[19,4,8],[nMT,0,nMT],3,1,wf12(:,2))
  call Hloop_AV_Q(ntryL,G0H48(1),wf12(:,2),G0H4(1),m3h12x4(:,8),heltab2x48(:,:,203))
  call Hloop_A_Q(ntryL,G0H4(1),19,nMT,G1H4(16),n2h4(54))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)+c(4)*M(3,:)%j) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(204),h0tab(:,204),[19,4,8],[nMT,nMZ,nMT],3,1,wf12(:,2))
  call Hloop_AV_Q(ntryL,G0H48(1),wf12(:,2),G0H4(1),m3h12x4(:,9),heltab2x48(:,:,204))
  call Hloop_A_Q(ntryL,G0H4(1),19,nMT,G1H4(19),n2h4(55))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)+c(24)*M(3,:)%j) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(205),h0tab(:,205),[19,4,8],[nMB,nMW,nMB],3,1,wf12(:,2))
  call Hloop_AV_Q(ntryL,G0H48(1),wf12(:,2),G0H4(1),m3h12x4(:,10),heltab2x48(:,:,205))
  call Hloop_A_Q(ntryL,G0H4(1),19,nMB,G1H4(20),n2h4(56))
  Gcoeff(:)%j = (c(12)*M(2,:)%j-c(11)*M(4,:)%j) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(206),h0tab(:,206),[19,4,8],[nMT,0,nMT],3,1,wf12(:,2))
  call Hloop_AV_Q(ntryL,G0H48(1),wf12(:,2),G0H4(1),m3h12x4(:,11),heltab2x48(:,:,206))
  call Hloop_A_Q(ntryL,G0H4(1),19,nMT,G1H4(21),n2h4(57))
  Gcoeff(:)%j = (c(8)*M(2,:)%j-c(7)*M(4,:)%j) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(207),h0tab(:,207),[19,4,8],[0,nMT,0],3,1,wf12(:,2))
  call Hloop_UV_W(ntryL,G0H48(1),0,wf12(:,2),19,G1H4(24),m3h12x4(:,12),heltab2x48(:,:,207))
  Gcoeff(:)%j = (c(32)*M(1,:)%j-c(31)*M(3,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(208),h0tab(:,208),[19,4,8],[nMT,nMH,nMT],3,1,wf12(:,4))
  call Hloop_AV_Q(ntryL,G0H48(1),wf12(:,4),G0H4(1),m3h12x4(:,13),heltab2x48(:,:,208))
  call Hloop_A_Q(ntryL,G0H4(1),19,nMT,G1H4(26),n2h4(58))
  Gcoeff(:)%j = (-(c(32)*M(1,:)%j)+c(31)*M(3,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(209),h0tab(:,209),[19,4,8],[nMT,nMZ,nMT],3,1,wf12(:,4))
  call Hloop_AV_Q(ntryL,G0H48(1),wf12(:,4),G0H4(1),m3h12x4(:,14),heltab2x48(:,:,209))
  call Hloop_A_Q(ntryL,G0H4(1),19,nMT,G1H4(27),n2h4(59))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j)+c(29)*M(3,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(210),h0tab(:,210),[19,4,8],[nMB,nMW,nMB],3,1,wf12(:,4))
  call Hloop_AV_Q(ntryL,G0H48(1),wf12(:,4),G0H4(1),m3h12x4(:,15),heltab2x48(:,:,210))
  call Hloop_A_Q(ntryL,G0H4(1),19,nMB,G1H4(30),n2h4(60))
  Gcoeff(:)%j = (-(c(3)*M(3,:)%j)) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(211),h0tab(:,211),[19,4,8],[nMT,0,nMT],3,1,wf12(:,4))
  call Hloop_AV_Q(ntryL,G0H48(1),wf12(:,4),G0H4(1),m3h12x4(:,16),heltab2x48(:,:,211))
  call Hloop_A_Q(ntryL,G0H4(1),19,nMT,G1H4(31),n2h4(61))
  Gcoeff(:)%j = (-(c(6)*M(3,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(212),h0tab(:,212),[19,4,8],[nMT,0,nMT],3,1,wf12(:,5))
  call Hloop_AZ_Q(ntryL,G0H48(1),wf12(:,5),G0H4(1),ngZu,m3h12x4(:,17),heltab2x48(:,:,212))
  call Hloop_A_Q(ntryL,G0H4(1),19,nMT,G1H4(32),n2h4(62))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)+c(1)*M(3,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(213),h0tab(:,213),[19,4,8],[nMT,0,nMT],3,1,wf12(:,4))
  call Hloop_AV_Q(ntryL,G0H48(1),wf12(:,4),G0H4(1),m3h12x4(:,18),heltab2x48(:,:,213))
  call Hloop_A_Q(ntryL,G0H4(1),19,nMT,G1H4(35),n2h4(63))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)+c(4)*M(3,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(214),h0tab(:,214),[19,4,8],[nMT,nMZ,nMT],3,1,wf12(:,4))
  call Hloop_AV_Q(ntryL,G0H48(1),wf12(:,4),G0H4(1),m3h12x4(:,19),heltab2x48(:,:,214))
  call Hloop_A_Q(ntryL,G0H4(1),19,nMT,G1H4(36),n2h4(64))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)+c(24)*M(3,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(215),h0tab(:,215),[19,4,8],[nMB,nMW,nMB],3,1,wf12(:,4))
  call Hloop_AV_Q(ntryL,G0H48(1),wf12(:,4),G0H4(1),m3h12x4(:,20),heltab2x48(:,:,215))
  call Hloop_A_Q(ntryL,G0H4(1),19,nMB,G1H4(37),n2h4(65))
  Gcoeff(:)%j = (c(12)*M(2,:)%j-c(11)*M(4,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(216),h0tab(:,216),[19,4,8],[nMT,0,nMT],3,1,wf12(:,4))
  call Hloop_AV_Q(ntryL,G0H48(1),wf12(:,4),G0H4(1),m3h12x4(:,21),heltab2x48(:,:,216))
  call Hloop_A_Q(ntryL,G0H4(1),19,nMT,G1H4(40),n2h4(66))
  Gcoeff(:)%j = (c(8)*M(2,:)%j-c(7)*M(4,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(217),h0tab(:,217),[19,4,8],[0,nMT,0],3,1,wf12(:,4))
  call Hloop_UV_W(ntryL,G0H48(1),0,wf12(:,4),19,G1H4(41),m3h12x4(:,22),heltab2x48(:,:,217))
  Gcoeff(:)%j = (-(c(3)*M(3,:)%j)) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(218),h0tab(:,218),[28,1,2],[0,0,0],3,1,wf12(:,20))
  call Hloop_AV_Q(ntryL,G0H48(1),wf12(:,20),G0H4(1),m3h12x4(:,23),heltab2x48(:,:,218))
  call Hloop_A_Q(ntryL,G0H4(1),28,0,G1H4(42),n2h4(67))
  Gcoeff(:)%j = (-(c(6)*M(3,:)%j)) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(219),h0tab(:,219),[28,1,2],[0,0,0],3,1,wf12(:,23))
  call Hloop_AZ_Q(ntryL,G0H48(1),wf12(:,23),G0H4(1),ngZu,m3h12x4(:,24),heltab2x48(:,:,219))
  call Hloop_A_Q(ntryL,G0H4(1),28,0,G1H4(45),n2h4(68))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)+c(1)*M(3,:)%j) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(220),h0tab(:,220),[28,1,2],[0,0,0],3,1,wf12(:,20))
  call Hloop_AV_Q(ntryL,G0H48(1),wf12(:,20),G0H4(1),m3h12x4(:,25),heltab2x48(:,:,220))
  call Hloop_A_Q(ntryL,G0H4(1),28,0,G1H4(46),n2h4(69))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)+c(4)*M(3,:)%j) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(221),h0tab(:,221),[28,1,2],[0,nMZ,0],3,1,wf12(:,20))
  call Hloop_AV_Q(ntryL,G0H48(1),wf12(:,20),G0H4(1),m3h12x4(:,26),heltab2x48(:,:,221))
  call Hloop_A_Q(ntryL,G0H4(1),28,0,G1H4(47),n2h4(70))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)+c(24)*M(3,:)%j) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(222),h0tab(:,222),[28,1,2],[0,nMW,0],3,1,wf12(:,20))
  call Hloop_AV_Q(ntryL,G0H48(1),wf12(:,20),G0H4(1),m3h12x4(:,27),heltab2x48(:,:,222))
  call Hloop_A_Q(ntryL,G0H4(1),28,0,G1H4(48),n2h4(71))
  Gcoeff(:)%j = (c(12)*M(2,:)%j-c(11)*M(4,:)%j) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(223),h0tab(:,223),[28,1,2],[0,0,0],3,1,wf12(:,20))
  call Hloop_AV_Q(ntryL,G0H48(1),wf12(:,20),G0H4(1),m3h12x4(:,28),heltab2x48(:,:,223))
  call Hloop_A_Q(ntryL,G0H4(1),28,0,G1H4(49),n2h4(72))
  Gcoeff(:)%j = (c(8)*M(2,:)%j-c(7)*M(4,:)%j) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(224),h0tab(:,224),[28,1,2],[0,0,0],3,1,wf12(:,20))
  call Hloop_UV_W(ntryL,G0H48(1),0,wf12(:,20),28,G1H4(50),m3h12x4(:,29),heltab2x48(:,:,224))
  Gcoeff(:)%j = (-(c(3)*M(3,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(225),h0tab(:,225),[28,1,2],[0,0,0],3,1,wf12(:,21))
  call Hloop_AV_Q(ntryL,G0H48(1),wf12(:,21),G0H4(1),m3h12x4(:,30),heltab2x48(:,:,225))
  call Hloop_A_Q(ntryL,G0H4(1),28,0,G1H4(51),n2h4(73))
  Gcoeff(:)%j = (-(c(6)*M(3,:)%j)) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(226),h0tab(:,226),[28,1,2],[0,0,0],3,1,wf12(:,24))
  call Hloop_AZ_Q(ntryL,G0H48(1),wf12(:,24),G0H4(1),ngZu,m3h12x4(:,31),heltab2x48(:,:,226))
  call Hloop_A_Q(ntryL,G0H4(1),28,0,G1H4(52),n2h4(74))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)+c(1)*M(3,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(227),h0tab(:,227),[28,1,2],[0,0,0],3,1,wf12(:,21))
  call Hloop_AV_Q(ntryL,G0H48(1),wf12(:,21),G0H4(1),m3h12x4(:,32),heltab2x48(:,:,227))
  call Hloop_A_Q(ntryL,G0H4(1),28,0,G1H4(53),n2h4(75))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)+c(4)*M(3,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(228),h0tab(:,228),[28,1,2],[0,nMZ,0],3,1,wf12(:,21))
  call Hloop_AV_Q(ntryL,G0H48(1),wf12(:,21),G0H4(1),m3h12x4(:,33),heltab2x48(:,:,228))
  call Hloop_A_Q(ntryL,G0H4(1),28,0,G1H4(54),n2h4(76))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)+c(24)*M(3,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(229),h0tab(:,229),[28,1,2],[0,nMW,0],3,1,wf12(:,21))
  call Hloop_AV_Q(ntryL,G0H48(1),wf12(:,21),G0H4(1),m3h12x4(:,34),heltab2x48(:,:,229))
  call Hloop_A_Q(ntryL,G0H4(1),28,0,G1H4(55),n2h4(77))
  Gcoeff(:)%j = (c(12)*M(2,:)%j-c(11)*M(4,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(230),h0tab(:,230),[28,1,2],[0,0,0],3,1,wf12(:,21))
  call Hloop_AV_Q(ntryL,G0H48(1),wf12(:,21),G0H4(1),m3h12x4(:,35),heltab2x48(:,:,230))
  call Hloop_A_Q(ntryL,G0H4(1),28,0,G1H4(56),n2h4(78))
  Gcoeff(:)%j = (c(8)*M(2,:)%j-c(7)*M(4,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(231),h0tab(:,231),[28,1,2],[0,0,0],3,1,wf12(:,21))
  call Hloop_UV_W(ntryL,G0H48(1),0,wf12(:,21),28,G1H4(57),m3h12x4(:,36),heltab2x48(:,:,231))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(23),[G1H8(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(22),[G1H8(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(24),[G1H8(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(4),[G1H8(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(26),[G1H16(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(32),[G1H16(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(10),[G1H8(27),G1H8(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(12),[G1H8(18),G1H8(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(9),[G1H16(4),G1H16(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(31),[G1H16(27),G1H16(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(40),[G1H4(35),G1H4(32),G1H4(31),G1H4(21),G1H4(16) &
    ,G1H4(15),G1H4(14),G1H4(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(1),[G0H8(17),G0H8(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(9),[G0H8(4),G0H8(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(40),[G1H16(37),G1H16(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(47),[G1H16(44),G1H16(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(56),[G1H4(53),G1H4(52),G1H4(51),G1H4(49),G1H4(46) &
    ,G1H4(45),G1H4(42),G1H4(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(26),[G1H4(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(27),[G1H4(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(30),[G1H4(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(36),[G1H4(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(37),[G1H4(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(41),[G1H4(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(54),[G1H4(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(55),[G1H4(48)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(57),[G1H4(50)])
  call Hloop_QV_A(ntryL,G1H8(23),wf4(:,3),G1H2(38),m3h4x2(:,19),heltab2x8(:,:,72))
  call Hloop_Q_A(ntryL,G1H2(38),23,nMT,G2H2(14),n2h2(33))
  call Hloop_QV_A(ntryL,G1H8(22),wf4(:,3),G1H2(42),m3h4x2(:,20),heltab2x8(:,:,73))
  call Hloop_Q_A(ntryL,G1H2(42),23,nMT,G2H2(15),n2h2(34))
  call Hloop_QV_A(ntryL,G1H8(24),wf4(:,3),G1H2(43),m3h4x2(:,21),heltab2x8(:,:,74))
  call Hloop_Q_A(ntryL,G1H2(43),23,nMB,G2H2(1),n2h2(35))
  call Hloop_QV_A(ntryL,G1H8(4),wf4(:,3),G1H2(44),m3h4x2(:,22),heltab2x8(:,:,75))
  call Hloop_Q_A(ntryL,G1H2(44),23,nMB,G2H2(2),n2h2(36))
  call Hloop_QV_A(ntryL,G1H8(7),wf4(:,4),G1H2(48),m3h4x2(:,23),heltab2x8(:,:,76))
  call Hloop_Q_A(ntryL,G1H2(48),29,0,G2H2(3),n2h2(37))
  call Hloop_AV_Q(ntryL,G1H16(26),wf4(:,3),G1H4(35),m3h4x4(:,15),heltab2x16(:,:,50))
  call Hloop_A_Q(ntryL,G1H4(35),19,0,G2H4(8),n2h4(79))
  call Hloop_AV_Q(ntryL,G1H16(6),wf4(:,3),G1H4(32),m3h4x4(:,16),heltab2x16(:,:,51))
  call Hloop_A_Q(ntryL,G1H4(32),19,nMT,G2H4(9),n2h4(80))
  call Hloop_QV_A(ntryL,G1H16(32),wf4(:,3),G1H4(31),m3h4x4(:,17),heltab2x16(:,:,52))
  call Hloop_Q_A(ntryL,G1H4(31),19,0,G2H4(10),n2h4(81))
  call Hloop_QV_A(ntryL,G1H16(8),wf4(:,3),G1H4(21),m3h4x4(:,18),heltab2x16(:,:,53))
  call Hloop_Q_A(ntryL,G1H4(21),19,nMT,G2H4(12),n2h4(82))
  call Hloop_AV_Q(ntryL,G1H16(24),wf4(:,3),G1H4(16),m3h4x4(:,19),heltab2x16(:,:,54))
  call Hloop_A_Q(ntryL,G1H4(16),19,nMB,G2H4(13),n2h4(83))
  call Hloop_QV_A(ntryL,G1H16(30),wf4(:,3),G1H4(15),m3h4x4(:,20),heltab2x16(:,:,55))
  call Hloop_Q_A(ntryL,G1H4(15),19,nMB,G2H4(14),n2h4(84))
  call Hloop_QV_A(ntryL,G1H8(10),wf4(:,3),G1H2(49),m3h4x2(:,24),heltab2x8(:,:,77))
  call Hloop_Q_A(ntryL,G1H2(49),23,nMT,G2H2(4),n2h2(38))
  call Hloop_QZ_A(ntryL,G1H8(26),wf4(:,1),G1H2(8),ngZu,m3h4x2(:,25),heltab2x8(:,:,78))
  call Hloop_Q_A(ntryL,G1H2(8),23,nMT,G2H2(5),n2h2(39))
  call Hloop_QV_A(ntryL,G1H8(5),wf4(:,3),G1H2(12),m3h4x2(:,26),heltab2x8(:,:,79))
  call Hloop_Q_A(ntryL,G1H2(12),23,nMT,G2H2(6),n2h2(40))
  call Hloop_UV_W(ntryL,G0H8(3),20,wf4(:,3),3,G1H2(18),m3h4x2(:,27),heltab2x8(:,:,80))
  call Hloop_AV_Q(ntryL,G1H8(8),wf4(:,3),G1H2(19),m3h4x2(:,28),heltab2x8(:,:,81))
  call Hloop_A_Q(ntryL,G1H2(19),27,nMT,G2H2(7),n2h2(41))
  call Hloop_AV_Q(ntryL,G1H8(9),wf4(:,3),G1H2(20),m3h4x2(:,29),heltab2x8(:,:,82))
  call Hloop_A_Q(ntryL,G1H2(20),27,nMT,G2H2(8),n2h2(42))
  call Hloop_AV_Q(ntryL,G1H8(13),wf4(:,3),G1H2(50),m3h4x2(:,30),heltab2x8(:,:,83))
  call Hloop_A_Q(ntryL,G1H2(50),27,nMB,G2H2(9),n2h2(43))
  call Hloop_AV_Q(ntryL,G1H8(12),wf4(:,3),G1H2(54),m3h4x2(:,31),heltab2x8(:,:,84))
  call Hloop_A_Q(ntryL,G1H2(54),27,nMT,G2H2(10),n2h2(44))
  call Hloop_AZ_Q(ntryL,G1H8(20),wf4(:,1),G1H2(55),ngZu,m3h4x2(:,32),heltab2x8(:,:,85))
  call Hloop_A_Q(ntryL,G1H2(55),27,nMT,G2H2(11),n2h2(45))
  call Hloop_AV_Q(ntryL,G1H8(11),wf4(:,3),G1H2(61),m3h4x2(:,33),heltab2x8(:,:,86))
  call Hloop_A_Q(ntryL,G1H2(61),27,nMT,G2H2(12),n2h2(46))
  call Hloop_AV_Q(ntryL,G1H8(17),wf4(:,3),G1H2(62),m3h4x2(:,34),heltab2x8(:,:,87))
  call Hloop_A_Q(ntryL,G1H2(62),27,nMB,G2H2(13),n2h2(47))
  call Hloop_UV_W(ntryL,G0H8(19),24,wf4(:,3),3,G1H2(66),m3h4x2(:,35),heltab2x8(:,:,88))
  call Hloop_AQ_S(ntryL,G1H16(2),wf8(:,19),G1H2(72),ngH,m3h8x2(:,1),heltab2x16(:,:,56))
  call Hloop_AQ_S(ntryL,G1H16(1),wf8(:,19),G1H2(1),ngX,m3h8x2(:,2),heltab2x16(:,:,57))
  call Hloop_AQ_S(ntryL,G1H16(7),wf8(:,19),G1H2(2),ngPbt,m3h8x2(:,3),heltab2x16(:,:,58))
  call Hloop_SQ_A(ntryL,G1H16(5),wf8(:,19),G1H2(3),ngX,m3h8x2(:,4),heltab2x16(:,:,59))
  call Hloop_Q_A(ntryL,G1H2(3),23,nMT,G2H2(16),n2h2(48))
  call Hloop_SQ_A(ntryL,G1H16(12),wf8(:,19),G1H2(4),ngH,m3h8x2(:,5),heltab2x16(:,:,60))
  call Hloop_Q_A(ntryL,G1H2(4),23,nMT,G2H2(17),n2h2(49))
  call Hloop_SQ_A(ntryL,G1H16(17),wf8(:,19),G1H2(23),ngPbt,m3h8x2(:,6),heltab2x16(:,:,61))
  call Hloop_Q_A(ntryL,G1H2(23),23,nMB,G2H2(18),n2h2(50))
  call Hloop_AQ_V(ntryL,G1H16(9),wf8(:,19),G1H2(11),m3h8x2(:,7),heltab2x16(:,:,62))
  call Hloop_AQ_V(ntryL,G1H16(3),wf8(:,20),G1H2(15),m3h8x2(:,8),heltab2x16(:,:,63))
  call Hloop_AQ_Z(ntryL,G1H16(10),wf8(:,19),G1H2(17),ngZu,m3h8x2(:,9),heltab2x16(:,:,64))
  call Hloop_AQ_W(ntryL,G1H16(20),wf8(:,19),G1H2(27),m3h8x2(:,10),heltab2x16(:,:,65))
  call Hloop_ZQ_A(ntryL,G0H16(4),wf8(:,19),G0H2(1),ngZu,m3h8x2(:,11),heltab2x16(:,:,66))
  call Hloop_Q_A(ntryL,G0H2(1),23,nMT,G1H2(33),n2h2(51))
  call Hloop_WQ_A(ntryL,G0H16(5),wf8(:,19),G0H2(1),m3h8x2(:,12),heltab2x16(:,:,67))
  call Hloop_Q_A(ntryL,G0H2(1),23,nMB,G1H2(40),n2h2(52))
  call Hloop_SQ_A(ntryL,G0H16(1),wf8(:,19),G0H2(1),ngH,m3h8x2(:,13),heltab2x16(:,:,68))
  call Hloop_Q_A(ntryL,G0H2(1),23,nMT,G1H2(47),n2h2(53))
  call Hloop_SQ_A(ntryL,G0H16(2),wf8(:,19),G0H2(1),ngPbt,m3h8x2(:,14),heltab2x16(:,:,69))
  call Hloop_Q_A(ntryL,G0H2(1),23,nMB,G1H2(53),n2h2(54))
  call Hloop_WQ_A(ntryL,G1H16(13),wf8(:,19),G1H2(58),m3h8x2(:,15),heltab2x16(:,:,70))
  call Hloop_Q_A(ntryL,G1H2(58),23,nMB,G2H2(19),n2h2(55))
  call Hloop_AQ_S(ntryL,G1H16(14),ex3(:),G1H8(30),ngH,m3h2x8(:,36),heltab2x16(:,:,71))
  call Hloop_AQ_S(ntryL,G1H16(18),ex3(:),G1H8(16),ngX,m3h2x8(:,37),heltab2x16(:,:,72))
  call Hloop_AQ_S(ntryL,G1H16(19),ex3(:),G1H8(1),ngPbt,m3h2x8(:,38),heltab2x16(:,:,73))
  call Hloop_SQ_A(ntryL,G1H16(21),ex3(:),G1H8(2),ngH,m3h2x8(:,39),heltab2x16(:,:,74))
  call Hloop_Q_A(ntryL,G1H8(2),20,nMT,G2H8(1),n2h8(59))
  call Hloop_SQ_A(ntryL,G1H16(22),ex3(:),G1H8(21),ngX,m3h2x8(:,40),heltab2x16(:,:,75))
  call Hloop_Q_A(ntryL,G1H8(21),20,nMT,G2H8(2),n2h8(60))
  call Hloop_SQ_A(ntryL,G1H16(23),ex3(:),G1H8(3),ngPbt,m3h2x8(:,41),heltab2x16(:,:,76))
  call Hloop_Q_A(ntryL,G1H8(3),20,nMB,G2H8(3),n2h8(61))
  call Hloop_AQ_V(ntryL,G1H16(31),ex3(:),G1H8(15),m3h2x8(:,42),heltab2x16(:,:,77))
  call Hloop_AQ_V(ntryL,G1H16(25),ex3(:),G1H8(19),m3h2x8(:,43),heltab2x16(:,:,78))
  call Hloop_AQ_Z(ntryL,G1H16(28),ex3(:),G1H8(28),ngZu,m3h2x8(:,44),heltab2x16(:,:,79))
  call Hloop_AQ_W(ntryL,G1H16(35),ex3(:),G1H8(27),m3h2x8(:,45),heltab2x16(:,:,80))
  call Hloop_SQ_A(ntryL,G0H16(3),ex3(:),G0H8(13),ngH,m3h2x8(:,46),heltab2x16(:,:,81))
  call Hloop_Q_A(ntryL,G0H8(13),20,nMT,G1H8(25),n2h8(62))
  call Hloop_SQ_A(ntryL,G0H16(6),ex3(:),G0H8(14),ngPbt,m3h2x8(:,47),heltab2x16(:,:,82))
  call Hloop_Q_A(ntryL,G0H8(14),20,nMB,G1H8(18),n2h8(63))
  call Hloop_ZQ_A(ntryL,G0H16(7),ex3(:),G0H8(20),ngZu,m3h2x8(:,48),heltab2x16(:,:,83))
  call Hloop_Q_A(ntryL,G0H8(20),20,nMT,G1H8(14),n2h8(64))
  call Hloop_WQ_A(ntryL,G0H16(8),ex3(:),G0H8(18),m3h2x8(:,49),heltab2x16(:,:,84))
  call Hloop_Q_A(ntryL,G0H8(18),20,nMB,G1H8(23),n2h8(65))
  call Hloop_WQ_A(ntryL,G1H16(33),ex3(:),G1H8(22),m3h2x8(:,50),heltab2x16(:,:,85))
  call Hloop_Q_A(ntryL,G1H8(22),20,nMB,G2H8(4),n2h8(66))
  call Hloop_AQ_V(ntryL,G1H4(40),ex3(:),G1H2(36),m3h2x2(:,53),heltab2x4(:,:,77))
  call Hloop_VA_Q(ntryL,G0H8(1),ex2(:),G0H4(1),m3h2x4(:,54),heltab2x8(:,:,89))
  call Hloop_A_Q(ntryL,G0H4(1),19,0,G1H4(14),n2h4(85))
  call Hloop_VA_Q(ntryL,G0H8(11),ex2(:),G0H4(1),m3h2x4(:,55),heltab2x8(:,:,90))
  call Hloop_A_Q(ntryL,G0H4(1),19,0,G1H4(3),n2h4(86))
  call Hloop_ZA_Q(ntryL,G0H8(16),ex2(:),G0H4(1),ngZu,m3h2x4(:,56),heltab2x8(:,:,91))
  call Hloop_A_Q(ntryL,G0H4(1),19,0,G1H4(53),n2h4(87))
  call Hloop_WA_Q(ntryL,G0H8(2),ex2(:),G0H4(1),m3h2x4(:,57),heltab2x8(:,:,92))
  call Hloop_A_Q(ntryL,G0H4(1),19,0,G1H4(52),n2h4(88))
  call Hloop_QA_V(ntryL,G1H8(6),ex2(:),G1H4(51),m3h2x4(:,58),heltab2x8(:,:,93))
  call Hloop_VQ_A(ntryL,G0H8(9),ex1(:),G0H4(1),m3h2x4(:,59),heltab2x8(:,:,94))
  call Hloop_Q_A(ntryL,G0H4(1),19,0,G1H4(49),n2h4(89))
  call Hloop_VQ_A(ntryL,G0H8(5),ex1(:),G0H4(1),m3h2x4(:,60),heltab2x8(:,:,95))
  call Hloop_Q_A(ntryL,G0H4(1),19,0,G1H4(46),n2h4(90))
  call Hloop_ZQ_A(ntryL,G0H8(10),ex1(:),G0H4(1),ngZu,m3h2x4(:,61),heltab2x8(:,:,96))
  call Hloop_Q_A(ntryL,G0H4(1),19,0,G1H4(45),n2h4(91))
  call Hloop_WQ_A(ntryL,G0H8(8),ex1(:),G0H4(1),m3h2x4(:,62),heltab2x8(:,:,97))
  call Hloop_Q_A(ntryL,G0H4(1),19,0,G1H4(42),n2h4(92))
  call Hloop_AQ_V(ntryL,G1H8(29),ex1(:),G1H4(6),m3h2x4(:,63),heltab2x8(:,:,98))
  call Hloop_QA_V(ntryL,G1H16(40),ex2(:),G1H8(24),m3h2x8(:,51),heltab2x16(:,:,86))
  call Hloop_QA_V(ntryL,G1H16(36),ex2(:),G1H8(4),m3h2x8(:,52),heltab2x16(:,:,87))
  call Hloop_QA_Z(ntryL,G1H16(38),ex2(:),G1H8(7),ngZu,m3h2x8(:,53),heltab2x16(:,:,88))
  call Hloop_QA_W(ntryL,G1H16(39),ex2(:),G1H8(10),m3h2x8(:,54),heltab2x16(:,:,89))
  call Hloop_WA_Q(ntryL,G1H16(41),ex2(:),G1H8(26),m3h2x8(:,55),heltab2x16(:,:,90))
  call Hloop_A_Q(ntryL,G1H8(26),18,0,G2H8(5),n2h8(67))
  call Hloop_AQ_V(ntryL,G1H16(47),ex1(:),G1H8(5),m3h2x8(:,56),heltab2x16(:,:,91))
  call Hloop_AQ_V(ntryL,G1H16(43),ex1(:),G1H8(8),m3h2x8(:,57),heltab2x16(:,:,92))
  call Hloop_AQ_Z(ntryL,G1H16(45),ex1(:),G1H8(9),ngZu,m3h2x8(:,58),heltab2x16(:,:,93))
  call Hloop_AQ_W(ntryL,G1H16(46),ex1(:),G1H8(13),m3h2x8(:,59),heltab2x16(:,:,94))
  call Hloop_WQ_A(ntryL,G1H16(48),ex1(:),G1H8(12),m3h2x8(:,60),heltab2x16(:,:,95))
  call Hloop_Q_A(ntryL,G1H8(12),17,0,G2H8(6),n2h8(68))
  call Hloop_AQ_V(ntryL,G1H4(56),ex1(:),G1H2(35),m3h2x2(:,54),heltab2x4(:,:,78))
  call Hloop_AQ_S(ntryL,G1H4(26),ex3(:),G1H2(37),ngH,m3h2x2(:,55),heltab2x4(:,:,79))
  call Hloop_AQ_S(ntryL,G1H4(27),ex3(:),G1H2(26),ngX,m3h2x2(:,56),heltab2x4(:,:,80))
  call Hloop_AQ_S(ntryL,G1H4(30),ex3(:),G1H2(34),ngPbt,m3h2x2(:,57),heltab2x4(:,:,81))
  call Hloop_AQ_Z(ntryL,G1H4(36),ex3(:),G1H2(30),ngZu,m3h2x2(:,58),heltab2x4(:,:,82))
  call Hloop_AQ_W(ntryL,G1H4(37),ex3(:),G1H2(39),m3h2x2(:,59),heltab2x4(:,:,83))
  call Hloop_VQ_A(ntryL,G1H4(41),ex3(:),G1H2(46),m3h2x2(:,60),heltab2x4(:,:,84))
  call Hloop_Q_A(ntryL,G1H2(46),23,nMT,G2H2(20),n2h2(56))
  call Hloop_AQ_Z(ntryL,G1H4(54),ex1(:),G1H2(45),ngZu,m3h2x2(:,61),heltab2x4(:,:,85))
  call Hloop_AQ_W(ntryL,G1H4(55),ex1(:),G1H2(52),m3h2x2(:,62),heltab2x4(:,:,86))
  call Hloop_VQ_A(ntryL,G1H4(57),ex1(:),G1H2(71),m3h2x2(:,63),heltab2x4(:,:,87))
  call Hloop_Q_A(ntryL,G1H2(71),29,0,G2H2(21),n2h2(57))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(17),[G2H2(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(16),[G2H2(32),G1H2(33)])
call ol_merge_last(G1H4(1), G1H4(1)) 
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1),[G1H4(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(18),[G2H2(35),G1H2(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(19),[G2H2(38),G1H2(53)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(42),[G1H4(43)])
call HGT_w2_OLR(G1H4(2),1,1,4)
call HGT_w2_invQ_OLR(G1H4(2),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(2),[G1H4(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(18),[G1H2(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(15),[G1H2(11),G1H2(51),G1H2(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(37),[G1H2(32)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(72),[G1H2(10)])



end subroutine vamp_1

end module ol_vamp_1_ppztt_ew_uuxttxz_1_/**/REALKIND
