! 2
! The number above is the number of vamp routines for this process.
! This is needed by the build system.

#if 3 > 1
#ifndef USE_CHECK_qp
#define DUMMY_qp
#endif
#else
#ifndef USE_qp
#define DUMMY_qp
#endif
#endif

module ol_vamp_ppztt_ew_ttxddxz_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  real(REALKIND):: M2L0cache, M2L1cache
  contains

! **********************************************************************
  subroutine redbaseconstr()
! **********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_data_types_/**/REALKIND, only: basis
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_tensor_sum_storage_ppztt_ew_ttxddxz_1_/**/REALKIND
  use ofred_basis_construction_/**/REALKIND, only: construct_RedBasis, construct_redset4
  use ofred_basis_construction_/**/REALKIND, only: construct_redset5
  implicit none

  ! Define mass sets for reduction
  mass5set(0:4,1) = [0,0,0,nMT,0]
  mass5set(0:4,2) = [0,0,nMZ,nMT,0]
  mass5set(0:4,3) = [0,0,0,nMT,nMZ]
  mass5set(0:4,4) = [nMT,nMT,0,0,0]
  mass5set(0:4,5) = [nMT,nMT,nMZ,0,0]
  mass5set(0:4,6) = [nMT,nMT,0,0,nMZ]
  mass5set(0:4,7) = [nMZ,nMH,nMT,0,0]
mass4set(0:3,1) = [nMW,nMW,0,0]
mass4set(0:3,2) = [nMZ,nMH,nMT,nMT]
mass4set(0:3,3) = [nMH,nMZ,nMT,nMT]
mass4set(0:3,4) = [nMW,nMW,nMB,nMB]
mass4set(0:3,5) = [0,0,0,0]
mass4set(0:3,6) = [nMT,nMT,0,0]
mass4set(0:3,7) = [0,0,0,nMZ]
mass4set(0:3,8) = [0,0,0,nMW]
mass4set(0:3,9) = [nMT,nMT,nMH,nMT]
mass4set(0:3,10) = [nMT,nMT,nMZ,nMT]
mass4set(0:3,11) = [nMB,nMB,nMW,nMB]
mass4set(0:3,12) = [nMT,nMT,0,nMT]
mass4set(0:3,13) = [0,0,0,nMT]
mass4set(0:3,14) = [0,0,nMZ,nMT]
mass4set(0:3,15) = [nMZ,0,0,nMT]
mass4set(0:3,16) = [0,nMT,0,0]
mass4set(0:3,17) = [0,nMT,nMZ,0]
mass4set(0:3,18) = [nMT,nMT,nMZ,0]
mass4set(0:3,19) = [nMZ,nMT,0,0]
mass4set(0:3,20) = [0,0,nMT,0]
mass4set(0:3,21) = [0,nMZ,nMT,0]
mass4set(0:3,22) = [0,0,nMZ,0]
mass4set(0:3,23) = [0,0,nMT,nMZ]
mass4set(0:3,24) = [nMT,0,0,0]
mass4set(0:3,25) = [nMT,nMZ,0,0]
mass4set(0:3,26) = [nMT,0,0,nMZ]
mass4set(0:3,27) = [nMT,nMT,0,nMZ]
mass4set(0:3,28) = [0,nMH,nMT,0]
mass4set(0:3,29) = [nMZ,nMH,0,0]
mass4set(0:3,30) = [nMZ,nMH,nMT,0]
  mass3set(0:2,1) = [nMW,nMW,0]
  mass3set(0:2,2) = [nMZ,nMH,nMT]
  mass3set(0:2,3) = [nMH,nMZ,nMT]
  mass3set(0:2,4) = [nMW,nMW,nMB]
  mass3set(0:2,5) = [0,0,0]
  mass3set(0:2,6) = [0,nMT,0]
  mass3set(0:2,7) = [nMT,nMT,0]
  mass3set(0:2,8) = [nMZ,0,0]
  mass3set(0:2,9) = [nMW,0,0]
  mass3set(0:2,10) = [nMT,nMT,nMH]
  mass3set(0:2,11) = [nMT,nMT,nMZ]
  mass3set(0:2,12) = [nMB,nMB,nMW]
  mass3set(0:2,13) = [0,0,nMT]
  mass3set(0:2,14) = [0,0,nMZ]
  mass3set(0:2,15) = [nMT,0,0]
  mass3set(0:2,16) = [nMT,nMH,nMT]
  mass3set(0:2,17) = [nMZ,nMT,nMT]
  mass3set(0:2,18) = [0,nMW,0]
  mass3set(0:2,19) = [nMT,nMZ,nMT]
  mass3set(0:2,20) = [nMH,nMT,nMT]
  mass3set(0:2,21) = [nMB,nMW,nMB]
  mass3set(0:2,22) = [nMW,nMB,nMB]
  mass3set(0:2,23) = [0,0,nMW]
  mass3set(0:2,24) = [nMT,nMT,nMT]
  mass3set(0:2,25) = [nMB,nMB,nMB]
  mass3set(0:2,26) = [nMT,0,nMT]
  mass3set(0:2,27) = [nMT,0,nMZ]
  mass3set(0:2,28) = [0,nMZ,nMT]
  mass3set(0:2,29) = [nMZ,0,nMT]
  mass3set(0:2,30) = [0,nMT,nMZ]
  mass3set(0:2,31) = [0,nMZ,0]
  mass3set(0:2,32) = [nMT,nMZ,0]
  mass3set(0:2,33) = [nMZ,nMT,0]
mass2set(0:1,1) = [0,0]
mass2set(0:1,2) = [nMT,nMT]
mass2set(0:1,3) = [nMB,nMB]
mass2set(0:1,4) = [0,nMT]
mass2set(0:1,5) = [nMT,0]
mass2set(0:1,6) = [nMZ,0]
mass2set(0:1,7) = [nMW,0]
mass2set(0:1,8) = [nMT,nMH]
mass2set(0:1,9) = [nMT,nMZ]
mass2set(0:1,10) = [nMB,nMW]
mass2set(0:1,11) = [0,nMZ]
mass2set(0:1,12) = [nMZ,nMT]
mass2set(0:1,13) = [0,nMW]
mass2set(0:1,14) = [nMH,nMT]
mass2set(0:1,15) = [nMW,nMB]


  ! Compute reduction bases from external momentum pairs p1, p2 (in light cone rep)
  call construct_RedBasis(16,20,RedBasis(1))
  call construct_RedBasis(16,21,RedBasis(2))
  call construct_RedBasis(16,23,RedBasis(3))
  call construct_RedBasis(20,21,RedBasis(4))
  call construct_RedBasis(20,23,RedBasis(5))
  call construct_RedBasis(21,23,RedBasis(6))
  call construct_RedBasis(16,22,RedBasis(7))
  call construct_RedBasis(20,22,RedBasis(8))
  call construct_RedBasis(22,23,RedBasis(9))
  call construct_RedBasis(16,17,RedBasis(10))
  call construct_RedBasis(16,29,RedBasis(11))
  call construct_RedBasis(17,21,RedBasis(12))
  call construct_RedBasis(17,29,RedBasis(13))
  call construct_RedBasis(21,29,RedBasis(14))
  call construct_RedBasis(16,25,RedBasis(15))
  call construct_RedBasis(17,25,RedBasis(16))
  call construct_RedBasis(25,29,RedBasis(17))
  call construct_RedBasis(16,18,RedBasis(18))
  call construct_RedBasis(16,19,RedBasis(19))
  call construct_RedBasis(18,19,RedBasis(20))
  call construct_RedBasis(18,23,RedBasis(21))
  call construct_RedBasis(19,23,RedBasis(22))
  call construct_RedBasis(16,27,RedBasis(23))
  call construct_RedBasis(18,27,RedBasis(24))
  call construct_RedBasis(19,27,RedBasis(25))
  call construct_RedBasis(17,19,RedBasis(26))
  call construct_RedBasis(17,23,RedBasis(27))
  call construct_RedBasis(17,27,RedBasis(28))
  call construct_RedBasis(2,3,RedBasis(29))
  call construct_RedBasis(2,7,RedBasis(30))
  call construct_RedBasis(3,7,RedBasis(31))
  call construct_RedBasis(2,11,RedBasis(32))
  call construct_RedBasis(3,11,RedBasis(33))
  call construct_RedBasis(1,3,RedBasis(34))
  call construct_RedBasis(1,7,RedBasis(35))
  call construct_RedBasis(1,11,RedBasis(36))
  call construct_RedBasis(4,5,RedBasis(37))
  call construct_RedBasis(4,7,RedBasis(38))
  call construct_RedBasis(5,7,RedBasis(39))
  call construct_RedBasis(4,6,RedBasis(40))
  call construct_RedBasis(6,7,RedBasis(41))
  call construct_RedBasis(1,5,RedBasis(42))
  call construct_RedBasis(1,13,RedBasis(43))
  call construct_RedBasis(5,13,RedBasis(44))
  call construct_RedBasis(1,9,RedBasis(45))
  call construct_RedBasis(9,13,RedBasis(46))
  call construct_RedBasis(24,28,RedBasis(47))
  call construct_RedBasis(24,29,RedBasis(48))
  call construct_RedBasis(28,29,RedBasis(49))
  call construct_RedBasis(24,30,RedBasis(50))
  call construct_RedBasis(28,30,RedBasis(51))
  call construct_RedBasis(24,26,RedBasis(52))
  call construct_RedBasis(24,27,RedBasis(53))
  call construct_RedBasis(26,27,RedBasis(54))
  call construct_RedBasis(24,25,RedBasis(55))
  call construct_RedBasis(25,27,RedBasis(56))
  call construct_RedBasis(26,30,RedBasis(57))


  ! Compute scalars depending on a third momentum p3 (in light cone rep)
  call construct_redset5(16, 20, 21, 23, RedBasis(1), RedBasis(2), & 
 RedBasis(3), RedBasis(4),RedBasis(5), RedBasis(6), RedSet_5(1))
  call construct_redset5(16, 20, 22, 23, RedBasis(1), RedBasis(7), & 
 RedBasis(3), RedBasis(8),RedBasis(5), RedBasis(9), RedSet_5(2))
  call construct_redset5(16, 17, 21, 29, RedBasis(10), RedBasis(2), & 
 RedBasis(11), RedBasis(12),RedBasis(13), RedBasis(14), RedSet_5(3))
  call construct_redset5(16, 17, 25, 29, RedBasis(10), RedBasis(15), & 
 RedBasis(11), RedBasis(16),RedBasis(13), RedBasis(17), RedSet_5(4))
  call construct_redset5(16, 18, 19, 23, RedBasis(18), RedBasis(19), & 
 RedBasis(3), RedBasis(20),RedBasis(21), RedBasis(22), RedSet_5(5))
  call construct_redset5(16, 18, 19, 27, RedBasis(18), RedBasis(19), & 
 RedBasis(23), RedBasis(20),RedBasis(24), RedBasis(25), RedSet_5(6))
  call construct_redset5(16, 17, 19, 23, RedBasis(10), RedBasis(19), & 
 RedBasis(3), RedBasis(26),RedBasis(27), RedBasis(22), RedSet_5(7))
  call construct_redset5(16, 17, 19, 27, RedBasis(10), RedBasis(19), & 
 RedBasis(23), RedBasis(26),RedBasis(28), RedBasis(25), RedSet_5(8))
  call construct_redset4(18,19,23,RedBasis(20),RedBasis(21),RedBasis(22),RedSet_4(1))
  call construct_redset4(16,19,23,RedBasis(19),RedBasis(3),RedBasis(22),RedSet_4(2))
  call construct_redset4(16,18,23,RedBasis(18),RedBasis(3),RedBasis(21),RedSet_4(3))
  call construct_redset4(16,18,19,RedBasis(18),RedBasis(19),RedBasis(20),RedSet_4(4))
  call construct_redset4(2,3,7,RedBasis(29),RedBasis(30),RedBasis(31),RedSet_4(5))
  call construct_redset4(18,19,27,RedBasis(20),RedBasis(24),RedBasis(25),RedSet_4(6))
  call construct_redset4(16,19,27,RedBasis(19),RedBasis(23),RedBasis(25),RedSet_4(7))
  call construct_redset4(16,18,27,RedBasis(18),RedBasis(23),RedBasis(24),RedSet_4(8))
  call construct_redset4(2,3,11,RedBasis(29),RedBasis(32),RedBasis(33),RedSet_4(9))
  call construct_redset4(17,19,23,RedBasis(26),RedBasis(27),RedBasis(22),RedSet_4(10))
  call construct_redset4(16,17,23,RedBasis(10),RedBasis(3),RedBasis(27),RedSet_4(11))
  call construct_redset4(16,17,19,RedBasis(10),RedBasis(19),RedBasis(26),RedSet_4(12))
  call construct_redset4(1,3,7,RedBasis(34),RedBasis(35),RedBasis(31),RedSet_4(13))
  call construct_redset4(17,19,27,RedBasis(26),RedBasis(28),RedBasis(25),RedSet_4(14))
  call construct_redset4(16,17,27,RedBasis(10),RedBasis(23),RedBasis(28),RedSet_4(15))
  call construct_redset4(1,3,11,RedBasis(34),RedBasis(36),RedBasis(33),RedSet_4(16))
  call construct_redset4(20,21,23,RedBasis(4),RedBasis(5),RedBasis(6),RedSet_4(17))
  call construct_redset4(16,21,23,RedBasis(2),RedBasis(3),RedBasis(6),RedSet_4(18))
  call construct_redset4(16,20,23,RedBasis(1),RedBasis(3),RedBasis(5),RedSet_4(19))
  call construct_redset4(16,20,21,RedBasis(1),RedBasis(2),RedBasis(4),RedSet_4(20))
  call construct_redset4(4,5,7,RedBasis(37),RedBasis(38),RedBasis(39),RedSet_4(21))
  call construct_redset4(20,22,23,RedBasis(8),RedBasis(5),RedBasis(9),RedSet_4(22))
  call construct_redset4(16,22,23,RedBasis(7),RedBasis(3),RedBasis(9),RedSet_4(23))
  call construct_redset4(16,20,22,RedBasis(1),RedBasis(7),RedBasis(8),RedSet_4(24))
  call construct_redset4(4,6,7,RedBasis(40),RedBasis(38),RedBasis(41),RedSet_4(25))
  call construct_redset4(17,21,29,RedBasis(12),RedBasis(13),RedBasis(14),RedSet_4(26))
  call construct_redset4(16,21,29,RedBasis(2),RedBasis(11),RedBasis(14),RedSet_4(27))
  call construct_redset4(16,17,29,RedBasis(10),RedBasis(11),RedBasis(13),RedSet_4(28))
  call construct_redset4(16,17,21,RedBasis(10),RedBasis(2),RedBasis(12),RedSet_4(29))
  call construct_redset4(1,5,13,RedBasis(42),RedBasis(43),RedBasis(44),RedSet_4(30))
  call construct_redset4(17,25,29,RedBasis(16),RedBasis(13),RedBasis(17),RedSet_4(31))
  call construct_redset4(16,25,29,RedBasis(15),RedBasis(11),RedBasis(17),RedSet_4(32))
  call construct_redset4(16,17,25,RedBasis(10),RedBasis(15),RedBasis(16),RedSet_4(33))
  call construct_redset4(1,9,13,RedBasis(45),RedBasis(43),RedBasis(46),RedSet_4(34))
  call construct_redset4(24,28,29,RedBasis(47),RedBasis(48),RedBasis(49),RedSet_4(35))
  call construct_redset4(24,28,30,RedBasis(47),RedBasis(50),RedBasis(51),RedSet_4(36))
  call construct_redset4(24,26,27,RedBasis(52),RedBasis(53),RedBasis(54),RedSet_4(37))
  call construct_redset4(24,25,27,RedBasis(55),RedBasis(53),RedBasis(56),RedSet_4(38))

end subroutine



! **********************************************************************
subroutine vamp(M)
! **********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_data_types_/**/REALKIND, only: Hpolcont
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_parameters_init_/**/REALKIND, only: init_met
  use ol_parameters_init_/**/DREALKIND, only: channel_on
  use ol_external_ppztt_ew_ttxddxz_1, only: channel_number_ppztt_ew_ttxddxz_1
  use ol_tensor_sum_storage_ppztt_ew_ttxddxz_1_/**/REALKIND
  use ol_loop_storage_ppztt_ew_ttxddxz_1_/**/DREALKIND, only: merge_step

  use ol_vamp_1_ppztt_ew_ttxddxz_1_/**/REALKIND, only: vamp_1
  use ol_vamp_2_ppztt_ew_ttxddxz_1_/**/REALKIND, only: vamp_2

  implicit none
  type(Hpolcont), intent(in) :: M(4,48)

#ifdef LOOPSQUARED
  M = 0
#endif

  merge_step = 1
  ! Call subroutines for all branches to calculate loop coefficient tensors
  call channel_on(channel_number_ppztt_ew_ttxddxz_1)
  call init_met(M2L1R1)
  call vamp_1(M)
  call vamp_2(M)


end subroutine vamp

! **********************************************************************
subroutine vamp2base(P_scatt, M2L0, M2L1, IRL1, M2L2, IRL2, mode)
! P_scatt(0:3,Npart) = external momenta
! M2tree = helicity-summed squared tree matrix element for top anti-top down anti-down Z -> 0
! M2loop0 = helicity-summed squared loop matrix element for top anti-top down anti-down Z -> 0
! M2loop1 = IR1, M2loop2 = IR2 are dummy values for the single and double poles
! IR0, IR1, IR2 = finite, single pole, and double pole IR contribution
! mode = 1 (default): full matrix element;
!        2: reuse and scale coefficients from the last call;
!        note that scalings cannot be reset
! **********************************************************************
  use KIND_TYPES, only: REALKIND, DREALKIND, intkind2
#ifdef PRECISION_dp
  use KIND_TYPES, only: QREALKIND, intkind2
#endif
  use ol_debug, only: ol_fatal
  use ol_generic, only: to_string
  use ol_external_ppztt_ew_ttxddxz_1, only: &
    & external_perm_inv_ppztt_ew_ttxddxz_1, average_factor_ppztt_ew_ttxddxz_1, photonid_ppztt_ew_ttxddxz_1
  use ol_colourmatrix_ppztt_ew_ttxddxz_1_/**/REALKIND ! colmat_not_initialised, colourmatrix_init, K1, K2, KL, KL2, KL2ct, KL2ct2
  use ol_kinematics_/**/REALKIND, only: init_kinematics, get_rmass2
  use ol_parameters_decl_/**/REALKIND ! parameters_status, scalefactor, <masses>
  ! tensorrankuse: for compatibility with old OL versions only insert if rank > 6
  use ol_parameters_init_/**/REALKIND, only: ensure_mp_loop_init
  use ol_init, only: set_parameter, parameters_flush
  use ol_loop_parameters_decl_/**/REALKIND, only: loop_parameters_status
  use ol_loop_parameters_decl_/**/DREALKIND, only: IR_is_on, ioperator_mode
  use ol_ew_renormalisation_/**/REALKIND, only: photon_factors
  use ol_forced_parameters_ppztt_ew_ttxddxz_1_/**/REALKIND, only: check_forced_parameters
  use ol_momenta_decl_/**/DREALKIND, only: momenta_nan_check
  use ol_momenta_decl_/**/REALKIND, only: QInvariantsMatrix
  use ol_tensor_sum_storage_ppztt_ew_ttxddxz_1_/**/REALKIND, only: &
    & reset_tensor_sum, integrate_tensor_sum, scale_tensor_sum, HOL_memory_allocation, HCL_memory_allocation, &
    & set_integral_masses_and_momenta, Tsum_memory_allocation
  use ol_tables_storage_ppztt_ew_ttxddxz_1_/**/DREALKIND, only: HOL_m3_init
  use ol_loop_ppztt_ew_ttxddxz_1_/**/REALKIND, only: amp2, fac_init_loop
  use ol_loop_ppztt_ew_ttxddxz_1_/**/DREALKIND, only: init_merging_tables, update_merging_tables
  use ol_loop_storage_ppztt_ew_ttxddxz_1_/**/REALKIND, only: &
    & fac_status_loop1, fac_status_loop2, M0_col1_helarray
  use ol_i_operator_/**/REALKIND, only: intdip
  use ol_loop_storage_ppztt_ew_ttxddxz_1_/**/DREALKIND, only: ntry, ntryL, p_switch, &
    & dp_not_alloc, qp_not_alloc
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  implicit none

  real(DREALKIND), intent(in)  :: P_scatt(0:3,5)
  real(REALKIND),  intent(out) :: M2L0, M2L1, IRL1(0:2), M2L2, IRL2(0:4)
  integer, intent(in), optional :: mode
  real(REALKIND)       :: P(0:3,5)
  integer              :: i, j, colmatpos, recycle_mode, ofred_mode
  complex(REALKIND)    :: M0_col1(4), Mct(4)
  complex(REALKIND)    :: Mcol_loop(4)
  real(REALKIND)       :: M2colint(16), M2CC(5,5), M2CC_EW ! colour correlations
  integer              :: extmasses2(5)
  real(REALKIND)       :: M2hel, M2ct, M2L2ct, M2L2ct2, vdip, c_dip(0:2)
  real(REALKIND)       :: scalebackfactor
  real(REALKIND)       :: bornphotonfactor, loopphotonfactor

  ofred_mode = 1

  if (present(mode)) then
    recycle_mode = mode
  else
    recycle_mode = 1
  end if

  call set_parameter("ew_renorm", 1)
  call parameters_flush()
  call ensure_mp_loop_init()
  if (fac_status_loop1 /= parameters_status .or. fac_status_loop2 /= loop_parameters_status) then
    ! Note: if fac_init would only be called when parameters changed which are relevant for the factors,
    ! a different 'status' would have to be used, because forced_parameters should be called after every parameter change.
    call check_forced_parameters()
    call fac_init_loop()
  end if

  if (colmat_not_initialised) call colourmatrix_init()


  M2L0     = 0
  M2L1     = 0
  M2ct     = 0
  M2colint = 0
  M2L2     = 0
  M2L2ct   = 0
  M2L2ct2  = 0
  IRL1     = 0
  IRL2     = 0
  extmasses2 = [ nMT, nMT, 0, 0, nMZ ]

  if (momenta_nan_check(P_scatt) /= 0) return

#ifndef PRECISION_dp
  if (ntryL==1 .OR. qp_not_alloc) then
    call Tsum_memory_allocation()
  end if
#else
  if (ntryL==1 .OR. dp_not_alloc) then
    call Tsum_memory_allocation()
  end if
#endif

#ifdef LOOPSQUARED
  call integrate_tensor_sum(M2L1)
#else
  if (recycle_mode == 1 .or. ofred_mode == 1) call reset_tensor_sum()
#endif


  ! Here we calculate the tree level squared using the helicity bookkeeping subroutines
  ! The value of the tree level squared is M2L0
  ! The subtrees are also initialised
  call amp2(P_scatt, M2L0, M2ct, M2colint, .true.)

  !The following part refers to the 1-loop calculation

  ! Construction of the basis used for the reduction
  call redbaseconstr()
  ! Memory allocation for the hol types is done just for the first phase space point
  ! Memory is reallocated when switching from double- to quad-precision for the first time
#ifndef PRECISION_dp
  if (ntryL==1 .OR. qp_not_alloc) then
    call HOL_memory_allocation()
    call HCL_memory_allocation()
    qp_not_alloc = .FALSE.
  end if
#else
  if (ntryL==1 .OR. dp_not_alloc) then
    call HOL_memory_allocation()
    call HCL_memory_allocation()
    dp_not_alloc = .FALSE.
  end if
#endif

  if(ntryL == 1) then
    !! m3 initialization done just for the first phase space point
    call HOL_m3_init()
    !! first temporary initialization of the merging tables
    call init_merging_tables(48,169)
  end if

  call set_integral_masses_and_momenta()

  !! Call for the calculation of the born-loop interference
  if (recycle_mode == 1 .or. ofred_mode == 1) then
    call vamp(M0_col1_helarray)
  end if

  !! Merging tables are adjusted and allocated with the proper dimensionality
  if(ntryL == 1) call update_merging_tables(48)

  if(ntry==1) ntry = 2
  if(ntryL==1) ntryL = ntryL + 1

#ifdef PRECISION_dp
  p_switch = 1
#else
  p_switch = 2
#endif


#ifdef LOOPSQUARED
  M2L2 = (M2L2 + 2*M2L2ct + M2L2ct2) / average_factor_ppztt_ew_ttxddxz_1
#else
  if (recycle_mode == 2 .and. ofred_mode == 0) then
    call scale_tensor_sum()
  end if
  call integrate_tensor_sum(M2L1)
#endif

  if (IR_is_on > 0) then
    do i = 1, 5
      do j = 1, i
        ! Why does this work without permuting the colour correlation matrices?
        M2CC(i,j) = M2colint(i*(i-1)/2+j)
      end do
    end do
    do j = 2, 5
      do i = 1, j-1
        M2CC(i,j) = M2CC(j,i)
      end do
    end do
    M2CC_EW = M2colint(5*(5+1)/2+1)
    call intdip(ioperator_mode, M2L0, M2CC, M2CC_EW, [2,2,2,2,0], [2,-2,-1,1,0]/3._/**/REALKIND, &
      & 5, get_rmass2(extmasses2), QInvariantsMatrix, vdip, c_dip, &
      & 1, &
      & [( photonid_ppztt_ew_ttxddxz_1( &
      & external_perm_inv_ppztt_ew_ttxddxz_1(i)), &
      & i=1, size(external_perm_inv_ppztt_ew_ttxddxz_1))])
    IRL1(0) = c_dip(0) / average_factor_ppztt_ew_ttxddxz_1
    IRL1(1) = c_dip(1) / average_factor_ppztt_ew_ttxddxz_1
    IRL1(2) = c_dip(2) / average_factor_ppztt_ew_ttxddxz_1
  else
    vdip = 0
    IRL1 = 0
  end if

  ! loop^2 IR contribution: not implemented
  IRL2 = 0

  ! photon factors
  call photon_factors(photonid_ppztt_ew_ttxddxz_1, 1, bornphotonfactor, loopphotonfactor)
  M2L1 = bornphotonfactor * M2L1
  M2ct = M2ct+M2L0*loopphotonfactor

  ! Colour and helicity average and symmetry factor of outgoing particles
  M2L0 = M2L0 / average_factor_ppztt_ew_ttxddxz_1
  M2L1 = 2*(M2L1 + M2ct)
  if (IR_is_on > 1) then
    M2L1 = M2L1 + vdip
  end if
  M2L1 = M2L1 / average_factor_ppztt_ew_ttxddxz_1

  ! check for NaN result
  if (M2L0 /= M2L0) then
    M2L0 = 0
  end if
  if (M2L1 /= M2L1) then
    M2L1 = 0
    M2L2 = 0
    IRL1 = 0
    IRL2 = 0
  end if

  scalebackfactor = scalefactor**(2*5-8)
  M2L0 = scalebackfactor * M2L0
  M2L1 = scalebackfactor * M2L1
  IRL1 = scalebackfactor * IRL1
  M2L2 = scalebackfactor * M2L2
  IRL2 = scalebackfactor * IRL2
  M2L0cache = M2L0
  M2L1cache = M2L1

end subroutine vamp2base


! **********************************************************************
subroutine ctamp2base(P_scatt, M2tree, M2ct)
! The part of vamp2 which calculates tree and counter-term
! matrix elements, but not the loop. R2 is deactivated.
! Does not calculate loop^2 counterterms/R2.
! P_scatt(0:3,Npart) = external momenta
! M2tree = helicity-summed squared tree matrix element for top anti-top down anti-down Z -> 0
! M2ct   = helicity-summed counterterm matrix element
! **********************************************************************
  use KIND_TYPES, only: REALKIND, DREALKIND
  use ol_external_ppztt_ew_ttxddxz_1, only: photonid_ppztt_ew_ttxddxz_1
  use ol_colourmatrix_ppztt_ew_ttxddxz_1_/**/REALKIND, only: &
    & colmat_not_initialised, colourmatrix_init, K1, K2
  use ol_parameters_decl_/**/REALKIND ! parameters_status, scalefactor, <masses>
  use ol_parameters_decl_/**/DREALKIND, only: do_ew_renorm
  use ol_loop_parameters_decl_/**/DREALKIND, only: &
    & loop_parameters_status, CT_is_on, R2_is_on, TP_is_on
  use ol_ew_renormalisation_/**/REALKIND, only: photon_factors
  use ol_init, only: set_parameter, parameters_flush
  use ol_parameters_init_/**/REALKIND, only: ensure_mp_loop_init
  use ol_external_ppztt_ew_ttxddxz_1, only: &
    & external_perm_inv_ppztt_ew_ttxddxz_1, average_factor_ppztt_ew_ttxddxz_1
  use ol_momenta_decl_/**/DREALKIND, only: momenta_nan_check
  use ol_kinematics_/**/REALKIND, only: init_kinematics
  use ol_forced_parameters_ppztt_ew_ttxddxz_1_/**/REALKIND, only: check_forced_parameters
  use ol_loop_storage_ppztt_ew_ttxddxz_1_/**/REALKIND, only: &
    & fac_status_loop1, fac_status_loop2
  use ol_loop_storage_ppztt_ew_ttxddxz_1_/**/DREALKIND, only: ntry
  use ol_loop_ppztt_ew_ttxddxz_1_/**/REALKIND, only: fac_init_loop, amp2
  implicit none

  real(DREALKIND), intent(in)  :: P_scatt(0:3,5)
  real(REALKIND),  intent(out) :: M2tree, M2ct
  real(REALKIND)    :: P(0:3,5)
  real(REALKIND)       :: M2colint(16)
  integer           :: CT_on_bak, R2_on_bak, TP_on_bak
  real(REALKIND)    :: scalebackfactor, bornphotonfactor, loopphotonfactor

  M2tree = 0
  M2ct   = 0

  if(ntry == 1) then
    ! initialization call needed for the correct helicity bokkeeping
    CT_on_bak = CT_is_on
    R2_on_bak = R2_is_on
    TP_on_bak = TP_is_on
    call set_parameter("ct_on", 1)
    call set_parameter("r2_on", 1)
    call set_parameter("tp_on", 1)
    call amp2(P_scatt, M2tree, M2ct, M2colint, .false.)
    call set_parameter("ct_on", CT_on_bak)
    call set_parameter("r2_on", R2_on_bak)
    call set_parameter("tp_on", TP_on_bak)
    ntry = 2
  end if

  call set_parameter("ct_on", 1)
  call set_parameter("ew_renorm", 1)
  call parameters_flush()
  call ensure_mp_loop_init()

  if (momenta_nan_check(P_scatt) /= 0)  return

  call amp2(P_scatt, M2tree, M2ct, M2colint, .false.)

  ! photon factors
  call photon_factors(photonid_ppztt_ew_ttxddxz_1, 1, bornphotonfactor, loopphotonfactor)
  M2ct = M2ct+M2tree*loopphotonfactor

  scalebackfactor = scalefactor**(2*5-8)
  M2tree = scalebackfactor * M2tree / average_factor_ppztt_ew_ttxddxz_1
  M2ct   = scalebackfactor * 2*M2ct / average_factor_ppztt_ew_ttxddxz_1

end subroutine ctamp2base


! **********************************************************************
subroutine vamp2cache(P_scatt, M2L0, M2L1, corr)
! **********************************************************************
  use KIND_TYPES, only: REALKIND, DREALKIND
  use ol_external_ppztt_ew_ttxddxz_1, only: extcomb_perm_ppztt_ew_ttxddxz_1, &
    & average_factor_ppztt_ew_ttxddxz_1
  use ol_loop_storage_ppztt_ew_ttxddxz_1_/**/REALKIND, only: M2ctcc, M0M1_hel_cc
  use ol_tensor_sum_storage_ppztt_ew_ttxddxz_1_/**/REALKIND, only: reset_tensor_sum, &
    & integrate_tensor_sum
  use ol_debug, only: ol_fatal
  use ol_colourmatrix_ppztt_ew_ttxddxz_1_/**/REALKIND, only: Cas
  use ol_data_types_/**/DREALKIND, only: correlator
  implicit none
  real(DREALKIND), intent(in)  :: P_scatt(0:3,5)
  real(REALKIND),  intent(out) :: M2L0, M2L1
  real(REALKIND) :: M2L1cc(0:16)
  type(correlator) :: corr
#if 5 > 3
  integer :: co, k, m, ind_cc_comb(5)
#else
  integer :: co, k, m
#endif
#if 1 > 0
  ind_cc_comb = [8,12,9,13,14]
  M2L1cc = 0
  !! Diagonal born-loop colour correlators
  co = 0
  do k = 1, 5
    co = co + k
    M2L1cc(co) = Cas(k)*M2L1cache
  end do
#if 5 > 3
  !! Independent colour correlators
  do k = 1, 5
    m = ind_cc_comb(k)
    call reset_tensor_sum()
    M2L1 = 0
    if(sum(abs(M0M1_hel_cc(:,:,m)%j)) == 0) then
      M2L1 = 0
    else
      call vamp(M0M1_hel_cc(:,:,m))
      call integrate_tensor_sum(M2L1)
    end if
    M2L1cc(m) = 2*(M2L1 + M2ctcc(m))/average_factor_ppztt_ew_ttxddxz_1
  end do
#endif
  !! Linearly dependent colour correlators
  M2L1cc(2) = (M2L1cache*(-Cas(1) - Cas(2) + Cas(3) + Cas(4) + Cas(5)))/2 + M2L1cc(9) + M2L1cc(13) + M2L1cc(14)
  M2L1cc(4) = (M2L1cache*(-Cas(1) + Cas(2) - Cas(3) + Cas(4) + Cas(5)))/2 + M2L1cc(8) + M2L1cc(12) + M2L1cc(14)
  M2L1cc(7) = -(M2L1cache*Cas(4)) - M2L1cc(8) - M2L1cc(9) - M2L1cc(14)
  M2L1cc(11) = -(M2L1cache*Cas(5)) - M2L1cc(12) - M2L1cc(13) - M2L1cc(14)
  M2L1cc(5) = (M2L1cache*(Cas(1) - Cas(2) - Cas(3) - Cas(4) - Cas(5)))/2 - M2L1cc(8) - M2L1cc(9) - M2L1cc(12)  &
  - M2L1cc(13) - M2L1cc(14)
  
  do k = 1, 16
    corr%rescc(k) = M2L1cc(extcomb_perm_ppztt_ew_ttxddxz_1(k))
  end do
  M2L0 = M2L0cache
  corr%rescc(0) = M2L1cache
  M2L1 = M2L1cache
#else
  call ol_fatal("born-loop colour correlators not available for process ppztt_ew_ttxddxz_1")
#endif
end subroutine vamp2cache



subroutine vamp2pc(P_scatt, M2L0, M2L1, IRL1, M2L2, IRL2, mode)
  ! polecheck routine: perform multiple calls of vamp2
  ! with different values of the UV/IR poles
  ! to determine the coefficients of the IR poles.
  use KIND_TYPES, only: REALKIND, DREALKIND
  use ol_parameters_decl_/**/DREALKIND, only: rZERO_dp => rZERO
  use ol_loop_parameters_decl_/**/REALKIND, only: &
    & de1_UV, de1_IR, de2_i_IR
  use ol_loop_parameters_decl_/**/DREALKIND, only: &
    & polescale_dp => polescale, polecheck_is, CT_is_on, IR_is_on
  use ol_init, only: set_parameter
  implicit none
  real(DREALKIND), intent(in)  :: P_scatt(:,:)
  real(REALKIND),  intent(out) :: M2L0, M2L1(0:2), IRL1(0:2), M2L2(0:4), IRL2(0:4)
  integer, intent(in), optional :: mode
  real(DREALKIND) :: poleUV1bak, poleIR1bak, poleIR2bak
  integer         :: CT_on_bak, IR_on_bak
  real(REALKIND)  :: M2L1_00, M2L1_10, M2L1_01, M2L1_20, M2L1_02, M2L1_11
  real(REALKIND)  :: M2L2_00, M2L2_10, M2L2_01, M2L2_20, M2L2_02, M2L2_11
  real(REALKIND)  :: IRL1x(0:2), IRL2x(0:4)

  if (polecheck_is == 0) then
    call vamp2base(P_scatt, M2L0, M2L1(0), IRL1, M2L2(0), IRL2, mode)
    if (IR_is_on == 2) then
      M2L1(1:2) = 0
      M2L2(1:4) = 0
    else
      M2L1(1:2) = -IRL1(1:2)
      M2L2(1:4) = -IRL2(1:4)
    end if
  else
    ! remember original parameters
    poleUV1bak = de1_UV
    poleIR1bak = de1_IR
    poleIR2bak = de2_i_IR
    CT_on_bak  = CT_is_on
    IR_on_bak  = IR_is_on
    ! three calls with different IR poles; IR subtractions are calculated but not added
    call set_parameter("pole_uv", rZERO_dp)
    call set_parameter("pole_ir1", rZERO_dp)
    call set_parameter("pole_ir2", rZERO_dp)
    call set_parameter("ct_on", 1)
    call set_parameter("ir_on", 1)
    call vamp2base(P_scatt, M2L0, M2L1_00, IRL1, M2L2_00, IRL2, mode)
    call set_parameter("pole_uv", polescale_dp)
    call set_parameter("pole_ir1", polescale_dp)
    call set_parameter("pole_ir2", rZERO_dp)
    call set_parameter("ir_on", 0)
    call vamp2base(P_scatt, M2L0, M2L1_10, IRL1x, M2L2_10, IRL2x, mode)
    call set_parameter("pole_uv", rZERO_dp)
    call set_parameter("pole_ir1", rZERO_dp)
    call set_parameter("pole_ir2", polescale_dp)
    call vamp2base(P_scatt, M2L0, M2L1_01, IRL1x, M2L2_01, IRL2x, mode)

    M2L1(0) = M2L1_00
    M2L1(1) = (M2L1_10 - M2L1_00)/polescale_dp
    M2L1(2) = (M2L1_01 - M2L1_00)/polescale_dp

#ifdef LOOPSQUARED
    call set_parameter("pole_uv", polescale_dp)
    call set_parameter("pole_ir1", 2*polescale_dp)
    call set_parameter("pole_ir2", rZERO_dp)
    call vamp2base(P_scatt, M2L0, M2L1_20, IRL1x, M2L2_20, IRL2x)
    call set_parameter("pole_uv", rZERO_dp)
    call set_parameter("pole_ir1", rZERO_dp)
    call set_parameter("pole_ir2", 2*polescale_dp)
    call vamp2base(P_scatt, M2L0, M2L1_02, IRL1x, M2L2_02, IRL2x)
    call set_parameter("pole_uv", rZERO_dp)
    call set_parameter("pole_ir1", polescale_dp)
    call set_parameter("pole_ir2", polescale_dp)
    call vamp2base(P_scatt, M2L0, M2L1_11, IRL1x, M2L2_11, IRL2x)

    M2L2(0) = M2L2_00
    M2L2(1) = (-3*M2L2_00 - M2L2_20 + 4*M2L2_10)/(2*polescale_dp)
    M2L2(2) = (-3*M2L2_00 + 4*M2L2_01 - M2L2_02)/(2*polescale_dp) + (M2L2_00 - 2*M2L2_10 + M2L2_20)/(2*polescale_dp**2)
    M2L2(3) = (M2L2_00 - M2L2_01 - M2L2_10 + M2L2_11)/polescale_dp**2
    M2L2(4) = (M2L2_00 + M2L2_02 - 2*M2L2_01)/(2*polescale_dp**2)
#endif
    ! restore original parameters
    call set_parameter("pole_uv", poleUV1bak)
    call set_parameter("pole_ir1", poleIR1bak)
    call set_parameter("pole_ir2", poleIR2bak)
    call set_parameter("ct_on", CT_on_bak)
    call set_parameter("ir_on", IR_on_bak)
    if (IR_on_bak == 2) then
      M2L1 = M2L1 + IRL1
      M2L2 = M2L2 + IRL2
    end if
  end if

end subroutine vamp2pc

end module ol_vamp_ppztt_ew_ttxddxz_1_/**/REALKIND


#ifdef DUMMY_qp
module ol_vamp_ppztt_ew_ttxddxz_1_/**/QREALKIND
  implicit none
  contains
  subroutine vamp2pc(P_scatt, M2L0, M2L1, IRL1, M2L2, IRL2, mode)
    ! Dummy quad precision routine. Throws an error if the process called but
    ! the process has not been compiled in quad precision.
    use KIND_TYPES, only: DREALKIND, QREALKIND
    use ol_debug, only: ol_fatal
    implicit none
    real(DREALKIND), intent(in)  :: P_scatt(:,:)
    real(QREALKIND),  intent(out) :: M2L0, M2L1(0:2), IRL1(0:2), M2L2(0:4), IRL2(0:4)
    integer, intent(in), optional :: mode
    call ol_fatal("Process ppztt_ew_ttxddxz_1" &
      & // "has not been compiled in quad precision")
  end subroutine vamp2pc
end module ol_vamp_ppztt_ew_ttxddxz_1_/**/QREALKIND
#endif


#ifdef PRECISION_dp

module ol_vamp_ppztt_ew_ttxddxz_1
  use ol_parameters_decl_/**/DREALKIND, only: procname_length
  use ol_data_types_/**/DREALKIND, only: me_cache
  implicit none
  character(procname_length) :: processname = 'ppztt_ew_ttxddxz_1'
  integer, save :: qp_eval = 0, killed = 0
  integer, save :: npoints(8) = 0
  integer, save :: stability_histogram(20) = 0, stability_histogram_qp(20) = 0
  type(me_cache), allocatable, target, save :: me_caches(:)
  contains

  subroutine finish_ppztt_ew_ttxddxz_1()
    ! final update of the stability histogram and memory deallocation
    use KIND_TYPES, only: DREALKIND
!   use ol_data_types_/**/REALKIND, only: Hpolcont
!   use ol_tensor_sum_storage_ppztt_ew_ttxddxz_1_/**/DREALKIND, only: HOL_memory_allocation
    use ol_stability, only: finish_histograms
    use ol_vamp_ppztt_ew_ttxddxz_1_/**/DREALKIND, only: vamp
    use ol_tensor_sum_storage_ppztt_ew_ttxddxz_1_/**/DREALKIND, only: &
      & HOL_memory_deallocation_/**/DREALKIND, HCL_memory_deallocation_/**/DREALKIND
#ifndef DUMMY_qp
    use ol_tensor_sum_storage_ppztt_ew_ttxddxz_1_/**/QREALKIND, only: &
      & HOL_memory_deallocation_/**/QREALKIND, HCL_memory_deallocation_/**/QREALKIND
#endif
    use ol_loop_storage_ppztt_ew_ttxddxz_1_/**/DREALKIND, only: &
      & dp_not_alloc, qp_not_alloc, merge_tables, merge_mism, merge_hels, merge_tables_on
      implicit none
      integer :: k
!   type(Hpolcont) :: Mdummy(4,48)
!   call HOL_memory_allocation()
!   call vamp(Mdummy)

    ! Memory is deallocated for both dp and/or qp stored hol coefficients
    if (.NOT. dp_not_alloc) then
      call HOL_memory_deallocation_/**/DREALKIND(0)
      call HCL_memory_deallocation_/**/DREALKIND(0)
    end if
#ifndef DUMMY_qp
    if (.NOT. qp_not_alloc) then
      call HOL_memory_deallocation_/**/QREALKIND(0)
      call HCL_memory_deallocation_/**/QREALKIND(0)
    end if
#endif

    if (merge_tables_on) then
      if (allocated(merge_tables)) deallocate(merge_tables)
      if (allocated(merge_mism)) deallocate(merge_mism)
      if (allocated(merge_hels)) deallocate(merge_hels)
      merge_tables_on = .false.
    end if

    if (allocated(me_caches)) then
      do k = 1, size(me_caches)
      if (allocated(me_caches(k)%psp)) deallocate(me_caches(k)%psp)
      if (allocated(me_caches(k)%me)) deallocate(me_caches(k)%me)
    end do
      if (allocated(me_caches)) deallocate(me_caches)
    end if
    call finish_histograms(processname, stability_histogram, stability_histogram_qp, npoints, qp_eval, killed)
  end subroutine finish_ppztt_ew_ttxddxz_1


  subroutine vamp2(P_scatt, M2L0, M2L1, IRL1, M2L2, IRL2) &
      & bind(c,name="ol_f_vamp2_ppztt_ew_ttxddxz_1")
    use KIND_TYPES, only: DREALKIND
    use ol_init, only: register_cleanup
    use ol_external_ppztt_ew_ttxddxz_1, only: external_perm_ppztt_ew_ttxddxz_1
    use ol_vamp_ppztt_ew_ttxddxz_1_/**/DREALKIND, only: vamp2dp => vamp2pc
    use ol_vamp_ppztt_ew_ttxddxz_1_/**/QREALKIND, only: vamp2qp => vamp2pc
    use ol_stability, only: vamp2generic
    implicit none
    real(DREALKIND), intent(in)  :: P_scatt(0:3,5)
    real(DREALKIND), intent(out) :: M2L0, M2L1(0:2), IRL1(0:2), M2L2(0:4), IRL2(0:4)
    real(DREALKIND), save :: abs_kfactor_threshold = 1, trigeff_local = 0, sum_M2tree = 0
    logical :: first_call = .true.
    if (first_call) then
      call register_cleanup(finish_ppztt_ew_ttxddxz_1)
      first_call = .false.
    end if
    call vamp2generic(vamp2dp, vamp2qp, processname, P_scatt, M2L0, M2L1, IRL1, M2L2, IRL2, &
                    & abs_kfactor_threshold, trigeff_local, sum_M2tree, &
                    & npoints, qp_eval, killed, stability_histogram, stability_histogram_qp, &
                    & external_perm_ppztt_ew_ttxddxz_1, me_caches)
  end subroutine vamp2


  subroutine ctamp2(P_scatt, M2tree, M2ct) &
      & bind(c,name="ol_f_ctamp2_ppztt_ew_ttxddxz_1")
    use KIND_TYPES, only: DREALKIND
    use ol_vamp_ppztt_ew_ttxddxz_1_/**/DREALKIND, only: ctamp2base
    implicit none
    real(DREALKIND), intent(in)  :: P_scatt(0:3,5)
    real(DREALKIND), intent(out) :: M2tree, M2ct
    call ctamp2base(P_scatt, M2tree, M2ct)
  end subroutine ctamp2


  subroutine vamp2_c(P_scatt, M2L0, M2L1, IRL1, M2L2, IRL2) &
      & bind(c,name="ol_vamp2_ppztt_ew_ttxddxz_1")
    use KIND_TYPES, only: DREALKIND
    use, intrinsic :: iso_c_binding, only: c_double
    implicit none
    real(c_double), intent(in)  :: P_scatt(0:3,5)
    real(c_double), intent(out) :: M2L0, M2L1(0:2), IRL1(0:2), M2L2(0:4), IRL2(0:4)
    real(DREALKIND) :: f_p_scatt(0:3,5)
    real(DREALKIND) :: f_m2l0, f_m2l1(0:2), f_irl1(0:2), f_m2l2(0:4), f_irl2(0:4)
    f_p_scatt = P_scatt
    call vamp2(f_p_scatt, f_m2l0, f_m2l1, f_irl1, f_m2l2, f_irl2)
    M2L0 = f_m2l0
    M2L1 = f_m2l1
    IRL1 = f_irl1
    M2L2 = f_m2l2
    IRL2 = f_irl2
  end subroutine vamp2_c


  subroutine ctamp2_c(P_scatt, M2tree, M2ct) &
      & bind(c,name="ol_ctamp2_ppztt_ew_ttxddxz_1")
    use KIND_TYPES, only: DREALKIND
    use, intrinsic :: iso_c_binding, only: c_double
    implicit none
    real(c_double), intent(in)  :: P_scatt(0:3,5)
    real(c_double), intent(out) :: M2tree, M2ct
    real(DREALKIND) :: f_p_scatt(0:3,5)
    real(DREALKIND) :: f_m2tree, f_m2ct
    f_p_scatt = P_scatt
    call ctamp2(f_p_scatt, f_m2tree, f_m2ct)
    M2tree = f_m2tree
    M2ct = f_m2ct
  end subroutine ctamp2_c

  !!! Interface for tree-loop correlators.
  subroutine vampcr2(P_scatt, M2L0, M2L1, M2L2, crtype, &
      & emitter, nextcombs, extcombs, mom, M2cc, M2munu) &
      & bind(c,name="ol_f_vampcr2_ppztt_ew_ttxddxz_1")
    use KIND_TYPES, only: DREALKIND
    use ol_vamp_ppztt_ew_ttxddxz_1_/**/DREALKIND, only: vamp2cache
    use ol_data_types_/**/DREALKIND, only: correlator
    implicit none
    real(DREALKIND), intent(in)  :: P_scatt(0:3,5), mom(:)
    real(DREALKIND), intent(out) :: M2L0, M2L1, M2L2, M2cc(0:16)
    integer, intent(in) :: crtype, emitter, nextcombs, extcombs(nextcombs)
    real(DREALKIND), intent(out) :: M2munu(:,:)
    type(correlator) :: corr
    M2L0 = 0
    M2L1 = 0
    M2L2 = 0
    corr%type=crtype
    if(crtype == 11) then
      allocate(corr%rescc(0:16))
      call vamp2cache(P_scatt, M2L0, M2L1, corr=corr)
      M2cc = corr%rescc
      deallocate(corr%rescc)
    end if
  end subroutine vampcr2

end module ol_vamp_ppztt_ew_ttxddxz_1

! #ifdef PRECISION_dp
#endif
