
module ol_vamp_1_ppztt_ew_ttxazg_2_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppztt_ew_ttxazg_2.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppztt_ew_ttxazg_2.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_ppztt_ew_ttxazg_2_/**/DREALKIND
  use ol_tensor_sum_storage_ppztt_ew_ttxazg_2_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_ppztt_ew_ttxazg_2_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_ppztt_ew_ttxazg_2_/**/DREALKIND, only: &
    & ntryL, p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(48)
  type(Hpolcont), intent(in) :: M(1,48)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

  Gcoeff(:)%j = (c(18)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(1),h0tab(:,1),[16,4,1,2,8],[nMT,nMT,nMH,nMT,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,1),heltab2x48(:,:,1))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMT,G1H24(1),n2h24(1))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(2),h0tab(:,2),[16,4,1,2,8],[nMT,nMT,nMZ,nMT,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,2),heltab2x48(:,:,2))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMT,G1H24(2),n2h24(2))
  Gcoeff(:)%j = (c(15)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(3),h0tab(:,3),[16,4,1,2,8],[nMB,nMB,nMW,nMB,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,3),heltab2x48(:,:,3))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMB,G1H24(3),n2h24(3))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(4),h0tab(:,4),[16,4,1,2,8],[nMT,nMT,0,nMT,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,4),heltab2x48(:,:,4))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMT,G1H24(4),n2h24(4))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(5),h0tab(:,5),[16,4,1,2,8],[nMT,nMT,nMZ,nMT,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,5),heltab2x48(:,:,5))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMT,G1H24(5),n2h24(5))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(6),h0tab(:,6),[16,4,1,2,8],[nMB,nMB,nMW,nMB,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,6),heltab2x48(:,:,6))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMB,G1H24(6),n2h24(6))
  Gcoeff(:)%j = (c(18)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(7),h0tab(:,7),[16,2,1,4,8],[nMT,nMH,nMT,nMT,nMT],5,0)
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,7),heltab2x48(:,:,7))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMT,G1H24(7),n2h24(7))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(8),h0tab(:,8),[16,2,1,4,8],[nMT,nMZ,nMT,nMT,nMT],5,0)
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,8),heltab2x48(:,:,8))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMT,G1H24(8),n2h24(8))
  Gcoeff(:)%j = (c(15)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(9),h0tab(:,9),[16,2,1,4,8],[nMB,nMW,nMB,nMB,nMB],5,0)
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,9),heltab2x48(:,:,9))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMB,G1H24(9),n2h24(9))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(10),h0tab(:,10),[16,2,1,4,8],[nMT,0,nMT,nMT,nMT],5,0)
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,10),heltab2x48(:,:,10))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMT,G1H24(10),n2h24(10))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(11),h0tab(:,11),[16,2,1,4,8],[nMT,nMZ,nMT,nMT,nMT],5,0)
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,11),heltab2x48(:,:,11))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMT,G1H24(11),n2h24(11))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(12),h0tab(:,12),[16,2,1,4,8],[nMB,nMW,nMB,nMB,nMB],5,0)
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,12),heltab2x48(:,:,12))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMB,G1H24(12),n2h24(12))
  Gcoeff(:)%j = (c(18)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(13),h0tab(:,13),[16,4,2,1,8],[nMT,nMT,nMH,nMT,nMT],5,0)
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,13),heltab2x48(:,:,13))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMT,G1H24(13),n2h24(13))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(14),h0tab(:,14),[16,4,2,1,8],[nMT,nMT,nMZ,nMT,nMT],5,0)
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,14),heltab2x48(:,:,14))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMT,G1H24(14),n2h24(14))
  Gcoeff(:)%j = (c(15)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(15),h0tab(:,15),[16,4,2,1,8],[nMB,nMB,nMW,nMB,nMB],5,0)
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,15),heltab2x48(:,:,15))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMB,G1H24(15),n2h24(15))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(16),h0tab(:,16),[16,4,2,1,8],[nMT,nMT,0,nMT,nMT],5,0)
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,16),heltab2x48(:,:,16))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMT,G1H24(16),n2h24(16))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(17),h0tab(:,17),[16,4,2,1,8],[nMT,nMT,nMZ,nMT,nMT],5,0)
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,17),heltab2x48(:,:,17))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMT,G1H24(17),n2h24(17))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(18),h0tab(:,18),[16,4,2,1,8],[nMB,nMB,nMW,nMB,nMB],5,0)
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,18),heltab2x48(:,:,18))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMB,G1H24(18),n2h24(18))
  Gcoeff(:)%j = (c(18)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(19),h0tab(:,19),[16,2,1,8,4],[nMT,nMH,nMT,nMT,nMT],5,0)
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,19),heltab2x48(:,:,19))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMT,G1H24(19),n2h24(19))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(20),h0tab(:,20),[16,2,1,8,4],[nMT,nMZ,nMT,nMT,nMT],5,0)
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,20),heltab2x48(:,:,20))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMT,G1H24(20),n2h24(20))
  Gcoeff(:)%j = (c(15)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(21),h0tab(:,21),[16,2,1,8,4],[nMB,nMW,nMB,nMB,nMB],5,0)
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,21),heltab2x48(:,:,21))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMB,G1H24(21),n2h24(21))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(22),h0tab(:,22),[16,2,1,8,4],[nMT,0,nMT,nMT,nMT],5,0)
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,22),heltab2x48(:,:,22))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMT,G1H24(22),n2h24(22))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(23),h0tab(:,23),[16,2,1,8,4],[nMT,nMZ,nMT,nMT,nMT],5,0)
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,23),heltab2x48(:,:,23))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMT,G1H24(23),n2h24(23))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(24),h0tab(:,24),[16,2,1,8,4],[nMB,nMW,nMB,nMB,nMB],5,0)
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,24),heltab2x48(:,:,24))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMB,G1H24(24),n2h24(24))
  Gcoeff(:)%j = (c(18)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(25),h0tab(:,25),[16,1,2,4,8],[nMT,nMH,nMT,nMT,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,25),heltab2x48(:,:,25))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMT,G1H24(25),n2h24(25))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(26),h0tab(:,26),[16,1,2,4,8],[nMT,nMZ,nMT,nMT,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,26),heltab2x48(:,:,26))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMT,G1H24(26),n2h24(26))
  Gcoeff(:)%j = (c(15)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(27),h0tab(:,27),[16,1,2,4,8],[nMB,nMW,nMB,nMB,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,27),heltab2x48(:,:,27))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMB,G1H24(27),n2h24(27))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(28),h0tab(:,28),[16,1,2,4,8],[nMT,0,nMT,nMT,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,28),heltab2x48(:,:,28))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMT,G1H24(28),n2h24(28))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(29),h0tab(:,29),[16,1,2,4,8],[nMT,nMZ,nMT,nMT,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,29),heltab2x48(:,:,29))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMT,G1H24(29),n2h24(29))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(30),h0tab(:,30),[16,1,2,4,8],[nMB,nMW,nMB,nMB,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,30),heltab2x48(:,:,30))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMB,G1H24(30),n2h24(30))
  Gcoeff(:)%j = (c(18)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(31),h0tab(:,31),[16,1,2,8,4],[nMT,nMH,nMT,nMT,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,31),heltab2x48(:,:,31))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMT,G1H24(31),n2h24(31))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(32),h0tab(:,32),[16,1,2,8,4],[nMT,nMZ,nMT,nMT,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,32),heltab2x48(:,:,32))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMT,G1H24(32),n2h24(32))
  Gcoeff(:)%j = (c(15)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(33),h0tab(:,33),[16,1,2,8,4],[nMB,nMW,nMB,nMB,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,33),heltab2x48(:,:,33))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMB,G1H24(33),n2h24(33))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(34),h0tab(:,34),[16,1,2,8,4],[nMT,0,nMT,nMT,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,34),heltab2x48(:,:,34))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMT,G1H24(34),n2h24(34))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(35),h0tab(:,35),[16,1,2,8,4],[nMT,nMZ,nMT,nMT,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,35),heltab2x48(:,:,35))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMT,G1H24(35),n2h24(35))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(36),h0tab(:,36),[16,1,2,8,4],[nMB,nMW,nMB,nMB,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,36),heltab2x48(:,:,36))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMB,G1H24(36),n2h24(36))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(37),h0tab(:,37),[16,2,4,1,8],[nMB,nMW,nMW,nMB,nMB],5,0)
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,37),heltab2x48(:,:,37))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMB,G1H24(37),n2h24(37))
  Gcoeff(:)%j = (c(12)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(38),h0tab(:,38),[16,2,4,1,8],[nMB,nMW,nMW,nMB,nMB],5,0)
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,38),heltab2x48(:,:,38))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMB,G1H24(38),n2h24(38))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(39),h0tab(:,39),[16,2,4,1,8],[nMB,nMW,nMW,nMB,nMB],5,0)
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,39),heltab2x48(:,:,39))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMB,G1H24(39),n2h24(39))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(40),h0tab(:,40),[16,2,4,1,8],[nMB,nMW,nMW,nMB,nMB],5,0)
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,40),heltab2x48(:,:,40))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMB,G1H24(40),n2h24(40))
  Gcoeff(:)%j = (c(9)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(41),h0tab(:,41),[16,2,8,1,4],[nMT,nMZ,nMH,nMT,nMT],5,0)
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,41),heltab2x48(:,:,41))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMT,G1H24(41),n2h24(41))
  Gcoeff(:)%j = (c(9)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(42),h0tab(:,42),[16,2,8,1,4],[nMT,nMH,nMZ,nMT,nMT],5,0)
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,42),heltab2x48(:,:,42))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMT,G1H24(42),n2h24(42))
  Gcoeff(:)%j = (-(c(32)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(43),h0tab(:,43),[16,2,8,1,4],[nMB,nMW,nMW,nMB,nMB],5,0)
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,43),heltab2x48(:,:,43))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMB,G1H24(43),n2h24(43))
  Gcoeff(:)%j = (c(14)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(44),h0tab(:,44),[16,2,8,1,4],[nMT,nMZ,nMH,nMT,nMT],5,0)
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,44),heltab2x48(:,:,44))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMT,G1H24(44),n2h24(44))
  Gcoeff(:)%j = (c(19)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(45),h0tab(:,45),[16,2,8,1,4],[nMB,nMW,nMW,nMB,nMB],5,0)
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,45),heltab2x48(:,:,45))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMB,G1H24(45),n2h24(45))
  Gcoeff(:)%j = (c(14)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(46),h0tab(:,46),[16,2,8,1,4],[nMT,nMH,nMZ,nMT,nMT],5,0)
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,46),heltab2x48(:,:,46))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMT,G1H24(46),n2h24(46))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(47),h0tab(:,47),[16,2,8,1,4],[nMB,nMW,nMW,nMB,nMB],5,0)
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,47),heltab2x48(:,:,47))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMB,G1H24(47),n2h24(47))
  Gcoeff(:)%j = (c(4)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(48),h0tab(:,48),[16,2,8,1,4],[nMB,nMW,nMW,nMB,nMB],5,0)
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,48),heltab2x48(:,:,48))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMB,G1H24(48),n2h24(48))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(49),h0tab(:,49),[16,1,4,2,8],[nMB,nMW,nMW,nMB,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,49),heltab2x48(:,:,49))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMB,G1H24(49),n2h24(49))
  Gcoeff(:)%j = (c(12)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(50),h0tab(:,50),[16,1,4,2,8],[nMB,nMW,nMW,nMB,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,50),heltab2x48(:,:,50))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMB,G1H24(50),n2h24(50))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(51),h0tab(:,51),[16,1,4,2,8],[nMB,nMW,nMW,nMB,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,51),heltab2x48(:,:,51))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMB,G1H24(51),n2h24(51))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(52),h0tab(:,52),[16,1,4,2,8],[nMB,nMW,nMW,nMB,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,52),heltab2x48(:,:,52))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMB,G1H24(52),n2h24(52))
  Gcoeff(:)%j = (c(34)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(53),h0tab(:,53),[16,1,4,8,2],[nMB,nMW,nMW,nMW,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,53),heltab2x48(:,:,53))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMB,G1H24(53),n2h24(53))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(54),h0tab(:,54),[16,1,4,8,2],[nMB,nMW,nMW,nMW,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,54),heltab2x48(:,:,54))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMB,G1H24(54),n2h24(54))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(55),h0tab(:,55),[16,1,4,8,2],[nMB,nMW,nMW,nMW,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,55),heltab2x48(:,:,55))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMB,G1H24(55),n2h24(55))
  Gcoeff(:)%j = (c(30)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(56),h0tab(:,56),[16,1,4,8,2],[nMB,nMW,nMW,nMW,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,56),heltab2x48(:,:,56))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMB,G1H24(56),n2h24(56))
  Gcoeff(:)%j = (c(6)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(57),h0tab(:,57),[16,1,4,8,2],[nMB,nMW,nMW,nMW,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,57),heltab2x48(:,:,57))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMB,G1H24(57),n2h24(57))
  Gcoeff(:)%j = (c(21)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(58),h0tab(:,58),[16,1,4,8,2],[nMB,nMW,nMW,nMW,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,58),heltab2x48(:,:,58))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMB,G1H24(58),n2h24(58))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(59),h0tab(:,59),[16,1,4,8,2],[nMB,nMW,nMW,nMW,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,59),heltab2x48(:,:,59))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMB,G1H24(59),n2h24(59))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(60),h0tab(:,60),[16,1,4,8,2],[nMB,nMW,nMW,nMW,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,60),heltab2x48(:,:,60))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMB,G1H24(60),n2h24(60))
  Gcoeff(:)%j = (c(9)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(61),h0tab(:,61),[16,1,8,2,4],[nMT,nMH,nMZ,nMT,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,61),heltab2x48(:,:,61))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMT,G1H24(61),n2h24(61))
  Gcoeff(:)%j = (c(9)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(62),h0tab(:,62),[16,1,8,2,4],[nMT,nMZ,nMH,nMT,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,62),heltab2x48(:,:,62))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMT,G1H24(62),n2h24(62))
  Gcoeff(:)%j = (-(c(32)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(63),h0tab(:,63),[16,1,8,2,4],[nMB,nMW,nMW,nMB,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,63),heltab2x48(:,:,63))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMB,G1H24(63),n2h24(63))
  Gcoeff(:)%j = (c(14)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(64),h0tab(:,64),[16,1,8,2,4],[nMT,nMH,nMZ,nMT,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,64),heltab2x48(:,:,64))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMT,G1H24(64),n2h24(64))
  Gcoeff(:)%j = (c(19)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(65),h0tab(:,65),[16,1,8,2,4],[nMB,nMW,nMW,nMB,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,65),heltab2x48(:,:,65))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMB,G1H24(65),n2h24(65))
  Gcoeff(:)%j = (c(14)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(66),h0tab(:,66),[16,1,8,2,4],[nMT,nMZ,nMH,nMT,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,66),heltab2x48(:,:,66))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMT,G1H24(66),n2h24(66))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(67),h0tab(:,67),[16,1,8,2,4],[nMB,nMW,nMW,nMB,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,67),heltab2x48(:,:,67))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMB,G1H24(67),n2h24(67))
  Gcoeff(:)%j = (c(4)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(68),h0tab(:,68),[16,1,8,2,4],[nMB,nMW,nMW,nMB,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,68),heltab2x48(:,:,68))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMB,G1H24(68),n2h24(68))
  Gcoeff(:)%j = (c(34)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(69),h0tab(:,69),[16,1,8,4,2],[nMB,nMW,nMW,nMW,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,69),heltab2x48(:,:,69))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMB,G1H24(69),n2h24(69))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(70),h0tab(:,70),[16,1,8,4,2],[nMB,nMW,nMW,nMW,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,70),heltab2x48(:,:,70))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMB,G1H24(70),n2h24(70))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(71),h0tab(:,71),[16,1,8,4,2],[nMB,nMW,nMW,nMW,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,71),heltab2x48(:,:,71))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMB,G1H24(71),n2h24(71))
  Gcoeff(:)%j = (c(21)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(72),h0tab(:,72),[16,1,8,4,2],[nMB,nMW,nMW,nMW,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,72),heltab2x48(:,:,72))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMB,G1H24(72),n2h24(72))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(73),h0tab(:,73),[16,1,8,4,2],[nMB,nMW,nMW,nMW,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,73),heltab2x48(:,:,73))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMB,G1H24(73),n2h24(73))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(74),h0tab(:,74),[16,1,8,4,2],[nMB,nMW,nMW,nMW,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,74),heltab2x48(:,:,74))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMB,G1H24(74),n2h24(74))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(75),h0tab(:,75),[16,1,8,4,2],[nMB,nMW,nMW,nMW,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,75),heltab2x48(:,:,75))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMB,G1H24(75),n2h24(75))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(76),h0tab(:,76),[16,1,8,4,2],[nMB,nMW,nMW,nMW,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,76),heltab2x48(:,:,76))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMB,G1H24(76),n2h24(76))
  call Hloop_AV_Q(ntryL,G1H24(1),ex3(:),G1H12(1),m3h2x12(:,1),heltab2x24(:,:,1))
  call Hloop_A_Q(ntryL,G1H12(1),20,nMT,G2H12(1),n2h12(1))
  call Hloop_AV_Q(ntryL,G1H24(2),ex3(:),G1H12(1),m3h2x12(:,2),heltab2x24(:,:,2))
  call Hloop_A_Q(ntryL,G1H12(1),20,nMT,G2H12(2),n2h12(2))
  call Hloop_AV_Q(ntryL,G1H24(3),ex3(:),G1H12(1),m3h2x12(:,3),heltab2x24(:,:,3))
  call Hloop_A_Q(ntryL,G1H12(1),20,nMB,G2H12(3),n2h12(3))
  call Hloop_AV_Q(ntryL,G1H24(4),ex3(:),G1H12(1),m3h2x12(:,4),heltab2x24(:,:,4))
  call Hloop_A_Q(ntryL,G1H12(1),20,nMT,G2H12(4),n2h12(4))
  call Hloop_AV_Q(ntryL,G1H24(5),ex3(:),G1H12(1),m3h2x12(:,5),heltab2x24(:,:,5))
  call Hloop_A_Q(ntryL,G1H12(1),20,nMT,G2H12(5),n2h12(5))
  call Hloop_AV_Q(ntryL,G1H24(6),ex3(:),G1H12(1),m3h2x12(:,6),heltab2x24(:,:,6))
  call Hloop_A_Q(ntryL,G1H12(1),20,nMB,G2H12(6),n2h12(6))
  call Hloop_QA_S(ntryL,G1H24(7),ex2(:),G1H12(1),ngH,m3h2x12(:,7),heltab2x24(:,:,7))
  call Hloop_QA_S(ntryL,G1H24(8),ex2(:),G1H12(2),ngX,m3h2x12(:,8),heltab2x24(:,:,8))
  call Hloop_QA_S(ntryL,G1H24(9),ex2(:),G1H12(3),ngPtb,m3h2x12(:,9),heltab2x24(:,:,9))
  call Hloop_QA_V(ntryL,G1H24(10),ex2(:),G1H12(4),m3h2x12(:,10),heltab2x24(:,:,10))
  call Hloop_QA_Z(ntryL,G1H24(11),ex2(:),G1H12(5),ngZu,m3h2x12(:,11),heltab2x24(:,:,11))
  call Hloop_QA_W(ntryL,G1H24(12),ex2(:),G1H12(6),m3h2x12(:,12),heltab2x24(:,:,12))
  call Hloop_QV_A(ntryL,G1H24(13),ex3(:),G1H12(7),m3h2x12(:,13),heltab2x24(:,:,13))
  call Hloop_Q_A(ntryL,G1H12(7),20,nMT,G2H12(7),n2h12(7))
  call Hloop_QV_A(ntryL,G1H24(14),ex3(:),G1H12(7),m3h2x12(:,14),heltab2x24(:,:,14))
  call Hloop_Q_A(ntryL,G1H12(7),20,nMT,G2H12(8),n2h12(8))
  call Hloop_QV_A(ntryL,G1H24(15),ex3(:),G1H12(7),m3h2x12(:,15),heltab2x24(:,:,15))
  call Hloop_Q_A(ntryL,G1H12(7),20,nMB,G2H12(9),n2h12(9))
  call Hloop_QV_A(ntryL,G1H24(16),ex3(:),G1H12(7),m3h2x12(:,16),heltab2x24(:,:,16))
  call Hloop_Q_A(ntryL,G1H12(7),20,nMT,G2H12(10),n2h12(10))
  call Hloop_QV_A(ntryL,G1H24(17),ex3(:),G1H12(7),m3h2x12(:,17),heltab2x24(:,:,17))
  call Hloop_Q_A(ntryL,G1H12(7),20,nMT,G2H12(11),n2h12(11))
  call Hloop_QV_A(ntryL,G1H24(18),ex3(:),G1H12(7),m3h2x12(:,18),heltab2x24(:,:,18))
  call Hloop_Q_A(ntryL,G1H12(7),20,nMB,G2H12(12),n2h12(12))
  call Hloop_QA_S(ntryL,G1H24(19),ex2(:),G1H12(7),ngH,m3h2x12(:,19),heltab2x24(:,:,19))
  call Hloop_QA_S(ntryL,G1H24(20),ex2(:),G1H12(8),ngX,m3h2x12(:,20),heltab2x24(:,:,20))
  call Hloop_QA_S(ntryL,G1H24(21),ex2(:),G1H12(9),ngPtb,m3h2x12(:,21),heltab2x24(:,:,21))
  call Hloop_QA_V(ntryL,G1H24(22),ex2(:),G1H12(10),m3h2x12(:,22),heltab2x24(:,:,22))
  call Hloop_QA_Z(ntryL,G1H24(23),ex2(:),G1H12(11),ngZu,m3h2x12(:,23),heltab2x24(:,:,23))
  call Hloop_QA_W(ntryL,G1H24(24),ex2(:),G1H12(12),m3h2x12(:,24),heltab2x24(:,:,24))
  call Hloop_AQ_S(ntryL,G1H24(25),ex1(:),G1H12(13),ngH,m3h2x12(:,25),heltab2x24(:,:,25))
  call Hloop_AQ_S(ntryL,G1H24(26),ex1(:),G1H12(14),ngX,m3h2x12(:,26),heltab2x24(:,:,26))
  call Hloop_AQ_S(ntryL,G1H24(27),ex1(:),G1H12(15),ngPbt,m3h2x12(:,27),heltab2x24(:,:,27))
  call Hloop_AQ_V(ntryL,G1H24(28),ex1(:),G1H12(16),m3h2x12(:,28),heltab2x24(:,:,28))
  call Hloop_AQ_Z(ntryL,G1H24(29),ex1(:),G1H12(17),ngZu,m3h2x12(:,29),heltab2x24(:,:,29))
  call Hloop_AQ_W(ntryL,G1H24(30),ex1(:),G1H12(18),m3h2x12(:,30),heltab2x24(:,:,30))
  call Hloop_AQ_S(ntryL,G1H24(31),ex1(:),G1H12(19),ngH,m3h2x12(:,31),heltab2x24(:,:,31))
  call Hloop_AQ_S(ntryL,G1H24(32),ex1(:),G1H12(20),ngX,m3h2x12(:,32),heltab2x24(:,:,32))
  call Hloop_AQ_S(ntryL,G1H24(33),ex1(:),G1H12(21),ngPbt,m3h2x12(:,33),heltab2x24(:,:,33))
  call Hloop_AQ_V(ntryL,G1H24(34),ex1(:),G1H12(22),m3h2x12(:,34),heltab2x24(:,:,34))
  call Hloop_AQ_Z(ntryL,G1H24(35),ex1(:),G1H12(23),ngZu,m3h2x12(:,35),heltab2x24(:,:,35))
  call Hloop_AQ_W(ntryL,G1H24(36),ex1(:),G1H12(24),m3h2x12(:,36),heltab2x24(:,:,36))
  call Hloop_QA_S(ntryL,G1H24(37),ex2(:),G1H12(25),ngPtb,m3h2x12(:,37),heltab2x24(:,:,37))
  call Hloop_QA_W(ntryL,G1H24(38),ex2(:),G1H12(26),m3h2x12(:,38),heltab2x24(:,:,38))
  call Hloop_QA_S(ntryL,G1H24(39),ex2(:),G1H12(27),ngPtb,m3h2x12(:,39),heltab2x24(:,:,39))
  call Hloop_QA_W(ntryL,G1H24(40),ex2(:),G1H12(28),m3h2x12(:,40),heltab2x24(:,:,40))
  call Hloop_QA_S(ntryL,G1H24(41),ex2(:),G1H12(29),ngX,m3h2x12(:,41),heltab2x24(:,:,41))
  call Hloop_QA_S(ntryL,G1H24(42),ex2(:),G1H12(30),ngH,m3h2x12(:,42),heltab2x24(:,:,42))
  call Hloop_QA_S(ntryL,G1H24(43),ex2(:),G1H12(31),ngPtb,m3h2x12(:,43),heltab2x24(:,:,43))
  call Hloop_QA_Z(ntryL,G1H24(44),ex2(:),G1H12(32),ngZu,m3h2x12(:,44),heltab2x24(:,:,44))
  call Hloop_QA_W(ntryL,G1H24(45),ex2(:),G1H12(33),m3h2x12(:,45),heltab2x24(:,:,45))
  call Hloop_QA_S(ntryL,G1H24(46),ex2(:),G1H12(34),ngH,m3h2x12(:,46),heltab2x24(:,:,46))
  call Hloop_QA_S(ntryL,G1H24(47),ex2(:),G1H12(35),ngPtb,m3h2x12(:,47),heltab2x24(:,:,47))
  call Hloop_QA_W(ntryL,G1H24(48),ex2(:),G1H12(36),m3h2x12(:,48),heltab2x24(:,:,48))
  call Hloop_AQ_S(ntryL,G1H24(49),ex1(:),G1H12(37),ngPbt,m3h2x12(:,49),heltab2x24(:,:,49))
  call Hloop_AQ_S(ntryL,G1H24(50),ex1(:),G1H12(38),ngPbt,m3h2x12(:,50),heltab2x24(:,:,50))
  call Hloop_AQ_W(ntryL,G1H24(51),ex1(:),G1H12(39),m3h2x12(:,51),heltab2x24(:,:,51))
  call Hloop_AQ_W(ntryL,G1H24(52),ex1(:),G1H12(40),m3h2x12(:,52),heltab2x24(:,:,52))
  call Hloop_AQ_S(ntryL,G1H24(53),ex1(:),G1H12(41),ngPbt,m3h2x12(:,53),heltab2x24(:,:,53))
  call Hloop_AQ_S(ntryL,G1H24(54),ex1(:),G1H12(42),ngPbt,m3h2x12(:,54),heltab2x24(:,:,54))
  call Hloop_AQ_S(ntryL,G1H24(55),ex1(:),G1H12(43),ngPbt,m3h2x12(:,55),heltab2x24(:,:,55))
  call Hloop_AQ_W(ntryL,G1H24(56),ex1(:),G1H12(44),m3h2x12(:,56),heltab2x24(:,:,56))
  call Hloop_AQ_S(ntryL,G1H24(57),ex1(:),G1H12(45),ngPbt,m3h2x12(:,57),heltab2x24(:,:,57))
  call Hloop_AQ_W(ntryL,G1H24(58),ex1(:),G1H12(46),m3h2x12(:,58),heltab2x24(:,:,58))
  call Hloop_AQ_W(ntryL,G1H24(59),ex1(:),G1H12(47),m3h2x12(:,59),heltab2x24(:,:,59))
  call Hloop_AQ_W(ntryL,G1H24(60),ex1(:),G1H12(48),m3h2x12(:,60),heltab2x24(:,:,60))
  call Hloop_AQ_S(ntryL,G1H24(61),ex1(:),G1H12(49),ngH,m3h2x12(:,61),heltab2x24(:,:,61))
  call Hloop_AQ_S(ntryL,G1H24(62),ex1(:),G1H12(50),ngX,m3h2x12(:,62),heltab2x24(:,:,62))
  call Hloop_AQ_S(ntryL,G1H24(63),ex1(:),G1H12(51),ngPbt,m3h2x12(:,63),heltab2x24(:,:,63))
  call Hloop_AQ_S(ntryL,G1H24(64),ex1(:),G1H12(52),ngH,m3h2x12(:,64),heltab2x24(:,:,64))
  call Hloop_AQ_S(ntryL,G1H24(65),ex1(:),G1H12(53),ngPbt,m3h2x12(:,65),heltab2x24(:,:,65))
  call Hloop_AQ_Z(ntryL,G1H24(66),ex1(:),G1H12(54),ngZu,m3h2x12(:,66),heltab2x24(:,:,66))
  call Hloop_AQ_W(ntryL,G1H24(67),ex1(:),G1H12(55),m3h2x12(:,67),heltab2x24(:,:,67))
  call Hloop_AQ_W(ntryL,G1H24(68),ex1(:),G1H12(56),m3h2x12(:,68),heltab2x24(:,:,68))
  call Hloop_AQ_S(ntryL,G1H24(69),ex1(:),G1H12(57),ngPbt,m3h2x12(:,69),heltab2x24(:,:,69))
  call Hloop_AQ_S(ntryL,G1H24(70),ex1(:),G1H12(58),ngPbt,m3h2x12(:,70),heltab2x24(:,:,70))
  call Hloop_AQ_S(ntryL,G1H24(71),ex1(:),G1H12(59),ngPbt,m3h2x12(:,71),heltab2x24(:,:,71))
  call Hloop_AQ_W(ntryL,G1H24(72),ex1(:),G1H12(60),m3h2x12(:,72),heltab2x24(:,:,72))
  call Hloop_AQ_S(ntryL,G1H24(73),ex1(:),G1H12(61),ngPbt,m3h2x12(:,73),heltab2x24(:,:,73))
  call Hloop_AQ_W(ntryL,G1H24(74),ex1(:),G1H12(62),m3h2x12(:,74),heltab2x24(:,:,74))
  call Hloop_AQ_W(ntryL,G1H24(75),ex1(:),G1H12(63),m3h2x12(:,75),heltab2x24(:,:,75))
  call Hloop_AQ_W(ntryL,G1H24(76),ex1(:),G1H12(64),m3h2x12(:,76),heltab2x24(:,:,76))
  call Hloop_AQ_S(ntryL,G2H12(1),ex1(:),G2H6(1),ngH,m3h2x6(:,1),heltab2x12(:,:,1))
  call Hloop_AQ_S(ntryL,G2H12(2),ex1(:),G2H6(2),ngX,m3h2x6(:,2),heltab2x12(:,:,2))
  call Hloop_AQ_S(ntryL,G2H12(3),ex1(:),G2H6(3),ngPbt,m3h2x6(:,3),heltab2x12(:,:,3))
  call Hloop_AQ_V(ntryL,G2H12(4),ex1(:),G2H6(4),m3h2x6(:,4),heltab2x12(:,:,4))
  call Hloop_AQ_Z(ntryL,G2H12(5),ex1(:),G2H6(5),ngZu,m3h2x6(:,5),heltab2x12(:,:,5))
  call Hloop_AQ_W(ntryL,G2H12(6),ex1(:),G2H6(6),m3h2x6(:,6),heltab2x12(:,:,6))
  call Hloop_SQ_A(ntryL,G1H12(1),ex1(:),G1H6(1),ngH,m3h2x6(:,7),heltab2x12(:,:,7))
  call Hloop_Q_A(ntryL,G1H6(1),19,nMT,G2H6(7),n2h6(1))
  call Hloop_SQ_A(ntryL,G1H12(2),ex1(:),G1H6(1),ngX,m3h2x6(:,8),heltab2x12(:,:,8))
  call Hloop_Q_A(ntryL,G1H6(1),19,nMT,G2H6(8),n2h6(2))
  call Hloop_SQ_A(ntryL,G1H12(3),ex1(:),G1H6(1),ngPbt,m3h2x6(:,9),heltab2x12(:,:,9))
  call Hloop_Q_A(ntryL,G1H6(1),19,nMB,G2H6(9),n2h6(3))
  call Hloop_VQ_A(ntryL,G1H12(4),ex1(:),G1H6(1),m3h2x6(:,10),heltab2x12(:,:,10))
  call Hloop_Q_A(ntryL,G1H6(1),19,nMT,G2H6(10),n2h6(4))
  call Hloop_ZQ_A(ntryL,G1H12(5),ex1(:),G1H6(1),ngZu,m3h2x6(:,11),heltab2x12(:,:,11))
  call Hloop_Q_A(ntryL,G1H6(1),19,nMT,G2H6(11),n2h6(5))
  call Hloop_WQ_A(ntryL,G1H12(6),ex1(:),G1H6(1),m3h2x6(:,12),heltab2x12(:,:,12))
  call Hloop_Q_A(ntryL,G1H6(1),19,nMB,G2H6(12),n2h6(6))
  call Hloop_QA_S(ntryL,G2H12(7),ex2(:),G2H6(13),ngH,m3h2x6(:,13),heltab2x12(:,:,13))
  call Hloop_QA_S(ntryL,G2H12(8),ex2(:),G2H6(14),ngX,m3h2x6(:,14),heltab2x12(:,:,14))
  call Hloop_QA_S(ntryL,G2H12(9),ex2(:),G2H6(15),ngPtb,m3h2x6(:,15),heltab2x12(:,:,15))
  call Hloop_QA_V(ntryL,G2H12(10),ex2(:),G2H6(16),m3h2x6(:,16),heltab2x12(:,:,16))
  call Hloop_QA_Z(ntryL,G2H12(11),ex2(:),G2H6(17),ngZu,m3h2x6(:,17),heltab2x12(:,:,17))
  call Hloop_QA_W(ntryL,G2H12(12),ex2(:),G2H6(18),m3h2x6(:,18),heltab2x12(:,:,18))
  call Hloop_SQ_A(ntryL,G1H12(7),ex1(:),G1H6(1),ngH,m3h2x6(:,19),heltab2x12(:,:,19))
  call Hloop_Q_A(ntryL,G1H6(1),19,nMT,G2H6(19),n2h6(7))
  call Hloop_SQ_A(ntryL,G1H12(8),ex1(:),G1H6(1),ngX,m3h2x6(:,20),heltab2x12(:,:,20))
  call Hloop_Q_A(ntryL,G1H6(1),19,nMT,G2H6(20),n2h6(8))
  call Hloop_SQ_A(ntryL,G1H12(9),ex1(:),G1H6(1),ngPbt,m3h2x6(:,21),heltab2x12(:,:,21))
  call Hloop_Q_A(ntryL,G1H6(1),19,nMB,G2H6(21),n2h6(9))
  call Hloop_VQ_A(ntryL,G1H12(10),ex1(:),G1H6(1),m3h2x6(:,22),heltab2x12(:,:,22))
  call Hloop_Q_A(ntryL,G1H6(1),19,nMT,G2H6(22),n2h6(10))
  call Hloop_ZQ_A(ntryL,G1H12(11),ex1(:),G1H6(1),ngZu,m3h2x6(:,23),heltab2x12(:,:,23))
  call Hloop_Q_A(ntryL,G1H6(1),19,nMT,G2H6(23),n2h6(11))
  call Hloop_WQ_A(ntryL,G1H12(12),ex1(:),G1H6(1),m3h2x6(:,24),heltab2x12(:,:,24))
  call Hloop_Q_A(ntryL,G1H6(1),19,nMB,G2H6(24),n2h6(12))
  call Hloop_SA_Q(ntryL,G1H12(13),ex2(:),G1H6(1),ngH,m3h2x6(:,25),heltab2x12(:,:,25))
  call Hloop_A_Q(ntryL,G1H6(1),19,nMT,G2H6(25),n2h6(13))
  call Hloop_SA_Q(ntryL,G1H12(14),ex2(:),G1H6(1),ngX,m3h2x6(:,26),heltab2x12(:,:,26))
  call Hloop_A_Q(ntryL,G1H6(1),19,nMT,G2H6(26),n2h6(14))
  call Hloop_SA_Q(ntryL,G1H12(15),ex2(:),G1H6(1),ngPtb,m3h2x6(:,27),heltab2x12(:,:,27))
  call Hloop_A_Q(ntryL,G1H6(1),19,nMB,G2H6(27),n2h6(15))
  call Hloop_VA_Q(ntryL,G1H12(16),ex2(:),G1H6(1),m3h2x6(:,28),heltab2x12(:,:,28))
  call Hloop_A_Q(ntryL,G1H6(1),19,nMT,G2H6(28),n2h6(16))
  call Hloop_ZA_Q(ntryL,G1H12(17),ex2(:),G1H6(1),ngZu,m3h2x6(:,29),heltab2x12(:,:,29))
  call Hloop_A_Q(ntryL,G1H6(1),19,nMT,G2H6(29),n2h6(17))
  call Hloop_WA_Q(ntryL,G1H12(18),ex2(:),G1H6(1),m3h2x6(:,30),heltab2x12(:,:,30))
  call Hloop_A_Q(ntryL,G1H6(1),19,nMB,G2H6(30),n2h6(18))
  call Hloop_SA_Q(ntryL,G1H12(19),ex2(:),G1H6(1),ngH,m3h2x6(:,31),heltab2x12(:,:,31))
  call Hloop_A_Q(ntryL,G1H6(1),19,nMT,G2H6(31),n2h6(19))
  call Hloop_SA_Q(ntryL,G1H12(20),ex2(:),G1H6(1),ngX,m3h2x6(:,32),heltab2x12(:,:,32))
  call Hloop_A_Q(ntryL,G1H6(1),19,nMT,G2H6(32),n2h6(20))
  call Hloop_SA_Q(ntryL,G1H12(21),ex2(:),G1H6(1),ngPtb,m3h2x6(:,33),heltab2x12(:,:,33))
  call Hloop_A_Q(ntryL,G1H6(1),19,nMB,G2H6(33),n2h6(21))
  call Hloop_VA_Q(ntryL,G1H12(22),ex2(:),G1H6(1),m3h2x6(:,34),heltab2x12(:,:,34))
  call Hloop_A_Q(ntryL,G1H6(1),19,nMT,G2H6(34),n2h6(22))
  call Hloop_ZA_Q(ntryL,G1H12(23),ex2(:),G1H6(1),ngZu,m3h2x6(:,35),heltab2x12(:,:,35))
  call Hloop_A_Q(ntryL,G1H6(1),19,nMT,G2H6(35),n2h6(23))
  call Hloop_WA_Q(ntryL,G1H12(24),ex2(:),G1H6(1),m3h2x6(:,36),heltab2x12(:,:,36))
  call Hloop_A_Q(ntryL,G1H6(1),19,nMB,G2H6(36),n2h6(24))
  call Hloop_TV_S(ntryL,G1H12(25),18,ex3(:),4,G2H6(37),m3h2x6(:,37),heltab2x12(:,:,37))
  call Hloop_VV_S(ntryL,G1H12(26),ex3(:),G1H6(1),m3h2x6(:,38),heltab2x12(:,:,38))
  call Hloop_SV_V(ntryL,G1H12(27),ex3(:),G1H6(2),m3h2x6(:,39),heltab2x12(:,:,39))
  call Hloop_UV_W(ntryL,G1H12(28),18,ex3(:),4,G2H6(38),m3h2x6(:,40),heltab2x12(:,:,40))
  call Hloop_SV_T(ntryL,G1H12(29),18,ex4(:),8,G2H4(1),m3h3x4(:,1),heltab2x12(:,:,41))
  call Hloop_TV_S(ntryL,G1H12(30),18,ex4(:),8,G2H4(2),m3h3x4(:,2),heltab2x12(:,:,42))
  call Hloop_TV_S(ntryL,G1H12(31),18,ex4(:),8,G2H4(3),m3h3x4(:,3),heltab2x12(:,:,43))
  call Hloop_VV_S(ntryL,G1H12(32),ex4(:),G1H4(1),m3h3x4(:,4),heltab2x12(:,:,44))
  call Hloop_VV_S(ntryL,G1H12(33),ex4(:),G1H4(2),m3h3x4(:,5),heltab2x12(:,:,45))
  call Hloop_SV_V(ntryL,G1H12(34),ex4(:),G1H4(3),m3h3x4(:,6),heltab2x12(:,:,46))
  call Hloop_SV_V(ntryL,G1H12(35),ex4(:),G1H4(4),m3h3x4(:,7),heltab2x12(:,:,47))
  call Hloop_UV_W(ntryL,G1H12(36),18,ex4(:),8,G2H4(4),m3h3x4(:,8),heltab2x12(:,:,48))
  call Hloop_SV_T(ntryL,G1H12(37),17,ex3(:),4,G2H6(39),m3h2x6(:,41),heltab2x12(:,:,49))
  call Hloop_SV_V(ntryL,G1H12(38),ex3(:),G1H6(3),m3h2x6(:,42),heltab2x12(:,:,50))
  call Hloop_VV_S(ntryL,G1H12(39),ex3(:),G1H6(4),m3h2x6(:,43),heltab2x12(:,:,51))
  call Hloop_UW_V(ntryL,G1H12(40),17,ex3(:),4,G2H6(40),m3h2x6(:,44),heltab2x12(:,:,52))
  call Hloop_SV_T(ntryL,G1H12(41),17,ex3(:),4,G2H6(41),m3h2x6(:,45),heltab2x12(:,:,53))
  call Hloop_SV_V(ntryL,G1H12(42),ex3(:),G1H6(5),m3h2x6(:,46),heltab2x12(:,:,54))
  call Hloop_SV_T(ntryL,G1H12(43),17,ex3(:),4,G2H6(42),m3h2x6(:,47),heltab2x12(:,:,55))
  call Hloop_VV_S(ntryL,G1H12(44),ex3(:),G1H6(6),m3h2x6(:,48),heltab2x12(:,:,56))
  call Hloop_SV_V(ntryL,G1H12(45),ex3(:),G1H6(7),m3h2x6(:,49),heltab2x12(:,:,57))
  call Hloop_UW_V(ntryL,G1H12(46),17,ex3(:),4,G2H6(43),m3h2x6(:,50),heltab2x12(:,:,58))
  call Hloop_VV_S(ntryL,G1H12(47),ex3(:),G1H6(8),m3h2x6(:,51),heltab2x12(:,:,59))
  call Hloop_UW_V(ntryL,G1H12(48),17,ex3(:),4,G2H6(44),m3h2x6(:,52),heltab2x12(:,:,60))
  call Hloop_TV_S(ntryL,G1H12(49),17,ex4(:),8,G2H4(5),m3h3x4(:,9),heltab2x12(:,:,61))
  call Hloop_SV_T(ntryL,G1H12(50),17,ex4(:),8,G2H4(6),m3h3x4(:,10),heltab2x12(:,:,62))
  call Hloop_SV_T(ntryL,G1H12(51),17,ex4(:),8,G2H4(7),m3h3x4(:,11),heltab2x12(:,:,63))
  call Hloop_SV_V(ntryL,G1H12(52),ex4(:),G1H4(5),m3h3x4(:,12),heltab2x12(:,:,64))
  call Hloop_SV_V(ntryL,G1H12(53),ex4(:),G1H4(6),m3h3x4(:,13),heltab2x12(:,:,65))
  call Hloop_VV_S(ntryL,G1H12(54),ex4(:),G1H4(7),m3h3x4(:,14),heltab2x12(:,:,66))
  call Hloop_VV_S(ntryL,G1H12(55),ex4(:),G1H4(8),m3h3x4(:,15),heltab2x12(:,:,67))
  call Hloop_UW_V(ntryL,G1H12(56),17,ex4(:),8,G2H4(8),m3h3x4(:,16),heltab2x12(:,:,68))
  call Hloop_SV_T(ntryL,G1H12(57),17,ex4(:),8,G2H4(9),m3h3x4(:,17),heltab2x12(:,:,69))
  call Hloop_SV_V(ntryL,G1H12(58),ex4(:),G1H4(9),m3h3x4(:,18),heltab2x12(:,:,70))
  call Hloop_SV_T(ntryL,G1H12(59),17,ex4(:),8,G2H4(10),m3h3x4(:,19),heltab2x12(:,:,71))
  call Hloop_VV_S(ntryL,G1H12(60),ex4(:),G1H4(10),m3h3x4(:,20),heltab2x12(:,:,72))
  call Hloop_SV_V(ntryL,G1H12(61),ex4(:),G1H4(11),m3h3x4(:,21),heltab2x12(:,:,73))
  call Hloop_UW_V(ntryL,G1H12(62),17,ex4(:),8,G2H4(11),m3h3x4(:,22),heltab2x12(:,:,74))
  call Hloop_VV_S(ntryL,G1H12(63),ex4(:),G1H4(12),m3h3x4(:,23),heltab2x12(:,:,75))
  call Hloop_UW_V(ntryL,G1H12(64),17,ex4(:),8,G2H4(12),m3h3x4(:,24),heltab2x12(:,:,76))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(11),[G2H6(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(12),[G2H6(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(23),[G2H6(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(24),[G2H6(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(29),[G2H6(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(30),[G2H6(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(35),[G2H6(32)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(36),[G2H6(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(37),[G1H6(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(38),[G1H6(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(1),[G1H4(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(3),[G1H4(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(4),[G1H4(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(39),[G1H6(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(40),[G1H6(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(41),[G1H6(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(43),[G1H6(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(42),[G1H6(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(44),[G1H6(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(6),[G1H4(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(7),[G1H4(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(8),[G1H4(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(9),[G1H4(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(11),[G1H4(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(10),[G1H4(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(12),[G1H4(11)])
  call Hotf_5pt_reduction(G2H6(1),RedSet_5(1),mass5set(:,1),  & 
G1H6(1),G1H6(2),G1H6(4),G1H6(3),G1H6(6),G1H6(5),6)
  call HG1shiftOLR(G1H6(2),8,6)
  call Hotf_5pt_reduction(G2H6(2),RedSet_5(1),mass5set(:,2),  & 
G1H6(8),G1H6(7),G1H6(9),G1H6(10),G1H6(11),G1H6(12),6)
  call HG1shiftOLR(G1H6(7),8,6)
  call Hotf_5pt_reduction(G2H6(3),RedSet_5(1),mass5set(:,3),  & 
G1H6(13),G1H6(14),G1H6(15),G1H6(16),G1H6(17),G1H6(18),6)
  call HG1shiftOLR(G1H6(14),8,6)
  call Hotf_5pt_reduction(G2H6(4),RedSet_5(1),mass5set(:,4),  & 
G1H6(19),G1H6(20),G1H6(21),G1H6(22),G1H6(23),G1H6(24),6)
  call HG1shiftOLR(G1H6(20),8,6)
  call Hotf_5pt_reduction(G2H6(5),RedSet_5(1),mass5set(:,2),  & 
G1H6(25),G1H6(26),G1H6(27),G1H6(28),G1H6(29),G1H6(30),6)
  call HG1shiftOLR(G1H6(26),8,6)
  call Hotf_5pt_reduction(G2H6(6),RedSet_5(1),mass5set(:,3),  & 
G1H6(31),G1H6(32),G1H6(33),G1H6(34),G1H6(35),G1H6(36),6)
  call HG1shiftOLR(G1H6(32),8,6)
  call Hotf_5pt_reduction(G2H6(7),RedSet_5(2),mass5set(:,5),  & 
G1H6(37),G1H6(38),G1H6(39),G1H6(40),G1H6(41),G1H6(42),6)
  call HG1shiftOLR(G1H6(38),8,6)
  call Hotf_5pt_reduction(G2H6(11),RedSet_5(2),mass5set(:,6),  & 
G1H6(43),G1H6(44),G1H6(45),G1H6(46),G1H6(47),G1H6(48),6)
  call HG1shiftOLR(G1H6(44),8,6)
  call Hotf_5pt_reduction(G2H6(12),RedSet_5(2),mass5set(:,7),  & 
G1H6(49),G1H6(50),G1H6(51),G1H6(52),G1H6(53),G1H6(54),6)
  call HG1shiftOLR(G1H6(50),8,6)
  call Hotf_5pt_reduction(G2H6(10),RedSet_5(2),mass5set(:,8),  & 
G1H6(55),G1H6(56),G1H6(57),G1H6(58),G1H6(59),G1H6(60),6)
  call HG1shiftOLR(G1H6(56),8,6)
  call Hotf_5pt_reduction(G2H6(13),RedSet_5(3),mass5set(:,1),  & 
G1H6(61),G1H6(62),G1H6(63),G1H6(64),G1H6(65),G1H6(66),6)
  call HG1shiftOLR(G1H6(62),8,6)
  call Hotf_5pt_reduction(G2H6(14),RedSet_5(3),mass5set(:,2),  & 
G1H6(67),G1H6(68),G1H6(69),G1H6(70),G1H6(71),G1H6(72),6)
  call HG1shiftOLR(G1H6(68),8,6)
  call Hotf_5pt_reduction(G2H6(15),RedSet_5(3),mass5set(:,3),  & 
G1H6(73),G1H6(74),G1H6(75),G1H6(76),G1H6(77),G1H6(78),6)
  call HG1shiftOLR(G1H6(74),8,6)
  call Hotf_5pt_reduction(G2H6(16),RedSet_5(3),mass5set(:,4),  & 
G1H6(79),G1H6(80),G1H6(81),G1H6(82),G1H6(83),G1H6(84),6)
  call HG1shiftOLR(G1H6(80),8,6)
  call Hotf_5pt_reduction(G2H6(17),RedSet_5(3),mass5set(:,2),  & 
G1H6(85),G1H6(86),G1H6(87),G1H6(88),G1H6(89),G1H6(90),6)
  call HG1shiftOLR(G1H6(86),8,6)
  call Hotf_5pt_reduction(G2H6(18),RedSet_5(3),mass5set(:,3),  & 
G1H6(91),G1H6(92),G1H6(93),G1H6(94),G1H6(95),G1H6(96),6)
  call HG1shiftOLR(G1H6(92),8,6)
  call Hotf_5pt_reduction(G2H6(19),RedSet_5(4),mass5set(:,5),  & 
G1H6(97),G1H6(98),G1H6(99),G1H6(100),G1H6(101),G1H6(102),6)
  call HG1shiftOLR(G1H6(98),4,6)
  call Hotf_5pt_reduction(G2H6(23),RedSet_5(4),mass5set(:,6),  & 
G1H6(103),G1H6(104),G1H6(105),G1H6(106),G1H6(107),G1H6(108),6)
  call HG1shiftOLR(G1H6(104),4,6)
  call Hotf_5pt_reduction(G2H6(24),RedSet_5(4),mass5set(:,7),  & 
G1H6(109),G1H6(110),G1H6(111),G1H6(112),G1H6(113),G1H6(114),6)
  call HG1shiftOLR(G1H6(110),4,6)
  call Hotf_5pt_reduction(G2H6(22),RedSet_5(4),mass5set(:,8),  & 
G1H6(115),G1H6(116),G1H6(117),G1H6(118),G1H6(119),G1H6(120),6)
  call HG1shiftOLR(G1H6(116),4,6)
  call Hotf_5pt_reduction(G2H6(25),RedSet_5(5),mass5set(:,5),  & 
G1H6(121),G1H6(122),G1H6(123),G1H6(124),G1H6(125),G1H6(126),6)
  call HG1shiftOLR(G1H6(122),8,6)
  call Hotf_5pt_reduction(G2H6(29),RedSet_5(5),mass5set(:,6),  & 
G1H6(127),G1H6(128),G1H6(129),G1H6(130),G1H6(131),G1H6(132),6)
  call HG1shiftOLR(G1H6(128),8,6)
  call Hotf_5pt_reduction(G2H6(30),RedSet_5(5),mass5set(:,7),  & 
G1H6(133),G1H6(134),G1H6(135),G1H6(136),G1H6(137),G1H6(138),6)
  call HG1shiftOLR(G1H6(134),8,6)
  call Hotf_5pt_reduction(G2H6(28),RedSet_5(5),mass5set(:,8),  & 
G1H6(139),G1H6(140),G1H6(141),G1H6(142),G1H6(143),G1H6(144),6)
  call HG1shiftOLR(G1H6(140),8,6)
  call Hotf_5pt_reduction(G2H6(31),RedSet_5(6),mass5set(:,5),  & 
G1H6(145),G1H6(146),G1H6(147),G1H6(148),G1H6(149),G1H6(150),6)
  call HG1shiftOLR(G1H6(146),4,6)
  call Hotf_5pt_reduction(G2H6(35),RedSet_5(6),mass5set(:,6),  & 
G1H6(151),G1H6(152),G1H6(153),G1H6(154),G1H6(155),G1H6(156),6)
  call HG1shiftOLR(G1H6(152),4,6)
  call Hotf_5pt_reduction(G2H6(36),RedSet_5(6),mass5set(:,7),  & 
G1H6(157),G1H6(158),G1H6(159),G1H6(160),G1H6(161),G1H6(162),6)
  call HG1shiftOLR(G1H6(158),4,6)
  call Hotf_5pt_reduction(G2H6(34),RedSet_5(6),mass5set(:,8),  & 
G1H6(163),G1H6(164),G1H6(165),G1H6(166),G1H6(167),G1H6(168),6)
  call HG1shiftOLR(G1H6(164),4,6)
  call Hotf_5pt_reduction(G2H6(37),RedSet_5(7),mass5set(:,9),  & 
G1H6(169),G1H6(170),G1H6(171),G1H6(172),G1H6(173),G1H6(174),6)
  call HG1shiftOLR(G1H6(170),8,6)
  call Hotf_5pt_reduction(G2H6(38),RedSet_5(7),mass5set(:,9),  & 
G1H6(175),G1H6(176),G1H6(177),G1H6(178),G1H6(179),G1H6(180),6)
  call HG1shiftOLR(G1H6(176),8,6)
  call Hotf_5pt_reduction(G2H4(1),RedSet_5(8),mass5set(:,10),  & 
G1H4(1),G1H4(2),G1H4(4),G1H4(7),G1H4(8),G1H4(6),4)
  call HG1shiftOLR(G1H4(2),4,4)
  call Hotf_5pt_reduction(G2H4(2),RedSet_5(8),mass5set(:,11),  & 
G1H4(10),G1H4(9),G1H4(12),G1H4(11),G1H4(13),G1H4(14),4)
  call HG1shiftOLR(G1H4(9),4,4)
  call Hotf_5pt_reduction(G2H4(3),RedSet_5(8),mass5set(:,9),  & 
G1H4(15),G1H4(16),G1H4(17),G1H4(18),G1H4(19),G1H4(20),4)
  call HG1shiftOLR(G1H4(16),4,4)
  call Hloop_ZQ_A(ntryL,G1H4(3),ex1(:),G1H2(1),ngZu,m3h2x2(:,1),heltab2x4(:,:,1))
  call Hloop_Q_A(ntryL,G1H2(1),27,nMT,G2H2(1),n2h2(1))
  call Hotf_5pt_reduction(G2H4(4),RedSet_5(8),mass5set(:,9),  & 
G1H4(3),G1H4(21),G1H4(22),G1H4(23),G1H4(24),G1H4(25),4)
  call HG1shiftOLR(G1H4(21),4,4)
  call Hotf_5pt_reduction(G2H6(39),RedSet_5(9),mass5set(:,9),  & 
G1H6(181),G1H6(182),G1H6(183),G1H6(184),G1H6(185),G1H6(186),6)
  call HG1shiftOLR(G1H6(182),8,6)
  call Hotf_5pt_reduction(G2H6(40),RedSet_5(9),mass5set(:,9),  & 
G1H6(187),G1H6(188),G1H6(189),G1H6(190),G1H6(191),G1H6(192),6)
  call HG1shiftOLR(G1H6(188),8,6)
  call Hotf_5pt_reduction(G2H6(41),RedSet_5(10),mass5set(:,12),  & 
G1H6(193),G1H6(194),G1H6(195),G1H6(196),G1H6(197),G1H6(198),6)
  call HG1shiftOLR(G1H6(194),2,6)
  call Hloop_VV_S(ntryL,G2H6(43),ex4(:),G2H2(2),m3h3x2(:,1),heltab2x6(:,:,1))
  call Hloop_SV_V(ntryL,G2H6(42),ex4(:),G2H2(3),m3h3x2(:,2),heltab2x6(:,:,2))
  call Hotf_5pt_reduction(G2H6(44),RedSet_5(10),mass5set(:,12),  & 
G1H6(199),G1H6(200),G1H6(201),G1H6(202),G1H6(203),G1H6(204),6)
  call HG1shiftOLR(G1H6(200),2,6)
  call Hotf_5pt_reduction(G2H4(5),RedSet_5(11),mass5set(:,11),  & 
G1H4(26),G1H4(27),G1H4(28),G1H4(29),G1H4(30),G1H4(31),4)
  call HG1shiftOLR(G1H4(27),4,4)
  call Hotf_5pt_reduction(G2H4(6),RedSet_5(11),mass5set(:,10),  & 
G1H4(32),G1H4(33),G1H4(34),G1H4(35),G1H4(36),G1H4(37),4)
  call HG1shiftOLR(G1H4(33),4,4)
  call Hotf_5pt_reduction(G2H4(7),RedSet_5(11),mass5set(:,9),  & 
G1H4(38),G1H4(39),G1H4(40),G1H4(41),G1H4(42),G1H4(43),4)
  call HG1shiftOLR(G1H4(39),4,4)
  call Hloop_ZA_Q(ntryL,G1H4(5),ex2(:),G1H2(1),ngZu,m3h2x2(:,2),heltab2x4(:,:,2))
  call Hloop_A_Q(ntryL,G1H2(1),27,nMT,G2H2(4),n2h2(2))
  call Hotf_5pt_reduction(G2H4(8),RedSet_5(11),mass5set(:,9),  & 
G1H4(5),G1H4(44),G1H4(45),G1H4(46),G1H4(47),G1H4(48),4)
  call HG1shiftOLR(G1H4(44),4,4)
  call Hotf_5pt_reduction(G2H4(9),RedSet_5(12),mass5set(:,12),  & 
G1H4(49),G1H4(50),G1H4(51),G1H4(52),G1H4(53),G1H4(54),4)
  call HG1shiftOLR(G1H4(50),2,4)
  call Hloop_VV_S(ntryL,G2H4(11),ex3(:),G2H2(5),m3h2x2(:,3),heltab2x4(:,:,3))
  call Hloop_SV_V(ntryL,G2H4(10),ex3(:),G2H2(6),m3h2x2(:,4),heltab2x4(:,:,4))
  call Hotf_5pt_reduction(G2H4(12),RedSet_5(12),mass5set(:,12),  & 
G1H4(55),G1H4(56),G1H4(57),G1H4(58),G1H4(59),G1H4(60),4)
  call HG1shiftOLR(G1H4(56),2,4)
  call Hloop_SA_Q(ntryL,G1H6(1),ex2(:),G1H3(1),ngH,m3h2x3(:,1),heltab2x6(:,:,3))
  call Hloop_A_Q(ntryL,G1H3(1),23,nMT,G2H3(1),n2h3(1))
call HGT_OLR(G1H6(2),1,1,6)
call HGT_invQ_OLR(G1H6(2),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(2),-8,nMT,G2H6(8),n2h6(25))
  call Hloop_QZ_A(ntryL,G2H6(8),ex4(:),G2H2(7),ngZu,m3h3x2(:,3),heltab2x6(:,:,4))
  call Hloop_SA_Q(ntryL,G1H6(6),ex2(:),G1H3(1),ngH,m3h2x3(:,2),heltab2x6(:,:,5))
  call Hloop_A_Q(ntryL,G1H3(1),23,nMT,G2H3(2),n2h3(2))
  call Hloop_SA_Q(ntryL,G1H6(5),ex2(:),G1H3(1),ngH,m3h2x3(:,3),heltab2x6(:,:,6))
  call Hloop_A_Q(ntryL,G1H3(1),23,nMT,G2H3(3),n2h3(3))
  call Hloop_SA_Q(ntryL,G1H6(8),ex2(:),G1H3(1),ngX,m3h2x3(:,4),heltab2x6(:,:,7))
  call Hloop_A_Q(ntryL,G1H3(1),23,nMT,G2H3(4),n2h3(4))
call HGT_OLR(G1H6(7),1,1,6)
call HGT_invQ_OLR(G1H6(7),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(7),-8,nMT,G2H6(9),n2h6(26))
  call Hloop_QZ_A(ntryL,G2H6(9),ex4(:),G2H2(8),ngZu,m3h3x2(:,4),heltab2x6(:,:,8))
  call Hloop_SA_Q(ntryL,G1H6(11),ex2(:),G1H3(1),ngX,m3h2x3(:,5),heltab2x6(:,:,9))
  call Hloop_A_Q(ntryL,G1H3(1),23,nMT,G2H3(5),n2h3(5))
  call Hloop_SA_Q(ntryL,G1H6(12),ex2(:),G1H3(1),ngX,m3h2x3(:,6),heltab2x6(:,:,10))
  call Hloop_A_Q(ntryL,G1H3(1),23,nMT,G2H3(6),n2h3(6))
  call Hloop_SA_Q(ntryL,G1H6(13),ex2(:),G1H3(1),ngPtb,m3h2x3(:,7),heltab2x6(:,:,11))
  call Hloop_A_Q(ntryL,G1H3(1),23,nMB,G2H3(7),n2h3(7))
call HGT_OLR(G1H6(14),1,1,6)
call HGT_invQ_OLR(G1H6(14),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(14),-8,nMB,G2H6(20),n2h6(27))
  call Hloop_QZ_A(ntryL,G2H6(20),ex4(:),G2H2(9),ngZd,m3h3x2(:,5),heltab2x6(:,:,12))
  call Hloop_SA_Q(ntryL,G1H6(17),ex2(:),G1H3(1),ngPtb,m3h2x3(:,8),heltab2x6(:,:,13))
  call Hloop_A_Q(ntryL,G1H3(1),23,nMB,G2H3(8),n2h3(8))
  call Hloop_SA_Q(ntryL,G1H6(18),ex2(:),G1H3(1),ngPtb,m3h2x3(:,9),heltab2x6(:,:,14))
  call Hloop_A_Q(ntryL,G1H3(1),23,nMB,G2H3(9),n2h3(9))
  call Hloop_VA_Q(ntryL,G1H6(19),ex2(:),G1H3(1),m3h2x3(:,10),heltab2x6(:,:,15))
  call Hloop_A_Q(ntryL,G1H3(1),23,nMT,G2H3(10),n2h3(10))
call HGT_OLR(G1H6(20),1,1,6)
call HGT_invQ_OLR(G1H6(20),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(20),-8,nMT,G2H6(21),n2h6(28))
  call Hloop_QZ_A(ntryL,G2H6(21),ex4(:),G2H2(10),ngZu,m3h3x2(:,6),heltab2x6(:,:,16))
  call Hloop_VA_Q(ntryL,G1H6(23),ex2(:),G1H3(1),m3h2x3(:,11),heltab2x6(:,:,17))
  call Hloop_A_Q(ntryL,G1H3(1),23,nMT,G2H3(11),n2h3(11))
  call Hloop_VA_Q(ntryL,G1H6(24),ex2(:),G1H3(1),m3h2x3(:,12),heltab2x6(:,:,18))
  call Hloop_A_Q(ntryL,G1H3(1),23,nMT,G2H3(12),n2h3(12))
  call Hloop_ZA_Q(ntryL,G1H6(25),ex2(:),G1H3(1),ngZu,m3h2x3(:,13),heltab2x6(:,:,19))
  call Hloop_A_Q(ntryL,G1H3(1),23,nMT,G2H3(13),n2h3(13))
call HGT_OLR(G1H6(26),1,1,6)
call HGT_invQ_OLR(G1H6(26),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(26),-8,nMT,G2H6(26),n2h6(29))
  call Hloop_QZ_A(ntryL,G2H6(26),ex4(:),G2H2(11),ngZu,m3h3x2(:,7),heltab2x6(:,:,20))
  call Hloop_ZA_Q(ntryL,G1H6(29),ex2(:),G1H3(1),ngZu,m3h2x3(:,14),heltab2x6(:,:,21))
  call Hloop_A_Q(ntryL,G1H3(1),23,nMT,G2H3(14),n2h3(14))
  call Hloop_ZA_Q(ntryL,G1H6(30),ex2(:),G1H3(1),ngZu,m3h2x3(:,15),heltab2x6(:,:,22))
  call Hloop_A_Q(ntryL,G1H3(1),23,nMT,G2H3(15),n2h3(15))
  call Hloop_WA_Q(ntryL,G1H6(31),ex2(:),G1H3(1),m3h2x3(:,16),heltab2x6(:,:,23))
  call Hloop_A_Q(ntryL,G1H3(1),23,nMB,G2H3(16),n2h3(16))
call HGT_OLR(G1H6(32),1,1,6)
call HGT_invQ_OLR(G1H6(32),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(32),-8,nMB,G2H6(27),n2h6(30))
  call Hloop_QZ_A(ntryL,G2H6(27),ex4(:),G2H2(12),ngZd,m3h3x2(:,8),heltab2x6(:,:,24))
  call Hloop_WA_Q(ntryL,G1H6(35),ex2(:),G1H3(1),m3h2x3(:,17),heltab2x6(:,:,25))
  call Hloop_A_Q(ntryL,G1H3(1),23,nMB,G2H3(17),n2h3(17))
  call Hloop_WA_Q(ntryL,G1H6(36),ex2(:),G1H3(1),m3h2x3(:,18),heltab2x6(:,:,26))
  call Hloop_A_Q(ntryL,G1H3(1),23,nMB,G2H3(18),n2h3(18))
  call Hloop_QV_A(ntryL,G1H6(37),ex3(:),G1H3(1),m3h2x3(:,19),heltab2x6(:,:,27))
  call Hloop_Q_A(ntryL,G1H3(1),23,nMT,G2H3(19),n2h3(19))
call HGT_OLR(G1H6(38),1,1,6)
call HGT_invQ_OLR(G1H6(38),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(38),-8,nMT,G2H6(32),n2h6(31))
  call Hloop_AZ_Q(ntryL,G2H6(32),ex4(:),G2H2(13),ngZu,m3h3x2(:,9),heltab2x6(:,:,28))
  call Hloop_QV_A(ntryL,G1H6(41),ex3(:),G1H3(1),m3h2x3(:,20),heltab2x6(:,:,29))
  call Hloop_Q_A(ntryL,G1H3(1),23,nMT,G2H3(20),n2h3(20))
  call Hloop_QV_A(ntryL,G1H6(42),ex3(:),G1H3(1),m3h2x3(:,21),heltab2x6(:,:,30))
  call Hloop_Q_A(ntryL,G1H3(1),23,nMT,G2H3(21),n2h3(21))
  call Hloop_QV_A(ntryL,G1H6(43),ex3(:),G1H3(1),m3h2x3(:,22),heltab2x6(:,:,31))
  call Hloop_Q_A(ntryL,G1H3(1),23,nMT,G2H3(22),n2h3(22))
call HGT_OLR(G1H6(44),1,1,6)
call HGT_invQ_OLR(G1H6(44),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(44),-8,nMT,G2H6(33),n2h6(32))
  call Hloop_AZ_Q(ntryL,G2H6(33),ex4(:),G2H2(14),ngZu,m3h3x2(:,10),heltab2x6(:,:,32))
  call Hloop_QV_A(ntryL,G1H6(47),ex3(:),G1H3(1),m3h2x3(:,23),heltab2x6(:,:,33))
  call Hloop_Q_A(ntryL,G1H3(1),23,nMT,G2H3(23),n2h3(23))
  call Hloop_QV_A(ntryL,G1H6(48),ex3(:),G1H3(1),m3h2x3(:,24),heltab2x6(:,:,34))
  call Hloop_Q_A(ntryL,G1H3(1),23,nMT,G2H3(24),n2h3(24))
  call Hloop_QV_A(ntryL,G1H6(49),ex3(:),G1H3(1),m3h2x3(:,25),heltab2x6(:,:,35))
  call Hloop_Q_A(ntryL,G1H3(1),23,nMB,G2H3(25),n2h3(25))
call HGT_OLR(G1H6(50),1,1,6)
call HGT_invQ_OLR(G1H6(50),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(50),-8,nMB,G2H6(1),n2h6(33))
  call Hloop_AZ_Q(ntryL,G2H6(1),ex4(:),G2H2(15),ngZd,m3h3x2(:,11),heltab2x6(:,:,36))
  call Hloop_QV_A(ntryL,G1H6(53),ex3(:),G1H3(1),m3h2x3(:,26),heltab2x6(:,:,37))
  call Hloop_Q_A(ntryL,G1H3(1),23,nMB,G2H3(26),n2h3(26))
  call Hloop_QV_A(ntryL,G1H6(54),ex3(:),G1H3(1),m3h2x3(:,27),heltab2x6(:,:,38))
  call Hloop_Q_A(ntryL,G1H3(1),23,nMB,G2H3(27),n2h3(27))
  call Hloop_QV_A(ntryL,G1H6(55),ex3(:),G1H3(1),m3h2x3(:,28),heltab2x6(:,:,39))
  call Hloop_Q_A(ntryL,G1H3(1),23,nMT,G2H3(28),n2h3(28))
call HGT_OLR(G1H6(56),1,1,6)
call HGT_invQ_OLR(G1H6(56),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(56),-8,nMT,G2H6(2),n2h6(34))
  call Hloop_AZ_Q(ntryL,G2H6(2),ex4(:),G2H2(16),ngZu,m3h3x2(:,12),heltab2x6(:,:,40))
  call Hloop_QV_A(ntryL,G1H6(59),ex3(:),G1H3(1),m3h2x3(:,29),heltab2x6(:,:,41))
  call Hloop_Q_A(ntryL,G1H3(1),23,nMT,G2H3(29),n2h3(29))
  call Hloop_QV_A(ntryL,G1H6(60),ex3(:),G1H3(1),m3h2x3(:,30),heltab2x6(:,:,42))
  call Hloop_Q_A(ntryL,G1H3(1),23,nMT,G2H3(30),n2h3(30))
  call Hloop_SQ_A(ntryL,G1H6(61),ex1(:),G1H3(1),ngH,m3h2x3(:,31),heltab2x6(:,:,43))
  call Hloop_Q_A(ntryL,G1H3(1),23,nMT,G2H3(31),n2h3(31))
call HGT_OLR(G1H6(62),1,1,6)
call HGT_invQ_OLR(G1H6(62),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(62),-8,nMT,G2H6(3),n2h6(35))
  call Hloop_AZ_Q(ntryL,G2H6(3),ex4(:),G2H2(17),ngZu,m3h3x2(:,13),heltab2x6(:,:,44))
  call Hloop_SQ_A(ntryL,G1H6(65),ex1(:),G1H3(1),ngH,m3h2x3(:,32),heltab2x6(:,:,45))
  call Hloop_Q_A(ntryL,G1H3(1),23,nMT,G2H3(32),n2h3(32))
  call Hloop_SQ_A(ntryL,G1H6(66),ex1(:),G1H3(1),ngH,m3h2x3(:,33),heltab2x6(:,:,46))
  call Hloop_Q_A(ntryL,G1H3(1),23,nMT,G2H3(33),n2h3(33))
  call Hloop_SQ_A(ntryL,G1H6(67),ex1(:),G1H3(1),ngX,m3h2x3(:,34),heltab2x6(:,:,47))
  call Hloop_Q_A(ntryL,G1H3(1),23,nMT,G2H3(34),n2h3(34))
call HGT_OLR(G1H6(68),1,1,6)
call HGT_invQ_OLR(G1H6(68),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(68),-8,nMT,G2H6(4),n2h6(36))
  call Hloop_AZ_Q(ntryL,G2H6(4),ex4(:),G2H2(18),ngZu,m3h3x2(:,14),heltab2x6(:,:,48))
  call Hloop_SQ_A(ntryL,G1H6(71),ex1(:),G1H3(1),ngX,m3h2x3(:,35),heltab2x6(:,:,49))
  call Hloop_Q_A(ntryL,G1H3(1),23,nMT,G2H3(35),n2h3(35))
  call Hloop_SQ_A(ntryL,G1H6(72),ex1(:),G1H3(1),ngX,m3h2x3(:,36),heltab2x6(:,:,50))
  call Hloop_Q_A(ntryL,G1H3(1),23,nMT,G2H3(36),n2h3(36))
  call Hloop_SQ_A(ntryL,G1H6(73),ex1(:),G1H3(1),ngPbt,m3h2x3(:,37),heltab2x6(:,:,51))
  call Hloop_Q_A(ntryL,G1H3(1),23,nMB,G2H3(37),n2h3(37))
call HGT_OLR(G1H6(74),1,1,6)
call HGT_invQ_OLR(G1H6(74),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(74),-8,nMB,G2H6(5),n2h6(37))
  call Hloop_AZ_Q(ntryL,G2H6(5),ex4(:),G2H2(19),ngZd,m3h3x2(:,15),heltab2x6(:,:,52))
  call Hloop_SQ_A(ntryL,G1H6(77),ex1(:),G1H3(1),ngPbt,m3h2x3(:,38),heltab2x6(:,:,53))
  call Hloop_Q_A(ntryL,G1H3(1),23,nMB,G2H3(38),n2h3(38))
  call Hloop_SQ_A(ntryL,G1H6(78),ex1(:),G1H3(1),ngPbt,m3h2x3(:,39),heltab2x6(:,:,54))
  call Hloop_Q_A(ntryL,G1H3(1),23,nMB,G2H3(39),n2h3(39))
  call Hloop_VQ_A(ntryL,G1H6(79),ex1(:),G1H3(1),m3h2x3(:,40),heltab2x6(:,:,55))
  call Hloop_Q_A(ntryL,G1H3(1),23,nMT,G2H3(40),n2h3(40))
call HGT_OLR(G1H6(80),1,1,6)
call HGT_invQ_OLR(G1H6(80),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(80),-8,nMT,G2H6(6),n2h6(38))
  call Hloop_AZ_Q(ntryL,G2H6(6),ex4(:),G2H2(20),ngZu,m3h3x2(:,16),heltab2x6(:,:,56))
  call Hloop_VQ_A(ntryL,G1H6(83),ex1(:),G1H3(1),m3h2x3(:,41),heltab2x6(:,:,57))
  call Hloop_Q_A(ntryL,G1H3(1),23,nMT,G2H3(41),n2h3(41))
  call Hloop_VQ_A(ntryL,G1H6(84),ex1(:),G1H3(1),m3h2x3(:,42),heltab2x6(:,:,58))
  call Hloop_Q_A(ntryL,G1H3(1),23,nMT,G2H3(42),n2h3(42))
  call Hloop_ZQ_A(ntryL,G1H6(85),ex1(:),G1H3(1),ngZu,m3h2x3(:,43),heltab2x6(:,:,59))
  call Hloop_Q_A(ntryL,G1H3(1),23,nMT,G2H3(43),n2h3(43))
call HGT_OLR(G1H6(86),1,1,6)
call HGT_invQ_OLR(G1H6(86),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(86),-8,nMT,G2H6(7),n2h6(39))
  call Hloop_AZ_Q(ntryL,G2H6(7),ex4(:),G2H2(21),ngZu,m3h3x2(:,17),heltab2x6(:,:,60))
  call Hloop_ZQ_A(ntryL,G1H6(89),ex1(:),G1H3(1),ngZu,m3h2x3(:,44),heltab2x6(:,:,61))
  call Hloop_Q_A(ntryL,G1H3(1),23,nMT,G2H3(44),n2h3(44))
  call Hloop_ZQ_A(ntryL,G1H6(90),ex1(:),G1H3(1),ngZu,m3h2x3(:,45),heltab2x6(:,:,62))
  call Hloop_Q_A(ntryL,G1H3(1),23,nMT,G2H3(45),n2h3(45))
  call Hloop_WQ_A(ntryL,G1H6(91),ex1(:),G1H3(1),m3h2x3(:,46),heltab2x6(:,:,63))
  call Hloop_Q_A(ntryL,G1H3(1),23,nMB,G2H3(46),n2h3(46))
call HGT_OLR(G1H6(92),1,1,6)
call HGT_invQ_OLR(G1H6(92),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(92),-8,nMB,G2H6(11),n2h6(40))
  call Hloop_AZ_Q(ntryL,G2H6(11),ex4(:),G2H2(22),ngZd,m3h3x2(:,18),heltab2x6(:,:,64))
  call Hloop_WQ_A(ntryL,G1H6(95),ex1(:),G1H3(1),m3h2x3(:,47),heltab2x6(:,:,65))
  call Hloop_Q_A(ntryL,G1H3(1),23,nMB,G2H3(47),n2h3(47))
  call Hloop_WQ_A(ntryL,G1H6(96),ex1(:),G1H3(1),m3h2x3(:,48),heltab2x6(:,:,66))
  call Hloop_Q_A(ntryL,G1H3(1),23,nMB,G2H3(48),n2h3(48))
  call Hloop_QZ_A(ntryL,G1H6(97),ex4(:),G1H2(1),ngZu,m3h3x2(:,19),heltab2x6(:,:,67))
  call Hloop_Q_A(ntryL,G1H2(1),27,nMT,G2H2(23),n2h2(3))
call HGT_OLR(G1H6(98),1,1,6)
call HGT_invQ_OLR(G1H6(98),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(98),-4,nMT,G2H6(12),n2h6(41))
  call Hloop_AV_Q(ntryL,G2H6(12),ex3(:),G2H3(49),m3h2x3(:,49),heltab2x6(:,:,68))
  call Hloop_QZ_A(ntryL,G1H6(101),ex4(:),G1H2(1),ngZu,m3h3x2(:,20),heltab2x6(:,:,69))
  call Hloop_Q_A(ntryL,G1H2(1),27,nMT,G2H2(24),n2h2(4))
  call Hloop_QZ_A(ntryL,G1H6(102),ex4(:),G1H2(1),ngZu,m3h3x2(:,21),heltab2x6(:,:,70))
  call Hloop_Q_A(ntryL,G1H2(1),27,nMT,G2H2(25),n2h2(5))
  call Hloop_QZ_A(ntryL,G1H6(103),ex4(:),G1H2(1),ngZu,m3h3x2(:,22),heltab2x6(:,:,71))
  call Hloop_Q_A(ntryL,G1H2(1),27,nMT,G2H2(26),n2h2(6))
call HGT_OLR(G1H6(104),1,1,6)
call HGT_invQ_OLR(G1H6(104),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(104),-4,nMT,G2H6(10),n2h6(42))
  call Hloop_AV_Q(ntryL,G2H6(10),ex3(:),G2H3(50),m3h2x3(:,50),heltab2x6(:,:,72))
  call Hloop_QZ_A(ntryL,G1H6(107),ex4(:),G1H2(1),ngZu,m3h3x2(:,23),heltab2x6(:,:,73))
  call Hloop_Q_A(ntryL,G1H2(1),27,nMT,G2H2(27),n2h2(7))
  call Hloop_QZ_A(ntryL,G1H6(108),ex4(:),G1H2(1),ngZu,m3h3x2(:,24),heltab2x6(:,:,74))
  call Hloop_Q_A(ntryL,G1H2(1),27,nMT,G2H2(28),n2h2(8))
  call Hloop_QZ_A(ntryL,G1H6(109),ex4(:),G1H2(1),ngZd,m3h3x2(:,25),heltab2x6(:,:,75))
  call Hloop_Q_A(ntryL,G1H2(1),27,nMB,G2H2(29),n2h2(9))
call HGT_OLR(G1H6(110),1,1,6)
call HGT_invQ_OLR(G1H6(110),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(110),-4,nMB,G2H6(13),n2h6(43))
  call Hloop_AV_Q(ntryL,G2H6(13),ex3(:),G2H3(51),m3h2x3(:,51),heltab2x6(:,:,76))
  call Hloop_QZ_A(ntryL,G1H6(113),ex4(:),G1H2(1),ngZd,m3h3x2(:,26),heltab2x6(:,:,77))
  call Hloop_Q_A(ntryL,G1H2(1),27,nMB,G2H2(30),n2h2(10))
  call Hloop_QZ_A(ntryL,G1H6(114),ex4(:),G1H2(1),ngZd,m3h3x2(:,27),heltab2x6(:,:,78))
  call Hloop_Q_A(ntryL,G1H2(1),27,nMB,G2H2(31),n2h2(11))
  call Hloop_QZ_A(ntryL,G1H6(115),ex4(:),G1H2(1),ngZu,m3h3x2(:,28),heltab2x6(:,:,79))
  call Hloop_Q_A(ntryL,G1H2(1),27,nMT,G2H2(32),n2h2(12))
call HGT_OLR(G1H6(116),1,1,6)
call HGT_invQ_OLR(G1H6(116),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(116),-4,nMT,G2H6(14),n2h6(44))
  call Hloop_AV_Q(ntryL,G2H6(14),ex3(:),G2H3(52),m3h2x3(:,52),heltab2x6(:,:,80))
  call Hloop_QZ_A(ntryL,G1H6(119),ex4(:),G1H2(1),ngZu,m3h3x2(:,29),heltab2x6(:,:,81))
  call Hloop_Q_A(ntryL,G1H2(1),27,nMT,G2H2(33),n2h2(13))
  call Hloop_QZ_A(ntryL,G1H6(120),ex4(:),G1H2(1),ngZu,m3h3x2(:,30),heltab2x6(:,:,82))
  call Hloop_Q_A(ntryL,G1H2(1),27,nMT,G2H2(34),n2h2(14))
  call Hloop_AV_Q(ntryL,G1H6(121),ex3(:),G1H3(1),m3h2x3(:,53),heltab2x6(:,:,83))
  call Hloop_A_Q(ntryL,G1H3(1),23,nMT,G2H3(53),n2h3(49))
call HGT_OLR(G1H6(122),1,1,6)
call HGT_invQ_OLR(G1H6(122),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(122),-8,nMT,G2H6(15),n2h6(45))
  call Hloop_QZ_A(ntryL,G2H6(15),ex4(:),G2H2(35),ngZu,m3h3x2(:,31),heltab2x6(:,:,84))
  call Hloop_AV_Q(ntryL,G1H6(125),ex3(:),G1H3(1),m3h2x3(:,54),heltab2x6(:,:,85))
  call Hloop_A_Q(ntryL,G1H3(1),23,nMT,G2H3(54),n2h3(50))
  call Hloop_AV_Q(ntryL,G1H6(126),ex3(:),G1H3(1),m3h2x3(:,55),heltab2x6(:,:,86))
  call Hloop_A_Q(ntryL,G1H3(1),23,nMT,G2H3(55),n2h3(51))
  call Hloop_AV_Q(ntryL,G1H6(127),ex3(:),G1H3(1),m3h2x3(:,56),heltab2x6(:,:,87))
  call Hloop_A_Q(ntryL,G1H3(1),23,nMT,G2H3(56),n2h3(52))
call HGT_OLR(G1H6(128),1,1,6)
call HGT_invQ_OLR(G1H6(128),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(128),-8,nMT,G2H6(16),n2h6(46))
  call Hloop_QZ_A(ntryL,G2H6(16),ex4(:),G2H2(36),ngZu,m3h3x2(:,32),heltab2x6(:,:,88))
  call Hloop_AV_Q(ntryL,G1H6(131),ex3(:),G1H3(1),m3h2x3(:,57),heltab2x6(:,:,89))
  call Hloop_A_Q(ntryL,G1H3(1),23,nMT,G2H3(57),n2h3(53))
  call Hloop_AV_Q(ntryL,G1H6(132),ex3(:),G1H3(1),m3h2x3(:,58),heltab2x6(:,:,90))
  call Hloop_A_Q(ntryL,G1H3(1),23,nMT,G2H3(58),n2h3(54))
  call Hloop_AV_Q(ntryL,G1H6(133),ex3(:),G1H3(1),m3h2x3(:,59),heltab2x6(:,:,91))
  call Hloop_A_Q(ntryL,G1H3(1),23,nMB,G2H3(59),n2h3(55))
call HGT_OLR(G1H6(134),1,1,6)
call HGT_invQ_OLR(G1H6(134),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(134),-8,nMB,G2H6(17),n2h6(47))
  call Hloop_QZ_A(ntryL,G2H6(17),ex4(:),G2H2(37),ngZd,m3h3x2(:,33),heltab2x6(:,:,92))
  call Hloop_AV_Q(ntryL,G1H6(137),ex3(:),G1H3(1),m3h2x3(:,60),heltab2x6(:,:,93))
  call Hloop_A_Q(ntryL,G1H3(1),23,nMB,G2H3(60),n2h3(56))
  call Hloop_AV_Q(ntryL,G1H6(138),ex3(:),G1H3(1),m3h2x3(:,61),heltab2x6(:,:,94))
  call Hloop_A_Q(ntryL,G1H3(1),23,nMB,G2H3(61),n2h3(57))
  call Hloop_AV_Q(ntryL,G1H6(139),ex3(:),G1H3(1),m3h2x3(:,62),heltab2x6(:,:,95))
  call Hloop_A_Q(ntryL,G1H3(1),23,nMT,G2H3(62),n2h3(58))
call HGT_OLR(G1H6(140),1,1,6)
call HGT_invQ_OLR(G1H6(140),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(140),-8,nMT,G2H6(18),n2h6(48))
  call Hloop_QZ_A(ntryL,G2H6(18),ex4(:),G2H2(38),ngZu,m3h3x2(:,34),heltab2x6(:,:,96))
  call Hloop_AV_Q(ntryL,G1H6(143),ex3(:),G1H3(1),m3h2x3(:,63),heltab2x6(:,:,97))
  call Hloop_A_Q(ntryL,G1H3(1),23,nMT,G2H3(63),n2h3(59))
  call Hloop_AV_Q(ntryL,G1H6(144),ex3(:),G1H3(1),m3h2x3(:,64),heltab2x6(:,:,98))
  call Hloop_A_Q(ntryL,G1H3(1),23,nMT,G2H3(64),n2h3(60))
  call Hloop_AZ_Q(ntryL,G1H6(145),ex4(:),G1H2(1),ngZu,m3h3x2(:,35),heltab2x6(:,:,99))
  call Hloop_A_Q(ntryL,G1H2(1),27,nMT,G2H2(39),n2h2(15))
call HGT_OLR(G1H6(146),1,1,6)
call HGT_invQ_OLR(G1H6(146),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(146),-4,nMT,G2H6(19),n2h6(49))
  call Hloop_QV_A(ntryL,G2H6(19),ex3(:),G2H3(65),m3h2x3(:,65),heltab2x6(:,:,100))
  call Hloop_AZ_Q(ntryL,G1H6(149),ex4(:),G1H2(1),ngZu,m3h3x2(:,36),heltab2x6(:,:,101))
  call Hloop_A_Q(ntryL,G1H2(1),27,nMT,G2H2(40),n2h2(16))
  call Hloop_AZ_Q(ntryL,G1H6(150),ex4(:),G1H2(1),ngZu,m3h3x2(:,37),heltab2x6(:,:,102))
  call Hloop_A_Q(ntryL,G1H2(1),27,nMT,G2H2(41),n2h2(17))
  call Hloop_AZ_Q(ntryL,G1H6(151),ex4(:),G1H2(1),ngZu,m3h3x2(:,38),heltab2x6(:,:,103))
  call Hloop_A_Q(ntryL,G1H2(1),27,nMT,G2H2(42),n2h2(18))
call HGT_OLR(G1H6(152),1,1,6)
call HGT_invQ_OLR(G1H6(152),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(152),-4,nMT,G2H6(23),n2h6(50))
  call Hloop_QV_A(ntryL,G2H6(23),ex3(:),G2H3(66),m3h2x3(:,66),heltab2x6(:,:,104))
  call Hloop_AZ_Q(ntryL,G1H6(155),ex4(:),G1H2(1),ngZu,m3h3x2(:,39),heltab2x6(:,:,105))
  call Hloop_A_Q(ntryL,G1H2(1),27,nMT,G2H2(43),n2h2(19))
  call Hloop_AZ_Q(ntryL,G1H6(156),ex4(:),G1H2(1),ngZu,m3h3x2(:,40),heltab2x6(:,:,106))
  call Hloop_A_Q(ntryL,G1H2(1),27,nMT,G2H2(44),n2h2(20))
  call Hloop_AZ_Q(ntryL,G1H6(157),ex4(:),G1H2(1),ngZd,m3h3x2(:,41),heltab2x6(:,:,107))
  call Hloop_A_Q(ntryL,G1H2(1),27,nMB,G2H2(45),n2h2(21))
call HGT_OLR(G1H6(158),1,1,6)
call HGT_invQ_OLR(G1H6(158),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(158),-4,nMB,G2H6(24),n2h6(51))
  call Hloop_QV_A(ntryL,G2H6(24),ex3(:),G2H3(67),m3h2x3(:,67),heltab2x6(:,:,108))
  call Hloop_AZ_Q(ntryL,G1H6(161),ex4(:),G1H2(1),ngZd,m3h3x2(:,42),heltab2x6(:,:,109))
  call Hloop_A_Q(ntryL,G1H2(1),27,nMB,G2H2(46),n2h2(22))
  call Hloop_AZ_Q(ntryL,G1H6(162),ex4(:),G1H2(1),ngZd,m3h3x2(:,43),heltab2x6(:,:,110))
  call Hloop_A_Q(ntryL,G1H2(1),27,nMB,G2H2(47),n2h2(23))
  call Hloop_AZ_Q(ntryL,G1H6(163),ex4(:),G1H2(1),ngZu,m3h3x2(:,44),heltab2x6(:,:,111))
  call Hloop_A_Q(ntryL,G1H2(1),27,nMT,G2H2(48),n2h2(24))
call HGT_OLR(G1H6(164),1,1,6)
call HGT_invQ_OLR(G1H6(164),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(164),-4,nMT,G2H6(22),n2h6(52))
  call Hloop_QV_A(ntryL,G2H6(22),ex3(:),G2H3(68),m3h2x3(:,68),heltab2x6(:,:,112))
  call Hloop_AZ_Q(ntryL,G1H6(167),ex4(:),G1H2(1),ngZu,m3h3x2(:,45),heltab2x6(:,:,113))
  call Hloop_A_Q(ntryL,G1H2(1),27,nMT,G2H2(49),n2h2(25))
  call Hloop_AZ_Q(ntryL,G1H6(168),ex4(:),G1H2(1),ngZu,m3h3x2(:,46),heltab2x6(:,:,114))
  call Hloop_A_Q(ntryL,G1H2(1),27,nMT,G2H2(50),n2h2(26))
  call Hloop_SQ_A(ntryL,G1H6(169),ex1(:),G1H3(1),ngPbt,m3h2x3(:,69),heltab2x6(:,:,115))
  call Hloop_Q_A(ntryL,G1H3(1),23,nMB,G2H3(69),n2h3(61))
call HGT_OLR(G1H6(170),1,1,6)
call HGT_invQ_OLR(G1H6(170),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(170),-8,nMB,G2H6(25),n2h6(53))
  call Hloop_AZ_Q(ntryL,G2H6(25),ex4(:),G2H2(51),ngZd,m3h3x2(:,47),heltab2x6(:,:,116))
  call Hloop_SQ_A(ntryL,G1H6(173),ex1(:),G1H3(1),ngPbt,m3h2x3(:,70),heltab2x6(:,:,117))
  call Hloop_Q_A(ntryL,G1H3(1),23,nMB,G2H3(70),n2h3(62))
  call Hloop_SQ_A(ntryL,G1H6(174),ex1(:),G1H3(1),ngPbt,m3h2x3(:,71),heltab2x6(:,:,118))
  call Hloop_Q_A(ntryL,G1H3(1),23,nMB,G2H3(71),n2h3(63))
  call Hloop_WQ_A(ntryL,G1H6(175),ex1(:),G1H3(1),m3h2x3(:,72),heltab2x6(:,:,119))
  call Hloop_Q_A(ntryL,G1H3(1),23,nMB,G2H3(72),n2h3(64))
call HGT_OLR(G1H6(176),1,1,6)
call HGT_invQ_OLR(G1H6(176),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(176),-8,nMB,G2H6(29),n2h6(54))
  call Hloop_AZ_Q(ntryL,G2H6(29),ex4(:),G2H2(52),ngZd,m3h3x2(:,48),heltab2x6(:,:,120))
  call Hloop_WQ_A(ntryL,G1H6(179),ex1(:),G1H3(1),m3h2x3(:,73),heltab2x6(:,:,121))
  call Hloop_Q_A(ntryL,G1H3(1),23,nMB,G2H3(73),n2h3(65))
  call Hloop_WQ_A(ntryL,G1H6(180),ex1(:),G1H3(1),m3h2x3(:,74),heltab2x6(:,:,122))
  call Hloop_Q_A(ntryL,G1H3(1),23,nMB,G2H3(74),n2h3(66))
  call Hloop_SQ_A(ntryL,G1H4(1),ex1(:),G1H2(1),ngH,m3h2x2(:,5),heltab2x4(:,:,5))
  call Hloop_Q_A(ntryL,G1H2(1),27,nMT,G2H2(53),n2h2(27))
call HGT_OLR(G1H4(2),1,1,4)
call HGT_invQ_OLR(G1H4(2),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(2),-4,nMT,G2H4(1),n2h4(1))
  call Hloop_AV_Q(ntryL,G2H4(1),ex3(:),G2H2(54),m3h2x2(:,6),heltab2x4(:,:,6))
  call Hloop_SQ_A(ntryL,G1H4(8),ex1(:),G1H2(1),ngH,m3h2x2(:,7),heltab2x4(:,:,7))
  call Hloop_Q_A(ntryL,G1H2(1),27,nMT,G2H2(55),n2h2(28))
  call Hloop_SQ_A(ntryL,G1H4(6),ex1(:),G1H2(1),ngH,m3h2x2(:,8),heltab2x4(:,:,8))
  call Hloop_Q_A(ntryL,G1H2(1),27,nMT,G2H2(56),n2h2(29))
  call Hloop_SQ_A(ntryL,G1H4(10),ex1(:),G1H2(1),ngX,m3h2x2(:,9),heltab2x4(:,:,9))
  call Hloop_Q_A(ntryL,G1H2(1),27,nMT,G2H2(57),n2h2(30))
call HGT_OLR(G1H4(9),1,1,4)
call HGT_invQ_OLR(G1H4(9),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(9),-4,nMT,G2H4(2),n2h4(2))
  call Hloop_AV_Q(ntryL,G2H4(2),ex3(:),G2H2(58),m3h2x2(:,10),heltab2x4(:,:,10))
  call Hloop_SQ_A(ntryL,G1H4(13),ex1(:),G1H2(1),ngX,m3h2x2(:,11),heltab2x4(:,:,11))
  call Hloop_Q_A(ntryL,G1H2(1),27,nMT,G2H2(59),n2h2(31))
  call Hloop_SQ_A(ntryL,G1H4(14),ex1(:),G1H2(1),ngX,m3h2x2(:,12),heltab2x4(:,:,12))
  call Hloop_Q_A(ntryL,G1H2(1),27,nMT,G2H2(60),n2h2(32))
  call Hloop_SQ_A(ntryL,G1H4(15),ex1(:),G1H2(1),ngPbt,m3h2x2(:,13),heltab2x4(:,:,13))
  call Hloop_Q_A(ntryL,G1H2(1),27,nMB,G2H2(61),n2h2(33))
call HGT_OLR(G1H4(16),1,1,4)
call HGT_invQ_OLR(G1H4(16),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(16),-4,nMB,G2H4(3),n2h4(3))
  call Hloop_AV_Q(ntryL,G2H4(3),ex3(:),G2H2(62),m3h2x2(:,14),heltab2x4(:,:,14))
  call Hloop_SQ_A(ntryL,G1H4(19),ex1(:),G1H2(1),ngPbt,m3h2x2(:,15),heltab2x4(:,:,15))
  call Hloop_Q_A(ntryL,G1H2(1),27,nMB,G2H2(63),n2h2(34))
  call Hloop_SQ_A(ntryL,G1H4(20),ex1(:),G1H2(1),ngPbt,m3h2x2(:,16),heltab2x4(:,:,16))
  call Hloop_Q_A(ntryL,G1H2(1),27,nMB,G2H2(64),n2h2(35))
  call Hloop_WQ_A(ntryL,G1H4(3),ex1(:),G1H2(1),m3h2x2(:,17),heltab2x4(:,:,17))
  call Hloop_Q_A(ntryL,G1H2(1),27,nMB,G2H2(65),n2h2(36))
call HGT_OLR(G1H4(21),1,1,4)
call HGT_invQ_OLR(G1H4(21),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(21),-4,nMB,G2H4(4),n2h4(4))
  call Hloop_AV_Q(ntryL,G2H4(4),ex3(:),G2H2(66),m3h2x2(:,18),heltab2x4(:,:,18))
  call Hloop_WQ_A(ntryL,G1H4(24),ex1(:),G1H2(1),m3h2x2(:,19),heltab2x4(:,:,19))
  call Hloop_Q_A(ntryL,G1H2(1),27,nMB,G2H2(67),n2h2(37))
  call Hloop_WQ_A(ntryL,G1H4(25),ex1(:),G1H2(1),m3h2x2(:,20),heltab2x4(:,:,20))
  call Hloop_Q_A(ntryL,G1H2(1),27,nMB,G2H2(68),n2h2(38))
  call Hloop_SA_Q(ntryL,G1H6(181),ex2(:),G1H3(1),ngPtb,m3h2x3(:,75),heltab2x6(:,:,123))
  call Hloop_A_Q(ntryL,G1H3(1),23,nMB,G2H3(75),n2h3(67))
call HGT_OLR(G1H6(182),1,1,6)
call HGT_invQ_OLR(G1H6(182),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(182),-8,nMB,G2H6(30),n2h6(55))
  call Hloop_QZ_A(ntryL,G2H6(30),ex4(:),G2H2(69),ngZd,m3h3x2(:,49),heltab2x6(:,:,124))
  call Hloop_SA_Q(ntryL,G1H6(185),ex2(:),G1H3(1),ngPtb,m3h2x3(:,76),heltab2x6(:,:,125))
  call Hloop_A_Q(ntryL,G1H3(1),23,nMB,G2H3(76),n2h3(68))
  call Hloop_SA_Q(ntryL,G1H6(186),ex2(:),G1H3(1),ngPtb,m3h2x3(:,77),heltab2x6(:,:,126))
  call Hloop_A_Q(ntryL,G1H3(1),23,nMB,G2H3(77),n2h3(69))
  call Hloop_WA_Q(ntryL,G1H6(187),ex2(:),G1H3(1),m3h2x3(:,78),heltab2x6(:,:,127))
  call Hloop_A_Q(ntryL,G1H3(1),23,nMB,G2H3(78),n2h3(70))
call HGT_OLR(G1H6(188),1,1,6)
call HGT_invQ_OLR(G1H6(188),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(188),-8,nMB,G2H6(28),n2h6(56))
  call Hloop_QZ_A(ntryL,G2H6(28),ex4(:),G2H2(70),ngZd,m3h3x2(:,50),heltab2x6(:,:,128))
  call Hloop_WA_Q(ntryL,G1H6(191),ex2(:),G1H3(1),m3h2x3(:,79),heltab2x6(:,:,129))
  call Hloop_A_Q(ntryL,G1H3(1),23,nMB,G2H3(79),n2h3(71))
  call Hloop_WA_Q(ntryL,G1H6(192),ex2(:),G1H3(1),m3h2x3(:,80),heltab2x6(:,:,130))
  call Hloop_A_Q(ntryL,G1H3(1),23,nMB,G2H3(80),n2h3(72))
  call Hloop_SV_T(ntryL,G1H6(193),21,ex4(:),8,G2H2(71),m3h3x2(:,51),heltab2x6(:,:,131))
call HGT_OLR(G1H6(194),1,1,6)
call HGT_invQ_OLR(G1H6(194),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(194),-2,nMB,G2H6(31),n2h6(57))
  call Hloop_QA_S(ntryL,G2H6(31),ex2(:),G2H3(81),ngPtb,m3h2x3(:,81),heltab2x6(:,:,132))
  call Hloop_SV_T(ntryL,G1H6(197),21,ex4(:),8,G2H2(72),m3h3x2(:,52),heltab2x6(:,:,133))
  call Hloop_SV_T(ntryL,G1H6(198),21,ex4(:),8,G2H2(73),m3h3x2(:,53),heltab2x6(:,:,134))
  call Hloop_UW_V(ntryL,G1H6(199),21,ex4(:),8,G2H2(74),m3h3x2(:,54),heltab2x6(:,:,135))
call HGT_OLR(G1H6(200),1,1,6)
call HGT_invQ_OLR(G1H6(200),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(200),-2,nMB,G2H6(35),n2h6(58))
  call Hloop_QA_W(ntryL,G2H6(35),ex2(:),G2H3(82),m3h2x3(:,82),heltab2x6(:,:,136))
  call Hloop_UW_V(ntryL,G1H6(203),21,ex4(:),8,G2H2(75),m3h3x2(:,55),heltab2x6(:,:,137))
  call Hloop_UW_V(ntryL,G1H6(204),21,ex4(:),8,G2H2(76),m3h3x2(:,56),heltab2x6(:,:,138))
  call Hloop_SA_Q(ntryL,G1H4(26),ex2(:),G1H2(1),ngX,m3h2x2(:,21),heltab2x4(:,:,21))
  call Hloop_A_Q(ntryL,G1H2(1),27,nMT,G2H2(77),n2h2(39))
call HGT_OLR(G1H4(27),1,1,4)
call HGT_invQ_OLR(G1H4(27),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(27),-4,nMT,G2H4(5),n2h4(5))
  call Hloop_QV_A(ntryL,G2H4(5),ex3(:),G2H2(78),m3h2x2(:,22),heltab2x4(:,:,22))
  call Hloop_SA_Q(ntryL,G1H4(30),ex2(:),G1H2(1),ngX,m3h2x2(:,23),heltab2x4(:,:,23))
  call Hloop_A_Q(ntryL,G1H2(1),27,nMT,G2H2(79),n2h2(40))
  call Hloop_SA_Q(ntryL,G1H4(31),ex2(:),G1H2(1),ngX,m3h2x2(:,24),heltab2x4(:,:,24))
  call Hloop_A_Q(ntryL,G1H2(1),27,nMT,G2H2(80),n2h2(41))
  call Hloop_SA_Q(ntryL,G1H4(32),ex2(:),G1H2(1),ngH,m3h2x2(:,25),heltab2x4(:,:,25))
  call Hloop_A_Q(ntryL,G1H2(1),27,nMT,G2H2(81),n2h2(42))
call HGT_OLR(G1H4(33),1,1,4)
call HGT_invQ_OLR(G1H4(33),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(33),-4,nMT,G2H4(6),n2h4(6))
  call Hloop_QV_A(ntryL,G2H4(6),ex3(:),G2H2(82),m3h2x2(:,26),heltab2x4(:,:,26))
  call Hloop_SA_Q(ntryL,G1H4(36),ex2(:),G1H2(1),ngH,m3h2x2(:,27),heltab2x4(:,:,27))
  call Hloop_A_Q(ntryL,G1H2(1),27,nMT,G2H2(83),n2h2(43))
  call Hloop_SA_Q(ntryL,G1H4(37),ex2(:),G1H2(1),ngH,m3h2x2(:,28),heltab2x4(:,:,28))
  call Hloop_A_Q(ntryL,G1H2(1),27,nMT,G2H2(84),n2h2(44))
  call Hloop_SA_Q(ntryL,G1H4(38),ex2(:),G1H2(1),ngPtb,m3h2x2(:,29),heltab2x4(:,:,29))
  call Hloop_A_Q(ntryL,G1H2(1),27,nMB,G2H2(85),n2h2(45))
call HGT_OLR(G1H4(39),1,1,4)
call HGT_invQ_OLR(G1H4(39),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(39),-4,nMB,G2H4(7),n2h4(7))
  call Hloop_QV_A(ntryL,G2H4(7),ex3(:),G2H2(86),m3h2x2(:,30),heltab2x4(:,:,30))
  call Hloop_SA_Q(ntryL,G1H4(42),ex2(:),G1H2(1),ngPtb,m3h2x2(:,31),heltab2x4(:,:,31))
  call Hloop_A_Q(ntryL,G1H2(1),27,nMB,G2H2(87),n2h2(46))
  call Hloop_SA_Q(ntryL,G1H4(43),ex2(:),G1H2(1),ngPtb,m3h2x2(:,32),heltab2x4(:,:,32))
  call Hloop_A_Q(ntryL,G1H2(1),27,nMB,G2H2(88),n2h2(47))
  call Hloop_WA_Q(ntryL,G1H4(5),ex2(:),G1H2(1),m3h2x2(:,33),heltab2x4(:,:,33))
  call Hloop_A_Q(ntryL,G1H2(1),27,nMB,G2H2(89),n2h2(48))
call HGT_OLR(G1H4(44),1,1,4)
call HGT_invQ_OLR(G1H4(44),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(44),-4,nMB,G2H4(8),n2h4(8))
  call Hloop_QV_A(ntryL,G2H4(8),ex3(:),G2H2(90),m3h2x2(:,34),heltab2x4(:,:,34))
  call Hloop_WA_Q(ntryL,G1H4(47),ex2(:),G1H2(1),m3h2x2(:,35),heltab2x4(:,:,35))
  call Hloop_A_Q(ntryL,G1H2(1),27,nMB,G2H2(91),n2h2(49))
  call Hloop_WA_Q(ntryL,G1H4(48),ex2(:),G1H2(1),m3h2x2(:,36),heltab2x4(:,:,36))
  call Hloop_A_Q(ntryL,G1H2(1),27,nMB,G2H2(92),n2h2(50))
  call Hloop_SV_T(ntryL,G1H4(49),25,ex3(:),4,G2H2(93),m3h2x2(:,37),heltab2x4(:,:,37))
call HGT_OLR(G1H4(50),1,1,4)
call HGT_invQ_OLR(G1H4(50),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(50),-2,nMB,G2H4(9),n2h4(9))
  call Hloop_QA_S(ntryL,G2H4(9),ex2(:),G2H2(94),ngPtb,m3h2x2(:,38),heltab2x4(:,:,38))
  call Hloop_SV_T(ntryL,G1H4(53),25,ex3(:),4,G2H2(95),m3h2x2(:,39),heltab2x4(:,:,39))
  call Hloop_SV_T(ntryL,G1H4(54),25,ex3(:),4,G2H2(96),m3h2x2(:,40),heltab2x4(:,:,40))
  call Hloop_UW_V(ntryL,G1H4(55),25,ex3(:),4,G2H2(97),m3h2x2(:,41),heltab2x4(:,:,41))
call HGT_OLR(G1H4(56),1,1,4)
call HGT_invQ_OLR(G1H4(56),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(56),-2,nMB,G2H4(11),n2h4(10))
  call Hloop_QA_W(ntryL,G2H4(11),ex2(:),G2H2(98),m3h2x2(:,42),heltab2x4(:,:,42))
  call Hloop_UW_V(ntryL,G1H4(59),25,ex3(:),4,G2H2(99),m3h2x2(:,43),heltab2x4(:,:,43))
  call Hloop_UW_V(ntryL,G1H4(60),25,ex3(:),4,G2H2(100),m3h2x2(:,44),heltab2x4(:,:,44))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(57),[G2H2(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(71),[G2H2(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(74),[G2H2(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(77),[G2H2(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(93),[G2H2(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(97),[G2H2(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(13),[G2H3(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(15),[G2H3(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(16),[G2H3(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(18),[G2H3(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(43),[G2H3(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(45),[G2H3(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(46),[G2H3(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(48),[G2H3(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(72),[G2H3(69)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(74),[G2H3(71)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(65),[G2H2(61)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(68),[G2H2(64)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(78),[G2H3(75)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(80),[G2H3(77)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(89),[G2H2(85)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(92),[G2H2(88)])
  call Hotf_5pt_reduction(G2H2(57),RedSet_5(8),mass5set(:,11),  & 
G1H2(1),G1H2(2),G1H2(3),G1H2(4),G1H2(5),G1H2(6),2)
  call HG1shiftOLR(G1H2(2),4,2)
  call Hotf_5pt_reduction(G2H2(71),RedSet_5(10),mass5set(:,12),  & 
G1H2(7),G1H2(8),G1H2(9),G1H2(10),G1H2(11),G1H2(12),2)
  call HG1shiftOLR(G1H2(8),2,2)
  call Hotf_5pt_reduction(G2H2(74),RedSet_5(10),mass5set(:,12),  & 
G1H2(13),G1H2(14),G1H2(15),G1H2(16),G1H2(17),G1H2(18),2)
  call HG1shiftOLR(G1H2(14),2,2)
  call Hotf_5pt_reduction(G2H2(77),RedSet_5(11),mass5set(:,11),  & 
G1H2(19),G1H2(20),G1H2(21),G1H2(22),G1H2(23),G1H2(24),2)
  call HG1shiftOLR(G1H2(20),4,2)
  call Hotf_5pt_reduction(G2H2(93),RedSet_5(12),mass5set(:,12),  & 
G1H2(25),G1H2(26),G1H2(27),G1H2(28),G1H2(29),G1H2(30),2)
  call HG1shiftOLR(G1H2(26),2,2)
  call Hotf_5pt_reduction(G2H2(97),RedSet_5(12),mass5set(:,12),  & 
G1H2(31),G1H2(32),G1H2(33),G1H2(34),G1H2(35),G1H2(36),2)
  call HG1shiftOLR(G1H2(32),2,2)
  call Hotf_5pt_reduction(G2H3(1),RedSet_5(1),mass5set(:,1),  & 
G1H3(1),G1H3(2),G1H3(3),G1H3(4),G1H3(5),G1H3(6),3)
  call HG1shiftOLR(G1H3(2),8,3)
  call Hotf_4pt_reduction(G2H3(3),RedSet_4(1),mass4set(:,1),  & 
G1H3(7),G1H3(8),G1H3(9),G1H3(10),G1H3(11),3)
  call HG1shiftOLR(G1H3(8),10,3)
  call Hotf_5pt_reduction(G2H3(13),RedSet_5(1),mass5set(:,2),  & 
G1H3(12),G1H3(13),G1H3(14),G1H3(15),G1H3(16),G1H3(17),3)
  call HG1shiftOLR(G1H3(13),8,3)
  call Hotf_4pt_reduction(G2H3(15),RedSet_4(1),mass4set(:,2),  & 
G1H3(18),G1H3(19),G1H3(20),G1H3(21),G1H3(22),3)
  call HG1shiftOLR(G1H3(19),10,3)
  call Hotf_5pt_reduction(G2H3(16),RedSet_5(1),mass5set(:,3),  & 
G1H3(23),G1H3(24),G1H3(25),G1H3(26),G1H3(27),G1H3(28),3)
  call HG1shiftOLR(G1H3(24),8,3)
  call Hotf_4pt_reduction(G2H3(18),RedSet_4(1),mass4set(:,3),  & 
G1H3(29),G1H3(30),G1H3(31),G1H3(32),G1H3(33),3)
  call HG1shiftOLR(G1H3(30),10,3)
  call Hotf_5pt_reduction(G2H3(10),RedSet_5(1),mass5set(:,4),  & 
G1H3(34),G1H3(35),G1H3(36),G1H3(37),G1H3(38),G1H3(39),3)
  call HG1shiftOLR(G1H3(35),8,3)
  call Hotf_4pt_reduction(G2H3(12),RedSet_4(1),mass4set(:,4),  & 
G1H3(40),G1H3(41),G1H3(42),G1H3(43),G1H3(44),3)
  call HG1shiftOLR(G1H3(41),10,3)
  call Hotf_5pt_reduction(G2H3(19),RedSet_5(2),mass5set(:,5),  & 
G1H3(45),G1H3(46),G1H3(47),G1H3(48),G1H3(49),G1H3(50),3)
  call HG1shiftOLR(G1H3(46),8,3)
  call Hotf_4pt_reduction(G2H3(21),RedSet_4(2),mass4set(:,5),  & 
G1H3(51),G1H3(52),G1H3(53),G1H3(54),G1H3(55),3)
  call HG1shiftOLR(G1H3(52),12,3)
  call Hotf_5pt_reduction(G2H3(22),RedSet_5(2),mass5set(:,6),  & 
G1H3(56),G1H3(57),G1H3(58),G1H3(59),G1H3(60),G1H3(61),3)
  call HG1shiftOLR(G1H3(57),8,3)
  call Hotf_4pt_reduction(G2H3(24),RedSet_4(2),mass4set(:,6),  & 
G1H3(62),G1H3(63),G1H3(64),G1H3(65),G1H3(66),3)
  call HG1shiftOLR(G1H3(63),12,3)
  call Hotf_5pt_reduction(G2H3(25),RedSet_5(2),mass5set(:,7),  & 
G1H3(67),G1H3(68),G1H3(69),G1H3(70),G1H3(71),G1H3(72),3)
  call HG1shiftOLR(G1H3(68),8,3)
  call Hotf_4pt_reduction(G2H3(27),RedSet_4(2),mass4set(:,7),  & 
G1H3(73),G1H3(74),G1H3(75),G1H3(76),G1H3(77),3)
  call HG1shiftOLR(G1H3(74),12,3)
  call Hotf_5pt_reduction(G2H3(28),RedSet_5(2),mass5set(:,8),  & 
G1H3(78),G1H3(79),G1H3(80),G1H3(81),G1H3(82),G1H3(83),3)
  call HG1shiftOLR(G1H3(79),8,3)
  call Hotf_4pt_reduction(G2H3(30),RedSet_4(2),mass4set(:,8),  & 
G1H3(84),G1H3(85),G1H3(86),G1H3(87),G1H3(88),3)
  call HG1shiftOLR(G1H3(85),12,3)
  call Hotf_5pt_reduction(G2H3(31),RedSet_5(3),mass5set(:,1),  & 
G1H3(89),G1H3(90),G1H3(91),G1H3(92),G1H3(93),G1H3(94),3)
  call HG1shiftOLR(G1H3(90),8,3)
  call Hotf_4pt_reduction(G2H3(33),RedSet_4(3),mass4set(:,1),  & 
G1H3(95),G1H3(96),G1H3(97),G1H3(98),G1H3(99),3)
  call HG1shiftOLR(G1H3(96),9,3)
  call Hotf_5pt_reduction(G2H3(43),RedSet_5(3),mass5set(:,2),  & 
G1H3(100),G1H3(101),G1H3(102),G1H3(103),G1H3(104),G1H3(105),3)
  call HG1shiftOLR(G1H3(101),8,3)
  call Hotf_4pt_reduction(G2H3(45),RedSet_4(3),mass4set(:,2),  & 
G1H3(106),G1H3(107),G1H3(108),G1H3(109),G1H3(110),3)
  call HG1shiftOLR(G1H3(107),9,3)
  call Hotf_5pt_reduction(G2H3(46),RedSet_5(3),mass5set(:,3),  & 
G1H3(111),G1H3(112),G1H3(113),G1H3(114),G1H3(115),G1H3(116),3)
  call HG1shiftOLR(G1H3(112),8,3)
  call Hotf_4pt_reduction(G2H3(48),RedSet_4(3),mass4set(:,3),  & 
G1H3(117),G1H3(118),G1H3(119),G1H3(120),G1H3(121),3)
  call HG1shiftOLR(G1H3(118),9,3)
  call Hotf_5pt_reduction(G2H3(40),RedSet_5(3),mass5set(:,4),  & 
G1H3(122),G1H3(123),G1H3(124),G1H3(125),G1H3(126),G1H3(127),3)
  call HG1shiftOLR(G1H3(123),8,3)
  call Hotf_4pt_reduction(G2H3(42),RedSet_4(3),mass4set(:,4),  & 
G1H3(128),G1H3(129),G1H3(130),G1H3(131),G1H3(132),3)
  call HG1shiftOLR(G1H3(129),9,3)
  call Hotf_5pt_reduction(G2H2(23),RedSet_5(4),mass5set(:,5),  & 
G1H2(37),G1H2(38),G1H2(39),G1H2(40),G1H2(41),G1H2(42),2)
  call HG1shiftOLR(G1H2(38),4,2)
  call Hotf_4pt_reduction(G2H2(25),RedSet_4(2),mass4set(:,5),  & 
G1H2(43),G1H2(44),G1H2(45),G1H2(46),G1H2(47),2)
  call HG1shiftOLR(G1H2(44),12,2)
  call Hotf_5pt_reduction(G2H2(26),RedSet_5(4),mass5set(:,6),  & 
G1H2(48),G1H2(49),G1H2(50),G1H2(51),G1H2(52),G1H2(53),2)
  call HG1shiftOLR(G1H2(49),4,2)
  call Hotf_4pt_reduction(G2H2(28),RedSet_4(2),mass4set(:,6),  & 
G1H2(54),G1H2(55),G1H2(56),G1H2(57),G1H2(58),2)
  call HG1shiftOLR(G1H2(55),12,2)
  call Hotf_5pt_reduction(G2H2(29),RedSet_5(4),mass5set(:,7),  & 
G1H2(59),G1H2(60),G1H2(61),G1H2(62),G1H2(63),G1H2(64),2)
  call HG1shiftOLR(G1H2(60),4,2)
  call Hotf_4pt_reduction(G2H2(31),RedSet_4(2),mass4set(:,7),  & 
G1H2(65),G1H2(66),G1H2(67),G1H2(68),G1H2(69),2)
  call HG1shiftOLR(G1H2(66),12,2)
  call Hotf_5pt_reduction(G2H2(32),RedSet_5(4),mass5set(:,8),  & 
G1H2(70),G1H2(71),G1H2(72),G1H2(73),G1H2(74),G1H2(75),2)
  call HG1shiftOLR(G1H2(71),4,2)
  call Hotf_4pt_reduction(G2H2(34),RedSet_4(2),mass4set(:,8),  & 
G1H2(76),G1H2(77),G1H2(78),G1H2(79),G1H2(80),2)
  call HG1shiftOLR(G1H2(77),12,2)
  call Hotf_5pt_reduction(G2H3(53),RedSet_5(5),mass5set(:,5),  & 
G1H3(133),G1H3(134),G1H3(135),G1H3(136),G1H3(137),G1H3(138),3)
  call HG1shiftOLR(G1H3(134),8,3)
  call Hotf_4pt_reduction(G2H3(55),RedSet_4(4),mass4set(:,5),  & 
G1H3(139),G1H3(140),G1H3(141),G1H3(142),G1H3(143),3)
  call HG1shiftOLR(G1H3(140),12,3)
  call Hotf_5pt_reduction(G2H3(56),RedSet_5(5),mass5set(:,6),  & 
G1H3(144),G1H3(145),G1H3(146),G1H3(147),G1H3(148),G1H3(149),3)
  call HG1shiftOLR(G1H3(145),8,3)
  call Hotf_4pt_reduction(G2H3(58),RedSet_4(4),mass4set(:,6),  & 
G1H3(150),G1H3(151),G1H3(152),G1H3(153),G1H3(154),3)
  call HG1shiftOLR(G1H3(151),12,3)
  call Hotf_5pt_reduction(G2H3(59),RedSet_5(5),mass5set(:,7),  & 
G1H3(155),G1H3(156),G1H3(157),G1H3(158),G1H3(159),G1H3(160),3)
  call HG1shiftOLR(G1H3(156),8,3)
  call Hotf_4pt_reduction(G2H3(61),RedSet_4(4),mass4set(:,7),  & 
G1H3(161),G1H3(162),G1H3(163),G1H3(164),G1H3(165),3)
  call HG1shiftOLR(G1H3(162),12,3)
  call Hotf_5pt_reduction(G2H3(62),RedSet_5(5),mass5set(:,8),  & 
G1H3(166),G1H3(167),G1H3(168),G1H3(169),G1H3(170),G1H3(171),3)
  call HG1shiftOLR(G1H3(167),8,3)
  call Hotf_4pt_reduction(G2H3(64),RedSet_4(4),mass4set(:,8),  & 
G1H3(172),G1H3(173),G1H3(174),G1H3(175),G1H3(176),3)
  call HG1shiftOLR(G1H3(173),12,3)
  call Hotf_5pt_reduction(G2H2(39),RedSet_5(6),mass5set(:,5),  & 
G1H2(81),G1H2(82),G1H2(83),G1H2(84),G1H2(85),G1H2(86),2)
  call HG1shiftOLR(G1H2(82),4,2)
  call Hotf_4pt_reduction(G2H2(41),RedSet_4(4),mass4set(:,5),  & 
G1H2(87),G1H2(88),G1H2(89),G1H2(90),G1H2(91),2)
  call HG1shiftOLR(G1H2(88),12,2)
  call Hotf_5pt_reduction(G2H2(42),RedSet_5(6),mass5set(:,6),  & 
G1H2(92),G1H2(93),G1H2(94),G1H2(95),G1H2(96),G1H2(97),2)
  call HG1shiftOLR(G1H2(93),4,2)
  call Hotf_4pt_reduction(G2H2(44),RedSet_4(4),mass4set(:,6),  & 
G1H2(98),G1H2(99),G1H2(100),G1H2(101),G1H2(102),2)
  call HG1shiftOLR(G1H2(99),12,2)
  call Hotf_5pt_reduction(G2H2(45),RedSet_5(6),mass5set(:,7),  & 
G1H2(103),G1H2(104),G1H2(105),G1H2(106),G1H2(107),G1H2(108),2)
  call HG1shiftOLR(G1H2(104),4,2)
  call Hotf_4pt_reduction(G2H2(47),RedSet_4(4),mass4set(:,7),  & 
G1H2(109),G1H2(110),G1H2(111),G1H2(112),G1H2(113),2)
  call HG1shiftOLR(G1H2(110),12,2)
  call Hotf_5pt_reduction(G2H2(48),RedSet_5(6),mass5set(:,8),  & 
G1H2(114),G1H2(115),G1H2(116),G1H2(117),G1H2(118),G1H2(119),2)
  call HG1shiftOLR(G1H2(115),4,2)
  call Hotf_4pt_reduction(G2H2(50),RedSet_4(4),mass4set(:,8),  & 
G1H2(120),G1H2(121),G1H2(122),G1H2(123),G1H2(124),2)
  call HG1shiftOLR(G1H2(121),12,2)
  call Hotf_5pt_reduction(G2H3(72),RedSet_5(7),mass5set(:,9),  & 
G1H3(177),G1H3(178),G1H3(179),G1H3(180),G1H3(181),G1H3(182),3)
  call HG1shiftOLR(G1H3(178),8,3)
  call Hotf_4pt_reduction(G2H3(74),RedSet_4(5),mass4set(:,9),  & 
G1H3(183),G1H3(184),G1H3(185),G1H3(186),G1H3(187),3)
  call HG1shiftOLR(G1H3(184),9,3)
  call Hotf_5pt_reduction(G2H2(53),RedSet_5(8),mass5set(:,10),  & 
G1H2(125),G1H2(126),G1H2(127),G1H2(128),G1H2(129),G1H2(130),2)
  call HG1shiftOLR(G1H2(126),4,2)
  call Hotf_4pt_reduction(G2H2(56),RedSet_4(6),mass4set(:,10),  & 
G1H2(131),G1H2(132),G1H2(133),G1H2(134),G1H2(135),2)
  call HG1shiftOLR(G1H2(132),5,2)
  call Hotf_4pt_reduction(G2H2(60),RedSet_4(6),mass4set(:,11),  & 
G1H2(136),G1H2(137),G1H2(138),G1H2(139),G1H2(140),2)
  call HG1shiftOLR(G1H2(137),5,2)
  call Hotf_5pt_reduction(G2H2(65),RedSet_5(8),mass5set(:,9),  & 
G1H2(141),G1H2(142),G1H2(143),G1H2(144),G1H2(145),G1H2(146),2)
  call HG1shiftOLR(G1H2(142),4,2)
  call Hotf_4pt_reduction(G2H2(68),RedSet_4(6),mass4set(:,9),  & 
G1H2(147),G1H2(148),G1H2(149),G1H2(150),G1H2(151),2)
  call HG1shiftOLR(G1H2(148),5,2)
  call Hotf_5pt_reduction(G2H3(78),RedSet_5(9),mass5set(:,9),  & 
G1H3(188),G1H3(189),G1H3(190),G1H3(191),G1H3(192),G1H3(193),3)
  call HG1shiftOLR(G1H3(189),8,3)
  call Hotf_4pt_reduction(G2H3(80),RedSet_4(7),mass4set(:,9),  & 
G1H3(194),G1H3(195),G1H3(196),G1H3(197),G1H3(198),3)
  call HG1shiftOLR(G1H3(195),10,3)
  call Hotf_4pt_reduction(G2H2(73),RedSet_4(7),mass4set(:,9),  & 
G1H2(152),G1H2(153),G1H2(154),G1H2(155),G1H2(156),2)
  call HG1shiftOLR(G1H2(153),10,2)
  call Hotf_4pt_reduction(G2H2(76),RedSet_4(7),mass4set(:,9),  & 
G1H2(157),G1H2(158),G1H2(159),G1H2(160),G1H2(161),2)
  call HG1shiftOLR(G1H2(158),10,2)
  call Hotf_4pt_reduction(G2H2(80),RedSet_4(8),mass4set(:,11),  & 
G1H2(162),G1H2(163),G1H2(164),G1H2(165),G1H2(166),2)
  call HG1shiftOLR(G1H2(163),6,2)
  call Hotf_5pt_reduction(G2H2(81),RedSet_5(11),mass5set(:,10),  & 
G1H2(167),G1H2(168),G1H2(169),G1H2(170),G1H2(171),G1H2(172),2)
  call HG1shiftOLR(G1H2(168),4,2)
  call Hotf_4pt_reduction(G2H2(84),RedSet_4(8),mass4set(:,10),  & 
G1H2(173),G1H2(174),G1H2(175),G1H2(176),G1H2(177),2)
  call HG1shiftOLR(G1H2(174),6,2)
  call Hotf_5pt_reduction(G2H2(89),RedSet_5(11),mass5set(:,9),  & 
G1H2(178),G1H2(179),G1H2(180),G1H2(181),G1H2(182),G1H2(183),2)
  call HG1shiftOLR(G1H2(179),4,2)
  call Hotf_4pt_reduction(G2H2(92),RedSet_4(8),mass4set(:,9),  & 
G1H2(184),G1H2(185),G1H2(186),G1H2(187),G1H2(188),2)
  call HG1shiftOLR(G1H2(185),6,2)
  call Hotf_4pt_reduction(G2H2(96),RedSet_4(8),mass4set(:,9),  & 
G1H2(189),G1H2(190),G1H2(191),G1H2(192),G1H2(193),2)
  call HG1shiftOLR(G1H2(190),6,2)
  call Hotf_4pt_reduction(G2H2(100),RedSet_4(8),mass4set(:,9),  & 
G1H2(194),G1H2(195),G1H2(196),G1H2(197),G1H2(198),2)
  call HG1shiftOLR(G1H2(195),6,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(136),[G1H2(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(152),[G1H2(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(157),[G1H2(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(162),[G1H2(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(189),[G1H2(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(194),[G1H2(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(7),[G1H3(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(18),[G1H3(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(29),[G1H3(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(40),[G1H3(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(51),[G1H3(50)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(62),[G1H3(61)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(73),[G1H3(72)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(84),[G1H3(83)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(95),[G1H3(94)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(106),[G1H3(105)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(117),[G1H3(116)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(128),[G1H3(127)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(43),[G1H2(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(54),[G1H2(53)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(65),[G1H2(64)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(76),[G1H2(75)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(139),[G1H3(138)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(150),[G1H3(149)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(161),[G1H3(160)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(172),[G1H3(171)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(87),[G1H2(86)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(98),[G1H2(97)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(109),[G1H2(108)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(120),[G1H2(119)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(183),[G1H3(182)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(131),[G1H2(130)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(147),[G1H2(146)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(194),[G1H3(193)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(173),[G1H2(172)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(184),[G1H2(183)])
  call Hloop_QV_A(ntryL,G1H2(1),ex3(:),G1H1(1),m3h2x1(:,1),heltab2x2(:,:,1))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(1),n2h1(1))
  call Hloop_QV_A(ntryL,G1H2(2),ex3(:),G1H1(1),m3h2x1(:,2),heltab2x2(:,:,2))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(2),n2h1(2))
  call Hloop_QV_A(ntryL,G1H2(136),ex3(:),G1H1(1),m3h2x1(:,3),heltab2x2(:,:,3))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(3),n2h1(3))
  call Hloop_SA_Q(ntryL,G1H2(7),ex2(:),G1H1(1),ngPtb,m3h2x1(:,4),heltab2x2(:,:,4))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(4),n2h1(4))
  call Hloop_SA_Q(ntryL,G1H2(8),ex2(:),G1H1(1),ngPtb,m3h2x1(:,5),heltab2x2(:,:,5))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMB,G2tensor(5),n2h1(5))
  call Hloop_SA_Q(ntryL,G1H2(152),ex2(:),G1H1(1),ngPtb,m3h2x1(:,6),heltab2x2(:,:,6))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(6),n2h1(6))
  call Hloop_WA_Q(ntryL,G1H2(13),ex2(:),G1H1(1),m3h2x1(:,7),heltab2x2(:,:,7))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(7),n2h1(7))
  call Hloop_WA_Q(ntryL,G1H2(14),ex2(:),G1H1(1),m3h2x1(:,8),heltab2x2(:,:,8))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMB,G2tensor(8),n2h1(8))
  call Hloop_WA_Q(ntryL,G1H2(157),ex2(:),G1H1(1),m3h2x1(:,9),heltab2x2(:,:,9))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(9),n2h1(9))
  call Hloop_AV_Q(ntryL,G1H2(19),ex3(:),G1H1(1),m3h2x1(:,10),heltab2x2(:,:,10))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(10),n2h1(10))
  call Hloop_AV_Q(ntryL,G1H2(20),ex3(:),G1H1(1),m3h2x1(:,11),heltab2x2(:,:,11))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(11),n2h1(11))
  call Hloop_AV_Q(ntryL,G1H2(162),ex3(:),G1H1(1),m3h2x1(:,12),heltab2x2(:,:,12))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(12),n2h1(12))
  call Hloop_SA_Q(ntryL,G1H2(25),ex2(:),G1H1(1),ngPtb,m3h2x1(:,13),heltab2x2(:,:,13))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(13),n2h1(13))
  call Hloop_SA_Q(ntryL,G1H2(26),ex2(:),G1H1(1),ngPtb,m3h2x1(:,14),heltab2x2(:,:,14))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMB,G2tensor(14),n2h1(14))
  call Hloop_SA_Q(ntryL,G1H2(189),ex2(:),G1H1(1),ngPtb,m3h2x1(:,15),heltab2x2(:,:,15))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(15),n2h1(15))
  call Hloop_WA_Q(ntryL,G1H2(31),ex2(:),G1H1(1),m3h2x1(:,16),heltab2x2(:,:,16))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(16),n2h1(16))
  call Hloop_WA_Q(ntryL,G1H2(32),ex2(:),G1H1(1),m3h2x1(:,17),heltab2x2(:,:,17))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMB,G2tensor(17),n2h1(17))
  call Hloop_WA_Q(ntryL,G1H2(194),ex2(:),G1H1(1),m3h2x1(:,18),heltab2x2(:,:,18))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(18),n2h1(18))
  call Hloop_AZ_Q(ntryL,G1H3(1),ex4(:),G1H1(1),ngZu,m3h3x1(:,1),heltab2x3(:,:,1))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(19),n2h1(19))
  call Hloop_AZ_Q(ntryL,G1H3(2),ex4(:),G1H1(1),ngZu,m3h3x1(:,2),heltab2x3(:,:,2))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(20),n2h1(20))
  call Hloop_AZ_Q(ntryL,G1H3(7),ex4(:),G1H1(1),ngZu,m3h3x1(:,3),heltab2x3(:,:,3))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(21),n2h1(21))
  call Hloop_AZ_Q(ntryL,G1H3(8),ex4(:),G1H1(1),ngZu,m3h3x1(:,4),heltab2x3(:,:,4))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,nMT,G2tensor(22),n2h1(22))
  call Hloop_AZ_Q(ntryL,G1H3(12),ex4(:),G1H1(1),ngZu,m3h3x1(:,5),heltab2x3(:,:,5))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(23),n2h1(23))
  call Hloop_AZ_Q(ntryL,G1H3(13),ex4(:),G1H1(1),ngZu,m3h3x1(:,6),heltab2x3(:,:,6))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(24),n2h1(24))
  call Hloop_AZ_Q(ntryL,G1H3(18),ex4(:),G1H1(1),ngZu,m3h3x1(:,7),heltab2x3(:,:,7))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(25),n2h1(25))
  call Hloop_AZ_Q(ntryL,G1H3(19),ex4(:),G1H1(1),ngZu,m3h3x1(:,8),heltab2x3(:,:,8))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,nMT,G2tensor(26),n2h1(26))
  call Hloop_AZ_Q(ntryL,G1H3(23),ex4(:),G1H1(1),ngZd,m3h3x1(:,9),heltab2x3(:,:,9))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(27),n2h1(27))
  call Hloop_AZ_Q(ntryL,G1H3(24),ex4(:),G1H1(1),ngZd,m3h3x1(:,10),heltab2x3(:,:,10))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(28),n2h1(28))
  call Hloop_AZ_Q(ntryL,G1H3(29),ex4(:),G1H1(1),ngZd,m3h3x1(:,11),heltab2x3(:,:,11))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(29),n2h1(29))
  call Hloop_AZ_Q(ntryL,G1H3(30),ex4(:),G1H1(1),ngZd,m3h3x1(:,12),heltab2x3(:,:,12))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,nMB,G2tensor(30),n2h1(30))
  call Hloop_AZ_Q(ntryL,G1H3(34),ex4(:),G1H1(1),ngZu,m3h3x1(:,13),heltab2x3(:,:,13))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(31),n2h1(31))
  call Hloop_AZ_Q(ntryL,G1H3(35),ex4(:),G1H1(1),ngZu,m3h3x1(:,14),heltab2x3(:,:,14))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(32),n2h1(32))
  call Hloop_AZ_Q(ntryL,G1H3(40),ex4(:),G1H1(1),ngZu,m3h3x1(:,15),heltab2x3(:,:,15))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(33),n2h1(33))
  call Hloop_AZ_Q(ntryL,G1H3(41),ex4(:),G1H1(1),ngZu,m3h3x1(:,16),heltab2x3(:,:,16))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,nMT,G2tensor(34),n2h1(34))
  call Hloop_QZ_A(ntryL,G1H3(45),ex4(:),G1H1(1),ngZu,m3h3x1(:,17),heltab2x3(:,:,17))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(35),n2h1(35))
  call Hloop_QZ_A(ntryL,G1H3(46),ex4(:),G1H1(1),ngZu,m3h3x1(:,18),heltab2x3(:,:,18))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(36),n2h1(36))
  call Hloop_QZ_A(ntryL,G1H3(51),ex4(:),G1H1(1),ngZu,m3h3x1(:,19),heltab2x3(:,:,19))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(37),n2h1(37))
  call Hloop_QZ_A(ntryL,G1H3(52),ex4(:),G1H1(1),ngZu,m3h3x1(:,20),heltab2x3(:,:,20))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,nMT,G2tensor(38),n2h1(38))
  call Hloop_QZ_A(ntryL,G1H3(56),ex4(:),G1H1(1),ngZu,m3h3x1(:,21),heltab2x3(:,:,21))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(39),n2h1(39))
  call Hloop_QZ_A(ntryL,G1H3(57),ex4(:),G1H1(1),ngZu,m3h3x1(:,22),heltab2x3(:,:,22))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(40),n2h1(40))
  call Hloop_QZ_A(ntryL,G1H3(62),ex4(:),G1H1(1),ngZu,m3h3x1(:,23),heltab2x3(:,:,23))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(41),n2h1(41))
  call Hloop_QZ_A(ntryL,G1H3(63),ex4(:),G1H1(1),ngZu,m3h3x1(:,24),heltab2x3(:,:,24))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,nMT,G2tensor(42),n2h1(42))
  call Hloop_QZ_A(ntryL,G1H3(67),ex4(:),G1H1(1),ngZd,m3h3x1(:,25),heltab2x3(:,:,25))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(43),n2h1(43))
  call Hloop_QZ_A(ntryL,G1H3(68),ex4(:),G1H1(1),ngZd,m3h3x1(:,26),heltab2x3(:,:,26))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(44),n2h1(44))
  call Hloop_QZ_A(ntryL,G1H3(73),ex4(:),G1H1(1),ngZd,m3h3x1(:,27),heltab2x3(:,:,27))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(45),n2h1(45))
  call Hloop_QZ_A(ntryL,G1H3(74),ex4(:),G1H1(1),ngZd,m3h3x1(:,28),heltab2x3(:,:,28))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,nMB,G2tensor(46),n2h1(46))
  call Hloop_QZ_A(ntryL,G1H3(78),ex4(:),G1H1(1),ngZu,m3h3x1(:,29),heltab2x3(:,:,29))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(47),n2h1(47))
  call Hloop_QZ_A(ntryL,G1H3(79),ex4(:),G1H1(1),ngZu,m3h3x1(:,30),heltab2x3(:,:,30))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(48),n2h1(48))
  call Hloop_QZ_A(ntryL,G1H3(84),ex4(:),G1H1(1),ngZu,m3h3x1(:,31),heltab2x3(:,:,31))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(49),n2h1(49))
  call Hloop_QZ_A(ntryL,G1H3(85),ex4(:),G1H1(1),ngZu,m3h3x1(:,32),heltab2x3(:,:,32))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,nMT,G2tensor(50),n2h1(50))
  call Hloop_QZ_A(ntryL,G1H3(89),ex4(:),G1H1(1),ngZu,m3h3x1(:,33),heltab2x3(:,:,33))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(51),n2h1(51))
  call Hloop_QZ_A(ntryL,G1H3(90),ex4(:),G1H1(1),ngZu,m3h3x1(:,34),heltab2x3(:,:,34))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(52),n2h1(52))
  call Hloop_QZ_A(ntryL,G1H3(95),ex4(:),G1H1(1),ngZu,m3h3x1(:,35),heltab2x3(:,:,35))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(53),n2h1(53))
  call Hloop_QZ_A(ntryL,G1H3(96),ex4(:),G1H1(1),ngZu,m3h3x1(:,36),heltab2x3(:,:,36))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,nMT,G2tensor(54),n2h1(54))
  call Hloop_QZ_A(ntryL,G1H3(100),ex4(:),G1H1(1),ngZu,m3h3x1(:,37),heltab2x3(:,:,37))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(55),n2h1(55))
  call Hloop_QZ_A(ntryL,G1H3(101),ex4(:),G1H1(1),ngZu,m3h3x1(:,38),heltab2x3(:,:,38))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(56),n2h1(56))
  call Hloop_QZ_A(ntryL,G1H3(106),ex4(:),G1H1(1),ngZu,m3h3x1(:,39),heltab2x3(:,:,39))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(57),n2h1(57))
  call Hloop_QZ_A(ntryL,G1H3(107),ex4(:),G1H1(1),ngZu,m3h3x1(:,40),heltab2x3(:,:,40))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,nMT,G2tensor(58),n2h1(58))
  call Hloop_QZ_A(ntryL,G1H3(111),ex4(:),G1H1(1),ngZd,m3h3x1(:,41),heltab2x3(:,:,41))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(59),n2h1(59))
  call Hloop_QZ_A(ntryL,G1H3(112),ex4(:),G1H1(1),ngZd,m3h3x1(:,42),heltab2x3(:,:,42))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(60),n2h1(60))
  call Hloop_QZ_A(ntryL,G1H3(117),ex4(:),G1H1(1),ngZd,m3h3x1(:,43),heltab2x3(:,:,43))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(61),n2h1(61))
  call Hloop_QZ_A(ntryL,G1H3(118),ex4(:),G1H1(1),ngZd,m3h3x1(:,44),heltab2x3(:,:,44))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,nMB,G2tensor(62),n2h1(62))
  call Hloop_QZ_A(ntryL,G1H3(122),ex4(:),G1H1(1),ngZu,m3h3x1(:,45),heltab2x3(:,:,45))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(63),n2h1(63))
  call Hloop_QZ_A(ntryL,G1H3(123),ex4(:),G1H1(1),ngZu,m3h3x1(:,46),heltab2x3(:,:,46))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(64),n2h1(64))
  call Hloop_QZ_A(ntryL,G1H3(128),ex4(:),G1H1(1),ngZu,m3h3x1(:,47),heltab2x3(:,:,47))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(65),n2h1(65))
  call Hloop_QZ_A(ntryL,G1H3(129),ex4(:),G1H1(1),ngZu,m3h3x1(:,48),heltab2x3(:,:,48))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,nMT,G2tensor(66),n2h1(66))
  call Hloop_QV_A(ntryL,G1H2(37),ex3(:),G1H1(1),m3h2x1(:,19),heltab2x2(:,:,19))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(67),n2h1(67))
  call Hloop_QV_A(ntryL,G1H2(38),ex3(:),G1H1(1),m3h2x1(:,20),heltab2x2(:,:,20))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(68),n2h1(68))
  call Hloop_QV_A(ntryL,G1H2(43),ex3(:),G1H1(1),m3h2x1(:,21),heltab2x2(:,:,21))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(69),n2h1(69))
  call Hloop_QV_A(ntryL,G1H2(44),ex3(:),G1H1(1),m3h2x1(:,22),heltab2x2(:,:,22))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,nMT,G2tensor(70),n2h1(70))
  call Hloop_QV_A(ntryL,G1H2(48),ex3(:),G1H1(1),m3h2x1(:,23),heltab2x2(:,:,23))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(71),n2h1(71))
  call Hloop_QV_A(ntryL,G1H2(49),ex3(:),G1H1(1),m3h2x1(:,24),heltab2x2(:,:,24))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(72),n2h1(72))
  call Hloop_QV_A(ntryL,G1H2(54),ex3(:),G1H1(1),m3h2x1(:,25),heltab2x2(:,:,25))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(73),n2h1(73))
  call Hloop_QV_A(ntryL,G1H2(55),ex3(:),G1H1(1),m3h2x1(:,26),heltab2x2(:,:,26))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,nMT,G2tensor(74),n2h1(74))
  call Hloop_QV_A(ntryL,G1H2(59),ex3(:),G1H1(1),m3h2x1(:,27),heltab2x2(:,:,27))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(75),n2h1(75))
  call Hloop_QV_A(ntryL,G1H2(60),ex3(:),G1H1(1),m3h2x1(:,28),heltab2x2(:,:,28))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(76),n2h1(76))
  call Hloop_QV_A(ntryL,G1H2(65),ex3(:),G1H1(1),m3h2x1(:,29),heltab2x2(:,:,29))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(77),n2h1(77))
  call Hloop_QV_A(ntryL,G1H2(66),ex3(:),G1H1(1),m3h2x1(:,30),heltab2x2(:,:,30))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,nMB,G2tensor(78),n2h1(78))
  call Hloop_QV_A(ntryL,G1H2(70),ex3(:),G1H1(1),m3h2x1(:,31),heltab2x2(:,:,31))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(79),n2h1(79))
  call Hloop_QV_A(ntryL,G1H2(71),ex3(:),G1H1(1),m3h2x1(:,32),heltab2x2(:,:,32))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(80),n2h1(80))
  call Hloop_QV_A(ntryL,G1H2(76),ex3(:),G1H1(1),m3h2x1(:,33),heltab2x2(:,:,33))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(81),n2h1(81))
  call Hloop_QV_A(ntryL,G1H2(77),ex3(:),G1H1(1),m3h2x1(:,34),heltab2x2(:,:,34))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,nMT,G2tensor(82),n2h1(82))
  call Hloop_AZ_Q(ntryL,G1H3(133),ex4(:),G1H1(1),ngZu,m3h3x1(:,49),heltab2x3(:,:,49))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(83),n2h1(83))
  call Hloop_AZ_Q(ntryL,G1H3(134),ex4(:),G1H1(1),ngZu,m3h3x1(:,50),heltab2x3(:,:,50))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(84),n2h1(84))
  call Hloop_AZ_Q(ntryL,G1H3(139),ex4(:),G1H1(1),ngZu,m3h3x1(:,51),heltab2x3(:,:,51))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(85),n2h1(85))
  call Hloop_AZ_Q(ntryL,G1H3(140),ex4(:),G1H1(1),ngZu,m3h3x1(:,52),heltab2x3(:,:,52))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,nMT,G2tensor(86),n2h1(86))
  call Hloop_AZ_Q(ntryL,G1H3(144),ex4(:),G1H1(1),ngZu,m3h3x1(:,53),heltab2x3(:,:,53))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(87),n2h1(87))
  call Hloop_AZ_Q(ntryL,G1H3(145),ex4(:),G1H1(1),ngZu,m3h3x1(:,54),heltab2x3(:,:,54))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(88),n2h1(88))
  call Hloop_AZ_Q(ntryL,G1H3(150),ex4(:),G1H1(1),ngZu,m3h3x1(:,55),heltab2x3(:,:,55))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(89),n2h1(89))
  call Hloop_AZ_Q(ntryL,G1H3(151),ex4(:),G1H1(1),ngZu,m3h3x1(:,56),heltab2x3(:,:,56))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,nMT,G2tensor(90),n2h1(90))
  call Hloop_AZ_Q(ntryL,G1H3(155),ex4(:),G1H1(1),ngZd,m3h3x1(:,57),heltab2x3(:,:,57))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(91),n2h1(91))
  call Hloop_AZ_Q(ntryL,G1H3(156),ex4(:),G1H1(1),ngZd,m3h3x1(:,58),heltab2x3(:,:,58))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(92),n2h1(92))
  call Hloop_AZ_Q(ntryL,G1H3(161),ex4(:),G1H1(1),ngZd,m3h3x1(:,59),heltab2x3(:,:,59))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(93),n2h1(93))
  call Hloop_AZ_Q(ntryL,G1H3(162),ex4(:),G1H1(1),ngZd,m3h3x1(:,60),heltab2x3(:,:,60))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,nMB,G2tensor(94),n2h1(94))
  call Hloop_AZ_Q(ntryL,G1H3(166),ex4(:),G1H1(1),ngZu,m3h3x1(:,61),heltab2x3(:,:,61))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(95),n2h1(95))
  call Hloop_AZ_Q(ntryL,G1H3(167),ex4(:),G1H1(1),ngZu,m3h3x1(:,62),heltab2x3(:,:,62))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(96),n2h1(96))
  call Hloop_AZ_Q(ntryL,G1H3(172),ex4(:),G1H1(1),ngZu,m3h3x1(:,63),heltab2x3(:,:,63))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(97),n2h1(97))
  call Hloop_AZ_Q(ntryL,G1H3(173),ex4(:),G1H1(1),ngZu,m3h3x1(:,64),heltab2x3(:,:,64))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,nMT,G2tensor(98),n2h1(98))
  call Hloop_AV_Q(ntryL,G1H2(81),ex3(:),G1H1(1),m3h2x1(:,35),heltab2x2(:,:,35))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(99),n2h1(99))
  call Hloop_AV_Q(ntryL,G1H2(82),ex3(:),G1H1(1),m3h2x1(:,36),heltab2x2(:,:,36))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(100),n2h1(100))
  call Hloop_AV_Q(ntryL,G1H2(87),ex3(:),G1H1(1),m3h2x1(:,37),heltab2x2(:,:,37))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(101),n2h1(101))
  call Hloop_AV_Q(ntryL,G1H2(88),ex3(:),G1H1(1),m3h2x1(:,38),heltab2x2(:,:,38))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,nMT,G2tensor(102),n2h1(102))
  call Hloop_AV_Q(ntryL,G1H2(92),ex3(:),G1H1(1),m3h2x1(:,39),heltab2x2(:,:,39))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(103),n2h1(103))
  call Hloop_AV_Q(ntryL,G1H2(93),ex3(:),G1H1(1),m3h2x1(:,40),heltab2x2(:,:,40))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(104),n2h1(104))
  call Hloop_AV_Q(ntryL,G1H2(98),ex3(:),G1H1(1),m3h2x1(:,41),heltab2x2(:,:,41))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(105),n2h1(105))
  call Hloop_AV_Q(ntryL,G1H2(99),ex3(:),G1H1(1),m3h2x1(:,42),heltab2x2(:,:,42))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,nMT,G2tensor(106),n2h1(106))
  call Hloop_AV_Q(ntryL,G1H2(103),ex3(:),G1H1(1),m3h2x1(:,43),heltab2x2(:,:,43))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(107),n2h1(107))
  call Hloop_AV_Q(ntryL,G1H2(104),ex3(:),G1H1(1),m3h2x1(:,44),heltab2x2(:,:,44))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(108),n2h1(108))
  call Hloop_AV_Q(ntryL,G1H2(109),ex3(:),G1H1(1),m3h2x1(:,45),heltab2x2(:,:,45))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(109),n2h1(109))
  call Hloop_AV_Q(ntryL,G1H2(110),ex3(:),G1H1(1),m3h2x1(:,46),heltab2x2(:,:,46))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,nMB,G2tensor(110),n2h1(110))
  call Hloop_AV_Q(ntryL,G1H2(114),ex3(:),G1H1(1),m3h2x1(:,47),heltab2x2(:,:,47))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(111),n2h1(111))
  call Hloop_AV_Q(ntryL,G1H2(115),ex3(:),G1H1(1),m3h2x1(:,48),heltab2x2(:,:,48))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(112),n2h1(112))
  call Hloop_AV_Q(ntryL,G1H2(120),ex3(:),G1H1(1),m3h2x1(:,49),heltab2x2(:,:,49))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(113),n2h1(113))
  call Hloop_AV_Q(ntryL,G1H2(121),ex3(:),G1H1(1),m3h2x1(:,50),heltab2x2(:,:,50))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,nMT,G2tensor(114),n2h1(114))
  call Hloop_QZ_A(ntryL,G1H3(177),ex4(:),G1H1(1),ngZd,m3h3x1(:,65),heltab2x3(:,:,65))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(115),n2h1(115))
  call Hloop_QZ_A(ntryL,G1H3(178),ex4(:),G1H1(1),ngZd,m3h3x1(:,66),heltab2x3(:,:,66))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(116),n2h1(116))
  call Hloop_QZ_A(ntryL,G1H3(183),ex4(:),G1H1(1),ngZd,m3h3x1(:,67),heltab2x3(:,:,67))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(117),n2h1(117))
  call Hloop_QZ_A(ntryL,G1H3(184),ex4(:),G1H1(1),ngZd,m3h3x1(:,68),heltab2x3(:,:,68))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,nMB,G2tensor(118),n2h1(118))
  call Hloop_QV_A(ntryL,G1H2(125),ex3(:),G1H1(1),m3h2x1(:,51),heltab2x2(:,:,51))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(119),n2h1(119))
  call Hloop_QV_A(ntryL,G1H2(126),ex3(:),G1H1(1),m3h2x1(:,52),heltab2x2(:,:,52))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(120),n2h1(120))
  call Hloop_QV_A(ntryL,G1H2(131),ex3(:),G1H1(1),m3h2x1(:,53),heltab2x2(:,:,53))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(121),n2h1(121))
  call Hloop_QV_A(ntryL,G1H2(132),ex3(:),G1H1(1),m3h2x1(:,54),heltab2x2(:,:,54))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),5,nMT,G2tensor(122),n2h1(122))
  call Hloop_QV_A(ntryL,G1H2(137),ex3(:),G1H1(1),m3h2x1(:,55),heltab2x2(:,:,55))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),5,nMT,G2tensor(123),n2h1(123))
  call Hloop_QV_A(ntryL,G1H2(141),ex3(:),G1H1(1),m3h2x1(:,56),heltab2x2(:,:,56))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(124),n2h1(124))
  call Hloop_QV_A(ntryL,G1H2(142),ex3(:),G1H1(1),m3h2x1(:,57),heltab2x2(:,:,57))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(125),n2h1(125))
  call Hloop_QV_A(ntryL,G1H2(147),ex3(:),G1H1(1),m3h2x1(:,58),heltab2x2(:,:,58))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(126),n2h1(126))
  call Hloop_QV_A(ntryL,G1H2(148),ex3(:),G1H1(1),m3h2x1(:,59),heltab2x2(:,:,59))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),5,nMB,G2tensor(127),n2h1(127))
  call Hloop_AZ_Q(ntryL,G1H3(188),ex4(:),G1H1(1),ngZd,m3h3x1(:,69),heltab2x3(:,:,69))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(128),n2h1(128))
  call Hloop_AZ_Q(ntryL,G1H3(189),ex4(:),G1H1(1),ngZd,m3h3x1(:,70),heltab2x3(:,:,70))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(129),n2h1(129))
  call Hloop_AZ_Q(ntryL,G1H3(194),ex4(:),G1H1(1),ngZd,m3h3x1(:,71),heltab2x3(:,:,71))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(130),n2h1(130))
  call Hloop_AZ_Q(ntryL,G1H3(195),ex4(:),G1H1(1),ngZd,m3h3x1(:,72),heltab2x3(:,:,72))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,nMB,G2tensor(131),n2h1(131))
  call Hloop_SA_Q(ntryL,G1H2(153),ex2(:),G1H1(1),ngPtb,m3h2x1(:,60),heltab2x2(:,:,60))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,nMB,G2tensor(132),n2h1(132))
  call Hloop_WA_Q(ntryL,G1H2(158),ex2(:),G1H1(1),m3h2x1(:,61),heltab2x2(:,:,61))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,nMB,G2tensor(133),n2h1(133))
  call Hloop_AV_Q(ntryL,G1H2(163),ex3(:),G1H1(1),m3h2x1(:,62),heltab2x2(:,:,62))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),6,nMT,G2tensor(134),n2h1(134))
  call Hloop_AV_Q(ntryL,G1H2(167),ex3(:),G1H1(1),m3h2x1(:,63),heltab2x2(:,:,63))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(135),n2h1(135))
  call Hloop_AV_Q(ntryL,G1H2(168),ex3(:),G1H1(1),m3h2x1(:,64),heltab2x2(:,:,64))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(136),n2h1(136))
  call Hloop_AV_Q(ntryL,G1H2(173),ex3(:),G1H1(1),m3h2x1(:,65),heltab2x2(:,:,65))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(137),n2h1(137))
  call Hloop_AV_Q(ntryL,G1H2(174),ex3(:),G1H1(1),m3h2x1(:,66),heltab2x2(:,:,66))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),6,nMT,G2tensor(138),n2h1(138))
  call Hloop_AV_Q(ntryL,G1H2(178),ex3(:),G1H1(1),m3h2x1(:,67),heltab2x2(:,:,67))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(139),n2h1(139))
  call Hloop_AV_Q(ntryL,G1H2(179),ex3(:),G1H1(1),m3h2x1(:,68),heltab2x2(:,:,68))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(140),n2h1(140))
  call Hloop_AV_Q(ntryL,G1H2(184),ex3(:),G1H1(1),m3h2x1(:,69),heltab2x2(:,:,69))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(141),n2h1(141))
  call Hloop_AV_Q(ntryL,G1H2(185),ex3(:),G1H1(1),m3h2x1(:,70),heltab2x2(:,:,70))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),6,nMB,G2tensor(142),n2h1(142))
  call Hloop_SA_Q(ntryL,G1H2(190),ex2(:),G1H1(1),ngPtb,m3h2x1(:,71),heltab2x2(:,:,71))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),6,nMB,G2tensor(143),n2h1(143))
  call Hloop_WA_Q(ntryL,G1H2(195),ex2(:),G1H1(1),m3h2x1(:,72),heltab2x2(:,:,72))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),6,nMB,G2tensor(144),n2h1(144))
  call ol_merge_tensors(G2tensor(7),[G2tensor(4)])
  call ol_merge_tensors(G2tensor(16),[G2tensor(13)])
  call Hotf_5pt_reduction_last(G2tensor(1),RedSet_5(8),mass5set(:,11),  & 
G1tensor(1),G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(5),G1tensor(6))
  call G_TensorShift(G1tensor(2),4)
  call Hotf_5pt_reduction_last(G2tensor(7),RedSet_5(10),mass5set(:,12),  & 
G1tensor(7),G1tensor(8),G1tensor(9),G1tensor(10),G1tensor(11),G1tensor(12))
  call G_TensorShift(G1tensor(8),2)
  call Hotf_5pt_reduction_last(G2tensor(10),RedSet_5(11),mass5set(:,11),  & 
G1tensor(13),G1tensor(14),G1tensor(15),G1tensor(16),G1tensor(17),G1tensor(18))
  call G_TensorShift(G1tensor(14),4)
  call Hotf_5pt_reduction_last(G2tensor(16),RedSet_5(12),mass5set(:,12),  & 
G1tensor(19),G1tensor(20),G1tensor(21),G1tensor(22),G1tensor(23),G1tensor(24))
  call G_TensorShift(G1tensor(20),2)
  call Hotf_5pt_reduction_last(G2tensor(19),RedSet_5(1),mass5set(:,1),  & 
G1tensor(25),G1tensor(26),G1tensor(27),G1tensor(28),G1tensor(29),G1tensor(30))
  call G_TensorShift(G1tensor(26),8)
  call Hotf_5pt_reduction_last(G2tensor(23),RedSet_5(1),mass5set(:,2),  & 
G1tensor(31),G1tensor(32),G1tensor(33),G1tensor(34),G1tensor(35),G1tensor(36))
  call G_TensorShift(G1tensor(32),8)
  call Hotf_5pt_reduction_last(G2tensor(27),RedSet_5(1),mass5set(:,3),  & 
G1tensor(37),G1tensor(38),G1tensor(39),G1tensor(40),G1tensor(41),G1tensor(42))
  call G_TensorShift(G1tensor(38),8)
  call Hotf_5pt_reduction_last(G2tensor(31),RedSet_5(1),mass5set(:,4),  & 
G1tensor(43),G1tensor(44),G1tensor(45),G1tensor(46),G1tensor(47),G1tensor(48))
  call G_TensorShift(G1tensor(44),8)
  call Hotf_5pt_reduction_last(G2tensor(35),RedSet_5(2),mass5set(:,5),  & 
G1tensor(49),G1tensor(50),G1tensor(51),G1tensor(52),G1tensor(53),G1tensor(54))
  call G_TensorShift(G1tensor(50),8)
  call Hotf_5pt_reduction_last(G2tensor(39),RedSet_5(2),mass5set(:,6),  & 
G1tensor(55),G1tensor(56),G1tensor(57),G1tensor(58),G1tensor(59),G1tensor(60))
  call G_TensorShift(G1tensor(56),8)
  call Hotf_5pt_reduction_last(G2tensor(43),RedSet_5(2),mass5set(:,7),  & 
G1tensor(61),G1tensor(62),G1tensor(63),G1tensor(64),G1tensor(65),G1tensor(66))
  call G_TensorShift(G1tensor(62),8)
  call Hotf_5pt_reduction_last(G2tensor(47),RedSet_5(2),mass5set(:,8),  & 
G1tensor(67),G1tensor(68),G1tensor(69),G1tensor(70),G1tensor(71),G1tensor(72))
  call G_TensorShift(G1tensor(68),8)
  call Hotf_5pt_reduction_last(G2tensor(51),RedSet_5(3),mass5set(:,1),  & 
G1tensor(73),G1tensor(74),G1tensor(75),G1tensor(76),G1tensor(77),G1tensor(78))
  call G_TensorShift(G1tensor(74),8)
  call Hotf_5pt_reduction_last(G2tensor(55),RedSet_5(3),mass5set(:,2),  & 
G1tensor(79),G1tensor(80),G1tensor(81),G1tensor(82),G1tensor(83),G1tensor(84))
  call G_TensorShift(G1tensor(80),8)
  call Hotf_5pt_reduction_last(G2tensor(59),RedSet_5(3),mass5set(:,3),  & 
G1tensor(85),G1tensor(86),G1tensor(87),G1tensor(88),G1tensor(89),G1tensor(90))
  call G_TensorShift(G1tensor(86),8)
  call Hotf_5pt_reduction_last(G2tensor(63),RedSet_5(3),mass5set(:,4),  & 
G1tensor(91),G1tensor(92),G1tensor(93),G1tensor(94),G1tensor(95),G1tensor(96))
  call G_TensorShift(G1tensor(92),8)
  call Hotf_5pt_reduction_last(G2tensor(67),RedSet_5(4),mass5set(:,5),  & 
G1tensor(97),G1tensor(98),G1tensor(99),G1tensor(100),G1tensor(101),G1tensor(102))
  call G_TensorShift(G1tensor(98),4)
  call Hotf_5pt_reduction_last(G2tensor(71),RedSet_5(4),mass5set(:,6),  & 
G1tensor(103),G1tensor(104),G1tensor(105),G1tensor(106),G1tensor(107),G1tensor(108))
  call G_TensorShift(G1tensor(104),4)
  call Hotf_5pt_reduction_last(G2tensor(75),RedSet_5(4),mass5set(:,7),  & 
G1tensor(109),G1tensor(110),G1tensor(111),G1tensor(112),G1tensor(113),G1tensor(114))
  call G_TensorShift(G1tensor(110),4)
  call Hotf_5pt_reduction_last(G2tensor(79),RedSet_5(4),mass5set(:,8),  & 
G1tensor(115),G1tensor(116),G1tensor(117),G1tensor(118),G1tensor(119),G1tensor(120))
  call G_TensorShift(G1tensor(116),4)
  call Hotf_5pt_reduction_last(G2tensor(83),RedSet_5(5),mass5set(:,5),  & 
G1tensor(121),G1tensor(122),G1tensor(123),G1tensor(124),G1tensor(125),G1tensor(126))
  call G_TensorShift(G1tensor(122),8)
  call Hotf_5pt_reduction_last(G2tensor(87),RedSet_5(5),mass5set(:,6),  & 
G1tensor(127),G1tensor(128),G1tensor(129),G1tensor(130),G1tensor(131),G1tensor(132))
  call G_TensorShift(G1tensor(128),8)
  call Hotf_5pt_reduction_last(G2tensor(91),RedSet_5(5),mass5set(:,7),  & 
G1tensor(133),G1tensor(134),G1tensor(135),G1tensor(136),G1tensor(137),G1tensor(138))
  call G_TensorShift(G1tensor(134),8)
  call Hotf_5pt_reduction_last(G2tensor(95),RedSet_5(5),mass5set(:,8),  & 
G1tensor(139),G1tensor(140),G1tensor(141),G1tensor(142),G1tensor(143),G1tensor(144))
  call G_TensorShift(G1tensor(140),8)
  call Hotf_5pt_reduction_last(G2tensor(99),RedSet_5(6),mass5set(:,5),  & 
G1tensor(145),G1tensor(146),G1tensor(147),G1tensor(148),G1tensor(149),G1tensor(150))
  call G_TensorShift(G1tensor(146),4)
  call Hotf_5pt_reduction_last(G2tensor(103),RedSet_5(6),mass5set(:,6),  & 
G1tensor(151),G1tensor(152),G1tensor(153),G1tensor(154),G1tensor(155),G1tensor(156))
  call G_TensorShift(G1tensor(152),4)
  call Hotf_5pt_reduction_last(G2tensor(107),RedSet_5(6),mass5set(:,7),  & 
G1tensor(157),G1tensor(158),G1tensor(159),G1tensor(160),G1tensor(161),G1tensor(162))
  call G_TensorShift(G1tensor(158),4)
  call Hotf_5pt_reduction_last(G2tensor(111),RedSet_5(6),mass5set(:,8),  & 
G1tensor(163),G1tensor(164),G1tensor(165),G1tensor(166),G1tensor(167),G1tensor(168))
  call G_TensorShift(G1tensor(164),4)
  call Hotf_5pt_reduction_last(G2tensor(115),RedSet_5(7),mass5set(:,9),  & 
G1tensor(169),G1tensor(170),G1tensor(171),G1tensor(172),G1tensor(173),G1tensor(174))
  call G_TensorShift(G1tensor(170),8)
  call Hotf_5pt_reduction_last(G2tensor(119),RedSet_5(8),mass5set(:,10),  & 
G1tensor(175),G1tensor(176),G1tensor(177),G1tensor(178),G1tensor(179),G1tensor(180))
  call G_TensorShift(G1tensor(176),4)
  call Hotf_5pt_reduction_last(G2tensor(124),RedSet_5(8),mass5set(:,9),  & 
G1tensor(181),G1tensor(182),G1tensor(183),G1tensor(184),G1tensor(185),G1tensor(186))
  call G_TensorShift(G1tensor(182),4)
  call Hotf_5pt_reduction_last(G2tensor(128),RedSet_5(9),mass5set(:,9),  & 
G1tensor(187),G1tensor(188),G1tensor(189),G1tensor(190),G1tensor(191),G1tensor(192))
  call G_TensorShift(G1tensor(188),8)
  call Hotf_5pt_reduction_last(G2tensor(135),RedSet_5(11),mass5set(:,10),  & 
G1tensor(193),G1tensor(194),G1tensor(195),G1tensor(196),G1tensor(197),G1tensor(198))
  call G_TensorShift(G1tensor(194),4)
  call Hotf_5pt_reduction_last(G2tensor(139),RedSet_5(11),mass5set(:,9),  & 
G1tensor(199),G1tensor(200),G1tensor(201),G1tensor(202),G1tensor(203),G1tensor(204))
  call G_TensorShift(G1tensor(200),4)
  call ol_merge_tensors(T1sum(1),[G1tensor(1)])
  call ol_merge_tensors(T1sum(2),[G1tensor(7)])
  call ol_merge_tensors(T1sum(3),[G1tensor(13)])
  call ol_merge_tensors(T1sum(4),[G1tensor(19)])
  call ol_merge_tensors(T1sum(5),[G1tensor(25)])
  call ol_merge_tensors(T1sum(6),[G1tensor(31)])
  call ol_merge_tensors(T1sum(7),[G1tensor(37)])
  call ol_merge_tensors(T1sum(8),[G1tensor(43)])
  call ol_merge_tensors(T1sum(9),[G1tensor(49)])
  call ol_merge_tensors(T1sum(10),[G1tensor(55)])
  call ol_merge_tensors(T1sum(11),[G1tensor(61)])
  call ol_merge_tensors(T1sum(12),[G1tensor(67)])
  call ol_merge_tensors(T1sum(13),[G1tensor(73)])
  call ol_merge_tensors(T1sum(14),[G1tensor(79)])
  call ol_merge_tensors(T1sum(15),[G1tensor(85)])
  call ol_merge_tensors(T1sum(16),[G1tensor(91)])
  call ol_merge_tensors(T1sum(17),[G1tensor(97)])
  call ol_merge_tensors(T1sum(18),[G1tensor(103)])
  call ol_merge_tensors(T1sum(19),[G1tensor(109)])
  call ol_merge_tensors(T1sum(20),[G1tensor(115)])
  call ol_merge_tensors(T1sum(21),[G1tensor(121)])
  call ol_merge_tensors(T1sum(22),[G1tensor(127)])
  call ol_merge_tensors(T1sum(23),[G1tensor(133)])
  call ol_merge_tensors(T1sum(24),[G1tensor(139)])
  call ol_merge_tensors(T1sum(25),[G1tensor(145)])
  call ol_merge_tensors(T1sum(26),[G1tensor(151)])
  call ol_merge_tensors(T1sum(27),[G1tensor(157)])
  call ol_merge_tensors(T1sum(28),[G1tensor(163)])
  call ol_merge_tensors(T1sum(29),[G1tensor(169)])
  call ol_merge_tensors(T1sum(30),[G1tensor(175)])
  call ol_merge_tensors(T1sum(31),[G1tensor(181)])
  call ol_merge_tensors(T1sum(32),[G1tensor(187)])
  call ol_merge_tensors(T1sum(33),[G1tensor(193)])
  call ol_merge_tensors(T1sum(34),[G1tensor(199)])
  Gcoeff(:)%j = (-(c(35)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(77),h0tab(:,77),[16,1,12,2],[nMB,nMW,nMW,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,77),heltab2x48(:,:,77))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMB,G1H24(1),n2h24(77))
  Gcoeff(:)%j = (c(6)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(78),h0tab(:,78),[16,1,12,2],[nMB,nMW,nMW,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,78),heltab2x48(:,:,78))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMB,G1H24(2),n2h24(78))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(79),h0tab(:,79),[16,2,8,5],[nMT,nMH,nMZ,nMT],4,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,79),heltab2x48(:,:,79))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMT,G1H24(3),n2h24(79))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(80),h0tab(:,80),[16,2,8,5],[nMT,nMZ,nMH,nMT],4,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,80),heltab2x48(:,:,80))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMT,G1H24(4),n2h24(80))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(81),h0tab(:,81),[16,2,8,5],[nMB,nMW,nMW,nMB],4,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,81),heltab2x48(:,:,81))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMB,G1H24(5),n2h24(81))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(82),h0tab(:,82),[16,2,8,5],[nMT,nMH,nMZ,nMT],4,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,82),heltab2x48(:,:,82))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMT,G1H24(6),n2h24(82))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(83),h0tab(:,83),[16,2,8,5],[nMB,nMW,nMW,nMB],4,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,83),heltab2x48(:,:,83))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMB,G1H24(7),n2h24(83))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(84),h0tab(:,84),[16,2,8,5],[nMT,nMZ,nMH,nMT],4,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,84),heltab2x48(:,:,84))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMT,G1H24(8),n2h24(84))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(85),h0tab(:,85),[16,2,8,5],[nMB,nMW,nMW,nMB],4,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,85),heltab2x48(:,:,85))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMB,G1H24(9),n2h24(85))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(86),h0tab(:,86),[16,2,8,5],[nMB,nMW,nMW,nMB],4,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,86),heltab2x48(:,:,86))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMB,G1H24(10),n2h24(86))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(87),h0tab(:,87),[16,5,2,8],[nMT,nMH,nMT,nMT],4,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,87),heltab2x48(:,:,87))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMT,G1H24(11),n2h24(87))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(88),h0tab(:,88),[16,5,2,8],[nMT,nMZ,nMT,nMT],4,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,88),heltab2x48(:,:,88))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMT,G1H24(12),n2h24(88))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(89),h0tab(:,89),[16,5,2,8],[nMB,nMW,nMB,nMB],4,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,89),heltab2x48(:,:,89))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMB,G1H24(13),n2h24(89))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(90),h0tab(:,90),[16,5,2,8],[nMT,0,nMT,nMT],4,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,90),heltab2x48(:,:,90))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMT,G1H24(14),n2h24(90))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(91),h0tab(:,91),[16,5,2,8],[nMT,nMZ,nMT,nMT],4,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,91),heltab2x48(:,:,91))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMT,G1H24(15),n2h24(91))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(92),h0tab(:,92),[16,5,2,8],[nMB,nMW,nMB,nMB],4,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,92),heltab2x48(:,:,92))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMB,G1H24(16),n2h24(92))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(93),h0tab(:,93),[16,2,5,8],[nMT,nMH,nMT,nMT],4,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,93),heltab2x48(:,:,93))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMT,G1H24(17),n2h24(93))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(94),h0tab(:,94),[16,2,5,8],[nMT,nMZ,nMT,nMT],4,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,94),heltab2x48(:,:,94))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMT,G1H24(18),n2h24(94))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(95),h0tab(:,95),[16,2,5,8],[nMB,nMW,nMB,nMB],4,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,95),heltab2x48(:,:,95))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMB,G1H24(19),n2h24(95))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(96),h0tab(:,96),[16,2,5,8],[nMT,0,nMT,nMT],4,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,96),heltab2x48(:,:,96))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMT,G1H24(20),n2h24(96))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(97),h0tab(:,97),[16,2,5,8],[nMT,nMZ,nMT,nMT],4,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,97),heltab2x48(:,:,97))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMT,G1H24(21),n2h24(97))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(98),h0tab(:,98),[16,2,5,8],[nMB,nMW,nMB,nMB],4,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,98),heltab2x48(:,:,98))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMB,G1H24(22),n2h24(98))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(99),h0tab(:,99),[16,1,8,6],[nMT,nMH,nMZ,nMT],4,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,99),heltab2x48(:,:,99))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMT,G1H24(23),n2h24(99))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(100),h0tab(:,100),[16,1,8,6],[nMT,nMZ,nMH,nMT],4,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,100),heltab2x48(:,:,100))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMT,G1H24(24),n2h24(100))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(101),h0tab(:,101),[16,1,8,6],[nMB,nMW,nMW,nMB],4,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,101),heltab2x48(:,:,101))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMB,G1H24(25),n2h24(101))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(102),h0tab(:,102),[16,1,8,6],[nMT,nMH,nMZ,nMT],4,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,102),heltab2x48(:,:,102))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMT,G1H24(26),n2h24(102))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(103),h0tab(:,103),[16,1,8,6],[nMB,nMW,nMW,nMB],4,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,103),heltab2x48(:,:,103))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMB,G1H24(27),n2h24(103))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(104),h0tab(:,104),[16,1,8,6],[nMT,nMZ,nMH,nMT],4,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,104),heltab2x48(:,:,104))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMT,G1H24(28),n2h24(104))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(105),h0tab(:,105),[16,1,8,6],[nMB,nMW,nMW,nMB],4,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,105),heltab2x48(:,:,105))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMB,G1H24(29),n2h24(105))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(106),h0tab(:,106),[16,1,8,6],[nMB,nMW,nMW,nMB],4,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,106),heltab2x48(:,:,106))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMB,G1H24(30),n2h24(106))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(107),h0tab(:,107),[16,6,1,8],[nMT,nMH,nMT,nMT],4,1,wf4(:,6))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,107),heltab2x48(:,:,107))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMT,G1H24(31),n2h24(107))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(108),h0tab(:,108),[16,6,1,8],[nMT,nMZ,nMT,nMT],4,1,wf4(:,6))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,108),heltab2x48(:,:,108))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMT,G1H24(32),n2h24(108))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(109),h0tab(:,109),[16,6,1,8],[nMB,nMW,nMB,nMB],4,1,wf4(:,6))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,109),heltab2x48(:,:,109))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMB,G1H24(33),n2h24(109))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(110),h0tab(:,110),[16,6,1,8],[nMT,0,nMT,nMT],4,1,wf4(:,6))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,110),heltab2x48(:,:,110))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMT,G1H24(34),n2h24(110))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(111),h0tab(:,111),[16,6,1,8],[nMT,nMZ,nMT,nMT],4,1,wf4(:,6))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,111),heltab2x48(:,:,111))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMT,G1H24(35),n2h24(111))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(112),h0tab(:,112),[16,6,1,8],[nMB,nMW,nMB,nMB],4,1,wf4(:,6))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,112),heltab2x48(:,:,112))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMB,G1H24(36),n2h24(112))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(113),h0tab(:,113),[16,1,6,8],[nMT,nMH,nMT,nMT],4,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,113),heltab2x48(:,:,113))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMT,G1H24(37),n2h24(113))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(114),h0tab(:,114),[16,1,6,8],[nMT,nMZ,nMT,nMT],4,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,114),heltab2x48(:,:,114))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMT,G1H24(38),n2h24(114))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(115),h0tab(:,115),[16,1,6,8],[nMB,nMW,nMB,nMB],4,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,115),heltab2x48(:,:,115))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMB,G1H24(39),n2h24(115))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(116),h0tab(:,116),[16,1,6,8],[nMT,0,nMT,nMT],4,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,116),heltab2x48(:,:,116))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMT,G1H24(40),n2h24(116))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(117),h0tab(:,117),[16,1,6,8],[nMT,nMZ,nMT,nMT],4,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,117),heltab2x48(:,:,117))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMT,G1H24(41),n2h24(117))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(118),h0tab(:,118),[16,1,6,8],[nMB,nMW,nMB,nMB],4,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,118),heltab2x48(:,:,118))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMB,G1H24(42),n2h24(118))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(119),h0tab(:,119),[16,2,4,9],[nMB,nMW,nMW,nMB],4,1,wf6(:,4))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,119),heltab2x48(:,:,119))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMB,G1H24(43),n2h24(119))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(120),h0tab(:,120),[16,2,4,9],[nMB,nMW,nMW,nMB],4,1,wf6(:,4))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,120),heltab2x48(:,:,120))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMB,G1H24(44),n2h24(120))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(121),h0tab(:,121),[16,2,4,9],[nMB,nMW,nMW,nMB],4,1,wf6(:,4))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,121),heltab2x48(:,:,121))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMB,G1H24(45),n2h24(121))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(122),h0tab(:,122),[16,2,4,9],[nMB,nMW,nMW,nMB],4,1,wf6(:,4))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,122),heltab2x48(:,:,122))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMB,G1H24(46),n2h24(122))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(123),h0tab(:,123),[16,4,2,9],[nMT,nMT,nMH,nMT],4,1,wf6(:,4))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,123),heltab2x48(:,:,123))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMT,G1H24(47),n2h24(123))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(124),h0tab(:,124),[16,4,2,9],[nMT,nMT,nMZ,nMT],4,1,wf6(:,4))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,124),heltab2x48(:,:,124))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMT,G1H24(48),n2h24(124))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(125),h0tab(:,125),[16,4,2,9],[nMB,nMB,nMW,nMB],4,1,wf6(:,4))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,125),heltab2x48(:,:,125))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMB,G1H24(49),n2h24(125))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(126),h0tab(:,126),[16,4,2,9],[nMT,nMT,0,nMT],4,1,wf6(:,4))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,126),heltab2x48(:,:,126))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMT,G1H24(50),n2h24(126))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(127),h0tab(:,127),[16,4,2,9],[nMT,nMT,nMZ,nMT],4,1,wf6(:,4))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,127),heltab2x48(:,:,127))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMT,G1H24(51),n2h24(127))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(128),h0tab(:,128),[16,4,2,9],[nMB,nMB,nMW,nMB],4,1,wf6(:,4))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,128),heltab2x48(:,:,128))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMB,G1H24(52),n2h24(128))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(129),h0tab(:,129),[16,2,9,4],[nMT,nMH,nMT,nMT],4,1,wf6(:,4))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,129),heltab2x48(:,:,129))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMT,G1H24(53),n2h24(129))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(130),h0tab(:,130),[16,2,9,4],[nMT,nMZ,nMT,nMT],4,1,wf6(:,4))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,130),heltab2x48(:,:,130))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMT,G1H24(54),n2h24(130))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(131),h0tab(:,131),[16,2,9,4],[nMB,nMW,nMB,nMB],4,1,wf6(:,4))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,131),heltab2x48(:,:,131))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMB,G1H24(55),n2h24(131))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(132),h0tab(:,132),[16,2,9,4],[nMT,0,nMT,nMT],4,1,wf6(:,4))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,132),heltab2x48(:,:,132))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMT,G1H24(56),n2h24(132))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(133),h0tab(:,133),[16,2,9,4],[nMT,nMZ,nMT,nMT],4,1,wf6(:,4))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,133),heltab2x48(:,:,133))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMT,G1H24(57),n2h24(133))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(134),h0tab(:,134),[16,2,9,4],[nMB,nMW,nMB,nMB],4,1,wf6(:,4))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,134),heltab2x48(:,:,134))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMB,G1H24(58),n2h24(134))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(135),h0tab(:,135),[16,1,4,10],[nMB,nMW,nMW,nMB],4,1,wf6(:,2))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,135),heltab2x48(:,:,135))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMB,G1H24(59),n2h24(135))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(136),h0tab(:,136),[16,1,4,10],[nMB,nMW,nMW,nMB],4,1,wf6(:,2))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,136),heltab2x48(:,:,136))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMB,G1H24(60),n2h24(136))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(137),h0tab(:,137),[16,1,4,10],[nMB,nMW,nMW,nMB],4,1,wf6(:,2))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,137),heltab2x48(:,:,137))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMB,G1H24(61),n2h24(137))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(138),h0tab(:,138),[16,1,4,10],[nMB,nMW,nMW,nMB],4,1,wf6(:,2))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,138),heltab2x48(:,:,138))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMB,G1H24(62),n2h24(138))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(139),h0tab(:,139),[16,4,1,10],[nMT,nMT,nMH,nMT],4,1,wf6(:,2))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,139),heltab2x48(:,:,139))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMT,G1H24(63),n2h24(139))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(140),h0tab(:,140),[16,4,1,10],[nMT,nMT,nMZ,nMT],4,1,wf6(:,2))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,140),heltab2x48(:,:,140))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMT,G1H24(64),n2h24(140))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(141),h0tab(:,141),[16,4,1,10],[nMB,nMB,nMW,nMB],4,1,wf6(:,2))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,141),heltab2x48(:,:,141))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMB,G1H24(65),n2h24(141))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(142),h0tab(:,142),[16,4,1,10],[nMT,nMT,0,nMT],4,1,wf6(:,2))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,142),heltab2x48(:,:,142))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMT,G1H24(66),n2h24(142))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(143),h0tab(:,143),[16,4,1,10],[nMT,nMT,nMZ,nMT],4,1,wf6(:,2))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,143),heltab2x48(:,:,143))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMT,G1H24(67),n2h24(143))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(144),h0tab(:,144),[16,4,1,10],[nMB,nMB,nMW,nMB],4,1,wf6(:,2))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,144),heltab2x48(:,:,144))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMB,G1H24(68),n2h24(144))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(145),h0tab(:,145),[16,1,10,4],[nMT,nMH,nMT,nMT],4,1,wf6(:,2))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,145),heltab2x48(:,:,145))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMT,G1H24(69),n2h24(145))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(146),h0tab(:,146),[16,1,10,4],[nMT,nMZ,nMT,nMT],4,1,wf6(:,2))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,146),heltab2x48(:,:,146))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMT,G1H24(70),n2h24(146))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(147),h0tab(:,147),[16,1,10,4],[nMB,nMW,nMB,nMB],4,1,wf6(:,2))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,147),heltab2x48(:,:,147))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMB,G1H24(71),n2h24(147))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(148),h0tab(:,148),[16,1,10,4],[nMT,0,nMT,nMT],4,1,wf6(:,2))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,148),heltab2x48(:,:,148))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMT,G1H24(72),n2h24(148))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(149),h0tab(:,149),[16,1,10,4],[nMT,nMZ,nMT,nMT],4,1,wf6(:,2))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,149),heltab2x48(:,:,149))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMT,G1H24(73),n2h24(149))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(150),h0tab(:,150),[16,1,10,4],[nMB,nMW,nMB,nMB],4,1,wf6(:,2))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,150),heltab2x48(:,:,150))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMB,G1H24(74),n2h24(150))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(151),h0tab(:,151),[17,4,2,8],[nMT,nMT,nMH,nMZ],4,1,wf4(:,8))
  call Hloop_SQ_A(ntryL,G0H48(1),wf4(:,8),G0H12(1),ngX,m3h4x12(:,1),heltab2x48(:,:,151))
  call Hloop_Q_A(ntryL,G0H12(1),17,nMT,G1H12(1),n2h12(13))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(152),h0tab(:,152),[17,4,2,8],[nMT,nMT,nMZ,nMH],4,1,wf4(:,8))
  call Hloop_SQ_A(ntryL,G0H48(1),wf4(:,8),G0H12(1),ngH,m3h4x12(:,2),heltab2x48(:,:,152))
  call Hloop_Q_A(ntryL,G0H12(1),17,nMT,G1H12(2),n2h12(14))
  Gcoeff(:)%j = (-(c(32)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(153),h0tab(:,153),[17,4,2,8],[nMB,nMB,nMW,nMW],4,1,wf4(:,8))
  call Hloop_SQ_A(ntryL,G0H48(1),wf4(:,8),G0H12(1),ngPbt,m3h4x12(:,3),heltab2x48(:,:,153))
  call Hloop_Q_A(ntryL,G0H12(1),17,nMB,G1H12(3),n2h12(15))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(154),h0tab(:,154),[17,4,2,8],[nMW,nMW,nMB,nMB],4,1,wf4(:,8))
  call Hloop_AQ_S(ntryL,G0H48(1),wf4(:,8),G0H12(1),ngPbt,m3h4x12(:,4),heltab2x48(:,:,154))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(155),h0tab(:,155),[17,4,2,8],[nMT,nMT,nMH,nMZ],4,1,wf4(:,8))
  call Hloop_ZQ_A(ntryL,G0H48(1),wf4(:,8),G0H12(2),ngZu,m3h4x12(:,5),heltab2x48(:,:,155))
  call Hloop_Q_A(ntryL,G0H12(2),17,nMT,G1H12(4),n2h12(16))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(156),h0tab(:,156),[17,4,2,8],[nMB,nMB,nMW,nMW],4,1,wf4(:,8))
  call Hloop_WQ_A(ntryL,G0H48(1),wf4(:,8),G0H12(2),m3h4x12(:,6),heltab2x48(:,:,156))
  call Hloop_Q_A(ntryL,G0H12(2),17,nMB,G1H12(5),n2h12(17))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(157),h0tab(:,157),[17,4,2,8],[nMT,nMT,nMZ,nMH],4,1,wf4(:,8))
  call Hloop_SQ_A(ntryL,G0H48(1),wf4(:,8),G0H12(2),ngH,m3h4x12(:,7),heltab2x48(:,:,157))
  call Hloop_Q_A(ntryL,G0H12(2),17,nMT,G1H12(6),n2h12(18))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(158),h0tab(:,158),[17,4,2,8],[nMB,nMB,nMW,nMW],4,1,wf4(:,8))
  call Hloop_SQ_A(ntryL,G0H48(1),wf4(:,8),G0H12(2),ngPbt,m3h4x12(:,8),heltab2x48(:,:,158))
  call Hloop_Q_A(ntryL,G0H12(2),17,nMB,G1H12(7),n2h12(19))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(159),h0tab(:,159),[17,4,2,8],[nMW,nMW,nMB,nMB],4,1,wf4(:,8))
  call Hloop_AQ_W(ntryL,G0H48(1),wf4(:,8),G0H12(2),m3h4x12(:,9),heltab2x48(:,:,159))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(160),h0tab(:,160),[17,4,2,8],[nMW,nMW,nMB,nMB],4,1,wf4(:,8))
  call Hloop_AQ_S(ntryL,G0H48(1),wf4(:,8),G0H12(3),ngPbt,m3h4x12(:,10),heltab2x48(:,:,160))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(161),h0tab(:,161),[17,4,2,8],[nMB,nMB,nMW,nMW],4,1,wf4(:,8))
  call Hloop_WQ_A(ntryL,G0H48(1),wf4(:,8),G0H12(4),m3h4x12(:,11),heltab2x48(:,:,161))
  call Hloop_Q_A(ntryL,G0H12(4),17,nMB,G1H12(8),n2h12(20))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(162),h0tab(:,162),[17,4,2,8],[nMW,nMW,nMB,nMB],4,1,wf4(:,8))
  call Hloop_AQ_W(ntryL,G0H48(1),wf4(:,8),G0H12(4),m3h4x12(:,12),heltab2x48(:,:,162))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(163),h0tab(:,163),[17,2,4,8],[nMH,nMT,nMT,nMT],4,1,wf4(:,8))
  call Hloop_AQ_S(ntryL,G0H48(1),wf4(:,8),G0H12(5),ngH,m3h4x12(:,13),heltab2x48(:,:,163))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(164),h0tab(:,164),[17,2,4,8],[nMZ,nMT,nMT,nMT],4,1,wf4(:,8))
  call Hloop_AQ_S(ntryL,G0H48(1),wf4(:,8),G0H12(6),ngX,m3h4x12(:,14),heltab2x48(:,:,164))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(165),h0tab(:,165),[17,2,4,8],[nMW,nMB,nMB,nMB],4,1,wf4(:,8))
  call Hloop_AQ_S(ntryL,G0H48(1),wf4(:,8),G0H12(7),ngPbt,m3h4x12(:,15),heltab2x48(:,:,165))
  Gcoeff(:)%j = (c(34)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(166),h0tab(:,166),[17,2,4,8],[nMB,nMW,nMW,nMW],4,1,wf4(:,8))
  call Hloop_SQ_A(ntryL,G0H48(1),wf4(:,8),G0H12(8),ngPbt,m3h4x12(:,16),heltab2x48(:,:,166))
  call Hloop_Q_A(ntryL,G0H12(8),17,nMB,G1H12(9),n2h12(21))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(167),h0tab(:,167),[17,2,4,8],[0,nMT,nMT,nMT],4,1,wf4(:,8))
  call Hloop_AQ_V(ntryL,G0H48(1),wf4(:,8),G0H12(8),m3h4x12(:,17),heltab2x48(:,:,167))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(168),h0tab(:,168),[17,2,4,8],[nMZ,nMT,nMT,nMT],4,1,wf4(:,8))
  call Hloop_AQ_Z(ntryL,G0H48(1),wf4(:,8),G0H12(9),ngZu,m3h4x12(:,18),heltab2x48(:,:,168))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(169),h0tab(:,169),[17,2,4,8],[nMW,nMB,nMB,nMB],4,1,wf4(:,8))
  call Hloop_AQ_W(ntryL,G0H48(1),wf4(:,8),G0H12(10),m3h4x12(:,19),heltab2x48(:,:,169))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(170),h0tab(:,170),[17,2,4,8],[nMB,nMW,nMW,nMW],4,1,wf4(:,8))
  call Hloop_WQ_A(ntryL,G0H48(1),wf4(:,8),G0H12(11),m3h4x12(:,20),heltab2x48(:,:,170))
  call Hloop_Q_A(ntryL,G0H12(11),17,nMB,G1H12(10),n2h12(22))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(171),h0tab(:,171),[17,2,4,8],[nMB,nMW,nMW,nMW],4,1,wf4(:,8))
  call Hloop_SQ_A(ntryL,G0H48(1),wf4(:,8),G0H12(11),ngPbt,m3h4x12(:,21),heltab2x48(:,:,171))
  call Hloop_Q_A(ntryL,G0H12(11),17,nMB,G1H12(11),n2h12(23))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(172),h0tab(:,172),[17,2,4,8],[nMB,nMW,nMW,nMW],4,1,wf4(:,8))
  call Hloop_SQ_A(ntryL,G0H48(1),wf4(:,8),G0H12(11),ngPbt,m3h4x12(:,22),heltab2x48(:,:,172))
  call Hloop_Q_A(ntryL,G0H12(11),17,nMB,G1H12(12),n2h12(24))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(173),h0tab(:,173),[17,2,4,8],[nMB,nMW,nMW,nMW],4,1,wf4(:,8))
  call Hloop_WQ_A(ntryL,G0H48(1),wf4(:,8),G0H12(11),m3h4x12(:,23),heltab2x48(:,:,173))
  call Hloop_Q_A(ntryL,G0H12(11),17,nMB,G1H12(13),n2h12(25))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(174),h0tab(:,174),[17,2,4,8],[nMB,nMW,nMW,nMW],4,1,wf4(:,8))
  call Hloop_WQ_A(ntryL,G0H48(1),wf4(:,8),G0H12(11),m3h4x12(:,24),heltab2x48(:,:,174))
  call Hloop_Q_A(ntryL,G0H12(11),17,nMB,G1H12(14),n2h12(26))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(175),h0tab(:,175),[17,2,4,8],[nMB,nMW,nMW,nMW],4,1,wf4(:,8))
  call Hloop_SQ_A(ntryL,G0H48(1),wf4(:,8),G0H12(11),ngPbt,m3h4x12(:,25),heltab2x48(:,:,175))
  call Hloop_Q_A(ntryL,G0H12(11),17,nMB,G1H12(15),n2h12(27))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(176),h0tab(:,176),[17,2,4,8],[nMB,nMW,nMW,nMW],4,1,wf4(:,8))
  call Hloop_WQ_A(ntryL,G0H48(1),wf4(:,8),G0H12(11),m3h4x12(:,26),heltab2x48(:,:,176))
  call Hloop_Q_A(ntryL,G0H12(11),17,nMB,G1H12(16),n2h12(28))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(177),h0tab(:,177),[17,2,8,4],[nMH,nMT,nMT,nMT],4,1,wf4(:,8))
  call Hloop_AQ_S(ntryL,G0H48(1),wf4(:,8),G0H12(11),ngH,m3h4x12(:,27),heltab2x48(:,:,177))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(178),h0tab(:,178),[17,2,8,4],[nMZ,nMT,nMT,nMT],4,1,wf4(:,8))
  call Hloop_AQ_S(ntryL,G0H48(1),wf4(:,8),G0H12(12),ngX,m3h4x12(:,28),heltab2x48(:,:,178))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(179),h0tab(:,179),[17,2,8,4],[nMW,nMB,nMB,nMB],4,1,wf4(:,8))
  call Hloop_AQ_S(ntryL,G0H48(1),wf4(:,8),G0H12(13),ngPbt,m3h4x12(:,29),heltab2x48(:,:,179))
  Gcoeff(:)%j = (c(34)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(180),h0tab(:,180),[17,2,8,4],[nMB,nMW,nMW,nMW],4,1,wf4(:,8))
  call Hloop_SQ_A(ntryL,G0H48(1),wf4(:,8),G0H12(14),ngPbt,m3h4x12(:,30),heltab2x48(:,:,180))
  call Hloop_Q_A(ntryL,G0H12(14),17,nMB,G1H12(17),n2h12(29))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(181),h0tab(:,181),[17,2,8,4],[0,nMT,nMT,nMT],4,1,wf4(:,8))
  call Hloop_AQ_V(ntryL,G0H48(1),wf4(:,8),G0H12(14),m3h4x12(:,31),heltab2x48(:,:,181))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(182),h0tab(:,182),[17,2,8,4],[nMZ,nMT,nMT,nMT],4,1,wf4(:,8))
  call Hloop_AQ_Z(ntryL,G0H48(1),wf4(:,8),G0H12(15),ngZu,m3h4x12(:,32),heltab2x48(:,:,182))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(183),h0tab(:,183),[17,2,8,4],[nMW,nMB,nMB,nMB],4,1,wf4(:,8))
  call Hloop_AQ_W(ntryL,G0H48(1),wf4(:,8),G0H12(16),m3h4x12(:,33),heltab2x48(:,:,183))
  Gcoeff(:)%j = (c(30)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(184),h0tab(:,184),[17,2,8,4],[nMB,nMW,nMW,nMW],4,1,wf4(:,8))
  call Hloop_WQ_A(ntryL,G0H48(1),wf4(:,8),G0H12(17),m3h4x12(:,34),heltab2x48(:,:,184))
  call Hloop_Q_A(ntryL,G0H12(17),17,nMB,G1H12(18),n2h12(30))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(185),h0tab(:,185),[17,2,8,4],[nMB,nMW,nMW,nMW],4,1,wf4(:,8))
  call Hloop_SQ_A(ntryL,G0H48(1),wf4(:,8),G0H12(17),ngPbt,m3h4x12(:,35),heltab2x48(:,:,185))
  call Hloop_Q_A(ntryL,G0H12(17),17,nMB,G1H12(19),n2h12(31))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(186),h0tab(:,186),[17,2,8,4],[nMB,nMW,nMW,nMW],4,1,wf4(:,8))
  call Hloop_SQ_A(ntryL,G0H48(1),wf4(:,8),G0H12(17),ngPbt,m3h4x12(:,36),heltab2x48(:,:,186))
  call Hloop_Q_A(ntryL,G0H12(17),17,nMB,G1H12(20),n2h12(32))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(187),h0tab(:,187),[17,2,8,4],[nMB,nMW,nMW,nMW],4,1,wf4(:,8))
  call Hloop_WQ_A(ntryL,G0H48(1),wf4(:,8),G0H12(17),m3h4x12(:,37),heltab2x48(:,:,187))
  call Hloop_Q_A(ntryL,G0H12(17),17,nMB,G1H12(21),n2h12(33))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(188),h0tab(:,188),[17,2,8,4],[nMB,nMW,nMW,nMW],4,1,wf4(:,8))
  call Hloop_WQ_A(ntryL,G0H48(1),wf4(:,8),G0H12(17),m3h4x12(:,38),heltab2x48(:,:,188))
  call Hloop_Q_A(ntryL,G0H12(17),17,nMB,G1H12(22),n2h12(34))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(189),h0tab(:,189),[17,2,8,4],[nMB,nMW,nMW,nMW],4,1,wf4(:,8))
  call Hloop_SQ_A(ntryL,G0H48(1),wf4(:,8),G0H12(17),ngPbt,m3h4x12(:,39),heltab2x48(:,:,189))
  call Hloop_Q_A(ntryL,G0H12(17),17,nMB,G1H12(23),n2h12(35))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(190),h0tab(:,190),[17,2,8,4],[nMB,nMW,nMW,nMW],4,1,wf4(:,8))
  call Hloop_WQ_A(ntryL,G0H48(1),wf4(:,8),G0H12(17),m3h4x12(:,40),heltab2x48(:,:,190))
  call Hloop_Q_A(ntryL,G0H12(17),17,nMB,G1H12(24),n2h12(36))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(191),h0tab(:,191),[18,4,1,8],[nMT,nMT,nMH,nMZ],4,1,wf4(:,4))
  call Hloop_SA_Q(ntryL,G0H48(1),wf4(:,4),G0H12(17),ngX,m3h4x12(:,41),heltab2x48(:,:,191))
  call Hloop_A_Q(ntryL,G0H12(17),18,nMT,G1H12(25),n2h12(37))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(192),h0tab(:,192),[18,4,1,8],[nMT,nMT,nMZ,nMH],4,1,wf4(:,4))
  call Hloop_SA_Q(ntryL,G0H48(1),wf4(:,4),G0H12(17),ngH,m3h4x12(:,42),heltab2x48(:,:,192))
  call Hloop_A_Q(ntryL,G0H12(17),18,nMT,G1H12(26),n2h12(38))
  Gcoeff(:)%j = (-(c(32)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(193),h0tab(:,193),[18,4,1,8],[nMB,nMB,nMW,nMW],4,1,wf4(:,4))
  call Hloop_SA_Q(ntryL,G0H48(1),wf4(:,4),G0H12(17),ngPtb,m3h4x12(:,43),heltab2x48(:,:,193))
  call Hloop_A_Q(ntryL,G0H12(17),18,nMB,G1H12(27),n2h12(39))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(194),h0tab(:,194),[18,4,1,8],[nMW,nMW,nMB,nMB],4,1,wf4(:,4))
  call Hloop_QA_S(ntryL,G0H48(1),wf4(:,4),G0H12(17),ngPtb,m3h4x12(:,44),heltab2x48(:,:,194))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(195),h0tab(:,195),[18,4,1,8],[nMT,nMT,nMH,nMZ],4,1,wf4(:,4))
  call Hloop_ZA_Q(ntryL,G0H48(1),wf4(:,4),G0H12(18),ngZu,m3h4x12(:,45),heltab2x48(:,:,195))
  call Hloop_A_Q(ntryL,G0H12(18),18,nMT,G1H12(28),n2h12(40))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(196),h0tab(:,196),[18,4,1,8],[nMB,nMB,nMW,nMW],4,1,wf4(:,4))
  call Hloop_WA_Q(ntryL,G0H48(1),wf4(:,4),G0H12(18),m3h4x12(:,46),heltab2x48(:,:,196))
  call Hloop_A_Q(ntryL,G0H12(18),18,nMB,G1H12(29),n2h12(41))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(197),h0tab(:,197),[18,4,1,8],[nMT,nMT,nMZ,nMH],4,1,wf4(:,4))
  call Hloop_SA_Q(ntryL,G0H48(1),wf4(:,4),G0H12(18),ngH,m3h4x12(:,47),heltab2x48(:,:,197))
  call Hloop_A_Q(ntryL,G0H12(18),18,nMT,G1H12(30),n2h12(42))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(198),h0tab(:,198),[18,4,1,8],[nMB,nMB,nMW,nMW],4,1,wf4(:,4))
  call Hloop_SA_Q(ntryL,G0H48(1),wf4(:,4),G0H12(18),ngPtb,m3h4x12(:,48),heltab2x48(:,:,198))
  call Hloop_A_Q(ntryL,G0H12(18),18,nMB,G1H12(31),n2h12(43))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(199),h0tab(:,199),[18,4,1,8],[nMW,nMW,nMB,nMB],4,1,wf4(:,4))
  call Hloop_QA_W(ntryL,G0H48(1),wf4(:,4),G0H12(18),m3h4x12(:,49),heltab2x48(:,:,199))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(200),h0tab(:,200),[18,4,1,8],[nMW,nMW,nMB,nMB],4,1,wf4(:,4))
  call Hloop_QA_S(ntryL,G0H48(1),wf4(:,4),G0H12(19),ngPtb,m3h4x12(:,50),heltab2x48(:,:,200))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(201),h0tab(:,201),[18,4,1,8],[nMB,nMB,nMW,nMW],4,1,wf4(:,4))
  call Hloop_WA_Q(ntryL,G0H48(1),wf4(:,4),G0H12(20),m3h4x12(:,51),heltab2x48(:,:,201))
  call Hloop_A_Q(ntryL,G0H12(20),18,nMB,G1H12(32),n2h12(44))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(202),h0tab(:,202),[18,4,1,8],[nMW,nMW,nMB,nMB],4,1,wf4(:,4))
  call Hloop_QA_W(ntryL,G0H48(1),wf4(:,4),G0H12(20),m3h4x12(:,52),heltab2x48(:,:,202))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(203),h0tab(:,203),[18,1,4,8],[nMH,nMT,nMT,nMT],4,1,wf4(:,4))
  call Hloop_QA_S(ntryL,G0H48(1),wf4(:,4),G0H12(21),ngH,m3h4x12(:,53),heltab2x48(:,:,203))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(204),h0tab(:,204),[18,1,4,8],[nMZ,nMT,nMT,nMT],4,1,wf4(:,4))
  call Hloop_QA_S(ntryL,G0H48(1),wf4(:,4),G0H12(22),ngX,m3h4x12(:,54),heltab2x48(:,:,204))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(205),h0tab(:,205),[18,1,4,8],[nMW,nMB,nMB,nMB],4,1,wf4(:,4))
  call Hloop_QA_S(ntryL,G0H48(1),wf4(:,4),G0H12(23),ngPtb,m3h4x12(:,55),heltab2x48(:,:,205))
  Gcoeff(:)%j = (c(34)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(206),h0tab(:,206),[18,1,4,8],[nMB,nMW,nMW,nMW],4,1,wf4(:,4))
  call Hloop_SA_Q(ntryL,G0H48(1),wf4(:,4),G0H12(24),ngPtb,m3h4x12(:,56),heltab2x48(:,:,206))
  call Hloop_A_Q(ntryL,G0H12(24),18,nMB,G1H12(33),n2h12(45))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(207),h0tab(:,207),[18,1,4,8],[0,nMT,nMT,nMT],4,1,wf4(:,4))
  call Hloop_QA_V(ntryL,G0H48(1),wf4(:,4),G0H12(24),m3h4x12(:,57),heltab2x48(:,:,207))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(208),h0tab(:,208),[18,1,4,8],[nMZ,nMT,nMT,nMT],4,1,wf4(:,4))
  call Hloop_QA_Z(ntryL,G0H48(1),wf4(:,4),G0H12(25),ngZu,m3h4x12(:,58),heltab2x48(:,:,208))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(209),h0tab(:,209),[18,1,4,8],[nMW,nMB,nMB,nMB],4,1,wf4(:,4))
  call Hloop_QA_W(ntryL,G0H48(1),wf4(:,4),G0H12(26),m3h4x12(:,59),heltab2x48(:,:,209))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(210),h0tab(:,210),[18,1,4,8],[nMB,nMW,nMW,nMW],4,1,wf4(:,4))
  call Hloop_WA_Q(ntryL,G0H48(1),wf4(:,4),G0H12(27),m3h4x12(:,60),heltab2x48(:,:,210))
  call Hloop_A_Q(ntryL,G0H12(27),18,nMB,G1H12(34),n2h12(46))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(211),h0tab(:,211),[18,1,4,8],[nMB,nMW,nMW,nMW],4,1,wf4(:,4))
  call Hloop_SA_Q(ntryL,G0H48(1),wf4(:,4),G0H12(27),ngPtb,m3h4x12(:,61),heltab2x48(:,:,211))
  call Hloop_A_Q(ntryL,G0H12(27),18,nMB,G1H12(35),n2h12(47))
  Gcoeff(:)%j = (c(30)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(212),h0tab(:,212),[18,1,4,8],[nMB,nMW,nMW,nMW],4,1,wf4(:,4))
  call Hloop_SA_Q(ntryL,G0H48(1),wf4(:,4),G0H12(27),ngPtb,m3h4x12(:,62),heltab2x48(:,:,212))
  call Hloop_A_Q(ntryL,G0H12(27),18,nMB,G1H12(36),n2h12(48))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(213),h0tab(:,213),[18,1,4,8],[nMB,nMW,nMW,nMW],4,1,wf4(:,4))
  call Hloop_WA_Q(ntryL,G0H48(1),wf4(:,4),G0H12(27),m3h4x12(:,63),heltab2x48(:,:,213))
  call Hloop_A_Q(ntryL,G0H12(27),18,nMB,G1H12(37),n2h12(49))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(214),h0tab(:,214),[18,1,4,8],[nMB,nMW,nMW,nMW],4,1,wf4(:,4))
  call Hloop_WA_Q(ntryL,G0H48(1),wf4(:,4),G0H12(27),m3h4x12(:,64),heltab2x48(:,:,214))
  call Hloop_A_Q(ntryL,G0H12(27),18,nMB,G1H12(38),n2h12(50))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(215),h0tab(:,215),[18,1,4,8],[nMB,nMW,nMW,nMW],4,1,wf4(:,4))
  call Hloop_SA_Q(ntryL,G0H48(1),wf4(:,4),G0H12(27),ngPtb,m3h4x12(:,65),heltab2x48(:,:,215))
  call Hloop_A_Q(ntryL,G0H12(27),18,nMB,G1H12(39),n2h12(51))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(216),h0tab(:,216),[18,1,4,8],[nMB,nMW,nMW,nMW],4,1,wf4(:,4))
  call Hloop_WA_Q(ntryL,G0H48(1),wf4(:,4),G0H12(27),m3h4x12(:,66),heltab2x48(:,:,216))
  call Hloop_A_Q(ntryL,G0H12(27),18,nMB,G1H12(40),n2h12(52))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(217),h0tab(:,217),[18,1,8,4],[nMH,nMT,nMT,nMT],4,1,wf4(:,4))
  call Hloop_QA_S(ntryL,G0H48(1),wf4(:,4),G0H12(27),ngH,m3h4x12(:,67),heltab2x48(:,:,217))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(218),h0tab(:,218),[18,1,8,4],[nMZ,nMT,nMT,nMT],4,1,wf4(:,4))
  call Hloop_QA_S(ntryL,G0H48(1),wf4(:,4),G0H12(28),ngX,m3h4x12(:,68),heltab2x48(:,:,218))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(219),h0tab(:,219),[18,1,8,4],[nMW,nMB,nMB,nMB],4,1,wf4(:,4))
  call Hloop_QA_S(ntryL,G0H48(1),wf4(:,4),G0H12(29),ngPtb,m3h4x12(:,69),heltab2x48(:,:,219))
  Gcoeff(:)%j = (c(34)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(220),h0tab(:,220),[18,1,8,4],[nMB,nMW,nMW,nMW],4,1,wf4(:,4))
  call Hloop_SA_Q(ntryL,G0H48(1),wf4(:,4),G0H12(30),ngPtb,m3h4x12(:,70),heltab2x48(:,:,220))
  call Hloop_A_Q(ntryL,G0H12(30),18,nMB,G1H12(41),n2h12(53))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(221),h0tab(:,221),[18,1,8,4],[0,nMT,nMT,nMT],4,1,wf4(:,4))
  call Hloop_QA_V(ntryL,G0H48(1),wf4(:,4),G0H12(30),m3h4x12(:,71),heltab2x48(:,:,221))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(222),h0tab(:,222),[18,1,8,4],[nMZ,nMT,nMT,nMT],4,1,wf4(:,4))
  call Hloop_QA_Z(ntryL,G0H48(1),wf4(:,4),G0H12(31),ngZu,m3h4x12(:,72),heltab2x48(:,:,222))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(223),h0tab(:,223),[18,1,8,4],[nMW,nMB,nMB,nMB],4,1,wf4(:,4))
  call Hloop_QA_W(ntryL,G0H48(1),wf4(:,4),G0H12(32),m3h4x12(:,73),heltab2x48(:,:,223))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(224),h0tab(:,224),[18,1,8,4],[nMB,nMW,nMW,nMW],4,1,wf4(:,4))
  call Hloop_WA_Q(ntryL,G0H48(1),wf4(:,4),G0H12(33),m3h4x12(:,74),heltab2x48(:,:,224))
  call Hloop_A_Q(ntryL,G0H12(33),18,nMB,G1H12(42),n2h12(54))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(225),h0tab(:,225),[18,1,8,4],[nMB,nMW,nMW,nMW],4,1,wf4(:,4))
  call Hloop_SA_Q(ntryL,G0H48(1),wf4(:,4),G0H12(33),ngPtb,m3h4x12(:,75),heltab2x48(:,:,225))
  call Hloop_A_Q(ntryL,G0H12(33),18,nMB,G1H12(43),n2h12(55))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(226),h0tab(:,226),[18,1,8,4],[nMB,nMW,nMW,nMW],4,1,wf4(:,4))
  call Hloop_SA_Q(ntryL,G0H48(1),wf4(:,4),G0H12(33),ngPtb,m3h4x12(:,76),heltab2x48(:,:,226))
  call Hloop_A_Q(ntryL,G0H12(33),18,nMB,G1H12(44),n2h12(56))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(227),h0tab(:,227),[18,1,8,4],[nMB,nMW,nMW,nMW],4,1,wf4(:,4))
  call Hloop_WA_Q(ntryL,G0H48(1),wf4(:,4),G0H12(33),m3h4x12(:,77),heltab2x48(:,:,227))
  call Hloop_A_Q(ntryL,G0H12(33),18,nMB,G1H12(45),n2h12(57))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(228),h0tab(:,228),[18,1,8,4],[nMB,nMW,nMW,nMW],4,1,wf4(:,4))
  call Hloop_WA_Q(ntryL,G0H48(1),wf4(:,4),G0H12(33),m3h4x12(:,78),heltab2x48(:,:,228))
  call Hloop_A_Q(ntryL,G0H12(33),18,nMB,G1H12(46),n2h12(58))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(229),h0tab(:,229),[18,1,8,4],[nMB,nMW,nMW,nMW],4,1,wf4(:,4))
  call Hloop_SA_Q(ntryL,G0H48(1),wf4(:,4),G0H12(33),ngPtb,m3h4x12(:,79),heltab2x48(:,:,229))
  call Hloop_A_Q(ntryL,G0H12(33),18,nMB,G1H12(47),n2h12(59))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(230),h0tab(:,230),[18,1,8,4],[nMB,nMW,nMW,nMW],4,1,wf4(:,4))
  call Hloop_WA_Q(ntryL,G0H48(1),wf4(:,4),G0H12(33),m3h4x12(:,80),heltab2x48(:,:,230))
  call Hloop_A_Q(ntryL,G0H12(33),18,nMB,G1H12(48),n2h12(60))
  call Hloop_AQ_S(ntryL,G1H24(1),ex1(:),G1H12(49),ngPbt,m3h2x12(:,77),heltab2x24(:,:,77))
  call Hloop_AQ_W(ntryL,G1H24(2),ex1(:),G1H12(50),m3h2x12(:,78),heltab2x24(:,:,78))
  call Hloop_QA_S(ntryL,G1H24(3),ex2(:),G1H12(51),ngH,m3h2x12(:,79),heltab2x24(:,:,79))
  call Hloop_QA_S(ntryL,G1H24(4),ex2(:),G1H12(52),ngX,m3h2x12(:,80),heltab2x24(:,:,80))
  call Hloop_QA_S(ntryL,G1H24(5),ex2(:),G1H12(53),ngPtb,m3h2x12(:,81),heltab2x24(:,:,81))
  call Hloop_QA_S(ntryL,G1H24(6),ex2(:),G1H12(54),ngH,m3h2x12(:,82),heltab2x24(:,:,82))
  call Hloop_QA_S(ntryL,G1H24(7),ex2(:),G1H12(55),ngPtb,m3h2x12(:,83),heltab2x24(:,:,83))
  call Hloop_QA_Z(ntryL,G1H24(8),ex2(:),G1H12(56),ngZu,m3h2x12(:,84),heltab2x24(:,:,84))
  call Hloop_QA_W(ntryL,G1H24(9),ex2(:),G1H12(57),m3h2x12(:,85),heltab2x24(:,:,85))
  call Hloop_QA_W(ntryL,G1H24(10),ex2(:),G1H12(58),m3h2x12(:,86),heltab2x24(:,:,86))
  call Hloop_AQ_S(ntryL,G1H24(11),wf4(:,2),G1H6(1),ngH,m3h4x6(:,1),heltab2x24(:,:,87))
  call Hloop_AQ_S(ntryL,G1H24(12),wf4(:,2),G1H6(2),ngX,m3h4x6(:,2),heltab2x24(:,:,88))
  call Hloop_AQ_S(ntryL,G1H24(13),wf4(:,2),G1H6(6),ngPbt,m3h4x6(:,3),heltab2x24(:,:,89))
  call Hloop_AQ_V(ntryL,G1H24(14),wf4(:,2),G1H6(5),m3h4x6(:,4),heltab2x24(:,:,90))
  call Hloop_AQ_Z(ntryL,G1H24(15),wf4(:,2),G1H6(8),ngZu,m3h4x6(:,5),heltab2x24(:,:,91))
  call Hloop_AQ_W(ntryL,G1H24(16),wf4(:,2),G1H6(7),m3h4x6(:,6),heltab2x24(:,:,92))
  call Hloop_QA_S(ntryL,G1H24(17),ex2(:),G1H12(59),ngH,m3h2x12(:,87),heltab2x24(:,:,93))
  call Hloop_QA_S(ntryL,G1H24(18),ex2(:),G1H12(60),ngX,m3h2x12(:,88),heltab2x24(:,:,94))
  call Hloop_QA_S(ntryL,G1H24(19),ex2(:),G1H12(61),ngPtb,m3h2x12(:,89),heltab2x24(:,:,95))
  call Hloop_QA_V(ntryL,G1H24(20),ex2(:),G1H12(62),m3h2x12(:,90),heltab2x24(:,:,96))
  call Hloop_QA_Z(ntryL,G1H24(21),ex2(:),G1H12(63),ngZu,m3h2x12(:,91),heltab2x24(:,:,97))
  call Hloop_QA_W(ntryL,G1H24(22),ex2(:),G1H12(64),m3h2x12(:,92),heltab2x24(:,:,98))
  call Hloop_AQ_S(ntryL,G1H24(23),ex1(:),G1H12(65),ngH,m3h2x12(:,93),heltab2x24(:,:,99))
  call Hloop_AQ_S(ntryL,G1H24(24),ex1(:),G1H12(66),ngX,m3h2x12(:,94),heltab2x24(:,:,100))
  call Hloop_AQ_S(ntryL,G1H24(25),ex1(:),G1H12(67),ngPbt,m3h2x12(:,95),heltab2x24(:,:,101))
  call Hloop_AQ_S(ntryL,G1H24(26),ex1(:),G1H12(68),ngH,m3h2x12(:,96),heltab2x24(:,:,102))
  call Hloop_AQ_S(ntryL,G1H24(27),ex1(:),G1H12(69),ngPbt,m3h2x12(:,97),heltab2x24(:,:,103))
  call Hloop_AQ_Z(ntryL,G1H24(28),ex1(:),G1H12(70),ngZu,m3h2x12(:,98),heltab2x24(:,:,104))
  call Hloop_AQ_W(ntryL,G1H24(29),ex1(:),G1H12(71),m3h2x12(:,99),heltab2x24(:,:,105))
  call Hloop_AQ_W(ntryL,G1H24(30),ex1(:),G1H12(72),m3h2x12(:,100),heltab2x24(:,:,106))
  call Hloop_QA_S(ntryL,G1H24(31),wf4(:,6),G1H6(11),ngH,m3h4x6(:,7),heltab2x24(:,:,107))
  call Hloop_QA_S(ntryL,G1H24(32),wf4(:,6),G1H6(12),ngX,m3h4x6(:,8),heltab2x24(:,:,108))
  call Hloop_QA_S(ntryL,G1H24(33),wf4(:,6),G1H6(13),ngPtb,m3h4x6(:,9),heltab2x24(:,:,109))
  call Hloop_QA_V(ntryL,G1H24(34),wf4(:,6),G1H6(14),m3h4x6(:,10),heltab2x24(:,:,110))
  call Hloop_QA_Z(ntryL,G1H24(35),wf4(:,6),G1H6(17),ngZu,m3h4x6(:,11),heltab2x24(:,:,111))
  call Hloop_QA_W(ntryL,G1H24(36),wf4(:,6),G1H6(18),m3h4x6(:,12),heltab2x24(:,:,112))
  call Hloop_AQ_S(ntryL,G1H24(37),ex1(:),G1H12(73),ngH,m3h2x12(:,101),heltab2x24(:,:,113))
  call Hloop_AQ_S(ntryL,G1H24(38),ex1(:),G1H12(74),ngX,m3h2x12(:,102),heltab2x24(:,:,114))
  call Hloop_AQ_S(ntryL,G1H24(39),ex1(:),G1H12(75),ngPbt,m3h2x12(:,103),heltab2x24(:,:,115))
  call Hloop_AQ_V(ntryL,G1H24(40),ex1(:),G1H12(76),m3h2x12(:,104),heltab2x24(:,:,116))
  call Hloop_AQ_Z(ntryL,G1H24(41),ex1(:),G1H12(77),ngZu,m3h2x12(:,105),heltab2x24(:,:,117))
  call Hloop_AQ_W(ntryL,G1H24(42),ex1(:),G1H12(78),m3h2x12(:,106),heltab2x24(:,:,118))
  call Hloop_QA_S(ntryL,G1H24(43),ex2(:),G1H12(79),ngPtb,m3h2x12(:,107),heltab2x24(:,:,119))
  call Hloop_QA_S(ntryL,G1H24(44),ex2(:),G1H12(80),ngPtb,m3h2x12(:,108),heltab2x24(:,:,120))
  call Hloop_QA_W(ntryL,G1H24(45),ex2(:),G1H12(81),m3h2x12(:,109),heltab2x24(:,:,121))
  call Hloop_QA_W(ntryL,G1H24(46),ex2(:),G1H12(82),m3h2x12(:,110),heltab2x24(:,:,122))
  call Hloop_QV_A(ntryL,G1H24(47),ex3(:),G1H12(83),m3h2x12(:,111),heltab2x24(:,:,123))
  call Hloop_Q_A(ntryL,G1H12(83),20,nMT,G2H12(1),n2h12(61))
  call Hloop_QV_A(ntryL,G1H24(48),ex3(:),G1H12(83),m3h2x12(:,112),heltab2x24(:,:,124))
  call Hloop_Q_A(ntryL,G1H12(83),20,nMT,G2H12(2),n2h12(62))
  call Hloop_QV_A(ntryL,G1H24(49),ex3(:),G1H12(83),m3h2x12(:,113),heltab2x24(:,:,125))
  call Hloop_Q_A(ntryL,G1H12(83),20,nMB,G2H12(3),n2h12(63))
  call Hloop_QV_A(ntryL,G1H24(50),ex3(:),G1H12(83),m3h2x12(:,114),heltab2x24(:,:,126))
  call Hloop_Q_A(ntryL,G1H12(83),20,nMT,G2H12(4),n2h12(64))



end subroutine vamp_1

end module ol_vamp_1_ppztt_ew_ttxazg_2_/**/REALKIND
