
module ol_colourmatrix_ppztt_ew_ttxddxz_3_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  logical, save           :: colmat_not_initialised = .true.
  complex(REALKIND), save :: K1(51,3), K2(3,3), KL(3,3), Cas(5) = 0
  contains
  subroutine colourmatrix_init
    use ol_parameters_decl_/**/REALKIND, only: CI
    implicit none
    integer :: k, co
    colmat_not_initialised = .false.
    ! colour matrix

  K1( 1,:) = [   0,   0,   0]
  K1( 2,:) = [   0,   9,   0]
  K1( 3,:) = [   0,   0,   0]
  K1( 4,:) = [   0,   0,   0]
  K1( 5,:) = [   0,  12,   0]
  K1( 6,:) = [   0,   0,   0]
  K1( 7,:) = [   0,   0,   0]
  K1( 8,:) = [   0, -12,   0]
  K1( 9,:) = [   0,   0,   0]
  K1(10,:) = [   0,   0,   0]
  K1(11,:) = [   0,  12,   0]
  K1(12,:) = [   0,   0,   0]
  K1(13,:) = [   0,   0,   0]
  K1(14,:) = [   0,   0,   0]
  K1(15,:) = [   0,   0,   0]
  K1(16,:) = [   0,   0,   0]
  K1(17,:) = [   0,   0,   0]
  K1(18,:) = [   0,   0,   0]
  K1(19,:) = [   0,   0,   0]
  K1(20,:) = [   0,  12,   0]
  K1(21,:) = [   0,   0,   0]
  K1(22,:) = [   0,   0,   0]
  K1(23,:) = [   0,   0,   0]
  K1(24,:) = [   0,   0,   0]
  K1(25,:) = [   0,   0,   0]
  K1(26,:) = [   0,   0,   0]
  K1(27,:) = [   0,   0,   0]
  K1(28,:) = [   0,   0,   0]
  K1(29,:) = [   0, -12,   0]
  K1(30,:) = [   0,   0,   0]
  K1(31,:) = [   0,   0,   0]
  K1(32,:) = [   0,  12,   0]
  K1(33,:) = [   0,   0,   0]
  K1(34,:) = [   0,   0,   0]
  K1(35,:) = [   0,   0,   0]
  K1(36,:) = [   0,   0,   0]
  K1(37,:) = [   0,   0,   0]
  K1(38,:) = [   0,   0,   0]
  K1(39,:) = [   0,   0,   0]
  K1(40,:) = [   0,   0,   0]
  K1(41,:) = [   0,   0,   0]
  K1(42,:) = [   0,   0,   0]
  K1(43,:) = [   0,   0,   0]
  K1(44,:) = [   0,   0,   0]
  K1(45,:) = [   0,   0,   0]
  K1(46,:) = [   0,   0,   0]
  K1(47,:) = [   0,   0,   0]
  K1(48,:) = [   0,   0,   0]
  K1(49,:) = [   0,   3,   0]
  K1(50,:) = [   3,   0,   9]
  K1(51,:) = [   0,   9,   0]

  K2(1,:) = [ 0, 0, 3]
  K2(2,:) = [ 3, 9, 0]
  K2(3,:) = [ 0, 0, 9]

  KL(1,:) = [ 0, 3, 0]
  KL(2,:) = [ 3, 0, 9]
  KL(3,:) = [ 0, 9, 0]

#if 1 > 0
    co = 0
    do k = 1, 5
      co = co + k
      Cas(k) = K1(1+3*co,1)/K1(1,1)
    end do
#endif
  end subroutine colourmatrix_init
end module ol_colourmatrix_ppztt_ew_ttxddxz_3_/**/REALKIND



module ol_forced_parameters_ppztt_ew_ttxddxz_3_/**/REALKIND
  implicit none
  contains
  subroutine check_forced_parameters
    use ol_parameters_decl_/**/REALKIND
    use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
    use ol_loop_parameters_decl_/**/DREALKIND, only: LeadingColour, nc, nf, CKMORDER
#endif
    implicit none
    logical, save :: checks_not_written = .true.

    if (checks_not_written) then
    ! e.g.
    ! if (ME /= 0) write(*,101) 'ME = 0'
  if (CKMORDER /= 0) write(*,101) 'CKMORDER = 0'
  if (nc /= 3) write(*,101) 'nc = 3'
  if (nf /= 6) write(*,101) 'nf = 6'
  if (MU /= 0) write(*,101) 'MU = 0'
  if (MD /= 0) write(*,101) 'MD = 0'
  if (MS /= 0) write(*,101) 'MS = 0'
  if (MC /= 0) write(*,101) 'MC = 0'
  if (LeadingColour /= 0) write(*,101) 'LeadingColour = 0'
  if (wMT /= 0) write(*,101) 'wMT = 0'
  if (wMT /= 0) write(*,101) 'wMT = 0'
  if (wMZ /= 0) write(*,101) 'wMZ = 0'


    checks_not_written = .false.
    end if

    101 format('[OpenLoops] === WARNING ===',/,'[OpenLoops] code was generated with ',A,/,'[OpenLoops] ===============')
  end subroutine check_forced_parameters
end module ol_forced_parameters_ppztt_ew_ttxddxz_3_/**/REALKIND


! **********************************************************************
module ol_loop_storage_ppztt_ew_ttxddxz_3_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, intkind1, intkind2
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont

#ifdef PRECISION_dp
  integer(intkind1), save :: ntry = 1, ntryL = 1
  integer(intkind1), save :: p_switch = 0 ! switch for dp or qp. Used for memory allocation of the OL types
  ! the following are flags for memory allocation of the hol coefficients in dp or qp
  logical, save :: dp_not_alloc = .TRUE., qp_not_alloc = .TRUE.
  integer, save :: n_merge_steps  ! total number of merging steps
  integer, save :: n_merge_mism   ! number of merging mismatches
  integer, save :: merge_step = 1 ! current merging step
  integer(intkind2), save, allocatable :: merge_tables(:,:,:) ! merging tables
  integer(intkind2), save, allocatable :: merge_mism(:)       ! array of merging mismatches
  integer(intkind2), save, allocatable :: merge_hels(:)       ! array with relevant helicities for a merging step
  logical, save :: merge_tables_on = .false.
  integer(intkind2), parameter :: nheltot = 48 ! number of helicity configurations
  integer(intkind2), save :: nhel = 48 ! number of non-vanishing helicity configurations (adapted at runtime)
  integer(intkind2), save :: Hel(48) ! physical helicity states
#endif

  complex(REALKIND), save :: den(95)

  ! external wave functions ex1(h1),... for h<n> helicities
  type(wfun) :: ex1(2), ex2(2), ex3(2), ex4(2), ex5(3)

  ! wf<h>(h,n) n wave functions with h helicity configurations
  type(wfun) :: wf4(4,31), wf6(6,32), wf8(8,36), wf12(12,38), wf48(48,128)

  ! diagram prefactors
  integer,           save :: fac_status_loop1 = -1, fac_status_loop2 = -1
  complex(REALKIND), save :: f(258), c(251)

  !Vector in helicity and colour space for Born-Loop interference
  type(Hpolcont),   save :: M0_col1_helarray(3,48), M0M1_hel_cc(3,48,16)
  complex(REALKIND), save :: M2ctcc(16)

end module ol_loop_storage_ppztt_ew_ttxddxz_3_/**/REALKIND






! **********************************************************************
module ol_loop_ppztt_ew_ttxddxz_3_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, DREALKIND, intkind1, intkind2
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont
  use ol_loop_storage_ppztt_ew_ttxddxz_3_/**/REALKIND
  implicit none

!*********************************************************************************
  contains

! **********************************************************************
subroutine fac_init_loop()
! Writes diagram prefactors to 'f', rsp. 'c'
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND
  use ol_init, only: set_parameter, tree_parameters_flush, parameters_flush
#ifndef PRECISION_dp
  use ol_loop_parameters_decl_/**/DREALKIND, only: SwF, SwB
!  use ol_loop_parameters_decl_/**/DREALKIND, only: DOI
#endif
  implicit none
  call set_parameter("ew_renorm", 1)
  if (parameters_status == 0) call tree_parameters_flush()
  if (loop_parameters_status == 0) call parameters_flush()
  fac_status_loop1 = parameters_status
  fac_status_loop2 = loop_parameters_status
  ! factors of the diagrams
    f(  1) = (2*CI*eQED**3)/9._/**/REALKIND
    f(  2) = CI*eQED**3
    f(  3) = (2*CI*countertermnorm*eQED**5)/9._/**/REALKIND
    f(  4) = (CI*countertermnorm*eQED**5)/3._/**/REALKIND
    f(  5) = (2*CI*countertermnorm*eQED**5)/3._/**/REALKIND
    f(  6) = CI*countertermnorm*eQED**5
    f(  7) = CI*eQED*gQCD**2
    f(  8) = (2*CI*countertermnorm*eQED**3*gQCD**2)/9._/**/REALKIND
    f(  9) = CI*countertermnorm*eQED**3*gQCD**2
    f( 10) = (2*CI*countertermnorm*ctVqq*eQED**3*gQCD**2)/9._/**/REALKIND
    f( 11) = CI*countertermnorm*ctVqq*eQED**3*gQCD**2
    f( 12) = (2*CI*countertermnorm*ctVtt*eQED**3*gQCD**2)/9._/**/REALKIND
    f( 13) = CI*countertermnorm*ctVtt*eQED**3*gQCD**2
    f( 14) = (CI*eQED**3*MT)/(2._/**/REALKIND*cw**2*sw**2)
    f( 15) = (CI*countertermnorm*eQED**5*MT)/(6._/**/REALKIND*cw**2*sw**2)
    f( 16) = (CI*countertermnorm*eQED**5*MT)/(2._/**/REALKIND*cw**2*sw**2)
    f( 17) = (CI*countertermnorm*ctStt*eQED**3*gQCD**2*MT)/(2._/**/REALKIND*cw**2*sw**2)
    f( 18) = (CI*countertermnorm*ctVqq*eQED**3*gQCD**2*MT)/(2._/**/REALKIND*cw**2*sw**2)
    f( 19) = (countertermnorm*eQED**5*MT)/(cw*MW*sw**2*12._/**/REALKIND)
    f( 20) = (countertermnorm*eQED**5*MT)/(cw*MW*sw**2*4._/**/REALKIND)
    f( 21) = (CI*countertermnorm*eQED**5*MT)/(cw**2*sw)
    f( 22) = (countertermnorm*eQED**5*MT)/(MW*sw*6._/**/REALKIND)
    f( 23) = (countertermnorm*eQED**5*MT)/(MW*sw*2._/**/REALKIND)
    f( 24) = (CI*countertermnorm*eQED**5*EWctHZA*MT)/(6._/**/REALKIND*MW*sw)
    f( 25) = (CI*countertermnorm*eQED**5*EWctHZZ*MT)/(2._/**/REALKIND*MW*sw)
    f( 26) = (2*eQED**5*integralnorm*SwB)/81._/**/REALKIND
    f( 27) = (4*eQED**5*integralnorm*SwB)/81._/**/REALKIND
    f( 28) = (8*eQED**5*integralnorm*SwB)/81._/**/REALKIND
    f( 29) = (eQED**5*integralnorm*SwB)/9._/**/REALKIND
    f( 30) = (2*eQED**5*integralnorm*SwB)/9._/**/REALKIND
    f( 31) = (4*eQED**5*integralnorm*SwB)/9._/**/REALKIND
    f( 32) = eQED**5*integralnorm*SwB
    f( 33) = (eQED**5*integralnorm*SwB)/(cw**2*2._/**/REALKIND)
    f( 34) = (eQED**3*gQCD**2*integralnorm*SwB)/9._/**/REALKIND
    f( 35) = (2*eQED**3*gQCD**2*integralnorm*SwB)/9._/**/REALKIND
    f( 36) = (4*eQED**3*gQCD**2*integralnorm*SwB)/9._/**/REALKIND
    f( 37) = eQED**3*gQCD**2*integralnorm*SwB
    f( 38) = (eQED**5*integralnorm*MT*SwB)/(cw**2*4._/**/REALKIND)
    f( 39) = (eQED**5*integralnorm*MH**2*MT*SwB)/(cw**2*4._/**/REALKIND)
    f( 40) = (2*eQED**5*integralnorm*MW**2*SwB)/9._/**/REALKIND
    f( 41) = (eQED**5*integralnorm*MW**2*SwB)/3._/**/REALKIND
    f( 42) = (2*eQED**5*integralnorm*MW**2*SwB)/3._/**/REALKIND
    f( 43) = (eQED**5*integralnorm*MW**2*SwB)/(cw**2*2._/**/REALKIND)
    f( 44) = (eQED**5*integralnorm*MT*MW**2*SwB)/(cw**4*2._/**/REALKIND)
    f( 45) = (eQED**5*integralnorm*MT*MW**2*SwB)/(cw**2*2._/**/REALKIND)
    f( 46) = (cw*eQED**5*integralnorm*SwB)/(sw**5*4._/**/REALKIND)
    f( 47) = (eQED**5*integralnorm*MT*SwB)/(cw*sw**5*8._/**/REALKIND)
    f( 48) = (eQED**5*integralnorm*MT*SwB)/(cw*sw**5*4._/**/REALKIND)
    f( 49) = (cw*eQED**5*integralnorm*MT*SwB)/(sw**5*4._/**/REALKIND)
    f( 50) = (eQED**5*integralnorm*SwB)/(sw**4*4._/**/REALKIND)
    f( 51) = (eQED**5*integralnorm*SwB)/(cw**2*sw**4*4._/**/REALKIND)
    f( 52) = (cw**2*eQED**5*integralnorm*SwB)/(sw**4*2._/**/REALKIND)
    f( 53) = (eQED**5*integralnorm*MB*SwB)/(cw**2*sw**4*4._/**/REALKIND)
    f( 54) = (eQED**5*integralnorm*MT*SwB)/(sw**4*8._/**/REALKIND)
    f( 55) = (eQED**5*integralnorm*MT*SwB)/(sw**4*4._/**/REALKIND)
    f( 56) = (eQED**5*integralnorm*MT*SwB)/(sw**4*2._/**/REALKIND)
    f( 57) = (eQED**5*integralnorm*MT*SwB)/(cw**4*sw**4*8._/**/REALKIND)
    f( 58) = (eQED**5*integralnorm*MT*SwB)/(cw**4*sw**4*4._/**/REALKIND)
    f( 59) = (eQED**5*integralnorm*MT*SwB)/(cw**2*sw**4*8._/**/REALKIND)
    f( 60) = (eQED**5*integralnorm*MT*SwB)/(cw**2*sw**4*4._/**/REALKIND)
    f( 61) = (cw**2*eQED**5*integralnorm*MT*SwB)/(sw**4*4._/**/REALKIND)
    f( 62) = (cw**2*eQED**5*integralnorm*MT*SwB)/(sw**4*2._/**/REALKIND)
    f( 63) = (3*eQED**5*integralnorm*lambdaHHH*MH**2*MT*SwB)/(cw**4*sw**4*4._/**/REALKIND)
    f( 64) = (eQED**5*integralnorm*MT**2*SwB)/(cw**4*sw**4*4._/**/REALKIND)
    f( 65) = (eQED**5*integralnorm*MB*SwB)/(cw**2*MW**2*sw**4*4._/**/REALKIND)
    f( 66) = (eQED**5*integralnorm*MH**2*SwB)/(cw**2*MW**2*sw**4*4._/**/REALKIND)
    f( 67) = (eQED**5*integralnorm*MH**2*MT*SwB)/(cw**2*MW**2*sw**4*16._/**/REALKIND)
    f( 68) = (3*eQED**5*integralnorm*lambdaHHH*MH**2*MT*SwB)/(cw**2*MW**2*sw**4*16._/**/REALKIND)
    f( 69) = (eQED**5*integralnorm*MH**4*MT*SwB)/(cw**2*MW**2*sw**4*16._/**/REALKIND)
    f( 70) = (eQED**5*integralnorm*MH**4*MT*SwB)/(cw**2*MW**2*sw**4*8._/**/REALKIND)
    f( 71) = (9*eQED**5*integralnorm*lambdaHHH**2*MH**4*MT*SwB)/(cw**2*MW**2*sw**4*16._/**/REALKIND)
    f( 72) = (eQED**5*integralnorm*MT**2*SwB)/(cw**2*MW**2*sw**4*16._/**/REALKIND)
    f( 73) = (eQED**5*integralnorm*MT**2*SwB)/(cw**2*MW**2*sw**4*8._/**/REALKIND)
    f( 74) = (eQED**5*integralnorm*MH**2*MT**2*SwB)/(cw**2*MW**2*sw**4*8._/**/REALKIND)
    f( 75) = (3*eQED**5*integralnorm*lambdaHHH*MH**2*MT**2*SwB)/(cw**2*MW**2*sw**4*8._/**/REALKIND)
    f( 76) = (eQED**5*integralnorm*MT**3*SwB)/(cw**2*MW**2*sw**4*8._/**/REALKIND)
    f( 77) = (eQED**5*integralnorm*MW**2*SwB)/(cw**2*sw**4*2._/**/REALKIND)
    f( 78) = (eQED**5*integralnorm*MT*MW**2*SwB)/(cw**6*sw**4*8._/**/REALKIND)
    f( 79) = (eQED**5*integralnorm*MT*MW**2*SwB)/(cw**6*sw**4*4._/**/REALKIND)
    f( 80) = (eQED**5*integralnorm*MT*MW**2*SwB)/(cw**6*sw**4*2._/**/REALKIND)
    f( 81) = (eQED**5*integralnorm*MT*MW**2*SwB)/(cw**2*sw**4*8._/**/REALKIND)
    f( 82) = (eQED**5*integralnorm*MT*MW**2*SwB)/(cw**2*sw**4*2._/**/REALKIND)
    f( 83) = (eQED**5*integralnorm*SwB)/(cw*sw**3*4._/**/REALKIND)
    f( 84) = (cw*eQED**5*integralnorm*SwB)/(sw**3*18._/**/REALKIND)
    f( 85) = (cw*eQED**5*integralnorm*SwB)/(sw**3*9._/**/REALKIND)
    f( 86) = (cw*eQED**5*integralnorm*SwB)/(sw**3*6._/**/REALKIND)
    f( 87) = (2*cw*eQED**5*integralnorm*SwB)/(sw**3*9._/**/REALKIND)
    f( 88) = (cw*eQED**5*integralnorm*SwB)/(sw**3*3._/**/REALKIND)
    f( 89) = (cw*eQED**5*integralnorm*SwB)/(sw**3*2._/**/REALKIND)
    f( 90) = (cw**3*eQED**5*integralnorm*SwB)/sw**3
    f( 91) = (cw*eQED**3*gQCD**2*integralnorm*SwB)/(sw**3*2._/**/REALKIND)
    f( 92) = (eQED**5*integralnorm*MT*SwB)/(cw**3*sw**3*4._/**/REALKIND)
    f( 93) = (eQED**5*integralnorm*MT*SwB)/(cw*sw**3*24._/**/REALKIND)
    f( 94) = (eQED**5*integralnorm*MT*SwB)/(cw*sw**3*12._/**/REALKIND)
    f( 95) = (eQED**5*integralnorm*MT*SwB)/(cw*sw**3*8._/**/REALKIND)
    f( 96) = (eQED**5*integralnorm*MT*SwB)/(cw*sw**3*6._/**/REALKIND)
    f( 97) = (cw*eQED**5*integralnorm*MT*SwB)/(sw**3*12._/**/REALKIND)
    f( 98) = (cw*eQED**5*integralnorm*MT*SwB)/(sw**3*6._/**/REALKIND)
    f( 99) = (cw*eQED**5*integralnorm*MT*SwB)/(sw**3*4._/**/REALKIND)
    f(100) = (cw*eQED**5*integralnorm*MT*SwB)/(sw**3*2._/**/REALKIND)
    f(101) = (eQED**5*integralnorm*MH**2*MT*SwB)/(cw*MW**2*sw**3*24._/**/REALKIND)
    f(102) = (eQED**5*integralnorm*MH**2*MT*SwB)/(cw*MW**2*sw**3*8._/**/REALKIND)
    f(103) = (eQED**5*integralnorm*MT**2*SwB)/(cw*MW**2*sw**3*36._/**/REALKIND)
    f(104) = (eQED**5*integralnorm*MT**2*SwB)/(cw*MW**2*sw**3*8._/**/REALKIND)
    f(105) = (eQED**3*gQCD**2*integralnorm*MT**2*SwB)/(cw*MW**2*sw**3*8._/**/REALKIND)
    f(106) = (eQED**5*integralnorm*MW**2*SwB)/(cw*sw**3*2._/**/REALKIND)
    f(107) = (eQED**5*integralnorm*MW**2*SwB)/(cw*sw**3)
    f(108) = (eQED**5*integralnorm*SwB)/(sw**2*18._/**/REALKIND)
    f(109) = (eQED**5*integralnorm*SwB)/(sw**2*9._/**/REALKIND)
    f(110) = (eQED**5*integralnorm*SwB)/(sw**2*6._/**/REALKIND)
    f(111) = (2*eQED**5*integralnorm*SwB)/(sw**2*9._/**/REALKIND)
    f(112) = (eQED**5*integralnorm*SwB)/(sw**2*3._/**/REALKIND)
    f(113) = (eQED**5*integralnorm*SwB)/(sw**2*2._/**/REALKIND)
    f(114) = (eQED**5*integralnorm*SwB)/(cw**2*sw**2*4._/**/REALKIND)
    f(115) = (cw**2*eQED**5*integralnorm*SwB)/(sw**2*3._/**/REALKIND)
    f(116) = (2*cw**2*eQED**5*integralnorm*SwB)/(sw**2*3._/**/REALKIND)
    f(117) = (cw**2*eQED**5*integralnorm*SwB)/sw**2
    f(118) = (eQED**3*gQCD**2*integralnorm*SwB)/(sw**2*2._/**/REALKIND)
    f(119) = (eQED**5*integralnorm*MH**2*SwB)/(cw**2*sw**2*6._/**/REALKIND)
    f(120) = (eQED**5*integralnorm*MH**2*SwB)/(cw**2*sw**2*3._/**/REALKIND)
    f(121) = (eQED**5*integralnorm*MT*SwB)/(sw**2*12._/**/REALKIND)
    f(122) = (eQED**5*integralnorm*MT*SwB)/(sw**2*6._/**/REALKIND)
    f(123) = (eQED**5*integralnorm*MT*SwB)/(sw**2*4._/**/REALKIND)
    f(124) = (eQED**5*integralnorm*MT*SwB)/(cw**2*sw**2*18._/**/REALKIND)
    f(125) = (eQED**5*integralnorm*MT*SwB)/(cw**2*sw**2*9._/**/REALKIND)
    f(126) = (eQED**5*integralnorm*MT*SwB)/(cw**2*sw**2*8._/**/REALKIND)
    f(127) = (2*eQED**5*integralnorm*MT*SwB)/(cw**2*sw**2*9._/**/REALKIND)
    f(128) = (eQED**5*integralnorm*MT*SwB)/(cw**2*sw**2*2._/**/REALKIND)
    f(129) = (eQED**3*gQCD**2*integralnorm*MT*SwB)/(cw**2*sw**2*2._/**/REALKIND)
    f(130) = (eQED**5*integralnorm*SwB)/(MW**2*sw**2*18._/**/REALKIND)
    f(131) = (eQED**5*integralnorm*SwB)/(MW**2*sw**2*9._/**/REALKIND)
    f(132) = (eQED**5*integralnorm*SwB)/(MW**2*sw**2*6._/**/REALKIND)
    f(133) = (eQED**5*integralnorm*SwB)/(MW**2*sw**2*2._/**/REALKIND)
    f(134) = (eQED**3*gQCD**2*integralnorm*SwB)/(MW**2*sw**2*2._/**/REALKIND)
    f(135) = (eQED**5*integralnorm*MH**2*MT*SwB)/(MW**2*sw**2*12._/**/REALKIND)
    f(136) = (eQED**5*integralnorm*MT**2*SwB)/(MW**2*sw**2*18._/**/REALKIND)
    f(137) = (eQED**5*integralnorm*MT**2*SwB)/(MW**2*sw**2*4._/**/REALKIND)
    f(138) = (eQED**3*gQCD**2*integralnorm*MT**2*SwB)/(MW**2*sw**2*4._/**/REALKIND)
    f(139) = (eQED**5*integralnorm*MW**2*SwB)/(cw**4*sw**2)
    f(140) = (eQED**5*integralnorm*MW**2*SwB)/(cw**2*sw**2*6._/**/REALKIND)
    f(141) = (eQED**5*integralnorm*MW**2*SwB)/(cw**2*sw**2*3._/**/REALKIND)
    f(142) = (2*eQED**5*integralnorm*MW**2*SwB)/(cw**2*sw**2*3._/**/REALKIND)
    f(143) = (eQED**5*integralnorm*SwB)/(cw*sw*18._/**/REALKIND)
    f(144) = (eQED**5*integralnorm*SwB)/(cw*sw*9._/**/REALKIND)
    f(145) = (eQED**5*integralnorm*SwB)/(cw*sw*6._/**/REALKIND)
    f(146) = (eQED**5*integralnorm*SwB)/(cw*sw*2._/**/REALKIND)
    f(147) = (2*cw*eQED**5*integralnorm*SwB)/(sw*9._/**/REALKIND)
    f(148) = (cw*eQED**5*integralnorm*SwB)/(sw*3._/**/REALKIND)
    f(149) = (2*cw*eQED**5*integralnorm*SwB)/(sw*3._/**/REALKIND)
    f(150) = (eQED**3*gQCD**2*integralnorm*SwB)/(cw*sw*2._/**/REALKIND)
    f(151) = (eQED**5*integralnorm*MT*SwB)/(cw*sw*12._/**/REALKIND)
    f(152) = (eQED**5*integralnorm*MT*SwB)/(cw*sw*4._/**/REALKIND)
    f(153) = (eQED**5*integralnorm*MH**2*MT*SwB)/(cw*sw*12._/**/REALKIND)
    f(154) = (eQED**5*integralnorm*MW**2*SwB)/(cw**3*sw*2._/**/REALKIND)
    f(155) = (eQED**5*integralnorm*MW**2*SwB)/(cw*sw*6._/**/REALKIND)
    f(156) = (eQED**5*integralnorm*MW**2*SwB)/(cw*sw*3._/**/REALKIND)
    f(157) = (2*cw*eQED**5*integralnorm*MW**2*SwB)/(sw*9._/**/REALKIND)
    f(158) = (eQED**5*integralnorm*MT*MW**2*SwB)/(cw**3*sw*6._/**/REALKIND)
    f(159) = (eQED**5*integralnorm*MT*MW**2*SwB)/(cw*sw*6._/**/REALKIND)
    f(160) = (2*eQED**5*integralnorm*MW**2*sw*SwB)/(cw*9._/**/REALKIND)
    f(161) = (eQED**5*integralnorm*MW**2*sw*SwB)/(cw*3._/**/REALKIND)
    f(162) = (2*eQED**5*integralnorm*MW**2*sw*SwB)/(cw*3._/**/REALKIND)
    f(163) = (eQED**5*integralnorm*MW**2*sw*SwB)/cw
    f(164) = (eQED**5*integralnorm*MW**2*sw**2*SwB)/(cw**2*3._/**/REALKIND)
    f(165) = (2*eQED**5*integralnorm*MW**2*sw**2*SwB)/(cw**2*3._/**/REALKIND)
    f(166) = (eQED**5*integralnorm*MW**2*sw**2*SwB)/cw**2
    f(167) = (eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw**2*sw**2*4._/**/REALKIND)
    f(168) = (eQED**5*integralnorm*MT*(cw - sw)*(cw + sw)*SwB)/(cw**2*sw**2*8._/**/REALKIND)
    f(169) = -((eQED**5*integralnorm*MT*SwB*(cw**4*4._/**/REALKIND + sw**4*4._/**/REALKIND  &
      - cw**2*sw**2*8._/**/REALKIND))/(cw**4*sw**4*4._/**/REALKIND*8._/**/REALKIND))
    f(170) = -((eQED**5*integralnorm*SwB*(cw**4*4._/**/REALKIND + sw**4*4._/**/REALKIND  &
      - cw**2*sw**2*8._/**/REALKIND))/(cw**2*MW**2*sw**4*4._/**/REALKIND*8._/**/REALKIND))
    f(171) = -((eQED**5*integralnorm*SwB*(cw**4*2._/**/REALKIND + sw**4*2._/**/REALKIND  &
      - cw**2*sw**2*4._/**/REALKIND))/(cw**2*MW**2*sw**4*2._/**/REALKIND*4._/**/REALKIND))
    f(172) = -((eQED**5*integralnorm*MH**2*MT*SwB*(-(cw**2*sw**2*16._/**/REALKIND) + cw**4*8._/**/REALKIND  &
      + sw**4*8._/**/REALKIND))/(cw**2*MW**2*sw**4*16._/**/REALKIND*8._/**/REALKIND))
    f(173) = -((eQED**5*integralnorm*MH**2*MT*SwB*(cw**4*4._/**/REALKIND + sw**4*4._/**/REALKIND  &
      - cw**2*sw**2*8._/**/REALKIND))/(cw**2*MW**2*sw**4*4._/**/REALKIND*8._/**/REALKIND))
    f(174) = (eQED**5*integralnorm*MH**2*MT*(-cw + sw)*(cw + sw)*SwB)/(cw**2*MW**2*sw**4*16._/**/REALKIND)
    f(175) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*sw**3*12._/**/REALKIND))
    f(176) = -((eQED**5*integralnorm*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw**3*sw**3*4._/**/REALKIND))
    f(177) = -((eQED**5*integralnorm*MT*(cw - sw)*(cw + sw)*SwB)/(cw**3*sw**3*12._/**/REALKIND))
    f(178) = -((eQED**5*integralnorm*MT*(cw - sw)*(cw + sw)*SwB)/(cw*sw**3*24._/**/REALKIND))
    f(179) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*MW**2*sw**3*36._/**/REALKIND))
    f(180) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*MW**2*sw**3*18._/**/REALKIND))
    f(181) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*MW**2*sw**3*12._/**/REALKIND))
    f(182) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*MW**2*sw**3*6._/**/REALKIND))
    f(183) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*MW**2*sw**3*4._/**/REALKIND))
    f(184) = -((eQED**3*gQCD**2*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*MW**2*sw**3*4._/**/REALKIND))
    f(185) = -((eQED**5*integralnorm*MH**2*MT*(cw - sw)*(cw + sw)*SwB)/(cw*MW**2*sw**3*24._/**/REALKIND))
    f(186) = -((eQED**5*integralnorm*MH**2*MT*(cw - sw)*(cw + sw)*SwB)/(cw*MW**2*sw**3*12._/**/REALKIND))
    f(187) = -((eQED**5*integralnorm*MH**2*MT*(cw - sw)*(cw + sw)*SwB)/(cw*MW**2*sw**3*8._/**/REALKIND))
    f(188) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*sw*9._/**/REALKIND))
    f(189) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*sw*6._/**/REALKIND))
    f(190) = (-2*eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*sw*9._/**/REALKIND)
    f(191) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*sw*3._/**/REALKIND))
    f(192) = -((eQED**5*integralnorm*MW**2*(cw - sw)*(cw + sw)*SwB)/(cw*sw*9._/**/REALKIND))
    f(193) = (eQED**5*integralnorm*SwB*(-(cw**2*sw**2*12._/**/REALKIND) + cw**4*6._/**/REALKIND  &
      + sw**4*6._/**/REALKIND))/(cw**2*sw**2*12._/**/REALKIND*6._/**/REALKIND)
    f(194) = (eQED**5*integralnorm*SwB*(cw**4*3._/**/REALKIND + sw**4*3._/**/REALKIND  &
      - cw**2*sw**2*6._/**/REALKIND))/(cw**2*sw**2*3._/**/REALKIND*6._/**/REALKIND)
    f(195) = (eQED**5*integralnorm*SwB*(cw**4*2._/**/REALKIND + sw**4*2._/**/REALKIND  &
      - cw**2*sw**2*4._/**/REALKIND))/(cw**2*sw**2*2._/**/REALKIND*4._/**/REALKIND)
    f(196) = (eQED**5*integralnorm*(cw - sw)**2*(cw + sw)**2*SwB)/(cw**2*sw**2*3._/**/REALKIND)
    f(197) = -((eQED**5*integralnorm*MW**2*(cw - sw)*(cw + sw)*SwB)/(cw**2*6._/**/REALKIND))
    f(198) = -((eQED**5*integralnorm*MW**2*(cw - sw)*(cw + sw)*SwB)/(cw**2*3._/**/REALKIND))
    f(199) = -((eQED**5*integralnorm*(cw - sw)**3*(cw + sw)**3*SwB)/(cw**3*sw**3*8._/**/REALKIND))
    f(200) = -((eQED**5*integralnorm*(cw - sw)**3*(cw + sw)**3*SwB)/(cw**3*sw**3*4._/**/REALKIND))
    f(201) = -((eQED**5*integralnorm*MW**2*(cw - sw)*sw*(cw + sw)*SwB)/(cw**3*2._/**/REALKIND))
    f(202) = (2*eQED**5*integralnorm*SwF)/81._/**/REALKIND
    f(203) = (4*eQED**5*integralnorm*SwF)/81._/**/REALKIND
    f(204) = (8*eQED**5*integralnorm*SwF)/81._/**/REALKIND
    f(205) = (eQED**5*integralnorm*SwF)/9._/**/REALKIND
    f(206) = (16*eQED**5*integralnorm*SwF)/81._/**/REALKIND
    f(207) = (2*eQED**5*integralnorm*SwF)/9._/**/REALKIND
    f(208) = (eQED**5*integralnorm*SwF)/3._/**/REALKIND
    f(209) = (4*eQED**5*integralnorm*SwF)/9._/**/REALKIND
    f(210) = (2*eQED**5*integralnorm*SwF)/3._/**/REALKIND
    f(211) = (8*eQED**5*integralnorm*SwF)/9._/**/REALKIND
    f(212) = eQED**5*integralnorm*SwF
    f(213) = 2*eQED**5*integralnorm*SwF
    f(214) = 3*eQED**5*integralnorm*SwF
    f(215) = (eQED**5*integralnorm*MB**2*MT*SwF)/(cw**2*MW**2*sw**4*8._/**/REALKIND)
    f(216) = (eQED**5*integralnorm*ME**2*MT*SwF)/(cw**2*MW**2*sw**4*8._/**/REALKIND)
    f(217) = (eQED**5*integralnorm*ML**2*MT*SwF)/(cw**2*MW**2*sw**4*8._/**/REALKIND)
    f(218) = (eQED**5*integralnorm*MM**2*MT*SwF)/(cw**2*MW**2*sw**4*8._/**/REALKIND)
    f(219) = (eQED**5*integralnorm*MT**3*SwF)/(cw**2*MW**2*sw**4*8._/**/REALKIND)
    f(220) = (eQED**5*integralnorm*MB*MT*SwF)/(cw*MW**2*sw**3*72._/**/REALKIND)
    f(221) = (eQED**5*integralnorm*MB*MT*SwF)/(cw*MW**2*sw**3*8._/**/REALKIND)
    f(222) = (eQED**5*integralnorm*ME*MT*SwF)/(cw*MW**2*sw**3*24._/**/REALKIND)
    f(223) = (eQED**5*integralnorm*ME*MT*SwF)/(cw*MW**2*sw**3*8._/**/REALKIND)
    f(224) = (eQED**5*integralnorm*ML*MT*SwF)/(cw*MW**2*sw**3*24._/**/REALKIND)
    f(225) = (eQED**5*integralnorm*ML*MT*SwF)/(cw*MW**2*sw**3*8._/**/REALKIND)
    f(226) = (eQED**5*integralnorm*MM*MT*SwF)/(cw*MW**2*sw**3*24._/**/REALKIND)
    f(227) = (eQED**5*integralnorm*MM*MT*SwF)/(cw*MW**2*sw**3*8._/**/REALKIND)
    f(228) = (eQED**5*integralnorm*MT**2*SwF)/(cw*MW**2*sw**3*36._/**/REALKIND)
    f(229) = (eQED**5*integralnorm*MT**2*SwF)/(cw*MW**2*sw**3*8._/**/REALKIND)
    f(230) = (eQED**5*integralnorm*MB*SwF)/(cw**2*sw**2*18._/**/REALKIND)
    f(231) = (eQED**5*integralnorm*MB*SwF)/(cw**2*sw**2*9._/**/REALKIND)
    f(232) = (eQED**5*integralnorm*MB*SwF)/(cw**2*sw**2*2._/**/REALKIND)
    f(233) = (eQED**5*integralnorm*ME*SwF)/(cw**2*sw**2*6._/**/REALKIND)
    f(234) = (eQED**5*integralnorm*ME*SwF)/(cw**2*sw**2*3._/**/REALKIND)
    f(235) = (eQED**5*integralnorm*ME*SwF)/(cw**2*sw**2*2._/**/REALKIND)
    f(236) = (eQED**5*integralnorm*ML*SwF)/(cw**2*sw**2*6._/**/REALKIND)
    f(237) = (eQED**5*integralnorm*ML*SwF)/(cw**2*sw**2*3._/**/REALKIND)
    f(238) = (eQED**5*integralnorm*ML*SwF)/(cw**2*sw**2*2._/**/REALKIND)
    f(239) = (eQED**5*integralnorm*MM*SwF)/(cw**2*sw**2*6._/**/REALKIND)
    f(240) = (eQED**5*integralnorm*MM*SwF)/(cw**2*sw**2*3._/**/REALKIND)
    f(241) = (eQED**5*integralnorm*MM*SwF)/(cw**2*sw**2*2._/**/REALKIND)
    f(242) = (eQED**5*integralnorm*MT*SwF)/(cw**2*sw**2*18._/**/REALKIND)
    f(243) = (eQED**5*integralnorm*MT*SwF)/(cw**2*sw**2*9._/**/REALKIND)
    f(244) = (eQED**5*integralnorm*MT*SwF)/(cw**2*sw**2*6._/**/REALKIND)
    f(245) = (2*eQED**5*integralnorm*MT*SwF)/(cw**2*sw**2*9._/**/REALKIND)
    f(246) = (eQED**5*integralnorm*MT*SwF)/(cw**2*sw**2*2._/**/REALKIND)
    f(247) = (eQED**5*integralnorm*MT*SwF)/(cw**2*sw**2)
    f(248) = (3*eQED**5*integralnorm*MT*SwF)/(cw**2*sw**2*2._/**/REALKIND)
    f(249) = (eQED**5*integralnorm*MB*MT*SwF)/(MW**2*sw**2*36._/**/REALKIND)
    f(250) = (eQED**5*integralnorm*MB*MT*SwF)/(MW**2*sw**2*4._/**/REALKIND)
    f(251) = (eQED**5*integralnorm*ME*MT*SwF)/(MW**2*sw**2*12._/**/REALKIND)
    f(252) = (eQED**5*integralnorm*ME*MT*SwF)/(MW**2*sw**2*4._/**/REALKIND)
    f(253) = (eQED**5*integralnorm*ML*MT*SwF)/(MW**2*sw**2*12._/**/REALKIND)
    f(254) = (eQED**5*integralnorm*ML*MT*SwF)/(MW**2*sw**2*4._/**/REALKIND)
    f(255) = (eQED**5*integralnorm*MM*MT*SwF)/(MW**2*sw**2*12._/**/REALKIND)
    f(256) = (eQED**5*integralnorm*MM*MT*SwF)/(MW**2*sw**2*4._/**/REALKIND)
    f(257) = (eQED**5*integralnorm*MT**2*SwF)/(MW**2*sw**2*18._/**/REALKIND)
    f(258) = (eQED**5*integralnorm*MT**2*SwF)/(MW**2*sw**2*4._/**/REALKIND)

  c = [ 6*f(26), 6*f(27), 6*f(28), 6*f(29), 6*f(30), 6*f(31), 6*f(32), 6*f(33), f(34), 3*f(34), f(35), 3*f(35), 8*f(35), f(36) &
    , 3*f(36), f(37), 3*f(37), 8*f(37), 6*f(38), 6*f(39), 6*f(40), 6*f(41), 6*f(42), 6*f(43), 6*f(44), 6*f(45), 6*f(46), 6*f(47) &
    , 6*f(48), 6*f(49), 6*f(50), 6*f(51), 6*f(52), 6*f(53), 6*f(54), 6*f(55), 6*f(56), 6*f(57), 6*f(58), 6*f(59), 6*f(60), 6*f(61) &
    , 6*f(62), 6*f(63), 6*f(64), 6*f(65), 6*f(66), 6*f(67), 6*f(68), 6*f(69), 6*f(70), 6*f(71), 6*f(72), 6*f(73), 6*f(74), 6*f(75) &
    , 6*f(76), 6*f(77), 6*f(78), 6*f(79), 6*f(80), 6*f(81), 6*f(82), 6*f(83), 6*f(84), 6*f(85), 6*f(86), 6*f(87), 6*f(88), 6*f(89) &
    , 6*f(90), f(91), 3*f(91), 6*f(92), 6*f(93), 6*f(94), 6*f(95), 6*f(96), 6*f(97), 6*f(98), 6*f(99), 6*f(100), 6*f(101) &
    , 6*f(102), 6*f(103), 6*f(104), f(105), 3*f(105), 6*f(106), 6*f(107), 6*f(108), 6*f(109), 6*f(110), 6*f(111), 6*f(112) &
    , 6*f(113), 6*f(114), 6*f(115), 6*f(116), 6*f(117), f(118), 3*f(118), 6*f(119), 6*f(120), 6*f(121), 6*f(122), 6*f(123) &
    , 6*f(124), 6*f(125), 6*f(126), 6*f(127), 6*f(128), f(129), 3*f(129), 8*f(129), 6*f(130), 6*f(131), 6*f(132), 6*f(133), f(134) &
    , 3*f(134), 6*f(135), 6*f(136), 6*f(137), f(138), 3*f(138), 6*f(139), 6*f(140), 6*f(141), 6*f(142), 6*f(143), 6*f(144) &
    , 6*f(145), 6*f(146), 6*f(147), 6*f(148), 6*f(149), f(150), 3*f(150), 6*f(151), 6*f(152), 6*f(153), 6*f(154), 6*f(155) &
    , 6*f(156), 6*f(157), 6*f(158), 6*f(159), 6*f(160), 6*f(161), 6*f(162), 6*f(163), 6*f(164), 6*f(165), 6*f(166), 6*f(167) &
    , 6*f(168), 6*f(169), 6*f(170), 6*f(171), 6*f(172), 6*f(173), 6*f(174), 6*f(175), 6*f(176), 6*f(177), 6*f(178), 6*f(179) &
    , 6*f(180), 6*f(181), 6*f(182), 6*f(183), f(184), 3*f(184), 6*f(185), 6*f(186), 6*f(187), 6*f(188), 6*f(189), 6*f(190) &
    , 6*f(191), 6*f(192), 6*f(193), 6*f(194), 6*f(195), 6*f(196), 6*f(197), 6*f(198), 6*f(199), 6*f(200), 6*f(201), 18*f(202) &
    , 18*f(203), 18*f(204), 18*f(205), 18*f(206), 6*f(207), 18*f(207), 6*f(208), 18*f(209), 6*f(210), 18*f(211), 6*f(212) &
    , 18*f(212), 18*f(213), 6*f(214), 18*f(215), 6*f(216), 6*f(217), 6*f(218), 18*f(219), 18*f(220), 18*f(221), 6*f(222), 6*f(223) &
    , 6*f(224), 6*f(225), 6*f(226), 6*f(227), 18*f(228), 18*f(229), 18*f(230), 18*f(231), 18*f(232), 6*f(233), 6*f(234), 6*f(235) &
    , 6*f(236), 6*f(237), 6*f(238), 6*f(239), 6*f(240), 6*f(241), 18*f(242), 18*f(243), 6*f(244), 18*f(245), 6*f(246), 18*f(246) &
    , 18*f(247), 6*f(248), 18*f(249), 18*f(250), 6*f(251), 6*f(252), 6*f(253), 6*f(254), 6*f(255), 6*f(256), 18*f(257) &
    , 18*f(258) ]
  c = (1._/**/REALKIND / 6) * c
end subroutine fac_init_loop

subroutine denominators()
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_momenta_decl_/**/REALKIND, only: L
  implicit none
  ! propagators
  den(1) = 1 /((L(5,3) - MH2)+L(6,3))
  den(2) = 1 /((L(5,12) - MZ2)+L(6,12))
  den(4) = 1 /((L(5,3))+L(6,3))
  den(5) = 1 /((L(5,20))+L(6,20))
  den(7) = 1 /((L(5,3) - MZ2)+L(6,3))
  den(9) = 1 /((L(5,24))+L(6,24))
  den(12) = 1 /((L(5,17) - MT2)+L(6,17))
  den(13) = 1 /((L(5,12))+L(6,12))
  den(16) = 1 /((L(5,18) - MT2)+L(6,18))
  den(20) = 1 /((L(5,28) - MH2)+L(6,28))
  den(23) = 1 /((L(5,19) - MZ2)+L(6,19))
  den(27) = 1 /((L(5,28))+L(6,28))
  den(30) = 1 /((L(5,28) - MZ2)+L(6,28))
  den(35) = 1 /((L(5,11))+L(6,11))
  den(46) = 1 /((L(5,7))+L(6,7))
  den(51) = 1 /((L(5,14) - MT2)+L(6,14))
  den(59) = 1 /((L(5,19))+L(6,19))
  den(63) = 1 /((L(5,13) - MT2)+L(6,13))
  den(74) = 1 /((L(5,19) - MH2)+L(6,19))

  ! denominators
  den(3) = den(1)*den(2)
  den(6) = den(4)*den(5)
  den(8) = den(5)*den(7)
  den(10) = den(4)*den(9)
  den(11) = den(7)*den(9)
  den(14) = den(12)*den(13)
  den(15) = den(2)*den(12)
  den(17) = den(13)*den(16)
  den(18) = den(2)*den(16)
  den(19) = den(1)*den(13)
  den(21) = den(2)*den(20)
  den(22) = den(1)*den(21)
  den(24) = den(1)*den(23)
  den(25) = den(13)*den(24)
  den(26) = den(2)*den(24)
  den(28) = den(5)*den(27)
  den(29) = den(7)*den(28)
  den(31) = den(5)*den(30)
  den(32) = den(7)*den(31)
  den(33) = den(4)*den(28)
  den(34) = den(4)*den(31)
  den(36) = den(4)*den(35)
  den(37) = den(5)*den(36)
  den(38) = den(7)*den(35)
  den(39) = den(5)*den(38)
  den(40) = den(9)*den(27)
  den(41) = den(7)*den(40)
  den(42) = den(9)*den(30)
  den(43) = den(7)*den(42)
  den(44) = den(4)*den(40)
  den(45) = den(4)*den(42)
  den(47) = den(4)*den(46)
  den(48) = den(9)*den(47)
  den(49) = den(7)*den(46)
  den(50) = den(9)*den(49)
  den(52) = den(13)*den(51)
  den(53) = den(12)*den(52)
  den(54) = den(2)*den(51)
  den(55) = den(12)*den(54)
  den(56) = den(12)*den(23)
  den(57) = den(13)*den(56)
  den(58) = den(2)*den(56)
  den(60) = den(12)*den(59)
  den(61) = den(13)*den(60)
  den(62) = den(2)*den(60)
  den(64) = den(13)*den(63)
  den(65) = den(16)*den(64)
  den(66) = den(2)*den(63)
  den(67) = den(16)*den(66)
  den(68) = den(16)*den(23)
  den(69) = den(13)*den(68)
  den(70) = den(2)*den(68)
  den(71) = den(16)*den(59)
  den(72) = den(13)*den(71)
  den(73) = den(2)*den(71)
  den(75) = den(7)*den(74)
  den(76) = den(12)*den(74)
  den(77) = den(16)*den(74)
  den(78) = den(7)*den(13)
  den(79) = den(2)*den(7)
  den(80) = den(4)*den(13)
  den(81) = den(2)*den(4)
  den(82) = den(1)*den(5)
  den(83) = den(1)*den(9)
  den(84) = den(13)*den(75)
  den(85) = den(2)*den(75)
  den(86) = den(7)*den(21)
  den(87) = den(4)*den(21)
  den(88) = den(1)*den(28)
  den(89) = den(1)*den(31)
  den(90) = den(1)*den(40)
  den(91) = den(1)*den(42)
  den(92) = den(13)*den(76)
  den(93) = den(2)*den(76)
  den(94) = den(13)*den(77)
  den(95) = den(2)*den(77)

end subroutine denominators

#ifdef PRECISION_dp
! **********************************************************************
subroutine init_merging_tables(tot_num_hels, tot_num_merge_steps)
!-----------------------------------------------------------------------
! In the first event the merging tables are fully initialised
! **********************************************************************
  implicit none
  integer, intent(in) :: tot_num_hels, tot_num_merge_steps
  n_merge_steps = tot_num_merge_steps
  allocate(merge_tables(tot_num_hels,2,n_merge_steps))
  allocate(merge_mism(n_merge_steps+1))
  allocate(merge_hels(n_merge_steps))
  merge_tables_on = .true.
  merge_mism = 0_intkind2
  merge_tables = -1_intkind2
  merge_hels = -1_intkind2
end subroutine init_merging_tables

! **********************************************************************
subroutine update_merging_tables(tot_num_hels)
!-----------------------------------------------------------------------
! After the first evaluation the merging tables are adapted
! **********************************************************************
  implicit none
  integer, intent(in) :: tot_num_hels
  integer(intkind2), allocatable ::  merge_tables_tmp(:,:,:), merge_hels_tmp(:)

  if(merge_mism(1) == 0) then ! helicity configurations match in all merging steps
    if(allocated(merge_tables)) deallocate(merge_tables)
    if(allocated(merge_hels)) deallocate(merge_hels)
    if(allocated(merge_mism)) deallocate(merge_mism)
    allocate(merge_mism(1))
    allocate(merge_hels(1))
    allocate(merge_tables(1,1,1)) ! dummy allocation
    merge_mism = 0_intkind2
    merge_tables = -1_intkind2
    merge_hels = -1_intkind2
  else
    n_merge_mism = merge_mism(1)
    allocate(merge_tables_tmp(tot_num_hels,2,n_merge_mism))
    merge_tables_tmp(:,:,1:n_merge_mism) = merge_tables(:,:,1:n_merge_mism)
    if(allocated(merge_tables)) then
      deallocate(merge_tables)
      allocate(merge_tables(tot_num_hels,2,n_merge_mism))
    end if
    merge_tables = merge_tables_tmp
    if(allocated(merge_tables_tmp)) deallocate(merge_tables_tmp)
    allocate(merge_hels_tmp(n_merge_mism))
    merge_hels_tmp(1:n_merge_mism) = merge_hels(1:n_merge_mism)
    if(allocated(merge_hels)) then
      deallocate(merge_hels)
      allocate(merge_hels(n_merge_mism))
    end if
    merge_hels = merge_hels_tmp
    if(allocated(merge_hels_tmp)) deallocate(merge_hels_tmp)
  end if
  merge_tables_on = .true.
end subroutine update_merging_tables
#endif


!
!
!
! **********************************************************************
#ifdef PRECISION_dp
subroutine amp2(P_scatt, M02, M2ct, M2colint, qp_kinematics)
#else
subroutine amp2(P_scatt, M02, M2ct, M2colint, qp_kinematics)
  use ol_loop_storage_ppztt_ew_ttxddxz_3_/**/DREALKIND, only: ntry, nhel, Hel
#endif
! P_scatt(0:3,Npart) = incoming external momenta
! M2  = helicity-summed squared matrix element for top anti-top down anti-down Z -> 0
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND !, only: ci, parameters_status, ZERO, scalefactor, >masses<
  use ol_parameters_init_/**/REALKIND, only: ensure_mp_init
  use ol_kinematics_/**/REALKIND, only: init_kinematics
  use ol_momenta_decl_/**/DREALKIND, only: momenta_nan_check
  use ol_data_types_/**/REALKIND
  use ol_h_helicity_bookkeeping_/**/REALKIND, only: &
    & helbookkeeping_wf, helsync, flip_phase
  use ol_helicity_init, only: helbookkeeping_flip, helsync_flip
  use ol_hel_propagators_/**/REALKIND
  use ol_hel_wavefunctions_/**/REALKIND
  use ol_wavefunctions_/**/REALKIND, only: wf_V_Std
  use ol_hel_vertices_/**/REALKIND
  use ol_hel_contractions_/**/REALKIND
  use ol_external_ppztt_ew_ttxddxz_3, only: external_perm_ppztt_ew_ttxddxz_3, &
    & external_perm_inv_ppztt_ew_ttxddxz_3, extcomb_perm_ppztt_ew_ttxddxz_3, &
    & average_factor_ppztt_ew_ttxddxz_3, photonid_ppztt_ew_ttxddxz_3
  use ol_ew_renormalisation_/**/REALKIND, only: photon_factors
  use ol_external_ppztt_ew_ttxddxz_3, only: H, hel_not_initialised, hel_init, POLSEL
  use ol_colourmatrix_ppztt_ew_ttxddxz_3_/**/REALKIND, only: colmat_not_initialised, colourmatrix_init
  use ol_forced_parameters_ppztt_ew_ttxddxz_3_/**/REALKIND, only: check_forced_parameters
  use ol_heltables_OLR_ppztt_ew_ttxddxz_3
  use ol_kinematics_/**/REALKIND, only: LC2Std_Rep_cmplx
  use ol_h_counterterms_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND ! counterterms
  use ol_loop_parameters_decl_/**/DREALKIND, only: IR_is_on
  use ol_init, only: set_parameter, parameters_flush
#ifdef PRECISION_dp
  use ol_kinematics_/**/QREALKIND, only: conv_mom_scatt2in_qp=>conv_mom_scatt2in, &
                                         internal_momenta_qp=>internal_momenta
  use ol_momenta_decl_/**/DREALKIND, only: L
  use ol_momenta_decl_/**/QREALKIND, only: L_qp=>L
#endif
  implicit none

  real(DREALKIND), intent(in)  :: P_scatt(0:3,5)
  real(REALKIND),  intent(out) :: M02, M2ct, M2colint(16)
  logical, intent(in) :: qp_kinematics

  integer           :: shift, k, r, m, n, i
  real(REALKIND)    :: P(0:3,5)
#ifdef PRECISION_dp
  real(QREALKIND)    :: P_qp(0:3,5)
#endif
  integer           :: extmasses2(5)
  real(REALKIND)    :: M2add, M2add_ct, M2add_colint(16)
  complex(REALKIND) :: M1(3), M2(3)
  real(REALKIND)    :: P_scatt_intern(0:3,5)
  real(REALKIND), save :: scalebackfactor, old_scalefactor = 0
  real(REALKIND)       :: bornphotonfactor
  integer(intkind1) :: nsync
  type(Hpolcont),   save :: M1helarray(3,48)
  type(Hpolcont) :: M1helarray_ct(3,48)
  integer, allocatable :: extcombs_permuted(:)
  integer              :: extcombs(16), nextcombs
#if 5 > 3
  integer :: ind_cc_comb(5)
#endif
  type(Hpolcont) :: A(48,128)

  !Aj are not used at the moment
  !complex(REALKIND) :: Aj(128)

  complex(REALKIND) :: omega(2) ! phases for helicity correlations

  call set_parameter("ew_renorm", 1)
  call parameters_flush()
  call ensure_mp_init()

  if (colmat_not_initialised) call colourmatrix_init()

  if (fac_status_loop1 /= parameters_status .or. fac_status_loop2 /= loop_parameters_status) then
    ! Note: if fac_init would only be called when parameters changed which are relevant for the factors,
    ! a different 'status' would have to be used, because forced_parameters should be called after every parameter change.
    call check_forced_parameters()
    call fac_init_loop()
  end if

  if (momenta_nan_check(P_scatt) /= 0) then
    M02 = 0
    return
  end if

  extmasses2 = [ nMT, nMT, 0, 0, nMZ ]
  ! Convert 2 -> n-2 PS-point to n -> 0 (so that P(1) + ... + P(n) = 0) and compute
  ! internal-propagator momenta in light-cone representation
  call init_kinematics(P_scatt, extmasses2, P, external_perm_inv_ppztt_ew_ttxddxz_3, 5, qp_kinematics)

  ! denominators
  call denominators()

   if (heltables_not_init) call init_heltables()

  ! external WFs
  ! Here the external wavefunctions are initialiased
  call pol_wf_Q(P(:,1), rMT, H1, ex1, POLSEL(1),1)
  call pol_wf_A(P(:,2), rMT, H2, ex2, POLSEL(2),2)
  call pol_wf_Q(P(:,3), rZERO, H3, ex3, POLSEL(3),3)
  call pol_wf_A(P(:,4), rZERO, H4, ex4, POLSEL(4),4)
  call pol_wf_V(P(:,5), rMZ, H5, ex5, POLSEL(5),5)



  ! internal WFs
  ! e.g. call vert_VQ_A(ntry, ex3, ex1, wf1, n1, t1) ...
  call vert_AQ_S(gH,ntry, ex2(:), ex1(:), wf4(:,1), n3(:,1), t3x4(:,:,1))
  call vert_QA_Z(gZd,ntry, ex3(:), ex4(:), wf4(:,2), n3(:,2), t3x4(:,:,2))
  call vert_SV_V(ntry, wf4(:,1), ex5(:), wf12(:,1), n3(:,3), t3x12(:,:,1))
  call vert_QA_V(ntry, ex1(:), ex2(:), wf4(:,3), n3(:,4), t3x4(:,:,3))
  call vert_ZQ_A(gZd,ntry, ex5(:), ex3(:), wf6(:,1), n3(:,5), t3x6(:,:,1))
  call prop_Q_A(ntry, wf6(:,1), 20, ZERO, 0_intkind1, wf6(:,2), n2(1))
  call vert_AV_Q(ntry, ex4(:), wf4(:,3), wf8(:,1), n3(:,6), t3x8(:,:,1))
  call vert_QA_Z(gZu,ntry, ex1(:), ex2(:), wf4(:,4), n3(:,7), t3x4(:,:,4))
  call vert_AZ_Q(gZd,ntry, ex4(:), wf4(:,4), wf8(:,2), n3(:,8), t3x8(:,:,2))
  call vert_AZ_Q(gZd,ntry, ex4(:), ex5(:), wf6(:,3), n3(:,9), t3x6(:,:,2))
  call prop_A_Q(ntry, wf6(:,3), 24, ZERO, 0_intkind1, wf6(:,4), n2(2))
  call vert_VQ_A(ntry, wf4(:,3), ex3(:), wf8(:,3), n3(:,10), t3x8(:,:,3))
  call vert_ZQ_A(gZd,ntry, wf4(:,4), ex3(:), wf8(:,4), n3(:,11), t3x8(:,:,4))
  call vert_ZQ_A(gZu,ntry, ex5(:), ex1(:), wf6(:,5), n3(:,12), t3x6(:,:,3))
  call vert_QA_V(ntry, ex3(:), ex4(:), wf4(:,5), n3(:,13), t3x4(:,:,5))
  call prop_Q_A(ntry, wf6(:,5), 17, MT, 1_intkind1, wf6(:,6), n2(3))
  call vert_QA_V(ntry, wf6(:,6), ex2(:), wf12(:,2), n3(:,14), t3x12(:,:,2))
  call vert_QA_Z(gZu,ntry, wf6(:,6), ex2(:), wf12(:,3), n3(:,15), t3x12(:,:,3))
  call vert_AZ_Q(gZu,ntry, ex2(:), ex5(:), wf6(:,7), n3(:,16), t3x6(:,:,4))
  call prop_A_Q(ntry, wf6(:,7), 18, MT, 1_intkind1, wf6(:,8), n2(4))
  call vert_QA_V(ntry, ex1(:), wf6(:,8), wf12(:,4), n3(:,17), t3x12(:,:,4))
  call vert_QA_Z(gZu,ntry, ex1(:), wf6(:,8), wf12(:,5), n3(:,18), t3x12(:,:,5))
  call counter_SV_V(ntry, wf4(:,1), ex5(:), wf12(:,6), n3(:,19), t3x12(:,:,6))
  call counter_AV_Q(ntry, ex4(:), wf4(:,3), wf8(:,5), n3(:,20), t3x8(:,:,5))
  call counter_AV_Q_LR(EWctAdd,ntry, ex4(:), wf4(:,3), wf8(:,6), n3(:,21), t3x8(:,:,6))
  call counter_AZ_Q(gZd,ntry, ex4(:), wf4(:,4), wf8(:,7), n3(:,22), t3x8(:,:,7))
  call counter_AZ_Q(EWctVdd,ntry, ex4(:), wf4(:,4), wf8(:,8), n3(:,23), t3x8(:,:,8))
  call counter_AV_Q_LR(EWctGdd,ntry, ex4(:), wf4(:,3), wf8(:,9), n3(:,24), t3x8(:,:,9))
  call counter_AZ_Q(gZd,ntry, ex4(:), ex5(:), wf6(:,9), n3(:,25), t3x6(:,:,5))
  call prop_A_Q(ntry, wf6(:,9), 24, ZERO, 0_intkind1, wf6(:,10), n2(5))
  call counter_AZ_Q(EWctVdd,ntry, ex4(:), ex5(:), wf6(:,11), n3(:,26), t3x6(:,:,6))
  call prop_A_Q(ntry, wf6(:,11), 24, ZERO, 0_intkind1, wf6(:,12), n2(6))
  call counter_VQ_A(ntry, wf4(:,3), ex3(:), wf8(:,10), n3(:,27), t3x8(:,:,10))
  call counter_VQ_A_LR(EWctAdd,ntry, wf4(:,3), ex3(:), wf8(:,11), n3(:,28), t3x8(:,:,11))
  call counter_ZQ_A(gZd,ntry, wf4(:,4), ex3(:), wf8(:,12), n3(:,29), t3x8(:,:,12))
  call counter_ZQ_A(EWctVdd,ntry, wf4(:,4), ex3(:), wf8(:,13), n3(:,30), t3x8(:,:,13))
  call counter_VQ_A_LR(EWctGdd,ntry, wf4(:,3), ex3(:), wf8(:,14), n3(:,31), t3x8(:,:,14))
  call counter_ZQ_A(gZd,ntry, ex5(:), ex3(:), wf6(:,13), n3(:,32), t3x6(:,:,7))
  call prop_Q_A(ntry, wf6(:,13), 20, ZERO, 0_intkind1, wf6(:,14), n2(7))
  call counter_ZQ_A(EWctVdd,ntry, ex5(:), ex3(:), wf6(:,15), n3(:,33), t3x6(:,:,8))
  call prop_Q_A(ntry, wf6(:,15), 20, ZERO, 0_intkind1, wf6(:,16), n2(8))
  call counter_QA_Z(gZd,ntry, ex3(:), ex4(:), wf4(:,6), n3(:,34), t3x4(:,:,6))
  call counter_QA_Z(EWctVdd,ntry, ex3(:), ex4(:), wf4(:,7), n3(:,35), t3x4(:,:,7))
  call counter_QA_V(ntry, ex3(:), ex4(:), wf4(:,8), n3(:,36), t3x4(:,:,8))
  call counter_QA_V_LR(EWctAdd,ntry, ex3(:), ex4(:), wf4(:,9), n3(:,37), t3x4(:,:,9))
  call counter_QA_V_LR(EWctGdd,ntry, ex3(:), ex4(:), wf4(:,10), n3(:,38), t3x4(:,:,10))
  call counter_QA_V(ntry, wf6(:,6), ex2(:), wf12(:,7), n3(:,39), t3x12(:,:,7))
  call counter_QA_V_LR(EWctAtt,ntry, wf6(:,6), ex2(:), wf12(:,8), n3(:,40), t3x12(:,:,8))
  call counter_QA_Z(gZu,ntry, wf6(:,6), ex2(:), wf12(:,9), n3(:,41), t3x12(:,:,9))
  call counter_QA_Z(EWctVtt,ntry, wf6(:,6), ex2(:), wf12(:,10), n3(:,42), t3x12(:,:,10))
  call counter_QA_V_LR(EWctGtt,ntry, wf6(:,6), ex2(:), wf12(:,11), n3(:,43), t3x12(:,:,11))
  call counter_AZ_Q(gZu,ntry, ex2(:), ex5(:), wf6(:,17), n3(:,44), t3x6(:,:,9))
  call prop_A_Q(ntry, wf6(:,17), 18, MT, 1_intkind1, wf6(:,18), n2(9))
  call vert_QA_V(ntry, ex1(:), wf6(:,18), wf12(:,12), n3(:,45), t3x12(:,:,12))
  call counter_AZ_Q(EWctVtt,ntry, ex2(:), ex5(:), wf6(:,19), n3(:,46), t3x6(:,:,10))
  call prop_A_Q(ntry, wf6(:,19), 18, MT, 1_intkind1, wf6(:,20), n2(10))
  call vert_QA_V(ntry, ex1(:), wf6(:,20), wf12(:,13), n3(:,47), t3x12(:,:,13))
  call vert_QA_Z(gZu,ntry, ex1(:), wf6(:,18), wf12(:,14), n3(:,48), t3x12(:,:,14))
  call vert_QA_Z(gZu,ntry, ex1(:), wf6(:,20), wf12(:,15), n3(:,49), t3x12(:,:,15))
  call counter_QA_V(ntry, ex1(:), wf6(:,8), wf12(:,16), n3(:,50), t3x12(:,:,16))
  call counter_QA_V_LR(EWctAtt,ntry, ex1(:), wf6(:,8), wf12(:,17), n3(:,51), t3x12(:,:,17))
  call counter_QA_Z(gZu,ntry, ex1(:), wf6(:,8), wf12(:,18), n3(:,52), t3x12(:,:,18))
  call counter_QA_Z(EWctVtt,ntry, ex1(:), wf6(:,8), wf12(:,19), n3(:,53), t3x12(:,:,19))
  call counter_QA_V_LR(EWctGtt,ntry, ex1(:), wf6(:,8), wf12(:,20), n3(:,54), t3x12(:,:,20))
  call counter_ZQ_A(gZu,ntry, ex5(:), ex1(:), wf6(:,21), n3(:,55), t3x6(:,:,11))
  call prop_Q_A(ntry, wf6(:,21), 17, MT, 1_intkind1, wf6(:,22), n2(11))
  call vert_QA_V(ntry, wf6(:,22), ex2(:), wf12(:,21), n3(:,56), t3x12(:,:,21))
  call counter_ZQ_A(EWctVtt,ntry, ex5(:), ex1(:), wf6(:,23), n3(:,57), t3x6(:,:,12))
  call prop_Q_A(ntry, wf6(:,23), 17, MT, 1_intkind1, wf6(:,24), n2(12))
  call vert_QA_V(ntry, wf6(:,24), ex2(:), wf12(:,22), n3(:,58), t3x12(:,:,22))
  call vert_QA_Z(gZu,ntry, wf6(:,22), ex2(:), wf12(:,23), n3(:,59), t3x12(:,:,23))
  call vert_QA_Z(gZu,ntry, wf6(:,24), ex2(:), wf12(:,24), n3(:,60), t3x12(:,:,24))
  call counter_AQ_S(gH,ntry, ex2(:), ex1(:), wf4(:,11), n3(:,61), t3x4(:,:,11))
  call vert_SV_V(ntry, wf4(:,11), ex5(:), wf12(:,25), n3(:,62), t3x12(:,:,25))
  call counter_AQ_S(EWctHtt,ntry, ex2(:), ex1(:), wf4(:,12), n3(:,63), t3x4(:,:,12))
  call vert_SV_V(ntry, wf4(:,12), ex5(:), wf12(:,26), n3(:,64), t3x12(:,:,26))
  call counter_QA_V(ntry, ex1(:), ex2(:), wf4(:,13), n3(:,65), t3x4(:,:,13))
  call vert_AV_Q(ntry, ex4(:), wf4(:,13), wf8(:,15), n3(:,66), t3x8(:,:,15))
  call counter_QA_V_LR(EWctAtt,ntry, ex1(:), ex2(:), wf4(:,14), n3(:,67), t3x4(:,:,14))
  call vert_AV_Q(ntry, ex4(:), wf4(:,14), wf8(:,16), n3(:,68), t3x8(:,:,16))
  call counter_QA_Z(gZu,ntry, ex1(:), ex2(:), wf4(:,15), n3(:,69), t3x4(:,:,15))
  call vert_AZ_Q(gZd,ntry, ex4(:), wf4(:,15), wf8(:,17), n3(:,70), t3x8(:,:,17))
  call counter_QA_Z(EWctVtt,ntry, ex1(:), ex2(:), wf4(:,16), n3(:,71), t3x4(:,:,16))
  call vert_AZ_Q(gZd,ntry, ex4(:), wf4(:,16), wf8(:,18), n3(:,72), t3x8(:,:,18))
  call counter_QA_V_LR(EWctGtt,ntry, ex1(:), ex2(:), wf4(:,17), n3(:,73), t3x4(:,:,17))
  call vert_AV_Q(ntry, ex4(:), wf4(:,17), wf8(:,19), n3(:,74), t3x8(:,:,19))
  call vert_VQ_A(ntry, wf4(:,13), ex3(:), wf8(:,20), n3(:,75), t3x8(:,:,20))
  call vert_VQ_A(ntry, wf4(:,14), ex3(:), wf8(:,21), n3(:,76), t3x8(:,:,21))
  call vert_ZQ_A(gZd,ntry, wf4(:,15), ex3(:), wf8(:,22), n3(:,77), t3x8(:,:,22))
  call vert_ZQ_A(gZd,ntry, wf4(:,16), ex3(:), wf8(:,23), n3(:,78), t3x8(:,:,23))
  call vert_VQ_A(ntry, wf4(:,17), ex3(:), wf8(:,24), n3(:,79), t3x8(:,:,24))
  call vert_VV_S(ntry, wf4(:,2), ex5(:), wf12(:,27), n3(:,80), t3x12(:,:,27))
  call counter_S_S(EWctHH,ntry, wf4(:,1), 3, wf4(:,18), n2(13))
  call vert_TV_S(ntry, wf4(:,1), 3, ex5(:), 16, wf12(:,28), n3(:,81), t3x12(:,:,28))
  call counter_V_S(EWctXA,ntry, wf4(:,5), 12, wf4(:,19), n2(14))
  call counter_V_S(EWctXZ,ntry, wf4(:,2), 12, wf4(:,20), n2(15))
  call counter_V_V(EWctAZ,ntry, wf4(:,5), 12, wf4(:,21), n2(16))
  call counter_V_V(EWctZZ,ntry, wf4(:,2), 12, wf4(:,22), n2(17))
  call vert_AQ_S(gX,ntry, ex2(:), ex1(:), wf4(:,23), n3(:,82), t3x4(:,:,18))
  call vert_QA_V(ntry, wf6(:,2), ex4(:), wf12(:,29), n3(:,83), t3x12(:,:,29))
  call counter_S_V(EWctXA,ntry, wf4(:,23), 3, wf4(:,24), n2(18))
  call vert_QA_Z(gZd,ntry, wf6(:,2), ex4(:), wf12(:,30), n3(:,84), t3x12(:,:,30))
  call counter_S_V(EWctXZ,ntry, wf4(:,23), 3, wf4(:,25), n2(19))
  call counter_V_V(EWctAA,ntry, wf4(:,3), 3, wf4(:,26), n2(20))
  call counter_V_V(EWctAZ,ntry, wf4(:,3), 3, wf4(:,27), n2(21))
  call counter_V_V(EWctAZ,ntry, wf4(:,4), 3, wf4(:,28), n2(22))
  call counter_V_V(EWctZZ,ntry, wf4(:,4), 3, wf4(:,29), n2(23))
  call counter_Q_A(ctqq,1,ntry, wf6(:,2), 20, wf6(:,25), n2(24))
  call prop_A_Q(ntry, wf8(:,1), 11, ZERO, 0_intkind1, wf8(:,25), n2(25))
  call counter_Q_A_LR(EWctdd,ntry, wf6(:,2), 20, wf6(:,26), n2(26))
  call prop_A_Q(ntry, wf8(:,2), 11, ZERO, 0_intkind1, wf8(:,26), n2(27))
  call vert_QA_V(ntry, ex3(:), wf6(:,4), wf12(:,31), n3(:,85), t3x12(:,:,31))
  call vert_QA_Z(gZd,ntry, ex3(:), wf6(:,4), wf12(:,32), n3(:,86), t3x12(:,:,32))
  call counter_A_Q(ctqq,1,ntry, wf6(:,4), 24, wf6(:,27), n2(28))
  call prop_Q_A(ntry, wf8(:,3), 7, ZERO, 0_intkind1, wf8(:,27), n2(29))
  call counter_A_Q_LR(EWctdd,ntry, wf6(:,4), 24, wf6(:,28), n2(30))
  call prop_Q_A(ntry, wf8(:,4), 7, ZERO, 0_intkind1, wf8(:,28), n2(31))
  call vert_AV_Q(ntry, ex2(:), wf4(:,5), wf8(:,29), n3(:,87), t3x8(:,:,25))
  call counter_Q_A(cttt,6,ntry, wf6(:,6), 17, wf6(:,29), n2(32))
  call prop_A_Q(ntry, wf8(:,29), 14, MT, 1_intkind1, wf8(:,30), n2(33))
  call counter_Q_A_LR(EWcttt,ntry, wf6(:,6), 17, wf6(:,30), n2(34))
  call vert_AZ_Q(gZu,ntry, ex2(:), wf4(:,2), wf8(:,31), n3(:,88), t3x8(:,:,26))
  call prop_A_Q(ntry, wf8(:,31), 14, MT, 1_intkind1, wf8(:,32), n2(35))
  call vert_AQ_S(gX,ntry, ex2(:), wf6(:,6), wf12(:,33), n3(:,89), t3x12(:,:,33))
  call counter_V_V(EWctAA,ntry, wf4(:,5), 12, wf4(:,30), n2(36))
  call counter_V_V(EWctAZ,ntry, wf4(:,2), 12, wf4(:,31), n2(37))
  call vert_VQ_A(ntry, wf4(:,5), ex1(:), wf8(:,33), n3(:,90), t3x8(:,:,27))
  call counter_A_Q(cttt,6,ntry, wf6(:,8), 18, wf6(:,31), n2(38))
  call prop_Q_A(ntry, wf8(:,33), 13, MT, 1_intkind1, wf8(:,34), n2(39))
  call counter_A_Q_LR(EWcttt,ntry, wf6(:,8), 18, wf6(:,32), n2(40))
  call vert_ZQ_A(gZu,ntry, wf4(:,2), ex1(:), wf8(:,35), n3(:,91), t3x8(:,:,28))
  call prop_Q_A(ntry, wf8(:,35), 13, MT, 1_intkind1, wf8(:,36), n2(41))
  call vert_AQ_S(gX,ntry, wf6(:,8), ex1(:), wf12(:,34), n3(:,92), t3x12(:,:,34))
  call vert_VS_T(ntry, ex5(:), 16, wf4(:,23), 3, wf12(:,35), n3(:,93), t3x12(:,:,35))
  call vert_VV_S(ntry, wf4(:,4), ex5(:), wf12(:,36), n3(:,94), t3x12(:,:,36))
  call vert_AQ_S(gH,ntry, ex2(:), wf6(:,6), wf12(:,37), n3(:,95), t3x12(:,:,37))
  call vert_AQ_S(gH,ntry, wf6(:,8), ex1(:), wf12(:,38), n3(:,96), t3x12(:,:,38))


  call init_hybrid_exwf(ex1)
  call init_hybrid_exwf(ex2)
  call init_hybrid_exwf(ex3)
  call init_hybrid_exwf(ex4)
  call init_hybrid_exwf(ex5)
  call init_hybrid_wf(wf4)
  call init_hybrid_wf(wf6)
  call init_hybrid_wf(wf8)
  call init_hybrid_wf(wf12)


  if (ntry==1) then
    call physical_helicities()
  end if

  ! computation of the colour-stripped amplitudes
  do nsync = ntry+ntry-1, ntry+1  !  nsync = 1,2  for 1st point and nsync = 3 later
    call diagrams()
    if (nsync == 1) call helsync(nsync, A, nhel, Hel)
  end do

  ! In the following loop the coefficients \Gamma_{i} of the expansion in
  ! the colour basis are computed for every helicity state and stored in M1helarray.
  ! Also the colour vector for the Born-loop interference is computed and saved in
  ! M0_col1_helarray
  do k = 1, nhel
    call colourvectors(A, k, M1helarray(:,k),M1helarray_ct(:,k))
    call colborninterf(M1helarray(:,k), M0_col1_helarray(:,k), 0)
  end do
  M1helarray(:,nhel+1:)%j = 0
  M0_col1_helarray(:,nhel+1:)%hf = -1_intkind2
  M0_col1_helarray(:,nhel+1:)%j = 0

  M2add = 0
  M2add_ct = 0
  M2add_colint = 0

  M02 = 0
  M2ct = 0
  M2colint = 0

  do k = 1, nhel
    call colint(M1helarray(:,k)%j, M2add)
    call colint_ct(M1helarray(:,k)%j, M1helarray_ct(:,k)%j, M2add_ct, 0)
    if (IR_is_on > 0) then
      call colint_IR(M1helarray(:,k)%j, M2add_colint)
    end if
    !summation over helicity configurations
    M02 = M02 + M2add
    M2ct = M2ct + M2add_ct
    M2colint = M2colint + M2add_colint
  end do

  call photon_factors(photonid_ppztt_ew_ttxddxz_3, 0, bornphotonfactor)
  M02 = bornphotonfactor * M02
  M2ct = bornphotonfactor * M2ct
  M2colint = bornphotonfactor * M2colint

  !! used for born-loop colour-correlators
  extcombs = [(i, i = 0, 16-1)]
  nextcombs = 5*(5+1)/2 + 1
  if(nextcombs>0) then
    allocate(extcombs_permuted(nextcombs))
  end if
  do k = 1, nextcombs
    extcombs_permuted(k) = extcomb_perm_ppztt_ew_ttxddxz_3(extcombs(k))
  end do

#if 1 > 0 && 5 > 3
  !!Born-loop colour correlators interference
ind_cc_comb = [8,12,9,13,14]
  M0M1_hel_cc(:,:,:)%j = 0
  do n = 1, 5
    M2add_ct = 0
    m = ind_cc_comb(n)
      do k = 1, nhel
        call colint_ct(M1helarray(:,k)%j, M1helarray_ct(:,k)%j, M2add_ct, m)
        call colborninterf(M1helarray(:,k), M0M1_hel_cc(:,k,m), m)
        M2ctcc(m) = M2ctcc(m) + M2add_ct
      end do
  end do
  M0M1_hel_cc(:,nhel+1:,:)%hf = -1_intkind2
  M0M1_hel_cc(:,nhel+1:,:)%j = 0
#endif


  contains

subroutine physical_helicities()
  implicit none

integer :: i1,i2,i3,i4,i5
integer :: n

n=0

do i5= 1, 3
do i4= 1, 2
do i3= 1, 2
do i2= 1, 2
do i1= 1, 2
n = n + 1
 if((ex1(i1)%hf==-1_intkind2) .OR. (ex2(i2)%hf==-1_intkind2) .OR. (ex3(i3)%hf==-1_intkind2) .OR. (ex4(i4)%hf==-1_intkind2)  &
    .OR. (ex5(i5)%hf==-1_intkind2)) then
  Hel(n) = -1_intkind2
 else
  Hel(n) = ex1(i1)%hf + ex2(i2)%hf + ex3(i3)%hf + ex4(i4)%hf + ex5(i5)%hf
 end if
end do
end do
end do
end do
end do

end subroutine physical_helicities

subroutine diagrams()
  implicit none
  integer :: h
  ! e.g. call cont_VV(nsync, wf3, wf6, A(:,1), n64, t64, nhel, den(5)) ...

    call Hcont_VV(nsync, wf4(:,2), wf12(:,1), A(:,1), n3(:,97), t3x48(:,:,1), nhel, den(3))
    call Hcont_QA(nsync, wf6(:,2), wf8(:,1), A(:,2), n3(:,98), t3x48(:,:,2), nhel, den(6))
    call Hcont_QA(nsync, wf6(:,2), wf8(:,2), A(:,3), n3(:,99), t3x48(:,:,3), nhel, den(8))
    call Hcont_QA(nsync, wf6(:,2), wf8(:,1), A(:,4), n3(:,100), t3x48(:,:,4), nhel, den(6))
    call Hcont_QA(nsync, wf6(:,4), wf8(:,3), A(:,5), n3(:,101), t3x48(:,:,5), nhel, den(10))
    call Hcont_QA(nsync, wf6(:,4), wf8(:,4), A(:,6), n3(:,102), t3x48(:,:,6), nhel, den(11))
    call Hcont_QA(nsync, wf6(:,4), wf8(:,3), A(:,7), n3(:,103), t3x48(:,:,7), nhel, den(10))
    call Hcont_VV(nsync, wf4(:,5), wf12(:,2), A(:,8), n3(:,104), t3x48(:,:,8), nhel, den(14))
    call Hcont_VV(nsync, wf4(:,2), wf12(:,3), A(:,9), n3(:,105), t3x48(:,:,9), nhel, den(15))
    call Hcont_VV(nsync, wf4(:,5), wf12(:,2), A(:,10), n3(:,106), t3x48(:,:,10), nhel, den(14))
    call Hcont_VV(nsync, wf4(:,5), wf12(:,4), A(:,11), n3(:,107), t3x48(:,:,11), nhel, den(17))
    call Hcont_VV(nsync, wf4(:,2), wf12(:,5), A(:,12), n3(:,108), t3x48(:,:,12), nhel, den(18))
    call Hcont_VV(nsync, wf4(:,5), wf12(:,4), A(:,13), n3(:,109), t3x48(:,:,13), nhel, den(17))

    call Hcont_VV(nsync, wf4(:,5), wf12(:,6), A(:,14), n3(:,110), t3x48(:,:,14), nhel, den(19))
    call Hcont_VV(nsync, wf4(:,2), wf12(:,6), A(:,15), n3(:,111), t3x48(:,:,15), nhel, den(3))
    call Hcont_QA(nsync, wf6(:,2), wf8(:,5), A(:,16), n3(:,112), t3x48(:,:,16), nhel, den(6))
    call Hcont_QA(nsync, wf6(:,2), wf8(:,6), A(:,17), n3(:,113), t3x48(:,:,17), nhel, den(6))
    call Hcont_QA(nsync, wf6(:,2), wf8(:,7), A(:,18), n3(:,114), t3x48(:,:,18), nhel, den(8))
    call Hcont_QA(nsync, wf6(:,2), wf8(:,8), A(:,19), n3(:,115), t3x48(:,:,19), nhel, den(8))
    call Hcont_QA(nsync, wf6(:,2), wf8(:,9), A(:,20), n3(:,116), t3x48(:,:,20), nhel, den(6))
    call Hcont_QA(nsync, wf8(:,3), wf6(:,10), A(:,21), n3(:,117), t3x48(:,:,21), nhel, den(10))
    call Hcont_QA(nsync, wf8(:,3), wf6(:,12), A(:,22), n3(:,118), t3x48(:,:,22), nhel, den(10))
    call Hcont_QA(nsync, wf8(:,4), wf6(:,10), A(:,23), n3(:,119), t3x48(:,:,23), nhel, den(11))
    call Hcont_QA(nsync, wf8(:,4), wf6(:,12), A(:,24), n3(:,120), t3x48(:,:,24), nhel, den(11))
    call Hcont_QA(nsync, wf8(:,3), wf6(:,12), A(:,25), n3(:,121), t3x48(:,:,25), nhel, den(10))
    call Hcont_QA(nsync, wf6(:,4), wf8(:,10), A(:,26), n3(:,122), t3x48(:,:,26), nhel, den(10))
    call Hcont_QA(nsync, wf6(:,4), wf8(:,11), A(:,27), n3(:,123), t3x48(:,:,27), nhel, den(10))
    call Hcont_QA(nsync, wf6(:,4), wf8(:,12), A(:,28), n3(:,124), t3x48(:,:,28), nhel, den(11))
    call Hcont_QA(nsync, wf6(:,4), wf8(:,13), A(:,29), n3(:,125), t3x48(:,:,29), nhel, den(11))
    call Hcont_QA(nsync, wf6(:,4), wf8(:,14), A(:,30), n3(:,126), t3x48(:,:,30), nhel, den(10))
    call Hcont_QA(nsync, wf8(:,1), wf6(:,14), A(:,31), n3(:,127), t3x48(:,:,31), nhel, den(6))
    call Hcont_QA(nsync, wf8(:,1), wf6(:,16), A(:,32), n3(:,128), t3x48(:,:,32), nhel, den(6))
    call Hcont_QA(nsync, wf8(:,2), wf6(:,14), A(:,33), n3(:,129), t3x48(:,:,33), nhel, den(8))
    call Hcont_QA(nsync, wf8(:,2), wf6(:,16), A(:,34), n3(:,130), t3x48(:,:,34), nhel, den(8))
    call Hcont_QA(nsync, wf8(:,1), wf6(:,16), A(:,35), n3(:,131), t3x48(:,:,35), nhel, den(6))
    call Hcont_VV(nsync, wf12(:,1), wf4(:,6), A(:,36), n3(:,132), t3x48(:,:,36), nhel, den(3))
    call Hcont_VV(nsync, wf12(:,1), wf4(:,7), A(:,37), n3(:,133), t3x48(:,:,37), nhel, den(3))
    call Hcont_VV(nsync, wf12(:,2), wf4(:,8), A(:,38), n3(:,134), t3x48(:,:,38), nhel, den(14))
    call Hcont_VV(nsync, wf12(:,2), wf4(:,9), A(:,39), n3(:,135), t3x48(:,:,39), nhel, den(14))
    call Hcont_VV(nsync, wf12(:,3), wf4(:,6), A(:,40), n3(:,136), t3x48(:,:,40), nhel, den(15))
    call Hcont_VV(nsync, wf12(:,3), wf4(:,7), A(:,41), n3(:,137), t3x48(:,:,41), nhel, den(15))
    call Hcont_VV(nsync, wf12(:,2), wf4(:,10), A(:,42), n3(:,138), t3x48(:,:,42), nhel, den(14))
    call Hcont_VV(nsync, wf12(:,4), wf4(:,8), A(:,43), n3(:,139), t3x48(:,:,43), nhel, den(17))
    call Hcont_VV(nsync, wf12(:,4), wf4(:,9), A(:,44), n3(:,140), t3x48(:,:,44), nhel, den(17))
    call Hcont_VV(nsync, wf12(:,5), wf4(:,6), A(:,45), n3(:,141), t3x48(:,:,45), nhel, den(18))
    call Hcont_VV(nsync, wf12(:,5), wf4(:,7), A(:,46), n3(:,142), t3x48(:,:,46), nhel, den(18))
    call Hcont_VV(nsync, wf12(:,4), wf4(:,10), A(:,47), n3(:,143), t3x48(:,:,47), nhel, den(17))
    call Hcont_VV(nsync, wf4(:,5), wf12(:,7), A(:,48), n3(:,144), t3x48(:,:,48), nhel, den(14))
    call Hcont_VV(nsync, wf4(:,5), wf12(:,8), A(:,49), n3(:,145), t3x48(:,:,49), nhel, den(14))
    call Hcont_VV(nsync, wf4(:,2), wf12(:,9), A(:,50), n3(:,146), t3x48(:,:,50), nhel, den(15))
    call Hcont_VV(nsync, wf4(:,2), wf12(:,10), A(:,51), n3(:,147), t3x48(:,:,51), nhel, den(15))
    call Hcont_VV(nsync, wf4(:,5), wf12(:,11), A(:,52), n3(:,148), t3x48(:,:,52), nhel, den(14))
    call Hcont_VV(nsync, wf4(:,5), wf12(:,12), A(:,53), n3(:,149), t3x48(:,:,53), nhel, den(17))
    call Hcont_VV(nsync, wf4(:,5), wf12(:,13), A(:,54), n3(:,150), t3x48(:,:,54), nhel, den(17))
    call Hcont_VV(nsync, wf4(:,2), wf12(:,14), A(:,55), n3(:,151), t3x48(:,:,55), nhel, den(18))
    call Hcont_VV(nsync, wf4(:,2), wf12(:,15), A(:,56), n3(:,152), t3x48(:,:,56), nhel, den(18))
    call Hcont_VV(nsync, wf4(:,5), wf12(:,13), A(:,57), n3(:,153), t3x48(:,:,57), nhel, den(17))
    call Hcont_VV(nsync, wf4(:,5), wf12(:,16), A(:,58), n3(:,154), t3x48(:,:,58), nhel, den(17))
    call Hcont_VV(nsync, wf4(:,5), wf12(:,17), A(:,59), n3(:,155), t3x48(:,:,59), nhel, den(17))
    call Hcont_VV(nsync, wf4(:,2), wf12(:,18), A(:,60), n3(:,156), t3x48(:,:,60), nhel, den(18))
    call Hcont_VV(nsync, wf4(:,2), wf12(:,19), A(:,61), n3(:,157), t3x48(:,:,61), nhel, den(18))
    call Hcont_VV(nsync, wf4(:,5), wf12(:,20), A(:,62), n3(:,158), t3x48(:,:,62), nhel, den(17))
    call Hcont_VV(nsync, wf4(:,5), wf12(:,21), A(:,63), n3(:,159), t3x48(:,:,63), nhel, den(14))
    call Hcont_VV(nsync, wf4(:,5), wf12(:,22), A(:,64), n3(:,160), t3x48(:,:,64), nhel, den(14))
    call Hcont_VV(nsync, wf4(:,2), wf12(:,23), A(:,65), n3(:,161), t3x48(:,:,65), nhel, den(15))
    call Hcont_VV(nsync, wf4(:,2), wf12(:,24), A(:,66), n3(:,162), t3x48(:,:,66), nhel, den(15))
    call Hcont_VV(nsync, wf4(:,5), wf12(:,22), A(:,67), n3(:,163), t3x48(:,:,67), nhel, den(14))
    call Hcont_VV(nsync, wf4(:,2), wf12(:,25), A(:,68), n3(:,164), t3x48(:,:,68), nhel, den(3))
    call Hcont_VV(nsync, wf4(:,2), wf12(:,26), A(:,69), n3(:,165), t3x48(:,:,69), nhel, den(3))
    call Hcont_QA(nsync, wf6(:,2), wf8(:,15), A(:,70), n3(:,166), t3x48(:,:,70), nhel, den(6))
    call Hcont_QA(nsync, wf6(:,2), wf8(:,16), A(:,71), n3(:,167), t3x48(:,:,71), nhel, den(6))
    call Hcont_QA(nsync, wf6(:,2), wf8(:,17), A(:,72), n3(:,168), t3x48(:,:,72), nhel, den(8))
    call Hcont_QA(nsync, wf6(:,2), wf8(:,18), A(:,73), n3(:,169), t3x48(:,:,73), nhel, den(8))
    call Hcont_QA(nsync, wf6(:,2), wf8(:,19), A(:,74), n3(:,170), t3x48(:,:,74), nhel, den(6))
    call Hcont_QA(nsync, wf6(:,4), wf8(:,20), A(:,75), n3(:,171), t3x48(:,:,75), nhel, den(10))
    call Hcont_QA(nsync, wf6(:,4), wf8(:,21), A(:,76), n3(:,172), t3x48(:,:,76), nhel, den(10))
    call Hcont_QA(nsync, wf6(:,4), wf8(:,22), A(:,77), n3(:,173), t3x48(:,:,77), nhel, den(11))
    call Hcont_QA(nsync, wf6(:,4), wf8(:,23), A(:,78), n3(:,174), t3x48(:,:,78), nhel, den(11))
    call Hcont_QA(nsync, wf6(:,4), wf8(:,24), A(:,79), n3(:,175), t3x48(:,:,79), nhel, den(10))
    call Hcont_SS(nsync, wf12(:,27), wf4(:,18), A(:,80), n3(:,176), t3x48(:,:,80), nhel, den(22))
    call Hcont_SS(nsync, wf12(:,28), wf4(:,19), A(:,81), n3(:,177), t3x48(:,:,81), nhel, den(25))
    call Hcont_SS(nsync, wf12(:,28), wf4(:,20), A(:,82), n3(:,178), t3x48(:,:,82), nhel, den(26))
    call Hcont_VV(nsync, wf12(:,1), wf4(:,21), A(:,83), n3(:,179), t3x48(:,:,83), nhel, den(25))
    call Hcont_VV(nsync, wf12(:,1), wf4(:,22), A(:,84), n3(:,180), t3x48(:,:,84), nhel, den(26))
    call Hcont_VV(nsync, wf12(:,29), wf4(:,24), A(:,85), n3(:,181), t3x48(:,:,85), nhel, den(29))
    call Hcont_VV(nsync, wf12(:,30), wf4(:,25), A(:,86), n3(:,182), t3x48(:,:,86), nhel, den(32))
    call Hcont_VV(nsync, wf12(:,29), wf4(:,26), A(:,87), n3(:,183), t3x48(:,:,87), nhel, den(33))
    call Hcont_VV(nsync, wf12(:,30), wf4(:,27), A(:,88), n3(:,184), t3x48(:,:,88), nhel, den(34))
    call Hcont_VV(nsync, wf12(:,29), wf4(:,28), A(:,89), n3(:,185), t3x48(:,:,89), nhel, den(29))
    call Hcont_VV(nsync, wf12(:,30), wf4(:,29), A(:,90), n3(:,186), t3x48(:,:,90), nhel, den(32))
    call Hcont_QA(nsync, wf6(:,25), wf8(:,25), A(:,91), n3(:,187), t3x48(:,:,91), nhel, den(37))
    call Hcont_QA(nsync, wf8(:,25), wf6(:,26), A(:,92), n3(:,188), t3x48(:,:,92), nhel, den(37))
    call Hcont_QA(nsync, wf6(:,25), wf8(:,26), A(:,93), n3(:,189), t3x48(:,:,93), nhel, den(39))
    call Hcont_QA(nsync, wf6(:,26), wf8(:,26), A(:,94), n3(:,190), t3x48(:,:,94), nhel, den(39))
    call Hcont_QA(nsync, wf8(:,25), wf6(:,26), A(:,95), n3(:,191), t3x48(:,:,95), nhel, den(37))
    call Hcont_VV(nsync, wf4(:,24), wf12(:,31), A(:,96), n3(:,192), t3x48(:,:,96), nhel, den(41))
    call Hcont_VV(nsync, wf4(:,25), wf12(:,32), A(:,97), n3(:,193), t3x48(:,:,97), nhel, den(43))
    call Hcont_VV(nsync, wf4(:,26), wf12(:,31), A(:,98), n3(:,194), t3x48(:,:,98), nhel, den(44))
    call Hcont_VV(nsync, wf4(:,27), wf12(:,32), A(:,99), n3(:,195), t3x48(:,:,99), nhel, den(45))
    call Hcont_VV(nsync, wf4(:,28), wf12(:,31), A(:,100), n3(:,196), t3x48(:,:,100), nhel, den(41))
    call Hcont_VV(nsync, wf4(:,29), wf12(:,32), A(:,101), n3(:,197), t3x48(:,:,101), nhel, den(43))
    call Hcont_QA(nsync, wf6(:,27), wf8(:,27), A(:,102), n3(:,198), t3x48(:,:,102), nhel, den(48))
    call Hcont_QA(nsync, wf8(:,27), wf6(:,28), A(:,103), n3(:,199), t3x48(:,:,103), nhel, den(48))
    call Hcont_QA(nsync, wf6(:,27), wf8(:,28), A(:,104), n3(:,200), t3x48(:,:,104), nhel, den(50))
    call Hcont_QA(nsync, wf6(:,28), wf8(:,28), A(:,105), n3(:,201), t3x48(:,:,105), nhel, den(50))
    call Hcont_QA(nsync, wf8(:,27), wf6(:,28), A(:,106), n3(:,202), t3x48(:,:,106), nhel, den(48))
    call Hcont_QA(nsync, wf6(:,29), wf8(:,30), A(:,107), n3(:,203), t3x48(:,:,107), nhel, den(53))
    call Hcont_QA(nsync, wf8(:,30), wf6(:,30), A(:,108), n3(:,204), t3x48(:,:,108), nhel, den(53))
    call Hcont_QA(nsync, wf6(:,29), wf8(:,32), A(:,109), n3(:,205), t3x48(:,:,109), nhel, den(55))
    call Hcont_QA(nsync, wf6(:,30), wf8(:,32), A(:,110), n3(:,206), t3x48(:,:,110), nhel, den(55))
    call Hcont_QA(nsync, wf8(:,30), wf6(:,30), A(:,111), n3(:,207), t3x48(:,:,111), nhel, den(53))
    call Hcont_SS(nsync, wf4(:,19), wf12(:,33), A(:,112), n3(:,208), t3x48(:,:,112), nhel, den(57))
    call Hcont_SS(nsync, wf4(:,20), wf12(:,33), A(:,113), n3(:,209), t3x48(:,:,113), nhel, den(58))
    call Hcont_VV(nsync, wf12(:,2), wf4(:,30), A(:,114), n3(:,210), t3x48(:,:,114), nhel, den(61))
    call Hcont_VV(nsync, wf12(:,2), wf4(:,31), A(:,115), n3(:,211), t3x48(:,:,115), nhel, den(62))
    call Hcont_VV(nsync, wf12(:,3), wf4(:,21), A(:,116), n3(:,212), t3x48(:,:,116), nhel, den(57))
    call Hcont_VV(nsync, wf12(:,3), wf4(:,22), A(:,117), n3(:,213), t3x48(:,:,117), nhel, den(58))
    call Hcont_QA(nsync, wf6(:,31), wf8(:,34), A(:,118), n3(:,214), t3x48(:,:,118), nhel, den(65))
    call Hcont_QA(nsync, wf8(:,34), wf6(:,32), A(:,119), n3(:,215), t3x48(:,:,119), nhel, den(65))
    call Hcont_QA(nsync, wf6(:,31), wf8(:,36), A(:,120), n3(:,216), t3x48(:,:,120), nhel, den(67))
    call Hcont_QA(nsync, wf6(:,32), wf8(:,36), A(:,121), n3(:,217), t3x48(:,:,121), nhel, den(67))
    call Hcont_QA(nsync, wf8(:,34), wf6(:,32), A(:,122), n3(:,218), t3x48(:,:,122), nhel, den(65))
    call Hcont_SS(nsync, wf4(:,19), wf12(:,34), A(:,123), n3(:,219), t3x48(:,:,123), nhel, den(69))
    call Hcont_SS(nsync, wf4(:,20), wf12(:,34), A(:,124), n3(:,220), t3x48(:,:,124), nhel, den(70))
    call Hcont_VV(nsync, wf12(:,4), wf4(:,30), A(:,125), n3(:,221), t3x48(:,:,125), nhel, den(72))
    call Hcont_VV(nsync, wf12(:,4), wf4(:,31), A(:,126), n3(:,222), t3x48(:,:,126), nhel, den(73))
    call Hcont_VV(nsync, wf12(:,5), wf4(:,21), A(:,127), n3(:,223), t3x48(:,:,127), nhel, den(69))
    call Hcont_VV(nsync, wf12(:,5), wf4(:,22), A(:,128), n3(:,224), t3x48(:,:,128), nhel, den(70))

end subroutine diagrams


elemental function diagmap(j, n)
  implicit none
  integer, intent(in) :: j, n
  complex(REALKIND) :: diagmap
  diagmap = A(j,n)%j
end function diagmap

function diagsum(j, pos, neg)
  implicit none
  integer, intent(in) :: j, pos(:), neg(:)
  complex(REALKIND) :: diagsum
  diagsum = sum(diagmap(j, pos)) - sum(diagmap(j, neg))
end function diagsum

subroutine colourvectors(A, j, M1, M2)
  implicit none
  type(Hpolcont) :: A(:,:)
  integer, intent(in) :: j
  type(Hpolcont), intent(out) :: M1(3), M2(3) ! M1helarray(3,48)
  integer :: empty(0), i

  M1(1)%j = ((-A(j,4)%j-A(j,7)%j-A(j,10)%j-A(j,13)%j)*f(7))/2._/**/REALKIND
  M1(2)%j = (A(j,2)%j+A(j,5)%j+A(j,8)%j+A(j,11)%j)*f(1)+(-A(j,3)%j-A(j,6)%j-A(j,9)%j-A(j,12)%j)*f(2)+A(j,1)%j*f(14)
  M1(3)%j = ((A(j,4)%j+A(j,7)%j+A(j,10)%j+A(j,13)%j)*f(7))/6._/**/REALKIND

  M2(1)%j = ((-A(j,20)%j-A(j,25)%j-A(j,30)%j-A(j,35)%j-A(j,42)%j-A(j,47)%j-A(j,52)%j-A(j,57)%j-A(j,62)%j-A(j,67)%j-A(j,74)%j &
       -A(j,79)%j+A(j,95)%j+A(j,106)%j+A(j,111)%j+A(j,122)%j)*f(9))/2._/**/REALKIND
  M2(2)%j = (-A(j,91)%j-A(j,102)%j-A(j,107)%j-A(j,118)%j)*f(8)+(A(j,93)%j+A(j,104)%j+A(j,109)%j+A(j,120)%j)*f(9)+((A(j,20)%j &
       +A(j,25)%j+A(j,30)%j+A(j,35)%j+A(j,42)%j+A(j,47)%j+A(j,52)%j+A(j,57)%j+A(j,62)%j+A(j,67)%j+A(j,74)%j+A(j,79)%j-A(j,95)%j &
       -A(j,106)%j-A(j,111)%j-A(j,122)%j)*f(9))/6._/**/REALKIND+(A(j,16)%j+A(j,21)%j+A(j,26)%j+A(j,31)%j+A(j,38)%j &
       +A(j,43)%j)*f(10)+(-A(j,18)%j-A(j,23)%j-A(j,28)%j-A(j,33)%j-A(j,40)%j-A(j,45)%j)*f(11)+(A(j,48)%j+A(j,53)%j+A(j,58)%j &
       +A(j,63)%j+A(j,70)%j+A(j,75)%j)*f(12)+(-A(j,50)%j-A(j,55)%j-A(j,60)%j-A(j,65)%j-A(j,72)%j-A(j,77)%j)*f(13)+A(j,68)%j*f(17) &
       +A(j,36)%j*f(18)
  M2(3)%j = (A(j,22)%j+A(j,32)%j+A(j,54)%j+A(j,64)%j-A(j,87)%j-A(j,92)%j-A(j,98)%j-A(j,103)%j-A(j,108)%j-A(j,114)%j-A(j,119)%j &
       -A(j,125)%j)*f(3)+(-A(j,49)%j-A(j,59)%j-A(j,71)%j-A(j,76)%j+A(j,89)%j+A(j,100)%j+A(j,116)%j+A(j,127)%j)*f(4)+(A(j,17)%j &
       +A(j,27)%j+A(j,39)%j+A(j,44)%j-A(j,88)%j-A(j,99)%j-A(j,115)%j-A(j,126)%j)*f(5)+(-A(j,19)%j-A(j,24)%j-A(j,29)%j-A(j,34)%j &
       -A(j,41)%j-A(j,46)%j-A(j,51)%j-A(j,56)%j-A(j,61)%j-A(j,66)%j-A(j,73)%j-A(j,78)%j+A(j,90)%j+A(j,94)%j+A(j,101)%j+A(j,105)%j &
       +A(j,110)%j+A(j,117)%j+A(j,121)%j+A(j,128)%j)*f(6)-A(j,83)%j*f(15)+(A(j,37)%j-A(j,80)%j-A(j,84)%j)*f(16)-A(j,81)%j*f(19) &
       -A(j,82)%j*f(20)-A(j,69)%j*f(21)+(A(j,85)%j+A(j,96)%j+A(j,112)%j+A(j,123)%j)*f(22)+(A(j,86)%j+A(j,97)%j+A(j,113)%j &
       +A(j,124)%j)*f(23)+A(j,14)%j*f(24)+A(j,15)%j*f(25)


  M1(:)%hf = Hel(j)
  M2(:)%hf = Hel(j)

  !M(i) corresponds to \Gamma_{i} in Fabios thesis

end subroutine colourvectors


! **********************************************************************
subroutine colint(M, M2colint)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppztt_ew_ttxddxz_3_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(3)
  real(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

    do i = 1, 3
      do j = 1, 3
        M2colint = M2colint + real(conjg(M(i))*K1(i,j)*M(j))
      end do
    end do

end subroutine colint

! **********************************************************************
subroutine colint_ct(M, Mct, M2colint_ct, l)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppztt_ew_ttxddxz_3_/**/REALKIND, only: K2
  implicit none
  complex(REALKIND), intent(in)  :: M(3), Mct(3)
  real(REALKIND),    intent(out) :: M2colint_ct
  integer, intent(in) :: l
  integer ::  i, j

  M2colint_ct = 0

  do i = 1, 3
    do j = 1, 3
      M2colint_ct = M2colint_ct + real(conjg(M(i))*K2(i+3*l,j)*Mct(j))
    end do
  end do

end subroutine colint_ct

! **********************************************************************
subroutine colint_IR(M, M2IRadd)
! M(i)   = <M|Ci> colour component of matrix element
! K1(i,j) = .....
! **********************************************************************
  use ol_colourmatrix_ppztt_ew_ttxddxz_3_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(3)
  real(REALKIND),    intent(out) :: M2IRadd(16)
  integer ::  i, j, k, colmatpos

  M2IRadd = 0

  do k = 1, 17-1
    colmatpos = 3*k
    do i = 1, 3
      do j = 1, 3
        M2IRadd(k) = M2IRadd(k) + real(conjg(M(i))*K1(i+colmatpos,j)*M(j))
      end do
    end do
  end do

end subroutine colint_IR

! **********************************************************************
subroutine colintmunu(M1, M2, M2colint)
! M1(i)    = <M1|Ci> colour component of matrix element
! M2(i)    = <M2|Ci> colour component of matrix element
! M2colint = <M1|M2>
!          = Sum_{i,j} <M1|Ci> * <Ci|Cj> * <Cj|M2>
!          = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppztt_ew_ttxddxz_3_/**/REALKIND, only: K2
  implicit none

  complex(REALKIND), intent(in)  :: M1(3)
  complex(REALKIND), intent(in)  :: M2(3)
  complex(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

  do i = 1, 3
    do j = 1, 3
      M2colint = M2colint + M1(i)*K2(i,j)*conjg(M2(j))
    end do
  end do

end subroutine colintmunu





! **********************************************************************
subroutine colborninterf(M, M0_col, l)
! M(i)         = <M|Ci> colour component of matrix element
! M0_col(i)    = <M2|Ci> colour component of matrix element,
!                see \tilde{M}_{j} in Fabios thesis
! M2colint = Sum_{i} <M1|Ci> * <Ci|Cj>
!          = colour-summed squared matrix element
! KL(i,j) = <Ci|Cj> with elements Cj of 1-loop colour basis
! **********************************************************************
  use ol_colourmatrix_ppztt_ew_ttxddxz_3_/**/REALKIND, only: KL
  implicit none

  type(Hpolcont), intent(in)  :: M(3)
  type(Hpolcont), intent(out)  :: M0_col(3)
  integer, intent(in) :: l
  integer :: i, j

  do j = 1, 3 !size(KL(1,:))
    M0_col(j)%j = 0
    M0_col(j)%hf = M(1)%hf
    do i = 1, 3 !size(KL(:,1))
      M0_col(j)%j = M0_col(j)%j  + conjg(M(i)%j)*KL(i+3*l,j)
    end do
  end do

end subroutine colborninterf

end subroutine amp2

end module ol_loop_ppztt_ew_ttxddxz_3_/**/REALKIND
