
module ol_colourmatrix_ppztt_ew_ttxbbxz_4_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  logical, save           :: colmat_not_initialised = .true.
  complex(REALKIND), save :: K1(34,2), K2(2,2), KL(2,2), Cas(5) = 0
  contains
  subroutine colourmatrix_init
    use ol_parameters_decl_/**/REALKIND, only: CI
    implicit none
    integer :: k, co
    colmat_not_initialised = .false.
    ! colour matrix

  K1( 1,:) = [ 9, 3]
  K1( 2,:) = [ 3, 9]
  K1( 3,:) = [ 0, 0]
  K1( 4,:) = [ 0, 0]
  K1( 5,:) = [ 0, 0]
  K1( 6,:) = [ 0, 0]
  K1( 7,:) = [ 0, 0]
  K1( 8,:) = [ 0, 0]
  K1( 9,:) = [ 0, 0]
  K1(10,:) = [ 0, 0]
  K1(11,:) = [ 0, 0]
  K1(12,:) = [ 0, 0]
  K1(13,:) = [ 0, 0]
  K1(14,:) = [ 0, 0]
  K1(15,:) = [ 0, 0]
  K1(16,:) = [ 0, 0]
  K1(17,:) = [ 0, 0]
  K1(18,:) = [ 0, 0]
  K1(19,:) = [ 0, 0]
  K1(20,:) = [ 0, 0]
  K1(21,:) = [ 0, 0]
  K1(22,:) = [ 0, 0]
  K1(23,:) = [ 0, 0]
  K1(24,:) = [ 0, 0]
  K1(25,:) = [ 0, 0]
  K1(26,:) = [ 0, 0]
  K1(27,:) = [ 0, 0]
  K1(28,:) = [ 0, 0]
  K1(29,:) = [ 0, 0]
  K1(30,:) = [ 0, 0]
  K1(31,:) = [ 0, 0]
  K1(32,:) = [ 0, 0]
  K1(33,:) = [ 9, 3]
  K1(34,:) = [ 3, 9]

  K2(1,:) = [ 9, 3]
  K2(2,:) = [ 3, 9]

  KL(1,:) = [ 9, 3]
  KL(2,:) = [ 3, 9]

#if 1 > 0
    co = 0
    do k = 1, 5
      co = co + k
      Cas(k) = K1(1+2*co,1)/K1(1,1)
    end do
#endif
  end subroutine colourmatrix_init
end module ol_colourmatrix_ppztt_ew_ttxbbxz_4_/**/REALKIND



module ol_forced_parameters_ppztt_ew_ttxbbxz_4_/**/REALKIND
  implicit none
  contains
  subroutine check_forced_parameters
    use ol_parameters_decl_/**/REALKIND
    use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
    use ol_loop_parameters_decl_/**/DREALKIND, only: LeadingColour, nc, nf, CKMORDER
#endif
    implicit none
    logical, save :: checks_not_written = .true.

    if (checks_not_written) then
    ! e.g.
    ! if (ME /= 0) write(*,101) 'ME = 0'
  if (CKMORDER /= 0) write(*,101) 'CKMORDER = 0'
  if (nc /= 3) write(*,101) 'nc = 3'
  if (nf /= 6) write(*,101) 'nf = 6'
  if (MU /= 0) write(*,101) 'MU = 0'
  if (MD /= 0) write(*,101) 'MD = 0'
  if (MS /= 0) write(*,101) 'MS = 0'
  if (MC /= 0) write(*,101) 'MC = 0'
  if (LeadingColour /= 0) write(*,101) 'LeadingColour = 0'
  if (wMT /= 0) write(*,101) 'wMT = 0'
  if (wMT /= 0) write(*,101) 'wMT = 0'
  if (wMB /= 0) write(*,101) 'wMB = 0'
  if (wMB /= 0) write(*,101) 'wMB = 0'
  if (wMZ /= 0) write(*,101) 'wMZ = 0'


    checks_not_written = .false.
    end if

    101 format('[OpenLoops] === WARNING ===',/,'[OpenLoops] code was generated with ',A,/,'[OpenLoops] ===============')
  end subroutine check_forced_parameters
end module ol_forced_parameters_ppztt_ew_ttxbbxz_4_/**/REALKIND


! **********************************************************************
module ol_loop_storage_ppztt_ew_ttxbbxz_4_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, intkind1, intkind2
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont

#ifdef PRECISION_dp
  integer(intkind1), save :: ntry = 1, ntryL = 1
  integer(intkind1), save :: p_switch = 0 ! switch for dp or qp. Used for memory allocation of the OL types
  ! the following are flags for memory allocation of the hol coefficients in dp or qp
  logical, save :: dp_not_alloc = .TRUE., qp_not_alloc = .TRUE.
  integer, save :: n_merge_steps  ! total number of merging steps
  integer, save :: n_merge_mism   ! number of merging mismatches
  integer, save :: merge_step = 1 ! current merging step
  integer(intkind2), save, allocatable :: merge_tables(:,:,:) ! merging tables
  integer(intkind2), save, allocatable :: merge_mism(:)       ! array of merging mismatches
  integer(intkind2), save, allocatable :: merge_hels(:)       ! array with relevant helicities for a merging step
  logical, save :: merge_tables_on = .false.
  integer(intkind2), parameter :: nheltot = 48 ! number of helicity configurations
  integer(intkind2), save :: nhel = 48 ! number of non-vanishing helicity configurations (adapted at runtime)
  integer(intkind2), save :: Hel(48) ! physical helicity states
#endif

  complex(REALKIND), save :: den(158)

  ! external wave functions ex1(h1),... for h<n> helicities
  type(wfun) :: ex1(2), ex2(2), ex3(2), ex4(2), ex5(3)

  ! wf<h>(h,n) n wave functions with h helicity configurations
  type(wfun) :: wf4(4,52), wf6(6,20), wf8(8,76), wf12(12,77), wf48(48,242)

  ! diagram prefactors
  integer,           save :: fac_status_loop1 = -1, fac_status_loop2 = -1
  complex(REALKIND), save :: f(606), c(550)

  !Vector in helicity and colour space for Born-Loop interference
  type(Hpolcont),   save :: M0_col1_helarray(2,48), M0M1_hel_cc(2,48,16)
  complex(REALKIND), save :: M2ctcc(16)

end module ol_loop_storage_ppztt_ew_ttxbbxz_4_/**/REALKIND






! **********************************************************************
module ol_loop_ppztt_ew_ttxbbxz_4_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, DREALKIND, intkind1, intkind2
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont
  use ol_loop_storage_ppztt_ew_ttxbbxz_4_/**/REALKIND
  implicit none

!*********************************************************************************
  contains

! **********************************************************************
subroutine fac_init_loop()
! Writes diagram prefactors to 'f', rsp. 'c'
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND
  use ol_init, only: set_parameter, tree_parameters_flush, parameters_flush
#ifndef PRECISION_dp
  use ol_loop_parameters_decl_/**/DREALKIND, only: SwF, SwB
!  use ol_loop_parameters_decl_/**/DREALKIND, only: DOI
#endif
  implicit none
  call set_parameter("ew_renorm", 1)
  if (parameters_status == 0) call tree_parameters_flush()
  if (loop_parameters_status == 0) call parameters_flush()
  fac_status_loop1 = parameters_status
  fac_status_loop2 = loop_parameters_status
  ! factors of the diagrams
    f(  1) = (2*CI*eQED**3)/9._/**/REALKIND
    f(  2) = CI*eQED**3
    f(  3) = (2*CI*countertermnorm*eQED**5)/9._/**/REALKIND
    f(  4) = (CI*countertermnorm*eQED**5)/3._/**/REALKIND
    f(  5) = (2*CI*countertermnorm*eQED**5)/3._/**/REALKIND
    f(  6) = CI*countertermnorm*eQED**5
    f(  7) = (CI*countertermnorm*eQED**5)/(cw*sqrt2)
    f(  8) = (CI*countertermnorm*eQED**5*(cw - sw)*(cw + sw))/(2._/**/REALKIND*cw*MW**2*sqrt2*sw**2)
    f(  9) = -(CI*eQED**3*(cw - sw)*(cw + sw))/(4._/**/REALKIND*cw*MW**2*sw**3)
    f( 10) = -(CI*countertermnorm*eQED**5*(cw - sw)*(cw + sw))/(4._/**/REALKIND*cw*MW**2*sw**3)
    f( 11) = -(CI*countertermnorm*eQED**5*(cw - sw)*(cw + sw))/(4._/**/REALKIND*cw*MW*sw**3)
    f( 12) = (CI*cw*eQED**3)/(2._/**/REALKIND*sw**3)
    f( 13) = (CI*countertermnorm*cw*eQED**5)/(2._/**/REALKIND*sw**3)
    f( 14) = (CI*countertermnorm*cw*eQED**5*EWctVbt)/(2._/**/REALKIND*sw**3)
    f( 15) = (CI*countertermnorm*cw*eQED**5*EWctVtb)/(2._/**/REALKIND*sw**3)
    f( 16) = (CI*eQED**3*MB*MT)/(8._/**/REALKIND*cw*MW**2*sw**3)
    f( 17) = (CI*countertermnorm*eQED**5*MB*MT)/(8._/**/REALKIND*cw*MW**2*sw**3)
    f( 18) = (CI*countertermnorm*cw*eQED**5)/(2._/**/REALKIND*MW*sw**3)
    f( 19) = (countertermnorm*eQED**5*MB*MT)/(cw**2*MW*sw**3*4._/**/REALKIND)
    f( 20) = (CI*eQED**3)/(2._/**/REALKIND*sw**2)
    f( 21) = (CI*countertermnorm*eQED**5)/(2._/**/REALKIND*sw**2)
    f( 22) = (CI*countertermnorm*eQED**5*EWctVbt)/(2._/**/REALKIND*sw**2)
    f( 23) = (CI*countertermnorm*eQED**5*EWctVtb)/(2._/**/REALKIND*sw**2)
    f( 24) = (CI*countertermnorm*eQED**5*EWctZWW)/(2._/**/REALKIND*sw**2)
    f( 25) = (CI*eQED**3*MB)/(2._/**/REALKIND*cw**2*sw**2)
    f( 26) = (CI*countertermnorm*eQED**5*MB)/(3._/**/REALKIND*cw**2*sw**2)
    f( 27) = (CI*countertermnorm*eQED**5*MB)/(2._/**/REALKIND*cw**2*sw**2)
    f( 28) = (CI*eQED**3*MT)/(2._/**/REALKIND*cw**2*sw**2)
    f( 29) = (CI*countertermnorm*eQED**5*MT)/(6._/**/REALKIND*cw**2*sw**2)
    f( 30) = (CI*countertermnorm*eQED**5*MT)/(2._/**/REALKIND*cw**2*sw**2)
    f( 31) = (CI*eQED**3)/(2._/**/REALKIND*MW**2*sw**2)
    f( 32) = (CI*countertermnorm*eQED**5)/(2._/**/REALKIND*MW**2*sw**2)
    f( 33) = (CI*countertermnorm*eQED**5*EWctZPP)/(2._/**/REALKIND*MW**2*sw**2)
    f( 34) = (CI*eQED**3*MB*MT)/(4._/**/REALKIND*MW**2*sw**2)
    f( 35) = (CI*countertermnorm*eQED**5*MB*MT)/(4._/**/REALKIND*MW**2*sw**2)
    f( 36) = (CI*countertermnorm*eQED**5*MB*MT)/(4._/**/REALKIND*cw*MW**2*sw**2)
    f( 37) = (countertermnorm*eQED**5*MB*MT)/(cw*MW**2*sw**2*4._/**/REALKIND)
    f( 38) = (countertermnorm*eQED**5*EWctZXH*MB*MT)/(MW**2*sw**2*4._/**/REALKIND)
    f( 39) = (CI*countertermnorm*eQED**5)/(2._/**/REALKIND*MW*sw**2)
    f( 40) = (CI*countertermnorm*eQED**5*EWctPWZ)/(2._/**/REALKIND*MW*sw**2)
    f( 41) = (countertermnorm*eQED**5*MB)/(cw*MW*sw**2*6._/**/REALKIND)
    f( 42) = (countertermnorm*eQED**5*MB)/(cw*MW*sw**2*4._/**/REALKIND)
    f( 43) = (countertermnorm*eQED**5*MT)/(cw*MW*sw**2*12._/**/REALKIND)
    f( 44) = (countertermnorm*eQED**5*MT)/(cw*MW*sw**2*4._/**/REALKIND)
    f( 45) = (CI*eQED**3)/(2._/**/REALKIND*cw*sw)
    f( 46) = (CI*countertermnorm*eQED**5)/(2._/**/REALKIND*cw*sw)
    f( 47) = (CI*countertermnorm*eQED**5*EWctVbt)/(2._/**/REALKIND*cw*sw)
    f( 48) = (CI*countertermnorm*eQED**5*EWctVtb)/(2._/**/REALKIND*cw*sw)
    f( 49) = (CI*countertermnorm*eQED**5*MB)/(cw**2*sw)
    f( 50) = (CI*countertermnorm*eQED**5*MT)/(cw**2*sw)
    f( 51) = (CI*countertermnorm*eQED**5*MB*MT)/(2._/**/REALKIND*MW**2*sw)
    f( 52) = (countertermnorm*eQED**5*MB*MT)/(MW**2*sw*2._/**/REALKIND)
    f( 53) = (CI*countertermnorm*eQED**5)/(2._/**/REALKIND*cw*MW*sw)
    f( 54) = (countertermnorm*eQED**5*MB)/(MW*sw*3._/**/REALKIND)
    f( 55) = (countertermnorm*eQED**5*MB)/(MW*sw*2._/**/REALKIND)
    f( 56) = (CI*countertermnorm*eQED**5*EWctHZA*MB)/(3._/**/REALKIND*MW*sw)
    f( 57) = (CI*countertermnorm*eQED**5*EWctHZZ*MB)/(2._/**/REALKIND*MW*sw)
    f( 58) = (countertermnorm*eQED**5*MT)/(MW*sw*6._/**/REALKIND)
    f( 59) = (countertermnorm*eQED**5*MT)/(MW*sw*2._/**/REALKIND)
    f( 60) = (CI*countertermnorm*eQED**5*EWctHZA*MT)/(6._/**/REALKIND*MW*sw)
    f( 61) = (CI*countertermnorm*eQED**5*EWctHZZ*MT)/(2._/**/REALKIND*MW*sw)
    f( 62) = (CI*countertermnorm*eQED**5*MW)/(2._/**/REALKIND*cw*sw)
    f( 63) = (CI*countertermnorm*eQED**5)/(MW**2*sqrt2*sw)
    f( 64) = (2*eQED**5*integralnorm*SwB)/81._/**/REALKIND
    f( 65) = (4*eQED**5*integralnorm*SwB)/81._/**/REALKIND
    f( 66) = (8*eQED**5*integralnorm*SwB)/81._/**/REALKIND
    f( 67) = (eQED**5*integralnorm*SwB)/9._/**/REALKIND
    f( 68) = (2*eQED**5*integralnorm*SwB)/9._/**/REALKIND
    f( 69) = (4*eQED**5*integralnorm*SwB)/9._/**/REALKIND
    f( 70) = eQED**5*integralnorm*SwB
    f( 71) = (eQED**5*integralnorm*SwB)/(cw**2*2._/**/REALKIND)
    f( 72) = (eQED**5*integralnorm*MB*SwB)/(cw**2*4._/**/REALKIND)
    f( 73) = (eQED**5*integralnorm*MB*MH**2*SwB)/(cw**2*4._/**/REALKIND)
    f( 74) = (eQED**5*integralnorm*MT*SwB)/(cw**2*4._/**/REALKIND)
    f( 75) = (eQED**5*integralnorm*MH**2*MT*SwB)/(cw**2*4._/**/REALKIND)
    f( 76) = (2*eQED**5*integralnorm*MW**2*SwB)/9._/**/REALKIND
    f( 77) = (eQED**5*integralnorm*MW**2*SwB)/3._/**/REALKIND
    f( 78) = (2*eQED**5*integralnorm*MW**2*SwB)/3._/**/REALKIND
    f( 79) = (eQED**5*integralnorm*MW**2*SwB)/(cw**2*2._/**/REALKIND)
    f( 80) = (eQED**5*integralnorm*MB*MW**2*SwB)/(cw**4*2._/**/REALKIND)
    f( 81) = (eQED**5*integralnorm*MB*MW**2*SwB)/(cw**2*2._/**/REALKIND)
    f( 82) = (eQED**5*integralnorm*MT*MW**2*SwB)/(cw**4*2._/**/REALKIND)
    f( 83) = (eQED**5*integralnorm*MT*MW**2*SwB)/(cw**2*2._/**/REALKIND)
    f( 84) = (eQED**5*integralnorm*SwB)/(cw*sw**5*16._/**/REALKIND)
    f( 85) = (eQED**5*integralnorm*SwB)/(cw*sw**5*8._/**/REALKIND)
    f( 86) = (eQED**5*integralnorm*SwB)/(cw*sw**5*4._/**/REALKIND)
    f( 87) = (cw*eQED**5*integralnorm*SwB)/(sw**5*8._/**/REALKIND)
    f( 88) = (cw*eQED**5*integralnorm*SwB)/(sw**5*4._/**/REALKIND)
    f( 89) = (cw*eQED**5*integralnorm*SwB)/(sw**5*2._/**/REALKIND)
    f( 90) = (cw**3*eQED**5*integralnorm*SwB)/(sw**5*2._/**/REALKIND)
    f( 91) = (eQED**5*integralnorm*MB*SwB)/(cw*sw**5*8._/**/REALKIND)
    f( 92) = (eQED**5*integralnorm*MB*SwB)/(cw*sw**5*4._/**/REALKIND)
    f( 93) = (cw*eQED**5*integralnorm*MB*SwB)/(sw**5*4._/**/REALKIND)
    f( 94) = (eQED**5*integralnorm*MT*SwB)/(cw*sw**5*8._/**/REALKIND)
    f( 95) = (eQED**5*integralnorm*MT*SwB)/(cw*sw**5*4._/**/REALKIND)
    f( 96) = (cw*eQED**5*integralnorm*MT*SwB)/(sw**5*4._/**/REALKIND)
    f( 97) = (eQED**5*integralnorm*MB*MT*SwB)/(cw**5*sw**5*32._/**/REALKIND)
    f( 98) = (eQED**5*integralnorm*MB*MT*SwB)/(cw**5*sw**5*16._/**/REALKIND)
    f( 99) = (eQED**5*integralnorm*MB*MT*SwB)/(cw**5*sw**5*8._/**/REALKIND)
    f(100) = (eQED**5*integralnorm*MB*MT*SwB)/(cw*sw**5*32._/**/REALKIND)
    f(101) = (eQED**5*integralnorm*MB*MT*SwB)/(cw*sw**5*8._/**/REALKIND)
    f(102) = (eQED**5*integralnorm*MB*MT*SwB)/(cw*sw**5*4._/**/REALKIND)
    f(103) = (cw*eQED**5*integralnorm*MB*MT*SwB)/(sw**5*16._/**/REALKIND)
    f(104) = (cw*eQED**5*integralnorm*MB*MT*SwB)/(sw**5*4._/**/REALKIND)
    f(105) = (eQED**5*integralnorm*MB**2*SwB)/(cw*MW**4*sw**5*16._/**/REALKIND)
    f(106) = (eQED**5*integralnorm*MB*MH**2*SwB)/(cw*MW**4*sw**5*16._/**/REALKIND)
    f(107) = (eQED**5*integralnorm*MB*MT*SwB)/(cw*MW**4*sw**5*16._/**/REALKIND)
    f(108) = (eQED**5*integralnorm*MB**3*MT*SwB)/(cw*MW**4*sw**5*32._/**/REALKIND)
    f(109) = (eQED**5*integralnorm*MH**2*MT*SwB)/(cw*MW**4*sw**5*16._/**/REALKIND)
    f(110) = (eQED**5*integralnorm*MB*MH**2*MT*SwB)/(cw*MW**4*sw**5*32._/**/REALKIND)
    f(111) = (eQED**5*integralnorm*MB**2*MH**2*MT*SwB)/(cw*MW**4*sw**5*32._/**/REALKIND)
    f(112) = (3*eQED**5*integralnorm*lambdaHHH*MB**2*MH**2*MT*SwB)/(cw*MW**4*sw**5*32._/**/REALKIND)
    f(113) = (eQED**5*integralnorm*MB*MH**4*MT*SwB)/(cw*MW**4*sw**5*64._/**/REALKIND)
    f(114) = (eQED**5*integralnorm*MB*MH**4*MT*SwB)/(cw*MW**4*sw**5*32._/**/REALKIND)
    f(115) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**4*MT*SwB)/(cw*MW**4*sw**5*32._/**/REALKIND)
    f(116) = (9*eQED**5*integralnorm*lambdaHHH**2*MB*MH**4*MT*SwB)/(cw*MW**4*sw**5*64._/**/REALKIND)
    f(117) = (eQED**5*integralnorm*MT**2*SwB)/(cw*MW**4*sw**5*16._/**/REALKIND)
    f(118) = (eQED**5*integralnorm*MB**2*MT**2*SwB)/(cw*MW**4*sw**5*32._/**/REALKIND)
    f(119) = (eQED**5*integralnorm*MB*MH**2*MT**2*SwB)/(cw*MW**4*sw**5*32._/**/REALKIND)
    f(120) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**2*MT**2*SwB)/(cw*MW**4*sw**5*32._/**/REALKIND)
    f(121) = (eQED**5*integralnorm*MB*MT**3*SwB)/(cw*MW**4*sw**5*32._/**/REALKIND)
    f(122) = (eQED**5*integralnorm*SwB)/(cw*MW**2*sw**5*16._/**/REALKIND)
    f(123) = (cw*eQED**5*integralnorm*SwB)/(MW**2*sw**5*8._/**/REALKIND)
    f(124) = (cw*eQED**5*integralnorm*SwB)/(MW**2*sw**5*4._/**/REALKIND)
    f(125) = (eQED**5*integralnorm*MB*SwB)/(cw*MW**2*sw**5*16._/**/REALKIND)
    f(126) = (cw*eQED**5*integralnorm*MB*SwB)/(MW**2*sw**5*8._/**/REALKIND)
    f(127) = (eQED**5*integralnorm*MB**2*SwB)/(cw*MW**2*sw**5*16._/**/REALKIND)
    f(128) = (cw*eQED**5*integralnorm*MB**2*SwB)/(MW**2*sw**5*8._/**/REALKIND)
    f(129) = (eQED**5*integralnorm*MH**2*SwB)/(cw*MW**2*sw**5*16._/**/REALKIND)
    f(130) = (cw*eQED**5*integralnorm*MH**2*SwB)/(MW**2*sw**5*8._/**/REALKIND)
    f(131) = (eQED**5*integralnorm*MT*SwB)/(cw*MW**2*sw**5*16._/**/REALKIND)
    f(132) = (cw*eQED**5*integralnorm*MT*SwB)/(MW**2*sw**5*8._/**/REALKIND)
    f(133) = (eQED**5*integralnorm*MB*MT*SwB)/(cw**3*MW**2*sw**5*32._/**/REALKIND)
    f(134) = (eQED**5*integralnorm*MB*MT*SwB)/(cw**3*MW**2*sw**5*16._/**/REALKIND)
    f(135) = (eQED**5*integralnorm*MB*MT*SwB)/(cw*MW**2*sw**5*32._/**/REALKIND)
    f(136) = (eQED**5*integralnorm*MB*MT*SwB)/(cw*MW**2*sw**5*16._/**/REALKIND)
    f(137) = (cw*eQED**5*integralnorm*MB*MT*SwB)/(MW**2*sw**5*16._/**/REALKIND)
    f(138) = (cw*eQED**5*integralnorm*MB*MT*SwB)/(MW**2*sw**5*8._/**/REALKIND)
    f(139) = (eQED**5*integralnorm*MB**2*MT*SwB)/(cw**3*MW**2*sw**5*16._/**/REALKIND)
    f(140) = (eQED**5*integralnorm*MB*MH**2*MT*SwB)/(cw**3*MW**2*sw**5*16._/**/REALKIND)
    f(141) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**2*MT*SwB)/(cw**3*MW**2*sw**5*16._/**/REALKIND)
    f(142) = (eQED**5*integralnorm*MT**2*SwB)/(cw*MW**2*sw**5*16._/**/REALKIND)
    f(143) = (cw*eQED**5*integralnorm*MT**2*SwB)/(MW**2*sw**5*8._/**/REALKIND)
    f(144) = (eQED**5*integralnorm*MB*MT**2*SwB)/(cw**3*MW**2*sw**5*16._/**/REALKIND)
    f(145) = (eQED**5*integralnorm*MW**2*SwB)/(cw*sw**5*2._/**/REALKIND)
    f(146) = (cw*eQED**5*integralnorm*MW**2*SwB)/(sw**5*2._/**/REALKIND)
    f(147) = (eQED**5*integralnorm*SwB)/(sw**4*8._/**/REALKIND)
    f(148) = (eQED**5*integralnorm*SwB)/(sw**4*4._/**/REALKIND)
    f(149) = (eQED**5*integralnorm*SwB)/(cw**2*sw**4*4._/**/REALKIND)
    f(150) = (cw**2*eQED**5*integralnorm*SwB)/(sw**4*2._/**/REALKIND)
    f(151) = (eQED**5*integralnorm*MB*SwB)/(sw**4*8._/**/REALKIND)
    f(152) = (eQED**5*integralnorm*MB*SwB)/(sw**4*4._/**/REALKIND)
    f(153) = (eQED**5*integralnorm*MB*SwB)/(sw**4*2._/**/REALKIND)
    f(154) = (eQED**5*integralnorm*MB*SwB)/(cw**4*sw**4*8._/**/REALKIND)
    f(155) = (eQED**5*integralnorm*MB*SwB)/(cw**4*sw**4*4._/**/REALKIND)
    f(156) = (eQED**5*integralnorm*MB*SwB)/(cw**2*sw**4*8._/**/REALKIND)
    f(157) = (eQED**5*integralnorm*MB*SwB)/(cw**2*sw**4*4._/**/REALKIND)
    f(158) = (cw**2*eQED**5*integralnorm*MB*SwB)/(sw**4*4._/**/REALKIND)
    f(159) = (cw**2*eQED**5*integralnorm*MB*SwB)/(sw**4*2._/**/REALKIND)
    f(160) = (eQED**5*integralnorm*MB**2*SwB)/(cw**4*sw**4*4._/**/REALKIND)
    f(161) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**2*SwB)/(cw**4*sw**4*4._/**/REALKIND)
    f(162) = (eQED**5*integralnorm*MT*SwB)/(sw**4*8._/**/REALKIND)
    f(163) = (eQED**5*integralnorm*MT*SwB)/(sw**4*4._/**/REALKIND)
    f(164) = (eQED**5*integralnorm*MT*SwB)/(sw**4*2._/**/REALKIND)
    f(165) = (eQED**5*integralnorm*MT*SwB)/(cw**4*sw**4*8._/**/REALKIND)
    f(166) = (eQED**5*integralnorm*MT*SwB)/(cw**4*sw**4*4._/**/REALKIND)
    f(167) = (eQED**5*integralnorm*MT*SwB)/(cw**2*sw**4*8._/**/REALKIND)
    f(168) = (eQED**5*integralnorm*MT*SwB)/(cw**2*sw**4*4._/**/REALKIND)
    f(169) = (cw**2*eQED**5*integralnorm*MT*SwB)/(sw**4*4._/**/REALKIND)
    f(170) = (cw**2*eQED**5*integralnorm*MT*SwB)/(sw**4*2._/**/REALKIND)
    f(171) = (eQED**5*integralnorm*MB*MT*SwB)/(sw**4*16._/**/REALKIND)
    f(172) = (eQED**5*integralnorm*MB*MT*SwB)/(sw**4*4._/**/REALKIND)
    f(173) = (eQED**5*integralnorm*MB*MT*SwB)/(cw**4*sw**4*16._/**/REALKIND)
    f(174) = (eQED**5*integralnorm*MB*MT*SwB)/(cw**4*sw**4*8._/**/REALKIND)
    f(175) = (eQED**5*integralnorm*MB*MT*SwB)/(cw**4*sw**4*4._/**/REALKIND)
    f(176) = (3*eQED**5*integralnorm*lambdaHHH*MH**2*MT*SwB)/(cw**4*sw**4*4._/**/REALKIND)
    f(177) = (eQED**5*integralnorm*MT**2*SwB)/(cw**4*sw**4*4._/**/REALKIND)
    f(178) = (eQED**5*integralnorm*SwB)/(MW**4*sw**4*4._/**/REALKIND)
    f(179) = (eQED**5*integralnorm*MB**2*SwB)/(MW**4*sw**4*8._/**/REALKIND)
    f(180) = (eQED**5*integralnorm*MB*MH**2*SwB)/(MW**4*sw**4*8._/**/REALKIND)
    f(181) = (eQED**5*integralnorm*MH**4*SwB)/(MW**4*sw**4*8._/**/REALKIND)
    f(182) = (eQED**5*integralnorm*MB*MT*SwB)/(MW**4*sw**4*8._/**/REALKIND)
    f(183) = (eQED**5*integralnorm*MB**3*MT*SwB)/(MW**4*sw**4*16._/**/REALKIND)
    f(184) = (eQED**5*integralnorm*MH**2*MT*SwB)/(MW**4*sw**4*8._/**/REALKIND)
    f(185) = (eQED**5*integralnorm*MB**2*MH**2*MT*SwB)/(MW**4*sw**4*16._/**/REALKIND)
    f(186) = (3*eQED**5*integralnorm*lambdaHHH*MB**2*MH**2*MT*SwB)/(MW**4*sw**4*16._/**/REALKIND)
    f(187) = (eQED**5*integralnorm*MB*MH**4*MT*SwB)/(MW**4*sw**4*32._/**/REALKIND)
    f(188) = (eQED**5*integralnorm*MB*MH**4*MT*SwB)/(MW**4*sw**4*16._/**/REALKIND)
    f(189) = (9*eQED**5*integralnorm*lambdaHHH**2*MB*MH**4*MT*SwB)/(MW**4*sw**4*32._/**/REALKIND)
    f(190) = (eQED**5*integralnorm*MT**2*SwB)/(MW**4*sw**4*8._/**/REALKIND)
    f(191) = (eQED**5*integralnorm*MB**2*MT**2*SwB)/(MW**4*sw**4*16._/**/REALKIND)
    f(192) = (eQED**5*integralnorm*MB*MH**2*MT**2*SwB)/(MW**4*sw**4*16._/**/REALKIND)
    f(193) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**2*MT**2*SwB)/(MW**4*sw**4*16._/**/REALKIND)
    f(194) = (eQED**5*integralnorm*MB*MT**3*SwB)/(MW**4*sw**4*16._/**/REALKIND)
    f(195) = (eQED**5*integralnorm*SwB)/(MW**2*sw**4*8._/**/REALKIND)
    f(196) = (eQED**5*integralnorm*SwB)/(MW**2*sw**4*4._/**/REALKIND)
    f(197) = (eQED**5*integralnorm*MB*SwB)/(MW**2*sw**4*8._/**/REALKIND)
    f(198) = (eQED**5*integralnorm*MB*SwB)/(cw**2*MW**2*sw**4*4._/**/REALKIND)
    f(199) = (eQED**5*integralnorm*MB**2*SwB)/(MW**2*sw**4*8._/**/REALKIND)
    f(200) = (eQED**5*integralnorm*MB**2*SwB)/(cw**2*MW**2*sw**4*16._/**/REALKIND)
    f(201) = (eQED**5*integralnorm*MB**2*SwB)/(cw**2*MW**2*sw**4*8._/**/REALKIND)
    f(202) = (eQED**5*integralnorm*MB**3*SwB)/(cw**2*MW**2*sw**4*8._/**/REALKIND)
    f(203) = (eQED**5*integralnorm*MH**2*SwB)/(MW**2*sw**4*8._/**/REALKIND)
    f(204) = (eQED**5*integralnorm*MH**2*SwB)/(cw**2*MW**2*sw**4*4._/**/REALKIND)
    f(205) = (eQED**5*integralnorm*MB*MH**2*SwB)/(cw**2*MW**2*sw**4*16._/**/REALKIND)
    f(206) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**2*SwB)/(cw**2*MW**2*sw**4*16._/**/REALKIND)
    f(207) = (eQED**5*integralnorm*MB**2*MH**2*SwB)/(cw**2*MW**2*sw**4*8._/**/REALKIND)
    f(208) = (3*eQED**5*integralnorm*lambdaHHH*MB**2*MH**2*SwB)/(cw**2*MW**2*sw**4*8._/**/REALKIND)
    f(209) = (eQED**5*integralnorm*MB*MH**4*SwB)/(cw**2*MW**2*sw**4*16._/**/REALKIND)
    f(210) = (eQED**5*integralnorm*MB*MH**4*SwB)/(cw**2*MW**2*sw**4*8._/**/REALKIND)
    f(211) = (9*eQED**5*integralnorm*lambdaHHH**2*MB*MH**4*SwB)/(cw**2*MW**2*sw**4*16._/**/REALKIND)
    f(212) = (eQED**5*integralnorm*MT*SwB)/(MW**2*sw**4*8._/**/REALKIND)
    f(213) = (eQED**5*integralnorm*MT*SwB)/(cw**2*MW**2*sw**4*4._/**/REALKIND)
    f(214) = (eQED**5*integralnorm*MB*MT*SwB)/(MW**2*sw**4*16._/**/REALKIND)
    f(215) = (eQED**5*integralnorm*MB*MT*SwB)/(MW**2*sw**4*8._/**/REALKIND)
    f(216) = (eQED**5*integralnorm*MB*MT*SwB)/(cw**2*MW**2*sw**4*16._/**/REALKIND)
    f(217) = (eQED**5*integralnorm*MB*MT*SwB)/(cw**2*MW**2*sw**4*8._/**/REALKIND)
    f(218) = (eQED**5*integralnorm*MB**2*MT*SwB)/(cw**2*MW**2*sw**4*8._/**/REALKIND)
    f(219) = (eQED**5*integralnorm*MH**2*MT*SwB)/(cw**2*MW**2*sw**4*16._/**/REALKIND)
    f(220) = (3*eQED**5*integralnorm*lambdaHHH*MH**2*MT*SwB)/(cw**2*MW**2*sw**4*16._/**/REALKIND)
    f(221) = (eQED**5*integralnorm*MB*MH**2*MT*SwB)/(cw**2*MW**2*sw**4*8._/**/REALKIND)
    f(222) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**2*MT*SwB)/(cw**2*MW**2*sw**4*8._/**/REALKIND)
    f(223) = (eQED**5*integralnorm*MH**4*MT*SwB)/(cw**2*MW**2*sw**4*16._/**/REALKIND)
    f(224) = (eQED**5*integralnorm*MH**4*MT*SwB)/(cw**2*MW**2*sw**4*8._/**/REALKIND)
    f(225) = (9*eQED**5*integralnorm*lambdaHHH**2*MH**4*MT*SwB)/(cw**2*MW**2*sw**4*16._/**/REALKIND)
    f(226) = (eQED**5*integralnorm*MT**2*SwB)/(MW**2*sw**4*8._/**/REALKIND)
    f(227) = (eQED**5*integralnorm*MT**2*SwB)/(cw**2*MW**2*sw**4*16._/**/REALKIND)
    f(228) = (eQED**5*integralnorm*MT**2*SwB)/(cw**2*MW**2*sw**4*8._/**/REALKIND)
    f(229) = (eQED**5*integralnorm*MB*MT**2*SwB)/(cw**2*MW**2*sw**4*8._/**/REALKIND)
    f(230) = (eQED**5*integralnorm*MH**2*MT**2*SwB)/(cw**2*MW**2*sw**4*8._/**/REALKIND)
    f(231) = (3*eQED**5*integralnorm*lambdaHHH*MH**2*MT**2*SwB)/(cw**2*MW**2*sw**4*8._/**/REALKIND)
    f(232) = (eQED**5*integralnorm*MT**3*SwB)/(cw**2*MW**2*sw**4*8._/**/REALKIND)
    f(233) = (eQED**5*integralnorm*MW**2*SwB)/(sw**4*2._/**/REALKIND)
    f(234) = (eQED**5*integralnorm*MW**2*SwB)/(cw**2*sw**4*2._/**/REALKIND)
    f(235) = (eQED**5*integralnorm*MB*MW**2*SwB)/(cw**6*sw**4*8._/**/REALKIND)
    f(236) = (eQED**5*integralnorm*MB*MW**2*SwB)/(cw**6*sw**4*4._/**/REALKIND)
    f(237) = (eQED**5*integralnorm*MB*MW**2*SwB)/(cw**6*sw**4*2._/**/REALKIND)
    f(238) = (eQED**5*integralnorm*MB*MW**2*SwB)/(cw**2*sw**4*8._/**/REALKIND)
    f(239) = (eQED**5*integralnorm*MB*MW**2*SwB)/(cw**2*sw**4*2._/**/REALKIND)
    f(240) = (eQED**5*integralnorm*MT*MW**2*SwB)/(cw**6*sw**4*8._/**/REALKIND)
    f(241) = (eQED**5*integralnorm*MT*MW**2*SwB)/(cw**6*sw**4*4._/**/REALKIND)
    f(242) = (eQED**5*integralnorm*MT*MW**2*SwB)/(cw**6*sw**4*2._/**/REALKIND)
    f(243) = (eQED**5*integralnorm*MT*MW**2*SwB)/(cw**2*sw**4*8._/**/REALKIND)
    f(244) = (eQED**5*integralnorm*MT*MW**2*SwB)/(cw**2*sw**4*2._/**/REALKIND)
    f(245) = (eQED**5*integralnorm*SwB)/(cw**3*sw**3*4._/**/REALKIND)
    f(246) = (eQED**5*integralnorm*SwB)/(cw*sw**3*8._/**/REALKIND)
    f(247) = (eQED**5*integralnorm*SwB)/(cw*sw**3*4._/**/REALKIND)
    f(248) = (cw*eQED**5*integralnorm*SwB)/(sw**3*18._/**/REALKIND)
    f(249) = (cw*eQED**5*integralnorm*SwB)/(sw**3*9._/**/REALKIND)
    f(250) = (cw*eQED**5*integralnorm*SwB)/(sw**3*6._/**/REALKIND)
    f(251) = (2*cw*eQED**5*integralnorm*SwB)/(sw**3*9._/**/REALKIND)
    f(252) = (cw*eQED**5*integralnorm*SwB)/(sw**3*3._/**/REALKIND)
    f(253) = (cw*eQED**5*integralnorm*SwB)/(sw**3*2._/**/REALKIND)
    f(254) = (cw**3*eQED**5*integralnorm*SwB)/sw**3
    f(255) = (eQED**5*integralnorm*MB*SwB)/(cw**3*sw**3*4._/**/REALKIND)
    f(256) = (eQED**5*integralnorm*MB*SwB)/(cw*sw**3*12._/**/REALKIND)
    f(257) = (eQED**5*integralnorm*MB*SwB)/(cw*sw**3*8._/**/REALKIND)
    f(258) = (eQED**5*integralnorm*MB*SwB)/(cw*sw**3*6._/**/REALKIND)
    f(259) = (eQED**5*integralnorm*MB*SwB)/(cw*sw**3*4._/**/REALKIND)
    f(260) = (eQED**5*integralnorm*MB*SwB)/(cw*sw**3*3._/**/REALKIND)
    f(261) = (cw*eQED**5*integralnorm*MB*SwB)/(sw**3*6._/**/REALKIND)
    f(262) = (cw*eQED**5*integralnorm*MB*SwB)/(sw**3*4._/**/REALKIND)
    f(263) = (cw*eQED**5*integralnorm*MB*SwB)/(sw**3*3._/**/REALKIND)
    f(264) = (cw*eQED**5*integralnorm*MB*SwB)/(sw**3*2._/**/REALKIND)
    f(265) = (eQED**5*integralnorm*MH**2*SwB)/(cw**3*sw**3*4._/**/REALKIND)
    f(266) = (eQED**5*integralnorm*MH**2*SwB)/(cw*sw**3*8._/**/REALKIND)
    f(267) = (eQED**5*integralnorm*MH**2*SwB)/(cw*sw**3*4._/**/REALKIND)
    f(268) = (eQED**5*integralnorm*MT*SwB)/(cw**3*sw**3*4._/**/REALKIND)
    f(269) = (eQED**5*integralnorm*MT*SwB)/(cw*sw**3*24._/**/REALKIND)
    f(270) = (eQED**5*integralnorm*MT*SwB)/(cw*sw**3*12._/**/REALKIND)
    f(271) = (eQED**5*integralnorm*MT*SwB)/(cw*sw**3*8._/**/REALKIND)
    f(272) = (eQED**5*integralnorm*MT*SwB)/(cw*sw**3*6._/**/REALKIND)
    f(273) = (eQED**5*integralnorm*MT*SwB)/(cw*sw**3*4._/**/REALKIND)
    f(274) = (cw*eQED**5*integralnorm*MT*SwB)/(sw**3*12._/**/REALKIND)
    f(275) = (cw*eQED**5*integralnorm*MT*SwB)/(sw**3*6._/**/REALKIND)
    f(276) = (cw*eQED**5*integralnorm*MT*SwB)/(sw**3*4._/**/REALKIND)
    f(277) = (cw*eQED**5*integralnorm*MT*SwB)/(sw**3*2._/**/REALKIND)
    f(278) = (eQED**5*integralnorm*MB*MT*SwB)/(cw**3*sw**3*8._/**/REALKIND)
    f(279) = (eQED**5*integralnorm*MB*MT*SwB)/(cw*sw**3*8._/**/REALKIND)
    f(280) = (eQED**5*integralnorm*SwB)/(cw*MW**2*sw**3*8._/**/REALKIND)
    f(281) = (eQED**5*integralnorm*SwB)/(cw*MW**2*sw**3*4._/**/REALKIND)
    f(282) = (eQED**5*integralnorm*MB*SwB)/(cw*MW**2*sw**3*8._/**/REALKIND)
    f(283) = (eQED**5*integralnorm*MB**2*SwB)/(cw*MW**2*sw**3*36._/**/REALKIND)
    f(284) = (eQED**5*integralnorm*MB**2*SwB)/(cw*MW**2*sw**3*8._/**/REALKIND)
    f(285) = (eQED**5*integralnorm*MH**2*SwB)/(cw*MW**2*sw**3*8._/**/REALKIND)
    f(286) = (eQED**5*integralnorm*MB*MH**2*SwB)/(cw*MW**2*sw**3*12._/**/REALKIND)
    f(287) = (eQED**5*integralnorm*MB*MH**2*SwB)/(cw*MW**2*sw**3*8._/**/REALKIND)
    f(288) = (eQED**5*integralnorm*MH**4*SwB)/(cw*MW**2*sw**3*8._/**/REALKIND)
    f(289) = (eQED**5*integralnorm*MT*SwB)/(cw*MW**2*sw**3*8._/**/REALKIND)
    f(290) = (eQED**5*integralnorm*MB*MT*SwB)/(cw*MW**2*sw**3*72._/**/REALKIND)
    f(291) = (eQED**5*integralnorm*MB*MT*SwB)/(cw*MW**2*sw**3*36._/**/REALKIND)
    f(292) = (eQED**5*integralnorm*MB*MT*SwB)/(cw*MW**2*sw**3*18._/**/REALKIND)
    f(293) = (eQED**5*integralnorm*MB*MT*SwB)/(cw*MW**2*sw**3*16._/**/REALKIND)
    f(294) = (eQED**5*integralnorm*MB*MT*SwB)/(cw*MW**2*sw**3*8._/**/REALKIND)
    f(295) = (eQED**5*integralnorm*MH**2*MT*SwB)/(cw*MW**2*sw**3*24._/**/REALKIND)
    f(296) = (eQED**5*integralnorm*MH**2*MT*SwB)/(cw*MW**2*sw**3*8._/**/REALKIND)
    f(297) = (eQED**5*integralnorm*MB*MH**2*MT*SwB)/(cw*MW**2*sw**3*16._/**/REALKIND)
    f(298) = (eQED**5*integralnorm*MT**2*SwB)/(cw*MW**2*sw**3*36._/**/REALKIND)
    f(299) = (eQED**5*integralnorm*MT**2*SwB)/(cw*MW**2*sw**3*8._/**/REALKIND)
    f(300) = (eQED**5*integralnorm*MW**2*SwB)/(cw**3*sw**3*4._/**/REALKIND)
    f(301) = (eQED**5*integralnorm*MW**2*SwB)/(cw**3*sw**3*2._/**/REALKIND)
    f(302) = (eQED**5*integralnorm*MW**2*SwB)/(cw*sw**3*4._/**/REALKIND)
    f(303) = (eQED**5*integralnorm*MW**2*SwB)/(cw*sw**3*2._/**/REALKIND)
    f(304) = (eQED**5*integralnorm*MW**2*SwB)/(cw*sw**3)
    f(305) = (cw*eQED**5*integralnorm*MW**2*SwB)/(sw**3*2._/**/REALKIND)
    f(306) = (eQED**5*integralnorm*SwB)/(sw**2*18._/**/REALKIND)
    f(307) = (eQED**5*integralnorm*SwB)/(sw**2*9._/**/REALKIND)
    f(308) = (eQED**5*integralnorm*SwB)/(sw**2*6._/**/REALKIND)
    f(309) = (2*eQED**5*integralnorm*SwB)/(sw**2*9._/**/REALKIND)
    f(310) = (eQED**5*integralnorm*SwB)/(sw**2*3._/**/REALKIND)
    f(311) = (eQED**5*integralnorm*SwB)/(sw**2*2._/**/REALKIND)
    f(312) = (eQED**5*integralnorm*SwB)/(cw**2*sw**2*4._/**/REALKIND)
    f(313) = (cw**2*eQED**5*integralnorm*SwB)/(sw**2*3._/**/REALKIND)
    f(314) = (2*cw**2*eQED**5*integralnorm*SwB)/(sw**2*3._/**/REALKIND)
    f(315) = (cw**2*eQED**5*integralnorm*SwB)/sw**2
    f(316) = (eQED**5*integralnorm*MB*SwB)/(sw**2*6._/**/REALKIND)
    f(317) = (eQED**5*integralnorm*MB*SwB)/(sw**2*4._/**/REALKIND)
    f(318) = (eQED**5*integralnorm*MB*SwB)/(sw**2*3._/**/REALKIND)
    f(319) = (eQED**5*integralnorm*MB*SwB)/(cw**2*sw**2*18._/**/REALKIND)
    f(320) = (eQED**5*integralnorm*MB*SwB)/(cw**2*sw**2*9._/**/REALKIND)
    f(321) = (eQED**5*integralnorm*MB*SwB)/(cw**2*sw**2*8._/**/REALKIND)
    f(322) = (2*eQED**5*integralnorm*MB*SwB)/(cw**2*sw**2*9._/**/REALKIND)
    f(323) = (eQED**5*integralnorm*MB*SwB)/(cw**2*sw**2*2._/**/REALKIND)
    f(324) = (eQED**5*integralnorm*MH**2*SwB)/(cw**2*sw**2*6._/**/REALKIND)
    f(325) = (eQED**5*integralnorm*MH**2*SwB)/(cw**2*sw**2*3._/**/REALKIND)
    f(326) = (eQED**5*integralnorm*MT*SwB)/(sw**2*12._/**/REALKIND)
    f(327) = (eQED**5*integralnorm*MT*SwB)/(sw**2*6._/**/REALKIND)
    f(328) = (eQED**5*integralnorm*MT*SwB)/(sw**2*4._/**/REALKIND)
    f(329) = (eQED**5*integralnorm*MT*SwB)/(cw**2*sw**2*18._/**/REALKIND)
    f(330) = (eQED**5*integralnorm*MT*SwB)/(cw**2*sw**2*9._/**/REALKIND)
    f(331) = (eQED**5*integralnorm*MT*SwB)/(cw**2*sw**2*8._/**/REALKIND)
    f(332) = (2*eQED**5*integralnorm*MT*SwB)/(cw**2*sw**2*9._/**/REALKIND)
    f(333) = (eQED**5*integralnorm*MT*SwB)/(cw**2*sw**2*2._/**/REALKIND)
    f(334) = (eQED**5*integralnorm*SwB)/(MW**2*sw**2*18._/**/REALKIND)
    f(335) = (eQED**5*integralnorm*SwB)/(MW**2*sw**2*9._/**/REALKIND)
    f(336) = (eQED**5*integralnorm*SwB)/(MW**2*sw**2*6._/**/REALKIND)
    f(337) = (2*eQED**5*integralnorm*SwB)/(MW**2*sw**2*9._/**/REALKIND)
    f(338) = (eQED**5*integralnorm*SwB)/(MW**2*sw**2*3._/**/REALKIND)
    f(339) = (eQED**5*integralnorm*SwB)/(MW**2*sw**2*2._/**/REALKIND)
    f(340) = (eQED**5*integralnorm*MB**2*SwB)/(MW**2*sw**2*18._/**/REALKIND)
    f(341) = (eQED**5*integralnorm*MB**2*SwB)/(MW**2*sw**2*4._/**/REALKIND)
    f(342) = (eQED**5*integralnorm*MB*MH**2*SwB)/(MW**2*sw**2*6._/**/REALKIND)
    f(343) = (eQED**5*integralnorm*MB*MT*SwB)/(MW**2*sw**2*36._/**/REALKIND)
    f(344) = (eQED**5*integralnorm*MB*MT*SwB)/(MW**2*sw**2*18._/**/REALKIND)
    f(345) = (eQED**5*integralnorm*MB*MT*SwB)/(MW**2*sw**2*9._/**/REALKIND)
    f(346) = (eQED**5*integralnorm*MB*MT*SwB)/(MW**2*sw**2*4._/**/REALKIND)
    f(347) = (eQED**5*integralnorm*MH**2*MT*SwB)/(MW**2*sw**2*12._/**/REALKIND)
    f(348) = (eQED**5*integralnorm*MT**2*SwB)/(MW**2*sw**2*18._/**/REALKIND)
    f(349) = (eQED**5*integralnorm*MT**2*SwB)/(MW**2*sw**2*4._/**/REALKIND)
    f(350) = (eQED**5*integralnorm*MW**2*SwB)/(sw**2*2._/**/REALKIND)
    f(351) = (eQED**5*integralnorm*MW**2*SwB)/(cw**4*sw**2)
    f(352) = (eQED**5*integralnorm*MW**2*SwB)/(cw**2*sw**2*6._/**/REALKIND)
    f(353) = (eQED**5*integralnorm*MW**2*SwB)/(cw**2*sw**2*3._/**/REALKIND)
    f(354) = (2*eQED**5*integralnorm*MW**2*SwB)/(cw**2*sw**2*3._/**/REALKIND)
    f(355) = (eQED**5*integralnorm*SwB)/(cw*sw*18._/**/REALKIND)
    f(356) = (eQED**5*integralnorm*SwB)/(cw*sw*9._/**/REALKIND)
    f(357) = (eQED**5*integralnorm*SwB)/(cw*sw*6._/**/REALKIND)
    f(358) = (2*eQED**5*integralnorm*SwB)/(cw*sw*9._/**/REALKIND)
    f(359) = (eQED**5*integralnorm*SwB)/(cw*sw*3._/**/REALKIND)
    f(360) = (eQED**5*integralnorm*SwB)/(cw*sw*2._/**/REALKIND)
    f(361) = (2*cw*eQED**5*integralnorm*SwB)/(sw*9._/**/REALKIND)
    f(362) = (cw*eQED**5*integralnorm*SwB)/(sw*3._/**/REALKIND)
    f(363) = (2*cw*eQED**5*integralnorm*SwB)/(sw*3._/**/REALKIND)
    f(364) = (eQED**5*integralnorm*MB*SwB)/(cw*sw*6._/**/REALKIND)
    f(365) = (eQED**5*integralnorm*MB*SwB)/(cw*sw*4._/**/REALKIND)
    f(366) = (eQED**5*integralnorm*MB*MH**2*SwB)/(cw*sw*6._/**/REALKIND)
    f(367) = (eQED**5*integralnorm*MT*SwB)/(cw*sw*12._/**/REALKIND)
    f(368) = (eQED**5*integralnorm*MT*SwB)/(cw*sw*4._/**/REALKIND)
    f(369) = (eQED**5*integralnorm*MH**2*MT*SwB)/(cw*sw*12._/**/REALKIND)
    f(370) = (eQED**5*integralnorm*MW**2*SwB)/(cw**3*sw*2._/**/REALKIND)
    f(371) = (eQED**5*integralnorm*MW**2*SwB)/(cw*sw*6._/**/REALKIND)
    f(372) = (eQED**5*integralnorm*MW**2*SwB)/(cw*sw*3._/**/REALKIND)
    f(373) = (eQED**5*integralnorm*MW**2*SwB)/(cw*sw*2._/**/REALKIND)
    f(374) = (2*cw*eQED**5*integralnorm*MW**2*SwB)/(sw*9._/**/REALKIND)
    f(375) = (eQED**5*integralnorm*MB*MW**2*SwB)/(cw**3*sw*3._/**/REALKIND)
    f(376) = (eQED**5*integralnorm*MB*MW**2*SwB)/(cw*sw*3._/**/REALKIND)
    f(377) = (eQED**5*integralnorm*MT*MW**2*SwB)/(cw**3*sw*6._/**/REALKIND)
    f(378) = (eQED**5*integralnorm*MT*MW**2*SwB)/(cw*sw*6._/**/REALKIND)
    f(379) = (eQED**5*integralnorm*MW**2*sw*SwB)/(cw**3*2._/**/REALKIND)
    f(380) = (2*eQED**5*integralnorm*MW**2*sw*SwB)/(cw*9._/**/REALKIND)
    f(381) = (eQED**5*integralnorm*MW**2*sw*SwB)/(cw*3._/**/REALKIND)
    f(382) = (2*eQED**5*integralnorm*MW**2*sw*SwB)/(cw*3._/**/REALKIND)
    f(383) = (eQED**5*integralnorm*MW**2*sw*SwB)/cw
    f(384) = (eQED**5*integralnorm*MW**2*sw**2*SwB)/(cw**2*3._/**/REALKIND)
    f(385) = (2*eQED**5*integralnorm*MW**2*sw**2*SwB)/(cw**2*3._/**/REALKIND)
    f(386) = (eQED**5*integralnorm*MW**2*sw**2*SwB)/cw**2
    f(387) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw**3*sw**5*8._/**/REALKIND))
    f(388) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*sw**5*16._/**/REALKIND))
    f(389) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*sw**5*8._/**/REALKIND))
    f(390) = -((cw*eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(sw**5*4._/**/REALKIND))
    f(391) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*MW**4*sw**5*8._/**/REALKIND))
    f(392) = -((eQED**5*integralnorm*MB**2*(cw - sw)*(cw + sw)*SwB)/(cw*MW**4*sw**5*16._/**/REALKIND))
    f(393) = -((eQED**5*integralnorm*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw*MW**4*sw**5*8._/**/REALKIND))
    f(394) = -((eQED**5*integralnorm*MB*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw*MW**4*sw**5*16._/**/REALKIND))
    f(395) = -((eQED**5*integralnorm*MH**4*(cw - sw)*(cw + sw)*SwB)/(cw*MW**4*sw**5*16._/**/REALKIND))
    f(396) = -((eQED**5*integralnorm*MB*MT*(cw - sw)*(cw + sw)*SwB)/(cw*MW**4*sw**5*16._/**/REALKIND))
    f(397) = -((eQED**5*integralnorm*MH**2*MT*(cw - sw)*(cw + sw)*SwB)/(cw*MW**4*sw**5*16._/**/REALKIND))
    f(398) = -((eQED**5*integralnorm*MB*MH**2*MT*(cw - sw)*(cw + sw)*SwB)/(cw*MW**4*sw**5*32._/**/REALKIND))
    f(399) = -((eQED**5*integralnorm*MB*MH**4*MT*(cw - sw)*(cw + sw)*SwB)/(cw*MW**4*sw**5*32._/**/REALKIND))
    f(400) = -((eQED**5*integralnorm*MT**2*(cw - sw)*(cw + sw)*SwB)/(cw*MW**4*sw**5*16._/**/REALKIND))
    f(401) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*MW**2*sw**5*16._/**/REALKIND))
    f(402) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*MW**2*sw**5*8._/**/REALKIND))
    f(403) = -((eQED**5*integralnorm*MB*(cw - sw)*(cw + sw)*SwB)/(cw**3*MW**2*sw**5*8._/**/REALKIND))
    f(404) = -((eQED**5*integralnorm*MB*(cw - sw)*(cw + sw)*SwB)/(cw*MW**2*sw**5*16._/**/REALKIND))
    f(405) = -((eQED**5*integralnorm*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw**3*MW**2*sw**5*8._/**/REALKIND))
    f(406) = -((eQED**5*integralnorm*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw*MW**2*sw**5*16._/**/REALKIND))
    f(407) = -((eQED**5*integralnorm*MT*(cw - sw)*(cw + sw)*SwB)/(cw**3*MW**2*sw**5*8._/**/REALKIND))
    f(408) = -((eQED**5*integralnorm*MT*(cw - sw)*(cw + sw)*SwB)/(cw*MW**2*sw**5*16._/**/REALKIND))
    f(409) = -((eQED**5*integralnorm*MB*MT*(cw - sw)*(cw + sw)*SwB)/(cw*MW**2*sw**5*32._/**/REALKIND))
    f(410) = -((eQED**5*integralnorm*MB*MH**2*MT*(cw - sw)*(cw + sw)*SwB)/(cw**3*MW**2*sw**5*16._/**/REALKIND))
    f(411) = (eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw**2*sw**2*4._/**/REALKIND)
    f(412) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(sw**4*4._/**/REALKIND))
    f(413) = (eQED**5*integralnorm*(-cw + sw)*(cw + sw)*SwB)/(cw**2*sw**4*8._/**/REALKIND)
    f(414) = (eQED**5*integralnorm*MB*(cw - sw)*(cw + sw)*SwB)/(cw**2*sw**2*8._/**/REALKIND)
    f(415) = -((eQED**5*integralnorm*MB*SwB*(cw**4*4._/**/REALKIND + sw**4*4._/**/REALKIND  &
      - cw**2*sw**2*8._/**/REALKIND))/(cw**4*sw**4*4._/**/REALKIND*8._/**/REALKIND))
    f(416) = (eQED**5*integralnorm*MT*(cw - sw)*(cw + sw)*SwB)/(cw**2*sw**2*8._/**/REALKIND)
    f(417) = -((eQED**5*integralnorm*MT*SwB*(cw**4*4._/**/REALKIND + sw**4*4._/**/REALKIND  &
      - cw**2*sw**2*8._/**/REALKIND))/(cw**4*sw**4*4._/**/REALKIND*8._/**/REALKIND))
    f(418) = -((eQED**5*integralnorm*SwB*(cw**4*4._/**/REALKIND + sw**4*4._/**/REALKIND  &
      - cw**2*sw**2*8._/**/REALKIND))/(cw**2*MW**2*sw**4*4._/**/REALKIND*8._/**/REALKIND))
    f(419) = -((eQED**5*integralnorm*SwB*(cw**4*2._/**/REALKIND + sw**4*2._/**/REALKIND  &
      - cw**2*sw**2*4._/**/REALKIND))/(cw**2*MW**2*sw**4*2._/**/REALKIND*4._/**/REALKIND))
    f(420) = -((eQED**5*integralnorm*MB*MH**2*SwB*(-(cw**2*sw**2*16._/**/REALKIND) + cw**4*8._/**/REALKIND  &
      + sw**4*8._/**/REALKIND))/(cw**2*MW**2*sw**4*16._/**/REALKIND*8._/**/REALKIND))
    f(421) = -((eQED**5*integralnorm*MB*MH**2*SwB*(cw**4*4._/**/REALKIND + sw**4*4._/**/REALKIND  &
      - cw**2*sw**2*8._/**/REALKIND))/(cw**2*MW**2*sw**4*4._/**/REALKIND*8._/**/REALKIND))
    f(422) = (eQED**5*integralnorm*MB*MH**2*(-cw + sw)*(cw + sw)*SwB)/(cw**2*MW**2*sw**4*16._/**/REALKIND)
    f(423) = -((eQED**5*integralnorm*MH**2*MT*SwB*(-(cw**2*sw**2*16._/**/REALKIND) + cw**4*8._/**/REALKIND  &
      + sw**4*8._/**/REALKIND))/(cw**2*MW**2*sw**4*16._/**/REALKIND*8._/**/REALKIND))
    f(424) = -((eQED**5*integralnorm*MH**2*MT*SwB*(cw**4*4._/**/REALKIND + sw**4*4._/**/REALKIND  &
      - cw**2*sw**2*8._/**/REALKIND))/(cw**2*MW**2*sw**4*4._/**/REALKIND*8._/**/REALKIND))
    f(425) = (eQED**5*integralnorm*MH**2*MT*(-cw + sw)*(cw + sw)*SwB)/(cw**2*MW**2*sw**4*16._/**/REALKIND)
    f(426) = (eQED**5*integralnorm*SwB*(-(cw**2*sw**2*16._/**/REALKIND) + cw**4*8._/**/REALKIND  &
      + sw**4*8._/**/REALKIND))/(cw**3*sw**5*16._/**/REALKIND*8._/**/REALKIND)
    f(427) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*sw**3*12._/**/REALKIND))
    f(428) = (eQED**5*integralnorm*SwB*(cw**4*4._/**/REALKIND + sw**4*4._/**/REALKIND  &
      - cw**2*sw**2*8._/**/REALKIND))/(cw*sw**5*4._/**/REALKIND*8._/**/REALKIND)
    f(429) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*sw**3*6._/**/REALKIND))
    f(430) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*sw**3*4._/**/REALKIND))
    f(431) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*sw**3*2._/**/REALKIND))
    f(432) = -((eQED**5*integralnorm*MB*(cw - sw)*(cw + sw)*SwB)/(cw**3*sw**3*6._/**/REALKIND))
    f(433) = -((eQED**5*integralnorm*MB*(cw - sw)*(cw + sw)*SwB)/(cw*sw**3*12._/**/REALKIND))
    f(434) = -((eQED**5*integralnorm*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw**3*sw**3*4._/**/REALKIND))
    f(435) = -((eQED**5*integralnorm*MT*(cw - sw)*(cw + sw)*SwB)/(cw**3*sw**3*12._/**/REALKIND))
    f(436) = -((eQED**5*integralnorm*MT*(cw - sw)*(cw + sw)*SwB)/(cw*sw**3*24._/**/REALKIND))
    f(437) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*MW**2*sw**3*36._/**/REALKIND))
    f(438) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*MW**2*sw**3*18._/**/REALKIND))
    f(439) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*MW**2*sw**3*12._/**/REALKIND))
    f(440) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*MW**2*sw**3*9._/**/REALKIND))
    f(441) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*MW**2*sw**3*6._/**/REALKIND))
    f(442) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*MW**2*sw**3*4._/**/REALKIND))
    f(443) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*MW**2*sw**3*3._/**/REALKIND))
    f(444) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*MW**2*sw**3*2._/**/REALKIND))
    f(445) = -((eQED**5*integralnorm*MB*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw*MW**2*sw**3*12._/**/REALKIND))
    f(446) = -((eQED**5*integralnorm*MB*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw*MW**2*sw**3*8._/**/REALKIND))
    f(447) = -((eQED**5*integralnorm*MB*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw*MW**2*sw**3*6._/**/REALKIND))
    f(448) = -((eQED**5*integralnorm*MH**2*MT*(cw - sw)*(cw + sw)*SwB)/(cw*MW**2*sw**3*24._/**/REALKIND))
    f(449) = -((eQED**5*integralnorm*MH**2*MT*(cw - sw)*(cw + sw)*SwB)/(cw*MW**2*sw**3*12._/**/REALKIND))
    f(450) = -((eQED**5*integralnorm*MH**2*MT*(cw - sw)*(cw + sw)*SwB)/(cw*MW**2*sw**3*8._/**/REALKIND))
    f(451) = -((eQED**5*integralnorm*MW**2*(cw - sw)*(cw + sw)*SwB)/(cw**3*sw**3*8._/**/REALKIND))
    f(452) = -((eQED**5*integralnorm*MW**2*(cw - sw)*(cw + sw)*SwB)/(cw*sw**3*4._/**/REALKIND))
    f(453) = (eQED**5*integralnorm*SwB*(cw**4*4._/**/REALKIND + sw**4*4._/**/REALKIND  &
      - cw**2*sw**2*8._/**/REALKIND))/(cw**3*sw**3*4._/**/REALKIND*8._/**/REALKIND)
    f(454) = (eQED**5*integralnorm*SwB*(cw**4*2._/**/REALKIND + sw**4*2._/**/REALKIND  &
      - cw**2*sw**2*4._/**/REALKIND))/(cw**3*sw**3*2._/**/REALKIND*4._/**/REALKIND)
    f(455) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw**3*sw*4._/**/REALKIND))
    f(456) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*sw*9._/**/REALKIND))
    f(457) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*sw*6._/**/REALKIND))
    f(458) = (-2*eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*sw*9._/**/REALKIND)
    f(459) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*sw*3._/**/REALKIND))
    f(460) = -((eQED**5*integralnorm*(cw - sw)**3*(cw + sw)**3*SwB)/(cw**3*MW**2*sw**5*16._/**/REALKIND))
    f(461) = -((eQED**5*integralnorm*(cw - sw)**3*(cw + sw)**3*SwB)/(cw**3*MW**2*sw**5*8._/**/REALKIND))
    f(462) = -((eQED**5*integralnorm*MW**2*(cw - sw)*(cw + sw)*SwB)/(cw**3*sw*4._/**/REALKIND))
    f(463) = -((eQED**5*integralnorm*MW**2*(cw - sw)*(cw + sw)*SwB)/(cw*sw*9._/**/REALKIND))
    f(464) = (eQED**5*integralnorm*SwB*(-(cw**2*sw**2*12._/**/REALKIND) + cw**4*6._/**/REALKIND  &
      + sw**4*6._/**/REALKIND))/(cw**2*sw**2*12._/**/REALKIND*6._/**/REALKIND)
    f(465) = (eQED**5*integralnorm*SwB*(cw**4*3._/**/REALKIND + sw**4*3._/**/REALKIND  &
      - cw**2*sw**2*6._/**/REALKIND))/(cw**2*sw**2*3._/**/REALKIND*6._/**/REALKIND)
    f(466) = (eQED**5*integralnorm*SwB*(cw**4*2._/**/REALKIND + sw**4*2._/**/REALKIND  &
      - cw**2*sw**2*4._/**/REALKIND))/(cw**2*sw**2*2._/**/REALKIND*4._/**/REALKIND)
    f(467) = (eQED**5*integralnorm*(cw - sw)**2*(cw + sw)**2*SwB)/(cw**2*sw**2*3._/**/REALKIND)
    f(468) = -((eQED**5*integralnorm*MW**2*(cw - sw)*(cw + sw)*SwB)/(cw**2*6._/**/REALKIND))
    f(469) = -((eQED**5*integralnorm*MW**2*(cw - sw)*(cw + sw)*SwB)/(cw**2*3._/**/REALKIND))
    f(470) = -((eQED**5*integralnorm*(cw - sw)**3*(cw + sw)**3*SwB)/(cw**3*sw**3*8._/**/REALKIND))
    f(471) = -((eQED**5*integralnorm*(cw - sw)**3*(cw + sw)**3*SwB)/(cw**3*sw**3*4._/**/REALKIND))
    f(472) = -((eQED**5*integralnorm*MW**2*(cw - sw)*sw*(cw + sw)*SwB)/(cw**3*2._/**/REALKIND))
    f(473) = (2*eQED**5*integralnorm*SwF)/81._/**/REALKIND
    f(474) = (4*eQED**5*integralnorm*SwF)/81._/**/REALKIND
    f(475) = (8*eQED**5*integralnorm*SwF)/81._/**/REALKIND
    f(476) = (eQED**5*integralnorm*SwF)/9._/**/REALKIND
    f(477) = (16*eQED**5*integralnorm*SwF)/81._/**/REALKIND
    f(478) = (2*eQED**5*integralnorm*SwF)/9._/**/REALKIND
    f(479) = (eQED**5*integralnorm*SwF)/3._/**/REALKIND
    f(480) = (4*eQED**5*integralnorm*SwF)/9._/**/REALKIND
    f(481) = (2*eQED**5*integralnorm*SwF)/3._/**/REALKIND
    f(482) = (8*eQED**5*integralnorm*SwF)/9._/**/REALKIND
    f(483) = eQED**5*integralnorm*SwF
    f(484) = 2*eQED**5*integralnorm*SwF
    f(485) = 3*eQED**5*integralnorm*SwF
    f(486) = (cw*eQED**5*integralnorm*SwF)/(sw**5*4._/**/REALKIND)
    f(487) = (cw*eQED**5*integralnorm*SwF)/(sw**5*2._/**/REALKIND)
    f(488) = (eQED**5*integralnorm*MB**3*MT*SwF)/(cw*MW**4*sw**5*32._/**/REALKIND)
    f(489) = (eQED**5*integralnorm*MB*ME**2*MT*SwF)/(cw*MW**4*sw**5*32._/**/REALKIND)
    f(490) = (eQED**5*integralnorm*MB*ML**2*MT*SwF)/(cw*MW**4*sw**5*32._/**/REALKIND)
    f(491) = (eQED**5*integralnorm*MB*MM**2*MT*SwF)/(cw*MW**4*sw**5*32._/**/REALKIND)
    f(492) = (eQED**5*integralnorm*MB*MT**3*SwF)/(cw*MW**4*sw**5*32._/**/REALKIND)
    f(493) = (cw*eQED**5*integralnorm*SwF)/(MW**2*sw**5*4._/**/REALKIND)
    f(494) = (cw*eQED**5*integralnorm*ME*SwF)/(MW**2*sw**5*4._/**/REALKIND)
    f(495) = (cw*eQED**5*integralnorm*ML*SwF)/(MW**2*sw**5*4._/**/REALKIND)
    f(496) = (cw*eQED**5*integralnorm*MM*SwF)/(MW**2*sw**5*4._/**/REALKIND)
    f(497) = (eQED**5*integralnorm*SwF)/(sw**4*4._/**/REALKIND)
    f(498) = (eQED**5*integralnorm*SwF)/(sw**4*2._/**/REALKIND)
    f(499) = (eQED**5*integralnorm*SwF)/(MW**4*sw**4*4._/**/REALKIND)
    f(500) = (eQED**5*integralnorm*ME**2*SwF)/(MW**4*sw**4*4._/**/REALKIND)
    f(501) = (eQED**5*integralnorm*ML**2*SwF)/(MW**4*sw**4*4._/**/REALKIND)
    f(502) = (eQED**5*integralnorm*MM**2*SwF)/(MW**4*sw**4*4._/**/REALKIND)
    f(503) = (eQED**5*integralnorm*MB**3*MT*SwF)/(MW**4*sw**4*16._/**/REALKIND)
    f(504) = (eQED**5*integralnorm*MB*ME**2*MT*SwF)/(MW**4*sw**4*16._/**/REALKIND)
    f(505) = (eQED**5*integralnorm*MB*ML**2*MT*SwF)/(MW**4*sw**4*16._/**/REALKIND)
    f(506) = (eQED**5*integralnorm*MB*MM**2*MT*SwF)/(MW**4*sw**4*16._/**/REALKIND)
    f(507) = (eQED**5*integralnorm*MB*MT**3*SwF)/(MW**4*sw**4*16._/**/REALKIND)
    f(508) = (eQED**5*integralnorm*SwF)/(MW**2*sw**4*4._/**/REALKIND)
    f(509) = (eQED**5*integralnorm*MB**3*SwF)/(cw**2*MW**2*sw**4*8._/**/REALKIND)
    f(510) = (eQED**5*integralnorm*ME*SwF)/(MW**2*sw**4*4._/**/REALKIND)
    f(511) = (eQED**5*integralnorm*MB*ME**2*SwF)/(cw**2*MW**2*sw**4*8._/**/REALKIND)
    f(512) = (eQED**5*integralnorm*ML*SwF)/(MW**2*sw**4*4._/**/REALKIND)
    f(513) = (eQED**5*integralnorm*MB*ML**2*SwF)/(cw**2*MW**2*sw**4*8._/**/REALKIND)
    f(514) = (eQED**5*integralnorm*MM*SwF)/(MW**2*sw**4*4._/**/REALKIND)
    f(515) = (eQED**5*integralnorm*MB*MM**2*SwF)/(cw**2*MW**2*sw**4*8._/**/REALKIND)
    f(516) = (eQED**5*integralnorm*MB**2*MT*SwF)/(cw**2*MW**2*sw**4*8._/**/REALKIND)
    f(517) = (eQED**5*integralnorm*MB*ME*MT*SwF)/(cw**2*MW**2*sw**4*8._/**/REALKIND)
    f(518) = (eQED**5*integralnorm*ME**2*MT*SwF)/(cw**2*MW**2*sw**4*8._/**/REALKIND)
    f(519) = (eQED**5*integralnorm*MB*ML*MT*SwF)/(cw**2*MW**2*sw**4*8._/**/REALKIND)
    f(520) = (eQED**5*integralnorm*ML**2*MT*SwF)/(cw**2*MW**2*sw**4*8._/**/REALKIND)
    f(521) = (eQED**5*integralnorm*MB*MM*MT*SwF)/(cw**2*MW**2*sw**4*8._/**/REALKIND)
    f(522) = (eQED**5*integralnorm*MM**2*MT*SwF)/(cw**2*MW**2*sw**4*8._/**/REALKIND)
    f(523) = (eQED**5*integralnorm*MB*MT**2*SwF)/(cw**2*MW**2*sw**4*8._/**/REALKIND)
    f(524) = (eQED**5*integralnorm*MT**3*SwF)/(cw**2*MW**2*sw**4*8._/**/REALKIND)
    f(525) = (eQED**5*integralnorm*SwF)/(cw*sw**3*4._/**/REALKIND)
    f(526) = (eQED**5*integralnorm*SwF)/(cw*sw**3*2._/**/REALKIND)
    f(527) = (eQED**5*integralnorm*ME*SwF)/(cw*sw**3*4._/**/REALKIND)
    f(528) = (eQED**5*integralnorm*ML*SwF)/(cw*sw**3*4._/**/REALKIND)
    f(529) = (eQED**5*integralnorm*MM*SwF)/(cw*sw**3*4._/**/REALKIND)
    f(530) = (eQED**5*integralnorm*SwF)/(cw*MW**2*sw**3*4._/**/REALKIND)
    f(531) = (eQED**5*integralnorm*MB**2*SwF)/(cw*MW**2*sw**3*36._/**/REALKIND)
    f(532) = (eQED**5*integralnorm*MB**2*SwF)/(cw*MW**2*sw**3*8._/**/REALKIND)
    f(533) = (eQED**5*integralnorm*ME*SwF)/(cw*MW**2*sw**3*4._/**/REALKIND)
    f(534) = (eQED**5*integralnorm*MB*ME*SwF)/(cw*MW**2*sw**3*12._/**/REALKIND)
    f(535) = (eQED**5*integralnorm*MB*ME*SwF)/(cw*MW**2*sw**3*8._/**/REALKIND)
    f(536) = (eQED**5*integralnorm*ME**2*SwF)/(cw*MW**2*sw**3*4._/**/REALKIND)
    f(537) = (eQED**5*integralnorm*ML*SwF)/(cw*MW**2*sw**3*4._/**/REALKIND)
    f(538) = (eQED**5*integralnorm*MB*ML*SwF)/(cw*MW**2*sw**3*12._/**/REALKIND)
    f(539) = (eQED**5*integralnorm*MB*ML*SwF)/(cw*MW**2*sw**3*8._/**/REALKIND)
    f(540) = (eQED**5*integralnorm*ML**2*SwF)/(cw*MW**2*sw**3*4._/**/REALKIND)
    f(541) = (eQED**5*integralnorm*MM*SwF)/(cw*MW**2*sw**3*4._/**/REALKIND)
    f(542) = (eQED**5*integralnorm*MB*MM*SwF)/(cw*MW**2*sw**3*12._/**/REALKIND)
    f(543) = (eQED**5*integralnorm*MB*MM*SwF)/(cw*MW**2*sw**3*8._/**/REALKIND)
    f(544) = (eQED**5*integralnorm*MM**2*SwF)/(cw*MW**2*sw**3*4._/**/REALKIND)
    f(545) = (eQED**5*integralnorm*MB*MT*SwF)/(cw*MW**2*sw**3*72._/**/REALKIND)
    f(546) = (eQED**5*integralnorm*MB*MT*SwF)/(cw*MW**2*sw**3*18._/**/REALKIND)
    f(547) = (eQED**5*integralnorm*MB*MT*SwF)/(cw*MW**2*sw**3*8._/**/REALKIND)
    f(548) = (eQED**5*integralnorm*ME*MT*SwF)/(cw*MW**2*sw**3*24._/**/REALKIND)
    f(549) = (eQED**5*integralnorm*ME*MT*SwF)/(cw*MW**2*sw**3*8._/**/REALKIND)
    f(550) = (eQED**5*integralnorm*ML*MT*SwF)/(cw*MW**2*sw**3*24._/**/REALKIND)
    f(551) = (eQED**5*integralnorm*ML*MT*SwF)/(cw*MW**2*sw**3*8._/**/REALKIND)
    f(552) = (eQED**5*integralnorm*MM*MT*SwF)/(cw*MW**2*sw**3*24._/**/REALKIND)
    f(553) = (eQED**5*integralnorm*MM*MT*SwF)/(cw*MW**2*sw**3*8._/**/REALKIND)
    f(554) = (eQED**5*integralnorm*MT**2*SwF)/(cw*MW**2*sw**3*36._/**/REALKIND)
    f(555) = (eQED**5*integralnorm*MT**2*SwF)/(cw*MW**2*sw**3*8._/**/REALKIND)
    f(556) = (eQED**5*integralnorm*MB*SwF)/(cw**2*sw**2*18._/**/REALKIND)
    f(557) = (eQED**5*integralnorm*MB*SwF)/(cw**2*sw**2*9._/**/REALKIND)
    f(558) = (2*eQED**5*integralnorm*MB*SwF)/(cw**2*sw**2*9._/**/REALKIND)
    f(559) = (eQED**5*integralnorm*MB*SwF)/(cw**2*sw**2*3._/**/REALKIND)
    f(560) = (4*eQED**5*integralnorm*MB*SwF)/(cw**2*sw**2*9._/**/REALKIND)
    f(561) = (eQED**5*integralnorm*MB*SwF)/(cw**2*sw**2*2._/**/REALKIND)
    f(562) = (eQED**5*integralnorm*MB*SwF)/(cw**2*sw**2)
    f(563) = (3*eQED**5*integralnorm*MB*SwF)/(cw**2*sw**2*2._/**/REALKIND)
    f(564) = (eQED**5*integralnorm*ME*SwF)/(cw**2*sw**2*6._/**/REALKIND)
    f(565) = (eQED**5*integralnorm*ME*SwF)/(cw**2*sw**2*3._/**/REALKIND)
    f(566) = (eQED**5*integralnorm*ME*SwF)/(cw**2*sw**2*2._/**/REALKIND)
    f(567) = (eQED**5*integralnorm*ML*SwF)/(cw**2*sw**2*6._/**/REALKIND)
    f(568) = (eQED**5*integralnorm*ML*SwF)/(cw**2*sw**2*3._/**/REALKIND)
    f(569) = (eQED**5*integralnorm*ML*SwF)/(cw**2*sw**2*2._/**/REALKIND)
    f(570) = (eQED**5*integralnorm*MM*SwF)/(cw**2*sw**2*6._/**/REALKIND)
    f(571) = (eQED**5*integralnorm*MM*SwF)/(cw**2*sw**2*3._/**/REALKIND)
    f(572) = (eQED**5*integralnorm*MM*SwF)/(cw**2*sw**2*2._/**/REALKIND)
    f(573) = (eQED**5*integralnorm*MT*SwF)/(cw**2*sw**2*18._/**/REALKIND)
    f(574) = (eQED**5*integralnorm*MT*SwF)/(cw**2*sw**2*9._/**/REALKIND)
    f(575) = (eQED**5*integralnorm*MT*SwF)/(cw**2*sw**2*6._/**/REALKIND)
    f(576) = (2*eQED**5*integralnorm*MT*SwF)/(cw**2*sw**2*9._/**/REALKIND)
    f(577) = (eQED**5*integralnorm*MT*SwF)/(cw**2*sw**2*2._/**/REALKIND)
    f(578) = (eQED**5*integralnorm*MT*SwF)/(cw**2*sw**2)
    f(579) = (3*eQED**5*integralnorm*MT*SwF)/(cw**2*sw**2*2._/**/REALKIND)
    f(580) = (eQED**5*integralnorm*MB**2*SwF)/(MW**2*sw**2*18._/**/REALKIND)
    f(581) = (eQED**5*integralnorm*MB**2*SwF)/(MW**2*sw**2*4._/**/REALKIND)
    f(582) = (eQED**5*integralnorm*MB*ME*SwF)/(MW**2*sw**2*6._/**/REALKIND)
    f(583) = (eQED**5*integralnorm*MB*ME*SwF)/(MW**2*sw**2*4._/**/REALKIND)
    f(584) = (eQED**5*integralnorm*MB*ML*SwF)/(MW**2*sw**2*6._/**/REALKIND)
    f(585) = (eQED**5*integralnorm*MB*ML*SwF)/(MW**2*sw**2*4._/**/REALKIND)
    f(586) = (eQED**5*integralnorm*MB*MM*SwF)/(MW**2*sw**2*6._/**/REALKIND)
    f(587) = (eQED**5*integralnorm*MB*MM*SwF)/(MW**2*sw**2*4._/**/REALKIND)
    f(588) = (eQED**5*integralnorm*MB*MT*SwF)/(MW**2*sw**2*36._/**/REALKIND)
    f(589) = (eQED**5*integralnorm*MB*MT*SwF)/(MW**2*sw**2*9._/**/REALKIND)
    f(590) = (eQED**5*integralnorm*MB*MT*SwF)/(MW**2*sw**2*4._/**/REALKIND)
    f(591) = (eQED**5*integralnorm*ME*MT*SwF)/(MW**2*sw**2*12._/**/REALKIND)
    f(592) = (eQED**5*integralnorm*ME*MT*SwF)/(MW**2*sw**2*4._/**/REALKIND)
    f(593) = (eQED**5*integralnorm*ML*MT*SwF)/(MW**2*sw**2*12._/**/REALKIND)
    f(594) = (eQED**5*integralnorm*ML*MT*SwF)/(MW**2*sw**2*4._/**/REALKIND)
    f(595) = (eQED**5*integralnorm*MM*MT*SwF)/(MW**2*sw**2*12._/**/REALKIND)
    f(596) = (eQED**5*integralnorm*MM*MT*SwF)/(MW**2*sw**2*4._/**/REALKIND)
    f(597) = (eQED**5*integralnorm*MT**2*SwF)/(MW**2*sw**2*18._/**/REALKIND)
    f(598) = (eQED**5*integralnorm*MT**2*SwF)/(MW**2*sw**2*4._/**/REALKIND)
    f(599) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwF)/(cw*MW**4*sw**5*8._/**/REALKIND))
    f(600) = -((eQED**5*integralnorm*ME**2*(cw - sw)*(cw + sw)*SwF)/(cw*MW**4*sw**5*8._/**/REALKIND))
    f(601) = -((eQED**5*integralnorm*ML**2*(cw - sw)*(cw + sw)*SwF)/(cw*MW**4*sw**5*8._/**/REALKIND))
    f(602) = -((eQED**5*integralnorm*MM**2*(cw - sw)*(cw + sw)*SwF)/(cw*MW**4*sw**5*8._/**/REALKIND))
    f(603) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwF)/(cw*MW**2*sw**5*8._/**/REALKIND))
    f(604) = -((eQED**5*integralnorm*ME*(cw - sw)*(cw + sw)*SwF)/(cw*MW**2*sw**5*8._/**/REALKIND))
    f(605) = -((eQED**5*integralnorm*ML*(cw - sw)*(cw + sw)*SwF)/(cw*MW**2*sw**5*8._/**/REALKIND))
    f(606) = -((eQED**5*integralnorm*MM*(cw - sw)*(cw + sw)*SwF)/(cw*MW**2*sw**5*8._/**/REALKIND))

  c = [ f(64), f(65), f(66), f(67), f(68), f(69), f(70), f(71), f(72), f(73), f(74), f(75), f(76), f(77), f(78), f(79), f(80) &
    , f(81), f(82), f(83), f(84), f(85), f(86), f(87), f(88), f(89), f(90), f(91), f(92), f(93), f(94), f(95), f(96), f(97), f(98) &
    , f(99), f(100), f(101), f(102), f(103), f(104), f(105), f(106), f(107), f(108), f(109), f(110), f(111), f(112), f(113) &
    , f(114), f(115), f(116), f(117), f(118), f(119), f(120), f(121), f(122), f(123), f(124), f(125), f(126), f(127), f(128) &
    , f(129), f(130), f(131), f(132), f(133), f(134), f(135), f(136), f(137), f(138), f(139), f(140), f(141), f(142), f(143) &
    , f(144), f(145), f(146), f(147), f(148), f(149), f(150), f(151), f(152), f(153), f(154), f(155), f(156), f(157), f(158) &
    , f(159), f(160), f(161), f(162), f(163), f(164), f(165), f(166), f(167), f(168), f(169), f(170), f(171), f(172), f(173) &
    , f(174), f(175), f(176), f(177), f(178), f(179), f(180), f(181), f(182), f(183), f(184), f(185), f(186), f(187), f(188) &
    , f(189), f(190), f(191), f(192), f(193), f(194), f(195), f(196), f(197), f(198), f(199), f(200), f(201), f(202), f(203) &
    , f(204), f(205), f(206), f(207), f(208), f(209), f(210), f(211), f(212), f(213), f(214), f(215), f(216), f(217), f(218) &
    , f(219), f(220), f(221), f(222), f(223), f(224), f(225), f(226), f(227), f(228), f(229), f(230), f(231), f(232), f(233) &
    , f(234), f(235), f(236), f(237), f(238), f(239), f(240), f(241), f(242), f(243), f(244), f(245), f(246), f(247), f(248) &
    , f(249), f(250), f(251), f(252), f(253), f(254), f(255), f(256), f(257), f(258), f(259), f(260), f(261), f(262), f(263) &
    , f(264), f(265), f(266), f(267), f(268), f(269), f(270), f(271), f(272), f(273), f(274), f(275), f(276), f(277), f(278) &
    , f(279), f(280), f(281), f(282), f(283), f(284), f(285), f(286), f(287), f(288), f(289), f(290), f(291), f(292), f(293) &
    , f(294), f(295), f(296), f(297), f(298), f(299), f(300), f(301), f(302), f(303), f(304), f(305), f(306), f(307), f(308) &
    , f(309), f(310), f(311), f(312), f(313), f(314), f(315), f(316), f(317), f(318), f(319), f(320), f(321), f(322), f(323) &
    , f(324), f(325), f(326), f(327), f(328), f(329), f(330), f(331), f(332), f(333), f(334), f(335), f(336), f(337), f(338) &
    , f(339), f(340), f(341), f(342), f(343), f(344), f(345), f(346), f(347), f(348), f(349), f(350), f(351), f(352), f(353) &
    , f(354), f(355), f(356), f(357), f(358), f(359), f(360), f(361), f(362), f(363), f(364), f(365), f(366), f(367), f(368) &
    , f(369), f(370), f(371), f(372), f(373), f(374), f(375), f(376), f(377), f(378), f(379), f(380), f(381), f(382), f(383) &
    , f(384), f(385), f(386), f(387), f(388), f(389), f(390), f(391), f(392), f(393), f(394), f(395), f(396), f(397), f(398) &
    , f(399), f(400), f(401), f(402), f(403), f(404), f(405), f(406), f(407), f(408), f(409), f(410), f(411), f(412), f(413) &
    , f(414), f(415), f(416), f(417), f(418), f(419), f(420), f(421), f(422), f(423), f(424), f(425), f(426), f(427), f(428) &
    , f(429), f(430), f(431), f(432), f(433), f(434), f(435), f(436), f(437), f(438), f(439), f(440), f(441), f(442), f(443) &
    , f(444), f(445), f(446), f(447), f(448), f(449), f(450), f(451), f(452), f(453), f(454), f(455), f(456), f(457), f(458) &
    , f(459), f(460), f(461), f(462), f(463), f(464), f(465), f(466), f(467), f(468), f(469), f(470), f(471), f(472), 3*f(473) &
    , 3*f(474), 3*f(475), 3*f(476), 3*f(477), f(478), 3*f(478), f(479), 3*f(480), f(481), 3*f(482), f(483), 3*f(483), 3*f(484) &
    , f(485), f(486), 3*f(486), 3*f(487), 3*f(488), f(489), f(490), f(491), 3*f(492), 3*f(493), f(494), f(495), f(496), f(497) &
    , 3*f(497), 3*f(498), 3*f(499), f(500), f(501), f(502), 3*f(503), f(504), f(505), f(506), 3*f(507), 3*f(508), 3*f(509), f(510) &
    , f(511), f(512), f(513), f(514), f(515), 3*f(516), f(517), f(518), f(519), f(520), f(521), f(522), 3*f(523), 3*f(524), f(525) &
    , 3*f(525), 3*f(526), f(527), f(528), f(529), 3*f(530), 3*f(531), 3*f(532), f(533), f(534), f(535), f(536), f(537), f(538) &
    , f(539), f(540), f(541), f(542), f(543), f(544), 3*f(545), 3*f(546), 3*f(547), f(548), f(549), f(550), f(551), f(552), f(553) &
    , 3*f(554), 3*f(555), 3*f(556), 3*f(557), 3*f(558), f(559), 3*f(560), f(561), 3*f(561), 3*f(562), f(563), f(564), f(565) &
    , f(566), f(567), f(568), f(569), f(570), f(571), f(572), 3*f(573), 3*f(574), f(575), 3*f(576), f(577), 3*f(577), 3*f(578) &
    , f(579), 3*f(580), 3*f(581), f(582), f(583), f(584), f(585), f(586), f(587), 3*f(588), 3*f(589), 3*f(590), f(591), f(592) &
    , f(593), f(594), f(595), f(596), 3*f(597), 3*f(598), 3*f(599), f(600), f(601), f(602), 3*f(603), f(604), f(605), f(606) ]
end subroutine fac_init_loop

subroutine denominators()
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_momenta_decl_/**/REALKIND, only: L
  implicit none
  ! propagators
  den(1) = 1 /((L(5,3) - MH2)+L(6,3))
  den(2) = 1 /((L(5,12) - MZ2)+L(6,12))
  den(4) = 1 /((L(5,3) - MZ2)+L(6,3))
  den(5) = 1 /((L(5,12) - MH2)+L(6,12))
  den(7) = 1 /((L(5,20) - MB2)+L(6,20))
  den(10) = 1 /((L(5,3))+L(6,3))
  den(12) = 1 /((L(5,24) - MB2)+L(6,24))
  den(16) = 1 /((L(5,9) - MW2)+L(6,9))
  den(17) = 1 /((L(5,6) - MW2)+L(6,6))
  den(19) = 1 /((L(5,17) - MT2)+L(6,17))
  den(22) = 1 /((L(5,18) - MT2)+L(6,18))
  den(27) = 1 /((L(5,12))+L(6,12))
  den(34) = 1 /((L(5,28) - MH2)+L(6,28))
  den(37) = 1 /((L(5,28) - MZ2)+L(6,28))
  den(41) = 1 /((L(5,19) - MH2)+L(6,19))
  den(44) = 1 /((L(5,19) - MZ2)+L(6,19))
  den(52) = 1 /((L(5,28))+L(6,28))
  den(57) = 1 /((L(5,11) - MB2)+L(6,11))
  den(72) = 1 /((L(5,7) - MB2)+L(6,7))
  den(79) = 1 /((L(5,22) - MW2)+L(6,22))
  den(82) = 1 /((L(5,25) - MW2)+L(6,25))
  den(85) = 1 /((L(5,14) - MT2)+L(6,14))
  den(96) = 1 /((L(5,13) - MT2)+L(6,13))
  den(114) = 1 /((L(5,19))+L(6,19))

  ! denominators
  den(3) = den(1)*den(2)
  den(6) = den(4)*den(5)
  den(8) = den(1)*den(7)
  den(9) = den(4)*den(7)
  den(11) = den(7)*den(10)
  den(13) = den(1)*den(12)
  den(14) = den(4)*den(12)
  den(15) = den(10)*den(12)
  den(18) = den(16)*den(17)
  den(20) = den(17)*den(19)
  den(21) = den(12)*den(17)
  den(23) = den(16)*den(22)
  den(24) = den(7)*den(16)
  den(25) = den(5)*den(19)
  den(26) = den(2)*den(19)
  den(28) = den(19)*den(27)
  den(29) = den(5)*den(22)
  den(30) = den(2)*den(22)
  den(31) = den(22)*den(27)
  den(32) = den(1)*den(27)
  den(33) = den(5)*den(10)
  den(35) = den(2)*den(34)
  den(36) = den(1)*den(35)
  den(38) = den(5)*den(37)
  den(39) = den(4)*den(38)
  den(40) = den(10)*den(38)
  den(42) = den(4)*den(41)
  den(43) = den(5)*den(42)
  den(45) = den(1)*den(44)
  den(46) = den(2)*den(45)
  den(47) = den(27)*den(45)
  den(48) = den(7)*den(34)
  den(49) = den(1)*den(48)
  den(50) = den(7)*den(37)
  den(51) = den(4)*den(50)
  den(53) = den(7)*den(52)
  den(54) = den(4)*den(53)
  den(55) = den(10)*den(50)
  den(56) = den(10)*den(53)
  den(58) = den(1)*den(57)
  den(59) = den(7)*den(58)
  den(60) = den(4)*den(57)
  den(61) = den(7)*den(60)
  den(62) = den(10)*den(57)
  den(63) = den(7)*den(62)
  den(64) = den(12)*den(34)
  den(65) = den(1)*den(64)
  den(66) = den(12)*den(37)
  den(67) = den(4)*den(66)
  den(68) = den(12)*den(52)
  den(69) = den(4)*den(68)
  den(70) = den(10)*den(66)
  den(71) = den(10)*den(68)
  den(73) = den(1)*den(72)
  den(74) = den(12)*den(73)
  den(75) = den(4)*den(72)
  den(76) = den(12)*den(75)
  den(77) = den(10)*den(72)
  den(78) = den(12)*den(77)
  den(80) = den(17)*den(79)
  den(81) = den(16)*den(80)
  den(83) = den(16)*den(82)
  den(84) = den(17)*den(83)
  den(86) = den(17)*den(85)
  den(87) = den(19)*den(86)
  den(88) = den(19)*den(82)
  den(89) = den(17)*den(88)
  den(90) = den(12)*den(82)
  den(91) = den(17)*den(90)
  den(92) = den(17)*den(72)
  den(93) = den(12)*den(92)
  den(94) = den(22)*den(79)
  den(95) = den(16)*den(94)
  den(97) = den(16)*den(96)
  den(98) = den(22)*den(97)
  den(99) = den(7)*den(79)
  den(100) = den(16)*den(99)
  den(101) = den(16)*den(57)
  den(102) = den(7)*den(101)
  den(103) = den(5)*den(85)
  den(104) = den(19)*den(103)
  den(105) = den(2)*den(85)
  den(106) = den(19)*den(105)
  den(107) = den(27)*den(85)
  den(108) = den(19)*den(107)
  den(109) = den(19)*den(41)
  den(110) = den(5)*den(109)
  den(111) = den(19)*den(44)
  den(112) = den(2)*den(111)
  den(113) = den(27)*den(111)
  den(115) = den(19)*den(114)
  den(116) = den(2)*den(115)
  den(117) = den(27)*den(115)
  den(118) = den(5)*den(96)
  den(119) = den(22)*den(118)
  den(120) = den(2)*den(96)
  den(121) = den(22)*den(120)
  den(122) = den(27)*den(96)
  den(123) = den(22)*den(122)
  den(124) = den(22)*den(41)
  den(125) = den(5)*den(124)
  den(126) = den(22)*den(44)
  den(127) = den(2)*den(126)
  den(128) = den(27)*den(126)
  den(129) = den(22)*den(114)
  den(130) = den(2)*den(129)
  den(131) = den(27)*den(129)
  den(132) = den(1)*den(5)
  den(133) = den(2)*den(4)
  den(134) = den(4)*den(27)
  den(135) = den(2)*den(10)
  den(136) = den(10)*den(27)
  den(137) = den(5)*den(45)
  den(138) = den(2)*den(42)
  den(139) = den(27)*den(42)
  den(140) = den(1)*den(38)
  den(141) = den(4)*den(35)
  den(142) = den(10)*den(35)
  den(143) = den(1)*den(50)
  den(144) = den(4)*den(48)
  den(145) = den(1)*den(53)
  den(146) = den(10)*den(48)
  den(147) = den(1)*den(66)
  den(148) = den(4)*den(64)
  den(149) = den(1)*den(68)
  den(150) = den(10)*den(64)
  den(151) = den(2)*den(109)
  den(152) = den(5)*den(111)
  den(153) = den(27)*den(109)
  den(154) = den(5)*den(115)
  den(155) = den(2)*den(124)
  den(156) = den(5)*den(126)
  den(157) = den(27)*den(124)
  den(158) = den(5)*den(129)

end subroutine denominators

#ifdef PRECISION_dp
! **********************************************************************
subroutine init_merging_tables(tot_num_hels, tot_num_merge_steps)
!-----------------------------------------------------------------------
! In the first event the merging tables are fully initialised
! **********************************************************************
  implicit none
  integer, intent(in) :: tot_num_hels, tot_num_merge_steps
  n_merge_steps = tot_num_merge_steps
  allocate(merge_tables(tot_num_hels,2,n_merge_steps))
  allocate(merge_mism(n_merge_steps+1))
  allocate(merge_hels(n_merge_steps))
  merge_tables_on = .true.
  merge_mism = 0_intkind2
  merge_tables = -1_intkind2
  merge_hels = -1_intkind2
end subroutine init_merging_tables

! **********************************************************************
subroutine update_merging_tables(tot_num_hels)
!-----------------------------------------------------------------------
! After the first evaluation the merging tables are adapted
! **********************************************************************
  implicit none
  integer, intent(in) :: tot_num_hels
  integer(intkind2), allocatable ::  merge_tables_tmp(:,:,:), merge_hels_tmp(:)

  if(merge_mism(1) == 0) then ! helicity configurations match in all merging steps
    if(allocated(merge_tables)) deallocate(merge_tables)
    if(allocated(merge_hels)) deallocate(merge_hels)
    if(allocated(merge_mism)) deallocate(merge_mism)
    allocate(merge_mism(1))
    allocate(merge_hels(1))
    allocate(merge_tables(1,1,1)) ! dummy allocation
    merge_mism = 0_intkind2
    merge_tables = -1_intkind2
    merge_hels = -1_intkind2
  else
    n_merge_mism = merge_mism(1)
    allocate(merge_tables_tmp(tot_num_hels,2,n_merge_mism))
    merge_tables_tmp(:,:,1:n_merge_mism) = merge_tables(:,:,1:n_merge_mism)
    if(allocated(merge_tables)) then
      deallocate(merge_tables)
      allocate(merge_tables(tot_num_hels,2,n_merge_mism))
    end if
    merge_tables = merge_tables_tmp
    if(allocated(merge_tables_tmp)) deallocate(merge_tables_tmp)
    allocate(merge_hels_tmp(n_merge_mism))
    merge_hels_tmp(1:n_merge_mism) = merge_hels(1:n_merge_mism)
    if(allocated(merge_hels)) then
      deallocate(merge_hels)
      allocate(merge_hels(n_merge_mism))
    end if
    merge_hels = merge_hels_tmp
    if(allocated(merge_hels_tmp)) deallocate(merge_hels_tmp)
  end if
  merge_tables_on = .true.
end subroutine update_merging_tables
#endif


!
!
!
! **********************************************************************
#ifdef PRECISION_dp
subroutine amp2(P_scatt, M02, M2ct, M2colint, qp_kinematics)
#else
subroutine amp2(P_scatt, M02, M2ct, M2colint, qp_kinematics)
  use ol_loop_storage_ppztt_ew_ttxbbxz_4_/**/DREALKIND, only: ntry, nhel, Hel
#endif
! P_scatt(0:3,Npart) = incoming external momenta
! M2  = helicity-summed squared matrix element for top anti-top bottom anti-bottom Z -> 0
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND !, only: ci, parameters_status, ZERO, scalefactor, >masses<
  use ol_parameters_init_/**/REALKIND, only: ensure_mp_init
  use ol_kinematics_/**/REALKIND, only: init_kinematics
  use ol_momenta_decl_/**/DREALKIND, only: momenta_nan_check
  use ol_data_types_/**/REALKIND
  use ol_h_helicity_bookkeeping_/**/REALKIND, only: &
    & helbookkeeping_wf, helsync, flip_phase
  use ol_helicity_init, only: helbookkeeping_flip, helsync_flip
  use ol_hel_propagators_/**/REALKIND
  use ol_hel_wavefunctions_/**/REALKIND
  use ol_wavefunctions_/**/REALKIND, only: wf_V_Std
  use ol_hel_vertices_/**/REALKIND
  use ol_hel_contractions_/**/REALKIND
  use ol_external_ppztt_ew_ttxbbxz_4, only: external_perm_ppztt_ew_ttxbbxz_4, &
    & external_perm_inv_ppztt_ew_ttxbbxz_4, extcomb_perm_ppztt_ew_ttxbbxz_4, &
    & average_factor_ppztt_ew_ttxbbxz_4, photonid_ppztt_ew_ttxbbxz_4
  use ol_ew_renormalisation_/**/REALKIND, only: photon_factors
  use ol_external_ppztt_ew_ttxbbxz_4, only: H, hel_not_initialised, hel_init, POLSEL
  use ol_colourmatrix_ppztt_ew_ttxbbxz_4_/**/REALKIND, only: colmat_not_initialised, colourmatrix_init
  use ol_forced_parameters_ppztt_ew_ttxbbxz_4_/**/REALKIND, only: check_forced_parameters
  use ol_heltables_OLR_ppztt_ew_ttxbbxz_4
  use ol_kinematics_/**/REALKIND, only: LC2Std_Rep_cmplx
  use ol_h_counterterms_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND ! counterterms
  use ol_loop_parameters_decl_/**/DREALKIND, only: IR_is_on
  use ol_init, only: set_parameter, parameters_flush
#ifdef PRECISION_dp
  use ol_kinematics_/**/QREALKIND, only: conv_mom_scatt2in_qp=>conv_mom_scatt2in, &
                                         internal_momenta_qp=>internal_momenta
  use ol_momenta_decl_/**/DREALKIND, only: L
  use ol_momenta_decl_/**/QREALKIND, only: L_qp=>L
#endif
  implicit none

  real(DREALKIND), intent(in)  :: P_scatt(0:3,5)
  real(REALKIND),  intent(out) :: M02, M2ct, M2colint(16)
  logical, intent(in) :: qp_kinematics

  integer           :: shift, k, r, m, n, i
  real(REALKIND)    :: P(0:3,5)
#ifdef PRECISION_dp
  real(QREALKIND)    :: P_qp(0:3,5)
#endif
  integer           :: extmasses2(5)
  real(REALKIND)    :: M2add, M2add_ct, M2add_colint(16)
  complex(REALKIND) :: M1(2), M2(2)
  real(REALKIND)    :: P_scatt_intern(0:3,5)
  real(REALKIND), save :: scalebackfactor, old_scalefactor = 0
  real(REALKIND)       :: bornphotonfactor
  integer(intkind1) :: nsync
  type(Hpolcont),   save :: M1helarray(2,48)
  type(Hpolcont) :: M1helarray_ct(2,48)
  integer, allocatable :: extcombs_permuted(:)
  integer              :: extcombs(16), nextcombs
#if 5 > 3
  integer :: ind_cc_comb(5)
#endif
  type(Hpolcont) :: A(48,242)

  !Aj are not used at the moment
  !complex(REALKIND) :: Aj(242)

  complex(REALKIND) :: omega(2) ! phases for helicity correlations

  call set_parameter("ew_renorm", 1)
  call parameters_flush()
  call ensure_mp_init()

  if (colmat_not_initialised) call colourmatrix_init()

  if (fac_status_loop1 /= parameters_status .or. fac_status_loop2 /= loop_parameters_status) then
    ! Note: if fac_init would only be called when parameters changed which are relevant for the factors,
    ! a different 'status' would have to be used, because forced_parameters should be called after every parameter change.
    call check_forced_parameters()
    call fac_init_loop()
  end if

  if (momenta_nan_check(P_scatt) /= 0) then
    M02 = 0
    return
  end if

  extmasses2 = [ nMT, nMT, nMB, nMB, nMZ ]
  ! Convert 2 -> n-2 PS-point to n -> 0 (so that P(1) + ... + P(n) = 0) and compute
  ! internal-propagator momenta in light-cone representation
  call init_kinematics(P_scatt, extmasses2, P, external_perm_inv_ppztt_ew_ttxbbxz_4, 5, qp_kinematics)

  ! denominators
  call denominators()

   if (heltables_not_init) call init_heltables()

  ! external WFs
  ! Here the external wavefunctions are initialiased
  call pol_wf_Q(P(:,1), rMT, H1, ex1, POLSEL(1),1)
  call pol_wf_A(P(:,2), rMT, H2, ex2, POLSEL(2),2)
  call pol_wf_Q(P(:,3), rMB, H3, ex3, POLSEL(3),3)
  call pol_wf_A(P(:,4), rMB, H4, ex4, POLSEL(4),4)
  call pol_wf_V(P(:,5), rMZ, H5, ex5, POLSEL(5),5)



  ! internal WFs
  ! e.g. call vert_VQ_A(ntry, ex3, ex1, wf1, n1, t1) ...
  call vert_AQ_S(gH,ntry, ex2(:), ex1(:), wf4(:,1), n3(:,1), t3x4(:,:,1))
  call vert_AQ_S(gX,ntry, ex4(:), ex3(:), wf4(:,2), n3(:,2), t3x4(:,:,2))
  call vert_TV_S(ntry, wf4(:,1), 3, ex5(:), 16, wf12(:,1), n3(:,3), t3x12(:,:,1))
  call vert_AQ_S(gX,ntry, ex2(:), ex1(:), wf4(:,3), n3(:,4), t3x4(:,:,3))
  call vert_AQ_S(gH,ntry, ex4(:), ex3(:), wf4(:,4), n3(:,5), t3x4(:,:,4))
  call vert_VS_T(ntry, ex5(:), 16, wf4(:,3), 3, wf12(:,2), n3(:,6), t3x12(:,:,2))
  call vert_QA_Z(gZd,ntry, ex3(:), ex4(:), wf4(:,5), n3(:,7), t3x4(:,:,5))
  call vert_SV_V(ntry, wf4(:,1), ex5(:), wf12(:,3), n3(:,8), t3x12(:,:,3))
  call vert_QA_Z(gZu,ntry, ex1(:), ex2(:), wf4(:,6), n3(:,9), t3x4(:,:,6))
  call vert_VV_S(ntry, wf4(:,6), ex5(:), wf12(:,4), n3(:,10), t3x12(:,:,4))
  call vert_ZQ_A(gZd,ntry, ex5(:), ex3(:), wf6(:,1), n3(:,11), t3x6(:,:,1))
  call prop_Q_A(ntry, wf6(:,1), 20, MB, 1_intkind1, wf6(:,2), n2(1))
  call vert_SA_Q(gH,ntry, wf4(:,1), ex4(:), wf8(:,1), n3(:,12), t3x8(:,:,1))
  call vert_SA_Q(gX,ntry, wf4(:,3), ex4(:), wf8(:,2), n3(:,13), t3x8(:,:,2))
  call vert_QA_V(ntry, ex1(:), ex2(:), wf4(:,7), n3(:,14), t3x4(:,:,7))
  call vert_AV_Q(ntry, ex4(:), wf4(:,7), wf8(:,3), n3(:,15), t3x8(:,:,3))
  call vert_AZ_Q(gZd,ntry, ex4(:), wf4(:,6), wf8(:,4), n3(:,16), t3x8(:,:,4))
  call vert_AZ_Q(gZd,ntry, ex4(:), ex5(:), wf6(:,3), n3(:,17), t3x6(:,:,2))
  call prop_A_Q(ntry, wf6(:,3), 24, MB, 1_intkind1, wf6(:,4), n2(2))
  call vert_QS_A(gH,ntry, ex3(:), wf4(:,1), wf8(:,5), n3(:,18), t3x8(:,:,5))
  call vert_QS_A(gX,ntry, ex3(:), wf4(:,3), wf8(:,6), n3(:,19), t3x8(:,:,6))
  call vert_VQ_A(ntry, wf4(:,7), ex3(:), wf8(:,7), n3(:,20), t3x8(:,:,7))
  call vert_ZQ_A(gZd,ntry, wf4(:,6), ex3(:), wf8(:,8), n3(:,21), t3x8(:,:,8))
  call vert_AQ_S(gPbt,ntry, ex4(:), ex1(:), wf4(:,8), n3(:,22), t3x4(:,:,8))
  call vert_AQ_S(gPtb,ntry, ex2(:), ex3(:), wf4(:,9), n3(:,23), t3x4(:,:,9))
  call vert_VS_T(ntry, ex5(:), 16, wf4(:,8), 9, wf12(:,5), n3(:,24), t3x12(:,:,5))
  call vert_QA_W(ntry, ex3(:), ex2(:), wf4(:,10), n3(:,25), t3x4(:,:,10))
  call vert_SV_V(ntry, wf4(:,8), ex5(:), wf12(:,6), n3(:,26), t3x12(:,:,6))
  call vert_QA_W(ntry, ex1(:), ex4(:), wf4(:,11), n3(:,27), t3x4(:,:,11))
  call vert_VV_S(ntry, wf4(:,11), ex5(:), wf12(:,7), n3(:,28), t3x12(:,:,7))
  call vert_UV_W(ntry, ex5(:), 16, wf4(:,11), 9, wf12(:,8), n3(:,29), t3x12(:,:,8))
  call vert_ZQ_A(gZu,ntry, ex5(:), ex1(:), wf6(:,5), n3(:,30), t3x6(:,:,3))
  call prop_Q_A(ntry, wf6(:,5), 17, MT, 1_intkind1, wf6(:,6), n2(3))
  call vert_AQ_S(gPbt,ntry, ex4(:), wf6(:,6), wf12(:,9), n3(:,31), t3x12(:,:,9))
  call vert_QA_W(ntry, wf6(:,6), ex4(:), wf12(:,10), n3(:,32), t3x12(:,:,10))
  call vert_QS_A(gPbt,ntry, ex1(:), wf4(:,9), wf8(:,9), n3(:,33), t3x8(:,:,9))
  call vert_WQ_A(ntry, wf4(:,10), ex1(:), wf8(:,10), n3(:,34), t3x8(:,:,10))
  call vert_AZ_Q(gZu,ntry, ex2(:), ex5(:), wf6(:,7), n3(:,35), t3x6(:,:,4))
  call prop_A_Q(ntry, wf6(:,7), 18, MT, 1_intkind1, wf6(:,8), n2(4))
  call vert_QS_A(gPtb,ntry, ex3(:), wf4(:,8), wf8(:,11), n3(:,36), t3x8(:,:,11))
  call vert_WQ_A(ntry, wf4(:,11), ex3(:), wf8(:,12), n3(:,37), t3x8(:,:,12))
  call vert_SA_Q(gPtb,ntry, wf4(:,8), ex2(:), wf8(:,13), n3(:,38), t3x8(:,:,13))
  call vert_AW_Q(ntry, ex2(:), wf4(:,11), wf8(:,14), n3(:,39), t3x8(:,:,14))
  call vert_AQ_S(gH,ntry, ex2(:), wf6(:,6), wf12(:,11), n3(:,40), t3x12(:,:,11))
  call vert_AQ_S(gX,ntry, ex2(:), wf6(:,6), wf12(:,12), n3(:,41), t3x12(:,:,12))
  call vert_QA_V(ntry, ex3(:), ex4(:), wf4(:,12), n3(:,42), t3x4(:,:,12))
  call vert_QA_V(ntry, wf6(:,6), ex2(:), wf12(:,13), n3(:,43), t3x12(:,:,13))
  call vert_QA_Z(gZu,ntry, wf6(:,6), ex2(:), wf12(:,14), n3(:,44), t3x12(:,:,14))
  call vert_AQ_S(gH,ntry, wf6(:,8), ex1(:), wf12(:,15), n3(:,45), t3x12(:,:,15))
  call vert_AQ_S(gX,ntry, wf6(:,8), ex1(:), wf12(:,16), n3(:,46), t3x12(:,:,16))
  call vert_QA_V(ntry, ex1(:), wf6(:,8), wf12(:,17), n3(:,47), t3x12(:,:,17))
  call vert_QA_Z(gZu,ntry, ex1(:), wf6(:,8), wf12(:,18), n3(:,48), t3x12(:,:,18))
  call counter_TV_S(ntry, wf4(:,1), 3, ex5(:), 16, wf12(:,19), n3(:,49), t3x12(:,:,19))
  call counter_VS_T(ntry, ex5(:), 16, wf4(:,3), 3, wf12(:,20), n3(:,50), t3x12(:,:,20))
  call counter_SV_V(ntry, wf4(:,1), ex5(:), wf12(:,21), n3(:,51), t3x12(:,:,21))
  call counter_VV_S(ntry, wf4(:,7), ex5(:), wf12(:,22), n3(:,52), t3x12(:,:,22))
  call counter_VV_S(ntry, wf4(:,6), ex5(:), wf12(:,23), n3(:,53), t3x12(:,:,23))
  call counter_SA_Q(EWctHbb,ntry, wf4(:,1), ex4(:), wf8(:,15), n3(:,54), t3x8(:,:,15))
  call counter_SA_Q(EWctXbb,ntry, wf4(:,3), ex4(:), wf8(:,16), n3(:,55), t3x8(:,:,16))
  call counter_AV_Q_LR(EWctAbb,ntry, ex4(:), wf4(:,7), wf8(:,17), n3(:,56), t3x8(:,:,17))
  call counter_AZ_Q(EWctVbb,ntry, ex4(:), wf4(:,6), wf8(:,18), n3(:,57), t3x8(:,:,18))
  call counter_AZ_Q(EWctVbb,ntry, ex4(:), ex5(:), wf6(:,9), n3(:,58), t3x6(:,:,5))
  call prop_A_Q(ntry, wf6(:,9), 24, MB, 1_intkind1, wf6(:,10), n2(5))
  call counter_QS_A(EWctHbb,ntry, ex3(:), wf4(:,1), wf8(:,19), n3(:,59), t3x8(:,:,19))
  call counter_QS_A(EWctXbb,ntry, ex3(:), wf4(:,3), wf8(:,20), n3(:,60), t3x8(:,:,20))
  call counter_VQ_A_LR(EWctAbb,ntry, wf4(:,7), ex3(:), wf8(:,21), n3(:,61), t3x8(:,:,21))
  call counter_ZQ_A(EWctVbb,ntry, wf4(:,6), ex3(:), wf8(:,22), n3(:,62), t3x8(:,:,22))
  call counter_ZQ_A(EWctVbb,ntry, ex5(:), ex3(:), wf6(:,11), n3(:,63), t3x6(:,:,6))
  call prop_Q_A(ntry, wf6(:,11), 20, MB, 1_intkind1, wf6(:,12), n2(6))
  call counter_AQ_S(EWctXbb,ntry, ex4(:), ex3(:), wf4(:,13), n3(:,64), t3x4(:,:,13))
  call counter_AQ_S(EWctHbb,ntry, ex4(:), ex3(:), wf4(:,14), n3(:,65), t3x4(:,:,14))
  call counter_QA_Z(EWctVbb,ntry, ex3(:), ex4(:), wf4(:,15), n3(:,66), t3x4(:,:,15))
  call counter_VS_T(ntry, ex5(:), 16, wf4(:,8), 9, wf12(:,24), n3(:,67), t3x12(:,:,24))
  call counter_SV_V(ntry, wf4(:,8), ex5(:), wf12(:,25), n3(:,68), t3x12(:,:,25))
  call counter_VV_S(ntry, wf4(:,11), ex5(:), wf12(:,26), n3(:,69), t3x12(:,:,26))
  call counter_UV_W(ntry, ex5(:), 16, wf4(:,11), 9, wf12(:,27), n3(:,70), t3x12(:,:,27))
  call counter_AQ_S(EWctPbt,ntry, ex4(:), wf6(:,6), wf12(:,28), n3(:,71), t3x12(:,:,28))
  call counter_QA_W(ntry, wf6(:,6), ex4(:), wf12(:,29), n3(:,72), t3x12(:,:,29))
  call counter_QS_A(EWctPtb,ntry, ex3(:), wf4(:,8), wf8(:,23), n3(:,73), t3x8(:,:,23))
  call counter_WQ_A(ntry, wf4(:,11), ex3(:), wf8(:,24), n3(:,74), t3x8(:,:,24))
  call counter_QA_V_LR(EWctAbb,ntry, ex3(:), ex4(:), wf4(:,16), n3(:,75), t3x4(:,:,16))
  call counter_SA_Q(EWctPtb,ntry, wf4(:,8), ex2(:), wf8(:,25), n3(:,76), t3x8(:,:,25))
  call counter_AW_Q(ntry, ex2(:), wf4(:,11), wf8(:,26), n3(:,77), t3x8(:,:,26))
  call counter_AZ_Q(EWctVtt,ntry, ex2(:), ex5(:), wf6(:,13), n3(:,78), t3x6(:,:,7))
  call prop_A_Q(ntry, wf6(:,13), 18, MT, 1_intkind1, wf6(:,14), n2(7))
  call counter_AQ_S(EWctHtt,ntry, ex2(:), wf6(:,6), wf12(:,30), n3(:,79), t3x12(:,:,30))
  call counter_AQ_S(EWctXtt,ntry, ex2(:), wf6(:,6), wf12(:,31), n3(:,80), t3x12(:,:,31))
  call counter_QA_V_LR(EWctAtt,ntry, wf6(:,6), ex2(:), wf12(:,32), n3(:,81), t3x12(:,:,32))
  call counter_QA_Z(EWctVtt,ntry, wf6(:,6), ex2(:), wf12(:,33), n3(:,82), t3x12(:,:,33))
  call vert_AQ_S(gH,ntry, wf6(:,14), ex1(:), wf12(:,34), n3(:,83), t3x12(:,:,34))
  call vert_AQ_S(gX,ntry, wf6(:,14), ex1(:), wf12(:,35), n3(:,84), t3x12(:,:,35))
  call vert_QA_V(ntry, ex1(:), wf6(:,14), wf12(:,36), n3(:,85), t3x12(:,:,36))
  call vert_QA_Z(gZu,ntry, ex1(:), wf6(:,14), wf12(:,37), n3(:,86), t3x12(:,:,37))
  call counter_AQ_S(EWctPtb,ntry, ex2(:), ex3(:), wf4(:,17), n3(:,87), t3x4(:,:,17))
  call counter_QA_W(ntry, ex3(:), ex2(:), wf4(:,18), n3(:,88), t3x4(:,:,18))
  call vert_QS_A(gPbt,ntry, ex1(:), wf4(:,17), wf8(:,27), n3(:,89), t3x8(:,:,27))
  call vert_WQ_A(ntry, wf4(:,18), ex1(:), wf8(:,28), n3(:,90), t3x8(:,:,28))
  call counter_QS_A(EWctPbt,ntry, ex1(:), wf4(:,9), wf8(:,29), n3(:,91), t3x8(:,:,29))
  call counter_WQ_A(ntry, wf4(:,10), ex1(:), wf8(:,30), n3(:,92), t3x8(:,:,30))
  call counter_ZQ_A(EWctVtt,ntry, ex5(:), ex1(:), wf6(:,15), n3(:,93), t3x6(:,:,8))
  call prop_Q_A(ntry, wf6(:,15), 17, MT, 1_intkind1, wf6(:,16), n2(8))
  call vert_AQ_S(gPbt,ntry, ex4(:), wf6(:,16), wf12(:,38), n3(:,94), t3x12(:,:,38))
  call vert_QA_W(ntry, wf6(:,16), ex4(:), wf12(:,39), n3(:,95), t3x12(:,:,39))
  call counter_AQ_S(EWctPbt,ntry, ex4(:), ex1(:), wf4(:,19), n3(:,96), t3x4(:,:,19))
  call vert_VS_T(ntry, ex5(:), 16, wf4(:,19), 9, wf12(:,40), n3(:,97), t3x12(:,:,40))
  call vert_SV_V(ntry, wf4(:,19), ex5(:), wf12(:,41), n3(:,98), t3x12(:,:,41))
  call counter_QA_W(ntry, ex1(:), ex4(:), wf4(:,20), n3(:,99), t3x4(:,:,20))
  call vert_VV_S(ntry, wf4(:,20), ex5(:), wf12(:,42), n3(:,100), t3x12(:,:,42))
  call vert_UV_W(ntry, ex5(:), 16, wf4(:,20), 9, wf12(:,43), n3(:,101), t3x12(:,:,43))
  call counter_AQ_S(EWctHtt,ntry, wf6(:,8), ex1(:), wf12(:,44), n3(:,102), t3x12(:,:,44))
  call counter_AQ_S(EWctXtt,ntry, wf6(:,8), ex1(:), wf12(:,45), n3(:,103), t3x12(:,:,45))
  call counter_QA_V_LR(EWctAtt,ntry, ex1(:), wf6(:,8), wf12(:,46), n3(:,104), t3x12(:,:,46))
  call counter_QA_Z(EWctVtt,ntry, ex1(:), wf6(:,8), wf12(:,47), n3(:,105), t3x12(:,:,47))
  call vert_AQ_S(gH,ntry, ex2(:), wf6(:,16), wf12(:,48), n3(:,106), t3x12(:,:,48))
  call vert_AQ_S(gX,ntry, ex2(:), wf6(:,16), wf12(:,49), n3(:,107), t3x12(:,:,49))
  call vert_QA_V(ntry, wf6(:,16), ex2(:), wf12(:,50), n3(:,108), t3x12(:,:,50))
  call vert_QA_Z(gZu,ntry, wf6(:,16), ex2(:), wf12(:,51), n3(:,109), t3x12(:,:,51))
  call vert_QS_A(gPtb,ntry, ex3(:), wf4(:,19), wf8(:,31), n3(:,110), t3x8(:,:,31))
  call vert_WQ_A(ntry, wf4(:,20), ex3(:), wf8(:,32), n3(:,111), t3x8(:,:,32))
  call vert_SA_Q(gPtb,ntry, wf4(:,19), ex2(:), wf8(:,33), n3(:,112), t3x8(:,:,33))
  call vert_AW_Q(ntry, ex2(:), wf4(:,20), wf8(:,34), n3(:,113), t3x8(:,:,34))
  call counter_AQ_S(EWctHtt,ntry, ex2(:), ex1(:), wf4(:,21), n3(:,114), t3x4(:,:,21))
  call vert_TV_S(ntry, wf4(:,21), 3, ex5(:), 16, wf12(:,52), n3(:,115), t3x12(:,:,52))
  call counter_AQ_S(EWctXtt,ntry, ex2(:), ex1(:), wf4(:,22), n3(:,116), t3x4(:,:,22))
  call vert_VS_T(ntry, ex5(:), 16, wf4(:,22), 3, wf12(:,53), n3(:,117), t3x12(:,:,53))
  call vert_SV_V(ntry, wf4(:,21), ex5(:), wf12(:,54), n3(:,118), t3x12(:,:,54))
  call counter_QA_Z(EWctVtt,ntry, ex1(:), ex2(:), wf4(:,23), n3(:,119), t3x4(:,:,23))
  call vert_VV_S(ntry, wf4(:,23), ex5(:), wf12(:,55), n3(:,120), t3x12(:,:,55))
  call vert_SA_Q(gH,ntry, wf4(:,21), ex4(:), wf8(:,35), n3(:,121), t3x8(:,:,35))
  call vert_SA_Q(gX,ntry, wf4(:,22), ex4(:), wf8(:,36), n3(:,122), t3x8(:,:,36))
  call counter_QA_V_LR(EWctAtt,ntry, ex1(:), ex2(:), wf4(:,24), n3(:,123), t3x4(:,:,24))
  call vert_AV_Q(ntry, ex4(:), wf4(:,24), wf8(:,37), n3(:,124), t3x8(:,:,37))
  call vert_AZ_Q(gZd,ntry, ex4(:), wf4(:,23), wf8(:,38), n3(:,125), t3x8(:,:,38))
  call vert_QS_A(gH,ntry, ex3(:), wf4(:,21), wf8(:,39), n3(:,126), t3x8(:,:,39))
  call vert_QS_A(gX,ntry, ex3(:), wf4(:,22), wf8(:,40), n3(:,127), t3x8(:,:,40))
  call vert_VQ_A(ntry, wf4(:,24), ex3(:), wf8(:,41), n3(:,128), t3x8(:,:,41))
  call vert_ZQ_A(gZd,ntry, wf4(:,23), ex3(:), wf8(:,42), n3(:,129), t3x8(:,:,42))
  call vert_VS_T(ntry, ex5(:), 16, wf4(:,2), 12, wf12(:,56), n3(:,130), t3x12(:,:,56))
  call counter_S_S(EWctHH,ntry, wf4(:,1), 3, wf4(:,25), n2(9))
  call vert_TV_S(ntry, wf4(:,4), 12, ex5(:), 16, wf12(:,57), n3(:,131), t3x12(:,:,57))
  call counter_S_S(EWctXX,ntry, wf4(:,3), 3, wf4(:,26), n2(10))
  call vert_VV_S(ntry, wf4(:,5), ex5(:), wf12(:,58), n3(:,132), t3x12(:,:,58))
  call vert_SV_V(ntry, wf4(:,4), ex5(:), wf12(:,59), n3(:,133), t3x12(:,:,59))
  call counter_S_V(EWctXZ,ntry, wf4(:,3), 3, wf4(:,27), n2(11))
  call counter_V_S(EWctXA,ntry, wf4(:,7), 3, wf4(:,28), n2(12))
  call counter_V_S(EWctXZ,ntry, wf4(:,6), 3, wf4(:,29), n2(13))
  call counter_V_V(EWctAZ,ntry, wf4(:,7), 3, wf4(:,30), n2(14))
  call counter_V_V(EWctZZ,ntry, wf4(:,6), 3, wf4(:,31), n2(15))
  call counter_S_S(EWctHH,ntry, wf4(:,4), 12, wf4(:,32), n2(16))
  call counter_S_S(EWctXX,ntry, wf4(:,2), 12, wf4(:,33), n2(17))
  call counter_S_V(EWctXZ,ntry, wf4(:,2), 12, wf4(:,34), n2(18))
  call counter_V_S(EWctXA,ntry, wf4(:,12), 12, wf4(:,35), n2(19))
  call counter_V_S(EWctXZ,ntry, wf4(:,5), 12, wf4(:,36), n2(20))
  call counter_V_V(EWctAZ,ntry, wf4(:,12), 12, wf4(:,37), n2(21))
  call counter_V_V(EWctZZ,ntry, wf4(:,5), 12, wf4(:,38), n2(22))
  call vert_AQ_S(gH,ntry, ex4(:), wf6(:,2), wf12(:,60), n3(:,134), t3x12(:,:,60))
  call vert_AQ_S(gX,ntry, ex4(:), wf6(:,2), wf12(:,61), n3(:,135), t3x12(:,:,61))
  call vert_QA_V(ntry, wf6(:,2), ex4(:), wf12(:,62), n3(:,136), t3x12(:,:,62))
  call counter_S_V(EWctXA,ntry, wf4(:,3), 3, wf4(:,39), n2(23))
  call vert_QA_Z(gZd,ntry, wf6(:,2), ex4(:), wf12(:,63), n3(:,137), t3x12(:,:,63))
  call counter_V_V(EWctAA,ntry, wf4(:,7), 3, wf4(:,40), n2(24))
  call counter_V_V(EWctAZ,ntry, wf4(:,6), 3, wf4(:,41), n2(25))
  call counter_Q_A_LR(EWctbb,ntry, wf6(:,2), 20, wf6(:,17), n2(26))
  call prop_A_Q(ntry, wf8(:,1), 11, MB, 1_intkind1, wf8(:,43), n2(27))
  call prop_A_Q(ntry, wf8(:,2), 11, MB, 1_intkind1, wf8(:,44), n2(28))
  call prop_A_Q(ntry, wf8(:,3), 11, MB, 1_intkind1, wf8(:,45), n2(29))
  call prop_A_Q(ntry, wf8(:,4), 11, MB, 1_intkind1, wf8(:,46), n2(30))
  call vert_AQ_S(gH,ntry, wf6(:,4), ex3(:), wf12(:,64), n3(:,138), t3x12(:,:,64))
  call vert_AQ_S(gX,ntry, wf6(:,4), ex3(:), wf12(:,65), n3(:,139), t3x12(:,:,65))
  call vert_QA_V(ntry, ex3(:), wf6(:,4), wf12(:,66), n3(:,140), t3x12(:,:,66))
  call vert_QA_Z(gZd,ntry, ex3(:), wf6(:,4), wf12(:,67), n3(:,141), t3x12(:,:,67))
  call counter_A_Q_LR(EWctbb,ntry, wf6(:,4), 24, wf6(:,18), n2(31))
  call prop_Q_A(ntry, wf8(:,5), 7, MB, 1_intkind1, wf8(:,47), n2(32))
  call prop_Q_A(ntry, wf8(:,6), 7, MB, 1_intkind1, wf8(:,48), n2(33))
  call prop_Q_A(ntry, wf8(:,7), 7, MB, 1_intkind1, wf8(:,49), n2(34))
  call prop_Q_A(ntry, wf8(:,8), 7, MB, 1_intkind1, wf8(:,50), n2(35))
  call vert_TV_S(ntry, wf4(:,9), 6, ex5(:), 16, wf12(:,68), n3(:,142), t3x12(:,:,68))
  call counter_S_S(EWctPP,ntry, wf4(:,8), 9, wf4(:,42), n2(36))
  call vert_VV_S(ntry, wf4(:,10), ex5(:), wf12(:,69), n3(:,143), t3x12(:,:,69))
  call vert_SV_V(ntry, wf4(:,9), ex5(:), wf12(:,70), n3(:,144), t3x12(:,:,70))
  call counter_S_V(EWctPW,ntry, wf4(:,8), 9, wf4(:,43), n2(37))
  call vert_UV_W(ntry, wf4(:,10), 6, ex5(:), 16, wf12(:,71), n3(:,145), t3x12(:,:,71))
  call counter_V_S(EWctPW,ntry, wf4(:,11), 9, wf4(:,44), n2(38))
  call counter_V_V(EWctWW,ntry, wf4(:,11), 9, wf4(:,45), n2(39))
  call counter_S_S(EWctPP,ntry, wf4(:,9), 6, wf4(:,46), n2(40))
  call counter_S_V(EWctPW,ntry, wf4(:,9), 6, wf4(:,47), n2(41))
  call counter_V_S(EWctPW,ntry, wf4(:,10), 6, wf4(:,48), n2(42))
  call counter_V_V(EWctWW,ntry, wf4(:,10), 6, wf4(:,49), n2(43))
  call vert_SA_Q(gPbt,ntry, wf4(:,9), ex4(:), wf8(:,51), n3(:,146), t3x8(:,:,43))
  call counter_Q_A_LR(EWcttt,ntry, wf6(:,6), 17, wf6(:,19), n2(44))
  call prop_A_Q(ntry, wf8(:,51), 14, MT, 1_intkind1, wf8(:,52), n2(45))
  call vert_AW_Q(ntry, ex4(:), wf4(:,10), wf8(:,53), n3(:,147), t3x8(:,:,44))
  call prop_A_Q(ntry, wf8(:,53), 14, MT, 1_intkind1, wf8(:,54), n2(46))
  call vert_AQ_S(gPbt,ntry, wf6(:,4), ex1(:), wf12(:,72), n3(:,148), t3x12(:,:,72))
  call vert_QA_W(ntry, ex1(:), wf6(:,4), wf12(:,73), n3(:,149), t3x12(:,:,73))
  call prop_Q_A(ntry, wf8(:,9), 7, MB, 1_intkind1, wf8(:,55), n2(47))
  call prop_Q_A(ntry, wf8(:,10), 7, MB, 1_intkind1, wf8(:,56), n2(48))
  call vert_AQ_S(gPtb,ntry, wf6(:,8), ex3(:), wf12(:,74), n3(:,150), t3x12(:,:,74))
  call vert_QA_W(ntry, ex3(:), wf6(:,8), wf12(:,75), n3(:,151), t3x12(:,:,75))
  call counter_A_Q_LR(EWcttt,ntry, wf6(:,8), 18, wf6(:,20), n2(49))
  call prop_Q_A(ntry, wf8(:,11), 13, MT, 1_intkind1, wf8(:,57), n2(50))
  call prop_Q_A(ntry, wf8(:,12), 13, MT, 1_intkind1, wf8(:,58), n2(51))
  call vert_AQ_S(gPtb,ntry, ex2(:), wf6(:,2), wf12(:,76), n3(:,152), t3x12(:,:,76))
  call vert_QA_W(ntry, wf6(:,2), ex2(:), wf12(:,77), n3(:,153), t3x12(:,:,77))
  call prop_A_Q(ntry, wf8(:,13), 11, MB, 1_intkind1, wf8(:,59), n2(52))
  call prop_A_Q(ntry, wf8(:,14), 11, MB, 1_intkind1, wf8(:,60), n2(53))
  call vert_SA_Q(gH,ntry, wf4(:,4), ex2(:), wf8(:,61), n3(:,154), t3x8(:,:,45))
  call prop_A_Q(ntry, wf8(:,61), 14, MT, 1_intkind1, wf8(:,62), n2(54))
  call vert_SA_Q(gX,ntry, wf4(:,2), ex2(:), wf8(:,63), n3(:,155), t3x8(:,:,46))
  call prop_A_Q(ntry, wf8(:,63), 14, MT, 1_intkind1, wf8(:,64), n2(55))
  call vert_AV_Q(ntry, ex2(:), wf4(:,12), wf8(:,65), n3(:,156), t3x8(:,:,47))
  call prop_A_Q(ntry, wf8(:,65), 14, MT, 1_intkind1, wf8(:,66), n2(56))
  call vert_AZ_Q(gZu,ntry, ex2(:), wf4(:,5), wf8(:,67), n3(:,157), t3x8(:,:,48))
  call prop_A_Q(ntry, wf8(:,67), 14, MT, 1_intkind1, wf8(:,68), n2(57))
  call counter_S_V(EWctXA,ntry, wf4(:,2), 12, wf4(:,50), n2(58))
  call counter_V_V(EWctAA,ntry, wf4(:,12), 12, wf4(:,51), n2(59))
  call counter_V_V(EWctAZ,ntry, wf4(:,5), 12, wf4(:,52), n2(60))
  call vert_QS_A(gH,ntry, ex1(:), wf4(:,4), wf8(:,69), n3(:,158), t3x8(:,:,49))
  call prop_Q_A(ntry, wf8(:,69), 13, MT, 1_intkind1, wf8(:,70), n2(61))
  call vert_QS_A(gX,ntry, ex1(:), wf4(:,2), wf8(:,71), n3(:,159), t3x8(:,:,50))
  call prop_Q_A(ntry, wf8(:,71), 13, MT, 1_intkind1, wf8(:,72), n2(62))
  call vert_VQ_A(ntry, wf4(:,12), ex1(:), wf8(:,73), n3(:,160), t3x8(:,:,51))
  call prop_Q_A(ntry, wf8(:,73), 13, MT, 1_intkind1, wf8(:,74), n2(63))
  call vert_ZQ_A(gZu,ntry, wf4(:,5), ex1(:), wf8(:,75), n3(:,161), t3x8(:,:,52))
  call prop_Q_A(ntry, wf8(:,75), 13, MT, 1_intkind1, wf8(:,76), n2(64))


  call init_hybrid_exwf(ex1)
  call init_hybrid_exwf(ex2)
  call init_hybrid_exwf(ex3)
  call init_hybrid_exwf(ex4)
  call init_hybrid_exwf(ex5)
  call init_hybrid_wf(wf4)
  call init_hybrid_wf(wf6)
  call init_hybrid_wf(wf8)
  call init_hybrid_wf(wf12)


  if (ntry==1) then
    call physical_helicities()
  end if

  ! computation of the colour-stripped amplitudes
  do nsync = ntry+ntry-1, ntry+1  !  nsync = 1,2  for 1st point and nsync = 3 later
    call diagrams()
    if (nsync == 1) call helsync(nsync, A, nhel, Hel)
  end do

  ! In the following loop the coefficients \Gamma_{i} of the expansion in
  ! the colour basis are computed for every helicity state and stored in M1helarray.
  ! Also the colour vector for the Born-loop interference is computed and saved in
  ! M0_col1_helarray
  do k = 1, nhel
    call colourvectors(A, k, M1helarray(:,k),M1helarray_ct(:,k))
    call colborninterf(M1helarray(:,k), M0_col1_helarray(:,k), 0)
  end do
  M1helarray(:,nhel+1:)%j = 0
  M0_col1_helarray(:,nhel+1:)%hf = -1_intkind2
  M0_col1_helarray(:,nhel+1:)%j = 0

  M2add = 0
  M2add_ct = 0
  M2add_colint = 0

  M02 = 0
  M2ct = 0
  M2colint = 0

  do k = 1, nhel
    call colint(M1helarray(:,k)%j, M2add)
    call colint_ct(M1helarray(:,k)%j, M1helarray_ct(:,k)%j, M2add_ct, 0)
    if (IR_is_on > 0) then
      call colint_IR(M1helarray(:,k)%j, M2add_colint)
    end if
    !summation over helicity configurations
    M02 = M02 + M2add
    M2ct = M2ct + M2add_ct
    M2colint = M2colint + M2add_colint
  end do

  call photon_factors(photonid_ppztt_ew_ttxbbxz_4, 0, bornphotonfactor)
  M02 = bornphotonfactor * M02
  M2ct = bornphotonfactor * M2ct
  M2colint = bornphotonfactor * M2colint

  !! used for born-loop colour-correlators
  extcombs = [(i, i = 0, 16-1)]
  nextcombs = 5*(5+1)/2 + 1
  if(nextcombs>0) then
    allocate(extcombs_permuted(nextcombs))
  end if
  do k = 1, nextcombs
    extcombs_permuted(k) = extcomb_perm_ppztt_ew_ttxbbxz_4(extcombs(k))
  end do

#if 1 > 0 && 5 > 3
  !!Born-loop colour correlators interference
ind_cc_comb = [8,12,9,13,14]
  M0M1_hel_cc(:,:,:)%j = 0
  do n = 1, 5
    M2add_ct = 0
    m = ind_cc_comb(n)
      do k = 1, nhel
        call colint_ct(M1helarray(:,k)%j, M1helarray_ct(:,k)%j, M2add_ct, m)
        call colborninterf(M1helarray(:,k), M0M1_hel_cc(:,k,m), m)
        M2ctcc(m) = M2ctcc(m) + M2add_ct
      end do
  end do
  M0M1_hel_cc(:,nhel+1:,:)%hf = -1_intkind2
  M0M1_hel_cc(:,nhel+1:,:)%j = 0
#endif


  contains

subroutine physical_helicities()
  implicit none

integer :: i1,i2,i3,i4,i5
integer :: n

n=0

do i5= 1, 3
do i4= 1, 2
do i3= 1, 2
do i2= 1, 2
do i1= 1, 2
n = n + 1
 if((ex1(i1)%hf==-1_intkind2) .OR. (ex2(i2)%hf==-1_intkind2) .OR. (ex3(i3)%hf==-1_intkind2) .OR. (ex4(i4)%hf==-1_intkind2)  &
    .OR. (ex5(i5)%hf==-1_intkind2)) then
  Hel(n) = -1_intkind2
 else
  Hel(n) = ex1(i1)%hf + ex2(i2)%hf + ex3(i3)%hf + ex4(i4)%hf + ex5(i5)%hf
 end if
end do
end do
end do
end do
end do

end subroutine physical_helicities

subroutine diagrams()
  implicit none
  integer :: h
  ! e.g. call cont_VV(nsync, wf3, wf6, A(:,1), n64, t64, nhel, den(5)) ...

    call Hcont_SS(nsync, wf4(:,2), wf12(:,1), A(:,1), n3(:,162), t3x48(:,:,1), nhel, den(3))
    call Hcont_SS(nsync, wf4(:,4), wf12(:,2), A(:,2), n3(:,163), t3x48(:,:,2), nhel, den(6))
    call Hcont_VV(nsync, wf4(:,5), wf12(:,3), A(:,3), n3(:,164), t3x48(:,:,3), nhel, den(3))
    call Hcont_SS(nsync, wf4(:,4), wf12(:,4), A(:,4), n3(:,165), t3x48(:,:,4), nhel, den(6))
    call Hcont_QA(nsync, wf6(:,2), wf8(:,1), A(:,5), n3(:,166), t3x48(:,:,5), nhel, den(8))
    call Hcont_QA(nsync, wf6(:,2), wf8(:,2), A(:,6), n3(:,167), t3x48(:,:,6), nhel, den(9))
    call Hcont_QA(nsync, wf6(:,2), wf8(:,3), A(:,7), n3(:,168), t3x48(:,:,7), nhel, den(11))
    call Hcont_QA(nsync, wf6(:,2), wf8(:,4), A(:,8), n3(:,169), t3x48(:,:,8), nhel, den(9))
    call Hcont_QA(nsync, wf6(:,4), wf8(:,5), A(:,9), n3(:,170), t3x48(:,:,9), nhel, den(13))
    call Hcont_QA(nsync, wf6(:,4), wf8(:,6), A(:,10), n3(:,171), t3x48(:,:,10), nhel, den(14))
    call Hcont_QA(nsync, wf6(:,4), wf8(:,7), A(:,11), n3(:,172), t3x48(:,:,11), nhel, den(15))
    call Hcont_QA(nsync, wf6(:,4), wf8(:,8), A(:,12), n3(:,173), t3x48(:,:,12), nhel, den(14))
    call Hcont_SS(nsync, wf4(:,9), wf12(:,5), A(:,13), n3(:,174), t3x48(:,:,13), nhel, den(18))
    call Hcont_VV(nsync, wf4(:,10), wf12(:,6), A(:,14), n3(:,175), t3x48(:,:,14), nhel, den(18))
    call Hcont_SS(nsync, wf4(:,9), wf12(:,7), A(:,15), n3(:,176), t3x48(:,:,15), nhel, den(18))
    call Hcont_VV(nsync, wf4(:,10), wf12(:,8), A(:,16), n3(:,177), t3x48(:,:,16), nhel, den(18))
    call Hcont_SS(nsync, wf4(:,9), wf12(:,9), A(:,17), n3(:,178), t3x48(:,:,17), nhel, den(20))
    call Hcont_VV(nsync, wf4(:,10), wf12(:,10), A(:,18), n3(:,179), t3x48(:,:,18), nhel, den(20))
    call Hcont_QA(nsync, wf6(:,4), wf8(:,9), A(:,19), n3(:,180), t3x48(:,:,19), nhel, den(21))
    call Hcont_QA(nsync, wf6(:,4), wf8(:,10), A(:,20), n3(:,181), t3x48(:,:,20), nhel, den(21))
    call Hcont_QA(nsync, wf6(:,8), wf8(:,11), A(:,21), n3(:,182), t3x48(:,:,21), nhel, den(23))
    call Hcont_QA(nsync, wf6(:,8), wf8(:,12), A(:,22), n3(:,183), t3x48(:,:,22), nhel, den(23))
    call Hcont_QA(nsync, wf6(:,2), wf8(:,13), A(:,23), n3(:,184), t3x48(:,:,23), nhel, den(24))
    call Hcont_QA(nsync, wf6(:,2), wf8(:,14), A(:,24), n3(:,185), t3x48(:,:,24), nhel, den(24))
    call Hcont_SS(nsync, wf4(:,4), wf12(:,11), A(:,25), n3(:,186), t3x48(:,:,25), nhel, den(25))
    call Hcont_SS(nsync, wf4(:,2), wf12(:,12), A(:,26), n3(:,187), t3x48(:,:,26), nhel, den(26))
    call Hcont_VV(nsync, wf4(:,12), wf12(:,13), A(:,27), n3(:,188), t3x48(:,:,27), nhel, den(28))
    call Hcont_VV(nsync, wf4(:,5), wf12(:,14), A(:,28), n3(:,189), t3x48(:,:,28), nhel, den(26))
    call Hcont_SS(nsync, wf4(:,4), wf12(:,15), A(:,29), n3(:,190), t3x48(:,:,29), nhel, den(29))
    call Hcont_SS(nsync, wf4(:,2), wf12(:,16), A(:,30), n3(:,191), t3x48(:,:,30), nhel, den(30))
    call Hcont_VV(nsync, wf4(:,12), wf12(:,17), A(:,31), n3(:,192), t3x48(:,:,31), nhel, den(31))
    call Hcont_VV(nsync, wf4(:,5), wf12(:,18), A(:,32), n3(:,193), t3x48(:,:,32), nhel, den(30))

    call Hcont_SS(nsync, wf4(:,2), wf12(:,19), A(:,33), n3(:,194), t3x48(:,:,33), nhel, den(3))
    call Hcont_SS(nsync, wf4(:,4), wf12(:,20), A(:,34), n3(:,195), t3x48(:,:,34), nhel, den(6))
    call Hcont_VV(nsync, wf4(:,12), wf12(:,21), A(:,35), n3(:,196), t3x48(:,:,35), nhel, den(32))
    call Hcont_VV(nsync, wf4(:,5), wf12(:,21), A(:,36), n3(:,197), t3x48(:,:,36), nhel, den(3))
    call Hcont_SS(nsync, wf4(:,4), wf12(:,22), A(:,37), n3(:,198), t3x48(:,:,37), nhel, den(33))
    call Hcont_SS(nsync, wf4(:,4), wf12(:,23), A(:,38), n3(:,199), t3x48(:,:,38), nhel, den(6))
    call Hcont_QA(nsync, wf6(:,2), wf8(:,15), A(:,39), n3(:,200), t3x48(:,:,39), nhel, den(8))
    call Hcont_QA(nsync, wf6(:,2), wf8(:,16), A(:,40), n3(:,201), t3x48(:,:,40), nhel, den(9))
    call Hcont_QA(nsync, wf6(:,2), wf8(:,17), A(:,41), n3(:,202), t3x48(:,:,41), nhel, den(11))
    call Hcont_QA(nsync, wf6(:,2), wf8(:,18), A(:,42), n3(:,203), t3x48(:,:,42), nhel, den(9))
    call Hcont_QA(nsync, wf8(:,5), wf6(:,10), A(:,43), n3(:,204), t3x48(:,:,43), nhel, den(13))
    call Hcont_QA(nsync, wf8(:,6), wf6(:,10), A(:,44), n3(:,205), t3x48(:,:,44), nhel, den(14))
    call Hcont_QA(nsync, wf8(:,7), wf6(:,10), A(:,45), n3(:,206), t3x48(:,:,45), nhel, den(15))
    call Hcont_QA(nsync, wf8(:,8), wf6(:,10), A(:,46), n3(:,207), t3x48(:,:,46), nhel, den(14))
    call Hcont_QA(nsync, wf6(:,4), wf8(:,19), A(:,47), n3(:,208), t3x48(:,:,47), nhel, den(13))
    call Hcont_QA(nsync, wf6(:,4), wf8(:,20), A(:,48), n3(:,209), t3x48(:,:,48), nhel, den(14))
    call Hcont_QA(nsync, wf6(:,4), wf8(:,21), A(:,49), n3(:,210), t3x48(:,:,49), nhel, den(15))
    call Hcont_QA(nsync, wf6(:,4), wf8(:,22), A(:,50), n3(:,211), t3x48(:,:,50), nhel, den(14))
    call Hcont_QA(nsync, wf8(:,1), wf6(:,12), A(:,51), n3(:,212), t3x48(:,:,51), nhel, den(8))
    call Hcont_QA(nsync, wf8(:,2), wf6(:,12), A(:,52), n3(:,213), t3x48(:,:,52), nhel, den(9))
    call Hcont_QA(nsync, wf8(:,3), wf6(:,12), A(:,53), n3(:,214), t3x48(:,:,53), nhel, den(11))
    call Hcont_QA(nsync, wf8(:,4), wf6(:,12), A(:,54), n3(:,215), t3x48(:,:,54), nhel, den(9))
    call Hcont_SS(nsync, wf12(:,1), wf4(:,13), A(:,55), n3(:,216), t3x48(:,:,55), nhel, den(3))
    call Hcont_SS(nsync, wf12(:,2), wf4(:,14), A(:,56), n3(:,217), t3x48(:,:,56), nhel, den(6))
    call Hcont_VV(nsync, wf12(:,3), wf4(:,15), A(:,57), n3(:,218), t3x48(:,:,57), nhel, den(3))
    call Hcont_SS(nsync, wf12(:,4), wf4(:,14), A(:,58), n3(:,219), t3x48(:,:,58), nhel, den(6))
    call Hcont_SS(nsync, wf4(:,9), wf12(:,24), A(:,59), n3(:,220), t3x48(:,:,59), nhel, den(18))
    call Hcont_VV(nsync, wf4(:,10), wf12(:,25), A(:,60), n3(:,221), t3x48(:,:,60), nhel, den(18))
    call Hcont_SS(nsync, wf4(:,9), wf12(:,26), A(:,61), n3(:,222), t3x48(:,:,61), nhel, den(18))
    call Hcont_VV(nsync, wf4(:,10), wf12(:,27), A(:,62), n3(:,223), t3x48(:,:,62), nhel, den(18))
    call Hcont_SS(nsync, wf4(:,9), wf12(:,28), A(:,63), n3(:,224), t3x48(:,:,63), nhel, den(20))
    call Hcont_VV(nsync, wf4(:,10), wf12(:,29), A(:,64), n3(:,225), t3x48(:,:,64), nhel, den(20))
    call Hcont_QA(nsync, wf8(:,9), wf6(:,10), A(:,65), n3(:,226), t3x48(:,:,65), nhel, den(21))
    call Hcont_QA(nsync, wf8(:,10), wf6(:,10), A(:,66), n3(:,227), t3x48(:,:,66), nhel, den(21))
    call Hcont_QA(nsync, wf6(:,8), wf8(:,23), A(:,67), n3(:,228), t3x48(:,:,67), nhel, den(23))
    call Hcont_QA(nsync, wf6(:,8), wf8(:,24), A(:,68), n3(:,229), t3x48(:,:,68), nhel, den(23))
    call Hcont_QA(nsync, wf8(:,13), wf6(:,12), A(:,69), n3(:,230), t3x48(:,:,69), nhel, den(24))
    call Hcont_QA(nsync, wf8(:,14), wf6(:,12), A(:,70), n3(:,231), t3x48(:,:,70), nhel, den(24))
    call Hcont_SS(nsync, wf12(:,11), wf4(:,14), A(:,71), n3(:,232), t3x48(:,:,71), nhel, den(25))
    call Hcont_SS(nsync, wf12(:,12), wf4(:,13), A(:,72), n3(:,233), t3x48(:,:,72), nhel, den(26))
    call Hcont_VV(nsync, wf12(:,13), wf4(:,16), A(:,73), n3(:,234), t3x48(:,:,73), nhel, den(28))
    call Hcont_VV(nsync, wf12(:,14), wf4(:,15), A(:,74), n3(:,235), t3x48(:,:,74), nhel, den(26))
    call Hcont_SS(nsync, wf12(:,15), wf4(:,14), A(:,75), n3(:,236), t3x48(:,:,75), nhel, den(29))
    call Hcont_SS(nsync, wf12(:,16), wf4(:,13), A(:,76), n3(:,237), t3x48(:,:,76), nhel, den(30))
    call Hcont_VV(nsync, wf12(:,17), wf4(:,16), A(:,77), n3(:,238), t3x48(:,:,77), nhel, den(31))
    call Hcont_VV(nsync, wf12(:,18), wf4(:,15), A(:,78), n3(:,239), t3x48(:,:,78), nhel, den(30))
    call Hcont_QA(nsync, wf6(:,2), wf8(:,25), A(:,79), n3(:,240), t3x48(:,:,79), nhel, den(24))
    call Hcont_QA(nsync, wf6(:,2), wf8(:,26), A(:,80), n3(:,241), t3x48(:,:,80), nhel, den(24))
    call Hcont_QA(nsync, wf8(:,11), wf6(:,14), A(:,81), n3(:,242), t3x48(:,:,81), nhel, den(23))
    call Hcont_QA(nsync, wf8(:,12), wf6(:,14), A(:,82), n3(:,243), t3x48(:,:,82), nhel, den(23))
    call Hcont_SS(nsync, wf4(:,4), wf12(:,30), A(:,83), n3(:,244), t3x48(:,:,83), nhel, den(25))
    call Hcont_SS(nsync, wf4(:,2), wf12(:,31), A(:,84), n3(:,245), t3x48(:,:,84), nhel, den(26))
    call Hcont_VV(nsync, wf4(:,12), wf12(:,32), A(:,85), n3(:,246), t3x48(:,:,85), nhel, den(28))
    call Hcont_VV(nsync, wf4(:,5), wf12(:,33), A(:,86), n3(:,247), t3x48(:,:,86), nhel, den(26))
    call Hcont_SS(nsync, wf4(:,4), wf12(:,34), A(:,87), n3(:,248), t3x48(:,:,87), nhel, den(29))
    call Hcont_SS(nsync, wf4(:,2), wf12(:,35), A(:,88), n3(:,249), t3x48(:,:,88), nhel, den(30))
    call Hcont_VV(nsync, wf4(:,12), wf12(:,36), A(:,89), n3(:,250), t3x48(:,:,89), nhel, den(31))
    call Hcont_VV(nsync, wf4(:,5), wf12(:,37), A(:,90), n3(:,251), t3x48(:,:,90), nhel, den(30))
    call Hcont_SS(nsync, wf12(:,5), wf4(:,17), A(:,91), n3(:,252), t3x48(:,:,91), nhel, den(18))
    call Hcont_VV(nsync, wf12(:,6), wf4(:,18), A(:,92), n3(:,253), t3x48(:,:,92), nhel, den(18))
    call Hcont_SS(nsync, wf12(:,7), wf4(:,17), A(:,93), n3(:,254), t3x48(:,:,93), nhel, den(18))
    call Hcont_VV(nsync, wf12(:,8), wf4(:,18), A(:,94), n3(:,255), t3x48(:,:,94), nhel, den(18))
    call Hcont_SS(nsync, wf12(:,9), wf4(:,17), A(:,95), n3(:,256), t3x48(:,:,95), nhel, den(20))
    call Hcont_VV(nsync, wf12(:,10), wf4(:,18), A(:,96), n3(:,257), t3x48(:,:,96), nhel, den(20))
    call Hcont_QA(nsync, wf6(:,4), wf8(:,27), A(:,97), n3(:,258), t3x48(:,:,97), nhel, den(21))
    call Hcont_QA(nsync, wf6(:,4), wf8(:,28), A(:,98), n3(:,259), t3x48(:,:,98), nhel, den(21))
    call Hcont_QA(nsync, wf6(:,4), wf8(:,29), A(:,99), n3(:,260), t3x48(:,:,99), nhel, den(21))
    call Hcont_QA(nsync, wf6(:,4), wf8(:,30), A(:,100), n3(:,261), t3x48(:,:,100), nhel, den(21))
    call Hcont_SS(nsync, wf4(:,9), wf12(:,38), A(:,101), n3(:,262), t3x48(:,:,101), nhel, den(20))
    call Hcont_VV(nsync, wf4(:,10), wf12(:,39), A(:,102), n3(:,263), t3x48(:,:,102), nhel, den(20))
    call Hcont_SS(nsync, wf4(:,9), wf12(:,40), A(:,103), n3(:,264), t3x48(:,:,103), nhel, den(18))
    call Hcont_VV(nsync, wf4(:,10), wf12(:,41), A(:,104), n3(:,265), t3x48(:,:,104), nhel, den(18))
    call Hcont_SS(nsync, wf4(:,9), wf12(:,42), A(:,105), n3(:,266), t3x48(:,:,105), nhel, den(18))
    call Hcont_VV(nsync, wf4(:,10), wf12(:,43), A(:,106), n3(:,267), t3x48(:,:,106), nhel, den(18))
    call Hcont_SS(nsync, wf4(:,4), wf12(:,44), A(:,107), n3(:,268), t3x48(:,:,107), nhel, den(29))
    call Hcont_SS(nsync, wf4(:,2), wf12(:,45), A(:,108), n3(:,269), t3x48(:,:,108), nhel, den(30))
    call Hcont_VV(nsync, wf4(:,12), wf12(:,46), A(:,109), n3(:,270), t3x48(:,:,109), nhel, den(31))
    call Hcont_VV(nsync, wf4(:,5), wf12(:,47), A(:,110), n3(:,271), t3x48(:,:,110), nhel, den(30))
    call Hcont_SS(nsync, wf4(:,4), wf12(:,48), A(:,111), n3(:,272), t3x48(:,:,111), nhel, den(25))
    call Hcont_SS(nsync, wf4(:,2), wf12(:,49), A(:,112), n3(:,273), t3x48(:,:,112), nhel, den(26))
    call Hcont_VV(nsync, wf4(:,12), wf12(:,50), A(:,113), n3(:,274), t3x48(:,:,113), nhel, den(28))
    call Hcont_VV(nsync, wf4(:,5), wf12(:,51), A(:,114), n3(:,275), t3x48(:,:,114), nhel, den(26))
    call Hcont_QA(nsync, wf6(:,8), wf8(:,31), A(:,115), n3(:,276), t3x48(:,:,115), nhel, den(23))
    call Hcont_QA(nsync, wf6(:,8), wf8(:,32), A(:,116), n3(:,277), t3x48(:,:,116), nhel, den(23))
    call Hcont_QA(nsync, wf6(:,2), wf8(:,33), A(:,117), n3(:,278), t3x48(:,:,117), nhel, den(24))
    call Hcont_QA(nsync, wf6(:,2), wf8(:,34), A(:,118), n3(:,279), t3x48(:,:,118), nhel, den(24))
    call Hcont_SS(nsync, wf4(:,2), wf12(:,52), A(:,119), n3(:,280), t3x48(:,:,119), nhel, den(3))
    call Hcont_SS(nsync, wf4(:,4), wf12(:,53), A(:,120), n3(:,281), t3x48(:,:,120), nhel, den(6))
    call Hcont_VV(nsync, wf4(:,5), wf12(:,54), A(:,121), n3(:,282), t3x48(:,:,121), nhel, den(3))
    call Hcont_SS(nsync, wf4(:,4), wf12(:,55), A(:,122), n3(:,283), t3x48(:,:,122), nhel, den(6))
    call Hcont_QA(nsync, wf6(:,2), wf8(:,35), A(:,123), n3(:,284), t3x48(:,:,123), nhel, den(8))
    call Hcont_QA(nsync, wf6(:,2), wf8(:,36), A(:,124), n3(:,285), t3x48(:,:,124), nhel, den(9))
    call Hcont_QA(nsync, wf6(:,2), wf8(:,37), A(:,125), n3(:,286), t3x48(:,:,125), nhel, den(11))
    call Hcont_QA(nsync, wf6(:,2), wf8(:,38), A(:,126), n3(:,287), t3x48(:,:,126), nhel, den(9))
    call Hcont_QA(nsync, wf6(:,4), wf8(:,39), A(:,127), n3(:,288), t3x48(:,:,127), nhel, den(13))
    call Hcont_QA(nsync, wf6(:,4), wf8(:,40), A(:,128), n3(:,289), t3x48(:,:,128), nhel, den(14))
    call Hcont_QA(nsync, wf6(:,4), wf8(:,41), A(:,129), n3(:,290), t3x48(:,:,129), nhel, den(15))
    call Hcont_QA(nsync, wf6(:,4), wf8(:,42), A(:,130), n3(:,291), t3x48(:,:,130), nhel, den(14))
    call Hcont_SS(nsync, wf12(:,56), wf4(:,25), A(:,131), n3(:,292), t3x48(:,:,131), nhel, den(36))
    call Hcont_SS(nsync, wf12(:,57), wf4(:,26), A(:,132), n3(:,293), t3x48(:,:,132), nhel, den(39))
    call Hcont_SS(nsync, wf4(:,25), wf12(:,58), A(:,133), n3(:,294), t3x48(:,:,133), nhel, den(36))
    call Hcont_VV(nsync, wf12(:,59), wf4(:,27), A(:,134), n3(:,295), t3x48(:,:,134), nhel, den(39))
    call Hcont_SS(nsync, wf12(:,57), wf4(:,28), A(:,135), n3(:,296), t3x48(:,:,135), nhel, den(40))
    call Hcont_SS(nsync, wf12(:,57), wf4(:,29), A(:,136), n3(:,297), t3x48(:,:,136), nhel, den(39))
    call Hcont_VV(nsync, wf12(:,59), wf4(:,30), A(:,137), n3(:,298), t3x48(:,:,137), nhel, den(40))
    call Hcont_VV(nsync, wf12(:,59), wf4(:,31), A(:,138), n3(:,299), t3x48(:,:,138), nhel, den(39))
    call Hcont_SS(nsync, wf12(:,2), wf4(:,32), A(:,139), n3(:,300), t3x48(:,:,139), nhel, den(43))
    call Hcont_SS(nsync, wf12(:,1), wf4(:,33), A(:,140), n3(:,301), t3x48(:,:,140), nhel, den(46))
    call Hcont_SS(nsync, wf12(:,4), wf4(:,32), A(:,141), n3(:,302), t3x48(:,:,141), nhel, den(43))
    call Hcont_VV(nsync, wf12(:,3), wf4(:,34), A(:,142), n3(:,303), t3x48(:,:,142), nhel, den(46))
    call Hcont_SS(nsync, wf12(:,1), wf4(:,35), A(:,143), n3(:,304), t3x48(:,:,143), nhel, den(47))
    call Hcont_SS(nsync, wf12(:,1), wf4(:,36), A(:,144), n3(:,305), t3x48(:,:,144), nhel, den(46))
    call Hcont_VV(nsync, wf12(:,3), wf4(:,37), A(:,145), n3(:,306), t3x48(:,:,145), nhel, den(47))
    call Hcont_VV(nsync, wf12(:,3), wf4(:,38), A(:,146), n3(:,307), t3x48(:,:,146), nhel, den(46))
    call Hcont_SS(nsync, wf4(:,25), wf12(:,60), A(:,147), n3(:,308), t3x48(:,:,147), nhel, den(49))
    call Hcont_SS(nsync, wf4(:,26), wf12(:,61), A(:,148), n3(:,309), t3x48(:,:,148), nhel, den(51))
    call Hcont_VV(nsync, wf12(:,62), wf4(:,39), A(:,149), n3(:,310), t3x48(:,:,149), nhel, den(54))
    call Hcont_VV(nsync, wf4(:,27), wf12(:,63), A(:,150), n3(:,311), t3x48(:,:,150), nhel, den(51))
    call Hcont_SS(nsync, wf4(:,28), wf12(:,61), A(:,151), n3(:,312), t3x48(:,:,151), nhel, den(55))
    call Hcont_SS(nsync, wf4(:,29), wf12(:,61), A(:,152), n3(:,313), t3x48(:,:,152), nhel, den(51))
    call Hcont_VV(nsync, wf12(:,62), wf4(:,40), A(:,153), n3(:,314), t3x48(:,:,153), nhel, den(56))
    call Hcont_VV(nsync, wf4(:,30), wf12(:,63), A(:,154), n3(:,315), t3x48(:,:,154), nhel, den(55))
    call Hcont_VV(nsync, wf12(:,62), wf4(:,41), A(:,155), n3(:,316), t3x48(:,:,155), nhel, den(54))
    call Hcont_VV(nsync, wf4(:,31), wf12(:,63), A(:,156), n3(:,317), t3x48(:,:,156), nhel, den(51))
    call Hcont_QA(nsync, wf6(:,17), wf8(:,43), A(:,157), n3(:,318), t3x48(:,:,157), nhel, den(59))
    call Hcont_QA(nsync, wf6(:,17), wf8(:,44), A(:,158), n3(:,319), t3x48(:,:,158), nhel, den(61))
    call Hcont_QA(nsync, wf6(:,17), wf8(:,45), A(:,159), n3(:,320), t3x48(:,:,159), nhel, den(63))
    call Hcont_QA(nsync, wf6(:,17), wf8(:,46), A(:,160), n3(:,321), t3x48(:,:,160), nhel, den(61))
    call Hcont_SS(nsync, wf4(:,25), wf12(:,64), A(:,161), n3(:,322), t3x48(:,:,161), nhel, den(65))
    call Hcont_SS(nsync, wf4(:,26), wf12(:,65), A(:,162), n3(:,323), t3x48(:,:,162), nhel, den(67))
    call Hcont_VV(nsync, wf4(:,39), wf12(:,66), A(:,163), n3(:,324), t3x48(:,:,163), nhel, den(69))
    call Hcont_VV(nsync, wf4(:,27), wf12(:,67), A(:,164), n3(:,325), t3x48(:,:,164), nhel, den(67))
    call Hcont_SS(nsync, wf4(:,28), wf12(:,65), A(:,165), n3(:,326), t3x48(:,:,165), nhel, den(70))
    call Hcont_SS(nsync, wf4(:,29), wf12(:,65), A(:,166), n3(:,327), t3x48(:,:,166), nhel, den(67))
    call Hcont_VV(nsync, wf4(:,40), wf12(:,66), A(:,167), n3(:,328), t3x48(:,:,167), nhel, den(71))
    call Hcont_VV(nsync, wf4(:,30), wf12(:,67), A(:,168), n3(:,329), t3x48(:,:,168), nhel, den(70))
    call Hcont_VV(nsync, wf4(:,41), wf12(:,66), A(:,169), n3(:,330), t3x48(:,:,169), nhel, den(69))
    call Hcont_VV(nsync, wf4(:,31), wf12(:,67), A(:,170), n3(:,331), t3x48(:,:,170), nhel, den(67))
    call Hcont_QA(nsync, wf6(:,18), wf8(:,47), A(:,171), n3(:,332), t3x48(:,:,171), nhel, den(74))
    call Hcont_QA(nsync, wf6(:,18), wf8(:,48), A(:,172), n3(:,333), t3x48(:,:,172), nhel, den(76))
    call Hcont_QA(nsync, wf6(:,18), wf8(:,49), A(:,173), n3(:,334), t3x48(:,:,173), nhel, den(78))
    call Hcont_QA(nsync, wf6(:,18), wf8(:,50), A(:,174), n3(:,335), t3x48(:,:,174), nhel, den(76))
    call Hcont_SS(nsync, wf12(:,68), wf4(:,42), A(:,175), n3(:,336), t3x48(:,:,175), nhel, den(81))
    call Hcont_SS(nsync, wf4(:,42), wf12(:,69), A(:,176), n3(:,337), t3x48(:,:,176), nhel, den(81))
    call Hcont_VV(nsync, wf12(:,70), wf4(:,43), A(:,177), n3(:,338), t3x48(:,:,177), nhel, den(81))
    call Hcont_VV(nsync, wf4(:,43), wf12(:,71), A(:,178), n3(:,339), t3x48(:,:,178), nhel, den(81))
    call Hcont_SS(nsync, wf12(:,68), wf4(:,44), A(:,179), n3(:,340), t3x48(:,:,179), nhel, den(81))
    call Hcont_SS(nsync, wf12(:,69), wf4(:,44), A(:,180), n3(:,341), t3x48(:,:,180), nhel, den(81))
    call Hcont_VV(nsync, wf12(:,70), wf4(:,45), A(:,181), n3(:,342), t3x48(:,:,181), nhel, den(81))
    call Hcont_VV(nsync, wf12(:,71), wf4(:,45), A(:,182), n3(:,343), t3x48(:,:,182), nhel, den(81))
    call Hcont_SS(nsync, wf12(:,5), wf4(:,46), A(:,183), n3(:,344), t3x48(:,:,183), nhel, den(84))
    call Hcont_SS(nsync, wf12(:,7), wf4(:,46), A(:,184), n3(:,345), t3x48(:,:,184), nhel, den(84))
    call Hcont_VV(nsync, wf12(:,6), wf4(:,47), A(:,185), n3(:,346), t3x48(:,:,185), nhel, den(84))
    call Hcont_VV(nsync, wf12(:,8), wf4(:,47), A(:,186), n3(:,347), t3x48(:,:,186), nhel, den(84))
    call Hcont_SS(nsync, wf12(:,5), wf4(:,48), A(:,187), n3(:,348), t3x48(:,:,187), nhel, den(84))
    call Hcont_SS(nsync, wf12(:,7), wf4(:,48), A(:,188), n3(:,349), t3x48(:,:,188), nhel, den(84))
    call Hcont_VV(nsync, wf12(:,6), wf4(:,49), A(:,189), n3(:,350), t3x48(:,:,189), nhel, den(84))
    call Hcont_VV(nsync, wf12(:,8), wf4(:,49), A(:,190), n3(:,351), t3x48(:,:,190), nhel, den(84))
    call Hcont_QA(nsync, wf6(:,19), wf8(:,52), A(:,191), n3(:,352), t3x48(:,:,191), nhel, den(87))
    call Hcont_QA(nsync, wf6(:,19), wf8(:,54), A(:,192), n3(:,353), t3x48(:,:,192), nhel, den(87))
    call Hcont_SS(nsync, wf12(:,9), wf4(:,46), A(:,193), n3(:,354), t3x48(:,:,193), nhel, den(89))
    call Hcont_VV(nsync, wf12(:,10), wf4(:,47), A(:,194), n3(:,355), t3x48(:,:,194), nhel, den(89))
    call Hcont_SS(nsync, wf12(:,9), wf4(:,48), A(:,195), n3(:,356), t3x48(:,:,195), nhel, den(89))
    call Hcont_VV(nsync, wf12(:,10), wf4(:,49), A(:,196), n3(:,357), t3x48(:,:,196), nhel, den(89))
    call Hcont_SS(nsync, wf4(:,46), wf12(:,72), A(:,197), n3(:,358), t3x48(:,:,197), nhel, den(91))
    call Hcont_SS(nsync, wf4(:,48), wf12(:,72), A(:,198), n3(:,359), t3x48(:,:,198), nhel, den(91))
    call Hcont_VV(nsync, wf4(:,47), wf12(:,73), A(:,199), n3(:,360), t3x48(:,:,199), nhel, den(91))
    call Hcont_VV(nsync, wf4(:,49), wf12(:,73), A(:,200), n3(:,361), t3x48(:,:,200), nhel, den(91))
    call Hcont_QA(nsync, wf6(:,18), wf8(:,55), A(:,201), n3(:,362), t3x48(:,:,201), nhel, den(93))
    call Hcont_QA(nsync, wf6(:,18), wf8(:,56), A(:,202), n3(:,363), t3x48(:,:,202), nhel, den(93))
    call Hcont_SS(nsync, wf4(:,42), wf12(:,74), A(:,203), n3(:,364), t3x48(:,:,203), nhel, den(95))
    call Hcont_VV(nsync, wf4(:,43), wf12(:,75), A(:,204), n3(:,365), t3x48(:,:,204), nhel, den(95))
    call Hcont_SS(nsync, wf4(:,44), wf12(:,74), A(:,205), n3(:,366), t3x48(:,:,205), nhel, den(95))
    call Hcont_VV(nsync, wf4(:,45), wf12(:,75), A(:,206), n3(:,367), t3x48(:,:,206), nhel, den(95))
    call Hcont_QA(nsync, wf6(:,20), wf8(:,57), A(:,207), n3(:,368), t3x48(:,:,207), nhel, den(98))
    call Hcont_QA(nsync, wf6(:,20), wf8(:,58), A(:,208), n3(:,369), t3x48(:,:,208), nhel, den(98))
    call Hcont_SS(nsync, wf4(:,42), wf12(:,76), A(:,209), n3(:,370), t3x48(:,:,209), nhel, den(100))
    call Hcont_VV(nsync, wf4(:,43), wf12(:,77), A(:,210), n3(:,371), t3x48(:,:,210), nhel, den(100))
    call Hcont_SS(nsync, wf4(:,44), wf12(:,76), A(:,211), n3(:,372), t3x48(:,:,211), nhel, den(100))
    call Hcont_VV(nsync, wf4(:,45), wf12(:,77), A(:,212), n3(:,373), t3x48(:,:,212), nhel, den(100))
    call Hcont_QA(nsync, wf6(:,17), wf8(:,59), A(:,213), n3(:,374), t3x48(:,:,213), nhel, den(102))
    call Hcont_QA(nsync, wf6(:,17), wf8(:,60), A(:,214), n3(:,375), t3x48(:,:,214), nhel, den(102))
    call Hcont_QA(nsync, wf6(:,19), wf8(:,62), A(:,215), n3(:,376), t3x48(:,:,215), nhel, den(104))
    call Hcont_QA(nsync, wf6(:,19), wf8(:,64), A(:,216), n3(:,377), t3x48(:,:,216), nhel, den(106))
    call Hcont_QA(nsync, wf6(:,19), wf8(:,66), A(:,217), n3(:,378), t3x48(:,:,217), nhel, den(108))
    call Hcont_QA(nsync, wf6(:,19), wf8(:,68), A(:,218), n3(:,379), t3x48(:,:,218), nhel, den(106))
    call Hcont_SS(nsync, wf12(:,11), wf4(:,32), A(:,219), n3(:,380), t3x48(:,:,219), nhel, den(110))
    call Hcont_SS(nsync, wf12(:,12), wf4(:,33), A(:,220), n3(:,381), t3x48(:,:,220), nhel, den(112))
    call Hcont_SS(nsync, wf12(:,12), wf4(:,35), A(:,221), n3(:,382), t3x48(:,:,221), nhel, den(113))
    call Hcont_SS(nsync, wf12(:,12), wf4(:,36), A(:,222), n3(:,383), t3x48(:,:,222), nhel, den(112))
    call Hcont_VV(nsync, wf12(:,13), wf4(:,50), A(:,223), n3(:,384), t3x48(:,:,223), nhel, den(116))
    call Hcont_VV(nsync, wf12(:,14), wf4(:,34), A(:,224), n3(:,385), t3x48(:,:,224), nhel, den(112))
    call Hcont_VV(nsync, wf12(:,13), wf4(:,51), A(:,225), n3(:,386), t3x48(:,:,225), nhel, den(117))
    call Hcont_VV(nsync, wf12(:,13), wf4(:,52), A(:,226), n3(:,387), t3x48(:,:,226), nhel, den(116))
    call Hcont_VV(nsync, wf12(:,14), wf4(:,37), A(:,227), n3(:,388), t3x48(:,:,227), nhel, den(113))
    call Hcont_VV(nsync, wf12(:,14), wf4(:,38), A(:,228), n3(:,389), t3x48(:,:,228), nhel, den(112))
    call Hcont_QA(nsync, wf6(:,20), wf8(:,70), A(:,229), n3(:,390), t3x48(:,:,229), nhel, den(119))
    call Hcont_QA(nsync, wf6(:,20), wf8(:,72), A(:,230), n3(:,391), t3x48(:,:,230), nhel, den(121))
    call Hcont_QA(nsync, wf6(:,20), wf8(:,74), A(:,231), n3(:,392), t3x48(:,:,231), nhel, den(123))
    call Hcont_QA(nsync, wf6(:,20), wf8(:,76), A(:,232), n3(:,393), t3x48(:,:,232), nhel, den(121))
    call Hcont_SS(nsync, wf12(:,15), wf4(:,32), A(:,233), n3(:,394), t3x48(:,:,233), nhel, den(125))
    call Hcont_SS(nsync, wf12(:,16), wf4(:,33), A(:,234), n3(:,395), t3x48(:,:,234), nhel, den(127))
    call Hcont_SS(nsync, wf12(:,16), wf4(:,35), A(:,235), n3(:,396), t3x48(:,:,235), nhel, den(128))
    call Hcont_SS(nsync, wf12(:,16), wf4(:,36), A(:,236), n3(:,397), t3x48(:,:,236), nhel, den(127))
    call Hcont_VV(nsync, wf12(:,17), wf4(:,50), A(:,237), n3(:,398), t3x48(:,:,237), nhel, den(130))
    call Hcont_VV(nsync, wf12(:,18), wf4(:,34), A(:,238), n3(:,399), t3x48(:,:,238), nhel, den(127))
    call Hcont_VV(nsync, wf12(:,17), wf4(:,51), A(:,239), n3(:,400), t3x48(:,:,239), nhel, den(131))
    call Hcont_VV(nsync, wf12(:,17), wf4(:,52), A(:,240), n3(:,401), t3x48(:,:,240), nhel, den(130))
    call Hcont_VV(nsync, wf12(:,18), wf4(:,37), A(:,241), n3(:,402), t3x48(:,:,241), nhel, den(128))
    call Hcont_VV(nsync, wf12(:,18), wf4(:,38), A(:,242), n3(:,403), t3x48(:,:,242), nhel, den(127))

end subroutine diagrams


elemental function diagmap(j, n)
  implicit none
  integer, intent(in) :: j, n
  complex(REALKIND) :: diagmap
  diagmap = A(j,n)%j
end function diagmap

function diagsum(j, pos, neg)
  implicit none
  integer, intent(in) :: j, pos(:), neg(:)
  complex(REALKIND) :: diagsum
  diagsum = sum(diagmap(j, pos)) - sum(diagmap(j, neg))
end function diagsum

subroutine colourvectors(A, j, M1, M2)
  implicit none
  type(Hpolcont) :: A(:,:)
  integer, intent(in) :: j
  type(Hpolcont), intent(out) :: M1(2), M2(2) ! M1helarray(2,48)
  integer :: empty(0), i

  M1(1)%j = -(A(j,13)%j*f(9))+A(j,16)%j*f(12)+(A(j,18)%j+A(j,20)%j+A(j,22)%j+A(j,24)%j)*f(20)+(A(j,17)%j+A(j,19)%j+A(j,21)%j &
       +A(j,23)%j)*f(31)+(A(j,14)%j-A(j,15)%j)*f(45)
  M1(2)%j = (A(j,7)%j+A(j,11)%j+A(j,27)%j+A(j,31)%j)*f(1)+(-A(j,8)%j-A(j,12)%j-A(j,28)%j-A(j,32)%j)*f(2)+(-A(j,1)%j &
       +A(j,2)%j)*f(16)+A(j,4)%j*f(25)+A(j,3)%j*f(28)+(A(j,5)%j+A(j,6)%j+A(j,9)%j+A(j,10)%j+A(j,25)%j+A(j,26)%j+A(j,29)%j &
       +A(j,30)%j)*f(34)

  M2(1)%j = (-A(j,93)%j-A(j,104)%j)*f(7)+(A(j,91)%j-A(j,103)%j)*f(8)+(A(j,175)%j+A(j,183)%j)*f(10)+(A(j,179)%j-A(j,187)%j)*f(11)+( &
       -A(j,182)%j-A(j,190)%j)*f(13)+A(j,106)%j*f(14)+A(j,94)%j*f(15)+(A(j,178)%j-A(j,186)%j)*f(18)+(A(j,66)%j+A(j,70)%j+A(j,82)%j &
       +A(j,102)%j-A(j,192)%j-A(j,196)%j-A(j,200)%j-A(j,202)%j-A(j,206)%j-A(j,208)%j-A(j,212)%j-A(j,214)%j)*f(21)+(A(j,64)%j &
       +A(j,100)%j+A(j,116)%j+A(j,118)%j)*f(22)+(A(j,68)%j+A(j,80)%j+A(j,96)%j+A(j,98)%j)*f(23)-A(j,62)%j*f(24)+(A(j,65)%j &
       +A(j,69)%j+A(j,81)%j+A(j,101)%j-A(j,191)%j-A(j,193)%j-A(j,197)%j-A(j,201)%j-A(j,203)%j-A(j,207)%j-A(j,209)%j &
       -A(j,213)%j)*f(32)+A(j,59)%j*f(33)+(-A(j,194)%j+A(j,195)%j+A(j,198)%j-A(j,199)%j+A(j,204)%j-A(j,205)%j+A(j,210)%j &
       -A(j,211)%j)*f(39)+(-A(j,60)%j+A(j,61)%j)*f(40)+(-A(j,176)%j+A(j,181)%j+A(j,184)%j-A(j,189)%j)*f(46)-A(j,105)%j*f(47) &
       +A(j,92)%j*f(48)+(-A(j,177)%j-A(j,185)%j)*f(53)+(-A(j,180)%j-A(j,188)%j)*f(62)+(-A(j,63)%j+A(j,67)%j+A(j,79)%j+A(j,95)%j &
       +A(j,97)%j-A(j,99)%j-A(j,115)%j-A(j,117)%j)*f(63)
  M2(2)%j = (A(j,45)%j+A(j,53)%j+A(j,89)%j+A(j,113)%j-A(j,153)%j-A(j,159)%j-A(j,167)%j-A(j,173)%j-A(j,217)%j-A(j,225)%j-A(j,231)%j &
       -A(j,239)%j)*f(3)+(-A(j,85)%j-A(j,109)%j-A(j,125)%j-A(j,129)%j+A(j,155)%j+A(j,169)%j+A(j,227)%j+A(j,241)%j)*f(4)+(A(j,41)%j &
       +A(j,49)%j+A(j,73)%j+A(j,77)%j-A(j,154)%j-A(j,168)%j-A(j,226)%j-A(j,240)%j)*f(5)+(-A(j,42)%j-A(j,46)%j-A(j,50)%j-A(j,54)%j &
       -A(j,74)%j-A(j,78)%j-A(j,86)%j-A(j,90)%j-A(j,110)%j-A(j,114)%j-A(j,126)%j-A(j,130)%j+A(j,156)%j+A(j,160)%j+A(j,170)%j &
       +A(j,174)%j+A(j,218)%j+A(j,228)%j+A(j,232)%j+A(j,242)%j)*f(6)+(A(j,131)%j-A(j,132)%j-A(j,139)%j+A(j,140)%j)*f(17)+( &
       -A(j,134)%j+A(j,142)%j)*f(19)+A(j,137)%j*f(26)+(A(j,122)%j-A(j,138)%j-A(j,141)%j)*f(27)-A(j,145)%j*f(29)+(A(j,57)%j &
       -A(j,133)%j-A(j,146)%j)*f(30)+(A(j,43)%j+A(j,44)%j+A(j,51)%j+A(j,52)%j+A(j,87)%j+A(j,88)%j+A(j,111)%j+A(j,112)%j-A(j,147)%j &
       -A(j,148)%j-A(j,157)%j-A(j,158)%j-A(j,161)%j-A(j,162)%j-A(j,171)%j-A(j,172)%j-A(j,215)%j-A(j,216)%j-A(j,219)%j-A(j,220)%j &
       -A(j,229)%j-A(j,230)%j-A(j,233)%j-A(j,234)%j)*f(35)+(-A(j,56)%j+A(j,119)%j)*f(36)+(-A(j,55)%j-A(j,120)%j)*f(37)+(A(j,33)%j &
       -A(j,34)%j)*f(38)+A(j,135)%j*f(41)-A(j,136)%j*f(42)-A(j,143)%j*f(43)-A(j,144)%j*f(44)-A(j,58)%j*f(49)-A(j,121)%j*f(50)+( &
       -A(j,39)%j-A(j,47)%j-A(j,71)%j-A(j,75)%j-A(j,83)%j-A(j,107)%j-A(j,123)%j-A(j,127)%j)*f(51)+(A(j,40)%j+A(j,48)%j+A(j,72)%j &
       +A(j,76)%j-A(j,84)%j-A(j,108)%j-A(j,124)%j-A(j,128)%j)*f(52)+(A(j,151)%j+A(j,165)%j+A(j,223)%j+A(j,237)%j)*f(54)+( &
       -A(j,152)%j-A(j,166)%j-A(j,224)%j-A(j,238)%j)*f(55)-A(j,37)%j*f(56)+A(j,38)%j*f(57)+(A(j,149)%j+A(j,163)%j+A(j,221)%j &
       +A(j,235)%j)*f(58)+(A(j,150)%j+A(j,164)%j+A(j,222)%j+A(j,236)%j)*f(59)+A(j,35)%j*f(60)+A(j,36)%j*f(61)


  M1(:)%hf = Hel(j)
  M2(:)%hf = Hel(j)

  !M(i) corresponds to \Gamma_{i} in Fabios thesis

end subroutine colourvectors


! **********************************************************************
subroutine colint(M, M2colint)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppztt_ew_ttxbbxz_4_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(2)
  real(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

    do i = 1, 2
      do j = 1, 2
        M2colint = M2colint + real(conjg(M(i))*K1(i,j)*M(j))
      end do
    end do

end subroutine colint

! **********************************************************************
subroutine colint_ct(M, Mct, M2colint_ct, l)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppztt_ew_ttxbbxz_4_/**/REALKIND, only: K2
  implicit none
  complex(REALKIND), intent(in)  :: M(2), Mct(2)
  real(REALKIND),    intent(out) :: M2colint_ct
  integer, intent(in) :: l
  integer ::  i, j

  M2colint_ct = 0

  do i = 1, 2
    do j = 1, 2
      M2colint_ct = M2colint_ct + real(conjg(M(i))*K2(i+2*l,j)*Mct(j))
    end do
  end do

end subroutine colint_ct

! **********************************************************************
subroutine colint_IR(M, M2IRadd)
! M(i)   = <M|Ci> colour component of matrix element
! K1(i,j) = .....
! **********************************************************************
  use ol_colourmatrix_ppztt_ew_ttxbbxz_4_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(2)
  real(REALKIND),    intent(out) :: M2IRadd(16)
  integer ::  i, j, k, colmatpos

  M2IRadd = 0

  do k = 1, 17-1
    colmatpos = 2*k
    do i = 1, 2
      do j = 1, 2
        M2IRadd(k) = M2IRadd(k) + real(conjg(M(i))*K1(i+colmatpos,j)*M(j))
      end do
    end do
  end do

end subroutine colint_IR

! **********************************************************************
subroutine colintmunu(M1, M2, M2colint)
! M1(i)    = <M1|Ci> colour component of matrix element
! M2(i)    = <M2|Ci> colour component of matrix element
! M2colint = <M1|M2>
!          = Sum_{i,j} <M1|Ci> * <Ci|Cj> * <Cj|M2>
!          = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppztt_ew_ttxbbxz_4_/**/REALKIND, only: K2
  implicit none

  complex(REALKIND), intent(in)  :: M1(2)
  complex(REALKIND), intent(in)  :: M2(2)
  complex(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

  do i = 1, 2
    do j = 1, 2
      M2colint = M2colint + M1(i)*K2(i,j)*conjg(M2(j))
    end do
  end do

end subroutine colintmunu





! **********************************************************************
subroutine colborninterf(M, M0_col, l)
! M(i)         = <M|Ci> colour component of matrix element
! M0_col(i)    = <M2|Ci> colour component of matrix element,
!                see \tilde{M}_{j} in Fabios thesis
! M2colint = Sum_{i} <M1|Ci> * <Ci|Cj>
!          = colour-summed squared matrix element
! KL(i,j) = <Ci|Cj> with elements Cj of 1-loop colour basis
! **********************************************************************
  use ol_colourmatrix_ppztt_ew_ttxbbxz_4_/**/REALKIND, only: KL
  implicit none

  type(Hpolcont), intent(in)  :: M(2)
  type(Hpolcont), intent(out)  :: M0_col(2)
  integer, intent(in) :: l
  integer :: i, j

  do j = 1, 2 !size(KL(1,:))
    M0_col(j)%j = 0
    M0_col(j)%hf = M(1)%hf
    do i = 1, 2 !size(KL(:,1))
      M0_col(j)%j = M0_col(j)%j  + conjg(M(i)%j)*KL(i+2*l,j)
    end do
  end do

end subroutine colborninterf

end subroutine amp2

end module ol_loop_ppztt_ew_ttxbbxz_4_/**/REALKIND
