
module ol_colourmatrix_ppztt_ew_ttxbbxz_3_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  logical, save           :: colmat_not_initialised = .true.
  complex(REALKIND), save :: K1(68,4), K2(4,4), KL(4,4), Cas(5) = 0
  contains
  subroutine colourmatrix_init
    use ol_parameters_decl_/**/REALKIND, only: CI
    implicit none
    integer :: k, co
    colmat_not_initialised = .false.
    ! colour matrix

  K1( 1,:) = [   9,   0,   3,   0]
  K1( 2,:) = [   0,   0,   0,   0]
  K1( 3,:) = [   3,   0,   9,   0]
  K1( 4,:) = [   0,   0,   0,   0]
  K1( 5,:) = [  12,   0,   4,   0]
  K1( 6,:) = [   0,   0,   0,   0]
  K1( 7,:) = [   4,   0,  12,   0]
  K1( 8,:) = [   0,   0,   0,   0]
  K1( 9,:) = [   0,   0,  -4,   0]
  K1(10,:) = [   0,   0,   0,   0]
  K1(11,:) = [  -4,   0, -12,   0]
  K1(12,:) = [   0,   0,   0,   0]
  K1(13,:) = [  12,   0,   4,   0]
  K1(14,:) = [   0,   0,   0,   0]
  K1(15,:) = [   4,   0,  12,   0]
  K1(16,:) = [   0,   0,   0,   0]
  K1(17,:) = [   0,   0,   4,   0]
  K1(18,:) = [   0,   0,   0,   0]
  K1(19,:) = [   4,   0,   0,   0]
  K1(20,:) = [   0,   0,   0,   0]
  K1(21,:) = [ -12,   0,  -4,   0]
  K1(22,:) = [   0,   0,   0,   0]
  K1(23,:) = [  -4,   0,   0,   0]
  K1(24,:) = [   0,   0,   0,   0]
  K1(25,:) = [  12,   0,   4,   0]
  K1(26,:) = [   0,   0,   0,   0]
  K1(27,:) = [   4,   0,  12,   0]
  K1(28,:) = [   0,   0,   0,   0]
  K1(29,:) = [ -12,   0,  -4,   0]
  K1(30,:) = [   0,   0,   0,   0]
  K1(31,:) = [  -4,   0,   0,   0]
  K1(32,:) = [   0,   0,   0,   0]
  K1(33,:) = [   0,   0,   4,   0]
  K1(34,:) = [   0,   0,   0,   0]
  K1(35,:) = [   4,   0,   0,   0]
  K1(36,:) = [   0,   0,   0,   0]
  K1(37,:) = [   0,   0,  -4,   0]
  K1(38,:) = [   0,   0,   0,   0]
  K1(39,:) = [  -4,   0, -12,   0]
  K1(40,:) = [   0,   0,   0,   0]
  K1(41,:) = [  12,   0,   4,   0]
  K1(42,:) = [   0,   0,   0,   0]
  K1(43,:) = [   4,   0,  12,   0]
  K1(44,:) = [   0,   0,   0,   0]
  K1(45,:) = [   0,   0,   0,   0]
  K1(46,:) = [   0,   0,   0,   0]
  K1(47,:) = [   0,   0,   0,   0]
  K1(48,:) = [   0,   0,   0,   0]
  K1(49,:) = [   0,   0,   0,   0]
  K1(50,:) = [   0,   0,   0,   0]
  K1(51,:) = [   0,   0,   0,   0]
  K1(52,:) = [   0,   0,   0,   0]
  K1(53,:) = [   0,   0,   0,   0]
  K1(54,:) = [   0,   0,   0,   0]
  K1(55,:) = [   0,   0,   0,   0]
  K1(56,:) = [   0,   0,   0,   0]
  K1(57,:) = [   0,   0,   0,   0]
  K1(58,:) = [   0,   0,   0,   0]
  K1(59,:) = [   0,   0,   0,   0]
  K1(60,:) = [   0,   0,   0,   0]
  K1(61,:) = [   0,   0,   0,   0]
  K1(62,:) = [   0,   0,   0,   0]
  K1(63,:) = [   0,   0,   0,   0]
  K1(64,:) = [   0,   0,   0,   0]
  K1(65,:) = [   0,   9,   0,   3]
  K1(66,:) = [   9,   0,   3,   0]
  K1(67,:) = [   0,   3,   0,   9]
  K1(68,:) = [   3,   0,   9,   0]

  K2(1,:) = [ 0, 9, 3, 0]
  K2(2,:) = [ 9, 0, 0, 3]
  K2(3,:) = [ 0, 3, 9, 0]
  K2(4,:) = [ 3, 0, 0, 9]

  KL(1,:) = [ 0, 9, 0, 3]
  KL(2,:) = [ 9, 0, 3, 0]
  KL(3,:) = [ 0, 3, 0, 9]
  KL(4,:) = [ 3, 0, 9, 0]

#if 1 > 0
    co = 0
    do k = 1, 5
      co = co + k
      Cas(k) = K1(1+4*co,1)/K1(1,1)
    end do
#endif
  end subroutine colourmatrix_init
end module ol_colourmatrix_ppztt_ew_ttxbbxz_3_/**/REALKIND



module ol_forced_parameters_ppztt_ew_ttxbbxz_3_/**/REALKIND
  implicit none
  contains
  subroutine check_forced_parameters
    use ol_parameters_decl_/**/REALKIND
    use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
    use ol_loop_parameters_decl_/**/DREALKIND, only: LeadingColour, nc, nf, CKMORDER
#endif
    implicit none
    logical, save :: checks_not_written = .true.

    if (checks_not_written) then
    ! e.g.
    ! if (ME /= 0) write(*,101) 'ME = 0'
  if (CKMORDER /= 0) write(*,101) 'CKMORDER = 0'
  if (nc /= 3) write(*,101) 'nc = 3'
  if (nf /= 6) write(*,101) 'nf = 6'
  if (MU /= 0) write(*,101) 'MU = 0'
  if (MD /= 0) write(*,101) 'MD = 0'
  if (MS /= 0) write(*,101) 'MS = 0'
  if (MC /= 0) write(*,101) 'MC = 0'
  if (LeadingColour /= 0) write(*,101) 'LeadingColour = 0'
  if (wMT /= 0) write(*,101) 'wMT = 0'
  if (wMT /= 0) write(*,101) 'wMT = 0'
  if (wMB /= 0) write(*,101) 'wMB = 0'
  if (wMB /= 0) write(*,101) 'wMB = 0'
  if (wMZ /= 0) write(*,101) 'wMZ = 0'


    checks_not_written = .false.
    end if

    101 format('[OpenLoops] === WARNING ===',/,'[OpenLoops] code was generated with ',A,/,'[OpenLoops] ===============')
  end subroutine check_forced_parameters
end module ol_forced_parameters_ppztt_ew_ttxbbxz_3_/**/REALKIND


! **********************************************************************
module ol_loop_storage_ppztt_ew_ttxbbxz_3_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, intkind1, intkind2
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont

#ifdef PRECISION_dp
  integer(intkind1), save :: ntry = 1, ntryL = 1
  integer(intkind1), save :: p_switch = 0 ! switch for dp or qp. Used for memory allocation of the OL types
  ! the following are flags for memory allocation of the hol coefficients in dp or qp
  logical, save :: dp_not_alloc = .TRUE., qp_not_alloc = .TRUE.
  integer, save :: n_merge_steps  ! total number of merging steps
  integer, save :: n_merge_mism   ! number of merging mismatches
  integer, save :: merge_step = 1 ! current merging step
  integer(intkind2), save, allocatable :: merge_tables(:,:,:) ! merging tables
  integer(intkind2), save, allocatable :: merge_mism(:)       ! array of merging mismatches
  integer(intkind2), save, allocatable :: merge_hels(:)       ! array with relevant helicities for a merging step
  logical, save :: merge_tables_on = .false.
  integer(intkind2), parameter :: nheltot = 48 ! number of helicity configurations
  integer(intkind2), save :: nhel = 48 ! number of non-vanishing helicity configurations (adapted at runtime)
  integer(intkind2), save :: Hel(48) ! physical helicity states
#endif

  complex(REALKIND), save :: den(158)

  ! external wave functions ex1(h1),... for h<n> helicities
  type(wfun) :: ex1(2), ex2(2), ex3(2), ex4(2), ex5(3)

  ! wf<h>(h,n) n wave functions with h helicity configurations
  type(wfun) :: wf4(4,64), wf6(6,32), wf8(8,102), wf12(12,104), wf48(48,374)

  ! diagram prefactors
  integer,           save :: fac_status_loop1 = -1, fac_status_loop2 = -1
  complex(REALKIND), save :: f(652), c(595)

  !Vector in helicity and colour space for Born-Loop interference
  type(Hpolcont),   save :: M0_col1_helarray(4,48), M0M1_hel_cc(4,48,16)
  complex(REALKIND), save :: M2ctcc(16)

end module ol_loop_storage_ppztt_ew_ttxbbxz_3_/**/REALKIND






! **********************************************************************
module ol_loop_ppztt_ew_ttxbbxz_3_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, DREALKIND, intkind1, intkind2
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont
  use ol_loop_storage_ppztt_ew_ttxbbxz_3_/**/REALKIND
  implicit none

!*********************************************************************************
  contains

! **********************************************************************
subroutine fac_init_loop()
! Writes diagram prefactors to 'f', rsp. 'c'
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND
  use ol_init, only: set_parameter, tree_parameters_flush, parameters_flush
#ifndef PRECISION_dp
  use ol_loop_parameters_decl_/**/DREALKIND, only: SwF, SwB
!  use ol_loop_parameters_decl_/**/DREALKIND, only: DOI
#endif
  implicit none
  call set_parameter("ew_renorm", 1)
  if (parameters_status == 0) call tree_parameters_flush()
  if (loop_parameters_status == 0) call parameters_flush()
  fac_status_loop1 = parameters_status
  fac_status_loop2 = loop_parameters_status
  ! factors of the diagrams
    f(  1) = (2*CI*eQED**3)/9._/**/REALKIND
    f(  2) = CI*eQED**3
    f(  3) = (2*CI*countertermnorm*eQED**5)/9._/**/REALKIND
    f(  4) = (CI*countertermnorm*eQED**5)/3._/**/REALKIND
    f(  5) = (2*CI*countertermnorm*eQED**5)/3._/**/REALKIND
    f(  6) = CI*countertermnorm*eQED**5
    f(  7) = CI*eQED*gQCD**2
    f(  8) = (2*CI*countertermnorm*eQED**3*gQCD**2)/9._/**/REALKIND
    f(  9) = CI*countertermnorm*eQED**3*gQCD**2
    f( 10) = (2*CI*countertermnorm*ctVbb*eQED**3*gQCD**2)/9._/**/REALKIND
    f( 11) = CI*countertermnorm*ctVbb*eQED**3*gQCD**2
    f( 12) = (2*CI*countertermnorm*ctVtt*eQED**3*gQCD**2)/9._/**/REALKIND
    f( 13) = CI*countertermnorm*ctVtt*eQED**3*gQCD**2
    f( 14) = (CI*countertermnorm*eQED**5)/(cw*sqrt2)
    f( 15) = (CI*countertermnorm*eQED**5*(cw - sw)*(cw + sw))/(2._/**/REALKIND*cw*MW**2*sqrt2*sw**2)
    f( 16) = -(CI*eQED**3*(cw - sw)*(cw + sw))/(4._/**/REALKIND*cw*MW**2*sw**3)
    f( 17) = -(CI*countertermnorm*eQED**5*(cw - sw)*(cw + sw))/(4._/**/REALKIND*cw*MW**2*sw**3)
    f( 18) = -(CI*countertermnorm*eQED**3*gQCD**2*(cw - sw)*(cw + sw))/(4._/**/REALKIND*cw*MW**2*sw**3)
    f( 19) = -(CI*countertermnorm*eQED**5*(cw - sw)*(cw + sw))/(4._/**/REALKIND*cw*MW*sw**3)
    f( 20) = (CI*cw*eQED**3)/(2._/**/REALKIND*sw**3)
    f( 21) = (CI*countertermnorm*cw*eQED**5)/(2._/**/REALKIND*sw**3)
    f( 22) = (CI*countertermnorm*cw*eQED**5*EWctVbt)/(2._/**/REALKIND*sw**3)
    f( 23) = (CI*countertermnorm*cw*eQED**5*EWctVtb)/(2._/**/REALKIND*sw**3)
    f( 24) = (CI*countertermnorm*ctVbt*cw*eQED**3*gQCD**2)/(2._/**/REALKIND*sw**3)
    f( 25) = (CI*eQED**3*MB*MT)/(8._/**/REALKIND*cw*MW**2*sw**3)
    f( 26) = (CI*countertermnorm*eQED**5*MB*MT)/(8._/**/REALKIND*cw*MW**2*sw**3)
    f( 27) = (CI*countertermnorm*ctSbb*eQED**3*gQCD**2*MB*MT)/(8._/**/REALKIND*cw*MW**2*sw**3)
    f( 28) = (CI*countertermnorm*ctStt*eQED**3*gQCD**2*MB*MT)/(8._/**/REALKIND*cw*MW**2*sw**3)
    f( 29) = (CI*countertermnorm*cw*eQED**5)/(2._/**/REALKIND*MW*sw**3)
    f( 30) = (countertermnorm*eQED**5*MB*MT)/(cw**2*MW*sw**3*4._/**/REALKIND)
    f( 31) = (CI*eQED**3)/(2._/**/REALKIND*sw**2)
    f( 32) = (CI*countertermnorm*eQED**5)/(2._/**/REALKIND*sw**2)
    f( 33) = (CI*countertermnorm*eQED**5*EWctVbt)/(2._/**/REALKIND*sw**2)
    f( 34) = (CI*countertermnorm*eQED**5*EWctVtb)/(2._/**/REALKIND*sw**2)
    f( 35) = (CI*countertermnorm*eQED**5*EWctZWW)/(2._/**/REALKIND*sw**2)
    f( 36) = (CI*countertermnorm*eQED**3*gQCD**2)/(2._/**/REALKIND*sw**2)
    f( 37) = (CI*countertermnorm*ctVbb*eQED**3*gQCD**2)/(2._/**/REALKIND*sw**2)
    f( 38) = (CI*countertermnorm*ctVbt*eQED**3*gQCD**2)/(2._/**/REALKIND*sw**2)
    f( 39) = (CI*countertermnorm*ctVtt*eQED**3*gQCD**2)/(2._/**/REALKIND*sw**2)
    f( 40) = (CI*eQED**3*MB)/(2._/**/REALKIND*cw**2*sw**2)
    f( 41) = (CI*countertermnorm*eQED**5*MB)/(3._/**/REALKIND*cw**2*sw**2)
    f( 42) = (CI*countertermnorm*eQED**5*MB)/(2._/**/REALKIND*cw**2*sw**2)
    f( 43) = (CI*countertermnorm*ctSbb*eQED**3*gQCD**2*MB)/(2._/**/REALKIND*cw**2*sw**2)
    f( 44) = (CI*countertermnorm*ctVtt*eQED**3*gQCD**2*MB)/(2._/**/REALKIND*cw**2*sw**2)
    f( 45) = (CI*eQED**3*MT)/(2._/**/REALKIND*cw**2*sw**2)
    f( 46) = (CI*countertermnorm*eQED**5*MT)/(6._/**/REALKIND*cw**2*sw**2)
    f( 47) = (CI*countertermnorm*eQED**5*MT)/(2._/**/REALKIND*cw**2*sw**2)
    f( 48) = (CI*countertermnorm*ctStt*eQED**3*gQCD**2*MT)/(2._/**/REALKIND*cw**2*sw**2)
    f( 49) = (CI*countertermnorm*ctVbb*eQED**3*gQCD**2*MT)/(2._/**/REALKIND*cw**2*sw**2)
    f( 50) = (CI*eQED**3)/(2._/**/REALKIND*MW**2*sw**2)
    f( 51) = (CI*countertermnorm*eQED**5)/(2._/**/REALKIND*MW**2*sw**2)
    f( 52) = (CI*countertermnorm*eQED**5*EWctZPP)/(2._/**/REALKIND*MW**2*sw**2)
    f( 53) = (CI*countertermnorm*eQED**3*gQCD**2)/(2._/**/REALKIND*MW**2*sw**2)
    f( 54) = (CI*countertermnorm*ctVbb*eQED**3*gQCD**2)/(2._/**/REALKIND*MW**2*sw**2)
    f( 55) = (CI*countertermnorm*ctVtt*eQED**3*gQCD**2)/(2._/**/REALKIND*MW**2*sw**2)
    f( 56) = (CI*eQED**3*MB*MT)/(4._/**/REALKIND*MW**2*sw**2)
    f( 57) = (CI*countertermnorm*eQED**5*MB*MT)/(4._/**/REALKIND*MW**2*sw**2)
    f( 58) = (CI*countertermnorm*eQED**5*MB*MT)/(4._/**/REALKIND*cw*MW**2*sw**2)
    f( 59) = (countertermnorm*eQED**5*MB*MT)/(cw*MW**2*sw**2*4._/**/REALKIND)
    f( 60) = (countertermnorm*eQED**5*EWctZXH*MB*MT)/(MW**2*sw**2*4._/**/REALKIND)
    f( 61) = (CI*countertermnorm*eQED**3*gQCD**2*MB*MT)/(4._/**/REALKIND*MW**2*sw**2)
    f( 62) = (CI*countertermnorm*ctSbb*eQED**3*gQCD**2*MB*MT)/(4._/**/REALKIND*MW**2*sw**2)
    f( 63) = (CI*countertermnorm*ctStt*eQED**3*gQCD**2*MB*MT)/(4._/**/REALKIND*MW**2*sw**2)
    f( 64) = (CI*countertermnorm*ctVbb*eQED**3*gQCD**2*MB*MT)/(4._/**/REALKIND*MW**2*sw**2)
    f( 65) = (CI*countertermnorm*ctVtt*eQED**3*gQCD**2*MB*MT)/(4._/**/REALKIND*MW**2*sw**2)
    f( 66) = (CI*countertermnorm*eQED**5)/(2._/**/REALKIND*MW*sw**2)
    f( 67) = (CI*countertermnorm*eQED**5*EWctPWZ)/(2._/**/REALKIND*MW*sw**2)
    f( 68) = (countertermnorm*eQED**5*MB)/(cw*MW*sw**2*6._/**/REALKIND)
    f( 69) = (countertermnorm*eQED**5*MB)/(cw*MW*sw**2*4._/**/REALKIND)
    f( 70) = (countertermnorm*eQED**5*MT)/(cw*MW*sw**2*12._/**/REALKIND)
    f( 71) = (countertermnorm*eQED**5*MT)/(cw*MW*sw**2*4._/**/REALKIND)
    f( 72) = (CI*eQED**3)/(2._/**/REALKIND*cw*sw)
    f( 73) = (CI*countertermnorm*eQED**5)/(2._/**/REALKIND*cw*sw)
    f( 74) = (CI*countertermnorm*eQED**5*EWctVbt)/(2._/**/REALKIND*cw*sw)
    f( 75) = (CI*countertermnorm*eQED**5*EWctVtb)/(2._/**/REALKIND*cw*sw)
    f( 76) = (CI*countertermnorm*eQED**3*gQCD**2)/(2._/**/REALKIND*cw*sw)
    f( 77) = (CI*countertermnorm*ctVbt*eQED**3*gQCD**2)/(2._/**/REALKIND*cw*sw)
    f( 78) = (CI*countertermnorm*eQED**5*MB)/(cw**2*sw)
    f( 79) = (CI*countertermnorm*eQED**5*MT)/(cw**2*sw)
    f( 80) = (CI*countertermnorm*eQED**5*MB*MT)/(2._/**/REALKIND*MW**2*sw)
    f( 81) = (countertermnorm*eQED**5*MB*MT)/(MW**2*sw*2._/**/REALKIND)
    f( 82) = (CI*countertermnorm*eQED**5)/(2._/**/REALKIND*cw*MW*sw)
    f( 83) = (countertermnorm*eQED**5*MB)/(MW*sw*3._/**/REALKIND)
    f( 84) = (countertermnorm*eQED**5*MB)/(MW*sw*2._/**/REALKIND)
    f( 85) = (CI*countertermnorm*eQED**5*EWctHZA*MB)/(3._/**/REALKIND*MW*sw)
    f( 86) = (CI*countertermnorm*eQED**5*EWctHZZ*MB)/(2._/**/REALKIND*MW*sw)
    f( 87) = (countertermnorm*eQED**5*MT)/(MW*sw*6._/**/REALKIND)
    f( 88) = (countertermnorm*eQED**5*MT)/(MW*sw*2._/**/REALKIND)
    f( 89) = (CI*countertermnorm*eQED**5*EWctHZA*MT)/(6._/**/REALKIND*MW*sw)
    f( 90) = (CI*countertermnorm*eQED**5*EWctHZZ*MT)/(2._/**/REALKIND*MW*sw)
    f( 91) = (CI*countertermnorm*eQED**5*MW)/(2._/**/REALKIND*cw*sw)
    f( 92) = (CI*countertermnorm*eQED**5)/(MW**2*sqrt2*sw)
    f( 93) = (2*eQED**5*integralnorm*SwB)/81._/**/REALKIND
    f( 94) = (4*eQED**5*integralnorm*SwB)/81._/**/REALKIND
    f( 95) = (8*eQED**5*integralnorm*SwB)/81._/**/REALKIND
    f( 96) = (eQED**5*integralnorm*SwB)/9._/**/REALKIND
    f( 97) = (2*eQED**5*integralnorm*SwB)/9._/**/REALKIND
    f( 98) = (4*eQED**5*integralnorm*SwB)/9._/**/REALKIND
    f( 99) = eQED**5*integralnorm*SwB
    f(100) = (eQED**5*integralnorm*SwB)/(cw**2*2._/**/REALKIND)
    f(101) = (eQED**3*gQCD**2*integralnorm*SwB)/9._/**/REALKIND
    f(102) = (2*eQED**3*gQCD**2*integralnorm*SwB)/9._/**/REALKIND
    f(103) = (4*eQED**3*gQCD**2*integralnorm*SwB)/9._/**/REALKIND
    f(104) = eQED**3*gQCD**2*integralnorm*SwB
    f(105) = (eQED**5*integralnorm*MB*SwB)/(cw**2*4._/**/REALKIND)
    f(106) = (eQED**5*integralnorm*MB*MH**2*SwB)/(cw**2*4._/**/REALKIND)
    f(107) = (eQED**5*integralnorm*MT*SwB)/(cw**2*4._/**/REALKIND)
    f(108) = (eQED**5*integralnorm*MH**2*MT*SwB)/(cw**2*4._/**/REALKIND)
    f(109) = (2*eQED**5*integralnorm*MW**2*SwB)/9._/**/REALKIND
    f(110) = (eQED**5*integralnorm*MW**2*SwB)/3._/**/REALKIND
    f(111) = (2*eQED**5*integralnorm*MW**2*SwB)/3._/**/REALKIND
    f(112) = (eQED**5*integralnorm*MW**2*SwB)/(cw**2*2._/**/REALKIND)
    f(113) = (eQED**5*integralnorm*MB*MW**2*SwB)/(cw**4*2._/**/REALKIND)
    f(114) = (eQED**5*integralnorm*MB*MW**2*SwB)/(cw**2*2._/**/REALKIND)
    f(115) = (eQED**5*integralnorm*MT*MW**2*SwB)/(cw**4*2._/**/REALKIND)
    f(116) = (eQED**5*integralnorm*MT*MW**2*SwB)/(cw**2*2._/**/REALKIND)
    f(117) = (eQED**5*integralnorm*SwB)/(cw*sw**5*16._/**/REALKIND)
    f(118) = (eQED**5*integralnorm*SwB)/(cw*sw**5*8._/**/REALKIND)
    f(119) = (eQED**5*integralnorm*SwB)/(cw*sw**5*4._/**/REALKIND)
    f(120) = (cw*eQED**5*integralnorm*SwB)/(sw**5*8._/**/REALKIND)
    f(121) = (cw*eQED**5*integralnorm*SwB)/(sw**5*4._/**/REALKIND)
    f(122) = (cw*eQED**5*integralnorm*SwB)/(sw**5*2._/**/REALKIND)
    f(123) = (cw**3*eQED**5*integralnorm*SwB)/(sw**5*2._/**/REALKIND)
    f(124) = (eQED**5*integralnorm*MB*SwB)/(cw*sw**5*8._/**/REALKIND)
    f(125) = (eQED**5*integralnorm*MB*SwB)/(cw*sw**5*4._/**/REALKIND)
    f(126) = (cw*eQED**5*integralnorm*MB*SwB)/(sw**5*4._/**/REALKIND)
    f(127) = (eQED**5*integralnorm*MT*SwB)/(cw*sw**5*8._/**/REALKIND)
    f(128) = (eQED**5*integralnorm*MT*SwB)/(cw*sw**5*4._/**/REALKIND)
    f(129) = (cw*eQED**5*integralnorm*MT*SwB)/(sw**5*4._/**/REALKIND)
    f(130) = (eQED**5*integralnorm*MB*MT*SwB)/(cw**5*sw**5*32._/**/REALKIND)
    f(131) = (eQED**5*integralnorm*MB*MT*SwB)/(cw**5*sw**5*16._/**/REALKIND)
    f(132) = (eQED**5*integralnorm*MB*MT*SwB)/(cw**5*sw**5*8._/**/REALKIND)
    f(133) = (eQED**5*integralnorm*MB*MT*SwB)/(cw*sw**5*32._/**/REALKIND)
    f(134) = (eQED**5*integralnorm*MB*MT*SwB)/(cw*sw**5*8._/**/REALKIND)
    f(135) = (eQED**5*integralnorm*MB*MT*SwB)/(cw*sw**5*4._/**/REALKIND)
    f(136) = (cw*eQED**5*integralnorm*MB*MT*SwB)/(sw**5*16._/**/REALKIND)
    f(137) = (cw*eQED**5*integralnorm*MB*MT*SwB)/(sw**5*4._/**/REALKIND)
    f(138) = (eQED**5*integralnorm*MB**2*SwB)/(cw*MW**4*sw**5*16._/**/REALKIND)
    f(139) = (eQED**5*integralnorm*MB*MH**2*SwB)/(cw*MW**4*sw**5*16._/**/REALKIND)
    f(140) = (eQED**5*integralnorm*MB*MT*SwB)/(cw*MW**4*sw**5*16._/**/REALKIND)
    f(141) = (eQED**5*integralnorm*MB**3*MT*SwB)/(cw*MW**4*sw**5*32._/**/REALKIND)
    f(142) = (eQED**5*integralnorm*MH**2*MT*SwB)/(cw*MW**4*sw**5*16._/**/REALKIND)
    f(143) = (eQED**5*integralnorm*MB*MH**2*MT*SwB)/(cw*MW**4*sw**5*32._/**/REALKIND)
    f(144) = (eQED**5*integralnorm*MB**2*MH**2*MT*SwB)/(cw*MW**4*sw**5*32._/**/REALKIND)
    f(145) = (3*eQED**5*integralnorm*lambdaHHH*MB**2*MH**2*MT*SwB)/(cw*MW**4*sw**5*32._/**/REALKIND)
    f(146) = (eQED**5*integralnorm*MB*MH**4*MT*SwB)/(cw*MW**4*sw**5*64._/**/REALKIND)
    f(147) = (eQED**5*integralnorm*MB*MH**4*MT*SwB)/(cw*MW**4*sw**5*32._/**/REALKIND)
    f(148) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**4*MT*SwB)/(cw*MW**4*sw**5*32._/**/REALKIND)
    f(149) = (9*eQED**5*integralnorm*lambdaHHH**2*MB*MH**4*MT*SwB)/(cw*MW**4*sw**5*64._/**/REALKIND)
    f(150) = (eQED**5*integralnorm*MT**2*SwB)/(cw*MW**4*sw**5*16._/**/REALKIND)
    f(151) = (eQED**5*integralnorm*MB**2*MT**2*SwB)/(cw*MW**4*sw**5*32._/**/REALKIND)
    f(152) = (eQED**5*integralnorm*MB*MH**2*MT**2*SwB)/(cw*MW**4*sw**5*32._/**/REALKIND)
    f(153) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**2*MT**2*SwB)/(cw*MW**4*sw**5*32._/**/REALKIND)
    f(154) = (eQED**5*integralnorm*MB*MT**3*SwB)/(cw*MW**4*sw**5*32._/**/REALKIND)
    f(155) = (eQED**5*integralnorm*SwB)/(cw*MW**2*sw**5*16._/**/REALKIND)
    f(156) = (cw*eQED**5*integralnorm*SwB)/(MW**2*sw**5*8._/**/REALKIND)
    f(157) = (cw*eQED**5*integralnorm*SwB)/(MW**2*sw**5*4._/**/REALKIND)
    f(158) = (eQED**5*integralnorm*MB*SwB)/(cw*MW**2*sw**5*16._/**/REALKIND)
    f(159) = (cw*eQED**5*integralnorm*MB*SwB)/(MW**2*sw**5*8._/**/REALKIND)
    f(160) = (eQED**5*integralnorm*MB**2*SwB)/(cw*MW**2*sw**5*16._/**/REALKIND)
    f(161) = (cw*eQED**5*integralnorm*MB**2*SwB)/(MW**2*sw**5*8._/**/REALKIND)
    f(162) = (eQED**5*integralnorm*MH**2*SwB)/(cw*MW**2*sw**5*16._/**/REALKIND)
    f(163) = (cw*eQED**5*integralnorm*MH**2*SwB)/(MW**2*sw**5*8._/**/REALKIND)
    f(164) = (eQED**5*integralnorm*MT*SwB)/(cw*MW**2*sw**5*16._/**/REALKIND)
    f(165) = (cw*eQED**5*integralnorm*MT*SwB)/(MW**2*sw**5*8._/**/REALKIND)
    f(166) = (eQED**5*integralnorm*MB*MT*SwB)/(cw**3*MW**2*sw**5*32._/**/REALKIND)
    f(167) = (eQED**5*integralnorm*MB*MT*SwB)/(cw**3*MW**2*sw**5*16._/**/REALKIND)
    f(168) = (eQED**5*integralnorm*MB*MT*SwB)/(cw*MW**2*sw**5*32._/**/REALKIND)
    f(169) = (eQED**5*integralnorm*MB*MT*SwB)/(cw*MW**2*sw**5*16._/**/REALKIND)
    f(170) = (cw*eQED**5*integralnorm*MB*MT*SwB)/(MW**2*sw**5*16._/**/REALKIND)
    f(171) = (cw*eQED**5*integralnorm*MB*MT*SwB)/(MW**2*sw**5*8._/**/REALKIND)
    f(172) = (eQED**5*integralnorm*MB**2*MT*SwB)/(cw**3*MW**2*sw**5*16._/**/REALKIND)
    f(173) = (eQED**5*integralnorm*MB*MH**2*MT*SwB)/(cw**3*MW**2*sw**5*16._/**/REALKIND)
    f(174) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**2*MT*SwB)/(cw**3*MW**2*sw**5*16._/**/REALKIND)
    f(175) = (eQED**5*integralnorm*MT**2*SwB)/(cw*MW**2*sw**5*16._/**/REALKIND)
    f(176) = (cw*eQED**5*integralnorm*MT**2*SwB)/(MW**2*sw**5*8._/**/REALKIND)
    f(177) = (eQED**5*integralnorm*MB*MT**2*SwB)/(cw**3*MW**2*sw**5*16._/**/REALKIND)
    f(178) = (eQED**5*integralnorm*MW**2*SwB)/(cw*sw**5*2._/**/REALKIND)
    f(179) = (cw*eQED**5*integralnorm*MW**2*SwB)/(sw**5*2._/**/REALKIND)
    f(180) = (eQED**5*integralnorm*SwB)/(sw**4*8._/**/REALKIND)
    f(181) = (eQED**5*integralnorm*SwB)/(sw**4*4._/**/REALKIND)
    f(182) = (eQED**5*integralnorm*SwB)/(cw**2*sw**4*4._/**/REALKIND)
    f(183) = (cw**2*eQED**5*integralnorm*SwB)/(sw**4*2._/**/REALKIND)
    f(184) = (eQED**5*integralnorm*MB*SwB)/(sw**4*8._/**/REALKIND)
    f(185) = (eQED**5*integralnorm*MB*SwB)/(sw**4*4._/**/REALKIND)
    f(186) = (eQED**5*integralnorm*MB*SwB)/(sw**4*2._/**/REALKIND)
    f(187) = (eQED**5*integralnorm*MB*SwB)/(cw**4*sw**4*8._/**/REALKIND)
    f(188) = (eQED**5*integralnorm*MB*SwB)/(cw**4*sw**4*4._/**/REALKIND)
    f(189) = (eQED**5*integralnorm*MB*SwB)/(cw**2*sw**4*8._/**/REALKIND)
    f(190) = (eQED**5*integralnorm*MB*SwB)/(cw**2*sw**4*4._/**/REALKIND)
    f(191) = (cw**2*eQED**5*integralnorm*MB*SwB)/(sw**4*4._/**/REALKIND)
    f(192) = (cw**2*eQED**5*integralnorm*MB*SwB)/(sw**4*2._/**/REALKIND)
    f(193) = (eQED**5*integralnorm*MB**2*SwB)/(cw**4*sw**4*4._/**/REALKIND)
    f(194) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**2*SwB)/(cw**4*sw**4*4._/**/REALKIND)
    f(195) = (eQED**5*integralnorm*MT*SwB)/(sw**4*8._/**/REALKIND)
    f(196) = (eQED**5*integralnorm*MT*SwB)/(sw**4*4._/**/REALKIND)
    f(197) = (eQED**5*integralnorm*MT*SwB)/(sw**4*2._/**/REALKIND)
    f(198) = (eQED**5*integralnorm*MT*SwB)/(cw**4*sw**4*8._/**/REALKIND)
    f(199) = (eQED**5*integralnorm*MT*SwB)/(cw**4*sw**4*4._/**/REALKIND)
    f(200) = (eQED**5*integralnorm*MT*SwB)/(cw**2*sw**4*8._/**/REALKIND)
    f(201) = (eQED**5*integralnorm*MT*SwB)/(cw**2*sw**4*4._/**/REALKIND)
    f(202) = (cw**2*eQED**5*integralnorm*MT*SwB)/(sw**4*4._/**/REALKIND)
    f(203) = (cw**2*eQED**5*integralnorm*MT*SwB)/(sw**4*2._/**/REALKIND)
    f(204) = (eQED**5*integralnorm*MB*MT*SwB)/(sw**4*16._/**/REALKIND)
    f(205) = (eQED**5*integralnorm*MB*MT*SwB)/(sw**4*4._/**/REALKIND)
    f(206) = (eQED**5*integralnorm*MB*MT*SwB)/(cw**4*sw**4*16._/**/REALKIND)
    f(207) = (eQED**5*integralnorm*MB*MT*SwB)/(cw**4*sw**4*8._/**/REALKIND)
    f(208) = (eQED**5*integralnorm*MB*MT*SwB)/(cw**4*sw**4*4._/**/REALKIND)
    f(209) = (3*eQED**5*integralnorm*lambdaHHH*MH**2*MT*SwB)/(cw**4*sw**4*4._/**/REALKIND)
    f(210) = (eQED**5*integralnorm*MT**2*SwB)/(cw**4*sw**4*4._/**/REALKIND)
    f(211) = (eQED**5*integralnorm*SwB)/(MW**4*sw**4*4._/**/REALKIND)
    f(212) = (eQED**5*integralnorm*MB**2*SwB)/(MW**4*sw**4*8._/**/REALKIND)
    f(213) = (eQED**5*integralnorm*MB*MH**2*SwB)/(MW**4*sw**4*8._/**/REALKIND)
    f(214) = (eQED**5*integralnorm*MH**4*SwB)/(MW**4*sw**4*8._/**/REALKIND)
    f(215) = (eQED**5*integralnorm*MB*MT*SwB)/(MW**4*sw**4*8._/**/REALKIND)
    f(216) = (eQED**5*integralnorm*MB**3*MT*SwB)/(MW**4*sw**4*16._/**/REALKIND)
    f(217) = (eQED**5*integralnorm*MH**2*MT*SwB)/(MW**4*sw**4*8._/**/REALKIND)
    f(218) = (eQED**5*integralnorm*MB**2*MH**2*MT*SwB)/(MW**4*sw**4*16._/**/REALKIND)
    f(219) = (3*eQED**5*integralnorm*lambdaHHH*MB**2*MH**2*MT*SwB)/(MW**4*sw**4*16._/**/REALKIND)
    f(220) = (eQED**5*integralnorm*MB*MH**4*MT*SwB)/(MW**4*sw**4*32._/**/REALKIND)
    f(221) = (eQED**5*integralnorm*MB*MH**4*MT*SwB)/(MW**4*sw**4*16._/**/REALKIND)
    f(222) = (9*eQED**5*integralnorm*lambdaHHH**2*MB*MH**4*MT*SwB)/(MW**4*sw**4*32._/**/REALKIND)
    f(223) = (eQED**5*integralnorm*MT**2*SwB)/(MW**4*sw**4*8._/**/REALKIND)
    f(224) = (eQED**5*integralnorm*MB**2*MT**2*SwB)/(MW**4*sw**4*16._/**/REALKIND)
    f(225) = (eQED**5*integralnorm*MB*MH**2*MT**2*SwB)/(MW**4*sw**4*16._/**/REALKIND)
    f(226) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**2*MT**2*SwB)/(MW**4*sw**4*16._/**/REALKIND)
    f(227) = (eQED**5*integralnorm*MB*MT**3*SwB)/(MW**4*sw**4*16._/**/REALKIND)
    f(228) = (eQED**5*integralnorm*SwB)/(MW**2*sw**4*8._/**/REALKIND)
    f(229) = (eQED**5*integralnorm*SwB)/(MW**2*sw**4*4._/**/REALKIND)
    f(230) = (eQED**5*integralnorm*MB*SwB)/(MW**2*sw**4*8._/**/REALKIND)
    f(231) = (eQED**5*integralnorm*MB*SwB)/(cw**2*MW**2*sw**4*4._/**/REALKIND)
    f(232) = (eQED**5*integralnorm*MB**2*SwB)/(MW**2*sw**4*8._/**/REALKIND)
    f(233) = (eQED**5*integralnorm*MB**2*SwB)/(cw**2*MW**2*sw**4*16._/**/REALKIND)
    f(234) = (eQED**5*integralnorm*MB**2*SwB)/(cw**2*MW**2*sw**4*8._/**/REALKIND)
    f(235) = (eQED**5*integralnorm*MB**3*SwB)/(cw**2*MW**2*sw**4*8._/**/REALKIND)
    f(236) = (eQED**5*integralnorm*MH**2*SwB)/(MW**2*sw**4*8._/**/REALKIND)
    f(237) = (eQED**5*integralnorm*MH**2*SwB)/(cw**2*MW**2*sw**4*4._/**/REALKIND)
    f(238) = (eQED**5*integralnorm*MB*MH**2*SwB)/(cw**2*MW**2*sw**4*16._/**/REALKIND)
    f(239) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**2*SwB)/(cw**2*MW**2*sw**4*16._/**/REALKIND)
    f(240) = (eQED**5*integralnorm*MB**2*MH**2*SwB)/(cw**2*MW**2*sw**4*8._/**/REALKIND)
    f(241) = (3*eQED**5*integralnorm*lambdaHHH*MB**2*MH**2*SwB)/(cw**2*MW**2*sw**4*8._/**/REALKIND)
    f(242) = (eQED**5*integralnorm*MB*MH**4*SwB)/(cw**2*MW**2*sw**4*16._/**/REALKIND)
    f(243) = (eQED**5*integralnorm*MB*MH**4*SwB)/(cw**2*MW**2*sw**4*8._/**/REALKIND)
    f(244) = (9*eQED**5*integralnorm*lambdaHHH**2*MB*MH**4*SwB)/(cw**2*MW**2*sw**4*16._/**/REALKIND)
    f(245) = (eQED**5*integralnorm*MT*SwB)/(MW**2*sw**4*8._/**/REALKIND)
    f(246) = (eQED**5*integralnorm*MT*SwB)/(cw**2*MW**2*sw**4*4._/**/REALKIND)
    f(247) = (eQED**5*integralnorm*MB*MT*SwB)/(MW**2*sw**4*16._/**/REALKIND)
    f(248) = (eQED**5*integralnorm*MB*MT*SwB)/(MW**2*sw**4*8._/**/REALKIND)
    f(249) = (eQED**5*integralnorm*MB*MT*SwB)/(cw**2*MW**2*sw**4*16._/**/REALKIND)
    f(250) = (eQED**5*integralnorm*MB*MT*SwB)/(cw**2*MW**2*sw**4*8._/**/REALKIND)
    f(251) = (eQED**5*integralnorm*MB**2*MT*SwB)/(cw**2*MW**2*sw**4*8._/**/REALKIND)
    f(252) = (eQED**5*integralnorm*MH**2*MT*SwB)/(cw**2*MW**2*sw**4*16._/**/REALKIND)
    f(253) = (3*eQED**5*integralnorm*lambdaHHH*MH**2*MT*SwB)/(cw**2*MW**2*sw**4*16._/**/REALKIND)
    f(254) = (eQED**5*integralnorm*MB*MH**2*MT*SwB)/(cw**2*MW**2*sw**4*8._/**/REALKIND)
    f(255) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**2*MT*SwB)/(cw**2*MW**2*sw**4*8._/**/REALKIND)
    f(256) = (eQED**5*integralnorm*MH**4*MT*SwB)/(cw**2*MW**2*sw**4*16._/**/REALKIND)
    f(257) = (eQED**5*integralnorm*MH**4*MT*SwB)/(cw**2*MW**2*sw**4*8._/**/REALKIND)
    f(258) = (9*eQED**5*integralnorm*lambdaHHH**2*MH**4*MT*SwB)/(cw**2*MW**2*sw**4*16._/**/REALKIND)
    f(259) = (eQED**5*integralnorm*MT**2*SwB)/(MW**2*sw**4*8._/**/REALKIND)
    f(260) = (eQED**5*integralnorm*MT**2*SwB)/(cw**2*MW**2*sw**4*16._/**/REALKIND)
    f(261) = (eQED**5*integralnorm*MT**2*SwB)/(cw**2*MW**2*sw**4*8._/**/REALKIND)
    f(262) = (eQED**5*integralnorm*MB*MT**2*SwB)/(cw**2*MW**2*sw**4*8._/**/REALKIND)
    f(263) = (eQED**5*integralnorm*MH**2*MT**2*SwB)/(cw**2*MW**2*sw**4*8._/**/REALKIND)
    f(264) = (3*eQED**5*integralnorm*lambdaHHH*MH**2*MT**2*SwB)/(cw**2*MW**2*sw**4*8._/**/REALKIND)
    f(265) = (eQED**5*integralnorm*MT**3*SwB)/(cw**2*MW**2*sw**4*8._/**/REALKIND)
    f(266) = (eQED**5*integralnorm*MW**2*SwB)/(sw**4*2._/**/REALKIND)
    f(267) = (eQED**5*integralnorm*MW**2*SwB)/(cw**2*sw**4*2._/**/REALKIND)
    f(268) = (eQED**5*integralnorm*MB*MW**2*SwB)/(cw**6*sw**4*8._/**/REALKIND)
    f(269) = (eQED**5*integralnorm*MB*MW**2*SwB)/(cw**6*sw**4*4._/**/REALKIND)
    f(270) = (eQED**5*integralnorm*MB*MW**2*SwB)/(cw**6*sw**4*2._/**/REALKIND)
    f(271) = (eQED**5*integralnorm*MB*MW**2*SwB)/(cw**2*sw**4*8._/**/REALKIND)
    f(272) = (eQED**5*integralnorm*MB*MW**2*SwB)/(cw**2*sw**4*2._/**/REALKIND)
    f(273) = (eQED**5*integralnorm*MT*MW**2*SwB)/(cw**6*sw**4*8._/**/REALKIND)
    f(274) = (eQED**5*integralnorm*MT*MW**2*SwB)/(cw**6*sw**4*4._/**/REALKIND)
    f(275) = (eQED**5*integralnorm*MT*MW**2*SwB)/(cw**6*sw**4*2._/**/REALKIND)
    f(276) = (eQED**5*integralnorm*MT*MW**2*SwB)/(cw**2*sw**4*8._/**/REALKIND)
    f(277) = (eQED**5*integralnorm*MT*MW**2*SwB)/(cw**2*sw**4*2._/**/REALKIND)
    f(278) = (eQED**5*integralnorm*SwB)/(cw**3*sw**3*4._/**/REALKIND)
    f(279) = (eQED**5*integralnorm*SwB)/(cw*sw**3*8._/**/REALKIND)
    f(280) = (eQED**5*integralnorm*SwB)/(cw*sw**3*4._/**/REALKIND)
    f(281) = (cw*eQED**5*integralnorm*SwB)/(sw**3*18._/**/REALKIND)
    f(282) = (cw*eQED**5*integralnorm*SwB)/(sw**3*9._/**/REALKIND)
    f(283) = (cw*eQED**5*integralnorm*SwB)/(sw**3*6._/**/REALKIND)
    f(284) = (2*cw*eQED**5*integralnorm*SwB)/(sw**3*9._/**/REALKIND)
    f(285) = (cw*eQED**5*integralnorm*SwB)/(sw**3*3._/**/REALKIND)
    f(286) = (cw*eQED**5*integralnorm*SwB)/(sw**3*2._/**/REALKIND)
    f(287) = (cw**3*eQED**5*integralnorm*SwB)/sw**3
    f(288) = (cw*eQED**3*gQCD**2*integralnorm*SwB)/(sw**3*2._/**/REALKIND)
    f(289) = (eQED**5*integralnorm*MB*SwB)/(cw**3*sw**3*4._/**/REALKIND)
    f(290) = (eQED**5*integralnorm*MB*SwB)/(cw*sw**3*12._/**/REALKIND)
    f(291) = (eQED**5*integralnorm*MB*SwB)/(cw*sw**3*8._/**/REALKIND)
    f(292) = (eQED**5*integralnorm*MB*SwB)/(cw*sw**3*6._/**/REALKIND)
    f(293) = (eQED**5*integralnorm*MB*SwB)/(cw*sw**3*4._/**/REALKIND)
    f(294) = (eQED**5*integralnorm*MB*SwB)/(cw*sw**3*3._/**/REALKIND)
    f(295) = (cw*eQED**5*integralnorm*MB*SwB)/(sw**3*6._/**/REALKIND)
    f(296) = (cw*eQED**5*integralnorm*MB*SwB)/(sw**3*4._/**/REALKIND)
    f(297) = (cw*eQED**5*integralnorm*MB*SwB)/(sw**3*3._/**/REALKIND)
    f(298) = (cw*eQED**5*integralnorm*MB*SwB)/(sw**3*2._/**/REALKIND)
    f(299) = (eQED**5*integralnorm*MH**2*SwB)/(cw**3*sw**3*4._/**/REALKIND)
    f(300) = (eQED**5*integralnorm*MH**2*SwB)/(cw*sw**3*8._/**/REALKIND)
    f(301) = (eQED**5*integralnorm*MH**2*SwB)/(cw*sw**3*4._/**/REALKIND)
    f(302) = (eQED**5*integralnorm*MT*SwB)/(cw**3*sw**3*4._/**/REALKIND)
    f(303) = (eQED**5*integralnorm*MT*SwB)/(cw*sw**3*24._/**/REALKIND)
    f(304) = (eQED**5*integralnorm*MT*SwB)/(cw*sw**3*12._/**/REALKIND)
    f(305) = (eQED**5*integralnorm*MT*SwB)/(cw*sw**3*8._/**/REALKIND)
    f(306) = (eQED**5*integralnorm*MT*SwB)/(cw*sw**3*6._/**/REALKIND)
    f(307) = (eQED**5*integralnorm*MT*SwB)/(cw*sw**3*4._/**/REALKIND)
    f(308) = (cw*eQED**5*integralnorm*MT*SwB)/(sw**3*12._/**/REALKIND)
    f(309) = (cw*eQED**5*integralnorm*MT*SwB)/(sw**3*6._/**/REALKIND)
    f(310) = (cw*eQED**5*integralnorm*MT*SwB)/(sw**3*4._/**/REALKIND)
    f(311) = (cw*eQED**5*integralnorm*MT*SwB)/(sw**3*2._/**/REALKIND)
    f(312) = (eQED**5*integralnorm*MB*MT*SwB)/(cw**3*sw**3*8._/**/REALKIND)
    f(313) = (eQED**5*integralnorm*MB*MT*SwB)/(cw*sw**3*8._/**/REALKIND)
    f(314) = (eQED**5*integralnorm*SwB)/(cw*MW**2*sw**3*8._/**/REALKIND)
    f(315) = (eQED**5*integralnorm*SwB)/(cw*MW**2*sw**3*4._/**/REALKIND)
    f(316) = (eQED**5*integralnorm*MB*SwB)/(cw*MW**2*sw**3*8._/**/REALKIND)
    f(317) = (eQED**5*integralnorm*MB**2*SwB)/(cw*MW**2*sw**3*36._/**/REALKIND)
    f(318) = (eQED**5*integralnorm*MB**2*SwB)/(cw*MW**2*sw**3*8._/**/REALKIND)
    f(319) = (eQED**3*gQCD**2*integralnorm*MB**2*SwB)/(cw*MW**2*sw**3*8._/**/REALKIND)
    f(320) = (eQED**5*integralnorm*MH**2*SwB)/(cw*MW**2*sw**3*8._/**/REALKIND)
    f(321) = (eQED**5*integralnorm*MB*MH**2*SwB)/(cw*MW**2*sw**3*12._/**/REALKIND)
    f(322) = (eQED**5*integralnorm*MB*MH**2*SwB)/(cw*MW**2*sw**3*8._/**/REALKIND)
    f(323) = (eQED**5*integralnorm*MH**4*SwB)/(cw*MW**2*sw**3*8._/**/REALKIND)
    f(324) = (eQED**5*integralnorm*MT*SwB)/(cw*MW**2*sw**3*8._/**/REALKIND)
    f(325) = (eQED**5*integralnorm*MB*MT*SwB)/(cw*MW**2*sw**3*72._/**/REALKIND)
    f(326) = (eQED**5*integralnorm*MB*MT*SwB)/(cw*MW**2*sw**3*36._/**/REALKIND)
    f(327) = (eQED**5*integralnorm*MB*MT*SwB)/(cw*MW**2*sw**3*18._/**/REALKIND)
    f(328) = (eQED**5*integralnorm*MB*MT*SwB)/(cw*MW**2*sw**3*16._/**/REALKIND)
    f(329) = (eQED**5*integralnorm*MB*MT*SwB)/(cw*MW**2*sw**3*8._/**/REALKIND)
    f(330) = (eQED**3*gQCD**2*integralnorm*MB*MT*SwB)/(cw*MW**2*sw**3*8._/**/REALKIND)
    f(331) = (eQED**5*integralnorm*MH**2*MT*SwB)/(cw*MW**2*sw**3*24._/**/REALKIND)
    f(332) = (eQED**5*integralnorm*MH**2*MT*SwB)/(cw*MW**2*sw**3*8._/**/REALKIND)
    f(333) = (eQED**5*integralnorm*MB*MH**2*MT*SwB)/(cw*MW**2*sw**3*16._/**/REALKIND)
    f(334) = (eQED**5*integralnorm*MT**2*SwB)/(cw*MW**2*sw**3*36._/**/REALKIND)
    f(335) = (eQED**5*integralnorm*MT**2*SwB)/(cw*MW**2*sw**3*8._/**/REALKIND)
    f(336) = (eQED**3*gQCD**2*integralnorm*MT**2*SwB)/(cw*MW**2*sw**3*8._/**/REALKIND)
    f(337) = (eQED**5*integralnorm*MW**2*SwB)/(cw**3*sw**3*4._/**/REALKIND)
    f(338) = (eQED**5*integralnorm*MW**2*SwB)/(cw**3*sw**3*2._/**/REALKIND)
    f(339) = (eQED**5*integralnorm*MW**2*SwB)/(cw*sw**3*4._/**/REALKIND)
    f(340) = (eQED**5*integralnorm*MW**2*SwB)/(cw*sw**3*2._/**/REALKIND)
    f(341) = (eQED**5*integralnorm*MW**2*SwB)/(cw*sw**3)
    f(342) = (cw*eQED**5*integralnorm*MW**2*SwB)/(sw**3*2._/**/REALKIND)
    f(343) = (eQED**5*integralnorm*SwB)/(sw**2*18._/**/REALKIND)
    f(344) = (eQED**5*integralnorm*SwB)/(sw**2*9._/**/REALKIND)
    f(345) = (eQED**5*integralnorm*SwB)/(sw**2*6._/**/REALKIND)
    f(346) = (2*eQED**5*integralnorm*SwB)/(sw**2*9._/**/REALKIND)
    f(347) = (eQED**5*integralnorm*SwB)/(sw**2*3._/**/REALKIND)
    f(348) = (eQED**5*integralnorm*SwB)/(sw**2*2._/**/REALKIND)
    f(349) = (eQED**5*integralnorm*SwB)/(cw**2*sw**2*4._/**/REALKIND)
    f(350) = (cw**2*eQED**5*integralnorm*SwB)/(sw**2*3._/**/REALKIND)
    f(351) = (2*cw**2*eQED**5*integralnorm*SwB)/(sw**2*3._/**/REALKIND)
    f(352) = (cw**2*eQED**5*integralnorm*SwB)/sw**2
    f(353) = (eQED**3*gQCD**2*integralnorm*SwB)/(sw**2*2._/**/REALKIND)
    f(354) = (eQED**5*integralnorm*MB*SwB)/(sw**2*6._/**/REALKIND)
    f(355) = (eQED**5*integralnorm*MB*SwB)/(sw**2*4._/**/REALKIND)
    f(356) = (eQED**5*integralnorm*MB*SwB)/(sw**2*3._/**/REALKIND)
    f(357) = (eQED**5*integralnorm*MB*SwB)/(cw**2*sw**2*18._/**/REALKIND)
    f(358) = (eQED**5*integralnorm*MB*SwB)/(cw**2*sw**2*9._/**/REALKIND)
    f(359) = (eQED**5*integralnorm*MB*SwB)/(cw**2*sw**2*8._/**/REALKIND)
    f(360) = (2*eQED**5*integralnorm*MB*SwB)/(cw**2*sw**2*9._/**/REALKIND)
    f(361) = (eQED**5*integralnorm*MB*SwB)/(cw**2*sw**2*2._/**/REALKIND)
    f(362) = (eQED**3*gQCD**2*integralnorm*MB*SwB)/(cw**2*sw**2*2._/**/REALKIND)
    f(363) = (eQED**5*integralnorm*MH**2*SwB)/(cw**2*sw**2*6._/**/REALKIND)
    f(364) = (eQED**5*integralnorm*MH**2*SwB)/(cw**2*sw**2*3._/**/REALKIND)
    f(365) = (eQED**5*integralnorm*MT*SwB)/(sw**2*12._/**/REALKIND)
    f(366) = (eQED**5*integralnorm*MT*SwB)/(sw**2*6._/**/REALKIND)
    f(367) = (eQED**5*integralnorm*MT*SwB)/(sw**2*4._/**/REALKIND)
    f(368) = (eQED**5*integralnorm*MT*SwB)/(cw**2*sw**2*18._/**/REALKIND)
    f(369) = (eQED**5*integralnorm*MT*SwB)/(cw**2*sw**2*9._/**/REALKIND)
    f(370) = (eQED**5*integralnorm*MT*SwB)/(cw**2*sw**2*8._/**/REALKIND)
    f(371) = (2*eQED**5*integralnorm*MT*SwB)/(cw**2*sw**2*9._/**/REALKIND)
    f(372) = (eQED**5*integralnorm*MT*SwB)/(cw**2*sw**2*2._/**/REALKIND)
    f(373) = (eQED**3*gQCD**2*integralnorm*MT*SwB)/(cw**2*sw**2*2._/**/REALKIND)
    f(374) = (eQED**5*integralnorm*SwB)/(MW**2*sw**2*18._/**/REALKIND)
    f(375) = (eQED**5*integralnorm*SwB)/(MW**2*sw**2*9._/**/REALKIND)
    f(376) = (eQED**5*integralnorm*SwB)/(MW**2*sw**2*6._/**/REALKIND)
    f(377) = (2*eQED**5*integralnorm*SwB)/(MW**2*sw**2*9._/**/REALKIND)
    f(378) = (eQED**5*integralnorm*SwB)/(MW**2*sw**2*3._/**/REALKIND)
    f(379) = (eQED**5*integralnorm*SwB)/(MW**2*sw**2*2._/**/REALKIND)
    f(380) = (eQED**3*gQCD**2*integralnorm*SwB)/(MW**2*sw**2*2._/**/REALKIND)
    f(381) = (eQED**5*integralnorm*MB**2*SwB)/(MW**2*sw**2*18._/**/REALKIND)
    f(382) = (eQED**5*integralnorm*MB**2*SwB)/(MW**2*sw**2*4._/**/REALKIND)
    f(383) = (eQED**3*gQCD**2*integralnorm*MB**2*SwB)/(MW**2*sw**2*4._/**/REALKIND)
    f(384) = (eQED**5*integralnorm*MB*MH**2*SwB)/(MW**2*sw**2*6._/**/REALKIND)
    f(385) = (eQED**5*integralnorm*MB*MT*SwB)/(MW**2*sw**2*36._/**/REALKIND)
    f(386) = (eQED**5*integralnorm*MB*MT*SwB)/(MW**2*sw**2*18._/**/REALKIND)
    f(387) = (eQED**5*integralnorm*MB*MT*SwB)/(MW**2*sw**2*9._/**/REALKIND)
    f(388) = (eQED**5*integralnorm*MB*MT*SwB)/(MW**2*sw**2*4._/**/REALKIND)
    f(389) = (eQED**3*gQCD**2*integralnorm*MB*MT*SwB)/(MW**2*sw**2*4._/**/REALKIND)
    f(390) = (eQED**5*integralnorm*MH**2*MT*SwB)/(MW**2*sw**2*12._/**/REALKIND)
    f(391) = (eQED**5*integralnorm*MT**2*SwB)/(MW**2*sw**2*18._/**/REALKIND)
    f(392) = (eQED**5*integralnorm*MT**2*SwB)/(MW**2*sw**2*4._/**/REALKIND)
    f(393) = (eQED**3*gQCD**2*integralnorm*MT**2*SwB)/(MW**2*sw**2*4._/**/REALKIND)
    f(394) = (eQED**5*integralnorm*MW**2*SwB)/(sw**2*2._/**/REALKIND)
    f(395) = (eQED**5*integralnorm*MW**2*SwB)/(cw**4*sw**2)
    f(396) = (eQED**5*integralnorm*MW**2*SwB)/(cw**2*sw**2*6._/**/REALKIND)
    f(397) = (eQED**5*integralnorm*MW**2*SwB)/(cw**2*sw**2*3._/**/REALKIND)
    f(398) = (2*eQED**5*integralnorm*MW**2*SwB)/(cw**2*sw**2*3._/**/REALKIND)
    f(399) = (eQED**5*integralnorm*SwB)/(cw*sw*18._/**/REALKIND)
    f(400) = (eQED**5*integralnorm*SwB)/(cw*sw*9._/**/REALKIND)
    f(401) = (eQED**5*integralnorm*SwB)/(cw*sw*6._/**/REALKIND)
    f(402) = (2*eQED**5*integralnorm*SwB)/(cw*sw*9._/**/REALKIND)
    f(403) = (eQED**5*integralnorm*SwB)/(cw*sw*3._/**/REALKIND)
    f(404) = (eQED**5*integralnorm*SwB)/(cw*sw*2._/**/REALKIND)
    f(405) = (2*cw*eQED**5*integralnorm*SwB)/(sw*9._/**/REALKIND)
    f(406) = (cw*eQED**5*integralnorm*SwB)/(sw*3._/**/REALKIND)
    f(407) = (2*cw*eQED**5*integralnorm*SwB)/(sw*3._/**/REALKIND)
    f(408) = (eQED**3*gQCD**2*integralnorm*SwB)/(cw*sw*2._/**/REALKIND)
    f(409) = (eQED**5*integralnorm*MB*SwB)/(cw*sw*6._/**/REALKIND)
    f(410) = (eQED**5*integralnorm*MB*SwB)/(cw*sw*4._/**/REALKIND)
    f(411) = (eQED**5*integralnorm*MB*MH**2*SwB)/(cw*sw*6._/**/REALKIND)
    f(412) = (eQED**5*integralnorm*MT*SwB)/(cw*sw*12._/**/REALKIND)
    f(413) = (eQED**5*integralnorm*MT*SwB)/(cw*sw*4._/**/REALKIND)
    f(414) = (eQED**5*integralnorm*MH**2*MT*SwB)/(cw*sw*12._/**/REALKIND)
    f(415) = (eQED**5*integralnorm*MW**2*SwB)/(cw**3*sw*2._/**/REALKIND)
    f(416) = (eQED**5*integralnorm*MW**2*SwB)/(cw*sw*6._/**/REALKIND)
    f(417) = (eQED**5*integralnorm*MW**2*SwB)/(cw*sw*3._/**/REALKIND)
    f(418) = (eQED**5*integralnorm*MW**2*SwB)/(cw*sw*2._/**/REALKIND)
    f(419) = (2*cw*eQED**5*integralnorm*MW**2*SwB)/(sw*9._/**/REALKIND)
    f(420) = (eQED**5*integralnorm*MB*MW**2*SwB)/(cw**3*sw*3._/**/REALKIND)
    f(421) = (eQED**5*integralnorm*MB*MW**2*SwB)/(cw*sw*3._/**/REALKIND)
    f(422) = (eQED**5*integralnorm*MT*MW**2*SwB)/(cw**3*sw*6._/**/REALKIND)
    f(423) = (eQED**5*integralnorm*MT*MW**2*SwB)/(cw*sw*6._/**/REALKIND)
    f(424) = (eQED**5*integralnorm*MW**2*sw*SwB)/(cw**3*2._/**/REALKIND)
    f(425) = (2*eQED**5*integralnorm*MW**2*sw*SwB)/(cw*9._/**/REALKIND)
    f(426) = (eQED**5*integralnorm*MW**2*sw*SwB)/(cw*3._/**/REALKIND)
    f(427) = (2*eQED**5*integralnorm*MW**2*sw*SwB)/(cw*3._/**/REALKIND)
    f(428) = (eQED**5*integralnorm*MW**2*sw*SwB)/cw
    f(429) = (eQED**5*integralnorm*MW**2*sw**2*SwB)/(cw**2*3._/**/REALKIND)
    f(430) = (2*eQED**5*integralnorm*MW**2*sw**2*SwB)/(cw**2*3._/**/REALKIND)
    f(431) = (eQED**5*integralnorm*MW**2*sw**2*SwB)/cw**2
    f(432) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw**3*sw**5*8._/**/REALKIND))
    f(433) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*sw**5*16._/**/REALKIND))
    f(434) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*sw**5*8._/**/REALKIND))
    f(435) = -((cw*eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(sw**5*4._/**/REALKIND))
    f(436) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*MW**4*sw**5*8._/**/REALKIND))
    f(437) = -((eQED**5*integralnorm*MB**2*(cw - sw)*(cw + sw)*SwB)/(cw*MW**4*sw**5*16._/**/REALKIND))
    f(438) = -((eQED**5*integralnorm*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw*MW**4*sw**5*8._/**/REALKIND))
    f(439) = -((eQED**5*integralnorm*MB*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw*MW**4*sw**5*16._/**/REALKIND))
    f(440) = -((eQED**5*integralnorm*MH**4*(cw - sw)*(cw + sw)*SwB)/(cw*MW**4*sw**5*16._/**/REALKIND))
    f(441) = -((eQED**5*integralnorm*MB*MT*(cw - sw)*(cw + sw)*SwB)/(cw*MW**4*sw**5*16._/**/REALKIND))
    f(442) = -((eQED**5*integralnorm*MH**2*MT*(cw - sw)*(cw + sw)*SwB)/(cw*MW**4*sw**5*16._/**/REALKIND))
    f(443) = -((eQED**5*integralnorm*MB*MH**2*MT*(cw - sw)*(cw + sw)*SwB)/(cw*MW**4*sw**5*32._/**/REALKIND))
    f(444) = -((eQED**5*integralnorm*MB*MH**4*MT*(cw - sw)*(cw + sw)*SwB)/(cw*MW**4*sw**5*32._/**/REALKIND))
    f(445) = -((eQED**5*integralnorm*MT**2*(cw - sw)*(cw + sw)*SwB)/(cw*MW**4*sw**5*16._/**/REALKIND))
    f(446) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*MW**2*sw**5*16._/**/REALKIND))
    f(447) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*MW**2*sw**5*8._/**/REALKIND))
    f(448) = -((eQED**5*integralnorm*MB*(cw - sw)*(cw + sw)*SwB)/(cw**3*MW**2*sw**5*8._/**/REALKIND))
    f(449) = -((eQED**5*integralnorm*MB*(cw - sw)*(cw + sw)*SwB)/(cw*MW**2*sw**5*16._/**/REALKIND))
    f(450) = -((eQED**5*integralnorm*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw**3*MW**2*sw**5*8._/**/REALKIND))
    f(451) = -((eQED**5*integralnorm*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw*MW**2*sw**5*16._/**/REALKIND))
    f(452) = -((eQED**5*integralnorm*MT*(cw - sw)*(cw + sw)*SwB)/(cw**3*MW**2*sw**5*8._/**/REALKIND))
    f(453) = -((eQED**5*integralnorm*MT*(cw - sw)*(cw + sw)*SwB)/(cw*MW**2*sw**5*16._/**/REALKIND))
    f(454) = -((eQED**5*integralnorm*MB*MT*(cw - sw)*(cw + sw)*SwB)/(cw*MW**2*sw**5*32._/**/REALKIND))
    f(455) = -((eQED**5*integralnorm*MB*MH**2*MT*(cw - sw)*(cw + sw)*SwB)/(cw**3*MW**2*sw**5*16._/**/REALKIND))
    f(456) = (eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw**2*sw**2*4._/**/REALKIND)
    f(457) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(sw**4*4._/**/REALKIND))
    f(458) = (eQED**5*integralnorm*(-cw + sw)*(cw + sw)*SwB)/(cw**2*sw**4*8._/**/REALKIND)
    f(459) = (eQED**5*integralnorm*MB*(cw - sw)*(cw + sw)*SwB)/(cw**2*sw**2*8._/**/REALKIND)
    f(460) = -((eQED**5*integralnorm*MB*SwB*(cw**4*4._/**/REALKIND + sw**4*4._/**/REALKIND  &
      - cw**2*sw**2*8._/**/REALKIND))/(cw**4*sw**4*4._/**/REALKIND*8._/**/REALKIND))
    f(461) = (eQED**5*integralnorm*MT*(cw - sw)*(cw + sw)*SwB)/(cw**2*sw**2*8._/**/REALKIND)
    f(462) = -((eQED**5*integralnorm*MT*SwB*(cw**4*4._/**/REALKIND + sw**4*4._/**/REALKIND  &
      - cw**2*sw**2*8._/**/REALKIND))/(cw**4*sw**4*4._/**/REALKIND*8._/**/REALKIND))
    f(463) = -((eQED**5*integralnorm*SwB*(cw**4*4._/**/REALKIND + sw**4*4._/**/REALKIND  &
      - cw**2*sw**2*8._/**/REALKIND))/(cw**2*MW**2*sw**4*4._/**/REALKIND*8._/**/REALKIND))
    f(464) = -((eQED**5*integralnorm*SwB*(cw**4*2._/**/REALKIND + sw**4*2._/**/REALKIND  &
      - cw**2*sw**2*4._/**/REALKIND))/(cw**2*MW**2*sw**4*2._/**/REALKIND*4._/**/REALKIND))
    f(465) = -((eQED**5*integralnorm*MB*MH**2*SwB*(-(cw**2*sw**2*16._/**/REALKIND) + cw**4*8._/**/REALKIND  &
      + sw**4*8._/**/REALKIND))/(cw**2*MW**2*sw**4*16._/**/REALKIND*8._/**/REALKIND))
    f(466) = -((eQED**5*integralnorm*MB*MH**2*SwB*(cw**4*4._/**/REALKIND + sw**4*4._/**/REALKIND  &
      - cw**2*sw**2*8._/**/REALKIND))/(cw**2*MW**2*sw**4*4._/**/REALKIND*8._/**/REALKIND))
    f(467) = (eQED**5*integralnorm*MB*MH**2*(-cw + sw)*(cw + sw)*SwB)/(cw**2*MW**2*sw**4*16._/**/REALKIND)
    f(468) = -((eQED**5*integralnorm*MH**2*MT*SwB*(-(cw**2*sw**2*16._/**/REALKIND) + cw**4*8._/**/REALKIND  &
      + sw**4*8._/**/REALKIND))/(cw**2*MW**2*sw**4*16._/**/REALKIND*8._/**/REALKIND))
    f(469) = -((eQED**5*integralnorm*MH**2*MT*SwB*(cw**4*4._/**/REALKIND + sw**4*4._/**/REALKIND  &
      - cw**2*sw**2*8._/**/REALKIND))/(cw**2*MW**2*sw**4*4._/**/REALKIND*8._/**/REALKIND))
    f(470) = (eQED**5*integralnorm*MH**2*MT*(-cw + sw)*(cw + sw)*SwB)/(cw**2*MW**2*sw**4*16._/**/REALKIND)
    f(471) = (eQED**5*integralnorm*SwB*(-(cw**2*sw**2*16._/**/REALKIND) + cw**4*8._/**/REALKIND  &
      + sw**4*8._/**/REALKIND))/(cw**3*sw**5*16._/**/REALKIND*8._/**/REALKIND)
    f(472) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*sw**3*12._/**/REALKIND))
    f(473) = (eQED**5*integralnorm*SwB*(cw**4*4._/**/REALKIND + sw**4*4._/**/REALKIND  &
      - cw**2*sw**2*8._/**/REALKIND))/(cw*sw**5*4._/**/REALKIND*8._/**/REALKIND)
    f(474) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*sw**3*6._/**/REALKIND))
    f(475) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*sw**3*4._/**/REALKIND))
    f(476) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*sw**3*2._/**/REALKIND))
    f(477) = -((eQED**5*integralnorm*MB*(cw - sw)*(cw + sw)*SwB)/(cw**3*sw**3*6._/**/REALKIND))
    f(478) = -((eQED**5*integralnorm*MB*(cw - sw)*(cw + sw)*SwB)/(cw*sw**3*12._/**/REALKIND))
    f(479) = -((eQED**5*integralnorm*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw**3*sw**3*4._/**/REALKIND))
    f(480) = -((eQED**5*integralnorm*MT*(cw - sw)*(cw + sw)*SwB)/(cw**3*sw**3*12._/**/REALKIND))
    f(481) = -((eQED**5*integralnorm*MT*(cw - sw)*(cw + sw)*SwB)/(cw*sw**3*24._/**/REALKIND))
    f(482) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*MW**2*sw**3*36._/**/REALKIND))
    f(483) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*MW**2*sw**3*18._/**/REALKIND))
    f(484) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*MW**2*sw**3*12._/**/REALKIND))
    f(485) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*MW**2*sw**3*9._/**/REALKIND))
    f(486) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*MW**2*sw**3*6._/**/REALKIND))
    f(487) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*MW**2*sw**3*4._/**/REALKIND))
    f(488) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*MW**2*sw**3*3._/**/REALKIND))
    f(489) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*MW**2*sw**3*2._/**/REALKIND))
    f(490) = -((eQED**3*gQCD**2*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*MW**2*sw**3*4._/**/REALKIND))
    f(491) = -((eQED**5*integralnorm*MB*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw*MW**2*sw**3*12._/**/REALKIND))
    f(492) = -((eQED**5*integralnorm*MB*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw*MW**2*sw**3*8._/**/REALKIND))
    f(493) = -((eQED**5*integralnorm*MB*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw*MW**2*sw**3*6._/**/REALKIND))
    f(494) = -((eQED**5*integralnorm*MH**2*MT*(cw - sw)*(cw + sw)*SwB)/(cw*MW**2*sw**3*24._/**/REALKIND))
    f(495) = -((eQED**5*integralnorm*MH**2*MT*(cw - sw)*(cw + sw)*SwB)/(cw*MW**2*sw**3*12._/**/REALKIND))
    f(496) = -((eQED**5*integralnorm*MH**2*MT*(cw - sw)*(cw + sw)*SwB)/(cw*MW**2*sw**3*8._/**/REALKIND))
    f(497) = -((eQED**5*integralnorm*MW**2*(cw - sw)*(cw + sw)*SwB)/(cw**3*sw**3*8._/**/REALKIND))
    f(498) = -((eQED**5*integralnorm*MW**2*(cw - sw)*(cw + sw)*SwB)/(cw*sw**3*4._/**/REALKIND))
    f(499) = (eQED**5*integralnorm*SwB*(cw**4*4._/**/REALKIND + sw**4*4._/**/REALKIND  &
      - cw**2*sw**2*8._/**/REALKIND))/(cw**3*sw**3*4._/**/REALKIND*8._/**/REALKIND)
    f(500) = (eQED**5*integralnorm*SwB*(cw**4*2._/**/REALKIND + sw**4*2._/**/REALKIND  &
      - cw**2*sw**2*4._/**/REALKIND))/(cw**3*sw**3*2._/**/REALKIND*4._/**/REALKIND)
    f(501) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw**3*sw*4._/**/REALKIND))
    f(502) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*sw*9._/**/REALKIND))
    f(503) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*sw*6._/**/REALKIND))
    f(504) = (-2*eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*sw*9._/**/REALKIND)
    f(505) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*sw*3._/**/REALKIND))
    f(506) = -((eQED**5*integralnorm*(cw - sw)**3*(cw + sw)**3*SwB)/(cw**3*MW**2*sw**5*16._/**/REALKIND))
    f(507) = -((eQED**5*integralnorm*(cw - sw)**3*(cw + sw)**3*SwB)/(cw**3*MW**2*sw**5*8._/**/REALKIND))
    f(508) = -((eQED**5*integralnorm*MW**2*(cw - sw)*(cw + sw)*SwB)/(cw**3*sw*4._/**/REALKIND))
    f(509) = -((eQED**5*integralnorm*MW**2*(cw - sw)*(cw + sw)*SwB)/(cw*sw*9._/**/REALKIND))
    f(510) = (eQED**5*integralnorm*SwB*(-(cw**2*sw**2*12._/**/REALKIND) + cw**4*6._/**/REALKIND  &
      + sw**4*6._/**/REALKIND))/(cw**2*sw**2*12._/**/REALKIND*6._/**/REALKIND)
    f(511) = (eQED**5*integralnorm*SwB*(cw**4*3._/**/REALKIND + sw**4*3._/**/REALKIND  &
      - cw**2*sw**2*6._/**/REALKIND))/(cw**2*sw**2*3._/**/REALKIND*6._/**/REALKIND)
    f(512) = (eQED**5*integralnorm*SwB*(cw**4*2._/**/REALKIND + sw**4*2._/**/REALKIND  &
      - cw**2*sw**2*4._/**/REALKIND))/(cw**2*sw**2*2._/**/REALKIND*4._/**/REALKIND)
    f(513) = (eQED**5*integralnorm*(cw - sw)**2*(cw + sw)**2*SwB)/(cw**2*sw**2*3._/**/REALKIND)
    f(514) = -((eQED**5*integralnorm*MW**2*(cw - sw)*(cw + sw)*SwB)/(cw**2*6._/**/REALKIND))
    f(515) = -((eQED**5*integralnorm*MW**2*(cw - sw)*(cw + sw)*SwB)/(cw**2*3._/**/REALKIND))
    f(516) = -((eQED**5*integralnorm*(cw - sw)**3*(cw + sw)**3*SwB)/(cw**3*sw**3*8._/**/REALKIND))
    f(517) = -((eQED**5*integralnorm*(cw - sw)**3*(cw + sw)**3*SwB)/(cw**3*sw**3*4._/**/REALKIND))
    f(518) = -((eQED**5*integralnorm*MW**2*(cw - sw)*sw*(cw + sw)*SwB)/(cw**3*2._/**/REALKIND))
    f(519) = (2*eQED**5*integralnorm*SwF)/81._/**/REALKIND
    f(520) = (4*eQED**5*integralnorm*SwF)/81._/**/REALKIND
    f(521) = (8*eQED**5*integralnorm*SwF)/81._/**/REALKIND
    f(522) = (eQED**5*integralnorm*SwF)/9._/**/REALKIND
    f(523) = (16*eQED**5*integralnorm*SwF)/81._/**/REALKIND
    f(524) = (2*eQED**5*integralnorm*SwF)/9._/**/REALKIND
    f(525) = (eQED**5*integralnorm*SwF)/3._/**/REALKIND
    f(526) = (4*eQED**5*integralnorm*SwF)/9._/**/REALKIND
    f(527) = (2*eQED**5*integralnorm*SwF)/3._/**/REALKIND
    f(528) = (8*eQED**5*integralnorm*SwF)/9._/**/REALKIND
    f(529) = eQED**5*integralnorm*SwF
    f(530) = 2*eQED**5*integralnorm*SwF
    f(531) = 3*eQED**5*integralnorm*SwF
    f(532) = (cw*eQED**5*integralnorm*SwF)/(sw**5*4._/**/REALKIND)
    f(533) = (cw*eQED**5*integralnorm*SwF)/(sw**5*2._/**/REALKIND)
    f(534) = (eQED**5*integralnorm*MB**3*MT*SwF)/(cw*MW**4*sw**5*32._/**/REALKIND)
    f(535) = (eQED**5*integralnorm*MB*ME**2*MT*SwF)/(cw*MW**4*sw**5*32._/**/REALKIND)
    f(536) = (eQED**5*integralnorm*MB*ML**2*MT*SwF)/(cw*MW**4*sw**5*32._/**/REALKIND)
    f(537) = (eQED**5*integralnorm*MB*MM**2*MT*SwF)/(cw*MW**4*sw**5*32._/**/REALKIND)
    f(538) = (eQED**5*integralnorm*MB*MT**3*SwF)/(cw*MW**4*sw**5*32._/**/REALKIND)
    f(539) = (cw*eQED**5*integralnorm*SwF)/(MW**2*sw**5*4._/**/REALKIND)
    f(540) = (cw*eQED**5*integralnorm*ME*SwF)/(MW**2*sw**5*4._/**/REALKIND)
    f(541) = (cw*eQED**5*integralnorm*ML*SwF)/(MW**2*sw**5*4._/**/REALKIND)
    f(542) = (cw*eQED**5*integralnorm*MM*SwF)/(MW**2*sw**5*4._/**/REALKIND)
    f(543) = (eQED**5*integralnorm*SwF)/(sw**4*4._/**/REALKIND)
    f(544) = (eQED**5*integralnorm*SwF)/(sw**4*2._/**/REALKIND)
    f(545) = (eQED**5*integralnorm*SwF)/(MW**4*sw**4*4._/**/REALKIND)
    f(546) = (eQED**5*integralnorm*ME**2*SwF)/(MW**4*sw**4*4._/**/REALKIND)
    f(547) = (eQED**5*integralnorm*ML**2*SwF)/(MW**4*sw**4*4._/**/REALKIND)
    f(548) = (eQED**5*integralnorm*MM**2*SwF)/(MW**4*sw**4*4._/**/REALKIND)
    f(549) = (eQED**5*integralnorm*MB**3*MT*SwF)/(MW**4*sw**4*16._/**/REALKIND)
    f(550) = (eQED**5*integralnorm*MB*ME**2*MT*SwF)/(MW**4*sw**4*16._/**/REALKIND)
    f(551) = (eQED**5*integralnorm*MB*ML**2*MT*SwF)/(MW**4*sw**4*16._/**/REALKIND)
    f(552) = (eQED**5*integralnorm*MB*MM**2*MT*SwF)/(MW**4*sw**4*16._/**/REALKIND)
    f(553) = (eQED**5*integralnorm*MB*MT**3*SwF)/(MW**4*sw**4*16._/**/REALKIND)
    f(554) = (eQED**5*integralnorm*SwF)/(MW**2*sw**4*4._/**/REALKIND)
    f(555) = (eQED**5*integralnorm*MB**3*SwF)/(cw**2*MW**2*sw**4*8._/**/REALKIND)
    f(556) = (eQED**5*integralnorm*ME*SwF)/(MW**2*sw**4*4._/**/REALKIND)
    f(557) = (eQED**5*integralnorm*MB*ME**2*SwF)/(cw**2*MW**2*sw**4*8._/**/REALKIND)
    f(558) = (eQED**5*integralnorm*ML*SwF)/(MW**2*sw**4*4._/**/REALKIND)
    f(559) = (eQED**5*integralnorm*MB*ML**2*SwF)/(cw**2*MW**2*sw**4*8._/**/REALKIND)
    f(560) = (eQED**5*integralnorm*MM*SwF)/(MW**2*sw**4*4._/**/REALKIND)
    f(561) = (eQED**5*integralnorm*MB*MM**2*SwF)/(cw**2*MW**2*sw**4*8._/**/REALKIND)
    f(562) = (eQED**5*integralnorm*MB**2*MT*SwF)/(cw**2*MW**2*sw**4*8._/**/REALKIND)
    f(563) = (eQED**5*integralnorm*MB*ME*MT*SwF)/(cw**2*MW**2*sw**4*8._/**/REALKIND)
    f(564) = (eQED**5*integralnorm*ME**2*MT*SwF)/(cw**2*MW**2*sw**4*8._/**/REALKIND)
    f(565) = (eQED**5*integralnorm*MB*ML*MT*SwF)/(cw**2*MW**2*sw**4*8._/**/REALKIND)
    f(566) = (eQED**5*integralnorm*ML**2*MT*SwF)/(cw**2*MW**2*sw**4*8._/**/REALKIND)
    f(567) = (eQED**5*integralnorm*MB*MM*MT*SwF)/(cw**2*MW**2*sw**4*8._/**/REALKIND)
    f(568) = (eQED**5*integralnorm*MM**2*MT*SwF)/(cw**2*MW**2*sw**4*8._/**/REALKIND)
    f(569) = (eQED**5*integralnorm*MB*MT**2*SwF)/(cw**2*MW**2*sw**4*8._/**/REALKIND)
    f(570) = (eQED**5*integralnorm*MT**3*SwF)/(cw**2*MW**2*sw**4*8._/**/REALKIND)
    f(571) = (eQED**5*integralnorm*SwF)/(cw*sw**3*4._/**/REALKIND)
    f(572) = (eQED**5*integralnorm*SwF)/(cw*sw**3*2._/**/REALKIND)
    f(573) = (eQED**5*integralnorm*ME*SwF)/(cw*sw**3*4._/**/REALKIND)
    f(574) = (eQED**5*integralnorm*ML*SwF)/(cw*sw**3*4._/**/REALKIND)
    f(575) = (eQED**5*integralnorm*MM*SwF)/(cw*sw**3*4._/**/REALKIND)
    f(576) = (eQED**5*integralnorm*SwF)/(cw*MW**2*sw**3*4._/**/REALKIND)
    f(577) = (eQED**5*integralnorm*MB**2*SwF)/(cw*MW**2*sw**3*36._/**/REALKIND)
    f(578) = (eQED**5*integralnorm*MB**2*SwF)/(cw*MW**2*sw**3*8._/**/REALKIND)
    f(579) = (eQED**5*integralnorm*ME*SwF)/(cw*MW**2*sw**3*4._/**/REALKIND)
    f(580) = (eQED**5*integralnorm*MB*ME*SwF)/(cw*MW**2*sw**3*12._/**/REALKIND)
    f(581) = (eQED**5*integralnorm*MB*ME*SwF)/(cw*MW**2*sw**3*8._/**/REALKIND)
    f(582) = (eQED**5*integralnorm*ME**2*SwF)/(cw*MW**2*sw**3*4._/**/REALKIND)
    f(583) = (eQED**5*integralnorm*ML*SwF)/(cw*MW**2*sw**3*4._/**/REALKIND)
    f(584) = (eQED**5*integralnorm*MB*ML*SwF)/(cw*MW**2*sw**3*12._/**/REALKIND)
    f(585) = (eQED**5*integralnorm*MB*ML*SwF)/(cw*MW**2*sw**3*8._/**/REALKIND)
    f(586) = (eQED**5*integralnorm*ML**2*SwF)/(cw*MW**2*sw**3*4._/**/REALKIND)
    f(587) = (eQED**5*integralnorm*MM*SwF)/(cw*MW**2*sw**3*4._/**/REALKIND)
    f(588) = (eQED**5*integralnorm*MB*MM*SwF)/(cw*MW**2*sw**3*12._/**/REALKIND)
    f(589) = (eQED**5*integralnorm*MB*MM*SwF)/(cw*MW**2*sw**3*8._/**/REALKIND)
    f(590) = (eQED**5*integralnorm*MM**2*SwF)/(cw*MW**2*sw**3*4._/**/REALKIND)
    f(591) = (eQED**5*integralnorm*MB*MT*SwF)/(cw*MW**2*sw**3*72._/**/REALKIND)
    f(592) = (eQED**5*integralnorm*MB*MT*SwF)/(cw*MW**2*sw**3*18._/**/REALKIND)
    f(593) = (eQED**5*integralnorm*MB*MT*SwF)/(cw*MW**2*sw**3*8._/**/REALKIND)
    f(594) = (eQED**5*integralnorm*ME*MT*SwF)/(cw*MW**2*sw**3*24._/**/REALKIND)
    f(595) = (eQED**5*integralnorm*ME*MT*SwF)/(cw*MW**2*sw**3*8._/**/REALKIND)
    f(596) = (eQED**5*integralnorm*ML*MT*SwF)/(cw*MW**2*sw**3*24._/**/REALKIND)
    f(597) = (eQED**5*integralnorm*ML*MT*SwF)/(cw*MW**2*sw**3*8._/**/REALKIND)
    f(598) = (eQED**5*integralnorm*MM*MT*SwF)/(cw*MW**2*sw**3*24._/**/REALKIND)
    f(599) = (eQED**5*integralnorm*MM*MT*SwF)/(cw*MW**2*sw**3*8._/**/REALKIND)
    f(600) = (eQED**5*integralnorm*MT**2*SwF)/(cw*MW**2*sw**3*36._/**/REALKIND)
    f(601) = (eQED**5*integralnorm*MT**2*SwF)/(cw*MW**2*sw**3*8._/**/REALKIND)
    f(602) = (eQED**5*integralnorm*MB*SwF)/(cw**2*sw**2*18._/**/REALKIND)
    f(603) = (eQED**5*integralnorm*MB*SwF)/(cw**2*sw**2*9._/**/REALKIND)
    f(604) = (2*eQED**5*integralnorm*MB*SwF)/(cw**2*sw**2*9._/**/REALKIND)
    f(605) = (eQED**5*integralnorm*MB*SwF)/(cw**2*sw**2*3._/**/REALKIND)
    f(606) = (4*eQED**5*integralnorm*MB*SwF)/(cw**2*sw**2*9._/**/REALKIND)
    f(607) = (eQED**5*integralnorm*MB*SwF)/(cw**2*sw**2*2._/**/REALKIND)
    f(608) = (eQED**5*integralnorm*MB*SwF)/(cw**2*sw**2)
    f(609) = (3*eQED**5*integralnorm*MB*SwF)/(cw**2*sw**2*2._/**/REALKIND)
    f(610) = (eQED**5*integralnorm*ME*SwF)/(cw**2*sw**2*6._/**/REALKIND)
    f(611) = (eQED**5*integralnorm*ME*SwF)/(cw**2*sw**2*3._/**/REALKIND)
    f(612) = (eQED**5*integralnorm*ME*SwF)/(cw**2*sw**2*2._/**/REALKIND)
    f(613) = (eQED**5*integralnorm*ML*SwF)/(cw**2*sw**2*6._/**/REALKIND)
    f(614) = (eQED**5*integralnorm*ML*SwF)/(cw**2*sw**2*3._/**/REALKIND)
    f(615) = (eQED**5*integralnorm*ML*SwF)/(cw**2*sw**2*2._/**/REALKIND)
    f(616) = (eQED**5*integralnorm*MM*SwF)/(cw**2*sw**2*6._/**/REALKIND)
    f(617) = (eQED**5*integralnorm*MM*SwF)/(cw**2*sw**2*3._/**/REALKIND)
    f(618) = (eQED**5*integralnorm*MM*SwF)/(cw**2*sw**2*2._/**/REALKIND)
    f(619) = (eQED**5*integralnorm*MT*SwF)/(cw**2*sw**2*18._/**/REALKIND)
    f(620) = (eQED**5*integralnorm*MT*SwF)/(cw**2*sw**2*9._/**/REALKIND)
    f(621) = (eQED**5*integralnorm*MT*SwF)/(cw**2*sw**2*6._/**/REALKIND)
    f(622) = (2*eQED**5*integralnorm*MT*SwF)/(cw**2*sw**2*9._/**/REALKIND)
    f(623) = (eQED**5*integralnorm*MT*SwF)/(cw**2*sw**2*2._/**/REALKIND)
    f(624) = (eQED**5*integralnorm*MT*SwF)/(cw**2*sw**2)
    f(625) = (3*eQED**5*integralnorm*MT*SwF)/(cw**2*sw**2*2._/**/REALKIND)
    f(626) = (eQED**5*integralnorm*MB**2*SwF)/(MW**2*sw**2*18._/**/REALKIND)
    f(627) = (eQED**5*integralnorm*MB**2*SwF)/(MW**2*sw**2*4._/**/REALKIND)
    f(628) = (eQED**5*integralnorm*MB*ME*SwF)/(MW**2*sw**2*6._/**/REALKIND)
    f(629) = (eQED**5*integralnorm*MB*ME*SwF)/(MW**2*sw**2*4._/**/REALKIND)
    f(630) = (eQED**5*integralnorm*MB*ML*SwF)/(MW**2*sw**2*6._/**/REALKIND)
    f(631) = (eQED**5*integralnorm*MB*ML*SwF)/(MW**2*sw**2*4._/**/REALKIND)
    f(632) = (eQED**5*integralnorm*MB*MM*SwF)/(MW**2*sw**2*6._/**/REALKIND)
    f(633) = (eQED**5*integralnorm*MB*MM*SwF)/(MW**2*sw**2*4._/**/REALKIND)
    f(634) = (eQED**5*integralnorm*MB*MT*SwF)/(MW**2*sw**2*36._/**/REALKIND)
    f(635) = (eQED**5*integralnorm*MB*MT*SwF)/(MW**2*sw**2*9._/**/REALKIND)
    f(636) = (eQED**5*integralnorm*MB*MT*SwF)/(MW**2*sw**2*4._/**/REALKIND)
    f(637) = (eQED**5*integralnorm*ME*MT*SwF)/(MW**2*sw**2*12._/**/REALKIND)
    f(638) = (eQED**5*integralnorm*ME*MT*SwF)/(MW**2*sw**2*4._/**/REALKIND)
    f(639) = (eQED**5*integralnorm*ML*MT*SwF)/(MW**2*sw**2*12._/**/REALKIND)
    f(640) = (eQED**5*integralnorm*ML*MT*SwF)/(MW**2*sw**2*4._/**/REALKIND)
    f(641) = (eQED**5*integralnorm*MM*MT*SwF)/(MW**2*sw**2*12._/**/REALKIND)
    f(642) = (eQED**5*integralnorm*MM*MT*SwF)/(MW**2*sw**2*4._/**/REALKIND)
    f(643) = (eQED**5*integralnorm*MT**2*SwF)/(MW**2*sw**2*18._/**/REALKIND)
    f(644) = (eQED**5*integralnorm*MT**2*SwF)/(MW**2*sw**2*4._/**/REALKIND)
    f(645) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwF)/(cw*MW**4*sw**5*8._/**/REALKIND))
    f(646) = -((eQED**5*integralnorm*ME**2*(cw - sw)*(cw + sw)*SwF)/(cw*MW**4*sw**5*8._/**/REALKIND))
    f(647) = -((eQED**5*integralnorm*ML**2*(cw - sw)*(cw + sw)*SwF)/(cw*MW**4*sw**5*8._/**/REALKIND))
    f(648) = -((eQED**5*integralnorm*MM**2*(cw - sw)*(cw + sw)*SwF)/(cw*MW**4*sw**5*8._/**/REALKIND))
    f(649) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwF)/(cw*MW**2*sw**5*8._/**/REALKIND))
    f(650) = -((eQED**5*integralnorm*ME*(cw - sw)*(cw + sw)*SwF)/(cw*MW**2*sw**5*8._/**/REALKIND))
    f(651) = -((eQED**5*integralnorm*ML*(cw - sw)*(cw + sw)*SwF)/(cw*MW**2*sw**5*8._/**/REALKIND))
    f(652) = -((eQED**5*integralnorm*MM*(cw - sw)*(cw + sw)*SwF)/(cw*MW**2*sw**5*8._/**/REALKIND))

  c = [ 6*f(93), 6*f(94), 6*f(95), 6*f(96), 6*f(97), 6*f(98), 6*f(99), 6*f(100), f(101), 3*f(101), f(102), 3*f(102), 8*f(102) &
    , f(103), 3*f(103), f(104), 3*f(104), 8*f(104), 6*f(105), 6*f(106), 6*f(107), 6*f(108), 6*f(109), 6*f(110), 6*f(111), 6*f(112) &
    , 6*f(113), 6*f(114), 6*f(115), 6*f(116), 6*f(117), 6*f(118), 6*f(119), 6*f(120), 6*f(121), 6*f(122), 6*f(123), 6*f(124) &
    , 6*f(125), 6*f(126), 6*f(127), 6*f(128), 6*f(129), 6*f(130), 6*f(131), 6*f(132), 6*f(133), 6*f(134), 6*f(135), 6*f(136) &
    , 6*f(137), 6*f(138), 6*f(139), 6*f(140), 6*f(141), 6*f(142), 6*f(143), 6*f(144), 6*f(145), 6*f(146), 6*f(147), 6*f(148) &
    , 6*f(149), 6*f(150), 6*f(151), 6*f(152), 6*f(153), 6*f(154), 6*f(155), 6*f(156), 6*f(157), 6*f(158), 6*f(159), 6*f(160) &
    , 6*f(161), 6*f(162), 6*f(163), 6*f(164), 6*f(165), 6*f(166), 6*f(167), 6*f(168), 6*f(169), 6*f(170), 6*f(171), 6*f(172) &
    , 6*f(173), 6*f(174), 6*f(175), 6*f(176), 6*f(177), 6*f(178), 6*f(179), 6*f(180), 6*f(181), 6*f(182), 6*f(183), 6*f(184) &
    , 6*f(185), 6*f(186), 6*f(187), 6*f(188), 6*f(189), 6*f(190), 6*f(191), 6*f(192), 6*f(193), 6*f(194), 6*f(195), 6*f(196) &
    , 6*f(197), 6*f(198), 6*f(199), 6*f(200), 6*f(201), 6*f(202), 6*f(203), 6*f(204), 6*f(205), 6*f(206), 6*f(207), 6*f(208) &
    , 6*f(209), 6*f(210), 6*f(211), 6*f(212), 6*f(213), 6*f(214), 6*f(215), 6*f(216), 6*f(217), 6*f(218), 6*f(219), 6*f(220) &
    , 6*f(221), 6*f(222), 6*f(223), 6*f(224), 6*f(225), 6*f(226), 6*f(227), 6*f(228), 6*f(229), 6*f(230), 6*f(231), 6*f(232) &
    , 6*f(233), 6*f(234), 6*f(235), 6*f(236), 6*f(237), 6*f(238), 6*f(239), 6*f(240), 6*f(241), 6*f(242), 6*f(243), 6*f(244) &
    , 6*f(245), 6*f(246), 6*f(247), 6*f(248), 6*f(249), 6*f(250), 6*f(251), 6*f(252), 6*f(253), 6*f(254), 6*f(255), 6*f(256) &
    , 6*f(257), 6*f(258), 6*f(259), 6*f(260), 6*f(261), 6*f(262), 6*f(263), 6*f(264), 6*f(265), 6*f(266), 6*f(267), 6*f(268) &
    , 6*f(269), 6*f(270), 6*f(271), 6*f(272), 6*f(273), 6*f(274), 6*f(275), 6*f(276), 6*f(277), 6*f(278), 6*f(279), 6*f(280) &
    , 6*f(281), 6*f(282), 6*f(283), 6*f(284), 6*f(285), 6*f(286), 6*f(287), f(288), 3*f(288), 8*f(288), 6*f(289), 6*f(290) &
    , 6*f(291), 6*f(292), 6*f(293), 6*f(294), 6*f(295), 6*f(296), 6*f(297), 6*f(298), 6*f(299), 6*f(300), 6*f(301), 6*f(302) &
    , 6*f(303), 6*f(304), 6*f(305), 6*f(306), 6*f(307), 6*f(308), 6*f(309), 6*f(310), 6*f(311), 6*f(312), 6*f(313), 6*f(314) &
    , 6*f(315), 6*f(316), 6*f(317), 6*f(318), f(319), 3*f(319), 6*f(320), 6*f(321), 6*f(322), 6*f(323), 6*f(324), 6*f(325) &
    , 6*f(326), 6*f(327), 6*f(328), 6*f(329), f(330), 3*f(330), 8*f(330), 6*f(331), 6*f(332), 6*f(333), 6*f(334), 6*f(335), f(336) &
    , 3*f(336), 6*f(337), 6*f(338), 6*f(339), 6*f(340), 6*f(341), 6*f(342), 6*f(343), 6*f(344), 6*f(345), 6*f(346), 6*f(347) &
    , 6*f(348), 6*f(349), 6*f(350), 6*f(351), 6*f(352), f(353), 3*f(353), 8*f(353), 6*f(354), 6*f(355), 6*f(356), 6*f(357) &
    , 6*f(358), 6*f(359), 6*f(360), 6*f(361), f(362), 3*f(362), 8*f(362), 6*f(363), 6*f(364), 6*f(365), 6*f(366), 6*f(367) &
    , 6*f(368), 6*f(369), 6*f(370), 6*f(371), 6*f(372), f(373), 3*f(373), 8*f(373), 6*f(374), 6*f(375), 6*f(376), 6*f(377) &
    , 6*f(378), 6*f(379), f(380), 3*f(380), 8*f(380), 6*f(381), 6*f(382), f(383), 3*f(383), 6*f(384), 6*f(385), 6*f(386), 6*f(387) &
    , 6*f(388), f(389), 3*f(389), 8*f(389), 6*f(390), 6*f(391), 6*f(392), f(393), 3*f(393), 6*f(394), 6*f(395), 6*f(396), 6*f(397) &
    , 6*f(398), 6*f(399), 6*f(400), 6*f(401), 6*f(402), 6*f(403), 6*f(404), 6*f(405), 6*f(406), 6*f(407), f(408), 3*f(408) &
    , 8*f(408), 6*f(409), 6*f(410), 6*f(411), 6*f(412), 6*f(413), 6*f(414), 6*f(415), 6*f(416), 6*f(417), 6*f(418), 6*f(419) &
    , 6*f(420), 6*f(421), 6*f(422), 6*f(423), 6*f(424), 6*f(425), 6*f(426), 6*f(427), 6*f(428), 6*f(429), 6*f(430), 6*f(431) &
    , 6*f(432), 6*f(433), 6*f(434), 6*f(435), 6*f(436), 6*f(437), 6*f(438), 6*f(439), 6*f(440), 6*f(441), 6*f(442), 6*f(443) &
    , 6*f(444), 6*f(445), 6*f(446), 6*f(447), 6*f(448), 6*f(449), 6*f(450), 6*f(451), 6*f(452), 6*f(453), 6*f(454), 6*f(455) &
    , 6*f(456), 6*f(457), 6*f(458), 6*f(459), 6*f(460), 6*f(461), 6*f(462), 6*f(463), 6*f(464), 6*f(465), 6*f(466), 6*f(467) &
    , 6*f(468), 6*f(469), 6*f(470), 6*f(471), 6*f(472), 6*f(473), 6*f(474), 6*f(475), 6*f(476), 6*f(477), 6*f(478), 6*f(479) &
    , 6*f(480), 6*f(481), 6*f(482), 6*f(483), 6*f(484), 6*f(485), 6*f(486), 6*f(487), 6*f(488), 6*f(489), f(490), 3*f(490) &
    , 8*f(490), 6*f(491), 6*f(492), 6*f(493), 6*f(494), 6*f(495), 6*f(496), 6*f(497), 6*f(498), 6*f(499), 6*f(500), 6*f(501) &
    , 6*f(502), 6*f(503), 6*f(504), 6*f(505), 6*f(506), 6*f(507), 6*f(508), 6*f(509), 6*f(510), 6*f(511), 6*f(512), 6*f(513) &
    , 6*f(514), 6*f(515), 6*f(516), 6*f(517), 6*f(518), 18*f(519), 18*f(520), 18*f(521), 18*f(522), 18*f(523), 6*f(524), 18*f(524) &
    , 6*f(525), 18*f(526), 6*f(527), 18*f(528), 6*f(529), 18*f(529), 18*f(530), 6*f(531), 6*f(532), 18*f(532), 18*f(533) &
    , 18*f(534), 6*f(535), 6*f(536), 6*f(537), 18*f(538), 18*f(539), 6*f(540), 6*f(541), 6*f(542), 6*f(543), 18*f(543), 18*f(544) &
    , 18*f(545), 6*f(546), 6*f(547), 6*f(548), 18*f(549), 6*f(550), 6*f(551), 6*f(552), 18*f(553), 18*f(554), 18*f(555), 6*f(556) &
    , 6*f(557), 6*f(558), 6*f(559), 6*f(560), 6*f(561), 18*f(562), 6*f(563), 6*f(564), 6*f(565), 6*f(566), 6*f(567), 6*f(568) &
    , 18*f(569), 18*f(570), 6*f(571), 18*f(571), 18*f(572), 6*f(573), 6*f(574), 6*f(575), 18*f(576), 18*f(577), 18*f(578) &
    , 6*f(579), 6*f(580), 6*f(581), 6*f(582), 6*f(583), 6*f(584), 6*f(585), 6*f(586), 6*f(587), 6*f(588), 6*f(589), 6*f(590) &
    , 18*f(591), 18*f(592), 18*f(593), 6*f(594), 6*f(595), 6*f(596), 6*f(597), 6*f(598), 6*f(599), 18*f(600), 18*f(601), 18*f(602) &
    , 18*f(603), 18*f(604), 6*f(605), 18*f(606), 6*f(607), 18*f(607), 18*f(608), 6*f(609), 6*f(610), 6*f(611), 6*f(612), 6*f(613) &
    , 6*f(614), 6*f(615), 6*f(616), 6*f(617), 6*f(618), 18*f(619), 18*f(620), 6*f(621), 18*f(622), 6*f(623), 18*f(623), 18*f(624) &
    , 6*f(625), 18*f(626), 18*f(627), 6*f(628), 6*f(629), 6*f(630), 6*f(631), 6*f(632), 6*f(633), 18*f(634), 18*f(635), 18*f(636) &
    , 6*f(637), 6*f(638), 6*f(639), 6*f(640), 6*f(641), 6*f(642), 18*f(643), 18*f(644), 18*f(645), 6*f(646), 6*f(647), 6*f(648) &
    , 18*f(649), 6*f(650), 6*f(651), 6*f(652) ]
  c = (1._/**/REALKIND / 6) * c
end subroutine fac_init_loop

subroutine denominators()
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_momenta_decl_/**/REALKIND, only: L
  implicit none
  ! propagators
  den(1) = 1 /((L(5,3) - MH2)+L(6,3))
  den(2) = 1 /((L(5,12) - MZ2)+L(6,12))
  den(4) = 1 /((L(5,3) - MZ2)+L(6,3))
  den(5) = 1 /((L(5,12) - MH2)+L(6,12))
  den(7) = 1 /((L(5,20) - MB2)+L(6,20))
  den(10) = 1 /((L(5,3))+L(6,3))
  den(12) = 1 /((L(5,24) - MB2)+L(6,24))
  den(16) = 1 /((L(5,9) - MW2)+L(6,9))
  den(17) = 1 /((L(5,6) - MW2)+L(6,6))
  den(19) = 1 /((L(5,17) - MT2)+L(6,17))
  den(22) = 1 /((L(5,18) - MT2)+L(6,18))
  den(27) = 1 /((L(5,12))+L(6,12))
  den(34) = 1 /((L(5,28) - MH2)+L(6,28))
  den(37) = 1 /((L(5,28) - MZ2)+L(6,28))
  den(41) = 1 /((L(5,19) - MH2)+L(6,19))
  den(44) = 1 /((L(5,19) - MZ2)+L(6,19))
  den(52) = 1 /((L(5,28))+L(6,28))
  den(57) = 1 /((L(5,11) - MB2)+L(6,11))
  den(72) = 1 /((L(5,7) - MB2)+L(6,7))
  den(79) = 1 /((L(5,22) - MW2)+L(6,22))
  den(82) = 1 /((L(5,25) - MW2)+L(6,25))
  den(85) = 1 /((L(5,14) - MT2)+L(6,14))
  den(96) = 1 /((L(5,13) - MT2)+L(6,13))
  den(114) = 1 /((L(5,19))+L(6,19))

  ! denominators
  den(3) = den(1)*den(2)
  den(6) = den(4)*den(5)
  den(8) = den(1)*den(7)
  den(9) = den(4)*den(7)
  den(11) = den(7)*den(10)
  den(13) = den(1)*den(12)
  den(14) = den(4)*den(12)
  den(15) = den(10)*den(12)
  den(18) = den(16)*den(17)
  den(20) = den(17)*den(19)
  den(21) = den(12)*den(17)
  den(23) = den(16)*den(22)
  den(24) = den(7)*den(16)
  den(25) = den(5)*den(19)
  den(26) = den(2)*den(19)
  den(28) = den(19)*den(27)
  den(29) = den(5)*den(22)
  den(30) = den(2)*den(22)
  den(31) = den(22)*den(27)
  den(32) = den(1)*den(27)
  den(33) = den(5)*den(10)
  den(35) = den(2)*den(34)
  den(36) = den(1)*den(35)
  den(38) = den(5)*den(37)
  den(39) = den(4)*den(38)
  den(40) = den(10)*den(38)
  den(42) = den(4)*den(41)
  den(43) = den(5)*den(42)
  den(45) = den(1)*den(44)
  den(46) = den(2)*den(45)
  den(47) = den(27)*den(45)
  den(48) = den(7)*den(34)
  den(49) = den(1)*den(48)
  den(50) = den(7)*den(37)
  den(51) = den(4)*den(50)
  den(53) = den(7)*den(52)
  den(54) = den(4)*den(53)
  den(55) = den(10)*den(50)
  den(56) = den(10)*den(53)
  den(58) = den(1)*den(57)
  den(59) = den(7)*den(58)
  den(60) = den(4)*den(57)
  den(61) = den(7)*den(60)
  den(62) = den(10)*den(57)
  den(63) = den(7)*den(62)
  den(64) = den(12)*den(34)
  den(65) = den(1)*den(64)
  den(66) = den(12)*den(37)
  den(67) = den(4)*den(66)
  den(68) = den(12)*den(52)
  den(69) = den(4)*den(68)
  den(70) = den(10)*den(66)
  den(71) = den(10)*den(68)
  den(73) = den(1)*den(72)
  den(74) = den(12)*den(73)
  den(75) = den(4)*den(72)
  den(76) = den(12)*den(75)
  den(77) = den(10)*den(72)
  den(78) = den(12)*den(77)
  den(80) = den(17)*den(79)
  den(81) = den(16)*den(80)
  den(83) = den(16)*den(82)
  den(84) = den(17)*den(83)
  den(86) = den(17)*den(85)
  den(87) = den(19)*den(86)
  den(88) = den(19)*den(82)
  den(89) = den(17)*den(88)
  den(90) = den(12)*den(82)
  den(91) = den(17)*den(90)
  den(92) = den(17)*den(72)
  den(93) = den(12)*den(92)
  den(94) = den(22)*den(79)
  den(95) = den(16)*den(94)
  den(97) = den(16)*den(96)
  den(98) = den(22)*den(97)
  den(99) = den(7)*den(79)
  den(100) = den(16)*den(99)
  den(101) = den(16)*den(57)
  den(102) = den(7)*den(101)
  den(103) = den(5)*den(85)
  den(104) = den(19)*den(103)
  den(105) = den(2)*den(85)
  den(106) = den(19)*den(105)
  den(107) = den(27)*den(85)
  den(108) = den(19)*den(107)
  den(109) = den(19)*den(41)
  den(110) = den(5)*den(109)
  den(111) = den(19)*den(44)
  den(112) = den(2)*den(111)
  den(113) = den(27)*den(111)
  den(115) = den(19)*den(114)
  den(116) = den(2)*den(115)
  den(117) = den(27)*den(115)
  den(118) = den(5)*den(96)
  den(119) = den(22)*den(118)
  den(120) = den(2)*den(96)
  den(121) = den(22)*den(120)
  den(122) = den(27)*den(96)
  den(123) = den(22)*den(122)
  den(124) = den(22)*den(41)
  den(125) = den(5)*den(124)
  den(126) = den(22)*den(44)
  den(127) = den(2)*den(126)
  den(128) = den(27)*den(126)
  den(129) = den(22)*den(114)
  den(130) = den(2)*den(129)
  den(131) = den(27)*den(129)
  den(132) = den(1)*den(5)
  den(133) = den(2)*den(4)
  den(134) = den(4)*den(27)
  den(135) = den(2)*den(10)
  den(136) = den(10)*den(27)
  den(137) = den(5)*den(45)
  den(138) = den(2)*den(42)
  den(139) = den(27)*den(42)
  den(140) = den(1)*den(38)
  den(141) = den(4)*den(35)
  den(142) = den(10)*den(35)
  den(143) = den(1)*den(50)
  den(144) = den(4)*den(48)
  den(145) = den(1)*den(53)
  den(146) = den(10)*den(48)
  den(147) = den(1)*den(66)
  den(148) = den(4)*den(64)
  den(149) = den(1)*den(68)
  den(150) = den(10)*den(64)
  den(151) = den(2)*den(109)
  den(152) = den(5)*den(111)
  den(153) = den(27)*den(109)
  den(154) = den(5)*den(115)
  den(155) = den(2)*den(124)
  den(156) = den(5)*den(126)
  den(157) = den(27)*den(124)
  den(158) = den(5)*den(129)

end subroutine denominators

#ifdef PRECISION_dp
! **********************************************************************
subroutine init_merging_tables(tot_num_hels, tot_num_merge_steps)
!-----------------------------------------------------------------------
! In the first event the merging tables are fully initialised
! **********************************************************************
  implicit none
  integer, intent(in) :: tot_num_hels, tot_num_merge_steps
  n_merge_steps = tot_num_merge_steps
  allocate(merge_tables(tot_num_hels,2,n_merge_steps))
  allocate(merge_mism(n_merge_steps+1))
  allocate(merge_hels(n_merge_steps))
  merge_tables_on = .true.
  merge_mism = 0_intkind2
  merge_tables = -1_intkind2
  merge_hels = -1_intkind2
end subroutine init_merging_tables

! **********************************************************************
subroutine update_merging_tables(tot_num_hels)
!-----------------------------------------------------------------------
! After the first evaluation the merging tables are adapted
! **********************************************************************
  implicit none
  integer, intent(in) :: tot_num_hels
  integer(intkind2), allocatable ::  merge_tables_tmp(:,:,:), merge_hels_tmp(:)

  if(merge_mism(1) == 0) then ! helicity configurations match in all merging steps
    if(allocated(merge_tables)) deallocate(merge_tables)
    if(allocated(merge_hels)) deallocate(merge_hels)
    if(allocated(merge_mism)) deallocate(merge_mism)
    allocate(merge_mism(1))
    allocate(merge_hels(1))
    allocate(merge_tables(1,1,1)) ! dummy allocation
    merge_mism = 0_intkind2
    merge_tables = -1_intkind2
    merge_hels = -1_intkind2
  else
    n_merge_mism = merge_mism(1)
    allocate(merge_tables_tmp(tot_num_hels,2,n_merge_mism))
    merge_tables_tmp(:,:,1:n_merge_mism) = merge_tables(:,:,1:n_merge_mism)
    if(allocated(merge_tables)) then
      deallocate(merge_tables)
      allocate(merge_tables(tot_num_hels,2,n_merge_mism))
    end if
    merge_tables = merge_tables_tmp
    if(allocated(merge_tables_tmp)) deallocate(merge_tables_tmp)
    allocate(merge_hels_tmp(n_merge_mism))
    merge_hels_tmp(1:n_merge_mism) = merge_hels(1:n_merge_mism)
    if(allocated(merge_hels)) then
      deallocate(merge_hels)
      allocate(merge_hels(n_merge_mism))
    end if
    merge_hels = merge_hels_tmp
    if(allocated(merge_hels_tmp)) deallocate(merge_hels_tmp)
  end if
  merge_tables_on = .true.
end subroutine update_merging_tables
#endif


!
!
!
! **********************************************************************
#ifdef PRECISION_dp
subroutine amp2(P_scatt, M02, M2ct, M2colint, qp_kinematics)
#else
subroutine amp2(P_scatt, M02, M2ct, M2colint, qp_kinematics)
  use ol_loop_storage_ppztt_ew_ttxbbxz_3_/**/DREALKIND, only: ntry, nhel, Hel
#endif
! P_scatt(0:3,Npart) = incoming external momenta
! M2  = helicity-summed squared matrix element for top anti-top bottom anti-bottom Z -> 0
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND !, only: ci, parameters_status, ZERO, scalefactor, >masses<
  use ol_parameters_init_/**/REALKIND, only: ensure_mp_init
  use ol_kinematics_/**/REALKIND, only: init_kinematics
  use ol_momenta_decl_/**/DREALKIND, only: momenta_nan_check
  use ol_data_types_/**/REALKIND
  use ol_h_helicity_bookkeeping_/**/REALKIND, only: &
    & helbookkeeping_wf, helsync, flip_phase
  use ol_helicity_init, only: helbookkeeping_flip, helsync_flip
  use ol_hel_propagators_/**/REALKIND
  use ol_hel_wavefunctions_/**/REALKIND
  use ol_wavefunctions_/**/REALKIND, only: wf_V_Std
  use ol_hel_vertices_/**/REALKIND
  use ol_hel_contractions_/**/REALKIND
  use ol_external_ppztt_ew_ttxbbxz_3, only: external_perm_ppztt_ew_ttxbbxz_3, &
    & external_perm_inv_ppztt_ew_ttxbbxz_3, extcomb_perm_ppztt_ew_ttxbbxz_3, &
    & average_factor_ppztt_ew_ttxbbxz_3, photonid_ppztt_ew_ttxbbxz_3
  use ol_ew_renormalisation_/**/REALKIND, only: photon_factors
  use ol_external_ppztt_ew_ttxbbxz_3, only: H, hel_not_initialised, hel_init, POLSEL
  use ol_colourmatrix_ppztt_ew_ttxbbxz_3_/**/REALKIND, only: colmat_not_initialised, colourmatrix_init
  use ol_forced_parameters_ppztt_ew_ttxbbxz_3_/**/REALKIND, only: check_forced_parameters
  use ol_heltables_OLR_ppztt_ew_ttxbbxz_3
  use ol_kinematics_/**/REALKIND, only: LC2Std_Rep_cmplx
  use ol_h_counterterms_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND ! counterterms
  use ol_loop_parameters_decl_/**/DREALKIND, only: IR_is_on
  use ol_init, only: set_parameter, parameters_flush
#ifdef PRECISION_dp
  use ol_kinematics_/**/QREALKIND, only: conv_mom_scatt2in_qp=>conv_mom_scatt2in, &
                                         internal_momenta_qp=>internal_momenta
  use ol_momenta_decl_/**/DREALKIND, only: L
  use ol_momenta_decl_/**/QREALKIND, only: L_qp=>L
#endif
  implicit none

  real(DREALKIND), intent(in)  :: P_scatt(0:3,5)
  real(REALKIND),  intent(out) :: M02, M2ct, M2colint(16)
  logical, intent(in) :: qp_kinematics

  integer           :: shift, k, r, m, n, i
  real(REALKIND)    :: P(0:3,5)
#ifdef PRECISION_dp
  real(QREALKIND)    :: P_qp(0:3,5)
#endif
  integer           :: extmasses2(5)
  real(REALKIND)    :: M2add, M2add_ct, M2add_colint(16)
  complex(REALKIND) :: M1(4), M2(4)
  real(REALKIND)    :: P_scatt_intern(0:3,5)
  real(REALKIND), save :: scalebackfactor, old_scalefactor = 0
  real(REALKIND)       :: bornphotonfactor
  integer(intkind1) :: nsync
  type(Hpolcont),   save :: M1helarray(4,48)
  type(Hpolcont) :: M1helarray_ct(4,48)
  integer, allocatable :: extcombs_permuted(:)
  integer              :: extcombs(16), nextcombs
#if 5 > 3
  integer :: ind_cc_comb(5)
#endif
  type(Hpolcont) :: A(48,374)

  !Aj are not used at the moment
  !complex(REALKIND) :: Aj(374)

  complex(REALKIND) :: omega(2) ! phases for helicity correlations

  call set_parameter("ew_renorm", 1)
  call parameters_flush()
  call ensure_mp_init()

  if (colmat_not_initialised) call colourmatrix_init()

  if (fac_status_loop1 /= parameters_status .or. fac_status_loop2 /= loop_parameters_status) then
    ! Note: if fac_init would only be called when parameters changed which are relevant for the factors,
    ! a different 'status' would have to be used, because forced_parameters should be called after every parameter change.
    call check_forced_parameters()
    call fac_init_loop()
  end if

  if (momenta_nan_check(P_scatt) /= 0) then
    M02 = 0
    return
  end if

  extmasses2 = [ nMT, nMT, nMB, nMB, nMZ ]
  ! Convert 2 -> n-2 PS-point to n -> 0 (so that P(1) + ... + P(n) = 0) and compute
  ! internal-propagator momenta in light-cone representation
  call init_kinematics(P_scatt, extmasses2, P, external_perm_inv_ppztt_ew_ttxbbxz_3, 5, qp_kinematics)

  ! denominators
  call denominators()

   if (heltables_not_init) call init_heltables()

  ! external WFs
  ! Here the external wavefunctions are initialiased
  call pol_wf_Q(P(:,1), rMT, H1, ex1, POLSEL(1),1)
  call pol_wf_A(P(:,2), rMT, H2, ex2, POLSEL(2),2)
  call pol_wf_Q(P(:,3), rMB, H3, ex3, POLSEL(3),3)
  call pol_wf_A(P(:,4), rMB, H4, ex4, POLSEL(4),4)
  call pol_wf_V(P(:,5), rMZ, H5, ex5, POLSEL(5),5)



  ! internal WFs
  ! e.g. call vert_VQ_A(ntry, ex3, ex1, wf1, n1, t1) ...
  call vert_AQ_S(gH,ntry, ex2(:), ex1(:), wf4(:,1), n3(:,1), t3x4(:,:,1))
  call vert_AQ_S(gX,ntry, ex4(:), ex3(:), wf4(:,2), n3(:,2), t3x4(:,:,2))
  call vert_TV_S(ntry, wf4(:,1), 3, ex5(:), 16, wf12(:,1), n3(:,3), t3x12(:,:,1))
  call vert_AQ_S(gX,ntry, ex2(:), ex1(:), wf4(:,3), n3(:,4), t3x4(:,:,3))
  call vert_AQ_S(gH,ntry, ex4(:), ex3(:), wf4(:,4), n3(:,5), t3x4(:,:,4))
  call vert_VS_T(ntry, ex5(:), 16, wf4(:,3), 3, wf12(:,2), n3(:,6), t3x12(:,:,2))
  call vert_QA_Z(gZd,ntry, ex3(:), ex4(:), wf4(:,5), n3(:,7), t3x4(:,:,5))
  call vert_SV_V(ntry, wf4(:,1), ex5(:), wf12(:,3), n3(:,8), t3x12(:,:,3))
  call vert_QA_Z(gZu,ntry, ex1(:), ex2(:), wf4(:,6), n3(:,9), t3x4(:,:,6))
  call vert_VV_S(ntry, wf4(:,6), ex5(:), wf12(:,4), n3(:,10), t3x12(:,:,4))
  call vert_ZQ_A(gZd,ntry, ex5(:), ex3(:), wf6(:,1), n3(:,11), t3x6(:,:,1))
  call prop_Q_A(ntry, wf6(:,1), 20, MB, 1_intkind1, wf6(:,2), n2(1))
  call vert_SA_Q(gH,ntry, wf4(:,1), ex4(:), wf8(:,1), n3(:,12), t3x8(:,:,1))
  call vert_SA_Q(gX,ntry, wf4(:,3), ex4(:), wf8(:,2), n3(:,13), t3x8(:,:,2))
  call vert_QA_V(ntry, ex1(:), ex2(:), wf4(:,7), n3(:,14), t3x4(:,:,7))
  call vert_AV_Q(ntry, ex4(:), wf4(:,7), wf8(:,3), n3(:,15), t3x8(:,:,3))
  call vert_AZ_Q(gZd,ntry, ex4(:), wf4(:,6), wf8(:,4), n3(:,16), t3x8(:,:,4))
  call vert_AZ_Q(gZd,ntry, ex4(:), ex5(:), wf6(:,3), n3(:,17), t3x6(:,:,2))
  call prop_A_Q(ntry, wf6(:,3), 24, MB, 1_intkind1, wf6(:,4), n2(2))
  call vert_QS_A(gH,ntry, ex3(:), wf4(:,1), wf8(:,5), n3(:,18), t3x8(:,:,5))
  call vert_QS_A(gX,ntry, ex3(:), wf4(:,3), wf8(:,6), n3(:,19), t3x8(:,:,6))
  call vert_VQ_A(ntry, wf4(:,7), ex3(:), wf8(:,7), n3(:,20), t3x8(:,:,7))
  call vert_ZQ_A(gZd,ntry, wf4(:,6), ex3(:), wf8(:,8), n3(:,21), t3x8(:,:,8))
  call vert_AQ_S(gPbt,ntry, ex4(:), ex1(:), wf4(:,8), n3(:,22), t3x4(:,:,8))
  call vert_AQ_S(gPtb,ntry, ex2(:), ex3(:), wf4(:,9), n3(:,23), t3x4(:,:,9))
  call vert_VS_T(ntry, ex5(:), 16, wf4(:,8), 9, wf12(:,5), n3(:,24), t3x12(:,:,5))
  call vert_QA_W(ntry, ex3(:), ex2(:), wf4(:,10), n3(:,25), t3x4(:,:,10))
  call vert_SV_V(ntry, wf4(:,8), ex5(:), wf12(:,6), n3(:,26), t3x12(:,:,6))
  call vert_QA_W(ntry, ex1(:), ex4(:), wf4(:,11), n3(:,27), t3x4(:,:,11))
  call vert_VV_S(ntry, wf4(:,11), ex5(:), wf12(:,7), n3(:,28), t3x12(:,:,7))
  call vert_UV_W(ntry, ex5(:), 16, wf4(:,11), 9, wf12(:,8), n3(:,29), t3x12(:,:,8))
  call vert_ZQ_A(gZu,ntry, ex5(:), ex1(:), wf6(:,5), n3(:,30), t3x6(:,:,3))
  call prop_Q_A(ntry, wf6(:,5), 17, MT, 1_intkind1, wf6(:,6), n2(3))
  call vert_AQ_S(gPbt,ntry, ex4(:), wf6(:,6), wf12(:,9), n3(:,31), t3x12(:,:,9))
  call vert_QA_W(ntry, wf6(:,6), ex4(:), wf12(:,10), n3(:,32), t3x12(:,:,10))
  call vert_QS_A(gPbt,ntry, ex1(:), wf4(:,9), wf8(:,9), n3(:,33), t3x8(:,:,9))
  call vert_WQ_A(ntry, wf4(:,10), ex1(:), wf8(:,10), n3(:,34), t3x8(:,:,10))
  call vert_AZ_Q(gZu,ntry, ex2(:), ex5(:), wf6(:,7), n3(:,35), t3x6(:,:,4))
  call prop_A_Q(ntry, wf6(:,7), 18, MT, 1_intkind1, wf6(:,8), n2(4))
  call vert_QS_A(gPtb,ntry, ex3(:), wf4(:,8), wf8(:,11), n3(:,36), t3x8(:,:,11))
  call vert_WQ_A(ntry, wf4(:,11), ex3(:), wf8(:,12), n3(:,37), t3x8(:,:,12))
  call vert_SA_Q(gPtb,ntry, wf4(:,8), ex2(:), wf8(:,13), n3(:,38), t3x8(:,:,13))
  call vert_AW_Q(ntry, ex2(:), wf4(:,11), wf8(:,14), n3(:,39), t3x8(:,:,14))
  call vert_AQ_S(gH,ntry, ex2(:), wf6(:,6), wf12(:,11), n3(:,40), t3x12(:,:,11))
  call vert_AQ_S(gX,ntry, ex2(:), wf6(:,6), wf12(:,12), n3(:,41), t3x12(:,:,12))
  call vert_QA_V(ntry, ex3(:), ex4(:), wf4(:,12), n3(:,42), t3x4(:,:,12))
  call vert_QA_V(ntry, wf6(:,6), ex2(:), wf12(:,13), n3(:,43), t3x12(:,:,13))
  call vert_QA_Z(gZu,ntry, wf6(:,6), ex2(:), wf12(:,14), n3(:,44), t3x12(:,:,14))
  call vert_AQ_S(gH,ntry, wf6(:,8), ex1(:), wf12(:,15), n3(:,45), t3x12(:,:,15))
  call vert_AQ_S(gX,ntry, wf6(:,8), ex1(:), wf12(:,16), n3(:,46), t3x12(:,:,16))
  call vert_QA_V(ntry, ex1(:), wf6(:,8), wf12(:,17), n3(:,47), t3x12(:,:,17))
  call vert_QA_Z(gZu,ntry, ex1(:), wf6(:,8), wf12(:,18), n3(:,48), t3x12(:,:,18))
  call counter_TV_S(ntry, wf4(:,1), 3, ex5(:), 16, wf12(:,19), n3(:,49), t3x12(:,:,19))
  call counter_VS_T(ntry, ex5(:), 16, wf4(:,3), 3, wf12(:,20), n3(:,50), t3x12(:,:,20))
  call counter_SV_V(ntry, wf4(:,1), ex5(:), wf12(:,21), n3(:,51), t3x12(:,:,21))
  call counter_VV_S(ntry, wf4(:,7), ex5(:), wf12(:,22), n3(:,52), t3x12(:,:,22))
  call counter_VV_S(ntry, wf4(:,6), ex5(:), wf12(:,23), n3(:,53), t3x12(:,:,23))
  call counter_SA_Q(gH,ntry, wf4(:,1), ex4(:), wf8(:,15), n3(:,54), t3x8(:,:,15))
  call counter_SA_Q(EWctHbb,ntry, wf4(:,1), ex4(:), wf8(:,16), n3(:,55), t3x8(:,:,16))
  call counter_SA_Q(gX,ntry, wf4(:,3), ex4(:), wf8(:,17), n3(:,56), t3x8(:,:,17))
  call counter_SA_Q(EWctXbb,ntry, wf4(:,3), ex4(:), wf8(:,18), n3(:,57), t3x8(:,:,18))
  call counter_AV_Q(ntry, ex4(:), wf4(:,7), wf8(:,19), n3(:,58), t3x8(:,:,19))
  call counter_AV_Q_LR(EWctAbb,ntry, ex4(:), wf4(:,7), wf8(:,20), n3(:,59), t3x8(:,:,20))
  call counter_AZ_Q(gZd,ntry, ex4(:), wf4(:,6), wf8(:,21), n3(:,60), t3x8(:,:,21))
  call counter_AZ_Q(EWctVbb,ntry, ex4(:), wf4(:,6), wf8(:,22), n3(:,61), t3x8(:,:,22))
  call counter_AV_Q_LR(EWctGbb,ntry, ex4(:), wf4(:,7), wf8(:,23), n3(:,62), t3x8(:,:,23))
  call counter_AZ_Q(gZd,ntry, ex4(:), ex5(:), wf6(:,9), n3(:,63), t3x6(:,:,5))
  call prop_A_Q(ntry, wf6(:,9), 24, MB, 1_intkind1, wf6(:,10), n2(5))
  call counter_AZ_Q(EWctVbb,ntry, ex4(:), ex5(:), wf6(:,11), n3(:,64), t3x6(:,:,6))
  call prop_A_Q(ntry, wf6(:,11), 24, MB, 1_intkind1, wf6(:,12), n2(6))
  call counter_QS_A(gH,ntry, ex3(:), wf4(:,1), wf8(:,24), n3(:,65), t3x8(:,:,24))
  call counter_QS_A(EWctHbb,ntry, ex3(:), wf4(:,1), wf8(:,25), n3(:,66), t3x8(:,:,25))
  call counter_QS_A(gX,ntry, ex3(:), wf4(:,3), wf8(:,26), n3(:,67), t3x8(:,:,26))
  call counter_QS_A(EWctXbb,ntry, ex3(:), wf4(:,3), wf8(:,27), n3(:,68), t3x8(:,:,27))
  call counter_VQ_A(ntry, wf4(:,7), ex3(:), wf8(:,28), n3(:,69), t3x8(:,:,28))
  call counter_VQ_A_LR(EWctAbb,ntry, wf4(:,7), ex3(:), wf8(:,29), n3(:,70), t3x8(:,:,29))
  call counter_ZQ_A(gZd,ntry, wf4(:,6), ex3(:), wf8(:,30), n3(:,71), t3x8(:,:,30))
  call counter_ZQ_A(EWctVbb,ntry, wf4(:,6), ex3(:), wf8(:,31), n3(:,72), t3x8(:,:,31))
  call counter_VQ_A_LR(EWctGbb,ntry, wf4(:,7), ex3(:), wf8(:,32), n3(:,73), t3x8(:,:,32))
  call counter_ZQ_A(gZd,ntry, ex5(:), ex3(:), wf6(:,13), n3(:,74), t3x6(:,:,7))
  call prop_Q_A(ntry, wf6(:,13), 20, MB, 1_intkind1, wf6(:,14), n2(7))
  call counter_ZQ_A(EWctVbb,ntry, ex5(:), ex3(:), wf6(:,15), n3(:,75), t3x6(:,:,8))
  call prop_Q_A(ntry, wf6(:,15), 20, MB, 1_intkind1, wf6(:,16), n2(8))
  call counter_AQ_S(gX,ntry, ex4(:), ex3(:), wf4(:,13), n3(:,76), t3x4(:,:,13))
  call counter_AQ_S(EWctXbb,ntry, ex4(:), ex3(:), wf4(:,14), n3(:,77), t3x4(:,:,14))
  call counter_AQ_S(gH,ntry, ex4(:), ex3(:), wf4(:,15), n3(:,78), t3x4(:,:,15))
  call counter_AQ_S(EWctHbb,ntry, ex4(:), ex3(:), wf4(:,16), n3(:,79), t3x4(:,:,16))
  call counter_QA_Z(gZd,ntry, ex3(:), ex4(:), wf4(:,17), n3(:,80), t3x4(:,:,17))
  call counter_QA_Z(EWctVbb,ntry, ex3(:), ex4(:), wf4(:,18), n3(:,81), t3x4(:,:,18))
  call counter_VS_T(ntry, ex5(:), 16, wf4(:,8), 9, wf12(:,24), n3(:,82), t3x12(:,:,24))
  call counter_SV_V(ntry, wf4(:,8), ex5(:), wf12(:,25), n3(:,83), t3x12(:,:,25))
  call counter_VV_S(ntry, wf4(:,11), ex5(:), wf12(:,26), n3(:,84), t3x12(:,:,26))
  call counter_UV_W(ntry, ex5(:), 16, wf4(:,11), 9, wf12(:,27), n3(:,85), t3x12(:,:,27))
  call counter_AQ_S(ctSbt,ntry, ex4(:), wf6(:,6), wf12(:,28), n3(:,86), t3x12(:,:,28))
  call counter_AQ_S(EWctPbt,ntry, ex4(:), wf6(:,6), wf12(:,29), n3(:,87), t3x12(:,:,29))
  call counter_QA_W(ntry, wf6(:,6), ex4(:), wf12(:,30), n3(:,88), t3x12(:,:,30))
  call counter_QS_A(ctStb,ntry, ex3(:), wf4(:,8), wf8(:,33), n3(:,89), t3x8(:,:,33))
  call counter_QS_A(EWctPtb,ntry, ex3(:), wf4(:,8), wf8(:,34), n3(:,90), t3x8(:,:,34))
  call counter_WQ_A(ntry, wf4(:,11), ex3(:), wf8(:,35), n3(:,91), t3x8(:,:,35))
  call counter_QA_V(ntry, ex3(:), ex4(:), wf4(:,19), n3(:,92), t3x4(:,:,19))
  call counter_QA_V_LR(EWctAbb,ntry, ex3(:), ex4(:), wf4(:,20), n3(:,93), t3x4(:,:,20))
  call counter_QA_V_LR(EWctGbb,ntry, ex3(:), ex4(:), wf4(:,21), n3(:,94), t3x4(:,:,21))
  call counter_SA_Q(ctStb,ntry, wf4(:,8), ex2(:), wf8(:,36), n3(:,95), t3x8(:,:,36))
  call counter_SA_Q(EWctPtb,ntry, wf4(:,8), ex2(:), wf8(:,37), n3(:,96), t3x8(:,:,37))
  call counter_AW_Q(ntry, ex2(:), wf4(:,11), wf8(:,38), n3(:,97), t3x8(:,:,38))
  call counter_AZ_Q(gZu,ntry, ex2(:), ex5(:), wf6(:,17), n3(:,98), t3x6(:,:,9))
  call prop_A_Q(ntry, wf6(:,17), 18, MT, 1_intkind1, wf6(:,18), n2(9))
  call counter_AZ_Q(EWctVtt,ntry, ex2(:), ex5(:), wf6(:,19), n3(:,99), t3x6(:,:,10))
  call prop_A_Q(ntry, wf6(:,19), 18, MT, 1_intkind1, wf6(:,20), n2(10))
  call counter_AQ_S(gH,ntry, ex2(:), wf6(:,6), wf12(:,31), n3(:,100), t3x12(:,:,31))
  call counter_AQ_S(EWctHtt,ntry, ex2(:), wf6(:,6), wf12(:,32), n3(:,101), t3x12(:,:,32))
  call counter_AQ_S(gX,ntry, ex2(:), wf6(:,6), wf12(:,33), n3(:,102), t3x12(:,:,33))
  call counter_AQ_S(EWctXtt,ntry, ex2(:), wf6(:,6), wf12(:,34), n3(:,103), t3x12(:,:,34))
  call counter_QA_V(ntry, wf6(:,6), ex2(:), wf12(:,35), n3(:,104), t3x12(:,:,35))
  call counter_QA_V_LR(EWctAtt,ntry, wf6(:,6), ex2(:), wf12(:,36), n3(:,105), t3x12(:,:,36))
  call counter_QA_Z(gZu,ntry, wf6(:,6), ex2(:), wf12(:,37), n3(:,106), t3x12(:,:,37))
  call counter_QA_Z(EWctVtt,ntry, wf6(:,6), ex2(:), wf12(:,38), n3(:,107), t3x12(:,:,38))
  call counter_QA_V_LR(EWctGtt,ntry, wf6(:,6), ex2(:), wf12(:,39), n3(:,108), t3x12(:,:,39))
  call vert_AQ_S(gH,ntry, wf6(:,18), ex1(:), wf12(:,40), n3(:,109), t3x12(:,:,40))
  call vert_AQ_S(gH,ntry, wf6(:,20), ex1(:), wf12(:,41), n3(:,110), t3x12(:,:,41))
  call vert_AQ_S(gX,ntry, wf6(:,18), ex1(:), wf12(:,42), n3(:,111), t3x12(:,:,42))
  call vert_AQ_S(gX,ntry, wf6(:,20), ex1(:), wf12(:,43), n3(:,112), t3x12(:,:,43))
  call vert_QA_V(ntry, ex1(:), wf6(:,18), wf12(:,44), n3(:,113), t3x12(:,:,44))
  call vert_QA_V(ntry, ex1(:), wf6(:,20), wf12(:,45), n3(:,114), t3x12(:,:,45))
  call vert_QA_Z(gZu,ntry, ex1(:), wf6(:,18), wf12(:,46), n3(:,115), t3x12(:,:,46))
  call vert_QA_Z(gZu,ntry, ex1(:), wf6(:,20), wf12(:,47), n3(:,116), t3x12(:,:,47))
  call counter_AQ_S(ctStb,ntry, ex2(:), ex3(:), wf4(:,22), n3(:,117), t3x4(:,:,22))
  call counter_AQ_S(EWctPtb,ntry, ex2(:), ex3(:), wf4(:,23), n3(:,118), t3x4(:,:,23))
  call counter_QA_W(ntry, ex3(:), ex2(:), wf4(:,24), n3(:,119), t3x4(:,:,24))
  call vert_QS_A(gPbt,ntry, ex1(:), wf4(:,22), wf8(:,39), n3(:,120), t3x8(:,:,39))
  call vert_QS_A(gPbt,ntry, ex1(:), wf4(:,23), wf8(:,40), n3(:,121), t3x8(:,:,40))
  call vert_WQ_A(ntry, wf4(:,24), ex1(:), wf8(:,41), n3(:,122), t3x8(:,:,41))
  call counter_QS_A(ctSbt,ntry, ex1(:), wf4(:,9), wf8(:,42), n3(:,123), t3x8(:,:,42))
  call counter_QS_A(EWctPbt,ntry, ex1(:), wf4(:,9), wf8(:,43), n3(:,124), t3x8(:,:,43))
  call counter_WQ_A(ntry, wf4(:,10), ex1(:), wf8(:,44), n3(:,125), t3x8(:,:,44))
  call counter_ZQ_A(gZu,ntry, ex5(:), ex1(:), wf6(:,21), n3(:,126), t3x6(:,:,11))
  call prop_Q_A(ntry, wf6(:,21), 17, MT, 1_intkind1, wf6(:,22), n2(11))
  call vert_AQ_S(gPbt,ntry, ex4(:), wf6(:,22), wf12(:,48), n3(:,127), t3x12(:,:,48))
  call counter_ZQ_A(EWctVtt,ntry, ex5(:), ex1(:), wf6(:,23), n3(:,128), t3x6(:,:,12))
  call prop_Q_A(ntry, wf6(:,23), 17, MT, 1_intkind1, wf6(:,24), n2(12))
  call vert_AQ_S(gPbt,ntry, ex4(:), wf6(:,24), wf12(:,49), n3(:,129), t3x12(:,:,49))
  call vert_QA_W(ntry, wf6(:,22), ex4(:), wf12(:,50), n3(:,130), t3x12(:,:,50))
  call vert_QA_W(ntry, wf6(:,24), ex4(:), wf12(:,51), n3(:,131), t3x12(:,:,51))
  call counter_AQ_S(ctSbt,ntry, ex4(:), ex1(:), wf4(:,25), n3(:,132), t3x4(:,:,25))
  call vert_VS_T(ntry, ex5(:), 16, wf4(:,25), 9, wf12(:,52), n3(:,133), t3x12(:,:,52))
  call counter_AQ_S(EWctPbt,ntry, ex4(:), ex1(:), wf4(:,26), n3(:,134), t3x4(:,:,26))
  call vert_VS_T(ntry, ex5(:), 16, wf4(:,26), 9, wf12(:,53), n3(:,135), t3x12(:,:,53))
  call vert_SV_V(ntry, wf4(:,25), ex5(:), wf12(:,54), n3(:,136), t3x12(:,:,54))
  call vert_SV_V(ntry, wf4(:,26), ex5(:), wf12(:,55), n3(:,137), t3x12(:,:,55))
  call counter_QA_W(ntry, ex1(:), ex4(:), wf4(:,27), n3(:,138), t3x4(:,:,27))
  call vert_VV_S(ntry, wf4(:,27), ex5(:), wf12(:,56), n3(:,139), t3x12(:,:,56))
  call vert_UV_W(ntry, ex5(:), 16, wf4(:,27), 9, wf12(:,57), n3(:,140), t3x12(:,:,57))
  call counter_AQ_S(gH,ntry, wf6(:,8), ex1(:), wf12(:,58), n3(:,141), t3x12(:,:,58))
  call counter_AQ_S(EWctHtt,ntry, wf6(:,8), ex1(:), wf12(:,59), n3(:,142), t3x12(:,:,59))
  call counter_AQ_S(gX,ntry, wf6(:,8), ex1(:), wf12(:,60), n3(:,143), t3x12(:,:,60))
  call counter_AQ_S(EWctXtt,ntry, wf6(:,8), ex1(:), wf12(:,61), n3(:,144), t3x12(:,:,61))
  call counter_QA_V(ntry, ex1(:), wf6(:,8), wf12(:,62), n3(:,145), t3x12(:,:,62))
  call counter_QA_V_LR(EWctAtt,ntry, ex1(:), wf6(:,8), wf12(:,63), n3(:,146), t3x12(:,:,63))
  call counter_QA_Z(gZu,ntry, ex1(:), wf6(:,8), wf12(:,64), n3(:,147), t3x12(:,:,64))
  call counter_QA_Z(EWctVtt,ntry, ex1(:), wf6(:,8), wf12(:,65), n3(:,148), t3x12(:,:,65))
  call counter_QA_V_LR(EWctGtt,ntry, ex1(:), wf6(:,8), wf12(:,66), n3(:,149), t3x12(:,:,66))
  call vert_AQ_S(gH,ntry, ex2(:), wf6(:,22), wf12(:,67), n3(:,150), t3x12(:,:,67))
  call vert_AQ_S(gH,ntry, ex2(:), wf6(:,24), wf12(:,68), n3(:,151), t3x12(:,:,68))
  call vert_AQ_S(gX,ntry, ex2(:), wf6(:,22), wf12(:,69), n3(:,152), t3x12(:,:,69))
  call vert_AQ_S(gX,ntry, ex2(:), wf6(:,24), wf12(:,70), n3(:,153), t3x12(:,:,70))
  call vert_QA_V(ntry, wf6(:,22), ex2(:), wf12(:,71), n3(:,154), t3x12(:,:,71))
  call vert_QA_V(ntry, wf6(:,24), ex2(:), wf12(:,72), n3(:,155), t3x12(:,:,72))
  call vert_QA_Z(gZu,ntry, wf6(:,22), ex2(:), wf12(:,73), n3(:,156), t3x12(:,:,73))
  call vert_QA_Z(gZu,ntry, wf6(:,24), ex2(:), wf12(:,74), n3(:,157), t3x12(:,:,74))
  call vert_QS_A(gPtb,ntry, ex3(:), wf4(:,25), wf8(:,45), n3(:,158), t3x8(:,:,45))
  call vert_QS_A(gPtb,ntry, ex3(:), wf4(:,26), wf8(:,46), n3(:,159), t3x8(:,:,46))
  call vert_WQ_A(ntry, wf4(:,27), ex3(:), wf8(:,47), n3(:,160), t3x8(:,:,47))
  call vert_SA_Q(gPtb,ntry, wf4(:,25), ex2(:), wf8(:,48), n3(:,161), t3x8(:,:,48))
  call vert_SA_Q(gPtb,ntry, wf4(:,26), ex2(:), wf8(:,49), n3(:,162), t3x8(:,:,49))
  call vert_AW_Q(ntry, ex2(:), wf4(:,27), wf8(:,50), n3(:,163), t3x8(:,:,50))
  call counter_AQ_S(gH,ntry, ex2(:), ex1(:), wf4(:,28), n3(:,164), t3x4(:,:,28))
  call vert_TV_S(ntry, wf4(:,28), 3, ex5(:), 16, wf12(:,75), n3(:,165), t3x12(:,:,75))
  call counter_AQ_S(EWctHtt,ntry, ex2(:), ex1(:), wf4(:,29), n3(:,166), t3x4(:,:,29))
  call vert_TV_S(ntry, wf4(:,29), 3, ex5(:), 16, wf12(:,76), n3(:,167), t3x12(:,:,76))
  call counter_AQ_S(gX,ntry, ex2(:), ex1(:), wf4(:,30), n3(:,168), t3x4(:,:,30))
  call vert_VS_T(ntry, ex5(:), 16, wf4(:,30), 3, wf12(:,77), n3(:,169), t3x12(:,:,77))
  call counter_AQ_S(EWctXtt,ntry, ex2(:), ex1(:), wf4(:,31), n3(:,170), t3x4(:,:,31))
  call vert_VS_T(ntry, ex5(:), 16, wf4(:,31), 3, wf12(:,78), n3(:,171), t3x12(:,:,78))
  call vert_SV_V(ntry, wf4(:,28), ex5(:), wf12(:,79), n3(:,172), t3x12(:,:,79))
  call vert_SV_V(ntry, wf4(:,29), ex5(:), wf12(:,80), n3(:,173), t3x12(:,:,80))
  call counter_QA_Z(gZu,ntry, ex1(:), ex2(:), wf4(:,32), n3(:,174), t3x4(:,:,32))
  call vert_VV_S(ntry, wf4(:,32), ex5(:), wf12(:,81), n3(:,175), t3x12(:,:,81))
  call counter_QA_Z(EWctVtt,ntry, ex1(:), ex2(:), wf4(:,33), n3(:,176), t3x4(:,:,33))
  call vert_VV_S(ntry, wf4(:,33), ex5(:), wf12(:,82), n3(:,177), t3x12(:,:,82))
  call vert_SA_Q(gH,ntry, wf4(:,28), ex4(:), wf8(:,51), n3(:,178), t3x8(:,:,51))
  call vert_SA_Q(gH,ntry, wf4(:,29), ex4(:), wf8(:,52), n3(:,179), t3x8(:,:,52))
  call vert_SA_Q(gX,ntry, wf4(:,30), ex4(:), wf8(:,53), n3(:,180), t3x8(:,:,53))
  call vert_SA_Q(gX,ntry, wf4(:,31), ex4(:), wf8(:,54), n3(:,181), t3x8(:,:,54))
  call counter_QA_V(ntry, ex1(:), ex2(:), wf4(:,34), n3(:,182), t3x4(:,:,34))
  call vert_AV_Q(ntry, ex4(:), wf4(:,34), wf8(:,55), n3(:,183), t3x8(:,:,55))
  call counter_QA_V_LR(EWctAtt,ntry, ex1(:), ex2(:), wf4(:,35), n3(:,184), t3x4(:,:,35))
  call vert_AV_Q(ntry, ex4(:), wf4(:,35), wf8(:,56), n3(:,185), t3x8(:,:,56))
  call vert_AZ_Q(gZd,ntry, ex4(:), wf4(:,32), wf8(:,57), n3(:,186), t3x8(:,:,57))
  call vert_AZ_Q(gZd,ntry, ex4(:), wf4(:,33), wf8(:,58), n3(:,187), t3x8(:,:,58))
  call counter_QA_V_LR(EWctGtt,ntry, ex1(:), ex2(:), wf4(:,36), n3(:,188), t3x4(:,:,36))
  call vert_AV_Q(ntry, ex4(:), wf4(:,36), wf8(:,59), n3(:,189), t3x8(:,:,59))
  call vert_QS_A(gH,ntry, ex3(:), wf4(:,28), wf8(:,60), n3(:,190), t3x8(:,:,60))
  call vert_QS_A(gH,ntry, ex3(:), wf4(:,29), wf8(:,61), n3(:,191), t3x8(:,:,61))
  call vert_QS_A(gX,ntry, ex3(:), wf4(:,30), wf8(:,62), n3(:,192), t3x8(:,:,62))
  call vert_QS_A(gX,ntry, ex3(:), wf4(:,31), wf8(:,63), n3(:,193), t3x8(:,:,63))
  call vert_VQ_A(ntry, wf4(:,34), ex3(:), wf8(:,64), n3(:,194), t3x8(:,:,64))
  call vert_VQ_A(ntry, wf4(:,35), ex3(:), wf8(:,65), n3(:,195), t3x8(:,:,65))
  call vert_ZQ_A(gZd,ntry, wf4(:,32), ex3(:), wf8(:,66), n3(:,196), t3x8(:,:,66))
  call vert_ZQ_A(gZd,ntry, wf4(:,33), ex3(:), wf8(:,67), n3(:,197), t3x8(:,:,67))
  call vert_VQ_A(ntry, wf4(:,36), ex3(:), wf8(:,68), n3(:,198), t3x8(:,:,68))
  call vert_VS_T(ntry, ex5(:), 16, wf4(:,2), 12, wf12(:,83), n3(:,199), t3x12(:,:,83))
  call counter_S_S(EWctHH,ntry, wf4(:,1), 3, wf4(:,37), n2(13))
  call vert_TV_S(ntry, wf4(:,4), 12, ex5(:), 16, wf12(:,84), n3(:,200), t3x12(:,:,84))
  call counter_S_S(EWctXX,ntry, wf4(:,3), 3, wf4(:,38), n2(14))
  call vert_VV_S(ntry, wf4(:,5), ex5(:), wf12(:,85), n3(:,201), t3x12(:,:,85))
  call vert_SV_V(ntry, wf4(:,4), ex5(:), wf12(:,86), n3(:,202), t3x12(:,:,86))
  call counter_S_V(EWctXZ,ntry, wf4(:,3), 3, wf4(:,39), n2(15))
  call counter_V_S(EWctXA,ntry, wf4(:,7), 3, wf4(:,40), n2(16))
  call counter_V_S(EWctXZ,ntry, wf4(:,6), 3, wf4(:,41), n2(17))
  call counter_V_V(EWctAZ,ntry, wf4(:,7), 3, wf4(:,42), n2(18))
  call counter_V_V(EWctZZ,ntry, wf4(:,6), 3, wf4(:,43), n2(19))
  call counter_S_S(EWctHH,ntry, wf4(:,4), 12, wf4(:,44), n2(20))
  call counter_S_S(EWctXX,ntry, wf4(:,2), 12, wf4(:,45), n2(21))
  call counter_S_V(EWctXZ,ntry, wf4(:,2), 12, wf4(:,46), n2(22))
  call counter_V_S(EWctXA,ntry, wf4(:,12), 12, wf4(:,47), n2(23))
  call counter_V_S(EWctXZ,ntry, wf4(:,5), 12, wf4(:,48), n2(24))
  call counter_V_V(EWctAZ,ntry, wf4(:,12), 12, wf4(:,49), n2(25))
  call counter_V_V(EWctZZ,ntry, wf4(:,5), 12, wf4(:,50), n2(26))
  call vert_AQ_S(gH,ntry, ex4(:), wf6(:,2), wf12(:,87), n3(:,203), t3x12(:,:,87))
  call vert_AQ_S(gX,ntry, ex4(:), wf6(:,2), wf12(:,88), n3(:,204), t3x12(:,:,88))
  call vert_QA_V(ntry, wf6(:,2), ex4(:), wf12(:,89), n3(:,205), t3x12(:,:,89))
  call counter_S_V(EWctXA,ntry, wf4(:,3), 3, wf4(:,51), n2(27))
  call vert_QA_Z(gZd,ntry, wf6(:,2), ex4(:), wf12(:,90), n3(:,206), t3x12(:,:,90))
  call counter_V_V(EWctAA,ntry, wf4(:,7), 3, wf4(:,52), n2(28))
  call counter_V_V(EWctAZ,ntry, wf4(:,6), 3, wf4(:,53), n2(29))
  call counter_Q_A(ctbb,5,ntry, wf6(:,2), 20, wf6(:,25), n2(30))
  call prop_A_Q(ntry, wf8(:,1), 11, MB, 1_intkind1, wf8(:,69), n2(31))
  call counter_Q_A_LR(EWctbb,ntry, wf6(:,2), 20, wf6(:,26), n2(32))
  call prop_A_Q(ntry, wf8(:,2), 11, MB, 1_intkind1, wf8(:,70), n2(33))
  call prop_A_Q(ntry, wf8(:,3), 11, MB, 1_intkind1, wf8(:,71), n2(34))
  call prop_A_Q(ntry, wf8(:,4), 11, MB, 1_intkind1, wf8(:,72), n2(35))
  call vert_AQ_S(gH,ntry, wf6(:,4), ex3(:), wf12(:,91), n3(:,207), t3x12(:,:,91))
  call vert_AQ_S(gX,ntry, wf6(:,4), ex3(:), wf12(:,92), n3(:,208), t3x12(:,:,92))
  call vert_QA_V(ntry, ex3(:), wf6(:,4), wf12(:,93), n3(:,209), t3x12(:,:,93))
  call vert_QA_Z(gZd,ntry, ex3(:), wf6(:,4), wf12(:,94), n3(:,210), t3x12(:,:,94))
  call counter_A_Q(ctbb,5,ntry, wf6(:,4), 24, wf6(:,27), n2(36))
  call prop_Q_A(ntry, wf8(:,5), 7, MB, 1_intkind1, wf8(:,73), n2(37))
  call counter_A_Q_LR(EWctbb,ntry, wf6(:,4), 24, wf6(:,28), n2(38))
  call prop_Q_A(ntry, wf8(:,6), 7, MB, 1_intkind1, wf8(:,74), n2(39))
  call prop_Q_A(ntry, wf8(:,7), 7, MB, 1_intkind1, wf8(:,75), n2(40))
  call prop_Q_A(ntry, wf8(:,8), 7, MB, 1_intkind1, wf8(:,76), n2(41))
  call vert_TV_S(ntry, wf4(:,9), 6, ex5(:), 16, wf12(:,95), n3(:,211), t3x12(:,:,95))
  call counter_S_S(EWctPP,ntry, wf4(:,8), 9, wf4(:,54), n2(42))
  call vert_VV_S(ntry, wf4(:,10), ex5(:), wf12(:,96), n3(:,212), t3x12(:,:,96))
  call vert_SV_V(ntry, wf4(:,9), ex5(:), wf12(:,97), n3(:,213), t3x12(:,:,97))
  call counter_S_V(EWctPW,ntry, wf4(:,8), 9, wf4(:,55), n2(43))
  call vert_UV_W(ntry, wf4(:,10), 6, ex5(:), 16, wf12(:,98), n3(:,214), t3x12(:,:,98))
  call counter_V_S(EWctPW,ntry, wf4(:,11), 9, wf4(:,56), n2(44))
  call counter_V_V(EWctWW,ntry, wf4(:,11), 9, wf4(:,57), n2(45))
  call counter_S_S(EWctPP,ntry, wf4(:,9), 6, wf4(:,58), n2(46))
  call counter_S_V(EWctPW,ntry, wf4(:,9), 6, wf4(:,59), n2(47))
  call counter_V_S(EWctPW,ntry, wf4(:,10), 6, wf4(:,60), n2(48))
  call counter_V_V(EWctWW,ntry, wf4(:,10), 6, wf4(:,61), n2(49))
  call vert_SA_Q(gPbt,ntry, wf4(:,9), ex4(:), wf8(:,77), n3(:,215), t3x8(:,:,69))
  call counter_Q_A(cttt,6,ntry, wf6(:,6), 17, wf6(:,29), n2(50))
  call prop_A_Q(ntry, wf8(:,77), 14, MT, 1_intkind1, wf8(:,78), n2(51))
  call counter_Q_A_LR(EWcttt,ntry, wf6(:,6), 17, wf6(:,30), n2(52))
  call vert_AW_Q(ntry, ex4(:), wf4(:,10), wf8(:,79), n3(:,216), t3x8(:,:,70))
  call prop_A_Q(ntry, wf8(:,79), 14, MT, 1_intkind1, wf8(:,80), n2(53))
  call vert_AQ_S(gPbt,ntry, wf6(:,4), ex1(:), wf12(:,99), n3(:,217), t3x12(:,:,99))
  call vert_QA_W(ntry, ex1(:), wf6(:,4), wf12(:,100), n3(:,218), t3x12(:,:,100))
  call prop_Q_A(ntry, wf8(:,9), 7, MB, 1_intkind1, wf8(:,81), n2(54))
  call prop_Q_A(ntry, wf8(:,10), 7, MB, 1_intkind1, wf8(:,82), n2(55))
  call vert_AQ_S(gPtb,ntry, wf6(:,8), ex3(:), wf12(:,101), n3(:,219), t3x12(:,:,101))
  call vert_QA_W(ntry, ex3(:), wf6(:,8), wf12(:,102), n3(:,220), t3x12(:,:,102))
  call counter_A_Q(cttt,6,ntry, wf6(:,8), 18, wf6(:,31), n2(56))
  call prop_Q_A(ntry, wf8(:,11), 13, MT, 1_intkind1, wf8(:,83), n2(57))
  call counter_A_Q_LR(EWcttt,ntry, wf6(:,8), 18, wf6(:,32), n2(58))
  call prop_Q_A(ntry, wf8(:,12), 13, MT, 1_intkind1, wf8(:,84), n2(59))
  call vert_AQ_S(gPtb,ntry, ex2(:), wf6(:,2), wf12(:,103), n3(:,221), t3x12(:,:,103))
  call vert_QA_W(ntry, wf6(:,2), ex2(:), wf12(:,104), n3(:,222), t3x12(:,:,104))
  call prop_A_Q(ntry, wf8(:,13), 11, MB, 1_intkind1, wf8(:,85), n2(60))
  call prop_A_Q(ntry, wf8(:,14), 11, MB, 1_intkind1, wf8(:,86), n2(61))
  call vert_SA_Q(gH,ntry, wf4(:,4), ex2(:), wf8(:,87), n3(:,223), t3x8(:,:,71))
  call prop_A_Q(ntry, wf8(:,87), 14, MT, 1_intkind1, wf8(:,88), n2(62))
  call vert_SA_Q(gX,ntry, wf4(:,2), ex2(:), wf8(:,89), n3(:,224), t3x8(:,:,72))
  call prop_A_Q(ntry, wf8(:,89), 14, MT, 1_intkind1, wf8(:,90), n2(63))
  call vert_AV_Q(ntry, ex2(:), wf4(:,12), wf8(:,91), n3(:,225), t3x8(:,:,73))
  call prop_A_Q(ntry, wf8(:,91), 14, MT, 1_intkind1, wf8(:,92), n2(64))
  call vert_AZ_Q(gZu,ntry, ex2(:), wf4(:,5), wf8(:,93), n3(:,226), t3x8(:,:,74))
  call prop_A_Q(ntry, wf8(:,93), 14, MT, 1_intkind1, wf8(:,94), n2(65))
  call counter_S_V(EWctXA,ntry, wf4(:,2), 12, wf4(:,62), n2(66))
  call counter_V_V(EWctAA,ntry, wf4(:,12), 12, wf4(:,63), n2(67))
  call counter_V_V(EWctAZ,ntry, wf4(:,5), 12, wf4(:,64), n2(68))
  call vert_QS_A(gH,ntry, ex1(:), wf4(:,4), wf8(:,95), n3(:,227), t3x8(:,:,75))
  call prop_Q_A(ntry, wf8(:,95), 13, MT, 1_intkind1, wf8(:,96), n2(69))
  call vert_QS_A(gX,ntry, ex1(:), wf4(:,2), wf8(:,97), n3(:,228), t3x8(:,:,76))
  call prop_Q_A(ntry, wf8(:,97), 13, MT, 1_intkind1, wf8(:,98), n2(70))
  call vert_VQ_A(ntry, wf4(:,12), ex1(:), wf8(:,99), n3(:,229), t3x8(:,:,77))
  call prop_Q_A(ntry, wf8(:,99), 13, MT, 1_intkind1, wf8(:,100), n2(71))
  call vert_ZQ_A(gZu,ntry, wf4(:,5), ex1(:), wf8(:,101), n3(:,230), t3x8(:,:,78))
  call prop_Q_A(ntry, wf8(:,101), 13, MT, 1_intkind1, wf8(:,102), n2(72))


  call init_hybrid_exwf(ex1)
  call init_hybrid_exwf(ex2)
  call init_hybrid_exwf(ex3)
  call init_hybrid_exwf(ex4)
  call init_hybrid_exwf(ex5)
  call init_hybrid_wf(wf4)
  call init_hybrid_wf(wf6)
  call init_hybrid_wf(wf8)
  call init_hybrid_wf(wf12)


  if (ntry==1) then
    call physical_helicities()
  end if

  ! computation of the colour-stripped amplitudes
  do nsync = ntry+ntry-1, ntry+1  !  nsync = 1,2  for 1st point and nsync = 3 later
    call diagrams()
    if (nsync == 1) call helsync(nsync, A, nhel, Hel)
  end do

  ! In the following loop the coefficients \Gamma_{i} of the expansion in
  ! the colour basis are computed for every helicity state and stored in M1helarray.
  ! Also the colour vector for the Born-loop interference is computed and saved in
  ! M0_col1_helarray
  do k = 1, nhel
    call colourvectors(A, k, M1helarray(:,k),M1helarray_ct(:,k))
    call colborninterf(M1helarray(:,k), M0_col1_helarray(:,k), 0)
  end do
  M1helarray(:,nhel+1:)%j = 0
  M0_col1_helarray(:,nhel+1:)%hf = -1_intkind2
  M0_col1_helarray(:,nhel+1:)%j = 0

  M2add = 0
  M2add_ct = 0
  M2add_colint = 0

  M02 = 0
  M2ct = 0
  M2colint = 0

  do k = 1, nhel
    call colint(M1helarray(:,k)%j, M2add)
    call colint_ct(M1helarray(:,k)%j, M1helarray_ct(:,k)%j, M2add_ct, 0)
    if (IR_is_on > 0) then
      call colint_IR(M1helarray(:,k)%j, M2add_colint)
    end if
    !summation over helicity configurations
    M02 = M02 + M2add
    M2ct = M2ct + M2add_ct
    M2colint = M2colint + M2add_colint
  end do

  call photon_factors(photonid_ppztt_ew_ttxbbxz_3, 0, bornphotonfactor)
  M02 = bornphotonfactor * M02
  M2ct = bornphotonfactor * M2ct
  M2colint = bornphotonfactor * M2colint

  !! used for born-loop colour-correlators
  extcombs = [(i, i = 0, 16-1)]
  nextcombs = 5*(5+1)/2 + 1
  if(nextcombs>0) then
    allocate(extcombs_permuted(nextcombs))
  end if
  do k = 1, nextcombs
    extcombs_permuted(k) = extcomb_perm_ppztt_ew_ttxbbxz_3(extcombs(k))
  end do

#if 1 > 0 && 5 > 3
  !!Born-loop colour correlators interference
ind_cc_comb = [8,12,9,13,14]
  M0M1_hel_cc(:,:,:)%j = 0
  do n = 1, 5
    M2add_ct = 0
    m = ind_cc_comb(n)
      do k = 1, nhel
        call colint_ct(M1helarray(:,k)%j, M1helarray_ct(:,k)%j, M2add_ct, m)
        call colborninterf(M1helarray(:,k), M0M1_hel_cc(:,k,m), m)
        M2ctcc(m) = M2ctcc(m) + M2add_ct
      end do
  end do
  M0M1_hel_cc(:,nhel+1:,:)%hf = -1_intkind2
  M0M1_hel_cc(:,nhel+1:,:)%j = 0
#endif


  contains

subroutine physical_helicities()
  implicit none

integer :: i1,i2,i3,i4,i5
integer :: n

n=0

do i5= 1, 3
do i4= 1, 2
do i3= 1, 2
do i2= 1, 2
do i1= 1, 2
n = n + 1
 if((ex1(i1)%hf==-1_intkind2) .OR. (ex2(i2)%hf==-1_intkind2) .OR. (ex3(i3)%hf==-1_intkind2) .OR. (ex4(i4)%hf==-1_intkind2)  &
    .OR. (ex5(i5)%hf==-1_intkind2)) then
  Hel(n) = -1_intkind2
 else
  Hel(n) = ex1(i1)%hf + ex2(i2)%hf + ex3(i3)%hf + ex4(i4)%hf + ex5(i5)%hf
 end if
end do
end do
end do
end do
end do

end subroutine physical_helicities

subroutine diagrams()
  implicit none
  integer :: h
  ! e.g. call cont_VV(nsync, wf3, wf6, A(:,1), n64, t64, nhel, den(5)) ...

    call Hcont_SS(nsync, wf4(:,2), wf12(:,1), A(:,1), n3(:,231), t3x48(:,:,1), nhel, den(3))
    call Hcont_SS(nsync, wf4(:,4), wf12(:,2), A(:,2), n3(:,232), t3x48(:,:,2), nhel, den(6))
    call Hcont_VV(nsync, wf4(:,5), wf12(:,3), A(:,3), n3(:,233), t3x48(:,:,3), nhel, den(3))
    call Hcont_SS(nsync, wf4(:,4), wf12(:,4), A(:,4), n3(:,234), t3x48(:,:,4), nhel, den(6))
    call Hcont_QA(nsync, wf6(:,2), wf8(:,1), A(:,5), n3(:,235), t3x48(:,:,5), nhel, den(8))
    call Hcont_QA(nsync, wf6(:,2), wf8(:,2), A(:,6), n3(:,236), t3x48(:,:,6), nhel, den(9))
    call Hcont_QA(nsync, wf6(:,2), wf8(:,3), A(:,7), n3(:,237), t3x48(:,:,7), nhel, den(11))
    call Hcont_QA(nsync, wf6(:,2), wf8(:,4), A(:,8), n3(:,238), t3x48(:,:,8), nhel, den(9))
    call Hcont_QA(nsync, wf6(:,2), wf8(:,3), A(:,9), n3(:,239), t3x48(:,:,9), nhel, den(11))
    call Hcont_QA(nsync, wf6(:,4), wf8(:,5), A(:,10), n3(:,240), t3x48(:,:,10), nhel, den(13))
    call Hcont_QA(nsync, wf6(:,4), wf8(:,6), A(:,11), n3(:,241), t3x48(:,:,11), nhel, den(14))
    call Hcont_QA(nsync, wf6(:,4), wf8(:,7), A(:,12), n3(:,242), t3x48(:,:,12), nhel, den(15))
    call Hcont_QA(nsync, wf6(:,4), wf8(:,8), A(:,13), n3(:,243), t3x48(:,:,13), nhel, den(14))
    call Hcont_QA(nsync, wf6(:,4), wf8(:,7), A(:,14), n3(:,244), t3x48(:,:,14), nhel, den(15))
    call Hcont_SS(nsync, wf4(:,9), wf12(:,5), A(:,15), n3(:,245), t3x48(:,:,15), nhel, den(18))
    call Hcont_VV(nsync, wf4(:,10), wf12(:,6), A(:,16), n3(:,246), t3x48(:,:,16), nhel, den(18))
    call Hcont_SS(nsync, wf4(:,9), wf12(:,7), A(:,17), n3(:,247), t3x48(:,:,17), nhel, den(18))
    call Hcont_VV(nsync, wf4(:,10), wf12(:,8), A(:,18), n3(:,248), t3x48(:,:,18), nhel, den(18))
    call Hcont_SS(nsync, wf4(:,9), wf12(:,9), A(:,19), n3(:,249), t3x48(:,:,19), nhel, den(20))
    call Hcont_VV(nsync, wf4(:,10), wf12(:,10), A(:,20), n3(:,250), t3x48(:,:,20), nhel, den(20))
    call Hcont_QA(nsync, wf6(:,4), wf8(:,9), A(:,21), n3(:,251), t3x48(:,:,21), nhel, den(21))
    call Hcont_QA(nsync, wf6(:,4), wf8(:,10), A(:,22), n3(:,252), t3x48(:,:,22), nhel, den(21))
    call Hcont_QA(nsync, wf6(:,8), wf8(:,11), A(:,23), n3(:,253), t3x48(:,:,23), nhel, den(23))
    call Hcont_QA(nsync, wf6(:,8), wf8(:,12), A(:,24), n3(:,254), t3x48(:,:,24), nhel, den(23))
    call Hcont_QA(nsync, wf6(:,2), wf8(:,13), A(:,25), n3(:,255), t3x48(:,:,25), nhel, den(24))
    call Hcont_QA(nsync, wf6(:,2), wf8(:,14), A(:,26), n3(:,256), t3x48(:,:,26), nhel, den(24))
    call Hcont_SS(nsync, wf4(:,4), wf12(:,11), A(:,27), n3(:,257), t3x48(:,:,27), nhel, den(25))
    call Hcont_SS(nsync, wf4(:,2), wf12(:,12), A(:,28), n3(:,258), t3x48(:,:,28), nhel, den(26))
    call Hcont_VV(nsync, wf4(:,12), wf12(:,13), A(:,29), n3(:,259), t3x48(:,:,29), nhel, den(28))
    call Hcont_VV(nsync, wf4(:,5), wf12(:,14), A(:,30), n3(:,260), t3x48(:,:,30), nhel, den(26))
    call Hcont_VV(nsync, wf4(:,12), wf12(:,13), A(:,31), n3(:,261), t3x48(:,:,31), nhel, den(28))
    call Hcont_SS(nsync, wf4(:,4), wf12(:,15), A(:,32), n3(:,262), t3x48(:,:,32), nhel, den(29))
    call Hcont_SS(nsync, wf4(:,2), wf12(:,16), A(:,33), n3(:,263), t3x48(:,:,33), nhel, den(30))
    call Hcont_VV(nsync, wf4(:,12), wf12(:,17), A(:,34), n3(:,264), t3x48(:,:,34), nhel, den(31))
    call Hcont_VV(nsync, wf4(:,5), wf12(:,18), A(:,35), n3(:,265), t3x48(:,:,35), nhel, den(30))
    call Hcont_VV(nsync, wf4(:,12), wf12(:,17), A(:,36), n3(:,266), t3x48(:,:,36), nhel, den(31))

    call Hcont_SS(nsync, wf4(:,2), wf12(:,19), A(:,37), n3(:,267), t3x48(:,:,37), nhel, den(3))
    call Hcont_SS(nsync, wf4(:,4), wf12(:,20), A(:,38), n3(:,268), t3x48(:,:,38), nhel, den(6))
    call Hcont_VV(nsync, wf4(:,12), wf12(:,21), A(:,39), n3(:,269), t3x48(:,:,39), nhel, den(32))
    call Hcont_VV(nsync, wf4(:,5), wf12(:,21), A(:,40), n3(:,270), t3x48(:,:,40), nhel, den(3))
    call Hcont_SS(nsync, wf4(:,4), wf12(:,22), A(:,41), n3(:,271), t3x48(:,:,41), nhel, den(33))
    call Hcont_SS(nsync, wf4(:,4), wf12(:,23), A(:,42), n3(:,272), t3x48(:,:,42), nhel, den(6))
    call Hcont_QA(nsync, wf6(:,2), wf8(:,15), A(:,43), n3(:,273), t3x48(:,:,43), nhel, den(8))
    call Hcont_QA(nsync, wf6(:,2), wf8(:,16), A(:,44), n3(:,274), t3x48(:,:,44), nhel, den(8))
    call Hcont_QA(nsync, wf6(:,2), wf8(:,17), A(:,45), n3(:,275), t3x48(:,:,45), nhel, den(9))
    call Hcont_QA(nsync, wf6(:,2), wf8(:,18), A(:,46), n3(:,276), t3x48(:,:,46), nhel, den(9))
    call Hcont_QA(nsync, wf6(:,2), wf8(:,19), A(:,47), n3(:,277), t3x48(:,:,47), nhel, den(11))
    call Hcont_QA(nsync, wf6(:,2), wf8(:,20), A(:,48), n3(:,278), t3x48(:,:,48), nhel, den(11))
    call Hcont_QA(nsync, wf6(:,2), wf8(:,21), A(:,49), n3(:,279), t3x48(:,:,49), nhel, den(9))
    call Hcont_QA(nsync, wf6(:,2), wf8(:,22), A(:,50), n3(:,280), t3x48(:,:,50), nhel, den(9))
    call Hcont_QA(nsync, wf6(:,2), wf8(:,23), A(:,51), n3(:,281), t3x48(:,:,51), nhel, den(11))
    call Hcont_QA(nsync, wf8(:,5), wf6(:,10), A(:,52), n3(:,282), t3x48(:,:,52), nhel, den(13))
    call Hcont_QA(nsync, wf8(:,5), wf6(:,12), A(:,53), n3(:,283), t3x48(:,:,53), nhel, den(13))
    call Hcont_QA(nsync, wf8(:,6), wf6(:,10), A(:,54), n3(:,284), t3x48(:,:,54), nhel, den(14))
    call Hcont_QA(nsync, wf8(:,6), wf6(:,12), A(:,55), n3(:,285), t3x48(:,:,55), nhel, den(14))
    call Hcont_QA(nsync, wf8(:,7), wf6(:,10), A(:,56), n3(:,286), t3x48(:,:,56), nhel, den(15))
    call Hcont_QA(nsync, wf8(:,7), wf6(:,12), A(:,57), n3(:,287), t3x48(:,:,57), nhel, den(15))
    call Hcont_QA(nsync, wf8(:,8), wf6(:,10), A(:,58), n3(:,288), t3x48(:,:,58), nhel, den(14))
    call Hcont_QA(nsync, wf8(:,8), wf6(:,12), A(:,59), n3(:,289), t3x48(:,:,59), nhel, den(14))
    call Hcont_QA(nsync, wf8(:,7), wf6(:,12), A(:,60), n3(:,290), t3x48(:,:,60), nhel, den(15))
    call Hcont_QA(nsync, wf6(:,4), wf8(:,24), A(:,61), n3(:,291), t3x48(:,:,61), nhel, den(13))
    call Hcont_QA(nsync, wf6(:,4), wf8(:,25), A(:,62), n3(:,292), t3x48(:,:,62), nhel, den(13))
    call Hcont_QA(nsync, wf6(:,4), wf8(:,26), A(:,63), n3(:,293), t3x48(:,:,63), nhel, den(14))
    call Hcont_QA(nsync, wf6(:,4), wf8(:,27), A(:,64), n3(:,294), t3x48(:,:,64), nhel, den(14))
    call Hcont_QA(nsync, wf6(:,4), wf8(:,28), A(:,65), n3(:,295), t3x48(:,:,65), nhel, den(15))
    call Hcont_QA(nsync, wf6(:,4), wf8(:,29), A(:,66), n3(:,296), t3x48(:,:,66), nhel, den(15))
    call Hcont_QA(nsync, wf6(:,4), wf8(:,30), A(:,67), n3(:,297), t3x48(:,:,67), nhel, den(14))
    call Hcont_QA(nsync, wf6(:,4), wf8(:,31), A(:,68), n3(:,298), t3x48(:,:,68), nhel, den(14))
    call Hcont_QA(nsync, wf6(:,4), wf8(:,32), A(:,69), n3(:,299), t3x48(:,:,69), nhel, den(15))
    call Hcont_QA(nsync, wf8(:,1), wf6(:,14), A(:,70), n3(:,300), t3x48(:,:,70), nhel, den(8))
    call Hcont_QA(nsync, wf8(:,1), wf6(:,16), A(:,71), n3(:,301), t3x48(:,:,71), nhel, den(8))
    call Hcont_QA(nsync, wf8(:,2), wf6(:,14), A(:,72), n3(:,302), t3x48(:,:,72), nhel, den(9))
    call Hcont_QA(nsync, wf8(:,2), wf6(:,16), A(:,73), n3(:,303), t3x48(:,:,73), nhel, den(9))
    call Hcont_QA(nsync, wf8(:,3), wf6(:,14), A(:,74), n3(:,304), t3x48(:,:,74), nhel, den(11))
    call Hcont_QA(nsync, wf8(:,3), wf6(:,16), A(:,75), n3(:,305), t3x48(:,:,75), nhel, den(11))
    call Hcont_QA(nsync, wf8(:,4), wf6(:,14), A(:,76), n3(:,306), t3x48(:,:,76), nhel, den(9))
    call Hcont_QA(nsync, wf8(:,4), wf6(:,16), A(:,77), n3(:,307), t3x48(:,:,77), nhel, den(9))
    call Hcont_QA(nsync, wf8(:,3), wf6(:,16), A(:,78), n3(:,308), t3x48(:,:,78), nhel, den(11))
    call Hcont_SS(nsync, wf12(:,1), wf4(:,13), A(:,79), n3(:,309), t3x48(:,:,79), nhel, den(3))
    call Hcont_SS(nsync, wf12(:,1), wf4(:,14), A(:,80), n3(:,310), t3x48(:,:,80), nhel, den(3))
    call Hcont_SS(nsync, wf12(:,2), wf4(:,15), A(:,81), n3(:,311), t3x48(:,:,81), nhel, den(6))
    call Hcont_SS(nsync, wf12(:,2), wf4(:,16), A(:,82), n3(:,312), t3x48(:,:,82), nhel, den(6))
    call Hcont_VV(nsync, wf12(:,3), wf4(:,17), A(:,83), n3(:,313), t3x48(:,:,83), nhel, den(3))
    call Hcont_VV(nsync, wf12(:,3), wf4(:,18), A(:,84), n3(:,314), t3x48(:,:,84), nhel, den(3))
    call Hcont_SS(nsync, wf12(:,4), wf4(:,15), A(:,85), n3(:,315), t3x48(:,:,85), nhel, den(6))
    call Hcont_SS(nsync, wf12(:,4), wf4(:,16), A(:,86), n3(:,316), t3x48(:,:,86), nhel, den(6))
    call Hcont_SS(nsync, wf4(:,9), wf12(:,24), A(:,87), n3(:,317), t3x48(:,:,87), nhel, den(18))
    call Hcont_VV(nsync, wf4(:,10), wf12(:,25), A(:,88), n3(:,318), t3x48(:,:,88), nhel, den(18))
    call Hcont_SS(nsync, wf4(:,9), wf12(:,26), A(:,89), n3(:,319), t3x48(:,:,89), nhel, den(18))
    call Hcont_VV(nsync, wf4(:,10), wf12(:,27), A(:,90), n3(:,320), t3x48(:,:,90), nhel, den(18))
    call Hcont_SS(nsync, wf4(:,9), wf12(:,28), A(:,91), n3(:,321), t3x48(:,:,91), nhel, den(20))
    call Hcont_SS(nsync, wf4(:,9), wf12(:,29), A(:,92), n3(:,322), t3x48(:,:,92), nhel, den(20))
    call Hcont_VV(nsync, wf4(:,10), wf12(:,30), A(:,93), n3(:,323), t3x48(:,:,93), nhel, den(20))
    call Hcont_VV(nsync, wf4(:,10), wf12(:,30), A(:,94), n3(:,324), t3x48(:,:,94), nhel, den(20))
    call Hcont_QA(nsync, wf8(:,9), wf6(:,10), A(:,95), n3(:,325), t3x48(:,:,95), nhel, den(21))
    call Hcont_QA(nsync, wf8(:,9), wf6(:,12), A(:,96), n3(:,326), t3x48(:,:,96), nhel, den(21))
    call Hcont_QA(nsync, wf8(:,10), wf6(:,10), A(:,97), n3(:,327), t3x48(:,:,97), nhel, den(21))
    call Hcont_QA(nsync, wf8(:,10), wf6(:,12), A(:,98), n3(:,328), t3x48(:,:,98), nhel, den(21))
    call Hcont_QA(nsync, wf6(:,8), wf8(:,33), A(:,99), n3(:,329), t3x48(:,:,99), nhel, den(23))
    call Hcont_QA(nsync, wf6(:,8), wf8(:,34), A(:,100), n3(:,330), t3x48(:,:,100), nhel, den(23))
    call Hcont_QA(nsync, wf6(:,8), wf8(:,35), A(:,101), n3(:,331), t3x48(:,:,101), nhel, den(23))
    call Hcont_QA(nsync, wf6(:,8), wf8(:,35), A(:,102), n3(:,332), t3x48(:,:,102), nhel, den(23))
    call Hcont_QA(nsync, wf8(:,13), wf6(:,14), A(:,103), n3(:,333), t3x48(:,:,103), nhel, den(24))
    call Hcont_QA(nsync, wf8(:,13), wf6(:,16), A(:,104), n3(:,334), t3x48(:,:,104), nhel, den(24))
    call Hcont_QA(nsync, wf8(:,14), wf6(:,14), A(:,105), n3(:,335), t3x48(:,:,105), nhel, den(24))
    call Hcont_QA(nsync, wf8(:,14), wf6(:,16), A(:,106), n3(:,336), t3x48(:,:,106), nhel, den(24))
    call Hcont_SS(nsync, wf12(:,11), wf4(:,15), A(:,107), n3(:,337), t3x48(:,:,107), nhel, den(25))
    call Hcont_SS(nsync, wf12(:,11), wf4(:,16), A(:,108), n3(:,338), t3x48(:,:,108), nhel, den(25))
    call Hcont_SS(nsync, wf12(:,12), wf4(:,13), A(:,109), n3(:,339), t3x48(:,:,109), nhel, den(26))
    call Hcont_SS(nsync, wf12(:,12), wf4(:,14), A(:,110), n3(:,340), t3x48(:,:,110), nhel, den(26))
    call Hcont_VV(nsync, wf12(:,13), wf4(:,19), A(:,111), n3(:,341), t3x48(:,:,111), nhel, den(28))
    call Hcont_VV(nsync, wf12(:,13), wf4(:,20), A(:,112), n3(:,342), t3x48(:,:,112), nhel, den(28))
    call Hcont_VV(nsync, wf12(:,14), wf4(:,17), A(:,113), n3(:,343), t3x48(:,:,113), nhel, den(26))
    call Hcont_VV(nsync, wf12(:,14), wf4(:,18), A(:,114), n3(:,344), t3x48(:,:,114), nhel, den(26))
    call Hcont_VV(nsync, wf12(:,13), wf4(:,21), A(:,115), n3(:,345), t3x48(:,:,115), nhel, den(28))
    call Hcont_SS(nsync, wf12(:,15), wf4(:,15), A(:,116), n3(:,346), t3x48(:,:,116), nhel, den(29))
    call Hcont_SS(nsync, wf12(:,15), wf4(:,16), A(:,117), n3(:,347), t3x48(:,:,117), nhel, den(29))
    call Hcont_SS(nsync, wf12(:,16), wf4(:,13), A(:,118), n3(:,348), t3x48(:,:,118), nhel, den(30))
    call Hcont_SS(nsync, wf12(:,16), wf4(:,14), A(:,119), n3(:,349), t3x48(:,:,119), nhel, den(30))
    call Hcont_VV(nsync, wf12(:,17), wf4(:,19), A(:,120), n3(:,350), t3x48(:,:,120), nhel, den(31))
    call Hcont_VV(nsync, wf12(:,17), wf4(:,20), A(:,121), n3(:,351), t3x48(:,:,121), nhel, den(31))
    call Hcont_VV(nsync, wf12(:,18), wf4(:,17), A(:,122), n3(:,352), t3x48(:,:,122), nhel, den(30))
    call Hcont_VV(nsync, wf12(:,18), wf4(:,18), A(:,123), n3(:,353), t3x48(:,:,123), nhel, den(30))
    call Hcont_VV(nsync, wf12(:,17), wf4(:,21), A(:,124), n3(:,354), t3x48(:,:,124), nhel, den(31))
    call Hcont_QA(nsync, wf6(:,2), wf8(:,36), A(:,125), n3(:,355), t3x48(:,:,125), nhel, den(24))
    call Hcont_QA(nsync, wf6(:,2), wf8(:,37), A(:,126), n3(:,356), t3x48(:,:,126), nhel, den(24))
    call Hcont_QA(nsync, wf6(:,2), wf8(:,38), A(:,127), n3(:,357), t3x48(:,:,127), nhel, den(24))
    call Hcont_QA(nsync, wf6(:,2), wf8(:,38), A(:,128), n3(:,358), t3x48(:,:,128), nhel, den(24))
    call Hcont_QA(nsync, wf8(:,11), wf6(:,18), A(:,129), n3(:,359), t3x48(:,:,129), nhel, den(23))
    call Hcont_QA(nsync, wf8(:,11), wf6(:,20), A(:,130), n3(:,360), t3x48(:,:,130), nhel, den(23))
    call Hcont_QA(nsync, wf8(:,12), wf6(:,18), A(:,131), n3(:,361), t3x48(:,:,131), nhel, den(23))
    call Hcont_QA(nsync, wf8(:,12), wf6(:,20), A(:,132), n3(:,362), t3x48(:,:,132), nhel, den(23))
    call Hcont_SS(nsync, wf4(:,4), wf12(:,31), A(:,133), n3(:,363), t3x48(:,:,133), nhel, den(25))
    call Hcont_SS(nsync, wf4(:,4), wf12(:,32), A(:,134), n3(:,364), t3x48(:,:,134), nhel, den(25))
    call Hcont_SS(nsync, wf4(:,2), wf12(:,33), A(:,135), n3(:,365), t3x48(:,:,135), nhel, den(26))
    call Hcont_SS(nsync, wf4(:,2), wf12(:,34), A(:,136), n3(:,366), t3x48(:,:,136), nhel, den(26))
    call Hcont_VV(nsync, wf4(:,12), wf12(:,35), A(:,137), n3(:,367), t3x48(:,:,137), nhel, den(28))
    call Hcont_VV(nsync, wf4(:,12), wf12(:,36), A(:,138), n3(:,368), t3x48(:,:,138), nhel, den(28))
    call Hcont_VV(nsync, wf4(:,5), wf12(:,37), A(:,139), n3(:,369), t3x48(:,:,139), nhel, den(26))
    call Hcont_VV(nsync, wf4(:,5), wf12(:,38), A(:,140), n3(:,370), t3x48(:,:,140), nhel, den(26))
    call Hcont_VV(nsync, wf4(:,12), wf12(:,39), A(:,141), n3(:,371), t3x48(:,:,141), nhel, den(28))
    call Hcont_SS(nsync, wf4(:,4), wf12(:,40), A(:,142), n3(:,372), t3x48(:,:,142), nhel, den(29))
    call Hcont_SS(nsync, wf4(:,4), wf12(:,41), A(:,143), n3(:,373), t3x48(:,:,143), nhel, den(29))
    call Hcont_SS(nsync, wf4(:,2), wf12(:,42), A(:,144), n3(:,374), t3x48(:,:,144), nhel, den(30))
    call Hcont_SS(nsync, wf4(:,2), wf12(:,43), A(:,145), n3(:,375), t3x48(:,:,145), nhel, den(30))
    call Hcont_VV(nsync, wf4(:,12), wf12(:,44), A(:,146), n3(:,376), t3x48(:,:,146), nhel, den(31))
    call Hcont_VV(nsync, wf4(:,12), wf12(:,45), A(:,147), n3(:,377), t3x48(:,:,147), nhel, den(31))
    call Hcont_VV(nsync, wf4(:,5), wf12(:,46), A(:,148), n3(:,378), t3x48(:,:,148), nhel, den(30))
    call Hcont_VV(nsync, wf4(:,5), wf12(:,47), A(:,149), n3(:,379), t3x48(:,:,149), nhel, den(30))
    call Hcont_VV(nsync, wf4(:,12), wf12(:,45), A(:,150), n3(:,380), t3x48(:,:,150), nhel, den(31))
    call Hcont_SS(nsync, wf12(:,5), wf4(:,22), A(:,151), n3(:,381), t3x48(:,:,151), nhel, den(18))
    call Hcont_SS(nsync, wf12(:,5), wf4(:,23), A(:,152), n3(:,382), t3x48(:,:,152), nhel, den(18))
    call Hcont_VV(nsync, wf12(:,6), wf4(:,24), A(:,153), n3(:,383), t3x48(:,:,153), nhel, den(18))
    call Hcont_VV(nsync, wf12(:,6), wf4(:,24), A(:,154), n3(:,384), t3x48(:,:,154), nhel, den(18))
    call Hcont_SS(nsync, wf12(:,7), wf4(:,22), A(:,155), n3(:,385), t3x48(:,:,155), nhel, den(18))
    call Hcont_SS(nsync, wf12(:,7), wf4(:,23), A(:,156), n3(:,386), t3x48(:,:,156), nhel, den(18))
    call Hcont_VV(nsync, wf12(:,8), wf4(:,24), A(:,157), n3(:,387), t3x48(:,:,157), nhel, den(18))
    call Hcont_VV(nsync, wf12(:,8), wf4(:,24), A(:,158), n3(:,388), t3x48(:,:,158), nhel, den(18))
    call Hcont_SS(nsync, wf12(:,9), wf4(:,22), A(:,159), n3(:,389), t3x48(:,:,159), nhel, den(20))
    call Hcont_SS(nsync, wf12(:,9), wf4(:,23), A(:,160), n3(:,390), t3x48(:,:,160), nhel, den(20))
    call Hcont_VV(nsync, wf12(:,10), wf4(:,24), A(:,161), n3(:,391), t3x48(:,:,161), nhel, den(20))
    call Hcont_VV(nsync, wf12(:,10), wf4(:,24), A(:,162), n3(:,392), t3x48(:,:,162), nhel, den(20))
    call Hcont_QA(nsync, wf6(:,4), wf8(:,39), A(:,163), n3(:,393), t3x48(:,:,163), nhel, den(21))
    call Hcont_QA(nsync, wf6(:,4), wf8(:,40), A(:,164), n3(:,394), t3x48(:,:,164), nhel, den(21))
    call Hcont_QA(nsync, wf6(:,4), wf8(:,41), A(:,165), n3(:,395), t3x48(:,:,165), nhel, den(21))
    call Hcont_QA(nsync, wf6(:,4), wf8(:,41), A(:,166), n3(:,396), t3x48(:,:,166), nhel, den(21))
    call Hcont_QA(nsync, wf6(:,4), wf8(:,42), A(:,167), n3(:,397), t3x48(:,:,167), nhel, den(21))
    call Hcont_QA(nsync, wf6(:,4), wf8(:,43), A(:,168), n3(:,398), t3x48(:,:,168), nhel, den(21))
    call Hcont_QA(nsync, wf6(:,4), wf8(:,44), A(:,169), n3(:,399), t3x48(:,:,169), nhel, den(21))
    call Hcont_QA(nsync, wf6(:,4), wf8(:,44), A(:,170), n3(:,400), t3x48(:,:,170), nhel, den(21))
    call Hcont_SS(nsync, wf4(:,9), wf12(:,48), A(:,171), n3(:,401), t3x48(:,:,171), nhel, den(20))
    call Hcont_SS(nsync, wf4(:,9), wf12(:,49), A(:,172), n3(:,402), t3x48(:,:,172), nhel, den(20))
    call Hcont_VV(nsync, wf4(:,10), wf12(:,50), A(:,173), n3(:,403), t3x48(:,:,173), nhel, den(20))
    call Hcont_VV(nsync, wf4(:,10), wf12(:,51), A(:,174), n3(:,404), t3x48(:,:,174), nhel, den(20))
    call Hcont_SS(nsync, wf4(:,9), wf12(:,52), A(:,175), n3(:,405), t3x48(:,:,175), nhel, den(18))
    call Hcont_SS(nsync, wf4(:,9), wf12(:,53), A(:,176), n3(:,406), t3x48(:,:,176), nhel, den(18))
    call Hcont_VV(nsync, wf4(:,10), wf12(:,54), A(:,177), n3(:,407), t3x48(:,:,177), nhel, den(18))
    call Hcont_VV(nsync, wf4(:,10), wf12(:,55), A(:,178), n3(:,408), t3x48(:,:,178), nhel, den(18))
    call Hcont_SS(nsync, wf4(:,9), wf12(:,56), A(:,179), n3(:,409), t3x48(:,:,179), nhel, den(18))
    call Hcont_SS(nsync, wf4(:,9), wf12(:,56), A(:,180), n3(:,410), t3x48(:,:,180), nhel, den(18))
    call Hcont_VV(nsync, wf4(:,10), wf12(:,57), A(:,181), n3(:,411), t3x48(:,:,181), nhel, den(18))
    call Hcont_VV(nsync, wf4(:,10), wf12(:,57), A(:,182), n3(:,412), t3x48(:,:,182), nhel, den(18))
    call Hcont_SS(nsync, wf4(:,4), wf12(:,58), A(:,183), n3(:,413), t3x48(:,:,183), nhel, den(29))
    call Hcont_SS(nsync, wf4(:,4), wf12(:,59), A(:,184), n3(:,414), t3x48(:,:,184), nhel, den(29))
    call Hcont_SS(nsync, wf4(:,2), wf12(:,60), A(:,185), n3(:,415), t3x48(:,:,185), nhel, den(30))
    call Hcont_SS(nsync, wf4(:,2), wf12(:,61), A(:,186), n3(:,416), t3x48(:,:,186), nhel, den(30))
    call Hcont_VV(nsync, wf4(:,12), wf12(:,62), A(:,187), n3(:,417), t3x48(:,:,187), nhel, den(31))
    call Hcont_VV(nsync, wf4(:,12), wf12(:,63), A(:,188), n3(:,418), t3x48(:,:,188), nhel, den(31))
    call Hcont_VV(nsync, wf4(:,5), wf12(:,64), A(:,189), n3(:,419), t3x48(:,:,189), nhel, den(30))
    call Hcont_VV(nsync, wf4(:,5), wf12(:,65), A(:,190), n3(:,420), t3x48(:,:,190), nhel, den(30))
    call Hcont_VV(nsync, wf4(:,12), wf12(:,66), A(:,191), n3(:,421), t3x48(:,:,191), nhel, den(31))
    call Hcont_SS(nsync, wf4(:,4), wf12(:,67), A(:,192), n3(:,422), t3x48(:,:,192), nhel, den(25))
    call Hcont_SS(nsync, wf4(:,4), wf12(:,68), A(:,193), n3(:,423), t3x48(:,:,193), nhel, den(25))
    call Hcont_SS(nsync, wf4(:,2), wf12(:,69), A(:,194), n3(:,424), t3x48(:,:,194), nhel, den(26))
    call Hcont_SS(nsync, wf4(:,2), wf12(:,70), A(:,195), n3(:,425), t3x48(:,:,195), nhel, den(26))
    call Hcont_VV(nsync, wf4(:,12), wf12(:,71), A(:,196), n3(:,426), t3x48(:,:,196), nhel, den(28))
    call Hcont_VV(nsync, wf4(:,12), wf12(:,72), A(:,197), n3(:,427), t3x48(:,:,197), nhel, den(28))
    call Hcont_VV(nsync, wf4(:,5), wf12(:,73), A(:,198), n3(:,428), t3x48(:,:,198), nhel, den(26))
    call Hcont_VV(nsync, wf4(:,5), wf12(:,74), A(:,199), n3(:,429), t3x48(:,:,199), nhel, den(26))
    call Hcont_VV(nsync, wf4(:,12), wf12(:,72), A(:,200), n3(:,430), t3x48(:,:,200), nhel, den(28))
    call Hcont_QA(nsync, wf6(:,8), wf8(:,45), A(:,201), n3(:,431), t3x48(:,:,201), nhel, den(23))
    call Hcont_QA(nsync, wf6(:,8), wf8(:,46), A(:,202), n3(:,432), t3x48(:,:,202), nhel, den(23))
    call Hcont_QA(nsync, wf6(:,8), wf8(:,47), A(:,203), n3(:,433), t3x48(:,:,203), nhel, den(23))
    call Hcont_QA(nsync, wf6(:,8), wf8(:,47), A(:,204), n3(:,434), t3x48(:,:,204), nhel, den(23))
    call Hcont_QA(nsync, wf6(:,2), wf8(:,48), A(:,205), n3(:,435), t3x48(:,:,205), nhel, den(24))
    call Hcont_QA(nsync, wf6(:,2), wf8(:,49), A(:,206), n3(:,436), t3x48(:,:,206), nhel, den(24))
    call Hcont_QA(nsync, wf6(:,2), wf8(:,50), A(:,207), n3(:,437), t3x48(:,:,207), nhel, den(24))
    call Hcont_QA(nsync, wf6(:,2), wf8(:,50), A(:,208), n3(:,438), t3x48(:,:,208), nhel, den(24))
    call Hcont_SS(nsync, wf4(:,2), wf12(:,75), A(:,209), n3(:,439), t3x48(:,:,209), nhel, den(3))
    call Hcont_SS(nsync, wf4(:,2), wf12(:,76), A(:,210), n3(:,440), t3x48(:,:,210), nhel, den(3))
    call Hcont_SS(nsync, wf4(:,4), wf12(:,77), A(:,211), n3(:,441), t3x48(:,:,211), nhel, den(6))
    call Hcont_SS(nsync, wf4(:,4), wf12(:,78), A(:,212), n3(:,442), t3x48(:,:,212), nhel, den(6))
    call Hcont_VV(nsync, wf4(:,5), wf12(:,79), A(:,213), n3(:,443), t3x48(:,:,213), nhel, den(3))
    call Hcont_VV(nsync, wf4(:,5), wf12(:,80), A(:,214), n3(:,444), t3x48(:,:,214), nhel, den(3))
    call Hcont_SS(nsync, wf4(:,4), wf12(:,81), A(:,215), n3(:,445), t3x48(:,:,215), nhel, den(6))
    call Hcont_SS(nsync, wf4(:,4), wf12(:,82), A(:,216), n3(:,446), t3x48(:,:,216), nhel, den(6))
    call Hcont_QA(nsync, wf6(:,2), wf8(:,51), A(:,217), n3(:,447), t3x48(:,:,217), nhel, den(8))
    call Hcont_QA(nsync, wf6(:,2), wf8(:,52), A(:,218), n3(:,448), t3x48(:,:,218), nhel, den(8))
    call Hcont_QA(nsync, wf6(:,2), wf8(:,53), A(:,219), n3(:,449), t3x48(:,:,219), nhel, den(9))
    call Hcont_QA(nsync, wf6(:,2), wf8(:,54), A(:,220), n3(:,450), t3x48(:,:,220), nhel, den(9))
    call Hcont_QA(nsync, wf6(:,2), wf8(:,55), A(:,221), n3(:,451), t3x48(:,:,221), nhel, den(11))
    call Hcont_QA(nsync, wf6(:,2), wf8(:,56), A(:,222), n3(:,452), t3x48(:,:,222), nhel, den(11))
    call Hcont_QA(nsync, wf6(:,2), wf8(:,57), A(:,223), n3(:,453), t3x48(:,:,223), nhel, den(9))
    call Hcont_QA(nsync, wf6(:,2), wf8(:,58), A(:,224), n3(:,454), t3x48(:,:,224), nhel, den(9))
    call Hcont_QA(nsync, wf6(:,2), wf8(:,59), A(:,225), n3(:,455), t3x48(:,:,225), nhel, den(11))
    call Hcont_QA(nsync, wf6(:,4), wf8(:,60), A(:,226), n3(:,456), t3x48(:,:,226), nhel, den(13))
    call Hcont_QA(nsync, wf6(:,4), wf8(:,61), A(:,227), n3(:,457), t3x48(:,:,227), nhel, den(13))
    call Hcont_QA(nsync, wf6(:,4), wf8(:,62), A(:,228), n3(:,458), t3x48(:,:,228), nhel, den(14))
    call Hcont_QA(nsync, wf6(:,4), wf8(:,63), A(:,229), n3(:,459), t3x48(:,:,229), nhel, den(14))
    call Hcont_QA(nsync, wf6(:,4), wf8(:,64), A(:,230), n3(:,460), t3x48(:,:,230), nhel, den(15))
    call Hcont_QA(nsync, wf6(:,4), wf8(:,65), A(:,231), n3(:,461), t3x48(:,:,231), nhel, den(15))
    call Hcont_QA(nsync, wf6(:,4), wf8(:,66), A(:,232), n3(:,462), t3x48(:,:,232), nhel, den(14))
    call Hcont_QA(nsync, wf6(:,4), wf8(:,67), A(:,233), n3(:,463), t3x48(:,:,233), nhel, den(14))
    call Hcont_QA(nsync, wf6(:,4), wf8(:,68), A(:,234), n3(:,464), t3x48(:,:,234), nhel, den(15))
    call Hcont_SS(nsync, wf12(:,83), wf4(:,37), A(:,235), n3(:,465), t3x48(:,:,235), nhel, den(36))
    call Hcont_SS(nsync, wf12(:,84), wf4(:,38), A(:,236), n3(:,466), t3x48(:,:,236), nhel, den(39))
    call Hcont_SS(nsync, wf4(:,37), wf12(:,85), A(:,237), n3(:,467), t3x48(:,:,237), nhel, den(36))
    call Hcont_VV(nsync, wf12(:,86), wf4(:,39), A(:,238), n3(:,468), t3x48(:,:,238), nhel, den(39))
    call Hcont_SS(nsync, wf12(:,84), wf4(:,40), A(:,239), n3(:,469), t3x48(:,:,239), nhel, den(40))
    call Hcont_SS(nsync, wf12(:,84), wf4(:,41), A(:,240), n3(:,470), t3x48(:,:,240), nhel, den(39))
    call Hcont_VV(nsync, wf12(:,86), wf4(:,42), A(:,241), n3(:,471), t3x48(:,:,241), nhel, den(40))
    call Hcont_VV(nsync, wf12(:,86), wf4(:,43), A(:,242), n3(:,472), t3x48(:,:,242), nhel, den(39))
    call Hcont_SS(nsync, wf12(:,2), wf4(:,44), A(:,243), n3(:,473), t3x48(:,:,243), nhel, den(43))
    call Hcont_SS(nsync, wf12(:,1), wf4(:,45), A(:,244), n3(:,474), t3x48(:,:,244), nhel, den(46))
    call Hcont_SS(nsync, wf12(:,4), wf4(:,44), A(:,245), n3(:,475), t3x48(:,:,245), nhel, den(43))
    call Hcont_VV(nsync, wf12(:,3), wf4(:,46), A(:,246), n3(:,476), t3x48(:,:,246), nhel, den(46))
    call Hcont_SS(nsync, wf12(:,1), wf4(:,47), A(:,247), n3(:,477), t3x48(:,:,247), nhel, den(47))
    call Hcont_SS(nsync, wf12(:,1), wf4(:,48), A(:,248), n3(:,478), t3x48(:,:,248), nhel, den(46))
    call Hcont_VV(nsync, wf12(:,3), wf4(:,49), A(:,249), n3(:,479), t3x48(:,:,249), nhel, den(47))
    call Hcont_VV(nsync, wf12(:,3), wf4(:,50), A(:,250), n3(:,480), t3x48(:,:,250), nhel, den(46))
    call Hcont_SS(nsync, wf4(:,37), wf12(:,87), A(:,251), n3(:,481), t3x48(:,:,251), nhel, den(49))
    call Hcont_SS(nsync, wf4(:,38), wf12(:,88), A(:,252), n3(:,482), t3x48(:,:,252), nhel, den(51))
    call Hcont_VV(nsync, wf12(:,89), wf4(:,51), A(:,253), n3(:,483), t3x48(:,:,253), nhel, den(54))
    call Hcont_VV(nsync, wf4(:,39), wf12(:,90), A(:,254), n3(:,484), t3x48(:,:,254), nhel, den(51))
    call Hcont_SS(nsync, wf4(:,40), wf12(:,88), A(:,255), n3(:,485), t3x48(:,:,255), nhel, den(55))
    call Hcont_SS(nsync, wf4(:,41), wf12(:,88), A(:,256), n3(:,486), t3x48(:,:,256), nhel, den(51))
    call Hcont_VV(nsync, wf12(:,89), wf4(:,52), A(:,257), n3(:,487), t3x48(:,:,257), nhel, den(56))
    call Hcont_VV(nsync, wf4(:,42), wf12(:,90), A(:,258), n3(:,488), t3x48(:,:,258), nhel, den(55))
    call Hcont_VV(nsync, wf12(:,89), wf4(:,53), A(:,259), n3(:,489), t3x48(:,:,259), nhel, den(54))
    call Hcont_VV(nsync, wf4(:,43), wf12(:,90), A(:,260), n3(:,490), t3x48(:,:,260), nhel, den(51))
    call Hcont_QA(nsync, wf6(:,25), wf8(:,69), A(:,261), n3(:,491), t3x48(:,:,261), nhel, den(59))
    call Hcont_QA(nsync, wf8(:,69), wf6(:,26), A(:,262), n3(:,492), t3x48(:,:,262), nhel, den(59))
    call Hcont_QA(nsync, wf6(:,25), wf8(:,70), A(:,263), n3(:,493), t3x48(:,:,263), nhel, den(61))
    call Hcont_QA(nsync, wf6(:,26), wf8(:,70), A(:,264), n3(:,494), t3x48(:,:,264), nhel, den(61))
    call Hcont_QA(nsync, wf6(:,25), wf8(:,71), A(:,265), n3(:,495), t3x48(:,:,265), nhel, den(63))
    call Hcont_QA(nsync, wf6(:,26), wf8(:,71), A(:,266), n3(:,496), t3x48(:,:,266), nhel, den(63))
    call Hcont_QA(nsync, wf6(:,25), wf8(:,72), A(:,267), n3(:,497), t3x48(:,:,267), nhel, den(61))
    call Hcont_QA(nsync, wf6(:,26), wf8(:,72), A(:,268), n3(:,498), t3x48(:,:,268), nhel, den(61))
    call Hcont_QA(nsync, wf6(:,26), wf8(:,71), A(:,269), n3(:,499), t3x48(:,:,269), nhel, den(63))
    call Hcont_SS(nsync, wf4(:,37), wf12(:,91), A(:,270), n3(:,500), t3x48(:,:,270), nhel, den(65))
    call Hcont_SS(nsync, wf4(:,38), wf12(:,92), A(:,271), n3(:,501), t3x48(:,:,271), nhel, den(67))
    call Hcont_VV(nsync, wf4(:,51), wf12(:,93), A(:,272), n3(:,502), t3x48(:,:,272), nhel, den(69))
    call Hcont_VV(nsync, wf4(:,39), wf12(:,94), A(:,273), n3(:,503), t3x48(:,:,273), nhel, den(67))
    call Hcont_SS(nsync, wf4(:,40), wf12(:,92), A(:,274), n3(:,504), t3x48(:,:,274), nhel, den(70))
    call Hcont_SS(nsync, wf4(:,41), wf12(:,92), A(:,275), n3(:,505), t3x48(:,:,275), nhel, den(67))
    call Hcont_VV(nsync, wf4(:,52), wf12(:,93), A(:,276), n3(:,506), t3x48(:,:,276), nhel, den(71))
    call Hcont_VV(nsync, wf4(:,42), wf12(:,94), A(:,277), n3(:,507), t3x48(:,:,277), nhel, den(70))
    call Hcont_VV(nsync, wf4(:,53), wf12(:,93), A(:,278), n3(:,508), t3x48(:,:,278), nhel, den(69))
    call Hcont_VV(nsync, wf4(:,43), wf12(:,94), A(:,279), n3(:,509), t3x48(:,:,279), nhel, den(67))
    call Hcont_QA(nsync, wf6(:,27), wf8(:,73), A(:,280), n3(:,510), t3x48(:,:,280), nhel, den(74))
    call Hcont_QA(nsync, wf8(:,73), wf6(:,28), A(:,281), n3(:,511), t3x48(:,:,281), nhel, den(74))
    call Hcont_QA(nsync, wf6(:,27), wf8(:,74), A(:,282), n3(:,512), t3x48(:,:,282), nhel, den(76))
    call Hcont_QA(nsync, wf6(:,28), wf8(:,74), A(:,283), n3(:,513), t3x48(:,:,283), nhel, den(76))
    call Hcont_QA(nsync, wf6(:,27), wf8(:,75), A(:,284), n3(:,514), t3x48(:,:,284), nhel, den(78))
    call Hcont_QA(nsync, wf6(:,28), wf8(:,75), A(:,285), n3(:,515), t3x48(:,:,285), nhel, den(78))
    call Hcont_QA(nsync, wf6(:,27), wf8(:,76), A(:,286), n3(:,516), t3x48(:,:,286), nhel, den(76))
    call Hcont_QA(nsync, wf6(:,28), wf8(:,76), A(:,287), n3(:,517), t3x48(:,:,287), nhel, den(76))
    call Hcont_QA(nsync, wf6(:,28), wf8(:,75), A(:,288), n3(:,518), t3x48(:,:,288), nhel, den(78))
    call Hcont_SS(nsync, wf12(:,95), wf4(:,54), A(:,289), n3(:,519), t3x48(:,:,289), nhel, den(81))
    call Hcont_SS(nsync, wf4(:,54), wf12(:,96), A(:,290), n3(:,520), t3x48(:,:,290), nhel, den(81))
    call Hcont_VV(nsync, wf12(:,97), wf4(:,55), A(:,291), n3(:,521), t3x48(:,:,291), nhel, den(81))
    call Hcont_VV(nsync, wf4(:,55), wf12(:,98), A(:,292), n3(:,522), t3x48(:,:,292), nhel, den(81))
    call Hcont_SS(nsync, wf12(:,95), wf4(:,56), A(:,293), n3(:,523), t3x48(:,:,293), nhel, den(81))
    call Hcont_SS(nsync, wf12(:,96), wf4(:,56), A(:,294), n3(:,524), t3x48(:,:,294), nhel, den(81))
    call Hcont_VV(nsync, wf12(:,97), wf4(:,57), A(:,295), n3(:,525), t3x48(:,:,295), nhel, den(81))
    call Hcont_VV(nsync, wf12(:,98), wf4(:,57), A(:,296), n3(:,526), t3x48(:,:,296), nhel, den(81))
    call Hcont_SS(nsync, wf12(:,5), wf4(:,58), A(:,297), n3(:,527), t3x48(:,:,297), nhel, den(84))
    call Hcont_SS(nsync, wf12(:,7), wf4(:,58), A(:,298), n3(:,528), t3x48(:,:,298), nhel, den(84))
    call Hcont_VV(nsync, wf12(:,6), wf4(:,59), A(:,299), n3(:,529), t3x48(:,:,299), nhel, den(84))
    call Hcont_VV(nsync, wf12(:,8), wf4(:,59), A(:,300), n3(:,530), t3x48(:,:,300), nhel, den(84))
    call Hcont_SS(nsync, wf12(:,5), wf4(:,60), A(:,301), n3(:,531), t3x48(:,:,301), nhel, den(84))
    call Hcont_SS(nsync, wf12(:,7), wf4(:,60), A(:,302), n3(:,532), t3x48(:,:,302), nhel, den(84))
    call Hcont_VV(nsync, wf12(:,6), wf4(:,61), A(:,303), n3(:,533), t3x48(:,:,303), nhel, den(84))
    call Hcont_VV(nsync, wf12(:,8), wf4(:,61), A(:,304), n3(:,534), t3x48(:,:,304), nhel, den(84))
    call Hcont_QA(nsync, wf6(:,29), wf8(:,78), A(:,305), n3(:,535), t3x48(:,:,305), nhel, den(87))
    call Hcont_QA(nsync, wf8(:,78), wf6(:,30), A(:,306), n3(:,536), t3x48(:,:,306), nhel, den(87))
    call Hcont_QA(nsync, wf6(:,29), wf8(:,80), A(:,307), n3(:,537), t3x48(:,:,307), nhel, den(87))
    call Hcont_QA(nsync, wf6(:,30), wf8(:,80), A(:,308), n3(:,538), t3x48(:,:,308), nhel, den(87))
    call Hcont_SS(nsync, wf12(:,9), wf4(:,58), A(:,309), n3(:,539), t3x48(:,:,309), nhel, den(89))
    call Hcont_VV(nsync, wf12(:,10), wf4(:,59), A(:,310), n3(:,540), t3x48(:,:,310), nhel, den(89))
    call Hcont_SS(nsync, wf12(:,9), wf4(:,60), A(:,311), n3(:,541), t3x48(:,:,311), nhel, den(89))
    call Hcont_VV(nsync, wf12(:,10), wf4(:,61), A(:,312), n3(:,542), t3x48(:,:,312), nhel, den(89))
    call Hcont_SS(nsync, wf4(:,58), wf12(:,99), A(:,313), n3(:,543), t3x48(:,:,313), nhel, den(91))
    call Hcont_SS(nsync, wf4(:,60), wf12(:,99), A(:,314), n3(:,544), t3x48(:,:,314), nhel, den(91))
    call Hcont_VV(nsync, wf4(:,59), wf12(:,100), A(:,315), n3(:,545), t3x48(:,:,315), nhel, den(91))
    call Hcont_VV(nsync, wf4(:,61), wf12(:,100), A(:,316), n3(:,546), t3x48(:,:,316), nhel, den(91))
    call Hcont_QA(nsync, wf6(:,27), wf8(:,81), A(:,317), n3(:,547), t3x48(:,:,317), nhel, den(93))
    call Hcont_QA(nsync, wf6(:,28), wf8(:,81), A(:,318), n3(:,548), t3x48(:,:,318), nhel, den(93))
    call Hcont_QA(nsync, wf6(:,27), wf8(:,82), A(:,319), n3(:,549), t3x48(:,:,319), nhel, den(93))
    call Hcont_QA(nsync, wf6(:,28), wf8(:,82), A(:,320), n3(:,550), t3x48(:,:,320), nhel, den(93))
    call Hcont_SS(nsync, wf4(:,54), wf12(:,101), A(:,321), n3(:,551), t3x48(:,:,321), nhel, den(95))
    call Hcont_VV(nsync, wf4(:,55), wf12(:,102), A(:,322), n3(:,552), t3x48(:,:,322), nhel, den(95))
    call Hcont_SS(nsync, wf4(:,56), wf12(:,101), A(:,323), n3(:,553), t3x48(:,:,323), nhel, den(95))
    call Hcont_VV(nsync, wf4(:,57), wf12(:,102), A(:,324), n3(:,554), t3x48(:,:,324), nhel, den(95))
    call Hcont_QA(nsync, wf6(:,31), wf8(:,83), A(:,325), n3(:,555), t3x48(:,:,325), nhel, den(98))
    call Hcont_QA(nsync, wf8(:,83), wf6(:,32), A(:,326), n3(:,556), t3x48(:,:,326), nhel, den(98))
    call Hcont_QA(nsync, wf6(:,31), wf8(:,84), A(:,327), n3(:,557), t3x48(:,:,327), nhel, den(98))
    call Hcont_QA(nsync, wf6(:,32), wf8(:,84), A(:,328), n3(:,558), t3x48(:,:,328), nhel, den(98))
    call Hcont_SS(nsync, wf4(:,54), wf12(:,103), A(:,329), n3(:,559), t3x48(:,:,329), nhel, den(100))
    call Hcont_VV(nsync, wf4(:,55), wf12(:,104), A(:,330), n3(:,560), t3x48(:,:,330), nhel, den(100))
    call Hcont_SS(nsync, wf4(:,56), wf12(:,103), A(:,331), n3(:,561), t3x48(:,:,331), nhel, den(100))
    call Hcont_VV(nsync, wf4(:,57), wf12(:,104), A(:,332), n3(:,562), t3x48(:,:,332), nhel, den(100))
    call Hcont_QA(nsync, wf6(:,25), wf8(:,85), A(:,333), n3(:,563), t3x48(:,:,333), nhel, den(102))
    call Hcont_QA(nsync, wf6(:,26), wf8(:,85), A(:,334), n3(:,564), t3x48(:,:,334), nhel, den(102))
    call Hcont_QA(nsync, wf6(:,25), wf8(:,86), A(:,335), n3(:,565), t3x48(:,:,335), nhel, den(102))
    call Hcont_QA(nsync, wf6(:,26), wf8(:,86), A(:,336), n3(:,566), t3x48(:,:,336), nhel, den(102))
    call Hcont_QA(nsync, wf6(:,29), wf8(:,88), A(:,337), n3(:,567), t3x48(:,:,337), nhel, den(104))
    call Hcont_QA(nsync, wf6(:,30), wf8(:,88), A(:,338), n3(:,568), t3x48(:,:,338), nhel, den(104))
    call Hcont_QA(nsync, wf6(:,29), wf8(:,90), A(:,339), n3(:,569), t3x48(:,:,339), nhel, den(106))
    call Hcont_QA(nsync, wf6(:,30), wf8(:,90), A(:,340), n3(:,570), t3x48(:,:,340), nhel, den(106))
    call Hcont_QA(nsync, wf6(:,29), wf8(:,92), A(:,341), n3(:,571), t3x48(:,:,341), nhel, den(108))
    call Hcont_QA(nsync, wf6(:,30), wf8(:,92), A(:,342), n3(:,572), t3x48(:,:,342), nhel, den(108))
    call Hcont_QA(nsync, wf6(:,29), wf8(:,94), A(:,343), n3(:,573), t3x48(:,:,343), nhel, den(106))
    call Hcont_QA(nsync, wf6(:,30), wf8(:,94), A(:,344), n3(:,574), t3x48(:,:,344), nhel, den(106))
    call Hcont_QA(nsync, wf6(:,30), wf8(:,92), A(:,345), n3(:,575), t3x48(:,:,345), nhel, den(108))
    call Hcont_SS(nsync, wf12(:,11), wf4(:,44), A(:,346), n3(:,576), t3x48(:,:,346), nhel, den(110))
    call Hcont_SS(nsync, wf12(:,12), wf4(:,45), A(:,347), n3(:,577), t3x48(:,:,347), nhel, den(112))
    call Hcont_SS(nsync, wf12(:,12), wf4(:,47), A(:,348), n3(:,578), t3x48(:,:,348), nhel, den(113))
    call Hcont_SS(nsync, wf12(:,12), wf4(:,48), A(:,349), n3(:,579), t3x48(:,:,349), nhel, den(112))
    call Hcont_VV(nsync, wf12(:,13), wf4(:,62), A(:,350), n3(:,580), t3x48(:,:,350), nhel, den(116))
    call Hcont_VV(nsync, wf12(:,14), wf4(:,46), A(:,351), n3(:,581), t3x48(:,:,351), nhel, den(112))
    call Hcont_VV(nsync, wf12(:,13), wf4(:,63), A(:,352), n3(:,582), t3x48(:,:,352), nhel, den(117))
    call Hcont_VV(nsync, wf12(:,13), wf4(:,64), A(:,353), n3(:,583), t3x48(:,:,353), nhel, den(116))
    call Hcont_VV(nsync, wf12(:,14), wf4(:,49), A(:,354), n3(:,584), t3x48(:,:,354), nhel, den(113))
    call Hcont_VV(nsync, wf12(:,14), wf4(:,50), A(:,355), n3(:,585), t3x48(:,:,355), nhel, den(112))
    call Hcont_QA(nsync, wf6(:,31), wf8(:,96), A(:,356), n3(:,586), t3x48(:,:,356), nhel, den(119))
    call Hcont_QA(nsync, wf6(:,32), wf8(:,96), A(:,357), n3(:,587), t3x48(:,:,357), nhel, den(119))
    call Hcont_QA(nsync, wf6(:,31), wf8(:,98), A(:,358), n3(:,588), t3x48(:,:,358), nhel, den(121))
    call Hcont_QA(nsync, wf6(:,32), wf8(:,98), A(:,359), n3(:,589), t3x48(:,:,359), nhel, den(121))
    call Hcont_QA(nsync, wf6(:,31), wf8(:,100), A(:,360), n3(:,590), t3x48(:,:,360), nhel, den(123))
    call Hcont_QA(nsync, wf6(:,32), wf8(:,100), A(:,361), n3(:,591), t3x48(:,:,361), nhel, den(123))
    call Hcont_QA(nsync, wf6(:,31), wf8(:,102), A(:,362), n3(:,592), t3x48(:,:,362), nhel, den(121))
    call Hcont_QA(nsync, wf6(:,32), wf8(:,102), A(:,363), n3(:,593), t3x48(:,:,363), nhel, den(121))
    call Hcont_QA(nsync, wf6(:,32), wf8(:,100), A(:,364), n3(:,594), t3x48(:,:,364), nhel, den(123))
    call Hcont_SS(nsync, wf12(:,15), wf4(:,44), A(:,365), n3(:,595), t3x48(:,:,365), nhel, den(125))
    call Hcont_SS(nsync, wf12(:,16), wf4(:,45), A(:,366), n3(:,596), t3x48(:,:,366), nhel, den(127))
    call Hcont_SS(nsync, wf12(:,16), wf4(:,47), A(:,367), n3(:,597), t3x48(:,:,367), nhel, den(128))
    call Hcont_SS(nsync, wf12(:,16), wf4(:,48), A(:,368), n3(:,598), t3x48(:,:,368), nhel, den(127))
    call Hcont_VV(nsync, wf12(:,17), wf4(:,62), A(:,369), n3(:,599), t3x48(:,:,369), nhel, den(130))
    call Hcont_VV(nsync, wf12(:,18), wf4(:,46), A(:,370), n3(:,600), t3x48(:,:,370), nhel, den(127))
    call Hcont_VV(nsync, wf12(:,17), wf4(:,63), A(:,371), n3(:,601), t3x48(:,:,371), nhel, den(131))
    call Hcont_VV(nsync, wf12(:,17), wf4(:,64), A(:,372), n3(:,602), t3x48(:,:,372), nhel, den(130))
    call Hcont_VV(nsync, wf12(:,18), wf4(:,49), A(:,373), n3(:,603), t3x48(:,:,373), nhel, den(128))
    call Hcont_VV(nsync, wf12(:,18), wf4(:,50), A(:,374), n3(:,604), t3x48(:,:,374), nhel, den(127))

end subroutine diagrams


elemental function diagmap(j, n)
  implicit none
  integer, intent(in) :: j, n
  complex(REALKIND) :: diagmap
  diagmap = A(j,n)%j
end function diagmap

function diagsum(j, pos, neg)
  implicit none
  integer, intent(in) :: j, pos(:), neg(:)
  complex(REALKIND) :: diagsum
  diagsum = sum(diagmap(j, pos)) - sum(diagmap(j, neg))
end function diagsum

subroutine colourvectors(A, j, M1, M2)
  implicit none
  type(Hpolcont) :: A(:,:)
  integer, intent(in) :: j
  type(Hpolcont), intent(out) :: M1(4), M2(4) ! M1helarray(4,48)
  integer :: empty(0), i

  M1(1)%j = -(A(j,15)%j*f(16))+A(j,18)%j*f(20)+(A(j,20)%j+A(j,22)%j+A(j,24)%j+A(j,26)%j)*f(31)+(A(j,19)%j+A(j,21)%j+A(j,23)%j &
       +A(j,25)%j)*f(50)+(A(j,16)%j-A(j,17)%j)*f(72)
  M1(2)%j = ((-A(j,9)%j-A(j,14)%j-A(j,31)%j-A(j,36)%j)*f(7))/2._/**/REALKIND
  M1(3)%j = (A(j,7)%j+A(j,12)%j+A(j,29)%j+A(j,34)%j)*f(1)+(-A(j,8)%j-A(j,13)%j-A(j,30)%j-A(j,35)%j)*f(2)+(-A(j,1)%j &
       +A(j,2)%j)*f(25)+A(j,4)%j*f(40)+A(j,3)%j*f(45)+(A(j,5)%j+A(j,6)%j+A(j,10)%j+A(j,11)%j+A(j,27)%j+A(j,28)%j+A(j,32)%j &
       +A(j,33)%j)*f(56)
  M1(4)%j = ((A(j,9)%j+A(j,14)%j+A(j,31)%j+A(j,36)%j)*f(7))/6._/**/REALKIND

  M2(1)%j = (-A(j,156)%j-A(j,178)%j)*f(14)+(A(j,152)%j-A(j,176)%j)*f(15)+(A(j,289)%j+A(j,297)%j)*f(17)+(A(j,293)%j &
       -A(j,301)%j)*f(19)+(-A(j,296)%j-A(j,304)%j)*f(21)+A(j,182)%j*f(22)+A(j,158)%j*f(23)+(A(j,292)%j-A(j,300)%j)*f(29) &
       +(A(j,98)%j+A(j,106)%j+A(j,132)%j+A(j,174)%j-A(j,308)%j-A(j,312)%j-A(j,316)%j-A(j,320)%j-A(j,324)%j-A(j,328)%j-A(j,332)%j &
       -A(j,336)%j)*f(32)+(A(j,94)%j+A(j,170)%j+A(j,204)%j+A(j,208)%j)*f(33)+(A(j,102)%j+A(j,128)%j+A(j,162)%j+A(j,166)%j)*f(34) &
       -A(j,90)%j*f(35)+(A(j,96)%j+A(j,104)%j+A(j,130)%j+A(j,172)%j-A(j,306)%j-A(j,309)%j-A(j,313)%j-A(j,318)%j-A(j,321)%j &
       -A(j,326)%j-A(j,329)%j-A(j,334)%j)*f(51)+A(j,87)%j*f(52)+(-A(j,310)%j+A(j,311)%j+A(j,314)%j-A(j,315)%j+A(j,322)%j &
       -A(j,323)%j+A(j,330)%j-A(j,331)%j)*f(66)+(-A(j,88)%j+A(j,89)%j)*f(67)+(-A(j,290)%j+A(j,295)%j+A(j,298)%j-A(j,303)%j)*f(73) &
       -A(j,180)%j*f(74)+A(j,154)%j*f(75)+(-A(j,291)%j-A(j,299)%j)*f(82)+(-A(j,294)%j-A(j,302)%j)*f(91)+(-A(j,92)%j+A(j,100)%j &
       +A(j,126)%j+A(j,160)%j+A(j,164)%j-A(j,168)%j-A(j,202)%j-A(j,206)%j)*f(92)
  M2(2)%j = ((-A(j,51)%j-A(j,60)%j-A(j,69)%j-A(j,78)%j-A(j,115)%j-A(j,124)%j-A(j,141)%j-A(j,150)%j-A(j,191)%j-A(j,200)%j &
       -A(j,225)%j-A(j,234)%j+A(j,269)%j+A(j,288)%j+A(j,345)%j+A(j,364)%j)*f(9))/2._/**/REALKIND+(-A(j,151)%j-A(j,175)%j)*f(18) &
       +(A(j,157)%j+A(j,181)%j)*f(24)+(-A(j,307)%j-A(j,319)%j-A(j,327)%j-A(j,335)%j)*f(36)+(A(j,97)%j+A(j,105)%j)*f(37)+(A(j,93)%j &
       +A(j,101)%j+A(j,127)%j+A(j,161)%j+A(j,165)%j+A(j,169)%j+A(j,203)%j+A(j,207)%j)*f(38)+(A(j,131)%j+A(j,173)%j)*f(39) &
       +(A(j,91)%j+A(j,99)%j+A(j,125)%j+A(j,159)%j+A(j,163)%j+A(j,167)%j+A(j,201)%j+A(j,205)%j-A(j,305)%j-A(j,317)%j-A(j,325)%j &
       -A(j,333)%j)*f(53)+(A(j,95)%j+A(j,103)%j)*f(54)+(A(j,129)%j+A(j,171)%j)*f(55)+(-A(j,155)%j+A(j,177)%j)*f(76)+(A(j,153)%j &
       -A(j,179)%j)*f(77)
  M2(3)%j = (-A(j,265)%j-A(j,284)%j-A(j,341)%j-A(j,360)%j)*f(8)+(A(j,267)%j+A(j,286)%j+A(j,343)%j+A(j,362)%j)*f(9)+((A(j,51)%j &
       +A(j,60)%j+A(j,69)%j+A(j,78)%j+A(j,115)%j+A(j,124)%j+A(j,141)%j+A(j,150)%j+A(j,191)%j+A(j,200)%j+A(j,225)%j+A(j,234)%j &
       -A(j,269)%j-A(j,288)%j-A(j,345)%j-A(j,364)%j)*f(9))/6._/**/REALKIND+(A(j,47)%j+A(j,56)%j+A(j,65)%j+A(j,74)%j+A(j,111)%j &
       +A(j,120)%j)*f(10)+(-A(j,49)%j-A(j,58)%j-A(j,67)%j-A(j,76)%j-A(j,113)%j-A(j,122)%j)*f(11)+(A(j,137)%j+A(j,146)%j+A(j,187)%j &
       +A(j,196)%j+A(j,221)%j+A(j,230)%j)*f(12)+(-A(j,139)%j-A(j,148)%j-A(j,189)%j-A(j,198)%j-A(j,223)%j-A(j,232)%j)*f(13)+( &
       -A(j,79)%j+A(j,81)%j)*f(27)+(-A(j,209)%j+A(j,211)%j)*f(28)+A(j,85)%j*f(43)+A(j,215)%j*f(44)+A(j,213)%j*f(48) &
       +A(j,83)%j*f(49)+(-A(j,261)%j-A(j,263)%j-A(j,280)%j-A(j,282)%j-A(j,337)%j-A(j,339)%j-A(j,356)%j-A(j,358)%j)*f(61) &
       +(A(j,43)%j+A(j,45)%j+A(j,61)%j+A(j,63)%j+A(j,107)%j+A(j,109)%j+A(j,116)%j+A(j,118)%j)*f(62)+(A(j,133)%j+A(j,135)%j &
       +A(j,183)%j+A(j,185)%j+A(j,217)%j+A(j,219)%j+A(j,226)%j+A(j,228)%j)*f(63)+(A(j,52)%j+A(j,54)%j+A(j,70)%j+A(j,72)%j)*f(64) &
       +(A(j,142)%j+A(j,144)%j+A(j,192)%j+A(j,194)%j)*f(65)
  M2(4)%j = (A(j,57)%j+A(j,75)%j+A(j,147)%j+A(j,197)%j-A(j,257)%j-A(j,266)%j-A(j,276)%j-A(j,285)%j-A(j,342)%j-A(j,352)%j &
       -A(j,361)%j-A(j,371)%j)*f(3)+(-A(j,138)%j-A(j,188)%j-A(j,222)%j-A(j,231)%j+A(j,259)%j+A(j,278)%j+A(j,354)%j &
       +A(j,373)%j)*f(4)+(A(j,48)%j+A(j,66)%j+A(j,112)%j+A(j,121)%j-A(j,258)%j-A(j,277)%j-A(j,353)%j-A(j,372)%j)*f(5)+(-A(j,50)%j &
       -A(j,59)%j-A(j,68)%j-A(j,77)%j-A(j,114)%j-A(j,123)%j-A(j,140)%j-A(j,149)%j-A(j,190)%j-A(j,199)%j-A(j,224)%j-A(j,233)%j &
       +A(j,260)%j+A(j,268)%j+A(j,279)%j+A(j,287)%j+A(j,344)%j+A(j,355)%j+A(j,363)%j+A(j,374)%j)*f(6)+(A(j,235)%j-A(j,236)%j &
       -A(j,243)%j+A(j,244)%j)*f(26)+(-A(j,238)%j+A(j,246)%j)*f(30)+A(j,241)%j*f(41)+(A(j,216)%j-A(j,242)%j-A(j,245)%j)*f(42) &
       -A(j,249)%j*f(46)+(A(j,84)%j-A(j,237)%j-A(j,250)%j)*f(47)+(A(j,53)%j+A(j,55)%j+A(j,71)%j+A(j,73)%j+A(j,143)%j+A(j,145)%j &
       +A(j,193)%j+A(j,195)%j-A(j,251)%j-A(j,252)%j-A(j,262)%j-A(j,264)%j-A(j,270)%j-A(j,271)%j-A(j,281)%j-A(j,283)%j-A(j,338)%j &
       -A(j,340)%j-A(j,346)%j-A(j,347)%j-A(j,357)%j-A(j,359)%j-A(j,365)%j-A(j,366)%j)*f(57)+(-A(j,82)%j+A(j,210)%j)*f(58)+( &
       -A(j,80)%j-A(j,212)%j)*f(59)+(A(j,37)%j-A(j,38)%j)*f(60)+A(j,239)%j*f(68)-A(j,240)%j*f(69)-A(j,247)%j*f(70) &
       -A(j,248)%j*f(71)-A(j,86)%j*f(78)-A(j,214)%j*f(79)+(-A(j,44)%j-A(j,62)%j-A(j,108)%j-A(j,117)%j-A(j,134)%j-A(j,184)%j &
       -A(j,218)%j-A(j,227)%j)*f(80)+(A(j,46)%j+A(j,64)%j+A(j,110)%j+A(j,119)%j-A(j,136)%j-A(j,186)%j-A(j,220)%j-A(j,229)%j)*f(81) &
       +(A(j,255)%j+A(j,274)%j+A(j,350)%j+A(j,369)%j)*f(83)+(-A(j,256)%j-A(j,275)%j-A(j,351)%j-A(j,370)%j)*f(84)-A(j,41)%j*f(85) &
       +A(j,42)%j*f(86)+(A(j,253)%j+A(j,272)%j+A(j,348)%j+A(j,367)%j)*f(87)+(A(j,254)%j+A(j,273)%j+A(j,349)%j+A(j,368)%j)*f(88) &
       +A(j,39)%j*f(89)+A(j,40)%j*f(90)


  M1(:)%hf = Hel(j)
  M2(:)%hf = Hel(j)

  !M(i) corresponds to \Gamma_{i} in Fabios thesis

end subroutine colourvectors


! **********************************************************************
subroutine colint(M, M2colint)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppztt_ew_ttxbbxz_3_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(4)
  real(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

    do i = 1, 4
      do j = 1, 4
        M2colint = M2colint + real(conjg(M(i))*K1(i,j)*M(j))
      end do
    end do

end subroutine colint

! **********************************************************************
subroutine colint_ct(M, Mct, M2colint_ct, l)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppztt_ew_ttxbbxz_3_/**/REALKIND, only: K2
  implicit none
  complex(REALKIND), intent(in)  :: M(4), Mct(4)
  real(REALKIND),    intent(out) :: M2colint_ct
  integer, intent(in) :: l
  integer ::  i, j

  M2colint_ct = 0

  do i = 1, 4
    do j = 1, 4
      M2colint_ct = M2colint_ct + real(conjg(M(i))*K2(i+4*l,j)*Mct(j))
    end do
  end do

end subroutine colint_ct

! **********************************************************************
subroutine colint_IR(M, M2IRadd)
! M(i)   = <M|Ci> colour component of matrix element
! K1(i,j) = .....
! **********************************************************************
  use ol_colourmatrix_ppztt_ew_ttxbbxz_3_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(4)
  real(REALKIND),    intent(out) :: M2IRadd(16)
  integer ::  i, j, k, colmatpos

  M2IRadd = 0

  do k = 1, 17-1
    colmatpos = 4*k
    do i = 1, 4
      do j = 1, 4
        M2IRadd(k) = M2IRadd(k) + real(conjg(M(i))*K1(i+colmatpos,j)*M(j))
      end do
    end do
  end do

end subroutine colint_IR

! **********************************************************************
subroutine colintmunu(M1, M2, M2colint)
! M1(i)    = <M1|Ci> colour component of matrix element
! M2(i)    = <M2|Ci> colour component of matrix element
! M2colint = <M1|M2>
!          = Sum_{i,j} <M1|Ci> * <Ci|Cj> * <Cj|M2>
!          = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppztt_ew_ttxbbxz_3_/**/REALKIND, only: K2
  implicit none

  complex(REALKIND), intent(in)  :: M1(4)
  complex(REALKIND), intent(in)  :: M2(4)
  complex(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

  do i = 1, 4
    do j = 1, 4
      M2colint = M2colint + M1(i)*K2(i,j)*conjg(M2(j))
    end do
  end do

end subroutine colintmunu





! **********************************************************************
subroutine colborninterf(M, M0_col, l)
! M(i)         = <M|Ci> colour component of matrix element
! M0_col(i)    = <M2|Ci> colour component of matrix element,
!                see \tilde{M}_{j} in Fabios thesis
! M2colint = Sum_{i} <M1|Ci> * <Ci|Cj>
!          = colour-summed squared matrix element
! KL(i,j) = <Ci|Cj> with elements Cj of 1-loop colour basis
! **********************************************************************
  use ol_colourmatrix_ppztt_ew_ttxbbxz_3_/**/REALKIND, only: KL
  implicit none

  type(Hpolcont), intent(in)  :: M(4)
  type(Hpolcont), intent(out)  :: M0_col(4)
  integer, intent(in) :: l
  integer :: i, j

  do j = 1, 4 !size(KL(1,:))
    M0_col(j)%j = 0
    M0_col(j)%hf = M(1)%hf
    do i = 1, 4 !size(KL(:,1))
      M0_col(j)%j = M0_col(j)%j  + conjg(M(i)%j)*KL(i+4*l,j)
    end do
  end do

end subroutine colborninterf

end subroutine amp2

end module ol_loop_ppztt_ew_ttxbbxz_3_/**/REALKIND
