
module ol_vamp_1_ppzjj_ew_bbxzgg_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppzjj_ew_bbxzgg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppzjj_ew_bbxzgg_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_ppzjj_ew_bbxzgg_1_/**/DREALKIND
  use ol_tensor_sum_storage_ppzjj_ew_bbxzgg_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_ppzjj_ew_bbxzgg_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_ppzjj_ew_bbxzgg_1_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL, hel_states
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(hel_states)
  type(Hpolcont), intent(in) :: M(3,hel_states)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel(1:hel_states)
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel(1:hel_states)
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

  Gcoeff(:)%j = (c(16)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(1),h0tab(:,1),[16,4,1,2,8],[nMB,nMB,nMH,nMB,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,1),heltab2x48(:,:,1))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMB,G1H24(1),n2h24(1))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(2),h0tab(:,2),[16,4,1,2,8],[nMB,nMB,nMZ,nMB,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,2),heltab2x48(:,:,2))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMB,G1H24(2),n2h24(2))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(3),h0tab(:,3),[16,4,1,2,8],[nMT,nMT,nMW,nMT,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,3),heltab2x48(:,:,3))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMT,G1H24(3),n2h24(3))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(4),h0tab(:,4),[16,4,1,2,8],[nMB,nMB,0,nMB,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,4),heltab2x48(:,:,4))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMB,G1H24(4),n2h24(4))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(5),h0tab(:,5),[16,4,1,2,8],[nMB,nMB,nMZ,nMB,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,5),heltab2x48(:,:,5))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMB,G1H24(5),n2h24(5))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(6),h0tab(:,6),[16,4,1,2,8],[nMT,nMT,nMW,nMT,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,6),heltab2x48(:,:,6))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMT,G1H24(6),n2h24(6))
  Gcoeff(:)%j = (c(16)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(7),h0tab(:,7),[16,2,1,4,8],[nMB,nMH,nMB,nMB,nMB],5,0)
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,7),heltab2x48(:,:,7))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMB,G1H24(7),n2h24(7))
  Gcoeff(:)%j = (-(c(16)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(8),h0tab(:,8),[16,2,1,4,8],[nMB,nMZ,nMB,nMB,nMB],5,0)
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,8),heltab2x48(:,:,8))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMB,G1H24(8),n2h24(8))
  Gcoeff(:)%j = (-(c(14)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(9),h0tab(:,9),[16,2,1,4,8],[nMT,nMW,nMT,nMT,nMT],5,0)
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,9),heltab2x48(:,:,9))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMT,G1H24(9),n2h24(9))
  Gcoeff(:)%j = (-(c(3)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(10),h0tab(:,10),[16,2,1,4,8],[nMB,0,nMB,nMB,nMB],5,0)
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,10),heltab2x48(:,:,10))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMB,G1H24(10),n2h24(10))
  Gcoeff(:)%j = (-(c(4)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(11),h0tab(:,11),[16,2,1,4,8],[nMB,nMZ,nMB,nMB,nMB],5,0)
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,11),heltab2x48(:,:,11))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMB,G1H24(11),n2h24(11))
  Gcoeff(:)%j = (-(c(10)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(12),h0tab(:,12),[16,2,1,4,8],[nMT,nMW,nMT,nMT,nMT],5,0)
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,12),heltab2x48(:,:,12))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMT,G1H24(12),n2h24(12))
  Gcoeff(:)%j = (c(16)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(13),h0tab(:,13),[16,4,2,1,8],[nMB,nMB,nMH,nMB,nMB],5,0)
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,13),heltab2x48(:,:,13))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMB,G1H24(13),n2h24(13))
  Gcoeff(:)%j = (-(c(16)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(14),h0tab(:,14),[16,4,2,1,8],[nMB,nMB,nMZ,nMB,nMB],5,0)
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,14),heltab2x48(:,:,14))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMB,G1H24(14),n2h24(14))
  Gcoeff(:)%j = (-(c(14)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(15),h0tab(:,15),[16,4,2,1,8],[nMT,nMT,nMW,nMT,nMT],5,0)
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,15),heltab2x48(:,:,15))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMT,G1H24(15),n2h24(15))
  Gcoeff(:)%j = (-(c(3)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(16),h0tab(:,16),[16,4,2,1,8],[nMB,nMB,0,nMB,nMB],5,0)
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,16),heltab2x48(:,:,16))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMB,G1H24(16),n2h24(16))
  Gcoeff(:)%j = (-(c(4)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(17),h0tab(:,17),[16,4,2,1,8],[nMB,nMB,nMZ,nMB,nMB],5,0)
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,17),heltab2x48(:,:,17))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMB,G1H24(17),n2h24(17))
  Gcoeff(:)%j = (-(c(10)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(18),h0tab(:,18),[16,4,2,1,8],[nMT,nMT,nMW,nMT,nMT],5,0)
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,18),heltab2x48(:,:,18))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMT,G1H24(18),n2h24(18))
  Gcoeff(:)%j = (c(16)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(19),h0tab(:,19),[16,2,1,8,4],[nMB,nMH,nMB,nMB,nMB],5,0)
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,19),heltab2x48(:,:,19))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMB,G1H24(19),n2h24(19))
  Gcoeff(:)%j = (-(c(16)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(20),h0tab(:,20),[16,2,1,8,4],[nMB,nMZ,nMB,nMB,nMB],5,0)
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,20),heltab2x48(:,:,20))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMB,G1H24(20),n2h24(20))
  Gcoeff(:)%j = (-(c(14)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(21),h0tab(:,21),[16,2,1,8,4],[nMT,nMW,nMT,nMT,nMT],5,0)
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,21),heltab2x48(:,:,21))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMT,G1H24(21),n2h24(21))
  Gcoeff(:)%j = (-(c(3)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(22),h0tab(:,22),[16,2,1,8,4],[nMB,0,nMB,nMB,nMB],5,0)
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,22),heltab2x48(:,:,22))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMB,G1H24(22),n2h24(22))
  Gcoeff(:)%j = (-(c(4)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(23),h0tab(:,23),[16,2,1,8,4],[nMB,nMZ,nMB,nMB,nMB],5,0)
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,23),heltab2x48(:,:,23))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMB,G1H24(23),n2h24(23))
  Gcoeff(:)%j = (-(c(10)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(24),h0tab(:,24),[16,2,1,8,4],[nMT,nMW,nMT,nMT,nMT],5,0)
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,24),heltab2x48(:,:,24))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMT,G1H24(24),n2h24(24))
  Gcoeff(:)%j = (c(16)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(25),h0tab(:,25),[16,1,2,4,8],[nMB,nMH,nMB,nMB,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,25),heltab2x48(:,:,25))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMB,G1H24(25),n2h24(25))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(26),h0tab(:,26),[16,1,2,4,8],[nMB,nMZ,nMB,nMB,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,26),heltab2x48(:,:,26))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMB,G1H24(26),n2h24(26))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(27),h0tab(:,27),[16,1,2,4,8],[nMT,nMW,nMT,nMT,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,27),heltab2x48(:,:,27))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMT,G1H24(27),n2h24(27))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(28),h0tab(:,28),[16,1,2,4,8],[nMB,0,nMB,nMB,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,28),heltab2x48(:,:,28))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMB,G1H24(28),n2h24(28))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(29),h0tab(:,29),[16,1,2,4,8],[nMB,nMZ,nMB,nMB,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,29),heltab2x48(:,:,29))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMB,G1H24(29),n2h24(29))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(30),h0tab(:,30),[16,1,2,4,8],[nMT,nMW,nMT,nMT,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,30),heltab2x48(:,:,30))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMT,G1H24(30),n2h24(30))
  Gcoeff(:)%j = (c(16)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(31),h0tab(:,31),[16,1,2,8,4],[nMB,nMH,nMB,nMB,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,31),heltab2x48(:,:,31))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMB,G1H24(31),n2h24(31))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(32),h0tab(:,32),[16,1,2,8,4],[nMB,nMZ,nMB,nMB,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,32),heltab2x48(:,:,32))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMB,G1H24(32),n2h24(32))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(33),h0tab(:,33),[16,1,2,8,4],[nMT,nMW,nMT,nMT,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,33),heltab2x48(:,:,33))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMT,G1H24(33),n2h24(33))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(34),h0tab(:,34),[16,1,2,8,4],[nMB,0,nMB,nMB,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,34),heltab2x48(:,:,34))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMB,G1H24(34),n2h24(34))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(35),h0tab(:,35),[16,1,2,8,4],[nMB,nMZ,nMB,nMB,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,35),heltab2x48(:,:,35))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMB,G1H24(35),n2h24(35))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(36),h0tab(:,36),[16,1,2,8,4],[nMT,nMW,nMT,nMT,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,36),heltab2x48(:,:,36))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMT,G1H24(36),n2h24(36))
  Gcoeff(:)%j = (-(c(8)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(37),h0tab(:,37),[16,2,4,1,8],[nMB,nMZ,nMH,nMB,nMB],5,0)
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,37),heltab2x48(:,:,37))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMB,G1H24(37),n2h24(37))
  Gcoeff(:)%j = (-(c(8)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(38),h0tab(:,38),[16,2,4,1,8],[nMB,nMH,nMZ,nMB,nMB],5,0)
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,38),heltab2x48(:,:,38))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMB,G1H24(38),n2h24(38))
  Gcoeff(:)%j = (c(20)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(39),h0tab(:,39),[16,2,4,1,8],[nMT,nMW,nMW,nMT,nMT],5,0)
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,39),heltab2x48(:,:,39))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMT,G1H24(39),n2h24(39))
  Gcoeff(:)%j = (c(12)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(40),h0tab(:,40),[16,2,4,1,8],[nMB,nMZ,nMH,nMB,nMB],5,0)
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,40),heltab2x48(:,:,40))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMB,G1H24(40),n2h24(40))
  Gcoeff(:)%j = (c(18)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(41),h0tab(:,41),[16,2,4,1,8],[nMT,nMW,nMW,nMT,nMT],5,0)
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,41),heltab2x48(:,:,41))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMT,G1H24(41),n2h24(41))
  Gcoeff(:)%j = (c(12)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(42),h0tab(:,42),[16,2,4,1,8],[nMB,nMH,nMZ,nMB,nMB],5,0)
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,42),heltab2x48(:,:,42))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMB,G1H24(42),n2h24(42))
  Gcoeff(:)%j = (-(c(18)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(43),h0tab(:,43),[16,2,4,1,8],[nMT,nMW,nMW,nMT,nMT],5,0)
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,43),heltab2x48(:,:,43))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMT,G1H24(43),n2h24(43))
  Gcoeff(:)%j = (-(c(6)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(44),h0tab(:,44),[16,2,4,1,8],[nMT,nMW,nMW,nMT,nMT],5,0)
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,44),heltab2x48(:,:,44))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMT,G1H24(44),n2h24(44))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(45),h0tab(:,45),[16,1,4,2,8],[nMB,nMH,nMZ,nMB,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,45),heltab2x48(:,:,45))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMB,G1H24(45),n2h24(45))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(46),h0tab(:,46),[16,1,4,2,8],[nMB,nMZ,nMH,nMB,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,46),heltab2x48(:,:,46))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMB,G1H24(46),n2h24(46))
  Gcoeff(:)%j = (c(20)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(47),h0tab(:,47),[16,1,4,2,8],[nMT,nMW,nMW,nMT,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,47),heltab2x48(:,:,47))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMT,G1H24(47),n2h24(47))
  Gcoeff(:)%j = (c(12)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(48),h0tab(:,48),[16,1,4,2,8],[nMB,nMH,nMZ,nMB,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,48),heltab2x48(:,:,48))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMB,G1H24(48),n2h24(48))
  Gcoeff(:)%j = (c(18)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(49),h0tab(:,49),[16,1,4,2,8],[nMT,nMW,nMW,nMT,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,49),heltab2x48(:,:,49))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMT,G1H24(49),n2h24(49))
  Gcoeff(:)%j = (c(12)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(50),h0tab(:,50),[16,1,4,2,8],[nMB,nMZ,nMH,nMB,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,50),heltab2x48(:,:,50))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMB,G1H24(50),n2h24(50))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(51),h0tab(:,51),[16,1,4,2,8],[nMT,nMW,nMW,nMT,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,51),heltab2x48(:,:,51))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMT,G1H24(51),n2h24(51))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(52),h0tab(:,52),[16,1,4,2,8],[nMT,nMW,nMW,nMT,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,52),heltab2x48(:,:,52))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMT,G1H24(52),n2h24(52))
  call Hloop_AZ_Q(ntryL,G1H24(1),ex3(:),G1H8(1),ngZd,m3h3x8(:,1),heltab2x24(:,:,1))
  call Hloop_A_Q(ntryL,G1H8(1),20,nMB,G2H8(1),n2h8(1))
  call Hloop_AZ_Q(ntryL,G1H24(2),ex3(:),G1H8(1),ngZd,m3h3x8(:,2),heltab2x24(:,:,2))
  call Hloop_A_Q(ntryL,G1H8(1),20,nMB,G2H8(2),n2h8(2))
  call Hloop_AZ_Q(ntryL,G1H24(3),ex3(:),G1H8(1),ngZu,m3h3x8(:,3),heltab2x24(:,:,3))
  call Hloop_A_Q(ntryL,G1H8(1),20,nMT,G2H8(3),n2h8(3))
  call Hloop_AZ_Q(ntryL,G1H24(4),ex3(:),G1H8(1),ngZd,m3h3x8(:,4),heltab2x24(:,:,4))
  call Hloop_A_Q(ntryL,G1H8(1),20,nMB,G2H8(4),n2h8(4))
  call Hloop_AZ_Q(ntryL,G1H24(5),ex3(:),G1H8(1),ngZd,m3h3x8(:,5),heltab2x24(:,:,5))
  call Hloop_A_Q(ntryL,G1H8(1),20,nMB,G2H8(5),n2h8(5))
  call Hloop_AZ_Q(ntryL,G1H24(6),ex3(:),G1H8(1),ngZu,m3h3x8(:,6),heltab2x24(:,:,6))
  call Hloop_A_Q(ntryL,G1H8(1),20,nMT,G2H8(6),n2h8(6))
  call Hloop_QA_S(ntryL,G1H24(7),ex2(:),G1H12(1),ngH,m3h2x12(:,1),heltab2x24(:,:,7))
  call Hloop_QA_S(ntryL,G1H24(8),ex2(:),G1H12(2),ngX,m3h2x12(:,2),heltab2x24(:,:,8))
  call Hloop_QA_S(ntryL,G1H24(9),ex2(:),G1H12(3),ngPbt,m3h2x12(:,3),heltab2x24(:,:,9))
  call Hloop_QA_V(ntryL,G1H24(10),ex2(:),G1H12(4),m3h2x12(:,4),heltab2x24(:,:,10))
  call Hloop_QA_Z(ntryL,G1H24(11),ex2(:),G1H12(5),ngZd,m3h2x12(:,5),heltab2x24(:,:,11))
  call Hloop_QA_W(ntryL,G1H24(12),ex2(:),G1H12(6),m3h2x12(:,6),heltab2x24(:,:,12))
  call Hloop_QZ_A(ntryL,G1H24(13),ex3(:),G1H8(1),ngZd,m3h3x8(:,7),heltab2x24(:,:,13))
  call Hloop_Q_A(ntryL,G1H8(1),20,nMB,G2H8(7),n2h8(7))
  call Hloop_QZ_A(ntryL,G1H24(14),ex3(:),G1H8(1),ngZd,m3h3x8(:,8),heltab2x24(:,:,14))
  call Hloop_Q_A(ntryL,G1H8(1),20,nMB,G2H8(8),n2h8(8))
  call Hloop_QZ_A(ntryL,G1H24(15),ex3(:),G1H8(1),ngZu,m3h3x8(:,9),heltab2x24(:,:,15))
  call Hloop_Q_A(ntryL,G1H8(1),20,nMT,G2H8(9),n2h8(9))
  call Hloop_QZ_A(ntryL,G1H24(16),ex3(:),G1H8(1),ngZd,m3h3x8(:,10),heltab2x24(:,:,16))
  call Hloop_Q_A(ntryL,G1H8(1),20,nMB,G2H8(10),n2h8(10))
  call Hloop_QZ_A(ntryL,G1H24(17),ex3(:),G1H8(1),ngZd,m3h3x8(:,11),heltab2x24(:,:,17))
  call Hloop_Q_A(ntryL,G1H8(1),20,nMB,G2H8(11),n2h8(11))
  call Hloop_QZ_A(ntryL,G1H24(18),ex3(:),G1H8(1),ngZu,m3h3x8(:,12),heltab2x24(:,:,18))
  call Hloop_Q_A(ntryL,G1H8(1),20,nMT,G2H8(12),n2h8(12))
  call Hloop_QA_S(ntryL,G1H24(19),ex2(:),G1H12(7),ngH,m3h2x12(:,7),heltab2x24(:,:,19))
  call Hloop_QA_S(ntryL,G1H24(20),ex2(:),G1H12(8),ngX,m3h2x12(:,8),heltab2x24(:,:,20))
  call Hloop_QA_S(ntryL,G1H24(21),ex2(:),G1H12(9),ngPbt,m3h2x12(:,9),heltab2x24(:,:,21))
  call Hloop_QA_V(ntryL,G1H24(22),ex2(:),G1H12(10),m3h2x12(:,10),heltab2x24(:,:,22))
  call Hloop_QA_Z(ntryL,G1H24(23),ex2(:),G1H12(11),ngZd,m3h2x12(:,11),heltab2x24(:,:,23))
  call Hloop_QA_W(ntryL,G1H24(24),ex2(:),G1H12(12),m3h2x12(:,12),heltab2x24(:,:,24))
  call Hloop_AQ_S(ntryL,G1H24(25),ex1(:),G1H12(13),ngH,m3h2x12(:,13),heltab2x24(:,:,25))
  call Hloop_AQ_S(ntryL,G1H24(26),ex1(:),G1H12(14),ngX,m3h2x12(:,14),heltab2x24(:,:,26))
  call Hloop_AQ_S(ntryL,G1H24(27),ex1(:),G1H12(15),ngPtb,m3h2x12(:,15),heltab2x24(:,:,27))
  call Hloop_AQ_V(ntryL,G1H24(28),ex1(:),G1H12(16),m3h2x12(:,16),heltab2x24(:,:,28))
  call Hloop_AQ_Z(ntryL,G1H24(29),ex1(:),G1H12(17),ngZd,m3h2x12(:,17),heltab2x24(:,:,29))
  call Hloop_AQ_W(ntryL,G1H24(30),ex1(:),G1H12(18),m3h2x12(:,18),heltab2x24(:,:,30))
  call Hloop_AQ_S(ntryL,G1H24(31),ex1(:),G1H12(19),ngH,m3h2x12(:,19),heltab2x24(:,:,31))
  call Hloop_AQ_S(ntryL,G1H24(32),ex1(:),G1H12(20),ngX,m3h2x12(:,20),heltab2x24(:,:,32))
  call Hloop_AQ_S(ntryL,G1H24(33),ex1(:),G1H12(21),ngPtb,m3h2x12(:,21),heltab2x24(:,:,33))
  call Hloop_AQ_V(ntryL,G1H24(34),ex1(:),G1H12(22),m3h2x12(:,22),heltab2x24(:,:,34))
  call Hloop_AQ_Z(ntryL,G1H24(35),ex1(:),G1H12(23),ngZd,m3h2x12(:,23),heltab2x24(:,:,35))
  call Hloop_AQ_W(ntryL,G1H24(36),ex1(:),G1H12(24),m3h2x12(:,24),heltab2x24(:,:,36))
  call Hloop_QA_S(ntryL,G1H24(37),ex2(:),G1H12(25),ngX,m3h2x12(:,25),heltab2x24(:,:,37))
  call Hloop_QA_S(ntryL,G1H24(38),ex2(:),G1H12(26),ngH,m3h2x12(:,26),heltab2x24(:,:,38))
  call Hloop_QA_S(ntryL,G1H24(39),ex2(:),G1H12(27),ngPbt,m3h2x12(:,27),heltab2x24(:,:,39))
  call Hloop_QA_Z(ntryL,G1H24(40),ex2(:),G1H12(28),ngZd,m3h2x12(:,28),heltab2x24(:,:,40))
  call Hloop_QA_W(ntryL,G1H24(41),ex2(:),G1H12(29),m3h2x12(:,29),heltab2x24(:,:,41))
  call Hloop_QA_S(ntryL,G1H24(42),ex2(:),G1H12(30),ngH,m3h2x12(:,30),heltab2x24(:,:,42))
  call Hloop_QA_S(ntryL,G1H24(43),ex2(:),G1H12(31),ngPbt,m3h2x12(:,31),heltab2x24(:,:,43))
  call Hloop_QA_W(ntryL,G1H24(44),ex2(:),G1H12(32),m3h2x12(:,32),heltab2x24(:,:,44))
  call Hloop_AQ_S(ntryL,G1H24(45),ex1(:),G1H12(33),ngH,m3h2x12(:,33),heltab2x24(:,:,45))
  call Hloop_AQ_S(ntryL,G1H24(46),ex1(:),G1H12(34),ngX,m3h2x12(:,34),heltab2x24(:,:,46))
  call Hloop_AQ_S(ntryL,G1H24(47),ex1(:),G1H12(35),ngPtb,m3h2x12(:,35),heltab2x24(:,:,47))
  call Hloop_AQ_S(ntryL,G1H24(48),ex1(:),G1H12(36),ngH,m3h2x12(:,36),heltab2x24(:,:,48))
  call Hloop_AQ_S(ntryL,G1H24(49),ex1(:),G1H12(37),ngPtb,m3h2x12(:,37),heltab2x24(:,:,49))
  call Hloop_AQ_Z(ntryL,G1H24(50),ex1(:),G1H12(38),ngZd,m3h2x12(:,38),heltab2x24(:,:,50))
  call Hloop_AQ_W(ntryL,G1H24(51),ex1(:),G1H12(39),m3h2x12(:,39),heltab2x24(:,:,51))
  call Hloop_AQ_W(ntryL,G1H24(52),ex1(:),G1H12(40),m3h2x12(:,40),heltab2x24(:,:,52))
  call Hloop_AQ_S(ntryL,G2H8(1),ex1(:),G2H4(1),ngH,m3h2x4(:,1),heltab2x8(:,:,1))
  call Hloop_AQ_S(ntryL,G2H8(2),ex1(:),G2H4(2),ngX,m3h2x4(:,2),heltab2x8(:,:,2))
  call Hloop_AQ_S(ntryL,G2H8(3),ex1(:),G2H4(3),ngPtb,m3h2x4(:,3),heltab2x8(:,:,3))
  call Hloop_AQ_V(ntryL,G2H8(4),ex1(:),G2H4(4),m3h2x4(:,4),heltab2x8(:,:,4))
  call Hloop_AQ_Z(ntryL,G2H8(5),ex1(:),G2H4(5),ngZd,m3h2x4(:,5),heltab2x8(:,:,5))
  call Hloop_AQ_W(ntryL,G2H8(6),ex1(:),G2H4(6),m3h2x4(:,6),heltab2x8(:,:,6))
  call Hloop_SQ_A(ntryL,G1H12(1),ex1(:),G1H6(1),ngH,m3h2x6(:,1),heltab2x12(:,:,1))
  call Hloop_Q_A(ntryL,G1H6(1),19,nMB,G2H6(1),n2h6(1))
  call Hloop_SQ_A(ntryL,G1H12(2),ex1(:),G1H6(1),ngX,m3h2x6(:,2),heltab2x12(:,:,2))
  call Hloop_Q_A(ntryL,G1H6(1),19,nMB,G2H6(2),n2h6(2))
  call Hloop_SQ_A(ntryL,G1H12(3),ex1(:),G1H6(1),ngPtb,m3h2x6(:,3),heltab2x12(:,:,3))
  call Hloop_Q_A(ntryL,G1H6(1),19,nMT,G2H6(3),n2h6(3))
  call Hloop_VQ_A(ntryL,G1H12(4),ex1(:),G1H6(1),m3h2x6(:,4),heltab2x12(:,:,4))
  call Hloop_Q_A(ntryL,G1H6(1),19,nMB,G2H6(4),n2h6(4))
  call Hloop_ZQ_A(ntryL,G1H12(5),ex1(:),G1H6(1),ngZd,m3h2x6(:,5),heltab2x12(:,:,5))
  call Hloop_Q_A(ntryL,G1H6(1),19,nMB,G2H6(5),n2h6(5))
  call Hloop_WQ_A(ntryL,G1H12(6),ex1(:),G1H6(1),m3h2x6(:,6),heltab2x12(:,:,6))
  call Hloop_Q_A(ntryL,G1H6(1),19,nMT,G2H6(6),n2h6(6))
  call Hloop_QA_S(ntryL,G2H8(7),ex2(:),G2H4(7),ngH,m3h2x4(:,7),heltab2x8(:,:,7))
  call Hloop_QA_S(ntryL,G2H8(8),ex2(:),G2H4(8),ngX,m3h2x4(:,8),heltab2x8(:,:,8))
  call Hloop_QA_S(ntryL,G2H8(9),ex2(:),G2H4(9),ngPbt,m3h2x4(:,9),heltab2x8(:,:,9))
  call Hloop_QA_V(ntryL,G2H8(10),ex2(:),G2H4(10),m3h2x4(:,10),heltab2x8(:,:,10))
  call Hloop_QA_Z(ntryL,G2H8(11),ex2(:),G2H4(11),ngZd,m3h2x4(:,11),heltab2x8(:,:,11))
  call Hloop_QA_W(ntryL,G2H8(12),ex2(:),G2H4(12),m3h2x4(:,12),heltab2x8(:,:,12))
  call Hloop_SQ_A(ntryL,G1H12(7),ex1(:),G1H6(1),ngH,m3h2x6(:,7),heltab2x12(:,:,7))
  call Hloop_Q_A(ntryL,G1H6(1),19,nMB,G2H6(7),n2h6(7))
  call Hloop_SQ_A(ntryL,G1H12(8),ex1(:),G1H6(1),ngX,m3h2x6(:,8),heltab2x12(:,:,8))
  call Hloop_Q_A(ntryL,G1H6(1),19,nMB,G2H6(8),n2h6(8))
  call Hloop_SQ_A(ntryL,G1H12(9),ex1(:),G1H6(1),ngPtb,m3h2x6(:,9),heltab2x12(:,:,9))
  call Hloop_Q_A(ntryL,G1H6(1),19,nMT,G2H6(9),n2h6(9))
  call Hloop_VQ_A(ntryL,G1H12(10),ex1(:),G1H6(1),m3h2x6(:,10),heltab2x12(:,:,10))
  call Hloop_Q_A(ntryL,G1H6(1),19,nMB,G2H6(10),n2h6(10))
  call Hloop_ZQ_A(ntryL,G1H12(11),ex1(:),G1H6(1),ngZd,m3h2x6(:,11),heltab2x12(:,:,11))
  call Hloop_Q_A(ntryL,G1H6(1),19,nMB,G2H6(11),n2h6(11))
  call Hloop_WQ_A(ntryL,G1H12(12),ex1(:),G1H6(1),m3h2x6(:,12),heltab2x12(:,:,12))
  call Hloop_Q_A(ntryL,G1H6(1),19,nMT,G2H6(12),n2h6(12))
  call Hloop_SA_Q(ntryL,G1H12(13),ex2(:),G1H6(1),ngH,m3h2x6(:,13),heltab2x12(:,:,13))
  call Hloop_A_Q(ntryL,G1H6(1),19,nMB,G2H6(13),n2h6(13))
  call Hloop_SA_Q(ntryL,G1H12(14),ex2(:),G1H6(1),ngX,m3h2x6(:,14),heltab2x12(:,:,14))
  call Hloop_A_Q(ntryL,G1H6(1),19,nMB,G2H6(14),n2h6(14))
  call Hloop_SA_Q(ntryL,G1H12(15),ex2(:),G1H6(1),ngPbt,m3h2x6(:,15),heltab2x12(:,:,15))
  call Hloop_A_Q(ntryL,G1H6(1),19,nMT,G2H6(15),n2h6(15))
  call Hloop_VA_Q(ntryL,G1H12(16),ex2(:),G1H6(1),m3h2x6(:,16),heltab2x12(:,:,16))
  call Hloop_A_Q(ntryL,G1H6(1),19,nMB,G2H6(16),n2h6(16))
  call Hloop_ZA_Q(ntryL,G1H12(17),ex2(:),G1H6(1),ngZd,m3h2x6(:,17),heltab2x12(:,:,17))
  call Hloop_A_Q(ntryL,G1H6(1),19,nMB,G2H6(17),n2h6(17))
  call Hloop_WA_Q(ntryL,G1H12(18),ex2(:),G1H6(1),m3h2x6(:,18),heltab2x12(:,:,18))
  call Hloop_A_Q(ntryL,G1H6(1),19,nMT,G2H6(18),n2h6(18))
  call Hloop_SA_Q(ntryL,G1H12(19),ex2(:),G1H6(1),ngH,m3h2x6(:,19),heltab2x12(:,:,19))
  call Hloop_A_Q(ntryL,G1H6(1),19,nMB,G2H6(19),n2h6(19))
  call Hloop_SA_Q(ntryL,G1H12(20),ex2(:),G1H6(1),ngX,m3h2x6(:,20),heltab2x12(:,:,20))
  call Hloop_A_Q(ntryL,G1H6(1),19,nMB,G2H6(20),n2h6(20))
  call Hloop_SA_Q(ntryL,G1H12(21),ex2(:),G1H6(1),ngPbt,m3h2x6(:,21),heltab2x12(:,:,21))
  call Hloop_A_Q(ntryL,G1H6(1),19,nMT,G2H6(21),n2h6(21))
  call Hloop_VA_Q(ntryL,G1H12(22),ex2(:),G1H6(1),m3h2x6(:,22),heltab2x12(:,:,22))
  call Hloop_A_Q(ntryL,G1H6(1),19,nMB,G2H6(22),n2h6(22))
  call Hloop_ZA_Q(ntryL,G1H12(23),ex2(:),G1H6(1),ngZd,m3h2x6(:,23),heltab2x12(:,:,23))
  call Hloop_A_Q(ntryL,G1H6(1),19,nMB,G2H6(23),n2h6(23))
  call Hloop_WA_Q(ntryL,G1H12(24),ex2(:),G1H6(1),m3h2x6(:,24),heltab2x12(:,:,24))
  call Hloop_A_Q(ntryL,G1H6(1),19,nMT,G2H6(24),n2h6(24))
  call Hloop_SV_T(ntryL,G1H12(25),18,ex3(:),4,G2H4(13),m3h3x4(:,1),heltab2x12(:,:,25))
  call Hloop_TV_S(ntryL,G1H12(26),18,ex3(:),4,G2H4(14),m3h3x4(:,2),heltab2x12(:,:,26))
  call Hloop_SV_T(ntryL,G1H12(27),18,ex3(:),4,G2H4(15),m3h3x4(:,3),heltab2x12(:,:,27))
  call Hloop_VV_S(ntryL,G1H12(28),ex3(:),G1H4(1),m3h3x4(:,4),heltab2x12(:,:,28))
  call Hloop_VV_S(ntryL,G1H12(29),ex3(:),G1H4(2),m3h3x4(:,5),heltab2x12(:,:,29))
  call Hloop_SV_V(ntryL,G1H12(30),ex3(:),G1H4(3),m3h3x4(:,6),heltab2x12(:,:,30))
  call Hloop_SV_V(ntryL,G1H12(31),ex3(:),G1H4(4),m3h3x4(:,7),heltab2x12(:,:,31))
  call Hloop_UW_V(ntryL,G1H12(32),18,ex3(:),4,G2H4(16),m3h3x4(:,8),heltab2x12(:,:,32))
  call Hloop_TV_S(ntryL,G1H12(33),17,ex3(:),4,G2H4(17),m3h3x4(:,9),heltab2x12(:,:,33))
  call Hloop_SV_T(ntryL,G1H12(34),17,ex3(:),4,G2H4(18),m3h3x4(:,10),heltab2x12(:,:,34))
  call Hloop_TV_S(ntryL,G1H12(35),17,ex3(:),4,G2H4(19),m3h3x4(:,11),heltab2x12(:,:,35))
  call Hloop_SV_V(ntryL,G1H12(36),ex3(:),G1H4(5),m3h3x4(:,12),heltab2x12(:,:,36))
  call Hloop_SV_V(ntryL,G1H12(37),ex3(:),G1H4(6),m3h3x4(:,13),heltab2x12(:,:,37))
  call Hloop_VV_S(ntryL,G1H12(38),ex3(:),G1H4(7),m3h3x4(:,14),heltab2x12(:,:,38))
  call Hloop_VV_S(ntryL,G1H12(39),ex3(:),G1H4(8),m3h3x4(:,15),heltab2x12(:,:,39))
  call Hloop_UV_W(ntryL,G1H12(40),17,ex3(:),4,G2H4(20),m3h3x4(:,16),heltab2x12(:,:,40))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(5),[G2H6(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(6),[G2H6(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(11),[G2H6(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(12),[G2H6(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(17),[G2H6(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(18),[G2H6(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(23),[G2H6(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(24),[G2H6(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(13),[G1H4(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(15),[G1H4(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(16),[G1H4(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(18),[G1H4(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(19),[G1H4(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(20),[G1H4(6)])
  call Hotf_5pt_reduction(G2H4(1),RedSet_5(1),mass5set(:,1),  & 
G1H4(1),G1H4(2),G1H4(4),G1H4(7),G1H4(8),G1H4(6),4)
  call HG1shiftOLR(G1H4(2),8,4)
  call Hotf_5pt_reduction(G2H4(2),RedSet_5(1),mass5set(:,2),  & 
G1H4(9),G1H4(10),G1H4(11),G1H4(12),G1H4(13),G1H4(14),4)
  call HG1shiftOLR(G1H4(10),8,4)
  call Hotf_5pt_reduction(G2H4(3),RedSet_5(1),mass5set(:,3),  & 
G1H4(15),G1H4(16),G1H4(17),G1H4(18),G1H4(19),G1H4(20),4)
  call HG1shiftOLR(G1H4(16),8,4)
  call Hotf_5pt_reduction(G2H4(4),RedSet_5(1),mass5set(:,4),  & 
G1H4(21),G1H4(22),G1H4(23),G1H4(24),G1H4(25),G1H4(26),4)
  call HG1shiftOLR(G1H4(22),8,4)
  call Hotf_5pt_reduction(G2H4(5),RedSet_5(1),mass5set(:,2),  & 
G1H4(27),G1H4(28),G1H4(29),G1H4(30),G1H4(31),G1H4(32),4)
  call HG1shiftOLR(G1H4(28),8,4)
  call Hotf_5pt_reduction(G2H4(6),RedSet_5(1),mass5set(:,3),  & 
G1H4(33),G1H4(34),G1H4(35),G1H4(36),G1H4(37),G1H4(38),4)
  call HG1shiftOLR(G1H4(34),8,4)
  call Hotf_5pt_reduction(G2H6(1),RedSet_5(2),mass5set(:,5),  & 
G1H6(1),G1H6(2),G1H6(3),G1H6(4),G1H6(5),G1H6(6),6)
  call HG1shiftOLR(G1H6(2),8,6)
  call Hotf_5pt_reduction(G2H6(5),RedSet_5(2),mass5set(:,6),  & 
G1H6(7),G1H6(8),G1H6(9),G1H6(10),G1H6(11),G1H6(12),6)
  call HG1shiftOLR(G1H6(8),8,6)
  call Hotf_5pt_reduction(G2H6(6),RedSet_5(2),mass5set(:,7),  & 
G1H6(13),G1H6(14),G1H6(15),G1H6(16),G1H6(17),G1H6(18),6)
  call HG1shiftOLR(G1H6(14),8,6)
  call Hotf_5pt_reduction(G2H6(4),RedSet_5(2),mass5set(:,8),  & 
G1H6(19),G1H6(20),G1H6(21),G1H6(22),G1H6(23),G1H6(24),6)
  call HG1shiftOLR(G1H6(20),8,6)
  call Hotf_5pt_reduction(G2H4(7),RedSet_5(3),mass5set(:,1),  & 
G1H4(39),G1H4(40),G1H4(41),G1H4(42),G1H4(43),G1H4(44),4)
  call HG1shiftOLR(G1H4(40),8,4)
  call Hotf_5pt_reduction(G2H4(8),RedSet_5(3),mass5set(:,2),  & 
G1H4(45),G1H4(46),G1H4(47),G1H4(48),G1H4(49),G1H4(50),4)
  call HG1shiftOLR(G1H4(46),8,4)
  call Hotf_5pt_reduction(G2H4(9),RedSet_5(3),mass5set(:,3),  & 
G1H4(51),G1H4(52),G1H4(53),G1H4(54),G1H4(55),G1H4(56),4)
  call HG1shiftOLR(G1H4(52),8,4)
  call Hotf_5pt_reduction(G2H4(10),RedSet_5(3),mass5set(:,4),  & 
G1H4(57),G1H4(58),G1H4(59),G1H4(60),G1H4(61),G1H4(62),4)
  call HG1shiftOLR(G1H4(58),8,4)
  call Hotf_5pt_reduction(G2H4(11),RedSet_5(3),mass5set(:,2),  & 
G1H4(63),G1H4(64),G1H4(65),G1H4(66),G1H4(67),G1H4(68),4)
  call HG1shiftOLR(G1H4(64),8,4)
  call Hotf_5pt_reduction(G2H4(12),RedSet_5(3),mass5set(:,3),  & 
G1H4(69),G1H4(70),G1H4(71),G1H4(72),G1H4(73),G1H4(74),4)
  call HG1shiftOLR(G1H4(70),8,4)
  call Hotf_5pt_reduction(G2H6(7),RedSet_5(4),mass5set(:,5),  & 
G1H6(25),G1H6(26),G1H6(27),G1H6(28),G1H6(29),G1H6(30),6)
  call HG1shiftOLR(G1H6(26),4,6)
  call Hotf_5pt_reduction(G2H6(11),RedSet_5(4),mass5set(:,6),  & 
G1H6(31),G1H6(32),G1H6(33),G1H6(34),G1H6(35),G1H6(36),6)
  call HG1shiftOLR(G1H6(32),4,6)
  call Hotf_5pt_reduction(G2H6(12),RedSet_5(4),mass5set(:,7),  & 
G1H6(37),G1H6(38),G1H6(39),G1H6(40),G1H6(41),G1H6(42),6)
  call HG1shiftOLR(G1H6(38),4,6)
  call Hotf_5pt_reduction(G2H6(10),RedSet_5(4),mass5set(:,8),  & 
G1H6(43),G1H6(44),G1H6(45),G1H6(46),G1H6(47),G1H6(48),6)
  call HG1shiftOLR(G1H6(44),4,6)
  call Hotf_5pt_reduction(G2H6(13),RedSet_5(5),mass5set(:,5),  & 
G1H6(49),G1H6(50),G1H6(51),G1H6(52),G1H6(53),G1H6(54),6)
  call HG1shiftOLR(G1H6(50),8,6)
  call Hotf_5pt_reduction(G2H6(17),RedSet_5(5),mass5set(:,6),  & 
G1H6(55),G1H6(56),G1H6(57),G1H6(58),G1H6(59),G1H6(60),6)
  call HG1shiftOLR(G1H6(56),8,6)
  call Hotf_5pt_reduction(G2H6(18),RedSet_5(5),mass5set(:,7),  & 
G1H6(61),G1H6(62),G1H6(63),G1H6(64),G1H6(65),G1H6(66),6)
  call HG1shiftOLR(G1H6(62),8,6)
  call Hotf_5pt_reduction(G2H6(16),RedSet_5(5),mass5set(:,8),  & 
G1H6(67),G1H6(68),G1H6(69),G1H6(70),G1H6(71),G1H6(72),6)
  call HG1shiftOLR(G1H6(68),8,6)
  call Hotf_5pt_reduction(G2H6(19),RedSet_5(6),mass5set(:,5),  & 
G1H6(73),G1H6(74),G1H6(75),G1H6(76),G1H6(77),G1H6(78),6)
  call HG1shiftOLR(G1H6(74),4,6)
  call Hotf_5pt_reduction(G2H6(23),RedSet_5(6),mass5set(:,6),  & 
G1H6(79),G1H6(80),G1H6(81),G1H6(82),G1H6(83),G1H6(84),6)
  call HG1shiftOLR(G1H6(80),4,6)
  call Hotf_5pt_reduction(G2H6(24),RedSet_5(6),mass5set(:,7),  & 
G1H6(85),G1H6(86),G1H6(87),G1H6(88),G1H6(89),G1H6(90),6)
  call HG1shiftOLR(G1H6(86),4,6)
  call Hotf_5pt_reduction(G2H6(22),RedSet_5(6),mass5set(:,8),  & 
G1H6(91),G1H6(92),G1H6(93),G1H6(94),G1H6(95),G1H6(96),6)
  call HG1shiftOLR(G1H6(92),4,6)
  call Hotf_5pt_reduction(G2H4(13),RedSet_5(7),mass5set(:,9),  & 
G1H4(75),G1H4(76),G1H4(77),G1H4(78),G1H4(79),G1H4(80),4)
  call HG1shiftOLR(G1H4(76),8,4)
  call Hotf_5pt_reduction(G2H4(14),RedSet_5(7),mass5set(:,10),  & 
G1H4(81),G1H4(82),G1H4(83),G1H4(84),G1H4(85),G1H4(86),4)
  call HG1shiftOLR(G1H4(82),8,4)
  call Hotf_5pt_reduction(G2H4(15),RedSet_5(7),mass5set(:,11),  & 
G1H4(87),G1H4(88),G1H4(89),G1H4(90),G1H4(91),G1H4(92),4)
  call HG1shiftOLR(G1H4(88),8,4)
  call Hloop_ZQ_A(ntryL,G1H4(3),ex1(:),G1H2(1),ngZd,m3h2x2(:,1),heltab2x4(:,:,1))
  call Hloop_Q_A(ntryL,G1H2(1),23,nMB,G2H2(1),n2h2(1))
  call Hotf_5pt_reduction(G2H4(16),RedSet_5(7),mass5set(:,11),  & 
G1H4(3),G1H4(93),G1H4(94),G1H4(95),G1H4(96),G1H4(97),4)
  call HG1shiftOLR(G1H4(93),8,4)
  call Hotf_5pt_reduction(G2H4(17),RedSet_5(8),mass5set(:,10),  & 
G1H4(98),G1H4(99),G1H4(100),G1H4(101),G1H4(102),G1H4(103),4)
  call HG1shiftOLR(G1H4(99),8,4)
  call Hotf_5pt_reduction(G2H4(18),RedSet_5(8),mass5set(:,9),  & 
G1H4(104),G1H4(105),G1H4(106),G1H4(107),G1H4(108),G1H4(109),4)
  call HG1shiftOLR(G1H4(105),8,4)
  call Hotf_5pt_reduction(G2H4(19),RedSet_5(8),mass5set(:,11),  & 
G1H4(110),G1H4(111),G1H4(112),G1H4(113),G1H4(114),G1H4(115),4)
  call HG1shiftOLR(G1H4(111),8,4)
  call Hloop_ZA_Q(ntryL,G1H4(5),ex2(:),G1H2(1),ngZd,m3h2x2(:,2),heltab2x4(:,:,2))
  call Hloop_A_Q(ntryL,G1H2(1),23,nMB,G2H2(2),n2h2(2))
  call Hotf_5pt_reduction(G2H4(20),RedSet_5(8),mass5set(:,11),  & 
G1H4(5),G1H4(116),G1H4(117),G1H4(118),G1H4(119),G1H4(120),4)
  call HG1shiftOLR(G1H4(116),8,4)
  call Hloop_SA_Q(ntryL,G1H4(1),ex2(:),G1H2(1),ngH,m3h2x2(:,3),heltab2x4(:,:,3))
  call Hloop_A_Q(ntryL,G1H2(1),23,nMB,G2H2(3),n2h2(3))
call HGT_OLR(G1H4(2),1,1,4)
call HGT_invQ_OLR(G1H4(2),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(2),-8,nMB,G2H4(1),n2h4(1))
  call Hloop_QV_A(ntryL,G2H4(1),ex4(:),G2H2(4),m3h2x2(:,4),heltab2x4(:,:,4))
  call Hloop_SA_Q(ntryL,G1H4(8),ex2(:),G1H2(1),ngH,m3h2x2(:,5),heltab2x4(:,:,5))
  call Hloop_A_Q(ntryL,G1H2(1),23,nMB,G2H2(5),n2h2(4))
  call Hloop_SA_Q(ntryL,G1H4(6),ex2(:),G1H2(1),ngH,m3h2x2(:,6),heltab2x4(:,:,6))
  call Hloop_A_Q(ntryL,G1H2(1),23,nMB,G2H2(6),n2h2(5))
  call Hloop_SA_Q(ntryL,G1H4(9),ex2(:),G1H2(1),ngX,m3h2x2(:,7),heltab2x4(:,:,7))
  call Hloop_A_Q(ntryL,G1H2(1),23,nMB,G2H2(7),n2h2(6))
call HGT_OLR(G1H4(10),1,1,4)
call HGT_invQ_OLR(G1H4(10),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(10),-8,nMB,G2H4(2),n2h4(2))
  call Hloop_QV_A(ntryL,G2H4(2),ex4(:),G2H2(8),m3h2x2(:,8),heltab2x4(:,:,8))
  call Hloop_SA_Q(ntryL,G1H4(13),ex2(:),G1H2(1),ngX,m3h2x2(:,9),heltab2x4(:,:,9))
  call Hloop_A_Q(ntryL,G1H2(1),23,nMB,G2H2(9),n2h2(7))
  call Hloop_SA_Q(ntryL,G1H4(14),ex2(:),G1H2(1),ngX,m3h2x2(:,10),heltab2x4(:,:,10))
  call Hloop_A_Q(ntryL,G1H2(1),23,nMB,G2H2(10),n2h2(8))
  call Hloop_SA_Q(ntryL,G1H4(15),ex2(:),G1H2(1),ngPbt,m3h2x2(:,11),heltab2x4(:,:,11))
  call Hloop_A_Q(ntryL,G1H2(1),23,nMT,G2H2(11),n2h2(9))
call HGT_OLR(G1H4(16),1,1,4)
call HGT_invQ_OLR(G1H4(16),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(16),-8,nMT,G2H4(3),n2h4(3))
  call Hloop_QV_A(ntryL,G2H4(3),ex4(:),G2H2(12),m3h2x2(:,12),heltab2x4(:,:,12))
  call Hloop_SA_Q(ntryL,G1H4(19),ex2(:),G1H2(1),ngPbt,m3h2x2(:,13),heltab2x4(:,:,13))
  call Hloop_A_Q(ntryL,G1H2(1),23,nMT,G2H2(13),n2h2(10))
  call Hloop_SA_Q(ntryL,G1H4(20),ex2(:),G1H2(1),ngPbt,m3h2x2(:,14),heltab2x4(:,:,14))
  call Hloop_A_Q(ntryL,G1H2(1),23,nMT,G2H2(14),n2h2(11))
  call Hloop_VA_Q(ntryL,G1H4(21),ex2(:),G1H2(1),m3h2x2(:,15),heltab2x4(:,:,15))
  call Hloop_A_Q(ntryL,G1H2(1),23,nMB,G2H2(15),n2h2(12))
call HGT_OLR(G1H4(22),1,1,4)
call HGT_invQ_OLR(G1H4(22),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(22),-8,nMB,G2H4(4),n2h4(4))
  call Hloop_QV_A(ntryL,G2H4(4),ex4(:),G2H2(16),m3h2x2(:,16),heltab2x4(:,:,16))
  call Hloop_VA_Q(ntryL,G1H4(25),ex2(:),G1H2(1),m3h2x2(:,17),heltab2x4(:,:,17))
  call Hloop_A_Q(ntryL,G1H2(1),23,nMB,G2H2(17),n2h2(13))
  call Hloop_VA_Q(ntryL,G1H4(26),ex2(:),G1H2(1),m3h2x2(:,18),heltab2x4(:,:,18))
  call Hloop_A_Q(ntryL,G1H2(1),23,nMB,G2H2(18),n2h2(14))
  call Hloop_ZA_Q(ntryL,G1H4(27),ex2(:),G1H2(1),ngZd,m3h2x2(:,19),heltab2x4(:,:,19))
  call Hloop_A_Q(ntryL,G1H2(1),23,nMB,G2H2(19),n2h2(15))
call HGT_OLR(G1H4(28),1,1,4)
call HGT_invQ_OLR(G1H4(28),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(28),-8,nMB,G2H4(5),n2h4(5))
  call Hloop_QV_A(ntryL,G2H4(5),ex4(:),G2H2(20),m3h2x2(:,20),heltab2x4(:,:,20))
  call Hloop_ZA_Q(ntryL,G1H4(31),ex2(:),G1H2(1),ngZd,m3h2x2(:,21),heltab2x4(:,:,21))
  call Hloop_A_Q(ntryL,G1H2(1),23,nMB,G2H2(21),n2h2(16))
  call Hloop_ZA_Q(ntryL,G1H4(32),ex2(:),G1H2(1),ngZd,m3h2x2(:,22),heltab2x4(:,:,22))
  call Hloop_A_Q(ntryL,G1H2(1),23,nMB,G2H2(22),n2h2(17))
  call Hloop_WA_Q(ntryL,G1H4(33),ex2(:),G1H2(1),m3h2x2(:,23),heltab2x4(:,:,23))
  call Hloop_A_Q(ntryL,G1H2(1),23,nMT,G2H2(23),n2h2(18))
call HGT_OLR(G1H4(34),1,1,4)
call HGT_invQ_OLR(G1H4(34),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(34),-8,nMT,G2H4(6),n2h4(6))
  call Hloop_QV_A(ntryL,G2H4(6),ex4(:),G2H2(24),m3h2x2(:,24),heltab2x4(:,:,24))
  call Hloop_WA_Q(ntryL,G1H4(37),ex2(:),G1H2(1),m3h2x2(:,25),heltab2x4(:,:,25))
  call Hloop_A_Q(ntryL,G1H2(1),23,nMT,G2H2(25),n2h2(19))
  call Hloop_WA_Q(ntryL,G1H4(38),ex2(:),G1H2(1),m3h2x2(:,26),heltab2x4(:,:,26))
  call Hloop_A_Q(ntryL,G1H2(1),23,nMT,G2H2(26),n2h2(20))
  call Hloop_QZ_A(ntryL,G1H6(1),ex3(:),G1H2(1),ngZd,m3h3x2(:,1),heltab2x6(:,:,1))
  call Hloop_Q_A(ntryL,G1H2(1),23,nMB,G2H2(27),n2h2(21))
call HGT_OLR(G1H6(2),1,1,6)
call HGT_invQ_OLR(G1H6(2),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(2),-8,nMB,G2H6(2),n2h6(25))
  call Hloop_AV_Q(ntryL,G2H6(2),ex4(:),G2H3(1),m3h2x3(:,1),heltab2x6(:,:,2))
  call Hloop_QZ_A(ntryL,G1H6(5),ex3(:),G1H2(1),ngZd,m3h3x2(:,2),heltab2x6(:,:,3))
  call Hloop_Q_A(ntryL,G1H2(1),23,nMB,G2H2(28),n2h2(22))
  call Hloop_QZ_A(ntryL,G1H6(6),ex3(:),G1H2(1),ngZd,m3h3x2(:,3),heltab2x6(:,:,4))
  call Hloop_Q_A(ntryL,G1H2(1),23,nMB,G2H2(29),n2h2(23))
  call Hloop_QZ_A(ntryL,G1H6(7),ex3(:),G1H2(1),ngZd,m3h3x2(:,4),heltab2x6(:,:,5))
  call Hloop_Q_A(ntryL,G1H2(1),23,nMB,G2H2(30),n2h2(24))
call HGT_OLR(G1H6(8),1,1,6)
call HGT_invQ_OLR(G1H6(8),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(8),-8,nMB,G2H6(3),n2h6(26))
  call Hloop_AV_Q(ntryL,G2H6(3),ex4(:),G2H3(2),m3h2x3(:,2),heltab2x6(:,:,6))
  call Hloop_QZ_A(ntryL,G1H6(11),ex3(:),G1H2(1),ngZd,m3h3x2(:,5),heltab2x6(:,:,7))
  call Hloop_Q_A(ntryL,G1H2(1),23,nMB,G2H2(31),n2h2(25))
  call Hloop_QZ_A(ntryL,G1H6(12),ex3(:),G1H2(1),ngZd,m3h3x2(:,6),heltab2x6(:,:,8))
  call Hloop_Q_A(ntryL,G1H2(1),23,nMB,G2H2(32),n2h2(26))
  call Hloop_QZ_A(ntryL,G1H6(13),ex3(:),G1H2(1),ngZu,m3h3x2(:,7),heltab2x6(:,:,9))
  call Hloop_Q_A(ntryL,G1H2(1),23,nMT,G2H2(33),n2h2(27))
call HGT_OLR(G1H6(14),1,1,6)
call HGT_invQ_OLR(G1H6(14),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(14),-8,nMT,G2H6(8),n2h6(27))
  call Hloop_AV_Q(ntryL,G2H6(8),ex4(:),G2H3(3),m3h2x3(:,3),heltab2x6(:,:,10))
  call Hloop_QZ_A(ntryL,G1H6(17),ex3(:),G1H2(1),ngZu,m3h3x2(:,8),heltab2x6(:,:,11))
  call Hloop_Q_A(ntryL,G1H2(1),23,nMT,G2H2(34),n2h2(28))
  call Hloop_QZ_A(ntryL,G1H6(18),ex3(:),G1H2(1),ngZu,m3h3x2(:,9),heltab2x6(:,:,12))
  call Hloop_Q_A(ntryL,G1H2(1),23,nMT,G2H2(35),n2h2(29))
  call Hloop_QZ_A(ntryL,G1H6(19),ex3(:),G1H2(1),ngZd,m3h3x2(:,10),heltab2x6(:,:,13))
  call Hloop_Q_A(ntryL,G1H2(1),23,nMB,G2H2(36),n2h2(30))
call HGT_OLR(G1H6(20),1,1,6)
call HGT_invQ_OLR(G1H6(20),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(20),-8,nMB,G2H6(9),n2h6(28))
  call Hloop_AV_Q(ntryL,G2H6(9),ex4(:),G2H3(4),m3h2x3(:,4),heltab2x6(:,:,14))
  call Hloop_QZ_A(ntryL,G1H6(23),ex3(:),G1H2(1),ngZd,m3h3x2(:,11),heltab2x6(:,:,15))
  call Hloop_Q_A(ntryL,G1H2(1),23,nMB,G2H2(37),n2h2(31))
  call Hloop_QZ_A(ntryL,G1H6(24),ex3(:),G1H2(1),ngZd,m3h3x2(:,12),heltab2x6(:,:,16))
  call Hloop_Q_A(ntryL,G1H2(1),23,nMB,G2H2(38),n2h2(32))
  call Hloop_SQ_A(ntryL,G1H4(39),ex1(:),G1H2(1),ngH,m3h2x2(:,27),heltab2x4(:,:,27))
  call Hloop_Q_A(ntryL,G1H2(1),23,nMB,G2H2(39),n2h2(33))
call HGT_OLR(G1H4(40),1,1,4)
call HGT_invQ_OLR(G1H4(40),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(40),-8,nMB,G2H4(7),n2h4(7))
  call Hloop_AV_Q(ntryL,G2H4(7),ex4(:),G2H2(40),m3h2x2(:,28),heltab2x4(:,:,28))
  call Hloop_SQ_A(ntryL,G1H4(43),ex1(:),G1H2(1),ngH,m3h2x2(:,29),heltab2x4(:,:,29))
  call Hloop_Q_A(ntryL,G1H2(1),23,nMB,G2H2(41),n2h2(34))
  call Hloop_SQ_A(ntryL,G1H4(44),ex1(:),G1H2(1),ngH,m3h2x2(:,30),heltab2x4(:,:,30))
  call Hloop_Q_A(ntryL,G1H2(1),23,nMB,G2H2(42),n2h2(35))
  call Hloop_SQ_A(ntryL,G1H4(45),ex1(:),G1H2(1),ngX,m3h2x2(:,31),heltab2x4(:,:,31))
  call Hloop_Q_A(ntryL,G1H2(1),23,nMB,G2H2(43),n2h2(36))
call HGT_OLR(G1H4(46),1,1,4)
call HGT_invQ_OLR(G1H4(46),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(46),-8,nMB,G2H4(8),n2h4(8))
  call Hloop_AV_Q(ntryL,G2H4(8),ex4(:),G2H2(44),m3h2x2(:,32),heltab2x4(:,:,32))
  call Hloop_SQ_A(ntryL,G1H4(49),ex1(:),G1H2(1),ngX,m3h2x2(:,33),heltab2x4(:,:,33))
  call Hloop_Q_A(ntryL,G1H2(1),23,nMB,G2H2(45),n2h2(37))
  call Hloop_SQ_A(ntryL,G1H4(50),ex1(:),G1H2(1),ngX,m3h2x2(:,34),heltab2x4(:,:,34))
  call Hloop_Q_A(ntryL,G1H2(1),23,nMB,G2H2(46),n2h2(38))
  call Hloop_SQ_A(ntryL,G1H4(51),ex1(:),G1H2(1),ngPtb,m3h2x2(:,35),heltab2x4(:,:,35))
  call Hloop_Q_A(ntryL,G1H2(1),23,nMT,G2H2(47),n2h2(39))
call HGT_OLR(G1H4(52),1,1,4)
call HGT_invQ_OLR(G1H4(52),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(52),-8,nMT,G2H4(9),n2h4(9))
  call Hloop_AV_Q(ntryL,G2H4(9),ex4(:),G2H2(48),m3h2x2(:,36),heltab2x4(:,:,36))
  call Hloop_SQ_A(ntryL,G1H4(55),ex1(:),G1H2(1),ngPtb,m3h2x2(:,37),heltab2x4(:,:,37))
  call Hloop_Q_A(ntryL,G1H2(1),23,nMT,G2H2(49),n2h2(40))
  call Hloop_SQ_A(ntryL,G1H4(56),ex1(:),G1H2(1),ngPtb,m3h2x2(:,38),heltab2x4(:,:,38))
  call Hloop_Q_A(ntryL,G1H2(1),23,nMT,G2H2(50),n2h2(41))
  call Hloop_VQ_A(ntryL,G1H4(57),ex1(:),G1H2(1),m3h2x2(:,39),heltab2x4(:,:,39))
  call Hloop_Q_A(ntryL,G1H2(1),23,nMB,G2H2(51),n2h2(42))
call HGT_OLR(G1H4(58),1,1,4)
call HGT_invQ_OLR(G1H4(58),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(58),-8,nMB,G2H4(10),n2h4(10))
  call Hloop_AV_Q(ntryL,G2H4(10),ex4(:),G2H2(52),m3h2x2(:,40),heltab2x4(:,:,40))
  call Hloop_VQ_A(ntryL,G1H4(61),ex1(:),G1H2(1),m3h2x2(:,41),heltab2x4(:,:,41))
  call Hloop_Q_A(ntryL,G1H2(1),23,nMB,G2H2(53),n2h2(43))
  call Hloop_VQ_A(ntryL,G1H4(62),ex1(:),G1H2(1),m3h2x2(:,42),heltab2x4(:,:,42))
  call Hloop_Q_A(ntryL,G1H2(1),23,nMB,G2H2(54),n2h2(44))
  call Hloop_ZQ_A(ntryL,G1H4(63),ex1(:),G1H2(1),ngZd,m3h2x2(:,43),heltab2x4(:,:,43))
  call Hloop_Q_A(ntryL,G1H2(1),23,nMB,G2H2(55),n2h2(45))
call HGT_OLR(G1H4(64),1,1,4)
call HGT_invQ_OLR(G1H4(64),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(64),-8,nMB,G2H4(11),n2h4(11))
  call Hloop_AV_Q(ntryL,G2H4(11),ex4(:),G2H2(56),m3h2x2(:,44),heltab2x4(:,:,44))
  call Hloop_ZQ_A(ntryL,G1H4(67),ex1(:),G1H2(1),ngZd,m3h2x2(:,45),heltab2x4(:,:,45))
  call Hloop_Q_A(ntryL,G1H2(1),23,nMB,G2H2(57),n2h2(46))
  call Hloop_ZQ_A(ntryL,G1H4(68),ex1(:),G1H2(1),ngZd,m3h2x2(:,46),heltab2x4(:,:,46))
  call Hloop_Q_A(ntryL,G1H2(1),23,nMB,G2H2(58),n2h2(47))
  call Hloop_WQ_A(ntryL,G1H4(69),ex1(:),G1H2(1),m3h2x2(:,47),heltab2x4(:,:,47))
  call Hloop_Q_A(ntryL,G1H2(1),23,nMT,G2H2(59),n2h2(48))
call HGT_OLR(G1H4(70),1,1,4)
call HGT_invQ_OLR(G1H4(70),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(70),-8,nMT,G2H4(12),n2h4(12))
  call Hloop_AV_Q(ntryL,G2H4(12),ex4(:),G2H2(60),m3h2x2(:,48),heltab2x4(:,:,48))
  call Hloop_WQ_A(ntryL,G1H4(73),ex1(:),G1H2(1),m3h2x2(:,49),heltab2x4(:,:,49))
  call Hloop_Q_A(ntryL,G1H2(1),23,nMT,G2H2(61),n2h2(49))
  call Hloop_WQ_A(ntryL,G1H4(74),ex1(:),G1H2(1),m3h2x2(:,50),heltab2x4(:,:,50))
  call Hloop_Q_A(ntryL,G1H2(1),23,nMT,G2H2(62),n2h2(50))
  call Hloop_QV_A(ntryL,G1H6(25),ex4(:),G1H3(1),m3h2x3(:,5),heltab2x6(:,:,17))
  call Hloop_Q_A(ntryL,G1H3(1),27,nMB,G2H3(5),n2h3(1))
call HGT_OLR(G1H6(26),1,1,6)
call HGT_invQ_OLR(G1H6(26),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(26),-4,nMB,G2H6(14),n2h6(29))
  call Hloop_AZ_Q(ntryL,G2H6(14),ex3(:),G2H2(63),ngZd,m3h3x2(:,13),heltab2x6(:,:,18))
  call Hloop_QV_A(ntryL,G1H6(29),ex4(:),G1H3(1),m3h2x3(:,6),heltab2x6(:,:,19))
  call Hloop_Q_A(ntryL,G1H3(1),27,nMB,G2H3(6),n2h3(2))
  call Hloop_QV_A(ntryL,G1H6(30),ex4(:),G1H3(1),m3h2x3(:,7),heltab2x6(:,:,20))
  call Hloop_Q_A(ntryL,G1H3(1),27,nMB,G2H3(7),n2h3(3))
  call Hloop_QV_A(ntryL,G1H6(31),ex4(:),G1H3(1),m3h2x3(:,8),heltab2x6(:,:,21))
  call Hloop_Q_A(ntryL,G1H3(1),27,nMB,G2H3(8),n2h3(4))
call HGT_OLR(G1H6(32),1,1,6)
call HGT_invQ_OLR(G1H6(32),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(32),-4,nMB,G2H6(15),n2h6(30))
  call Hloop_AZ_Q(ntryL,G2H6(15),ex3(:),G2H2(64),ngZd,m3h3x2(:,14),heltab2x6(:,:,22))
  call Hloop_QV_A(ntryL,G1H6(35),ex4(:),G1H3(1),m3h2x3(:,9),heltab2x6(:,:,23))
  call Hloop_Q_A(ntryL,G1H3(1),27,nMB,G2H3(9),n2h3(5))
  call Hloop_QV_A(ntryL,G1H6(36),ex4(:),G1H3(1),m3h2x3(:,10),heltab2x6(:,:,24))
  call Hloop_Q_A(ntryL,G1H3(1),27,nMB,G2H3(10),n2h3(6))
  call Hloop_QV_A(ntryL,G1H6(37),ex4(:),G1H3(1),m3h2x3(:,11),heltab2x6(:,:,25))
  call Hloop_Q_A(ntryL,G1H3(1),27,nMT,G2H3(11),n2h3(7))
call HGT_OLR(G1H6(38),1,1,6)
call HGT_invQ_OLR(G1H6(38),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(38),-4,nMT,G2H6(20),n2h6(31))
  call Hloop_AZ_Q(ntryL,G2H6(20),ex3(:),G2H2(65),ngZu,m3h3x2(:,15),heltab2x6(:,:,26))
  call Hloop_QV_A(ntryL,G1H6(41),ex4(:),G1H3(1),m3h2x3(:,12),heltab2x6(:,:,27))
  call Hloop_Q_A(ntryL,G1H3(1),27,nMT,G2H3(12),n2h3(8))
  call Hloop_QV_A(ntryL,G1H6(42),ex4(:),G1H3(1),m3h2x3(:,13),heltab2x6(:,:,28))
  call Hloop_Q_A(ntryL,G1H3(1),27,nMT,G2H3(13),n2h3(9))
  call Hloop_QV_A(ntryL,G1H6(43),ex4(:),G1H3(1),m3h2x3(:,14),heltab2x6(:,:,29))
  call Hloop_Q_A(ntryL,G1H3(1),27,nMB,G2H3(14),n2h3(10))
call HGT_OLR(G1H6(44),1,1,6)
call HGT_invQ_OLR(G1H6(44),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(44),-4,nMB,G2H6(21),n2h6(32))
  call Hloop_AZ_Q(ntryL,G2H6(21),ex3(:),G2H2(66),ngZd,m3h3x2(:,16),heltab2x6(:,:,30))
  call Hloop_QV_A(ntryL,G1H6(47),ex4(:),G1H3(1),m3h2x3(:,15),heltab2x6(:,:,31))
  call Hloop_Q_A(ntryL,G1H3(1),27,nMB,G2H3(15),n2h3(11))
  call Hloop_QV_A(ntryL,G1H6(48),ex4(:),G1H3(1),m3h2x3(:,16),heltab2x6(:,:,32))
  call Hloop_Q_A(ntryL,G1H3(1),27,nMB,G2H3(16),n2h3(12))
  call Hloop_AZ_Q(ntryL,G1H6(49),ex3(:),G1H2(1),ngZd,m3h3x2(:,17),heltab2x6(:,:,33))
  call Hloop_A_Q(ntryL,G1H2(1),23,nMB,G2H2(67),n2h2(51))
call HGT_OLR(G1H6(50),1,1,6)
call HGT_invQ_OLR(G1H6(50),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(50),-8,nMB,G2H6(1),n2h6(33))
  call Hloop_QV_A(ntryL,G2H6(1),ex4(:),G2H3(17),m3h2x3(:,17),heltab2x6(:,:,34))
  call Hloop_AZ_Q(ntryL,G1H6(53),ex3(:),G1H2(1),ngZd,m3h3x2(:,18),heltab2x6(:,:,35))
  call Hloop_A_Q(ntryL,G1H2(1),23,nMB,G2H2(68),n2h2(52))
  call Hloop_AZ_Q(ntryL,G1H6(54),ex3(:),G1H2(1),ngZd,m3h3x2(:,19),heltab2x6(:,:,36))
  call Hloop_A_Q(ntryL,G1H2(1),23,nMB,G2H2(69),n2h2(53))
  call Hloop_AZ_Q(ntryL,G1H6(55),ex3(:),G1H2(1),ngZd,m3h3x2(:,20),heltab2x6(:,:,37))
  call Hloop_A_Q(ntryL,G1H2(1),23,nMB,G2H2(70),n2h2(54))
call HGT_OLR(G1H6(56),1,1,6)
call HGT_invQ_OLR(G1H6(56),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(56),-8,nMB,G2H6(5),n2h6(34))
  call Hloop_QV_A(ntryL,G2H6(5),ex4(:),G2H3(18),m3h2x3(:,18),heltab2x6(:,:,38))
  call Hloop_AZ_Q(ntryL,G1H6(59),ex3(:),G1H2(1),ngZd,m3h3x2(:,21),heltab2x6(:,:,39))
  call Hloop_A_Q(ntryL,G1H2(1),23,nMB,G2H2(71),n2h2(55))
  call Hloop_AZ_Q(ntryL,G1H6(60),ex3(:),G1H2(1),ngZd,m3h3x2(:,22),heltab2x6(:,:,40))
  call Hloop_A_Q(ntryL,G1H2(1),23,nMB,G2H2(72),n2h2(56))
  call Hloop_AZ_Q(ntryL,G1H6(61),ex3(:),G1H2(1),ngZu,m3h3x2(:,23),heltab2x6(:,:,41))
  call Hloop_A_Q(ntryL,G1H2(1),23,nMT,G2H2(73),n2h2(57))
call HGT_OLR(G1H6(62),1,1,6)
call HGT_invQ_OLR(G1H6(62),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(62),-8,nMT,G2H6(6),n2h6(35))
  call Hloop_QV_A(ntryL,G2H6(6),ex4(:),G2H3(19),m3h2x3(:,19),heltab2x6(:,:,42))
  call Hloop_AZ_Q(ntryL,G1H6(65),ex3(:),G1H2(1),ngZu,m3h3x2(:,24),heltab2x6(:,:,43))
  call Hloop_A_Q(ntryL,G1H2(1),23,nMT,G2H2(74),n2h2(58))
  call Hloop_AZ_Q(ntryL,G1H6(66),ex3(:),G1H2(1),ngZu,m3h3x2(:,25),heltab2x6(:,:,44))
  call Hloop_A_Q(ntryL,G1H2(1),23,nMT,G2H2(75),n2h2(59))
  call Hloop_AZ_Q(ntryL,G1H6(67),ex3(:),G1H2(1),ngZd,m3h3x2(:,26),heltab2x6(:,:,45))
  call Hloop_A_Q(ntryL,G1H2(1),23,nMB,G2H2(76),n2h2(60))
call HGT_OLR(G1H6(68),1,1,6)
call HGT_invQ_OLR(G1H6(68),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(68),-8,nMB,G2H6(4),n2h6(36))
  call Hloop_QV_A(ntryL,G2H6(4),ex4(:),G2H3(20),m3h2x3(:,20),heltab2x6(:,:,46))
  call Hloop_AZ_Q(ntryL,G1H6(71),ex3(:),G1H2(1),ngZd,m3h3x2(:,27),heltab2x6(:,:,47))
  call Hloop_A_Q(ntryL,G1H2(1),23,nMB,G2H2(77),n2h2(61))
  call Hloop_AZ_Q(ntryL,G1H6(72),ex3(:),G1H2(1),ngZd,m3h3x2(:,28),heltab2x6(:,:,48))
  call Hloop_A_Q(ntryL,G1H2(1),23,nMB,G2H2(78),n2h2(62))
  call Hloop_AV_Q(ntryL,G1H6(73),ex4(:),G1H3(1),m3h2x3(:,21),heltab2x6(:,:,49))
  call Hloop_A_Q(ntryL,G1H3(1),27,nMB,G2H3(21),n2h3(13))
call HGT_OLR(G1H6(74),1,1,6)
call HGT_invQ_OLR(G1H6(74),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(74),-4,nMB,G2H6(7),n2h6(37))
  call Hloop_QZ_A(ntryL,G2H6(7),ex3(:),G2H2(79),ngZd,m3h3x2(:,29),heltab2x6(:,:,50))
  call Hloop_AV_Q(ntryL,G1H6(77),ex4(:),G1H3(1),m3h2x3(:,22),heltab2x6(:,:,51))
  call Hloop_A_Q(ntryL,G1H3(1),27,nMB,G2H3(22),n2h3(14))
  call Hloop_AV_Q(ntryL,G1H6(78),ex4(:),G1H3(1),m3h2x3(:,23),heltab2x6(:,:,52))
  call Hloop_A_Q(ntryL,G1H3(1),27,nMB,G2H3(23),n2h3(15))
  call Hloop_AV_Q(ntryL,G1H6(79),ex4(:),G1H3(1),m3h2x3(:,24),heltab2x6(:,:,53))
  call Hloop_A_Q(ntryL,G1H3(1),27,nMB,G2H3(24),n2h3(16))
call HGT_OLR(G1H6(80),1,1,6)
call HGT_invQ_OLR(G1H6(80),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(80),-4,nMB,G2H6(11),n2h6(38))
  call Hloop_QZ_A(ntryL,G2H6(11),ex3(:),G2H2(80),ngZd,m3h3x2(:,30),heltab2x6(:,:,54))
  call Hloop_AV_Q(ntryL,G1H6(83),ex4(:),G1H3(1),m3h2x3(:,25),heltab2x6(:,:,55))
  call Hloop_A_Q(ntryL,G1H3(1),27,nMB,G2H3(25),n2h3(17))
  call Hloop_AV_Q(ntryL,G1H6(84),ex4(:),G1H3(1),m3h2x3(:,26),heltab2x6(:,:,56))
  call Hloop_A_Q(ntryL,G1H3(1),27,nMB,G2H3(26),n2h3(18))
  call Hloop_AV_Q(ntryL,G1H6(85),ex4(:),G1H3(1),m3h2x3(:,27),heltab2x6(:,:,57))
  call Hloop_A_Q(ntryL,G1H3(1),27,nMT,G2H3(27),n2h3(19))
call HGT_OLR(G1H6(86),1,1,6)
call HGT_invQ_OLR(G1H6(86),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(86),-4,nMT,G2H6(12),n2h6(39))
  call Hloop_QZ_A(ntryL,G2H6(12),ex3(:),G2H2(81),ngZu,m3h3x2(:,31),heltab2x6(:,:,58))
  call Hloop_AV_Q(ntryL,G1H6(89),ex4(:),G1H3(1),m3h2x3(:,28),heltab2x6(:,:,59))
  call Hloop_A_Q(ntryL,G1H3(1),27,nMT,G2H3(28),n2h3(20))
  call Hloop_AV_Q(ntryL,G1H6(90),ex4(:),G1H3(1),m3h2x3(:,29),heltab2x6(:,:,60))
  call Hloop_A_Q(ntryL,G1H3(1),27,nMT,G2H3(29),n2h3(21))
  call Hloop_AV_Q(ntryL,G1H6(91),ex4(:),G1H3(1),m3h2x3(:,30),heltab2x6(:,:,61))
  call Hloop_A_Q(ntryL,G1H3(1),27,nMB,G2H3(30),n2h3(22))
call HGT_OLR(G1H6(92),1,1,6)
call HGT_invQ_OLR(G1H6(92),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(92),-4,nMB,G2H6(10),n2h6(40))
  call Hloop_QZ_A(ntryL,G2H6(10),ex3(:),G2H2(82),ngZd,m3h3x2(:,32),heltab2x6(:,:,62))
  call Hloop_AV_Q(ntryL,G1H6(95),ex4(:),G1H3(1),m3h2x3(:,31),heltab2x6(:,:,63))
  call Hloop_A_Q(ntryL,G1H3(1),27,nMB,G2H3(31),n2h3(23))
  call Hloop_AV_Q(ntryL,G1H6(96),ex4(:),G1H3(1),m3h2x3(:,32),heltab2x6(:,:,64))
  call Hloop_A_Q(ntryL,G1H3(1),27,nMB,G2H3(32),n2h3(24))
  call Hloop_SQ_A(ntryL,G1H4(75),ex1(:),G1H2(1),ngH,m3h2x2(:,51),heltab2x4(:,:,51))
  call Hloop_Q_A(ntryL,G1H2(1),23,nMB,G2H2(83),n2h2(63))
call HGT_OLR(G1H4(76),1,1,4)
call HGT_invQ_OLR(G1H4(76),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(76),-8,nMB,G2H4(13),n2h4(13))
  call Hloop_AV_Q(ntryL,G2H4(13),ex4(:),G2H2(84),m3h2x2(:,52),heltab2x4(:,:,52))
  call Hloop_SQ_A(ntryL,G1H4(79),ex1(:),G1H2(1),ngH,m3h2x2(:,53),heltab2x4(:,:,53))
  call Hloop_Q_A(ntryL,G1H2(1),23,nMB,G2H2(85),n2h2(64))
  call Hloop_SQ_A(ntryL,G1H4(80),ex1(:),G1H2(1),ngH,m3h2x2(:,54),heltab2x4(:,:,54))
  call Hloop_Q_A(ntryL,G1H2(1),23,nMB,G2H2(86),n2h2(65))
  call Hloop_SQ_A(ntryL,G1H4(81),ex1(:),G1H2(1),ngX,m3h2x2(:,55),heltab2x4(:,:,55))
  call Hloop_Q_A(ntryL,G1H2(1),23,nMB,G2H2(87),n2h2(66))
call HGT_OLR(G1H4(82),1,1,4)
call HGT_invQ_OLR(G1H4(82),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(82),-8,nMB,G2H4(14),n2h4(14))
  call Hloop_AV_Q(ntryL,G2H4(14),ex4(:),G2H2(88),m3h2x2(:,56),heltab2x4(:,:,56))
  call Hloop_SQ_A(ntryL,G1H4(85),ex1(:),G1H2(1),ngX,m3h2x2(:,57),heltab2x4(:,:,57))
  call Hloop_Q_A(ntryL,G1H2(1),23,nMB,G2H2(89),n2h2(67))
  call Hloop_SQ_A(ntryL,G1H4(86),ex1(:),G1H2(1),ngX,m3h2x2(:,58),heltab2x4(:,:,58))
  call Hloop_Q_A(ntryL,G1H2(1),23,nMB,G2H2(90),n2h2(68))
  call Hloop_SQ_A(ntryL,G1H4(87),ex1(:),G1H2(1),ngPtb,m3h2x2(:,59),heltab2x4(:,:,59))
  call Hloop_Q_A(ntryL,G1H2(1),23,nMT,G2H2(91),n2h2(69))
call HGT_OLR(G1H4(88),1,1,4)
call HGT_invQ_OLR(G1H4(88),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(88),-8,nMT,G2H4(15),n2h4(15))
  call Hloop_AV_Q(ntryL,G2H4(15),ex4(:),G2H2(92),m3h2x2(:,60),heltab2x4(:,:,60))
  call Hloop_SQ_A(ntryL,G1H4(91),ex1(:),G1H2(1),ngPtb,m3h2x2(:,61),heltab2x4(:,:,61))
  call Hloop_Q_A(ntryL,G1H2(1),23,nMT,G2H2(93),n2h2(70))
  call Hloop_SQ_A(ntryL,G1H4(92),ex1(:),G1H2(1),ngPtb,m3h2x2(:,62),heltab2x4(:,:,62))
  call Hloop_Q_A(ntryL,G1H2(1),23,nMT,G2H2(94),n2h2(71))
  call Hloop_WQ_A(ntryL,G1H4(3),ex1(:),G1H2(1),m3h2x2(:,63),heltab2x4(:,:,63))
  call Hloop_Q_A(ntryL,G1H2(1),23,nMT,G2H2(95),n2h2(72))
call HGT_OLR(G1H4(93),1,1,4)
call HGT_invQ_OLR(G1H4(93),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(93),-8,nMT,G2H4(16),n2h4(16))
  call Hloop_AV_Q(ntryL,G2H4(16),ex4(:),G2H2(96),m3h2x2(:,64),heltab2x4(:,:,64))
  call Hloop_WQ_A(ntryL,G1H4(96),ex1(:),G1H2(1),m3h2x2(:,65),heltab2x4(:,:,65))
  call Hloop_Q_A(ntryL,G1H2(1),23,nMT,G2H2(97),n2h2(73))
  call Hloop_WQ_A(ntryL,G1H4(97),ex1(:),G1H2(1),m3h2x2(:,66),heltab2x4(:,:,66))
  call Hloop_Q_A(ntryL,G1H2(1),23,nMT,G2H2(98),n2h2(74))
  call Hloop_SA_Q(ntryL,G1H4(98),ex2(:),G1H2(1),ngX,m3h2x2(:,67),heltab2x4(:,:,67))
  call Hloop_A_Q(ntryL,G1H2(1),23,nMB,G2H2(99),n2h2(75))
call HGT_OLR(G1H4(99),1,1,4)
call HGT_invQ_OLR(G1H4(99),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(99),-8,nMB,G2H4(17),n2h4(17))
  call Hloop_QV_A(ntryL,G2H4(17),ex4(:),G2H2(100),m3h2x2(:,68),heltab2x4(:,:,68))
  call Hloop_SA_Q(ntryL,G1H4(102),ex2(:),G1H2(1),ngX,m3h2x2(:,69),heltab2x4(:,:,69))
  call Hloop_A_Q(ntryL,G1H2(1),23,nMB,G2H2(101),n2h2(76))
  call Hloop_SA_Q(ntryL,G1H4(103),ex2(:),G1H2(1),ngX,m3h2x2(:,70),heltab2x4(:,:,70))
  call Hloop_A_Q(ntryL,G1H2(1),23,nMB,G2H2(102),n2h2(77))
  call Hloop_SA_Q(ntryL,G1H4(104),ex2(:),G1H2(1),ngH,m3h2x2(:,71),heltab2x4(:,:,71))
  call Hloop_A_Q(ntryL,G1H2(1),23,nMB,G2H2(103),n2h2(78))
call HGT_OLR(G1H4(105),1,1,4)
call HGT_invQ_OLR(G1H4(105),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(105),-8,nMB,G2H4(18),n2h4(18))
  call Hloop_QV_A(ntryL,G2H4(18),ex4(:),G2H2(104),m3h2x2(:,72),heltab2x4(:,:,72))
  call Hloop_SA_Q(ntryL,G1H4(108),ex2(:),G1H2(1),ngH,m3h2x2(:,73),heltab2x4(:,:,73))
  call Hloop_A_Q(ntryL,G1H2(1),23,nMB,G2H2(105),n2h2(79))
  call Hloop_SA_Q(ntryL,G1H4(109),ex2(:),G1H2(1),ngH,m3h2x2(:,74),heltab2x4(:,:,74))
  call Hloop_A_Q(ntryL,G1H2(1),23,nMB,G2H2(106),n2h2(80))
  call Hloop_SA_Q(ntryL,G1H4(110),ex2(:),G1H2(1),ngPbt,m3h2x2(:,75),heltab2x4(:,:,75))
  call Hloop_A_Q(ntryL,G1H2(1),23,nMT,G2H2(107),n2h2(81))
call HGT_OLR(G1H4(111),1,1,4)
call HGT_invQ_OLR(G1H4(111),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(111),-8,nMT,G2H4(19),n2h4(19))
  call Hloop_QV_A(ntryL,G2H4(19),ex4(:),G2H2(108),m3h2x2(:,76),heltab2x4(:,:,76))
  call Hloop_SA_Q(ntryL,G1H4(114),ex2(:),G1H2(1),ngPbt,m3h2x2(:,77),heltab2x4(:,:,77))
  call Hloop_A_Q(ntryL,G1H2(1),23,nMT,G2H2(109),n2h2(82))
  call Hloop_SA_Q(ntryL,G1H4(115),ex2(:),G1H2(1),ngPbt,m3h2x2(:,78),heltab2x4(:,:,78))
  call Hloop_A_Q(ntryL,G1H2(1),23,nMT,G2H2(110),n2h2(83))
  call Hloop_WA_Q(ntryL,G1H4(5),ex2(:),G1H2(1),m3h2x2(:,79),heltab2x4(:,:,79))
  call Hloop_A_Q(ntryL,G1H2(1),23,nMT,G2H2(111),n2h2(84))
call HGT_OLR(G1H4(116),1,1,4)
call HGT_invQ_OLR(G1H4(116),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(116),-8,nMT,G2H4(20),n2h4(20))
  call Hloop_QV_A(ntryL,G2H4(20),ex4(:),G2H2(112),m3h2x2(:,80),heltab2x4(:,:,80))
  call Hloop_WA_Q(ntryL,G1H4(119),ex2(:),G1H2(1),m3h2x2(:,81),heltab2x4(:,:,81))
  call Hloop_A_Q(ntryL,G1H2(1),23,nMT,G2H2(113),n2h2(85))
  call Hloop_WA_Q(ntryL,G1H4(120),ex2(:),G1H2(1),m3h2x2(:,82),heltab2x4(:,:,82))
  call Hloop_A_Q(ntryL,G1H2(1),23,nMT,G2H2(114),n2h2(86))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(87),[G2H2(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(99),[G2H2(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(19),[G2H2(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(22),[G2H2(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(23),[G2H2(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(26),[G2H2(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(55),[G2H2(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(58),[G2H2(46)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(59),[G2H2(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(62),[G2H2(50)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(95),[G2H2(91)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(98),[G2H2(94)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(111),[G2H2(107)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(114),[G2H2(110)])
  call Hotf_5pt_reduction(G2H2(87),RedSet_5(7),mass5set(:,10),  & 
G1H2(1),G1H2(2),G1H2(3),G1H2(4),G1H2(5),G1H2(6),2)
  call HG1shiftOLR(G1H2(2),8,2)
  call Hotf_5pt_reduction(G2H2(99),RedSet_5(8),mass5set(:,10),  & 
G1H2(7),G1H2(8),G1H2(9),G1H2(10),G1H2(11),G1H2(12),2)
  call HG1shiftOLR(G1H2(8),8,2)
  call Hotf_5pt_reduction(G2H2(3),RedSet_5(1),mass5set(:,1),  & 
G1H2(13),G1H2(14),G1H2(15),G1H2(16),G1H2(17),G1H2(18),2)
  call HG1shiftOLR(G1H2(14),8,2)
  call Hotf_4pt_reduction(G2H2(6),RedSet_4(1),mass4set(:,1),  & 
G1H2(19),G1H2(20),G1H2(21),G1H2(22),G1H2(23),2)
  call HG1shiftOLR(G1H2(20),10,2)
  call Hotf_5pt_reduction(G2H2(19),RedSet_5(1),mass5set(:,2),  & 
G1H2(24),G1H2(25),G1H2(26),G1H2(27),G1H2(28),G1H2(29),2)
  call HG1shiftOLR(G1H2(25),8,2)
  call Hotf_4pt_reduction(G2H2(22),RedSet_4(1),mass4set(:,2),  & 
G1H2(30),G1H2(31),G1H2(32),G1H2(33),G1H2(34),2)
  call HG1shiftOLR(G1H2(31),10,2)
  call Hotf_5pt_reduction(G2H2(23),RedSet_5(1),mass5set(:,3),  & 
G1H2(35),G1H2(36),G1H2(37),G1H2(38),G1H2(39),G1H2(40),2)
  call HG1shiftOLR(G1H2(36),8,2)
  call Hotf_4pt_reduction(G2H2(26),RedSet_4(1),mass4set(:,3),  & 
G1H2(41),G1H2(42),G1H2(43),G1H2(44),G1H2(45),2)
  call HG1shiftOLR(G1H2(42),10,2)
  call Hotf_5pt_reduction(G2H2(15),RedSet_5(1),mass5set(:,4),  & 
G1H2(46),G1H2(47),G1H2(48),G1H2(49),G1H2(50),G1H2(51),2)
  call HG1shiftOLR(G1H2(47),8,2)
  call Hotf_4pt_reduction(G2H2(18),RedSet_4(1),mass4set(:,4),  & 
G1H2(52),G1H2(53),G1H2(54),G1H2(55),G1H2(56),2)
  call HG1shiftOLR(G1H2(53),10,2)
  call Hotf_5pt_reduction(G2H2(27),RedSet_5(2),mass5set(:,5),  & 
G1H2(57),G1H2(58),G1H2(59),G1H2(60),G1H2(61),G1H2(62),2)
  call HG1shiftOLR(G1H2(58),8,2)
  call Hotf_4pt_reduction(G2H2(29),RedSet_4(2),mass4set(:,5),  & 
G1H2(63),G1H2(64),G1H2(65),G1H2(66),G1H2(67),2)
  call HG1shiftOLR(G1H2(64),12,2)
  call Hotf_5pt_reduction(G2H2(30),RedSet_5(2),mass5set(:,6),  & 
G1H2(68),G1H2(69),G1H2(70),G1H2(71),G1H2(72),G1H2(73),2)
  call HG1shiftOLR(G1H2(69),8,2)
  call Hotf_4pt_reduction(G2H2(32),RedSet_4(2),mass4set(:,6),  & 
G1H2(74),G1H2(75),G1H2(76),G1H2(77),G1H2(78),2)
  call HG1shiftOLR(G1H2(75),12,2)
  call Hotf_5pt_reduction(G2H2(33),RedSet_5(2),mass5set(:,7),  & 
G1H2(79),G1H2(80),G1H2(81),G1H2(82),G1H2(83),G1H2(84),2)
  call HG1shiftOLR(G1H2(80),8,2)
  call Hotf_4pt_reduction(G2H2(35),RedSet_4(2),mass4set(:,7),  & 
G1H2(85),G1H2(86),G1H2(87),G1H2(88),G1H2(89),2)
  call HG1shiftOLR(G1H2(86),12,2)
  call Hotf_5pt_reduction(G2H2(36),RedSet_5(2),mass5set(:,8),  & 
G1H2(90),G1H2(91),G1H2(92),G1H2(93),G1H2(94),G1H2(95),2)
  call HG1shiftOLR(G1H2(91),8,2)
  call Hotf_4pt_reduction(G2H2(38),RedSet_4(2),mass4set(:,8),  & 
G1H2(96),G1H2(97),G1H2(98),G1H2(99),G1H2(100),2)
  call HG1shiftOLR(G1H2(97),12,2)
  call Hotf_5pt_reduction(G2H2(39),RedSet_5(3),mass5set(:,1),  & 
G1H2(101),G1H2(102),G1H2(103),G1H2(104),G1H2(105),G1H2(106),2)
  call HG1shiftOLR(G1H2(102),8,2)
  call Hotf_4pt_reduction(G2H2(42),RedSet_4(3),mass4set(:,1),  & 
G1H2(107),G1H2(108),G1H2(109),G1H2(110),G1H2(111),2)
  call HG1shiftOLR(G1H2(108),9,2)
  call Hotf_5pt_reduction(G2H2(55),RedSet_5(3),mass5set(:,2),  & 
G1H2(112),G1H2(113),G1H2(114),G1H2(115),G1H2(116),G1H2(117),2)
  call HG1shiftOLR(G1H2(113),8,2)
  call Hotf_4pt_reduction(G2H2(58),RedSet_4(3),mass4set(:,2),  & 
G1H2(118),G1H2(119),G1H2(120),G1H2(121),G1H2(122),2)
  call HG1shiftOLR(G1H2(119),9,2)
  call Hotf_5pt_reduction(G2H2(59),RedSet_5(3),mass5set(:,3),  & 
G1H2(123),G1H2(124),G1H2(125),G1H2(126),G1H2(127),G1H2(128),2)
  call HG1shiftOLR(G1H2(124),8,2)
  call Hotf_4pt_reduction(G2H2(62),RedSet_4(3),mass4set(:,3),  & 
G1H2(129),G1H2(130),G1H2(131),G1H2(132),G1H2(133),2)
  call HG1shiftOLR(G1H2(130),9,2)
  call Hotf_5pt_reduction(G2H2(51),RedSet_5(3),mass5set(:,4),  & 
G1H2(134),G1H2(135),G1H2(136),G1H2(137),G1H2(138),G1H2(139),2)
  call HG1shiftOLR(G1H2(135),8,2)
  call Hotf_4pt_reduction(G2H2(54),RedSet_4(3),mass4set(:,4),  & 
G1H2(140),G1H2(141),G1H2(142),G1H2(143),G1H2(144),2)
  call HG1shiftOLR(G1H2(141),9,2)
  call Hotf_5pt_reduction(G2H3(5),RedSet_5(4),mass5set(:,5),  & 
G1H3(1),G1H3(2),G1H3(3),G1H3(4),G1H3(5),G1H3(6),3)
  call HG1shiftOLR(G1H3(2),4,3)
  call Hotf_4pt_reduction(G2H3(7),RedSet_4(2),mass4set(:,5),  & 
G1H3(7),G1H3(8),G1H3(9),G1H3(10),G1H3(11),3)
  call HG1shiftOLR(G1H3(8),12,3)
  call Hotf_5pt_reduction(G2H3(8),RedSet_5(4),mass5set(:,6),  & 
G1H3(12),G1H3(13),G1H3(14),G1H3(15),G1H3(16),G1H3(17),3)
  call HG1shiftOLR(G1H3(13),4,3)
  call Hotf_4pt_reduction(G2H3(10),RedSet_4(2),mass4set(:,6),  & 
G1H3(18),G1H3(19),G1H3(20),G1H3(21),G1H3(22),3)
  call HG1shiftOLR(G1H3(19),12,3)
  call Hotf_5pt_reduction(G2H3(11),RedSet_5(4),mass5set(:,7),  & 
G1H3(23),G1H3(24),G1H3(25),G1H3(26),G1H3(27),G1H3(28),3)
  call HG1shiftOLR(G1H3(24),4,3)
  call Hotf_4pt_reduction(G2H3(13),RedSet_4(2),mass4set(:,7),  & 
G1H3(29),G1H3(30),G1H3(31),G1H3(32),G1H3(33),3)
  call HG1shiftOLR(G1H3(30),12,3)
  call Hotf_5pt_reduction(G2H3(14),RedSet_5(4),mass5set(:,8),  & 
G1H3(34),G1H3(35),G1H3(36),G1H3(37),G1H3(38),G1H3(39),3)
  call HG1shiftOLR(G1H3(35),4,3)
  call Hotf_4pt_reduction(G2H3(16),RedSet_4(2),mass4set(:,8),  & 
G1H3(40),G1H3(41),G1H3(42),G1H3(43),G1H3(44),3)
  call HG1shiftOLR(G1H3(41),12,3)
  call Hotf_5pt_reduction(G2H2(67),RedSet_5(5),mass5set(:,5),  & 
G1H2(145),G1H2(146),G1H2(147),G1H2(148),G1H2(149),G1H2(150),2)
  call HG1shiftOLR(G1H2(146),8,2)
  call Hotf_4pt_reduction(G2H2(69),RedSet_4(4),mass4set(:,5),  & 
G1H2(151),G1H2(152),G1H2(153),G1H2(154),G1H2(155),2)
  call HG1shiftOLR(G1H2(152),12,2)
  call Hotf_5pt_reduction(G2H2(70),RedSet_5(5),mass5set(:,6),  & 
G1H2(156),G1H2(157),G1H2(158),G1H2(159),G1H2(160),G1H2(161),2)
  call HG1shiftOLR(G1H2(157),8,2)
  call Hotf_4pt_reduction(G2H2(72),RedSet_4(4),mass4set(:,6),  & 
G1H2(162),G1H2(163),G1H2(164),G1H2(165),G1H2(166),2)
  call HG1shiftOLR(G1H2(163),12,2)
  call Hotf_5pt_reduction(G2H2(73),RedSet_5(5),mass5set(:,7),  & 
G1H2(167),G1H2(168),G1H2(169),G1H2(170),G1H2(171),G1H2(172),2)
  call HG1shiftOLR(G1H2(168),8,2)
  call Hotf_4pt_reduction(G2H2(75),RedSet_4(4),mass4set(:,7),  & 
G1H2(173),G1H2(174),G1H2(175),G1H2(176),G1H2(177),2)
  call HG1shiftOLR(G1H2(174),12,2)
  call Hotf_5pt_reduction(G2H2(76),RedSet_5(5),mass5set(:,8),  & 
G1H2(178),G1H2(179),G1H2(180),G1H2(181),G1H2(182),G1H2(183),2)
  call HG1shiftOLR(G1H2(179),8,2)
  call Hotf_4pt_reduction(G2H2(78),RedSet_4(4),mass4set(:,8),  & 
G1H2(184),G1H2(185),G1H2(186),G1H2(187),G1H2(188),2)
  call HG1shiftOLR(G1H2(185),12,2)
  call Hotf_5pt_reduction(G2H3(21),RedSet_5(6),mass5set(:,5),  & 
G1H3(45),G1H3(46),G1H3(47),G1H3(48),G1H3(49),G1H3(50),3)
  call HG1shiftOLR(G1H3(46),4,3)
  call Hotf_4pt_reduction(G2H3(23),RedSet_4(4),mass4set(:,5),  & 
G1H3(51),G1H3(52),G1H3(53),G1H3(54),G1H3(55),3)
  call HG1shiftOLR(G1H3(52),12,3)
  call Hotf_5pt_reduction(G2H3(24),RedSet_5(6),mass5set(:,6),  & 
G1H3(56),G1H3(57),G1H3(58),G1H3(59),G1H3(60),G1H3(61),3)
  call HG1shiftOLR(G1H3(57),4,3)
  call Hotf_4pt_reduction(G2H3(26),RedSet_4(4),mass4set(:,6),  & 
G1H3(62),G1H3(63),G1H3(64),G1H3(65),G1H3(66),3)
  call HG1shiftOLR(G1H3(63),12,3)
  call Hotf_5pt_reduction(G2H3(27),RedSet_5(6),mass5set(:,7),  & 
G1H3(67),G1H3(68),G1H3(69),G1H3(70),G1H3(71),G1H3(72),3)
  call HG1shiftOLR(G1H3(68),4,3)
  call Hotf_4pt_reduction(G2H3(29),RedSet_4(4),mass4set(:,7),  & 
G1H3(73),G1H3(74),G1H3(75),G1H3(76),G1H3(77),3)
  call HG1shiftOLR(G1H3(74),12,3)
  call Hotf_5pt_reduction(G2H3(30),RedSet_5(6),mass5set(:,8),  & 
G1H3(78),G1H3(79),G1H3(80),G1H3(81),G1H3(82),G1H3(83),3)
  call HG1shiftOLR(G1H3(79),4,3)
  call Hotf_4pt_reduction(G2H3(32),RedSet_4(4),mass4set(:,8),  & 
G1H3(84),G1H3(85),G1H3(86),G1H3(87),G1H3(88),3)
  call HG1shiftOLR(G1H3(85),12,3)
  call Hotf_5pt_reduction(G2H2(83),RedSet_5(7),mass5set(:,9),  & 
G1H2(189),G1H2(190),G1H2(191),G1H2(192),G1H2(193),G1H2(194),2)
  call HG1shiftOLR(G1H2(190),8,2)
  call Hotf_4pt_reduction(G2H2(86),RedSet_4(5),mass4set(:,9),  & 
G1H2(195),G1H2(196),G1H2(197),G1H2(198),G1H2(199),2)
  call HG1shiftOLR(G1H2(196),9,2)
  call Hotf_4pt_reduction(G2H2(90),RedSet_4(5),mass4set(:,10),  & 
G1H2(200),G1H2(201),G1H2(202),G1H2(203),G1H2(204),2)
  call HG1shiftOLR(G1H2(201),9,2)
  call Hotf_5pt_reduction(G2H2(95),RedSet_5(7),mass5set(:,11),  & 
G1H2(205),G1H2(206),G1H2(207),G1H2(208),G1H2(209),G1H2(210),2)
  call HG1shiftOLR(G1H2(206),8,2)
  call Hotf_4pt_reduction(G2H2(98),RedSet_4(5),mass4set(:,11),  & 
G1H2(211),G1H2(212),G1H2(213),G1H2(214),G1H2(215),2)
  call HG1shiftOLR(G1H2(212),9,2)
  call Hotf_4pt_reduction(G2H2(102),RedSet_4(6),mass4set(:,10),  & 
G1H2(216),G1H2(217),G1H2(218),G1H2(219),G1H2(220),2)
  call HG1shiftOLR(G1H2(217),10,2)
  call Hotf_5pt_reduction(G2H2(103),RedSet_5(8),mass5set(:,9),  & 
G1H2(221),G1H2(222),G1H2(223),G1H2(224),G1H2(225),G1H2(226),2)
  call HG1shiftOLR(G1H2(222),8,2)
  call Hotf_4pt_reduction(G2H2(106),RedSet_4(6),mass4set(:,9),  & 
G1H2(227),G1H2(228),G1H2(229),G1H2(230),G1H2(231),2)
  call HG1shiftOLR(G1H2(228),10,2)
  call Hotf_5pt_reduction(G2H2(111),RedSet_5(8),mass5set(:,11),  & 
G1H2(232),G1H2(233),G1H2(234),G1H2(235),G1H2(236),G1H2(237),2)
  call HG1shiftOLR(G1H2(233),8,2)
  call Hotf_4pt_reduction(G2H2(114),RedSet_4(6),mass4set(:,11),  & 
G1H2(238),G1H2(239),G1H2(240),G1H2(241),G1H2(242),2)
  call HG1shiftOLR(G1H2(239),10,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(200),[G1H2(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(216),[G1H2(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(19),[G1H2(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(30),[G1H2(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(41),[G1H2(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(52),[G1H2(51)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(63),[G1H2(62)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(74),[G1H2(73)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(85),[G1H2(84)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(96),[G1H2(95)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(107),[G1H2(106)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(118),[G1H2(117)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(129),[G1H2(128)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(140),[G1H2(139)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(7),[G1H3(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(18),[G1H3(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(29),[G1H3(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(40),[G1H3(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(151),[G1H2(150)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(162),[G1H2(161)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(173),[G1H2(172)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(184),[G1H2(183)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(51),[G1H3(50)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(62),[G1H3(61)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(73),[G1H3(72)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(84),[G1H3(83)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(195),[G1H2(194)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(211),[G1H2(210)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(227),[G1H2(226)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(238),[G1H2(237)])
  call Hloop_QV_A(ntryL,G1H2(1),ex4(:),G1H1(1),m3h2x1(:,1),heltab2x2(:,:,1))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(1),n2h1(1))
  call Hloop_QV_A(ntryL,G1H2(2),ex4(:),G1H1(1),m3h2x1(:,2),heltab2x2(:,:,2))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(2),n2h1(2))
  call Hloop_QV_A(ntryL,G1H2(200),ex4(:),G1H1(1),m3h2x1(:,3),heltab2x2(:,:,3))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(3),n2h1(3))
  call Hloop_AV_Q(ntryL,G1H2(7),ex4(:),G1H1(1),m3h2x1(:,4),heltab2x2(:,:,4))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(4),n2h1(4))
  call Hloop_AV_Q(ntryL,G1H2(8),ex4(:),G1H1(1),m3h2x1(:,5),heltab2x2(:,:,5))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(5),n2h1(5))
  call Hloop_AV_Q(ntryL,G1H2(216),ex4(:),G1H1(1),m3h2x1(:,6),heltab2x2(:,:,6))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(6),n2h1(6))
  call Hloop_AV_Q(ntryL,G1H2(13),ex4(:),G1H1(1),m3h2x1(:,7),heltab2x2(:,:,7))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(7),n2h1(7))
  call Hloop_AV_Q(ntryL,G1H2(14),ex4(:),G1H1(1),m3h2x1(:,8),heltab2x2(:,:,8))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(8),n2h1(8))
  call Hloop_AV_Q(ntryL,G1H2(19),ex4(:),G1H1(1),m3h2x1(:,9),heltab2x2(:,:,9))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(9),n2h1(9))
  call Hloop_AV_Q(ntryL,G1H2(20),ex4(:),G1H1(1),m3h2x1(:,10),heltab2x2(:,:,10))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,nMB,G2tensor(10),n2h1(10))
  call Hloop_AV_Q(ntryL,G1H2(24),ex4(:),G1H1(1),m3h2x1(:,11),heltab2x2(:,:,11))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(11),n2h1(11))
  call Hloop_AV_Q(ntryL,G1H2(25),ex4(:),G1H1(1),m3h2x1(:,12),heltab2x2(:,:,12))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(12),n2h1(12))
  call Hloop_AV_Q(ntryL,G1H2(30),ex4(:),G1H1(1),m3h2x1(:,13),heltab2x2(:,:,13))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(13),n2h1(13))
  call Hloop_AV_Q(ntryL,G1H2(31),ex4(:),G1H1(1),m3h2x1(:,14),heltab2x2(:,:,14))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,nMB,G2tensor(14),n2h1(14))
  call Hloop_AV_Q(ntryL,G1H2(35),ex4(:),G1H1(1),m3h2x1(:,15),heltab2x2(:,:,15))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(15),n2h1(15))
  call Hloop_AV_Q(ntryL,G1H2(36),ex4(:),G1H1(1),m3h2x1(:,16),heltab2x2(:,:,16))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(16),n2h1(16))
  call Hloop_AV_Q(ntryL,G1H2(41),ex4(:),G1H1(1),m3h2x1(:,17),heltab2x2(:,:,17))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(17),n2h1(17))
  call Hloop_AV_Q(ntryL,G1H2(42),ex4(:),G1H1(1),m3h2x1(:,18),heltab2x2(:,:,18))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,nMT,G2tensor(18),n2h1(18))
  call Hloop_AV_Q(ntryL,G1H2(46),ex4(:),G1H1(1),m3h2x1(:,19),heltab2x2(:,:,19))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(19),n2h1(19))
  call Hloop_AV_Q(ntryL,G1H2(47),ex4(:),G1H1(1),m3h2x1(:,20),heltab2x2(:,:,20))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(20),n2h1(20))
  call Hloop_AV_Q(ntryL,G1H2(52),ex4(:),G1H1(1),m3h2x1(:,21),heltab2x2(:,:,21))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(21),n2h1(21))
  call Hloop_AV_Q(ntryL,G1H2(53),ex4(:),G1H1(1),m3h2x1(:,22),heltab2x2(:,:,22))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,nMB,G2tensor(22),n2h1(22))
  call Hloop_QV_A(ntryL,G1H2(57),ex4(:),G1H1(1),m3h2x1(:,23),heltab2x2(:,:,23))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(23),n2h1(23))
  call Hloop_QV_A(ntryL,G1H2(58),ex4(:),G1H1(1),m3h2x1(:,24),heltab2x2(:,:,24))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(24),n2h1(24))
  call Hloop_QV_A(ntryL,G1H2(63),ex4(:),G1H1(1),m3h2x1(:,25),heltab2x2(:,:,25))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(25),n2h1(25))
  call Hloop_QV_A(ntryL,G1H2(64),ex4(:),G1H1(1),m3h2x1(:,26),heltab2x2(:,:,26))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,nMB,G2tensor(26),n2h1(26))
  call Hloop_QV_A(ntryL,G1H2(68),ex4(:),G1H1(1),m3h2x1(:,27),heltab2x2(:,:,27))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(27),n2h1(27))
  call Hloop_QV_A(ntryL,G1H2(69),ex4(:),G1H1(1),m3h2x1(:,28),heltab2x2(:,:,28))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(28),n2h1(28))
  call Hloop_QV_A(ntryL,G1H2(74),ex4(:),G1H1(1),m3h2x1(:,29),heltab2x2(:,:,29))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(29),n2h1(29))
  call Hloop_QV_A(ntryL,G1H2(75),ex4(:),G1H1(1),m3h2x1(:,30),heltab2x2(:,:,30))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,nMB,G2tensor(30),n2h1(30))
  call Hloop_QV_A(ntryL,G1H2(79),ex4(:),G1H1(1),m3h2x1(:,31),heltab2x2(:,:,31))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(31),n2h1(31))
  call Hloop_QV_A(ntryL,G1H2(80),ex4(:),G1H1(1),m3h2x1(:,32),heltab2x2(:,:,32))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(32),n2h1(32))
  call Hloop_QV_A(ntryL,G1H2(85),ex4(:),G1H1(1),m3h2x1(:,33),heltab2x2(:,:,33))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(33),n2h1(33))
  call Hloop_QV_A(ntryL,G1H2(86),ex4(:),G1H1(1),m3h2x1(:,34),heltab2x2(:,:,34))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,nMT,G2tensor(34),n2h1(34))
  call Hloop_QV_A(ntryL,G1H2(90),ex4(:),G1H1(1),m3h2x1(:,35),heltab2x2(:,:,35))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(35),n2h1(35))
  call Hloop_QV_A(ntryL,G1H2(91),ex4(:),G1H1(1),m3h2x1(:,36),heltab2x2(:,:,36))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(36),n2h1(36))
  call Hloop_QV_A(ntryL,G1H2(96),ex4(:),G1H1(1),m3h2x1(:,37),heltab2x2(:,:,37))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(37),n2h1(37))
  call Hloop_QV_A(ntryL,G1H2(97),ex4(:),G1H1(1),m3h2x1(:,38),heltab2x2(:,:,38))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,nMB,G2tensor(38),n2h1(38))
  call Hloop_QV_A(ntryL,G1H2(101),ex4(:),G1H1(1),m3h2x1(:,39),heltab2x2(:,:,39))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(39),n2h1(39))
  call Hloop_QV_A(ntryL,G1H2(102),ex4(:),G1H1(1),m3h2x1(:,40),heltab2x2(:,:,40))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(40),n2h1(40))
  call Hloop_QV_A(ntryL,G1H2(107),ex4(:),G1H1(1),m3h2x1(:,41),heltab2x2(:,:,41))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(41),n2h1(41))
  call Hloop_QV_A(ntryL,G1H2(108),ex4(:),G1H1(1),m3h2x1(:,42),heltab2x2(:,:,42))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,nMB,G2tensor(42),n2h1(42))
  call Hloop_QV_A(ntryL,G1H2(112),ex4(:),G1H1(1),m3h2x1(:,43),heltab2x2(:,:,43))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(43),n2h1(43))
  call Hloop_QV_A(ntryL,G1H2(113),ex4(:),G1H1(1),m3h2x1(:,44),heltab2x2(:,:,44))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(44),n2h1(44))
  call Hloop_QV_A(ntryL,G1H2(118),ex4(:),G1H1(1),m3h2x1(:,45),heltab2x2(:,:,45))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(45),n2h1(45))
  call Hloop_QV_A(ntryL,G1H2(119),ex4(:),G1H1(1),m3h2x1(:,46),heltab2x2(:,:,46))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,nMB,G2tensor(46),n2h1(46))
  call Hloop_QV_A(ntryL,G1H2(123),ex4(:),G1H1(1),m3h2x1(:,47),heltab2x2(:,:,47))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(47),n2h1(47))
  call Hloop_QV_A(ntryL,G1H2(124),ex4(:),G1H1(1),m3h2x1(:,48),heltab2x2(:,:,48))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(48),n2h1(48))
  call Hloop_QV_A(ntryL,G1H2(129),ex4(:),G1H1(1),m3h2x1(:,49),heltab2x2(:,:,49))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(49),n2h1(49))
  call Hloop_QV_A(ntryL,G1H2(130),ex4(:),G1H1(1),m3h2x1(:,50),heltab2x2(:,:,50))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,nMT,G2tensor(50),n2h1(50))
  call Hloop_QV_A(ntryL,G1H2(134),ex4(:),G1H1(1),m3h2x1(:,51),heltab2x2(:,:,51))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(51),n2h1(51))
  call Hloop_QV_A(ntryL,G1H2(135),ex4(:),G1H1(1),m3h2x1(:,52),heltab2x2(:,:,52))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(52),n2h1(52))
  call Hloop_QV_A(ntryL,G1H2(140),ex4(:),G1H1(1),m3h2x1(:,53),heltab2x2(:,:,53))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(53),n2h1(53))
  call Hloop_QV_A(ntryL,G1H2(141),ex4(:),G1H1(1),m3h2x1(:,54),heltab2x2(:,:,54))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,nMB,G2tensor(54),n2h1(54))
  call Hloop_QZ_A(ntryL,G1H3(1),ex3(:),G1H1(1),ngZd,m3h3x1(:,1),heltab2x3(:,:,1))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(55),n2h1(55))
  call Hloop_QZ_A(ntryL,G1H3(2),ex3(:),G1H1(1),ngZd,m3h3x1(:,2),heltab2x3(:,:,2))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(56),n2h1(56))
  call Hloop_QZ_A(ntryL,G1H3(7),ex3(:),G1H1(1),ngZd,m3h3x1(:,3),heltab2x3(:,:,3))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(57),n2h1(57))
  call Hloop_QZ_A(ntryL,G1H3(8),ex3(:),G1H1(1),ngZd,m3h3x1(:,4),heltab2x3(:,:,4))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,nMB,G2tensor(58),n2h1(58))
  call Hloop_QZ_A(ntryL,G1H3(12),ex3(:),G1H1(1),ngZd,m3h3x1(:,5),heltab2x3(:,:,5))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(59),n2h1(59))
  call Hloop_QZ_A(ntryL,G1H3(13),ex3(:),G1H1(1),ngZd,m3h3x1(:,6),heltab2x3(:,:,6))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(60),n2h1(60))
  call Hloop_QZ_A(ntryL,G1H3(18),ex3(:),G1H1(1),ngZd,m3h3x1(:,7),heltab2x3(:,:,7))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(61),n2h1(61))
  call Hloop_QZ_A(ntryL,G1H3(19),ex3(:),G1H1(1),ngZd,m3h3x1(:,8),heltab2x3(:,:,8))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,nMB,G2tensor(62),n2h1(62))
  call Hloop_QZ_A(ntryL,G1H3(23),ex3(:),G1H1(1),ngZu,m3h3x1(:,9),heltab2x3(:,:,9))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(63),n2h1(63))
  call Hloop_QZ_A(ntryL,G1H3(24),ex3(:),G1H1(1),ngZu,m3h3x1(:,10),heltab2x3(:,:,10))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(64),n2h1(64))
  call Hloop_QZ_A(ntryL,G1H3(29),ex3(:),G1H1(1),ngZu,m3h3x1(:,11),heltab2x3(:,:,11))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(65),n2h1(65))
  call Hloop_QZ_A(ntryL,G1H3(30),ex3(:),G1H1(1),ngZu,m3h3x1(:,12),heltab2x3(:,:,12))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,nMT,G2tensor(66),n2h1(66))
  call Hloop_QZ_A(ntryL,G1H3(34),ex3(:),G1H1(1),ngZd,m3h3x1(:,13),heltab2x3(:,:,13))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(67),n2h1(67))
  call Hloop_QZ_A(ntryL,G1H3(35),ex3(:),G1H1(1),ngZd,m3h3x1(:,14),heltab2x3(:,:,14))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(68),n2h1(68))
  call Hloop_QZ_A(ntryL,G1H3(40),ex3(:),G1H1(1),ngZd,m3h3x1(:,15),heltab2x3(:,:,15))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(69),n2h1(69))
  call Hloop_QZ_A(ntryL,G1H3(41),ex3(:),G1H1(1),ngZd,m3h3x1(:,16),heltab2x3(:,:,16))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,nMB,G2tensor(70),n2h1(70))
  call Hloop_AV_Q(ntryL,G1H2(145),ex4(:),G1H1(1),m3h2x1(:,55),heltab2x2(:,:,55))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(71),n2h1(71))
  call Hloop_AV_Q(ntryL,G1H2(146),ex4(:),G1H1(1),m3h2x1(:,56),heltab2x2(:,:,56))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(72),n2h1(72))
  call Hloop_AV_Q(ntryL,G1H2(151),ex4(:),G1H1(1),m3h2x1(:,57),heltab2x2(:,:,57))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(73),n2h1(73))
  call Hloop_AV_Q(ntryL,G1H2(152),ex4(:),G1H1(1),m3h2x1(:,58),heltab2x2(:,:,58))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,nMB,G2tensor(74),n2h1(74))
  call Hloop_AV_Q(ntryL,G1H2(156),ex4(:),G1H1(1),m3h2x1(:,59),heltab2x2(:,:,59))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(75),n2h1(75))
  call Hloop_AV_Q(ntryL,G1H2(157),ex4(:),G1H1(1),m3h2x1(:,60),heltab2x2(:,:,60))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(76),n2h1(76))
  call Hloop_AV_Q(ntryL,G1H2(162),ex4(:),G1H1(1),m3h2x1(:,61),heltab2x2(:,:,61))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(77),n2h1(77))
  call Hloop_AV_Q(ntryL,G1H2(163),ex4(:),G1H1(1),m3h2x1(:,62),heltab2x2(:,:,62))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,nMB,G2tensor(78),n2h1(78))
  call Hloop_AV_Q(ntryL,G1H2(167),ex4(:),G1H1(1),m3h2x1(:,63),heltab2x2(:,:,63))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(79),n2h1(79))
  call Hloop_AV_Q(ntryL,G1H2(168),ex4(:),G1H1(1),m3h2x1(:,64),heltab2x2(:,:,64))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(80),n2h1(80))
  call Hloop_AV_Q(ntryL,G1H2(173),ex4(:),G1H1(1),m3h2x1(:,65),heltab2x2(:,:,65))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(81),n2h1(81))
  call Hloop_AV_Q(ntryL,G1H2(174),ex4(:),G1H1(1),m3h2x1(:,66),heltab2x2(:,:,66))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,nMT,G2tensor(82),n2h1(82))
  call Hloop_AV_Q(ntryL,G1H2(178),ex4(:),G1H1(1),m3h2x1(:,67),heltab2x2(:,:,67))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(83),n2h1(83))
  call Hloop_AV_Q(ntryL,G1H2(179),ex4(:),G1H1(1),m3h2x1(:,68),heltab2x2(:,:,68))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(84),n2h1(84))
  call Hloop_AV_Q(ntryL,G1H2(184),ex4(:),G1H1(1),m3h2x1(:,69),heltab2x2(:,:,69))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(85),n2h1(85))
  call Hloop_AV_Q(ntryL,G1H2(185),ex4(:),G1H1(1),m3h2x1(:,70),heltab2x2(:,:,70))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,nMB,G2tensor(86),n2h1(86))
  call Hloop_AZ_Q(ntryL,G1H3(45),ex3(:),G1H1(1),ngZd,m3h3x1(:,17),heltab2x3(:,:,17))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(87),n2h1(87))
  call Hloop_AZ_Q(ntryL,G1H3(46),ex3(:),G1H1(1),ngZd,m3h3x1(:,18),heltab2x3(:,:,18))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(88),n2h1(88))
  call Hloop_AZ_Q(ntryL,G1H3(51),ex3(:),G1H1(1),ngZd,m3h3x1(:,19),heltab2x3(:,:,19))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(89),n2h1(89))
  call Hloop_AZ_Q(ntryL,G1H3(52),ex3(:),G1H1(1),ngZd,m3h3x1(:,20),heltab2x3(:,:,20))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,nMB,G2tensor(90),n2h1(90))
  call Hloop_AZ_Q(ntryL,G1H3(56),ex3(:),G1H1(1),ngZd,m3h3x1(:,21),heltab2x3(:,:,21))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(91),n2h1(91))
  call Hloop_AZ_Q(ntryL,G1H3(57),ex3(:),G1H1(1),ngZd,m3h3x1(:,22),heltab2x3(:,:,22))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(92),n2h1(92))
  call Hloop_AZ_Q(ntryL,G1H3(62),ex3(:),G1H1(1),ngZd,m3h3x1(:,23),heltab2x3(:,:,23))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(93),n2h1(93))
  call Hloop_AZ_Q(ntryL,G1H3(63),ex3(:),G1H1(1),ngZd,m3h3x1(:,24),heltab2x3(:,:,24))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,nMB,G2tensor(94),n2h1(94))
  call Hloop_AZ_Q(ntryL,G1H3(67),ex3(:),G1H1(1),ngZu,m3h3x1(:,25),heltab2x3(:,:,25))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(95),n2h1(95))
  call Hloop_AZ_Q(ntryL,G1H3(68),ex3(:),G1H1(1),ngZu,m3h3x1(:,26),heltab2x3(:,:,26))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(96),n2h1(96))
  call Hloop_AZ_Q(ntryL,G1H3(73),ex3(:),G1H1(1),ngZu,m3h3x1(:,27),heltab2x3(:,:,27))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(97),n2h1(97))
  call Hloop_AZ_Q(ntryL,G1H3(74),ex3(:),G1H1(1),ngZu,m3h3x1(:,28),heltab2x3(:,:,28))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,nMT,G2tensor(98),n2h1(98))
  call Hloop_AZ_Q(ntryL,G1H3(78),ex3(:),G1H1(1),ngZd,m3h3x1(:,29),heltab2x3(:,:,29))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(99),n2h1(99))
  call Hloop_AZ_Q(ntryL,G1H3(79),ex3(:),G1H1(1),ngZd,m3h3x1(:,30),heltab2x3(:,:,30))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(100),n2h1(100))
  call Hloop_AZ_Q(ntryL,G1H3(84),ex3(:),G1H1(1),ngZd,m3h3x1(:,31),heltab2x3(:,:,31))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(101),n2h1(101))
  call Hloop_AZ_Q(ntryL,G1H3(85),ex3(:),G1H1(1),ngZd,m3h3x1(:,32),heltab2x3(:,:,32))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,nMB,G2tensor(102),n2h1(102))
  call Hloop_QV_A(ntryL,G1H2(189),ex4(:),G1H1(1),m3h2x1(:,71),heltab2x2(:,:,71))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(103),n2h1(103))
  call Hloop_QV_A(ntryL,G1H2(190),ex4(:),G1H1(1),m3h2x1(:,72),heltab2x2(:,:,72))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(104),n2h1(104))
  call Hloop_QV_A(ntryL,G1H2(195),ex4(:),G1H1(1),m3h2x1(:,73),heltab2x2(:,:,73))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(105),n2h1(105))
  call Hloop_QV_A(ntryL,G1H2(196),ex4(:),G1H1(1),m3h2x1(:,74),heltab2x2(:,:,74))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,nMB,G2tensor(106),n2h1(106))
  call Hloop_QV_A(ntryL,G1H2(201),ex4(:),G1H1(1),m3h2x1(:,75),heltab2x2(:,:,75))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,nMB,G2tensor(107),n2h1(107))
  call Hloop_QV_A(ntryL,G1H2(205),ex4(:),G1H1(1),m3h2x1(:,76),heltab2x2(:,:,76))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(108),n2h1(108))
  call Hloop_QV_A(ntryL,G1H2(206),ex4(:),G1H1(1),m3h2x1(:,77),heltab2x2(:,:,77))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(109),n2h1(109))
  call Hloop_QV_A(ntryL,G1H2(211),ex4(:),G1H1(1),m3h2x1(:,78),heltab2x2(:,:,78))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(110),n2h1(110))
  call Hloop_QV_A(ntryL,G1H2(212),ex4(:),G1H1(1),m3h2x1(:,79),heltab2x2(:,:,79))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,nMT,G2tensor(111),n2h1(111))
  call Hloop_AV_Q(ntryL,G1H2(217),ex4(:),G1H1(1),m3h2x1(:,80),heltab2x2(:,:,80))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,nMB,G2tensor(112),n2h1(112))
  call Hloop_AV_Q(ntryL,G1H2(221),ex4(:),G1H1(1),m3h2x1(:,81),heltab2x2(:,:,81))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(113),n2h1(113))
  call Hloop_AV_Q(ntryL,G1H2(222),ex4(:),G1H1(1),m3h2x1(:,82),heltab2x2(:,:,82))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(114),n2h1(114))
  call Hloop_AV_Q(ntryL,G1H2(227),ex4(:),G1H1(1),m3h2x1(:,83),heltab2x2(:,:,83))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(115),n2h1(115))
  call Hloop_AV_Q(ntryL,G1H2(228),ex4(:),G1H1(1),m3h2x1(:,84),heltab2x2(:,:,84))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,nMB,G2tensor(116),n2h1(116))
  call Hloop_AV_Q(ntryL,G1H2(232),ex4(:),G1H1(1),m3h2x1(:,85),heltab2x2(:,:,85))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(117),n2h1(117))
  call Hloop_AV_Q(ntryL,G1H2(233),ex4(:),G1H1(1),m3h2x1(:,86),heltab2x2(:,:,86))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(118),n2h1(118))
  call Hloop_AV_Q(ntryL,G1H2(238),ex4(:),G1H1(1),m3h2x1(:,87),heltab2x2(:,:,87))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(119),n2h1(119))
  call Hloop_AV_Q(ntryL,G1H2(239),ex4(:),G1H1(1),m3h2x1(:,88),heltab2x2(:,:,88))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,nMT,G2tensor(120),n2h1(120))
  call Hotf_5pt_reduction_last(G2tensor(1),RedSet_5(7),mass5set(:,10),  & 
G1tensor(1),G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(5),G1tensor(6))
  call G_TensorShift(G1tensor(2),8)
  call Hotf_5pt_reduction_last(G2tensor(4),RedSet_5(8),mass5set(:,10),  & 
G1tensor(7),G1tensor(8),G1tensor(9),G1tensor(10),G1tensor(11),G1tensor(12))
  call G_TensorShift(G1tensor(8),8)
  call Hotf_5pt_reduction_last(G2tensor(7),RedSet_5(1),mass5set(:,1),  & 
G1tensor(13),G1tensor(14),G1tensor(15),G1tensor(16),G1tensor(17),G1tensor(18))
  call G_TensorShift(G1tensor(14),8)
  call Hotf_5pt_reduction_last(G2tensor(11),RedSet_5(1),mass5set(:,2),  & 
G1tensor(19),G1tensor(20),G1tensor(21),G1tensor(22),G1tensor(23),G1tensor(24))
  call G_TensorShift(G1tensor(20),8)
  call Hotf_5pt_reduction_last(G2tensor(15),RedSet_5(1),mass5set(:,3),  & 
G1tensor(25),G1tensor(26),G1tensor(27),G1tensor(28),G1tensor(29),G1tensor(30))
  call G_TensorShift(G1tensor(26),8)
  call Hotf_5pt_reduction_last(G2tensor(19),RedSet_5(1),mass5set(:,4),  & 
G1tensor(31),G1tensor(32),G1tensor(33),G1tensor(34),G1tensor(35),G1tensor(36))
  call G_TensorShift(G1tensor(32),8)
  call Hotf_5pt_reduction_last(G2tensor(23),RedSet_5(2),mass5set(:,5),  & 
G1tensor(37),G1tensor(38),G1tensor(39),G1tensor(40),G1tensor(41),G1tensor(42))
  call G_TensorShift(G1tensor(38),8)
  call Hotf_5pt_reduction_last(G2tensor(27),RedSet_5(2),mass5set(:,6),  & 
G1tensor(43),G1tensor(44),G1tensor(45),G1tensor(46),G1tensor(47),G1tensor(48))
  call G_TensorShift(G1tensor(44),8)
  call Hotf_5pt_reduction_last(G2tensor(31),RedSet_5(2),mass5set(:,7),  & 
G1tensor(49),G1tensor(50),G1tensor(51),G1tensor(52),G1tensor(53),G1tensor(54))
  call G_TensorShift(G1tensor(50),8)
  call Hotf_5pt_reduction_last(G2tensor(35),RedSet_5(2),mass5set(:,8),  & 
G1tensor(55),G1tensor(56),G1tensor(57),G1tensor(58),G1tensor(59),G1tensor(60))
  call G_TensorShift(G1tensor(56),8)
  call Hotf_5pt_reduction_last(G2tensor(39),RedSet_5(3),mass5set(:,1),  & 
G1tensor(61),G1tensor(62),G1tensor(63),G1tensor(64),G1tensor(65),G1tensor(66))
  call G_TensorShift(G1tensor(62),8)
  call Hotf_5pt_reduction_last(G2tensor(43),RedSet_5(3),mass5set(:,2),  & 
G1tensor(67),G1tensor(68),G1tensor(69),G1tensor(70),G1tensor(71),G1tensor(72))
  call G_TensorShift(G1tensor(68),8)
  call Hotf_5pt_reduction_last(G2tensor(47),RedSet_5(3),mass5set(:,3),  & 
G1tensor(73),G1tensor(74),G1tensor(75),G1tensor(76),G1tensor(77),G1tensor(78))
  call G_TensorShift(G1tensor(74),8)
  call Hotf_5pt_reduction_last(G2tensor(51),RedSet_5(3),mass5set(:,4),  & 
G1tensor(79),G1tensor(80),G1tensor(81),G1tensor(82),G1tensor(83),G1tensor(84))
  call G_TensorShift(G1tensor(80),8)
  call Hotf_5pt_reduction_last(G2tensor(55),RedSet_5(4),mass5set(:,5),  & 
G1tensor(85),G1tensor(86),G1tensor(87),G1tensor(88),G1tensor(89),G1tensor(90))
  call G_TensorShift(G1tensor(86),4)
  call Hotf_5pt_reduction_last(G2tensor(59),RedSet_5(4),mass5set(:,6),  & 
G1tensor(91),G1tensor(92),G1tensor(93),G1tensor(94),G1tensor(95),G1tensor(96))
  call G_TensorShift(G1tensor(92),4)
  call Hotf_5pt_reduction_last(G2tensor(63),RedSet_5(4),mass5set(:,7),  & 
G1tensor(97),G1tensor(98),G1tensor(99),G1tensor(100),G1tensor(101),G1tensor(102))
  call G_TensorShift(G1tensor(98),4)
  call Hotf_5pt_reduction_last(G2tensor(67),RedSet_5(4),mass5set(:,8),  & 
G1tensor(103),G1tensor(104),G1tensor(105),G1tensor(106),G1tensor(107),G1tensor(108))
  call G_TensorShift(G1tensor(104),4)
  call Hotf_5pt_reduction_last(G2tensor(71),RedSet_5(5),mass5set(:,5),  & 
G1tensor(109),G1tensor(110),G1tensor(111),G1tensor(112),G1tensor(113),G1tensor(114))
  call G_TensorShift(G1tensor(110),8)
  call Hotf_5pt_reduction_last(G2tensor(75),RedSet_5(5),mass5set(:,6),  & 
G1tensor(115),G1tensor(116),G1tensor(117),G1tensor(118),G1tensor(119),G1tensor(120))
  call G_TensorShift(G1tensor(116),8)
  call Hotf_5pt_reduction_last(G2tensor(79),RedSet_5(5),mass5set(:,7),  & 
G1tensor(121),G1tensor(122),G1tensor(123),G1tensor(124),G1tensor(125),G1tensor(126))
  call G_TensorShift(G1tensor(122),8)
  call Hotf_5pt_reduction_last(G2tensor(83),RedSet_5(5),mass5set(:,8),  & 
G1tensor(127),G1tensor(128),G1tensor(129),G1tensor(130),G1tensor(131),G1tensor(132))
  call G_TensorShift(G1tensor(128),8)
  call Hotf_5pt_reduction_last(G2tensor(87),RedSet_5(6),mass5set(:,5),  & 
G1tensor(133),G1tensor(134),G1tensor(135),G1tensor(136),G1tensor(137),G1tensor(138))
  call G_TensorShift(G1tensor(134),4)
  call Hotf_5pt_reduction_last(G2tensor(91),RedSet_5(6),mass5set(:,6),  & 
G1tensor(139),G1tensor(140),G1tensor(141),G1tensor(142),G1tensor(143),G1tensor(144))
  call G_TensorShift(G1tensor(140),4)
  call Hotf_5pt_reduction_last(G2tensor(95),RedSet_5(6),mass5set(:,7),  & 
G1tensor(145),G1tensor(146),G1tensor(147),G1tensor(148),G1tensor(149),G1tensor(150))
  call G_TensorShift(G1tensor(146),4)
  call Hotf_5pt_reduction_last(G2tensor(99),RedSet_5(6),mass5set(:,8),  & 
G1tensor(151),G1tensor(152),G1tensor(153),G1tensor(154),G1tensor(155),G1tensor(156))
  call G_TensorShift(G1tensor(152),4)
  call Hotf_5pt_reduction_last(G2tensor(103),RedSet_5(7),mass5set(:,9),  & 
G1tensor(157),G1tensor(158),G1tensor(159),G1tensor(160),G1tensor(161),G1tensor(162))
  call G_TensorShift(G1tensor(158),8)
  call Hotf_5pt_reduction_last(G2tensor(108),RedSet_5(7),mass5set(:,11),  & 
G1tensor(163),G1tensor(164),G1tensor(165),G1tensor(166),G1tensor(167),G1tensor(168))
  call G_TensorShift(G1tensor(164),8)
  call Hotf_5pt_reduction_last(G2tensor(113),RedSet_5(8),mass5set(:,9),  & 
G1tensor(169),G1tensor(170),G1tensor(171),G1tensor(172),G1tensor(173),G1tensor(174))
  call G_TensorShift(G1tensor(170),8)
  call Hotf_5pt_reduction_last(G2tensor(117),RedSet_5(8),mass5set(:,11),  & 
G1tensor(175),G1tensor(176),G1tensor(177),G1tensor(178),G1tensor(179),G1tensor(180))
  call G_TensorShift(G1tensor(176),8)
  call ol_merge_tensors(T1sum(1),[G1tensor(1)])
  call ol_merge_tensors(T1sum(2),[G1tensor(7)])
  call ol_merge_tensors(T1sum(3),[G1tensor(13)])
  call ol_merge_tensors(T1sum(4),[G1tensor(19)])
  call ol_merge_tensors(T1sum(5),[G1tensor(25)])
  call ol_merge_tensors(T1sum(6),[G1tensor(31)])
  call ol_merge_tensors(T1sum(7),[G1tensor(37)])
  call ol_merge_tensors(T1sum(8),[G1tensor(43)])
  call ol_merge_tensors(T1sum(9),[G1tensor(49)])
  call ol_merge_tensors(T1sum(10),[G1tensor(55)])
  call ol_merge_tensors(T1sum(11),[G1tensor(61)])
  call ol_merge_tensors(T1sum(12),[G1tensor(67)])
  call ol_merge_tensors(T1sum(13),[G1tensor(73)])
  call ol_merge_tensors(T1sum(14),[G1tensor(79)])
  call ol_merge_tensors(T1sum(15),[G1tensor(85)])
  call ol_merge_tensors(T1sum(16),[G1tensor(91)])
  call ol_merge_tensors(T1sum(17),[G1tensor(97)])
  call ol_merge_tensors(T1sum(18),[G1tensor(103)])
  call ol_merge_tensors(T1sum(19),[G1tensor(109)])
  call ol_merge_tensors(T1sum(20),[G1tensor(115)])
  call ol_merge_tensors(T1sum(21),[G1tensor(121)])
  call ol_merge_tensors(T1sum(22),[G1tensor(127)])
  call ol_merge_tensors(T1sum(23),[G1tensor(133)])
  call ol_merge_tensors(T1sum(24),[G1tensor(139)])
  call ol_merge_tensors(T1sum(25),[G1tensor(145)])
  call ol_merge_tensors(T1sum(26),[G1tensor(151)])
  call ol_merge_tensors(T1sum(27),[G1tensor(157)])
  call ol_merge_tensors(T1sum(28),[G1tensor(163)])
  call ol_merge_tensors(T1sum(29),[G1tensor(169)])
  call ol_merge_tensors(T1sum(30),[G1tensor(175)])
  Gcoeff(:)%j = (-(c(32)*M(3,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(53),h0tab(:,53),[16,3,8,4],[nMT,nMT,nMT,nMT],4,1,wf4(:,14))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,53),heltab2x48(:,:,53))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMT,G1H24(1),n2h24(53))
  Gcoeff(:)%j = (-(c(32)*M(3,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(54),h0tab(:,54),[16,3,8,4],[nMT,nMT,nMT,nMT],4,1,wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,54),heltab2x48(:,:,54))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMT,G1H24(2),n2h24(54))
  Gcoeff(:)%j = (-(c(31)*M(3,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(55),h0tab(:,55),[16,3,8,4],[nMB,nMB,nMB,nMB],4,1,wf4(:,14))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,55),heltab2x48(:,:,55))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMB,G1H24(3),n2h24(55))
  Gcoeff(:)%j = (-(c(31)*M(3,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(56),h0tab(:,56),[16,3,8,4],[nMB,nMB,nMB,nMB],4,1,wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,56),heltab2x48(:,:,56))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMB,G1H24(4),n2h24(56))
  Gcoeff(:)%j = (-(c(32)*M(3,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(57),h0tab(:,57),[16,3,8,4],[nMT,nMT,nMT,nMT],4,1,wf4(:,12))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,57),heltab2x48(:,:,57))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMT,G1H24(5),n2h24(57))
  Gcoeff(:)%j = (-(c(32)*M(3,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(58),h0tab(:,58),[16,3,8,4],[nMT,nMT,nMT,nMT],4,1,wf4(:,12))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,58),heltab2x48(:,:,58))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMT,G1H24(6),n2h24(58))
  Gcoeff(:)%j = (c(31)*M(3,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(59),h0tab(:,59),[16,3,8,4],[nMB,nMB,nMB,nMB],4,1,wf4(:,12))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,59),heltab2x48(:,:,59))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMB,G1H24(7),n2h24(59))
  Gcoeff(:)%j = (c(31)*M(3,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(60),h0tab(:,60),[16,3,8,4],[nMB,nMB,nMB,nMB],4,1,wf4(:,12))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,60),heltab2x48(:,:,60))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMB,G1H24(8),n2h24(60))
  Gcoeff(:)%j = (-(c(23)*M(3,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(61),h0tab(:,61),[16,3,8,4],[0,0,0,0],4,1,wf4(:,10))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,61),heltab2x48(:,:,61))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(9),n2h24(61))
  Gcoeff(:)%j = (-(c(22)*M(3,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(62),h0tab(:,62),[16,3,8,4],[nMT,nMT,nMT,nMT],4,1,wf4(:,10))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,62),heltab2x48(:,:,62))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMT,G1H24(10),n2h24(62))
  Gcoeff(:)%j = (-(c(23)*M(3,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(63),h0tab(:,63),[16,3,8,4],[0,0,0,0],4,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,63),heltab2x48(:,:,63))
  call Hloop_A_Q(ntryL,G0H24(1),16,0,G1H24(11),n2h24(63))
  Gcoeff(:)%j = (-(c(22)*M(3,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(64),h0tab(:,64),[16,3,8,4],[nMT,nMT,nMT,nMT],4,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,64),heltab2x48(:,:,64))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMT,G1H24(12),n2h24(64))
  Gcoeff(:)%j = (c(22)*M(3,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(65),h0tab(:,65),[16,3,8,4],[0,0,0,0],4,1,wf4(:,10))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,65),heltab2x48(:,:,65))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(13),n2h24(65))
  Gcoeff(:)%j = (c(21)*M(3,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(66),h0tab(:,66),[16,3,8,4],[nMB,nMB,nMB,nMB],4,1,wf4(:,10))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,66),heltab2x48(:,:,66))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMB,G1H24(14),n2h24(66))
  Gcoeff(:)%j = (c(22)*M(3,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(67),h0tab(:,67),[16,3,8,4],[0,0,0,0],4,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,67),heltab2x48(:,:,67))
  call Hloop_A_Q(ntryL,G0H24(1),16,0,G1H24(15),n2h24(67))
  Gcoeff(:)%j = (c(21)*M(3,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(68),h0tab(:,68),[16,3,8,4],[nMB,nMB,nMB,nMB],4,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,68),heltab2x48(:,:,68))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMB,G1H24(16),n2h24(68))
  Gcoeff(:)%j = (c(25)*M(3,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(69),h0tab(:,69),[16,3,8,4],[0,0,0,0],4,1,wf4(:,11))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,69),heltab2x48(:,:,69))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(17),n2h24(69))
  Gcoeff(:)%j = (c(24)*M(3,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(70),h0tab(:,70),[16,3,8,4],[nMT,nMT,nMT,nMT],4,1,wf4(:,11))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,70),heltab2x48(:,:,70))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMT,G1H24(18),n2h24(70))
  Gcoeff(:)%j = (c(25)*M(3,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(71),h0tab(:,71),[16,3,8,4],[0,0,0,0],4,1,wf4(:,11))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,71),heltab2x48(:,:,71))
  call Hloop_A_Q(ntryL,G0H24(1),16,0,G1H24(19),n2h24(71))
  Gcoeff(:)%j = (c(24)*M(3,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(72),h0tab(:,72),[16,3,8,4],[nMT,nMT,nMT,nMT],4,1,wf4(:,11))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,72),heltab2x48(:,:,72))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMT,G1H24(20),n2h24(72))
  Gcoeff(:)%j = (c(25)*M(3,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(73),h0tab(:,73),[16,3,8,4],[0,0,0,0],4,1,wf4(:,11))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,73),heltab2x48(:,:,73))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(21),n2h24(73))
  Gcoeff(:)%j = (c(24)*M(3,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(74),h0tab(:,74),[16,3,8,4],[nMB,nMB,nMB,nMB],4,1,wf4(:,11))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,74),heltab2x48(:,:,74))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMB,G1H24(22),n2h24(74))
  Gcoeff(:)%j = (c(25)*M(3,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(75),h0tab(:,75),[16,3,8,4],[0,0,0,0],4,1,wf4(:,11))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,75),heltab2x48(:,:,75))
  call Hloop_A_Q(ntryL,G0H24(1),16,0,G1H24(23),n2h24(75))
  Gcoeff(:)%j = (c(24)*M(3,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(76),h0tab(:,76),[16,3,8,4],[nMB,nMB,nMB,nMB],4,1,wf4(:,11))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,76),heltab2x48(:,:,76))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMB,G1H24(24),n2h24(76))
  Gcoeff(:)%j = (-(c(32)*M(3,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(77),h0tab(:,77),[16,3,4,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,77),heltab2x48(:,:,77))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMT,G1H24(25),n2h24(77))
  Gcoeff(:)%j = (-(c(32)*M(3,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(78),h0tab(:,78),[16,3,4,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,14))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,78),heltab2x48(:,:,78))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMT,G1H24(26),n2h24(78))
  Gcoeff(:)%j = (-(c(31)*M(3,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(79),h0tab(:,79),[16,3,4,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,79),heltab2x48(:,:,79))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMB,G1H24(27),n2h24(79))
  Gcoeff(:)%j = (-(c(31)*M(3,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(80),h0tab(:,80),[16,3,4,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,14))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,80),heltab2x48(:,:,80))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMB,G1H24(28),n2h24(80))
  Gcoeff(:)%j = (-(c(32)*M(3,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(81),h0tab(:,81),[16,3,4,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,12))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,81),heltab2x48(:,:,81))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMT,G1H24(29),n2h24(81))
  Gcoeff(:)%j = (-(c(32)*M(3,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(82),h0tab(:,82),[16,3,4,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,12))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,82),heltab2x48(:,:,82))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMT,G1H24(30),n2h24(82))
  Gcoeff(:)%j = (c(31)*M(3,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(83),h0tab(:,83),[16,3,4,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,12))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,83),heltab2x48(:,:,83))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMB,G1H24(31),n2h24(83))
  Gcoeff(:)%j = (c(31)*M(3,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(84),h0tab(:,84),[16,3,4,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,12))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,84),heltab2x48(:,:,84))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMB,G1H24(32),n2h24(84))
  Gcoeff(:)%j = (-(c(23)*M(3,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(85),h0tab(:,85),[16,3,4,8],[0,0,0,0],4,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,85),heltab2x48(:,:,85))
  call Hloop_A_Q(ntryL,G0H24(1),16,0,G1H24(33),n2h24(85))
  Gcoeff(:)%j = (-(c(22)*M(3,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(86),h0tab(:,86),[16,3,4,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,86),heltab2x48(:,:,86))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMT,G1H24(34),n2h24(86))
  Gcoeff(:)%j = (-(c(23)*M(3,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(87),h0tab(:,87),[16,3,4,8],[0,0,0,0],4,1,wf4(:,10))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,87),heltab2x48(:,:,87))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(35),n2h24(87))
  Gcoeff(:)%j = (-(c(22)*M(3,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(88),h0tab(:,88),[16,3,4,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,10))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,88),heltab2x48(:,:,88))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMT,G1H24(36),n2h24(88))
  Gcoeff(:)%j = (c(22)*M(3,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(89),h0tab(:,89),[16,3,4,8],[0,0,0,0],4,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,89),heltab2x48(:,:,89))
  call Hloop_A_Q(ntryL,G0H24(1),16,0,G1H24(37),n2h24(89))
  Gcoeff(:)%j = (c(21)*M(3,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(90),h0tab(:,90),[16,3,4,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,90),heltab2x48(:,:,90))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMB,G1H24(38),n2h24(90))
  Gcoeff(:)%j = (c(22)*M(3,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(91),h0tab(:,91),[16,3,4,8],[0,0,0,0],4,1,wf4(:,10))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,91),heltab2x48(:,:,91))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(39),n2h24(91))
  Gcoeff(:)%j = (c(21)*M(3,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(92),h0tab(:,92),[16,3,4,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,10))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,92),heltab2x48(:,:,92))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMB,G1H24(40),n2h24(92))
  Gcoeff(:)%j = (c(25)*M(3,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(93),h0tab(:,93),[16,3,4,8],[0,0,0,0],4,1,wf4(:,11))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,93),heltab2x48(:,:,93))
  call Hloop_A_Q(ntryL,G0H24(1),16,0,G1H24(41),n2h24(93))
  Gcoeff(:)%j = (c(24)*M(3,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(94),h0tab(:,94),[16,3,4,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,11))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,94),heltab2x48(:,:,94))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMT,G1H24(42),n2h24(94))
  Gcoeff(:)%j = (c(25)*M(3,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(95),h0tab(:,95),[16,3,4,8],[0,0,0,0],4,1,wf4(:,11))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,95),heltab2x48(:,:,95))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(43),n2h24(95))
  Gcoeff(:)%j = (c(24)*M(3,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(96),h0tab(:,96),[16,3,4,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,11))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,96),heltab2x48(:,:,96))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMT,G1H24(44),n2h24(96))
  Gcoeff(:)%j = (c(25)*M(3,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(97),h0tab(:,97),[16,3,4,8],[0,0,0,0],4,1,wf4(:,11))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,97),heltab2x48(:,:,97))
  call Hloop_A_Q(ntryL,G0H24(1),16,0,G1H24(45),n2h24(97))
  Gcoeff(:)%j = (c(24)*M(3,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(98),h0tab(:,98),[16,3,4,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,11))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,98),heltab2x48(:,:,98))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMB,G1H24(46),n2h24(98))
  Gcoeff(:)%j = (c(25)*M(3,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(99),h0tab(:,99),[16,3,4,8],[0,0,0,0],4,1,wf4(:,11))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,99),heltab2x48(:,:,99))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(47),n2h24(99))
  Gcoeff(:)%j = (c(24)*M(3,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(100),h0tab(:,100),[16,3,4,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,11))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,100),heltab2x48(:,:,100))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMB,G1H24(48),n2h24(100))
  Gcoeff(:)%j = (-(c(32)*M(3,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(101),h0tab(:,101),[16,4,3,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,14))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,101),heltab2x48(:,:,101))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMT,G1H24(49),n2h24(101))
  Gcoeff(:)%j = (-(c(32)*M(3,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(102),h0tab(:,102),[16,4,3,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,102),heltab2x48(:,:,102))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMT,G1H24(50),n2h24(102))
  Gcoeff(:)%j = (-(c(31)*M(3,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(103),h0tab(:,103),[16,4,3,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,14))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,103),heltab2x48(:,:,103))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMB,G1H24(51),n2h24(103))
  Gcoeff(:)%j = (-(c(31)*M(3,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(104),h0tab(:,104),[16,4,3,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,104),heltab2x48(:,:,104))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMB,G1H24(52),n2h24(104))
  Gcoeff(:)%j = (-(c(32)*M(3,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(105),h0tab(:,105),[16,4,3,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,12))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,105),heltab2x48(:,:,105))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMT,G1H24(53),n2h24(105))
  Gcoeff(:)%j = (-(c(32)*M(3,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(106),h0tab(:,106),[16,4,3,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,12))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,106),heltab2x48(:,:,106))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMT,G1H24(54),n2h24(106))
  Gcoeff(:)%j = (c(31)*M(3,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(107),h0tab(:,107),[16,4,3,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,12))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,107),heltab2x48(:,:,107))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMB,G1H24(55),n2h24(107))
  Gcoeff(:)%j = (c(31)*M(3,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(108),h0tab(:,108),[16,4,3,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,12))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,108),heltab2x48(:,:,108))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMB,G1H24(56),n2h24(108))
  Gcoeff(:)%j = (-(c(23)*M(3,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(109),h0tab(:,109),[16,4,3,8],[0,0,0,0],4,1,wf4(:,10))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,109),heltab2x48(:,:,109))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(57),n2h24(109))
  Gcoeff(:)%j = (-(c(22)*M(3,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(110),h0tab(:,110),[16,4,3,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,10))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,110),heltab2x48(:,:,110))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMT,G1H24(58),n2h24(110))
  Gcoeff(:)%j = (-(c(23)*M(3,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(111),h0tab(:,111),[16,4,3,8],[0,0,0,0],4,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,111),heltab2x48(:,:,111))
  call Hloop_A_Q(ntryL,G0H24(1),16,0,G1H24(59),n2h24(111))
  Gcoeff(:)%j = (-(c(22)*M(3,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(112),h0tab(:,112),[16,4,3,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,112),heltab2x48(:,:,112))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMT,G1H24(60),n2h24(112))
  Gcoeff(:)%j = (c(22)*M(3,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(113),h0tab(:,113),[16,4,3,8],[0,0,0,0],4,1,wf4(:,10))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,113),heltab2x48(:,:,113))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(61),n2h24(113))
  Gcoeff(:)%j = (c(21)*M(3,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(114),h0tab(:,114),[16,4,3,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,10))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,114),heltab2x48(:,:,114))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMB,G1H24(62),n2h24(114))
  Gcoeff(:)%j = (c(22)*M(3,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(115),h0tab(:,115),[16,4,3,8],[0,0,0,0],4,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,115),heltab2x48(:,:,115))
  call Hloop_A_Q(ntryL,G0H24(1),16,0,G1H24(63),n2h24(115))
  Gcoeff(:)%j = (c(21)*M(3,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(116),h0tab(:,116),[16,4,3,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,116),heltab2x48(:,:,116))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMB,G1H24(64),n2h24(116))
  Gcoeff(:)%j = (c(25)*M(3,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(117),h0tab(:,117),[16,4,3,8],[0,0,0,0],4,1,wf4(:,11))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,117),heltab2x48(:,:,117))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(65),n2h24(117))
  Gcoeff(:)%j = (c(24)*M(3,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(118),h0tab(:,118),[16,4,3,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,11))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,118),heltab2x48(:,:,118))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMT,G1H24(66),n2h24(118))
  Gcoeff(:)%j = (c(25)*M(3,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(119),h0tab(:,119),[16,4,3,8],[0,0,0,0],4,1,wf4(:,11))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,119),heltab2x48(:,:,119))
  call Hloop_A_Q(ntryL,G0H24(1),16,0,G1H24(67),n2h24(119))
  Gcoeff(:)%j = (c(24)*M(3,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(120),h0tab(:,120),[16,4,3,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,11))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,120),heltab2x48(:,:,120))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMT,G1H24(68),n2h24(120))
  Gcoeff(:)%j = (c(25)*M(3,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(121),h0tab(:,121),[16,4,3,8],[0,0,0,0],4,1,wf4(:,11))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,121),heltab2x48(:,:,121))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(69),n2h24(121))
  Gcoeff(:)%j = (c(24)*M(3,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(122),h0tab(:,122),[16,4,3,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,11))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,122),heltab2x48(:,:,122))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMB,G1H24(70),n2h24(122))
  Gcoeff(:)%j = (c(25)*M(3,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(123),h0tab(:,123),[16,4,3,8],[0,0,0,0],4,1,wf4(:,11))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,123),heltab2x48(:,:,123))
  call Hloop_A_Q(ntryL,G0H24(1),16,0,G1H24(71),n2h24(123))
  Gcoeff(:)%j = (c(24)*M(3,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(124),h0tab(:,124),[16,4,3,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,11))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,124),heltab2x48(:,:,124))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMB,G1H24(72),n2h24(124))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(125),h0tab(:,125),[16,5,2,8],[nMB,nMH,nMB,nMB],4,1,wf6(:,2))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,125),heltab2x48(:,:,125))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMB,G1H24(73),n2h24(125))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(126),h0tab(:,126),[16,5,2,8],[nMB,nMZ,nMB,nMB],4,1,wf6(:,2))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,126),heltab2x48(:,:,126))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMB,G1H24(74),n2h24(126))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(127),h0tab(:,127),[16,5,2,8],[nMT,nMW,nMT,nMT],4,1,wf6(:,2))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,127),heltab2x48(:,:,127))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMT,G1H24(75),n2h24(127))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(128),h0tab(:,128),[16,5,2,8],[nMB,0,nMB,nMB],4,1,wf6(:,2))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,128),heltab2x48(:,:,128))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMB,G1H24(76),n2h24(128))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(129),h0tab(:,129),[16,5,2,8],[nMB,nMZ,nMB,nMB],4,1,wf6(:,2))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,129),heltab2x48(:,:,129))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMB,G1H24(77),n2h24(129))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(130),h0tab(:,130),[16,5,2,8],[nMT,nMW,nMT,nMT],4,1,wf6(:,2))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,130),heltab2x48(:,:,130))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMT,G1H24(78),n2h24(130))
  Gcoeff(:)%j = (c(16)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(131),h0tab(:,131),[16,2,5,8],[nMB,nMH,nMB,nMB],4,1,wf6(:,2))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,131),heltab2x48(:,:,131))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMB,G1H24(79),n2h24(131))
  Gcoeff(:)%j = (-(c(16)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(132),h0tab(:,132),[16,2,5,8],[nMB,nMZ,nMB,nMB],4,1,wf6(:,2))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,132),heltab2x48(:,:,132))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMB,G1H24(80),n2h24(132))
  Gcoeff(:)%j = (-(c(14)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(133),h0tab(:,133),[16,2,5,8],[nMT,nMW,nMT,nMT],4,1,wf6(:,2))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,133),heltab2x48(:,:,133))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMT,G1H24(81),n2h24(133))
  Gcoeff(:)%j = (-(c(3)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(134),h0tab(:,134),[16,2,5,8],[nMB,0,nMB,nMB],4,1,wf6(:,2))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,134),heltab2x48(:,:,134))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMB,G1H24(82),n2h24(134))
  Gcoeff(:)%j = (-(c(4)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(135),h0tab(:,135),[16,2,5,8],[nMB,nMZ,nMB,nMB],4,1,wf6(:,2))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,135),heltab2x48(:,:,135))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMB,G1H24(83),n2h24(135))
  Gcoeff(:)%j = (-(c(10)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(136),h0tab(:,136),[16,2,5,8],[nMT,nMW,nMT,nMT],4,1,wf6(:,2))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,136),heltab2x48(:,:,136))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMT,G1H24(84),n2h24(136))
  Gcoeff(:)%j = (c(16)*M(2,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(137),h0tab(:,137),[16,6,1,8],[nMB,nMH,nMB,nMB],4,1,wf6(:,4))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,137),heltab2x48(:,:,137))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMB,G1H24(85),n2h24(137))
  Gcoeff(:)%j = (-(c(16)*M(2,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(138),h0tab(:,138),[16,6,1,8],[nMB,nMZ,nMB,nMB],4,1,wf6(:,4))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,138),heltab2x48(:,:,138))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMB,G1H24(86),n2h24(138))
  Gcoeff(:)%j = (-(c(14)*M(2,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(139),h0tab(:,139),[16,6,1,8],[nMT,nMW,nMT,nMT],4,1,wf6(:,4))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,139),heltab2x48(:,:,139))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMT,G1H24(87),n2h24(139))
  Gcoeff(:)%j = (-(c(3)*M(2,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(140),h0tab(:,140),[16,6,1,8],[nMB,0,nMB,nMB],4,1,wf6(:,4))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,140),heltab2x48(:,:,140))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMB,G1H24(88),n2h24(140))
  Gcoeff(:)%j = (-(c(4)*M(2,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(141),h0tab(:,141),[16,6,1,8],[nMB,nMZ,nMB,nMB],4,1,wf6(:,4))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,141),heltab2x48(:,:,141))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMB,G1H24(89),n2h24(141))
  Gcoeff(:)%j = (-(c(10)*M(2,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(142),h0tab(:,142),[16,6,1,8],[nMT,nMW,nMT,nMT],4,1,wf6(:,4))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,142),heltab2x48(:,:,142))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMT,G1H24(90),n2h24(142))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(143),h0tab(:,143),[16,1,6,8],[nMB,nMH,nMB,nMB],4,1,wf6(:,4))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,143),heltab2x48(:,:,143))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMB,G1H24(91),n2h24(143))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(144),h0tab(:,144),[16,1,6,8],[nMB,nMZ,nMB,nMB],4,1,wf6(:,4))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,144),heltab2x48(:,:,144))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMB,G1H24(92),n2h24(144))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(145),h0tab(:,145),[16,1,6,8],[nMT,nMW,nMT,nMT],4,1,wf6(:,4))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,145),heltab2x48(:,:,145))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMT,G1H24(93),n2h24(145))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(146),h0tab(:,146),[16,1,6,8],[nMB,0,nMB,nMB],4,1,wf6(:,4))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,146),heltab2x48(:,:,146))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMB,G1H24(94),n2h24(146))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(147),h0tab(:,147),[16,1,6,8],[nMB,nMZ,nMB,nMB],4,1,wf6(:,4))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,147),heltab2x48(:,:,147))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMB,G1H24(95),n2h24(147))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(148),h0tab(:,148),[16,1,6,8],[nMT,nMW,nMT,nMT],4,1,wf6(:,4))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,148),heltab2x48(:,:,148))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMT,G1H24(96),n2h24(148))
  Gcoeff(:)%j = (-(c(8)*M(2,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(149),h0tab(:,149),[16,2,4,9],[nMB,nMH,nMZ,nMB],4,1,wf4(:,7))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,149),heltab2x48(:,:,149))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMB,G1H24(97),n2h24(149))
  Gcoeff(:)%j = (-(c(8)*M(2,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(150),h0tab(:,150),[16,2,4,9],[nMB,nMZ,nMH,nMB],4,1,wf4(:,7))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,150),heltab2x48(:,:,150))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMB,G1H24(98),n2h24(150))
  Gcoeff(:)%j = (c(20)*M(2,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(151),h0tab(:,151),[16,2,4,9],[nMT,nMW,nMW,nMT],4,1,wf4(:,7))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,151),heltab2x48(:,:,151))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMT,G1H24(99),n2h24(151))
  Gcoeff(:)%j = (c(12)*M(2,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(152),h0tab(:,152),[16,2,4,9],[nMB,nMH,nMZ,nMB],4,1,wf4(:,7))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,152),heltab2x48(:,:,152))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMB,G1H24(100),n2h24(152))
  Gcoeff(:)%j = (-(c(18)*M(2,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(153),h0tab(:,153),[16,2,4,9],[nMT,nMW,nMW,nMT],4,1,wf4(:,7))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,153),heltab2x48(:,:,153))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMT,G1H24(101),n2h24(153))
  Gcoeff(:)%j = (c(12)*M(2,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(154),h0tab(:,154),[16,2,4,9],[nMB,nMZ,nMH,nMB],4,1,wf4(:,7))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,154),heltab2x48(:,:,154))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMB,G1H24(102),n2h24(154))
  Gcoeff(:)%j = (c(18)*M(2,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(155),h0tab(:,155),[16,2,4,9],[nMT,nMW,nMW,nMT],4,1,wf4(:,7))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,155),heltab2x48(:,:,155))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMT,G1H24(103),n2h24(155))
  Gcoeff(:)%j = (-(c(6)*M(2,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(156),h0tab(:,156),[16,2,4,9],[nMT,nMW,nMW,nMT],4,1,wf4(:,7))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,156),heltab2x48(:,:,156))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMT,G1H24(104),n2h24(156))
  Gcoeff(:)%j = (c(16)*M(2,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(157),h0tab(:,157),[16,4,2,9],[nMB,nMB,nMH,nMB],4,1,wf4(:,7))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,157),heltab2x48(:,:,157))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMB,G1H24(105),n2h24(157))
  Gcoeff(:)%j = (-(c(16)*M(2,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(158),h0tab(:,158),[16,4,2,9],[nMB,nMB,nMZ,nMB],4,1,wf4(:,7))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,158),heltab2x48(:,:,158))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMB,G1H24(106),n2h24(158))
  Gcoeff(:)%j = (-(c(14)*M(2,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(159),h0tab(:,159),[16,4,2,9],[nMT,nMT,nMW,nMT],4,1,wf4(:,7))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,159),heltab2x48(:,:,159))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMT,G1H24(107),n2h24(159))
  Gcoeff(:)%j = (-(c(3)*M(2,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(160),h0tab(:,160),[16,4,2,9],[nMB,nMB,0,nMB],4,1,wf4(:,7))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,160),heltab2x48(:,:,160))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMB,G1H24(108),n2h24(160))
  Gcoeff(:)%j = (-(c(4)*M(2,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(161),h0tab(:,161),[16,4,2,9],[nMB,nMB,nMZ,nMB],4,1,wf4(:,7))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,161),heltab2x48(:,:,161))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMB,G1H24(109),n2h24(161))
  Gcoeff(:)%j = (-(c(10)*M(2,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(162),h0tab(:,162),[16,4,2,9],[nMT,nMT,nMW,nMT],4,1,wf4(:,7))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,162),heltab2x48(:,:,162))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMT,G1H24(110),n2h24(162))
  Gcoeff(:)%j = (c(16)*M(2,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(163),h0tab(:,163),[16,2,9,4],[nMB,nMH,nMB,nMB],4,1,wf4(:,7))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,163),heltab2x48(:,:,163))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMB,G1H24(111),n2h24(163))
  Gcoeff(:)%j = (-(c(16)*M(2,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(164),h0tab(:,164),[16,2,9,4],[nMB,nMZ,nMB,nMB],4,1,wf4(:,7))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,164),heltab2x48(:,:,164))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMB,G1H24(112),n2h24(164))
  Gcoeff(:)%j = (-(c(14)*M(2,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(165),h0tab(:,165),[16,2,9,4],[nMT,nMW,nMT,nMT],4,1,wf4(:,7))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,165),heltab2x48(:,:,165))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMT,G1H24(113),n2h24(165))
  Gcoeff(:)%j = (-(c(3)*M(2,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(166),h0tab(:,166),[16,2,9,4],[nMB,0,nMB,nMB],4,1,wf4(:,7))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,166),heltab2x48(:,:,166))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMB,G1H24(114),n2h24(166))
  Gcoeff(:)%j = (-(c(4)*M(2,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(167),h0tab(:,167),[16,2,9,4],[nMB,nMZ,nMB,nMB],4,1,wf4(:,7))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,167),heltab2x48(:,:,167))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMB,G1H24(115),n2h24(167))
  Gcoeff(:)%j = (-(c(10)*M(2,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(168),h0tab(:,168),[16,2,9,4],[nMT,nMW,nMT,nMT],4,1,wf4(:,7))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,168),heltab2x48(:,:,168))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMT,G1H24(116),n2h24(168))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(169),h0tab(:,169),[16,1,4,10],[nMB,nMH,nMZ,nMB],4,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,169),heltab2x48(:,:,169))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMB,G1H24(117),n2h24(169))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(170),h0tab(:,170),[16,1,4,10],[nMB,nMZ,nMH,nMB],4,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,170),heltab2x48(:,:,170))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMB,G1H24(118),n2h24(170))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(171),h0tab(:,171),[16,1,4,10],[nMT,nMW,nMW,nMT],4,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,171),heltab2x48(:,:,171))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMT,G1H24(119),n2h24(171))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(172),h0tab(:,172),[16,1,4,10],[nMB,nMH,nMZ,nMB],4,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,172),heltab2x48(:,:,172))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMB,G1H24(120),n2h24(172))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(173),h0tab(:,173),[16,1,4,10],[nMT,nMW,nMW,nMT],4,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,173),heltab2x48(:,:,173))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMT,G1H24(121),n2h24(173))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(174),h0tab(:,174),[16,1,4,10],[nMB,nMZ,nMH,nMB],4,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,174),heltab2x48(:,:,174))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMB,G1H24(122),n2h24(174))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(175),h0tab(:,175),[16,1,4,10],[nMT,nMW,nMW,nMT],4,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,175),heltab2x48(:,:,175))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMT,G1H24(123),n2h24(175))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(176),h0tab(:,176),[16,1,4,10],[nMT,nMW,nMW,nMT],4,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,176),heltab2x48(:,:,176))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMT,G1H24(124),n2h24(176))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(177),h0tab(:,177),[16,4,1,10],[nMB,nMB,nMH,nMB],4,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,177),heltab2x48(:,:,177))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMB,G1H24(125),n2h24(177))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(178),h0tab(:,178),[16,4,1,10],[nMB,nMB,nMZ,nMB],4,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,178),heltab2x48(:,:,178))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMB,G1H24(126),n2h24(178))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(179),h0tab(:,179),[16,4,1,10],[nMT,nMT,nMW,nMT],4,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,179),heltab2x48(:,:,179))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMT,G1H24(127),n2h24(179))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(180),h0tab(:,180),[16,4,1,10],[nMB,nMB,0,nMB],4,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,180),heltab2x48(:,:,180))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMB,G1H24(128),n2h24(180))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(181),h0tab(:,181),[16,4,1,10],[nMB,nMB,nMZ,nMB],4,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,181),heltab2x48(:,:,181))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMB,G1H24(129),n2h24(181))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(182),h0tab(:,182),[16,4,1,10],[nMT,nMT,nMW,nMT],4,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,182),heltab2x48(:,:,182))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMT,G1H24(130),n2h24(182))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(183),h0tab(:,183),[16,1,10,4],[nMB,nMH,nMB,nMB],4,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,183),heltab2x48(:,:,183))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMB,G1H24(131),n2h24(183))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(184),h0tab(:,184),[16,1,10,4],[nMB,nMZ,nMB,nMB],4,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,184),heltab2x48(:,:,184))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMB,G1H24(132),n2h24(184))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(185),h0tab(:,185),[16,1,10,4],[nMT,nMW,nMT,nMT],4,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,185),heltab2x48(:,:,185))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMT,G1H24(133),n2h24(185))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(186),h0tab(:,186),[16,1,10,4],[nMB,0,nMB,nMB],4,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,186),heltab2x48(:,:,186))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMB,G1H24(134),n2h24(186))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(187),h0tab(:,187),[16,1,10,4],[nMB,nMZ,nMB,nMB],4,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,187),heltab2x48(:,:,187))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMB,G1H24(135),n2h24(187))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(188),h0tab(:,188),[16,1,10,4],[nMT,nMW,nMT,nMT],4,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,188),heltab2x48(:,:,188))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMT,G1H24(136),n2h24(188))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(189),h0tab(:,189),[17,4,2,8],[nMZ,nMH,nMB,nMB],4,1,wf4(:,9))
  call Hloop_AQ_S(ntryL,G0H48(1),wf4(:,9),G0H12(1),ngX,m3h4x12(:,1),heltab2x48(:,:,189))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(190),h0tab(:,190),[17,4,2,8],[nMH,nMZ,nMB,nMB],4,1,wf4(:,9))
  call Hloop_AQ_S(ntryL,G0H48(1),wf4(:,9),G0H12(2),ngH,m3h4x12(:,2),heltab2x48(:,:,190))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(191),h0tab(:,191),[17,4,2,8],[nMW,nMW,nMT,nMT],4,1,wf4(:,9))
  call Hloop_AQ_S(ntryL,G0H48(1),wf4(:,9),G0H12(3),ngPtb,m3h4x12(:,3),heltab2x48(:,:,191))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(192),h0tab(:,192),[17,4,2,8],[nMZ,nMH,nMB,nMB],4,1,wf4(:,9))
  call Hloop_AQ_Z(ntryL,G0H48(1),wf4(:,9),G0H12(4),ngZd,m3h4x12(:,4),heltab2x48(:,:,192))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(193),h0tab(:,193),[17,4,2,8],[nMW,nMW,nMT,nMT],4,1,wf4(:,9))
  call Hloop_AQ_W(ntryL,G0H48(1),wf4(:,9),G0H12(5),m3h4x12(:,5),heltab2x48(:,:,193))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(194),h0tab(:,194),[17,4,2,8],[nMH,nMZ,nMB,nMB],4,1,wf4(:,9))
  call Hloop_AQ_S(ntryL,G0H48(1),wf4(:,9),G0H12(6),ngH,m3h4x12(:,6),heltab2x48(:,:,194))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(195),h0tab(:,195),[17,4,2,8],[nMW,nMW,nMT,nMT],4,1,wf4(:,9))
  call Hloop_AQ_S(ntryL,G0H48(1),wf4(:,9),G0H12(7),ngPtb,m3h4x12(:,7),heltab2x48(:,:,195))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(196),h0tab(:,196),[17,4,2,8],[nMW,nMW,nMT,nMT],4,1,wf4(:,9))
  call Hloop_AQ_W(ntryL,G0H48(1),wf4(:,9),G0H12(8),m3h4x12(:,8),heltab2x48(:,:,196))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(197),h0tab(:,197),[17,2,4,8],[nMH,nMB,nMB,nMB],4,1,wf4(:,9))
  call Hloop_AQ_S(ntryL,G0H48(1),wf4(:,9),G0H12(9),ngH,m3h4x12(:,9),heltab2x48(:,:,197))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(198),h0tab(:,198),[17,2,4,8],[nMZ,nMB,nMB,nMB],4,1,wf4(:,9))
  call Hloop_AQ_S(ntryL,G0H48(1),wf4(:,9),G0H12(10),ngX,m3h4x12(:,10),heltab2x48(:,:,198))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(199),h0tab(:,199),[17,2,4,8],[nMW,nMT,nMT,nMT],4,1,wf4(:,9))
  call Hloop_AQ_S(ntryL,G0H48(1),wf4(:,9),G0H12(11),ngPtb,m3h4x12(:,11),heltab2x48(:,:,199))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(200),h0tab(:,200),[17,2,4,8],[0,nMB,nMB,nMB],4,1,wf4(:,9))
  call Hloop_AQ_V(ntryL,G0H48(1),wf4(:,9),G0H12(12),m3h4x12(:,12),heltab2x48(:,:,200))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(201),h0tab(:,201),[17,2,4,8],[nMZ,nMB,nMB,nMB],4,1,wf4(:,9))
  call Hloop_AQ_Z(ntryL,G0H48(1),wf4(:,9),G0H12(13),ngZd,m3h4x12(:,13),heltab2x48(:,:,201))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(202),h0tab(:,202),[17,2,4,8],[nMW,nMT,nMT,nMT],4,1,wf4(:,9))
  call Hloop_AQ_W(ntryL,G0H48(1),wf4(:,9),G0H12(14),m3h4x12(:,14),heltab2x48(:,:,202))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(203),h0tab(:,203),[17,2,8,4],[nMH,nMB,nMB,nMB],4,1,wf4(:,9))
  call Hloop_AQ_S(ntryL,G0H48(1),wf4(:,9),G0H12(15),ngH,m3h4x12(:,15),heltab2x48(:,:,203))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(204),h0tab(:,204),[17,2,8,4],[nMZ,nMB,nMB,nMB],4,1,wf4(:,9))
  call Hloop_AQ_S(ntryL,G0H48(1),wf4(:,9),G0H12(16),ngX,m3h4x12(:,16),heltab2x48(:,:,204))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(205),h0tab(:,205),[17,2,8,4],[nMW,nMT,nMT,nMT],4,1,wf4(:,9))
  call Hloop_AQ_S(ntryL,G0H48(1),wf4(:,9),G0H12(17),ngPtb,m3h4x12(:,17),heltab2x48(:,:,205))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(206),h0tab(:,206),[17,2,8,4],[0,nMB,nMB,nMB],4,1,wf4(:,9))
  call Hloop_AQ_V(ntryL,G0H48(1),wf4(:,9),G0H12(18),m3h4x12(:,18),heltab2x48(:,:,206))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(207),h0tab(:,207),[17,2,8,4],[nMZ,nMB,nMB,nMB],4,1,wf4(:,9))
  call Hloop_AQ_Z(ntryL,G0H48(1),wf4(:,9),G0H12(19),ngZd,m3h4x12(:,19),heltab2x48(:,:,207))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(208),h0tab(:,208),[17,2,8,4],[nMW,nMT,nMT,nMT],4,1,wf4(:,9))
  call Hloop_AQ_W(ntryL,G0H48(1),wf4(:,9),G0H12(20),m3h4x12(:,20),heltab2x48(:,:,208))
  Gcoeff(:)%j = (-(c(8)*M(2,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(209),h0tab(:,209),[18,4,1,8],[nMZ,nMH,nMB,nMB],4,1,wf4(:,4))
  call Hloop_QA_S(ntryL,G0H48(1),wf4(:,4),G0H12(21),ngX,m3h4x12(:,21),heltab2x48(:,:,209))
  Gcoeff(:)%j = (-(c(8)*M(2,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(210),h0tab(:,210),[18,4,1,8],[nMH,nMZ,nMB,nMB],4,1,wf4(:,4))
  call Hloop_QA_S(ntryL,G0H48(1),wf4(:,4),G0H12(22),ngH,m3h4x12(:,22),heltab2x48(:,:,210))
  Gcoeff(:)%j = (c(20)*M(2,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(211),h0tab(:,211),[18,4,1,8],[nMW,nMW,nMT,nMT],4,1,wf4(:,4))
  call Hloop_QA_S(ntryL,G0H48(1),wf4(:,4),G0H12(23),ngPbt,m3h4x12(:,23),heltab2x48(:,:,211))
  Gcoeff(:)%j = (c(12)*M(2,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(212),h0tab(:,212),[18,4,1,8],[nMZ,nMH,nMB,nMB],4,1,wf4(:,4))
  call Hloop_QA_Z(ntryL,G0H48(1),wf4(:,4),G0H12(24),ngZd,m3h4x12(:,24),heltab2x48(:,:,212))
  Gcoeff(:)%j = (c(18)*M(2,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(213),h0tab(:,213),[18,4,1,8],[nMW,nMW,nMT,nMT],4,1,wf4(:,4))
  call Hloop_QA_W(ntryL,G0H48(1),wf4(:,4),G0H12(25),m3h4x12(:,25),heltab2x48(:,:,213))
  Gcoeff(:)%j = (c(12)*M(2,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(214),h0tab(:,214),[18,4,1,8],[nMH,nMZ,nMB,nMB],4,1,wf4(:,4))
  call Hloop_QA_S(ntryL,G0H48(1),wf4(:,4),G0H12(26),ngH,m3h4x12(:,26),heltab2x48(:,:,214))
  Gcoeff(:)%j = (-(c(18)*M(2,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(215),h0tab(:,215),[18,4,1,8],[nMW,nMW,nMT,nMT],4,1,wf4(:,4))
  call Hloop_QA_S(ntryL,G0H48(1),wf4(:,4),G0H12(27),ngPbt,m3h4x12(:,27),heltab2x48(:,:,215))
  Gcoeff(:)%j = (-(c(6)*M(2,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(216),h0tab(:,216),[18,4,1,8],[nMW,nMW,nMT,nMT],4,1,wf4(:,4))
  call Hloop_QA_W(ntryL,G0H48(1),wf4(:,4),G0H12(28),m3h4x12(:,28),heltab2x48(:,:,216))
  Gcoeff(:)%j = (c(16)*M(2,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(217),h0tab(:,217),[18,1,4,8],[nMH,nMB,nMB,nMB],4,1,wf4(:,4))
  call Hloop_QA_S(ntryL,G0H48(1),wf4(:,4),G0H12(29),ngH,m3h4x12(:,29),heltab2x48(:,:,217))
  Gcoeff(:)%j = (-(c(16)*M(2,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(218),h0tab(:,218),[18,1,4,8],[nMZ,nMB,nMB,nMB],4,1,wf4(:,4))
  call Hloop_QA_S(ntryL,G0H48(1),wf4(:,4),G0H12(30),ngX,m3h4x12(:,30),heltab2x48(:,:,218))
  Gcoeff(:)%j = (-(c(14)*M(2,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(219),h0tab(:,219),[18,1,4,8],[nMW,nMT,nMT,nMT],4,1,wf4(:,4))
  call Hloop_QA_S(ntryL,G0H48(1),wf4(:,4),G0H12(31),ngPbt,m3h4x12(:,31),heltab2x48(:,:,219))
  Gcoeff(:)%j = (-(c(3)*M(2,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(220),h0tab(:,220),[18,1,4,8],[0,nMB,nMB,nMB],4,1,wf4(:,4))
  call Hloop_QA_V(ntryL,G0H48(1),wf4(:,4),G0H12(32),m3h4x12(:,32),heltab2x48(:,:,220))
  Gcoeff(:)%j = (-(c(4)*M(2,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(221),h0tab(:,221),[18,1,4,8],[nMZ,nMB,nMB,nMB],4,1,wf4(:,4))
  call Hloop_QA_Z(ntryL,G0H48(1),wf4(:,4),G0H12(33),ngZd,m3h4x12(:,33),heltab2x48(:,:,221))
  Gcoeff(:)%j = (-(c(10)*M(2,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(222),h0tab(:,222),[18,1,4,8],[nMW,nMT,nMT,nMT],4,1,wf4(:,4))
  call Hloop_QA_W(ntryL,G0H48(1),wf4(:,4),G0H12(34),m3h4x12(:,34),heltab2x48(:,:,222))
  Gcoeff(:)%j = (c(16)*M(2,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(223),h0tab(:,223),[18,1,8,4],[nMH,nMB,nMB,nMB],4,1,wf4(:,4))
  call Hloop_QA_S(ntryL,G0H48(1),wf4(:,4),G0H12(35),ngH,m3h4x12(:,35),heltab2x48(:,:,223))
  Gcoeff(:)%j = (-(c(16)*M(2,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(224),h0tab(:,224),[18,1,8,4],[nMZ,nMB,nMB,nMB],4,1,wf4(:,4))
  call Hloop_QA_S(ntryL,G0H48(1),wf4(:,4),G0H12(36),ngX,m3h4x12(:,36),heltab2x48(:,:,224))
  Gcoeff(:)%j = (-(c(14)*M(2,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(225),h0tab(:,225),[18,1,8,4],[nMW,nMT,nMT,nMT],4,1,wf4(:,4))
  call Hloop_QA_S(ntryL,G0H48(1),wf4(:,4),G0H12(37),ngPbt,m3h4x12(:,37),heltab2x48(:,:,225))
  Gcoeff(:)%j = (-(c(3)*M(2,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(226),h0tab(:,226),[18,1,8,4],[0,nMB,nMB,nMB],4,1,wf4(:,4))
  call Hloop_QA_V(ntryL,G0H48(1),wf4(:,4),G0H12(38),m3h4x12(:,38),heltab2x48(:,:,226))
  Gcoeff(:)%j = (-(c(4)*M(2,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(227),h0tab(:,227),[18,1,8,4],[nMZ,nMB,nMB,nMB],4,1,wf4(:,4))
  call Hloop_QA_Z(ntryL,G0H48(1),wf4(:,4),G0H12(39),ngZd,m3h4x12(:,39),heltab2x48(:,:,227))
  Gcoeff(:)%j = (-(c(10)*M(2,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(228),h0tab(:,228),[18,1,8,4],[nMW,nMT,nMT,nMT],4,1,wf4(:,4))
  call Hloop_QA_W(ntryL,G0H48(1),wf4(:,4),G0H12(40),m3h4x12(:,40),heltab2x48(:,:,228))
  Gcoeff(:)%j = (c(15)*(-M(1,:)%j+M(2,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(229),h0tab(:,229),[24,2,1,4],[nMB,nMH,nMB,nMB],4,1,wf4(:,5))
  call Hloop_QV_A(ntryL,G0H48(1),wf4(:,5),G0H12(41),m3h4x12(:,41),heltab2x48(:,:,229))
  call Hloop_Q_A(ntryL,G0H12(41),24,nMB,G1H12(1),n2h12(1))
  Gcoeff(:)%j = (c(15)*(M(1,:)%j-M(2,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(230),h0tab(:,230),[24,2,1,4],[nMB,nMZ,nMB,nMB],4,1,wf4(:,5))
  call Hloop_QV_A(ntryL,G0H48(1),wf4(:,5),G0H12(41),m3h4x12(:,42),heltab2x48(:,:,230))
  call Hloop_Q_A(ntryL,G0H12(41),24,nMB,G1H12(2),n2h12(2))
  Gcoeff(:)%j = (c(13)*(M(1,:)%j-M(2,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(231),h0tab(:,231),[24,2,1,4],[nMT,nMW,nMT,nMT],4,1,wf4(:,5))
  call Hloop_QV_A(ntryL,G0H48(1),wf4(:,5),G0H12(41),m3h4x12(:,43),heltab2x48(:,:,231))
  call Hloop_Q_A(ntryL,G0H12(41),24,nMT,G1H12(3),n2h12(3))
  Gcoeff(:)%j = (c(1)*(M(1,:)%j-M(2,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(232),h0tab(:,232),[24,2,1,4],[nMB,0,nMB,nMB],4,1,wf4(:,5))
  call Hloop_QV_A(ntryL,G0H48(1),wf4(:,5),G0H12(41),m3h4x12(:,44),heltab2x48(:,:,232))
  call Hloop_Q_A(ntryL,G0H12(41),24,nMB,G1H12(4),n2h12(4))
  Gcoeff(:)%j = (c(2)*(M(1,:)%j-M(2,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(233),h0tab(:,233),[24,2,1,4],[nMB,nMZ,nMB,nMB],4,1,wf4(:,5))
  call Hloop_QV_A(ntryL,G0H48(1),wf4(:,5),G0H12(41),m3h4x12(:,45),heltab2x48(:,:,233))
  call Hloop_Q_A(ntryL,G0H12(41),24,nMB,G1H12(5),n2h12(5))
  Gcoeff(:)%j = (c(9)*(M(1,:)%j-M(2,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(234),h0tab(:,234),[24,2,1,4],[nMT,nMW,nMT,nMT],4,1,wf4(:,5))
  call Hloop_QV_A(ntryL,G0H48(1),wf4(:,5),G0H12(41),m3h4x12(:,46),heltab2x48(:,:,234))
  call Hloop_Q_A(ntryL,G0H12(41),24,nMT,G1H12(6),n2h12(6))
  Gcoeff(:)%j = (c(15)*(-M(1,:)%j+M(2,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(235),h0tab(:,235),[24,1,2,4],[nMB,nMH,nMB,nMB],4,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H48(1),wf4(:,5),G0H12(41),m3h4x12(:,47),heltab2x48(:,:,235))
  call Hloop_A_Q(ntryL,G0H12(41),24,nMB,G1H12(7),n2h12(7))
  Gcoeff(:)%j = (c(15)*(M(1,:)%j-M(2,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(236),h0tab(:,236),[24,1,2,4],[nMB,nMZ,nMB,nMB],4,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H48(1),wf4(:,5),G0H12(41),m3h4x12(:,48),heltab2x48(:,:,236))
  call Hloop_A_Q(ntryL,G0H12(41),24,nMB,G1H12(8),n2h12(8))
  Gcoeff(:)%j = (c(13)*(M(1,:)%j-M(2,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(237),h0tab(:,237),[24,1,2,4],[nMT,nMW,nMT,nMT],4,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H48(1),wf4(:,5),G0H12(41),m3h4x12(:,49),heltab2x48(:,:,237))
  call Hloop_A_Q(ntryL,G0H12(41),24,nMT,G1H12(9),n2h12(9))
  Gcoeff(:)%j = (c(1)*(M(1,:)%j-M(2,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(238),h0tab(:,238),[24,1,2,4],[nMB,0,nMB,nMB],4,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H48(1),wf4(:,5),G0H12(41),m3h4x12(:,50),heltab2x48(:,:,238))
  call Hloop_A_Q(ntryL,G0H12(41),24,nMB,G1H12(10),n2h12(10))
  Gcoeff(:)%j = (c(2)*(M(1,:)%j-M(2,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(239),h0tab(:,239),[24,1,2,4],[nMB,nMZ,nMB,nMB],4,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H48(1),wf4(:,5),G0H12(41),m3h4x12(:,51),heltab2x48(:,:,239))
  call Hloop_A_Q(ntryL,G0H12(41),24,nMB,G1H12(11),n2h12(11))
  Gcoeff(:)%j = (c(9)*(M(1,:)%j-M(2,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(240),h0tab(:,240),[24,1,2,4],[nMT,nMW,nMT,nMT],4,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H48(1),wf4(:,5),G0H12(41),m3h4x12(:,52),heltab2x48(:,:,240))
  call Hloop_A_Q(ntryL,G0H12(41),24,nMT,G1H12(12),n2h12(12))
  Gcoeff(:)%j = (c(7)*(M(1,:)%j-M(2,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(241),h0tab(:,241),[24,1,4,2],[nMB,nMH,nMZ,nMB],4,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H48(1),wf4(:,5),G0H12(41),m3h4x12(:,53),heltab2x48(:,:,241))
  call Hloop_A_Q(ntryL,G0H12(41),24,nMB,G1H12(13),n2h12(13))
  Gcoeff(:)%j = (c(7)*(M(1,:)%j-M(2,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(242),h0tab(:,242),[24,1,4,2],[nMB,nMZ,nMH,nMB],4,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H48(1),wf4(:,5),G0H12(41),m3h4x12(:,54),heltab2x48(:,:,242))
  call Hloop_A_Q(ntryL,G0H12(41),24,nMB,G1H12(14),n2h12(14))
  Gcoeff(:)%j = (c(19)*(-M(1,:)%j+M(2,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(243),h0tab(:,243),[24,1,4,2],[nMT,nMW,nMW,nMT],4,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H48(1),wf4(:,5),G0H12(41),m3h4x12(:,55),heltab2x48(:,:,243))
  call Hloop_A_Q(ntryL,G0H12(41),24,nMT,G1H12(15),n2h12(15))
  Gcoeff(:)%j = (c(11)*(-M(1,:)%j+M(2,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(244),h0tab(:,244),[24,1,4,2],[nMB,nMH,nMZ,nMB],4,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H48(1),wf4(:,5),G0H12(41),m3h4x12(:,56),heltab2x48(:,:,244))
  call Hloop_A_Q(ntryL,G0H12(41),24,nMB,G1H12(16),n2h12(16))
  Gcoeff(:)%j = (c(17)*(-M(1,:)%j+M(2,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(245),h0tab(:,245),[24,1,4,2],[nMT,nMW,nMW,nMT],4,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H48(1),wf4(:,5),G0H12(41),m3h4x12(:,57),heltab2x48(:,:,245))
  call Hloop_A_Q(ntryL,G0H12(41),24,nMT,G1H12(17),n2h12(17))
  Gcoeff(:)%j = (c(11)*(-M(1,:)%j+M(2,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(246),h0tab(:,246),[24,1,4,2],[nMB,nMZ,nMH,nMB],4,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H48(1),wf4(:,5),G0H12(41),m3h4x12(:,58),heltab2x48(:,:,246))
  call Hloop_A_Q(ntryL,G0H12(41),24,nMB,G1H12(18),n2h12(18))
  Gcoeff(:)%j = (c(17)*(M(1,:)%j-M(2,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(247),h0tab(:,247),[24,1,4,2],[nMT,nMW,nMW,nMT],4,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H48(1),wf4(:,5),G0H12(41),m3h4x12(:,59),heltab2x48(:,:,247))
  call Hloop_A_Q(ntryL,G0H12(41),24,nMT,G1H12(19),n2h12(19))
  Gcoeff(:)%j = (c(5)*(M(1,:)%j-M(2,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(248),h0tab(:,248),[24,1,4,2],[nMT,nMW,nMW,nMT],4,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H48(1),wf4(:,5),G0H12(41),m3h4x12(:,60),heltab2x48(:,:,248))
  call Hloop_A_Q(ntryL,G0H12(41),24,nMT,G1H12(20),n2h12(20))
  call Hloop_QS_A(ntryL,G1H24(1),wf4(:,14),G1H6(1),ngH,m3h4x6(:,1),heltab2x24(:,:,53))
  call Hloop_Q_A(ntryL,G1H6(1),19,nMT,G2H6(13),n2h6(41))
  call Hloop_AS_Q(ntryL,G1H24(2),wf4(:,14),G1H6(2),ngH,m3h4x6(:,2),heltab2x24(:,:,54))
  call Hloop_A_Q(ntryL,G1H6(2),19,nMT,G2H6(17),n2h6(42))
  call Hloop_QS_A(ntryL,G1H24(3),wf4(:,14),G1H6(5),ngH,m3h4x6(:,3),heltab2x24(:,:,55))
  call Hloop_Q_A(ntryL,G1H6(5),19,nMB,G2H6(18),n2h6(43))
  call Hloop_AS_Q(ntryL,G1H24(4),wf4(:,14),G1H6(6),ngH,m3h4x6(:,4),heltab2x24(:,:,56))
  call Hloop_A_Q(ntryL,G1H6(6),19,nMB,G2H6(16),n2h6(44))
  call Hloop_QS_A(ntryL,G1H24(5),wf4(:,12),G1H6(7),ngX,m3h4x6(:,5),heltab2x24(:,:,57))
  call Hloop_Q_A(ntryL,G1H6(7),19,nMT,G2H6(19),n2h6(45))
  call Hloop_AS_Q(ntryL,G1H24(6),wf4(:,12),G1H6(8),ngX,m3h4x6(:,6),heltab2x24(:,:,58))
  call Hloop_A_Q(ntryL,G1H6(8),19,nMT,G2H6(23),n2h6(46))
  call Hloop_QS_A(ntryL,G1H24(7),wf4(:,12),G1H6(11),ngX,m3h4x6(:,7),heltab2x24(:,:,59))
  call Hloop_Q_A(ntryL,G1H6(11),19,nMB,G2H6(24),n2h6(47))
  call Hloop_AS_Q(ntryL,G1H24(8),wf4(:,12),G1H6(12),ngX,m3h4x6(:,8),heltab2x24(:,:,60))
  call Hloop_A_Q(ntryL,G1H6(12),19,nMB,G2H6(22),n2h6(48))
  call Hloop_QV_A(ntryL,G1H24(9),wf4(:,10),G1H6(13),m3h4x6(:,9),heltab2x24(:,:,61))
  call Hloop_Q_A(ntryL,G1H6(13),19,0,G2H6(2),n2h6(49))
  call Hloop_QV_A(ntryL,G1H24(10),wf4(:,10),G1H6(14),m3h4x6(:,10),heltab2x24(:,:,62))
  call Hloop_Q_A(ntryL,G1H6(14),19,nMT,G2H6(3),n2h6(50))
  call Hloop_AV_Q(ntryL,G1H24(11),wf4(:,10),G1H6(17),m3h4x6(:,11),heltab2x24(:,:,63))
  call Hloop_A_Q(ntryL,G1H6(17),19,0,G2H6(8),n2h6(51))
  call Hloop_AV_Q(ntryL,G1H24(12),wf4(:,10),G1H6(18),m3h4x6(:,12),heltab2x24(:,:,64))
  call Hloop_A_Q(ntryL,G1H6(18),19,nMT,G2H6(9),n2h6(52))
  call Hloop_QV_A(ntryL,G1H24(13),wf4(:,10),G1H6(19),m3h4x6(:,13),heltab2x24(:,:,65))
  call Hloop_Q_A(ntryL,G1H6(19),19,0,G2H6(14),n2h6(53))
  call Hloop_QV_A(ntryL,G1H24(14),wf4(:,10),G1H6(20),m3h4x6(:,14),heltab2x24(:,:,66))
  call Hloop_Q_A(ntryL,G1H6(20),19,nMB,G2H6(15),n2h6(54))
  call Hloop_AV_Q(ntryL,G1H24(15),wf4(:,10),G1H6(23),m3h4x6(:,15),heltab2x24(:,:,67))
  call Hloop_A_Q(ntryL,G1H6(23),19,0,G2H6(20),n2h6(55))
  call Hloop_AV_Q(ntryL,G1H24(16),wf4(:,10),G1H6(24),m3h4x6(:,16),heltab2x24(:,:,68))
  call Hloop_A_Q(ntryL,G1H6(24),19,nMB,G2H6(21),n2h6(56))
  call Hloop_QZ_A(ntryL,G1H24(17),wf4(:,11),G1H6(25),ngZu,m3h4x6(:,17),heltab2x24(:,:,69))
  call Hloop_Q_A(ntryL,G1H6(25),19,0,G2H6(1),n2h6(57))
  call Hloop_QZ_A(ntryL,G1H24(18),wf4(:,11),G1H6(26),ngZu,m3h4x6(:,18),heltab2x24(:,:,70))
  call Hloop_Q_A(ntryL,G1H6(26),19,nMT,G2H6(5),n2h6(58))
  call Hloop_AZ_Q(ntryL,G1H24(19),wf4(:,11),G1H6(29),ngZu,m3h4x6(:,19),heltab2x24(:,:,71))
  call Hloop_A_Q(ntryL,G1H6(29),19,0,G2H6(6),n2h6(59))
  call Hloop_AZ_Q(ntryL,G1H24(20),wf4(:,11),G1H6(30),ngZu,m3h4x6(:,20),heltab2x24(:,:,72))
  call Hloop_A_Q(ntryL,G1H6(30),19,nMT,G2H6(4),n2h6(60))
  call Hloop_QZ_A(ntryL,G1H24(21),wf4(:,11),G1H6(31),ngZd,m3h4x6(:,21),heltab2x24(:,:,73))
  call Hloop_Q_A(ntryL,G1H6(31),19,0,G2H6(7),n2h6(61))
  call Hloop_QZ_A(ntryL,G1H24(22),wf4(:,11),G1H6(32),ngZd,m3h4x6(:,22),heltab2x24(:,:,74))
  call Hloop_Q_A(ntryL,G1H6(32),19,nMB,G2H6(11),n2h6(62))
  call Hloop_AZ_Q(ntryL,G1H24(23),wf4(:,11),G1H6(35),ngZd,m3h4x6(:,23),heltab2x24(:,:,75))
  call Hloop_A_Q(ntryL,G1H6(35),19,0,G2H6(12),n2h6(63))
  call Hloop_AZ_Q(ntryL,G1H24(24),wf4(:,11),G1H6(36),ngZd,m3h4x6(:,24),heltab2x24(:,:,76))
  call Hloop_A_Q(ntryL,G1H6(36),19,nMB,G2H6(10),n2h6(64))
  call Hloop_AS_Q(ntryL,G1H24(25),wf4(:,14),G1H6(37),ngH,m3h4x6(:,25),heltab2x24(:,:,77))
  call Hloop_A_Q(ntryL,G1H6(37),19,nMT,G2H6(25),n2h6(65))
  call Hloop_QS_A(ntryL,G1H24(26),wf4(:,14),G1H6(38),ngH,m3h4x6(:,26),heltab2x24(:,:,78))
  call Hloop_Q_A(ntryL,G1H6(38),19,nMT,G2H6(26),n2h6(66))
  call Hloop_AS_Q(ntryL,G1H24(27),wf4(:,14),G1H6(41),ngH,m3h4x6(:,27),heltab2x24(:,:,79))
  call Hloop_A_Q(ntryL,G1H6(41),19,nMB,G2H6(27),n2h6(67))
  call Hloop_QS_A(ntryL,G1H24(28),wf4(:,14),G1H6(42),ngH,m3h4x6(:,28),heltab2x24(:,:,80))
  call Hloop_Q_A(ntryL,G1H6(42),19,nMB,G2H6(28),n2h6(68))
  call Hloop_AS_Q(ntryL,G1H24(29),wf4(:,12),G1H6(43),ngX,m3h4x6(:,29),heltab2x24(:,:,81))
  call Hloop_A_Q(ntryL,G1H6(43),19,nMT,G2H6(29),n2h6(69))
  call Hloop_QS_A(ntryL,G1H24(30),wf4(:,12),G1H6(44),ngX,m3h4x6(:,30),heltab2x24(:,:,82))
  call Hloop_Q_A(ntryL,G1H6(44),19,nMT,G2H6(30),n2h6(70))
  call Hloop_AS_Q(ntryL,G1H24(31),wf4(:,12),G1H6(47),ngX,m3h4x6(:,31),heltab2x24(:,:,83))
  call Hloop_A_Q(ntryL,G1H6(47),19,nMB,G2H6(31),n2h6(71))
  call Hloop_QS_A(ntryL,G1H24(32),wf4(:,12),G1H6(48),ngX,m3h4x6(:,32),heltab2x24(:,:,84))
  call Hloop_Q_A(ntryL,G1H6(48),19,nMB,G2H6(32),n2h6(72))
  call Hloop_AV_Q(ntryL,G1H24(33),wf4(:,10),G1H6(49),m3h4x6(:,33),heltab2x24(:,:,85))
  call Hloop_A_Q(ntryL,G1H6(49),19,0,G2H6(33),n2h6(73))
  call Hloop_AV_Q(ntryL,G1H24(34),wf4(:,10),G1H6(50),m3h4x6(:,34),heltab2x24(:,:,86))
  call Hloop_A_Q(ntryL,G1H6(50),19,nMT,G2H6(34),n2h6(74))
  call Hloop_QV_A(ntryL,G1H24(35),wf4(:,10),G1H6(53),m3h4x6(:,35),heltab2x24(:,:,87))
  call Hloop_Q_A(ntryL,G1H6(53),19,0,G2H6(35),n2h6(75))
  call Hloop_QV_A(ntryL,G1H24(36),wf4(:,10),G1H6(54),m3h4x6(:,36),heltab2x24(:,:,88))
  call Hloop_Q_A(ntryL,G1H6(54),19,nMT,G2H6(36),n2h6(76))
  call Hloop_AV_Q(ntryL,G1H24(37),wf4(:,10),G1H6(55),m3h4x6(:,37),heltab2x24(:,:,89))
  call Hloop_A_Q(ntryL,G1H6(55),19,0,G2H6(37),n2h6(77))
  call Hloop_AV_Q(ntryL,G1H24(38),wf4(:,10),G1H6(56),m3h4x6(:,38),heltab2x24(:,:,90))
  call Hloop_A_Q(ntryL,G1H6(56),19,nMB,G2H6(38),n2h6(78))
  call Hloop_QV_A(ntryL,G1H24(39),wf4(:,10),G1H6(59),m3h4x6(:,39),heltab2x24(:,:,91))
  call Hloop_Q_A(ntryL,G1H6(59),19,0,G2H6(39),n2h6(79))
  call Hloop_QV_A(ntryL,G1H24(40),wf4(:,10),G1H6(60),m3h4x6(:,40),heltab2x24(:,:,92))
  call Hloop_Q_A(ntryL,G1H6(60),19,nMB,G2H6(40),n2h6(80))
  call Hloop_AZ_Q(ntryL,G1H24(41),wf4(:,11),G1H6(61),ngZu,m3h4x6(:,41),heltab2x24(:,:,93))
  call Hloop_A_Q(ntryL,G1H6(61),19,0,G2H6(41),n2h6(81))
  call Hloop_AZ_Q(ntryL,G1H24(42),wf4(:,11),G1H6(62),ngZu,m3h4x6(:,42),heltab2x24(:,:,94))
  call Hloop_A_Q(ntryL,G1H6(62),19,nMT,G2H6(42),n2h6(82))
  call Hloop_QZ_A(ntryL,G1H24(43),wf4(:,11),G1H6(65),ngZu,m3h4x6(:,43),heltab2x24(:,:,95))
  call Hloop_Q_A(ntryL,G1H6(65),19,0,G2H6(43),n2h6(83))
  call Hloop_QZ_A(ntryL,G1H24(44),wf4(:,11),G1H6(66),ngZu,m3h4x6(:,44),heltab2x24(:,:,96))
  call Hloop_Q_A(ntryL,G1H6(66),19,nMT,G2H6(44),n2h6(84))
  call Hloop_AZ_Q(ntryL,G1H24(45),wf4(:,11),G1H6(67),ngZd,m3h4x6(:,45),heltab2x24(:,:,97))
  call Hloop_A_Q(ntryL,G1H6(67),19,0,G2H6(45),n2h6(85))
  call Hloop_AZ_Q(ntryL,G1H24(46),wf4(:,11),G1H6(68),ngZd,m3h4x6(:,46),heltab2x24(:,:,98))
  call Hloop_A_Q(ntryL,G1H6(68),19,nMB,G2H6(46),n2h6(86))
  call Hloop_QZ_A(ntryL,G1H24(47),wf4(:,11),G1H6(71),ngZd,m3h4x6(:,47),heltab2x24(:,:,99))
  call Hloop_Q_A(ntryL,G1H6(71),19,0,G2H6(47),n2h6(87))
  call Hloop_QZ_A(ntryL,G1H24(48),wf4(:,11),G1H6(72),ngZd,m3h4x6(:,48),heltab2x24(:,:,100))
  call Hloop_Q_A(ntryL,G1H6(72),19,nMB,G2H6(48),n2h6(88))
  call Hloop_QZ_A(ntryL,G1H24(49),ex3(:),G1H8(1),ngZu,m3h3x8(:,13),heltab2x24(:,:,101))
  call Hloop_Q_A(ntryL,G1H8(1),20,nMT,G2H8(1),n2h8(13))
  call Hloop_AZ_Q(ntryL,G1H24(50),ex3(:),G1H8(1),ngZu,m3h3x8(:,14),heltab2x24(:,:,102))
  call Hloop_A_Q(ntryL,G1H8(1),20,nMT,G2H8(2),n2h8(14))
  call Hloop_QZ_A(ntryL,G1H24(51),ex3(:),G1H8(1),ngZd,m3h3x8(:,15),heltab2x24(:,:,103))
  call Hloop_Q_A(ntryL,G1H8(1),20,nMB,G2H8(3),n2h8(15))
  call Hloop_AZ_Q(ntryL,G1H24(52),ex3(:),G1H8(1),ngZd,m3h3x8(:,16),heltab2x24(:,:,104))
  call Hloop_A_Q(ntryL,G1H8(1),20,nMB,G2H8(4),n2h8(16))
  call Hloop_QZ_A(ntryL,G1H24(53),ex3(:),G1H8(1),ngZu,m3h3x8(:,17),heltab2x24(:,:,105))
  call Hloop_Q_A(ntryL,G1H8(1),20,nMT,G2H8(5),n2h8(17))
  call Hloop_AZ_Q(ntryL,G1H24(54),ex3(:),G1H8(1),ngZu,m3h3x8(:,18),heltab2x24(:,:,106))
  call Hloop_A_Q(ntryL,G1H8(1),20,nMT,G2H8(6),n2h8(18))
  call Hloop_QZ_A(ntryL,G1H24(55),ex3(:),G1H8(1),ngZd,m3h3x8(:,19),heltab2x24(:,:,107))
  call Hloop_Q_A(ntryL,G1H8(1),20,nMB,G2H8(7),n2h8(19))
  call Hloop_AZ_Q(ntryL,G1H24(56),ex3(:),G1H8(1),ngZd,m3h3x8(:,20),heltab2x24(:,:,108))
  call Hloop_A_Q(ntryL,G1H8(1),20,nMB,G2H8(8),n2h8(20))
  call Hloop_QZ_A(ntryL,G1H24(57),ex3(:),G1H8(1),ngZu,m3h3x8(:,21),heltab2x24(:,:,109))
  call Hloop_Q_A(ntryL,G1H8(1),20,0,G2H8(9),n2h8(21))
  call Hloop_QZ_A(ntryL,G1H24(58),ex3(:),G1H8(1),ngZu,m3h3x8(:,22),heltab2x24(:,:,110))
  call Hloop_Q_A(ntryL,G1H8(1),20,nMT,G2H8(10),n2h8(22))
  call Hloop_AZ_Q(ntryL,G1H24(59),ex3(:),G1H8(1),ngZu,m3h3x8(:,23),heltab2x24(:,:,111))
  call Hloop_A_Q(ntryL,G1H8(1),20,0,G2H8(11),n2h8(23))
  call Hloop_AZ_Q(ntryL,G1H24(60),ex3(:),G1H8(1),ngZu,m3h3x8(:,24),heltab2x24(:,:,112))
  call Hloop_A_Q(ntryL,G1H8(1),20,nMT,G2H8(12),n2h8(24))
  call Hloop_QZ_A(ntryL,G1H24(61),ex3(:),G1H8(1),ngZd,m3h3x8(:,25),heltab2x24(:,:,113))
  call Hloop_Q_A(ntryL,G1H8(1),20,0,G2H8(13),n2h8(25))
  call Hloop_QZ_A(ntryL,G1H24(62),ex3(:),G1H8(1),ngZd,m3h3x8(:,26),heltab2x24(:,:,114))
  call Hloop_Q_A(ntryL,G1H8(1),20,nMB,G2H8(14),n2h8(26))
  call Hloop_AZ_Q(ntryL,G1H24(63),ex3(:),G1H8(1),ngZd,m3h3x8(:,27),heltab2x24(:,:,115))
  call Hloop_A_Q(ntryL,G1H8(1),20,0,G2H8(15),n2h8(27))
  call Hloop_AZ_Q(ntryL,G1H24(64),ex3(:),G1H8(1),ngZd,m3h3x8(:,28),heltab2x24(:,:,116))
  call Hloop_A_Q(ntryL,G1H8(1),20,nMB,G2H8(16),n2h8(28))
  call Hloop_QZ_A(ntryL,G1H24(65),ex3(:),G1H8(1),ngZu,m3h3x8(:,29),heltab2x24(:,:,117))
  call Hloop_Q_A(ntryL,G1H8(1),20,0,G2H8(17),n2h8(29))
  call Hloop_QZ_A(ntryL,G1H24(66),ex3(:),G1H8(1),ngZu,m3h3x8(:,30),heltab2x24(:,:,118))
  call Hloop_Q_A(ntryL,G1H8(1),20,nMT,G2H8(18),n2h8(30))
  call Hloop_AZ_Q(ntryL,G1H24(67),ex3(:),G1H8(1),ngZu,m3h3x8(:,31),heltab2x24(:,:,119))
  call Hloop_A_Q(ntryL,G1H8(1),20,0,G2H8(19),n2h8(31))
  call Hloop_AZ_Q(ntryL,G1H24(68),ex3(:),G1H8(1),ngZu,m3h3x8(:,32),heltab2x24(:,:,120))
  call Hloop_A_Q(ntryL,G1H8(1),20,nMT,G2H8(20),n2h8(32))
  call Hloop_QZ_A(ntryL,G1H24(69),ex3(:),G1H8(1),ngZd,m3h3x8(:,33),heltab2x24(:,:,121))
  call Hloop_Q_A(ntryL,G1H8(1),20,0,G2H8(21),n2h8(33))
  call Hloop_QZ_A(ntryL,G1H24(70),ex3(:),G1H8(1),ngZd,m3h3x8(:,34),heltab2x24(:,:,122))
  call Hloop_Q_A(ntryL,G1H8(1),20,nMB,G2H8(22),n2h8(34))
  call Hloop_AZ_Q(ntryL,G1H24(71),ex3(:),G1H8(1),ngZd,m3h3x8(:,35),heltab2x24(:,:,123))
  call Hloop_A_Q(ntryL,G1H8(1),20,0,G2H8(23),n2h8(35))
  call Hloop_AZ_Q(ntryL,G1H24(72),ex3(:),G1H8(1),ngZd,m3h3x8(:,36),heltab2x24(:,:,124))
  call Hloop_A_Q(ntryL,G1H8(1),20,nMB,G2H8(24),n2h8(36))
  call Hloop_AQ_S(ntryL,G1H24(73),wf6(:,2),G1H4(1),ngH,m3h6x4(:,1),heltab2x24(:,:,125))
  call Hloop_AQ_S(ntryL,G1H24(74),wf6(:,2),G1H4(2),ngX,m3h6x4(:,2),heltab2x24(:,:,126))
  call Hloop_AQ_S(ntryL,G1H24(75),wf6(:,2),G1H4(8),ngPtb,m3h6x4(:,3),heltab2x24(:,:,127))
  call Hloop_AQ_V(ntryL,G1H24(76),wf6(:,2),G1H4(6),m3h6x4(:,4),heltab2x24(:,:,128))
  call Hloop_AQ_Z(ntryL,G1H24(77),wf6(:,2),G1H4(9),ngZd,m3h6x4(:,5),heltab2x24(:,:,129))
  call Hloop_AQ_W(ntryL,G1H24(78),wf6(:,2),G1H4(10),m3h6x4(:,6),heltab2x24(:,:,130))
  call Hloop_QA_S(ntryL,G1H24(79),ex2(:),G1H12(21),ngH,m3h2x12(:,41),heltab2x24(:,:,131))
  call Hloop_QA_S(ntryL,G1H24(80),ex2(:),G1H12(22),ngX,m3h2x12(:,42),heltab2x24(:,:,132))
  call Hloop_QA_S(ntryL,G1H24(81),ex2(:),G1H12(23),ngPbt,m3h2x12(:,43),heltab2x24(:,:,133))
  call Hloop_QA_V(ntryL,G1H24(82),ex2(:),G1H12(24),m3h2x12(:,44),heltab2x24(:,:,134))
  call Hloop_QA_Z(ntryL,G1H24(83),ex2(:),G1H12(25),ngZd,m3h2x12(:,45),heltab2x24(:,:,135))
  call Hloop_QA_W(ntryL,G1H24(84),ex2(:),G1H12(26),m3h2x12(:,46),heltab2x24(:,:,136))
  call Hloop_QA_S(ntryL,G1H24(85),wf6(:,4),G1H4(13),ngH,m3h6x4(:,7),heltab2x24(:,:,137))
  call Hloop_QA_S(ntryL,G1H24(86),wf6(:,4),G1H4(14),ngX,m3h6x4(:,8),heltab2x24(:,:,138))
  call Hloop_QA_S(ntryL,G1H24(87),wf6(:,4),G1H4(15),ngPbt,m3h6x4(:,9),heltab2x24(:,:,139))
  call Hloop_QA_V(ntryL,G1H24(88),wf6(:,4),G1H4(16),m3h6x4(:,10),heltab2x24(:,:,140))
  call Hloop_QA_Z(ntryL,G1H24(89),wf6(:,4),G1H4(19),ngZd,m3h6x4(:,11),heltab2x24(:,:,141))
  call Hloop_QA_W(ntryL,G1H24(90),wf6(:,4),G1H4(20),m3h6x4(:,12),heltab2x24(:,:,142))
  call Hloop_AQ_S(ntryL,G1H24(91),ex1(:),G1H12(27),ngH,m3h2x12(:,47),heltab2x24(:,:,143))
  call Hloop_AQ_S(ntryL,G1H24(92),ex1(:),G1H12(28),ngX,m3h2x12(:,48),heltab2x24(:,:,144))
  call Hloop_AQ_S(ntryL,G1H24(93),ex1(:),G1H12(29),ngPtb,m3h2x12(:,49),heltab2x24(:,:,145))
  call Hloop_AQ_V(ntryL,G1H24(94),ex1(:),G1H12(30),m3h2x12(:,50),heltab2x24(:,:,146))
  call Hloop_AQ_Z(ntryL,G1H24(95),ex1(:),G1H12(31),ngZd,m3h2x12(:,51),heltab2x24(:,:,147))
  call Hloop_AQ_W(ntryL,G1H24(96),ex1(:),G1H12(32),m3h2x12(:,52),heltab2x24(:,:,148))
  call Hloop_QA_S(ntryL,G1H24(97),ex2(:),G1H12(33),ngH,m3h2x12(:,53),heltab2x24(:,:,149))
  call Hloop_QA_S(ntryL,G1H24(98),ex2(:),G1H12(34),ngX,m3h2x12(:,54),heltab2x24(:,:,150))
  call Hloop_QA_S(ntryL,G1H24(99),ex2(:),G1H12(35),ngPbt,m3h2x12(:,55),heltab2x24(:,:,151))
  call Hloop_QA_S(ntryL,G1H24(100),ex2(:),G1H12(36),ngH,m3h2x12(:,56),heltab2x24(:,:,152))
  call Hloop_QA_S(ntryL,G1H24(101),ex2(:),G1H12(37),ngPbt,m3h2x12(:,57),heltab2x24(:,:,153))
  call Hloop_QA_Z(ntryL,G1H24(102),ex2(:),G1H12(38),ngZd,m3h2x12(:,58),heltab2x24(:,:,154))
  call Hloop_QA_W(ntryL,G1H24(103),ex2(:),G1H12(39),m3h2x12(:,59),heltab2x24(:,:,155))
  call Hloop_QA_W(ntryL,G1H24(104),ex2(:),G1H12(40),m3h2x12(:,60),heltab2x24(:,:,156))
  call Hloop_QZ_A(ntryL,G1H24(105),ex3(:),G1H8(1),ngZd,m3h3x8(:,37),heltab2x24(:,:,157))
  call Hloop_Q_A(ntryL,G1H8(1),20,nMB,G2H8(25),n2h8(37))
  call Hloop_QZ_A(ntryL,G1H24(106),ex3(:),G1H8(1),ngZd,m3h3x8(:,38),heltab2x24(:,:,158))
  call Hloop_Q_A(ntryL,G1H8(1),20,nMB,G2H8(26),n2h8(38))
  call Hloop_QZ_A(ntryL,G1H24(107),ex3(:),G1H8(1),ngZu,m3h3x8(:,39),heltab2x24(:,:,159))
  call Hloop_Q_A(ntryL,G1H8(1),20,nMT,G2H8(27),n2h8(39))
  call Hloop_QZ_A(ntryL,G1H24(108),ex3(:),G1H8(1),ngZd,m3h3x8(:,40),heltab2x24(:,:,160))
  call Hloop_Q_A(ntryL,G1H8(1),20,nMB,G2H8(28),n2h8(40))
  call Hloop_QZ_A(ntryL,G1H24(109),ex3(:),G1H8(1),ngZd,m3h3x8(:,41),heltab2x24(:,:,161))
  call Hloop_Q_A(ntryL,G1H8(1),20,nMB,G2H8(29),n2h8(41))
  call Hloop_QZ_A(ntryL,G1H24(110),ex3(:),G1H8(1),ngZu,m3h3x8(:,42),heltab2x24(:,:,162))
  call Hloop_Q_A(ntryL,G1H8(1),20,nMT,G2H8(30),n2h8(42))
  call Hloop_QA_S(ntryL,G1H24(111),ex2(:),G1H12(41),ngH,m3h2x12(:,61),heltab2x24(:,:,163))
  call Hloop_QA_S(ntryL,G1H24(112),ex2(:),G1H12(42),ngX,m3h2x12(:,62),heltab2x24(:,:,164))
  call Hloop_QA_S(ntryL,G1H24(113),ex2(:),G1H12(43),ngPbt,m3h2x12(:,63),heltab2x24(:,:,165))
  call Hloop_QA_V(ntryL,G1H24(114),ex2(:),G1H12(44),m3h2x12(:,64),heltab2x24(:,:,166))
  call Hloop_QA_Z(ntryL,G1H24(115),ex2(:),G1H12(45),ngZd,m3h2x12(:,65),heltab2x24(:,:,167))
  call Hloop_QA_W(ntryL,G1H24(116),ex2(:),G1H12(46),m3h2x12(:,66),heltab2x24(:,:,168))
  call Hloop_AQ_S(ntryL,G1H24(117),ex1(:),G1H12(47),ngH,m3h2x12(:,67),heltab2x24(:,:,169))
  call Hloop_AQ_S(ntryL,G1H24(118),ex1(:),G1H12(48),ngX,m3h2x12(:,68),heltab2x24(:,:,170))
  call Hloop_AQ_S(ntryL,G1H24(119),ex1(:),G1H12(49),ngPtb,m3h2x12(:,69),heltab2x24(:,:,171))
  call Hloop_AQ_S(ntryL,G1H24(120),ex1(:),G1H12(50),ngH,m3h2x12(:,70),heltab2x24(:,:,172))
  call Hloop_AQ_S(ntryL,G1H24(121),ex1(:),G1H12(51),ngPtb,m3h2x12(:,71),heltab2x24(:,:,173))
  call Hloop_AQ_Z(ntryL,G1H24(122),ex1(:),G1H12(52),ngZd,m3h2x12(:,72),heltab2x24(:,:,174))
  call Hloop_AQ_W(ntryL,G1H24(123),ex1(:),G1H12(53),m3h2x12(:,73),heltab2x24(:,:,175))
  call Hloop_AQ_W(ntryL,G1H24(124),ex1(:),G1H12(54),m3h2x12(:,74),heltab2x24(:,:,176))
  call Hloop_AZ_Q(ntryL,G1H24(125),ex3(:),G1H8(1),ngZd,m3h3x8(:,43),heltab2x24(:,:,177))
  call Hloop_A_Q(ntryL,G1H8(1),20,nMB,G2H8(31),n2h8(43))
  call Hloop_AZ_Q(ntryL,G1H24(126),ex3(:),G1H8(1),ngZd,m3h3x8(:,44),heltab2x24(:,:,178))
  call Hloop_A_Q(ntryL,G1H8(1),20,nMB,G2H8(32),n2h8(44))
  call Hloop_AZ_Q(ntryL,G1H24(127),ex3(:),G1H8(1),ngZu,m3h3x8(:,45),heltab2x24(:,:,179))
  call Hloop_A_Q(ntryL,G1H8(1),20,nMT,G2H8(33),n2h8(45))
  call Hloop_AZ_Q(ntryL,G1H24(128),ex3(:),G1H8(1),ngZd,m3h3x8(:,46),heltab2x24(:,:,180))
  call Hloop_A_Q(ntryL,G1H8(1),20,nMB,G2H8(34),n2h8(46))
  call Hloop_AZ_Q(ntryL,G1H24(129),ex3(:),G1H8(1),ngZd,m3h3x8(:,47),heltab2x24(:,:,181))
  call Hloop_A_Q(ntryL,G1H8(1),20,nMB,G2H8(35),n2h8(47))
  call Hloop_AZ_Q(ntryL,G1H24(130),ex3(:),G1H8(1),ngZu,m3h3x8(:,48),heltab2x24(:,:,182))
  call Hloop_A_Q(ntryL,G1H8(1),20,nMT,G2H8(36),n2h8(48))
  call Hloop_AQ_S(ntryL,G1H24(131),ex1(:),G1H12(55),ngH,m3h2x12(:,75),heltab2x24(:,:,183))
  call Hloop_AQ_S(ntryL,G1H24(132),ex1(:),G1H12(56),ngX,m3h2x12(:,76),heltab2x24(:,:,184))
  call Hloop_AQ_S(ntryL,G1H24(133),ex1(:),G1H12(57),ngPtb,m3h2x12(:,77),heltab2x24(:,:,185))
  call Hloop_AQ_V(ntryL,G1H24(134),ex1(:),G1H12(58),m3h2x12(:,78),heltab2x24(:,:,186))
  call Hloop_AQ_Z(ntryL,G1H24(135),ex1(:),G1H12(59),ngZd,m3h2x12(:,79),heltab2x24(:,:,187))
  call Hloop_AQ_W(ntryL,G1H24(136),ex1(:),G1H12(60),m3h2x12(:,80),heltab2x24(:,:,188))
  call Hloop_SV_T(ntryL,G0H12(1),17,ex3(:),4,G1H4(21),m3h3x4(:,17),heltab2x12(:,:,41))
  call Hloop_TV_S(ntryL,G0H12(2),17,ex3(:),4,G1H4(22),m3h3x4(:,18),heltab2x12(:,:,42))
  call Hloop_TV_S(ntryL,G0H12(3),17,ex3(:),4,G1H4(25),m3h3x4(:,19),heltab2x12(:,:,43))
  call Hloop_VV_S(ntryL,G0H12(4),ex3(:),G0H4(1),m3h3x4(:,20),heltab2x12(:,:,44))
  call Hloop_VV_S(ntryL,G0H12(5),ex3(:),G0H4(2),m3h3x4(:,21),heltab2x12(:,:,45))
  call Hloop_SV_V(ntryL,G0H12(6),ex3(:),G0H4(3),m3h3x4(:,22),heltab2x12(:,:,46))
  call Hloop_SV_V(ntryL,G0H12(7),ex3(:),G0H4(4),m3h3x4(:,23),heltab2x12(:,:,47))
  call Hloop_UV_W(ntryL,G0H12(8),17,ex3(:),4,G1H4(26),m3h3x4(:,24),heltab2x12(:,:,48))
  call Hloop_SA_Q(ntryL,G0H12(9),ex2(:),G0H6(1),ngH,m3h2x6(:,25),heltab2x12(:,:,49))
  call Hloop_A_Q(ntryL,G0H6(1),19,nMB,G1H6(73),n2h6(89))
  call Hloop_SA_Q(ntryL,G0H12(10),ex2(:),G0H6(1),ngX,m3h2x6(:,26),heltab2x12(:,:,50))
  call Hloop_A_Q(ntryL,G0H6(1),19,nMB,G1H6(74),n2h6(90))
  call Hloop_SA_Q(ntryL,G0H12(11),ex2(:),G0H6(1),ngPbt,m3h2x6(:,27),heltab2x12(:,:,51))
  call Hloop_A_Q(ntryL,G0H6(1),19,nMT,G1H6(77),n2h6(91))
  call Hloop_VA_Q(ntryL,G0H12(12),ex2(:),G0H6(1),m3h2x6(:,28),heltab2x12(:,:,52))
  call Hloop_A_Q(ntryL,G0H6(1),19,nMB,G1H6(78),n2h6(92))
  call Hloop_ZA_Q(ntryL,G0H12(13),ex2(:),G0H6(1),ngZd,m3h2x6(:,29),heltab2x12(:,:,53))
  call Hloop_A_Q(ntryL,G0H6(1),19,nMB,G1H6(79),n2h6(93))
  call Hloop_WA_Q(ntryL,G0H12(14),ex2(:),G0H6(1),m3h2x6(:,30),heltab2x12(:,:,54))
  call Hloop_A_Q(ntryL,G0H6(1),19,nMT,G1H6(80),n2h6(94))
  call Hloop_SA_Q(ntryL,G0H12(15),ex2(:),G0H6(1),ngH,m3h2x6(:,31),heltab2x12(:,:,55))
  call Hloop_A_Q(ntryL,G0H6(1),19,nMB,G1H6(83),n2h6(95))
  call Hloop_SA_Q(ntryL,G0H12(16),ex2(:),G0H6(1),ngX,m3h2x6(:,32),heltab2x12(:,:,56))
  call Hloop_A_Q(ntryL,G0H6(1),19,nMB,G1H6(84),n2h6(96))
  call Hloop_SA_Q(ntryL,G0H12(17),ex2(:),G0H6(1),ngPbt,m3h2x6(:,33),heltab2x12(:,:,57))
  call Hloop_A_Q(ntryL,G0H6(1),19,nMT,G1H6(85),n2h6(97))
  call Hloop_VA_Q(ntryL,G0H12(18),ex2(:),G0H6(1),m3h2x6(:,34),heltab2x12(:,:,58))
  call Hloop_A_Q(ntryL,G0H6(1),19,nMB,G1H6(86),n2h6(98))



end subroutine vamp_1

end module ol_vamp_1_ppzjj_ew_bbxzgg_1_/**/REALKIND
