
module ol_vamp_1_ppzjj_ew_uuxzgg_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppzjj_ew_uuxzgg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppzjj_ew_uuxzgg_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_ppzjj_ew_uuxzgg_1_/**/DREALKIND
  use ol_tensor_sum_storage_ppzjj_ew_uuxzgg_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_ppzjj_ew_uuxzgg_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_ppzjj_ew_uuxzgg_1_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(48)
  type(Hpolcont), intent(in) :: M(3,48)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

  Gcoeff(:)%j = (-(c(3)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(1),h0tab(:,1),[16,4,1,2,8],[0,0,0,0,0],5,0)
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,1),heltab2x48(:,:,1))
  call Hloop_A_Q(ntryL,G0H24(1),16,0,G1H24(1),n2h24(1))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(2),h0tab(:,2),[16,4,1,2,8],[0,0,nMZ,0,0],5,0)
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,2),heltab2x48(:,:,2))
  call Hloop_A_Q(ntryL,G0H24(1),16,0,G1H24(2),n2h24(2))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(3),h0tab(:,3),[16,4,1,2,8],[0,0,nMW,0,0],5,0)
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,3),heltab2x48(:,:,3))
  call Hloop_A_Q(ntryL,G0H24(1),16,0,G1H24(3),n2h24(3))
  Gcoeff(:)%j = (-(c(3)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(4),h0tab(:,4),[16,2,1,4,8],[0,0,0,0,0],5,0)
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,4),heltab2x48(:,:,4))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(4),n2h24(4))
  Gcoeff(:)%j = (-(c(4)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(5),h0tab(:,5),[16,2,1,4,8],[0,nMZ,0,0,0],5,0)
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,5),heltab2x48(:,:,5))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(5),n2h24(5))
  Gcoeff(:)%j = (-(c(8)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(6),h0tab(:,6),[16,2,1,4,8],[0,nMW,0,0,0],5,0)
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,6),heltab2x48(:,:,6))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(6),n2h24(6))
  Gcoeff(:)%j = (-(c(3)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(7),h0tab(:,7),[16,4,2,1,8],[0,0,0,0,0],5,0)
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,7),heltab2x48(:,:,7))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(7),n2h24(7))
  Gcoeff(:)%j = (-(c(4)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(8),h0tab(:,8),[16,4,2,1,8],[0,0,nMZ,0,0],5,0)
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,8),heltab2x48(:,:,8))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(8),n2h24(8))
  Gcoeff(:)%j = (-(c(8)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(9),h0tab(:,9),[16,4,2,1,8],[0,0,nMW,0,0],5,0)
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,9),heltab2x48(:,:,9))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(9),n2h24(9))
  Gcoeff(:)%j = (-(c(3)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(10),h0tab(:,10),[16,2,1,8,4],[0,0,0,0,0],5,0)
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,10),heltab2x48(:,:,10))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(10),n2h24(10))
  Gcoeff(:)%j = (-(c(4)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(11),h0tab(:,11),[16,2,1,8,4],[0,nMZ,0,0,0],5,0)
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,11),heltab2x48(:,:,11))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(11),n2h24(11))
  Gcoeff(:)%j = (-(c(8)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(12),h0tab(:,12),[16,2,1,8,4],[0,nMW,0,0,0],5,0)
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,12),heltab2x48(:,:,12))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(12),n2h24(12))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(13),h0tab(:,13),[16,1,2,4,8],[0,0,0,0,0],5,0)
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,13),heltab2x48(:,:,13))
  call Hloop_A_Q(ntryL,G0H24(1),16,0,G1H24(13),n2h24(13))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(14),h0tab(:,14),[16,1,2,4,8],[0,nMZ,0,0,0],5,0)
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,14),heltab2x48(:,:,14))
  call Hloop_A_Q(ntryL,G0H24(1),16,0,G1H24(14),n2h24(14))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(15),h0tab(:,15),[16,1,2,4,8],[0,nMW,0,0,0],5,0)
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,15),heltab2x48(:,:,15))
  call Hloop_A_Q(ntryL,G0H24(1),16,0,G1H24(15),n2h24(15))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(16),h0tab(:,16),[16,1,2,8,4],[0,0,0,0,0],5,0)
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,16),heltab2x48(:,:,16))
  call Hloop_A_Q(ntryL,G0H24(1),16,0,G1H24(16),n2h24(16))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(17),h0tab(:,17),[16,1,2,8,4],[0,nMZ,0,0,0],5,0)
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,17),heltab2x48(:,:,17))
  call Hloop_A_Q(ntryL,G0H24(1),16,0,G1H24(17),n2h24(17))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(18),h0tab(:,18),[16,1,2,8,4],[0,nMW,0,0,0],5,0)
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,18),heltab2x48(:,:,18))
  call Hloop_A_Q(ntryL,G0H24(1),16,0,G1H24(18),n2h24(18))
  Gcoeff(:)%j = (-(c(6)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(19),h0tab(:,19),[16,2,4,1,8],[0,nMW,nMW,0,0],5,0)
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,19),heltab2x48(:,:,19))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(19),n2h24(19))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(20),h0tab(:,20),[16,1,4,2,8],[0,nMW,nMW,0,0],5,0)
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,20),heltab2x48(:,:,20))
  call Hloop_A_Q(ntryL,G0H24(1),16,0,G1H24(20),n2h24(20))
  call Hloop_AZ_Q(ntryL,G1H24(1),ex3(:),G1H8(1),ngZu,m3h3x8(:,1),heltab2x24(:,:,1))
  call Hloop_A_Q(ntryL,G1H8(1),20,0,G2H8(1),n2h8(1))
  call Hloop_AZ_Q(ntryL,G1H24(2),ex3(:),G1H8(1),ngZu,m3h3x8(:,2),heltab2x24(:,:,2))
  call Hloop_A_Q(ntryL,G1H8(1),20,0,G2H8(2),n2h8(2))
  call Hloop_AZ_Q(ntryL,G1H24(3),ex3(:),G1H8(1),ngZd,m3h3x8(:,3),heltab2x24(:,:,3))
  call Hloop_A_Q(ntryL,G1H8(1),20,0,G2H8(3),n2h8(3))
  call Hloop_QA_V(ntryL,G1H24(4),ex2(:),G1H12(1),m3h2x12(:,1),heltab2x24(:,:,4))
  call Hloop_QA_Z(ntryL,G1H24(5),ex2(:),G1H12(2),ngZu,m3h2x12(:,2),heltab2x24(:,:,5))
  call Hloop_QA_W(ntryL,G1H24(6),ex2(:),G1H12(3),m3h2x12(:,3),heltab2x24(:,:,6))
  call Hloop_QZ_A(ntryL,G1H24(7),ex3(:),G1H8(1),ngZu,m3h3x8(:,4),heltab2x24(:,:,7))
  call Hloop_Q_A(ntryL,G1H8(1),20,0,G2H8(4),n2h8(4))
  call Hloop_QZ_A(ntryL,G1H24(8),ex3(:),G1H8(1),ngZu,m3h3x8(:,5),heltab2x24(:,:,8))
  call Hloop_Q_A(ntryL,G1H8(1),20,0,G2H8(5),n2h8(5))
  call Hloop_QZ_A(ntryL,G1H24(9),ex3(:),G1H8(1),ngZd,m3h3x8(:,6),heltab2x24(:,:,9))
  call Hloop_Q_A(ntryL,G1H8(1),20,0,G2H8(6),n2h8(6))
  call Hloop_QA_V(ntryL,G1H24(10),ex2(:),G1H12(4),m3h2x12(:,4),heltab2x24(:,:,10))
  call Hloop_QA_Z(ntryL,G1H24(11),ex2(:),G1H12(5),ngZu,m3h2x12(:,5),heltab2x24(:,:,11))
  call Hloop_QA_W(ntryL,G1H24(12),ex2(:),G1H12(6),m3h2x12(:,6),heltab2x24(:,:,12))
  call Hloop_AQ_V(ntryL,G1H24(13),ex1(:),G1H12(7),m3h2x12(:,7),heltab2x24(:,:,13))
  call Hloop_AQ_Z(ntryL,G1H24(14),ex1(:),G1H12(8),ngZu,m3h2x12(:,8),heltab2x24(:,:,14))
  call Hloop_AQ_W(ntryL,G1H24(15),ex1(:),G1H12(9),m3h2x12(:,9),heltab2x24(:,:,15))
  call Hloop_AQ_V(ntryL,G1H24(16),ex1(:),G1H12(10),m3h2x12(:,10),heltab2x24(:,:,16))
  call Hloop_AQ_Z(ntryL,G1H24(17),ex1(:),G1H12(11),ngZu,m3h2x12(:,11),heltab2x24(:,:,17))
  call Hloop_AQ_W(ntryL,G1H24(18),ex1(:),G1H12(12),m3h2x12(:,12),heltab2x24(:,:,18))
  call Hloop_QA_W(ntryL,G1H24(19),ex2(:),G1H12(13),m3h2x12(:,13),heltab2x24(:,:,19))
  call Hloop_AQ_W(ntryL,G1H24(20),ex1(:),G1H12(14),m3h2x12(:,14),heltab2x24(:,:,20))
  call Hloop_AQ_V(ntryL,G2H8(1),ex1(:),G2H4(1),m3h2x4(:,1),heltab2x8(:,:,1))
  call Hloop_AQ_Z(ntryL,G2H8(2),ex1(:),G2H4(2),ngZu,m3h2x4(:,2),heltab2x8(:,:,2))
  call Hloop_AQ_W(ntryL,G2H8(3),ex1(:),G2H4(3),m3h2x4(:,3),heltab2x8(:,:,3))
  call Hloop_VQ_A(ntryL,G1H12(1),ex1(:),G1H6(1),m3h2x6(:,1),heltab2x12(:,:,1))
  call Hloop_Q_A(ntryL,G1H6(1),19,0,G2H6(1),n2h6(1))
  call Hloop_ZQ_A(ntryL,G1H12(2),ex1(:),G1H6(1),ngZu,m3h2x6(:,2),heltab2x12(:,:,2))
  call Hloop_Q_A(ntryL,G1H6(1),19,0,G2H6(2),n2h6(2))
  call Hloop_WQ_A(ntryL,G1H12(3),ex1(:),G1H6(1),m3h2x6(:,3),heltab2x12(:,:,3))
  call Hloop_Q_A(ntryL,G1H6(1),19,0,G2H6(3),n2h6(3))
  call Hloop_QA_V(ntryL,G2H8(4),ex2(:),G2H4(4),m3h2x4(:,4),heltab2x8(:,:,4))
  call Hloop_QA_Z(ntryL,G2H8(5),ex2(:),G2H4(5),ngZu,m3h2x4(:,5),heltab2x8(:,:,5))
  call Hloop_QA_W(ntryL,G2H8(6),ex2(:),G2H4(6),m3h2x4(:,6),heltab2x8(:,:,6))
  call Hloop_VQ_A(ntryL,G1H12(4),ex1(:),G1H6(1),m3h2x6(:,4),heltab2x12(:,:,4))
  call Hloop_Q_A(ntryL,G1H6(1),19,0,G2H6(4),n2h6(4))
  call Hloop_ZQ_A(ntryL,G1H12(5),ex1(:),G1H6(1),ngZu,m3h2x6(:,5),heltab2x12(:,:,5))
  call Hloop_Q_A(ntryL,G1H6(1),19,0,G2H6(5),n2h6(5))
  call Hloop_WQ_A(ntryL,G1H12(6),ex1(:),G1H6(1),m3h2x6(:,6),heltab2x12(:,:,6))
  call Hloop_Q_A(ntryL,G1H6(1),19,0,G2H6(6),n2h6(6))
  call Hloop_VA_Q(ntryL,G1H12(7),ex2(:),G1H6(1),m3h2x6(:,7),heltab2x12(:,:,7))
  call Hloop_A_Q(ntryL,G1H6(1),19,0,G2H6(7),n2h6(7))
  call Hloop_ZA_Q(ntryL,G1H12(8),ex2(:),G1H6(1),ngZu,m3h2x6(:,8),heltab2x12(:,:,8))
  call Hloop_A_Q(ntryL,G1H6(1),19,0,G2H6(8),n2h6(8))
  call Hloop_WA_Q(ntryL,G1H12(9),ex2(:),G1H6(1),m3h2x6(:,9),heltab2x12(:,:,9))
  call Hloop_A_Q(ntryL,G1H6(1),19,0,G2H6(9),n2h6(9))
  call Hloop_VA_Q(ntryL,G1H12(10),ex2(:),G1H6(1),m3h2x6(:,10),heltab2x12(:,:,10))
  call Hloop_A_Q(ntryL,G1H6(1),19,0,G2H6(10),n2h6(10))
  call Hloop_ZA_Q(ntryL,G1H12(11),ex2(:),G1H6(1),ngZu,m3h2x6(:,11),heltab2x12(:,:,11))
  call Hloop_A_Q(ntryL,G1H6(1),19,0,G2H6(11),n2h6(11))
  call Hloop_WA_Q(ntryL,G1H12(12),ex2(:),G1H6(1),m3h2x6(:,12),heltab2x12(:,:,12))
  call Hloop_A_Q(ntryL,G1H6(1),19,0,G2H6(12),n2h6(12))
  call Hloop_UV_W(ntryL,G1H12(13),18,ex3(:),4,G2H4(7),m3h3x4(:,1),heltab2x12(:,:,13))
  call Hloop_UW_V(ntryL,G1H12(14),17,ex3(:),4,G2H4(8),m3h3x4(:,2),heltab2x12(:,:,14))
  call Hotf_5pt_reduction(G2H4(1),RedSet_5(1),mass5set(:,1),  & 
G1H4(1),G1H4(2),G1H4(3),G1H4(4),G1H4(5),G1H4(6),4)
  call HG1shiftOLR(G1H4(2),8,4)
  call Hotf_5pt_reduction(G2H4(2),RedSet_5(1),mass5set(:,2),  & 
G1H4(7),G1H4(8),G1H4(9),G1H4(10),G1H4(11),G1H4(12),4)
  call HG1shiftOLR(G1H4(8),8,4)
  call Hotf_5pt_reduction(G2H4(3),RedSet_5(1),mass5set(:,3),  & 
G1H4(13),G1H4(14),G1H4(15),G1H4(16),G1H4(17),G1H4(18),4)
  call HG1shiftOLR(G1H4(14),8,4)
  call Hotf_5pt_reduction(G2H6(1),RedSet_5(2),mass5set(:,1),  & 
G1H6(1),G1H6(2),G1H6(3),G1H6(4),G1H6(5),G1H6(6),6)
  call HG1shiftOLR(G1H6(2),8,6)
  call Hotf_5pt_reduction(G2H6(2),RedSet_5(2),mass5set(:,4),  & 
G1H6(7),G1H6(8),G1H6(9),G1H6(10),G1H6(11),G1H6(12),6)
  call HG1shiftOLR(G1H6(8),8,6)
  call Hotf_5pt_reduction(G2H6(3),RedSet_5(2),mass5set(:,5),  & 
G1H6(13),G1H6(14),G1H6(15),G1H6(16),G1H6(17),G1H6(18),6)
  call HG1shiftOLR(G1H6(14),8,6)
  call Hotf_5pt_reduction(G2H4(4),RedSet_5(3),mass5set(:,1),  & 
G1H4(19),G1H4(20),G1H4(21),G1H4(22),G1H4(23),G1H4(24),4)
  call HG1shiftOLR(G1H4(20),8,4)
  call Hotf_5pt_reduction(G2H4(5),RedSet_5(3),mass5set(:,2),  & 
G1H4(25),G1H4(26),G1H4(27),G1H4(28),G1H4(29),G1H4(30),4)
  call HG1shiftOLR(G1H4(26),8,4)
  call Hotf_5pt_reduction(G2H4(6),RedSet_5(3),mass5set(:,3),  & 
G1H4(31),G1H4(32),G1H4(33),G1H4(34),G1H4(35),G1H4(36),4)
  call HG1shiftOLR(G1H4(32),8,4)
  call Hotf_5pt_reduction(G2H6(4),RedSet_5(4),mass5set(:,1),  & 
G1H6(19),G1H6(20),G1H6(21),G1H6(22),G1H6(23),G1H6(24),6)
  call HG1shiftOLR(G1H6(20),4,6)
  call Hotf_5pt_reduction(G2H6(5),RedSet_5(4),mass5set(:,4),  & 
G1H6(25),G1H6(26),G1H6(27),G1H6(28),G1H6(29),G1H6(30),6)
  call HG1shiftOLR(G1H6(26),4,6)
  call Hotf_5pt_reduction(G2H6(6),RedSet_5(4),mass5set(:,5),  & 
G1H6(31),G1H6(32),G1H6(33),G1H6(34),G1H6(35),G1H6(36),6)
  call HG1shiftOLR(G1H6(32),4,6)
  call Hotf_5pt_reduction(G2H6(7),RedSet_5(5),mass5set(:,1),  & 
G1H6(37),G1H6(38),G1H6(39),G1H6(40),G1H6(41),G1H6(42),6)
  call HG1shiftOLR(G1H6(38),8,6)
  call Hotf_5pt_reduction(G2H6(8),RedSet_5(5),mass5set(:,4),  & 
G1H6(43),G1H6(44),G1H6(45),G1H6(46),G1H6(47),G1H6(48),6)
  call HG1shiftOLR(G1H6(44),8,6)
  call Hotf_5pt_reduction(G2H6(9),RedSet_5(5),mass5set(:,5),  & 
G1H6(49),G1H6(50),G1H6(51),G1H6(52),G1H6(53),G1H6(54),6)
  call HG1shiftOLR(G1H6(50),8,6)
  call Hotf_5pt_reduction(G2H6(10),RedSet_5(6),mass5set(:,1),  & 
G1H6(55),G1H6(56),G1H6(57),G1H6(58),G1H6(59),G1H6(60),6)
  call HG1shiftOLR(G1H6(56),4,6)
  call Hotf_5pt_reduction(G2H6(11),RedSet_5(6),mass5set(:,4),  & 
G1H6(61),G1H6(62),G1H6(63),G1H6(64),G1H6(65),G1H6(66),6)
  call HG1shiftOLR(G1H6(62),4,6)
  call Hotf_5pt_reduction(G2H6(12),RedSet_5(6),mass5set(:,5),  & 
G1H6(67),G1H6(68),G1H6(69),G1H6(70),G1H6(71),G1H6(72),6)
  call HG1shiftOLR(G1H6(68),4,6)
  call Hotf_5pt_reduction(G2H4(7),RedSet_5(7),mass5set(:,6),  & 
G1H4(37),G1H4(38),G1H4(39),G1H4(40),G1H4(41),G1H4(42),4)
  call HG1shiftOLR(G1H4(38),8,4)
  call Hotf_5pt_reduction(G2H4(8),RedSet_5(8),mass5set(:,6),  & 
G1H4(43),G1H4(44),G1H4(45),G1H4(46),G1H4(47),G1H4(48),4)
  call HG1shiftOLR(G1H4(44),8,4)
  call Hloop_VA_Q(ntryL,G1H4(1),ex2(:),G1H2(1),m3h2x2(:,1),heltab2x4(:,:,1))
  call Hloop_A_Q(ntryL,G1H2(1),23,0,G2H2(1),n2h2(1))
call HGT_OLR(G1H4(2),1,1,4)
call HGT_invQ_OLR(G1H4(2),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(2),-8,0,G2H4(1),n2h4(1))
  call Hloop_QV_A(ntryL,G2H4(1),ex4(:),G2H2(2),m3h2x2(:,2),heltab2x4(:,:,2))
  call Hloop_VA_Q(ntryL,G1H4(5),ex2(:),G1H2(1),m3h2x2(:,3),heltab2x4(:,:,3))
  call Hloop_A_Q(ntryL,G1H2(1),23,0,G2H2(3),n2h2(2))
  call Hloop_VA_Q(ntryL,G1H4(6),ex2(:),G1H2(1),m3h2x2(:,4),heltab2x4(:,:,4))
  call Hloop_A_Q(ntryL,G1H2(1),23,0,G2H2(4),n2h2(3))
  call Hloop_ZA_Q(ntryL,G1H4(7),ex2(:),G1H2(1),ngZu,m3h2x2(:,5),heltab2x4(:,:,5))
  call Hloop_A_Q(ntryL,G1H2(1),23,0,G2H2(5),n2h2(4))
call HGT_OLR(G1H4(8),1,1,4)
call HGT_invQ_OLR(G1H4(8),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(8),-8,0,G2H4(2),n2h4(2))
  call Hloop_QV_A(ntryL,G2H4(2),ex4(:),G2H2(6),m3h2x2(:,6),heltab2x4(:,:,6))
  call Hloop_ZA_Q(ntryL,G1H4(11),ex2(:),G1H2(1),ngZu,m3h2x2(:,7),heltab2x4(:,:,7))
  call Hloop_A_Q(ntryL,G1H2(1),23,0,G2H2(7),n2h2(5))
  call Hloop_ZA_Q(ntryL,G1H4(12),ex2(:),G1H2(1),ngZu,m3h2x2(:,8),heltab2x4(:,:,8))
  call Hloop_A_Q(ntryL,G1H2(1),23,0,G2H2(8),n2h2(6))
  call Hloop_WA_Q(ntryL,G1H4(13),ex2(:),G1H2(1),m3h2x2(:,9),heltab2x4(:,:,9))
  call Hloop_A_Q(ntryL,G1H2(1),23,0,G2H2(9),n2h2(7))
call HGT_OLR(G1H4(14),1,1,4)
call HGT_invQ_OLR(G1H4(14),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(14),-8,0,G2H4(3),n2h4(3))
  call Hloop_QV_A(ntryL,G2H4(3),ex4(:),G2H2(10),m3h2x2(:,10),heltab2x4(:,:,10))
  call Hloop_WA_Q(ntryL,G1H4(17),ex2(:),G1H2(1),m3h2x2(:,11),heltab2x4(:,:,11))
  call Hloop_A_Q(ntryL,G1H2(1),23,0,G2H2(11),n2h2(8))
  call Hloop_WA_Q(ntryL,G1H4(18),ex2(:),G1H2(1),m3h2x2(:,12),heltab2x4(:,:,12))
  call Hloop_A_Q(ntryL,G1H2(1),23,0,G2H2(12),n2h2(9))
  call Hloop_QZ_A(ntryL,G1H6(1),ex3(:),G1H2(1),ngZu,m3h3x2(:,1),heltab2x6(:,:,1))
  call Hloop_Q_A(ntryL,G1H2(1),23,0,G2H2(13),n2h2(10))
call HGT_OLR(G1H6(2),1,1,6)
call HGT_invQ_OLR(G1H6(2),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(2),-8,0,G2H6(1),n2h6(13))
  call Hloop_AV_Q(ntryL,G2H6(1),ex4(:),G2H3(1),m3h2x3(:,1),heltab2x6(:,:,2))
  call Hloop_QZ_A(ntryL,G1H6(5),ex3(:),G1H2(1),ngZu,m3h3x2(:,2),heltab2x6(:,:,3))
  call Hloop_Q_A(ntryL,G1H2(1),23,0,G2H2(14),n2h2(11))
  call Hloop_QZ_A(ntryL,G1H6(6),ex3(:),G1H2(1),ngZu,m3h3x2(:,3),heltab2x6(:,:,4))
  call Hloop_Q_A(ntryL,G1H2(1),23,0,G2H2(15),n2h2(12))
  call Hloop_QZ_A(ntryL,G1H6(7),ex3(:),G1H2(1),ngZu,m3h3x2(:,4),heltab2x6(:,:,5))
  call Hloop_Q_A(ntryL,G1H2(1),23,0,G2H2(16),n2h2(13))
call HGT_OLR(G1H6(8),1,1,6)
call HGT_invQ_OLR(G1H6(8),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(8),-8,0,G2H6(2),n2h6(14))
  call Hloop_AV_Q(ntryL,G2H6(2),ex4(:),G2H3(2),m3h2x3(:,2),heltab2x6(:,:,6))
  call Hloop_QZ_A(ntryL,G1H6(11),ex3(:),G1H2(1),ngZu,m3h3x2(:,5),heltab2x6(:,:,7))
  call Hloop_Q_A(ntryL,G1H2(1),23,0,G2H2(17),n2h2(14))
  call Hloop_QZ_A(ntryL,G1H6(12),ex3(:),G1H2(1),ngZu,m3h3x2(:,6),heltab2x6(:,:,8))
  call Hloop_Q_A(ntryL,G1H2(1),23,0,G2H2(18),n2h2(15))
  call Hloop_QZ_A(ntryL,G1H6(13),ex3(:),G1H2(1),ngZd,m3h3x2(:,7),heltab2x6(:,:,9))
  call Hloop_Q_A(ntryL,G1H2(1),23,0,G2H2(19),n2h2(16))
call HGT_OLR(G1H6(14),1,1,6)
call HGT_invQ_OLR(G1H6(14),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(14),-8,0,G2H6(3),n2h6(15))
  call Hloop_AV_Q(ntryL,G2H6(3),ex4(:),G2H3(3),m3h2x3(:,3),heltab2x6(:,:,10))
  call Hloop_QZ_A(ntryL,G1H6(17),ex3(:),G1H2(1),ngZd,m3h3x2(:,8),heltab2x6(:,:,11))
  call Hloop_Q_A(ntryL,G1H2(1),23,0,G2H2(20),n2h2(17))
  call Hloop_QZ_A(ntryL,G1H6(18),ex3(:),G1H2(1),ngZd,m3h3x2(:,9),heltab2x6(:,:,12))
  call Hloop_Q_A(ntryL,G1H2(1),23,0,G2H2(21),n2h2(18))
  call Hloop_VQ_A(ntryL,G1H4(19),ex1(:),G1H2(1),m3h2x2(:,13),heltab2x4(:,:,13))
  call Hloop_Q_A(ntryL,G1H2(1),23,0,G2H2(22),n2h2(19))
call HGT_OLR(G1H4(20),1,1,4)
call HGT_invQ_OLR(G1H4(20),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(20),-8,0,G2H4(4),n2h4(4))
  call Hloop_AV_Q(ntryL,G2H4(4),ex4(:),G2H2(23),m3h2x2(:,14),heltab2x4(:,:,14))
  call Hloop_VQ_A(ntryL,G1H4(23),ex1(:),G1H2(1),m3h2x2(:,15),heltab2x4(:,:,15))
  call Hloop_Q_A(ntryL,G1H2(1),23,0,G2H2(24),n2h2(20))
  call Hloop_VQ_A(ntryL,G1H4(24),ex1(:),G1H2(1),m3h2x2(:,16),heltab2x4(:,:,16))
  call Hloop_Q_A(ntryL,G1H2(1),23,0,G2H2(25),n2h2(21))
  call Hloop_ZQ_A(ntryL,G1H4(25),ex1(:),G1H2(1),ngZu,m3h2x2(:,17),heltab2x4(:,:,17))
  call Hloop_Q_A(ntryL,G1H2(1),23,0,G2H2(26),n2h2(22))
call HGT_OLR(G1H4(26),1,1,4)
call HGT_invQ_OLR(G1H4(26),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(26),-8,0,G2H4(5),n2h4(5))
  call Hloop_AV_Q(ntryL,G2H4(5),ex4(:),G2H2(27),m3h2x2(:,18),heltab2x4(:,:,18))
  call Hloop_ZQ_A(ntryL,G1H4(29),ex1(:),G1H2(1),ngZu,m3h2x2(:,19),heltab2x4(:,:,19))
  call Hloop_Q_A(ntryL,G1H2(1),23,0,G2H2(28),n2h2(23))
  call Hloop_ZQ_A(ntryL,G1H4(30),ex1(:),G1H2(1),ngZu,m3h2x2(:,20),heltab2x4(:,:,20))
  call Hloop_Q_A(ntryL,G1H2(1),23,0,G2H2(29),n2h2(24))
  call Hloop_WQ_A(ntryL,G1H4(31),ex1(:),G1H2(1),m3h2x2(:,21),heltab2x4(:,:,21))
  call Hloop_Q_A(ntryL,G1H2(1),23,0,G2H2(30),n2h2(25))
call HGT_OLR(G1H4(32),1,1,4)
call HGT_invQ_OLR(G1H4(32),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(32),-8,0,G2H4(6),n2h4(6))
  call Hloop_AV_Q(ntryL,G2H4(6),ex4(:),G2H2(31),m3h2x2(:,22),heltab2x4(:,:,22))
  call Hloop_WQ_A(ntryL,G1H4(35),ex1(:),G1H2(1),m3h2x2(:,23),heltab2x4(:,:,23))
  call Hloop_Q_A(ntryL,G1H2(1),23,0,G2H2(32),n2h2(26))
  call Hloop_WQ_A(ntryL,G1H4(36),ex1(:),G1H2(1),m3h2x2(:,24),heltab2x4(:,:,24))
  call Hloop_Q_A(ntryL,G1H2(1),23,0,G2H2(33),n2h2(27))
  call Hloop_QV_A(ntryL,G1H6(19),ex4(:),G1H3(1),m3h2x3(:,4),heltab2x6(:,:,13))
  call Hloop_Q_A(ntryL,G1H3(1),27,0,G2H3(4),n2h3(1))
call HGT_OLR(G1H6(20),1,1,6)
call HGT_invQ_OLR(G1H6(20),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(20),-4,0,G2H6(4),n2h6(16))
  call Hloop_AZ_Q(ntryL,G2H6(4),ex3(:),G2H2(34),ngZu,m3h3x2(:,10),heltab2x6(:,:,14))
  call Hloop_QV_A(ntryL,G1H6(23),ex4(:),G1H3(1),m3h2x3(:,5),heltab2x6(:,:,15))
  call Hloop_Q_A(ntryL,G1H3(1),27,0,G2H3(5),n2h3(2))
  call Hloop_QV_A(ntryL,G1H6(24),ex4(:),G1H3(1),m3h2x3(:,6),heltab2x6(:,:,16))
  call Hloop_Q_A(ntryL,G1H3(1),27,0,G2H3(6),n2h3(3))
  call Hloop_QV_A(ntryL,G1H6(25),ex4(:),G1H3(1),m3h2x3(:,7),heltab2x6(:,:,17))
  call Hloop_Q_A(ntryL,G1H3(1),27,0,G2H3(7),n2h3(4))
call HGT_OLR(G1H6(26),1,1,6)
call HGT_invQ_OLR(G1H6(26),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(26),-4,0,G2H6(5),n2h6(17))
  call Hloop_AZ_Q(ntryL,G2H6(5),ex3(:),G2H2(35),ngZu,m3h3x2(:,11),heltab2x6(:,:,18))
  call Hloop_QV_A(ntryL,G1H6(29),ex4(:),G1H3(1),m3h2x3(:,8),heltab2x6(:,:,19))
  call Hloop_Q_A(ntryL,G1H3(1),27,0,G2H3(8),n2h3(5))
  call Hloop_QV_A(ntryL,G1H6(30),ex4(:),G1H3(1),m3h2x3(:,9),heltab2x6(:,:,20))
  call Hloop_Q_A(ntryL,G1H3(1),27,0,G2H3(9),n2h3(6))
  call Hloop_QV_A(ntryL,G1H6(31),ex4(:),G1H3(1),m3h2x3(:,10),heltab2x6(:,:,21))
  call Hloop_Q_A(ntryL,G1H3(1),27,0,G2H3(10),n2h3(7))
call HGT_OLR(G1H6(32),1,1,6)
call HGT_invQ_OLR(G1H6(32),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(32),-4,0,G2H6(6),n2h6(18))
  call Hloop_AZ_Q(ntryL,G2H6(6),ex3(:),G2H2(36),ngZd,m3h3x2(:,12),heltab2x6(:,:,22))
  call Hloop_QV_A(ntryL,G1H6(35),ex4(:),G1H3(1),m3h2x3(:,11),heltab2x6(:,:,23))
  call Hloop_Q_A(ntryL,G1H3(1),27,0,G2H3(11),n2h3(8))
  call Hloop_QV_A(ntryL,G1H6(36),ex4(:),G1H3(1),m3h2x3(:,12),heltab2x6(:,:,24))
  call Hloop_Q_A(ntryL,G1H3(1),27,0,G2H3(12),n2h3(9))
  call Hloop_AZ_Q(ntryL,G1H6(37),ex3(:),G1H2(1),ngZu,m3h3x2(:,13),heltab2x6(:,:,25))
  call Hloop_A_Q(ntryL,G1H2(1),23,0,G2H2(37),n2h2(28))
call HGT_OLR(G1H6(38),1,1,6)
call HGT_invQ_OLR(G1H6(38),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(38),-8,0,G2H6(7),n2h6(19))
  call Hloop_QV_A(ntryL,G2H6(7),ex4(:),G2H3(13),m3h2x3(:,13),heltab2x6(:,:,26))
  call Hloop_AZ_Q(ntryL,G1H6(41),ex3(:),G1H2(1),ngZu,m3h3x2(:,14),heltab2x6(:,:,27))
  call Hloop_A_Q(ntryL,G1H2(1),23,0,G2H2(38),n2h2(29))
  call Hloop_AZ_Q(ntryL,G1H6(42),ex3(:),G1H2(1),ngZu,m3h3x2(:,15),heltab2x6(:,:,28))
  call Hloop_A_Q(ntryL,G1H2(1),23,0,G2H2(39),n2h2(30))
  call Hloop_AZ_Q(ntryL,G1H6(43),ex3(:),G1H2(1),ngZu,m3h3x2(:,16),heltab2x6(:,:,29))
  call Hloop_A_Q(ntryL,G1H2(1),23,0,G2H2(40),n2h2(31))
call HGT_OLR(G1H6(44),1,1,6)
call HGT_invQ_OLR(G1H6(44),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(44),-8,0,G2H6(8),n2h6(20))
  call Hloop_QV_A(ntryL,G2H6(8),ex4(:),G2H3(14),m3h2x3(:,14),heltab2x6(:,:,30))
  call Hloop_AZ_Q(ntryL,G1H6(47),ex3(:),G1H2(1),ngZu,m3h3x2(:,17),heltab2x6(:,:,31))
  call Hloop_A_Q(ntryL,G1H2(1),23,0,G2H2(41),n2h2(32))
  call Hloop_AZ_Q(ntryL,G1H6(48),ex3(:),G1H2(1),ngZu,m3h3x2(:,18),heltab2x6(:,:,32))
  call Hloop_A_Q(ntryL,G1H2(1),23,0,G2H2(42),n2h2(33))
  call Hloop_AZ_Q(ntryL,G1H6(49),ex3(:),G1H2(1),ngZd,m3h3x2(:,19),heltab2x6(:,:,33))
  call Hloop_A_Q(ntryL,G1H2(1),23,0,G2H2(43),n2h2(34))
call HGT_OLR(G1H6(50),1,1,6)
call HGT_invQ_OLR(G1H6(50),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(50),-8,0,G2H6(9),n2h6(21))
  call Hloop_QV_A(ntryL,G2H6(9),ex4(:),G2H3(15),m3h2x3(:,15),heltab2x6(:,:,34))
  call Hloop_AZ_Q(ntryL,G1H6(53),ex3(:),G1H2(1),ngZd,m3h3x2(:,20),heltab2x6(:,:,35))
  call Hloop_A_Q(ntryL,G1H2(1),23,0,G2H2(44),n2h2(35))
  call Hloop_AZ_Q(ntryL,G1H6(54),ex3(:),G1H2(1),ngZd,m3h3x2(:,21),heltab2x6(:,:,36))
  call Hloop_A_Q(ntryL,G1H2(1),23,0,G2H2(45),n2h2(36))
  call Hloop_AV_Q(ntryL,G1H6(55),ex4(:),G1H3(1),m3h2x3(:,16),heltab2x6(:,:,37))
  call Hloop_A_Q(ntryL,G1H3(1),27,0,G2H3(16),n2h3(10))
call HGT_OLR(G1H6(56),1,1,6)
call HGT_invQ_OLR(G1H6(56),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(56),-4,0,G2H6(10),n2h6(22))
  call Hloop_QZ_A(ntryL,G2H6(10),ex3(:),G2H2(46),ngZu,m3h3x2(:,22),heltab2x6(:,:,38))
  call Hloop_AV_Q(ntryL,G1H6(59),ex4(:),G1H3(1),m3h2x3(:,17),heltab2x6(:,:,39))
  call Hloop_A_Q(ntryL,G1H3(1),27,0,G2H3(17),n2h3(11))
  call Hloop_AV_Q(ntryL,G1H6(60),ex4(:),G1H3(1),m3h2x3(:,18),heltab2x6(:,:,40))
  call Hloop_A_Q(ntryL,G1H3(1),27,0,G2H3(18),n2h3(12))
  call Hloop_AV_Q(ntryL,G1H6(61),ex4(:),G1H3(1),m3h2x3(:,19),heltab2x6(:,:,41))
  call Hloop_A_Q(ntryL,G1H3(1),27,0,G2H3(19),n2h3(13))
call HGT_OLR(G1H6(62),1,1,6)
call HGT_invQ_OLR(G1H6(62),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(62),-4,0,G2H6(11),n2h6(23))
  call Hloop_QZ_A(ntryL,G2H6(11),ex3(:),G2H2(47),ngZu,m3h3x2(:,23),heltab2x6(:,:,42))
  call Hloop_AV_Q(ntryL,G1H6(65),ex4(:),G1H3(1),m3h2x3(:,20),heltab2x6(:,:,43))
  call Hloop_A_Q(ntryL,G1H3(1),27,0,G2H3(20),n2h3(14))
  call Hloop_AV_Q(ntryL,G1H6(66),ex4(:),G1H3(1),m3h2x3(:,21),heltab2x6(:,:,44))
  call Hloop_A_Q(ntryL,G1H3(1),27,0,G2H3(21),n2h3(15))
  call Hloop_AV_Q(ntryL,G1H6(67),ex4(:),G1H3(1),m3h2x3(:,22),heltab2x6(:,:,45))
  call Hloop_A_Q(ntryL,G1H3(1),27,0,G2H3(22),n2h3(16))
call HGT_OLR(G1H6(68),1,1,6)
call HGT_invQ_OLR(G1H6(68),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(68),-4,0,G2H6(12),n2h6(24))
  call Hloop_QZ_A(ntryL,G2H6(12),ex3(:),G2H2(48),ngZd,m3h3x2(:,24),heltab2x6(:,:,46))
  call Hloop_AV_Q(ntryL,G1H6(71),ex4(:),G1H3(1),m3h2x3(:,23),heltab2x6(:,:,47))
  call Hloop_A_Q(ntryL,G1H3(1),27,0,G2H3(23),n2h3(17))
  call Hloop_AV_Q(ntryL,G1H6(72),ex4(:),G1H3(1),m3h2x3(:,24),heltab2x6(:,:,48))
  call Hloop_A_Q(ntryL,G1H3(1),27,0,G2H3(24),n2h3(18))
  call Hloop_WQ_A(ntryL,G1H4(37),ex1(:),G1H2(1),m3h2x2(:,25),heltab2x4(:,:,25))
  call Hloop_Q_A(ntryL,G1H2(1),23,0,G2H2(49),n2h2(37))
call HGT_OLR(G1H4(38),1,1,4)
call HGT_invQ_OLR(G1H4(38),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(38),-8,0,G2H4(7),n2h4(7))
  call Hloop_AV_Q(ntryL,G2H4(7),ex4(:),G2H2(50),m3h2x2(:,26),heltab2x4(:,:,26))
  call Hloop_WQ_A(ntryL,G1H4(41),ex1(:),G1H2(1),m3h2x2(:,27),heltab2x4(:,:,27))
  call Hloop_Q_A(ntryL,G1H2(1),23,0,G2H2(51),n2h2(38))
  call Hloop_WQ_A(ntryL,G1H4(42),ex1(:),G1H2(1),m3h2x2(:,28),heltab2x4(:,:,28))
  call Hloop_Q_A(ntryL,G1H2(1),23,0,G2H2(52),n2h2(39))
  call Hloop_WA_Q(ntryL,G1H4(43),ex2(:),G1H2(1),m3h2x2(:,29),heltab2x4(:,:,29))
  call Hloop_A_Q(ntryL,G1H2(1),23,0,G2H2(53),n2h2(40))
call HGT_OLR(G1H4(44),1,1,4)
call HGT_invQ_OLR(G1H4(44),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(44),-8,0,G2H4(8),n2h4(8))
  call Hloop_QV_A(ntryL,G2H4(8),ex4(:),G2H2(54),m3h2x2(:,30),heltab2x4(:,:,30))
  call Hloop_WA_Q(ntryL,G1H4(47),ex2(:),G1H2(1),m3h2x2(:,31),heltab2x4(:,:,31))
  call Hloop_A_Q(ntryL,G1H2(1),23,0,G2H2(55),n2h2(41))
  call Hloop_WA_Q(ntryL,G1H4(48),ex2(:),G1H2(1),m3h2x2(:,32),heltab2x4(:,:,32))
  call Hloop_A_Q(ntryL,G1H2(1),23,0,G2H2(56),n2h2(42))
  call Hotf_5pt_reduction(G2H2(1),RedSet_5(1),mass5set(:,1),  & 
G1H2(1),G1H2(2),G1H2(3),G1H2(4),G1H2(5),G1H2(6),2)
  call HG1shiftOLR(G1H2(2),8,2)
  call Hotf_4pt_reduction(G2H2(4),RedSet_4(1),mass4set(:,1),  & 
G1H2(7),G1H2(8),G1H2(9),G1H2(10),G1H2(11),2)
  call HG1shiftOLR(G1H2(8),10,2)
  call Hotf_5pt_reduction(G2H2(5),RedSet_5(1),mass5set(:,2),  & 
G1H2(12),G1H2(13),G1H2(14),G1H2(15),G1H2(16),G1H2(17),2)
  call HG1shiftOLR(G1H2(13),8,2)
  call Hotf_4pt_reduction(G2H2(8),RedSet_4(1),mass4set(:,2),  & 
G1H2(18),G1H2(19),G1H2(20),G1H2(21),G1H2(22),2)
  call HG1shiftOLR(G1H2(19),10,2)
  call Hotf_5pt_reduction(G2H2(9),RedSet_5(1),mass5set(:,3),  & 
G1H2(23),G1H2(24),G1H2(25),G1H2(26),G1H2(27),G1H2(28),2)
  call HG1shiftOLR(G1H2(24),8,2)
  call Hotf_4pt_reduction(G2H2(12),RedSet_4(1),mass4set(:,3),  & 
G1H2(29),G1H2(30),G1H2(31),G1H2(32),G1H2(33),2)
  call HG1shiftOLR(G1H2(30),10,2)
  call Hotf_5pt_reduction(G2H2(13),RedSet_5(2),mass5set(:,1),  & 
G1H2(34),G1H2(35),G1H2(36),G1H2(37),G1H2(38),G1H2(39),2)
  call HG1shiftOLR(G1H2(35),8,2)
  call Hotf_4pt_reduction(G2H2(15),RedSet_4(2),mass4set(:,1),  & 
G1H2(40),G1H2(41),G1H2(42),G1H2(43),G1H2(44),2)
  call HG1shiftOLR(G1H2(41),12,2)
  call Hotf_5pt_reduction(G2H2(16),RedSet_5(2),mass5set(:,4),  & 
G1H2(45),G1H2(46),G1H2(47),G1H2(48),G1H2(49),G1H2(50),2)
  call HG1shiftOLR(G1H2(46),8,2)
  call Hotf_4pt_reduction(G2H2(18),RedSet_4(2),mass4set(:,4),  & 
G1H2(51),G1H2(52),G1H2(53),G1H2(54),G1H2(55),2)
  call HG1shiftOLR(G1H2(52),12,2)
  call Hotf_5pt_reduction(G2H2(19),RedSet_5(2),mass5set(:,5),  & 
G1H2(56),G1H2(57),G1H2(58),G1H2(59),G1H2(60),G1H2(61),2)
  call HG1shiftOLR(G1H2(57),8,2)
  call Hotf_4pt_reduction(G2H2(21),RedSet_4(2),mass4set(:,5),  & 
G1H2(62),G1H2(63),G1H2(64),G1H2(65),G1H2(66),2)
  call HG1shiftOLR(G1H2(63),12,2)
  call Hotf_5pt_reduction(G2H2(22),RedSet_5(3),mass5set(:,1),  & 
G1H2(67),G1H2(68),G1H2(69),G1H2(70),G1H2(71),G1H2(72),2)
  call HG1shiftOLR(G1H2(68),8,2)
  call Hotf_4pt_reduction(G2H2(25),RedSet_4(3),mass4set(:,1),  & 
G1H2(73),G1H2(74),G1H2(75),G1H2(76),G1H2(77),2)
  call HG1shiftOLR(G1H2(74),9,2)
  call Hotf_5pt_reduction(G2H2(26),RedSet_5(3),mass5set(:,2),  & 
G1H2(78),G1H2(79),G1H2(80),G1H2(81),G1H2(82),G1H2(83),2)
  call HG1shiftOLR(G1H2(79),8,2)
  call Hotf_4pt_reduction(G2H2(29),RedSet_4(3),mass4set(:,2),  & 
G1H2(84),G1H2(85),G1H2(86),G1H2(87),G1H2(88),2)
  call HG1shiftOLR(G1H2(85),9,2)
  call Hotf_5pt_reduction(G2H2(30),RedSet_5(3),mass5set(:,3),  & 
G1H2(89),G1H2(90),G1H2(91),G1H2(92),G1H2(93),G1H2(94),2)
  call HG1shiftOLR(G1H2(90),8,2)
  call Hotf_4pt_reduction(G2H2(33),RedSet_4(3),mass4set(:,3),  & 
G1H2(95),G1H2(96),G1H2(97),G1H2(98),G1H2(99),2)
  call HG1shiftOLR(G1H2(96),9,2)
  call Hotf_5pt_reduction(G2H3(4),RedSet_5(4),mass5set(:,1),  & 
G1H3(1),G1H3(2),G1H3(3),G1H3(4),G1H3(5),G1H3(6),3)
  call HG1shiftOLR(G1H3(2),4,3)
  call Hotf_4pt_reduction(G2H3(6),RedSet_4(2),mass4set(:,1),  & 
G1H3(7),G1H3(8),G1H3(9),G1H3(10),G1H3(11),3)
  call HG1shiftOLR(G1H3(8),12,3)
  call Hotf_5pt_reduction(G2H3(7),RedSet_5(4),mass5set(:,4),  & 
G1H3(12),G1H3(13),G1H3(14),G1H3(15),G1H3(16),G1H3(17),3)
  call HG1shiftOLR(G1H3(13),4,3)
  call Hotf_4pt_reduction(G2H3(9),RedSet_4(2),mass4set(:,4),  & 
G1H3(18),G1H3(19),G1H3(20),G1H3(21),G1H3(22),3)
  call HG1shiftOLR(G1H3(19),12,3)
  call Hotf_5pt_reduction(G2H3(10),RedSet_5(4),mass5set(:,5),  & 
G1H3(23),G1H3(24),G1H3(25),G1H3(26),G1H3(27),G1H3(28),3)
  call HG1shiftOLR(G1H3(24),4,3)
  call Hotf_4pt_reduction(G2H3(12),RedSet_4(2),mass4set(:,5),  & 
G1H3(29),G1H3(30),G1H3(31),G1H3(32),G1H3(33),3)
  call HG1shiftOLR(G1H3(30),12,3)
  call Hotf_5pt_reduction(G2H2(37),RedSet_5(5),mass5set(:,1),  & 
G1H2(100),G1H2(101),G1H2(102),G1H2(103),G1H2(104),G1H2(105),2)
  call HG1shiftOLR(G1H2(101),8,2)
  call Hotf_4pt_reduction(G2H2(39),RedSet_4(4),mass4set(:,1),  & 
G1H2(106),G1H2(107),G1H2(108),G1H2(109),G1H2(110),2)
  call HG1shiftOLR(G1H2(107),12,2)
  call Hotf_5pt_reduction(G2H2(40),RedSet_5(5),mass5set(:,4),  & 
G1H2(111),G1H2(112),G1H2(113),G1H2(114),G1H2(115),G1H2(116),2)
  call HG1shiftOLR(G1H2(112),8,2)
  call Hotf_4pt_reduction(G2H2(42),RedSet_4(4),mass4set(:,4),  & 
G1H2(117),G1H2(118),G1H2(119),G1H2(120),G1H2(121),2)
  call HG1shiftOLR(G1H2(118),12,2)
  call Hotf_5pt_reduction(G2H2(43),RedSet_5(5),mass5set(:,5),  & 
G1H2(122),G1H2(123),G1H2(124),G1H2(125),G1H2(126),G1H2(127),2)
  call HG1shiftOLR(G1H2(123),8,2)
  call Hotf_4pt_reduction(G2H2(45),RedSet_4(4),mass4set(:,5),  & 
G1H2(128),G1H2(129),G1H2(130),G1H2(131),G1H2(132),2)
  call HG1shiftOLR(G1H2(129),12,2)
  call Hotf_5pt_reduction(G2H3(16),RedSet_5(6),mass5set(:,1),  & 
G1H3(34),G1H3(35),G1H3(36),G1H3(37),G1H3(38),G1H3(39),3)
  call HG1shiftOLR(G1H3(35),4,3)
  call Hotf_4pt_reduction(G2H3(18),RedSet_4(4),mass4set(:,1),  & 
G1H3(40),G1H3(41),G1H3(42),G1H3(43),G1H3(44),3)
  call HG1shiftOLR(G1H3(41),12,3)
  call Hotf_5pt_reduction(G2H3(19),RedSet_5(6),mass5set(:,4),  & 
G1H3(45),G1H3(46),G1H3(47),G1H3(48),G1H3(49),G1H3(50),3)
  call HG1shiftOLR(G1H3(46),4,3)
  call Hotf_4pt_reduction(G2H3(21),RedSet_4(4),mass4set(:,4),  & 
G1H3(51),G1H3(52),G1H3(53),G1H3(54),G1H3(55),3)
  call HG1shiftOLR(G1H3(52),12,3)
  call Hotf_5pt_reduction(G2H3(22),RedSet_5(6),mass5set(:,5),  & 
G1H3(56),G1H3(57),G1H3(58),G1H3(59),G1H3(60),G1H3(61),3)
  call HG1shiftOLR(G1H3(57),4,3)
  call Hotf_4pt_reduction(G2H3(24),RedSet_4(4),mass4set(:,5),  & 
G1H3(62),G1H3(63),G1H3(64),G1H3(65),G1H3(66),3)
  call HG1shiftOLR(G1H3(63),12,3)
  call Hotf_5pt_reduction(G2H2(49),RedSet_5(7),mass5set(:,6),  & 
G1H2(133),G1H2(134),G1H2(135),G1H2(136),G1H2(137),G1H2(138),2)
  call HG1shiftOLR(G1H2(134),8,2)
  call Hotf_4pt_reduction(G2H2(52),RedSet_4(5),mass4set(:,6),  & 
G1H2(139),G1H2(140),G1H2(141),G1H2(142),G1H2(143),2)
  call HG1shiftOLR(G1H2(140),9,2)
  call Hotf_5pt_reduction(G2H2(53),RedSet_5(8),mass5set(:,6),  & 
G1H2(144),G1H2(145),G1H2(146),G1H2(147),G1H2(148),G1H2(149),2)
  call HG1shiftOLR(G1H2(145),8,2)
  call Hotf_4pt_reduction(G2H2(56),RedSet_4(6),mass4set(:,6),  & 
G1H2(150),G1H2(151),G1H2(152),G1H2(153),G1H2(154),2)
  call HG1shiftOLR(G1H2(151),10,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(7),[G1H2(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(18),[G1H2(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(29),[G1H2(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(40),[G1H2(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(51),[G1H2(50)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(62),[G1H2(61)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(73),[G1H2(72)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(84),[G1H2(83)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(95),[G1H2(94)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(7),[G1H3(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(18),[G1H3(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(29),[G1H3(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(106),[G1H2(105)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(117),[G1H2(116)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(128),[G1H2(127)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(40),[G1H3(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(51),[G1H3(50)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(62),[G1H3(61)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(139),[G1H2(138)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(150),[G1H2(149)])
  call Hloop_AV_Q(ntryL,G1H2(1),ex4(:),G1H1(1),m3h2x1(:,1),heltab2x2(:,:,1))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(1),n2h1(1))
  call Hloop_AV_Q(ntryL,G1H2(2),ex4(:),G1H1(1),m3h2x1(:,2),heltab2x2(:,:,2))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(2),n2h1(2))
  call Hloop_AV_Q(ntryL,G1H2(7),ex4(:),G1H1(1),m3h2x1(:,3),heltab2x2(:,:,3))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(3),n2h1(3))
  call Hloop_AV_Q(ntryL,G1H2(8),ex4(:),G1H1(1),m3h2x1(:,4),heltab2x2(:,:,4))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,0,G2tensor(4),n2h1(4))
  call Hloop_AV_Q(ntryL,G1H2(12),ex4(:),G1H1(1),m3h2x1(:,5),heltab2x2(:,:,5))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(5),n2h1(5))
  call Hloop_AV_Q(ntryL,G1H2(13),ex4(:),G1H1(1),m3h2x1(:,6),heltab2x2(:,:,6))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(6),n2h1(6))
  call Hloop_AV_Q(ntryL,G1H2(18),ex4(:),G1H1(1),m3h2x1(:,7),heltab2x2(:,:,7))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(7),n2h1(7))
  call Hloop_AV_Q(ntryL,G1H2(19),ex4(:),G1H1(1),m3h2x1(:,8),heltab2x2(:,:,8))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,0,G2tensor(8),n2h1(8))
  call Hloop_AV_Q(ntryL,G1H2(23),ex4(:),G1H1(1),m3h2x1(:,9),heltab2x2(:,:,9))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(9),n2h1(9))
  call Hloop_AV_Q(ntryL,G1H2(24),ex4(:),G1H1(1),m3h2x1(:,10),heltab2x2(:,:,10))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(10),n2h1(10))
  call Hloop_AV_Q(ntryL,G1H2(29),ex4(:),G1H1(1),m3h2x1(:,11),heltab2x2(:,:,11))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(11),n2h1(11))
  call Hloop_AV_Q(ntryL,G1H2(30),ex4(:),G1H1(1),m3h2x1(:,12),heltab2x2(:,:,12))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,0,G2tensor(12),n2h1(12))
  call Hloop_QV_A(ntryL,G1H2(34),ex4(:),G1H1(1),m3h2x1(:,13),heltab2x2(:,:,13))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(13),n2h1(13))
  call Hloop_QV_A(ntryL,G1H2(35),ex4(:),G1H1(1),m3h2x1(:,14),heltab2x2(:,:,14))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(14),n2h1(14))
  call Hloop_QV_A(ntryL,G1H2(40),ex4(:),G1H1(1),m3h2x1(:,15),heltab2x2(:,:,15))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(15),n2h1(15))
  call Hloop_QV_A(ntryL,G1H2(41),ex4(:),G1H1(1),m3h2x1(:,16),heltab2x2(:,:,16))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(16),n2h1(16))
  call Hloop_QV_A(ntryL,G1H2(45),ex4(:),G1H1(1),m3h2x1(:,17),heltab2x2(:,:,17))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(17),n2h1(17))
  call Hloop_QV_A(ntryL,G1H2(46),ex4(:),G1H1(1),m3h2x1(:,18),heltab2x2(:,:,18))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(18),n2h1(18))
  call Hloop_QV_A(ntryL,G1H2(51),ex4(:),G1H1(1),m3h2x1(:,19),heltab2x2(:,:,19))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(19),n2h1(19))
  call Hloop_QV_A(ntryL,G1H2(52),ex4(:),G1H1(1),m3h2x1(:,20),heltab2x2(:,:,20))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(20),n2h1(20))
  call Hloop_QV_A(ntryL,G1H2(56),ex4(:),G1H1(1),m3h2x1(:,21),heltab2x2(:,:,21))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(21),n2h1(21))
  call Hloop_QV_A(ntryL,G1H2(57),ex4(:),G1H1(1),m3h2x1(:,22),heltab2x2(:,:,22))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(22),n2h1(22))
  call Hloop_QV_A(ntryL,G1H2(62),ex4(:),G1H1(1),m3h2x1(:,23),heltab2x2(:,:,23))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(23),n2h1(23))
  call Hloop_QV_A(ntryL,G1H2(63),ex4(:),G1H1(1),m3h2x1(:,24),heltab2x2(:,:,24))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(24),n2h1(24))
  call Hloop_QV_A(ntryL,G1H2(67),ex4(:),G1H1(1),m3h2x1(:,25),heltab2x2(:,:,25))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(25),n2h1(25))
  call Hloop_QV_A(ntryL,G1H2(68),ex4(:),G1H1(1),m3h2x1(:,26),heltab2x2(:,:,26))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(26),n2h1(26))
  call Hloop_QV_A(ntryL,G1H2(73),ex4(:),G1H1(1),m3h2x1(:,27),heltab2x2(:,:,27))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(27),n2h1(27))
  call Hloop_QV_A(ntryL,G1H2(74),ex4(:),G1H1(1),m3h2x1(:,28),heltab2x2(:,:,28))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,0,G2tensor(28),n2h1(28))
  call Hloop_QV_A(ntryL,G1H2(78),ex4(:),G1H1(1),m3h2x1(:,29),heltab2x2(:,:,29))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(29),n2h1(29))
  call Hloop_QV_A(ntryL,G1H2(79),ex4(:),G1H1(1),m3h2x1(:,30),heltab2x2(:,:,30))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(30),n2h1(30))
  call Hloop_QV_A(ntryL,G1H2(84),ex4(:),G1H1(1),m3h2x1(:,31),heltab2x2(:,:,31))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(31),n2h1(31))
  call Hloop_QV_A(ntryL,G1H2(85),ex4(:),G1H1(1),m3h2x1(:,32),heltab2x2(:,:,32))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,0,G2tensor(32),n2h1(32))
  call Hloop_QV_A(ntryL,G1H2(89),ex4(:),G1H1(1),m3h2x1(:,33),heltab2x2(:,:,33))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(33),n2h1(33))
  call Hloop_QV_A(ntryL,G1H2(90),ex4(:),G1H1(1),m3h2x1(:,34),heltab2x2(:,:,34))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(34),n2h1(34))
  call Hloop_QV_A(ntryL,G1H2(95),ex4(:),G1H1(1),m3h2x1(:,35),heltab2x2(:,:,35))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(35),n2h1(35))
  call Hloop_QV_A(ntryL,G1H2(96),ex4(:),G1H1(1),m3h2x1(:,36),heltab2x2(:,:,36))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,0,G2tensor(36),n2h1(36))
  call Hloop_QZ_A(ntryL,G1H3(1),ex3(:),G1H1(1),ngZu,m3h3x1(:,1),heltab2x3(:,:,1))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(37),n2h1(37))
  call Hloop_QZ_A(ntryL,G1H3(2),ex3(:),G1H1(1),ngZu,m3h3x1(:,2),heltab2x3(:,:,2))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(38),n2h1(38))
  call Hloop_QZ_A(ntryL,G1H3(7),ex3(:),G1H1(1),ngZu,m3h3x1(:,3),heltab2x3(:,:,3))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(39),n2h1(39))
  call Hloop_QZ_A(ntryL,G1H3(8),ex3(:),G1H1(1),ngZu,m3h3x1(:,4),heltab2x3(:,:,4))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(40),n2h1(40))
  call Hloop_QZ_A(ntryL,G1H3(12),ex3(:),G1H1(1),ngZu,m3h3x1(:,5),heltab2x3(:,:,5))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(41),n2h1(41))
  call Hloop_QZ_A(ntryL,G1H3(13),ex3(:),G1H1(1),ngZu,m3h3x1(:,6),heltab2x3(:,:,6))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(42),n2h1(42))
  call Hloop_QZ_A(ntryL,G1H3(18),ex3(:),G1H1(1),ngZu,m3h3x1(:,7),heltab2x3(:,:,7))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(43),n2h1(43))
  call Hloop_QZ_A(ntryL,G1H3(19),ex3(:),G1H1(1),ngZu,m3h3x1(:,8),heltab2x3(:,:,8))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(44),n2h1(44))
  call Hloop_QZ_A(ntryL,G1H3(23),ex3(:),G1H1(1),ngZd,m3h3x1(:,9),heltab2x3(:,:,9))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(45),n2h1(45))
  call Hloop_QZ_A(ntryL,G1H3(24),ex3(:),G1H1(1),ngZd,m3h3x1(:,10),heltab2x3(:,:,10))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(46),n2h1(46))
  call Hloop_QZ_A(ntryL,G1H3(29),ex3(:),G1H1(1),ngZd,m3h3x1(:,11),heltab2x3(:,:,11))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(47),n2h1(47))
  call Hloop_QZ_A(ntryL,G1H3(30),ex3(:),G1H1(1),ngZd,m3h3x1(:,12),heltab2x3(:,:,12))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(48),n2h1(48))
  call Hloop_AV_Q(ntryL,G1H2(100),ex4(:),G1H1(1),m3h2x1(:,37),heltab2x2(:,:,37))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(49),n2h1(49))
  call Hloop_AV_Q(ntryL,G1H2(101),ex4(:),G1H1(1),m3h2x1(:,38),heltab2x2(:,:,38))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(50),n2h1(50))
  call Hloop_AV_Q(ntryL,G1H2(106),ex4(:),G1H1(1),m3h2x1(:,39),heltab2x2(:,:,39))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(51),n2h1(51))
  call Hloop_AV_Q(ntryL,G1H2(107),ex4(:),G1H1(1),m3h2x1(:,40),heltab2x2(:,:,40))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,0,G2tensor(52),n2h1(52))
  call Hloop_AV_Q(ntryL,G1H2(111),ex4(:),G1H1(1),m3h2x1(:,41),heltab2x2(:,:,41))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(53),n2h1(53))
  call Hloop_AV_Q(ntryL,G1H2(112),ex4(:),G1H1(1),m3h2x1(:,42),heltab2x2(:,:,42))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(54),n2h1(54))
  call Hloop_AV_Q(ntryL,G1H2(117),ex4(:),G1H1(1),m3h2x1(:,43),heltab2x2(:,:,43))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(55),n2h1(55))
  call Hloop_AV_Q(ntryL,G1H2(118),ex4(:),G1H1(1),m3h2x1(:,44),heltab2x2(:,:,44))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,0,G2tensor(56),n2h1(56))
  call Hloop_AV_Q(ntryL,G1H2(122),ex4(:),G1H1(1),m3h2x1(:,45),heltab2x2(:,:,45))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(57),n2h1(57))
  call Hloop_AV_Q(ntryL,G1H2(123),ex4(:),G1H1(1),m3h2x1(:,46),heltab2x2(:,:,46))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(58),n2h1(58))
  call Hloop_AV_Q(ntryL,G1H2(128),ex4(:),G1H1(1),m3h2x1(:,47),heltab2x2(:,:,47))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(59),n2h1(59))
  call Hloop_AV_Q(ntryL,G1H2(129),ex4(:),G1H1(1),m3h2x1(:,48),heltab2x2(:,:,48))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,0,G2tensor(60),n2h1(60))
  call Hloop_AZ_Q(ntryL,G1H3(34),ex3(:),G1H1(1),ngZu,m3h3x1(:,13),heltab2x3(:,:,13))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(61),n2h1(61))
  call Hloop_AZ_Q(ntryL,G1H3(35),ex3(:),G1H1(1),ngZu,m3h3x1(:,14),heltab2x3(:,:,14))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(62),n2h1(62))
  call Hloop_AZ_Q(ntryL,G1H3(40),ex3(:),G1H1(1),ngZu,m3h3x1(:,15),heltab2x3(:,:,15))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(63),n2h1(63))
  call Hloop_AZ_Q(ntryL,G1H3(41),ex3(:),G1H1(1),ngZu,m3h3x1(:,16),heltab2x3(:,:,16))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,0,G2tensor(64),n2h1(64))
  call Hloop_AZ_Q(ntryL,G1H3(45),ex3(:),G1H1(1),ngZu,m3h3x1(:,17),heltab2x3(:,:,17))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(65),n2h1(65))
  call Hloop_AZ_Q(ntryL,G1H3(46),ex3(:),G1H1(1),ngZu,m3h3x1(:,18),heltab2x3(:,:,18))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(66),n2h1(66))
  call Hloop_AZ_Q(ntryL,G1H3(51),ex3(:),G1H1(1),ngZu,m3h3x1(:,19),heltab2x3(:,:,19))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(67),n2h1(67))
  call Hloop_AZ_Q(ntryL,G1H3(52),ex3(:),G1H1(1),ngZu,m3h3x1(:,20),heltab2x3(:,:,20))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,0,G2tensor(68),n2h1(68))
  call Hloop_AZ_Q(ntryL,G1H3(56),ex3(:),G1H1(1),ngZd,m3h3x1(:,21),heltab2x3(:,:,21))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(69),n2h1(69))
  call Hloop_AZ_Q(ntryL,G1H3(57),ex3(:),G1H1(1),ngZd,m3h3x1(:,22),heltab2x3(:,:,22))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(70),n2h1(70))
  call Hloop_AZ_Q(ntryL,G1H3(62),ex3(:),G1H1(1),ngZd,m3h3x1(:,23),heltab2x3(:,:,23))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(71),n2h1(71))
  call Hloop_AZ_Q(ntryL,G1H3(63),ex3(:),G1H1(1),ngZd,m3h3x1(:,24),heltab2x3(:,:,24))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,0,G2tensor(72),n2h1(72))
  call Hloop_QV_A(ntryL,G1H2(133),ex4(:),G1H1(1),m3h2x1(:,49),heltab2x2(:,:,49))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(73),n2h1(73))
  call Hloop_QV_A(ntryL,G1H2(134),ex4(:),G1H1(1),m3h2x1(:,50),heltab2x2(:,:,50))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(74),n2h1(74))
  call Hloop_QV_A(ntryL,G1H2(139),ex4(:),G1H1(1),m3h2x1(:,51),heltab2x2(:,:,51))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(75),n2h1(75))
  call Hloop_QV_A(ntryL,G1H2(140),ex4(:),G1H1(1),m3h2x1(:,52),heltab2x2(:,:,52))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,0,G2tensor(76),n2h1(76))
  call Hloop_AV_Q(ntryL,G1H2(144),ex4(:),G1H1(1),m3h2x1(:,53),heltab2x2(:,:,53))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(77),n2h1(77))
  call Hloop_AV_Q(ntryL,G1H2(145),ex4(:),G1H1(1),m3h2x1(:,54),heltab2x2(:,:,54))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(78),n2h1(78))
  call Hloop_AV_Q(ntryL,G1H2(150),ex4(:),G1H1(1),m3h2x1(:,55),heltab2x2(:,:,55))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(79),n2h1(79))
  call Hloop_AV_Q(ntryL,G1H2(151),ex4(:),G1H1(1),m3h2x1(:,56),heltab2x2(:,:,56))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,0,G2tensor(80),n2h1(80))
  call Hotf_5pt_reduction_last(G2tensor(1),RedSet_5(1),mass5set(:,1),  & 
G1tensor(1),G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(5),G1tensor(6))
  call G_TensorShift(G1tensor(2),8)
  call Hotf_5pt_reduction_last(G2tensor(5),RedSet_5(1),mass5set(:,2),  & 
G1tensor(7),G1tensor(8),G1tensor(9),G1tensor(10),G1tensor(11),G1tensor(12))
  call G_TensorShift(G1tensor(8),8)
  call Hotf_5pt_reduction_last(G2tensor(9),RedSet_5(1),mass5set(:,3),  & 
G1tensor(13),G1tensor(14),G1tensor(15),G1tensor(16),G1tensor(17),G1tensor(18))
  call G_TensorShift(G1tensor(14),8)
  call Hotf_5pt_reduction_last(G2tensor(13),RedSet_5(2),mass5set(:,1),  & 
G1tensor(19),G1tensor(20),G1tensor(21),G1tensor(22),G1tensor(23),G1tensor(24))
  call G_TensorShift(G1tensor(20),8)
  call Hotf_5pt_reduction_last(G2tensor(17),RedSet_5(2),mass5set(:,4),  & 
G1tensor(25),G1tensor(26),G1tensor(27),G1tensor(28),G1tensor(29),G1tensor(30))
  call G_TensorShift(G1tensor(26),8)
  call Hotf_5pt_reduction_last(G2tensor(21),RedSet_5(2),mass5set(:,5),  & 
G1tensor(31),G1tensor(32),G1tensor(33),G1tensor(34),G1tensor(35),G1tensor(36))
  call G_TensorShift(G1tensor(32),8)
  call Hotf_5pt_reduction_last(G2tensor(25),RedSet_5(3),mass5set(:,1),  & 
G1tensor(37),G1tensor(38),G1tensor(39),G1tensor(40),G1tensor(41),G1tensor(42))
  call G_TensorShift(G1tensor(38),8)
  call Hotf_5pt_reduction_last(G2tensor(29),RedSet_5(3),mass5set(:,2),  & 
G1tensor(43),G1tensor(44),G1tensor(45),G1tensor(46),G1tensor(47),G1tensor(48))
  call G_TensorShift(G1tensor(44),8)
  call Hotf_5pt_reduction_last(G2tensor(33),RedSet_5(3),mass5set(:,3),  & 
G1tensor(49),G1tensor(50),G1tensor(51),G1tensor(52),G1tensor(53),G1tensor(54))
  call G_TensorShift(G1tensor(50),8)
  call Hotf_5pt_reduction_last(G2tensor(37),RedSet_5(4),mass5set(:,1),  & 
G1tensor(55),G1tensor(56),G1tensor(57),G1tensor(58),G1tensor(59),G1tensor(60))
  call G_TensorShift(G1tensor(56),4)
  call Hotf_5pt_reduction_last(G2tensor(41),RedSet_5(4),mass5set(:,4),  & 
G1tensor(61),G1tensor(62),G1tensor(63),G1tensor(64),G1tensor(65),G1tensor(66))
  call G_TensorShift(G1tensor(62),4)
  call Hotf_5pt_reduction_last(G2tensor(45),RedSet_5(4),mass5set(:,5),  & 
G1tensor(67),G1tensor(68),G1tensor(69),G1tensor(70),G1tensor(71),G1tensor(72))
  call G_TensorShift(G1tensor(68),4)
  call Hotf_5pt_reduction_last(G2tensor(49),RedSet_5(5),mass5set(:,1),  & 
G1tensor(73),G1tensor(74),G1tensor(75),G1tensor(76),G1tensor(77),G1tensor(78))
  call G_TensorShift(G1tensor(74),8)
  call Hotf_5pt_reduction_last(G2tensor(53),RedSet_5(5),mass5set(:,4),  & 
G1tensor(79),G1tensor(80),G1tensor(81),G1tensor(82),G1tensor(83),G1tensor(84))
  call G_TensorShift(G1tensor(80),8)
  call Hotf_5pt_reduction_last(G2tensor(57),RedSet_5(5),mass5set(:,5),  & 
G1tensor(85),G1tensor(86),G1tensor(87),G1tensor(88),G1tensor(89),G1tensor(90))
  call G_TensorShift(G1tensor(86),8)
  call Hotf_5pt_reduction_last(G2tensor(61),RedSet_5(6),mass5set(:,1),  & 
G1tensor(91),G1tensor(92),G1tensor(93),G1tensor(94),G1tensor(95),G1tensor(96))
  call G_TensorShift(G1tensor(92),4)
  call Hotf_5pt_reduction_last(G2tensor(65),RedSet_5(6),mass5set(:,4),  & 
G1tensor(97),G1tensor(98),G1tensor(99),G1tensor(100),G1tensor(101),G1tensor(102))
  call G_TensorShift(G1tensor(98),4)
  call Hotf_5pt_reduction_last(G2tensor(69),RedSet_5(6),mass5set(:,5),  & 
G1tensor(103),G1tensor(104),G1tensor(105),G1tensor(106),G1tensor(107),G1tensor(108))
  call G_TensorShift(G1tensor(104),4)
  call Hotf_5pt_reduction_last(G2tensor(73),RedSet_5(7),mass5set(:,6),  & 
G1tensor(109),G1tensor(110),G1tensor(111),G1tensor(112),G1tensor(113),G1tensor(114))
  call G_TensorShift(G1tensor(110),8)
  call Hotf_5pt_reduction_last(G2tensor(77),RedSet_5(8),mass5set(:,6),  & 
G1tensor(115),G1tensor(116),G1tensor(117),G1tensor(118),G1tensor(119),G1tensor(120))
  call G_TensorShift(G1tensor(116),8)
  call ol_merge_tensors(T1sum(1),[G1tensor(1)])
  call ol_merge_tensors(T1sum(2),[G1tensor(7)])
  call ol_merge_tensors(T1sum(3),[G1tensor(13)])
  call ol_merge_tensors(T1sum(4),[G1tensor(19)])
  call ol_merge_tensors(T1sum(5),[G1tensor(25)])
  call ol_merge_tensors(T1sum(6),[G1tensor(31)])
  call ol_merge_tensors(T1sum(7),[G1tensor(37)])
  call ol_merge_tensors(T1sum(8),[G1tensor(43)])
  call ol_merge_tensors(T1sum(9),[G1tensor(49)])
  call ol_merge_tensors(T1sum(10),[G1tensor(55)])
  call ol_merge_tensors(T1sum(11),[G1tensor(61)])
  call ol_merge_tensors(T1sum(12),[G1tensor(67)])
  call ol_merge_tensors(T1sum(13),[G1tensor(73)])
  call ol_merge_tensors(T1sum(14),[G1tensor(79)])
  call ol_merge_tensors(T1sum(15),[G1tensor(85)])
  call ol_merge_tensors(T1sum(16),[G1tensor(91)])
  call ol_merge_tensors(T1sum(17),[G1tensor(97)])
  call ol_merge_tensors(T1sum(18),[G1tensor(103)])
  call ol_merge_tensors(T1sum(19),[G1tensor(109)])
  call ol_merge_tensors(T1sum(20),[G1tensor(115)])
  Gcoeff(:)%j = (c(11)*M(3,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(21),h0tab(:,21),[16,3,8,4],[0,0,0,0],4,1,wf4(:,10))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,21),heltab2x48(:,:,21))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(1),n2h24(21))
  Gcoeff(:)%j = (c(10)*M(3,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(22),h0tab(:,22),[16,3,8,4],[nMT,nMT,nMT,nMT],4,1,wf4(:,10))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,22),heltab2x48(:,:,22))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMT,G1H24(2),n2h24(22))
  Gcoeff(:)%j = (c(11)*M(3,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(23),h0tab(:,23),[16,3,8,4],[0,0,0,0],4,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,23),heltab2x48(:,:,23))
  call Hloop_A_Q(ntryL,G0H24(1),16,0,G1H24(3),n2h24(23))
  Gcoeff(:)%j = (c(10)*M(3,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(24),h0tab(:,24),[16,3,8,4],[nMT,nMT,nMT,nMT],4,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,24),heltab2x48(:,:,24))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMT,G1H24(4),n2h24(24))
  Gcoeff(:)%j = (-(c(10)*M(3,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(25),h0tab(:,25),[16,3,8,4],[0,0,0,0],4,1,wf4(:,10))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,25),heltab2x48(:,:,25))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(5),n2h24(25))
  Gcoeff(:)%j = (-(c(9)*M(3,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(26),h0tab(:,26),[16,3,8,4],[nMB,nMB,nMB,nMB],4,1,wf4(:,10))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,26),heltab2x48(:,:,26))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMB,G1H24(6),n2h24(26))
  Gcoeff(:)%j = (-(c(10)*M(3,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(27),h0tab(:,27),[16,3,8,4],[0,0,0,0],4,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,27),heltab2x48(:,:,27))
  call Hloop_A_Q(ntryL,G0H24(1),16,0,G1H24(7),n2h24(27))
  Gcoeff(:)%j = (-(c(9)*M(3,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(28),h0tab(:,28),[16,3,8,4],[nMB,nMB,nMB,nMB],4,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,28),heltab2x48(:,:,28))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMB,G1H24(8),n2h24(28))
  Gcoeff(:)%j = (c(13)*M(3,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(29),h0tab(:,29),[16,3,8,4],[0,0,0,0],4,1,wf4(:,11))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,29),heltab2x48(:,:,29))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(9),n2h24(29))
  Gcoeff(:)%j = (c(12)*M(3,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(30),h0tab(:,30),[16,3,8,4],[nMT,nMT,nMT,nMT],4,1,wf4(:,11))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,30),heltab2x48(:,:,30))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMT,G1H24(10),n2h24(30))
  Gcoeff(:)%j = (c(13)*M(3,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(31),h0tab(:,31),[16,3,8,4],[0,0,0,0],4,1,wf4(:,11))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,31),heltab2x48(:,:,31))
  call Hloop_A_Q(ntryL,G0H24(1),16,0,G1H24(11),n2h24(31))
  Gcoeff(:)%j = (c(12)*M(3,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(32),h0tab(:,32),[16,3,8,4],[nMT,nMT,nMT,nMT],4,1,wf4(:,11))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,32),heltab2x48(:,:,32))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMT,G1H24(12),n2h24(32))
  Gcoeff(:)%j = (c(13)*M(3,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(33),h0tab(:,33),[16,3,8,4],[0,0,0,0],4,1,wf4(:,11))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,33),heltab2x48(:,:,33))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(13),n2h24(33))
  Gcoeff(:)%j = (c(12)*M(3,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(34),h0tab(:,34),[16,3,8,4],[nMB,nMB,nMB,nMB],4,1,wf4(:,11))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,34),heltab2x48(:,:,34))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMB,G1H24(14),n2h24(34))
  Gcoeff(:)%j = (c(13)*M(3,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(35),h0tab(:,35),[16,3,8,4],[0,0,0,0],4,1,wf4(:,11))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,35),heltab2x48(:,:,35))
  call Hloop_A_Q(ntryL,G0H24(1),16,0,G1H24(15),n2h24(35))
  Gcoeff(:)%j = (c(12)*M(3,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(36),h0tab(:,36),[16,3,8,4],[nMB,nMB,nMB,nMB],4,1,wf4(:,11))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,36),heltab2x48(:,:,36))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMB,G1H24(16),n2h24(36))
  Gcoeff(:)%j = (c(11)*M(3,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(37),h0tab(:,37),[16,3,4,8],[0,0,0,0],4,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,37),heltab2x48(:,:,37))
  call Hloop_A_Q(ntryL,G0H24(1),16,0,G1H24(17),n2h24(37))
  Gcoeff(:)%j = (c(10)*M(3,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(38),h0tab(:,38),[16,3,4,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,38),heltab2x48(:,:,38))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMT,G1H24(18),n2h24(38))
  Gcoeff(:)%j = (c(11)*M(3,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(39),h0tab(:,39),[16,3,4,8],[0,0,0,0],4,1,wf4(:,10))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,39),heltab2x48(:,:,39))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(19),n2h24(39))
  Gcoeff(:)%j = (c(10)*M(3,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(40),h0tab(:,40),[16,3,4,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,10))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,40),heltab2x48(:,:,40))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMT,G1H24(20),n2h24(40))
  Gcoeff(:)%j = (-(c(10)*M(3,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(41),h0tab(:,41),[16,3,4,8],[0,0,0,0],4,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,41),heltab2x48(:,:,41))
  call Hloop_A_Q(ntryL,G0H24(1),16,0,G1H24(21),n2h24(41))
  Gcoeff(:)%j = (-(c(9)*M(3,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(42),h0tab(:,42),[16,3,4,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,42),heltab2x48(:,:,42))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMB,G1H24(22),n2h24(42))
  Gcoeff(:)%j = (-(c(10)*M(3,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(43),h0tab(:,43),[16,3,4,8],[0,0,0,0],4,1,wf4(:,10))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,43),heltab2x48(:,:,43))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(23),n2h24(43))
  Gcoeff(:)%j = (-(c(9)*M(3,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(44),h0tab(:,44),[16,3,4,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,10))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,44),heltab2x48(:,:,44))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMB,G1H24(24),n2h24(44))
  Gcoeff(:)%j = (c(13)*M(3,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(45),h0tab(:,45),[16,3,4,8],[0,0,0,0],4,1,wf4(:,11))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,45),heltab2x48(:,:,45))
  call Hloop_A_Q(ntryL,G0H24(1),16,0,G1H24(25),n2h24(45))
  Gcoeff(:)%j = (c(12)*M(3,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(46),h0tab(:,46),[16,3,4,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,11))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,46),heltab2x48(:,:,46))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMT,G1H24(26),n2h24(46))
  Gcoeff(:)%j = (c(13)*M(3,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(47),h0tab(:,47),[16,3,4,8],[0,0,0,0],4,1,wf4(:,11))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,47),heltab2x48(:,:,47))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(27),n2h24(47))
  Gcoeff(:)%j = (c(12)*M(3,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(48),h0tab(:,48),[16,3,4,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,11))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,48),heltab2x48(:,:,48))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMT,G1H24(28),n2h24(48))
  Gcoeff(:)%j = (c(13)*M(3,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(49),h0tab(:,49),[16,3,4,8],[0,0,0,0],4,1,wf4(:,11))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,49),heltab2x48(:,:,49))
  call Hloop_A_Q(ntryL,G0H24(1),16,0,G1H24(29),n2h24(49))
  Gcoeff(:)%j = (c(12)*M(3,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(50),h0tab(:,50),[16,3,4,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,11))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,50),heltab2x48(:,:,50))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMB,G1H24(30),n2h24(50))
  Gcoeff(:)%j = (c(13)*M(3,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(51),h0tab(:,51),[16,3,4,8],[0,0,0,0],4,1,wf4(:,11))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,51),heltab2x48(:,:,51))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(31),n2h24(51))
  Gcoeff(:)%j = (c(12)*M(3,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(52),h0tab(:,52),[16,3,4,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,11))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,52),heltab2x48(:,:,52))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMB,G1H24(32),n2h24(52))
  Gcoeff(:)%j = (c(11)*M(3,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(53),h0tab(:,53),[16,4,3,8],[0,0,0,0],4,1,wf4(:,10))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,53),heltab2x48(:,:,53))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(33),n2h24(53))
  Gcoeff(:)%j = (c(10)*M(3,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(54),h0tab(:,54),[16,4,3,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,10))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,54),heltab2x48(:,:,54))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMT,G1H24(34),n2h24(54))
  Gcoeff(:)%j = (c(11)*M(3,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(55),h0tab(:,55),[16,4,3,8],[0,0,0,0],4,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,55),heltab2x48(:,:,55))
  call Hloop_A_Q(ntryL,G0H24(1),16,0,G1H24(35),n2h24(55))
  Gcoeff(:)%j = (c(10)*M(3,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(56),h0tab(:,56),[16,4,3,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,56),heltab2x48(:,:,56))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMT,G1H24(36),n2h24(56))
  Gcoeff(:)%j = (-(c(10)*M(3,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(57),h0tab(:,57),[16,4,3,8],[0,0,0,0],4,1,wf4(:,10))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,57),heltab2x48(:,:,57))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(37),n2h24(57))
  Gcoeff(:)%j = (-(c(9)*M(3,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(58),h0tab(:,58),[16,4,3,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,10))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,58),heltab2x48(:,:,58))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMB,G1H24(38),n2h24(58))
  Gcoeff(:)%j = (-(c(10)*M(3,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(59),h0tab(:,59),[16,4,3,8],[0,0,0,0],4,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,59),heltab2x48(:,:,59))
  call Hloop_A_Q(ntryL,G0H24(1),16,0,G1H24(39),n2h24(59))
  Gcoeff(:)%j = (-(c(9)*M(3,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(60),h0tab(:,60),[16,4,3,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,60),heltab2x48(:,:,60))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMB,G1H24(40),n2h24(60))
  Gcoeff(:)%j = (c(13)*M(3,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(61),h0tab(:,61),[16,4,3,8],[0,0,0,0],4,1,wf4(:,11))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,61),heltab2x48(:,:,61))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(41),n2h24(61))
  Gcoeff(:)%j = (c(12)*M(3,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(62),h0tab(:,62),[16,4,3,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,11))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,62),heltab2x48(:,:,62))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMT,G1H24(42),n2h24(62))
  Gcoeff(:)%j = (c(13)*M(3,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(63),h0tab(:,63),[16,4,3,8],[0,0,0,0],4,1,wf4(:,11))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,63),heltab2x48(:,:,63))
  call Hloop_A_Q(ntryL,G0H24(1),16,0,G1H24(43),n2h24(63))
  Gcoeff(:)%j = (c(12)*M(3,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(64),h0tab(:,64),[16,4,3,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,11))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,64),heltab2x48(:,:,64))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMT,G1H24(44),n2h24(64))
  Gcoeff(:)%j = (c(13)*M(3,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(65),h0tab(:,65),[16,4,3,8],[0,0,0,0],4,1,wf4(:,11))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,65),heltab2x48(:,:,65))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(45),n2h24(65))
  Gcoeff(:)%j = (c(12)*M(3,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(66),h0tab(:,66),[16,4,3,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,11))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,66),heltab2x48(:,:,66))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMB,G1H24(46),n2h24(66))
  Gcoeff(:)%j = (c(13)*M(3,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(67),h0tab(:,67),[16,4,3,8],[0,0,0,0],4,1,wf4(:,11))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,67),heltab2x48(:,:,67))
  call Hloop_A_Q(ntryL,G0H24(1),16,0,G1H24(47),n2h24(67))
  Gcoeff(:)%j = (c(12)*M(3,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(68),h0tab(:,68),[16,4,3,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,11))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,68),heltab2x48(:,:,68))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMB,G1H24(48),n2h24(68))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(69),h0tab(:,69),[16,5,2,8],[0,0,0,0],4,1,wf6(:,2))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,69),heltab2x48(:,:,69))
  call Hloop_A_Q(ntryL,G0H24(1),16,0,G1H24(49),n2h24(69))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(70),h0tab(:,70),[16,5,2,8],[0,nMZ,0,0],4,1,wf6(:,2))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,70),heltab2x48(:,:,70))
  call Hloop_A_Q(ntryL,G0H24(1),16,0,G1H24(50),n2h24(70))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(71),h0tab(:,71),[16,5,2,8],[0,nMW,0,0],4,1,wf6(:,2))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,71),heltab2x48(:,:,71))
  call Hloop_A_Q(ntryL,G0H24(1),16,0,G1H24(51),n2h24(71))
  Gcoeff(:)%j = (-(c(3)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(72),h0tab(:,72),[16,2,5,8],[0,0,0,0],4,1,wf6(:,2))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,72),heltab2x48(:,:,72))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(52),n2h24(72))
  Gcoeff(:)%j = (-(c(4)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(73),h0tab(:,73),[16,2,5,8],[0,nMZ,0,0],4,1,wf6(:,2))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,73),heltab2x48(:,:,73))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(53),n2h24(73))
  Gcoeff(:)%j = (-(c(8)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(74),h0tab(:,74),[16,2,5,8],[0,nMW,0,0],4,1,wf6(:,2))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,74),heltab2x48(:,:,74))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(54),n2h24(74))
  Gcoeff(:)%j = (-(c(3)*M(2,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(75),h0tab(:,75),[16,6,1,8],[0,0,0,0],4,1,wf6(:,4))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,75),heltab2x48(:,:,75))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(55),n2h24(75))
  Gcoeff(:)%j = (-(c(4)*M(2,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(76),h0tab(:,76),[16,6,1,8],[0,nMZ,0,0],4,1,wf6(:,4))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,76),heltab2x48(:,:,76))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(56),n2h24(76))
  Gcoeff(:)%j = (-(c(8)*M(2,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(77),h0tab(:,77),[16,6,1,8],[0,nMW,0,0],4,1,wf6(:,4))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,77),heltab2x48(:,:,77))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(57),n2h24(77))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(78),h0tab(:,78),[16,1,6,8],[0,0,0,0],4,1,wf6(:,4))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,78),heltab2x48(:,:,78))
  call Hloop_A_Q(ntryL,G0H24(1),16,0,G1H24(58),n2h24(78))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(79),h0tab(:,79),[16,1,6,8],[0,nMZ,0,0],4,1,wf6(:,4))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,79),heltab2x48(:,:,79))
  call Hloop_A_Q(ntryL,G0H24(1),16,0,G1H24(59),n2h24(79))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(80),h0tab(:,80),[16,1,6,8],[0,nMW,0,0],4,1,wf6(:,4))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,80),heltab2x48(:,:,80))
  call Hloop_A_Q(ntryL,G0H24(1),16,0,G1H24(60),n2h24(80))
  Gcoeff(:)%j = (-(c(6)*M(2,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(81),h0tab(:,81),[16,2,4,9],[0,nMW,nMW,0],4,1,wf4(:,7))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,81),heltab2x48(:,:,81))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(61),n2h24(81))
  Gcoeff(:)%j = (-(c(3)*M(2,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(82),h0tab(:,82),[16,4,2,9],[0,0,0,0],4,1,wf4(:,7))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,82),heltab2x48(:,:,82))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(62),n2h24(82))
  Gcoeff(:)%j = (-(c(4)*M(2,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(83),h0tab(:,83),[16,4,2,9],[0,0,nMZ,0],4,1,wf4(:,7))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,83),heltab2x48(:,:,83))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(63),n2h24(83))
  Gcoeff(:)%j = (-(c(8)*M(2,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(84),h0tab(:,84),[16,4,2,9],[0,0,nMW,0],4,1,wf4(:,7))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,84),heltab2x48(:,:,84))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(64),n2h24(84))
  Gcoeff(:)%j = (-(c(3)*M(2,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(85),h0tab(:,85),[16,2,9,4],[0,0,0,0],4,1,wf4(:,7))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,85),heltab2x48(:,:,85))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(65),n2h24(85))
  Gcoeff(:)%j = (-(c(4)*M(2,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(86),h0tab(:,86),[16,2,9,4],[0,nMZ,0,0],4,1,wf4(:,7))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,86),heltab2x48(:,:,86))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(66),n2h24(86))
  Gcoeff(:)%j = (-(c(8)*M(2,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(87),h0tab(:,87),[16,2,9,4],[0,nMW,0,0],4,1,wf4(:,7))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,87),heltab2x48(:,:,87))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(67),n2h24(87))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(88),h0tab(:,88),[16,1,4,10],[0,nMW,nMW,0],4,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,88),heltab2x48(:,:,88))
  call Hloop_A_Q(ntryL,G0H24(1),16,0,G1H24(68),n2h24(88))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(89),h0tab(:,89),[16,4,1,10],[0,0,0,0],4,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,89),heltab2x48(:,:,89))
  call Hloop_A_Q(ntryL,G0H24(1),16,0,G1H24(69),n2h24(89))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(90),h0tab(:,90),[16,4,1,10],[0,0,nMZ,0],4,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,90),heltab2x48(:,:,90))
  call Hloop_A_Q(ntryL,G0H24(1),16,0,G1H24(70),n2h24(90))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(91),h0tab(:,91),[16,4,1,10],[0,0,nMW,0],4,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,91),heltab2x48(:,:,91))
  call Hloop_A_Q(ntryL,G0H24(1),16,0,G1H24(71),n2h24(91))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(92),h0tab(:,92),[16,1,10,4],[0,0,0,0],4,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,92),heltab2x48(:,:,92))
  call Hloop_A_Q(ntryL,G0H24(1),16,0,G1H24(72),n2h24(92))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(93),h0tab(:,93),[16,1,10,4],[0,nMZ,0,0],4,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,93),heltab2x48(:,:,93))
  call Hloop_A_Q(ntryL,G0H24(1),16,0,G1H24(73),n2h24(93))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(94),h0tab(:,94),[16,1,10,4],[0,nMW,0,0],4,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,94),heltab2x48(:,:,94))
  call Hloop_A_Q(ntryL,G0H24(1),16,0,G1H24(74),n2h24(94))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(95),h0tab(:,95),[17,4,2,8],[nMW,nMW,0,0],4,1,wf4(:,9))
  call Hloop_AQ_W(ntryL,G0H48(1),wf4(:,9),G0H12(1),m3h4x12(:,1),heltab2x48(:,:,95))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(96),h0tab(:,96),[17,2,4,8],[0,0,0,0],4,1,wf4(:,9))
  call Hloop_AQ_V(ntryL,G0H48(1),wf4(:,9),G0H12(2),m3h4x12(:,2),heltab2x48(:,:,96))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(97),h0tab(:,97),[17,2,4,8],[nMZ,0,0,0],4,1,wf4(:,9))
  call Hloop_AQ_Z(ntryL,G0H48(1),wf4(:,9),G0H12(3),ngZu,m3h4x12(:,3),heltab2x48(:,:,97))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(98),h0tab(:,98),[17,2,4,8],[nMW,0,0,0],4,1,wf4(:,9))
  call Hloop_AQ_W(ntryL,G0H48(1),wf4(:,9),G0H12(4),m3h4x12(:,4),heltab2x48(:,:,98))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(99),h0tab(:,99),[17,2,8,4],[0,0,0,0],4,1,wf4(:,9))
  call Hloop_AQ_V(ntryL,G0H48(1),wf4(:,9),G0H12(5),m3h4x12(:,5),heltab2x48(:,:,99))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(100),h0tab(:,100),[17,2,8,4],[nMZ,0,0,0],4,1,wf4(:,9))
  call Hloop_AQ_Z(ntryL,G0H48(1),wf4(:,9),G0H12(6),ngZu,m3h4x12(:,6),heltab2x48(:,:,100))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(101),h0tab(:,101),[17,2,8,4],[nMW,0,0,0],4,1,wf4(:,9))
  call Hloop_AQ_W(ntryL,G0H48(1),wf4(:,9),G0H12(7),m3h4x12(:,7),heltab2x48(:,:,101))
  Gcoeff(:)%j = (-(c(6)*M(2,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(102),h0tab(:,102),[18,4,1,8],[nMW,nMW,0,0],4,1,wf4(:,4))
  call Hloop_QA_W(ntryL,G0H48(1),wf4(:,4),G0H12(8),m3h4x12(:,8),heltab2x48(:,:,102))
  Gcoeff(:)%j = (-(c(3)*M(2,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(103),h0tab(:,103),[18,1,4,8],[0,0,0,0],4,1,wf4(:,4))
  call Hloop_QA_V(ntryL,G0H48(1),wf4(:,4),G0H12(9),m3h4x12(:,9),heltab2x48(:,:,103))
  Gcoeff(:)%j = (-(c(4)*M(2,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(104),h0tab(:,104),[18,1,4,8],[nMZ,0,0,0],4,1,wf4(:,4))
  call Hloop_QA_Z(ntryL,G0H48(1),wf4(:,4),G0H12(10),ngZu,m3h4x12(:,10),heltab2x48(:,:,104))
  Gcoeff(:)%j = (-(c(8)*M(2,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(105),h0tab(:,105),[18,1,4,8],[nMW,0,0,0],4,1,wf4(:,4))
  call Hloop_QA_W(ntryL,G0H48(1),wf4(:,4),G0H12(11),m3h4x12(:,11),heltab2x48(:,:,105))
  Gcoeff(:)%j = (-(c(3)*M(2,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(106),h0tab(:,106),[18,1,8,4],[0,0,0,0],4,1,wf4(:,4))
  call Hloop_QA_V(ntryL,G0H48(1),wf4(:,4),G0H12(12),m3h4x12(:,12),heltab2x48(:,:,106))
  Gcoeff(:)%j = (-(c(4)*M(2,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(107),h0tab(:,107),[18,1,8,4],[nMZ,0,0,0],4,1,wf4(:,4))
  call Hloop_QA_Z(ntryL,G0H48(1),wf4(:,4),G0H12(13),ngZu,m3h4x12(:,13),heltab2x48(:,:,107))
  Gcoeff(:)%j = (-(c(8)*M(2,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(108),h0tab(:,108),[18,1,8,4],[nMW,0,0,0],4,1,wf4(:,4))
  call Hloop_QA_W(ntryL,G0H48(1),wf4(:,4),G0H12(14),m3h4x12(:,14),heltab2x48(:,:,108))
  Gcoeff(:)%j = (c(1)*(M(1,:)%j-M(2,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(109),h0tab(:,109),[24,2,1,4],[0,0,0,0],4,1,wf4(:,5))
  call Hloop_QV_A(ntryL,G0H48(1),wf4(:,5),G0H12(15),m3h4x12(:,15),heltab2x48(:,:,109))
  call Hloop_Q_A(ntryL,G0H12(15),24,0,G1H12(1),n2h12(1))
  Gcoeff(:)%j = (c(2)*(M(1,:)%j-M(2,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(110),h0tab(:,110),[24,2,1,4],[0,nMZ,0,0],4,1,wf4(:,5))
  call Hloop_QV_A(ntryL,G0H48(1),wf4(:,5),G0H12(15),m3h4x12(:,16),heltab2x48(:,:,110))
  call Hloop_Q_A(ntryL,G0H12(15),24,0,G1H12(2),n2h12(2))
  Gcoeff(:)%j = (c(7)*(M(1,:)%j-M(2,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(111),h0tab(:,111),[24,2,1,4],[0,nMW,0,0],4,1,wf4(:,5))
  call Hloop_QV_A(ntryL,G0H48(1),wf4(:,5),G0H12(15),m3h4x12(:,17),heltab2x48(:,:,111))
  call Hloop_Q_A(ntryL,G0H12(15),24,0,G1H12(3),n2h12(3))
  Gcoeff(:)%j = (c(1)*(M(1,:)%j-M(2,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(112),h0tab(:,112),[24,1,2,4],[0,0,0,0],4,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H48(1),wf4(:,5),G0H12(15),m3h4x12(:,18),heltab2x48(:,:,112))
  call Hloop_A_Q(ntryL,G0H12(15),24,0,G1H12(4),n2h12(4))
  Gcoeff(:)%j = (c(2)*(M(1,:)%j-M(2,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(113),h0tab(:,113),[24,1,2,4],[0,nMZ,0,0],4,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H48(1),wf4(:,5),G0H12(15),m3h4x12(:,19),heltab2x48(:,:,113))
  call Hloop_A_Q(ntryL,G0H12(15),24,0,G1H12(5),n2h12(5))
  Gcoeff(:)%j = (c(7)*(M(1,:)%j-M(2,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(114),h0tab(:,114),[24,1,2,4],[0,nMW,0,0],4,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H48(1),wf4(:,5),G0H12(15),m3h4x12(:,20),heltab2x48(:,:,114))
  call Hloop_A_Q(ntryL,G0H12(15),24,0,G1H12(6),n2h12(6))
  Gcoeff(:)%j = (c(5)*(M(1,:)%j-M(2,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(115),h0tab(:,115),[24,1,4,2],[0,nMW,nMW,0],4,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H48(1),wf4(:,5),G0H12(15),m3h4x12(:,21),heltab2x48(:,:,115))
  call Hloop_A_Q(ntryL,G0H12(15),24,0,G1H12(7),n2h12(7))
  call Hloop_QV_A(ntryL,G1H24(1),wf4(:,10),G1H6(1),m3h4x6(:,1),heltab2x24(:,:,21))
  call Hloop_Q_A(ntryL,G1H6(1),19,0,G2H6(1),n2h6(25))
  call Hloop_QV_A(ntryL,G1H24(2),wf4(:,10),G1H6(2),m3h4x6(:,2),heltab2x24(:,:,22))
  call Hloop_Q_A(ntryL,G1H6(2),19,nMT,G2H6(2),n2h6(26))
  call Hloop_AV_Q(ntryL,G1H24(3),wf4(:,10),G1H6(5),m3h4x6(:,3),heltab2x24(:,:,23))
  call Hloop_A_Q(ntryL,G1H6(5),19,0,G2H6(3),n2h6(27))
  call Hloop_AV_Q(ntryL,G1H24(4),wf4(:,10),G1H6(6),m3h4x6(:,4),heltab2x24(:,:,24))
  call Hloop_A_Q(ntryL,G1H6(6),19,nMT,G2H6(4),n2h6(28))
  call Hloop_QV_A(ntryL,G1H24(5),wf4(:,10),G1H6(7),m3h4x6(:,5),heltab2x24(:,:,25))
  call Hloop_Q_A(ntryL,G1H6(7),19,0,G2H6(5),n2h6(29))
  call Hloop_QV_A(ntryL,G1H24(6),wf4(:,10),G1H6(8),m3h4x6(:,6),heltab2x24(:,:,26))
  call Hloop_Q_A(ntryL,G1H6(8),19,nMB,G2H6(6),n2h6(30))
  call Hloop_AV_Q(ntryL,G1H24(7),wf4(:,10),G1H6(11),m3h4x6(:,7),heltab2x24(:,:,27))
  call Hloop_A_Q(ntryL,G1H6(11),19,0,G2H6(7),n2h6(31))
  call Hloop_AV_Q(ntryL,G1H24(8),wf4(:,10),G1H6(12),m3h4x6(:,8),heltab2x24(:,:,28))
  call Hloop_A_Q(ntryL,G1H6(12),19,nMB,G2H6(8),n2h6(32))
  call Hloop_QZ_A(ntryL,G1H24(9),wf4(:,11),G1H6(13),ngZu,m3h4x6(:,9),heltab2x24(:,:,29))
  call Hloop_Q_A(ntryL,G1H6(13),19,0,G2H6(9),n2h6(33))
  call Hloop_QZ_A(ntryL,G1H24(10),wf4(:,11),G1H6(14),ngZu,m3h4x6(:,10),heltab2x24(:,:,30))
  call Hloop_Q_A(ntryL,G1H6(14),19,nMT,G2H6(10),n2h6(34))
  call Hloop_AZ_Q(ntryL,G1H24(11),wf4(:,11),G1H6(17),ngZu,m3h4x6(:,11),heltab2x24(:,:,31))
  call Hloop_A_Q(ntryL,G1H6(17),19,0,G2H6(11),n2h6(35))
  call Hloop_AZ_Q(ntryL,G1H24(12),wf4(:,11),G1H6(18),ngZu,m3h4x6(:,12),heltab2x24(:,:,32))
  call Hloop_A_Q(ntryL,G1H6(18),19,nMT,G2H6(12),n2h6(36))
  call Hloop_QZ_A(ntryL,G1H24(13),wf4(:,11),G1H6(19),ngZd,m3h4x6(:,13),heltab2x24(:,:,33))
  call Hloop_Q_A(ntryL,G1H6(19),19,0,G2H6(13),n2h6(37))
  call Hloop_QZ_A(ntryL,G1H24(14),wf4(:,11),G1H6(20),ngZd,m3h4x6(:,14),heltab2x24(:,:,34))
  call Hloop_Q_A(ntryL,G1H6(20),19,nMB,G2H6(14),n2h6(38))
  call Hloop_AZ_Q(ntryL,G1H24(15),wf4(:,11),G1H6(23),ngZd,m3h4x6(:,15),heltab2x24(:,:,35))
  call Hloop_A_Q(ntryL,G1H6(23),19,0,G2H6(15),n2h6(39))
  call Hloop_AZ_Q(ntryL,G1H24(16),wf4(:,11),G1H6(24),ngZd,m3h4x6(:,16),heltab2x24(:,:,36))
  call Hloop_A_Q(ntryL,G1H6(24),19,nMB,G2H6(16),n2h6(40))
  call Hloop_AV_Q(ntryL,G1H24(17),wf4(:,10),G1H6(25),m3h4x6(:,17),heltab2x24(:,:,37))
  call Hloop_A_Q(ntryL,G1H6(25),19,0,G2H6(17),n2h6(41))
  call Hloop_AV_Q(ntryL,G1H24(18),wf4(:,10),G1H6(26),m3h4x6(:,18),heltab2x24(:,:,38))
  call Hloop_A_Q(ntryL,G1H6(26),19,nMT,G2H6(18),n2h6(42))
  call Hloop_QV_A(ntryL,G1H24(19),wf4(:,10),G1H6(29),m3h4x6(:,19),heltab2x24(:,:,39))
  call Hloop_Q_A(ntryL,G1H6(29),19,0,G2H6(19),n2h6(43))
  call Hloop_QV_A(ntryL,G1H24(20),wf4(:,10),G1H6(30),m3h4x6(:,20),heltab2x24(:,:,40))
  call Hloop_Q_A(ntryL,G1H6(30),19,nMT,G2H6(20),n2h6(44))
  call Hloop_AV_Q(ntryL,G1H24(21),wf4(:,10),G1H6(31),m3h4x6(:,21),heltab2x24(:,:,41))
  call Hloop_A_Q(ntryL,G1H6(31),19,0,G2H6(21),n2h6(45))
  call Hloop_AV_Q(ntryL,G1H24(22),wf4(:,10),G1H6(32),m3h4x6(:,22),heltab2x24(:,:,42))
  call Hloop_A_Q(ntryL,G1H6(32),19,nMB,G2H6(22),n2h6(46))
  call Hloop_QV_A(ntryL,G1H24(23),wf4(:,10),G1H6(35),m3h4x6(:,23),heltab2x24(:,:,43))
  call Hloop_Q_A(ntryL,G1H6(35),19,0,G2H6(23),n2h6(47))
  call Hloop_QV_A(ntryL,G1H24(24),wf4(:,10),G1H6(36),m3h4x6(:,24),heltab2x24(:,:,44))
  call Hloop_Q_A(ntryL,G1H6(36),19,nMB,G2H6(24),n2h6(48))
  call Hloop_AZ_Q(ntryL,G1H24(25),wf4(:,11),G1H6(37),ngZu,m3h4x6(:,25),heltab2x24(:,:,45))
  call Hloop_A_Q(ntryL,G1H6(37),19,0,G2H6(25),n2h6(49))
  call Hloop_AZ_Q(ntryL,G1H24(26),wf4(:,11),G1H6(38),ngZu,m3h4x6(:,26),heltab2x24(:,:,46))
  call Hloop_A_Q(ntryL,G1H6(38),19,nMT,G2H6(26),n2h6(50))
  call Hloop_QZ_A(ntryL,G1H24(27),wf4(:,11),G1H6(41),ngZu,m3h4x6(:,27),heltab2x24(:,:,47))
  call Hloop_Q_A(ntryL,G1H6(41),19,0,G2H6(27),n2h6(51))
  call Hloop_QZ_A(ntryL,G1H24(28),wf4(:,11),G1H6(42),ngZu,m3h4x6(:,28),heltab2x24(:,:,48))
  call Hloop_Q_A(ntryL,G1H6(42),19,nMT,G2H6(28),n2h6(52))
  call Hloop_AZ_Q(ntryL,G1H24(29),wf4(:,11),G1H6(43),ngZd,m3h4x6(:,29),heltab2x24(:,:,49))
  call Hloop_A_Q(ntryL,G1H6(43),19,0,G2H6(29),n2h6(53))
  call Hloop_AZ_Q(ntryL,G1H24(30),wf4(:,11),G1H6(44),ngZd,m3h4x6(:,30),heltab2x24(:,:,50))
  call Hloop_A_Q(ntryL,G1H6(44),19,nMB,G2H6(30),n2h6(54))
  call Hloop_QZ_A(ntryL,G1H24(31),wf4(:,11),G1H6(47),ngZd,m3h4x6(:,31),heltab2x24(:,:,51))
  call Hloop_Q_A(ntryL,G1H6(47),19,0,G2H6(31),n2h6(55))
  call Hloop_QZ_A(ntryL,G1H24(32),wf4(:,11),G1H6(48),ngZd,m3h4x6(:,32),heltab2x24(:,:,52))
  call Hloop_Q_A(ntryL,G1H6(48),19,nMB,G2H6(32),n2h6(56))
  call Hloop_QZ_A(ntryL,G1H24(33),ex3(:),G1H8(1),ngZu,m3h3x8(:,7),heltab2x24(:,:,53))
  call Hloop_Q_A(ntryL,G1H8(1),20,0,G2H8(1),n2h8(7))
  call Hloop_QZ_A(ntryL,G1H24(34),ex3(:),G1H8(1),ngZu,m3h3x8(:,8),heltab2x24(:,:,54))
  call Hloop_Q_A(ntryL,G1H8(1),20,nMT,G2H8(2),n2h8(8))
  call Hloop_AZ_Q(ntryL,G1H24(35),ex3(:),G1H8(1),ngZu,m3h3x8(:,9),heltab2x24(:,:,55))
  call Hloop_A_Q(ntryL,G1H8(1),20,0,G2H8(3),n2h8(9))
  call Hloop_AZ_Q(ntryL,G1H24(36),ex3(:),G1H8(1),ngZu,m3h3x8(:,10),heltab2x24(:,:,56))
  call Hloop_A_Q(ntryL,G1H8(1),20,nMT,G2H8(4),n2h8(10))
  call Hloop_QZ_A(ntryL,G1H24(37),ex3(:),G1H8(1),ngZd,m3h3x8(:,11),heltab2x24(:,:,57))
  call Hloop_Q_A(ntryL,G1H8(1),20,0,G2H8(5),n2h8(11))
  call Hloop_QZ_A(ntryL,G1H24(38),ex3(:),G1H8(1),ngZd,m3h3x8(:,12),heltab2x24(:,:,58))
  call Hloop_Q_A(ntryL,G1H8(1),20,nMB,G2H8(6),n2h8(12))
  call Hloop_AZ_Q(ntryL,G1H24(39),ex3(:),G1H8(1),ngZd,m3h3x8(:,13),heltab2x24(:,:,59))
  call Hloop_A_Q(ntryL,G1H8(1),20,0,G2H8(7),n2h8(13))
  call Hloop_AZ_Q(ntryL,G1H24(40),ex3(:),G1H8(1),ngZd,m3h3x8(:,14),heltab2x24(:,:,60))
  call Hloop_A_Q(ntryL,G1H8(1),20,nMB,G2H8(8),n2h8(14))
  call Hloop_QZ_A(ntryL,G1H24(41),ex3(:),G1H8(1),ngZu,m3h3x8(:,15),heltab2x24(:,:,61))
  call Hloop_Q_A(ntryL,G1H8(1),20,0,G2H8(9),n2h8(15))
  call Hloop_QZ_A(ntryL,G1H24(42),ex3(:),G1H8(1),ngZu,m3h3x8(:,16),heltab2x24(:,:,62))
  call Hloop_Q_A(ntryL,G1H8(1),20,nMT,G2H8(10),n2h8(16))
  call Hloop_AZ_Q(ntryL,G1H24(43),ex3(:),G1H8(1),ngZu,m3h3x8(:,17),heltab2x24(:,:,63))
  call Hloop_A_Q(ntryL,G1H8(1),20,0,G2H8(11),n2h8(17))
  call Hloop_AZ_Q(ntryL,G1H24(44),ex3(:),G1H8(1),ngZu,m3h3x8(:,18),heltab2x24(:,:,64))
  call Hloop_A_Q(ntryL,G1H8(1),20,nMT,G2H8(12),n2h8(18))
  call Hloop_QZ_A(ntryL,G1H24(45),ex3(:),G1H8(1),ngZd,m3h3x8(:,19),heltab2x24(:,:,65))
  call Hloop_Q_A(ntryL,G1H8(1),20,0,G2H8(13),n2h8(19))
  call Hloop_QZ_A(ntryL,G1H24(46),ex3(:),G1H8(1),ngZd,m3h3x8(:,20),heltab2x24(:,:,66))
  call Hloop_Q_A(ntryL,G1H8(1),20,nMB,G2H8(14),n2h8(20))
  call Hloop_AZ_Q(ntryL,G1H24(47),ex3(:),G1H8(1),ngZd,m3h3x8(:,21),heltab2x24(:,:,67))
  call Hloop_A_Q(ntryL,G1H8(1),20,0,G2H8(15),n2h8(21))
  call Hloop_AZ_Q(ntryL,G1H24(48),ex3(:),G1H8(1),ngZd,m3h3x8(:,22),heltab2x24(:,:,68))
  call Hloop_A_Q(ntryL,G1H8(1),20,nMB,G2H8(16),n2h8(22))
  call Hloop_AQ_V(ntryL,G1H24(49),wf6(:,2),G1H4(1),m3h6x4(:,1),heltab2x24(:,:,69))
  call Hloop_AQ_Z(ntryL,G1H24(50),wf6(:,2),G1H4(2),ngZu,m3h6x4(:,2),heltab2x24(:,:,70))
  call Hloop_AQ_W(ntryL,G1H24(51),wf6(:,2),G1H4(5),m3h6x4(:,3),heltab2x24(:,:,71))
  call Hloop_QA_V(ntryL,G1H24(52),ex2(:),G1H12(8),m3h2x12(:,15),heltab2x24(:,:,72))
  call Hloop_QA_Z(ntryL,G1H24(53),ex2(:),G1H12(9),ngZu,m3h2x12(:,16),heltab2x24(:,:,73))
  call Hloop_QA_W(ntryL,G1H24(54),ex2(:),G1H12(10),m3h2x12(:,17),heltab2x24(:,:,74))
  call Hloop_QA_V(ntryL,G1H24(55),wf6(:,4),G1H4(6),m3h6x4(:,4),heltab2x24(:,:,75))
  call Hloop_QA_Z(ntryL,G1H24(56),wf6(:,4),G1H4(7),ngZu,m3h6x4(:,5),heltab2x24(:,:,76))
  call Hloop_QA_W(ntryL,G1H24(57),wf6(:,4),G1H4(8),m3h6x4(:,6),heltab2x24(:,:,77))
  call Hloop_AQ_V(ntryL,G1H24(58),ex1(:),G1H12(11),m3h2x12(:,18),heltab2x24(:,:,78))
  call Hloop_AQ_Z(ntryL,G1H24(59),ex1(:),G1H12(12),ngZu,m3h2x12(:,19),heltab2x24(:,:,79))
  call Hloop_AQ_W(ntryL,G1H24(60),ex1(:),G1H12(13),m3h2x12(:,20),heltab2x24(:,:,80))
  call Hloop_QA_W(ntryL,G1H24(61),ex2(:),G1H12(14),m3h2x12(:,21),heltab2x24(:,:,81))
  call Hloop_QZ_A(ntryL,G1H24(62),ex3(:),G1H8(1),ngZu,m3h3x8(:,23),heltab2x24(:,:,82))
  call Hloop_Q_A(ntryL,G1H8(1),20,0,G2H8(17),n2h8(23))
  call Hloop_QZ_A(ntryL,G1H24(63),ex3(:),G1H8(1),ngZu,m3h3x8(:,24),heltab2x24(:,:,83))
  call Hloop_Q_A(ntryL,G1H8(1),20,0,G2H8(18),n2h8(24))
  call Hloop_QZ_A(ntryL,G1H24(64),ex3(:),G1H8(1),ngZd,m3h3x8(:,25),heltab2x24(:,:,84))
  call Hloop_Q_A(ntryL,G1H8(1),20,0,G2H8(19),n2h8(25))
  call Hloop_QA_V(ntryL,G1H24(65),ex2(:),G1H12(15),m3h2x12(:,22),heltab2x24(:,:,85))
  call Hloop_QA_Z(ntryL,G1H24(66),ex2(:),G1H12(16),ngZu,m3h2x12(:,23),heltab2x24(:,:,86))
  call Hloop_QA_W(ntryL,G1H24(67),ex2(:),G1H12(17),m3h2x12(:,24),heltab2x24(:,:,87))
  call Hloop_AQ_W(ntryL,G1H24(68),ex1(:),G1H12(18),m3h2x12(:,25),heltab2x24(:,:,88))
  call Hloop_AZ_Q(ntryL,G1H24(69),ex3(:),G1H8(1),ngZu,m3h3x8(:,26),heltab2x24(:,:,89))
  call Hloop_A_Q(ntryL,G1H8(1),20,0,G2H8(20),n2h8(26))
  call Hloop_AZ_Q(ntryL,G1H24(70),ex3(:),G1H8(1),ngZu,m3h3x8(:,27),heltab2x24(:,:,90))
  call Hloop_A_Q(ntryL,G1H8(1),20,0,G2H8(21),n2h8(27))
  call Hloop_AZ_Q(ntryL,G1H24(71),ex3(:),G1H8(1),ngZd,m3h3x8(:,28),heltab2x24(:,:,91))
  call Hloop_A_Q(ntryL,G1H8(1),20,0,G2H8(22),n2h8(28))
  call Hloop_AQ_V(ntryL,G1H24(72),ex1(:),G1H12(19),m3h2x12(:,26),heltab2x24(:,:,92))
  call Hloop_AQ_Z(ntryL,G1H24(73),ex1(:),G1H12(20),ngZu,m3h2x12(:,27),heltab2x24(:,:,93))
  call Hloop_AQ_W(ntryL,G1H24(74),ex1(:),G1H12(21),m3h2x12(:,28),heltab2x24(:,:,94))
  call Hloop_UW_V(ntryL,G0H12(1),17,ex3(:),4,G1H4(11),m3h3x4(:,3),heltab2x12(:,:,15))
  call Hloop_VA_Q(ntryL,G0H12(2),ex2(:),G0H6(1),m3h2x6(:,13),heltab2x12(:,:,16))
  call Hloop_A_Q(ntryL,G0H6(1),19,0,G1H6(49),n2h6(57))
  call Hloop_ZA_Q(ntryL,G0H12(3),ex2(:),G0H6(1),ngZu,m3h2x6(:,14),heltab2x12(:,:,17))
  call Hloop_A_Q(ntryL,G0H6(1),19,0,G1H6(50),n2h6(58))
  call Hloop_WA_Q(ntryL,G0H12(4),ex2(:),G0H6(1),m3h2x6(:,15),heltab2x12(:,:,18))
  call Hloop_A_Q(ntryL,G0H6(1),19,0,G1H6(53),n2h6(59))
  call Hloop_VA_Q(ntryL,G0H12(5),ex2(:),G0H6(1),m3h2x6(:,16),heltab2x12(:,:,19))
  call Hloop_A_Q(ntryL,G0H6(1),19,0,G1H6(54),n2h6(60))
  call Hloop_ZA_Q(ntryL,G0H12(6),ex2(:),G0H6(1),ngZu,m3h2x6(:,17),heltab2x12(:,:,20))
  call Hloop_A_Q(ntryL,G0H6(1),19,0,G1H6(55),n2h6(61))
  call Hloop_WA_Q(ntryL,G0H12(7),ex2(:),G0H6(1),m3h2x6(:,18),heltab2x12(:,:,21))
  call Hloop_A_Q(ntryL,G0H6(1),19,0,G1H6(56),n2h6(62))
  call Hloop_UV_W(ntryL,G0H12(8),18,ex3(:),4,G1H4(12),m3h3x4(:,4),heltab2x12(:,:,22))
  call Hloop_VQ_A(ntryL,G0H12(9),ex1(:),G0H6(1),m3h2x6(:,19),heltab2x12(:,:,23))
  call Hloop_Q_A(ntryL,G0H6(1),19,0,G1H6(59),n2h6(63))
  call Hloop_ZQ_A(ntryL,G0H12(10),ex1(:),G0H6(1),ngZu,m3h2x6(:,20),heltab2x12(:,:,24))
  call Hloop_Q_A(ntryL,G0H6(1),19,0,G1H6(60),n2h6(64))
  call Hloop_WQ_A(ntryL,G0H12(11),ex1(:),G0H6(1),m3h2x6(:,21),heltab2x12(:,:,25))
  call Hloop_Q_A(ntryL,G0H6(1),19,0,G1H6(61),n2h6(65))
  call Hloop_VQ_A(ntryL,G0H12(12),ex1(:),G0H6(1),m3h2x6(:,22),heltab2x12(:,:,26))
  call Hloop_Q_A(ntryL,G0H6(1),19,0,G1H6(62),n2h6(66))
  call Hloop_ZQ_A(ntryL,G0H12(13),ex1(:),G0H6(1),ngZu,m3h2x6(:,23),heltab2x12(:,:,27))
  call Hloop_Q_A(ntryL,G0H6(1),19,0,G1H6(65),n2h6(67))
  call Hloop_WQ_A(ntryL,G0H12(14),ex1(:),G0H6(1),m3h2x6(:,24),heltab2x12(:,:,28))
  call Hloop_Q_A(ntryL,G0H6(1),19,0,G1H6(66),n2h6(68))
  call Hloop_QA_V(ntryL,G1H12(1),ex2(:),G1H6(67),m3h2x6(:,25),heltab2x12(:,:,29))
  call Hloop_QA_Z(ntryL,G1H12(2),ex2(:),G1H6(68),ngZu,m3h2x6(:,26),heltab2x12(:,:,30))
  call Hloop_QA_W(ntryL,G1H12(3),ex2(:),G1H6(71),m3h2x6(:,27),heltab2x12(:,:,31))
  call Hloop_AQ_V(ntryL,G1H12(4),ex1(:),G1H6(72),m3h2x6(:,28),heltab2x12(:,:,32))
  call Hloop_AQ_Z(ntryL,G1H12(5),ex1(:),G1H6(1),ngZu,m3h2x6(:,29),heltab2x12(:,:,33))
  call Hloop_AQ_W(ntryL,G1H12(6),ex1(:),G1H6(2),m3h2x6(:,30),heltab2x12(:,:,34))
  call Hloop_AQ_W(ntryL,G1H12(7),ex1(:),G1H6(5),m3h2x6(:,31),heltab2x12(:,:,35))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1),[G1H4(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(2),[G1H4(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(5),[G1H4(46),G1H4(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(59),[G1H6(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(27),[G2H6(19),G1H6(10),G1H6(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(60),[G1H6(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(61),[G1H6(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(31),[G2H6(23),G1H6(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(6),[G1H4(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(7),[G1H4(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(8),[G1H4(40),G1H4(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(62),[G1H6(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(9),[G2H6(1),G1H6(28),G1H6(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(65),[G1H6(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(66),[G1H6(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(13),[G2H6(5),G1H6(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(49),[G1H6(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(25),[G2H6(17),G1H6(46),G1H6(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(50),[G1H6(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(53),[G1H6(51)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(29),[G2H6(21),G1H6(52)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(54),[G1H6(57)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(11),[G2H6(3),G1H6(64),G1H6(58)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(55),[G1H6(63)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(56),[G1H6(69)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(15),[G2H6(7),G1H6(70)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(12),[G1H4(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(11),[G1H4(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(10),[G2H6(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(12),[G2H6(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(14),[G2H6(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(16),[G2H6(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(26),[G2H6(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(28),[G2H6(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(30),[G2H6(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(32),[G2H6(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(5),[G2H8(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(7),[G2H8(3)])
  call Hloop_VA_Q(ntryL,G1H4(3),ex2(:),G1H2(6),m3h2x2(:,33),heltab2x4(:,:,33))
  call Hloop_A_Q(ntryL,G1H2(6),23,0,G2H2(1),n2h2(43))
  call Hloop_VA_Q(ntryL,G1H4(1),ex2(:),G1H2(17),m3h2x2(:,34),heltab2x4(:,:,34))
  call Hloop_A_Q(ntryL,G1H2(17),23,0,G2H2(4),n2h2(44))
  call Hloop_ZA_Q(ntryL,G1H4(9),ex2(:),G1H2(28),ngZu,m3h2x2(:,35),heltab2x4(:,:,35))
  call Hloop_A_Q(ntryL,G1H2(28),23,0,G2H2(5),n2h2(45))
  call Hloop_ZA_Q(ntryL,G1H4(2),ex2(:),G1H2(39),ngZu,m3h2x2(:,36),heltab2x4(:,:,36))
  call Hloop_A_Q(ntryL,G1H2(39),23,0,G2H2(8),n2h2(46))
  call Hloop_WA_Q(ntryL,G1H4(15),ex2(:),G1H2(50),m3h2x2(:,37),heltab2x4(:,:,37))
  call Hloop_A_Q(ntryL,G1H2(50),23,0,G2H2(9),n2h2(47))
  call Hloop_WA_Q(ntryL,G1H4(5),ex2(:),G1H2(61),m3h2x2(:,38),heltab2x4(:,:,38))
  call Hloop_A_Q(ntryL,G1H2(61),23,0,G2H2(12),n2h2(48))
  call Hloop_QZ_A(ntryL,G1H6(59),ex3(:),G1H2(72),ngZu,m3h3x2(:,25),heltab2x6(:,:,49))
  call Hloop_Q_A(ntryL,G1H2(72),23,0,G2H2(13),n2h2(49))
  call Hotf_4pt_reduction(G2H6(27),RedSet_4(12),mass4set(:,1),  & 
G1H6(6),G1H6(7),G1H6(8),G1H6(11),G1H6(12),G0H6(1),6)
  call HG1shiftOLR(G1H6(7),8,6)
  call Hloop_QZ_A(ntryL,G1H6(60),ex3(:),G1H2(83),ngZu,m3h3x2(:,26),heltab2x6(:,:,50))
  call Hloop_Q_A(ntryL,G1H2(83),23,0,G2H2(15),n2h2(50))
  call Hloop_QZ_A(ntryL,G1H6(61),ex3(:),G1H2(94),ngZd,m3h3x2(:,27),heltab2x6(:,:,51))
  call Hloop_Q_A(ntryL,G1H2(94),23,0,G2H2(16),n2h2(51))
  call Hotf_4pt_reduction(G2H6(31),RedSet_4(12),mass4set(:,1),  & 
G1H6(13),G1H6(14),G1H6(17),G1H6(18),G1H6(19),G0H6(2),6)
  call HG1shiftOLR(G1H6(14),8,6)
  call Hloop_VQ_A(ntryL,G1H4(21),ex1(:),G1H2(105),m3h2x2(:,39),heltab2x4(:,:,39))
  call Hloop_Q_A(ntryL,G1H2(105),23,0,G2H2(18),n2h2(52))
  call Hloop_VQ_A(ntryL,G1H4(6),ex1(:),G1H2(116),m3h2x2(:,40),heltab2x4(:,:,40))
  call Hloop_Q_A(ntryL,G1H2(116),23,0,G2H2(19),n2h2(53))
  call Hloop_ZQ_A(ntryL,G1H4(27),ex1(:),G1H2(127),ngZu,m3h2x2(:,41),heltab2x4(:,:,41))
  call Hloop_Q_A(ntryL,G1H2(127),23,0,G2H2(21),n2h2(54))
  call Hloop_ZQ_A(ntryL,G1H4(7),ex1(:),G1H2(138),ngZu,m3h2x2(:,42),heltab2x4(:,:,42))
  call Hloop_Q_A(ntryL,G1H2(138),23,0,G2H2(22),n2h2(55))
  call Hloop_WQ_A(ntryL,G1H4(33),ex1(:),G1H2(149),m3h2x2(:,43),heltab2x4(:,:,43))
  call Hloop_Q_A(ntryL,G1H2(149),23,0,G2H2(25),n2h2(56))
  call Hloop_WQ_A(ntryL,G1H4(8),ex1(:),G1H2(1),m3h2x2(:,44),heltab2x4(:,:,44))
  call Hloop_Q_A(ntryL,G1H2(1),23,0,G2H2(26),n2h2(57))
  call Hloop_QV_A(ntryL,G1H6(62),ex4(:),G1H3(6),m3h2x3(:,25),heltab2x6(:,:,52))
  call Hloop_Q_A(ntryL,G1H3(6),27,0,G2H3(4),n2h3(19))
  call Hotf_4pt_reduction(G2H6(9),RedSet_4(19),mass4set(:,1),  & 
G1H6(20),G1H6(23),G1H6(24),G1H6(25),G1H6(26),G0H6(3),6)
  call HG1shiftOLR(G1H6(23),4,6)
  call Hloop_QV_A(ntryL,G1H6(65),ex4(:),G1H3(17),m3h2x3(:,26),heltab2x6(:,:,53))
  call Hloop_Q_A(ntryL,G1H3(17),27,0,G2H3(6),n2h3(20))
  call Hloop_QV_A(ntryL,G1H6(66),ex4(:),G1H3(28),m3h2x3(:,27),heltab2x6(:,:,54))
  call Hloop_Q_A(ntryL,G1H3(28),27,0,G2H3(7),n2h3(21))
  call Hotf_4pt_reduction(G2H6(13),RedSet_4(19),mass4set(:,1),  & 
G1H6(29),G1H6(30),G1H6(31),G1H6(32),G1H6(35),G0H6(4),6)
  call HG1shiftOLR(G1H6(30),4,6)
  call Hloop_AZ_Q(ntryL,G1H6(49),ex3(:),G1H2(2),ngZu,m3h3x2(:,28),heltab2x6(:,:,55))
  call Hloop_A_Q(ntryL,G1H2(2),23,0,G2H2(29),n2h2(58))
  call Hotf_4pt_reduction(G2H6(25),RedSet_4(12),mass4set(:,1),  & 
G1H6(36),G1H6(37),G1H6(38),G1H6(41),G1H6(42),G0H6(5),6)
  call HG1shiftOLR(G1H6(37),8,6)
  call Hloop_AZ_Q(ntryL,G1H6(50),ex3(:),G1H2(7),ngZu,m3h3x2(:,29),heltab2x6(:,:,56))
  call Hloop_A_Q(ntryL,G1H2(7),23,0,G2H2(30),n2h2(59))
  call Hloop_AZ_Q(ntryL,G1H6(53),ex3(:),G1H2(8),ngZd,m3h3x2(:,30),heltab2x6(:,:,57))
  call Hloop_A_Q(ntryL,G1H2(8),23,0,G2H2(33),n2h2(60))
  call Hotf_4pt_reduction(G2H6(29),RedSet_4(12),mass4set(:,1),  & 
G1H6(43),G1H6(44),G1H6(47),G1H6(48),G1H6(3),G0H6(6),6)
  call HG1shiftOLR(G1H6(44),8,6)
  call Hloop_AV_Q(ntryL,G1H6(54),ex4(:),G1H3(39),m3h2x3(:,28),heltab2x6(:,:,58))
  call Hloop_A_Q(ntryL,G1H3(39),27,0,G2H3(9),n2h3(22))
  call Hotf_4pt_reduction(G2H6(11),RedSet_4(19),mass4set(:,1),  & 
G1H6(10),G1H6(4),G1H6(9),G1H6(15),G1H6(16),G0H6(7),6)
  call HG1shiftOLR(G1H6(4),4,6)
  call Hloop_AV_Q(ntryL,G1H6(55),ex4(:),G1H3(50),m3h2x3(:,29),heltab2x6(:,:,59))
  call Hloop_A_Q(ntryL,G1H3(50),27,0,G2H3(10),n2h3(23))
  call Hloop_AV_Q(ntryL,G1H6(56),ex4(:),G1H3(61),m3h2x3(:,30),heltab2x6(:,:,60))
  call Hloop_A_Q(ntryL,G1H3(61),27,0,G2H3(12),n2h3(24))
  call Hotf_4pt_reduction(G2H6(15),RedSet_4(19),mass4set(:,1),  & 
G1H6(21),G1H6(28),G1H6(22),G1H6(27),G1H6(33),G0H6(8),6)
  call HG1shiftOLR(G1H6(28),4,6)
  call Hloop_WQ_A(ntryL,G1H4(12),ex1(:),G1H2(12),m3h2x2(:,45),heltab2x4(:,:,45))
  call Hloop_Q_A(ntryL,G1H2(12),23,0,G2H2(37),n2h2(61))
  call Hloop_WA_Q(ntryL,G1H4(11),ex2(:),G1H2(13),m3h2x2(:,46),heltab2x4(:,:,46))
  call Hloop_A_Q(ntryL,G1H2(13),23,0,G2H2(39),n2h2(62))
  call Hotf_4pt_reduction(G2H6(10),RedSet_4(19),mass4set(:,7),  & 
G1H6(34),G1H6(39),G1H6(46),G1H6(40),G1H6(45),G0H6(9),6)
  call HG1shiftOLR(G1H6(39),4,6)
  call Hotf_4pt_reduction(G2H6(12),RedSet_4(19),mass4set(:,7),  & 
G1H6(51),G1H6(52),G1H6(57),G1H6(64),G1H6(58),G0H6(10),6)
  call HG1shiftOLR(G1H6(52),4,6)
  call Hotf_4pt_reduction(G2H6(14),RedSet_4(19),mass4set(:,8),  & 
G1H6(63),G1H6(69),G1H6(70),G1H6(59),G1H6(60),G0H6(11),6)
  call HG1shiftOLR(G1H6(69),4,6)
  call Hotf_4pt_reduction(G2H6(16),RedSet_4(19),mass4set(:,8),  & 
G1H6(61),G1H6(62),G1H6(65),G1H6(66),G1H6(49),G0H6(12),6)
  call HG1shiftOLR(G1H6(62),4,6)
  call Hotf_4pt_reduction(G2H6(26),RedSet_4(12),mass4set(:,7),  & 
G1H6(50),G1H6(53),G1H6(54),G1H6(55),G1H6(56),G0H6(13),6)
  call HG1shiftOLR(G1H6(53),8,6)
  call Hotf_4pt_reduction(G2H6(28),RedSet_4(12),mass4set(:,7),  & 
G1H6(73),G1H6(74),G1H6(75),G1H6(76),G1H6(77),G0H6(14),6)
  call HG1shiftOLR(G1H6(74),8,6)
  call Hotf_4pt_reduction(G2H6(30),RedSet_4(12),mass4set(:,8),  & 
G1H6(78),G1H6(79),G1H6(80),G1H6(81),G1H6(82),G0H6(15),6)
  call HG1shiftOLR(G1H6(79),8,6)
  call Hotf_4pt_reduction(G2H6(32),RedSet_4(12),mass4set(:,8),  & 
G1H6(83),G1H6(84),G1H6(85),G1H6(86),G1H6(87),G0H6(16),6)
  call HG1shiftOLR(G1H6(84),8,6)
  call Hotf_4pt_reduction(G2H8(5),RedSet_4(9),mass4set(:,1),  & 
G1H8(1),G1H8(2),G1H8(3),G1H8(4),G1H8(5),G0H8(1),8)
  call HG1shiftOLR(G1H8(2),8,8)
  call Hotf_4pt_reduction(G2H8(2),RedSet_4(9),mass4set(:,7),  & 
G1H8(6),G1H8(7),G1H8(8),G1H8(9),G1H8(10),G0H8(2),8)
  call HG1shiftOLR(G1H8(7),8,8)
  call Hotf_4pt_reduction(G2H8(7),RedSet_4(9),mass4set(:,1),  & 
G1H8(11),G1H8(12),G1H8(13),G1H8(14),G1H8(15),G0H8(3),8)
  call HG1shiftOLR(G1H8(12),8,8)
  call Hotf_4pt_reduction(G2H8(4),RedSet_4(9),mass4set(:,7),  & 
G1H8(16),G1H8(17),G1H8(18),G1H8(19),G1H8(20),G0H8(4),8)
  call HG1shiftOLR(G1H8(17),8,8)
  call Hotf_4pt_reduction(G2H8(6),RedSet_4(9),mass4set(:,8),  & 
G1H8(21),G1H8(22),G1H8(23),G1H8(24),G1H8(25),G0H8(5),8)
  call HG1shiftOLR(G1H8(22),8,8)
  call Hotf_4pt_reduction(G2H8(8),RedSet_4(9),mass4set(:,8),  & 
G1H8(26),G1H8(27),G1H8(28),G1H8(29),G1H8(30),G0H8(6),8)
  call HG1shiftOLR(G1H8(27),8,8)
  call Hotf_4pt_reduction(G2H8(9),RedSet_4(9),mass4set(:,1),  & 
G1H8(31),G1H8(32),G1H8(33),G1H8(34),G1H8(35),G0H8(7),8)
  call HG1shiftOLR(G1H8(32),8,8)
  call Hotf_4pt_reduction(G2H8(10),RedSet_4(9),mass4set(:,7),  & 
G1H8(36),G1H8(37),G1H8(38),G1H8(39),G1H8(40),G0H8(8),8)
  call HG1shiftOLR(G1H8(37),8,8)
  call Hotf_4pt_reduction(G2H8(11),RedSet_4(9),mass4set(:,1),  & 
G1H8(41),G1H8(42),G1H8(43),G1H8(44),G1H8(45),G0H8(9),8)
  call HG1shiftOLR(G1H8(42),8,8)
  call Hotf_4pt_reduction(G2H8(12),RedSet_4(9),mass4set(:,7),  & 
G1H8(46),G1H8(47),G1H8(48),G1H8(49),G1H8(50),G0H8(10),8)
  call HG1shiftOLR(G1H8(47),8,8)
  call Hotf_4pt_reduction(G2H8(13),RedSet_4(9),mass4set(:,1),  & 
G1H8(51),G1H8(52),G1H8(53),G1H8(54),G1H8(55),G0H8(11),8)
  call HG1shiftOLR(G1H8(52),8,8)
  call Hotf_4pt_reduction(G2H8(14),RedSet_4(9),mass4set(:,8),  & 
G1H8(56),G1H8(57),G1H8(58),G1H8(59),G1H8(60),G0H8(12),8)
  call HG1shiftOLR(G1H8(57),8,8)
  call Hotf_4pt_reduction(G2H8(15),RedSet_4(9),mass4set(:,1),  & 
G1H8(61),G1H8(62),G1H8(63),G1H8(64),G1H8(65),G0H8(13),8)
  call HG1shiftOLR(G1H8(62),8,8)
  call Hotf_4pt_reduction(G2H8(16),RedSet_4(9),mass4set(:,8),  & 
G1H8(66),G1H8(67),G1H8(68),G1H8(69),G1H8(70),G0H8(14),8)
  call HG1shiftOLR(G1H8(67),8,8)
  call Hloop_VQ_A(ntryL,G1H12(8),wf6(:,2),G1H2(18),m3h6x2(:,1),heltab2x12(:,:,36))
  call Hloop_Q_A(ntryL,G1H2(18),23,0,G2H2(40),n2h2(63))
  call Hloop_ZQ_A(ntryL,G1H12(9),wf6(:,2),G1H2(19),ngZu,m3h6x2(:,2),heltab2x12(:,:,37))
  call Hloop_Q_A(ntryL,G1H2(19),23,0,G2H2(42),n2h2(64))
  call Hloop_WQ_A(ntryL,G1H12(10),wf6(:,2),G1H2(23),m3h6x2(:,3),heltab2x12(:,:,38))
  call Hloop_Q_A(ntryL,G1H2(23),23,0,G2H2(43),n2h2(65))
  call Hloop_VA_Q(ntryL,G1H12(11),wf6(:,4),G1H2(24),m3h6x2(:,4),heltab2x12(:,:,39))
  call Hloop_A_Q(ntryL,G1H2(24),23,0,G2H2(45),n2h2(66))
  call Hloop_ZA_Q(ntryL,G1H12(12),wf6(:,4),G1H2(29),ngZu,m3h6x2(:,5),heltab2x12(:,:,40))
  call Hloop_A_Q(ntryL,G1H2(29),23,0,G2H2(49),n2h2(67))
  call Hloop_WA_Q(ntryL,G1H12(13),wf6(:,4),G1H2(30),m3h6x2(:,6),heltab2x12(:,:,41))
  call Hloop_A_Q(ntryL,G1H2(30),23,0,G2H2(52),n2h2(68))
  call Hloop_UV_W(ntryL,G1H12(14),18,ex3(:),4,G2H4(1),m3h3x4(:,5),heltab2x12(:,:,42))
  call Hloop_QA_V(ntryL,G2H8(17),ex2(:),G2H4(2),m3h2x4(:,7),heltab2x8(:,:,7))
  call Hloop_QA_Z(ntryL,G2H8(18),ex2(:),G2H4(3),ngZu,m3h2x4(:,8),heltab2x8(:,:,8))
  call Hloop_QA_W(ntryL,G2H8(19),ex2(:),G2H4(4),m3h2x4(:,9),heltab2x8(:,:,9))
  call Hloop_VQ_A(ntryL,G1H12(15),wf4(:,7),G1H3(1),m3h4x3(:,1),heltab2x12(:,:,43))
  call Hloop_Q_A(ntryL,G1H3(1),27,0,G2H3(16),n2h3(25))
  call Hloop_ZQ_A(ntryL,G1H12(16),wf4(:,7),G1H3(2),ngZu,m3h4x3(:,2),heltab2x12(:,:,44))
  call Hloop_Q_A(ntryL,G1H3(2),27,0,G2H3(18),n2h3(26))
  call Hloop_WQ_A(ntryL,G1H12(17),wf4(:,7),G1H3(7),m3h4x3(:,3),heltab2x12(:,:,45))
  call Hloop_Q_A(ntryL,G1H3(7),27,0,G2H3(19),n2h3(27))
  call Hloop_UW_V(ntryL,G1H12(18),17,ex3(:),4,G2H4(5),m3h3x4(:,6),heltab2x12(:,:,46))
  call Hloop_AQ_V(ntryL,G2H8(20),ex1(:),G2H4(6),m3h2x4(:,10),heltab2x8(:,:,10))
  call Hloop_AQ_Z(ntryL,G2H8(21),ex1(:),G2H4(7),ngZu,m3h2x4(:,11),heltab2x8(:,:,11))
  call Hloop_AQ_W(ntryL,G2H8(22),ex1(:),G2H4(8),m3h2x4(:,12),heltab2x8(:,:,12))
  call Hloop_VA_Q(ntryL,G1H12(19),wf4(:,2),G1H3(8),m3h4x3(:,4),heltab2x12(:,:,47))
  call Hloop_A_Q(ntryL,G1H3(8),27,0,G2H3(21),n2h3(28))
  call Hloop_ZA_Q(ntryL,G1H12(20),wf4(:,2),G1H3(12),ngZu,m3h4x3(:,5),heltab2x12(:,:,48))
  call Hloop_A_Q(ntryL,G1H3(12),27,0,G2H3(22),n2h3(29))
  call Hloop_WA_Q(ntryL,G1H12(21),wf4(:,2),G1H3(13),m3h4x3(:,6),heltab2x12(:,:,49))
  call Hloop_A_Q(ntryL,G1H3(13),27,0,G2H3(24),n2h3(30))
  call Hloop_VQ_A(ntryL,G1H6(67),ex1(:),G1H3(18),m3h2x3(:,31),heltab2x6(:,:,61))
  call Hloop_Q_A(ntryL,G1H3(18),27,0,G2H3(25),n2h3(31))
  call Hloop_ZQ_A(ntryL,G1H6(68),ex1(:),G1H3(19),ngZu,m3h2x3(:,32),heltab2x6(:,:,62))
  call Hloop_Q_A(ntryL,G1H3(19),27,0,G2H3(26),n2h3(32))
  call Hloop_WQ_A(ntryL,G1H6(71),ex1(:),G1H3(23),m3h2x3(:,33),heltab2x6(:,:,63))
  call Hloop_Q_A(ntryL,G1H3(23),27,0,G2H3(27),n2h3(33))
  call Hloop_VA_Q(ntryL,G1H6(72),ex2(:),G1H3(24),m3h2x3(:,34),heltab2x6(:,:,64))
  call Hloop_A_Q(ntryL,G1H3(24),27,0,G2H3(28),n2h3(34))
  call Hloop_ZA_Q(ntryL,G1H6(1),ex2(:),G1H3(29),ngZu,m3h2x3(:,35),heltab2x6(:,:,65))
  call Hloop_A_Q(ntryL,G1H3(29),27,0,G2H3(29),n2h3(35))
  call Hloop_WA_Q(ntryL,G1H6(2),ex2(:),G1H3(30),m3h2x3(:,36),heltab2x6(:,:,66))
  call Hloop_A_Q(ntryL,G1H3(30),27,0,G2H3(30),n2h3(36))
  call Hloop_UW_V(ntryL,G1H6(5),25,ex3(:),4,G2H2(53),m3h3x2(:,31),heltab2x6(:,:,67))
  call Hloop_QZ_A(ntryL,G1H6(6),ex3(:),G1H2(34),ngZu,m3h3x2(:,32),heltab2x6(:,:,68))
  call Hloop_Q_A(ntryL,G1H2(34),23,0,G2H2(56),n2h2(69))
call HGT_OLR(G1H6(7),1,1,6)
call HGT_invQ_OLR(G1H6(7),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(7),-8,0,G2H6(19),n2h6(69))
  call Hloop_AV_Q(ntryL,G2H6(19),ex4(:),G2H3(31),m3h2x3(:,37),heltab2x6(:,:,69))
  call Hloop_QZ_A(ntryL,G1H6(11),ex3(:),G1H2(35),ngZu,m3h3x2(:,33),heltab2x6(:,:,70))
  call Hloop_Q_A(ntryL,G1H2(35),23,0,G2H2(57),n2h2(70))
  call Hloop_QZ_A(ntryL,G1H6(12),ex3(:),G1H2(40),ngZu,m3h3x2(:,34),heltab2x6(:,:,71))
  call Hloop_Q_A(ntryL,G1H2(40),23,0,G2H2(58),n2h2(71))
  call Hloop_QZ_A(ntryL,G0H6(1),ex3(:),G0H2(1),ngZu,m3h3x2(:,35),heltab2x6(:,:,72))
  call Hloop_Q_A(ntryL,G0H2(1),23,0,G1H2(41),n2h2(72))
  call Hloop_QZ_A(ntryL,G1H6(13),ex3(:),G1H2(45),ngZd,m3h3x2(:,36),heltab2x6(:,:,73))
  call Hloop_Q_A(ntryL,G1H2(45),23,0,G2H2(59),n2h2(73))
call HGT_OLR(G1H6(14),1,1,6)
call HGT_invQ_OLR(G1H6(14),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(14),-8,0,G2H6(23),n2h6(70))
  call Hloop_AV_Q(ntryL,G2H6(23),ex4(:),G2H3(32),m3h2x3(:,38),heltab2x6(:,:,74))
  call Hloop_QZ_A(ntryL,G1H6(18),ex3(:),G1H2(46),ngZd,m3h3x2(:,37),heltab2x6(:,:,75))
  call Hloop_Q_A(ntryL,G1H2(46),23,0,G2H2(60),n2h2(74))
  call Hloop_QZ_A(ntryL,G1H6(19),ex3(:),G1H2(51),ngZd,m3h3x2(:,38),heltab2x6(:,:,76))
  call Hloop_Q_A(ntryL,G1H2(51),23,0,G2H2(61),n2h2(75))
  call Hloop_QZ_A(ntryL,G0H6(2),ex3(:),G0H2(1),ngZd,m3h3x2(:,39),heltab2x6(:,:,77))
  call Hloop_Q_A(ntryL,G0H2(1),23,0,G1H2(52),n2h2(76))
  call Hloop_QV_A(ntryL,G1H6(20),ex4(:),G1H3(34),m3h2x3(:,39),heltab2x6(:,:,78))
  call Hloop_Q_A(ntryL,G1H3(34),27,0,G2H3(33),n2h3(37))
call HGT_OLR(G1H6(23),1,1,6)
call HGT_invQ_OLR(G1H6(23),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(23),-4,0,G2H6(1),n2h6(71))
  call Hloop_AZ_Q(ntryL,G2H6(1),ex3(:),G2H2(62),ngZu,m3h3x2(:,40),heltab2x6(:,:,79))
  call Hloop_QV_A(ntryL,G1H6(25),ex4(:),G1H3(35),m3h2x3(:,40),heltab2x6(:,:,80))
  call Hloop_Q_A(ntryL,G1H3(35),27,0,G2H3(34),n2h3(38))
  call Hloop_QV_A(ntryL,G1H6(26),ex4(:),G1H3(40),m3h2x3(:,41),heltab2x6(:,:,81))
  call Hloop_Q_A(ntryL,G1H3(40),27,0,G2H3(35),n2h3(39))
  call Hloop_QV_A(ntryL,G0H6(3),ex4(:),G0H3(1),m3h2x3(:,42),heltab2x6(:,:,82))
  call Hloop_Q_A(ntryL,G0H3(1),27,0,G1H3(41),n2h3(40))
  call Hloop_QV_A(ntryL,G1H6(29),ex4(:),G1H3(45),m3h2x3(:,43),heltab2x6(:,:,83))
  call Hloop_Q_A(ntryL,G1H3(45),27,0,G2H3(36),n2h3(41))
call HGT_OLR(G1H6(30),1,1,6)
call HGT_invQ_OLR(G1H6(30),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(30),-4,0,G2H6(5),n2h6(72))
  call Hloop_AZ_Q(ntryL,G2H6(5),ex3(:),G2H2(63),ngZd,m3h3x2(:,41),heltab2x6(:,:,84))
  call Hloop_QV_A(ntryL,G1H6(32),ex4(:),G1H3(46),m3h2x3(:,44),heltab2x6(:,:,85))
  call Hloop_Q_A(ntryL,G1H3(46),27,0,G2H3(37),n2h3(42))
  call Hloop_QV_A(ntryL,G1H6(35),ex4(:),G1H3(51),m3h2x3(:,45),heltab2x6(:,:,86))
  call Hloop_Q_A(ntryL,G1H3(51),27,0,G2H3(38),n2h3(43))
  call Hloop_QV_A(ntryL,G0H6(4),ex4(:),G0H3(1),m3h2x3(:,46),heltab2x6(:,:,87))
  call Hloop_Q_A(ntryL,G0H3(1),27,0,G1H3(52),n2h3(44))
  call Hloop_AZ_Q(ntryL,G1H6(36),ex3(:),G1H2(56),ngZu,m3h3x2(:,42),heltab2x6(:,:,88))
  call Hloop_A_Q(ntryL,G1H2(56),23,0,G2H2(64),n2h2(77))
call HGT_OLR(G1H6(37),1,1,6)
call HGT_invQ_OLR(G1H6(37),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(37),-8,0,G2H6(17),n2h6(73))
  call Hloop_QV_A(ntryL,G2H6(17),ex4(:),G2H3(39),m3h2x3(:,47),heltab2x6(:,:,89))
  call Hloop_AZ_Q(ntryL,G1H6(41),ex3(:),G1H2(57),ngZu,m3h3x2(:,43),heltab2x6(:,:,90))
  call Hloop_A_Q(ntryL,G1H2(57),23,0,G2H2(65),n2h2(78))
  call Hloop_AZ_Q(ntryL,G1H6(42),ex3(:),G1H2(62),ngZu,m3h3x2(:,44),heltab2x6(:,:,91))
  call Hloop_A_Q(ntryL,G1H2(62),23,0,G2H2(66),n2h2(79))
  call Hloop_AZ_Q(ntryL,G0H6(5),ex3(:),G0H2(1),ngZu,m3h3x2(:,45),heltab2x6(:,:,92))
  call Hloop_A_Q(ntryL,G0H2(1),23,0,G1H2(63),n2h2(80))
  call Hloop_AZ_Q(ntryL,G1H6(43),ex3(:),G1H2(67),ngZd,m3h3x2(:,46),heltab2x6(:,:,93))
  call Hloop_A_Q(ntryL,G1H2(67),23,0,G2H2(67),n2h2(81))
call HGT_OLR(G1H6(44),1,1,6)
call HGT_invQ_OLR(G1H6(44),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(44),-8,0,G2H6(21),n2h6(74))
  call Hloop_QV_A(ntryL,G2H6(21),ex4(:),G2H3(40),m3h2x3(:,48),heltab2x6(:,:,94))
  call Hloop_AZ_Q(ntryL,G1H6(48),ex3(:),G1H2(68),ngZd,m3h3x2(:,47),heltab2x6(:,:,95))
  call Hloop_A_Q(ntryL,G1H2(68),23,0,G2H2(68),n2h2(82))
  call Hloop_AZ_Q(ntryL,G1H6(3),ex3(:),G1H2(73),ngZd,m3h3x2(:,48),heltab2x6(:,:,96))
  call Hloop_A_Q(ntryL,G1H2(73),23,0,G2H2(69),n2h2(83))
  call Hloop_AZ_Q(ntryL,G0H6(6),ex3(:),G0H2(1),ngZd,m3h3x2(:,49),heltab2x6(:,:,97))
  call Hloop_A_Q(ntryL,G0H2(1),23,0,G1H2(74),n2h2(84))
  call Hloop_AV_Q(ntryL,G1H6(10),ex4(:),G1H3(56),m3h2x3(:,49),heltab2x6(:,:,98))
  call Hloop_A_Q(ntryL,G1H3(56),27,0,G2H3(41),n2h3(45))
call HGT_OLR(G1H6(4),1,1,6)
call HGT_invQ_OLR(G1H6(4),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(4),-4,0,G2H6(3),n2h6(75))
  call Hloop_QZ_A(ntryL,G2H6(3),ex3(:),G2H2(70),ngZu,m3h3x2(:,50),heltab2x6(:,:,99))
  call Hloop_AV_Q(ntryL,G1H6(15),ex4(:),G1H3(57),m3h2x3(:,50),heltab2x6(:,:,100))
  call Hloop_A_Q(ntryL,G1H3(57),27,0,G2H3(42),n2h3(46))
  call Hloop_AV_Q(ntryL,G1H6(16),ex4(:),G1H3(62),m3h2x3(:,51),heltab2x6(:,:,101))
  call Hloop_A_Q(ntryL,G1H3(62),27,0,G2H3(43),n2h3(47))
  call Hloop_AV_Q(ntryL,G0H6(7),ex4(:),G0H3(1),m3h2x3(:,52),heltab2x6(:,:,102))
  call Hloop_A_Q(ntryL,G0H3(1),27,0,G1H3(63),n2h3(48))
  call Hloop_AV_Q(ntryL,G1H6(21),ex4(:),G1H3(6),m3h2x3(:,53),heltab2x6(:,:,103))
  call Hloop_A_Q(ntryL,G1H3(6),27,0,G2H3(44),n2h3(49))
call HGT_OLR(G1H6(28),1,1,6)
call HGT_invQ_OLR(G1H6(28),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(28),-4,0,G2H6(7),n2h6(76))
  call Hloop_QZ_A(ntryL,G2H6(7),ex3(:),G2H2(71),ngZd,m3h3x2(:,51),heltab2x6(:,:,104))
  call Hloop_AV_Q(ntryL,G1H6(27),ex4(:),G1H3(17),m3h2x3(:,54),heltab2x6(:,:,105))
  call Hloop_A_Q(ntryL,G1H3(17),27,0,G2H3(45),n2h3(50))
  call Hloop_AV_Q(ntryL,G1H6(33),ex4(:),G1H3(28),m3h2x3(:,55),heltab2x6(:,:,106))
  call Hloop_A_Q(ntryL,G1H3(28),27,0,G2H3(46),n2h3(51))
  call Hloop_AV_Q(ntryL,G0H6(8),ex4(:),G0H3(1),m3h2x3(:,56),heltab2x6(:,:,107))
  call Hloop_A_Q(ntryL,G0H3(1),27,0,G1H3(39),n2h3(52))
  call Hloop_QV_A(ntryL,G1H6(34),ex4(:),G1H3(50),m3h2x3(:,57),heltab2x6(:,:,108))
  call Hloop_Q_A(ntryL,G1H3(50),27,nMT,G2H3(47),n2h3(53))
call HGT_OLR(G1H6(39),1,1,6)
call HGT_invQ_OLR(G1H6(39),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(39),-4,nMT,G2H6(2),n2h6(77))
  call Hloop_AZ_Q(ntryL,G2H6(2),ex3(:),G2H2(72),ngZu,m3h3x2(:,52),heltab2x6(:,:,109))
  call Hloop_QV_A(ntryL,G1H6(40),ex4(:),G1H3(61),m3h2x3(:,58),heltab2x6(:,:,110))
  call Hloop_Q_A(ntryL,G1H3(61),27,nMT,G2H3(48),n2h3(54))
  call Hloop_QV_A(ntryL,G1H6(45),ex4(:),G1H3(1),m3h2x3(:,59),heltab2x6(:,:,111))
  call Hloop_Q_A(ntryL,G1H3(1),27,nMT,G2H3(49),n2h3(55))
  call Hloop_QV_A(ntryL,G0H6(9),ex4(:),G0H3(1),m3h2x3(:,60),heltab2x6(:,:,112))
  call Hloop_Q_A(ntryL,G0H3(1),27,nMT,G1H3(2),n2h3(56))
  call Hloop_AV_Q(ntryL,G1H6(51),ex4(:),G1H3(7),m3h2x3(:,61),heltab2x6(:,:,113))
  call Hloop_A_Q(ntryL,G1H3(7),27,nMT,G2H3(50),n2h3(57))
call HGT_OLR(G1H6(52),1,1,6)
call HGT_invQ_OLR(G1H6(52),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(52),-4,nMT,G2H6(4),n2h6(78))
  call Hloop_QZ_A(ntryL,G2H6(4),ex3(:),G2H2(73),ngZu,m3h3x2(:,53),heltab2x6(:,:,114))
  call Hloop_AV_Q(ntryL,G1H6(64),ex4(:),G1H3(8),m3h2x3(:,62),heltab2x6(:,:,115))
  call Hloop_A_Q(ntryL,G1H3(8),27,nMT,G2H3(51),n2h3(58))
  call Hloop_AV_Q(ntryL,G1H6(58),ex4(:),G1H3(12),m3h2x3(:,63),heltab2x6(:,:,116))
  call Hloop_A_Q(ntryL,G1H3(12),27,nMT,G2H3(52),n2h3(59))
  call Hloop_AV_Q(ntryL,G0H6(10),ex4(:),G0H3(1),m3h2x3(:,64),heltab2x6(:,:,117))
  call Hloop_A_Q(ntryL,G0H3(1),27,nMT,G1H3(13),n2h3(60))
  call Hloop_QV_A(ntryL,G1H6(63),ex4(:),G1H3(18),m3h2x3(:,65),heltab2x6(:,:,118))
  call Hloop_Q_A(ntryL,G1H3(18),27,nMB,G2H3(53),n2h3(61))
call HGT_OLR(G1H6(69),1,1,6)
call HGT_invQ_OLR(G1H6(69),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(69),-4,nMB,G2H6(6),n2h6(79))
  call Hloop_AZ_Q(ntryL,G2H6(6),ex3(:),G2H2(74),ngZd,m3h3x2(:,54),heltab2x6(:,:,119))
  call Hloop_QV_A(ntryL,G1H6(59),ex4(:),G1H3(19),m3h2x3(:,66),heltab2x6(:,:,120))
  call Hloop_Q_A(ntryL,G1H3(19),27,nMB,G2H3(54),n2h3(62))
  call Hloop_QV_A(ntryL,G1H6(60),ex4(:),G1H3(23),m3h2x3(:,67),heltab2x6(:,:,121))
  call Hloop_Q_A(ntryL,G1H3(23),27,nMB,G2H3(55),n2h3(63))
  call Hloop_QV_A(ntryL,G0H6(11),ex4(:),G0H3(1),m3h2x3(:,68),heltab2x6(:,:,122))
  call Hloop_Q_A(ntryL,G0H3(1),27,nMB,G1H3(24),n2h3(64))
  call Hloop_AV_Q(ntryL,G1H6(61),ex4(:),G1H3(29),m3h2x3(:,69),heltab2x6(:,:,123))
  call Hloop_A_Q(ntryL,G1H3(29),27,nMB,G2H3(56),n2h3(65))
call HGT_OLR(G1H6(62),1,1,6)
call HGT_invQ_OLR(G1H6(62),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(62),-4,nMB,G2H6(8),n2h6(80))
  call Hloop_QZ_A(ntryL,G2H6(8),ex3(:),G2H2(75),ngZd,m3h3x2(:,55),heltab2x6(:,:,124))
  call Hloop_AV_Q(ntryL,G1H6(66),ex4(:),G1H3(30),m3h2x3(:,70),heltab2x6(:,:,125))
  call Hloop_A_Q(ntryL,G1H3(30),27,nMB,G2H3(57),n2h3(66))
  call Hloop_AV_Q(ntryL,G1H6(49),ex4(:),G1H3(34),m3h2x3(:,71),heltab2x6(:,:,126))
  call Hloop_A_Q(ntryL,G1H3(34),27,nMB,G2H3(58),n2h3(67))
  call Hloop_AV_Q(ntryL,G0H6(12),ex4(:),G0H3(1),m3h2x3(:,72),heltab2x6(:,:,127))
  call Hloop_A_Q(ntryL,G0H3(1),27,nMB,G1H3(35),n2h3(68))
  call Hloop_AZ_Q(ntryL,G1H6(50),ex3(:),G1H2(78),ngZu,m3h3x2(:,56),heltab2x6(:,:,128))
  call Hloop_A_Q(ntryL,G1H2(78),23,nMT,G2H2(76),n2h2(85))
call HGT_OLR(G1H6(53),1,1,6)
call HGT_invQ_OLR(G1H6(53),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(53),-8,nMT,G2H6(18),n2h6(81))
  call Hloop_QV_A(ntryL,G2H6(18),ex4(:),G2H3(59),m3h2x3(:,73),heltab2x6(:,:,129))
  call Hloop_AZ_Q(ntryL,G1H6(55),ex3(:),G1H2(79),ngZu,m3h3x2(:,57),heltab2x6(:,:,130))
  call Hloop_A_Q(ntryL,G1H2(79),23,nMT,G2H2(77),n2h2(86))
  call Hloop_AZ_Q(ntryL,G1H6(56),ex3(:),G1H2(84),ngZu,m3h3x2(:,58),heltab2x6(:,:,131))
  call Hloop_A_Q(ntryL,G1H2(84),23,nMT,G2H2(78),n2h2(87))
  call Hloop_AZ_Q(ntryL,G0H6(13),ex3(:),G0H2(1),ngZu,m3h3x2(:,59),heltab2x6(:,:,132))
  call Hloop_A_Q(ntryL,G0H2(1),23,nMT,G1H2(85),n2h2(88))
  call Hloop_QZ_A(ntryL,G1H6(73),ex3(:),G1H2(89),ngZu,m3h3x2(:,60),heltab2x6(:,:,133))
  call Hloop_Q_A(ntryL,G1H2(89),23,nMT,G2H2(79),n2h2(89))
call HGT_OLR(G1H6(74),1,1,6)
call HGT_invQ_OLR(G1H6(74),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(74),-8,nMT,G2H6(20),n2h6(82))
  call Hloop_AV_Q(ntryL,G2H6(20),ex4(:),G2H3(60),m3h2x3(:,74),heltab2x6(:,:,134))
  call Hloop_QZ_A(ntryL,G1H6(76),ex3(:),G1H2(90),ngZu,m3h3x2(:,61),heltab2x6(:,:,135))
  call Hloop_Q_A(ntryL,G1H2(90),23,nMT,G2H2(80),n2h2(90))
  call Hloop_QZ_A(ntryL,G1H6(77),ex3(:),G1H2(95),ngZu,m3h3x2(:,62),heltab2x6(:,:,136))
  call Hloop_Q_A(ntryL,G1H2(95),23,nMT,G2H2(81),n2h2(91))
  call Hloop_QZ_A(ntryL,G0H6(14),ex3(:),G0H2(1),ngZu,m3h3x2(:,63),heltab2x6(:,:,137))
  call Hloop_Q_A(ntryL,G0H2(1),23,nMT,G1H2(96),n2h2(92))
  call Hloop_AZ_Q(ntryL,G1H6(78),ex3(:),G1H2(100),ngZd,m3h3x2(:,64),heltab2x6(:,:,138))
  call Hloop_A_Q(ntryL,G1H2(100),23,nMB,G2H2(82),n2h2(93))
call HGT_OLR(G1H6(79),1,1,6)
call HGT_invQ_OLR(G1H6(79),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(79),-8,nMB,G2H6(22),n2h6(83))
  call Hloop_QV_A(ntryL,G2H6(22),ex4(:),G2H3(61),m3h2x3(:,75),heltab2x6(:,:,139))
  call Hloop_AZ_Q(ntryL,G1H6(81),ex3(:),G1H2(101),ngZd,m3h3x2(:,65),heltab2x6(:,:,140))
  call Hloop_A_Q(ntryL,G1H2(101),23,nMB,G2H2(83),n2h2(94))
  call Hloop_AZ_Q(ntryL,G1H6(82),ex3(:),G1H2(106),ngZd,m3h3x2(:,66),heltab2x6(:,:,141))
  call Hloop_A_Q(ntryL,G1H2(106),23,nMB,G2H2(84),n2h2(95))
  call Hloop_AZ_Q(ntryL,G0H6(15),ex3(:),G0H2(1),ngZd,m3h3x2(:,67),heltab2x6(:,:,142))
  call Hloop_A_Q(ntryL,G0H2(1),23,nMB,G1H2(107),n2h2(96))
  call Hloop_QZ_A(ntryL,G1H6(83),ex3(:),G1H2(111),ngZd,m3h3x2(:,68),heltab2x6(:,:,143))
  call Hloop_Q_A(ntryL,G1H2(111),23,nMB,G2H2(85),n2h2(97))
call HGT_OLR(G1H6(84),1,1,6)
call HGT_invQ_OLR(G1H6(84),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(84),-8,nMB,G2H6(24),n2h6(84))
  call Hloop_AV_Q(ntryL,G2H6(24),ex4(:),G2H3(62),m3h2x3(:,76),heltab2x6(:,:,144))
  call Hloop_QZ_A(ntryL,G1H6(86),ex3(:),G1H2(112),ngZd,m3h3x2(:,69),heltab2x6(:,:,145))
  call Hloop_Q_A(ntryL,G1H2(112),23,nMB,G2H2(86),n2h2(98))
  call Hloop_QZ_A(ntryL,G1H6(87),ex3(:),G1H2(117),ngZd,m3h3x2(:,70),heltab2x6(:,:,146))
  call Hloop_Q_A(ntryL,G1H2(117),23,nMB,G2H2(87),n2h2(99))
  call Hloop_QZ_A(ntryL,G0H6(16),ex3(:),G0H2(1),ngZd,m3h3x2(:,71),heltab2x6(:,:,147))
  call Hloop_Q_A(ntryL,G0H2(1),23,nMB,G1H2(118),n2h2(100))
  call Hloop_QV_A(ntryL,G1H8(1),wf4(:,10),G1H2(122),m3h4x2(:,1),heltab2x8(:,:,13))
  call Hloop_Q_A(ntryL,G1H2(122),23,0,G2H2(88),n2h2(101))
call HGT_OLR(G1H8(2),1,1,8)
call HGT_invQ_OLR(G1H8(2),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(2),-8,0,G2H8(1),n2h8(29))
  call Hloop_AV_Q(ntryL,G2H8(1),ex4(:),G2H4(9),m3h2x4(:,13),heltab2x8(:,:,14))
  call Hloop_QV_A(ntryL,G1H8(4),wf4(:,10),G1H2(123),m3h4x2(:,2),heltab2x8(:,:,15))
  call Hloop_Q_A(ntryL,G1H2(123),23,0,G2H2(89),n2h2(102))
  call Hloop_QV_A(ntryL,G1H8(5),wf4(:,10),G1H2(128),m3h4x2(:,3),heltab2x8(:,:,16))
  call Hloop_Q_A(ntryL,G1H2(128),23,0,G2H2(90),n2h2(103))
  call Hloop_QV_A(ntryL,G0H8(1),wf4(:,10),G0H2(1),m3h4x2(:,4),heltab2x8(:,:,17))
  call Hloop_Q_A(ntryL,G0H2(1),23,0,G1H2(129),n2h2(104))
  call Hloop_QV_A(ntryL,G1H8(6),wf4(:,10),G1H2(133),m3h4x2(:,5),heltab2x8(:,:,18))
  call Hloop_Q_A(ntryL,G1H2(133),23,nMT,G2H2(91),n2h2(105))
call HGT_OLR(G1H8(7),1,1,8)
call HGT_invQ_OLR(G1H8(7),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(7),-8,nMT,G2H8(3),n2h8(30))
  call Hloop_AV_Q(ntryL,G2H8(3),ex4(:),G2H4(10),m3h2x4(:,14),heltab2x8(:,:,19))
  call Hloop_QV_A(ntryL,G1H8(9),wf4(:,10),G1H2(134),m3h4x2(:,6),heltab2x8(:,:,20))
  call Hloop_Q_A(ntryL,G1H2(134),23,nMT,G2H2(92),n2h2(106))
  call Hloop_QV_A(ntryL,G1H8(10),wf4(:,10),G1H2(139),m3h4x2(:,7),heltab2x8(:,:,21))
  call Hloop_Q_A(ntryL,G1H2(139),23,nMT,G2H2(93),n2h2(107))
  call Hloop_QV_A(ntryL,G0H8(2),wf4(:,10),G0H2(1),m3h4x2(:,8),heltab2x8(:,:,22))
  call Hloop_Q_A(ntryL,G0H2(1),23,nMT,G1H2(140),n2h2(108))
  call Hloop_AV_Q(ntryL,G1H8(11),wf4(:,10),G1H2(144),m3h4x2(:,9),heltab2x8(:,:,23))
  call Hloop_A_Q(ntryL,G1H2(144),23,0,G2H2(94),n2h2(109))
call HGT_OLR(G1H8(12),1,1,8)
call HGT_invQ_OLR(G1H8(12),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(12),-8,0,G2H8(5),n2h8(31))
  call Hloop_QV_A(ntryL,G2H8(5),ex4(:),G2H4(11),m3h2x4(:,15),heltab2x8(:,:,24))
  call Hloop_AV_Q(ntryL,G1H8(14),wf4(:,10),G1H2(145),m3h4x2(:,10),heltab2x8(:,:,25))
  call Hloop_A_Q(ntryL,G1H2(145),23,0,G2H2(95),n2h2(110))
  call Hloop_AV_Q(ntryL,G1H8(15),wf4(:,10),G1H2(150),m3h4x2(:,11),heltab2x8(:,:,26))
  call Hloop_A_Q(ntryL,G1H2(150),23,0,G2H2(96),n2h2(111))
  call Hloop_AV_Q(ntryL,G0H8(3),wf4(:,10),G0H2(1),m3h4x2(:,12),heltab2x8(:,:,27))
  call Hloop_A_Q(ntryL,G0H2(1),23,0,G1H2(151),n2h2(112))
  call Hloop_AV_Q(ntryL,G1H8(16),wf4(:,10),G1H2(6),m3h4x2(:,13),heltab2x8(:,:,28))
  call Hloop_A_Q(ntryL,G1H2(6),23,nMT,G2H2(97),n2h2(113))
call HGT_OLR(G1H8(17),1,1,8)
call HGT_invQ_OLR(G1H8(17),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(17),-8,nMT,G2H8(2),n2h8(32))
  call Hloop_QV_A(ntryL,G2H8(2),ex4(:),G2H4(12),m3h2x4(:,16),heltab2x8(:,:,29))
  call Hloop_AV_Q(ntryL,G1H8(19),wf4(:,10),G1H2(17),m3h4x2(:,14),heltab2x8(:,:,30))
  call Hloop_A_Q(ntryL,G1H2(17),23,nMT,G2H2(98),n2h2(114))
  call Hloop_AV_Q(ntryL,G1H8(20),wf4(:,10),G1H2(28),m3h4x2(:,15),heltab2x8(:,:,31))
  call Hloop_A_Q(ntryL,G1H2(28),23,nMT,G2H2(99),n2h2(115))
  call Hloop_AV_Q(ntryL,G0H8(4),wf4(:,10),G0H2(1),m3h4x2(:,16),heltab2x8(:,:,32))
  call Hloop_A_Q(ntryL,G0H2(1),23,nMT,G1H2(39),n2h2(116))
  call Hloop_QV_A(ntryL,G1H8(21),wf4(:,10),G1H2(50),m3h4x2(:,17),heltab2x8(:,:,33))
  call Hloop_Q_A(ntryL,G1H2(50),23,nMB,G2H2(100),n2h2(117))
call HGT_OLR(G1H8(22),1,1,8)
call HGT_invQ_OLR(G1H8(22),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(22),-8,nMB,G2H8(7),n2h8(33))
  call Hloop_AV_Q(ntryL,G2H8(7),ex4(:),G2H4(13),m3h2x4(:,17),heltab2x8(:,:,34))
  call Hloop_QV_A(ntryL,G1H8(24),wf4(:,10),G1H2(61),m3h4x2(:,18),heltab2x8(:,:,35))
  call Hloop_Q_A(ntryL,G1H2(61),23,nMB,G2H2(101),n2h2(118))
  call Hloop_QV_A(ntryL,G1H8(25),wf4(:,10),G1H2(72),m3h4x2(:,19),heltab2x8(:,:,36))
  call Hloop_Q_A(ntryL,G1H2(72),23,nMB,G2H2(102),n2h2(119))
  call Hloop_QV_A(ntryL,G0H8(5),wf4(:,10),G0H2(1),m3h4x2(:,20),heltab2x8(:,:,37))
  call Hloop_Q_A(ntryL,G0H2(1),23,nMB,G1H2(83),n2h2(120))
  call Hloop_AV_Q(ntryL,G1H8(26),wf4(:,10),G1H2(94),m3h4x2(:,21),heltab2x8(:,:,38))
  call Hloop_A_Q(ntryL,G1H2(94),23,nMB,G2H2(103),n2h2(121))
call HGT_OLR(G1H8(27),1,1,8)
call HGT_invQ_OLR(G1H8(27),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(27),-8,nMB,G2H8(4),n2h8(34))
  call Hloop_QV_A(ntryL,G2H8(4),ex4(:),G2H4(14),m3h2x4(:,18),heltab2x8(:,:,39))
  call Hloop_AV_Q(ntryL,G1H8(29),wf4(:,10),G1H2(105),m3h4x2(:,22),heltab2x8(:,:,40))
  call Hloop_A_Q(ntryL,G1H2(105),23,nMB,G2H2(104),n2h2(122))
  call Hloop_AV_Q(ntryL,G1H8(30),wf4(:,10),G1H2(116),m3h4x2(:,23),heltab2x8(:,:,41))
  call Hloop_A_Q(ntryL,G1H2(116),23,nMB,G2H2(105),n2h2(123))
  call Hloop_AV_Q(ntryL,G0H8(6),wf4(:,10),G0H2(1),m3h4x2(:,24),heltab2x8(:,:,42))
  call Hloop_A_Q(ntryL,G0H2(1),23,nMB,G1H2(127),n2h2(124))
  call Hloop_QZ_A(ntryL,G1H8(31),wf4(:,11),G1H2(138),ngZu,m3h4x2(:,25),heltab2x8(:,:,43))
  call Hloop_Q_A(ntryL,G1H2(138),23,0,G2H2(106),n2h2(125))
call HGT_OLR(G1H8(32),1,1,8)
call HGT_invQ_OLR(G1H8(32),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(32),-8,0,G2H8(6),n2h8(35))
  call Hloop_AV_Q(ntryL,G2H8(6),ex4(:),G2H4(15),m3h2x4(:,19),heltab2x8(:,:,44))
  call Hloop_QZ_A(ntryL,G1H8(34),wf4(:,11),G1H2(149),ngZu,m3h4x2(:,26),heltab2x8(:,:,45))
  call Hloop_Q_A(ntryL,G1H2(149),23,0,G2H2(107),n2h2(126))
  call Hloop_QZ_A(ntryL,G1H8(35),wf4(:,11),G1H2(1),ngZu,m3h4x2(:,27),heltab2x8(:,:,46))
  call Hloop_Q_A(ntryL,G1H2(1),23,0,G2H2(108),n2h2(127))
  call Hloop_QZ_A(ntryL,G0H8(7),wf4(:,11),G0H2(1),ngZu,m3h4x2(:,28),heltab2x8(:,:,47))
  call Hloop_Q_A(ntryL,G0H2(1),23,0,G1H2(2),n2h2(128))
  call Hloop_QZ_A(ntryL,G1H8(36),wf4(:,11),G1H2(7),ngZu,m3h4x2(:,29),heltab2x8(:,:,48))
  call Hloop_Q_A(ntryL,G1H2(7),23,nMT,G2H2(109),n2h2(129))
call HGT_OLR(G1H8(37),1,1,8)
call HGT_invQ_OLR(G1H8(37),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(37),-8,nMT,G2H8(8),n2h8(36))
  call Hloop_AV_Q(ntryL,G2H8(8),ex4(:),G2H4(16),m3h2x4(:,20),heltab2x8(:,:,49))
  call Hloop_QZ_A(ntryL,G1H8(39),wf4(:,11),G1H2(8),ngZu,m3h4x2(:,30),heltab2x8(:,:,50))
  call Hloop_Q_A(ntryL,G1H2(8),23,nMT,G2H2(110),n2h2(130))
  call Hloop_QZ_A(ntryL,G1H8(40),wf4(:,11),G1H2(12),ngZu,m3h4x2(:,31),heltab2x8(:,:,51))
  call Hloop_Q_A(ntryL,G1H2(12),23,nMT,G2H2(111),n2h2(131))
  call Hloop_QZ_A(ntryL,G0H8(8),wf4(:,11),G0H2(1),ngZu,m3h4x2(:,32),heltab2x8(:,:,52))
  call Hloop_Q_A(ntryL,G0H2(1),23,nMT,G1H2(13),n2h2(132))
  call Hloop_AZ_Q(ntryL,G1H8(41),wf4(:,11),G1H2(18),ngZu,m3h4x2(:,33),heltab2x8(:,:,53))
  call Hloop_A_Q(ntryL,G1H2(18),23,0,G2H2(112),n2h2(133))
call HGT_OLR(G1H8(42),1,1,8)
call HGT_invQ_OLR(G1H8(42),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(42),-8,0,G2H8(9),n2h8(37))
  call Hloop_QV_A(ntryL,G2H8(9),ex4(:),G2H4(17),m3h2x4(:,21),heltab2x8(:,:,54))
  call Hloop_AZ_Q(ntryL,G1H8(44),wf4(:,11),G1H2(19),ngZu,m3h4x2(:,34),heltab2x8(:,:,55))
  call Hloop_A_Q(ntryL,G1H2(19),23,0,G2H2(113),n2h2(134))
  call Hloop_AZ_Q(ntryL,G1H8(45),wf4(:,11),G1H2(23),ngZu,m3h4x2(:,35),heltab2x8(:,:,56))
  call Hloop_A_Q(ntryL,G1H2(23),23,0,G2H2(114),n2h2(135))
  call Hloop_AZ_Q(ntryL,G0H8(9),wf4(:,11),G0H2(1),ngZu,m3h4x2(:,36),heltab2x8(:,:,57))
  call Hloop_A_Q(ntryL,G0H2(1),23,0,G1H2(24),n2h2(136))
  call Hloop_AZ_Q(ntryL,G1H8(46),wf4(:,11),G1H2(29),ngZu,m3h4x2(:,37),heltab2x8(:,:,58))
  call Hloop_A_Q(ntryL,G1H2(29),23,nMT,G2H2(115),n2h2(137))
call HGT_OLR(G1H8(47),1,1,8)
call HGT_invQ_OLR(G1H8(47),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(47),-8,nMT,G2H8(10),n2h8(38))
  call Hloop_QV_A(ntryL,G2H8(10),ex4(:),G2H4(18),m3h2x4(:,22),heltab2x8(:,:,59))
  call Hloop_AZ_Q(ntryL,G1H8(49),wf4(:,11),G1H2(30),ngZu,m3h4x2(:,38),heltab2x8(:,:,60))
  call Hloop_A_Q(ntryL,G1H2(30),23,nMT,G2H2(116),n2h2(138))
  call Hloop_AZ_Q(ntryL,G1H8(50),wf4(:,11),G1H2(34),ngZu,m3h4x2(:,39),heltab2x8(:,:,61))
  call Hloop_A_Q(ntryL,G1H2(34),23,nMT,G2H2(117),n2h2(139))
  call Hloop_AZ_Q(ntryL,G0H8(10),wf4(:,11),G0H2(1),ngZu,m3h4x2(:,40),heltab2x8(:,:,62))
  call Hloop_A_Q(ntryL,G0H2(1),23,nMT,G1H2(35),n2h2(140))
  call Hloop_QZ_A(ntryL,G1H8(51),wf4(:,11),G1H2(40),ngZd,m3h4x2(:,41),heltab2x8(:,:,63))
  call Hloop_Q_A(ntryL,G1H2(40),23,0,G2H2(118),n2h2(141))
call HGT_OLR(G1H8(52),1,1,8)
call HGT_invQ_OLR(G1H8(52),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(52),-8,0,G2H8(11),n2h8(39))
  call Hloop_AV_Q(ntryL,G2H8(11),ex4(:),G2H4(19),m3h2x4(:,23),heltab2x8(:,:,64))
  call Hloop_QZ_A(ntryL,G1H8(54),wf4(:,11),G1H2(45),ngZd,m3h4x2(:,42),heltab2x8(:,:,65))
  call Hloop_Q_A(ntryL,G1H2(45),23,0,G2H2(119),n2h2(142))
  call Hloop_QZ_A(ntryL,G1H8(55),wf4(:,11),G1H2(46),ngZd,m3h4x2(:,43),heltab2x8(:,:,66))
  call Hloop_Q_A(ntryL,G1H2(46),23,0,G2H2(120),n2h2(143))
  call Hloop_QZ_A(ntryL,G0H8(11),wf4(:,11),G0H2(1),ngZd,m3h4x2(:,44),heltab2x8(:,:,67))
  call Hloop_Q_A(ntryL,G0H2(1),23,0,G1H2(51),n2h2(144))
  call Hloop_QZ_A(ntryL,G1H8(56),wf4(:,11),G1H2(56),ngZd,m3h4x2(:,45),heltab2x8(:,:,68))
  call Hloop_Q_A(ntryL,G1H2(56),23,nMB,G2H2(121),n2h2(145))
call HGT_OLR(G1H8(57),1,1,8)
call HGT_invQ_OLR(G1H8(57),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(57),-8,nMB,G2H8(12),n2h8(40))
  call Hloop_AV_Q(ntryL,G2H8(12),ex4(:),G2H4(20),m3h2x4(:,24),heltab2x8(:,:,69))
  call Hloop_QZ_A(ntryL,G1H8(59),wf4(:,11),G1H2(57),ngZd,m3h4x2(:,46),heltab2x8(:,:,70))
  call Hloop_Q_A(ntryL,G1H2(57),23,nMB,G2H2(122),n2h2(146))
  call Hloop_QZ_A(ntryL,G1H8(60),wf4(:,11),G1H2(62),ngZd,m3h4x2(:,47),heltab2x8(:,:,71))
  call Hloop_Q_A(ntryL,G1H2(62),23,nMB,G2H2(123),n2h2(147))
  call Hloop_QZ_A(ntryL,G0H8(12),wf4(:,11),G0H2(1),ngZd,m3h4x2(:,48),heltab2x8(:,:,72))
  call Hloop_Q_A(ntryL,G0H2(1),23,nMB,G1H2(67),n2h2(148))
  call Hloop_AZ_Q(ntryL,G1H8(61),wf4(:,11),G1H2(68),ngZd,m3h4x2(:,49),heltab2x8(:,:,73))
  call Hloop_A_Q(ntryL,G1H2(68),23,0,G2H2(124),n2h2(149))
call HGT_OLR(G1H8(62),1,1,8)
call HGT_invQ_OLR(G1H8(62),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(62),-8,0,G2H8(13),n2h8(41))
  call Hloop_QV_A(ntryL,G2H8(13),ex4(:),G2H4(21),m3h2x4(:,25),heltab2x8(:,:,74))
  call Hloop_AZ_Q(ntryL,G1H8(64),wf4(:,11),G1H2(73),ngZd,m3h4x2(:,50),heltab2x8(:,:,75))
  call Hloop_A_Q(ntryL,G1H2(73),23,0,G2H2(125),n2h2(150))
  call Hloop_AZ_Q(ntryL,G1H8(65),wf4(:,11),G1H2(78),ngZd,m3h4x2(:,51),heltab2x8(:,:,76))
  call Hloop_A_Q(ntryL,G1H2(78),23,0,G2H2(126),n2h2(151))
  call Hloop_AZ_Q(ntryL,G0H8(13),wf4(:,11),G0H2(1),ngZd,m3h4x2(:,52),heltab2x8(:,:,77))
  call Hloop_A_Q(ntryL,G0H2(1),23,0,G1H2(79),n2h2(152))
  call Hloop_AZ_Q(ntryL,G1H8(66),wf4(:,11),G1H2(84),ngZd,m3h4x2(:,53),heltab2x8(:,:,78))
  call Hloop_A_Q(ntryL,G1H2(84),23,nMB,G2H2(127),n2h2(153))
call HGT_OLR(G1H8(67),1,1,8)
call HGT_invQ_OLR(G1H8(67),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(67),-8,nMB,G2H8(14),n2h8(42))
  call Hloop_QV_A(ntryL,G2H8(14),ex4(:),G2H4(22),m3h2x4(:,26),heltab2x8(:,:,79))
  call Hloop_AZ_Q(ntryL,G1H8(69),wf4(:,11),G1H2(89),ngZd,m3h4x2(:,54),heltab2x8(:,:,80))
  call Hloop_A_Q(ntryL,G1H2(89),23,nMB,G2H2(128),n2h2(154))
  call Hloop_AZ_Q(ntryL,G1H8(70),wf4(:,11),G1H2(90),ngZd,m3h4x2(:,55),heltab2x8(:,:,81))
  call Hloop_A_Q(ntryL,G1H2(90),23,nMB,G2H2(129),n2h2(155))
  call Hloop_AZ_Q(ntryL,G0H8(14),wf4(:,11),G0H2(1),ngZd,m3h4x2(:,56),heltab2x8(:,:,82))
  call Hloop_A_Q(ntryL,G0H2(1),23,nMB,G1H2(95),n2h2(156))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(124),[G2H2(112),G2H2(94),G2H2(11),G2H2(7),G2H2(3) &
    ,G1H2(27),G1H2(16),G1H2(5)])
call HGT_OLR(G2H3(1),1,1,3)
call HGT_invQ_OLR(G2H3(1),2,5,3)
call HGT_OLR(G2H3(1),6,15,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(1),[G2H3(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(40),[G2H2(14),G1H2(38)])
call HGT_OLR(G2H3(2),1,1,3)
call HGT_invQ_OLR(G2H3(2),2,5,3)
call HGT_OLR(G2H3(2),6,15,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(2),[G2H3(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(42),[G2H2(17),G1H2(49)])
call HGT_OLR(G2H3(3),1,1,3)
call HGT_invQ_OLR(G2H3(3),2,5,3)
call HGT_OLR(G2H3(3),6,15,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(3),[G2H3(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(43),[G2H2(51),G2H2(20),G1H2(137),G1H2(60)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(118),[G2H2(106),G2H2(88),G2H2(32),G2H2(28),G2H2(24) &
    ,G1H2(93),G1H2(82),G1H2(71)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(18),[G1H2(69)])
call HGT_OLR(G2H2(34),1,1,2)
call HGT_invQ_OLR(G2H2(34),2,5,2)
call HGT_OLR(G2H2(34),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(34),[G2H2(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(16),[G2H3(5),G1H3(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(21),[G1H2(80)])
call HGT_OLR(G2H2(35),1,1,2)
call HGT_invQ_OLR(G2H2(35),2,5,2)
call HGT_OLR(G2H2(35),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(35),[G2H2(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(18),[G2H3(8),G1H3(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(25),[G1H2(91)])
call HGT_OLR(G2H2(36),1,1,2)
call HGT_invQ_OLR(G2H2(36),2,5,2)
call HGT_OLR(G2H2(36),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(36),[G2H2(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(19),[G2H3(11),G1H3(27)])
call HGT_OLR(G2H3(13),1,1,3)
call HGT_invQ_OLR(G2H3(13),2,5,3)
call HGT_OLR(G2H3(13),6,15,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(13),[G2H3(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(45),[G2H2(38),G1H2(104)])
call HGT_OLR(G2H3(14),1,1,3)
call HGT_invQ_OLR(G2H3(14),2,5,3)
call HGT_OLR(G2H3(14),6,15,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(14),[G2H3(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(49),[G2H2(41),G1H2(115)])
call HGT_OLR(G2H3(15),1,1,3)
call HGT_invQ_OLR(G2H3(15),2,5,3)
call HGT_OLR(G2H3(15),6,15,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(15),[G2H3(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(52),[G2H2(55),G2H2(44),G1H2(148),G1H2(126)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(1),[G1H2(3)])
call HGT_OLR(G2H2(46),1,1,2)
call HGT_invQ_OLR(G2H2(46),2,5,2)
call HGT_OLR(G2H2(46),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(46),[G2H2(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(21),[G2H3(17),G1H3(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(5),[G1H2(14)])
call HGT_OLR(G2H2(47),1,1,2)
call HGT_invQ_OLR(G2H2(47),2,5,2)
call HGT_OLR(G2H2(47),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(47),[G2H2(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(22),[G2H3(20),G1H3(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(9),[G1H2(25)])
call HGT_OLR(G2H2(48),1,1,2)
call HGT_invQ_OLR(G2H2(48),2,5,2)
call HGT_OLR(G2H2(48),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(48),[G2H2(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(24),[G2H3(23),G1H3(60)])
call HGT_OLR(G2H2(54),1,1,2)
call HGT_invQ_OLR(G2H2(54),2,5,2)
call HGT_OLR(G2H2(54),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(54),[G2H2(53)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(4),[G1H2(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(126),[G2H2(114),G2H2(96),G1H2(33),G1H2(22),G1H2(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(8),[G1H2(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(12),[G1H2(147),G1H2(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(153),[G1H2(32)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(13),[G1H2(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(59),[G2H2(56),G1H2(59),G1H2(48),G1H2(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(61),[G2H2(58),G1H2(65),G1H2(54),G1H2(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(15),[G1H2(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(16),[G1H2(58)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(143),[G1H2(66)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(19),[G1H2(70)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(120),[G2H2(108),G2H2(90),G1H2(99),G1H2(88),G1H2(77)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(22),[G1H2(81)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(26),[G1H2(136),G1H2(92)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(142),[G1H2(98)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(4),[G1H3(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(33),[G1H3(15),G1H3(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(35),[G1H3(21),G1H3(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(6),[G1H3(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(7),[G1H3(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(36),[G1H3(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(38),[G1H3(32)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(29),[G1H2(102)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(67),[G2H2(64),G1H2(125),G1H2(114),G1H2(103)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(69),[G2H2(66),G1H2(131),G1H2(120),G1H2(109)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(30),[G1H2(113)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(33),[G1H2(124)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(154),[G1H2(132)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(9),[G1H3(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(41),[G1H3(48),G1H3(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(43),[G1H3(54),G1H3(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(10),[G1H3(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(12),[G1H3(58)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(44),[G1H3(59)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(46),[G1H3(65)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(37),[G1H2(135)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(39),[G1H2(146)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(52),[G1H2(41)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(74),[G1H2(63)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(51),[G1H2(2),G1H2(129)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(109),[G2H2(91)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(111),[G2H2(93)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(13),[G1H2(140)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(79),[G1H2(24),G1H2(151)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(115),[G2H2(97)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(117),[G2H2(99)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(35),[G1H2(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(121),[G2H2(100)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(123),[G2H2(102)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(67),[G1H2(83)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(127),[G2H2(103)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(129),[G2H2(105)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(95),[G1H2(127)])
call HGT_OLR(G2H2(2),1,1,2)
call HGT_invQ_OLR(G2H2(2),2,5,2)
call HGT_OLR(G2H2(2),6,15,2)
  call Hotf_4pt_reduction(G2H2(2),RedSet_4(32),mass4set(:,1),  & 
G1H2(100),G1H2(101),G1H2(106),G1H2(111),G1H2(112),2)
  call HG1shiftOLR(G1H2(101),2,2)
  call Hotf_4pt_reduction(G2H2(124),RedSet_4(9),mass4set(:,1),  & 
G1H2(117),G1H2(122),G1H2(123),G1H2(128),G1H2(133),2)
  call HG1shiftOLR(G1H2(122),8,2)
call HGT_OLR(G2H2(6),1,1,2)
call HGT_invQ_OLR(G2H2(6),2,5,2)
call HGT_OLR(G2H2(6),6,15,2)
  call Hotf_4pt_reduction(G2H2(6),RedSet_4(32),mass4set(:,2),  & 
G1H2(134),G1H2(139),G1H2(144),G1H2(145),G1H2(150),2)
  call HG1shiftOLR(G1H2(139),2,2)
call HGT_OLR(G2H2(10),1,1,2)
call HGT_invQ_OLR(G2H2(10),2,5,2)
call HGT_OLR(G2H2(10),6,15,2)
  call Hotf_4pt_reduction(G2H2(10),RedSet_4(32),mass4set(:,3),  & 
G1H2(6),G1H2(17),G1H2(28),G1H2(50),G1H2(61),2)
  call HG1shiftOLR(G1H2(17),2,2)
  call Hotf_4pt_reduction(G2H3(1),RedSet_4(33),mass4set(:,1),  & 
G1H3(40),G1H3(45),G1H3(46),G1H3(51),G1H3(56),3)
  call HG1shiftOLR(G1H3(45),4,3)
  call Hotf_4pt_reduction(G2H2(40),RedSet_4(13),mass4set(:,1),  & 
G1H2(72),G1H2(94),G1H2(105),G1H2(116),G1H2(138),2)
  call HG1shiftOLR(G1H2(94),8,2)
  call Hotf_4pt_reduction(G2H3(2),RedSet_4(33),mass4set(:,4),  & 
G1H3(57),G1H3(62),G1H3(6),G1H3(17),G1H3(28),3)
  call HG1shiftOLR(G1H3(62),4,3)
  call Hotf_4pt_reduction(G2H2(42),RedSet_4(13),mass4set(:,4),  & 
G1H2(149),G1H2(1),G1H2(7),G1H2(8),G1H2(12),2)
  call HG1shiftOLR(G1H2(1),8,2)
  call Hotf_4pt_reduction(G2H3(3),RedSet_4(33),mass4set(:,5),  & 
G1H3(50),G1H3(61),G1H3(1),G1H3(7),G1H3(8),3)
  call HG1shiftOLR(G1H3(61),4,3)
  call Hotf_4pt_reduction(G2H2(43),RedSet_4(13),mass4set(:,5),  & 
G1H2(18),G1H2(19),G1H2(23),G1H2(29),G1H2(30),2)
  call HG1shiftOLR(G1H2(19),8,2)
call HGT_OLR(G2H2(23),1,1,2)
call HGT_invQ_OLR(G2H2(23),2,5,2)
call HGT_OLR(G2H2(23),6,15,2)
  call Hotf_4pt_reduction(G2H2(23),RedSet_4(34),mass4set(:,1),  & 
G1H2(34),G1H2(40),G1H2(45),G1H2(46),G1H2(56),2)
  call HG1shiftOLR(G1H2(40),1,2)
  call Hotf_4pt_reduction(G2H2(118),RedSet_4(9),mass4set(:,1),  & 
G1H2(57),G1H2(62),G1H2(68),G1H2(73),G1H2(78),2)
  call HG1shiftOLR(G1H2(62),8,2)
call HGT_OLR(G2H2(27),1,1,2)
call HGT_invQ_OLR(G2H2(27),2,5,2)
call HGT_OLR(G2H2(27),6,15,2)
  call Hotf_4pt_reduction(G2H2(27),RedSet_4(34),mass4set(:,2),  & 
G1H2(84),G1H2(89),G1H2(90),G1H2(27),G1H2(16),2)
  call HG1shiftOLR(G1H2(89),1,2)
call HGT_OLR(G2H2(31),1,1,2)
call HGT_invQ_OLR(G2H2(31),2,5,2)
call HGT_OLR(G2H2(31),6,15,2)
  call Hotf_4pt_reduction(G2H2(31),RedSet_4(34),mass4set(:,3),  & 
G1H2(5),G1H2(38),G1H2(49),G1H2(137),G1H2(60),2)
  call HG1shiftOLR(G1H2(38),1,2)
  call Hotf_4pt_reduction(G2H2(34),RedSet_4(15),mass4set(:,1),  & 
G1H2(93),G1H2(82),G1H2(71),G1H2(69),G1H2(80),2)
  call HG1shiftOLR(G1H2(82),8,2)
  call Hotf_4pt_reduction(G2H3(16),RedSet_4(20),mass4set(:,1),  & 
G1H3(12),G1H3(18),G1H3(19),G1H3(23),G1H3(29),3)
  call HG1shiftOLR(G1H3(18),4,3)
  call Hotf_4pt_reduction(G2H2(35),RedSet_4(15),mass4set(:,4),  & 
G1H2(91),G1H2(104),G1H2(115),G1H2(148),G1H2(126),2)
  call HG1shiftOLR(G1H2(104),8,2)
  call Hotf_4pt_reduction(G2H3(18),RedSet_4(20),mass4set(:,4),  & 
G1H3(30),G1H3(34),G1H3(5),G1H3(16),G1H3(27),3)
  call HG1shiftOLR(G1H3(34),4,3)
  call Hotf_4pt_reduction(G2H2(36),RedSet_4(15),mass4set(:,5),  & 
G1H2(3),G1H2(14),G1H2(25),G1H2(4),G1H2(33),2)
  call HG1shiftOLR(G1H2(14),8,2)
  call Hotf_4pt_reduction(G2H3(19),RedSet_4(20),mass4set(:,5),  & 
G1H3(38),G1H3(49),G1H3(60),G1H3(3),G1H3(15),3)
  call HG1shiftOLR(G1H3(49),4,3)
  call Hotf_4pt_reduction(G2H3(13),RedSet_4(35),mass4set(:,1),  & 
G1H3(4),G1H3(21),G1H3(10),G1H3(14),G1H3(25),3)
  call HG1shiftOLR(G1H3(21),4,3)
  call Hotf_4pt_reduction(G2H2(45),RedSet_4(23),mass4set(:,1),  & 
G1H2(22),G1H2(11),G1H2(15),G1H2(147),G1H2(26),2)
  call HG1shiftOLR(G1H2(11),8,2)
  call Hotf_4pt_reduction(G2H3(14),RedSet_4(35),mass4set(:,4),  & 
G1H3(26),G1H3(32),G1H3(36),G1H3(48),G1H3(37),3)
  call HG1shiftOLR(G1H3(32),4,3)
  call Hotf_4pt_reduction(G2H2(49),RedSet_4(23),mass4set(:,4),  & 
G1H2(32),G1H2(36),G1H2(59),G1H2(48),G1H2(37),2)
  call HG1shiftOLR(G1H2(36),8,2)
  call Hotf_4pt_reduction(G2H3(15),RedSet_4(35),mass4set(:,5),  & 
G1H3(54),G1H3(43),G1H3(47),G1H3(58),G1H3(59),3)
  call HG1shiftOLR(G1H3(43),4,3)
  call Hotf_4pt_reduction(G2H2(52),RedSet_4(23),mass4set(:,5),  & 
G1H2(65),G1H2(54),G1H2(43),G1H2(47),G1H2(58),2)
  call HG1shiftOLR(G1H2(54),8,2)
  call Hotf_4pt_reduction(G2H2(46),RedSet_4(7),mass4set(:,1),  & 
G1H2(66),G1H2(70),G1H2(99),G1H2(88),G1H2(77),2)
  call HG1shiftOLR(G1H2(70),8,2)
  call Hotf_4pt_reduction(G2H3(21),RedSet_4(26),mass4set(:,1),  & 
G1H3(65),G1H3(67),G1H3(68),G1H3(69),G1H3(70),3)
  call HG1shiftOLR(G1H3(67),4,3)
  call Hotf_4pt_reduction(G2H2(47),RedSet_4(7),mass4set(:,4),  & 
G1H2(81),G1H2(136),G1H2(92),G1H2(98),G1H2(102),2)
  call HG1shiftOLR(G1H2(136),8,2)
  call Hotf_4pt_reduction(G2H3(22),RedSet_4(26),mass4set(:,4),  & 
G1H3(71),G1H3(72),G1H3(73),G1H3(74),G1H3(75),3)
  call HG1shiftOLR(G1H3(72),4,3)
  call Hotf_4pt_reduction(G2H2(48),RedSet_4(7),mass4set(:,5),  & 
G1H2(125),G1H2(114),G1H2(103),G1H2(131),G1H2(120),2)
  call HG1shiftOLR(G1H2(114),8,2)
  call Hotf_4pt_reduction(G2H3(24),RedSet_4(26),mass4set(:,5),  & 
G1H3(76),G1H3(77),G1H3(78),G1H3(79),G1H3(80),3)
  call HG1shiftOLR(G1H3(77),4,3)
call HGT_OLR(G2H2(50),1,1,2)
call HGT_invQ_OLR(G2H2(50),2,5,2)
call HGT_OLR(G2H2(50),6,15,2)
  call Hotf_4pt_reduction(G2H2(50),RedSet_4(36),mass4set(:,6),  & 
G1H2(109),G1H2(113),G1H2(124),G1H2(132),G1H2(135),2)
  call HG1shiftOLR(G1H2(113),1,2)
  call Hotf_4pt_reduction(G2H2(54),RedSet_4(37),mass4set(:,6),  & 
G1H2(146),G1H2(41),G1H2(63),G1H2(2),G1H2(129),2)
  call HG1shiftOLR(G1H2(41),2,2)
  call Hotf_4pt_reduction(G2H2(4),RedSet_4(8),mass4set(:,1),  & 
G1H2(140),G1H2(24),G1H2(151),G1H2(39),G1H2(83),2)
  call HG1shiftOLR(G1H2(24),8,2)
  call Hloop_AV_Q(ntryL,G1H2(9),ex4(:),G1H1(1),m3h2x1(:,57),heltab2x2(:,:,57))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(1),n2h1(81))
  call Hloop_AV_Q(ntryL,G1H2(10),ex4(:),G1H1(1),m3h2x1(:,58),heltab2x2(:,:,58))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(5),n2h1(82))
  call Hloop_AV_Q(ntryL,G2H2(126),ex4(:),G2H1(1),m3h2x1(:,59),heltab2x2(:,:,59))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(1),n2h1(83))
  call Hotf_4pt_reduction(G2H2(8),RedSet_4(8),mass4set(:,4),  & 
G1H2(127),G1H2(9),G1H2(10),G1H2(155),G1H2(156),2)
  call HG1shiftOLR(G1H2(9),8,2)
  call Hloop_AV_Q(ntryL,G1H2(20),ex4(:),G1H1(1),m3h2x1(:,60),heltab2x2(:,:,60))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(9),n2h1(84))
  call Hloop_AV_Q(ntryL,G1H2(21),ex4(:),G1H1(1),m3h2x1(:,61),heltab2x2(:,:,61))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(13),n2h1(85))
  call Hotf_4pt_reduction(G2H2(12),RedSet_4(8),mass4set(:,5),  & 
G1H2(20),G1H2(21),G1H2(157),G1H2(158),G1H2(159),2)
  call HG1shiftOLR(G1H2(21),8,2)
  call Hloop_AV_Q(ntryL,G1H2(31),ex4(:),G1H1(1),m3h2x1(:,62),heltab2x2(:,:,62))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(17),n2h1(86))
  call Hloop_AV_Q(ntryL,G1H2(153),ex4(:),G1H1(1),m3h2x1(:,63),heltab2x2(:,:,63))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(21),n2h1(87))
  call Hotf_4pt_reduction(G2H2(13),RedSet_4(11),mass4set(:,1),  & 
G1H2(31),G1H2(153),G1H2(160),G1H2(161),G1H2(162),2)
  call HG1shiftOLR(G1H2(153),8,2)
  call Hotf_4pt_reduction(G2H2(59),RedSet_4(12),mass4set(:,1),  & 
G1H2(163),G1H2(164),G1H2(165),G1H2(166),G1H2(167),2)
  call HG1shiftOLR(G1H2(164),8,2)
  call Hloop_QV_A(ntryL,G1H2(42),ex4(:),G1H1(1),m3h2x1(:,64),heltab2x2(:,:,64))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(25),n2h1(88))
  call Hloop_QV_A(ntryL,G2H2(61),ex4(:),G2H1(1),m3h2x1(:,65),heltab2x2(:,:,65))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(2),n2h1(89))
  call Hloop_QV_A(ntryL,G1H2(44),ex4(:),G1H1(1),m3h2x1(:,66),heltab2x2(:,:,66))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(29),n2h1(90))
  call Hotf_4pt_reduction(G2H2(15),RedSet_4(11),mass4set(:,9),  & 
G1H2(42),G1H2(44),G1H2(168),G1H2(169),G1H2(170),2)
  call HG1shiftOLR(G1H2(44),8,2)
  call Hloop_QV_A(ntryL,G1H2(53),ex4(:),G1H1(1),m3h2x1(:,67),heltab2x2(:,:,67))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(33),n2h1(91))
  call Hloop_QV_A(ntryL,G1H2(55),ex4(:),G1H1(1),m3h2x1(:,68),heltab2x2(:,:,68))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(37),n2h1(92))
  call Hotf_4pt_reduction(G2H2(16),RedSet_4(11),mass4set(:,10),  & 
G1H2(53),G1H2(55),G1H2(171),G1H2(172),G1H2(173),2)
  call HG1shiftOLR(G1H2(55),8,2)
  call Hloop_QV_A(ntryL,G1H2(64),ex4(:),G1H1(1),m3h2x1(:,69),heltab2x2(:,:,69))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(41),n2h1(93))
  call Hloop_QV_A(ntryL,G1H2(143),ex4(:),G1H1(1),m3h2x1(:,70),heltab2x2(:,:,70))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(45),n2h1(94))
  call Hotf_4pt_reduction(G2H2(19),RedSet_4(16),mass4set(:,1),  & 
G1H2(64),G1H2(143),G1H2(174),G1H2(175),G1H2(176),2)
  call HG1shiftOLR(G1H2(143),8,2)
  call Hloop_QV_A(ntryL,G1H2(75),ex4(:),G1H1(1),m3h2x1(:,71),heltab2x2(:,:,71))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(49),n2h1(95))
  call Hloop_QV_A(ntryL,G1H2(76),ex4(:),G1H1(1),m3h2x1(:,72),heltab2x2(:,:,72))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(53),n2h1(96))
  call Hloop_QV_A(ntryL,G2H2(120),ex4(:),G2H1(1),m3h2x1(:,73),heltab2x2(:,:,73))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(3),n2h1(97))
  call Hotf_4pt_reduction(G2H2(22),RedSet_4(16),mass4set(:,4),  & 
G1H2(75),G1H2(76),G1H2(177),G1H2(178),G1H2(179),2)
  call HG1shiftOLR(G1H2(76),8,2)
  call Hloop_QV_A(ntryL,G1H2(86),ex4(:),G1H1(1),m3h2x1(:,74),heltab2x2(:,:,74))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(57),n2h1(98))
  call Hloop_QV_A(ntryL,G1H2(87),ex4(:),G1H1(1),m3h2x1(:,75),heltab2x2(:,:,75))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(61),n2h1(99))
  call Hotf_4pt_reduction(G2H2(26),RedSet_4(16),mass4set(:,5),  & 
G1H2(86),G1H2(87),G1H2(180),G1H2(181),G1H2(182),2)
  call HG1shiftOLR(G1H2(87),8,2)
  call Hloop_QV_A(ntryL,G1H2(97),ex4(:),G1H1(1),m3h2x1(:,76),heltab2x2(:,:,76))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(65),n2h1(100))
  call Hloop_QV_A(ntryL,G1H2(142),ex4(:),G1H1(1),m3h2x1(:,77),heltab2x2(:,:,77))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(69),n2h1(101))
  call Hotf_4pt_reduction(G2H3(4),RedSet_4(18),mass4set(:,1),  & 
G1H3(81),G1H3(82),G1H3(83),G1H3(84),G1H3(85),3)
  call HG1shiftOLR(G1H3(82),4,3)
  call Hotf_4pt_reduction(G2H3(33),RedSet_4(19),mass4set(:,1),  & 
G1H3(86),G1H3(87),G1H3(88),G1H3(89),G1H3(90),3)
  call HG1shiftOLR(G1H3(87),4,3)
  call Hloop_QZ_A(ntryL,G1H3(9),ex3(:),G1H1(1),ngZu,m3h3x1(:,25),heltab2x3(:,:,25))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(73),n2h1(102))
  call Hloop_QZ_A(ntryL,G2H3(35),ex3(:),G2H1(1),ngZu,m3h3x1(:,26),heltab2x3(:,:,26))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(4),n2h1(103))
  call Hloop_QZ_A(ntryL,G1H3(11),ex3(:),G1H1(1),ngZu,m3h3x1(:,27),heltab2x3(:,:,27))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(77),n2h1(104))
  call Hotf_4pt_reduction(G2H3(6),RedSet_4(18),mass4set(:,9),  & 
G1H3(9),G1H3(11),G1H3(91),G1H3(92),G1H3(93),3)
  call HG1shiftOLR(G1H3(11),4,3)
  call Hloop_QZ_A(ntryL,G1H3(20),ex3(:),G1H1(1),ngZu,m3h3x1(:,28),heltab2x3(:,:,28))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(81),n2h1(105))
  call Hloop_QZ_A(ntryL,G1H3(22),ex3(:),G1H1(1),ngZu,m3h3x1(:,29),heltab2x3(:,:,29))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(82),n2h1(106))
  call Hotf_4pt_reduction(G2H3(7),RedSet_4(18),mass4set(:,10),  & 
G1H3(20),G1H3(22),G1H3(94),G1H3(95),G1H3(96),3)
  call HG1shiftOLR(G1H3(22),4,3)
  call Hotf_4pt_reduction(G2H3(36),RedSet_4(19),mass4set(:,1),  & 
G1H3(97),G1H3(98),G1H3(99),G1H3(100),G1H3(101),3)
  call HG1shiftOLR(G1H3(98),4,3)
  call Hloop_QZ_A(ntryL,G1H3(31),ex3(:),G1H1(1),ngZd,m3h3x1(:,30),heltab2x3(:,:,30))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(83),n2h1(107))
  call Hloop_QZ_A(ntryL,G2H3(38),ex3(:),G2H1(1),ngZd,m3h3x1(:,31),heltab2x3(:,:,31))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(5),n2h1(108))
  call Hloop_QZ_A(ntryL,G1H3(33),ex3(:),G1H1(1),ngZd,m3h3x1(:,32),heltab2x3(:,:,32))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(84),n2h1(109))
  call Hotf_4pt_reduction(G2H2(29),RedSet_4(22),mass4set(:,1),  & 
G1H2(97),G1H2(142),G1H2(183),G1H2(184),G1H2(185),2)
  call HG1shiftOLR(G1H2(142),8,2)
  call Hotf_4pt_reduction(G2H2(67),RedSet_4(12),mass4set(:,1),  & 
G1H2(186),G1H2(187),G1H2(188),G1H2(189),G1H2(190),2)
  call HG1shiftOLR(G1H2(187),8,2)
  call Hloop_AV_Q(ntryL,G1H2(108),ex4(:),G1H1(1),m3h2x1(:,78),heltab2x2(:,:,78))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(85),n2h1(110))
  call Hloop_AV_Q(ntryL,G2H2(69),ex4(:),G2H1(1),m3h2x1(:,79),heltab2x2(:,:,79))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(6),n2h1(111))
  call Hloop_AV_Q(ntryL,G1H2(110),ex4(:),G1H1(1),m3h2x1(:,80),heltab2x2(:,:,80))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(86),n2h1(112))
  call Hotf_4pt_reduction(G2H2(30),RedSet_4(22),mass4set(:,9),  & 
G1H2(108),G1H2(110),G1H2(191),G1H2(192),G1H2(193),2)
  call HG1shiftOLR(G1H2(110),8,2)
  call Hloop_AV_Q(ntryL,G1H2(119),ex4(:),G1H1(1),m3h2x1(:,81),heltab2x2(:,:,81))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(87),n2h1(113))
  call Hloop_AV_Q(ntryL,G1H2(121),ex4(:),G1H1(1),m3h2x1(:,82),heltab2x2(:,:,82))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(88),n2h1(114))
  call Hotf_4pt_reduction(G2H2(33),RedSet_4(22),mass4set(:,10),  & 
G1H2(119),G1H2(121),G1H2(194),G1H2(195),G1H2(196),2)
  call HG1shiftOLR(G1H2(121),8,2)
  call Hloop_AV_Q(ntryL,G1H2(130),ex4(:),G1H1(1),m3h2x1(:,83),heltab2x2(:,:,83))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(89),n2h1(115))
  call Hloop_AV_Q(ntryL,G1H2(154),ex4(:),G1H1(1),m3h2x1(:,84),heltab2x2(:,:,84))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(90),n2h1(116))
  call Hotf_4pt_reduction(G2H3(9),RedSet_4(25),mass4set(:,1),  & 
G1H3(31),G1H3(33),G1H3(102),G1H3(103),G1H3(104),3)
  call HG1shiftOLR(G1H3(33),4,3)
  call Hotf_4pt_reduction(G2H3(41),RedSet_4(19),mass4set(:,1),  & 
G1H3(105),G1H3(106),G1H3(107),G1H3(108),G1H3(109),3)
  call HG1shiftOLR(G1H3(106),4,3)
  call Hloop_AZ_Q(ntryL,G1H3(42),ex3(:),G1H1(1),ngZu,m3h3x1(:,33),heltab2x3(:,:,33))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(91),n2h1(117))
  call Hloop_AZ_Q(ntryL,G2H3(43),ex3(:),G2H1(1),ngZu,m3h3x1(:,34),heltab2x3(:,:,34))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(7),n2h1(118))
  call Hloop_AZ_Q(ntryL,G1H3(44),ex3(:),G1H1(1),ngZu,m3h3x1(:,35),heltab2x3(:,:,35))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(92),n2h1(119))
  call Hotf_4pt_reduction(G2H3(10),RedSet_4(25),mass4set(:,9),  & 
G1H3(42),G1H3(44),G1H3(110),G1H3(111),G1H3(112),3)
  call HG1shiftOLR(G1H3(44),4,3)
  call Hloop_AZ_Q(ntryL,G1H3(53),ex3(:),G1H1(1),ngZu,m3h3x1(:,36),heltab2x3(:,:,36))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(93),n2h1(120))
  call Hloop_AZ_Q(ntryL,G1H3(55),ex3(:),G1H1(1),ngZu,m3h3x1(:,37),heltab2x3(:,:,37))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(94),n2h1(121))
  call Hotf_4pt_reduction(G2H3(12),RedSet_4(25),mass4set(:,10),  & 
G1H3(53),G1H3(55),G1H3(113),G1H3(114),G1H3(115),3)
  call HG1shiftOLR(G1H3(55),4,3)
  call Hotf_4pt_reduction(G2H3(44),RedSet_4(19),mass4set(:,1),  & 
G1H3(116),G1H3(117),G1H3(118),G1H3(119),G1H3(120),3)
  call HG1shiftOLR(G1H3(117),4,3)
  call Hloop_AZ_Q(ntryL,G1H3(64),ex3(:),G1H1(1),ngZd,m3h3x1(:,38),heltab2x3(:,:,38))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(95),n2h1(122))
  call Hloop_AZ_Q(ntryL,G2H3(46),ex3(:),G2H1(1),ngZd,m3h3x1(:,39),heltab2x3(:,:,39))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(8),n2h1(123))
  call Hloop_AZ_Q(ntryL,G1H3(66),ex3(:),G1H1(1),ngZd,m3h3x1(:,40),heltab2x3(:,:,40))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(96),n2h1(124))
  call Hotf_4pt_reduction(G2H2(37),RedSet_4(28),mass4set(:,11),  & 
G1H2(130),G1H2(154),G1H2(197),G1H2(198),G1H2(199),2)
  call HG1shiftOLR(G1H2(154),8,2)
  call Hloop_QV_A(ntryL,G1H2(141),ex4(:),G1H1(1),m3h2x1(:,85),heltab2x2(:,:,85))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(97),n2h1(125))
  call Hotf_4pt_reduction(G2H2(39),RedSet_4(30),mass4set(:,11),  & 
G1H2(141),G1H2(200),G1H2(201),G1H2(202),G1H2(203),2)
  call HG1shiftOLR(G1H2(200),8,2)
  call Hloop_AV_Q(ntryL,G1H2(152),ex4(:),G1H1(1),m3h2x1(:,86),heltab2x2(:,:,86))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(98),n2h1(126))
  call Hotf_4pt_reduction(G2H4(1),RedSet_4(5),mass4set(:,6),  & 
G1H4(13),G1H4(14),G1H4(17),G1H4(18),G1H4(19),4)
  call HG1shiftOLR(G1H4(14),9,4)
  call Hotf_4pt_reduction(G2H4(2),RedSet_4(3),mass4set(:,1),  & 
G1H4(20),G1H4(23),G1H4(24),G1H4(25),G1H4(26),4)
  call HG1shiftOLR(G1H4(23),9,4)
  call Hotf_4pt_reduction(G2H4(3),RedSet_4(3),mass4set(:,2),  & 
G1H4(29),G1H4(30),G1H4(31),G1H4(32),G1H4(35),4)
  call HG1shiftOLR(G1H4(30),9,4)
  call Hotf_4pt_reduction(G2H4(4),RedSet_4(3),mass4set(:,3),  & 
G1H4(36),G1H4(37),G1H4(38),G1H4(41),G1H4(42),4)
  call HG1shiftOLR(G1H4(37),9,4)
  call Hotf_4pt_reduction(G2H4(5),RedSet_4(6),mass4set(:,6),  & 
G1H4(43),G1H4(44),G1H4(47),G1H4(48),G1H4(4),4)
  call HG1shiftOLR(G1H4(44),10,4)
  call Hotf_4pt_reduction(G2H4(6),RedSet_4(1),mass4set(:,1),  & 
G1H4(10),G1H4(46),G1H4(16),G1H4(22),G1H4(28),4)
  call HG1shiftOLR(G1H4(46),10,4)
  call Hotf_4pt_reduction(G2H4(7),RedSet_4(1),mass4set(:,2),  & 
G1H4(40),G1H4(34),G1H4(39),G1H4(45),G1H4(3),4)
  call HG1shiftOLR(G1H4(34),10,4)
  call Hotf_4pt_reduction(G2H4(8),RedSet_4(1),mass4set(:,3),  & 
G1H4(1),G1H4(9),G1H4(2),G1H4(15),G1H4(5),4)
  call HG1shiftOLR(G1H4(9),10,4)
  call Hloop_QV_A(ntryL,G1H2(52),ex4(:),G1H1(1),m3h2x1(:,87),heltab2x2(:,:,87))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(99),n2h1(127))
  call Hloop_QZ_A(ntryL,G1H3(41),ex3(:),G1H1(1),ngZu,m3h3x1(:,41),heltab2x3(:,:,41))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(100),n2h1(128))
  call Hloop_QZ_A(ntryL,G1H3(52),ex3(:),G1H1(1),ngZd,m3h3x1(:,42),heltab2x3(:,:,42))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(101),n2h1(129))
  call Hloop_AV_Q(ntryL,G1H2(74),ex4(:),G1H1(1),m3h2x1(:,88),heltab2x2(:,:,88))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(102),n2h1(130))
  call Hloop_AZ_Q(ntryL,G1H3(63),ex3(:),G1H1(1),ngZu,m3h3x1(:,43),heltab2x3(:,:,43))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(103),n2h1(131))
  call Hloop_AZ_Q(ntryL,G1H3(39),ex3(:),G1H1(1),ngZd,m3h3x1(:,44),heltab2x3(:,:,44))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(104),n2h1(132))
  call Hotf_4pt_reduction(G2H3(47),RedSet_4(19),mass4set(:,7),  & 
G1H3(64),G1H3(66),G1H3(41),G1H3(52),G1H3(63),3)
  call HG1shiftOLR(G1H3(66),4,3)
  call Hloop_QZ_A(ntryL,G2H3(49),ex3(:),G2H1(1),ngZu,m3h3x1(:,45),heltab2x3(:,:,45))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(9),n2h1(133))
  call Hloop_QZ_A(ntryL,G1H3(2),ex3(:),G1H1(1),ngZu,m3h3x1(:,46),heltab2x3(:,:,46))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(105),n2h1(134))
  call Hotf_4pt_reduction(G2H3(50),RedSet_4(19),mass4set(:,7),  & 
G1H3(39),G1H3(2),G1H3(121),G1H3(122),G1H3(123),3)
  call HG1shiftOLR(G1H3(2),4,3)
  call Hloop_AZ_Q(ntryL,G2H3(52),ex3(:),G2H1(1),ngZu,m3h3x1(:,47),heltab2x3(:,:,47))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(10),n2h1(135))
  call Hloop_AZ_Q(ntryL,G1H3(13),ex3(:),G1H1(1),ngZu,m3h3x1(:,48),heltab2x3(:,:,48))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(106),n2h1(136))
  call Hotf_4pt_reduction(G2H3(53),RedSet_4(19),mass4set(:,8),  & 
G1H3(13),G1H3(124),G1H3(125),G1H3(126),G1H3(127),3)
  call HG1shiftOLR(G1H3(124),4,3)
  call Hloop_QZ_A(ntryL,G2H3(55),ex3(:),G2H1(1),ngZd,m3h3x1(:,49),heltab2x3(:,:,49))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(11),n2h1(137))
  call Hloop_QZ_A(ntryL,G1H3(24),ex3(:),G1H1(1),ngZd,m3h3x1(:,50),heltab2x3(:,:,50))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(107),n2h1(138))
  call Hotf_4pt_reduction(G2H3(56),RedSet_4(19),mass4set(:,8),  & 
G1H3(24),G1H3(128),G1H3(129),G1H3(130),G1H3(131),3)
  call HG1shiftOLR(G1H3(128),4,3)
  call Hloop_AZ_Q(ntryL,G2H3(58),ex3(:),G2H1(1),ngZd,m3h3x1(:,51),heltab2x3(:,:,51))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(12),n2h1(139))
  call Hloop_AZ_Q(ntryL,G1H3(35),ex3(:),G1H1(1),ngZd,m3h3x1(:,52),heltab2x3(:,:,52))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(108),n2h1(140))
  call Hotf_4pt_reduction(G2H2(76),RedSet_4(12),mass4set(:,7),  & 
G1H2(152),G1H2(52),G1H2(74),G1H2(204),G1H2(205),2)
  call HG1shiftOLR(G1H2(52),8,2)
  call Hloop_AV_Q(ntryL,G2H2(78),ex4(:),G2H1(1),m3h2x1(:,89),heltab2x2(:,:,89))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(13),n2h1(141))
  call Hloop_AV_Q(ntryL,G1H2(85),ex4(:),G1H1(1),m3h2x1(:,90),heltab2x2(:,:,90))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(109),n2h1(142))
  call Hotf_4pt_reduction(G2H2(79),RedSet_4(12),mass4set(:,7),  & 
G1H2(85),G1H2(206),G1H2(207),G1H2(208),G1H2(209),2)
  call HG1shiftOLR(G1H2(206),8,2)
  call Hloop_QV_A(ntryL,G2H2(81),ex4(:),G2H1(1),m3h2x1(:,91),heltab2x2(:,:,91))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(14),n2h1(143))
  call Hloop_QV_A(ntryL,G1H2(96),ex4(:),G1H1(1),m3h2x1(:,92),heltab2x2(:,:,92))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(110),n2h1(144))



end subroutine vamp_1

end module ol_vamp_1_ppzjj_ew_uuxzgg_1_/**/REALKIND
