
module ol_colourmatrix_ppzjj_ew_uuuxuxz_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  logical, save           :: colmat_not_initialised = .true.
  complex(REALKIND), save :: K1(68,4), K2(4,4), KL(4,4), Cas(5) = 0
  contains
  subroutine colourmatrix_init
    use ol_parameters_decl_/**/REALKIND, only: CI
    implicit none
    integer :: k, co
    colmat_not_initialised = .false.
    ! colour matrix

  K1( 1,:) = [   0,   0,   0,   0]
  K1( 2,:) = [   0,   9,   0,   3]
  K1( 3,:) = [   0,   0,   0,   0]
  K1( 4,:) = [   0,   3,   0,   9]
  K1( 5,:) = [   0,  12,   0,   4]
  K1( 6,:) = [  12,   0,   4,   0]
  K1( 7,:) = [   0,   4,   0,  12]
  K1( 8,:) = [   4,   0,  12,   0]
  K1( 9,:) = [   0,   0,   0,   4]
  K1(10,:) = [   0,   0,   4,   0]
  K1(11,:) = [   0,   4,   0,   0]
  K1(12,:) = [   4,   0,   0,   0]
  K1(13,:) = [   0,  12,   0,   4]
  K1(14,:) = [  12,   0,   4,   0]
  K1(15,:) = [   0,   4,   0,  12]
  K1(16,:) = [   4,   0,  12,   0]
  K1(17,:) = [   0,   0,   0,  -4]
  K1(18,:) = [   0,   0,  -4,   0]
  K1(19,:) = [   0,  -4,   0, -12]
  K1(20,:) = [  -4,   0, -12,   0]
  K1(21,:) = [   0, -12,   0,  -4]
  K1(22,:) = [ -12,   0,  -4,   0]
  K1(23,:) = [   0,  -4,   0,   0]
  K1(24,:) = [  -4,   0,   0,   0]
  K1(25,:) = [   0,  12,   0,   4]
  K1(26,:) = [  12,   0,   4,   0]
  K1(27,:) = [   0,   4,   0,  12]
  K1(28,:) = [   4,   0,  12,   0]
  K1(29,:) = [   0, -12,   0,  -4]
  K1(30,:) = [ -12,   0,  -4,   0]
  K1(31,:) = [   0,  -4,   0,   0]
  K1(32,:) = [  -4,   0,   0,   0]
  K1(33,:) = [   0,   0,   0,  -4]
  K1(34,:) = [   0,   0,  -4,   0]
  K1(35,:) = [   0,  -4,   0, -12]
  K1(36,:) = [  -4,   0, -12,   0]
  K1(37,:) = [   0,   0,   0,   4]
  K1(38,:) = [   0,   0,   4,   0]
  K1(39,:) = [   0,   4,   0,   0]
  K1(40,:) = [   4,   0,   0,   0]
  K1(41,:) = [   0,  12,   0,   4]
  K1(42,:) = [  12,   0,   4,   0]
  K1(43,:) = [   0,   4,   0,  12]
  K1(44,:) = [   4,   0,  12,   0]
  K1(45,:) = [   0,   0,   0,   0]
  K1(46,:) = [   0,   0,   0,   0]
  K1(47,:) = [   0,   0,   0,   0]
  K1(48,:) = [   0,   0,   0,   0]
  K1(49,:) = [   0,   0,   0,   0]
  K1(50,:) = [   0,   0,   0,   0]
  K1(51,:) = [   0,   0,   0,   0]
  K1(52,:) = [   0,   0,   0,   0]
  K1(53,:) = [   0,   0,   0,   0]
  K1(54,:) = [   0,   0,   0,   0]
  K1(55,:) = [   0,   0,   0,   0]
  K1(56,:) = [   0,   0,   0,   0]
  K1(57,:) = [   0,   0,   0,   0]
  K1(58,:) = [   0,   0,   0,   0]
  K1(59,:) = [   0,   0,   0,   0]
  K1(60,:) = [   0,   0,   0,   0]
  K1(61,:) = [   0,   0,   0,   0]
  K1(62,:) = [   0,   0,   0,   0]
  K1(63,:) = [   0,   0,   0,   0]
  K1(64,:) = [   0,   0,   0,   0]
  K1(65,:) = [   0,   0,   0,   0]
  K1(66,:) = [   0,   9,   0,   3]
  K1(67,:) = [   0,   0,   0,   0]
  K1(68,:) = [   0,   3,   0,   9]

  K2(1,:) = [ 9, 0, 3, 0]
  K2(2,:) = [ 0, 9, 0, 3]
  K2(3,:) = [ 3, 0, 9, 0]
  K2(4,:) = [ 0, 3, 0, 9]

  KL(1,:) = [ 0, 9, 0, 3]
  KL(2,:) = [ 9, 0, 3, 0]
  KL(3,:) = [ 0, 3, 0, 9]
  KL(4,:) = [ 3, 0, 9, 0]

#if 1 > 0
    co = 0
    do k = 1, 5
      co = co + k
      Cas(k) = K1(1+4*co,1)/K1(1,1)
    end do
#endif
  end subroutine colourmatrix_init
end module ol_colourmatrix_ppzjj_ew_uuuxuxz_1_/**/REALKIND



module ol_forced_parameters_ppzjj_ew_uuuxuxz_1_/**/REALKIND
  implicit none
  contains
  subroutine check_forced_parameters
    use ol_parameters_decl_/**/REALKIND
    use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
    use ol_loop_parameters_decl_/**/DREALKIND, only: LeadingColour, nc, nf, CKMORDER
#endif
    implicit none
    logical, save :: checks_not_written = .true.

    if (checks_not_written) then
    ! e.g.
    ! if (ME /= 0) write(*,101) 'ME = 0'
  if (ME /= 0) write(*,101) 'ME = 0'
  if (CKMORDER /= 0) write(*,101) 'CKMORDER = 0'
  if (nc /= 3) write(*,101) 'nc = 3'
  if (nf /= 6) write(*,101) 'nf = 6'
  if (MU /= 0) write(*,101) 'MU = 0'
  if (MD /= 0) write(*,101) 'MD = 0'
  if (MS /= 0) write(*,101) 'MS = 0'
  if (MC /= 0) write(*,101) 'MC = 0'
  if (LeadingColour /= 0) write(*,101) 'LeadingColour = 0'
  if (wMZ /= 0) write(*,101) 'wMZ = 0'


    checks_not_written = .false.
    end if

    101 format('[OpenLoops] === WARNING ===',/,'[OpenLoops] code was generated with ',A,/,'[OpenLoops] ===============')
  end subroutine check_forced_parameters
end module ol_forced_parameters_ppzjj_ew_uuuxuxz_1_/**/REALKIND


! **********************************************************************
module ol_loop_storage_ppzjj_ew_uuuxuxz_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, intkind1, intkind2
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont

#ifdef PRECISION_dp
  integer(intkind1), save :: ntryL = 1
  integer(intkind1), save :: p_switch = 0 ! switch for dp or qp. Used for memory allocation of the OL types
  ! the following are flags for memory allocation of the hol coefficients in dp or qp
  logical, save :: dp_not_alloc = .TRUE., qp_not_alloc = .TRUE.
  integer, save :: n_merge_steps  ! total number of merging steps
  integer, save :: n_merge_mism   ! number of merging mismatches
  integer, save :: merge_step = 1 ! current merging step
  integer(intkind2), save, allocatable :: merge_tables(:,:,:) ! merging tables
  integer(intkind2), save, allocatable :: merge_mism(:)       ! array of merging mismatches
  integer(intkind2), save, allocatable :: merge_hels(:)       ! array with relevant helicities for a merging step
  logical, save :: merge_tables_on = .false.
  integer(intkind2), parameter :: nheltot = 48 ! number of helicity configurations
  integer(intkind2), save :: nhel = 48 ! number of non-vanishing helicity configurations (adapted at runtime)
  integer(intkind2), save :: Hel(48) ! physical helicity states
#endif

  complex(REALKIND), save :: den(98)

  ! external wave functions ex1(h1),... for h<n> helicities
  type(wfun) :: ex1(2), ex2(2), ex3(2), ex4(2), ex5(3)

  ! wf<h>(h,n) n wave functions with h helicity configurations
  type(wfun) :: wf4(4,24), wf6(6,32), wf8(8,68), wf12(12,30), wf48(48,162)

  ! diagram prefactors
  integer,           save :: fac_status_loop1 = -1, fac_status_loop2 = -1
  complex(REALKIND), save :: f(20), c(27)

  !Vector in helicity and colour space for Born-Loop interference
  type(Hpolcont),   save :: M0_col1_helarray(4,48), M0M1_hel_cc(4,48,16)
  complex(REALKIND), save :: M2ctcc(16)

end module ol_loop_storage_ppzjj_ew_uuuxuxz_1_/**/REALKIND






! **********************************************************************
module ol_loop_ppzjj_ew_uuuxuxz_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, DREALKIND, intkind1, intkind2
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont
  use ol_loop_storage_ppzjj_ew_uuuxuxz_1_/**/REALKIND
  implicit none

!*********************************************************************************
  contains

! **********************************************************************
subroutine fac_init_loop()
! Writes diagram prefactors to 'f', rsp. 'c'
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND
  use ol_init, only: set_parameter, tree_parameters_flush, parameters_flush
#ifndef PRECISION_dp
  use ol_loop_parameters_decl_/**/DREALKIND, only: SwF, SwB
!  use ol_loop_parameters_decl_/**/DREALKIND, only: DOI
#endif
  implicit none
  call set_parameter("ew_renorm", 1)
  if (parameters_status == 0) call tree_parameters_flush()
  if (loop_parameters_status == 0) call parameters_flush()
  fac_status_loop1 = parameters_status
  fac_status_loop2 = loop_parameters_status
  ! factors of the diagrams
    f( 1) = (4*CI*eQED**3)/9._/**/REALKIND
    f( 2) = CI*eQED**3
    f( 3) = CI*eQED*gQCD**2
    f( 4) = (4*CI*countertermnorm*eQED**3*gQCD**2)/9._/**/REALKIND
    f( 5) = CI*countertermnorm*eQED**3*gQCD**2
    f( 6) = (4*CI*countertermnorm*ctVqq*eQED**3*gQCD**2)/9._/**/REALKIND
    f( 7) = CI*countertermnorm*ctVqq*eQED**3*gQCD**2
    f( 8) = CI*countertermnorm*eQED*gQCD**4
    f( 9) = CI*countertermnorm*ctGqq*eQED*gQCD**4
    f(10) = CI*countertermnorm*ctVqq*eQED*gQCD**4
    f(11) = countertermnorm*ctZGG*eQED*gQCD**4
    f(12) = (4*eQED**3*gQCD**2*integralnorm*SwB)/9._/**/REALKIND
    f(13) = eQED**3*gQCD**2*integralnorm*SwB
    f(14) = CI*eQED*gQCD**4*integralnorm*SwB
    f(15) = (eQED*gQCD**4*integralnorm*SwB)/2._/**/REALKIND
    f(16) = eQED*gQCD**4*integralnorm*SwB
    f(17) = (cw*eQED**3*gQCD**2*integralnorm*SwB)/(sw**3*2._/**/REALKIND)
    f(18) = (eQED**3*gQCD**2*integralnorm*SwB)/(sw**2*2._/**/REALKIND)
    f(19) = eQED*gQCD**4*integralnorm*SwF
    f(20) = 2*eQED*gQCD**4*integralnorm*SwF

  c = [ 6*f(12), 18*f(12), 48*f(12), 6*f(13), 18*f(13), 48*f(13), 9*CI*f(14), 27*CI*f(14), 18*f(15), 54*f(15), f(16), 3*f(16) &
    , 6*f(16), 8*f(16), 10*f(16), 18*f(16), 21*f(16), 24*f(16), 54*f(16), 6*f(17), 18*f(17), 6*f(18), 18*f(18), 3*f(19), 9*f(19) &
    , 3*f(20), 9*f(20) ]
  c = (1._/**/REALKIND / 36) * c
end subroutine fac_init_loop

subroutine denominators()
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_momenta_decl_/**/REALKIND, only: L
  implicit none
  ! propagators
  den(1) = 1 /((L(5,5))+L(6,5))
  den(2) = 1 /((L(5,18))+L(6,18))
  den(4) = 1 /((L(5,5) - MZ2)+L(6,5))
  den(6) = 1 /((L(5,24))+L(6,24))
  den(9) = 1 /((L(5,17))+L(6,17))
  den(10) = 1 /((L(5,6))+L(6,6))
  den(12) = 1 /((L(5,6) - MZ2)+L(6,6))
  den(16) = 1 /((L(5,9))+L(6,9))
  den(18) = 1 /((L(5,9) - MZ2)+L(6,9))
  den(20) = 1 /((L(5,20))+L(6,20))
  den(23) = 1 /((L(5,10))+L(6,10))
  den(25) = 1 /((L(5,10) - MZ2)+L(6,10))
  den(31) = 1 /((L(5,26))+L(6,26))
  den(34) = 1 /((L(5,13))+L(6,13))
  den(41) = 1 /((L(5,7))+L(6,7))
  den(46) = 1 /((L(5,14))+L(6,14))
  den(51) = 1 /((L(5,25))+L(6,25))
  den(60) = 1 /((L(5,22))+L(6,22))
  den(69) = 1 /((L(5,11))+L(6,11))
  den(78) = 1 /((L(5,21))+L(6,21))
  den(87) = 1 /((L(5,21) - MZ2)+L(6,21))
  den(89) = 1 /((L(5,25) - MZ2)+L(6,25))
  den(91) = 1 /((L(5,22) - MZ2)+L(6,22))
  den(93) = 1 /((L(5,26) - MZ2)+L(6,26))

  ! denominators
  den(3) = den(1)*den(2)
  den(5) = den(2)*den(4)
  den(7) = den(1)*den(6)
  den(8) = den(4)*den(6)
  den(11) = den(9)*den(10)
  den(13) = den(9)*den(12)
  den(14) = den(6)*den(10)
  den(15) = den(6)*den(12)
  den(17) = den(2)*den(16)
  den(19) = den(2)*den(18)
  den(21) = den(16)*den(20)
  den(22) = den(18)*den(20)
  den(24) = den(9)*den(23)
  den(26) = den(9)*den(25)
  den(27) = den(20)*den(23)
  den(28) = den(20)*den(25)
  den(29) = den(1)*den(23)
  den(30) = den(10)*den(16)
  den(32) = den(2)*den(31)
  den(33) = den(1)*den(32)
  den(35) = den(1)*den(34)
  den(36) = den(2)*den(35)
  den(37) = den(4)*den(34)
  den(38) = den(2)*den(37)
  den(39) = den(6)*den(31)
  den(40) = den(1)*den(39)
  den(42) = den(1)*den(41)
  den(43) = den(6)*den(42)
  den(44) = den(4)*den(41)
  den(45) = den(6)*den(44)
  den(47) = den(10)*den(46)
  den(48) = den(9)*den(47)
  den(49) = den(12)*den(46)
  den(50) = den(9)*den(49)
  den(52) = den(9)*den(51)
  den(53) = den(10)*den(52)
  den(54) = den(6)*den(51)
  den(55) = den(10)*den(54)
  den(56) = den(10)*den(41)
  den(57) = den(6)*den(56)
  den(58) = den(12)*den(41)
  den(59) = den(6)*den(58)
  den(61) = den(2)*den(60)
  den(62) = den(16)*den(61)
  den(63) = den(16)*den(34)
  den(64) = den(2)*den(63)
  den(65) = den(18)*den(34)
  den(66) = den(2)*den(65)
  den(67) = den(20)*den(60)
  den(68) = den(16)*den(67)
  den(70) = den(16)*den(69)
  den(71) = den(20)*den(70)
  den(72) = den(18)*den(69)
  den(73) = den(20)*den(72)
  den(74) = den(23)*den(46)
  den(75) = den(9)*den(74)
  den(76) = den(25)*den(46)
  den(77) = den(9)*den(76)
  den(79) = den(9)*den(78)
  den(80) = den(23)*den(79)
  den(81) = den(20)*den(78)
  den(82) = den(23)*den(81)
  den(83) = den(23)*den(69)
  den(84) = den(20)*den(83)
  den(85) = den(25)*den(69)
  den(86) = den(20)*den(85)
  den(88) = den(9)*den(87)
  den(90) = den(9)*den(89)
  den(92) = den(2)*den(91)
  den(94) = den(2)*den(93)
  den(95) = den(20)*den(87)
  den(96) = den(20)*den(91)
  den(97) = den(6)*den(89)
  den(98) = den(6)*den(93)

end subroutine denominators

#ifdef PRECISION_dp
! **********************************************************************
subroutine init_merging_tables(tot_num_hels, tot_num_merge_steps)
!-----------------------------------------------------------------------
! In the first event the merging tables are fully initialised
! **********************************************************************
  implicit none
  integer, intent(in) :: tot_num_hels, tot_num_merge_steps
  n_merge_steps = tot_num_merge_steps
  allocate(merge_tables(tot_num_hels,2,n_merge_steps))
  allocate(merge_mism(n_merge_steps+1))
  allocate(merge_hels(n_merge_steps))
  merge_tables_on = .true.
  merge_mism = 0_intkind2
  merge_tables = -1_intkind2
  merge_hels = -1_intkind2
end subroutine init_merging_tables

! **********************************************************************
subroutine update_merging_tables(tot_num_hels)
!-----------------------------------------------------------------------
! After the first evaluation the merging tables are adapted
! **********************************************************************
  implicit none
  integer, intent(in) :: tot_num_hels
  integer(intkind2), allocatable ::  merge_tables_tmp(:,:,:), merge_hels_tmp(:)

  if(merge_mism(1) == 0) then ! helicity configurations match in all merging steps
    if(allocated(merge_tables)) deallocate(merge_tables)
    if(allocated(merge_hels)) deallocate(merge_hels)
    if(allocated(merge_mism)) deallocate(merge_mism)
    allocate(merge_mism(1))
    allocate(merge_hels(1))
    allocate(merge_tables(1,1,1)) ! dummy allocation
    merge_mism = 0_intkind2
    merge_tables = -1_intkind2
    merge_hels = -1_intkind2
  else
    n_merge_mism = merge_mism(1)
    allocate(merge_tables_tmp(tot_num_hels,2,n_merge_mism))
    merge_tables_tmp(:,:,1:n_merge_mism) = merge_tables(:,:,1:n_merge_mism)
    if(allocated(merge_tables)) then
      deallocate(merge_tables)
      allocate(merge_tables(tot_num_hels,2,n_merge_mism))
    end if
    merge_tables = merge_tables_tmp
    if(allocated(merge_tables_tmp)) deallocate(merge_tables_tmp)
    allocate(merge_hels_tmp(n_merge_mism))
    merge_hels_tmp(1:n_merge_mism) = merge_hels(1:n_merge_mism)
    if(allocated(merge_hels)) then
      deallocate(merge_hels)
      allocate(merge_hels(n_merge_mism))
    end if
    merge_hels = merge_hels_tmp
    if(allocated(merge_hels_tmp)) deallocate(merge_hels_tmp)
  end if
  merge_tables_on = .true.
end subroutine update_merging_tables
#endif


!
!
!
! **********************************************************************
#ifdef PRECISION_dp
recursive subroutine amp2(P_scatt, M02, M2ct, M2colint, qp_kinematics)
#else
recursive subroutine amp2(P_scatt, M02, M2ct, M2colint, qp_kinematics)
  use ol_loop_storage_ppzjj_ew_uuuxuxz_1_/**/DREALKIND, only: nhel, Hel
#endif
! P_scatt(0:3,Npart) = incoming external momenta
! M2  = helicity-summed squared matrix element for up up anti-up anti-up Z -> 0
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND !, only: ci, parameters_status, ZERO, scalefactor, >masses<
  use ol_parameters_init_/**/REALKIND, only: ensure_mp_init
  use ol_kinematics_/**/REALKIND, only: init_kinematics
  use ol_momenta_decl_/**/DREALKIND, only: momenta_nan_check
  use ol_data_types_/**/REALKIND
  use ol_h_helicity_bookkeeping_/**/REALKIND, only: &
    & helbookkeeping_wf, helsync, flip_phase
  use ol_helicity_init, only: helbookkeeping_flip, helsync_flip
  use ol_hel_propagators_/**/REALKIND
  use ol_hel_wavefunctions_/**/REALKIND
  use ol_wavefunctions_/**/REALKIND, only: wf_V_Std
  use ol_hel_vertices_/**/REALKIND
  use ol_hel_contractions_/**/REALKIND
  use ol_external_ppzjj_ew_uuuxuxz_1, only: &
    & external_perm_ppzjj_ew_uuuxuxz_1, &
    & external_perm_inv_ppzjj_ew_uuuxuxz_1, &
    & extcomb_perm_ppzjj_ew_uuuxuxz_1, &
    & average_factor_ppzjj_ew_uuuxuxz_1, &
    & photonid_ppzjj_ew_uuuxuxz_1
  use ol_ew_renormalisation_/**/REALKIND, only: photon_factors
  use ol_external_ppzjj_ew_uuuxuxz_1, only: &
    & H, hel_not_initialised, hel_init, POLSEL
  use ol_colourmatrix_ppzjj_ew_uuuxuxz_1_/**/REALKIND, only: &
    & colmat_not_initialised, colourmatrix_init
  use ol_forced_parameters_ppzjj_ew_uuuxuxz_1_/**/REALKIND, only: &
    & check_forced_parameters
  use ol_heltables_OLR_ppzjj_ew_uuuxuxz_1
  use ol_kinematics_/**/REALKIND, only: LC2Std_Rep_cmplx
  use ol_h_counterterms_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND ! counterterms
  use ol_loop_parameters_decl_/**/DREALKIND, only: IR_is_on
  use ol_init, only: set_parameter, parameters_flush
#ifdef PRECISION_dp
  use ol_kinematics_/**/QREALKIND, only: conv_mom_scatt2in_qp=>conv_mom_scatt2in, &
                                         internal_momenta_qp=>internal_momenta
  use ol_momenta_decl_/**/DREALKIND, only: L
  use ol_momenta_decl_/**/QREALKIND, only: L_qp=>L
#endif
  implicit none

  real(DREALKIND), intent(in)  :: P_scatt(0:3,5)
  real(REALKIND),  intent(out) :: M02, M2ct, M2colint(16)
  logical, intent(in) :: qp_kinematics
  integer(intkind1), save :: ntry = 0

  integer           :: shift, k, r, m, n, i
  real(REALKIND)    :: P(0:3,5)
#ifdef PRECISION_dp
  real(QREALKIND)    :: P_qp(0:3,5)
#endif
  integer           :: extmasses2(5)
  real(REALKIND)    :: M2add, M2add_ct, M2add_colint(16)
  complex(REALKIND) :: M1(4), M2(4)
  real(REALKIND)    :: P_scatt_intern(0:3,5)
  real(REALKIND), save :: scalebackfactor, old_scalefactor = 0
  real(REALKIND)       :: bornphotonfactor
  integer(intkind1) :: nsync
  type(Hpolcont),   save :: M1helarray(4,48)
  type(Hpolcont) :: M1helarray_ct(4,48)
  integer, allocatable :: extcombs_permuted(:)
  integer              :: extcombs(16), nextcombs
  integer              :: CT_on_bak, R2_on_bak, TP_on_bak

#if 5 > 3
  integer :: ind_cc_comb(5)
#endif
  type(Hpolcont) :: A(48,162)

  !Aj are not used at the moment
  !complex(REALKIND) :: Aj(162)

  complex(REALKIND) :: omega(2) ! phases for helicity correlations

  if(ntry == 0) then
    ! recursive initialization call needed for the correct helicity bokkeeping
    ntry = 1
    CT_on_bak = CT_is_on
    R2_on_bak = R2_is_on
    TP_on_bak = TP_is_on
    call set_parameter("ct_on", 1)
    call set_parameter("r2_on", 1)
    call set_parameter("tp_on", 1)
    call amp2(P_scatt, M02, M2ct, M2colint, qp_kinematics)
    call set_parameter("ct_on", CT_on_bak)
    call set_parameter("r2_on", R2_on_bak)
    call set_parameter("tp_on", TP_on_bak)
  end if


  call set_parameter("ew_renorm", 1)
  call parameters_flush()
  call ensure_mp_init()

  if (colmat_not_initialised) call colourmatrix_init()

  if (fac_status_loop1 /= parameters_status .or. fac_status_loop2 /= loop_parameters_status) then
    ! Note: if fac_init would only be called when parameters changed which are relevant for the factors,
    ! a different 'status' would have to be used, because forced_parameters should be called after every parameter change.
    call check_forced_parameters()
    call fac_init_loop()
  end if

  if (momenta_nan_check(P_scatt) /= 0) then
    M02 = 0
    return
  end if

  extmasses2 = [ 0, 0, 0, 0, nMZ ]
  ! Convert 2 -> n-2 PS-point to n -> 0 (so that P(1) + ... + P(n) = 0) and compute
  ! internal-propagator momenta in light-cone representation
  call init_kinematics(P_scatt, extmasses2, P, &
     external_perm_inv_ppzjj_ew_uuuxuxz_1, 5, qp_kinematics)

  ! denominators
  call denominators()

   if (heltables_not_init) call init_heltables()

  ! external WFs
  ! Here the external wavefunctions are initialiased
  call pol_wf_Q(P(:,1), rZERO, H1, ex1, POLSEL(1),1)
  call pol_wf_Q(P(:,2), rZERO, H2, ex2, POLSEL(2),2)
  call pol_wf_A(P(:,3), rZERO, H3, ex3, POLSEL(3),3)
  call pol_wf_A(P(:,4), rZERO, H4, ex4, POLSEL(4),4)
  call pol_wf_V(P(:,5), rMZ, H5, ex5, POLSEL(5),5)



  ! internal WFs
  ! e.g. call vert_VQ_A(ntry, ex3, ex1, wf1, n1, t1) ...
  call vert_QA_V(ntry, ex1(:), ex3(:), wf4(:,1), n3(:,1), t3x4(:,:,1))
  call vert_ZQ_A(gZu,ntry, ex5(:), ex2(:), wf6(:,1), n3(:,2), t3x6(:,:,1))
  call prop_Q_A(ntry, wf6(:,1), 18, ZERO, 0_intkind1, wf6(:,2), n2(1))
  call vert_AV_Q(ntry, ex4(:), wf4(:,1), wf8(:,1), n3(:,3), t3x8(:,:,1))
  call vert_QA_Z(gZu,ntry, ex1(:), ex3(:), wf4(:,2), n3(:,4), t3x4(:,:,2))
  call vert_AZ_Q(gZu,ntry, ex4(:), wf4(:,2), wf8(:,2), n3(:,5), t3x8(:,:,2))
  call vert_AZ_Q(gZu,ntry, ex4(:), ex5(:), wf6(:,3), n3(:,6), t3x6(:,:,2))
  call prop_A_Q(ntry, wf6(:,3), 24, ZERO, 0_intkind1, wf6(:,4), n2(2))
  call vert_VQ_A(ntry, wf4(:,1), ex2(:), wf8(:,3), n3(:,7), t3x8(:,:,3))
  call vert_ZQ_A(gZu,ntry, wf4(:,2), ex2(:), wf8(:,4), n3(:,8), t3x8(:,:,4))
  call vert_ZQ_A(gZu,ntry, ex5(:), ex1(:), wf6(:,5), n3(:,9), t3x6(:,:,3))
  call vert_QA_V(ntry, ex2(:), ex3(:), wf4(:,3), n3(:,10), t3x4(:,:,3))
  call prop_Q_A(ntry, wf6(:,5), 17, ZERO, 0_intkind1, wf6(:,6), n2(3))
  call vert_QA_V(ntry, wf6(:,6), ex4(:), wf12(:,1), n3(:,11), t3x12(:,:,1))
  call vert_QA_Z(gZu,ntry, ex2(:), ex3(:), wf4(:,4), n3(:,12), t3x4(:,:,4))
  call vert_QA_Z(gZu,ntry, wf6(:,6), ex4(:), wf12(:,2), n3(:,13), t3x12(:,:,2))
  call vert_VQ_A(ntry, wf4(:,3), ex1(:), wf8(:,5), n3(:,14), t3x8(:,:,5))
  call vert_ZQ_A(gZu,ntry, wf4(:,4), ex1(:), wf8(:,6), n3(:,15), t3x8(:,:,6))
  call vert_QA_V(ntry, ex1(:), ex4(:), wf4(:,5), n3(:,16), t3x4(:,:,5))
  call vert_AV_Q(ntry, ex3(:), wf4(:,5), wf8(:,7), n3(:,17), t3x8(:,:,7))
  call vert_QA_Z(gZu,ntry, ex1(:), ex4(:), wf4(:,6), n3(:,18), t3x4(:,:,6))
  call vert_AZ_Q(gZu,ntry, ex3(:), wf4(:,6), wf8(:,8), n3(:,19), t3x8(:,:,8))
  call vert_AZ_Q(gZu,ntry, ex3(:), ex5(:), wf6(:,7), n3(:,20), t3x6(:,:,4))
  call prop_A_Q(ntry, wf6(:,7), 20, ZERO, 0_intkind1, wf6(:,8), n2(4))
  call vert_VQ_A(ntry, wf4(:,5), ex2(:), wf8(:,9), n3(:,21), t3x8(:,:,9))
  call vert_ZQ_A(gZu,ntry, wf4(:,6), ex2(:), wf8(:,10), n3(:,22), t3x8(:,:,10))
  call vert_QA_V(ntry, ex2(:), ex4(:), wf4(:,7), n3(:,23), t3x4(:,:,7))
  call vert_QA_V(ntry, wf6(:,6), ex3(:), wf12(:,3), n3(:,24), t3x12(:,:,3))
  call vert_QA_Z(gZu,ntry, ex2(:), ex4(:), wf4(:,8), n3(:,25), t3x4(:,:,8))
  call vert_QA_Z(gZu,ntry, wf6(:,6), ex3(:), wf12(:,4), n3(:,26), t3x12(:,:,4))
  call vert_VQ_A(ntry, wf4(:,7), ex1(:), wf8(:,11), n3(:,27), t3x8(:,:,11))
  call vert_ZQ_A(gZu,ntry, wf4(:,8), ex1(:), wf8(:,12), n3(:,28), t3x8(:,:,12))
  call counter_VG_G(ntry, ex5(:), wf4(:,1), 5, wf12(:,5), 21, n3(:,29), t3x12(:,:,5))
  call counter_AV_Q(ntry, ex4(:), wf4(:,1), wf8(:,13), n3(:,30), t3x8(:,:,13))
  call counter_AZ_Q(gZu,ntry, ex4(:), wf4(:,2), wf8(:,14), n3(:,31), t3x8(:,:,14))
  call counter_AV_Q_LR(EWctGuu,ntry, ex4(:), wf4(:,1), wf8(:,15), n3(:,32), t3x8(:,:,15))
  call counter_AZ_Q(gZu,ntry, ex4(:), ex5(:), wf6(:,9), n3(:,33), t3x6(:,:,5))
  call prop_A_Q(ntry, wf6(:,9), 24, ZERO, 0_intkind1, wf6(:,10), n2(5))
  call counter_AZ_Q(EWctVuu,ntry, ex4(:), ex5(:), wf6(:,11), n3(:,34), t3x6(:,:,6))
  call prop_A_Q(ntry, wf6(:,11), 24, ZERO, 0_intkind1, wf6(:,12), n2(6))
  call counter_VG_G(ntry, ex5(:), wf4(:,5), 9, wf12(:,6), 25, n3(:,35), t3x12(:,:,6))
  call counter_QA_V(ntry, wf6(:,6), ex4(:), wf12(:,7), n3(:,36), t3x12(:,:,7))
  call counter_QA_Z(gZu,ntry, wf6(:,6), ex4(:), wf12(:,8), n3(:,37), t3x12(:,:,8))
  call counter_QA_V_LR(EWctGuu,ntry, wf6(:,6), ex4(:), wf12(:,9), n3(:,38), t3x12(:,:,9))
  call counter_AV_Q(ntry, ex3(:), wf4(:,5), wf8(:,16), n3(:,39), t3x8(:,:,16))
  call counter_AZ_Q(gZu,ntry, ex3(:), wf4(:,6), wf8(:,17), n3(:,40), t3x8(:,:,17))
  call counter_AV_Q_LR(EWctGuu,ntry, ex3(:), wf4(:,5), wf8(:,18), n3(:,41), t3x8(:,:,18))
  call counter_AZ_Q(gZu,ntry, ex3(:), ex5(:), wf6(:,13), n3(:,42), t3x6(:,:,7))
  call prop_A_Q(ntry, wf6(:,13), 20, ZERO, 0_intkind1, wf6(:,14), n2(7))
  call counter_AZ_Q(EWctVuu,ntry, ex3(:), ex5(:), wf6(:,15), n3(:,43), t3x6(:,:,8))
  call prop_A_Q(ntry, wf6(:,15), 20, ZERO, 0_intkind1, wf6(:,16), n2(8))
  call counter_QA_V(ntry, wf6(:,6), ex3(:), wf12(:,10), n3(:,44), t3x12(:,:,10))
  call counter_QA_Z(gZu,ntry, wf6(:,6), ex3(:), wf12(:,11), n3(:,45), t3x12(:,:,11))
  call counter_QA_V_LR(EWctGuu,ntry, wf6(:,6), ex3(:), wf12(:,12), n3(:,46), t3x12(:,:,12))
  call counter_VQ_A(ntry, wf4(:,1), ex2(:), wf8(:,19), n3(:,47), t3x8(:,:,19))
  call counter_ZQ_A(gZu,ntry, wf4(:,2), ex2(:), wf8(:,20), n3(:,48), t3x8(:,:,20))
  call counter_VQ_A_LR(EWctGuu,ntry, wf4(:,1), ex2(:), wf8(:,21), n3(:,49), t3x8(:,:,21))
  call counter_ZQ_A(gZu,ntry, ex5(:), ex2(:), wf6(:,17), n3(:,50), t3x6(:,:,9))
  call prop_Q_A(ntry, wf6(:,17), 18, ZERO, 0_intkind1, wf6(:,18), n2(9))
  call counter_ZQ_A(EWctVuu,ntry, ex5(:), ex2(:), wf6(:,19), n3(:,51), t3x6(:,:,10))
  call prop_Q_A(ntry, wf6(:,19), 18, ZERO, 0_intkind1, wf6(:,20), n2(10))
  call counter_VQ_A(ntry, wf4(:,5), ex2(:), wf8(:,22), n3(:,52), t3x8(:,:,22))
  call counter_ZQ_A(gZu,ntry, wf4(:,6), ex2(:), wf8(:,23), n3(:,53), t3x8(:,:,23))
  call counter_VQ_A_LR(EWctGuu,ntry, wf4(:,5), ex2(:), wf8(:,24), n3(:,54), t3x8(:,:,24))
  call counter_QA_V(ntry, ex2(:), ex4(:), wf4(:,9), n3(:,55), t3x4(:,:,9))
  call counter_QA_Z(gZu,ntry, ex2(:), ex4(:), wf4(:,10), n3(:,56), t3x4(:,:,10))
  call counter_QA_V_LR(EWctGuu,ntry, ex2(:), ex4(:), wf4(:,11), n3(:,57), t3x4(:,:,11))
  call vert_VQ_A(ntry, wf4(:,9), ex1(:), wf8(:,25), n3(:,58), t3x8(:,:,25))
  call vert_ZQ_A(gZu,ntry, wf4(:,10), ex1(:), wf8(:,26), n3(:,59), t3x8(:,:,26))
  call vert_VQ_A(ntry, wf4(:,11), ex1(:), wf8(:,27), n3(:,60), t3x8(:,:,27))
  call counter_QA_V(ntry, ex2(:), ex3(:), wf4(:,12), n3(:,61), t3x4(:,:,12))
  call counter_QA_Z(gZu,ntry, ex2(:), ex3(:), wf4(:,13), n3(:,62), t3x4(:,:,13))
  call counter_QA_V_LR(EWctGuu,ntry, ex2(:), ex3(:), wf4(:,14), n3(:,63), t3x4(:,:,14))
  call vert_VQ_A(ntry, wf4(:,12), ex1(:), wf8(:,28), n3(:,64), t3x8(:,:,28))
  call vert_ZQ_A(gZu,ntry, wf4(:,13), ex1(:), wf8(:,29), n3(:,65), t3x8(:,:,29))
  call vert_VQ_A(ntry, wf4(:,14), ex1(:), wf8(:,30), n3(:,66), t3x8(:,:,30))
  call counter_VQ_A(ntry, wf4(:,3), ex1(:), wf8(:,31), n3(:,67), t3x8(:,:,31))
  call counter_ZQ_A(gZu,ntry, wf4(:,4), ex1(:), wf8(:,32), n3(:,68), t3x8(:,:,32))
  call counter_VQ_A_LR(EWctGuu,ntry, wf4(:,3), ex1(:), wf8(:,33), n3(:,69), t3x8(:,:,33))
  call counter_ZQ_A(gZu,ntry, ex5(:), ex1(:), wf6(:,21), n3(:,70), t3x6(:,:,11))
  call prop_Q_A(ntry, wf6(:,21), 17, ZERO, 0_intkind1, wf6(:,22), n2(11))
  call vert_QA_V(ntry, wf6(:,22), ex4(:), wf12(:,13), n3(:,71), t3x12(:,:,13))
  call vert_QA_Z(gZu,ntry, wf6(:,22), ex4(:), wf12(:,14), n3(:,72), t3x12(:,:,14))
  call counter_ZQ_A(EWctVuu,ntry, ex5(:), ex1(:), wf6(:,23), n3(:,73), t3x6(:,:,12))
  call prop_Q_A(ntry, wf6(:,23), 17, ZERO, 0_intkind1, wf6(:,24), n2(12))
  call vert_QA_V(ntry, wf6(:,24), ex4(:), wf12(:,15), n3(:,74), t3x12(:,:,15))
  call counter_VQ_A(ntry, wf4(:,7), ex1(:), wf8(:,34), n3(:,75), t3x8(:,:,34))
  call counter_ZQ_A(gZu,ntry, wf4(:,8), ex1(:), wf8(:,35), n3(:,76), t3x8(:,:,35))
  call counter_VQ_A_LR(EWctGuu,ntry, wf4(:,7), ex1(:), wf8(:,36), n3(:,77), t3x8(:,:,36))
  call vert_QA_V(ntry, wf6(:,22), ex3(:), wf12(:,16), n3(:,78), t3x12(:,:,16))
  call vert_QA_Z(gZu,ntry, wf6(:,22), ex3(:), wf12(:,17), n3(:,79), t3x12(:,:,17))
  call vert_QA_V(ntry, wf6(:,24), ex3(:), wf12(:,18), n3(:,80), t3x12(:,:,18))
  call counter_QA_V(ntry, ex1(:), ex4(:), wf4(:,15), n3(:,81), t3x4(:,:,15))
  call vert_AV_Q(ntry, ex3(:), wf4(:,15), wf8(:,37), n3(:,82), t3x8(:,:,37))
  call counter_QA_Z(gZu,ntry, ex1(:), ex4(:), wf4(:,16), n3(:,83), t3x4(:,:,16))
  call vert_AZ_Q(gZu,ntry, ex3(:), wf4(:,16), wf8(:,38), n3(:,84), t3x8(:,:,38))
  call counter_QA_V_LR(EWctGuu,ntry, ex1(:), ex4(:), wf4(:,17), n3(:,85), t3x4(:,:,17))
  call vert_AV_Q(ntry, ex3(:), wf4(:,17), wf8(:,39), n3(:,86), t3x8(:,:,39))
  call vert_VQ_A(ntry, wf4(:,15), ex2(:), wf8(:,40), n3(:,87), t3x8(:,:,40))
  call vert_ZQ_A(gZu,ntry, wf4(:,16), ex2(:), wf8(:,41), n3(:,88), t3x8(:,:,41))
  call vert_VQ_A(ntry, wf4(:,17), ex2(:), wf8(:,42), n3(:,89), t3x8(:,:,42))
  call counter_QA_V(ntry, ex1(:), ex3(:), wf4(:,18), n3(:,90), t3x4(:,:,18))
  call vert_AV_Q(ntry, ex4(:), wf4(:,18), wf8(:,43), n3(:,91), t3x8(:,:,43))
  call counter_QA_Z(gZu,ntry, ex1(:), ex3(:), wf4(:,19), n3(:,92), t3x4(:,:,19))
  call vert_AZ_Q(gZu,ntry, ex4(:), wf4(:,19), wf8(:,44), n3(:,93), t3x8(:,:,44))
  call counter_QA_V_LR(EWctGuu,ntry, ex1(:), ex3(:), wf4(:,20), n3(:,94), t3x4(:,:,20))
  call vert_AV_Q(ntry, ex4(:), wf4(:,20), wf8(:,45), n3(:,95), t3x8(:,:,45))
  call vert_VQ_A(ntry, wf4(:,18), ex2(:), wf8(:,46), n3(:,96), t3x8(:,:,46))
  call vert_ZQ_A(gZu,ntry, wf4(:,19), ex2(:), wf8(:,47), n3(:,97), t3x8(:,:,47))
  call vert_VQ_A(ntry, wf4(:,20), ex2(:), wf8(:,48), n3(:,98), t3x8(:,:,48))
  call vert_QA_V(ntry, wf6(:,2), ex4(:), wf12(:,19), n3(:,99), t3x12(:,:,19))
  call counter_V_V(ctGG,21,ntry, wf4(:,1), 5, wf4(:,21), n2(13))
  call counter_Q_A(ctqq,2,ntry, wf6(:,2), 18, wf6(:,25), n2(14))
  call prop_A_Q(ntry, wf8(:,1), 13, ZERO, 0_intkind1, wf8(:,49), n2(15))
  call prop_A_Q(ntry, wf8(:,2), 13, ZERO, 0_intkind1, wf8(:,50), n2(16))
  call counter_Q_A_LR(EWctuu,ntry, wf6(:,2), 18, wf6(:,26), n2(17))
  call vert_QA_V(ntry, ex2(:), wf6(:,4), wf12(:,20), n3(:,100), t3x12(:,:,20))
  call counter_A_Q(ctqq,2,ntry, wf6(:,4), 24, wf6(:,27), n2(18))
  call prop_Q_A(ntry, wf8(:,3), 7, ZERO, 0_intkind1, wf8(:,51), n2(19))
  call prop_Q_A(ntry, wf8(:,4), 7, ZERO, 0_intkind1, wf8(:,52), n2(20))
  call counter_A_Q_LR(EWctuu,ntry, wf6(:,4), 24, wf6(:,28), n2(21))
  call vert_AV_Q(ntry, ex4(:), wf4(:,3), wf8(:,53), n3(:,101), t3x8(:,:,49))
  call counter_Q_A(ctqq,2,ntry, wf6(:,6), 17, wf6(:,29), n2(22))
  call prop_A_Q(ntry, wf8(:,53), 14, ZERO, 0_intkind1, wf8(:,54), n2(23))
  call vert_AZ_Q(gZu,ntry, ex4(:), wf4(:,4), wf8(:,55), n3(:,102), t3x8(:,:,50))
  call prop_A_Q(ntry, wf8(:,55), 14, ZERO, 0_intkind1, wf8(:,56), n2(24))
  call counter_Q_A_LR(EWctuu,ntry, wf6(:,6), 17, wf6(:,30), n2(25))
  call counter_V_V(ctGG,21,ntry, wf4(:,3), 6, wf4(:,22), n2(26))
  call vert_QA_V(ntry, ex1(:), wf6(:,4), wf12(:,21), n3(:,103), t3x12(:,:,21))
  call prop_Q_A(ntry, wf8(:,5), 7, ZERO, 0_intkind1, wf8(:,57), n2(27))
  call prop_Q_A(ntry, wf8(:,6), 7, ZERO, 0_intkind1, wf8(:,58), n2(28))
  call vert_QA_V(ntry, wf6(:,2), ex3(:), wf12(:,22), n3(:,104), t3x12(:,:,22))
  call counter_V_V(ctGG,21,ntry, wf4(:,5), 9, wf4(:,23), n2(29))
  call prop_A_Q(ntry, wf8(:,7), 13, ZERO, 0_intkind1, wf8(:,59), n2(30))
  call prop_A_Q(ntry, wf8(:,8), 13, ZERO, 0_intkind1, wf8(:,60), n2(31))
  call vert_QA_V(ntry, ex2(:), wf6(:,8), wf12(:,23), n3(:,105), t3x12(:,:,23))
  call counter_A_Q(ctqq,2,ntry, wf6(:,8), 20, wf6(:,31), n2(32))
  call prop_Q_A(ntry, wf8(:,9), 11, ZERO, 0_intkind1, wf8(:,61), n2(33))
  call prop_Q_A(ntry, wf8(:,10), 11, ZERO, 0_intkind1, wf8(:,62), n2(34))
  call counter_A_Q_LR(EWctuu,ntry, wf6(:,8), 20, wf6(:,32), n2(35))
  call vert_AV_Q(ntry, ex3(:), wf4(:,7), wf8(:,63), n3(:,106), t3x8(:,:,51))
  call prop_A_Q(ntry, wf8(:,63), 14, ZERO, 0_intkind1, wf8(:,64), n2(36))
  call vert_AZ_Q(gZu,ntry, ex3(:), wf4(:,8), wf8(:,65), n3(:,107), t3x8(:,:,52))
  call prop_A_Q(ntry, wf8(:,65), 14, ZERO, 0_intkind1, wf8(:,66), n2(37))
  call counter_V_V(ctGG,21,ntry, wf4(:,7), 10, wf4(:,24), n2(38))
  call vert_QA_V(ntry, ex1(:), wf6(:,8), wf12(:,24), n3(:,108), t3x12(:,:,24))
  call prop_Q_A(ntry, wf8(:,11), 11, ZERO, 0_intkind1, wf8(:,67), n2(39))
  call prop_Q_A(ntry, wf8(:,12), 11, ZERO, 0_intkind1, wf8(:,68), n2(40))
  call vert_QA_Z(gZu,ntry, wf6(:,2), ex3(:), wf12(:,25), n3(:,109), t3x12(:,:,25))
  call vert_QA_Z(gZu,ntry, wf6(:,2), ex4(:), wf12(:,26), n3(:,110), t3x12(:,:,26))
  call vert_QA_Z(gZu,ntry, ex1(:), wf6(:,8), wf12(:,27), n3(:,111), t3x12(:,:,27))
  call vert_QA_Z(gZu,ntry, ex2(:), wf6(:,8), wf12(:,28), n3(:,112), t3x12(:,:,28))
  call vert_QA_Z(gZu,ntry, ex1(:), wf6(:,4), wf12(:,29), n3(:,113), t3x12(:,:,29))
  call vert_QA_Z(gZu,ntry, ex2(:), wf6(:,4), wf12(:,30), n3(:,114), t3x12(:,:,30))


  call init_hybrid_exwf(ex1)
  call init_hybrid_exwf(ex2)
  call init_hybrid_exwf(ex3)
  call init_hybrid_exwf(ex4)
  call init_hybrid_exwf(ex5)
  call init_hybrid_wf(wf4)
  call init_hybrid_wf(wf6)
  call init_hybrid_wf(wf8)
  call init_hybrid_wf(wf12)


  if (ntry==1) then
    call physical_helicities()
  end if

  ! computation of the colour-stripped amplitudes
  do nsync = ntry+ntry-1, ntry+1  !  nsync = 1,2  for 1st point and nsync = 3 later
    call diagrams()
    if (nsync == 1) call helsync(nsync, A, nhel, Hel)
  end do

  ! In the following loop the coefficients \Gamma_{i} of the expansion in
  ! the colour basis are computed for every helicity state and stored in M1helarray.
  ! Also the colour vector for the Born-loop interference is computed and saved in
  ! M0_col1_helarray
  do k = 1, nhel
    call colourvectors(A, k, M1helarray(:,k),M1helarray_ct(:,k))
    call colborninterf(M1helarray(:,k), M0_col1_helarray(:,k), 0)
  end do
  M1helarray(:,nhel+1:)%j = 0
  M0_col1_helarray(:,nhel+1:)%hf = -1_intkind2
  M0_col1_helarray(:,nhel+1:)%j = 0

  M2add = 0
  M2add_ct = 0
  M2add_colint = 0

  M02 = 0
  M2ct = 0
  M2colint = 0

  do k = 1, nhel
    call colint(M1helarray(:,k)%j, M2add)
    call colint_ct(M1helarray(:,k)%j, M1helarray_ct(:,k)%j, M2add_ct, 0)
    if (IR_is_on > 0) then
      call colint_IR(M1helarray(:,k)%j, M2add_colint)
    end if
    !summation over helicity configurations
    M02 = M02 + M2add
    M2ct = M2ct + M2add_ct
    M2colint = M2colint + M2add_colint
  end do

  call photon_factors(photonid_ppzjj_ew_uuuxuxz_1, &
                    &  0, bornphotonfactor)
  M02 = bornphotonfactor * M02
  M2ct = bornphotonfactor * M2ct
  M2colint = bornphotonfactor * M2colint

  !! used for born-loop colour-correlators
  extcombs = [(i, i = 0, 16-1)]
  nextcombs = 5*(5+1)/2 + 1
  if(nextcombs>0) then
    allocate(extcombs_permuted(nextcombs))
  end if
  do k = 1, nextcombs
    extcombs_permuted(k) = extcomb_perm_ppzjj_ew_uuuxuxz_1(extcombs(k))
  end do

#if 1 > 0 && 5 > 3
  !!Born-loop colour correlators interference
ind_cc_comb = [8,12,9,13,14]
  M0M1_hel_cc(:,:,:)%j = 0
  do n = 1, 5
    M2add_ct = 0
    m = ind_cc_comb(n)
      do k = 1, nhel
        call colint_ct(M1helarray(:,k)%j, M1helarray_ct(:,k)%j, M2add_ct, m)
        call colborninterf(M1helarray(:,k), M0M1_hel_cc(:,k,m), m)
        M2ctcc(m) = M2ctcc(m) + M2add_ct
      end do
  end do
  M0M1_hel_cc(:,nhel+1:,:)%hf = -1_intkind2
  M0M1_hel_cc(:,nhel+1:,:)%j = 0
#endif

  ntry=2


  contains

subroutine physical_helicities()
  implicit none

integer :: i1,i2,i3,i4,i5
integer :: n

n=0

do i5= 1, 3
do i4= 1, 2
do i3= 1, 2
do i2= 1, 2
do i1= 1, 2
n = n + 1
 if((ex1(i1)%hf==-1_intkind2) .OR. (ex2(i2)%hf==-1_intkind2) .OR. (ex3(i3)%hf==-1_intkind2) .OR. (ex4(i4)%hf==-1_intkind2)  &
    .OR. (ex5(i5)%hf==-1_intkind2)) then
  Hel(n) = -1_intkind2
 else
  Hel(n) = ex1(i1)%hf + ex2(i2)%hf + ex3(i3)%hf + ex4(i4)%hf + ex5(i5)%hf
 end if
end do
end do
end do
end do
end do

end subroutine physical_helicities

subroutine diagrams()
  implicit none
  integer :: h
  ! e.g. call cont_VV(nsync, wf3, wf6, A(:,1), n64, t64, nhel, den(5)) ...

    call Hcont_QA(nsync, wf6(:,2), wf8(:,1), A(:,1), n3(:,115), t3x48(:,:,1), nhel, den(3))
    call Hcont_QA(nsync, wf6(:,2), wf8(:,2), A(:,2), n3(:,116), t3x48(:,:,2), nhel, den(5))
    call Hcont_QA(nsync, wf6(:,2), wf8(:,1), A(:,3), n3(:,117), t3x48(:,:,3), nhel, den(3))
    call Hcont_QA(nsync, wf6(:,4), wf8(:,3), A(:,4), n3(:,118), t3x48(:,:,4), nhel, den(7))
    call Hcont_QA(nsync, wf6(:,4), wf8(:,4), A(:,5), n3(:,119), t3x48(:,:,5), nhel, den(8))
    call Hcont_QA(nsync, wf6(:,4), wf8(:,3), A(:,6), n3(:,120), t3x48(:,:,6), nhel, den(7))
    call Hcont_VV(nsync, wf4(:,3), wf12(:,1), A(:,7), n3(:,121), t3x48(:,:,7), nhel, den(11))
    call Hcont_VV(nsync, wf4(:,4), wf12(:,2), A(:,8), n3(:,122), t3x48(:,:,8), nhel, den(13))
    call Hcont_VV(nsync, wf4(:,3), wf12(:,1), A(:,9), n3(:,123), t3x48(:,:,9), nhel, den(11))
    call Hcont_QA(nsync, wf6(:,4), wf8(:,5), A(:,10), n3(:,124), t3x48(:,:,10), nhel, den(14))
    call Hcont_QA(nsync, wf6(:,4), wf8(:,6), A(:,11), n3(:,125), t3x48(:,:,11), nhel, den(15))
    call Hcont_QA(nsync, wf6(:,4), wf8(:,5), A(:,12), n3(:,126), t3x48(:,:,12), nhel, den(14))
    call Hcont_QA(nsync, wf6(:,2), wf8(:,7), A(:,13), n3(:,127), t3x48(:,:,13), nhel, den(17))
    call Hcont_QA(nsync, wf6(:,2), wf8(:,8), A(:,14), n3(:,128), t3x48(:,:,14), nhel, den(19))
    call Hcont_QA(nsync, wf6(:,2), wf8(:,7), A(:,15), n3(:,129), t3x48(:,:,15), nhel, den(17))
    call Hcont_QA(nsync, wf6(:,8), wf8(:,9), A(:,16), n3(:,130), t3x48(:,:,16), nhel, den(21))
    call Hcont_QA(nsync, wf6(:,8), wf8(:,10), A(:,17), n3(:,131), t3x48(:,:,17), nhel, den(22))
    call Hcont_QA(nsync, wf6(:,8), wf8(:,9), A(:,18), n3(:,132), t3x48(:,:,18), nhel, den(21))
    call Hcont_VV(nsync, wf4(:,7), wf12(:,3), A(:,19), n3(:,133), t3x48(:,:,19), nhel, den(24))
    call Hcont_VV(nsync, wf4(:,8), wf12(:,4), A(:,20), n3(:,134), t3x48(:,:,20), nhel, den(26))
    call Hcont_VV(nsync, wf4(:,7), wf12(:,3), A(:,21), n3(:,135), t3x48(:,:,21), nhel, den(24))
    call Hcont_QA(nsync, wf6(:,8), wf8(:,11), A(:,22), n3(:,136), t3x48(:,:,22), nhel, den(27))
    call Hcont_QA(nsync, wf6(:,8), wf8(:,12), A(:,23), n3(:,137), t3x48(:,:,23), nhel, den(28))
    call Hcont_QA(nsync, wf6(:,8), wf8(:,11), A(:,24), n3(:,138), t3x48(:,:,24), nhel, den(27))

    call Hcont_VV(nsync, wf4(:,7), wf12(:,5), A(:,25), n3(:,139), t3x48(:,:,25), nhel, den(29))
    call Hcont_QA(nsync, wf6(:,2), wf8(:,13), A(:,26), n3(:,140), t3x48(:,:,26), nhel, den(3))
    call Hcont_QA(nsync, wf6(:,2), wf8(:,14), A(:,27), n3(:,141), t3x48(:,:,27), nhel, den(5))
    call Hcont_QA(nsync, wf6(:,2), wf8(:,13), A(:,28), n3(:,142), t3x48(:,:,28), nhel, den(3))
    call Hcont_QA(nsync, wf6(:,2), wf8(:,15), A(:,29), n3(:,143), t3x48(:,:,29), nhel, den(3))
    call Hcont_QA(nsync, wf8(:,3), wf6(:,10), A(:,30), n3(:,144), t3x48(:,:,30), nhel, den(7))
    call Hcont_QA(nsync, wf8(:,4), wf6(:,10), A(:,31), n3(:,145), t3x48(:,:,31), nhel, den(8))
    call Hcont_QA(nsync, wf8(:,3), wf6(:,10), A(:,32), n3(:,146), t3x48(:,:,32), nhel, den(7))
    call Hcont_QA(nsync, wf8(:,3), wf6(:,12), A(:,33), n3(:,147), t3x48(:,:,33), nhel, den(7))
    call Hcont_VV(nsync, wf4(:,3), wf12(:,6), A(:,34), n3(:,148), t3x48(:,:,34), nhel, den(30))
    call Hcont_VV(nsync, wf4(:,3), wf12(:,7), A(:,35), n3(:,149), t3x48(:,:,35), nhel, den(11))
    call Hcont_VV(nsync, wf4(:,4), wf12(:,8), A(:,36), n3(:,150), t3x48(:,:,36), nhel, den(13))
    call Hcont_VV(nsync, wf4(:,3), wf12(:,7), A(:,37), n3(:,151), t3x48(:,:,37), nhel, den(11))
    call Hcont_VV(nsync, wf4(:,3), wf12(:,9), A(:,38), n3(:,152), t3x48(:,:,38), nhel, den(11))
    call Hcont_QA(nsync, wf8(:,5), wf6(:,10), A(:,39), n3(:,153), t3x48(:,:,39), nhel, den(14))
    call Hcont_QA(nsync, wf8(:,6), wf6(:,10), A(:,40), n3(:,154), t3x48(:,:,40), nhel, den(15))
    call Hcont_QA(nsync, wf8(:,5), wf6(:,10), A(:,41), n3(:,155), t3x48(:,:,41), nhel, den(14))
    call Hcont_QA(nsync, wf8(:,5), wf6(:,12), A(:,42), n3(:,156), t3x48(:,:,42), nhel, den(14))
    call Hcont_QA(nsync, wf6(:,2), wf8(:,16), A(:,43), n3(:,157), t3x48(:,:,43), nhel, den(17))
    call Hcont_QA(nsync, wf6(:,2), wf8(:,17), A(:,44), n3(:,158), t3x48(:,:,44), nhel, den(19))
    call Hcont_QA(nsync, wf6(:,2), wf8(:,16), A(:,45), n3(:,159), t3x48(:,:,45), nhel, den(17))
    call Hcont_QA(nsync, wf6(:,2), wf8(:,18), A(:,46), n3(:,160), t3x48(:,:,46), nhel, den(17))
    call Hcont_QA(nsync, wf8(:,9), wf6(:,14), A(:,47), n3(:,161), t3x48(:,:,47), nhel, den(21))
    call Hcont_QA(nsync, wf8(:,10), wf6(:,14), A(:,48), n3(:,162), t3x48(:,:,48), nhel, den(22))
    call Hcont_QA(nsync, wf8(:,9), wf6(:,14), A(:,49), n3(:,163), t3x48(:,:,49), nhel, den(21))
    call Hcont_QA(nsync, wf8(:,9), wf6(:,16), A(:,50), n3(:,164), t3x48(:,:,50), nhel, den(21))
    call Hcont_VV(nsync, wf4(:,7), wf12(:,10), A(:,51), n3(:,165), t3x48(:,:,51), nhel, den(24))
    call Hcont_VV(nsync, wf4(:,8), wf12(:,11), A(:,52), n3(:,166), t3x48(:,:,52), nhel, den(26))
    call Hcont_VV(nsync, wf4(:,7), wf12(:,10), A(:,53), n3(:,167), t3x48(:,:,53), nhel, den(24))
    call Hcont_VV(nsync, wf4(:,7), wf12(:,12), A(:,54), n3(:,168), t3x48(:,:,54), nhel, den(24))
    call Hcont_QA(nsync, wf8(:,11), wf6(:,14), A(:,55), n3(:,169), t3x48(:,:,55), nhel, den(27))
    call Hcont_QA(nsync, wf8(:,12), wf6(:,14), A(:,56), n3(:,170), t3x48(:,:,56), nhel, den(28))
    call Hcont_QA(nsync, wf8(:,11), wf6(:,14), A(:,57), n3(:,171), t3x48(:,:,57), nhel, den(27))
    call Hcont_QA(nsync, wf8(:,11), wf6(:,16), A(:,58), n3(:,172), t3x48(:,:,58), nhel, den(27))
    call Hcont_QA(nsync, wf6(:,4), wf8(:,19), A(:,59), n3(:,173), t3x48(:,:,59), nhel, den(7))
    call Hcont_QA(nsync, wf6(:,4), wf8(:,20), A(:,60), n3(:,174), t3x48(:,:,60), nhel, den(8))
    call Hcont_QA(nsync, wf6(:,4), wf8(:,19), A(:,61), n3(:,175), t3x48(:,:,61), nhel, den(7))
    call Hcont_QA(nsync, wf6(:,4), wf8(:,21), A(:,62), n3(:,176), t3x48(:,:,62), nhel, den(7))
    call Hcont_QA(nsync, wf8(:,1), wf6(:,18), A(:,63), n3(:,177), t3x48(:,:,63), nhel, den(3))
    call Hcont_QA(nsync, wf8(:,2), wf6(:,18), A(:,64), n3(:,178), t3x48(:,:,64), nhel, den(5))
    call Hcont_QA(nsync, wf8(:,1), wf6(:,18), A(:,65), n3(:,179), t3x48(:,:,65), nhel, den(3))
    call Hcont_QA(nsync, wf8(:,1), wf6(:,20), A(:,66), n3(:,180), t3x48(:,:,66), nhel, den(3))
    call Hcont_QA(nsync, wf6(:,8), wf8(:,22), A(:,67), n3(:,181), t3x48(:,:,67), nhel, den(21))
    call Hcont_QA(nsync, wf6(:,8), wf8(:,23), A(:,68), n3(:,182), t3x48(:,:,68), nhel, den(22))
    call Hcont_QA(nsync, wf6(:,8), wf8(:,22), A(:,69), n3(:,183), t3x48(:,:,69), nhel, den(21))
    call Hcont_QA(nsync, wf6(:,8), wf8(:,24), A(:,70), n3(:,184), t3x48(:,:,70), nhel, den(21))
    call Hcont_QA(nsync, wf8(:,7), wf6(:,18), A(:,71), n3(:,185), t3x48(:,:,71), nhel, den(17))
    call Hcont_QA(nsync, wf8(:,8), wf6(:,18), A(:,72), n3(:,186), t3x48(:,:,72), nhel, den(19))
    call Hcont_QA(nsync, wf8(:,7), wf6(:,18), A(:,73), n3(:,187), t3x48(:,:,73), nhel, den(17))
    call Hcont_QA(nsync, wf8(:,7), wf6(:,20), A(:,74), n3(:,188), t3x48(:,:,74), nhel, den(17))
    call Hcont_VV(nsync, wf12(:,3), wf4(:,9), A(:,75), n3(:,189), t3x48(:,:,75), nhel, den(24))
    call Hcont_VV(nsync, wf12(:,4), wf4(:,10), A(:,76), n3(:,190), t3x48(:,:,76), nhel, den(26))
    call Hcont_VV(nsync, wf12(:,3), wf4(:,9), A(:,77), n3(:,191), t3x48(:,:,77), nhel, den(24))
    call Hcont_VV(nsync, wf12(:,3), wf4(:,11), A(:,78), n3(:,192), t3x48(:,:,78), nhel, den(24))
    call Hcont_QA(nsync, wf6(:,8), wf8(:,25), A(:,79), n3(:,193), t3x48(:,:,79), nhel, den(27))
    call Hcont_QA(nsync, wf6(:,8), wf8(:,26), A(:,80), n3(:,194), t3x48(:,:,80), nhel, den(28))
    call Hcont_QA(nsync, wf6(:,8), wf8(:,25), A(:,81), n3(:,195), t3x48(:,:,81), nhel, den(27))
    call Hcont_QA(nsync, wf6(:,8), wf8(:,27), A(:,82), n3(:,196), t3x48(:,:,82), nhel, den(27))
    call Hcont_VV(nsync, wf12(:,1), wf4(:,12), A(:,83), n3(:,197), t3x48(:,:,83), nhel, den(11))
    call Hcont_VV(nsync, wf12(:,2), wf4(:,13), A(:,84), n3(:,198), t3x48(:,:,84), nhel, den(13))
    call Hcont_VV(nsync, wf12(:,1), wf4(:,12), A(:,85), n3(:,199), t3x48(:,:,85), nhel, den(11))
    call Hcont_VV(nsync, wf12(:,1), wf4(:,14), A(:,86), n3(:,200), t3x48(:,:,86), nhel, den(11))
    call Hcont_QA(nsync, wf6(:,4), wf8(:,28), A(:,87), n3(:,201), t3x48(:,:,87), nhel, den(14))
    call Hcont_QA(nsync, wf6(:,4), wf8(:,29), A(:,88), n3(:,202), t3x48(:,:,88), nhel, den(15))
    call Hcont_QA(nsync, wf6(:,4), wf8(:,28), A(:,89), n3(:,203), t3x48(:,:,89), nhel, den(14))
    call Hcont_QA(nsync, wf6(:,4), wf8(:,30), A(:,90), n3(:,204), t3x48(:,:,90), nhel, den(14))
    call Hcont_QA(nsync, wf6(:,4), wf8(:,31), A(:,91), n3(:,205), t3x48(:,:,91), nhel, den(14))
    call Hcont_QA(nsync, wf6(:,4), wf8(:,32), A(:,92), n3(:,206), t3x48(:,:,92), nhel, den(15))
    call Hcont_QA(nsync, wf6(:,4), wf8(:,31), A(:,93), n3(:,207), t3x48(:,:,93), nhel, den(14))
    call Hcont_QA(nsync, wf6(:,4), wf8(:,33), A(:,94), n3(:,208), t3x48(:,:,94), nhel, den(14))
    call Hcont_VV(nsync, wf4(:,3), wf12(:,13), A(:,95), n3(:,209), t3x48(:,:,95), nhel, den(11))
    call Hcont_VV(nsync, wf4(:,4), wf12(:,14), A(:,96), n3(:,210), t3x48(:,:,96), nhel, den(13))
    call Hcont_VV(nsync, wf4(:,3), wf12(:,13), A(:,97), n3(:,211), t3x48(:,:,97), nhel, den(11))
    call Hcont_VV(nsync, wf4(:,3), wf12(:,15), A(:,98), n3(:,212), t3x48(:,:,98), nhel, den(11))
    call Hcont_QA(nsync, wf6(:,8), wf8(:,34), A(:,99), n3(:,213), t3x48(:,:,99), nhel, den(27))
    call Hcont_QA(nsync, wf6(:,8), wf8(:,35), A(:,100), n3(:,214), t3x48(:,:,100), nhel, den(28))
    call Hcont_QA(nsync, wf6(:,8), wf8(:,34), A(:,101), n3(:,215), t3x48(:,:,101), nhel, den(27))
    call Hcont_QA(nsync, wf6(:,8), wf8(:,36), A(:,102), n3(:,216), t3x48(:,:,102), nhel, den(27))
    call Hcont_VV(nsync, wf4(:,7), wf12(:,16), A(:,103), n3(:,217), t3x48(:,:,103), nhel, den(24))
    call Hcont_VV(nsync, wf4(:,8), wf12(:,17), A(:,104), n3(:,218), t3x48(:,:,104), nhel, den(26))
    call Hcont_VV(nsync, wf4(:,7), wf12(:,16), A(:,105), n3(:,219), t3x48(:,:,105), nhel, den(24))
    call Hcont_VV(nsync, wf4(:,7), wf12(:,18), A(:,106), n3(:,220), t3x48(:,:,106), nhel, den(24))
    call Hcont_QA(nsync, wf6(:,2), wf8(:,37), A(:,107), n3(:,221), t3x48(:,:,107), nhel, den(17))
    call Hcont_QA(nsync, wf6(:,2), wf8(:,38), A(:,108), n3(:,222), t3x48(:,:,108), nhel, den(19))
    call Hcont_QA(nsync, wf6(:,2), wf8(:,37), A(:,109), n3(:,223), t3x48(:,:,109), nhel, den(17))
    call Hcont_QA(nsync, wf6(:,2), wf8(:,39), A(:,110), n3(:,224), t3x48(:,:,110), nhel, den(17))
    call Hcont_QA(nsync, wf6(:,8), wf8(:,40), A(:,111), n3(:,225), t3x48(:,:,111), nhel, den(21))
    call Hcont_QA(nsync, wf6(:,8), wf8(:,41), A(:,112), n3(:,226), t3x48(:,:,112), nhel, den(22))
    call Hcont_QA(nsync, wf6(:,8), wf8(:,40), A(:,113), n3(:,227), t3x48(:,:,113), nhel, den(21))
    call Hcont_QA(nsync, wf6(:,8), wf8(:,42), A(:,114), n3(:,228), t3x48(:,:,114), nhel, den(21))
    call Hcont_QA(nsync, wf6(:,2), wf8(:,43), A(:,115), n3(:,229), t3x48(:,:,115), nhel, den(3))
    call Hcont_QA(nsync, wf6(:,2), wf8(:,44), A(:,116), n3(:,230), t3x48(:,:,116), nhel, den(5))
    call Hcont_QA(nsync, wf6(:,2), wf8(:,43), A(:,117), n3(:,231), t3x48(:,:,117), nhel, den(3))
    call Hcont_QA(nsync, wf6(:,2), wf8(:,45), A(:,118), n3(:,232), t3x48(:,:,118), nhel, den(3))
    call Hcont_QA(nsync, wf6(:,4), wf8(:,46), A(:,119), n3(:,233), t3x48(:,:,119), nhel, den(7))
    call Hcont_QA(nsync, wf6(:,4), wf8(:,47), A(:,120), n3(:,234), t3x48(:,:,120), nhel, den(8))
    call Hcont_QA(nsync, wf6(:,4), wf8(:,46), A(:,121), n3(:,235), t3x48(:,:,121), nhel, den(7))
    call Hcont_QA(nsync, wf6(:,4), wf8(:,48), A(:,122), n3(:,236), t3x48(:,:,122), nhel, den(7))
    call Hcont_VV(nsync, wf12(:,19), wf4(:,21), A(:,123), n3(:,237), t3x48(:,:,123), nhel, den(33))
    call Hcont_QA(nsync, wf6(:,25), wf8(:,49), A(:,124), n3(:,238), t3x48(:,:,124), nhel, den(36))
    call Hcont_QA(nsync, wf6(:,25), wf8(:,50), A(:,125), n3(:,239), t3x48(:,:,125), nhel, den(38))
    call Hcont_QA(nsync, wf6(:,25), wf8(:,49), A(:,126), n3(:,240), t3x48(:,:,126), nhel, den(36))
    call Hcont_QA(nsync, wf8(:,49), wf6(:,26), A(:,127), n3(:,241), t3x48(:,:,127), nhel, den(36))
    call Hcont_VV(nsync, wf4(:,21), wf12(:,20), A(:,128), n3(:,242), t3x48(:,:,128), nhel, den(40))
    call Hcont_QA(nsync, wf6(:,27), wf8(:,51), A(:,129), n3(:,243), t3x48(:,:,129), nhel, den(43))
    call Hcont_QA(nsync, wf6(:,27), wf8(:,52), A(:,130), n3(:,244), t3x48(:,:,130), nhel, den(45))
    call Hcont_QA(nsync, wf6(:,27), wf8(:,51), A(:,131), n3(:,245), t3x48(:,:,131), nhel, den(43))
    call Hcont_QA(nsync, wf8(:,51), wf6(:,28), A(:,132), n3(:,246), t3x48(:,:,132), nhel, den(43))
    call Hcont_QA(nsync, wf6(:,29), wf8(:,54), A(:,133), n3(:,247), t3x48(:,:,133), nhel, den(48))
    call Hcont_QA(nsync, wf6(:,29), wf8(:,56), A(:,134), n3(:,248), t3x48(:,:,134), nhel, den(50))
    call Hcont_QA(nsync, wf6(:,29), wf8(:,54), A(:,135), n3(:,249), t3x48(:,:,135), nhel, den(48))
    call Hcont_QA(nsync, wf8(:,54), wf6(:,30), A(:,136), n3(:,250), t3x48(:,:,136), nhel, den(48))
    call Hcont_VV(nsync, wf12(:,1), wf4(:,22), A(:,137), n3(:,251), t3x48(:,:,137), nhel, den(53))
    call Hcont_VV(nsync, wf4(:,22), wf12(:,21), A(:,138), n3(:,252), t3x48(:,:,138), nhel, den(55))
    call Hcont_QA(nsync, wf6(:,27), wf8(:,57), A(:,139), n3(:,253), t3x48(:,:,139), nhel, den(57))
    call Hcont_QA(nsync, wf6(:,27), wf8(:,58), A(:,140), n3(:,254), t3x48(:,:,140), nhel, den(59))
    call Hcont_QA(nsync, wf6(:,27), wf8(:,57), A(:,141), n3(:,255), t3x48(:,:,141), nhel, den(57))
    call Hcont_QA(nsync, wf6(:,28), wf8(:,57), A(:,142), n3(:,256), t3x48(:,:,142), nhel, den(57))
    call Hcont_VV(nsync, wf12(:,22), wf4(:,23), A(:,143), n3(:,257), t3x48(:,:,143), nhel, den(62))
    call Hcont_QA(nsync, wf6(:,25), wf8(:,59), A(:,144), n3(:,258), t3x48(:,:,144), nhel, den(64))
    call Hcont_QA(nsync, wf6(:,25), wf8(:,60), A(:,145), n3(:,259), t3x48(:,:,145), nhel, den(66))
    call Hcont_QA(nsync, wf6(:,25), wf8(:,59), A(:,146), n3(:,260), t3x48(:,:,146), nhel, den(64))
    call Hcont_QA(nsync, wf6(:,26), wf8(:,59), A(:,147), n3(:,261), t3x48(:,:,147), nhel, den(64))
    call Hcont_VV(nsync, wf4(:,23), wf12(:,23), A(:,148), n3(:,262), t3x48(:,:,148), nhel, den(68))
    call Hcont_QA(nsync, wf6(:,31), wf8(:,61), A(:,149), n3(:,263), t3x48(:,:,149), nhel, den(71))
    call Hcont_QA(nsync, wf6(:,31), wf8(:,62), A(:,150), n3(:,264), t3x48(:,:,150), nhel, den(73))
    call Hcont_QA(nsync, wf6(:,31), wf8(:,61), A(:,151), n3(:,265), t3x48(:,:,151), nhel, den(71))
    call Hcont_QA(nsync, wf8(:,61), wf6(:,32), A(:,152), n3(:,266), t3x48(:,:,152), nhel, den(71))
    call Hcont_QA(nsync, wf6(:,29), wf8(:,64), A(:,153), n3(:,267), t3x48(:,:,153), nhel, den(75))
    call Hcont_QA(nsync, wf6(:,29), wf8(:,66), A(:,154), n3(:,268), t3x48(:,:,154), nhel, den(77))
    call Hcont_QA(nsync, wf6(:,29), wf8(:,64), A(:,155), n3(:,269), t3x48(:,:,155), nhel, den(75))
    call Hcont_QA(nsync, wf6(:,30), wf8(:,64), A(:,156), n3(:,270), t3x48(:,:,156), nhel, den(75))
    call Hcont_VV(nsync, wf12(:,3), wf4(:,24), A(:,157), n3(:,271), t3x48(:,:,157), nhel, den(80))
    call Hcont_VV(nsync, wf4(:,24), wf12(:,24), A(:,158), n3(:,272), t3x48(:,:,158), nhel, den(82))
    call Hcont_QA(nsync, wf6(:,31), wf8(:,67), A(:,159), n3(:,273), t3x48(:,:,159), nhel, den(84))
    call Hcont_QA(nsync, wf6(:,31), wf8(:,68), A(:,160), n3(:,274), t3x48(:,:,160), nhel, den(86))
    call Hcont_QA(nsync, wf6(:,31), wf8(:,67), A(:,161), n3(:,275), t3x48(:,:,161), nhel, den(84))
    call Hcont_QA(nsync, wf6(:,32), wf8(:,67), A(:,162), n3(:,276), t3x48(:,:,162), nhel, den(84))

end subroutine diagrams


elemental function diagmap(j, n)
  implicit none
  integer, intent(in) :: j, n
  complex(REALKIND) :: diagmap
  diagmap = A(j,n)%j
end function diagmap

function diagsum(j, pos, neg)
  implicit none
  integer, intent(in) :: j, pos(:), neg(:)
  complex(REALKIND) :: diagsum
  diagsum = sum(diagmap(j, pos)) - sum(diagmap(j, neg))
end function diagsum

subroutine colourvectors(A, j, M1, M2)
  implicit none
  type(Hpolcont) :: A(:,:)
  integer, intent(in) :: j
  type(Hpolcont), intent(out) :: M1(4), M2(4) ! M1helarray(4,48)
  integer :: empty(0), i

  M1(1)%j = (-A(j,7)%j-A(j,10)%j-A(j,13)%j-A(j,16)%j)*f(1)+(-A(j,8)%j-A(j,11)%j-A(j,14)%j-A(j,17)%j)*f(2)
  M1(2)%j = ((A(j,9)%j+A(j,12)%j+A(j,15)%j+A(j,18)%j)*f(3))/6._/**/REALKIND+((A(j,3)%j+A(j,6)%j+A(j,21)%j &
       +A(j,24)%j)*f(3))/2._/**/REALKIND
  M1(3)%j = (A(j,1)%j+A(j,4)%j+A(j,19)%j+A(j,22)%j)*f(1)+(A(j,2)%j+A(j,5)%j+A(j,20)%j+A(j,23)%j)*f(2)
  M1(4)%j = ((-A(j,9)%j-A(j,12)%j-A(j,15)%j-A(j,18)%j)*f(3))/2._/**/REALKIND+((-A(j,3)%j-A(j,6)%j-A(j,21)%j &
       -A(j,24)%j)*f(3))/6._/**/REALKIND

  M2(1)%j = ((-A(j,135)%j-A(j,137)%j-A(j,138)%j-A(j,141)%j-A(j,143)%j-A(j,146)%j-A(j,148)%j-A(j,151)%j)*f(8))/6._/**/REALKIND+(( &
       -A(j,123)%j-A(j,126)%j-A(j,128)%j-A(j,131)%j-A(j,155)%j-A(j,157)%j-A(j,158)%j-A(j,161)%j)*f(8))/2._/**/REALKIND+((A(j,37)%j &
       +A(j,45)%j+A(j,69)%j+A(j,85)%j+A(j,89)%j+A(j,93)%j+A(j,109)%j+A(j,113)%j)*f(9))/6._/**/REALKIND+((A(j,28)%j+A(j,53)%j &
       +A(j,61)%j+A(j,77)%j+A(j,81)%j+A(j,101)%j+A(j,117)%j+A(j,121)%j)*f(9))/2._/**/REALKIND+((A(j,41)%j+A(j,49)%j+A(j,73)%j &
       +A(j,97)%j)*f(10))/6._/**/REALKIND+((A(j,32)%j+A(j,57)%j+A(j,65)%j+A(j,105)%j)*f(10))/2._/**/REALKIND &
       -(A(j,25)%j*f(11))/2._/**/REALKIND-(A(j,34)%j*f(11))/6._/**/REALKIND
  M2(2)%j = (A(j,133)%j+A(j,139)%j+A(j,144)%j+A(j,149)%j)*f(4)+(A(j,134)%j+A(j,140)%j+A(j,145)%j+A(j,150)%j)*f(5)+((A(j,38)%j &
       +A(j,42)%j+A(j,46)%j+A(j,50)%j+A(j,70)%j+A(j,74)%j+A(j,86)%j+A(j,90)%j+A(j,94)%j+A(j,98)%j+A(j,110)%j+A(j,114)%j-A(j,136)%j &
       -A(j,142)%j-A(j,147)%j-A(j,152)%j)*f(5))/6._/**/REALKIND+((A(j,29)%j+A(j,33)%j+A(j,54)%j+A(j,58)%j+A(j,62)%j+A(j,66)%j &
       +A(j,78)%j+A(j,82)%j+A(j,102)%j+A(j,106)%j+A(j,118)%j+A(j,122)%j-A(j,127)%j-A(j,132)%j-A(j,156)%j &
       -A(j,162)%j)*f(5))/2._/**/REALKIND+(-A(j,35)%j-A(j,39)%j-A(j,43)%j-A(j,47)%j-A(j,67)%j-A(j,71)%j-A(j,83)%j-A(j,87)%j &
       -A(j,91)%j-A(j,95)%j-A(j,107)%j-A(j,111)%j)*f(6)+(-A(j,36)%j-A(j,40)%j-A(j,44)%j-A(j,48)%j-A(j,68)%j-A(j,72)%j-A(j,84)%j &
       -A(j,88)%j-A(j,92)%j-A(j,96)%j-A(j,108)%j-A(j,112)%j)*f(7)
  M2(3)%j = ((A(j,135)%j+A(j,137)%j+A(j,138)%j+A(j,141)%j+A(j,143)%j+A(j,146)%j+A(j,148)%j+A(j,151)%j)*f(8))/2._/**/REALKIND &
       +((A(j,123)%j+A(j,126)%j+A(j,128)%j+A(j,131)%j+A(j,155)%j+A(j,157)%j+A(j,158)%j+A(j,161)%j)*f(8))/6._/**/REALKIND+(( &
       -A(j,37)%j-A(j,45)%j-A(j,69)%j-A(j,85)%j-A(j,89)%j-A(j,93)%j-A(j,109)%j-A(j,113)%j)*f(9))/2._/**/REALKIND+((-A(j,28)%j &
       -A(j,53)%j-A(j,61)%j-A(j,77)%j-A(j,81)%j-A(j,101)%j-A(j,117)%j-A(j,121)%j)*f(9))/6._/**/REALKIND+((-A(j,41)%j-A(j,49)%j &
       -A(j,73)%j-A(j,97)%j)*f(10))/2._/**/REALKIND+((-A(j,32)%j-A(j,57)%j-A(j,65)%j-A(j,105)%j)*f(10))/6._/**/REALKIND &
       +(A(j,25)%j*f(11))/6._/**/REALKIND+(A(j,34)%j*f(11))/2._/**/REALKIND
  M2(4)%j = (-A(j,124)%j-A(j,129)%j-A(j,153)%j-A(j,159)%j)*f(4)+((-A(j,38)%j-A(j,42)%j-A(j,46)%j-A(j,50)%j-A(j,70)%j-A(j,74)%j &
       -A(j,86)%j-A(j,90)%j-A(j,94)%j-A(j,98)%j-A(j,110)%j-A(j,114)%j+A(j,136)%j+A(j,142)%j+A(j,147)%j &
       +A(j,152)%j)*f(5))/2._/**/REALKIND+(-A(j,125)%j-A(j,130)%j-A(j,154)%j-A(j,160)%j)*f(5)+((-A(j,29)%j-A(j,33)%j-A(j,54)%j &
       -A(j,58)%j-A(j,62)%j-A(j,66)%j-A(j,78)%j-A(j,82)%j-A(j,102)%j-A(j,106)%j-A(j,118)%j-A(j,122)%j+A(j,127)%j+A(j,132)%j &
       +A(j,156)%j+A(j,162)%j)*f(5))/6._/**/REALKIND+(A(j,26)%j+A(j,30)%j+A(j,51)%j+A(j,55)%j+A(j,59)%j+A(j,63)%j+A(j,75)%j &
       +A(j,79)%j+A(j,99)%j+A(j,103)%j+A(j,115)%j+A(j,119)%j)*f(6)+(A(j,27)%j+A(j,31)%j+A(j,52)%j+A(j,56)%j+A(j,60)%j+A(j,64)%j &
       +A(j,76)%j+A(j,80)%j+A(j,100)%j+A(j,104)%j+A(j,116)%j+A(j,120)%j)*f(7)


  M1(:)%hf = Hel(j)
  M2(:)%hf = Hel(j)

  !M(i) corresponds to \Gamma_{i} in Fabios thesis

end subroutine colourvectors


! **********************************************************************
subroutine colint(M, M2colint)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppzjj_ew_uuuxuxz_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(4)
  real(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

    do i = 1, 4
      do j = 1, 4
        M2colint = M2colint + real(conjg(M(i))*K1(i,j)*M(j))
      end do
    end do

end subroutine colint

! **********************************************************************
subroutine colint_ct(M, Mct, M2colint_ct, l)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppzjj_ew_uuuxuxz_1_/**/REALKIND, only: K2
  implicit none
  complex(REALKIND), intent(in)  :: M(4), Mct(4)
  real(REALKIND),    intent(out) :: M2colint_ct
  integer, intent(in) :: l
  integer ::  i, j

  M2colint_ct = 0

  do i = 1, 4
    do j = 1, 4
      M2colint_ct = M2colint_ct + real(conjg(M(i))*K2(i+4*l,j)*Mct(j))
    end do
  end do

end subroutine colint_ct

! **********************************************************************
subroutine colint_IR(M, M2IRadd)
! M(i)   = <M|Ci> colour component of matrix element
! K1(i,j) = .....
! **********************************************************************
  use ol_colourmatrix_ppzjj_ew_uuuxuxz_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(4)
  real(REALKIND),    intent(out) :: M2IRadd(16)
  integer ::  i, j, k, colmatpos

  M2IRadd = 0

  do k = 1, 17-1
    colmatpos = 4*k
    do i = 1, 4
      do j = 1, 4
        M2IRadd(k) = M2IRadd(k) + real(conjg(M(i))*K1(i+colmatpos,j)*M(j))
      end do
    end do
  end do

end subroutine colint_IR

! **********************************************************************
subroutine colintmunu(M1, M2, M2colint)
! M1(i)    = <M1|Ci> colour component of matrix element
! M2(i)    = <M2|Ci> colour component of matrix element
! M2colint = <M1|M2>
!          = Sum_{i,j} <M1|Ci> * <Ci|Cj> * <Cj|M2>
!          = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppzjj_ew_uuuxuxz_1_/**/REALKIND, only: K2
  implicit none

  complex(REALKIND), intent(in)  :: M1(4)
  complex(REALKIND), intent(in)  :: M2(4)
  complex(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

  do i = 1, 4
    do j = 1, 4
      M2colint = M2colint + M1(i)*K2(i,j)*conjg(M2(j))
    end do
  end do

end subroutine colintmunu





! **********************************************************************
subroutine colborninterf(M, M0_col, l)
! M(i)         = <M|Ci> colour component of matrix element
! M0_col(i)    = <M2|Ci> colour component of matrix element,
!                see \tilde{M}_{j} in Fabios thesis
! M2colint = Sum_{i} <M1|Ci> * <Ci|Cj>
!          = colour-summed squared matrix element
! KL(i,j) = <Ci|Cj> with elements Cj of 1-loop colour basis
! **********************************************************************
  use ol_colourmatrix_ppzjj_ew_uuuxuxz_1_/**/REALKIND, only: KL
  implicit none

  type(Hpolcont), intent(in)  :: M(4)
  type(Hpolcont), intent(out)  :: M0_col(4)
  integer, intent(in) :: l
  integer :: i, j

  do j = 1, 4 !size(KL(1,:))
    M0_col(j)%j = 0
    M0_col(j)%hf = M(1)%hf
    do i = 1, 4 !size(KL(:,1))
      M0_col(j)%j = M0_col(j)%j  + conjg(M(i)%j)*KL(i+4*l,j)
    end do
  end do

end subroutine colborninterf

end subroutine amp2

end module ol_loop_ppzjj_ew_uuuxuxz_1_/**/REALKIND
