
module ol_vamp_2_ppzjj_uuxzgg_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_2(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppzjj_uuxzgg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppzjj_uuxzgg_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_ppzjj_uuxzgg_1_/**/DREALKIND
  use ol_tensor_sum_storage_ppzjj_uuxzgg_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_ppzjj_uuxzgg_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_ppzjj_uuxzgg_1_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(48)
  type(Hpolcont), intent(in) :: M(3,48)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel
#endif

  ! =============================================
  call Hotf_4pt_reduction_last(G1tensor(151),RedSet_4(22),mass4set(:,1),  & 
G0tensor(160),G0tensor(161),G0tensor(162),G0tensor(163),G0tensor(164))
  call Hotf_4pt_reduction_last(G1tensor(156),RedSet_4(25),mass4set(:,1),  & 
G0tensor(165),G0tensor(166),G0tensor(167),G0tensor(168),G0tensor(169))
  call Hotf_4pt_reduction_last(G1tensor(161),RedSet_4(28),mass4set(:,1),  & 
G0tensor(170),G0tensor(171),G0tensor(172),G0tensor(173),G0tensor(174))
  call Hotf_4pt_reduction_last(G1tensor(166),RedSet_4(33),mass4set(:,1),  & 
G0tensor(175),G0tensor(176),G0tensor(177),G0tensor(178),G0tensor(179))
  call Hotf_4pt_reduction_last(G1tensor(171),RedSet_4(34),mass4set(:,1),  & 
G0tensor(180),G0tensor(181),G0tensor(182),G0tensor(183),G0tensor(184))
  call Hotf_4pt_reduction_last(G1tensor(176),RedSet_4(36),mass4set(:,1),  & 
G0tensor(185),G0tensor(186),G0tensor(187),G0tensor(188),G0tensor(189))
  call Hotf_4pt_reduction_last(G1tensor(181),RedSet_4(38),mass4set(:,1),  & 
G0tensor(190),G0tensor(191),G0tensor(192),G0tensor(193),G0tensor(194))
  call Hotf_4pt_reduction_last(G1tensor(186),RedSet_4(39),mass4set(:,1),  & 
G0tensor(195),G0tensor(196),G0tensor(197),G0tensor(198),G0tensor(199))
  call Hotf_4pt_reduction_last(G1tensor(191),RedSet_4(41),mass4set(:,1),  & 
G0tensor(200),G0tensor(201),G0tensor(202),G0tensor(203),G0tensor(204))
  call Hotf_4pt_reduction_last(G1tensor(196),RedSet_4(42),mass4set(:,1),  & 
G0tensor(205),G0tensor(206),G0tensor(207),G0tensor(208),G0tensor(209))
  call Hotf_4pt_reduction_last(G1tensor(201),RedSet_4(44),mass4set(:,1),  & 
G0tensor(210),G0tensor(211),G0tensor(212),G0tensor(213),G0tensor(214))
  call Hotf_4pt_reduction_last(G1tensor(206),RedSet_4(45),mass4set(:,1),  & 
G0tensor(215),G0tensor(216),G0tensor(217),G0tensor(218),G0tensor(219))
  call Hotf_4pt_reduction_last(G1tensor(211),RedSet_4(33),mass4set(:,2),  & 
G0tensor(220),G0tensor(221),G0tensor(222),G0tensor(223),G0tensor(224))
  call Hotf_4pt_reduction_last(G1tensor(252),RedSet_4(33),mass4set(:,3),  & 
G0tensor(225),G0tensor(226),G0tensor(227),G0tensor(228),G0tensor(229))
  call Hotf_4pt_reduction_last(G1tensor(257),RedSet_4(28),mass4set(:,2),  & 
G0tensor(230),G0tensor(231),G0tensor(232),G0tensor(233),G0tensor(234))
  call Hotf_4pt_reduction_last(G1tensor(262),RedSet_4(28),mass4set(:,3),  & 
G0tensor(235),G0tensor(236),G0tensor(237),G0tensor(238),G0tensor(239))
  call Hotf_4pt_reduction_last(G1tensor(267),RedSet_4(25),mass4set(:,2),  & 
G0tensor(240),G0tensor(241),G0tensor(242),G0tensor(243),G0tensor(244))
  call Hotf_4pt_reduction_last(G1tensor(272),RedSet_4(25),mass4set(:,3),  & 
G0tensor(245),G0tensor(246),G0tensor(247),G0tensor(248),G0tensor(249))
  call ol_merge_tensors(T0sum(1),[G0tensor(10)])
  call ol_merge_tensors(T0sum(2),[G0tensor(15)])
  call ol_merge_tensors(T0sum(3),[G0tensor(20)])
  call ol_merge_tensors(T0sum(4),[G0tensor(25)])
  call ol_merge_tensors(T0sum(5),[G0tensor(30)])
  call ol_merge_tensors(T0sum(6),[G0tensor(35)])
  call ol_merge_tensors(T0sum(7),[G0tensor(40)])
  call ol_merge_tensors(T0sum(8),[G0tensor(45)])
  call ol_merge_tensors(T0sum(9),[G0tensor(50)])
  call ol_merge_tensors(T0sum(10),[G0tensor(55)])
  call ol_merge_tensors(T0sum(11),[G0tensor(60)])
  call ol_merge_tensors(T0sum(12),[G0tensor(65)])
  call ol_merge_tensors(T0sum(13),[G0tensor(70)])
  call ol_merge_tensors(T0sum(14),[G0tensor(75)])
  call ol_merge_tensors(T0sum(15),[G0tensor(80)])
  call ol_merge_tensors(T0sum(16),[G0tensor(85)])
  call ol_merge_tensors(T0sum(17),[G0tensor(90)])
  call ol_merge_tensors(T0sum(18),[G0tensor(95)])
  call ol_merge_tensors(T0sum(19),[G0tensor(100)])
  call ol_merge_tensors(T0sum(20),[G0tensor(105)])
  call ol_merge_tensors(T0sum(21),[G0tensor(110)])
  call ol_merge_tensors(T0sum(22),[G0tensor(115)])
  call ol_merge_tensors(T0sum(23),[G0tensor(120)])
  call ol_merge_tensors(T0sum(24),[G0tensor(125)])
  call ol_merge_tensors(T0sum(25),[G0tensor(130)])
  call ol_merge_tensors(T0sum(26),[G0tensor(135)])
  call ol_merge_tensors(T0sum(27),[G0tensor(140)])
  call ol_merge_tensors(T0sum(28),[G0tensor(145)])
  call ol_merge_tensors(T0sum(29),[G0tensor(150)])
  call ol_merge_tensors(T0sum(30),[G0tensor(155)])
  call ol_merge_tensors(T0sum(31),[G0tensor(160)])
  call ol_merge_tensors(T0sum(32),[G0tensor(165)])
  call ol_merge_tensors(T0sum(33),[G0tensor(170)])
  call ol_merge_tensors(T0sum(34),[G0tensor(175)])
  call ol_merge_tensors(T0sum(35),[G0tensor(180)])
  call ol_merge_tensors(T0sum(36),[G0tensor(185)])
  call ol_merge_tensors(T0sum(37),[G0tensor(190)])
  call ol_merge_tensors(T0sum(38),[G0tensor(195)])
  call ol_merge_tensors(T0sum(39),[G0tensor(200)])
  call ol_merge_tensors(T0sum(40),[G0tensor(205)])
  call ol_merge_tensors(T0sum(41),[G0tensor(210)])
  call ol_merge_tensors(T0sum(42),[G0tensor(215)])
  call ol_merge_tensors(T0sum(43),[G0tensor(1)])
  call ol_merge_tensors(T0sum(44),[G0tensor(2)])
  call ol_merge_tensors(T0sum(45),[G0tensor(3)])
  call ol_merge_tensors(T0sum(46),[G0tensor(4)])
  call ol_merge_tensors(T0sum(47),[G0tensor(5)])
  call ol_merge_tensors(T0sum(48),[G0tensor(6)])
  call ol_merge_tensors(T0sum(49),[G0tensor(7)])
  call ol_merge_tensors(T0sum(50),[G0tensor(8)])
  call ol_merge_tensors(T0sum(51),[G0tensor(9)])
  call ol_merge_tensors(T0sum(52),[G0tensor(220)])
  call ol_merge_tensors(T0sum(53),[G0tensor(225)])
  call ol_merge_tensors(T0sum(54),[G0tensor(230)])
  call ol_merge_tensors(T0sum(55),[G0tensor(235)])
  call ol_merge_tensors(T0sum(56),[G0tensor(240)])
  call ol_merge_tensors(T0sum(57),[G0tensor(245)])
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)-c(9)*M(3,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(67),h0tab(:,67),[24,2,5],[0,0,0],4,1,wf6(:,2))
  call Hloop_GGG_G_12(ntryL,G0H48(1),ex5(:),ex4(:),G0H12(8),m4h2x2x12(:,4),heltab3x48(:,:,4))
  Gcoeff(:)%j = (-(c(11)*M(2,:)%j)-c(9)*M(3,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(68),h0tab(:,68),[24,2,5],[0,0,0],4,1,wf6(:,2))
  call Hloop_GGG_G_12(ntryL,G0H48(1),ex4(:),ex5(:),G0H12(3),m4h2x2x12(:,5),heltab3x48(:,:,5))
  Gcoeff(:)%j = (c(11)*(M(1,:)%j-M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(69),h0tab(:,69),[24,2,5],[0,0,0],4,1,wf6(:,2))
  call Hloop_GGG_G_23(ntryL,G0H48(1),ex5(:),ex4(:),G0H12(2),m4h2x2x12(:,6),heltab3x48(:,:,6))
  Gcoeff(:)%j = (-(c(11)*M(2,:)%j)-c(9)*M(3,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(70),h0tab(:,70),[24,1,6],[0,0,0],4,1,wf6(:,4))
  call Hloop_GGG_G_12(ntryL,G0H48(1),ex5(:),ex4(:),G0H12(1),m4h2x2x12(:,7),heltab3x48(:,:,7))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)-c(9)*M(3,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(71),h0tab(:,71),[24,1,6],[0,0,0],4,1,wf6(:,4))
  call Hloop_GGG_G_12(ntryL,G0H48(1),ex4(:),ex5(:),G0H12(4),m4h2x2x12(:,8),heltab3x48(:,:,8))
  Gcoeff(:)%j = (c(11)*(-M(1,:)%j+M(2,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(72),h0tab(:,72),[24,1,6],[0,0,0],4,1,wf6(:,4))
  call Hloop_GGG_G_23(ntryL,G0H48(1),ex5(:),ex4(:),G0H12(5),m4h2x2x12(:,9),heltab3x48(:,:,9))
  Gcoeff(:)%j = (c(13)*(-M(1,:)%j+M(2,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(73),h0tab(:,73),[24,3,4],[0,0,0],3,2,wf4(:,5),wf4(:,10))
  call Hloop_QV_A(ntryL,G0H48(1),wf4(:,5),G0H12(6),m3h4x12(:,10),heltab2x48(:,:,64))
  call Hloop_Q_A(ntryL,G0H12(6),24,0,G1H12(14),n2h12(23))
  Gcoeff(:)%j = (c(12)*(-M(1,:)%j+M(2,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(74),h0tab(:,74),[24,3,4],[nMT,nMT,nMT],3,2,wf4(:,5),wf4(:,10))
  call Hloop_QV_A(ntryL,G0H48(1),wf4(:,5),G0H12(7),m3h4x12(:,11),heltab2x48(:,:,65))
  call Hloop_Q_A(ntryL,G0H12(7),24,nMT,G1H12(15),n2h12(24))
  Gcoeff(:)%j = (c(13)*(-M(1,:)%j+M(2,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(75),h0tab(:,75),[24,3,4],[0,0,0],3,2,wf4(:,5),wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H48(1),wf4(:,5),G0H12(6),m3h4x12(:,12),heltab2x48(:,:,66))
  call Hloop_A_Q(ntryL,G0H12(6),24,0,G1H12(19),n2h12(25))
  Gcoeff(:)%j = (c(12)*(-M(1,:)%j+M(2,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(76),h0tab(:,76),[24,3,4],[nMT,nMT,nMT],3,2,wf4(:,5),wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H48(1),wf4(:,5),G0H12(7),m3h4x12(:,13),heltab2x48(:,:,67))
  call Hloop_A_Q(ntryL,G0H12(7),24,nMT,G1H12(20),n2h12(26))
  Gcoeff(:)%j = (c(13)*(-M(1,:)%j+M(2,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(77),h0tab(:,77),[24,3,4],[0,0,0],3,2,wf4(:,5),wf4(:,10))
  call Hloop_QV_A(ntryL,G0H48(1),wf4(:,5),G0H12(6),m3h4x12(:,14),heltab2x48(:,:,68))
  call Hloop_Q_A(ntryL,G0H12(6),24,0,G1H12(22),n2h12(27))
  Gcoeff(:)%j = (c(12)*(-M(1,:)%j+M(2,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(78),h0tab(:,78),[24,3,4],[nMB,nMB,nMB],3,2,wf4(:,5),wf4(:,10))
  call Hloop_QV_A(ntryL,G0H48(1),wf4(:,5),G0H12(7),m3h4x12(:,15),heltab2x48(:,:,69))
  call Hloop_Q_A(ntryL,G0H12(7),24,nMB,G1H12(23),n2h12(28))
  Gcoeff(:)%j = (c(13)*(-M(1,:)%j+M(2,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(79),h0tab(:,79),[24,3,4],[0,0,0],3,2,wf4(:,5),wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H48(1),wf4(:,5),G0H12(6),m3h4x12(:,16),heltab2x48(:,:,70))
  call Hloop_A_Q(ntryL,G0H12(6),24,0,G1H12(2),n2h12(29))
  Gcoeff(:)%j = (c(12)*(-M(1,:)%j+M(2,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(80),h0tab(:,80),[24,3,4],[nMB,nMB,nMB],3,2,wf4(:,5),wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H48(1),wf4(:,5),G0H12(7),m3h4x12(:,17),heltab2x48(:,:,71))
  call Hloop_A_Q(ntryL,G0H12(7),24,nMB,G1H12(10),n2h12(30))
  Gcoeff(:)%j = (c(13)*(-M(1,:)%j+M(2,:)%j)) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(81),h0tab(:,81),[16,4,11],[0,0,0],3,1,wf8(:,3))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,55),heltab2x48(:,:,72))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(1),n2h24(43))
  Gcoeff(:)%j = (c(12)*(-M(1,:)%j+M(2,:)%j)) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(82),h0tab(:,82),[16,4,11],[nMT,nMT,nMT],3,1,wf8(:,3))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,56),heltab2x48(:,:,73))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMT,G1H24(2),n2h24(44))
  Gcoeff(:)%j = (c(13)*(-M(1,:)%j+M(2,:)%j)) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(83),h0tab(:,83),[16,4,11],[0,0,0],3,1,wf8(:,3))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,57),heltab2x48(:,:,74))
  call Hloop_A_Q(ntryL,G0H24(1),16,0,G1H24(3),n2h24(45))
  Gcoeff(:)%j = (c(12)*(-M(1,:)%j+M(2,:)%j)) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(84),h0tab(:,84),[16,4,11],[nMT,nMT,nMT],3,1,wf8(:,3))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,58),heltab2x48(:,:,75))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMT,G1H24(4),n2h24(46))
  Gcoeff(:)%j = (c(13)*(-M(1,:)%j+M(2,:)%j)) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(85),h0tab(:,85),[16,4,11],[0,0,0],3,1,wf8(:,3))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,59),heltab2x48(:,:,76))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(5),n2h24(47))
  Gcoeff(:)%j = (c(12)*(-M(1,:)%j+M(2,:)%j)) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(86),h0tab(:,86),[16,4,11],[nMB,nMB,nMB],3,1,wf8(:,3))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,60),heltab2x48(:,:,77))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMB,G1H24(6),n2h24(48))
  Gcoeff(:)%j = (c(13)*(-M(1,:)%j+M(2,:)%j)) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(87),h0tab(:,87),[16,4,11],[0,0,0],3,1,wf8(:,3))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,61),heltab2x48(:,:,78))
  call Hloop_A_Q(ntryL,G0H24(1),16,0,G1H24(7),n2h24(49))
  Gcoeff(:)%j = (c(12)*(-M(1,:)%j+M(2,:)%j)) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(88),h0tab(:,88),[16,4,11],[nMB,nMB,nMB],3,1,wf8(:,3))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,62),heltab2x48(:,:,79))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMB,G1H24(8),n2h24(50))
  Gcoeff(:)%j = (c(13)*(M(1,:)%j-M(2,:)%j)) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(89),h0tab(:,89),[19,4,8],[0,0,0],3,1,wf8(:,4))
  call Hloop_AV_Q(ntryL,G0H48(1),wf8(:,4),G0H6(1),m3h8x6(:,1),heltab2x48(:,:,80))
  call Hloop_A_Q(ntryL,G0H6(1),19,0,G1H6(13),n2h6(66))
  Gcoeff(:)%j = (c(12)*(M(1,:)%j-M(2,:)%j)) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(90),h0tab(:,90),[19,4,8],[nMT,nMT,nMT],3,1,wf8(:,4))
  call Hloop_AV_Q(ntryL,G0H48(1),wf8(:,4),G0H6(2),m3h8x6(:,2),heltab2x48(:,:,81))
  call Hloop_A_Q(ntryL,G0H6(2),19,nMT,G1H6(14),n2h6(67))
  Gcoeff(:)%j = (c(13)*(M(1,:)%j-M(2,:)%j)) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(91),h0tab(:,91),[19,4,8],[0,0,0],3,1,wf8(:,4))
  call Hloop_QV_A(ntryL,G0H48(1),wf8(:,4),G0H6(3),m3h8x6(:,3),heltab2x48(:,:,82))
  call Hloop_Q_A(ntryL,G0H6(3),19,0,G1H6(15),n2h6(68))
  Gcoeff(:)%j = (c(12)*(M(1,:)%j-M(2,:)%j)) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(92),h0tab(:,92),[19,4,8],[nMT,nMT,nMT],3,1,wf8(:,4))
  call Hloop_QV_A(ntryL,G0H48(1),wf8(:,4),G0H6(4),m3h8x6(:,4),heltab2x48(:,:,83))
  call Hloop_Q_A(ntryL,G0H6(4),19,nMT,G1H6(16),n2h6(69))
  Gcoeff(:)%j = (c(13)*(M(1,:)%j-M(2,:)%j)) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(93),h0tab(:,93),[19,4,8],[0,0,0],3,1,wf8(:,4))
  call Hloop_AV_Q(ntryL,G0H48(1),wf8(:,4),G0H6(5),m3h8x6(:,5),heltab2x48(:,:,84))
  call Hloop_A_Q(ntryL,G0H6(5),19,0,G1H6(20),n2h6(70))
  Gcoeff(:)%j = (c(12)*(M(1,:)%j-M(2,:)%j)) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(94),h0tab(:,94),[19,4,8],[nMB,nMB,nMB],3,1,wf8(:,4))
  call Hloop_AV_Q(ntryL,G0H48(1),wf8(:,4),G0H6(6),m3h8x6(:,6),heltab2x48(:,:,85))
  call Hloop_A_Q(ntryL,G0H6(6),19,nMB,G1H6(21),n2h6(71))
  Gcoeff(:)%j = (c(13)*(M(1,:)%j-M(2,:)%j)) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(95),h0tab(:,95),[19,4,8],[0,0,0],3,1,wf8(:,4))
  call Hloop_QV_A(ntryL,G0H48(1),wf8(:,4),G0H6(7),m3h8x6(:,7),heltab2x48(:,:,86))
  call Hloop_Q_A(ntryL,G0H6(7),19,0,G1H6(22),n2h6(72))
  Gcoeff(:)%j = (c(12)*(M(1,:)%j-M(2,:)%j)) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(96),h0tab(:,96),[19,4,8],[nMB,nMB,nMB],3,1,wf8(:,4))
  call Hloop_QV_A(ntryL,G0H48(1),wf8(:,4),G0H6(8),m3h8x6(:,8),heltab2x48(:,:,87))
  call Hloop_Q_A(ntryL,G0H6(8),19,nMB,G1H6(25),n2h6(73))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(97),h0tab(:,97),[16,5,10],[0,0,0],3,2,wf6(:,2),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,63),heltab2x48(:,:,88))
  call Hloop_A_Q(ntryL,G0H24(1),16,0,G1H24(9),n2h24(51))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(98),h0tab(:,98),[16,5,10],[0,0,0],3,2,wf6(:,2),wf4(:,2))
  call Hloop_UV_W(ntryL,G0H48(1),0,ex5(:),16,G1H24(10),m3h2x24(:,64),heltab2x48(:,:,89))
  Gcoeff(:)%j = (c(8)*M(2,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(99),h0tab(:,99),[18,5,8],[0,0,0],3,2,wf4(:,4),wf6(:,2))
  call Hloop_QA_V(ntryL,G0H48(1),wf4(:,4),G0H12(6),m3h4x12(:,18),heltab2x48(:,:,90))
  Gcoeff(:)%j = (-(c(6)*M(2,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(100),h0tab(:,100),[18,5,8],[0,0,0],3,2,wf4(:,4),wf6(:,2))
  call Hloop_VA_Q(ntryL,G0H48(1),wf4(:,4),G0H12(7),m3h4x12(:,19),heltab2x48(:,:,91))
  call Hloop_A_Q(ntryL,G0H12(7),18,0,G1H12(1),n2h12(31))
  Gcoeff(:)%j = (c(3)*(-M(1,:)%j+M(2,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(101),h0tab(:,101),[24,2,5],[0,0,0],3,2,wf4(:,5),wf6(:,2))
  call Hloop_QV_A(ntryL,G0H48(1),wf4(:,5),G0H12(7),m3h4x12(:,20),heltab2x48(:,:,92))
  call Hloop_Q_A(ntryL,G0H12(7),24,0,G1H12(7),n2h12(32))
  Gcoeff(:)%j = (c(11)*(M(1,:)%j-M(2,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(102),h0tab(:,102),[24,2,5],[0,0,0],3,2,wf4(:,5),wf6(:,2))
  call Hloop_UV_W(ntryL,G0H48(1),0,wf4(:,5),24,G1H12(21),m3h4x12(:,21),heltab2x48(:,:,93))
  Gcoeff(:)%j = (c(17)*M(1,:)%j-c(16)*M(3,:)%j) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(103),h0tab(:,103),[16,7,8],[0,0,0],3,1,wf12(:,3))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,65),heltab2x48(:,:,94))
  call Hloop_A_Q(ntryL,G0H24(1),16,0,G1H24(11),n2h24(52))
  Gcoeff(:)%j = (c(15)*M(1,:)%j-c(14)*M(3,:)%j) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(104),h0tab(:,104),[16,7,8],[nMT,nMT,nMT],3,1,wf12(:,3))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,66),heltab2x48(:,:,95))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMT,G1H24(12),n2h24(53))
  Gcoeff(:)%j = (c(17)*M(2,:)%j-c(16)*M(3,:)%j) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(105),h0tab(:,105),[16,7,8],[0,0,0],3,1,wf12(:,3))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,67),heltab2x48(:,:,96))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(13),n2h24(54))
  Gcoeff(:)%j = (c(15)*M(2,:)%j-c(14)*M(3,:)%j) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(106),h0tab(:,106),[16,7,8],[nMT,nMT,nMT],3,1,wf12(:,3))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,68),heltab2x48(:,:,97))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMT,G1H24(14),n2h24(55))
  Gcoeff(:)%j = (c(17)*M(1,:)%j-c(16)*M(3,:)%j) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(107),h0tab(:,107),[16,7,8],[0,0,0],3,1,wf12(:,3))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,69),heltab2x48(:,:,98))
  call Hloop_A_Q(ntryL,G0H24(1),16,0,G1H24(15),n2h24(56))
  Gcoeff(:)%j = (c(15)*M(1,:)%j-c(14)*M(3,:)%j) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(108),h0tab(:,108),[16,7,8],[nMB,nMB,nMB],3,1,wf12(:,3))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,70),heltab2x48(:,:,99))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMB,G1H24(16),n2h24(57))
  Gcoeff(:)%j = (c(17)*M(2,:)%j-c(16)*M(3,:)%j) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(109),h0tab(:,109),[16,7,8],[0,0,0],3,1,wf12(:,3))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,71),heltab2x48(:,:,100))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(17),n2h24(58))
  Gcoeff(:)%j = (c(15)*M(2,:)%j-c(14)*M(3,:)%j) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(110),h0tab(:,110),[16,7,8],[nMB,nMB,nMB],3,1,wf12(:,3))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,72),heltab2x48(:,:,101))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMB,G1H24(18),n2h24(59))
  Gcoeff(:)%j = (c(6)*(-M(1,:)%j+M(2,:)%j)) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(111),h0tab(:,111),[16,7,8],[0,0,0],3,1,wf12(:,3))
  call Hloop_DV_C(ntryL,G0H48(1),0,ex5(:),G1H24(19),m3h2x24(:,73),heltab2x48(:,:,102))
  Gcoeff(:)%j = (c(6)*(M(1,:)%j-M(2,:)%j)) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(112),h0tab(:,112),[16,7,8],[0,0,0],3,1,wf12(:,3))
  call Hloop_CV_D(ntryL,G0H48(1),0,ex5(:),16,G1H24(20),m3h2x24(:,74),heltab2x48(:,:,103))
  Gcoeff(:)%j = (c(6)*(M(1,:)%j-M(2,:)%j)) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(113),h0tab(:,113),[16,7,8],[0,0,0],3,1,wf12(:,3))
  call Hloop_UV_W(ntryL,G0H48(1),0,ex5(:),16,G1H24(21),m3h2x24(:,75),heltab2x48(:,:,104))
  Gcoeff(:)%j = (c(8)*M(2,:)%j) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(114),h0tab(:,114),[16,2,13],[0,0,0],3,1,wf12(:,23))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,76),heltab2x48(:,:,105))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(22),n2h24(60))
  Gcoeff(:)%j = (-(c(6)*M(2,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(115),h0tab(:,115),[16,2,13],[0,0,0],3,1,wf12(:,23))
  call Hloop_UV_W(ntryL,G0H48(1),0,ex5(:),16,G1H24(23),m3h2x24(:,77),heltab2x48(:,:,106))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(116),h0tab(:,116),[21,2,8],[0,0,0],3,1,wf12(:,22))
  call Hloop_AQ_V(ntryL,G0H48(1),wf12(:,22),G0H4(1),m3h12x4(:,1),heltab2x48(:,:,107))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(117),h0tab(:,117),[21,2,8],[0,0,0],3,1,wf12(:,22))
  call Hloop_VQ_A(ntryL,G0H48(1),wf12(:,22),G0H4(2),m3h12x4(:,2),heltab2x48(:,:,108))
  call Hloop_Q_A(ntryL,G0H4(2),21,0,G1H4(26),n2h4(31))
  Gcoeff(:)%j = (c(8)*M(2,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(118),h0tab(:,118),[16,6,9],[0,0,0],3,2,wf6(:,4),wf4(:,7))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,78),heltab2x48(:,:,109))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(24),n2h24(61))
  Gcoeff(:)%j = (-(c(6)*M(2,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(119),h0tab(:,119),[16,6,9],[0,0,0],3,2,wf6(:,4),wf4(:,7))
  call Hloop_UV_W(ntryL,G0H48(1),0,ex5(:),16,G1H24(25),m3h2x24(:,79),heltab2x48(:,:,110))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(120),h0tab(:,120),[17,6,8],[0,0,0],3,2,wf4(:,9),wf6(:,4))
  call Hloop_AQ_V(ntryL,G0H48(1),wf4(:,9),G0H12(7),m3h4x12(:,22),heltab2x48(:,:,111))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(121),h0tab(:,121),[17,6,8],[0,0,0],3,2,wf4(:,9),wf6(:,4))
  call Hloop_VQ_A(ntryL,G0H48(1),wf4(:,9),G0H12(9),m3h4x12(:,23),heltab2x48(:,:,112))
  call Hloop_Q_A(ntryL,G0H12(9),17,0,G1H12(8),n2h12(33))
  Gcoeff(:)%j = (c(3)*(-M(1,:)%j+M(2,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(122),h0tab(:,122),[24,1,6],[0,0,0],3,2,wf4(:,5),wf6(:,4))
  call Hloop_AV_Q(ntryL,G0H48(1),wf4(:,5),G0H12(9),m3h4x12(:,24),heltab2x48(:,:,113))
  call Hloop_A_Q(ntryL,G0H12(9),24,0,G1H12(5),n2h12(34))
  Gcoeff(:)%j = (c(11)*(-M(1,:)%j+M(2,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(123),h0tab(:,123),[24,1,6],[0,0,0],3,2,wf4(:,5),wf6(:,4))
  call Hloop_UV_W(ntryL,G0H48(1),0,wf4(:,5),24,G1H12(12),m3h4x12(:,25),heltab2x48(:,:,114))
  Gcoeff(:)%j = (c(17)*M(1,:)%j-c(16)*M(3,:)%j) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(124),h0tab(:,124),[16,7,8],[0,0,0],3,1,wf12(:,4))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,80),heltab2x48(:,:,115))
  call Hloop_A_Q(ntryL,G0H24(1),16,0,G1H24(26),n2h24(62))
  Gcoeff(:)%j = (c(15)*M(1,:)%j-c(14)*M(3,:)%j) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(125),h0tab(:,125),[16,7,8],[nMT,nMT,nMT],3,1,wf12(:,4))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,81),heltab2x48(:,:,116))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMT,G1H24(27),n2h24(63))
  Gcoeff(:)%j = (c(17)*M(2,:)%j-c(16)*M(3,:)%j) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(126),h0tab(:,126),[16,7,8],[0,0,0],3,1,wf12(:,4))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,82),heltab2x48(:,:,117))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(28),n2h24(64))
  Gcoeff(:)%j = (c(15)*M(2,:)%j-c(14)*M(3,:)%j) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(127),h0tab(:,127),[16,7,8],[nMT,nMT,nMT],3,1,wf12(:,4))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,83),heltab2x48(:,:,118))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMT,G1H24(29),n2h24(65))
  Gcoeff(:)%j = (c(17)*M(1,:)%j-c(16)*M(3,:)%j) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(128),h0tab(:,128),[16,7,8],[0,0,0],3,1,wf12(:,4))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,84),heltab2x48(:,:,119))
  call Hloop_A_Q(ntryL,G0H24(1),16,0,G1H24(30),n2h24(66))
  Gcoeff(:)%j = (c(15)*M(1,:)%j-c(14)*M(3,:)%j) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(129),h0tab(:,129),[16,7,8],[nMB,nMB,nMB],3,1,wf12(:,4))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,85),heltab2x48(:,:,120))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMB,G1H24(31),n2h24(67))
  Gcoeff(:)%j = (c(17)*M(2,:)%j-c(16)*M(3,:)%j) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(130),h0tab(:,130),[16,7,8],[0,0,0],3,1,wf12(:,4))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,86),heltab2x48(:,:,121))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(32),n2h24(68))
  Gcoeff(:)%j = (c(15)*M(2,:)%j-c(14)*M(3,:)%j) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(131),h0tab(:,131),[16,7,8],[nMB,nMB,nMB],3,1,wf12(:,4))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,87),heltab2x48(:,:,122))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMB,G1H24(33),n2h24(69))
  Gcoeff(:)%j = (c(6)*(-M(1,:)%j+M(2,:)%j)) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(132),h0tab(:,132),[16,7,8],[0,0,0],3,1,wf12(:,4))
  call Hloop_DV_C(ntryL,G0H48(1),0,ex5(:),G1H24(34),m3h2x24(:,88),heltab2x48(:,:,123))
  Gcoeff(:)%j = (c(6)*(M(1,:)%j-M(2,:)%j)) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(133),h0tab(:,133),[16,7,8],[0,0,0],3,1,wf12(:,4))
  call Hloop_CV_D(ntryL,G0H48(1),0,ex5(:),16,G1H24(35),m3h2x24(:,89),heltab2x48(:,:,124))
  Gcoeff(:)%j = (c(6)*(M(1,:)%j-M(2,:)%j)) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(134),h0tab(:,134),[16,7,8],[0,0,0],3,1,wf12(:,4))
  call Hloop_UV_W(ntryL,G0H48(1),0,ex5(:),16,G1H24(36),m3h2x24(:,90),heltab2x48(:,:,125))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(135),h0tab(:,135),[16,1,14],[0,0,0],3,1,wf12(:,27))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,91),heltab2x48(:,:,126))
  call Hloop_A_Q(ntryL,G0H24(1),16,0,G1H24(37),n2h24(70))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(136),h0tab(:,136),[16,1,14],[0,0,0],3,1,wf12(:,27))
  call Hloop_UV_W(ntryL,G0H48(1),0,ex5(:),16,G1H24(38),m3h2x24(:,92),heltab2x48(:,:,127))
  Gcoeff(:)%j = (c(8)*M(2,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(137),h0tab(:,137),[22,1,8],[0,0,0],3,1,wf12(:,25))
  call Hloop_QA_V(ntryL,G0H48(1),wf12(:,25),G0H4(2),m3h12x4(:,3),heltab2x48(:,:,128))
  Gcoeff(:)%j = (-(c(6)*M(2,:)%j)) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(138),h0tab(:,138),[22,1,8],[0,0,0],3,1,wf12(:,25))
  call Hloop_VA_Q(ntryL,G0H48(1),wf12(:,25),G0H4(3),m3h12x4(:,4),heltab2x48(:,:,129))
  call Hloop_A_Q(ntryL,G0H4(3),22,0,G1H4(27),n2h4(32))
  Gcoeff(:)%j = (-(c(10)*M(2,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(139),h0tab(:,139),[18,4,9],[0,0,0],3,2,wf4(:,4),wf4(:,7))
  call Hloop_VA_Q(ntryL,G0H48(1),wf4(:,4),G0H12(9),m3h4x12(:,26),heltab2x48(:,:,130))
  call Hloop_A_Q(ntryL,G0H12(9),18,0,G1H12(17),n2h12(35))
  Gcoeff(:)%j = (c(17)*M(2,:)%j) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(140),h0tab(:,140),[16,4,11],[0,0,0],3,1,wf8(:,7))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,93),heltab2x48(:,:,131))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(39),n2h24(71))
  Gcoeff(:)%j = (c(15)*M(2,:)%j) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(141),h0tab(:,141),[16,4,11],[nMT,nMT,nMT],3,1,wf8(:,7))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,94),heltab2x48(:,:,132))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMT,G1H24(40),n2h24(72))
  Gcoeff(:)%j = (c(17)*M(2,:)%j) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(142),h0tab(:,142),[16,4,11],[0,0,0],3,1,wf8(:,7))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,95),heltab2x48(:,:,133))
  call Hloop_A_Q(ntryL,G0H24(1),16,0,G1H24(41),n2h24(73))
  Gcoeff(:)%j = (c(15)*M(2,:)%j) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(143),h0tab(:,143),[16,4,11],[nMT,nMT,nMT],3,1,wf8(:,7))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,96),heltab2x48(:,:,134))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMT,G1H24(42),n2h24(74))
  Gcoeff(:)%j = (c(17)*M(2,:)%j) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(144),h0tab(:,144),[16,4,11],[0,0,0],3,1,wf8(:,7))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,97),heltab2x48(:,:,135))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(43),n2h24(75))
  Gcoeff(:)%j = (c(15)*M(2,:)%j) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(145),h0tab(:,145),[16,4,11],[nMB,nMB,nMB],3,1,wf8(:,7))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,98),heltab2x48(:,:,136))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMB,G1H24(44),n2h24(76))
  Gcoeff(:)%j = (c(17)*M(2,:)%j) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(146),h0tab(:,146),[16,4,11],[0,0,0],3,1,wf8(:,7))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,99),heltab2x48(:,:,137))
  call Hloop_A_Q(ntryL,G0H24(1),16,0,G1H24(45),n2h24(77))
  Gcoeff(:)%j = (c(15)*M(2,:)%j) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(147),h0tab(:,147),[16,4,11],[nMB,nMB,nMB],3,1,wf8(:,7))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,100),heltab2x48(:,:,138))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMB,G1H24(46),n2h24(78))
  Gcoeff(:)%j = (c(8)*M(2,:)%j) * den(59)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(148),h0tab(:,148),[16,2,13],[0,0,0],3,1,wf12(:,30))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,101),heltab2x48(:,:,139))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(47),n2h24(79))
  Gcoeff(:)%j = (-(c(6)*M(2,:)%j)) * den(59)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(149),h0tab(:,149),[16,2,13],[0,0,0],3,1,wf12(:,30))
  call Hloop_UV_W(ntryL,G0H48(1),0,ex5(:),16,G1H24(48),m3h2x24(:,102),heltab2x48(:,:,140))
  Gcoeff(:)%j = (-(c(10)*M(2,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(150),h0tab(:,150),[25,2,4],[0,0,0],3,1,wf8(:,19))
  call Hloop_AQ_V(ntryL,G0H48(1),wf8(:,19),G0H6(9),m3h8x6(:,9),heltab2x48(:,:,141))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(151),h0tab(:,151),[17,4,10],[0,0,0],3,2,wf4(:,9),wf4(:,2))
  call Hloop_VQ_A(ntryL,G0H48(1),wf4(:,9),G0H12(9),m3h4x12(:,27),heltab2x48(:,:,142))
  call Hloop_Q_A(ntryL,G0H12(9),17,0,G1H12(18),n2h12(36))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(152),h0tab(:,152),[16,4,11],[0,0,0],3,1,wf8(:,8))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,103),heltab2x48(:,:,143))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(49),n2h24(80))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(153),h0tab(:,153),[16,4,11],[nMT,nMT,nMT],3,1,wf8(:,8))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,104),heltab2x48(:,:,144))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMT,G1H24(50),n2h24(81))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(154),h0tab(:,154),[16,4,11],[0,0,0],3,1,wf8(:,8))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,105),heltab2x48(:,:,145))
  call Hloop_A_Q(ntryL,G0H24(1),16,0,G1H24(51),n2h24(82))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(155),h0tab(:,155),[16,4,11],[nMT,nMT,nMT],3,1,wf8(:,8))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,106),heltab2x48(:,:,146))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMT,G1H24(52),n2h24(83))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(156),h0tab(:,156),[16,4,11],[0,0,0],3,1,wf8(:,8))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,107),heltab2x48(:,:,147))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(53),n2h24(84))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(157),h0tab(:,157),[16,4,11],[nMB,nMB,nMB],3,1,wf8(:,8))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,108),heltab2x48(:,:,148))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMB,G1H24(54),n2h24(85))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(158),h0tab(:,158),[16,4,11],[0,0,0],3,1,wf8(:,8))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,109),heltab2x48(:,:,149))
  call Hloop_A_Q(ntryL,G0H24(1),16,0,G1H24(55),n2h24(86))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(159),h0tab(:,159),[16,4,11],[nMB,nMB,nMB],3,1,wf8(:,8))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,110),heltab2x48(:,:,150))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMB,G1H24(56),n2h24(87))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(160),h0tab(:,160),[16,1,14],[0,0,0],3,1,wf12(:,32))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,111),heltab2x48(:,:,151))
  call Hloop_A_Q(ntryL,G0H24(1),16,0,G1H24(57),n2h24(88))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(161),h0tab(:,161),[16,1,14],[0,0,0],3,1,wf12(:,32))
  call Hloop_UV_W(ntryL,G0H48(1),0,ex5(:),16,G1H24(58),m3h2x24(:,112),heltab2x48(:,:,152))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(162),h0tab(:,162),[26,1,4],[0,0,0],3,1,wf8(:,14))
  call Hloop_QA_V(ntryL,G0H48(1),wf8(:,14),G0H6(10),m3h8x6(:,10),heltab2x48(:,:,153))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(163),h0tab(:,163),[19,4,8],[0,0,0],3,1,wf8(:,9))
  call Hloop_AV_Q(ntryL,G0H48(1),wf8(:,9),G0H6(11),m3h8x6(:,11),heltab2x48(:,:,154))
  call Hloop_A_Q(ntryL,G0H6(11),19,0,G1H6(5),n2h6(74))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(164),h0tab(:,164),[19,4,8],[nMT,nMT,nMT],3,1,wf8(:,9))
  call Hloop_AV_Q(ntryL,G0H48(1),wf8(:,9),G0H6(12),m3h8x6(:,12),heltab2x48(:,:,155))
  call Hloop_A_Q(ntryL,G0H6(12),19,nMT,G1H6(31),n2h6(75))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(165),h0tab(:,165),[19,4,8],[0,0,0],3,1,wf8(:,9))
  call Hloop_QV_A(ntryL,G0H48(1),wf8(:,9),G0H6(13),m3h8x6(:,13),heltab2x48(:,:,156))
  call Hloop_Q_A(ntryL,G0H6(13),19,0,G1H6(11),n2h6(76))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(166),h0tab(:,166),[19,4,8],[nMT,nMT,nMT],3,1,wf8(:,9))
  call Hloop_QV_A(ntryL,G0H48(1),wf8(:,9),G0H6(14),m3h8x6(:,14),heltab2x48(:,:,157))
  call Hloop_Q_A(ntryL,G0H6(14),19,nMT,G1H6(32),n2h6(77))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(167),h0tab(:,167),[19,4,8],[0,0,0],3,1,wf8(:,9))
  call Hloop_AV_Q(ntryL,G0H48(1),wf8(:,9),G0H6(15),m3h8x6(:,15),heltab2x48(:,:,158))
  call Hloop_A_Q(ntryL,G0H6(15),19,0,G1H6(6),n2h6(78))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(168),h0tab(:,168),[19,4,8],[nMB,nMB,nMB],3,1,wf8(:,9))
  call Hloop_AV_Q(ntryL,G0H48(1),wf8(:,9),G0H6(16),m3h8x6(:,16),heltab2x48(:,:,159))
  call Hloop_A_Q(ntryL,G0H6(16),19,nMB,G1H6(12),n2h6(79))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(169),h0tab(:,169),[19,4,8],[0,0,0],3,1,wf8(:,9))
  call Hloop_QV_A(ntryL,G0H48(1),wf8(:,9),G0H6(1),m3h8x6(:,17),heltab2x48(:,:,160))
  call Hloop_Q_A(ntryL,G0H6(1),19,0,G1H6(17),n2h6(80))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(170),h0tab(:,170),[19,4,8],[nMB,nMB,nMB],3,1,wf8(:,9))
  call Hloop_QV_A(ntryL,G0H48(1),wf8(:,9),G0H6(2),m3h8x6(:,18),heltab2x48(:,:,161))
  call Hloop_Q_A(ntryL,G0H6(2),19,nMB,G1H6(18),n2h6(81))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(171),h0tab(:,171),[21,2,8],[0,0,0],3,1,wf12(:,33))
  call Hloop_AQ_V(ntryL,G0H48(1),wf12(:,33),G0H4(3),m3h12x4(:,5),heltab2x48(:,:,162))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(172),h0tab(:,172),[21,2,8],[0,0,0],3,1,wf12(:,33))
  call Hloop_VQ_A(ntryL,G0H48(1),wf12(:,33),G0H4(4),m3h12x4(:,6),heltab2x48(:,:,163))
  call Hloop_Q_A(ntryL,G0H4(4),21,0,G1H4(8),n2h4(33))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(173),h0tab(:,173),[25,2,4],[0,0,0],3,1,wf8(:,20))
  call Hloop_AQ_V(ntryL,G0H48(1),wf8(:,20),G0H6(3),m3h8x6(:,19),heltab2x48(:,:,164))
  Gcoeff(:)%j = (c(17)*M(2,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(174),h0tab(:,174),[19,4,8],[0,0,0],3,1,wf8(:,10))
  call Hloop_AV_Q(ntryL,G0H48(1),wf8(:,10),G0H6(4),m3h8x6(:,20),heltab2x48(:,:,165))
  call Hloop_A_Q(ntryL,G0H6(4),19,0,G1H6(24),n2h6(82))
  Gcoeff(:)%j = (c(15)*M(2,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(175),h0tab(:,175),[19,4,8],[nMT,nMT,nMT],3,1,wf8(:,10))
  call Hloop_AV_Q(ntryL,G0H48(1),wf8(:,10),G0H6(5),m3h8x6(:,21),heltab2x48(:,:,166))
  call Hloop_A_Q(ntryL,G0H6(5),19,nMT,G1H6(41),n2h6(83))
  Gcoeff(:)%j = (c(17)*M(2,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(176),h0tab(:,176),[19,4,8],[0,0,0],3,1,wf8(:,10))
  call Hloop_QV_A(ntryL,G0H48(1),wf8(:,10),G0H6(6),m3h8x6(:,22),heltab2x48(:,:,167))
  call Hloop_Q_A(ntryL,G0H6(6),19,0,G1H6(1),n2h6(84))
  Gcoeff(:)%j = (c(15)*M(2,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(177),h0tab(:,177),[19,4,8],[nMT,nMT,nMT],3,1,wf8(:,10))
  call Hloop_QV_A(ntryL,G0H48(1),wf8(:,10),G0H6(7),m3h8x6(:,23),heltab2x48(:,:,168))
  call Hloop_Q_A(ntryL,G0H6(7),19,nMT,G1H6(2),n2h6(85))
  Gcoeff(:)%j = (c(17)*M(2,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(178),h0tab(:,178),[19,4,8],[0,0,0],3,1,wf8(:,10))
  call Hloop_AV_Q(ntryL,G0H48(1),wf8(:,10),G0H6(8),m3h8x6(:,24),heltab2x48(:,:,169))
  call Hloop_A_Q(ntryL,G0H6(8),19,0,G1H6(28),n2h6(86))
  Gcoeff(:)%j = (c(15)*M(2,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(179),h0tab(:,179),[19,4,8],[nMB,nMB,nMB],3,1,wf8(:,10))
  call Hloop_AV_Q(ntryL,G0H48(1),wf8(:,10),G0H6(11),m3h8x6(:,25),heltab2x48(:,:,170))
  call Hloop_A_Q(ntryL,G0H6(11),19,nMB,G1H6(29),n2h6(87))
  Gcoeff(:)%j = (c(17)*M(2,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(180),h0tab(:,180),[19,4,8],[0,0,0],3,1,wf8(:,10))
  call Hloop_QV_A(ntryL,G0H48(1),wf8(:,10),G0H6(12),m3h8x6(:,26),heltab2x48(:,:,171))
  call Hloop_Q_A(ntryL,G0H6(12),19,0,G1H6(30),n2h6(88))
  Gcoeff(:)%j = (c(15)*M(2,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(181),h0tab(:,181),[19,4,8],[nMB,nMB,nMB],3,1,wf8(:,10))
  call Hloop_QV_A(ntryL,G0H48(1),wf8(:,10),G0H6(13),m3h8x6(:,27),heltab2x48(:,:,172))
  call Hloop_Q_A(ntryL,G0H6(13),19,nMB,G1H6(35),n2h6(89))
  Gcoeff(:)%j = (c(8)*M(2,:)%j) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(182),h0tab(:,182),[22,1,8],[0,0,0],3,1,wf12(:,29))
  call Hloop_QA_V(ntryL,G0H48(1),wf12(:,29),G0H4(4),m3h12x4(:,7),heltab2x48(:,:,173))
  Gcoeff(:)%j = (-(c(6)*M(2,:)%j)) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(183),h0tab(:,183),[22,1,8],[0,0,0],3,1,wf12(:,29))
  call Hloop_VA_Q(ntryL,G0H48(1),wf12(:,29),G0H4(5),m3h12x4(:,8),heltab2x48(:,:,174))
  call Hloop_A_Q(ntryL,G0H4(5),22,0,G1H4(11),n2h4(34))
  Gcoeff(:)%j = (-(c(10)*M(2,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(184),h0tab(:,184),[26,1,4],[0,0,0],3,1,wf8(:,16))
  call Hloop_QA_V(ntryL,G0H48(1),wf8(:,16),G0H6(14),m3h8x6(:,28),heltab2x48(:,:,175))
  Gcoeff(:)%j = (c(5)*(M(1,:)%j-M(2,:)%j)) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(185),h0tab(:,185),[25,2,4],[0,0,0],3,1,wf8(:,22))
  call Hloop_AQ_V(ntryL,G0H48(1),wf8(:,22),G0H6(15),m3h8x6(:,29),heltab2x48(:,:,176))
  Gcoeff(:)%j = (c(5)*(M(1,:)%j-M(2,:)%j)) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(186),h0tab(:,186),[26,1,4],[0,0,0],3,1,wf8(:,18))
  call Hloop_QA_V(ntryL,G0H48(1),wf8(:,18),G0H6(16),m3h8x6(:,30),heltab2x48(:,:,177))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(23),[G1H6(3),G1H6(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(20),[G1H4(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(1),[G1H6(11),G1H6(15),G1H6(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(24),[G1H6(5),G1H6(13),G1H6(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(41),[G1H6(31),G1H6(14),G1H6(75)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(2),[G1H6(32),G1H6(16),G1H6(80)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(28),[G1H6(6),G1H6(20),G1H6(85)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(29),[G1H6(12),G1H6(21),G1H6(90)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(30),[G1H6(17),G1H6(22),G1H6(95)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(35),[G1H6(18),G1H6(25),G1H6(100)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(17),[G1H12(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(18),[G1H12(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(21),[G0H12(2),G0H12(3),G0H12(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(12),[G0H12(5),G0H12(4),G0H12(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H24(15),[G1H24(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H24(17),[G1H24(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(3),[G0H4(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(8),[G1H4(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H24(30),[G1H24(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H24(32),[G1H24(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(4),[G0H4(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(11),[G1H4(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H6(15),[G0H6(3),G0H6(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H6(16),[G0H6(14),G0H6(10)])
  call Hloop_AZ_Q(ntryL,G1H6(39),ex3(:),G1H2(32),ngZu,m3h3x2(:,74),heltab2x6(:,:,153))
  call Hloop_A_Q(ntryL,G1H2(32),30,0,G2H2(2),n2h2(113))
  call Hloop_QZ_A(ntryL,G1H6(23),ex3(:),G1H2(48),ngZu,m3h3x2(:,75),heltab2x6(:,:,154))
  call Hloop_Q_A(ntryL,G1H2(48),29,0,G2H2(5),n2h2(114))
  call Hloop_QV_A(ntryL,G1H4(20),ex4(:),G1H2(54),m3h2x2(:,43),heltab2x4(:,:,53))
  call Hloop_Q_A(ntryL,G1H2(54),29,0,G2H2(9),n2h2(115))
  call Hloop_QZ_A(ntryL,G1H6(1),ex3(:),G1H2(66),ngZu,m3h3x2(:,76),heltab2x6(:,:,155))
  call Hloop_Q_A(ntryL,G1H2(66),23,0,G2H2(12),n2h2(116))
  call Hloop_QV_A(ntryL,G1H6(19),ex4(:),G1H3(43),m3h2x3(:,70),heltab2x6(:,:,156))
  call Hloop_Q_A(ntryL,G1H3(43),27,0,G2H3(15),n2h3(55))
  call Hloop_AZ_Q(ntryL,G1H6(24),ex3(:),G1H2(20),ngZu,m3h3x2(:,77),heltab2x6(:,:,157))
  call Hloop_A_Q(ntryL,G1H2(20),23,0,G2H2(16),n2h2(117))
  call Hloop_AV_Q(ntryL,G1H6(42),ex4(:),G1H3(4),m3h2x3(:,71),heltab2x6(:,:,158))
  call Hloop_A_Q(ntryL,G1H3(4),27,0,G2H3(10),n2h3(56))
  call Hloop_QV_A(ntryL,G1H6(27),ex4(:),G1H3(10),m3h2x3(:,72),heltab2x6(:,:,159))
  call Hloop_Q_A(ntryL,G1H3(10),27,nMT,G2H3(3),n2h3(57))
  call Hloop_AV_Q(ntryL,G1H6(36),ex4(:),G1H3(32),m3h2x3(:,73),heltab2x6(:,:,160))
  call Hloop_A_Q(ntryL,G1H3(32),27,nMT,G2H3(16),n2h3(58))
  call Hloop_QV_A(ntryL,G1H6(55),ex4(:),G1H3(33),m3h2x3(:,74),heltab2x6(:,:,161))
  call Hloop_Q_A(ntryL,G1H3(33),27,0,G2H3(13),n2h3(59))
  call Hloop_QV_A(ntryL,G1H6(60),ex4(:),G1H3(30),m3h2x3(:,75),heltab2x6(:,:,162))
  call Hloop_Q_A(ntryL,G1H3(30),27,nMB,G2H3(7),n2h3(60))
  call Hloop_AV_Q(ntryL,G1H6(65),ex4(:),G1H3(19),m3h2x3(:,76),heltab2x6(:,:,163))
  call Hloop_A_Q(ntryL,G1H3(19),27,0,G2H3(1),n2h3(61))
  call Hloop_AV_Q(ntryL,G1H6(70),ex4(:),G1H3(6),m3h2x3(:,77),heltab2x6(:,:,164))
  call Hloop_A_Q(ntryL,G1H3(6),27,nMB,G2H3(12),n2h3(62))
  call Hloop_AZ_Q(ntryL,G1H6(41),ex3(:),G1H2(53),ngZu,m3h3x2(:,78),heltab2x6(:,:,165))
  call Hloop_A_Q(ntryL,G1H2(53),23,nMT,G2H2(10),n2h2(118))
  call Hloop_QZ_A(ntryL,G1H6(2),ex3(:),G1H2(21),ngZu,m3h3x2(:,79),heltab2x6(:,:,166))
  call Hloop_Q_A(ntryL,G1H2(21),23,nMT,G2H2(20),n2h2(119))
  call Hloop_AZ_Q(ntryL,G1H6(28),ex3(:),G1H2(22),ngZd,m3h3x2(:,80),heltab2x6(:,:,167))
  call Hloop_A_Q(ntryL,G1H2(22),23,0,G2H2(6),n2h2(120))
  call Hloop_AZ_Q(ntryL,G1H6(29),ex3(:),G1H2(26),ngZd,m3h3x2(:,81),heltab2x6(:,:,168))
  call Hloop_A_Q(ntryL,G1H2(26),23,nMB,G2H2(26),n2h2(121))
  call Hloop_QZ_A(ntryL,G1H6(30),ex3(:),G1H2(30),ngZd,m3h3x2(:,82),heltab2x6(:,:,169))
  call Hloop_Q_A(ntryL,G1H2(30),23,0,G2H2(33),n2h2(122))
  call Hloop_QZ_A(ntryL,G1H6(35),ex3(:),G1H2(41),ngZd,m3h3x2(:,83),heltab2x6(:,:,170))
  call Hloop_Q_A(ntryL,G1H2(41),23,nMB,G2H2(29),n2h2(123))
  call Hloop_QV_A(ntryL,G1H8(3),wf4(:,10),G1H2(52),m3h4x2(:,25),heltab2x8(:,:,35))
  call Hloop_Q_A(ntryL,G1H2(52),23,0,G2H2(28),n2h2(124))
  call Hloop_QV_A(ntryL,G1H8(8),wf4(:,10),G1H2(28),m3h4x2(:,26),heltab2x8(:,:,36))
  call Hloop_Q_A(ntryL,G1H2(28),23,nMT,G2H2(53),n2h2(125))
  call Hloop_AV_Q(ntryL,G1H8(13),wf4(:,10),G1H2(39),m3h4x2(:,27),heltab2x8(:,:,37))
  call Hloop_A_Q(ntryL,G1H2(39),23,0,G2H2(55),n2h2(126))
  call Hloop_AV_Q(ntryL,G1H8(18),wf4(:,10),G1H2(1),m3h4x2(:,28),heltab2x8(:,:,38))
  call Hloop_A_Q(ntryL,G1H2(1),23,nMT,G2H2(57),n2h2(127))
  call Hloop_QV_A(ntryL,G1H8(23),wf4(:,10),G1H2(7),m3h4x2(:,29),heltab2x8(:,:,39))
  call Hloop_Q_A(ntryL,G1H2(7),23,nMB,G2H2(59),n2h2(128))
  call Hloop_AV_Q(ntryL,G1H8(28),wf4(:,10),G1H2(17),m3h4x2(:,30),heltab2x8(:,:,40))
  call Hloop_A_Q(ntryL,G1H2(17),23,nMB,G2H2(19),n2h2(129))
  call Hloop_AV_Q(ntryL,G1H12(24),ex4(:),G1H6(47),m3h2x6(:,31),heltab2x12(:,:,62))
  call Hloop_A_Q(ntryL,G1H6(47),26,0,G2H6(12),n2h6(90))
  call Hloop_QV_A(ntryL,G1H12(16),ex4(:),G1H6(48),m3h2x6(:,32),heltab2x12(:,:,63))
  call Hloop_Q_A(ntryL,G1H6(48),25,0,G2H6(14),n2h6(91))
  call Hloop_AZ_Q(ntryL,G1H12(17),ex3(:),G1H4(13),ngZu,m3h3x4(:,22),heltab2x12(:,:,64))
  call Hloop_A_Q(ntryL,G1H4(13),22,0,G2H4(10),n2h4(35))
  call Hloop_QZ_A(ntryL,G1H12(18),ex3(:),G1H4(14),ngZu,m3h3x4(:,23),heltab2x12(:,:,65))
  call Hloop_Q_A(ntryL,G1H4(14),21,0,G2H4(11),n2h4(36))
  call Hloop_VA_Q(ntryL,G1H12(21),ex2(:),G1H6(52),m3h2x6(:,33),heltab2x12(:,:,66))
  call Hloop_A_Q(ntryL,G1H6(52),26,0,G2H6(2),n2h6(92))
  call Hloop_VQ_A(ntryL,G1H12(12),ex1(:),G1H6(53),m3h2x6(:,34),heltab2x12(:,:,67))
  call Hloop_Q_A(ntryL,G1H6(53),25,0,G2H6(9),n2h6(93))
  call Hloop_QV_A(ntryL,G1H12(14),wf4(:,10),G1H3(1),m3h4x3(:,5),heltab2x12(:,:,68))
  call Hloop_Q_A(ntryL,G1H3(1),27,0,G2H3(5),n2h3(63))
  call Hloop_QV_A(ntryL,G1H12(15),wf4(:,10),G1H3(13),m3h4x3(:,6),heltab2x12(:,:,69))
  call Hloop_Q_A(ntryL,G1H3(13),27,nMT,G2H3(14),n2h3(64))
  call Hloop_AV_Q(ntryL,G1H12(19),wf4(:,10),G1H3(14),m3h4x3(:,7),heltab2x12(:,:,70))
  call Hloop_A_Q(ntryL,G1H3(14),27,0,G2H3(2),n2h3(65))
  call Hloop_AV_Q(ntryL,G1H12(20),wf4(:,10),G1H3(17),m3h4x3(:,8),heltab2x12(:,:,71))
  call Hloop_A_Q(ntryL,G1H3(17),27,nMT,G2H3(18),n2h3(66))
  call Hloop_QV_A(ntryL,G1H12(22),wf4(:,10),G1H3(25),m3h4x3(:,9),heltab2x12(:,:,72))
  call Hloop_Q_A(ntryL,G1H3(25),27,0,G2H3(20),n2h3(67))
  call Hloop_QV_A(ntryL,G1H12(23),wf4(:,10),G1H3(28),m3h4x3(:,10),heltab2x12(:,:,73))
  call Hloop_Q_A(ntryL,G1H3(28),27,nMB,G2H3(4),n2h3(68))
  call Hloop_AV_Q(ntryL,G1H12(2),wf4(:,10),G1H3(29),m3h4x3(:,11),heltab2x12(:,:,74))
  call Hloop_A_Q(ntryL,G1H3(29),27,0,G2H3(22),n2h3(69))
  call Hloop_AV_Q(ntryL,G1H12(10),wf4(:,10),G1H3(48),m3h4x3(:,12),heltab2x12(:,:,75))
  call Hloop_A_Q(ntryL,G1H3(48),27,nMB,G2H3(24),n2h3(70))
  call Hloop_QZ_A(ntryL,G1H24(1),ex3(:),G1H8(1),ngZu,m3h3x8(:,13),heltab2x24(:,:,55))
  call Hloop_Q_A(ntryL,G1H8(1),20,0,G2H8(6),n2h8(19))
  call Hloop_QZ_A(ntryL,G1H24(2),ex3(:),G1H8(2),ngZu,m3h3x8(:,14),heltab2x24(:,:,56))
  call Hloop_Q_A(ntryL,G1H8(2),20,nMT,G2H8(8),n2h8(20))
  call Hloop_AZ_Q(ntryL,G1H24(3),ex3(:),G1H8(4),ngZu,m3h3x8(:,15),heltab2x24(:,:,57))
  call Hloop_A_Q(ntryL,G1H8(4),20,0,G2H8(9),n2h8(21))
  call Hloop_AZ_Q(ntryL,G1H24(4),ex3(:),G1H8(5),ngZu,m3h3x8(:,16),heltab2x24(:,:,58))
  call Hloop_A_Q(ntryL,G1H8(5),20,nMT,G2H8(10),n2h8(22))
  call Hloop_QZ_A(ntryL,G1H24(5),ex3(:),G1H8(6),ngZd,m3h3x8(:,17),heltab2x24(:,:,59))
  call Hloop_Q_A(ntryL,G1H8(6),20,0,G2H8(1),n2h8(23))
  call Hloop_QZ_A(ntryL,G1H24(6),ex3(:),G1H8(7),ngZd,m3h3x8(:,18),heltab2x24(:,:,60))
  call Hloop_Q_A(ntryL,G1H8(7),20,nMB,G2H8(3),n2h8(24))
  call Hloop_AZ_Q(ntryL,G1H24(7),ex3(:),G1H8(9),ngZd,m3h3x8(:,19),heltab2x24(:,:,61))
  call Hloop_A_Q(ntryL,G1H8(9),20,0,G2H8(5),n2h8(25))
  call Hloop_AZ_Q(ntryL,G1H24(8),ex3(:),G1H8(10),ngZd,m3h3x8(:,20),heltab2x24(:,:,62))
  call Hloop_A_Q(ntryL,G1H8(10),20,nMB,G2H8(2),n2h8(26))
  call Hloop_AQ_V(ntryL,G1H24(9),wf6(:,2),G1H4(19),m3h6x4(:,5),heltab2x24(:,:,63))
  call Hloop_VQ_A(ntryL,G1H24(10),wf6(:,2),G1H4(24),m3h6x4(:,6),heltab2x24(:,:,64))
  call Hloop_Q_A(ntryL,G1H4(24),21,0,G2H4(9),n2h4(37))
  call Hloop_VQ_A(ntryL,G0H12(6),wf6(:,2),G0H2(1),m3h6x2(:,7),heltab2x12(:,:,76))
  call Hloop_Q_A(ntryL,G0H2(1),23,0,G1H2(18),n2h2(130))
  call Hloop_AQ_V(ntryL,G1H12(1),wf6(:,2),G1H2(40),m3h6x2(:,8),heltab2x12(:,:,77))
  call Hloop_QA_V(ntryL,G1H12(7),ex2(:),G1H6(56),m3h2x6(:,35),heltab2x12(:,:,78))
  call Hloop_AV_Q(ntryL,G1H24(15),wf12(:,3),G1H2(46),m3h12x2(:,1),heltab2x24(:,:,65))
  call Hloop_A_Q(ntryL,G1H2(46),23,0,G2H2(21),n2h2(131))
  call Hloop_AV_Q(ntryL,G1H24(12),wf12(:,3),G1H2(51),m3h12x2(:,2),heltab2x24(:,:,66))
  call Hloop_A_Q(ntryL,G1H2(51),23,nMT,G2H2(30),n2h2(132))
  call Hloop_QV_A(ntryL,G1H24(17),wf12(:,3),G1H2(62),m3h12x2(:,3),heltab2x24(:,:,67))
  call Hloop_Q_A(ntryL,G1H2(62),23,0,G2H2(32),n2h2(133))
  call Hloop_QV_A(ntryL,G1H24(14),wf12(:,3),G1H2(68),m3h12x2(:,4),heltab2x24(:,:,68))
  call Hloop_Q_A(ntryL,G1H2(68),23,nMT,G2H2(38),n2h2(134))
  call Hloop_AV_Q(ntryL,G1H24(16),wf12(:,3),G1H2(31),m3h12x2(:,5),heltab2x24(:,:,69))
  call Hloop_A_Q(ntryL,G1H2(31),23,nMB,G2H2(40),n2h2(135))
  call Hloop_QV_A(ntryL,G1H24(18),wf12(:,3),G1H2(71),m3h12x2(:,6),heltab2x24(:,:,70))
  call Hloop_Q_A(ntryL,G1H2(71),23,nMB,G2H2(8),n2h2(136))
  call Hloop_DV_C(ntryL,G1H24(19),16,wf12(:,3),G2H2(97),m3h12x2(:,7),heltab2x24(:,:,71))
  call Hloop_CV_D(ntryL,G1H24(20),16,wf12(:,3),7,G2H2(37),m3h12x2(:,8),heltab2x24(:,:,72))
  call Hloop_UV_W(ntryL,G1H24(21),16,wf12(:,3),7,G2H2(15),m3h12x2(:,9),heltab2x24(:,:,73))
  call Hloop_QA_V(ntryL,G1H24(22),ex2(:),G1H12(6),m3h2x12(:,23),heltab2x24(:,:,74))
  call Hloop_VA_Q(ntryL,G1H24(23),ex2(:),G1H12(3),m3h2x12(:,24),heltab2x24(:,:,75))
  call Hloop_A_Q(ntryL,G1H12(3),18,0,G2H12(1),n2h12(37))
  call Hloop_VA_Q(ntryL,G0H4(3),ex2(:),G0H2(1),m3h2x2(:,44),heltab2x4(:,:,54))
  call Hloop_A_Q(ntryL,G0H2(1),23,0,G1H2(72),n2h2(137))
  call Hloop_QA_V(ntryL,G1H4(8),ex2(:),G1H2(73),m3h2x2(:,45),heltab2x4(:,:,55))
  call Hloop_QA_V(ntryL,G1H24(24),wf6(:,4),G1H4(23),m3h6x4(:,7),heltab2x24(:,:,76))
  call Hloop_VA_Q(ntryL,G1H24(25),wf6(:,4),G1H4(25),m3h6x4(:,8),heltab2x24(:,:,77))
  call Hloop_A_Q(ntryL,G1H4(25),22,0,G2H4(12),n2h4(38))
  call Hloop_VA_Q(ntryL,G0H12(7),wf6(:,4),G0H2(1),m3h6x2(:,9),heltab2x12(:,:,79))
  call Hloop_A_Q(ntryL,G0H2(1),23,0,G1H2(76),n2h2(138))
  call Hloop_QA_V(ntryL,G1H12(8),wf6(:,4),G1H2(77),m3h6x2(:,10),heltab2x12(:,:,80))
  call Hloop_AQ_V(ntryL,G1H12(5),ex1(:),G1H6(57),m3h2x6(:,36),heltab2x12(:,:,81))
  call Hloop_AV_Q(ntryL,G1H24(30),wf12(:,4),G1H2(78),m3h12x2(:,10),heltab2x24(:,:,78))
  call Hloop_A_Q(ntryL,G1H2(78),23,0,G2H2(91),n2h2(139))
  call Hloop_AV_Q(ntryL,G1H24(27),wf12(:,4),G1H2(81),m3h12x2(:,11),heltab2x24(:,:,79))
  call Hloop_A_Q(ntryL,G1H2(81),23,nMT,G2H2(18),n2h2(140))
  call Hloop_QV_A(ntryL,G1H24(32),wf12(:,4),G1H2(82),m3h12x2(:,12),heltab2x24(:,:,80))
  call Hloop_Q_A(ntryL,G1H2(82),23,0,G2H2(39),n2h2(141))
  call Hloop_QV_A(ntryL,G1H24(29),wf12(:,4),G1H2(83),m3h12x2(:,13),heltab2x24(:,:,81))
  call Hloop_Q_A(ntryL,G1H2(83),23,nMT,G2H2(22),n2h2(142))
  call Hloop_AV_Q(ntryL,G1H24(31),wf12(:,4),G1H2(86),m3h12x2(:,14),heltab2x24(:,:,82))
  call Hloop_A_Q(ntryL,G1H2(86),23,nMB,G2H2(23),n2h2(143))
  call Hloop_QV_A(ntryL,G1H24(33),wf12(:,4),G1H2(87),m3h12x2(:,15),heltab2x24(:,:,83))
  call Hloop_Q_A(ntryL,G1H2(87),23,nMB,G2H2(24),n2h2(144))
  call Hloop_DV_C(ntryL,G1H24(34),16,wf12(:,4),G2H2(4),m3h12x2(:,16),heltab2x24(:,:,84))
  call Hloop_CV_D(ntryL,G1H24(35),16,wf12(:,4),7,G2H2(31),m3h12x2(:,17),heltab2x24(:,:,85))
  call Hloop_UV_W(ntryL,G1H24(36),16,wf12(:,4),7,G2H2(34),m3h12x2(:,18),heltab2x24(:,:,86))
  call Hloop_AQ_V(ntryL,G1H24(37),ex1(:),G1H12(9),m3h2x12(:,25),heltab2x24(:,:,87))
  call Hloop_VQ_A(ntryL,G1H24(38),ex1(:),G1H12(11),m3h2x12(:,26),heltab2x24(:,:,88))
  call Hloop_Q_A(ntryL,G1H12(11),17,0,G2H12(2),n2h12(38))
  call Hloop_VQ_A(ntryL,G0H4(4),ex1(:),G0H2(1),m3h2x2(:,46),heltab2x4(:,:,56))
  call Hloop_Q_A(ntryL,G0H2(1),23,0,G1H2(88),n2h2(145))
  call Hloop_AQ_V(ntryL,G1H4(11),ex1(:),G1H2(91),m3h2x2(:,47),heltab2x4(:,:,57))
  call Hloop_QZ_A(ntryL,G1H24(39),ex3(:),G1H8(11),ngZu,m3h3x8(:,21),heltab2x24(:,:,89))
  call Hloop_Q_A(ntryL,G1H8(11),20,0,G2H8(7),n2h8(27))
  call Hloop_QZ_A(ntryL,G1H24(40),ex3(:),G1H8(12),ngZu,m3h3x8(:,22),heltab2x24(:,:,90))
  call Hloop_Q_A(ntryL,G1H8(12),20,nMT,G2H8(4),n2h8(28))
  call Hloop_AZ_Q(ntryL,G1H24(41),ex3(:),G1H8(14),ngZu,m3h3x8(:,23),heltab2x24(:,:,91))
  call Hloop_A_Q(ntryL,G1H8(14),20,0,G2H8(11),n2h8(29))
  call Hloop_AZ_Q(ntryL,G1H24(42),ex3(:),G1H8(15),ngZu,m3h3x8(:,24),heltab2x24(:,:,92))
  call Hloop_A_Q(ntryL,G1H8(15),20,nMT,G2H8(12),n2h8(30))
  call Hloop_QZ_A(ntryL,G1H24(43),ex3(:),G1H8(16),ngZd,m3h3x8(:,25),heltab2x24(:,:,93))
  call Hloop_Q_A(ntryL,G1H8(16),20,0,G2H8(13),n2h8(31))
  call Hloop_QZ_A(ntryL,G1H24(44),ex3(:),G1H8(17),ngZd,m3h3x8(:,26),heltab2x24(:,:,94))
  call Hloop_Q_A(ntryL,G1H8(17),20,nMB,G2H8(14),n2h8(32))
  call Hloop_AZ_Q(ntryL,G1H24(45),ex3(:),G1H8(19),ngZd,m3h3x8(:,27),heltab2x24(:,:,95))
  call Hloop_A_Q(ntryL,G1H8(19),20,0,G2H8(15),n2h8(33))
  call Hloop_AZ_Q(ntryL,G1H24(46),ex3(:),G1H8(20),ngZd,m3h3x8(:,28),heltab2x24(:,:,96))
  call Hloop_A_Q(ntryL,G1H8(20),20,nMB,G2H8(16),n2h8(34))
  call Hloop_QA_V(ntryL,G1H24(47),ex2(:),G1H12(13),m3h2x12(:,27),heltab2x24(:,:,97))
  call Hloop_VA_Q(ntryL,G1H24(48),ex2(:),G1H12(4),m3h2x12(:,28),heltab2x24(:,:,98))
  call Hloop_A_Q(ntryL,G1H12(4),18,0,G2H12(3),n2h12(39))
  call Hloop_VA_Q(ntryL,G0H6(15),ex2(:),G0H3(1),m3h2x3(:,78),heltab2x6(:,:,171))
  call Hloop_A_Q(ntryL,G0H3(1),27,0,G1H3(2),n2h3(71))
  call Hloop_QZ_A(ntryL,G1H24(49),ex3(:),G1H8(21),ngZu,m3h3x8(:,29),heltab2x24(:,:,99))
  call Hloop_Q_A(ntryL,G1H8(21),20,0,G2H8(17),n2h8(35))
  call Hloop_QZ_A(ntryL,G1H24(50),ex3(:),G1H8(22),ngZu,m3h3x8(:,30),heltab2x24(:,:,100))
  call Hloop_Q_A(ntryL,G1H8(22),20,nMT,G2H8(18),n2h8(36))
  call Hloop_AZ_Q(ntryL,G1H24(51),ex3(:),G1H8(24),ngZu,m3h3x8(:,31),heltab2x24(:,:,101))
  call Hloop_A_Q(ntryL,G1H8(24),20,0,G2H8(19),n2h8(37))
  call Hloop_AZ_Q(ntryL,G1H24(52),ex3(:),G1H8(25),ngZu,m3h3x8(:,32),heltab2x24(:,:,102))
  call Hloop_A_Q(ntryL,G1H8(25),20,nMT,G2H8(20),n2h8(38))
  call Hloop_QZ_A(ntryL,G1H24(53),ex3(:),G1H8(26),ngZd,m3h3x8(:,33),heltab2x24(:,:,103))
  call Hloop_Q_A(ntryL,G1H8(26),20,0,G2H8(21),n2h8(39))
  call Hloop_QZ_A(ntryL,G1H24(54),ex3(:),G1H8(27),ngZd,m3h3x8(:,34),heltab2x24(:,:,104))
  call Hloop_Q_A(ntryL,G1H8(27),20,nMB,G2H8(22),n2h8(40))
  call Hloop_AZ_Q(ntryL,G1H24(55),ex3(:),G1H8(29),ngZd,m3h3x8(:,35),heltab2x24(:,:,105))
  call Hloop_A_Q(ntryL,G1H8(29),20,0,G2H8(23),n2h8(41))
  call Hloop_AZ_Q(ntryL,G1H24(56),ex3(:),G1H8(30),ngZd,m3h3x8(:,36),heltab2x24(:,:,106))
  call Hloop_A_Q(ntryL,G1H8(30),20,nMB,G2H8(24),n2h8(42))
  call Hloop_AQ_V(ntryL,G1H24(57),ex1(:),G1H12(24),m3h2x12(:,29),heltab2x24(:,:,107))
  call Hloop_VQ_A(ntryL,G1H24(58),ex1(:),G1H12(16),m3h2x12(:,30),heltab2x24(:,:,108))
  call Hloop_Q_A(ntryL,G1H12(16),17,0,G2H12(4),n2h12(40))
  call Hloop_VQ_A(ntryL,G0H6(16),ex1(:),G0H3(1),m3h2x3(:,79),heltab2x6(:,:,172))
  call Hloop_Q_A(ntryL,G0H3(1),27,0,G1H3(3),n2h3(72))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(65),[G2H2(62),G2H2(25),G2H2(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(51),[G2H2(48),G2H2(27),G2H2(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(44),[G1H3(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(2),[G1H3(74),G1H3(69),G1H3(12)])
call HGT_w2_OLR(G1H3(44),1,1,3)
call HGT_w2_invQ_OLR(G1H3(44),2,5,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(44),[G1H3(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(31),[G1H3(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(3),[G1H3(66),G1H3(61),G1H3(11)])
call HGT_w2_OLR(G1H3(31),1,1,3)
call HGT_w2_invQ_OLR(G1H3(31),2,5,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(31),[G1H3(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(18),[G1H2(95),G1H2(45)])
call HGT_w2_OLR(G1H2(49),1,1,2)
call HGT_w2_invQ_OLR(G1H2(49),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(49),[G1H2(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(62),[G1H3(40),G1H3(8)])
call HGT_w2_OLR(G1H3(26),1,1,3)
call HGT_w2_invQ_OLR(G1H3(26),2,5,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(26),[G1H3(62)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(5),[G1H3(27)])
call HGT_OLR(G2H3(17),1,1,3)
call HGT_invQ_OLR(G2H3(17),2,5,3)
call HGT_OLR(G2H3(17),6,15,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(17),[G2H3(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(39),[G2H2(32),G2H2(92),G2H2(86),G2H2(54),G1H2(119) &
    ,G1H2(115),G1H2(61),G1H2(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(69),[G2H2(56)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(28),[G1H2(70),G1H2(58)])
call HGT_OLR(G2H2(69),1,1,2)
call HGT_invQ_OLR(G2H2(69),2,5,2)
call HGT_OLR(G2H2(69),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(69),[G2H2(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(19),[G1H3(67),G1H3(50),G1H3(41)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(2),[G1H3(7)])
call HGT_OLR(G2H3(21),1,1,3)
call HGT_invQ_OLR(G2H3(21),2,5,3)
call HGT_OLR(G2H3(21),6,15,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(21),[G2H3(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(91),[G2H2(21),G2H2(98),G2H2(80),G2H2(58),G1H2(127) &
    ,G1H2(112),G1H2(75),G1H2(63)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(71),[G2H2(60)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(55),[G1H2(80),G1H2(50)])
call HGT_OLR(G2H2(71),1,1,2)
call HGT_invQ_OLR(G2H2(71),2,5,2)
call HGT_OLR(G2H2(71),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(71),[G2H2(55)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(23),[G1H3(75),G1H3(59),G1H3(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(33),[G2H2(12),G1H2(114),G1H2(94)])
call HGT_w2_OLR(G1H2(10),1,1,2)
call HGT_w2_invQ_OLR(G1H2(10),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(33),[G1H2(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(15),[G1H3(49),G1H3(39)])
call HGT_w2_OLR(G1H3(20),1,1,3)
call HGT_w2_invQ_OLR(G1H3(20),2,5,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(15),[G1H3(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(53),[G1H2(142)])
call HGT_OLR(G2H2(67),1,1,2)
call HGT_invQ_OLR(G2H2(67),2,5,2)
call HGT_OLR(G2H2(67),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(67),[G2H2(53)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(26),[G1H3(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(57),[G1H2(145)])
call HGT_OLR(G2H2(68),1,1,2)
call HGT_invQ_OLR(G2H2(68),2,5,2)
call HGT_OLR(G2H2(68),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(68),[G2H2(57)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(29),[G1H3(80)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(32),[G1H3(84)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(59),[G1H2(149)])
call HGT_OLR(G2H2(70),1,1,2)
call HGT_invQ_OLR(G2H2(70),2,5,2)
call HGT_OLR(G2H2(70),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(70),[G2H2(59)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(35),[G1H3(88)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(38),[G1H3(92)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(19),[G1H2(153)])
call HGT_OLR(G2H2(72),1,1,2)
call HGT_invQ_OLR(G2H2(72),2,5,2)
call HGT_OLR(G2H2(72),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(72),[G2H2(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(41),[G1H3(96)])
call HGT_OLR(G2H3(43),1,1,3)
call HGT_invQ_OLR(G2H3(43),2,5,3)
call HGT_OLR(G2H3(43),6,15,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(43),[G2H3(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(18),[G2H2(30),G2H2(101),G2H2(74),G1H2(146),G1H2(59)])
call HGT_OLR(G2H3(44),1,1,3)
call HGT_invQ_OLR(G2H3(44),2,5,3)
call HGT_OLR(G2H3(44),6,15,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(44),[G2H3(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(22),[G2H2(38),G2H2(95),G2H2(77),G1H2(143),G1H2(132)])
call HGT_OLR(G2H3(45),1,1,3)
call HGT_invQ_OLR(G2H3(45),2,5,3)
call HGT_OLR(G2H3(45),6,15,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(45),[G2H3(22)])
call HGT_OLR(G2H3(46),1,1,3)
call HGT_invQ_OLR(G2H3(46),2,5,3)
call HGT_OLR(G2H3(46),6,15,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(46),[G2H3(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(23),[G2H2(40),G2H2(107),G2H2(83),G1H2(154),G1H2(136)])
call HGT_OLR(G2H3(47),1,1,3)
call HGT_invQ_OLR(G2H3(47),2,5,3)
call HGT_OLR(G2H3(47),6,15,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(47),[G2H3(20)])
call HGT_OLR(G2H3(48),1,1,3)
call HGT_invQ_OLR(G2H3(48),2,5,3)
call HGT_OLR(G2H3(48),6,15,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(48),[G2H3(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(24),[G2H2(8),G2H2(104),G2H2(89),G1H2(150),G1H2(140)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(72),[G1H2(25),G1H2(79)])
call HGT_w2_OLR(G1H2(37),1,1,2)
call HGT_w2_invQ_OLR(G1H2(37),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(37),[G1H2(72)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(88),[G1H2(118),G1H2(4)])
call HGT_w2_OLR(G1H2(38),1,1,2)
call HGT_w2_invQ_OLR(G1H2(38),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(38),[G1H2(88)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(12),[G2H4(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(9),[G2H4(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(40),[G1H2(98),G1H2(55)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(34),[G2H2(15),G1H2(110),G1H2(103),G1H2(11),G1H2(65)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(77),[G1H2(105),G1H2(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(76),[G1H2(122),G1H2(74)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(70),[G1H3(54),G1H3(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(91),[G1H2(102),G1H2(97)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(73),[G1H2(109),G1H2(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(6),[G2H2(16),G1H2(126),G1H2(121)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(10),[G1H3(58),G1H3(53)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(23),[G1H4(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(19),[G1H4(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(3),[G1H3(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(16),[G1H3(79)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(13),[G1H3(83)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(7),[G1H3(87)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(1),[G1H3(91)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(12),[G1H3(95)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(10),[G1H2(64)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(20),[G1H2(131)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(26),[G1H2(135)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(29),[G1H2(139)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(1),[G2H8(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(5),[G2H8(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(4),[G2H2(97)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(31),[G2H2(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(13),[G2H8(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(15),[G2H8(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(21),[G2H8(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(23),[G2H8(19)])
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(65),ex2(:),G2tensor(11),m3h2x1(:,172),heltab2x2(:,:,172))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(51),ex2(:),G2tensor(2),m3h2x1(:,173),heltab2x2(:,:,173))
  call Hloop_AZ_Q(ntryL,G1H3(44),ex3(:),G1H1(1),ngZu,m3h3x1(:,96),heltab2x3(:,:,96))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(93),n2h1(239))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(42),ex1(:),G2tensor(43),m3h2x1(:,174),heltab2x2(:,:,174))
  call Hloop_QZ_A(ntryL,G1H3(31),ex3(:),G1H1(1),ngZu,m3h3x1(:,97),heltab2x3(:,:,97))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(4),n2h1(240))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(45),ex2(:),G2tensor(6),m3h2x1(:,175),heltab2x2(:,:,175))
  call Hloop_QV_A(ntryL,G1H2(49),ex4(:),G1H1(1),m3h2x1(:,176),heltab2x2(:,:,176))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(7),n2h1(241))
  call Hloop_QZ_A(ntryL,G1H3(26),ex3(:),G1H1(1),ngZu,m3h3x1(:,98),heltab2x3(:,:,98))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(10),n2h1(242))
  call Hloop_QZ_A(ntryL,G2H3(17),ex3(:),G2H1(1),ngZu,m3h3x1(:,99),heltab2x3(:,:,99))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(21),n2h1(243))
  call Hloop_QV_A(ntryL,G2H2(39),ex4(:),G2H1(1),m3h2x1(:,177),heltab2x2(:,:,177))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(22),n2h1(244))
  call Hloop_QV_A(ntryL,G2H2(69),ex4(:),G2H1(1),m3h2x1(:,178),heltab2x2(:,:,178))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(23),n2h1(245))
  call Hloop_QZ_A(ntryL,G2H3(19),ex3(:),G2H1(1),ngZu,m3h3x1(:,100),heltab2x3(:,:,100))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(24),n2h1(246))
  call Hloop_AZ_Q(ntryL,G2H3(21),ex3(:),G2H1(1),ngZu,m3h3x1(:,101),heltab2x3(:,:,101))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(25),n2h1(247))
  call Hloop_AV_Q(ntryL,G2H2(91),ex4(:),G2H1(1),m3h2x1(:,179),heltab2x2(:,:,179))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(26),n2h1(248))
  call Hloop_AV_Q(ntryL,G2H2(71),ex4(:),G2H1(1),m3h2x1(:,180),heltab2x2(:,:,180))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(27),n2h1(249))
  call Hloop_AZ_Q(ntryL,G2H3(23),ex3(:),G2H1(1),ngZu,m3h3x1(:,102),heltab2x3(:,:,102))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(28),n2h1(250))
  call Hloop_QV_A(ntryL,G2H2(33),ex4(:),G2H1(1),m3h2x1(:,181),heltab2x2(:,:,181))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(29),n2h1(251))
  call Hloop_QZ_A(ntryL,G2H3(15),ex3(:),G2H1(1),ngZu,m3h3x1(:,103),heltab2x3(:,:,103))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(30),n2h1(252))
  call Hloop_QV_A(ntryL,G2H2(67),ex4(:),G2H1(1),m3h2x1(:,182),heltab2x2(:,:,182))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(31),n2h1(253))
  call Hloop_QZ_A(ntryL,G2H3(26),ex3(:),G2H1(1),ngZu,m3h3x1(:,104),heltab2x3(:,:,104))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(32),n2h1(254))
  call Hloop_AV_Q(ntryL,G2H2(68),ex4(:),G2H1(1),m3h2x1(:,183),heltab2x2(:,:,183))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(33),n2h1(255))
  call Hloop_AZ_Q(ntryL,G2H3(29),ex3(:),G2H1(1),ngZu,m3h3x1(:,105),heltab2x3(:,:,105))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(34),n2h1(256))
  call Hloop_QZ_A(ntryL,G2H3(32),ex3(:),G2H1(1),ngZd,m3h3x1(:,106),heltab2x3(:,:,106))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(35),n2h1(257))
  call Hloop_QV_A(ntryL,G2H2(70),ex4(:),G2H1(1),m3h2x1(:,184),heltab2x2(:,:,184))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(36),n2h1(258))
  call Hloop_QZ_A(ntryL,G2H3(35),ex3(:),G2H1(1),ngZd,m3h3x1(:,107),heltab2x3(:,:,107))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(37),n2h1(259))
  call Hloop_AZ_Q(ntryL,G2H3(38),ex3(:),G2H1(1),ngZd,m3h3x1(:,108),heltab2x3(:,:,108))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(38),n2h1(260))
  call Hloop_AV_Q(ntryL,G2H2(72),ex4(:),G2H1(1),m3h2x1(:,185),heltab2x2(:,:,185))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(39),n2h1(261))
  call Hloop_AZ_Q(ntryL,G2H3(41),ex3(:),G2H1(1),ngZd,m3h3x1(:,109),heltab2x3(:,:,109))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(40),n2h1(262))
  call Hloop_AZ_Q(ntryL,G2H3(43),ex3(:),G2H1(1),ngZu,m3h3x1(:,110),heltab2x3(:,:,110))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(41),n2h1(263))
  call Hloop_AV_Q(ntryL,G2H2(18),ex4(:),G2H1(1),m3h2x1(:,186),heltab2x2(:,:,186))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(42),n2h1(264))
  call Hloop_QZ_A(ntryL,G2H3(44),ex3(:),G2H1(1),ngZu,m3h3x1(:,111),heltab2x3(:,:,111))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(43),n2h1(265))
  call Hloop_QV_A(ntryL,G2H2(22),ex4(:),G2H1(1),m3h2x1(:,187),heltab2x2(:,:,187))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(44),n2h1(266))
  call Hloop_AZ_Q(ntryL,G2H3(45),ex3(:),G2H1(1),ngZd,m3h3x1(:,112),heltab2x3(:,:,112))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(45),n2h1(267))
  call Hloop_AZ_Q(ntryL,G2H3(46),ex3(:),G2H1(1),ngZd,m3h3x1(:,113),heltab2x3(:,:,113))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(46),n2h1(268))
  call Hloop_AV_Q(ntryL,G2H2(23),ex4(:),G2H1(1),m3h2x1(:,188),heltab2x2(:,:,188))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(47),n2h1(269))
  call Hloop_QZ_A(ntryL,G2H3(47),ex3(:),G2H1(1),ngZd,m3h3x1(:,114),heltab2x3(:,:,114))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(48),n2h1(270))
  call Hloop_QZ_A(ntryL,G2H3(48),ex3(:),G2H1(1),ngZd,m3h3x1(:,115),heltab2x3(:,:,115))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(49),n2h1(271))
  call Hloop_QV_A(ntryL,G2H2(24),ex4(:),G2H1(1),m3h2x1(:,189),heltab2x2(:,:,189))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(50),n2h1(272))
call HGT_OLR(G2H4(13),1,1,4)
call HGT_invQ_OLR(G2H4(13),2,5,4)
call HGT_OLR(G2H4(13),6,15,4)
  call Hloop_QV_A(ntryL,G2H4(13),wf4(:,10),G2H1(1),m3h4x1(:,11),heltab2x4(:,:,58))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(51),n2h1(273))
call HGT_OLR(G2H4(14),1,1,4)
call HGT_invQ_OLR(G2H4(14),2,5,4)
call HGT_OLR(G2H4(14),6,15,4)
  call Hloop_QV_A(ntryL,G2H4(14),wf4(:,10),G2H1(1),m3h4x1(:,12),heltab2x4(:,:,59))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(52),n2h1(274))
call HGT_OLR(G2H4(1),1,1,4)
call HGT_invQ_OLR(G2H4(1),2,5,4)
call HGT_OLR(G2H4(1),6,15,4)
  call Hloop_AV_Q(ntryL,G2H4(1),wf4(:,10),G2H1(1),m3h4x1(:,13),heltab2x4(:,:,60))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(53),n2h1(275))
call HGT_OLR(G2H4(2),1,1,4)
call HGT_invQ_OLR(G2H4(2),2,5,4)
call HGT_OLR(G2H4(2),6,15,4)
  call Hloop_AV_Q(ntryL,G2H4(2),wf4(:,10),G2H1(1),m3h4x1(:,14),heltab2x4(:,:,61))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(54),n2h1(276))
call HGT_OLR(G2H4(4),1,1,4)
call HGT_invQ_OLR(G2H4(4),2,5,4)
call HGT_OLR(G2H4(4),6,15,4)
  call Hloop_QV_A(ntryL,G2H4(4),wf4(:,10),G2H1(1),m3h4x1(:,15),heltab2x4(:,:,62))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(55),n2h1(277))
call HGT_OLR(G2H4(8),1,1,4)
call HGT_invQ_OLR(G2H4(8),2,5,4)
call HGT_OLR(G2H4(8),6,15,4)
  call Hloop_AV_Q(ntryL,G2H4(8),wf4(:,10),G2H1(1),m3h4x1(:,16),heltab2x4(:,:,63))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(56),n2h1(278))
  call Hloop_AV_Q(ntryL,G1H2(37),ex4(:),G1H1(1),m3h2x1(:,190),heltab2x2(:,:,190))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(14),n2h1(279))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H6(20),wf6(:,2),G2tensor(15),m3h6x1(:,11),heltab2x6(:,:,173))
  call Hloop_QV_A(ntryL,G1H2(38),ex4(:),G1H1(1),m3h2x1(:,191),heltab2x2(:,:,191))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(18),n2h1(280))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H6(10),wf6(:,4),G2tensor(19),m3h6x1(:,12),heltab2x6(:,:,174))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H4(12),wf4(:,7),G2tensor(22),m3h4x1(:,17),heltab2x4(:,:,64))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H4(9),wf4(:,2),G2tensor(23),m3h4x1(:,18),heltab2x4(:,:,65))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(40),23,ex4(:),8,G2tensor(26),m3h2x1(:,192),heltab2x2(:,:,192))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H2(34),23,ex4(:),8,G3tensor(57),m3h2x1(:,193),heltab2x2(:,:,193))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(77),23,ex4(:),8,G2tensor(30),m3h2x1(:,194),heltab2x2(:,:,194))
  call Hloop_VA_Q(ntryL,G1H2(8),ex2(:),G1H1(1),m3h2x1(:,195),heltab2x2(:,:,195))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(31),n2h1(281))
  call Hloop_VA_Q(ntryL,G1H2(19),ex2(:),G1H1(1),m3h2x1(:,196),heltab2x2(:,:,196))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(34),n2h1(282))
  call Hloop_VQ_A(ntryL,G1H2(29),ex1(:),G1H1(1),m3h2x1(:,197),heltab2x2(:,:,197))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(38),n2h1(283))
  call Hloop_VQ_A(ntryL,G1H2(36),ex1(:),G1H1(1),m3h2x1(:,198),heltab2x2(:,:,198))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(91),n2h1(284))
  call Hloop_AV_Q(ntryL,G1H2(76),ex4(:),G1H1(1),m3h2x1(:,199),heltab2x2(:,:,199))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(39),n2h1(285))
  call Hloop_AZ_Q(ntryL,G1H3(70),ex3(:),G1H1(1),ngZu,m3h3x1(:,116),heltab2x3(:,:,116))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(42),n2h1(286))
  call Hloop_VQ_A(ntryL,G1H2(84),ex1(:),G1H1(1),m3h2x1(:,200),heltab2x2(:,:,200))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(156),n2h1(287))
  call Hloop_VQ_A(ntryL,G1H2(85),ex1(:),G1H1(1),m3h2x1(:,201),heltab2x2(:,:,201))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(99),n2h1(288))
  call Hloop_VA_Q(ntryL,G1H2(89),ex2(:),G1H1(1),m3h2x1(:,202),heltab2x2(:,:,202))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(162),n2h1(289))
  call Hloop_VA_Q(ntryL,G1H2(90),ex2(:),G1H1(1),m3h2x1(:,203),heltab2x2(:,:,203))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(102),n2h1(290))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(91),23,ex4(:),8,G2tensor(108),m3h2x1(:,204),heltab2x2(:,:,204))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(73),23,ex4(:),8,G2tensor(168),m3h2x1(:,205),heltab2x2(:,:,205))
  call Hloop_AV_Q(ntryL,G2H2(6),ex4(:),G2H1(1),m3h2x1(:,206),heltab2x2(:,:,206))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(58),n2h1(291))
  call Hloop_AZ_Q(ntryL,G2H3(10),ex3(:),G2H1(1),ngZu,m3h3x1(:,117),heltab2x3(:,:,117))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(59),n2h1(292))
  call Hloop_VQ_A(ntryL,G1H6(51),wf6(:,2),G1H1(1),m3h6x1(:,13),heltab2x6(:,:,175))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(219),n2h1(293))
  call Hloop_VQ_A(ntryL,G1H6(54),wf6(:,2),G1H1(1),m3h6x1(:,14),heltab2x6(:,:,176))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(186),n2h1(294))
  call Hloop_VA_Q(ntryL,G1H6(7),wf6(:,4),G1H1(1),m3h6x1(:,15),heltab2x6(:,:,177))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(174),n2h1(295))
  call Hloop_VA_Q(ntryL,G1H6(8),wf6(:,4),G1H1(1),m3h6x1(:,16),heltab2x6(:,:,178))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(69),n2h1(296))
  call Hloop_VQ_A(ntryL,G1H4(10),wf4(:,7),G1H1(1),m3h4x1(:,19),heltab2x4(:,:,66))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(77),n2h1(297))
  call Hloop_VQ_A(ntryL,G1H4(23),wf4(:,7),G1H1(1),m3h4x1(:,20),heltab2x4(:,:,67))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(72),n2h1(298))
  call Hloop_VA_Q(ntryL,G1H4(6),wf4(:,2),G1H1(1),m3h4x1(:,21),heltab2x4(:,:,68))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(70),n2h1(299))
  call Hloop_VA_Q(ntryL,G1H4(19),wf4(:,2),G1H1(1),m3h4x1(:,22),heltab2x4(:,:,69))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(75),n2h1(300))
  call Hloop_QZ_A(ntryL,G2H3(3),ex3(:),G2H1(1),ngZu,m3h3x1(:,118),heltab2x3(:,:,118))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(60),n2h1(301))
  call Hloop_AZ_Q(ntryL,G2H3(16),ex3(:),G2H1(1),ngZu,m3h3x1(:,119),heltab2x3(:,:,119))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(61),n2h1(302))
  call Hloop_QZ_A(ntryL,G2H3(13),ex3(:),G2H1(1),ngZd,m3h3x1(:,120),heltab2x3(:,:,120))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(62),n2h1(303))
  call Hloop_QZ_A(ntryL,G2H3(7),ex3(:),G2H1(1),ngZd,m3h3x1(:,121),heltab2x3(:,:,121))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(63),n2h1(304))
  call Hloop_AZ_Q(ntryL,G2H3(1),ex3(:),G2H1(1),ngZd,m3h3x1(:,122),heltab2x3(:,:,122))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(64),n2h1(305))
  call Hloop_AZ_Q(ntryL,G2H3(12),ex3(:),G2H1(1),ngZd,m3h3x1(:,123),heltab2x3(:,:,123))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(65),n2h1(306))
  call Hloop_AV_Q(ntryL,G2H2(10),ex4(:),G2H1(1),m3h2x1(:,207),heltab2x2(:,:,207))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(66),n2h1(307))
  call Hloop_QV_A(ntryL,G2H2(20),ex4(:),G2H1(1),m3h2x1(:,208),heltab2x2(:,:,208))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(67),n2h1(308))
  call Hloop_AV_Q(ntryL,G2H2(26),ex4(:),G2H1(1),m3h2x1(:,209),heltab2x2(:,:,209))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(68),n2h1(309))
  call Hloop_QV_A(ntryL,G2H2(29),ex4(:),G2H1(1),m3h2x1(:,210),heltab2x2(:,:,210))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(69),n2h1(310))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(2),ex1(:),G2tensor(78),m3h2x1(:,211),heltab2x2(:,:,211))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(5),ex2(:),G2tensor(81),m3h2x1(:,212),heltab2x2(:,:,212))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(9),ex2(:),G2tensor(83),m3h2x1(:,213),heltab2x2(:,:,213))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H6(12),wf6(:,2),G2tensor(85),m3h6x1(:,17),heltab2x6(:,:,179))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H6(14),wf6(:,4),G2tensor(86),m3h6x1(:,18),heltab2x6(:,:,180))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H4(10),wf4(:,7),G2tensor(89),m3h4x1(:,23),heltab2x4(:,:,70))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H4(11),wf4(:,2),G2tensor(213),m3h4x1(:,24),heltab2x4(:,:,71))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H6(2),wf6(:,2),G2tensor(222),m3h6x1(:,19),heltab2x6(:,:,181))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H6(9),wf6(:,4),G2tensor(231),m3h6x1(:,20),heltab2x6(:,:,182))
  call Hloop_QV_A(ntryL,G2H8(1),wf8(:,3),G2H1(1),m3h8x1(:,1),heltab2x8(:,:,41))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(70),n2h1(311))
  call Hloop_QV_A(ntryL,G2H8(8),wf8(:,3),G2H1(1),m3h8x1(:,2),heltab2x8(:,:,42))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(71),n2h1(312))
  call Hloop_AV_Q(ntryL,G2H8(5),wf8(:,3),G2H1(1),m3h8x1(:,3),heltab2x8(:,:,43))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(72),n2h1(313))
  call Hloop_AV_Q(ntryL,G2H8(10),wf8(:,3),G2H1(1),m3h8x1(:,4),heltab2x8(:,:,44))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(73),n2h1(314))
  call Hloop_QV_A(ntryL,G2H8(3),wf8(:,3),G2H1(1),m3h8x1(:,5),heltab2x8(:,:,45))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(74),n2h1(315))
  call Hloop_AV_Q(ntryL,G2H8(2),wf8(:,3),G2H1(1),m3h8x1(:,6),heltab2x8(:,:,46))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(75),n2h1(316))
  call Hloop_VQ_A(ntryL,G1H6(56),wf6(:,2),G1H1(1),m3h6x1(:,21),heltab2x6(:,:,183))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(237),n2h1(317))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H2(4),23,ex4(:),G3tensor(76),m3h2x1(:,214),heltab2x2(:,:,214))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H2(31),23,ex4(:),8,G3tensor(77),m3h2x1(:,215),heltab2x2(:,:,215))
  call Hloop_VQ_A(ntryL,G1H12(6),wf12(:,23),G1H1(1),m3h12x1(:,1),heltab2x12(:,:,82))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(243),n2h1(318))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H12(1),wf12(:,23),G2tensor(249),m3h12x1(:,2),heltab2x12(:,:,83))
  call Hloop_VA_Q(ntryL,G1H6(57),wf6(:,4),G1H1(1),m3h6x1(:,22),heltab2x6(:,:,184))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(97),n2h1(319))
  call Hloop_VA_Q(ntryL,G1H12(9),wf12(:,27),G1H1(1),m3h12x1(:,3),heltab2x12(:,:,84))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(204),n2h1(320))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H12(2),wf12(:,27),G2tensor(63),m3h12x1(:,4),heltab2x12(:,:,85))
  call Hloop_QV_A(ntryL,G2H8(13),wf8(:,7),G2H1(1),m3h8x1(:,7),heltab2x8(:,:,47))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(78),n2h1(321))
  call Hloop_QV_A(ntryL,G2H8(4),wf8(:,7),G2H1(1),m3h8x1(:,8),heltab2x8(:,:,48))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(79),n2h1(322))
  call Hloop_AV_Q(ntryL,G2H8(15),wf8(:,7),G2H1(1),m3h8x1(:,9),heltab2x8(:,:,49))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(80),n2h1(323))
  call Hloop_AV_Q(ntryL,G2H8(12),wf8(:,7),G2H1(1),m3h8x1(:,10),heltab2x8(:,:,50))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(81),n2h1(324))
  call Hloop_QV_A(ntryL,G2H8(14),wf8(:,7),G2H1(1),m3h8x1(:,11),heltab2x8(:,:,51))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(82),n2h1(325))
  call Hloop_AV_Q(ntryL,G2H8(16),wf8(:,7),G2H1(1),m3h8x1(:,12),heltab2x8(:,:,52))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(83),n2h1(326))
  call Hloop_VQ_A(ntryL,G1H12(13),wf12(:,30),G1H1(1),m3h12x1(:,5),heltab2x12(:,:,86))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(95),n2h1(327))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H12(3),wf12(:,30),G2tensor(65),m3h12x1(:,6),heltab2x12(:,:,87))
  call Hloop_QV_A(ntryL,G2H8(21),wf8(:,8),G2H1(1),m3h8x1(:,13),heltab2x8(:,:,53))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(84),n2h1(328))
  call Hloop_QV_A(ntryL,G2H8(18),wf8(:,8),G2H1(1),m3h8x1(:,14),heltab2x8(:,:,54))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(85),n2h1(329))
  call Hloop_AV_Q(ntryL,G2H8(23),wf8(:,8),G2H1(1),m3h8x1(:,15),heltab2x8(:,:,55))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(86),n2h1(330))
  call Hloop_AV_Q(ntryL,G2H8(20),wf8(:,8),G2H1(1),m3h8x1(:,16),heltab2x8(:,:,56))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(87),n2h1(331))
  call Hloop_QV_A(ntryL,G2H8(22),wf8(:,8),G2H1(1),m3h8x1(:,17),heltab2x8(:,:,57))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(88),n2h1(332))
  call Hloop_AV_Q(ntryL,G2H8(24),wf8(:,8),G2H1(1),m3h8x1(:,18),heltab2x8(:,:,58))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(89),n2h1(333))
  call Hloop_VA_Q(ntryL,G1H12(24),wf12(:,32),G1H1(1),m3h12x1(:,7),heltab2x12(:,:,88))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(105),n2h1(334))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H12(4),wf12(:,32),G2tensor(210),m3h12x1(:,8),heltab2x12(:,:,89))
  call ol_merge_tensors(G2tensor(93),[G2tensor(178),G2tensor(8),G1tensor(208),G1tensor(203),G1tensor(177),G1tensor(65) &
    ,G1tensor(14),G1tensor(67),G0tensor(217),G0tensor(212),G0tensor(186),G0tensor(72),G0tensor(26),G0tensor(21)])
  call ol_merge_tensors(G2tensor(4),[G2tensor(148),G2tensor(9),G2tensor(12),G1tensor(198),G1tensor(193),G1tensor(92),G1tensor(2) &
    ,G1tensor(32),G1tensor(7),G0tensor(207),G0tensor(202),G0tensor(101),G0tensor(47),G0tensor(31),G0tensor(11)])
  call ol_merge_tensors(G2tensor(78),[G2tensor(211),G2tensor(154),G2tensor(106),G2tensor(16),G1tensor(127),G1tensor(56) &
    ,G1tensor(44),G1tensor(24),G0tensor(136),G0tensor(41),G0tensor(36),G0tensor(22)])
  call ol_merge_tensors(G2tensor(38),[G2tensor(124),G2tensor(112),G2tensor(28),G2tensor(20),G1tensor(41),G1tensor(40),G1tensor(5) &
    ,G1tensor(33),G0tensor(66),G0tensor(57),G0tensor(51),G0tensor(46)])
  call ol_merge_tensors(G2tensor(81),[G2tensor(208),G2tensor(160),G2tensor(118),G2tensor(24),G1tensor(142),G1tensor(123) &
    ,G1tensor(118),G1tensor(21),G1tensor(15),G1tensor(48),G0tensor(151),G0tensor(132),G0tensor(127),G0tensor(61),G0tensor(56) &
    ,G0tensor(32)])
  call ol_merge_tensors(G2tensor(31),[G2tensor(136),G2tensor(130),G2tensor(36),G2tensor(32),G1tensor(70),G1tensor(71),G1tensor(46) &
    ,G1tensor(39),G0tensor(81),G0tensor(76),G0tensor(71),G0tensor(37)])
  call ol_merge_tensors(G2tensor(168),[G2tensor(14),G2tensor(202),G2tensor(184),G2tensor(142),G2tensor(40),G1tensor(182) &
    ,G1tensor(148),G1tensor(143),G1tensor(82),G1tensor(77),G1tensor(73),G0tensor(191),G0tensor(157),G0tensor(152),G0tensor(91) &
    ,G0tensor(86),G0tensor(82)])
  call ol_merge_tensors(G2tensor(108),[G2tensor(18),G2tensor(205),G2tensor(151),G2tensor(145),G2tensor(17),G2tensor(44) &
    ,G1tensor(133),G1tensor(128),G1tensor(112),G1tensor(87),G1tensor(29),G1tensor(37),G0tensor(142),G0tensor(137),G0tensor(121) &
    ,G0tensor(96),G0tensor(67),G0tensor(16)])
  call ol_merge_tensors(G2tensor(152),[G2tensor(149),G2tensor(13),G2tensor(3),G1tensor(115),G1tensor(107),G1tensor(95) &
    ,G1tensor(45),G0tensor(124),G0tensor(116),G0tensor(104),G0tensor(52)])
  call ol_merge_tensors(G2tensor(210),[G2tensor(105),G2tensor(63),G2tensor(204),G2tensor(206),G2tensor(140),G2tensor(134) &
    ,G2tensor(104),G2tensor(98),G2tensor(94),G2tensor(54),G2tensor(52),G2tensor(41),G2tensor(5),G1tensor(190),G1tensor(155) &
    ,G1tensor(110),G1tensor(64),G1tensor(55),G1tensor(25),G0tensor(199),G0tensor(164),G0tensor(119),G0tensor(79),G0tensor(19) &
    ,G0tensor(14)])
  call ol_merge_tensors(G2tensor(89),[G2tensor(155),G2tensor(21),G1tensor(130),G1tensor(18),G0tensor(139),G0tensor(27)])
  call ol_merge_tensors(G2tensor(72),[G2tensor(22),G2tensor(173),G2tensor(158),G2tensor(49),G2tensor(25),G1tensor(135) &
    ,G1tensor(22),G1tensor(20),G0tensor(144),G0tensor(63),G0tensor(28)])
  call ol_merge_tensors(G2tensor(65),[G2tensor(95),G2tensor(249),G2tensor(243),G2tensor(203),G2tensor(128),G2tensor(116) &
    ,G2tensor(101),G2tensor(96),G2tensor(92),G2tensor(50),G2tensor(47),G2tensor(29),G1tensor(175),G1tensor(140),G1tensor(85) &
    ,G1tensor(9),G1tensor(26),G0tensor(184),G0tensor(149),G0tensor(94),G0tensor(54),G0tensor(29)])
  call ol_merge_tensors(G2tensor(213),[G2tensor(161),G2tensor(59),G2tensor(33),G1tensor(145),G1tensor(100),G1tensor(13) &
    ,G0tensor(154),G0tensor(109),G0tensor(12)])
  call ol_merge_tensors(G2tensor(75),[G2tensor(23),G2tensor(167),G2tensor(164),G2tensor(60),G2tensor(46),G2tensor(37) &
    ,G1tensor(150),G1tensor(105),G1tensor(62),G1tensor(19),G0tensor(159),G0tensor(114),G0tensor(43),G0tensor(13)])
  call ol_merge_tensors(G2tensor(70),[G2tensor(146),G2tensor(139),G2tensor(137),G2tensor(45),G1tensor(187),G1tensor(90) &
    ,G1tensor(75),G1tensor(27),G0tensor(196),G0tensor(99),G0tensor(84),G0tensor(42)])
  call ol_merge_tensors(G3tensor(86),[G3tensor(84),G3tensor(80),G3tensor(78),G3tensor(72),G3tensor(70),G3tensor(3),G3tensor(1) &
    ,G2tensor(212),G2tensor(209),G2tensor(122),G2tensor(110),G1tensor(160),G1tensor(53),G1tensor(66),G0tensor(169),G0tensor(64) &
    ,G0tensor(44)])
  call ol_merge_tensors(G3tensor(11),[G3tensor(9),G3tensor(6),G3tensor(5),G3tensor(4),G3tensor(2),G2tensor(227),G2tensor(221) &
    ,G2tensor(188),G2tensor(182),G2tensor(176),G2tensor(170),G1tensor(170),G1tensor(165),G1tensor(63),G1tensor(8),G0tensor(179) &
    ,G0tensor(174),G0tensor(78),G0tensor(53)])
  call ol_merge_tensors(G2tensor(77),[G2tensor(143),G2tensor(127),G2tensor(125),G2tensor(48),G1tensor(172),G1tensor(80) &
    ,G1tensor(34),G1tensor(28),G0tensor(181),G0tensor(89),G0tensor(69),G0tensor(62)])
  call ol_merge_tensors(G2tensor(185),[G2tensor(179),G2tensor(53),G2tensor(51),G1tensor(185),G1tensor(180),G1tensor(59) &
    ,G0tensor(194),G0tensor(189),G0tensor(77)])
  call ol_merge_tensors(G2tensor(85),[G2tensor(219),G2tensor(191),G2tensor(55),G1tensor(195),G1tensor(83),G0tensor(204) &
    ,G0tensor(92)])
  call ol_merge_tensors(G2tensor(186),[G2tensor(15),G2tensor(194),G2tensor(56),G1tensor(200),G1tensor(84),G0tensor(209) &
    ,G0tensor(93)])
  call ol_merge_tensors(G2tensor(86),[G2tensor(174),G2tensor(197),G2tensor(61),G2tensor(57),G1tensor(205),G1tensor(120) &
    ,G1tensor(43),G0tensor(214),G0tensor(129),G0tensor(17)])
  call ol_merge_tensors(G2tensor(69),[G2tensor(19),G2tensor(200),G2tensor(62),G2tensor(58),G1tensor(210),G1tensor(125) &
    ,G1tensor(49),G0tensor(219),G0tensor(134),G0tensor(18)])
  call ol_merge_tensors(G2tensor(237),[G2tensor(222),G2tensor(115),G2tensor(113),G2tensor(100),G2tensor(64),G1tensor(137) &
    ,G1tensor(4),G1tensor(72),G0tensor(146),G0tensor(49),G0tensor(24)])
  call ol_merge_tensors(G2tensor(97),[G2tensor(231),G2tensor(133),G2tensor(131),G2tensor(103),G2tensor(66),G1tensor(152) &
    ,G1tensor(51),G1tensor(38),G0tensor(161),G0tensor(74),G0tensor(34)])
  call ol_merge_tensors(G3tensor(14),[G3tensor(13),G3tensor(8),G3tensor(7),G2tensor(236),G2tensor(233),G2tensor(218),G2tensor(215) &
    ,G1tensor(261),G1tensor(251),G0tensor(234),G0tensor(224)])
  call ol_merge_tensors(G3tensor(16),[G3tensor(15),G3tensor(12),G3tensor(10),G2tensor(242),G2tensor(239),G2tensor(230) &
    ,G2tensor(224),G1tensor(266),G1tensor(256),G0tensor(239),G0tensor(229)])
  call ol_merge_tensors(G3tensor(87),[G3tensor(85),G3tensor(81),G3tensor(79),G3tensor(73),G3tensor(71),G3tensor(18),G3tensor(17) &
    ,G2tensor(248),G2tensor(245),G1tensor(271),G0tensor(244)])
  call ol_merge_tensors(G3tensor(89),[G3tensor(88),G3tensor(83),G3tensor(82),G3tensor(75),G3tensor(74),G3tensor(20),G3tensor(19) &
    ,G2tensor(254),G2tensor(251),G1tensor(276),G0tensor(249)])
  call ol_merge_tensors(G3tensor(53),[G3tensor(51),G2tensor(121),G2tensor(119),G2tensor(109),G2tensor(107),G1tensor(157) &
    ,G1tensor(35),G1tensor(60),G0tensor(166),G0tensor(59),G0tensor(39)])
  call ol_merge_tensors(G2tensor(91),[G2tensor(43),G2tensor(172),G2tensor(157),G1tensor(132),G1tensor(16),G1tensor(6) &
    ,G0tensor(141),G0tensor(58),G0tensor(23)])
  call ol_merge_tensors(G2tensor(34),[G2tensor(6),G2tensor(166),G2tensor(163),G1tensor(147),G1tensor(50),G1tensor(36) &
    ,G0tensor(156),G0tensor(38),G0tensor(33)])
  call ol_merge_tensors(G3tensor(48),[G3tensor(45),G3tensor(25),G3tensor(21),G2tensor(181),G2tensor(169),G1tensor(162) &
    ,G1tensor(47),G1tensor(3),G0tensor(171),G0tensor(73),G0tensor(48)])
  call ol_merge_tensors(G3tensor(27),[G3tensor(23),G2tensor(226),G2tensor(220),G2tensor(187),G2tensor(175),G1tensor(167) &
    ,G1tensor(158),G1tensor(74),G1tensor(52),G0tensor(176),G0tensor(167),G0tensor(83),G0tensor(68)])
  call ol_merge_tensors(G2tensor(156),[G2tensor(190),G1tensor(192),G1tensor(78),G0tensor(201),G0tensor(87)])
  call ol_merge_tensors(G2tensor(99),[G2tensor(193),G1tensor(197),G1tensor(79),G0tensor(206),G0tensor(88)])
  call ol_merge_tensors(G2tensor(83),[G2tensor(162),G2tensor(196),G1tensor(202),G1tensor(103),G1tensor(98),G1tensor(88) &
    ,G0tensor(211),G0tensor(112),G0tensor(107),G0tensor(97)])
  call ol_merge_tensors(G2tensor(102),[G2tensor(199),G1tensor(207),G1tensor(89),G0tensor(216),G0tensor(98)])
  call ol_merge_tensors(G3tensor(33),[G3tensor(31),G2tensor(217),G2tensor(214),G1tensor(269),G1tensor(248),G0tensor(242) &
    ,G0tensor(221)])
  call ol_merge_tensors(G3tensor(39),[G3tensor(36),G2tensor(229),G2tensor(223),G1tensor(274),G1tensor(253),G0tensor(247) &
    ,G0tensor(226)])
  call ol_merge_tensors(G3tensor(43),[G3tensor(41),G2tensor(235),G2tensor(232),G1tensor(258),G0tensor(231)])
  call ol_merge_tensors(G3tensor(49),[G3tensor(46),G2tensor(241),G2tensor(238),G1tensor(263),G0tensor(236)])
  call ol_merge_tensors(G3tensor(54),[G3tensor(52),G2tensor(247),G2tensor(244),G1tensor(268),G0tensor(241)])
  call ol_merge_tensors(G3tensor(56),[G3tensor(55),G2tensor(253),G2tensor(250),G1tensor(273),G0tensor(246)])
  call ol_merge_tensors(G3tensor(58),[G3tensor(29),G1tensor(178),G1tensor(163),G1tensor(97),G1tensor(93),G0tensor(187) &
    ,G0tensor(172),G0tensor(106),G0tensor(102)])
  call ol_merge_tensors(G2tensor(26),[G2tensor(7),G1tensor(138),G1tensor(129),G1tensor(102),G1tensor(94),G0tensor(147) &
    ,G0tensor(138),G0tensor(111),G0tensor(103)])
  call ol_merge_tensors(G2tensor(11),[G1tensor(119),G1tensor(108),G1tensor(99),G0tensor(128),G0tensor(117),G0tensor(108)])
  call ol_merge_tensors(G2tensor(2),[G1tensor(124),G1tensor(109),G1tensor(104),G0tensor(133),G0tensor(118),G0tensor(113)])
  call ol_merge_tensors(G3tensor(64),[G3tensor(62),G3tensor(59),G3tensor(30),G1tensor(183),G1tensor(168),G1tensor(117) &
    ,G1tensor(113),G0tensor(192),G0tensor(177),G0tensor(126),G0tensor(122)])
  call ol_merge_tensors(G2tensor(10),[G1tensor(194),G1tensor(173),G1tensor(122),G1tensor(114),G0tensor(203),G0tensor(182) &
    ,G0tensor(131),G0tensor(123)])
  call ol_merge_tensors(G3tensor(77),[G3tensor(76),G3tensor(57),G3tensor(26),G3tensor(22),G1tensor(164),G1tensor(159) &
    ,G1tensor(154),G1tensor(149),G1tensor(139),G1tensor(134),G0tensor(173),G0tensor(168),G0tensor(163),G0tensor(158),G0tensor(148) &
    ,G0tensor(143)])
  call ol_merge_tensors(G2tensor(39),[G2tensor(30),G1tensor(179),G1tensor(153),G1tensor(144),G0tensor(188),G0tensor(162) &
    ,G0tensor(153)])
  call ol_merge_tensors(G3tensor(38),[G3tensor(35),G3tensor(28),G3tensor(24),G1tensor(209),G1tensor(199),G1tensor(189) &
    ,G1tensor(174),G1tensor(169),G0tensor(218),G0tensor(208),G0tensor(198),G0tensor(183),G0tensor(178)])
  call ol_merge_tensors(G2tensor(42),[G1tensor(204),G1tensor(188),G1tensor(184),G0tensor(213),G0tensor(197),G0tensor(193)])
  call ol_merge_tensors(G1tensor(238),[G1tensor(214)])
  call ol_merge_tensors(G1tensor(219),[G1tensor(215)])
  call ol_merge_tensors(G1tensor(237),[G1tensor(216)])
  call ol_merge_tensors(G1tensor(241),[G1tensor(220)])
  call ol_merge_tensors(G1tensor(231),[G1tensor(223)])
  call ol_merge_tensors(G1tensor(245),[G1tensor(224)])
  call ol_merge_tensors(G1tensor(235),[G1tensor(227)])
  call ol_merge_tensors(G1tensor(242),[G1tensor(230)])
  call ol_merge_tensors(G1tensor(246),[G1tensor(234)])
  call ol_merge_tensors(G3tensor(61),[G3tensor(60),G1tensor(249),G0tensor(222)])
  call ol_merge_tensors(G3tensor(34),[G3tensor(32),G1tensor(250),G0tensor(223)])
  call ol_merge_tensors(G3tensor(65),[G3tensor(63),G1tensor(254),G0tensor(227)])
  call ol_merge_tensors(G3tensor(40),[G3tensor(37),G1tensor(255),G0tensor(228)])
  call ol_merge_tensors(G3tensor(67),[G3tensor(66),G1tensor(259),G0tensor(232)])
  call ol_merge_tensors(G3tensor(44),[G3tensor(42),G1tensor(270),G1tensor(260),G0tensor(243),G0tensor(233)])
  call ol_merge_tensors(G3tensor(69),[G3tensor(68),G1tensor(264),G0tensor(237)])
  call ol_merge_tensors(G3tensor(50),[G3tensor(47),G1tensor(275),G1tensor(265),G0tensor(248),G0tensor(238)])
  call TI_triangle_red(G2tensor(93),RedBasis(33),mass3set(:,1),G0tensor(10),G0tensor(15),G0tensor(20),G0tensor(25),M2L1R1)
  call TI_triangle_red(G2tensor(4),RedBasis(32),mass3set(:,1),G0tensor(30),G0tensor(35),G0tensor(40),G0tensor(45),M2L1R1)
  call TI_triangle_red(G2tensor(78),RedBasis(58),mass3set(:,1),G0tensor(50),G0tensor(55),G0tensor(60),G0tensor(65),M2L1R1)
  call TI_triangle_red(G2tensor(38),RedBasis(64),mass3set(:,1),G0tensor(70),G0tensor(75),G0tensor(80),G0tensor(85),M2L1R1)
  call TI_triangle_red(G2tensor(81),RedBasis(17),mass3set(:,1),G0tensor(90),G0tensor(95),G0tensor(100),G0tensor(105),M2L1R1)
  call TI_triangle_red(G2tensor(31),RedBasis(62),mass3set(:,1),G0tensor(110),G0tensor(115),G0tensor(120),G0tensor(125),M2L1R1)
  call TI_triangle_red(G2tensor(168),RedBasis(11),mass3set(:,1),G0tensor(130),G0tensor(135),G0tensor(140),G0tensor(145),M2L1R1)
  call TI_triangle_red(G2tensor(108),RedBasis(6),mass3set(:,1),G0tensor(150),G0tensor(155),G0tensor(160),G0tensor(165),M2L1R1)
  call TI_triangle_red(G2tensor(152),RedBasis(22),mass3set(:,1),G0tensor(170),G0tensor(175),G0tensor(180),G0tensor(185),M2L1R1)
  call TI_triangle_red(G2tensor(210),RedBasis(7),mass3set(:,1),G0tensor(190),G0tensor(195),G0tensor(200),G0tensor(205),M2L1R1)
  call TI_triangle_red(G2tensor(89),RedBasis(4),mass3set(:,1),G0tensor(210),G0tensor(215),G0tensor(1),G0tensor(2),M2L1R1)
  call TI_triangle_red(G2tensor(72),RedBasis(2),mass3set(:,1),G0tensor(3),G0tensor(4),G0tensor(5),G0tensor(6),M2L1R1)
  call TI_triangle_red(G2tensor(65),RedBasis(1),mass3set(:,1),G0tensor(7),G0tensor(8),G0tensor(9),G0tensor(220),M2L1R1)
  call TI_triangle_red(G2tensor(213),RedBasis(9),mass3set(:,1),G0tensor(225),G0tensor(230),G0tensor(235),G0tensor(240),M2L1R1)
  call TI_triangle_red(G2tensor(75),RedBasis(8),mass3set(:,1),G0tensor(245),G0tensor(217),G0tensor(212),G0tensor(186),M2L1R1)
  call TI_triangle_red(G2tensor(70),RedBasis(19),mass3set(:,1),G0tensor(72),G0tensor(26),G0tensor(21),G0tensor(207),M2L1R1)
  call TI_triangle_red(G3tensor(86),RedBasis(18),mass3set(:,1),G0tensor(202),G0tensor(101),G0tensor(47),G0tensor(31),M2L1R1)
  call TI_triangle_red(G3tensor(11),RedBasis(21),mass3set(:,1),G0tensor(11),G0tensor(136),G0tensor(41),G0tensor(36),M2L1R1)
  call TI_triangle_red(G2tensor(77),RedBasis(24),mass3set(:,1),G0tensor(22),G0tensor(66),G0tensor(57),G0tensor(51),M2L1R1)
  call TI_triangle_red(G2tensor(185),RedBasis(28),mass3set(:,1),G0tensor(46),G0tensor(151),G0tensor(132),G0tensor(127),M2L1R1)
  call TI_triangle_red(G2tensor(85),RedBasis(31),mass3set(:,1),G0tensor(61),G0tensor(56),G0tensor(32),G0tensor(81),M2L1R1)
  call TI_triangle_red(G2tensor(186),RedBasis(30),mass3set(:,1),G0tensor(76),G0tensor(71),G0tensor(37),G0tensor(191),M2L1R1)
  call TI_triangle_red(G2tensor(86),RedBasis(16),mass3set(:,1),G0tensor(157),G0tensor(152),G0tensor(91),G0tensor(86),M2L1R1)
  call TI_triangle_red(G2tensor(69),RedBasis(15),mass3set(:,1),G0tensor(82),G0tensor(142),G0tensor(137),G0tensor(121),M2L1R1)
  call TI_triangle_red(G2tensor(237),RedBasis(56),mass3set(:,1),G0tensor(96),G0tensor(67),G0tensor(16),G0tensor(124),M2L1R1)
  call TI_triangle_red(G2tensor(97),RedBasis(59),mass3set(:,1),G0tensor(116),G0tensor(104),G0tensor(52),G0tensor(199),M2L1R1)
  call TI_triangle_red(G3tensor(14),RedBasis(21),mass3set(:,2),G0tensor(164),G0tensor(119),G0tensor(79),G0tensor(19),M2L1R1,[nMT], &
    G0tensor(14))
  call TI_triangle_red(G3tensor(16),RedBasis(21),mass3set(:,3),G0tensor(139),G0tensor(27),G0tensor(144),G0tensor(63),M2L1R1,[nMB], &
    G0tensor(28))
  call TI_triangle_red(G3tensor(87),RedBasis(18),mass3set(:,2),G0tensor(184),G0tensor(149),G0tensor(94),G0tensor(54),M2L1R1,[nMT], &
    G0tensor(29))
  call TI_triangle_red(G3tensor(89),RedBasis(18),mass3set(:,3),G0tensor(154),G0tensor(109),G0tensor(12), &
    G0tensor(159),M2L1R1,[nMB],G0tensor(114))
  call TI_triangle_red(G3tensor(53),RedBasis(61),mass3set(:,1),G0tensor(43),G0tensor(13),G0tensor(196),G0tensor(99),M2L1R1)
  call TI_triangle_red(G2tensor(91),RedBasis(57),mass3set(:,1),G0tensor(84),G0tensor(42),G0tensor(169),G0tensor(64),M2L1R1)
  call TI_triangle_red(G2tensor(34),RedBasis(60),mass3set(:,1),G0tensor(44),G0tensor(179),G0tensor(174),G0tensor(78),M2L1R1)
  call TI_triangle_red(G3tensor(48),RedBasis(63),mass3set(:,1),G0tensor(53),G0tensor(181),G0tensor(89),G0tensor(69),M2L1R1)
  call TI_triangle_red(G3tensor(27),RedBasis(20),mass3set(:,1),G0tensor(62),G0tensor(194),G0tensor(189),G0tensor(77),M2L1R1)
  call TI_triangle_red(G2tensor(156),RedBasis(66),mass3set(:,1),G0tensor(204),G0tensor(92),G0tensor(209),G0tensor(93),M2L1R1)
  call TI_triangle_red(G2tensor(99),RedBasis(65),mass3set(:,1),G0tensor(214),G0tensor(129),G0tensor(17),G0tensor(219),M2L1R1)
  call TI_triangle_red(G2tensor(83),RedBasis(14),mass3set(:,1),G0tensor(134),G0tensor(18),G0tensor(146),G0tensor(49),M2L1R1)
  call TI_triangle_red(G2tensor(102),RedBasis(67),mass3set(:,1),G0tensor(24),G0tensor(161),G0tensor(74),G0tensor(34),M2L1R1)
  call TI_triangle_red(G3tensor(33),RedBasis(20),mass3set(:,2),G0tensor(234),G0tensor(224),G0tensor(239), &
    G0tensor(229),M2L1R1,[nMT],G0tensor(244))
  call TI_triangle_red(G3tensor(39),RedBasis(20),mass3set(:,3),G0tensor(249),G0tensor(166),G0tensor(59),G0tensor(39),M2L1R1,[nMB], &
    G0tensor(141))
  call TI_triangle_red(G3tensor(43),RedBasis(63),mass3set(:,2),G0tensor(58),G0tensor(23),G0tensor(156),G0tensor(38),M2L1R1,[nMT], &
    G0tensor(33))
  call TI_triangle_red(G3tensor(49),RedBasis(63),mass3set(:,3),G0tensor(171),G0tensor(73),G0tensor(48),G0tensor(176),M2L1R1,[nMB], &
    G0tensor(167))
  call TI_triangle_red(G3tensor(54),RedBasis(61),mass3set(:,2),G0tensor(83),G0tensor(68),G0tensor(201),G0tensor(87),M2L1R1,[nMT], &
    G0tensor(206))
  call TI_triangle_red(G3tensor(56),RedBasis(61),mass3set(:,3),G0tensor(88),G0tensor(211),G0tensor(112), &
    G0tensor(107),M2L1R1,[nMB],G0tensor(97))
  call TI_triangle_red(G3tensor(58),RedBasis(23),mass3set(:,1),G0tensor(216),G0tensor(98),G0tensor(242),G0tensor(221),M2L1R1)
  call TI_triangle_red(G2tensor(26),RedBasis(5),mass3set(:,1),G0tensor(247),G0tensor(226),G0tensor(231),G0tensor(236),M2L1R1)
  call TI_triangle_red(G2tensor(11),RedBasis(13),mass3set(:,1),G0tensor(241),G0tensor(246),G0tensor(187),G0tensor(172),M2L1R1)
  call TI_triangle_red(G2tensor(2),RedBasis(12),mass3set(:,1),G0tensor(106),G0tensor(102),G0tensor(147),G0tensor(138),M2L1R1)
  call TI_triangle_red(G3tensor(64),RedBasis(27),mass3set(:,1),G0tensor(111),G0tensor(103),G0tensor(128),G0tensor(117),M2L1R1)
  call TI_triangle_red(G2tensor(10),RedBasis(26),mass3set(:,1),G0tensor(108),G0tensor(133),G0tensor(118),G0tensor(113),M2L1R1)
  call TI_triangle_red(G3tensor(77),RedBasis(3),mass3set(:,1),G0tensor(192),G0tensor(177),G0tensor(126),G0tensor(122),M2L1R1)
  call TI_triangle_red(G2tensor(39),RedBasis(10),mass3set(:,1),G0tensor(203),G0tensor(182),G0tensor(131),G0tensor(123),M2L1R1)
  call TI_triangle_red(G3tensor(38),RedBasis(25),mass3set(:,1),G0tensor(173),G0tensor(168),G0tensor(163),G0tensor(158),M2L1R1)
  call TI_triangle_red(G2tensor(42),RedBasis(29),mass3set(:,1),G0tensor(148),G0tensor(143),G0tensor(188),G0tensor(162),M2L1R1)
  call TI_triangle_red(G3tensor(61),RedBasis(27),mass3set(:,2),G0tensor(153),G0tensor(218),G0tensor(208), &
    G0tensor(198),M2L1R1,[nMT],G0tensor(183))
  call TI_triangle_red(G3tensor(34),RedBasis(25),mass3set(:,2),G0tensor(178),G0tensor(213),G0tensor(197), &
    G0tensor(193),M2L1R1,[nMT],G0tensor(222))
  call TI_triangle_red(G3tensor(65),RedBasis(27),mass3set(:,3),G0tensor(223),G0tensor(227),G0tensor(228), &
    G0tensor(232),M2L1R1,[nMB],G0tensor(243))
  call TI_triangle_red(G3tensor(40),RedBasis(25),mass3set(:,3),G0tensor(233),G0tensor(237),G0tensor(248), &
    G0tensor(238),M2L1R1,[nMB],G0tensor(250))
  call TI_triangle_red(G3tensor(67),RedBasis(23),mass3set(:,2),G0tensor(251),G0tensor(252),G0tensor(253), &
    G0tensor(254),M2L1R1,[nMT],G0tensor(255))
  call TI_triangle_red(G3tensor(44),RedBasis(3),mass3set(:,2),G0tensor(256),G0tensor(257),G0tensor(258), &
    G0tensor(259),M2L1R1,[nMT],G0tensor(260))
  call TI_triangle_red(G3tensor(69),RedBasis(23),mass3set(:,3),G0tensor(261),G0tensor(262),G0tensor(263), &
    G0tensor(264),M2L1R1,[nMB],G0tensor(265))
  call TI_triangle_red(G3tensor(50),RedBasis(3),mass3set(:,3),G0tensor(266),G0tensor(267),G0tensor(268), &
    G0tensor(269),M2L1R1,[nMB],G0tensor(270))
  call ol_merge_tensors(T0sum(58),[G0tensor(10)])
  call ol_merge_tensors(T0sum(59),[G0tensor(30)])
  call ol_merge_tensors(T0sum(60),[G0tensor(50)])
  call ol_merge_tensors(T0sum(61),[G0tensor(70)])
  call ol_merge_tensors(T0sum(62),[G0tensor(90)])
  call ol_merge_tensors(T0sum(63),[G0tensor(110)])
  call ol_merge_tensors(T0sum(64),[G0tensor(130)])
  call ol_merge_tensors(T0sum(65),[G0tensor(150)])
  call ol_merge_tensors(T0sum(66),[G0tensor(170)])
  call ol_merge_tensors(T0sum(67),[G0tensor(190)])
  call ol_merge_tensors(T0sum(68),[G0tensor(210)])
  call ol_merge_tensors(T0sum(69),[G0tensor(3)])
  call ol_merge_tensors(T0sum(70),[G0tensor(7)])
  call ol_merge_tensors(T0sum(71),[G0tensor(225)])
  call ol_merge_tensors(T0sum(72),[G0tensor(245)])
  call ol_merge_tensors(T0sum(73),[G0tensor(72)])
  call ol_merge_tensors(T0sum(74),[G0tensor(202)])
  call ol_merge_tensors(T0sum(75),[G0tensor(11)])
  call ol_merge_tensors(T0sum(76),[G0tensor(22)])
  call ol_merge_tensors(T0sum(77),[G0tensor(46)])
  call ol_merge_tensors(T0sum(78),[G0tensor(61)])
  call ol_merge_tensors(T0sum(79),[G0tensor(76)])
  call ol_merge_tensors(T0sum(80),[G0tensor(157)])
  call ol_merge_tensors(T0sum(81),[G0tensor(82)])
  call ol_merge_tensors(T0sum(82),[G0tensor(96)])
  call ol_merge_tensors(T0sum(83),[G0tensor(116)])
  call ol_merge_tensors(T0sum(84),[G0tensor(164)])
  call ol_merge_tensors(T0sum(85),[G0tensor(139)])
  call ol_merge_tensors(T0sum(86),[G0tensor(184)])
  call ol_merge_tensors(T0sum(87),[G0tensor(154)])
  call ol_merge_tensors(T0sum(88),[G0tensor(43)])
  call ol_merge_tensors(T0sum(89),[G0tensor(84)])
  call ol_merge_tensors(T0sum(90),[G0tensor(44)])
  call ol_merge_tensors(T0sum(91),[G0tensor(53)])
  call ol_merge_tensors(T0sum(92),[G0tensor(62)])
  call ol_merge_tensors(T0sum(93),[G0tensor(204)])
  call ol_merge_tensors(T0sum(94),[G0tensor(214)])
  call ol_merge_tensors(T0sum(95),[G0tensor(134)])
  call ol_merge_tensors(T0sum(96),[G0tensor(24)])
  call ol_merge_tensors(T0sum(97),[G0tensor(234)])
  call ol_merge_tensors(T0sum(98),[G0tensor(249)])
  call ol_merge_tensors(T0sum(99),[G0tensor(58)])
  call ol_merge_tensors(T0sum(100),[G0tensor(171)])
  call ol_merge_tensors(T0sum(101),[G0tensor(83)])
  call ol_merge_tensors(T0sum(102),[G0tensor(88)])
  call ol_merge_tensors(T0sum(103),[G0tensor(216)])
  call ol_merge_tensors(T0sum(104),[G0tensor(247)])
  call ol_merge_tensors(T0sum(105),[G0tensor(241)])
  call ol_merge_tensors(T0sum(106),[G0tensor(106)])
  call ol_merge_tensors(T0sum(107),[G0tensor(111)])
  call ol_merge_tensors(T0sum(108),[G0tensor(108)])
  call ol_merge_tensors(T0sum(109),[G0tensor(192)])
  call ol_merge_tensors(T0sum(110),[G0tensor(203)])
  call ol_merge_tensors(T0sum(111),[G0tensor(173)])
  call ol_merge_tensors(T0sum(112),[G0tensor(148)])
  call ol_merge_tensors(T1sum(13),[G1tensor(212)])
  call ol_merge_tensors(T1sum(14),[G1tensor(213)])
  call ol_merge_tensors(T1sum(15),[G1tensor(238)])
  call ol_merge_tensors(T1sum(16),[G1tensor(219)])
  call ol_merge_tensors(T1sum(17),[G1tensor(237)])
  call ol_merge_tensors(T1sum(18),[G1tensor(217)])
  call ol_merge_tensors(T1sum(19),[G1tensor(218)])
  call ol_merge_tensors(T1sum(20),[G1tensor(241)])
  call ol_merge_tensors(T1sum(21),[G1tensor(221)])
  call ol_merge_tensors(T1sum(22),[G1tensor(222)])
  call ol_merge_tensors(T1sum(23),[G1tensor(231)])
  call ol_merge_tensors(T1sum(24),[G1tensor(245)])
  call ol_merge_tensors(T1sum(25),[G1tensor(225)])
  call ol_merge_tensors(T1sum(26),[G1tensor(226)])
  call ol_merge_tensors(T1sum(27),[G1tensor(235)])
  call ol_merge_tensors(T1sum(28),[G1tensor(228)])
  call ol_merge_tensors(T1sum(29),[G1tensor(229)])
  call ol_merge_tensors(T1sum(30),[G1tensor(242)])
  call ol_merge_tensors(T1sum(31),[G1tensor(232)])
  call ol_merge_tensors(T1sum(32),[G1tensor(233)])
  call ol_merge_tensors(T1sum(33),[G1tensor(246)])
  call ol_merge_tensors(T1sum(34),[G1tensor(236)])
  call ol_merge_tensors(T1sum(35),[G1tensor(239)])
  call ol_merge_tensors(T1sum(36),[G1tensor(240)])
  call ol_merge_tensors(T1sum(37),[G1tensor(243)])
  call ol_merge_tensors(T1sum(38),[G1tensor(244)])
  call ol_merge_tensors(T1sum(39),[G1tensor(247)])
  call ol_merge_tensors(T0sum(113),[G0tensor(153)])
  call ol_merge_tensors(T0sum(114),[G0tensor(178)])
  call ol_merge_tensors(T0sum(115),[G0tensor(223)])
  call ol_merge_tensors(T0sum(116),[G0tensor(233)])
  call ol_merge_tensors(T0sum(117),[G0tensor(251)])
  call ol_merge_tensors(T0sum(118),[G0tensor(256)])
  call ol_merge_tensors(T0sum(119),[G0tensor(261)])
  call ol_merge_tensors(T0sum(120),[G0tensor(266)])
  Gcoeff(:)%j = (c(1)*(M(1,:)%j-M(2,:)%j)) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(187),h0tab(:,187),[23,8],[0,0],3,1,wf12(:,3))
  call Hloop_GGG_G_12(ntryL,G0H48(1),ex5(:),wf12(:,3),G0H2(1),m4h2x12x2(:,1),heltab3x48(:,:,10))
  Gcoeff(:)%j = (c(1)*(-M(1,:)%j+M(2,:)%j)) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(188),h0tab(:,188),[23,8],[0,0],3,1,wf12(:,3))
  call Hloop_GGG_G_12(ntryL,G0H48(1),wf12(:,3),ex5(:),G0H2(2),m4h12x2x2(:,1),heltab3x48(:,:,11))
  Gcoeff(:)%j = (c(2)*(-M(1,:)%j+M(2,:)%j)) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(189),h0tab(:,189),[23,8],[0,0],3,1,wf12(:,3))
  call Hloop_GGG_G_23(ntryL,G0H48(1),ex5(:),wf12(:,3),G0H2(3),m4h2x12x2(:,2),heltab3x48(:,:,12))
  Gcoeff(:)%j = (c(1)*(-M(1,:)%j+M(2,:)%j)) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(190),h0tab(:,190),[16,15],[0,0],3,1,wf12(:,3))
  call Hloop_UV_W(ntryL,G0H48(1),0,ex5(:),16,G1H24(11),m3h2x24(:,113),heltab2x48(:,:,178))
  Gcoeff(:)%j = (c(1)*(M(1,:)%j-M(2,:)%j)) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(191),h0tab(:,191),[16,15],[0,0],3,1,wf12(:,3))
  call Hloop_UV_W(ntryL,G0H48(1),0,ex5(:),16,G1H24(13),m3h2x24(:,114),heltab2x48(:,:,179))
  Gcoeff(:)%j = (c(2)*(M(1,:)%j-M(2,:)%j)) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(192),h0tab(:,192),[16,15],[0,0],3,1,wf12(:,3))
  call Hloop_UV_W(ntryL,G0H48(1),0,ex5(:),16,G1H24(26),m3h2x24(:,115),heltab2x48(:,:,180))
  Gcoeff(:)%j = (c(1)*(-M(1,:)%j+M(2,:)%j)) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(193),h0tab(:,193),[24,7],[0,0],3,1,wf12(:,3))
  call Hloop_GGG_G_12(ntryL,G0H48(1),ex5(:),ex4(:),G0H12(9),m4h2x2x12(:,10),heltab3x48(:,:,13))
  Gcoeff(:)%j = (c(1)*(M(1,:)%j-M(2,:)%j)) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(194),h0tab(:,194),[24,7],[0,0],3,1,wf12(:,3))
  call Hloop_GGG_G_12(ntryL,G0H48(1),ex4(:),ex5(:),G0H12(2),m4h2x2x12(:,11),heltab3x48(:,:,14))
  Gcoeff(:)%j = (c(2)*(M(1,:)%j-M(2,:)%j)) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(195),h0tab(:,195),[24,7],[0,0],3,1,wf12(:,3))
  call Hloop_GGG_G_23(ntryL,G0H48(1),ex5(:),ex4(:),G0H12(3),m4h2x2x12(:,12),heltab3x48(:,:,15))
  Gcoeff(:)%j = (c(1)*(M(1,:)%j-M(2,:)%j)) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(196),h0tab(:,196),[23,8],[0,0],3,1,wf12(:,4))
  call Hloop_GGG_G_12(ntryL,G0H48(1),ex5(:),wf12(:,4),G0H2(4),m4h2x12x2(:,3),heltab3x48(:,:,16))
  Gcoeff(:)%j = (c(1)*(-M(1,:)%j+M(2,:)%j)) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(197),h0tab(:,197),[23,8],[0,0],3,1,wf12(:,4))
  call Hloop_GGG_G_12(ntryL,G0H48(1),wf12(:,4),ex5(:),G0H2(5),m4h12x2x2(:,2),heltab3x48(:,:,17))
  Gcoeff(:)%j = (c(2)*(-M(1,:)%j+M(2,:)%j)) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(198),h0tab(:,198),[23,8],[0,0],3,1,wf12(:,4))
  call Hloop_GGG_G_23(ntryL,G0H48(1),ex5(:),wf12(:,4),G0H2(6),m4h2x12x2(:,4),heltab3x48(:,:,18))
  Gcoeff(:)%j = (c(1)*(-M(1,:)%j+M(2,:)%j)) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(199),h0tab(:,199),[16,15],[0,0],3,1,wf12(:,4))
  call Hloop_UV_W(ntryL,G0H48(1),0,ex5(:),16,G1H24(28),m3h2x24(:,116),heltab2x48(:,:,181))
  Gcoeff(:)%j = (c(1)*(M(1,:)%j-M(2,:)%j)) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(200),h0tab(:,200),[16,15],[0,0],3,1,wf12(:,4))
  call Hloop_UV_W(ntryL,G0H48(1),0,ex5(:),16,G1H24(1),m3h2x24(:,117),heltab2x48(:,:,182))
  Gcoeff(:)%j = (c(2)*(M(1,:)%j-M(2,:)%j)) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(201),h0tab(:,201),[16,15],[0,0],3,1,wf12(:,4))
  call Hloop_UV_W(ntryL,G0H48(1),0,ex5(:),16,G1H24(2),m3h2x24(:,118),heltab2x48(:,:,183))
  Gcoeff(:)%j = (c(1)*(-M(1,:)%j+M(2,:)%j)) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(202),h0tab(:,202),[24,7],[0,0],3,1,wf12(:,4))
  call Hloop_GGG_G_12(ntryL,G0H48(1),ex5(:),ex4(:),G0H12(8),m4h2x2x12(:,13),heltab3x48(:,:,19))
  Gcoeff(:)%j = (c(1)*(M(1,:)%j-M(2,:)%j)) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(203),h0tab(:,203),[24,7],[0,0],3,1,wf12(:,4))
  call Hloop_GGG_G_12(ntryL,G0H48(1),ex4(:),ex5(:),G0H12(5),m4h2x2x12(:,14),heltab3x48(:,:,20))
  Gcoeff(:)%j = (c(2)*(M(1,:)%j-M(2,:)%j)) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(204),h0tab(:,204),[24,7],[0,0],3,1,wf12(:,4))
  call Hloop_GGG_G_23(ntryL,G0H48(1),ex5(:),ex4(:),G0H12(4),m4h2x2x12(:,15),heltab3x48(:,:,21))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(205),h0tab(:,205),[21,10],[0,0],2,2,wf12(:,22),wf4(:,2))
  call Hloop_VQ_A(ntryL,G0H48(1),wf12(:,22),G0H4(5),m3h12x4(:,9),heltab2x48(:,:,184))
  call Hloop_Q_A(ntryL,G0H4(5),21,0,G1H4(28),n2h4(39))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(206),h0tab(:,206),[26,5],[0,0],2,2,wf8(:,14),wf6(:,2))
  call Hloop_VA_Q(ntryL,G0H48(1),wf8(:,14),G0H6(1),m3h8x6(:,31),heltab2x48(:,:,185))
  call Hloop_A_Q(ntryL,G0H6(1),26,0,G1H6(58),n2h6(94))
  Gcoeff(:)%j = (-(c(10)*M(2,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(207),h0tab(:,207),[18,13],[0,0],2,2,wf4(:,4),wf12(:,23))
  call Hloop_QA_V(ntryL,G0H48(1),wf4(:,4),G0H12(1),m3h4x12(:,28),heltab2x48(:,:,186))
  Gcoeff(:)%j = (-(c(10)*M(2,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(208),h0tab(:,208),[26,5],[0,0],2,2,wf8(:,16),wf6(:,2))
  call Hloop_VA_Q(ntryL,G0H48(1),wf8(:,16),G0H6(2),m3h8x6(:,32),heltab2x48(:,:,187))
  call Hloop_A_Q(ntryL,G0H6(2),26,0,G1H6(59),n2h6(95))
  Gcoeff(:)%j = (c(13)*(-M(1,:)%j+M(2,:)%j)) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(209),h0tab(:,209),[24,7],[0,0],2,2,wf4(:,5),wf12(:,3))
  call Hloop_QV_A(ntryL,G0H48(1),wf4(:,5),G0H12(6),m3h4x12(:,29),heltab2x48(:,:,188))
  call Hloop_Q_A(ntryL,G0H12(6),24,0,G1H12(17),n2h12(41))
  Gcoeff(:)%j = (c(12)*(-M(1,:)%j+M(2,:)%j)) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(210),h0tab(:,210),[24,7],[nMT,nMT],2,2,wf4(:,5),wf12(:,3))
  call Hloop_QV_A(ntryL,G0H48(1),wf4(:,5),G0H12(7),m3h4x12(:,30),heltab2x48(:,:,189))
  call Hloop_Q_A(ntryL,G0H12(7),24,nMT,G1H12(18),n2h12(42))
  Gcoeff(:)%j = (c(13)*(-M(1,:)%j+M(2,:)%j)) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(211),h0tab(:,211),[24,7],[0,0],2,2,wf4(:,5),wf12(:,3))
  call Hloop_QV_A(ntryL,G0H48(1),wf4(:,5),G0H12(6),m3h4x12(:,31),heltab2x48(:,:,190))
  call Hloop_Q_A(ntryL,G0H12(6),24,0,G1H12(21),n2h12(43))
  Gcoeff(:)%j = (c(12)*(-M(1,:)%j+M(2,:)%j)) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(212),h0tab(:,212),[24,7],[nMB,nMB],2,2,wf4(:,5),wf12(:,3))
  call Hloop_QV_A(ntryL,G0H48(1),wf4(:,5),G0H12(7),m3h4x12(:,32),heltab2x48(:,:,191))
  call Hloop_Q_A(ntryL,G0H12(7),24,nMB,G1H12(12),n2h12(44))
  Gcoeff(:)%j = (c(7)*(-M(1,:)%j+M(2,:)%j)) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(213),h0tab(:,213),[24,7],[0,0],2,2,wf4(:,5),wf12(:,3))
  call Hloop_CV_D(ntryL,G0H48(1),0,wf4(:,5),24,G1H12(14),m3h4x12(:,33),heltab2x48(:,:,192))
  Gcoeff(:)%j = (c(2)*(M(1,:)%j-M(2,:)%j)) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(214),h0tab(:,214),[24,7],[0,0],2,2,wf4(:,5),wf12(:,3))
  call Hloop_UV_W(ntryL,G0H48(1),0,wf4(:,5),24,G1H12(15),m3h4x12(:,34),heltab2x48(:,:,193))
  Gcoeff(:)%j = (c(5)*(M(1,:)%j-M(2,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(215),h0tab(:,215),[26,5],[0,0],2,2,wf8(:,18),wf6(:,2))
  call Hloop_VA_Q(ntryL,G0H48(1),wf8(:,18),G0H6(4),m3h8x6(:,33),heltab2x48(:,:,194))
  call Hloop_A_Q(ntryL,G0H6(4),26,0,G1H6(61),n2h6(96))
  Gcoeff(:)%j = (-(c(10)*M(2,:)%j)) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(216),h0tab(:,216),[25,6],[0,0],2,2,wf8(:,19),wf6(:,4))
  call Hloop_VQ_A(ntryL,G0H48(1),wf8(:,19),G0H6(5),m3h8x6(:,34),heltab2x48(:,:,195))
  call Hloop_Q_A(ntryL,G0H6(5),25,0,G1H6(62),n2h6(97))
  Gcoeff(:)%j = (-(c(10)*M(2,:)%j)) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(217),h0tab(:,217),[22,9],[0,0],2,2,wf12(:,25),wf4(:,7))
  call Hloop_VA_Q(ntryL,G0H48(1),wf12(:,25),G0H4(1),m3h12x4(:,10),heltab2x48(:,:,196))
  call Hloop_A_Q(ntryL,G0H4(1),22,0,G1H4(17),n2h4(40))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(218),h0tab(:,218),[25,6],[0,0],2,2,wf8(:,20),wf6(:,4))
  call Hloop_VQ_A(ntryL,G0H48(1),wf8(:,20),G0H6(6),m3h8x6(:,35),heltab2x48(:,:,197))
  call Hloop_Q_A(ntryL,G0H6(6),25,0,G1H6(63),n2h6(98))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(219),h0tab(:,219),[17,14],[0,0],2,2,wf4(:,9),wf12(:,27))
  call Hloop_AQ_V(ntryL,G0H48(1),wf4(:,9),G0H12(6),m3h4x12(:,35),heltab2x48(:,:,198))
  Gcoeff(:)%j = (c(13)*(-M(1,:)%j+M(2,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(220),h0tab(:,220),[24,7],[0,0],2,2,wf4(:,5),wf12(:,4))
  call Hloop_QV_A(ntryL,G0H48(1),wf4(:,5),G0H12(7),m3h4x12(:,36),heltab2x48(:,:,199))
  call Hloop_Q_A(ntryL,G0H12(7),24,0,G1H12(19),n2h12(45))
  Gcoeff(:)%j = (c(12)*(-M(1,:)%j+M(2,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(221),h0tab(:,221),[24,7],[nMT,nMT],2,2,wf4(:,5),wf12(:,4))
  call Hloop_QV_A(ntryL,G0H48(1),wf4(:,5),G0H12(7),m3h4x12(:,37),heltab2x48(:,:,200))
  call Hloop_Q_A(ntryL,G0H12(7),24,nMT,G1H12(20),n2h12(46))
  Gcoeff(:)%j = (c(13)*(-M(1,:)%j+M(2,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(222),h0tab(:,222),[24,7],[0,0],2,2,wf4(:,5),wf12(:,4))
  call Hloop_QV_A(ntryL,G0H48(1),wf4(:,5),G0H12(7),m3h4x12(:,38),heltab2x48(:,:,201))
  call Hloop_Q_A(ntryL,G0H12(7),24,0,G1H12(22),n2h12(47))
  Gcoeff(:)%j = (c(12)*(-M(1,:)%j+M(2,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(223),h0tab(:,223),[24,7],[nMB,nMB],2,2,wf4(:,5),wf12(:,4))
  call Hloop_QV_A(ntryL,G0H48(1),wf4(:,5),G0H12(7),m3h4x12(:,39),heltab2x48(:,:,202))
  call Hloop_Q_A(ntryL,G0H12(7),24,nMB,G1H12(23),n2h12(48))
  Gcoeff(:)%j = (c(7)*(-M(1,:)%j+M(2,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(224),h0tab(:,224),[24,7],[0,0],2,2,wf4(:,5),wf12(:,4))
  call Hloop_CV_D(ntryL,G0H48(1),0,wf4(:,5),24,G1H12(2),m3h4x12(:,40),heltab2x48(:,:,203))
  Gcoeff(:)%j = (c(2)*(M(1,:)%j-M(2,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(225),h0tab(:,225),[24,7],[0,0],2,2,wf4(:,5),wf12(:,4))
  call Hloop_UV_W(ntryL,G0H48(1),0,wf4(:,5),24,G1H12(10),m3h4x12(:,41),heltab2x48(:,:,204))
  Gcoeff(:)%j = (c(5)*(M(1,:)%j-M(2,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(226),h0tab(:,226),[25,6],[0,0],2,2,wf8(:,22),wf6(:,4))
  call Hloop_AQ_V(ntryL,G0H48(1),wf8(:,22),G0H6(7),m3h8x6(:,36),heltab2x48(:,:,205))
  Gcoeff(:)%j = (-(c(10)*M(2,:)%j)) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(227),h0tab(:,227),[18,13],[0,0],2,2,wf4(:,4),wf12(:,30))
  call Hloop_QA_V(ntryL,G0H48(1),wf4(:,4),G0H12(7),m3h4x12(:,42),heltab2x48(:,:,206))
  Gcoeff(:)%j = (-(c(10)*M(2,:)%j)) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(228),h0tab(:,228),[22,9],[0,0],2,2,wf12(:,29),wf4(:,7))
  call Hloop_VA_Q(ntryL,G0H48(1),wf12(:,29),G0H4(2),m3h12x4(:,11),heltab2x48(:,:,207))
  call Hloop_A_Q(ntryL,G0H4(2),22,0,G1H4(18),n2h4(41))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(64)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(229),h0tab(:,229),[21,10],[0,0],2,2,wf12(:,33),wf4(:,2))
  call Hloop_VQ_A(ntryL,G0H48(1),wf12(:,33),G0H4(3),m3h12x4(:,12),heltab2x48(:,:,208))
  call Hloop_Q_A(ntryL,G0H4(3),21,0,G1H4(1),n2h4(42))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(230),h0tab(:,230),[17,14],[0,0],2,2,wf4(:,9),wf12(:,32))
  call Hloop_AQ_V(ntryL,G0H48(1),wf4(:,9),G0H12(10),m3h4x12(:,43),heltab2x48(:,:,209))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H2(6),[G0H2(5),G0H2(4),G0H2(3),G0H2(2),G0H2(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(15),[G0H12(3),G0H12(2),G0H12(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(10),[G0H12(4),G0H12(5),G0H12(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1),[G1H4(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(61),[G1H6(59),G1H6(58)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(21),[G1H12(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(63),[G1H6(62)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(18),[G1H4(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(22),[G1H12(19)])
  call Hcheck_last_UV_W(ntryL,l_switch,G0H2(6),23,ex4(:),8,G1tensor(1),m3h2x1(:,216),heltab2x2(:,:,216))
  call Hcheck_last_GGG_G_12(ntryL,l_switch,G1H24(11),ex4(:),wf12(:,3),G1tensor(31),m4h2x12x1(:,1),heltab3x24(:,:,1))
  call Hcheck_last_GGG_G_12(ntryL,l_switch,G1H24(13),wf12(:,3),ex4(:),G1tensor(61),m4h12x2x1(:,1),heltab3x24(:,:,2))
  call Hcheck_last_GGG_G_23(ntryL,l_switch,G1H24(26),ex4(:),wf12(:,3),G1tensor(12),m4h2x12x1(:,2),heltab3x24(:,:,3))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H12(15),24,wf12(:,3),7,G2tensor(111),m3h12x1(:,9),heltab2x12(:,:,90))
  call Hcheck_last_GGG_G_12(ntryL,l_switch,G1H24(28),ex4(:),wf12(:,4),G1tensor(30),m4h2x12x1(:,3),heltab3x24(:,:,4))
  call Hcheck_last_GGG_G_12(ntryL,l_switch,G1H24(1),wf12(:,4),ex4(:),G1tensor(42),m4h12x2x1(:,2),heltab3x24(:,:,5))
  call Hcheck_last_GGG_G_23(ntryL,l_switch,G1H24(2),ex4(:),wf12(:,4),G1tensor(54),m4h2x12x1(:,4),heltab3x24(:,:,6))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H12(10),24,wf12(:,4),7,G2tensor(27),m3h12x1(:,10),heltab2x12(:,:,91))
  call Hcheck_last_QA_V(ntryL,l_switch,G1H4(1),wf4(:,2),G1tensor(68),m3h4x1(:,25),heltab2x4(:,:,72))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H6(61),wf6(:,2),G1tensor(11),m3h6x1(:,23),heltab2x6(:,:,185))
  call Hloop_VQ_A(ntryL,G0H12(1),wf12(:,23),G0H1(1),m3h12x1(:,11),heltab2x12(:,:,92))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),31,0,G1tensor(10),n2h1(335))
  call Hloop_QV_A(ntryL,G1H12(21),wf12(:,3),G1H1(1),m3h12x1(:,12),heltab2x12(:,:,93))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(117),n2h1(336))
  call Hloop_QV_A(ntryL,G1H12(18),wf12(:,3),G1H1(1),m3h12x1(:,13),heltab2x12(:,:,94))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(207),n2h1(337))
  call Hloop_QV_A(ntryL,G1H12(12),wf12(:,3),G1H1(1),m3h12x1(:,14),heltab2x12(:,:,95))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(123),n2h1(338))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H12(14),24,wf12(:,3),7,G2tensor(129),m3h12x1(:,15),heltab2x12(:,:,96))
  call Hcheck_last_QA_V(ntryL,l_switch,G1H6(63),wf6(:,4),G1tensor(17),m3h6x1(:,24),heltab2x6(:,:,186))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H4(18),wf4(:,7),G1tensor(23),m3h4x1(:,26),heltab2x4(:,:,73))
  call Hloop_VA_Q(ntryL,G0H12(6),wf12(:,27),G0H1(1),m3h12x1(:,16),heltab2x12(:,:,97))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,0,G1tensor(58),n2h1(339))
  call Hloop_QV_A(ntryL,G1H12(22),wf12(:,4),G1H1(1),m3h12x1(:,17),heltab2x12(:,:,98))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(35),n2h1(340))
  call Hloop_QV_A(ntryL,G1H12(20),wf12(:,4),G1H1(1),m3h12x1(:,18),heltab2x12(:,:,99))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(135),n2h1(341))
  call Hloop_QV_A(ntryL,G1H12(23),wf12(:,4),G1H1(1),m3h12x1(:,19),heltab2x12(:,:,100))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(141),n2h1(342))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H12(2),24,wf12(:,4),7,G2tensor(201),m3h12x1(:,20),heltab2x12(:,:,101))
  call Hloop_VA_Q(ntryL,G0H6(7),wf6(:,4),G0H1(1),m3h6x1(:,25),heltab2x6(:,:,187))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,0,G1tensor(57),n2h1(343))
  call Hloop_VQ_A(ntryL,G0H12(7),wf12(:,30),G0H1(1),m3h12x1(:,21),heltab2x12(:,:,102))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),31,0,G1tensor(69),n2h1(344))
  call Hloop_VA_Q(ntryL,G0H12(10),wf12(:,32),G0H1(1),m3h12x1(:,22),heltab2x12(:,:,103))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,0,G1tensor(76),n2h1(345))
  call ol_merge_tensors(G0tensor(147),[G0tensor(187),G0tensor(74),G0tensor(146),G0tensor(174),G0tensor(67),G0tensor(151) &
    ,G0tensor(66),G0tensor(8),G0tensor(135),G0tensor(120),G0tensor(100),G0tensor(75),G0tensor(15)])
  call ol_merge_tensors(G0tensor(188),[G0tensor(163),G0tensor(118),G0tensor(128),G0tensor(98),G0tensor(89),G0tensor(13) &
    ,G0tensor(101),G0tensor(230),G0tensor(215),G0tensor(95),G0tensor(55),G0tensor(40),G0tensor(20)])
  call ol_merge_tensors(G1tensor(57),[G1tensor(17),G0tensor(182),G0tensor(42),G0tensor(52),G0tensor(137),G0tensor(91),G0tensor(4) &
    ,G0tensor(105),G0tensor(25)])
  call ol_merge_tensors(G0tensor(17),[G0tensor(209),G0tensor(169),G0tensor(104),G0tensor(26),G0tensor(195),G0tensor(175) &
    ,G0tensor(155),G0tensor(115),G0tensor(80),G0tensor(60),G0tensor(35)])
  call ol_merge_tensors(G1tensor(11),[G0tensor(226),G0tensor(179),G0tensor(16),G0tensor(37),G0tensor(32),G0tensor(217) &
    ,G0tensor(65),G0tensor(45)])
  call ol_merge_tensors(G0tensor(194),[G0tensor(181),G0tensor(196),G0tensor(136),G0tensor(125),G0tensor(85)])
  call ol_merge_tensors(G1tensor(1),[G0tensor(131),G0tensor(126),G0tensor(103),G0tensor(231),G0tensor(242),G0tensor(18) &
    ,G0tensor(92),G0tensor(189),G0tensor(152),G0tensor(56),G0tensor(160),G0tensor(140)])
  call ol_merge_tensors(G1tensor(68),[G0tensor(143),G0tensor(49),G0tensor(129),G0tensor(71),G0tensor(21),G0tensor(212) &
    ,G0tensor(235),G0tensor(145)])
  call ol_merge_tensors(G1tensor(23),[G0tensor(133),G0tensor(161),G0tensor(93),G0tensor(142),G0tensor(57),G0tensor(5),G0tensor(1) &
    ,G0tensor(165)])
  call ol_merge_tensors(G0tensor(117),[G0tensor(246),G0tensor(221),G0tensor(132),G0tensor(41),G0tensor(180)])
  call ol_merge_tensors(G1tensor(69),[G1tensor(10),G0tensor(113),G0tensor(102),G0tensor(236),G0tensor(81),G0tensor(9),G0tensor(2) &
    ,G0tensor(185)])
  call ol_merge_tensors(G1tensor(76),[G1tensor(58),G0tensor(162),G0tensor(123),G0tensor(172),G0tensor(86),G0tensor(127) &
    ,G0tensor(240),G0tensor(200)])
  call ol_merge_tensors(G1tensor(54),[G1tensor(42),G1tensor(30),G1tensor(12),G1tensor(61),G1tensor(31),G0tensor(158),G0tensor(122) &
    ,G0tensor(138),G0tensor(121),G0tensor(191),G0tensor(36),G0tensor(31),G0tensor(186),G0tensor(220),G0tensor(6),G0tensor(205)])
  call ol_merge_tensors(G0tensor(168),[G0tensor(34),G0tensor(219),G0tensor(77),G0tensor(51),G0tensor(47),G0tensor(207)])
  call ol_merge_tensors(G2tensor(201),[G2tensor(35),G2tensor(129),G2tensor(117),G2tensor(27),G2tensor(111),G0tensor(177) &
    ,G0tensor(69),G0tensor(78),G0tensor(64),G0tensor(99),G0tensor(199),G0tensor(124)])
  call ol_merge_tensors(G0tensor(201),[G0tensor(23),G0tensor(224),G0tensor(119)])
  call ol_merge_tensors(G0tensor(254),[G0tensor(198),G0tensor(79)])
  call ol_merge_tensors(G0tensor(259),[G0tensor(193),G0tensor(54),G0tensor(19)])
  call ol_merge_tensors(G0tensor(260),[G0tensor(255),G0tensor(222),G0tensor(183),G0tensor(206),G0tensor(33),G0tensor(244) &
    ,G0tensor(29),G0tensor(14)])
  call ol_merge_tensors(G0tensor(112),[G0tensor(73),G0tensor(166),G0tensor(27)])
  call ol_merge_tensors(G0tensor(264),[G0tensor(232),G0tensor(144)])
  call ol_merge_tensors(G0tensor(269),[G0tensor(238),G0tensor(159),G0tensor(63)])
  call ol_merge_tensors(G0tensor(270),[G0tensor(265),G0tensor(250),G0tensor(243),G0tensor(97),G0tensor(167),G0tensor(141) &
    ,G0tensor(114),G0tensor(28)])
  call ol_merge_tensors(G0tensor(252),[G0tensor(197),G0tensor(208),G0tensor(68),G0tensor(156),G0tensor(149)])
  call ol_merge_tensors(G0tensor(213),[G0tensor(229),G0tensor(94)])
  call ol_merge_tensors(G0tensor(262),[G0tensor(248),G0tensor(228),G0tensor(211),G0tensor(48),G0tensor(109)])
  call ol_merge_tensors(G0tensor(237),[G0tensor(39),G0tensor(12)])
  call ol_merge_tensors(G0tensor(258),[G0tensor(253),G0tensor(218),G0tensor(239)])
  call ol_merge_tensors(G0tensor(268),[G0tensor(263),G0tensor(227),G0tensor(59)])
  call ol_merge_tensors(G2tensor(135),[G2tensor(207),G0tensor(257),G0tensor(87),G0tensor(38)])
  call ol_merge_tensors(G2tensor(141),[G2tensor(123),G0tensor(267),G0tensor(107),G0tensor(176)])
call TI_bubble_red(G2tensor(201),24,mass2set(:,1),G0tensor(10),M2L1R1)
call TI_bubble_red(G2tensor(135),24,mass2set(:,2),G0tensor(30),M2L1R1,G0tensor(50))
call TI_bubble_red(G2tensor(141),24,mass2set(:,3),G0tensor(70),M2L1R1,G0tensor(90))
  call ol_merge_tensors(G0tensor(50),[G0tensor(260)])
  call ol_merge_tensors(G0tensor(90),[G0tensor(270)])
call TI_bubble_red(G1tensor(57),25,mass2set(:,1),G0tensor(110),M2L1R1)
call TI_bubble_red(G1tensor(11),26,mass2set(:,1),G0tensor(130),M2L1R1)
call TI_bubble_red(G1tensor(1),23,mass2set(:,1),G0tensor(150),M2L1R1)
call TI_bubble_red(G1tensor(68),21,mass2set(:,1),G0tensor(170),M2L1R1)
call TI_bubble_red(G1tensor(23),22,mass2set(:,1),G0tensor(190),M2L1R1)
call TI_bubble_red(G1tensor(69),18,mass2set(:,1),G0tensor(210),M2L1R1)
call TI_bubble_red(G1tensor(76),17,mass2set(:,1),G0tensor(3),M2L1R1)
call TI_bubble_red(G1tensor(54),16,mass2set(:,1),G0tensor(7),M2L1R1)
  call ol_merge_tensors(T0sum(121),[G0tensor(147)])
  call ol_merge_tensors(T0sum(122),[G0tensor(188)])
  call ol_merge_tensors(T0sum(123),[G0tensor(110)])
  call ol_merge_tensors(T0sum(124),[G0tensor(17)])
  call ol_merge_tensors(T0sum(125),[G0tensor(130)])
  call ol_merge_tensors(T0sum(126),[G0tensor(194)])
  call ol_merge_tensors(T0sum(127),[G0tensor(150)])
  call ol_merge_tensors(T0sum(128),[G0tensor(170)])
  call ol_merge_tensors(T0sum(129),[G0tensor(190)])
  call ol_merge_tensors(T0sum(130),[G0tensor(117)])
  call ol_merge_tensors(T0sum(131),[G0tensor(210)])
  call ol_merge_tensors(T0sum(132),[G0tensor(3)])
  call ol_merge_tensors(T0sum(133),[G0tensor(7)])
  call ol_merge_tensors(T0sum(134),[G0tensor(168)])
  call ol_merge_tensors(T0sum(135),[G0tensor(10)])
  call ol_merge_tensors(T0sum(136),[G0tensor(201)])
  call ol_merge_tensors(T0sum(137),[G0tensor(254)])
  call ol_merge_tensors(T0sum(138),[G0tensor(259)])
  call ol_merge_tensors(T0sum(139),[G0tensor(50)])
  call ol_merge_tensors(T0sum(140),[G0tensor(112)])
  call ol_merge_tensors(T0sum(141),[G0tensor(264)])
  call ol_merge_tensors(T0sum(142),[G0tensor(269)])
  call ol_merge_tensors(T0sum(143),[G0tensor(90)])
  call ol_merge_tensors(T0sum(144),[G0tensor(252)])
  call ol_merge_tensors(T0sum(145),[G0tensor(213)])
  call ol_merge_tensors(T0sum(146),[G0tensor(262)])
  call ol_merge_tensors(T0sum(147),[G0tensor(237)])
  call ol_merge_tensors(T0sum(148),[G0tensor(258)])
  call ol_merge_tensors(T0sum(149),[G0tensor(268)])
  call ol_merge_tensors(T0sum(150),[G0tensor(30)])
  call ol_merge_tensors(T0sum(151),[G0tensor(70)])


! Compute scalar Master integrals 

  call compute_scalar_box([ 17, 21, 29 ],masses2_9,RedSet_4(10),ScalarBoxes(1))
  call compute_scalar_box([ 16, 21, 29 ],masses2_9,RedSet_4(11),ScalarBoxes(2))
  call compute_scalar_box([ 16, 17, 29 ],masses2_9,RedSet_4(1),ScalarBoxes(3))
  call compute_scalar_box([ 16, 17, 21 ],masses2_9,RedSet_4(2),ScalarBoxes(4))
  call compute_scalar_box([ 1, 5, 13 ],masses2_9,RedSet_4(12),ScalarBoxes(5))
  call compute_scalar_box([ 17, 25, 29 ],masses2_9,RedSet_4(13),ScalarBoxes(6))
  call compute_scalar_box([ 16, 25, 29 ],masses2_9,RedSet_4(14),ScalarBoxes(7))
  call compute_scalar_box([ 16, 17, 25 ],masses2_9,RedSet_4(3),ScalarBoxes(8))
  call compute_scalar_box([ 1, 9, 13 ],masses2_9,RedSet_4(15),ScalarBoxes(9))
  call compute_scalar_box([ 18, 22, 23 ],masses2_9,RedSet_4(16),ScalarBoxes(10))
  call compute_scalar_box([ 16, 22, 23 ],masses2_9,RedSet_4(17),ScalarBoxes(11))
  call compute_scalar_box([ 16, 18, 23 ],masses2_9,RedSet_4(18),ScalarBoxes(12))
  call compute_scalar_box([ 16, 18, 22 ],masses2_9,RedSet_4(4),ScalarBoxes(13))
  call compute_scalar_box([ 2, 6, 7 ],masses2_9,RedSet_4(19),ScalarBoxes(14))
  call compute_scalar_box([ 17, 21, 23 ],masses2_9,RedSet_4(20),ScalarBoxes(15))
  call compute_scalar_box([ 16, 21, 23 ],masses2_9,RedSet_4(21),ScalarBoxes(16))
  call compute_scalar_box([ 16, 17, 23 ],masses2_9,RedSet_4(22),ScalarBoxes(17))
  call compute_scalar_box([ 1, 5, 7 ],masses2_9,RedSet_4(23),ScalarBoxes(18))
  call compute_scalar_box([ 20, 21, 23 ],masses2_9,RedSet_4(24),ScalarBoxes(19))
  call compute_scalar_box([ 16, 20, 23 ],masses2_9,RedSet_4(25),ScalarBoxes(20))
  call compute_scalar_box([ 16, 20, 21 ],masses2_9,RedSet_4(5),ScalarBoxes(21))
  call compute_scalar_box([ 4, 5, 7 ],masses2_9,RedSet_4(26),ScalarBoxes(22))
  call compute_scalar_box([ 18, 19, 23 ],masses2_9,RedSet_4(27),ScalarBoxes(23))
  call compute_scalar_box([ 16, 19, 23 ],masses2_9,RedSet_4(28),ScalarBoxes(24))
  call compute_scalar_box([ 16, 18, 19 ],masses2_9,RedSet_4(6),ScalarBoxes(25))
  call compute_scalar_box([ 2, 3, 7 ],masses2_9,RedSet_4(29),ScalarBoxes(26))
  call compute_scalar_box([ 20, 22, 23 ],masses2_9,RedSet_4(30),ScalarBoxes(27))
  call compute_scalar_box([ 16, 20, 22 ],masses2_9,RedSet_4(7),ScalarBoxes(28))
  call compute_scalar_box([ 4, 6, 7 ],masses2_9,RedSet_4(31),ScalarBoxes(29))
  call compute_scalar_box([ 18, 19, 27 ],masses2_9,RedSet_4(32),ScalarBoxes(30))
  call compute_scalar_box([ 16, 19, 27 ],masses2_9,RedSet_4(33),ScalarBoxes(31))
  call compute_scalar_box([ 16, 18, 27 ],masses2_9,RedSet_4(34),ScalarBoxes(32))
  call compute_scalar_box([ 2, 3, 11 ],masses2_9,RedSet_4(35),ScalarBoxes(33))
  call compute_scalar_box([ 17, 19, 23 ],masses2_9,RedSet_4(36),ScalarBoxes(34))
  call compute_scalar_box([ 16, 17, 19 ],masses2_9,RedSet_4(8),ScalarBoxes(35))
  call compute_scalar_box([ 1, 3, 7 ],masses2_9,RedSet_4(37),ScalarBoxes(36))
  call compute_scalar_box([ 17, 19, 27 ],masses2_9,RedSet_4(38),ScalarBoxes(37))
  call compute_scalar_box([ 16, 17, 27 ],masses2_9,RedSet_4(39),ScalarBoxes(38))
  call compute_scalar_box([ 1, 3, 11 ],masses2_9,RedSet_4(40),ScalarBoxes(39))
  call compute_scalar_box([ 18, 26, 27 ],masses2_9,RedSet_4(41),ScalarBoxes(40))
  call compute_scalar_box([ 16, 26, 27 ],masses2_9,RedSet_4(42),ScalarBoxes(41))
  call compute_scalar_box([ 16, 18, 26 ],masses2_9,RedSet_4(9),ScalarBoxes(42))
  call compute_scalar_box([ 2, 10, 11 ],masses2_9,RedSet_4(43),ScalarBoxes(43))
  call compute_scalar_box([ 17, 25, 27 ],masses2_9,RedSet_4(44),ScalarBoxes(44))
  call compute_scalar_box([ 16, 25, 27 ],masses2_9,RedSet_4(45),ScalarBoxes(45))
  call compute_scalar_box([ 1, 9, 11 ],masses2_9,RedSet_4(46),ScalarBoxes(46))
! end of process


end subroutine vamp_2

end module ol_vamp_2_ppzjj_uuxzgg_1_/**/REALKIND
