
module ol_vamp_1_ppzjj_ddxzgg_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppzjj_ddxzgg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppzjj_ddxzgg_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_ppzjj_ddxzgg_1_/**/DREALKIND
  use ol_tensor_sum_storage_ppzjj_ddxzgg_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_ppzjj_ddxzgg_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_ppzjj_ddxzgg_1_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(48)
  type(Hpolcont), intent(in) :: M(3,48)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

  Gcoeff(:)%j = (c(8)*M(1,:)%j-c(9)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(1),h0tab(:,1),[16,4,1,2,8],[0,0,0,0,0],5,0)
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,1),heltab2x48(:,:,1))
  call Hloop_A_Q(ntryL,G0H24(1),16,0,G1H24(1),n2h24(1))
  Gcoeff(:)%j = (c(8)*M(2,:)%j-c(9)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(2),h0tab(:,2),[16,2,1,4,8],[0,0,0,0,0],5,0)
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,2),heltab2x48(:,:,2))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(2),n2h24(2))
  Gcoeff(:)%j = (c(8)*M(2,:)%j-c(9)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(3),h0tab(:,3),[16,4,2,1,8],[0,0,0,0,0],5,0)
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,3),heltab2x48(:,:,3))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(3),n2h24(3))
  Gcoeff(:)%j = (c(8)*M(2,:)%j-c(9)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(4),h0tab(:,4),[16,2,1,8,4],[0,0,0,0,0],5,0)
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,4),heltab2x48(:,:,4))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(4),n2h24(4))
  Gcoeff(:)%j = (c(8)*M(1,:)%j-c(9)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(5),h0tab(:,5),[16,1,2,4,8],[0,0,0,0,0],5,0)
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,5),heltab2x48(:,:,5))
  call Hloop_A_Q(ntryL,G0H24(1),16,0,G1H24(5),n2h24(5))
  Gcoeff(:)%j = (c(8)*M(1,:)%j-c(9)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(6),h0tab(:,6),[16,1,2,8,4],[0,0,0,0,0],5,0)
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,6),heltab2x48(:,:,6))
  call Hloop_A_Q(ntryL,G0H24(1),16,0,G1H24(6),n2h24(6))
  Gcoeff(:)%j = (-(c(11)*M(2,:)%j)-c(9)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(7),h0tab(:,7),[16,2,4,1,8],[0,0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H48(1),0,ex5(:),16,G1H24(7),m3h2x24(:,7),heltab2x48(:,:,7))
  Gcoeff(:)%j = (-(c(4)*M(3,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(8),h0tab(:,8),[16,2,8,1,4],[0,0,0,0,0],5,0)
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,8),heltab2x48(:,:,8))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(8),n2h24(7))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)-c(9)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(9),h0tab(:,9),[16,1,4,2,8],[0,0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H48(1),0,ex5(:),16,G1H24(9),m3h2x24(:,9),heltab2x48(:,:,9))
  Gcoeff(:)%j = (-(c(4)*M(3,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(10),h0tab(:,10),[16,1,4,8,2],[0,0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H48(1),0,ex5(:),16,G1H24(10),m3h2x24(:,10),heltab2x48(:,:,10))
  Gcoeff(:)%j = (c(4)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(11),h0tab(:,11),[16,1,8,2,4],[0,0,0,0,0],5,0)
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,11),heltab2x48(:,:,11))
  call Hloop_A_Q(ntryL,G0H24(1),16,0,G1H24(11),n2h24(8))
  Gcoeff(:)%j = (-(c(4)*M(3,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(12),h0tab(:,12),[16,1,8,4,2],[0,0,0,0,0],5,0)
  call Hloop_UV_W(ntryL,G0H48(1),0,ex5(:),16,G1H24(12),m3h2x24(:,12),heltab2x48(:,:,12))
  call Hloop_AZ_Q(ntryL,G1H24(1),ex3(:),G1H8(1),ngZd,m3h3x8(:,1),heltab2x24(:,:,1))
  call Hloop_A_Q(ntryL,G1H8(1),20,0,G2H8(1),n2h8(1))
  call Hloop_QA_V(ntryL,G1H24(2),ex2(:),G1H12(1),m3h2x12(:,1),heltab2x24(:,:,2))
  call Hloop_QZ_A(ntryL,G1H24(3),ex3(:),G1H8(1),ngZd,m3h3x8(:,2),heltab2x24(:,:,3))
  call Hloop_Q_A(ntryL,G1H8(1),20,0,G2H8(2),n2h8(2))
  call Hloop_QA_V(ntryL,G1H24(4),ex2(:),G1H12(2),m3h2x12(:,2),heltab2x24(:,:,4))
  call Hloop_AQ_V(ntryL,G1H24(5),ex1(:),G1H12(3),m3h2x12(:,3),heltab2x24(:,:,5))
  call Hloop_AQ_V(ntryL,G1H24(6),ex1(:),G1H12(4),m3h2x12(:,4),heltab2x24(:,:,6))
  call Hloop_VA_Q(ntryL,G1H24(7),ex2(:),G1H12(5),m3h2x12(:,5),heltab2x24(:,:,7))
  call Hloop_A_Q(ntryL,G1H12(5),18,0,G2H12(1),n2h12(1))
  call Hloop_QA_V(ntryL,G1H24(8),ex2(:),G1H12(5),m3h2x12(:,6),heltab2x24(:,:,8))
  call Hloop_VQ_A(ntryL,G1H24(9),ex1(:),G1H12(6),m3h2x12(:,7),heltab2x24(:,:,9))
  call Hloop_Q_A(ntryL,G1H12(6),17,0,G2H12(2),n2h12(2))
  call Hloop_VQ_A(ntryL,G1H24(10),ex1(:),G1H12(6),m3h2x12(:,8),heltab2x24(:,:,10))
  call Hloop_Q_A(ntryL,G1H12(6),17,0,G2H12(3),n2h12(3))
  call Hloop_AQ_V(ntryL,G1H24(11),ex1(:),G1H12(6),m3h2x12(:,9),heltab2x24(:,:,11))
  call Hloop_VQ_A(ntryL,G1H24(12),ex1(:),G1H12(7),m3h2x12(:,10),heltab2x24(:,:,12))
  call Hloop_Q_A(ntryL,G1H12(7),17,0,G2H12(4),n2h12(4))
  call Hloop_AQ_V(ntryL,G2H8(1),ex1(:),G2H4(1),m3h2x4(:,1),heltab2x8(:,:,1))
  call Hloop_VQ_A(ntryL,G1H12(1),ex1(:),G1H6(1),m3h2x6(:,1),heltab2x12(:,:,1))
  call Hloop_Q_A(ntryL,G1H6(1),19,0,G2H6(1),n2h6(1))
  call Hloop_QA_V(ntryL,G2H8(2),ex2(:),G2H4(2),m3h2x4(:,2),heltab2x8(:,:,2))
  call Hloop_VQ_A(ntryL,G1H12(2),ex1(:),G1H6(1),m3h2x6(:,2),heltab2x12(:,:,2))
  call Hloop_Q_A(ntryL,G1H6(1),19,0,G2H6(2),n2h6(2))
  call Hloop_VA_Q(ntryL,G1H12(3),ex2(:),G1H6(1),m3h2x6(:,3),heltab2x12(:,:,3))
  call Hloop_A_Q(ntryL,G1H6(1),19,0,G2H6(3),n2h6(3))
  call Hloop_VA_Q(ntryL,G1H12(4),ex2(:),G1H6(1),m3h2x6(:,4),heltab2x12(:,:,4))
  call Hloop_A_Q(ntryL,G1H6(1),19,0,G2H6(4),n2h6(4))
  call Hotf_5pt_reduction(G2H12(1),RedSet_5(1),mass5set(:,1),  & 
G1H12(7),G1H12(1),G1H12(2),G1H12(3),G1H12(4),G1H12(8),12)
  call HG1shiftOLR(G1H12(1),8,12)
  call Hloop_UV_W(ntryL,G1H12(5),18,ex4(:),8,G2H6(5),m3h2x6(:,5),heltab2x12(:,:,5))
  call Hotf_5pt_reduction(G2H12(2),RedSet_5(2),mass5set(:,1),  & 
G1H12(5),G1H12(9),G1H12(10),G1H12(11),G1H12(12),G1H12(13),12)
  call HG1shiftOLR(G1H12(9),8,12)
  call Hotf_5pt_reduction(G2H12(3),RedSet_5(3),mass5set(:,1),  & 
G1H12(14),G1H12(15),G1H12(16),G1H12(17),G1H12(18),G1H12(19),12)
  call HG1shiftOLR(G1H12(15),2,12)
  call Hloop_UV_W(ntryL,G1H12(6),17,ex4(:),8,G2H6(6),m3h2x6(:,6),heltab2x12(:,:,6))
  call Hotf_5pt_reduction(G2H12(4),RedSet_5(4),mass5set(:,1),  & 
G1H12(6),G1H12(20),G1H12(21),G1H12(22),G1H12(23),G1H12(24),12)
  call HG1shiftOLR(G1H12(20),2,12)
  call Hloop_AZ_Q(ntryL,G1H12(7),ex3(:),G1H4(1),ngZd,m3h3x4(:,1),heltab2x12(:,:,7))
  call Hloop_A_Q(ntryL,G1H4(1),22,0,G2H4(3),n2h4(1))
call HGT_raise_alpha_OLR(G1H12(1),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(1),2,5,12)
  call Hloop_UV_W(ntryL,G1H12(1),-8,ex4(:),8,G2H6(7),m3h2x6(:,7),heltab2x12(:,:,8))
call signflip_OLR(G2H6(7))
  call Hloop_AZ_Q(ntryL,G1H12(3),ex3(:),G1H4(1),ngZd,m3h3x4(:,2),heltab2x12(:,:,9))
  call Hloop_A_Q(ntryL,G1H4(1),22,0,G2H4(4),n2h4(2))
  call Hloop_AZ_Q(ntryL,G1H12(4),ex3(:),G1H4(1),ngZd,m3h3x4(:,3),heltab2x12(:,:,10))
  call Hloop_A_Q(ntryL,G1H4(1),22,0,G2H4(5),n2h4(3))
  call Hloop_AZ_Q(ntryL,G1H12(8),ex3(:),G1H4(1),ngZd,m3h3x4(:,4),heltab2x12(:,:,11))
  call Hloop_A_Q(ntryL,G1H4(1),22,0,G2H4(6),n2h4(4))
  call Hloop_QZ_A(ntryL,G1H12(5),ex3(:),G1H4(1),ngZd,m3h3x4(:,5),heltab2x12(:,:,12))
  call Hloop_Q_A(ntryL,G1H4(1),21,0,G2H4(7),n2h4(5))
call HGT_raise_alpha_OLR(G1H12(9),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(9),2,5,12)
  call Hloop_UV_W(ntryL,G1H12(9),-8,ex4(:),8,G2H6(8),m3h2x6(:,8),heltab2x12(:,:,13))
call signflip_OLR(G2H6(8))
  call Hloop_QZ_A(ntryL,G1H12(11),ex3(:),G1H4(1),ngZd,m3h3x4(:,6),heltab2x12(:,:,14))
  call Hloop_Q_A(ntryL,G1H4(1),21,0,G2H4(8),n2h4(6))
  call Hloop_QZ_A(ntryL,G1H12(12),ex3(:),G1H4(1),ngZd,m3h3x4(:,7),heltab2x12(:,:,15))
  call Hloop_Q_A(ntryL,G1H4(1),21,0,G2H4(9),n2h4(7))
  call Hloop_QZ_A(ntryL,G1H12(13),ex3(:),G1H4(1),ngZd,m3h3x4(:,8),heltab2x12(:,:,16))
  call Hloop_Q_A(ntryL,G1H4(1),21,0,G2H4(10),n2h4(8))
  call Hloop_QZ_A(ntryL,G1H12(14),ex3(:),G1H4(1),ngZd,m3h3x4(:,9),heltab2x12(:,:,17))
  call Hloop_Q_A(ntryL,G1H4(1),21,0,G2H4(11),n2h4(9))
call HGT_raise_alpha_OLR(G1H12(15),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(15),2,5,12)
  call Hloop_VA_Q(ntryL,G1H12(15),ex2(:),G1H6(1),m3h2x6(:,9),heltab2x12(:,:,18))
  call Hloop_QZ_A(ntryL,G1H12(17),ex3(:),G1H4(1),ngZd,m3h3x4(:,10),heltab2x12(:,:,19))
  call Hloop_Q_A(ntryL,G1H4(1),21,0,G2H4(12),n2h4(10))
  call Hloop_QZ_A(ntryL,G1H12(18),ex3(:),G1H4(1),ngZd,m3h3x4(:,11),heltab2x12(:,:,20))
  call Hloop_Q_A(ntryL,G1H4(1),21,0,G2H4(13),n2h4(11))
  call Hloop_QZ_A(ntryL,G1H12(19),ex3(:),G1H4(1),ngZd,m3h3x4(:,12),heltab2x12(:,:,21))
  call Hloop_Q_A(ntryL,G1H4(1),21,0,G2H4(14),n2h4(12))
  call Hloop_QV_A(ntryL,G1H12(6),ex4(:),G1H6(2),m3h2x6(:,10),heltab2x12(:,:,22))
  call Hloop_Q_A(ntryL,G1H6(2),25,0,G2H6(9),n2h6(5))
call HGT_raise_alpha_OLR(G1H12(20),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(20),2,5,12)
  call Hloop_VA_Q(ntryL,G1H12(20),ex2(:),G1H6(2),m3h2x6(:,11),heltab2x12(:,:,23))
  call Hloop_QV_A(ntryL,G1H12(22),ex4(:),G1H6(3),m3h2x6(:,12),heltab2x12(:,:,24))
  call Hloop_Q_A(ntryL,G1H6(3),25,0,G2H6(10),n2h6(6))
  call Hloop_QV_A(ntryL,G1H12(23),ex4(:),G1H6(3),m3h2x6(:,13),heltab2x12(:,:,25))
  call Hloop_Q_A(ntryL,G1H6(3),25,0,G2H6(11),n2h6(7))
  call Hloop_QV_A(ntryL,G1H12(24),ex4(:),G1H6(3),m3h2x6(:,14),heltab2x12(:,:,26))
  call Hloop_Q_A(ntryL,G1H6(3),25,0,G2H6(12),n2h6(8))
  call Hotf_5pt_reduction(G2H4(1),RedSet_5(5),mass5set(:,1),  & 
G1H4(1),G1H4(2),G1H4(3),G1H4(4),G1H4(5),G1H4(6),4)
  call HG1shiftOLR(G1H4(2),8,4)
  call Hotf_5pt_reduction(G2H6(1),RedSet_5(6),mass5set(:,1),  & 
G1H6(3),G1H6(4),G1H6(5),G1H6(6),G1H6(7),G1H6(8),6)
  call HG1shiftOLR(G1H6(4),8,6)
  call Hotf_5pt_reduction(G2H4(2),RedSet_5(7),mass5set(:,1),  & 
G1H4(7),G1H4(8),G1H4(9),G1H4(10),G1H4(11),G1H4(12),4)
  call HG1shiftOLR(G1H4(8),8,4)
  call Hotf_5pt_reduction(G2H6(2),RedSet_5(8),mass5set(:,1),  & 
G1H6(9),G1H6(10),G1H6(11),G1H6(12),G1H6(13),G1H6(14),6)
  call HG1shiftOLR(G1H6(10),4,6)
  call Hotf_5pt_reduction(G2H6(3),RedSet_5(9),mass5set(:,1),  & 
G1H6(15),G1H6(16),G1H6(17),G1H6(18),G1H6(19),G1H6(20),6)
  call HG1shiftOLR(G1H6(16),8,6)
  call Hotf_5pt_reduction(G2H6(4),RedSet_5(10),mass5set(:,1),  & 
G1H6(21),G1H6(22),G1H6(23),G1H6(24),G1H6(25),G1H6(26),6)
  call HG1shiftOLR(G1H6(22),4,6)
  call Hotf_5pt_reduction(G2H6(5),RedSet_5(11),mass5set(:,1),  & 
G1H6(27),G1H6(28),G1H6(29),G1H6(30),G1H6(31),G1H6(32),6)
  call HG1shiftOLR(G1H6(28),4,6)
  call Hotf_5pt_reduction(G2H6(6),RedSet_5(12),mass5set(:,1),  & 
G1H6(33),G1H6(34),G1H6(35),G1H6(36),G1H6(37),G1H6(38),6)
  call HG1shiftOLR(G1H6(34),4,6)
  call Hloop_AQ_V(ntryL,G2H4(3),ex1(:),G2H2(1),m3h2x2(:,1),heltab2x4(:,:,1))
  call Hloop_AQ_V(ntryL,G2H4(5),ex1(:),G2H2(2),m3h2x2(:,2),heltab2x4(:,:,2))
  call Hloop_AQ_V(ntryL,G2H4(6),ex1(:),G2H2(3),m3h2x2(:,3),heltab2x4(:,:,3))
  call Hloop_QA_V(ntryL,G2H4(7),ex2(:),G2H2(4),m3h2x2(:,4),heltab2x4(:,:,4))
  call Hloop_QA_V(ntryL,G2H4(9),ex2(:),G2H2(5),m3h2x2(:,5),heltab2x4(:,:,5))
  call Hloop_QA_V(ntryL,G2H4(10),ex2(:),G2H2(6),m3h2x2(:,6),heltab2x4(:,:,6))
  call Hotf_5pt_reduction(G2H4(11),RedSet_5(3),mass5set(:,1),  & 
G1H4(13),G1H4(14),G1H4(15),G1H4(16),G1H4(17),G1H4(18),4)
  call HG1shiftOLR(G1H4(14),2,4)
  call Hotf_4pt_reduction(G2H4(13),RedSet_4(1),mass4set(:,1),  & 
G1H4(19),G1H4(20),G1H4(21),G1H4(22),G1H4(23),4)
  call HG1shiftOLR(G1H4(20),2,4)
  call Hotf_4pt_reduction(G2H4(14),RedSet_4(2),mass4set(:,1),  & 
G1H4(24),G1H4(25),G1H4(26),G1H4(27),G1H4(28),4)
  call HG1shiftOLR(G1H4(25),10,4)
  call Hotf_5pt_reduction(G2H6(9),RedSet_5(4),mass5set(:,1),  & 
G1H6(39),G1H6(40),G1H6(41),G1H6(42),G1H6(43),G1H6(44),6)
  call HG1shiftOLR(G1H6(40),2,6)
  call Hotf_4pt_reduction(G2H6(11),RedSet_4(1),mass4set(:,1),  & 
G1H6(45),G1H6(46),G1H6(47),G1H6(48),G1H6(49),6)
  call HG1shiftOLR(G1H6(46),2,6)
  call Hotf_4pt_reduction(G2H6(12),RedSet_4(3),mass4set(:,1),  & 
G1H6(50),G1H6(51),G1H6(52),G1H6(53),G1H6(54),6)
  call HG1shiftOLR(G1H6(51),6,6)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(19),[G1H4(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(24),[G1H4(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(45),[G1H6(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(50),[G1H6(44)])
  call Hloop_VA_Q(ntryL,G1H4(1),ex2(:),G1H2(1),m3h2x2(:,7),heltab2x4(:,:,7))
  call Hloop_A_Q(ntryL,G1H2(1),23,0,G2H2(7),n2h2(1))
call HGT_OLR(G1H4(2),1,1,4)
call HGT_invQ_OLR(G1H4(2),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(2),-8,0,G2H4(1),n2h4(13))
  call Hloop_QV_A(ntryL,G2H4(1),ex4(:),G2H2(8),m3h2x2(:,8),heltab2x4(:,:,8))
  call Hloop_VA_Q(ntryL,G1H4(5),ex2(:),G1H2(1),m3h2x2(:,9),heltab2x4(:,:,9))
  call Hloop_A_Q(ntryL,G1H2(1),23,0,G2H2(9),n2h2(2))
  call Hloop_VA_Q(ntryL,G1H4(6),ex2(:),G1H2(1),m3h2x2(:,10),heltab2x4(:,:,10))
  call Hloop_A_Q(ntryL,G1H2(1),23,0,G2H2(10),n2h2(3))
  call Hloop_QZ_A(ntryL,G1H6(3),ex3(:),G1H2(1),ngZd,m3h3x2(:,1),heltab2x6(:,:,1))
  call Hloop_Q_A(ntryL,G1H2(1),23,0,G2H2(11),n2h2(4))
call HGT_OLR(G1H6(4),1,1,6)
call HGT_invQ_OLR(G1H6(4),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(4),-8,0,G2H6(1),n2h6(9))
  call Hloop_AV_Q(ntryL,G2H6(1),ex4(:),G2H3(1),m3h2x3(:,1),heltab2x6(:,:,2))
  call Hloop_QZ_A(ntryL,G1H6(7),ex3(:),G1H2(1),ngZd,m3h3x2(:,2),heltab2x6(:,:,3))
  call Hloop_Q_A(ntryL,G1H2(1),23,0,G2H2(12),n2h2(5))
  call Hloop_QZ_A(ntryL,G1H6(8),ex3(:),G1H2(1),ngZd,m3h3x2(:,3),heltab2x6(:,:,4))
  call Hloop_Q_A(ntryL,G1H2(1),23,0,G2H2(13),n2h2(6))
  call Hloop_VQ_A(ntryL,G1H4(7),ex1(:),G1H2(1),m3h2x2(:,11),heltab2x4(:,:,11))
  call Hloop_Q_A(ntryL,G1H2(1),23,0,G2H2(14),n2h2(7))
call HGT_OLR(G1H4(8),1,1,4)
call HGT_invQ_OLR(G1H4(8),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(8),-8,0,G2H4(2),n2h4(14))
  call Hloop_AV_Q(ntryL,G2H4(2),ex4(:),G2H2(15),m3h2x2(:,12),heltab2x4(:,:,12))
  call Hloop_VQ_A(ntryL,G1H4(11),ex1(:),G1H2(1),m3h2x2(:,13),heltab2x4(:,:,13))
  call Hloop_Q_A(ntryL,G1H2(1),23,0,G2H2(16),n2h2(8))
  call Hloop_VQ_A(ntryL,G1H4(12),ex1(:),G1H2(1),m3h2x2(:,14),heltab2x4(:,:,14))
  call Hloop_Q_A(ntryL,G1H2(1),23,0,G2H2(17),n2h2(9))
  call Hloop_QV_A(ntryL,G1H6(9),ex4(:),G1H3(1),m3h2x3(:,2),heltab2x6(:,:,5))
  call Hloop_Q_A(ntryL,G1H3(1),27,0,G2H3(2),n2h3(1))
call HGT_OLR(G1H6(10),1,1,6)
call HGT_invQ_OLR(G1H6(10),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(10),-4,0,G2H6(2),n2h6(10))
  call Hloop_AZ_Q(ntryL,G2H6(2),ex3(:),G2H2(18),ngZd,m3h3x2(:,4),heltab2x6(:,:,6))
  call Hloop_QV_A(ntryL,G1H6(13),ex4(:),G1H3(1),m3h2x3(:,3),heltab2x6(:,:,7))
  call Hloop_Q_A(ntryL,G1H3(1),27,0,G2H3(3),n2h3(2))
  call Hloop_QV_A(ntryL,G1H6(14),ex4(:),G1H3(1),m3h2x3(:,4),heltab2x6(:,:,8))
  call Hloop_Q_A(ntryL,G1H3(1),27,0,G2H3(4),n2h3(3))
  call Hloop_AZ_Q(ntryL,G1H6(15),ex3(:),G1H2(1),ngZd,m3h3x2(:,5),heltab2x6(:,:,9))
  call Hloop_A_Q(ntryL,G1H2(1),23,0,G2H2(19),n2h2(10))
call HGT_OLR(G1H6(16),1,1,6)
call HGT_invQ_OLR(G1H6(16),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(16),-8,0,G2H6(3),n2h6(11))
  call Hloop_QV_A(ntryL,G2H6(3),ex4(:),G2H3(5),m3h2x3(:,5),heltab2x6(:,:,10))
  call Hloop_AZ_Q(ntryL,G1H6(19),ex3(:),G1H2(1),ngZd,m3h3x2(:,6),heltab2x6(:,:,11))
  call Hloop_A_Q(ntryL,G1H2(1),23,0,G2H2(20),n2h2(11))
  call Hloop_AZ_Q(ntryL,G1H6(20),ex3(:),G1H2(1),ngZd,m3h3x2(:,7),heltab2x6(:,:,12))
  call Hloop_A_Q(ntryL,G1H2(1),23,0,G2H2(21),n2h2(12))
  call Hloop_AV_Q(ntryL,G1H6(21),ex4(:),G1H3(1),m3h2x3(:,6),heltab2x6(:,:,13))
  call Hloop_A_Q(ntryL,G1H3(1),27,0,G2H3(6),n2h3(4))
call HGT_OLR(G1H6(22),1,1,6)
call HGT_invQ_OLR(G1H6(22),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(22),-4,0,G2H6(4),n2h6(12))
  call Hloop_QZ_A(ntryL,G2H6(4),ex3(:),G2H2(22),ngZd,m3h3x2(:,8),heltab2x6(:,:,14))
  call Hloop_AV_Q(ntryL,G1H6(25),ex4(:),G1H3(1),m3h2x3(:,7),heltab2x6(:,:,15))
  call Hloop_A_Q(ntryL,G1H3(1),27,0,G2H3(7),n2h3(5))
  call Hloop_AV_Q(ntryL,G1H6(26),ex4(:),G1H3(1),m3h2x3(:,8),heltab2x6(:,:,16))
  call Hloop_A_Q(ntryL,G1H3(1),27,0,G2H3(8),n2h3(6))
  call Hloop_VQ_A(ntryL,G1H6(27),ex1(:),G1H3(1),m3h2x3(:,9),heltab2x6(:,:,17))
  call Hloop_Q_A(ntryL,G1H3(1),27,0,G2H3(9),n2h3(7))
call HGT_OLR(G1H6(28),1,1,6)
call HGT_invQ_OLR(G1H6(28),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(28),-4,0,G2H6(5),n2h6(13))
  call Hloop_AZ_Q(ntryL,G2H6(5),ex3(:),G2H2(23),ngZd,m3h3x2(:,9),heltab2x6(:,:,18))
  call Hloop_VQ_A(ntryL,G1H6(31),ex1(:),G1H3(1),m3h2x3(:,10),heltab2x6(:,:,19))
  call Hloop_Q_A(ntryL,G1H3(1),27,0,G2H3(10),n2h3(8))
  call Hloop_VQ_A(ntryL,G1H6(32),ex1(:),G1H3(1),m3h2x3(:,11),heltab2x6(:,:,20))
  call Hloop_Q_A(ntryL,G1H3(1),27,0,G2H3(11),n2h3(9))
  call Hloop_VA_Q(ntryL,G1H6(33),ex2(:),G1H3(1),m3h2x3(:,12),heltab2x6(:,:,21))
  call Hloop_A_Q(ntryL,G1H3(1),27,0,G2H3(12),n2h3(10))
call HGT_OLR(G1H6(34),1,1,6)
call HGT_invQ_OLR(G1H6(34),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(34),-4,0,G2H6(6),n2h6(14))
  call Hloop_QZ_A(ntryL,G2H6(6),ex3(:),G2H2(24),ngZd,m3h3x2(:,10),heltab2x6(:,:,22))
  call Hloop_VA_Q(ntryL,G1H6(37),ex2(:),G1H3(1),m3h2x3(:,13),heltab2x6(:,:,23))
  call Hloop_A_Q(ntryL,G1H3(1),27,0,G2H3(13),n2h3(11))
  call Hloop_VA_Q(ntryL,G1H6(38),ex2(:),G1H3(1),m3h2x3(:,14),heltab2x6(:,:,24))
  call Hloop_A_Q(ntryL,G1H3(1),27,0,G2H3(14),n2h3(12))
  call Hloop_QV_A(ntryL,G1H4(13),ex4(:),G1H2(1),m3h2x2(:,15),heltab2x4(:,:,15))
  call Hloop_Q_A(ntryL,G1H2(1),29,0,G2H2(25),n2h2(13))
call HGT_raise_alpha_OLR(G1H4(14),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(14),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(14),ex2(:),G1H2(1),m3h2x2(:,16),heltab2x4(:,:,16))
  call Hloop_QV_A(ntryL,G1H4(19),ex4(:),G1H2(2),m3h2x2(:,17),heltab2x4(:,:,17))
  call Hloop_Q_A(ntryL,G1H2(2),29,0,G2H2(26),n2h2(14))
  call Hloop_QV_A(ntryL,G1H4(24),ex4(:),G1H2(2),m3h2x2(:,18),heltab2x4(:,:,18))
  call Hloop_Q_A(ntryL,G1H2(2),29,0,G2H2(27),n2h2(15))
call HGT_raise_alpha_OLR(G1H4(20),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(20),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(20),ex2(:),G1H2(2),m3h2x2(:,19),heltab2x4(:,:,19))
  call Hloop_QV_A(ntryL,G1H4(23),ex4(:),G1H2(3),m3h2x2(:,20),heltab2x4(:,:,20))
  call Hloop_Q_A(ntryL,G1H2(3),29,0,G2H2(28),n2h2(16))
call HGT_raise_alpha_OLR(G1H4(25),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(25),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(25),ex2(:),G1H2(3),m3h2x2(:,21),heltab2x4(:,:,21))
  call Hloop_QV_A(ntryL,G1H4(28),ex4(:),G1H2(4),m3h2x2(:,22),heltab2x4(:,:,22))
  call Hloop_Q_A(ntryL,G1H2(4),29,0,G2H2(29),n2h2(17))
  call Hloop_QZ_A(ntryL,G1H6(39),ex3(:),G1H2(4),ngZd,m3h3x2(:,11),heltab2x6(:,:,25))
  call Hloop_Q_A(ntryL,G1H2(4),29,0,G2H2(30),n2h2(18))
call HGT_raise_alpha_OLR(G1H6(40),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(40),2,5,6)
  call Hloop_VA_Q(ntryL,G1H6(40),ex2(:),G1H3(1),m3h2x3(:,15),heltab2x6(:,:,26))
  call Hloop_QZ_A(ntryL,G1H6(45),ex3(:),G1H2(4),ngZd,m3h3x2(:,12),heltab2x6(:,:,27))
  call Hloop_Q_A(ntryL,G1H2(4),29,0,G2H2(31),n2h2(19))
  call Hloop_QZ_A(ntryL,G1H6(50),ex3(:),G1H2(4),ngZd,m3h3x2(:,13),heltab2x6(:,:,28))
  call Hloop_Q_A(ntryL,G1H2(4),29,0,G2H2(32),n2h2(20))
call HGT_raise_alpha_OLR(G1H6(46),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(46),2,5,6)
  call Hloop_VA_Q(ntryL,G1H6(46),ex2(:),G1H3(2),m3h2x3(:,16),heltab2x6(:,:,29))
  call Hloop_QZ_A(ntryL,G1H6(49),ex3(:),G1H2(4),ngZd,m3h3x2(:,14),heltab2x6(:,:,30))
  call Hloop_Q_A(ntryL,G1H2(4),29,0,G2H2(33),n2h2(21))
call HGT_raise_alpha_OLR(G1H6(51),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(51),2,5,6)
  call Hloop_VA_Q(ntryL,G1H6(51),ex2(:),G1H3(3),m3h2x3(:,17),heltab2x6(:,:,31))
  call Hloop_QZ_A(ntryL,G1H6(54),ex3(:),G1H2(4),ngZd,m3h3x2(:,15),heltab2x6(:,:,32))
  call Hloop_Q_A(ntryL,G1H2(4),29,0,G2H2(34),n2h2(22))
  call Hotf_5pt_reduction(G2H2(1),RedSet_5(1),mass5set(:,1),  & 
G1H2(4),G1H2(5),G1H2(6),G1H2(7),G1H2(8),G1H2(9),2)
  call HG1shiftOLR(G1H2(5),8,2)
  call Hotf_4pt_reduction(G2H2(3),RedSet_4(4),mass4set(:,1),  & 
G1H2(10),G1H2(11),G1H2(12),G1H2(13),G1H2(14),2)
  call HG1shiftOLR(G1H2(11),9,2)
  call Hotf_5pt_reduction(G2H2(4),RedSet_5(2),mass5set(:,1),  & 
G1H2(15),G1H2(16),G1H2(17),G1H2(18),G1H2(19),G1H2(20),2)
  call HG1shiftOLR(G1H2(16),8,2)
  call Hotf_4pt_reduction(G2H2(6),RedSet_4(2),mass4set(:,1),  & 
G1H2(21),G1H2(22),G1H2(23),G1H2(24),G1H2(25),2)
  call HG1shiftOLR(G1H2(22),10,2)
  call Hotf_5pt_reduction(G2H2(7),RedSet_5(5),mass5set(:,1),  & 
G1H2(26),G1H2(27),G1H2(28),G1H2(29),G1H2(30),G1H2(31),2)
  call HG1shiftOLR(G1H2(27),8,2)
  call Hotf_4pt_reduction(G2H2(10),RedSet_4(5),mass4set(:,1),  & 
G1H2(32),G1H2(33),G1H2(34),G1H2(35),G1H2(36),2)
  call HG1shiftOLR(G1H2(33),10,2)
  call Hotf_5pt_reduction(G2H2(11),RedSet_5(6),mass5set(:,1),  & 
G1H2(37),G1H2(38),G1H2(39),G1H2(40),G1H2(41),G1H2(42),2)
  call HG1shiftOLR(G1H2(38),8,2)
  call Hotf_4pt_reduction(G2H2(13),RedSet_4(6),mass4set(:,1),  & 
G1H2(43),G1H2(44),G1H2(45),G1H2(46),G1H2(47),2)
  call HG1shiftOLR(G1H2(44),12,2)
  call Hotf_5pt_reduction(G2H2(14),RedSet_5(7),mass5set(:,1),  & 
G1H2(48),G1H2(49),G1H2(50),G1H2(51),G1H2(52),G1H2(53),2)
  call HG1shiftOLR(G1H2(49),8,2)
  call Hotf_4pt_reduction(G2H2(17),RedSet_4(7),mass4set(:,1),  & 
G1H2(54),G1H2(55),G1H2(56),G1H2(57),G1H2(58),2)
  call HG1shiftOLR(G1H2(55),9,2)
  call Hotf_5pt_reduction(G2H3(2),RedSet_5(8),mass5set(:,1),  & 
G1H3(4),G1H3(5),G1H3(6),G1H3(7),G1H3(8),G1H3(9),3)
  call HG1shiftOLR(G1H3(5),4,3)
  call Hotf_4pt_reduction(G2H3(4),RedSet_4(6),mass4set(:,1),  & 
G1H3(10),G1H3(11),G1H3(12),G1H3(13),G1H3(14),3)
  call HG1shiftOLR(G1H3(11),12,3)
  call Hotf_5pt_reduction(G2H2(19),RedSet_5(9),mass5set(:,1),  & 
G1H2(59),G1H2(60),G1H2(61),G1H2(62),G1H2(63),G1H2(64),2)
  call HG1shiftOLR(G1H2(60),8,2)
  call Hotf_4pt_reduction(G2H2(21),RedSet_4(8),mass4set(:,1),  & 
G1H2(65),G1H2(66),G1H2(67),G1H2(68),G1H2(69),2)
  call HG1shiftOLR(G1H2(66),12,2)
  call Hotf_5pt_reduction(G2H3(6),RedSet_5(10),mass5set(:,1),  & 
G1H3(15),G1H3(16),G1H3(17),G1H3(18),G1H3(19),G1H3(20),3)
  call HG1shiftOLR(G1H3(16),4,3)
  call Hotf_4pt_reduction(G2H3(8),RedSet_4(8),mass4set(:,1),  & 
G1H3(21),G1H3(22),G1H3(23),G1H3(24),G1H3(25),3)
  call HG1shiftOLR(G1H3(22),12,3)
  call Hotf_5pt_reduction(G2H3(9),RedSet_5(11),mass5set(:,1),  & 
G1H3(26),G1H3(27),G1H3(28),G1H3(29),G1H3(30),G1H3(31),3)
  call HG1shiftOLR(G1H3(27),4,3)
  call Hotf_4pt_reduction(G2H3(11),RedSet_4(9),mass4set(:,1),  & 
G1H3(32),G1H3(33),G1H3(34),G1H3(35),G1H3(36),3)
  call HG1shiftOLR(G1H3(33),5,3)
  call Hotf_5pt_reduction(G2H3(12),RedSet_5(12),mass5set(:,1),  & 
G1H3(37),G1H3(38),G1H3(39),G1H3(40),G1H3(41),G1H3(42),3)
  call HG1shiftOLR(G1H3(38),4,3)
  call Hotf_4pt_reduction(G2H3(14),RedSet_4(3),mass4set(:,1),  & 
G1H3(43),G1H3(44),G1H3(45),G1H3(46),G1H3(47),3)
  call HG1shiftOLR(G1H3(44),6,3)
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(25),ex2(:),G2tensor(1),m3h2x1(:,1),heltab2x2(:,:,1))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(27),ex2(:),G2tensor(2),m3h2x1(:,2),heltab2x2(:,:,2))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(30),ex2(:),G2tensor(3),m3h2x1(:,3),heltab2x2(:,:,3))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(32),ex2(:),G2tensor(4),m3h2x1(:,4),heltab2x2(:,:,4))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(10),[G1H2(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(21),[G1H2(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(32),[G1H2(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(43),[G1H2(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(54),[G1H2(53)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(10),[G1H3(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(65),[G1H2(64)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(21),[G1H3(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(32),[G1H3(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(43),[G1H3(42)])
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(4),23,ex4(:),8,G2tensor(5),m3h2x1(:,5),heltab2x2(:,:,5))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(5),0,ex4(:),8,G2tensor(6),m3h2x1(:,6),heltab2x2(:,:,6))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(10),23,ex4(:),8,G2tensor(7),m3h2x1(:,7),heltab2x2(:,:,7))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(11),1,ex4(:),8,G2tensor(8),m3h2x1(:,8),heltab2x2(:,:,8))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(15),23,ex4(:),8,G2tensor(9),m3h2x1(:,9),heltab2x2(:,:,9))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(16),0,ex4(:),8,G2tensor(10),m3h2x1(:,10),heltab2x2(:,:,10))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(21),23,ex4(:),8,G2tensor(11),m3h2x1(:,11),heltab2x2(:,:,11))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(22),2,ex4(:),8,G2tensor(12),m3h2x1(:,12),heltab2x2(:,:,12))
  call Hloop_AV_Q(ntryL,G1H2(26),ex4(:),G1H1(1),m3h2x1(:,13),heltab2x2(:,:,13))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(13),n2h1(5))
  call Hloop_AV_Q(ntryL,G1H2(27),ex4(:),G1H1(1),m3h2x1(:,14),heltab2x2(:,:,14))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(14),n2h1(6))
  call Hloop_AV_Q(ntryL,G1H2(32),ex4(:),G1H1(1),m3h2x1(:,15),heltab2x2(:,:,15))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(15),n2h1(7))
  call Hloop_AV_Q(ntryL,G1H2(33),ex4(:),G1H1(1),m3h2x1(:,16),heltab2x2(:,:,16))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,0,G2tensor(16),n2h1(8))
  call Hloop_QV_A(ntryL,G1H2(37),ex4(:),G1H1(1),m3h2x1(:,17),heltab2x2(:,:,17))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(17),n2h1(9))
  call Hloop_QV_A(ntryL,G1H2(38),ex4(:),G1H1(1),m3h2x1(:,18),heltab2x2(:,:,18))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(18),n2h1(10))
  call Hloop_QV_A(ntryL,G1H2(43),ex4(:),G1H1(1),m3h2x1(:,19),heltab2x2(:,:,19))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(19),n2h1(11))
  call Hloop_QV_A(ntryL,G1H2(44),ex4(:),G1H1(1),m3h2x1(:,20),heltab2x2(:,:,20))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(20),n2h1(12))
  call Hloop_QV_A(ntryL,G1H2(48),ex4(:),G1H1(1),m3h2x1(:,21),heltab2x2(:,:,21))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(21),n2h1(13))
  call Hloop_QV_A(ntryL,G1H2(49),ex4(:),G1H1(1),m3h2x1(:,22),heltab2x2(:,:,22))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(22),n2h1(14))
  call Hloop_QV_A(ntryL,G1H2(54),ex4(:),G1H1(1),m3h2x1(:,23),heltab2x2(:,:,23))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(23),n2h1(15))
  call Hloop_QV_A(ntryL,G1H2(55),ex4(:),G1H1(1),m3h2x1(:,24),heltab2x2(:,:,24))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,0,G2tensor(24),n2h1(16))
  call Hloop_QZ_A(ntryL,G1H3(4),ex3(:),G1H1(1),ngZd,m3h3x1(:,1),heltab2x3(:,:,1))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(25),n2h1(17))
  call Hloop_QZ_A(ntryL,G1H3(5),ex3(:),G1H1(1),ngZd,m3h3x1(:,2),heltab2x3(:,:,2))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(26),n2h1(18))
  call Hloop_QZ_A(ntryL,G1H3(10),ex3(:),G1H1(1),ngZd,m3h3x1(:,3),heltab2x3(:,:,3))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(27),n2h1(19))
  call Hloop_QZ_A(ntryL,G1H3(11),ex3(:),G1H1(1),ngZd,m3h3x1(:,4),heltab2x3(:,:,4))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(28),n2h1(20))
  call Hloop_AV_Q(ntryL,G1H2(59),ex4(:),G1H1(1),m3h2x1(:,25),heltab2x2(:,:,25))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(29),n2h1(21))
  call Hloop_AV_Q(ntryL,G1H2(60),ex4(:),G1H1(1),m3h2x1(:,26),heltab2x2(:,:,26))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(30),n2h1(22))
  call Hloop_AV_Q(ntryL,G1H2(65),ex4(:),G1H1(1),m3h2x1(:,27),heltab2x2(:,:,27))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(31),n2h1(23))
  call Hloop_AV_Q(ntryL,G1H2(66),ex4(:),G1H1(1),m3h2x1(:,28),heltab2x2(:,:,28))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,0,G2tensor(32),n2h1(24))
  call Hloop_AZ_Q(ntryL,G1H3(15),ex3(:),G1H1(1),ngZd,m3h3x1(:,5),heltab2x3(:,:,5))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(33),n2h1(25))
  call Hloop_AZ_Q(ntryL,G1H3(16),ex3(:),G1H1(1),ngZd,m3h3x1(:,6),heltab2x3(:,:,6))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(34),n2h1(26))
  call Hloop_AZ_Q(ntryL,G1H3(21),ex3(:),G1H1(1),ngZd,m3h3x1(:,7),heltab2x3(:,:,7))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(35),n2h1(27))
  call Hloop_AZ_Q(ntryL,G1H3(22),ex3(:),G1H1(1),ngZd,m3h3x1(:,8),heltab2x3(:,:,8))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,0,G2tensor(36),n2h1(28))
  call Hloop_QZ_A(ntryL,G1H3(26),ex3(:),G1H1(1),ngZd,m3h3x1(:,9),heltab2x3(:,:,9))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(37),n2h1(29))
  call Hloop_QZ_A(ntryL,G1H3(27),ex3(:),G1H1(1),ngZd,m3h3x1(:,10),heltab2x3(:,:,10))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(38),n2h1(30))
  call Hloop_QZ_A(ntryL,G1H3(32),ex3(:),G1H1(1),ngZd,m3h3x1(:,11),heltab2x3(:,:,11))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(39),n2h1(31))
  call Hloop_QZ_A(ntryL,G1H3(33),ex3(:),G1H1(1),ngZd,m3h3x1(:,12),heltab2x3(:,:,12))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),5,0,G2tensor(40),n2h1(32))
  call Hloop_AZ_Q(ntryL,G1H3(37),ex3(:),G1H1(1),ngZd,m3h3x1(:,13),heltab2x3(:,:,13))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(41),n2h1(33))
  call Hloop_AZ_Q(ntryL,G1H3(38),ex3(:),G1H1(1),ngZd,m3h3x1(:,14),heltab2x3(:,:,14))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(42),n2h1(34))
  call Hloop_AZ_Q(ntryL,G1H3(43),ex3(:),G1H1(1),ngZd,m3h3x1(:,15),heltab2x3(:,:,15))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(43),n2h1(35))
  call Hloop_AZ_Q(ntryL,G1H3(44),ex3(:),G1H1(1),ngZd,m3h3x1(:,16),heltab2x3(:,:,16))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),6,0,G2tensor(44),n2h1(36))
  call Hotf_5pt_reduction_last(G2tensor(1),RedSet_5(3),mass5set(:,1),  & 
G1tensor(1),G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(5),G1tensor(6))
  call G_TensorShift(G1tensor(2),2)
  call Hotf_5pt_reduction_last(G2tensor(3),RedSet_5(4),mass5set(:,1),  & 
G1tensor(7),G1tensor(8),G1tensor(9),G1tensor(10),G1tensor(11),G1tensor(12))
  call G_TensorShift(G1tensor(8),2)
  call Hotf_5pt_reduction_last(G2tensor(5),RedSet_5(1),mass5set(:,1),  & 
G1tensor(13),G1tensor(14),G1tensor(15),G1tensor(16),G1tensor(17),G1tensor(18))
  call G_TensorShift(G1tensor(14),8)
  call Hotf_5pt_reduction_last(G2tensor(9),RedSet_5(2),mass5set(:,1),  & 
G1tensor(19),G1tensor(20),G1tensor(21),G1tensor(22),G1tensor(23),G1tensor(24))
  call G_TensorShift(G1tensor(20),8)
  call Hotf_5pt_reduction_last(G2tensor(13),RedSet_5(5),mass5set(:,1),  & 
G1tensor(25),G1tensor(26),G1tensor(27),G1tensor(28),G1tensor(29),G1tensor(30))
  call G_TensorShift(G1tensor(26),8)
  call Hotf_5pt_reduction_last(G2tensor(17),RedSet_5(6),mass5set(:,1),  & 
G1tensor(31),G1tensor(32),G1tensor(33),G1tensor(34),G1tensor(35),G1tensor(36))
  call G_TensorShift(G1tensor(32),8)
  call Hotf_5pt_reduction_last(G2tensor(21),RedSet_5(7),mass5set(:,1),  & 
G1tensor(37),G1tensor(38),G1tensor(39),G1tensor(40),G1tensor(41),G1tensor(42))
  call G_TensorShift(G1tensor(38),8)
  call Hotf_5pt_reduction_last(G2tensor(25),RedSet_5(8),mass5set(:,1),  & 
G1tensor(43),G1tensor(44),G1tensor(45),G1tensor(46),G1tensor(47),G1tensor(48))
  call G_TensorShift(G1tensor(44),4)
  call Hotf_5pt_reduction_last(G2tensor(29),RedSet_5(9),mass5set(:,1),  & 
G1tensor(49),G1tensor(50),G1tensor(51),G1tensor(52),G1tensor(53),G1tensor(54))
  call G_TensorShift(G1tensor(50),8)
  call Hotf_5pt_reduction_last(G2tensor(33),RedSet_5(10),mass5set(:,1),  & 
G1tensor(55),G1tensor(56),G1tensor(57),G1tensor(58),G1tensor(59),G1tensor(60))
  call G_TensorShift(G1tensor(56),4)
  call Hotf_5pt_reduction_last(G2tensor(37),RedSet_5(11),mass5set(:,1),  & 
G1tensor(61),G1tensor(62),G1tensor(63),G1tensor(64),G1tensor(65),G1tensor(66))
  call G_TensorShift(G1tensor(62),4)
  call Hotf_5pt_reduction_last(G2tensor(41),RedSet_5(12),mass5set(:,1),  & 
G1tensor(67),G1tensor(68),G1tensor(69),G1tensor(70),G1tensor(71),G1tensor(72))
  call G_TensorShift(G1tensor(68),4)
  call ol_merge_tensors(T1sum(1),[G1tensor(1)])
  call ol_merge_tensors(T1sum(2),[G1tensor(7)])
  call ol_merge_tensors(T1sum(3),[G1tensor(13)])
  call ol_merge_tensors(T1sum(4),[G1tensor(19)])
  call ol_merge_tensors(T1sum(5),[G1tensor(25)])
  call ol_merge_tensors(T1sum(6),[G1tensor(31)])
  call ol_merge_tensors(T1sum(7),[G1tensor(37)])
  call ol_merge_tensors(T1sum(8),[G1tensor(43)])
  call ol_merge_tensors(T1sum(9),[G1tensor(49)])
  call ol_merge_tensors(T1sum(10),[G1tensor(55)])
  call ol_merge_tensors(T1sum(11),[G1tensor(61)])
  call ol_merge_tensors(T1sum(12),[G1tensor(67)])
  Gcoeff(:)%j = (-(c(11)*M(2,:)%j)-c(9)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(13),h0tab(:,13),[24,1,4,2],[0,0,0,0],5,0)
  call Hloop_GGG_G_12(ntryL,G0H48(1),ex5(:),ex4(:),G0H12(1),m4h2x2x12(:,1),heltab3x48(:,:,1))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)-c(9)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(14),h0tab(:,14),[24,1,4,2],[0,0,0,0],5,0)
  call Hloop_GGG_G_12(ntryL,G0H48(1),ex4(:),ex5(:),G0H12(2),m4h2x2x12(:,2),heltab3x48(:,:,2))
  Gcoeff(:)%j = (c(11)*(-M(1,:)%j+M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(15),h0tab(:,15),[24,1,4,2],[0,0,0,0],5,0)
  call Hloop_GGG_G_23(ntryL,G0H48(1),ex5(:),ex4(:),G0H12(3),m4h2x2x12(:,3),heltab3x48(:,:,3))
  Gcoeff(:)%j = (c(17)*M(2,:)%j-c(16)*M(3,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(16),h0tab(:,16),[16,3,8,4],[0,0,0,0],4,1,wf4(:,10))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,13),heltab2x48(:,:,13))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(1),n2h24(9))
  Gcoeff(:)%j = (c(15)*M(2,:)%j-c(14)*M(3,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(17),h0tab(:,17),[16,3,8,4],[nMT,nMT,nMT,nMT],4,1,wf4(:,10))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,14),heltab2x48(:,:,14))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMT,G1H24(2),n2h24(10))
  Gcoeff(:)%j = (c(17)*M(1,:)%j-c(16)*M(3,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(18),h0tab(:,18),[16,3,8,4],[0,0,0,0],4,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,15),heltab2x48(:,:,15))
  call Hloop_A_Q(ntryL,G0H24(1),16,0,G1H24(3),n2h24(11))
  Gcoeff(:)%j = (c(15)*M(1,:)%j-c(14)*M(3,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(19),h0tab(:,19),[16,3,8,4],[nMT,nMT,nMT,nMT],4,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,16),heltab2x48(:,:,16))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMT,G1H24(4),n2h24(12))
  Gcoeff(:)%j = (c(17)*M(2,:)%j-c(16)*M(3,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(20),h0tab(:,20),[16,3,8,4],[0,0,0,0],4,1,wf4(:,10))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,17),heltab2x48(:,:,17))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(5),n2h24(13))
  Gcoeff(:)%j = (c(15)*M(2,:)%j-c(14)*M(3,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(21),h0tab(:,21),[16,3,8,4],[nMB,nMB,nMB,nMB],4,1,wf4(:,10))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,18),heltab2x48(:,:,18))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMB,G1H24(6),n2h24(14))
  Gcoeff(:)%j = (c(17)*M(1,:)%j-c(16)*M(3,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(22),h0tab(:,22),[16,3,8,4],[0,0,0,0],4,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,19),heltab2x48(:,:,19))
  call Hloop_A_Q(ntryL,G0H24(1),16,0,G1H24(7),n2h24(15))
  Gcoeff(:)%j = (c(15)*M(1,:)%j-c(14)*M(3,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(23),h0tab(:,23),[16,3,8,4],[nMB,nMB,nMB,nMB],4,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,20),heltab2x48(:,:,20))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMB,G1H24(8),n2h24(16))
  Gcoeff(:)%j = (c(17)*M(1,:)%j-c(16)*M(3,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(24),h0tab(:,24),[16,3,4,8],[0,0,0,0],4,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,21),heltab2x48(:,:,21))
  call Hloop_A_Q(ntryL,G0H24(1),16,0,G1H24(9),n2h24(17))
  Gcoeff(:)%j = (c(15)*M(1,:)%j-c(14)*M(3,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(25),h0tab(:,25),[16,3,4,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,22),heltab2x48(:,:,22))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMT,G1H24(10),n2h24(18))
  Gcoeff(:)%j = (c(17)*M(2,:)%j-c(16)*M(3,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(26),h0tab(:,26),[16,3,4,8],[0,0,0,0],4,1,wf4(:,10))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,23),heltab2x48(:,:,23))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(11),n2h24(19))
  Gcoeff(:)%j = (c(15)*M(2,:)%j-c(14)*M(3,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(27),h0tab(:,27),[16,3,4,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,10))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,24),heltab2x48(:,:,24))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMT,G1H24(12),n2h24(20))
  Gcoeff(:)%j = (c(17)*M(1,:)%j-c(16)*M(3,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(28),h0tab(:,28),[16,3,4,8],[0,0,0,0],4,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,25),heltab2x48(:,:,25))
  call Hloop_A_Q(ntryL,G0H24(1),16,0,G1H24(13),n2h24(21))
  Gcoeff(:)%j = (c(15)*M(1,:)%j-c(14)*M(3,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(29),h0tab(:,29),[16,3,4,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,26),heltab2x48(:,:,26))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMB,G1H24(14),n2h24(22))
  Gcoeff(:)%j = (c(17)*M(2,:)%j-c(16)*M(3,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(30),h0tab(:,30),[16,3,4,8],[0,0,0,0],4,1,wf4(:,10))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,27),heltab2x48(:,:,27))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(15),n2h24(23))
  Gcoeff(:)%j = (c(15)*M(2,:)%j-c(14)*M(3,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(31),h0tab(:,31),[16,3,4,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,10))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,28),heltab2x48(:,:,28))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMB,G1H24(16),n2h24(24))
  Gcoeff(:)%j = (c(17)*M(2,:)%j-c(16)*M(3,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(32),h0tab(:,32),[16,4,3,8],[0,0,0,0],4,1,wf4(:,10))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,29),heltab2x48(:,:,29))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(17),n2h24(25))
  Gcoeff(:)%j = (c(15)*M(2,:)%j-c(14)*M(3,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(33),h0tab(:,33),[16,4,3,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,10))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,30),heltab2x48(:,:,30))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMT,G1H24(18),n2h24(26))
  Gcoeff(:)%j = (c(17)*M(1,:)%j-c(16)*M(3,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(34),h0tab(:,34),[16,4,3,8],[0,0,0,0],4,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,31),heltab2x48(:,:,31))
  call Hloop_A_Q(ntryL,G0H24(1),16,0,G1H24(19),n2h24(27))
  Gcoeff(:)%j = (c(15)*M(1,:)%j-c(14)*M(3,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(35),h0tab(:,35),[16,4,3,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,32),heltab2x48(:,:,32))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMT,G1H24(20),n2h24(28))
  Gcoeff(:)%j = (c(17)*M(2,:)%j-c(16)*M(3,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(36),h0tab(:,36),[16,4,3,8],[0,0,0,0],4,1,wf4(:,10))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,33),heltab2x48(:,:,33))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(21),n2h24(29))
  Gcoeff(:)%j = (c(15)*M(2,:)%j-c(14)*M(3,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(37),h0tab(:,37),[16,4,3,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,10))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,34),heltab2x48(:,:,34))
  call Hloop_Q_A(ntryL,G0H24(1),16,nMB,G1H24(22),n2h24(30))
  Gcoeff(:)%j = (c(17)*M(1,:)%j-c(16)*M(3,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(38),h0tab(:,38),[16,4,3,8],[0,0,0,0],4,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,35),heltab2x48(:,:,35))
  call Hloop_A_Q(ntryL,G0H24(1),16,0,G1H24(23),n2h24(31))
  Gcoeff(:)%j = (c(15)*M(1,:)%j-c(14)*M(3,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(39),h0tab(:,39),[16,4,3,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,36),heltab2x48(:,:,36))
  call Hloop_A_Q(ntryL,G0H24(1),16,nMB,G1H24(24),n2h24(32))
  Gcoeff(:)%j = (c(4)*M(3,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(40),h0tab(:,40),[16,2,8,5],[0,0,0,0],4,1,wf6(:,2))
  call Hloop_UV_W(ntryL,G0H48(1),0,ex5(:),16,G1H24(25),m3h2x24(:,37),heltab2x48(:,:,37))
  Gcoeff(:)%j = (-(c(4)*M(3,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(41),h0tab(:,41),[16,2,8,5],[0,0,0,0],4,1,wf6(:,2))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,38),heltab2x48(:,:,38))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(26),n2h24(33))
  Gcoeff(:)%j = (c(8)*M(1,:)%j-c(9)*M(3,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(42),h0tab(:,42),[16,5,2,8],[0,0,0,0],4,1,wf6(:,2))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,39),heltab2x48(:,:,39))
  call Hloop_A_Q(ntryL,G0H24(1),16,0,G1H24(27),n2h24(34))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)-c(9)*M(3,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(43),h0tab(:,43),[16,5,2,8],[0,0,0,0],4,1,wf6(:,2))
  call Hloop_UV_W(ntryL,G0H48(1),0,ex5(:),16,G1H24(28),m3h2x24(:,40),heltab2x48(:,:,40))
  Gcoeff(:)%j = (c(8)*M(2,:)%j-c(9)*M(3,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(44),h0tab(:,44),[16,2,5,8],[0,0,0,0],4,1,wf6(:,2))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,41),heltab2x48(:,:,41))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(29),n2h24(35))
  Gcoeff(:)%j = (-(c(11)*M(2,:)%j)-c(9)*M(3,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(45),h0tab(:,45),[16,2,5,8],[0,0,0,0],4,1,wf6(:,2))
  call Hloop_UV_W(ntryL,G0H48(1),0,ex5(:),16,G1H24(30),m3h2x24(:,42),heltab2x48(:,:,42))
  Gcoeff(:)%j = (-(c(4)*M(3,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(46),h0tab(:,46),[16,1,8,6],[0,0,0,0],4,1,wf6(:,4))
  call Hloop_UV_W(ntryL,G0H48(1),0,ex5(:),16,G1H24(31),m3h2x24(:,43),heltab2x48(:,:,43))
  Gcoeff(:)%j = (c(4)*M(3,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(47),h0tab(:,47),[16,1,8,6],[0,0,0,0],4,1,wf6(:,4))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,44),heltab2x48(:,:,44))
  call Hloop_A_Q(ntryL,G0H24(1),16,0,G1H24(32),n2h24(36))
  Gcoeff(:)%j = (c(8)*M(2,:)%j-c(9)*M(3,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(48),h0tab(:,48),[16,6,1,8],[0,0,0,0],4,1,wf6(:,4))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,45),heltab2x48(:,:,45))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(33),n2h24(37))
  Gcoeff(:)%j = (-(c(11)*M(2,:)%j)-c(9)*M(3,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(49),h0tab(:,49),[16,6,1,8],[0,0,0,0],4,1,wf6(:,4))
  call Hloop_UV_W(ntryL,G0H48(1),0,ex5(:),16,G1H24(34),m3h2x24(:,46),heltab2x48(:,:,46))
  Gcoeff(:)%j = (c(8)*M(1,:)%j-c(9)*M(3,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(50),h0tab(:,50),[16,1,6,8],[0,0,0,0],4,1,wf6(:,4))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,47),heltab2x48(:,:,47))
  call Hloop_A_Q(ntryL,G0H24(1),16,0,G1H24(35),n2h24(38))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)-c(9)*M(3,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(51),h0tab(:,51),[16,1,6,8],[0,0,0,0],4,1,wf6(:,4))
  call Hloop_UV_W(ntryL,G0H48(1),0,ex5(:),16,G1H24(36),m3h2x24(:,48),heltab2x48(:,:,48))
  Gcoeff(:)%j = (-(c(6)*M(2,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(52),h0tab(:,52),[16,2,4,9],[0,0,0,0],4,1,wf4(:,7))
  call Hloop_UV_W(ntryL,G0H48(1),0,ex5(:),16,G1H24(37),m3h2x24(:,49),heltab2x48(:,:,49))
  Gcoeff(:)%j = (c(8)*M(2,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(53),h0tab(:,53),[16,4,2,9],[0,0,0,0],4,1,wf4(:,7))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,50),heltab2x48(:,:,50))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(38),n2h24(39))
  Gcoeff(:)%j = (c(8)*M(2,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(54),h0tab(:,54),[16,2,9,4],[0,0,0,0],4,1,wf4(:,7))
  call Hloop_QV_A(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,51),heltab2x48(:,:,51))
  call Hloop_Q_A(ntryL,G0H24(1),16,0,G1H24(39),n2h24(40))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(55),h0tab(:,55),[16,1,4,10],[0,0,0,0],4,1,wf4(:,2))
  call Hloop_UV_W(ntryL,G0H48(1),0,ex5(:),16,G1H24(40),m3h2x24(:,52),heltab2x48(:,:,52))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(56),h0tab(:,56),[16,4,1,10],[0,0,0,0],4,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,53),heltab2x48(:,:,53))
  call Hloop_A_Q(ntryL,G0H24(1),16,0,G1H24(41),n2h24(41))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(57),h0tab(:,57),[16,1,10,4],[0,0,0,0],4,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H48(1),ex5(:),G0H24(1),m3h2x24(:,54),heltab2x48(:,:,54))
  call Hloop_A_Q(ntryL,G0H24(1),16,0,G1H24(42),n2h24(42))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(58),h0tab(:,58),[17,4,2,8],[0,0,0,0],4,1,wf4(:,9))
  call Hloop_VQ_A(ntryL,G0H48(1),wf4(:,9),G0H12(4),m3h4x12(:,1),heltab2x48(:,:,55))
  call Hloop_Q_A(ntryL,G0H12(4),17,0,G1H12(7),n2h12(9))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(59),h0tab(:,59),[17,2,4,8],[0,0,0,0],4,1,wf4(:,9))
  call Hloop_AQ_V(ntryL,G0H48(1),wf4(:,9),G0H12(4),m3h4x12(:,2),heltab2x48(:,:,56))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(60),h0tab(:,60),[17,2,8,4],[0,0,0,0],4,1,wf4(:,9))
  call Hloop_AQ_V(ntryL,G0H48(1),wf4(:,9),G0H12(5),m3h4x12(:,3),heltab2x48(:,:,57))
  Gcoeff(:)%j = (-(c(6)*M(2,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(61),h0tab(:,61),[18,4,1,8],[0,0,0,0],4,1,wf4(:,4))
  call Hloop_VA_Q(ntryL,G0H48(1),wf4(:,4),G0H12(6),m3h4x12(:,4),heltab2x48(:,:,58))
  call Hloop_A_Q(ntryL,G0H12(6),18,0,G1H12(1),n2h12(10))
  Gcoeff(:)%j = (c(8)*M(2,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(62),h0tab(:,62),[18,1,4,8],[0,0,0,0],4,1,wf4(:,4))
  call Hloop_QA_V(ntryL,G0H48(1),wf4(:,4),G0H12(6),m3h4x12(:,5),heltab2x48(:,:,59))
  Gcoeff(:)%j = (c(8)*M(2,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(63),h0tab(:,63),[18,1,8,4],[0,0,0,0],4,1,wf4(:,4))
  call Hloop_QA_V(ntryL,G0H48(1),wf4(:,4),G0H12(7),m3h4x12(:,6),heltab2x48(:,:,60))
  Gcoeff(:)%j = (c(3)*(-M(1,:)%j+M(2,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(64),h0tab(:,64),[24,2,1,4],[0,0,0,0],4,1,wf4(:,5))
  call Hloop_QV_A(ntryL,G0H48(1),wf4(:,5),G0H12(8),m3h4x12(:,7),heltab2x48(:,:,61))
  call Hloop_Q_A(ntryL,G0H12(8),24,0,G1H12(3),n2h12(11))
  Gcoeff(:)%j = (c(3)*(-M(1,:)%j+M(2,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(65),h0tab(:,65),[24,1,2,4],[0,0,0,0],4,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H48(1),wf4(:,5),G0H12(8),m3h4x12(:,8),heltab2x48(:,:,62))
  call Hloop_A_Q(ntryL,G0H12(8),24,0,G1H12(4),n2h12(12))
  Gcoeff(:)%j = (c(11)*(-M(1,:)%j+M(2,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(66),h0tab(:,66),[24,1,4,2],[0,0,0,0],4,1,wf4(:,5))
  call Hloop_UV_W(ntryL,G0H48(1),0,wf4(:,5),24,G1H12(8),m3h4x12(:,9),heltab2x48(:,:,63))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(1),[G1H12(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(7),[G1H12(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(8),[G0H12(3),G0H12(2),G0H12(1)])
  call Hloop_AZ_Q(ntryL,G1H12(1),ex3(:),G1H4(17),ngZd,m3h3x4(:,13),heltab2x12(:,:,27))
  call Hloop_A_Q(ntryL,G1H4(17),22,0,G2H4(3),n2h4(18))
  call Hloop_QZ_A(ntryL,G1H12(7),ex3(:),G1H4(18),ngZd,m3h3x4(:,14),heltab2x12(:,:,28))
  call Hloop_Q_A(ntryL,G1H4(18),21,0,G2H4(5),n2h4(19))
  call Hloop_QZ_A(ntryL,G1H12(16),ex3(:),G1H4(1),ngZd,m3h3x4(:,15),heltab2x12(:,:,29))
  call Hloop_Q_A(ntryL,G1H4(1),21,0,G2H4(6),n2h4(20))
  call Hloop_QV_A(ntryL,G1H12(21),ex4(:),G1H6(43),m3h2x6(:,15),heltab2x12(:,:,30))
  call Hloop_Q_A(ntryL,G1H6(43),25,0,G2H6(9),n2h6(18))
  call Hloop_VQ_A(ntryL,G1H12(8),ex1(:),G1H6(44),m3h2x6(:,16),heltab2x12(:,:,31))
  call Hloop_Q_A(ntryL,G1H6(44),25,0,G2H6(11),n2h6(19))
  call Hloop_QV_A(ntryL,G1H24(1),wf4(:,10),G1H6(3),m3h4x6(:,1),heltab2x24(:,:,13))
  call Hloop_Q_A(ntryL,G1H6(3),19,0,G2H6(12),n2h6(20))
  call Hloop_QV_A(ntryL,G1H24(2),wf4(:,10),G1H6(4),m3h4x6(:,2),heltab2x24(:,:,14))
  call Hloop_Q_A(ntryL,G1H6(4),19,nMT,G2H6(1),n2h6(21))
  call Hloop_AV_Q(ntryL,G1H24(3),wf4(:,10),G1H6(7),m3h4x6(:,3),heltab2x24(:,:,15))
  call Hloop_A_Q(ntryL,G1H6(7),19,0,G2H6(2),n2h6(22))
  call Hloop_AV_Q(ntryL,G1H24(4),wf4(:,10),G1H6(8),m3h4x6(:,4),heltab2x24(:,:,16))
  call Hloop_A_Q(ntryL,G1H6(8),19,nMT,G2H6(3),n2h6(23))
  call Hloop_QV_A(ntryL,G1H24(5),wf4(:,10),G1H6(9),m3h4x6(:,5),heltab2x24(:,:,17))
  call Hloop_Q_A(ntryL,G1H6(9),19,0,G2H6(4),n2h6(24))
  call Hloop_QV_A(ntryL,G1H24(6),wf4(:,10),G1H6(10),m3h4x6(:,6),heltab2x24(:,:,18))
  call Hloop_Q_A(ntryL,G1H6(10),19,nMB,G2H6(5),n2h6(25))
  call Hloop_AV_Q(ntryL,G1H24(7),wf4(:,10),G1H6(13),m3h4x6(:,7),heltab2x24(:,:,19))
  call Hloop_A_Q(ntryL,G1H6(13),19,0,G2H6(6),n2h6(26))
  call Hloop_AV_Q(ntryL,G1H24(8),wf4(:,10),G1H6(14),m3h4x6(:,8),heltab2x24(:,:,20))
  call Hloop_A_Q(ntryL,G1H6(14),19,nMB,G2H6(13),n2h6(27))
  call Hloop_AV_Q(ntryL,G1H24(9),wf4(:,10),G1H6(15),m3h4x6(:,9),heltab2x24(:,:,21))
  call Hloop_A_Q(ntryL,G1H6(15),19,0,G2H6(14),n2h6(28))
  call Hloop_AV_Q(ntryL,G1H24(10),wf4(:,10),G1H6(16),m3h4x6(:,10),heltab2x24(:,:,22))
  call Hloop_A_Q(ntryL,G1H6(16),19,nMT,G2H6(15),n2h6(29))
  call Hloop_QV_A(ntryL,G1H24(11),wf4(:,10),G1H6(19),m3h4x6(:,11),heltab2x24(:,:,23))
  call Hloop_Q_A(ntryL,G1H6(19),19,0,G2H6(16),n2h6(30))
  call Hloop_QV_A(ntryL,G1H24(12),wf4(:,10),G1H6(20),m3h4x6(:,12),heltab2x24(:,:,24))
  call Hloop_Q_A(ntryL,G1H6(20),19,nMT,G2H6(17),n2h6(31))
  call Hloop_AV_Q(ntryL,G1H24(13),wf4(:,10),G1H6(21),m3h4x6(:,13),heltab2x24(:,:,25))
  call Hloop_A_Q(ntryL,G1H6(21),19,0,G2H6(18),n2h6(32))
  call Hloop_AV_Q(ntryL,G1H24(14),wf4(:,10),G1H6(22),m3h4x6(:,14),heltab2x24(:,:,26))
  call Hloop_A_Q(ntryL,G1H6(22),19,nMB,G2H6(19),n2h6(33))
  call Hloop_QV_A(ntryL,G1H24(15),wf4(:,10),G1H6(25),m3h4x6(:,15),heltab2x24(:,:,27))
  call Hloop_Q_A(ntryL,G1H6(25),19,0,G2H6(20),n2h6(34))
  call Hloop_QV_A(ntryL,G1H24(16),wf4(:,10),G1H6(26),m3h4x6(:,16),heltab2x24(:,:,28))
  call Hloop_Q_A(ntryL,G1H6(26),19,nMB,G2H6(21),n2h6(35))
  call Hloop_QZ_A(ntryL,G1H24(17),ex3(:),G1H8(1),ngZu,m3h3x8(:,3),heltab2x24(:,:,29))
  call Hloop_Q_A(ntryL,G1H8(1),20,0,G2H8(1),n2h8(3))
  call Hloop_QZ_A(ntryL,G1H24(18),ex3(:),G1H8(1),ngZu,m3h3x8(:,4),heltab2x24(:,:,30))
  call Hloop_Q_A(ntryL,G1H8(1),20,nMT,G2H8(2),n2h8(4))
  call Hloop_AZ_Q(ntryL,G1H24(19),ex3(:),G1H8(1),ngZu,m3h3x8(:,5),heltab2x24(:,:,31))
  call Hloop_A_Q(ntryL,G1H8(1),20,0,G2H8(3),n2h8(5))
  call Hloop_AZ_Q(ntryL,G1H24(20),ex3(:),G1H8(1),ngZu,m3h3x8(:,6),heltab2x24(:,:,32))
  call Hloop_A_Q(ntryL,G1H8(1),20,nMT,G2H8(4),n2h8(6))
  call Hloop_QZ_A(ntryL,G1H24(21),ex3(:),G1H8(1),ngZd,m3h3x8(:,7),heltab2x24(:,:,33))
  call Hloop_Q_A(ntryL,G1H8(1),20,0,G2H8(5),n2h8(7))
  call Hloop_QZ_A(ntryL,G1H24(22),ex3(:),G1H8(1),ngZd,m3h3x8(:,8),heltab2x24(:,:,34))
  call Hloop_Q_A(ntryL,G1H8(1),20,nMB,G2H8(6),n2h8(8))
  call Hloop_AZ_Q(ntryL,G1H24(23),ex3(:),G1H8(1),ngZd,m3h3x8(:,9),heltab2x24(:,:,35))
  call Hloop_A_Q(ntryL,G1H8(1),20,0,G2H8(7),n2h8(9))
  call Hloop_AZ_Q(ntryL,G1H24(24),ex3(:),G1H8(1),ngZd,m3h3x8(:,10),heltab2x24(:,:,36))
  call Hloop_A_Q(ntryL,G1H8(1),20,nMB,G2H8(8),n2h8(10))
  call Hloop_VA_Q(ntryL,G1H24(25),ex2(:),G1H12(5),m3h2x12(:,11),heltab2x24(:,:,37))
  call Hloop_A_Q(ntryL,G1H12(5),18,0,G2H12(1),n2h12(13))
  call Hloop_QA_V(ntryL,G1H24(26),ex2(:),G1H12(9),m3h2x12(:,12),heltab2x24(:,:,38))
  call Hloop_AQ_V(ntryL,G1H24(27),wf6(:,2),G1H4(2),m3h6x4(:,1),heltab2x24(:,:,39))
  call Hloop_VQ_A(ntryL,G1H24(28),wf6(:,2),G1H4(5),m3h6x4(:,2),heltab2x24(:,:,40))
  call Hloop_Q_A(ntryL,G1H4(5),21,0,G2H4(7),n2h4(21))
  call Hloop_QA_V(ntryL,G1H24(29),ex2(:),G1H12(11),m3h2x12(:,13),heltab2x24(:,:,41))
  call Hloop_VA_Q(ntryL,G1H24(30),ex2(:),G1H12(12),m3h2x12(:,14),heltab2x24(:,:,42))
  call Hloop_A_Q(ntryL,G1H12(12),18,0,G2H12(2),n2h12(14))
  call Hloop_VQ_A(ntryL,G1H24(31),ex1(:),G1H12(13),m3h2x12(:,15),heltab2x24(:,:,43))
  call Hloop_Q_A(ntryL,G1H12(13),17,0,G2H12(3),n2h12(15))
  call Hloop_AQ_V(ntryL,G1H24(32),ex1(:),G1H12(14),m3h2x12(:,16),heltab2x24(:,:,44))
  call Hloop_QA_V(ntryL,G1H24(33),wf6(:,4),G1H4(6),m3h6x4(:,3),heltab2x24(:,:,45))
  call Hloop_VA_Q(ntryL,G1H24(34),wf6(:,4),G1H4(7),m3h6x4(:,4),heltab2x24(:,:,46))
  call Hloop_A_Q(ntryL,G1H4(7),22,0,G2H4(9),n2h4(22))
  call Hloop_AQ_V(ntryL,G1H24(35),ex1(:),G1H12(15),m3h2x12(:,17),heltab2x24(:,:,47))
  call Hloop_VQ_A(ntryL,G1H24(36),ex1(:),G1H12(17),m3h2x12(:,18),heltab2x24(:,:,48))
  call Hloop_Q_A(ntryL,G1H12(17),17,0,G2H12(4),n2h12(16))
  call Hloop_VA_Q(ntryL,G1H24(37),ex2(:),G1H12(18),m3h2x12(:,19),heltab2x24(:,:,49))
  call Hloop_A_Q(ntryL,G1H12(18),18,0,G2H12(5),n2h12(17))
  call Hloop_QZ_A(ntryL,G1H24(38),ex3(:),G1H8(1),ngZd,m3h3x8(:,11),heltab2x24(:,:,50))
  call Hloop_Q_A(ntryL,G1H8(1),20,0,G2H8(9),n2h8(11))
  call Hloop_QA_V(ntryL,G1H24(39),ex2(:),G1H12(19),m3h2x12(:,20),heltab2x24(:,:,51))
  call Hloop_VQ_A(ntryL,G1H24(40),ex1(:),G1H12(6),m3h2x12(:,21),heltab2x24(:,:,52))
  call Hloop_Q_A(ntryL,G1H12(6),17,0,G2H12(6),n2h12(18))
  call Hloop_AZ_Q(ntryL,G1H24(41),ex3(:),G1H8(1),ngZd,m3h3x8(:,12),heltab2x24(:,:,53))
  call Hloop_A_Q(ntryL,G1H8(1),20,0,G2H8(10),n2h8(12))
  call Hloop_AQ_V(ntryL,G1H24(42),ex1(:),G1H12(20),m3h2x12(:,22),heltab2x24(:,:,54))
  call Hloop_VA_Q(ntryL,G0H12(4),ex2(:),G0H6(1),m3h2x6(:,17),heltab2x12(:,:,32))
  call Hloop_A_Q(ntryL,G0H6(1),19,0,G1H6(27),n2h6(36))
  call Hloop_VA_Q(ntryL,G0H12(5),ex2(:),G0H6(1),m3h2x6(:,18),heltab2x12(:,:,33))
  call Hloop_A_Q(ntryL,G0H6(1),19,0,G1H6(28),n2h6(37))
  call Hloop_VQ_A(ntryL,G0H12(6),ex1(:),G0H6(1),m3h2x6(:,19),heltab2x12(:,:,34))
  call Hloop_Q_A(ntryL,G0H6(1),19,0,G1H6(31),n2h6(38))
  call Hloop_VQ_A(ntryL,G0H12(7),ex1(:),G0H6(1),m3h2x6(:,20),heltab2x12(:,:,35))
  call Hloop_Q_A(ntryL,G0H6(1),19,0,G1H6(32),n2h6(39))
  call Hloop_QA_V(ntryL,G1H12(3),ex2(:),G1H6(33),m3h2x6(:,21),heltab2x12(:,:,36))
  call Hloop_AQ_V(ntryL,G1H12(4),ex1(:),G1H6(34),m3h2x6(:,22),heltab2x12(:,:,37))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(9),[G2H4(4)])
call HGT_lower_alpha_OLR(G2H6(8),1,1,6)
call HGT_lower_alpha_invQ_OLR(G2H6(8),2,5,6)
call HGT_lower_alpha_OLR(G2H6(8),6,15,6)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(8),[G2H6(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(7),[G2H4(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(31),[G1H6(5)])
call HGT_w2_OLR(G1H6(1),1,1,6)
call HGT_w2_invQ_OLR(G1H6(1),2,5,6)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(1),[G1H6(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(12),[G1H4(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(32),[G1H6(11)])
call HGT_w2_OLR(G1H6(2),1,1,6)
call HGT_w2_invQ_OLR(G1H6(2),2,5,6)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(2),[G1H6(32)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(10),[G1H6(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(2),[G1H4(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(20),[G1H6(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(6),[G1H4(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(4),[G1H6(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(27),[G1H6(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(18),[G1H6(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(28),[G1H6(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(6),[G1H6(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(6),[G1H4(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(9),[G1H6(41)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(5),[G2H8(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(7),[G2H8(3)])
call HGT_lower_alpha_OLR(G2H6(7),1,1,6)
call HGT_lower_alpha_invQ_OLR(G2H6(7),2,5,6)
call HGT_lower_alpha_OLR(G2H6(7),6,15,6)
  call Hotf_4pt_reduction(G2H6(7),RedSet_4(47),mass4set(:,1),  & 
G1H6(37),G1H6(38),G1H6(39),G1H6(40),G1H6(45),6)
  call HG1shiftOLR(G1H6(38),1,6)
  call Hloop_AQ_V(ntryL,G2H4(9),ex1(:),G2H2(1),m3h2x2(:,23),heltab2x4(:,:,23))
  call Hotf_4pt_reduction(G2H6(8),RedSet_4(48),mass4set(:,1),  & 
G1H6(50),G1H6(46),G1H6(49),G1H6(51),G1H6(54),6)
  call HG1shiftOLR(G1H6(46),2,6)
  call Hloop_QA_V(ntryL,G2H4(7),ex2(:),G2H2(3),m3h2x2(:,24),heltab2x4(:,:,24))
  call Hloop_QZ_A(ntryL,G1H6(1),ex3(:),G1H2(9),ngZd,m3h3x2(:,16),heltab2x6(:,:,33))
  call Hloop_Q_A(ntryL,G1H2(9),23,0,G2H2(4),n2h2(23))
  call Hotf_4pt_reduction(G2H4(12),RedSet_4(11),mass4set(:,1),  & 
G1H4(8),G1H4(11),G1H4(12),G1H4(13),G1H4(14),4)
  call HG1shiftOLR(G1H4(11),2,4)
  call Hloop_QV_A(ntryL,G1H6(2),ex4(:),G1H3(9),m3h2x3(:,18),heltab2x6(:,:,34))
  call Hloop_Q_A(ntryL,G1H3(9),27,0,G2H3(2),n2h3(13))
  call Hotf_4pt_reduction(G2H6(10),RedSet_4(14),mass4set(:,1),  & 
G1H6(43),G1H6(44),G1H6(3),G1H6(4),G1H6(7),6)
  call HG1shiftOLR(G1H6(44),2,6)
  call Hloop_VA_Q(ntryL,G1H4(3),ex2(:),G1H2(20),m3h2x2(:,25),heltab2x4(:,:,25))
  call Hloop_A_Q(ntryL,G1H2(20),23,0,G2H2(6),n2h2(24))
  call Hloop_VA_Q(ntryL,G1H4(2),ex2(:),G1H2(31),m3h2x2(:,26),heltab2x4(:,:,26))
  call Hloop_A_Q(ntryL,G1H2(31),23,0,G2H2(7),n2h2(25))
  call Hotf_4pt_reduction(G2H6(20),RedSet_4(28),mass4set(:,1),  & 
G1H6(8),G1H6(9),G1H6(10),G1H6(13),G1H6(14),G0H6(1),6)
  call HG1shiftOLR(G1H6(9),8,6)
  call Hloop_VQ_A(ntryL,G1H4(9),ex1(:),G1H2(42),m3h2x2(:,27),heltab2x4(:,:,27))
  call Hloop_Q_A(ntryL,G1H2(42),23,0,G2H2(10),n2h2(26))
  call Hloop_VQ_A(ntryL,G1H4(6),ex1(:),G1H2(53),m3h2x2(:,28),heltab2x4(:,:,28))
  call Hloop_Q_A(ntryL,G1H2(53),23,0,G2H2(11),n2h2(27))
  call Hotf_4pt_reduction(G2H6(4),RedSet_4(33),mass4set(:,1),  & 
G1H6(15),G1H6(16),G1H6(19),G1H6(20),G1H6(21),G0H6(2),6)
  call HG1shiftOLR(G1H6(16),4,6)
  call Hloop_AZ_Q(ntryL,G1H6(27),ex3(:),G1H2(64),ngZd,m3h3x2(:,17),heltab2x6(:,:,35))
  call Hloop_A_Q(ntryL,G1H2(64),23,0,G2H2(13),n2h2(28))
  call Hotf_4pt_reduction(G2H6(18),RedSet_4(28),mass4set(:,1),  & 
G1H6(22),G1H6(25),G1H6(26),G1H6(5),G1H6(31),G0H6(3),6)
  call HG1shiftOLR(G1H6(25),8,6)
  call Hloop_AV_Q(ntryL,G1H6(28),ex4(:),G1H3(20),m3h2x3(:,19),heltab2x6(:,:,36))
  call Hloop_A_Q(ntryL,G1H3(20),27,0,G2H3(4),n2h3(14))
  call Hotf_4pt_reduction(G2H6(6),RedSet_4(33),mass4set(:,1),  & 
G1H6(11),G1H6(32),G1H6(42),G1H6(6),G1H6(12),G0H6(4),6)
  call HG1shiftOLR(G1H6(32),4,6)
  call Hloop_VQ_A(ntryL,G1H6(29),ex1(:),G1H3(31),m3h2x3(:,20),heltab2x6(:,:,37))
  call Hloop_Q_A(ntryL,G1H3(31),27,0,G2H3(6),n2h3(15))
  call Hloop_VQ_A(ntryL,G1H6(30),ex1(:),G1H3(42),m3h2x3(:,21),heltab2x6(:,:,38))
  call Hloop_Q_A(ntryL,G1H3(42),27,0,G2H3(8),n2h3(16))
  call Hloop_VA_Q(ntryL,G1H6(35),ex2(:),G1H3(4),m3h2x3(:,22),heltab2x6(:,:,39))
  call Hloop_A_Q(ntryL,G1H3(4),27,0,G2H3(9),n2h3(17))
  call Hloop_VA_Q(ntryL,G1H6(36),ex2(:),G1H3(5),m3h2x3(:,23),heltab2x6(:,:,40))
  call Hloop_A_Q(ntryL,G1H3(5),27,0,G2H3(11),n2h3(18))
  call Hotf_4pt_reduction(G2H4(6),RedSet_4(10),mass4set(:,1),  & 
G1H4(19),G1H4(24),G1H4(20),G1H4(23),G1H4(25),4)
  call HG1shiftOLR(G1H4(24),2,4)
  call Hloop_QV_A(ntryL,G1H4(21),ex4(:),G1H2(4),m3h2x2(:,29),heltab2x4(:,:,29))
  call Hloop_Q_A(ntryL,G1H2(4),29,0,G2H2(14),n2h2(29))
  call Hloop_QV_A(ntryL,G1H4(22),ex4(:),G1H2(5),m3h2x2(:,30),heltab2x4(:,:,30))
  call Hloop_Q_A(ntryL,G1H2(5),29,0,G2H2(17),n2h2(30))
  call Hloop_QV_A(ntryL,G1H4(26),ex4(:),G1H2(10),m3h2x2(:,31),heltab2x4(:,:,31))
  call Hloop_Q_A(ntryL,G1H2(10),29,0,G2H2(19),n2h2(31))
  call Hloop_QV_A(ntryL,G1H4(27),ex4(:),G1H2(11),m3h2x2(:,32),heltab2x4(:,:,32))
  call Hloop_Q_A(ntryL,G1H2(11),29,0,G2H2(21),n2h2(32))
  call Hotf_4pt_reduction(G2H6(9),RedSet_4(13),mass4set(:,1),  & 
G1H6(17),G1H6(18),G1H6(23),G1H6(24),G1H6(41),6)
  call HG1shiftOLR(G1H6(18),2,6)
  call Hloop_QZ_A(ntryL,G1H6(47),ex3(:),G1H2(15),ngZd,m3h3x2(:,18),heltab2x6(:,:,41))
  call Hloop_Q_A(ntryL,G1H2(15),29,0,G2H2(25),n2h2(33))
  call Hloop_QZ_A(ntryL,G1H6(48),ex3(:),G1H2(16),ngZd,m3h3x2(:,19),heltab2x6(:,:,42))
  call Hloop_Q_A(ntryL,G1H2(16),29,0,G2H2(27),n2h2(34))
  call Hloop_QZ_A(ntryL,G1H6(52),ex3(:),G1H2(21),ngZd,m3h3x2(:,20),heltab2x6(:,:,43))
  call Hloop_Q_A(ntryL,G1H2(21),29,0,G2H2(30),n2h2(35))
  call Hloop_QZ_A(ntryL,G1H6(53),ex3(:),G1H2(22),ngZd,m3h3x2(:,21),heltab2x6(:,:,44))
  call Hloop_Q_A(ntryL,G1H2(22),29,0,G2H2(32),n2h2(36))
  call Hloop_AQ_V(ntryL,G2H4(3),ex1(:),G2H2(35),m3h2x2(:,33),heltab2x4(:,:,33))
  call Hloop_QA_V(ntryL,G2H4(5),ex2(:),G2H2(36),m3h2x2(:,34),heltab2x4(:,:,34))
  call Hotf_4pt_reduction(G2H6(12),RedSet_4(33),mass4set(:,1),  & 
G1H6(1),G1H6(2),G1H6(27),G1H6(28),G1H6(29),G0H6(5),6)
  call HG1shiftOLR(G1H6(2),4,6)
  call Hotf_4pt_reduction(G2H6(1),RedSet_4(33),mass4set(:,2),  & 
G1H6(30),G1H6(35),G1H6(36),G1H6(47),G1H6(48),G0H6(6),6)
  call HG1shiftOLR(G1H6(35),4,6)
  call Hotf_4pt_reduction(G2H6(2),RedSet_4(33),mass4set(:,1),  & 
G1H6(52),G1H6(53),G1H6(55),G1H6(56),G1H6(57),G0H6(7),6)
  call HG1shiftOLR(G1H6(53),4,6)
  call Hotf_4pt_reduction(G2H6(3),RedSet_4(33),mass4set(:,2),  & 
G1H6(58),G1H6(59),G1H6(60),G1H6(61),G1H6(62),G0H6(8),6)
  call HG1shiftOLR(G1H6(59),4,6)
  call Hotf_4pt_reduction(G2H6(5),RedSet_4(33),mass4set(:,3),  & 
G1H6(63),G1H6(64),G1H6(65),G1H6(66),G1H6(67),G0H6(9),6)
  call HG1shiftOLR(G1H6(64),4,6)
  call Hotf_4pt_reduction(G2H6(13),RedSet_4(33),mass4set(:,3),  & 
G1H6(68),G1H6(69),G1H6(70),G1H6(71),G1H6(72),G0H6(10),6)
  call HG1shiftOLR(G1H6(69),4,6)
  call Hotf_4pt_reduction(G2H6(14),RedSet_4(28),mass4set(:,1),  & 
G1H6(73),G1H6(74),G1H6(75),G1H6(76),G1H6(77),G0H6(11),6)
  call HG1shiftOLR(G1H6(74),8,6)
  call Hotf_4pt_reduction(G2H6(15),RedSet_4(28),mass4set(:,2),  & 
G1H6(78),G1H6(79),G1H6(80),G1H6(81),G1H6(82),G0H6(12),6)
  call HG1shiftOLR(G1H6(79),8,6)
  call Hotf_4pt_reduction(G2H6(16),RedSet_4(28),mass4set(:,1),  & 
G1H6(83),G1H6(84),G1H6(85),G1H6(86),G1H6(87),G0H6(13),6)
  call HG1shiftOLR(G1H6(84),8,6)
  call Hotf_4pt_reduction(G2H6(17),RedSet_4(28),mass4set(:,2),  & 
G1H6(88),G1H6(89),G1H6(90),G1H6(91),G1H6(92),G0H6(14),6)
  call HG1shiftOLR(G1H6(89),8,6)
  call Hotf_4pt_reduction(G2H6(19),RedSet_4(28),mass4set(:,3),  & 
G1H6(93),G1H6(94),G1H6(95),G1H6(96),G1H6(97),G0H6(15),6)
  call HG1shiftOLR(G1H6(94),8,6)
  call Hotf_4pt_reduction(G2H6(21),RedSet_4(28),mass4set(:,3),  & 
G1H6(98),G1H6(99),G1H6(100),G1H6(101),G1H6(102),G0H6(16),6)
  call HG1shiftOLR(G1H6(99),8,6)
  call Hotf_4pt_reduction(G2H8(5),RedSet_4(25),mass4set(:,1),  & 
G1H8(1),G1H8(2),G1H8(3),G1H8(4),G1H8(5),G0H8(1),8)
  call HG1shiftOLR(G1H8(2),8,8)
  call Hotf_4pt_reduction(G2H8(2),RedSet_4(25),mass4set(:,2),  & 
G1H8(6),G1H8(7),G1H8(8),G1H8(9),G1H8(10),G0H8(2),8)
  call HG1shiftOLR(G1H8(7),8,8)
  call Hotf_4pt_reduction(G2H8(7),RedSet_4(25),mass4set(:,1),  & 
G1H8(11),G1H8(12),G1H8(13),G1H8(14),G1H8(15),G0H8(3),8)
  call HG1shiftOLR(G1H8(12),8,8)
  call Hotf_4pt_reduction(G2H8(4),RedSet_4(25),mass4set(:,2),  & 
G1H8(16),G1H8(17),G1H8(18),G1H8(19),G1H8(20),G0H8(4),8)
  call HG1shiftOLR(G1H8(17),8,8)
  call Hotf_4pt_reduction(G2H8(6),RedSet_4(25),mass4set(:,3),  & 
G1H8(21),G1H8(22),G1H8(23),G1H8(24),G1H8(25),G0H8(5),8)
  call HG1shiftOLR(G1H8(22),8,8)
  call Hotf_4pt_reduction(G2H8(8),RedSet_4(25),mass4set(:,3),  & 
G1H8(26),G1H8(27),G1H8(28),G1H8(29),G1H8(30),G0H8(6),8)
  call HG1shiftOLR(G1H8(27),8,8)
  call Hotf_4pt_reduction(G2H12(1),RedSet_4(9),mass4set(:,1),  & 
G1H12(22),G1H12(23),G1H12(24),G1H12(2),G1H12(10),12)
  call HG1shiftOLR(G1H12(23),5,12)
  call Hloop_UV_W(ntryL,G1H12(9),18,ex4(:),8,G2H6(11),m3h2x6(:,23),heltab2x12(:,:,38))
  call Hloop_VQ_A(ntryL,G1H12(11),wf6(:,2),G1H2(26),m3h6x2(:,1),heltab2x12(:,:,39))
  call Hloop_Q_A(ntryL,G1H2(26),23,0,G2H2(37),n2h2(37))
  call Hloop_AQ_V(ntryL,G2H12(2),wf6(:,2),G2H2(38),m3h6x2(:,2),heltab2x12(:,:,40))
  call Hotf_4pt_reduction(G2H12(3),RedSet_4(3),mass4set(:,1),  & 
G1H12(1),G1H12(7),G1H12(16),G1H12(21),G1H12(8),12)
  call HG1shiftOLR(G1H12(7),6,12)
  call Hloop_UV_W(ntryL,G1H12(14),17,ex4(:),8,G2H6(7),m3h2x6(:,24),heltab2x12(:,:,41))
  call Hloop_VA_Q(ntryL,G1H12(15),wf6(:,4),G1H2(27),m3h6x2(:,3),heltab2x12(:,:,42))
  call Hloop_A_Q(ntryL,G1H2(27),23,0,G2H2(39),n2h2(38))
  call Hloop_QA_V(ntryL,G2H12(4),wf6(:,4),G2H2(40),m3h6x2(:,4),heltab2x12(:,:,43))
  call Hotf_4pt_reduction(G2H12(5),RedSet_4(4),mass4set(:,1),  & 
G1H12(5),G1H12(12),G1H12(13),G1H12(17),G1H12(18),12)
  call HG1shiftOLR(G1H12(12),9,12)
  call Hloop_QA_V(ntryL,G2H8(9),ex2(:),G2H4(10),m3h2x4(:,3),heltab2x8(:,:,3))
  call Hloop_VQ_A(ntryL,G1H12(19),wf4(:,7),G1H3(10),m3h4x3(:,1),heltab2x12(:,:,44))
  call Hloop_Q_A(ntryL,G1H3(10),27,0,G2H3(12),n2h3(19))
  call Hotf_4pt_reduction(G2H12(6),RedSet_4(2),mass4set(:,1),  & 
G1H12(6),G1H12(3),G1H12(4),G1H12(9),G1H12(11),12)
  call HG1shiftOLR(G1H12(3),10,12)
  call Hloop_AQ_V(ntryL,G2H8(10),ex1(:),G2H4(11),m3h2x4(:,4),heltab2x8(:,:,4))
  call Hloop_VA_Q(ntryL,G1H12(20),wf4(:,2),G1H3(11),m3h4x3(:,2),heltab2x12(:,:,45))
  call Hloop_A_Q(ntryL,G1H3(11),27,0,G2H3(14),n2h3(20))
  call Hloop_VQ_A(ntryL,G1H6(33),ex1(:),G1H3(15),m3h2x3(:,24),heltab2x6(:,:,45))
  call Hloop_Q_A(ntryL,G1H3(15),27,0,G2H3(15),n2h3(21))
  call Hloop_VA_Q(ntryL,G1H6(34),ex2(:),G1H3(16),m3h2x3(:,25),heltab2x6(:,:,46))
  call Hloop_A_Q(ntryL,G1H3(16),27,0,G2H3(16),n2h3(22))
  call Hloop_AZ_Q(ntryL,G1H6(37),ex3(:),G1H2(32),ngZd,m3h3x2(:,22),heltab2x6(:,:,47))
  call Hloop_A_Q(ntryL,G1H2(32),30,0,G2H2(41),n2h2(39))
call HGT_raise_alpha_OLR(G1H6(38),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(38),2,5,6)
  call Hloop_VQ_A(ntryL,G1H6(38),ex1(:),G1H3(21),m3h2x3(:,26),heltab2x6(:,:,48))
  call Hloop_AZ_Q(ntryL,G1H6(40),ex3(:),G1H2(33),ngZd,m3h3x2(:,23),heltab2x6(:,:,49))
  call Hloop_A_Q(ntryL,G1H2(33),30,0,G2H2(42),n2h2(40))
  call Hloop_AZ_Q(ntryL,G1H6(45),ex3(:),G1H2(37),ngZd,m3h3x2(:,24),heltab2x6(:,:,50))
  call Hloop_A_Q(ntryL,G1H2(37),30,0,G2H2(43),n2h2(41))
  call Hloop_QZ_A(ntryL,G1H6(50),ex3(:),G1H2(38),ngZd,m3h3x2(:,25),heltab2x6(:,:,51))
  call Hloop_Q_A(ntryL,G1H2(38),29,0,G2H2(44),n2h2(42))
call HGT_raise_alpha_OLR(G1H6(46),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(46),2,5,6)
  call Hloop_VA_Q(ntryL,G1H6(46),ex2(:),G1H3(22),m3h2x3(:,27),heltab2x6(:,:,52))
  call Hloop_QZ_A(ntryL,G1H6(51),ex3(:),G1H2(43),ngZd,m3h3x2(:,26),heltab2x6(:,:,53))
  call Hloop_Q_A(ntryL,G1H2(43),29,0,G2H2(45),n2h2(43))
  call Hloop_QZ_A(ntryL,G1H6(54),ex3(:),G1H2(44),ngZd,m3h3x2(:,27),heltab2x6(:,:,54))
  call Hloop_Q_A(ntryL,G1H2(44),29,0,G2H2(46),n2h2(44))
  call Hloop_QV_A(ntryL,G1H4(8),ex4(:),G1H2(48),m3h2x2(:,35),heltab2x4(:,:,35))
  call Hloop_Q_A(ntryL,G1H2(48),29,0,G2H2(47),n2h2(45))
call HGT_raise_alpha_OLR(G1H4(11),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(11),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(11),ex2(:),G1H2(49),m3h2x2(:,36),heltab2x4(:,:,36))
  call Hloop_QV_A(ntryL,G1H4(13),ex4(:),G1H2(54),m3h2x2(:,37),heltab2x4(:,:,37))
  call Hloop_Q_A(ntryL,G1H2(54),29,0,G2H2(48),n2h2(46))
  call Hloop_QV_A(ntryL,G1H4(14),ex4(:),G1H2(55),m3h2x2(:,38),heltab2x4(:,:,38))
  call Hloop_Q_A(ntryL,G1H2(55),29,0,G2H2(49),n2h2(47))
  call Hloop_QZ_A(ntryL,G1H6(43),ex3(:),G1H2(59),ngZd,m3h3x2(:,28),heltab2x6(:,:,55))
  call Hloop_Q_A(ntryL,G1H2(59),29,0,G2H2(50),n2h2(48))
call HGT_raise_alpha_OLR(G1H6(44),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(44),2,5,6)
  call Hloop_VA_Q(ntryL,G1H6(44),ex2(:),G1H3(26),m3h2x3(:,28),heltab2x6(:,:,56))
  call Hloop_QZ_A(ntryL,G1H6(4),ex3(:),G1H2(60),ngZd,m3h3x2(:,29),heltab2x6(:,:,57))
  call Hloop_Q_A(ntryL,G1H2(60),29,0,G2H2(51),n2h2(49))
  call Hloop_QZ_A(ntryL,G1H6(7),ex3(:),G1H2(65),ngZd,m3h3x2(:,30),heltab2x6(:,:,58))
  call Hloop_Q_A(ntryL,G1H2(65),29,0,G2H2(52),n2h2(50))
  call Hloop_QZ_A(ntryL,G1H6(8),ex3(:),G1H2(66),ngZd,m3h3x2(:,31),heltab2x6(:,:,59))
  call Hloop_Q_A(ntryL,G1H2(66),23,0,G2H2(53),n2h2(51))
call HGT_OLR(G1H6(9),1,1,6)
call HGT_invQ_OLR(G1H6(9),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(9),-8,0,G2H6(8),n2h6(43))
  call Hloop_AV_Q(ntryL,G2H6(8),ex4(:),G2H3(17),m3h2x3(:,29),heltab2x6(:,:,60))
  call Hloop_QZ_A(ntryL,G1H6(13),ex3(:),G1H2(9),ngZd,m3h3x2(:,32),heltab2x6(:,:,61))
  call Hloop_Q_A(ntryL,G1H2(9),23,0,G2H2(54),n2h2(52))
  call Hloop_QZ_A(ntryL,G1H6(14),ex3(:),G1H2(20),ngZd,m3h3x2(:,33),heltab2x6(:,:,62))
  call Hloop_Q_A(ntryL,G1H2(20),23,0,G2H2(55),n2h2(53))
  call Hloop_QZ_A(ntryL,G0H6(1),ex3(:),G0H2(1),ngZd,m3h3x2(:,34),heltab2x6(:,:,63))
  call Hloop_Q_A(ntryL,G0H2(1),23,0,G1H2(31),n2h2(54))
  call Hloop_QV_A(ntryL,G1H6(15),ex4(:),G1H3(27),m3h2x3(:,30),heltab2x6(:,:,64))
  call Hloop_Q_A(ntryL,G1H3(27),27,0,G2H3(18),n2h3(23))
call HGT_OLR(G1H6(16),1,1,6)
call HGT_invQ_OLR(G1H6(16),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(16),-4,0,G2H6(10),n2h6(44))
  call Hloop_AZ_Q(ntryL,G2H6(10),ex3(:),G2H2(56),ngZd,m3h3x2(:,35),heltab2x6(:,:,65))
  call Hloop_QV_A(ntryL,G1H6(20),ex4(:),G1H3(32),m3h2x3(:,31),heltab2x6(:,:,66))
  call Hloop_Q_A(ntryL,G1H3(32),27,0,G2H3(19),n2h3(24))
  call Hloop_QV_A(ntryL,G1H6(21),ex4(:),G1H3(33),m3h2x3(:,32),heltab2x6(:,:,67))
  call Hloop_Q_A(ntryL,G1H3(33),27,0,G2H3(20),n2h3(25))
  call Hloop_QV_A(ntryL,G0H6(2),ex4(:),G0H3(1),m3h2x3(:,33),heltab2x6(:,:,68))
  call Hloop_Q_A(ntryL,G0H3(1),27,0,G1H3(37),n2h3(26))
  call Hloop_AZ_Q(ntryL,G1H6(22),ex3(:),G1H2(42),ngZd,m3h3x2(:,36),heltab2x6(:,:,69))
  call Hloop_A_Q(ntryL,G1H2(42),23,0,G2H2(57),n2h2(55))
call HGT_OLR(G1H6(25),1,1,6)
call HGT_invQ_OLR(G1H6(25),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(25),-8,0,G2H6(20),n2h6(45))
  call Hloop_QV_A(ntryL,G2H6(20),ex4(:),G2H3(21),m3h2x3(:,34),heltab2x6(:,:,70))
  call Hloop_AZ_Q(ntryL,G1H6(5),ex3(:),G1H2(53),ngZd,m3h3x2(:,37),heltab2x6(:,:,71))
  call Hloop_A_Q(ntryL,G1H2(53),23,0,G2H2(58),n2h2(56))
  call Hloop_AZ_Q(ntryL,G1H6(31),ex3(:),G1H2(64),ngZd,m3h3x2(:,38),heltab2x6(:,:,72))
  call Hloop_A_Q(ntryL,G1H2(64),23,0,G2H2(59),n2h2(57))
  call Hloop_AZ_Q(ntryL,G0H6(3),ex3(:),G0H2(1),ngZd,m3h3x2(:,39),heltab2x6(:,:,73))
  call Hloop_A_Q(ntryL,G0H2(1),23,0,G1H2(4),n2h2(58))
  call Hloop_AV_Q(ntryL,G1H6(11),ex4(:),G1H3(38),m3h2x3(:,35),heltab2x6(:,:,74))
  call Hloop_A_Q(ntryL,G1H3(38),27,0,G2H3(22),n2h3(27))
call HGT_OLR(G1H6(32),1,1,6)
call HGT_invQ_OLR(G1H6(32),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(32),-4,0,G2H6(4),n2h6(46))
  call Hloop_QZ_A(ntryL,G2H6(4),ex3(:),G2H2(60),ngZd,m3h3x2(:,40),heltab2x6(:,:,75))
  call Hloop_AV_Q(ntryL,G1H6(6),ex4(:),G1H3(43),m3h2x3(:,36),heltab2x6(:,:,76))
  call Hloop_A_Q(ntryL,G1H3(43),27,0,G2H3(23),n2h3(28))
  call Hloop_AV_Q(ntryL,G1H6(12),ex4(:),G1H3(44),m3h2x3(:,37),heltab2x6(:,:,77))
  call Hloop_A_Q(ntryL,G1H3(44),27,0,G2H3(24),n2h3(29))
  call Hloop_AV_Q(ntryL,G0H6(4),ex4(:),G0H3(1),m3h2x3(:,38),heltab2x6(:,:,78))
  call Hloop_A_Q(ntryL,G0H3(1),27,0,G1H3(9),n2h3(30))
  call Hloop_QV_A(ntryL,G1H4(19),ex4(:),G1H2(5),m3h2x2(:,39),heltab2x4(:,:,39))
  call Hloop_Q_A(ntryL,G1H2(5),29,0,G2H2(61),n2h2(59))
call HGT_raise_alpha_OLR(G1H4(24),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(24),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(24),ex2(:),G1H2(10),m3h2x2(:,40),heltab2x4(:,:,40))
  call Hloop_QV_A(ntryL,G1H4(23),ex4(:),G1H2(11),m3h2x2(:,41),heltab2x4(:,:,41))
  call Hloop_Q_A(ntryL,G1H2(11),29,0,G2H2(62),n2h2(60))
  call Hloop_QV_A(ntryL,G1H4(25),ex4(:),G1H2(15),m3h2x2(:,42),heltab2x4(:,:,42))
  call Hloop_Q_A(ntryL,G1H2(15),29,0,G2H2(63),n2h2(61))
  call Hloop_QZ_A(ntryL,G1H6(17),ex3(:),G1H2(16),ngZd,m3h3x2(:,41),heltab2x6(:,:,79))
  call Hloop_Q_A(ntryL,G1H2(16),29,0,G2H2(64),n2h2(62))
call HGT_raise_alpha_OLR(G1H6(18),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(18),2,5,6)
  call Hloop_VA_Q(ntryL,G1H6(18),ex2(:),G1H3(20),m3h2x3(:,39),heltab2x6(:,:,80))
  call Hloop_QZ_A(ntryL,G1H6(24),ex3(:),G1H2(21),ngZd,m3h3x2(:,42),heltab2x6(:,:,81))
  call Hloop_Q_A(ntryL,G1H2(21),29,0,G2H2(65),n2h2(63))
  call Hloop_QZ_A(ntryL,G1H6(41),ex3(:),G1H2(22),ngZd,m3h3x2(:,43),heltab2x6(:,:,82))
  call Hloop_Q_A(ntryL,G1H2(22),29,0,G2H2(66),n2h2(64))
  call Hloop_QV_A(ntryL,G1H6(1),ex4(:),G1H3(31),m3h2x3(:,40),heltab2x6(:,:,83))
  call Hloop_Q_A(ntryL,G1H3(31),27,0,G2H3(25),n2h3(31))
call HGT_OLR(G1H6(2),1,1,6)
call HGT_invQ_OLR(G1H6(2),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(2),-4,0,G2H6(18),n2h6(48))
  call Hloop_AZ_Q(ntryL,G2H6(18),ex3(:),G2H2(67),ngZu,m3h3x2(:,44),heltab2x6(:,:,84))
  call Hloop_QV_A(ntryL,G1H6(28),ex4(:),G1H3(42),m3h2x3(:,41),heltab2x6(:,:,85))
  call Hloop_Q_A(ntryL,G1H3(42),27,0,G2H3(26),n2h3(32))
  call Hloop_QV_A(ntryL,G1H6(29),ex4(:),G1H3(4),m3h2x3(:,42),heltab2x6(:,:,86))
  call Hloop_Q_A(ntryL,G1H3(4),27,0,G2H3(27),n2h3(33))
  call Hloop_QV_A(ntryL,G0H6(5),ex4(:),G0H3(1),m3h2x3(:,43),heltab2x6(:,:,87))
  call Hloop_Q_A(ntryL,G0H3(1),27,0,G1H3(5),n2h3(34))
  call Hloop_QV_A(ntryL,G1H6(30),ex4(:),G1H3(10),m3h2x3(:,44),heltab2x6(:,:,88))
  call Hloop_Q_A(ntryL,G1H3(10),27,nMT,G2H3(28),n2h3(35))
call HGT_OLR(G1H6(35),1,1,6)
call HGT_invQ_OLR(G1H6(35),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(35),-4,nMT,G2H6(6),n2h6(49))
  call Hloop_AZ_Q(ntryL,G2H6(6),ex3(:),G2H2(68),ngZu,m3h3x2(:,45),heltab2x6(:,:,89))
  call Hloop_QV_A(ntryL,G1H6(47),ex4(:),G1H3(11),m3h2x3(:,45),heltab2x6(:,:,90))
  call Hloop_Q_A(ntryL,G1H3(11),27,nMT,G2H3(29),n2h3(36))
  call Hloop_QV_A(ntryL,G1H6(48),ex4(:),G1H3(15),m3h2x3(:,46),heltab2x6(:,:,91))
  call Hloop_Q_A(ntryL,G1H3(15),27,nMT,G2H3(30),n2h3(37))
  call Hloop_QV_A(ntryL,G0H6(6),ex4(:),G0H3(1),m3h2x3(:,47),heltab2x6(:,:,92))
  call Hloop_Q_A(ntryL,G0H3(1),27,nMT,G1H3(16),n2h3(38))
  call Hloop_AV_Q(ntryL,G1H6(52),ex4(:),G1H3(27),m3h2x3(:,48),heltab2x6(:,:,93))
  call Hloop_A_Q(ntryL,G1H3(27),27,0,G2H3(31),n2h3(39))
call HGT_OLR(G1H6(53),1,1,6)
call HGT_invQ_OLR(G1H6(53),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(53),-4,0,G2H6(9),n2h6(50))
  call Hloop_QZ_A(ntryL,G2H6(9),ex3(:),G2H2(69),ngZu,m3h3x2(:,46),heltab2x6(:,:,94))
  call Hloop_AV_Q(ntryL,G1H6(56),ex4(:),G1H3(32),m3h2x3(:,49),heltab2x6(:,:,95))
  call Hloop_A_Q(ntryL,G1H3(32),27,0,G2H3(32),n2h3(40))
  call Hloop_AV_Q(ntryL,G1H6(57),ex4(:),G1H3(33),m3h2x3(:,50),heltab2x6(:,:,96))
  call Hloop_A_Q(ntryL,G1H3(33),27,0,G2H3(33),n2h3(41))
  call Hloop_AV_Q(ntryL,G0H6(7),ex4(:),G0H3(1),m3h2x3(:,51),heltab2x6(:,:,97))
  call Hloop_A_Q(ntryL,G0H3(1),27,0,G1H3(38),n2h3(42))
  call Hloop_AV_Q(ntryL,G1H6(58),ex4(:),G1H3(43),m3h2x3(:,52),heltab2x6(:,:,98))
  call Hloop_A_Q(ntryL,G1H3(43),27,nMT,G2H3(34),n2h3(43))
call HGT_OLR(G1H6(59),1,1,6)
call HGT_invQ_OLR(G1H6(59),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(59),-4,nMT,G2H6(12),n2h6(51))
  call Hloop_QZ_A(ntryL,G2H6(12),ex3(:),G2H2(70),ngZu,m3h3x2(:,47),heltab2x6(:,:,99))
  call Hloop_AV_Q(ntryL,G1H6(61),ex4(:),G1H3(44),m3h2x3(:,53),heltab2x6(:,:,100))
  call Hloop_A_Q(ntryL,G1H3(44),27,nMT,G2H3(35),n2h3(44))
  call Hloop_AV_Q(ntryL,G1H6(62),ex4(:),G1H3(31),m3h2x3(:,54),heltab2x6(:,:,101))
  call Hloop_A_Q(ntryL,G1H3(31),27,nMT,G2H3(36),n2h3(45))
  call Hloop_AV_Q(ntryL,G0H6(8),ex4(:),G0H3(1),m3h2x3(:,55),heltab2x6(:,:,102))
  call Hloop_A_Q(ntryL,G0H3(1),27,nMT,G1H3(42),n2h3(46))
  call Hloop_QV_A(ntryL,G1H6(63),ex4(:),G1H3(4),m3h2x3(:,56),heltab2x6(:,:,103))
  call Hloop_Q_A(ntryL,G1H3(4),27,nMB,G2H3(37),n2h3(47))
call HGT_OLR(G1H6(64),1,1,6)
call HGT_invQ_OLR(G1H6(64),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(64),-4,nMB,G2H6(1),n2h6(52))
  call Hloop_AZ_Q(ntryL,G2H6(1),ex3(:),G2H2(71),ngZd,m3h3x2(:,48),heltab2x6(:,:,104))
  call Hloop_QV_A(ntryL,G1H6(66),ex4(:),G1H3(10),m3h2x3(:,57),heltab2x6(:,:,105))
  call Hloop_Q_A(ntryL,G1H3(10),27,nMB,G2H3(38),n2h3(48))
  call Hloop_QV_A(ntryL,G1H6(67),ex4(:),G1H3(11),m3h2x3(:,58),heltab2x6(:,:,106))
  call Hloop_Q_A(ntryL,G1H3(11),27,nMB,G2H3(39),n2h3(49))
  call Hloop_QV_A(ntryL,G0H6(9),ex4(:),G0H3(1),m3h2x3(:,59),heltab2x6(:,:,107))
  call Hloop_Q_A(ntryL,G0H3(1),27,nMB,G1H3(15),n2h3(50))
  call Hloop_AV_Q(ntryL,G1H6(68),ex4(:),G1H3(27),m3h2x3(:,60),heltab2x6(:,:,108))
  call Hloop_A_Q(ntryL,G1H3(27),27,nMB,G2H3(40),n2h3(51))
call HGT_OLR(G1H6(69),1,1,6)
call HGT_invQ_OLR(G1H6(69),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(69),-4,nMB,G2H6(2),n2h6(53))
  call Hloop_QZ_A(ntryL,G2H6(2),ex3(:),G2H2(72),ngZd,m3h3x2(:,49),heltab2x6(:,:,109))
  call Hloop_AV_Q(ntryL,G1H6(71),ex4(:),G1H3(32),m3h2x3(:,61),heltab2x6(:,:,110))
  call Hloop_A_Q(ntryL,G1H3(32),27,nMB,G2H3(41),n2h3(52))
  call Hloop_AV_Q(ntryL,G1H6(72),ex4(:),G1H3(33),m3h2x3(:,62),heltab2x6(:,:,111))
  call Hloop_A_Q(ntryL,G1H3(33),27,nMB,G2H3(42),n2h3(53))
  call Hloop_AV_Q(ntryL,G0H6(10),ex4(:),G0H3(1),m3h2x3(:,63),heltab2x6(:,:,112))
  call Hloop_A_Q(ntryL,G0H3(1),27,nMB,G1H3(43),n2h3(54))
  call Hloop_AZ_Q(ntryL,G1H6(73),ex3(:),G1H2(26),ngZu,m3h3x2(:,50),heltab2x6(:,:,113))
  call Hloop_A_Q(ntryL,G1H2(26),23,0,G2H2(73),n2h2(65))
call HGT_OLR(G1H6(74),1,1,6)
call HGT_invQ_OLR(G1H6(74),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(74),-8,0,G2H6(3),n2h6(54))
  call Hloop_QV_A(ntryL,G2H6(3),ex4(:),G2H3(43),m3h2x3(:,64),heltab2x6(:,:,114))
  call Hloop_AZ_Q(ntryL,G1H6(76),ex3(:),G1H2(27),ngZu,m3h3x2(:,51),heltab2x6(:,:,115))
  call Hloop_A_Q(ntryL,G1H2(27),23,0,G2H2(74),n2h2(66))
  call Hloop_AZ_Q(ntryL,G1H6(77),ex3(:),G1H2(32),ngZu,m3h3x2(:,52),heltab2x6(:,:,116))
  call Hloop_A_Q(ntryL,G1H2(32),23,0,G2H2(75),n2h2(67))
  call Hloop_AZ_Q(ntryL,G0H6(11),ex3(:),G0H2(1),ngZu,m3h3x2(:,53),heltab2x6(:,:,117))
  call Hloop_A_Q(ntryL,G0H2(1),23,0,G1H2(33),n2h2(68))
  call Hloop_AZ_Q(ntryL,G1H6(78),ex3(:),G1H2(37),ngZu,m3h3x2(:,54),heltab2x6(:,:,118))
  call Hloop_A_Q(ntryL,G1H2(37),23,nMT,G2H2(76),n2h2(69))
call HGT_OLR(G1H6(79),1,1,6)
call HGT_invQ_OLR(G1H6(79),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(79),-8,nMT,G2H6(5),n2h6(55))
  call Hloop_QV_A(ntryL,G2H6(5),ex4(:),G2H3(44),m3h2x3(:,65),heltab2x6(:,:,119))
  call Hloop_AZ_Q(ntryL,G1H6(81),ex3(:),G1H2(38),ngZu,m3h3x2(:,55),heltab2x6(:,:,120))
  call Hloop_A_Q(ntryL,G1H2(38),23,nMT,G2H2(77),n2h2(70))
  call Hloop_AZ_Q(ntryL,G1H6(82),ex3(:),G1H2(43),ngZu,m3h3x2(:,56),heltab2x6(:,:,121))
  call Hloop_A_Q(ntryL,G1H2(43),23,nMT,G2H2(78),n2h2(71))
  call Hloop_AZ_Q(ntryL,G0H6(12),ex3(:),G0H2(1),ngZu,m3h3x2(:,57),heltab2x6(:,:,122))
  call Hloop_A_Q(ntryL,G0H2(1),23,nMT,G1H2(44),n2h2(72))
  call Hloop_QZ_A(ntryL,G1H6(83),ex3(:),G1H2(48),ngZu,m3h3x2(:,58),heltab2x6(:,:,123))
  call Hloop_Q_A(ntryL,G1H2(48),23,0,G2H2(79),n2h2(73))
call HGT_OLR(G1H6(84),1,1,6)
call HGT_invQ_OLR(G1H6(84),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(84),-8,0,G2H6(13),n2h6(56))
  call Hloop_AV_Q(ntryL,G2H6(13),ex4(:),G2H3(45),m3h2x3(:,66),heltab2x6(:,:,124))
  call Hloop_QZ_A(ntryL,G1H6(86),ex3(:),G1H2(54),ngZu,m3h3x2(:,59),heltab2x6(:,:,125))
  call Hloop_Q_A(ntryL,G1H2(54),23,0,G2H2(80),n2h2(74))
  call Hloop_QZ_A(ntryL,G1H6(87),ex3(:),G1H2(55),ngZu,m3h3x2(:,60),heltab2x6(:,:,126))
  call Hloop_Q_A(ntryL,G1H2(55),23,0,G2H2(81),n2h2(75))
  call Hloop_QZ_A(ntryL,G0H6(13),ex3(:),G0H2(1),ngZu,m3h3x2(:,61),heltab2x6(:,:,127))
  call Hloop_Q_A(ntryL,G0H2(1),23,0,G1H2(59),n2h2(76))
  call Hloop_QZ_A(ntryL,G1H6(88),ex3(:),G1H2(60),ngZu,m3h3x2(:,62),heltab2x6(:,:,128))
  call Hloop_Q_A(ntryL,G1H2(60),23,nMT,G2H2(82),n2h2(77))
call HGT_OLR(G1H6(89),1,1,6)
call HGT_invQ_OLR(G1H6(89),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(89),-8,nMT,G2H6(14),n2h6(57))
  call Hloop_AV_Q(ntryL,G2H6(14),ex4(:),G2H3(46),m3h2x3(:,67),heltab2x6(:,:,129))
  call Hloop_QZ_A(ntryL,G1H6(91),ex3(:),G1H2(65),ngZu,m3h3x2(:,63),heltab2x6(:,:,130))
  call Hloop_Q_A(ntryL,G1H2(65),23,nMT,G2H2(83),n2h2(78))
  call Hloop_QZ_A(ntryL,G1H6(92),ex3(:),G1H2(66),ngZu,m3h3x2(:,64),heltab2x6(:,:,131))
  call Hloop_Q_A(ntryL,G1H2(66),23,nMT,G2H2(84),n2h2(79))
  call Hloop_QZ_A(ntryL,G0H6(14),ex3(:),G0H2(1),ngZu,m3h3x2(:,65),heltab2x6(:,:,132))
  call Hloop_Q_A(ntryL,G0H2(1),23,nMT,G1H2(9),n2h2(80))
  call Hloop_AZ_Q(ntryL,G1H6(93),ex3(:),G1H2(20),ngZd,m3h3x2(:,66),heltab2x6(:,:,133))
  call Hloop_A_Q(ntryL,G1H2(20),23,nMB,G2H2(85),n2h2(81))
call HGT_OLR(G1H6(94),1,1,6)
call HGT_invQ_OLR(G1H6(94),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(94),-8,nMB,G2H6(15),n2h6(58))
  call Hloop_QV_A(ntryL,G2H6(15),ex4(:),G2H3(47),m3h2x3(:,68),heltab2x6(:,:,134))
  call Hloop_AZ_Q(ntryL,G1H6(96),ex3(:),G1H2(42),ngZd,m3h3x2(:,67),heltab2x6(:,:,135))
  call Hloop_A_Q(ntryL,G1H2(42),23,nMB,G2H2(86),n2h2(82))
  call Hloop_AZ_Q(ntryL,G1H6(97),ex3(:),G1H2(53),ngZd,m3h3x2(:,68),heltab2x6(:,:,136))
  call Hloop_A_Q(ntryL,G1H2(53),23,nMB,G2H2(87),n2h2(83))
  call Hloop_AZ_Q(ntryL,G0H6(15),ex3(:),G0H2(1),ngZd,m3h3x2(:,69),heltab2x6(:,:,137))
  call Hloop_A_Q(ntryL,G0H2(1),23,nMB,G1H2(64),n2h2(84))
  call Hloop_QZ_A(ntryL,G1H6(98),ex3(:),G1H2(5),ngZd,m3h3x2(:,70),heltab2x6(:,:,138))
  call Hloop_Q_A(ntryL,G1H2(5),23,nMB,G2H2(88),n2h2(85))
call HGT_OLR(G1H6(99),1,1,6)
call HGT_invQ_OLR(G1H6(99),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(99),-8,nMB,G2H6(16),n2h6(59))
  call Hloop_AV_Q(ntryL,G2H6(16),ex4(:),G2H3(48),m3h2x3(:,69),heltab2x6(:,:,139))
  call Hloop_QZ_A(ntryL,G1H6(101),ex3(:),G1H2(11),ngZd,m3h3x2(:,71),heltab2x6(:,:,140))
  call Hloop_Q_A(ntryL,G1H2(11),23,nMB,G2H2(89),n2h2(86))
  call Hloop_QZ_A(ntryL,G1H6(102),ex3(:),G1H2(15),ngZd,m3h3x2(:,72),heltab2x6(:,:,141))
  call Hloop_Q_A(ntryL,G1H2(15),23,nMB,G2H2(90),n2h2(87))
  call Hloop_QZ_A(ntryL,G0H6(16),ex3(:),G0H2(1),ngZd,m3h3x2(:,73),heltab2x6(:,:,142))
  call Hloop_Q_A(ntryL,G0H2(1),23,nMB,G1H2(16),n2h2(88))
  call Hloop_QV_A(ntryL,G1H8(1),wf4(:,10),G1H2(21),m3h4x2(:,1),heltab2x8(:,:,5))
  call Hloop_Q_A(ntryL,G1H2(21),23,0,G2H2(91),n2h2(89))
call HGT_OLR(G1H8(2),1,1,8)
call HGT_invQ_OLR(G1H8(2),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(2),-8,0,G2H8(1),n2h8(13))
  call Hloop_AV_Q(ntryL,G2H8(1),ex4(:),G2H4(13),m3h2x4(:,5),heltab2x8(:,:,6))
  call Hloop_QV_A(ntryL,G1H8(4),wf4(:,10),G1H2(22),m3h4x2(:,2),heltab2x8(:,:,7))
  call Hloop_Q_A(ntryL,G1H2(22),23,0,G2H2(92),n2h2(90))
  call Hloop_QV_A(ntryL,G1H8(5),wf4(:,10),G1H2(26),m3h4x2(:,3),heltab2x8(:,:,8))
  call Hloop_Q_A(ntryL,G1H2(26),23,0,G2H2(93),n2h2(91))
  call Hloop_QV_A(ntryL,G0H8(1),wf4(:,10),G0H2(1),m3h4x2(:,4),heltab2x8(:,:,9))
  call Hloop_Q_A(ntryL,G0H2(1),23,0,G1H2(27),n2h2(92))
  call Hloop_QV_A(ntryL,G1H8(6),wf4(:,10),G1H2(32),m3h4x2(:,5),heltab2x8(:,:,10))
  call Hloop_Q_A(ntryL,G1H2(32),23,nMT,G2H2(94),n2h2(93))
call HGT_OLR(G1H8(7),1,1,8)
call HGT_invQ_OLR(G1H8(7),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(7),-8,nMT,G2H8(3),n2h8(14))
  call Hloop_AV_Q(ntryL,G2H8(3),ex4(:),G2H4(14),m3h2x4(:,6),heltab2x8(:,:,11))
  call Hloop_QV_A(ntryL,G1H8(9),wf4(:,10),G1H2(37),m3h4x2(:,6),heltab2x8(:,:,12))
  call Hloop_Q_A(ntryL,G1H2(37),23,nMT,G2H2(95),n2h2(94))
  call Hloop_QV_A(ntryL,G1H8(10),wf4(:,10),G1H2(38),m3h4x2(:,7),heltab2x8(:,:,13))
  call Hloop_Q_A(ntryL,G1H2(38),23,nMT,G2H2(96),n2h2(95))
  call Hloop_QV_A(ntryL,G0H8(2),wf4(:,10),G0H2(1),m3h4x2(:,8),heltab2x8(:,:,14))
  call Hloop_Q_A(ntryL,G0H2(1),23,nMT,G1H2(43),n2h2(96))
  call Hloop_AV_Q(ntryL,G1H8(11),wf4(:,10),G1H2(48),m3h4x2(:,9),heltab2x8(:,:,15))
  call Hloop_A_Q(ntryL,G1H2(48),23,0,G2H2(97),n2h2(97))
call HGT_OLR(G1H8(12),1,1,8)
call HGT_invQ_OLR(G1H8(12),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(12),-8,0,G2H8(5),n2h8(15))
  call Hloop_QV_A(ntryL,G2H8(5),ex4(:),G2H4(1),m3h2x4(:,7),heltab2x8(:,:,16))
  call Hloop_AV_Q(ntryL,G1H8(14),wf4(:,10),G1H2(54),m3h4x2(:,10),heltab2x8(:,:,17))
  call Hloop_A_Q(ntryL,G1H2(54),23,0,G2H2(98),n2h2(98))
  call Hloop_AV_Q(ntryL,G1H8(15),wf4(:,10),G1H2(55),m3h4x2(:,11),heltab2x8(:,:,18))
  call Hloop_A_Q(ntryL,G1H2(55),23,0,G2H2(99),n2h2(99))
  call Hloop_AV_Q(ntryL,G0H8(3),wf4(:,10),G0H2(1),m3h4x2(:,12),heltab2x8(:,:,19))
  call Hloop_A_Q(ntryL,G0H2(1),23,0,G1H2(60),n2h2(100))
  call Hloop_AV_Q(ntryL,G1H8(16),wf4(:,10),G1H2(65),m3h4x2(:,13),heltab2x8(:,:,20))
  call Hloop_A_Q(ntryL,G1H2(65),23,nMT,G2H2(100),n2h2(101))
call HGT_OLR(G1H8(17),1,1,8)
call HGT_invQ_OLR(G1H8(17),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(17),-8,nMT,G2H8(2),n2h8(16))
  call Hloop_QV_A(ntryL,G2H8(2),ex4(:),G2H4(2),m3h2x4(:,8),heltab2x8(:,:,21))
  call Hloop_AV_Q(ntryL,G1H8(19),wf4(:,10),G1H2(66),m3h4x2(:,14),heltab2x8(:,:,22))
  call Hloop_A_Q(ntryL,G1H2(66),23,nMT,G2H2(101),n2h2(102))
  call Hloop_AV_Q(ntryL,G1H8(20),wf4(:,10),G1H2(20),m3h4x2(:,15),heltab2x8(:,:,23))
  call Hloop_A_Q(ntryL,G1H2(20),23,nMT,G2H2(102),n2h2(103))
  call Hloop_AV_Q(ntryL,G0H8(4),wf4(:,10),G0H2(1),m3h4x2(:,16),heltab2x8(:,:,24))
  call Hloop_A_Q(ntryL,G0H2(1),23,nMT,G1H2(42),n2h2(104))
  call Hloop_QV_A(ntryL,G1H8(21),wf4(:,10),G1H2(53),m3h4x2(:,17),heltab2x8(:,:,25))
  call Hloop_Q_A(ntryL,G1H2(53),23,nMB,G2H2(103),n2h2(105))
call HGT_OLR(G1H8(22),1,1,8)
call HGT_invQ_OLR(G1H8(22),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(22),-8,nMB,G2H8(7),n2h8(17))
  call Hloop_AV_Q(ntryL,G2H8(7),ex4(:),G2H4(4),m3h2x4(:,9),heltab2x8(:,:,26))
  call Hloop_QV_A(ntryL,G1H8(24),wf4(:,10),G1H2(5),m3h4x2(:,18),heltab2x8(:,:,27))
  call Hloop_Q_A(ntryL,G1H2(5),23,nMB,G2H2(104),n2h2(106))
  call Hloop_QV_A(ntryL,G1H8(25),wf4(:,10),G1H2(11),m3h4x2(:,19),heltab2x8(:,:,28))
  call Hloop_Q_A(ntryL,G1H2(11),23,nMB,G2H2(105),n2h2(107))
  call Hloop_QV_A(ntryL,G0H8(5),wf4(:,10),G0H2(1),m3h4x2(:,20),heltab2x8(:,:,29))
  call Hloop_Q_A(ntryL,G0H2(1),23,nMB,G1H2(15),n2h2(108))
  call Hloop_AV_Q(ntryL,G1H8(26),wf4(:,10),G1H2(21),m3h4x2(:,21),heltab2x8(:,:,30))
  call Hloop_A_Q(ntryL,G1H2(21),23,nMB,G2H2(106),n2h2(109))
call HGT_OLR(G1H8(27),1,1,8)
call HGT_invQ_OLR(G1H8(27),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(27),-8,nMB,G2H8(4),n2h8(18))
  call Hloop_QV_A(ntryL,G2H8(4),ex4(:),G2H4(8),m3h2x4(:,10),heltab2x8(:,:,31))
  call Hloop_AV_Q(ntryL,G1H8(29),wf4(:,10),G1H2(22),m3h4x2(:,22),heltab2x8(:,:,32))
  call Hloop_A_Q(ntryL,G1H2(22),23,nMB,G2H2(107),n2h2(110))
  call Hloop_AV_Q(ntryL,G1H8(30),wf4(:,10),G1H2(26),m3h4x2(:,23),heltab2x8(:,:,33))
  call Hloop_A_Q(ntryL,G1H2(26),23,nMB,G2H2(108),n2h2(111))
  call Hloop_AV_Q(ntryL,G0H8(6),wf4(:,10),G0H2(1),m3h4x2(:,24),heltab2x8(:,:,34))
  call Hloop_A_Q(ntryL,G0H2(1),23,nMB,G1H2(32),n2h2(112))
  call Hloop_AV_Q(ntryL,G1H12(22),ex4(:),G1H6(33),m3h2x6(:,25),heltab2x12(:,:,46))
  call Hloop_A_Q(ntryL,G1H6(33),26,0,G2H6(17),n2h6(60))
call HGT_raise_alpha_OLR(G1H12(23),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(23),2,5,12)
  call Hloop_VQ_A(ntryL,G1H12(23),wf6(:,2),G1H2(37),m3h6x2(:,5),heltab2x12(:,:,47))
  call Hloop_AV_Q(ntryL,G1H12(2),ex4(:),G1H6(34),m3h2x6(:,26),heltab2x12(:,:,48))
  call Hloop_A_Q(ntryL,G1H6(34),26,0,G2H6(19),n2h6(61))
  call Hloop_AV_Q(ntryL,G1H12(10),ex4(:),G1H6(37),m3h2x6(:,27),heltab2x12(:,:,49))
  call Hloop_A_Q(ntryL,G1H6(37),26,0,G2H6(21),n2h6(62))
  call Hloop_QV_A(ntryL,G1H12(1),ex4(:),G1H6(38),m3h2x6(:,28),heltab2x12(:,:,50))
  call Hloop_Q_A(ntryL,G1H6(38),25,0,G2H6(8),n2h6(63))
call HGT_raise_alpha_OLR(G1H12(7),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(7),2,5,12)
  call Hloop_VA_Q(ntryL,G1H12(7),wf6(:,4),G1H2(38),m3h6x2(:,6),heltab2x12(:,:,51))
  call Hloop_QV_A(ntryL,G1H12(21),ex4(:),G1H6(40),m3h2x6(:,29),heltab2x12(:,:,52))
  call Hloop_Q_A(ntryL,G1H6(40),25,0,G2H6(10),n2h6(64))
  call Hloop_QV_A(ntryL,G1H12(8),ex4(:),G1H6(45),m3h2x6(:,30),heltab2x12(:,:,53))
  call Hloop_Q_A(ntryL,G1H6(45),25,0,G2H6(20),n2h6(65))
  call Hloop_AZ_Q(ntryL,G1H12(5),ex3(:),G1H4(28),ngZd,m3h3x4(:,16),heltab2x12(:,:,54))
  call Hloop_A_Q(ntryL,G1H4(28),22,0,G2H4(9),n2h4(25))
call HGT_raise_alpha_OLR(G1H12(12),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(12),2,5,12)
  call Hloop_VQ_A(ntryL,G1H12(12),wf4(:,7),G1H3(44),m3h4x3(:,3),heltab2x12(:,:,55))
  call Hloop_AZ_Q(ntryL,G1H12(17),ex3(:),G1H4(17),ngZd,m3h3x4(:,17),heltab2x12(:,:,56))
  call Hloop_A_Q(ntryL,G1H4(17),22,0,G2H4(7),n2h4(26))
  call Hloop_AZ_Q(ntryL,G1H12(18),ex3(:),G1H4(18),ngZd,m3h3x4(:,18),heltab2x12(:,:,57))
  call Hloop_A_Q(ntryL,G1H4(18),22,0,G2H4(12),n2h4(27))
  call Hloop_QZ_A(ntryL,G1H12(6),ex3(:),G1H4(1),ngZd,m3h3x4(:,19),heltab2x12(:,:,58))
  call Hloop_Q_A(ntryL,G1H4(1),21,0,G2H4(6),n2h4(28))
call HGT_raise_alpha_OLR(G1H12(3),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(3),2,5,12)
  call Hloop_VA_Q(ntryL,G1H12(3),wf4(:,2),G1H3(31),m3h4x3(:,4),heltab2x12(:,:,59))
  call Hloop_QZ_A(ntryL,G1H12(9),ex3(:),G1H4(5),ngZd,m3h3x4(:,20),heltab2x12(:,:,60))
  call Hloop_Q_A(ntryL,G1H4(5),21,0,G2H4(3),n2h4(29))
  call Hloop_QZ_A(ntryL,G1H12(11),ex3(:),G1H4(7),ngZd,m3h3x4(:,21),heltab2x12(:,:,61))
  call Hloop_Q_A(ntryL,G1H4(7),21,0,G2H4(5),n2h4(30))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(38),[G2H2(2),G1H2(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(40),[G2H2(5),G1H2(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(97),[G2H2(9),G1H2(30)])
call HGT_OLR(G2H3(1),1,1,3)
call HGT_invQ_OLR(G2H3(1),2,5,3)
call HGT_OLR(G2H3(1),6,15,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(1),[G2H3(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(37),[G2H2(12),G1H2(41)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(91),[G2H2(16),G1H2(52)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(10),[G1H2(50)])
call HGT_OLR(G2H2(18),1,1,2)
call HGT_invQ_OLR(G2H2(18),2,5,2)
call HGT_OLR(G2H2(18),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(18),[G2H2(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(12),[G2H3(10),G2H3(3),G1H3(30),G1H3(8)])
call HGT_OLR(G2H3(5),1,1,3)
call HGT_invQ_OLR(G2H3(5),2,5,3)
call HGT_OLR(G2H3(5),6,15,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(5),[G2H3(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(39),[G2H2(20),G1H2(63)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(6),[G1H2(28)])
call HGT_OLR(G2H2(22),1,1,2)
call HGT_invQ_OLR(G2H2(22),2,5,2)
call HGT_OLR(G2H2(22),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(22),[G2H2(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(14),[G2H3(13),G2H3(7),G1H3(41),G1H3(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(4),[G1H2(39)])
call HGT_w2_OLR(G1H2(1),1,1,2)
call HGT_w2_invQ_OLR(G1H2(1),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(4),[G1H2(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(31),[G2H2(26)])
call HGT_w2_OLR(G1H2(2),1,1,2)
call HGT_w2_invQ_OLR(G1H2(2),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(2),[G1H2(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(34),[G2H2(33),G2H2(29),G2H2(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(2),[G1H3(6)])
call HGT_w2_OLR(G1H3(1),1,1,3)
call HGT_w2_invQ_OLR(G1H3(1),2,5,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(2),[G1H3(1)])
call HGT_w2_OLR(G1H3(2),1,1,3)
call HGT_w2_invQ_OLR(G1H3(2),2,5,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(2),[G1H3(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(35),[G1H2(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(1),[G1H2(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(36),[G1H2(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(3),[G1H2(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(7),[G1H2(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(99),[G1H2(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(79),[G2H2(53),G1H2(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(81),[G2H2(55),G1H2(46)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(11),[G1H2(51)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(93),[G1H2(58)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(18),[G1H3(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(20),[G1H3(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(36),[G1H3(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(13),[G1H2(61)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(73),[G2H2(57),G1H2(62)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(75),[G2H2(59),G1H2(68)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(4),[G1H3(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(22),[G1H3(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(24),[G1H3(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(47),[G1H3(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(6),[G1H3(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(8),[G1H3(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(9),[G1H3(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(11),[G1H3(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(63),[G2H2(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(49),[G2H2(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(66),[G2H2(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(52),[G2H2(32)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(59),[G1H2(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(33),[G1H2(4)])
  call Hotf_4pt_reduction(G2H2(38),RedSet_4(18),mass4set(:,1),  & 
G1H2(48),G1H2(54),G1H2(55),G1H2(65),G1H2(66),2)
  call HG1shiftOLR(G1H2(54),8,2)
  call Hotf_4pt_reduction(G2H2(40),RedSet_4(22),mass4set(:,1),  & 
G1H2(20),G1H2(53),G1H2(5),G1H2(11),G1H2(21),2)
  call HG1shiftOLR(G1H2(53),8,2)
call HGT_OLR(G2H2(8),1,1,2)
call HGT_invQ_OLR(G2H2(8),2,5,2)
call HGT_OLR(G2H2(8),6,15,2)
  call Hotf_4pt_reduction(G2H2(8),RedSet_4(49),mass4set(:,1),  & 
G1H2(22),G1H2(26),G1H2(8),G1H2(19),G1H2(30),2)
  call HG1shiftOLR(G1H2(26),2,2)
  call Hotf_4pt_reduction(G2H2(97),RedSet_4(25),mass4set(:,1),  & 
G1H2(41),G1H2(52),G1H2(50),G1H2(63),G1H2(28),2)
  call HG1shiftOLR(G1H2(52),8,2)
  call Hotf_4pt_reduction(G2H3(1),RedSet_4(50),mass4set(:,1),  & 
G1H3(4),G1H3(10),G1H3(11),G1H3(27),G1H3(32),3)
  call HG1shiftOLR(G1H3(10),4,3)
  call Hotf_4pt_reduction(G2H2(37),RedSet_4(18),mass4set(:,1),  & 
G1H2(39),G1H2(1),G1H2(45),G1H2(6),G1H2(7),2)
  call HG1shiftOLR(G1H2(1),8,2)
call HGT_OLR(G2H2(15),1,1,2)
call HGT_invQ_OLR(G2H2(15),2,5,2)
call HGT_OLR(G2H2(15),6,15,2)
  call Hotf_4pt_reduction(G2H2(15),RedSet_4(51),mass4set(:,1),  & 
G1H2(17),G1H2(18),G1H2(29),G1H2(36),G1H2(40),2)
  call HG1shiftOLR(G1H2(18),1,2)
  call Hotf_4pt_reduction(G2H2(91),RedSet_4(25),mass4set(:,1),  & 
G1H2(46),G1H2(51),G1H2(58),G1H2(61),G1H2(62),2)
  call HG1shiftOLR(G1H2(51),8,2)
  call Hotf_4pt_reduction(G2H2(18),RedSet_4(30),mass4set(:,1),  & 
G1H2(68),G1H2(31),G1H2(4),G1H2(70),G1H2(71),2)
  call HG1shiftOLR(G1H2(31),8,2)
  call Hotf_4pt_reduction(G2H3(12),RedSet_4(34),mass4set(:,1),  & 
G1H3(33),G1H3(30),G1H3(8),G1H3(41),G1H3(19),3)
  call HG1shiftOLR(G1H3(30),4,3)
  call Hotf_4pt_reduction(G2H3(5),RedSet_4(52),mass4set(:,1),  & 
G1H3(6),G1H3(1),G1H3(12),G1H3(7),G1H3(13),3)
  call HG1shiftOLR(G1H3(1),4,3)
  call Hotf_4pt_reduction(G2H2(39),RedSet_4(22),mass4set(:,1),  & 
G1H2(72),G1H2(73),G1H2(74),G1H2(75),G1H2(76),2)
  call HG1shiftOLR(G1H2(73),8,2)
  call Hotf_4pt_reduction(G2H2(22),RedSet_4(24),mass4set(:,1),  & 
G1H2(77),G1H2(78),G1H2(79),G1H2(80),G1H2(81),2)
  call HG1shiftOLR(G1H2(78),8,2)
  call Hotf_4pt_reduction(G2H3(14),RedSet_4(39),mass4set(:,1),  & 
G1H3(14),G1H3(17),G1H3(18),G1H3(24),G1H3(25),3)
  call HG1shiftOLR(G1H3(17),4,3)
call HGT_OLR(G2H2(23),1,1,2)
call HGT_invQ_OLR(G2H2(23),2,5,2)
call HGT_OLR(G2H2(23),6,15,2)
  call Hotf_4pt_reduction(G2H2(23),RedSet_4(53),mass4set(:,1),  & 
G1H2(82),G1H2(83),G1H2(84),G1H2(85),G1H2(86),2)
  call HG1shiftOLR(G1H2(83),1,2)
call HGT_OLR(G2H2(24),1,1,2)
call HGT_invQ_OLR(G2H2(24),2,5,2)
call HGT_OLR(G2H2(24),6,15,2)
  call Hotf_4pt_reduction(G2H2(24),RedSet_4(54),mass4set(:,1),  & 
G1H2(87),G1H2(88),G1H2(89),G1H2(90),G1H2(91),2)
  call HG1shiftOLR(G1H2(88),2,2)
  call Hotf_4pt_reduction(G2H2(4),RedSet_4(27),mass4set(:,1),  & 
G1H2(92),G1H2(93),G1H2(94),G1H2(95),G1H2(96),2)
  call HG1shiftOLR(G1H2(93),8,2)
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(31),ex2(:),G2tensor(1),m3h2x1(:,29),heltab2x2(:,:,29))
  call Hloop_QV_A(ntryL,G1H2(2),ex4(:),G1H1(1),m3h2x1(:,30),heltab2x2(:,:,30))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(3),n2h1(37))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(34),ex2(:),G2tensor(5),m3h2x1(:,31),heltab2x2(:,:,31))
call HGT_w2_OLR(G1H2(3),1,1,2)
call HGT_w2_invQ_OLR(G1H2(3),2,5,2)
  call Hloop_QV_A(ntryL,G1H2(3),ex4(:),G1H1(1),m3h2x1(:,32),heltab2x2(:,:,32))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(9),n2h1(38))
  call Hotf_4pt_reduction(G2H3(2),RedSet_4(32),mass4set(:,1),  & 
G1H3(28),G1H3(29),G1H3(39),G1H3(40),G1H3(48),3)
  call HG1shiftOLR(G1H3(29),4,3)
  call Hloop_QZ_A(ntryL,G1H3(2),ex3(:),G1H1(1),ngZd,m3h3x1(:,17),heltab2x3(:,:,17))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(13),n2h1(39))
call HGT_w2_OLR(G1H3(3),1,1,3)
call HGT_w2_invQ_OLR(G1H3(3),2,5,3)
  call Hloop_QZ_A(ntryL,G1H3(3),ex3(:),G1H1(1),ngZd,m3h3x1(:,18),heltab2x3(:,:,18))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(17),n2h1(40))
  call Hotf_4pt_reduction(G2H2(35),RedSet_4(16),mass4set(:,1),  & 
G1H2(2),G1H2(3),G1H2(97),G1H2(98),G1H2(99),2)
  call HG1shiftOLR(G1H2(3),8,2)
  call Hotf_4pt_reduction(G2H2(1),RedSet_4(17),mass4set(:,1),  & 
G1H2(100),G1H2(101),G1H2(102),G1H2(103),G1H2(104),2)
  call HG1shiftOLR(G1H2(101),8,2)
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(12),23,ex4(:),8,G2tensor(21),m3h2x1(:,33),heltab2x2(:,:,33))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(13),23,ex4(:),8,G2tensor(25),m3h2x1(:,34),heltab2x2(:,:,34))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(14),23,ex4(:),8,G2tensor(29),m3h2x1(:,35),heltab2x2(:,:,35))
  call Hotf_4pt_reduction(G2H2(36),RedSet_4(20),mass4set(:,1),  & 
G1H2(12),G1H2(13),G1H2(14),G1H2(105),G1H2(106),2)
  call HG1shiftOLR(G1H2(13),8,2)
  call Hotf_4pt_reduction(G2H2(3),RedSet_4(21),mass4set(:,1),  & 
G1H2(107),G1H2(108),G1H2(109),G1H2(110),G1H2(111),2)
  call HG1shiftOLR(G1H2(108),8,2)
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(23),23,ex4(:),8,G2tensor(33),m3h2x1(:,36),heltab2x2(:,:,36))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(24),23,ex4(:),8,G2tensor(37),m3h2x1(:,37),heltab2x2(:,:,37))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(25),23,ex4(:),8,G2tensor(41),m3h2x1(:,38),heltab2x2(:,:,38))
  call Hotf_4pt_reduction(G2H2(7),RedSet_4(21),mass4set(:,1),  & 
G1H2(23),G1H2(24),G1H2(25),G1H2(112),G1H2(113),2)
  call HG1shiftOLR(G1H2(24),8,2)
  call Hloop_AV_Q(ntryL,G1H2(34),ex4(:),G1H1(1),m3h2x1(:,39),heltab2x2(:,:,39))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(45),n2h1(41))
  call Hloop_AV_Q(ntryL,G1H2(35),ex4(:),G1H1(1),m3h2x1(:,40),heltab2x2(:,:,40))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(46),n2h1(42))
  call Hloop_AV_Q(ntryL,G2H2(99),ex4(:),G2H1(1),m3h2x1(:,41),heltab2x2(:,:,41))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(1),n2h1(43))
  call Hotf_4pt_reduction(G2H2(79),RedSet_4(28),mass4set(:,1),  & 
G1H2(34),G1H2(35),G1H2(114),G1H2(115),G1H2(116),2)
  call HG1shiftOLR(G1H2(35),8,2)
  call Hloop_QV_A(ntryL,G2H2(81),ex4(:),G2H1(1),m3h2x1(:,42),heltab2x2(:,:,42))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(2),n2h1(44))
  call Hloop_QV_A(ntryL,G1H2(47),ex4(:),G1H1(1),m3h2x1(:,43),heltab2x2(:,:,43))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(47),n2h1(45))
  call Hotf_4pt_reduction(G2H2(11),RedSet_4(17),mass4set(:,1),  & 
G1H2(47),G1H2(117),G1H2(118),G1H2(119),G1H2(120),2)
  call HG1shiftOLR(G1H2(117),8,2)
  call Hloop_QV_A(ntryL,G1H2(56),ex4(:),G1H1(1),m3h2x1(:,44),heltab2x2(:,:,44))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(48),n2h1(46))
  call Hloop_QV_A(ntryL,G1H2(57),ex4(:),G1H1(1),m3h2x1(:,45),heltab2x2(:,:,45))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(49),n2h1(47))
  call Hloop_QV_A(ntryL,G2H2(93),ex4(:),G2H1(1),m3h2x1(:,46),heltab2x2(:,:,46))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(3),n2h1(48))
  call Hotf_4pt_reduction(G2H3(18),RedSet_4(33),mass4set(:,1),  & 
G1H3(2),G1H3(3),G1H3(49),G1H3(50),G1H3(51),3)
  call HG1shiftOLR(G1H3(3),4,3)
  call Hloop_QZ_A(ntryL,G2H3(20),ex3(:),G2H1(1),ngZd,m3h3x1(:,19),heltab2x3(:,:,19))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(4),n2h1(49))
  call Hloop_QZ_A(ntryL,G1H3(36),ex3(:),G1H1(1),ngZd,m3h3x1(:,20),heltab2x3(:,:,20))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(50),n2h1(50))
  call Hotf_4pt_reduction(G2H2(13),RedSet_4(36),mass4set(:,1),  & 
G1H2(56),G1H2(57),G1H2(121),G1H2(122),G1H2(123),2)
  call HG1shiftOLR(G1H2(57),8,2)
  call Hotf_4pt_reduction(G2H2(73),RedSet_4(28),mass4set(:,1),  & 
G1H2(124),G1H2(125),G1H2(126),G1H2(127),G1H2(128),2)
  call HG1shiftOLR(G1H2(125),8,2)
  call Hloop_AV_Q(ntryL,G1H2(67),ex4(:),G1H1(1),m3h2x1(:,47),heltab2x2(:,:,47))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(51),n2h1(51))
  call Hloop_AV_Q(ntryL,G2H2(75),ex4(:),G2H1(1),m3h2x1(:,48),heltab2x2(:,:,48))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(5),n2h1(52))
  call Hloop_AV_Q(ntryL,G1H2(69),ex4(:),G1H1(1),m3h2x1(:,49),heltab2x2(:,:,49))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(52),n2h1(53))
  call Hotf_4pt_reduction(G2H3(4),RedSet_4(38),mass4set(:,1),  & 
G1H3(36),G1H3(52),G1H3(53),G1H3(54),G1H3(55),3)
  call HG1shiftOLR(G1H3(52),4,3)
  call Hotf_4pt_reduction(G2H3(22),RedSet_4(33),mass4set(:,1),  & 
G1H3(56),G1H3(57),G1H3(58),G1H3(59),G1H3(60),3)
  call HG1shiftOLR(G1H3(57),4,3)
  call Hloop_AZ_Q(ntryL,G1H3(23),ex3(:),G1H1(1),ngZd,m3h3x1(:,21),heltab2x3(:,:,21))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(53),n2h1(54))
  call Hloop_AZ_Q(ntryL,G2H3(24),ex3(:),G2H1(1),ngZd,m3h3x1(:,22),heltab2x3(:,:,22))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(6),n2h1(55))
  call Hloop_AZ_Q(ntryL,G1H3(47),ex3(:),G1H1(1),ngZd,m3h3x1(:,23),heltab2x3(:,:,23))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(54),n2h1(56))
  call Hotf_4pt_reduction(G2H3(6),RedSet_4(41),mass4set(:,1),  & 
G1H3(23),G1H3(47),G1H3(61),G1H3(62),G1H3(63),3)
  call HG1shiftOLR(G1H3(47),4,3)
  call Hotf_4pt_reduction(G2H3(8),RedSet_4(42),mass4set(:,1),  & 
G1H3(64),G1H3(65),G1H3(66),G1H3(67),G1H3(68),3)
  call HG1shiftOLR(G1H3(65),4,3)
  call Hloop_QZ_A(ntryL,G1H3(34),ex3(:),G1H1(1),ngZd,m3h3x1(:,24),heltab2x3(:,:,24))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(55),n2h1(57))
  call Hloop_QZ_A(ntryL,G1H3(35),ex3(:),G1H1(1),ngZd,m3h3x1(:,25),heltab2x3(:,:,25))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(56),n2h1(58))
  call Hotf_4pt_reduction(G2H3(9),RedSet_4(44),mass4set(:,1),  & 
G1H3(34),G1H3(35),G1H3(69),G1H3(70),G1H3(71),3)
  call HG1shiftOLR(G1H3(35),4,3)
  call Hotf_4pt_reduction(G2H3(11),RedSet_4(45),mass4set(:,1),  & 
G1H3(72),G1H3(73),G1H3(74),G1H3(75),G1H3(76),3)
  call HG1shiftOLR(G1H3(73),4,3)
  call Hloop_AZ_Q(ntryL,G1H3(45),ex3(:),G1H1(1),ngZd,m3h3x1(:,26),heltab2x3(:,:,26))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(57),n2h1(59))
  call Hloop_AZ_Q(ntryL,G1H3(46),ex3(:),G1H1(1),ngZd,m3h3x1(:,27),heltab2x3(:,:,27))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(58),n2h1(60))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(63),ex2(:),G2tensor(59),m3h2x1(:,50),heltab2x2(:,:,50))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(49),ex2(:),G2tensor(60),m3h2x1(:,51),heltab2x2(:,:,51))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(66),ex2(:),G2tensor(61),m3h2x1(:,52),heltab2x2(:,:,52))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(52),ex2(:),G2tensor(62),m3h2x1(:,53),heltab2x2(:,:,53))
  call Hotf_4pt_reduction(G2H6(11),RedSet_4(9),mass4set(:,1),  & 
G1H6(50),G1H6(46),G1H6(51),G1H6(54),G1H6(43),6)
  call HG1shiftOLR(G1H6(46),5,6)
  call Hotf_4pt_reduction(G2H6(7),RedSet_4(3),mass4set(:,1),  & 
G1H6(44),G1H6(4),G1H6(7),G1H6(8),G1H6(9),6)
  call HG1shiftOLR(G1H6(4),6,6)
  call Hotf_4pt_reduction(G2H4(10),RedSet_4(7),mass4set(:,1),  & 
G1H4(16),G1H4(4),G1H4(10),G1H4(15),G1H4(3),4)
  call HG1shiftOLR(G1H4(4),9,4)
  call Hotf_4pt_reduction(G2H4(11),RedSet_4(5),mass4set(:,1),  & 
G1H4(2),G1H4(9),G1H4(6),G1H4(21),G1H4(22),4)
  call HG1shiftOLR(G1H4(9),10,4)
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(41),ex1(:),G2tensor(63),m3h2x1(:,54),heltab2x2(:,:,54))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(43),ex1(:),G2tensor(64),m3h2x1(:,55),heltab2x2(:,:,55))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(44),ex2(:),G2tensor(65),m3h2x1(:,56),heltab2x2(:,:,56))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(46),ex2(:),G2tensor(66),m3h2x1(:,57),heltab2x2(:,:,57))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(47),ex2(:),G2tensor(67),m3h2x1(:,58),heltab2x2(:,:,58))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(50),ex2(:),G2tensor(68),m3h2x1(:,59),heltab2x2(:,:,59))
  call Hloop_QV_A(ntryL,G1H2(59),ex4(:),G1H1(1),m3h2x1(:,60),heltab2x2(:,:,60))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(69),n2h1(61))
  call Hloop_QZ_A(ntryL,G1H3(37),ex3(:),G1H1(1),ngZd,m3h3x1(:,28),heltab2x3(:,:,28))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(70),n2h1(62))
  call Hloop_AV_Q(ntryL,G1H2(33),ex4(:),G1H1(1),m3h2x1(:,61),heltab2x2(:,:,61))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(71),n2h1(63))
  call Hloop_AZ_Q(ntryL,G1H3(9),ex3(:),G1H1(1),ngZd,m3h3x1(:,29),heltab2x3(:,:,29))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(72),n2h1(64))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(61),ex2(:),G2tensor(73),m3h2x1(:,62),heltab2x2(:,:,62))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(64),ex2(:),G2tensor(74),m3h2x1(:,63),heltab2x2(:,:,63))
  call Hotf_4pt_reduction(G2H3(25),RedSet_4(33),mass4set(:,1),  & 
G1H3(45),G1H3(46),G1H3(37),G1H3(9),G1H3(77),3)
  call HG1shiftOLR(G1H3(46),4,3)
  call Hloop_QZ_A(ntryL,G2H3(27),ex3(:),G2H1(1),ngZu,m3h3x1(:,30),heltab2x3(:,:,30))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(7),n2h1(65))
  call Hloop_QZ_A(ntryL,G1H3(5),ex3(:),G1H1(1),ngZu,m3h3x1(:,31),heltab2x3(:,:,31))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(75),n2h1(66))
  call Hotf_4pt_reduction(G2H3(28),RedSet_4(33),mass4set(:,2),  & 
G1H3(5),G1H3(78),G1H3(79),G1H3(80),G1H3(81),3)
  call HG1shiftOLR(G1H3(78),4,3)
  call Hloop_QZ_A(ntryL,G2H3(30),ex3(:),G2H1(1),ngZu,m3h3x1(:,32),heltab2x3(:,:,32))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(8),n2h1(67))
  call Hloop_QZ_A(ntryL,G1H3(16),ex3(:),G1H1(1),ngZu,m3h3x1(:,33),heltab2x3(:,:,33))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(76),n2h1(68))
  call Hotf_4pt_reduction(G2H3(31),RedSet_4(33),mass4set(:,1),  & 
G1H3(16),G1H3(82),G1H3(83),G1H3(84),G1H3(85),3)
  call HG1shiftOLR(G1H3(82),4,3)
  call Hloop_AZ_Q(ntryL,G2H3(33),ex3(:),G2H1(1),ngZu,m3h3x1(:,34),heltab2x3(:,:,34))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(9),n2h1(69))
  call Hloop_AZ_Q(ntryL,G1H3(38),ex3(:),G1H1(1),ngZu,m3h3x1(:,35),heltab2x3(:,:,35))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(77),n2h1(70))
  call Hotf_4pt_reduction(G2H3(34),RedSet_4(33),mass4set(:,2),  & 
G1H3(38),G1H3(86),G1H3(87),G1H3(88),G1H3(89),3)
  call HG1shiftOLR(G1H3(86),4,3)
  call Hloop_AZ_Q(ntryL,G2H3(36),ex3(:),G2H1(1),ngZu,m3h3x1(:,36),heltab2x3(:,:,36))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(10),n2h1(71))
  call Hloop_AZ_Q(ntryL,G1H3(42),ex3(:),G1H1(1),ngZu,m3h3x1(:,37),heltab2x3(:,:,37))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(78),n2h1(72))
  call Hotf_4pt_reduction(G2H3(37),RedSet_4(33),mass4set(:,3),  & 
G1H3(42),G1H3(90),G1H3(91),G1H3(92),G1H3(93),3)
  call HG1shiftOLR(G1H3(90),4,3)
  call Hloop_QZ_A(ntryL,G2H3(39),ex3(:),G2H1(1),ngZd,m3h3x1(:,38),heltab2x3(:,:,38))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(11),n2h1(73))
  call Hloop_QZ_A(ntryL,G1H3(15),ex3(:),G1H1(1),ngZd,m3h3x1(:,39),heltab2x3(:,:,39))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(79),n2h1(74))
  call Hotf_4pt_reduction(G2H3(40),RedSet_4(33),mass4set(:,3),  & 
G1H3(15),G1H3(94),G1H3(95),G1H3(96),G1H3(97),3)
  call HG1shiftOLR(G1H3(94),4,3)
  call Hloop_AZ_Q(ntryL,G2H3(42),ex3(:),G2H1(1),ngZd,m3h3x1(:,40),heltab2x3(:,:,40))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(12),n2h1(75))
  call Hloop_AZ_Q(ntryL,G1H3(43),ex3(:),G1H1(1),ngZd,m3h3x1(:,41),heltab2x3(:,:,41))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(80),n2h1(76))
  call Hotf_4pt_reduction(G2H2(76),RedSet_4(28),mass4set(:,2),  & 
G1H2(67),G1H2(69),G1H2(59),G1H2(33),G1H2(129),2)
  call HG1shiftOLR(G1H2(69),8,2)
  call Hloop_AV_Q(ntryL,G2H2(78),ex4(:),G2H1(1),m3h2x1(:,64),heltab2x2(:,:,64))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(13),n2h1(77))
  call Hloop_AV_Q(ntryL,G1H2(44),ex4(:),G1H1(1),m3h2x1(:,65),heltab2x2(:,:,65))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(81),n2h1(78))
  call Hotf_4pt_reduction(G2H2(82),RedSet_4(28),mass4set(:,2),  & 
G1H2(44),G1H2(130),G1H2(131),G1H2(132),G1H2(133),2)
  call HG1shiftOLR(G1H2(130),8,2)
  call Hloop_QV_A(ntryL,G2H2(84),ex4(:),G2H1(1),m3h2x1(:,66),heltab2x2(:,:,66))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(14),n2h1(79))
  call Hloop_QV_A(ntryL,G1H2(9),ex4(:),G1H1(1),m3h2x1(:,67),heltab2x2(:,:,67))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(82),n2h1(80))
  call Hotf_4pt_reduction(G2H2(85),RedSet_4(28),mass4set(:,3),  & 
G1H2(9),G1H2(134),G1H2(135),G1H2(136),G1H2(137),2)
  call HG1shiftOLR(G1H2(134),8,2)
  call Hloop_AV_Q(ntryL,G2H2(87),ex4(:),G2H1(1),m3h2x1(:,68),heltab2x2(:,:,68))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(15),n2h1(81))
  call Hloop_AV_Q(ntryL,G1H2(64),ex4(:),G1H1(1),m3h2x1(:,69),heltab2x2(:,:,69))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(83),n2h1(82))
  call Hotf_4pt_reduction(G2H2(88),RedSet_4(28),mass4set(:,3),  & 
G1H2(64),G1H2(138),G1H2(139),G1H2(140),G1H2(141),2)
  call HG1shiftOLR(G1H2(138),8,2)
  call Hloop_QV_A(ntryL,G2H2(90),ex4(:),G2H1(1),m3h2x1(:,70),heltab2x2(:,:,70))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(16),n2h1(83))
  call Hloop_QV_A(ntryL,G1H2(16),ex4(:),G1H1(1),m3h2x1(:,71),heltab2x2(:,:,71))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(84),n2h1(84))
  call Hloop_QV_A(ntryL,G1H2(27),ex4(:),G1H1(1),m3h2x1(:,72),heltab2x2(:,:,72))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(85),n2h1(85))
  call Hotf_4pt_reduction(G2H2(94),RedSet_4(25),mass4set(:,2),  & 
G1H2(16),G1H2(27),G1H2(142),G1H2(143),G1H2(144),2)
  call HG1shiftOLR(G1H2(27),8,2)
  call Hloop_QV_A(ntryL,G2H2(96),ex4(:),G2H1(1),m3h2x1(:,73),heltab2x2(:,:,73))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(17),n2h1(86))
  call Hloop_QV_A(ntryL,G1H2(43),ex4(:),G1H1(1),m3h2x1(:,74),heltab2x2(:,:,74))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(86),n2h1(87))
  call Hloop_AV_Q(ntryL,G1H2(60),ex4(:),G1H1(1),m3h2x1(:,75),heltab2x2(:,:,75))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(87),n2h1(88))
  call Hotf_4pt_reduction(G2H2(100),RedSet_4(25),mass4set(:,2),  & 
G1H2(43),G1H2(60),G1H2(145),G1H2(146),G1H2(147),2)
  call HG1shiftOLR(G1H2(60),8,2)
  call Hloop_AV_Q(ntryL,G2H2(102),ex4(:),G2H1(1),m3h2x1(:,76),heltab2x2(:,:,76))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(18),n2h1(89))
  call Hloop_AV_Q(ntryL,G1H2(42),ex4(:),G1H1(1),m3h2x1(:,77),heltab2x2(:,:,77))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(88),n2h1(90))
  call Hotf_4pt_reduction(G2H2(103),RedSet_4(25),mass4set(:,3),  & 
G1H2(42),G1H2(148),G1H2(149),G1H2(150),G1H2(151),2)
  call HG1shiftOLR(G1H2(148),8,2)
  call Hloop_QV_A(ntryL,G2H2(105),ex4(:),G2H1(1),m3h2x1(:,78),heltab2x2(:,:,78))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(19),n2h1(91))
  call Hloop_QV_A(ntryL,G1H2(15),ex4(:),G1H1(1),m3h2x1(:,79),heltab2x2(:,:,79))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(89),n2h1(92))
  call Hotf_4pt_reduction(G2H2(106),RedSet_4(25),mass4set(:,3),  & 
G1H2(15),G1H2(152),G1H2(153),G1H2(154),G1H2(155),2)
  call HG1shiftOLR(G1H2(152),8,2)
  call Hloop_AV_Q(ntryL,G2H2(108),ex4(:),G2H1(1),m3h2x1(:,80),heltab2x2(:,:,80))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(20),n2h1(93))
  call Hloop_AV_Q(ntryL,G1H2(32),ex4(:),G1H1(1),m3h2x1(:,81),heltab2x2(:,:,81))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(90),n2h1(94))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H6(17),wf6(:,2),G2tensor(91),m3h6x1(:,1),heltab2x6(:,:,143))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H6(21),wf6(:,2),G2tensor(92),m3h6x1(:,2),heltab2x6(:,:,144))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H6(8),wf6(:,4),G2tensor(93),m3h6x1(:,3),heltab2x6(:,:,145))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H6(20),wf6(:,4),G2tensor(94),m3h6x1(:,4),heltab2x6(:,:,146))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H4(9),wf4(:,7),G2tensor(95),m3h4x1(:,1),heltab2x4(:,:,43))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H4(12),wf4(:,7),G2tensor(96),m3h4x1(:,2),heltab2x4(:,:,44))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H4(6),wf4(:,2),G2tensor(97),m3h4x1(:,3),heltab2x4(:,:,45))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H4(5),wf4(:,2),G2tensor(98),m3h4x1(:,4),heltab2x4(:,:,46))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(48),23,ex4(:),8,G2tensor(99),m3h2x1(:,82),heltab2x2(:,:,82))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(54),0,ex4(:),8,G2tensor(100),m3h2x1(:,83),heltab2x2(:,:,83))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(66),23,ex4(:),8,G2tensor(101),m3h2x1(:,84),heltab2x2(:,:,84))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(20),23,ex4(:),8,G2tensor(102),m3h2x1(:,85),heltab2x2(:,:,85))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(53),0,ex4(:),8,G2tensor(103),m3h2x1(:,86),heltab2x2(:,:,86))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(21),23,ex4(:),8,G2tensor(104),m3h2x1(:,87),heltab2x2(:,:,87))
  call Hloop_VA_Q(ntryL,G1H2(22),ex2(:),G1H1(1),m3h2x1(:,88),heltab2x2(:,:,88))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(105),n2h1(97))
  call Hloop_VA_Q(ntryL,G1H2(26),ex2(:),G1H1(1),m3h2x1(:,89),heltab2x2(:,:,89))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(106),n2h1(98))
  call Hloop_VA_Q(ntryL,G1H2(30),ex2(:),G1H1(1),m3h2x1(:,90),heltab2x2(:,:,90))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(107),n2h1(99))
  call Hloop_AV_Q(ntryL,G1H2(41),ex4(:),G1H1(1),m3h2x1(:,91),heltab2x2(:,:,91))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(108),n2h1(100))
  call Hloop_AV_Q(ntryL,G1H2(52),ex4(:),G1H1(1),m3h2x1(:,92),heltab2x2(:,:,92))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(109),n2h1(101))
  call Hloop_AV_Q(ntryL,G1H2(28),ex4(:),G1H1(1),m3h2x1(:,93),heltab2x2(:,:,93))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(110),n2h1(102))
  call Hloop_QZ_A(ntryL,G1H3(4),ex3(:),G1H1(1),ngZd,m3h3x1(:,42),heltab2x3(:,:,42))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(111),n2h1(103))
  call Hloop_QZ_A(ntryL,G1H3(10),ex3(:),G1H1(1),ngZd,m3h3x1(:,43),heltab2x3(:,:,43))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(112),n2h1(104))
  call Hloop_QZ_A(ntryL,G1H3(32),ex3(:),G1H1(1),ngZd,m3h3x1(:,44),heltab2x3(:,:,44))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(113),n2h1(105))
  call Hloop_QV_A(ntryL,G1H2(39),ex4(:),G1H1(1),m3h2x1(:,94),heltab2x2(:,:,94))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(114),n2h1(106))
  call Hloop_QV_A(ntryL,G1H2(1),ex4(:),G1H1(1),m3h2x1(:,95),heltab2x2(:,:,95))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(115),n2h1(107))
  call Hloop_QV_A(ntryL,G1H2(7),ex4(:),G1H1(1),m3h2x1(:,96),heltab2x2(:,:,96))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(116),n2h1(108))
  call Hloop_VQ_A(ntryL,G1H2(17),ex1(:),G1H1(1),m3h2x1(:,97),heltab2x2(:,:,97))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(117),n2h1(109))
  call Hloop_VQ_A(ntryL,G1H2(18),ex1(:),G1H1(1),m3h2x1(:,98),heltab2x2(:,:,98))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),1,0,G2tensor(118),n2h1(110))
  call Hloop_VQ_A(ntryL,G1H2(40),ex1(:),G1H1(1),m3h2x1(:,99),heltab2x2(:,:,99))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(119),n2h1(111))
  call Hloop_QV_A(ntryL,G1H2(46),ex4(:),G1H1(1),m3h2x1(:,100),heltab2x2(:,:,100))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(120),n2h1(112))
  call Hloop_QV_A(ntryL,G1H2(51),ex4(:),G1H1(1),m3h2x1(:,101),heltab2x2(:,:,101))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(121),n2h1(113))
  call Hloop_QV_A(ntryL,G1H2(62),ex4(:),G1H1(1),m3h2x1(:,102),heltab2x2(:,:,102))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(122),n2h1(114))
  call Hloop_QV_A(ntryL,G1H2(68),ex4(:),G1H1(1),m3h2x1(:,103),heltab2x2(:,:,103))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(123),n2h1(115))
  call Hloop_QV_A(ntryL,G1H2(31),ex4(:),G1H1(1),m3h2x1(:,104),heltab2x2(:,:,104))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(124),n2h1(116))
  call Hloop_QV_A(ntryL,G1H2(71),ex4(:),G1H1(1),m3h2x1(:,105),heltab2x2(:,:,105))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(125),n2h1(117))
  call Hloop_QZ_A(ntryL,G1H3(33),ex3(:),G1H1(1),ngZd,m3h3x1(:,45),heltab2x3(:,:,45))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(126),n2h1(118))
  call Hloop_QZ_A(ntryL,G1H3(30),ex3(:),G1H1(1),ngZd,m3h3x1(:,46),heltab2x3(:,:,46))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(127),n2h1(119))
  call Hloop_QZ_A(ntryL,G1H3(19),ex3(:),G1H1(1),ngZd,m3h3x1(:,47),heltab2x3(:,:,47))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(128),n2h1(120))
  call Hloop_AZ_Q(ntryL,G1H3(6),ex3(:),G1H1(1),ngZd,m3h3x1(:,48),heltab2x3(:,:,48))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(129),n2h1(121))
  call Hloop_AZ_Q(ntryL,G1H3(1),ex3(:),G1H1(1),ngZd,m3h3x1(:,49),heltab2x3(:,:,49))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(130),n2h1(122))
  call Hloop_AZ_Q(ntryL,G1H3(13),ex3(:),G1H1(1),ngZd,m3h3x1(:,50),heltab2x3(:,:,50))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(131),n2h1(123))
  call Hloop_AV_Q(ntryL,G1H2(72),ex4(:),G1H1(1),m3h2x1(:,106),heltab2x2(:,:,106))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(132),n2h1(124))
  call Hloop_AV_Q(ntryL,G1H2(73),ex4(:),G1H1(1),m3h2x1(:,107),heltab2x2(:,:,107))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(133),n2h1(125))
  call Hloop_AV_Q(ntryL,G1H2(76),ex4(:),G1H1(1),m3h2x1(:,108),heltab2x2(:,:,108))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(134),n2h1(126))
  call Hloop_AV_Q(ntryL,G1H2(77),ex4(:),G1H1(1),m3h2x1(:,109),heltab2x2(:,:,109))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(135),n2h1(127))
  call Hloop_AV_Q(ntryL,G1H2(78),ex4(:),G1H1(1),m3h2x1(:,110),heltab2x2(:,:,110))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(136),n2h1(128))
  call Hloop_AV_Q(ntryL,G1H2(81),ex4(:),G1H1(1),m3h2x1(:,111),heltab2x2(:,:,111))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(137),n2h1(129))
  call Hloop_AZ_Q(ntryL,G1H3(14),ex3(:),G1H1(1),ngZd,m3h3x1(:,51),heltab2x3(:,:,51))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(138),n2h1(130))
  call Hloop_AZ_Q(ntryL,G1H3(17),ex3(:),G1H1(1),ngZd,m3h3x1(:,52),heltab2x3(:,:,52))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(139),n2h1(131))
  call Hloop_AZ_Q(ntryL,G1H3(25),ex3(:),G1H1(1),ngZd,m3h3x1(:,53),heltab2x3(:,:,53))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(140),n2h1(132))
  call Hloop_VQ_A(ntryL,G1H2(82),ex1(:),G1H1(1),m3h2x1(:,112),heltab2x2(:,:,112))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(141),n2h1(133))
  call Hloop_VQ_A(ntryL,G1H2(83),ex1(:),G1H1(1),m3h2x1(:,113),heltab2x2(:,:,113))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),1,0,G2tensor(142),n2h1(134))
  call Hloop_VQ_A(ntryL,G1H2(86),ex1(:),G1H1(1),m3h2x1(:,114),heltab2x2(:,:,114))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(143),n2h1(135))
  call Hloop_VA_Q(ntryL,G1H2(87),ex2(:),G1H1(1),m3h2x1(:,115),heltab2x2(:,:,115))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(144),n2h1(136))
  call Hloop_VA_Q(ntryL,G1H2(88),ex2(:),G1H1(1),m3h2x1(:,116),heltab2x2(:,:,116))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(145),n2h1(137))
  call Hloop_VA_Q(ntryL,G1H2(91),ex2(:),G1H1(1),m3h2x1(:,117),heltab2x2(:,:,117))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(146),n2h1(138))
  call Hloop_QV_A(ntryL,G1H2(92),ex4(:),G1H1(1),m3h2x1(:,118),heltab2x2(:,:,118))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(147),n2h1(139))
  call Hloop_QV_A(ntryL,G1H2(93),ex4(:),G1H1(1),m3h2x1(:,119),heltab2x2(:,:,119))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(148),n2h1(140))
  call Hloop_QV_A(ntryL,G1H2(96),ex4(:),G1H1(1),m3h2x1(:,120),heltab2x2(:,:,120))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(149),n2h1(141))
  call Hloop_QZ_A(ntryL,G1H3(28),ex3(:),G1H1(1),ngZd,m3h3x1(:,54),heltab2x3(:,:,54))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(150),n2h1(142))
  call Hloop_QZ_A(ntryL,G1H3(29),ex3(:),G1H1(1),ngZd,m3h3x1(:,55),heltab2x3(:,:,55))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(151),n2h1(143))
  call Hloop_QZ_A(ntryL,G1H3(48),ex3(:),G1H1(1),ngZd,m3h3x1(:,56),heltab2x3(:,:,56))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(152),n2h1(144))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(2),23,ex4(:),8,G2tensor(153),m3h2x1(:,121),heltab2x2(:,:,121))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(3),0,ex4(:),8,G2tensor(154),m3h2x1(:,122),heltab2x2(:,:,122))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(99),23,ex4(:),8,G2tensor(155),m3h2x1(:,123),heltab2x2(:,:,123))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(100),23,ex4(:),8,G2tensor(156),m3h2x1(:,124),heltab2x2(:,:,124))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(101),0,ex4(:),8,G2tensor(157),m3h2x1(:,125),heltab2x2(:,:,125))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(104),23,ex4(:),8,G2tensor(158),m3h2x1(:,126),heltab2x2(:,:,126))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(12),23,ex4(:),8,G2tensor(159),m3h2x1(:,127),heltab2x2(:,:,127))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(13),0,ex4(:),8,G2tensor(160),m3h2x1(:,128),heltab2x2(:,:,128))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(106),23,ex4(:),8,G2tensor(161),m3h2x1(:,129),heltab2x2(:,:,129))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(107),23,ex4(:),8,G2tensor(162),m3h2x1(:,130),heltab2x2(:,:,130))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(108),0,ex4(:),8,G2tensor(163),m3h2x1(:,131),heltab2x2(:,:,131))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(111),23,ex4(:),8,G2tensor(164),m3h2x1(:,132),heltab2x2(:,:,132))
  call Hloop_AV_Q(ntryL,G1H2(23),ex4(:),G1H1(1),m3h2x1(:,133),heltab2x2(:,:,133))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(165),n2h1(149))
  call Hloop_AV_Q(ntryL,G1H2(24),ex4(:),G1H1(1),m3h2x1(:,134),heltab2x2(:,:,134))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(166),n2h1(150))
  call Hloop_AV_Q(ntryL,G1H2(113),ex4(:),G1H1(1),m3h2x1(:,135),heltab2x2(:,:,135))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(167),n2h1(151))
  call Hloop_QV_A(ntryL,G1H2(34),ex4(:),G1H1(1),m3h2x1(:,136),heltab2x2(:,:,136))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(168),n2h1(152))
  call Hloop_QV_A(ntryL,G1H2(35),ex4(:),G1H1(1),m3h2x1(:,137),heltab2x2(:,:,137))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(169),n2h1(153))
  call Hloop_QV_A(ntryL,G1H2(116),ex4(:),G1H1(1),m3h2x1(:,138),heltab2x2(:,:,138))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(170),n2h1(154))
  call Hloop_QV_A(ntryL,G1H2(47),ex4(:),G1H1(1),m3h2x1(:,139),heltab2x2(:,:,139))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(171),n2h1(155))
  call Hloop_QV_A(ntryL,G1H2(117),ex4(:),G1H1(1),m3h2x1(:,140),heltab2x2(:,:,140))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(172),n2h1(156))
  call Hloop_QV_A(ntryL,G1H2(120),ex4(:),G1H1(1),m3h2x1(:,141),heltab2x2(:,:,141))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(173),n2h1(157))
  call Hloop_QZ_A(ntryL,G1H3(2),ex3(:),G1H1(1),ngZd,m3h3x1(:,57),heltab2x3(:,:,57))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(174),n2h1(158))
  call Hloop_QZ_A(ntryL,G1H3(3),ex3(:),G1H1(1),ngZd,m3h3x1(:,58),heltab2x3(:,:,58))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(175),n2h1(159))
  call Hloop_QZ_A(ntryL,G1H3(51),ex3(:),G1H1(1),ngZd,m3h3x1(:,59),heltab2x3(:,:,59))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(176),n2h1(160))
  call Hloop_AV_Q(ntryL,G1H2(56),ex4(:),G1H1(1),m3h2x1(:,142),heltab2x2(:,:,142))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(177),n2h1(161))
  call Hloop_AV_Q(ntryL,G1H2(57),ex4(:),G1H1(1),m3h2x1(:,143),heltab2x2(:,:,143))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(178),n2h1(162))
  call Hloop_AV_Q(ntryL,G1H2(123),ex4(:),G1H1(1),m3h2x1(:,144),heltab2x2(:,:,144))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(179),n2h1(163))
  call Hloop_AV_Q(ntryL,G1H2(124),ex4(:),G1H1(1),m3h2x1(:,145),heltab2x2(:,:,145))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(180),n2h1(164))
  call Hloop_AV_Q(ntryL,G1H2(125),ex4(:),G1H1(1),m3h2x1(:,146),heltab2x2(:,:,146))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(181),n2h1(165))
  call Hloop_AV_Q(ntryL,G1H2(128),ex4(:),G1H1(1),m3h2x1(:,147),heltab2x2(:,:,147))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(182),n2h1(166))
  call Hloop_AZ_Q(ntryL,G1H3(36),ex3(:),G1H1(1),ngZd,m3h3x1(:,60),heltab2x3(:,:,60))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(183),n2h1(167))
  call Hloop_AZ_Q(ntryL,G1H3(52),ex3(:),G1H1(1),ngZd,m3h3x1(:,61),heltab2x3(:,:,61))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(184),n2h1(168))
  call Hloop_AZ_Q(ntryL,G1H3(55),ex3(:),G1H1(1),ngZd,m3h3x1(:,62),heltab2x3(:,:,62))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(185),n2h1(169))
  call Hloop_AZ_Q(ntryL,G1H3(56),ex3(:),G1H1(1),ngZd,m3h3x1(:,63),heltab2x3(:,:,63))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(186),n2h1(170))
  call Hloop_AZ_Q(ntryL,G1H3(57),ex3(:),G1H1(1),ngZd,m3h3x1(:,64),heltab2x3(:,:,64))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(187),n2h1(171))
  call Hloop_AZ_Q(ntryL,G1H3(60),ex3(:),G1H1(1),ngZd,m3h3x1(:,65),heltab2x3(:,:,65))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(188),n2h1(172))
  call Hloop_QZ_A(ntryL,G1H3(23),ex3(:),G1H1(1),ngZd,m3h3x1(:,66),heltab2x3(:,:,66))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(189),n2h1(173))
  call Hloop_QZ_A(ntryL,G1H3(47),ex3(:),G1H1(1),ngZd,m3h3x1(:,67),heltab2x3(:,:,67))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(190),n2h1(174))
  call Hloop_QZ_A(ntryL,G1H3(63),ex3(:),G1H1(1),ngZd,m3h3x1(:,68),heltab2x3(:,:,68))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(191),n2h1(175))
  call Hloop_QZ_A(ntryL,G1H3(64),ex3(:),G1H1(1),ngZd,m3h3x1(:,69),heltab2x3(:,:,69))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(192),n2h1(176))
  call Hloop_QZ_A(ntryL,G1H3(65),ex3(:),G1H1(1),ngZd,m3h3x1(:,70),heltab2x3(:,:,70))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(193),n2h1(177))
  call Hloop_QZ_A(ntryL,G1H3(68),ex3(:),G1H1(1),ngZd,m3h3x1(:,71),heltab2x3(:,:,71))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(194),n2h1(178))
  call Hloop_AZ_Q(ntryL,G1H3(34),ex3(:),G1H1(1),ngZd,m3h3x1(:,72),heltab2x3(:,:,72))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(195),n2h1(179))
  call Hloop_AZ_Q(ntryL,G1H3(35),ex3(:),G1H1(1),ngZd,m3h3x1(:,73),heltab2x3(:,:,73))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(196),n2h1(180))
  call Hloop_AZ_Q(ntryL,G1H3(71),ex3(:),G1H1(1),ngZd,m3h3x1(:,74),heltab2x3(:,:,74))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(197),n2h1(181))
  call Hloop_AZ_Q(ntryL,G1H3(72),ex3(:),G1H1(1),ngZd,m3h3x1(:,75),heltab2x3(:,:,75))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(198),n2h1(182))
  call Hloop_AZ_Q(ntryL,G1H3(73),ex3(:),G1H1(1),ngZd,m3h3x1(:,76),heltab2x3(:,:,76))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(199),n2h1(183))
  call Hloop_AZ_Q(ntryL,G1H3(76),ex3(:),G1H1(1),ngZd,m3h3x1(:,77),heltab2x3(:,:,77))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(200),n2h1(184))
  call Hloop_VQ_A(ntryL,G1H6(50),wf6(:,2),G1H1(1),m3h6x1(:,5),heltab2x6(:,:,147))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(201),n2h1(185))
  call Hloop_VQ_A(ntryL,G1H6(46),wf6(:,2),G1H1(1),m3h6x1(:,6),heltab2x6(:,:,148))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),5,0,G2tensor(202),n2h1(186))
  call Hloop_VQ_A(ntryL,G1H6(43),wf6(:,2),G1H1(1),m3h6x1(:,7),heltab2x6(:,:,149))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(203),n2h1(187))
  call Hloop_VA_Q(ntryL,G1H6(44),wf6(:,4),G1H1(1),m3h6x1(:,8),heltab2x6(:,:,150))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(204),n2h1(188))
  call Hloop_VA_Q(ntryL,G1H6(4),wf6(:,4),G1H1(1),m3h6x1(:,9),heltab2x6(:,:,151))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),6,0,G2tensor(205),n2h1(189))
  call Hloop_VA_Q(ntryL,G1H6(9),wf6(:,4),G1H1(1),m3h6x1(:,10),heltab2x6(:,:,152))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(206),n2h1(190))
  call Hloop_VQ_A(ntryL,G1H4(16),wf4(:,7),G1H1(1),m3h4x1(:,5),heltab2x4(:,:,47))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(207),n2h1(191))
  call Hloop_VQ_A(ntryL,G1H4(4),wf4(:,7),G1H1(1),m3h4x1(:,6),heltab2x4(:,:,48))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,0,G2tensor(208),n2h1(192))
  call Hloop_VQ_A(ntryL,G1H4(3),wf4(:,7),G1H1(1),m3h4x1(:,7),heltab2x4(:,:,49))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(209),n2h1(193))
  call Hloop_VA_Q(ntryL,G1H4(2),wf4(:,2),G1H1(1),m3h4x1(:,8),heltab2x4(:,:,50))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(210),n2h1(194))
  call Hloop_VA_Q(ntryL,G1H4(9),wf4(:,2),G1H1(1),m3h4x1(:,9),heltab2x4(:,:,51))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,0,G2tensor(211),n2h1(195))
  call Hloop_VA_Q(ntryL,G1H4(22),wf4(:,2),G1H1(1),m3h4x1(:,10),heltab2x4(:,:,52))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(212),n2h1(196))
  call Hloop_QZ_A(ntryL,G1H3(45),ex3(:),G1H1(1),ngZu,m3h3x1(:,78),heltab2x3(:,:,78))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(213),n2h1(197))
  call Hloop_QZ_A(ntryL,G1H3(46),ex3(:),G1H1(1),ngZu,m3h3x1(:,79),heltab2x3(:,:,79))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(214),n2h1(198))
  call Hloop_QZ_A(ntryL,G1H3(77),ex3(:),G1H1(1),ngZu,m3h3x1(:,80),heltab2x3(:,:,80))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(215),n2h1(199))
  call Hloop_QZ_A(ntryL,G1H3(5),ex3(:),G1H1(1),ngZu,m3h3x1(:,81),heltab2x3(:,:,81))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(216),n2h1(200))
  call Hloop_QZ_A(ntryL,G1H3(78),ex3(:),G1H1(1),ngZu,m3h3x1(:,82),heltab2x3(:,:,82))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(217),n2h1(201))
  call Hloop_QZ_A(ntryL,G1H3(81),ex3(:),G1H1(1),ngZu,m3h3x1(:,83),heltab2x3(:,:,83))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(218),n2h1(202))
  call Hloop_AZ_Q(ntryL,G1H3(16),ex3(:),G1H1(1),ngZu,m3h3x1(:,84),heltab2x3(:,:,84))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(219),n2h1(203))
  call Hloop_AZ_Q(ntryL,G1H3(82),ex3(:),G1H1(1),ngZu,m3h3x1(:,85),heltab2x3(:,:,85))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(220),n2h1(204))
  call Hloop_AZ_Q(ntryL,G1H3(85),ex3(:),G1H1(1),ngZu,m3h3x1(:,86),heltab2x3(:,:,86))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(221),n2h1(205))
  call Hloop_AZ_Q(ntryL,G1H3(38),ex3(:),G1H1(1),ngZu,m3h3x1(:,87),heltab2x3(:,:,87))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(222),n2h1(206))
  call Hloop_AZ_Q(ntryL,G1H3(86),ex3(:),G1H1(1),ngZu,m3h3x1(:,88),heltab2x3(:,:,88))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(223),n2h1(207))
  call Hloop_AZ_Q(ntryL,G1H3(89),ex3(:),G1H1(1),ngZu,m3h3x1(:,89),heltab2x3(:,:,89))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(224),n2h1(208))
  call Hloop_QZ_A(ntryL,G1H3(42),ex3(:),G1H1(1),ngZd,m3h3x1(:,90),heltab2x3(:,:,90))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(225),n2h1(209))
  call Hloop_QZ_A(ntryL,G1H3(90),ex3(:),G1H1(1),ngZd,m3h3x1(:,91),heltab2x3(:,:,91))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(226),n2h1(210))
  call Hloop_QZ_A(ntryL,G1H3(93),ex3(:),G1H1(1),ngZd,m3h3x1(:,92),heltab2x3(:,:,92))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(227),n2h1(211))
  call Hloop_AZ_Q(ntryL,G1H3(15),ex3(:),G1H1(1),ngZd,m3h3x1(:,93),heltab2x3(:,:,93))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(228),n2h1(212))
  call Hloop_AZ_Q(ntryL,G1H3(94),ex3(:),G1H1(1),ngZd,m3h3x1(:,94),heltab2x3(:,:,94))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(229),n2h1(213))
  call Hloop_AZ_Q(ntryL,G1H3(97),ex3(:),G1H1(1),ngZd,m3h3x1(:,95),heltab2x3(:,:,95))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(230),n2h1(214))
  call Hloop_AV_Q(ntryL,G1H2(67),ex4(:),G1H1(1),m3h2x1(:,148),heltab2x2(:,:,148))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(231),n2h1(215))
  call Hloop_AV_Q(ntryL,G1H2(69),ex4(:),G1H1(1),m3h2x1(:,149),heltab2x2(:,:,149))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(232),n2h1(216))
  call Hloop_AV_Q(ntryL,G1H2(129),ex4(:),G1H1(1),m3h2x1(:,150),heltab2x2(:,:,150))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(233),n2h1(217))
  call Hloop_QV_A(ntryL,G1H2(44),ex4(:),G1H1(1),m3h2x1(:,151),heltab2x2(:,:,151))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(234),n2h1(218))
  call Hloop_QV_A(ntryL,G1H2(130),ex4(:),G1H1(1),m3h2x1(:,152),heltab2x2(:,:,152))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(235),n2h1(219))
  call Hloop_QV_A(ntryL,G1H2(133),ex4(:),G1H1(1),m3h2x1(:,153),heltab2x2(:,:,153))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(236),n2h1(220))
  call Hloop_AV_Q(ntryL,G1H2(9),ex4(:),G1H1(1),m3h2x1(:,154),heltab2x2(:,:,154))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(237),n2h1(221))
  call Hloop_AV_Q(ntryL,G1H2(134),ex4(:),G1H1(1),m3h2x1(:,155),heltab2x2(:,:,155))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(238),n2h1(222))
  call Hloop_AV_Q(ntryL,G1H2(137),ex4(:),G1H1(1),m3h2x1(:,156),heltab2x2(:,:,156))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(239),n2h1(223))
  call Hloop_QV_A(ntryL,G1H2(64),ex4(:),G1H1(1),m3h2x1(:,157),heltab2x2(:,:,157))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(240),n2h1(224))
  call Hloop_QV_A(ntryL,G1H2(138),ex4(:),G1H1(1),m3h2x1(:,158),heltab2x2(:,:,158))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(241),n2h1(225))
  call Hloop_QV_A(ntryL,G1H2(141),ex4(:),G1H1(1),m3h2x1(:,159),heltab2x2(:,:,159))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(242),n2h1(226))
  call Hloop_QV_A(ntryL,G1H2(16),ex4(:),G1H1(1),m3h2x1(:,160),heltab2x2(:,:,160))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(243),n2h1(227))
  call Hloop_QV_A(ntryL,G1H2(27),ex4(:),G1H1(1),m3h2x1(:,161),heltab2x2(:,:,161))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(244),n2h1(228))
  call Hloop_QV_A(ntryL,G1H2(144),ex4(:),G1H1(1),m3h2x1(:,162),heltab2x2(:,:,162))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(245),n2h1(229))
  call Hloop_AV_Q(ntryL,G1H2(43),ex4(:),G1H1(1),m3h2x1(:,163),heltab2x2(:,:,163))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(246),n2h1(230))
  call Hloop_AV_Q(ntryL,G1H2(60),ex4(:),G1H1(1),m3h2x1(:,164),heltab2x2(:,:,164))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(247),n2h1(231))
  call Hloop_AV_Q(ntryL,G1H2(147),ex4(:),G1H1(1),m3h2x1(:,165),heltab2x2(:,:,165))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(248),n2h1(232))
  call Hloop_QV_A(ntryL,G1H2(42),ex4(:),G1H1(1),m3h2x1(:,166),heltab2x2(:,:,166))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(249),n2h1(233))
  call Hloop_QV_A(ntryL,G1H2(148),ex4(:),G1H1(1),m3h2x1(:,167),heltab2x2(:,:,167))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(250),n2h1(234))
  call Hloop_QV_A(ntryL,G1H2(151),ex4(:),G1H1(1),m3h2x1(:,168),heltab2x2(:,:,168))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(251),n2h1(235))
  call Hloop_AV_Q(ntryL,G1H2(15),ex4(:),G1H1(1),m3h2x1(:,169),heltab2x2(:,:,169))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(252),n2h1(236))
  call Hloop_AV_Q(ntryL,G1H2(152),ex4(:),G1H1(1),m3h2x1(:,170),heltab2x2(:,:,170))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(253),n2h1(237))
  call Hloop_AV_Q(ntryL,G1H2(155),ex4(:),G1H1(1),m3h2x1(:,171),heltab2x2(:,:,171))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(254),n2h1(238))
  call ol_merge_tensors(G2tensor(97),[G2tensor(11),G2tensor(2),G1tensor(24),G1tensor(6)])
  call ol_merge_tensors(G2tensor(204),[G2tensor(93),G2tensor(43),G2tensor(4),G1tensor(72),G1tensor(12)])
  call ol_merge_tensors(G2tensor(63),[G2tensor(6),G1tensor(14)])
  call ol_merge_tensors(G2tensor(95),[G2tensor(7),G1tensor(18)])
  call ol_merge_tensors(G2tensor(65),[G2tensor(10),G1tensor(20)])
  call ol_merge_tensors(G2tensor(105),[G2tensor(14),G1tensor(26)])
  call ol_merge_tensors(G2tensor(210),[G2tensor(15),G1tensor(30)])
  call ol_merge_tensors(G2tensor(111),[G2tensor(18),G1tensor(32)])
  call ol_merge_tensors(G2tensor(27),[G2tensor(19),G1tensor(48),G1tensor(36)])
  call ol_merge_tensors(G2tensor(117),[G2tensor(22),G1tensor(38)])
  call ol_merge_tensors(G2tensor(207),[G2tensor(23),G1tensor(42)])
  call ol_merge_tensors(G2tensor(123),[G2tensor(26),G1tensor(44),G1tensor(39)])
  call ol_merge_tensors(G2tensor(129),[G2tensor(30),G1tensor(50)])
  call ol_merge_tensors(G2tensor(35),[G2tensor(31),G1tensor(60),G1tensor(54)])
  call ol_merge_tensors(G2tensor(135),[G2tensor(34),G1tensor(56),G1tensor(27)])
  call ol_merge_tensors(G2tensor(141),[G2tensor(38),G1tensor(62)])
  call ol_merge_tensors(G2tensor(201),[G2tensor(91),G2tensor(39),G1tensor(66)])
  call ol_merge_tensors(G2tensor(144),[G2tensor(42),G1tensor(68)])
  call ol_merge_tensors(G2tensor(147),[G1tensor(33),G1tensor(2)])
  call ol_merge_tensors(G2tensor(73),[G1tensor(3)])
  call ol_merge_tensors(G2tensor(67),[G1tensor(4)])
  call ol_merge_tensors(G2tensor(1),[G1tensor(11),G1tensor(5)])
  call ol_merge_tensors(G2tensor(150),[G1tensor(45),G1tensor(8)])
  call ol_merge_tensors(G2tensor(74),[G1tensor(9)])
  call ol_merge_tensors(G2tensor(68),[G1tensor(10)])
  call ol_merge_tensors(G2tensor(153),[G1tensor(15)])
  call ol_merge_tensors(G2tensor(171),[G2tensor(156),G1tensor(40),G1tensor(16)])
  call ol_merge_tensors(G2tensor(114),[G2tensor(99),G1tensor(35),G1tensor(17)])
  call ol_merge_tensors(G2tensor(159),[G1tensor(21)])
  call ol_merge_tensors(G2tensor(165),[G2tensor(162),G1tensor(28),G1tensor(22)])
  call ol_merge_tensors(G2tensor(132),[G2tensor(102),G1tensor(53),G1tensor(23)])
  call ol_merge_tensors(G2tensor(120),[G2tensor(108),G1tensor(41),G1tensor(29)])
  call ol_merge_tensors(G2tensor(180),[G2tensor(168),G1tensor(52),G1tensor(34)])
  call ol_merge_tensors(G2tensor(219),[G2tensor(213),G2tensor(186),G2tensor(174),G1tensor(58),G1tensor(46)])
  call ol_merge_tensors(G2tensor(126),[G1tensor(65),G1tensor(47)])
  call ol_merge_tensors(G2tensor(177),[G1tensor(51)])
  call ol_merge_tensors(G2tensor(183),[G1tensor(57)])
  call ol_merge_tensors(G2tensor(138),[G1tensor(71),G1tensor(59)])
  call ol_merge_tensors(G2tensor(189),[G1tensor(63)])
  call ol_merge_tensors(G2tensor(192),[G1tensor(64)])
  call ol_merge_tensors(G2tensor(195),[G1tensor(69)])
  call ol_merge_tensors(G2tensor(198),[G1tensor(70)])
  call ol_merge_tensors(G2tensor(71),[G2tensor(69)])
  call ol_merge_tensors(G2tensor(77),[G2tensor(75),G2tensor(72),G2tensor(70)])
  call ol_merge_tensors(G2tensor(78),[G2tensor(76)])
  call ol_merge_tensors(G2tensor(80),[G2tensor(79)])
  call ol_merge_tensors(G2tensor(82),[G2tensor(81)])
  call ol_merge_tensors(G2tensor(84),[G2tensor(83)])
  call ol_merge_tensors(G2tensor(87),[G2tensor(85)])
  call ol_merge_tensors(G2tensor(88),[G2tensor(86)])
  call ol_merge_tensors(G2tensor(90),[G2tensor(89)])
  call ol_merge_tensors(G2tensor(222),[G2tensor(216)])
  call ol_merge_tensors(G2tensor(228),[G2tensor(225)])
  call ol_merge_tensors(G2tensor(234),[G2tensor(231)])
  call ol_merge_tensors(G2tensor(240),[G2tensor(237)])
  call ol_merge_tensors(G2tensor(246),[G2tensor(243)])
  call ol_merge_tensors(G2tensor(252),[G2tensor(249)])
  call Hotf_4pt_reduction_last(G2tensor(97),RedSet_4(2),mass4set(:,1),  & 
G1tensor(1),G1tensor(7),G1tensor(13),G1tensor(19),G1tensor(25))
  call G_TensorShift(G1tensor(7),10)
  call Hotf_4pt_reduction_last(G2tensor(204),RedSet_4(3),mass4set(:,1),  & 
G1tensor(31),G1tensor(37),G1tensor(43),G1tensor(49),G1tensor(55))
  call G_TensorShift(G1tensor(37),6)
  call Hotf_4pt_reduction_last(G2tensor(63),RedSet_4(47),mass4set(:,1),  & 
G1tensor(61),G1tensor(67),G1tensor(24),G1tensor(6),G1tensor(72))
  call G_TensorShift(G1tensor(67),1)
  call Hotf_4pt_reduction_last(G2tensor(95),RedSet_4(4),mass4set(:,1),  & 
G1tensor(12),G1tensor(14),G1tensor(18),G1tensor(20),G1tensor(26))
  call G_TensorShift(G1tensor(14),9)
  call Hotf_4pt_reduction_last(G2tensor(65),RedSet_4(48),mass4set(:,1),  & 
G1tensor(30),G1tensor(32),G1tensor(48),G1tensor(36),G1tensor(38))
  call G_TensorShift(G1tensor(32),2)
  call Hotf_4pt_reduction_last(G2tensor(105),RedSet_4(49),mass4set(:,1),  & 
G1tensor(42),G1tensor(44),G1tensor(39),G1tensor(50),G1tensor(60))
  call G_TensorShift(G1tensor(44),2)
  call Hotf_4pt_reduction_last(G2tensor(210),RedSet_4(5),mass4set(:,1),  & 
G1tensor(54),G1tensor(56),G1tensor(27),G1tensor(62),G1tensor(66))
  call G_TensorShift(G1tensor(56),10)
  call Hotf_4pt_reduction_last(G2tensor(111),RedSet_4(50),mass4set(:,1),  & 
G1tensor(68),G1tensor(33),G1tensor(2),G1tensor(3),G1tensor(4))
  call G_TensorShift(G1tensor(33),4)
  call Hotf_4pt_reduction_last(G2tensor(27),RedSet_4(6),mass4set(:,1),  & 
G1tensor(11),G1tensor(5),G1tensor(45),G1tensor(8),G1tensor(9))
  call G_TensorShift(G1tensor(5),12)
  call Hotf_4pt_reduction_last(G2tensor(117),RedSet_4(51),mass4set(:,1),  & 
G1tensor(10),G1tensor(15),G1tensor(40),G1tensor(16),G1tensor(35))
  call G_TensorShift(G1tensor(15),1)
  call Hotf_4pt_reduction_last(G2tensor(207),RedSet_4(7),mass4set(:,1),  & 
G1tensor(17),G1tensor(21),G1tensor(28),G1tensor(22),G1tensor(53))
  call G_TensorShift(G1tensor(21),9)
  call Hotf_4pt_reduction_last(G2tensor(123),RedSet_4(30),mass4set(:,1),  & 
G1tensor(23),G1tensor(41),G1tensor(29),G1tensor(52),G1tensor(34))
  call G_TensorShift(G1tensor(41),8)
  call Hotf_4pt_reduction_last(G2tensor(129),RedSet_4(52),mass4set(:,1),  & 
G1tensor(58),G1tensor(46),G1tensor(65),G1tensor(47),G1tensor(51))
  call G_TensorShift(G1tensor(46),4)
  call Hotf_4pt_reduction_last(G2tensor(35),RedSet_4(8),mass4set(:,1),  & 
G1tensor(57),G1tensor(71),G1tensor(59),G1tensor(63),G1tensor(64))
  call G_TensorShift(G1tensor(71),12)
  call Hotf_4pt_reduction_last(G2tensor(135),RedSet_4(24),mass4set(:,1),  & 
G1tensor(69),G1tensor(70),G1tensor(73),G1tensor(74),G1tensor(75))
  call G_TensorShift(G1tensor(70),8)
  call Hotf_4pt_reduction_last(G2tensor(141),RedSet_4(53),mass4set(:,1),  & 
G1tensor(76),G1tensor(77),G1tensor(78),G1tensor(79),G1tensor(80))
  call G_TensorShift(G1tensor(77),1)
  call Hotf_4pt_reduction_last(G2tensor(201),RedSet_4(9),mass4set(:,1),  & 
G1tensor(81),G1tensor(82),G1tensor(83),G1tensor(84),G1tensor(85))
  call G_TensorShift(G1tensor(82),5)
  call Hotf_4pt_reduction_last(G2tensor(144),RedSet_4(54),mass4set(:,1),  & 
G1tensor(86),G1tensor(87),G1tensor(88),G1tensor(89),G1tensor(90))
  call G_TensorShift(G1tensor(87),2)
  call Hotf_4pt_reduction_last(G2tensor(147),RedSet_4(27),mass4set(:,1),  & 
G1tensor(91),G1tensor(92),G1tensor(93),G1tensor(94),G1tensor(95))
  call G_TensorShift(G1tensor(92),8)
  call Hotf_4pt_reduction_last(G2tensor(73),RedSet_4(10),mass4set(:,1),  & 
G1tensor(96),G1tensor(97),G1tensor(98),G1tensor(99),G1tensor(100))
  call G_TensorShift(G1tensor(97),2)
  call Hotf_4pt_reduction_last(G2tensor(67),RedSet_4(11),mass4set(:,1),  & 
G1tensor(101),G1tensor(102),G1tensor(103),G1tensor(104),G1tensor(105))
  call G_TensorShift(G1tensor(102),2)
  call Hotf_4pt_reduction_last(G2tensor(1),RedSet_4(1),mass4set(:,1),  & 
G1tensor(106),G1tensor(107),G1tensor(108),G1tensor(109),G1tensor(110))
  call G_TensorShift(G1tensor(107),2)
  call Hotf_4pt_reduction_last(G2tensor(150),RedSet_4(32),mass4set(:,1),  & 
G1tensor(111),G1tensor(112),G1tensor(113),G1tensor(114),G1tensor(115))
  call G_TensorShift(G1tensor(112),4)
  call Hotf_4pt_reduction_last(G2tensor(74),RedSet_4(13),mass4set(:,1),  & 
G1tensor(116),G1tensor(117),G1tensor(118),G1tensor(119),G1tensor(120))
  call G_TensorShift(G1tensor(117),2)
  call Hotf_4pt_reduction_last(G2tensor(68),RedSet_4(14),mass4set(:,1),  & 
G1tensor(121),G1tensor(122),G1tensor(123),G1tensor(124),G1tensor(125))
  call G_TensorShift(G1tensor(122),2)
  call Hotf_4pt_reduction_last(G2tensor(153),RedSet_4(16),mass4set(:,1),  & 
G1tensor(126),G1tensor(127),G1tensor(128),G1tensor(129),G1tensor(130))
  call G_TensorShift(G1tensor(127),8)
  call Hotf_4pt_reduction_last(G2tensor(171),RedSet_4(17),mass4set(:,1),  & 
G1tensor(131),G1tensor(132),G1tensor(133),G1tensor(134),G1tensor(135))
  call G_TensorShift(G1tensor(132),8)
  call Hotf_4pt_reduction_last(G2tensor(114),RedSet_4(18),mass4set(:,1),  & 
G1tensor(136),G1tensor(137),G1tensor(138),G1tensor(139),G1tensor(140))
  call G_TensorShift(G1tensor(137),8)
  call Hotf_4pt_reduction_last(G2tensor(159),RedSet_4(20),mass4set(:,1),  & 
G1tensor(141),G1tensor(142),G1tensor(143),G1tensor(144),G1tensor(145))
  call G_TensorShift(G1tensor(142),8)
  call Hotf_4pt_reduction_last(G2tensor(165),RedSet_4(21),mass4set(:,1),  & 
G1tensor(146),G1tensor(147),G1tensor(148),G1tensor(149),G1tensor(150))
  call G_TensorShift(G1tensor(147),8)
  call Hotf_4pt_reduction_last(G2tensor(132),RedSet_4(22),mass4set(:,1),  & 
G1tensor(151),G1tensor(152),G1tensor(153),G1tensor(154),G1tensor(155))
  call G_TensorShift(G1tensor(152),8)
  call Hotf_4pt_reduction_last(G2tensor(120),RedSet_4(25),mass4set(:,1),  & 
G1tensor(156),G1tensor(157),G1tensor(158),G1tensor(159),G1tensor(160))
  call G_TensorShift(G1tensor(157),8)
  call Hotf_4pt_reduction_last(G2tensor(180),RedSet_4(28),mass4set(:,1),  & 
G1tensor(161),G1tensor(162),G1tensor(163),G1tensor(164),G1tensor(165))
  call G_TensorShift(G1tensor(162),8)
  call Hotf_4pt_reduction_last(G2tensor(219),RedSet_4(33),mass4set(:,1),  & 
G1tensor(166),G1tensor(167),G1tensor(168),G1tensor(169),G1tensor(170))
  call G_TensorShift(G1tensor(167),4)
  call Hotf_4pt_reduction_last(G2tensor(126),RedSet_4(34),mass4set(:,1),  & 
G1tensor(171),G1tensor(172),G1tensor(173),G1tensor(174),G1tensor(175))
  call G_TensorShift(G1tensor(172),4)
  call Hotf_4pt_reduction_last(G2tensor(177),RedSet_4(36),mass4set(:,1),  & 
G1tensor(176),G1tensor(177),G1tensor(178),G1tensor(179),G1tensor(180))
  call G_TensorShift(G1tensor(177),8)
  call Hotf_4pt_reduction_last(G2tensor(183),RedSet_4(38),mass4set(:,1),  & 
G1tensor(181),G1tensor(182),G1tensor(183),G1tensor(184),G1tensor(185))
  call G_TensorShift(G1tensor(182),4)
  call Hotf_4pt_reduction_last(G2tensor(138),RedSet_4(39),mass4set(:,1),  & 
G1tensor(186),G1tensor(187),G1tensor(188),G1tensor(189),G1tensor(190))
  call G_TensorShift(G1tensor(187),4)
  call Hotf_4pt_reduction_last(G2tensor(189),RedSet_4(41),mass4set(:,1),  & 
G1tensor(191),G1tensor(192),G1tensor(193),G1tensor(194),G1tensor(195))
  call G_TensorShift(G1tensor(192),4)
  call Hotf_4pt_reduction_last(G2tensor(192),RedSet_4(42),mass4set(:,1),  & 
G1tensor(196),G1tensor(197),G1tensor(198),G1tensor(199),G1tensor(200))
  call G_TensorShift(G1tensor(197),4)
  call Hotf_4pt_reduction_last(G2tensor(195),RedSet_4(44),mass4set(:,1),  & 
G1tensor(201),G1tensor(202),G1tensor(203),G1tensor(204),G1tensor(205))
  call G_TensorShift(G1tensor(202),4)
  call Hotf_4pt_reduction_last(G2tensor(198),RedSet_4(45),mass4set(:,1),  & 
G1tensor(206),G1tensor(207),G1tensor(208),G1tensor(209),G1tensor(210))
  call G_TensorShift(G1tensor(207),4)
  call Hotf_4pt_reduction_last(G2tensor(71),RedSet_4(28),mass4set(:,1),  & 
G1tensor(211),G1tensor(212),G1tensor(213),G1tensor(214),G1tensor(215),G0tensor(1))
  call G_TensorShift(G1tensor(212),8)
  call Hotf_4pt_reduction_last(G2tensor(77),RedSet_4(33),mass4set(:,1),  & 
G1tensor(211),G1tensor(216),G1tensor(217),G1tensor(218),G1tensor(219),G0tensor(2))
  call G_TensorShift(G1tensor(216),4)
  call Hotf_4pt_reduction_last(G2tensor(78),RedSet_4(33),mass4set(:,2),  & 
G1tensor(211),G1tensor(220),G1tensor(221),G1tensor(222),G1tensor(223),G0tensor(3))
  call G_TensorShift(G1tensor(220),4)
  call Hotf_4pt_reduction_last(G2tensor(80),RedSet_4(33),mass4set(:,3),  & 
G1tensor(211),G1tensor(224),G1tensor(225),G1tensor(226),G1tensor(227),G0tensor(4))
  call G_TensorShift(G1tensor(224),4)
  call Hotf_4pt_reduction_last(G2tensor(82),RedSet_4(28),mass4set(:,2),  & 
G1tensor(211),G1tensor(228),G1tensor(229),G1tensor(230),G1tensor(231),G0tensor(5))
  call G_TensorShift(G1tensor(228),8)
  call Hotf_4pt_reduction_last(G2tensor(84),RedSet_4(28),mass4set(:,3),  & 
G1tensor(211),G1tensor(232),G1tensor(233),G1tensor(234),G1tensor(235),G0tensor(6))
  call G_TensorShift(G1tensor(232),8)
  call Hotf_4pt_reduction_last(G2tensor(87),RedSet_4(25),mass4set(:,1),  & 
G1tensor(211),G1tensor(236),G1tensor(237),G1tensor(238),G1tensor(239),G0tensor(7))
  call G_TensorShift(G1tensor(236),8)
  call Hotf_4pt_reduction_last(G2tensor(88),RedSet_4(25),mass4set(:,2),  & 
G1tensor(211),G1tensor(240),G1tensor(241),G1tensor(242),G1tensor(243),G0tensor(8))
  call G_TensorShift(G1tensor(240),8)
  call Hotf_4pt_reduction_last(G2tensor(90),RedSet_4(25),mass4set(:,3),  & 
G1tensor(211),G1tensor(244),G1tensor(245),G1tensor(246),G1tensor(247),G0tensor(9))
  call G_TensorShift(G1tensor(244),8)
  call Hotf_4pt_reduction_last(G2tensor(222),RedSet_4(33),mass4set(:,2),  & 
G1tensor(211),G1tensor(248),G1tensor(249),G1tensor(250),G1tensor(251))
  call G_TensorShift(G1tensor(248),4)
  call Hotf_4pt_reduction_last(G2tensor(228),RedSet_4(33),mass4set(:,3),  & 
G1tensor(252),G1tensor(253),G1tensor(254),G1tensor(255),G1tensor(256))
  call G_TensorShift(G1tensor(253),4)
  call Hotf_4pt_reduction_last(G2tensor(234),RedSet_4(28),mass4set(:,2),  & 
G1tensor(257),G1tensor(258),G1tensor(259),G1tensor(260),G1tensor(261))
  call G_TensorShift(G1tensor(258),8)
  call Hotf_4pt_reduction_last(G2tensor(240),RedSet_4(28),mass4set(:,3),  & 
G1tensor(262),G1tensor(263),G1tensor(264),G1tensor(265),G1tensor(266))
  call G_TensorShift(G1tensor(263),8)
  call Hotf_4pt_reduction_last(G2tensor(246),RedSet_4(25),mass4set(:,2),  & 
G1tensor(267),G1tensor(268),G1tensor(269),G1tensor(270),G1tensor(271))
  call G_TensorShift(G1tensor(268),8)
  call Hotf_4pt_reduction_last(G2tensor(252),RedSet_4(25),mass4set(:,3),  & 
G1tensor(272),G1tensor(273),G1tensor(274),G1tensor(275),G1tensor(276))
  call G_TensorShift(G1tensor(273),8)
  call Hotf_4pt_reduction_last(G1tensor(1),RedSet_4(2),mass4set(:,1),  & 
G0tensor(10),G0tensor(11),G0tensor(12),G0tensor(13),G0tensor(14))
  call Hotf_4pt_reduction_last(G1tensor(31),RedSet_4(3),mass4set(:,1),  & 
G0tensor(15),G0tensor(16),G0tensor(17),G0tensor(18),G0tensor(19))
  call Hotf_4pt_reduction_last(G1tensor(61),RedSet_4(47),mass4set(:,1),  & 
G0tensor(20),G0tensor(21),G0tensor(22),G0tensor(23),G0tensor(24))
  call Hotf_4pt_reduction_last(G1tensor(12),RedSet_4(4),mass4set(:,1),  & 
G0tensor(25),G0tensor(26),G0tensor(27),G0tensor(28),G0tensor(29))
  call Hotf_4pt_reduction_last(G1tensor(30),RedSet_4(48),mass4set(:,1),  & 
G0tensor(30),G0tensor(31),G0tensor(32),G0tensor(33),G0tensor(34))
  call Hotf_4pt_reduction_last(G1tensor(42),RedSet_4(49),mass4set(:,1),  & 
G0tensor(35),G0tensor(36),G0tensor(37),G0tensor(38),G0tensor(39))
  call Hotf_4pt_reduction_last(G1tensor(54),RedSet_4(5),mass4set(:,1),  & 
G0tensor(40),G0tensor(41),G0tensor(42),G0tensor(43),G0tensor(44))
  call Hotf_4pt_reduction_last(G1tensor(68),RedSet_4(50),mass4set(:,1),  & 
G0tensor(45),G0tensor(46),G0tensor(47),G0tensor(48),G0tensor(49))
  call Hotf_4pt_reduction_last(G1tensor(11),RedSet_4(6),mass4set(:,1),  & 
G0tensor(50),G0tensor(51),G0tensor(52),G0tensor(53),G0tensor(54))
  call Hotf_4pt_reduction_last(G1tensor(10),RedSet_4(51),mass4set(:,1),  & 
G0tensor(55),G0tensor(56),G0tensor(57),G0tensor(58),G0tensor(59))
  call Hotf_4pt_reduction_last(G1tensor(17),RedSet_4(7),mass4set(:,1),  & 
G0tensor(60),G0tensor(61),G0tensor(62),G0tensor(63),G0tensor(64))
  call Hotf_4pt_reduction_last(G1tensor(23),RedSet_4(30),mass4set(:,1),  & 
G0tensor(65),G0tensor(66),G0tensor(67),G0tensor(68),G0tensor(69))
  call Hotf_4pt_reduction_last(G1tensor(58),RedSet_4(52),mass4set(:,1),  & 
G0tensor(70),G0tensor(71),G0tensor(72),G0tensor(73),G0tensor(74))
  call Hotf_4pt_reduction_last(G1tensor(57),RedSet_4(8),mass4set(:,1),  & 
G0tensor(75),G0tensor(76),G0tensor(77),G0tensor(78),G0tensor(79))
  call Hotf_4pt_reduction_last(G1tensor(69),RedSet_4(24),mass4set(:,1),  & 
G0tensor(80),G0tensor(81),G0tensor(82),G0tensor(83),G0tensor(84))
  call Hotf_4pt_reduction_last(G1tensor(76),RedSet_4(53),mass4set(:,1),  & 
G0tensor(85),G0tensor(86),G0tensor(87),G0tensor(88),G0tensor(89))
  call Hotf_4pt_reduction_last(G1tensor(81),RedSet_4(9),mass4set(:,1),  & 
G0tensor(90),G0tensor(91),G0tensor(92),G0tensor(93),G0tensor(94))
  call Hotf_4pt_reduction_last(G1tensor(86),RedSet_4(54),mass4set(:,1),  & 
G0tensor(95),G0tensor(96),G0tensor(97),G0tensor(98),G0tensor(99))
  call Hotf_4pt_reduction_last(G1tensor(91),RedSet_4(27),mass4set(:,1),  & 
G0tensor(100),G0tensor(101),G0tensor(102),G0tensor(103),G0tensor(104))
  call Hotf_4pt_reduction_last(G1tensor(96),RedSet_4(10),mass4set(:,1),  & 
G0tensor(105),G0tensor(106),G0tensor(107),G0tensor(108),G0tensor(109))
  call Hotf_4pt_reduction_last(G1tensor(101),RedSet_4(11),mass4set(:,1),  & 
G0tensor(110),G0tensor(111),G0tensor(112),G0tensor(113),G0tensor(114))
  call Hotf_4pt_reduction_last(G1tensor(106),RedSet_4(1),mass4set(:,1),  & 
G0tensor(115),G0tensor(116),G0tensor(117),G0tensor(118),G0tensor(119))
  call Hotf_4pt_reduction_last(G1tensor(111),RedSet_4(32),mass4set(:,1),  & 
G0tensor(120),G0tensor(121),G0tensor(122),G0tensor(123),G0tensor(124))
  call Hotf_4pt_reduction_last(G1tensor(116),RedSet_4(13),mass4set(:,1),  & 
G0tensor(125),G0tensor(126),G0tensor(127),G0tensor(128),G0tensor(129))
  call Hotf_4pt_reduction_last(G1tensor(121),RedSet_4(14),mass4set(:,1),  & 
G0tensor(130),G0tensor(131),G0tensor(132),G0tensor(133),G0tensor(134))
  call Hotf_4pt_reduction_last(G1tensor(126),RedSet_4(16),mass4set(:,1),  & 
G0tensor(135),G0tensor(136),G0tensor(137),G0tensor(138),G0tensor(139))
  call Hotf_4pt_reduction_last(G1tensor(131),RedSet_4(17),mass4set(:,1),  & 
G0tensor(140),G0tensor(141),G0tensor(142),G0tensor(143),G0tensor(144))
  call Hotf_4pt_reduction_last(G1tensor(136),RedSet_4(18),mass4set(:,1),  & 
G0tensor(145),G0tensor(146),G0tensor(147),G0tensor(148),G0tensor(149))
  call Hotf_4pt_reduction_last(G1tensor(141),RedSet_4(20),mass4set(:,1),  & 
G0tensor(150),G0tensor(151),G0tensor(152),G0tensor(153),G0tensor(154))
  call Hotf_4pt_reduction_last(G1tensor(146),RedSet_4(21),mass4set(:,1),  & 
G0tensor(155),G0tensor(156),G0tensor(157),G0tensor(158),G0tensor(159))



end subroutine vamp_1

end module ol_vamp_1_ppzjj_ddxzgg_1_/**/REALKIND
