
module ol_vamp_8_ppzatt_ttxazgg_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_8(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppzatt_ttxazgg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppzatt_ttxazgg_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_ppzatt_ttxazgg_1_/**/DREALKIND
  use ol_tensor_sum_storage_ppzatt_ttxazgg_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_ppzatt_ttxazgg_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_ppzatt_ttxazgg_1_/**/DREALKIND, only: ntryL, p_switch, Hel
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(96)
  type(Hpolcont), intent(in) :: M(3,96)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel
#endif

  ! =============================================
  call Hloop_AV_Q(ntryL,G0H96(1),wf4(:,2),G0H24(16),m3h4x24(:,29),heltab2x96(:,:,229))
  call Hloop_A_Q(ntryL,G0H24(16),48,0,G1H24(31),n2h24(163))
Gcoeff(:)%j = (c(12)*(M(1,:)%j-M(2,:)%j)) * den(73)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(248),h0tab(:,248),[48,3,4,8],[nMB,nMB,nMB,nMB],4,2,wf4(:,2),wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H96(1),wf4(:,2),G0H24(17),m3h4x24(:,30),heltab2x96(:,:,230))
  call Hloop_A_Q(ntryL,G0H24(17),48,nMB,G1H24(32),n2h24(164))
Gcoeff(:)%j = (c(13)*(M(1,:)%j-M(2,:)%j)) * den(73)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(249),h0tab(:,249),[48,3,4,8],[0,0,0,0],4,2,wf4(:,2),wf4(:,14))
  call Hloop_QV_A(ntryL,G0H96(1),wf4(:,2),G0H24(18),m3h4x24(:,31),heltab2x96(:,:,231))
  call Hloop_Q_A(ntryL,G0H24(18),48,0,G1H24(34),n2h24(165))
Gcoeff(:)%j = (c(12)*(M(1,:)%j-M(2,:)%j)) * den(73)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(250),h0tab(:,250),[48,3,4,8],[nMB,nMB,nMB,nMB],4,2,wf4(:,2),wf4(:,14))
  call Hloop_QV_A(ntryL,G0H96(1),wf4(:,2),G0H24(12),m3h4x24(:,32),heltab2x96(:,:,232))
  call Hloop_Q_A(ntryL,G0H24(12),48,nMB,G1H24(35),n2h24(166))
Gcoeff(:)%j = (c(14)*(-M(1,:)%j+M(2,:)%j)) * den(73)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(251),h0tab(:,251),[48,3,8,4],[0,0,0,0],4,2,wf4(:,2),wf4(:,14))
  call Hloop_QV_A(ntryL,G0H96(1),wf4(:,2),G0H24(13),m3h4x24(:,33),heltab2x96(:,:,233))
  call Hloop_Q_A(ntryL,G0H24(13),48,0,G1H24(36),n2h24(167))
Gcoeff(:)%j = (c(13)*(-M(1,:)%j+M(2,:)%j)) * den(73)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(252),h0tab(:,252),[48,3,8,4],[nMT,nMT,nMT,nMT],4,2,wf4(:,2),wf4(:,14))
  call Hloop_QV_A(ntryL,G0H96(1),wf4(:,2),G0H24(14),m3h4x24(:,34),heltab2x96(:,:,234))
  call Hloop_Q_A(ntryL,G0H24(14),48,nMT,G1H24(6),n2h24(168))
Gcoeff(:)%j = (c(14)*(-M(1,:)%j+M(2,:)%j)) * den(73)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(253),h0tab(:,253),[48,3,8,4],[0,0,0,0],4,2,wf4(:,2),wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H96(1),wf4(:,2),G0H24(15),m3h4x24(:,35),heltab2x96(:,:,235))
  call Hloop_A_Q(ntryL,G0H24(15),48,0,G1H24(8),n2h24(169))
Gcoeff(:)%j = (c(13)*(-M(1,:)%j+M(2,:)%j)) * den(73)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(254),h0tab(:,254),[48,3,8,4],[nMT,nMT,nMT,nMT],4,2,wf4(:,2),wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H96(1),wf4(:,2),G0H24(16),m3h4x24(:,36),heltab2x96(:,:,236))
  call Hloop_A_Q(ntryL,G0H24(16),48,nMT,G1H24(9),n2h24(170))
Gcoeff(:)%j = (c(13)*(M(1,:)%j-M(2,:)%j)) * den(73)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(255),h0tab(:,255),[48,3,8,4],[0,0,0,0],4,2,wf4(:,2),wf4(:,14))
  call Hloop_QV_A(ntryL,G0H96(1),wf4(:,2),G0H24(17),m3h4x24(:,37),heltab2x96(:,:,237))
  call Hloop_Q_A(ntryL,G0H24(17),48,0,G1H24(10),n2h24(171))
Gcoeff(:)%j = (c(12)*(M(1,:)%j-M(2,:)%j)) * den(73)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(256),h0tab(:,256),[48,3,8,4],[nMB,nMB,nMB,nMB],4,2,wf4(:,2),wf4(:,14))
  call Hloop_QV_A(ntryL,G0H96(1),wf4(:,2),G0H24(18),m3h4x24(:,38),heltab2x96(:,:,238))
  call Hloop_Q_A(ntryL,G0H24(18),48,nMB,G1H24(11),n2h24(172))
Gcoeff(:)%j = (c(13)*(M(1,:)%j-M(2,:)%j)) * den(73)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(257),h0tab(:,257),[48,3,8,4],[0,0,0,0],4,2,wf4(:,2),wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H96(1),wf4(:,2),G0H24(12),m3h4x24(:,39),heltab2x96(:,:,239))
  call Hloop_A_Q(ntryL,G0H24(12),48,0,G1H24(37),n2h24(173))
Gcoeff(:)%j = (c(12)*(M(1,:)%j-M(2,:)%j)) * den(73)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(258),h0tab(:,258),[48,3,8,4],[nMB,nMB,nMB,nMB],4,2,wf4(:,2),wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H96(1),wf4(:,2),G0H24(13),m3h4x24(:,40),heltab2x96(:,:,240))
  call Hloop_A_Q(ntryL,G0H24(13),48,nMB,G1H24(38),n2h24(174))
Gcoeff(:)%j = (c(14)*(-M(1,:)%j+M(2,:)%j)) * den(73)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(259),h0tab(:,259),[48,4,3,8],[0,0,0,0],4,2,wf4(:,2),wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H96(1),wf4(:,2),G0H24(14),m3h4x24(:,41),heltab2x96(:,:,241))
  call Hloop_A_Q(ntryL,G0H24(14),48,0,G1H24(39),n2h24(175))
Gcoeff(:)%j = (c(13)*(-M(1,:)%j+M(2,:)%j)) * den(73)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(260),h0tab(:,260),[48,4,3,8],[nMT,nMT,nMT,nMT],4,2,wf4(:,2),wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H96(1),wf4(:,2),G0H24(15),m3h4x24(:,42),heltab2x96(:,:,242))
  call Hloop_A_Q(ntryL,G0H24(15),48,nMT,G1H24(40),n2h24(176))
Gcoeff(:)%j = (c(14)*(-M(1,:)%j+M(2,:)%j)) * den(73)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(261),h0tab(:,261),[48,4,3,8],[0,0,0,0],4,2,wf4(:,2),wf4(:,14))
  call Hloop_QV_A(ntryL,G0H96(1),wf4(:,2),G0H24(16),m3h4x24(:,43),heltab2x96(:,:,243))
  call Hloop_Q_A(ntryL,G0H24(16),48,0,G1H24(41),n2h24(177))
Gcoeff(:)%j = (c(13)*(-M(1,:)%j+M(2,:)%j)) * den(73)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(262),h0tab(:,262),[48,4,3,8],[nMT,nMT,nMT,nMT],4,2,wf4(:,2),wf4(:,14))
  call Hloop_QV_A(ntryL,G0H96(1),wf4(:,2),G0H24(17),m3h4x24(:,44),heltab2x96(:,:,244))
  call Hloop_Q_A(ntryL,G0H24(17),48,nMT,G1H24(44),n2h24(178))
Gcoeff(:)%j = (c(13)*(M(1,:)%j-M(2,:)%j)) * den(73)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(263),h0tab(:,263),[48,4,3,8],[0,0,0,0],4,2,wf4(:,2),wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H96(1),wf4(:,2),G0H24(18),m3h4x24(:,45),heltab2x96(:,:,245))
  call Hloop_A_Q(ntryL,G0H24(18),48,0,G1H24(45),n2h24(179))
Gcoeff(:)%j = (c(12)*(M(1,:)%j-M(2,:)%j)) * den(73)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(264),h0tab(:,264),[48,4,3,8],[nMB,nMB,nMB,nMB],4,2,wf4(:,2),wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H96(1),wf4(:,2),G0H24(12),m3h4x24(:,46),heltab2x96(:,:,246))
  call Hloop_A_Q(ntryL,G0H24(12),48,nMB,G1H24(46),n2h24(180))
Gcoeff(:)%j = (c(13)*(M(1,:)%j-M(2,:)%j)) * den(73)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(265),h0tab(:,265),[48,4,3,8],[0,0,0,0],4,2,wf4(:,2),wf4(:,14))
  call Hloop_QV_A(ntryL,G0H96(1),wf4(:,2),G0H24(13),m3h4x24(:,47),heltab2x96(:,:,247))
  call Hloop_Q_A(ntryL,G0H24(13),48,0,G1H24(47),n2h24(181))
Gcoeff(:)%j = (c(12)*(M(1,:)%j-M(2,:)%j)) * den(73)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(266),h0tab(:,266),[48,4,3,8],[nMB,nMB,nMB,nMB],4,2,wf4(:,2),wf4(:,14))
  call Hloop_QV_A(ntryL,G0H96(1),wf4(:,2),G0H24(14),m3h4x24(:,48),heltab2x96(:,:,248))
  call Hloop_Q_A(ntryL,G0H24(14),48,nMB,G1H24(49),n2h24(182))
Gcoeff(:)%j = (c(14)*(-M(1,:)%j+M(2,:)%j)) * den(270)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(267),h0tab(:,267),[32,4,8,19],[0,0,0,0],4,1,wf8(:,23))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,201),heltab2x96(:,:,249))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(1),n2h48(171))
Gcoeff(:)%j = (c(13)*(-M(1,:)%j+M(2,:)%j)) * den(270)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(268),h0tab(:,268),[32,4,8,19],[nMT,nMT,nMT,nMT],4,1,wf8(:,23))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,202),heltab2x96(:,:,250))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(2),n2h48(172))
Gcoeff(:)%j = (c(14)*(-M(1,:)%j+M(2,:)%j)) * den(270)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(269),h0tab(:,269),[32,4,8,19],[0,0,0,0],4,1,wf8(:,23))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,203),heltab2x96(:,:,251))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(3),n2h48(173))
Gcoeff(:)%j = (c(13)*(-M(1,:)%j+M(2,:)%j)) * den(270)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(270),h0tab(:,270),[32,4,8,19],[nMT,nMT,nMT,nMT],4,1,wf8(:,23))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,204),heltab2x96(:,:,252))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(4),n2h48(174))
Gcoeff(:)%j = (c(13)*(M(1,:)%j-M(2,:)%j)) * den(270)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(271),h0tab(:,271),[32,4,8,19],[0,0,0,0],4,1,wf8(:,23))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,205),heltab2x96(:,:,253))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(5),n2h48(175))
Gcoeff(:)%j = (c(12)*(M(1,:)%j-M(2,:)%j)) * den(270)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(272),h0tab(:,272),[32,4,8,19],[nMB,nMB,nMB,nMB],4,1,wf8(:,23))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,206),heltab2x96(:,:,254))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMB,G1H48(6),n2h48(176))
Gcoeff(:)%j = (c(13)*(M(1,:)%j-M(2,:)%j)) * den(270)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(273),h0tab(:,273),[32,4,8,19],[0,0,0,0],4,1,wf8(:,23))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,207),heltab2x96(:,:,255))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(7),n2h48(177))
Gcoeff(:)%j = (c(12)*(M(1,:)%j-M(2,:)%j)) * den(270)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(274),h0tab(:,274),[32,4,8,19],[nMB,nMB,nMB,nMB],4,1,wf8(:,23))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,208),heltab2x96(:,:,256))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMB,G1H48(8),n2h48(178))
Gcoeff(:)%j = (c(14)*(-M(1,:)%j+M(2,:)%j)) * den(270)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(275),h0tab(:,275),[32,8,4,19],[0,0,0,0],4,1,wf8(:,23))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,209),heltab2x96(:,:,257))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(9),n2h48(179))
Gcoeff(:)%j = (c(13)*(-M(1,:)%j+M(2,:)%j)) * den(270)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(276),h0tab(:,276),[32,8,4,19],[nMT,nMT,nMT,nMT],4,1,wf8(:,23))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,210),heltab2x96(:,:,258))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(10),n2h48(180))
Gcoeff(:)%j = (c(14)*(-M(1,:)%j+M(2,:)%j)) * den(270)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(277),h0tab(:,277),[32,8,4,19],[0,0,0,0],4,1,wf8(:,23))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,211),heltab2x96(:,:,259))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(11),n2h48(181))
Gcoeff(:)%j = (c(13)*(-M(1,:)%j+M(2,:)%j)) * den(270)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(278),h0tab(:,278),[32,8,4,19],[nMT,nMT,nMT,nMT],4,1,wf8(:,23))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,212),heltab2x96(:,:,260))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(12),n2h48(182))
Gcoeff(:)%j = (c(13)*(M(1,:)%j-M(2,:)%j)) * den(270)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(279),h0tab(:,279),[32,8,4,19],[0,0,0,0],4,1,wf8(:,23))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,213),heltab2x96(:,:,261))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(13),n2h48(183))
Gcoeff(:)%j = (c(12)*(M(1,:)%j-M(2,:)%j)) * den(270)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(280),h0tab(:,280),[32,8,4,19],[nMB,nMB,nMB,nMB],4,1,wf8(:,23))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,214),heltab2x96(:,:,262))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMB,G1H48(14),n2h48(184))
Gcoeff(:)%j = (c(13)*(M(1,:)%j-M(2,:)%j)) * den(270)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(281),h0tab(:,281),[32,8,4,19],[0,0,0,0],4,1,wf8(:,23))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,215),heltab2x96(:,:,263))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(15),n2h48(185))
Gcoeff(:)%j = (c(12)*(M(1,:)%j-M(2,:)%j)) * den(270)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(282),h0tab(:,282),[32,8,4,19],[nMB,nMB,nMB,nMB],4,1,wf8(:,23))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,216),heltab2x96(:,:,264))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMB,G1H48(16),n2h48(186))
Gcoeff(:)%j = (c(14)*(-M(1,:)%j+M(2,:)%j)) * den(270)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(283),h0tab(:,283),[32,4,19,8],[0,0,0,0],4,1,wf8(:,23))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,217),heltab2x96(:,:,265))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(17),n2h48(187))
Gcoeff(:)%j = (c(13)*(-M(1,:)%j+M(2,:)%j)) * den(270)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(284),h0tab(:,284),[32,4,19,8],[nMT,nMT,nMT,nMT],4,1,wf8(:,23))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,218),heltab2x96(:,:,266))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(18),n2h48(188))
Gcoeff(:)%j = (c(14)*(-M(1,:)%j+M(2,:)%j)) * den(270)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(285),h0tab(:,285),[32,4,19,8],[0,0,0,0],4,1,wf8(:,23))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,219),heltab2x96(:,:,267))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(19),n2h48(189))
Gcoeff(:)%j = (c(13)*(-M(1,:)%j+M(2,:)%j)) * den(270)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(286),h0tab(:,286),[32,4,19,8],[nMT,nMT,nMT,nMT],4,1,wf8(:,23))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,220),heltab2x96(:,:,268))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(20),n2h48(190))
Gcoeff(:)%j = (c(13)*(M(1,:)%j-M(2,:)%j)) * den(270)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(287),h0tab(:,287),[32,4,19,8],[0,0,0,0],4,1,wf8(:,23))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,221),heltab2x96(:,:,269))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(21),n2h48(191))
Gcoeff(:)%j = (c(12)*(M(1,:)%j-M(2,:)%j)) * den(270)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(288),h0tab(:,288),[32,4,19,8],[nMB,nMB,nMB,nMB],4,1,wf8(:,23))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,222),heltab2x96(:,:,270))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMB,G1H48(22),n2h48(192))
Gcoeff(:)%j = (c(13)*(M(1,:)%j-M(2,:)%j)) * den(270)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(289),h0tab(:,289),[32,4,19,8],[0,0,0,0],4,1,wf8(:,23))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,223),heltab2x96(:,:,271))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(23),n2h48(193))
Gcoeff(:)%j = (c(12)*(M(1,:)%j-M(2,:)%j)) * den(270)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(290),h0tab(:,290),[32,4,19,8],[nMB,nMB,nMB,nMB],4,1,wf8(:,23))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,224),heltab2x96(:,:,272))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMB,G1H48(24),n2h48(194))
Gcoeff(:)%j = (c(14)*(M(1,:)%j-M(2,:)%j)) * den(272)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(291),h0tab(:,291),[35,8,4,16],[0,0,0,0],4,1,wf8(:,24))
  call Hloop_QV_A(ntryL,G0H96(1),wf8(:,24),G0H12(1),m3h8x12(:,1),heltab2x96(:,:,273))
  call Hloop_Q_A(ntryL,G0H12(1),35,0,G1H12(236),n2h12(363))
Gcoeff(:)%j = (c(13)*(M(1,:)%j-M(2,:)%j)) * den(272)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(292),h0tab(:,292),[35,8,4,16],[nMT,nMT,nMT,nMT],4,1,wf8(:,24))
  call Hloop_QV_A(ntryL,G0H96(1),wf8(:,24),G0H12(2),m3h8x12(:,2),heltab2x96(:,:,274))
  call Hloop_Q_A(ntryL,G0H12(2),35,nMT,G1H12(239),n2h12(364))
Gcoeff(:)%j = (c(14)*(M(1,:)%j-M(2,:)%j)) * den(272)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(293),h0tab(:,293),[35,8,4,16],[0,0,0,0],4,1,wf8(:,24))
  call Hloop_AV_Q(ntryL,G0H96(1),wf8(:,24),G0H12(3),m3h8x12(:,3),heltab2x96(:,:,275))
  call Hloop_A_Q(ntryL,G0H12(3),35,0,G1H12(240),n2h12(365))
Gcoeff(:)%j = (c(13)*(M(1,:)%j-M(2,:)%j)) * den(272)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(294),h0tab(:,294),[35,8,4,16],[nMT,nMT,nMT,nMT],4,1,wf8(:,24))
  call Hloop_AV_Q(ntryL,G0H96(1),wf8(:,24),G0H12(4),m3h8x12(:,4),heltab2x96(:,:,276))
  call Hloop_A_Q(ntryL,G0H12(4),35,nMT,G1H12(242),n2h12(366))
Gcoeff(:)%j = (c(13)*(-M(1,:)%j+M(2,:)%j)) * den(272)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(295),h0tab(:,295),[35,8,4,16],[0,0,0,0],4,1,wf8(:,24))
  call Hloop_QV_A(ntryL,G0H96(1),wf8(:,24),G0H12(5),m3h8x12(:,5),heltab2x96(:,:,277))
  call Hloop_Q_A(ntryL,G0H12(5),35,0,G1H12(246),n2h12(367))
Gcoeff(:)%j = (c(12)*(-M(1,:)%j+M(2,:)%j)) * den(272)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(296),h0tab(:,296),[35,8,4,16],[nMB,nMB,nMB,nMB],4,1,wf8(:,24))
  call Hloop_QV_A(ntryL,G0H96(1),wf8(:,24),G0H12(6),m3h8x12(:,6),heltab2x96(:,:,278))
  call Hloop_Q_A(ntryL,G0H12(6),35,nMB,G1H12(143),n2h12(368))
Gcoeff(:)%j = (c(13)*(-M(1,:)%j+M(2,:)%j)) * den(272)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(297),h0tab(:,297),[35,8,4,16],[0,0,0,0],4,1,wf8(:,24))
  call Hloop_AV_Q(ntryL,G0H96(1),wf8(:,24),G0H12(7),m3h8x12(:,7),heltab2x96(:,:,279))
  call Hloop_A_Q(ntryL,G0H12(7),35,0,G1H12(144),n2h12(369))
Gcoeff(:)%j = (c(12)*(-M(1,:)%j+M(2,:)%j)) * den(272)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(298),h0tab(:,298),[35,8,4,16],[nMB,nMB,nMB,nMB],4,1,wf8(:,24))
  call Hloop_AV_Q(ntryL,G0H96(1),wf8(:,24),G0H12(8),m3h8x12(:,8),heltab2x96(:,:,280))
  call Hloop_A_Q(ntryL,G0H12(8),35,nMB,G1H12(161),n2h12(370))
Gcoeff(:)%j = (c(14)*(M(1,:)%j-M(2,:)%j)) * den(272)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(299),h0tab(:,299),[35,4,8,16],[0,0,0,0],4,1,wf8(:,24))
  call Hloop_AV_Q(ntryL,G0H96(1),wf8(:,24),G0H12(9),m3h8x12(:,9),heltab2x96(:,:,281))
  call Hloop_A_Q(ntryL,G0H12(9),35,0,G1H12(162),n2h12(371))
Gcoeff(:)%j = (c(13)*(M(1,:)%j-M(2,:)%j)) * den(272)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(300),h0tab(:,300),[35,4,8,16],[nMT,nMT,nMT,nMT],4,1,wf8(:,24))
  call Hloop_AV_Q(ntryL,G0H96(1),wf8(:,24),G0H12(10),m3h8x12(:,10),heltab2x96(:,:,282))
  call Hloop_A_Q(ntryL,G0H12(10),35,nMT,G1H12(180),n2h12(372))
Gcoeff(:)%j = (c(14)*(M(1,:)%j-M(2,:)%j)) * den(272)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(301),h0tab(:,301),[35,4,8,16],[0,0,0,0],4,1,wf8(:,24))
  call Hloop_QV_A(ntryL,G0H96(1),wf8(:,24),G0H12(11),m3h8x12(:,11),heltab2x96(:,:,283))
  call Hloop_Q_A(ntryL,G0H12(11),35,0,G1H12(197),n2h12(373))
Gcoeff(:)%j = (c(13)*(M(1,:)%j-M(2,:)%j)) * den(272)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(302),h0tab(:,302),[35,4,8,16],[nMT,nMT,nMT,nMT],4,1,wf8(:,24))
  call Hloop_QV_A(ntryL,G0H96(1),wf8(:,24),G0H12(12),m3h8x12(:,12),heltab2x96(:,:,284))
  call Hloop_Q_A(ntryL,G0H12(12),35,nMT,G1H12(198),n2h12(374))
Gcoeff(:)%j = (c(13)*(-M(1,:)%j+M(2,:)%j)) * den(272)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(303),h0tab(:,303),[35,4,8,16],[0,0,0,0],4,1,wf8(:,24))
  call Hloop_AV_Q(ntryL,G0H96(1),wf8(:,24),G0H12(13),m3h8x12(:,13),heltab2x96(:,:,285))
  call Hloop_A_Q(ntryL,G0H12(13),35,0,G1H12(215),n2h12(375))
Gcoeff(:)%j = (c(12)*(-M(1,:)%j+M(2,:)%j)) * den(272)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(304),h0tab(:,304),[35,4,8,16],[nMB,nMB,nMB,nMB],4,1,wf8(:,24))
  call Hloop_AV_Q(ntryL,G0H96(1),wf8(:,24),G0H12(14),m3h8x12(:,14),heltab2x96(:,:,286))
  call Hloop_A_Q(ntryL,G0H12(14),35,nMB,G1H12(216),n2h12(376))
Gcoeff(:)%j = (c(13)*(-M(1,:)%j+M(2,:)%j)) * den(272)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(305),h0tab(:,305),[35,4,8,16],[0,0,0,0],4,1,wf8(:,24))
  call Hloop_QV_A(ntryL,G0H96(1),wf8(:,24),G0H12(15),m3h8x12(:,15),heltab2x96(:,:,287))
  call Hloop_Q_A(ntryL,G0H12(15),35,0,G1H12(234),n2h12(377))
Gcoeff(:)%j = (c(12)*(-M(1,:)%j+M(2,:)%j)) * den(272)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(306),h0tab(:,306),[35,4,8,16],[nMB,nMB,nMB,nMB],4,1,wf8(:,24))
  call Hloop_QV_A(ntryL,G0H96(1),wf8(:,24),G0H12(16),m3h8x12(:,16),heltab2x96(:,:,288))
  call Hloop_Q_A(ntryL,G0H12(16),35,nMB,G1H12(7),n2h12(378))
Gcoeff(:)%j = (c(14)*(M(1,:)%j-M(2,:)%j)) * den(272)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(307),h0tab(:,307),[35,4,16,8],[0,0,0,0],4,1,wf8(:,24))
  call Hloop_AV_Q(ntryL,G0H96(1),wf8(:,24),G0H12(1),m3h8x12(:,17),heltab2x96(:,:,289))
  call Hloop_A_Q(ntryL,G0H12(1),35,0,G1H12(8),n2h12(379))
Gcoeff(:)%j = (c(13)*(M(1,:)%j-M(2,:)%j)) * den(272)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(308),h0tab(:,308),[35,4,16,8],[nMT,nMT,nMT,nMT],4,1,wf8(:,24))
  call Hloop_AV_Q(ntryL,G0H96(1),wf8(:,24),G0H12(2),m3h8x12(:,18),heltab2x96(:,:,290))
  call Hloop_A_Q(ntryL,G0H12(2),35,nMT,G1H12(11),n2h12(380))
Gcoeff(:)%j = (c(14)*(M(1,:)%j-M(2,:)%j)) * den(272)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(309),h0tab(:,309),[35,4,16,8],[0,0,0,0],4,1,wf8(:,24))
  call Hloop_QV_A(ntryL,G0H96(1),wf8(:,24),G0H12(3),m3h8x12(:,19),heltab2x96(:,:,291))
  call Hloop_Q_A(ntryL,G0H12(3),35,0,G1H12(75),n2h12(381))
Gcoeff(:)%j = (c(13)*(M(1,:)%j-M(2,:)%j)) * den(272)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(310),h0tab(:,310),[35,4,16,8],[nMT,nMT,nMT,nMT],4,1,wf8(:,24))
  call Hloop_QV_A(ntryL,G0H96(1),wf8(:,24),G0H12(4),m3h8x12(:,20),heltab2x96(:,:,292))
  call Hloop_Q_A(ntryL,G0H12(4),35,nMT,G1H12(76),n2h12(382))
Gcoeff(:)%j = (c(13)*(-M(1,:)%j+M(2,:)%j)) * den(272)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(311),h0tab(:,311),[35,4,16,8],[0,0,0,0],4,1,wf8(:,24))
  call Hloop_AV_Q(ntryL,G0H96(1),wf8(:,24),G0H12(5),m3h8x12(:,21),heltab2x96(:,:,293))
  call Hloop_A_Q(ntryL,G0H12(5),35,0,G1H12(2),n2h12(383))
Gcoeff(:)%j = (c(12)*(-M(1,:)%j+M(2,:)%j)) * den(272)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(312),h0tab(:,312),[35,4,16,8],[nMB,nMB,nMB,nMB],4,1,wf8(:,24))
  call Hloop_AV_Q(ntryL,G0H96(1),wf8(:,24),G0H12(6),m3h8x12(:,22),heltab2x96(:,:,294))
  call Hloop_A_Q(ntryL,G0H12(6),35,nMB,G1H12(4),n2h12(384))
Gcoeff(:)%j = (c(13)*(-M(1,:)%j+M(2,:)%j)) * den(272)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(313),h0tab(:,313),[35,4,16,8],[0,0,0,0],4,1,wf8(:,24))
  call Hloop_QV_A(ntryL,G0H96(1),wf8(:,24),G0H12(7),m3h8x12(:,23),heltab2x96(:,:,295))
  call Hloop_Q_A(ntryL,G0H12(7),35,0,G1H12(77),n2h12(385))
Gcoeff(:)%j = (c(12)*(-M(1,:)%j+M(2,:)%j)) * den(272)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(314),h0tab(:,314),[35,4,16,8],[nMB,nMB,nMB,nMB],4,1,wf8(:,24))
  call Hloop_QV_A(ntryL,G0H96(1),wf8(:,24),G0H12(8),m3h8x12(:,24),heltab2x96(:,:,296))
  call Hloop_Q_A(ntryL,G0H12(8),35,nMB,G1H12(111),n2h12(386))
Gcoeff(:)%j = (c(8)*M(2,:)%j-c(9)*M(3,:)%j) * den(4)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(315),h0tab(:,315),[32,10,5,16],[nMT,0,nMT,nMT],4,2,wf6(:,2),wf4(:,3))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,225),heltab2x96(:,:,297))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(25),n2h48(195))
Gcoeff(:)%j = (-(c(11)*M(2,:)%j)-c(9)*M(3,:)%j) * den(4)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(316),h0tab(:,316),[32,10,5,16],[0,nMT,0,0],4,2,wf6(:,2),wf4(:,3))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(26),m3h2x48(:,226),heltab2x96(:,:,298))
Gcoeff(:)%j = (c(8)*M(1,:)%j-c(9)*M(3,:)%j) * den(4)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(317),h0tab(:,317),[32,5,10,16],[nMT,0,nMT,nMT],4,2,wf4(:,3),wf6(:,2))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,227),heltab2x96(:,:,299))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(27),n2h48(196))
Gcoeff(:)%j = (-(c(11)*M(1,:)%j)-c(9)*M(3,:)%j) * den(4)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(318),h0tab(:,318),[32,5,10,16],[0,nMT,0,0],4,2,wf4(:,3),wf6(:,2))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(28),m3h2x48(:,228),heltab2x96(:,:,300))
Gcoeff(:)%j = (-(c(4)*M(3,:)%j)) * den(4)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(319),h0tab(:,319),[32,5,16,10],[0,nMT,nMT,0],4,2,wf4(:,3),wf6(:,2))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(29),m3h2x48(:,229),heltab2x96(:,:,301))
Gcoeff(:)%j = (c(4)*M(3,:)%j) * den(4)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(320),h0tab(:,320),[32,5,16,10],[nMT,0,0,nMT],4,2,wf4(:,3),wf6(:,2))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,230),heltab2x96(:,:,302))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(30),n2h48(197))
Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(96)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(321),h0tab(:,321),[32,8,5,18],[nMT,nMT,0,nMT],4,2,wf4(:,3),wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,231),heltab2x96(:,:,303))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(31),n2h48(198))
Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(96)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(322),h0tab(:,322),[32,5,18,8],[nMT,0,nMT,nMT],4,2,wf4(:,3),wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,232),heltab2x96(:,:,304))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(32),n2h48(199))
Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(96)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(323),h0tab(:,323),[32,5,8,18],[0,nMT,nMT,0],4,2,wf4(:,3),wf4(:,5))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(33),m3h2x48(:,233),heltab2x96(:,:,305))
Gcoeff(:)%j = (c(8)*M(2,:)%j) * den(108)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(324),h0tab(:,324),[34,5,8,16],[0,nMT,nMT,nMT],4,2,wf4(:,7),wf4(:,3))
  call Hloop_QA_V(ntryL,G0H96(1),wf4(:,7),G0H24(15),m3h4x24(:,49),heltab2x96(:,:,306))
Gcoeff(:)%j = (c(8)*M(2,:)%j) * den(108)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(325),h0tab(:,325),[34,5,16,8],[0,nMT,nMT,nMT],4,2,wf4(:,7),wf4(:,3))
  call Hloop_QA_V(ntryL,G0H96(1),wf4(:,7),G0H24(16),m3h4x24(:,50),heltab2x96(:,:,307))
Gcoeff(:)%j = (-(c(6)*M(2,:)%j)) * den(108)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(326),h0tab(:,326),[34,8,5,16],[nMT,nMT,0,0],4,2,wf4(:,7),wf4(:,3))
  call Hloop_VA_Q(ntryL,G0H96(1),wf4(:,7),G0H24(17),m3h4x24(:,51),heltab2x96(:,:,308))
  call Hloop_A_Q(ntryL,G0H24(17),34,nMT,G1H24(51),n2h24(183))
Gcoeff(:)%j = (c(3)*(-M(1,:)%j+M(2,:)%j)) * den(159)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(327),h0tab(:,327),[48,5,2,8],[nMT,0,nMT,nMT],4,2,wf4(:,2),wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H96(1),wf4(:,2),G0H24(18),m3h4x24(:,52),heltab2x96(:,:,309))
  call Hloop_A_Q(ntryL,G0H24(18),48,nMT,G1H24(52),n2h24(184))
Gcoeff(:)%j = (c(11)*(M(1,:)%j-M(2,:)%j)) * den(159)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(328),h0tab(:,328),[48,2,8,5],[0,nMT,nMT,0],4,2,wf4(:,2),wf4(:,3))
  call Hloop_UV_W(ntryL,G0H96(1),0,wf4(:,2),48,G1H24(53),m3h4x24(:,53),heltab2x96(:,:,310))
Gcoeff(:)%j = (c(3)*(-M(1,:)%j+M(2,:)%j)) * den(159)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(329),h0tab(:,329),[48,2,5,8],[nMT,0,nMT,nMT],4,2,wf4(:,2),wf4(:,3))
  call Hloop_QV_A(ntryL,G0H96(1),wf4(:,2),G0H24(12),m3h4x24(:,54),heltab2x96(:,:,311))
  call Hloop_Q_A(ntryL,G0H24(12),48,nMT,G1H24(55),n2h24(185))
Gcoeff(:)%j = (c(20)*M(2,:)%j-c(19)*M(3,:)%j) * den(102)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(330),h0tab(:,330),[32,7,16,8],[0,0,0,0],4,1,wf8(:,25))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,234),heltab2x96(:,:,312))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(34),n2h48(200))
Gcoeff(:)%j = (c(18)*M(2,:)%j-c(17)*M(3,:)%j) * den(102)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(331),h0tab(:,331),[32,7,16,8],[nMT,nMT,nMT,nMT],4,1,wf8(:,25))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,235),heltab2x96(:,:,313))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(35),n2h48(201))
Gcoeff(:)%j = (c(20)*M(1,:)%j-c(19)*M(3,:)%j) * den(102)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(332),h0tab(:,332),[32,7,16,8],[0,0,0,0],4,1,wf8(:,25))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,236),heltab2x96(:,:,314))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(36),n2h48(202))
Gcoeff(:)%j = (c(18)*M(1,:)%j-c(17)*M(3,:)%j) * den(102)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(333),h0tab(:,333),[32,7,16,8],[nMT,nMT,nMT,nMT],4,1,wf8(:,25))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,237),heltab2x96(:,:,315))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(37),n2h48(203))
Gcoeff(:)%j = (c(20)*M(2,:)%j-c(19)*M(3,:)%j) * den(102)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(334),h0tab(:,334),[32,7,16,8],[0,0,0,0],4,1,wf8(:,25))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,238),heltab2x96(:,:,316))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(38),n2h48(204))
Gcoeff(:)%j = (c(18)*M(2,:)%j-c(17)*M(3,:)%j) * den(102)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(335),h0tab(:,335),[32,7,16,8],[nMB,nMB,nMB,nMB],4,1,wf8(:,25))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,239),heltab2x96(:,:,317))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMB,G1H48(39),n2h48(205))
Gcoeff(:)%j = (c(20)*M(1,:)%j-c(19)*M(3,:)%j) * den(102)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(336),h0tab(:,336),[32,7,16,8],[0,0,0,0],4,1,wf8(:,25))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,240),heltab2x96(:,:,318))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(40),n2h48(206))
Gcoeff(:)%j = (c(18)*M(1,:)%j-c(17)*M(3,:)%j) * den(102)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(337),h0tab(:,337),[32,7,16,8],[nMB,nMB,nMB,nMB],4,1,wf8(:,25))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,241),heltab2x96(:,:,319))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMB,G1H48(41),n2h48(207))
Gcoeff(:)%j = (c(20)*M(1,:)%j-c(19)*M(3,:)%j) * den(102)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(338),h0tab(:,338),[32,7,8,16],[0,0,0,0],4,1,wf8(:,25))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,242),heltab2x96(:,:,320))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(42),n2h48(208))
Gcoeff(:)%j = (c(18)*M(1,:)%j-c(17)*M(3,:)%j) * den(102)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(339),h0tab(:,339),[32,7,8,16],[nMT,nMT,nMT,nMT],4,1,wf8(:,25))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,243),heltab2x96(:,:,321))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(43),n2h48(209))
Gcoeff(:)%j = (c(20)*M(2,:)%j-c(19)*M(3,:)%j) * den(102)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(340),h0tab(:,340),[32,7,8,16],[0,0,0,0],4,1,wf8(:,25))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,244),heltab2x96(:,:,322))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(44),n2h48(210))
Gcoeff(:)%j = (c(18)*M(2,:)%j-c(17)*M(3,:)%j) * den(102)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(341),h0tab(:,341),[32,7,8,16],[nMT,nMT,nMT,nMT],4,1,wf8(:,25))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,245),heltab2x96(:,:,323))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(45),n2h48(211))
Gcoeff(:)%j = (c(20)*M(1,:)%j-c(19)*M(3,:)%j) * den(102)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(342),h0tab(:,342),[32,7,8,16],[0,0,0,0],4,1,wf8(:,25))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,246),heltab2x96(:,:,324))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(46),n2h48(212))
Gcoeff(:)%j = (c(18)*M(1,:)%j-c(17)*M(3,:)%j) * den(102)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(343),h0tab(:,343),[32,7,8,16],[nMB,nMB,nMB,nMB],4,1,wf8(:,25))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,247),heltab2x96(:,:,325))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMB,G1H48(47),n2h48(213))
Gcoeff(:)%j = (c(20)*M(2,:)%j-c(19)*M(3,:)%j) * den(102)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(344),h0tab(:,344),[32,7,8,16],[0,0,0,0],4,1,wf8(:,25))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,248),heltab2x96(:,:,326))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(48),n2h48(214))
Gcoeff(:)%j = (c(18)*M(2,:)%j-c(17)*M(3,:)%j) * den(102)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(345),h0tab(:,345),[32,7,8,16],[nMB,nMB,nMB,nMB],4,1,wf8(:,25))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,249),heltab2x96(:,:,327))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMB,G1H48(49),n2h48(215))
Gcoeff(:)%j = (c(20)*M(2,:)%j-c(19)*M(3,:)%j) * den(102)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(346),h0tab(:,346),[32,8,7,16],[0,0,0,0],4,1,wf8(:,25))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,250),heltab2x96(:,:,328))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(50),n2h48(216))
Gcoeff(:)%j = (c(18)*M(2,:)%j-c(17)*M(3,:)%j) * den(102)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(347),h0tab(:,347),[32,8,7,16],[nMT,nMT,nMT,nMT],4,1,wf8(:,25))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,251),heltab2x96(:,:,329))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(51),n2h48(217))
Gcoeff(:)%j = (c(20)*M(1,:)%j-c(19)*M(3,:)%j) * den(102)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(348),h0tab(:,348),[32,8,7,16],[0,0,0,0],4,1,wf8(:,25))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,252),heltab2x96(:,:,330))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(52),n2h48(218))
Gcoeff(:)%j = (c(18)*M(1,:)%j-c(17)*M(3,:)%j) * den(102)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(349),h0tab(:,349),[32,8,7,16],[nMT,nMT,nMT,nMT],4,1,wf8(:,25))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,253),heltab2x96(:,:,331))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(53),n2h48(219))
Gcoeff(:)%j = (c(20)*M(2,:)%j-c(19)*M(3,:)%j) * den(102)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(350),h0tab(:,350),[32,8,7,16],[0,0,0,0],4,1,wf8(:,25))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,254),heltab2x96(:,:,332))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(54),n2h48(220))
Gcoeff(:)%j = (c(18)*M(2,:)%j-c(17)*M(3,:)%j) * den(102)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(351),h0tab(:,351),[32,8,7,16],[nMB,nMB,nMB,nMB],4,1,wf8(:,25))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,255),heltab2x96(:,:,333))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMB,G1H48(55),n2h48(221))
Gcoeff(:)%j = (c(20)*M(1,:)%j-c(19)*M(3,:)%j) * den(102)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(352),h0tab(:,352),[32,8,7,16],[0,0,0,0],4,1,wf8(:,25))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,256),heltab2x96(:,:,334))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(56),n2h48(222))
Gcoeff(:)%j = (c(18)*M(1,:)%j-c(17)*M(3,:)%j) * den(102)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(353),h0tab(:,353),[32,8,7,16],[nMB,nMB,nMB,nMB],4,1,wf8(:,25))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,257),heltab2x96(:,:,335))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMB,G1H48(57),n2h48(223))
Gcoeff(:)%j = (c(4)*M(3,:)%j) * den(14)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(354),h0tab(:,354),[32,2,16,13],[0,nMT,nMT,0],4,1,wf12(:,5))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(58),m3h2x48(:,258),heltab2x96(:,:,336))
Gcoeff(:)%j = (-(c(4)*M(3,:)%j)) * den(14)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(355),h0tab(:,355),[32,2,16,13],[nMT,0,0,nMT],4,1,wf12(:,5))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,259),heltab2x96(:,:,337))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(59),n2h48(224))
Gcoeff(:)%j = (c(8)*M(1,:)%j-c(9)*M(3,:)%j) * den(14)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(356),h0tab(:,356),[32,13,2,16],[nMT,0,nMT,nMT],4,1,wf12(:,5))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,260),heltab2x96(:,:,338))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(60),n2h48(225))
Gcoeff(:)%j = (-(c(11)*M(1,:)%j)-c(9)*M(3,:)%j) * den(14)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(357),h0tab(:,357),[32,13,2,16],[0,nMT,0,0],4,1,wf12(:,5))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(61),m3h2x48(:,261),heltab2x96(:,:,339))
Gcoeff(:)%j = (c(8)*M(2,:)%j-c(9)*M(3,:)%j) * den(14)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(358),h0tab(:,358),[32,2,13,16],[nMT,0,nMT,nMT],4,1,wf12(:,5))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,262),heltab2x96(:,:,340))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(62),n2h48(226))
Gcoeff(:)%j = (-(c(11)*M(2,:)%j)-c(9)*M(3,:)%j) * den(14)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(359),h0tab(:,359),[32,2,13,16],[0,nMT,0,0],4,1,wf12(:,5))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(63),m3h2x48(:,263),heltab2x96(:,:,341))
Gcoeff(:)%j = (-(c(6)*M(2,:)%j)) * den(7)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(360),h0tab(:,360),[32,2,8,21],[0,nMT,nMT,0],4,1,wf8(:,2))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(64),m3h2x48(:,264),heltab2x96(:,:,342))
Gcoeff(:)%j = (c(8)*M(2,:)%j) * den(7)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(361),h0tab(:,361),[32,8,2,21],[nMT,nMT,0,nMT],4,1,wf8(:,2))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,265),heltab2x96(:,:,343))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(65),n2h48(227))
Gcoeff(:)%j = (c(8)*M(2,:)%j) * den(7)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(362),h0tab(:,362),[32,2,21,8],[nMT,0,nMT,nMT],4,1,wf8(:,2))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,266),heltab2x96(:,:,344))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(66),n2h48(228))
Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(88)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(363),h0tab(:,363),[37,8,2,16],[nMT,nMT,0,0],4,1,wf8(:,34))
  call Hloop_VQ_A(ntryL,G0H96(1),wf8(:,34),G0H12(9),m3h8x12(:,25),heltab2x96(:,:,345))
  call Hloop_Q_A(ntryL,G0H12(9),37,nMT,G1H12(183),n2h12(387))
Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(88)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(364),h0tab(:,364),[37,2,8,16],[0,nMT,nMT,nMT],4,1,wf8(:,34))
  call Hloop_AQ_V(ntryL,G0H96(1),wf8(:,34),G0H12(10),m3h8x12(:,26),heltab2x96(:,:,346))
Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(88)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(365),h0tab(:,365),[37,2,16,8],[0,nMT,nMT,nMT],4,1,wf8(:,34))
  call Hloop_AQ_V(ntryL,G0H96(1),wf8(:,34),G0H12(11),m3h8x12(:,27),heltab2x96(:,:,347))
Gcoeff(:)%j = (c(8)*M(2,:)%j-c(9)*M(3,:)%j) * den(28)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(366),h0tab(:,366),[32,6,9,16],[nMT,0,nMT,nMT],4,2,wf4(:,9),wf6(:,4))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,267),heltab2x96(:,:,348))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(67),n2h48(229))
Gcoeff(:)%j = (-(c(11)*M(2,:)%j)-c(9)*M(3,:)%j) * den(28)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(367),h0tab(:,367),[32,6,9,16],[0,nMT,0,0],4,2,wf4(:,9),wf6(:,4))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(68),m3h2x48(:,268),heltab2x96(:,:,349))
Gcoeff(:)%j = (c(8)*M(1,:)%j-c(9)*M(3,:)%j) * den(28)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(368),h0tab(:,368),[32,9,6,16],[nMT,0,nMT,nMT],4,2,wf6(:,4),wf4(:,9))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,269),heltab2x96(:,:,350))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(69),n2h48(230))
Gcoeff(:)%j = (-(c(11)*M(1,:)%j)-c(9)*M(3,:)%j) * den(28)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(369),h0tab(:,369),[32,9,6,16],[0,nMT,0,0],4,2,wf6(:,4),wf4(:,9))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(70),m3h2x48(:,270),heltab2x96(:,:,351))
Gcoeff(:)%j = (c(4)*M(3,:)%j) * den(28)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(370),h0tab(:,370),[32,6,16,9],[0,nMT,nMT,0],4,2,wf4(:,9),wf6(:,4))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(71),m3h2x48(:,271),heltab2x96(:,:,352))
Gcoeff(:)%j = (-(c(4)*M(3,:)%j)) * den(28)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(371),h0tab(:,371),[32,6,16,9],[nMT,0,0,nMT],4,2,wf4(:,9),wf6(:,4))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,272),heltab2x96(:,:,353))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(72),n2h48(231))
Gcoeff(:)%j = (c(8)*M(2,:)%j) * den(120)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(372),h0tab(:,372),[32,6,17,8],[nMT,0,nMT,nMT],4,2,wf4(:,9),wf4(:,11))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,273),heltab2x96(:,:,354))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(73),n2h48(232))
Gcoeff(:)%j = (c(8)*M(2,:)%j) * den(120)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(373),h0tab(:,373),[32,8,6,17],[nMT,nMT,0,nMT],4,2,wf4(:,9),wf4(:,11))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,274),heltab2x96(:,:,355))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(74),n2h48(233))
Gcoeff(:)%j = (-(c(6)*M(2,:)%j)) * den(120)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(374),h0tab(:,374),[32,6,8,17],[0,nMT,nMT,0],4,2,wf4(:,9),wf4(:,11))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(75),m3h2x48(:,275),heltab2x96(:,:,356))
Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(130)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(375),h0tab(:,375),[33,6,16,8],[0,nMT,nMT,nMT],4,2,wf4(:,13),wf4(:,9))
  call Hloop_AQ_V(ntryL,G0H96(1),wf4(:,13),G0H24(13),m3h4x24(:,55),heltab2x96(:,:,357))
Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(130)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(376),h0tab(:,376),[33,6,8,16],[0,nMT,nMT,nMT],4,2,wf4(:,13),wf4(:,9))
  call Hloop_AQ_V(ntryL,G0H96(1),wf4(:,13),G0H24(14),m3h4x24(:,56),heltab2x96(:,:,358))
Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(130)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(377),h0tab(:,377),[33,8,6,16],[nMT,nMT,0,0],4,2,wf4(:,13),wf4(:,9))
  call Hloop_VQ_A(ntryL,G0H96(1),wf4(:,13),G0H24(17),m3h4x24(:,57),heltab2x96(:,:,359))
  call Hloop_Q_A(ntryL,G0H24(17),33,nMT,G1H24(56),n2h24(186))
Gcoeff(:)%j = (c(3)*(-M(1,:)%j+M(2,:)%j)) * den(192)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(378),h0tab(:,378),[48,6,1,8],[nMT,0,nMT,nMT],4,2,wf4(:,2),wf4(:,9))
  call Hloop_QV_A(ntryL,G0H96(1),wf4(:,2),G0H24(18),m3h4x24(:,58),heltab2x96(:,:,360))
  call Hloop_Q_A(ntryL,G0H24(18),48,nMT,G1H24(14),n2h24(187))
Gcoeff(:)%j = (c(11)*(-M(1,:)%j+M(2,:)%j)) * den(192)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(379),h0tab(:,379),[48,1,8,6],[0,nMT,nMT,0],4,2,wf4(:,2),wf4(:,9))
  call Hloop_UV_W(ntryL,G0H96(1),0,wf4(:,2),48,G1H24(58),m3h4x24(:,59),heltab2x96(:,:,361))
Gcoeff(:)%j = (c(3)*(-M(1,:)%j+M(2,:)%j)) * den(192)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(380),h0tab(:,380),[48,1,6,8],[nMT,0,nMT,nMT],4,2,wf4(:,2),wf4(:,9))
  call Hloop_AV_Q(ntryL,G0H96(1),wf4(:,2),G0H24(12),m3h4x24(:,60),heltab2x96(:,:,362))
  call Hloop_A_Q(ntryL,G0H24(12),48,nMT,G1H24(63),n2h24(188))
Gcoeff(:)%j = (c(20)*M(2,:)%j-c(19)*M(3,:)%j) * den(125)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(381),h0tab(:,381),[32,7,16,8],[0,0,0,0],4,1,wf8(:,26))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,276),heltab2x96(:,:,363))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(76),n2h48(234))
Gcoeff(:)%j = (c(18)*M(2,:)%j-c(17)*M(3,:)%j) * den(125)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(382),h0tab(:,382),[32,7,16,8],[nMT,nMT,nMT,nMT],4,1,wf8(:,26))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,277),heltab2x96(:,:,364))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(77),n2h48(235))
Gcoeff(:)%j = (c(20)*M(1,:)%j-c(19)*M(3,:)%j) * den(125)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(383),h0tab(:,383),[32,7,16,8],[0,0,0,0],4,1,wf8(:,26))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,278),heltab2x96(:,:,365))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(78),n2h48(236))
Gcoeff(:)%j = (c(18)*M(1,:)%j-c(17)*M(3,:)%j) * den(125)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(384),h0tab(:,384),[32,7,16,8],[nMT,nMT,nMT,nMT],4,1,wf8(:,26))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,279),heltab2x96(:,:,366))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(79),n2h48(237))
Gcoeff(:)%j = (c(20)*M(2,:)%j-c(19)*M(3,:)%j) * den(125)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(385),h0tab(:,385),[32,7,16,8],[0,0,0,0],4,1,wf8(:,26))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,280),heltab2x96(:,:,367))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(80),n2h48(238))
Gcoeff(:)%j = (c(18)*M(2,:)%j-c(17)*M(3,:)%j) * den(125)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(386),h0tab(:,386),[32,7,16,8],[nMB,nMB,nMB,nMB],4,1,wf8(:,26))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,281),heltab2x96(:,:,368))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMB,G1H48(81),n2h48(239))
Gcoeff(:)%j = (c(20)*M(1,:)%j-c(19)*M(3,:)%j) * den(125)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(387),h0tab(:,387),[32,7,16,8],[0,0,0,0],4,1,wf8(:,26))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,282),heltab2x96(:,:,369))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(82),n2h48(240))
Gcoeff(:)%j = (c(18)*M(1,:)%j-c(17)*M(3,:)%j) * den(125)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(388),h0tab(:,388),[32,7,16,8],[nMB,nMB,nMB,nMB],4,1,wf8(:,26))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,283),heltab2x96(:,:,370))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMB,G1H48(83),n2h48(241))
Gcoeff(:)%j = (c(20)*M(1,:)%j-c(19)*M(3,:)%j) * den(125)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(389),h0tab(:,389),[32,7,8,16],[0,0,0,0],4,1,wf8(:,26))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,284),heltab2x96(:,:,371))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(84),n2h48(242))
Gcoeff(:)%j = (c(18)*M(1,:)%j-c(17)*M(3,:)%j) * den(125)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(390),h0tab(:,390),[32,7,8,16],[nMT,nMT,nMT,nMT],4,1,wf8(:,26))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,285),heltab2x96(:,:,372))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(85),n2h48(243))
Gcoeff(:)%j = (c(20)*M(2,:)%j-c(19)*M(3,:)%j) * den(125)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(391),h0tab(:,391),[32,7,8,16],[0,0,0,0],4,1,wf8(:,26))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,286),heltab2x96(:,:,373))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(86),n2h48(244))
Gcoeff(:)%j = (c(18)*M(2,:)%j-c(17)*M(3,:)%j) * den(125)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(392),h0tab(:,392),[32,7,8,16],[nMT,nMT,nMT,nMT],4,1,wf8(:,26))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,287),heltab2x96(:,:,374))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(87),n2h48(245))
Gcoeff(:)%j = (c(20)*M(1,:)%j-c(19)*M(3,:)%j) * den(125)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(393),h0tab(:,393),[32,7,8,16],[0,0,0,0],4,1,wf8(:,26))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,288),heltab2x96(:,:,375))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(88),n2h48(246))
Gcoeff(:)%j = (c(18)*M(1,:)%j-c(17)*M(3,:)%j) * den(125)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(394),h0tab(:,394),[32,7,8,16],[nMB,nMB,nMB,nMB],4,1,wf8(:,26))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,289),heltab2x96(:,:,376))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMB,G1H48(89),n2h48(247))
Gcoeff(:)%j = (c(20)*M(2,:)%j-c(19)*M(3,:)%j) * den(125)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(395),h0tab(:,395),[32,7,8,16],[0,0,0,0],4,1,wf8(:,26))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,290),heltab2x96(:,:,377))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(90),n2h48(248))
Gcoeff(:)%j = (c(18)*M(2,:)%j-c(17)*M(3,:)%j) * den(125)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(396),h0tab(:,396),[32,7,8,16],[nMB,nMB,nMB,nMB],4,1,wf8(:,26))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,291),heltab2x96(:,:,378))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMB,G1H48(91),n2h48(249))
Gcoeff(:)%j = (c(20)*M(2,:)%j-c(19)*M(3,:)%j) * den(125)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(397),h0tab(:,397),[32,8,7,16],[0,0,0,0],4,1,wf8(:,26))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,292),heltab2x96(:,:,379))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(92),n2h48(250))
Gcoeff(:)%j = (c(18)*M(2,:)%j-c(17)*M(3,:)%j) * den(125)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(398),h0tab(:,398),[32,8,7,16],[nMT,nMT,nMT,nMT],4,1,wf8(:,26))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,293),heltab2x96(:,:,380))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(93),n2h48(251))
Gcoeff(:)%j = (c(20)*M(1,:)%j-c(19)*M(3,:)%j) * den(125)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(399),h0tab(:,399),[32,8,7,16],[0,0,0,0],4,1,wf8(:,26))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,294),heltab2x96(:,:,381))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(94),n2h48(252))
Gcoeff(:)%j = (c(18)*M(1,:)%j-c(17)*M(3,:)%j) * den(125)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(400),h0tab(:,400),[32,8,7,16],[nMT,nMT,nMT,nMT],4,1,wf8(:,26))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,295),heltab2x96(:,:,382))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(95),n2h48(253))
Gcoeff(:)%j = (c(20)*M(2,:)%j-c(19)*M(3,:)%j) * den(125)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(401),h0tab(:,401),[32,8,7,16],[0,0,0,0],4,1,wf8(:,26))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,296),heltab2x96(:,:,383))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(96),n2h48(254))
Gcoeff(:)%j = (c(18)*M(2,:)%j-c(17)*M(3,:)%j) * den(125)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(402),h0tab(:,402),[32,8,7,16],[nMB,nMB,nMB,nMB],4,1,wf8(:,26))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,297),heltab2x96(:,:,384))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMB,G1H48(97),n2h48(255))
Gcoeff(:)%j = (c(20)*M(1,:)%j-c(19)*M(3,:)%j) * den(125)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(403),h0tab(:,403),[32,8,7,16],[0,0,0,0],4,1,wf8(:,26))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,298),heltab2x96(:,:,385))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(98),n2h48(256))
Gcoeff(:)%j = (c(18)*M(1,:)%j-c(17)*M(3,:)%j) * den(125)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(404),h0tab(:,404),[32,8,7,16],[nMB,nMB,nMB,nMB],4,1,wf8(:,26))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,299),heltab2x96(:,:,386))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMB,G1H48(99),n2h48(257))
Gcoeff(:)%j = (-(c(4)*M(3,:)%j)) * den(40)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(405),h0tab(:,405),[32,1,16,14],[0,nMT,nMT,0],4,1,wf12(:,16))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(100),m3h2x48(:,300),heltab2x96(:,:,387))
Gcoeff(:)%j = (c(4)*M(3,:)%j) * den(40)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(406),h0tab(:,406),[32,1,16,14],[nMT,0,0,nMT],4,1,wf12(:,16))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,301),heltab2x96(:,:,388))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(101),n2h48(258))
Gcoeff(:)%j = (c(8)*M(2,:)%j-c(9)*M(3,:)%j) * den(40)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(407),h0tab(:,407),[32,14,1,16],[nMT,0,nMT,nMT],4,1,wf12(:,16))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,302),heltab2x96(:,:,389))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(102),n2h48(259))
Gcoeff(:)%j = (-(c(11)*M(2,:)%j)-c(9)*M(3,:)%j) * den(40)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(408),h0tab(:,408),[32,14,1,16],[0,nMT,0,0],4,1,wf12(:,16))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(103),m3h2x48(:,303),heltab2x96(:,:,390))
Gcoeff(:)%j = (c(8)*M(1,:)%j-c(9)*M(3,:)%j) * den(40)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(409),h0tab(:,409),[32,1,14,16],[nMT,0,nMT,nMT],4,1,wf12(:,16))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,304),heltab2x96(:,:,391))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(104),n2h48(260))
Gcoeff(:)%j = (-(c(11)*M(1,:)%j)-c(9)*M(3,:)%j) * den(40)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(410),h0tab(:,410),[32,1,14,16],[0,nMT,0,0],4,1,wf12(:,16))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(105),m3h2x48(:,305),heltab2x96(:,:,392))
Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(34)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(411),h0tab(:,411),[32,1,8,22],[0,nMT,nMT,0],4,1,wf8(:,10))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(106),m3h2x48(:,306),heltab2x96(:,:,393))
Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(34)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(412),h0tab(:,412),[32,8,1,22],[nMT,nMT,0,nMT],4,1,wf8(:,10))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,307),heltab2x96(:,:,394))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(107),n2h48(261))
Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(34)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(413),h0tab(:,413),[32,1,22,8],[nMT,0,nMT,nMT],4,1,wf8(:,10))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,308),heltab2x96(:,:,395))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(108),n2h48(262))
Gcoeff(:)%j = (-(c(6)*M(2,:)%j)) * den(115)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(414),h0tab(:,414),[38,8,1,16],[nMT,nMT,0,0],4,1,wf8(:,44))
  call Hloop_VA_Q(ntryL,G0H96(1),wf8(:,44),G0H12(12),m3h8x12(:,28),heltab2x96(:,:,396))
  call Hloop_A_Q(ntryL,G0H12(12),38,nMT,G1H12(184),n2h12(388))
Gcoeff(:)%j = (c(8)*M(2,:)%j) * den(115)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(415),h0tab(:,415),[38,1,8,16],[0,nMT,nMT,nMT],4,1,wf8(:,44))
  call Hloop_QA_V(ntryL,G0H96(1),wf8(:,44),G0H12(13),m3h8x12(:,29),heltab2x96(:,:,397))
Gcoeff(:)%j = (c(8)*M(2,:)%j) * den(115)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(416),h0tab(:,416),[38,1,16,8],[0,nMT,nMT,nMT],4,1,wf8(:,44))
  call Hloop_QA_V(ntryL,G0H96(1),wf8(:,44),G0H12(14),m3h8x12(:,30),heltab2x96(:,:,398))
Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(305)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(417),h0tab(:,417),[32,4,9,18],[nMT,nMT,0,nMT],4,2,wf6(:,4),wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,309),heltab2x96(:,:,399))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(109),n2h48(263))
Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(305)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(418),h0tab(:,418),[32,4,18,9],[nMT,nMT,0,nMT],4,2,wf4(:,5),wf6(:,4))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,310),heltab2x96(:,:,400))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(110),n2h48(264))
Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(305)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(419),h0tab(:,419),[32,9,4,18],[0,nMT,nMT,0],4,2,wf6(:,4),wf4(:,5))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(111),m3h2x48(:,311),heltab2x96(:,:,401))
Gcoeff(:)%j = (c(8)*M(2,:)%j) * den(308)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(420),h0tab(:,420),[34,9,4,16],[0,nMT,nMT,nMT],4,2,wf4(:,7),wf6(:,4))
  call Hloop_QA_V(ntryL,G0H96(1),wf4(:,7),G0H24(17),m3h4x24(:,61),heltab2x96(:,:,402))
Gcoeff(:)%j = (c(8)*M(2,:)%j) * den(308)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(421),h0tab(:,421),[34,4,16,9],[nMT,nMT,nMT,0],4,2,wf4(:,7),wf6(:,4))
  call Hloop_VA_Q(ntryL,G0H96(1),wf4(:,7),G0H24(18),m3h4x24(:,62),heltab2x96(:,:,403))
  call Hloop_A_Q(ntryL,G0H24(18),34,nMT,G1H24(64),n2h24(189))
Gcoeff(:)%j = (-(c(6)*M(2,:)%j)) * den(308)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(422),h0tab(:,422),[34,4,9,16],[nMT,nMT,0,0],4,2,wf4(:,7),wf6(:,4))
  call Hloop_VA_Q(ntryL,G0H96(1),wf4(:,7),G0H24(12),m3h4x24(:,63),heltab2x96(:,:,404))
  call Hloop_A_Q(ntryL,G0H24(12),34,nMT,G1H24(66),n2h24(190))
Gcoeff(:)%j = (c(3)*(-M(1,:)%j+M(2,:)%j)) * den(196)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(423),h0tab(:,423),[48,4,2,9],[nMT,nMT,0,nMT],4,2,wf4(:,2),wf6(:,4))
  call Hloop_QV_A(ntryL,G0H96(1),wf4(:,2),G0H24(18),m3h4x24(:,64),heltab2x96(:,:,405))
  call Hloop_Q_A(ntryL,G0H24(18),48,nMT,G1H24(72),n2h24(191))
Gcoeff(:)%j = (c(11)*(M(1,:)%j-M(2,:)%j)) * den(196)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(424),h0tab(:,424),[48,2,4,9],[0,nMT,nMT,0],4,2,wf4(:,2),wf6(:,4))
  call Hloop_UV_W(ntryL,G0H96(1),0,wf4(:,2),48,G1H24(73),m3h4x24(:,65),heltab2x96(:,:,406))
Gcoeff(:)%j = (c(3)*(-M(1,:)%j+M(2,:)%j)) * den(196)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(425),h0tab(:,425),[48,2,9,4],[nMT,0,nMT,nMT],4,2,wf4(:,2),wf6(:,4))
  call Hloop_QV_A(ntryL,G0H96(1),wf4(:,2),G0H24(12),m3h4x24(:,66),heltab2x96(:,:,407))
  call Hloop_Q_A(ntryL,G0H24(12),48,nMT,G1H24(74),n2h24(192))
Gcoeff(:)%j = (c(20)*M(2,:)%j-c(19)*M(3,:)%j) * den(312)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(426),h0tab(:,426),[32,4,16,11],[0,0,0,0],4,1,wf12(:,27))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,312),heltab2x96(:,:,408))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(112),n2h48(265))
Gcoeff(:)%j = (c(18)*M(2,:)%j-c(17)*M(3,:)%j) * den(312)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(427),h0tab(:,427),[32,4,16,11],[nMT,nMT,nMT,nMT],4,1,wf12(:,27))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,313),heltab2x96(:,:,409))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(113),n2h48(266))
Gcoeff(:)%j = (c(20)*M(1,:)%j-c(19)*M(3,:)%j) * den(312)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(428),h0tab(:,428),[32,4,16,11],[0,0,0,0],4,1,wf12(:,27))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,314),heltab2x96(:,:,410))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(114),n2h48(267))
Gcoeff(:)%j = (c(18)*M(1,:)%j-c(17)*M(3,:)%j) * den(312)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(429),h0tab(:,429),[32,4,16,11],[nMT,nMT,nMT,nMT],4,1,wf12(:,27))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,315),heltab2x96(:,:,411))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(115),n2h48(268))
Gcoeff(:)%j = (-(c(18)*M(2,:)%j)+c(17)*M(3,:)%j) * den(312)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(430),h0tab(:,430),[32,4,16,11],[0,0,0,0],4,1,wf12(:,27))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,316),heltab2x96(:,:,412))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(116),n2h48(269))
Gcoeff(:)%j = (-(c(16)*M(2,:)%j)+c(15)*M(3,:)%j) * den(312)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(431),h0tab(:,431),[32,4,16,11],[nMB,nMB,nMB,nMB],4,1,wf12(:,27))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,317),heltab2x96(:,:,413))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMB,G1H48(117),n2h48(270))
Gcoeff(:)%j = (-(c(18)*M(1,:)%j)+c(17)*M(3,:)%j) * den(312)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(432),h0tab(:,432),[32,4,16,11],[0,0,0,0],4,1,wf12(:,27))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,318),heltab2x96(:,:,414))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(118),n2h48(271))
Gcoeff(:)%j = (-(c(16)*M(1,:)%j)+c(15)*M(3,:)%j) * den(312)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(433),h0tab(:,433),[32,4,16,11],[nMB,nMB,nMB,nMB],4,1,wf12(:,27))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,319),heltab2x96(:,:,415))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMB,G1H48(119),n2h48(272))
Gcoeff(:)%j = (c(20)*M(1,:)%j-c(19)*M(3,:)%j) * den(312)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(434),h0tab(:,434),[32,11,4,16],[0,0,0,0],4,1,wf12(:,27))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,320),heltab2x96(:,:,416))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(120),n2h48(273))
Gcoeff(:)%j = (c(18)*M(1,:)%j-c(17)*M(3,:)%j) * den(312)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(435),h0tab(:,435),[32,11,4,16],[nMT,nMT,nMT,nMT],4,1,wf12(:,27))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,321),heltab2x96(:,:,417))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(121),n2h48(274))
Gcoeff(:)%j = (c(20)*M(2,:)%j-c(19)*M(3,:)%j) * den(312)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(436),h0tab(:,436),[32,11,4,16],[0,0,0,0],4,1,wf12(:,27))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,322),heltab2x96(:,:,418))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(122),n2h48(275))
Gcoeff(:)%j = (c(18)*M(2,:)%j-c(17)*M(3,:)%j) * den(312)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(437),h0tab(:,437),[32,11,4,16],[nMT,nMT,nMT,nMT],4,1,wf12(:,27))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,323),heltab2x96(:,:,419))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(123),n2h48(276))
Gcoeff(:)%j = (-(c(18)*M(1,:)%j)+c(17)*M(3,:)%j) * den(312)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(438),h0tab(:,438),[32,11,4,16],[0,0,0,0],4,1,wf12(:,27))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,324),heltab2x96(:,:,420))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(124),n2h48(277))
Gcoeff(:)%j = (-(c(16)*M(1,:)%j)+c(15)*M(3,:)%j) * den(312)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(439),h0tab(:,439),[32,11,4,16],[nMB,nMB,nMB,nMB],4,1,wf12(:,27))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,325),heltab2x96(:,:,421))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMB,G1H48(125),n2h48(278))
Gcoeff(:)%j = (-(c(18)*M(2,:)%j)+c(17)*M(3,:)%j) * den(312)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(440),h0tab(:,440),[32,11,4,16],[0,0,0,0],4,1,wf12(:,27))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,326),heltab2x96(:,:,422))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(126),n2h48(279))
Gcoeff(:)%j = (-(c(16)*M(2,:)%j)+c(15)*M(3,:)%j) * den(312)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(441),h0tab(:,441),[32,11,4,16],[nMB,nMB,nMB,nMB],4,1,wf12(:,27))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,327),heltab2x96(:,:,423))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMB,G1H48(127),n2h48(280))
Gcoeff(:)%j = (c(20)*M(2,:)%j-c(19)*M(3,:)%j) * den(312)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(442),h0tab(:,442),[32,4,11,16],[0,0,0,0],4,1,wf12(:,27))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,328),heltab2x96(:,:,424))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(128),n2h48(281))
Gcoeff(:)%j = (c(18)*M(2,:)%j-c(17)*M(3,:)%j) * den(312)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(443),h0tab(:,443),[32,4,11,16],[nMT,nMT,nMT,nMT],4,1,wf12(:,27))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,329),heltab2x96(:,:,425))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(129),n2h48(282))
Gcoeff(:)%j = (c(20)*M(1,:)%j-c(19)*M(3,:)%j) * den(312)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(444),h0tab(:,444),[32,4,11,16],[0,0,0,0],4,1,wf12(:,27))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,330),heltab2x96(:,:,426))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(130),n2h48(283))
Gcoeff(:)%j = (c(18)*M(1,:)%j-c(17)*M(3,:)%j) * den(312)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(445),h0tab(:,445),[32,4,11,16],[nMT,nMT,nMT,nMT],4,1,wf12(:,27))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,331),heltab2x96(:,:,427))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(131),n2h48(284))
Gcoeff(:)%j = (-(c(18)*M(2,:)%j)+c(17)*M(3,:)%j) * den(312)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(446),h0tab(:,446),[32,4,11,16],[0,0,0,0],4,1,wf12(:,27))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,332),heltab2x96(:,:,428))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(132),n2h48(285))
Gcoeff(:)%j = (-(c(16)*M(2,:)%j)+c(15)*M(3,:)%j) * den(312)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(447),h0tab(:,447),[32,4,11,16],[nMB,nMB,nMB,nMB],4,1,wf12(:,27))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,333),heltab2x96(:,:,429))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMB,G1H48(133),n2h48(286))
Gcoeff(:)%j = (-(c(18)*M(1,:)%j)+c(17)*M(3,:)%j) * den(312)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(448),h0tab(:,448),[32,4,11,16],[0,0,0,0],4,1,wf12(:,27))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,334),heltab2x96(:,:,430))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(134),n2h48(287))
Gcoeff(:)%j = (-(c(16)*M(1,:)%j)+c(15)*M(3,:)%j) * den(312)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(449),h0tab(:,449),[32,4,11,16],[nMB,nMB,nMB,nMB],4,1,wf12(:,27))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,335),heltab2x96(:,:,431))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMB,G1H48(135),n2h48(288))
Gcoeff(:)%j = (c(4)*M(3,:)%j) * den(50)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(450),h0tab(:,450),[32,2,16,13],[0,nMT,nMT,0],4,1,wf12(:,20))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(136),m3h2x48(:,336),heltab2x96(:,:,432))
Gcoeff(:)%j = (-(c(4)*M(3,:)%j)) * den(50)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(451),h0tab(:,451),[32,2,16,13],[nMT,0,0,nMT],4,1,wf12(:,20))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,337),heltab2x96(:,:,433))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(137),n2h48(289))
Gcoeff(:)%j = (c(8)*M(1,:)%j-c(9)*M(3,:)%j) * den(50)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(452),h0tab(:,452),[32,13,2,16],[nMT,0,nMT,nMT],4,1,wf12(:,20))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,338),heltab2x96(:,:,434))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(138),n2h48(290))
Gcoeff(:)%j = (-(c(11)*M(1,:)%j)-c(9)*M(3,:)%j) * den(50)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(453),h0tab(:,453),[32,13,2,16],[0,nMT,0,0],4,1,wf12(:,20))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(139),m3h2x48(:,339),heltab2x96(:,:,435))
Gcoeff(:)%j = (c(8)*M(2,:)%j-c(9)*M(3,:)%j) * den(50)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(454),h0tab(:,454),[32,2,13,16],[nMT,0,nMT,nMT],4,1,wf12(:,20))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,340),heltab2x96(:,:,436))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(140),n2h48(291))
Gcoeff(:)%j = (-(c(11)*M(2,:)%j)-c(9)*M(3,:)%j) * den(50)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(455),h0tab(:,455),[32,2,13,16],[0,nMT,0,0],4,1,wf12(:,20))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(141),m3h2x48(:,341),heltab2x96(:,:,437))
Gcoeff(:)%j = (-(c(6)*M(2,:)%j)) * den(31)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(456),h0tab(:,456),[32,2,4,25],[0,nMT,nMT,0],4,1,wf12(:,11))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(142),m3h2x48(:,342),heltab2x96(:,:,438))
Gcoeff(:)%j = (c(8)*M(2,:)%j) * den(31)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(457),h0tab(:,457),[32,4,2,25],[nMT,nMT,0,nMT],4,1,wf12(:,11))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,343),heltab2x96(:,:,439))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(143),n2h48(292))
Gcoeff(:)%j = (c(8)*M(2,:)%j) * den(31)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(458),h0tab(:,458),[32,2,25,4],[nMT,0,nMT,nMT],4,1,wf12(:,11))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,344),heltab2x96(:,:,440))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(144),n2h48(293))
Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(113)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(459),h0tab(:,459),[41,4,2,16],[nMT,nMT,0,0],4,1,wf12(:,43))
  call Hloop_VQ_A(ntryL,G0H96(1),wf12(:,43),G0H8(1),m3h12x8(:,1),heltab2x96(:,:,441))
  call Hloop_Q_A(ntryL,G0H8(1),41,nMT,G1H8(67),n2h8(215))
Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(113)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(460),h0tab(:,460),[41,2,4,16],[0,nMT,nMT,nMT],4,1,wf12(:,43))
  call Hloop_AQ_V(ntryL,G0H96(1),wf12(:,43),G0H8(2),m3h12x8(:,2),heltab2x96(:,:,442))
Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(113)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(461),h0tab(:,461),[41,2,16,4],[0,nMT,nMT,nMT],4,1,wf12(:,43))
  call Hloop_AQ_V(ntryL,G0H96(1),wf12(:,43),G0H8(3),m3h12x8(:,3),heltab2x96(:,:,443))
Gcoeff(:)%j = (c(8)*M(2,:)%j) * den(324)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(462),h0tab(:,462),[32,4,17,10],[nMT,nMT,0,nMT],4,2,wf4(:,11),wf6(:,2))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,345),heltab2x96(:,:,444))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(145),n2h48(294))
Gcoeff(:)%j = (c(8)*M(2,:)%j) * den(324)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(463),h0tab(:,463),[32,4,10,17],[nMT,nMT,0,nMT],4,2,wf6(:,2),wf4(:,11))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,346),heltab2x96(:,:,445))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(146),n2h48(295))
Gcoeff(:)%j = (-(c(6)*M(2,:)%j)) * den(324)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(464),h0tab(:,464),[32,10,4,17],[0,nMT,nMT,0],4,2,wf6(:,2),wf4(:,11))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(147),m3h2x48(:,347),heltab2x96(:,:,446))
Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(326)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(465),h0tab(:,465),[33,4,16,10],[nMT,nMT,nMT,0],4,2,wf4(:,13),wf6(:,2))
  call Hloop_VQ_A(ntryL,G0H96(1),wf4(:,13),G0H24(18),m3h4x24(:,67),heltab2x96(:,:,447))
  call Hloop_Q_A(ntryL,G0H24(18),33,nMT,G1H24(15),n2h24(193))
Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(326)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(466),h0tab(:,466),[33,10,4,16],[0,nMT,nMT,nMT],4,2,wf4(:,13),wf6(:,2))
  call Hloop_AQ_V(ntryL,G0H96(1),wf4(:,13),G0H24(12),m3h4x24(:,68),heltab2x96(:,:,448))
Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(326)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(467),h0tab(:,467),[33,4,10,16],[nMT,nMT,0,0],4,2,wf4(:,13),wf6(:,2))
  call Hloop_VQ_A(ntryL,G0H96(1),wf4(:,13),G0H24(18),m3h4x24(:,69),heltab2x96(:,:,449))
  call Hloop_Q_A(ntryL,G0H24(18),33,nMT,G1H24(77),n2h24(194))
Gcoeff(:)%j = (c(3)*(-M(1,:)%j+M(2,:)%j)) * den(155)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(468),h0tab(:,468),[48,4,1,10],[nMT,nMT,0,nMT],4,2,wf4(:,2),wf6(:,2))
  call Hloop_AV_Q(ntryL,G0H96(1),wf4(:,2),G0H24(18),m3h4x24(:,70),heltab2x96(:,:,450))
  call Hloop_A_Q(ntryL,G0H24(18),48,nMT,G1H24(80),n2h24(195))
Gcoeff(:)%j = (c(11)*(-M(1,:)%j+M(2,:)%j)) * den(155)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(469),h0tab(:,469),[48,1,4,10],[0,nMT,nMT,0],4,2,wf4(:,2),wf6(:,2))
  call Hloop_UV_W(ntryL,G0H96(1),0,wf4(:,2),48,G1H24(82),m3h4x24(:,71),heltab2x96(:,:,451))
Gcoeff(:)%j = (c(3)*(-M(1,:)%j+M(2,:)%j)) * den(155)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(470),h0tab(:,470),[48,1,10,4],[nMT,0,nMT,nMT],4,2,wf4(:,2),wf6(:,2))
  call Hloop_AV_Q(ntryL,G0H96(1),wf4(:,2),G0H24(18),m3h4x24(:,72),heltab2x96(:,:,452))
  call Hloop_A_Q(ntryL,G0H24(18),48,nMT,G1H24(83),n2h24(196))
Gcoeff(:)%j = (c(20)*M(2,:)%j-c(19)*M(3,:)%j) * den(328)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(471),h0tab(:,471),[32,4,16,11],[0,0,0,0],4,1,wf12(:,28))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,348),heltab2x96(:,:,453))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(148),n2h48(296))
Gcoeff(:)%j = (c(18)*M(2,:)%j-c(17)*M(3,:)%j) * den(328)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(472),h0tab(:,472),[32,4,16,11],[nMT,nMT,nMT,nMT],4,1,wf12(:,28))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,349),heltab2x96(:,:,454))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(149),n2h48(297))
Gcoeff(:)%j = (c(20)*M(1,:)%j-c(19)*M(3,:)%j) * den(328)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(473),h0tab(:,473),[32,4,16,11],[0,0,0,0],4,1,wf12(:,28))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,350),heltab2x96(:,:,455))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(150),n2h48(298))
Gcoeff(:)%j = (c(18)*M(1,:)%j-c(17)*M(3,:)%j) * den(328)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(474),h0tab(:,474),[32,4,16,11],[nMT,nMT,nMT,nMT],4,1,wf12(:,28))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,351),heltab2x96(:,:,456))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(151),n2h48(299))
Gcoeff(:)%j = (-(c(18)*M(2,:)%j)+c(17)*M(3,:)%j) * den(328)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(475),h0tab(:,475),[32,4,16,11],[0,0,0,0],4,1,wf12(:,28))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,352),heltab2x96(:,:,457))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(152),n2h48(300))
Gcoeff(:)%j = (-(c(16)*M(2,:)%j)+c(15)*M(3,:)%j) * den(328)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(476),h0tab(:,476),[32,4,16,11],[nMB,nMB,nMB,nMB],4,1,wf12(:,28))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,353),heltab2x96(:,:,458))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMB,G1H48(153),n2h48(301))
Gcoeff(:)%j = (-(c(18)*M(1,:)%j)+c(17)*M(3,:)%j) * den(328)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(477),h0tab(:,477),[32,4,16,11],[0,0,0,0],4,1,wf12(:,28))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,354),heltab2x96(:,:,459))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(154),n2h48(302))
Gcoeff(:)%j = (-(c(16)*M(1,:)%j)+c(15)*M(3,:)%j) * den(328)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(478),h0tab(:,478),[32,4,16,11],[nMB,nMB,nMB,nMB],4,1,wf12(:,28))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,355),heltab2x96(:,:,460))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMB,G1H48(155),n2h48(303))
Gcoeff(:)%j = (c(20)*M(1,:)%j-c(19)*M(3,:)%j) * den(328)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(479),h0tab(:,479),[32,11,4,16],[0,0,0,0],4,1,wf12(:,28))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,356),heltab2x96(:,:,461))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(156),n2h48(304))
Gcoeff(:)%j = (c(18)*M(1,:)%j-c(17)*M(3,:)%j) * den(328)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(480),h0tab(:,480),[32,11,4,16],[nMT,nMT,nMT,nMT],4,1,wf12(:,28))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,357),heltab2x96(:,:,462))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(157),n2h48(305))
Gcoeff(:)%j = (c(20)*M(2,:)%j-c(19)*M(3,:)%j) * den(328)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(481),h0tab(:,481),[32,11,4,16],[0,0,0,0],4,1,wf12(:,28))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,358),heltab2x96(:,:,463))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(158),n2h48(306))
Gcoeff(:)%j = (c(18)*M(2,:)%j-c(17)*M(3,:)%j) * den(328)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(482),h0tab(:,482),[32,11,4,16],[nMT,nMT,nMT,nMT],4,1,wf12(:,28))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,359),heltab2x96(:,:,464))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(159),n2h48(307))
Gcoeff(:)%j = (-(c(18)*M(1,:)%j)+c(17)*M(3,:)%j) * den(328)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(483),h0tab(:,483),[32,11,4,16],[0,0,0,0],4,1,wf12(:,28))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,360),heltab2x96(:,:,465))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(160),n2h48(308))
Gcoeff(:)%j = (-(c(16)*M(1,:)%j)+c(15)*M(3,:)%j) * den(328)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(484),h0tab(:,484),[32,11,4,16],[nMB,nMB,nMB,nMB],4,1,wf12(:,28))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,361),heltab2x96(:,:,466))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMB,G1H48(161),n2h48(309))
Gcoeff(:)%j = (-(c(18)*M(2,:)%j)+c(17)*M(3,:)%j) * den(328)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(485),h0tab(:,485),[32,11,4,16],[0,0,0,0],4,1,wf12(:,28))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,362),heltab2x96(:,:,467))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(162),n2h48(310))
Gcoeff(:)%j = (-(c(16)*M(2,:)%j)+c(15)*M(3,:)%j) * den(328)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(486),h0tab(:,486),[32,11,4,16],[nMB,nMB,nMB,nMB],4,1,wf12(:,28))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,363),heltab2x96(:,:,468))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMB,G1H48(163),n2h48(311))
Gcoeff(:)%j = (c(20)*M(2,:)%j-c(19)*M(3,:)%j) * den(328)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(487),h0tab(:,487),[32,4,11,16],[0,0,0,0],4,1,wf12(:,28))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,364),heltab2x96(:,:,469))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(164),n2h48(312))
Gcoeff(:)%j = (c(18)*M(2,:)%j-c(17)*M(3,:)%j) * den(328)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(488),h0tab(:,488),[32,4,11,16],[nMT,nMT,nMT,nMT],4,1,wf12(:,28))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,365),heltab2x96(:,:,470))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(165),n2h48(313))
Gcoeff(:)%j = (c(20)*M(1,:)%j-c(19)*M(3,:)%j) * den(328)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(489),h0tab(:,489),[32,4,11,16],[0,0,0,0],4,1,wf12(:,28))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,366),heltab2x96(:,:,471))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(166),n2h48(314))
Gcoeff(:)%j = (c(18)*M(1,:)%j-c(17)*M(3,:)%j) * den(328)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(490),h0tab(:,490),[32,4,11,16],[nMT,nMT,nMT,nMT],4,1,wf12(:,28))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,367),heltab2x96(:,:,472))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(167),n2h48(315))
Gcoeff(:)%j = (-(c(18)*M(2,:)%j)+c(17)*M(3,:)%j) * den(328)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(491),h0tab(:,491),[32,4,11,16],[0,0,0,0],4,1,wf12(:,28))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,368),heltab2x96(:,:,473))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(168),n2h48(316))
Gcoeff(:)%j = (-(c(16)*M(2,:)%j)+c(15)*M(3,:)%j) * den(328)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(492),h0tab(:,492),[32,4,11,16],[nMB,nMB,nMB,nMB],4,1,wf12(:,28))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,369),heltab2x96(:,:,474))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMB,G1H48(169),n2h48(317))
Gcoeff(:)%j = (-(c(18)*M(1,:)%j)+c(17)*M(3,:)%j) * den(328)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(493),h0tab(:,493),[32,4,11,16],[0,0,0,0],4,1,wf12(:,28))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,370),heltab2x96(:,:,475))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(170),n2h48(318))
Gcoeff(:)%j = (-(c(16)*M(1,:)%j)+c(15)*M(3,:)%j) * den(328)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(494),h0tab(:,494),[32,4,11,16],[nMB,nMB,nMB,nMB],4,1,wf12(:,28))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,371),heltab2x96(:,:,476))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMB,G1H48(171),n2h48(319))
Gcoeff(:)%j = (-(c(4)*M(3,:)%j)) * den(61)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(495),h0tab(:,495),[32,1,16,14],[0,nMT,nMT,0],4,1,wf12(:,22))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(172),m3h2x48(:,372),heltab2x96(:,:,477))
Gcoeff(:)%j = (c(4)*M(3,:)%j) * den(61)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(496),h0tab(:,496),[32,1,16,14],[nMT,0,0,nMT],4,1,wf12(:,22))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,373),heltab2x96(:,:,478))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(173),n2h48(320))
Gcoeff(:)%j = (c(8)*M(2,:)%j-c(9)*M(3,:)%j) * den(61)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(497),h0tab(:,497),[32,14,1,16],[nMT,0,nMT,nMT],4,1,wf12(:,22))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,374),heltab2x96(:,:,479))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(174),n2h48(321))
Gcoeff(:)%j = (-(c(11)*M(2,:)%j)-c(9)*M(3,:)%j) * den(61)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(498),h0tab(:,498),[32,14,1,16],[0,nMT,0,0],4,1,wf12(:,22))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(175),m3h2x48(:,375),heltab2x96(:,:,480))
Gcoeff(:)%j = (c(8)*M(1,:)%j-c(9)*M(3,:)%j) * den(61)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(499),h0tab(:,499),[32,1,14,16],[nMT,0,nMT,nMT],4,1,wf12(:,22))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,376),heltab2x96(:,:,481))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(176),n2h48(322))
Gcoeff(:)%j = (-(c(11)*M(1,:)%j)-c(9)*M(3,:)%j) * den(61)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(500),h0tab(:,500),[32,1,14,16],[0,nMT,0,0],4,1,wf12(:,22))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(177),m3h2x48(:,377),heltab2x96(:,:,482))
Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(10)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(501),h0tab(:,501),[32,1,4,26],[0,nMT,nMT,0],4,1,wf12(:,3))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(178),m3h2x48(:,378),heltab2x96(:,:,483))
Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(10)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(502),h0tab(:,502),[32,4,1,26],[nMT,nMT,0,nMT],4,1,wf12(:,3))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,379),heltab2x96(:,:,484))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(179),n2h48(323))
Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(10)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(503),h0tab(:,503),[32,1,26,4],[nMT,0,nMT,nMT],4,1,wf12(:,3))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,380),heltab2x96(:,:,485))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(180),n2h48(324))
Gcoeff(:)%j = (-(c(6)*M(2,:)%j)) * den(90)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(504),h0tab(:,504),[42,4,1,16],[nMT,nMT,0,0],4,1,wf12(:,31))
  call Hloop_VA_Q(ntryL,G0H96(1),wf12(:,31),G0H8(4),m3h12x8(:,4),heltab2x96(:,:,486))
  call Hloop_A_Q(ntryL,G0H8(4),42,nMT,G1H8(68),n2h8(216))
Gcoeff(:)%j = (c(8)*M(2,:)%j) * den(90)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(505),h0tab(:,505),[42,1,4,16],[0,nMT,nMT,nMT],4,1,wf12(:,31))
  call Hloop_QA_V(ntryL,G0H96(1),wf12(:,31),G0H8(5),m3h12x8(:,5),heltab2x96(:,:,487))
Gcoeff(:)%j = (c(8)*M(2,:)%j) * den(90)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(506),h0tab(:,506),[42,1,16,4],[0,nMT,nMT,nMT],4,1,wf12(:,31))
  call Hloop_QA_V(ntryL,G0H96(1),wf12(:,31),G0H8(6),m3h12x8(:,6),heltab2x96(:,:,488))
Gcoeff(:)%j = (-(c(10)*M(2,:)%j)) * den(384)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(507),h0tab(:,507),[34,8,4,17],[nMT,nMT,nMT,0],4,2,wf4(:,7),wf4(:,11))
  call Hloop_VA_Q(ntryL,G0H96(1),wf4(:,7),G0H24(18),m3h4x24(:,73),heltab2x96(:,:,489))
  call Hloop_A_Q(ntryL,G0H24(18),34,nMT,G1H24(84),n2h24(197))
Gcoeff(:)%j = (-(c(10)*M(2,:)%j)) * den(384)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(508),h0tab(:,508),[34,4,8,17],[nMT,nMT,nMT,0],4,2,wf4(:,7),wf4(:,11))
  call Hloop_VA_Q(ntryL,G0H96(1),wf4(:,7),G0H24(18),m3h4x24(:,74),heltab2x96(:,:,490))
  call Hloop_A_Q(ntryL,G0H24(18),34,nMT,G1H24(7),n2h24(198))
Gcoeff(:)%j = (c(20)*M(2,:)%j) * den(340)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(509),h0tab(:,509),[32,4,8,19],[0,0,0,0],4,1,wf8(:,29))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,381),heltab2x96(:,:,491))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(181),n2h48(325))
Gcoeff(:)%j = (c(18)*M(2,:)%j) * den(340)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(510),h0tab(:,510),[32,4,8,19],[nMT,nMT,nMT,nMT],4,1,wf8(:,29))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,382),heltab2x96(:,:,492))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(182),n2h48(326))
Gcoeff(:)%j = (c(20)*M(2,:)%j) * den(340)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(511),h0tab(:,511),[32,4,8,19],[0,0,0,0],4,1,wf8(:,29))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,383),heltab2x96(:,:,493))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(183),n2h48(327))
Gcoeff(:)%j = (c(18)*M(2,:)%j) * den(340)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(512),h0tab(:,512),[32,4,8,19],[nMT,nMT,nMT,nMT],4,1,wf8(:,29))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,384),heltab2x96(:,:,494))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(184),n2h48(328))
Gcoeff(:)%j = (-(c(18)*M(2,:)%j)) * den(340)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(513),h0tab(:,513),[32,4,8,19],[0,0,0,0],4,1,wf8(:,29))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,385),heltab2x96(:,:,495))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(185),n2h48(329))
Gcoeff(:)%j = (-(c(16)*M(2,:)%j)) * den(340)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(514),h0tab(:,514),[32,4,8,19],[nMB,nMB,nMB,nMB],4,1,wf8(:,29))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,386),heltab2x96(:,:,496))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMB,G1H48(186),n2h48(330))
Gcoeff(:)%j = (-(c(18)*M(2,:)%j)) * den(340)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(515),h0tab(:,515),[32,4,8,19],[0,0,0,0],4,1,wf8(:,29))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,387),heltab2x96(:,:,497))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(187),n2h48(331))
Gcoeff(:)%j = (-(c(16)*M(2,:)%j)) * den(340)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(516),h0tab(:,516),[32,4,8,19],[nMB,nMB,nMB,nMB],4,1,wf8(:,29))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,388),heltab2x96(:,:,498))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMB,G1H48(188),n2h48(332))
Gcoeff(:)%j = (c(20)*M(2,:)%j) * den(340)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(517),h0tab(:,517),[32,8,4,19],[0,0,0,0],4,1,wf8(:,29))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,389),heltab2x96(:,:,499))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(189),n2h48(333))
Gcoeff(:)%j = (c(18)*M(2,:)%j) * den(340)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(518),h0tab(:,518),[32,8,4,19],[nMT,nMT,nMT,nMT],4,1,wf8(:,29))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,390),heltab2x96(:,:,500))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(190),n2h48(334))
Gcoeff(:)%j = (c(20)*M(2,:)%j) * den(340)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(519),h0tab(:,519),[32,8,4,19],[0,0,0,0],4,1,wf8(:,29))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,391),heltab2x96(:,:,501))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(191),n2h48(335))
Gcoeff(:)%j = (c(18)*M(2,:)%j) * den(340)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(520),h0tab(:,520),[32,8,4,19],[nMT,nMT,nMT,nMT],4,1,wf8(:,29))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,392),heltab2x96(:,:,502))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(192),n2h48(336))
Gcoeff(:)%j = (-(c(18)*M(2,:)%j)) * den(340)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(521),h0tab(:,521),[32,8,4,19],[0,0,0,0],4,1,wf8(:,29))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,393),heltab2x96(:,:,503))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(193),n2h48(337))
Gcoeff(:)%j = (-(c(16)*M(2,:)%j)) * den(340)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(522),h0tab(:,522),[32,8,4,19],[nMB,nMB,nMB,nMB],4,1,wf8(:,29))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,394),heltab2x96(:,:,504))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMB,G1H48(194),n2h48(338))
Gcoeff(:)%j = (-(c(18)*M(2,:)%j)) * den(340)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(523),h0tab(:,523),[32,8,4,19],[0,0,0,0],4,1,wf8(:,29))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,395),heltab2x96(:,:,505))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(195),n2h48(339))
Gcoeff(:)%j = (-(c(16)*M(2,:)%j)) * den(340)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(524),h0tab(:,524),[32,8,4,19],[nMB,nMB,nMB,nMB],4,1,wf8(:,29))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,396),heltab2x96(:,:,506))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMB,G1H48(196),n2h48(340))
Gcoeff(:)%j = (c(20)*M(2,:)%j) * den(340)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(525),h0tab(:,525),[32,4,19,8],[0,0,0,0],4,1,wf8(:,29))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,397),heltab2x96(:,:,507))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(197),n2h48(341))
Gcoeff(:)%j = (c(18)*M(2,:)%j) * den(340)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(526),h0tab(:,526),[32,4,19,8],[nMT,nMT,nMT,nMT],4,1,wf8(:,29))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,398),heltab2x96(:,:,508))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(198),n2h48(342))
Gcoeff(:)%j = (c(20)*M(2,:)%j) * den(340)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(527),h0tab(:,527),[32,4,19,8],[0,0,0,0],4,1,wf8(:,29))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,399),heltab2x96(:,:,509))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(199),n2h48(343))
Gcoeff(:)%j = (c(18)*M(2,:)%j) * den(340)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(528),h0tab(:,528),[32,4,19,8],[nMT,nMT,nMT,nMT],4,1,wf8(:,29))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,400),heltab2x96(:,:,510))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(200),n2h48(344))
Gcoeff(:)%j = (-(c(18)*M(2,:)%j)) * den(340)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(529),h0tab(:,529),[32,4,19,8],[0,0,0,0],4,1,wf8(:,29))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,401),heltab2x96(:,:,511))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(201),n2h48(345))
Gcoeff(:)%j = (-(c(16)*M(2,:)%j)) * den(340)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(530),h0tab(:,530),[32,4,19,8],[nMB,nMB,nMB,nMB],4,1,wf8(:,29))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,402),heltab2x96(:,:,512))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMB,G1H48(202),n2h48(346))
Gcoeff(:)%j = (-(c(18)*M(2,:)%j)) * den(340)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(531),h0tab(:,531),[32,4,19,8],[0,0,0,0],4,1,wf8(:,29))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,403),heltab2x96(:,:,513))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(203),n2h48(347))
Gcoeff(:)%j = (-(c(16)*M(2,:)%j)) * den(340)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(532),h0tab(:,532),[32,4,19,8],[nMB,nMB,nMB,nMB],4,1,wf8(:,29))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,404),heltab2x96(:,:,514))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMB,G1H48(204),n2h48(348))
Gcoeff(:)%j = (-(c(6)*M(2,:)%j)) * den(59)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(533),h0tab(:,533),[32,2,8,21],[0,nMT,nMT,0],4,1,wf8(:,20))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(205),m3h2x48(:,405),heltab2x96(:,:,515))
Gcoeff(:)%j = (c(8)*M(2,:)%j) * den(59)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(534),h0tab(:,534),[32,8,2,21],[nMT,nMT,0,nMT],4,1,wf8(:,20))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,406),heltab2x96(:,:,516))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(206),n2h48(349))
Gcoeff(:)%j = (c(8)*M(2,:)%j) * den(59)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(535),h0tab(:,535),[32,2,21,8],[nMT,0,nMT,nMT],4,1,wf8(:,20))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,407),heltab2x96(:,:,517))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(207),n2h48(350))
Gcoeff(:)%j = (-(c(6)*M(2,:)%j)) * den(37)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(536),h0tab(:,536),[32,2,4,25],[0,nMT,nMT,0],4,1,wf12(:,14))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(208),m3h2x48(:,408),heltab2x96(:,:,518))
Gcoeff(:)%j = (c(8)*M(2,:)%j) * den(37)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(537),h0tab(:,537),[32,4,2,25],[nMT,nMT,0,nMT],4,1,wf12(:,14))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,409),heltab2x96(:,:,519))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(209),n2h48(351))
Gcoeff(:)%j = (c(8)*M(2,:)%j) * den(37)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(538),h0tab(:,538),[32,2,25,4],[nMT,0,nMT,nMT],4,1,wf12(:,14))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,410),heltab2x96(:,:,520))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(210),n2h48(352))
Gcoeff(:)%j = (-(c(10)*M(2,:)%j)) * den(117)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(539),h0tab(:,539),[49,2,4,8],[0,nMT,nMT,nMT],4,1,wf8(:,49))
  call Hloop_AQ_V(ntryL,G0H96(1),wf8(:,49),G0H12(15),m3h8x12(:,31),heltab2x96(:,:,521))
Gcoeff(:)%j = (-(c(10)*M(2,:)%j)) * den(117)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(540),h0tab(:,540),[49,2,8,4],[0,nMT,nMT,nMT],4,1,wf8(:,49))
  call Hloop_AQ_V(ntryL,G0H96(1),wf8(:,49),G0H12(16),m3h8x12(:,32),heltab2x96(:,:,522))
Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(385)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(541),h0tab(:,541),[33,4,8,18],[nMT,nMT,nMT,0],4,2,wf4(:,13),wf4(:,5))
  call Hloop_VQ_A(ntryL,G0H96(1),wf4(:,13),G0H24(18),m3h4x24(:,75),heltab2x96(:,:,523))
  call Hloop_Q_A(ntryL,G0H24(18),33,nMT,G1H24(59),n2h24(199))
Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(385)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(542),h0tab(:,542),[33,8,4,18],[nMT,nMT,nMT,0],4,2,wf4(:,13),wf4(:,5))
  call Hloop_VQ_A(ntryL,G0H96(1),wf4(:,13),G0H24(18),m3h4x24(:,76),heltab2x96(:,:,524))
  call Hloop_Q_A(ntryL,G0H24(18),33,nMT,G1H24(27),n2h24(200))
Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(349)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(543),h0tab(:,543),[32,4,8,19],[0,0,0,0],4,1,wf8(:,30))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,411),heltab2x96(:,:,525))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(211),n2h48(353))
Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(349)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(544),h0tab(:,544),[32,4,8,19],[nMT,nMT,nMT,nMT],4,1,wf8(:,30))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,412),heltab2x96(:,:,526))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(212),n2h48(354))
Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(349)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(545),h0tab(:,545),[32,4,8,19],[0,0,0,0],4,1,wf8(:,30))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,413),heltab2x96(:,:,527))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(213),n2h48(355))
Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(349)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(546),h0tab(:,546),[32,4,8,19],[nMT,nMT,nMT,nMT],4,1,wf8(:,30))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,414),heltab2x96(:,:,528))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(214),n2h48(356))
Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(349)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(547),h0tab(:,547),[32,4,8,19],[0,0,0,0],4,1,wf8(:,30))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,415),heltab2x96(:,:,529))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(215),n2h48(357))
Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(349)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(548),h0tab(:,548),[32,4,8,19],[nMB,nMB,nMB,nMB],4,1,wf8(:,30))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,416),heltab2x96(:,:,530))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMB,G1H48(216),n2h48(358))
Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(349)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(549),h0tab(:,549),[32,4,8,19],[0,0,0,0],4,1,wf8(:,30))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,417),heltab2x96(:,:,531))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(217),n2h48(359))
Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(349)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(550),h0tab(:,550),[32,4,8,19],[nMB,nMB,nMB,nMB],4,1,wf8(:,30))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,418),heltab2x96(:,:,532))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMB,G1H48(218),n2h48(360))
Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(349)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(551),h0tab(:,551),[32,8,4,19],[0,0,0,0],4,1,wf8(:,30))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,419),heltab2x96(:,:,533))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(219),n2h48(361))
Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(349)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(552),h0tab(:,552),[32,8,4,19],[nMT,nMT,nMT,nMT],4,1,wf8(:,30))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,420),heltab2x96(:,:,534))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(220),n2h48(362))
Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(349)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(553),h0tab(:,553),[32,8,4,19],[0,0,0,0],4,1,wf8(:,30))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,421),heltab2x96(:,:,535))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(221),n2h48(363))
Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(349)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(554),h0tab(:,554),[32,8,4,19],[nMT,nMT,nMT,nMT],4,1,wf8(:,30))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,422),heltab2x96(:,:,536))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(222),n2h48(364))
Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(349)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(555),h0tab(:,555),[32,8,4,19],[0,0,0,0],4,1,wf8(:,30))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,423),heltab2x96(:,:,537))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(223),n2h48(365))
Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(349)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(556),h0tab(:,556),[32,8,4,19],[nMB,nMB,nMB,nMB],4,1,wf8(:,30))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,424),heltab2x96(:,:,538))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMB,G1H48(224),n2h48(366))
Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(349)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(557),h0tab(:,557),[32,8,4,19],[0,0,0,0],4,1,wf8(:,30))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,425),heltab2x96(:,:,539))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(225),n2h48(367))
Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(349)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(558),h0tab(:,558),[32,8,4,19],[nMB,nMB,nMB,nMB],4,1,wf8(:,30))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,426),heltab2x96(:,:,540))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMB,G1H48(226),n2h48(368))
Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(349)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(559),h0tab(:,559),[32,4,19,8],[0,0,0,0],4,1,wf8(:,30))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,427),heltab2x96(:,:,541))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(227),n2h48(369))
Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(349)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(560),h0tab(:,560),[32,4,19,8],[nMT,nMT,nMT,nMT],4,1,wf8(:,30))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,428),heltab2x96(:,:,542))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(228),n2h48(370))
Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(349)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(561),h0tab(:,561),[32,4,19,8],[0,0,0,0],4,1,wf8(:,30))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,429),heltab2x96(:,:,543))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(229),n2h48(371))
Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(349)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(562),h0tab(:,562),[32,4,19,8],[nMT,nMT,nMT,nMT],4,1,wf8(:,30))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,430),heltab2x96(:,:,544))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(230),n2h48(372))
Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(349)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(563),h0tab(:,563),[32,4,19,8],[0,0,0,0],4,1,wf8(:,30))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,431),heltab2x96(:,:,545))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(231),n2h48(373))
Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(349)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(564),h0tab(:,564),[32,4,19,8],[nMB,nMB,nMB,nMB],4,1,wf8(:,30))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,432),heltab2x96(:,:,546))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMB,G1H48(232),n2h48(374))
Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(349)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(565),h0tab(:,565),[32,4,19,8],[0,0,0,0],4,1,wf8(:,30))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,433),heltab2x96(:,:,547))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(233),n2h48(375))
Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(349)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(566),h0tab(:,566),[32,4,19,8],[nMB,nMB,nMB,nMB],4,1,wf8(:,30))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,434),heltab2x96(:,:,548))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMB,G1H48(234),n2h48(376))
Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(52)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(567),h0tab(:,567),[32,1,8,22],[0,nMT,nMT,0],4,1,wf8(:,16))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(235),m3h2x48(:,435),heltab2x96(:,:,549))
Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(52)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(568),h0tab(:,568),[32,8,1,22],[nMT,nMT,0,nMT],4,1,wf8(:,16))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,436),heltab2x96(:,:,550))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(236),n2h48(377))
Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(52)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(569),h0tab(:,569),[32,1,22,8],[nMT,0,nMT,nMT],4,1,wf8(:,16))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,437),heltab2x96(:,:,551))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(237),n2h48(378))
Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(16)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(570),h0tab(:,570),[32,1,4,26],[0,nMT,nMT,0],4,1,wf12(:,7))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(238),m3h2x48(:,438),heltab2x96(:,:,552))
Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(16)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(571),h0tab(:,571),[32,4,1,26],[nMT,nMT,0,nMT],4,1,wf12(:,7))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,439),heltab2x96(:,:,553))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(239),n2h48(379))
Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(16)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(572),h0tab(:,572),[32,1,26,4],[nMT,0,nMT,nMT],4,1,wf12(:,7))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,440),heltab2x96(:,:,554))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(240),n2h48(380))
Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(93)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(573),h0tab(:,573),[50,1,4,8],[0,nMT,nMT,nMT],4,1,wf8(:,40))
  call Hloop_QA_V(ntryL,G0H96(1),wf8(:,40),G0H12(1),m3h8x12(:,33),heltab2x96(:,:,555))
Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(93)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(574),h0tab(:,574),[50,1,8,4],[0,nMT,nMT,nMT],4,1,wf8(:,40))
  call Hloop_QA_V(ntryL,G0H96(1),wf8(:,40),G0H12(2),m3h8x12(:,34),heltab2x96(:,:,556))
Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(358)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(575),h0tab(:,575),[35,8,4,16],[0,0,0,0],4,1,wf8(:,31))
  call Hloop_QV_A(ntryL,G0H96(1),wf8(:,31),G0H12(3),m3h8x12(:,35),heltab2x96(:,:,557))
  call Hloop_Q_A(ntryL,G0H12(3),35,0,G1H12(250),n2h12(389))
Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(358)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(576),h0tab(:,576),[35,8,4,16],[nMT,nMT,nMT,nMT],4,1,wf8(:,31))
  call Hloop_QV_A(ntryL,G0H96(1),wf8(:,31),G0H12(4),m3h8x12(:,36),heltab2x96(:,:,558))
  call Hloop_Q_A(ntryL,G0H12(4),35,nMT,G1H12(251),n2h12(390))
Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(358)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(577),h0tab(:,577),[35,8,4,16],[0,0,0,0],4,1,wf8(:,31))
  call Hloop_AV_Q(ntryL,G0H96(1),wf8(:,31),G0H12(5),m3h8x12(:,37),heltab2x96(:,:,559))
  call Hloop_A_Q(ntryL,G0H12(5),35,0,G1H12(269),n2h12(391))
Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(358)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(578),h0tab(:,578),[35,8,4,16],[nMT,nMT,nMT,nMT],4,1,wf8(:,31))
  call Hloop_AV_Q(ntryL,G0H96(1),wf8(:,31),G0H12(6),m3h8x12(:,38),heltab2x96(:,:,560))
  call Hloop_A_Q(ntryL,G0H12(6),35,nMT,G1H12(270),n2h12(392))
Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(358)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(579),h0tab(:,579),[35,8,4,16],[0,0,0,0],4,1,wf8(:,31))
  call Hloop_QV_A(ntryL,G0H96(1),wf8(:,31),G0H12(7),m3h8x12(:,39),heltab2x96(:,:,561))
  call Hloop_Q_A(ntryL,G0H12(7),35,0,G1H12(288),n2h12(393))
Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(358)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(580),h0tab(:,580),[35,8,4,16],[nMB,nMB,nMB,nMB],4,1,wf8(:,31))
  call Hloop_QV_A(ntryL,G0H96(1),wf8(:,31),G0H12(8),m3h8x12(:,40),heltab2x96(:,:,562))
  call Hloop_Q_A(ntryL,G0H12(8),35,nMB,G1H12(290),n2h12(394))
Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(358)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(581),h0tab(:,581),[35,8,4,16],[0,0,0,0],4,1,wf8(:,31))
  call Hloop_AV_Q(ntryL,G0H96(1),wf8(:,31),G0H12(9),m3h8x12(:,41),heltab2x96(:,:,563))
  call Hloop_A_Q(ntryL,G0H12(9),35,0,G1H12(308),n2h12(395))
Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(358)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(582),h0tab(:,582),[35,8,4,16],[nMB,nMB,nMB,nMB],4,1,wf8(:,31))
  call Hloop_AV_Q(ntryL,G0H96(1),wf8(:,31),G0H12(12),m3h8x12(:,42),heltab2x96(:,:,564))
  call Hloop_A_Q(ntryL,G0H12(12),35,nMB,G1H12(309),n2h12(396))
Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(358)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(583),h0tab(:,583),[35,4,8,16],[0,0,0,0],4,1,wf8(:,31))
  call Hloop_AV_Q(ntryL,G0H96(1),wf8(:,31),G0H12(3),m3h8x12(:,43),heltab2x96(:,:,565))
  call Hloop_A_Q(ntryL,G0H12(3),35,0,G1H12(327),n2h12(397))
Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(358)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(584),h0tab(:,584),[35,4,8,16],[nMT,nMT,nMT,nMT],4,1,wf8(:,31))
  call Hloop_AV_Q(ntryL,G0H96(1),wf8(:,31),G0H12(4),m3h8x12(:,44),heltab2x96(:,:,566))
  call Hloop_A_Q(ntryL,G0H12(4),35,nMT,G1H12(328),n2h12(398))
Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(358)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(585),h0tab(:,585),[35,4,8,16],[0,0,0,0],4,1,wf8(:,31))
  call Hloop_QV_A(ntryL,G0H96(1),wf8(:,31),G0H12(5),m3h8x12(:,45),heltab2x96(:,:,567))
  call Hloop_Q_A(ntryL,G0H12(5),35,0,G1H12(346),n2h12(399))
Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(358)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(586),h0tab(:,586),[35,4,8,16],[nMT,nMT,nMT,nMT],4,1,wf8(:,31))
  call Hloop_QV_A(ntryL,G0H96(1),wf8(:,31),G0H12(6),m3h8x12(:,46),heltab2x96(:,:,568))
  call Hloop_Q_A(ntryL,G0H12(6),35,nMT,G1H12(347),n2h12(400))
Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(358)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(587),h0tab(:,587),[35,4,8,16],[0,0,0,0],4,1,wf8(:,31))
  call Hloop_AV_Q(ntryL,G0H96(1),wf8(:,31),G0H12(7),m3h8x12(:,47),heltab2x96(:,:,569))
  call Hloop_A_Q(ntryL,G0H12(7),35,0,G1H12(108),n2h12(401))
Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(358)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(588),h0tab(:,588),[35,4,8,16],[nMB,nMB,nMB,nMB],4,1,wf8(:,31))
  call Hloop_AV_Q(ntryL,G0H96(1),wf8(:,31),G0H12(8),m3h8x12(:,48),heltab2x96(:,:,570))
  call Hloop_A_Q(ntryL,G0H12(8),35,nMB,G1H12(110),n2h12(402))
Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(358)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(589),h0tab(:,589),[35,4,8,16],[0,0,0,0],4,1,wf8(:,31))
  call Hloop_QV_A(ntryL,G0H96(1),wf8(:,31),G0H12(9),m3h8x12(:,49),heltab2x96(:,:,571))
  call Hloop_Q_A(ntryL,G0H12(9),35,0,G1H12(138),n2h12(403))
Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(358)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(590),h0tab(:,590),[35,4,8,16],[nMB,nMB,nMB,nMB],4,1,wf8(:,31))
  call Hloop_QV_A(ntryL,G0H96(1),wf8(:,31),G0H12(12),m3h8x12(:,50),heltab2x96(:,:,572))
  call Hloop_Q_A(ntryL,G0H12(12),35,nMB,G1H12(139),n2h12(404))
Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(358)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(591),h0tab(:,591),[35,4,16,8],[0,0,0,0],4,1,wf8(:,31))
  call Hloop_AV_Q(ntryL,G0H96(1),wf8(:,31),G0H12(3),m3h8x12(:,51),heltab2x96(:,:,573))
  call Hloop_A_Q(ntryL,G0H12(3),35,0,G1H12(365),n2h12(405))
Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(358)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(592),h0tab(:,592),[35,4,16,8],[nMT,nMT,nMT,nMT],4,1,wf8(:,31))
  call Hloop_AV_Q(ntryL,G0H96(1),wf8(:,31),G0H12(4),m3h8x12(:,52),heltab2x96(:,:,574))
  call Hloop_A_Q(ntryL,G0H12(4),35,nMT,G1H12(366),n2h12(406))
Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(358)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(593),h0tab(:,593),[35,4,16,8],[0,0,0,0],4,1,wf8(:,31))
  call Hloop_QV_A(ntryL,G0H96(1),wf8(:,31),G0H12(5),m3h8x12(:,53),heltab2x96(:,:,575))
  call Hloop_Q_A(ntryL,G0H12(5),35,0,G1H12(384),n2h12(407))
Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(358)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(594),h0tab(:,594),[35,4,16,8],[nMT,nMT,nMT,nMT],4,1,wf8(:,31))
  call Hloop_QV_A(ntryL,G0H96(1),wf8(:,31),G0H12(6),m3h8x12(:,54),heltab2x96(:,:,576))
  call Hloop_Q_A(ntryL,G0H12(6),35,nMT,G1H12(386),n2h12(408))
Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(358)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(595),h0tab(:,595),[35,4,16,8],[0,0,0,0],4,1,wf8(:,31))
  call Hloop_AV_Q(ntryL,G0H96(1),wf8(:,31),G0H12(7),m3h8x12(:,55),heltab2x96(:,:,577))
  call Hloop_A_Q(ntryL,G0H12(7),35,0,G1H12(175),n2h12(409))
Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(358)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(596),h0tab(:,596),[35,4,16,8],[nMB,nMB,nMB,nMB],4,1,wf8(:,31))
  call Hloop_AV_Q(ntryL,G0H96(1),wf8(:,31),G0H12(8),m3h8x12(:,56),heltab2x96(:,:,578))
  call Hloop_A_Q(ntryL,G0H12(8),35,nMB,G1H12(176),n2h12(410))
Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(358)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(597),h0tab(:,597),[35,4,16,8],[0,0,0,0],4,1,wf8(:,31))
  call Hloop_QV_A(ntryL,G0H96(1),wf8(:,31),G0H12(9),m3h8x12(:,57),heltab2x96(:,:,579))
  call Hloop_Q_A(ntryL,G0H12(9),35,0,G1H12(210),n2h12(411))
Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(358)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(598),h0tab(:,598),[35,4,16,8],[nMB,nMB,nMB,nMB],4,1,wf8(:,31))
  call Hloop_QV_A(ntryL,G0H96(1),wf8(:,31),G0H12(12),m3h8x12(:,58),heltab2x96(:,:,580))
  call Hloop_Q_A(ntryL,G0H12(12),35,nMB,G1H12(212),n2h12(412))
Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(64)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(599),h0tab(:,599),[37,8,2,16],[nMT,nMT,0,0],4,1,wf8(:,22))
  call Hloop_VQ_A(ntryL,G0H96(1),wf8(:,22),G0H12(3),m3h8x12(:,59),heltab2x96(:,:,581))
  call Hloop_Q_A(ntryL,G0H12(3),37,nMT,G1H12(12),n2h12(413))
Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(64)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(600),h0tab(:,600),[37,2,8,16],[0,nMT,nMT,nMT],4,1,wf8(:,22))
  call Hloop_AQ_V(ntryL,G0H96(1),wf8(:,22),G0H12(4),m3h8x12(:,60),heltab2x96(:,:,582))
Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(64)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(601),h0tab(:,601),[37,2,16,8],[0,nMT,nMT,nMT],4,1,wf8(:,22))
  call Hloop_AQ_V(ntryL,G0H96(1),wf8(:,22),G0H12(5),m3h8x12(:,61),heltab2x96(:,:,583))
Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(44)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(602),h0tab(:,602),[41,4,2,16],[nMT,nMT,0,0],4,1,wf12(:,18))
  call Hloop_VQ_A(ntryL,G0H96(1),wf12(:,18),G0H8(7),m3h12x8(:,7),heltab2x96(:,:,584))
  call Hloop_Q_A(ntryL,G0H8(7),41,nMT,G1H8(5),n2h8(217))
Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(44)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(603),h0tab(:,603),[41,2,4,16],[0,nMT,nMT,nMT],4,1,wf12(:,18))
  call Hloop_AQ_V(ntryL,G0H96(1),wf12(:,18),G0H8(8),m3h12x8(:,8),heltab2x96(:,:,585))
Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(44)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(604),h0tab(:,604),[41,2,16,4],[0,nMT,nMT,nMT],4,1,wf12(:,18))
  call Hloop_AQ_V(ntryL,G0H96(1),wf12(:,18),G0H8(9),m3h12x8(:,9),heltab2x96(:,:,586))
Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(122)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(605),h0tab(:,605),[49,2,4,8],[0,nMT,nMT,nMT],4,1,wf8(:,50))
  call Hloop_AQ_V(ntryL,G0H96(1),wf8(:,50),G0H12(6),m3h8x12(:,62),heltab2x96(:,:,587))
Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(122)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(606),h0tab(:,606),[49,2,8,4],[0,nMT,nMT,nMT],4,1,wf8(:,50))
  call Hloop_AQ_V(ntryL,G0H96(1),wf8(:,50),G0H12(7),m3h8x12(:,63),heltab2x96(:,:,588))
Gcoeff(:)%j = (c(20)*M(2,:)%j) * den(367)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(607),h0tab(:,607),[35,8,4,16],[0,0,0,0],4,1,wf8(:,32))
  call Hloop_QV_A(ntryL,G0H96(1),wf8(:,32),G0H12(8),m3h8x12(:,64),heltab2x96(:,:,589))
  call Hloop_Q_A(ntryL,G0H12(8),35,0,G1H12(14),n2h12(414))
Gcoeff(:)%j = (c(18)*M(2,:)%j) * den(367)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(608),h0tab(:,608),[35,8,4,16],[nMT,nMT,nMT,nMT],4,1,wf8(:,32))
  call Hloop_QV_A(ntryL,G0H96(1),wf8(:,32),G0H12(9),m3h8x12(:,65),heltab2x96(:,:,590))
  call Hloop_Q_A(ntryL,G0H12(9),35,nMT,G1H12(19),n2h12(415))
Gcoeff(:)%j = (c(20)*M(2,:)%j) * den(367)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(609),h0tab(:,609),[35,8,4,16],[0,0,0,0],4,1,wf8(:,32))
  call Hloop_AV_Q(ntryL,G0H96(1),wf8(:,32),G0H12(12),m3h8x12(:,66),heltab2x96(:,:,591))
  call Hloop_A_Q(ntryL,G0H12(12),35,0,G1H12(20),n2h12(416))
Gcoeff(:)%j = (c(18)*M(2,:)%j) * den(367)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(610),h0tab(:,610),[35,8,4,16],[nMT,nMT,nMT,nMT],4,1,wf8(:,32))
  call Hloop_AV_Q(ntryL,G0H96(1),wf8(:,32),G0H12(3),m3h8x12(:,67),heltab2x96(:,:,592))
  call Hloop_A_Q(ntryL,G0H12(3),35,nMT,G1H12(24),n2h12(417))
Gcoeff(:)%j = (-(c(18)*M(2,:)%j)) * den(367)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(611),h0tab(:,611),[35,8,4,16],[0,0,0,0],4,1,wf8(:,32))
  call Hloop_QV_A(ntryL,G0H96(1),wf8(:,32),G0H12(8),m3h8x12(:,68),heltab2x96(:,:,593))
  call Hloop_Q_A(ntryL,G0H12(8),35,0,G1H12(25),n2h12(418))
Gcoeff(:)%j = (-(c(16)*M(2,:)%j)) * den(367)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(612),h0tab(:,612),[35,8,4,16],[nMB,nMB,nMB,nMB],4,1,wf8(:,32))
  call Hloop_QV_A(ntryL,G0H96(1),wf8(:,32),G0H12(9),m3h8x12(:,69),heltab2x96(:,:,594))
  call Hloop_Q_A(ntryL,G0H12(9),35,nMB,G1H12(30),n2h12(419))
Gcoeff(:)%j = (-(c(18)*M(2,:)%j)) * den(367)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(613),h0tab(:,613),[35,8,4,16],[0,0,0,0],4,1,wf8(:,32))
  call Hloop_AV_Q(ntryL,G0H96(1),wf8(:,32),G0H12(12),m3h8x12(:,70),heltab2x96(:,:,595))
  call Hloop_A_Q(ntryL,G0H12(12),35,0,G1H12(32),n2h12(420))
Gcoeff(:)%j = (-(c(16)*M(2,:)%j)) * den(367)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(614),h0tab(:,614),[35,8,4,16],[nMB,nMB,nMB,nMB],4,1,wf8(:,32))
  call Hloop_AV_Q(ntryL,G0H96(1),wf8(:,32),G0H12(3),m3h8x12(:,71),heltab2x96(:,:,596))
  call Hloop_A_Q(ntryL,G0H12(3),35,nMB,G1H12(35),n2h12(421))
Gcoeff(:)%j = (c(20)*M(2,:)%j) * den(367)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(615),h0tab(:,615),[35,4,8,16],[0,0,0,0],4,1,wf8(:,32))
  call Hloop_AV_Q(ntryL,G0H96(1),wf8(:,32),G0H12(8),m3h8x12(:,72),heltab2x96(:,:,597))
  call Hloop_A_Q(ntryL,G0H12(8),35,0,G1H12(36),n2h12(422))
Gcoeff(:)%j = (c(18)*M(2,:)%j) * den(367)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(616),h0tab(:,616),[35,4,8,16],[nMT,nMT,nMT,nMT],4,1,wf8(:,32))
  call Hloop_AV_Q(ntryL,G0H96(1),wf8(:,32),G0H12(9),m3h8x12(:,73),heltab2x96(:,:,598))
  call Hloop_A_Q(ntryL,G0H12(9),35,nMT,G1H12(42),n2h12(423))
Gcoeff(:)%j = (c(20)*M(2,:)%j) * den(367)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(617),h0tab(:,617),[35,4,8,16],[0,0,0,0],4,1,wf8(:,32))
  call Hloop_QV_A(ntryL,G0H96(1),wf8(:,32),G0H12(12),m3h8x12(:,74),heltab2x96(:,:,599))
  call Hloop_Q_A(ntryL,G0H12(12),35,0,G1H12(43),n2h12(424))
Gcoeff(:)%j = (c(18)*M(2,:)%j) * den(367)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(618),h0tab(:,618),[35,4,8,16],[nMT,nMT,nMT,nMT],4,1,wf8(:,32))
  call Hloop_QV_A(ntryL,G0H96(1),wf8(:,32),G0H12(3),m3h8x12(:,75),heltab2x96(:,:,600))
  call Hloop_Q_A(ntryL,G0H12(3),35,nMT,G1H12(44),n2h12(425))
Gcoeff(:)%j = (-(c(18)*M(2,:)%j)) * den(367)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(619),h0tab(:,619),[35,4,8,16],[0,0,0,0],4,1,wf8(:,32))
  call Hloop_AV_Q(ntryL,G0H96(1),wf8(:,32),G0H12(8),m3h8x12(:,76),heltab2x96(:,:,601))
  call Hloop_A_Q(ntryL,G0H12(8),35,0,G1H12(47),n2h12(426))
Gcoeff(:)%j = (-(c(16)*M(2,:)%j)) * den(367)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(620),h0tab(:,620),[35,4,8,16],[nMB,nMB,nMB,nMB],4,1,wf8(:,32))
  call Hloop_AV_Q(ntryL,G0H96(1),wf8(:,32),G0H12(9),m3h8x12(:,77),heltab2x96(:,:,602))
  call Hloop_A_Q(ntryL,G0H12(9),35,nMB,G1H12(53),n2h12(427))
Gcoeff(:)%j = (-(c(18)*M(2,:)%j)) * den(367)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(621),h0tab(:,621),[35,4,8,16],[0,0,0,0],4,1,wf8(:,32))
  call Hloop_QV_A(ntryL,G0H96(1),wf8(:,32),G0H12(12),m3h8x12(:,78),heltab2x96(:,:,603))
  call Hloop_Q_A(ntryL,G0H12(12),35,0,G1H12(54),n2h12(428))
Gcoeff(:)%j = (-(c(16)*M(2,:)%j)) * den(367)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(622),h0tab(:,622),[35,4,8,16],[nMB,nMB,nMB,nMB],4,1,wf8(:,32))
  call Hloop_QV_A(ntryL,G0H96(1),wf8(:,32),G0H12(3),m3h8x12(:,79),heltab2x96(:,:,604))
  call Hloop_Q_A(ntryL,G0H12(3),35,nMB,G1H12(55),n2h12(429))
Gcoeff(:)%j = (c(20)*M(2,:)%j) * den(367)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(623),h0tab(:,623),[35,4,16,8],[0,0,0,0],4,1,wf8(:,32))
  call Hloop_AV_Q(ntryL,G0H96(1),wf8(:,32),G0H12(8),m3h8x12(:,80),heltab2x96(:,:,605))
  call Hloop_A_Q(ntryL,G0H12(8),35,0,G1H12(56),n2h12(430))
Gcoeff(:)%j = (c(18)*M(2,:)%j) * den(367)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(624),h0tab(:,624),[35,4,16,8],[nMT,nMT,nMT,nMT],4,1,wf8(:,32))
  call Hloop_AV_Q(ntryL,G0H96(1),wf8(:,32),G0H12(9),m3h8x12(:,81),heltab2x96(:,:,606))
  call Hloop_A_Q(ntryL,G0H12(9),35,nMT,G1H12(62),n2h12(431))
Gcoeff(:)%j = (c(20)*M(2,:)%j) * den(367)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(625),h0tab(:,625),[35,4,16,8],[0,0,0,0],4,1,wf8(:,32))
  call Hloop_QV_A(ntryL,G0H96(1),wf8(:,32),G0H12(12),m3h8x12(:,82),heltab2x96(:,:,607))
  call Hloop_Q_A(ntryL,G0H12(12),35,0,G1H12(65),n2h12(432))
Gcoeff(:)%j = (c(18)*M(2,:)%j) * den(367)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(626),h0tab(:,626),[35,4,16,8],[nMT,nMT,nMT,nMT],4,1,wf8(:,32))
  call Hloop_QV_A(ntryL,G0H96(1),wf8(:,32),G0H12(3),m3h8x12(:,83),heltab2x96(:,:,608))
  call Hloop_Q_A(ntryL,G0H12(3),35,nMT,G1H12(66),n2h12(433))
Gcoeff(:)%j = (-(c(18)*M(2,:)%j)) * den(367)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(627),h0tab(:,627),[35,4,16,8],[0,0,0,0],4,1,wf8(:,32))
  call Hloop_AV_Q(ntryL,G0H96(1),wf8(:,32),G0H12(8),m3h8x12(:,84),heltab2x96(:,:,609))
  call Hloop_A_Q(ntryL,G0H12(8),35,0,G1H12(68),n2h12(434))
Gcoeff(:)%j = (-(c(16)*M(2,:)%j)) * den(367)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(628),h0tab(:,628),[35,4,16,8],[nMB,nMB,nMB,nMB],4,1,wf8(:,32))
  call Hloop_AV_Q(ntryL,G0H96(1),wf8(:,32),G0H12(9),m3h8x12(:,85),heltab2x96(:,:,610))
  call Hloop_A_Q(ntryL,G0H12(9),35,nMB,G1H12(73),n2h12(435))
Gcoeff(:)%j = (-(c(18)*M(2,:)%j)) * den(367)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(629),h0tab(:,629),[35,4,16,8],[0,0,0,0],4,1,wf8(:,32))
  call Hloop_QV_A(ntryL,G0H96(1),wf8(:,32),G0H12(12),m3h8x12(:,86),heltab2x96(:,:,611))
  call Hloop_Q_A(ntryL,G0H12(12),35,0,G1H12(74),n2h12(436))
Gcoeff(:)%j = (-(c(16)*M(2,:)%j)) * den(367)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(630),h0tab(:,630),[35,4,16,8],[nMB,nMB,nMB,nMB],4,1,wf8(:,32))
  call Hloop_QV_A(ntryL,G0H96(1),wf8(:,32),G0H12(3),m3h8x12(:,87),heltab2x96(:,:,612))
  call Hloop_Q_A(ntryL,G0H12(3),35,nMB,G1H12(84),n2h12(437))
Gcoeff(:)%j = (-(c(6)*M(2,:)%j)) * den(56)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(631),h0tab(:,631),[38,8,1,16],[nMT,nMT,0,0],4,1,wf8(:,18))
  call Hloop_VA_Q(ntryL,G0H96(1),wf8(:,18),G0H12(8),m3h8x12(:,88),heltab2x96(:,:,613))
  call Hloop_A_Q(ntryL,G0H12(8),38,nMT,G1H12(107),n2h12(438))
Gcoeff(:)%j = (c(8)*M(2,:)%j) * den(56)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(632),h0tab(:,632),[38,1,8,16],[0,nMT,nMT,nMT],4,1,wf8(:,18))
  call Hloop_QA_V(ntryL,G0H96(1),wf8(:,18),G0H12(9),m3h8x12(:,89),heltab2x96(:,:,614))
Gcoeff(:)%j = (c(8)*M(2,:)%j) * den(56)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(633),h0tab(:,633),[38,1,16,8],[0,nMT,nMT,nMT],4,1,wf8(:,18))
  call Hloop_QA_V(ntryL,G0H96(1),wf8(:,18),G0H12(12),m3h8x12(:,90),heltab2x96(:,:,615))
Gcoeff(:)%j = (-(c(6)*M(2,:)%j)) * den(21)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(634),h0tab(:,634),[42,4,1,16],[nMT,nMT,0,0],4,1,wf12(:,9))
  call Hloop_VA_Q(ntryL,G0H96(1),wf12(:,9),G0H8(10),m3h12x8(:,10),heltab2x96(:,:,616))
  call Hloop_A_Q(ntryL,G0H8(10),42,nMT,G1H8(16),n2h8(218))
Gcoeff(:)%j = (c(8)*M(2,:)%j) * den(21)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(635),h0tab(:,635),[42,1,4,16],[0,nMT,nMT,nMT],4,1,wf12(:,9))
  call Hloop_QA_V(ntryL,G0H96(1),wf12(:,9),G0H8(11),m3h12x8(:,11),heltab2x96(:,:,617))
Gcoeff(:)%j = (c(8)*M(2,:)%j) * den(21)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(636),h0tab(:,636),[42,1,16,4],[0,nMT,nMT,nMT],4,1,wf12(:,9))
  call Hloop_QA_V(ntryL,G0H96(1),wf12(:,9),G0H8(12),m3h12x8(:,12),heltab2x96(:,:,618))
Gcoeff(:)%j = (-(c(10)*M(2,:)%j)) * den(99)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(637),h0tab(:,637),[50,1,4,8],[0,nMT,nMT,nMT],4,1,wf8(:,41))
  call Hloop_QA_V(ntryL,G0H96(1),wf8(:,41),G0H12(3),m3h8x12(:,91),heltab2x96(:,:,619))
Gcoeff(:)%j = (-(c(10)*M(2,:)%j)) * den(99)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(638),h0tab(:,638),[50,1,8,4],[0,nMT,nMT,nMT],4,1,wf8(:,41))
  call Hloop_QA_V(ntryL,G0H96(1),wf8(:,41),G0H12(8),m3h8x12(:,92),heltab2x96(:,:,620))
Gcoeff(:)%j = (c(5)*(M(1,:)%j-M(2,:)%j)) * den(48)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(639),h0tab(:,639),[49,2,4,8],[0,nMT,nMT,nMT],4,1,wf8(:,14))
  call Hloop_AQ_V(ntryL,G0H96(1),wf8(:,14),G0H12(17),m3h8x12(:,93),heltab2x96(:,:,621))
Gcoeff(:)%j = (c(5)*(M(1,:)%j-M(2,:)%j)) * den(48)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(640),h0tab(:,640),[49,2,8,4],[0,nMT,nMT,nMT],4,1,wf8(:,14))
  call Hloop_AQ_V(ntryL,G0H96(1),wf8(:,14),G0H12(18),m3h8x12(:,94),heltab2x96(:,:,622))
Gcoeff(:)%j = (c(5)*(M(1,:)%j-M(2,:)%j)) * den(24)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(641),h0tab(:,641),[50,1,4,8],[0,nMT,nMT,nMT],4,1,wf8(:,7))
  call Hloop_QA_V(ntryL,G0H96(1),wf8(:,7),G0H12(19),m3h8x12(:,95),heltab2x96(:,:,623))
Gcoeff(:)%j = (c(5)*(M(1,:)%j-M(2,:)%j)) * den(24)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(642),h0tab(:,642),[50,1,8,4],[0,nMT,nMT,nMT],4,1,wf8(:,7))
  call Hloop_QA_V(ntryL,G0H96(1),wf8(:,7),G0H12(20),m3h8x12(:,96),heltab2x96(:,:,624))
  call ol_merge(ntryL,G1H8(16),[G1H8(68),G1H8(71),G1H8(55)])
  call ol_merge(ntryL,G1H12(99),[G1H12(235),G1H12(146)])
  call ol_merge(ntryL,G1H12(12),[G1H12(183),G1H12(45),G1H12(157)])
  call ol_merge(ntryL,G1H12(214),[G1H12(168)])
  call ol_merge(ntryL,G1H12(22),[G1H12(181)])
  call ol_merge(ntryL,G1H12(107),[G1H12(184),G1H12(58),G1H12(200)])
  call ol_merge(ntryL,G1H12(81),[G1H12(222),G1H12(211)])
  call ol_merge(ntryL,G1H8(5),[G1H8(67),G1H8(52),G1H8(65)])
  call ol_merge(ntryL,G1H8(51),[G1H8(74)])
  call ol_merge(ntryL,G1H8(21),[G1H8(17)])
  call ol_merge(ntryL,G1H12(44),[G1H12(347),G1H12(198),G1H12(245)])
  call ol_merge(ntryL,G1H12(66),[G1H12(386),G1H12(76),G1H12(179)])
  call ol_merge(ntryL,G1H12(19),[G1H12(251),G1H12(239),G1H12(233)])
  call ol_merge(ntryL,G1H12(42),[G1H12(328),G1H12(180),G1H12(41)])
  call ol_merge(ntryL,G1H12(62),[G1H12(366),G1H12(11),G1H12(49)])
  call ol_merge(ntryL,G1H12(24),[G1H12(270),G1H12(242),G1H12(59)])
  call ol_merge(ntryL,G1H12(14),[G1H12(250),G1H12(236),G1H12(147)])
  call ol_merge(ntryL,G1H12(20),[G1H12(269),G1H12(240),G1H12(171)])
  call ol_merge(ntryL,G1H12(25),[G1H12(288),G1H12(246),G1H12(201)])
  call ol_merge(ntryL,G1H12(30),[G1H12(290),G1H12(143),G1H12(225)])
  call ol_merge(ntryL,G1H12(32),[G1H12(308),G1H12(144),G1H12(247)])
  call ol_merge(ntryL,G1H12(35),[G1H12(309),G1H12(161),G1H12(253)])
  call ol_merge(ntryL,G1H12(36),[G1H12(327),G1H12(162),G1H12(295)])
  call ol_merge(ntryL,G1H12(43),[G1H12(346),G1H12(197),G1H12(301)])
  call ol_merge(ntryL,G1H12(47),[G1H12(108),G1H12(215),G1H12(307)])
  call ol_merge(ntryL,G1H12(53),[G1H12(110),G1H12(216),G1H12(313)])
  call ol_merge(ntryL,G1H12(54),[G1H12(138),G1H12(234),G1H12(319)])
  call ol_merge(ntryL,G1H12(55),[G1H12(139),G1H12(7),G1H12(325)])
  call ol_merge(ntryL,G1H12(56),[G1H12(365),G1H12(8),G1H12(367)])
  call ol_merge(ntryL,G1H12(65),[G1H12(384),G1H12(75),G1H12(373)])
  call ol_merge(ntryL,G1H12(68),[G1H12(175),G1H12(2),G1H12(379)])
  call ol_merge(ntryL,G1H12(73),[G1H12(176),G1H12(4),G1H12(385)])
  call ol_merge(ntryL,G1H12(74),[G1H12(210),G1H12(77),G1H12(391)])
  call ol_merge(ntryL,G1H12(84),[G1H12(212),G1H12(111),G1H12(397)])
  call ol_merge(ntryL,G1H24(51),[G1H24(217)])
  call ol_merge(ntryL,G1H24(56),[G1H24(232)])
  call ol_merge(ntryL,G1H24(64),[G1H24(69)])
  call ol_merge(ntryL,G1H24(66),[G1H24(247)])
  call ol_merge(ntryL,G1H24(15),[G1H24(262)])
  call ol_merge(ntryL,G1H24(77),[G1H24(268)])
  call ol_merge(ntryL,G1H24(7),[G1H24(283)])
  call ol_merge(ntryL,G1H24(84),[G1H24(289)])
  call ol_merge(ntryL,G1H24(59),[G1H24(299)])
  call ol_merge(ntryL,G1H24(27),[G1H24(305)])
  call ol_merge(ntryL,G1H24(53),[G0H24(2),G0H24(3),G0H24(19)])
  call ol_merge(ntryL,G1H24(58),[G0H24(5),G0H24(6),G0H24(1)])
  call ol_merge(ntryL,G1H24(73),[G0H24(8),G0H24(7),G0H24(4)])
  call ol_merge(ntryL,G1H24(82),[G0H24(11),G0H24(10),G0H24(9)])
  call ol_merge(ntryL,G0H12(4),[G0H12(10)])
  call ol_merge(ntryL,G0H12(5),[G0H12(11)])
  call ol_merge(ntryL,G0H12(9),[G0H12(13)])
  call ol_merge(ntryL,G0H12(12),[G0H12(14)])
  call ol_merge(ntryL,G1H48(116),[G1H48(112)])
  call ol_merge(ntryL,G1H48(118),[G1H48(114)])
  call ol_merge(ntryL,G1H48(124),[G1H48(120)])
  call ol_merge(ntryL,G1H48(126),[G1H48(122)])
  call ol_merge(ntryL,G1H48(132),[G1H48(128)])
  call ol_merge(ntryL,G1H48(134),[G1H48(130)])
  call ol_merge(ntryL,G0H8(8),[G0H8(2)])
  call ol_merge(ntryL,G0H8(9),[G0H8(3)])
  call ol_merge(ntryL,G1H48(152),[G1H48(148)])
  call ol_merge(ntryL,G1H48(154),[G1H48(150)])
  call ol_merge(ntryL,G1H48(160),[G1H48(156)])
  call ol_merge(ntryL,G1H48(162),[G1H48(158)])
  call ol_merge(ntryL,G1H48(168),[G1H48(164)])
  call ol_merge(ntryL,G1H48(170),[G1H48(166)])
  call ol_merge(ntryL,G0H8(11),[G0H8(5)])
  call ol_merge(ntryL,G0H8(12),[G0H8(6)])
  call ol_merge(ntryL,G0H12(17),[G0H12(6),G0H12(15)])
  call ol_merge(ntryL,G0H12(18),[G0H12(7),G0H12(16)])
  call ol_merge(ntryL,G0H12(19),[G0H12(3),G0H12(1)])
  call ol_merge(ntryL,G0H12(20),[G0H12(8),G0H12(2)])
  call Hloop_AV_Q(ntryL,G1H8(11),ex3(:),G1H4(12),m3h2x4(:,217),heltab2x8(:,:,325))
  call Hloop_A_Q(ntryL,G1H4(12),60,nMT,G2H4(263),n2h4(495))
  call Hloop_AZ_Q(ntryL,G1H12(119),ex4(:),G1H4(24),ngZu,m3h3x4(:,247),heltab2x12(:,:,747))
  call Hloop_A_Q(ntryL,G1H4(24),60,nMT,G2H4(264),n2h4(496))
  call Hloop_QV_A(ntryL,G1H8(20),ex5(:),G1H4(60),m3h2x4(:,218),heltab2x8(:,:,326))
  call Hloop_Q_A(ntryL,G1H4(60),60,nMT,G2H4(257),n2h4(497))
  call Hloop_QV_A(ntryL,G1H8(31),ex3(:),G1H4(84),m3h2x4(:,219),heltab2x8(:,:,327))
  call Hloop_Q_A(ntryL,G1H4(84),60,nMT,G2H4(259),n2h4(498))
  call Hloop_QZ_A(ntryL,G1H12(127),ex4(:),G1H4(96),ngZu,m3h3x4(:,248),heltab2x12(:,:,748))
  call Hloop_Q_A(ntryL,G1H4(96),60,nMT,G2H4(260),n2h4(499))
  call Hloop_AV_Q(ntryL,G1H8(42),ex5(:),G1H4(108),m3h2x4(:,220),heltab2x8(:,:,328))
  call Hloop_A_Q(ntryL,G1H4(108),60,nMT,G2H4(265),n2h4(500))
  call Hloop_AZ_Q(ntryL,G1H12(137),ex4(:),G1H4(149),ngZu,m3h3x4(:,249),heltab2x12(:,:,749))
  call Hloop_A_Q(ntryL,G1H4(149),58,nMT,G2H4(267),n2h4(501))
  call Hloop_AV_Q(ntryL,G1H8(16),ex3(:),G1H4(155),m3h2x4(:,221),heltab2x8(:,:,329))
  call Hloop_A_Q(ntryL,G1H4(155),46,nMT,G2H4(268),n2h4(502))
  call Hloop_QV_A(ntryL,G1H12(99),ex3(:),G1H6(805),m3h2x6(:,389),heltab2x12(:,:,750))
  call Hloop_Q_A(ntryL,G1H6(805),53,nMT,G2H6(309),n2h6(602))
  call Hloop_QZ_A(ntryL,G1H12(12),ex4(:),G1H4(166),ngZu,m3h3x4(:,250),heltab2x12(:,:,751))
  call Hloop_Q_A(ntryL,G1H4(166),45,nMT,G2H4(277),n2h4(503))
  call Hloop_QV_A(ntryL,G1H12(214),ex5(:),G1H6(806),m3h2x6(:,390),heltab2x12(:,:,752))
  call Hloop_Q_A(ntryL,G1H6(806),53,nMT,G2H6(311),n2h6(603))
  call Hloop_QZ_A(ntryL,G1H12(22),ex4(:),G1H4(172),ngZu,m3h3x4(:,251),heltab2x12(:,:,753))
  call Hloop_Q_A(ntryL,G1H4(172),45,nMT,G2H4(279),n2h4(504))
  call Hloop_AV_Q(ntryL,G1H12(191),ex3(:),G1H6(821),m3h2x6(:,391),heltab2x12(:,:,754))
  call Hloop_A_Q(ntryL,G1H6(821),54,nMT,G2H6(312),n2h6(604))
  call Hloop_AZ_Q(ntryL,G1H12(107),ex4(:),G1H4(7),ngZu,m3h3x4(:,252),heltab2x12(:,:,755))
  call Hloop_A_Q(ntryL,G1H4(7),46,nMT,G2H4(280),n2h4(505))
  call Hloop_QZ_A(ntryL,G1H12(81),ex4(:),G1H4(8),ngZu,m3h3x4(:,253),heltab2x12(:,:,756))
  call Hloop_Q_A(ntryL,G1H4(8),57,nMT,G2H4(285),n2h4(506))
  call Hloop_QV_A(ntryL,G1H8(5),ex3(:),G1H4(13),m3h2x4(:,222),heltab2x8(:,:,330))
  call Hloop_Q_A(ntryL,G1H4(13),45,nMT,G2H4(287),n2h4(507))
  call Hloop_QV_A(ntryL,G1H8(51),ex5(:),G1H4(14),m3h2x4(:,223),heltab2x8(:,:,331))
  call Hloop_Q_A(ntryL,G1H4(14),57,nMT,G2H4(288),n2h4(508))
  call Hloop_QV_A(ntryL,G1H8(21),ex3(:),G1H4(75),m3h2x4(:,224),heltab2x8(:,:,332))
  call Hloop_Q_A(ntryL,G1H4(75),45,nMT,G2H4(281),n2h4(509))
  call Hloop_QV_A(ntryL,G1H12(44),ex3(:),G1H6(822),m3h2x6(:,392),heltab2x12(:,:,757))
  call Hloop_Q_A(ntryL,G1H6(822),39,nMT,G2H6(313),n2h6(605))
  call Hloop_QV_A(ntryL,G1H12(66),ex3(:),G1H6(837),m3h2x6(:,393),heltab2x12(:,:,758))
  call Hloop_Q_A(ntryL,G1H6(837),39,nMT,G2H6(315),n2h6(606))
  call Hloop_QZ_A(ntryL,G1H12(19),ex4(:),G1H4(611),ngZu,m3h3x4(:,254),heltab2x12(:,:,759))
  call Hloop_Q_A(ntryL,G1H4(611),43,nMT,G2H4(283),n2h4(510))
  call Hloop_QZ_A(ntryL,G1H12(13),ex4(:),G1H4(26),ngZu,m3h3x4(:,255),heltab2x12(:,:,760))
  call Hloop_Q_A(ntryL,G1H4(26),43,nMT,G2H4(284),n2h4(511))
  call Hloop_QV_A(ntryL,G1H12(23),ex5(:),G1H6(838),m3h2x6(:,394),heltab2x12(:,:,761))
  call Hloop_Q_A(ntryL,G1H6(838),51,nMT,G2H6(316),n2h6(607))
  call Hloop_QV_A(ntryL,G1H12(31),ex5(:),G1H6(853),m3h2x6(:,395),heltab2x12(:,:,762))
  call Hloop_Q_A(ntryL,G1H6(853),51,nMT,G2H6(317),n2h6(608))
  call Hloop_AV_Q(ntryL,G1H12(42),ex3(:),G1H6(854),m3h2x6(:,396),heltab2x12(:,:,763))
  call Hloop_A_Q(ntryL,G1H6(854),39,nMT,G2H6(319),n2h6(609))
  call Hloop_AV_Q(ntryL,G1H12(62),ex3(:),G1H6(869),m3h2x6(:,397),heltab2x12(:,:,764))
  call Hloop_A_Q(ntryL,G1H6(869),39,nMT,G2H6(320),n2h6(610))
  call Hloop_AZ_Q(ntryL,G1H12(24),ex4(:),G1H4(30),ngZu,m3h3x4(:,256),heltab2x12(:,:,765))
  call Hloop_A_Q(ntryL,G1H4(30),43,nMT,G2H4(289),n2h4(512))
  call Hloop_AZ_Q(ntryL,G1H12(67),ex4(:),G1H4(37),ngZu,m3h3x4(:,257),heltab2x12(:,:,766))
  call Hloop_A_Q(ntryL,G1H4(37),43,nMT,G2H4(291),n2h4(513))
  call Hloop_AV_Q(ntryL,G1H12(78),ex5(:),G1H6(870),m3h2x6(:,398),heltab2x12(:,:,767))
  call Hloop_A_Q(ntryL,G1H6(870),51,nMT,G2H6(321),n2h6(611))
  call Hloop_AV_Q(ntryL,G1H12(98),ex5(:),G1H6(885),m3h2x6(:,399),heltab2x12(:,:,768))
  call Hloop_A_Q(ntryL,G1H6(885),51,nMT,G2H6(323),n2h6(612))
  call Hloop_AV_Q(ntryL,G1H12(177),ex5(:),G1H6(886),m3h2x6(:,400),heltab2x12(:,:,769))
  call Hloop_A_Q(ntryL,G1H6(886),51,0,G2H6(324),n2h6(613))
  call Hloop_QV_A(ntryL,G1H12(3),ex5(:),G1H6(901),m3h2x6(:,401),heltab2x12(:,:,770))
  call Hloop_Q_A(ntryL,G1H6(901),51,0,G2H6(325),n2h6(614))
  call Hloop_AV_Q(ntryL,G1H12(15),ex5(:),G1H6(902),m3h2x6(:,402),heltab2x12(:,:,771))
  call Hloop_A_Q(ntryL,G1H6(902),51,0,G2H6(327),n2h6(615))
  call Hloop_AV_Q(ntryL,G1H12(89),ex5(:),G1H6(917),m3h2x6(:,403),heltab2x12(:,:,772))
  call Hloop_A_Q(ntryL,G1H6(917),51,nMB,G2H6(328),n2h6(616))
  call Hloop_QV_A(ntryL,G1H12(105),ex5(:),G1H6(918),m3h2x6(:,404),heltab2x12(:,:,773))
  call Hloop_Q_A(ntryL,G1H6(918),51,0,G2H6(332),n2h6(617))
  call Hloop_QV_A(ntryL,G1H12(123),ex5(:),G1H6(933),m3h2x6(:,405),heltab2x12(:,:,774))
  call Hloop_Q_A(ntryL,G1H6(933),51,nMB,G2H6(333),n2h6(618))
  call Hloop_QZ_A(ntryL,G1H12(14),ex4(:),G1H4(38),ngZu,m3h3x4(:,258),heltab2x12(:,:,775))
  call Hloop_Q_A(ntryL,G1H4(38),43,0,G2H4(292),n2h4(514))
  call Hloop_AZ_Q(ntryL,G1H12(20),ex4(:),G1H4(42),ngZu,m3h3x4(:,259),heltab2x12(:,:,776))
  call Hloop_A_Q(ntryL,G1H4(42),43,0,G2H4(299),n2h4(515))
  call Hloop_QZ_A(ntryL,G1H12(25),ex4(:),G1H4(43),ngZd,m3h3x4(:,260),heltab2x12(:,:,777))
  call Hloop_Q_A(ntryL,G1H4(43),43,0,G2H4(301),n2h4(516))
  call Hloop_QZ_A(ntryL,G1H12(30),ex4(:),G1H4(50),ngZd,m3h3x4(:,261),heltab2x12(:,:,778))
  call Hloop_Q_A(ntryL,G1H4(50),43,nMB,G2H4(302),n2h4(517))
  call Hloop_AZ_Q(ntryL,G1H12(32),ex4(:),G1H4(54),ngZd,m3h3x4(:,262),heltab2x12(:,:,779))
  call Hloop_A_Q(ntryL,G1H4(54),43,0,G2H4(306),n2h4(518))
  call Hloop_AZ_Q(ntryL,G1H12(35),ex4(:),G1H4(55),ngZd,m3h3x4(:,263),heltab2x12(:,:,780))
  call Hloop_A_Q(ntryL,G1H4(55),43,nMB,G2H4(307),n2h4(519))
  call Hloop_QV_A(ntryL,G1H12(259),ex5(:),G1H6(934),m3h2x6(:,406),heltab2x12(:,:,781))
  call Hloop_Q_A(ntryL,G1H6(934),51,0,G2H6(335),n2h6(619))
  call Hloop_AV_Q(ntryL,G1H12(265),ex5(:),G1H6(949),m3h2x6(:,407),heltab2x12(:,:,782))
  call Hloop_A_Q(ntryL,G1H6(949),51,0,G2H6(336),n2h6(620))
  call Hloop_QV_A(ntryL,G1H12(271),ex5(:),G1H6(950),m3h2x6(:,408),heltab2x12(:,:,783))
  call Hloop_Q_A(ntryL,G1H6(950),51,0,G2H6(340),n2h6(621))
  call Hloop_QV_A(ntryL,G1H12(277),ex5(:),G1H6(965),m3h2x6(:,409),heltab2x12(:,:,784))
  call Hloop_Q_A(ntryL,G1H6(965),51,nMB,G2H6(341),n2h6(622))
  call Hloop_AV_Q(ntryL,G1H12(283),ex5(:),G1H6(966),m3h2x6(:,410),heltab2x12(:,:,785))
  call Hloop_A_Q(ntryL,G1H6(966),51,0,G2H6(343),n2h6(623))
  call Hloop_AV_Q(ntryL,G1H12(289),ex5(:),G1H6(981),m3h2x6(:,411),heltab2x12(:,:,786))
  call Hloop_A_Q(ntryL,G1H6(981),51,nMB,G2H6(344),n2h6(624))
  call Hloop_AZ_Q(ntryL,G1H24(30),ex4(:),G1H8(39),ngZu,m3h3x8(:,113),heltab2x24(:,:,413))
  call Hloop_A_Q(ntryL,G1H8(39),44,0,G2H8(55),n2h8(219))
  call Hloop_AZ_Q(ntryL,G1H24(5),ex4(:),G1H8(40),ngZu,m3h3x8(:,114),heltab2x24(:,:,414))
  call Hloop_A_Q(ntryL,G1H8(40),44,nMT,G2H8(58),n2h8(220))
  call Hloop_QZ_A(ntryL,G1H24(12),ex4(:),G1H8(14),ngZu,m3h3x8(:,115),heltab2x24(:,:,415))
  call Hloop_Q_A(ntryL,G1H8(14),44,0,G2H8(59),n2h8(221))
  call Hloop_QZ_A(ntryL,G1H24(43),ex4(:),G1H8(19),ngZu,m3h3x8(:,116),heltab2x24(:,:,416))
  call Hloop_Q_A(ntryL,G1H8(19),44,nMT,G2H8(60),n2h8(222))
  call Hloop_AZ_Q(ntryL,G1H24(50),ex4(:),G1H8(93),ngZd,m3h3x8(:,117),heltab2x24(:,:,417))
  call Hloop_A_Q(ntryL,G1H8(93),44,0,G2H8(63),n2h8(223))
  call Hloop_AZ_Q(ntryL,G1H24(57),ex4(:),G1H8(94),ngZd,m3h3x8(:,118),heltab2x24(:,:,418))
  call Hloop_A_Q(ntryL,G1H8(94),44,nMB,G2H8(64),n2h8(224))
  call Hloop_QZ_A(ntryL,G1H24(70),ex4(:),G1H8(109),ngZd,m3h3x8(:,119),heltab2x24(:,:,419))
  call Hloop_Q_A(ntryL,G1H8(109),44,0,G2H8(87),n2h8(225))
  call Hloop_QZ_A(ntryL,G1H24(78),ex4(:),G1H8(110),ngZd,m3h3x8(:,120),heltab2x24(:,:,420))
  call Hloop_Q_A(ntryL,G1H8(110),44,nMB,G2H8(89),n2h8(226))
  call Hloop_AV_Q(ntryL,G1H12(36),ex3(:),G1H6(982),m3h2x6(:,412),heltab2x12(:,:,787))
  call Hloop_A_Q(ntryL,G1H6(982),39,0,G2H6(345),n2h6(625))
  call Hloop_QV_A(ntryL,G1H12(43),ex3(:),G1H6(1002),m3h2x6(:,413),heltab2x12(:,:,788))
  call Hloop_Q_A(ntryL,G1H6(1002),39,0,G2H6(347),n2h6(626))
  call Hloop_AV_Q(ntryL,G1H12(47),ex3(:),G1H6(1003),m3h2x6(:,414),heltab2x12(:,:,789))
  call Hloop_A_Q(ntryL,G1H6(1003),39,0,G2H6(348),n2h6(627))
  call Hloop_AV_Q(ntryL,G1H12(53),ex3(:),G1H6(1023),m3h2x6(:,415),heltab2x12(:,:,790))
  call Hloop_A_Q(ntryL,G1H6(1023),39,nMB,G2H6(349),n2h6(628))
  call Hloop_QV_A(ntryL,G1H12(54),ex3(:),G1H6(1024),m3h2x6(:,416),heltab2x12(:,:,791))
  call Hloop_Q_A(ntryL,G1H6(1024),39,0,G2H6(351),n2h6(629))
  call Hloop_QV_A(ntryL,G1H12(55),ex3(:),G1H6(1039),m3h2x6(:,417),heltab2x12(:,:,792))
  call Hloop_Q_A(ntryL,G1H6(1039),39,nMB,G2H6(352),n2h6(630))
  call Hloop_QV_A(ntryL,G1H16(1),ex3(:),G1H8(125),m3h2x8(:,61),heltab2x16(:,:,89))
  call Hloop_Q_A(ntryL,G1H8(125),44,0,G2H8(90),n2h8(227))
  call Hloop_QV_A(ntryL,G1H16(8),ex3(:),G1H8(126),m3h2x8(:,62),heltab2x16(:,:,90))
  call Hloop_Q_A(ntryL,G1H8(126),44,nMT,G2H8(91),n2h8(228))
  call Hloop_AV_Q(ntryL,G1H16(15),ex3(:),G1H8(141),m3h2x8(:,63),heltab2x16(:,:,91))
  call Hloop_A_Q(ntryL,G1H8(141),44,0,G2H8(93),n2h8(229))
  call Hloop_AV_Q(ntryL,G1H16(21),ex3(:),G1H8(142),m3h2x8(:,64),heltab2x16(:,:,92))
  call Hloop_A_Q(ntryL,G1H8(142),44,nMT,G2H8(94),n2h8(230))
  call Hloop_QV_A(ntryL,G1H16(27),ex3(:),G1H8(157),m3h2x8(:,65),heltab2x16(:,:,93))
  call Hloop_Q_A(ntryL,G1H8(157),44,nMB,G2H8(95),n2h8(231))
  call Hloop_AV_Q(ntryL,G1H16(33),ex3(:),G1H8(158),m3h2x8(:,66),heltab2x16(:,:,94))
  call Hloop_A_Q(ntryL,G1H8(158),44,nMB,G2H8(97),n2h8(232))
  call Hloop_QZ_A(ntryL,G1H12(331),ex4(:),G1H4(56),ngZu,m3h3x4(:,264),heltab2x12(:,:,793))
  call Hloop_Q_A(ntryL,G1H4(56),43,0,G2H4(309),n2h4(520))
  call Hloop_AZ_Q(ntryL,G1H12(337),ex4(:),G1H4(66),ngZu,m3h3x4(:,265),heltab2x12(:,:,794))
  call Hloop_A_Q(ntryL,G1H4(66),43,0,G2H4(310),n2h4(521))
  call Hloop_QZ_A(ntryL,G1H12(343),ex4(:),G1H4(67),ngZd,m3h3x4(:,266),heltab2x12(:,:,795))
  call Hloop_Q_A(ntryL,G1H4(67),43,0,G2H4(314),n2h4(522))
  call Hloop_QZ_A(ntryL,G1H12(349),ex4(:),G1H4(68),ngZd,m3h3x4(:,267),heltab2x12(:,:,796))
  call Hloop_Q_A(ntryL,G1H4(68),43,nMB,G2H4(315),n2h4(523))
  call Hloop_AZ_Q(ntryL,G1H12(355),ex4(:),G1H4(73),ngZd,m3h3x4(:,268),heltab2x12(:,:,797))
  call Hloop_A_Q(ntryL,G1H4(73),43,0,G2H4(317),n2h4(524))
  call Hloop_AZ_Q(ntryL,G1H12(361),ex4(:),G1H4(79),ngZd,m3h3x4(:,269),heltab2x12(:,:,798))
  call Hloop_A_Q(ntryL,G1H4(79),43,nMB,G2H4(318),n2h4(525))
  call Hloop_AV_Q(ntryL,G1H24(54),ex5(:),G1H12(27),m3h2x12(:,205),heltab2x24(:,:,421))
  call Hloop_A_Q(ntryL,G1H12(27),52,0,G2H12(5),n2h12(439))
  call Hloop_AV_Q(ntryL,G1H24(42),ex5(:),G1H12(160),m3h2x12(:,206),heltab2x24(:,:,422))
  call Hloop_A_Q(ntryL,G1H12(160),52,nMT,G2H12(8),n2h12(440))
  call Hloop_QV_A(ntryL,G1H24(20),ex5(:),G1H12(21),m3h2x12(:,207),heltab2x24(:,:,423))
  call Hloop_Q_A(ntryL,G1H12(21),52,0,G2H12(9),n2h12(441))
  call Hloop_QV_A(ntryL,G1H24(85),ex5(:),G1H12(97),m3h2x12(:,208),heltab2x24(:,:,424))
  call Hloop_Q_A(ntryL,G1H12(97),52,nMT,G2H12(11),n2h12(442))
  call Hloop_AV_Q(ntryL,G1H24(91),ex5(:),G1H12(102),m3h2x12(:,209),heltab2x24(:,:,425))
  call Hloop_A_Q(ntryL,G1H12(102),52,0,G2H12(15),n2h12(443))
  call Hloop_AV_Q(ntryL,G1H24(97),ex5(:),G1H12(39),m3h2x12(:,210),heltab2x24(:,:,426))
  call Hloop_A_Q(ntryL,G1H12(39),52,nMB,G2H12(16),n2h12(444))
  call Hloop_QV_A(ntryL,G1H24(103),ex5(:),G1H12(101),m3h2x12(:,211),heltab2x24(:,:,427))
  call Hloop_Q_A(ntryL,G1H12(101),52,0,G2H12(17),n2h12(445))
  call Hloop_QV_A(ntryL,G1H24(109),ex5(:),G1H12(63),m3h2x12(:,212),heltab2x24(:,:,428))
  call Hloop_Q_A(ntryL,G1H12(63),52,nMB,G2H12(42),n2h12(446))
  call Hloop_AV_Q(ntryL,G1H12(56),ex3(:),G1H6(1040),m3h2x6(:,418),heltab2x12(:,:,799))
  call Hloop_A_Q(ntryL,G1H6(1040),39,0,G2H6(353),n2h6(631))
  call Hloop_QV_A(ntryL,G1H12(65),ex3(:),G1H6(1055),m3h2x6(:,419),heltab2x12(:,:,800))
  call Hloop_Q_A(ntryL,G1H6(1055),39,0,G2H6(355),n2h6(632))
  call Hloop_AV_Q(ntryL,G1H12(68),ex3(:),G1H6(1056),m3h2x6(:,420),heltab2x12(:,:,801))
  call Hloop_A_Q(ntryL,G1H6(1056),39,0,G2H6(356),n2h6(633))
  call Hloop_AV_Q(ntryL,G1H12(73),ex3(:),G1H6(1071),m3h2x6(:,421),heltab2x12(:,:,802))
  call Hloop_A_Q(ntryL,G1H6(1071),39,nMB,G2H6(12),n2h6(634))
  call Hloop_QV_A(ntryL,G1H12(74),ex3(:),G1H6(1072),m3h2x6(:,422),heltab2x12(:,:,803))
  call Hloop_Q_A(ntryL,G1H6(1072),39,0,G2H6(98),n2h6(635))
  call Hloop_QV_A(ntryL,G1H12(84),ex3(:),G1H6(1087),m3h2x6(:,423),heltab2x12(:,:,804))
  call Hloop_Q_A(ntryL,G1H6(1087),39,nMB,G2H6(16),n2h6(636))
  call Hloop_AV_Q(ntryL,G1H16(39),wf4(:,14),G1H4(80),m3h4x4(:,29),heltab2x16(:,:,95))
  call Hloop_A_Q(ntryL,G1H4(80),43,0,G2H4(319),n2h4(526))
  call Hloop_AV_Q(ntryL,G1H16(45),wf4(:,14),G1H4(11),m3h4x4(:,30),heltab2x16(:,:,96))
  call Hloop_A_Q(ntryL,G1H4(11),43,nMT,G2H4(321),n2h4(527))
  call Hloop_QV_A(ntryL,G1H16(51),wf4(:,14),G1H4(23),m3h4x4(:,31),heltab2x16(:,:,97))
  call Hloop_Q_A(ntryL,G1H4(23),43,0,G2H4(322),n2h4(528))
  call Hloop_QV_A(ntryL,G1H16(57),wf4(:,14),G1H4(59),m3h4x4(:,32),heltab2x16(:,:,98))
  call Hloop_Q_A(ntryL,G1H4(59),43,nMT,G2H4(33),n2h4(529))
  call Hloop_AV_Q(ntryL,G1H16(63),wf4(:,14),G1H4(9),m3h4x4(:,33),heltab2x16(:,:,99))
  call Hloop_A_Q(ntryL,G1H4(9),43,nMB,G2H4(36),n2h4(530))
  call Hloop_QV_A(ntryL,G1H16(69),wf4(:,14),G1H4(57),m3h4x4(:,34),heltab2x16(:,:,100))
  call Hloop_Q_A(ntryL,G1H4(57),43,nMB,G2H4(143),n2h4(531))
  call Hloop_QV_A(ntryL,G1H24(115),wf4(:,14),G1H6(1088),m3h4x6(:,85),heltab2x24(:,:,429))
  call Hloop_Q_A(ntryL,G1H6(1088),39,0,G2H6(19),n2h6(637))
  call Hloop_QV_A(ntryL,G1H24(121),wf4(:,14),G1H6(1108),m3h4x6(:,86),heltab2x24(:,:,430))
  call Hloop_Q_A(ntryL,G1H6(1108),39,nMT,G2H6(99),n2h6(638))
  call Hloop_AV_Q(ntryL,G1H24(127),wf4(:,14),G1H6(1109),m3h4x6(:,87),heltab2x24(:,:,431))
  call Hloop_A_Q(ntryL,G1H6(1109),39,0,G2H6(23),n2h6(639))
  call Hloop_AV_Q(ntryL,G1H24(133),wf4(:,14),G1H6(1129),m3h4x6(:,88),heltab2x24(:,:,432))
  call Hloop_A_Q(ntryL,G1H6(1129),39,nMT,G2H6(100),n2h6(640))
  call Hloop_QV_A(ntryL,G1H24(139),wf4(:,14),G1H6(1130),m3h4x6(:,89),heltab2x24(:,:,433))
  call Hloop_Q_A(ntryL,G1H6(1130),39,0,G2H6(7),n2h6(641))
  call Hloop_QV_A(ntryL,G1H24(145),wf4(:,14),G1H6(1145),m3h4x6(:,90),heltab2x24(:,:,434))
  call Hloop_Q_A(ntryL,G1H6(1145),39,nMB,G2H6(28),n2h6(642))
  call Hloop_AV_Q(ntryL,G1H24(151),wf4(:,14),G1H6(1146),m3h4x6(:,91),heltab2x24(:,:,435))
  call Hloop_A_Q(ntryL,G1H6(1146),39,0,G2H6(57),n2h6(643))
  call Hloop_AV_Q(ntryL,G1H24(157),wf4(:,14),G1H6(1161),m3h4x6(:,92),heltab2x24(:,:,436))
  call Hloop_A_Q(ntryL,G1H6(1161),39,nMB,G2H6(31),n2h6(644))
  call Hloop_QV_A(ntryL,G1H24(163),wf4(:,14),G1H6(1162),m3h4x6(:,93),heltab2x24(:,:,437))
  call Hloop_Q_A(ntryL,G1H6(1162),39,0,G2H6(11),n2h6(645))
  call Hloop_QV_A(ntryL,G1H24(169),wf4(:,14),G1H6(1177),m3h4x6(:,94),heltab2x24(:,:,438))
  call Hloop_Q_A(ntryL,G1H6(1177),39,nMT,G2H6(64),n2h6(646))
  call Hloop_AV_Q(ntryL,G1H24(175),wf4(:,14),G1H6(1178),m3h4x6(:,95),heltab2x24(:,:,439))
  call Hloop_A_Q(ntryL,G1H6(1178),39,0,G2H6(35),n2h6(647))
  call Hloop_AV_Q(ntryL,G1H24(181),wf4(:,14),G1H6(258),m3h4x6(:,96),heltab2x24(:,:,440))
  call Hloop_A_Q(ntryL,G1H6(258),39,nMT,G2H6(101),n2h6(648))
  call Hloop_QV_A(ntryL,G1H24(187),wf4(:,14),G1H6(264),m3h4x6(:,97),heltab2x24(:,:,441))
  call Hloop_Q_A(ntryL,G1H6(264),39,0,G2H6(39),n2h6(649))
  call Hloop_QV_A(ntryL,G1H24(193),wf4(:,14),G1H6(13),m3h4x6(:,98),heltab2x24(:,:,442))
  call Hloop_Q_A(ntryL,G1H6(13),39,nMB,G2H6(42),n2h6(650))
  call Hloop_AV_Q(ntryL,G1H24(199),wf4(:,14),G1H6(14),m3h4x6(:,99),heltab2x24(:,:,443))
  call Hloop_A_Q(ntryL,G1H6(14),39,0,G2H6(102),n2h6(651))
  call Hloop_AV_Q(ntryL,G1H24(205),wf4(:,14),G1H6(19),m3h4x6(:,100),heltab2x24(:,:,444))
  call Hloop_A_Q(ntryL,G1H6(19),39,nMB,G2H6(1),n2h6(652))
  call Hloop_AZ_Q(ntryL,G1H24(211),ex4(:),G1H8(173),ngZu,m3h3x8(:,121),heltab2x24(:,:,445))
  call Hloop_A_Q(ntryL,G1H8(173),42,nMT,G2H8(98),n2h8(233))
  call Hloop_AZ_Q(ntryL,G1H24(51),ex4(:),G1H8(174),ngZu,m3h3x8(:,122),heltab2x24(:,:,446))
  call Hloop_A_Q(ntryL,G1H8(174),42,nMT,G2H8(99),n2h8(234))
  call Hloop_AV_Q(ntryL,G1H24(223),ex5(:),G1H12(103),m3h2x12(:,213),heltab2x24(:,:,447))
  call Hloop_A_Q(ntryL,G1H12(103),50,nMT,G2H12(6),n2h12(447))
  call Hloop_QZ_A(ntryL,G1H24(62),ex4(:),G1H8(189),ngZu,m3h3x8(:,123),heltab2x24(:,:,448))
  call Hloop_Q_A(ntryL,G1H8(189),41,nMT,G2H8(101),n2h8(235))
  call Hloop_QZ_A(ntryL,G1H24(56),ex4(:),G1H8(190),ngZu,m3h3x8(:,124),heltab2x24(:,:,449))
  call Hloop_Q_A(ntryL,G1H8(190),41,nMT,G2H8(102),n2h8(236))
  call Hloop_QV_A(ntryL,G1H24(238),ex5(:),G1H12(232),m3h2x12(:,214),heltab2x24(:,:,450))
  call Hloop_Q_A(ntryL,G1H12(232),49,nMT,G2H12(27),n2h12(448))
  call Hloop_AV_Q(ntryL,G1H24(64),ex3(:),G1H12(10),m3h2x12(:,215),heltab2x24(:,:,451))
  call Hloop_A_Q(ntryL,G1H12(10),38,nMT,G2H12(32),n2h12(449))
  call Hloop_AV_Q(ntryL,G1H24(66),ex3(:),G1H12(16),m3h2x12(:,216),heltab2x24(:,:,452))
  call Hloop_A_Q(ntryL,G1H12(16),38,nMT,G2H12(77),n2h12(450))
  call Hloop_AV_Q(ntryL,G1H24(253),ex5(:),G1H12(40),m3h2x12(:,217),heltab2x24(:,:,453))
  call Hloop_A_Q(ntryL,G1H12(40),50,nMT,G2H12(78),n2h12(451))
  call Hloop_QV_A(ntryL,G1H24(258),ex5(:),G1H12(46),m3h2x12(:,218),heltab2x24(:,:,454))
  call Hloop_Q_A(ntryL,G1H12(46),52,nMT,G2H12(80),n2h12(452))
  call Hloop_QV_A(ntryL,G1H24(15),ex3(:),G1H12(52),m3h2x12(:,219),heltab2x24(:,:,455))
  call Hloop_Q_A(ntryL,G1H12(52),37,nMT,G2H12(81),n2h12(453))
  call Hloop_QV_A(ntryL,G1H24(77),ex3(:),G1H12(64),m3h2x12(:,220),heltab2x24(:,:,456))
  call Hloop_Q_A(ntryL,G1H12(64),37,nMT,G2H12(82),n2h12(454))
  call Hloop_QV_A(ntryL,G1H24(274),ex5(:),G1H12(82),m3h2x12(:,221),heltab2x24(:,:,457))
  call Hloop_Q_A(ntryL,G1H12(82),49,nMT,G2H12(84),n2h12(455))
  call Hloop_AV_Q(ntryL,G1H24(279),ex5(:),G1H12(100),m3h2x12(:,222),heltab2x24(:,:,458))
  call Hloop_A_Q(ntryL,G1H12(100),52,nMT,G2H12(85),n2h12(456))
  call Hloop_AV_Q(ntryL,G1H24(7),ex3(:),G1H12(87),m3h2x12(:,223),heltab2x24(:,:,459))
  call Hloop_A_Q(ntryL,G1H12(87),38,nMT,G2H12(86),n2h12(457))
  call Hloop_QV_A(ntryL,G1H16(75),ex3(:),G1H8(205),m3h2x8(:,67),heltab2x16(:,:,101))
  call Hloop_Q_A(ntryL,G1H8(205),44,nMT,G2H8(103),n2h8(237))
  call Hloop_AZ_Q(ntryL,G1H24(84),ex4(:),G1H8(206),ngZu,m3h3x8(:,125),heltab2x24(:,:,460))
  call Hloop_A_Q(ntryL,G1H8(206),42,nMT,G2H8(105),n2h8(238))
  call Hloop_QZ_A(ntryL,G1H24(295),ex4(:),G1H8(221),ngZu,m3h3x8(:,126),heltab2x24(:,:,461))
  call Hloop_Q_A(ntryL,G1H8(221),44,nMT,G2H8(106),n2h8(239))
  call Hloop_QV_A(ntryL,G1H24(59),ex3(:),G1H12(94),m3h2x12(:,224),heltab2x24(:,:,462))
  call Hloop_Q_A(ntryL,G1H12(94),37,nMT,G2H12(88),n2h12(458))
  call Hloop_AV_Q(ntryL,G1H16(81),ex3(:),G1H8(222),m3h2x8(:,68),heltab2x16(:,:,102))
  call Hloop_A_Q(ntryL,G1H8(222),44,nMT,G2H8(107),n2h8(240))
  call Hloop_QZ_A(ntryL,G1H24(27),ex4(:),G1H8(237),ngZu,m3h3x8(:,127),heltab2x24(:,:,463))
  call Hloop_Q_A(ntryL,G1H8(237),41,nMT,G2H8(109),n2h8(241))
  call Hloop_AZ_Q(ntryL,G1H24(311),ex4(:),G1H8(238),ngZu,m3h3x8(:,128),heltab2x24(:,:,464))
  call Hloop_A_Q(ntryL,G1H8(238),44,nMT,G2H8(110),n2h8(242))
  call Hloop_VA_Q(ntryL,G1H24(53),ex2(:),G1H12(106),m3h2x12(:,225),heltab2x24(:,:,465))
  call Hloop_A_Q(ntryL,G1H12(106),50,nMT,G2H12(89),n2h12(459))
  call Hloop_VQ_A(ntryL,G1H24(58),ex1(:),G1H12(159),m3h2x12(:,226),heltab2x24(:,:,466))
  call Hloop_Q_A(ntryL,G1H12(159),49,nMT,G2H12(90),n2h12(460))
  call Hloop_VA_Q(ntryL,G1H24(73),ex2(:),G1H12(195),m3h2x12(:,227),heltab2x24(:,:,467))
  call Hloop_A_Q(ntryL,G1H12(195),50,nMT,G2H12(93),n2h12(461))
  call Hloop_VQ_A(ntryL,G1H24(82),ex1(:),G1H12(213),m3h2x12(:,228),heltab2x24(:,:,468))
  call Hloop_Q_A(ntryL,G1H12(213),49,nMT,G2H12(94),n2h12(462))
  call Hloop_AV_Q(ntryL,G1H24(3),wf4(:,14),G1H6(20),m3h4x6(:,101),heltab2x24(:,:,469))
  call Hloop_A_Q(ntryL,G1H6(20),51,0,G2H6(67),n2h6(653))
  call Hloop_AV_Q(ntryL,G1H24(4),wf4(:,14),G1H6(26),m3h4x6(:,102),heltab2x24(:,:,470))
  call Hloop_A_Q(ntryL,G1H6(26),51,nMT,G2H6(47),n2h6(654))
  call Hloop_QV_A(ntryL,G1H24(28),wf4(:,14),G1H6(31),m3h4x6(:,103),heltab2x24(:,:,471))
  call Hloop_Q_A(ntryL,G1H6(31),51,0,G2H6(4),n2h6(655))
  call Hloop_QV_A(ntryL,G1H24(29),wf4(:,14),G1H6(32),m3h4x6(:,104),heltab2x24(:,:,472))
  call Hloop_Q_A(ntryL,G1H6(32),51,nMT,G2H6(71),n2h6(656))
  call Hloop_AV_Q(ntryL,G1H24(31),wf4(:,14),G1H6(36),m3h4x6(:,105),heltab2x24(:,:,473))
  call Hloop_A_Q(ntryL,G1H6(36),51,0,G2H6(51),n2h6(657))
  call Hloop_AV_Q(ntryL,G1H24(32),wf4(:,14),G1H6(43),m3h4x6(:,106),heltab2x24(:,:,474))
  call Hloop_A_Q(ntryL,G1H6(43),51,nMB,G2H6(30),n2h6(658))
  call Hloop_QV_A(ntryL,G1H24(34),wf4(:,14),G1H6(44),m3h4x6(:,107),heltab2x24(:,:,475))
  call Hloop_Q_A(ntryL,G1H6(44),51,0,G2H6(21),n2h6(659))
  call Hloop_QV_A(ntryL,G1H24(35),wf4(:,14),G1H6(48),m3h4x6(:,108),heltab2x24(:,:,476))
  call Hloop_Q_A(ntryL,G1H6(48),51,nMB,G2H6(105),n2h6(660))
  call Hloop_QV_A(ntryL,G1H24(36),wf4(:,14),G1H6(49),m3h4x6(:,109),heltab2x24(:,:,477))
  call Hloop_Q_A(ntryL,G1H6(49),51,0,G2H6(107),n2h6(661))
  call Hloop_QV_A(ntryL,G1H24(6),wf4(:,14),G1H6(45),m3h4x6(:,110),heltab2x24(:,:,478))
  call Hloop_Q_A(ntryL,G1H6(45),51,nMT,G2H6(108),n2h6(662))
  call Hloop_AV_Q(ntryL,G1H24(8),wf4(:,14),G1H6(1120),m3h4x6(:,111),heltab2x24(:,:,479))
  call Hloop_A_Q(ntryL,G1H6(1120),51,0,G2H6(77),n2h6(663))
  call Hloop_AV_Q(ntryL,G1H24(9),wf4(:,14),G1H6(62),m3h4x6(:,112),heltab2x24(:,:,480))
  call Hloop_A_Q(ntryL,G1H6(62),51,nMT,G2H6(89),n2h6(664))
  call Hloop_QV_A(ntryL,G1H24(10),wf4(:,14),G1H6(68),m3h4x6(:,113),heltab2x24(:,:,481))
  call Hloop_Q_A(ntryL,G1H6(68),51,0,G2H6(81),n2h6(665))
  call Hloop_QV_A(ntryL,G1H24(11),wf4(:,14),G1H6(57),m3h4x6(:,114),heltab2x24(:,:,482))
  call Hloop_Q_A(ntryL,G1H6(57),51,nMB,G2H6(79),n2h6(666))
  call Hloop_AV_Q(ntryL,G1H24(37),wf4(:,14),G1H6(1014),m3h4x6(:,115),heltab2x24(:,:,483))
  call Hloop_A_Q(ntryL,G1H6(1014),51,0,G2H6(80),n2h6(667))
  call Hloop_AV_Q(ntryL,G1H24(38),wf4(:,14),G1H6(84),m3h4x6(:,116),heltab2x24(:,:,484))
  call Hloop_A_Q(ntryL,G1H6(84),51,nMB,G2H6(114),n2h6(668))
  call Hloop_AV_Q(ntryL,G1H24(39),ex3(:),G1H12(5),m3h2x12(:,229),heltab2x24(:,:,485))
  call Hloop_A_Q(ntryL,G1H12(5),52,0,G2H12(95),n2h12(463))
  call Hloop_AV_Q(ntryL,G1H24(40),ex3(:),G1H12(33),m3h2x12(:,230),heltab2x24(:,:,486))
  call Hloop_A_Q(ntryL,G1H12(33),52,nMT,G2H12(97),n2h12(464))
  call Hloop_QV_A(ntryL,G1H24(41),ex3(:),G1H12(6),m3h2x12(:,231),heltab2x24(:,:,487))
  call Hloop_Q_A(ntryL,G1H12(6),52,0,G2H12(98),n2h12(465))
  call Hloop_QV_A(ntryL,G1H24(44),ex3(:),G1H12(80),m3h2x12(:,232),heltab2x24(:,:,488))
  call Hloop_Q_A(ntryL,G1H12(80),52,nMT,G2H12(99),n2h12(466))
  call Hloop_AV_Q(ntryL,G1H24(45),ex3(:),G1H12(85),m3h2x12(:,233),heltab2x24(:,:,489))
  call Hloop_A_Q(ntryL,G1H12(85),52,0,G2H12(101),n2h12(467))
  call Hloop_AV_Q(ntryL,G1H24(46),ex3(:),G1H12(90),m3h2x12(:,234),heltab2x24(:,:,490))
  call Hloop_A_Q(ntryL,G1H12(90),52,nMB,G2H12(102),n2h12(468))
  call Hloop_QV_A(ntryL,G1H24(47),ex3(:),G1H12(91),m3h2x12(:,235),heltab2x24(:,:,491))
  call Hloop_Q_A(ntryL,G1H12(91),52,0,G2H12(103),n2h12(469))
  call Hloop_QV_A(ntryL,G1H24(49),ex3(:),G1H12(92),m3h2x12(:,236),heltab2x24(:,:,492))
  call Hloop_Q_A(ntryL,G1H12(92),52,nMB,G2H12(105),n2h12(470))
  call Hloop_AV_Q(ntryL,G1H48(1),ex3(:),G1H24(33),m3h2x24(:,115),heltab2x48(:,:,201))
  call Hloop_A_Q(ntryL,G1H24(33),36,0,G2H24(37),n2h24(201))
  call Hloop_AV_Q(ntryL,G1H48(2),ex3(:),G1H24(18),m3h2x24(:,116),heltab2x48(:,:,202))
  call Hloop_A_Q(ntryL,G1H24(18),36,nMT,G2H24(38),n2h24(202))
  call Hloop_QV_A(ntryL,G1H48(3),ex3(:),G1H24(1),m3h2x24(:,117),heltab2x48(:,:,203))
  call Hloop_Q_A(ntryL,G1H24(1),36,0,G2H24(39),n2h24(203))
  call Hloop_QV_A(ntryL,G1H48(4),ex3(:),G1H24(17),m3h2x24(:,118),heltab2x48(:,:,204))
  call Hloop_Q_A(ntryL,G1H24(17),36,nMT,G2H24(40),n2h24(204))
  call Hloop_AV_Q(ntryL,G1H48(5),ex3(:),G1H24(65),m3h2x24(:,119),heltab2x48(:,:,205))
  call Hloop_A_Q(ntryL,G1H24(65),36,0,G2H24(41),n2h24(205))
  call Hloop_AV_Q(ntryL,G1H48(6),ex3(:),G1H24(71),m3h2x24(:,120),heltab2x48(:,:,206))
  call Hloop_A_Q(ntryL,G1H24(71),36,nMB,G2H24(42),n2h24(206))
  call Hloop_QV_A(ntryL,G1H48(7),ex3(:),G1H24(76),m3h2x24(:,121),heltab2x48(:,:,207))
  call Hloop_Q_A(ntryL,G1H24(76),36,0,G2H24(43),n2h24(207))
  call Hloop_QV_A(ntryL,G1H48(8),ex3(:),G1H24(81),m3h2x24(:,122),heltab2x48(:,:,208))
  call Hloop_Q_A(ntryL,G1H24(81),36,nMB,G2H24(44),n2h24(208))
  call Hloop_QZ_A(ntryL,G1H48(9),ex4(:),G1H16(3),ngZu,m3h3x16(:,27),heltab2x48(:,:,209))
  call Hloop_Q_A(ntryL,G1H16(3),40,0,G2H16(14),n2h16(43))
  call Hloop_QZ_A(ntryL,G1H48(10),ex4(:),G1H16(9),ngZu,m3h3x16(:,28),heltab2x48(:,:,210))
  call Hloop_Q_A(ntryL,G1H16(9),40,nMT,G2H16(16),n2h16(44))
  call Hloop_AZ_Q(ntryL,G1H48(11),ex4(:),G1H16(2),ngZu,m3h3x16(:,29),heltab2x48(:,:,211))
  call Hloop_A_Q(ntryL,G1H16(2),40,0,G2H16(17),n2h16(45))
  call Hloop_AZ_Q(ntryL,G1H48(12),ex4(:),G1H16(4),ngZu,m3h3x16(:,30),heltab2x48(:,:,212))
  call Hloop_A_Q(ntryL,G1H16(4),40,nMT,G2H16(18),n2h16(46))
  call Hloop_QZ_A(ntryL,G1H48(13),ex4(:),G1H16(5),ngZd,m3h3x16(:,31),heltab2x48(:,:,213))
  call Hloop_Q_A(ntryL,G1H16(5),40,0,G2H16(19),n2h16(47))
  call Hloop_QZ_A(ntryL,G1H48(14),ex4(:),G1H16(6),ngZd,m3h3x16(:,32),heltab2x48(:,:,214))
  call Hloop_Q_A(ntryL,G1H16(6),40,nMB,G2H16(20),n2h16(48))
  call Hloop_AZ_Q(ntryL,G1H48(15),ex4(:),G1H16(7),ngZd,m3h3x16(:,33),heltab2x48(:,:,215))
  call Hloop_A_Q(ntryL,G1H16(7),40,0,G2H16(21),n2h16(49))
  call Hloop_AZ_Q(ntryL,G1H48(16),ex4(:),G1H16(10),ngZd,m3h3x16(:,34),heltab2x48(:,:,216))
  call Hloop_A_Q(ntryL,G1H16(10),40,nMB,G2H16(22),n2h16(50))
  call Hloop_QV_A(ntryL,G1H48(17),ex3(:),G1H24(21),m3h2x24(:,123),heltab2x48(:,:,217))
  call Hloop_Q_A(ntryL,G1H24(21),36,0,G2H24(45),n2h24(209))
  call Hloop_QV_A(ntryL,G1H48(18),ex3(:),G1H24(22),m3h2x24(:,124),heltab2x48(:,:,218))
  call Hloop_Q_A(ntryL,G1H24(22),36,nMT,G2H24(46),n2h24(210))
  call Hloop_AV_Q(ntryL,G1H48(19),ex3(:),G1H24(24),m3h2x24(:,125),heltab2x48(:,:,219))
  call Hloop_A_Q(ntryL,G1H24(24),36,0,G2H24(47),n2h24(211))
  call Hloop_AV_Q(ntryL,G1H48(20),ex3(:),G1H24(25),m3h2x24(:,126),heltab2x48(:,:,220))
  call Hloop_A_Q(ntryL,G1H24(25),36,nMT,G2H24(48),n2h24(212))
  call Hloop_QV_A(ntryL,G1H48(21),ex3(:),G1H24(26),m3h2x24(:,127),heltab2x48(:,:,221))
  call Hloop_Q_A(ntryL,G1H24(26),36,0,G2H24(49),n2h24(213))
  call Hloop_QV_A(ntryL,G1H48(22),ex3(:),G1H24(86),m3h2x24(:,128),heltab2x48(:,:,222))
  call Hloop_Q_A(ntryL,G1H24(86),36,nMB,G2H24(50),n2h24(214))
  call Hloop_AV_Q(ntryL,G1H48(23),ex3(:),G1H24(87),m3h2x24(:,129),heltab2x48(:,:,223))
  call Hloop_A_Q(ntryL,G1H24(87),36,0,G2H24(51),n2h24(215))
  call Hloop_AV_Q(ntryL,G1H48(24),ex3(:),G1H24(88),m3h2x24(:,130),heltab2x48(:,:,224))
  call Hloop_A_Q(ntryL,G1H24(88),36,nMB,G2H24(52),n2h24(216))
  call Hloop_QA_V(ntryL,G1H48(25),wf6(:,2),G1H8(253),m3h6x8(:,5),heltab2x48(:,:,225))
  call Hloop_VA_Q(ntryL,G1H48(26),wf6(:,2),G1H8(254),m3h6x8(:,6),heltab2x48(:,:,226))
  call Hloop_A_Q(ntryL,G1H8(254),42,nMT,G2H8(111),n2h8(243))
  call Hloop_AQ_V(ntryL,G1H48(27),wf4(:,3),G1H12(112),m3h4x12(:,57),heltab2x48(:,:,227))
  call Hloop_VQ_A(ntryL,G1H48(28),wf4(:,3),G1H12(130),m3h4x12(:,58),heltab2x48(:,:,228))
  call Hloop_Q_A(ntryL,G1H12(130),37,nMT,G2H12(106),n2h12(471))
  call Hloop_VQ_A(ntryL,G1H48(29),wf4(:,3),G1H12(117),m3h4x12(:,59),heltab2x48(:,:,229))
  call Hloop_Q_A(ntryL,G1H12(117),37,nMT,G2H12(107),n2h12(472))
  call Hloop_AQ_V(ntryL,G1H48(30),wf4(:,3),G1H12(129),m3h4x12(:,60),heltab2x48(:,:,230))
  call Hloop_AZ_Q(ntryL,G1H48(31),ex4(:),G1H16(11),ngZu,m3h3x16(:,35),heltab2x48(:,:,231))
  call Hloop_A_Q(ntryL,G1H16(11),40,nMT,G2H16(3),n2h16(51))
  call Hloop_AQ_V(ntryL,G1H48(32),wf4(:,3),G1H12(135),m3h4x12(:,61),heltab2x48(:,:,232))
  call Hloop_VQ_A(ntryL,G1H48(33),wf4(:,3),G1H12(153),m3h4x12(:,62),heltab2x48(:,:,233))
  call Hloop_Q_A(ntryL,G1H12(153),37,nMT,G2H12(109),n2h12(473))
  call Hloop_VQ_A(ntryL,G0H24(15),wf4(:,3),G0H6(1),m3h4x6(:,117),heltab2x24(:,:,493))
  call Hloop_Q_A(ntryL,G0H6(1),39,nMT,G1H6(85),n2h6(669))
  call Hloop_VQ_A(ntryL,G0H24(16),wf4(:,3),G0H6(2),m3h4x6(:,118),heltab2x24(:,:,494))
  call Hloop_Q_A(ntryL,G0H6(2),39,nMT,G1H6(97),n2h6(670))
  call Hloop_AQ_V(ntryL,G1H24(52),wf4(:,3),G1H6(98),m3h4x6(:,119),heltab2x24(:,:,495))
  call Hloop_QA_V(ntryL,G1H24(55),ex2(:),G1H12(154),m3h2x12(:,237),heltab2x24(:,:,496))
  call Hloop_QV_A(ntryL,G1H48(34),wf8(:,25),G1H6(108),m3h8x6(:,1),heltab2x48(:,:,234))
  call Hloop_Q_A(ntryL,G1H6(108),39,0,G2H6(116),n2h6(671))
  call Hloop_QV_A(ntryL,G1H48(35),wf8(:,25),G1H6(110),m3h8x6(:,2),heltab2x48(:,:,235))
  call Hloop_Q_A(ntryL,G1H6(110),39,nMT,G2H6(117),n2h6(672))
  call Hloop_AV_Q(ntryL,G1H48(36),wf8(:,25),G1H6(120),m3h8x6(:,3),heltab2x48(:,:,236))
  call Hloop_A_Q(ntryL,G1H6(120),39,0,G2H6(49),n2h6(673))
  call Hloop_AV_Q(ntryL,G1H48(37),wf8(:,25),G1H6(121),m3h8x6(:,4),heltab2x48(:,:,237))
  call Hloop_A_Q(ntryL,G1H6(121),39,nMT,G2H6(52),n2h6(674))
  call Hloop_QV_A(ntryL,G1H48(38),wf8(:,25),G1H6(122),m3h8x6(:,5),heltab2x48(:,:,238))
  call Hloop_Q_A(ntryL,G1H6(122),39,0,G2H6(56),n2h6(675))
  call Hloop_QV_A(ntryL,G1H48(39),wf8(:,25),G1H6(127),m3h8x6(:,6),heltab2x48(:,:,239))
  call Hloop_Q_A(ntryL,G1H6(127),39,nMB,G2H6(58),n2h6(676))
  call Hloop_AV_Q(ntryL,G1H48(40),wf8(:,25),G1H6(133),m3h8x6(:,7),heltab2x48(:,:,240))
  call Hloop_A_Q(ntryL,G1H6(133),39,0,G2H6(94),n2h6(677))
  call Hloop_AV_Q(ntryL,G1H48(41),wf8(:,25),G1H6(134),m3h8x6(:,8),heltab2x48(:,:,241))
  call Hloop_A_Q(ntryL,G1H6(134),39,nMB,G2H6(69),n2h6(678))
  call Hloop_AV_Q(ntryL,G1H48(42),wf8(:,25),G1H6(139),m3h8x6(:,9),heltab2x48(:,:,242))
  call Hloop_A_Q(ntryL,G1H6(139),39,0,G2H6(8),n2h6(679))
  call Hloop_AV_Q(ntryL,G1H48(43),wf8(:,25),G1H6(140),m3h8x6(:,10),heltab2x48(:,:,243))
  call Hloop_A_Q(ntryL,G1H6(140),39,nMT,G2H6(337),n2h6(680))
  call Hloop_QV_A(ntryL,G1H48(44),wf8(:,25),G1H6(146),m3h8x6(:,11),heltab2x48(:,:,244))
  call Hloop_Q_A(ntryL,G1H6(146),39,0,G2H6(305),n2h6(681))
  call Hloop_QV_A(ntryL,G1H48(45),wf8(:,25),G1H6(151),m3h8x6(:,12),heltab2x48(:,:,245))
  call Hloop_Q_A(ntryL,G1H6(151),39,nMT,G2H6(15),n2h6(682))
  call Hloop_AV_Q(ntryL,G1H48(46),wf8(:,25),G1H6(152),m3h8x6(:,13),heltab2x48(:,:,246))
  call Hloop_A_Q(ntryL,G1H6(152),39,0,G2H6(65),n2h6(683))
  call Hloop_AV_Q(ntryL,G1H48(47),wf8(:,25),G1H6(156),m3h8x6(:,14),heltab2x48(:,:,247))
  call Hloop_A_Q(ntryL,G1H6(156),39,nMB,G2H6(62),n2h6(684))
  call Hloop_QV_A(ntryL,G1H48(48),wf8(:,25),G1H6(93),m3h8x6(:,15),heltab2x48(:,:,248))
  call Hloop_Q_A(ntryL,G1H6(93),39,0,G2H6(22),n2h6(685))
  call Hloop_QV_A(ntryL,G1H48(49),wf8(:,25),G1H6(1099),m3h8x6(:,16),heltab2x48(:,:,249))
  call Hloop_Q_A(ntryL,G1H6(1099),39,nMB,G2H6(329),n2h6(686))
  call Hloop_QZ_A(ntryL,G1H48(50),ex4(:),G1H16(12),ngZu,m3h3x16(:,36),heltab2x48(:,:,250))
  call Hloop_Q_A(ntryL,G1H16(12),40,0,G2H16(1),n2h16(52))
  call Hloop_QZ_A(ntryL,G1H48(51),ex4(:),G1H16(13),ngZu,m3h3x16(:,37),heltab2x48(:,:,251))
  call Hloop_Q_A(ntryL,G1H16(13),40,nMT,G2H16(9),n2h16(53))
  call Hloop_AZ_Q(ntryL,G1H48(52),ex4(:),G1H16(14),ngZu,m3h3x16(:,38),heltab2x48(:,:,252))
  call Hloop_A_Q(ntryL,G1H16(14),40,0,G2H16(11),n2h16(54))
  call Hloop_AZ_Q(ntryL,G1H48(53),ex4(:),G1H16(16),ngZu,m3h3x16(:,39),heltab2x48(:,:,253))
  call Hloop_A_Q(ntryL,G1H16(16),40,nMT,G2H16(5),n2h16(55))
  call Hloop_QZ_A(ntryL,G1H48(54),ex4(:),G1H16(17),ngZd,m3h3x16(:,40),heltab2x48(:,:,254))
  call Hloop_Q_A(ntryL,G1H16(17),40,0,G2H16(4),n2h16(56))
  call Hloop_QZ_A(ntryL,G1H48(55),ex4(:),G1H16(18),ngZd,m3h3x16(:,41),heltab2x48(:,:,255))
  call Hloop_Q_A(ntryL,G1H16(18),40,nMB,G2H16(7),n2h16(57))
  call Hloop_AZ_Q(ntryL,G1H48(56),ex4(:),G1H16(19),ngZd,m3h3x16(:,42),heltab2x48(:,:,256))
  call Hloop_A_Q(ntryL,G1H16(19),40,0,G2H16(2),n2h16(58))
  call Hloop_AZ_Q(ntryL,G1H48(57),ex4(:),G1H16(20),ngZd,m3h3x16(:,43),heltab2x48(:,:,257))
  call Hloop_A_Q(ntryL,G1H16(20),40,nMB,G2H16(6),n2h16(59))
  call Hloop_VA_Q(ntryL,G1H48(58),ex2(:),G1H24(89),m3h2x24(:,131),heltab2x48(:,:,258))
  call Hloop_A_Q(ntryL,G1H24(89),34,nMT,G2H24(53),n2h24(217))
  call Hloop_QA_V(ntryL,G1H48(59),ex2(:),G1H24(90),m3h2x24(:,132),heltab2x48(:,:,259))
  call Hloop_AQ_V(ntryL,G1H48(60),wf12(:,5),G1H4(71),m3h12x4(:,1),heltab2x48(:,:,260))
  call Hloop_VQ_A(ntryL,G1H48(61),wf12(:,5),G1H4(33),m3h12x4(:,2),heltab2x48(:,:,261))
  call Hloop_Q_A(ntryL,G1H4(33),45,nMT,G2H4(45),n2h4(532))
  call Hloop_QA_V(ntryL,G1H48(62),ex2(:),G1H24(92),m3h2x24(:,133),heltab2x48(:,:,262))
  call Hloop_VA_Q(ntryL,G1H48(63),ex2(:),G1H24(93),m3h2x24(:,134),heltab2x48(:,:,263))
  call Hloop_A_Q(ntryL,G1H24(93),34,nMT,G2H24(54),n2h24(218))
  call Hloop_VA_Q(ntryL,G1H48(64),ex2(:),G1H24(94),m3h2x24(:,135),heltab2x48(:,:,264))
  call Hloop_A_Q(ntryL,G1H24(94),34,nMT,G2H24(55),n2h24(219))
  call Hloop_QZ_A(ntryL,G1H48(65),ex4(:),G1H16(22),ngZu,m3h3x16(:,44),heltab2x48(:,:,265))
  call Hloop_Q_A(ntryL,G1H16(22),40,nMT,G2H16(8),n2h16(60))
  call Hloop_QA_V(ntryL,G1H48(66),ex2(:),G1H24(95),m3h2x24(:,136),heltab2x48(:,:,266))
  call Hloop_VA_Q(ntryL,G0H12(4),ex2(:),G0H6(3),m3h2x6(:,424),heltab2x12(:,:,805))
  call Hloop_A_Q(ntryL,G0H6(3),39,nMT,G1H6(168),n2h6(687))
  call Hloop_VA_Q(ntryL,G0H12(5),ex2(:),G0H6(4),m3h2x6(:,425),heltab2x12(:,:,806))
  call Hloop_A_Q(ntryL,G0H6(4),39,nMT,G1H6(169),n2h6(688))
  call Hloop_QA_V(ntryL,G1H48(67),wf4(:,9),G1H12(165),m3h4x12(:,63),heltab2x48(:,:,267))
  call Hloop_VA_Q(ntryL,G1H48(68),wf4(:,9),G1H12(189),m3h4x12(:,64),heltab2x48(:,:,268))
  call Hloop_A_Q(ntryL,G1H12(189),38,nMT,G2H12(110),n2h12(474))
  call Hloop_AQ_V(ntryL,G1H48(69),wf6(:,4),G1H8(269),m3h6x8(:,7),heltab2x48(:,:,269))
  call Hloop_VQ_A(ntryL,G1H48(70),wf6(:,4),G1H8(270),m3h6x8(:,8),heltab2x48(:,:,270))
  call Hloop_Q_A(ntryL,G1H8(270),41,nMT,G2H8(113),n2h8(244))
  call Hloop_VA_Q(ntryL,G1H48(71),wf4(:,9),G1H12(219),m3h4x12(:,65),heltab2x48(:,:,271))
  call Hloop_A_Q(ntryL,G1H12(219),38,nMT,G2H12(38),n2h12(475))
  call Hloop_QA_V(ntryL,G1H48(72),wf4(:,9),G1H12(190),m3h4x12(:,66),heltab2x48(:,:,272))
  call Hloop_QA_V(ntryL,G1H48(73),wf4(:,9),G1H12(208),m3h4x12(:,67),heltab2x48(:,:,273))
  call Hloop_QZ_A(ntryL,G1H48(74),ex4(:),G1H16(23),ngZu,m3h3x16(:,45),heltab2x48(:,:,274))
  call Hloop_Q_A(ntryL,G1H16(23),40,nMT,G2H16(13),n2h16(61))
  call Hloop_VA_Q(ntryL,G1H48(75),wf4(:,9),G1H12(220),m3h4x12(:,68),heltab2x48(:,:,275))
  call Hloop_A_Q(ntryL,G1H12(220),38,nMT,G2H12(36),n2h12(476))
  call Hloop_VA_Q(ntryL,G0H24(13),wf4(:,9),G0H6(5),m3h4x6(:,120),heltab2x24(:,:,497))
  call Hloop_A_Q(ntryL,G0H6(5),39,nMT,G1H6(176),n2h6(689))
  call Hloop_VA_Q(ntryL,G0H24(14),wf4(:,9),G0H6(6),m3h4x6(:,121),heltab2x24(:,:,498))
  call Hloop_A_Q(ntryL,G0H6(6),39,nMT,G1H6(180),n2h6(690))
  call Hloop_QA_V(ntryL,G1H24(14),wf4(:,9),G1H6(181),m3h4x6(:,122),heltab2x24(:,:,499))
  call Hloop_AQ_V(ntryL,G1H24(63),ex1(:),G1H12(238),m3h2x12(:,238),heltab2x24(:,:,500))
  call Hloop_QV_A(ntryL,G1H48(76),wf8(:,26),G1H6(182),m3h8x6(:,17),heltab2x48(:,:,276))
  call Hloop_Q_A(ntryL,G1H6(182),39,0,G2H6(25),n2h6(691))
  call Hloop_QV_A(ntryL,G1H48(77),wf8(:,26),G1H6(192),m3h8x6(:,18),heltab2x48(:,:,277))
  call Hloop_Q_A(ntryL,G1H6(192),39,nMT,G2H6(26),n2h6(692))
  call Hloop_AV_Q(ntryL,G1H48(78),wf8(:,26),G1H6(193),m3h8x6(:,19),heltab2x48(:,:,278))
  call Hloop_A_Q(ntryL,G1H6(193),39,0,G2H6(297),n2h6(693))
  call Hloop_AV_Q(ntryL,G1H48(79),wf8(:,26),G1H6(194),m3h8x6(:,20),heltab2x48(:,:,279))
  call Hloop_A_Q(ntryL,G1H6(194),39,nMT,G2H6(93),n2h6(694))
  call Hloop_QV_A(ntryL,G1H48(80),wf8(:,26),G1H6(200),m3h8x6(:,21),heltab2x48(:,:,280))
  call Hloop_Q_A(ntryL,G1H6(200),39,0,G2H6(34),n2h6(695))
  call Hloop_QV_A(ntryL,G1H48(81),wf8(:,26),G1H6(105),m3h8x6(:,22),heltab2x48(:,:,281))
  call Hloop_Q_A(ntryL,G1H6(105),39,nMB,G2H6(72),n2h6(696))
  call Hloop_AV_Q(ntryL,G1H48(82),wf8(:,26),G1H6(993),m3h8x6(:,23),heltab2x48(:,:,282))
  call Hloop_A_Q(ntryL,G1H6(993),39,0,G2H6(38),n2h6(697))
  call Hloop_AV_Q(ntryL,G1H48(83),wf8(:,26),G1H6(218),m3h8x6(:,24),heltab2x48(:,:,283))
  call Hloop_A_Q(ntryL,G1H6(218),39,nMB,G2H6(68),n2h6(698))
  call Hloop_AV_Q(ntryL,G1H48(84),wf8(:,26),G1H6(223),m3h8x6(:,25),heltab2x48(:,:,284))
  call Hloop_A_Q(ntryL,G1H6(223),39,0,G2H6(66),n2h6(699))
  call Hloop_AV_Q(ntryL,G1H48(85),wf8(:,26),G1H6(229),m3h8x6(:,26),heltab2x48(:,:,285))
  call Hloop_A_Q(ntryL,G1H6(229),39,nMT,G2H6(44),n2h6(700))
  call Hloop_QV_A(ntryL,G1H48(86),wf8(:,26),G1H6(230),m3h8x6(:,27),heltab2x48(:,:,286))
  call Hloop_Q_A(ntryL,G1H6(230),39,0,G2H6(45),n2h6(701))
  call Hloop_QV_A(ntryL,G1H48(87),wf8(:,26),G1H6(235),m3h8x6(:,28),heltab2x48(:,:,287))
  call Hloop_Q_A(ntryL,G1H6(235),39,nMT,G2H6(96),n2h6(702))
  call Hloop_AV_Q(ntryL,G1H48(88),wf8(:,26),G1H6(236),m3h8x6(:,29),heltab2x48(:,:,288))
  call Hloop_A_Q(ntryL,G1H6(236),39,0,G2H6(50),n2h6(703))
  call Hloop_AV_Q(ntryL,G1H48(89),wf8(:,26),G1H6(242),m3h8x6(:,30),heltab2x48(:,:,289))
  call Hloop_A_Q(ntryL,G1H6(242),39,nMB,G2H6(95),n2h6(704))
  call Hloop_QV_A(ntryL,G1H48(90),wf8(:,26),G1H6(247),m3h8x6(:,31),heltab2x48(:,:,290))
  call Hloop_Q_A(ntryL,G1H6(247),39,0,G2H6(63),n2h6(705))
  call Hloop_QV_A(ntryL,G1H48(91),wf8(:,26),G1H6(248),m3h8x6(:,32),heltab2x48(:,:,291))
  call Hloop_Q_A(ntryL,G1H6(248),39,nMB,G2H6(70),n2h6(706))
  call Hloop_QZ_A(ntryL,G1H48(92),ex4(:),G1H16(24),ngZu,m3h3x16(:,46),heltab2x48(:,:,292))
  call Hloop_Q_A(ntryL,G1H16(24),40,0,G2H16(10),n2h16(62))
  call Hloop_QZ_A(ntryL,G1H48(93),ex4(:),G1H16(25),ngZu,m3h3x16(:,47),heltab2x48(:,:,293))
  call Hloop_Q_A(ntryL,G1H16(25),40,nMT,G2H16(15),n2h16(63))
  call Hloop_AZ_Q(ntryL,G1H48(94),ex4(:),G1H16(26),ngZu,m3h3x16(:,48),heltab2x48(:,:,294))
  call Hloop_A_Q(ntryL,G1H16(26),40,0,G2H16(12),n2h16(64))
  call Hloop_AZ_Q(ntryL,G1H48(95),ex4(:),G1H16(28),ngZu,m3h3x16(:,49),heltab2x48(:,:,295))
  call Hloop_A_Q(ntryL,G1H16(28),40,nMT,G2H16(23),n2h16(65))
  call Hloop_QZ_A(ntryL,G1H48(96),ex4(:),G1H16(29),ngZd,m3h3x16(:,50),heltab2x48(:,:,296))
  call Hloop_Q_A(ntryL,G1H16(29),40,0,G2H16(24),n2h16(66))
  call Hloop_QZ_A(ntryL,G1H48(97),ex4(:),G1H16(30),ngZd,m3h3x16(:,51),heltab2x48(:,:,297))
  call Hloop_Q_A(ntryL,G1H16(30),40,nMB,G2H16(25),n2h16(67))
  call Hloop_AZ_Q(ntryL,G1H48(98),ex4(:),G1H16(31),ngZd,m3h3x16(:,52),heltab2x48(:,:,298))
  call Hloop_A_Q(ntryL,G1H16(31),40,0,G2H16(26),n2h16(68))
  call Hloop_AZ_Q(ntryL,G1H48(99),ex4(:),G1H16(32),ngZd,m3h3x16(:,53),heltab2x48(:,:,299))
  call Hloop_A_Q(ntryL,G1H16(32),40,nMB,G2H16(27),n2h16(69))
  call Hloop_VQ_A(ntryL,G1H48(100),ex1(:),G1H24(96),m3h2x24(:,137),heltab2x48(:,:,300))
  call Hloop_Q_A(ntryL,G1H24(96),33,nMT,G2H24(56),n2h24(220))
  call Hloop_AQ_V(ntryL,G1H48(101),ex1(:),G1H24(98),m3h2x24(:,138),heltab2x48(:,:,301))
  call Hloop_QA_V(ntryL,G1H48(102),wf12(:,16),G1H4(69),m3h12x4(:,3),heltab2x48(:,:,302))
  call Hloop_VA_Q(ntryL,G1H48(103),wf12(:,16),G1H4(107),m3h12x4(:,4),heltab2x48(:,:,303))
  call Hloop_A_Q(ntryL,G1H4(107),46,nMT,G2H4(145),n2h4(533))
  call Hloop_AQ_V(ntryL,G1H48(104),ex1(:),G1H24(99),m3h2x24(:,139),heltab2x48(:,:,304))
  call Hloop_VQ_A(ntryL,G1H48(105),ex1(:),G1H24(100),m3h2x24(:,140),heltab2x48(:,:,305))
  call Hloop_Q_A(ntryL,G1H24(100),33,nMT,G2H24(57),n2h24(221))
  call Hloop_VQ_A(ntryL,G1H48(106),ex1(:),G1H24(101),m3h2x24(:,141),heltab2x48(:,:,306))
  call Hloop_Q_A(ntryL,G1H24(101),33,nMT,G2H24(58),n2h24(222))
  call Hloop_AZ_Q(ntryL,G1H48(107),ex4(:),G1H16(34),ngZu,m3h3x16(:,54),heltab2x48(:,:,307))
  call Hloop_A_Q(ntryL,G1H16(34),40,nMT,G2H16(28),n2h16(70))
  call Hloop_AQ_V(ntryL,G1H48(108),ex1(:),G1H24(102),m3h2x24(:,142),heltab2x48(:,:,308))
  call Hloop_VQ_A(ntryL,G0H12(9),ex1(:),G0H6(7),m3h2x6(:,426),heltab2x12(:,:,807))
  call Hloop_Q_A(ntryL,G0H6(7),39,nMT,G1H6(252),n2h6(707))
  call Hloop_VQ_A(ntryL,G0H12(12),ex1(:),G0H6(8),m3h2x6(:,427),heltab2x12(:,:,808))
  call Hloop_Q_A(ntryL,G0H6(8),39,nMT,G1H6(259),n2h6(708))
  call Hloop_AV_Q(ntryL,G1H48(109),ex3(:),G1H24(104),m3h2x24(:,143),heltab2x48(:,:,309))
  call Hloop_A_Q(ntryL,G1H24(104),36,nMT,G2H24(59),n2h24(223))
  call Hloop_QV_A(ntryL,G1H48(110),ex3(:),G1H24(105),m3h2x24(:,144),heltab2x48(:,:,310))
  call Hloop_Q_A(ntryL,G1H24(105),36,nMT,G2H24(60),n2h24(224))
  call Hloop_VQ_A(ntryL,G1H48(111),wf6(:,4),G1H8(32),m3h6x8(:,9),heltab2x48(:,:,311))
  call Hloop_Q_A(ntryL,G1H8(32),41,nMT,G2H8(114),n2h8(245))
  call Hloop_VQ_A(ntryL,G0H24(17),wf6(:,4),G0H4(1),m3h6x4(:,13),heltab2x24(:,:,501))
  call Hloop_Q_A(ntryL,G0H4(1),43,nMT,G1H4(119),n2h4(534))
  call Hloop_QV_A(ntryL,G1H24(72),ex3(:),G1H12(243),m3h2x12(:,239),heltab2x24(:,:,502))
  call Hloop_Q_A(ntryL,G1H12(243),52,nMT,G2H12(49),n2h12(477))
  call Hloop_QA_V(ntryL,G1H24(74),ex2(:),G1H12(244),m3h2x12(:,240),heltab2x24(:,:,503))
  call Hloop_AV_Q(ntryL,G1H48(116),ex3(:),G1H24(106),m3h2x24(:,145),heltab2x48(:,:,312))
  call Hloop_A_Q(ntryL,G1H24(106),36,0,G2H24(61),n2h24(225))
  call Hloop_AV_Q(ntryL,G1H48(113),ex3(:),G1H24(107),m3h2x24(:,146),heltab2x48(:,:,313))
  call Hloop_A_Q(ntryL,G1H24(107),36,nMT,G2H24(62),n2h24(226))
  call Hloop_QV_A(ntryL,G1H48(118),ex3(:),G1H24(108),m3h2x24(:,147),heltab2x48(:,:,314))
  call Hloop_Q_A(ntryL,G1H24(108),36,0,G2H24(5),n2h24(227))
  call Hloop_QV_A(ntryL,G1H48(115),ex3(:),G1H24(110),m3h2x24(:,148),heltab2x48(:,:,315))
  call Hloop_Q_A(ntryL,G1H24(110),36,nMT,G2H24(6),n2h24(228))
  call Hloop_AV_Q(ntryL,G1H48(117),ex3(:),G1H24(111),m3h2x24(:,149),heltab2x48(:,:,316))
  call Hloop_A_Q(ntryL,G1H24(111),36,nMB,G2H24(7),n2h24(229))
  call Hloop_QV_A(ntryL,G1H48(119),ex3(:),G1H24(112),m3h2x24(:,150),heltab2x48(:,:,317))
  call Hloop_Q_A(ntryL,G1H24(112),36,nMB,G2H24(8),n2h24(230))
  call Hloop_AV_Q(ntryL,G1H48(124),wf12(:,27),G1H4(171),m3h12x4(:,5),heltab2x48(:,:,318))
  call Hloop_A_Q(ntryL,G1H4(171),43,0,G2H4(70),n2h4(535))
  call Hloop_AV_Q(ntryL,G1H48(121),wf12(:,27),G1H4(137),m3h12x4(:,6),heltab2x48(:,:,319))
  call Hloop_A_Q(ntryL,G1H4(137),43,nMT,G2H4(51),n2h4(536))
  call Hloop_QV_A(ntryL,G1H48(126),wf12(:,27),G1H4(93),m3h12x4(:,7),heltab2x48(:,:,320))
  call Hloop_Q_A(ntryL,G1H4(93),43,0,G2H4(48),n2h4(537))
  call Hloop_QV_A(ntryL,G1H48(123),wf12(:,27),G1H4(1),m3h12x4(:,8),heltab2x48(:,:,321))
  call Hloop_Q_A(ntryL,G1H4(1),43,nMT,G2H4(49),n2h4(538))
  call Hloop_AV_Q(ntryL,G1H48(125),wf12(:,27),G1H4(99),m3h12x4(:,9),heltab2x48(:,:,322))
  call Hloop_A_Q(ntryL,G1H4(99),43,nMB,G2H4(146),n2h4(539))
  call Hloop_QV_A(ntryL,G1H48(127),wf12(:,27),G1H4(188),m3h12x4(:,10),heltab2x48(:,:,323))
  call Hloop_Q_A(ntryL,G1H4(188),43,nMB,G2H4(54),n2h4(540))
  call Hloop_QV_A(ntryL,G1H48(132),ex3(:),G1H24(113),m3h2x24(:,151),heltab2x48(:,:,324))
  call Hloop_Q_A(ntryL,G1H24(113),36,0,G2H24(9),n2h24(231))
  call Hloop_QV_A(ntryL,G1H48(129),ex3(:),G1H24(114),m3h2x24(:,152),heltab2x48(:,:,325))
  call Hloop_Q_A(ntryL,G1H24(114),36,nMT,G2H24(10),n2h24(232))
  call Hloop_AV_Q(ntryL,G1H48(134),ex3(:),G1H24(116),m3h2x24(:,153),heltab2x48(:,:,326))
  call Hloop_A_Q(ntryL,G1H24(116),36,0,G2H24(11),n2h24(233))
  call Hloop_AV_Q(ntryL,G1H48(131),ex3(:),G1H24(117),m3h2x24(:,154),heltab2x48(:,:,327))
  call Hloop_A_Q(ntryL,G1H24(117),36,nMT,G2H24(12),n2h24(234))
  call Hloop_QV_A(ntryL,G1H48(133),ex3(:),G1H24(118),m3h2x24(:,155),heltab2x48(:,:,328))
  call Hloop_Q_A(ntryL,G1H24(118),36,nMB,G2H24(13),n2h24(235))
  call Hloop_AV_Q(ntryL,G1H48(135),ex3(:),G1H24(119),m3h2x24(:,156),heltab2x48(:,:,329))
  call Hloop_A_Q(ntryL,G1H24(119),36,nMB,G2H24(14),n2h24(236))
  call Hloop_VA_Q(ntryL,G1H48(136),ex2(:),G1H24(120),m3h2x24(:,157),heltab2x48(:,:,330))
  call Hloop_A_Q(ntryL,G1H24(120),34,nMT,G2H24(15),n2h24(237))
  call Hloop_QA_V(ntryL,G1H48(137),ex2(:),G1H24(122),m3h2x24(:,158),heltab2x48(:,:,331))
  call Hloop_AQ_V(ntryL,G1H48(138),wf12(:,20),G1H4(154),m3h12x4(:,11),heltab2x48(:,:,332))
  call Hloop_VQ_A(ntryL,G1H48(139),wf12(:,20),G1H4(81),m3h12x4(:,12),heltab2x48(:,:,333))
  call Hloop_Q_A(ntryL,G1H4(81),45,nMT,G2H4(79),n2h4(541))
  call Hloop_QA_V(ntryL,G1H48(140),ex2(:),G1H24(123),m3h2x24(:,159),heltab2x48(:,:,334))
  call Hloop_VA_Q(ntryL,G1H48(141),ex2(:),G1H24(124),m3h2x24(:,160),heltab2x48(:,:,335))
  call Hloop_A_Q(ntryL,G1H24(124),34,nMT,G2H24(16),n2h24(238))
  call Hloop_VA_Q(ntryL,G1H48(142),ex2(:),G1H24(125),m3h2x24(:,161),heltab2x48(:,:,336))
  call Hloop_A_Q(ntryL,G1H24(125),34,nMT,G2H24(17),n2h24(239))
  call Hloop_QV_A(ntryL,G1H48(143),ex3(:),G1H24(126),m3h2x24(:,162),heltab2x48(:,:,337))
  call Hloop_Q_A(ntryL,G1H24(126),36,nMT,G2H24(18),n2h24(240))
  call Hloop_QA_V(ntryL,G1H48(144),ex2(:),G1H24(128),m3h2x24(:,163),heltab2x48(:,:,338))
  call Hloop_VA_Q(ntryL,G0H8(8),ex2(:),G0H4(2),m3h2x4(:,225),heltab2x8(:,:,333))
  call Hloop_A_Q(ntryL,G0H4(2),43,nMT,G1H4(22),n2h4(542))
  call Hloop_VA_Q(ntryL,G0H8(9),ex2(:),G0H4(3),m3h2x4(:,226),heltab2x8(:,:,334))
  call Hloop_A_Q(ntryL,G0H4(3),43,nMT,G1H4(10),n2h4(543))
  call Hloop_AV_Q(ntryL,G1H48(145),ex3(:),G1H24(129),m3h2x24(:,164),heltab2x48(:,:,339))
  call Hloop_A_Q(ntryL,G1H24(129),36,nMT,G2H24(19),n2h24(241))
  call Hloop_QV_A(ntryL,G1H48(146),ex3(:),G1H24(130),m3h2x24(:,165),heltab2x48(:,:,340))
  call Hloop_Q_A(ntryL,G1H24(130),36,nMT,G2H24(20),n2h24(242))
  call Hloop_VA_Q(ntryL,G1H48(147),wf6(:,2),G1H8(37),m3h6x8(:,10),heltab2x48(:,:,341))
  call Hloop_A_Q(ntryL,G1H8(37),42,nMT,G2H8(115),n2h8(246))
  call Hloop_VA_Q(ntryL,G0H24(12),wf6(:,2),G0H4(4),m3h6x4(:,14),heltab2x24(:,:,504))
  call Hloop_A_Q(ntryL,G0H4(4),43,nMT,G1H4(16),n2h4(544))
  call Hloop_AV_Q(ntryL,G1H24(80),ex3(:),G1H12(252),m3h2x12(:,241),heltab2x24(:,:,505))
  call Hloop_A_Q(ntryL,G1H12(252),52,nMT,G2H12(39),n2h12(478))
  call Hloop_AQ_V(ntryL,G1H24(83),ex1(:),G1H12(258),m3h2x12(:,242),heltab2x24(:,:,506))
  call Hloop_AV_Q(ntryL,G1H48(152),ex3(:),G1H24(131),m3h2x24(:,166),heltab2x48(:,:,342))
  call Hloop_A_Q(ntryL,G1H24(131),36,0,G2H24(1),n2h24(243))
  call Hloop_AV_Q(ntryL,G1H48(149),ex3(:),G1H24(132),m3h2x24(:,167),heltab2x48(:,:,343))
  call Hloop_A_Q(ntryL,G1H24(132),36,nMT,G2H24(2),n2h24(244))
  call Hloop_QV_A(ntryL,G1H48(154),ex3(:),G1H24(134),m3h2x24(:,168),heltab2x48(:,:,344))
  call Hloop_Q_A(ntryL,G1H24(134),36,0,G2H24(3),n2h24(245))
  call Hloop_QV_A(ntryL,G1H48(151),ex3(:),G1H24(135),m3h2x24(:,169),heltab2x48(:,:,345))
  call Hloop_Q_A(ntryL,G1H24(135),36,nMT,G2H24(4),n2h24(246))
  call Hloop_AV_Q(ntryL,G1H48(153),ex3(:),G1H24(136),m3h2x24(:,170),heltab2x48(:,:,346))
  call Hloop_A_Q(ntryL,G1H24(136),36,nMB,G2H24(21),n2h24(247))
  call Hloop_QV_A(ntryL,G1H48(155),ex3(:),G1H24(137),m3h2x24(:,171),heltab2x48(:,:,347))
  call Hloop_Q_A(ntryL,G1H24(137),36,nMB,G2H24(22),n2h24(248))
  call Hloop_AV_Q(ntryL,G1H48(160),wf12(:,28),G1H4(21),m3h12x4(:,13),heltab2x48(:,:,348))
  call Hloop_A_Q(ntryL,G1H4(21),43,0,G2H4(58),n2h4(545))
  call Hloop_AV_Q(ntryL,G1H48(157),wf12(:,28),G1H4(40),m3h12x4(:,14),heltab2x48(:,:,349))
  call Hloop_A_Q(ntryL,G1H4(40),43,nMT,G2H4(56),n2h4(546))
  call Hloop_QV_A(ntryL,G1H48(162),wf12(:,28),G1H4(45),m3h12x4(:,15),heltab2x48(:,:,350))
  call Hloop_Q_A(ntryL,G1H4(45),43,0,G2H4(57),n2h4(547))
  call Hloop_QV_A(ntryL,G1H48(159),wf12(:,28),G1H4(58),m3h12x4(:,16),heltab2x48(:,:,351))
  call Hloop_Q_A(ntryL,G1H4(58),43,nMT,G2H4(61),n2h4(548))
  call Hloop_AV_Q(ntryL,G1H48(161),wf12(:,28),G1H4(65),m3h12x4(:,17),heltab2x48(:,:,352))
  call Hloop_A_Q(ntryL,G1H4(65),43,nMB,G2H4(94),n2h4(549))
  call Hloop_QV_A(ntryL,G1H48(163),wf12(:,28),G1H4(82),m3h12x4(:,18),heltab2x48(:,:,353))
  call Hloop_Q_A(ntryL,G1H4(82),43,nMB,G2H4(65),n2h4(550))
  call Hloop_QV_A(ntryL,G1H48(168),ex3(:),G1H24(138),m3h2x24(:,172),heltab2x48(:,:,354))
  call Hloop_Q_A(ntryL,G1H24(138),36,0,G2H24(23),n2h24(249))
  call Hloop_QV_A(ntryL,G1H48(165),ex3(:),G1H24(140),m3h2x24(:,173),heltab2x48(:,:,355))
  call Hloop_Q_A(ntryL,G1H24(140),36,nMT,G2H24(24),n2h24(250))
  call Hloop_AV_Q(ntryL,G1H48(170),ex3(:),G1H24(141),m3h2x24(:,174),heltab2x48(:,:,356))
  call Hloop_A_Q(ntryL,G1H24(141),36,0,G2H24(25),n2h24(251))
  call Hloop_AV_Q(ntryL,G1H48(167),ex3(:),G1H24(142),m3h2x24(:,175),heltab2x48(:,:,357))
  call Hloop_A_Q(ntryL,G1H24(142),36,nMT,G2H24(26),n2h24(252))
  call Hloop_QV_A(ntryL,G1H48(169),ex3(:),G1H24(143),m3h2x24(:,176),heltab2x48(:,:,358))
  call Hloop_Q_A(ntryL,G1H24(143),36,nMB,G2H24(27),n2h24(253))
  call Hloop_AV_Q(ntryL,G1H48(171),ex3(:),G1H24(144),m3h2x24(:,177),heltab2x48(:,:,359))
  call Hloop_A_Q(ntryL,G1H24(144),36,nMB,G2H24(28),n2h24(254))
  call Hloop_VQ_A(ntryL,G1H48(172),ex1(:),G1H24(146),m3h2x24(:,178),heltab2x48(:,:,360))
  call Hloop_Q_A(ntryL,G1H24(146),33,nMT,G2H24(29),n2h24(255))
  call Hloop_AQ_V(ntryL,G1H48(173),ex1(:),G1H24(147),m3h2x24(:,179),heltab2x48(:,:,361))
  call Hloop_QA_V(ntryL,G1H48(174),wf12(:,22),G1H4(88),m3h12x4(:,19),heltab2x48(:,:,362))
  call Hloop_VA_Q(ntryL,G1H48(175),wf12(:,22),G1H4(94),m3h12x4(:,20),heltab2x48(:,:,363))
  call Hloop_A_Q(ntryL,G1H4(94),46,nMT,G2H4(63),n2h4(551))
  call Hloop_AQ_V(ntryL,G1H48(176),ex1(:),G1H24(148),m3h2x24(:,180),heltab2x48(:,:,364))
  call Hloop_VQ_A(ntryL,G1H48(177),ex1(:),G1H24(149),m3h2x24(:,181),heltab2x48(:,:,365))
  call Hloop_Q_A(ntryL,G1H24(149),33,nMT,G2H24(30),n2h24(256))
  call Hloop_VQ_A(ntryL,G1H48(178),ex1(:),G1H24(150),m3h2x24(:,182),heltab2x48(:,:,366))
  call Hloop_Q_A(ntryL,G1H24(150),33,nMT,G2H24(31),n2h24(257))
  call Hloop_AV_Q(ntryL,G1H48(179),ex3(:),G1H24(152),m3h2x24(:,183),heltab2x48(:,:,367))
  call Hloop_A_Q(ntryL,G1H24(152),36,nMT,G2H24(32),n2h24(258))
  call Hloop_AQ_V(ntryL,G1H48(180),ex1(:),G1H24(153),m3h2x24(:,184),heltab2x48(:,:,368))
  call Hloop_VQ_A(ntryL,G0H8(11),ex1(:),G0H4(5),m3h2x4(:,227),heltab2x8(:,:,335))
  call Hloop_Q_A(ntryL,G0H4(5),43,nMT,G1H4(100),n2h4(552))
  call Hloop_VQ_A(ntryL,G0H8(12),ex1(:),G0H4(6),m3h2x4(:,228),heltab2x8(:,:,336))
  call Hloop_Q_A(ntryL,G0H4(6),43,nMT,G1H4(112),n2h4(553))
  call Hloop_AV_Q(ntryL,G1H48(181),ex3(:),G1H24(154),m3h2x24(:,185),heltab2x48(:,:,369))
  call Hloop_A_Q(ntryL,G1H24(154),36,0,G2H24(33),n2h24(259))
  call Hloop_AV_Q(ntryL,G1H48(182),ex3(:),G1H24(155),m3h2x24(:,186),heltab2x48(:,:,370))
  call Hloop_A_Q(ntryL,G1H24(155),36,nMT,G2H24(34),n2h24(260))
  call Hloop_QV_A(ntryL,G1H48(183),ex3(:),G1H24(156),m3h2x24(:,187),heltab2x48(:,:,371))
  call Hloop_Q_A(ntryL,G1H24(156),36,0,G2H24(35),n2h24(261))
  call Hloop_QV_A(ntryL,G1H48(184),ex3(:),G1H24(158),m3h2x24(:,188),heltab2x48(:,:,372))
  call Hloop_Q_A(ntryL,G1H24(158),36,nMT,G2H24(36),n2h24(262))
  call Hloop_AV_Q(ntryL,G1H48(185),ex3(:),G1H24(159),m3h2x24(:,189),heltab2x48(:,:,373))
  call Hloop_A_Q(ntryL,G1H24(159),36,0,G2H24(63),n2h24(263))
  call Hloop_AV_Q(ntryL,G1H48(186),ex3(:),G1H24(160),m3h2x24(:,190),heltab2x48(:,:,374))
  call Hloop_A_Q(ntryL,G1H24(160),36,nMB,G2H24(64),n2h24(264))
  call Hloop_QV_A(ntryL,G1H48(187),ex3(:),G1H24(161),m3h2x24(:,191),heltab2x48(:,:,375))
  call Hloop_Q_A(ntryL,G1H24(161),36,0,G2H24(65),n2h24(265))
  call Hloop_QV_A(ntryL,G1H48(188),ex3(:),G1H24(162),m3h2x24(:,192),heltab2x48(:,:,376))
  call Hloop_Q_A(ntryL,G1H24(162),36,nMB,G2H24(66),n2h24(266))
  call Hloop_QZ_A(ntryL,G1H48(189),ex4(:),G1H16(35),ngZu,m3h3x16(:,55),heltab2x48(:,:,377))
  call Hloop_Q_A(ntryL,G1H16(35),40,0,G2H16(29),n2h16(71))
  call Hloop_QZ_A(ntryL,G1H48(190),ex4(:),G1H16(36),ngZu,m3h3x16(:,56),heltab2x48(:,:,378))
  call Hloop_Q_A(ntryL,G1H16(36),40,nMT,G2H16(30),n2h16(72))
  call Hloop_AZ_Q(ntryL,G1H48(191),ex4(:),G1H16(37),ngZu,m3h3x16(:,57),heltab2x48(:,:,379))
  call Hloop_A_Q(ntryL,G1H16(37),40,0,G2H16(31),n2h16(73))
  call Hloop_AZ_Q(ntryL,G1H48(192),ex4(:),G1H16(38),ngZu,m3h3x16(:,58),heltab2x48(:,:,380))
  call Hloop_A_Q(ntryL,G1H16(38),40,nMT,G2H16(32),n2h16(74))
  call Hloop_QZ_A(ntryL,G1H48(193),ex4(:),G1H16(40),ngZd,m3h3x16(:,59),heltab2x48(:,:,381))
  call Hloop_Q_A(ntryL,G1H16(40),40,0,G2H16(33),n2h16(75))
  call Hloop_QZ_A(ntryL,G1H48(194),ex4(:),G1H16(41),ngZd,m3h3x16(:,60),heltab2x48(:,:,382))
  call Hloop_Q_A(ntryL,G1H16(41),40,nMB,G2H16(34),n2h16(76))
  call Hloop_AZ_Q(ntryL,G1H48(195),ex4(:),G1H16(42),ngZd,m3h3x16(:,61),heltab2x48(:,:,383))
  call Hloop_A_Q(ntryL,G1H16(42),40,0,G2H16(35),n2h16(77))
  call Hloop_AZ_Q(ntryL,G1H48(196),ex4(:),G1H16(43),ngZd,m3h3x16(:,62),heltab2x48(:,:,384))
  call Hloop_A_Q(ntryL,G1H16(43),40,nMB,G2H16(36),n2h16(78))
  call Hloop_QV_A(ntryL,G1H48(197),ex3(:),G1H24(164),m3h2x24(:,193),heltab2x48(:,:,385))
  call Hloop_Q_A(ntryL,G1H24(164),36,0,G2H24(67),n2h24(267))
  call Hloop_QV_A(ntryL,G1H48(198),ex3(:),G1H24(165),m3h2x24(:,194),heltab2x48(:,:,386))
  call Hloop_Q_A(ntryL,G1H24(165),36,nMT,G2H24(68),n2h24(268))
  call Hloop_AV_Q(ntryL,G1H48(199),ex3(:),G1H24(166),m3h2x24(:,195),heltab2x48(:,:,387))
  call Hloop_A_Q(ntryL,G1H24(166),36,0,G2H24(69),n2h24(269))
  call Hloop_AV_Q(ntryL,G1H48(200),ex3(:),G1H24(167),m3h2x24(:,196),heltab2x48(:,:,388))
  call Hloop_A_Q(ntryL,G1H24(167),36,nMT,G2H24(70),n2h24(270))
  call Hloop_QV_A(ntryL,G1H48(201),ex3(:),G1H24(168),m3h2x24(:,197),heltab2x48(:,:,389))
  call Hloop_Q_A(ntryL,G1H24(168),36,0,G2H24(71),n2h24(271))
  call Hloop_QV_A(ntryL,G1H48(202),ex3(:),G1H24(170),m3h2x24(:,198),heltab2x48(:,:,390))
  call Hloop_Q_A(ntryL,G1H24(170),36,nMB,G2H24(72),n2h24(272))
  call Hloop_AV_Q(ntryL,G1H48(203),ex3(:),G1H24(171),m3h2x24(:,199),heltab2x48(:,:,391))
  call Hloop_A_Q(ntryL,G1H24(171),36,0,G2H24(73),n2h24(273))
  call Hloop_AV_Q(ntryL,G1H48(204),ex3(:),G1H24(172),m3h2x24(:,200),heltab2x48(:,:,392))
  call Hloop_A_Q(ntryL,G1H24(172),36,nMB,G2H24(74),n2h24(274))
  call Hloop_VA_Q(ntryL,G1H48(205),ex2(:),G1H24(173),m3h2x24(:,201),heltab2x48(:,:,393))
  call Hloop_A_Q(ntryL,G1H24(173),34,nMT,G2H24(75),n2h24(275))
  call Hloop_QZ_A(ntryL,G1H48(206),ex4(:),G1H16(44),ngZu,m3h3x16(:,63),heltab2x48(:,:,394))
  call Hloop_Q_A(ntryL,G1H16(44),40,nMT,G2H16(37),n2h16(79))
  call Hloop_QA_V(ntryL,G1H48(207),ex2(:),G1H24(174),m3h2x24(:,202),heltab2x48(:,:,395))
  call Hloop_VA_Q(ntryL,G1H48(208),ex2(:),G1H24(176),m3h2x24(:,203),heltab2x48(:,:,396))
  call Hloop_A_Q(ntryL,G1H24(176),34,nMT,G2H24(76),n2h24(276))
  call Hloop_QV_A(ntryL,G1H48(209),ex3(:),G1H24(177),m3h2x24(:,204),heltab2x48(:,:,397))
  call Hloop_Q_A(ntryL,G1H24(177),36,nMT,G2H24(77),n2h24(277))
  call Hloop_QA_V(ntryL,G1H48(210),ex2(:),G1H24(178),m3h2x24(:,205),heltab2x48(:,:,398))
  call Hloop_VA_Q(ntryL,G0H12(17),ex2(:),G0H6(9),m3h2x6(:,428),heltab2x12(:,:,809))
  call Hloop_A_Q(ntryL,G0H6(9),51,nMT,G1H6(260),n2h6(709))
  call Hloop_VA_Q(ntryL,G0H12(18),ex2(:),G0H6(10),m3h2x6(:,429),heltab2x12(:,:,810))
  call Hloop_A_Q(ntryL,G0H6(10),51,nMT,G1H6(265),n2h6(710))
  call Hloop_AV_Q(ntryL,G1H48(211),ex3(:),G1H24(179),m3h2x24(:,206),heltab2x48(:,:,399))
  call Hloop_A_Q(ntryL,G1H24(179),36,0,G2H24(78),n2h24(278))
  call Hloop_AV_Q(ntryL,G1H48(212),ex3(:),G1H24(180),m3h2x24(:,207),heltab2x48(:,:,400))
  call Hloop_A_Q(ntryL,G1H24(180),36,nMT,G2H24(79),n2h24(279))
  call Hloop_QV_A(ntryL,G1H48(213),ex3(:),G1H24(182),m3h2x24(:,208),heltab2x48(:,:,401))
  call Hloop_Q_A(ntryL,G1H24(182),36,0,G2H24(80),n2h24(280))
  call Hloop_QV_A(ntryL,G1H48(214),ex3(:),G1H24(183),m3h2x24(:,209),heltab2x48(:,:,402))
  call Hloop_Q_A(ntryL,G1H24(183),36,nMT,G2H24(81),n2h24(281))
  call Hloop_AV_Q(ntryL,G1H48(215),ex3(:),G1H24(184),m3h2x24(:,210),heltab2x48(:,:,403))
  call Hloop_A_Q(ntryL,G1H24(184),36,0,G2H24(82),n2h24(282))
  call Hloop_AV_Q(ntryL,G1H48(216),ex3(:),G1H24(185),m3h2x24(:,211),heltab2x48(:,:,404))
  call Hloop_A_Q(ntryL,G1H24(185),36,nMB,G2H24(83),n2h24(283))
  call Hloop_QV_A(ntryL,G1H48(217),ex3(:),G1H24(186),m3h2x24(:,212),heltab2x48(:,:,405))
  call Hloop_Q_A(ntryL,G1H24(186),36,0,G2H24(84),n2h24(284))
  call Hloop_QV_A(ntryL,G1H48(218),ex3(:),G1H24(188),m3h2x24(:,213),heltab2x48(:,:,406))
  call Hloop_Q_A(ntryL,G1H24(188),36,nMB,G2H24(85),n2h24(285))
  call Hloop_QZ_A(ntryL,G1H48(219),ex4(:),G1H16(46),ngZu,m3h3x16(:,64),heltab2x48(:,:,407))
  call Hloop_Q_A(ntryL,G1H16(46),40,0,G2H16(38),n2h16(80))
  call Hloop_QZ_A(ntryL,G1H48(220),ex4(:),G1H16(47),ngZu,m3h3x16(:,65),heltab2x48(:,:,408))
  call Hloop_Q_A(ntryL,G1H16(47),40,nMT,G2H16(39),n2h16(81))
  call Hloop_AZ_Q(ntryL,G1H48(221),ex4(:),G1H16(48),ngZu,m3h3x16(:,66),heltab2x48(:,:,409))
  call Hloop_A_Q(ntryL,G1H16(48),40,0,G2H16(40),n2h16(82))
  call Hloop_AZ_Q(ntryL,G1H48(222),ex4(:),G1H16(49),ngZu,m3h3x16(:,67),heltab2x48(:,:,410))
  call Hloop_A_Q(ntryL,G1H16(49),40,nMT,G2H16(41),n2h16(83))
  call Hloop_QZ_A(ntryL,G1H48(223),ex4(:),G1H16(50),ngZd,m3h3x16(:,68),heltab2x48(:,:,411))
  call Hloop_Q_A(ntryL,G1H16(50),40,0,G2H16(42),n2h16(84))
  call Hloop_QZ_A(ntryL,G1H48(224),ex4(:),G1H16(52),ngZd,m3h3x16(:,69),heltab2x48(:,:,412))
  call Hloop_Q_A(ntryL,G1H16(52),40,nMB,G2H16(43),n2h16(85))
  call Hloop_AZ_Q(ntryL,G1H48(225),ex4(:),G1H16(53),ngZd,m3h3x16(:,70),heltab2x48(:,:,413))
  call Hloop_A_Q(ntryL,G1H16(53),40,0,G2H16(44),n2h16(86))
  call Hloop_AZ_Q(ntryL,G1H48(226),ex4(:),G1H16(54),ngZd,m3h3x16(:,71),heltab2x48(:,:,414))
  call Hloop_A_Q(ntryL,G1H16(54),40,nMB,G2H16(45),n2h16(87))
  call Hloop_QV_A(ntryL,G1H48(227),ex3(:),G1H24(189),m3h2x24(:,214),heltab2x48(:,:,415))
  call Hloop_Q_A(ntryL,G1H24(189),36,0,G2H24(86),n2h24(286))
  call Hloop_QV_A(ntryL,G1H48(228),ex3(:),G1H24(190),m3h2x24(:,215),heltab2x48(:,:,416))
  call Hloop_Q_A(ntryL,G1H24(190),36,nMT,G2H24(87),n2h24(287))
  call Hloop_AV_Q(ntryL,G1H48(229),ex3(:),G1H24(191),m3h2x24(:,216),heltab2x48(:,:,417))
  call Hloop_A_Q(ntryL,G1H24(191),36,0,G2H24(88),n2h24(288))
  call Hloop_AV_Q(ntryL,G1H48(230),ex3(:),G1H24(192),m3h2x24(:,217),heltab2x48(:,:,418))
  call Hloop_A_Q(ntryL,G1H24(192),36,nMT,G2H24(89),n2h24(289))
  call Hloop_QV_A(ntryL,G1H48(231),ex3(:),G1H24(194),m3h2x24(:,218),heltab2x48(:,:,419))
  call Hloop_Q_A(ntryL,G1H24(194),36,0,G2H24(90),n2h24(290))
  call Hloop_QV_A(ntryL,G1H48(232),ex3(:),G1H24(195),m3h2x24(:,219),heltab2x48(:,:,420))
  call Hloop_Q_A(ntryL,G1H24(195),36,nMB,G2H24(91),n2h24(291))
  call Hloop_AV_Q(ntryL,G1H48(233),ex3(:),G1H24(196),m3h2x24(:,220),heltab2x48(:,:,421))
  call Hloop_A_Q(ntryL,G1H24(196),36,0,G2H24(92),n2h24(292))
  call Hloop_AV_Q(ntryL,G1H48(234),ex3(:),G1H24(197),m3h2x24(:,221),heltab2x48(:,:,422))
  call Hloop_A_Q(ntryL,G1H24(197),36,nMB,G2H24(93),n2h24(293))
  call Hloop_VQ_A(ntryL,G1H48(235),ex1(:),G1H24(198),m3h2x24(:,222),heltab2x48(:,:,423))
  call Hloop_Q_A(ntryL,G1H24(198),33,nMT,G2H24(94),n2h24(294))
  call Hloop_AZ_Q(ntryL,G1H48(236),ex4(:),G1H16(55),ngZu,m3h3x16(:,72),heltab2x48(:,:,424))
  call Hloop_A_Q(ntryL,G1H16(55),40,nMT,G2H16(46),n2h16(88))
  call Hloop_AQ_V(ntryL,G1H48(237),ex1(:),G1H24(200),m3h2x24(:,223),heltab2x48(:,:,425))
  call Hloop_VQ_A(ntryL,G1H48(238),ex1(:),G1H24(201),m3h2x24(:,224),heltab2x48(:,:,426))
  call Hloop_Q_A(ntryL,G1H24(201),33,nMT,G2H24(95),n2h24(295))
  call Hloop_AV_Q(ntryL,G1H48(239),ex3(:),G1H24(202),m3h2x24(:,225),heltab2x48(:,:,427))
  call Hloop_A_Q(ntryL,G1H24(202),36,nMT,G2H24(96),n2h24(296))
  call Hloop_AQ_V(ntryL,G1H48(240),ex1(:),G1H24(203),m3h2x24(:,226),heltab2x48(:,:,428))
  call Hloop_VQ_A(ntryL,G0H12(19),ex1(:),G0H6(11),m3h2x6(:,430),heltab2x12(:,:,811))
  call Hloop_Q_A(ntryL,G0H6(11),51,nMT,G1H6(266),n2h6(711))
  call Hloop_VQ_A(ntryL,G0H12(20),ex1(:),G0H6(12),m3h2x6(:,431),heltab2x12(:,:,812))
  call Hloop_Q_A(ntryL,G0H6(12),51,nMT,G1H6(276),n2h6(712))
  call ol_merge(ntryL,G2H4(219),[G2H4(207),G2H4(100),G2H4(69)])
  call ol_merge(ntryL,G2H4(63),[G2H4(145),G2H4(161),G2H4(149),G2H4(104),G2H4(73)])
  call ol_merge(ntryL,G2H4(224),[G2H4(211),G2H4(4),G2H4(83)])
  call ol_merge(ntryL,G2H4(79),[G2H4(45),G2H4(170),G2H4(153),G2H4(6),G2H4(84)])
  call ol_merge(ntryL,G2H6(170),[G2H6(165),G2H6(53),G2H6(46),G1H6(516),G1H6(497),G1H6(130)])
  call ol_merge(ntryL,G2H6(120),[G2H6(111),G2H6(55),G2H6(48),G1H6(522),G1H6(503),G1H6(131)])
  call ol_merge(ntryL,G2H4(232),[G2H4(215),G2H4(19),G2H4(91),G1H4(370),G1H4(332),G1H4(186)])
  call ol_merge(ntryL,G2H4(178),[G2H4(157),G2H4(22),G2H4(93),G1H4(376),G1H4(338),G1H4(187)])
  call ol_merge(ntryL,G2H4(236),[G2H4(228),G2H4(26),G2H4(10),G1H4(390),G1H4(351),G1H4(231)])
  call ol_merge(ntryL,G2H4(182),[G2H4(174),G2H4(28),G2H4(12),G1H4(396),G1H4(357),G1H4(232)])
call ol_merge_last(G2H4(206), G2H4(206)) 
  call ol_merge(ntryL,G2H4(326),[G2H4(206),G2H4(116)])
  call ol_merge(ntryL,G2H4(267),[G1H4(129)])
call HGT_lower_alpha_w2_OLR(G2H4(326),1,1,4)
call HGT_lower_alpha_w2_invQ_OLR(G2H4(326),2,5,4)
call HGT_lower_alpha_w2_OLR(G2H4(326),6,15,4)
  call ol_merge(ntryL,G2H4(326),[G2H4(267)])



end subroutine vamp_8

end module ol_vamp_8_ppzatt_ttxazgg_1_/**/REALKIND
