
module ol_vamp_5_ppwwtt_ttxwwxgg_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_5(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppwwtt_ttxwwxgg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppwwtt_ttxwwxgg_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_ppwwtt_ttxwwxgg_1_/**/DREALKIND
  use ol_tensor_sum_storage_ppwwtt_ttxwwxgg_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_ppwwtt_ttxwwxgg_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_ppwwtt_ttxwwxgg_1_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL, hel_states
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(hel_states)
  type(Hpolcont), intent(in) :: M(3,hel_states)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel(1:hel_states)
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel(1:hel_states)
#endif

  ! =============================================
  call Hotf_5pt_reduction_last(G2tensor(208),RedSet_5(35),mass5set(:,17),  & 
G1tensor(481),G1tensor(482),G1tensor(483),G1tensor(484),G1tensor(485),G1tensor(486))
  call G_TensorShift(G1tensor(482),8)
  call Hotf_5pt_reduction_last(G2tensor(347),RedSet_5(101),mass5set(:,53),  & 
G1tensor(487),G1tensor(488),G1tensor(489),G1tensor(490),G1tensor(491),G1tensor(492))
  call G_TensorShift(G1tensor(488),4)
  call Hotf_5pt_reduction_last(G2tensor(350),RedSet_5(102),mass5set(:,7),  & 
G1tensor(493),G1tensor(494),G1tensor(495),G1tensor(496),G1tensor(497),G1tensor(498))
  call G_TensorShift(G1tensor(494),4)
  call Hotf_5pt_reduction_last(G2tensor(216),RedSet_5(36),mass5set(:,17),  & 
G1tensor(499),G1tensor(500),G1tensor(501),G1tensor(502),G1tensor(503),G1tensor(504))
  call G_TensorShift(G1tensor(500),4)
  call Hotf_5pt_reduction_last(G2tensor(93),RedSet_5(61),mass5set(:,4),  & 
G1tensor(505),G1tensor(506),G1tensor(507),G1tensor(508),G1tensor(509),G1tensor(510))
  call G_TensorShift(G1tensor(506),5)
  call Hotf_5pt_reduction_last(G2tensor(95),RedSet_5(62),mass5set(:,5),  & 
G1tensor(511),G1tensor(512),G1tensor(513),G1tensor(514),G1tensor(515),G1tensor(516))
  call G_TensorShift(G1tensor(512),5)
  call Hotf_5pt_reduction_last(G2tensor(97),RedSet_5(6),mass5set(:,4),  & 
G1tensor(517),G1tensor(518),G1tensor(519),G1tensor(520),G1tensor(521),G1tensor(522))
  call G_TensorShift(G1tensor(518),10)
  call Hotf_5pt_reduction_last(G2tensor(99),RedSet_5(7),mass5set(:,5),  & 
G1tensor(523),G1tensor(524),G1tensor(525),G1tensor(526),G1tensor(527),G1tensor(528))
  call G_TensorShift(G1tensor(524),10)
  call Hotf_5pt_reduction_last(G2tensor(101),RedSet_5(4),mass5set(:,3),  & 
G1tensor(529),G1tensor(530),G1tensor(531),G1tensor(532),G1tensor(533),G1tensor(534))
  call G_TensorShift(G1tensor(530),17)
  call Hotf_5pt_reduction_last(G2tensor(103),RedSet_5(5),mass5set(:,3),  & 
G1tensor(535),G1tensor(536),G1tensor(537),G1tensor(538),G1tensor(539),G1tensor(540))
  call G_TensorShift(G1tensor(536),18)
  call Hotf_5pt_reduction_last(G2tensor(359),RedSet_5(3),mass5set(:,2),  & 
G1tensor(541),G1tensor(542),G1tensor(543),G1tensor(544),G1tensor(545),G1tensor(546))
  call G_TensorShift(G1tensor(542),10)
  call Hotf_5pt_reduction_last(G2tensor(363),RedSet_5(2),mass5set(:,1),  & 
G1tensor(547),G1tensor(548),G1tensor(549),G1tensor(550),G1tensor(551),G1tensor(552))
  call G_TensorShift(G1tensor(548),17)
  call Hotf_5pt_reduction_last(G2tensor(367),RedSet_5(1),mass5set(:,1),  & 
G1tensor(553),G1tensor(554),G1tensor(555),G1tensor(556),G1tensor(557),G1tensor(558))
  call G_TensorShift(G1tensor(554),18)
  call Hotf_5pt_reduction_last(G2tensor(405),RedSet_5(14),mass5set(:,9),  & 
G1tensor(559),G1tensor(560),G1tensor(561),G1tensor(562),G1tensor(563),G1tensor(564))
  call G_TensorShift(G1tensor(560),10)
  call Hotf_5pt_reduction_last(G2tensor(417),RedSet_5(11),mass5set(:,8),  & 
G1tensor(565),G1tensor(566),G1tensor(567),G1tensor(568),G1tensor(569),G1tensor(570))
  call G_TensorShift(G1tensor(566),12)
  call Hotf_5pt_reduction_last(G2tensor(429),RedSet_5(13),mass5set(:,8),  & 
G1tensor(571),G1tensor(572),G1tensor(573),G1tensor(574),G1tensor(575),G1tensor(576))
  call G_TensorShift(G1tensor(572),12)
  call Hotf_5pt_reduction_last(G2tensor(441),RedSet_5(16),mass5set(:,10),  & 
G1tensor(577),G1tensor(578),G1tensor(579),G1tensor(580),G1tensor(581),G1tensor(582))
  call G_TensorShift(G1tensor(578),12)
  call Hotf_5pt_reduction_last(G2tensor(453),RedSet_5(15),mass5set(:,10),  & 
G1tensor(583),G1tensor(584),G1tensor(585),G1tensor(586),G1tensor(587),G1tensor(588))
  call G_TensorShift(G1tensor(584),12)
  call Hotf_5pt_reduction_last(G2tensor(461),RedSet_5(49),mass5set(:,29),  & 
G1tensor(589),G1tensor(590),G1tensor(591),G1tensor(592),G1tensor(593),G1tensor(594))
  call G_TensorShift(G1tensor(590),8)
  call Hotf_5pt_reduction_last(G2tensor(465),RedSet_5(49),mass5set(:,30),  & 
G1tensor(595),G1tensor(596),G1tensor(597),G1tensor(598),G1tensor(599),G1tensor(600))
  call G_TensorShift(G1tensor(596),8)
  call Hotf_5pt_reduction_last(G2tensor(473),RedSet_5(50),mass5set(:,29),  & 
G1tensor(601),G1tensor(602),G1tensor(603),G1tensor(604),G1tensor(605),G1tensor(606))
  call G_TensorShift(G1tensor(602),16)
  call Hotf_5pt_reduction_last(G2tensor(477),RedSet_5(50),mass5set(:,31),  & 
G1tensor(607),G1tensor(608),G1tensor(609),G1tensor(610),G1tensor(611),G1tensor(612))
  call G_TensorShift(G1tensor(608),16)
  call Hotf_5pt_reduction_last(G2tensor(485),RedSet_5(52),mass5set(:,29),  & 
G1tensor(613),G1tensor(614),G1tensor(615),G1tensor(616),G1tensor(617),G1tensor(618))
  call G_TensorShift(G1tensor(614),4)
  call Hotf_5pt_reduction_last(G2tensor(489),RedSet_5(52),mass5set(:,30),  & 
G1tensor(619),G1tensor(620),G1tensor(621),G1tensor(622),G1tensor(623),G1tensor(624))
  call G_TensorShift(G1tensor(620),4)
  call Hotf_5pt_reduction_last(G2tensor(497),RedSet_5(26),mass5set(:,29),  & 
G1tensor(625),G1tensor(626),G1tensor(627),G1tensor(628),G1tensor(629),G1tensor(630))
  call G_TensorShift(G1tensor(626),16)
  call Hotf_5pt_reduction_last(G2tensor(501),RedSet_5(26),mass5set(:,32),  & 
G1tensor(631),G1tensor(632),G1tensor(633),G1tensor(634),G1tensor(635),G1tensor(636))
  call G_TensorShift(G1tensor(632),16)
  call Hotf_5pt_reduction_last(G2tensor(509),RedSet_5(47),mass5set(:,29),  & 
G1tensor(637),G1tensor(638),G1tensor(639),G1tensor(640),G1tensor(641),G1tensor(642))
  call G_TensorShift(G1tensor(638),16)
  call Hotf_5pt_reduction_last(G2tensor(513),RedSet_5(47),mass5set(:,31),  & 
G1tensor(643),G1tensor(644),G1tensor(645),G1tensor(646),G1tensor(647),G1tensor(648))
  call G_TensorShift(G1tensor(644),16)
  call Hotf_5pt_reduction_last(G2tensor(521),RedSet_5(25),mass5set(:,29),  & 
G1tensor(649),G1tensor(650),G1tensor(651),G1tensor(652),G1tensor(653),G1tensor(654))
  call G_TensorShift(G1tensor(650),16)
  call Hotf_5pt_reduction_last(G2tensor(525),RedSet_5(25),mass5set(:,32),  & 
G1tensor(655),G1tensor(656),G1tensor(657),G1tensor(658),G1tensor(659),G1tensor(660))
  call G_TensorShift(G1tensor(656),16)
  call Hotf_5pt_reduction_last(G2tensor(533),RedSet_5(51),mass5set(:,29),  & 
G1tensor(661),G1tensor(662),G1tensor(663),G1tensor(664),G1tensor(665),G1tensor(666))
  call G_TensorShift(G1tensor(662),4)
  call Hotf_5pt_reduction_last(G2tensor(537),RedSet_5(51),mass5set(:,33),  & 
G1tensor(667),G1tensor(668),G1tensor(669),G1tensor(670),G1tensor(671),G1tensor(672))
  call G_TensorShift(G1tensor(668),4)
  call Hotf_5pt_reduction_last(G2tensor(545),RedSet_5(27),mass5set(:,29),  & 
G1tensor(673),G1tensor(674),G1tensor(675),G1tensor(676),G1tensor(677),G1tensor(678))
  call G_TensorShift(G1tensor(674),8)
  call Hotf_5pt_reduction_last(G2tensor(549),RedSet_5(27),mass5set(:,34),  & 
G1tensor(679),G1tensor(680),G1tensor(681),G1tensor(682),G1tensor(683),G1tensor(684))
  call G_TensorShift(G1tensor(680),8)
  call Hotf_5pt_reduction_last(G2tensor(557),RedSet_5(48),mass5set(:,29),  & 
G1tensor(685),G1tensor(686),G1tensor(687),G1tensor(688),G1tensor(689),G1tensor(690))
  call G_TensorShift(G1tensor(686),8)
  call Hotf_5pt_reduction_last(G2tensor(561),RedSet_5(48),mass5set(:,33),  & 
G1tensor(691),G1tensor(692),G1tensor(693),G1tensor(694),G1tensor(695),G1tensor(696))
  call G_TensorShift(G1tensor(692),8)
  call Hotf_5pt_reduction_last(G2tensor(573),RedSet_5(58),mass5set(:,29),  & 
G1tensor(697),G1tensor(698),G1tensor(699),G1tensor(700),G1tensor(701),G1tensor(702))
  call G_TensorShift(G1tensor(698),16)
  call Hotf_5pt_reduction_last(G2tensor(569),RedSet_5(58),mass5set(:,35),  & 
G1tensor(703),G1tensor(704),G1tensor(705),G1tensor(706),G1tensor(707),G1tensor(708))
  call G_TensorShift(G1tensor(704),16)
  call Hotf_5pt_reduction_last(G2tensor(581),RedSet_5(59),mass5set(:,29),  & 
G1tensor(709),G1tensor(710),G1tensor(711),G1tensor(712),G1tensor(713),G1tensor(714))
  call G_TensorShift(G1tensor(710),8)
  call Hotf_5pt_reduction_last(G2tensor(585),RedSet_5(59),mass5set(:,34),  & 
G1tensor(715),G1tensor(716),G1tensor(717),G1tensor(718),G1tensor(719),G1tensor(720))
  call G_TensorShift(G1tensor(716),8)
  call Hotf_5pt_reduction_last(G2tensor(597),RedSet_5(60),mass5set(:,29),  & 
G1tensor(721),G1tensor(722),G1tensor(723),G1tensor(724),G1tensor(725),G1tensor(726))
  call G_TensorShift(G1tensor(722),16)
  call Hotf_5pt_reduction_last(G2tensor(593),RedSet_5(60),mass5set(:,35),  & 
G1tensor(727),G1tensor(728),G1tensor(729),G1tensor(730),G1tensor(731),G1tensor(732))
  call G_TensorShift(G1tensor(728),16)
  call ol_merge_tensors(T1sum(21),[G1tensor(1)])
  call ol_merge_tensors(T1sum(22),[G1tensor(37)])
  call ol_merge_tensors(T1sum(23),[G1tensor(73)])
  call ol_merge_tensors(T1sum(24),[G1tensor(109)])
  call ol_merge_tensors(T1sum(25),[G1tensor(44)])
  call ol_merge_tensors(T1sum(26),[G1tensor(74)])
  call ol_merge_tensors(T1sum(27),[G1tensor(98)])
  call ol_merge_tensors(T1sum(28),[G1tensor(75)])
  call ol_merge_tensors(T1sum(29),[G1tensor(12)])
  call ol_merge_tensors(T1sum(30),[G1tensor(11)])
  call ol_merge_tensors(T1sum(31),[G1tensor(21)])
  call ol_merge_tensors(T1sum(32),[G1tensor(29)])
  call ol_merge_tensors(T1sum(33),[G1tensor(40)])
  call ol_merge_tensors(T1sum(34),[G1tensor(47)])
  call ol_merge_tensors(T1sum(35),[G1tensor(59)])
  call ol_merge_tensors(T1sum(36),[G1tensor(70)])
  call ol_merge_tensors(T1sum(37),[G1tensor(78)])
  call ol_merge_tensors(T1sum(38),[G1tensor(89)])
  call ol_merge_tensors(T1sum(39),[G1tensor(96)])
  call ol_merge_tensors(T1sum(40),[G1tensor(111)])
  call ol_merge_tensors(T1sum(41),[G1tensor(121)])
  call ol_merge_tensors(T1sum(42),[G1tensor(127)])
  call ol_merge_tensors(T1sum(43),[G1tensor(133)])
  call ol_merge_tensors(T1sum(44),[G1tensor(139)])
  call ol_merge_tensors(T1sum(45),[G1tensor(145)])
  call ol_merge_tensors(T1sum(46),[G1tensor(151)])
  call ol_merge_tensors(T1sum(47),[G1tensor(157)])
  call ol_merge_tensors(T1sum(48),[G1tensor(163)])
  call ol_merge_tensors(T1sum(49),[G1tensor(169)])
  call ol_merge_tensors(T1sum(50),[G1tensor(175)])
  call ol_merge_tensors(T1sum(51),[G1tensor(181)])
  call ol_merge_tensors(T1sum(52),[G1tensor(187)])
  call ol_merge_tensors(T1sum(53),[G1tensor(193)])
  call ol_merge_tensors(T1sum(54),[G1tensor(199)])
  call ol_merge_tensors(T1sum(55),[G1tensor(205)])
  call ol_merge_tensors(T1sum(56),[G1tensor(211)])
  call ol_merge_tensors(T1sum(57),[G1tensor(217)])
  call ol_merge_tensors(T1sum(58),[G1tensor(223)])
  call ol_merge_tensors(T1sum(59),[G1tensor(229)])
  call ol_merge_tensors(T1sum(60),[G1tensor(235)])
  call ol_merge_tensors(T1sum(61),[G1tensor(241)])
  call ol_merge_tensors(T1sum(62),[G1tensor(247)])
  call ol_merge_tensors(T1sum(63),[G1tensor(253)])
  call ol_merge_tensors(T1sum(64),[G1tensor(259)])
  call ol_merge_tensors(T1sum(65),[G1tensor(265)])
  call ol_merge_tensors(T1sum(66),[G1tensor(271)])
  call ol_merge_tensors(T1sum(67),[G1tensor(277)])
  call ol_merge_tensors(T1sum(68),[G1tensor(283)])
  call ol_merge_tensors(T1sum(69),[G1tensor(289)])
  call ol_merge_tensors(T1sum(70),[G1tensor(295)])
  call ol_merge_tensors(T1sum(71),[G1tensor(301)])
  call ol_merge_tensors(T1sum(72),[G1tensor(307)])
  call ol_merge_tensors(T1sum(73),[G1tensor(313)])
  call ol_merge_tensors(T1sum(74),[G1tensor(319)])
  call ol_merge_tensors(T1sum(75),[G1tensor(325)])
  call ol_merge_tensors(T1sum(76),[G1tensor(331)])
  call ol_merge_tensors(T1sum(77),[G1tensor(337)])
  call ol_merge_tensors(T1sum(78),[G1tensor(343)])
  call ol_merge_tensors(T1sum(79),[G1tensor(349)])
  call ol_merge_tensors(T1sum(80),[G1tensor(355)])
  call ol_merge_tensors(T1sum(81),[G1tensor(361)])
  call ol_merge_tensors(T1sum(82),[G1tensor(367)])
  call ol_merge_tensors(T1sum(83),[G1tensor(373)])
  call ol_merge_tensors(T1sum(84),[G1tensor(379)])
  call ol_merge_tensors(T1sum(85),[G1tensor(385)])
  call ol_merge_tensors(T1sum(86),[G1tensor(391)])
  call ol_merge_tensors(T1sum(87),[G1tensor(397)])
  call ol_merge_tensors(T1sum(88),[G1tensor(403)])
  call ol_merge_tensors(T1sum(89),[G1tensor(409)])
  call ol_merge_tensors(T1sum(90),[G1tensor(415)])
  call ol_merge_tensors(T1sum(91),[G1tensor(421)])
  call ol_merge_tensors(T1sum(92),[G1tensor(427)])
  call ol_merge_tensors(T1sum(93),[G1tensor(433)])
  call ol_merge_tensors(T1sum(94),[G1tensor(439)])
  call ol_merge_tensors(T1sum(95),[G1tensor(445)])
  call ol_merge_tensors(T1sum(96),[G1tensor(451)])
  call ol_merge_tensors(T1sum(97),[G1tensor(457)])
  call ol_merge_tensors(T1sum(98),[G1tensor(463)])
  call ol_merge_tensors(T1sum(99),[G1tensor(469)])
  call ol_merge_tensors(T1sum(100),[G1tensor(475)])
  call ol_merge_tensors(T1sum(101),[G1tensor(481)])
  call ol_merge_tensors(T1sum(102),[G1tensor(487)])
  call ol_merge_tensors(T1sum(103),[G1tensor(493)])
  call ol_merge_tensors(T1sum(104),[G1tensor(499)])
  call ol_merge_tensors(T1sum(105),[G1tensor(505)])
  call ol_merge_tensors(T1sum(106),[G1tensor(511)])
  call ol_merge_tensors(T1sum(107),[G1tensor(517)])
  call ol_merge_tensors(T1sum(108),[G1tensor(523)])
  call ol_merge_tensors(T1sum(109),[G1tensor(529)])
  call ol_merge_tensors(T1sum(110),[G1tensor(535)])
  call ol_merge_tensors(T1sum(111),[G1tensor(541)])
  call ol_merge_tensors(T1sum(112),[G1tensor(547)])
  call ol_merge_tensors(T1sum(113),[G1tensor(553)])
  call ol_merge_tensors(T1sum(114),[G1tensor(559)])
  call ol_merge_tensors(T1sum(115),[G1tensor(565)])
  call ol_merge_tensors(T1sum(116),[G1tensor(571)])
  call ol_merge_tensors(T1sum(117),[G1tensor(577)])
  call ol_merge_tensors(T1sum(118),[G1tensor(583)])
  call ol_merge_tensors(T1sum(119),[G1tensor(589)])
  call ol_merge_tensors(T1sum(120),[G1tensor(595)])
  call ol_merge_tensors(T1sum(121),[G1tensor(601)])
  call ol_merge_tensors(T1sum(122),[G1tensor(607)])
  call ol_merge_tensors(T1sum(123),[G1tensor(613)])
  call ol_merge_tensors(T1sum(124),[G1tensor(619)])
  call ol_merge_tensors(T1sum(125),[G1tensor(625)])
  call ol_merge_tensors(T1sum(126),[G1tensor(631)])
  call ol_merge_tensors(T1sum(127),[G1tensor(637)])
  call ol_merge_tensors(T1sum(128),[G1tensor(643)])
  call ol_merge_tensors(T1sum(129),[G1tensor(649)])
  call ol_merge_tensors(T1sum(130),[G1tensor(655)])
  call ol_merge_tensors(T1sum(131),[G1tensor(661)])
  call ol_merge_tensors(T1sum(132),[G1tensor(667)])
  call ol_merge_tensors(T1sum(133),[G1tensor(673)])
  call ol_merge_tensors(T1sum(134),[G1tensor(679)])
  call ol_merge_tensors(T1sum(135),[G1tensor(685)])
  call ol_merge_tensors(T1sum(136),[G1tensor(691)])
  call ol_merge_tensors(T1sum(137),[G1tensor(697)])
  call ol_merge_tensors(T1sum(138),[G1tensor(703)])
  call ol_merge_tensors(T1sum(139),[G1tensor(709)])
  call ol_merge_tensors(T1sum(140),[G1tensor(715)])
  call ol_merge_tensors(T1sum(141),[G1tensor(721)])
  call ol_merge_tensors(T1sum(142),[G1tensor(727)])
  Gcoeff(:)%j = (c(22)*M(1,:)%j+c(20)*M(3,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(152),h0tab(:,152),[48,2,8,5],[0,nMT,nMB,0],5,1,wf6(:,3))
  call Hloop_GGG_G_12(ntryL,G0H144(1),ex6(:),ex5(:),G0H36(10),m4h2x2x36(:,4),heltab3x144(:,:,4))
  Gcoeff(:)%j = (c(22)*M(2,:)%j+c(20)*M(3,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(153),h0tab(:,153),[48,2,8,5],[0,nMT,nMB,0],5,1,wf6(:,3))
  call Hloop_GGG_G_12(ntryL,G0H144(1),ex5(:),ex6(:),G0H36(3),m4h2x2x36(:,5),heltab3x144(:,:,5))
  Gcoeff(:)%j = (c(22)*(-M(1,:)%j+M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(154),h0tab(:,154),[48,2,8,5],[0,nMT,nMB,0],5,1,wf6(:,3))
  call Hloop_GGG_G_23(ntryL,G0H144(1),ex6(:),ex5(:),G0H36(2),m4h2x2x36(:,6),heltab3x144(:,:,6))
  Gcoeff(:)%j = (c(22)*M(2,:)%j+c(20)*M(3,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(155),h0tab(:,155),[48,1,4,10],[0,nMT,nMB,0],5,1,wf6(:,4))
  call Hloop_GGG_G_12(ntryL,G0H144(1),ex6(:),ex5(:),G0H36(1),m4h2x2x36(:,7),heltab3x144(:,:,7))
  Gcoeff(:)%j = (c(22)*M(1,:)%j+c(20)*M(3,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(156),h0tab(:,156),[48,1,4,10],[0,nMT,nMB,0],5,1,wf6(:,4))
  call Hloop_GGG_G_12(ntryL,G0H144(1),ex5(:),ex6(:),G0H36(4),m4h2x2x36(:,8),heltab3x144(:,:,8))
  Gcoeff(:)%j = (c(22)*(M(1,:)%j-M(2,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(157),h0tab(:,157),[48,1,4,10],[0,nMT,nMB,0],5,1,wf6(:,4))
  call Hloop_GGG_G_23(ntryL,G0H144(1),ex6(:),ex5(:),G0H36(5),m4h2x2x36(:,9),heltab3x144(:,:,9))
  Gcoeff(:)%j = (-(c(33)*M(2,:)%j)-c(31)*M(3,:)%j) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(158),h0tab(:,158),[48,1,12,2],[0,nMT,nMT,0],5,1,wf9(:,1))
  call Hloop_GGG_G_12(ntryL,G0H144(1),ex6(:),ex5(:),G0H36(6),m4h2x2x36(:,10),heltab3x144(:,:,10))
  Gcoeff(:)%j = (-(c(33)*M(1,:)%j)-c(31)*M(3,:)%j) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(159),h0tab(:,159),[48,1,12,2],[0,nMT,nMT,0],5,1,wf9(:,1))
  call Hloop_GGG_G_12(ntryL,G0H144(1),ex5(:),ex6(:),G0H36(7),m4h2x2x36(:,11),heltab3x144(:,:,11))
  Gcoeff(:)%j = (c(33)*(-M(1,:)%j+M(2,:)%j)) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(160),h0tab(:,160),[48,1,12,2],[0,nMT,nMT,0],5,1,wf9(:,1))
  call Hloop_GGG_G_23(ntryL,G0H144(1),ex6(:),ex5(:),G0H36(8),m4h2x2x36(:,12),heltab3x144(:,:,12))
  Gcoeff(:)%j = (c(11)*M(2,:)%j+c(9)*M(3,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(161),h0tab(:,161),[48,1,12,2],[0,nMT,nMT,0],5,1,wf9(:,2))
  call Hloop_GGG_G_12(ntryL,G0H144(1),ex6(:),ex5(:),G0H36(9),m4h2x2x36(:,13),heltab3x144(:,:,13))
  Gcoeff(:)%j = (c(11)*M(1,:)%j+c(9)*M(3,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(162),h0tab(:,162),[48,1,12,2],[0,nMT,nMT,0],5,1,wf9(:,2))
  call Hloop_GGG_G_12(ntryL,G0H144(1),ex5(:),ex6(:),G0H36(11),m4h2x2x36(:,14),heltab3x144(:,:,14))
  Gcoeff(:)%j = (c(11)*(M(1,:)%j-M(2,:)%j)) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(163),h0tab(:,163),[48,1,12,2],[0,nMT,nMT,0],5,1,wf9(:,2))
  call Hloop_GGG_G_23(ntryL,G0H144(1),ex6(:),ex5(:),G0H36(12),m4h2x2x36(:,15),heltab3x144(:,:,15))
  Gcoeff(:)%j = (c(44)*M(2,:)%j+c(42)*M(3,:)%j) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(164),h0tab(:,164),[48,1,12,2],[0,nMT,nMT,0],5,1,wf9(:,3))
  call Hloop_GGG_G_12(ntryL,G0H144(1),ex6(:),ex5(:),G0H36(13),m4h2x2x36(:,16),heltab3x144(:,:,16))
  Gcoeff(:)%j = (c(44)*M(1,:)%j+c(42)*M(3,:)%j) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(165),h0tab(:,165),[48,1,12,2],[0,nMT,nMT,0],5,1,wf9(:,3))
  call Hloop_GGG_G_12(ntryL,G0H144(1),ex5(:),ex6(:),G0H36(14),m4h2x2x36(:,17),heltab3x144(:,:,17))
  Gcoeff(:)%j = (c(44)*(M(1,:)%j-M(2,:)%j)) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(166),h0tab(:,166),[48,1,12,2],[0,nMT,nMT,0],5,1,wf9(:,3))
  call Hloop_GGG_G_23(ntryL,G0H144(1),ex6(:),ex5(:),G0H36(15),m4h2x2x36(:,18),heltab3x144(:,:,18))
  Gcoeff(:)%j = (c(66)*M(1,:)%j-c(65)*M(3,:)%j) * den(89)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(167),h0tab(:,167),[32,12,3,16],[nMT,nMT,nMT,nMT],4,2,wf9(:,1),wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,137),heltab2x144(:,:,149))
  call Hloop_A_Q(ntryL,G0H72(1),32,nMT,G1H72(1),n2h72(110))
  Gcoeff(:)%j = (c(66)*M(2,:)%j-c(65)*M(3,:)%j) * den(89)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(168),h0tab(:,168),[32,12,3,16],[nMT,nMT,nMT,nMT],4,2,wf9(:,1),wf4(:,10))
  call Hloop_QV_A(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,138),heltab2x144(:,:,150))
  call Hloop_Q_A(ntryL,G0H72(1),32,nMT,G1H72(2),n2h72(111))
  Gcoeff(:)%j = (c(62)*M(1,:)%j-c(61)*M(3,:)%j) * den(89)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(169),h0tab(:,169),[32,12,3,16],[nMB,nMB,nMB,nMB],4,2,wf9(:,1),wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,139),heltab2x144(:,:,151))
  call Hloop_A_Q(ntryL,G0H72(1),32,nMB,G1H72(3),n2h72(112))
  Gcoeff(:)%j = (c(62)*M(2,:)%j-c(61)*M(3,:)%j) * den(89)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(170),h0tab(:,170),[32,12,3,16],[nMB,nMB,nMB,nMB],4,2,wf9(:,1),wf4(:,10))
  call Hloop_QV_A(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,140),heltab2x144(:,:,152))
  call Hloop_Q_A(ntryL,G0H72(1),32,nMB,G1H72(4),n2h72(113))
  Gcoeff(:)%j = (-(c(53)*M(1,:)%j)+c(52)*M(3,:)%j) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(171),h0tab(:,171),[32,12,3,16],[0,0,0,0],4,2,wf9(:,2),wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,141),heltab2x144(:,:,153))
  call Hloop_A_Q(ntryL,G0H72(1),32,0,G1H72(5),n2h72(114))
  Gcoeff(:)%j = (-(c(51)*M(1,:)%j)+c(50)*M(3,:)%j) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(172),h0tab(:,172),[32,12,3,16],[nMT,nMT,nMT,nMT],4,2,wf9(:,2),wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,142),heltab2x144(:,:,154))
  call Hloop_A_Q(ntryL,G0H72(1),32,nMT,G1H72(6),n2h72(115))
  Gcoeff(:)%j = (-(c(53)*M(2,:)%j)+c(52)*M(3,:)%j) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(173),h0tab(:,173),[32,12,3,16],[0,0,0,0],4,2,wf9(:,2),wf4(:,10))
  call Hloop_QV_A(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,143),heltab2x144(:,:,155))
  call Hloop_Q_A(ntryL,G0H72(1),32,0,G1H72(7),n2h72(116))
  Gcoeff(:)%j = (-(c(51)*M(2,:)%j)+c(50)*M(3,:)%j) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(174),h0tab(:,174),[32,12,3,16],[nMT,nMT,nMT,nMT],4,2,wf9(:,2),wf4(:,10))
  call Hloop_QV_A(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,144),heltab2x144(:,:,156))
  call Hloop_Q_A(ntryL,G0H72(1),32,nMT,G1H72(8),n2h72(117))
  Gcoeff(:)%j = (c(51)*M(1,:)%j-c(50)*M(3,:)%j) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(175),h0tab(:,175),[32,12,3,16],[0,0,0,0],4,2,wf9(:,2),wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,145),heltab2x144(:,:,157))
  call Hloop_A_Q(ntryL,G0H72(1),32,0,G1H72(9),n2h72(118))
  Gcoeff(:)%j = (c(49)*M(1,:)%j-c(48)*M(3,:)%j) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(176),h0tab(:,176),[32,12,3,16],[nMB,nMB,nMB,nMB],4,2,wf9(:,2),wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,146),heltab2x144(:,:,158))
  call Hloop_A_Q(ntryL,G0H72(1),32,nMB,G1H72(10),n2h72(119))
  Gcoeff(:)%j = (c(51)*M(2,:)%j-c(50)*M(3,:)%j) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(177),h0tab(:,177),[32,12,3,16],[0,0,0,0],4,2,wf9(:,2),wf4(:,10))
  call Hloop_QV_A(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,147),heltab2x144(:,:,159))
  call Hloop_Q_A(ntryL,G0H72(1),32,0,G1H72(11),n2h72(120))
  Gcoeff(:)%j = (c(49)*M(2,:)%j-c(48)*M(3,:)%j) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(178),h0tab(:,178),[32,12,3,16],[nMB,nMB,nMB,nMB],4,2,wf9(:,2),wf4(:,10))
  call Hloop_QV_A(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,148),heltab2x144(:,:,160))
  call Hloop_Q_A(ntryL,G0H72(1),32,nMB,G1H72(12),n2h72(121))
  Gcoeff(:)%j = (-(c(74)*M(1,:)%j)+c(73)*M(3,:)%j) * den(79)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(179),h0tab(:,179),[32,12,3,16],[0,0,0,0],4,2,wf9(:,3),wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,149),heltab2x144(:,:,161))
  call Hloop_A_Q(ntryL,G0H72(1),32,0,G1H72(13),n2h72(122))
  Gcoeff(:)%j = (-(c(72)*M(1,:)%j)+c(71)*M(3,:)%j) * den(79)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(180),h0tab(:,180),[32,12,3,16],[nMT,nMT,nMT,nMT],4,2,wf9(:,3),wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,150),heltab2x144(:,:,162))
  call Hloop_A_Q(ntryL,G0H72(1),32,nMT,G1H72(14),n2h72(123))
  Gcoeff(:)%j = (-(c(74)*M(2,:)%j)+c(73)*M(3,:)%j) * den(79)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(181),h0tab(:,181),[32,12,3,16],[0,0,0,0],4,2,wf9(:,3),wf4(:,10))
  call Hloop_QV_A(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,151),heltab2x144(:,:,163))
  call Hloop_Q_A(ntryL,G0H72(1),32,0,G1H72(15),n2h72(124))
  Gcoeff(:)%j = (-(c(72)*M(2,:)%j)+c(71)*M(3,:)%j) * den(79)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(182),h0tab(:,182),[32,12,3,16],[nMT,nMT,nMT,nMT],4,2,wf9(:,3),wf4(:,10))
  call Hloop_QV_A(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,152),heltab2x144(:,:,164))
  call Hloop_Q_A(ntryL,G0H72(1),32,nMT,G1H72(16),n2h72(125))
  Gcoeff(:)%j = (-(c(74)*M(1,:)%j)+c(73)*M(3,:)%j) * den(79)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(183),h0tab(:,183),[32,12,3,16],[0,0,0,0],4,2,wf9(:,3),wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,153),heltab2x144(:,:,165))
  call Hloop_A_Q(ntryL,G0H72(1),32,0,G1H72(17),n2h72(126))
  Gcoeff(:)%j = (-(c(72)*M(1,:)%j)+c(71)*M(3,:)%j) * den(79)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(184),h0tab(:,184),[32,12,3,16],[nMB,nMB,nMB,nMB],4,2,wf9(:,3),wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,154),heltab2x144(:,:,166))
  call Hloop_A_Q(ntryL,G0H72(1),32,nMB,G1H72(18),n2h72(127))
  Gcoeff(:)%j = (-(c(74)*M(2,:)%j)+c(73)*M(3,:)%j) * den(79)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(185),h0tab(:,185),[32,12,3,16],[0,0,0,0],4,2,wf9(:,3),wf4(:,10))
  call Hloop_QV_A(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,155),heltab2x144(:,:,167))
  call Hloop_Q_A(ntryL,G0H72(1),32,0,G1H72(19),n2h72(128))
  Gcoeff(:)%j = (-(c(72)*M(2,:)%j)+c(71)*M(3,:)%j) * den(79)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(186),h0tab(:,186),[32,12,3,16],[nMB,nMB,nMB,nMB],4,2,wf9(:,3),wf4(:,10))
  call Hloop_QV_A(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,156),heltab2x144(:,:,168))
  call Hloop_Q_A(ntryL,G0H72(1),32,nMB,G1H72(20),n2h72(129))
  Gcoeff(:)%j = (c(66)*M(1,:)%j-c(65)*M(3,:)%j) * den(89)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(187),h0tab(:,187),[32,3,12,16],[nMT,nMT,nMT,nMT],4,2,wf4(:,10),wf9(:,1))
  call Hloop_AV_Q(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,157),heltab2x144(:,:,169))
  call Hloop_A_Q(ntryL,G0H72(1),32,nMT,G1H72(21),n2h72(130))
  Gcoeff(:)%j = (c(66)*M(2,:)%j-c(65)*M(3,:)%j) * den(89)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(188),h0tab(:,188),[32,3,12,16],[nMT,nMT,nMT,nMT],4,2,wf4(:,10),wf9(:,1))
  call Hloop_QV_A(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,158),heltab2x144(:,:,170))
  call Hloop_Q_A(ntryL,G0H72(1),32,nMT,G1H72(22),n2h72(131))
  Gcoeff(:)%j = (c(62)*M(1,:)%j-c(61)*M(3,:)%j) * den(89)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(189),h0tab(:,189),[32,3,12,16],[nMB,nMB,nMB,nMB],4,2,wf4(:,10),wf9(:,1))
  call Hloop_AV_Q(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,159),heltab2x144(:,:,171))
  call Hloop_A_Q(ntryL,G0H72(1),32,nMB,G1H72(23),n2h72(132))
  Gcoeff(:)%j = (c(62)*M(2,:)%j-c(61)*M(3,:)%j) * den(89)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(190),h0tab(:,190),[32,3,12,16],[nMB,nMB,nMB,nMB],4,2,wf4(:,10),wf9(:,1))
  call Hloop_QV_A(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,160),heltab2x144(:,:,172))
  call Hloop_Q_A(ntryL,G0H72(1),32,nMB,G1H72(24),n2h72(133))
  Gcoeff(:)%j = (-(c(53)*M(1,:)%j)+c(52)*M(3,:)%j) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(191),h0tab(:,191),[32,3,12,16],[0,0,0,0],4,2,wf4(:,10),wf9(:,2))
  call Hloop_AV_Q(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,161),heltab2x144(:,:,173))
  call Hloop_A_Q(ntryL,G0H72(1),32,0,G1H72(25),n2h72(134))
  Gcoeff(:)%j = (-(c(51)*M(1,:)%j)+c(50)*M(3,:)%j) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(192),h0tab(:,192),[32,3,12,16],[nMT,nMT,nMT,nMT],4,2,wf4(:,10),wf9(:,2))
  call Hloop_AV_Q(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,162),heltab2x144(:,:,174))
  call Hloop_A_Q(ntryL,G0H72(1),32,nMT,G1H72(26),n2h72(135))
  Gcoeff(:)%j = (-(c(53)*M(2,:)%j)+c(52)*M(3,:)%j) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(193),h0tab(:,193),[32,3,12,16],[0,0,0,0],4,2,wf4(:,10),wf9(:,2))
  call Hloop_QV_A(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,163),heltab2x144(:,:,175))
  call Hloop_Q_A(ntryL,G0H72(1),32,0,G1H72(27),n2h72(136))
  Gcoeff(:)%j = (-(c(51)*M(2,:)%j)+c(50)*M(3,:)%j) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(194),h0tab(:,194),[32,3,12,16],[nMT,nMT,nMT,nMT],4,2,wf4(:,10),wf9(:,2))
  call Hloop_QV_A(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,164),heltab2x144(:,:,176))
  call Hloop_Q_A(ntryL,G0H72(1),32,nMT,G1H72(28),n2h72(137))
  Gcoeff(:)%j = (c(51)*M(1,:)%j-c(50)*M(3,:)%j) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(195),h0tab(:,195),[32,3,12,16],[0,0,0,0],4,2,wf4(:,10),wf9(:,2))
  call Hloop_AV_Q(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,165),heltab2x144(:,:,177))
  call Hloop_A_Q(ntryL,G0H72(1),32,0,G1H72(29),n2h72(138))
  Gcoeff(:)%j = (c(49)*M(1,:)%j-c(48)*M(3,:)%j) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(196),h0tab(:,196),[32,3,12,16],[nMB,nMB,nMB,nMB],4,2,wf4(:,10),wf9(:,2))
  call Hloop_AV_Q(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,166),heltab2x144(:,:,178))
  call Hloop_A_Q(ntryL,G0H72(1),32,nMB,G1H72(30),n2h72(139))
  Gcoeff(:)%j = (c(51)*M(2,:)%j-c(50)*M(3,:)%j) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(197),h0tab(:,197),[32,3,12,16],[0,0,0,0],4,2,wf4(:,10),wf9(:,2))
  call Hloop_QV_A(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,167),heltab2x144(:,:,179))
  call Hloop_Q_A(ntryL,G0H72(1),32,0,G1H72(31),n2h72(140))
  Gcoeff(:)%j = (c(49)*M(2,:)%j-c(48)*M(3,:)%j) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(198),h0tab(:,198),[32,3,12,16],[nMB,nMB,nMB,nMB],4,2,wf4(:,10),wf9(:,2))
  call Hloop_QV_A(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,168),heltab2x144(:,:,180))
  call Hloop_Q_A(ntryL,G0H72(1),32,nMB,G1H72(32),n2h72(141))
  Gcoeff(:)%j = (-(c(74)*M(1,:)%j)+c(73)*M(3,:)%j) * den(79)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(199),h0tab(:,199),[32,3,12,16],[0,0,0,0],4,2,wf4(:,10),wf9(:,3))
  call Hloop_AV_Q(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,169),heltab2x144(:,:,181))
  call Hloop_A_Q(ntryL,G0H72(1),32,0,G1H72(33),n2h72(142))
  Gcoeff(:)%j = (-(c(72)*M(1,:)%j)+c(71)*M(3,:)%j) * den(79)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(200),h0tab(:,200),[32,3,12,16],[nMT,nMT,nMT,nMT],4,2,wf4(:,10),wf9(:,3))
  call Hloop_AV_Q(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,170),heltab2x144(:,:,182))
  call Hloop_A_Q(ntryL,G0H72(1),32,nMT,G1H72(34),n2h72(143))
  Gcoeff(:)%j = (-(c(74)*M(2,:)%j)+c(73)*M(3,:)%j) * den(79)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(201),h0tab(:,201),[32,3,12,16],[0,0,0,0],4,2,wf4(:,10),wf9(:,3))
  call Hloop_QV_A(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,171),heltab2x144(:,:,183))
  call Hloop_Q_A(ntryL,G0H72(1),32,0,G1H72(35),n2h72(144))
  Gcoeff(:)%j = (-(c(72)*M(2,:)%j)+c(71)*M(3,:)%j) * den(79)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(202),h0tab(:,202),[32,3,12,16],[nMT,nMT,nMT,nMT],4,2,wf4(:,10),wf9(:,3))
  call Hloop_QV_A(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,172),heltab2x144(:,:,184))
  call Hloop_Q_A(ntryL,G0H72(1),32,nMT,G1H72(36),n2h72(145))
  Gcoeff(:)%j = (-(c(74)*M(1,:)%j)+c(73)*M(3,:)%j) * den(79)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(203),h0tab(:,203),[32,3,12,16],[0,0,0,0],4,2,wf4(:,10),wf9(:,3))
  call Hloop_AV_Q(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,173),heltab2x144(:,:,185))
  call Hloop_A_Q(ntryL,G0H72(1),32,0,G1H72(37),n2h72(146))
  Gcoeff(:)%j = (-(c(72)*M(1,:)%j)+c(71)*M(3,:)%j) * den(79)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(204),h0tab(:,204),[32,3,12,16],[nMB,nMB,nMB,nMB],4,2,wf4(:,10),wf9(:,3))
  call Hloop_AV_Q(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,174),heltab2x144(:,:,186))
  call Hloop_A_Q(ntryL,G0H72(1),32,nMB,G1H72(38),n2h72(147))
  Gcoeff(:)%j = (-(c(74)*M(2,:)%j)+c(73)*M(3,:)%j) * den(79)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(205),h0tab(:,205),[32,3,12,16],[0,0,0,0],4,2,wf4(:,10),wf9(:,3))
  call Hloop_QV_A(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,175),heltab2x144(:,:,187))
  call Hloop_Q_A(ntryL,G0H72(1),32,0,G1H72(39),n2h72(148))
  Gcoeff(:)%j = (-(c(72)*M(2,:)%j)+c(71)*M(3,:)%j) * den(79)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(206),h0tab(:,206),[32,3,12,16],[nMB,nMB,nMB,nMB],4,2,wf4(:,10),wf9(:,3))
  call Hloop_QV_A(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,176),heltab2x144(:,:,188))
  call Hloop_Q_A(ntryL,G0H72(1),32,nMB,G1H72(40),n2h72(149))
  Gcoeff(:)%j = (c(66)*M(2,:)%j-c(65)*M(3,:)%j) * den(89)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(207),h0tab(:,207),[32,3,16,12],[nMT,nMT,nMT,nMT],4,2,wf4(:,10),wf9(:,1))
  call Hloop_QV_A(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,177),heltab2x144(:,:,189))
  call Hloop_Q_A(ntryL,G0H72(1),32,nMT,G1H72(41),n2h72(150))
  Gcoeff(:)%j = (c(66)*M(1,:)%j-c(65)*M(3,:)%j) * den(89)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(208),h0tab(:,208),[32,3,16,12],[nMT,nMT,nMT,nMT],4,2,wf4(:,10),wf9(:,1))
  call Hloop_AV_Q(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,178),heltab2x144(:,:,190))
  call Hloop_A_Q(ntryL,G0H72(1),32,nMT,G1H72(42),n2h72(151))
  Gcoeff(:)%j = (c(62)*M(2,:)%j-c(61)*M(3,:)%j) * den(89)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(209),h0tab(:,209),[32,3,16,12],[nMB,nMB,nMB,nMB],4,2,wf4(:,10),wf9(:,1))
  call Hloop_QV_A(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,179),heltab2x144(:,:,191))
  call Hloop_Q_A(ntryL,G0H72(1),32,nMB,G1H72(43),n2h72(152))
  Gcoeff(:)%j = (c(62)*M(1,:)%j-c(61)*M(3,:)%j) * den(89)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(210),h0tab(:,210),[32,3,16,12],[nMB,nMB,nMB,nMB],4,2,wf4(:,10),wf9(:,1))
  call Hloop_AV_Q(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,180),heltab2x144(:,:,192))
  call Hloop_A_Q(ntryL,G0H72(1),32,nMB,G1H72(44),n2h72(153))
  Gcoeff(:)%j = (-(c(53)*M(2,:)%j)+c(52)*M(3,:)%j) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(211),h0tab(:,211),[32,3,16,12],[0,0,0,0],4,2,wf4(:,10),wf9(:,2))
  call Hloop_QV_A(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,181),heltab2x144(:,:,193))
  call Hloop_Q_A(ntryL,G0H72(1),32,0,G1H72(45),n2h72(154))
  Gcoeff(:)%j = (-(c(51)*M(2,:)%j)+c(50)*M(3,:)%j) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(212),h0tab(:,212),[32,3,16,12],[nMT,nMT,nMT,nMT],4,2,wf4(:,10),wf9(:,2))
  call Hloop_QV_A(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,182),heltab2x144(:,:,194))
  call Hloop_Q_A(ntryL,G0H72(1),32,nMT,G1H72(46),n2h72(155))
  Gcoeff(:)%j = (-(c(53)*M(1,:)%j)+c(52)*M(3,:)%j) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(213),h0tab(:,213),[32,3,16,12],[0,0,0,0],4,2,wf4(:,10),wf9(:,2))
  call Hloop_AV_Q(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,183),heltab2x144(:,:,195))
  call Hloop_A_Q(ntryL,G0H72(1),32,0,G1H72(47),n2h72(156))
  Gcoeff(:)%j = (-(c(51)*M(1,:)%j)+c(50)*M(3,:)%j) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(214),h0tab(:,214),[32,3,16,12],[nMT,nMT,nMT,nMT],4,2,wf4(:,10),wf9(:,2))
  call Hloop_AV_Q(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,184),heltab2x144(:,:,196))
  call Hloop_A_Q(ntryL,G0H72(1),32,nMT,G1H72(48),n2h72(157))
  Gcoeff(:)%j = (c(51)*M(2,:)%j-c(50)*M(3,:)%j) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(215),h0tab(:,215),[32,3,16,12],[0,0,0,0],4,2,wf4(:,10),wf9(:,2))
  call Hloop_QV_A(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,185),heltab2x144(:,:,197))
  call Hloop_Q_A(ntryL,G0H72(1),32,0,G1H72(49),n2h72(158))
  Gcoeff(:)%j = (c(49)*M(2,:)%j-c(48)*M(3,:)%j) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(216),h0tab(:,216),[32,3,16,12],[nMB,nMB,nMB,nMB],4,2,wf4(:,10),wf9(:,2))
  call Hloop_QV_A(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,186),heltab2x144(:,:,198))
  call Hloop_Q_A(ntryL,G0H72(1),32,nMB,G1H72(50),n2h72(159))
  Gcoeff(:)%j = (c(51)*M(1,:)%j-c(50)*M(3,:)%j) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(217),h0tab(:,217),[32,3,16,12],[0,0,0,0],4,2,wf4(:,10),wf9(:,2))
  call Hloop_AV_Q(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,187),heltab2x144(:,:,199))
  call Hloop_A_Q(ntryL,G0H72(1),32,0,G1H72(51),n2h72(160))
  Gcoeff(:)%j = (c(49)*M(1,:)%j-c(48)*M(3,:)%j) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(218),h0tab(:,218),[32,3,16,12],[nMB,nMB,nMB,nMB],4,2,wf4(:,10),wf9(:,2))
  call Hloop_AV_Q(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,188),heltab2x144(:,:,200))
  call Hloop_A_Q(ntryL,G0H72(1),32,nMB,G1H72(52),n2h72(161))
  Gcoeff(:)%j = (-(c(74)*M(2,:)%j)+c(73)*M(3,:)%j) * den(79)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(219),h0tab(:,219),[32,3,16,12],[0,0,0,0],4,2,wf4(:,10),wf9(:,3))
  call Hloop_QV_A(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,189),heltab2x144(:,:,201))
  call Hloop_Q_A(ntryL,G0H72(1),32,0,G1H72(53),n2h72(162))
  Gcoeff(:)%j = (-(c(72)*M(2,:)%j)+c(71)*M(3,:)%j) * den(79)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(220),h0tab(:,220),[32,3,16,12],[nMT,nMT,nMT,nMT],4,2,wf4(:,10),wf9(:,3))
  call Hloop_QV_A(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,190),heltab2x144(:,:,202))
  call Hloop_Q_A(ntryL,G0H72(1),32,nMT,G1H72(54),n2h72(163))
  Gcoeff(:)%j = (-(c(74)*M(1,:)%j)+c(73)*M(3,:)%j) * den(79)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(221),h0tab(:,221),[32,3,16,12],[0,0,0,0],4,2,wf4(:,10),wf9(:,3))
  call Hloop_AV_Q(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,191),heltab2x144(:,:,203))
  call Hloop_A_Q(ntryL,G0H72(1),32,0,G1H72(55),n2h72(164))
  Gcoeff(:)%j = (-(c(72)*M(1,:)%j)+c(71)*M(3,:)%j) * den(79)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(222),h0tab(:,222),[32,3,16,12],[nMT,nMT,nMT,nMT],4,2,wf4(:,10),wf9(:,3))
  call Hloop_AV_Q(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,192),heltab2x144(:,:,204))
  call Hloop_A_Q(ntryL,G0H72(1),32,nMT,G1H72(56),n2h72(165))
  Gcoeff(:)%j = (-(c(74)*M(2,:)%j)+c(73)*M(3,:)%j) * den(79)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(223),h0tab(:,223),[32,3,16,12],[0,0,0,0],4,2,wf4(:,10),wf9(:,3))
  call Hloop_QV_A(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,193),heltab2x144(:,:,205))
  call Hloop_Q_A(ntryL,G0H72(1),32,0,G1H72(57),n2h72(166))
  Gcoeff(:)%j = (-(c(72)*M(2,:)%j)+c(71)*M(3,:)%j) * den(79)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(224),h0tab(:,224),[32,3,16,12],[nMB,nMB,nMB,nMB],4,2,wf4(:,10),wf9(:,3))
  call Hloop_QV_A(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,194),heltab2x144(:,:,206))
  call Hloop_Q_A(ntryL,G0H72(1),32,nMB,G1H72(58),n2h72(167))
  Gcoeff(:)%j = (-(c(74)*M(1,:)%j)+c(73)*M(3,:)%j) * den(79)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(225),h0tab(:,225),[32,3,16,12],[0,0,0,0],4,2,wf4(:,10),wf9(:,3))
  call Hloop_AV_Q(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,195),heltab2x144(:,:,207))
  call Hloop_A_Q(ntryL,G0H72(1),32,0,G1H72(59),n2h72(168))
  Gcoeff(:)%j = (-(c(72)*M(1,:)%j)+c(71)*M(3,:)%j) * den(79)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(226),h0tab(:,226),[32,3,16,12],[nMB,nMB,nMB,nMB],4,2,wf4(:,10),wf9(:,3))
  call Hloop_AV_Q(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,196),heltab2x144(:,:,208))
  call Hloop_A_Q(ntryL,G0H72(1),32,nMB,G1H72(60),n2h72(169))
  Gcoeff(:)%j = (c(55)*(M(1,:)%j-M(2,:)%j)) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(227),h0tab(:,227),[48,3,4,8],[0,0,0,0],4,2,wf4(:,1),wf4(:,10))
  call Hloop_QV_A(ntryL,G0H144(1),wf4(:,1),G0H36(16),m3h4x36(:,13),heltab2x144(:,:,209))
  call Hloop_Q_A(ntryL,G0H36(16),48,0,G1H36(7),n2h36(56))
  Gcoeff(:)%j = (c(54)*(M(1,:)%j-M(2,:)%j)) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(228),h0tab(:,228),[48,3,4,8],[nMT,nMT,nMB,nMT],4,2,wf4(:,1),wf4(:,10))
  call Hloop_QV_A(ntryL,G0H144(1),wf4(:,1),G0H36(16),m3h4x36(:,14),heltab2x144(:,:,210))
  call Hloop_Q_A(ntryL,G0H36(16),48,nMT,G1H36(12),n2h36(57))
  Gcoeff(:)%j = (c(55)*(M(1,:)%j-M(2,:)%j)) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(229),h0tab(:,229),[48,3,4,8],[0,0,0,0],4,2,wf4(:,1),wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H144(1),wf4(:,1),G0H36(16),m3h4x36(:,15),heltab2x144(:,:,211))
  call Hloop_A_Q(ntryL,G0H36(16),48,0,G1H36(3),n2h36(58))
  Gcoeff(:)%j = (c(54)*(M(1,:)%j-M(2,:)%j)) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(230),h0tab(:,230),[48,3,4,8],[nMB,nMB,nMT,nMB],4,2,wf4(:,1),wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H144(1),wf4(:,1),G0H36(16),m3h4x36(:,16),heltab2x144(:,:,212))
  call Hloop_A_Q(ntryL,G0H36(16),48,nMB,G1H36(5),n2h36(59))
  Gcoeff(:)%j = (c(55)*(M(1,:)%j-M(2,:)%j)) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(231),h0tab(:,231),[48,3,8,4],[0,0,0,0],4,2,wf4(:,1),wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H144(1),wf4(:,1),G0H36(16),m3h4x36(:,17),heltab2x144(:,:,213))
  call Hloop_A_Q(ntryL,G0H36(16),48,0,G1H36(31),n2h36(60))
  Gcoeff(:)%j = (c(54)*(M(1,:)%j-M(2,:)%j)) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(232),h0tab(:,232),[48,3,8,4],[nMT,nMT,nMB,nMT],4,2,wf4(:,1),wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H144(1),wf4(:,1),G0H36(16),m3h4x36(:,18),heltab2x144(:,:,214))
  call Hloop_A_Q(ntryL,G0H36(16),48,nMT,G1H36(32),n2h36(61))
  Gcoeff(:)%j = (c(55)*(M(1,:)%j-M(2,:)%j)) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(233),h0tab(:,233),[48,3,8,4],[0,0,0,0],4,2,wf4(:,1),wf4(:,10))
  call Hloop_QV_A(ntryL,G0H144(1),wf4(:,1),G0H36(16),m3h4x36(:,19),heltab2x144(:,:,215))
  call Hloop_Q_A(ntryL,G0H36(16),48,0,G1H36(33),n2h36(62))
  Gcoeff(:)%j = (c(54)*(M(1,:)%j-M(2,:)%j)) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(234),h0tab(:,234),[48,3,8,4],[nMB,nMB,nMT,nMB],4,2,wf4(:,1),wf4(:,10))
  call Hloop_QV_A(ntryL,G0H144(1),wf4(:,1),G0H36(16),m3h4x36(:,20),heltab2x144(:,:,216))
  call Hloop_Q_A(ntryL,G0H36(16),48,nMB,G1H36(34),n2h36(63))
  Gcoeff(:)%j = (c(55)*(M(1,:)%j-M(2,:)%j)) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(235),h0tab(:,235),[48,4,3,8],[0,0,0,0],4,2,wf4(:,1),wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H144(1),wf4(:,1),G0H36(16),m3h4x36(:,21),heltab2x144(:,:,217))
  call Hloop_A_Q(ntryL,G0H36(16),48,0,G1H36(36),n2h36(64))
  Gcoeff(:)%j = (c(54)*(M(1,:)%j-M(2,:)%j)) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(236),h0tab(:,236),[48,4,3,8],[nMB,nMT,nMT,nMB],4,2,wf4(:,1),wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H144(1),wf4(:,1),G0H36(16),m3h4x36(:,22),heltab2x144(:,:,218))
  call Hloop_A_Q(ntryL,G0H36(16),48,nMB,G1H36(37),n2h36(65))
  Gcoeff(:)%j = (c(55)*(M(1,:)%j-M(2,:)%j)) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(237),h0tab(:,237),[48,4,3,8],[0,0,0,0],4,2,wf4(:,1),wf4(:,10))
  call Hloop_QV_A(ntryL,G0H144(1),wf4(:,1),G0H36(16),m3h4x36(:,23),heltab2x144(:,:,219))
  call Hloop_Q_A(ntryL,G0H36(16),48,0,G1H36(38),n2h36(66))
  Gcoeff(:)%j = (c(54)*(M(1,:)%j-M(2,:)%j)) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(238),h0tab(:,238),[48,4,3,8],[nMT,nMB,nMB,nMT],4,2,wf4(:,1),wf4(:,10))
  call Hloop_QV_A(ntryL,G0H144(1),wf4(:,1),G0H36(16),m3h4x36(:,24),heltab2x144(:,:,220))
  call Hloop_Q_A(ntryL,G0H36(16),48,nMT,G1H36(39),n2h36(67))
  Gcoeff(:)%j = (c(55)*(M(1,:)%j-M(2,:)%j)) * den(93)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(239),h0tab(:,239),[32,4,8,19],[0,0,0,0],4,1,wf8(:,9))
  call Hloop_QV_A(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,197),heltab2x144(:,:,221))
  call Hloop_Q_A(ntryL,G0H72(1),32,0,G1H72(61),n2h72(170))
  Gcoeff(:)%j = (c(54)*(M(1,:)%j-M(2,:)%j)) * den(93)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(240),h0tab(:,240),[32,4,8,19],[nMT,nMB,nMT,nMT],4,1,wf8(:,9))
  call Hloop_QV_A(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,198),heltab2x144(:,:,222))
  call Hloop_Q_A(ntryL,G0H72(1),32,nMT,G1H72(62),n2h72(171))
  Gcoeff(:)%j = (c(55)*(M(1,:)%j-M(2,:)%j)) * den(93)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(241),h0tab(:,241),[32,4,8,19],[0,0,0,0],4,1,wf8(:,9))
  call Hloop_AV_Q(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,199),heltab2x144(:,:,223))
  call Hloop_A_Q(ntryL,G0H72(1),32,0,G1H72(63),n2h72(172))
  Gcoeff(:)%j = (c(54)*(M(1,:)%j-M(2,:)%j)) * den(93)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(242),h0tab(:,242),[32,4,8,19],[nMB,nMT,nMB,nMB],4,1,wf8(:,9))
  call Hloop_AV_Q(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,200),heltab2x144(:,:,224))
  call Hloop_A_Q(ntryL,G0H72(1),32,nMB,G1H72(64),n2h72(173))
  Gcoeff(:)%j = (c(55)*(M(1,:)%j-M(2,:)%j)) * den(93)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(243),h0tab(:,243),[32,8,4,19],[0,0,0,0],4,1,wf8(:,9))
  call Hloop_AV_Q(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,201),heltab2x144(:,:,225))
  call Hloop_A_Q(ntryL,G0H72(1),32,0,G1H72(65),n2h72(174))
  Gcoeff(:)%j = (c(54)*(M(1,:)%j-M(2,:)%j)) * den(93)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(244),h0tab(:,244),[32,8,4,19],[nMT,nMB,nMT,nMT],4,1,wf8(:,9))
  call Hloop_AV_Q(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,202),heltab2x144(:,:,226))
  call Hloop_A_Q(ntryL,G0H72(1),32,nMT,G1H72(66),n2h72(175))
  Gcoeff(:)%j = (c(55)*(M(1,:)%j-M(2,:)%j)) * den(93)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(245),h0tab(:,245),[32,8,4,19],[0,0,0,0],4,1,wf8(:,9))
  call Hloop_QV_A(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,203),heltab2x144(:,:,227))
  call Hloop_Q_A(ntryL,G0H72(1),32,0,G1H72(67),n2h72(176))
  Gcoeff(:)%j = (c(54)*(M(1,:)%j-M(2,:)%j)) * den(93)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(246),h0tab(:,246),[32,8,4,19],[nMB,nMT,nMB,nMB],4,1,wf8(:,9))
  call Hloop_QV_A(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,204),heltab2x144(:,:,228))
  call Hloop_Q_A(ntryL,G0H72(1),32,nMB,G1H72(68),n2h72(177))
  Gcoeff(:)%j = (c(55)*(M(1,:)%j-M(2,:)%j)) * den(93)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(247),h0tab(:,247),[32,4,19,8],[0,0,0,0],4,1,wf8(:,9))
  call Hloop_QV_A(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,205),heltab2x144(:,:,229))
  call Hloop_Q_A(ntryL,G0H72(1),32,0,G1H72(69),n2h72(178))
  Gcoeff(:)%j = (c(54)*(M(1,:)%j-M(2,:)%j)) * den(93)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(248),h0tab(:,248),[32,4,19,8],[nMT,nMB,nMB,nMT],4,1,wf8(:,9))
  call Hloop_QV_A(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,206),heltab2x144(:,:,230))
  call Hloop_Q_A(ntryL,G0H72(1),32,nMT,G1H72(70),n2h72(179))
  Gcoeff(:)%j = (c(55)*(M(1,:)%j-M(2,:)%j)) * den(93)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(249),h0tab(:,249),[32,4,19,8],[0,0,0,0],4,1,wf8(:,9))
  call Hloop_AV_Q(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,207),heltab2x144(:,:,231))
  call Hloop_A_Q(ntryL,G0H72(1),32,0,G1H72(71),n2h72(180))
  Gcoeff(:)%j = (c(54)*(M(1,:)%j-M(2,:)%j)) * den(93)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(250),h0tab(:,250),[32,4,19,8],[nMB,nMT,nMT,nMB],4,1,wf8(:,9))
  call Hloop_AV_Q(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,208),heltab2x144(:,:,232))
  call Hloop_A_Q(ntryL,G0H72(1),32,nMB,G1H72(72),n2h72(181))
  Gcoeff(:)%j = (c(55)*(-M(1,:)%j+M(2,:)%j)) * den(97)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(251),h0tab(:,251),[35,8,4,16],[0,0,0,0],4,1,wf8(:,10))
  call Hloop_AV_Q(ntryL,G0H144(1),wf8(:,10),G0H18(1),m3h8x18(:,1),heltab2x144(:,:,233))
  call Hloop_A_Q(ntryL,G0H18(1),35,0,G1H18(62),n2h18(149))
  Gcoeff(:)%j = (c(54)*(-M(1,:)%j+M(2,:)%j)) * den(97)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(252),h0tab(:,252),[35,8,4,16],[nMT,nMB,nMT,nMT],4,1,wf8(:,10))
  call Hloop_AV_Q(ntryL,G0H144(1),wf8(:,10),G0H18(1),m3h8x18(:,2),heltab2x144(:,:,234))
  call Hloop_A_Q(ntryL,G0H18(1),35,nMT,G1H18(63),n2h18(150))
  Gcoeff(:)%j = (c(55)*(-M(1,:)%j+M(2,:)%j)) * den(97)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(253),h0tab(:,253),[35,8,4,16],[0,0,0,0],4,1,wf8(:,10))
  call Hloop_QV_A(ntryL,G0H144(1),wf8(:,10),G0H18(1),m3h8x18(:,3),heltab2x144(:,:,235))
  call Hloop_Q_A(ntryL,G0H18(1),35,0,G1H18(175),n2h18(151))
  Gcoeff(:)%j = (c(54)*(-M(1,:)%j+M(2,:)%j)) * den(97)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(254),h0tab(:,254),[35,8,4,16],[nMB,nMT,nMB,nMB],4,1,wf8(:,10))
  call Hloop_QV_A(ntryL,G0H144(1),wf8(:,10),G0H18(1),m3h8x18(:,4),heltab2x144(:,:,236))
  call Hloop_Q_A(ntryL,G0H18(1),35,nMB,G1H18(176),n2h18(152))
  Gcoeff(:)%j = (c(55)*(-M(1,:)%j+M(2,:)%j)) * den(97)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(255),h0tab(:,255),[35,4,8,16],[0,0,0,0],4,1,wf8(:,10))
  call Hloop_QV_A(ntryL,G0H144(1),wf8(:,10),G0H18(1),m3h8x18(:,5),heltab2x144(:,:,237))
  call Hloop_Q_A(ntryL,G0H18(1),35,0,G1H18(191),n2h18(153))
  Gcoeff(:)%j = (c(54)*(-M(1,:)%j+M(2,:)%j)) * den(97)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(256),h0tab(:,256),[35,4,8,16],[nMT,nMB,nMT,nMT],4,1,wf8(:,10))
  call Hloop_QV_A(ntryL,G0H144(1),wf8(:,10),G0H18(1),m3h8x18(:,6),heltab2x144(:,:,238))
  call Hloop_Q_A(ntryL,G0H18(1),35,nMT,G1H18(192),n2h18(154))
  Gcoeff(:)%j = (c(55)*(-M(1,:)%j+M(2,:)%j)) * den(97)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(257),h0tab(:,257),[35,4,8,16],[0,0,0,0],4,1,wf8(:,10))
  call Hloop_AV_Q(ntryL,G0H144(1),wf8(:,10),G0H18(1),m3h8x18(:,7),heltab2x144(:,:,239))
  call Hloop_A_Q(ntryL,G0H18(1),35,0,G1H18(207),n2h18(155))
  Gcoeff(:)%j = (c(54)*(-M(1,:)%j+M(2,:)%j)) * den(97)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(258),h0tab(:,258),[35,4,8,16],[nMB,nMT,nMB,nMB],4,1,wf8(:,10))
  call Hloop_AV_Q(ntryL,G0H144(1),wf8(:,10),G0H18(1),m3h8x18(:,8),heltab2x144(:,:,240))
  call Hloop_A_Q(ntryL,G0H18(1),35,nMB,G1H18(208),n2h18(156))
  Gcoeff(:)%j = (c(55)*(-M(1,:)%j+M(2,:)%j)) * den(97)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(259),h0tab(:,259),[35,4,16,8],[0,0,0,0],4,1,wf8(:,10))
  call Hloop_AV_Q(ntryL,G0H144(1),wf8(:,10),G0H18(1),m3h8x18(:,9),heltab2x144(:,:,241))
  call Hloop_A_Q(ntryL,G0H18(1),35,0,G1H18(223),n2h18(157))
  Gcoeff(:)%j = (c(54)*(-M(1,:)%j+M(2,:)%j)) * den(97)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(260),h0tab(:,260),[35,4,16,8],[nMB,nMT,nMT,nMB],4,1,wf8(:,10))
  call Hloop_AV_Q(ntryL,G0H144(1),wf8(:,10),G0H18(1),m3h8x18(:,10),heltab2x144(:,:,242))
  call Hloop_A_Q(ntryL,G0H18(1),35,nMB,G1H18(224),n2h18(158))
  Gcoeff(:)%j = (c(55)*(-M(1,:)%j+M(2,:)%j)) * den(97)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(261),h0tab(:,261),[35,4,16,8],[0,0,0,0],4,1,wf8(:,10))
  call Hloop_QV_A(ntryL,G0H144(1),wf8(:,10),G0H18(1),m3h8x18(:,11),heltab2x144(:,:,243))
  call Hloop_Q_A(ntryL,G0H18(1),35,0,G1H18(28),n2h18(159))
  Gcoeff(:)%j = (c(54)*(-M(1,:)%j+M(2,:)%j)) * den(97)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(262),h0tab(:,262),[35,4,16,8],[nMT,nMB,nMB,nMT],4,1,wf8(:,10))
  call Hloop_QV_A(ntryL,G0H144(1),wf8(:,10),G0H18(1),m3h8x18(:,12),heltab2x144(:,:,244))
  call Hloop_Q_A(ntryL,G0H18(1),35,nMT,G1H18(29),n2h18(160))
  Gcoeff(:)%j = (-(c(19)*M(2,:)%j)+c(20)*M(3,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(263),h0tab(:,263),[32,10,5,16],[nMB,0,nMB,nMB],4,2,wf6(:,4),wf6(:,3))
  call Hloop_QV_A(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,209),heltab2x144(:,:,245))
  call Hloop_Q_A(ntryL,G0H72(1),32,nMB,G1H72(73),n2h72(182))
  Gcoeff(:)%j = (c(22)*M(2,:)%j+c(20)*M(3,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(264),h0tab(:,264),[32,10,5,16],[0,nMB,0,0],4,2,wf6(:,4),wf6(:,3))
  call Hloop_UV_W(ntryL,G0H144(1),0,ex6(:),32,G1H72(74),m3h2x72(:,210),heltab2x144(:,:,246))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)+c(20)*M(3,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(265),h0tab(:,265),[32,5,10,16],[nMB,0,nMB,nMB],4,2,wf6(:,3),wf6(:,4))
  call Hloop_AV_Q(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,211),heltab2x144(:,:,247))
  call Hloop_A_Q(ntryL,G0H72(1),32,nMB,G1H72(75),n2h72(183))
  Gcoeff(:)%j = (c(22)*M(1,:)%j+c(20)*M(3,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(266),h0tab(:,266),[32,5,10,16],[0,nMB,0,0],4,2,wf6(:,3),wf6(:,4))
  call Hloop_UV_W(ntryL,G0H144(1),0,ex6(:),32,G1H72(76),m3h2x72(:,212),heltab2x144(:,:,248))
  Gcoeff(:)%j = (c(15)*M(3,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(267),h0tab(:,267),[32,5,16,10],[0,nMB,nMB,0],4,2,wf6(:,3),wf6(:,4))
  call Hloop_UV_W(ntryL,G0H144(1),0,ex6(:),32,G1H72(77),m3h2x72(:,213),heltab2x144(:,:,249))
  Gcoeff(:)%j = (-(c(15)*M(3,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(268),h0tab(:,268),[32,5,16,10],[nMB,0,0,nMB],4,2,wf6(:,3),wf6(:,4))
  call Hloop_AV_Q(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,214),heltab2x144(:,:,250))
  call Hloop_A_Q(ntryL,G0H72(1),32,nMB,G1H72(78),n2h72(184))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(338)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(269),h0tab(:,269),[32,8,5,18],[nMT,nMB,0,nMT],4,2,wf6(:,3),wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,215),heltab2x144(:,:,251))
  call Hloop_A_Q(ntryL,G0H72(1),32,nMT,G1H72(79),n2h72(185))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(338)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(270),h0tab(:,270),[32,5,18,8],[nMB,0,nMT,nMB],4,2,wf6(:,3),wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,216),heltab2x144(:,:,252))
  call Hloop_A_Q(ntryL,G0H72(1),32,nMB,G1H72(80),n2h72(186))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(338)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(271),h0tab(:,271),[32,5,8,18],[0,nMB,nMT,0],4,2,wf6(:,3),wf4(:,3))
  call Hloop_UV_W(ntryL,G0H144(1),0,ex6(:),32,G1H72(81),m3h2x72(:,217),heltab2x144(:,:,253))
  Gcoeff(:)%j = (-(c(19)*M(2,:)%j)) * den(339)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(272),h0tab(:,272),[34,5,8,16],[0,nMB,nMT,nMT],4,2,wf4(:,5),wf6(:,3))
  call Hloop_QA_V(ntryL,G0H144(1),wf4(:,5),G0H36(16),m3h4x36(:,25),heltab2x144(:,:,254))
  Gcoeff(:)%j = (-(c(19)*M(2,:)%j)) * den(339)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(273),h0tab(:,273),[34,5,16,8],[0,nMB,nMB,nMT],4,2,wf4(:,5),wf6(:,3))
  call Hloop_QA_V(ntryL,G0H144(1),wf4(:,5),G0H36(17),m3h4x36(:,26),heltab2x144(:,:,255))
  Gcoeff(:)%j = (c(17)*M(2,:)%j) * den(339)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(274),h0tab(:,274),[34,8,5,16],[nMT,nMB,0,0],4,2,wf4(:,5),wf6(:,3))
  call Hloop_VA_Q(ntryL,G0H144(1),wf4(:,5),G0H36(18),m3h4x36(:,27),heltab2x144(:,:,256))
  call Hloop_A_Q(ntryL,G0H36(18),34,nMT,G1H36(40),n2h36(68))
  Gcoeff(:)%j = (c(14)*(M(1,:)%j-M(2,:)%j)) * den(154)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(275),h0tab(:,275),[48,5,2,8],[nMB,0,nMT,nMB],4,2,wf4(:,1),wf6(:,3))
  call Hloop_AV_Q(ntryL,G0H144(1),wf4(:,1),G0H36(18),m3h4x36(:,28),heltab2x144(:,:,257))
  call Hloop_A_Q(ntryL,G0H36(18),48,nMB,G1H36(42),n2h36(69))
  Gcoeff(:)%j = (c(22)*(-M(1,:)%j+M(2,:)%j)) * den(154)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(276),h0tab(:,276),[48,2,8,5],[0,nMT,nMB,0],4,2,wf4(:,1),wf6(:,3))
  call Hloop_UV_W(ntryL,G0H144(1),0,wf4(:,1),48,G1H36(43),m3h4x36(:,29),heltab2x144(:,:,258))
  Gcoeff(:)%j = (c(14)*(M(1,:)%j-M(2,:)%j)) * den(154)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(277),h0tab(:,277),[48,2,5,8],[nMT,0,nMB,nMT],4,2,wf4(:,1),wf6(:,3))
  call Hloop_QV_A(ntryL,G0H144(1),wf4(:,1),G0H36(18),m3h4x36(:,30),heltab2x144(:,:,259))
  call Hloop_Q_A(ntryL,G0H36(18),48,nMT,G1H36(44),n2h36(70))
  Gcoeff(:)%j = (-(c(15)*M(3,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(278),h0tab(:,278),[32,2,16,13],[0,nMT,nMT,0],4,1,wf18(:,2))
  call Hloop_UV_W(ntryL,G0H144(1),0,ex6(:),32,G1H72(82),m3h2x72(:,218),heltab2x144(:,:,260))
  Gcoeff(:)%j = (c(15)*M(3,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(279),h0tab(:,279),[32,2,16,13],[nMT,0,0,nMT],4,1,wf18(:,2))
  call Hloop_QV_A(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,219),heltab2x144(:,:,261))
  call Hloop_Q_A(ntryL,G0H72(1),32,nMT,G1H72(83),n2h72(187))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)+c(20)*M(3,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(280),h0tab(:,280),[32,13,2,16],[nMT,0,nMT,nMT],4,1,wf18(:,2))
  call Hloop_AV_Q(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,220),heltab2x144(:,:,262))
  call Hloop_A_Q(ntryL,G0H72(1),32,nMT,G1H72(84),n2h72(188))
  Gcoeff(:)%j = (c(22)*M(1,:)%j+c(20)*M(3,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(281),h0tab(:,281),[32,13,2,16],[0,nMT,0,0],4,1,wf18(:,2))
  call Hloop_UV_W(ntryL,G0H144(1),0,ex6(:),32,G1H72(85),m3h2x72(:,221),heltab2x144(:,:,263))
  Gcoeff(:)%j = (-(c(19)*M(2,:)%j)+c(20)*M(3,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(282),h0tab(:,282),[32,2,13,16],[nMT,0,nMT,nMT],4,1,wf18(:,2))
  call Hloop_QV_A(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,222),heltab2x144(:,:,264))
  call Hloop_Q_A(ntryL,G0H72(1),32,nMT,G1H72(86),n2h72(189))
  Gcoeff(:)%j = (c(22)*M(2,:)%j+c(20)*M(3,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(283),h0tab(:,283),[32,2,13,16],[0,nMT,0,0],4,1,wf18(:,2))
  call Hloop_UV_W(ntryL,G0H144(1),0,ex6(:),32,G1H72(87),m3h2x72(:,223),heltab2x144(:,:,265))
  Gcoeff(:)%j = (c(17)*M(2,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(284),h0tab(:,284),[32,2,8,21],[0,nMT,nMB,0],4,1,wf12(:,3))
  call Hloop_UV_W(ntryL,G0H144(1),0,ex6(:),32,G1H72(88),m3h2x72(:,224),heltab2x144(:,:,266))
  Gcoeff(:)%j = (-(c(19)*M(2,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(285),h0tab(:,285),[32,8,2,21],[nMB,nMT,0,nMB],4,1,wf12(:,3))
  call Hloop_QV_A(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,225),heltab2x144(:,:,267))
  call Hloop_Q_A(ntryL,G0H72(1),32,nMB,G1H72(89),n2h72(190))
  Gcoeff(:)%j = (-(c(19)*M(2,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(286),h0tab(:,286),[32,2,21,8],[nMT,0,nMB,nMT],4,1,wf12(:,3))
  call Hloop_QV_A(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,226),heltab2x144(:,:,268))
  call Hloop_Q_A(ntryL,G0H72(1),32,nMT,G1H72(90),n2h72(191))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(100)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(287),h0tab(:,287),[37,8,2,16],[nMB,nMT,0,0],4,1,wf12(:,18))
  call Hloop_VQ_A(ntryL,G0H144(1),wf12(:,18),G0H12(1),m3h12x12(:,1),heltab2x144(:,:,269))
  call Hloop_Q_A(ntryL,G0H12(1),37,nMB,G1H12(80),n2h12(127))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(100)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(288),h0tab(:,288),[37,2,8,16],[0,nMT,nMB,nMB],4,1,wf12(:,18))
  call Hloop_AQ_V(ntryL,G0H144(1),wf12(:,18),G0H12(2),m3h12x12(:,2),heltab2x144(:,:,270))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(100)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(289),h0tab(:,289),[37,2,16,8],[0,nMT,nMT,nMB],4,1,wf12(:,18))
  call Hloop_AQ_V(ntryL,G0H144(1),wf12(:,18),G0H12(3),m3h12x12(:,3),heltab2x144(:,:,271))
  Gcoeff(:)%j = (-(c(19)*M(2,:)%j)) * den(340)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(290),h0tab(:,290),[32,4,17,10],[nMB,nMT,0,nMB],4,2,wf4(:,7),wf6(:,4))
  call Hloop_AV_Q(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,227),heltab2x144(:,:,272))
  call Hloop_A_Q(ntryL,G0H72(1),32,nMB,G1H72(91),n2h72(192))
  Gcoeff(:)%j = (-(c(19)*M(2,:)%j)) * den(340)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(291),h0tab(:,291),[32,4,10,17],[nMT,nMB,0,nMT],4,2,wf6(:,4),wf4(:,7))
  call Hloop_QV_A(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,228),heltab2x144(:,:,273))
  call Hloop_Q_A(ntryL,G0H72(1),32,nMT,G1H72(92),n2h72(193))
  Gcoeff(:)%j = (c(17)*M(2,:)%j) * den(340)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(292),h0tab(:,292),[32,10,4,17],[0,nMB,nMT,0],4,2,wf6(:,4),wf4(:,7))
  call Hloop_UV_W(ntryL,G0H144(1),0,ex6(:),32,G1H72(93),m3h2x72(:,229),heltab2x144(:,:,274))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(341)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(293),h0tab(:,293),[33,4,16,10],[nMT,nMB,nMB,0],4,2,wf4(:,9),wf6(:,4))
  call Hloop_VQ_A(ntryL,G0H144(1),wf4(:,9),G0H36(18),m3h4x36(:,31),heltab2x144(:,:,275))
  call Hloop_Q_A(ntryL,G0H36(18),33,nMT,G1H36(13),n2h36(71))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(341)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(294),h0tab(:,294),[33,10,4,16],[0,nMB,nMT,nMT],4,2,wf4(:,9),wf6(:,4))
  call Hloop_AQ_V(ntryL,G0H144(1),wf4(:,9),G0H36(18),m3h4x36(:,32),heltab2x144(:,:,276))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(341)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(295),h0tab(:,295),[33,4,10,16],[nMT,nMB,0,0],4,2,wf4(:,9),wf6(:,4))
  call Hloop_VQ_A(ntryL,G0H144(1),wf4(:,9),G0H36(19),m3h4x36(:,33),heltab2x144(:,:,277))
  call Hloop_Q_A(ntryL,G0H36(19),33,nMT,G1H36(14),n2h36(72))
  Gcoeff(:)%j = (c(14)*(M(1,:)%j-M(2,:)%j)) * den(150)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(296),h0tab(:,296),[48,4,1,10],[nMB,nMT,0,nMB],4,2,wf4(:,1),wf6(:,4))
  call Hloop_AV_Q(ntryL,G0H144(1),wf4(:,1),G0H36(19),m3h4x36(:,34),heltab2x144(:,:,278))
  call Hloop_A_Q(ntryL,G0H36(19),48,nMB,G1H36(45),n2h36(73))
  Gcoeff(:)%j = (c(22)*(M(1,:)%j-M(2,:)%j)) * den(150)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(297),h0tab(:,297),[48,1,4,10],[0,nMT,nMB,0],4,2,wf4(:,1),wf6(:,4))
  call Hloop_UV_W(ntryL,G0H144(1),0,wf4(:,1),48,G1H36(46),m3h4x36(:,35),heltab2x144(:,:,279))
  Gcoeff(:)%j = (c(14)*(M(1,:)%j-M(2,:)%j)) * den(150)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(298),h0tab(:,298),[48,1,10,4],[nMT,0,nMB,nMT],4,2,wf4(:,1),wf6(:,4))
  call Hloop_AV_Q(ntryL,G0H144(1),wf4(:,1),G0H36(19),m3h4x36(:,36),heltab2x144(:,:,280))
  call Hloop_A_Q(ntryL,G0H36(19),48,nMT,G1H36(47),n2h36(74))
  Gcoeff(:)%j = (c(15)*M(3,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(299),h0tab(:,299),[32,1,16,14],[0,nMT,nMT,0],4,1,wf18(:,4))
  call Hloop_UV_W(ntryL,G0H144(1),0,ex6(:),32,G1H72(94),m3h2x72(:,230),heltab2x144(:,:,281))
  Gcoeff(:)%j = (-(c(15)*M(3,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(300),h0tab(:,300),[32,1,16,14],[nMT,0,0,nMT],4,1,wf18(:,4))
  call Hloop_AV_Q(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,231),heltab2x144(:,:,282))
  call Hloop_A_Q(ntryL,G0H72(1),32,nMT,G1H72(95),n2h72(194))
  Gcoeff(:)%j = (-(c(19)*M(2,:)%j)+c(20)*M(3,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(301),h0tab(:,301),[32,14,1,16],[nMT,0,nMT,nMT],4,1,wf18(:,4))
  call Hloop_QV_A(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,232),heltab2x144(:,:,283))
  call Hloop_Q_A(ntryL,G0H72(1),32,nMT,G1H72(96),n2h72(195))
  Gcoeff(:)%j = (c(22)*M(2,:)%j+c(20)*M(3,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(302),h0tab(:,302),[32,14,1,16],[0,nMT,0,0],4,1,wf18(:,4))
  call Hloop_UV_W(ntryL,G0H144(1),0,ex6(:),32,G1H72(97),m3h2x72(:,233),heltab2x144(:,:,284))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)+c(20)*M(3,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(303),h0tab(:,303),[32,1,14,16],[nMT,0,nMT,nMT],4,1,wf18(:,4))
  call Hloop_AV_Q(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,234),heltab2x144(:,:,285))
  call Hloop_A_Q(ntryL,G0H72(1),32,nMT,G1H72(98),n2h72(196))
  Gcoeff(:)%j = (c(22)*M(1,:)%j+c(20)*M(3,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(304),h0tab(:,304),[32,1,14,16],[0,nMT,0,0],4,1,wf18(:,4))
  call Hloop_UV_W(ntryL,G0H144(1),0,ex6(:),32,G1H72(99),m3h2x72(:,235),heltab2x144(:,:,286))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(305),h0tab(:,305),[32,1,4,26],[0,nMT,nMB,0],4,1,wf12(:,6))
  call Hloop_UV_W(ntryL,G0H144(1),0,ex6(:),32,G1H72(100),m3h2x72(:,236),heltab2x144(:,:,287))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(306),h0tab(:,306),[32,4,1,26],[nMB,nMT,0,nMB],4,1,wf12(:,6))
  call Hloop_AV_Q(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,237),heltab2x144(:,:,288))
  call Hloop_A_Q(ntryL,G0H72(1),32,nMB,G1H72(101),n2h72(197))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(307),h0tab(:,307),[32,1,26,4],[nMT,0,nMB,nMT],4,1,wf12(:,6))
  call Hloop_AV_Q(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,238),heltab2x144(:,:,289))
  call Hloop_A_Q(ntryL,G0H72(1),32,nMT,G1H72(102),n2h72(198))
  Gcoeff(:)%j = (c(17)*M(2,:)%j) * den(102)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(308),h0tab(:,308),[42,4,1,16],[nMB,nMT,0,0],4,1,wf12(:,20))
  call Hloop_VA_Q(ntryL,G0H144(1),wf12(:,20),G0H12(4),m3h12x12(:,4),heltab2x144(:,:,290))
  call Hloop_A_Q(ntryL,G0H12(4),42,nMB,G1H12(91),n2h12(128))
  Gcoeff(:)%j = (-(c(19)*M(2,:)%j)) * den(102)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(309),h0tab(:,309),[42,1,4,16],[0,nMT,nMB,nMB],4,1,wf12(:,20))
  call Hloop_QA_V(ntryL,G0H144(1),wf12(:,20),G0H12(5),m3h12x12(:,5),heltab2x144(:,:,291))
  Gcoeff(:)%j = (-(c(19)*M(2,:)%j)) * den(102)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(310),h0tab(:,310),[42,1,16,4],[0,nMT,nMT,nMB],4,1,wf12(:,20))
  call Hloop_QA_V(ntryL,G0H144(1),wf12(:,20),G0H12(6),m3h12x12(:,6),heltab2x144(:,:,292))
  Gcoeff(:)%j = (c(30)*M(2,:)%j) * den(214)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(311),h0tab(:,311),[32,2,17,12],[nMT,0,nMT,nMT],4,2,wf4(:,7),wf9(:,1))
  call Hloop_QV_A(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,239),heltab2x144(:,:,293))
  call Hloop_Q_A(ntryL,G0H72(1),32,nMT,G1H72(103),n2h72(199))
  Gcoeff(:)%j = (-(c(8)*M(2,:)%j)) * den(218)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(312),h0tab(:,312),[32,2,17,12],[nMT,0,nMT,nMT],4,2,wf4(:,7),wf9(:,2))
  call Hloop_QV_A(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,240),heltab2x144(:,:,294))
  call Hloop_Q_A(ntryL,G0H72(1),32,nMT,G1H72(104),n2h72(200))
  Gcoeff(:)%j = (-(c(41)*M(2,:)%j)) * den(221)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(313),h0tab(:,313),[32,2,17,12],[nMT,0,nMT,nMT],4,2,wf4(:,7),wf9(:,3))
  call Hloop_QV_A(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,241),heltab2x144(:,:,295))
  call Hloop_Q_A(ntryL,G0H72(1),32,nMT,G1H72(105),n2h72(201))
  Gcoeff(:)%j = (-(c(28)*M(2,:)%j)) * den(214)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(314),h0tab(:,314),[32,2,12,17],[0,nMT,nMT,0],4,2,wf9(:,1),wf4(:,7))
  call Hloop_UV_W(ntryL,G0H144(1),0,ex6(:),32,G1H72(106),m3h2x72(:,242),heltab2x144(:,:,296))
  Gcoeff(:)%j = (c(6)*M(2,:)%j) * den(218)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(315),h0tab(:,315),[32,2,12,17],[0,nMT,nMT,0],4,2,wf9(:,2),wf4(:,7))
  call Hloop_UV_W(ntryL,G0H144(1),0,ex6(:),32,G1H72(107),m3h2x72(:,243),heltab2x144(:,:,297))
  Gcoeff(:)%j = (c(39)*M(2,:)%j) * den(221)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(316),h0tab(:,316),[32,2,12,17],[0,nMT,nMT,0],4,2,wf9(:,3),wf4(:,7))
  call Hloop_UV_W(ntryL,G0H144(1),0,ex6(:),32,G1H72(108),m3h2x72(:,244),heltab2x144(:,:,298))
  Gcoeff(:)%j = (c(30)*M(2,:)%j) * den(214)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(317),h0tab(:,317),[32,12,2,17],[nMT,nMT,0,nMT],4,2,wf9(:,1),wf4(:,7))
  call Hloop_QV_A(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,245),heltab2x144(:,:,299))
  call Hloop_Q_A(ntryL,G0H72(1),32,nMT,G1H72(109),n2h72(202))
  Gcoeff(:)%j = (-(c(8)*M(2,:)%j)) * den(218)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(318),h0tab(:,318),[32,12,2,17],[nMT,nMT,0,nMT],4,2,wf9(:,2),wf4(:,7))
  call Hloop_QV_A(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,246),heltab2x144(:,:,300))
  call Hloop_Q_A(ntryL,G0H72(1),32,nMT,G1H72(110),n2h72(203))
  Gcoeff(:)%j = (-(c(41)*M(2,:)%j)) * den(221)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(319),h0tab(:,319),[32,12,2,17],[nMT,nMT,0,nMT],4,2,wf9(:,3),wf4(:,7))
  call Hloop_QV_A(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,247),heltab2x144(:,:,301))
  call Hloop_Q_A(ntryL,G0H72(1),32,nMT,G1H72(111),n2h72(204))
  Gcoeff(:)%j = (c(30)*M(1,:)%j) * den(230)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(320),h0tab(:,320),[32,1,18,12],[nMT,0,nMT,nMT],4,2,wf4(:,3),wf9(:,1))
  call Hloop_AV_Q(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,248),heltab2x144(:,:,302))
  call Hloop_A_Q(ntryL,G0H72(1),32,nMT,G1H72(112),n2h72(205))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(234)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(321),h0tab(:,321),[32,1,18,12],[nMT,0,nMT,nMT],4,2,wf4(:,3),wf9(:,2))
  call Hloop_AV_Q(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,249),heltab2x144(:,:,303))
  call Hloop_A_Q(ntryL,G0H72(1),32,nMT,G1H72(113),n2h72(206))
  Gcoeff(:)%j = (-(c(41)*M(1,:)%j)) * den(237)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(322),h0tab(:,322),[32,1,18,12],[nMT,0,nMT,nMT],4,2,wf4(:,3),wf9(:,3))
  call Hloop_AV_Q(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,250),heltab2x144(:,:,304))
  call Hloop_A_Q(ntryL,G0H72(1),32,nMT,G1H72(114),n2h72(207))
  Gcoeff(:)%j = (c(28)*M(1,:)%j) * den(230)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(323),h0tab(:,323),[32,1,12,18],[0,nMT,nMT,0],4,2,wf9(:,1),wf4(:,3))
  call Hloop_UV_W(ntryL,G0H144(1),0,ex6(:),32,G1H72(115),m3h2x72(:,251),heltab2x144(:,:,305))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(234)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(324),h0tab(:,324),[32,1,12,18],[0,nMT,nMT,0],4,2,wf9(:,2),wf4(:,3))
  call Hloop_UV_W(ntryL,G0H144(1),0,ex6(:),32,G1H72(116),m3h2x72(:,252),heltab2x144(:,:,306))
  Gcoeff(:)%j = (-(c(39)*M(1,:)%j)) * den(237)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(325),h0tab(:,325),[32,1,12,18],[0,nMT,nMT,0],4,2,wf9(:,3),wf4(:,3))
  call Hloop_UV_W(ntryL,G0H144(1),0,ex6(:),32,G1H72(117),m3h2x72(:,253),heltab2x144(:,:,307))
  Gcoeff(:)%j = (c(30)*M(1,:)%j) * den(230)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(326),h0tab(:,326),[32,12,1,18],[nMT,nMT,0,nMT],4,2,wf9(:,1),wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,254),heltab2x144(:,:,308))
  call Hloop_A_Q(ntryL,G0H72(1),32,nMT,G1H72(118),n2h72(208))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(234)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(327),h0tab(:,327),[32,12,1,18],[nMT,nMT,0,nMT],4,2,wf9(:,2),wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,255),heltab2x144(:,:,309))
  call Hloop_A_Q(ntryL,G0H72(1),32,nMT,G1H72(119),n2h72(209))
  Gcoeff(:)%j = (-(c(41)*M(1,:)%j)) * den(237)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(328),h0tab(:,328),[32,12,1,18],[nMT,nMT,0,nMT],4,2,wf9(:,3),wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,256),heltab2x144(:,:,310))
  call Hloop_A_Q(ntryL,G0H72(1),32,nMT,G1H72(120),n2h72(210))
  Gcoeff(:)%j = (c(30)*M(1,:)%j) * den(240)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(329),h0tab(:,329),[33,2,16,12],[0,nMT,nMT,nMT],4,2,wf4(:,9),wf9(:,1))
  call Hloop_AQ_V(ntryL,G0H144(1),wf4(:,9),G0H36(19),m3h4x36(:,37),heltab2x144(:,:,311))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(244)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(330),h0tab(:,330),[33,2,16,12],[0,nMT,nMT,nMT],4,2,wf4(:,9),wf9(:,2))
  call Hloop_AQ_V(ntryL,G0H144(1),wf4(:,9),G0H36(20),m3h4x36(:,38),heltab2x144(:,:,312))
  Gcoeff(:)%j = (-(c(41)*M(1,:)%j)) * den(247)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(331),h0tab(:,331),[33,2,16,12],[0,nMT,nMT,nMT],4,2,wf4(:,9),wf9(:,3))
  call Hloop_AQ_V(ntryL,G0H144(1),wf4(:,9),G0H36(21),m3h4x36(:,39),heltab2x144(:,:,313))
  Gcoeff(:)%j = (c(28)*M(1,:)%j) * den(240)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(332),h0tab(:,332),[33,12,2,16],[nMT,nMT,0,0],4,2,wf4(:,9),wf9(:,1))
  call Hloop_VQ_A(ntryL,G0H144(1),wf4(:,9),G0H36(22),m3h4x36(:,40),heltab2x144(:,:,314))
  call Hloop_Q_A(ntryL,G0H36(22),33,nMT,G1H36(48),n2h36(75))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(244)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(333),h0tab(:,333),[33,12,2,16],[nMT,nMT,0,0],4,2,wf4(:,9),wf9(:,2))
  call Hloop_VQ_A(ntryL,G0H144(1),wf4(:,9),G0H36(22),m3h4x36(:,41),heltab2x144(:,:,315))
  call Hloop_Q_A(ntryL,G0H36(22),33,nMT,G1H36(49),n2h36(76))
  Gcoeff(:)%j = (-(c(39)*M(1,:)%j)) * den(247)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(334),h0tab(:,334),[33,12,2,16],[nMT,nMT,0,0],4,2,wf4(:,9),wf9(:,3))
  call Hloop_VQ_A(ntryL,G0H144(1),wf4(:,9),G0H36(22),m3h4x36(:,42),heltab2x144(:,:,316))
  call Hloop_Q_A(ntryL,G0H36(22),33,nMT,G1H36(51),n2h36(77))
  Gcoeff(:)%j = (c(30)*M(1,:)%j) * den(240)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(335),h0tab(:,335),[33,2,12,16],[0,nMT,nMT,nMT],4,2,wf4(:,9),wf9(:,1))
  call Hloop_AQ_V(ntryL,G0H144(1),wf4(:,9),G0H36(22),m3h4x36(:,43),heltab2x144(:,:,317))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(244)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(336),h0tab(:,336),[33,2,12,16],[0,nMT,nMT,nMT],4,2,wf4(:,9),wf9(:,2))
  call Hloop_AQ_V(ntryL,G0H144(1),wf4(:,9),G0H36(23),m3h4x36(:,44),heltab2x144(:,:,318))
  Gcoeff(:)%j = (-(c(41)*M(1,:)%j)) * den(247)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(337),h0tab(:,337),[33,2,12,16],[0,nMT,nMT,nMT],4,2,wf4(:,9),wf9(:,3))
  call Hloop_AQ_V(ntryL,G0H144(1),wf4(:,9),G0H36(24),m3h4x36(:,45),heltab2x144(:,:,319))
  Gcoeff(:)%j = (c(30)*M(2,:)%j) * den(204)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(338),h0tab(:,338),[34,1,16,12],[0,nMT,nMT,nMT],4,2,wf4(:,5),wf9(:,1))
  call Hloop_QA_V(ntryL,G0H144(1),wf4(:,5),G0H36(25),m3h4x36(:,46),heltab2x144(:,:,320))
  Gcoeff(:)%j = (-(c(8)*M(2,:)%j)) * den(208)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(339),h0tab(:,339),[34,1,16,12],[0,nMT,nMT,nMT],4,2,wf4(:,5),wf9(:,2))
  call Hloop_QA_V(ntryL,G0H144(1),wf4(:,5),G0H36(26),m3h4x36(:,47),heltab2x144(:,:,321))
  Gcoeff(:)%j = (-(c(41)*M(2,:)%j)) * den(211)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(340),h0tab(:,340),[34,1,16,12],[0,nMT,nMT,nMT],4,2,wf4(:,5),wf9(:,3))
  call Hloop_QA_V(ntryL,G0H144(1),wf4(:,5),G0H36(27),m3h4x36(:,48),heltab2x144(:,:,322))
  Gcoeff(:)%j = (-(c(28)*M(2,:)%j)) * den(204)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(341),h0tab(:,341),[34,12,1,16],[nMT,nMT,0,0],4,2,wf4(:,5),wf9(:,1))
  call Hloop_VA_Q(ntryL,G0H144(1),wf4(:,5),G0H36(28),m3h4x36(:,49),heltab2x144(:,:,323))
  call Hloop_A_Q(ntryL,G0H36(28),34,nMT,G1H36(52),n2h36(78))
  Gcoeff(:)%j = (c(6)*M(2,:)%j) * den(208)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(342),h0tab(:,342),[34,12,1,16],[nMT,nMT,0,0],4,2,wf4(:,5),wf9(:,2))
  call Hloop_VA_Q(ntryL,G0H144(1),wf4(:,5),G0H36(28),m3h4x36(:,50),heltab2x144(:,:,324))
  call Hloop_A_Q(ntryL,G0H36(28),34,nMT,G1H36(53),n2h36(79))
  Gcoeff(:)%j = (c(39)*M(2,:)%j) * den(211)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(343),h0tab(:,343),[34,12,1,16],[nMT,nMT,0,0],4,2,wf4(:,5),wf9(:,3))
  call Hloop_VA_Q(ntryL,G0H144(1),wf4(:,5),G0H36(28),m3h4x36(:,51),heltab2x144(:,:,325))
  call Hloop_A_Q(ntryL,G0H36(28),34,nMT,G1H36(54),n2h36(80))
  Gcoeff(:)%j = (c(30)*M(2,:)%j) * den(204)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(344),h0tab(:,344),[34,1,12,16],[0,nMT,nMT,nMT],4,2,wf4(:,5),wf9(:,1))
  call Hloop_QA_V(ntryL,G0H144(1),wf4(:,5),G0H36(28),m3h4x36(:,52),heltab2x144(:,:,326))
  Gcoeff(:)%j = (-(c(8)*M(2,:)%j)) * den(208)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(345),h0tab(:,345),[34,1,12,16],[0,nMT,nMT,nMT],4,2,wf4(:,5),wf9(:,2))
  call Hloop_QA_V(ntryL,G0H144(1),wf4(:,5),G0H36(29),m3h4x36(:,53),heltab2x144(:,:,327))
  Gcoeff(:)%j = (-(c(41)*M(2,:)%j)) * den(211)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(346),h0tab(:,346),[34,1,12,16],[0,nMT,nMT,nMT],4,2,wf4(:,5),wf9(:,3))
  call Hloop_QA_V(ntryL,G0H144(1),wf4(:,5),G0H36(30),m3h4x36(:,54),heltab2x144(:,:,328))
  Gcoeff(:)%j = (c(25)*(-M(1,:)%j+M(2,:)%j)) * den(352)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(347),h0tab(:,347),[48,2,1,12],[nMT,0,nMT,nMT],4,2,wf4(:,1),wf9(:,1))
  call Hloop_QV_A(ntryL,G0H144(1),wf4(:,1),G0H36(31),m3h4x36(:,55),heltab2x144(:,:,329))
  call Hloop_Q_A(ntryL,G0H36(31),48,nMT,G1H36(55),n2h36(81))
  Gcoeff(:)%j = (c(3)*(M(1,:)%j-M(2,:)%j)) * den(353)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(348),h0tab(:,348),[48,2,1,12],[nMT,0,nMT,nMT],4,2,wf4(:,1),wf9(:,2))
  call Hloop_QV_A(ntryL,G0H144(1),wf4(:,1),G0H36(31),m3h4x36(:,56),heltab2x144(:,:,330))
  call Hloop_Q_A(ntryL,G0H36(31),48,nMT,G1H36(57),n2h36(82))
  Gcoeff(:)%j = (c(36)*(M(1,:)%j-M(2,:)%j)) * den(354)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(349),h0tab(:,349),[48,2,1,12],[nMT,0,nMT,nMT],4,2,wf4(:,1),wf9(:,3))
  call Hloop_QV_A(ntryL,G0H144(1),wf4(:,1),G0H36(31),m3h4x36(:,57),heltab2x144(:,:,331))
  call Hloop_Q_A(ntryL,G0H36(31),48,nMT,G1H36(58),n2h36(83))
  Gcoeff(:)%j = (c(25)*(-M(1,:)%j+M(2,:)%j)) * den(352)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(350),h0tab(:,350),[48,1,2,12],[nMT,0,nMT,nMT],4,2,wf4(:,1),wf9(:,1))
  call Hloop_AV_Q(ntryL,G0H144(1),wf4(:,1),G0H36(31),m3h4x36(:,58),heltab2x144(:,:,332))
  call Hloop_A_Q(ntryL,G0H36(31),48,nMT,G1H36(59),n2h36(84))
  Gcoeff(:)%j = (c(3)*(M(1,:)%j-M(2,:)%j)) * den(353)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(351),h0tab(:,351),[48,1,2,12],[nMT,0,nMT,nMT],4,2,wf4(:,1),wf9(:,2))
  call Hloop_AV_Q(ntryL,G0H144(1),wf4(:,1),G0H36(31),m3h4x36(:,59),heltab2x144(:,:,333))
  call Hloop_A_Q(ntryL,G0H36(31),48,nMT,G1H36(20),n2h36(85))
  Gcoeff(:)%j = (c(36)*(M(1,:)%j-M(2,:)%j)) * den(354)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(352),h0tab(:,352),[48,1,2,12],[nMT,0,nMT,nMT],4,2,wf4(:,1),wf9(:,3))
  call Hloop_AV_Q(ntryL,G0H144(1),wf4(:,1),G0H36(31),m3h4x36(:,60),heltab2x144(:,:,334))
  call Hloop_A_Q(ntryL,G0H36(31),48,nMT,G1H36(21),n2h36(86))
  Gcoeff(:)%j = (c(33)*(-M(1,:)%j+M(2,:)%j)) * den(352)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(353),h0tab(:,353),[48,1,12,2],[0,nMT,nMT,0],4,2,wf4(:,1),wf9(:,1))
  call Hloop_UV_W(ntryL,G0H144(1),0,wf4(:,1),48,G1H36(24),m3h4x36(:,61),heltab2x144(:,:,335))
  Gcoeff(:)%j = (c(11)*(M(1,:)%j-M(2,:)%j)) * den(353)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(354),h0tab(:,354),[48,1,12,2],[0,nMT,nMT,0],4,2,wf4(:,1),wf9(:,2))
  call Hloop_UV_W(ntryL,G0H144(1),0,wf4(:,1),48,G1H36(25),m3h4x36(:,62),heltab2x144(:,:,336))
  Gcoeff(:)%j = (c(44)*(M(1,:)%j-M(2,:)%j)) * den(354)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(355),h0tab(:,355),[48,1,12,2],[0,nMT,nMT,0],4,2,wf4(:,1),wf9(:,3))
  call Hloop_UV_W(ntryL,G0H144(1),0,wf4(:,1),48,G1H36(8),m3h4x36(:,63),heltab2x144(:,:,337))
  Gcoeff(:)%j = (c(26)*M(3,:)%j) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(356),h0tab(:,356),[32,2,16,13],[0,nMT,nMT,0],4,1,wf18(:,12))
  call Hloop_UV_W(ntryL,G0H144(1),0,ex6(:),32,G1H72(121),m3h2x72(:,257),heltab2x144(:,:,338))
  Gcoeff(:)%j = (-(c(26)*M(3,:)%j)) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(357),h0tab(:,357),[32,2,16,13],[nMT,0,0,nMT],4,1,wf18(:,12))
  call Hloop_QV_A(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,258),heltab2x144(:,:,339))
  call Hloop_Q_A(ntryL,G0H72(1),32,nMT,G1H72(122),n2h72(211))
  Gcoeff(:)%j = (-(c(4)*M(3,:)%j)) * den(59)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(358),h0tab(:,358),[32,2,16,13],[0,nMT,nMT,0],4,1,wf18(:,14))
  call Hloop_UV_W(ntryL,G0H144(1),0,ex6(:),32,G1H72(123),m3h2x72(:,259),heltab2x144(:,:,340))
  Gcoeff(:)%j = (-(c(37)*M(3,:)%j)) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(359),h0tab(:,359),[32,2,16,13],[0,nMT,nMT,0],4,1,wf18(:,16))
  call Hloop_UV_W(ntryL,G0H144(1),0,ex6(:),32,G1H72(124),m3h2x72(:,260),heltab2x144(:,:,341))
  Gcoeff(:)%j = (c(4)*M(3,:)%j) * den(59)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(360),h0tab(:,360),[32,2,16,13],[nMT,0,0,nMT],4,1,wf18(:,14))
  call Hloop_QV_A(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,261),heltab2x144(:,:,342))
  call Hloop_Q_A(ntryL,G0H72(1),32,nMT,G1H72(125),n2h72(212))
  Gcoeff(:)%j = (c(37)*M(3,:)%j) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(361),h0tab(:,361),[32,2,16,13],[nMT,0,0,nMT],4,1,wf18(:,16))
  call Hloop_QV_A(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,262),heltab2x144(:,:,343))
  call Hloop_Q_A(ntryL,G0H72(1),32,nMT,G1H72(126),n2h72(213))
  Gcoeff(:)%j = (c(30)*M(1,:)%j-c(31)*M(3,:)%j) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(362),h0tab(:,362),[32,13,2,16],[nMT,0,nMT,nMT],4,1,wf18(:,12))
  call Hloop_AV_Q(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,263),heltab2x144(:,:,344))
  call Hloop_A_Q(ntryL,G0H72(1),32,nMT,G1H72(127),n2h72(214))
  Gcoeff(:)%j = (-(c(33)*M(1,:)%j)-c(31)*M(3,:)%j) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(363),h0tab(:,363),[32,13,2,16],[0,nMT,0,0],4,1,wf18(:,12))
  call Hloop_UV_W(ntryL,G0H144(1),0,ex6(:),32,G1H72(128),m3h2x72(:,264),heltab2x144(:,:,345))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)+c(9)*M(3,:)%j) * den(59)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(364),h0tab(:,364),[32,13,2,16],[nMT,0,nMT,nMT],4,1,wf18(:,14))
  call Hloop_AV_Q(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,265),heltab2x144(:,:,346))
  call Hloop_A_Q(ntryL,G0H72(1),32,nMT,G1H72(129),n2h72(215))
  Gcoeff(:)%j = (-(c(41)*M(1,:)%j)+c(42)*M(3,:)%j) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(365),h0tab(:,365),[32,13,2,16],[nMT,0,nMT,nMT],4,1,wf18(:,16))
  call Hloop_AV_Q(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,266),heltab2x144(:,:,347))
  call Hloop_A_Q(ntryL,G0H72(1),32,nMT,G1H72(130),n2h72(216))
  Gcoeff(:)%j = (c(11)*M(1,:)%j+c(9)*M(3,:)%j) * den(59)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(366),h0tab(:,366),[32,13,2,16],[0,nMT,0,0],4,1,wf18(:,14))
  call Hloop_UV_W(ntryL,G0H144(1),0,ex6(:),32,G1H72(131),m3h2x72(:,267),heltab2x144(:,:,348))
  Gcoeff(:)%j = (c(44)*M(1,:)%j+c(42)*M(3,:)%j) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(367),h0tab(:,367),[32,13,2,16],[0,nMT,0,0],4,1,wf18(:,16))
  call Hloop_UV_W(ntryL,G0H144(1),0,ex6(:),32,G1H72(132),m3h2x72(:,268),heltab2x144(:,:,349))
  Gcoeff(:)%j = (c(30)*M(2,:)%j-c(31)*M(3,:)%j) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(368),h0tab(:,368),[32,2,13,16],[nMT,0,nMT,nMT],4,1,wf18(:,12))
  call Hloop_QV_A(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,269),heltab2x144(:,:,350))
  call Hloop_Q_A(ntryL,G0H72(1),32,nMT,G1H72(133),n2h72(217))
  Gcoeff(:)%j = (-(c(33)*M(2,:)%j)-c(31)*M(3,:)%j) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(369),h0tab(:,369),[32,2,13,16],[0,nMT,0,0],4,1,wf18(:,12))
  call Hloop_UV_W(ntryL,G0H144(1),0,ex6(:),32,G1H72(134),m3h2x72(:,270),heltab2x144(:,:,351))
  Gcoeff(:)%j = (-(c(8)*M(2,:)%j)+c(9)*M(3,:)%j) * den(59)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(370),h0tab(:,370),[32,2,13,16],[nMT,0,nMT,nMT],4,1,wf18(:,14))
  call Hloop_QV_A(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,271),heltab2x144(:,:,352))
  call Hloop_Q_A(ntryL,G0H72(1),32,nMT,G1H72(135),n2h72(218))
  Gcoeff(:)%j = (-(c(41)*M(2,:)%j)+c(42)*M(3,:)%j) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(371),h0tab(:,371),[32,2,13,16],[nMT,0,nMT,nMT],4,1,wf18(:,16))
  call Hloop_QV_A(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,272),heltab2x144(:,:,353))
  call Hloop_Q_A(ntryL,G0H72(1),32,nMT,G1H72(136),n2h72(219))
  Gcoeff(:)%j = (c(11)*M(2,:)%j+c(9)*M(3,:)%j) * den(59)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(372),h0tab(:,372),[32,2,13,16],[0,nMT,0,0],4,1,wf18(:,14))
  call Hloop_UV_W(ntryL,G0H144(1),0,ex6(:),32,G1H72(137),m3h2x72(:,273),heltab2x144(:,:,354))
  Gcoeff(:)%j = (c(44)*M(2,:)%j+c(42)*M(3,:)%j) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(373),h0tab(:,373),[32,2,13,16],[0,nMT,0,0],4,1,wf18(:,16))
  call Hloop_UV_W(ntryL,G0H144(1),0,ex6(:),32,G1H72(138),m3h2x72(:,274),heltab2x144(:,:,355))
  Gcoeff(:)%j = (-(c(26)*M(3,:)%j)) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(374),h0tab(:,374),[32,1,16,14],[0,nMT,nMT,0],4,1,wf18(:,6))
  call Hloop_UV_W(ntryL,G0H144(1),0,ex6(:),32,G1H72(139),m3h2x72(:,275),heltab2x144(:,:,356))
  Gcoeff(:)%j = (c(26)*M(3,:)%j) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(375),h0tab(:,375),[32,1,16,14],[nMT,0,0,nMT],4,1,wf18(:,6))
  call Hloop_AV_Q(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,276),heltab2x144(:,:,357))
  call Hloop_A_Q(ntryL,G0H72(1),32,nMT,G1H72(140),n2h72(220))
  Gcoeff(:)%j = (c(4)*M(3,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(376),h0tab(:,376),[32,1,16,14],[0,nMT,nMT,0],4,1,wf18(:,8))
  call Hloop_UV_W(ntryL,G0H144(1),0,ex6(:),32,G1H72(141),m3h2x72(:,277),heltab2x144(:,:,358))
  Gcoeff(:)%j = (c(37)*M(3,:)%j) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(377),h0tab(:,377),[32,1,16,14],[0,nMT,nMT,0],4,1,wf18(:,10))
  call Hloop_UV_W(ntryL,G0H144(1),0,ex6(:),32,G1H72(142),m3h2x72(:,278),heltab2x144(:,:,359))
  Gcoeff(:)%j = (-(c(4)*M(3,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(378),h0tab(:,378),[32,1,16,14],[nMT,0,0,nMT],4,1,wf18(:,8))
  call Hloop_AV_Q(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,279),heltab2x144(:,:,360))
  call Hloop_A_Q(ntryL,G0H72(1),32,nMT,G1H72(143),n2h72(221))
  Gcoeff(:)%j = (-(c(37)*M(3,:)%j)) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(379),h0tab(:,379),[32,1,16,14],[nMT,0,0,nMT],4,1,wf18(:,10))
  call Hloop_AV_Q(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,280),heltab2x144(:,:,361))
  call Hloop_A_Q(ntryL,G0H72(1),32,nMT,G1H72(144),n2h72(222))
  Gcoeff(:)%j = (c(30)*M(2,:)%j-c(31)*M(3,:)%j) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(380),h0tab(:,380),[32,14,1,16],[nMT,0,nMT,nMT],4,1,wf18(:,6))
  call Hloop_QV_A(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,281),heltab2x144(:,:,362))
  call Hloop_Q_A(ntryL,G0H72(1),32,nMT,G1H72(145),n2h72(223))
  Gcoeff(:)%j = (-(c(33)*M(2,:)%j)-c(31)*M(3,:)%j) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(381),h0tab(:,381),[32,14,1,16],[0,nMT,0,0],4,1,wf18(:,6))
  call Hloop_UV_W(ntryL,G0H144(1),0,ex6(:),32,G1H72(146),m3h2x72(:,282),heltab2x144(:,:,363))
  Gcoeff(:)%j = (-(c(8)*M(2,:)%j)+c(9)*M(3,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(382),h0tab(:,382),[32,14,1,16],[nMT,0,nMT,nMT],4,1,wf18(:,8))
  call Hloop_QV_A(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,283),heltab2x144(:,:,364))
  call Hloop_Q_A(ntryL,G0H72(1),32,nMT,G1H72(147),n2h72(224))
  Gcoeff(:)%j = (-(c(41)*M(2,:)%j)+c(42)*M(3,:)%j) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(383),h0tab(:,383),[32,14,1,16],[nMT,0,nMT,nMT],4,1,wf18(:,10))
  call Hloop_QV_A(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,284),heltab2x144(:,:,365))
  call Hloop_Q_A(ntryL,G0H72(1),32,nMT,G1H72(148),n2h72(225))
  Gcoeff(:)%j = (c(11)*M(2,:)%j+c(9)*M(3,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(384),h0tab(:,384),[32,14,1,16],[0,nMT,0,0],4,1,wf18(:,8))
  call Hloop_UV_W(ntryL,G0H144(1),0,ex6(:),32,G1H72(149),m3h2x72(:,285),heltab2x144(:,:,366))
  Gcoeff(:)%j = (c(44)*M(2,:)%j+c(42)*M(3,:)%j) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(385),h0tab(:,385),[32,14,1,16],[0,nMT,0,0],4,1,wf18(:,10))
  call Hloop_UV_W(ntryL,G0H144(1),0,ex6(:),32,G1H72(150),m3h2x72(:,286),heltab2x144(:,:,367))
  Gcoeff(:)%j = (c(30)*M(1,:)%j-c(31)*M(3,:)%j) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(386),h0tab(:,386),[32,1,14,16],[nMT,0,nMT,nMT],4,1,wf18(:,6))
  call Hloop_AV_Q(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,287),heltab2x144(:,:,368))
  call Hloop_A_Q(ntryL,G0H72(1),32,nMT,G1H72(151),n2h72(226))
  Gcoeff(:)%j = (-(c(33)*M(1,:)%j)-c(31)*M(3,:)%j) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(387),h0tab(:,387),[32,1,14,16],[0,nMT,0,0],4,1,wf18(:,6))
  call Hloop_UV_W(ntryL,G0H144(1),0,ex6(:),32,G1H72(152),m3h2x72(:,288),heltab2x144(:,:,369))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)+c(9)*M(3,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(388),h0tab(:,388),[32,1,14,16],[nMT,0,nMT,nMT],4,1,wf18(:,8))
  call Hloop_AV_Q(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,289),heltab2x144(:,:,370))
  call Hloop_A_Q(ntryL,G0H72(1),32,nMT,G1H72(153),n2h72(227))
  Gcoeff(:)%j = (-(c(41)*M(1,:)%j)+c(42)*M(3,:)%j) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(389),h0tab(:,389),[32,1,14,16],[nMT,0,nMT,nMT],4,1,wf18(:,10))
  call Hloop_AV_Q(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,290),heltab2x144(:,:,371))
  call Hloop_A_Q(ntryL,G0H72(1),32,nMT,G1H72(154),n2h72(228))
  Gcoeff(:)%j = (c(11)*M(1,:)%j+c(9)*M(3,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(390),h0tab(:,390),[32,1,14,16],[0,nMT,0,0],4,1,wf18(:,8))
  call Hloop_UV_W(ntryL,G0H144(1),0,ex6(:),32,G1H72(155),m3h2x72(:,291),heltab2x144(:,:,372))
  Gcoeff(:)%j = (c(44)*M(1,:)%j+c(42)*M(3,:)%j) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(391),h0tab(:,391),[32,1,14,16],[0,nMT,0,0],4,1,wf18(:,10))
  call Hloop_UV_W(ntryL,G0H144(1),0,ex6(:),32,G1H72(156),m3h2x72(:,292),heltab2x144(:,:,373))
  Gcoeff(:)%j = (c(21)*M(2,:)%j) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(392),h0tab(:,392),[34,8,4,17],[nMT,nMB,nMT,0],4,2,wf4(:,5),wf4(:,7))
  call Hloop_VA_Q(ntryL,G0H144(1),wf4(:,5),G0H36(31),m3h4x36(:,64),heltab2x144(:,:,374))
  call Hloop_A_Q(ntryL,G0H36(31),34,nMT,G1H36(26),n2h36(87))
  Gcoeff(:)%j = (-(c(59)*M(2,:)%j)) * den(110)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(393),h0tab(:,393),[32,4,8,19],[0,0,0,0],4,1,wf8(:,11))
  call Hloop_QV_A(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,293),heltab2x144(:,:,375))
  call Hloop_Q_A(ntryL,G0H72(1),32,0,G1H72(157),n2h72(229))
  Gcoeff(:)%j = (-(c(57)*M(2,:)%j)) * den(110)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(394),h0tab(:,394),[32,4,8,19],[nMT,nMB,nMT,nMT],4,1,wf8(:,11))
  call Hloop_QV_A(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,294),heltab2x144(:,:,376))
  call Hloop_Q_A(ntryL,G0H72(1),32,nMT,G1H72(158),n2h72(230))
  Gcoeff(:)%j = (-(c(59)*M(2,:)%j)) * den(110)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(395),h0tab(:,395),[32,4,8,19],[0,0,0,0],4,1,wf8(:,11))
  call Hloop_AV_Q(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,295),heltab2x144(:,:,377))
  call Hloop_A_Q(ntryL,G0H72(1),32,0,G1H72(159),n2h72(231))
  Gcoeff(:)%j = (-(c(57)*M(2,:)%j)) * den(110)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(396),h0tab(:,396),[32,4,8,19],[nMB,nMT,nMB,nMB],4,1,wf8(:,11))
  call Hloop_AV_Q(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,296),heltab2x144(:,:,378))
  call Hloop_A_Q(ntryL,G0H72(1),32,nMB,G1H72(160),n2h72(232))
  Gcoeff(:)%j = (-(c(59)*M(2,:)%j)) * den(110)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(397),h0tab(:,397),[32,8,4,19],[0,0,0,0],4,1,wf8(:,11))
  call Hloop_AV_Q(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,297),heltab2x144(:,:,379))
  call Hloop_A_Q(ntryL,G0H72(1),32,0,G1H72(161),n2h72(233))
  Gcoeff(:)%j = (-(c(57)*M(2,:)%j)) * den(110)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(398),h0tab(:,398),[32,8,4,19],[nMT,nMB,nMT,nMT],4,1,wf8(:,11))
  call Hloop_AV_Q(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,298),heltab2x144(:,:,380))
  call Hloop_A_Q(ntryL,G0H72(1),32,nMT,G1H72(162),n2h72(234))
  Gcoeff(:)%j = (-(c(59)*M(2,:)%j)) * den(110)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(399),h0tab(:,399),[32,8,4,19],[0,0,0,0],4,1,wf8(:,11))
  call Hloop_QV_A(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,299),heltab2x144(:,:,381))
  call Hloop_Q_A(ntryL,G0H72(1),32,0,G1H72(163),n2h72(235))
  Gcoeff(:)%j = (-(c(57)*M(2,:)%j)) * den(110)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(400),h0tab(:,400),[32,8,4,19],[nMB,nMT,nMB,nMB],4,1,wf8(:,11))
  call Hloop_QV_A(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,300),heltab2x144(:,:,382))
  call Hloop_Q_A(ntryL,G0H72(1),32,nMB,G1H72(164),n2h72(236))
  Gcoeff(:)%j = (-(c(59)*M(2,:)%j)) * den(110)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(401),h0tab(:,401),[32,4,19,8],[0,0,0,0],4,1,wf8(:,11))
  call Hloop_QV_A(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,301),heltab2x144(:,:,383))
  call Hloop_Q_A(ntryL,G0H72(1),32,0,G1H72(165),n2h72(237))
  Gcoeff(:)%j = (-(c(57)*M(2,:)%j)) * den(110)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(402),h0tab(:,402),[32,4,19,8],[nMT,nMB,nMB,nMT],4,1,wf8(:,11))
  call Hloop_QV_A(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,302),heltab2x144(:,:,384))
  call Hloop_Q_A(ntryL,G0H72(1),32,nMT,G1H72(166),n2h72(238))
  Gcoeff(:)%j = (-(c(59)*M(2,:)%j)) * den(110)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(403),h0tab(:,403),[32,4,19,8],[0,0,0,0],4,1,wf8(:,11))
  call Hloop_AV_Q(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,303),heltab2x144(:,:,385))
  call Hloop_A_Q(ntryL,G0H72(1),32,0,G1H72(167),n2h72(239))
  Gcoeff(:)%j = (-(c(57)*M(2,:)%j)) * den(110)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(404),h0tab(:,404),[32,4,19,8],[nMB,nMT,nMT,nMB],4,1,wf8(:,11))
  call Hloop_AV_Q(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,304),heltab2x144(:,:,386))
  call Hloop_A_Q(ntryL,G0H72(1),32,nMB,G1H72(168),n2h72(240))
  Gcoeff(:)%j = (c(17)*M(2,:)%j) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(405),h0tab(:,405),[32,2,8,21],[0,nMT,nMB,0],4,1,wf12(:,12))
  call Hloop_UV_W(ntryL,G0H144(1),0,ex6(:),32,G1H72(169),m3h2x72(:,305),heltab2x144(:,:,387))
  Gcoeff(:)%j = (-(c(19)*M(2,:)%j)) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(406),h0tab(:,406),[32,8,2,21],[nMB,nMT,0,nMB],4,1,wf12(:,12))
  call Hloop_QV_A(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,306),heltab2x144(:,:,388))
  call Hloop_Q_A(ntryL,G0H72(1),32,nMB,G1H72(170),n2h72(241))
  Gcoeff(:)%j = (-(c(19)*M(2,:)%j)) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(407),h0tab(:,407),[32,2,21,8],[nMT,0,nMB,nMT],4,1,wf12(:,12))
  call Hloop_QV_A(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,307),heltab2x144(:,:,389))
  call Hloop_Q_A(ntryL,G0H72(1),32,nMT,G1H72(171),n2h72(242))
  Gcoeff(:)%j = (c(21)*M(2,:)%j) * den(122)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(408),h0tab(:,408),[49,2,8,4],[0,nMT,nMB,nMT],4,1,wf8(:,25))
  call Hloop_AQ_V(ntryL,G0H144(1),wf8(:,25),G0H18(1),m3h8x18(:,13),heltab2x144(:,:,390))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(409),h0tab(:,409),[33,4,8,18],[nMT,nMB,nMT,0],4,2,wf4(:,9),wf4(:,3))
  call Hloop_VQ_A(ntryL,G0H144(1),wf4(:,9),G0H36(31),m3h4x36(:,65),heltab2x144(:,:,391))
  call Hloop_Q_A(ntryL,G0H36(31),33,nMT,G1H36(28),n2h36(88))
  Gcoeff(:)%j = (-(c(59)*M(1,:)%j)) * den(113)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(410),h0tab(:,410),[32,4,8,19],[0,0,0,0],4,1,wf8(:,12))
  call Hloop_QV_A(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,308),heltab2x144(:,:,392))
  call Hloop_Q_A(ntryL,G0H72(1),32,0,G1H72(172),n2h72(243))
  Gcoeff(:)%j = (-(c(57)*M(1,:)%j)) * den(113)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(411),h0tab(:,411),[32,4,8,19],[nMT,nMB,nMT,nMT],4,1,wf8(:,12))
  call Hloop_QV_A(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,309),heltab2x144(:,:,393))
  call Hloop_Q_A(ntryL,G0H72(1),32,nMT,G1H72(173),n2h72(244))
  Gcoeff(:)%j = (-(c(59)*M(1,:)%j)) * den(113)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(412),h0tab(:,412),[32,4,8,19],[0,0,0,0],4,1,wf8(:,12))
  call Hloop_AV_Q(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,310),heltab2x144(:,:,394))
  call Hloop_A_Q(ntryL,G0H72(1),32,0,G1H72(174),n2h72(245))
  Gcoeff(:)%j = (-(c(57)*M(1,:)%j)) * den(113)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(413),h0tab(:,413),[32,4,8,19],[nMB,nMT,nMB,nMB],4,1,wf8(:,12))
  call Hloop_AV_Q(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,311),heltab2x144(:,:,395))
  call Hloop_A_Q(ntryL,G0H72(1),32,nMB,G1H72(175),n2h72(246))
  Gcoeff(:)%j = (-(c(59)*M(1,:)%j)) * den(113)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(414),h0tab(:,414),[32,8,4,19],[0,0,0,0],4,1,wf8(:,12))
  call Hloop_AV_Q(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,312),heltab2x144(:,:,396))
  call Hloop_A_Q(ntryL,G0H72(1),32,0,G1H72(176),n2h72(247))
  Gcoeff(:)%j = (-(c(57)*M(1,:)%j)) * den(113)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(415),h0tab(:,415),[32,8,4,19],[nMT,nMB,nMT,nMT],4,1,wf8(:,12))
  call Hloop_AV_Q(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,313),heltab2x144(:,:,397))
  call Hloop_A_Q(ntryL,G0H72(1),32,nMT,G1H72(177),n2h72(248))
  Gcoeff(:)%j = (-(c(59)*M(1,:)%j)) * den(113)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(416),h0tab(:,416),[32,8,4,19],[0,0,0,0],4,1,wf8(:,12))
  call Hloop_QV_A(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,314),heltab2x144(:,:,398))
  call Hloop_Q_A(ntryL,G0H72(1),32,0,G1H72(178),n2h72(249))
  Gcoeff(:)%j = (-(c(57)*M(1,:)%j)) * den(113)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(417),h0tab(:,417),[32,8,4,19],[nMB,nMT,nMB,nMB],4,1,wf8(:,12))
  call Hloop_QV_A(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,315),heltab2x144(:,:,399))
  call Hloop_Q_A(ntryL,G0H72(1),32,nMB,G1H72(179),n2h72(250))
  Gcoeff(:)%j = (-(c(59)*M(1,:)%j)) * den(113)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(418),h0tab(:,418),[32,4,19,8],[0,0,0,0],4,1,wf8(:,12))
  call Hloop_QV_A(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,316),heltab2x144(:,:,400))
  call Hloop_Q_A(ntryL,G0H72(1),32,0,G1H72(180),n2h72(251))
  Gcoeff(:)%j = (-(c(57)*M(1,:)%j)) * den(113)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(419),h0tab(:,419),[32,4,19,8],[nMT,nMB,nMB,nMT],4,1,wf8(:,12))
  call Hloop_QV_A(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,317),heltab2x144(:,:,401))
  call Hloop_Q_A(ntryL,G0H72(1),32,nMT,G1H72(181),n2h72(252))
  Gcoeff(:)%j = (-(c(59)*M(1,:)%j)) * den(113)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(420),h0tab(:,420),[32,4,19,8],[0,0,0,0],4,1,wf8(:,12))
  call Hloop_AV_Q(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,318),heltab2x144(:,:,402))
  call Hloop_A_Q(ntryL,G0H72(1),32,0,G1H72(182),n2h72(253))
  Gcoeff(:)%j = (-(c(57)*M(1,:)%j)) * den(113)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(421),h0tab(:,421),[32,4,19,8],[nMB,nMT,nMT,nMB],4,1,wf8(:,12))
  call Hloop_AV_Q(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,319),heltab2x144(:,:,403))
  call Hloop_A_Q(ntryL,G0H72(1),32,nMB,G1H72(183),n2h72(254))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(422),h0tab(:,422),[32,1,4,26],[0,nMT,nMB,0],4,1,wf12(:,8))
  call Hloop_UV_W(ntryL,G0H144(1),0,ex6(:),32,G1H72(184),m3h2x72(:,320),heltab2x144(:,:,404))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(423),h0tab(:,423),[32,4,1,26],[nMB,nMT,0,nMB],4,1,wf12(:,8))
  call Hloop_AV_Q(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,321),heltab2x144(:,:,405))
  call Hloop_A_Q(ntryL,G0H72(1),32,nMB,G1H72(185),n2h72(255))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(424),h0tab(:,424),[32,1,26,4],[nMT,0,nMB,nMT],4,1,wf12(:,8))
  call Hloop_AV_Q(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,322),heltab2x144(:,:,406))
  call Hloop_A_Q(ntryL,G0H72(1),32,nMT,G1H72(186),n2h72(256))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(105)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(425),h0tab(:,425),[50,1,4,8],[0,nMT,nMB,nMT],4,1,wf8(:,19))
  call Hloop_QA_V(ntryL,G0H144(1),wf8(:,19),G0H18(2),m3h8x18(:,14),heltab2x144(:,:,407))
  Gcoeff(:)%j = (-(c(59)*M(1,:)%j)) * den(116)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(426),h0tab(:,426),[35,8,4,16],[0,0,0,0],4,1,wf8(:,13))
  call Hloop_AV_Q(ntryL,G0H144(1),wf8(:,13),G0H18(3),m3h8x18(:,15),heltab2x144(:,:,408))
  call Hloop_A_Q(ntryL,G0H18(3),35,0,G1H18(35),n2h18(161))
  Gcoeff(:)%j = (-(c(57)*M(1,:)%j)) * den(116)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(427),h0tab(:,427),[35,8,4,16],[nMT,nMB,nMT,nMT],4,1,wf8(:,13))
  call Hloop_AV_Q(ntryL,G0H144(1),wf8(:,13),G0H18(3),m3h8x18(:,16),heltab2x144(:,:,409))
  call Hloop_A_Q(ntryL,G0H18(3),35,nMT,G1H18(38),n2h18(162))
  Gcoeff(:)%j = (-(c(59)*M(1,:)%j)) * den(116)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(428),h0tab(:,428),[35,8,4,16],[0,0,0,0],4,1,wf8(:,13))
  call Hloop_QV_A(ntryL,G0H144(1),wf8(:,13),G0H18(3),m3h8x18(:,17),heltab2x144(:,:,410))
  call Hloop_Q_A(ntryL,G0H18(3),35,0,G1H18(39),n2h18(163))
  Gcoeff(:)%j = (-(c(57)*M(1,:)%j)) * den(116)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(429),h0tab(:,429),[35,8,4,16],[nMB,nMT,nMB,nMB],4,1,wf8(:,13))
  call Hloop_QV_A(ntryL,G0H144(1),wf8(:,13),G0H18(3),m3h8x18(:,18),heltab2x144(:,:,411))
  call Hloop_Q_A(ntryL,G0H18(3),35,nMB,G1H18(12),n2h18(164))
  Gcoeff(:)%j = (-(c(59)*M(1,:)%j)) * den(116)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(430),h0tab(:,430),[35,4,8,16],[0,0,0,0],4,1,wf8(:,13))
  call Hloop_QV_A(ntryL,G0H144(1),wf8(:,13),G0H18(3),m3h8x18(:,19),heltab2x144(:,:,412))
  call Hloop_Q_A(ntryL,G0H18(3),35,0,G1H18(18),n2h18(165))
  Gcoeff(:)%j = (-(c(57)*M(1,:)%j)) * den(116)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(431),h0tab(:,431),[35,4,8,16],[nMT,nMB,nMT,nMT],4,1,wf8(:,13))
  call Hloop_QV_A(ntryL,G0H144(1),wf8(:,13),G0H18(3),m3h8x18(:,20),heltab2x144(:,:,413))
  call Hloop_Q_A(ntryL,G0H18(3),35,nMT,G1H18(47),n2h18(166))
  Gcoeff(:)%j = (-(c(59)*M(1,:)%j)) * den(116)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(432),h0tab(:,432),[35,4,8,16],[0,0,0,0],4,1,wf8(:,13))
  call Hloop_AV_Q(ntryL,G0H144(1),wf8(:,13),G0H18(3),m3h8x18(:,21),heltab2x144(:,:,414))
  call Hloop_A_Q(ntryL,G0H18(3),35,0,G1H18(55),n2h18(167))
  Gcoeff(:)%j = (-(c(57)*M(1,:)%j)) * den(116)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(433),h0tab(:,433),[35,4,8,16],[nMB,nMT,nMB,nMB],4,1,wf8(:,13))
  call Hloop_AV_Q(ntryL,G0H144(1),wf8(:,13),G0H18(3),m3h8x18(:,22),heltab2x144(:,:,415))
  call Hloop_A_Q(ntryL,G0H18(3),35,nMB,G1H18(7),n2h18(168))
  Gcoeff(:)%j = (-(c(59)*M(1,:)%j)) * den(116)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(434),h0tab(:,434),[35,4,16,8],[0,0,0,0],4,1,wf8(:,13))
  call Hloop_AV_Q(ntryL,G0H144(1),wf8(:,13),G0H18(3),m3h8x18(:,23),heltab2x144(:,:,416))
  call Hloop_A_Q(ntryL,G0H18(3),35,0,G1H18(25),n2h18(169))
  Gcoeff(:)%j = (-(c(57)*M(1,:)%j)) * den(116)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(435),h0tab(:,435),[35,4,16,8],[nMB,nMT,nMT,nMB],4,1,wf8(:,13))
  call Hloop_AV_Q(ntryL,G0H144(1),wf8(:,13),G0H18(3),m3h8x18(:,24),heltab2x144(:,:,417))
  call Hloop_A_Q(ntryL,G0H18(3),35,nMB,G1H18(30),n2h18(170))
  Gcoeff(:)%j = (-(c(59)*M(1,:)%j)) * den(116)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(436),h0tab(:,436),[35,4,16,8],[0,0,0,0],4,1,wf8(:,13))
  call Hloop_QV_A(ntryL,G0H144(1),wf8(:,13),G0H18(3),m3h8x18(:,25),heltab2x144(:,:,418))
  call Hloop_Q_A(ntryL,G0H18(3),35,0,G1H18(31),n2h18(171))
  Gcoeff(:)%j = (-(c(57)*M(1,:)%j)) * den(116)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(437),h0tab(:,437),[35,4,16,8],[nMT,nMB,nMB,nMT],4,1,wf8(:,13))
  call Hloop_QV_A(ntryL,G0H144(1),wf8(:,13),G0H18(3),m3h8x18(:,26),heltab2x144(:,:,419))
  call Hloop_Q_A(ntryL,G0H18(3),35,nMT,G1H18(37),n2h18(172))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(438),h0tab(:,438),[37,8,2,16],[nMB,nMT,0,0],4,1,wf12(:,14))
  call Hloop_VQ_A(ntryL,G0H144(1),wf12(:,14),G0H12(7),m3h12x12(:,7),heltab2x144(:,:,420))
  call Hloop_Q_A(ntryL,G0H12(7),37,nMB,G1H12(64),n2h12(129))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(439),h0tab(:,439),[37,2,8,16],[0,nMT,nMB,nMB],4,1,wf12(:,14))
  call Hloop_AQ_V(ntryL,G0H144(1),wf12(:,14),G0H12(8),m3h12x12(:,8),heltab2x144(:,:,421))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(440),h0tab(:,440),[37,2,16,8],[0,nMT,nMT,nMB],4,1,wf12(:,14))
  call Hloop_AQ_V(ntryL,G0H144(1),wf12(:,14),G0H12(1),m3h12x12(:,9),heltab2x144(:,:,422))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(125)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(441),h0tab(:,441),[49,2,8,4],[0,nMT,nMB,nMT],4,1,wf8(:,26))
  call Hloop_AQ_V(ntryL,G0H144(1),wf8(:,26),G0H18(3),m3h8x18(:,27),heltab2x144(:,:,423))
  Gcoeff(:)%j = (-(c(59)*M(2,:)%j)) * den(119)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(442),h0tab(:,442),[35,8,4,16],[0,0,0,0],4,1,wf8(:,14))
  call Hloop_AV_Q(ntryL,G0H144(1),wf8(:,14),G0H18(4),m3h8x18(:,28),heltab2x144(:,:,424))
  call Hloop_A_Q(ntryL,G0H18(4),35,0,G1H18(2),n2h18(173))
  Gcoeff(:)%j = (-(c(57)*M(2,:)%j)) * den(119)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(443),h0tab(:,443),[35,8,4,16],[nMT,nMB,nMT,nMT],4,1,wf8(:,14))
  call Hloop_AV_Q(ntryL,G0H144(1),wf8(:,14),G0H18(4),m3h8x18(:,29),heltab2x144(:,:,425))
  call Hloop_A_Q(ntryL,G0H18(4),35,nMT,G1H18(3),n2h18(174))
  Gcoeff(:)%j = (-(c(59)*M(2,:)%j)) * den(119)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(444),h0tab(:,444),[35,8,4,16],[0,0,0,0],4,1,wf8(:,14))
  call Hloop_QV_A(ntryL,G0H144(1),wf8(:,14),G0H18(4),m3h8x18(:,30),heltab2x144(:,:,426))
  call Hloop_Q_A(ntryL,G0H18(4),35,0,G1H18(41),n2h18(175))
  Gcoeff(:)%j = (-(c(57)*M(2,:)%j)) * den(119)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(445),h0tab(:,445),[35,8,4,16],[nMB,nMT,nMB,nMB],4,1,wf8(:,14))
  call Hloop_QV_A(ntryL,G0H144(1),wf8(:,14),G0H18(4),m3h8x18(:,31),heltab2x144(:,:,427))
  call Hloop_Q_A(ntryL,G0H18(4),35,nMB,G1H18(44),n2h18(176))
  Gcoeff(:)%j = (-(c(59)*M(2,:)%j)) * den(119)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(446),h0tab(:,446),[35,4,8,16],[0,0,0,0],4,1,wf8(:,14))
  call Hloop_QV_A(ntryL,G0H144(1),wf8(:,14),G0H18(4),m3h8x18(:,32),heltab2x144(:,:,428))
  call Hloop_Q_A(ntryL,G0H18(4),35,0,G1H18(48),n2h18(177))
  Gcoeff(:)%j = (-(c(57)*M(2,:)%j)) * den(119)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(447),h0tab(:,447),[35,4,8,16],[nMT,nMB,nMT,nMT],4,1,wf8(:,14))
  call Hloop_QV_A(ntryL,G0H144(1),wf8(:,14),G0H18(4),m3h8x18(:,33),heltab2x144(:,:,429))
  call Hloop_Q_A(ntryL,G0H18(4),35,nMT,G1H18(60),n2h18(178))
  Gcoeff(:)%j = (-(c(59)*M(2,:)%j)) * den(119)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(448),h0tab(:,448),[35,4,8,16],[0,0,0,0],4,1,wf8(:,14))
  call Hloop_AV_Q(ntryL,G0H144(1),wf8(:,14),G0H18(4),m3h8x18(:,34),heltab2x144(:,:,430))
  call Hloop_A_Q(ntryL,G0H18(4),35,0,G1H18(61),n2h18(179))
  Gcoeff(:)%j = (-(c(57)*M(2,:)%j)) * den(119)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(449),h0tab(:,449),[35,4,8,16],[nMB,nMT,nMB,nMB],4,1,wf8(:,14))
  call Hloop_AV_Q(ntryL,G0H144(1),wf8(:,14),G0H18(4),m3h8x18(:,35),heltab2x144(:,:,431))
  call Hloop_A_Q(ntryL,G0H18(4),35,nMB,G1H18(66),n2h18(180))
  Gcoeff(:)%j = (-(c(59)*M(2,:)%j)) * den(119)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(450),h0tab(:,450),[35,4,16,8],[0,0,0,0],4,1,wf8(:,14))
  call Hloop_AV_Q(ntryL,G0H144(1),wf8(:,14),G0H18(4),m3h8x18(:,36),heltab2x144(:,:,432))
  call Hloop_A_Q(ntryL,G0H18(4),35,0,G1H18(72),n2h18(181))
  Gcoeff(:)%j = (-(c(57)*M(2,:)%j)) * den(119)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(451),h0tab(:,451),[35,4,16,8],[nMB,nMT,nMT,nMB],4,1,wf8(:,14))
  call Hloop_AV_Q(ntryL,G0H144(1),wf8(:,14),G0H18(4),m3h8x18(:,37),heltab2x144(:,:,433))
  call Hloop_A_Q(ntryL,G0H18(4),35,nMB,G1H18(73),n2h18(182))
  Gcoeff(:)%j = (-(c(59)*M(2,:)%j)) * den(119)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(452),h0tab(:,452),[35,4,16,8],[0,0,0,0],4,1,wf8(:,14))
  call Hloop_QV_A(ntryL,G0H144(1),wf8(:,14),G0H18(4),m3h8x18(:,38),heltab2x144(:,:,434))
  call Hloop_Q_A(ntryL,G0H18(4),35,0,G1H18(74),n2h18(183))
  Gcoeff(:)%j = (-(c(57)*M(2,:)%j)) * den(119)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(453),h0tab(:,453),[35,4,16,8],[nMT,nMB,nMB,nMT],4,1,wf8(:,14))
  call Hloop_QV_A(ntryL,G0H144(1),wf8(:,14),G0H18(4),m3h8x18(:,39),heltab2x144(:,:,435))
  call Hloop_Q_A(ntryL,G0H18(4),35,nMT,G1H18(75),n2h18(184))
  Gcoeff(:)%j = (c(17)*M(2,:)%j) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(454),h0tab(:,454),[42,4,1,16],[nMB,nMT,0,0],4,1,wf12(:,10))
  call Hloop_VA_Q(ntryL,G0H144(1),wf12(:,10),G0H12(4),m3h12x12(:,10),heltab2x144(:,:,436))
  call Hloop_A_Q(ntryL,G0H12(4),42,nMB,G1H12(82),n2h12(130))
  Gcoeff(:)%j = (-(c(19)*M(2,:)%j)) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(455),h0tab(:,455),[42,1,4,16],[0,nMT,nMB,nMB],4,1,wf12(:,10))
  call Hloop_QA_V(ntryL,G0H144(1),wf12(:,10),G0H12(7),m3h12x12(:,11),heltab2x144(:,:,437))
  Gcoeff(:)%j = (-(c(19)*M(2,:)%j)) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(456),h0tab(:,456),[42,1,16,4],[0,nMT,nMT,nMB],4,1,wf12(:,10))
  call Hloop_QA_V(ntryL,G0H144(1),wf12(:,10),G0H12(4),m3h12x12(:,12),heltab2x144(:,:,438))
  Gcoeff(:)%j = (c(21)*M(2,:)%j) * den(108)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(457),h0tab(:,457),[50,1,4,8],[0,nMT,nMB,nMT],4,1,wf8(:,20))
  call Hloop_QA_V(ntryL,G0H144(1),wf8(:,20),G0H18(4),m3h8x18(:,40),heltab2x144(:,:,439))
  Gcoeff(:)%j = (c(16)*(-M(1,:)%j+M(2,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(458),h0tab(:,458),[49,2,8,4],[0,nMT,nMB,nMT],4,1,wf8(:,8))
  call Hloop_AQ_V(ntryL,G0H144(1),wf8(:,8),G0H18(5),m3h8x18(:,41),heltab2x144(:,:,440))
  Gcoeff(:)%j = (c(16)*(-M(1,:)%j+M(2,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(459),h0tab(:,459),[50,1,4,8],[0,nMT,nMB,nMT],4,1,wf8(:,4))
  call Hloop_QA_V(ntryL,G0H144(1),wf8(:,4),G0H18(6),m3h8x18(:,42),heltab2x144(:,:,441))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(82),[G1H12(91),G1H12(72),G1H12(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H18(40),[G1H18(8),G1H18(68)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(64),[G1H12(80),G1H12(85),G1H12(41)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(95),[G1H12(50)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(65),[G1H12(61)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H18(60),[G1H18(47),G1H18(192),G1H18(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H18(75),[G1H18(37),G1H18(29),G1H18(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H18(3),[G1H18(38),G1H18(63),G1H18(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H18(2),[G1H18(35),G1H18(62),G1H18(83)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H18(41),[G1H18(39),G1H18(175),G1H18(89)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H18(44),[G1H18(12),G1H18(176),G1H18(95)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H18(48),[G1H18(18),G1H18(191),G1H18(119)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H18(61),[G1H18(55),G1H18(207),G1H18(125)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H18(66),[G1H18(7),G1H18(208),G1H18(131)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H18(74),[G1H18(31),G1H18(28),G1H18(155)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H18(72),[G1H18(25),G1H18(223),G1H18(161)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H18(73),[G1H18(30),G1H18(224),G1H18(167)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H36(40),[G1H36(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H36(13),[G1H36(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H36(14),[G1H36(50)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H36(52),[G1H36(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H36(53),[G1H36(65)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H36(54),[G1H36(71)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H36(48),[G1H36(95)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H36(49),[G1H36(101)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H36(51),[G1H36(107)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H36(26),[G1H36(113)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H36(28),[G1H36(118)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H36(43),[G0H36(2),G0H36(3),G0H36(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H36(46),[G0H36(5),G0H36(4),G0H36(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H36(24),[G0H36(8),G0H36(7),G0H36(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H36(25),[G0H36(12),G0H36(11),G0H36(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H36(8),[G0H36(15),G0H36(14),G0H36(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H72(9),[G1H72(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H72(11),[G1H72(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H72(29),[G1H72(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H72(31),[G1H72(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H72(49),[G1H72(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H72(51),[G1H72(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H12(8),[G0H12(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H12(1),[G0H12(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H12(7),[G0H12(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H12(4),[G0H12(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H18(5),[G0H18(3),G0H18(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H18(6),[G0H18(4),G0H18(2)])
  call Hloop_AW_Q(ntryL,G1H12(11),ex3(:),G1H4(54),m3h3x4(:,91),heltab2x12(:,:,234))
  call Hloop_A_Q(ntryL,G1H4(54),60,nMT,G2H4(50),n2h4(139))
  call Hloop_QW_A(ntryL,G1H12(19),ex4(:),G1H4(55),m3h3x4(:,92),heltab2x12(:,:,235))
  call Hloop_Q_A(ntryL,G1H4(55),60,nMT,G2H4(66),n2h4(140))
  call Hloop_AV_Q(ntryL,G1H8(3),ex5(:),G1H4(9),m3h2x4(:,46),heltab2x8(:,:,102))
  call Hloop_A_Q(ntryL,G1H4(9),60,nMT,G2H4(54),n2h4(141))
  call Hloop_AW_Q(ntryL,G1H18(58),ex4(:),G1H6(472),m3h3x6(:,142),heltab2x18(:,:,319))
  call Hloop_A_Q(ntryL,G1H6(472),58,nMB,G2H6(186),n2h6(366))
  call Hloop_AW_Q(ntryL,G1H12(82),ex3(:),G1H4(10),m3h3x4(:,93),heltab2x12(:,:,236))
  call Hloop_A_Q(ntryL,G1H4(10),46,nMT,G2H4(35),n2h4(142))
  call Hloop_QW_A(ntryL,G1H18(40),ex3(:),G1H6(473),m3h3x6(:,143),heltab2x18(:,:,320))
  call Hloop_Q_A(ntryL,G1H6(473),53,nMB,G2H6(188),n2h6(367))
  call Hloop_QW_A(ntryL,G1H12(64),ex4(:),G1H4(57),m3h3x4(:,94),heltab2x12(:,:,237))
  call Hloop_Q_A(ntryL,G1H4(57),45,nMT,G2H4(37),n2h4(143))
  call Hloop_QV_A(ntryL,G1H12(95),ex5(:),G1H6(488),m3h2x6(:,88),heltab2x12(:,:,238))
  call Hloop_Q_A(ntryL,G1H6(488),53,nMB,G2H6(189),n2h6(368))
  call Hloop_QW_A(ntryL,G1H12(65),ex4(:),G1H4(58),m3h3x4(:,95),heltab2x12(:,:,239))
  call Hloop_Q_A(ntryL,G1H4(58),45,nMT,G2H4(38),n2h4(144))
  call Hloop_QW_A(ntryL,G1H18(60),ex3(:),G1H6(489),m3h3x6(:,144),heltab2x18(:,:,321))
  call Hloop_Q_A(ntryL,G1H6(489),39,nMB,G2H6(193),n2h6(369))
  call Hloop_QW_A(ntryL,G1H18(75),ex3(:),G1H6(504),m3h3x6(:,145),heltab2x18(:,:,322))
  call Hloop_Q_A(ntryL,G1H6(504),39,nMB,G2H6(194),n2h6(370))
  call Hloop_QV_A(ntryL,G1H18(34),ex5(:),G1H9(66),m3h2x9(:,121),heltab2x18(:,:,323))
  call Hloop_Q_A(ntryL,G1H9(66),51,nMT,G2H9(59),n2h9(133))
  call Hloop_AW_Q(ntryL,G1H18(3),ex4(:),G1H6(505),m3h3x6(:,146),heltab2x18(:,:,324))
  call Hloop_A_Q(ntryL,G1H6(505),43,nMB,G2H6(196),n2h6(371))
  call Hloop_AW_Q(ntryL,G1H18(13),ex4(:),G1H6(520),m3h3x6(:,147),heltab2x18(:,:,325))
  call Hloop_A_Q(ntryL,G1H6(520),43,nMB,G2H6(197),n2h6(372))
  call Hloop_AV_Q(ntryL,G1H18(36),ex5(:),G1H9(37),m3h2x9(:,122),heltab2x18(:,:,326))
  call Hloop_A_Q(ntryL,G1H9(37),51,nMT,G2H9(23),n2h9(134))
  call Hloop_QV_A(ntryL,G1H18(49),ex5(:),G1H9(103),m3h2x9(:,123),heltab2x18(:,:,327))
  call Hloop_Q_A(ntryL,G1H9(103),51,0,G2H9(6),n2h9(135))
  call Hloop_AV_Q(ntryL,G1H18(71),ex5(:),G1H9(184),m3h2x9(:,124),heltab2x18(:,:,328))
  call Hloop_A_Q(ntryL,G1H9(184),51,0,G2H9(8),n2h9(136))
  call Hloop_AV_Q(ntryL,G1H18(77),ex5(:),G1H9(9),m3h2x9(:,125),heltab2x18(:,:,329))
  call Hloop_A_Q(ntryL,G1H9(9),51,nMB,G2H9(11),n2h9(137))
  call Hloop_AW_Q(ntryL,G1H18(2),ex4(:),G1H6(521),m3h3x6(:,148),heltab2x18(:,:,330))
  call Hloop_A_Q(ntryL,G1H6(521),43,0,G2H6(198),n2h6(373))
  call Hloop_QW_A(ntryL,G1H18(41),ex4(:),G1H6(536),m3h3x6(:,149),heltab2x18(:,:,331))
  call Hloop_Q_A(ntryL,G1H6(536),43,0,G2H6(200),n2h6(374))
  call Hloop_QW_A(ntryL,G1H18(44),ex4(:),G1H6(537),m3h3x6(:,150),heltab2x18(:,:,332))
  call Hloop_Q_A(ntryL,G1H6(537),43,nMT,G2H6(201),n2h6(375))
  call Hloop_AV_Q(ntryL,G1H18(101),ex5(:),G1H9(93),m3h2x9(:,126),heltab2x18(:,:,333))
  call Hloop_A_Q(ntryL,G1H9(93),51,0,G2H9(21),n2h9(138))
  call Hloop_QV_A(ntryL,G1H18(107),ex5(:),G1H9(115),m3h2x9(:,127),heltab2x18(:,:,334))
  call Hloop_Q_A(ntryL,G1H9(115),51,0,G2H9(27),n2h9(139))
  call Hloop_QV_A(ntryL,G1H18(113),ex5(:),G1H9(142),m3h2x9(:,128),heltab2x18(:,:,335))
  call Hloop_Q_A(ntryL,G1H9(142),51,nMB,G2H9(29),n2h9(140))
  call Hloop_QW_A(ntryL,G1H24(1),ex4(:),G1H8(6),m3h3x8(:,60),heltab2x24(:,:,165))
  call Hloop_Q_A(ntryL,G1H8(6),44,0,G2H8(41),n2h8(82))
  call Hloop_QW_A(ntryL,G1H24(8),ex4(:),G1H8(7),m3h3x8(:,61),heltab2x24(:,:,166))
  call Hloop_Q_A(ntryL,G1H8(7),44,nMT,G2H8(43),n2h8(83))
  call Hloop_AW_Q(ntryL,G1H24(16),ex4(:),G1H8(22),m3h3x8(:,62),heltab2x24(:,:,167))
  call Hloop_A_Q(ntryL,G1H8(22),44,0,G2H8(44),n2h8(84))
  call Hloop_AW_Q(ntryL,G1H24(21),ex4(:),G1H8(23),m3h3x8(:,63),heltab2x24(:,:,168))
  call Hloop_A_Q(ntryL,G1H8(23),44,nMB,G2H8(45),n2h8(85))
  call Hloop_QW_A(ntryL,G1H18(48),ex3(:),G1H6(552),m3h3x6(:,151),heltab2x18(:,:,336))
  call Hloop_Q_A(ntryL,G1H6(552),39,0,G2H6(202),n2h6(376))
  call Hloop_AW_Q(ntryL,G1H18(61),ex3(:),G1H6(553),m3h3x6(:,152),heltab2x18(:,:,337))
  call Hloop_A_Q(ntryL,G1H6(553),39,0,G2H6(204),n2h6(377))
  call Hloop_AW_Q(ntryL,G1H18(66),ex3(:),G1H6(568),m3h3x6(:,153),heltab2x18(:,:,338))
  call Hloop_A_Q(ntryL,G1H6(568),39,nMT,G2H6(205),n2h6(378))
  call Hloop_AW_Q(ntryL,G1H24(27),ex3(:),G1H8(38),m3h3x8(:,64),heltab2x24(:,:,169))
  call Hloop_A_Q(ntryL,G1H8(38),44,0,G2H8(47),n2h8(86))
  call Hloop_AW_Q(ntryL,G1H24(33),ex3(:),G1H8(39),m3h3x8(:,65),heltab2x24(:,:,170))
  call Hloop_A_Q(ntryL,G1H8(39),44,nMT,G2H8(48),n2h8(87))
  call Hloop_QW_A(ntryL,G1H24(39),ex3(:),G1H8(54),m3h3x8(:,66),heltab2x24(:,:,171))
  call Hloop_Q_A(ntryL,G1H8(54),44,0,G2H8(8),n2h8(88))
  call Hloop_QW_A(ntryL,G1H24(45),ex3(:),G1H8(55),m3h3x8(:,67),heltab2x24(:,:,172))
  call Hloop_Q_A(ntryL,G1H8(55),44,nMB,G2H8(5),n2h8(89))
  call Hloop_AW_Q(ntryL,G1H18(137),ex4(:),G1H6(569),m3h3x6(:,154),heltab2x18(:,:,339))
  call Hloop_A_Q(ntryL,G1H6(569),43,0,G2H6(206),n2h6(379))
  call Hloop_QW_A(ntryL,G1H18(143),ex4(:),G1H6(584),m3h3x6(:,155),heltab2x18(:,:,340))
  call Hloop_Q_A(ntryL,G1H6(584),43,0,G2H6(208),n2h6(380))
  call Hloop_QW_A(ntryL,G1H18(149),ex4(:),G1H6(585),m3h3x6(:,156),heltab2x18(:,:,341))
  call Hloop_Q_A(ntryL,G1H6(585),43,nMT,G2H6(209),n2h6(381))
  call Hloop_AV_Q(ntryL,G1H24(51),ex5(:),G1H12(21),m3h2x12(:,52),heltab2x24(:,:,173))
  call Hloop_A_Q(ntryL,G1H12(21),52,0,G2H12(37),n2h12(131))
  call Hloop_AV_Q(ntryL,G1H24(57),ex5(:),G1H12(66),m3h2x12(:,53),heltab2x24(:,:,174))
  call Hloop_A_Q(ntryL,G1H12(66),52,nMT,G2H12(39),n2h12(132))
  call Hloop_QV_A(ntryL,G1H24(63),ex5(:),G1H12(93),m3h2x12(:,54),heltab2x24(:,:,175))
  call Hloop_Q_A(ntryL,G1H12(93),52,0,G2H12(40),n2h12(133))
  call Hloop_QV_A(ntryL,G1H24(69),ex5(:),G1H12(94),m3h2x12(:,55),heltab2x24(:,:,176))
  call Hloop_Q_A(ntryL,G1H12(94),52,nMB,G2H12(41),n2h12(134))
  call Hloop_QW_A(ntryL,G1H18(74),ex3(:),G1H6(605),m3h3x6(:,157),heltab2x18(:,:,342))
  call Hloop_Q_A(ntryL,G1H6(605),39,0,G2H6(210),n2h6(382))
  call Hloop_AW_Q(ntryL,G1H18(72),ex3(:),G1H6(606),m3h3x6(:,158),heltab2x18(:,:,343))
  call Hloop_A_Q(ntryL,G1H6(606),39,0,G2H6(212),n2h6(383))
  call Hloop_AW_Q(ntryL,G1H18(73),ex3(:),G1H6(626),m3h3x6(:,159),heltab2x18(:,:,344))
  call Hloop_A_Q(ntryL,G1H6(626),39,nMT,G2H6(213),n2h6(384))
  call Hloop_AV_Q(ntryL,G1H24(75),wf4(:,10),G1H6(627),m3h4x6(:,52),heltab2x24(:,:,177))
  call Hloop_A_Q(ntryL,G1H6(627),43,0,G2H6(217),n2h6(385))
  call Hloop_AV_Q(ntryL,G1H24(81),wf4(:,10),G1H6(642),m3h4x6(:,53),heltab2x24(:,:,178))
  call Hloop_A_Q(ntryL,G1H6(642),43,nMB,G2H6(59),n2h6(386))
  call Hloop_QV_A(ntryL,G1H24(87),wf4(:,10),G1H6(643),m3h4x6(:,54),heltab2x24(:,:,179))
  call Hloop_Q_A(ntryL,G1H6(643),43,0,G2H6(10),n2h6(387))
  call Hloop_QV_A(ntryL,G1H24(93),wf4(:,10),G1H6(658),m3h4x6(:,55),heltab2x24(:,:,180))
  call Hloop_Q_A(ntryL,G1H6(658),43,nMT,G2H6(13),n2h6(388))
  call Hloop_AV_Q(ntryL,G1H24(99),wf4(:,10),G1H6(659),m3h4x6(:,56),heltab2x24(:,:,181))
  call Hloop_A_Q(ntryL,G1H6(659),39,0,G2H6(16),n2h6(389))
  call Hloop_AV_Q(ntryL,G1H24(105),wf4(:,10),G1H6(674),m3h4x6(:,57),heltab2x24(:,:,182))
  call Hloop_A_Q(ntryL,G1H6(674),39,nMT,G2H6(49),n2h6(390))
  call Hloop_QV_A(ntryL,G1H24(111),wf4(:,10),G1H6(675),m3h4x6(:,58),heltab2x24(:,:,183))
  call Hloop_Q_A(ntryL,G1H6(675),39,0,G2H6(20),n2h6(391))
  call Hloop_QV_A(ntryL,G1H24(117),wf4(:,10),G1H6(690),m3h4x6(:,59),heltab2x24(:,:,184))
  call Hloop_Q_A(ntryL,G1H6(690),39,nMB,G2H6(24),n2h6(392))
  call Hloop_QV_A(ntryL,G1H24(123),wf4(:,10),G1H6(691),m3h4x6(:,60),heltab2x24(:,:,185))
  call Hloop_Q_A(ntryL,G1H6(691),39,0,G2H6(55),n2h6(393))
  call Hloop_QV_A(ntryL,G1H24(129),wf4(:,10),G1H6(49),m3h4x6(:,61),heltab2x24(:,:,186))
  call Hloop_Q_A(ntryL,G1H6(49),39,nMB,G2H6(28),n2h6(394))
  call Hloop_AV_Q(ntryL,G1H24(135),wf4(:,10),G1H6(54),m3h4x6(:,62),heltab2x24(:,:,187))
  call Hloop_A_Q(ntryL,G1H6(54),39,0,G2H6(3),n2h6(395))
  call Hloop_AV_Q(ntryL,G1H24(141),wf4(:,10),G1H6(62),m3h4x6(:,63),heltab2x24(:,:,188))
  call Hloop_A_Q(ntryL,G1H6(62),39,nMT,G2H6(11),n2h6(396))
  call Hloop_AW_Q(ntryL,G1H36(4),ex4(:),G1H12(103),m3h3x12(:,46),heltab2x36(:,:,175))
  call Hloop_A_Q(ntryL,G1H12(103),42,nMB,G2H12(43),n2h12(135))
  call Hloop_AW_Q(ntryL,G1H36(40),ex4(:),G1H12(104),m3h3x12(:,47),heltab2x36(:,:,176))
  call Hloop_A_Q(ntryL,G1H12(104),42,nMB,G2H12(44),n2h12(136))
  call Hloop_AV_Q(ntryL,G1H36(41),ex5(:),G1H18(79),m3h2x18(:,82),heltab2x36(:,:,177))
  call Hloop_A_Q(ntryL,G1H18(79),50,nMT,G2H18(28),n2h18(185))
  call Hloop_QW_A(ntryL,G1H36(13),ex3(:),G1H12(119),m3h3x12(:,48),heltab2x36(:,:,178))
  call Hloop_Q_A(ntryL,G1H12(119),37,nMB,G2H12(45),n2h12(137))
  call Hloop_QW_A(ntryL,G1H36(14),ex3(:),G1H12(120),m3h3x12(:,49),heltab2x36(:,:,179))
  call Hloop_Q_A(ntryL,G1H12(120),37,nMB,G2H12(47),n2h12(138))
  call Hloop_QV_A(ntryL,G1H36(56),ex5(:),G1H18(80),m3h2x18(:,83),heltab2x36(:,:,180))
  call Hloop_Q_A(ntryL,G1H18(80),49,nMT,G2H18(18),n2h18(186))
  call Hloop_AV_Q(ntryL,G1H24(147),ex5(:),G1H12(135),m3h2x12(:,56),heltab2x24(:,:,189))
  call Hloop_A_Q(ntryL,G1H12(135),52,nMT,G2H12(48),n2h12(139))
  call Hloop_QV_A(ntryL,G1H36(23),ex5(:),G1H18(81),m3h2x18(:,84),heltab2x36(:,:,181))
  call Hloop_Q_A(ntryL,G1H18(81),49,nMT,G2H18(20),n2h18(187))
  call Hloop_QV_A(ntryL,G1H36(29),ex5(:),G1H18(82),m3h2x18(:,85),heltab2x36(:,:,182))
  call Hloop_Q_A(ntryL,G1H18(82),49,nMT,G2H18(22),n2h18(188))
  call Hloop_QV_A(ntryL,G1H36(16),ex5(:),G1H18(86),m3h2x18(:,86),heltab2x36(:,:,183))
  call Hloop_Q_A(ntryL,G1H18(86),49,nMT,G2H18(25),n2h18(189))
  call Hloop_AS_Q(ntryL,G1H36(52),wf9(:,1),G1H4(59),ngH,m3h9x4(:,37),heltab2x36(:,:,184))
  call Hloop_A_Q(ntryL,G1H4(59),46,nMT,G2H4(39),n2h4(145))
  call Hloop_AV_Q(ntryL,G1H36(53),wf9(:,2),G1H4(60),m3h9x4(:,38),heltab2x36(:,:,185))
  call Hloop_A_Q(ntryL,G1H4(60),46,nMT,G2H4(41),n2h4(146))
  call Hloop_AZ_Q(ntryL,G1H36(54),wf9(:,3),G1H4(63),ngZu,m3h9x4(:,39),heltab2x36(:,:,186))
  call Hloop_A_Q(ntryL,G1H4(63),46,nMT,G2H4(42),n2h4(147))
  call Hloop_QS_A(ntryL,G1H36(77),wf9(:,1),G1H4(64),ngH,m3h9x4(:,40),heltab2x36(:,:,187))
  call Hloop_Q_A(ntryL,G1H4(64),45,nMT,G2H4(43),n2h4(148))
  call Hloop_QV_A(ntryL,G1H36(83),wf9(:,2),G1H4(21),m3h9x4(:,41),heltab2x36(:,:,188))
  call Hloop_Q_A(ntryL,G1H4(21),45,nMT,G2H4(46),n2h4(149))
  call Hloop_QZ_A(ntryL,G1H36(89),wf9(:,3),G1H4(22),ngZu,m3h9x4(:,42),heltab2x36(:,:,189))
  call Hloop_Q_A(ntryL,G1H4(22),45,nMT,G2H4(47),n2h4(150))
  call Hloop_QS_A(ntryL,G1H36(48),wf9(:,1),G1H4(74),ngH,m3h9x4(:,43),heltab2x36(:,:,190))
  call Hloop_Q_A(ntryL,G1H4(74),45,nMT,G2H4(48),n2h4(151))
  call Hloop_QV_A(ntryL,G1H36(49),wf9(:,2),G1H4(86),m3h9x4(:,44),heltab2x36(:,:,191))
  call Hloop_Q_A(ntryL,G1H4(86),45,nMT,G2H4(51),n2h4(152))
  call Hloop_QZ_A(ntryL,G1H36(51),wf9(:,3),G1H4(68),ngZu,m3h9x4(:,45),heltab2x36(:,:,192))
  call Hloop_Q_A(ntryL,G1H4(68),45,nMT,G2H4(52),n2h4(153))
  call Hloop_AW_Q(ntryL,G1H36(26),ex4(:),G1H12(136),m3h3x12(:,50),heltab2x36(:,:,193))
  call Hloop_A_Q(ntryL,G1H12(136),42,nMB,G2H12(49),n2h12(140))
  call Hloop_QW_A(ntryL,G1H24(153),ex4(:),G1H8(70),m3h3x8(:,68),heltab2x24(:,:,190))
  call Hloop_Q_A(ntryL,G1H8(70),44,nMT,G2H8(4),n2h8(90))
  call Hloop_QW_A(ntryL,G1H36(28),ex3(:),G1H12(151),m3h3x12(:,51),heltab2x36(:,:,194))
  call Hloop_Q_A(ntryL,G1H12(151),37,nMB,G2H12(51),n2h12(141))
  call Hloop_AW_Q(ntryL,G1H24(159),ex3(:),G1H8(71),m3h3x8(:,69),heltab2x24(:,:,191))
  call Hloop_A_Q(ntryL,G1H8(71),44,nMT,G2H8(6),n2h8(91))
  call Hloop_VA_Q(ntryL,G1H36(43),ex2(:),G1H18(87),m3h2x18(:,87),heltab2x36(:,:,195))
  call Hloop_A_Q(ntryL,G1H18(87),50,nMT,G2H18(30),n2h18(190))
  call Hloop_VQ_A(ntryL,G1H36(46),ex1(:),G1H18(88),m3h2x18(:,88),heltab2x36(:,:,196))
  call Hloop_Q_A(ntryL,G1H18(88),49,nMT,G2H18(31),n2h18(191))
  call Hloop_VQ_A(ntryL,G1H36(24),ex1(:),G1H18(90),m3h2x18(:,89),heltab2x36(:,:,197))
  call Hloop_Q_A(ntryL,G1H18(90),49,nMT,G2H18(33),n2h18(192))
  call Hloop_VQ_A(ntryL,G1H36(25),ex1(:),G1H18(93),m3h2x18(:,90),heltab2x36(:,:,198))
  call Hloop_Q_A(ntryL,G1H18(93),49,nMT,G2H18(34),n2h18(193))
  call Hloop_VQ_A(ntryL,G1H36(8),ex1(:),G1H18(94),m3h2x18(:,91),heltab2x36(:,:,199))
  call Hloop_Q_A(ntryL,G1H18(94),49,nMT,G2H18(35),n2h18(194))
  call Hloop_AS_Q(ntryL,G1H72(1),wf9(:,1),G1H8(86),ngH,m3h9x8(:,7),heltab2x72(:,:,137))
  call Hloop_A_Q(ntryL,G1H8(86),44,nMT,G2H8(7),n2h8(92))
  call Hloop_QS_A(ntryL,G1H72(2),wf9(:,1),G1H8(87),ngH,m3h9x8(:,8),heltab2x72(:,:,138))
  call Hloop_Q_A(ntryL,G1H8(87),44,nMT,G2H8(9),n2h8(93))
  call Hloop_AS_Q(ntryL,G1H72(3),wf9(:,1),G1H8(102),ngH,m3h9x8(:,9),heltab2x72(:,:,139))
  call Hloop_A_Q(ntryL,G1H8(102),44,nMB,G2H8(1),n2h8(94))
  call Hloop_QS_A(ntryL,G1H72(4),wf9(:,1),G1H8(103),ngH,m3h9x8(:,10),heltab2x72(:,:,140))
  call Hloop_Q_A(ntryL,G1H8(103),44,nMB,G2H8(10),n2h8(95))
  call Hloop_AV_Q(ntryL,G1H72(9),wf9(:,2),G1H8(118),m3h9x8(:,11),heltab2x72(:,:,141))
  call Hloop_A_Q(ntryL,G1H8(118),44,0,G2H8(12),n2h8(96))
  call Hloop_AV_Q(ntryL,G1H72(6),wf9(:,2),G1H8(119),m3h9x8(:,12),heltab2x72(:,:,142))
  call Hloop_A_Q(ntryL,G1H8(119),44,nMT,G2H8(13),n2h8(97))
  call Hloop_QV_A(ntryL,G1H72(11),wf9(:,2),G1H8(1),m3h9x8(:,13),heltab2x72(:,:,143))
  call Hloop_Q_A(ntryL,G1H8(1),44,0,G2H8(15),n2h8(98))
  call Hloop_QV_A(ntryL,G1H72(8),wf9(:,2),G1H8(2),m3h9x8(:,14),heltab2x72(:,:,144))
  call Hloop_Q_A(ntryL,G1H8(2),44,nMT,G2H8(16),n2h8(99))
  call Hloop_AV_Q(ntryL,G1H72(10),wf9(:,2),G1H8(8),m3h9x8(:,15),heltab2x72(:,:,145))
  call Hloop_A_Q(ntryL,G1H8(8),44,nMB,G2H8(17),n2h8(100))
  call Hloop_QV_A(ntryL,G1H72(12),wf9(:,2),G1H8(13),m3h9x8(:,16),heltab2x72(:,:,146))
  call Hloop_Q_A(ntryL,G1H8(13),44,nMB,G2H8(19),n2h8(101))
  call Hloop_AZ_Q(ntryL,G1H72(13),wf9(:,3),G1H8(9),ngZu,m3h9x8(:,17),heltab2x72(:,:,147))
  call Hloop_A_Q(ntryL,G1H8(9),44,0,G2H8(20),n2h8(102))
  call Hloop_AZ_Q(ntryL,G1H72(14),wf9(:,3),G1H8(12),ngZu,m3h9x8(:,18),heltab2x72(:,:,148))
  call Hloop_A_Q(ntryL,G1H8(12),44,nMT,G2H8(21),n2h8(103))
  call Hloop_QZ_A(ntryL,G1H72(15),wf9(:,3),G1H8(14),ngZu,m3h9x8(:,19),heltab2x72(:,:,149))
  call Hloop_Q_A(ntryL,G1H8(14),44,0,G2H8(23),n2h8(104))
  call Hloop_QZ_A(ntryL,G1H72(16),wf9(:,3),G1H8(17),ngZu,m3h9x8(:,20),heltab2x72(:,:,150))
  call Hloop_Q_A(ntryL,G1H8(17),44,nMT,G2H8(24),n2h8(105))
  call Hloop_AZ_Q(ntryL,G1H72(17),wf9(:,3),G1H8(18),ngZd,m3h9x8(:,21),heltab2x72(:,:,151))
  call Hloop_A_Q(ntryL,G1H8(18),44,0,G2H8(25),n2h8(106))
  call Hloop_AZ_Q(ntryL,G1H72(18),wf9(:,3),G1H8(19),ngZd,m3h9x8(:,22),heltab2x72(:,:,152))
  call Hloop_A_Q(ntryL,G1H8(19),44,nMB,G2H8(27),n2h8(107))
  call Hloop_QZ_A(ntryL,G1H72(19),wf9(:,3),G1H8(24),ngZd,m3h9x8(:,23),heltab2x72(:,:,153))
  call Hloop_Q_A(ntryL,G1H8(24),44,0,G2H8(28),n2h8(108))
  call Hloop_QZ_A(ntryL,G1H72(20),wf9(:,3),G1H8(29),ngZd,m3h9x8(:,24),heltab2x72(:,:,154))
  call Hloop_Q_A(ntryL,G1H8(29),44,nMB,G2H8(29),n2h8(109))
  call Hloop_AV_Q(ntryL,G1H72(21),wf4(:,10),G1H18(96),m3h4x18(:,25),heltab2x72(:,:,155))
  call Hloop_A_Q(ntryL,G1H18(96),35,nMT,G2H18(37),n2h18(195))
  call Hloop_QV_A(ntryL,G1H72(22),wf4(:,10),G1H18(97),m3h4x18(:,26),heltab2x72(:,:,156))
  call Hloop_Q_A(ntryL,G1H18(97),35,nMT,G2H18(38),n2h18(196))
  call Hloop_AV_Q(ntryL,G1H72(23),wf4(:,10),G1H18(100),m3h4x18(:,27),heltab2x72(:,:,157))
  call Hloop_A_Q(ntryL,G1H18(100),35,nMB,G2H18(39),n2h18(197))
  call Hloop_QV_A(ntryL,G1H72(24),wf4(:,10),G1H18(102),m3h4x18(:,28),heltab2x72(:,:,158))
  call Hloop_Q_A(ntryL,G1H18(102),35,nMB,G2H18(41),n2h18(198))
  call Hloop_AV_Q(ntryL,G1H72(29),wf4(:,10),G1H18(103),m3h4x18(:,29),heltab2x72(:,:,159))
  call Hloop_A_Q(ntryL,G1H18(103),35,0,G2H18(42),n2h18(199))
  call Hloop_AV_Q(ntryL,G1H72(26),wf4(:,10),G1H18(104),m3h4x18(:,30),heltab2x72(:,:,160))
  call Hloop_A_Q(ntryL,G1H18(104),35,nMT,G2H18(13),n2h18(200))
  call Hloop_QV_A(ntryL,G1H72(31),wf4(:,10),G1H18(108),m3h4x18(:,31),heltab2x72(:,:,161))
  call Hloop_Q_A(ntryL,G1H18(108),35,0,G2H18(9),n2h18(201))
  call Hloop_QV_A(ntryL,G1H72(28),wf4(:,10),G1H18(109),m3h4x18(:,32),heltab2x72(:,:,162))
  call Hloop_Q_A(ntryL,G1H18(109),35,nMT,G2H18(10),n2h18(202))
  call Hloop_AV_Q(ntryL,G1H72(30),wf4(:,10),G1H18(110),m3h4x18(:,33),heltab2x72(:,:,163))
  call Hloop_A_Q(ntryL,G1H18(110),35,nMB,G2H18(12),n2h18(203))
  call Hloop_QV_A(ntryL,G1H72(32),wf4(:,10),G1H18(111),m3h4x18(:,34),heltab2x72(:,:,164))
  call Hloop_Q_A(ntryL,G1H18(111),35,nMB,G2H18(19),n2h18(204))
  call Hloop_AV_Q(ntryL,G1H72(33),wf4(:,10),G1H18(115),m3h4x18(:,35),heltab2x72(:,:,165))
  call Hloop_A_Q(ntryL,G1H18(115),35,0,G2H18(27),n2h18(205))
  call Hloop_AV_Q(ntryL,G1H72(34),wf4(:,10),G1H18(116),m3h4x18(:,36),heltab2x72(:,:,166))
  call Hloop_A_Q(ntryL,G1H18(116),35,nMT,G2H18(1),n2h18(206))
  call Hloop_QV_A(ntryL,G1H72(35),wf4(:,10),G1H18(117),m3h4x18(:,37),heltab2x72(:,:,167))
  call Hloop_Q_A(ntryL,G1H18(117),35,0,G2H18(5),n2h18(207))
  call Hloop_QV_A(ntryL,G1H72(36),wf4(:,10),G1H18(118),m3h4x18(:,38),heltab2x72(:,:,168))
  call Hloop_Q_A(ntryL,G1H18(118),35,nMT,G2H18(23),n2h18(208))
  call Hloop_AV_Q(ntryL,G1H72(37),wf4(:,10),G1H18(122),m3h4x18(:,39),heltab2x72(:,:,169))
  call Hloop_A_Q(ntryL,G1H18(122),35,0,G2H18(15),n2h18(209))
  call Hloop_AV_Q(ntryL,G1H72(38),wf4(:,10),G1H18(123),m3h4x18(:,40),heltab2x72(:,:,170))
  call Hloop_A_Q(ntryL,G1H18(123),35,nMB,G2H18(11),n2h18(210))
  call Hloop_QV_A(ntryL,G1H72(39),wf4(:,10),G1H18(124),m3h4x18(:,41),heltab2x72(:,:,171))
  call Hloop_Q_A(ntryL,G1H18(124),35,0,G2H18(14),n2h18(211))
  call Hloop_QV_A(ntryL,G1H72(40),wf4(:,10),G1H18(126),m3h4x18(:,42),heltab2x72(:,:,172))
  call Hloop_Q_A(ntryL,G1H18(126),35,nMB,G2H18(2),n2h18(212))
  call Hloop_QV_A(ntryL,G1H72(41),wf4(:,10),G1H18(129),m3h4x18(:,43),heltab2x72(:,:,173))
  call Hloop_Q_A(ntryL,G1H18(129),35,nMT,G2H18(3),n2h18(213))
  call Hloop_AV_Q(ntryL,G1H72(42),wf4(:,10),G1H18(130),m3h4x18(:,44),heltab2x72(:,:,174))
  call Hloop_A_Q(ntryL,G1H18(130),35,nMT,G2H18(4),n2h18(214))
  call Hloop_QV_A(ntryL,G1H72(43),wf4(:,10),G1H18(132),m3h4x18(:,45),heltab2x72(:,:,175))
  call Hloop_Q_A(ntryL,G1H18(132),35,nMB,G2H18(6),n2h18(215))
  call Hloop_AV_Q(ntryL,G1H72(44),wf4(:,10),G1H18(133),m3h4x18(:,46),heltab2x72(:,:,176))
  call Hloop_A_Q(ntryL,G1H18(133),35,nMB,G2H18(7),n2h18(216))
  call Hloop_QV_A(ntryL,G1H72(49),wf4(:,10),G1H18(136),m3h4x18(:,47),heltab2x72(:,:,177))
  call Hloop_Q_A(ntryL,G1H18(136),35,0,G2H18(8),n2h18(217))
  call Hloop_QV_A(ntryL,G1H72(46),wf4(:,10),G1H18(138),m3h4x18(:,48),heltab2x72(:,:,178))
  call Hloop_Q_A(ntryL,G1H18(138),35,nMT,G2H18(16),n2h18(218))
  call Hloop_AV_Q(ntryL,G1H72(51),wf4(:,10),G1H18(139),m3h4x18(:,49),heltab2x72(:,:,179))
  call Hloop_A_Q(ntryL,G1H18(139),35,0,G2H18(17),n2h18(219))
  call Hloop_AV_Q(ntryL,G1H72(48),wf4(:,10),G1H18(140),m3h4x18(:,50),heltab2x72(:,:,180))
  call Hloop_A_Q(ntryL,G1H18(140),35,nMT,G2H18(49),n2h18(220))
  call Hloop_QV_A(ntryL,G1H72(50),wf4(:,10),G1H18(144),m3h4x18(:,51),heltab2x72(:,:,181))
  call Hloop_Q_A(ntryL,G1H18(144),35,nMB,G2H18(50),n2h18(221))
  call Hloop_AV_Q(ntryL,G1H72(52),wf4(:,10),G1H18(145),m3h4x18(:,52),heltab2x72(:,:,182))
  call Hloop_A_Q(ntryL,G1H18(145),35,nMB,G2H18(51),n2h18(222))
  call Hloop_QV_A(ntryL,G1H72(53),wf4(:,10),G1H18(146),m3h4x18(:,53),heltab2x72(:,:,183))
  call Hloop_Q_A(ntryL,G1H18(146),35,0,G2H18(52),n2h18(223))
  call Hloop_QV_A(ntryL,G1H72(54),wf4(:,10),G1H18(147),m3h4x18(:,54),heltab2x72(:,:,184))
  call Hloop_Q_A(ntryL,G1H18(147),35,nMT,G2H18(53),n2h18(224))
  call Hloop_AV_Q(ntryL,G1H72(55),wf4(:,10),G1H18(151),m3h4x18(:,55),heltab2x72(:,:,185))
  call Hloop_A_Q(ntryL,G1H18(151),35,0,G2H18(54),n2h18(225))
  call Hloop_AV_Q(ntryL,G1H72(56),wf4(:,10),G1H18(152),m3h4x18(:,56),heltab2x72(:,:,186))
  call Hloop_A_Q(ntryL,G1H18(152),35,nMT,G2H18(55),n2h18(226))
  call Hloop_QV_A(ntryL,G1H72(57),wf4(:,10),G1H18(153),m3h4x18(:,57),heltab2x72(:,:,187))
  call Hloop_Q_A(ntryL,G1H18(153),35,0,G2H18(56),n2h18(227))
  call Hloop_QV_A(ntryL,G1H72(58),wf4(:,10),G1H18(154),m3h4x18(:,58),heltab2x72(:,:,188))
  call Hloop_Q_A(ntryL,G1H18(154),35,nMB,G2H18(57),n2h18(228))
  call Hloop_AV_Q(ntryL,G1H72(59),wf4(:,10),G1H18(158),m3h4x18(:,59),heltab2x72(:,:,189))
  call Hloop_A_Q(ntryL,G1H18(158),35,0,G2H18(58),n2h18(229))
  call Hloop_AV_Q(ntryL,G1H72(60),wf4(:,10),G1H18(159),m3h4x18(:,60),heltab2x72(:,:,190))
  call Hloop_A_Q(ntryL,G1H18(159),35,nMB,G2H18(59),n2h18(230))
  call Hloop_QV_A(ntryL,G1H36(7),wf4(:,10),G1H9(159),m3h4x9(:,5),heltab2x36(:,:,200))
  call Hloop_Q_A(ntryL,G1H9(159),51,0,G2H9(31),n2h9(141))
  call Hloop_QV_A(ntryL,G1H36(12),wf4(:,10),G1H9(180),m3h4x9(:,6),heltab2x36(:,:,201))
  call Hloop_Q_A(ntryL,G1H9(180),51,nMT,G2H9(33),n2h9(142))
  call Hloop_AV_Q(ntryL,G1H36(3),wf4(:,10),G1H9(199),m3h4x9(:,7),heltab2x36(:,:,202))
  call Hloop_A_Q(ntryL,G1H9(199),51,0,G2H9(35),n2h9(143))
  call Hloop_AV_Q(ntryL,G1H36(5),wf4(:,10),G1H9(210),m3h4x9(:,8),heltab2x36(:,:,203))
  call Hloop_A_Q(ntryL,G1H9(210),51,nMB,G2H9(37),n2h9(144))
  call Hloop_AV_Q(ntryL,G1H36(31),wf4(:,10),G1H9(59),m3h4x9(:,9),heltab2x36(:,:,204))
  call Hloop_A_Q(ntryL,G1H9(59),51,0,G2H9(42),n2h9(145))
  call Hloop_AV_Q(ntryL,G1H36(32),wf4(:,10),G1H9(60),m3h4x9(:,10),heltab2x36(:,:,205))
  call Hloop_A_Q(ntryL,G1H9(60),51,nMT,G2H9(52),n2h9(146))
  call Hloop_QV_A(ntryL,G1H36(33),wf4(:,10),G1H9(69),m3h4x9(:,11),heltab2x36(:,:,206))
  call Hloop_Q_A(ntryL,G1H9(69),51,0,G2H9(15),n2h9(147))
  call Hloop_QV_A(ntryL,G1H36(34),wf4(:,10),G1H9(50),m3h4x9(:,12),heltab2x36(:,:,207))
  call Hloop_Q_A(ntryL,G1H9(50),51,nMB,G2H9(10),n2h9(148))
  call Hloop_AW_Q(ntryL,G1H36(36),ex3(:),G1H12(152),m3h3x12(:,52),heltab2x36(:,:,208))
  call Hloop_A_Q(ntryL,G1H12(152),52,0,G2H12(52),n2h12(142))
  call Hloop_AW_Q(ntryL,G1H36(37),ex3(:),G1H12(23),m3h3x12(:,53),heltab2x36(:,:,209))
  call Hloop_A_Q(ntryL,G1H12(23),52,nMT,G2H12(53),n2h12(143))
  call Hloop_QW_A(ntryL,G1H36(38),ex3(:),G1H12(24),m3h3x12(:,54),heltab2x36(:,:,210))
  call Hloop_Q_A(ntryL,G1H12(24),52,0,G2H12(55),n2h12(144))
  call Hloop_QW_A(ntryL,G1H36(39),ex3(:),G1H12(37),m3h3x12(:,55),heltab2x36(:,:,211))
  call Hloop_Q_A(ntryL,G1H12(37),52,nMB,G2H12(56),n2h12(145))
  call Hloop_QW_A(ntryL,G1H72(61),ex3(:),G1H24(9),m3h3x24(:,42),heltab2x72(:,:,191))
  call Hloop_Q_A(ntryL,G1H24(9),36,0,G2H24(28),n2h24(72))
  call Hloop_QW_A(ntryL,G1H72(62),ex3(:),G1H24(15),m3h3x24(:,43),heltab2x72(:,:,192))
  call Hloop_Q_A(ntryL,G1H24(15),36,nMB,G2H24(29),n2h24(73))
  call Hloop_AW_Q(ntryL,G1H72(63),ex3(:),G1H24(2),m3h3x24(:,44),heltab2x72(:,:,193))
  call Hloop_A_Q(ntryL,G1H24(2),36,0,G2H24(30),n2h24(74))
  call Hloop_AW_Q(ntryL,G1H72(64),ex3(:),G1H24(4),m3h3x24(:,45),heltab2x72(:,:,194))
  call Hloop_A_Q(ntryL,G1H24(4),36,nMT,G2H24(31),n2h24(75))
  call Hloop_AW_Q(ntryL,G1H72(65),ex4(:),G1H24(5),m3h3x24(:,46),heltab2x72(:,:,195))
  call Hloop_A_Q(ntryL,G1H24(5),40,0,G2H24(32),n2h24(76))
  call Hloop_AW_Q(ntryL,G1H72(66),ex4(:),G1H24(6),m3h3x24(:,47),heltab2x72(:,:,196))
  call Hloop_A_Q(ntryL,G1H24(6),40,nMB,G2H24(33),n2h24(77))
  call Hloop_QW_A(ntryL,G1H72(67),ex4(:),G1H24(7),m3h3x24(:,48),heltab2x72(:,:,197))
  call Hloop_Q_A(ntryL,G1H24(7),40,0,G2H24(34),n2h24(78))
  call Hloop_QW_A(ntryL,G1H72(68),ex4(:),G1H24(10),m3h3x24(:,49),heltab2x72(:,:,198))
  call Hloop_Q_A(ntryL,G1H24(10),40,nMT,G2H24(4),n2h24(79))
  call Hloop_QW_A(ntryL,G1H72(69),ex3(:),G1H24(11),m3h3x24(:,50),heltab2x72(:,:,199))
  call Hloop_Q_A(ntryL,G1H24(11),36,0,G2H24(5),n2h24(80))
  call Hloop_QW_A(ntryL,G1H72(70),ex3(:),G1H24(12),m3h3x24(:,51),heltab2x72(:,:,200))
  call Hloop_Q_A(ntryL,G1H24(12),36,nMB,G2H24(6),n2h24(81))
  call Hloop_AW_Q(ntryL,G1H72(71),ex3(:),G1H24(13),m3h3x24(:,52),heltab2x72(:,:,201))
  call Hloop_A_Q(ntryL,G1H24(13),36,0,G2H24(7),n2h24(82))
  call Hloop_AW_Q(ntryL,G1H72(72),ex3(:),G1H24(14),m3h3x24(:,53),heltab2x72(:,:,202))
  call Hloop_A_Q(ntryL,G1H24(14),36,nMT,G2H24(1),n2h24(83))
  call Hloop_QA_V(ntryL,G1H72(73),wf6(:,4),G1H12(32),m3h6x12(:,7),heltab2x72(:,:,203))
  call Hloop_VA_Q(ntryL,G1H72(74),wf6(:,4),G1H12(35),m3h6x12(:,8),heltab2x72(:,:,204))
  call Hloop_A_Q(ntryL,G1H12(35),42,nMB,G2H12(57),n2h12(146))
  call Hloop_AQ_V(ntryL,G1H72(75),wf6(:,3),G1H12(36),m3h6x12(:,9),heltab2x72(:,:,205))
  call Hloop_VQ_A(ntryL,G1H72(76),wf6(:,3),G1H12(43),m3h6x12(:,10),heltab2x72(:,:,206))
  call Hloop_Q_A(ntryL,G1H12(43),37,nMB,G2H12(59),n2h12(147))
  call Hloop_VQ_A(ntryL,G1H72(77),wf6(:,3),G1H12(44),m3h6x12(:,11),heltab2x72(:,:,207))
  call Hloop_Q_A(ntryL,G1H12(44),37,nMB,G2H12(60),n2h12(148))
  call Hloop_AQ_V(ntryL,G1H72(78),wf6(:,3),G1H12(49),m3h6x12(:,12),heltab2x72(:,:,208))
  call Hloop_AW_Q(ntryL,G1H72(79),ex4(:),G1H24(17),m3h3x24(:,54),heltab2x72(:,:,209))
  call Hloop_A_Q(ntryL,G1H24(17),40,nMB,G2H24(2),n2h24(84))
  call Hloop_AQ_V(ntryL,G1H72(80),wf6(:,3),G1H12(55),m3h6x12(:,13),heltab2x72(:,:,210))
  call Hloop_VQ_A(ntryL,G1H72(81),wf6(:,3),G1H12(56),m3h6x12(:,14),heltab2x72(:,:,211))
  call Hloop_Q_A(ntryL,G1H12(56),37,nMB,G2H12(61),n2h12(149))
  call Hloop_VQ_A(ntryL,G0H36(16),wf6(:,3),G0H6(1),m3h6x6(:,9),heltab2x36(:,:,212))
  call Hloop_Q_A(ntryL,G0H6(1),39,nMB,G1H6(66),n2h6(397))
  call Hloop_VQ_A(ntryL,G0H36(17),wf6(:,3),G0H6(2),m3h6x6(:,10),heltab2x36(:,:,213))
  call Hloop_Q_A(ntryL,G0H6(2),39,nMB,G1H6(67),n2h6(398))
  call Hloop_AQ_V(ntryL,G1H36(42),wf6(:,3),G1H6(68),m3h6x6(:,11),heltab2x36(:,:,214))
  call Hloop_QA_V(ntryL,G1H36(44),ex2(:),G1H18(160),m3h2x18(:,92),heltab2x36(:,:,215))
  call Hloop_VA_Q(ntryL,G1H72(82),ex2(:),G1H36(30),m3h2x36(:,60),heltab2x72(:,:,212))
  call Hloop_A_Q(ntryL,G1H36(30),34,nMT,G2H36(1),n2h36(89))
  call Hloop_QA_V(ntryL,G1H72(83),ex2(:),G1H36(2),m3h2x36(:,61),heltab2x72(:,:,213))
  call Hloop_AQ_V(ntryL,G1H72(84),wf18(:,2),G1H4(69),m3h18x4(:,1),heltab2x72(:,:,214))
  call Hloop_VQ_A(ntryL,G1H72(85),wf18(:,2),G1H4(79),m3h18x4(:,2),heltab2x72(:,:,215))
  call Hloop_Q_A(ntryL,G1H4(79),45,nMT,G2H4(55),n2h4(154))
  call Hloop_QA_V(ntryL,G1H72(86),ex2(:),G1H36(10),m3h2x36(:,62),heltab2x72(:,:,216))
  call Hloop_VA_Q(ntryL,G1H72(87),ex2(:),G1H36(1),m3h2x36(:,63),heltab2x72(:,:,217))
  call Hloop_A_Q(ntryL,G1H36(1),34,nMT,G2H36(2),n2h36(90))
  call Hloop_VA_Q(ntryL,G1H72(88),ex2(:),G1H36(9),m3h2x36(:,64),heltab2x72(:,:,218))
  call Hloop_A_Q(ntryL,G1H36(9),34,nMT,G2H36(3),n2h36(91))
  call Hloop_QW_A(ntryL,G1H72(89),ex4(:),G1H24(18),m3h3x24(:,55),heltab2x72(:,:,219))
  call Hloop_Q_A(ntryL,G1H24(18),40,nMT,G2H24(3),n2h24(85))
  call Hloop_QA_V(ntryL,G1H72(90),ex2(:),G1H36(22),m3h2x36(:,65),heltab2x72(:,:,220))
  call Hloop_VA_Q(ntryL,G0H12(8),ex2(:),G0H6(3),m3h2x6(:,89),heltab2x12(:,:,240))
  call Hloop_A_Q(ntryL,G0H6(3),39,nMT,G1H6(78),n2h6(399))
  call Hloop_VA_Q(ntryL,G0H12(1),ex2(:),G0H6(4),m3h2x6(:,90),heltab2x12(:,:,241))
  call Hloop_A_Q(ntryL,G0H6(4),39,nMT,G1H6(79),n2h6(400))
  call Hloop_AW_Q(ntryL,G1H72(91),ex3(:),G1H24(3),m3h3x24(:,56),heltab2x72(:,:,221))
  call Hloop_A_Q(ntryL,G1H24(3),36,nMT,G2H24(8),n2h24(86))
  call Hloop_QW_A(ntryL,G1H72(92),ex3(:),G1H24(19),m3h3x24(:,57),heltab2x72(:,:,222))
  call Hloop_Q_A(ntryL,G1H24(19),36,nMB,G2H24(9),n2h24(87))
  call Hloop_VA_Q(ntryL,G1H72(93),wf6(:,4),G1H12(59),m3h6x12(:,15),heltab2x72(:,:,223))
  call Hloop_A_Q(ntryL,G1H12(59),42,nMB,G2H12(63),n2h12(150))
  call Hloop_VA_Q(ntryL,G0H36(18),wf6(:,4),G0H6(5),m3h6x6(:,12),heltab2x36(:,:,216))
  call Hloop_A_Q(ntryL,G0H6(5),43,nMB,G1H6(80),n2h6(401))
  call Hloop_AW_Q(ntryL,G1H36(45),ex3(:),G1H12(60),m3h3x12(:,56),heltab2x36(:,:,217))
  call Hloop_A_Q(ntryL,G1H12(60),52,nMT,G2H12(64),n2h12(151))
  call Hloop_AQ_V(ntryL,G1H36(47),ex1(:),G1H18(162),m3h2x18(:,93),heltab2x36(:,:,218))
  call Hloop_VQ_A(ntryL,G1H72(94),ex1(:),G1H36(27),m3h2x36(:,66),heltab2x72(:,:,224))
  call Hloop_Q_A(ntryL,G1H36(27),33,nMT,G2H36(4),n2h36(92))
  call Hloop_AQ_V(ntryL,G1H72(95),ex1(:),G1H36(6),m3h2x36(:,67),heltab2x72(:,:,225))
  call Hloop_QA_V(ntryL,G1H72(96),wf18(:,4),G1H4(39),m3h18x4(:,3),heltab2x72(:,:,226))
  call Hloop_VA_Q(ntryL,G1H72(97),wf18(:,4),G1H4(75),m3h18x4(:,4),heltab2x72(:,:,227))
  call Hloop_A_Q(ntryL,G1H4(75),46,nMT,G2H4(59),n2h4(155))
  call Hloop_AQ_V(ntryL,G1H72(98),ex1(:),G1H36(17),m3h2x36(:,68),heltab2x72(:,:,228))
  call Hloop_VQ_A(ntryL,G1H72(99),ex1(:),G1H36(18),m3h2x36(:,69),heltab2x72(:,:,229))
  call Hloop_Q_A(ntryL,G1H36(18),33,nMT,G2H36(5),n2h36(93))
  call Hloop_VQ_A(ntryL,G1H72(100),ex1(:),G1H36(60),m3h2x36(:,70),heltab2x72(:,:,230))
  call Hloop_Q_A(ntryL,G1H36(60),33,nMT,G2H36(6),n2h36(94))
  call Hloop_AW_Q(ntryL,G1H72(101),ex3(:),G1H24(20),m3h3x24(:,58),heltab2x72(:,:,231))
  call Hloop_A_Q(ntryL,G1H24(20),36,nMT,G2H24(10),n2h24(88))
  call Hloop_AQ_V(ntryL,G1H72(102),ex1(:),G1H36(61),m3h2x36(:,71),heltab2x72(:,:,232))
  call Hloop_VQ_A(ntryL,G0H12(7),ex1(:),G0H6(6),m3h2x6(:,91),heltab2x12(:,:,242))
  call Hloop_Q_A(ntryL,G0H6(6),43,nMT,G1H6(85),n2h6(402))
  call Hloop_VQ_A(ntryL,G0H12(4),ex1(:),G0H6(7),m3h2x6(:,92),heltab2x12(:,:,243))
  call Hloop_Q_A(ntryL,G0H6(7),43,nMT,G1H6(27),n2h6(403))
  call Hloop_QA_V(ntryL,G1H72(103),ex2(:),G1H36(62),m3h2x36(:,72),heltab2x72(:,:,233))
  call Hloop_QA_V(ntryL,G1H72(104),ex2(:),G1H36(63),m3h2x36(:,73),heltab2x72(:,:,234))
  call Hloop_QA_V(ntryL,G1H72(105),ex2(:),G1H36(64),m3h2x36(:,74),heltab2x72(:,:,235))
  call Hloop_VA_Q(ntryL,G1H72(106),ex2(:),G1H36(66),m3h2x36(:,75),heltab2x72(:,:,236))
  call Hloop_A_Q(ntryL,G1H36(66),34,nMT,G2H36(7),n2h36(95))
  call Hloop_VA_Q(ntryL,G1H72(107),ex2(:),G1H36(67),m3h2x36(:,76),heltab2x72(:,:,237))
  call Hloop_A_Q(ntryL,G1H36(67),34,nMT,G2H36(8),n2h36(96))
  call Hloop_VA_Q(ntryL,G1H72(108),ex2(:),G1H36(68),m3h2x36(:,77),heltab2x72(:,:,238))
  call Hloop_A_Q(ntryL,G1H36(68),34,nMT,G2H36(9),n2h36(97))
  call Hloop_QS_A(ntryL,G1H72(109),wf9(:,1),G1H8(25),ngH,m3h9x8(:,25),heltab2x72(:,:,239))
  call Hloop_Q_A(ntryL,G1H8(25),44,nMT,G2H8(31),n2h8(110))
  call Hloop_QV_A(ntryL,G1H72(110),wf9(:,2),G1H8(28),m3h9x8(:,26),heltab2x72(:,:,240))
  call Hloop_Q_A(ntryL,G1H8(28),44,nMT,G2H8(32),n2h8(111))
  call Hloop_QZ_A(ntryL,G1H72(111),wf9(:,3),G1H8(30),ngZu,m3h9x8(:,27),heltab2x72(:,:,241))
  call Hloop_Q_A(ntryL,G1H8(30),44,nMT,G2H8(49),n2h8(112))
  call Hloop_AQ_V(ntryL,G1H72(112),ex1(:),G1H36(69),m3h2x36(:,78),heltab2x72(:,:,242))
  call Hloop_AQ_V(ntryL,G1H72(113),ex1(:),G1H36(70),m3h2x36(:,79),heltab2x72(:,:,243))
  call Hloop_AQ_V(ntryL,G1H72(114),ex1(:),G1H36(72),m3h2x36(:,80),heltab2x72(:,:,244))
  call Hloop_VQ_A(ntryL,G1H72(115),ex1(:),G1H36(73),m3h2x36(:,81),heltab2x72(:,:,245))
  call Hloop_Q_A(ntryL,G1H36(73),33,nMT,G2H36(10),n2h36(98))
  call Hloop_VQ_A(ntryL,G1H72(116),ex1(:),G1H36(74),m3h2x36(:,82),heltab2x72(:,:,246))
  call Hloop_Q_A(ntryL,G1H36(74),33,nMT,G2H36(11),n2h36(99))
  call Hloop_VQ_A(ntryL,G1H72(117),ex1(:),G1H36(75),m3h2x36(:,83),heltab2x72(:,:,247))
  call Hloop_Q_A(ntryL,G1H36(75),33,nMT,G2H36(12),n2h36(100))
  call Hloop_AS_Q(ntryL,G1H72(118),wf9(:,1),G1H8(33),ngH,m3h9x8(:,28),heltab2x72(:,:,248))
  call Hloop_A_Q(ntryL,G1H8(33),44,nMT,G2H8(50),n2h8(113))
  call Hloop_AV_Q(ntryL,G1H72(119),wf9(:,2),G1H8(34),m3h9x8(:,29),heltab2x72(:,:,249))
  call Hloop_A_Q(ntryL,G1H8(34),44,nMT,G2H8(51),n2h8(114))
  call Hloop_AZ_Q(ntryL,G1H72(120),wf9(:,3),G1H8(35),ngZu,m3h9x8(:,30),heltab2x72(:,:,250))
  call Hloop_A_Q(ntryL,G1H8(35),44,nMT,G2H8(52),n2h8(115))
  call Hloop_VA_Q(ntryL,G0H36(19),ex2(:),G0H18(3),m3h2x18(:,94),heltab2x36(:,:,219))
  call Hloop_A_Q(ntryL,G0H18(3),35,nMT,G1H18(165),n2h18(231))
  call Hloop_VA_Q(ntryL,G0H36(20),ex2(:),G0H18(1),m3h2x18(:,95),heltab2x36(:,:,220))
  call Hloop_A_Q(ntryL,G0H18(1),35,nMT,G1H18(166),n2h18(232))
  call Hloop_VA_Q(ntryL,G0H36(21),ex2(:),G0H18(4),m3h2x18(:,96),heltab2x36(:,:,221))
  call Hloop_A_Q(ntryL,G0H18(4),35,nMT,G1H18(168),n2h18(233))
  call Hloop_VA_Q(ntryL,G0H36(22),ex2(:),G0H18(2),m3h2x18(:,97),heltab2x36(:,:,222))
  call Hloop_A_Q(ntryL,G0H18(2),35,nMT,G1H18(169),n2h18(234))
  call Hloop_VA_Q(ntryL,G0H36(23),ex2(:),G0H18(3),m3h2x18(:,98),heltab2x36(:,:,223))
  call Hloop_A_Q(ntryL,G0H18(3),35,nMT,G1H18(50),n2h18(235))
  call Hloop_VA_Q(ntryL,G0H36(24),ex2(:),G0H18(1),m3h2x18(:,99),heltab2x36(:,:,224))
  call Hloop_A_Q(ntryL,G0H18(1),35,nMT,G1H18(51),n2h18(236))
  call Hloop_VQ_A(ntryL,G0H36(25),ex1(:),G0H18(4),m3h2x18(:,100),heltab2x36(:,:,225))
  call Hloop_Q_A(ntryL,G0H18(4),35,nMT,G1H18(52),n2h18(237))
  call Hloop_VQ_A(ntryL,G0H36(26),ex1(:),G0H18(2),m3h2x18(:,101),heltab2x36(:,:,226))
  call Hloop_Q_A(ntryL,G0H18(2),35,nMT,G1H18(53),n2h18(238))
  call Hloop_VQ_A(ntryL,G0H36(27),ex1(:),G0H18(3),m3h2x18(:,102),heltab2x36(:,:,227))
  call Hloop_Q_A(ntryL,G0H18(3),35,nMT,G1H18(69),n2h18(239))
  call Hloop_VQ_A(ntryL,G0H36(28),ex1(:),G0H18(1),m3h2x18(:,103),heltab2x36(:,:,228))
  call Hloop_Q_A(ntryL,G0H18(1),35,nMT,G1H18(10),n2h18(240))
  call Hloop_VQ_A(ntryL,G0H36(29),ex1(:),G0H18(4),m3h2x18(:,104),heltab2x36(:,:,229))
  call Hloop_Q_A(ntryL,G0H18(4),35,nMT,G1H18(56),n2h18(241))
  call Hloop_VQ_A(ntryL,G0H36(30),ex1(:),G0H18(2),m3h2x18(:,105),heltab2x36(:,:,230))
  call Hloop_Q_A(ntryL,G0H18(2),35,nMT,G1H18(9),n2h18(242))
  call Hloop_QA_V(ntryL,G1H36(55),ex2(:),G1H18(11),m3h2x18(:,106),heltab2x36(:,:,231))
  call Hloop_QA_V(ntryL,G1H36(57),ex2(:),G1H18(20),m3h2x18(:,107),heltab2x36(:,:,232))
  call Hloop_QA_V(ntryL,G1H36(58),ex2(:),G1H18(21),m3h2x18(:,108),heltab2x36(:,:,233))
  call Hloop_AQ_V(ntryL,G1H36(59),ex1(:),G1H18(172),m3h2x18(:,109),heltab2x36(:,:,234))
  call Hloop_AQ_V(ntryL,G1H36(20),ex1(:),G1H18(177),m3h2x18(:,110),heltab2x36(:,:,235))
  call Hloop_AQ_V(ntryL,G1H36(21),ex1(:),G1H18(182),m3h2x18(:,111),heltab2x36(:,:,236))
  call Hloop_VA_Q(ntryL,G1H72(121),ex2(:),G1H36(76),m3h2x36(:,84),heltab2x72(:,:,251))
  call Hloop_A_Q(ntryL,G1H36(76),34,nMT,G2H36(13),n2h36(101))
  call Hloop_QA_V(ntryL,G1H72(122),ex2(:),G1H36(78),m3h2x36(:,85),heltab2x72(:,:,252))
  call Hloop_VA_Q(ntryL,G1H72(123),ex2(:),G1H36(79),m3h2x36(:,86),heltab2x72(:,:,253))
  call Hloop_A_Q(ntryL,G1H36(79),34,nMT,G2H36(14),n2h36(102))
  call Hloop_VA_Q(ntryL,G1H72(124),ex2(:),G1H36(80),m3h2x36(:,87),heltab2x72(:,:,254))
  call Hloop_A_Q(ntryL,G1H36(80),34,nMT,G2H36(15),n2h36(103))
  call Hloop_QA_V(ntryL,G1H72(125),ex2(:),G1H36(81),m3h2x36(:,88),heltab2x72(:,:,255))
  call Hloop_QA_V(ntryL,G1H72(126),ex2(:),G1H36(82),m3h2x36(:,89),heltab2x72(:,:,256))
  call Hloop_AQ_V(ntryL,G1H72(127),wf18(:,12),G1H4(78),m3h18x4(:,5),heltab2x72(:,:,257))
  call Hloop_VQ_A(ntryL,G1H72(128),wf18(:,12),G1H4(80),m3h18x4(:,6),heltab2x72(:,:,258))
  call Hloop_Q_A(ntryL,G1H4(80),45,nMT,G2H4(60),n2h4(156))
  call Hloop_AQ_V(ntryL,G1H72(129),wf18(:,14),G1H4(83),m3h18x4(:,7),heltab2x72(:,:,259))
  call Hloop_AQ_V(ntryL,G1H72(130),wf18(:,16),G1H4(40),m3h18x4(:,8),heltab2x72(:,:,260))
  call Hloop_VQ_A(ntryL,G1H72(131),wf18(:,14),G1H4(85),m3h18x4(:,9),heltab2x72(:,:,261))
  call Hloop_Q_A(ntryL,G1H4(85),45,nMT,G2H4(63),n2h4(157))
  call Hloop_VQ_A(ntryL,G1H72(132),wf18(:,16),G1H4(87),m3h18x4(:,10),heltab2x72(:,:,262))
  call Hloop_Q_A(ntryL,G1H4(87),45,nMT,G2H4(64),n2h4(158))
  call Hloop_QA_V(ntryL,G1H72(133),ex2(:),G1H36(84),m3h2x36(:,90),heltab2x72(:,:,263))
  call Hloop_VA_Q(ntryL,G1H72(134),ex2(:),G1H36(85),m3h2x36(:,91),heltab2x72(:,:,264))
  call Hloop_A_Q(ntryL,G1H36(85),34,nMT,G2H36(16),n2h36(104))
  call Hloop_QA_V(ntryL,G1H72(135),ex2(:),G1H36(86),m3h2x36(:,92),heltab2x72(:,:,265))
  call Hloop_QA_V(ntryL,G1H72(136),ex2(:),G1H36(87),m3h2x36(:,93),heltab2x72(:,:,266))
  call Hloop_VA_Q(ntryL,G1H72(137),ex2(:),G1H36(88),m3h2x36(:,94),heltab2x72(:,:,267))
  call Hloop_A_Q(ntryL,G1H36(88),34,nMT,G2H36(17),n2h36(105))
  call Hloop_VA_Q(ntryL,G1H72(138),ex2(:),G1H36(90),m3h2x36(:,95),heltab2x72(:,:,268))
  call Hloop_A_Q(ntryL,G1H36(90),34,nMT,G2H36(18),n2h36(106))
  call Hloop_VQ_A(ntryL,G1H72(139),ex1(:),G1H36(91),m3h2x36(:,96),heltab2x72(:,:,269))
  call Hloop_Q_A(ntryL,G1H36(91),33,nMT,G2H36(19),n2h36(107))
  call Hloop_AQ_V(ntryL,G1H72(140),ex1(:),G1H36(92),m3h2x36(:,97),heltab2x72(:,:,270))
  call Hloop_VQ_A(ntryL,G1H72(141),ex1(:),G1H36(93),m3h2x36(:,98),heltab2x72(:,:,271))
  call Hloop_Q_A(ntryL,G1H36(93),33,nMT,G2H36(20),n2h36(108))
  call Hloop_VQ_A(ntryL,G1H72(142),ex1(:),G1H36(94),m3h2x36(:,99),heltab2x72(:,:,272))
  call Hloop_Q_A(ntryL,G1H36(94),33,nMT,G2H36(21),n2h36(109))
  call Hloop_AQ_V(ntryL,G1H72(143),ex1(:),G1H36(96),m3h2x36(:,100),heltab2x72(:,:,273))
  call Hloop_AQ_V(ntryL,G1H72(144),ex1(:),G1H36(97),m3h2x36(:,101),heltab2x72(:,:,274))
  call Hloop_QA_V(ntryL,G1H72(145),wf18(:,6),G1H4(90),m3h18x4(:,11),heltab2x72(:,:,275))
  call Hloop_VA_Q(ntryL,G1H72(146),wf18(:,6),G1H4(27),m3h18x4(:,12),heltab2x72(:,:,276))
  call Hloop_A_Q(ntryL,G1H4(27),46,nMT,G2H4(67),n2h4(159))
  call Hloop_QA_V(ntryL,G1H72(147),wf18(:,8),G1H4(28),m3h18x4(:,13),heltab2x72(:,:,277))
  call Hloop_QA_V(ntryL,G1H72(148),wf18(:,10),G1H4(66),m3h18x4(:,14),heltab2x72(:,:,278))
  call Hloop_VA_Q(ntryL,G1H72(149),wf18(:,8),G1H4(67),m3h18x4(:,15),heltab2x72(:,:,279))
  call Hloop_A_Q(ntryL,G1H4(67),46,nMT,G2H4(71),n2h4(160))
  call Hloop_VA_Q(ntryL,G1H72(150),wf18(:,10),G1H4(72),m3h18x4(:,16),heltab2x72(:,:,280))
  call Hloop_A_Q(ntryL,G1H4(72),46,nMT,G2H4(79),n2h4(161))
  call Hloop_AQ_V(ntryL,G1H72(151),ex1(:),G1H36(98),m3h2x36(:,102),heltab2x72(:,:,281))
  call Hloop_VQ_A(ntryL,G1H72(152),ex1(:),G1H36(99),m3h2x36(:,103),heltab2x72(:,:,282))
  call Hloop_Q_A(ntryL,G1H36(99),33,nMT,G2H36(22),n2h36(110))
  call Hloop_AQ_V(ntryL,G1H72(153),ex1(:),G1H36(100),m3h2x36(:,104),heltab2x72(:,:,283))
  call Hloop_AQ_V(ntryL,G1H72(154),ex1(:),G1H36(102),m3h2x36(:,105),heltab2x72(:,:,284))
  call Hloop_VQ_A(ntryL,G1H72(155),ex1(:),G1H36(103),m3h2x36(:,106),heltab2x72(:,:,285))
  call Hloop_Q_A(ntryL,G1H36(103),33,nMT,G2H36(23),n2h36(111))
  call Hloop_VQ_A(ntryL,G1H72(156),ex1(:),G1H36(104),m3h2x36(:,107),heltab2x72(:,:,286))
  call Hloop_Q_A(ntryL,G1H36(104),33,nMT,G2H36(24),n2h36(112))
  call Hloop_QW_A(ntryL,G1H72(157),ex3(:),G1H24(22),m3h3x24(:,59),heltab2x72(:,:,287))
  call Hloop_Q_A(ntryL,G1H24(22),36,0,G2H24(11),n2h24(89))
  call Hloop_QW_A(ntryL,G1H72(158),ex3(:),G1H24(23),m3h3x24(:,60),heltab2x72(:,:,288))
  call Hloop_Q_A(ntryL,G1H24(23),36,nMB,G2H24(12),n2h24(90))
  call Hloop_AW_Q(ntryL,G1H72(159),ex3(:),G1H24(24),m3h3x24(:,61),heltab2x72(:,:,289))
  call Hloop_A_Q(ntryL,G1H24(24),36,0,G2H24(13),n2h24(91))
  call Hloop_AW_Q(ntryL,G1H72(160),ex3(:),G1H24(25),m3h3x24(:,62),heltab2x72(:,:,290))
  call Hloop_A_Q(ntryL,G1H24(25),36,nMT,G2H24(14),n2h24(92))
  call Hloop_AW_Q(ntryL,G1H72(161),ex4(:),G1H24(26),m3h3x24(:,63),heltab2x72(:,:,291))
  call Hloop_A_Q(ntryL,G1H24(26),40,0,G2H24(15),n2h24(93))
  call Hloop_AW_Q(ntryL,G1H72(162),ex4(:),G1H24(28),m3h3x24(:,64),heltab2x72(:,:,292))
  call Hloop_A_Q(ntryL,G1H24(28),40,nMB,G2H24(16),n2h24(94))
  call Hloop_QW_A(ntryL,G1H72(163),ex4(:),G1H24(29),m3h3x24(:,65),heltab2x72(:,:,293))
  call Hloop_Q_A(ntryL,G1H24(29),40,0,G2H24(17),n2h24(95))
  call Hloop_QW_A(ntryL,G1H72(164),ex4(:),G1H24(30),m3h3x24(:,66),heltab2x72(:,:,294))
  call Hloop_Q_A(ntryL,G1H24(30),40,nMT,G2H24(18),n2h24(96))
  call Hloop_QW_A(ntryL,G1H72(165),ex3(:),G1H24(31),m3h3x24(:,67),heltab2x72(:,:,295))
  call Hloop_Q_A(ntryL,G1H24(31),36,0,G2H24(19),n2h24(97))
  call Hloop_QW_A(ntryL,G1H72(166),ex3(:),G1H24(32),m3h3x24(:,68),heltab2x72(:,:,296))
  call Hloop_Q_A(ntryL,G1H24(32),36,nMB,G2H24(20),n2h24(98))
  call Hloop_AW_Q(ntryL,G1H72(167),ex3(:),G1H24(34),m3h3x24(:,69),heltab2x72(:,:,297))
  call Hloop_A_Q(ntryL,G1H24(34),36,0,G2H24(21),n2h24(99))
  call Hloop_AW_Q(ntryL,G1H72(168),ex3(:),G1H24(35),m3h3x24(:,70),heltab2x72(:,:,298))
  call Hloop_A_Q(ntryL,G1H24(35),36,nMT,G2H24(22),n2h24(100))
  call Hloop_VA_Q(ntryL,G1H72(169),ex2(:),G1H36(105),m3h2x36(:,108),heltab2x72(:,:,299))
  call Hloop_A_Q(ntryL,G1H36(105),34,nMT,G2H36(25),n2h36(113))
  call Hloop_QW_A(ntryL,G1H72(170),ex4(:),G1H24(36),m3h3x24(:,71),heltab2x72(:,:,300))
  call Hloop_Q_A(ntryL,G1H24(36),40,nMT,G2H24(23),n2h24(101))
  call Hloop_QA_V(ntryL,G1H72(171),ex2(:),G1H36(106),m3h2x36(:,109),heltab2x72(:,:,301))
  call Hloop_VA_Q(ntryL,G0H18(5),ex2(:),G0H9(1),m3h2x9(:,129),heltab2x18(:,:,345))
  call Hloop_A_Q(ntryL,G0H9(1),51,nMT,G1H9(75),n2h9(149))
  call Hloop_QW_A(ntryL,G1H72(172),ex3(:),G1H24(37),m3h3x24(:,72),heltab2x72(:,:,302))
  call Hloop_Q_A(ntryL,G1H24(37),36,0,G2H24(24),n2h24(102))
  call Hloop_QW_A(ntryL,G1H72(173),ex3(:),G1H24(38),m3h3x24(:,73),heltab2x72(:,:,303))
  call Hloop_Q_A(ntryL,G1H24(38),36,nMB,G2H24(25),n2h24(103))
  call Hloop_AW_Q(ntryL,G1H72(174),ex3(:),G1H24(40),m3h3x24(:,74),heltab2x72(:,:,304))
  call Hloop_A_Q(ntryL,G1H24(40),36,0,G2H24(26),n2h24(104))
  call Hloop_AW_Q(ntryL,G1H72(175),ex3(:),G1H24(41),m3h3x24(:,75),heltab2x72(:,:,305))
  call Hloop_A_Q(ntryL,G1H24(41),36,nMT,G2H24(27),n2h24(105))
  call Hloop_AW_Q(ntryL,G1H72(176),ex4(:),G1H24(42),m3h3x24(:,76),heltab2x72(:,:,306))
  call Hloop_A_Q(ntryL,G1H24(42),40,0,G2H24(35),n2h24(106))
  call Hloop_AW_Q(ntryL,G1H72(177),ex4(:),G1H24(43),m3h3x24(:,77),heltab2x72(:,:,307))
  call Hloop_A_Q(ntryL,G1H24(43),40,nMB,G2H24(36),n2h24(107))
  call Hloop_QW_A(ntryL,G1H72(178),ex4(:),G1H24(44),m3h3x24(:,78),heltab2x72(:,:,308))
  call Hloop_Q_A(ntryL,G1H24(44),40,0,G2H24(37),n2h24(108))
  call Hloop_QW_A(ntryL,G1H72(179),ex4(:),G1H24(46),m3h3x24(:,79),heltab2x72(:,:,309))
  call Hloop_Q_A(ntryL,G1H24(46),40,nMT,G2H24(38),n2h24(109))
  call Hloop_QW_A(ntryL,G1H72(180),ex3(:),G1H24(47),m3h3x24(:,80),heltab2x72(:,:,310))
  call Hloop_Q_A(ntryL,G1H24(47),36,0,G2H24(39),n2h24(110))
  call Hloop_QW_A(ntryL,G1H72(181),ex3(:),G1H24(48),m3h3x24(:,81),heltab2x72(:,:,311))
  call Hloop_Q_A(ntryL,G1H24(48),36,nMB,G2H24(40),n2h24(111))
  call Hloop_AW_Q(ntryL,G1H72(182),ex3(:),G1H24(49),m3h3x24(:,82),heltab2x72(:,:,312))
  call Hloop_A_Q(ntryL,G1H24(49),36,0,G2H24(41),n2h24(112))
  call Hloop_AW_Q(ntryL,G1H72(183),ex3(:),G1H24(50),m3h3x24(:,83),heltab2x72(:,:,313))
  call Hloop_A_Q(ntryL,G1H24(50),36,nMT,G2H24(42),n2h24(113))
  call Hloop_VQ_A(ntryL,G1H72(184),ex1(:),G1H36(108),m3h2x36(:,110),heltab2x72(:,:,314))
  call Hloop_Q_A(ntryL,G1H36(108),33,nMT,G2H36(26),n2h36(114))
  call Hloop_AW_Q(ntryL,G1H72(185),ex3(:),G1H24(52),m3h3x24(:,84),heltab2x72(:,:,315))
  call Hloop_A_Q(ntryL,G1H24(52),36,nMT,G2H24(43),n2h24(114))
  call Hloop_AQ_V(ntryL,G1H72(186),ex1(:),G1H36(109),m3h2x36(:,111),heltab2x72(:,:,316))
  call Hloop_VQ_A(ntryL,G0H18(6),ex1(:),G0H9(2),m3h2x9(:,130),heltab2x18(:,:,346))
  call Hloop_Q_A(ntryL,G0H9(2),51,nMT,G1H9(76),n2h9(150))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(42),[G2H4(41),G2H4(39),G2H4(61),G2H4(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(79),[G2H4(71),G2H4(67),G2H4(59),G2H4(82),G2H4(78) &
    ,G2H4(74),G2H4(49),G2H4(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(52),[G2H4(51),G2H4(48),G2H4(65),G2H4(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(64),[G2H4(63),G2H4(60),G2H4(55),G2H4(106),G2H4(102) &
    ,G2H4(98),G2H4(53),G2H4(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(107),[G2H6(103),G2H6(21),G2H6(14),G1H6(299),G1H6(280) &
    ,G1H6(171)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(77),[G2H6(73),G2H6(23),G2H6(15),G1H6(305),G1H6(286) &
    ,G1H6(172)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(47),[G2H4(46),G2H4(43),G2H4(69),G2H4(3),G1H4(65) &
    ,G1H4(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(94),[G2H4(90),G2H4(86),G2H4(57),G2H4(4),G1H4(71) &
    ,G1H4(16)])
call ol_merge_last(G2H6(100), G2H6(100)) 
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(219),[G2H6(100),G2H6(60)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(186),[G1H6(81)])
call HGT_lower_alpha_w2_OLR(G2H6(219),1,1,6)
call HGT_lower_alpha_w2_invQ_OLR(G2H6(219),2,5,6)
call HGT_lower_alpha_w2_OLR(G2H6(219),6,15,6)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(219),[G2H6(186)])
call ol_merge_last(G2H6(101), G2H6(101)) 
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(218),[G2H6(101),G2H6(61)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(188),[G1H6(304),G1H6(148),G1H6(149)])
call HGT_lower_alpha_w2_OLR(G2H6(218),1,1,6)
call HGT_lower_alpha_w2_invQ_OLR(G2H6(218),2,5,6)
call HGT_lower_alpha_w2_OLR(G2H6(218),6,15,6)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(218),[G2H6(188)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(72),[G2H4(44)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H9(33),[G1H9(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H9(75),[G1H9(87),G1H9(81),G1H9(47)])
call HGT_w2_OLR(G1H9(33),1,1,9)
call HGT_w2_invQ_OLR(G1H9(33),2,5,9)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H9(33),[G1H9(75)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(63),[G1H6(82)])
call HGT_lower_alpha_OLR(G2H6(66),1,1,6)
call HGT_lower_alpha_invQ_OLR(G2H6(66),2,5,6)
call HGT_lower_alpha_OLR(G2H6(66),6,15,6)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(66),[G2H6(63)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H9(45),[G1H9(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H9(76),[G1H9(77),G1H9(71),G1H9(10)])
call HGT_w2_OLR(G1H9(45),1,1,9)
call HGT_w2_invQ_OLR(G1H9(45),2,5,9)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H9(45),[G1H9(76)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(68),[G1H6(150)])
call HGT_lower_alpha_OLR(G2H6(71),1,1,6)
call HGT_lower_alpha_invQ_OLR(G2H6(71),2,5,6)
call HGT_lower_alpha_OLR(G2H6(71),6,15,6)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(71),[G2H6(68)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(67),[G1H6(166),G1H6(8)])
call HGT_w2_OLR(G1H6(50),1,1,6)
call HGT_w2_invQ_OLR(G1H6(50),2,5,6)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(50),[G1H6(67)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(66),[G1H6(186),G1H6(36)])
call HGT_w2_OLR(G1H6(61),1,1,6)
call HGT_w2_invQ_OLR(G1H6(61),2,5,6)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(61),[G1H6(66)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H9(72),[G1H9(14),G1H9(29)])
call HGT_w2_OLR(G1H9(23),1,1,9)
call HGT_w2_invQ_OLR(G1H9(23),2,5,9)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H9(23),[G1H9(72)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H9(33),[G1H9(11)])
call HGT_OLR(G2H9(17),1,1,9)
call HGT_invQ_OLR(G2H9(17),2,5,9)
call HGT_OLR(G2H9(17),6,15,9)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H9(17),[G2H9(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(207),[G2H6(81),G1H6(673),G1H6(226),G1H6(48)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(13),[G1H6(120),G1H6(86)])
call HGT_OLR(G2H6(85),1,1,6)
call HGT_invQ_OLR(G2H6(85),2,5,6)
call HGT_OLR(G2H6(85),6,15,6)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(85),[G2H6(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(199),[G2H6(86),G1H6(641),G1H6(236),G1H6(13)])
call HGT_OLR(G2H6(89),1,1,6)
call HGT_invQ_OLR(G2H6(89),2,5,6)
call HGT_OLR(G2H6(89),6,15,6)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(89),[G1H6(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H9(19),[G1H9(78),G1H9(31),G1H9(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H9(52),[G1H9(51)])
call HGT_OLR(G2H9(22),1,1,9)
call HGT_invQ_OLR(G2H9(22),2,5,9)
call HGT_OLR(G2H9(22),6,15,9)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H9(22),[G2H9(52)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(175),[G2H6(91),G1H6(567),G1H6(252),G1H6(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(11),[G1H6(71),G1H6(116)])
call HGT_OLR(G2H6(95),1,1,6)
call HGT_invQ_OLR(G2H6(95),2,5,6)
call HGT_OLR(G2H6(95),6,15,6)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(95),[G2H6(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(96),[G1H6(267),G1H6(69)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(49),[G1H6(125),G1H6(138)])
call HGT_OLR(G2H6(99),1,1,6)
call HGT_invQ_OLR(G2H6(99),2,5,6)
call HGT_OLR(G2H6(99),6,15,6)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(99),[G2H6(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H9(24),[G1H9(88),G1H9(63),G1H9(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(194),[G1H6(235),G1H6(165)])
call HGT_w2_OLR(G1H6(114),1,1,6)
call HGT_w2_invQ_OLR(G1H6(114),2,5,6)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(194),[G1H6(114)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(193),[G1H6(225),G1H6(185)])
call HGT_w2_OLR(G1H6(122),1,1,6)
call HGT_w2_invQ_OLR(G1H6(122),2,5,6)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(193),[G1H6(122)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H9(59),[G1H9(30),G1H9(13)])
call HGT_w2_OLR(G1H9(46),1,1,9)
call HGT_w2_invQ_OLR(G1H9(46),2,5,9)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H9(59),[G1H9(46)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H9(28),[G1H9(102)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H9(32),[G1H9(118)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H9(36),[G1H9(134)])
call HGT_OLR(G2H9(39),1,1,9)
call HGT_invQ_OLR(G2H9(39),2,5,9)
call HGT_OLR(G2H9(39),6,15,9)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H9(39),[G2H9(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(171),[G2H6(114),G1H6(551),G1H6(359)])
call HGT_OLR(G2H9(40),1,1,9)
call HGT_invQ_OLR(G2H9(40),2,5,9)
call HGT_OLR(G2H9(40),6,15,9)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H9(40),[G2H9(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(179),[G2H6(118),G1H6(583),G1H6(375)])
call HGT_OLR(G2H9(41),1,1,9)
call HGT_invQ_OLR(G2H9(41),2,5,9)
call HGT_OLR(G2H9(41),6,15,9)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H9(41),[G2H9(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(183),[G2H6(122),G1H6(391),G1H6(199),G1H6(90)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(16),[G1H6(603)])
call HGT_OLR(G2H6(125),1,1,6)
call HGT_invQ_OLR(G2H6(125),2,5,6)
call HGT_OLR(G2H6(125),6,15,6)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(125),[G2H6(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H9(43),[G1H9(150)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(20),[G1H6(624)])
call HGT_OLR(G2H6(126),1,1,6)
call HGT_invQ_OLR(G2H6(126),2,5,6)
call HGT_OLR(G2H6(126),6,15,6)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(126),[G2H6(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H9(47),[G1H9(166)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(24),[G1H6(640)])
call HGT_OLR(G2H6(127),1,1,6)
call HGT_invQ_OLR(G2H6(127),2,5,6)
call HGT_OLR(G2H6(127),6,15,6)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(127),[G2H6(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H9(51),[G1H9(182)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(28),[G2H8(23),G2H8(15),G2H8(26),G2H8(2),G1H8(101) &
    ,G1H8(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(24),[G2H8(16),G2H8(9),G2H8(11),G1H8(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(25),[G2H8(20),G2H8(12),G2H8(18),G2H8(3),G1H8(69) &
    ,G1H8(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(27),[G2H8(17),G2H8(1),G2H8(14),G1H8(53)])
call HGT_OLR(G2H9(54),1,1,9)
call HGT_invQ_OLR(G2H9(54),2,5,9)
call HGT_OLR(G2H9(54),6,15,9)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H9(54),[G2H9(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(203),[G2H6(129),G1H6(657),G1H6(407)])
call HGT_OLR(G2H9(55),1,1,9)
call HGT_invQ_OLR(G2H9(55),2,5,9)
call HGT_OLR(G2H9(55),6,15,9)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H9(55),[G2H9(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(211),[G2H6(133),G1H6(689),G1H6(423)])
call HGT_OLR(G2H9(56),1,1,9)
call HGT_invQ_OLR(G2H9(56),2,5,9)
call HGT_OLR(G2H9(56),6,15,9)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H9(56),[G2H9(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(215),[G2H6(137),G1H6(439),G1H6(208),G1H6(121)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(21),[G2H8(13),G2H8(7),G2H8(22),G1H8(85)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(29),[G2H8(19),G2H8(10),G2H8(30),G1H8(117)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(3),[G1H6(688)])
call HGT_OLR(G2H6(141),1,1,6)
call HGT_invQ_OLR(G2H6(141),2,5,6)
call HGT_OLR(G2H6(141),6,15,6)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(141),[G2H6(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(142),[G1H6(455)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(55),[G1H6(656)])
call HGT_OLR(G2H6(146),1,1,6)
call HGT_invQ_OLR(G2H6(146),2,5,6)
call HGT_OLR(G2H6(146),6,15,6)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(146),[G2H6(55)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(147),[G1H6(471)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(28),[G1H6(672)])
call HGT_OLR(G2H6(151),1,1,6)
call HGT_invQ_OLR(G2H6(151),2,5,6)
call HGT_OLR(G2H6(151),6,15,6)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(151),[G2H6(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(152),[G1H6(487)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(8),[G1H12(79)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(24),[G1H12(46)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(13),[G1H12(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(25),[G1H12(88)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(10),[G1H6(582)])
call HGT_OLR(G2H6(156),1,1,6)
call HGT_invQ_OLR(G2H6(156),2,5,6)
call HGT_OLR(G2H6(156),6,15,6)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(156),[G2H6(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(195),[G2H6(157),G1H6(625),G1H6(503)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(217),[G1H6(550)])
call HGT_OLR(G2H6(161),1,1,6)
call HGT_invQ_OLR(G2H6(161),2,5,6)
call HGT_OLR(G2H6(161),6,15,6)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(161),[G2H6(217)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(187),[G2H6(162),G1H6(604),G1H6(519)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(59),[G1H6(566)])
call HGT_OLR(G2H6(166),1,1,6)
call HGT_invQ_OLR(G2H6(166),2,5,6)
call HGT_OLR(G2H6(166),6,15,6)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(166),[G2H6(59)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(191),[G2H6(167),G1H6(535),G1H6(217),G1H6(139)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(47),[G1H8(68)])
call HGT_OLR(G2H8(37),1,1,8)
call HGT_invQ_OLR(G2H8(37),2,5,8)
call HGT_OLR(G2H8(37),6,15,8)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(37),[G2H8(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(48),[G1H8(84)])
call HGT_OLR(G2H8(38),1,1,8)
call HGT_invQ_OLR(G2H8(38),2,5,8)
call HGT_OLR(G2H8(38),6,15,8)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(38),[G2H8(48)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(8),[G1H8(100)])
call HGT_OLR(G2H8(39),1,1,8)
call HGT_invQ_OLR(G2H8(39),2,5,8)
call HGT_OLR(G2H8(39),6,15,8)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(39),[G2H8(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(5),[G1H8(116)])
call HGT_OLR(G2H8(40),1,1,8)
call HGT_invQ_OLR(G2H8(40),2,5,8)
call HGT_OLR(G2H8(40),6,15,8)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(40),[G2H8(5)])
call HGT_OLR(G2H12(33),1,1,12)
call HGT_invQ_OLR(G2H12(33),2,5,12)
call HGT_OLR(G2H12(33),6,15,12)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(33),[G2H12(55)])
call HGT_OLR(G2H12(34),1,1,12)
call HGT_invQ_OLR(G2H12(34),2,5,12)
call HGT_OLR(G2H12(34),6,15,12)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(34),[G2H12(56)])
call HGT_OLR(G2H12(35),1,1,12)
call HGT_invQ_OLR(G2H12(35),2,5,12)
call HGT_OLR(G2H12(35),6,15,12)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(35),[G2H12(52)])
call HGT_OLR(G2H12(36),1,1,12)
call HGT_invQ_OLR(G2H12(36),2,5,12)
call HGT_OLR(G2H12(36),6,15,12)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(36),[G2H12(53)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(78),[G1H6(207),G1H6(21)])
call HGT_w2_OLR(G1H6(38),1,1,6)
call HGT_w2_invQ_OLR(G1H6(38),2,5,6)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(38),[G1H6(78)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(38),[G1H12(102)])
call HGT_lower_alpha_OLR(G2H18(26),1,1,18)
call HGT_lower_alpha_invQ_OLR(G2H18(26),2,5,18)
call HGT_lower_alpha_OLR(G2H18(26),6,15,18)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H18(26),[G2H18(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(57),[G2H12(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(79),[G1H6(216),G1H6(142)])
call HGT_w2_OLR(G1H6(42),1,1,6)
call HGT_w2_invQ_OLR(G1H6(42),2,5,6)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(42),[G1H6(79)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H18(29),[G1H18(59)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(85),[G1H6(113),G1H6(108)])
call HGT_w2_OLR(G1H6(43),1,1,6)
call HGT_w2_invQ_OLR(G1H6(43),2,5,6)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(43),[G1H6(85)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(60),[G2H12(46),G1H12(118)])
call HGT_lower_alpha_OLR(G2H18(21),1,1,18)
call HGT_lower_alpha_invQ_OLR(G2H18(21),2,5,18)
call HGT_lower_alpha_OLR(G2H18(21),6,15,18)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H18(21),[G2H18(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(59),[G2H12(50)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(27),[G1H6(25)])
call HGT_w2_OLR(G1H6(44),1,1,6)
call HGT_w2_invQ_OLR(G1H6(44),2,5,6)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(44),[G1H6(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H18(24),[G1H18(174)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H18(52),[G1H18(19)])
call HGT_w2_OLR(G1H18(65),1,1,18)
call HGT_w2_invQ_OLR(G1H18(65),2,5,18)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H18(65),[G1H18(52)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H18(32),[G1H18(190)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H18(53),[G1H18(54)])
call HGT_w2_OLR(G1H18(5),1,1,18)
call HGT_w2_invQ_OLR(G1H18(5),2,5,18)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H18(5),[G1H18(53)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H18(36),[G1H18(206)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H18(69),[G1H18(42)])
call HGT_w2_OLR(G1H18(15),1,1,18)
call HGT_w2_invQ_OLR(G1H18(15),2,5,18)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H18(15),[G1H18(69)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H18(40),[G1H18(222)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H18(10),[G1H18(112)])
call HGT_w2_OLR(G1H18(22),1,1,18)
call HGT_w2_invQ_OLR(G1H18(22),2,5,18)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H18(22),[G1H18(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H18(56),[G1H18(120)])
call HGT_w2_OLR(G1H18(23),1,1,18)
call HGT_w2_invQ_OLR(G1H18(23),2,5,18)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H18(23),[G1H18(56)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H18(9),[G1H18(127)])
call HGT_w2_OLR(G1H18(27),1,1,18)
call HGT_w2_invQ_OLR(G1H18(27),2,5,18)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H18(27),[G1H18(9)])
call HGT_lower_alpha_OLR(G2H18(46),1,1,18)
call HGT_lower_alpha_invQ_OLR(G2H18(46),2,5,18)
call HGT_lower_alpha_OLR(G2H18(46),6,15,18)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H18(46),[G2H18(33)])
call HGT_lower_alpha_OLR(G2H18(47),1,1,18)
call HGT_lower_alpha_invQ_OLR(G2H18(47),2,5,18)
call HGT_lower_alpha_OLR(G2H18(47),6,15,18)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H18(47),[G2H18(34)])
call HGT_lower_alpha_OLR(G2H18(48),1,1,18)
call HGT_lower_alpha_invQ_OLR(G2H18(48),2,5,18)
call HGT_lower_alpha_OLR(G2H18(48),6,15,18)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H18(48),[G2H18(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(63),[G2H12(58),G1H12(134)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(49),[G2H8(32),G2H8(31),G2H8(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(61),[G2H12(62),G1H12(150)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(52),[G2H8(51),G2H8(50),G2H8(46)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(38),[G1H4(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(40),[G1H4(83),G1H4(78),G1H4(69),G1H4(53),G1H4(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(56),[G1H4(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(66),[G1H4(28),G1H4(90),G1H4(39),G1H4(62),G1H4(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(190),[G1H6(53),G1H6(55)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(276),[G1H6(196),G1H6(56)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(195),[G1H6(189),G1H6(102)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(68),[G1H6(103)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(52),[G1H4(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(80),[G1H6(246),G1H6(107)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(261),[G1H6(105)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H9(82),[G1H9(57),G1H9(44)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(275),[G1H6(46)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(315),[G1H6(310),G1H6(155)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(353),[G1H6(323),G1H6(160)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(311),[G1H6(292),G1H6(176)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(316),[G1H6(297),G1H6(177)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(354),[G1H6(349),G1H6(181)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(324),[G1H6(319),G1H6(182)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(77),[G1H4(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(82),[G1H4(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(89),[G1H4(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(84),[G1H4(48)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(61),[G1H4(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(397),[G1H6(203)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(445),[G1H6(212)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(541),[G1H6(221)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(679),[G1H6(232)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(647),[G1H6(242)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(196),[G1H6(251),G1H6(245)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(573),[G1H6(257)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(197),[G1H6(266),G1H6(260)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H9(23),[G1H9(62),G1H9(56)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(189),[G1H6(285),G1H6(279)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(296),[G1H6(291)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(38),[G1H4(70),G1H4(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(81),[G1H4(76)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(32),[G1H12(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(49),[G1H12(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(36),[G1H12(54)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H18(3),[G1H18(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H18(16),[G1H18(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H18(53),[G1H18(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H18(165),[G1H18(67)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H18(4),[G1H18(70)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H18(166),[G1H18(76)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H18(49),[G1H18(78)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H18(168),[G1H18(84)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H18(55),[G1H18(85)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H18(169),[G1H18(91)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H18(37),[G1H18(92)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H18(50),[G1H18(98)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H18(13),[G1H18(99)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H18(51),[G1H18(105)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H18(1),[G1H18(106)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H18(38),[G1H18(114)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H18(10),[G1H18(121)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H18(23),[G1H18(128)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(55),[G1H12(73)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(348),[G1H6(318)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(88),[G1H4(41)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(684),[G1H6(329)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(652),[G1H6(334)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(578),[G1H6(339)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H9(6),[G1H9(101)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H9(8),[G1H9(117)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H9(11),[G1H9(133)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(198),[G1H6(358)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(557),[G1H6(365)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(562),[G1H6(370)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(200),[G1H6(374)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(589),[G1H6(381)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(594),[G1H6(386)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(201),[G1H6(390)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(599),[G1H6(402)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H9(21),[G1H9(149)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H9(27),[G1H9(165)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H9(29),[G1H9(181)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(41),[G1H8(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(107),[G1H8(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(112),[G1H8(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(43),[G1H8(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(44),[G1H8(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(75),[G1H8(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(80),[G1H8(48)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(45),[G1H8(52)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(202),[G1H6(406)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(663),[G1H6(413)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(668),[G1H6(418)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(204),[G1H6(422)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(695),[G1H6(429)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(700),[G1H6(434)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(205),[G1H6(438)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(705),[G1H6(450)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(206),[G1H6(454)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(208),[G1H6(470)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(209),[G1H6(486)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(37),[G1H12(78)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(39),[G1H12(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(40),[G1H12(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(41),[G1H12(87)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(210),[G1H6(502)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(631),[G1H6(509)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(636),[G1H6(514)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(212),[G1H6(518)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(610),[G1H6(525)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(615),[G1H6(530)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(213),[G1H6(534)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(620),[G1H6(546)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(43),[G1H12(101)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H18(28),[G1H18(64)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(45),[G1H12(117)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H18(18),[G1H18(173)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H18(20),[G1H18(189)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H18(22),[G1H18(205)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H18(25),[G1H18(221)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(49),[G1H12(133)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(51),[G1H12(149)])
  call Hloop_AQ_V(ntryL,G2H4(42),ex1(:),G2H2(2),m3h2x2(:,111),heltab2x4(:,:,123))
  call Hloop_AQ_V(ntryL,G2H4(79),ex1(:),G2H2(3),m3h2x2(:,112),heltab2x4(:,:,124))
  call Hloop_QA_V(ntryL,G2H4(52),ex2(:),G2H2(5),m3h2x2(:,113),heltab2x4(:,:,125))
  call Hloop_QA_V(ntryL,G2H4(64),ex2(:),G2H2(6),m3h2x2(:,114),heltab2x4(:,:,126))



end subroutine vamp_5

end module ol_vamp_5_ppwwtt_ttxwwxgg_1_/**/REALKIND
