
module ol_vamp_3_ppwwtt_uuxttxwwx_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_3(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppwwtt_uuxttxwwx_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppwwtt_uuxttxwwx_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_ppwwtt_uuxttxwwx_1_/**/DREALKIND
  use ol_tensor_sum_storage_ppwwtt_uuxttxwwx_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_ppwwtt_uuxttxwwx_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_ppwwtt_uuxttxwwx_1_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL, hel_states
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(hel_states)
  type(Hpolcont), intent(in) :: M(2,hel_states)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel(1:hel_states)
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel(1:hel_states)
#endif

  ! =============================================
  call Hloop_QV_A(ntryL,G0H144(1),wf36(:,13),G0H4(1),m3h36x4(:,118),heltab2x144(:,:,315))
  call Hloop_Q_A(ntryL,G0H4(1),51,nMT,G1H4(86),n2h4(124))
  Gcoeff(:)%j = (-(c(58)*M(1,:)%j)+c(57)*M(2,:)%j) * den(175)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(316),h0tab(:,316),[51,12],[0,0],2,2,wf36(:,13),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H144(1),wf36(:,13),G0H4(1),m3h36x4(:,119),heltab2x144(:,:,316))
  call Hloop_Q_A(ntryL,G0H4(1),51,0,G1H4(87),n2h4(125))
  Gcoeff(:)%j = (-(c(56)*M(1,:)%j)+c(55)*M(2,:)%j) * den(175)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(317),h0tab(:,317),[51,12],[nMB,nMB],2,2,wf36(:,13),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H144(1),wf36(:,13),G0H4(1),m3h36x4(:,120),heltab2x144(:,:,317))
  call Hloop_Q_A(ntryL,G0H4(1),51,nMB,G1H4(88),n2h4(126))
  Gcoeff(:)%j = (-(c(72)*M(1,:)%j)+c(71)*M(2,:)%j) * den(176)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(318),h0tab(:,318),[51,12],[0,0],2,2,wf36(:,14),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H144(1),wf36(:,14),G0H4(1),m3h36x4(:,121),heltab2x144(:,:,318))
  call Hloop_Q_A(ntryL,G0H4(1),51,0,G1H4(89),n2h4(127))
  Gcoeff(:)%j = (-(c(70)*M(1,:)%j)+c(69)*M(2,:)%j) * den(176)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(319),h0tab(:,319),[51,12],[nMT,nMT],2,2,wf36(:,14),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H144(1),wf36(:,14),G0H4(1),m3h36x4(:,122),heltab2x144(:,:,319))
  call Hloop_Q_A(ntryL,G0H4(1),51,nMT,G1H4(90),n2h4(128))
  Gcoeff(:)%j = (-(c(72)*M(1,:)%j)+c(71)*M(2,:)%j) * den(176)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(320),h0tab(:,320),[51,12],[0,0],2,2,wf36(:,14),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H144(1),wf36(:,14),G0H4(1),m3h36x4(:,123),heltab2x144(:,:,320))
  call Hloop_Q_A(ntryL,G0H4(1),51,0,G1H4(91),n2h4(129))
  Gcoeff(:)%j = (-(c(70)*M(1,:)%j)+c(69)*M(2,:)%j) * den(176)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(321),h0tab(:,321),[51,12],[nMB,nMB],2,2,wf36(:,14),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H144(1),wf36(:,14),G0H4(1),m3h36x4(:,124),heltab2x144(:,:,321))
  call Hloop_Q_A(ntryL,G0H4(1),51,nMB,G1H4(92),n2h4(130))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)+c(10)*M(2,:)%j) * den(175)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(322),h0tab(:,322),[51,12],[0,0],2,2,wf36(:,13),wf4(:,2))
  call Hloop_CV_D(ntryL,G0H144(1),0,wf36(:,13),51,G1H4(93),m3h36x4(:,125),heltab2x144(:,:,322))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j)+c(49)*M(2,:)%j) * den(176)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(323),h0tab(:,323),[51,12],[0,0],2,2,wf36(:,14),wf4(:,2))
  call Hloop_CV_D(ntryL,G0H144(1),0,wf36(:,14),51,G1H4(94),m3h36x4(:,126),heltab2x144(:,:,323))
  Gcoeff(:)%j = (c(4)*M(1,:)%j-c(3)*M(2,:)%j) * den(175)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(324),h0tab(:,324),[51,12],[0,0],2,2,wf36(:,13),wf4(:,2))
  call Hloop_UV_W(ntryL,G0H144(1),0,wf36(:,13),51,G1H4(95),m3h36x4(:,127),heltab2x144(:,:,324))
  Gcoeff(:)%j = (c(43)*M(1,:)%j-c(42)*M(2,:)%j) * den(176)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(325),h0tab(:,325),[51,12],[0,0],2,2,wf36(:,14),wf4(:,2))
  call Hloop_UV_W(ntryL,G0H144(1),0,wf36(:,14),51,G1H4(96),m3h36x4(:,128),heltab2x144(:,:,325))
  Gcoeff(:)%j = (c(12)*M(1,:)%j-c(8)*M(2,:)%j) * den(123)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(326),h0tab(:,326),[50,13],[0,0],2,2,wf18(:,42),wf8(:,8))
  call Hloop_VA_Q(ntryL,G0H144(1),wf18(:,42),G0H8(1),m3h18x8(:,67),heltab2x144(:,:,326))
  call Hloop_A_Q(ntryL,G0H8(1),50,0,G1H8(6),n2h8(34))
  Gcoeff(:)%j = (c(51)*M(1,:)%j-c(47)*M(2,:)%j) * den(124)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(327),h0tab(:,327),[50,13],[0,0],2,2,wf18(:,43),wf8(:,8))
  call Hloop_VA_Q(ntryL,G0H144(1),wf18(:,43),G0H8(8),m3h18x8(:,68),heltab2x144(:,:,327))
  call Hloop_A_Q(ntryL,G0H8(8),50,0,G1H8(12),n2h8(35))
  Gcoeff(:)%j = (c(12)*M(1,:)%j-c(8)*M(2,:)%j) * den(125)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(328),h0tab(:,328),[49,14],[0,0],2,2,wf18(:,17),wf8(:,6))
  call Hloop_AQ_V(ntryL,G0H144(1),wf18(:,17),G0H8(15),m3h18x8(:,69),heltab2x144(:,:,328))
  Gcoeff(:)%j = (c(51)*M(1,:)%j-c(47)*M(2,:)%j) * den(126)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(329),h0tab(:,329),[49,14],[0,0],2,2,wf18(:,19),wf8(:,6))
  call Hloop_AQ_V(ntryL,G0H144(1),wf18(:,19),G0H8(16),m3h18x8(:,70),heltab2x144(:,:,329))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(13),[G1H6(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(15),[G1H4(47),G1H4(1),G1H4(40),G1H4(29),G1H4(4),G1H4(10) &
    ,G1H4(2),G1H4(48),G1H4(11),G1H4(34),G1H4(7),G1H4(9),G1H4(17),G1H4(8),G1H4(49),G1H4(35),G1H4(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(12),[G1H4(44),G1H4(19),G1H4(30),G1H4(6),G1H4(14),G1H4(3) &
    ,G1H4(46),G1H4(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(43),[G1H4(25),G1H4(24),G1H4(20),G1H4(50),G1H4(31) &
    ,G1H4(27),G1H4(42),G1H4(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(52),[G1H4(51),G1H4(32),G1H4(37),G1H4(33),G1H4(28) &
    ,G1H4(26),G1H4(38),G1H4(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(54),[G1H4(53),G1H4(36),G1H4(45),G1H4(41),G1H4(21) &
    ,G1H4(18),G1H4(23),G1H4(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(5),[G1H8(7),G1H8(3),G1H8(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(9),[G0H8(4),G0H8(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(91),[G1H4(89),G1H4(87),G1H4(85),G1H4(79),G1H4(77) &
    ,G1H4(75),G1H4(73),G1H4(69),G1H4(67),G1H4(63),G1H4(61),G1H4(57),G1H4(55)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(90),[G1H4(86),G1H4(78),G1H4(74),G1H4(68),G1H4(62) &
    ,G1H4(56)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(92),[G1H4(88),G1H4(80),G1H4(76),G1H4(70),G1H4(64) &
    ,G1H4(58)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(94),[G1H4(93),G1H4(82),G1H4(81),G1H4(71),G1H4(65) &
    ,G1H4(59)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(96),[G1H4(95),G1H4(84),G1H4(83),G1H4(72),G1H4(66) &
    ,G1H4(60)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(12),[G1H6(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(12),[G1H8(6),G1H8(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(16),[G0H8(15)])
  call Hloop_VQ_A(ntryL,G0H24(7),wf24(:,7),G0H1(1),m3h24x1(:,5),heltab2x24(:,:,43))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),63,nMB,G1tensor(1),n2h1(376))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H6(13),wf6(:,3),G1tensor(31),m3h6x1(:,41),heltab2x6(:,:,90))
  call Hloop_QV_A(ntryL,G1H4(15),wf4(:,1),G1H1(1),m3h4x1(:,66),heltab2x4(:,:,89))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(106),n2h1(377))
  call Hloop_QV_A(ntryL,G1H4(12),wf4(:,1),G1H1(1),m3h4x1(:,67),heltab2x4(:,:,90))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(223),n2h1(378))
  call Hloop_QV_A(ntryL,G1H4(43),wf4(:,1),G1H1(1),m3h4x1(:,68),heltab2x4(:,:,91))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(175),n2h1(379))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H4(52),60,wf4(:,1),3,G2tensor(229),m3h4x1(:,69),heltab2x4(:,:,92))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(54),60,wf4(:,1),3,G2tensor(131),m3h4x1(:,70),heltab2x4(:,:,93))
  call Hcheck_last_QA_V(ntryL,l_switch,G1H8(10),wf8(:,2),G1tensor(61),m3h8x1(:,4),heltab2x8(:,:,28))
  call Hloop_VQ_A(ntryL,G0H24(8),wf24(:,13),G0H1(1),m3h24x1(:,6),heltab2x24(:,:,44))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),63,nMB,G1tensor(91),n2h1(380))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H8(5),wf8(:,4),G1tensor(121),m3h8x1(:,5),heltab2x8(:,:,29))
  call Hloop_VA_Q(ntryL,G0H8(9),wf8(:,2),G0H1(1),m3h8x1(:,6),heltab2x8(:,:,30))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),63,nMT,G1tensor(151),n2h1(381))
  call Hloop_QV_A(ntryL,G1H4(91),wf4(:,2),G1H1(1),m3h4x1(:,71),heltab2x4(:,:,94))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(132),n2h1(382))
  call Hloop_QV_A(ntryL,G1H4(90),wf4(:,2),G1H1(1),m3h4x1(:,72),heltab2x4(:,:,95))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(133),n2h1(383))
  call Hloop_QV_A(ntryL,G1H4(92),wf4(:,2),G1H1(1),m3h4x1(:,73),heltab2x4(:,:,96))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(69),n2h1(384))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H4(94),51,wf4(:,2),12,G2tensor(9),m3h4x1(:,74),heltab2x4(:,:,97))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(96),51,wf4(:,2),12,G2tensor(70),m3h4x1(:,75),heltab2x4(:,:,98))
  call Hloop_VQ_A(ntryL,G0H24(9),wf24(:,11),G0H1(1),m3h24x1(:,7),heltab2x24(:,:,45))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),63,0,G1tensor(181),n2h1(385))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H6(12),wf6(:,7),G1tensor(8),m3h6x1(:,42),heltab2x6(:,:,91))
  call Hcheck_last_QA_V(ntryL,l_switch,G1H8(13),wf8(:,6),G1tensor(62),m3h8x1(:,7),heltab2x8(:,:,31))
  call Hloop_VQ_A(ntryL,G0H24(1),wf24(:,17),G0H1(1),m3h24x1(:,8),heltab2x24(:,:,46))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),63,0,G1tensor(9),n2h1(386))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H8(12),wf8(:,8),G1tensor(110),m3h8x1(:,8),heltab2x8(:,:,32))
  call Hloop_VA_Q(ntryL,G0H8(16),wf8(:,6),G0H1(1),m3h8x1(:,9),heltab2x8(:,:,33))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),63,0,G1tensor(108),n2h1(387))
  call ol_merge_tensors(G2tensor(175),[G0tensor(189),G0tensor(366),G0tensor(236),G0tensor(240),G0tensor(15)])
  call ol_merge_tensors(G0tensor(48),[G0tensor(43),G0tensor(469),G0tensor(180),G0tensor(20)])
  call ol_merge_tensors(G0tensor(459),[G0tensor(246),G0tensor(210),G0tensor(25)])
  call ol_merge_tensors(G0tensor(601),[G0tensor(596),G0tensor(591),G0tensor(585),G0tensor(579),G0tensor(574),G0tensor(569) &
    ,G0tensor(564),G0tensor(559),G0tensor(554),G0tensor(549),G0tensor(544),G0tensor(539),G0tensor(534),G0tensor(529),G0tensor(524) &
    ,G0tensor(519),G0tensor(514),G0tensor(509),G0tensor(504),G0tensor(499),G0tensor(452),G0tensor(413),G0tensor(412),G0tensor(363) &
    ,G0tensor(367),G0tensor(328),G0tensor(468),G0tensor(463),G0tensor(302),G0tensor(308),G0tensor(292),G0tensor(287),G0tensor(422) &
    ,G0tensor(203),G0tensor(377),G0tensor(183),G0tensor(402),G0tensor(173),G0tensor(127),G0tensor(171),G0tensor(191),G0tensor(354) &
    ,G0tensor(164),G0tensor(58),G0tensor(156),G0tensor(102),G0tensor(129),G0tensor(124),G0tensor(33),G0tensor(111),G0tensor(162) &
    ,G0tensor(22),G0tensor(13),G0tensor(21),G0tensor(476),G0tensor(446),G0tensor(342),G0tensor(213),G0tensor(209),G0tensor(142) &
    ,G0tensor(49),G0tensor(19),G0tensor(484),G0tensor(257),G0tensor(494),G0tensor(149),G0tensor(24),G0tensor(88),G0tensor(219) &
    ,G0tensor(383),G0tensor(182),G0tensor(480),G0tensor(6),G0tensor(465),G0tensor(435),G0tensor(345),G0tensor(315),G0tensor(255) &
    ,G0tensor(225),G0tensor(195),G0tensor(130),G0tensor(105),G0tensor(60),G0tensor(30)])
  call ol_merge_tensors(G0tensor(590),[G0tensor(584),G0tensor(493),G0tensor(462),G0tensor(198),G0tensor(386),G0tensor(176) &
    ,G0tensor(77),G0tensor(192),G0tensor(112),G0tensor(52),G0tensor(47),G0tensor(114),G0tensor(28),G0tensor(152),G0tensor(471) &
    ,G0tensor(457),G0tensor(441),G0tensor(394),G0tensor(391),G0tensor(174),G0tensor(214),G0tensor(451),G0tensor(76),G0tensor(371) &
    ,G0tensor(475),G0tensor(5),G0tensor(460),G0tensor(430),G0tensor(340),G0tensor(310),G0tensor(285),G0tensor(260),G0tensor(230) &
    ,G0tensor(200),G0tensor(35)])
  call ol_merge_tensors(G0tensor(547),[G0tensor(506),G0tensor(338),G0tensor(122),G0tensor(57),G0tensor(212),G0tensor(12) &
    ,G0tensor(415),G0tensor(325),G0tensor(115),G0tensor(95),G0tensor(45)])
  call ol_merge_tensors(G2tensor(131),[G2tensor(229),G2tensor(106),G0tensor(432),G0tensor(163),G0tensor(281),G0tensor(271) &
    ,G0tensor(339),G0tensor(228),G0tensor(97),G0tensor(96),G0tensor(270),G0tensor(150),G0tensor(50)])
  call ol_merge_tensors(G1tensor(61),[G0tensor(361),G0tensor(351),G0tensor(239),G0tensor(295),G0tensor(100),G0tensor(55)])
  call ol_merge_tensors(G0tensor(536),[G0tensor(527),G0tensor(512),G0tensor(483),G0tensor(337),G0tensor(206),G0tensor(157) &
    ,G0tensor(72),G0tensor(349),G0tensor(166),G0tensor(17),G0tensor(253),G0tensor(251),G0tensor(477),G0tensor(395),G0tensor(165) &
    ,G0tensor(140),G0tensor(70)])
  call ol_merge_tensors(G2tensor(70),[G2tensor(9),G2tensor(132),G0tensor(208),G0tensor(126),G0tensor(41),G0tensor(362) &
    ,G0tensor(37),G0tensor(411),G0tensor(223),G0tensor(434),G0tensor(158),G0tensor(108),G0tensor(44),G0tensor(355),G0tensor(160) &
    ,G0tensor(75)])
  call ol_merge_tensors(G1tensor(108),[G1tensor(62),G0tensor(573),G0tensor(553),G0tensor(333),G0tensor(267),G0tensor(464) &
    ,G0tensor(258),G0tensor(375),G0tensor(170),G0tensor(80)])
  call ol_merge_tensors(G2tensor(223),[G0tensor(204),G0tensor(83),G0tensor(144),G0tensor(94),G0tensor(218),G0tensor(445) &
    ,G0tensor(90)])
  call ol_merge_tensors(G0tensor(551),[G0tensor(447),G0tensor(393),G0tensor(347),G0tensor(323),G0tensor(232),G0tensor(406) &
    ,G0tensor(234),G0tensor(99),G0tensor(118),G0tensor(2),G0tensor(120)])
  call ol_merge_tensors(G2tensor(133),[G0tensor(104),G0tensor(79),G0tensor(264),G0tensor(489),G0tensor(8),G0tensor(215) &
    ,G0tensor(185),G0tensor(125)])
  call ol_merge_tensors(G0tensor(561),[G0tensor(532),G0tensor(516),G0tensor(497),G0tensor(453),G0tensor(423),G0tensor(187) &
    ,G0tensor(177),G0tensor(314),G0tensor(62),G0tensor(326),G0tensor(426),G0tensor(238),G0tensor(229),G0tensor(168),G0tensor(147) &
    ,G0tensor(490),G0tensor(145)])
  call ol_merge_tensors(G0tensor(324),[G0tensor(341),G0tensor(245),G0tensor(190)])
  call ol_merge_tensors(G0tensor(321),[G0tensor(116),G0tensor(241),G0tensor(250),G0tensor(220)])
  call ol_merge_tensors(G0tensor(487),[G0tensor(448),G0tensor(233),G0tensor(420),G0tensor(300),G0tensor(275)])
  call ol_merge_tensors(G1tensor(91),[G1tensor(1),G0tensor(188),G0tensor(87),G0tensor(242),G0tensor(4),G0tensor(330) &
    ,G0tensor(280)])
  call ol_merge_tensors(G0tensor(389),[G0tensor(311),G0tensor(381),G0tensor(263),G0tensor(470),G0tensor(455),G0tensor(335) &
    ,G0tensor(305)])
  call ol_merge_tensors(G1tensor(8),[G0tensor(507),G0tensor(502),G0tensor(38),G0tensor(456),G0tensor(146),G0tensor(380) &
    ,G0tensor(360)])
  call ol_merge_tensors(G1tensor(9),[G1tensor(181),G0tensor(472),G0tensor(307),G0tensor(357),G0tensor(101),G0tensor(216) &
    ,G0tensor(400),G0tensor(365)])
  call ol_merge_tensors(G0tensor(418),[G0tensor(313),G0tensor(396),G0tensor(491),G0tensor(221),G0tensor(29),G0tensor(405) &
    ,G0tensor(385)])
  call ol_merge_tensors(G0tensor(296),[G0tensor(306),G0tensor(450),G0tensor(425)])
  call ol_merge_tensors(G0tensor(61),[G0tensor(479),G0tensor(9),G0tensor(3)])
  call ol_merge_tensors(G0tensor(42),[G0tensor(309),G0tensor(91),G0tensor(482)])
  call ol_merge_tensors(G0tensor(46),[G0tensor(92),G0tensor(226),G0tensor(141)])
  call ol_merge_tensors(G1tensor(31),[G0tensor(89),G0tensor(248),G0tensor(231)])
  call ol_merge_tensors(G0tensor(31),[G0tensor(416),G0tensor(222)])
  call ol_merge_tensors(G2tensor(69),[G0tensor(56),G0tensor(53),G0tensor(134),G0tensor(179),G0tensor(133),G0tensor(252)])
  call ol_merge_tensors(G0tensor(178),[G0tensor(67),G0tensor(317),G0tensor(34),G0tensor(98),G0tensor(398)])
  call ol_merge_tensors(G0tensor(543),[G0tensor(523),G0tensor(376),G0tensor(196),G0tensor(81),G0tensor(478),G0tensor(64) &
    ,G0tensor(227),G0tensor(39),G0tensor(419),G0tensor(392)])
  call ol_merge_tensors(G1tensor(110),[G0tensor(568),G0tensor(548),G0tensor(373),G0tensor(303),G0tensor(74),G0tensor(172) &
    ,G0tensor(237),G0tensor(128),G0tensor(409)])
  call ol_merge_tensors(G0tensor(578),[G0tensor(558),G0tensor(368),G0tensor(428),G0tensor(286),G0tensor(481),G0tensor(113) &
    ,G0tensor(444),G0tensor(148),G0tensor(78),G0tensor(217)])
  call ol_merge_tensors(G0tensor(567),[G0tensor(526),G0tensor(501),G0tensor(496),G0tensor(272),G0tensor(404),G0tensor(18) &
    ,G0tensor(316),G0tensor(259),G0tensor(449),G0tensor(54),G0tensor(454)])
  call ol_merge_tensors(G1tensor(121),[G0tensor(533),G0tensor(513),G0tensor(11),G0tensor(153),G0tensor(249)])
  call ol_merge_tensors(G1tensor(151),[G0tensor(538),G0tensor(518),G0tensor(382),G0tensor(424)])
  call ol_merge_tensors(G0tensor(599),[G0tensor(594),G0tensor(121),G0tensor(109),G0tensor(486),G0tensor(106),G0tensor(103) &
    ,G0tensor(224)])
  call ol_merge_tensors(G0tensor(131),[G0tensor(461),G0tensor(184)])
  call ol_merge_tensors(G0tensor(588),[G0tensor(582),G0tensor(139),G0tensor(32),G0tensor(466),G0tensor(312),G0tensor(436) &
    ,G0tensor(194)])
  call ol_merge_tensors(G0tensor(571),[G0tensor(562),G0tensor(288),G0tensor(268),G0tensor(207),G0tensor(201),G0tensor(26) &
    ,G0tensor(23),G0tensor(279),G0tensor(86),G0tensor(387)])
  call ol_merge_tensors(G0tensor(557),[G0tensor(552),G0tensor(117),G0tensor(68),G0tensor(154),G0tensor(161)])
  call ol_merge_tensors(G0tensor(581),[G0tensor(556),G0tensor(546),G0tensor(442),G0tensor(266),G0tensor(159)])
  call ol_merge_tensors(G0tensor(583),[G0tensor(467),G0tensor(107),G0tensor(269)])
  call ol_merge_tensors(G0tensor(598),[G0tensor(378),G0tensor(343),G0tensor(384),G0tensor(186),G0tensor(167),G0tensor(137)])
  call ol_merge_tensors(G0tensor(587),[G0tensor(417),G0tensor(473),G0tensor(353),G0tensor(318),G0tensor(181),G0tensor(364)])
  call ol_merge_tensors(G0tensor(589),[G0tensor(492),G0tensor(197),G0tensor(379)])
  call ol_merge_tensors(G0tensor(522),[G0tensor(517),G0tensor(332),G0tensor(273),G0tensor(282),G0tensor(401)])
  call ol_merge_tensors(G0tensor(593),[G0tensor(521),G0tensor(511),G0tensor(498),G0tensor(438),G0tensor(433)])
  call ol_merge_tensors(G0tensor(595),[G0tensor(503),G0tensor(322),G0tensor(283)])
  call ol_merge_tensors(G0tensor(600),[G0tensor(508),G0tensor(408),G0tensor(388)])
  call ol_merge_tensors(G0tensor(577),[G0tensor(572),G0tensor(541),G0tensor(531),G0tensor(528)])
  call ol_merge_tensors(G0tensor(576),[G0tensor(566),G0tensor(563),G0tensor(542),G0tensor(537)])
call TI_bubble_red(G2tensor(175),60,mass2set(:,1),G0tensor(10),M2L1R1,G0tensor(40))
call TI_bubble_red(G2tensor(131),60,mass2set(:,2),G0tensor(65),M2L1R1)
call TI_bubble_red(G2tensor(70),51,mass2set(:,2),G0tensor(85),M2L1R1)
call TI_bubble_red(G2tensor(223),60,mass2set(:,3),G0tensor(110),M2L1R1,G0tensor(135))
call TI_bubble_red(G2tensor(133),51,mass2set(:,3),G0tensor(155),M2L1R1,G0tensor(175))
call TI_bubble_red(G2tensor(69),51,mass2set(:,1),G0tensor(205),M2L1R1,G0tensor(235))
  call ol_merge_tensors(G0tensor(235),[G0tensor(590),G0tensor(40)])
  call ol_merge_tensors(G0tensor(175),[G0tensor(135),G0tensor(601)])
call TI_bubble_red(G1tensor(61),52,mass2set(:,4),G0tensor(265),M2L1R1,G0tensor(290))
call TI_bubble_red(G1tensor(108),49,mass2set(:,2),G0tensor(320),M2L1R1)
call TI_bubble_red(G1tensor(91),40,mass2set(:,5),G0tensor(350),M2L1R1,G0tensor(370))
call TI_bubble_red(G1tensor(8),46,mass2set(:,2),G0tensor(390),M2L1R1)
call TI_bubble_red(G1tensor(9),34,mass2set(:,2),G0tensor(410),M2L1R1)
call TI_bubble_red(G1tensor(31),43,mass2set(:,6),G0tensor(440),M2L1R1,G0tensor(1))
call TI_bubble_red(G1tensor(110),50,mass2set(:,2),G0tensor(7),M2L1R1)
call TI_bubble_red(G1tensor(121),56,mass2set(:,4),G0tensor(485),M2L1R1,G0tensor(211))
call TI_bubble_red(G1tensor(151),52,mass2set(:,7),G0tensor(14),M2L1R1,G0tensor(59))
  call ol_merge_tensors(G0tensor(1),[G0tensor(370),G0tensor(235)])
  call ol_merge_tensors(G0tensor(59),[G0tensor(211),G0tensor(290),G0tensor(175)])
  call ol_merge_tensors(T0sum(227),[G0tensor(10)])
  call ol_merge_tensors(T0sum(228),[G0tensor(1)])
  call ol_merge_tensors(T0sum(229),[G0tensor(48)])
  call ol_merge_tensors(T0sum(230),[G0tensor(459)])
  call ol_merge_tensors(T0sum(231),[G0tensor(59)])
  call ol_merge_tensors(T0sum(232),[G0tensor(547)])
  call ol_merge_tensors(T0sum(233),[G0tensor(65)])
  call ol_merge_tensors(T0sum(234),[G0tensor(265)])
  call ol_merge_tensors(T0sum(235),[G0tensor(536)])
  call ol_merge_tensors(T0sum(236),[G0tensor(85)])
  call ol_merge_tensors(T0sum(237),[G0tensor(320)])
  call ol_merge_tensors(T0sum(238),[G0tensor(110)])
  call ol_merge_tensors(T0sum(239),[G0tensor(551)])
  call ol_merge_tensors(T0sum(240),[G0tensor(155)])
  call ol_merge_tensors(T0sum(241),[G0tensor(561)])
  call ol_merge_tensors(T0sum(242),[G0tensor(324)])
  call ol_merge_tensors(T0sum(243),[G0tensor(321)])
  call ol_merge_tensors(T0sum(244),[G0tensor(487)])
  call ol_merge_tensors(T0sum(245),[G0tensor(350)])
  call ol_merge_tensors(T0sum(246),[G0tensor(389)])
  call ol_merge_tensors(T0sum(247),[G0tensor(390)])
  call ol_merge_tensors(T0sum(248),[G0tensor(410)])
  call ol_merge_tensors(T0sum(249),[G0tensor(418)])
  call ol_merge_tensors(T0sum(250),[G0tensor(296)])
  call ol_merge_tensors(T0sum(251),[G0tensor(61)])
  call ol_merge_tensors(T0sum(252),[G0tensor(42)])
  call ol_merge_tensors(T0sum(253),[G0tensor(46)])
  call ol_merge_tensors(T0sum(254),[G0tensor(440)])
  call ol_merge_tensors(T0sum(255),[G0tensor(31)])
  call ol_merge_tensors(T0sum(256),[G0tensor(205)])
  call ol_merge_tensors(T0sum(257),[G0tensor(178)])
  call ol_merge_tensors(T0sum(258),[G0tensor(543)])
  call ol_merge_tensors(T0sum(259),[G0tensor(7)])
  call ol_merge_tensors(T0sum(260),[G0tensor(578)])
  call ol_merge_tensors(T0sum(261),[G0tensor(567)])
  call ol_merge_tensors(T0sum(262),[G0tensor(485)])
  call ol_merge_tensors(T0sum(263),[G0tensor(14)])
  call ol_merge_tensors(T0sum(264),[G0tensor(599)])
  call ol_merge_tensors(T0sum(265),[G0tensor(131)])
  call ol_merge_tensors(T0sum(266),[G0tensor(588)])
  call ol_merge_tensors(T0sum(267),[G0tensor(571)])
  call ol_merge_tensors(T0sum(268),[G0tensor(557)])
  call ol_merge_tensors(T0sum(269),[G0tensor(581)])
  call ol_merge_tensors(T0sum(270),[G0tensor(583)])
  call ol_merge_tensors(T0sum(271),[G0tensor(598)])
  call ol_merge_tensors(T0sum(272),[G0tensor(587)])
  call ol_merge_tensors(T0sum(273),[G0tensor(589)])
  call ol_merge_tensors(T0sum(274),[G0tensor(522)])
  call ol_merge_tensors(T0sum(275),[G0tensor(593)])
  call ol_merge_tensors(T0sum(276),[G0tensor(595)])
  call ol_merge_tensors(T0sum(277),[G0tensor(600)])
  call ol_merge_tensors(T0sum(278),[G0tensor(577)])
  call ol_merge_tensors(T0sum(279),[G0tensor(576)])


! Compute scalar Master integrals 

  call compute_scalar_box([ 42, 43, 47 ],masses2_33,RedSet_4(1),ScalarBoxes(1))
  call compute_scalar_box([ 40, 43, 47 ],masses2_33,RedSet_4(2),ScalarBoxes(2))
  call compute_scalar_box([ 40, 42, 47 ],masses2_33,RedSet_4(3),ScalarBoxes(3))
  call compute_scalar_box([ 40, 42, 43 ],masses2_30,RedSet_4(4),ScalarBoxes(4))
  call compute_scalar_box([ 2, 3, 7 ],masses2_32,RedSet_4(5),ScalarBoxes(5))
  call compute_scalar_box([ 32, 43, 47 ],masses2_47,RedSet_4(6),ScalarBoxes(6))
  call compute_scalar_box([ 32, 42, 47 ],masses2_47,RedSet_4(7),ScalarBoxes(7))
  call compute_scalar_box([ 32, 42, 43 ],masses2_45,RedSet_4(8),ScalarBoxes(8))
  call compute_scalar_box([ 10, 11, 15 ],masses2_34,RedSet_4(9),ScalarBoxes(9))
  call compute_scalar_box([ 32, 40, 47 ],masses2_47,RedSet_4(10),ScalarBoxes(10))
  call compute_scalar_box([ 32, 40, 43 ],masses2_45,RedSet_4(11),ScalarBoxes(11))
  call compute_scalar_box([ 8, 11, 15 ],masses2_34,RedSet_4(12),ScalarBoxes(12))
  call compute_scalar_box([ 32, 40, 42 ],masses2_45,RedSet_4(13),ScalarBoxes(13))
  call compute_scalar_box([ 8, 10, 15 ],masses2_34,RedSet_4(14),ScalarBoxes(14))
  call compute_scalar_box([ 8, 10, 11 ],masses2_31,RedSet_4(15),ScalarBoxes(15))
  call compute_scalar_box([ 41, 43, 47 ],masses2_33,RedSet_4(16),ScalarBoxes(16))
  call compute_scalar_box([ 40, 41, 47 ],masses2_33,RedSet_4(17),ScalarBoxes(17))
  call compute_scalar_box([ 40, 41, 43 ],masses2_30,RedSet_4(18),ScalarBoxes(18))
  call compute_scalar_box([ 1, 3, 7 ],masses2_32,RedSet_4(19),ScalarBoxes(19))
  call compute_scalar_box([ 32, 41, 47 ],masses2_47,RedSet_4(20),ScalarBoxes(20))
  call compute_scalar_box([ 32, 41, 43 ],masses2_45,RedSet_4(21),ScalarBoxes(21))
  call compute_scalar_box([ 9, 11, 15 ],masses2_34,RedSet_4(22),ScalarBoxes(22))
  call compute_scalar_box([ 32, 40, 41 ],masses2_45,RedSet_4(23),ScalarBoxes(23))
  call compute_scalar_box([ 8, 9, 15 ],masses2_34,RedSet_4(24),ScalarBoxes(24))
  call compute_scalar_box([ 8, 9, 11 ],masses2_31,RedSet_4(25),ScalarBoxes(25))
  call compute_scalar_box([ 42, 46, 47 ],masses2_44,RedSet_4(26),ScalarBoxes(26))
  call compute_scalar_box([ 34, 46, 47 ],masses2_29,RedSet_4(27),ScalarBoxes(27))
  call compute_scalar_box([ 34, 42, 47 ],masses2_35,RedSet_4(28),ScalarBoxes(28))
  call compute_scalar_box([ 34, 42, 46 ],masses2_35,RedSet_4(29),ScalarBoxes(29))
  call compute_scalar_box([ 8, 12, 13 ],masses2_44,RedSet_4(30),ScalarBoxes(30))
  call compute_scalar_box([ 32, 46, 47 ],masses2_29,RedSet_4(31),ScalarBoxes(31))
  call compute_scalar_box([ 32, 42, 47 ],masses2_35,RedSet_4(7),ScalarBoxes(32))
  call compute_scalar_box([ 32, 42, 46 ],masses2_35,RedSet_4(32),ScalarBoxes(33))
  call compute_scalar_box([ 10, 14, 15 ],masses2_44,RedSet_4(33),ScalarBoxes(34))
  call compute_scalar_box([ 32, 34, 47 ],masses2_29,RedSet_4(34),ScalarBoxes(35))
  call compute_scalar_box([ 32, 34, 46 ],masses2_29,RedSet_4(35),ScalarBoxes(36))
  call compute_scalar_box([ 2, 14, 15 ],masses2_29,RedSet_4(36),ScalarBoxes(37))
  call compute_scalar_box([ 32, 34, 42 ],masses2_32,RedSet_4(37),ScalarBoxes(38))
  call compute_scalar_box([ 2, 10, 15 ],masses2_35,RedSet_4(38),ScalarBoxes(39))
  call compute_scalar_box([ 2, 10, 14 ],masses2_35,RedSet_4(39),ScalarBoxes(40))
  call compute_scalar_box([ 38, 46, 47 ],masses2_44,RedSet_4(40),ScalarBoxes(41))
  call compute_scalar_box([ 34, 38, 47 ],masses2_35,RedSet_4(41),ScalarBoxes(42))
  call compute_scalar_box([ 34, 38, 46 ],masses2_35,RedSet_4(42),ScalarBoxes(43))
  call compute_scalar_box([ 4, 12, 13 ],masses2_44,RedSet_4(43),ScalarBoxes(44))
  call compute_scalar_box([ 32, 38, 47 ],masses2_35,RedSet_4(44),ScalarBoxes(45))
  call compute_scalar_box([ 32, 38, 46 ],masses2_35,RedSet_4(45),ScalarBoxes(46))
  call compute_scalar_box([ 6, 14, 15 ],masses2_44,RedSet_4(46),ScalarBoxes(47))
  call compute_scalar_box([ 32, 34, 38 ],masses2_32,RedSet_4(47),ScalarBoxes(48))
  call compute_scalar_box([ 2, 6, 15 ],masses2_35,RedSet_4(48),ScalarBoxes(49))
  call compute_scalar_box([ 2, 6, 14 ],masses2_35,RedSet_4(49),ScalarBoxes(50))
  call compute_scalar_box([ 56, 58, 59 ],masses2_31,RedSet_4(55),ScalarBoxes(51))
  call compute_scalar_box([ 48, 58, 59 ],masses2_46,RedSet_4(56),ScalarBoxes(52))
  call compute_scalar_box([ 48, 56, 59 ],masses2_46,RedSet_4(57),ScalarBoxes(53))
  call compute_scalar_box([ 48, 56, 58 ],masses2_46,RedSet_4(58),ScalarBoxes(54))
  call compute_scalar_box([ 56, 57, 59 ],masses2_31,RedSet_4(59),ScalarBoxes(55))
  call compute_scalar_box([ 48, 57, 59 ],masses2_46,RedSet_4(60),ScalarBoxes(56))
  call compute_scalar_box([ 48, 56, 57 ],masses2_46,RedSet_4(61),ScalarBoxes(57))
  call compute_scalar_box([ 50, 58, 62 ],masses2_35,RedSet_4(62),ScalarBoxes(58))
  call compute_scalar_box([ 48, 58, 62 ],masses2_35,RedSet_4(63),ScalarBoxes(59))
  call compute_scalar_box([ 48, 50, 62 ],masses2_29,RedSet_4(64),ScalarBoxes(60))
  call compute_scalar_box([ 48, 50, 58 ],masses2_32,RedSet_4(65),ScalarBoxes(61))
  call compute_scalar_box([ 50, 54, 62 ],masses2_35,RedSet_4(66),ScalarBoxes(62))
  call compute_scalar_box([ 48, 54, 62 ],masses2_35,RedSet_4(67),ScalarBoxes(63))
  call compute_scalar_box([ 48, 50, 54 ],masses2_32,RedSet_4(68),ScalarBoxes(64))
  call compute_scalar_box([ 52, 53, 55 ],masses2_31,RedSet_4(69),ScalarBoxes(65))
  call compute_scalar_box([ 48, 53, 55 ],masses2_46,RedSet_4(70),ScalarBoxes(66))
  call compute_scalar_box([ 48, 52, 55 ],masses2_46,RedSet_4(71),ScalarBoxes(67))
  call compute_scalar_box([ 48, 52, 53 ],masses2_46,RedSet_4(72),ScalarBoxes(68))
  call compute_scalar_box([ 4, 5, 7 ],masses2_31,RedSet_4(73),ScalarBoxes(69))
  call compute_scalar_box([ 52, 54, 55 ],masses2_31,RedSet_4(74),ScalarBoxes(70))
  call compute_scalar_box([ 48, 54, 55 ],masses2_46,RedSet_4(75),ScalarBoxes(71))
  call compute_scalar_box([ 48, 52, 54 ],masses2_46,RedSet_4(76),ScalarBoxes(72))
  call compute_scalar_box([ 4, 6, 7 ],masses2_31,RedSet_4(77),ScalarBoxes(73))
  call compute_scalar_box([ 49, 53, 61 ],masses2_35,RedSet_4(78),ScalarBoxes(74))
  call compute_scalar_box([ 48, 53, 61 ],masses2_35,RedSet_4(79),ScalarBoxes(75))
  call compute_scalar_box([ 48, 49, 61 ],masses2_29,RedSet_4(80),ScalarBoxes(76))
  call compute_scalar_box([ 48, 49, 53 ],masses2_32,RedSet_4(81),ScalarBoxes(77))
  call compute_scalar_box([ 1, 5, 13 ],masses2_35,RedSet_4(82),ScalarBoxes(78))
  call compute_scalar_box([ 49, 57, 61 ],masses2_35,RedSet_4(83),ScalarBoxes(79))
  call compute_scalar_box([ 48, 57, 61 ],masses2_35,RedSet_4(84),ScalarBoxes(80))
  call compute_scalar_box([ 48, 49, 57 ],masses2_32,RedSet_4(85),ScalarBoxes(81))
  call compute_scalar_box([ 1, 9, 13 ],masses2_35,RedSet_4(86),ScalarBoxes(82))
  call compute_scalar_box([ 35, 51, 55 ],masses2_43,RedSet_4(87),ScalarBoxes(83))
  call compute_scalar_box([ 32, 51, 55 ],masses2_43,RedSet_4(88),ScalarBoxes(84))
  call compute_scalar_box([ 32, 35, 55 ],masses2_38,RedSet_4(89),ScalarBoxes(85))
  call compute_scalar_box([ 32, 35, 51 ],masses2_41,RedSet_4(50),ScalarBoxes(86))
  call compute_scalar_box([ 3, 19, 23 ],masses2_42,RedSet_4(90),ScalarBoxes(87))
  call compute_scalar_box([ 35, 43, 47 ],masses2_47,RedSet_4(91),ScalarBoxes(88))
  call compute_scalar_box([ 32, 35, 47 ],masses2_52,RedSet_4(92),ScalarBoxes(89))
  call compute_scalar_box([ 32, 35, 43 ],masses2_49,RedSet_4(51),ScalarBoxes(90))
  call compute_scalar_box([ 3, 11, 15 ],masses2_48,RedSet_4(93),ScalarBoxes(91))
  call compute_scalar_box([ 40, 44, 47 ],masses2_36,RedSet_4(94),ScalarBoxes(92))
  call compute_scalar_box([ 32, 44, 47 ],masses2_52,RedSet_4(95),ScalarBoxes(93))
  call compute_scalar_box([ 32, 40, 44 ],masses2_47,RedSet_4(52),ScalarBoxes(94))
  call compute_scalar_box([ 8, 12, 15 ],masses2_37,RedSet_4(96),ScalarBoxes(95))
  call compute_scalar_box([ 34, 35, 51 ],masses2_29,RedSet_4(97),ScalarBoxes(96))
  call compute_scalar_box([ 32, 35, 51 ],masses2_29,RedSet_4(50),ScalarBoxes(97))
  call compute_scalar_box([ 32, 34, 51 ],masses2_29,RedSet_4(98),ScalarBoxes(98))
  call compute_scalar_box([ 32, 34, 35 ],masses2_29,RedSet_4(53),ScalarBoxes(99))
  call compute_scalar_box([ 2, 3, 19 ],masses2_29,RedSet_4(99),ScalarBoxes(100))
  call compute_scalar_box([ 44, 46, 47 ],masses2_29,RedSet_4(100),ScalarBoxes(101))
  call compute_scalar_box([ 32, 44, 47 ],masses2_29,RedSet_4(95),ScalarBoxes(102))
  call compute_scalar_box([ 32, 44, 46 ],masses2_29,RedSet_4(54),ScalarBoxes(103))
  call compute_scalar_box([ 12, 14, 15 ],masses2_29,RedSet_4(101),ScalarBoxes(104))
  call compute_scalar_box([ 34, 35, 47 ],masses2_29,RedSet_4(102),ScalarBoxes(105))
  call compute_scalar_box([ 32, 35, 47 ],masses2_29,RedSet_4(92),ScalarBoxes(106))
  call compute_scalar_box([ 2, 3, 15 ],masses2_29,RedSet_4(103),ScalarBoxes(107))
! end of process


end subroutine vamp_3

end module ol_vamp_3_ppwwtt_uuxttxwwx_1_/**/REALKIND
