
module ol_vamp_1_ppwwtt_ttxwwxgg_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppwwtt_ttxwwxgg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppwwtt_ttxwwxgg_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_ppwwtt_ttxwwxgg_1_/**/DREALKIND
  use ol_tensor_sum_storage_ppwwtt_ttxwwxgg_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_ppwwtt_ttxwwxgg_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_ppwwtt_ttxwwxgg_1_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL, hel_states
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(hel_states)
  type(Hpolcont), intent(in) :: M(3,hel_states)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel(1:hel_states)
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel(1:hel_states)
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

  Gcoeff(:)%j = (-(c(19)*M(2,:)%j)+c(20)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(1),h0tab(:,1),[32,8,2,1,4,16],[nMB,nMT,0,nMT,nMB,nMB],6,0)
  call Hloop_QV_A(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,1),heltab2x144(:,:,1))
  call Hloop_Q_A(ntryL,G0H72(1),32,nMB,G1H72(1),n2h72(1))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)+c(20)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(2),h0tab(:,2),[32,4,1,2,8,16],[nMB,nMT,0,nMT,nMB,nMB],6,0)
  call Hloop_AV_Q(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,2),heltab2x144(:,:,2))
  call Hloop_A_Q(ntryL,G0H72(1),32,nMB,G1H72(2),n2h72(2))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)+c(20)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(3),h0tab(:,3),[32,8,4,1,2,16],[nMT,nMB,nMT,0,nMT,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,3),heltab2x144(:,:,3))
  call Hloop_A_Q(ntryL,G0H72(1),32,nMT,G1H72(3),n2h72(3))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)+c(20)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(4),h0tab(:,4),[32,4,1,2,16,8],[nMB,nMT,0,nMT,nMT,nMB],6,0)
  call Hloop_AV_Q(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,4),heltab2x144(:,:,4))
  call Hloop_A_Q(ntryL,G0H72(1),32,nMB,G1H72(4),n2h72(4))
  Gcoeff(:)%j = (-(c(19)*M(2,:)%j)+c(20)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(5),h0tab(:,5),[32,2,1,4,8,16],[nMT,0,nMT,nMB,nMT,nMT],6,0)
  call Hloop_QV_A(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,5),heltab2x144(:,:,5))
  call Hloop_Q_A(ntryL,G0H72(1),32,nMT,G1H72(5),n2h72(5))
  Gcoeff(:)%j = (-(c(19)*M(2,:)%j)+c(20)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(6),h0tab(:,6),[32,2,1,4,16,8],[nMT,0,nMT,nMB,nMB,nMT],6,0)
  call Hloop_QV_A(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,6),heltab2x144(:,:,6))
  call Hloop_Q_A(ntryL,G0H72(1),32,nMT,G1H72(6),n2h72(6))
  Gcoeff(:)%j = (-(c(19)*M(2,:)%j)+c(20)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(7),h0tab(:,7),[32,4,8,2,1,16],[nMT,nMB,nMT,0,nMT,nMT],6,0)
  call Hloop_QV_A(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,7),heltab2x144(:,:,7))
  call Hloop_Q_A(ntryL,G0H72(1),32,nMT,G1H72(7),n2h72(7))
  Gcoeff(:)%j = (-(c(19)*M(2,:)%j)+c(20)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(8),h0tab(:,8),[32,4,16,1,2,8],[nMB,nMT,nMT,0,nMT,nMB],6,0)
  call Hloop_AV_Q(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,8),heltab2x144(:,:,8))
  call Hloop_A_Q(ntryL,G0H72(1),32,nMB,G1H72(8),n2h72(8))
  Gcoeff(:)%j = (-(c(19)*M(2,:)%j)+c(20)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(9),h0tab(:,9),[32,2,1,16,4,8],[nMT,0,nMT,nMT,nMB,nMT],6,0)
  call Hloop_QV_A(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,9),heltab2x144(:,:,9))
  call Hloop_Q_A(ntryL,G0H72(1),32,nMT,G1H72(9),n2h72(9))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)+c(20)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(10),h0tab(:,10),[32,1,2,8,4,16],[nMT,0,nMT,nMB,nMT,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,10),heltab2x144(:,:,10))
  call Hloop_A_Q(ntryL,G0H72(1),32,nMT,G1H72(10),n2h72(10))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)+c(20)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(11),h0tab(:,11),[32,1,2,8,16,4],[nMT,0,nMT,nMB,nMB,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,11),heltab2x144(:,:,11))
  call Hloop_A_Q(ntryL,G0H72(1),32,nMT,G1H72(11),n2h72(11))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)+c(20)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(12),h0tab(:,12),[32,1,2,16,8,4],[nMT,0,nMT,nMT,nMB,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,12),heltab2x144(:,:,12))
  call Hloop_A_Q(ntryL,G0H72(1),32,nMT,G1H72(12),n2h72(12))
  Gcoeff(:)%j = (-(c(15)*M(3,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(13),h0tab(:,13),[32,4,1,16,2,8],[nMB,nMT,0,0,nMT,nMB],6,0)
  call Hloop_AV_Q(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,13),heltab2x144(:,:,13))
  call Hloop_A_Q(ntryL,G0H72(1),32,nMB,G1H72(13),n2h72(13))
  Gcoeff(:)%j = (c(22)*M(2,:)%j+c(20)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(14),h0tab(:,14),[32,2,8,4,1,16],[0,nMT,nMB,nMT,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H144(1),0,ex6(:),32,G1H72(14),m3h2x72(:,14),heltab2x144(:,:,14))
  Gcoeff(:)%j = (c(15)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(15),h0tab(:,15),[32,2,16,1,4,8],[nMT,0,0,nMT,nMB,nMT],6,0)
  call Hloop_QV_A(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,15),heltab2x144(:,:,15))
  call Hloop_Q_A(ntryL,G0H72(1),32,nMT,G1H72(15),n2h72(14))
  Gcoeff(:)%j = (c(22)*M(1,:)%j+c(20)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(16),h0tab(:,16),[32,1,4,8,2,16],[0,nMT,nMB,nMT,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H144(1),0,ex6(:),32,G1H72(16),m3h2x72(:,16),heltab2x144(:,:,16))
  Gcoeff(:)%j = (c(15)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(17),h0tab(:,17),[32,1,4,16,8,2],[0,nMT,nMB,nMB,nMT,0],6,0)
  call Hloop_UV_W(ntryL,G0H144(1),0,ex6(:),32,G1H72(17),m3h2x72(:,17),heltab2x144(:,:,17))
  Gcoeff(:)%j = (c(15)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(18),h0tab(:,18),[32,1,4,8,16,2],[0,nMT,nMB,nMT,nMT,0],6,0)
  call Hloop_UV_W(ntryL,G0H144(1),0,ex6(:),32,G1H72(18),m3h2x72(:,18),heltab2x144(:,:,18))
  Gcoeff(:)%j = (-(c(15)*M(3,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(19),h0tab(:,19),[32,1,16,2,8,4],[nMT,0,0,nMT,nMB,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,19),heltab2x144(:,:,19))
  call Hloop_A_Q(ntryL,G0H72(1),32,nMT,G1H72(19),n2h72(15))
  Gcoeff(:)%j = (c(15)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(20),h0tab(:,20),[32,1,16,4,8,2],[0,nMT,nMT,nMB,nMT,0],6,0)
  call Hloop_UV_W(ntryL,G0H144(1),0,ex6(:),32,G1H72(20),m3h2x72(:,20),heltab2x144(:,:,20))
  call Hloop_QW_A(ntryL,G1H72(1),ex4(:),G1H24(1),m3h3x24(:,1),heltab2x72(:,:,1))
  call Hloop_Q_A(ntryL,G1H24(1),40,nMT,G2H24(1),n2h24(1))
  call Hloop_AW_Q(ntryL,G1H72(2),ex3(:),G1H24(1),m3h3x24(:,2),heltab2x72(:,:,2))
  call Hloop_A_Q(ntryL,G1H24(1),36,nMT,G2H24(2),n2h24(2))
  call Hloop_AW_Q(ntryL,G1H72(3),ex4(:),G1H24(1),m3h3x24(:,3),heltab2x72(:,:,3))
  call Hloop_A_Q(ntryL,G1H24(1),40,nMB,G2H24(3),n2h24(3))
  call Hloop_AW_Q(ntryL,G1H72(4),ex3(:),G1H24(1),m3h3x24(:,4),heltab2x72(:,:,4))
  call Hloop_A_Q(ntryL,G1H24(1),36,nMT,G2H24(4),n2h24(4))
  call Hloop_QA_V(ntryL,G1H72(5),ex2(:),G1H36(1),m3h2x36(:,1),heltab2x72(:,:,5))
  call Hloop_QA_V(ntryL,G1H72(6),ex2(:),G1H36(2),m3h2x36(:,2),heltab2x72(:,:,6))
  call Hloop_QW_A(ntryL,G1H72(7),ex3(:),G1H24(1),m3h3x24(:,5),heltab2x72(:,:,7))
  call Hloop_Q_A(ntryL,G1H24(1),36,nMB,G2H24(5),n2h24(5))
  call Hloop_AW_Q(ntryL,G1H72(8),ex3(:),G1H24(1),m3h3x24(:,6),heltab2x72(:,:,8))
  call Hloop_A_Q(ntryL,G1H24(1),36,nMT,G2H24(6),n2h24(6))
  call Hloop_QA_V(ntryL,G1H72(9),ex2(:),G1H36(3),m3h2x36(:,3),heltab2x72(:,:,9))
  call Hloop_AQ_V(ntryL,G1H72(10),ex1(:),G1H36(4),m3h2x36(:,4),heltab2x72(:,:,10))
  call Hloop_AQ_V(ntryL,G1H72(11),ex1(:),G1H36(5),m3h2x36(:,5),heltab2x72(:,:,11))
  call Hloop_AQ_V(ntryL,G1H72(12),ex1(:),G1H36(6),m3h2x36(:,6),heltab2x72(:,:,12))
  call Hloop_AW_Q(ntryL,G1H72(13),ex3(:),G1H24(1),m3h3x24(:,7),heltab2x72(:,:,13))
  call Hloop_A_Q(ntryL,G1H24(1),36,nMT,G2H24(7),n2h24(7))
  call Hloop_VA_Q(ntryL,G1H72(14),ex2(:),G1H36(7),m3h2x36(:,7),heltab2x72(:,:,14))
  call Hloop_A_Q(ntryL,G1H36(7),34,nMT,G2H36(1),n2h36(1))
  call Hloop_QA_V(ntryL,G1H72(15),ex2(:),G1H36(7),m3h2x36(:,8),heltab2x72(:,:,15))
  call Hloop_VQ_A(ntryL,G1H72(16),ex1(:),G1H36(8),m3h2x36(:,9),heltab2x72(:,:,16))
  call Hloop_Q_A(ntryL,G1H36(8),33,nMT,G2H36(2),n2h36(2))
  call Hloop_VQ_A(ntryL,G1H72(17),ex1(:),G1H36(8),m3h2x36(:,10),heltab2x72(:,:,17))
  call Hloop_Q_A(ntryL,G1H36(8),33,nMT,G2H36(3),n2h36(3))
  call Hloop_VQ_A(ntryL,G1H72(18),ex1(:),G1H36(8),m3h2x36(:,11),heltab2x72(:,:,18))
  call Hloop_Q_A(ntryL,G1H36(8),33,nMT,G2H36(4),n2h36(4))
  call Hloop_AQ_V(ntryL,G1H72(19),ex1(:),G1H36(8),m3h2x36(:,12),heltab2x72(:,:,19))
  call Hloop_VQ_A(ntryL,G1H72(20),ex1(:),G1H36(9),m3h2x36(:,13),heltab2x72(:,:,20))
  call Hloop_Q_A(ntryL,G1H36(9),33,nMT,G2H36(5),n2h36(5))
  call Hloop_QA_V(ntryL,G2H24(1),ex2(:),G2H12(1),m3h2x12(:,1),heltab2x24(:,:,1))
  call Hloop_AQ_V(ntryL,G2H24(2),ex1(:),G2H12(2),m3h2x12(:,2),heltab2x24(:,:,2))
  call Hotf_5pt_reduction(G2H24(3),RedSet_5(1),mass5set(:,1),  & 
G1H24(1),G1H24(2),G1H24(3),G1H24(4),G1H24(5),G1H24(6),24)
  call HG1shiftOLR(G1H24(2),16,24)
  call Hloop_AQ_V(ntryL,G2H24(4),ex1(:),G2H12(3),m3h2x12(:,3),heltab2x24(:,:,3))
  call Hloop_VQ_A(ntryL,G1H36(1),ex1(:),G1H18(1),m3h2x18(:,1),heltab2x36(:,:,1))
  call Hloop_Q_A(ntryL,G1H18(1),35,nMT,G2H18(1),n2h18(1))
  call Hloop_VQ_A(ntryL,G1H36(2),ex1(:),G1H18(1),m3h2x18(:,2),heltab2x36(:,:,2))
  call Hloop_Q_A(ntryL,G1H18(1),35,nMT,G2H18(2),n2h18(2))
  call Hotf_5pt_reduction(G2H24(5),RedSet_5(2),mass5set(:,1),  & 
G1H24(7),G1H24(8),G1H24(9),G1H24(10),G1H24(11),G1H24(12),24)
  call HG1shiftOLR(G1H24(8),16,24)
  call Hotf_5pt_reduction(G2H24(6),RedSet_5(3),mass5set(:,2),  & 
G1H24(13),G1H24(14),G1H24(15),G1H24(16),G1H24(17),G1H24(18),24)
  call HG1shiftOLR(G1H24(14),8,24)
  call Hloop_VQ_A(ntryL,G1H36(3),ex1(:),G1H18(1),m3h2x18(:,3),heltab2x36(:,:,3))
  call Hloop_Q_A(ntryL,G1H18(1),35,nMT,G2H18(3),n2h18(3))
  call Hloop_VA_Q(ntryL,G1H36(4),ex2(:),G1H18(1),m3h2x18(:,4),heltab2x36(:,:,4))
  call Hloop_A_Q(ntryL,G1H18(1),35,nMT,G2H18(4),n2h18(4))
  call Hloop_VA_Q(ntryL,G1H36(5),ex2(:),G1H18(1),m3h2x18(:,5),heltab2x36(:,:,5))
  call Hloop_A_Q(ntryL,G1H18(1),35,nMT,G2H18(5),n2h18(5))
  call Hloop_VA_Q(ntryL,G1H36(6),ex2(:),G1H18(1),m3h2x18(:,6),heltab2x36(:,:,6))
  call Hloop_A_Q(ntryL,G1H18(1),35,nMT,G2H18(6),n2h18(6))
  call Hloop_AQ_V(ntryL,G2H24(7),ex1(:),G2H12(4),m3h2x12(:,4),heltab2x24(:,:,4))
  call Hotf_5pt_reduction(G2H36(1),RedSet_5(4),mass5set(:,3),  & 
G1H36(9),G1H36(1),G1H36(2),G1H36(3),G1H36(4),G1H36(5),36)
  call HG1shiftOLR(G1H36(1),16,36)
  call Hloop_UV_W(ntryL,G1H36(7),34,ex5(:),16,G2H18(7),m3h2x18(:,7),heltab2x36(:,:,7))
  call Hotf_5pt_reduction(G2H36(2),RedSet_5(5),mass5set(:,3),  & 
G1H36(6),G1H36(7),G1H36(10),G1H36(11),G1H36(12),G1H36(13),36)
  call HG1shiftOLR(G1H36(7),16,36)
  call Hotf_5pt_reduction(G2H36(3),RedSet_5(6),mass5set(:,4),  & 
G1H36(14),G1H36(15),G1H36(16),G1H36(17),G1H36(18),G1H36(19),36)
  call HG1shiftOLR(G1H36(15),2,36)
  call Hotf_5pt_reduction(G2H36(4),RedSet_5(5),mass5set(:,3),  & 
G1H36(20),G1H36(21),G1H36(22),G1H36(23),G1H36(24),G1H36(25),36)
  call HG1shiftOLR(G1H36(21),2,36)
  call Hloop_UV_W(ntryL,G1H36(8),33,ex5(:),16,G2H18(8),m3h2x18(:,8),heltab2x36(:,:,8))
  call Hotf_5pt_reduction(G2H36(5),RedSet_5(7),mass5set(:,5),  & 
G1H36(8),G1H36(26),G1H36(27),G1H36(28),G1H36(29),G1H36(30),36)
  call HG1shiftOLR(G1H36(26),2,36)
  call Hloop_AW_Q(ntryL,G1H24(1),ex3(:),G1H8(1),m3h3x8(:,1),heltab2x24(:,:,5))
  call Hloop_A_Q(ntryL,G1H8(1),44,nMT,G2H8(1),n2h8(1))
call HGT_OLR(G1H24(2),1,1,24)
call HGT_invQ_OLR(G1H24(2),2,5,24)
  call Hloop_Q_A(ntryL,G1H24(2),-16,nMT,G2H24(1),n2h24(8))
  call Hloop_QV_A(ntryL,G2H24(1),ex5(:),G2H12(5),m3h2x12(:,5),heltab2x24(:,:,6))
  call Hloop_AW_Q(ntryL,G1H24(4),ex3(:),G1H8(1),m3h3x8(:,2),heltab2x24(:,:,7))
  call Hloop_A_Q(ntryL,G1H8(1),44,nMT,G2H8(2),n2h8(2))
  call Hloop_AW_Q(ntryL,G1H24(5),ex3(:),G1H8(1),m3h3x8(:,3),heltab2x24(:,:,8))
  call Hloop_A_Q(ntryL,G1H8(1),44,nMT,G2H8(3),n2h8(3))
  call Hloop_AW_Q(ntryL,G1H24(6),ex3(:),G1H8(1),m3h3x8(:,4),heltab2x24(:,:,9))
  call Hloop_A_Q(ntryL,G1H8(1),44,nMT,G2H8(4),n2h8(4))
  call Hloop_QW_A(ntryL,G1H24(7),ex4(:),G1H8(1),m3h3x8(:,5),heltab2x24(:,:,10))
  call Hloop_Q_A(ntryL,G1H8(1),44,nMT,G2H8(5),n2h8(5))
call HGT_OLR(G1H24(8),1,1,24)
call HGT_invQ_OLR(G1H24(8),2,5,24)
  call Hloop_A_Q(ntryL,G1H24(8),-16,nMT,G2H24(2),n2h24(9))
  call Hloop_AV_Q(ntryL,G2H24(2),ex5(:),G2H12(6),m3h2x12(:,6),heltab2x24(:,:,11))
  call Hloop_QW_A(ntryL,G1H24(10),ex4(:),G1H8(1),m3h3x8(:,6),heltab2x24(:,:,12))
  call Hloop_Q_A(ntryL,G1H8(1),44,nMT,G2H8(6),n2h8(6))
  call Hloop_QW_A(ntryL,G1H24(11),ex4(:),G1H8(1),m3h3x8(:,7),heltab2x24(:,:,13))
  call Hloop_Q_A(ntryL,G1H8(1),44,nMT,G2H8(7),n2h8(7))
  call Hloop_QW_A(ntryL,G1H24(12),ex4(:),G1H8(1),m3h3x8(:,8),heltab2x24(:,:,14))
  call Hloop_Q_A(ntryL,G1H8(1),44,nMT,G2H8(8),n2h8(8))
  call Hloop_AV_Q(ntryL,G1H24(13),ex5(:),G1H12(1),m3h2x12(:,7),heltab2x24(:,:,15))
  call Hloop_A_Q(ntryL,G1H12(1),52,nMT,G2H12(7),n2h12(1))
call HGT_OLR(G1H24(14),1,1,24)
call HGT_invQ_OLR(G1H24(14),2,5,24)
  call Hloop_Q_A(ntryL,G1H24(14),-8,nMB,G2H24(3),n2h24(10))
  call Hloop_QW_A(ntryL,G2H24(3),ex4(:),G2H8(9),m3h3x8(:,9),heltab2x24(:,:,16))
  call Hloop_AV_Q(ntryL,G1H24(16),ex5(:),G1H12(1),m3h2x12(:,8),heltab2x24(:,:,17))
  call Hloop_A_Q(ntryL,G1H12(1),52,nMT,G2H12(8),n2h12(2))
  call Hloop_AV_Q(ntryL,G1H24(17),ex5(:),G1H12(1),m3h2x12(:,9),heltab2x24(:,:,18))
  call Hloop_A_Q(ntryL,G1H12(1),52,nMT,G2H12(9),n2h12(3))
  call Hloop_AV_Q(ntryL,G1H24(18),ex5(:),G1H12(1),m3h2x12(:,10),heltab2x24(:,:,19))
  call Hloop_A_Q(ntryL,G1H12(1),52,nMT,G2H12(10),n2h12(4))
  call Hloop_AW_Q(ntryL,G1H36(9),ex4(:),G1H12(1),m3h3x12(:,1),heltab2x36(:,:,9))
  call Hloop_A_Q(ntryL,G1H12(1),42,nMB,G2H12(11),n2h12(5))
call HGT_raise_alpha_OLR(G1H36(1),1,1,36)
call HGT_raise_alpha_invQ_OLR(G1H36(1),2,5,36)
  call Hloop_UV_W(ntryL,G1H36(1),-16,ex5(:),16,G2H18(9),m3h2x18(:,9),heltab2x36(:,:,10))
call signflip_OLR(G2H18(9))
  call Hloop_AW_Q(ntryL,G1H36(3),ex4(:),G1H12(1),m3h3x12(:,2),heltab2x36(:,:,11))
  call Hloop_A_Q(ntryL,G1H12(1),42,nMB,G2H12(12),n2h12(6))
  call Hloop_AW_Q(ntryL,G1H36(4),ex4(:),G1H12(1),m3h3x12(:,3),heltab2x36(:,:,12))
  call Hloop_A_Q(ntryL,G1H12(1),42,nMB,G2H12(13),n2h12(7))
  call Hloop_AW_Q(ntryL,G1H36(5),ex4(:),G1H12(1),m3h3x12(:,4),heltab2x36(:,:,13))
  call Hloop_A_Q(ntryL,G1H12(1),42,nMB,G2H12(14),n2h12(8))
  call Hloop_QW_A(ntryL,G1H36(6),ex3(:),G1H12(1),m3h3x12(:,5),heltab2x36(:,:,14))
  call Hloop_Q_A(ntryL,G1H12(1),37,nMB,G2H12(15),n2h12(9))
call HGT_raise_alpha_OLR(G1H36(7),1,1,36)
call HGT_raise_alpha_invQ_OLR(G1H36(7),2,5,36)
  call Hloop_UV_W(ntryL,G1H36(7),-16,ex5(:),16,G2H18(10),m3h2x18(:,10),heltab2x36(:,:,15))
call signflip_OLR(G2H18(10))
  call Hloop_QW_A(ntryL,G1H36(11),ex3(:),G1H12(1),m3h3x12(:,6),heltab2x36(:,:,16))
  call Hloop_Q_A(ntryL,G1H12(1),37,nMB,G2H12(16),n2h12(10))
  call Hloop_QW_A(ntryL,G1H36(12),ex3(:),G1H12(1),m3h3x12(:,7),heltab2x36(:,:,17))
  call Hloop_Q_A(ntryL,G1H12(1),37,nMB,G2H12(17),n2h12(11))
  call Hloop_QW_A(ntryL,G1H36(13),ex3(:),G1H12(1),m3h3x12(:,8),heltab2x36(:,:,18))
  call Hloop_Q_A(ntryL,G1H12(1),37,nMB,G2H12(18),n2h12(12))
  call Hloop_QW_A(ntryL,G1H36(14),ex3(:),G1H12(1),m3h3x12(:,9),heltab2x36(:,:,19))
  call Hloop_Q_A(ntryL,G1H12(1),37,nMB,G2H12(19),n2h12(13))
call HGT_raise_alpha_OLR(G1H36(15),1,1,36)
call HGT_raise_alpha_invQ_OLR(G1H36(15),2,5,36)
  call Hloop_VA_Q(ntryL,G1H36(15),ex2(:),G1H18(1),m3h2x18(:,11),heltab2x36(:,:,20))
  call Hloop_QW_A(ntryL,G1H36(17),ex3(:),G1H12(1),m3h3x12(:,10),heltab2x36(:,:,21))
  call Hloop_Q_A(ntryL,G1H12(1),37,nMB,G2H12(20),n2h12(14))
  call Hloop_QW_A(ntryL,G1H36(18),ex3(:),G1H12(1),m3h3x12(:,11),heltab2x36(:,:,22))
  call Hloop_Q_A(ntryL,G1H12(1),37,nMB,G2H12(21),n2h12(15))
  call Hloop_QW_A(ntryL,G1H36(19),ex3(:),G1H12(1),m3h3x12(:,12),heltab2x36(:,:,23))
  call Hloop_Q_A(ntryL,G1H12(1),37,nMB,G2H12(22),n2h12(16))
  call Hloop_QW_A(ntryL,G1H36(20),ex3(:),G1H12(1),m3h3x12(:,13),heltab2x36(:,:,24))
  call Hloop_Q_A(ntryL,G1H12(1),37,nMB,G2H12(23),n2h12(17))
call HGT_raise_alpha_OLR(G1H36(21),1,1,36)
call HGT_raise_alpha_invQ_OLR(G1H36(21),2,5,36)
  call Hloop_VA_Q(ntryL,G1H36(21),ex2(:),G1H18(2),m3h2x18(:,12),heltab2x36(:,:,25))
  call Hloop_QW_A(ntryL,G1H36(23),ex3(:),G1H12(1),m3h3x12(:,14),heltab2x36(:,:,26))
  call Hloop_Q_A(ntryL,G1H12(1),37,nMB,G2H12(24),n2h12(18))
  call Hloop_QW_A(ntryL,G1H36(24),ex3(:),G1H12(1),m3h3x12(:,15),heltab2x36(:,:,27))
  call Hloop_Q_A(ntryL,G1H12(1),37,nMB,G2H12(25),n2h12(19))
  call Hloop_QW_A(ntryL,G1H36(25),ex3(:),G1H12(1),m3h3x12(:,16),heltab2x36(:,:,28))
  call Hloop_Q_A(ntryL,G1H12(1),37,nMB,G2H12(26),n2h12(20))
  call Hloop_QV_A(ntryL,G1H36(8),ex5(:),G1H18(3),m3h2x18(:,13),heltab2x36(:,:,29))
  call Hloop_Q_A(ntryL,G1H18(3),49,nMT,G2H18(11),n2h18(7))
call HGT_raise_alpha_OLR(G1H36(26),1,1,36)
call HGT_raise_alpha_invQ_OLR(G1H36(26),2,5,36)
  call Hloop_VA_Q(ntryL,G1H36(26),ex2(:),G1H18(3),m3h2x18(:,14),heltab2x36(:,:,30))
  call Hloop_QV_A(ntryL,G1H36(28),ex5(:),G1H18(4),m3h2x18(:,15),heltab2x36(:,:,31))
  call Hloop_Q_A(ntryL,G1H18(4),49,nMT,G2H18(12),n2h18(8))
  call Hloop_QV_A(ntryL,G1H36(29),ex5(:),G1H18(4),m3h2x18(:,16),heltab2x36(:,:,32))
  call Hloop_Q_A(ntryL,G1H18(4),49,nMT,G2H18(13),n2h18(9))
  call Hloop_QV_A(ntryL,G1H36(30),ex5(:),G1H18(4),m3h2x18(:,17),heltab2x36(:,:,33))
  call Hloop_Q_A(ntryL,G1H18(4),49,nMT,G2H18(14),n2h18(10))
  call Hotf_5pt_reduction(G2H12(1),RedSet_5(8),mass5set(:,6),  & 
G1H12(1),G1H12(2),G1H12(3),G1H12(4),G1H12(5),G1H12(6),12)
  call HG1shiftOLR(G1H12(2),16,12)
  call Hotf_5pt_reduction(G2H12(2),RedSet_5(9),mass5set(:,6),  & 
G1H12(7),G1H12(8),G1H12(9),G1H12(10),G1H12(11),G1H12(12),12)
  call HG1shiftOLR(G1H12(8),16,12)
  call Hotf_5pt_reduction(G2H12(3),RedSet_5(9),mass5set(:,6),  & 
G1H12(13),G1H12(14),G1H12(15),G1H12(16),G1H12(17),G1H12(18),12)
  call HG1shiftOLR(G1H12(14),8,12)
  call Hotf_5pt_reduction(G2H18(1),RedSet_5(10),mass5set(:,7),  & 
G1H18(4),G1H18(5),G1H18(6),G1H18(7),G1H18(8),G1H18(9),18)
  call HG1shiftOLR(G1H18(5),16,18)
  call Hotf_5pt_reduction(G2H18(2),RedSet_5(10),mass5set(:,7),  & 
G1H18(10),G1H18(11),G1H18(12),G1H18(13),G1H18(14),G1H18(15),18)
  call HG1shiftOLR(G1H18(11),8,18)
  call Hotf_5pt_reduction(G2H18(3),RedSet_5(11),mass5set(:,8),  & 
G1H18(16),G1H18(17),G1H18(18),G1H18(19),G1H18(20),G1H18(21),18)
  call HG1shiftOLR(G1H18(17),8,18)
  call Hotf_5pt_reduction(G2H18(4),RedSet_5(12),mass5set(:,7),  & 
G1H18(22),G1H18(23),G1H18(24),G1H18(25),G1H18(26),G1H18(27),18)
  call HG1shiftOLR(G1H18(23),16,18)
  call Hotf_5pt_reduction(G2H18(5),RedSet_5(12),mass5set(:,7),  & 
G1H18(28),G1H18(29),G1H18(30),G1H18(31),G1H18(32),G1H18(33),18)
  call HG1shiftOLR(G1H18(29),4,18)
  call Hotf_5pt_reduction(G2H18(6),RedSet_5(13),mass5set(:,8),  & 
G1H18(34),G1H18(35),G1H18(36),G1H18(37),G1H18(38),G1H18(39),18)
  call HG1shiftOLR(G1H18(35),4,18)
  call Hotf_5pt_reduction(G2H12(4),RedSet_5(14),mass5set(:,9),  & 
G1H12(19),G1H12(20),G1H12(21),G1H12(22),G1H12(23),G1H12(24),12)
  call HG1shiftOLR(G1H12(20),8,12)
  call Hotf_5pt_reduction(G2H18(7),RedSet_5(15),mass5set(:,10),  & 
G1H18(40),G1H18(41),G1H18(42),G1H18(43),G1H18(44),G1H18(45),18)
  call HG1shiftOLR(G1H18(41),8,18)
  call Hotf_5pt_reduction(G2H18(8),RedSet_5(16),mass5set(:,10),  & 
G1H18(46),G1H18(47),G1H18(48),G1H18(49),G1H18(50),G1H18(51),18)
  call HG1shiftOLR(G1H18(47),4,18)
  call Hloop_AQ_V(ntryL,G2H8(1),ex1(:),G2H4(1),m3h2x4(:,1),heltab2x8(:,:,1))
  call Hloop_AQ_V(ntryL,G2H8(3),ex1(:),G2H4(2),m3h2x4(:,2),heltab2x8(:,:,2))
  call Hloop_AQ_V(ntryL,G2H8(4),ex1(:),G2H4(3),m3h2x4(:,3),heltab2x8(:,:,3))
  call Hloop_QA_V(ntryL,G2H8(5),ex2(:),G2H4(4),m3h2x4(:,4),heltab2x8(:,:,4))
  call Hloop_QA_V(ntryL,G2H8(7),ex2(:),G2H4(5),m3h2x4(:,5),heltab2x8(:,:,5))
  call Hloop_QA_V(ntryL,G2H8(8),ex2(:),G2H4(6),m3h2x4(:,6),heltab2x8(:,:,6))
  call Hloop_AQ_V(ntryL,G2H12(7),ex1(:),G2H6(1),m3h2x6(:,1),heltab2x12(:,:,1))
  call Hloop_AQ_V(ntryL,G2H12(9),ex1(:),G2H6(2),m3h2x6(:,2),heltab2x12(:,:,2))
  call Hloop_AQ_V(ntryL,G2H12(10),ex1(:),G2H6(3),m3h2x6(:,3),heltab2x12(:,:,3))
  call Hotf_5pt_reduction(G2H12(11),RedSet_5(4),mass5set(:,3),  & 
G1H12(25),G1H12(26),G1H12(27),G1H12(28),G1H12(29),G1H12(30),12)
  call HG1shiftOLR(G1H12(26),16,12)
  call Hotf_5pt_reduction(G2H12(13),RedSet_5(17),mass5set(:,11),  & 
G1H12(31),G1H12(32),G1H12(33),G1H12(34),G1H12(35),G1H12(36),12)
  call HG1shiftOLR(G1H12(32),16,12)
  call Hotf_5pt_reduction(G2H12(14),RedSet_5(18),mass5set(:,12),  & 
G1H12(37),G1H12(38),G1H12(39),G1H12(40),G1H12(41),G1H12(42),12)
  call HG1shiftOLR(G1H12(38),16,12)
  call Hotf_5pt_reduction(G2H12(15),RedSet_5(5),mass5set(:,3),  & 
G1H12(43),G1H12(44),G1H12(45),G1H12(46),G1H12(47),G1H12(48),12)
  call HG1shiftOLR(G1H12(44),16,12)
  call Hotf_5pt_reduction(G2H12(17),RedSet_5(19),mass5set(:,11),  & 
G1H12(49),G1H12(50),G1H12(51),G1H12(52),G1H12(53),G1H12(54),12)
  call HG1shiftOLR(G1H12(50),16,12)
  call Hotf_5pt_reduction(G2H12(18),RedSet_5(20),mass5set(:,12),  & 
G1H12(55),G1H12(56),G1H12(57),G1H12(58),G1H12(59),G1H12(60),12)
  call HG1shiftOLR(G1H12(56),16,12)
  call Hotf_5pt_reduction(G2H12(19),RedSet_5(6),mass5set(:,4),  & 
G1H12(61),G1H12(62),G1H12(63),G1H12(64),G1H12(65),G1H12(66),12)
  call HG1shiftOLR(G1H12(62),2,12)
  call Hotf_5pt_reduction(G2H12(21),RedSet_5(21),mass5set(:,3),  & 
G1H12(67),G1H12(68),G1H12(69),G1H12(70),G1H12(71),G1H12(72),12)
  call HG1shiftOLR(G1H12(68),2,12)
  call Hotf_5pt_reduction(G2H12(22),RedSet_5(22),mass5set(:,3),  & 
G1H12(73),G1H12(74),G1H12(75),G1H12(76),G1H12(77),G1H12(78),12)
  call HG1shiftOLR(G1H12(74),2,12)
  call Hotf_5pt_reduction(G2H12(23),RedSet_5(5),mass5set(:,3),  & 
G1H12(79),G1H12(80),G1H12(81),G1H12(82),G1H12(83),G1H12(84),12)
  call HG1shiftOLR(G1H12(80),2,12)
  call Hotf_5pt_reduction(G2H12(25),RedSet_5(23),mass5set(:,13),  & 
G1H12(85),G1H12(86),G1H12(87),G1H12(88),G1H12(89),G1H12(90),12)
  call HG1shiftOLR(G1H12(86),2,12)
  call Hotf_5pt_reduction(G2H12(26),RedSet_5(22),mass5set(:,3),  & 
G1H12(91),G1H12(92),G1H12(93),G1H12(94),G1H12(95),G1H12(96),12)
  call HG1shiftOLR(G1H12(92),2,12)
  call Hotf_5pt_reduction(G2H18(11),RedSet_5(7),mass5set(:,5),  & 
G1H18(52),G1H18(53),G1H18(54),G1H18(55),G1H18(56),G1H18(57),18)
  call HG1shiftOLR(G1H18(53),2,18)
  call Hotf_5pt_reduction(G2H18(13),RedSet_5(21),mass5set(:,3),  & 
G1H18(58),G1H18(59),G1H18(60),G1H18(61),G1H18(62),G1H18(63),18)
  call HG1shiftOLR(G1H18(59),2,18)
  call Hotf_5pt_reduction(G2H18(14),RedSet_5(24),mass5set(:,13),  & 
G1H18(64),G1H18(65),G1H18(66),G1H18(67),G1H18(68),G1H18(69),18)
  call HG1shiftOLR(G1H18(65),2,18)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(31),[G1H12(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(37),[G1H12(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(49),[G1H12(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(55),[G1H12(48)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(67),[G1H12(65)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(73),[G1H12(66)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(85),[G1H12(83)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(91),[G1H12(84)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H18(58),[G1H18(56)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H18(64),[G1H18(57)])
  call Hloop_VQ_A(ntryL,G1H12(1),ex1(:),G1H6(1),m3h2x6(:,4),heltab2x12(:,:,4))
  call Hloop_Q_A(ntryL,G1H6(1),43,nMT,G2H6(4),n2h6(1))
call HGT_OLR(G1H12(2),1,1,12)
call HGT_invQ_OLR(G1H12(2),2,5,12)
  call Hloop_A_Q(ntryL,G1H12(2),-16,nMB,G2H12(1),n2h12(21))
  call Hloop_AV_Q(ntryL,G2H12(1),ex5(:),G2H6(5),m3h2x6(:,5),heltab2x12(:,:,5))
  call Hloop_VQ_A(ntryL,G1H12(5),ex1(:),G1H6(1),m3h2x6(:,6),heltab2x12(:,:,6))
  call Hloop_Q_A(ntryL,G1H6(1),43,nMT,G2H6(6),n2h6(2))
  call Hloop_VQ_A(ntryL,G1H12(6),ex1(:),G1H6(1),m3h2x6(:,7),heltab2x12(:,:,7))
  call Hloop_Q_A(ntryL,G1H6(1),43,nMT,G2H6(7),n2h6(3))
  call Hloop_VA_Q(ntryL,G1H12(7),ex2(:),G1H6(1),m3h2x6(:,8),heltab2x12(:,:,8))
  call Hloop_A_Q(ntryL,G1H6(1),39,nMT,G2H6(8),n2h6(4))
call HGT_OLR(G1H12(8),1,1,12)
call HGT_invQ_OLR(G1H12(8),2,5,12)
  call Hloop_Q_A(ntryL,G1H12(8),-16,nMB,G2H12(2),n2h12(22))
  call Hloop_QV_A(ntryL,G2H12(2),ex5(:),G2H6(9),m3h2x6(:,9),heltab2x12(:,:,9))
  call Hloop_VA_Q(ntryL,G1H12(11),ex2(:),G1H6(1),m3h2x6(:,10),heltab2x12(:,:,10))
  call Hloop_A_Q(ntryL,G1H6(1),39,nMT,G2H6(10),n2h6(5))
  call Hloop_VA_Q(ntryL,G1H12(12),ex2(:),G1H6(1),m3h2x6(:,11),heltab2x12(:,:,11))
  call Hloop_A_Q(ntryL,G1H6(1),39,nMT,G2H6(11),n2h6(6))
  call Hloop_VA_Q(ntryL,G1H12(13),ex2(:),G1H6(1),m3h2x6(:,12),heltab2x12(:,:,12))
  call Hloop_A_Q(ntryL,G1H6(1),39,nMT,G2H6(12),n2h6(7))
call HGT_OLR(G1H12(14),1,1,12)
call HGT_invQ_OLR(G1H12(14),2,5,12)
  call Hloop_Q_A(ntryL,G1H12(14),-8,nMB,G2H12(3),n2h12(23))
  call Hloop_QW_A(ntryL,G2H12(3),ex4(:),G2H4(7),m3h3x4(:,1),heltab2x12(:,:,13))
  call Hloop_VA_Q(ntryL,G1H12(17),ex2(:),G1H6(1),m3h2x6(:,13),heltab2x12(:,:,14))
  call Hloop_A_Q(ntryL,G1H6(1),39,nMT,G2H6(13),n2h6(8))
  call Hloop_VA_Q(ntryL,G1H12(18),ex2(:),G1H6(1),m3h2x6(:,14),heltab2x12(:,:,15))
  call Hloop_A_Q(ntryL,G1H6(1),39,nMT,G2H6(14),n2h6(9))
  call Hloop_QW_A(ntryL,G1H18(4),ex3(:),G1H6(1),m3h3x6(:,1),heltab2x18(:,:,1))
  call Hloop_Q_A(ntryL,G1H6(1),39,nMB,G2H6(15),n2h6(10))
call HGT_OLR(G1H18(5),1,1,18)
call HGT_invQ_OLR(G1H18(5),2,5,18)
  call Hloop_A_Q(ntryL,G1H18(5),-16,nMT,G2H18(1),n2h18(11))
  call Hloop_AV_Q(ntryL,G2H18(1),ex5(:),G2H9(1),m3h2x9(:,1),heltab2x18(:,:,2))
  call Hloop_QW_A(ntryL,G1H18(8),ex3(:),G1H6(1),m3h3x6(:,2),heltab2x18(:,:,3))
  call Hloop_Q_A(ntryL,G1H6(1),39,nMB,G2H6(16),n2h6(11))
  call Hloop_QW_A(ntryL,G1H18(9),ex3(:),G1H6(1),m3h3x6(:,3),heltab2x18(:,:,4))
  call Hloop_Q_A(ntryL,G1H6(1),39,nMB,G2H6(17),n2h6(12))
  call Hloop_QW_A(ntryL,G1H18(10),ex3(:),G1H6(1),m3h3x6(:,4),heltab2x18(:,:,5))
  call Hloop_Q_A(ntryL,G1H6(1),39,nMB,G2H6(18),n2h6(13))
call HGT_OLR(G1H18(11),1,1,18)
call HGT_invQ_OLR(G1H18(11),2,5,18)
  call Hloop_A_Q(ntryL,G1H18(11),-8,nMT,G2H18(2),n2h18(12))
  call Hloop_AW_Q(ntryL,G2H18(2),ex4(:),G2H6(19),m3h3x6(:,5),heltab2x18(:,:,6))
  call Hloop_QW_A(ntryL,G1H18(14),ex3(:),G1H6(1),m3h3x6(:,6),heltab2x18(:,:,7))
  call Hloop_Q_A(ntryL,G1H6(1),39,nMB,G2H6(20),n2h6(14))
  call Hloop_QW_A(ntryL,G1H18(15),ex3(:),G1H6(1),m3h3x6(:,7),heltab2x18(:,:,8))
  call Hloop_Q_A(ntryL,G1H6(1),39,nMB,G2H6(21),n2h6(15))
  call Hloop_QV_A(ntryL,G1H18(16),ex5(:),G1H9(1),m3h2x9(:,2),heltab2x18(:,:,9))
  call Hloop_Q_A(ntryL,G1H9(1),51,nMT,G2H9(2),n2h9(1))
call HGT_OLR(G1H18(17),1,1,18)
call HGT_invQ_OLR(G1H18(17),2,5,18)
  call Hloop_A_Q(ntryL,G1H18(17),-8,nMT,G2H18(3),n2h18(13))
  call Hloop_AW_Q(ntryL,G2H18(3),ex4(:),G2H6(22),m3h3x6(:,8),heltab2x18(:,:,10))
  call Hloop_QV_A(ntryL,G1H18(20),ex5(:),G1H9(1),m3h2x9(:,3),heltab2x18(:,:,11))
  call Hloop_Q_A(ntryL,G1H9(1),51,nMT,G2H9(3),n2h9(2))
  call Hloop_QV_A(ntryL,G1H18(21),ex5(:),G1H9(1),m3h2x9(:,4),heltab2x18(:,:,12))
  call Hloop_Q_A(ntryL,G1H9(1),51,nMT,G2H9(4),n2h9(3))
  call Hloop_AW_Q(ntryL,G1H18(22),ex4(:),G1H6(1),m3h3x6(:,9),heltab2x18(:,:,13))
  call Hloop_A_Q(ntryL,G1H6(1),43,nMB,G2H6(23),n2h6(16))
call HGT_OLR(G1H18(23),1,1,18)
call HGT_invQ_OLR(G1H18(23),2,5,18)
  call Hloop_Q_A(ntryL,G1H18(23),-16,nMT,G2H18(4),n2h18(14))
  call Hloop_QV_A(ntryL,G2H18(4),ex5(:),G2H9(5),m3h2x9(:,5),heltab2x18(:,:,14))
  call Hloop_AW_Q(ntryL,G1H18(26),ex4(:),G1H6(1),m3h3x6(:,10),heltab2x18(:,:,15))
  call Hloop_A_Q(ntryL,G1H6(1),43,nMB,G2H6(24),n2h6(17))
  call Hloop_AW_Q(ntryL,G1H18(27),ex4(:),G1H6(1),m3h3x6(:,11),heltab2x18(:,:,16))
  call Hloop_A_Q(ntryL,G1H6(1),43,nMB,G2H6(25),n2h6(18))
  call Hloop_AW_Q(ntryL,G1H18(28),ex4(:),G1H6(1),m3h3x6(:,12),heltab2x18(:,:,17))
  call Hloop_A_Q(ntryL,G1H6(1),43,nMB,G2H6(26),n2h6(19))
call HGT_OLR(G1H18(29),1,1,18)
call HGT_invQ_OLR(G1H18(29),2,5,18)
  call Hloop_Q_A(ntryL,G1H18(29),-4,nMT,G2H18(5),n2h18(15))
  call Hloop_QW_A(ntryL,G2H18(5),ex3(:),G2H6(27),m3h3x6(:,13),heltab2x18(:,:,18))
  call Hloop_AW_Q(ntryL,G1H18(32),ex4(:),G1H6(1),m3h3x6(:,14),heltab2x18(:,:,19))
  call Hloop_A_Q(ntryL,G1H6(1),43,nMB,G2H6(28),n2h6(20))
  call Hloop_AW_Q(ntryL,G1H18(33),ex4(:),G1H6(1),m3h3x6(:,15),heltab2x18(:,:,20))
  call Hloop_A_Q(ntryL,G1H6(1),43,nMB,G2H6(29),n2h6(21))
  call Hloop_AV_Q(ntryL,G1H18(34),ex5(:),G1H9(1),m3h2x9(:,6),heltab2x18(:,:,21))
  call Hloop_A_Q(ntryL,G1H9(1),51,nMT,G2H9(6),n2h9(4))
call HGT_OLR(G1H18(35),1,1,18)
call HGT_invQ_OLR(G1H18(35),2,5,18)
  call Hloop_Q_A(ntryL,G1H18(35),-4,nMT,G2H18(6),n2h18(16))
  call Hloop_QW_A(ntryL,G2H18(6),ex3(:),G2H6(30),m3h3x6(:,16),heltab2x18(:,:,22))
  call Hloop_AV_Q(ntryL,G1H18(38),ex5(:),G1H9(1),m3h2x9(:,7),heltab2x18(:,:,23))
  call Hloop_A_Q(ntryL,G1H9(1),51,nMT,G2H9(7),n2h9(5))
  call Hloop_AV_Q(ntryL,G1H18(39),ex5(:),G1H9(1),m3h2x9(:,8),heltab2x18(:,:,24))
  call Hloop_A_Q(ntryL,G1H9(1),51,nMT,G2H9(8),n2h9(6))
  call Hloop_UV_W(ntryL,G1H12(19),37,ex5(:),16,G2H6(31),m3h2x6(:,15),heltab2x12(:,:,16))
call HGT_OLR(G1H12(20),1,1,12)
call HGT_invQ_OLR(G1H12(20),2,5,12)
  call Hloop_Q_A(ntryL,G1H12(20),-8,nMB,G2H12(4),n2h12(24))
  call Hloop_QW_A(ntryL,G2H12(4),ex4(:),G2H4(8),m3h3x4(:,2),heltab2x12(:,:,17))
  call Hloop_UV_W(ntryL,G1H12(23),37,ex5(:),16,G2H6(32),m3h2x6(:,16),heltab2x12(:,:,18))
  call Hloop_UV_W(ntryL,G1H12(24),37,ex5(:),16,G2H6(33),m3h2x6(:,17),heltab2x12(:,:,19))
  call Hloop_VQ_A(ntryL,G1H18(40),ex1(:),G1H9(1),m3h2x9(:,9),heltab2x18(:,:,25))
  call Hloop_Q_A(ntryL,G1H9(1),51,nMT,G2H9(9),n2h9(7))
call HGT_OLR(G1H18(41),1,1,18)
call HGT_invQ_OLR(G1H18(41),2,5,18)
  call Hloop_A_Q(ntryL,G1H18(41),-8,nMT,G2H18(7),n2h18(17))
  call Hloop_AW_Q(ntryL,G2H18(7),ex4(:),G2H6(34),m3h3x6(:,17),heltab2x18(:,:,26))
  call Hloop_VQ_A(ntryL,G1H18(44),ex1(:),G1H9(1),m3h2x9(:,10),heltab2x18(:,:,27))
  call Hloop_Q_A(ntryL,G1H9(1),51,nMT,G2H9(10),n2h9(8))
  call Hloop_VQ_A(ntryL,G1H18(45),ex1(:),G1H9(1),m3h2x9(:,11),heltab2x18(:,:,28))
  call Hloop_Q_A(ntryL,G1H9(1),51,nMT,G2H9(11),n2h9(9))
  call Hloop_VA_Q(ntryL,G1H18(46),ex2(:),G1H9(1),m3h2x9(:,12),heltab2x18(:,:,29))
  call Hloop_A_Q(ntryL,G1H9(1),51,nMT,G2H9(12),n2h9(10))
call HGT_OLR(G1H18(47),1,1,18)
call HGT_invQ_OLR(G1H18(47),2,5,18)
  call Hloop_Q_A(ntryL,G1H18(47),-4,nMT,G2H18(8),n2h18(18))
  call Hloop_QW_A(ntryL,G2H18(8),ex3(:),G2H6(35),m3h3x6(:,18),heltab2x18(:,:,30))
  call Hloop_VA_Q(ntryL,G1H18(50),ex2(:),G1H9(1),m3h2x9(:,13),heltab2x18(:,:,31))
  call Hloop_A_Q(ntryL,G1H9(1),51,nMT,G2H9(13),n2h9(11))
  call Hloop_VA_Q(ntryL,G1H18(51),ex2(:),G1H9(1),m3h2x9(:,14),heltab2x18(:,:,32))
  call Hloop_A_Q(ntryL,G1H9(1),51,nMT,G2H9(14),n2h9(12))
  call Hloop_AW_Q(ntryL,G1H12(25),ex3(:),G1H4(1),m3h3x4(:,3),heltab2x12(:,:,20))
  call Hloop_A_Q(ntryL,G1H4(1),46,nMT,G2H4(9),n2h4(1))
call HGT_raise_alpha_OLR(G1H12(26),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(26),2,5,12)
  call Hloop_UV_W(ntryL,G1H12(26),-16,ex5(:),16,G2H6(36),m3h2x6(:,18),heltab2x12(:,:,21))
call signflip_OLR(G2H6(36))
  call Hloop_AW_Q(ntryL,G1H12(31),ex3(:),G1H4(1),m3h3x4(:,4),heltab2x12(:,:,22))
  call Hloop_A_Q(ntryL,G1H4(1),46,nMT,G2H4(10),n2h4(2))
  call Hloop_AW_Q(ntryL,G1H12(37),ex3(:),G1H4(1),m3h3x4(:,5),heltab2x12(:,:,23))
  call Hloop_A_Q(ntryL,G1H4(1),46,nMT,G2H4(11),n2h4(3))
call HGT_raise_alpha_OLR(G1H12(32),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(32),2,5,12)
  call Hloop_UV_W(ntryL,G1H12(32),-16,ex5(:),16,G2H6(37),m3h2x6(:,19),heltab2x12(:,:,24))
call signflip_OLR(G2H6(37))
  call Hloop_AW_Q(ntryL,G1H12(35),ex3(:),G1H4(1),m3h3x4(:,6),heltab2x12(:,:,25))
  call Hloop_A_Q(ntryL,G1H4(1),46,nMT,G2H4(12),n2h4(4))
  call Hloop_AW_Q(ntryL,G1H12(36),ex3(:),G1H4(1),m3h3x4(:,7),heltab2x12(:,:,26))
  call Hloop_A_Q(ntryL,G1H4(1),46,nMT,G2H4(13),n2h4(5))
call HGT_raise_alpha_OLR(G1H12(38),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(38),2,5,12)
  call Hloop_UV_W(ntryL,G1H12(38),-16,ex5(:),16,G2H6(38),m3h2x6(:,20),heltab2x12(:,:,27))
call signflip_OLR(G2H6(38))
  call Hloop_AW_Q(ntryL,G1H12(41),ex3(:),G1H4(1),m3h3x4(:,8),heltab2x12(:,:,28))
  call Hloop_A_Q(ntryL,G1H4(1),46,nMT,G2H4(14),n2h4(6))
  call Hloop_AW_Q(ntryL,G1H12(42),ex3(:),G1H4(1),m3h3x4(:,9),heltab2x12(:,:,29))
  call Hloop_A_Q(ntryL,G1H4(1),46,nMT,G2H4(15),n2h4(7))
  call Hloop_QW_A(ntryL,G1H12(43),ex4(:),G1H4(1),m3h3x4(:,10),heltab2x12(:,:,30))
  call Hloop_Q_A(ntryL,G1H4(1),45,nMT,G2H4(16),n2h4(8))
call HGT_raise_alpha_OLR(G1H12(44),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(44),2,5,12)
  call Hloop_UV_W(ntryL,G1H12(44),-16,ex5(:),16,G2H6(39),m3h2x6(:,21),heltab2x12(:,:,31))
call signflip_OLR(G2H6(39))
  call Hloop_QW_A(ntryL,G1H12(49),ex4(:),G1H4(1),m3h3x4(:,11),heltab2x12(:,:,32))
  call Hloop_Q_A(ntryL,G1H4(1),45,nMT,G2H4(17),n2h4(9))
  call Hloop_QW_A(ntryL,G1H12(55),ex4(:),G1H4(1),m3h3x4(:,12),heltab2x12(:,:,33))
  call Hloop_Q_A(ntryL,G1H4(1),45,nMT,G2H4(18),n2h4(10))
call HGT_raise_alpha_OLR(G1H12(50),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(50),2,5,12)
  call Hloop_UV_W(ntryL,G1H12(50),-16,ex5(:),16,G2H6(40),m3h2x6(:,22),heltab2x12(:,:,34))
call signflip_OLR(G2H6(40))
  call Hloop_QW_A(ntryL,G1H12(53),ex4(:),G1H4(1),m3h3x4(:,13),heltab2x12(:,:,35))
  call Hloop_Q_A(ntryL,G1H4(1),45,nMT,G2H4(19),n2h4(11))
  call Hloop_QW_A(ntryL,G1H12(54),ex4(:),G1H4(1),m3h3x4(:,14),heltab2x12(:,:,36))
  call Hloop_Q_A(ntryL,G1H4(1),45,nMT,G2H4(20),n2h4(12))
call HGT_raise_alpha_OLR(G1H12(56),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(56),2,5,12)
  call Hloop_UV_W(ntryL,G1H12(56),-16,ex5(:),16,G2H6(41),m3h2x6(:,23),heltab2x12(:,:,37))
call signflip_OLR(G2H6(41))
  call Hloop_QW_A(ntryL,G1H12(59),ex4(:),G1H4(1),m3h3x4(:,15),heltab2x12(:,:,38))
  call Hloop_Q_A(ntryL,G1H4(1),45,nMT,G2H4(21),n2h4(13))
  call Hloop_QW_A(ntryL,G1H12(60),ex4(:),G1H4(1),m3h3x4(:,16),heltab2x12(:,:,39))
  call Hloop_Q_A(ntryL,G1H4(1),45,nMT,G2H4(22),n2h4(14))
  call Hloop_QV_A(ntryL,G1H12(61),ex5(:),G1H6(1),m3h2x6(:,24),heltab2x12(:,:,40))
  call Hloop_Q_A(ntryL,G1H6(1),53,nMB,G2H6(42),n2h6(22))
call HGT_raise_alpha_OLR(G1H12(62),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(62),2,5,12)
  call Hloop_VA_Q(ntryL,G1H12(62),ex2(:),G1H6(1),m3h2x6(:,25),heltab2x12(:,:,41))
  call Hloop_QV_A(ntryL,G1H12(67),ex5(:),G1H6(2),m3h2x6(:,26),heltab2x12(:,:,42))
  call Hloop_Q_A(ntryL,G1H6(2),53,nMB,G2H6(43),n2h6(23))
  call Hloop_QV_A(ntryL,G1H12(73),ex5(:),G1H6(2),m3h2x6(:,27),heltab2x12(:,:,43))
  call Hloop_Q_A(ntryL,G1H6(2),53,nMB,G2H6(44),n2h6(24))
call HGT_raise_alpha_OLR(G1H12(68),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(68),2,5,12)
  call Hloop_VA_Q(ntryL,G1H12(68),ex2(:),G1H6(2),m3h2x6(:,28),heltab2x12(:,:,44))
  call Hloop_QV_A(ntryL,G1H12(71),ex5(:),G1H6(3),m3h2x6(:,29),heltab2x12(:,:,45))
  call Hloop_Q_A(ntryL,G1H6(3),53,nMB,G2H6(45),n2h6(25))
  call Hloop_QV_A(ntryL,G1H12(72),ex5(:),G1H6(3),m3h2x6(:,30),heltab2x12(:,:,46))
  call Hloop_Q_A(ntryL,G1H6(3),53,nMB,G2H6(46),n2h6(26))
call HGT_raise_alpha_OLR(G1H12(74),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(74),2,5,12)
  call Hloop_VA_Q(ntryL,G1H12(74),ex2(:),G1H6(3),m3h2x6(:,31),heltab2x12(:,:,47))
  call Hloop_QV_A(ntryL,G1H12(77),ex5(:),G1H6(4),m3h2x6(:,32),heltab2x12(:,:,48))
  call Hloop_Q_A(ntryL,G1H6(4),53,nMB,G2H6(47),n2h6(27))
  call Hloop_QV_A(ntryL,G1H12(78),ex5(:),G1H6(4),m3h2x6(:,33),heltab2x12(:,:,49))
  call Hloop_Q_A(ntryL,G1H6(4),53,nMB,G2H6(48),n2h6(28))
  call Hloop_QW_A(ntryL,G1H12(79),ex4(:),G1H4(1),m3h3x4(:,17),heltab2x12(:,:,50))
  call Hloop_Q_A(ntryL,G1H4(1),45,nMT,G2H4(23),n2h4(15))
call HGT_raise_alpha_OLR(G1H12(80),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(80),2,5,12)
  call Hloop_VA_Q(ntryL,G1H12(80),ex2(:),G1H6(4),m3h2x6(:,34),heltab2x12(:,:,51))
  call Hloop_QW_A(ntryL,G1H12(85),ex4(:),G1H4(1),m3h3x4(:,18),heltab2x12(:,:,52))
  call Hloop_Q_A(ntryL,G1H4(1),45,nMT,G2H4(24),n2h4(16))
  call Hloop_QW_A(ntryL,G1H12(91),ex4(:),G1H4(1),m3h3x4(:,19),heltab2x12(:,:,53))
  call Hloop_Q_A(ntryL,G1H4(1),45,nMT,G2H4(25),n2h4(17))
call HGT_raise_alpha_OLR(G1H12(86),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(86),2,5,12)
  call Hloop_VA_Q(ntryL,G1H12(86),ex2(:),G1H6(5),m3h2x6(:,35),heltab2x12(:,:,54))
  call Hloop_QW_A(ntryL,G1H12(89),ex4(:),G1H4(1),m3h3x4(:,20),heltab2x12(:,:,55))
  call Hloop_Q_A(ntryL,G1H4(1),45,nMT,G2H4(26),n2h4(18))
  call Hloop_QW_A(ntryL,G1H12(90),ex4(:),G1H4(1),m3h3x4(:,21),heltab2x12(:,:,56))
  call Hloop_Q_A(ntryL,G1H4(1),45,nMT,G2H4(27),n2h4(19))
call HGT_raise_alpha_OLR(G1H12(92),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(92),2,5,12)
  call Hloop_VA_Q(ntryL,G1H12(92),ex2(:),G1H6(6),m3h2x6(:,36),heltab2x12(:,:,57))
  call Hloop_QW_A(ntryL,G1H12(95),ex4(:),G1H4(1),m3h3x4(:,22),heltab2x12(:,:,58))
  call Hloop_Q_A(ntryL,G1H4(1),45,nMT,G2H4(28),n2h4(20))
  call Hloop_QW_A(ntryL,G1H12(96),ex4(:),G1H4(1),m3h3x4(:,23),heltab2x12(:,:,59))
  call Hloop_Q_A(ntryL,G1H4(1),45,nMT,G2H4(29),n2h4(21))
  call Hloop_QW_A(ntryL,G1H18(52),ex3(:),G1H6(7),m3h3x6(:,19),heltab2x18(:,:,33))
  call Hloop_Q_A(ntryL,G1H6(7),53,nMB,G2H6(49),n2h6(29))
call HGT_raise_alpha_OLR(G1H18(53),1,1,18)
call HGT_raise_alpha_invQ_OLR(G1H18(53),2,5,18)
  call Hloop_VA_Q(ntryL,G1H18(53),ex2(:),G1H9(1),m3h2x9(:,15),heltab2x18(:,:,34))
  call Hloop_QW_A(ntryL,G1H18(58),ex3(:),G1H6(7),m3h3x6(:,20),heltab2x18(:,:,35))
  call Hloop_Q_A(ntryL,G1H6(7),53,nMB,G2H6(50),n2h6(30))
  call Hloop_QW_A(ntryL,G1H18(64),ex3(:),G1H6(7),m3h3x6(:,21),heltab2x18(:,:,36))
  call Hloop_Q_A(ntryL,G1H6(7),53,nMB,G2H6(51),n2h6(31))
call HGT_raise_alpha_OLR(G1H18(59),1,1,18)
call HGT_raise_alpha_invQ_OLR(G1H18(59),2,5,18)
  call Hloop_VA_Q(ntryL,G1H18(59),ex2(:),G1H9(2),m3h2x9(:,16),heltab2x18(:,:,37))
  call Hloop_QW_A(ntryL,G1H18(62),ex3(:),G1H6(7),m3h3x6(:,22),heltab2x18(:,:,38))
  call Hloop_Q_A(ntryL,G1H6(7),53,nMB,G2H6(52),n2h6(32))
  call Hloop_QW_A(ntryL,G1H18(63),ex3(:),G1H6(7),m3h3x6(:,23),heltab2x18(:,:,39))
  call Hloop_Q_A(ntryL,G1H6(7),53,nMB,G2H6(53),n2h6(33))
call HGT_raise_alpha_OLR(G1H18(65),1,1,18)
call HGT_raise_alpha_invQ_OLR(G1H18(65),2,5,18)
  call Hloop_VA_Q(ntryL,G1H18(65),ex2(:),G1H9(3),m3h2x9(:,17),heltab2x18(:,:,40))
  call Hloop_QW_A(ntryL,G1H18(68),ex3(:),G1H6(7),m3h3x6(:,24),heltab2x18(:,:,41))
  call Hloop_Q_A(ntryL,G1H6(7),53,nMB,G2H6(54),n2h6(34))
  call Hloop_QW_A(ntryL,G1H18(69),ex3(:),G1H6(7),m3h3x6(:,25),heltab2x18(:,:,42))
  call Hloop_Q_A(ntryL,G1H6(7),53,nMB,G2H6(55),n2h6(35))
  call Hotf_5pt_reduction(G2H4(1),RedSet_5(1),mass5set(:,1),  & 
G1H4(1),G1H4(2),G1H4(3),G1H4(4),G1H4(5),G1H4(6),4)
  call HG1shiftOLR(G1H4(2),16,4)
  call Hotf_5pt_reduction(G2H4(3),RedSet_5(25),mass5set(:,14),  & 
G1H4(7),G1H4(8),G1H4(9),G1H4(10),G1H4(11),G1H4(12),4)
  call HG1shiftOLR(G1H4(8),16,4)
  call Hotf_5pt_reduction(G2H4(4),RedSet_5(2),mass5set(:,1),  & 
G1H4(13),G1H4(14),G1H4(15),G1H4(16),G1H4(17),G1H4(18),4)
  call HG1shiftOLR(G1H4(14),16,4)
  call Hotf_5pt_reduction(G2H4(6),RedSet_5(26),mass5set(:,14),  & 
G1H4(19),G1H4(20),G1H4(21),G1H4(22),G1H4(23),G1H4(24),4)
  call HG1shiftOLR(G1H4(20),16,4)
  call Hotf_5pt_reduction(G2H6(1),RedSet_5(3),mass5set(:,2),  & 
G1H6(7),G1H6(8),G1H6(9),G1H6(10),G1H6(11),G1H6(12),6)
  call HG1shiftOLR(G1H6(8),8,6)
  call Hotf_5pt_reduction(G2H6(3),RedSet_5(27),mass5set(:,15),  & 
G1H6(13),G1H6(14),G1H6(15),G1H6(16),G1H6(17),G1H6(18),6)
  call HG1shiftOLR(G1H6(14),8,6)
  call Hotf_5pt_reduction(G2H6(4),RedSet_5(8),mass5set(:,6),  & 
G1H6(19),G1H6(20),G1H6(21),G1H6(22),G1H6(23),G1H6(24),6)
  call HG1shiftOLR(G1H6(20),16,6)
  call Hotf_5pt_reduction(G2H6(7),RedSet_5(28),mass5set(:,16),  & 
G1H6(25),G1H6(26),G1H6(27),G1H6(28),G1H6(29),G1H6(30),6)
  call HG1shiftOLR(G1H6(26),16,6)
  call Hotf_5pt_reduction(G2H6(8),RedSet_5(9),mass5set(:,6),  & 
G1H6(31),G1H6(32),G1H6(33),G1H6(34),G1H6(35),G1H6(36),6)
  call HG1shiftOLR(G1H6(32),16,6)
  call Hotf_5pt_reduction(G2H6(11),RedSet_5(29),mass5set(:,16),  & 
G1H6(37),G1H6(38),G1H6(39),G1H6(40),G1H6(41),G1H6(42),6)
  call HG1shiftOLR(G1H6(38),16,6)
  call Hotf_5pt_reduction(G2H6(12),RedSet_5(9),mass5set(:,6),  & 
G1H6(43),G1H6(44),G1H6(45),G1H6(46),G1H6(47),G1H6(48),6)
  call HG1shiftOLR(G1H6(44),8,6)
  call Hotf_5pt_reduction(G2H6(14),RedSet_5(30),mass5set(:,6),  & 
G1H6(49),G1H6(50),G1H6(51),G1H6(52),G1H6(53),G1H6(54),6)
  call HG1shiftOLR(G1H6(50),8,6)
  call Hotf_5pt_reduction(G2H6(15),RedSet_5(10),mass5set(:,7),  & 
G1H6(55),G1H6(56),G1H6(57),G1H6(58),G1H6(59),G1H6(60),6)
  call HG1shiftOLR(G1H6(56),16,6)
  call Hotf_5pt_reduction(G2H6(17),RedSet_5(31),mass5set(:,8),  & 
G1H6(61),G1H6(62),G1H6(63),G1H6(64),G1H6(65),G1H6(66),6)
  call HG1shiftOLR(G1H6(62),16,6)
  call Hotf_5pt_reduction(G2H6(18),RedSet_5(10),mass5set(:,7),  & 
G1H6(67),G1H6(68),G1H6(69),G1H6(70),G1H6(71),G1H6(72),6)
  call HG1shiftOLR(G1H6(68),8,6)
  call Hotf_5pt_reduction(G2H6(21),RedSet_5(32),mass5set(:,7),  & 
G1H6(73),G1H6(74),G1H6(75),G1H6(76),G1H6(77),G1H6(78),6)
  call HG1shiftOLR(G1H6(74),8,6)
  call Hotf_5pt_reduction(G2H9(2),RedSet_5(11),mass5set(:,8),  & 
G1H9(4),G1H9(5),G1H9(6),G1H9(7),G1H9(8),G1H9(9),9)
  call HG1shiftOLR(G1H9(5),8,9)
  call Hotf_5pt_reduction(G2H9(4),RedSet_5(32),mass5set(:,7),  & 
G1H9(10),G1H9(11),G1H9(12),G1H9(13),G1H9(14),G1H9(15),9)
  call HG1shiftOLR(G1H9(11),8,9)
  call Hotf_5pt_reduction(G2H6(23),RedSet_5(12),mass5set(:,7),  & 
G1H6(79),G1H6(80),G1H6(81),G1H6(82),G1H6(83),G1H6(84),6)
  call HG1shiftOLR(G1H6(80),16,6)
  call Hotf_5pt_reduction(G2H6(25),RedSet_5(33),mass5set(:,8),  & 
G1H6(85),G1H6(86),G1H6(87),G1H6(88),G1H6(89),G1H6(90),6)
  call HG1shiftOLR(G1H6(86),16,6)
  call Hotf_5pt_reduction(G2H6(26),RedSet_5(12),mass5set(:,7),  & 
G1H6(91),G1H6(92),G1H6(93),G1H6(94),G1H6(95),G1H6(96),6)
  call HG1shiftOLR(G1H6(92),4,6)
  call Hotf_5pt_reduction(G2H6(29),RedSet_5(34),mass5set(:,7),  & 
G1H6(97),G1H6(98),G1H6(99),G1H6(100),G1H6(101),G1H6(102),6)
  call HG1shiftOLR(G1H6(98),4,6)
  call Hotf_5pt_reduction(G2H9(6),RedSet_5(13),mass5set(:,8),  & 
G1H9(16),G1H9(17),G1H9(18),G1H9(19),G1H9(20),G1H9(21),9)
  call HG1shiftOLR(G1H9(17),4,9)
  call Hotf_5pt_reduction(G2H9(8),RedSet_5(34),mass5set(:,7),  & 
G1H9(22),G1H9(23),G1H9(24),G1H9(25),G1H9(26),G1H9(27),9)
  call HG1shiftOLR(G1H9(23),4,9)
  call Hotf_5pt_reduction(G2H6(31),RedSet_5(14),mass5set(:,9),  & 
G1H6(103),G1H6(104),G1H6(105),G1H6(106),G1H6(107),G1H6(108),6)
  call HG1shiftOLR(G1H6(104),8,6)
  call Hotf_5pt_reduction(G2H6(33),RedSet_5(30),mass5set(:,6),  & 
G1H6(109),G1H6(110),G1H6(111),G1H6(112),G1H6(113),G1H6(114),6)
  call HG1shiftOLR(G1H6(110),8,6)
  call Hotf_5pt_reduction(G2H9(9),RedSet_5(15),mass5set(:,10),  & 
G1H9(28),G1H9(29),G1H9(30),G1H9(31),G1H9(32),G1H9(33),9)
  call HG1shiftOLR(G1H9(29),8,9)
  call Hotf_5pt_reduction(G2H9(11),RedSet_5(35),mass5set(:,17),  & 
G1H9(34),G1H9(35),G1H9(36),G1H9(37),G1H9(38),G1H9(39),9)
  call HG1shiftOLR(G1H9(35),8,9)
  call Hotf_5pt_reduction(G2H9(12),RedSet_5(16),mass5set(:,10),  & 
G1H9(40),G1H9(41),G1H9(42),G1H9(43),G1H9(44),G1H9(45),9)
  call HG1shiftOLR(G1H9(41),4,9)
  call Hotf_5pt_reduction(G2H9(14),RedSet_5(36),mass5set(:,17),  & 
G1H9(46),G1H9(47),G1H9(48),G1H9(49),G1H9(50),G1H9(51),9)
  call HG1shiftOLR(G1H9(47),4,9)
  call Hloop_AQ_V(ntryL,G2H4(9),ex1(:),G2H2(1),m3h2x2(:,1),heltab2x4(:,:,1))
  call Hloop_AQ_V(ntryL,G2H4(11),ex1(:),G2H2(2),m3h2x2(:,2),heltab2x4(:,:,2))
  call Hloop_AQ_V(ntryL,G2H4(15),ex1(:),G2H2(3),m3h2x2(:,3),heltab2x4(:,:,3))
  call Hloop_QA_V(ntryL,G2H4(16),ex2(:),G2H2(4),m3h2x2(:,4),heltab2x4(:,:,4))
  call Hloop_QA_V(ntryL,G2H4(18),ex2(:),G2H2(5),m3h2x2(:,5),heltab2x4(:,:,5))
  call Hloop_QA_V(ntryL,G2H4(22),ex2(:),G2H2(6),m3h2x2(:,6),heltab2x4(:,:,6))
  call Hotf_5pt_reduction(G2H6(42),RedSet_5(6),mass5set(:,4),  & 
G1H6(115),G1H6(116),G1H6(117),G1H6(118),G1H6(119),G1H6(120),6)
  call HG1shiftOLR(G1H6(116),2,6)
  call Hotf_5pt_reduction(G2H6(44),RedSet_5(22),mass5set(:,3),  & 
G1H6(121),G1H6(122),G1H6(123),G1H6(124),G1H6(125),G1H6(126),6)
  call HG1shiftOLR(G1H6(122),2,6)
  call Hotf_4pt_reduction(G2H6(48),RedSet_4(1),mass4set(:,1),  & 
G1H6(127),G1H6(128),G1H6(129),G1H6(130),G1H6(131),6)
  call HG1shiftOLR(G1H6(128),26,6)
  call Hotf_5pt_reduction(G2H4(23),RedSet_5(5),mass5set(:,3),  & 
G1H4(25),G1H4(26),G1H4(27),G1H4(28),G1H4(29),G1H4(30),4)
  call HG1shiftOLR(G1H4(26),2,4)
  call Hotf_5pt_reduction(G2H4(25),RedSet_5(22),mass5set(:,3),  & 
G1H4(31),G1H4(32),G1H4(33),G1H4(34),G1H4(35),G1H4(36),4)
  call HG1shiftOLR(G1H4(32),2,4)
  call Hotf_4pt_reduction(G2H4(29),RedSet_4(1),mass4set(:,1),  & 
G1H4(37),G1H4(38),G1H4(39),G1H4(40),G1H4(41),4)
  call HG1shiftOLR(G1H4(38),26,4)
  call Hotf_5pt_reduction(G2H6(49),RedSet_5(7),mass5set(:,5),  & 
G1H6(132),G1H6(133),G1H6(134),G1H6(135),G1H6(136),G1H6(137),6)
  call HG1shiftOLR(G1H6(133),2,6)
  call Hotf_5pt_reduction(G2H6(51),RedSet_5(24),mass5set(:,13),  & 
G1H6(138),G1H6(139),G1H6(140),G1H6(141),G1H6(142),G1H6(143),6)
  call HG1shiftOLR(G1H6(139),2,6)
  call Hotf_4pt_reduction(G2H6(55),RedSet_4(2),mass4set(:,2),  & 
G1H6(144),G1H6(145),G1H6(146),G1H6(147),G1H6(148),6)
  call HG1shiftOLR(G1H6(145),14,6)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(7),[G1H4(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(19),[G1H4(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(13),[G1H6(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(25),[G1H6(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(37),[G1H6(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(49),[G1H6(48)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(61),[G1H6(60)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(73),[G1H6(72)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H9(10),[G1H9(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(85),[G1H6(84)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(97),[G1H6(96)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H9(22),[G1H9(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(109),[G1H6(108)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H9(34),[G1H9(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H9(46),[G1H9(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(121),[G1H6(120)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(127),[G1H6(126)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(31),[G1H4(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(37),[G1H4(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(138),[G1H6(137)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(144),[G1H6(143)])
  call Hloop_VA_Q(ntryL,G1H4(1),ex2(:),G1H2(1),m3h2x2(:,7),heltab2x4(:,:,7))
  call Hloop_A_Q(ntryL,G1H2(1),47,nMT,G2H2(7),n2h2(1))
call HGT_OLR(G1H4(2),1,1,4)
call HGT_invQ_OLR(G1H4(2),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(2),-16,nMT,G2H4(1),n2h4(22))
  call Hloop_QV_A(ntryL,G2H4(1),ex5(:),G2H2(8),m3h2x2(:,8),heltab2x4(:,:,8))
  call Hloop_VA_Q(ntryL,G1H4(7),ex2(:),G1H2(1),m3h2x2(:,9),heltab2x4(:,:,9))
  call Hloop_A_Q(ntryL,G1H2(1),47,nMT,G2H2(9),n2h2(2))
call HGT_OLR(G1H4(8),1,1,4)
call HGT_invQ_OLR(G1H4(8),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(8),-16,nMT,G2H4(3),n2h4(23))
  call Hloop_QV_A(ntryL,G2H4(3),ex5(:),G2H2(10),m3h2x2(:,10),heltab2x4(:,:,10))
  call Hloop_VA_Q(ntryL,G1H4(12),ex2(:),G1H2(1),m3h2x2(:,11),heltab2x4(:,:,11))
  call Hloop_A_Q(ntryL,G1H2(1),47,nMT,G2H2(11),n2h2(3))
  call Hloop_VQ_A(ntryL,G1H4(13),ex1(:),G1H2(1),m3h2x2(:,12),heltab2x4(:,:,12))
  call Hloop_Q_A(ntryL,G1H2(1),47,nMT,G2H2(12),n2h2(4))
call HGT_OLR(G1H4(14),1,1,4)
call HGT_invQ_OLR(G1H4(14),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(14),-16,nMT,G2H4(4),n2h4(24))
  call Hloop_AV_Q(ntryL,G2H4(4),ex5(:),G2H2(13),m3h2x2(:,13),heltab2x4(:,:,13))
  call Hloop_VQ_A(ntryL,G1H4(19),ex1(:),G1H2(1),m3h2x2(:,14),heltab2x4(:,:,14))
  call Hloop_Q_A(ntryL,G1H2(1),47,nMT,G2H2(14),n2h2(5))
call HGT_OLR(G1H4(20),1,1,4)
call HGT_invQ_OLR(G1H4(20),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(20),-16,nMT,G2H4(6),n2h4(25))
  call Hloop_AV_Q(ntryL,G2H4(6),ex5(:),G2H2(15),m3h2x2(:,15),heltab2x4(:,:,15))
  call Hloop_VQ_A(ntryL,G1H4(24),ex1(:),G1H2(1),m3h2x2(:,16),heltab2x4(:,:,16))
  call Hloop_Q_A(ntryL,G1H2(1),47,nMT,G2H2(16),n2h2(6))
  call Hloop_VA_Q(ntryL,G1H6(7),ex2(:),G1H3(1),m3h2x3(:,1),heltab2x6(:,:,1))
  call Hloop_A_Q(ntryL,G1H3(1),55,nMT,G2H3(1),n2h3(1))
call HGT_OLR(G1H6(8),1,1,6)
call HGT_invQ_OLR(G1H6(8),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(8),-8,nMB,G2H6(1),n2h6(36))
  call Hloop_QW_A(ntryL,G2H6(1),ex4(:),G2H2(17),m3h3x2(:,1),heltab2x6(:,:,2))
  call Hloop_VA_Q(ntryL,G1H6(13),ex2(:),G1H3(1),m3h2x3(:,2),heltab2x6(:,:,3))
  call Hloop_A_Q(ntryL,G1H3(1),55,nMT,G2H3(2),n2h3(2))
call HGT_OLR(G1H6(14),1,1,6)
call HGT_invQ_OLR(G1H6(14),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(14),-8,nMB,G2H6(3),n2h6(37))
  call Hloop_QW_A(ntryL,G2H6(3),ex4(:),G2H2(18),m3h3x2(:,2),heltab2x6(:,:,4))
  call Hloop_VA_Q(ntryL,G1H6(18),ex2(:),G1H3(1),m3h2x3(:,3),heltab2x6(:,:,5))
  call Hloop_A_Q(ntryL,G1H3(1),55,nMT,G2H3(3),n2h3(3))
  call Hloop_QW_A(ntryL,G1H6(19),ex3(:),G1H2(1),m3h3x2(:,3),heltab2x6(:,:,6))
  call Hloop_Q_A(ntryL,G1H2(1),47,nMB,G2H2(19),n2h2(7))
call HGT_OLR(G1H6(20),1,1,6)
call HGT_invQ_OLR(G1H6(20),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(20),-16,nMB,G2H6(4),n2h6(38))
  call Hloop_AV_Q(ntryL,G2H6(4),ex5(:),G2H3(4),m3h2x3(:,4),heltab2x6(:,:,7))
  call Hloop_QW_A(ntryL,G1H6(25),ex3(:),G1H2(1),m3h3x2(:,4),heltab2x6(:,:,8))
  call Hloop_Q_A(ntryL,G1H2(1),47,nMB,G2H2(20),n2h2(8))
call HGT_OLR(G1H6(26),1,1,6)
call HGT_invQ_OLR(G1H6(26),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(26),-16,nMB,G2H6(7),n2h6(39))
  call Hloop_AV_Q(ntryL,G2H6(7),ex5(:),G2H3(5),m3h2x3(:,5),heltab2x6(:,:,9))
  call Hloop_QW_A(ntryL,G1H6(30),ex3(:),G1H2(1),m3h3x2(:,5),heltab2x6(:,:,10))
  call Hloop_Q_A(ntryL,G1H2(1),47,nMB,G2H2(21),n2h2(9))
  call Hloop_AW_Q(ntryL,G1H6(31),ex4(:),G1H2(1),m3h3x2(:,6),heltab2x6(:,:,11))
  call Hloop_A_Q(ntryL,G1H2(1),47,nMB,G2H2(22),n2h2(10))
call HGT_OLR(G1H6(32),1,1,6)
call HGT_invQ_OLR(G1H6(32),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(32),-16,nMB,G2H6(8),n2h6(40))
  call Hloop_QV_A(ntryL,G2H6(8),ex5(:),G2H3(6),m3h2x3(:,6),heltab2x6(:,:,12))
  call Hloop_AW_Q(ntryL,G1H6(37),ex4(:),G1H2(1),m3h3x2(:,7),heltab2x6(:,:,13))
  call Hloop_A_Q(ntryL,G1H2(1),47,nMB,G2H2(23),n2h2(11))
call HGT_OLR(G1H6(38),1,1,6)
call HGT_invQ_OLR(G1H6(38),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(38),-16,nMB,G2H6(11),n2h6(41))
  call Hloop_QV_A(ntryL,G2H6(11),ex5(:),G2H3(7),m3h2x3(:,7),heltab2x6(:,:,14))
  call Hloop_AW_Q(ntryL,G1H6(42),ex4(:),G1H2(1),m3h3x2(:,8),heltab2x6(:,:,15))
  call Hloop_A_Q(ntryL,G1H2(1),47,nMB,G2H2(24),n2h2(12))
  call Hloop_AV_Q(ntryL,G1H6(43),ex5(:),G1H3(1),m3h2x3(:,8),heltab2x6(:,:,16))
  call Hloop_A_Q(ntryL,G1H3(1),55,nMT,G2H3(8),n2h3(4))
call HGT_OLR(G1H6(44),1,1,6)
call HGT_invQ_OLR(G1H6(44),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(44),-8,nMB,G2H6(12),n2h6(42))
  call Hloop_QW_A(ntryL,G2H6(12),ex4(:),G2H2(25),m3h3x2(:,9),heltab2x6(:,:,17))
  call Hloop_AV_Q(ntryL,G1H6(49),ex5(:),G1H3(1),m3h2x3(:,9),heltab2x6(:,:,18))
  call Hloop_A_Q(ntryL,G1H3(1),55,nMT,G2H3(9),n2h3(5))
call HGT_OLR(G1H6(50),1,1,6)
call HGT_invQ_OLR(G1H6(50),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(50),-8,nMB,G2H6(14),n2h6(43))
  call Hloop_QW_A(ntryL,G2H6(14),ex4(:),G2H2(26),m3h3x2(:,10),heltab2x6(:,:,19))
  call Hloop_AV_Q(ntryL,G1H6(54),ex5(:),G1H3(1),m3h2x3(:,10),heltab2x6(:,:,20))
  call Hloop_A_Q(ntryL,G1H3(1),55,nMT,G2H3(10),n2h3(6))
  call Hloop_QW_A(ntryL,G1H6(55),ex4(:),G1H2(1),m3h3x2(:,11),heltab2x6(:,:,21))
  call Hloop_Q_A(ntryL,G1H2(1),47,nMT,G2H2(27),n2h2(13))
call HGT_OLR(G1H6(56),1,1,6)
call HGT_invQ_OLR(G1H6(56),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(56),-16,nMT,G2H6(15),n2h6(44))
  call Hloop_AV_Q(ntryL,G2H6(15),ex5(:),G2H3(11),m3h2x3(:,11),heltab2x6(:,:,22))
  call Hloop_QW_A(ntryL,G1H6(61),ex4(:),G1H2(1),m3h3x2(:,12),heltab2x6(:,:,23))
  call Hloop_Q_A(ntryL,G1H2(1),47,nMT,G2H2(28),n2h2(14))
call HGT_OLR(G1H6(62),1,1,6)
call HGT_invQ_OLR(G1H6(62),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(62),-16,nMT,G2H6(17),n2h6(45))
  call Hloop_AV_Q(ntryL,G2H6(17),ex5(:),G2H3(12),m3h2x3(:,12),heltab2x6(:,:,24))
  call Hloop_QW_A(ntryL,G1H6(66),ex4(:),G1H2(1),m3h3x2(:,13),heltab2x6(:,:,25))
  call Hloop_Q_A(ntryL,G1H2(1),47,nMT,G2H2(29),n2h2(15))
  call Hloop_QV_A(ntryL,G1H6(67),ex5(:),G1H3(1),m3h2x3(:,13),heltab2x6(:,:,26))
  call Hloop_Q_A(ntryL,G1H3(1),55,nMB,G2H3(13),n2h3(7))
call HGT_OLR(G1H6(68),1,1,6)
call HGT_invQ_OLR(G1H6(68),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(68),-8,nMT,G2H6(18),n2h6(46))
  call Hloop_AW_Q(ntryL,G2H6(18),ex4(:),G2H2(30),m3h3x2(:,14),heltab2x6(:,:,27))
  call Hloop_QV_A(ntryL,G1H6(73),ex5(:),G1H3(1),m3h2x3(:,14),heltab2x6(:,:,28))
  call Hloop_Q_A(ntryL,G1H3(1),55,nMB,G2H3(14),n2h3(8))
call HGT_OLR(G1H6(74),1,1,6)
call HGT_invQ_OLR(G1H6(74),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(74),-8,nMT,G2H6(21),n2h6(47))
  call Hloop_AW_Q(ntryL,G2H6(21),ex4(:),G2H2(31),m3h3x2(:,15),heltab2x6(:,:,29))
  call Hloop_QV_A(ntryL,G1H6(78),ex5(:),G1H3(1),m3h2x3(:,15),heltab2x6(:,:,30))
  call Hloop_Q_A(ntryL,G1H3(1),55,nMB,G2H3(15),n2h3(9))
  call Hloop_QW_A(ntryL,G1H9(4),ex3(:),G1H3(1),m3h3x3(:,1),heltab2x9(:,:,1))
  call Hloop_Q_A(ntryL,G1H3(1),55,nMB,G2H3(16),n2h3(10))
call HGT_OLR(G1H9(5),1,1,9)
call HGT_invQ_OLR(G1H9(5),2,5,9)
  call Hloop_A_Q(ntryL,G1H9(5),-8,nMT,G2H9(2),n2h9(13))
  call Hloop_AW_Q(ntryL,G2H9(2),ex4(:),G2H3(17),m3h3x3(:,2),heltab2x9(:,:,2))
  call Hloop_QW_A(ntryL,G1H9(10),ex3(:),G1H3(1),m3h3x3(:,3),heltab2x9(:,:,3))
  call Hloop_Q_A(ntryL,G1H3(1),55,nMB,G2H3(18),n2h3(11))
call HGT_OLR(G1H9(11),1,1,9)
call HGT_invQ_OLR(G1H9(11),2,5,9)
  call Hloop_A_Q(ntryL,G1H9(11),-8,nMT,G2H9(4),n2h9(14))
  call Hloop_AW_Q(ntryL,G2H9(4),ex4(:),G2H3(19),m3h3x3(:,4),heltab2x9(:,:,4))
  call Hloop_QW_A(ntryL,G1H9(15),ex3(:),G1H3(1),m3h3x3(:,5),heltab2x9(:,:,5))
  call Hloop_Q_A(ntryL,G1H3(1),55,nMB,G2H3(20),n2h3(12))
  call Hloop_AW_Q(ntryL,G1H6(79),ex3(:),G1H2(1),m3h3x2(:,16),heltab2x6(:,:,31))
  call Hloop_A_Q(ntryL,G1H2(1),47,nMT,G2H2(32),n2h2(16))
call HGT_OLR(G1H6(80),1,1,6)
call HGT_invQ_OLR(G1H6(80),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(80),-16,nMT,G2H6(23),n2h6(48))
  call Hloop_QV_A(ntryL,G2H6(23),ex5(:),G2H3(21),m3h2x3(:,16),heltab2x6(:,:,32))
  call Hloop_AW_Q(ntryL,G1H6(85),ex3(:),G1H2(1),m3h3x2(:,17),heltab2x6(:,:,33))
  call Hloop_A_Q(ntryL,G1H2(1),47,nMT,G2H2(33),n2h2(17))
call HGT_OLR(G1H6(86),1,1,6)
call HGT_invQ_OLR(G1H6(86),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(86),-16,nMT,G2H6(25),n2h6(49))
  call Hloop_QV_A(ntryL,G2H6(25),ex5(:),G2H3(22),m3h2x3(:,17),heltab2x6(:,:,34))
  call Hloop_AW_Q(ntryL,G1H6(90),ex3(:),G1H2(1),m3h3x2(:,18),heltab2x6(:,:,35))
  call Hloop_A_Q(ntryL,G1H2(1),47,nMT,G2H2(34),n2h2(18))
  call Hloop_AV_Q(ntryL,G1H6(91),ex5(:),G1H3(1),m3h2x3(:,18),heltab2x6(:,:,36))
  call Hloop_A_Q(ntryL,G1H3(1),59,nMB,G2H3(23),n2h3(13))
call HGT_OLR(G1H6(92),1,1,6)
call HGT_invQ_OLR(G1H6(92),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(92),-4,nMT,G2H6(26),n2h6(50))
  call Hloop_QW_A(ntryL,G2H6(26),ex3(:),G2H2(35),m3h3x2(:,19),heltab2x6(:,:,37))
  call Hloop_AV_Q(ntryL,G1H6(97),ex5(:),G1H3(1),m3h2x3(:,19),heltab2x6(:,:,38))
  call Hloop_A_Q(ntryL,G1H3(1),59,nMB,G2H3(24),n2h3(14))
call HGT_OLR(G1H6(98),1,1,6)
call HGT_invQ_OLR(G1H6(98),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(98),-4,nMT,G2H6(29),n2h6(51))
  call Hloop_QW_A(ntryL,G2H6(29),ex3(:),G2H2(36),m3h3x2(:,20),heltab2x6(:,:,39))
  call Hloop_AV_Q(ntryL,G1H6(102),ex5(:),G1H3(1),m3h2x3(:,20),heltab2x6(:,:,40))
  call Hloop_A_Q(ntryL,G1H3(1),59,nMB,G2H3(25),n2h3(15))
  call Hloop_AW_Q(ntryL,G1H9(16),ex4(:),G1H3(1),m3h3x3(:,6),heltab2x9(:,:,6))
  call Hloop_A_Q(ntryL,G1H3(1),59,nMB,G2H3(26),n2h3(16))
call HGT_OLR(G1H9(17),1,1,9)
call HGT_invQ_OLR(G1H9(17),2,5,9)
  call Hloop_Q_A(ntryL,G1H9(17),-4,nMT,G2H9(6),n2h9(15))
  call Hloop_QW_A(ntryL,G2H9(6),ex3(:),G2H3(27),m3h3x3(:,7),heltab2x9(:,:,7))
  call Hloop_AW_Q(ntryL,G1H9(22),ex4(:),G1H3(1),m3h3x3(:,8),heltab2x9(:,:,8))
  call Hloop_A_Q(ntryL,G1H3(1),59,nMB,G2H3(28),n2h3(17))
call HGT_OLR(G1H9(23),1,1,9)
call HGT_invQ_OLR(G1H9(23),2,5,9)
  call Hloop_Q_A(ntryL,G1H9(23),-4,nMT,G2H9(8),n2h9(16))
  call Hloop_QW_A(ntryL,G2H9(8),ex3(:),G2H3(29),m3h3x3(:,9),heltab2x9(:,:,9))
  call Hloop_AW_Q(ntryL,G1H9(27),ex4(:),G1H3(1),m3h3x3(:,10),heltab2x9(:,:,10))
  call Hloop_A_Q(ntryL,G1H3(1),59,nMB,G2H3(30),n2h3(18))
  call Hloop_VA_Q(ntryL,G1H6(103),ex2(:),G1H3(1),m3h2x3(:,21),heltab2x6(:,:,41))
  call Hloop_A_Q(ntryL,G1H3(1),55,nMT,G2H3(31),n2h3(19))
call HGT_OLR(G1H6(104),1,1,6)
call HGT_invQ_OLR(G1H6(104),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(104),-8,nMB,G2H6(31),n2h6(52))
  call Hloop_QW_A(ntryL,G2H6(31),ex4(:),G2H2(37),m3h3x2(:,21),heltab2x6(:,:,42))
  call Hloop_VA_Q(ntryL,G1H6(109),ex2(:),G1H3(1),m3h2x3(:,22),heltab2x6(:,:,43))
  call Hloop_A_Q(ntryL,G1H3(1),55,nMT,G2H3(32),n2h3(20))
call HGT_OLR(G1H6(110),1,1,6)
call HGT_invQ_OLR(G1H6(110),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(110),-8,nMB,G2H6(33),n2h6(53))
  call Hloop_QW_A(ntryL,G2H6(33),ex4(:),G2H2(38),m3h3x2(:,22),heltab2x6(:,:,44))
  call Hloop_VA_Q(ntryL,G1H6(114),ex2(:),G1H3(1),m3h2x3(:,23),heltab2x6(:,:,45))
  call Hloop_A_Q(ntryL,G1H3(1),55,nMT,G2H3(33),n2h3(21))
  call Hloop_QW_A(ntryL,G1H9(28),ex3(:),G1H3(1),m3h3x3(:,11),heltab2x9(:,:,11))
  call Hloop_Q_A(ntryL,G1H3(1),55,nMB,G2H3(34),n2h3(22))
call HGT_OLR(G1H9(29),1,1,9)
call HGT_invQ_OLR(G1H9(29),2,5,9)
  call Hloop_A_Q(ntryL,G1H9(29),-8,nMT,G2H9(9),n2h9(17))
  call Hloop_AW_Q(ntryL,G2H9(9),ex4(:),G2H3(35),m3h3x3(:,12),heltab2x9(:,:,12))
  call Hloop_QW_A(ntryL,G1H9(34),ex3(:),G1H3(1),m3h3x3(:,13),heltab2x9(:,:,13))
  call Hloop_Q_A(ntryL,G1H3(1),55,nMB,G2H3(36),n2h3(23))
call HGT_OLR(G1H9(35),1,1,9)
call HGT_invQ_OLR(G1H9(35),2,5,9)
  call Hloop_A_Q(ntryL,G1H9(35),-8,nMT,G2H9(11),n2h9(18))
  call Hloop_AW_Q(ntryL,G2H9(11),ex4(:),G2H3(37),m3h3x3(:,14),heltab2x9(:,:,14))
  call Hloop_QW_A(ntryL,G1H9(39),ex3(:),G1H3(1),m3h3x3(:,15),heltab2x9(:,:,15))
  call Hloop_Q_A(ntryL,G1H3(1),55,nMB,G2H3(38),n2h3(24))
  call Hloop_AW_Q(ntryL,G1H9(40),ex4(:),G1H3(1),m3h3x3(:,16),heltab2x9(:,:,16))
  call Hloop_A_Q(ntryL,G1H3(1),59,nMB,G2H3(39),n2h3(25))
call HGT_OLR(G1H9(41),1,1,9)
call HGT_invQ_OLR(G1H9(41),2,5,9)
  call Hloop_Q_A(ntryL,G1H9(41),-4,nMT,G2H9(12),n2h9(19))
  call Hloop_QW_A(ntryL,G2H9(12),ex3(:),G2H3(40),m3h3x3(:,17),heltab2x9(:,:,17))
  call Hloop_AW_Q(ntryL,G1H9(46),ex4(:),G1H3(1),m3h3x3(:,18),heltab2x9(:,:,18))
  call Hloop_A_Q(ntryL,G1H3(1),59,nMB,G2H3(41),n2h3(26))
call HGT_OLR(G1H9(47),1,1,9)
call HGT_invQ_OLR(G1H9(47),2,5,9)
  call Hloop_Q_A(ntryL,G1H9(47),-4,nMT,G2H9(14),n2h9(20))
  call Hloop_QW_A(ntryL,G2H9(14),ex3(:),G2H3(42),m3h3x3(:,19),heltab2x9(:,:,19))
  call Hloop_AW_Q(ntryL,G1H9(51),ex4(:),G1H3(1),m3h3x3(:,20),heltab2x9(:,:,20))
  call Hloop_A_Q(ntryL,G1H3(1),59,nMB,G2H3(43),n2h3(27))
  call Hloop_QW_A(ntryL,G1H6(115),ex4(:),G1H2(1),m3h3x2(:,23),heltab2x6(:,:,46))
  call Hloop_Q_A(ntryL,G1H2(1),61,nMT,G2H2(39),n2h2(19))
call HGT_raise_alpha_OLR(G1H6(116),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(116),2,5,6)
  call Hloop_VA_Q(ntryL,G1H6(116),ex2(:),G1H3(1),m3h2x3(:,24),heltab2x6(:,:,47))
  call Hloop_QW_A(ntryL,G1H6(121),ex4(:),G1H2(1),m3h3x2(:,24),heltab2x6(:,:,48))
  call Hloop_Q_A(ntryL,G1H2(1),61,nMT,G2H2(40),n2h2(20))
call HGT_raise_alpha_OLR(G1H6(122),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(122),2,5,6)
  call Hloop_VA_Q(ntryL,G1H6(122),ex2(:),G1H3(2),m3h2x3(:,25),heltab2x6(:,:,49))
  call Hloop_QW_A(ntryL,G1H6(127),ex4(:),G1H2(1),m3h3x2(:,25),heltab2x6(:,:,50))
  call Hloop_Q_A(ntryL,G1H2(1),61,nMT,G2H2(41),n2h2(21))
call HGT_raise_alpha_OLR(G1H6(128),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(128),2,5,6)
  call Hloop_VA_Q(ntryL,G1H6(128),ex2(:),G1H3(3),m3h2x3(:,26),heltab2x6(:,:,51))
  call Hloop_QV_A(ntryL,G1H4(25),ex5(:),G1H2(1),m3h2x2(:,17),heltab2x4(:,:,17))
  call Hloop_Q_A(ntryL,G1H2(1),61,nMT,G2H2(42),n2h2(22))
call HGT_raise_alpha_OLR(G1H4(26),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(26),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(26),ex2(:),G1H2(1),m3h2x2(:,18),heltab2x4(:,:,18))
  call Hloop_QV_A(ntryL,G1H4(31),ex5(:),G1H2(2),m3h2x2(:,19),heltab2x4(:,:,19))
  call Hloop_Q_A(ntryL,G1H2(2),61,nMT,G2H2(43),n2h2(23))
call HGT_raise_alpha_OLR(G1H4(32),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(32),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(32),ex2(:),G1H2(2),m3h2x2(:,20),heltab2x4(:,:,20))
  call Hloop_QV_A(ntryL,G1H4(37),ex5(:),G1H2(3),m3h2x2(:,21),heltab2x4(:,:,21))
  call Hloop_Q_A(ntryL,G1H2(3),61,nMT,G2H2(44),n2h2(24))
call HGT_raise_alpha_OLR(G1H4(38),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(38),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(38),ex2(:),G1H2(3),m3h2x2(:,22),heltab2x4(:,:,22))
  call Hloop_QW_A(ntryL,G1H6(132),ex4(:),G1H2(4),m3h3x2(:,26),heltab2x6(:,:,52))
  call Hloop_Q_A(ntryL,G1H2(4),61,nMT,G2H2(45),n2h2(25))
call HGT_raise_alpha_OLR(G1H6(133),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(133),2,5,6)
  call Hloop_VA_Q(ntryL,G1H6(133),ex2(:),G1H3(4),m3h2x3(:,27),heltab2x6(:,:,53))
  call Hloop_QW_A(ntryL,G1H6(138),ex4(:),G1H2(4),m3h3x2(:,27),heltab2x6(:,:,54))
  call Hloop_Q_A(ntryL,G1H2(4),61,nMT,G2H2(46),n2h2(26))
call HGT_raise_alpha_OLR(G1H6(139),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(139),2,5,6)
  call Hloop_VA_Q(ntryL,G1H6(139),ex2(:),G1H3(5),m3h2x3(:,28),heltab2x6(:,:,55))
  call Hloop_QW_A(ntryL,G1H6(144),ex4(:),G1H2(4),m3h3x2(:,28),heltab2x6(:,:,56))
  call Hloop_Q_A(ntryL,G1H2(4),61,nMT,G2H2(47),n2h2(27))
call HGT_raise_alpha_OLR(G1H6(145),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(145),2,5,6)
  call Hloop_VA_Q(ntryL,G1H6(145),ex2(:),G1H3(6),m3h2x3(:,29),heltab2x6(:,:,57))
  call Hotf_5pt_reduction(G2H2(1),RedSet_5(4),mass5set(:,3),  & 
G1H2(4),G1H2(5),G1H2(6),G1H2(7),G1H2(8),G1H2(9),2)
  call HG1shiftOLR(G1H2(5),16,2)
  call Hotf_5pt_reduction(G2H2(4),RedSet_5(5),mass5set(:,3),  & 
G1H2(10),G1H2(11),G1H2(12),G1H2(13),G1H2(14),G1H2(15),2)
  call HG1shiftOLR(G1H2(11),16,2)
  call Hotf_5pt_reduction(G2H2(7),RedSet_5(1),mass5set(:,1),  & 
G1H2(16),G1H2(17),G1H2(18),G1H2(19),G1H2(20),G1H2(21),2)
  call HG1shiftOLR(G1H2(17),16,2)
  call Hotf_5pt_reduction(G2H2(12),RedSet_5(2),mass5set(:,1),  & 
G1H2(22),G1H2(23),G1H2(24),G1H2(25),G1H2(26),G1H2(27),2)
  call HG1shiftOLR(G1H2(23),16,2)
  call Hotf_5pt_reduction(G2H3(1),RedSet_5(3),mass5set(:,2),  & 
G1H3(7),G1H3(8),G1H3(9),G1H3(10),G1H3(11),G1H3(12),3)
  call HG1shiftOLR(G1H3(8),8,3)
  call Hotf_5pt_reduction(G2H2(19),RedSet_5(8),mass5set(:,6),  & 
G1H2(28),G1H2(29),G1H2(30),G1H2(31),G1H2(32),G1H2(33),2)
  call HG1shiftOLR(G1H2(29),16,2)
  call Hotf_5pt_reduction(G2H2(22),RedSet_5(9),mass5set(:,6),  & 
G1H2(34),G1H2(35),G1H2(36),G1H2(37),G1H2(38),G1H2(39),2)
  call HG1shiftOLR(G1H2(35),16,2)
  call Hotf_5pt_reduction(G2H3(8),RedSet_5(9),mass5set(:,6),  & 
G1H3(13),G1H3(14),G1H3(15),G1H3(16),G1H3(17),G1H3(18),3)
  call HG1shiftOLR(G1H3(14),8,3)
  call Hotf_5pt_reduction(G2H2(27),RedSet_5(10),mass5set(:,7),  & 
G1H2(40),G1H2(41),G1H2(42),G1H2(43),G1H2(44),G1H2(45),2)
  call HG1shiftOLR(G1H2(41),16,2)
  call Hotf_5pt_reduction(G2H3(13),RedSet_5(10),mass5set(:,7),  & 
G1H3(19),G1H3(20),G1H3(21),G1H3(22),G1H3(23),G1H3(24),3)
  call HG1shiftOLR(G1H3(20),8,3)
  call Hotf_5pt_reduction(G2H3(16),RedSet_5(11),mass5set(:,8),  & 
G1H3(25),G1H3(26),G1H3(27),G1H3(28),G1H3(29),G1H3(30),3)
  call HG1shiftOLR(G1H3(26),8,3)
  call Hotf_5pt_reduction(G2H2(32),RedSet_5(12),mass5set(:,7),  & 
G1H2(46),G1H2(47),G1H2(48),G1H2(49),G1H2(50),G1H2(51),2)
  call HG1shiftOLR(G1H2(47),16,2)
  call Hotf_5pt_reduction(G2H3(23),RedSet_5(12),mass5set(:,7),  & 
G1H3(31),G1H3(32),G1H3(33),G1H3(34),G1H3(35),G1H3(36),3)
  call HG1shiftOLR(G1H3(32),4,3)
  call Hotf_5pt_reduction(G2H3(26),RedSet_5(13),mass5set(:,8),  & 
G1H3(37),G1H3(38),G1H3(39),G1H3(40),G1H3(41),G1H3(42),3)
  call HG1shiftOLR(G1H3(38),4,3)
  call Hotf_5pt_reduction(G2H3(31),RedSet_5(14),mass5set(:,9),  & 
G1H3(43),G1H3(44),G1H3(45),G1H3(46),G1H3(47),G1H3(48),3)
  call HG1shiftOLR(G1H3(44),8,3)
  call Hotf_5pt_reduction(G2H3(34),RedSet_5(15),mass5set(:,10),  & 
G1H3(49),G1H3(50),G1H3(51),G1H3(52),G1H3(53),G1H3(54),3)
  call HG1shiftOLR(G1H3(50),8,3)
  call Hotf_5pt_reduction(G2H3(39),RedSet_5(16),mass5set(:,10),  & 
G1H3(55),G1H3(56),G1H3(57),G1H3(58),G1H3(59),G1H3(60),3)
  call HG1shiftOLR(G1H3(56),4,3)
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(39),ex2(:),G2tensor(1),m3h2x1(:,1),heltab2x2(:,:,1))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(42),ex2(:),G2tensor(2),m3h2x1(:,2),heltab2x2(:,:,2))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(45),ex2(:),G2tensor(3),m3h2x1(:,3),heltab2x2(:,:,3))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(4),47,ex5(:),16,G2tensor(4),m3h2x1(:,4),heltab2x2(:,:,4))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(5),0,ex5(:),16,G2tensor(5),m3h2x1(:,5),heltab2x2(:,:,5))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(10),47,ex5(:),16,G2tensor(6),m3h2x1(:,6),heltab2x2(:,:,6))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(11),0,ex5(:),16,G2tensor(7),m3h2x1(:,7),heltab2x2(:,:,7))
  call Hloop_AV_Q(ntryL,G1H2(16),ex5(:),G1H1(1),m3h2x1(:,8),heltab2x2(:,:,8))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(8),n2h1(3))
  call Hloop_AV_Q(ntryL,G1H2(17),ex5(:),G1H1(1),m3h2x1(:,9),heltab2x2(:,:,9))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nMT,G2tensor(9),n2h1(4))
  call Hloop_QV_A(ntryL,G1H2(22),ex5(:),G1H1(1),m3h2x1(:,10),heltab2x2(:,:,10))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(10),n2h1(5))
  call Hloop_QV_A(ntryL,G1H2(23),ex5(:),G1H1(1),m3h2x1(:,11),heltab2x2(:,:,11))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMT,G2tensor(11),n2h1(6))
  call Hloop_AW_Q(ntryL,G1H3(7),ex4(:),G1H1(1),m3h3x1(:,1),heltab2x3(:,:,1))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(12),n2h1(7))
  call Hloop_AW_Q(ntryL,G1H3(8),ex4(:),G1H1(1),m3h3x1(:,2),heltab2x3(:,:,2))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(13),n2h1(8))
  call Hloop_QV_A(ntryL,G1H2(28),ex5(:),G1H1(1),m3h2x1(:,12),heltab2x2(:,:,12))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(14),n2h1(9))
  call Hloop_QV_A(ntryL,G1H2(29),ex5(:),G1H1(1),m3h2x1(:,13),heltab2x2(:,:,13))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(15),n2h1(10))
  call Hloop_AV_Q(ntryL,G1H2(34),ex5(:),G1H1(1),m3h2x1(:,14),heltab2x2(:,:,14))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(16),n2h1(11))
  call Hloop_AV_Q(ntryL,G1H2(35),ex5(:),G1H1(1),m3h2x1(:,15),heltab2x2(:,:,15))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(17),n2h1(12))
  call Hloop_AW_Q(ntryL,G1H3(13),ex4(:),G1H1(1),m3h3x1(:,3),heltab2x3(:,:,3))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(18),n2h1(13))
  call Hloop_AW_Q(ntryL,G1H3(14),ex4(:),G1H1(1),m3h3x1(:,4),heltab2x3(:,:,4))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(19),n2h1(14))
  call Hloop_QV_A(ntryL,G1H2(40),ex5(:),G1H1(1),m3h2x1(:,16),heltab2x2(:,:,16))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(20),n2h1(15))
  call Hloop_QV_A(ntryL,G1H2(41),ex5(:),G1H1(1),m3h2x1(:,17),heltab2x2(:,:,17))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMT,G2tensor(21),n2h1(16))
  call Hloop_QW_A(ntryL,G1H3(19),ex4(:),G1H1(1),m3h3x1(:,5),heltab2x3(:,:,5))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(22),n2h1(17))
  call Hloop_QW_A(ntryL,G1H3(20),ex4(:),G1H1(1),m3h3x1(:,6),heltab2x3(:,:,6))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(23),n2h1(18))
  call Hloop_QW_A(ntryL,G1H3(25),ex4(:),G1H1(1),m3h3x1(:,7),heltab2x3(:,:,7))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(24),n2h1(19))
  call Hloop_QW_A(ntryL,G1H3(26),ex4(:),G1H1(1),m3h3x1(:,8),heltab2x3(:,:,8))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(25),n2h1(20))
  call Hloop_AV_Q(ntryL,G1H2(46),ex5(:),G1H1(1),m3h2x1(:,18),heltab2x2(:,:,18))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(26),n2h1(21))
  call Hloop_AV_Q(ntryL,G1H2(47),ex5(:),G1H1(1),m3h2x1(:,19),heltab2x2(:,:,19))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nMT,G2tensor(27),n2h1(22))
  call Hloop_AW_Q(ntryL,G1H3(31),ex3(:),G1H1(1),m3h3x1(:,9),heltab2x3(:,:,9))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(28),n2h1(23))
  call Hloop_AW_Q(ntryL,G1H3(32),ex3(:),G1H1(1),m3h3x1(:,10),heltab2x3(:,:,10))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(29),n2h1(24))
  call Hloop_AW_Q(ntryL,G1H3(37),ex3(:),G1H1(1),m3h3x1(:,11),heltab2x3(:,:,11))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(30),n2h1(25))
  call Hloop_AW_Q(ntryL,G1H3(38),ex3(:),G1H1(1),m3h3x1(:,12),heltab2x3(:,:,12))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(31),n2h1(26))
  call Hloop_AW_Q(ntryL,G1H3(43),ex4(:),G1H1(1),m3h3x1(:,13),heltab2x3(:,:,13))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(32),n2h1(27))
  call Hloop_AW_Q(ntryL,G1H3(44),ex4(:),G1H1(1),m3h3x1(:,14),heltab2x3(:,:,14))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(33),n2h1(28))
  call Hloop_QW_A(ntryL,G1H3(49),ex4(:),G1H1(1),m3h3x1(:,15),heltab2x3(:,:,15))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(34),n2h1(29))
  call Hloop_QW_A(ntryL,G1H3(50),ex4(:),G1H1(1),m3h3x1(:,16),heltab2x3(:,:,16))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(35),n2h1(30))
  call Hloop_AW_Q(ntryL,G1H3(55),ex3(:),G1H1(1),m3h3x1(:,17),heltab2x3(:,:,17))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(36),n2h1(31))
  call Hloop_AW_Q(ntryL,G1H3(56),ex3(:),G1H1(1),m3h3x1(:,18),heltab2x3(:,:,18))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(37),n2h1(32))
  call Hotf_5pt_reduction_last(G2tensor(1),RedSet_5(6),mass5set(:,4),  & 
G1tensor(1),G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(5),G1tensor(6))
  call G_TensorShift(G1tensor(2),2)
  call Hotf_5pt_reduction_last(G2tensor(2),RedSet_5(5),mass5set(:,3),  & 
G1tensor(7),G1tensor(8),G1tensor(9),G1tensor(10),G1tensor(11),G1tensor(12))
  call G_TensorShift(G1tensor(8),2)
  call Hotf_5pt_reduction_last(G2tensor(3),RedSet_5(7),mass5set(:,5),  & 
G1tensor(13),G1tensor(14),G1tensor(15),G1tensor(16),G1tensor(17),G1tensor(18))
  call G_TensorShift(G1tensor(14),2)
  call Hotf_5pt_reduction_last(G2tensor(4),RedSet_5(4),mass5set(:,3),  & 
G1tensor(19),G1tensor(20),G1tensor(21),G1tensor(22),G1tensor(23),G1tensor(24))
  call G_TensorShift(G1tensor(20),16)
  call Hotf_5pt_reduction_last(G2tensor(6),RedSet_5(5),mass5set(:,3),  & 
G1tensor(25),G1tensor(26),G1tensor(27),G1tensor(28),G1tensor(29),G1tensor(30))
  call G_TensorShift(G1tensor(26),16)
  call Hotf_5pt_reduction_last(G2tensor(8),RedSet_5(1),mass5set(:,1),  & 
G1tensor(31),G1tensor(32),G1tensor(33),G1tensor(34),G1tensor(35),G1tensor(36))
  call G_TensorShift(G1tensor(32),16)
  call Hotf_5pt_reduction_last(G2tensor(10),RedSet_5(2),mass5set(:,1),  & 
G1tensor(37),G1tensor(38),G1tensor(39),G1tensor(40),G1tensor(41),G1tensor(42))
  call G_TensorShift(G1tensor(38),16)
  call Hotf_5pt_reduction_last(G2tensor(12),RedSet_5(3),mass5set(:,2),  & 
G1tensor(43),G1tensor(44),G1tensor(45),G1tensor(46),G1tensor(47),G1tensor(48))
  call G_TensorShift(G1tensor(44),8)
  call Hotf_5pt_reduction_last(G2tensor(14),RedSet_5(8),mass5set(:,6),  & 
G1tensor(49),G1tensor(50),G1tensor(51),G1tensor(52),G1tensor(53),G1tensor(54))
  call G_TensorShift(G1tensor(50),16)
  call Hotf_5pt_reduction_last(G2tensor(16),RedSet_5(9),mass5set(:,6),  & 
G1tensor(55),G1tensor(56),G1tensor(57),G1tensor(58),G1tensor(59),G1tensor(60))
  call G_TensorShift(G1tensor(56),16)
  call Hotf_5pt_reduction_last(G2tensor(18),RedSet_5(9),mass5set(:,6),  & 
G1tensor(61),G1tensor(62),G1tensor(63),G1tensor(64),G1tensor(65),G1tensor(66))
  call G_TensorShift(G1tensor(62),8)
  call Hotf_5pt_reduction_last(G2tensor(20),RedSet_5(10),mass5set(:,7),  & 
G1tensor(67),G1tensor(68),G1tensor(69),G1tensor(70),G1tensor(71),G1tensor(72))
  call G_TensorShift(G1tensor(68),16)
  call Hotf_5pt_reduction_last(G2tensor(22),RedSet_5(10),mass5set(:,7),  & 
G1tensor(73),G1tensor(74),G1tensor(75),G1tensor(76),G1tensor(77),G1tensor(78))
  call G_TensorShift(G1tensor(74),8)
  call Hotf_5pt_reduction_last(G2tensor(24),RedSet_5(11),mass5set(:,8),  & 
G1tensor(79),G1tensor(80),G1tensor(81),G1tensor(82),G1tensor(83),G1tensor(84))
  call G_TensorShift(G1tensor(80),8)
  call Hotf_5pt_reduction_last(G2tensor(26),RedSet_5(12),mass5set(:,7),  & 
G1tensor(85),G1tensor(86),G1tensor(87),G1tensor(88),G1tensor(89),G1tensor(90))
  call G_TensorShift(G1tensor(86),16)
  call Hotf_5pt_reduction_last(G2tensor(28),RedSet_5(12),mass5set(:,7),  & 
G1tensor(91),G1tensor(92),G1tensor(93),G1tensor(94),G1tensor(95),G1tensor(96))
  call G_TensorShift(G1tensor(92),4)
  call Hotf_5pt_reduction_last(G2tensor(30),RedSet_5(13),mass5set(:,8),  & 
G1tensor(97),G1tensor(98),G1tensor(99),G1tensor(100),G1tensor(101),G1tensor(102))
  call G_TensorShift(G1tensor(98),4)
  call Hotf_5pt_reduction_last(G2tensor(32),RedSet_5(14),mass5set(:,9),  & 
G1tensor(103),G1tensor(104),G1tensor(105),G1tensor(106),G1tensor(107),G1tensor(108))
  call G_TensorShift(G1tensor(104),8)
  call Hotf_5pt_reduction_last(G2tensor(34),RedSet_5(15),mass5set(:,10),  & 
G1tensor(109),G1tensor(110),G1tensor(111),G1tensor(112),G1tensor(113),G1tensor(114))
  call G_TensorShift(G1tensor(110),8)
  call Hotf_5pt_reduction_last(G2tensor(36),RedSet_5(16),mass5set(:,10),  & 
G1tensor(115),G1tensor(116),G1tensor(117),G1tensor(118),G1tensor(119),G1tensor(120))
  call G_TensorShift(G1tensor(116),4)
  call ol_merge_tensors(T1sum(1),[G1tensor(1)])
  call ol_merge_tensors(T1sum(2),[G1tensor(7)])
  call ol_merge_tensors(T1sum(3),[G1tensor(13)])
  call ol_merge_tensors(T1sum(4),[G1tensor(19)])
  call ol_merge_tensors(T1sum(5),[G1tensor(25)])
  call ol_merge_tensors(T1sum(6),[G1tensor(31)])
  call ol_merge_tensors(T1sum(7),[G1tensor(37)])
  call ol_merge_tensors(T1sum(8),[G1tensor(43)])
  call ol_merge_tensors(T1sum(9),[G1tensor(49)])
  call ol_merge_tensors(T1sum(10),[G1tensor(55)])
  call ol_merge_tensors(T1sum(11),[G1tensor(61)])
  call ol_merge_tensors(T1sum(12),[G1tensor(67)])
  call ol_merge_tensors(T1sum(13),[G1tensor(73)])
  call ol_merge_tensors(T1sum(14),[G1tensor(79)])
  call ol_merge_tensors(T1sum(15),[G1tensor(85)])
  call ol_merge_tensors(T1sum(16),[G1tensor(91)])
  call ol_merge_tensors(T1sum(17),[G1tensor(97)])
  call ol_merge_tensors(T1sum(18),[G1tensor(103)])
  call ol_merge_tensors(T1sum(19),[G1tensor(109)])
  call ol_merge_tensors(T1sum(20),[G1tensor(115)])
  Gcoeff(:)%j = (c(22)*M(2,:)%j+c(20)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(21),h0tab(:,21),[48,1,4,8,2],[0,nMT,nMB,nMT,0],6,0)
  call Hloop_GGG_G_12(ntryL,G0H144(1),ex6(:),ex5(:),G0H36(1),m4h2x2x36(:,1),heltab3x144(:,:,1))
  Gcoeff(:)%j = (c(22)*M(1,:)%j+c(20)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(22),h0tab(:,22),[48,1,4,8,2],[0,nMT,nMB,nMT,0],6,0)
  call Hloop_GGG_G_12(ntryL,G0H144(1),ex5(:),ex6(:),G0H36(2),m4h2x2x36(:,2),heltab3x144(:,:,2))
  Gcoeff(:)%j = (c(22)*(M(1,:)%j-M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(23),h0tab(:,23),[48,1,4,8,2],[0,nMT,nMB,nMT,0],6,0)
  call Hloop_GGG_G_23(ntryL,G0H144(1),ex6(:),ex5(:),G0H36(3),m4h2x2x36(:,3),heltab3x144(:,:,3))
  Gcoeff(:)%j = (-(c(59)*M(2,:)%j)+c(58)*M(3,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(24),h0tab(:,24),[32,3,16,4,8],[0,0,0,0,0],5,1,wf4(:,10))
  call Hloop_QV_A(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,21),heltab2x144(:,:,21))
  call Hloop_Q_A(ntryL,G0H72(1),32,0,G1H72(1),n2h72(16))
  Gcoeff(:)%j = (-(c(57)*M(2,:)%j)+c(56)*M(3,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(25),h0tab(:,25),[32,3,16,4,8],[nMT,nMT,nMT,nMB,nMT],5,1,wf4(:,10))
  call Hloop_QV_A(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,22),heltab2x144(:,:,22))
  call Hloop_Q_A(ntryL,G0H72(1),32,nMT,G1H72(2),n2h72(17))
  Gcoeff(:)%j = (-(c(59)*M(1,:)%j)+c(58)*M(3,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(26),h0tab(:,26),[32,3,16,4,8],[0,0,0,0,0],5,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,23),heltab2x144(:,:,23))
  call Hloop_A_Q(ntryL,G0H72(1),32,0,G1H72(3),n2h72(18))
  Gcoeff(:)%j = (-(c(57)*M(1,:)%j)+c(56)*M(3,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(27),h0tab(:,27),[32,3,16,4,8],[nMB,nMB,nMB,nMT,nMB],5,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,24),heltab2x144(:,:,24))
  call Hloop_A_Q(ntryL,G0H72(1),32,nMB,G1H72(4),n2h72(19))
  Gcoeff(:)%j = (-(c(59)*M(1,:)%j)+c(58)*M(3,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(28),h0tab(:,28),[32,3,8,4,16],[0,0,0,0,0],5,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,25),heltab2x144(:,:,25))
  call Hloop_A_Q(ntryL,G0H72(1),32,0,G1H72(5),n2h72(20))
  Gcoeff(:)%j = (-(c(57)*M(1,:)%j)+c(56)*M(3,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(29),h0tab(:,29),[32,3,8,4,16],[nMT,nMT,nMB,nMT,nMT],5,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,26),heltab2x144(:,:,26))
  call Hloop_A_Q(ntryL,G0H72(1),32,nMT,G1H72(6),n2h72(21))
  Gcoeff(:)%j = (-(c(59)*M(2,:)%j)+c(58)*M(3,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(30),h0tab(:,30),[32,3,8,4,16],[0,0,0,0,0],5,1,wf4(:,10))
  call Hloop_QV_A(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,27),heltab2x144(:,:,27))
  call Hloop_Q_A(ntryL,G0H72(1),32,0,G1H72(7),n2h72(22))
  Gcoeff(:)%j = (-(c(57)*M(2,:)%j)+c(56)*M(3,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(31),h0tab(:,31),[32,3,8,4,16],[nMB,nMB,nMT,nMB,nMB],5,1,wf4(:,10))
  call Hloop_QV_A(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,28),heltab2x144(:,:,28))
  call Hloop_Q_A(ntryL,G0H72(1),32,nMB,G1H72(8),n2h72(23))
  Gcoeff(:)%j = (-(c(59)*M(1,:)%j)+c(58)*M(3,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(32),h0tab(:,32),[32,3,16,8,4],[0,0,0,0,0],5,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,29),heltab2x144(:,:,29))
  call Hloop_A_Q(ntryL,G0H72(1),32,0,G1H72(9),n2h72(24))
  Gcoeff(:)%j = (-(c(57)*M(1,:)%j)+c(56)*M(3,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(33),h0tab(:,33),[32,3,16,8,4],[nMT,nMT,nMT,nMB,nMT],5,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,30),heltab2x144(:,:,30))
  call Hloop_A_Q(ntryL,G0H72(1),32,nMT,G1H72(10),n2h72(25))
  Gcoeff(:)%j = (-(c(59)*M(2,:)%j)+c(58)*M(3,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(34),h0tab(:,34),[32,3,16,8,4],[0,0,0,0,0],5,1,wf4(:,10))
  call Hloop_QV_A(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,31),heltab2x144(:,:,31))
  call Hloop_Q_A(ntryL,G0H72(1),32,0,G1H72(11),n2h72(26))
  Gcoeff(:)%j = (-(c(57)*M(2,:)%j)+c(56)*M(3,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(35),h0tab(:,35),[32,3,16,8,4],[nMB,nMB,nMB,nMT,nMB],5,1,wf4(:,10))
  call Hloop_QV_A(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,32),heltab2x144(:,:,32))
  call Hloop_Q_A(ntryL,G0H72(1),32,nMB,G1H72(12),n2h72(27))
  Gcoeff(:)%j = (-(c(59)*M(2,:)%j)+c(58)*M(3,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(36),h0tab(:,36),[32,4,8,3,16],[0,0,0,0,0],5,1,wf4(:,10))
  call Hloop_QV_A(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,33),heltab2x144(:,:,33))
  call Hloop_Q_A(ntryL,G0H72(1),32,0,G1H72(13),n2h72(28))
  Gcoeff(:)%j = (-(c(57)*M(2,:)%j)+c(56)*M(3,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(37),h0tab(:,37),[32,4,8,3,16],[nMT,nMB,nMT,nMT,nMT],5,1,wf4(:,10))
  call Hloop_QV_A(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,34),heltab2x144(:,:,34))
  call Hloop_Q_A(ntryL,G0H72(1),32,nMT,G1H72(14),n2h72(29))
  Gcoeff(:)%j = (-(c(59)*M(1,:)%j)+c(58)*M(3,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(38),h0tab(:,38),[32,4,8,3,16],[0,0,0,0,0],5,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,35),heltab2x144(:,:,35))
  call Hloop_A_Q(ntryL,G0H72(1),32,0,G1H72(15),n2h72(30))
  Gcoeff(:)%j = (-(c(57)*M(1,:)%j)+c(56)*M(3,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(39),h0tab(:,39),[32,4,8,3,16],[nMB,nMT,nMB,nMB,nMB],5,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,36),heltab2x144(:,:,36))
  call Hloop_A_Q(ntryL,G0H72(1),32,nMB,G1H72(16),n2h72(31))
  Gcoeff(:)%j = (-(c(59)*M(2,:)%j)+c(58)*M(3,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(40),h0tab(:,40),[32,3,4,8,16],[0,0,0,0,0],5,1,wf4(:,10))
  call Hloop_QV_A(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,37),heltab2x144(:,:,37))
  call Hloop_Q_A(ntryL,G0H72(1),32,0,G1H72(17),n2h72(32))
  Gcoeff(:)%j = (-(c(57)*M(2,:)%j)+c(56)*M(3,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(41),h0tab(:,41),[32,3,4,8,16],[nMT,nMT,nMB,nMT,nMT],5,1,wf4(:,10))
  call Hloop_QV_A(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,38),heltab2x144(:,:,38))
  call Hloop_Q_A(ntryL,G0H72(1),32,nMT,G1H72(18),n2h72(33))
  Gcoeff(:)%j = (-(c(59)*M(1,:)%j)+c(58)*M(3,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(42),h0tab(:,42),[32,3,4,8,16],[0,0,0,0,0],5,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,39),heltab2x144(:,:,39))
  call Hloop_A_Q(ntryL,G0H72(1),32,0,G1H72(19),n2h72(34))
  Gcoeff(:)%j = (-(c(57)*M(1,:)%j)+c(56)*M(3,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(43),h0tab(:,43),[32,3,4,8,16],[nMB,nMB,nMT,nMB,nMB],5,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,40),heltab2x144(:,:,40))
  call Hloop_A_Q(ntryL,G0H72(1),32,nMB,G1H72(20),n2h72(35))
  Gcoeff(:)%j = (-(c(59)*M(1,:)%j)+c(58)*M(3,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(44),h0tab(:,44),[32,8,4,3,16],[0,0,0,0,0],5,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,41),heltab2x144(:,:,41))
  call Hloop_A_Q(ntryL,G0H72(1),32,0,G1H72(21),n2h72(36))
  Gcoeff(:)%j = (-(c(57)*M(1,:)%j)+c(56)*M(3,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(45),h0tab(:,45),[32,8,4,3,16],[nMT,nMB,nMT,nMT,nMT],5,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,42),heltab2x144(:,:,42))
  call Hloop_A_Q(ntryL,G0H72(1),32,nMT,G1H72(22),n2h72(37))
  Gcoeff(:)%j = (-(c(59)*M(2,:)%j)+c(58)*M(3,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(46),h0tab(:,46),[32,8,4,3,16],[0,0,0,0,0],5,1,wf4(:,10))
  call Hloop_QV_A(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,43),heltab2x144(:,:,43))
  call Hloop_Q_A(ntryL,G0H72(1),32,0,G1H72(23),n2h72(38))
  Gcoeff(:)%j = (-(c(57)*M(2,:)%j)+c(56)*M(3,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(47),h0tab(:,47),[32,8,4,3,16],[nMB,nMT,nMB,nMB,nMB],5,1,wf4(:,10))
  call Hloop_QV_A(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,44),heltab2x144(:,:,44))
  call Hloop_Q_A(ntryL,G0H72(1),32,nMB,G1H72(24),n2h72(39))
  Gcoeff(:)%j = (-(c(59)*M(1,:)%j)+c(58)*M(3,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(48),h0tab(:,48),[32,3,8,16,4],[0,0,0,0,0],5,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,45),heltab2x144(:,:,45))
  call Hloop_A_Q(ntryL,G0H72(1),32,0,G1H72(25),n2h72(40))
  Gcoeff(:)%j = (-(c(57)*M(1,:)%j)+c(56)*M(3,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(49),h0tab(:,49),[32,3,8,16,4],[nMT,nMT,nMB,nMB,nMT],5,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,46),heltab2x144(:,:,46))
  call Hloop_A_Q(ntryL,G0H72(1),32,nMT,G1H72(26),n2h72(41))
  Gcoeff(:)%j = (-(c(59)*M(2,:)%j)+c(58)*M(3,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(50),h0tab(:,50),[32,3,8,16,4],[0,0,0,0,0],5,1,wf4(:,10))
  call Hloop_QV_A(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,47),heltab2x144(:,:,47))
  call Hloop_Q_A(ntryL,G0H72(1),32,0,G1H72(27),n2h72(42))
  Gcoeff(:)%j = (-(c(57)*M(2,:)%j)+c(56)*M(3,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(51),h0tab(:,51),[32,3,8,16,4],[nMB,nMB,nMT,nMT,nMB],5,1,wf4(:,10))
  call Hloop_QV_A(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,48),heltab2x144(:,:,48))
  call Hloop_Q_A(ntryL,G0H72(1),32,nMB,G1H72(28),n2h72(43))
  Gcoeff(:)%j = (-(c(59)*M(2,:)%j)+c(58)*M(3,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(52),h0tab(:,52),[32,4,16,3,8],[0,0,0,0,0],5,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,49),heltab2x144(:,:,49))
  call Hloop_A_Q(ntryL,G0H72(1),32,0,G1H72(29),n2h72(44))
  Gcoeff(:)%j = (-(c(57)*M(2,:)%j)+c(56)*M(3,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(53),h0tab(:,53),[32,4,16,3,8],[nMB,nMT,nMT,nMT,nMB],5,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,50),heltab2x144(:,:,50))
  call Hloop_A_Q(ntryL,G0H72(1),32,nMB,G1H72(30),n2h72(45))
  Gcoeff(:)%j = (-(c(59)*M(1,:)%j)+c(58)*M(3,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(54),h0tab(:,54),[32,4,16,3,8],[0,0,0,0,0],5,1,wf4(:,10))
  call Hloop_QV_A(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,51),heltab2x144(:,:,51))
  call Hloop_Q_A(ntryL,G0H72(1),32,0,G1H72(31),n2h72(46))
  Gcoeff(:)%j = (-(c(57)*M(1,:)%j)+c(56)*M(3,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(55),h0tab(:,55),[32,4,16,3,8],[nMT,nMB,nMB,nMB,nMT],5,1,wf4(:,10))
  call Hloop_QV_A(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,52),heltab2x144(:,:,52))
  call Hloop_Q_A(ntryL,G0H72(1),32,nMT,G1H72(32),n2h72(47))
  Gcoeff(:)%j = (-(c(59)*M(2,:)%j)+c(58)*M(3,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(56),h0tab(:,56),[32,3,4,16,8],[0,0,0,0,0],5,1,wf4(:,10))
  call Hloop_QV_A(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,53),heltab2x144(:,:,53))
  call Hloop_Q_A(ntryL,G0H72(1),32,0,G1H72(33),n2h72(48))
  Gcoeff(:)%j = (-(c(57)*M(2,:)%j)+c(56)*M(3,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(57),h0tab(:,57),[32,3,4,16,8],[nMT,nMT,nMB,nMB,nMT],5,1,wf4(:,10))
  call Hloop_QV_A(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,54),heltab2x144(:,:,54))
  call Hloop_Q_A(ntryL,G0H72(1),32,nMT,G1H72(34),n2h72(49))
  Gcoeff(:)%j = (-(c(59)*M(1,:)%j)+c(58)*M(3,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(58),h0tab(:,58),[32,3,4,16,8],[0,0,0,0,0],5,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,55),heltab2x144(:,:,55))
  call Hloop_A_Q(ntryL,G0H72(1),32,0,G1H72(35),n2h72(50))
  Gcoeff(:)%j = (-(c(57)*M(1,:)%j)+c(56)*M(3,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(59),h0tab(:,59),[32,3,4,16,8],[nMB,nMB,nMT,nMT,nMB],5,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,56),heltab2x144(:,:,56))
  call Hloop_A_Q(ntryL,G0H72(1),32,nMB,G1H72(36),n2h72(51))
  Gcoeff(:)%j = (-(c(59)*M(1,:)%j)+c(58)*M(3,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(60),h0tab(:,60),[32,8,3,4,16],[0,0,0,0,0],5,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,57),heltab2x144(:,:,57))
  call Hloop_A_Q(ntryL,G0H72(1),32,0,G1H72(37),n2h72(52))
  Gcoeff(:)%j = (-(c(57)*M(1,:)%j)+c(56)*M(3,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(61),h0tab(:,61),[32,8,3,4,16],[nMT,nMB,nMB,nMT,nMT],5,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,58),heltab2x144(:,:,58))
  call Hloop_A_Q(ntryL,G0H72(1),32,nMT,G1H72(38),n2h72(53))
  Gcoeff(:)%j = (-(c(59)*M(2,:)%j)+c(58)*M(3,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(62),h0tab(:,62),[32,8,3,4,16],[0,0,0,0,0],5,1,wf4(:,10))
  call Hloop_QV_A(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,59),heltab2x144(:,:,59))
  call Hloop_Q_A(ntryL,G0H72(1),32,0,G1H72(39),n2h72(54))
  Gcoeff(:)%j = (-(c(57)*M(2,:)%j)+c(56)*M(3,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(63),h0tab(:,63),[32,8,3,4,16],[nMB,nMT,nMT,nMB,nMB],5,1,wf4(:,10))
  call Hloop_QV_A(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,60),heltab2x144(:,:,60))
  call Hloop_Q_A(ntryL,G0H72(1),32,nMB,G1H72(40),n2h72(55))
  Gcoeff(:)%j = (-(c(59)*M(1,:)%j)+c(58)*M(3,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(64),h0tab(:,64),[32,4,3,16,8],[0,0,0,0,0],5,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,61),heltab2x144(:,:,61))
  call Hloop_A_Q(ntryL,G0H72(1),32,0,G1H72(41),n2h72(56))
  Gcoeff(:)%j = (-(c(57)*M(1,:)%j)+c(56)*M(3,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(65),h0tab(:,65),[32,4,3,16,8],[nMB,nMT,nMT,nMT,nMB],5,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,62),heltab2x144(:,:,62))
  call Hloop_A_Q(ntryL,G0H72(1),32,nMB,G1H72(42),n2h72(57))
  Gcoeff(:)%j = (-(c(59)*M(2,:)%j)+c(58)*M(3,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(66),h0tab(:,66),[32,4,3,16,8],[0,0,0,0,0],5,1,wf4(:,10))
  call Hloop_QV_A(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,63),heltab2x144(:,:,63))
  call Hloop_Q_A(ntryL,G0H72(1),32,0,G1H72(43),n2h72(58))
  Gcoeff(:)%j = (-(c(57)*M(2,:)%j)+c(56)*M(3,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(67),h0tab(:,67),[32,4,3,16,8],[nMT,nMB,nMB,nMB,nMT],5,1,wf4(:,10))
  call Hloop_QV_A(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,64),heltab2x144(:,:,64))
  call Hloop_Q_A(ntryL,G0H72(1),32,nMT,G1H72(44),n2h72(59))
  Gcoeff(:)%j = (-(c(59)*M(2,:)%j)+c(58)*M(3,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(68),h0tab(:,68),[32,4,3,8,16],[0,0,0,0,0],5,1,wf4(:,10))
  call Hloop_QV_A(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,65),heltab2x144(:,:,65))
  call Hloop_Q_A(ntryL,G0H72(1),32,0,G1H72(45),n2h72(60))
  Gcoeff(:)%j = (-(c(57)*M(2,:)%j)+c(56)*M(3,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(69),h0tab(:,69),[32,4,3,8,16],[nMT,nMB,nMB,nMT,nMT],5,1,wf4(:,10))
  call Hloop_QV_A(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,66),heltab2x144(:,:,66))
  call Hloop_Q_A(ntryL,G0H72(1),32,nMT,G1H72(46),n2h72(61))
  Gcoeff(:)%j = (-(c(59)*M(1,:)%j)+c(58)*M(3,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(70),h0tab(:,70),[32,4,3,8,16],[0,0,0,0,0],5,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,67),heltab2x144(:,:,67))
  call Hloop_A_Q(ntryL,G0H72(1),32,0,G1H72(47),n2h72(62))
  Gcoeff(:)%j = (-(c(57)*M(1,:)%j)+c(56)*M(3,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(71),h0tab(:,71),[32,4,3,8,16],[nMB,nMT,nMT,nMB,nMB],5,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,68),heltab2x144(:,:,68))
  call Hloop_A_Q(ntryL,G0H72(1),32,nMB,G1H72(48),n2h72(63))
  Gcoeff(:)%j = (-(c(15)*M(3,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(72),h0tab(:,72),[32,5,16,2,8],[nMB,0,0,nMT,nMB],5,1,wf6(:,3))
  call Hloop_AV_Q(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,69),heltab2x144(:,:,69))
  call Hloop_A_Q(ntryL,G0H72(1),32,nMB,G1H72(49),n2h72(64))
  Gcoeff(:)%j = (c(22)*M(1,:)%j+c(20)*M(3,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(73),h0tab(:,73),[32,5,8,2,16],[0,nMB,nMT,0,0],5,1,wf6(:,3))
  call Hloop_UV_W(ntryL,G0H144(1),0,ex6(:),32,G1H72(50),m3h2x72(:,70),heltab2x144(:,:,70))
  Gcoeff(:)%j = (-(c(15)*M(3,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(74),h0tab(:,74),[32,2,8,16,5],[0,nMT,nMB,nMB,0],5,1,wf6(:,3))
  call Hloop_UV_W(ntryL,G0H144(1),0,ex6(:),32,G1H72(51),m3h2x72(:,71),heltab2x144(:,:,71))
  Gcoeff(:)%j = (c(22)*M(2,:)%j+c(20)*M(3,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(75),h0tab(:,75),[32,2,8,5,16],[0,nMT,nMB,0,0],5,1,wf6(:,3))
  call Hloop_UV_W(ntryL,G0H144(1),0,ex6(:),32,G1H72(52),m3h2x72(:,72),heltab2x144(:,:,72))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)+c(20)*M(3,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(76),h0tab(:,76),[32,5,2,8,16],[nMB,0,nMT,nMB,nMB],5,1,wf6(:,3))
  call Hloop_AV_Q(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,73),heltab2x144(:,:,73))
  call Hloop_A_Q(ntryL,G0H72(1),32,nMB,G1H72(53),n2h72(65))
  Gcoeff(:)%j = (-(c(19)*M(2,:)%j)+c(20)*M(3,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(77),h0tab(:,77),[32,8,2,5,16],[nMB,nMT,0,nMB,nMB],5,1,wf6(:,3))
  call Hloop_QV_A(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,74),heltab2x144(:,:,74))
  call Hloop_Q_A(ntryL,G0H72(1),32,nMB,G1H72(54),n2h72(66))
  Gcoeff(:)%j = (-(c(15)*M(3,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(78),h0tab(:,78),[32,2,16,8,5],[0,nMT,nMT,nMB,0],5,1,wf6(:,3))
  call Hloop_UV_W(ntryL,G0H144(1),0,ex6(:),32,G1H72(55),m3h2x72(:,75),heltab2x144(:,:,75))
  Gcoeff(:)%j = (c(15)*M(3,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(79),h0tab(:,79),[32,2,16,5,8],[nMT,0,0,nMB,nMT],5,1,wf6(:,3))
  call Hloop_QV_A(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,76),heltab2x144(:,:,76))
  call Hloop_Q_A(ntryL,G0H72(1),32,nMT,G1H72(56),n2h72(67))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)+c(20)*M(3,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(80),h0tab(:,80),[32,5,2,16,8],[nMB,0,nMT,nMT,nMB],5,1,wf6(:,3))
  call Hloop_AV_Q(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,77),heltab2x144(:,:,77))
  call Hloop_A_Q(ntryL,G0H72(1),32,nMB,G1H72(57),n2h72(68))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)+c(20)*M(3,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(81),h0tab(:,81),[32,8,5,2,16],[nMT,nMB,0,nMT,nMT],5,1,wf6(:,3))
  call Hloop_AV_Q(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,78),heltab2x144(:,:,78))
  call Hloop_A_Q(ntryL,G0H72(1),32,nMT,G1H72(58),n2h72(69))
  Gcoeff(:)%j = (-(c(19)*M(2,:)%j)+c(20)*M(3,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(82),h0tab(:,82),[32,2,5,16,8],[nMT,0,nMB,nMB,nMT],5,1,wf6(:,3))
  call Hloop_QV_A(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,79),heltab2x144(:,:,79))
  call Hloop_Q_A(ntryL,G0H72(1),32,nMT,G1H72(59),n2h72(70))
  Gcoeff(:)%j = (-(c(19)*M(2,:)%j)+c(20)*M(3,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(83),h0tab(:,83),[32,2,5,8,16],[nMT,0,nMB,nMT,nMT],5,1,wf6(:,3))
  call Hloop_QV_A(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,80),heltab2x144(:,:,80))
  call Hloop_Q_A(ntryL,G0H72(1),32,nMT,G1H72(60),n2h72(71))
  Gcoeff(:)%j = (-(c(15)*M(3,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(84),h0tab(:,84),[32,4,1,16,10],[nMB,nMT,0,0,nMB],5,1,wf6(:,4))
  call Hloop_AV_Q(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,81),heltab2x144(:,:,81))
  call Hloop_A_Q(ntryL,G0H72(1),32,nMB,G1H72(61),n2h72(72))
  Gcoeff(:)%j = (c(22)*M(2,:)%j+c(20)*M(3,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(85),h0tab(:,85),[32,10,4,1,16],[0,nMB,nMT,0,0],5,1,wf6(:,4))
  call Hloop_UV_W(ntryL,G0H144(1),0,ex6(:),32,G1H72(62),m3h2x72(:,82),heltab2x144(:,:,82))
  Gcoeff(:)%j = (c(15)*M(3,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(86),h0tab(:,86),[32,1,4,16,10],[0,nMT,nMB,nMB,0],5,1,wf6(:,4))
  call Hloop_UV_W(ntryL,G0H144(1),0,ex6(:),32,G1H72(63),m3h2x72(:,83),heltab2x144(:,:,83))
  Gcoeff(:)%j = (c(22)*M(1,:)%j+c(20)*M(3,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(87),h0tab(:,87),[32,1,4,10,16],[0,nMT,nMB,0,0],5,1,wf6(:,4))
  call Hloop_UV_W(ntryL,G0H144(1),0,ex6(:),32,G1H72(64),m3h2x72(:,84),heltab2x144(:,:,84))
  Gcoeff(:)%j = (-(c(19)*M(2,:)%j)+c(20)*M(3,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(88),h0tab(:,88),[32,10,1,4,16],[nMB,0,nMT,nMB,nMB],5,1,wf6(:,4))
  call Hloop_QV_A(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,85),heltab2x144(:,:,85))
  call Hloop_Q_A(ntryL,G0H72(1),32,nMB,G1H72(65),n2h72(73))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)+c(20)*M(3,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(89),h0tab(:,89),[32,4,1,10,16],[nMB,nMT,0,nMB,nMB],5,1,wf6(:,4))
  call Hloop_AV_Q(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,86),heltab2x144(:,:,86))
  call Hloop_A_Q(ntryL,G0H72(1),32,nMB,G1H72(66),n2h72(74))
  Gcoeff(:)%j = (c(15)*M(3,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(90),h0tab(:,90),[32,1,16,4,10],[0,nMT,nMT,nMB,0],5,1,wf6(:,4))
  call Hloop_UV_W(ntryL,G0H144(1),0,ex6(:),32,G1H72(67),m3h2x72(:,87),heltab2x144(:,:,87))
  Gcoeff(:)%j = (-(c(15)*M(3,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(91),h0tab(:,91),[32,1,16,10,4],[nMT,0,0,nMB,nMT],5,1,wf6(:,4))
  call Hloop_AV_Q(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,88),heltab2x144(:,:,88))
  call Hloop_A_Q(ntryL,G0H72(1),32,nMT,G1H72(68),n2h72(75))
  Gcoeff(:)%j = (-(c(19)*M(2,:)%j)+c(20)*M(3,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(92),h0tab(:,92),[32,4,16,1,10],[nMB,nMT,nMT,0,nMB],5,1,wf6(:,4))
  call Hloop_AV_Q(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,89),heltab2x144(:,:,89))
  call Hloop_A_Q(ntryL,G0H72(1),32,nMB,G1H72(69),n2h72(76))
  Gcoeff(:)%j = (-(c(19)*M(2,:)%j)+c(20)*M(3,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(93),h0tab(:,93),[32,4,10,1,16],[nMT,nMB,0,nMT,nMT],5,1,wf6(:,4))
  call Hloop_QV_A(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,90),heltab2x144(:,:,90))
  call Hloop_Q_A(ntryL,G0H72(1),32,nMT,G1H72(70),n2h72(77))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)+c(20)*M(3,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(94),h0tab(:,94),[32,1,10,16,4],[nMT,0,nMB,nMB,nMT],5,1,wf6(:,4))
  call Hloop_AV_Q(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,91),heltab2x144(:,:,91))
  call Hloop_A_Q(ntryL,G0H72(1),32,nMT,G1H72(71),n2h72(78))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)+c(20)*M(3,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(95),h0tab(:,95),[32,1,10,4,16],[nMT,0,nMB,nMT,nMT],5,1,wf6(:,4))
  call Hloop_AV_Q(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,92),heltab2x144(:,:,92))
  call Hloop_A_Q(ntryL,G0H72(1),32,nMT,G1H72(72),n2h72(79))
  Gcoeff(:)%j = (c(30)*M(2,:)%j-c(31)*M(3,:)%j) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(96),h0tab(:,96),[32,2,1,16,12],[nMT,0,nMT,nMT,nMT],5,1,wf9(:,1))
  call Hloop_QV_A(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,93),heltab2x144(:,:,93))
  call Hloop_Q_A(ntryL,G0H72(1),32,nMT,G1H72(73),n2h72(80))
  Gcoeff(:)%j = (-(c(8)*M(2,:)%j)+c(9)*M(3,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(97),h0tab(:,97),[32,2,1,16,12],[nMT,0,nMT,nMT,nMT],5,1,wf9(:,2))
  call Hloop_QV_A(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,94),heltab2x144(:,:,94))
  call Hloop_Q_A(ntryL,G0H72(1),32,nMT,G1H72(74),n2h72(81))
  Gcoeff(:)%j = (-(c(41)*M(2,:)%j)+c(42)*M(3,:)%j) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(98),h0tab(:,98),[32,2,1,16,12],[nMT,0,nMT,nMT,nMT],5,1,wf9(:,3))
  call Hloop_QV_A(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,95),heltab2x144(:,:,95))
  call Hloop_Q_A(ntryL,G0H72(1),32,nMT,G1H72(75),n2h72(82))
  Gcoeff(:)%j = (c(30)*M(2,:)%j-c(31)*M(3,:)%j) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(99),h0tab(:,99),[32,12,2,1,16],[nMT,nMT,0,nMT,nMT],5,1,wf9(:,1))
  call Hloop_QV_A(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,96),heltab2x144(:,:,96))
  call Hloop_Q_A(ntryL,G0H72(1),32,nMT,G1H72(76),n2h72(83))
  Gcoeff(:)%j = (-(c(8)*M(2,:)%j)+c(9)*M(3,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(100),h0tab(:,100),[32,12,2,1,16],[nMT,nMT,0,nMT,nMT],5,1,wf9(:,2))
  call Hloop_QV_A(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,97),heltab2x144(:,:,97))
  call Hloop_Q_A(ntryL,G0H72(1),32,nMT,G1H72(77),n2h72(84))
  Gcoeff(:)%j = (-(c(41)*M(2,:)%j)+c(42)*M(3,:)%j) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(101),h0tab(:,101),[32,12,2,1,16],[nMT,nMT,0,nMT,nMT],5,1,wf9(:,3))
  call Hloop_QV_A(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,98),heltab2x144(:,:,98))
  call Hloop_Q_A(ntryL,G0H72(1),32,nMT,G1H72(78),n2h72(85))
  Gcoeff(:)%j = (c(30)*M(1,:)%j-c(31)*M(3,:)%j) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(102),h0tab(:,102),[32,1,2,16,12],[nMT,0,nMT,nMT,nMT],5,1,wf9(:,1))
  call Hloop_AV_Q(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,99),heltab2x144(:,:,99))
  call Hloop_A_Q(ntryL,G0H72(1),32,nMT,G1H72(79),n2h72(86))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)+c(9)*M(3,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(103),h0tab(:,103),[32,1,2,16,12],[nMT,0,nMT,nMT,nMT],5,1,wf9(:,2))
  call Hloop_AV_Q(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,100),heltab2x144(:,:,100))
  call Hloop_A_Q(ntryL,G0H72(1),32,nMT,G1H72(80),n2h72(87))
  Gcoeff(:)%j = (-(c(41)*M(1,:)%j)+c(42)*M(3,:)%j) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(104),h0tab(:,104),[32,1,2,16,12],[nMT,0,nMT,nMT,nMT],5,1,wf9(:,3))
  call Hloop_AV_Q(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,101),heltab2x144(:,:,101))
  call Hloop_A_Q(ntryL,G0H72(1),32,nMT,G1H72(81),n2h72(88))
  Gcoeff(:)%j = (c(30)*M(1,:)%j-c(31)*M(3,:)%j) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(105),h0tab(:,105),[32,1,2,12,16],[nMT,0,nMT,nMT,nMT],5,1,wf9(:,1))
  call Hloop_AV_Q(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,102),heltab2x144(:,:,102))
  call Hloop_A_Q(ntryL,G0H72(1),32,nMT,G1H72(82),n2h72(89))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)+c(9)*M(3,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(106),h0tab(:,106),[32,1,2,12,16],[nMT,0,nMT,nMT,nMT],5,1,wf9(:,2))
  call Hloop_AV_Q(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,103),heltab2x144(:,:,103))
  call Hloop_A_Q(ntryL,G0H72(1),32,nMT,G1H72(83),n2h72(90))
  Gcoeff(:)%j = (-(c(41)*M(1,:)%j)+c(42)*M(3,:)%j) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(107),h0tab(:,107),[32,1,2,12,16],[nMT,0,nMT,nMT,nMT],5,1,wf9(:,3))
  call Hloop_AV_Q(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,104),heltab2x144(:,:,104))
  call Hloop_A_Q(ntryL,G0H72(1),32,nMT,G1H72(84),n2h72(91))
  Gcoeff(:)%j = (c(30)*M(1,:)%j-c(31)*M(3,:)%j) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(108),h0tab(:,108),[32,12,1,2,16],[nMT,nMT,0,nMT,nMT],5,1,wf9(:,1))
  call Hloop_AV_Q(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,105),heltab2x144(:,:,105))
  call Hloop_A_Q(ntryL,G0H72(1),32,nMT,G1H72(85),n2h72(92))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)+c(9)*M(3,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(109),h0tab(:,109),[32,12,1,2,16],[nMT,nMT,0,nMT,nMT],5,1,wf9(:,2))
  call Hloop_AV_Q(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,106),heltab2x144(:,:,106))
  call Hloop_A_Q(ntryL,G0H72(1),32,nMT,G1H72(86),n2h72(93))
  Gcoeff(:)%j = (-(c(41)*M(1,:)%j)+c(42)*M(3,:)%j) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(110),h0tab(:,110),[32,12,1,2,16],[nMT,nMT,0,nMT,nMT],5,1,wf9(:,3))
  call Hloop_AV_Q(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,107),heltab2x144(:,:,107))
  call Hloop_A_Q(ntryL,G0H72(1),32,nMT,G1H72(87),n2h72(94))
  Gcoeff(:)%j = (c(30)*M(2,:)%j-c(31)*M(3,:)%j) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(111),h0tab(:,111),[32,2,1,12,16],[nMT,0,nMT,nMT,nMT],5,1,wf9(:,1))
  call Hloop_QV_A(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,108),heltab2x144(:,:,108))
  call Hloop_Q_A(ntryL,G0H72(1),32,nMT,G1H72(88),n2h72(95))
  Gcoeff(:)%j = (-(c(8)*M(2,:)%j)+c(9)*M(3,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(112),h0tab(:,112),[32,2,1,12,16],[nMT,0,nMT,nMT,nMT],5,1,wf9(:,2))
  call Hloop_QV_A(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,109),heltab2x144(:,:,109))
  call Hloop_Q_A(ntryL,G0H72(1),32,nMT,G1H72(89),n2h72(96))
  Gcoeff(:)%j = (-(c(41)*M(2,:)%j)+c(42)*M(3,:)%j) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(113),h0tab(:,113),[32,2,1,12,16],[nMT,0,nMT,nMT,nMT],5,1,wf9(:,3))
  call Hloop_QV_A(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,110),heltab2x144(:,:,110))
  call Hloop_Q_A(ntryL,G0H72(1),32,nMT,G1H72(90),n2h72(97))
  Gcoeff(:)%j = (c(26)*M(3,:)%j) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(114),h0tab(:,114),[32,1,16,2,12],[nMT,0,0,nMT,nMT],5,1,wf9(:,1))
  call Hloop_AV_Q(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,111),heltab2x144(:,:,111))
  call Hloop_A_Q(ntryL,G0H72(1),32,nMT,G1H72(91),n2h72(98))
  Gcoeff(:)%j = (-(c(4)*M(3,:)%j)) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(115),h0tab(:,115),[32,1,16,2,12],[nMT,0,0,nMT,nMT],5,1,wf9(:,2))
  call Hloop_AV_Q(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,112),heltab2x144(:,:,112))
  call Hloop_A_Q(ntryL,G0H72(1),32,nMT,G1H72(92),n2h72(99))
  Gcoeff(:)%j = (-(c(37)*M(3,:)%j)) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(116),h0tab(:,116),[32,1,16,2,12],[nMT,0,0,nMT,nMT],5,1,wf9(:,3))
  call Hloop_AV_Q(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,113),heltab2x144(:,:,113))
  call Hloop_A_Q(ntryL,G0H72(1),32,nMT,G1H72(93),n2h72(100))
  Gcoeff(:)%j = (-(c(26)*M(3,:)%j)) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(117),h0tab(:,117),[32,1,16,12,2],[0,nMT,nMT,nMT,0],5,1,wf9(:,1))
  call Hloop_UV_W(ntryL,G0H144(1),0,ex6(:),32,G1H72(94),m3h2x72(:,114),heltab2x144(:,:,114))
  Gcoeff(:)%j = (c(4)*M(3,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(118),h0tab(:,118),[32,1,16,12,2],[0,nMT,nMT,nMT,0],5,1,wf9(:,2))
  call Hloop_UV_W(ntryL,G0H144(1),0,ex6(:),32,G1H72(95),m3h2x72(:,115),heltab2x144(:,:,115))
  Gcoeff(:)%j = (c(37)*M(3,:)%j) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(119),h0tab(:,119),[32,1,16,12,2],[0,nMT,nMT,nMT,0],5,1,wf9(:,3))
  call Hloop_UV_W(ntryL,G0H144(1),0,ex6(:),32,G1H72(96),m3h2x72(:,116),heltab2x144(:,:,116))
  Gcoeff(:)%j = (-(c(26)*M(3,:)%j)) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(120),h0tab(:,120),[32,2,16,1,12],[nMT,0,0,nMT,nMT],5,1,wf9(:,1))
  call Hloop_QV_A(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,117),heltab2x144(:,:,117))
  call Hloop_Q_A(ntryL,G0H72(1),32,nMT,G1H72(97),n2h72(101))
  Gcoeff(:)%j = (c(4)*M(3,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(121),h0tab(:,121),[32,2,16,1,12],[nMT,0,0,nMT,nMT],5,1,wf9(:,2))
  call Hloop_QV_A(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,118),heltab2x144(:,:,118))
  call Hloop_Q_A(ntryL,G0H72(1),32,nMT,G1H72(98),n2h72(102))
  Gcoeff(:)%j = (c(37)*M(3,:)%j) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(122),h0tab(:,122),[32,2,16,1,12],[nMT,0,0,nMT,nMT],5,1,wf9(:,3))
  call Hloop_QV_A(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,119),heltab2x144(:,:,119))
  call Hloop_Q_A(ntryL,G0H72(1),32,nMT,G1H72(99),n2h72(103))
  Gcoeff(:)%j = (-(c(33)*M(2,:)%j)-c(31)*M(3,:)%j) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(123),h0tab(:,123),[32,2,12,1,16],[0,nMT,nMT,0,0],5,1,wf9(:,1))
  call Hloop_UV_W(ntryL,G0H144(1),0,ex6(:),32,G1H72(100),m3h2x72(:,120),heltab2x144(:,:,120))
  Gcoeff(:)%j = (c(11)*M(2,:)%j+c(9)*M(3,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(124),h0tab(:,124),[32,2,12,1,16],[0,nMT,nMT,0,0],5,1,wf9(:,2))
  call Hloop_UV_W(ntryL,G0H144(1),0,ex6(:),32,G1H72(101),m3h2x72(:,121),heltab2x144(:,:,121))
  Gcoeff(:)%j = (c(44)*M(2,:)%j+c(42)*M(3,:)%j) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(125),h0tab(:,125),[32,2,12,1,16],[0,nMT,nMT,0,0],5,1,wf9(:,3))
  call Hloop_UV_W(ntryL,G0H144(1),0,ex6(:),32,G1H72(102),m3h2x72(:,122),heltab2x144(:,:,122))
  Gcoeff(:)%j = (-(c(26)*M(3,:)%j)) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(126),h0tab(:,126),[32,1,12,16,2],[0,nMT,nMT,nMT,0],5,1,wf9(:,1))
  call Hloop_UV_W(ntryL,G0H144(1),0,ex6(:),32,G1H72(103),m3h2x72(:,123),heltab2x144(:,:,123))
  Gcoeff(:)%j = (c(4)*M(3,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(127),h0tab(:,127),[32,1,12,16,2],[0,nMT,nMT,nMT,0],5,1,wf9(:,2))
  call Hloop_UV_W(ntryL,G0H144(1),0,ex6(:),32,G1H72(104),m3h2x72(:,124),heltab2x144(:,:,124))
  Gcoeff(:)%j = (c(37)*M(3,:)%j) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(128),h0tab(:,128),[32,1,12,16,2],[0,nMT,nMT,nMT,0],5,1,wf9(:,3))
  call Hloop_UV_W(ntryL,G0H144(1),0,ex6(:),32,G1H72(105),m3h2x72(:,125),heltab2x144(:,:,125))
  Gcoeff(:)%j = (-(c(33)*M(1,:)%j)-c(31)*M(3,:)%j) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(129),h0tab(:,129),[32,1,12,2,16],[0,nMT,nMT,0,0],5,1,wf9(:,1))
  call Hloop_UV_W(ntryL,G0H144(1),0,ex6(:),32,G1H72(106),m3h2x72(:,126),heltab2x144(:,:,126))
  Gcoeff(:)%j = (c(11)*M(1,:)%j+c(9)*M(3,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(130),h0tab(:,130),[32,1,12,2,16],[0,nMT,nMT,0,0],5,1,wf9(:,2))
  call Hloop_UV_W(ntryL,G0H144(1),0,ex6(:),32,G1H72(107),m3h2x72(:,127),heltab2x144(:,:,127))
  Gcoeff(:)%j = (c(44)*M(1,:)%j+c(42)*M(3,:)%j) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(131),h0tab(:,131),[32,1,12,2,16],[0,nMT,nMT,0,0],5,1,wf9(:,3))
  call Hloop_UV_W(ntryL,G0H144(1),0,ex6(:),32,G1H72(108),m3h2x72(:,128),heltab2x144(:,:,128))
  Gcoeff(:)%j = (c(17)*M(2,:)%j) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(132),h0tab(:,132),[32,2,8,4,17],[0,nMT,nMB,nMT,0],5,1,wf4(:,7))
  call Hloop_UV_W(ntryL,G0H144(1),0,ex6(:),32,G1H72(109),m3h2x72(:,129),heltab2x144(:,:,129))
  Gcoeff(:)%j = (-(c(19)*M(2,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(133),h0tab(:,133),[32,4,8,2,17],[nMT,nMB,nMT,0,nMT],5,1,wf4(:,7))
  call Hloop_QV_A(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,130),heltab2x144(:,:,130))
  call Hloop_Q_A(ntryL,G0H72(1),32,nMT,G1H72(110),n2h72(104))
  Gcoeff(:)%j = (-(c(19)*M(2,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(134),h0tab(:,134),[32,4,17,2,8],[nMB,nMT,0,nMT,nMB],5,1,wf4(:,7))
  call Hloop_AV_Q(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,131),heltab2x144(:,:,131))
  call Hloop_A_Q(ntryL,G0H72(1),32,nMB,G1H72(111),n2h72(105))
  Gcoeff(:)%j = (-(c(19)*M(2,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(135),h0tab(:,135),[32,2,17,4,8],[nMT,0,nMT,nMB,nMT],5,1,wf4(:,7))
  call Hloop_QV_A(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,132),heltab2x144(:,:,132))
  call Hloop_Q_A(ntryL,G0H72(1),32,nMT,G1H72(112),n2h72(106))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(136),h0tab(:,136),[32,1,4,8,18],[0,nMT,nMB,nMT,0],5,1,wf4(:,3))
  call Hloop_UV_W(ntryL,G0H144(1),0,ex6(:),32,G1H72(113),m3h2x72(:,133),heltab2x144(:,:,133))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(137),h0tab(:,137),[32,8,4,1,18],[nMT,nMB,nMT,0,nMT],5,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,134),heltab2x144(:,:,134))
  call Hloop_A_Q(ntryL,G0H72(1),32,nMT,G1H72(114),n2h72(107))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(138),h0tab(:,138),[32,4,1,18,8],[nMB,nMT,0,nMT,nMB],5,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,135),heltab2x144(:,:,135))
  call Hloop_A_Q(ntryL,G0H72(1),32,nMB,G1H72(115),n2h72(108))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(139),h0tab(:,139),[32,1,18,8,4],[nMT,0,nMT,nMB,nMT],5,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H144(1),ex6(:),G0H72(1),m3h2x72(:,136),heltab2x144(:,:,136))
  call Hloop_A_Q(ntryL,G0H72(1),32,nMT,G1H72(116),n2h72(109))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(140),h0tab(:,140),[33,4,8,2,16],[nMT,nMB,nMT,0,0],5,1,wf4(:,9))
  call Hloop_VQ_A(ntryL,G0H144(1),wf4(:,9),G0H36(4),m3h4x36(:,1),heltab2x144(:,:,137))
  call Hloop_Q_A(ntryL,G0H36(4),33,nMT,G1H36(9),n2h36(11))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(141),h0tab(:,141),[33,2,8,4,16],[0,nMT,nMB,nMT,nMT],5,1,wf4(:,9))
  call Hloop_AQ_V(ntryL,G0H144(1),wf4(:,9),G0H36(4),m3h4x36(:,2),heltab2x144(:,:,138))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(142),h0tab(:,142),[33,2,8,16,4],[0,nMT,nMB,nMB,nMT],5,1,wf4(:,9))
  call Hloop_AQ_V(ntryL,G0H144(1),wf4(:,9),G0H36(5),m3h4x36(:,3),heltab2x144(:,:,139))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(143),h0tab(:,143),[33,2,16,8,4],[0,nMT,nMT,nMB,nMT],5,1,wf4(:,9))
  call Hloop_AQ_V(ntryL,G0H144(1),wf4(:,9),G0H36(6),m3h4x36(:,4),heltab2x144(:,:,140))
  Gcoeff(:)%j = (c(17)*M(2,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(144),h0tab(:,144),[34,8,4,1,16],[nMT,nMB,nMT,0,0],5,1,wf4(:,5))
  call Hloop_VA_Q(ntryL,G0H144(1),wf4(:,5),G0H36(7),m3h4x36(:,5),heltab2x144(:,:,141))
  call Hloop_A_Q(ntryL,G0H36(7),34,nMT,G1H36(1),n2h36(12))
  Gcoeff(:)%j = (-(c(19)*M(2,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(145),h0tab(:,145),[34,1,4,8,16],[0,nMT,nMB,nMT,nMT],5,1,wf4(:,5))
  call Hloop_QA_V(ntryL,G0H144(1),wf4(:,5),G0H36(7),m3h4x36(:,6),heltab2x144(:,:,142))
  Gcoeff(:)%j = (-(c(19)*M(2,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(146),h0tab(:,146),[34,1,4,16,8],[0,nMT,nMB,nMB,nMT],5,1,wf4(:,5))
  call Hloop_QA_V(ntryL,G0H144(1),wf4(:,5),G0H36(8),m3h4x36(:,7),heltab2x144(:,:,143))
  Gcoeff(:)%j = (-(c(19)*M(2,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(147),h0tab(:,147),[34,1,16,4,8],[0,nMT,nMT,nMB,nMT],5,1,wf4(:,5))
  call Hloop_QA_V(ntryL,G0H144(1),wf4(:,5),G0H36(9),m3h4x36(:,8),heltab2x144(:,:,144))
  Gcoeff(:)%j = (c(14)*(M(1,:)%j-M(2,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(148),h0tab(:,148),[48,4,1,2,8],[nMB,nMT,0,nMT,nMB],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H144(1),wf4(:,1),G0H36(10),m3h4x36(:,9),heltab2x144(:,:,145))
  call Hloop_A_Q(ntryL,G0H36(10),48,nMB,G1H36(3),n2h36(13))
  Gcoeff(:)%j = (c(14)*(M(1,:)%j-M(2,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(149),h0tab(:,149),[48,2,1,4,8],[nMT,0,nMT,nMB,nMT],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H144(1),wf4(:,1),G0H36(10),m3h4x36(:,10),heltab2x144(:,:,146))
  call Hloop_Q_A(ntryL,G0H36(10),48,nMT,G1H36(4),n2h36(14))
  Gcoeff(:)%j = (c(14)*(M(1,:)%j-M(2,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(150),h0tab(:,150),[48,1,2,8,4],[nMT,0,nMT,nMB,nMT],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H144(1),wf4(:,1),G0H36(10),m3h4x36(:,11),heltab2x144(:,:,147))
  call Hloop_A_Q(ntryL,G0H36(10),48,nMT,G1H36(5),n2h36(15))
  Gcoeff(:)%j = (c(22)*(M(1,:)%j-M(2,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(151),h0tab(:,151),[48,1,4,8,2],[0,nMT,nMB,nMT,0],5,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H144(1),0,wf4(:,1),48,G1H36(6),m3h4x36(:,12),heltab2x144(:,:,148))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H36(1),[G1H36(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H36(9),[G1H36(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H36(6),[G0H36(3),G0H36(2),G0H36(1)])
  call Hloop_AW_Q(ntryL,G1H24(3),ex3(:),G1H8(1),m3h3x8(:,10),heltab2x24(:,:,20))
  call Hloop_A_Q(ntryL,G1H8(1),44,nMT,G2H8(1),n2h8(9))
  call Hloop_QW_A(ntryL,G1H24(9),ex4(:),G1H8(1),m3h3x8(:,11),heltab2x24(:,:,21))
  call Hloop_Q_A(ntryL,G1H8(1),44,nMT,G2H8(3),n2h8(10))
  call Hloop_AV_Q(ntryL,G1H24(15),ex5(:),G1H12(29),m3h2x12(:,11),heltab2x24(:,:,22))
  call Hloop_A_Q(ntryL,G1H12(29),52,nMT,G2H12(7),n2h12(37))
  call Hloop_AW_Q(ntryL,G1H36(1),ex4(:),G1H12(30),m3h3x12(:,17),heltab2x36(:,:,34))
  call Hloop_A_Q(ntryL,G1H12(30),42,nMB,G2H12(9),n2h12(38))
  call Hloop_QW_A(ntryL,G1H36(9),ex3(:),G1H12(47),m3h3x12(:,18),heltab2x36(:,:,35))
  call Hloop_Q_A(ntryL,G1H12(47),37,nMB,G2H12(10),n2h12(39))
  call Hloop_QW_A(ntryL,G1H36(16),ex3(:),G1H12(48),m3h3x12(:,19),heltab2x36(:,:,36))
  call Hloop_Q_A(ntryL,G1H12(48),37,nMB,G2H12(11),n2h12(40))
  call Hloop_QW_A(ntryL,G1H36(22),ex3(:),G1H12(65),m3h3x12(:,20),heltab2x36(:,:,37))
  call Hloop_Q_A(ntryL,G1H12(65),37,nMB,G2H12(13),n2h12(41))
  call Hloop_QV_A(ntryL,G1H36(27),ex5(:),G1H18(56),m3h2x18(:,18),heltab2x36(:,:,38))
  call Hloop_Q_A(ntryL,G1H18(56),49,nMT,G2H18(11),n2h18(22))
  call Hloop_VQ_A(ntryL,G1H36(6),ex1(:),G1H18(57),m3h2x18(:,19),heltab2x36(:,:,39))
  call Hloop_Q_A(ntryL,G1H18(57),49,nMT,G2H18(13),n2h18(23))
  call Hloop_QV_A(ntryL,G1H72(1),wf4(:,10),G1H18(4),m3h4x18(:,1),heltab2x72(:,:,21))
  call Hloop_Q_A(ntryL,G1H18(4),35,0,G2H18(14),n2h18(24))
  call Hloop_QV_A(ntryL,G1H72(2),wf4(:,10),G1H18(5),m3h4x18(:,2),heltab2x72(:,:,22))
  call Hloop_Q_A(ntryL,G1H18(5),35,nMT,G2H18(1),n2h18(25))
  call Hloop_AV_Q(ntryL,G1H72(3),wf4(:,10),G1H18(8),m3h4x18(:,3),heltab2x72(:,:,23))
  call Hloop_A_Q(ntryL,G1H18(8),35,0,G2H18(2),n2h18(26))
  call Hloop_AV_Q(ntryL,G1H72(4),wf4(:,10),G1H18(9),m3h4x18(:,4),heltab2x72(:,:,24))
  call Hloop_A_Q(ntryL,G1H18(9),35,nMB,G2H18(3),n2h18(27))
  call Hloop_AV_Q(ntryL,G1H72(5),wf4(:,10),G1H18(10),m3h4x18(:,5),heltab2x72(:,:,25))
  call Hloop_A_Q(ntryL,G1H18(10),35,0,G2H18(4),n2h18(28))
  call Hloop_AV_Q(ntryL,G1H72(6),wf4(:,10),G1H18(11),m3h4x18(:,6),heltab2x72(:,:,26))
  call Hloop_A_Q(ntryL,G1H18(11),35,nMT,G2H18(5),n2h18(29))
  call Hloop_QV_A(ntryL,G1H72(7),wf4(:,10),G1H18(14),m3h4x18(:,7),heltab2x72(:,:,27))
  call Hloop_Q_A(ntryL,G1H18(14),35,0,G2H18(6),n2h18(30))
  call Hloop_QV_A(ntryL,G1H72(8),wf4(:,10),G1H18(15),m3h4x18(:,8),heltab2x72(:,:,28))
  call Hloop_Q_A(ntryL,G1H18(15),35,nMB,G2H18(7),n2h18(31))
  call Hloop_AV_Q(ntryL,G1H72(9),wf4(:,10),G1H18(16),m3h4x18(:,9),heltab2x72(:,:,29))
  call Hloop_A_Q(ntryL,G1H18(16),35,0,G2H18(8),n2h18(32))
  call Hloop_AV_Q(ntryL,G1H72(10),wf4(:,10),G1H18(17),m3h4x18(:,10),heltab2x72(:,:,30))
  call Hloop_A_Q(ntryL,G1H18(17),35,nMT,G2H18(15),n2h18(33))
  call Hloop_QV_A(ntryL,G1H72(11),wf4(:,10),G1H18(20),m3h4x18(:,11),heltab2x72(:,:,31))
  call Hloop_Q_A(ntryL,G1H18(20),35,0,G2H18(16),n2h18(34))
  call Hloop_QV_A(ntryL,G1H72(12),wf4(:,10),G1H18(21),m3h4x18(:,12),heltab2x72(:,:,32))
  call Hloop_Q_A(ntryL,G1H18(21),35,nMB,G2H18(17),n2h18(35))
  call Hloop_QW_A(ntryL,G1H72(13),ex3(:),G1H24(1),m3h3x24(:,8),heltab2x72(:,:,33))
  call Hloop_Q_A(ntryL,G1H24(1),36,0,G2H24(4),n2h24(11))
  call Hloop_QW_A(ntryL,G1H72(14),ex3(:),G1H24(2),m3h3x24(:,9),heltab2x72(:,:,34))
  call Hloop_Q_A(ntryL,G1H24(2),36,nMB,G2H24(5),n2h24(12))
  call Hloop_AW_Q(ntryL,G1H72(15),ex3(:),G1H24(4),m3h3x24(:,10),heltab2x72(:,:,35))
  call Hloop_A_Q(ntryL,G1H24(4),36,0,G2H24(6),n2h24(13))
  call Hloop_AW_Q(ntryL,G1H72(16),ex3(:),G1H24(5),m3h3x24(:,11),heltab2x72(:,:,36))
  call Hloop_A_Q(ntryL,G1H24(5),36,nMT,G2H24(7),n2h24(14))
  call Hloop_QV_A(ntryL,G1H72(17),wf4(:,10),G1H18(22),m3h4x18(:,13),heltab2x72(:,:,37))
  call Hloop_Q_A(ntryL,G1H18(22),35,0,G2H18(18),n2h18(36))
  call Hloop_QV_A(ntryL,G1H72(18),wf4(:,10),G1H18(23),m3h4x18(:,14),heltab2x72(:,:,38))
  call Hloop_Q_A(ntryL,G1H18(23),35,nMT,G2H18(19),n2h18(37))
  call Hloop_AV_Q(ntryL,G1H72(19),wf4(:,10),G1H18(26),m3h4x18(:,15),heltab2x72(:,:,39))
  call Hloop_A_Q(ntryL,G1H18(26),35,0,G2H18(20),n2h18(38))
  call Hloop_AV_Q(ntryL,G1H72(20),wf4(:,10),G1H18(27),m3h4x18(:,16),heltab2x72(:,:,40))
  call Hloop_A_Q(ntryL,G1H18(27),35,nMB,G2H18(21),n2h18(39))
  call Hloop_AW_Q(ntryL,G1H72(21),ex4(:),G1H24(6),m3h3x24(:,12),heltab2x72(:,:,41))
  call Hloop_A_Q(ntryL,G1H24(6),40,0,G2H24(1),n2h24(15))
  call Hloop_AW_Q(ntryL,G1H72(22),ex4(:),G1H24(7),m3h3x24(:,13),heltab2x72(:,:,42))
  call Hloop_A_Q(ntryL,G1H24(7),40,nMB,G2H24(2),n2h24(16))
  call Hloop_QW_A(ntryL,G1H72(23),ex4(:),G1H24(8),m3h3x24(:,14),heltab2x72(:,:,43))
  call Hloop_Q_A(ntryL,G1H24(8),40,0,G2H24(3),n2h24(17))
  call Hloop_QW_A(ntryL,G1H72(24),ex4(:),G1H24(10),m3h3x24(:,15),heltab2x72(:,:,44))
  call Hloop_Q_A(ntryL,G1H24(10),40,nMT,G2H24(8),n2h24(18))
  call Hloop_AV_Q(ntryL,G1H72(25),wf4(:,10),G1H18(28),m3h4x18(:,17),heltab2x72(:,:,45))
  call Hloop_A_Q(ntryL,G1H18(28),35,0,G2H18(22),n2h18(40))
  call Hloop_AV_Q(ntryL,G1H72(26),wf4(:,10),G1H18(29),m3h4x18(:,18),heltab2x72(:,:,46))
  call Hloop_A_Q(ntryL,G1H18(29),35,nMT,G2H18(23),n2h18(41))
  call Hloop_QV_A(ntryL,G1H72(27),wf4(:,10),G1H18(32),m3h4x18(:,19),heltab2x72(:,:,47))
  call Hloop_Q_A(ntryL,G1H18(32),35,0,G2H18(24),n2h18(42))
  call Hloop_QV_A(ntryL,G1H72(28),wf4(:,10),G1H18(33),m3h4x18(:,20),heltab2x72(:,:,48))
  call Hloop_Q_A(ntryL,G1H18(33),35,nMB,G2H18(25),n2h18(43))
  call Hloop_AW_Q(ntryL,G1H72(29),ex3(:),G1H24(11),m3h3x24(:,16),heltab2x72(:,:,49))
  call Hloop_A_Q(ntryL,G1H24(11),36,0,G2H24(9),n2h24(19))
  call Hloop_AW_Q(ntryL,G1H72(30),ex3(:),G1H24(12),m3h3x24(:,17),heltab2x72(:,:,50))
  call Hloop_A_Q(ntryL,G1H24(12),36,nMT,G2H24(10),n2h24(20))
  call Hloop_QW_A(ntryL,G1H72(31),ex3(:),G1H24(13),m3h3x24(:,18),heltab2x72(:,:,51))
  call Hloop_Q_A(ntryL,G1H24(13),36,0,G2H24(11),n2h24(21))
  call Hloop_QW_A(ntryL,G1H72(32),ex3(:),G1H24(14),m3h3x24(:,19),heltab2x72(:,:,52))
  call Hloop_Q_A(ntryL,G1H24(14),36,nMB,G2H24(12),n2h24(22))
  call Hloop_QV_A(ntryL,G1H72(33),wf4(:,10),G1H18(34),m3h4x18(:,21),heltab2x72(:,:,53))
  call Hloop_Q_A(ntryL,G1H18(34),35,0,G2H18(26),n2h18(44))
  call Hloop_QV_A(ntryL,G1H72(34),wf4(:,10),G1H18(35),m3h4x18(:,22),heltab2x72(:,:,54))
  call Hloop_Q_A(ntryL,G1H18(35),35,nMT,G2H18(27),n2h18(45))
  call Hloop_AV_Q(ntryL,G1H72(35),wf4(:,10),G1H18(38),m3h4x18(:,23),heltab2x72(:,:,55))
  call Hloop_A_Q(ntryL,G1H18(38),35,0,G2H18(28),n2h18(46))
  call Hloop_AV_Q(ntryL,G1H72(36),wf4(:,10),G1H18(39),m3h4x18(:,24),heltab2x72(:,:,56))
  call Hloop_A_Q(ntryL,G1H18(39),35,nMB,G2H18(29),n2h18(47))
  call Hloop_AW_Q(ntryL,G1H72(37),ex4(:),G1H24(16),m3h3x24(:,20),heltab2x72(:,:,57))
  call Hloop_A_Q(ntryL,G1H24(16),40,0,G2H24(13),n2h24(23))
  call Hloop_AW_Q(ntryL,G1H72(38),ex4(:),G1H24(17),m3h3x24(:,21),heltab2x72(:,:,58))
  call Hloop_A_Q(ntryL,G1H24(17),40,nMB,G2H24(14),n2h24(24))
  call Hloop_QW_A(ntryL,G1H72(39),ex4(:),G1H24(18),m3h3x24(:,22),heltab2x72(:,:,59))
  call Hloop_Q_A(ntryL,G1H24(18),40,0,G2H24(15),n2h24(25))
  call Hloop_QW_A(ntryL,G1H72(40),ex4(:),G1H24(3),m3h3x24(:,23),heltab2x72(:,:,60))
  call Hloop_Q_A(ntryL,G1H24(3),40,nMT,G2H24(16),n2h24(26))
  call Hloop_AW_Q(ntryL,G1H72(41),ex3(:),G1H24(9),m3h3x24(:,24),heltab2x72(:,:,61))
  call Hloop_A_Q(ntryL,G1H24(9),36,0,G2H24(17),n2h24(27))
  call Hloop_AW_Q(ntryL,G1H72(42),ex3(:),G1H24(15),m3h3x24(:,25),heltab2x72(:,:,62))
  call Hloop_A_Q(ntryL,G1H24(15),36,nMT,G2H24(18),n2h24(28))
  call Hloop_QW_A(ntryL,G1H72(43),ex3(:),G1H24(1),m3h3x24(:,26),heltab2x72(:,:,63))
  call Hloop_Q_A(ntryL,G1H24(1),36,0,G2H24(19),n2h24(29))
  call Hloop_QW_A(ntryL,G1H72(44),ex3(:),G1H24(2),m3h3x24(:,27),heltab2x72(:,:,64))
  call Hloop_Q_A(ntryL,G1H24(2),36,nMB,G2H24(20),n2h24(30))
  call Hloop_QW_A(ntryL,G1H72(45),ex3(:),G1H24(4),m3h3x24(:,28),heltab2x72(:,:,65))
  call Hloop_Q_A(ntryL,G1H24(4),36,0,G2H24(21),n2h24(31))
  call Hloop_QW_A(ntryL,G1H72(46),ex3(:),G1H24(5),m3h3x24(:,29),heltab2x72(:,:,66))
  call Hloop_Q_A(ntryL,G1H24(5),36,nMB,G2H24(22),n2h24(32))
  call Hloop_AW_Q(ntryL,G1H72(47),ex3(:),G1H24(6),m3h3x24(:,30),heltab2x72(:,:,67))
  call Hloop_A_Q(ntryL,G1H24(6),36,0,G2H24(23),n2h24(33))
  call Hloop_AW_Q(ntryL,G1H72(48),ex3(:),G1H24(7),m3h3x24(:,31),heltab2x72(:,:,68))
  call Hloop_A_Q(ntryL,G1H24(7),36,nMT,G2H24(24),n2h24(34))
  call Hloop_AQ_V(ntryL,G1H72(49),wf6(:,3),G1H12(66),m3h6x12(:,1),heltab2x72(:,:,69))
  call Hloop_VQ_A(ntryL,G1H72(50),wf6(:,3),G1H12(83),m3h6x12(:,2),heltab2x72(:,:,70))
  call Hloop_Q_A(ntryL,G1H12(83),37,nMB,G2H12(14),n2h12(42))
  call Hloop_VA_Q(ntryL,G1H72(51),ex2(:),G1H36(7),m3h2x36(:,14),heltab2x72(:,:,71))
  call Hloop_A_Q(ntryL,G1H36(7),34,nMT,G2H36(1),n2h36(16))
  call Hloop_VA_Q(ntryL,G1H72(52),ex2(:),G1H36(11),m3h2x36(:,15),heltab2x72(:,:,72))
  call Hloop_A_Q(ntryL,G1H36(11),34,nMT,G2H36(2),n2h36(17))
  call Hloop_AQ_V(ntryL,G1H72(53),wf6(:,3),G1H12(84),m3h6x12(:,3),heltab2x72(:,:,73))
  call Hloop_QW_A(ntryL,G1H72(54),ex4(:),G1H24(8),m3h3x24(:,32),heltab2x72(:,:,74))
  call Hloop_Q_A(ntryL,G1H24(8),40,nMT,G2H24(25),n2h24(35))
  call Hloop_VA_Q(ntryL,G1H72(55),ex2(:),G1H36(12),m3h2x36(:,16),heltab2x72(:,:,75))
  call Hloop_A_Q(ntryL,G1H36(12),34,nMT,G2H36(3),n2h36(18))
  call Hloop_QA_V(ntryL,G1H72(56),ex2(:),G1H36(13),m3h2x36(:,17),heltab2x72(:,:,76))
  call Hloop_AQ_V(ntryL,G1H72(57),wf6(:,3),G1H12(1),m3h6x12(:,4),heltab2x72(:,:,77))
  call Hloop_AW_Q(ntryL,G1H72(58),ex4(:),G1H24(10),m3h3x24(:,33),heltab2x72(:,:,78))
  call Hloop_A_Q(ntryL,G1H24(10),40,nMB,G2H24(26),n2h24(36))
  call Hloop_QA_V(ntryL,G1H72(59),ex2(:),G1H36(14),m3h2x36(:,18),heltab2x72(:,:,79))
  call Hloop_QA_V(ntryL,G1H72(60),ex2(:),G1H36(15),m3h2x36(:,19),heltab2x72(:,:,80))
  call Hloop_AW_Q(ntryL,G1H72(61),ex3(:),G1H24(11),m3h3x24(:,34),heltab2x72(:,:,81))
  call Hloop_A_Q(ntryL,G1H24(11),36,nMT,G2H24(27),n2h24(37))
  call Hloop_VA_Q(ntryL,G1H72(62),wf6(:,4),G1H12(2),m3h6x12(:,5),heltab2x72(:,:,82))
  call Hloop_A_Q(ntryL,G1H12(2),42,nMB,G2H12(15),n2h12(43))
  call Hloop_VQ_A(ntryL,G1H72(63),ex1(:),G1H36(17),m3h2x36(:,20),heltab2x72(:,:,83))
  call Hloop_Q_A(ntryL,G1H36(17),33,nMT,G2H36(4),n2h36(19))
  call Hloop_VQ_A(ntryL,G1H72(64),ex1(:),G1H36(18),m3h2x36(:,21),heltab2x72(:,:,84))
  call Hloop_Q_A(ntryL,G1H36(18),33,nMT,G2H36(5),n2h36(20))
  call Hloop_QA_V(ntryL,G1H72(65),wf6(:,4),G1H12(5),m3h6x12(:,6),heltab2x72(:,:,85))
  call Hloop_AW_Q(ntryL,G1H72(66),ex3(:),G1H24(12),m3h3x24(:,35),heltab2x72(:,:,86))
  call Hloop_A_Q(ntryL,G1H24(12),36,nMT,G2H24(28),n2h24(38))
  call Hloop_VQ_A(ntryL,G1H72(67),ex1(:),G1H36(19),m3h2x36(:,22),heltab2x72(:,:,87))
  call Hloop_Q_A(ntryL,G1H36(19),33,nMT,G2H36(6),n2h36(21))
  call Hloop_AQ_V(ntryL,G1H72(68),ex1(:),G1H36(20),m3h2x36(:,23),heltab2x72(:,:,88))
  call Hloop_AW_Q(ntryL,G1H72(69),ex3(:),G1H24(13),m3h3x24(:,36),heltab2x72(:,:,89))
  call Hloop_A_Q(ntryL,G1H24(13),36,nMT,G2H24(29),n2h24(39))
  call Hloop_QW_A(ntryL,G1H72(70),ex3(:),G1H24(14),m3h3x24(:,37),heltab2x72(:,:,90))
  call Hloop_Q_A(ntryL,G1H24(14),36,nMB,G2H24(30),n2h24(40))
  call Hloop_AQ_V(ntryL,G1H72(71),ex1(:),G1H36(21),m3h2x36(:,24),heltab2x72(:,:,91))
  call Hloop_AQ_V(ntryL,G1H72(72),ex1(:),G1H36(23),m3h2x36(:,25),heltab2x72(:,:,92))
  call Hloop_QA_V(ntryL,G1H72(73),ex2(:),G1H36(24),m3h2x36(:,26),heltab2x72(:,:,93))
  call Hloop_QA_V(ntryL,G1H72(74),ex2(:),G1H36(25),m3h2x36(:,27),heltab2x72(:,:,94))
  call Hloop_QA_V(ntryL,G1H72(75),ex2(:),G1H36(8),m3h2x36(:,28),heltab2x72(:,:,95))
  call Hloop_QS_A(ntryL,G1H72(76),wf9(:,1),G1H8(1),ngH,m3h9x8(:,1),heltab2x72(:,:,96))
  call Hloop_Q_A(ntryL,G1H8(1),44,nMT,G2H8(4),n2h8(11))
  call Hloop_QV_A(ntryL,G1H72(77),wf9(:,2),G1H8(1),m3h9x8(:,2),heltab2x72(:,:,97))
  call Hloop_Q_A(ntryL,G1H8(1),44,nMT,G2H8(5),n2h8(12))
  call Hloop_QZ_A(ntryL,G1H72(78),wf9(:,3),G1H8(1),ngZu,m3h9x8(:,3),heltab2x72(:,:,98))
  call Hloop_Q_A(ntryL,G1H8(1),44,nMT,G2H8(7),n2h8(13))
  call Hloop_AQ_V(ntryL,G1H72(79),ex1(:),G1H36(26),m3h2x36(:,29),heltab2x72(:,:,99))
  call Hloop_AQ_V(ntryL,G1H72(80),ex1(:),G1H36(28),m3h2x36(:,30),heltab2x72(:,:,100))
  call Hloop_AQ_V(ntryL,G1H72(81),ex1(:),G1H36(29),m3h2x36(:,31),heltab2x72(:,:,101))
  call Hloop_AQ_V(ntryL,G1H72(82),ex1(:),G1H36(30),m3h2x36(:,32),heltab2x72(:,:,102))
  call Hloop_AQ_V(ntryL,G1H72(83),ex1(:),G1H36(2),m3h2x36(:,33),heltab2x72(:,:,103))
  call Hloop_AQ_V(ntryL,G1H72(84),ex1(:),G1H36(10),m3h2x36(:,34),heltab2x72(:,:,104))
  call Hloop_AS_Q(ntryL,G1H72(85),wf9(:,1),G1H8(1),ngH,m3h9x8(:,4),heltab2x72(:,:,105))
  call Hloop_A_Q(ntryL,G1H8(1),44,nMT,G2H8(8),n2h8(14))
  call Hloop_AV_Q(ntryL,G1H72(86),wf9(:,2),G1H8(1),m3h9x8(:,5),heltab2x72(:,:,106))
  call Hloop_A_Q(ntryL,G1H8(1),44,nMT,G2H8(10),n2h8(15))
  call Hloop_AZ_Q(ntryL,G1H72(87),wf9(:,3),G1H8(1),ngZu,m3h9x8(:,6),heltab2x72(:,:,107))
  call Hloop_A_Q(ntryL,G1H8(1),44,nMT,G2H8(11),n2h8(16))
  call Hloop_QA_V(ntryL,G1H72(88),ex2(:),G1H36(1),m3h2x36(:,35),heltab2x72(:,:,108))
  call Hloop_QA_V(ntryL,G1H72(89),ex2(:),G1H36(9),m3h2x36(:,36),heltab2x72(:,:,109))
  call Hloop_QA_V(ntryL,G1H72(90),ex2(:),G1H36(16),m3h2x36(:,37),heltab2x72(:,:,110))
  call Hloop_AQ_V(ntryL,G1H72(91),ex1(:),G1H36(22),m3h2x36(:,38),heltab2x72(:,:,111))
  call Hloop_AQ_V(ntryL,G1H72(92),ex1(:),G1H36(27),m3h2x36(:,39),heltab2x72(:,:,112))
  call Hloop_AQ_V(ntryL,G1H72(93),ex1(:),G1H36(6),m3h2x36(:,40),heltab2x72(:,:,113))
  call Hloop_VQ_A(ntryL,G1H72(94),ex1(:),G1H36(7),m3h2x36(:,41),heltab2x72(:,:,114))
  call Hloop_Q_A(ntryL,G1H36(7),33,nMT,G2H36(7),n2h36(22))
  call Hloop_VQ_A(ntryL,G1H72(95),ex1(:),G1H36(11),m3h2x36(:,42),heltab2x72(:,:,115))
  call Hloop_Q_A(ntryL,G1H36(11),33,nMT,G2H36(8),n2h36(23))
  call Hloop_VQ_A(ntryL,G1H72(96),ex1(:),G1H36(12),m3h2x36(:,43),heltab2x72(:,:,116))
  call Hloop_Q_A(ntryL,G1H36(12),33,nMT,G2H36(9),n2h36(24))
  call Hloop_QA_V(ntryL,G1H72(97),ex2(:),G1H36(17),m3h2x36(:,44),heltab2x72(:,:,117))
  call Hloop_QA_V(ntryL,G1H72(98),ex2(:),G1H36(18),m3h2x36(:,45),heltab2x72(:,:,118))
  call Hloop_QA_V(ntryL,G1H72(99),ex2(:),G1H36(19),m3h2x36(:,46),heltab2x72(:,:,119))
  call Hloop_VA_Q(ntryL,G1H72(100),ex2(:),G1H36(7),m3h2x36(:,47),heltab2x72(:,:,120))
  call Hloop_A_Q(ntryL,G1H36(7),34,nMT,G2H36(10),n2h36(25))
  call Hloop_VA_Q(ntryL,G1H72(101),ex2(:),G1H36(11),m3h2x36(:,48),heltab2x72(:,:,121))
  call Hloop_A_Q(ntryL,G1H36(11),34,nMT,G2H36(11),n2h36(26))
  call Hloop_VA_Q(ntryL,G1H72(102),ex2(:),G1H36(12),m3h2x36(:,49),heltab2x72(:,:,122))
  call Hloop_A_Q(ntryL,G1H36(12),34,nMT,G2H36(12),n2h36(27))
  call Hloop_VQ_A(ntryL,G1H72(103),ex1(:),G1H36(7),m3h2x36(:,50),heltab2x72(:,:,123))
  call Hloop_Q_A(ntryL,G1H36(7),33,nMT,G2H36(13),n2h36(28))
  call Hloop_VQ_A(ntryL,G1H72(104),ex1(:),G1H36(11),m3h2x36(:,51),heltab2x72(:,:,124))
  call Hloop_Q_A(ntryL,G1H36(11),33,nMT,G2H36(14),n2h36(29))
  call Hloop_VQ_A(ntryL,G1H72(105),ex1(:),G1H36(12),m3h2x36(:,52),heltab2x72(:,:,125))
  call Hloop_Q_A(ntryL,G1H36(12),33,nMT,G2H36(15),n2h36(30))
  call Hloop_VQ_A(ntryL,G1H72(106),ex1(:),G1H36(7),m3h2x36(:,53),heltab2x72(:,:,126))
  call Hloop_Q_A(ntryL,G1H36(7),33,nMT,G2H36(16),n2h36(31))
  call Hloop_VQ_A(ntryL,G1H72(107),ex1(:),G1H36(11),m3h2x36(:,54),heltab2x72(:,:,127))
  call Hloop_Q_A(ntryL,G1H36(11),33,nMT,G2H36(17),n2h36(32))
  call Hloop_VQ_A(ntryL,G1H72(108),ex1(:),G1H36(12),m3h2x36(:,55),heltab2x72(:,:,128))
  call Hloop_Q_A(ntryL,G1H36(12),33,nMT,G2H36(18),n2h36(33))
  call Hloop_VA_Q(ntryL,G1H72(109),ex2(:),G1H36(7),m3h2x36(:,56),heltab2x72(:,:,129))
  call Hloop_A_Q(ntryL,G1H36(7),34,nMT,G2H36(19),n2h36(34))
  call Hloop_QW_A(ntryL,G1H72(110),ex3(:),G1H24(16),m3h3x24(:,38),heltab2x72(:,:,130))
  call Hloop_Q_A(ntryL,G1H24(16),36,nMB,G2H24(31),n2h24(41))
  call Hloop_AW_Q(ntryL,G1H72(111),ex3(:),G1H24(17),m3h3x24(:,39),heltab2x72(:,:,131))
  call Hloop_A_Q(ntryL,G1H24(17),36,nMT,G2H24(32),n2h24(42))
  call Hloop_QA_V(ntryL,G1H72(112),ex2(:),G1H36(11),m3h2x36(:,57),heltab2x72(:,:,132))
  call Hloop_VQ_A(ntryL,G1H72(113),ex1(:),G1H36(12),m3h2x36(:,58),heltab2x72(:,:,133))
  call Hloop_Q_A(ntryL,G1H36(12),33,nMT,G2H36(20),n2h36(35))
  call Hloop_AW_Q(ntryL,G1H72(114),ex4(:),G1H24(18),m3h3x24(:,40),heltab2x72(:,:,134))
  call Hloop_A_Q(ntryL,G1H24(18),40,nMB,G2H24(33),n2h24(43))
  call Hloop_AW_Q(ntryL,G1H72(115),ex3(:),G1H24(3),m3h3x24(:,41),heltab2x72(:,:,135))
  call Hloop_A_Q(ntryL,G1H24(3),36,nMT,G2H24(34),n2h24(44))
  call Hloop_AQ_V(ntryL,G1H72(116),ex1(:),G1H36(7),m3h2x36(:,59),heltab2x72(:,:,136))
  call Hloop_VA_Q(ntryL,G0H36(4),ex2(:),G0H18(1),m3h2x18(:,20),heltab2x36(:,:,40))
  call Hloop_A_Q(ntryL,G0H18(1),35,nMT,G1H18(40),n2h18(48))
  call Hloop_VA_Q(ntryL,G0H36(5),ex2(:),G0H18(1),m3h2x18(:,21),heltab2x36(:,:,41))
  call Hloop_A_Q(ntryL,G0H18(1),35,nMT,G1H18(41),n2h18(49))
  call Hloop_VA_Q(ntryL,G0H36(6),ex2(:),G0H18(1),m3h2x18(:,22),heltab2x36(:,:,42))
  call Hloop_A_Q(ntryL,G0H18(1),35,nMT,G1H18(44),n2h18(50))
  call Hloop_VQ_A(ntryL,G0H36(7),ex1(:),G0H18(1),m3h2x18(:,23),heltab2x36(:,:,43))
  call Hloop_Q_A(ntryL,G0H18(1),35,nMT,G1H18(45),n2h18(51))
  call Hloop_VQ_A(ntryL,G0H36(8),ex1(:),G0H18(1),m3h2x18(:,24),heltab2x36(:,:,44))
  call Hloop_Q_A(ntryL,G0H18(1),35,nMT,G1H18(46),n2h18(52))
  call Hloop_VQ_A(ntryL,G0H36(9),ex1(:),G0H18(1),m3h2x18(:,25),heltab2x36(:,:,45))
  call Hloop_Q_A(ntryL,G0H18(1),35,nMT,G1H18(47),n2h18(53))
  call Hloop_AW_Q(ntryL,G1H36(3),ex3(:),G1H12(6),m3h3x12(:,21),heltab2x36(:,:,46))
  call Hloop_A_Q(ntryL,G1H12(6),52,nMT,G2H12(17),n2h12(44))
  call Hloop_QA_V(ntryL,G1H36(4),ex2(:),G1H18(50),m3h2x18(:,26),heltab2x36(:,:,47))
  call Hloop_AQ_V(ntryL,G1H36(5),ex1(:),G1H18(51),m3h2x18(:,27),heltab2x36(:,:,48))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(11),[G2H8(10),G2H8(8),G2H8(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(7),[G2H8(5),G2H8(4),G2H8(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(15),[G2H12(12),G1H12(28)])
call HGT_lower_alpha_OLR(G2H18(10),1,1,18)
call HGT_lower_alpha_invQ_OLR(G2H18(10),2,5,18)
call HGT_lower_alpha_OLR(G2H18(10),6,15,18)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H18(10),[G2H18(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(14),[G2H12(16),G1H12(46)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H18(46),[G1H18(12)])
call HGT_w2_OLR(G1H18(1),1,1,18)
call HGT_w2_invQ_OLR(G1H18(1),2,5,18)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H18(1),[G1H18(46)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(20),[G1H12(64)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H18(45),[G1H18(6)])
call HGT_w2_OLR(G1H18(2),1,1,18)
call HGT_w2_invQ_OLR(G1H18(2),2,5,18)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H18(2),[G1H18(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(24),[G1H12(82)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H18(47),[G1H18(18)])
call HGT_w2_OLR(G1H18(3),1,1,18)
call HGT_w2_invQ_OLR(G1H18(3),2,5,18)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H18(3),[G1H18(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H18(12),[G1H18(55)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(5),[G1H12(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(84),[G1H12(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(1),[G1H12(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H18(19),[G1H18(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H18(27),[G1H18(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H18(1),[G1H18(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H18(40),[G1H18(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H18(5),[G1H18(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H18(41),[G1H18(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H18(23),[G1H18(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H18(44),[G1H18(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H18(15),[G1H18(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(66),[G1H12(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(9),[G1H12(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(10),[G1H12(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(11),[G1H12(63)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(13),[G1H12(81)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H18(11),[G1H18(54)])
call HGT_OLR(G2H12(5),1,1,12)
call HGT_invQ_OLR(G2H12(5),2,5,12)
call HGT_OLR(G2H12(5),6,15,12)
  call Hotf_5pt_reduction(G2H12(5),RedSet_5(37),mass5set(:,1),  & 
G1H12(7),G1H12(8),G1H12(11),G1H12(12),G1H12(13),G1H12(14),12)
  call HG1shiftOLR(G1H12(8),2,12)
  call Hloop_AQ_V(ntryL,G2H8(11),ex1(:),G2H4(9),m3h2x4(:,7),heltab2x8(:,:,7))
call HGT_OLR(G2H12(6),1,1,12)
call HGT_invQ_OLR(G2H12(6),2,5,12)
call HGT_OLR(G2H12(6),6,15,12)
  call Hotf_5pt_reduction(G2H12(6),RedSet_5(38),mass5set(:,1),  & 
G1H12(17),G1H12(18),G1H12(19),G1H12(20),G1H12(23),G1H12(24),12)
  call HG1shiftOLR(G1H12(18),1,12)
  call Hloop_QA_V(ntryL,G2H8(7),ex2(:),G2H4(11),m3h2x4(:,8),heltab2x8(:,:,8))
call HGT_OLR(G2H8(9),1,1,8)
call HGT_invQ_OLR(G2H8(9),2,5,8)
call HGT_OLR(G2H8(9),6,15,8)
  call Hotf_5pt_reduction(G2H8(9),RedSet_5(39),mass5set(:,18),  & 
G1H8(1),G1H8(2),G1H8(3),G1H8(4),G1H8(5),G1H8(6),8)
  call HG1shiftOLR(G1H8(2),2,8)
  call Hloop_AQ_V(ntryL,G2H12(8),ex1(:),G2H6(42),m3h2x6(:,37),heltab2x12(:,:,60))
call HGT_lower_alpha_OLR(G2H18(9),1,1,18)
call HGT_lower_alpha_invQ_OLR(G2H18(9),2,5,18)
call HGT_lower_alpha_OLR(G2H18(9),6,15,18)
  call Hotf_5pt_reduction(G2H18(9),RedSet_5(40),mass5set(:,3),  & 
G1H18(52),G1H18(53),G1H18(58),G1H18(64),G1H18(59),G1H18(62),18)
  call HG1shiftOLR(G1H18(53),1,18)
  call Hotf_5pt_reduction(G2H12(15),RedSet_5(41),mass5set(:,19),  & 
G1H12(25),G1H12(26),G1H12(31),G1H12(37),G1H12(32),G1H12(35),12)
  call HG1shiftOLR(G1H12(26),16,12)
  call Hotf_5pt_reduction(G2H18(10),RedSet_5(42),mass5set(:,3),  & 
G1H18(63),G1H18(65),G1H18(68),G1H18(69),G1H18(56),G1H18(57),18)
  call HG1shiftOLR(G1H18(65),2,18)
  call Hotf_5pt_reduction(G2H12(14),RedSet_5(43),mass5set(:,19),  & 
G1H12(36),G1H12(38),G1H12(41),G1H12(42),G1H12(43),G1H12(44),12)
  call HG1shiftOLR(G1H12(38),16,12)
  call Hloop_QW_A(ntryL,G1H18(1),ex3(:),G1H6(12),m3h3x6(:,26),heltab2x18(:,:,43))
  call Hloop_Q_A(ntryL,G1H6(12),39,nMB,G2H6(44),n2h6(60))
  call Hotf_5pt_reduction(G2H12(20),RedSet_5(44),mass5set(:,20),  & 
G1H12(49),G1H12(55),G1H12(50),G1H12(53),G1H12(54),G1H12(56),12)
  call HG1shiftOLR(G1H12(55),2,12)
  call Hloop_QW_A(ntryL,G1H18(2),ex3(:),G1H6(24),m3h3x6(:,27),heltab2x18(:,:,44))
  call Hloop_Q_A(ntryL,G1H6(24),39,nMB,G2H6(48),n2h6(61))
  call Hotf_5pt_reduction(G2H12(24),RedSet_5(45),mass5set(:,21),  & 
G1H12(59),G1H12(60),G1H12(61),G1H12(62),G1H12(67),G1H12(73),12)
  call HG1shiftOLR(G1H12(60),2,12)
  call Hloop_QV_A(ntryL,G1H18(3),ex5(:),G1H9(9),m3h2x9(:,18),heltab2x18(:,:,45))
  call Hloop_Q_A(ntryL,G1H9(9),51,nMT,G2H9(2),n2h9(21))
  call Hotf_5pt_reduction(G2H18(12),RedSet_5(46),mass5set(:,3),  & 
G1H18(4),G1H18(5),G1H18(8),G1H18(9),G1H18(10),G1H18(11),18)
  call HG1shiftOLR(G1H18(5),2,18)
  call Hloop_VQ_A(ntryL,G1H12(3),ex1(:),G1H6(36),m3h2x6(:,38),heltab2x12(:,:,61))
  call Hloop_Q_A(ntryL,G1H6(36),43,nMT,G2H6(49),n2h6(62))
  call Hloop_VQ_A(ntryL,G1H12(5),ex1(:),G1H6(48),m3h2x6(:,39),heltab2x12(:,:,62))
  call Hloop_Q_A(ntryL,G1H6(48),43,nMT,G2H6(51),n2h6(63))
  call Hloop_VA_Q(ntryL,G1H12(9),ex2(:),G1H6(60),m3h2x6(:,40),heltab2x12(:,:,63))
  call Hloop_A_Q(ntryL,G1H6(60),39,nMT,G2H6(55),n2h6(64))
  call Hloop_VA_Q(ntryL,G1H12(84),ex2(:),G1H6(72),m3h2x6(:,41),heltab2x12(:,:,64))
  call Hloop_A_Q(ntryL,G1H6(72),39,nMT,G2H6(1),n2h6(65))
  call Hloop_VA_Q(ntryL,G1H12(15),ex2(:),G1H6(84),m3h2x6(:,42),heltab2x12(:,:,65))
  call Hloop_A_Q(ntryL,G1H6(84),39,nMT,G2H6(3),n2h6(66))
  call Hloop_VA_Q(ntryL,G1H12(1),ex2(:),G1H6(96),m3h2x6(:,43),heltab2x12(:,:,66))
  call Hloop_A_Q(ntryL,G1H6(96),39,nMT,G2H6(4),n2h6(67))
  call Hotf_5pt_reduction(G2H18(19),RedSet_5(47),mass5set(:,22),  & 
G1H18(14),G1H18(15),G1H18(16),G1H18(17),G1H18(20),G1H18(21),18)
  call HG1shiftOLR(G1H18(15),16,18)
  call Hotf_5pt_reduction(G2H18(27),RedSet_5(48),mass5set(:,23),  & 
G1H18(22),G1H18(23),G1H18(26),G1H18(27),G1H18(28),G1H18(29),18)
  call HG1shiftOLR(G1H18(23),8,18)
  call Hotf_5pt_reduction(G2H18(1),RedSet_5(49),mass5set(:,24),  & 
G1H18(32),G1H18(33),G1H18(34),G1H18(35),G1H18(38),G1H18(39),18)
  call HG1shiftOLR(G1H18(33),8,18)
  call Hloop_AW_Q(ntryL,G1H18(40),ex4(:),G1H6(108),m3h3x6(:,28),heltab2x18(:,:,46))
  call Hloop_A_Q(ntryL,G1H6(108),43,nMB,G2H6(7),n2h6(68))
  call Hotf_5pt_reduction(G2H18(5),RedSet_5(50),mass5set(:,22),  & 
G1H18(12),G1H18(46),G1H18(6),G1H18(45),G1H18(18),G1H18(47),18)
  call HG1shiftOLR(G1H18(46),16,18)
  call Hloop_AW_Q(ntryL,G1H18(41),ex4(:),G1H6(120),m3h3x6(:,29),heltab2x18(:,:,47))
  call Hloop_A_Q(ntryL,G1H6(120),43,nMB,G2H6(8),n2h6(69))
  call Hotf_5pt_reduction(G2H18(23),RedSet_5(51),mass5set(:,23),  & 
G1H18(55),G1H18(7),G1H18(13),G1H18(19),G1H18(24),G1H18(25),18)
  call HG1shiftOLR(G1H18(7),4,18)
  call Hloop_AV_Q(ntryL,G1H18(44),ex5(:),G1H9(21),m3h2x9(:,19),heltab2x18(:,:,48))
  call Hloop_A_Q(ntryL,G1H9(21),51,nMT,G2H9(4),n2h9(22))
  call Hotf_5pt_reduction(G2H18(15),RedSet_5(52),mass5set(:,24),  & 
G1H18(30),G1H18(31),G1H18(36),G1H18(37),G1H18(54),G1H18(1),18)
  call HG1shiftOLR(G1H18(31),4,18)
  call Hloop_UV_W(ntryL,G1H12(21),37,ex5(:),16,G2H6(11),m3h2x6(:,44),heltab2x12(:,:,67))
  call Hloop_UV_W(ntryL,G1H12(66),37,ex5(:),16,G2H6(12),m3h2x6(:,45),heltab2x12(:,:,68))
  call Hloop_VQ_A(ntryL,G1H18(42),ex1(:),G1H9(33),m3h2x9(:,20),heltab2x18(:,:,49))
  call Hloop_Q_A(ntryL,G1H9(33),51,nMT,G2H9(6),n2h9(23))
  call Hloop_VQ_A(ntryL,G1H18(43),ex1(:),G1H9(45),m3h2x9(:,21),heltab2x18(:,:,50))
  call Hloop_Q_A(ntryL,G1H9(45),51,nMT,G2H9(8),n2h9(24))
  call Hloop_VA_Q(ntryL,G1H18(48),ex2(:),G1H9(4),m3h2x9(:,22),heltab2x18(:,:,51))
  call Hloop_A_Q(ntryL,G1H9(4),51,nMT,G2H9(9),n2h9(25))
  call Hloop_VA_Q(ntryL,G1H18(49),ex2(:),G1H9(5),m3h2x9(:,23),heltab2x18(:,:,52))
  call Hloop_A_Q(ntryL,G1H9(5),51,nMT,G2H9(11),n2h9(26))
  call Hotf_5pt_reduction(G2H12(9),RedSet_5(53),mass5set(:,25),  & 
G1H12(68),G1H12(71),G1H12(72),G1H12(74),G1H12(77),G1H12(78),12)
  call HG1shiftOLR(G1H12(71),16,12)
  call Hloop_AW_Q(ntryL,G1H12(33),ex3(:),G1H4(6),m3h3x4(:,24),heltab2x12(:,:,69))
  call Hloop_A_Q(ntryL,G1H4(6),46,nMT,G2H4(15),n2h4(29))
  call Hloop_AW_Q(ntryL,G1H12(34),ex3(:),G1H4(18),m3h3x4(:,25),heltab2x12(:,:,70))
  call Hloop_A_Q(ntryL,G1H4(18),46,nMT,G2H4(16),n2h4(30))
  call Hloop_AW_Q(ntryL,G1H12(39),ex3(:),G1H4(30),m3h3x4(:,26),heltab2x12(:,:,71))
  call Hloop_A_Q(ntryL,G1H4(30),46,nMT,G2H4(18),n2h4(31))
  call Hloop_AW_Q(ntryL,G1H12(40),ex3(:),G1H4(36),m3h3x4(:,27),heltab2x12(:,:,72))
  call Hloop_A_Q(ntryL,G1H4(36),46,nMT,G2H4(22),n2h4(32))
  call Hotf_5pt_reduction(G2H12(10),RedSet_5(54),mass5set(:,25),  & 
G1H12(79),G1H12(80),G1H12(85),G1H12(91),G1H12(86),G1H12(89),12)
  call HG1shiftOLR(G1H12(80),16,12)
  call Hloop_QW_A(ntryL,G1H12(51),ex4(:),G1H4(1),m3h3x4(:,28),heltab2x12(:,:,73))
  call Hloop_Q_A(ntryL,G1H4(1),45,nMT,G2H4(23),n2h4(33))
  call Hloop_QW_A(ntryL,G1H12(52),ex4(:),G1H4(2),m3h3x4(:,29),heltab2x12(:,:,74))
  call Hloop_Q_A(ntryL,G1H4(2),45,nMT,G2H4(25),n2h4(34))
  call Hloop_QW_A(ntryL,G1H12(57),ex4(:),G1H4(7),m3h3x4(:,30),heltab2x12(:,:,75))
  call Hloop_Q_A(ntryL,G1H4(7),45,nMT,G2H4(29),n2h4(35))
  call Hloop_QW_A(ntryL,G1H12(58),ex4(:),G1H4(8),m3h3x4(:,31),heltab2x12(:,:,76))
  call Hloop_Q_A(ntryL,G1H4(8),45,nMT,G2H4(1),n2h4(36))
  call Hotf_5pt_reduction(G2H12(11),RedSet_5(55),mass5set(:,26),  & 
G1H12(90),G1H12(92),G1H12(95),G1H12(96),G1H12(29),G1H12(30),12)
  call HG1shiftOLR(G1H12(92),2,12)
  call Hloop_QV_A(ntryL,G1H12(69),ex5(:),G1H6(126),m3h2x6(:,46),heltab2x12(:,:,77))
  call Hloop_Q_A(ntryL,G1H6(126),53,nMB,G2H6(14),n2h6(70))
  call Hloop_QV_A(ntryL,G1H12(70),ex5(:),G1H6(137),m3h2x6(:,47),heltab2x12(:,:,78))
  call Hloop_Q_A(ntryL,G1H6(137),53,nMB,G2H6(15),n2h6(71))
  call Hloop_QV_A(ntryL,G1H12(75),ex5(:),G1H6(143),m3h2x6(:,48),heltab2x12(:,:,79))
  call Hloop_Q_A(ntryL,G1H6(143),53,nMB,G2H6(17),n2h6(72))
  call Hloop_QV_A(ntryL,G1H12(76),ex5(:),G1H6(7),m3h2x6(:,49),heltab2x12(:,:,80))
  call Hloop_Q_A(ntryL,G1H6(7),53,nMB,G2H6(18),n2h6(73))
  call Hotf_5pt_reduction(G2H12(13),RedSet_5(56),mass5set(:,27),  & 
G1H12(47),G1H12(48),G1H12(65),G1H12(83),G1H12(2),G1H12(6),12)
  call HG1shiftOLR(G1H12(48),2,12)
  call Hloop_QW_A(ntryL,G1H12(87),ex4(:),G1H4(12),m3h3x4(:,32),heltab2x12(:,:,81))
  call Hloop_Q_A(ntryL,G1H4(12),45,nMT,G2H4(3),n2h4(37))
  call Hloop_QW_A(ntryL,G1H12(88),ex4(:),G1H4(13),m3h3x4(:,33),heltab2x12(:,:,82))
  call Hloop_Q_A(ntryL,G1H4(13),45,nMT,G2H4(4),n2h4(38))
  call Hloop_QW_A(ntryL,G1H12(93),ex4(:),G1H4(14),m3h3x4(:,34),heltab2x12(:,:,83))
  call Hloop_Q_A(ntryL,G1H4(14),45,nMT,G2H4(6),n2h4(39))
  call Hloop_QW_A(ntryL,G1H12(94),ex4(:),G1H4(19),m3h3x4(:,35),heltab2x12(:,:,84))
  call Hloop_Q_A(ntryL,G1H4(19),45,nMT,G2H4(30),n2h4(40))
  call Hotf_5pt_reduction(G2H18(11),RedSet_5(57),mass5set(:,28),  & 
G1H18(2),G1H18(3),G1H18(40),G1H18(41),G1H18(44),G1H18(42),18)
  call HG1shiftOLR(G1H18(3),2,18)
  call Hloop_QW_A(ntryL,G1H18(60),ex3(:),G1H6(8),m3h3x6(:,30),heltab2x18(:,:,53))
  call Hloop_Q_A(ntryL,G1H6(8),53,nMB,G2H6(21),n2h6(74))
  call Hloop_QW_A(ntryL,G1H18(61),ex3(:),G1H6(13),m3h3x6(:,31),heltab2x18(:,:,54))
  call Hloop_Q_A(ntryL,G1H6(13),53,nMB,G2H6(23),n2h6(75))
  call Hloop_QW_A(ntryL,G1H18(66),ex3(:),G1H6(14),m3h3x6(:,32),heltab2x18(:,:,55))
  call Hloop_Q_A(ntryL,G1H6(14),53,nMB,G2H6(25),n2h6(76))
  call Hloop_QW_A(ntryL,G1H18(67),ex3(:),G1H6(18),m3h3x6(:,33),heltab2x18(:,:,56))
  call Hloop_Q_A(ntryL,G1H6(18),53,nMB,G2H6(26),n2h6(77))
  call Hloop_AQ_V(ntryL,G2H8(1),ex1(:),G2H4(31),m3h2x4(:,9),heltab2x8(:,:,9))
  call Hloop_QA_V(ntryL,G2H8(3),ex2(:),G2H4(32),m3h2x4(:,10),heltab2x8(:,:,10))
  call Hloop_AQ_V(ntryL,G2H12(7),ex1(:),G2H6(29),m3h2x6(:,50),heltab2x12(:,:,85))
  call Hotf_5pt_reduction(G2H18(14),RedSet_5(49),mass5set(:,29),  & 
G1H18(43),G1H18(48),G1H18(49),G1H18(60),G1H18(61),G1H18(66),18)
  call HG1shiftOLR(G1H18(48),8,18)
  call Hotf_5pt_reduction(G2H18(2),RedSet_5(49),mass5set(:,29),  & 
G1H18(67),G1H18(70),G1H18(71),G1H18(72),G1H18(73),G1H18(74),18)
  call HG1shiftOLR(G1H18(70),8,18)
  call Hotf_5pt_reduction(G2H18(3),RedSet_5(49),mass5set(:,30),  & 
G1H18(75),G1H18(76),G1H18(77),G1H18(78),G1H18(79),G1H18(80),18)
  call HG1shiftOLR(G1H18(76),8,18)
  call Hotf_5pt_reduction(G2H18(4),RedSet_5(50),mass5set(:,29),  & 
G1H18(81),G1H18(82),G1H18(83),G1H18(84),G1H18(85),G1H18(86),18)
  call HG1shiftOLR(G1H18(82),16,18)
  call Hotf_5pt_reduction(G2H18(6),RedSet_5(50),mass5set(:,29),  & 
G1H18(87),G1H18(88),G1H18(89),G1H18(90),G1H18(91),G1H18(92),18)
  call HG1shiftOLR(G1H18(88),16,18)
  call Hotf_5pt_reduction(G2H18(7),RedSet_5(50),mass5set(:,31),  & 
G1H18(93),G1H18(94),G1H18(95),G1H18(96),G1H18(97),G1H18(98),18)
  call HG1shiftOLR(G1H18(94),16,18)
  call Hotf_5pt_reduction(G2H18(8),RedSet_5(52),mass5set(:,29),  & 
G1H18(99),G1H18(100),G1H18(101),G1H18(102),G1H18(103),G1H18(104),18)
  call HG1shiftOLR(G1H18(100),4,18)
  call Hotf_5pt_reduction(G2H18(16),RedSet_5(52),mass5set(:,29),  & 
G1H18(105),G1H18(106),G1H18(107),G1H18(108),G1H18(109),G1H18(110),18)
  call HG1shiftOLR(G1H18(106),4,18)
  call Hotf_5pt_reduction(G2H18(17),RedSet_5(52),mass5set(:,30),  & 
G1H18(111),G1H18(112),G1H18(113),G1H18(114),G1H18(115),G1H18(116),18)
  call HG1shiftOLR(G1H18(112),4,18)
  call Hotf_5pt_reduction(G2H24(4),RedSet_5(26),mass5set(:,29),  & 
G1H24(9),G1H24(15),G1H24(1),G1H24(2),G1H24(4),G1H24(5),24)
  call HG1shiftOLR(G1H24(15),16,24)
  call Hotf_5pt_reduction(G2H24(5),RedSet_5(26),mass5set(:,14),  & 
G1H24(6),G1H24(7),G1H24(8),G1H24(10),G1H24(11),G1H24(12),24)
  call HG1shiftOLR(G1H24(7),16,24)
  call Hotf_5pt_reduction(G2H24(6),RedSet_5(26),mass5set(:,29),  & 
G1H24(13),G1H24(14),G1H24(16),G1H24(17),G1H24(18),G1H24(3),24)
  call HG1shiftOLR(G1H24(14),16,24)
  call Hotf_5pt_reduction(G2H24(7),RedSet_5(26),mass5set(:,32),  & 
G1H24(19),G1H24(20),G1H24(21),G1H24(22),G1H24(23),G1H24(24),24)
  call HG1shiftOLR(G1H24(20),16,24)
  call Hotf_5pt_reduction(G2H18(18),RedSet_5(47),mass5set(:,29),  & 
G1H18(117),G1H18(118),G1H18(119),G1H18(120),G1H18(121),G1H18(122),18)
  call HG1shiftOLR(G1H18(118),16,18)
  call Hotf_5pt_reduction(G2H18(20),RedSet_5(47),mass5set(:,29),  & 
G1H18(123),G1H18(124),G1H18(125),G1H18(126),G1H18(127),G1H18(128),18)
  call HG1shiftOLR(G1H18(124),16,18)
  call Hotf_5pt_reduction(G2H18(21),RedSet_5(47),mass5set(:,31),  & 
G1H18(129),G1H18(130),G1H18(131),G1H18(132),G1H18(133),G1H18(134),18)
  call HG1shiftOLR(G1H18(130),16,18)
  call Hotf_5pt_reduction(G2H24(1),RedSet_5(25),mass5set(:,29),  & 
G1H24(25),G1H24(26),G1H24(27),G1H24(28),G1H24(29),G1H24(30),24)
  call HG1shiftOLR(G1H24(26),16,24)
  call Hotf_5pt_reduction(G2H24(2),RedSet_5(25),mass5set(:,14),  & 
G1H24(31),G1H24(32),G1H24(33),G1H24(34),G1H24(35),G1H24(36),24)
  call HG1shiftOLR(G1H24(32),16,24)
  call Hotf_5pt_reduction(G2H24(3),RedSet_5(25),mass5set(:,29),  & 
G1H24(37),G1H24(38),G1H24(39),G1H24(40),G1H24(41),G1H24(42),24)
  call HG1shiftOLR(G1H24(38),16,24)
  call Hotf_5pt_reduction(G2H24(8),RedSet_5(25),mass5set(:,32),  & 
G1H24(43),G1H24(44),G1H24(45),G1H24(46),G1H24(47),G1H24(48),24)
  call HG1shiftOLR(G1H24(44),16,24)
  call Hotf_5pt_reduction(G2H18(22),RedSet_5(51),mass5set(:,29),  & 
G1H18(135),G1H18(136),G1H18(137),G1H18(138),G1H18(139),G1H18(140),18)
  call HG1shiftOLR(G1H18(136),4,18)
  call Hotf_5pt_reduction(G2H18(24),RedSet_5(51),mass5set(:,29),  & 
G1H18(141),G1H18(142),G1H18(143),G1H18(144),G1H18(145),G1H18(146),18)
  call HG1shiftOLR(G1H18(142),4,18)
  call Hotf_5pt_reduction(G2H18(25),RedSet_5(51),mass5set(:,33),  & 
G1H18(147),G1H18(148),G1H18(149),G1H18(150),G1H18(151),G1H18(152),18)
  call HG1shiftOLR(G1H18(148),4,18)
  call Hotf_5pt_reduction(G2H24(9),RedSet_5(27),mass5set(:,29),  & 
G1H24(49),G1H24(50),G1H24(51),G1H24(52),G1H24(53),G1H24(54),24)
  call HG1shiftOLR(G1H24(50),8,24)
  call Hotf_5pt_reduction(G2H24(10),RedSet_5(27),mass5set(:,15),  & 
G1H24(55),G1H24(56),G1H24(57),G1H24(58),G1H24(59),G1H24(60),24)
  call HG1shiftOLR(G1H24(56),8,24)
  call Hotf_5pt_reduction(G2H24(11),RedSet_5(27),mass5set(:,29),  & 
G1H24(61),G1H24(62),G1H24(63),G1H24(64),G1H24(65),G1H24(66),24)
  call HG1shiftOLR(G1H24(62),8,24)
  call Hotf_5pt_reduction(G2H24(12),RedSet_5(27),mass5set(:,34),  & 
G1H24(67),G1H24(68),G1H24(69),G1H24(70),G1H24(71),G1H24(72),24)
  call HG1shiftOLR(G1H24(68),8,24)
  call Hotf_5pt_reduction(G2H18(26),RedSet_5(48),mass5set(:,29),  & 
G1H18(153),G1H18(154),G1H18(155),G1H18(156),G1H18(157),G1H18(158),18)
  call HG1shiftOLR(G1H18(154),8,18)
  call Hotf_5pt_reduction(G2H18(28),RedSet_5(48),mass5set(:,29),  & 
G1H18(159),G1H18(160),G1H18(161),G1H18(162),G1H18(163),G1H18(164),18)
  call HG1shiftOLR(G1H18(160),8,18)
  call Hotf_5pt_reduction(G2H18(29),RedSet_5(48),mass5set(:,33),  & 
G1H18(165),G1H18(166),G1H18(167),G1H18(168),G1H18(169),G1H18(170),18)
  call HG1shiftOLR(G1H18(166),8,18)
  call Hotf_5pt_reduction(G2H24(13),RedSet_5(58),mass5set(:,29),  & 
G1H24(73),G1H24(74),G1H24(75),G1H24(76),G1H24(77),G1H24(78),24)
  call HG1shiftOLR(G1H24(74),16,24)
  call Hotf_5pt_reduction(G2H24(14),RedSet_5(58),mass5set(:,35),  & 
G1H24(79),G1H24(80),G1H24(81),G1H24(82),G1H24(83),G1H24(84),24)
  call HG1shiftOLR(G1H24(80),16,24)
  call Hotf_5pt_reduction(G2H24(15),RedSet_5(58),mass5set(:,29),  & 
G1H24(85),G1H24(86),G1H24(87),G1H24(88),G1H24(89),G1H24(90),24)
  call HG1shiftOLR(G1H24(86),16,24)
  call Hotf_5pt_reduction(G2H24(16),RedSet_5(58),mass5set(:,36),  & 
G1H24(91),G1H24(92),G1H24(93),G1H24(94),G1H24(95),G1H24(96),24)
  call HG1shiftOLR(G1H24(92),16,24)
  call Hotf_5pt_reduction(G2H24(17),RedSet_5(59),mass5set(:,29),  & 
G1H24(97),G1H24(98),G1H24(99),G1H24(100),G1H24(101),G1H24(102),24)
  call HG1shiftOLR(G1H24(98),8,24)
  call Hotf_5pt_reduction(G2H24(18),RedSet_5(59),mass5set(:,15),  & 
G1H24(103),G1H24(104),G1H24(105),G1H24(106),G1H24(107),G1H24(108),24)
  call HG1shiftOLR(G1H24(104),8,24)
  call Hotf_5pt_reduction(G2H24(19),RedSet_5(59),mass5set(:,29),  & 
G1H24(109),G1H24(110),G1H24(111),G1H24(112),G1H24(113),G1H24(114),24)
  call HG1shiftOLR(G1H24(110),8,24)
  call Hotf_5pt_reduction(G2H24(20),RedSet_5(59),mass5set(:,34),  & 
G1H24(115),G1H24(116),G1H24(117),G1H24(118),G1H24(119),G1H24(120),24)
  call HG1shiftOLR(G1H24(116),8,24)
  call Hotf_5pt_reduction(G2H24(21),RedSet_5(60),mass5set(:,29),  & 
G1H24(121),G1H24(122),G1H24(123),G1H24(124),G1H24(125),G1H24(126),24)
  call HG1shiftOLR(G1H24(122),16,24)
  call Hotf_5pt_reduction(G2H24(22),RedSet_5(60),mass5set(:,35),  & 
G1H24(127),G1H24(128),G1H24(129),G1H24(130),G1H24(131),G1H24(132),24)
  call HG1shiftOLR(G1H24(128),16,24)
  call Hotf_5pt_reduction(G2H24(23),RedSet_5(60),mass5set(:,29),  & 
G1H24(133),G1H24(134),G1H24(135),G1H24(136),G1H24(137),G1H24(138),24)
  call HG1shiftOLR(G1H24(134),16,24)
  call Hotf_5pt_reduction(G2H24(24),RedSet_5(60),mass5set(:,36),  & 
G1H24(139),G1H24(140),G1H24(141),G1H24(142),G1H24(143),G1H24(144),24)
  call HG1shiftOLR(G1H24(140),16,24)
  call Hotf_5pt_reduction(G2H36(1),RedSet_5(61),mass5set(:,4),  & 
G1H36(12),G1H36(3),G1H36(4),G1H36(5),G1H36(31),G1H36(32),36)
  call HG1shiftOLR(G1H36(3),5,36)
  call Hotf_5pt_reduction(G2H36(2),RedSet_5(18),mass5set(:,12),  & 
G1H36(33),G1H36(34),G1H36(35),G1H36(36),G1H36(37),G1H36(38),36)
  call HG1shiftOLR(G1H36(34),16,36)
  call Hloop_QA_V(ntryL,G2H24(25),ex2(:),G2H12(18),m3h2x12(:,12),heltab2x24(:,:,23))
  call Hotf_5pt_reduction(G2H36(3),RedSet_5(62),mass5set(:,5),  & 
G1H36(39),G1H36(40),G1H36(41),G1H36(42),G1H36(43),G1H36(44),36)
  call HG1shiftOLR(G1H36(40),5,36)
  call Hloop_UV_W(ntryL,G1H36(13),34,ex5(:),16,G2H18(13),m3h2x18(:,28),heltab2x36(:,:,49))
  call Hloop_AQ_V(ntryL,G2H24(26),wf6(:,3),G2H4(33),m3h6x4(:,1),heltab2x24(:,:,24))
  call Hloop_VQ_A(ntryL,G1H36(14),wf6(:,3),G1H6(19),m3h6x6(:,1),heltab2x36(:,:,50))
  call Hloop_Q_A(ntryL,G1H6(19),39,nMB,G2H6(31),n2h6(78))
  call Hloop_VQ_A(ntryL,G1H36(15),wf6(:,3),G1H6(20),m3h6x6(:,2),heltab2x36(:,:,51))
  call Hloop_Q_A(ntryL,G1H6(20),39,nMB,G2H6(33),n2h6(79))
  call Hloop_AQ_V(ntryL,G2H24(27),ex1(:),G2H12(19),m3h2x12(:,13),heltab2x24(:,:,25))
  call Hotf_5pt_reduction(G2H36(4),RedSet_5(6),mass5set(:,4),  & 
G1H36(13),G1H36(14),G1H36(15),G1H36(45),G1H36(46),G1H36(47),36)
  call HG1shiftOLR(G1H36(14),10,36)
  call Hotf_5pt_reduction(G2H36(5),RedSet_5(20),mass5set(:,12),  & 
G1H36(48),G1H36(49),G1H36(50),G1H36(51),G1H36(52),G1H36(53),36)
  call HG1shiftOLR(G1H36(49),16,36)
  call Hloop_AQ_V(ntryL,G2H24(28),ex1(:),G2H12(21),m3h2x12(:,14),heltab2x24(:,:,26))
  call Hotf_5pt_reduction(G2H36(6),RedSet_5(7),mass5set(:,5),  & 
G1H36(54),G1H36(55),G1H36(56),G1H36(57),G1H36(58),G1H36(59),36)
  call HG1shiftOLR(G1H36(55),10,36)
  call Hloop_UV_W(ntryL,G1H36(20),33,ex5(:),16,G2H18(9),m3h2x18(:,29),heltab2x36(:,:,52))
  call Hotf_5pt_reduction(G2H24(29),RedSet_5(3),mass5set(:,2),  & 
G1H24(145),G1H24(146),G1H24(147),G1H24(148),G1H24(149),G1H24(150),24)
  call HG1shiftOLR(G1H24(146),10,24)
  call Hloop_QA_V(ntryL,G2H24(30),wf6(:,4),G2H4(34),m3h6x4(:,2),heltab2x24(:,:,27))
  call Hloop_VA_Q(ntryL,G1H36(21),wf6(:,4),G1H6(25),m3h6x6(:,3),heltab2x36(:,:,53))
  call Hloop_A_Q(ntryL,G1H6(25),43,nMB,G2H6(56),n2h6(80))
  call Hloop_VA_Q(ntryL,G1H36(23),wf6(:,4),G1H6(26),m3h6x6(:,4),heltab2x36(:,:,54))
  call Hloop_A_Q(ntryL,G1H6(26),43,nMB,G2H6(57),n2h6(81))
  call Hloop_VQ_A(ntryL,G1H36(24),ex1(:),G1H18(171),m3h2x18(:,30),heltab2x36(:,:,55))
  call Hloop_Q_A(ntryL,G1H18(171),35,nMT,G2H18(10),n2h18(54))
  call Hloop_VQ_A(ntryL,G1H36(25),ex1(:),G1H18(171),m3h2x18(:,31),heltab2x36(:,:,56))
  call Hloop_Q_A(ntryL,G1H18(171),35,nMT,G2H18(12),n2h18(55))
  call Hloop_VQ_A(ntryL,G1H36(8),ex1(:),G1H18(171),m3h2x18(:,32),heltab2x36(:,:,57))
  call Hloop_Q_A(ntryL,G1H18(171),35,nMT,G2H18(19),n2h18(56))
  call Hloop_VA_Q(ntryL,G1H36(26),ex2(:),G1H18(171),m3h2x18(:,33),heltab2x36(:,:,58))
  call Hloop_A_Q(ntryL,G1H18(171),35,nMT,G2H18(27),n2h18(57))
  call Hloop_VA_Q(ntryL,G1H36(28),ex2(:),G1H18(171),m3h2x18(:,34),heltab2x36(:,:,59))
  call Hloop_A_Q(ntryL,G1H18(171),35,nMT,G2H18(1),n2h18(58))
  call Hloop_VA_Q(ntryL,G1H36(29),ex2(:),G1H18(171),m3h2x18(:,35),heltab2x36(:,:,60))
  call Hloop_A_Q(ntryL,G1H18(171),35,nMT,G2H18(5),n2h18(59))
  call Hloop_VA_Q(ntryL,G1H36(30),ex2(:),G1H18(171),m3h2x18(:,36),heltab2x36(:,:,61))
  call Hloop_A_Q(ntryL,G1H18(171),35,nMT,G2H18(23),n2h18(60))
  call Hloop_VA_Q(ntryL,G1H36(2),ex2(:),G1H18(171),m3h2x18(:,37),heltab2x36(:,:,62))
  call Hloop_A_Q(ntryL,G1H18(171),35,nMT,G2H18(15),n2h18(61))
  call Hloop_VA_Q(ntryL,G1H36(10),ex2(:),G1H18(171),m3h2x18(:,38),heltab2x36(:,:,63))
  call Hloop_A_Q(ntryL,G1H18(171),35,nMT,G2H18(11),n2h18(62))
  call Hloop_VQ_A(ntryL,G1H36(1),ex1(:),G1H18(171),m3h2x18(:,39),heltab2x36(:,:,64))
  call Hloop_Q_A(ntryL,G1H18(171),35,nMT,G2H18(14),n2h18(63))
  call Hloop_VQ_A(ntryL,G1H36(9),ex1(:),G1H18(171),m3h2x18(:,40),heltab2x36(:,:,65))
  call Hloop_Q_A(ntryL,G1H18(171),35,nMT,G2H18(2),n2h18(64))
  call Hloop_VQ_A(ntryL,G1H36(16),ex1(:),G1H18(171),m3h2x18(:,41),heltab2x36(:,:,66))
  call Hloop_Q_A(ntryL,G1H18(171),35,nMT,G2H18(3),n2h18(65))
  call Hloop_UV_W(ntryL,G1H36(22),33,ex5(:),16,G2H18(4),m3h2x18(:,42),heltab2x36(:,:,67))
  call Hloop_UV_W(ntryL,G1H36(27),33,ex5(:),16,G2H18(6),m3h2x18(:,43),heltab2x36(:,:,68))
  call Hloop_UV_W(ntryL,G1H36(6),33,ex5(:),16,G2H18(7),m3h2x18(:,44),heltab2x36(:,:,69))
  call Hotf_5pt_reduction(G2H36(7),RedSet_5(24),mass5set(:,13),  & 
G1H36(20),G1H36(21),G1H36(23),G1H36(24),G1H36(25),G1H36(8),36)
  call HG1shiftOLR(G1H36(21),2,36)
  call Hotf_5pt_reduction(G2H36(8),RedSet_5(24),mass5set(:,13),  & 
G1H36(26),G1H36(28),G1H36(29),G1H36(30),G1H36(2),G1H36(10),36)
  call HG1shiftOLR(G1H36(28),2,36)
  call Hotf_5pt_reduction(G2H36(9),RedSet_5(24),mass5set(:,13),  & 
G1H36(1),G1H36(9),G1H36(16),G1H36(22),G1H36(27),G1H36(6),36)
  call HG1shiftOLR(G1H36(9),2,36)
  call Hloop_UV_W(ntryL,G1H36(17),34,ex5(:),16,G2H18(8),m3h2x18(:,45),heltab2x36(:,:,70))
  call Hloop_UV_W(ntryL,G1H36(18),34,ex5(:),16,G2H18(16),m3h2x18(:,46),heltab2x36(:,:,71))
  call Hloop_UV_W(ntryL,G1H36(19),34,ex5(:),16,G2H18(17),m3h2x18(:,47),heltab2x36(:,:,72))
  call Hotf_5pt_reduction(G2H36(10),RedSet_5(17),mass5set(:,11),  & 
G1H36(17),G1H36(18),G1H36(19),G1H36(60),G1H36(61),G1H36(62),36)
  call HG1shiftOLR(G1H36(18),16,36)
  call Hotf_5pt_reduction(G2H36(11),RedSet_5(17),mass5set(:,11),  & 
G1H36(63),G1H36(64),G1H36(65),G1H36(66),G1H36(67),G1H36(68),36)
  call HG1shiftOLR(G1H36(64),16,36)
  call Hotf_5pt_reduction(G2H36(12),RedSet_5(17),mass5set(:,11),  & 
G1H36(69),G1H36(70),G1H36(71),G1H36(72),G1H36(73),G1H36(74),36)
  call HG1shiftOLR(G1H36(70),16,36)
  call Hotf_5pt_reduction(G2H36(13),RedSet_5(23),mass5set(:,13),  & 
G1H36(75),G1H36(76),G1H36(77),G1H36(78),G1H36(79),G1H36(80),36)
  call HG1shiftOLR(G1H36(76),2,36)
  call Hotf_5pt_reduction(G2H36(14),RedSet_5(23),mass5set(:,13),  & 
G1H36(81),G1H36(82),G1H36(83),G1H36(84),G1H36(85),G1H36(86),36)
  call HG1shiftOLR(G1H36(82),2,36)
  call Hotf_5pt_reduction(G2H36(15),RedSet_5(23),mass5set(:,13),  & 
G1H36(87),G1H36(88),G1H36(89),G1H36(90),G1H36(91),G1H36(92),36)
  call HG1shiftOLR(G1H36(88),2,36)
  call Hotf_5pt_reduction(G2H36(16),RedSet_5(19),mass5set(:,11),  & 
G1H36(93),G1H36(94),G1H36(95),G1H36(96),G1H36(97),G1H36(98),36)
  call HG1shiftOLR(G1H36(94),16,36)
  call Hotf_5pt_reduction(G2H36(17),RedSet_5(19),mass5set(:,11),  & 
G1H36(99),G1H36(100),G1H36(101),G1H36(102),G1H36(103),G1H36(104),36)
  call HG1shiftOLR(G1H36(100),16,36)
  call Hotf_5pt_reduction(G2H36(18),RedSet_5(19),mass5set(:,11),  & 
G1H36(105),G1H36(106),G1H36(107),G1H36(108),G1H36(109),G1H36(110),36)
  call HG1shiftOLR(G1H36(106),16,36)
  call Hotf_5pt_reduction(G2H36(19),RedSet_5(4),mass5set(:,3),  & 
G1H36(111),G1H36(112),G1H36(113),G1H36(114),G1H36(115),G1H36(116),36)
  call HG1shiftOLR(G1H36(112),17,36)
  call Hotf_5pt_reduction(G2H24(31),RedSet_5(2),mass5set(:,1),  & 
G1H24(151),G1H24(152),G1H24(153),G1H24(154),G1H24(155),G1H24(156),24)
  call HG1shiftOLR(G1H24(152),17,24)
  call Hloop_AQ_V(ntryL,G2H24(32),wf4(:,7),G2H6(58),m3h4x6(:,1),heltab2x24(:,:,28))
  call Hloop_VQ_A(ntryL,G1H36(11),wf4(:,7),G1H9(10),m3h4x9(:,1),heltab2x36(:,:,73))
  call Hloop_Q_A(ntryL,G1H9(10),51,nMT,G2H9(12),n2h9(27))
  call Hotf_5pt_reduction(G2H36(20),RedSet_5(5),mass5set(:,3),  & 
G1H36(11),G1H36(117),G1H36(118),G1H36(119),G1H36(120),G1H36(121),36)
  call HG1shiftOLR(G1H36(117),18,36)
  call Hotf_5pt_reduction(G2H24(33),RedSet_5(1),mass5set(:,1),  & 
G1H24(157),G1H24(158),G1H24(159),G1H24(160),G1H24(161),G1H24(162),24)
  call HG1shiftOLR(G1H24(158),18,24)
  call Hloop_AQ_V(ntryL,G2H24(34),ex1(:),G2H12(22),m3h2x12(:,15),heltab2x24(:,:,29))
  call Hloop_VA_Q(ntryL,G1H36(7),wf4(:,3),G1H9(11),m3h4x9(:,2),heltab2x36(:,:,74))
  call Hloop_A_Q(ntryL,G1H9(11),51,nMT,G2H9(14),n2h9(28))
  call Hloop_AQ_V(ntryL,G2H12(17),ex1(:),G2H6(59),m3h2x6(:,51),heltab2x12(:,:,86))
  call Hloop_VQ_A(ntryL,G1H18(50),ex1(:),G1H9(15),m3h2x9(:,24),heltab2x18(:,:,57))
  call Hloop_Q_A(ntryL,G1H9(15),51,nMT,G2H9(15),n2h9(29))
  call Hloop_VA_Q(ntryL,G1H18(51),ex2(:),G1H9(16),m3h2x9(:,25),heltab2x18(:,:,58))
  call Hloop_A_Q(ntryL,G1H9(16),51,nMT,G2H9(16),n2h9(30))
  call Hloop_AW_Q(ntryL,G1H12(7),ex3(:),G1H4(20),m3h3x4(:,36),heltab2x12(:,:,87))
  call Hloop_A_Q(ntryL,G1H4(20),60,nMT,G2H4(35),n2h4(41))
call HGT_OLR(G1H12(8),1,1,12)
call HGT_invQ_OLR(G1H12(8),2,5,12)
  call Hloop_Q_A(ntryL,G1H12(8),-2,nMT,G2H12(23),n2h12(45))
  call Hloop_QA_V(ntryL,G2H12(23),ex2(:),G2H6(60),m3h2x6(:,52),heltab2x12(:,:,88))
  call Hloop_AW_Q(ntryL,G1H12(12),ex3(:),G1H4(24),m3h3x4(:,37),heltab2x12(:,:,89))
  call Hloop_A_Q(ntryL,G1H4(24),60,nMT,G2H4(36),n2h4(42))
  call Hloop_AW_Q(ntryL,G1H12(13),ex3(:),G1H4(25),m3h3x4(:,38),heltab2x12(:,:,90))
  call Hloop_A_Q(ntryL,G1H4(25),60,nMT,G2H4(37),n2h4(43))
  call Hloop_AW_Q(ntryL,G1H12(14),ex3(:),G1H4(26),m3h3x4(:,39),heltab2x12(:,:,91))
  call Hloop_A_Q(ntryL,G1H4(26),60,nMT,G2H4(38),n2h4(44))
  call Hloop_QW_A(ntryL,G1H12(17),ex4(:),G1H4(31),m3h3x4(:,40),heltab2x12(:,:,92))
  call Hloop_Q_A(ntryL,G1H4(31),60,nMT,G2H4(39),n2h4(45))
call HGT_OLR(G1H12(18),1,1,12)
call HGT_invQ_OLR(G1H12(18),2,5,12)
  call Hloop_A_Q(ntryL,G1H12(18),-1,nMT,G2H12(25),n2h12(46))
  call Hloop_AQ_V(ntryL,G2H12(25),ex1(:),G2H6(61),m3h2x6(:,53),heltab2x12(:,:,93))
  call Hloop_QW_A(ntryL,G1H12(20),ex4(:),G1H4(32),m3h3x4(:,41),heltab2x12(:,:,94))
  call Hloop_Q_A(ntryL,G1H4(32),60,nMT,G2H4(40),n2h4(46))
  call Hloop_QW_A(ntryL,G1H12(23),ex4(:),G1H4(37),m3h3x4(:,42),heltab2x12(:,:,95))
  call Hloop_Q_A(ntryL,G1H4(37),60,nMT,G2H4(41),n2h4(47))
  call Hloop_QW_A(ntryL,G1H12(24),ex4(:),G1H4(38),m3h3x4(:,43),heltab2x12(:,:,96))
  call Hloop_Q_A(ntryL,G1H4(38),60,nMT,G2H4(42),n2h4(48))
  call Hloop_AV_Q(ntryL,G1H8(1),ex5(:),G1H4(6),m3h2x4(:,11),heltab2x8(:,:,11))
  call Hloop_A_Q(ntryL,G1H4(6),60,nMT,G2H4(43),n2h4(49))
call HGT_OLR(G1H8(2),1,1,8)
call HGT_invQ_OLR(G1H8(2),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(2),-2,nMT,G2H8(10),n2h8(17))
  call Hloop_QA_V(ntryL,G2H8(10),ex2(:),G2H4(44),m3h2x4(:,12),heltab2x8(:,:,12))
  call Hloop_AV_Q(ntryL,G1H8(4),ex5(:),G1H4(18),m3h2x4(:,13),heltab2x8(:,:,13))
  call Hloop_A_Q(ntryL,G1H4(18),60,nMT,G2H4(45),n2h4(50))
  call Hloop_AV_Q(ntryL,G1H8(5),ex5(:),G1H4(30),m3h2x4(:,14),heltab2x8(:,:,14))
  call Hloop_A_Q(ntryL,G1H4(30),60,nMT,G2H4(46),n2h4(51))
  call Hloop_AV_Q(ntryL,G1H8(6),ex5(:),G1H4(36),m3h2x4(:,15),heltab2x8(:,:,15))
  call Hloop_A_Q(ntryL,G1H4(36),60,nMT,G2H4(47),n2h4(52))
  call Hloop_AW_Q(ntryL,G1H18(52),ex4(:),G1H6(30),m3h3x6(:,34),heltab2x18(:,:,59))
  call Hloop_A_Q(ntryL,G1H6(30),58,nMB,G2H6(62),n2h6(82))
call HGT_raise_alpha_OLR(G1H18(53),1,1,18)
call HGT_raise_alpha_invQ_OLR(G1H18(53),2,5,18)
  call Hloop_VQ_A(ntryL,G1H18(53),ex1(:),G1H9(17),m3h2x9(:,26),heltab2x18(:,:,60))
  call Hloop_AW_Q(ntryL,G1H18(64),ex4(:),G1H6(31),m3h3x6(:,35),heltab2x18(:,:,61))
  call Hloop_A_Q(ntryL,G1H6(31),58,nMB,G2H6(63),n2h6(83))
  call Hloop_AW_Q(ntryL,G1H18(59),ex4(:),G1H6(32),m3h3x6(:,36),heltab2x18(:,:,62))
  call Hloop_A_Q(ntryL,G1H6(32),58,nMB,G2H6(64),n2h6(84))
  call Hloop_AW_Q(ntryL,G1H18(62),ex4(:),G1H6(37),m3h3x6(:,37),heltab2x18(:,:,63))
  call Hloop_A_Q(ntryL,G1H6(37),58,nMB,G2H6(65),n2h6(85))
  call Hloop_AW_Q(ntryL,G1H12(25),ex3(:),G1H4(1),m3h3x4(:,44),heltab2x12(:,:,97))
  call Hloop_A_Q(ntryL,G1H4(1),46,nMT,G2H4(48),n2h4(53))
call HGT_raise_alpha_OLR(G1H12(26),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(26),2,5,12)
  call Hloop_UV_W(ntryL,G1H12(26),-16,ex5(:),16,G2H6(66),m3h2x6(:,54),heltab2x12(:,:,98))
call signflip_OLR(G2H6(66))
  call Hloop_AW_Q(ntryL,G1H12(37),ex3(:),G1H4(2),m3h3x4(:,45),heltab2x12(:,:,99))
  call Hloop_A_Q(ntryL,G1H4(2),46,nMT,G2H4(49),n2h4(54))
  call Hloop_AW_Q(ntryL,G1H12(32),ex3(:),G1H4(7),m3h3x4(:,46),heltab2x12(:,:,100))
  call Hloop_A_Q(ntryL,G1H4(7),46,nMT,G2H4(50),n2h4(55))
  call Hloop_AW_Q(ntryL,G1H12(35),ex3(:),G1H4(8),m3h3x4(:,47),heltab2x12(:,:,101))
  call Hloop_A_Q(ntryL,G1H4(8),46,nMT,G2H4(51),n2h4(56))
  call Hloop_QW_A(ntryL,G1H18(63),ex3(:),G1H6(38),m3h3x6(:,38),heltab2x18(:,:,64))
  call Hloop_Q_A(ntryL,G1H6(38),53,nMB,G2H6(67),n2h6(86))



end subroutine vamp_1

end module ol_vamp_1_ppwwtt_ttxwwxgg_1_/**/REALKIND
