
module ol_vamp_1_ppwwtt_ttxddxwwx_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppwwtt_ttxddxwwx_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppwwtt_ttxddxwwx_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_ppwwtt_ttxddxwwx_1_/**/DREALKIND
  use ol_tensor_sum_storage_ppwwtt_ttxddxwwx_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_ppwwtt_ttxddxwwx_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_ppwwtt_ttxddxwwx_1_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL, hel_states
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(hel_states)
  type(Hpolcont), intent(in) :: M(2,hel_states)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel(1:hel_states)
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel(1:hel_states)
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)+c(33)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(1),h0tab(:,1),[32,4,1,2,8,16],[0,0,nMT,0,0,0],6,0)
  call Hloop_AW_Q(ntryL,G0H144(1),ex6(:),G0H48(1),m3h3x48(:,1),heltab2x144(:,:,1))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(1),n2h48(1))
  Gcoeff(:)%j = (c(35)*M(1,:)%j+c(29)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(2),h0tab(:,2),[32,4,2,1,8,16],[0,0,nMT,0,0,0],6,0)
  call Hloop_AW_Q(ntryL,G0H144(1),ex6(:),G0H48(1),m3h3x48(:,2),heltab2x144(:,:,2))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(2),n2h48(2))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)+c(33)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(3),h0tab(:,3),[32,2,8,4,1,16],[nMT,0,0,0,nMT,nMB],6,0)
  call Hloop_QW_A(ntryL,G0H144(1),ex6(:),G0H48(1),m3h3x48(:,3),heltab2x144(:,:,3))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(3),n2h48(3))
  Gcoeff(:)%j = (c(35)*M(1,:)%j+c(29)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(4),h0tab(:,4),[32,2,4,8,1,16],[nMT,0,0,0,nMT,nMB],6,0)
  call Hloop_QW_A(ntryL,G0H144(1),ex6(:),G0H48(1),m3h3x48(:,4),heltab2x144(:,:,4))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(4),n2h48(4))
  call Hloop_AQ_V(ntryL,G1H48(1),ex3(:),G1H24(1),m3h2x24(:,1),heltab2x48(:,:,1))
  call Hloop_AQ_V(ntryL,G1H48(2),ex3(:),G1H24(2),m3h2x24(:,2),heltab2x48(:,:,2))
  call Hloop_QA_V(ntryL,G1H48(3),ex2(:),G1H24(3),m3h2x24(:,3),heltab2x48(:,:,3))
  call Hloop_QA_V(ntryL,G1H48(4),ex2(:),G1H24(4),m3h2x24(:,4),heltab2x48(:,:,4))
  call Hloop_VQ_A(ntryL,G1H24(1),ex1(:),G1H12(1),m3h2x12(:,1),heltab2x24(:,:,1))
  call Hloop_Q_A(ntryL,G1H12(1),37,nMT,G2H12(1),n2h12(1))
  call Hloop_VA_Q(ntryL,G1H24(2),ex2(:),G1H12(1),m3h2x12(:,2),heltab2x24(:,:,2))
  call Hloop_A_Q(ntryL,G1H12(1),38,nMT,G2H12(2),n2h12(2))
  call Hloop_VA_Q(ntryL,G1H24(3),ex4(:),G1H12(1),m3h2x12(:,3),heltab2x24(:,:,3))
  call Hloop_A_Q(ntryL,G1H12(1),42,0,G2H12(3),n2h12(3))
  call Hloop_VQ_A(ntryL,G1H24(4),ex3(:),G1H12(1),m3h2x12(:,4),heltab2x24(:,:,4))
  call Hloop_Q_A(ntryL,G1H12(1),38,0,G2H12(4),n2h12(4))
  call Hloop_QA_V(ntryL,G2H12(1),ex2(:),G2H6(1),m3h2x6(:,1),heltab2x12(:,:,1))
  call Hloop_AQ_V(ntryL,G2H12(2),ex1(:),G2H6(2),m3h2x6(:,2),heltab2x12(:,:,2))
  call Hloop_AQ_V(ntryL,G2H12(3),ex3(:),G2H6(3),m3h2x6(:,3),heltab2x12(:,:,3))
  call Hloop_QA_V(ntryL,G2H12(4),ex4(:),G2H6(4),m3h2x6(:,4),heltab2x12(:,:,4))
  call Hotf_5pt_reduction(G2H6(1),RedSet_5(1),mass5set(:,1),  & 
G1H6(1),G1H6(2),G1H6(3),G1H6(4),G1H6(5),G1H6(6),6)
  call HG1shiftOLR(G1H6(2),16,6)
  call Hotf_5pt_reduction(G2H6(2),RedSet_5(2),mass5set(:,1),  & 
G1H6(7),G1H6(8),G1H6(9),G1H6(10),G1H6(11),G1H6(12),6)
  call HG1shiftOLR(G1H6(8),16,6)
  call Hotf_5pt_reduction(G2H6(3),RedSet_5(3),mass5set(:,2),  & 
G1H6(13),G1H6(14),G1H6(15),G1H6(16),G1H6(17),G1H6(18),6)
  call HG1shiftOLR(G1H6(14),16,6)
  call Hotf_5pt_reduction(G2H6(4),RedSet_5(4),mass5set(:,2),  & 
G1H6(19),G1H6(20),G1H6(21),G1H6(22),G1H6(23),G1H6(24),6)
  call HG1shiftOLR(G1H6(20),16,6)
  call Hloop_VA_Q(ntryL,G1H6(1),ex4(:),G1H3(1),m3h2x3(:,1),heltab2x6(:,:,1))
  call Hloop_A_Q(ntryL,G1H3(1),47,0,G2H3(1),n2h3(1))
call HGT_OLR(G1H6(2),1,1,6)
call HGT_invQ_OLR(G1H6(2),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(2),-16,0,G2H6(1),n2h6(1))
  call Hloop_QW_A(ntryL,G2H6(1),ex5(:),G2H2(1),m3h3x2(:,1),heltab2x6(:,:,2))
  call Hloop_VA_Q(ntryL,G1H6(6),ex4(:),G1H3(1),m3h2x3(:,2),heltab2x6(:,:,3))
  call Hloop_A_Q(ntryL,G1H3(1),47,0,G2H3(2),n2h3(2))
  call Hloop_VA_Q(ntryL,G1H6(7),ex4(:),G1H3(1),m3h2x3(:,3),heltab2x6(:,:,4))
  call Hloop_A_Q(ntryL,G1H3(1),47,0,G2H3(3),n2h3(3))
call HGT_OLR(G1H6(8),1,1,6)
call HGT_invQ_OLR(G1H6(8),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(8),-16,0,G2H6(2),n2h6(2))
  call Hloop_QW_A(ntryL,G2H6(2),ex5(:),G2H2(2),m3h3x2(:,2),heltab2x6(:,:,5))
  call Hloop_VA_Q(ntryL,G1H6(12),ex4(:),G1H3(1),m3h2x3(:,4),heltab2x6(:,:,6))
  call Hloop_A_Q(ntryL,G1H3(1),47,0,G2H3(4),n2h3(4))
  call Hloop_VQ_A(ntryL,G1H6(13),ex1(:),G1H3(1),m3h2x3(:,5),heltab2x6(:,:,7))
  call Hloop_Q_A(ntryL,G1H3(1),47,nMT,G2H3(5),n2h3(5))
call HGT_OLR(G1H6(14),1,1,6)
call HGT_invQ_OLR(G1H6(14),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(14),-16,nMB,G2H6(3),n2h6(3))
  call Hloop_AW_Q(ntryL,G2H6(3),ex5(:),G2H2(3),m3h3x2(:,3),heltab2x6(:,:,8))
  call Hloop_VQ_A(ntryL,G1H6(18),ex1(:),G1H3(1),m3h2x3(:,6),heltab2x6(:,:,9))
  call Hloop_Q_A(ntryL,G1H3(1),47,nMT,G2H3(6),n2h3(6))
  call Hloop_VQ_A(ntryL,G1H6(19),ex1(:),G1H3(1),m3h2x3(:,7),heltab2x6(:,:,10))
  call Hloop_Q_A(ntryL,G1H3(1),47,nMT,G2H3(7),n2h3(7))
call HGT_OLR(G1H6(20),1,1,6)
call HGT_invQ_OLR(G1H6(20),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(20),-16,nMB,G2H6(4),n2h6(4))
  call Hloop_AW_Q(ntryL,G2H6(4),ex5(:),G2H2(4),m3h3x2(:,4),heltab2x6(:,:,11))
  call Hloop_VQ_A(ntryL,G1H6(24),ex1(:),G1H3(1),m3h2x3(:,8),heltab2x6(:,:,12))
  call Hloop_Q_A(ntryL,G1H3(1),47,nMT,G2H3(8),n2h3(8))
  call Hotf_5pt_reduction(G2H3(1),RedSet_5(1),mass5set(:,1),  & 
G1H3(1),G1H3(2),G1H3(3),G1H3(4),G1H3(5),G1H3(6),3)
  call HG1shiftOLR(G1H3(2),16,3)
  call Hotf_5pt_reduction(G2H3(3),RedSet_5(2),mass5set(:,1),  & 
G1H3(7),G1H3(8),G1H3(9),G1H3(10),G1H3(11),G1H3(12),3)
  call HG1shiftOLR(G1H3(8),16,3)
  call Hotf_5pt_reduction(G2H3(5),RedSet_5(3),mass5set(:,2),  & 
G1H3(13),G1H3(14),G1H3(15),G1H3(16),G1H3(17),G1H3(18),3)
  call HG1shiftOLR(G1H3(14),16,3)
  call Hotf_5pt_reduction(G2H3(7),RedSet_5(4),mass5set(:,2),  & 
G1H3(19),G1H3(20),G1H3(21),G1H3(22),G1H3(23),G1H3(24),3)
  call HG1shiftOLR(G1H3(20),16,3)
  call Hloop_AW_Q(ntryL,G1H3(1),ex5(:),G1H1(1),m3h3x1(:,1),heltab2x3(:,:,1))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(1),n2h1(1))
  call Hloop_AW_Q(ntryL,G1H3(2),ex5(:),G1H1(1),m3h3x1(:,2),heltab2x3(:,:,2))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(2),n2h1(2))
  call Hloop_AW_Q(ntryL,G1H3(7),ex5(:),G1H1(1),m3h3x1(:,3),heltab2x3(:,:,3))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(3),n2h1(3))
  call Hloop_AW_Q(ntryL,G1H3(8),ex5(:),G1H1(1),m3h3x1(:,4),heltab2x3(:,:,4))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(4),n2h1(4))
  call Hloop_QW_A(ntryL,G1H3(13),ex5(:),G1H1(1),m3h3x1(:,5),heltab2x3(:,:,5))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(5),n2h1(5))
  call Hloop_QW_A(ntryL,G1H3(14),ex5(:),G1H1(1),m3h3x1(:,6),heltab2x3(:,:,6))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(6),n2h1(6))
  call Hloop_QW_A(ntryL,G1H3(19),ex5(:),G1H1(1),m3h3x1(:,7),heltab2x3(:,:,7))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(7),n2h1(7))
  call Hloop_QW_A(ntryL,G1H3(20),ex5(:),G1H1(1),m3h3x1(:,8),heltab2x3(:,:,8))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(8),n2h1(8))
  call Hotf_5pt_reduction_last(G2tensor(1),RedSet_5(1),mass5set(:,1),  & 
G1tensor(1),G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(5),G1tensor(6))
  call G_TensorShift(G1tensor(2),16)
  call Hotf_5pt_reduction_last(G2tensor(3),RedSet_5(2),mass5set(:,1),  & 
G1tensor(7),G1tensor(8),G1tensor(9),G1tensor(10),G1tensor(11),G1tensor(12))
  call G_TensorShift(G1tensor(8),16)
  call Hotf_5pt_reduction_last(G2tensor(5),RedSet_5(3),mass5set(:,2),  & 
G1tensor(13),G1tensor(14),G1tensor(15),G1tensor(16),G1tensor(17),G1tensor(18))
  call G_TensorShift(G1tensor(14),16)
  call Hotf_5pt_reduction_last(G2tensor(7),RedSet_5(4),mass5set(:,2),  & 
G1tensor(19),G1tensor(20),G1tensor(21),G1tensor(22),G1tensor(23),G1tensor(24))
  call G_TensorShift(G1tensor(20),16)
  call ol_merge_tensors(T1sum(1),[G1tensor(1)])
  call ol_merge_tensors(T1sum(2),[G1tensor(7)])
  call ol_merge_tensors(T1sum(3),[G1tensor(13)])
  call ol_merge_tensors(T1sum(4),[G1tensor(19)])
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j)+c(29)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(5),h0tab(:,5),[32,3,16,8,4],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_QW_A(ntryL,G0H144(1),ex6(:),G0H48(1),m3h3x48(:,5),heltab2x144(:,:,5))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(1),n2h48(5))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j)+c(29)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(6),h0tab(:,6),[32,4,8,3,16],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_AW_Q(ntryL,G0H144(1),ex6(:),G0H48(1),m3h3x48(:,6),heltab2x144(:,:,6))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(2),n2h48(6))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j)+c(29)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(7),h0tab(:,7),[32,3,4,8,16],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_AW_Q(ntryL,G0H144(1),ex6(:),G0H48(1),m3h3x48(:,7),heltab2x144(:,:,7))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(3),n2h48(7))
  Gcoeff(:)%j = (c(26)*M(1,:)%j-c(25)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(8),h0tab(:,8),[32,4,3,8,16],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_AW_Q(ntryL,G0H144(1),ex6(:),G0H48(1),m3h3x48(:,8),heltab2x144(:,:,8))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(4),n2h48(8))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j)+c(29)*M(2,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(9),h0tab(:,9),[32,2,1,16,12],[nMT,0,nMT,nMB,nMB],5,1,wf4(:,2))
  call Hloop_QW_A(ntryL,G0H144(1),ex6(:),G0H48(1),m3h3x48(:,9),heltab2x144(:,:,9))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(5),n2h48(9))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j)+c(29)*M(2,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(10),h0tab(:,10),[32,12,2,1,16],[nMT,nMT,0,nMT,nMB],5,1,wf4(:,2))
  call Hloop_QW_A(ntryL,G0H144(1),ex6(:),G0H48(1),m3h3x48(:,10),heltab2x144(:,:,10))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(6),n2h48(10))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j)+c(29)*M(2,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(11),h0tab(:,11),[32,2,1,12,16],[nMT,0,nMT,nMT,nMB],5,1,wf4(:,2))
  call Hloop_QW_A(ntryL,G0H144(1),ex6(:),G0H48(1),m3h3x48(:,11),heltab2x144(:,:,11))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(7),n2h48(11))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)+c(25)*M(2,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(12),h0tab(:,12),[32,2,12,1,16],[nMT,0,0,nMT,nMB],5,1,wf4(:,2))
  call Hloop_QW_A(ntryL,G0H144(1),ex6(:),G0H48(1),m3h3x48(:,12),heltab2x144(:,:,12))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(8),n2h48(12))
  Gcoeff(:)%j = (c(35)*M(1,:)%j+c(29)*M(2,:)%j) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(13),h0tab(:,13),[32,2,4,8,17],[nMT,0,0,0,nMB],5,1,wf6(:,7))
  call Hloop_QW_A(ntryL,G0H144(1),ex6(:),G0H48(1),m3h3x48(:,13),heltab2x144(:,:,13))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(9),n2h48(13))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)+c(33)*M(2,:)%j) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(14),h0tab(:,14),[32,2,8,4,17],[nMT,0,0,0,nMB],5,1,wf6(:,7))
  call Hloop_QW_A(ntryL,G0H144(1),ex6(:),G0H48(1),m3h3x48(:,14),heltab2x144(:,:,14))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(10),n2h48(14))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)+c(33)*M(2,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(15),h0tab(:,15),[32,4,1,2,24],[0,0,nMT,0,0],5,1,wf6(:,4))
  call Hloop_AW_Q(ntryL,G0H144(1),ex6(:),G0H48(1),m3h3x48(:,15),heltab2x144(:,:,15))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(11),n2h48(15))
  Gcoeff(:)%j = (c(35)*M(1,:)%j+c(29)*M(2,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(16),h0tab(:,16),[32,4,2,1,24],[0,0,nMT,0,0],5,1,wf6(:,4))
  call Hloop_AW_Q(ntryL,G0H144(1),ex6(:),G0H48(1),m3h3x48(:,16),heltab2x144(:,:,16))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(12),n2h48(16))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)+c(33)*M(2,:)%j) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(17),h0tab(:,17),[34,8,4,1,16],[0,0,0,nMT,nMB],5,1,wf6(:,8))
  call Hloop_QA_V(ntryL,G0H144(1),wf6(:,8),G0H24(1),m3h6x24(:,1),heltab2x144(:,:,17))
  Gcoeff(:)%j = (c(35)*M(1,:)%j+c(29)*M(2,:)%j) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(18),h0tab(:,18),[34,4,8,1,16],[0,0,0,nMT,nMB],5,1,wf6(:,8))
  call Hloop_QA_V(ntryL,G0H144(1),wf6(:,8),G0H24(2),m3h6x24(:,2),heltab2x144(:,:,18))
  Gcoeff(:)%j = (c(35)*M(1,:)%j+c(29)*M(2,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(19),h0tab(:,19),[36,2,1,8,16],[0,nMT,0,0,0],5,1,wf6(:,3))
  call Hloop_AQ_V(ntryL,G0H144(1),wf6(:,3),G0H24(3),m3h6x24(:,3),heltab2x144(:,:,19))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)+c(33)*M(2,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(20),h0tab(:,20),[36,1,2,8,16],[0,nMT,0,0,0],5,1,wf6(:,3))
  call Hloop_AQ_V(ntryL,G0H144(1),wf6(:,3),G0H24(4),m3h6x24(:,4),heltab2x144(:,:,20))
  Gcoeff(:)%j = (c(9)*M(1,:)%j-c(11)*M(2,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(21),h0tab(:,21),[48,4,1,2,8],[0,0,nMT,0,0],5,1,wf9(:,1))
  call Hloop_AV_Q(ntryL,G0H144(1),wf9(:,1),G0H16(1),m3h9x16(:,1),heltab2x144(:,:,21))
  call Hloop_A_Q(ntryL,G0H16(1),48,0,G1H16(1),n2h16(1))
  Gcoeff(:)%j = (-(c(57)*M(1,:)%j)+c(59)*M(2,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(22),h0tab(:,22),[48,4,1,2,8],[0,0,nMT,0,0],5,1,wf9(:,2))
  call Hloop_AZ_Q(ntryL,G0H144(1),wf9(:,2),G0H16(1),ngZd,m3h9x16(:,2),heltab2x144(:,:,22))
  call Hloop_A_Q(ntryL,G0H16(1),48,0,G1H16(2),n2h16(2))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)-c(7)*M(2,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(23),h0tab(:,23),[48,4,2,1,8],[0,0,nMT,0,0],5,1,wf9(:,1))
  call Hloop_AV_Q(ntryL,G0H144(1),wf9(:,1),G0H16(1),m3h9x16(:,3),heltab2x144(:,:,23))
  call Hloop_A_Q(ntryL,G0H16(1),48,0,G1H16(3),n2h16(3))
  Gcoeff(:)%j = (c(61)*M(1,:)%j+c(55)*M(2,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(24),h0tab(:,24),[48,4,2,1,8],[0,0,nMT,0,0],5,1,wf9(:,2))
  call Hloop_AZ_Q(ntryL,G0H144(1),wf9(:,2),G0H16(1),ngZd,m3h9x16(:,4),heltab2x144(:,:,24))
  call Hloop_A_Q(ntryL,G0H16(1),48,0,G1H16(4),n2h16(4))
  Gcoeff(:)%j = (c(44)*M(1,:)%j-c(46)*M(2,:)%j) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(25),h0tab(:,25),[48,1,4,8,2],[nMT,0,0,0,nMT],5,1,wf9(:,3))
  call Hloop_AS_Q(ntryL,G0H144(1),wf9(:,3),G0H16(1),ngH,m3h9x16(:,5),heltab2x144(:,:,25))
  call Hloop_A_Q(ntryL,G0H16(1),48,nMT,G1H16(5),n2h16(5))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)+c(20)*M(2,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(26),h0tab(:,26),[48,1,4,8,2],[nMT,0,0,0,nMT],5,1,wf9(:,1))
  call Hloop_AV_Q(ntryL,G0H144(1),wf9(:,1),G0H16(1),m3h9x16(:,6),heltab2x144(:,:,26))
  call Hloop_A_Q(ntryL,G0H16(1),48,nMT,G1H16(6),n2h16(6))
  Gcoeff(:)%j = (-(c(57)*M(1,:)%j)+c(59)*M(2,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(27),h0tab(:,27),[48,1,4,8,2],[nMT,0,0,0,nMT],5,1,wf9(:,2))
  call Hloop_AZ_Q(ntryL,G0H144(1),wf9(:,2),G0H16(1),ngZu,m3h9x16(:,7),heltab2x144(:,:,27))
  call Hloop_A_Q(ntryL,G0H16(1),48,nMT,G1H16(7),n2h16(7))
  Gcoeff(:)%j = (-(c(48)*M(1,:)%j)-c(42)*M(2,:)%j) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(28),h0tab(:,28),[48,1,8,4,2],[nMT,0,0,0,nMT],5,1,wf9(:,3))
  call Hloop_AS_Q(ntryL,G0H144(1),wf9(:,3),G0H16(1),ngH,m3h9x16(:,8),heltab2x144(:,:,28))
  call Hloop_A_Q(ntryL,G0H16(1),48,nMT,G1H16(8),n2h16(8))
  Gcoeff(:)%j = (c(22)*M(1,:)%j+c(16)*M(2,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(29),h0tab(:,29),[48,1,8,4,2],[nMT,0,0,0,nMT],5,1,wf9(:,1))
  call Hloop_AV_Q(ntryL,G0H144(1),wf9(:,1),G0H16(1),m3h9x16(:,9),heltab2x144(:,:,29))
  call Hloop_A_Q(ntryL,G0H16(1),48,nMT,G1H16(9),n2h16(9))
  Gcoeff(:)%j = (c(61)*M(1,:)%j+c(55)*M(2,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(30),h0tab(:,30),[48,1,8,4,2],[nMT,0,0,0,nMT],5,1,wf9(:,2))
  call Hloop_AZ_Q(ntryL,G0H144(1),wf9(:,2),G0H16(1),ngZu,m3h9x16(:,10),heltab2x144(:,:,30))
  call Hloop_A_Q(ntryL,G0H16(1),48,nMT,G1H16(10),n2h16(10))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(2),[G1H16(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(4),[G1H16(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(7),[G1H16(6),G1H16(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(10),[G1H16(9),G1H16(8)])
  call Hloop_QV_A(ntryL,G1H48(1),wf4(:,1),G1H12(1),m3h4x12(:,1),heltab2x48(:,:,5))
  call Hloop_Q_A(ntryL,G1H12(1),35,0,G2H12(1),n2h12(5))
  call Hloop_AQ_V(ntryL,G1H48(2),ex3(:),G1H24(1),m3h2x24(:,5),heltab2x48(:,:,6))
  call Hloop_AV_Q(ntryL,G1H48(3),wf4(:,1),G1H12(1),m3h4x12(:,2),heltab2x48(:,:,7))
  call Hloop_A_Q(ntryL,G1H12(1),35,0,G2H12(2),n2h12(6))
  call Hloop_AQ_V(ntryL,G1H48(4),ex3(:),G1H24(2),m3h2x24(:,6),heltab2x48(:,:,8))
  call Hloop_QA_V(ntryL,G1H48(5),ex2(:),G1H24(3),m3h2x24(:,7),heltab2x48(:,:,9))
  call Hloop_QV_A(ntryL,G1H48(6),wf4(:,2),G1H12(1),m3h4x12(:,3),heltab2x48(:,:,10))
  call Hloop_Q_A(ntryL,G1H12(1),44,nMT,G2H12(3),n2h12(7))
  call Hloop_QA_V(ntryL,G1H48(7),ex2(:),G1H24(4),m3h2x24(:,8),heltab2x48(:,:,11))
  call Hloop_QA_V(ntryL,G1H48(8),ex2(:),G1H24(5),m3h2x24(:,9),heltab2x48(:,:,12))
  call Hloop_QA_V(ntryL,G1H48(9),ex2(:),G1H24(6),m3h2x24(:,10),heltab2x48(:,:,13))
  call Hloop_QA_V(ntryL,G1H48(10),ex2(:),G1H24(7),m3h2x24(:,11),heltab2x48(:,:,14))
  call Hloop_AQ_V(ntryL,G1H48(11),ex3(:),G1H24(8),m3h2x24(:,12),heltab2x48(:,:,15))
  call Hloop_AQ_V(ntryL,G1H48(12),ex3(:),G1H24(9),m3h2x24(:,13),heltab2x48(:,:,16))
  call Hloop_VA_Q(ntryL,G0H24(1),ex4(:),G0H12(1),m3h2x12(:,5),heltab2x24(:,:,5))
  call Hloop_A_Q(ntryL,G0H12(1),42,0,G1H12(1),n2h12(8))
  call Hloop_VQ_A(ntryL,G0H24(2),ex3(:),G0H12(1),m3h2x12(:,6),heltab2x24(:,:,6))
  call Hloop_Q_A(ntryL,G0H12(1),38,0,G1H12(2),n2h12(9))
  call Hloop_VA_Q(ntryL,G0H24(3),ex2(:),G0H12(1),m3h2x12(:,7),heltab2x24(:,:,7))
  call Hloop_A_Q(ntryL,G0H12(1),38,nMT,G1H12(3),n2h12(10))
  call Hloop_VQ_A(ntryL,G0H24(4),ex1(:),G0H12(1),m3h2x12(:,8),heltab2x24(:,:,8))
  call Hloop_Q_A(ntryL,G0H12(1),37,nMT,G1H12(4),n2h12(11))
  call Hloop_AQ_V(ntryL,G1H16(2),ex3(:),G1H8(1),m3h2x8(:,1),heltab2x16(:,:,1))
  call Hloop_AQ_V(ntryL,G1H16(4),ex3(:),G1H8(2),m3h2x8(:,2),heltab2x16(:,:,2))
  call Hloop_AQ_V(ntryL,G1H16(7),ex1(:),G1H8(3),m3h2x8(:,3),heltab2x16(:,:,3))
  call Hloop_AQ_V(ntryL,G1H16(10),ex1(:),G1H8(4),m3h2x8(:,4),heltab2x16(:,:,4))
  call Hotf_5pt_reduction(G2H12(1),RedSet_5(5),mass5set(:,3),  & 
G1H12(5),G1H12(6),G1H12(7),G1H12(8),G1H12(9),G1H12(10),12)
  call HG1shiftOLR(G1H12(6),4,12)
  call Hloop_VA_Q(ntryL,G1H24(1),ex4(:),G1H12(11),m3h2x12(:,9),heltab2x24(:,:,9))
  call Hloop_A_Q(ntryL,G1H12(11),44,0,G2H12(4),n2h12(12))
  call Hloop_AQ_V(ntryL,G2H12(2),ex3(:),G2H6(1),m3h2x6(:,5),heltab2x12(:,:,5))
  call Hloop_UV_W(ntryL,G1H24(2),36,wf4(:,1),3,G2H6(2),m3h4x6(:,1),heltab2x24(:,:,10))
  call Hloop_VQ_A(ntryL,G1H24(3),ex1(:),G1H12(11),m3h2x12(:,10),heltab2x24(:,:,11))
  call Hloop_Q_A(ntryL,G1H12(11),35,nMT,G2H12(1),n2h12(13))
  call Hloop_QA_V(ntryL,G2H12(3),ex2(:),G2H6(3),m3h2x6(:,6),heltab2x12(:,:,6))
  call Hloop_VQ_A(ntryL,G1H24(4),ex1(:),G1H12(11),m3h2x12(:,11),heltab2x24(:,:,12))
  call Hloop_Q_A(ntryL,G1H12(11),35,nMT,G2H12(2),n2h12(14))
  call Hloop_UV_W(ntryL,G1H24(5),34,wf4(:,2),12,G2H6(4),m3h4x6(:,2),heltab2x24(:,:,13))
  call Hloop_VQ_A(ntryL,G1H24(6),ex3(:),G1H12(11),m3h2x12(:,12),heltab2x24(:,:,14))
  call Hloop_Q_A(ntryL,G1H12(11),38,0,G2H12(3),n2h12(15))
  call Hloop_VA_Q(ntryL,G1H24(7),ex4(:),G1H12(11),m3h2x12(:,13),heltab2x24(:,:,15))
  call Hloop_A_Q(ntryL,G1H12(11),42,0,G2H12(5),n2h12(16))
  call Hloop_VQ_A(ntryL,G1H24(8),ex1(:),G1H12(11),m3h2x12(:,14),heltab2x24(:,:,16))
  call Hloop_Q_A(ntryL,G1H12(11),37,nMT,G2H12(6),n2h12(17))
  call Hloop_VA_Q(ntryL,G1H24(9),ex2(:),G1H12(11),m3h2x12(:,15),heltab2x24(:,:,17))
  call Hloop_A_Q(ntryL,G1H12(11),38,nMT,G2H12(7),n2h12(18))
  call Hloop_AQ_V(ntryL,G1H12(1),ex3(:),G1H6(1),m3h2x6(:,7),heltab2x12(:,:,7))
  call Hloop_QA_V(ntryL,G1H12(2),ex4(:),G1H6(2),m3h2x6(:,8),heltab2x12(:,:,8))
  call Hloop_AQ_V(ntryL,G1H12(3),ex1(:),G1H6(6),m3h2x6(:,9),heltab2x12(:,:,9))
  call Hloop_QA_V(ntryL,G1H12(4),ex2(:),G1H6(7),m3h2x6(:,10),heltab2x12(:,:,10))
  call Hloop_VQ_A(ntryL,G1H8(1),ex1(:),G1H4(1),m3h2x4(:,1),heltab2x8(:,:,1))
  call Hloop_Q_A(ntryL,G1H4(1),53,nMT,G2H4(1),n2h4(1))
  call Hloop_VA_Q(ntryL,G1H8(2),ex2(:),G1H4(1),m3h2x4(:,2),heltab2x8(:,:,2))
  call Hloop_A_Q(ntryL,G1H4(1),54,nMT,G2H4(2),n2h4(2))
  call Hloop_VQ_A(ntryL,G1H8(3),ex3(:),G1H4(1),m3h2x4(:,3),heltab2x8(:,:,3))
  call Hloop_Q_A(ntryL,G1H4(1),53,0,G2H4(3),n2h4(3))
  call Hloop_VA_Q(ntryL,G1H8(4),ex4(:),G1H4(1),m3h2x4(:,4),heltab2x8(:,:,4))
  call Hloop_A_Q(ntryL,G1H4(1),57,0,G2H4(4),n2h4(4))
  call Hloop_QW_A(ntryL,G1H12(5),ex5(:),G1H4(1),m3h3x4(:,1),heltab2x12(:,:,11))
  call Hloop_Q_A(ntryL,G1H4(1),51,0,G2H4(5),n2h4(5))
call HGT_OLR(G1H12(6),1,1,12)
call HGT_invQ_OLR(G1H12(6),2,5,12)
  call Hloop_A_Q(ntryL,G1H12(6),-4,0,G2H12(8),n2h12(19))
  call Hloop_AQ_V(ntryL,G2H12(8),ex3(:),G2H6(5),m3h2x6(:,11),heltab2x12(:,:,12))
  call Hloop_QW_A(ntryL,G1H12(8),ex5(:),G1H4(1),m3h3x4(:,2),heltab2x12(:,:,13))
  call Hloop_Q_A(ntryL,G1H4(1),51,0,G2H4(6),n2h4(6))
  call Hloop_QW_A(ntryL,G1H12(9),ex5(:),G1H4(1),m3h3x4(:,3),heltab2x12(:,:,14))
  call Hloop_Q_A(ntryL,G1H4(1),51,0,G2H4(7),n2h4(7))
  call Hloop_QW_A(ntryL,G1H12(10),ex5(:),G1H4(1),m3h3x4(:,4),heltab2x12(:,:,15))
  call Hloop_Q_A(ntryL,G1H4(1),51,0,G2H4(8),n2h4(8))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(7),[G1H6(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(2),[G1H6(11),G1H6(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(6),[G1H6(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(1),[G1H6(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(4),[G1H6(23),G1H6(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(2),[G1H6(21)])
  call Hloop_VA_Q(ntryL,G1H6(7),ex4(:),G1H3(1),m3h2x3(:,9),heltab2x6(:,:,13))
  call Hloop_A_Q(ntryL,G1H3(1),47,0,G2H3(1),n2h3(9))
  call Hloop_VA_Q(ntryL,G1H6(4),ex4(:),G1H3(2),m3h2x3(:,10),heltab2x6(:,:,14))
  call Hloop_A_Q(ntryL,G1H3(2),47,0,G2H3(3),n2h3(10))
  call Hotf_5pt_reduction(G2H6(2),RedSet_5(6),mass5set(:,3),  & 
G1H6(8),G1H6(12),G1H6(13),G1H6(14),G1H6(18),G1H6(19),6)
  call HG1shiftOLR(G1H6(12),16,6)
  call Hloop_VA_Q(ntryL,G1H6(6),ex4(:),G1H3(7),m3h2x3(:,11),heltab2x6(:,:,15))
  call Hloop_A_Q(ntryL,G1H3(7),47,0,G2H3(5),n2h3(11))
  call Hloop_VA_Q(ntryL,G1H6(10),ex4(:),G1H3(8),m3h2x3(:,12),heltab2x6(:,:,16))
  call Hloop_A_Q(ntryL,G1H3(8),47,0,G2H3(7),n2h3(12))
  call Hloop_VQ_A(ntryL,G1H6(1),ex1(:),G1H3(13),m3h2x3(:,13),heltab2x6(:,:,17))
  call Hloop_Q_A(ntryL,G1H3(13),47,nMT,G2H3(9),n2h3(13))
  call Hloop_VQ_A(ntryL,G1H6(16),ex1(:),G1H3(14),m3h2x3(:,14),heltab2x6(:,:,18))
  call Hloop_Q_A(ntryL,G1H3(14),47,nMT,G2H3(10),n2h3(14))
  call Hotf_5pt_reduction(G2H6(4),RedSet_5(7),mass5set(:,4),  & 
G1H6(20),G1H6(24),G1H6(3),G1H6(11),G1H6(5),G1H6(9),6)
  call HG1shiftOLR(G1H6(24),16,6)
  call Hloop_VQ_A(ntryL,G1H6(2),ex1(:),G1H3(19),m3h2x3(:,15),heltab2x6(:,:,19))
  call Hloop_Q_A(ntryL,G1H3(19),47,nMT,G2H3(11),n2h3(15))
  call Hloop_VQ_A(ntryL,G1H6(22),ex1(:),G1H3(20),m3h2x3(:,16),heltab2x6(:,:,20))
  call Hloop_Q_A(ntryL,G1H3(20),47,nMT,G2H3(12),n2h3(16))
  call Hotf_5pt_reduction(G2H12(4),RedSet_5(8),mass5set(:,3),  & 
G1H12(11),G1H12(1),G1H12(2),G1H12(3),G1H12(4),G1H12(5),12)
  call HG1shiftOLR(G1H12(1),16,12)
  call Hotf_5pt_reduction(G2H6(1),RedSet_5(9),mass5set(:,3),  & 
G1H6(15),G1H6(23),G1H6(17),G1H6(21),G1H6(7),G1H6(4),6)
  call HG1shiftOLR(G1H6(23),16,6)
  call Hotf_5pt_reduction(G2H12(1),RedSet_5(10),mass5set(:,5),  & 
G1H12(6),G1H12(8),G1H12(9),G1H12(10),G1H12(12),G1H12(13),12)
  call HG1shiftOLR(G1H12(8),12,12)
  call Hotf_5pt_reduction(G2H6(3),RedSet_5(11),mass5set(:,6),  & 
G1H6(6),G1H6(10),G1H6(1),G1H6(16),G1H6(2),G1H6(22),6)
  call HG1shiftOLR(G1H6(10),16,6)
  call Hotf_5pt_reduction(G2H12(2),RedSet_5(12),mass5set(:,7),  & 
G1H12(14),G1H12(15),G1H12(16),G1H12(17),G1H12(18),G1H12(19),12)
  call HG1shiftOLR(G1H12(15),16,12)
  call Hloop_QA_V(ntryL,G2H12(3),ex4(:),G2H6(2),m3h2x6(:,12),heltab2x12(:,:,16))
  call Hloop_AQ_V(ntryL,G2H12(5),ex3(:),G2H6(4),m3h2x6(:,13),heltab2x12(:,:,17))
  call Hloop_QA_V(ntryL,G2H12(6),ex2(:),G2H6(1),m3h2x6(:,14),heltab2x12(:,:,18))
  call Hloop_AQ_V(ntryL,G2H12(7),ex1(:),G2H6(3),m3h2x6(:,15),heltab2x12(:,:,19))
  call Hloop_QA_V(ntryL,G2H4(1),ex2(:),G2H2(5),m3h2x2(:,1),heltab2x4(:,:,1))
  call Hloop_AQ_V(ntryL,G2H4(2),ex1(:),G2H2(6),m3h2x2(:,2),heltab2x4(:,:,2))
  call Hloop_QA_V(ntryL,G2H4(3),ex4(:),G2H2(7),m3h2x2(:,3),heltab2x4(:,:,3))
  call Hloop_AQ_V(ntryL,G2H4(4),ex3(:),G2H2(8),m3h2x2(:,4),heltab2x4(:,:,4))
  call Hloop_QA_V(ntryL,G2H4(5),ex4(:),G2H2(9),m3h2x2(:,5),heltab2x4(:,:,5))
  call Hloop_QA_V(ntryL,G2H4(7),ex4(:),G2H2(10),m3h2x2(:,6),heltab2x4(:,:,6))
  call Hloop_QA_V(ntryL,G2H4(8),ex4(:),G2H2(11),m3h2x2(:,7),heltab2x4(:,:,7))
  call Hloop_VA_Q(ntryL,G1H6(8),ex4(:),G1H3(1),m3h2x3(:,17),heltab2x6(:,:,21))
  call Hloop_A_Q(ntryL,G1H3(1),47,0,G2H3(13),n2h3(17))
call HGT_OLR(G1H6(12),1,1,6)
call HGT_invQ_OLR(G1H6(12),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(12),-16,0,G2H6(6),n2h6(5))
  call Hloop_QW_A(ntryL,G2H6(6),ex5(:),G2H2(12),m3h3x2(:,5),heltab2x6(:,:,22))
  call Hloop_VA_Q(ntryL,G1H6(18),ex4(:),G1H3(2),m3h2x3(:,18),heltab2x6(:,:,23))
  call Hloop_A_Q(ntryL,G1H3(2),47,0,G2H3(14),n2h3(18))
  call Hloop_VA_Q(ntryL,G1H6(19),ex4(:),G1H3(7),m3h2x3(:,19),heltab2x6(:,:,24))
  call Hloop_A_Q(ntryL,G1H3(7),47,0,G2H3(15),n2h3(19))
  call Hloop_VQ_A(ntryL,G1H6(20),ex1(:),G1H3(8),m3h2x3(:,20),heltab2x6(:,:,25))
  call Hloop_Q_A(ntryL,G1H3(8),47,nMT,G2H3(16),n2h3(20))
call HGT_OLR(G1H6(24),1,1,6)
call HGT_invQ_OLR(G1H6(24),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(24),-16,nMB,G2H6(6),n2h6(6))
  call Hloop_AW_Q(ntryL,G2H6(6),ex5(:),G2H2(13),m3h3x2(:,6),heltab2x6(:,:,26))
  call Hloop_VQ_A(ntryL,G1H6(5),ex1(:),G1H3(13),m3h2x3(:,21),heltab2x6(:,:,27))
  call Hloop_Q_A(ntryL,G1H3(13),47,nMT,G2H3(17),n2h3(21))
  call Hloop_VQ_A(ntryL,G1H6(9),ex1(:),G1H3(14),m3h2x3(:,22),heltab2x6(:,:,28))
  call Hloop_Q_A(ntryL,G1H3(14),47,nMT,G2H3(18),n2h3(22))
  call Hloop_AV_Q(ntryL,G1H12(11),wf4(:,1),G1H3(19),m3h4x3(:,1),heltab2x12(:,:,20))
  call Hloop_A_Q(ntryL,G1H3(19),47,0,G2H3(19),n2h3(23))
call HGT_OLR(G1H12(1),1,1,12)
call HGT_invQ_OLR(G1H12(1),2,5,12)
  call Hloop_Q_A(ntryL,G1H12(1),-16,0,G2H12(8),n2h12(20))
  call Hloop_QW_A(ntryL,G2H12(8),ex5(:),G2H4(1),m3h3x4(:,5),heltab2x12(:,:,21))
  call Hloop_AV_Q(ntryL,G1H12(4),wf4(:,1),G1H3(20),m3h4x3(:,2),heltab2x12(:,:,22))
  call Hloop_A_Q(ntryL,G1H3(20),47,0,G2H3(20),n2h3(24))
  call Hloop_AV_Q(ntryL,G1H12(5),wf4(:,1),G1H3(1),m3h4x3(:,3),heltab2x12(:,:,23))
  call Hloop_A_Q(ntryL,G1H3(1),47,0,G2H3(21),n2h3(25))
  call Hloop_VA_Q(ntryL,G1H6(15),ex4(:),G1H3(2),m3h2x3(:,23),heltab2x6(:,:,29))
  call Hloop_A_Q(ntryL,G1H3(2),47,0,G2H3(22),n2h3(26))
call HGT_OLR(G1H6(23),1,1,6)
call HGT_invQ_OLR(G1H6(23),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(23),-16,0,G2H6(6),n2h6(7))
  call Hloop_QW_A(ntryL,G2H6(6),ex5(:),G2H2(14),m3h3x2(:,7),heltab2x6(:,:,30))
  call Hloop_VA_Q(ntryL,G1H6(7),ex4(:),G1H3(7),m3h2x3(:,24),heltab2x6(:,:,31))
  call Hloop_A_Q(ntryL,G1H3(7),47,0,G2H3(23),n2h3(27))
  call Hloop_VA_Q(ntryL,G1H6(4),ex4(:),G1H3(8),m3h2x3(:,25),heltab2x6(:,:,32))
  call Hloop_A_Q(ntryL,G1H3(8),47,0,G2H3(24),n2h3(28))
  call Hloop_QW_A(ntryL,G1H12(6),ex5(:),G1H4(1),m3h3x4(:,6),heltab2x12(:,:,24))
  call Hloop_Q_A(ntryL,G1H4(1),51,nMB,G2H4(2),n2h4(9))
call HGT_OLR(G1H12(8),1,1,12)
call HGT_invQ_OLR(G1H12(8),2,5,12)
  call Hloop_A_Q(ntryL,G1H12(8),-12,nMB,G2H12(4),n2h12(21))
  call Hloop_AV_Q(ntryL,G2H12(4),wf4(:,2),G2H3(25),m3h4x3(:,4),heltab2x12(:,:,25))
  call Hloop_QW_A(ntryL,G1H12(12),ex5(:),G1H4(1),m3h3x4(:,7),heltab2x12(:,:,26))
  call Hloop_Q_A(ntryL,G1H4(1),51,nMB,G2H4(3),n2h4(10))
  call Hloop_QW_A(ntryL,G1H12(13),ex5(:),G1H4(1),m3h3x4(:,8),heltab2x12(:,:,27))
  call Hloop_Q_A(ntryL,G1H4(1),51,nMB,G2H4(4),n2h4(11))
  call Hloop_VQ_A(ntryL,G1H6(6),ex1(:),G1H3(13),m3h2x3(:,26),heltab2x6(:,:,33))
  call Hloop_Q_A(ntryL,G1H3(13),47,nMT,G2H3(26),n2h3(29))
call HGT_OLR(G1H6(10),1,1,6)
call HGT_invQ_OLR(G1H6(10),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(10),-16,nMB,G2H6(6),n2h6(8))
  call Hloop_AW_Q(ntryL,G2H6(6),ex5(:),G2H2(15),m3h3x2(:,8),heltab2x6(:,:,34))
  call Hloop_VQ_A(ntryL,G1H6(2),ex1(:),G1H3(14),m3h2x3(:,27),heltab2x6(:,:,35))
  call Hloop_Q_A(ntryL,G1H3(14),47,nMT,G2H3(27),n2h3(30))
  call Hloop_VQ_A(ntryL,G1H6(22),ex1(:),G1H3(19),m3h2x3(:,28),heltab2x6(:,:,36))
  call Hloop_Q_A(ntryL,G1H3(19),47,nMT,G2H3(28),n2h3(31))
  call Hloop_QV_A(ntryL,G1H12(14),wf4(:,2),G1H3(20),m3h4x3(:,5),heltab2x12(:,:,28))
  call Hloop_Q_A(ntryL,G1H3(20),47,nMT,G2H3(29),n2h3(32))
call HGT_OLR(G1H12(15),1,1,12)
call HGT_invQ_OLR(G1H12(15),2,5,12)
  call Hloop_A_Q(ntryL,G1H12(15),-16,nMB,G2H12(1),n2h12(22))
  call Hloop_AW_Q(ntryL,G2H12(1),ex5(:),G2H4(5),m3h3x4(:,9),heltab2x12(:,:,29))
  call Hloop_QV_A(ntryL,G1H12(18),wf4(:,2),G1H3(1),m3h4x3(:,6),heltab2x12(:,:,30))
  call Hloop_Q_A(ntryL,G1H3(1),47,nMT,G2H3(30),n2h3(33))
  call Hloop_QV_A(ntryL,G1H12(19),wf4(:,2),G1H3(2),m3h4x3(:,7),heltab2x12(:,:,31))
  call Hloop_Q_A(ntryL,G1H3(2),47,nMT,G2H3(31),n2h3(34))
call HGT_OLR(G2H2(1),1,1,2)
call HGT_invQ_OLR(G2H2(1),2,5,2)
call HGT_OLR(G2H2(1),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(1),[G2H2(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(2),[G1H3(6)])
call HGT_OLR(G2H2(2),1,1,2)
call HGT_invQ_OLR(G2H2(2),2,5,2)
call HGT_OLR(G2H2(2),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(2),[G2H2(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(4),[G1H3(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(6),[G1H3(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(8),[G1H3(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(1),[G1H3(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(3),[G1H3(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(13),[G1H3(11),G1H3(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(5),[G1H3(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(7),[G1H3(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(9),[G1H3(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(10),[G1H3(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(16),[G1H3(23),G1H3(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(11),[G1H3(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(12),[G1H3(22)])
  call Hotf_5pt_reduction(G2H2(1),RedSet_5(13),mass5set(:,1),  & 
G1H2(1),G1H2(2),G1H2(3),G1H2(4),G1H2(5),G1H2(6),2)
  call HG1shiftOLR(G1H2(2),8,2)
  call Hotf_5pt_reduction(G2H3(2),RedSet_5(14),mass5set(:,1),  & 
G1H3(7),G1H3(8),G1H3(13),G1H3(14),G1H3(19),G1H3(20),3)
  call HG1shiftOLR(G1H3(8),16,3)
  call Hotf_5pt_reduction(G2H2(2),RedSet_5(15),mass5set(:,1),  & 
G1H2(7),G1H2(8),G1H2(9),G1H2(10),G1H2(11),G1H2(12),2)
  call HG1shiftOLR(G1H2(8),8,2)
  call Hotf_5pt_reduction(G2H3(4),RedSet_5(16),mass5set(:,1),  & 
G1H3(1),G1H3(2),G1H3(6),G1H3(12),G1H3(18),G1H3(24),3)
  call HG1shiftOLR(G1H3(2),16,3)
call HGT_OLR(G2H2(3),1,1,2)
call HGT_invQ_OLR(G2H2(3),2,5,2)
call HGT_OLR(G2H2(3),6,15,2)
  call Hotf_5pt_reduction(G2H2(3),RedSet_5(17),mass5set(:,8),  & 
G1H2(13),G1H2(14),G1H2(15),G1H2(16),G1H2(17),G1H2(18),2)
  call HG1shiftOLR(G1H2(14),1,2)
  call Hotf_5pt_reduction(G2H3(6),RedSet_5(18),mass5set(:,4),  & 
G1H3(3),G1H3(4),G1H3(11),G1H3(5),G1H3(9),G1H3(10),3)
  call HG1shiftOLR(G1H3(4),16,3)
call HGT_OLR(G2H2(4),1,1,2)
call HGT_invQ_OLR(G2H2(4),2,5,2)
call HGT_OLR(G2H2(4),6,15,2)
  call Hotf_5pt_reduction(G2H2(4),RedSet_5(19),mass5set(:,8),  & 
G1H2(19),G1H2(20),G1H2(21),G1H2(22),G1H2(23),G1H2(24),2)
  call HG1shiftOLR(G1H2(20),1,2)
  call Hotf_5pt_reduction(G2H3(8),RedSet_5(20),mass5set(:,4),  & 
G1H3(15),G1H3(16),G1H3(23),G1H3(17),G1H3(21),G1H3(22),3)
  call HG1shiftOLR(G1H3(16),16,3)
  call Hotf_5pt_reduction(G2H3(1),RedSet_5(21),mass5set(:,9),  & 
G1H3(25),G1H3(26),G1H3(27),G1H3(28),G1H3(29),G1H3(30),3)
  call HG1shiftOLR(G1H3(26),16,3)
  call Hotf_5pt_reduction(G2H3(3),RedSet_5(22),mass5set(:,9),  & 
G1H3(31),G1H3(32),G1H3(33),G1H3(34),G1H3(35),G1H3(36),3)
  call HG1shiftOLR(G1H3(32),16,3)
  call Hotf_5pt_reduction(G2H3(13),RedSet_5(6),mass5set(:,3),  & 
G1H3(37),G1H3(38),G1H3(39),G1H3(40),G1H3(41),G1H3(42),3)
  call HG1shiftOLR(G1H3(38),16,3)
  call Hotf_5pt_reduction(G2H3(5),RedSet_5(23),mass5set(:,9),  & 
G1H3(43),G1H3(44),G1H3(45),G1H3(46),G1H3(47),G1H3(48),3)
  call HG1shiftOLR(G1H3(44),16,3)
  call Hotf_5pt_reduction(G2H3(7),RedSet_5(24),mass5set(:,9),  & 
G1H3(49),G1H3(50),G1H3(51),G1H3(52),G1H3(53),G1H3(54),3)
  call HG1shiftOLR(G1H3(50),16,3)
  call Hotf_5pt_reduction(G2H3(9),RedSet_5(25),mass5set(:,10),  & 
G1H3(55),G1H3(56),G1H3(57),G1H3(58),G1H3(59),G1H3(60),3)
  call HG1shiftOLR(G1H3(56),16,3)
  call Hotf_5pt_reduction(G2H3(10),RedSet_5(26),mass5set(:,4),  & 
G1H3(61),G1H3(62),G1H3(63),G1H3(64),G1H3(65),G1H3(66),3)
  call HG1shiftOLR(G1H3(62),16,3)
  call Hotf_5pt_reduction(G2H3(16),RedSet_5(7),mass5set(:,4),  & 
G1H3(67),G1H3(68),G1H3(69),G1H3(70),G1H3(71),G1H3(72),3)
  call HG1shiftOLR(G1H3(68),16,3)
  call Hotf_5pt_reduction(G2H3(11),RedSet_5(27),mass5set(:,10),  & 
G1H3(73),G1H3(74),G1H3(75),G1H3(76),G1H3(77),G1H3(78),3)
  call HG1shiftOLR(G1H3(74),16,3)
  call Hotf_5pt_reduction(G2H3(12),RedSet_5(28),mass5set(:,4),  & 
G1H3(79),G1H3(80),G1H3(81),G1H3(82),G1H3(83),G1H3(84),3)
  call HG1shiftOLR(G1H3(80),16,3)
  call Hotf_5pt_reduction(G2H6(2),RedSet_5(4),mass5set(:,2),  & 
G1H6(8),G1H6(12),G1H6(18),G1H6(19),G1H6(20),G1H6(24),6)
  call HG1shiftOLR(G1H6(12),17,6)
  call Hotf_5pt_reduction(G2H6(4),RedSet_5(3),mass5set(:,2),  & 
G1H6(5),G1H6(9),G1H6(15),G1H6(23),G1H6(7),G1H6(4),6)
  call HG1shiftOLR(G1H6(9),17,6)
  call Hotf_5pt_reduction(G2H6(1),RedSet_5(1),mass5set(:,1),  & 
G1H6(6),G1H6(10),G1H6(2),G1H6(22),G1H6(25),G1H6(26),6)
  call HG1shiftOLR(G1H6(10),24,6)
  call Hotf_5pt_reduction(G2H6(3),RedSet_5(2),mass5set(:,1),  & 
G1H6(27),G1H6(28),G1H6(29),G1H6(30),G1H6(31),G1H6(32),6)
  call HG1shiftOLR(G1H6(28),24,6)
  call Hotf_5pt_reduction(G2H2(7),RedSet_5(29),mass5set(:,8),  & 
G1H2(25),G1H2(26),G1H2(27),G1H2(28),G1H2(29),G1H2(30),2)
  call HG1shiftOLR(G1H2(26),2,2)
  call Hotf_5pt_reduction(G2H2(8),RedSet_5(30),mass5set(:,8),  & 
G1H2(31),G1H2(32),G1H2(33),G1H2(34),G1H2(35),G1H2(36),2)
  call HG1shiftOLR(G1H2(32),2,2)
  call Hotf_5pt_reduction(G2H2(9),RedSet_5(5),mass5set(:,3),  & 
G1H2(37),G1H2(38),G1H2(39),G1H2(40),G1H2(41),G1H2(42),2)
  call HG1shiftOLR(G1H2(38),4,2)
  call Hotf_4pt_reduction(G2H2(11),RedSet_4(50),mass4set(:,1),  & 
G1H2(43),G1H2(44),G1H2(45),G1H2(46),G1H2(47),2)
  call HG1shiftOLR(G1H2(44),12,2)
  call Hotf_4pt_reduction(G2H3(15),RedSet_4(11),mass4set(:,1),  & 
G1H3(85),G1H3(86),G1H3(87),G1H3(88),G1H3(89),3)
  call HG1shiftOLR(G1H3(86),24,3)
  call Hotf_4pt_reduction(G2H3(18),RedSet_4(36),mass4set(:,2),  & 
G1H3(90),G1H3(91),G1H3(92),G1H3(93),G1H3(94),3)
  call HG1shiftOLR(G1H3(91),17,3)
  call Hotf_5pt_reduction(G2H3(19),RedSet_5(8),mass5set(:,3),  & 
G1H3(95),G1H3(96),G1H3(97),G1H3(98),G1H3(99),G1H3(100),3)
  call HG1shiftOLR(G1H3(96),16,3)
  call Hotf_4pt_reduction(G2H3(21),RedSet_4(51),mass4set(:,1),  & 
G1H3(101),G1H3(102),G1H3(103),G1H3(104),G1H3(105),3)
  call HG1shiftOLR(G1H3(102),19,3)
  call Hotf_5pt_reduction(G2H3(22),RedSet_5(9),mass5set(:,3),  & 
G1H3(106),G1H3(107),G1H3(108),G1H3(109),G1H3(110),G1H3(111),3)
  call HG1shiftOLR(G1H3(107),16,3)
  call Hotf_4pt_reduction(G2H3(24),RedSet_4(52),mass4set(:,1),  & 
G1H3(112),G1H3(113),G1H3(114),G1H3(115),G1H3(116),3)
  call HG1shiftOLR(G1H3(113),24,3)
  call Hotf_5pt_reduction(G2H4(2),RedSet_5(10),mass5set(:,5),  & 
G1H4(1),G1H4(2),G1H4(3),G1H4(4),G1H4(5),G1H4(6),4)
  call HG1shiftOLR(G1H4(2),12,4)
  call Hotf_4pt_reduction(G2H4(4),RedSet_4(53),mass4set(:,3),  & 
G1H4(7),G1H4(8),G1H4(9),G1H4(10),G1H4(11),4)
  call HG1shiftOLR(G1H4(8),28,4)
  call Hotf_5pt_reduction(G2H3(26),RedSet_5(11),mass5set(:,6),  & 
G1H3(117),G1H3(118),G1H3(119),G1H3(120),G1H3(121),G1H3(122),3)
  call HG1shiftOLR(G1H3(118),16,3)
  call Hotf_4pt_reduction(G2H3(28),RedSet_4(54),mass4set(:,4),  & 
G1H3(123),G1H3(124),G1H3(125),G1H3(126),G1H3(127),3)
  call HG1shiftOLR(G1H3(124),17,3)
  call Hotf_5pt_reduction(G2H3(29),RedSet_5(12),mass5set(:,7),  & 
G1H3(128),G1H3(129),G1H3(130),G1H3(131),G1H3(132),G1H3(133),3)
  call HG1shiftOLR(G1H3(129),16,3)
  call Hotf_4pt_reduction(G2H3(31),RedSet_4(53),mass4set(:,3),  & 
G1H3(134),G1H3(135),G1H3(136),G1H3(137),G1H3(138),3)
  call HG1shiftOLR(G1H3(135),28,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(85),[G1H3(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(90),[G1H3(72)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(43),[G1H2(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(101),[G1H3(100)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(112),[G1H3(111)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(7),[G1H4(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(123),[G1H3(122)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(134),[G1H3(133)])
  call Hloop_VA_Q(ntryL,G1H2(1),ex4(:),G1H1(1),m3h2x1(:,1),heltab2x2(:,:,1))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(1),n2h1(9))
  call Hloop_VA_Q(ntryL,G1H2(2),ex4(:),G1H1(1),m3h2x1(:,2),heltab2x2(:,:,2))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(3),n2h1(10))
  call Hloop_VA_Q(ntryL,G1H2(6),ex4(:),G1H1(1),m3h2x1(:,3),heltab2x2(:,:,3))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(5),n2h1(11))
  call Hloop_AW_Q(ntryL,G1H3(7),ex5(:),G1H1(1),m3h3x1(:,9),heltab2x3(:,:,9))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(7),n2h1(12))
  call Hloop_AW_Q(ntryL,G1H3(8),ex5(:),G1H1(1),m3h3x1(:,10),heltab2x3(:,:,10))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(9),n2h1(13))
  call Hloop_AW_Q(ntryL,G1H3(20),ex5(:),G1H1(1),m3h3x1(:,11),heltab2x3(:,:,11))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(10),n2h1(14))
  call Hloop_VA_Q(ntryL,G1H2(7),ex4(:),G1H1(1),m3h2x1(:,4),heltab2x2(:,:,4))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(11),n2h1(15))
  call Hloop_VA_Q(ntryL,G1H2(8),ex4(:),G1H1(1),m3h2x1(:,5),heltab2x2(:,:,5))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(12),n2h1(16))
  call Hloop_VA_Q(ntryL,G1H2(12),ex4(:),G1H1(1),m3h2x1(:,6),heltab2x2(:,:,6))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(13),n2h1(17))
  call Hloop_AW_Q(ntryL,G1H3(1),ex5(:),G1H1(1),m3h3x1(:,12),heltab2x3(:,:,12))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(14),n2h1(18))
  call Hloop_AW_Q(ntryL,G1H3(2),ex5(:),G1H1(1),m3h3x1(:,13),heltab2x3(:,:,13))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(15),n2h1(19))
  call Hloop_AW_Q(ntryL,G1H3(24),ex5(:),G1H1(1),m3h3x1(:,14),heltab2x3(:,:,14))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(16),n2h1(20))
  call Hloop_VQ_A(ntryL,G1H2(13),ex1(:),G1H1(1),m3h2x1(:,7),heltab2x2(:,:,7))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(17),n2h1(21))
  call Hloop_VQ_A(ntryL,G1H2(14),ex1(:),G1H1(1),m3h2x1(:,8),heltab2x2(:,:,8))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),1,nMT,G2tensor(18),n2h1(22))
  call Hloop_VQ_A(ntryL,G1H2(18),ex1(:),G1H1(1),m3h2x1(:,9),heltab2x2(:,:,9))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(19),n2h1(23))
  call Hloop_QW_A(ntryL,G1H3(3),ex5(:),G1H1(1),m3h3x1(:,15),heltab2x3(:,:,15))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(20),n2h1(24))
  call Hloop_QW_A(ntryL,G1H3(4),ex5(:),G1H1(1),m3h3x1(:,16),heltab2x3(:,:,16))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(21),n2h1(25))
  call Hloop_QW_A(ntryL,G1H3(10),ex5(:),G1H1(1),m3h3x1(:,17),heltab2x3(:,:,17))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(22),n2h1(26))
  call Hloop_VQ_A(ntryL,G1H2(19),ex1(:),G1H1(1),m3h2x1(:,10),heltab2x2(:,:,10))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(23),n2h1(27))
  call Hloop_VQ_A(ntryL,G1H2(20),ex1(:),G1H1(1),m3h2x1(:,11),heltab2x2(:,:,11))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),1,nMT,G2tensor(24),n2h1(28))
  call Hloop_VQ_A(ntryL,G1H2(24),ex1(:),G1H1(1),m3h2x1(:,12),heltab2x2(:,:,12))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(25),n2h1(29))
  call Hloop_QW_A(ntryL,G1H3(15),ex5(:),G1H1(1),m3h3x1(:,18),heltab2x3(:,:,18))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(26),n2h1(30))
  call Hloop_QW_A(ntryL,G1H3(16),ex5(:),G1H1(1),m3h3x1(:,19),heltab2x3(:,:,19))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(27),n2h1(31))
  call Hloop_QW_A(ntryL,G1H3(22),ex5(:),G1H1(1),m3h3x1(:,20),heltab2x3(:,:,20))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(28),n2h1(32))
  call Hloop_AW_Q(ntryL,G1H3(25),ex5(:),G1H1(1),m3h3x1(:,21),heltab2x3(:,:,21))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(29),n2h1(33))
  call Hloop_AW_Q(ntryL,G1H3(26),ex5(:),G1H1(1),m3h3x1(:,22),heltab2x3(:,:,22))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(30),n2h1(34))
  call Hloop_AW_Q(ntryL,G1H3(30),ex5(:),G1H1(1),m3h3x1(:,23),heltab2x3(:,:,23))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(31),n2h1(35))
  call Hloop_AW_Q(ntryL,G1H3(31),ex5(:),G1H1(1),m3h3x1(:,24),heltab2x3(:,:,24))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(32),n2h1(36))
  call Hloop_AW_Q(ntryL,G1H3(32),ex5(:),G1H1(1),m3h3x1(:,25),heltab2x3(:,:,25))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(33),n2h1(37))
  call Hloop_AW_Q(ntryL,G1H3(36),ex5(:),G1H1(1),m3h3x1(:,26),heltab2x3(:,:,26))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(34),n2h1(38))
  call Hloop_AW_Q(ntryL,G1H3(37),ex5(:),G1H1(1),m3h3x1(:,27),heltab2x3(:,:,27))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(35),n2h1(39))
  call Hloop_AW_Q(ntryL,G1H3(38),ex5(:),G1H1(1),m3h3x1(:,28),heltab2x3(:,:,28))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(36),n2h1(40))
  call Hloop_AW_Q(ntryL,G1H3(85),ex5(:),G1H1(1),m3h3x1(:,29),heltab2x3(:,:,29))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(37),n2h1(41))
  call Hloop_AW_Q(ntryL,G1H3(43),ex5(:),G1H1(1),m3h3x1(:,30),heltab2x3(:,:,30))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(38),n2h1(42))
  call Hloop_AW_Q(ntryL,G1H3(44),ex5(:),G1H1(1),m3h3x1(:,31),heltab2x3(:,:,31))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(39),n2h1(43))
  call Hloop_AW_Q(ntryL,G1H3(48),ex5(:),G1H1(1),m3h3x1(:,32),heltab2x3(:,:,32))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(40),n2h1(44))
  call Hloop_AW_Q(ntryL,G1H3(49),ex5(:),G1H1(1),m3h3x1(:,33),heltab2x3(:,:,33))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(41),n2h1(45))
  call Hloop_AW_Q(ntryL,G1H3(50),ex5(:),G1H1(1),m3h3x1(:,34),heltab2x3(:,:,34))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(42),n2h1(46))
  call Hloop_AW_Q(ntryL,G1H3(54),ex5(:),G1H1(1),m3h3x1(:,35),heltab2x3(:,:,35))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(43),n2h1(47))
  call Hloop_QW_A(ntryL,G1H3(55),ex5(:),G1H1(1),m3h3x1(:,36),heltab2x3(:,:,36))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(44),n2h1(48))
  call Hloop_QW_A(ntryL,G1H3(56),ex5(:),G1H1(1),m3h3x1(:,37),heltab2x3(:,:,37))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(45),n2h1(49))
  call Hloop_QW_A(ntryL,G1H3(60),ex5(:),G1H1(1),m3h3x1(:,38),heltab2x3(:,:,38))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(46),n2h1(50))
  call Hloop_QW_A(ntryL,G1H3(61),ex5(:),G1H1(1),m3h3x1(:,39),heltab2x3(:,:,39))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(47),n2h1(51))
  call Hloop_QW_A(ntryL,G1H3(62),ex5(:),G1H1(1),m3h3x1(:,40),heltab2x3(:,:,40))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(48),n2h1(52))
  call Hloop_QW_A(ntryL,G1H3(66),ex5(:),G1H1(1),m3h3x1(:,41),heltab2x3(:,:,41))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(49),n2h1(53))
  call Hloop_QW_A(ntryL,G1H3(67),ex5(:),G1H1(1),m3h3x1(:,42),heltab2x3(:,:,42))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(50),n2h1(54))
  call Hloop_QW_A(ntryL,G1H3(68),ex5(:),G1H1(1),m3h3x1(:,43),heltab2x3(:,:,43))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(51),n2h1(55))
  call Hloop_QW_A(ntryL,G1H3(90),ex5(:),G1H1(1),m3h3x1(:,44),heltab2x3(:,:,44))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(52),n2h1(56))
  call Hloop_QW_A(ntryL,G1H3(73),ex5(:),G1H1(1),m3h3x1(:,45),heltab2x3(:,:,45))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(53),n2h1(57))
  call Hloop_QW_A(ntryL,G1H3(74),ex5(:),G1H1(1),m3h3x1(:,46),heltab2x3(:,:,46))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(54),n2h1(58))
  call Hloop_QW_A(ntryL,G1H3(78),ex5(:),G1H1(1),m3h3x1(:,47),heltab2x3(:,:,47))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(55),n2h1(59))
  call Hloop_QW_A(ntryL,G1H3(79),ex5(:),G1H1(1),m3h3x1(:,48),heltab2x3(:,:,48))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(56),n2h1(60))
  call Hloop_QW_A(ntryL,G1H3(80),ex5(:),G1H1(1),m3h3x1(:,49),heltab2x3(:,:,49))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(57),n2h1(61))
  call Hloop_QW_A(ntryL,G1H3(84),ex5(:),G1H1(1),m3h3x1(:,50),heltab2x3(:,:,50))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(58),n2h1(62))
  call Hloop_VQ_A(ntryL,G1H6(8),wf6(:,7),G1H1(1),m3h6x1(:,1),heltab2x6(:,:,37))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(59),n2h1(63))
  call Hloop_VQ_A(ntryL,G1H6(12),wf6(:,7),G1H1(1),m3h6x1(:,2),heltab2x6(:,:,38))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),17,nMB,G2tensor(60),n2h1(64))
  call Hloop_VQ_A(ntryL,G1H6(24),wf6(:,7),G1H1(1),m3h6x1(:,3),heltab2x6(:,:,39))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(61),n2h1(65))
  call Hloop_VQ_A(ntryL,G1H6(5),wf6(:,7),G1H1(1),m3h6x1(:,4),heltab2x6(:,:,40))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(62),n2h1(66))
  call Hloop_VQ_A(ntryL,G1H6(9),wf6(:,7),G1H1(1),m3h6x1(:,5),heltab2x6(:,:,41))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),17,nMB,G2tensor(63),n2h1(67))
  call Hloop_VQ_A(ntryL,G1H6(4),wf6(:,7),G1H1(1),m3h6x1(:,6),heltab2x6(:,:,42))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(64),n2h1(68))
  call Hloop_VA_Q(ntryL,G1H6(6),wf6(:,4),G1H1(1),m3h6x1(:,7),heltab2x6(:,:,43))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(65),n2h1(69))
  call Hloop_VA_Q(ntryL,G1H6(10),wf6(:,4),G1H1(1),m3h6x1(:,8),heltab2x6(:,:,44))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),24,0,G2tensor(66),n2h1(70))
  call Hloop_VA_Q(ntryL,G1H6(26),wf6(:,4),G1H1(1),m3h6x1(:,9),heltab2x6(:,:,45))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(67),n2h1(71))
  call Hloop_VA_Q(ntryL,G1H6(27),wf6(:,4),G1H1(1),m3h6x1(:,10),heltab2x6(:,:,46))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(68),n2h1(72))
  call Hloop_VA_Q(ntryL,G1H6(28),wf6(:,4),G1H1(1),m3h6x1(:,11),heltab2x6(:,:,47))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),24,0,G2tensor(69),n2h1(73))
  call Hloop_VA_Q(ntryL,G1H6(32),wf6(:,4),G1H1(1),m3h6x1(:,12),heltab2x6(:,:,48))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(70),n2h1(74))
  call Hloop_VA_Q(ntryL,G1H2(25),ex2(:),G1H1(1),m3h2x1(:,13),heltab2x2(:,:,13))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(71),n2h1(75))
  call Hloop_VA_Q(ntryL,G1H2(26),ex2(:),G1H1(1),m3h2x1(:,14),heltab2x2(:,:,14))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMT,G2tensor(72),n2h1(76))
  call Hloop_VA_Q(ntryL,G1H2(30),ex2(:),G1H1(1),m3h2x1(:,15),heltab2x2(:,:,15))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(73),n2h1(77))
  call Hloop_VA_Q(ntryL,G1H2(31),ex2(:),G1H1(1),m3h2x1(:,16),heltab2x2(:,:,16))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(74),n2h1(78))
  call Hloop_VA_Q(ntryL,G1H2(32),ex2(:),G1H1(1),m3h2x1(:,17),heltab2x2(:,:,17))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMT,G2tensor(75),n2h1(79))
  call Hloop_VA_Q(ntryL,G1H2(36),ex2(:),G1H1(1),m3h2x1(:,18),heltab2x2(:,:,18))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(76),n2h1(80))
  call Hloop_VQ_A(ntryL,G1H2(37),ex3(:),G1H1(1),m3h2x1(:,19),heltab2x2(:,:,19))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(77),n2h1(81))
  call Hloop_VQ_A(ntryL,G1H2(38),ex3(:),G1H1(1),m3h2x1(:,20),heltab2x2(:,:,20))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(78),n2h1(82))
  call Hloop_VQ_A(ntryL,G1H2(43),ex3(:),G1H1(1),m3h2x1(:,21),heltab2x2(:,:,21))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(79),n2h1(83))
  call Hloop_VQ_A(ntryL,G1H2(44),ex3(:),G1H1(1),m3h2x1(:,22),heltab2x2(:,:,22))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(80),n2h1(84))
  call Hloop_AW_Q(ntryL,G1H3(86),ex5(:),G1H1(1),m3h3x1(:,51),heltab2x3(:,:,51))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),24,0,G2tensor(81),n2h1(85))
  call Hloop_QW_A(ntryL,G1H3(91),ex5(:),G1H1(1),m3h3x1(:,52),heltab2x3(:,:,52))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),17,nMB,G2tensor(82),n2h1(86))
  call Hloop_AW_Q(ntryL,G1H3(95),ex5(:),G1H1(1),m3h3x1(:,53),heltab2x3(:,:,53))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(83),n2h1(87))
  call Hloop_AW_Q(ntryL,G1H3(96),ex5(:),G1H1(1),m3h3x1(:,54),heltab2x3(:,:,54))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(84),n2h1(88))
  call Hloop_AW_Q(ntryL,G1H3(101),ex5(:),G1H1(1),m3h3x1(:,55),heltab2x3(:,:,55))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(85),n2h1(89))
  call Hloop_AW_Q(ntryL,G1H3(102),ex5(:),G1H1(1),m3h3x1(:,56),heltab2x3(:,:,56))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),19,0,G2tensor(86),n2h1(90))
  call Hloop_AW_Q(ntryL,G1H3(106),ex5(:),G1H1(1),m3h3x1(:,57),heltab2x3(:,:,57))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(87),n2h1(91))
  call Hloop_AW_Q(ntryL,G1H3(107),ex5(:),G1H1(1),m3h3x1(:,58),heltab2x3(:,:,58))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(88),n2h1(92))
  call Hloop_AW_Q(ntryL,G1H3(112),ex5(:),G1H1(1),m3h3x1(:,59),heltab2x3(:,:,59))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(89),n2h1(93))
  call Hloop_AW_Q(ntryL,G1H3(113),ex5(:),G1H1(1),m3h3x1(:,60),heltab2x3(:,:,60))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),24,0,G2tensor(90),n2h1(94))
  call Hloop_QV_A(ntryL,G1H4(1),wf4(:,2),G1H1(1),m3h4x1(:,1),heltab2x4(:,:,8))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(91),n2h1(95))
  call Hloop_QV_A(ntryL,G1H4(2),wf4(:,2),G1H1(1),m3h4x1(:,2),heltab2x4(:,:,9))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,nMB,G2tensor(92),n2h1(96))
  call Hloop_QV_A(ntryL,G1H4(7),wf4(:,2),G1H1(1),m3h4x1(:,3),heltab2x4(:,:,10))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(93),n2h1(97))
  call Hloop_QV_A(ntryL,G1H4(8),wf4(:,2),G1H1(1),m3h4x1(:,4),heltab2x4(:,:,11))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),28,nMB,G2tensor(94),n2h1(98))
  call Hloop_QW_A(ntryL,G1H3(117),ex5(:),G1H1(1),m3h3x1(:,61),heltab2x3(:,:,61))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(95),n2h1(99))
  call Hloop_QW_A(ntryL,G1H3(118),ex5(:),G1H1(1),m3h3x1(:,62),heltab2x3(:,:,62))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(96),n2h1(100))
  call Hloop_QW_A(ntryL,G1H3(123),ex5(:),G1H1(1),m3h3x1(:,63),heltab2x3(:,:,63))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(97),n2h1(101))
  call Hloop_QW_A(ntryL,G1H3(124),ex5(:),G1H1(1),m3h3x1(:,64),heltab2x3(:,:,64))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),17,nMB,G2tensor(98),n2h1(102))
  call Hloop_QW_A(ntryL,G1H3(128),ex5(:),G1H1(1),m3h3x1(:,65),heltab2x3(:,:,65))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(99),n2h1(103))
  call Hloop_QW_A(ntryL,G1H3(129),ex5(:),G1H1(1),m3h3x1(:,66),heltab2x3(:,:,66))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(100),n2h1(104))
  call Hloop_QW_A(ntryL,G1H3(134),ex5(:),G1H1(1),m3h3x1(:,67),heltab2x3(:,:,67))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(101),n2h1(105))
  call Hloop_QW_A(ntryL,G1H3(135),ex5(:),G1H1(1),m3h3x1(:,68),heltab2x3(:,:,68))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),28,nMB,G2tensor(102),n2h1(106))
  call ol_merge_tensors(G2tensor(1),[G2tensor(2),G1tensor(2)])
  call ol_merge_tensors(G2tensor(11),[G2tensor(4),G1tensor(8)])
  call ol_merge_tensors(G2tensor(17),[G2tensor(6),G1tensor(14)])
  call ol_merge_tensors(G2tensor(23),[G2tensor(8),G1tensor(20)])
  call ol_merge_tensors(G2tensor(29),[G1tensor(3)])
  call ol_merge_tensors(G2tensor(32),[G1tensor(4)])
  call ol_merge_tensors(G2tensor(35),[G1tensor(11),G1tensor(5)])
  call ol_merge_tensors(G2tensor(7),[G1tensor(6)])
  call ol_merge_tensors(G2tensor(38),[G1tensor(9)])
  call ol_merge_tensors(G2tensor(41),[G1tensor(10)])
  call ol_merge_tensors(G2tensor(14),[G1tensor(12)])
  call ol_merge_tensors(G2tensor(44),[G1tensor(15)])
  call ol_merge_tensors(G2tensor(47),[G1tensor(16)])
  call ol_merge_tensors(G2tensor(50),[G1tensor(23),G1tensor(17)])
  call ol_merge_tensors(G2tensor(20),[G1tensor(18)])
  call ol_merge_tensors(G2tensor(53),[G1tensor(21)])
  call ol_merge_tensors(G2tensor(56),[G1tensor(22)])
  call ol_merge_tensors(G2tensor(26),[G1tensor(24)])
  call Hotf_5pt_reduction_last(G2tensor(1),RedSet_5(13),mass5set(:,1),  & 
G1tensor(1),G1tensor(7),G1tensor(13),G1tensor(19),G1tensor(2),G1tensor(8))
  call G_TensorShift(G1tensor(7),8)
  call Hotf_5pt_reduction_last(G2tensor(11),RedSet_5(15),mass5set(:,1),  & 
G1tensor(14),G1tensor(20),G1tensor(3),G1tensor(4),G1tensor(11),G1tensor(5))
  call G_TensorShift(G1tensor(20),8)
  call Hotf_5pt_reduction_last(G2tensor(17),RedSet_5(17),mass5set(:,8),  & 
G1tensor(6),G1tensor(9),G1tensor(10),G1tensor(12),G1tensor(15),G1tensor(16))
  call G_TensorShift(G1tensor(9),1)
  call Hotf_5pt_reduction_last(G2tensor(23),RedSet_5(19),mass5set(:,8),  & 
G1tensor(23),G1tensor(17),G1tensor(18),G1tensor(21),G1tensor(22),G1tensor(24))
  call G_TensorShift(G1tensor(17),1)
  call Hotf_5pt_reduction_last(G2tensor(29),RedSet_5(21),mass5set(:,9),  & 
G1tensor(25),G1tensor(26),G1tensor(27),G1tensor(28),G1tensor(29),G1tensor(30))
  call G_TensorShift(G1tensor(26),16)
  call Hotf_5pt_reduction_last(G2tensor(32),RedSet_5(22),mass5set(:,9),  & 
G1tensor(31),G1tensor(32),G1tensor(33),G1tensor(34),G1tensor(35),G1tensor(36))
  call G_TensorShift(G1tensor(32),16)
  call Hotf_5pt_reduction_last(G2tensor(35),RedSet_5(6),mass5set(:,3),  & 
G1tensor(37),G1tensor(38),G1tensor(39),G1tensor(40),G1tensor(41),G1tensor(42))
  call G_TensorShift(G1tensor(38),16)
  call Hotf_5pt_reduction_last(G2tensor(7),RedSet_5(14),mass5set(:,1),  & 
G1tensor(43),G1tensor(44),G1tensor(45),G1tensor(46),G1tensor(47),G1tensor(48))
  call G_TensorShift(G1tensor(44),16)
  call Hotf_5pt_reduction_last(G2tensor(38),RedSet_5(23),mass5set(:,9),  & 
G1tensor(49),G1tensor(50),G1tensor(51),G1tensor(52),G1tensor(53),G1tensor(54))
  call G_TensorShift(G1tensor(50),16)
  call Hotf_5pt_reduction_last(G2tensor(41),RedSet_5(24),mass5set(:,9),  & 
G1tensor(55),G1tensor(56),G1tensor(57),G1tensor(58),G1tensor(59),G1tensor(60))
  call G_TensorShift(G1tensor(56),16)
  call Hotf_5pt_reduction_last(G2tensor(14),RedSet_5(16),mass5set(:,1),  & 
G1tensor(61),G1tensor(62),G1tensor(63),G1tensor(64),G1tensor(65),G1tensor(66))
  call G_TensorShift(G1tensor(62),16)
  call Hotf_5pt_reduction_last(G2tensor(44),RedSet_5(25),mass5set(:,10),  & 
G1tensor(67),G1tensor(68),G1tensor(69),G1tensor(70),G1tensor(71),G1tensor(72))
  call G_TensorShift(G1tensor(68),16)
  call Hotf_5pt_reduction_last(G2tensor(47),RedSet_5(26),mass5set(:,4),  & 
G1tensor(73),G1tensor(74),G1tensor(75),G1tensor(76),G1tensor(77),G1tensor(78))
  call G_TensorShift(G1tensor(74),16)
  call Hotf_5pt_reduction_last(G2tensor(50),RedSet_5(7),mass5set(:,4),  & 
G1tensor(79),G1tensor(80),G1tensor(81),G1tensor(82),G1tensor(83),G1tensor(84))
  call G_TensorShift(G1tensor(80),16)
  call Hotf_5pt_reduction_last(G2tensor(20),RedSet_5(18),mass5set(:,4),  & 
G1tensor(85),G1tensor(86),G1tensor(87),G1tensor(88),G1tensor(89),G1tensor(90))
  call G_TensorShift(G1tensor(86),16)
  call Hotf_5pt_reduction_last(G2tensor(53),RedSet_5(27),mass5set(:,10),  & 
G1tensor(91),G1tensor(92),G1tensor(93),G1tensor(94),G1tensor(95),G1tensor(96))
  call G_TensorShift(G1tensor(92),16)
  call Hotf_5pt_reduction_last(G2tensor(56),RedSet_5(28),mass5set(:,4),  & 
G1tensor(97),G1tensor(98),G1tensor(99),G1tensor(100),G1tensor(101),G1tensor(102))
  call G_TensorShift(G1tensor(98),16)
  call Hotf_5pt_reduction_last(G2tensor(26),RedSet_5(20),mass5set(:,4),  & 
G1tensor(103),G1tensor(104),G1tensor(105),G1tensor(106),G1tensor(107),G1tensor(108))
  call G_TensorShift(G1tensor(104),16)
  call Hotf_5pt_reduction_last(G2tensor(59),RedSet_5(4),mass5set(:,2),  & 
G1tensor(109),G1tensor(110),G1tensor(111),G1tensor(112),G1tensor(113),G1tensor(114))
  call G_TensorShift(G1tensor(110),17)
  call Hotf_5pt_reduction_last(G2tensor(62),RedSet_5(3),mass5set(:,2),  & 
G1tensor(115),G1tensor(116),G1tensor(117),G1tensor(118),G1tensor(119),G1tensor(120))
  call G_TensorShift(G1tensor(116),17)
  call Hotf_5pt_reduction_last(G2tensor(65),RedSet_5(1),mass5set(:,1),  & 
G1tensor(121),G1tensor(122),G1tensor(123),G1tensor(124),G1tensor(125),G1tensor(126))
  call G_TensorShift(G1tensor(122),24)
  call Hotf_5pt_reduction_last(G2tensor(68),RedSet_5(2),mass5set(:,1),  & 
G1tensor(127),G1tensor(128),G1tensor(129),G1tensor(130),G1tensor(131),G1tensor(132))
  call G_TensorShift(G1tensor(128),24)
  call Hotf_5pt_reduction_last(G2tensor(71),RedSet_5(29),mass5set(:,8),  & 
G1tensor(133),G1tensor(134),G1tensor(135),G1tensor(136),G1tensor(137),G1tensor(138))
  call G_TensorShift(G1tensor(134),2)
  call Hotf_5pt_reduction_last(G2tensor(74),RedSet_5(30),mass5set(:,8),  & 
G1tensor(139),G1tensor(140),G1tensor(141),G1tensor(142),G1tensor(143),G1tensor(144))
  call G_TensorShift(G1tensor(140),2)
  call Hotf_5pt_reduction_last(G2tensor(77),RedSet_5(5),mass5set(:,3),  & 
G1tensor(145),G1tensor(146),G1tensor(147),G1tensor(148),G1tensor(149),G1tensor(150))
  call G_TensorShift(G1tensor(146),4)
  call Hotf_5pt_reduction_last(G2tensor(83),RedSet_5(8),mass5set(:,3),  & 
G1tensor(151),G1tensor(152),G1tensor(153),G1tensor(154),G1tensor(155),G1tensor(156))
  call G_TensorShift(G1tensor(152),16)
  call Hotf_5pt_reduction_last(G2tensor(87),RedSet_5(9),mass5set(:,3),  & 
G1tensor(157),G1tensor(158),G1tensor(159),G1tensor(160),G1tensor(161),G1tensor(162))
  call G_TensorShift(G1tensor(158),16)
  call Hotf_5pt_reduction_last(G2tensor(91),RedSet_5(10),mass5set(:,5),  & 
G1tensor(163),G1tensor(164),G1tensor(165),G1tensor(166),G1tensor(167),G1tensor(168))
  call G_TensorShift(G1tensor(164),12)
  call Hotf_5pt_reduction_last(G2tensor(95),RedSet_5(11),mass5set(:,6),  & 
G1tensor(169),G1tensor(170),G1tensor(171),G1tensor(172),G1tensor(173),G1tensor(174))
  call G_TensorShift(G1tensor(170),16)
  call Hotf_5pt_reduction_last(G2tensor(99),RedSet_5(12),mass5set(:,7),  & 
G1tensor(175),G1tensor(176),G1tensor(177),G1tensor(178),G1tensor(179),G1tensor(180))
  call G_TensorShift(G1tensor(176),16)
  call ol_merge_tensors(T1sum(5),[G1tensor(1)])
  call ol_merge_tensors(T1sum(6),[G1tensor(14)])
  call ol_merge_tensors(T1sum(7),[G1tensor(6)])
  call ol_merge_tensors(T1sum(8),[G1tensor(23)])
  call ol_merge_tensors(T1sum(9),[G1tensor(25)])
  call ol_merge_tensors(T1sum(10),[G1tensor(31)])
  call ol_merge_tensors(T1sum(11),[G1tensor(37)])
  call ol_merge_tensors(T1sum(12),[G1tensor(43)])
  call ol_merge_tensors(T1sum(13),[G1tensor(49)])
  call ol_merge_tensors(T1sum(14),[G1tensor(55)])
  call ol_merge_tensors(T1sum(15),[G1tensor(61)])
  call ol_merge_tensors(T1sum(16),[G1tensor(67)])
  call ol_merge_tensors(T1sum(17),[G1tensor(73)])
  call ol_merge_tensors(T1sum(18),[G1tensor(79)])
  call ol_merge_tensors(T1sum(19),[G1tensor(85)])
  call ol_merge_tensors(T1sum(20),[G1tensor(91)])
  call ol_merge_tensors(T1sum(21),[G1tensor(97)])
  call ol_merge_tensors(T1sum(22),[G1tensor(103)])
  call ol_merge_tensors(T1sum(23),[G1tensor(109)])
  call ol_merge_tensors(T1sum(24),[G1tensor(115)])
  call ol_merge_tensors(T1sum(25),[G1tensor(121)])
  call ol_merge_tensors(T1sum(26),[G1tensor(127)])
  call ol_merge_tensors(T1sum(27),[G1tensor(133)])
  call ol_merge_tensors(T1sum(28),[G1tensor(139)])
  call ol_merge_tensors(T1sum(29),[G1tensor(145)])
  call ol_merge_tensors(T1sum(30),[G1tensor(151)])
  call ol_merge_tensors(T1sum(31),[G1tensor(157)])
  call ol_merge_tensors(T1sum(32),[G1tensor(163)])
  call ol_merge_tensors(T1sum(33),[G1tensor(169)])
  call ol_merge_tensors(T1sum(34),[G1tensor(175)])
  Gcoeff(:)%j = (-(c(73)*M(1,:)%j)+c(72)*M(2,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(31),h0tab(:,31),[32,12,3,16],[0,0,0,0],4,2,wf4(:,2),wf4(:,1))
  call Hloop_QW_A(ntryL,G0H144(1),ex6(:),G0H48(1),m3h3x48(:,17),heltab2x144(:,:,31))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(1),n2h48(17))
  Gcoeff(:)%j = (-(c(71)*M(1,:)%j)+c(70)*M(2,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(32),h0tab(:,32),[32,12,3,16],[nMT,nMT,nMT,nMB],4,2,wf4(:,2),wf4(:,1))
  call Hloop_QW_A(ntryL,G0H144(1),ex6(:),G0H48(1),m3h3x48(:,18),heltab2x144(:,:,32))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(2),n2h48(18))
  Gcoeff(:)%j = (-(c(73)*M(1,:)%j)+c(72)*M(2,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(33),h0tab(:,33),[32,12,3,16],[0,0,0,0],4,2,wf4(:,2),wf4(:,1))
  call Hloop_AW_Q(ntryL,G0H144(1),ex6(:),G0H48(1),m3h3x48(:,19),heltab2x144(:,:,33))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(3),n2h48(19))
  Gcoeff(:)%j = (-(c(71)*M(1,:)%j)+c(70)*M(2,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(34),h0tab(:,34),[32,12,3,16],[nMB,nMB,nMB,nMT],4,2,wf4(:,2),wf4(:,1))
  call Hloop_AW_Q(ntryL,G0H144(1),ex6(:),G0H48(1),m3h3x48(:,20),heltab2x144(:,:,34))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMB,G1H48(4),n2h48(20))
  Gcoeff(:)%j = (-(c(73)*M(1,:)%j)+c(72)*M(2,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(35),h0tab(:,35),[32,3,12,16],[0,0,0,0],4,2,wf4(:,1),wf4(:,2))
  call Hloop_QW_A(ntryL,G0H144(1),ex6(:),G0H48(1),m3h3x48(:,21),heltab2x144(:,:,35))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(5),n2h48(21))
  Gcoeff(:)%j = (-(c(71)*M(1,:)%j)+c(70)*M(2,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(36),h0tab(:,36),[32,3,12,16],[nMT,nMT,nMT,nMB],4,2,wf4(:,1),wf4(:,2))
  call Hloop_QW_A(ntryL,G0H144(1),ex6(:),G0H48(1),m3h3x48(:,22),heltab2x144(:,:,36))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(6),n2h48(22))
  Gcoeff(:)%j = (-(c(73)*M(1,:)%j)+c(72)*M(2,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(37),h0tab(:,37),[32,3,12,16],[0,0,0,0],4,2,wf4(:,1),wf4(:,2))
  call Hloop_AW_Q(ntryL,G0H144(1),ex6(:),G0H48(1),m3h3x48(:,23),heltab2x144(:,:,37))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(7),n2h48(23))
  Gcoeff(:)%j = (-(c(71)*M(1,:)%j)+c(70)*M(2,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(38),h0tab(:,38),[32,3,12,16],[nMB,nMB,nMB,nMT],4,2,wf4(:,1),wf4(:,2))
  call Hloop_AW_Q(ntryL,G0H144(1),ex6(:),G0H48(1),m3h3x48(:,24),heltab2x144(:,:,38))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMB,G1H48(8),n2h48(24))
  Gcoeff(:)%j = (-(c(73)*M(1,:)%j)+c(72)*M(2,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(39),h0tab(:,39),[32,3,16,12],[0,0,0,0],4,2,wf4(:,1),wf4(:,2))
  call Hloop_QW_A(ntryL,G0H144(1),ex6(:),G0H48(1),m3h3x48(:,25),heltab2x144(:,:,39))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(9),n2h48(25))
  Gcoeff(:)%j = (-(c(71)*M(1,:)%j)+c(70)*M(2,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(40),h0tab(:,40),[32,3,16,12],[nMT,nMT,nMB,nMB],4,2,wf4(:,1),wf4(:,2))
  call Hloop_QW_A(ntryL,G0H144(1),ex6(:),G0H48(1),m3h3x48(:,26),heltab2x144(:,:,40))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(10),n2h48(26))
  Gcoeff(:)%j = (-(c(73)*M(1,:)%j)+c(72)*M(2,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(41),h0tab(:,41),[32,3,16,12],[0,0,0,0],4,2,wf4(:,1),wf4(:,2))
  call Hloop_AW_Q(ntryL,G0H144(1),ex6(:),G0H48(1),m3h3x48(:,27),heltab2x144(:,:,41))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(11),n2h48(27))
  Gcoeff(:)%j = (-(c(71)*M(1,:)%j)+c(70)*M(2,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(42),h0tab(:,42),[32,3,16,12],[nMB,nMB,nMT,nMT],4,2,wf4(:,1),wf4(:,2))
  call Hloop_AW_Q(ntryL,G0H144(1),ex6(:),G0H48(1),m3h3x48(:,28),heltab2x144(:,:,42))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMB,G1H48(12),n2h48(28))
  Gcoeff(:)%j = (c(26)*M(1,:)%j-c(25)*M(2,:)%j) * den(75)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(43),h0tab(:,43),[32,4,3,24],[0,0,0,0],4,2,wf4(:,1),wf6(:,4))
  call Hloop_AW_Q(ntryL,G0H144(1),ex6(:),G0H48(1),m3h3x48(:,29),heltab2x144(:,:,43))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(13),n2h48(29))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j)+c(29)*M(2,:)%j) * den(75)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(44),h0tab(:,44),[32,3,24,4],[0,0,0,0],4,2,wf4(:,1),wf6(:,4))
  call Hloop_QW_A(ntryL,G0H144(1),ex6(:),G0H48(1),m3h3x48(:,30),heltab2x144(:,:,44))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(14),n2h48(30))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j)+c(29)*M(2,:)%j) * den(75)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(45),h0tab(:,45),[32,3,4,24],[0,0,0,0],4,2,wf4(:,1),wf6(:,4))
  call Hloop_AW_Q(ntryL,G0H144(1),ex6(:),G0H48(1),m3h3x48(:,31),heltab2x144(:,:,45))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(15),n2h48(31))
  Gcoeff(:)%j = (c(26)*M(1,:)%j-c(25)*M(2,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(46),h0tab(:,46),[36,3,8,16],[0,0,0,0],4,2,wf6(:,3),wf4(:,1))
  call Hloop_AQ_V(ntryL,G0H144(1),wf6(:,3),G0H24(1),m3h6x24(:,5),heltab2x144(:,:,46))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j)+c(29)*M(2,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(47),h0tab(:,47),[36,3,16,8],[0,0,0,0],4,2,wf6(:,3),wf4(:,1))
  call Hloop_VQ_A(ntryL,G0H144(1),wf6(:,3),G0H24(2),m3h6x24(:,6),heltab2x144(:,:,47))
  call Hloop_Q_A(ntryL,G0H24(2),36,0,G1H24(1),n2h24(1))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j)+c(29)*M(2,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(48),h0tab(:,48),[36,8,3,16],[0,0,0,0],4,2,wf6(:,3),wf4(:,1))
  call Hloop_AQ_V(ntryL,G0H144(1),wf6(:,3),G0H24(3),m3h6x24(:,7),heltab2x144(:,:,48))
  Gcoeff(:)%j = (c(8)*M(1,:)%j-c(7)*M(2,:)%j) * den(153)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(49),h0tab(:,49),[48,3,4,8],[0,0,0,0],4,2,wf9(:,1),wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H144(1),wf9(:,1),G0H16(1),m3h9x16(:,11),heltab2x144(:,:,49))
  call Hloop_A_Q(ntryL,G0H16(1),48,0,G1H16(1),n2h16(11))
  Gcoeff(:)%j = (-(c(56)*M(1,:)%j)+c(55)*M(2,:)%j) * den(154)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(50),h0tab(:,50),[48,3,4,8],[0,0,0,0],4,2,wf9(:,2),wf4(:,1))
  call Hloop_AZ_Q(ntryL,G0H144(1),wf9(:,2),G0H16(1),ngZd,m3h9x16(:,12),heltab2x144(:,:,50))
  call Hloop_A_Q(ntryL,G0H16(1),48,0,G1H16(3),n2h16(12))
  Gcoeff(:)%j = (c(8)*M(1,:)%j-c(7)*M(2,:)%j) * den(153)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(51),h0tab(:,51),[48,3,8,4],[0,0,0,0],4,2,wf9(:,1),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H144(1),wf9(:,1),G0H16(1),m3h9x16(:,13),heltab2x144(:,:,51))
  call Hloop_Q_A(ntryL,G0H16(1),48,0,G1H16(6),n2h16(13))
  Gcoeff(:)%j = (-(c(56)*M(1,:)%j)+c(55)*M(2,:)%j) * den(154)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(52),h0tab(:,52),[48,3,8,4],[0,0,0,0],4,2,wf9(:,2),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H144(1),wf9(:,2),G0H16(1),ngZd,m3h9x16(:,14),heltab2x144(:,:,52))
  call Hloop_Q_A(ntryL,G0H16(1),48,0,G1H16(5),n2h16(14))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)+c(1)*M(2,:)%j) * den(153)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(53),h0tab(:,53),[48,4,3,8],[0,0,0,0],4,2,wf9(:,1),wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H144(1),wf9(:,1),G0H16(1),m3h9x16(:,15),heltab2x144(:,:,53))
  call Hloop_A_Q(ntryL,G0H16(1),48,0,G1H16(9),n2h16(15))
  Gcoeff(:)%j = (c(52)*M(1,:)%j-c(51)*M(2,:)%j) * den(154)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(54),h0tab(:,54),[48,4,3,8],[0,0,0,0],4,2,wf9(:,2),wf4(:,1))
  call Hloop_AZ_Q(ntryL,G0H144(1),wf9(:,2),G0H16(1),ngZd,m3h9x16(:,16),heltab2x144(:,:,54))
  call Hloop_A_Q(ntryL,G0H16(1),48,0,G1H16(8),n2h16(16))
  Gcoeff(:)%j = (c(36)*M(1,:)%j-c(32)*M(2,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(55),h0tab(:,55),[32,7,8,16],[0,0,0,0],4,1,wf8(:,2))
  call Hloop_AW_Q(ntryL,G0H144(1),ex6(:),G0H48(1),m3h3x48(:,32),heltab2x144(:,:,55))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(16),n2h48(32))
  Gcoeff(:)%j = (c(36)*M(1,:)%j-c(32)*M(2,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(56),h0tab(:,56),[32,4,11,16],[0,0,0,0],4,1,wf8(:,4))
  call Hloop_AW_Q(ntryL,G0H144(1),ex6(:),G0H48(1),m3h3x48(:,33),heltab2x144(:,:,56))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(17),n2h48(33))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j)+c(29)*M(2,:)%j) * den(103)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(57),h0tab(:,57),[32,2,17,12],[nMT,0,nMB,nMB],4,2,wf6(:,7),wf4(:,2))
  call Hloop_QW_A(ntryL,G0H144(1),ex6(:),G0H48(1),m3h3x48(:,34),heltab2x144(:,:,57))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(18),n2h48(34))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)+c(25)*M(2,:)%j) * den(103)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(58),h0tab(:,58),[32,2,12,17],[nMT,0,0,nMB],4,2,wf4(:,2),wf6(:,7))
  call Hloop_QW_A(ntryL,G0H144(1),ex6(:),G0H48(1),m3h3x48(:,35),heltab2x144(:,:,58))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(19),n2h48(35))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j)+c(29)*M(2,:)%j) * den(103)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(59),h0tab(:,59),[32,12,2,17],[nMT,nMT,0,nMB],4,2,wf4(:,2),wf6(:,7))
  call Hloop_QW_A(ntryL,G0H144(1),ex6(:),G0H48(1),m3h3x48(:,36),heltab2x144(:,:,59))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(20),n2h48(36))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j)+c(29)*M(2,:)%j) * den(99)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(60),h0tab(:,60),[34,1,16,12],[0,nMT,nMB,nMB],4,2,wf6(:,8),wf4(:,2))
  call Hloop_QA_V(ntryL,G0H144(1),wf6(:,8),G0H24(4),m3h6x24(:,8),heltab2x144(:,:,60))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)+c(25)*M(2,:)%j) * den(99)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(61),h0tab(:,61),[34,12,1,16],[0,0,nMT,nMB],4,2,wf6(:,8),wf4(:,2))
  call Hloop_QA_V(ntryL,G0H144(1),wf6(:,8),G0H24(2),m3h6x24(:,9),heltab2x144(:,:,61))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j)+c(29)*M(2,:)%j) * den(99)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(62),h0tab(:,62),[34,1,12,16],[0,nMT,nMT,nMB],4,2,wf6(:,8),wf4(:,2))
  call Hloop_QA_V(ntryL,G0H144(1),wf6(:,8),G0H24(5),m3h6x24(:,10),heltab2x144(:,:,62))
  Gcoeff(:)%j = (c(43)*M(1,:)%j-c(42)*M(2,:)%j) * den(156)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(63),h0tab(:,63),[48,2,1,12],[nMT,0,nMT,nMT],4,2,wf9(:,3),wf4(:,2))
  call Hloop_QS_A(ntryL,G0H144(1),wf9(:,3),G0H16(1),ngH,m3h9x16(:,17),heltab2x144(:,:,63))
  call Hloop_Q_A(ntryL,G0H16(1),48,nMT,G1H16(2),n2h16(17))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)+c(16)*M(2,:)%j) * den(157)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(64),h0tab(:,64),[48,2,1,12],[nMT,0,nMT,nMT],4,2,wf9(:,1),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H144(1),wf9(:,1),G0H16(1),m3h9x16(:,18),heltab2x144(:,:,64))
  call Hloop_Q_A(ntryL,G0H16(1),48,nMT,G1H16(4),n2h16(18))
  Gcoeff(:)%j = (-(c(56)*M(1,:)%j)+c(55)*M(2,:)%j) * den(158)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(65),h0tab(:,65),[48,2,1,12],[nMT,0,nMT,nMT],4,2,wf9(:,2),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H144(1),wf9(:,2),G0H16(1),ngZu,m3h9x16(:,19),heltab2x144(:,:,65))
  call Hloop_Q_A(ntryL,G0H16(1),48,nMT,G1H16(7),n2h16(19))
  Gcoeff(:)%j = (c(43)*M(1,:)%j-c(42)*M(2,:)%j) * den(156)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(66),h0tab(:,66),[48,1,2,12],[nMT,0,nMT,nMT],4,2,wf9(:,3),wf4(:,2))
  call Hloop_AS_Q(ntryL,G0H144(1),wf9(:,3),G0H16(1),ngH,m3h9x16(:,20),heltab2x144(:,:,66))
  call Hloop_A_Q(ntryL,G0H16(1),48,nMT,G1H16(10),n2h16(20))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)+c(16)*M(2,:)%j) * den(157)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(67),h0tab(:,67),[48,1,2,12],[nMT,0,nMT,nMT],4,2,wf9(:,1),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H144(1),wf9(:,1),G0H16(1),m3h9x16(:,21),heltab2x144(:,:,67))
  call Hloop_A_Q(ntryL,G0H16(1),48,nMT,G1H16(11),n2h16(21))
  Gcoeff(:)%j = (-(c(56)*M(1,:)%j)+c(55)*M(2,:)%j) * den(158)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(68),h0tab(:,68),[48,1,2,12],[nMT,0,nMT,nMT],4,2,wf9(:,2),wf4(:,2))
  call Hloop_AZ_Q(ntryL,G0H144(1),wf9(:,2),G0H16(1),ngZu,m3h9x16(:,22),heltab2x144(:,:,68))
  call Hloop_A_Q(ntryL,G0H16(1),48,nMT,G1H16(12),n2h16(22))
  Gcoeff(:)%j = (-(c(39)*M(1,:)%j)+c(38)*M(2,:)%j) * den(156)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(69),h0tab(:,69),[48,1,12,2],[nMT,0,0,nMT],4,2,wf9(:,3),wf4(:,2))
  call Hloop_AS_Q(ntryL,G0H144(1),wf9(:,3),G0H16(1),ngH,m3h9x16(:,23),heltab2x144(:,:,69))
  call Hloop_A_Q(ntryL,G0H16(1),48,nMT,G1H16(13),n2h16(23))
  Gcoeff(:)%j = (c(4)*M(1,:)%j-c(3)*M(2,:)%j) * den(157)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(70),h0tab(:,70),[48,1,12,2],[nMT,0,0,nMT],4,2,wf9(:,1),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H144(1),wf9(:,1),G0H16(1),m3h9x16(:,24),heltab2x144(:,:,70))
  call Hloop_A_Q(ntryL,G0H16(1),48,nMT,G1H16(14),n2h16(24))
  Gcoeff(:)%j = (c(52)*M(1,:)%j-c(51)*M(2,:)%j) * den(158)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(71),h0tab(:,71),[48,1,12,2],[nMT,0,0,nMT],4,2,wf9(:,2),wf4(:,2))
  call Hloop_AZ_Q(ntryL,G0H144(1),wf9(:,2),G0H16(1),ngZu,m3h9x16(:,25),heltab2x144(:,:,71))
  call Hloop_A_Q(ntryL,G0H16(1),48,nMT,G1H16(15),n2h16(25))
  Gcoeff(:)%j = (c(36)*M(1,:)%j-c(32)*M(2,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(72),h0tab(:,72),[32,2,13,16],[nMT,0,nMT,nMB],4,1,wf8(:,8))
  call Hloop_QW_A(ntryL,G0H144(1),ex6(:),G0H48(1),m3h3x48(:,37),heltab2x144(:,:,72))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(21),n2h48(37))
  Gcoeff(:)%j = (c(36)*M(1,:)%j-c(32)*M(2,:)%j) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(73),h0tab(:,73),[32,14,1,16],[nMT,0,nMT,nMB],4,1,wf8(:,6))
  call Hloop_QW_A(ntryL,G0H144(1),ex6(:),G0H48(1),m3h3x48(:,38),heltab2x144(:,:,73))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(22),n2h48(38))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)+c(33)*M(2,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(74),h0tab(:,74),[34,8,4,17],[0,0,0,nMB],4,2,wf6(:,8),wf6(:,7))
  call Hloop_QA_V(ntryL,G0H144(1),wf6(:,8),G0H24(6),m3h6x24(:,11),heltab2x144(:,:,74))
  Gcoeff(:)%j = (c(35)*M(1,:)%j+c(29)*M(2,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(75),h0tab(:,75),[34,4,8,17],[0,0,0,nMB],4,2,wf6(:,8),wf6(:,7))
  call Hloop_QA_V(ntryL,G0H144(1),wf6(:,8),G0H24(7),m3h6x24(:,12),heltab2x144(:,:,75))
  Gcoeff(:)%j = (c(35)*M(1,:)%j+c(29)*M(2,:)%j) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(76),h0tab(:,76),[49,2,4,8],[nMT,0,0,0],4,1,wf18(:,34))
  call Hloop_VQ_A(ntryL,G0H144(1),wf18(:,34),G0H8(1),m3h18x8(:,1),heltab2x144(:,:,76))
  call Hloop_Q_A(ntryL,G0H8(1),49,nMT,G1H8(1),n2h8(1))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)+c(33)*M(2,:)%j) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(77),h0tab(:,77),[49,2,8,4],[nMT,0,0,0],4,1,wf18(:,34))
  call Hloop_VQ_A(ntryL,G0H144(1),wf18(:,34),G0H8(1),m3h18x8(:,2),heltab2x144(:,:,77))
  call Hloop_Q_A(ntryL,G0H8(1),49,nMT,G1H8(2),n2h8(2))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)+c(33)*M(2,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(78),h0tab(:,78),[36,1,2,24],[0,nMT,0,0],4,2,wf6(:,3),wf6(:,4))
  call Hloop_AQ_V(ntryL,G0H144(1),wf6(:,3),G0H24(8),m3h6x24(:,13),heltab2x144(:,:,78))
  Gcoeff(:)%j = (c(35)*M(1,:)%j+c(29)*M(2,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(79),h0tab(:,79),[36,2,1,24],[0,nMT,0,0],4,2,wf6(:,3),wf6(:,4))
  call Hloop_AQ_V(ntryL,G0H144(1),wf6(:,3),G0H24(9),m3h6x24(:,14),heltab2x144(:,:,79))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)+c(33)*M(2,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(80),h0tab(:,80),[56,2,1,4],[0,nMT,0,0],4,1,wf18(:,26))
  call Hloop_QA_V(ntryL,G0H144(1),wf18(:,26),G0H8(1),m3h18x8(:,3),heltab2x144(:,:,80))
  Gcoeff(:)%j = (c(35)*M(1,:)%j+c(29)*M(2,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(81),h0tab(:,81),[56,1,2,4],[0,nMT,0,0],4,1,wf18(:,26))
  call Hloop_QA_V(ntryL,G0H144(1),wf18(:,26),G0H8(2),m3h18x8(:,4),heltab2x144(:,:,81))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)+c(33)*M(2,:)%j) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(82),h0tab(:,82),[50,1,4,8],[nMT,0,0,0],4,1,wf18(:,39))
  call Hloop_VA_Q(ntryL,G0H144(1),wf18(:,39),G0H8(3),m3h18x8(:,5),heltab2x144(:,:,82))
  call Hloop_A_Q(ntryL,G0H8(3),50,nMT,G1H8(3),n2h8(3))
  Gcoeff(:)%j = (c(35)*M(1,:)%j+c(29)*M(2,:)%j) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(83),h0tab(:,83),[50,1,8,4],[nMT,0,0,0],4,1,wf18(:,39))
  call Hloop_VA_Q(ntryL,G0H144(1),wf18(:,39),G0H8(3),m3h18x8(:,6),heltab2x144(:,:,83))
  call Hloop_A_Q(ntryL,G0H8(3),50,nMT,G1H8(4),n2h8(4))
  Gcoeff(:)%j = (c(35)*M(1,:)%j+c(29)*M(2,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(84),h0tab(:,84),[52,2,1,8],[0,nMT,0,0],4,1,wf18(:,22))
  call Hloop_AQ_V(ntryL,G0H144(1),wf18(:,22),G0H8(3),m3h18x8(:,7),heltab2x144(:,:,84))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)+c(33)*M(2,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(85),h0tab(:,85),[52,1,2,8],[0,nMT,0,0],4,1,wf18(:,22))
  call Hloop_AQ_V(ntryL,G0H144(1),wf18(:,22),G0H8(4),m3h18x8(:,8),heltab2x144(:,:,85))
  Gcoeff(:)%j = (-(c(48)*M(1,:)%j)-c(42)*M(2,:)%j) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(86),h0tab(:,86),[49,2,4,8],[nMT,0,0,0],4,1,wf18(:,15))
  call Hloop_VQ_A(ntryL,G0H144(1),wf18(:,15),G0H8(5),m3h18x8(:,9),heltab2x144(:,:,86))
  call Hloop_Q_A(ntryL,G0H8(5),49,nMT,G1H8(5),n2h8(5))
  Gcoeff(:)%j = (c(22)*M(1,:)%j+c(16)*M(2,:)%j) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(87),h0tab(:,87),[49,2,4,8],[nMT,0,0,0],4,1,wf18(:,17))
  call Hloop_VQ_A(ntryL,G0H144(1),wf18(:,17),G0H8(5),m3h18x8(:,10),heltab2x144(:,:,87))
  call Hloop_Q_A(ntryL,G0H8(5),49,nMT,G1H8(6),n2h8(6))
  Gcoeff(:)%j = (c(61)*M(1,:)%j+c(55)*M(2,:)%j) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(88),h0tab(:,88),[49,2,4,8],[nMT,0,0,0],4,1,wf18(:,19))
  call Hloop_VQ_A(ntryL,G0H144(1),wf18(:,19),G0H8(5),m3h18x8(:,11),heltab2x144(:,:,88))
  call Hloop_Q_A(ntryL,G0H8(5),49,nMT,G1H8(7),n2h8(7))
  Gcoeff(:)%j = (c(44)*M(1,:)%j-c(46)*M(2,:)%j) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(89),h0tab(:,89),[49,2,8,4],[nMT,0,0,0],4,1,wf18(:,15))
  call Hloop_VQ_A(ntryL,G0H144(1),wf18(:,15),G0H8(5),m3h18x8(:,12),heltab2x144(:,:,89))
  call Hloop_Q_A(ntryL,G0H8(5),49,nMT,G1H8(8),n2h8(8))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)+c(20)*M(2,:)%j) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(90),h0tab(:,90),[49,2,8,4],[nMT,0,0,0],4,1,wf18(:,17))
  call Hloop_VQ_A(ntryL,G0H144(1),wf18(:,17),G0H8(5),m3h18x8(:,13),heltab2x144(:,:,90))
  call Hloop_Q_A(ntryL,G0H8(5),49,nMT,G1H8(9),n2h8(9))
  Gcoeff(:)%j = (-(c(57)*M(1,:)%j)+c(59)*M(2,:)%j) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(91),h0tab(:,91),[49,2,8,4],[nMT,0,0,0],4,1,wf18(:,19))
  call Hloop_VQ_A(ntryL,G0H144(1),wf18(:,19),G0H8(5),m3h18x8(:,14),heltab2x144(:,:,91))
  call Hloop_Q_A(ntryL,G0H8(5),49,nMT,G1H8(10),n2h8(10))
  Gcoeff(:)%j = (c(44)*M(1,:)%j-c(46)*M(2,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(92),h0tab(:,92),[50,1,4,8],[nMT,0,0,0],4,1,wf18(:,40))
  call Hloop_VA_Q(ntryL,G0H144(1),wf18(:,40),G0H8(5),m3h18x8(:,15),heltab2x144(:,:,92))
  call Hloop_A_Q(ntryL,G0H8(5),50,nMT,G1H8(11),n2h8(11))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)+c(20)*M(2,:)%j) * den(64)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(93),h0tab(:,93),[50,1,4,8],[nMT,0,0,0],4,1,wf18(:,41))
  call Hloop_VA_Q(ntryL,G0H144(1),wf18(:,41),G0H8(5),m3h18x8(:,16),heltab2x144(:,:,93))
  call Hloop_A_Q(ntryL,G0H8(5),50,nMT,G1H8(12),n2h8(12))
  Gcoeff(:)%j = (-(c(57)*M(1,:)%j)+c(59)*M(2,:)%j) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(94),h0tab(:,94),[50,1,4,8],[nMT,0,0,0],4,1,wf18(:,42))
  call Hloop_VA_Q(ntryL,G0H144(1),wf18(:,42),G0H8(5),m3h18x8(:,17),heltab2x144(:,:,94))
  call Hloop_A_Q(ntryL,G0H8(5),50,nMT,G1H8(13),n2h8(13))
  Gcoeff(:)%j = (-(c(48)*M(1,:)%j)-c(42)*M(2,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(95),h0tab(:,95),[50,1,8,4],[nMT,0,0,0],4,1,wf18(:,40))
  call Hloop_VA_Q(ntryL,G0H144(1),wf18(:,40),G0H8(5),m3h18x8(:,18),heltab2x144(:,:,95))
  call Hloop_A_Q(ntryL,G0H8(5),50,nMT,G1H8(14),n2h8(14))
  Gcoeff(:)%j = (c(22)*M(1,:)%j+c(16)*M(2,:)%j) * den(64)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(96),h0tab(:,96),[50,1,8,4],[nMT,0,0,0],4,1,wf18(:,41))
  call Hloop_VA_Q(ntryL,G0H144(1),wf18(:,41),G0H8(5),m3h18x8(:,19),heltab2x144(:,:,96))
  call Hloop_A_Q(ntryL,G0H8(5),50,nMT,G1H8(15),n2h8(15))
  Gcoeff(:)%j = (c(61)*M(1,:)%j+c(55)*M(2,:)%j) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(97),h0tab(:,97),[50,1,8,4],[nMT,0,0,0],4,1,wf18(:,42))
  call Hloop_VA_Q(ntryL,G0H144(1),wf18(:,42),G0H8(5),m3h18x8(:,20),heltab2x144(:,:,97))
  call Hloop_A_Q(ntryL,G0H8(5),50,nMT,G1H8(16),n2h8(16))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)-c(7)*M(2,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(98),h0tab(:,98),[52,2,1,8],[0,nMT,0,0],4,1,wf18(:,6))
  call Hloop_AQ_V(ntryL,G0H144(1),wf18(:,6),G0H8(5),m3h18x8(:,21),heltab2x144(:,:,98))
  Gcoeff(:)%j = (c(61)*M(1,:)%j+c(55)*M(2,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(99),h0tab(:,99),[52,2,1,8],[0,nMT,0,0],4,1,wf18(:,8))
  call Hloop_AQ_V(ntryL,G0H144(1),wf18(:,8),G0H8(6),m3h18x8(:,22),heltab2x144(:,:,99))
  Gcoeff(:)%j = (c(9)*M(1,:)%j-c(11)*M(2,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(100),h0tab(:,100),[52,1,2,8],[0,nMT,0,0],4,1,wf18(:,6))
  call Hloop_AQ_V(ntryL,G0H144(1),wf18(:,6),G0H8(7),m3h18x8(:,23),heltab2x144(:,:,100))
  Gcoeff(:)%j = (-(c(57)*M(1,:)%j)+c(59)*M(2,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(101),h0tab(:,101),[52,1,2,8],[0,nMT,0,0],4,1,wf18(:,8))
  call Hloop_AQ_V(ntryL,G0H144(1),wf18(:,8),G0H8(8),m3h18x8(:,24),heltab2x144(:,:,101))
  Gcoeff(:)%j = (c(9)*M(1,:)%j-c(11)*M(2,:)%j) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(102),h0tab(:,102),[56,2,1,4],[0,nMT,0,0],4,1,wf18(:,29))
  call Hloop_QA_V(ntryL,G0H144(1),wf18(:,29),G0H8(9),m3h18x8(:,25),heltab2x144(:,:,102))
  Gcoeff(:)%j = (-(c(57)*M(1,:)%j)+c(59)*M(2,:)%j) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(103),h0tab(:,103),[56,2,1,4],[0,nMT,0,0],4,1,wf18(:,30))
  call Hloop_QA_V(ntryL,G0H144(1),wf18(:,30),G0H8(10),m3h18x8(:,26),heltab2x144(:,:,103))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)-c(7)*M(2,:)%j) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(104),h0tab(:,104),[56,1,2,4],[0,nMT,0,0],4,1,wf18(:,29))
  call Hloop_QA_V(ntryL,G0H144(1),wf18(:,29),G0H8(11),m3h18x8(:,27),heltab2x144(:,:,104))
  Gcoeff(:)%j = (c(61)*M(1,:)%j+c(55)*M(2,:)%j) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(105),h0tab(:,105),[56,1,2,4],[0,nMT,0,0],4,1,wf18(:,30))
  call Hloop_QA_V(ntryL,G0H144(1),wf18(:,30),G0H8(12),m3h18x8(:,28),heltab2x144(:,:,105))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(3),[G1H16(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(5),[G1H16(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(8),[G1H16(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(7),[G1H16(4),G1H16(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(12),[G1H16(11),G1H16(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(15),[G1H16(14),G1H16(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(7),[G1H8(6),G1H8(5),G1H8(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(10),[G1H8(9),G1H8(8),G1H8(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(10),[G0H8(9),G0H8(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(12),[G0H8(11),G0H8(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(13),[G1H8(12),G1H8(11),G1H8(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(16),[G1H8(15),G1H8(14),G1H8(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(6),[G0H8(5),G0H8(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(8),[G0H8(7),G0H8(4)])
  call Hloop_QW_A(ntryL,G1H12(7),ex5(:),G1H4(6),m3h3x4(:,10),heltab2x12(:,:,32))
  call Hloop_Q_A(ntryL,G1H4(6),51,0,G2H4(7),n2h4(12))
  call Hloop_QV_A(ntryL,G1H48(1),wf4(:,2),G1H12(11),m3h4x12(:,4),heltab2x48(:,:,17))
  call Hloop_Q_A(ntryL,G1H12(11),44,0,G2H12(2),n2h12(23))
  call Hloop_QV_A(ntryL,G1H48(2),wf4(:,2),G1H12(1),m3h4x12(:,5),heltab2x48(:,:,18))
  call Hloop_Q_A(ntryL,G1H12(1),44,nMT,G2H12(3),n2h12(24))
  call Hloop_AV_Q(ntryL,G1H48(3),wf4(:,2),G1H12(4),m3h4x12(:,6),heltab2x48(:,:,19))
  call Hloop_A_Q(ntryL,G1H12(4),44,0,G2H12(5),n2h12(25))
  call Hloop_AV_Q(ntryL,G1H48(4),wf4(:,2),G1H12(5),m3h4x12(:,7),heltab2x48(:,:,20))
  call Hloop_A_Q(ntryL,G1H12(5),44,nMB,G2H12(6),n2h12(26))
  call Hloop_QV_A(ntryL,G1H48(5),wf4(:,1),G1H12(6),m3h4x12(:,8),heltab2x48(:,:,21))
  call Hloop_Q_A(ntryL,G1H12(6),35,0,G2H12(7),n2h12(27))
  call Hloop_QV_A(ntryL,G1H48(6),wf4(:,1),G1H12(8),m3h4x12(:,9),heltab2x48(:,:,22))
  call Hloop_Q_A(ntryL,G1H12(8),35,nMT,G2H12(8),n2h12(28))
  call Hloop_AV_Q(ntryL,G1H48(7),wf4(:,1),G1H12(12),m3h4x12(:,10),heltab2x48(:,:,23))
  call Hloop_A_Q(ntryL,G1H12(12),35,0,G2H12(4),n2h12(29))
  call Hloop_AV_Q(ntryL,G1H48(8),wf4(:,1),G1H12(13),m3h4x12(:,11),heltab2x48(:,:,24))
  call Hloop_A_Q(ntryL,G1H12(13),35,nMB,G2H12(1),n2h12(30))
  call Hloop_QV_A(ntryL,G1H48(9),wf4(:,1),G1H12(14),m3h4x12(:,12),heltab2x48(:,:,25))
  call Hloop_Q_A(ntryL,G1H12(14),35,0,G2H12(9),n2h12(31))
  call Hloop_QV_A(ntryL,G1H48(10),wf4(:,1),G1H12(15),m3h4x12(:,13),heltab2x48(:,:,26))
  call Hloop_Q_A(ntryL,G1H12(15),35,nMT,G2H12(10),n2h12(32))
  call Hloop_AV_Q(ntryL,G1H48(11),wf4(:,1),G1H12(18),m3h4x12(:,14),heltab2x48(:,:,27))
  call Hloop_A_Q(ntryL,G1H12(18),35,0,G2H12(11),n2h12(33))
  call Hloop_AV_Q(ntryL,G1H48(12),wf4(:,1),G1H12(19),m3h4x12(:,15),heltab2x48(:,:,28))
  call Hloop_A_Q(ntryL,G1H12(19),35,nMB,G2H12(12),n2h12(34))
  call Hloop_AQ_V(ntryL,G1H48(13),ex3(:),G1H24(2),m3h2x24(:,14),heltab2x48(:,:,29))
  call Hloop_QV_A(ntryL,G1H48(14),wf4(:,1),G1H12(7),m3h4x12(:,16),heltab2x48(:,:,30))
  call Hloop_Q_A(ntryL,G1H12(7),35,0,G2H12(13),n2h12(35))
  call Hloop_AV_Q(ntryL,G1H48(15),wf4(:,1),G1H12(11),m3h4x12(:,17),heltab2x48(:,:,31))
  call Hloop_A_Q(ntryL,G1H12(11),35,0,G2H12(14),n2h12(36))
  call Hloop_UV_W(ntryL,G0H24(1),36,wf4(:,1),3,G1H6(8),m3h4x6(:,3),heltab2x24(:,:,18))
  call Hloop_QV_A(ntryL,G1H24(1),wf4(:,1),G1H6(12),m3h4x6(:,4),heltab2x24(:,:,19))
  call Hloop_Q_A(ntryL,G1H6(12),39,0,G2H6(6),n2h6(9))
  call Hloop_VA_Q(ntryL,G0H24(3),ex4(:),G0H12(1),m3h2x12(:,16),heltab2x24(:,:,20))
  call Hloop_A_Q(ntryL,G0H12(1),44,0,G1H12(1),n2h12(37))
  call Hloop_AV_Q(ntryL,G1H16(3),wf4(:,1),G1H4(1),m3h4x4(:,1),heltab2x16(:,:,5))
  call Hloop_A_Q(ntryL,G1H4(1),51,0,G2H4(8),n2h4(13))
  call Hloop_QV_A(ntryL,G1H16(5),wf4(:,1),G1H4(2),m3h4x4(:,2),heltab2x16(:,:,6))
  call Hloop_Q_A(ntryL,G1H4(2),51,0,G2H4(2),n2h4(14))
  call Hloop_AQ_V(ntryL,G1H16(8),ex3(:),G1H8(6),m3h2x8(:,5),heltab2x16(:,:,7))
  call Hloop_AQ_V(ntryL,G1H48(16),wf8(:,2),G1H6(24),m3h8x6(:,1),heltab2x48(:,:,32))
  call Hloop_AQ_V(ntryL,G1H48(17),ex3(:),G1H24(3),m3h2x24(:,15),heltab2x48(:,:,33))
  call Hloop_QA_V(ntryL,G1H48(18),ex2(:),G1H24(4),m3h2x24(:,16),heltab2x48(:,:,34))
  call Hloop_QA_V(ntryL,G1H48(19),ex2(:),G1H24(5),m3h2x24(:,17),heltab2x48(:,:,35))
  call Hloop_QV_A(ntryL,G1H48(20),wf4(:,2),G1H12(4),m3h4x12(:,18),heltab2x48(:,:,36))
  call Hloop_Q_A(ntryL,G1H12(4),44,nMT,G2H12(15),n2h12(38))
  call Hloop_VQ_A(ntryL,G0H24(4),ex1(:),G0H12(1),m3h2x12(:,17),heltab2x24(:,:,21))
  call Hloop_Q_A(ntryL,G0H12(1),35,nMT,G1H12(5),n2h12(39))
  call Hloop_UV_W(ntryL,G0H24(2),34,wf4(:,2),12,G1H6(5),m3h4x6(:,5),heltab2x24(:,:,22))
  call Hloop_VQ_A(ntryL,G0H24(5),ex1(:),G0H12(1),m3h2x12(:,18),heltab2x24(:,:,23))
  call Hloop_Q_A(ntryL,G0H12(1),35,nMT,G1H12(6),n2h12(40))
  call Hloop_QA_V(ntryL,G1H16(7),ex2(:),G1H8(5),m3h2x8(:,6),heltab2x16(:,:,8))
  call Hloop_AQ_V(ntryL,G1H16(12),ex1(:),G1H8(1),m3h2x8(:,7),heltab2x16(:,:,9))
  call Hloop_AQ_V(ntryL,G1H16(15),ex1(:),G1H8(9),m3h2x8(:,8),heltab2x16(:,:,10))
  call Hloop_QA_V(ntryL,G1H48(21),ex2(:),G1H24(6),m3h2x24(:,18),heltab2x48(:,:,37))
  call Hloop_QA_V(ntryL,G1H48(22),wf8(:,6),G1H6(9),m3h8x6(:,2),heltab2x48(:,:,38))
  call Hloop_VA_Q(ntryL,G0H24(6),ex4(:),G0H12(1),m3h2x12(:,19),heltab2x24(:,:,24))
  call Hloop_A_Q(ntryL,G0H12(1),42,0,G1H12(8),n2h12(41))
  call Hloop_VQ_A(ntryL,G0H24(7),ex3(:),G0H12(1),m3h2x12(:,20),heltab2x24(:,:,25))
  call Hloop_Q_A(ntryL,G0H12(1),38,0,G1H12(12),n2h12(42))
  call Hloop_QA_V(ntryL,G1H8(7),ex2(:),G1H4(7),m3h2x4(:,5),heltab2x8(:,:,5))
  call Hloop_QA_V(ntryL,G1H8(10),ex2(:),G1H4(8),m3h2x4(:,6),heltab2x8(:,:,6))
  call Hloop_VQ_A(ntryL,G0H24(8),ex1(:),G0H12(1),m3h2x12(:,21),heltab2x24(:,:,26))
  call Hloop_Q_A(ntryL,G0H12(1),37,nMT,G1H12(13),n2h12(43))
  call Hloop_VA_Q(ntryL,G0H24(9),ex2(:),G0H12(1),m3h2x12(:,22),heltab2x24(:,:,27))
  call Hloop_A_Q(ntryL,G0H12(1),38,nMT,G1H12(14),n2h12(44))
  call Hloop_VA_Q(ntryL,G0H8(10),ex2(:),G0H4(1),m3h2x4(:,7),heltab2x8(:,:,7))
  call Hloop_A_Q(ntryL,G0H4(1),58,nMT,G1H4(6),n2h4(15))
  call Hloop_VQ_A(ntryL,G0H8(12),ex1(:),G0H4(1),m3h2x4(:,8),heltab2x8(:,:,8))
  call Hloop_Q_A(ntryL,G0H4(1),57,nMT,G1H4(1),n2h4(16))
  call Hloop_AQ_V(ntryL,G1H8(13),ex1(:),G1H4(2),m3h2x4(:,9),heltab2x8(:,:,9))
  call Hloop_AQ_V(ntryL,G1H8(16),ex1(:),G1H4(12),m3h2x4(:,10),heltab2x8(:,:,10))
  call Hloop_VA_Q(ntryL,G0H8(6),ex2(:),G0H4(1),m3h2x4(:,11),heltab2x8(:,:,11))
  call Hloop_A_Q(ntryL,G0H4(1),54,nMT,G1H4(13),n2h4(17))
  call Hloop_VQ_A(ntryL,G0H8(8),ex1(:),G0H4(1),m3h2x4(:,12),heltab2x8(:,:,12))
  call Hloop_Q_A(ntryL,G0H4(1),53,nMT,G1H4(14),n2h4(18))
call HGT_lower_alpha_w2_OLR(G2H6(5),1,1,6)
call HGT_lower_alpha_w2_invQ_OLR(G2H6(5),2,5,6)
call HGT_lower_alpha_w2_OLR(G2H6(5),6,15,6)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(5),[G2H6(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(8),[G1H6(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(24),[G1H6(21),G1H6(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(5),[G1H6(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(9),[G1H6(16),G1H6(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(1),[G1H12(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(5),[G1H12(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(5),[G1H12(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(10),[G1H12(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(6),[G1H12(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(8),[G1H12(17)])
  call Hotf_4pt_reduction(G2H6(5),RedSet_4(95),mass4set(:,1),  & 
G1H6(4),G1H6(6),G1H6(10),G1H6(26),G1H6(27),6)
  call HG1shiftOLR(G1H6(6),8,6)
  call Hloop_QA_V(ntryL,G2H4(6),ex4(:),G2H2(5),m3h2x2(:,8),heltab2x4(:,:,12))
  call Hloop_VA_Q(ntryL,G1H6(8),ex4(:),G1H3(42),m3h2x3(:,29),heltab2x6(:,:,49))
  call Hloop_A_Q(ntryL,G1H3(42),47,0,G2H3(2),n2h3(35))
  call Hloop_VA_Q(ntryL,G1H6(24),ex4(:),G1H3(72),m3h2x3(:,30),heltab2x6(:,:,50))
  call Hloop_A_Q(ntryL,G1H3(72),47,0,G2H3(4),n2h3(36))
  call Hloop_VQ_A(ntryL,G1H6(5),ex1(:),G1H3(100),m3h2x3(:,31),heltab2x6(:,:,51))
  call Hloop_Q_A(ntryL,G1H3(100),47,nMT,G2H3(6),n2h3(37))
  call Hloop_VQ_A(ntryL,G1H6(9),ex1(:),G1H3(111),m3h2x3(:,32),heltab2x6(:,:,52))
  call Hloop_Q_A(ntryL,G1H3(111),47,nMT,G2H3(8),n2h3(38))
  call Hloop_AV_Q(ntryL,G1H12(1),wf4(:,1),G1H3(122),m3h4x3(:,8),heltab2x12(:,:,33))
  call Hloop_A_Q(ntryL,G1H3(122),47,0,G2H3(1),n2h3(39))
  call Hotf_4pt_reduction(G2H12(5),RedSet_4(83),mass4set(:,1),  & 
G1H12(15),G1H12(18),G1H12(19),G1H12(7),G1H12(11),G0H12(1),12)
  call HG1shiftOLR(G1H12(18),16,12)
  call Hloop_VA_Q(ntryL,G1H6(17),ex4(:),G1H3(133),m3h2x3(:,33),heltab2x6(:,:,53))
  call Hloop_A_Q(ntryL,G1H3(133),47,0,G2H3(3),n2h3(40))
  call Hloop_QW_A(ntryL,G1H12(5),ex5(:),G1H4(15),m3h3x4(:,11),heltab2x12(:,:,34))
  call Hloop_Q_A(ntryL,G1H4(15),51,nMB,G2H4(4),n2h4(19))
  call Hotf_4pt_reduction(G2H12(10),RedSet_4(50),mass4set(:,5),  & 
G1H12(4),G1H12(2),G1H12(3),G1H12(9),G1H12(10),G0H12(2),12)
  call HG1shiftOLR(G1H12(2),12,12)
  call Hloop_VQ_A(ntryL,G1H6(1),ex1(:),G1H3(7),m3h2x3(:,34),heltab2x6(:,:,54))
  call Hloop_Q_A(ntryL,G1H3(7),47,nMT,G2H3(13),n2h3(41))
  call Hloop_QV_A(ntryL,G1H12(6),wf4(:,2),G1H3(8),m3h4x3(:,9),heltab2x12(:,:,35))
  call Hloop_Q_A(ntryL,G1H3(8),47,nMT,G2H3(5),n2h3(42))
  call Hotf_4pt_reduction(G2H12(8),RedSet_4(86),mass4set(:,6),  & 
G1H12(16),G1H12(17),G1H12(1),G1H12(5),G1H12(6),G0H12(3),12)
  call HG1shiftOLR(G1H12(17),16,12)
  call Hloop_QA_V(ntryL,G2H4(7),ex4(:),G2H2(6),m3h2x2(:,9),heltab2x4(:,:,13))
  call Hotf_4pt_reduction(G2H12(2),RedSet_4(83),mass4set(:,1),  & 
G1H12(20),G1H12(21),G1H12(22),G1H12(23),G1H12(24),G0H12(4),12)
  call HG1shiftOLR(G1H12(21),16,12)
  call Hotf_4pt_reduction(G2H12(3),RedSet_4(83),mass4set(:,6),  & 
G1H12(25),G1H12(26),G1H12(27),G1H12(28),G1H12(29),G0H12(5),12)
  call HG1shiftOLR(G1H12(26),16,12)
  call Hotf_4pt_reduction(G2H12(6),RedSet_4(83),mass4set(:,7),  & 
G1H12(30),G1H12(31),G1H12(32),G1H12(33),G1H12(34),G0H12(6),12)
  call HG1shiftOLR(G1H12(31),16,12)
  call Hotf_4pt_reduction(G2H12(7),RedSet_4(86),mass4set(:,1),  & 
G1H12(35),G1H12(36),G1H12(37),G1H12(38),G1H12(39),G0H12(7),12)
  call HG1shiftOLR(G1H12(36),16,12)
  call Hotf_4pt_reduction(G2H12(4),RedSet_4(86),mass4set(:,1),  & 
G1H12(40),G1H12(41),G1H12(42),G1H12(43),G1H12(44),G0H12(8),12)
  call HG1shiftOLR(G1H12(41),16,12)
  call Hotf_4pt_reduction(G2H12(1),RedSet_4(86),mass4set(:,7),  & 
G1H12(45),G1H12(46),G1H12(47),G1H12(48),G1H12(49),G0H12(9),12)
  call HG1shiftOLR(G1H12(46),16,12)
  call Hotf_4pt_reduction(G2H12(9),RedSet_4(50),mass4set(:,1),  & 
G1H12(50),G1H12(51),G1H12(52),G1H12(53),G1H12(54),G0H12(10),12)
  call HG1shiftOLR(G1H12(51),12,12)
  call Hotf_4pt_reduction(G2H12(11),RedSet_4(50),mass4set(:,1),  & 
G1H12(55),G1H12(56),G1H12(57),G1H12(58),G1H12(59),G0H12(11),12)
  call HG1shiftOLR(G1H12(56),12,12)
  call Hotf_4pt_reduction(G2H12(12),RedSet_4(50),mass4set(:,8),  & 
G1H12(60),G1H12(61),G1H12(62),G1H12(63),G1H12(64),G0H12(12),12)
  call HG1shiftOLR(G1H12(61),12,12)
  call Hloop_UV_W(ntryL,G1H24(2),36,wf4(:,1),3,G2H6(2),m3h4x6(:,6),heltab2x24(:,:,28))
  call Hloop_QA_V(ntryL,G2H12(13),wf6(:,4),G2H2(1),m3h6x2(:,1),heltab2x12(:,:,36))
  call Hloop_AQ_V(ntryL,G2H12(14),ex3(:),G2H6(4),m3h2x6(:,16),heltab2x12(:,:,37))
  call Hloop_AQ_V(ntryL,G2H4(8),ex3(:),G2H2(2),m3h2x2(:,10),heltab2x4(:,:,14))
  call Hloop_QA_V(ntryL,G2H4(2),ex4(:),G2H2(3),m3h2x2(:,11),heltab2x4(:,:,15))
  call Hloop_UV_W(ntryL,G1H8(6),52,wf4(:,1),3,G2H2(4),m3h4x2(:,1),heltab2x8(:,:,13))
  call Hloop_VA_Q(ntryL,G1H24(3),wf8(:,4),G1H3(20),m3h8x3(:,1),heltab2x24(:,:,29))
  call Hloop_A_Q(ntryL,G1H3(20),47,0,G2H3(7),n2h3(43))
  call Hloop_VQ_A(ntryL,G1H24(4),wf6(:,7),G1H4(15),m3h6x4(:,1),heltab2x24(:,:,30))
  call Hloop_Q_A(ntryL,G1H4(15),51,nMB,G2H4(6),n2h4(20))
  call Hloop_UV_W(ntryL,G1H24(5),34,wf4(:,2),12,G2H6(1),m3h4x6(:,7),heltab2x24(:,:,31))
  call Hloop_QA_V(ntryL,G2H12(15),ex2(:),G2H6(3),m3h2x6(:,17),heltab2x12(:,:,38))
  call Hloop_VQ_A(ntryL,G1H8(5),ex1(:),G1H4(15),m3h2x4(:,13),heltab2x8(:,:,14))
  call Hloop_Q_A(ntryL,G1H4(15),51,nMT,G2H4(7),n2h4(21))
  call Hloop_VA_Q(ntryL,G1H8(1),ex2(:),G1H4(15),m3h2x4(:,14),heltab2x8(:,:,15))
  call Hloop_A_Q(ntryL,G1H4(15),51,nMT,G2H4(8),n2h4(22))
  call Hloop_UV_W(ntryL,G1H8(9),49,wf4(:,2),12,G2H2(7),m3h4x2(:,2),heltab2x8(:,:,16))
  call Hloop_VQ_A(ntryL,G1H24(6),wf8(:,8),G1H3(1),m3h8x3(:,2),heltab2x24(:,:,32))
  call Hloop_Q_A(ntryL,G1H3(1),47,nMT,G2H3(9),n2h3(44))
  call Hloop_AQ_V(ntryL,G1H12(8),ex3(:),G1H6(28),m3h2x6(:,18),heltab2x12(:,:,39))
  call Hloop_QA_V(ntryL,G1H12(12),ex4(:),G1H6(32),m3h2x6(:,19),heltab2x12(:,:,40))
  call Hloop_VQ_A(ntryL,G1H4(7),ex3(:),G1H2(42),m3h2x2(:,12),heltab2x4(:,:,16))
  call Hloop_Q_A(ntryL,G1H2(42),55,0,G2H2(8),n2h2(1))
  call Hloop_VA_Q(ntryL,G1H4(8),ex4(:),G1H2(1),m3h2x2(:,13),heltab2x4(:,:,17))
  call Hloop_A_Q(ntryL,G1H2(1),59,0,G2H2(9),n2h2(2))
  call Hloop_QA_V(ntryL,G1H12(13),ex2(:),G1H6(12),m3h2x6(:,20),heltab2x12(:,:,41))
  call Hloop_AQ_V(ntryL,G1H12(14),ex1(:),G1H6(13),m3h2x6(:,21),heltab2x12(:,:,42))
  call Hloop_AQ_V(ntryL,G1H4(6),ex1(:),G1H2(2),m3h2x2(:,14),heltab2x4(:,:,18))
  call Hloop_QA_V(ntryL,G1H4(1),ex2(:),G1H2(6),m3h2x2(:,15),heltab2x4(:,:,19))
  call Hloop_VQ_A(ntryL,G1H4(2),ex3(:),G1H2(7),m3h2x2(:,16),heltab2x4(:,:,20))
  call Hloop_Q_A(ntryL,G1H2(7),55,0,G2H2(11),n2h2(3))
  call Hloop_VA_Q(ntryL,G1H4(12),ex4(:),G1H2(8),m3h2x2(:,17),heltab2x4(:,:,21))
  call Hloop_A_Q(ntryL,G1H2(8),59,0,G2H2(16),n2h2(4))
  call Hloop_AQ_V(ntryL,G1H4(13),ex1(:),G1H2(12),m3h2x2(:,18),heltab2x4(:,:,22))
  call Hloop_QA_V(ntryL,G1H4(14),ex2(:),G1H2(13),m3h2x2(:,19),heltab2x4(:,:,23))
  call Hloop_QW_A(ntryL,G1H6(4),ex5(:),G1H2(14),m3h3x2(:,9),heltab2x6(:,:,55))
  call Hloop_Q_A(ntryL,G1H2(14),55,0,G2H2(17),n2h2(5))
call HGT_raise_alpha_OLR(G1H6(6),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(6),2,5,6)
  call Hloop_VA_Q(ntryL,G1H6(6),ex4(:),G1H3(2),m3h2x3(:,35),heltab2x6(:,:,56))
  call Hloop_QW_A(ntryL,G1H6(26),ex5(:),G1H2(18),m3h3x2(:,10),heltab2x6(:,:,57))
  call Hloop_Q_A(ntryL,G1H2(18),55,0,G2H2(18),n2h2(6))
  call Hloop_QW_A(ntryL,G1H6(27),ex5(:),G1H2(19),m3h3x2(:,11),heltab2x6(:,:,58))
  call Hloop_Q_A(ntryL,G1H2(19),55,0,G2H2(19),n2h2(7))
  call Hloop_AV_Q(ntryL,G1H12(15),wf4(:,1),G1H3(24),m3h4x3(:,10),heltab2x12(:,:,43))
  call Hloop_A_Q(ntryL,G1H3(24),47,0,G2H3(10),n2h3(45))
call HGT_OLR(G1H12(18),1,1,12)
call HGT_invQ_OLR(G1H12(18),2,5,12)
  call Hloop_Q_A(ntryL,G1H12(18),-16,0,G2H12(5),n2h12(45))
  call Hloop_QW_A(ntryL,G2H12(5),ex5(:),G2H4(2),m3h3x4(:,12),heltab2x12(:,:,44))
  call Hloop_AV_Q(ntryL,G1H12(7),wf4(:,1),G1H3(3),m3h4x3(:,11),heltab2x12(:,:,45))
  call Hloop_A_Q(ntryL,G1H3(3),47,0,G2H3(16),n2h3(46))
  call Hloop_AV_Q(ntryL,G1H12(11),wf4(:,1),G1H3(4),m3h4x3(:,12),heltab2x12(:,:,46))
  call Hloop_A_Q(ntryL,G1H3(4),47,0,G2H3(11),n2h3(47))
  call Hloop_AV_Q(ntryL,G0H12(1),wf4(:,1),G0H3(1),m3h4x3(:,13),heltab2x12(:,:,47))
  call Hloop_A_Q(ntryL,G0H3(1),47,0,G1H3(10),n2h3(48))
  call Hloop_QW_A(ntryL,G1H12(4),ex5(:),G1H4(15),m3h3x4(:,13),heltab2x12(:,:,48))
  call Hloop_Q_A(ntryL,G1H4(15),51,nMB,G2H4(9),n2h4(23))
call HGT_OLR(G1H12(2),1,1,12)
call HGT_invQ_OLR(G1H12(2),2,5,12)
  call Hloop_A_Q(ntryL,G1H12(2),-12,nMB,G2H12(10),n2h12(46))
  call Hloop_AV_Q(ntryL,G2H12(10),wf4(:,2),G2H3(12),m3h4x3(:,14),heltab2x12(:,:,49))
  call Hloop_QW_A(ntryL,G1H12(9),ex5(:),G1H4(7),m3h3x4(:,14),heltab2x12(:,:,50))
  call Hloop_Q_A(ntryL,G1H4(7),51,nMB,G2H4(10),n2h4(24))
  call Hloop_QW_A(ntryL,G1H12(10),ex5(:),G1H4(8),m3h3x4(:,15),heltab2x12(:,:,51))
  call Hloop_Q_A(ntryL,G1H4(8),51,nMB,G2H4(11),n2h4(25))
  call Hloop_QW_A(ntryL,G0H12(2),ex5(:),G0H4(1),m3h3x4(:,16),heltab2x12(:,:,52))
  call Hloop_Q_A(ntryL,G0H4(1),51,nMB,G1H4(6),n2h4(26))
  call Hloop_QV_A(ntryL,G1H12(16),wf4(:,2),G1H3(15),m3h4x3(:,15),heltab2x12(:,:,53))
  call Hloop_Q_A(ntryL,G1H3(15),47,nMT,G2H3(15),n2h3(49))
call HGT_OLR(G1H12(17),1,1,12)
call HGT_invQ_OLR(G1H12(17),2,5,12)
  call Hloop_A_Q(ntryL,G1H12(17),-16,nMB,G2H12(8),n2h12(47))
  call Hloop_AW_Q(ntryL,G2H12(8),ex5(:),G2H4(12),m3h3x4(:,17),heltab2x12(:,:,54))
  call Hloop_QV_A(ntryL,G1H12(5),wf4(:,2),G1H3(16),m3h4x3(:,16),heltab2x12(:,:,55))
  call Hloop_Q_A(ntryL,G1H3(16),47,nMT,G2H3(18),n2h3(50))
  call Hloop_QV_A(ntryL,G1H12(6),wf4(:,2),G1H3(22),m3h4x3(:,17),heltab2x12(:,:,56))
  call Hloop_Q_A(ntryL,G1H3(22),47,nMT,G2H3(19),n2h3(51))
  call Hloop_QV_A(ntryL,G0H12(3),wf4(:,2),G0H3(1),m3h4x3(:,18),heltab2x12(:,:,57))
  call Hloop_Q_A(ntryL,G0H3(1),47,nMT,G1H3(25),n2h3(52))
  call Hloop_QV_A(ntryL,G1H12(20),wf4(:,1),G1H3(26),m3h4x3(:,19),heltab2x12(:,:,58))
  call Hloop_Q_A(ntryL,G1H3(26),47,0,G2H3(21),n2h3(53))
call HGT_OLR(G1H12(21),1,1,12)
call HGT_invQ_OLR(G1H12(21),2,5,12)
  call Hloop_A_Q(ntryL,G1H12(21),-16,0,G2H12(2),n2h12(48))
  call Hloop_AW_Q(ntryL,G2H12(2),ex5(:),G2H4(13),m3h3x4(:,18),heltab2x12(:,:,59))
  call Hloop_QV_A(ntryL,G1H12(23),wf4(:,1),G1H3(30),m3h4x3(:,20),heltab2x12(:,:,60))
  call Hloop_Q_A(ntryL,G1H3(30),47,0,G2H3(22),n2h3(54))
  call Hloop_QV_A(ntryL,G1H12(24),wf4(:,1),G1H3(31),m3h4x3(:,21),heltab2x12(:,:,61))
  call Hloop_Q_A(ntryL,G1H3(31),47,0,G2H3(24),n2h3(55))
  call Hloop_QV_A(ntryL,G0H12(4),wf4(:,1),G0H3(1),m3h4x3(:,22),heltab2x12(:,:,62))
  call Hloop_Q_A(ntryL,G0H3(1),47,0,G1H3(32),n2h3(56))
  call Hloop_QV_A(ntryL,G1H12(25),wf4(:,1),G1H3(36),m3h4x3(:,23),heltab2x12(:,:,63))
  call Hloop_Q_A(ntryL,G1H3(36),47,nMT,G2H3(26),n2h3(57))
call HGT_OLR(G1H12(26),1,1,12)
call HGT_invQ_OLR(G1H12(26),2,5,12)
  call Hloop_A_Q(ntryL,G1H12(26),-16,nMB,G2H12(3),n2h12(49))
  call Hloop_AW_Q(ntryL,G2H12(3),ex5(:),G2H4(14),m3h3x4(:,19),heltab2x12(:,:,64))
  call Hloop_QV_A(ntryL,G1H12(28),wf4(:,1),G1H3(37),m3h4x3(:,24),heltab2x12(:,:,65))
  call Hloop_Q_A(ntryL,G1H3(37),47,nMT,G2H3(28),n2h3(58))
  call Hloop_QV_A(ntryL,G1H12(29),wf4(:,1),G1H3(38),m3h4x3(:,25),heltab2x12(:,:,66))
  call Hloop_Q_A(ntryL,G1H3(38),47,nMT,G2H3(29),n2h3(59))
  call Hloop_QV_A(ntryL,G0H12(5),wf4(:,1),G0H3(1),m3h4x3(:,26),heltab2x12(:,:,67))
  call Hloop_Q_A(ntryL,G0H3(1),47,nMT,G1H3(85),n2h3(60))
  call Hloop_AV_Q(ntryL,G1H12(30),wf4(:,1),G1H3(43),m3h4x3(:,27),heltab2x12(:,:,68))
  call Hloop_A_Q(ntryL,G1H3(43),47,nMB,G2H3(31),n2h3(61))
call HGT_OLR(G1H12(31),1,1,12)
call HGT_invQ_OLR(G1H12(31),2,5,12)
  call Hloop_Q_A(ntryL,G1H12(31),-16,nMT,G2H12(6),n2h12(50))
  call Hloop_QW_A(ntryL,G2H12(6),ex5(:),G2H4(15),m3h3x4(:,20),heltab2x12(:,:,69))
  call Hloop_AV_Q(ntryL,G1H12(33),wf4(:,1),G1H3(44),m3h4x3(:,28),heltab2x12(:,:,70))
  call Hloop_A_Q(ntryL,G1H3(44),47,nMB,G2H3(32),n2h3(62))
  call Hloop_AV_Q(ntryL,G1H12(34),wf4(:,1),G1H3(48),m3h4x3(:,29),heltab2x12(:,:,71))
  call Hloop_A_Q(ntryL,G1H3(48),47,nMB,G2H3(33),n2h3(63))
  call Hloop_AV_Q(ntryL,G0H12(6),wf4(:,1),G0H3(1),m3h4x3(:,30),heltab2x12(:,:,72))
  call Hloop_A_Q(ntryL,G0H3(1),47,nMB,G1H3(49),n2h3(64))
  call Hloop_QV_A(ntryL,G1H12(35),wf4(:,2),G1H3(50),m3h4x3(:,31),heltab2x12(:,:,73))
  call Hloop_Q_A(ntryL,G1H3(50),47,0,G2H3(34),n2h3(65))
call HGT_OLR(G1H12(36),1,1,12)
call HGT_invQ_OLR(G1H12(36),2,5,12)
  call Hloop_A_Q(ntryL,G1H12(36),-16,0,G2H12(7),n2h12(51))
  call Hloop_AW_Q(ntryL,G2H12(7),ex5(:),G2H4(16),m3h3x4(:,21),heltab2x12(:,:,74))
  call Hloop_QV_A(ntryL,G1H12(38),wf4(:,2),G1H3(54),m3h4x3(:,32),heltab2x12(:,:,75))
  call Hloop_Q_A(ntryL,G1H3(54),47,0,G2H3(35),n2h3(66))
  call Hloop_QV_A(ntryL,G1H12(39),wf4(:,2),G1H3(55),m3h4x3(:,33),heltab2x12(:,:,76))
  call Hloop_Q_A(ntryL,G1H3(55),47,0,G2H3(36),n2h3(67))
  call Hloop_QV_A(ntryL,G0H12(7),wf4(:,2),G0H3(1),m3h4x3(:,34),heltab2x12(:,:,77))
  call Hloop_Q_A(ntryL,G0H3(1),47,0,G1H3(56),n2h3(68))
  call Hloop_AV_Q(ntryL,G1H12(40),wf4(:,2),G1H3(60),m3h4x3(:,35),heltab2x12(:,:,78))
  call Hloop_A_Q(ntryL,G1H3(60),47,0,G2H3(37),n2h3(69))
call HGT_OLR(G1H12(41),1,1,12)
call HGT_invQ_OLR(G1H12(41),2,5,12)
  call Hloop_Q_A(ntryL,G1H12(41),-16,0,G2H12(4),n2h12(52))
  call Hloop_QW_A(ntryL,G2H12(4),ex5(:),G2H4(17),m3h3x4(:,22),heltab2x12(:,:,79))
  call Hloop_AV_Q(ntryL,G1H12(43),wf4(:,2),G1H3(61),m3h4x3(:,36),heltab2x12(:,:,80))
  call Hloop_A_Q(ntryL,G1H3(61),47,0,G2H3(38),n2h3(70))
  call Hloop_AV_Q(ntryL,G1H12(44),wf4(:,2),G1H3(62),m3h4x3(:,37),heltab2x12(:,:,81))
  call Hloop_A_Q(ntryL,G1H3(62),47,0,G2H3(39),n2h3(71))
  call Hloop_AV_Q(ntryL,G0H12(8),wf4(:,2),G0H3(1),m3h4x3(:,38),heltab2x12(:,:,82))
  call Hloop_A_Q(ntryL,G0H3(1),47,0,G1H3(66),n2h3(72))
  call Hloop_AV_Q(ntryL,G1H12(45),wf4(:,2),G1H3(67),m3h4x3(:,39),heltab2x12(:,:,83))
  call Hloop_A_Q(ntryL,G1H3(67),47,nMB,G2H3(40),n2h3(73))
call HGT_OLR(G1H12(46),1,1,12)
call HGT_invQ_OLR(G1H12(46),2,5,12)
  call Hloop_Q_A(ntryL,G1H12(46),-16,nMT,G2H12(1),n2h12(53))
  call Hloop_QW_A(ntryL,G2H12(1),ex5(:),G2H4(18),m3h3x4(:,23),heltab2x12(:,:,84))
  call Hloop_AV_Q(ntryL,G1H12(48),wf4(:,2),G1H3(68),m3h4x3(:,40),heltab2x12(:,:,85))
  call Hloop_A_Q(ntryL,G1H3(68),47,nMB,G2H3(41),n2h3(74))
  call Hloop_AV_Q(ntryL,G1H12(49),wf4(:,2),G1H3(90),m3h4x3(:,41),heltab2x12(:,:,86))
  call Hloop_A_Q(ntryL,G1H3(90),47,nMB,G2H3(42),n2h3(75))
  call Hloop_AV_Q(ntryL,G0H12(9),wf4(:,2),G0H3(1),m3h4x3(:,42),heltab2x12(:,:,87))
  call Hloop_A_Q(ntryL,G0H3(1),47,nMB,G1H3(73),n2h3(76))
  call Hloop_QW_A(ntryL,G1H12(50),ex5(:),G1H4(1),m3h3x4(:,24),heltab2x12(:,:,88))
  call Hloop_Q_A(ntryL,G1H4(1),51,0,G2H4(19),n2h4(27))
call HGT_OLR(G1H12(51),1,1,12)
call HGT_invQ_OLR(G1H12(51),2,5,12)
  call Hloop_A_Q(ntryL,G1H12(51),-12,0,G2H12(9),n2h12(54))
  call Hloop_AV_Q(ntryL,G2H12(9),wf4(:,2),G2H3(43),m3h4x3(:,43),heltab2x12(:,:,89))
  call Hloop_QW_A(ntryL,G1H12(53),ex5(:),G1H4(2),m3h3x4(:,25),heltab2x12(:,:,90))
  call Hloop_Q_A(ntryL,G1H4(2),51,0,G2H4(20),n2h4(28))
  call Hloop_QW_A(ntryL,G1H12(54),ex5(:),G1H4(12),m3h3x4(:,26),heltab2x12(:,:,91))
  call Hloop_Q_A(ntryL,G1H4(12),51,0,G2H4(21),n2h4(29))
  call Hloop_QW_A(ntryL,G0H12(10),ex5(:),G0H4(1),m3h3x4(:,27),heltab2x12(:,:,92))
  call Hloop_Q_A(ntryL,G0H4(1),51,0,G1H4(13),n2h4(30))
  call Hloop_AW_Q(ntryL,G1H12(55),ex5(:),G1H4(14),m3h3x4(:,28),heltab2x12(:,:,93))
  call Hloop_A_Q(ntryL,G1H4(14),51,0,G2H4(22),n2h4(31))
call HGT_OLR(G1H12(56),1,1,12)
call HGT_invQ_OLR(G1H12(56),2,5,12)
  call Hloop_Q_A(ntryL,G1H12(56),-12,0,G2H12(11),n2h12(55))
  call Hloop_QV_A(ntryL,G2H12(11),wf4(:,2),G2H3(44),m3h4x3(:,44),heltab2x12(:,:,94))
  call Hloop_AW_Q(ntryL,G1H12(58),ex5(:),G1H4(15),m3h3x4(:,29),heltab2x12(:,:,95))
  call Hloop_A_Q(ntryL,G1H4(15),51,0,G2H4(23),n2h4(32))
  call Hloop_AW_Q(ntryL,G1H12(59),ex5(:),G1H4(7),m3h3x4(:,30),heltab2x12(:,:,96))
  call Hloop_A_Q(ntryL,G1H4(7),51,0,G2H4(24),n2h4(33))
  call Hloop_AW_Q(ntryL,G0H12(11),ex5(:),G0H4(1),m3h3x4(:,31),heltab2x12(:,:,97))
  call Hloop_A_Q(ntryL,G0H4(1),51,0,G1H4(8),n2h4(34))
  call Hloop_AW_Q(ntryL,G1H12(60),ex5(:),G1H4(1),m3h3x4(:,32),heltab2x12(:,:,98))
  call Hloop_A_Q(ntryL,G1H4(1),51,nMT,G2H4(25),n2h4(35))
call HGT_OLR(G1H12(61),1,1,12)
call HGT_invQ_OLR(G1H12(61),2,5,12)
  call Hloop_Q_A(ntryL,G1H12(61),-12,nMT,G2H12(12),n2h12(56))
  call Hloop_QV_A(ntryL,G2H12(12),wf4(:,2),G2H3(45),m3h4x3(:,45),heltab2x12(:,:,99))
  call Hloop_AW_Q(ntryL,G1H12(63),ex5(:),G1H4(2),m3h3x4(:,33),heltab2x12(:,:,100))
  call Hloop_A_Q(ntryL,G1H4(2),51,nMT,G2H4(26),n2h4(36))
  call Hloop_AW_Q(ntryL,G1H12(64),ex5(:),G1H4(12),m3h3x4(:,34),heltab2x12(:,:,101))
  call Hloop_A_Q(ntryL,G1H4(12),51,nMT,G2H4(27),n2h4(37))
  call Hloop_AW_Q(ntryL,G0H12(12),ex5(:),G0H4(1),m3h3x4(:,35),heltab2x12(:,:,102))
  call Hloop_A_Q(ntryL,G0H4(1),51,nMT,G1H4(14),n2h4(38))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(1),[G2H2(10),G1H2(41)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(4),[G1H2(11),G1H2(5)])
call HGT_OLR(G2H2(12),1,1,2)
call HGT_invQ_OLR(G2H2(12),2,5,2)
call HGT_OLR(G2H2(12),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(12),[G2H2(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(7),[G2H3(20),G2H3(14),G1H3(99),G1H3(41),G1H3(18) &
    ,G1H3(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(23),[G1H2(17)])
call HGT_OLR(G2H2(13),1,1,2)
call HGT_invQ_OLR(G2H2(13),2,5,2)
call HGT_OLR(G2H2(13),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(13),[G1H2(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(9),[G2H3(30),G2H3(17),G1H3(132),G1H3(71),G1H3(21) &
    ,G1H3(9)])
call HGT_OLR(G2H2(14),1,1,2)
call HGT_invQ_OLR(G2H2(14),2,5,2)
call HGT_OLR(G2H2(14),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(14),[G2H2(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(37),[G2H3(23),G1H3(110)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(13),[G1H3(119)])
call HGT_OLR(G2H3(25),1,1,3)
call HGT_invQ_OLR(G2H3(25),2,5,3)
call HGT_OLR(G2H3(25),6,15,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(25),[G2H3(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(6),[G2H4(3),G1H4(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(26),[G2H3(27),G1H3(121)])
call HGT_OLR(G2H4(5),1,1,4)
call HGT_invQ_OLR(G2H4(5),2,5,4)
call HGT_OLR(G2H4(5),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(5),[G2H4(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(13),[G1H2(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(29),[G1H3(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(35),[G1H3(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(12),[G1H2(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(47),[G1H3(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(53),[G1H3(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(59),[G1H3(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(65),[G1H3(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(77),[G1H3(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(83),[G1H3(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(33),[G1H3(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(2),[G1H3(46),G1H3(39),G1H3(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(4),[G1H3(109),G1H3(52),G1H3(40),G1H3(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(51),[G1H3(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(63),[G1H3(57)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(6),[G1H3(76),G1H3(69),G1H3(58)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(8),[G1H3(120),G1H3(82),G1H3(70),G1H3(64)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(81),[G1H3(75)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(32),[G1H6(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(1),[G1H6(7),G1H6(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(28),[G1H6(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(12),[G1H6(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(2),[G1H6(31),G1H6(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(13),[G1H6(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(7),[G1H2(35),G1H2(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(6),[G1H2(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(5),[G1H2(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(115),[G1H3(88)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(105),[G1H3(89)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(126),[G1H3(93)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(138),[G1H3(94)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(1),[G1H3(97)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(10),[G1H3(98)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(11),[G1H3(104)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(3),[G1H3(108)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(39),[G1H3(116)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(4),[G1H4(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(9),[G1H4(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(11),[G1H4(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(29),[G1H3(127)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(5),[G1H3(130)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(15),[G1H3(131)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(19),[G1H3(137)])
  call Hotf_4pt_reduction(G2H2(1),RedSet_4(80),mass4set(:,1),  & 
G1H2(20),G1H2(24),G1H2(25),G1H2(26),G1H2(30),2)
  call HG1shiftOLR(G1H2(24),4,2)
  call Hotf_4pt_reduction(G2H2(12),RedSet_4(57),mass4set(:,1),  & 
G1H2(31),G1H2(32),G1H2(36),G1H2(37),G1H2(38),2)
  call HG1shiftOLR(G1H2(32),8,2)
  call Hotf_4pt_reduction(G2H3(7),RedSet_4(10),mass4set(:,1),  & 
G1H3(74),G1H3(78),G1H3(79),G1H3(80),G1H3(84),3)
  call HG1shiftOLR(G1H3(78),16,3)
  call Hotf_4pt_reduction(G2H2(13),RedSet_4(64),mass4set(:,9),  & 
G1H2(43),G1H2(44),G1H2(42),G1H2(1),G1H2(7),2)
  call HG1shiftOLR(G1H2(44),1,2)
  call Hotf_4pt_reduction(G2H3(9),RedSet_4(35),mass4set(:,3),  & 
G1H3(86),G1H3(91),G1H3(95),G1H3(96),G1H3(101),3)
  call HG1shiftOLR(G1H3(91),16,3)
call HGT_OLR(G2H4(1),1,1,4)
call HGT_invQ_OLR(G2H4(1),2,5,4)
call HGT_OLR(G2H4(1),6,15,4)
  call Hotf_4pt_reduction(G2H4(1),RedSet_4(96),mass4set(:,1),  & 
G1H4(15),G1H4(7),G1H4(1),G1H4(2),G1H4(12),4)
  call HG1shiftOLR(G1H4(7),3,4)
  call Hotf_4pt_reduction(G2H2(14),RedSet_4(97),mass4set(:,1),  & 
G1H2(8),G1H2(14),G1H2(18),G1H2(19),G1H2(41),2)
  call HG1shiftOLR(G1H2(14),8,2)
  call Hotf_4pt_reduction(G2H3(37),RedSet_4(86),mass4set(:,1),  & 
G1H3(102),G1H3(106),G1H3(107),G1H3(112),G1H3(113),3)
  call HG1shiftOLR(G1H3(106),16,3)
  call Hotf_4pt_reduction(G2H3(25),RedSet_4(91),mass4set(:,3),  & 
G1H3(117),G1H3(118),G1H3(123),G1H3(124),G1H3(128),3)
  call HG1shiftOLR(G1H3(118),16,3)
  call Hotf_4pt_reduction(G2H4(6),RedSet_4(89),mass4set(:,10),  & 
G1H4(5),G1H4(3),G1H4(4),G1H4(10),G1H4(16),4)
  call HG1shiftOLR(G1H4(3),12,4)
call HGT_OLR(G2H2(15),1,1,2)
call HGT_invQ_OLR(G2H2(15),2,5,2)
call HGT_OLR(G2H2(15),6,15,2)
  call Hotf_4pt_reduction(G2H2(15),RedSet_4(98),mass4set(:,11),  & 
G1H2(11),G1H2(5),G1H2(17),G1H2(23),G1H2(3),2)
  call HG1shiftOLR(G1H2(5),1,2)
  call Hotf_4pt_reduction(G2H3(26),RedSet_4(83),mass4set(:,6),  & 
G1H3(129),G1H3(134),G1H3(135),G1H3(42),G1H3(72),3)
  call HG1shiftOLR(G1H3(134),16,3)
  call Hotf_4pt_reduction(G2H4(5),RedSet_4(99),mass4set(:,12),  & 
G1H4(17),G1H4(18),G1H4(19),G1H4(20),G1H4(21),4)
  call HG1shiftOLR(G1H4(18),12,4)
  call Hloop_VA_Q(ntryL,G1H2(13),ex4(:),G1H1(1),m3h2x1(:,23),heltab2x2(:,:,23))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(2),n2h1(107))
  call Hloop_VA_Q(ntryL,G1H2(4),ex4(:),G1H1(1),m3h2x1(:,24),heltab2x2(:,:,24))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(4),n2h1(108))
  call Hloop_AW_Q(ntryL,G1H3(29),ex5(:),G1H1(1),m3h3x1(:,69),heltab2x3(:,:,69))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(6),n2h1(109))
  call Hloop_AW_Q(ntryL,G1H3(35),ex5(:),G1H1(1),m3h3x1(:,70),heltab2x3(:,:,70))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(8),n2h1(110))
  call Hloop_VA_Q(ntryL,G1H2(12),ex4(:),G1H1(1),m3h2x1(:,25),heltab2x2(:,:,25))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(1),n2h1(111))
  call Hloop_VA_Q(ntryL,G1H2(10),ex4(:),G1H1(1),m3h2x1(:,26),heltab2x2(:,:,26))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(11),n2h1(112))
  call Hloop_AW_Q(ntryL,G1H3(47),ex5(:),G1H1(1),m3h3x1(:,71),heltab2x3(:,:,71))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(17),n2h1(113))
  call Hloop_AW_Q(ntryL,G1H3(53),ex5(:),G1H1(1),m3h3x1(:,72),heltab2x3(:,:,72))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(23),n2h1(114))
  call Hloop_VQ_A(ntryL,G1H2(15),ex1(:),G1H1(1),m3h2x1(:,27),heltab2x2(:,:,27))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(29),n2h1(115))
  call Hloop_VQ_A(ntryL,G1H2(16),ex1(:),G1H1(1),m3h2x1(:,28),heltab2x2(:,:,28))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(32),n2h1(116))
  call Hloop_QW_A(ntryL,G1H3(59),ex5(:),G1H1(1),m3h3x1(:,73),heltab2x3(:,:,73))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(35),n2h1(117))
  call Hloop_QW_A(ntryL,G1H3(65),ex5(:),G1H1(1),m3h3x1(:,74),heltab2x3(:,:,74))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(7),n2h1(118))
  call Hloop_VQ_A(ntryL,G1H2(21),ex1(:),G1H1(1),m3h2x1(:,29),heltab2x2(:,:,29))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(38),n2h1(119))
  call Hloop_VQ_A(ntryL,G1H2(22),ex1(:),G1H1(1),m3h2x1(:,30),heltab2x2(:,:,30))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(41),n2h1(120))
  call Hloop_QW_A(ntryL,G1H3(77),ex5(:),G1H1(1),m3h3x1(:,75),heltab2x3(:,:,75))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(14),n2h1(121))
  call Hloop_QW_A(ntryL,G1H3(83),ex5(:),G1H1(1),m3h3x1(:,76),heltab2x3(:,:,76))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(44),n2h1(122))
  call Hloop_AW_Q(ntryL,G1H3(33),ex5(:),G1H1(1),m3h3x1(:,77),heltab2x3(:,:,77))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(47),n2h1(123))
  call Hotf_4pt_reduction(G2H3(2),RedSet_4(2),mass4set(:,1),  & 
G1H3(100),G1H3(111),G1H3(122),G1H3(133),G1H3(7),3)
  call HG1shiftOLR(G1H3(111),16,3)
  call Hotf_4pt_reduction(G2H3(4),RedSet_4(6),mass4set(:,1),  & 
G1H3(8),G1H3(20),G1H3(1),G1H3(24),G1H3(3),3)
  call HG1shiftOLR(G1H3(20),16,3)
  call Hloop_AW_Q(ntryL,G1H3(51),ex5(:),G1H1(1),m3h3x1(:,78),heltab2x3(:,:,78))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(50),n2h1(124))
  call Hloop_QW_A(ntryL,G1H3(63),ex5(:),G1H1(1),m3h3x1(:,79),heltab2x3(:,:,79))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(20),n2h1(125))
  call Hotf_4pt_reduction(G2H3(6),RedSet_4(27),mass4set(:,13),  & 
G1H3(4),G1H3(15),G1H3(16),G1H3(22),G1H3(26),3)
  call HG1shiftOLR(G1H3(15),16,3)
  call Hotf_4pt_reduction(G2H3(8),RedSet_4(31),mass4set(:,3),  & 
G1H3(30),G1H3(31),G1H3(36),G1H3(37),G1H3(38),3)
  call HG1shiftOLR(G1H3(31),16,3)
  call Hloop_QW_A(ntryL,G1H3(81),ex5(:),G1H1(1),m3h3x1(:,80),heltab2x3(:,:,80))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(53),n2h1(126))
  call Hloop_VQ_A(ntryL,G1H6(32),wf6(:,7),G1H1(1),m3h6x1(:,13),heltab2x6(:,:,59))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(56),n2h1(127))
  call Hloop_VQ_A(ntryL,G1H6(19),wf6(:,7),G1H1(1),m3h6x1(:,14),heltab2x6(:,:,60))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(26),n2h1(128))
  call Hotf_4pt_reduction(G2H6(1),RedSet_4(36),mass4set(:,2),  & 
G1H6(21),G1H6(14),G1H6(3),G1H6(16),G1H6(11),6)
  call HG1shiftOLR(G1H6(14),17,6)
  call Hloop_VQ_A(ntryL,G1H6(28),wf6(:,7),G1H1(1),m3h6x1(:,15),heltab2x6(:,:,61))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(59),n2h1(129))
  call Hloop_VQ_A(ntryL,G1H6(23),wf6(:,7),G1H1(1),m3h6x1(:,16),heltab2x6(:,:,62))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(62),n2h1(130))
  call Hloop_VA_Q(ntryL,G1H6(12),wf6(:,4),G1H1(1),m3h6x1(:,17),heltab2x6(:,:,63))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(65),n2h1(131))
  call Hloop_VA_Q(ntryL,G1H6(22),wf6(:,4),G1H1(1),m3h6x1(:,18),heltab2x6(:,:,64))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(68),n2h1(132))
  call Hotf_4pt_reduction(G2H6(2),RedSet_4(11),mass4set(:,1),  & 
G1H6(8),G1H6(24),G1H6(5),G1H6(9),G1H6(17),6)
  call HG1shiftOLR(G1H6(24),24,6)
  call Hloop_VA_Q(ntryL,G1H6(13),wf6(:,4),G1H1(1),m3h6x1(:,19),heltab2x6(:,:,65))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(71),n2h1(133))
  call Hloop_VA_Q(ntryL,G1H6(30),wf6(:,4),G1H1(1),m3h6x1(:,20),heltab2x6(:,:,66))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(74),n2h1(134))
  call Hloop_VA_Q(ntryL,G1H2(27),ex2(:),G1H1(1),m3h2x1(:,31),heltab2x2(:,:,31))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(77),n2h1(135))
  call Hloop_VA_Q(ntryL,G1H2(28),ex2(:),G1H1(1),m3h2x1(:,32),heltab2x2(:,:,32))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(83),n2h1(136))
  call Hotf_4pt_reduction(G2H2(7),RedSet_4(71),mass4set(:,9),  & 
G1H2(9),G1H2(35),G1H2(29),G1H2(39),G1H2(40),2)
  call HG1shiftOLR(G1H2(35),2,2)
  call Hloop_VA_Q(ntryL,G1H2(33),ex2(:),G1H1(1),m3h2x1(:,33),heltab2x2(:,:,33))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(87),n2h1(137))
  call Hloop_VA_Q(ntryL,G1H2(34),ex2(:),G1H1(1),m3h2x1(:,34),heltab2x2(:,:,34))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(91),n2h1(138))
  call Hotf_4pt_reduction(G2H2(6),RedSet_4(78),mass4set(:,1),  & 
G1H2(13),G1H2(4),G1H2(12),G1H2(10),G1H2(15),2)
  call HG1shiftOLR(G1H2(4),4,2)
  call Hotf_4pt_reduction(G2H2(5),RedSet_4(79),mass4set(:,1),  & 
G1H2(16),G1H2(21),G1H2(22),G1H2(27),G1H2(28),2)
  call HG1shiftOLR(G1H2(21),4,2)
  call Hloop_VQ_A(ntryL,G1H2(45),ex3(:),G1H1(1),m3h2x1(:,35),heltab2x2(:,:,35))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(95),n2h1(139))
  call Hloop_VQ_A(ntryL,G1H2(46),ex3(:),G1H1(1),m3h2x1(:,36),heltab2x2(:,:,36))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(99),n2h1(140))
  call Hloop_VQ_A(ntryL,G1H2(47),ex3(:),G1H1(1),m3h2x1(:,37),heltab2x2(:,:,37))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(103),n2h1(141))
  call Hloop_AW_Q(ntryL,G1H3(87),ex5(:),G1H1(1),m3h3x1(:,81),heltab2x3(:,:,81))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(104),n2h1(142))
  call Hloop_AW_Q(ntryL,G1H3(115),ex5(:),G1H1(1),m3h3x1(:,82),heltab2x3(:,:,82))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(105),n2h1(143))
  call Hloop_AW_Q(ntryL,G1H3(105),ex5(:),G1H1(1),m3h3x1(:,83),heltab2x3(:,:,83))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(106),n2h1(144))
  call Hloop_QW_A(ntryL,G1H3(92),ex5(:),G1H1(1),m3h3x1(:,84),heltab2x3(:,:,84))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(107),n2h1(145))
  call Hloop_QW_A(ntryL,G1H3(126),ex5(:),G1H1(1),m3h3x1(:,85),heltab2x3(:,:,85))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(108),n2h1(146))
  call Hloop_QW_A(ntryL,G1H3(138),ex5(:),G1H1(1),m3h3x1(:,86),heltab2x3(:,:,86))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(109),n2h1(147))
  call Hotf_4pt_reduction(G2H3(1),RedSet_4(82),mass4set(:,1),  & 
G1H3(43),G1H3(44),G1H3(48),G1H3(50),G1H3(54),3)
  call HG1shiftOLR(G1H3(44),16,3)
  call Hotf_4pt_reduction(G2H3(10),RedSet_4(83),mass4set(:,1),  & 
G1H3(55),G1H3(60),G1H3(61),G1H3(62),G1H3(67),3)
  call HG1shiftOLR(G1H3(60),16,3)
  call Hloop_AW_Q(ntryL,G1H3(103),ex5(:),G1H1(1),m3h3x1(:,87),heltab2x3(:,:,87))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(110),n2h1(148))
  call Hloop_AW_Q(ntryL,G2H3(11),ex5(:),G2H1(1),m3h3x1(:,88),heltab2x3(:,:,88))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),63,0,G3tensor(1),n2h1(149))
  call Hotf_4pt_reduction(G2H3(3),RedSet_4(85),mass4set(:,1),  & 
G1H3(68),G1H3(90),G1H3(99),G1H3(41),G1H3(18),3)
  call HG1shiftOLR(G1H3(90),16,3)
  call Hloop_AW_Q(ntryL,G1H3(114),ex5(:),G1H1(1),m3h3x1(:,89),heltab2x3(:,:,89))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(111),n2h1(150))
  call Hloop_AW_Q(ntryL,G2H3(39),ex5(:),G2H1(1),m3h3x1(:,90),heltab2x3(:,:,90))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),63,0,G3tensor(2),n2h1(151))
  call Hotf_4pt_reduction(G2H4(4),RedSet_4(88),mass4set(:,14),  & 
G1H4(22),G1H4(23),G1H4(24),G1H4(25),G1H4(26),4)
  call HG1shiftOLR(G1H4(23),12,4)
  call Hotf_4pt_reduction(G2H4(9),RedSet_4(50),mass4set(:,5),  & 
G1H4(27),G1H4(28),G1H4(29),G1H4(30),G1H4(31),4)
  call HG1shiftOLR(G1H4(28),12,4)
  call Hloop_QV_A(ntryL,G1H4(9),wf4(:,2),G1H1(1),m3h4x1(:,5),heltab2x4(:,:,24))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(112),n2h1(152))
  call Hloop_QV_A(ntryL,G2H4(11),wf4(:,2),G2H1(1),m3h4x1(:,6),heltab2x4(:,:,25))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),63,nMB,G3tensor(3),n2h1(153))
  call Hloop_QV_A(ntryL,G1H4(11),wf4(:,2),G1H1(1),m3h4x1(:,7),heltab2x4(:,:,26))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(113),n2h1(154))
  call Hloop_QW_A(ntryL,G1H3(125),ex5(:),G1H1(1),m3h3x1(:,91),heltab2x3(:,:,91))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(114),n2h1(155))
  call Hloop_QW_A(ntryL,G2H3(29),ex5(:),G2H1(1),m3h3x1(:,92),heltab2x3(:,:,92))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),63,nMB,G3tensor(4),n2h1(156))
  call Hotf_4pt_reduction(G2H3(5),RedSet_4(93),mass4set(:,15),  & 
G1H3(19),G1H3(132),G1H3(71),G1H3(21),G1H3(9),3)
  call HG1shiftOLR(G1H3(132),16,3)
  call Hotf_4pt_reduction(G2H3(15),RedSet_4(86),mass4set(:,6),  & 
G1H3(110),G1H3(119),G1H3(121),G1H3(13),G1H3(14),3)
  call HG1shiftOLR(G1H3(119),16,3)
  call Hloop_QW_A(ntryL,G1H3(136),ex5(:),G1H1(1),m3h3x1(:,93),heltab2x3(:,:,93))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(115),n2h1(157))
  call Hloop_QW_A(ntryL,G2H3(19),ex5(:),G2H1(1),m3h3x1(:,94),heltab2x3(:,:,94))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),63,nMB,G3tensor(5),n2h1(158))
  call Hotf_4pt_reduction(G2H6(4),RedSet_4(52),mass4set(:,1),  & 
G1H6(1),G1H6(4),G1H6(6),G1H6(26),G1H6(27),6)
  call HG1shiftOLR(G1H6(4),24,6)
  call Hotf_4pt_reduction(G2H2(3),RedSet_4(100),mass4set(:,1),  & 
G1H2(33),G1H2(34),G1H2(45),G1H2(46),G1H2(47),2)
  call HG1shiftOLR(G1H2(34),4,2)
  call Hotf_4pt_reduction(G2H6(3),RedSet_4(54),mass4set(:,4),  & 
G1H6(18),G1H6(7),G1H6(20),G1H6(15),G1H6(2),6)
  call HG1shiftOLR(G1H6(7),17,6)
  call Hotf_4pt_reduction(G2H4(8),RedSet_4(101),mass4set(:,12),  & 
G1H4(9),G1H4(11),G1H4(32),G1H4(33),G1H4(34),4)
  call HG1shiftOLR(G1H4(11),12,4)
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(8),ex4(:),G2tensor(116),m3h2x1(:,38),heltab2x2(:,:,38))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(9),ex3(:),G2tensor(117),m3h2x1(:,39),heltab2x2(:,:,39))
  call Hloop_VQ_A(ntryL,G1H2(2),ex3(:),G1H1(1),m3h2x1(:,40),heltab2x2(:,:,40))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(118),n2h1(159))
  call Hloop_VQ_A(ntryL,G1H2(6),ex3(:),G1H1(1),m3h2x1(:,41),heltab2x2(:,:,41))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(119),n2h1(160))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(11),ex4(:),G2tensor(120),m3h2x1(:,42),heltab2x2(:,:,42))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(16),ex3(:),G2tensor(121),m3h2x1(:,43),heltab2x2(:,:,43))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(17),ex4(:),G2tensor(122),m3h2x1(:,44),heltab2x2(:,:,44))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(19),ex4(:),G2tensor(123),m3h2x1(:,45),heltab2x2(:,:,45))
  call Hloop_AW_Q(ntryL,G1H3(10),ex5(:),G1H1(1),m3h3x1(:,95),heltab2x3(:,:,95))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(124),n2h1(161))
  call Hloop_QV_A(ntryL,G1H4(6),wf4(:,2),G1H1(1),m3h4x1(:,8),heltab2x4(:,:,27))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(125),n2h1(162))
  call Hloop_QW_A(ntryL,G1H3(25),ex5(:),G1H1(1),m3h3x1(:,96),heltab2x3(:,:,96))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(126),n2h1(163))
  call Hotf_4pt_reduction(G2H3(21),RedSet_4(83),mass4set(:,1),  & 
G1H3(6),G1H3(12),G1H3(11),G1H3(5),G1H3(23),3)
  call HG1shiftOLR(G1H3(12),16,3)
  call Hloop_QW_A(ntryL,G2H3(24),ex5(:),G2H1(1),m3h3x1(:,97),heltab2x3(:,:,97))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),63,0,G3tensor(6),n2h1(164))
  call Hloop_QW_A(ntryL,G1H3(32),ex5(:),G1H1(1),m3h3x1(:,98),heltab2x3(:,:,98))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(127),n2h1(165))
  call Hloop_QW_A(ntryL,G1H3(85),ex5(:),G1H1(1),m3h3x1(:,99),heltab2x3(:,:,99))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(128),n2h1(166))
  call Hotf_4pt_reduction(G2H3(31),RedSet_4(83),mass4set(:,7),  & 
G1H3(17),G1H3(27),G1H3(46),G1H3(39),G1H3(28),3)
  call HG1shiftOLR(G1H3(27),16,3)
  call Hloop_AW_Q(ntryL,G2H3(33),ex5(:),G2H1(1),m3h3x1(:,100),heltab2x3(:,:,100))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),63,nMT,G3tensor(7),n2h1(167))
  call Hloop_AW_Q(ntryL,G1H3(49),ex5(:),G1H1(1),m3h3x1(:,101),heltab2x3(:,:,101))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(129),n2h1(168))
  call Hotf_4pt_reduction(G2H3(34),RedSet_4(86),mass4set(:,1),  & 
G1H3(109),G1H3(52),G1H3(40),G1H3(34),G1H3(45),3)
  call HG1shiftOLR(G1H3(52),16,3)
  call Hloop_QW_A(ntryL,G2H3(36),ex5(:),G2H1(1),m3h3x1(:,102),heltab2x3(:,:,102))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),63,0,G3tensor(8),n2h1(169))
  call Hloop_QW_A(ntryL,G1H3(56),ex5(:),G1H1(1),m3h3x1(:,103),heltab2x3(:,:,103))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(130),n2h1(170))
  call Hloop_AW_Q(ntryL,G1H3(66),ex5(:),G1H1(1),m3h3x1(:,104),heltab2x3(:,:,104))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(131),n2h1(171))
  call Hotf_4pt_reduction(G2H3(40),RedSet_4(86),mass4set(:,7),  & 
G1H3(57),G1H3(76),G1H3(69),G1H3(58),G1H3(120),3)
  call HG1shiftOLR(G1H3(76),16,3)
  call Hloop_AW_Q(ntryL,G2H3(42),ex5(:),G2H1(1),m3h3x1(:,105),heltab2x3(:,:,105))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),63,nMT,G3tensor(9),n2h1(172))
  call Hloop_AW_Q(ntryL,G1H3(73),ex5(:),G1H1(1),m3h3x1(:,106),heltab2x3(:,:,106))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(132),n2h1(173))
  call Hotf_4pt_reduction(G2H4(19),RedSet_4(50),mass4set(:,1),  & 
G1H4(6),G1H4(35),G1H4(36),G1H4(37),G1H4(38),4)
  call HG1shiftOLR(G1H4(35),12,4)
  call Hloop_QV_A(ntryL,G2H4(21),wf4(:,2),G2H1(1),m3h4x1(:,9),heltab2x4(:,:,28))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),63,0,G3tensor(10),n2h1(174))
  call Hloop_QV_A(ntryL,G1H4(13),wf4(:,2),G1H1(1),m3h4x1(:,10),heltab2x4(:,:,29))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(133),n2h1(175))
  call Hotf_4pt_reduction(G2H4(22),RedSet_4(50),mass4set(:,1),  & 
G1H4(13),G1H4(39),G1H4(40),G1H4(41),G1H4(42),4)
  call HG1shiftOLR(G1H4(39),12,4)
  call Hloop_AV_Q(ntryL,G2H4(24),wf4(:,2),G2H1(1),m3h4x1(:,11),heltab2x4(:,:,30))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),63,0,G3tensor(11),n2h1(176))
  call Hloop_AV_Q(ntryL,G1H4(8),wf4(:,2),G1H1(1),m3h4x1(:,12),heltab2x4(:,:,31))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(134),n2h1(177))
  call Hotf_4pt_reduction(G2H4(25),RedSet_4(50),mass4set(:,8),  & 
G1H4(8),G1H4(43),G1H4(44),G1H4(45),G1H4(46),4)
  call HG1shiftOLR(G1H4(43),12,4)
  call Hloop_AV_Q(ntryL,G2H4(27),wf4(:,2),G2H1(1),m3h4x1(:,13),heltab2x4(:,:,32))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),63,nMT,G3tensor(12),n2h1(178))
  call Hloop_AV_Q(ntryL,G1H4(14),wf4(:,2),G1H1(1),m3h4x1(:,14),heltab2x4(:,:,33))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(135),n2h1(179))
  call Hloop_VQ_A(ntryL,G1H2(20),ex3(:),G1H1(1),m3h2x1(:,46),heltab2x2(:,:,46))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(136),n2h1(180))
  call Hloop_VQ_A(ntryL,G1H2(24),ex3(:),G1H1(1),m3h2x1(:,47),heltab2x2(:,:,47))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(137),n2h1(181))
  call Hloop_VQ_A(ntryL,G1H2(30),ex3(:),G1H1(1),m3h2x1(:,48),heltab2x2(:,:,48))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(138),n2h1(182))
  call Hloop_VA_Q(ntryL,G1H2(31),ex4(:),G1H1(1),m3h2x1(:,49),heltab2x2(:,:,49))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(139),n2h1(183))
  call Hloop_VA_Q(ntryL,G1H2(32),ex4(:),G1H1(1),m3h2x1(:,50),heltab2x2(:,:,50))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(140),n2h1(184))
  call Hloop_VA_Q(ntryL,G1H2(38),ex4(:),G1H1(1),m3h2x1(:,51),heltab2x2(:,:,51))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(141),n2h1(185))
  call Hloop_AW_Q(ntryL,G1H3(74),ex5(:),G1H1(1),m3h3x1(:,107),heltab2x3(:,:,107))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(142),n2h1(186))
  call Hloop_AW_Q(ntryL,G1H3(78),ex5(:),G1H1(1),m3h3x1(:,108),heltab2x3(:,:,108))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(143),n2h1(187))
  call Hloop_AW_Q(ntryL,G1H3(84),ex5(:),G1H1(1),m3h3x1(:,109),heltab2x3(:,:,109))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(144),n2h1(188))
  call Hloop_VQ_A(ntryL,G1H2(43),ex1(:),G1H1(1),m3h2x1(:,52),heltab2x2(:,:,52))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(145),n2h1(189))
  call Hloop_VQ_A(ntryL,G1H2(44),ex1(:),G1H1(1),m3h2x1(:,53),heltab2x2(:,:,53))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),1,nMT,G2tensor(146),n2h1(190))
  call Hloop_VQ_A(ntryL,G1H2(7),ex1(:),G1H1(1),m3h2x1(:,54),heltab2x2(:,:,54))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(147),n2h1(191))
  call Hloop_QW_A(ntryL,G1H3(86),ex5(:),G1H1(1),m3h3x1(:,110),heltab2x3(:,:,110))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(148),n2h1(192))
  call Hloop_QW_A(ntryL,G1H3(91),ex5(:),G1H1(1),m3h3x1(:,111),heltab2x3(:,:,111))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(149),n2h1(193))
  call Hloop_QW_A(ntryL,G1H3(101),ex5(:),G1H1(1),m3h3x1(:,112),heltab2x3(:,:,112))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(150),n2h1(194))
  call Hloop_AV_Q(ntryL,G1H4(15),wf4(:,1),G1H1(1),m3h4x1(:,15),heltab2x4(:,:,34))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(151),n2h1(195))
  call Hloop_AV_Q(ntryL,G1H4(7),wf4(:,1),G1H1(1),m3h4x1(:,16),heltab2x4(:,:,35))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),3,0,G2tensor(152),n2h1(196))
  call Hloop_AV_Q(ntryL,G1H4(12),wf4(:,1),G1H1(1),m3h4x1(:,17),heltab2x4(:,:,36))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(153),n2h1(197))
  call Hloop_VA_Q(ntryL,G1H2(8),ex4(:),G1H1(1),m3h2x1(:,55),heltab2x2(:,:,55))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(154),n2h1(198))
  call Hloop_VA_Q(ntryL,G1H2(14),ex4(:),G1H1(1),m3h2x1(:,56),heltab2x2(:,:,56))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(155),n2h1(199))
  call Hloop_VA_Q(ntryL,G1H2(41),ex4(:),G1H1(1),m3h2x1(:,57),heltab2x2(:,:,57))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(156),n2h1(200))
  call Hloop_AW_Q(ntryL,G1H3(102),ex5(:),G1H1(1),m3h3x1(:,113),heltab2x3(:,:,113))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(157),n2h1(201))
  call Hloop_AW_Q(ntryL,G1H3(106),ex5(:),G1H1(1),m3h3x1(:,114),heltab2x3(:,:,114))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(158),n2h1(202))
  call Hloop_AW_Q(ntryL,G1H3(113),ex5(:),G1H1(1),m3h3x1(:,115),heltab2x3(:,:,115))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(159),n2h1(203))
  call Hloop_QW_A(ntryL,G1H3(117),ex5(:),G1H1(1),m3h3x1(:,116),heltab2x3(:,:,116))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(160),n2h1(204))
  call Hloop_QW_A(ntryL,G1H3(118),ex5(:),G1H1(1),m3h3x1(:,117),heltab2x3(:,:,117))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(161),n2h1(205))
  call Hloop_QW_A(ntryL,G1H3(128),ex5(:),G1H1(1),m3h3x1(:,118),heltab2x3(:,:,118))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(162),n2h1(206))
  call Hloop_QV_A(ntryL,G1H4(5),wf4(:,2),G1H1(1),m3h4x1(:,18),heltab2x4(:,:,37))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(163),n2h1(207))
  call Hloop_QV_A(ntryL,G1H4(3),wf4(:,2),G1H1(1),m3h4x1(:,19),heltab2x4(:,:,38))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,nMB,G2tensor(164),n2h1(208))
  call Hloop_QV_A(ntryL,G1H4(16),wf4(:,2),G1H1(1),m3h4x1(:,20),heltab2x4(:,:,39))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(165),n2h1(209))
  call Hloop_VQ_A(ntryL,G1H2(11),ex1(:),G1H1(1),m3h2x1(:,58),heltab2x2(:,:,58))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(166),n2h1(210))
  call Hloop_VQ_A(ntryL,G1H2(5),ex1(:),G1H1(1),m3h2x1(:,59),heltab2x2(:,:,59))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),1,nMT,G2tensor(167),n2h1(211))
  call Hloop_VQ_A(ntryL,G1H2(3),ex1(:),G1H1(1),m3h2x1(:,60),heltab2x2(:,:,60))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(168),n2h1(212))
  call Hloop_QW_A(ntryL,G1H3(129),ex5(:),G1H1(1),m3h3x1(:,119),heltab2x3(:,:,119))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(169),n2h1(213))
  call Hloop_QW_A(ntryL,G1H3(134),ex5(:),G1H1(1),m3h3x1(:,120),heltab2x3(:,:,120))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(170),n2h1(214))
  call Hloop_QW_A(ntryL,G1H3(72),ex5(:),G1H1(1),m3h3x1(:,121),heltab2x3(:,:,121))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(171),n2h1(215))
  call Hloop_QV_A(ntryL,G1H4(17),wf4(:,2),G1H1(1),m3h4x1(:,21),heltab2x4(:,:,40))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(172),n2h1(216))
  call Hloop_QV_A(ntryL,G1H4(18),wf4(:,2),G1H1(1),m3h4x1(:,22),heltab2x4(:,:,41))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,nMT,G2tensor(173),n2h1(217))
  call Hloop_QV_A(ntryL,G1H4(21),wf4(:,2),G1H1(1),m3h4x1(:,23),heltab2x4(:,:,42))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(174),n2h1(218))
  call Hloop_AW_Q(ntryL,G1H3(100),ex5(:),G1H1(1),m3h3x1(:,122),heltab2x3(:,:,122))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(175),n2h1(219))
  call Hloop_AW_Q(ntryL,G1H3(111),ex5(:),G1H1(1),m3h3x1(:,123),heltab2x3(:,:,123))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(176),n2h1(220))
  call Hloop_AW_Q(ntryL,G1H3(7),ex5(:),G1H1(1),m3h3x1(:,124),heltab2x3(:,:,124))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(177),n2h1(221))
  call Hloop_AW_Q(ntryL,G1H3(8),ex5(:),G1H1(1),m3h3x1(:,125),heltab2x3(:,:,125))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(178),n2h1(222))
  call Hloop_AW_Q(ntryL,G1H3(20),ex5(:),G1H1(1),m3h3x1(:,126),heltab2x3(:,:,126))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(179),n2h1(223))
  call Hloop_AW_Q(ntryL,G1H3(3),ex5(:),G1H1(1),m3h3x1(:,127),heltab2x3(:,:,127))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(180),n2h1(224))
  call Hloop_QW_A(ntryL,G1H3(4),ex5(:),G1H1(1),m3h3x1(:,128),heltab2x3(:,:,128))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(181),n2h1(225))
  call Hloop_QW_A(ntryL,G1H3(15),ex5(:),G1H1(1),m3h3x1(:,129),heltab2x3(:,:,129))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(182),n2h1(226))
  call Hloop_QW_A(ntryL,G1H3(26),ex5(:),G1H1(1),m3h3x1(:,130),heltab2x3(:,:,130))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(183),n2h1(227))
  call Hloop_QW_A(ntryL,G1H3(30),ex5(:),G1H1(1),m3h3x1(:,131),heltab2x3(:,:,131))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(184),n2h1(228))
  call Hloop_QW_A(ntryL,G1H3(31),ex5(:),G1H1(1),m3h3x1(:,132),heltab2x3(:,:,132))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(185),n2h1(229))
  call Hloop_QW_A(ntryL,G1H3(38),ex5(:),G1H1(1),m3h3x1(:,133),heltab2x3(:,:,133))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(186),n2h1(230))
  call Hloop_VQ_A(ntryL,G1H6(21),wf6(:,7),G1H1(1),m3h6x1(:,21),heltab2x6(:,:,67))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(187),n2h1(231))
  call Hloop_VQ_A(ntryL,G1H6(14),wf6(:,7),G1H1(1),m3h6x1(:,22),heltab2x6(:,:,68))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),17,nMB,G2tensor(188),n2h1(232))
  call Hloop_VQ_A(ntryL,G1H6(11),wf6(:,7),G1H1(1),m3h6x1(:,23),heltab2x6(:,:,69))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(189),n2h1(233))
  call Hloop_VA_Q(ntryL,G1H6(8),wf6(:,4),G1H1(1),m3h6x1(:,24),heltab2x6(:,:,70))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(190),n2h1(234))
  call Hloop_VA_Q(ntryL,G1H6(24),wf6(:,4),G1H1(1),m3h6x1(:,25),heltab2x6(:,:,71))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),24,0,G2tensor(191),n2h1(235))
  call Hloop_VA_Q(ntryL,G1H6(17),wf6(:,4),G1H1(1),m3h6x1(:,26),heltab2x6(:,:,72))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(192),n2h1(236))
  call Hloop_VA_Q(ntryL,G1H2(9),ex2(:),G1H1(1),m3h2x1(:,61),heltab2x2(:,:,61))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(193),n2h1(237))
  call Hloop_VA_Q(ntryL,G1H2(35),ex2(:),G1H1(1),m3h2x1(:,62),heltab2x2(:,:,62))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMT,G2tensor(194),n2h1(238))
  call Hloop_VA_Q(ntryL,G1H2(40),ex2(:),G1H1(1),m3h2x1(:,63),heltab2x2(:,:,63))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(195),n2h1(239))
  call Hloop_VQ_A(ntryL,G1H2(13),ex3(:),G1H1(1),m3h2x1(:,64),heltab2x2(:,:,64))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(196),n2h1(240))
  call Hloop_VQ_A(ntryL,G1H2(4),ex3(:),G1H1(1),m3h2x1(:,65),heltab2x2(:,:,65))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(197),n2h1(241))
  call Hloop_VQ_A(ntryL,G1H2(15),ex3(:),G1H1(1),m3h2x1(:,66),heltab2x2(:,:,66))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(198),n2h1(242))
  call Hloop_VQ_A(ntryL,G1H2(16),ex3(:),G1H1(1),m3h2x1(:,67),heltab2x2(:,:,67))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(199),n2h1(243))
  call Hloop_VQ_A(ntryL,G1H2(21),ex3(:),G1H1(1),m3h2x1(:,68),heltab2x2(:,:,68))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(200),n2h1(244))
  call Hloop_VQ_A(ntryL,G1H2(28),ex3(:),G1H1(1),m3h2x1(:,69),heltab2x2(:,:,69))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(201),n2h1(245))
  call Hloop_AW_Q(ntryL,G1H3(43),ex5(:),G1H1(1),m3h3x1(:,134),heltab2x3(:,:,134))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(202),n2h1(246))
  call Hloop_AW_Q(ntryL,G1H3(44),ex5(:),G1H1(1),m3h3x1(:,135),heltab2x3(:,:,135))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(203),n2h1(247))
  call Hloop_AW_Q(ntryL,G1H3(54),ex5(:),G1H1(1),m3h3x1(:,136),heltab2x3(:,:,136))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(204),n2h1(248))
  call Hloop_AW_Q(ntryL,G1H3(55),ex5(:),G1H1(1),m3h3x1(:,137),heltab2x3(:,:,137))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(205),n2h1(249))
  call Hloop_AW_Q(ntryL,G1H3(60),ex5(:),G1H1(1),m3h3x1(:,138),heltab2x3(:,:,138))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(206),n2h1(250))
  call Hloop_AW_Q(ntryL,G1H3(67),ex5(:),G1H1(1),m3h3x1(:,139),heltab2x3(:,:,139))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(207),n2h1(251))
  call Hloop_AW_Q(ntryL,G1H3(68),ex5(:),G1H1(1),m3h3x1(:,140),heltab2x3(:,:,140))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(208),n2h1(252))
  call Hloop_AW_Q(ntryL,G1H3(90),ex5(:),G1H1(1),m3h3x1(:,141),heltab2x3(:,:,141))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(209),n2h1(253))
  call Hloop_AW_Q(ntryL,G1H3(18),ex5(:),G1H1(1),m3h3x1(:,142),heltab2x3(:,:,142))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(210),n2h1(254))
  call Hloop_QV_A(ntryL,G1H4(22),wf4(:,2),G1H1(1),m3h4x1(:,24),heltab2x4(:,:,43))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(211),n2h1(255))
  call Hloop_QV_A(ntryL,G1H4(23),wf4(:,2),G1H1(1),m3h4x1(:,25),heltab2x4(:,:,44))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,nMB,G2tensor(212),n2h1(256))
  call Hloop_QV_A(ntryL,G1H4(26),wf4(:,2),G1H1(1),m3h4x1(:,26),heltab2x4(:,:,45))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(213),n2h1(257))
  call Hloop_QV_A(ntryL,G1H4(27),wf4(:,2),G1H1(1),m3h4x1(:,27),heltab2x4(:,:,46))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(214),n2h1(258))
  call Hloop_QV_A(ntryL,G1H4(28),wf4(:,2),G1H1(1),m3h4x1(:,28),heltab2x4(:,:,47))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,nMB,G2tensor(215),n2h1(259))
  call Hloop_QV_A(ntryL,G1H4(31),wf4(:,2),G1H1(1),m3h4x1(:,29),heltab2x4(:,:,48))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(216),n2h1(260))
  call Hloop_QW_A(ntryL,G1H3(19),ex5(:),G1H1(1),m3h3x1(:,143),heltab2x3(:,:,143))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(217),n2h1(261))
  call Hloop_QW_A(ntryL,G1H3(132),ex5(:),G1H1(1),m3h3x1(:,144),heltab2x3(:,:,144))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(218),n2h1(262))
  call Hloop_QW_A(ntryL,G1H3(9),ex5(:),G1H1(1),m3h3x1(:,145),heltab2x3(:,:,145))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(219),n2h1(263))
  call Hloop_QW_A(ntryL,G1H3(110),ex5(:),G1H1(1),m3h3x1(:,146),heltab2x3(:,:,146))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(220),n2h1(264))
  call Hloop_QW_A(ntryL,G1H3(119),ex5(:),G1H1(1),m3h3x1(:,147),heltab2x3(:,:,147))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(221),n2h1(265))
  call Hloop_QW_A(ntryL,G1H3(14),ex5(:),G1H1(1),m3h3x1(:,148),heltab2x3(:,:,148))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(222),n2h1(266))
  call Hloop_VA_Q(ntryL,G1H6(1),wf6(:,4),G1H1(1),m3h6x1(:,27),heltab2x6(:,:,73))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(223),n2h1(267))
  call Hloop_VA_Q(ntryL,G1H6(4),wf6(:,4),G1H1(1),m3h6x1(:,28),heltab2x6(:,:,74))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),24,0,G2tensor(224),n2h1(268))
  call Hloop_VA_Q(ntryL,G1H6(27),wf6(:,4),G1H1(1),m3h6x1(:,29),heltab2x6(:,:,75))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(225),n2h1(269))
  call Hloop_VQ_A(ntryL,G1H2(33),ex3(:),G1H1(1),m3h2x1(:,70),heltab2x2(:,:,70))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(226),n2h1(270))
  call Hloop_VQ_A(ntryL,G1H2(34),ex3(:),G1H1(1),m3h2x1(:,71),heltab2x2(:,:,71))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(227),n2h1(271))
  call Hloop_VQ_A(ntryL,G1H2(47),ex3(:),G1H1(1),m3h2x1(:,72),heltab2x2(:,:,72))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(228),n2h1(272))
  call Hloop_VQ_A(ntryL,G1H6(18),wf6(:,7),G1H1(1),m3h6x1(:,30),heltab2x6(:,:,76))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(229),n2h1(273))
  call Hloop_VQ_A(ntryL,G1H6(7),wf6(:,7),G1H1(1),m3h6x1(:,31),heltab2x6(:,:,77))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),17,nMB,G2tensor(230),n2h1(274))
  call Hloop_VQ_A(ntryL,G1H6(2),wf6(:,7),G1H1(1),m3h6x1(:,32),heltab2x6(:,:,78))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(231),n2h1(275))
  call Hloop_AV_Q(ntryL,G1H4(9),wf4(:,2),G1H1(1),m3h4x1(:,30),heltab2x4(:,:,49))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(232),n2h1(276))
  call Hloop_AV_Q(ntryL,G1H4(11),wf4(:,2),G1H1(1),m3h4x1(:,31),heltab2x4(:,:,50))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,nMT,G2tensor(233),n2h1(277))
  call Hloop_AV_Q(ntryL,G1H4(34),wf4(:,2),G1H1(1),m3h4x1(:,32),heltab2x4(:,:,51))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(234),n2h1(278))
  call Hloop_QW_A(ntryL,G1H3(6),ex5(:),G1H1(1),m3h3x1(:,149),heltab2x3(:,:,149))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(235),n2h1(279))
  call Hloop_QW_A(ntryL,G1H3(12),ex5(:),G1H1(1),m3h3x1(:,150),heltab2x3(:,:,150))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(236),n2h1(280))
  call Hloop_QW_A(ntryL,G1H3(23),ex5(:),G1H1(1),m3h3x1(:,151),heltab2x3(:,:,151))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(237),n2h1(281))
  call Hloop_AW_Q(ntryL,G1H3(17),ex5(:),G1H1(1),m3h3x1(:,152),heltab2x3(:,:,152))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(238),n2h1(282))
  call Hloop_AW_Q(ntryL,G1H3(27),ex5(:),G1H1(1),m3h3x1(:,153),heltab2x3(:,:,153))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nMT,G2tensor(239),n2h1(283))
  call Hloop_AW_Q(ntryL,G1H3(28),ex5(:),G1H1(1),m3h3x1(:,154),heltab2x3(:,:,154))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(240),n2h1(284))
  call Hloop_QW_A(ntryL,G1H3(109),ex5(:),G1H1(1),m3h3x1(:,155),heltab2x3(:,:,155))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(241),n2h1(285))
  call Hloop_QW_A(ntryL,G1H3(52),ex5(:),G1H1(1),m3h3x1(:,156),heltab2x3(:,:,156))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(242),n2h1(286))
  call Hloop_QW_A(ntryL,G1H3(45),ex5(:),G1H1(1),m3h3x1(:,157),heltab2x3(:,:,157))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(243),n2h1(287))
  call Hloop_AW_Q(ntryL,G1H3(57),ex5(:),G1H1(1),m3h3x1(:,158),heltab2x3(:,:,158))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(244),n2h1(288))
  call Hloop_AW_Q(ntryL,G1H3(76),ex5(:),G1H1(1),m3h3x1(:,159),heltab2x3(:,:,159))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nMT,G2tensor(245),n2h1(289))
  call Hloop_AW_Q(ntryL,G1H3(120),ex5(:),G1H1(1),m3h3x1(:,160),heltab2x3(:,:,160))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(246),n2h1(290))
  call Hloop_QV_A(ntryL,G1H4(6),wf4(:,2),G1H1(1),m3h4x1(:,33),heltab2x4(:,:,52))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(247),n2h1(291))
  call Hloop_QV_A(ntryL,G1H4(35),wf4(:,2),G1H1(1),m3h4x1(:,34),heltab2x4(:,:,53))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(248),n2h1(292))
  call Hloop_QV_A(ntryL,G1H4(38),wf4(:,2),G1H1(1),m3h4x1(:,35),heltab2x4(:,:,54))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(249),n2h1(293))
  call Hloop_AV_Q(ntryL,G1H4(13),wf4(:,2),G1H1(1),m3h4x1(:,36),heltab2x4(:,:,55))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(250),n2h1(294))
  call Hloop_AV_Q(ntryL,G1H4(39),wf4(:,2),G1H1(1),m3h4x1(:,37),heltab2x4(:,:,56))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,0,G2tensor(251),n2h1(295))
  call Hloop_AV_Q(ntryL,G1H4(42),wf4(:,2),G1H1(1),m3h4x1(:,38),heltab2x4(:,:,57))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(252),n2h1(296))
  call Hloop_AV_Q(ntryL,G1H4(8),wf4(:,2),G1H1(1),m3h4x1(:,39),heltab2x4(:,:,58))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(253),n2h1(297))
  call Hloop_AV_Q(ntryL,G1H4(43),wf4(:,2),G1H1(1),m3h4x1(:,40),heltab2x4(:,:,59))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,nMT,G2tensor(254),n2h1(298))
  call Hloop_AV_Q(ntryL,G1H4(46),wf4(:,2),G1H1(1),m3h4x1(:,41),heltab2x4(:,:,60))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(255),n2h1(299))
  call ol_merge_tensors(G2tensor(66),[G2tensor(3),G1tensor(122),G1tensor(7)])
  call ol_merge_tensors(G2tensor(9),[G2tensor(5),G1tensor(44),G1tensor(8)])
  call ol_merge_tensors(G2tensor(67),[G2tensor(10),G1tensor(126),G1tensor(48)])
  call ol_merge_tensors(G2tensor(69),[G2tensor(12),G1tensor(128),G1tensor(20)])
  call ol_merge_tensors(G2tensor(15),[G2tensor(13),G1tensor(62),G1tensor(5)])
  call ol_merge_tensors(G2tensor(70),[G2tensor(16),G1tensor(132),G1tensor(66)])
  call ol_merge_tensors(G2tensor(117),[G2tensor(63),G2tensor(18),G1tensor(116),G1tensor(9)])
  call ol_merge_tensors(G2tensor(21),[G2tensor(19),G1tensor(86),G1tensor(16)])
  call ol_merge_tensors(G2tensor(64),[G2tensor(22),G1tensor(120),G1tensor(90)])
  call ol_merge_tensors(G2tensor(116),[G2tensor(60),G2tensor(24),G1tensor(110),G1tensor(17)])
  call ol_merge_tensors(G2tensor(27),[G2tensor(25),G1tensor(104),G1tensor(24)])
  call ol_merge_tensors(G2tensor(61),[G2tensor(28),G1tensor(114),G1tensor(108)])
  call ol_merge_tensors(G2tensor(2),[G2tensor(30),G1tensor(26),G1tensor(13)])
  call ol_merge_tensors(G2tensor(65),[G2tensor(31),G1tensor(123),G1tensor(30)])
  call ol_merge_tensors(G2tensor(4),[G2tensor(33),G1tensor(32),G1tensor(19)])
  call ol_merge_tensors(G2tensor(68),[G2tensor(34),G1tensor(124),G1tensor(36)])
  call ol_merge_tensors(G2tensor(139),[G2tensor(36),G1tensor(38),G1tensor(11),G1tensor(2)])
  call ol_merge_tensors(G2tensor(190),[G2tensor(37),G1tensor(131),G1tensor(125),G1tensor(42)])
  call ol_merge_tensors(G2tensor(1),[G2tensor(39),G1tensor(50),G1tensor(3)])
  call ol_merge_tensors(G2tensor(71),[G2tensor(40),G1tensor(129),G1tensor(54)])
  call ol_merge_tensors(G2tensor(11),[G2tensor(42),G1tensor(56),G1tensor(4)])
  call ol_merge_tensors(G2tensor(74),[G2tensor(43),G1tensor(130),G1tensor(60)])
  call ol_merge_tensors(G2tensor(29),[G2tensor(45),G1tensor(68),G1tensor(10)])
  call ol_merge_tensors(G2tensor(59),[G2tensor(46),G1tensor(117),G1tensor(72)])
  call ol_merge_tensors(G2tensor(32),[G2tensor(48),G1tensor(74),G1tensor(12)])
  call ol_merge_tensors(G2tensor(62),[G2tensor(49),G1tensor(118),G1tensor(78)])
  call ol_merge_tensors(G2tensor(145),[G2tensor(51),G1tensor(80),G1tensor(22),G1tensor(15)])
  call ol_merge_tensors(G2tensor(187),[G2tensor(52),G1tensor(119),G1tensor(113),G1tensor(84)])
  call ol_merge_tensors(G2tensor(38),[G2tensor(54),G1tensor(92),G1tensor(18)])
  call ol_merge_tensors(G2tensor(56),[G2tensor(55),G1tensor(111),G1tensor(96)])
  call ol_merge_tensors(G2tensor(41),[G2tensor(57),G1tensor(98),G1tensor(21)])
  call ol_merge_tensors(G2tensor(26),[G2tensor(58),G1tensor(112),G1tensor(102)])
  call ol_merge_tensors(G2tensor(120),[G2tensor(72),G1tensor(134)])
  call ol_merge_tensors(G2tensor(73),[G1tensor(138)])
  call ol_merge_tensors(G2tensor(121),[G2tensor(75),G1tensor(140)])
  call ol_merge_tensors(G2tensor(76),[G1tensor(144)])
  call ol_merge_tensors(G2tensor(122),[G2tensor(78),G1tensor(146)])
  call ol_merge_tensors(G2tensor(250),[G2tensor(247),G2tensor(79),G1tensor(150)])
  call ol_merge_tensors(G2tensor(151),[G2tensor(84),G1tensor(152)])
  call ol_merge_tensors(G2tensor(85),[G1tensor(156)])
  call ol_merge_tensors(G2tensor(154),[G2tensor(88),G1tensor(158)])
  call ol_merge_tensors(G2tensor(223),[G2tensor(89),G1tensor(162)])
  call ol_merge_tensors(G2tensor(160),[G2tensor(92),G1tensor(171),G1tensor(164)])
  call ol_merge_tensors(G2tensor(101),[G2tensor(93),G1tensor(180),G1tensor(168)])
  call ol_merge_tensors(G2tensor(166),[G2tensor(96),G1tensor(170)])
  call ol_merge_tensors(G2tensor(229),[G2tensor(97),G1tensor(174)])
  call ol_merge_tensors(G2tensor(172),[G2tensor(100),G1tensor(176)])
  call ol_merge_tensors(G2tensor(47),[G1tensor(33),G1tensor(27)])
  call ol_merge_tensors(G2tensor(175),[G1tensor(52),G1tensor(39),G1tensor(28)])
  call ol_merge_tensors(G2tensor(6),[G1tensor(45),G1tensor(29)])
  call ol_merge_tensors(G2tensor(178),[G1tensor(160),G1tensor(58),G1tensor(40),G1tensor(34)])
  call ol_merge_tensors(G2tensor(8),[G1tensor(46),G1tensor(35)])
  call ol_merge_tensors(G2tensor(142),[G1tensor(155),G1tensor(65),G1tensor(47),G1tensor(41)])
  call ol_merge_tensors(G2tensor(50),[G1tensor(57),G1tensor(51)])
  call ol_merge_tensors(G2tensor(17),[G1tensor(63),G1tensor(53)])
  call ol_merge_tensors(G2tensor(23),[G1tensor(64),G1tensor(59)])
  call ol_merge_tensors(G2tensor(20),[G1tensor(75),G1tensor(69)])
  call ol_merge_tensors(G2tensor(181),[G1tensor(94),G1tensor(81),G1tensor(70)])
  call ol_merge_tensors(G2tensor(35),[G1tensor(87),G1tensor(71)])
  call ol_merge_tensors(G2tensor(184),[G1tensor(172),G1tensor(100),G1tensor(82),G1tensor(76)])
  call ol_merge_tensors(G2tensor(7),[G1tensor(88),G1tensor(77)])
  call ol_merge_tensors(G2tensor(148),[G1tensor(179),G1tensor(107),G1tensor(89),G1tensor(83)])
  call ol_merge_tensors(G2tensor(53),[G1tensor(99),G1tensor(93)])
  call ol_merge_tensors(G2tensor(14),[G1tensor(105),G1tensor(95)])
  call ol_merge_tensors(G2tensor(44),[G1tensor(106),G1tensor(101)])
  call ol_merge_tensors(G2tensor(77),[G1tensor(135)])
  call ol_merge_tensors(G2tensor(83),[G1tensor(136)])
  call ol_merge_tensors(G2tensor(193),[G1tensor(143),G1tensor(137)])
  call ol_merge_tensors(G2tensor(87),[G1tensor(141)])
  call ol_merge_tensors(G2tensor(91),[G1tensor(142)])
  call ol_merge_tensors(G2tensor(196),[G1tensor(147)])
  call ol_merge_tensors(G2tensor(199),[G1tensor(148)])
  call ol_merge_tensors(G2tensor(136),[G1tensor(149)])
  call ol_merge_tensors(G2tensor(202),[G1tensor(153)])
  call ol_merge_tensors(G2tensor(235),[G2tensor(205),G1tensor(154)])
  call ol_merge_tensors(G2tensor(208),[G1tensor(159)])
  call ol_merge_tensors(G2tensor(241),[G2tensor(157),G1tensor(161)])
  call ol_merge_tensors(G2tensor(211),[G1tensor(165)])
  call ol_merge_tensors(G2tensor(214),[G1tensor(166)])
  call ol_merge_tensors(G2tensor(163),[G1tensor(167)])
  call ol_merge_tensors(G2tensor(169),[G1tensor(173)])
  call ol_merge_tensors(G2tensor(217),[G1tensor(177)])
  call ol_merge_tensors(G2tensor(220),[G1tensor(178)])
  call ol_merge_tensors(G2tensor(127),[G2tensor(124)])
  call ol_merge_tensors(G2tensor(131),[G2tensor(130)])
  call ol_merge_tensors(G2tensor(134),[G2tensor(133)])
  call Hotf_4pt_reduction_last(G2tensor(66),RedSet_4(102),mass4set(:,16),  & 
G1tensor(1),G1tensor(14),G1tensor(6),G1tensor(23),G1tensor(25))
  call G_TensorShift(G1tensor(14),2)
  call Hotf_4pt_reduction_last(G2tensor(9),RedSet_4(58),mass4set(:,16),  & 
G1tensor(31),G1tensor(37),G1tensor(43),G1tensor(49),G1tensor(55))
  call G_TensorShift(G1tensor(37),10)
  call Hotf_4pt_reduction_last(G2tensor(67),RedSet_4(13),mass4set(:,16),  & 
G1tensor(61),G1tensor(67),G1tensor(73),G1tensor(79),G1tensor(85))
  call G_TensorShift(G1tensor(67),26)
  call Hotf_4pt_reduction_last(G2tensor(69),RedSet_4(103),mass4set(:,16),  & 
G1tensor(91),G1tensor(97),G1tensor(103),G1tensor(109),G1tensor(115))
  call G_TensorShift(G1tensor(97),1)
  call Hotf_4pt_reduction_last(G2tensor(15),RedSet_4(61),mass4set(:,16),  & 
G1tensor(121),G1tensor(127),G1tensor(133),G1tensor(139),G1tensor(145))
  call G_TensorShift(G1tensor(127),9)
  call Hotf_4pt_reduction_last(G2tensor(70),RedSet_4(23),mass4set(:,16),  & 
G1tensor(151),G1tensor(157),G1tensor(163),G1tensor(169),G1tensor(175))
  call G_TensorShift(G1tensor(157),25)
  call Hotf_4pt_reduction_last(G2tensor(117),RedSet_4(104),mass4set(:,17),  & 
G1tensor(122),G1tensor(7),G1tensor(44),G1tensor(8),G1tensor(126))
  call G_TensorShift(G1tensor(7),4)
  call Hotf_4pt_reduction_last(G2tensor(21),RedSet_4(65),mass4set(:,9),  & 
G1tensor(48),G1tensor(128),G1tensor(20),G1tensor(62),G1tensor(5))
  call G_TensorShift(G1tensor(128),5)
  call Hotf_4pt_reduction_last(G2tensor(64),RedSet_4(38),mass4set(:,2),  & 
G1tensor(132),G1tensor(66),G1tensor(116),G1tensor(9),G1tensor(86))
  call G_TensorShift(G1tensor(66),21)
  call Hotf_4pt_reduction_last(G2tensor(116),RedSet_4(105),mass4set(:,17),  & 
G1tensor(16),G1tensor(120),G1tensor(90),G1tensor(110),G1tensor(17))
  call G_TensorShift(G1tensor(120),8)
  call Hotf_4pt_reduction_last(G2tensor(27),RedSet_4(68),mass4set(:,9),  & 
G1tensor(104),G1tensor(24),G1tensor(114),G1tensor(108),G1tensor(26))
  call G_TensorShift(G1tensor(24),9)
  call Hotf_4pt_reduction_last(G2tensor(61),RedSet_4(47),mass4set(:,2),  & 
G1tensor(13),G1tensor(123),G1tensor(30),G1tensor(32),G1tensor(19))
  call G_TensorShift(G1tensor(123),25)
  call Hotf_4pt_reduction_last(G2tensor(2),RedSet_4(55),mass4set(:,18),  & 
G1tensor(124),G1tensor(36),G1tensor(38),G1tensor(11),G1tensor(2))
  call G_TensorShift(G1tensor(36),8)
  call Hotf_4pt_reduction_last(G2tensor(65),RedSet_4(4),mass4set(:,18),  & 
G1tensor(131),G1tensor(125),G1tensor(42),G1tensor(50),G1tensor(3))
  call G_TensorShift(G1tensor(125),24)
  call Hotf_4pt_reduction_last(G2tensor(4),RedSet_4(56),mass4set(:,18),  & 
G1tensor(129),G1tensor(54),G1tensor(56),G1tensor(4),G1tensor(130))
  call G_TensorShift(G1tensor(54),8)
  call Hotf_4pt_reduction_last(G2tensor(68),RedSet_4(8),mass4set(:,18),  & 
G1tensor(60),G1tensor(68),G1tensor(10),G1tensor(117),G1tensor(72))
  call G_TensorShift(G1tensor(68),24)
  call Hotf_4pt_reduction_last(G2tensor(139),RedSet_4(57),mass4set(:,1),  & 
G1tensor(74),G1tensor(12),G1tensor(118),G1tensor(78),G1tensor(80))
  call G_TensorShift(G1tensor(12),8)
  call Hotf_4pt_reduction_last(G2tensor(190),RedSet_4(11),mass4set(:,1),  & 
G1tensor(22),G1tensor(15),G1tensor(119),G1tensor(113),G1tensor(84))
  call G_TensorShift(G1tensor(15),24)
  call Hotf_4pt_reduction_last(G2tensor(1),RedSet_4(59),mass4set(:,18),  & 
G1tensor(92),G1tensor(18),G1tensor(111),G1tensor(96),G1tensor(98))
  call G_TensorShift(G1tensor(18),8)
  call Hotf_4pt_reduction_last(G2tensor(71),RedSet_4(18),mass4set(:,18),  & 
G1tensor(21),G1tensor(112),G1tensor(102),G1tensor(134),G1tensor(138))
  call G_TensorShift(G1tensor(112),24)
  call Hotf_4pt_reduction_last(G2tensor(11),RedSet_4(60),mass4set(:,18),  & 
G1tensor(140),G1tensor(144),G1tensor(146),G1tensor(150),G1tensor(152))
  call G_TensorShift(G1tensor(144),8)
  call Hotf_4pt_reduction_last(G2tensor(74),RedSet_4(21),mass4set(:,18),  & 
G1tensor(156),G1tensor(158),G1tensor(162),G1tensor(171),G1tensor(164))
  call G_TensorShift(G1tensor(158),24)
  call Hotf_4pt_reduction_last(G2tensor(29),RedSet_4(62),mass4set(:,19),  & 
G1tensor(180),G1tensor(168),G1tensor(170),G1tensor(174),G1tensor(176))
  call G_TensorShift(G1tensor(168),1)
  call Hotf_4pt_reduction_last(G2tensor(59),RedSet_4(29),mass4set(:,20),  & 
G1tensor(33),G1tensor(27),G1tensor(52),G1tensor(39),G1tensor(28))
  call G_TensorShift(G1tensor(27),17)
  call Hotf_4pt_reduction_last(G2tensor(32),RedSet_4(63),mass4set(:,9),  & 
G1tensor(45),G1tensor(29),G1tensor(160),G1tensor(58),G1tensor(40))
  call G_TensorShift(G1tensor(29),1)
  call Hotf_4pt_reduction_last(G2tensor(62),RedSet_4(33),mass4set(:,2),  & 
G1tensor(34),G1tensor(46),G1tensor(35),G1tensor(155),G1tensor(65))
  call G_TensorShift(G1tensor(46),17)
  call Hotf_4pt_reduction_last(G2tensor(145),RedSet_4(64),mass4set(:,9),  & 
G1tensor(47),G1tensor(41),G1tensor(57),G1tensor(51),G1tensor(63))
  call G_TensorShift(G1tensor(41),1)
  call Hotf_4pt_reduction_last(G2tensor(187),RedSet_4(36),mass4set(:,2),  & 
G1tensor(53),G1tensor(64),G1tensor(59),G1tensor(75),G1tensor(69))
  call G_TensorShift(G1tensor(64),17)
  call Hotf_4pt_reduction_last(G2tensor(38),RedSet_4(66),mass4set(:,19),  & 
G1tensor(94),G1tensor(81),G1tensor(70),G1tensor(87),G1tensor(71))
  call G_TensorShift(G1tensor(81),1)
  call Hotf_4pt_reduction_last(G2tensor(56),RedSet_4(43),mass4set(:,20),  & 
G1tensor(172),G1tensor(100),G1tensor(82),G1tensor(76),G1tensor(88))
  call G_TensorShift(G1tensor(100),17)
  call Hotf_4pt_reduction_last(G2tensor(41),RedSet_4(67),mass4set(:,9),  & 
G1tensor(77),G1tensor(179),G1tensor(107),G1tensor(89),G1tensor(83))
  call G_TensorShift(G1tensor(179),1)
  call Hotf_4pt_reduction_last(G2tensor(26),RedSet_4(45),mass4set(:,2),  & 
G1tensor(99),G1tensor(93),G1tensor(105),G1tensor(95),G1tensor(106))
  call G_TensorShift(G1tensor(93),17)
  call Hotf_4pt_reduction_last(G2tensor(120),RedSet_4(106),mass4set(:,17),  & 
G1tensor(101),G1tensor(135),G1tensor(136),G1tensor(143),G1tensor(137))
  call G_TensorShift(G1tensor(135),8)
  call Hotf_4pt_reduction_last(G2tensor(73),RedSet_4(72),mass4set(:,9),  & 
G1tensor(141),G1tensor(142),G1tensor(147),G1tensor(148),G1tensor(149))
  call G_TensorShift(G1tensor(142),10)
  call Hotf_4pt_reduction_last(G2tensor(121),RedSet_4(107),mass4set(:,17),  & 
G1tensor(153),G1tensor(154),G1tensor(159),G1tensor(161),G1tensor(165))
  call G_TensorShift(G1tensor(154),4)
  call Hotf_4pt_reduction_last(G2tensor(76),RedSet_4(76),mass4set(:,9),  & 
G1tensor(166),G1tensor(167),G1tensor(173),G1tensor(177),G1tensor(178))
  call G_TensorShift(G1tensor(167),6)
  call Hotf_4pt_reduction_last(G2tensor(122),RedSet_4(95),mass4set(:,1),  & 
G1tensor(181),G1tensor(182),G1tensor(183),G1tensor(184),G1tensor(185))
  call G_TensorShift(G1tensor(182),8)
  call Hotf_4pt_reduction_last(G2tensor(250),RedSet_4(50),mass4set(:,1),  & 
G1tensor(186),G1tensor(187),G1tensor(188),G1tensor(189),G1tensor(190))
  call G_TensorShift(G1tensor(187),12)
  call Hotf_4pt_reduction_last(G2tensor(151),RedSet_4(96),mass4set(:,1),  & 
G1tensor(191),G1tensor(192),G1tensor(193),G1tensor(194),G1tensor(195))
  call G_TensorShift(G1tensor(192),3)
  call Hotf_4pt_reduction_last(G2tensor(85),RedSet_4(51),mass4set(:,1),  & 
G1tensor(196),G1tensor(197),G1tensor(198),G1tensor(199),G1tensor(200))
  call G_TensorShift(G1tensor(197),19)
  call Hotf_4pt_reduction_last(G2tensor(154),RedSet_4(97),mass4set(:,1),  & 
G1tensor(201),G1tensor(202),G1tensor(203),G1tensor(204),G1tensor(205))



end subroutine vamp_1

end module ol_vamp_1_ppwwtt_ttxddxwwx_1_/**/REALKIND
