
module ol_vamp_1_ppwwtt_ttxbbxwwx_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppwwtt_ttxbbxwwx_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppwwtt_ttxbbxwwx_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_ppwwtt_ttxbbxwwx_1_/**/DREALKIND
  use ol_tensor_sum_storage_ppwwtt_ttxbbxwwx_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_ppwwtt_ttxbbxwwx_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_ppwwtt_ttxbbxwwx_1_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL, hel_states
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(hel_states)
  type(Hpolcont), intent(in) :: M(2,hel_states)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel(1:hel_states)
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel(1:hel_states)
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)+c(33)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(1),h0tab(:,1),[32,4,1,2,8,16],[nMB,0,nMT,0,nMB,nMT],6,0)
  call Hloop_AW_Q(ntryL,G0H144(1),ex6(:),G0H48(1),m3h3x48(:,1),heltab2x144(:,:,1))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMB,G1H48(1),n2h48(1))
  Gcoeff(:)%j = (c(35)*M(1,:)%j+c(29)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(2),h0tab(:,2),[32,4,2,1,8,16],[nMB,0,nMT,0,nMB,nMT],6,0)
  call Hloop_AW_Q(ntryL,G0H144(1),ex6(:),G0H48(1),m3h3x48(:,2),heltab2x144(:,:,2))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMB,G1H48(2),n2h48(2))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)-c(35)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(3),h0tab(:,3),[32,2,1,16,8,4],[nMT,0,nMT,nMB,0,nMB],6,0)
  call Hloop_QW_A(ntryL,G0H144(1),ex6(:),G0H48(1),m3h3x48(:,3),heltab2x144(:,:,3))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(3),n2h48(3))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)+c(33)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(4),h0tab(:,4),[32,2,8,4,1,16],[nMT,0,nMB,0,nMT,nMB],6,0)
  call Hloop_QW_A(ntryL,G0H144(1),ex6(:),G0H48(1),m3h3x48(:,4),heltab2x144(:,:,4))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(4),n2h48(4))
  Gcoeff(:)%j = (-(c(33)*M(1,:)%j)+c(31)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(5),h0tab(:,5),[32,2,8,16,1,4],[nMT,0,nMB,nMT,0,nMB],6,0)
  call Hloop_QW_A(ntryL,G0H144(1),ex6(:),G0H48(1),m3h3x48(:,5),heltab2x144(:,:,5))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(5),n2h48(5))
  Gcoeff(:)%j = (c(35)*M(1,:)%j+c(29)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(6),h0tab(:,6),[32,2,4,8,1,16],[nMT,0,nMB,0,nMT,nMB],6,0)
  call Hloop_QW_A(ntryL,G0H144(1),ex6(:),G0H48(1),m3h3x48(:,6),heltab2x144(:,:,6))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(6),n2h48(6))
  call Hloop_AQ_V(ntryL,G1H48(1),ex3(:),G1H24(1),m3h2x24(:,1),heltab2x48(:,:,1))
  call Hloop_AQ_V(ntryL,G1H48(2),ex3(:),G1H24(2),m3h2x24(:,2),heltab2x48(:,:,2))
  call Hloop_QA_V(ntryL,G1H48(3),ex2(:),G1H24(3),m3h2x24(:,3),heltab2x48(:,:,3))
  call Hloop_QA_V(ntryL,G1H48(4),ex2(:),G1H24(4),m3h2x24(:,4),heltab2x48(:,:,4))
  call Hloop_QA_V(ntryL,G1H48(5),ex2(:),G1H24(5),m3h2x24(:,5),heltab2x48(:,:,5))
  call Hloop_QA_V(ntryL,G1H48(6),ex2(:),G1H24(6),m3h2x24(:,6),heltab2x48(:,:,6))
  call Hloop_VQ_A(ntryL,G1H24(1),ex1(:),G1H12(1),m3h2x12(:,1),heltab2x24(:,:,1))
  call Hloop_Q_A(ntryL,G1H12(1),37,nMT,G2H12(1),n2h12(1))
  call Hloop_VA_Q(ntryL,G1H24(2),ex2(:),G1H12(1),m3h2x12(:,2),heltab2x24(:,:,2))
  call Hloop_A_Q(ntryL,G1H12(1),38,nMT,G2H12(2),n2h12(2))
  call Hloop_VQ_A(ntryL,G1H24(3),ex1(:),G1H12(1),m3h2x12(:,3),heltab2x24(:,:,3))
  call Hloop_Q_A(ntryL,G1H12(1),35,nMT,G2H12(3),n2h12(3))
  call Hloop_VA_Q(ntryL,G1H24(4),ex4(:),G1H12(1),m3h2x12(:,4),heltab2x24(:,:,4))
  call Hloop_A_Q(ntryL,G1H12(1),42,nMB,G2H12(4),n2h12(4))
  call Hloop_VA_Q(ntryL,G1H24(5),ex4(:),G1H12(1),m3h2x12(:,5),heltab2x24(:,:,5))
  call Hloop_A_Q(ntryL,G1H12(1),42,nMB,G2H12(5),n2h12(5))
  call Hloop_VQ_A(ntryL,G1H24(6),ex3(:),G1H12(1),m3h2x12(:,6),heltab2x24(:,:,6))
  call Hloop_Q_A(ntryL,G1H12(1),38,nMB,G2H12(6),n2h12(6))
  call Hloop_QA_V(ntryL,G2H12(1),ex2(:),G2H6(1),m3h2x6(:,1),heltab2x12(:,:,1))
  call Hloop_AQ_V(ntryL,G2H12(2),ex1(:),G2H6(2),m3h2x6(:,2),heltab2x12(:,:,2))
  call Hotf_5pt_reduction(G2H12(3),RedSet_5(1),mass5set(:,1),  & 
G1H12(1),G1H12(2),G1H12(3),G1H12(4),G1H12(5),G1H12(6),12)
  call HG1shiftOLR(G1H12(2),4,12)
  call Hloop_AQ_V(ntryL,G2H12(4),ex3(:),G2H6(3),m3h2x6(:,3),heltab2x12(:,:,3))
  call Hotf_5pt_reduction(G2H12(5),RedSet_5(2),mass5set(:,2),  & 
G1H12(7),G1H12(8),G1H12(9),G1H12(10),G1H12(11),G1H12(12),12)
  call HG1shiftOLR(G1H12(8),4,12)
  call Hloop_QA_V(ntryL,G2H12(6),ex4(:),G2H6(4),m3h2x6(:,4),heltab2x12(:,:,4))
  call Hloop_QW_A(ntryL,G1H12(1),ex5(:),G1H4(1),m3h3x4(:,1),heltab2x12(:,:,5))
  call Hloop_Q_A(ntryL,G1H4(1),51,nMB,G2H4(1),n2h4(1))
call HGT_OLR(G1H12(2),1,1,12)
call HGT_invQ_OLR(G1H12(2),2,5,12)
  call Hloop_A_Q(ntryL,G1H12(2),-4,nMB,G2H12(1),n2h12(7))
  call Hloop_AQ_V(ntryL,G2H12(1),ex3(:),G2H6(5),m3h2x6(:,5),heltab2x12(:,:,6))
  call Hloop_QW_A(ntryL,G1H12(5),ex5(:),G1H4(1),m3h3x4(:,2),heltab2x12(:,:,7))
  call Hloop_Q_A(ntryL,G1H4(1),51,nMB,G2H4(2),n2h4(2))
  call Hloop_QW_A(ntryL,G1H12(6),ex5(:),G1H4(1),m3h3x4(:,3),heltab2x12(:,:,8))
  call Hloop_Q_A(ntryL,G1H4(1),51,nMB,G2H4(3),n2h4(3))
  call Hloop_AW_Q(ntryL,G1H12(7),ex5(:),G1H4(1),m3h3x4(:,4),heltab2x12(:,:,9))
  call Hloop_A_Q(ntryL,G1H4(1),58,nMT,G2H4(4),n2h4(4))
call HGT_OLR(G1H12(8),1,1,12)
call HGT_invQ_OLR(G1H12(8),2,5,12)
  call Hloop_A_Q(ntryL,G1H12(8),-4,nMB,G2H12(2),n2h12(8))
  call Hloop_AQ_V(ntryL,G2H12(2),ex3(:),G2H6(6),m3h2x6(:,6),heltab2x12(:,:,10))
  call Hloop_AW_Q(ntryL,G1H12(11),ex5(:),G1H4(1),m3h3x4(:,5),heltab2x12(:,:,11))
  call Hloop_A_Q(ntryL,G1H4(1),58,nMT,G2H4(5),n2h4(5))
  call Hloop_AW_Q(ntryL,G1H12(12),ex5(:),G1H4(1),m3h3x4(:,6),heltab2x12(:,:,12))
  call Hloop_A_Q(ntryL,G1H4(1),58,nMT,G2H4(6),n2h4(6))
  call Hotf_5pt_reduction(G2H6(1),RedSet_5(3),mass5set(:,3),  & 
G1H6(1),G1H6(2),G1H6(3),G1H6(4),G1H6(5),G1H6(6),6)
  call HG1shiftOLR(G1H6(2),16,6)
  call Hotf_5pt_reduction(G2H6(2),RedSet_5(4),mass5set(:,3),  & 
G1H6(7),G1H6(8),G1H6(9),G1H6(10),G1H6(11),G1H6(12),6)
  call HG1shiftOLR(G1H6(8),16,6)
  call Hotf_5pt_reduction(G2H6(3),RedSet_5(5),mass5set(:,4),  & 
G1H6(13),G1H6(14),G1H6(15),G1H6(16),G1H6(17),G1H6(18),6)
  call HG1shiftOLR(G1H6(14),16,6)
  call Hotf_5pt_reduction(G2H6(4),RedSet_5(6),mass5set(:,4),  & 
G1H6(19),G1H6(20),G1H6(21),G1H6(22),G1H6(23),G1H6(24),6)
  call HG1shiftOLR(G1H6(20),16,6)
  call Hloop_QA_V(ntryL,G2H4(1),ex4(:),G2H2(1),m3h2x2(:,1),heltab2x4(:,:,1))
  call Hloop_QA_V(ntryL,G2H4(3),ex4(:),G2H2(2),m3h2x2(:,2),heltab2x4(:,:,2))
  call Hloop_AQ_V(ntryL,G2H4(4),ex1(:),G2H2(3),m3h2x2(:,3),heltab2x4(:,:,3))
  call Hloop_AQ_V(ntryL,G2H4(6),ex1(:),G2H2(4),m3h2x2(:,4),heltab2x4(:,:,4))
  call Hloop_VA_Q(ntryL,G1H6(1),ex4(:),G1H3(1),m3h2x3(:,1),heltab2x6(:,:,1))
  call Hloop_A_Q(ntryL,G1H3(1),47,nMB,G2H3(1),n2h3(1))
call HGT_OLR(G1H6(2),1,1,6)
call HGT_invQ_OLR(G1H6(2),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(2),-16,nMT,G2H6(1),n2h6(1))
  call Hloop_QW_A(ntryL,G2H6(1),ex5(:),G2H2(5),m3h3x2(:,1),heltab2x6(:,:,2))
  call Hloop_VA_Q(ntryL,G1H6(6),ex4(:),G1H3(1),m3h2x3(:,2),heltab2x6(:,:,3))
  call Hloop_A_Q(ntryL,G1H3(1),47,nMB,G2H3(2),n2h3(2))
  call Hloop_VA_Q(ntryL,G1H6(7),ex4(:),G1H3(1),m3h2x3(:,3),heltab2x6(:,:,4))
  call Hloop_A_Q(ntryL,G1H3(1),47,nMB,G2H3(3),n2h3(3))
call HGT_OLR(G1H6(8),1,1,6)
call HGT_invQ_OLR(G1H6(8),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(8),-16,nMT,G2H6(2),n2h6(2))
  call Hloop_QW_A(ntryL,G2H6(2),ex5(:),G2H2(6),m3h3x2(:,2),heltab2x6(:,:,5))
  call Hloop_VA_Q(ntryL,G1H6(12),ex4(:),G1H3(1),m3h2x3(:,4),heltab2x6(:,:,6))
  call Hloop_A_Q(ntryL,G1H3(1),47,nMB,G2H3(4),n2h3(4))
  call Hloop_VQ_A(ntryL,G1H6(13),ex1(:),G1H3(1),m3h2x3(:,5),heltab2x6(:,:,7))
  call Hloop_Q_A(ntryL,G1H3(1),47,nMT,G2H3(5),n2h3(5))
call HGT_OLR(G1H6(14),1,1,6)
call HGT_invQ_OLR(G1H6(14),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(14),-16,nMB,G2H6(3),n2h6(3))
  call Hloop_AW_Q(ntryL,G2H6(3),ex5(:),G2H2(7),m3h3x2(:,3),heltab2x6(:,:,8))
  call Hloop_VQ_A(ntryL,G1H6(18),ex1(:),G1H3(1),m3h2x3(:,6),heltab2x6(:,:,9))
  call Hloop_Q_A(ntryL,G1H3(1),47,nMT,G2H3(6),n2h3(6))
  call Hloop_VQ_A(ntryL,G1H6(19),ex1(:),G1H3(1),m3h2x3(:,7),heltab2x6(:,:,10))
  call Hloop_Q_A(ntryL,G1H3(1),47,nMT,G2H3(7),n2h3(7))
call HGT_OLR(G1H6(20),1,1,6)
call HGT_invQ_OLR(G1H6(20),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(20),-16,nMB,G2H6(4),n2h6(4))
  call Hloop_AW_Q(ntryL,G2H6(4),ex5(:),G2H2(8),m3h3x2(:,4),heltab2x6(:,:,11))
  call Hloop_VQ_A(ntryL,G1H6(24),ex1(:),G1H3(1),m3h2x3(:,8),heltab2x6(:,:,12))
  call Hloop_Q_A(ntryL,G1H3(1),47,nMT,G2H3(8),n2h3(8))
  call Hotf_5pt_reduction(G2H2(1),RedSet_5(1),mass5set(:,1),  & 
G1H2(1),G1H2(2),G1H2(3),G1H2(4),G1H2(5),G1H2(6),2)
  call HG1shiftOLR(G1H2(2),4,2)
  call Hotf_5pt_reduction(G2H2(3),RedSet_5(2),mass5set(:,2),  & 
G1H2(7),G1H2(8),G1H2(9),G1H2(10),G1H2(11),G1H2(12),2)
  call HG1shiftOLR(G1H2(8),4,2)
  call Hotf_5pt_reduction(G2H3(1),RedSet_5(3),mass5set(:,3),  & 
G1H3(1),G1H3(2),G1H3(3),G1H3(4),G1H3(5),G1H3(6),3)
  call HG1shiftOLR(G1H3(2),16,3)
  call Hotf_5pt_reduction(G2H3(3),RedSet_5(4),mass5set(:,3),  & 
G1H3(7),G1H3(8),G1H3(9),G1H3(10),G1H3(11),G1H3(12),3)
  call HG1shiftOLR(G1H3(8),16,3)
  call Hotf_5pt_reduction(G2H3(5),RedSet_5(5),mass5set(:,4),  & 
G1H3(13),G1H3(14),G1H3(15),G1H3(16),G1H3(17),G1H3(18),3)
  call HG1shiftOLR(G1H3(14),16,3)
  call Hotf_5pt_reduction(G2H3(7),RedSet_5(6),mass5set(:,4),  & 
G1H3(19),G1H3(20),G1H3(21),G1H3(22),G1H3(23),G1H3(24),3)
  call HG1shiftOLR(G1H3(20),16,3)
  call Hloop_VQ_A(ntryL,G1H2(1),ex3(:),G1H1(1),m3h2x1(:,1),heltab2x2(:,:,1))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(1),n2h1(1))
  call Hloop_VQ_A(ntryL,G1H2(2),ex3(:),G1H1(1),m3h2x1(:,2),heltab2x2(:,:,2))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(2),n2h1(2))
  call Hloop_VQ_A(ntryL,G1H2(7),ex3(:),G1H1(1),m3h2x1(:,3),heltab2x2(:,:,3))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(3),n2h1(3))
  call Hloop_VQ_A(ntryL,G1H2(8),ex3(:),G1H1(1),m3h2x1(:,4),heltab2x2(:,:,4))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(4),n2h1(4))
  call Hloop_AW_Q(ntryL,G1H3(1),ex5(:),G1H1(1),m3h3x1(:,1),heltab2x3(:,:,1))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(5),n2h1(5))
  call Hloop_AW_Q(ntryL,G1H3(2),ex5(:),G1H1(1),m3h3x1(:,2),heltab2x3(:,:,2))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nMT,G2tensor(6),n2h1(6))
  call Hloop_AW_Q(ntryL,G1H3(7),ex5(:),G1H1(1),m3h3x1(:,3),heltab2x3(:,:,3))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(7),n2h1(7))
  call Hloop_AW_Q(ntryL,G1H3(8),ex5(:),G1H1(1),m3h3x1(:,4),heltab2x3(:,:,4))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nMT,G2tensor(8),n2h1(8))
  call Hloop_QW_A(ntryL,G1H3(13),ex5(:),G1H1(1),m3h3x1(:,5),heltab2x3(:,:,5))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(9),n2h1(9))
  call Hloop_QW_A(ntryL,G1H3(14),ex5(:),G1H1(1),m3h3x1(:,6),heltab2x3(:,:,6))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(10),n2h1(10))
  call Hloop_QW_A(ntryL,G1H3(19),ex5(:),G1H1(1),m3h3x1(:,7),heltab2x3(:,:,7))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(11),n2h1(11))
  call Hloop_QW_A(ntryL,G1H3(20),ex5(:),G1H1(1),m3h3x1(:,8),heltab2x3(:,:,8))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(12),n2h1(12))
  call Hotf_5pt_reduction_last(G2tensor(1),RedSet_5(1),mass5set(:,1),  & 
G1tensor(1),G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(5),G1tensor(6))
  call G_TensorShift(G1tensor(2),4)
  call Hotf_5pt_reduction_last(G2tensor(3),RedSet_5(2),mass5set(:,2),  & 
G1tensor(7),G1tensor(8),G1tensor(9),G1tensor(10),G1tensor(11),G1tensor(12))
  call G_TensorShift(G1tensor(8),4)
  call Hotf_5pt_reduction_last(G2tensor(5),RedSet_5(3),mass5set(:,3),  & 
G1tensor(13),G1tensor(14),G1tensor(15),G1tensor(16),G1tensor(17),G1tensor(18))
  call G_TensorShift(G1tensor(14),16)
  call Hotf_5pt_reduction_last(G2tensor(7),RedSet_5(4),mass5set(:,3),  & 
G1tensor(19),G1tensor(20),G1tensor(21),G1tensor(22),G1tensor(23),G1tensor(24))
  call G_TensorShift(G1tensor(20),16)
  call Hotf_5pt_reduction_last(G2tensor(9),RedSet_5(5),mass5set(:,4),  & 
G1tensor(25),G1tensor(26),G1tensor(27),G1tensor(28),G1tensor(29),G1tensor(30))
  call G_TensorShift(G1tensor(26),16)
  call Hotf_5pt_reduction_last(G2tensor(11),RedSet_5(6),mass5set(:,4),  & 
G1tensor(31),G1tensor(32),G1tensor(33),G1tensor(34),G1tensor(35),G1tensor(36))
  call G_TensorShift(G1tensor(32),16)
  call ol_merge_tensors(T1sum(1),[G1tensor(1)])
  call ol_merge_tensors(T1sum(2),[G1tensor(7)])
  call ol_merge_tensors(T1sum(3),[G1tensor(13)])
  call ol_merge_tensors(T1sum(4),[G1tensor(19)])
  call ol_merge_tensors(T1sum(5),[G1tensor(25)])
  call ol_merge_tensors(T1sum(6),[G1tensor(31)])
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j)+c(29)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(7),h0tab(:,7),[32,3,16,8,4],[nMT,nMT,nMB,0,nMB],5,1,wf4(:,1))
  call Hloop_QW_A(ntryL,G0H144(1),ex6(:),G0H48(1),m3h3x48(:,7),heltab2x144(:,:,7))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(1),n2h48(7))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j)+c(29)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(8),h0tab(:,8),[32,4,8,3,16],[nMB,0,nMB,nMB,nMT],5,1,wf4(:,1))
  call Hloop_AW_Q(ntryL,G0H144(1),ex6(:),G0H48(1),m3h3x48(:,8),heltab2x144(:,:,8))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMB,G1H48(2),n2h48(8))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j)+c(29)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(9),h0tab(:,9),[32,3,4,8,16],[nMB,nMB,0,nMB,nMT],5,1,wf4(:,1))
  call Hloop_AW_Q(ntryL,G0H144(1),ex6(:),G0H48(1),m3h3x48(:,9),heltab2x144(:,:,9))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMB,G1H48(3),n2h48(9))
  Gcoeff(:)%j = (c(26)*M(1,:)%j-c(25)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(10),h0tab(:,10),[32,4,3,8,16],[nMB,0,0,nMB,nMT],5,1,wf4(:,1))
  call Hloop_AW_Q(ntryL,G0H144(1),ex6(:),G0H48(1),m3h3x48(:,10),heltab2x144(:,:,10))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMB,G1H48(4),n2h48(10))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j)+c(29)*M(2,:)%j) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(11),h0tab(:,11),[32,2,1,16,12],[nMT,0,nMT,nMB,nMB],5,1,wf4(:,2))
  call Hloop_QW_A(ntryL,G0H144(1),ex6(:),G0H48(1),m3h3x48(:,11),heltab2x144(:,:,11))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(5),n2h48(11))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j)+c(29)*M(2,:)%j) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(12),h0tab(:,12),[32,12,2,1,16],[nMT,nMT,0,nMT,nMB],5,1,wf4(:,2))
  call Hloop_QW_A(ntryL,G0H144(1),ex6(:),G0H48(1),m3h3x48(:,12),heltab2x144(:,:,12))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(6),n2h48(12))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j)+c(29)*M(2,:)%j) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(13),h0tab(:,13),[32,2,1,12,16],[nMT,0,nMT,nMT,nMB],5,1,wf4(:,2))
  call Hloop_QW_A(ntryL,G0H144(1),ex6(:),G0H48(1),m3h3x48(:,13),heltab2x144(:,:,13))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(7),n2h48(13))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)+c(25)*M(2,:)%j) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(14),h0tab(:,14),[32,2,12,1,16],[nMT,0,0,nMT,nMB],5,1,wf4(:,2))
  call Hloop_QW_A(ntryL,G0H144(1),ex6(:),G0H48(1),m3h3x48(:,14),heltab2x144(:,:,14))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(8),n2h48(14))
  Gcoeff(:)%j = (c(35)*M(1,:)%j+c(29)*M(2,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(15),h0tab(:,15),[32,2,4,8,17],[nMT,0,nMB,0,nMB],5,1,wf6(:,7))
  call Hloop_QW_A(ntryL,G0H144(1),ex6(:),G0H48(1),m3h3x48(:,15),heltab2x144(:,:,15))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(9),n2h48(15))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)+c(33)*M(2,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(16),h0tab(:,16),[32,2,8,4,17],[nMT,0,nMB,0,nMB],5,1,wf6(:,7))
  call Hloop_QW_A(ntryL,G0H144(1),ex6(:),G0H48(1),m3h3x48(:,16),heltab2x144(:,:,16))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(10),n2h48(16))
  Gcoeff(:)%j = (-(c(33)*M(1,:)%j)+c(31)*M(2,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(17),h0tab(:,17),[32,2,8,17,4],[nMT,0,nMB,0,nMB],5,1,wf6(:,7))
  call Hloop_QW_A(ntryL,G0H144(1),ex6(:),G0H48(1),m3h3x48(:,17),heltab2x144(:,:,17))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(11),n2h48(17))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)-c(35)*M(2,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(18),h0tab(:,18),[32,2,17,8,4],[nMT,0,nMB,0,nMB],5,1,wf6(:,7))
  call Hloop_QW_A(ntryL,G0H144(1),ex6(:),G0H48(1),m3h3x48(:,18),heltab2x144(:,:,18))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(12),n2h48(18))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)+c(33)*M(2,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(19),h0tab(:,19),[32,4,1,2,24],[nMB,0,nMT,0,nMT],5,1,wf6(:,4))
  call Hloop_AW_Q(ntryL,G0H144(1),ex6(:),G0H48(1),m3h3x48(:,19),heltab2x144(:,:,19))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMB,G1H48(13),n2h48(19))
  Gcoeff(:)%j = (c(35)*M(1,:)%j+c(29)*M(2,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(20),h0tab(:,20),[32,4,2,1,24],[nMB,0,nMT,0,nMT],5,1,wf6(:,4))
  call Hloop_AW_Q(ntryL,G0H144(1),ex6(:),G0H48(1),m3h3x48(:,20),heltab2x144(:,:,20))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMB,G1H48(14),n2h48(20))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)-c(35)*M(2,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(21),h0tab(:,21),[32,2,1,24,4],[nMT,0,nMT,0,nMB],5,1,wf6(:,4))
  call Hloop_QW_A(ntryL,G0H144(1),ex6(:),G0H48(1),m3h3x48(:,21),heltab2x144(:,:,21))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(15),n2h48(21))
  Gcoeff(:)%j = (-(c(33)*M(1,:)%j)+c(31)*M(2,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(22),h0tab(:,22),[32,2,24,1,4],[nMT,0,nMT,0,nMB],5,1,wf6(:,4))
  call Hloop_QW_A(ntryL,G0H144(1),ex6(:),G0H48(1),m3h3x48(:,22),heltab2x144(:,:,22))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(16),n2h48(22))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)+c(33)*M(2,:)%j) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(23),h0tab(:,23),[34,8,4,1,16],[0,nMB,0,nMT,nMB],5,1,wf6(:,8))
  call Hloop_QA_V(ntryL,G0H144(1),wf6(:,8),G0H24(1),m3h6x24(:,1),heltab2x144(:,:,23))
  Gcoeff(:)%j = (-(c(33)*M(1,:)%j)+c(31)*M(2,:)%j) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(24),h0tab(:,24),[34,4,1,16,8],[nMB,0,nMT,nMB,0],5,1,wf6(:,8))
  call Hloop_VA_Q(ntryL,G0H144(1),wf6(:,8),G0H24(2),m3h6x24(:,2),heltab2x144(:,:,24))
  call Hloop_A_Q(ntryL,G0H24(2),34,nMB,G1H24(1),n2h24(1))
  Gcoeff(:)%j = (c(35)*M(1,:)%j+c(29)*M(2,:)%j) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(25),h0tab(:,25),[34,4,8,1,16],[0,nMB,0,nMT,nMB],5,1,wf6(:,8))
  call Hloop_QA_V(ntryL,G0H144(1),wf6(:,8),G0H24(2),m3h6x24(:,3),heltab2x144(:,:,25))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)-c(35)*M(2,:)%j) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(26),h0tab(:,26),[34,1,16,8,4],[0,nMT,nMB,0,nMB],5,1,wf6(:,8))
  call Hloop_QA_V(ntryL,G0H144(1),wf6(:,8),G0H24(3),m3h6x24(:,4),heltab2x144(:,:,26))
  Gcoeff(:)%j = (c(35)*M(1,:)%j+c(29)*M(2,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(27),h0tab(:,27),[36,2,1,8,16],[0,nMT,0,nMB,nMT],5,1,wf6(:,3))
  call Hloop_AQ_V(ntryL,G0H144(1),wf6(:,3),G0H24(4),m3h6x24(:,5),heltab2x144(:,:,27))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)-c(35)*M(2,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(28),h0tab(:,28),[36,2,1,16,8],[nMT,0,nMT,nMB,0],5,1,wf6(:,3))
  call Hloop_VQ_A(ntryL,G0H144(1),wf6(:,3),G0H24(5),m3h6x24(:,6),heltab2x144(:,:,28))
  call Hloop_Q_A(ntryL,G0H24(5),36,nMT,G1H24(2),n2h24(2))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)+c(33)*M(2,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(29),h0tab(:,29),[36,1,2,8,16],[0,nMT,0,nMB,nMT],5,1,wf6(:,3))
  call Hloop_AQ_V(ntryL,G0H144(1),wf6(:,3),G0H24(5),m3h6x24(:,7),heltab2x144(:,:,29))
  Gcoeff(:)%j = (-(c(33)*M(1,:)%j)+c(31)*M(2,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(30),h0tab(:,30),[36,1,16,8,2],[0,nMT,nMB,0,nMT],5,1,wf6(:,3))
  call Hloop_AQ_V(ntryL,G0H144(1),wf6(:,3),G0H24(6),m3h6x24(:,8),heltab2x144(:,:,30))
  Gcoeff(:)%j = (c(44)*M(1,:)%j-c(46)*M(2,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(31),h0tab(:,31),[48,4,1,2,8],[nMB,0,nMT,0,nMB],5,1,wf9(:,1))
  call Hloop_AS_Q(ntryL,G0H144(1),wf9(:,1),G0H16(1),ngH,m3h9x16(:,1),heltab2x144(:,:,31))
  call Hloop_A_Q(ntryL,G0H16(1),48,nMB,G1H16(1),n2h16(1))
  Gcoeff(:)%j = (c(9)*M(1,:)%j-c(11)*M(2,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(32),h0tab(:,32),[48,4,1,2,8],[nMB,0,nMT,0,nMB],5,1,wf9(:,2))
  call Hloop_AV_Q(ntryL,G0H144(1),wf9(:,2),G0H16(1),m3h9x16(:,2),heltab2x144(:,:,32))
  call Hloop_A_Q(ntryL,G0H16(1),48,nMB,G1H16(2),n2h16(2))
  Gcoeff(:)%j = (-(c(70)*M(1,:)%j)+c(72)*M(2,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(33),h0tab(:,33),[48,4,1,2,8],[nMB,0,nMT,0,nMB],5,1,wf9(:,3))
  call Hloop_AZ_Q(ntryL,G0H144(1),wf9(:,3),G0H16(1),ngZd,m3h9x16(:,3),heltab2x144(:,:,33))
  call Hloop_A_Q(ntryL,G0H16(1),48,nMB,G1H16(3),n2h16(3))
  Gcoeff(:)%j = (-(c(48)*M(1,:)%j)-c(42)*M(2,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(34),h0tab(:,34),[48,4,2,1,8],[nMB,0,nMT,0,nMB],5,1,wf9(:,1))
  call Hloop_AS_Q(ntryL,G0H144(1),wf9(:,1),G0H16(1),ngH,m3h9x16(:,4),heltab2x144(:,:,34))
  call Hloop_A_Q(ntryL,G0H16(1),48,nMB,G1H16(4),n2h16(4))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)-c(7)*M(2,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(35),h0tab(:,35),[48,4,2,1,8],[nMB,0,nMT,0,nMB],5,1,wf9(:,2))
  call Hloop_AV_Q(ntryL,G0H144(1),wf9(:,2),G0H16(1),m3h9x16(:,5),heltab2x144(:,:,35))
  call Hloop_A_Q(ntryL,G0H16(1),48,nMB,G1H16(5),n2h16(5))
  Gcoeff(:)%j = (c(74)*M(1,:)%j+c(68)*M(2,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(36),h0tab(:,36),[48,4,2,1,8],[nMB,0,nMT,0,nMB],5,1,wf9(:,3))
  call Hloop_AZ_Q(ntryL,G0H144(1),wf9(:,3),G0H16(1),ngZd,m3h9x16(:,6),heltab2x144(:,:,36))
  call Hloop_A_Q(ntryL,G0H16(1),48,nMB,G1H16(6),n2h16(6))
  Gcoeff(:)%j = (c(57)*M(1,:)%j-c(59)*M(2,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(37),h0tab(:,37),[48,1,4,8,2],[nMT,0,nMB,0,nMT],5,1,wf9(:,1))
  call Hloop_AS_Q(ntryL,G0H144(1),wf9(:,1),G0H16(1),ngH,m3h9x16(:,7),heltab2x144(:,:,37))
  call Hloop_A_Q(ntryL,G0H16(1),48,nMT,G1H16(7),n2h16(7))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)+c(20)*M(2,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(38),h0tab(:,38),[48,1,4,8,2],[nMT,0,nMB,0,nMT],5,1,wf9(:,2))
  call Hloop_AV_Q(ntryL,G0H144(1),wf9(:,2),G0H16(1),m3h9x16(:,8),heltab2x144(:,:,38))
  call Hloop_A_Q(ntryL,G0H16(1),48,nMT,G1H16(8),n2h16(8))
  Gcoeff(:)%j = (-(c(70)*M(1,:)%j)+c(72)*M(2,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(39),h0tab(:,39),[48,1,4,8,2],[nMT,0,nMB,0,nMT],5,1,wf9(:,3))
  call Hloop_AZ_Q(ntryL,G0H144(1),wf9(:,3),G0H16(1),ngZu,m3h9x16(:,9),heltab2x144(:,:,39))
  call Hloop_A_Q(ntryL,G0H16(1),48,nMT,G1H16(9),n2h16(9))
  Gcoeff(:)%j = (-(c(61)*M(1,:)%j)-c(55)*M(2,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(40),h0tab(:,40),[48,1,8,4,2],[nMT,0,nMB,0,nMT],5,1,wf9(:,1))
  call Hloop_AS_Q(ntryL,G0H144(1),wf9(:,1),G0H16(1),ngH,m3h9x16(:,10),heltab2x144(:,:,40))
  call Hloop_A_Q(ntryL,G0H16(1),48,nMT,G1H16(10),n2h16(10))
  Gcoeff(:)%j = (c(22)*M(1,:)%j+c(16)*M(2,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(41),h0tab(:,41),[48,1,8,4,2],[nMT,0,nMB,0,nMT],5,1,wf9(:,2))
  call Hloop_AV_Q(ntryL,G0H144(1),wf9(:,2),G0H16(1),m3h9x16(:,11),heltab2x144(:,:,41))
  call Hloop_A_Q(ntryL,G0H16(1),48,nMT,G1H16(11),n2h16(11))
  Gcoeff(:)%j = (c(74)*M(1,:)%j+c(68)*M(2,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(42),h0tab(:,42),[48,1,8,4,2],[nMT,0,nMB,0,nMT],5,1,wf9(:,3))
  call Hloop_AZ_Q(ntryL,G0H144(1),wf9(:,3),G0H16(1),ngZu,m3h9x16(:,12),heltab2x144(:,:,42))
  call Hloop_A_Q(ntryL,G0H16(1),48,nMT,G1H16(12),n2h16(12))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(3),[G1H16(2),G1H16(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(6),[G1H16(5),G1H16(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(9),[G1H16(8),G1H16(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(12),[G1H16(11),G1H16(10)])
  call Hloop_QV_A(ntryL,G1H48(1),wf4(:,1),G1H12(1),m3h4x12(:,1),heltab2x48(:,:,7))
  call Hloop_Q_A(ntryL,G1H12(1),35,nMT,G2H12(3),n2h12(9))
  call Hloop_AQ_V(ntryL,G1H48(2),ex3(:),G1H24(3),m3h2x24(:,7),heltab2x48(:,:,8))
  call Hloop_AV_Q(ntryL,G1H48(3),wf4(:,1),G1H12(2),m3h4x12(:,2),heltab2x48(:,:,9))
  call Hloop_A_Q(ntryL,G1H12(2),35,nMB,G2H12(4),n2h12(10))
  call Hloop_AQ_V(ntryL,G1H48(4),ex3(:),G1H24(4),m3h2x24(:,8),heltab2x48(:,:,10))
  call Hloop_QA_V(ntryL,G1H48(5),ex2(:),G1H24(5),m3h2x24(:,9),heltab2x48(:,:,11))
  call Hloop_QV_A(ntryL,G1H48(6),wf4(:,2),G1H12(5),m3h4x12(:,3),heltab2x48(:,:,12))
  call Hloop_Q_A(ntryL,G1H12(5),44,nMT,G2H12(5),n2h12(11))
  call Hloop_QA_V(ntryL,G1H48(7),ex2(:),G1H24(6),m3h2x24(:,10),heltab2x48(:,:,13))
  call Hloop_QA_V(ntryL,G1H48(8),ex2(:),G1H24(7),m3h2x24(:,11),heltab2x48(:,:,14))
  call Hloop_QA_V(ntryL,G1H48(9),ex2(:),G1H24(8),m3h2x24(:,12),heltab2x48(:,:,15))
  call Hloop_QA_V(ntryL,G1H48(10),ex2(:),G1H24(9),m3h2x24(:,13),heltab2x48(:,:,16))
  call Hloop_QA_V(ntryL,G1H48(11),ex2(:),G1H24(10),m3h2x24(:,14),heltab2x48(:,:,17))
  call Hloop_QA_V(ntryL,G1H48(12),ex2(:),G1H24(11),m3h2x24(:,15),heltab2x48(:,:,18))
  call Hloop_AQ_V(ntryL,G1H48(13),ex3(:),G1H24(12),m3h2x24(:,16),heltab2x48(:,:,19))
  call Hloop_AQ_V(ntryL,G1H48(14),ex3(:),G1H24(13),m3h2x24(:,17),heltab2x48(:,:,20))
  call Hloop_QA_V(ntryL,G1H48(15),ex2(:),G1H24(14),m3h2x24(:,18),heltab2x48(:,:,21))
  call Hloop_QA_V(ntryL,G1H48(16),ex2(:),G1H24(15),m3h2x24(:,19),heltab2x48(:,:,22))
  call Hloop_VA_Q(ntryL,G0H24(1),ex4(:),G0H12(1),m3h2x12(:,7),heltab2x24(:,:,7))
  call Hloop_A_Q(ntryL,G0H12(1),42,nMB,G1H12(6),n2h12(12))
  call Hloop_AQ_V(ntryL,G1H24(1),ex3(:),G1H12(7),m3h2x12(:,8),heltab2x24(:,:,8))
  call Hloop_VQ_A(ntryL,G0H24(2),ex3(:),G0H12(1),m3h2x12(:,9),heltab2x24(:,:,9))
  call Hloop_Q_A(ntryL,G0H12(1),38,nMB,G1H12(8),n2h12(13))
  call Hloop_VQ_A(ntryL,G0H24(3),ex1(:),G0H12(1),m3h2x12(:,10),heltab2x24(:,:,10))
  call Hloop_Q_A(ntryL,G0H12(1),35,nMT,G1H12(11),n2h12(14))
  call Hloop_VA_Q(ntryL,G0H24(4),ex2(:),G0H12(1),m3h2x12(:,11),heltab2x24(:,:,11))
  call Hloop_A_Q(ntryL,G0H12(1),38,nMT,G1H12(12),n2h12(15))
  call Hloop_QA_V(ntryL,G1H24(2),ex2(:),G1H12(1),m3h2x12(:,12),heltab2x24(:,:,12))
  call Hloop_VQ_A(ntryL,G0H24(5),ex1(:),G0H12(1),m3h2x12(:,13),heltab2x24(:,:,13))
  call Hloop_Q_A(ntryL,G0H12(1),37,nMT,G1H12(2),n2h12(16))
  call Hloop_VQ_A(ntryL,G0H24(6),ex1(:),G0H12(1),m3h2x12(:,14),heltab2x24(:,:,14))
  call Hloop_Q_A(ntryL,G0H12(1),37,nMT,G1H12(5),n2h12(17))
  call Hloop_AQ_V(ntryL,G1H16(3),ex3(:),G1H8(1),m3h2x8(:,1),heltab2x16(:,:,1))
  call Hloop_AQ_V(ntryL,G1H16(6),ex3(:),G1H8(2),m3h2x8(:,2),heltab2x16(:,:,2))
  call Hloop_AQ_V(ntryL,G1H16(9),ex1(:),G1H8(3),m3h2x8(:,3),heltab2x16(:,:,3))
  call Hloop_AQ_V(ntryL,G1H16(12),ex1(:),G1H8(4),m3h2x8(:,4),heltab2x16(:,:,4))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(11),[G1H12(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(3),[G1H12(4)])
  call Hloop_QW_A(ntryL,G1H12(11),ex5(:),G1H4(1),m3h3x4(:,7),heltab2x12(:,:,13))
  call Hloop_Q_A(ntryL,G1H4(1),51,nMB,G2H4(1),n2h4(7))
  call Hotf_5pt_reduction(G2H12(3),RedSet_5(7),mass5set(:,5),  & 
G1H12(3),G1H12(4),G1H12(11),G1H12(13),G1H12(14),G1H12(15),12)
  call HG1shiftOLR(G1H12(4),4,12)
  call Hloop_AW_Q(ntryL,G1H12(9),ex5(:),G1H4(1),m3h3x4(:,8),heltab2x12(:,:,14))
  call Hloop_A_Q(ntryL,G1H4(1),58,nMT,G2H4(3),n2h4(8))
  call Hloop_AW_Q(ntryL,G1H12(10),ex5(:),G1H4(1),m3h3x4(:,9),heltab2x12(:,:,15))
  call Hloop_A_Q(ntryL,G1H4(1),58,nMT,G2H4(4),n2h4(9))
  call Hloop_VA_Q(ntryL,G1H24(3),ex4(:),G1H12(9),m3h2x12(:,15),heltab2x24(:,:,15))
  call Hloop_A_Q(ntryL,G1H12(9),44,nMB,G2H12(6),n2h12(18))
  call Hloop_AQ_V(ntryL,G2H12(4),ex3(:),G2H6(1),m3h2x6(:,7),heltab2x12(:,:,16))
  call Hloop_UV_W(ntryL,G1H24(4),36,wf4(:,1),3,G2H6(2),m3h4x6(:,1),heltab2x24(:,:,16))
  call Hloop_VQ_A(ntryL,G1H24(5),ex1(:),G1H12(10),m3h2x12(:,16),heltab2x24(:,:,17))
  call Hloop_Q_A(ntryL,G1H12(10),35,nMT,G2H12(1),n2h12(19))
  call Hloop_QA_V(ntryL,G2H12(5),ex2(:),G2H6(3),m3h2x6(:,8),heltab2x12(:,:,17))
  call Hloop_VQ_A(ntryL,G1H24(6),ex1(:),G1H12(9),m3h2x12(:,17),heltab2x24(:,:,18))
  call Hloop_Q_A(ntryL,G1H12(9),35,nMT,G2H12(2),n2h12(20))
  call Hloop_UV_W(ntryL,G1H24(7),34,wf4(:,2),12,G2H6(4),m3h4x6(:,2),heltab2x24(:,:,19))
  call Hloop_VQ_A(ntryL,G1H24(8),ex3(:),G1H12(10),m3h2x12(:,18),heltab2x24(:,:,20))
  call Hloop_Q_A(ntryL,G1H12(10),38,nMB,G2H12(3),n2h12(21))
  call Hloop_VA_Q(ntryL,G1H24(9),ex4(:),G1H12(9),m3h2x12(:,19),heltab2x24(:,:,21))
  call Hloop_A_Q(ntryL,G1H12(9),42,nMB,G2H12(4),n2h12(22))
  call Hloop_VA_Q(ntryL,G1H24(10),ex4(:),G1H12(10),m3h2x12(:,20),heltab2x24(:,:,22))
  call Hloop_A_Q(ntryL,G1H12(10),42,nMB,G2H12(5),n2h12(23))
  call Hloop_VQ_A(ntryL,G1H24(11),wf6(:,7),G1H4(1),m3h6x4(:,1),heltab2x24(:,:,23))
  call Hloop_Q_A(ntryL,G1H4(1),51,nMB,G2H4(6),n2h4(10))
  call Hloop_VQ_A(ntryL,G1H24(12),ex1(:),G1H12(9),m3h2x12(:,21),heltab2x24(:,:,24))
  call Hloop_Q_A(ntryL,G1H12(9),37,nMT,G2H12(7),n2h12(24))
  call Hloop_VA_Q(ntryL,G1H24(13),ex2(:),G1H12(10),m3h2x12(:,22),heltab2x24(:,:,25))
  call Hloop_A_Q(ntryL,G1H12(10),38,nMT,G2H12(8),n2h12(25))
  call Hloop_VQ_A(ntryL,G1H24(14),ex1(:),G1H12(9),m3h2x12(:,23),heltab2x24(:,:,26))
  call Hloop_Q_A(ntryL,G1H12(9),35,nMT,G2H12(9),n2h12(26))
  call Hloop_VA_Q(ntryL,G1H24(15),wf6(:,4),G1H4(1),m3h6x4(:,2),heltab2x24(:,:,27))
  call Hloop_A_Q(ntryL,G1H4(1),58,nMT,G2H4(7),n2h4(11))
  call Hloop_AQ_V(ntryL,G1H12(6),ex3(:),G1H6(1),m3h2x6(:,9),heltab2x12(:,:,18))
  call Hloop_VQ_A(ntryL,G1H12(7),ex1(:),G1H6(2),m3h2x6(:,10),heltab2x12(:,:,19))
  call Hloop_Q_A(ntryL,G1H6(2),39,nMT,G2H6(7),n2h6(5))
  call Hloop_QA_V(ntryL,G1H12(8),ex4(:),G1H6(6),m3h2x6(:,11),heltab2x12(:,:,20))
  call Hloop_AQ_V(ntryL,G1H12(12),ex1(:),G1H6(7),m3h2x6(:,12),heltab2x12(:,:,21))
  call Hloop_VQ_A(ntryL,G1H12(1),ex1(:),G1H6(8),m3h2x6(:,13),heltab2x12(:,:,22))
  call Hloop_Q_A(ntryL,G1H6(8),39,nMT,G2H6(8),n2h6(6))
  call Hloop_QA_V(ntryL,G1H12(2),ex2(:),G1H6(12),m3h2x6(:,14),heltab2x12(:,:,23))
  call Hloop_QW_A(ntryL,G1H12(5),ex5(:),G1H4(1),m3h3x4(:,10),heltab2x12(:,:,24))
  call Hloop_Q_A(ntryL,G1H4(1),53,nMB,G2H4(8),n2h4(12))
  call Hloop_VQ_A(ntryL,G1H8(1),ex1(:),G1H4(1),m3h2x4(:,1),heltab2x8(:,:,1))
  call Hloop_Q_A(ntryL,G1H4(1),53,nMT,G2H4(9),n2h4(13))
  call Hloop_VA_Q(ntryL,G1H8(2),ex2(:),G1H4(1),m3h2x4(:,2),heltab2x8(:,:,2))
  call Hloop_A_Q(ntryL,G1H4(1),54,nMT,G2H4(10),n2h4(14))
  call Hloop_VQ_A(ntryL,G1H8(3),ex3(:),G1H4(1),m3h2x4(:,3),heltab2x8(:,:,3))
  call Hloop_Q_A(ntryL,G1H4(1),53,nMB,G2H4(11),n2h4(15))
  call Hloop_VA_Q(ntryL,G1H8(4),ex4(:),G1H4(1),m3h2x4(:,4),heltab2x8(:,:,4))
  call Hloop_A_Q(ntryL,G1H4(1),57,nMB,G2H4(12),n2h4(16))
  call Hloop_QW_A(ntryL,G1H12(3),ex5(:),G1H4(1),m3h3x4(:,11),heltab2x12(:,:,25))
  call Hloop_Q_A(ntryL,G1H4(1),51,nMB,G2H4(13),n2h4(17))
call HGT_OLR(G1H12(4),1,1,12)
call HGT_invQ_OLR(G1H12(4),2,5,12)
  call Hloop_A_Q(ntryL,G1H12(4),-4,nMB,G2H12(10),n2h12(27))
  call Hloop_AQ_V(ntryL,G2H12(10),ex3(:),G2H6(9),m3h2x6(:,15),heltab2x12(:,:,26))
  call Hloop_QW_A(ntryL,G1H12(13),ex5(:),G1H4(1),m3h3x4(:,12),heltab2x12(:,:,27))
  call Hloop_Q_A(ntryL,G1H4(1),51,nMB,G2H4(14),n2h4(18))
  call Hloop_QW_A(ntryL,G1H12(14),ex5(:),G1H4(1),m3h3x4(:,13),heltab2x12(:,:,28))
  call Hloop_Q_A(ntryL,G1H4(1),51,nMB,G2H4(15),n2h4(19))
  call Hloop_QW_A(ntryL,G1H12(15),ex5(:),G1H4(1),m3h3x4(:,14),heltab2x12(:,:,29))
  call Hloop_Q_A(ntryL,G1H4(1),51,nMB,G2H4(16),n2h4(20))
call HGT_lower_alpha_w2_OLR(G2H6(5),1,1,6)
call HGT_lower_alpha_w2_invQ_OLR(G2H6(5),2,5,6)
call HGT_lower_alpha_w2_OLR(G2H6(5),6,15,6)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(5),[G2H6(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(6),[G2H4(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(7),[G2H4(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(12),[G1H6(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(2),[G1H6(11),G1H6(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(7),[G1H6(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(1),[G1H6(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(4),[G1H6(23),G1H6(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(6),[G1H6(21)])
  call Hotf_5pt_reduction(G2H6(5),RedSet_5(8),mass5set(:,6),  & 
G1H6(13),G1H6(14),G1H6(18),G1H6(19),G1H6(20),G1H6(24),6)
  call HG1shiftOLR(G1H6(14),8,6)
  call Hloop_QA_V(ntryL,G2H4(6),ex4(:),G2H2(1),m3h2x2(:,5),heltab2x4(:,:,5))
call HGT_lower_alpha_w2_OLR(G2H6(6),1,1,6)
call HGT_lower_alpha_w2_invQ_OLR(G2H6(6),2,5,6)
call HGT_lower_alpha_w2_OLR(G2H6(6),6,15,6)
  call Hotf_5pt_reduction(G2H6(6),RedSet_5(9),mass5set(:,7),  & 
G1H6(2),G1H6(8),G1H6(3),G1H6(11),G1H6(5),G1H6(9),6)
  call HG1shiftOLR(G1H6(8),1,6)
  call Hloop_AQ_V(ntryL,G2H4(7),ex1(:),G2H2(3),m3h2x2(:,6),heltab2x4(:,:,6))
  call Hloop_VA_Q(ntryL,G1H6(12),ex4(:),G1H3(1),m3h2x3(:,9),heltab2x6(:,:,13))
  call Hloop_A_Q(ntryL,G1H3(1),47,nMB,G2H3(1),n2h3(9))
  call Hloop_VA_Q(ntryL,G1H6(4),ex4(:),G1H3(2),m3h2x3(:,10),heltab2x6(:,:,14))
  call Hloop_A_Q(ntryL,G1H3(2),47,nMB,G2H3(3),n2h3(10))
  call Hotf_5pt_reduction(G2H6(2),RedSet_5(10),mass5set(:,8),  & 
G1H6(15),G1H6(23),G1H6(17),G1H6(21),G1H6(12),G1H6(4),6)
  call HG1shiftOLR(G1H6(23),16,6)
  call Hloop_VA_Q(ntryL,G1H6(7),ex4(:),G1H3(7),m3h2x3(:,11),heltab2x6(:,:,15))
  call Hloop_A_Q(ntryL,G1H3(7),47,nMB,G2H3(5),n2h3(11))
  call Hloop_VA_Q(ntryL,G1H6(10),ex4(:),G1H3(8),m3h2x3(:,12),heltab2x6(:,:,16))
  call Hloop_A_Q(ntryL,G1H3(8),47,nMB,G2H3(7),n2h3(12))
  call Hloop_VQ_A(ntryL,G1H6(1),ex1(:),G1H3(13),m3h2x3(:,13),heltab2x6(:,:,17))
  call Hloop_Q_A(ntryL,G1H3(13),47,nMT,G2H3(9),n2h3(13))
  call Hloop_VQ_A(ntryL,G1H6(16),ex1(:),G1H3(14),m3h2x3(:,14),heltab2x6(:,:,18))
  call Hloop_Q_A(ntryL,G1H3(14),47,nMT,G2H3(10),n2h3(14))
  call Hotf_5pt_reduction(G2H6(4),RedSet_5(11),mass5set(:,9),  & 
G1H6(7),G1H6(10),G1H6(1),G1H6(16),G1H6(25),G1H6(26),6)
  call HG1shiftOLR(G1H6(10),16,6)
  call Hloop_VQ_A(ntryL,G1H6(6),ex1(:),G1H3(19),m3h2x3(:,15),heltab2x6(:,:,19))
  call Hloop_Q_A(ntryL,G1H3(19),47,nMT,G2H3(11),n2h3(15))
  call Hloop_VQ_A(ntryL,G1H6(22),ex1(:),G1H3(20),m3h2x3(:,16),heltab2x6(:,:,20))
  call Hloop_Q_A(ntryL,G1H3(20),47,nMT,G2H3(12),n2h3(16))
  call Hloop_QA_V(ntryL,G2H4(1),ex4(:),G2H2(9),m3h2x2(:,7),heltab2x4(:,:,7))
  call Hloop_AQ_V(ntryL,G2H4(3),ex1(:),G2H2(10),m3h2x2(:,8),heltab2x4(:,:,8))
  call Hloop_AQ_V(ntryL,G2H4(4),ex1(:),G2H2(11),m3h2x2(:,9),heltab2x4(:,:,9))
  call Hotf_5pt_reduction(G2H12(6),RedSet_5(12),mass5set(:,10),  & 
G1H12(10),G1H12(9),G1H12(6),G1H12(7),G1H12(8),G1H12(12),12)
  call HG1shiftOLR(G1H12(9),16,12)
  call Hotf_5pt_reduction(G2H6(1),RedSet_5(13),mass5set(:,11),  & 
G1H6(6),G1H6(22),G1H6(27),G1H6(28),G1H6(29),G1H6(30),6)
  call HG1shiftOLR(G1H6(22),16,6)
  call Hotf_5pt_reduction(G2H12(1),RedSet_5(1),mass5set(:,1),  & 
G1H12(1),G1H12(2),G1H12(5),G1H12(3),G1H12(4),G1H12(13),12)
  call HG1shiftOLR(G1H12(2),12,12)
  call Hotf_5pt_reduction(G2H6(3),RedSet_5(14),mass5set(:,12),  & 
G1H6(31),G1H6(32),G1H6(33),G1H6(34),G1H6(35),G1H6(36),6)
  call HG1shiftOLR(G1H6(32),16,6)
  call Hotf_5pt_reduction(G2H12(2),RedSet_5(15),mass5set(:,13),  & 
G1H12(14),G1H12(15),G1H12(16),G1H12(17),G1H12(18),G1H12(19),12)
  call HG1shiftOLR(G1H12(15),16,12)
  call Hloop_QA_V(ntryL,G2H12(3),ex4(:),G2H6(8),m3h2x6(:,16),heltab2x12(:,:,30))
  call Hloop_AQ_V(ntryL,G2H12(4),ex3(:),G2H6(5),m3h2x6(:,17),heltab2x12(:,:,31))
  call Hloop_AQ_V(ntryL,G2H12(5),wf6(:,7),G2H2(12),m3h6x2(:,1),heltab2x12(:,:,32))
  call Hloop_QA_V(ntryL,G2H12(7),ex2(:),G2H6(6),m3h2x6(:,18),heltab2x12(:,:,33))
  call Hloop_AQ_V(ntryL,G2H12(8),ex1(:),G2H6(2),m3h2x6(:,19),heltab2x12(:,:,34))
  call Hloop_QA_V(ntryL,G2H12(9),wf6(:,4),G2H2(13),m3h6x2(:,2),heltab2x12(:,:,35))
  call Hotf_5pt_reduction(G2H6(7),RedSet_5(16),mass5set(:,14),  & 
G1H6(37),G1H6(38),G1H6(39),G1H6(40),G1H6(41),G1H6(42),6)
  call HG1shiftOLR(G1H6(38),8,6)
  call Hloop_QA_V(ntryL,G2H4(8),ex4(:),G2H2(14),m3h2x2(:,10),heltab2x4(:,:,10))
  call Hloop_QA_V(ntryL,G2H4(9),ex2(:),G2H2(15),m3h2x2(:,11),heltab2x4(:,:,11))
  call Hloop_AQ_V(ntryL,G2H4(10),ex1(:),G2H2(16),m3h2x2(:,12),heltab2x4(:,:,12))
  call Hloop_QA_V(ntryL,G2H4(11),ex4(:),G2H2(17),m3h2x2(:,13),heltab2x4(:,:,13))
  call Hloop_AQ_V(ntryL,G2H4(12),ex3(:),G2H2(18),m3h2x2(:,14),heltab2x4(:,:,14))
  call Hloop_QA_V(ntryL,G2H4(13),ex4(:),G2H2(19),m3h2x2(:,15),heltab2x4(:,:,15))
  call Hloop_QA_V(ntryL,G2H4(15),ex4(:),G2H2(20),m3h2x2(:,16),heltab2x4(:,:,16))
  call Hloop_QA_V(ntryL,G2H4(16),ex4(:),G2H2(21),m3h2x2(:,17),heltab2x4(:,:,17))
  call Hloop_QW_A(ntryL,G1H6(13),ex5(:),G1H2(1),m3h3x2(:,5),heltab2x6(:,:,21))
  call Hloop_Q_A(ntryL,G1H2(1),55,nMB,G2H2(22),n2h2(1))
call HGT_raise_alpha_OLR(G1H6(14),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(14),2,5,6)
  call Hloop_VA_Q(ntryL,G1H6(14),ex4(:),G1H3(1),m3h2x3(:,17),heltab2x6(:,:,22))
  call Hloop_QW_A(ntryL,G1H6(20),ex5(:),G1H2(2),m3h3x2(:,6),heltab2x6(:,:,23))
  call Hloop_Q_A(ntryL,G1H2(2),55,nMB,G2H2(23),n2h2(2))
  call Hloop_QW_A(ntryL,G1H6(24),ex5(:),G1H2(7),m3h3x2(:,7),heltab2x6(:,:,24))
  call Hloop_Q_A(ntryL,G1H2(7),55,nMB,G2H2(24),n2h2(3))
  call Hloop_AW_Q(ntryL,G1H6(2),ex5(:),G1H2(8),m3h3x2(:,8),heltab2x6(:,:,25))
  call Hloop_A_Q(ntryL,G1H2(8),62,nMT,G2H2(25),n2h2(4))
call HGT_raise_alpha_OLR(G1H6(8),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(8),2,5,6)
  call Hloop_VQ_A(ntryL,G1H6(8),ex1(:),G1H3(2),m3h2x3(:,18),heltab2x6(:,:,26))
  call Hloop_AW_Q(ntryL,G1H6(5),ex5(:),G1H2(1),m3h3x2(:,9),heltab2x6(:,:,27))
  call Hloop_A_Q(ntryL,G1H2(1),62,nMT,G2H2(26),n2h2(5))
  call Hloop_AW_Q(ntryL,G1H6(9),ex5(:),G1H2(2),m3h3x2(:,10),heltab2x6(:,:,28))
  call Hloop_A_Q(ntryL,G1H2(2),62,nMT,G2H2(27),n2h2(6))
  call Hloop_VA_Q(ntryL,G1H6(15),ex4(:),G1H3(7),m3h2x3(:,19),heltab2x6(:,:,29))
  call Hloop_A_Q(ntryL,G1H3(7),47,nMB,G2H3(13),n2h3(17))
call HGT_OLR(G1H6(23),1,1,6)
call HGT_invQ_OLR(G1H6(23),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(23),-16,nMT,G2H6(4),n2h6(9))
  call Hloop_QW_A(ntryL,G2H6(4),ex5(:),G2H2(28),m3h3x2(:,11),heltab2x6(:,:,30))
  call Hloop_VA_Q(ntryL,G1H6(12),ex4(:),G1H3(8),m3h2x3(:,20),heltab2x6(:,:,31))
  call Hloop_A_Q(ntryL,G1H3(8),47,nMB,G2H3(14),n2h3(18))
  call Hloop_VA_Q(ntryL,G1H6(4),ex4(:),G1H3(13),m3h2x3(:,21),heltab2x6(:,:,32))
  call Hloop_A_Q(ntryL,G1H3(13),47,nMB,G2H3(15),n2h3(19))
  call Hloop_VQ_A(ntryL,G1H6(7),ex1(:),G1H3(14),m3h2x3(:,22),heltab2x6(:,:,33))
  call Hloop_Q_A(ntryL,G1H3(14),47,nMT,G2H3(16),n2h3(20))
call HGT_OLR(G1H6(10),1,1,6)
call HGT_invQ_OLR(G1H6(10),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(10),-16,nMB,G2H6(1),n2h6(10))
  call Hloop_AW_Q(ntryL,G2H6(1),ex5(:),G2H2(29),m3h3x2(:,12),heltab2x6(:,:,34))
  call Hloop_VQ_A(ntryL,G1H6(25),ex1(:),G1H3(19),m3h2x3(:,23),heltab2x6(:,:,35))
  call Hloop_Q_A(ntryL,G1H3(19),47,nMT,G2H3(17),n2h3(21))
  call Hloop_VQ_A(ntryL,G1H6(26),ex1(:),G1H3(20),m3h2x3(:,24),heltab2x6(:,:,36))
  call Hloop_Q_A(ntryL,G1H3(20),47,nMT,G2H3(18),n2h3(22))
  call Hloop_AV_Q(ntryL,G1H12(10),wf4(:,1),G1H3(7),m3h4x3(:,1),heltab2x12(:,:,36))
  call Hloop_A_Q(ntryL,G1H3(7),47,nMB,G2H3(19),n2h3(23))
call HGT_OLR(G1H12(9),1,1,12)
call HGT_invQ_OLR(G1H12(9),2,5,12)
  call Hloop_Q_A(ntryL,G1H12(9),-16,nMT,G2H12(10),n2h12(28))
  call Hloop_QW_A(ntryL,G2H12(10),ex5(:),G2H4(2),m3h3x4(:,15),heltab2x12(:,:,37))
  call Hloop_AV_Q(ntryL,G1H12(8),wf4(:,1),G1H3(8),m3h4x3(:,2),heltab2x12(:,:,38))
  call Hloop_A_Q(ntryL,G1H3(8),47,nMB,G2H3(20),n2h3(24))
  call Hloop_AV_Q(ntryL,G1H12(12),wf4(:,1),G1H3(13),m3h4x3(:,3),heltab2x12(:,:,39))
  call Hloop_A_Q(ntryL,G1H3(13),47,nMB,G2H3(21),n2h3(25))
  call Hloop_VA_Q(ntryL,G1H6(6),ex4(:),G1H3(14),m3h2x3(:,25),heltab2x6(:,:,37))
  call Hloop_A_Q(ntryL,G1H3(14),47,nMB,G2H3(22),n2h3(26))
call HGT_OLR(G1H6(22),1,1,6)
call HGT_invQ_OLR(G1H6(22),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(22),-16,nMT,G2H6(3),n2h6(11))
  call Hloop_QW_A(ntryL,G2H6(3),ex5(:),G2H2(30),m3h3x2(:,13),heltab2x6(:,:,38))
  call Hloop_VA_Q(ntryL,G1H6(29),ex4(:),G1H3(19),m3h2x3(:,26),heltab2x6(:,:,39))
  call Hloop_A_Q(ntryL,G1H3(19),47,nMB,G2H3(23),n2h3(27))
  call Hloop_VA_Q(ntryL,G1H6(30),ex4(:),G1H3(20),m3h2x3(:,27),heltab2x6(:,:,40))
  call Hloop_A_Q(ntryL,G1H3(20),47,nMB,G2H3(24),n2h3(28))
  call Hloop_QW_A(ntryL,G1H12(1),ex5(:),G1H4(1),m3h3x4(:,16),heltab2x12(:,:,40))
  call Hloop_Q_A(ntryL,G1H4(1),51,nMB,G2H4(5),n2h4(21))
call HGT_OLR(G1H12(2),1,1,12)
call HGT_invQ_OLR(G1H12(2),2,5,12)
  call Hloop_A_Q(ntryL,G1H12(2),-12,nMB,G2H12(6),n2h12(29))
  call Hloop_AV_Q(ntryL,G2H12(6),wf4(:,2),G2H3(25),m3h4x3(:,4),heltab2x12(:,:,41))
  call Hloop_QW_A(ntryL,G1H12(4),ex5(:),G1H4(1),m3h3x4(:,17),heltab2x12(:,:,42))
  call Hloop_Q_A(ntryL,G1H4(1),51,nMB,G2H4(6),n2h4(22))
  call Hloop_QW_A(ntryL,G1H12(13),ex5(:),G1H4(1),m3h3x4(:,18),heltab2x12(:,:,43))
  call Hloop_Q_A(ntryL,G1H4(1),51,nMB,G2H4(7),n2h4(23))
  call Hloop_VQ_A(ntryL,G1H6(31),ex1(:),G1H3(7),m3h2x3(:,28),heltab2x6(:,:,41))
  call Hloop_Q_A(ntryL,G1H3(7),47,nMT,G2H3(26),n2h3(29))
call HGT_OLR(G1H6(32),1,1,6)
call HGT_invQ_OLR(G1H6(32),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(32),-16,nMB,G2H6(7),n2h6(12))
  call Hloop_AW_Q(ntryL,G2H6(7),ex5(:),G2H2(31),m3h3x2(:,14),heltab2x6(:,:,42))
  call Hloop_VQ_A(ntryL,G1H6(35),ex1(:),G1H3(8),m3h2x3(:,29),heltab2x6(:,:,43))
  call Hloop_Q_A(ntryL,G1H3(8),47,nMT,G2H3(27),n2h3(30))
  call Hloop_VQ_A(ntryL,G1H6(36),ex1(:),G1H3(13),m3h2x3(:,30),heltab2x6(:,:,44))
  call Hloop_Q_A(ntryL,G1H3(13),47,nMT,G2H3(28),n2h3(31))
  call Hloop_QV_A(ntryL,G1H12(14),wf4(:,2),G1H3(14),m3h4x3(:,5),heltab2x12(:,:,44))
  call Hloop_Q_A(ntryL,G1H3(14),47,nMT,G2H3(29),n2h3(32))
call HGT_OLR(G1H12(15),1,1,12)
call HGT_invQ_OLR(G1H12(15),2,5,12)
  call Hloop_A_Q(ntryL,G1H12(15),-16,nMB,G2H12(1),n2h12(30))
  call Hloop_AW_Q(ntryL,G2H12(1),ex5(:),G2H4(1),m3h3x4(:,19),heltab2x12(:,:,45))
  call Hloop_QV_A(ntryL,G1H12(18),wf4(:,2),G1H3(19),m3h4x3(:,6),heltab2x12(:,:,46))
  call Hloop_Q_A(ntryL,G1H3(19),47,nMT,G2H3(30),n2h3(33))
  call Hloop_QV_A(ntryL,G1H12(19),wf4(:,2),G1H3(20),m3h4x3(:,7),heltab2x12(:,:,47))
  call Hloop_Q_A(ntryL,G1H3(20),47,nMT,G2H3(31),n2h3(34))
  call Hloop_QW_A(ntryL,G1H6(37),ex5(:),G1H2(7),m3h3x2(:,15),heltab2x6(:,:,45))
  call Hloop_Q_A(ntryL,G1H2(7),55,nMB,G2H2(32),n2h2(7))
call HGT_raise_alpha_OLR(G1H6(38),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(38),2,5,6)
  call Hloop_VA_Q(ntryL,G1H6(38),ex4(:),G1H3(7),m3h2x3(:,31),heltab2x6(:,:,46))
  call Hloop_QW_A(ntryL,G1H6(41),ex5(:),G1H2(8),m3h3x2(:,16),heltab2x6(:,:,47))
  call Hloop_Q_A(ntryL,G1H2(8),55,nMB,G2H2(33),n2h2(8))
  call Hloop_QW_A(ntryL,G1H6(42),ex5(:),G1H2(1),m3h3x2(:,17),heltab2x6(:,:,48))
  call Hloop_Q_A(ntryL,G1H2(1),55,nMB,G2H2(34),n2h2(9))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(13),[G2H2(2),G1H2(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(12),[G2H2(4),G1H2(12)])
call HGT_OLR(G2H2(5),1,1,2)
call HGT_invQ_OLR(G2H2(5),2,5,2)
call HGT_OLR(G2H2(5),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(5),[G2H2(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(2),[G1H3(6)])
call HGT_OLR(G2H2(6),1,1,2)
call HGT_invQ_OLR(G2H2(6),2,5,2)
call HGT_OLR(G2H2(6),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(6),[G2H2(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(4),[G1H3(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(6),[G1H3(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(8),[G1H3(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(9),[G1H2(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(19),[G1H2(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(1),[G1H2(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(10),[G1H2(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(11),[G1H2(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(3),[G1H2(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(1),[G1H3(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(3),[G1H3(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(13),[G1H3(11),G1H3(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(5),[G1H3(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(7),[G1H3(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(9),[G1H3(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(10),[G1H3(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(16),[G1H3(23),G1H3(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(11),[G1H3(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(12),[G1H3(22)])
  call Hotf_5pt_reduction(G2H2(13),RedSet_5(17),mass5set(:,15),  & 
G1H2(2),G1H2(7),G1H2(8),G1H2(1),G1H2(6),G1H2(12),2)
  call HG1shiftOLR(G1H2(7),4,2)
  call Hotf_5pt_reduction(G2H2(12),RedSet_5(18),mass5set(:,4),  & 
G1H2(3),G1H2(4),G1H2(5),G1H2(9),G1H2(10),G1H2(11),2)
  call HG1shiftOLR(G1H2(4),4,2)
  call Hotf_5pt_reduction(G2H2(5),RedSet_5(19),mass5set(:,16),  & 
G1H2(13),G1H2(14),G1H2(15),G1H2(16),G1H2(17),G1H2(18),2)
  call HG1shiftOLR(G1H2(14),8,2)
  call Hotf_5pt_reduction(G2H3(2),RedSet_5(20),mass5set(:,17),  & 
G1H3(8),G1H3(13),G1H3(14),G1H3(19),G1H3(20),G1H3(6),3)
  call HG1shiftOLR(G1H3(13),16,3)
  call Hotf_5pt_reduction(G2H2(6),RedSet_5(21),mass5set(:,16),  & 
G1H2(19),G1H2(20),G1H2(21),G1H2(22),G1H2(23),G1H2(24),2)
  call HG1shiftOLR(G1H2(20),8,2)
  call Hotf_5pt_reduction(G2H3(4),RedSet_5(22),mass5set(:,17),  & 
G1H3(12),G1H3(18),G1H3(24),G1H3(3),G1H3(4),G1H3(11),3)
  call HG1shiftOLR(G1H3(18),16,3)
call HGT_OLR(G2H2(7),1,1,2)
call HGT_invQ_OLR(G2H2(7),2,5,2)
call HGT_OLR(G2H2(7),6,15,2)
  call Hotf_5pt_reduction(G2H2(7),RedSet_5(23),mass5set(:,18),  & 
G1H2(25),G1H2(26),G1H2(27),G1H2(28),G1H2(29),G1H2(30),2)
  call HG1shiftOLR(G1H2(26),1,2)
  call Hotf_5pt_reduction(G2H3(6),RedSet_5(24),mass5set(:,2),  & 
G1H3(5),G1H3(9),G1H3(10),G1H3(15),G1H3(16),G1H3(23),3)
  call HG1shiftOLR(G1H3(9),16,3)
call HGT_OLR(G2H2(8),1,1,2)
call HGT_invQ_OLR(G2H2(8),2,5,2)
call HGT_OLR(G2H2(8),6,15,2)
  call Hotf_5pt_reduction(G2H2(8),RedSet_5(25),mass5set(:,18),  & 
G1H2(31),G1H2(32),G1H2(33),G1H2(34),G1H2(35),G1H2(36),2)
  call HG1shiftOLR(G1H2(32),1,2)
  call Hotf_5pt_reduction(G2H3(8),RedSet_5(26),mass5set(:,2),  & 
G1H3(17),G1H3(21),G1H3(22),G1H3(25),G1H3(26),G1H3(27),3)
  call HG1shiftOLR(G1H3(21),16,3)
  call Hotf_5pt_reduction(G2H2(9),RedSet_5(27),mass5set(:,19),  & 
G1H2(37),G1H2(38),G1H2(39),G1H2(40),G1H2(41),G1H2(42),2)
  call HG1shiftOLR(G1H2(38),4,2)
  call Hotf_5pt_reduction(G2H2(19),RedSet_5(7),mass5set(:,5),  & 
G1H2(43),G1H2(44),G1H2(45),G1H2(46),G1H2(47),G1H2(48),2)
  call HG1shiftOLR(G1H2(44),4,2)
  call Hotf_5pt_reduction(G2H2(1),RedSet_5(28),mass5set(:,4),  & 
G1H2(49),G1H2(50),G1H2(51),G1H2(52),G1H2(53),G1H2(54),2)
  call HG1shiftOLR(G1H2(50),4,2)
  call Hotf_5pt_reduction(G2H2(10),RedSet_5(29),mass5set(:,20),  & 
G1H2(55),G1H2(56),G1H2(57),G1H2(58),G1H2(59),G1H2(60),2)
  call HG1shiftOLR(G1H2(56),4,2)
  call Hotf_5pt_reduction(G2H2(11),RedSet_5(30),mass5set(:,21),  & 
G1H2(61),G1H2(62),G1H2(63),G1H2(64),G1H2(65),G1H2(66),2)
  call HG1shiftOLR(G1H2(62),4,2)
  call Hotf_5pt_reduction(G2H2(3),RedSet_5(31),mass5set(:,15),  & 
G1H2(67),G1H2(68),G1H2(69),G1H2(70),G1H2(71),G1H2(72),2)
  call HG1shiftOLR(G1H2(68),4,2)
  call Hotf_5pt_reduction(G2H3(1),RedSet_5(32),mass5set(:,22),  & 
G1H3(28),G1H3(29),G1H3(30),G1H3(31),G1H3(32),G1H3(33),3)
  call HG1shiftOLR(G1H3(29),16,3)
  call Hotf_5pt_reduction(G2H3(3),RedSet_5(33),mass5set(:,23),  & 
G1H3(34),G1H3(35),G1H3(36),G1H3(37),G1H3(38),G1H3(39),3)
  call HG1shiftOLR(G1H3(35),16,3)
  call Hotf_5pt_reduction(G2H3(13),RedSet_5(10),mass5set(:,8),  & 
G1H3(40),G1H3(41),G1H3(42),G1H3(43),G1H3(44),G1H3(45),3)
  call HG1shiftOLR(G1H3(41),16,3)
  call Hotf_5pt_reduction(G2H3(5),RedSet_5(34),mass5set(:,22),  & 
G1H3(46),G1H3(47),G1H3(48),G1H3(49),G1H3(50),G1H3(51),3)
  call HG1shiftOLR(G1H3(47),16,3)
  call Hotf_5pt_reduction(G2H3(7),RedSet_5(35),mass5set(:,23),  & 
G1H3(52),G1H3(53),G1H3(54),G1H3(55),G1H3(56),G1H3(57),3)
  call HG1shiftOLR(G1H3(53),16,3)
  call Hotf_5pt_reduction(G2H3(9),RedSet_5(36),mass5set(:,24),  & 
G1H3(58),G1H3(59),G1H3(60),G1H3(61),G1H3(62),G1H3(63),3)
  call HG1shiftOLR(G1H3(59),16,3)
  call Hotf_5pt_reduction(G2H3(10),RedSet_5(37),mass5set(:,25),  & 
G1H3(64),G1H3(65),G1H3(66),G1H3(67),G1H3(68),G1H3(69),3)
  call HG1shiftOLR(G1H3(65),16,3)
  call Hotf_5pt_reduction(G2H3(16),RedSet_5(11),mass5set(:,9),  & 
G1H3(70),G1H3(71),G1H3(72),G1H3(73),G1H3(74),G1H3(75),3)
  call HG1shiftOLR(G1H3(71),16,3)
  call Hotf_5pt_reduction(G2H3(11),RedSet_5(38),mass5set(:,24),  & 
G1H3(76),G1H3(77),G1H3(78),G1H3(79),G1H3(80),G1H3(81),3)
  call HG1shiftOLR(G1H3(77),16,3)
  call Hotf_5pt_reduction(G2H3(12),RedSet_5(39),mass5set(:,25),  & 
G1H3(82),G1H3(83),G1H3(84),G1H3(85),G1H3(86),G1H3(87),3)
  call HG1shiftOLR(G1H3(83),16,3)
  call Hotf_5pt_reduction(G2H6(8),RedSet_5(6),mass5set(:,4),  & 
G1H6(13),G1H6(14),G1H6(20),G1H6(24),G1H6(2),G1H6(8),6)
  call HG1shiftOLR(G1H6(14),17,6)
  call Hotf_5pt_reduction(G2H6(5),RedSet_5(5),mass5set(:,4),  & 
G1H6(5),G1H6(9),G1H6(15),G1H6(23),G1H6(12),G1H6(4),6)
  call HG1shiftOLR(G1H6(9),17,6)
  call Hotf_5pt_reduction(G2H6(6),RedSet_5(3),mass5set(:,3),  & 
G1H6(7),G1H6(10),G1H6(25),G1H6(26),G1H6(6),G1H6(22),6)
  call HG1shiftOLR(G1H6(10),24,6)
  call Hotf_5pt_reduction(G2H6(2),RedSet_5(4),mass5set(:,3),  & 
G1H6(29),G1H6(30),G1H6(31),G1H6(32),G1H6(35),G1H6(36),6)
  call HG1shiftOLR(G1H6(30),24,6)
  call Hotf_5pt_reduction(G2H2(14),RedSet_5(40),mass5set(:,26),  & 
G1H2(73),G1H2(74),G1H2(75),G1H2(76),G1H2(77),G1H2(78),2)
  call HG1shiftOLR(G1H2(74),2,2)
  call Hotf_5pt_reduction(G2H2(17),RedSet_5(41),mass5set(:,18),  & 
G1H2(79),G1H2(80),G1H2(81),G1H2(82),G1H2(83),G1H2(84),2)
  call HG1shiftOLR(G1H2(80),2,2)
  call Hotf_5pt_reduction(G2H2(18),RedSet_5(42),mass5set(:,18),  & 
G1H2(85),G1H2(86),G1H2(87),G1H2(88),G1H2(89),G1H2(90),2)
  call HG1shiftOLR(G1H2(86),2,2)
  call Hotf_4pt_reduction(G2H2(21),RedSet_4(8),mass4set(:,1),  & 
G1H2(91),G1H2(92),G1H2(93),G1H2(94),G1H2(95),2)
  call HG1shiftOLR(G1H2(92),12,2)
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(22),ex4(:),G2tensor(1),m3h2x1(:,5),heltab2x2(:,:,5))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(24),ex4(:),G2tensor(3),m3h2x1(:,6),heltab2x2(:,:,6))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(25),ex1(:),G2tensor(5),m3h2x1(:,7),heltab2x2(:,:,7))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(27),ex1(:),G2tensor(7),m3h2x1(:,8),heltab2x2(:,:,8))
  call Hotf_4pt_reduction(G2H3(15),RedSet_4(40),mass4set(:,2),  & 
G1H3(88),G1H3(89),G1H3(90),G1H3(91),G1H3(92),3)
  call HG1shiftOLR(G1H3(89),24,3)
  call Hotf_4pt_reduction(G2H3(18),RedSet_4(65),mass4set(:,3),  & 
G1H3(93),G1H3(94),G1H3(95),G1H3(96),G1H3(97),3)
  call HG1shiftOLR(G1H3(94),17,3)
  call Hotf_5pt_reduction(G2H3(19),RedSet_5(12),mass5set(:,10),  & 
G1H3(98),G1H3(99),G1H3(100),G1H3(101),G1H3(102),G1H3(103),3)
  call HG1shiftOLR(G1H3(99),16,3)
  call Hotf_4pt_reduction(G2H3(21),RedSet_4(78),mass4set(:,4),  & 
G1H3(104),G1H3(105),G1H3(106),G1H3(107),G1H3(108),3)
  call HG1shiftOLR(G1H3(105),19,3)
  call Hotf_5pt_reduction(G2H3(22),RedSet_5(13),mass5set(:,11),  & 
G1H3(109),G1H3(110),G1H3(111),G1H3(112),G1H3(113),G1H3(114),3)
  call HG1shiftOLR(G1H3(110),16,3)
  call Hotf_4pt_reduction(G2H3(24),RedSet_4(79),mass4set(:,5),  & 
G1H3(115),G1H3(116),G1H3(117),G1H3(118),G1H3(119),3)
  call HG1shiftOLR(G1H3(116),24,3)
  call Hotf_5pt_reduction(G2H4(5),RedSet_5(1),mass5set(:,1),  & 
G1H4(1),G1H4(2),G1H4(3),G1H4(4),G1H4(5),G1H4(6),4)
  call HG1shiftOLR(G1H4(2),12,4)
  call Hotf_4pt_reduction(G2H4(7),RedSet_4(13),mass4set(:,6),  & 
G1H4(7),G1H4(8),G1H4(9),G1H4(10),G1H4(11),4)
  call HG1shiftOLR(G1H4(8),28,4)
  call Hotf_5pt_reduction(G2H3(26),RedSet_5(14),mass5set(:,12),  & 
G1H3(120),G1H3(121),G1H3(122),G1H3(123),G1H3(124),G1H3(125),3)
  call HG1shiftOLR(G1H3(121),16,3)
  call Hotf_4pt_reduction(G2H3(28),RedSet_4(80),mass4set(:,7),  & 
G1H3(126),G1H3(127),G1H3(128),G1H3(129),G1H3(130),3)
  call HG1shiftOLR(G1H3(127),17,3)
  call Hotf_5pt_reduction(G2H3(29),RedSet_5(15),mass5set(:,13),  & 
G1H3(131),G1H3(132),G1H3(133),G1H3(134),G1H3(135),G1H3(136),3)
  call HG1shiftOLR(G1H3(132),16,3)
  call Hotf_4pt_reduction(G2H3(31),RedSet_4(13),mass4set(:,6),  & 
G1H3(137),G1H3(138),G1H3(139),G1H3(140),G1H3(141),3)
  call HG1shiftOLR(G1H3(138),28,3)
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(32),ex4(:),G2tensor(9),m3h2x1(:,9),heltab2x2(:,:,9))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(34),ex4(:),G2tensor(11),m3h2x1(:,10),heltab2x2(:,:,10))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(91),[G1H2(48)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(88),[G1H3(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(93),[G1H3(75)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(104),[G1H3(103)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(115),[G1H3(114)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(7),[G1H4(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(126),[G1H3(125)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(137),[G1H3(136)])
  call Hloop_VQ_A(ntryL,G1H2(2),ex3(:),G1H1(1),m3h2x1(:,11),heltab2x2(:,:,11))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(13),n2h1(13))
  call Hloop_VQ_A(ntryL,G1H2(7),ex3(:),G1H1(1),m3h2x1(:,12),heltab2x2(:,:,12))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(14),n2h1(14))
  call Hloop_VQ_A(ntryL,G1H2(12),ex3(:),G1H1(1),m3h2x1(:,13),heltab2x2(:,:,13))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(15),n2h1(15))
  call Hloop_VQ_A(ntryL,G1H2(3),ex3(:),G1H1(1),m3h2x1(:,14),heltab2x2(:,:,14))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(16),n2h1(16))
  call Hloop_VQ_A(ntryL,G1H2(4),ex3(:),G1H1(1),m3h2x1(:,15),heltab2x2(:,:,15))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(17),n2h1(17))
  call Hloop_VQ_A(ntryL,G1H2(11),ex3(:),G1H1(1),m3h2x1(:,16),heltab2x2(:,:,16))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(18),n2h1(18))
  call Hloop_VA_Q(ntryL,G1H2(13),ex4(:),G1H1(1),m3h2x1(:,17),heltab2x2(:,:,17))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(19),n2h1(19))
  call Hloop_VA_Q(ntryL,G1H2(14),ex4(:),G1H1(1),m3h2x1(:,18),heltab2x2(:,:,18))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(20),n2h1(20))
  call Hloop_VA_Q(ntryL,G1H2(18),ex4(:),G1H1(1),m3h2x1(:,19),heltab2x2(:,:,19))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(21),n2h1(21))
  call Hloop_AW_Q(ntryL,G1H3(8),ex5(:),G1H1(1),m3h3x1(:,9),heltab2x3(:,:,9))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(22),n2h1(22))
  call Hloop_AW_Q(ntryL,G1H3(13),ex5(:),G1H1(1),m3h3x1(:,10),heltab2x3(:,:,10))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nMT,G2tensor(23),n2h1(23))
  call Hloop_AW_Q(ntryL,G1H3(6),ex5(:),G1H1(1),m3h3x1(:,11),heltab2x3(:,:,11))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(24),n2h1(24))
  call Hloop_VA_Q(ntryL,G1H2(19),ex4(:),G1H1(1),m3h2x1(:,20),heltab2x2(:,:,20))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(25),n2h1(25))
  call Hloop_VA_Q(ntryL,G1H2(20),ex4(:),G1H1(1),m3h2x1(:,21),heltab2x2(:,:,21))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(26),n2h1(26))
  call Hloop_VA_Q(ntryL,G1H2(24),ex4(:),G1H1(1),m3h2x1(:,22),heltab2x2(:,:,22))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(27),n2h1(27))
  call Hloop_AW_Q(ntryL,G1H3(12),ex5(:),G1H1(1),m3h3x1(:,12),heltab2x3(:,:,12))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(28),n2h1(28))
  call Hloop_AW_Q(ntryL,G1H3(18),ex5(:),G1H1(1),m3h3x1(:,13),heltab2x3(:,:,13))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nMT,G2tensor(29),n2h1(29))
  call Hloop_AW_Q(ntryL,G1H3(11),ex5(:),G1H1(1),m3h3x1(:,14),heltab2x3(:,:,14))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(30),n2h1(30))
  call Hloop_VQ_A(ntryL,G1H2(25),ex1(:),G1H1(1),m3h2x1(:,23),heltab2x2(:,:,23))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(31),n2h1(31))
  call Hloop_VQ_A(ntryL,G1H2(26),ex1(:),G1H1(1),m3h2x1(:,24),heltab2x2(:,:,24))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),1,nMT,G2tensor(32),n2h1(32))
  call Hloop_VQ_A(ntryL,G1H2(30),ex1(:),G1H1(1),m3h2x1(:,25),heltab2x2(:,:,25))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(33),n2h1(33))
  call Hloop_QW_A(ntryL,G1H3(5),ex5(:),G1H1(1),m3h3x1(:,15),heltab2x3(:,:,15))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(34),n2h1(34))
  call Hloop_QW_A(ntryL,G1H3(9),ex5(:),G1H1(1),m3h3x1(:,16),heltab2x3(:,:,16))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(35),n2h1(35))
  call Hloop_QW_A(ntryL,G1H3(23),ex5(:),G1H1(1),m3h3x1(:,17),heltab2x3(:,:,17))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(36),n2h1(36))
  call Hloop_VQ_A(ntryL,G1H2(31),ex1(:),G1H1(1),m3h2x1(:,26),heltab2x2(:,:,26))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(37),n2h1(37))
  call Hloop_VQ_A(ntryL,G1H2(32),ex1(:),G1H1(1),m3h2x1(:,27),heltab2x2(:,:,27))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),1,nMT,G2tensor(38),n2h1(38))
  call Hloop_VQ_A(ntryL,G1H2(36),ex1(:),G1H1(1),m3h2x1(:,28),heltab2x2(:,:,28))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(39),n2h1(39))
  call Hloop_QW_A(ntryL,G1H3(17),ex5(:),G1H1(1),m3h3x1(:,18),heltab2x3(:,:,18))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(40),n2h1(40))
  call Hloop_QW_A(ntryL,G1H3(21),ex5(:),G1H1(1),m3h3x1(:,19),heltab2x3(:,:,19))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(41),n2h1(41))
  call Hloop_QW_A(ntryL,G1H3(27),ex5(:),G1H1(1),m3h3x1(:,20),heltab2x3(:,:,20))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(42),n2h1(42))
  call Hloop_VQ_A(ntryL,G1H2(37),ex3(:),G1H1(1),m3h2x1(:,29),heltab2x2(:,:,29))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(43),n2h1(43))
  call Hloop_VQ_A(ntryL,G1H2(38),ex3(:),G1H1(1),m3h2x1(:,30),heltab2x2(:,:,30))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(44),n2h1(44))
  call Hloop_VQ_A(ntryL,G1H2(42),ex3(:),G1H1(1),m3h2x1(:,31),heltab2x2(:,:,31))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(45),n2h1(45))
  call Hloop_VQ_A(ntryL,G1H2(43),ex3(:),G1H1(1),m3h2x1(:,32),heltab2x2(:,:,32))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(46),n2h1(46))
  call Hloop_VQ_A(ntryL,G1H2(44),ex3(:),G1H1(1),m3h2x1(:,33),heltab2x2(:,:,33))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(47),n2h1(47))
  call Hloop_VQ_A(ntryL,G1H2(91),ex3(:),G1H1(1),m3h2x1(:,34),heltab2x2(:,:,34))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(48),n2h1(48))
  call Hloop_VQ_A(ntryL,G1H2(49),ex3(:),G1H1(1),m3h2x1(:,35),heltab2x2(:,:,35))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(49),n2h1(49))
  call Hloop_VQ_A(ntryL,G1H2(50),ex3(:),G1H1(1),m3h2x1(:,36),heltab2x2(:,:,36))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(50),n2h1(50))
  call Hloop_VQ_A(ntryL,G1H2(54),ex3(:),G1H1(1),m3h2x1(:,37),heltab2x2(:,:,37))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(51),n2h1(51))
  call Hloop_VQ_A(ntryL,G1H2(55),ex3(:),G1H1(1),m3h2x1(:,38),heltab2x2(:,:,38))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(52),n2h1(52))
  call Hloop_VQ_A(ntryL,G1H2(56),ex3(:),G1H1(1),m3h2x1(:,39),heltab2x2(:,:,39))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(53),n2h1(53))
  call Hloop_VQ_A(ntryL,G1H2(60),ex3(:),G1H1(1),m3h2x1(:,40),heltab2x2(:,:,40))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(54),n2h1(54))
  call Hloop_VQ_A(ntryL,G1H2(61),ex3(:),G1H1(1),m3h2x1(:,41),heltab2x2(:,:,41))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(55),n2h1(55))
  call Hloop_VQ_A(ntryL,G1H2(62),ex3(:),G1H1(1),m3h2x1(:,42),heltab2x2(:,:,42))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(56),n2h1(56))
  call Hloop_VQ_A(ntryL,G1H2(66),ex3(:),G1H1(1),m3h2x1(:,43),heltab2x2(:,:,43))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(57),n2h1(57))
  call Hloop_VQ_A(ntryL,G1H2(67),ex3(:),G1H1(1),m3h2x1(:,44),heltab2x2(:,:,44))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(58),n2h1(58))
  call Hloop_VQ_A(ntryL,G1H2(68),ex3(:),G1H1(1),m3h2x1(:,45),heltab2x2(:,:,45))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(59),n2h1(59))
  call Hloop_VQ_A(ntryL,G1H2(72),ex3(:),G1H1(1),m3h2x1(:,46),heltab2x2(:,:,46))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(60),n2h1(60))
  call Hloop_AW_Q(ntryL,G1H3(28),ex5(:),G1H1(1),m3h3x1(:,21),heltab2x3(:,:,21))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(61),n2h1(61))
  call Hloop_AW_Q(ntryL,G1H3(29),ex5(:),G1H1(1),m3h3x1(:,22),heltab2x3(:,:,22))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nMT,G2tensor(62),n2h1(62))
  call Hloop_AW_Q(ntryL,G1H3(33),ex5(:),G1H1(1),m3h3x1(:,23),heltab2x3(:,:,23))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(63),n2h1(63))
  call Hloop_AW_Q(ntryL,G1H3(34),ex5(:),G1H1(1),m3h3x1(:,24),heltab2x3(:,:,24))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(64),n2h1(64))
  call Hloop_AW_Q(ntryL,G1H3(35),ex5(:),G1H1(1),m3h3x1(:,25),heltab2x3(:,:,25))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nMT,G2tensor(65),n2h1(65))
  call Hloop_AW_Q(ntryL,G1H3(39),ex5(:),G1H1(1),m3h3x1(:,26),heltab2x3(:,:,26))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(66),n2h1(66))
  call Hloop_AW_Q(ntryL,G1H3(40),ex5(:),G1H1(1),m3h3x1(:,27),heltab2x3(:,:,27))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(67),n2h1(67))
  call Hloop_AW_Q(ntryL,G1H3(41),ex5(:),G1H1(1),m3h3x1(:,28),heltab2x3(:,:,28))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nMT,G2tensor(68),n2h1(68))
  call Hloop_AW_Q(ntryL,G1H3(88),ex5(:),G1H1(1),m3h3x1(:,29),heltab2x3(:,:,29))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(69),n2h1(69))
  call Hloop_AW_Q(ntryL,G1H3(46),ex5(:),G1H1(1),m3h3x1(:,30),heltab2x3(:,:,30))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(70),n2h1(70))
  call Hloop_AW_Q(ntryL,G1H3(47),ex5(:),G1H1(1),m3h3x1(:,31),heltab2x3(:,:,31))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nMT,G2tensor(71),n2h1(71))
  call Hloop_AW_Q(ntryL,G1H3(51),ex5(:),G1H1(1),m3h3x1(:,32),heltab2x3(:,:,32))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(72),n2h1(72))
  call Hloop_AW_Q(ntryL,G1H3(52),ex5(:),G1H1(1),m3h3x1(:,33),heltab2x3(:,:,33))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(73),n2h1(73))
  call Hloop_AW_Q(ntryL,G1H3(53),ex5(:),G1H1(1),m3h3x1(:,34),heltab2x3(:,:,34))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nMT,G2tensor(74),n2h1(74))
  call Hloop_AW_Q(ntryL,G1H3(57),ex5(:),G1H1(1),m3h3x1(:,35),heltab2x3(:,:,35))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(75),n2h1(75))
  call Hloop_QW_A(ntryL,G1H3(58),ex5(:),G1H1(1),m3h3x1(:,36),heltab2x3(:,:,36))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(76),n2h1(76))
  call Hloop_QW_A(ntryL,G1H3(59),ex5(:),G1H1(1),m3h3x1(:,37),heltab2x3(:,:,37))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(77),n2h1(77))
  call Hloop_QW_A(ntryL,G1H3(63),ex5(:),G1H1(1),m3h3x1(:,38),heltab2x3(:,:,38))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(78),n2h1(78))
  call Hloop_QW_A(ntryL,G1H3(64),ex5(:),G1H1(1),m3h3x1(:,39),heltab2x3(:,:,39))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(79),n2h1(79))
  call Hloop_QW_A(ntryL,G1H3(65),ex5(:),G1H1(1),m3h3x1(:,40),heltab2x3(:,:,40))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(80),n2h1(80))
  call Hloop_QW_A(ntryL,G1H3(69),ex5(:),G1H1(1),m3h3x1(:,41),heltab2x3(:,:,41))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(81),n2h1(81))
  call Hloop_QW_A(ntryL,G1H3(70),ex5(:),G1H1(1),m3h3x1(:,42),heltab2x3(:,:,42))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(82),n2h1(82))
  call Hloop_QW_A(ntryL,G1H3(71),ex5(:),G1H1(1),m3h3x1(:,43),heltab2x3(:,:,43))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(83),n2h1(83))
  call Hloop_QW_A(ntryL,G1H3(93),ex5(:),G1H1(1),m3h3x1(:,44),heltab2x3(:,:,44))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(84),n2h1(84))
  call Hloop_QW_A(ntryL,G1H3(76),ex5(:),G1H1(1),m3h3x1(:,45),heltab2x3(:,:,45))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(85),n2h1(85))
  call Hloop_QW_A(ntryL,G1H3(77),ex5(:),G1H1(1),m3h3x1(:,46),heltab2x3(:,:,46))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(86),n2h1(86))
  call Hloop_QW_A(ntryL,G1H3(81),ex5(:),G1H1(1),m3h3x1(:,47),heltab2x3(:,:,47))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(87),n2h1(87))
  call Hloop_QW_A(ntryL,G1H3(82),ex5(:),G1H1(1),m3h3x1(:,48),heltab2x3(:,:,48))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(88),n2h1(88))
  call Hloop_QW_A(ntryL,G1H3(83),ex5(:),G1H1(1),m3h3x1(:,49),heltab2x3(:,:,49))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(89),n2h1(89))
  call Hloop_QW_A(ntryL,G1H3(87),ex5(:),G1H1(1),m3h3x1(:,50),heltab2x3(:,:,50))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(90),n2h1(90))
  call Hloop_VQ_A(ntryL,G1H6(13),wf6(:,7),G1H1(1),m3h6x1(:,1),heltab2x6(:,:,49))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(91),n2h1(91))
  call Hloop_VQ_A(ntryL,G1H6(14),wf6(:,7),G1H1(1),m3h6x1(:,2),heltab2x6(:,:,50))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),17,nMB,G2tensor(92),n2h1(92))
  call Hloop_VQ_A(ntryL,G1H6(8),wf6(:,7),G1H1(1),m3h6x1(:,3),heltab2x6(:,:,51))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(93),n2h1(93))
  call Hloop_VQ_A(ntryL,G1H6(5),wf6(:,7),G1H1(1),m3h6x1(:,4),heltab2x6(:,:,52))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(94),n2h1(94))
  call Hloop_VQ_A(ntryL,G1H6(9),wf6(:,7),G1H1(1),m3h6x1(:,5),heltab2x6(:,:,53))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),17,nMB,G2tensor(95),n2h1(95))
  call Hloop_VQ_A(ntryL,G1H6(4),wf6(:,7),G1H1(1),m3h6x1(:,6),heltab2x6(:,:,54))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(96),n2h1(96))
  call Hloop_VA_Q(ntryL,G1H6(7),wf6(:,4),G1H1(1),m3h6x1(:,7),heltab2x6(:,:,55))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(97),n2h1(97))
  call Hloop_VA_Q(ntryL,G1H6(10),wf6(:,4),G1H1(1),m3h6x1(:,8),heltab2x6(:,:,56))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),24,nMT,G2tensor(98),n2h1(98))
  call Hloop_VA_Q(ntryL,G1H6(22),wf6(:,4),G1H1(1),m3h6x1(:,9),heltab2x6(:,:,57))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(99),n2h1(99))
  call Hloop_VA_Q(ntryL,G1H6(29),wf6(:,4),G1H1(1),m3h6x1(:,10),heltab2x6(:,:,58))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(100),n2h1(100))
  call Hloop_VA_Q(ntryL,G1H6(30),wf6(:,4),G1H1(1),m3h6x1(:,11),heltab2x6(:,:,59))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),24,nMT,G2tensor(101),n2h1(101))
  call Hloop_VA_Q(ntryL,G1H6(36),wf6(:,4),G1H1(1),m3h6x1(:,12),heltab2x6(:,:,60))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(102),n2h1(102))
  call Hloop_VA_Q(ntryL,G1H2(73),ex2(:),G1H1(1),m3h2x1(:,47),heltab2x2(:,:,47))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(103),n2h1(103))
  call Hloop_VA_Q(ntryL,G1H2(74),ex2(:),G1H1(1),m3h2x1(:,48),heltab2x2(:,:,48))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMT,G2tensor(104),n2h1(104))
  call Hloop_VA_Q(ntryL,G1H2(78),ex2(:),G1H1(1),m3h2x1(:,49),heltab2x2(:,:,49))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(105),n2h1(105))
  call Hloop_VA_Q(ntryL,G1H2(79),ex2(:),G1H1(1),m3h2x1(:,50),heltab2x2(:,:,50))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(106),n2h1(106))
  call Hloop_VA_Q(ntryL,G1H2(80),ex2(:),G1H1(1),m3h2x1(:,51),heltab2x2(:,:,51))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMT,G2tensor(107),n2h1(107))
  call Hloop_VA_Q(ntryL,G1H2(84),ex2(:),G1H1(1),m3h2x1(:,52),heltab2x2(:,:,52))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(108),n2h1(108))
  call Hloop_VA_Q(ntryL,G1H2(85),ex2(:),G1H1(1),m3h2x1(:,53),heltab2x2(:,:,53))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(109),n2h1(109))
  call Hloop_VA_Q(ntryL,G1H2(86),ex2(:),G1H1(1),m3h2x1(:,54),heltab2x2(:,:,54))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMT,G2tensor(110),n2h1(110))
  call Hloop_VA_Q(ntryL,G1H2(90),ex2(:),G1H1(1),m3h2x1(:,55),heltab2x2(:,:,55))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(111),n2h1(111))
  call Hloop_VQ_A(ntryL,G1H2(92),ex3(:),G1H1(1),m3h2x1(:,56),heltab2x2(:,:,56))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,nMB,G2tensor(112),n2h1(112))
  call Hloop_AW_Q(ntryL,G1H3(89),ex5(:),G1H1(1),m3h3x1(:,51),heltab2x3(:,:,51))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),24,nMT,G2tensor(113),n2h1(113))
  call Hloop_QW_A(ntryL,G1H3(94),ex5(:),G1H1(1),m3h3x1(:,52),heltab2x3(:,:,52))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),17,nMB,G2tensor(114),n2h1(114))
  call Hloop_AW_Q(ntryL,G1H3(98),ex5(:),G1H1(1),m3h3x1(:,53),heltab2x3(:,:,53))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(115),n2h1(115))
  call Hloop_AW_Q(ntryL,G1H3(99),ex5(:),G1H1(1),m3h3x1(:,54),heltab2x3(:,:,54))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nMT,G2tensor(116),n2h1(116))
  call Hloop_AW_Q(ntryL,G1H3(104),ex5(:),G1H1(1),m3h3x1(:,55),heltab2x3(:,:,55))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(117),n2h1(117))
  call Hloop_AW_Q(ntryL,G1H3(105),ex5(:),G1H1(1),m3h3x1(:,56),heltab2x3(:,:,56))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),19,nMT,G2tensor(118),n2h1(118))
  call Hloop_AW_Q(ntryL,G1H3(109),ex5(:),G1H1(1),m3h3x1(:,57),heltab2x3(:,:,57))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(119),n2h1(119))
  call Hloop_AW_Q(ntryL,G1H3(110),ex5(:),G1H1(1),m3h3x1(:,58),heltab2x3(:,:,58))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nMT,G2tensor(120),n2h1(120))
  call Hloop_AW_Q(ntryL,G1H3(115),ex5(:),G1H1(1),m3h3x1(:,59),heltab2x3(:,:,59))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(121),n2h1(121))
  call Hloop_AW_Q(ntryL,G1H3(116),ex5(:),G1H1(1),m3h3x1(:,60),heltab2x3(:,:,60))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),24,nMT,G2tensor(122),n2h1(122))
  call Hloop_QV_A(ntryL,G1H4(1),wf4(:,2),G1H1(1),m3h4x1(:,1),heltab2x4(:,:,18))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(123),n2h1(123))
  call Hloop_QV_A(ntryL,G1H4(2),wf4(:,2),G1H1(1),m3h4x1(:,2),heltab2x4(:,:,19))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,nMB,G2tensor(124),n2h1(124))
  call Hloop_QV_A(ntryL,G1H4(7),wf4(:,2),G1H1(1),m3h4x1(:,3),heltab2x4(:,:,20))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(125),n2h1(125))
  call Hloop_QV_A(ntryL,G1H4(8),wf4(:,2),G1H1(1),m3h4x1(:,4),heltab2x4(:,:,21))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),28,nMB,G2tensor(126),n2h1(126))
  call Hloop_QW_A(ntryL,G1H3(120),ex5(:),G1H1(1),m3h3x1(:,61),heltab2x3(:,:,61))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(127),n2h1(127))
  call Hloop_QW_A(ntryL,G1H3(121),ex5(:),G1H1(1),m3h3x1(:,62),heltab2x3(:,:,62))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(128),n2h1(128))
  call Hloop_QW_A(ntryL,G1H3(126),ex5(:),G1H1(1),m3h3x1(:,63),heltab2x3(:,:,63))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(129),n2h1(129))
  call Hloop_QW_A(ntryL,G1H3(127),ex5(:),G1H1(1),m3h3x1(:,64),heltab2x3(:,:,64))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),17,nMB,G2tensor(130),n2h1(130))
  call Hloop_QW_A(ntryL,G1H3(131),ex5(:),G1H1(1),m3h3x1(:,65),heltab2x3(:,:,65))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(131),n2h1(131))
  call Hloop_QW_A(ntryL,G1H3(132),ex5(:),G1H1(1),m3h3x1(:,66),heltab2x3(:,:,66))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(132),n2h1(132))
  call Hloop_QW_A(ntryL,G1H3(137),ex5(:),G1H1(1),m3h3x1(:,67),heltab2x3(:,:,67))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(133),n2h1(133))
  call Hloop_QW_A(ntryL,G1H3(138),ex5(:),G1H1(1),m3h3x1(:,68),heltab2x3(:,:,68))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),28,nMB,G2tensor(134),n2h1(134))
  call ol_merge_tensors(G2tensor(1),[G2tensor(2),G1tensor(2)])
  call ol_merge_tensors(G2tensor(5),[G2tensor(4),G1tensor(8)])
  call ol_merge_tensors(G2tensor(19),[G2tensor(6),G1tensor(14)])
  call ol_merge_tensors(G2tensor(25),[G2tensor(8),G1tensor(20)])
  call ol_merge_tensors(G2tensor(31),[G2tensor(10),G1tensor(26)])
  call ol_merge_tensors(G2tensor(37),[G2tensor(12),G1tensor(32)])
  call ol_merge_tensors(G2tensor(43),[G1tensor(3)])
  call ol_merge_tensors(G2tensor(46),[G1tensor(4)])
  call ol_merge_tensors(G2tensor(49),[G1tensor(5)])
  call ol_merge_tensors(G2tensor(13),[G1tensor(6)])
  call ol_merge_tensors(G2tensor(52),[G1tensor(9)])
  call ol_merge_tensors(G2tensor(55),[G1tensor(10)])
  call ol_merge_tensors(G2tensor(58),[G1tensor(11)])
  call ol_merge_tensors(G2tensor(16),[G1tensor(12)])
  call ol_merge_tensors(G2tensor(61),[G1tensor(15)])
  call ol_merge_tensors(G2tensor(64),[G1tensor(16)])
  call ol_merge_tensors(G2tensor(67),[G1tensor(23),G1tensor(17)])
  call ol_merge_tensors(G2tensor(22),[G1tensor(18)])
  call ol_merge_tensors(G2tensor(70),[G1tensor(21)])
  call ol_merge_tensors(G2tensor(73),[G1tensor(22)])
  call ol_merge_tensors(G2tensor(28),[G1tensor(24)])
  call ol_merge_tensors(G2tensor(76),[G1tensor(27)])
  call ol_merge_tensors(G2tensor(79),[G1tensor(28)])
  call ol_merge_tensors(G2tensor(82),[G1tensor(35),G1tensor(29)])
  call ol_merge_tensors(G2tensor(34),[G1tensor(30)])
  call ol_merge_tensors(G2tensor(85),[G1tensor(33)])
  call ol_merge_tensors(G2tensor(88),[G1tensor(34)])
  call ol_merge_tensors(G2tensor(40),[G1tensor(36)])
  call Hotf_5pt_reduction_last(G2tensor(1),RedSet_5(8),mass5set(:,6),  & 
G1tensor(1),G1tensor(7),G1tensor(13),G1tensor(19),G1tensor(25),G1tensor(31))
  call G_TensorShift(G1tensor(7),8)
  call Hotf_5pt_reduction_last(G2tensor(5),RedSet_5(9),mass5set(:,7),  & 
G1tensor(2),G1tensor(8),G1tensor(14),G1tensor(20),G1tensor(26),G1tensor(32))
  call G_TensorShift(G1tensor(8),1)
  call Hotf_5pt_reduction_last(G2tensor(19),RedSet_5(19),mass5set(:,16),  & 
G1tensor(3),G1tensor(4),G1tensor(5),G1tensor(6),G1tensor(9),G1tensor(10))
  call G_TensorShift(G1tensor(4),8)
  call Hotf_5pt_reduction_last(G2tensor(25),RedSet_5(21),mass5set(:,16),  & 
G1tensor(11),G1tensor(12),G1tensor(15),G1tensor(16),G1tensor(23),G1tensor(17))
  call G_TensorShift(G1tensor(12),8)
  call Hotf_5pt_reduction_last(G2tensor(31),RedSet_5(23),mass5set(:,18),  & 
G1tensor(18),G1tensor(21),G1tensor(22),G1tensor(24),G1tensor(27),G1tensor(28))
  call G_TensorShift(G1tensor(21),1)
  call Hotf_5pt_reduction_last(G2tensor(37),RedSet_5(25),mass5set(:,18),  & 
G1tensor(35),G1tensor(29),G1tensor(30),G1tensor(33),G1tensor(34),G1tensor(36))
  call G_TensorShift(G1tensor(29),1)
  call Hotf_5pt_reduction_last(G2tensor(43),RedSet_5(27),mass5set(:,19),  & 
G1tensor(37),G1tensor(38),G1tensor(39),G1tensor(40),G1tensor(41),G1tensor(42))
  call G_TensorShift(G1tensor(38),4)
  call Hotf_5pt_reduction_last(G2tensor(46),RedSet_5(7),mass5set(:,5),  & 
G1tensor(43),G1tensor(44),G1tensor(45),G1tensor(46),G1tensor(47),G1tensor(48))
  call G_TensorShift(G1tensor(44),4)
  call Hotf_5pt_reduction_last(G2tensor(49),RedSet_5(28),mass5set(:,4),  & 
G1tensor(49),G1tensor(50),G1tensor(51),G1tensor(52),G1tensor(53),G1tensor(54))
  call G_TensorShift(G1tensor(50),4)
  call Hotf_5pt_reduction_last(G2tensor(13),RedSet_5(17),mass5set(:,15),  & 
G1tensor(55),G1tensor(56),G1tensor(57),G1tensor(58),G1tensor(59),G1tensor(60))
  call G_TensorShift(G1tensor(56),4)
  call Hotf_5pt_reduction_last(G2tensor(52),RedSet_5(29),mass5set(:,20),  & 
G1tensor(61),G1tensor(62),G1tensor(63),G1tensor(64),G1tensor(65),G1tensor(66))
  call G_TensorShift(G1tensor(62),4)
  call Hotf_5pt_reduction_last(G2tensor(55),RedSet_5(30),mass5set(:,21),  & 
G1tensor(67),G1tensor(68),G1tensor(69),G1tensor(70),G1tensor(71),G1tensor(72))
  call G_TensorShift(G1tensor(68),4)
  call Hotf_5pt_reduction_last(G2tensor(58),RedSet_5(31),mass5set(:,15),  & 
G1tensor(73),G1tensor(74),G1tensor(75),G1tensor(76),G1tensor(77),G1tensor(78))
  call G_TensorShift(G1tensor(74),4)
  call Hotf_5pt_reduction_last(G2tensor(16),RedSet_5(18),mass5set(:,4),  & 
G1tensor(79),G1tensor(80),G1tensor(81),G1tensor(82),G1tensor(83),G1tensor(84))
  call G_TensorShift(G1tensor(80),4)
  call Hotf_5pt_reduction_last(G2tensor(61),RedSet_5(32),mass5set(:,22),  & 
G1tensor(85),G1tensor(86),G1tensor(87),G1tensor(88),G1tensor(89),G1tensor(90))
  call G_TensorShift(G1tensor(86),16)
  call Hotf_5pt_reduction_last(G2tensor(64),RedSet_5(33),mass5set(:,23),  & 
G1tensor(91),G1tensor(92),G1tensor(93),G1tensor(94),G1tensor(95),G1tensor(96))
  call G_TensorShift(G1tensor(92),16)
  call Hotf_5pt_reduction_last(G2tensor(67),RedSet_5(10),mass5set(:,8),  & 
G1tensor(97),G1tensor(98),G1tensor(99),G1tensor(100),G1tensor(101),G1tensor(102))
  call G_TensorShift(G1tensor(98),16)
  call Hotf_5pt_reduction_last(G2tensor(22),RedSet_5(20),mass5set(:,17),  & 
G1tensor(103),G1tensor(104),G1tensor(105),G1tensor(106),G1tensor(107),G1tensor(108))
  call G_TensorShift(G1tensor(104),16)
  call Hotf_5pt_reduction_last(G2tensor(70),RedSet_5(34),mass5set(:,22),  & 
G1tensor(109),G1tensor(110),G1tensor(111),G1tensor(112),G1tensor(113),G1tensor(114))
  call G_TensorShift(G1tensor(110),16)
  call Hotf_5pt_reduction_last(G2tensor(73),RedSet_5(35),mass5set(:,23),  & 
G1tensor(115),G1tensor(116),G1tensor(117),G1tensor(118),G1tensor(119),G1tensor(120))
  call G_TensorShift(G1tensor(116),16)
  call Hotf_5pt_reduction_last(G2tensor(28),RedSet_5(22),mass5set(:,17),  & 
G1tensor(121),G1tensor(122),G1tensor(123),G1tensor(124),G1tensor(125),G1tensor(126))
  call G_TensorShift(G1tensor(122),16)
  call Hotf_5pt_reduction_last(G2tensor(76),RedSet_5(36),mass5set(:,24),  & 
G1tensor(127),G1tensor(128),G1tensor(129),G1tensor(130),G1tensor(131),G1tensor(132))
  call G_TensorShift(G1tensor(128),16)
  call Hotf_5pt_reduction_last(G2tensor(79),RedSet_5(37),mass5set(:,25),  & 
G1tensor(133),G1tensor(134),G1tensor(135),G1tensor(136),G1tensor(137),G1tensor(138))
  call G_TensorShift(G1tensor(134),16)
  call Hotf_5pt_reduction_last(G2tensor(82),RedSet_5(11),mass5set(:,9),  & 
G1tensor(139),G1tensor(140),G1tensor(141),G1tensor(142),G1tensor(143),G1tensor(144))
  call G_TensorShift(G1tensor(140),16)
  call Hotf_5pt_reduction_last(G2tensor(34),RedSet_5(24),mass5set(:,2),  & 
G1tensor(145),G1tensor(146),G1tensor(147),G1tensor(148),G1tensor(149),G1tensor(150))
  call G_TensorShift(G1tensor(146),16)
  call Hotf_5pt_reduction_last(G2tensor(85),RedSet_5(38),mass5set(:,24),  & 
G1tensor(151),G1tensor(152),G1tensor(153),G1tensor(154),G1tensor(155),G1tensor(156))
  call G_TensorShift(G1tensor(152),16)
  call Hotf_5pt_reduction_last(G2tensor(88),RedSet_5(39),mass5set(:,25),  & 
G1tensor(157),G1tensor(158),G1tensor(159),G1tensor(160),G1tensor(161),G1tensor(162))
  call G_TensorShift(G1tensor(158),16)
  call Hotf_5pt_reduction_last(G2tensor(40),RedSet_5(26),mass5set(:,2),  & 
G1tensor(163),G1tensor(164),G1tensor(165),G1tensor(166),G1tensor(167),G1tensor(168))
  call G_TensorShift(G1tensor(164),16)
  call Hotf_5pt_reduction_last(G2tensor(9),RedSet_5(16),mass5set(:,14),  & 
G1tensor(169),G1tensor(170),G1tensor(171),G1tensor(172),G1tensor(173),G1tensor(174))
  call G_TensorShift(G1tensor(170),8)
  call Hotf_5pt_reduction_last(G2tensor(91),RedSet_5(6),mass5set(:,4),  & 
G1tensor(175),G1tensor(176),G1tensor(177),G1tensor(178),G1tensor(179),G1tensor(180))
  call G_TensorShift(G1tensor(176),17)
  call Hotf_5pt_reduction_last(G2tensor(94),RedSet_5(5),mass5set(:,4),  & 
G1tensor(181),G1tensor(182),G1tensor(183),G1tensor(184),G1tensor(185),G1tensor(186))
  call G_TensorShift(G1tensor(182),17)
  call Hotf_5pt_reduction_last(G2tensor(97),RedSet_5(3),mass5set(:,3),  & 
G1tensor(187),G1tensor(188),G1tensor(189),G1tensor(190),G1tensor(191),G1tensor(192))
  call G_TensorShift(G1tensor(188),24)
  call Hotf_5pt_reduction_last(G2tensor(100),RedSet_5(4),mass5set(:,3),  & 
G1tensor(193),G1tensor(194),G1tensor(195),G1tensor(196),G1tensor(197),G1tensor(198))
  call G_TensorShift(G1tensor(194),24)
  call Hotf_5pt_reduction_last(G2tensor(103),RedSet_5(40),mass5set(:,26),  & 
G1tensor(199),G1tensor(200),G1tensor(201),G1tensor(202),G1tensor(203),G1tensor(204))
  call G_TensorShift(G1tensor(200),2)
  call Hotf_5pt_reduction_last(G2tensor(106),RedSet_5(41),mass5set(:,18),  & 
G1tensor(205),G1tensor(206),G1tensor(207),G1tensor(208),G1tensor(209),G1tensor(210))
  call G_TensorShift(G1tensor(206),2)
  call Hotf_5pt_reduction_last(G2tensor(109),RedSet_5(42),mass5set(:,18),  & 
G1tensor(211),G1tensor(212),G1tensor(213),G1tensor(214),G1tensor(215),G1tensor(216))
  call G_TensorShift(G1tensor(212),2)
  call Hotf_5pt_reduction_last(G2tensor(115),RedSet_5(12),mass5set(:,10),  & 
G1tensor(217),G1tensor(218),G1tensor(219),G1tensor(220),G1tensor(221),G1tensor(222))
  call G_TensorShift(G1tensor(218),16)
  call Hotf_5pt_reduction_last(G2tensor(119),RedSet_5(13),mass5set(:,11),  & 
G1tensor(223),G1tensor(224),G1tensor(225),G1tensor(226),G1tensor(227),G1tensor(228))
  call G_TensorShift(G1tensor(224),16)
  call Hotf_5pt_reduction_last(G2tensor(123),RedSet_5(1),mass5set(:,1),  & 
G1tensor(229),G1tensor(230),G1tensor(231),G1tensor(232),G1tensor(233),G1tensor(234))
  call G_TensorShift(G1tensor(230),12)
  call Hotf_5pt_reduction_last(G2tensor(127),RedSet_5(14),mass5set(:,12),  & 
G1tensor(235),G1tensor(236),G1tensor(237),G1tensor(238),G1tensor(239),G1tensor(240))
  call G_TensorShift(G1tensor(236),16)
  call Hotf_5pt_reduction_last(G2tensor(131),RedSet_5(15),mass5set(:,13),  & 
G1tensor(241),G1tensor(242),G1tensor(243),G1tensor(244),G1tensor(245),G1tensor(246))
  call G_TensorShift(G1tensor(242),16)
  call ol_merge_tensors(T1sum(7),[G1tensor(1)])
  call ol_merge_tensors(T1sum(8),[G1tensor(2)])
  call ol_merge_tensors(T1sum(9),[G1tensor(3)])
  call ol_merge_tensors(T1sum(10),[G1tensor(11)])
  call ol_merge_tensors(T1sum(11),[G1tensor(18)])
  call ol_merge_tensors(T1sum(12),[G1tensor(35)])
  call ol_merge_tensors(T1sum(13),[G1tensor(37)])
  call ol_merge_tensors(T1sum(14),[G1tensor(43)])
  call ol_merge_tensors(T1sum(15),[G1tensor(49)])
  call ol_merge_tensors(T1sum(16),[G1tensor(55)])
  call ol_merge_tensors(T1sum(17),[G1tensor(61)])
  call ol_merge_tensors(T1sum(18),[G1tensor(67)])
  call ol_merge_tensors(T1sum(19),[G1tensor(73)])
  call ol_merge_tensors(T1sum(20),[G1tensor(79)])
  call ol_merge_tensors(T1sum(21),[G1tensor(85)])
  call ol_merge_tensors(T1sum(22),[G1tensor(91)])
  call ol_merge_tensors(T1sum(23),[G1tensor(97)])
  call ol_merge_tensors(T1sum(24),[G1tensor(103)])
  call ol_merge_tensors(T1sum(25),[G1tensor(109)])
  call ol_merge_tensors(T1sum(26),[G1tensor(115)])
  call ol_merge_tensors(T1sum(27),[G1tensor(121)])
  call ol_merge_tensors(T1sum(28),[G1tensor(127)])
  call ol_merge_tensors(T1sum(29),[G1tensor(133)])
  call ol_merge_tensors(T1sum(30),[G1tensor(139)])
  call ol_merge_tensors(T1sum(31),[G1tensor(145)])
  call ol_merge_tensors(T1sum(32),[G1tensor(151)])
  call ol_merge_tensors(T1sum(33),[G1tensor(157)])
  call ol_merge_tensors(T1sum(34),[G1tensor(163)])
  call ol_merge_tensors(T1sum(35),[G1tensor(169)])
  call ol_merge_tensors(T1sum(36),[G1tensor(175)])
  call ol_merge_tensors(T1sum(37),[G1tensor(181)])
  call ol_merge_tensors(T1sum(38),[G1tensor(187)])
  call ol_merge_tensors(T1sum(39),[G1tensor(193)])
  call ol_merge_tensors(T1sum(40),[G1tensor(199)])
  call ol_merge_tensors(T1sum(41),[G1tensor(205)])
  call ol_merge_tensors(T1sum(42),[G1tensor(211)])
  call ol_merge_tensors(T1sum(43),[G1tensor(217)])
  call ol_merge_tensors(T1sum(44),[G1tensor(223)])
  call ol_merge_tensors(T1sum(45),[G1tensor(229)])
  call ol_merge_tensors(T1sum(46),[G1tensor(235)])
  call ol_merge_tensors(T1sum(47),[G1tensor(241)])
  Gcoeff(:)%j = (-(c(86)*M(1,:)%j)+c(85)*M(2,:)%j) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(43),h0tab(:,43),[32,12,3,16],[0,0,0,0],4,2,wf4(:,2),wf4(:,1))
  call Hloop_QW_A(ntryL,G0H144(1),ex6(:),G0H48(1),m3h3x48(:,23),heltab2x144(:,:,43))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(1),n2h48(23))
  Gcoeff(:)%j = (-(c(84)*M(1,:)%j)+c(83)*M(2,:)%j) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(44),h0tab(:,44),[32,12,3,16],[nMT,nMT,nMT,nMB],4,2,wf4(:,2),wf4(:,1))
  call Hloop_QW_A(ntryL,G0H144(1),ex6(:),G0H48(1),m3h3x48(:,24),heltab2x144(:,:,44))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(2),n2h48(24))
  Gcoeff(:)%j = (-(c(86)*M(1,:)%j)+c(85)*M(2,:)%j) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(45),h0tab(:,45),[32,12,3,16],[0,0,0,0],4,2,wf4(:,2),wf4(:,1))
  call Hloop_AW_Q(ntryL,G0H144(1),ex6(:),G0H48(1),m3h3x48(:,25),heltab2x144(:,:,45))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(3),n2h48(25))
  Gcoeff(:)%j = (-(c(84)*M(1,:)%j)+c(83)*M(2,:)%j) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(46),h0tab(:,46),[32,12,3,16],[nMB,nMB,nMB,nMT],4,2,wf4(:,2),wf4(:,1))
  call Hloop_AW_Q(ntryL,G0H144(1),ex6(:),G0H48(1),m3h3x48(:,26),heltab2x144(:,:,46))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMB,G1H48(4),n2h48(26))
  Gcoeff(:)%j = (-(c(86)*M(1,:)%j)+c(85)*M(2,:)%j) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(47),h0tab(:,47),[32,3,12,16],[0,0,0,0],4,2,wf4(:,1),wf4(:,2))
  call Hloop_QW_A(ntryL,G0H144(1),ex6(:),G0H48(1),m3h3x48(:,27),heltab2x144(:,:,47))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(5),n2h48(27))
  Gcoeff(:)%j = (-(c(84)*M(1,:)%j)+c(83)*M(2,:)%j) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(48),h0tab(:,48),[32,3,12,16],[nMT,nMT,nMT,nMB],4,2,wf4(:,1),wf4(:,2))
  call Hloop_QW_A(ntryL,G0H144(1),ex6(:),G0H48(1),m3h3x48(:,28),heltab2x144(:,:,48))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(6),n2h48(28))
  Gcoeff(:)%j = (-(c(86)*M(1,:)%j)+c(85)*M(2,:)%j) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(49),h0tab(:,49),[32,3,12,16],[0,0,0,0],4,2,wf4(:,1),wf4(:,2))
  call Hloop_AW_Q(ntryL,G0H144(1),ex6(:),G0H48(1),m3h3x48(:,29),heltab2x144(:,:,49))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(7),n2h48(29))
  Gcoeff(:)%j = (-(c(84)*M(1,:)%j)+c(83)*M(2,:)%j) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(50),h0tab(:,50),[32,3,12,16],[nMB,nMB,nMB,nMT],4,2,wf4(:,1),wf4(:,2))
  call Hloop_AW_Q(ntryL,G0H144(1),ex6(:),G0H48(1),m3h3x48(:,30),heltab2x144(:,:,50))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMB,G1H48(8),n2h48(30))
  Gcoeff(:)%j = (-(c(86)*M(1,:)%j)+c(85)*M(2,:)%j) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(51),h0tab(:,51),[32,3,16,12],[0,0,0,0],4,2,wf4(:,1),wf4(:,2))
  call Hloop_QW_A(ntryL,G0H144(1),ex6(:),G0H48(1),m3h3x48(:,31),heltab2x144(:,:,51))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(9),n2h48(31))
  Gcoeff(:)%j = (-(c(84)*M(1,:)%j)+c(83)*M(2,:)%j) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(52),h0tab(:,52),[32,3,16,12],[nMT,nMT,nMB,nMB],4,2,wf4(:,1),wf4(:,2))
  call Hloop_QW_A(ntryL,G0H144(1),ex6(:),G0H48(1),m3h3x48(:,32),heltab2x144(:,:,52))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(10),n2h48(32))
  Gcoeff(:)%j = (-(c(86)*M(1,:)%j)+c(85)*M(2,:)%j) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(53),h0tab(:,53),[32,3,16,12],[0,0,0,0],4,2,wf4(:,1),wf4(:,2))
  call Hloop_AW_Q(ntryL,G0H144(1),ex6(:),G0H48(1),m3h3x48(:,33),heltab2x144(:,:,53))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(11),n2h48(33))
  Gcoeff(:)%j = (-(c(84)*M(1,:)%j)+c(83)*M(2,:)%j) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(54),h0tab(:,54),[32,3,16,12],[nMB,nMB,nMT,nMT],4,2,wf4(:,1),wf4(:,2))
  call Hloop_AW_Q(ntryL,G0H144(1),ex6(:),G0H48(1),m3h3x48(:,34),heltab2x144(:,:,54))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMB,G1H48(12),n2h48(34))
  Gcoeff(:)%j = (c(26)*M(1,:)%j-c(25)*M(2,:)%j) * den(95)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(55),h0tab(:,55),[32,4,3,24],[nMB,0,0,nMT],4,2,wf4(:,1),wf6(:,4))
  call Hloop_AW_Q(ntryL,G0H144(1),ex6(:),G0H48(1),m3h3x48(:,35),heltab2x144(:,:,55))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMB,G1H48(13),n2h48(35))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j)+c(29)*M(2,:)%j) * den(95)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(56),h0tab(:,56),[32,3,24,4],[nMT,nMT,0,nMB],4,2,wf4(:,1),wf6(:,4))
  call Hloop_QW_A(ntryL,G0H144(1),ex6(:),G0H48(1),m3h3x48(:,36),heltab2x144(:,:,56))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(14),n2h48(36))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j)+c(29)*M(2,:)%j) * den(95)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(57),h0tab(:,57),[32,3,4,24],[nMB,nMB,0,nMT],4,2,wf4(:,1),wf6(:,4))
  call Hloop_AW_Q(ntryL,G0H144(1),ex6(:),G0H48(1),m3h3x48(:,37),heltab2x144(:,:,57))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMB,G1H48(15),n2h48(37))
  Gcoeff(:)%j = (c(26)*M(1,:)%j-c(25)*M(2,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(58),h0tab(:,58),[36,3,8,16],[0,0,nMB,nMT],4,2,wf6(:,3),wf4(:,1))
  call Hloop_AQ_V(ntryL,G0H144(1),wf6(:,3),G0H24(1),m3h6x24(:,9),heltab2x144(:,:,58))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j)+c(29)*M(2,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(59),h0tab(:,59),[36,3,16,8],[nMT,nMT,nMB,0],4,2,wf6(:,3),wf4(:,1))
  call Hloop_VQ_A(ntryL,G0H144(1),wf6(:,3),G0H24(2),m3h6x24(:,10),heltab2x144(:,:,59))
  call Hloop_Q_A(ntryL,G0H24(2),36,nMT,G1H24(1),n2h24(3))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j)+c(29)*M(2,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(60),h0tab(:,60),[36,8,3,16],[0,nMB,nMB,nMT],4,2,wf6(:,3),wf4(:,1))
  call Hloop_AQ_V(ntryL,G0H144(1),wf6(:,3),G0H24(3),m3h6x24(:,11),heltab2x144(:,:,60))
  Gcoeff(:)%j = (c(43)*M(1,:)%j-c(42)*M(2,:)%j) * den(199)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(61),h0tab(:,61),[48,3,4,8],[nMB,nMB,0,nMB],4,2,wf9(:,1),wf4(:,1))
  call Hloop_AS_Q(ntryL,G0H144(1),wf9(:,1),G0H16(1),ngH,m3h9x16(:,13),heltab2x144(:,:,61))
  call Hloop_A_Q(ntryL,G0H16(1),48,nMB,G1H16(2),n2h16(13))
  Gcoeff(:)%j = (c(8)*M(1,:)%j-c(7)*M(2,:)%j) * den(200)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(62),h0tab(:,62),[48,3,4,8],[nMB,nMB,0,nMB],4,2,wf9(:,2),wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H144(1),wf9(:,2),G0H16(1),m3h9x16(:,14),heltab2x144(:,:,62))
  call Hloop_A_Q(ntryL,G0H16(1),48,nMB,G1H16(1),n2h16(14))
  Gcoeff(:)%j = (-(c(69)*M(1,:)%j)+c(68)*M(2,:)%j) * den(201)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(63),h0tab(:,63),[48,3,4,8],[nMB,nMB,0,nMB],4,2,wf9(:,3),wf4(:,1))
  call Hloop_AZ_Q(ntryL,G0H144(1),wf9(:,3),G0H16(1),ngZd,m3h9x16(:,15),heltab2x144(:,:,63))
  call Hloop_A_Q(ntryL,G0H16(1),48,nMB,G1H16(5),n2h16(15))
  Gcoeff(:)%j = (c(43)*M(1,:)%j-c(42)*M(2,:)%j) * den(199)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(64),h0tab(:,64),[48,3,8,4],[nMB,nMB,0,nMB],4,2,wf9(:,1),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H144(1),wf9(:,1),G0H16(1),ngH,m3h9x16(:,16),heltab2x144(:,:,64))
  call Hloop_Q_A(ntryL,G0H16(1),48,nMB,G1H16(4),n2h16(16))
  Gcoeff(:)%j = (c(8)*M(1,:)%j-c(7)*M(2,:)%j) * den(200)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(65),h0tab(:,65),[48,3,8,4],[nMB,nMB,0,nMB],4,2,wf9(:,2),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H144(1),wf9(:,2),G0H16(1),m3h9x16(:,17),heltab2x144(:,:,65))
  call Hloop_Q_A(ntryL,G0H16(1),48,nMB,G1H16(8),n2h16(17))
  Gcoeff(:)%j = (-(c(69)*M(1,:)%j)+c(68)*M(2,:)%j) * den(201)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(66),h0tab(:,66),[48,3,8,4],[nMB,nMB,0,nMB],4,2,wf9(:,3),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H144(1),wf9(:,3),G0H16(1),ngZd,m3h9x16(:,18),heltab2x144(:,:,66))
  call Hloop_Q_A(ntryL,G0H16(1),48,nMB,G1H16(7),n2h16(18))
  Gcoeff(:)%j = (-(c(39)*M(1,:)%j)+c(38)*M(2,:)%j) * den(199)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(67),h0tab(:,67),[48,4,3,8],[nMB,0,0,nMB],4,2,wf9(:,1),wf4(:,1))
  call Hloop_AS_Q(ntryL,G0H144(1),wf9(:,1),G0H16(1),ngH,m3h9x16(:,19),heltab2x144(:,:,67))
  call Hloop_A_Q(ntryL,G0H16(1),48,nMB,G1H16(11),n2h16(19))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)+c(1)*M(2,:)%j) * den(200)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(68),h0tab(:,68),[48,4,3,8],[nMB,0,0,nMB],4,2,wf9(:,2),wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H144(1),wf9(:,2),G0H16(1),m3h9x16(:,20),heltab2x144(:,:,68))
  call Hloop_A_Q(ntryL,G0H16(1),48,nMB,G1H16(10),n2h16(20))
  Gcoeff(:)%j = (c(65)*M(1,:)%j-c(64)*M(2,:)%j) * den(201)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(69),h0tab(:,69),[48,4,3,8],[nMB,0,0,nMB],4,2,wf9(:,3),wf4(:,1))
  call Hloop_AZ_Q(ntryL,G0H144(1),wf9(:,3),G0H16(1),ngZd,m3h9x16(:,21),heltab2x144(:,:,69))
  call Hloop_A_Q(ntryL,G0H16(1),48,nMB,G1H16(3),n2h16(21))
  Gcoeff(:)%j = (c(36)*M(1,:)%j-c(32)*M(2,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(70),h0tab(:,70),[32,7,8,16],[nMB,0,nMB,nMT],4,1,wf8(:,2))
  call Hloop_AW_Q(ntryL,G0H144(1),ex6(:),G0H48(1),m3h3x48(:,38),heltab2x144(:,:,70))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMB,G1H48(16),n2h48(38))
  Gcoeff(:)%j = (c(36)*M(1,:)%j-c(32)*M(2,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(71),h0tab(:,71),[32,4,11,16],[nMB,0,nMB,nMT],4,1,wf8(:,4))
  call Hloop_AW_Q(ntryL,G0H144(1),ex6(:),G0H48(1),m3h3x48(:,39),heltab2x144(:,:,71))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMB,G1H48(17),n2h48(39))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j)+c(29)*M(2,:)%j) * den(127)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(72),h0tab(:,72),[32,2,17,12],[nMT,0,nMB,nMB],4,2,wf6(:,7),wf4(:,2))
  call Hloop_QW_A(ntryL,G0H144(1),ex6(:),G0H48(1),m3h3x48(:,40),heltab2x144(:,:,72))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(18),n2h48(40))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)+c(25)*M(2,:)%j) * den(127)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(73),h0tab(:,73),[32,2,12,17],[nMT,0,0,nMB],4,2,wf4(:,2),wf6(:,7))
  call Hloop_QW_A(ntryL,G0H144(1),ex6(:),G0H48(1),m3h3x48(:,41),heltab2x144(:,:,73))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(19),n2h48(41))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j)+c(29)*M(2,:)%j) * den(127)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(74),h0tab(:,74),[32,12,2,17],[nMT,nMT,0,nMB],4,2,wf4(:,2),wf6(:,7))
  call Hloop_QW_A(ntryL,G0H144(1),ex6(:),G0H48(1),m3h3x48(:,42),heltab2x144(:,:,74))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(20),n2h48(42))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j)+c(29)*M(2,:)%j) * den(123)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(75),h0tab(:,75),[34,1,16,12],[0,nMT,nMB,nMB],4,2,wf6(:,8),wf4(:,2))
  call Hloop_QA_V(ntryL,G0H144(1),wf6(:,8),G0H24(4),m3h6x24(:,12),heltab2x144(:,:,75))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)+c(25)*M(2,:)%j) * den(123)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(76),h0tab(:,76),[34,12,1,16],[0,0,nMT,nMB],4,2,wf6(:,8),wf4(:,2))
  call Hloop_QA_V(ntryL,G0H144(1),wf6(:,8),G0H24(5),m3h6x24(:,13),heltab2x144(:,:,76))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j)+c(29)*M(2,:)%j) * den(123)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(77),h0tab(:,77),[34,1,12,16],[0,nMT,nMT,nMB],4,2,wf6(:,8),wf4(:,2))
  call Hloop_QA_V(ntryL,G0H144(1),wf6(:,8),G0H24(6),m3h6x24(:,14),heltab2x144(:,:,77))
  Gcoeff(:)%j = (c(56)*M(1,:)%j-c(55)*M(2,:)%j) * den(203)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(78),h0tab(:,78),[48,2,1,12],[nMT,0,nMT,nMT],4,2,wf9(:,1),wf4(:,2))
  call Hloop_QS_A(ntryL,G0H144(1),wf9(:,1),G0H16(1),ngH,m3h9x16(:,22),heltab2x144(:,:,78))
  call Hloop_Q_A(ntryL,G0H16(1),48,nMT,G1H16(6),n2h16(22))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)+c(16)*M(2,:)%j) * den(204)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(79),h0tab(:,79),[48,2,1,12],[nMT,0,nMT,nMT],4,2,wf9(:,2),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H144(1),wf9(:,2),G0H16(1),m3h9x16(:,23),heltab2x144(:,:,79))
  call Hloop_Q_A(ntryL,G0H16(1),48,nMT,G1H16(9),n2h16(23))
  Gcoeff(:)%j = (-(c(69)*M(1,:)%j)+c(68)*M(2,:)%j) * den(205)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(80),h0tab(:,80),[48,2,1,12],[nMT,0,nMT,nMT],4,2,wf9(:,3),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H144(1),wf9(:,3),G0H16(1),ngZu,m3h9x16(:,24),heltab2x144(:,:,80))
  call Hloop_Q_A(ntryL,G0H16(1),48,nMT,G1H16(12),n2h16(24))
  Gcoeff(:)%j = (c(56)*M(1,:)%j-c(55)*M(2,:)%j) * den(203)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(81),h0tab(:,81),[48,1,2,12],[nMT,0,nMT,nMT],4,2,wf9(:,1),wf4(:,2))
  call Hloop_AS_Q(ntryL,G0H144(1),wf9(:,1),G0H16(1),ngH,m3h9x16(:,25),heltab2x144(:,:,81))
  call Hloop_A_Q(ntryL,G0H16(1),48,nMT,G1H16(13),n2h16(25))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)+c(16)*M(2,:)%j) * den(204)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(82),h0tab(:,82),[48,1,2,12],[nMT,0,nMT,nMT],4,2,wf9(:,2),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H144(1),wf9(:,2),G0H16(1),m3h9x16(:,26),heltab2x144(:,:,82))
  call Hloop_A_Q(ntryL,G0H16(1),48,nMT,G1H16(14),n2h16(26))
  Gcoeff(:)%j = (-(c(69)*M(1,:)%j)+c(68)*M(2,:)%j) * den(205)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(83),h0tab(:,83),[48,1,2,12],[nMT,0,nMT,nMT],4,2,wf9(:,3),wf4(:,2))
  call Hloop_AZ_Q(ntryL,G0H144(1),wf9(:,3),G0H16(1),ngZu,m3h9x16(:,27),heltab2x144(:,:,83))
  call Hloop_A_Q(ntryL,G0H16(1),48,nMT,G1H16(15),n2h16(27))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j)+c(51)*M(2,:)%j) * den(203)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(84),h0tab(:,84),[48,1,12,2],[nMT,0,0,nMT],4,2,wf9(:,1),wf4(:,2))
  call Hloop_AS_Q(ntryL,G0H144(1),wf9(:,1),G0H16(1),ngH,m3h9x16(:,28),heltab2x144(:,:,84))
  call Hloop_A_Q(ntryL,G0H16(1),48,nMT,G1H16(16),n2h16(28))
  Gcoeff(:)%j = (c(4)*M(1,:)%j-c(3)*M(2,:)%j) * den(204)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(85),h0tab(:,85),[48,1,12,2],[nMT,0,0,nMT],4,2,wf9(:,2),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H144(1),wf9(:,2),G0H16(1),m3h9x16(:,29),heltab2x144(:,:,85))
  call Hloop_A_Q(ntryL,G0H16(1),48,nMT,G1H16(17),n2h16(29))
  Gcoeff(:)%j = (c(65)*M(1,:)%j-c(64)*M(2,:)%j) * den(205)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(86),h0tab(:,86),[48,1,12,2],[nMT,0,0,nMT],4,2,wf9(:,3),wf4(:,2))
  call Hloop_AZ_Q(ntryL,G0H144(1),wf9(:,3),G0H16(1),ngZu,m3h9x16(:,30),heltab2x144(:,:,86))
  call Hloop_A_Q(ntryL,G0H16(1),48,nMT,G1H16(18),n2h16(30))
  Gcoeff(:)%j = (c(36)*M(1,:)%j-c(32)*M(2,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(87),h0tab(:,87),[32,2,13,16],[nMT,0,nMT,nMB],4,1,wf8(:,8))
  call Hloop_QW_A(ntryL,G0H144(1),ex6(:),G0H48(1),m3h3x48(:,43),heltab2x144(:,:,87))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(21),n2h48(43))
  Gcoeff(:)%j = (c(36)*M(1,:)%j-c(32)*M(2,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(88),h0tab(:,88),[32,14,1,16],[nMT,0,nMT,nMB],4,1,wf8(:,6))
  call Hloop_QW_A(ntryL,G0H144(1),ex6(:),G0H48(1),m3h3x48(:,44),heltab2x144(:,:,88))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(22),n2h48(44))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)+c(33)*M(2,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(89),h0tab(:,89),[34,8,4,17],[0,nMB,0,nMB],4,2,wf6(:,8),wf6(:,7))
  call Hloop_QA_V(ntryL,G0H144(1),wf6(:,8),G0H24(2),m3h6x24(:,15),heltab2x144(:,:,89))
  Gcoeff(:)%j = (c(35)*M(1,:)%j+c(29)*M(2,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(90),h0tab(:,90),[34,4,8,17],[0,nMB,0,nMB],4,2,wf6(:,8),wf6(:,7))
  call Hloop_QA_V(ntryL,G0H144(1),wf6(:,8),G0H24(7),m3h6x24(:,16),heltab2x144(:,:,90))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)-c(35)*M(2,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(91),h0tab(:,91),[34,4,8,17],[nMB,0,nMB,0],4,2,wf6(:,8),wf6(:,7))
  call Hloop_VA_Q(ntryL,G0H144(1),wf6(:,8),G0H24(8),m3h6x24(:,17),heltab2x144(:,:,91))
  call Hloop_A_Q(ntryL,G0H24(8),34,nMB,G1H24(2),n2h24(4))
  Gcoeff(:)%j = (-(c(33)*M(1,:)%j)+c(31)*M(2,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(92),h0tab(:,92),[34,4,17,8],[nMB,0,nMB,0],4,2,wf6(:,8),wf6(:,7))
  call Hloop_VA_Q(ntryL,G0H144(1),wf6(:,8),G0H24(8),m3h6x24(:,18),heltab2x144(:,:,92))
  call Hloop_A_Q(ntryL,G0H24(8),34,nMB,G1H24(3),n2h24(5))
  Gcoeff(:)%j = (-(c(33)*M(1,:)%j)+c(31)*M(2,:)%j) * den(206)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(93),h0tab(:,93),[36,2,8,17],[nMT,0,nMB,0],4,2,wf6(:,3),wf6(:,7))
  call Hloop_VQ_A(ntryL,G0H144(1),wf6(:,3),G0H24(8),m3h6x24(:,19),heltab2x144(:,:,93))
  call Hloop_Q_A(ntryL,G0H24(8),36,nMT,G1H24(4),n2h24(6))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)-c(35)*M(2,:)%j) * den(206)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(94),h0tab(:,94),[36,2,17,8],[nMT,0,nMB,0],4,2,wf6(:,3),wf6(:,7))
  call Hloop_VQ_A(ntryL,G0H144(1),wf6(:,3),G0H24(8),m3h6x24(:,20),heltab2x144(:,:,94))
  call Hloop_Q_A(ntryL,G0H24(8),36,nMT,G1H24(5),n2h24(7))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)+c(30)*M(2,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(95),h0tab(:,95),[32,2,4,25],[nMT,0,nMB,nMB],4,1,wf12(:,2))
  call Hloop_QW_A(ntryL,G0H144(1),ex6(:),G0H48(1),m3h3x48(:,45),heltab2x144(:,:,95))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(23),n2h48(45))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)+c(30)*M(2,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(96),h0tab(:,96),[32,4,2,25],[nMB,0,nMT,nMT],4,1,wf12(:,2))
  call Hloop_AW_Q(ntryL,G0H144(1),ex6(:),G0H48(1),m3h3x48(:,46),heltab2x144(:,:,96))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMB,G1H48(24),n2h48(46))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)+c(26)*M(2,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(97),h0tab(:,97),[32,2,25,4],[nMT,0,0,nMB],4,1,wf12(:,2))
  call Hloop_QW_A(ntryL,G0H144(1),ex6(:),G0H48(1),m3h3x48(:,47),heltab2x144(:,:,97))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(25),n2h48(47))
  Gcoeff(:)%j = (c(35)*M(1,:)%j+c(29)*M(2,:)%j) * den(74)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(98),h0tab(:,98),[49,2,4,8],[nMT,0,nMB,0],4,1,wf18(:,40))
  call Hloop_VQ_A(ntryL,G0H144(1),wf18(:,40),G0H8(1),m3h18x8(:,1),heltab2x144(:,:,98))
  call Hloop_Q_A(ntryL,G0H8(1),49,nMT,G1H8(1),n2h8(1))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)+c(33)*M(2,:)%j) * den(74)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(99),h0tab(:,99),[49,2,8,4],[nMT,0,nMB,0],4,1,wf18(:,40))
  call Hloop_VQ_A(ntryL,G0H144(1),wf18(:,40),G0H8(1),m3h18x8(:,2),heltab2x144(:,:,99))
  call Hloop_Q_A(ntryL,G0H8(1),49,nMT,G1H8(2),n2h8(2))
  Gcoeff(:)%j = (-(c(33)*M(1,:)%j)+c(31)*M(2,:)%j) * den(207)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(100),h0tab(:,100),[34,4,1,24],[nMB,0,nMT,0],4,2,wf6(:,8),wf6(:,4))
  call Hloop_VA_Q(ntryL,G0H144(1),wf6(:,8),G0H24(8),m3h6x24(:,21),heltab2x144(:,:,100))
  call Hloop_A_Q(ntryL,G0H24(8),34,nMB,G1H24(6),n2h24(8))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)-c(35)*M(2,:)%j) * den(207)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(101),h0tab(:,101),[34,1,24,4],[0,nMT,0,nMB],4,2,wf6(:,8),wf6(:,4))
  call Hloop_QA_V(ntryL,G0H144(1),wf6(:,8),G0H24(8),m3h6x24(:,22),heltab2x144(:,:,101))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)+c(33)*M(2,:)%j) * den(91)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(102),h0tab(:,102),[36,1,2,24],[0,nMT,0,nMT],4,2,wf6(:,3),wf6(:,4))
  call Hloop_AQ_V(ntryL,G0H144(1),wf6(:,3),G0H24(9),m3h6x24(:,23),heltab2x144(:,:,102))
  Gcoeff(:)%j = (c(35)*M(1,:)%j+c(29)*M(2,:)%j) * den(91)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(103),h0tab(:,103),[36,2,1,24],[0,nMT,0,nMT],4,2,wf6(:,3),wf6(:,4))
  call Hloop_AQ_V(ntryL,G0H144(1),wf6(:,3),G0H24(10),m3h6x24(:,24),heltab2x144(:,:,103))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)-c(35)*M(2,:)%j) * den(91)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(104),h0tab(:,104),[36,2,1,24],[nMT,0,nMT,0],4,2,wf6(:,3),wf6(:,4))
  call Hloop_VQ_A(ntryL,G0H144(1),wf6(:,3),G0H24(11),m3h6x24(:,25),heltab2x144(:,:,104))
  call Hloop_Q_A(ntryL,G0H24(11),36,nMT,G1H24(7),n2h24(9))
  Gcoeff(:)%j = (-(c(33)*M(1,:)%j)+c(31)*M(2,:)%j) * den(91)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(105),h0tab(:,105),[36,1,24,2],[0,nMT,0,nMT],4,2,wf6(:,3),wf6(:,4))
  call Hloop_AQ_V(ntryL,G0H144(1),wf6(:,3),G0H24(11),m3h6x24(:,26),heltab2x144(:,:,105))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)+c(30)*M(2,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(106),h0tab(:,106),[32,2,4,25],[nMT,0,nMB,nMB],4,1,wf12(:,4))
  call Hloop_QW_A(ntryL,G0H144(1),ex6(:),G0H48(1),m3h3x48(:,48),heltab2x144(:,:,106))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(26),n2h48(48))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)+c(30)*M(2,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(107),h0tab(:,107),[32,4,2,25],[nMB,0,nMT,nMT],4,1,wf12(:,4))
  call Hloop_AW_Q(ntryL,G0H144(1),ex6(:),G0H48(1),m3h3x48(:,49),heltab2x144(:,:,107))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMB,G1H48(27),n2h48(49))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)+c(26)*M(2,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(108),h0tab(:,108),[32,2,25,4],[nMT,0,0,nMB],4,1,wf12(:,4))
  call Hloop_QW_A(ntryL,G0H144(1),ex6(:),G0H48(1),m3h3x48(:,50),heltab2x144(:,:,108))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(28),n2h48(50))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)+c(33)*M(2,:)%j) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(109),h0tab(:,109),[56,2,1,4],[0,nMT,0,nMB],4,1,wf18(:,30))
  call Hloop_QA_V(ntryL,G0H144(1),wf18(:,30),G0H8(1),m3h18x8(:,3),heltab2x144(:,:,109))
  Gcoeff(:)%j = (c(35)*M(1,:)%j+c(29)*M(2,:)%j) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(110),h0tab(:,110),[56,1,2,4],[0,nMT,0,nMB],4,1,wf18(:,30))
  call Hloop_QA_V(ntryL,G0H144(1),wf18(:,30),G0H8(2),m3h18x8(:,4),heltab2x144(:,:,110))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)+c(30)*M(2,:)%j) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(111),h0tab(:,111),[38,8,1,16],[nMB,0,nMT,nMB],4,1,wf12(:,1))
  call Hloop_QV_A(ntryL,G0H144(1),wf12(:,1),G0H12(1),m3h12x12(:,1),heltab2x144(:,:,111))
  call Hloop_Q_A(ntryL,G0H12(1),38,nMB,G1H12(10),n2h12(31))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)+c(30)*M(2,:)%j) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(112),h0tab(:,112),[38,1,8,16],[nMT,0,nMB,nMT],4,1,wf12(:,1))
  call Hloop_AV_Q(ntryL,G0H144(1),wf12(:,1),G0H12(1),m3h12x12(:,2),heltab2x144(:,:,112))
  call Hloop_A_Q(ntryL,G0H12(1),38,nMT,G1H12(9),n2h12(32))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)+c(26)*M(2,:)%j) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(113),h0tab(:,113),[38,1,16,8],[0,nMT,nMB,0],4,1,wf12(:,1))
  call Hloop_UV_W(ntryL,G0H144(1),0,wf12(:,1),38,G1H12(8),m3h12x12(:,3),heltab2x144(:,:,113))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)+c(33)*M(2,:)%j) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(114),h0tab(:,114),[50,1,4,8],[nMT,0,nMB,0],4,1,wf18(:,45))
  call Hloop_VA_Q(ntryL,G0H144(1),wf18(:,45),G0H8(3),m3h18x8(:,5),heltab2x144(:,:,114))
  call Hloop_A_Q(ntryL,G0H8(3),50,nMT,G1H8(3),n2h8(3))
  Gcoeff(:)%j = (c(35)*M(1,:)%j+c(29)*M(2,:)%j) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(115),h0tab(:,115),[50,1,8,4],[nMT,0,nMB,0],4,1,wf18(:,45))
  call Hloop_VA_Q(ntryL,G0H144(1),wf18(:,45),G0H8(3),m3h18x8(:,6),heltab2x144(:,:,115))
  call Hloop_A_Q(ntryL,G0H8(3),50,nMT,G1H8(4),n2h8(4))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)+c(30)*M(2,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(116),h0tab(:,116),[38,8,1,16],[nMB,0,nMT,nMB],4,1,wf12(:,3))
  call Hloop_QV_A(ntryL,G0H144(1),wf12(:,3),G0H12(1),m3h12x12(:,4),heltab2x144(:,:,116))
  call Hloop_Q_A(ntryL,G0H12(1),38,nMB,G1H12(12),n2h12(33))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)+c(30)*M(2,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(117),h0tab(:,117),[38,1,8,16],[nMT,0,nMB,nMT],4,1,wf12(:,3))
  call Hloop_AV_Q(ntryL,G0H144(1),wf12(:,3),G0H12(1),m3h12x12(:,5),heltab2x144(:,:,117))
  call Hloop_A_Q(ntryL,G0H12(1),38,nMT,G1H12(1),n2h12(34))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)+c(26)*M(2,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(118),h0tab(:,118),[38,1,16,8],[0,nMT,nMB,0],4,1,wf12(:,3))
  call Hloop_UV_W(ntryL,G0H144(1),0,wf12(:,3),38,G1H12(2),m3h12x12(:,6),heltab2x144(:,:,118))
  Gcoeff(:)%j = (c(35)*M(1,:)%j+c(29)*M(2,:)%j) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(119),h0tab(:,119),[52,2,1,8],[0,nMT,0,nMB],4,1,wf18(:,25))
  call Hloop_AQ_V(ntryL,G0H144(1),wf18(:,25),G0H8(3),m3h18x8(:,7),heltab2x144(:,:,119))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)+c(33)*M(2,:)%j) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(120),h0tab(:,120),[52,1,2,8],[0,nMT,0,nMB],4,1,wf18(:,25))
  call Hloop_AQ_V(ntryL,G0H144(1),wf18(:,25),G0H8(4),m3h18x8(:,8),heltab2x144(:,:,120))
  Gcoeff(:)%j = (-(c(61)*M(1,:)%j)-c(55)*M(2,:)%j) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(121),h0tab(:,121),[49,2,4,8],[nMT,0,nMB,0],4,1,wf18(:,18))
  call Hloop_VQ_A(ntryL,G0H144(1),wf18(:,18),G0H8(5),m3h18x8(:,9),heltab2x144(:,:,121))
  call Hloop_Q_A(ntryL,G0H8(5),49,nMT,G1H8(5),n2h8(5))
  Gcoeff(:)%j = (c(22)*M(1,:)%j+c(16)*M(2,:)%j) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(122),h0tab(:,122),[49,2,4,8],[nMT,0,nMB,0],4,1,wf18(:,20))
  call Hloop_VQ_A(ntryL,G0H144(1),wf18(:,20),G0H8(5),m3h18x8(:,10),heltab2x144(:,:,122))
  call Hloop_Q_A(ntryL,G0H8(5),49,nMT,G1H8(6),n2h8(6))
  Gcoeff(:)%j = (c(74)*M(1,:)%j+c(68)*M(2,:)%j) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(123),h0tab(:,123),[49,2,4,8],[nMT,0,nMB,0],4,1,wf18(:,22))
  call Hloop_VQ_A(ntryL,G0H144(1),wf18(:,22),G0H8(5),m3h18x8(:,11),heltab2x144(:,:,123))
  call Hloop_Q_A(ntryL,G0H8(5),49,nMT,G1H8(7),n2h8(7))
  Gcoeff(:)%j = (c(57)*M(1,:)%j-c(59)*M(2,:)%j) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(124),h0tab(:,124),[49,2,8,4],[nMT,0,nMB,0],4,1,wf18(:,18))
  call Hloop_VQ_A(ntryL,G0H144(1),wf18(:,18),G0H8(5),m3h18x8(:,12),heltab2x144(:,:,124))
  call Hloop_Q_A(ntryL,G0H8(5),49,nMT,G1H8(8),n2h8(8))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)+c(20)*M(2,:)%j) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(125),h0tab(:,125),[49,2,8,4],[nMT,0,nMB,0],4,1,wf18(:,20))
  call Hloop_VQ_A(ntryL,G0H144(1),wf18(:,20),G0H8(5),m3h18x8(:,13),heltab2x144(:,:,125))
  call Hloop_Q_A(ntryL,G0H8(5),49,nMT,G1H8(9),n2h8(9))
  Gcoeff(:)%j = (-(c(70)*M(1,:)%j)+c(72)*M(2,:)%j) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(126),h0tab(:,126),[49,2,8,4],[nMT,0,nMB,0],4,1,wf18(:,22))
  call Hloop_VQ_A(ntryL,G0H144(1),wf18(:,22),G0H8(5),m3h18x8(:,14),heltab2x144(:,:,126))
  call Hloop_Q_A(ntryL,G0H8(5),49,nMT,G1H8(10),n2h8(10))
  Gcoeff(:)%j = (c(57)*M(1,:)%j-c(59)*M(2,:)%j) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(127),h0tab(:,127),[50,1,4,8],[nMT,0,nMB,0],4,1,wf18(:,46))
  call Hloop_VA_Q(ntryL,G0H144(1),wf18(:,46),G0H8(5),m3h18x8(:,15),heltab2x144(:,:,127))
  call Hloop_A_Q(ntryL,G0H8(5),50,nMT,G1H8(11),n2h8(11))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)+c(20)*M(2,:)%j) * den(82)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(128),h0tab(:,128),[50,1,4,8],[nMT,0,nMB,0],4,1,wf18(:,47))
  call Hloop_VA_Q(ntryL,G0H144(1),wf18(:,47),G0H8(5),m3h18x8(:,16),heltab2x144(:,:,128))
  call Hloop_A_Q(ntryL,G0H8(5),50,nMT,G1H8(12),n2h8(12))
  Gcoeff(:)%j = (-(c(70)*M(1,:)%j)+c(72)*M(2,:)%j) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(129),h0tab(:,129),[50,1,4,8],[nMT,0,nMB,0],4,1,wf18(:,48))
  call Hloop_VA_Q(ntryL,G0H144(1),wf18(:,48),G0H8(5),m3h18x8(:,17),heltab2x144(:,:,129))
  call Hloop_A_Q(ntryL,G0H8(5),50,nMT,G1H8(13),n2h8(13))
  Gcoeff(:)%j = (-(c(61)*M(1,:)%j)-c(55)*M(2,:)%j) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(130),h0tab(:,130),[50,1,8,4],[nMT,0,nMB,0],4,1,wf18(:,46))
  call Hloop_VA_Q(ntryL,G0H144(1),wf18(:,46),G0H8(5),m3h18x8(:,18),heltab2x144(:,:,130))
  call Hloop_A_Q(ntryL,G0H8(5),50,nMT,G1H8(14),n2h8(14))
  Gcoeff(:)%j = (c(22)*M(1,:)%j+c(16)*M(2,:)%j) * den(82)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(131),h0tab(:,131),[50,1,8,4],[nMT,0,nMB,0],4,1,wf18(:,47))
  call Hloop_VA_Q(ntryL,G0H144(1),wf18(:,47),G0H8(5),m3h18x8(:,19),heltab2x144(:,:,131))
  call Hloop_A_Q(ntryL,G0H8(5),50,nMT,G1H8(15),n2h8(15))
  Gcoeff(:)%j = (c(74)*M(1,:)%j+c(68)*M(2,:)%j) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(132),h0tab(:,132),[50,1,8,4],[nMT,0,nMB,0],4,1,wf18(:,48))
  call Hloop_VA_Q(ntryL,G0H144(1),wf18(:,48),G0H8(5),m3h18x8(:,20),heltab2x144(:,:,132))
  call Hloop_A_Q(ntryL,G0H8(5),50,nMT,G1H8(16),n2h8(16))
  Gcoeff(:)%j = (-(c(48)*M(1,:)%j)-c(42)*M(2,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(133),h0tab(:,133),[52,2,1,8],[0,nMT,0,nMB],4,1,wf18(:,7))
  call Hloop_AQ_V(ntryL,G0H144(1),wf18(:,7),G0H8(5),m3h18x8(:,21),heltab2x144(:,:,133))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)-c(7)*M(2,:)%j) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(134),h0tab(:,134),[52,2,1,8],[0,nMT,0,nMB],4,1,wf18(:,9))
  call Hloop_AQ_V(ntryL,G0H144(1),wf18(:,9),G0H8(6),m3h18x8(:,22),heltab2x144(:,:,134))
  Gcoeff(:)%j = (c(74)*M(1,:)%j+c(68)*M(2,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(135),h0tab(:,135),[52,2,1,8],[0,nMT,0,nMB],4,1,wf18(:,11))
  call Hloop_AQ_V(ntryL,G0H144(1),wf18(:,11),G0H8(7),m3h18x8(:,23),heltab2x144(:,:,135))
  Gcoeff(:)%j = (c(44)*M(1,:)%j-c(46)*M(2,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(136),h0tab(:,136),[52,1,2,8],[0,nMT,0,nMB],4,1,wf18(:,7))
  call Hloop_AQ_V(ntryL,G0H144(1),wf18(:,7),G0H8(8),m3h18x8(:,24),heltab2x144(:,:,136))
  Gcoeff(:)%j = (c(9)*M(1,:)%j-c(11)*M(2,:)%j) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(137),h0tab(:,137),[52,1,2,8],[0,nMT,0,nMB],4,1,wf18(:,9))
  call Hloop_AQ_V(ntryL,G0H144(1),wf18(:,9),G0H8(9),m3h18x8(:,25),heltab2x144(:,:,137))
  Gcoeff(:)%j = (-(c(70)*M(1,:)%j)+c(72)*M(2,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(138),h0tab(:,138),[52,1,2,8],[0,nMT,0,nMB],4,1,wf18(:,11))
  call Hloop_AQ_V(ntryL,G0H144(1),wf18(:,11),G0H8(10),m3h18x8(:,26),heltab2x144(:,:,138))
  Gcoeff(:)%j = (c(44)*M(1,:)%j-c(46)*M(2,:)%j) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(139),h0tab(:,139),[56,2,1,4],[0,nMT,0,nMB],4,1,wf18(:,34))
  call Hloop_QA_V(ntryL,G0H144(1),wf18(:,34),G0H8(11),m3h18x8(:,27),heltab2x144(:,:,139))
  Gcoeff(:)%j = (c(9)*M(1,:)%j-c(11)*M(2,:)%j) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(140),h0tab(:,140),[56,2,1,4],[0,nMT,0,nMB],4,1,wf18(:,35))
  call Hloop_QA_V(ntryL,G0H144(1),wf18(:,35),G0H8(12),m3h18x8(:,28),heltab2x144(:,:,140))
  Gcoeff(:)%j = (-(c(70)*M(1,:)%j)+c(72)*M(2,:)%j) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(141),h0tab(:,141),[56,2,1,4],[0,nMT,0,nMB],4,1,wf18(:,36))
  call Hloop_QA_V(ntryL,G0H144(1),wf18(:,36),G0H8(13),m3h18x8(:,29),heltab2x144(:,:,141))
  Gcoeff(:)%j = (-(c(48)*M(1,:)%j)-c(42)*M(2,:)%j) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(142),h0tab(:,142),[56,1,2,4],[0,nMT,0,nMB],4,1,wf18(:,34))
  call Hloop_QA_V(ntryL,G0H144(1),wf18(:,34),G0H8(14),m3h18x8(:,30),heltab2x144(:,:,142))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)-c(7)*M(2,:)%j) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(143),h0tab(:,143),[56,1,2,4],[0,nMT,0,nMB],4,1,wf18(:,35))
  call Hloop_QA_V(ntryL,G0H144(1),wf18(:,35),G0H8(15),m3h18x8(:,31),heltab2x144(:,:,143))
  Gcoeff(:)%j = (c(74)*M(1,:)%j+c(68)*M(2,:)%j) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(144),h0tab(:,144),[56,1,2,4],[0,nMT,0,nMB],4,1,wf18(:,36))
  call Hloop_QA_V(ntryL,G0H144(1),wf18(:,36),G0H8(16),m3h18x8(:,32),heltab2x144(:,:,144))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(5),[G1H16(1),G1H16(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(7),[G1H16(8),G1H16(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(3),[G1H16(10),G1H16(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(12),[G1H16(9),G1H16(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(15),[G1H16(14),G1H16(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(18),[G1H16(17),G1H16(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(7),[G1H8(6),G1H8(5),G1H8(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(10),[G1H8(9),G1H8(8),G1H8(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(13),[G0H8(12),G0H8(11),G0H8(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(16),[G0H8(15),G0H8(14),G0H8(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(12),[G1H12(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(1),[G1H12(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(2),[G1H12(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(13),[G1H8(12),G1H8(11),G1H8(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(16),[G1H8(15),G1H8(14),G1H8(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(7),[G0H8(6),G0H8(5),G0H8(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(10),[G0H8(9),G0H8(8),G0H8(4)])
  call Hloop_QW_A(ntryL,G1H12(11),ex5(:),G1H4(6),m3h3x4(:,20),heltab2x12(:,:,48))
  call Hloop_Q_A(ntryL,G1H4(6),51,nMB,G2H4(3),n2h4(24))
  call Hloop_QV_A(ntryL,G1H48(1),wf4(:,2),G1H12(4),m3h4x12(:,4),heltab2x48(:,:,23))
  call Hloop_Q_A(ntryL,G1H12(4),44,0,G2H12(2),n2h12(35))
  call Hloop_QV_A(ntryL,G1H48(2),wf4(:,2),G1H12(13),m3h4x12(:,5),heltab2x48(:,:,24))
  call Hloop_Q_A(ntryL,G1H12(13),44,nMT,G2H12(3),n2h12(36))
  call Hloop_AV_Q(ntryL,G1H48(3),wf4(:,2),G1H12(14),m3h4x12(:,6),heltab2x48(:,:,25))
  call Hloop_A_Q(ntryL,G1H12(14),44,0,G2H12(4),n2h12(37))
  call Hloop_AV_Q(ntryL,G1H48(4),wf4(:,2),G1H12(15),m3h4x12(:,7),heltab2x48(:,:,26))
  call Hloop_A_Q(ntryL,G1H12(15),44,nMB,G2H12(5),n2h12(38))
  call Hloop_QV_A(ntryL,G1H48(5),wf4(:,1),G1H12(18),m3h4x12(:,8),heltab2x48(:,:,27))
  call Hloop_Q_A(ntryL,G1H12(18),35,0,G2H12(7),n2h12(39))
  call Hloop_QV_A(ntryL,G1H48(6),wf4(:,1),G1H12(19),m3h4x12(:,9),heltab2x48(:,:,28))
  call Hloop_Q_A(ntryL,G1H12(19),35,nMT,G2H12(8),n2h12(40))
  call Hloop_AV_Q(ntryL,G1H48(7),wf4(:,1),G1H12(10),m3h4x12(:,10),heltab2x48(:,:,29))
  call Hloop_A_Q(ntryL,G1H12(10),35,0,G2H12(9),n2h12(41))
  call Hloop_AV_Q(ntryL,G1H48(8),wf4(:,1),G1H12(9),m3h4x12(:,11),heltab2x48(:,:,30))
  call Hloop_A_Q(ntryL,G1H12(9),35,nMB,G2H12(10),n2h12(42))
  call Hloop_QV_A(ntryL,G1H48(9),wf4(:,1),G1H12(8),m3h4x12(:,12),heltab2x48(:,:,31))
  call Hloop_Q_A(ntryL,G1H12(8),35,0,G2H12(6),n2h12(43))
  call Hloop_QV_A(ntryL,G1H48(10),wf4(:,1),G1H12(11),m3h4x12(:,13),heltab2x48(:,:,32))
  call Hloop_Q_A(ntryL,G1H12(11),35,nMT,G2H12(1),n2h12(44))
  call Hloop_AV_Q(ntryL,G1H48(11),wf4(:,1),G1H12(4),m3h4x12(:,14),heltab2x48(:,:,33))
  call Hloop_A_Q(ntryL,G1H12(4),35,0,G2H12(11),n2h12(45))
  call Hloop_AV_Q(ntryL,G1H48(12),wf4(:,1),G1H12(13),m3h4x12(:,15),heltab2x48(:,:,34))
  call Hloop_A_Q(ntryL,G1H12(13),35,nMB,G2H12(12),n2h12(46))
  call Hloop_AQ_V(ntryL,G1H48(13),ex3(:),G1H24(8),m3h2x24(:,20),heltab2x48(:,:,35))
  call Hloop_QV_A(ntryL,G1H48(14),wf4(:,1),G1H12(14),m3h4x12(:,16),heltab2x48(:,:,36))
  call Hloop_Q_A(ntryL,G1H12(14),35,nMT,G2H12(13),n2h12(47))
  call Hloop_AV_Q(ntryL,G1H48(15),wf4(:,1),G1H12(15),m3h4x12(:,17),heltab2x48(:,:,37))
  call Hloop_A_Q(ntryL,G1H12(15),35,nMB,G2H12(14),n2h12(48))
  call Hloop_UV_W(ntryL,G0H24(1),36,wf4(:,1),3,G1H6(37),m3h4x6(:,3),heltab2x24(:,:,28))
  call Hloop_QV_A(ntryL,G1H24(1),wf4(:,1),G1H6(38),m3h4x6(:,4),heltab2x24(:,:,29))
  call Hloop_Q_A(ntryL,G1H6(38),39,nMT,G2H6(4),n2h6(14))
  call Hloop_VA_Q(ntryL,G0H24(3),ex4(:),G0H12(1),m3h2x12(:,24),heltab2x24(:,:,30))
  call Hloop_A_Q(ntryL,G0H12(1),44,nMB,G1H12(18),n2h12(49))
  call Hloop_AV_Q(ntryL,G1H16(5),wf4(:,1),G1H4(1),m3h4x4(:,1),heltab2x16(:,:,5))
  call Hloop_A_Q(ntryL,G1H4(1),51,nMB,G2H4(4),n2h4(25))
  call Hloop_QV_A(ntryL,G1H16(7),wf4(:,1),G1H4(2),m3h4x4(:,2),heltab2x16(:,:,6))
  call Hloop_Q_A(ntryL,G1H4(2),51,nMB,G2H4(8),n2h4(26))
  call Hloop_AQ_V(ntryL,G1H16(3),ex3(:),G1H8(6),m3h2x8(:,5),heltab2x16(:,:,7))
  call Hloop_AQ_V(ntryL,G1H48(16),wf8(:,2),G1H6(41),m3h8x6(:,1),heltab2x48(:,:,38))
  call Hloop_AQ_V(ntryL,G1H48(17),ex3(:),G1H24(9),m3h2x24(:,21),heltab2x48(:,:,39))
  call Hloop_QA_V(ntryL,G1H48(18),ex2(:),G1H24(10),m3h2x24(:,22),heltab2x48(:,:,40))
  call Hloop_QA_V(ntryL,G1H48(19),ex2(:),G1H24(11),m3h2x24(:,23),heltab2x48(:,:,41))
  call Hloop_QV_A(ntryL,G1H48(20),wf4(:,2),G1H12(19),m3h4x12(:,18),heltab2x48(:,:,42))
  call Hloop_Q_A(ntryL,G1H12(19),44,nMT,G2H12(15),n2h12(50))
  call Hloop_VQ_A(ntryL,G0H24(4),ex1(:),G0H12(1),m3h2x12(:,25),heltab2x24(:,:,31))
  call Hloop_Q_A(ntryL,G0H12(1),35,nMT,G1H12(10),n2h12(51))
  call Hloop_UV_W(ntryL,G0H24(5),34,wf4(:,2),12,G1H6(42),m3h4x6(:,5),heltab2x24(:,:,32))
  call Hloop_VQ_A(ntryL,G0H24(6),ex1(:),G0H12(1),m3h2x12(:,26),heltab2x24(:,:,33))
  call Hloop_Q_A(ntryL,G0H12(1),35,nMT,G1H12(9),n2h12(52))
  call Hloop_QA_V(ntryL,G1H16(12),ex2(:),G1H8(5),m3h2x8(:,6),heltab2x16(:,:,8))
  call Hloop_AQ_V(ntryL,G1H16(15),ex1(:),G1H8(1),m3h2x8(:,7),heltab2x16(:,:,9))
  call Hloop_AQ_V(ntryL,G1H16(18),ex1(:),G1H8(9),m3h2x8(:,8),heltab2x16(:,:,10))
  call Hloop_QA_V(ntryL,G1H48(21),ex2(:),G1H24(12),m3h2x24(:,24),heltab2x48(:,:,43))
  call Hloop_QA_V(ntryL,G1H48(22),wf8(:,6),G1H6(13),m3h8x6(:,2),heltab2x48(:,:,44))
  call Hloop_VA_Q(ntryL,G0H24(2),ex4(:),G0H12(1),m3h2x12(:,27),heltab2x24(:,:,34))
  call Hloop_A_Q(ntryL,G0H12(1),42,nMB,G1H12(8),n2h12(53))
  call Hloop_VQ_A(ntryL,G0H24(7),ex3(:),G0H12(1),m3h2x12(:,28),heltab2x24(:,:,35))
  call Hloop_Q_A(ntryL,G0H12(1),38,nMB,G1H12(11),n2h12(54))
  call Hloop_AQ_V(ntryL,G1H24(2),ex3(:),G1H12(4),m3h2x12(:,29),heltab2x24(:,:,36))
  call Hloop_AQ_V(ntryL,G1H24(3),ex3(:),G1H12(13),m3h2x12(:,30),heltab2x24(:,:,37))
  call Hloop_QA_V(ntryL,G1H24(4),ex2(:),G1H12(14),m3h2x12(:,31),heltab2x24(:,:,38))
  call Hloop_QA_V(ntryL,G1H24(5),ex2(:),G1H12(15),m3h2x12(:,32),heltab2x24(:,:,39))
  call Hloop_QA_V(ntryL,G1H48(23),ex2(:),G1H24(13),m3h2x24(:,25),heltab2x48(:,:,45))
  call Hloop_AQ_V(ntryL,G1H48(24),ex3(:),G1H24(14),m3h2x24(:,26),heltab2x48(:,:,46))
  call Hloop_QA_V(ntryL,G1H48(25),ex2(:),G1H24(15),m3h2x24(:,27),heltab2x48(:,:,47))
  call Hloop_QA_V(ntryL,G1H8(7),ex2(:),G1H4(7),m3h2x4(:,5),heltab2x8(:,:,5))
  call Hloop_QA_V(ntryL,G1H8(10),ex2(:),G1H4(8),m3h2x4(:,6),heltab2x8(:,:,6))
  call Hloop_AQ_V(ntryL,G1H24(6),ex3(:),G1H12(19),m3h2x12(:,33),heltab2x24(:,:,40))
  call Hloop_VQ_A(ntryL,G0H24(8),ex1(:),G0H12(1),m3h2x12(:,34),heltab2x24(:,:,41))
  call Hloop_Q_A(ntryL,G0H12(1),35,nMT,G1H12(20),n2h12(55))
  call Hloop_VQ_A(ntryL,G0H24(9),ex1(:),G0H12(1),m3h2x12(:,35),heltab2x24(:,:,42))
  call Hloop_Q_A(ntryL,G0H12(1),37,nMT,G1H12(21),n2h12(56))
  call Hloop_VA_Q(ntryL,G0H24(10),ex2(:),G0H12(1),m3h2x12(:,36),heltab2x24(:,:,43))
  call Hloop_A_Q(ntryL,G0H12(1),38,nMT,G1H12(22),n2h12(57))
  call Hloop_QA_V(ntryL,G1H24(7),ex2(:),G1H12(23),m3h2x12(:,37),heltab2x24(:,:,44))
  call Hloop_VQ_A(ntryL,G0H24(11),ex1(:),G0H12(1),m3h2x12(:,38),heltab2x24(:,:,45))
  call Hloop_Q_A(ntryL,G0H12(1),37,nMT,G1H12(24),n2h12(58))
  call Hloop_QA_V(ntryL,G1H48(26),ex2(:),G1H24(1),m3h2x24(:,28),heltab2x48(:,:,48))
  call Hloop_AQ_V(ntryL,G1H48(27),ex3(:),G1H24(2),m3h2x24(:,29),heltab2x48(:,:,49))
  call Hloop_QA_V(ntryL,G1H48(28),ex2(:),G1H24(3),m3h2x24(:,30),heltab2x48(:,:,50))
  call Hloop_VA_Q(ntryL,G0H8(13),ex2(:),G0H4(1),m3h2x4(:,7),heltab2x8(:,:,7))
  call Hloop_A_Q(ntryL,G0H4(1),58,nMT,G1H4(6),n2h4(27))
  call Hloop_VQ_A(ntryL,G0H8(16),ex1(:),G0H4(1),m3h2x4(:,8),heltab2x8(:,:,8))
  call Hloop_Q_A(ntryL,G0H4(1),57,nMT,G1H4(1),n2h4(28))
  call Hloop_QA_V(ntryL,G1H12(12),ex4(:),G1H6(14),m3h2x6(:,20),heltab2x12(:,:,49))
  call Hloop_AQ_V(ntryL,G1H12(1),ex1(:),G1H6(8),m3h2x6(:,21),heltab2x12(:,:,50))
  call Hloop_VQ_A(ntryL,G1H12(2),ex1(:),G1H6(5),m3h2x6(:,22),heltab2x12(:,:,51))
  call Hloop_Q_A(ntryL,G1H6(5),39,nMT,G2H6(1),n2h6(15))
  call Hloop_AQ_V(ntryL,G1H8(13),ex1(:),G1H4(2),m3h2x4(:,9),heltab2x8(:,:,9))
  call Hloop_AQ_V(ntryL,G1H8(16),ex1(:),G1H4(12),m3h2x4(:,10),heltab2x8(:,:,10))
  call Hloop_VA_Q(ntryL,G0H8(7),ex2(:),G0H4(1),m3h2x4(:,11),heltab2x8(:,:,11))
  call Hloop_A_Q(ntryL,G0H4(1),54,nMT,G1H4(13),n2h4(29))
  call Hloop_VQ_A(ntryL,G0H8(10),ex1(:),G0H4(1),m3h2x4(:,12),heltab2x8(:,:,12))
  call Hloop_Q_A(ntryL,G0H4(1),53,nMT,G1H4(14),n2h4(30))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(4),[G1H6(19)])
call HGT_lower_alpha_w2_OLR(G2H6(9),1,1,6)
call HGT_lower_alpha_w2_invQ_OLR(G2H6(9),2,5,6)
call HGT_lower_alpha_w2_OLR(G2H6(9),6,15,6)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(9),[G2H6(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(1),[G1H6(39),G1H6(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(37),[G1H6(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(41),[G1H6(28),G1H6(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(42),[G1H6(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(13),[G1H6(34),G1H6(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(18),[G1H12(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(5),[G1H12(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(10),[G1H12(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(1),[G1H12(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(9),[G1H12(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(8),[G1H12(17)])
  call Hotf_4pt_reduction(G2H6(9),RedSet_4(82),mass4set(:,8),  & 
G1H6(9),G1H6(4),G1H6(7),G1H6(10),G1H6(22),6)
  call HG1shiftOLR(G1H6(4),8,6)
  call Hloop_QA_V(ntryL,G2H4(14),ex4(:),G2H2(2),m3h2x2(:,18),heltab2x4(:,:,22))
  call Hotf_4pt_reduction(G2H6(1),RedSet_4(81),mass4set(:,9),  & 
G1H6(29),G1H6(30),G1H6(36),G1H6(38),G1H6(5),6)
  call HG1shiftOLR(G1H6(30),8,6)
  call Hloop_AW_Q(ntryL,G1H6(3),ex5(:),G1H2(48),m3h3x2(:,18),heltab2x6(:,:,61))
  call Hloop_A_Q(ntryL,G1H2(48),62,nMT,G2H2(4),n2h2(10))
  call Hloop_AW_Q(ntryL,G1H6(11),ex5(:),G1H2(2),m3h3x2(:,19),heltab2x6(:,:,62))
  call Hloop_A_Q(ntryL,G1H2(2),62,nMT,G2H2(15),n2h2(11))
  call Hloop_VA_Q(ntryL,G1H6(37),ex4(:),G1H3(45),m3h2x3(:,32),heltab2x6(:,:,63))
  call Hloop_A_Q(ntryL,G1H3(45),47,nMB,G2H3(2),n2h3(35))
  call Hloop_VA_Q(ntryL,G1H6(41),ex4(:),G1H3(75),m3h2x3(:,33),heltab2x6(:,:,64))
  call Hloop_A_Q(ntryL,G1H3(75),47,nMB,G2H3(4),n2h3(36))
  call Hloop_VQ_A(ntryL,G1H6(42),ex1(:),G1H3(103),m3h2x3(:,34),heltab2x6(:,:,65))
  call Hloop_Q_A(ntryL,G1H3(103),47,nMT,G2H3(6),n2h3(37))
  call Hloop_VQ_A(ntryL,G1H6(13),ex1(:),G1H3(114),m3h2x3(:,35),heltab2x6(:,:,66))
  call Hloop_Q_A(ntryL,G1H3(114),47,nMT,G2H3(8),n2h3(38))
  call Hloop_AV_Q(ntryL,G1H12(18),wf4(:,1),G1H3(125),m3h4x3(:,8),heltab2x12(:,:,52))
  call Hloop_A_Q(ntryL,G1H3(125),47,nMB,G2H3(1),n2h3(39))
  call Hotf_4pt_reduction(G2H12(5),RedSet_4(120),mass4set(:,10),  & 
G1H12(12),G1H12(1),G1H12(2),G1H12(6),G1H12(7),G0H12(1),12)
  call HG1shiftOLR(G1H12(1),16,12)
  call Hloop_VA_Q(ntryL,G1H6(27),ex4(:),G1H3(136),m3h2x3(:,36),heltab2x6(:,:,67))
  call Hloop_A_Q(ntryL,G1H3(136),47,nMB,G2H3(3),n2h3(40))
  call Hloop_QW_A(ntryL,G1H12(10),ex5(:),G1H4(15),m3h3x4(:,21),heltab2x12(:,:,53))
  call Hloop_Q_A(ntryL,G1H4(15),51,nMB,G2H4(9),n2h4(31))
  call Hotf_4pt_reduction(G2H12(1),RedSet_4(8),mass4set(:,1),  & 
G1H12(5),G1H12(3),G1H12(16),G1H12(17),G1H12(18),G0H12(2),12)
  call HG1shiftOLR(G1H12(3),12,12)
  call Hloop_VQ_A(ntryL,G1H6(33),ex1(:),G1H3(8),m3h2x3(:,37),heltab2x6(:,:,68))
  call Hloop_Q_A(ntryL,G1H3(8),47,nMT,G2H3(13),n2h3(41))
  call Hloop_QV_A(ntryL,G1H12(9),wf4(:,2),G1H3(13),m3h4x3(:,9),heltab2x12(:,:,54))
  call Hloop_Q_A(ntryL,G1H3(13),47,nMT,G2H3(5),n2h3(42))
  call Hotf_4pt_reduction(G2H12(8),RedSet_4(123),mass4set(:,11),  & 
G1H12(10),G1H12(9),G1H12(25),G1H12(26),G1H12(27),G0H12(3),12)
  call HG1shiftOLR(G1H12(9),16,12)
  call Hloop_QW_A(ntryL,G1H6(40),ex5(:),G1H2(7),m3h3x2(:,20),heltab2x6(:,:,69))
  call Hloop_Q_A(ntryL,G1H2(7),55,nMB,G2H2(16),n2h2(12))
  call Hloop_QA_V(ntryL,G2H4(3),ex4(:),G2H2(13),m3h2x2(:,19),heltab2x4(:,:,23))
  call Hotf_4pt_reduction(G2H12(2),RedSet_4(120),mass4set(:,12),  & 
G1H12(28),G1H12(29),G1H12(30),G1H12(31),G1H12(32),G0H12(4),12)
  call HG1shiftOLR(G1H12(29),16,12)
  call Hotf_4pt_reduction(G2H12(3),RedSet_4(120),mass4set(:,11),  & 
G1H12(33),G1H12(34),G1H12(35),G1H12(36),G1H12(37),G0H12(5),12)
  call HG1shiftOLR(G1H12(34),16,12)
  call Hotf_4pt_reduction(G2H12(4),RedSet_4(120),mass4set(:,12),  & 
G1H12(38),G1H12(39),G1H12(40),G1H12(41),G1H12(42),G0H12(6),12)
  call HG1shiftOLR(G1H12(39),16,12)
  call Hotf_4pt_reduction(G2H12(7),RedSet_4(123),mass4set(:,12),  & 
G1H12(43),G1H12(44),G1H12(45),G1H12(46),G1H12(47),G0H12(7),12)
  call HG1shiftOLR(G1H12(44),16,12)
  call Hotf_4pt_reduction(G2H12(9),RedSet_4(123),mass4set(:,12),  & 
G1H12(48),G1H12(49),G1H12(50),G1H12(51),G1H12(52),G0H12(8),12)
  call HG1shiftOLR(G1H12(49),16,12)
  call Hotf_4pt_reduction(G2H12(10),RedSet_4(123),mass4set(:,10),  & 
G1H12(53),G1H12(54),G1H12(55),G1H12(56),G1H12(57),G0H12(9),12)
  call HG1shiftOLR(G1H12(54),16,12)
  call Hotf_4pt_reduction(G2H12(6),RedSet_4(8),mass4set(:,12),  & 
G1H12(58),G1H12(59),G1H12(60),G1H12(61),G1H12(62),G0H12(10),12)
  call HG1shiftOLR(G1H12(59),12,12)
  call Hotf_4pt_reduction(G2H12(11),RedSet_4(8),mass4set(:,12),  & 
G1H12(63),G1H12(64),G1H12(65),G1H12(66),G1H12(67),G0H12(11),12)
  call HG1shiftOLR(G1H12(64),12,12)
  call Hotf_4pt_reduction(G2H12(12),RedSet_4(8),mass4set(:,13),  & 
G1H12(68),G1H12(69),G1H12(70),G1H12(71),G1H12(72),G0H12(12),12)
  call HG1shiftOLR(G1H12(69),12,12)
  call Hloop_UV_W(ntryL,G1H24(8),36,wf4(:,1),3,G2H6(3),m3h4x6(:,6),heltab2x24(:,:,46))
  call Hloop_QA_V(ntryL,G2H12(13),wf6(:,4),G2H2(12),m3h6x2(:,3),heltab2x12(:,:,55))
  call Hloop_AQ_V(ntryL,G2H12(14),ex3(:),G2H6(7),m3h2x6(:,23),heltab2x12(:,:,56))
  call Hloop_AQ_V(ntryL,G2H4(4),ex3(:),G2H2(5),m3h2x2(:,20),heltab2x4(:,:,24))
  call Hloop_QA_V(ntryL,G2H4(8),ex4(:),G2H2(6),m3h2x2(:,21),heltab2x4(:,:,25))
  call Hloop_UV_W(ntryL,G1H8(6),52,wf4(:,1),3,G2H2(7),m3h4x2(:,1),heltab2x8(:,:,13))
  call Hloop_VA_Q(ntryL,G1H24(9),wf8(:,4),G1H3(6),m3h8x3(:,1),heltab2x24(:,:,47))
  call Hloop_A_Q(ntryL,G1H3(6),47,nMB,G2H3(7),n2h3(43))
  call Hloop_VQ_A(ntryL,G1H24(10),wf6(:,7),G1H4(15),m3h6x4(:,3),heltab2x24(:,:,48))
  call Hloop_Q_A(ntryL,G1H4(15),51,nMB,G2H4(10),n2h4(32))
  call Hloop_UV_W(ntryL,G1H24(11),34,wf4(:,2),12,G2H6(8),m3h4x6(:,7),heltab2x24(:,:,49))
  call Hloop_QA_V(ntryL,G2H12(15),ex2(:),G2H6(5),m3h2x6(:,24),heltab2x12(:,:,57))
  call Hloop_VQ_A(ntryL,G1H8(5),ex1(:),G1H4(15),m3h2x4(:,13),heltab2x8(:,:,14))
  call Hloop_Q_A(ntryL,G1H4(15),51,nMT,G2H4(11),n2h4(33))
  call Hloop_VA_Q(ntryL,G1H8(1),ex2(:),G1H4(15),m3h2x4(:,14),heltab2x8(:,:,15))
  call Hloop_A_Q(ntryL,G1H4(15),51,nMT,G2H4(12),n2h4(34))
  call Hloop_UV_W(ntryL,G1H8(9),49,wf4(:,2),12,G2H2(8),m3h4x2(:,2),heltab2x8(:,:,16))
  call Hloop_VQ_A(ntryL,G1H24(12),wf8(:,8),G1H3(12),m3h8x3(:,2),heltab2x24(:,:,50))
  call Hloop_Q_A(ntryL,G1H3(12),47,nMT,G2H3(9),n2h3(44))
  call Hloop_AQ_V(ntryL,G1H12(8),ex3(:),G1H6(19),m3h2x6(:,25),heltab2x12(:,:,58))
  call Hloop_QA_V(ntryL,G1H12(11),ex4(:),G1H6(39),m3h2x6(:,26),heltab2x12(:,:,59))
  call Hloop_VA_Q(ntryL,G1H12(4),ex4(:),G1H6(18),m3h2x6(:,27),heltab2x12(:,:,60))
  call Hloop_A_Q(ntryL,G1H6(18),46,nMB,G2H6(6),n2h6(16))
  call Hloop_VQ_A(ntryL,G1H12(13),wf6(:,7),G1H2(12),m3h6x2(:,4),heltab2x12(:,:,61))
  call Hloop_Q_A(ntryL,G1H2(12),55,nMB,G2H2(9),n2h2(13))
  call Hloop_VA_Q(ntryL,G1H12(14),ex4(:),G1H6(17),m3h2x6(:,28),heltab2x12(:,:,62))
  call Hloop_A_Q(ntryL,G1H6(17),46,nMB,G2H6(2),n2h6(17))
  call Hloop_VQ_A(ntryL,G1H12(15),wf6(:,7),G1H2(3),m3h6x2(:,5),heltab2x12(:,:,63))
  call Hloop_Q_A(ntryL,G1H2(3),55,nMB,G2H2(19),n2h2(14))
  call Hloop_VQ_A(ntryL,G1H24(13),ex3(:),G1H12(8),m3h2x12(:,39),heltab2x24(:,:,51))
  call Hloop_Q_A(ntryL,G1H12(8),38,nMB,G2H12(5),n2h12(59))
  call Hloop_VA_Q(ntryL,G1H24(14),ex2(:),G1H12(11),m3h2x12(:,40),heltab2x24(:,:,52))
  call Hloop_A_Q(ntryL,G1H12(11),38,nMT,G2H12(1),n2h12(60))
  call Hloop_UV_W(ntryL,G1H24(15),34,wf12(:,2),25,G2H2(1),m3h12x2(:,1),heltab2x24(:,:,53))
  call Hloop_VQ_A(ntryL,G1H4(7),ex3(:),G1H2(4),m3h2x2(:,22),heltab2x4(:,:,26))
  call Hloop_Q_A(ntryL,G1H2(4),55,nMB,G2H2(10),n2h2(15))
  call Hloop_VA_Q(ntryL,G1H4(8),ex4(:),G1H2(11),m3h2x2(:,23),heltab2x4(:,:,27))
  call Hloop_A_Q(ntryL,G1H2(11),59,nMB,G2H2(11),n2h2(16))
  call Hloop_VQ_A(ntryL,G1H12(19),ex1(:),G1H6(28),m3h2x6(:,29),heltab2x12(:,:,64))
  call Hloop_Q_A(ntryL,G1H6(28),39,nMT,G2H6(4),n2h6(18))
  call Hloop_QA_V(ntryL,G1H12(20),wf6(:,4),G1H2(13),m3h6x2(:,6),heltab2x12(:,:,65))
  call Hloop_QA_V(ntryL,G1H12(21),ex2(:),G1H6(21),m3h2x6(:,30),heltab2x12(:,:,66))
  call Hloop_AQ_V(ntryL,G1H12(22),ex1(:),G1H6(1),m3h2x6(:,31),heltab2x12(:,:,67))
  call Hloop_VQ_A(ntryL,G1H12(23),ex1(:),G1H6(34),m3h2x6(:,32),heltab2x12(:,:,68))
  call Hloop_Q_A(ntryL,G1H6(34),39,nMT,G2H6(9),n2h6(19))
  call Hloop_QA_V(ntryL,G1H12(24),wf6(:,4),G1H2(14),m3h6x2(:,7),heltab2x12(:,:,69))
  call Hloop_VQ_A(ntryL,G1H24(1),ex3(:),G1H12(4),m3h2x12(:,41),heltab2x24(:,:,54))
  call Hloop_Q_A(ntryL,G1H12(4),38,nMB,G2H12(8),n2h12(61))
  call Hloop_VA_Q(ntryL,G1H24(2),ex2(:),G1H12(13),m3h2x12(:,42),heltab2x24(:,:,55))
  call Hloop_A_Q(ntryL,G1H12(13),38,nMT,G2H12(2),n2h12(62))
  call Hloop_UV_W(ntryL,G1H24(3),34,wf12(:,4),25,G2H2(3),m3h12x2(:,2),heltab2x24(:,:,56))
  call Hloop_AQ_V(ntryL,G1H4(6),ex1(:),G1H2(18),m3h2x2(:,24),heltab2x4(:,:,28))
  call Hloop_QA_V(ntryL,G1H4(1),ex2(:),G1H2(19),m3h2x2(:,25),heltab2x4(:,:,29))
  call Hloop_VQ_A(ntryL,G1H6(14),ex1(:),G1H3(18),m3h2x3(:,38),heltab2x6(:,:,70))
  call Hloop_Q_A(ntryL,G1H3(18),47,nMT,G2H3(10),n2h3(45))
  call Hloop_VA_Q(ntryL,G1H6(8),ex4(:),G1H3(11),m3h2x3(:,39),heltab2x6(:,:,71))
  call Hloop_A_Q(ntryL,G1H3(11),47,nMB,G2H3(16),n2h3(46))
  call Hloop_VQ_A(ntryL,G1H4(2),ex3(:),G1H2(20),m3h2x2(:,26),heltab2x4(:,:,30))
  call Hloop_Q_A(ntryL,G1H2(20),55,nMB,G2H2(14),n2h2(17))
  call Hloop_VA_Q(ntryL,G1H4(12),ex4(:),G1H2(24),m3h2x2(:,27),heltab2x4(:,:,31))
  call Hloop_A_Q(ntryL,G1H2(24),59,nMB,G2H2(17),n2h2(18))
  call Hloop_AQ_V(ntryL,G1H4(13),ex1(:),G1H2(25),m3h2x2(:,28),heltab2x4(:,:,32))
  call Hloop_QA_V(ntryL,G1H4(14),ex2(:),G1H2(26),m3h2x2(:,29),heltab2x4(:,:,33))
  call Hloop_QW_A(ntryL,G1H6(9),ex5(:),G1H2(30),m3h3x2(:,21),heltab2x6(:,:,72))
  call Hloop_Q_A(ntryL,G1H2(30),55,nMB,G2H2(18),n2h2(19))
call HGT_raise_alpha_OLR(G1H6(4),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(4),2,5,6)
  call Hloop_VA_Q(ntryL,G1H6(4),ex4(:),G1H3(5),m3h2x3(:,40),heltab2x6(:,:,73))
  call Hloop_QW_A(ntryL,G1H6(10),ex5(:),G1H2(31),m3h3x2(:,22),heltab2x6(:,:,74))
  call Hloop_Q_A(ntryL,G1H2(31),55,nMB,G2H2(21),n2h2(20))
  call Hloop_QW_A(ntryL,G1H6(22),ex5(:),G1H2(32),m3h3x2(:,23),heltab2x6(:,:,75))
  call Hloop_Q_A(ntryL,G1H2(32),55,nMB,G2H2(22),n2h2(21))
  call Hloop_QW_A(ntryL,G1H6(29),ex5(:),G1H2(36),m3h3x2(:,24),heltab2x6(:,:,76))
  call Hloop_Q_A(ntryL,G1H2(36),55,nMB,G2H2(24),n2h2(22))
call HGT_raise_alpha_OLR(G1H6(30),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(30),2,5,6)
  call Hloop_VA_Q(ntryL,G1H6(30),ex4(:),G1H3(9),m3h2x3(:,41),heltab2x6(:,:,77))
  call Hloop_QW_A(ntryL,G1H6(38),ex5(:),G1H2(37),m3h3x2(:,25),heltab2x6(:,:,78))
  call Hloop_Q_A(ntryL,G1H2(37),55,nMB,G2H2(25),n2h2(23))
  call Hloop_QW_A(ntryL,G1H6(5),ex5(:),G1H2(38),m3h3x2(:,26),heltab2x6(:,:,79))
  call Hloop_Q_A(ntryL,G1H2(38),55,nMB,G2H2(27),n2h2(24))
  call Hloop_AV_Q(ntryL,G1H12(12),wf4(:,1),G1H3(23),m3h4x3(:,10),heltab2x12(:,:,70))
  call Hloop_A_Q(ntryL,G1H3(23),47,nMB,G2H3(11),n2h3(47))
call HGT_OLR(G1H12(1),1,1,12)
call HGT_invQ_OLR(G1H12(1),2,5,12)
  call Hloop_Q_A(ntryL,G1H12(1),-16,nMT,G2H12(3),n2h12(63))
  call Hloop_QW_A(ntryL,G2H12(3),ex5(:),G2H4(13),m3h3x4(:,22),heltab2x12(:,:,71))
  call Hloop_AV_Q(ntryL,G1H12(6),wf4(:,1),G1H3(17),m3h4x3(:,11),heltab2x12(:,:,72))
  call Hloop_A_Q(ntryL,G1H3(17),47,nMB,G2H3(12),n2h3(48))
  call Hloop_AV_Q(ntryL,G1H12(7),wf4(:,1),G1H3(21),m3h4x3(:,12),heltab2x12(:,:,73))
  call Hloop_A_Q(ntryL,G1H3(21),47,nMB,G2H3(15),n2h3(49))
  call Hloop_AV_Q(ntryL,G0H12(1),wf4(:,1),G0H3(1),m3h4x3(:,13),heltab2x12(:,:,74))
  call Hloop_A_Q(ntryL,G0H3(1),47,nMB,G1H3(27),n2h3(50))
  call Hloop_QW_A(ntryL,G1H12(5),ex5(:),G1H4(15),m3h3x4(:,23),heltab2x12(:,:,75))
  call Hloop_Q_A(ntryL,G1H4(15),51,nMB,G2H4(15),n2h4(35))
call HGT_OLR(G1H12(3),1,1,12)
call HGT_invQ_OLR(G1H12(3),2,5,12)
  call Hloop_A_Q(ntryL,G1H12(3),-12,nMB,G2H12(4),n2h12(64))
  call Hloop_AV_Q(ntryL,G2H12(4),wf4(:,2),G2H3(18),m3h4x3(:,14),heltab2x12(:,:,76))
  call Hloop_QW_A(ntryL,G1H12(17),ex5(:),G1H4(7),m3h3x4(:,24),heltab2x12(:,:,77))
  call Hloop_Q_A(ntryL,G1H4(7),51,nMB,G2H4(16),n2h4(36))
  call Hloop_QW_A(ntryL,G1H12(18),ex5(:),G1H4(8),m3h3x4(:,25),heltab2x12(:,:,78))
  call Hloop_Q_A(ntryL,G1H4(8),51,nMB,G2H4(5),n2h4(37))
  call Hloop_QW_A(ntryL,G0H12(2),ex5(:),G0H4(1),m3h3x4(:,26),heltab2x12(:,:,79))
  call Hloop_Q_A(ntryL,G0H4(1),51,nMB,G1H4(6),n2h4(38))
  call Hloop_QV_A(ntryL,G1H12(10),wf4(:,2),G1H3(28),m3h4x3(:,15),heltab2x12(:,:,80))
  call Hloop_Q_A(ntryL,G1H3(28),47,nMT,G2H3(19),n2h3(51))
call HGT_OLR(G1H12(9),1,1,12)
call HGT_invQ_OLR(G1H12(9),2,5,12)
  call Hloop_A_Q(ntryL,G1H12(9),-16,nMB,G2H12(7),n2h12(65))
  call Hloop_AW_Q(ntryL,G2H12(7),ex5(:),G2H4(7),m3h3x4(:,27),heltab2x12(:,:,81))
  call Hloop_QV_A(ntryL,G1H12(26),wf4(:,2),G1H3(29),m3h4x3(:,16),heltab2x12(:,:,82))
  call Hloop_Q_A(ntryL,G1H3(29),47,nMT,G2H3(21),n2h3(52))
  call Hloop_QV_A(ntryL,G1H12(27),wf4(:,2),G1H3(33),m3h4x3(:,17),heltab2x12(:,:,83))
  call Hloop_Q_A(ntryL,G1H3(33),47,nMT,G2H3(22),n2h3(53))
  call Hloop_QV_A(ntryL,G0H12(3),wf4(:,2),G0H3(1),m3h4x3(:,18),heltab2x12(:,:,84))
  call Hloop_Q_A(ntryL,G0H3(1),47,nMT,G1H3(34),n2h3(54))
  call Hloop_QV_A(ntryL,G1H12(28),wf4(:,1),G1H3(35),m3h4x3(:,19),heltab2x12(:,:,85))
  call Hloop_Q_A(ntryL,G1H3(35),47,0,G2H3(24),n2h3(55))
call HGT_OLR(G1H12(29),1,1,12)
call HGT_invQ_OLR(G1H12(29),2,5,12)
  call Hloop_A_Q(ntryL,G1H12(29),-16,0,G2H12(9),n2h12(66))
  call Hloop_AW_Q(ntryL,G2H12(9),ex5(:),G2H4(14),m3h3x4(:,28),heltab2x12(:,:,86))
  call Hloop_QV_A(ntryL,G1H12(31),wf4(:,1),G1H3(39),m3h4x3(:,20),heltab2x12(:,:,87))
  call Hloop_Q_A(ntryL,G1H3(39),47,0,G2H3(26),n2h3(56))
  call Hloop_QV_A(ntryL,G1H12(32),wf4(:,1),G1H3(40),m3h4x3(:,21),heltab2x12(:,:,88))
  call Hloop_Q_A(ntryL,G1H3(40),47,0,G2H3(28),n2h3(57))
  call Hloop_QV_A(ntryL,G0H12(4),wf4(:,1),G0H3(1),m3h4x3(:,22),heltab2x12(:,:,89))
  call Hloop_Q_A(ntryL,G0H3(1),47,0,G1H3(41),n2h3(58))
  call Hloop_QV_A(ntryL,G1H12(33),wf4(:,1),G1H3(88),m3h4x3(:,23),heltab2x12(:,:,90))
  call Hloop_Q_A(ntryL,G1H3(88),47,nMT,G2H3(29),n2h3(59))
call HGT_OLR(G1H12(34),1,1,12)
call HGT_invQ_OLR(G1H12(34),2,5,12)
  call Hloop_A_Q(ntryL,G1H12(34),-16,nMB,G2H12(10),n2h12(67))
  call Hloop_AW_Q(ntryL,G2H12(10),ex5(:),G2H4(3),m3h3x4(:,29),heltab2x12(:,:,91))
  call Hloop_QV_A(ntryL,G1H12(36),wf4(:,1),G1H3(46),m3h4x3(:,24),heltab2x12(:,:,92))
  call Hloop_Q_A(ntryL,G1H3(46),47,nMT,G2H3(31),n2h3(60))
  call Hloop_QV_A(ntryL,G1H12(37),wf4(:,1),G1H3(47),m3h4x3(:,25),heltab2x12(:,:,93))
  call Hloop_Q_A(ntryL,G1H3(47),47,nMT,G2H3(32),n2h3(61))
  call Hloop_QV_A(ntryL,G0H12(5),wf4(:,1),G0H3(1),m3h4x3(:,26),heltab2x12(:,:,94))
  call Hloop_Q_A(ntryL,G0H3(1),47,nMT,G1H3(51),n2h3(62))
  call Hloop_AV_Q(ntryL,G1H12(38),wf4(:,1),G1H3(52),m3h4x3(:,27),heltab2x12(:,:,95))
  call Hloop_A_Q(ntryL,G1H3(52),47,0,G2H3(33),n2h3(63))
call HGT_OLR(G1H12(39),1,1,12)
call HGT_invQ_OLR(G1H12(39),2,5,12)
  call Hloop_Q_A(ntryL,G1H12(39),-16,0,G2H12(6),n2h12(68))
  call Hloop_QW_A(ntryL,G2H12(6),ex5(:),G2H4(4),m3h3x4(:,30),heltab2x12(:,:,96))
  call Hloop_AV_Q(ntryL,G1H12(41),wf4(:,1),G1H3(53),m3h4x3(:,28),heltab2x12(:,:,97))
  call Hloop_A_Q(ntryL,G1H3(53),47,0,G2H3(34),n2h3(64))
  call Hloop_AV_Q(ntryL,G1H12(42),wf4(:,1),G1H3(57),m3h4x3(:,29),heltab2x12(:,:,98))
  call Hloop_A_Q(ntryL,G1H3(57),47,0,G2H3(35),n2h3(65))
  call Hloop_AV_Q(ntryL,G0H12(6),wf4(:,1),G0H3(1),m3h4x3(:,30),heltab2x12(:,:,99))
  call Hloop_A_Q(ntryL,G0H3(1),47,0,G1H3(58),n2h3(66))
  call Hloop_QV_A(ntryL,G1H12(43),wf4(:,2),G1H3(59),m3h4x3(:,31),heltab2x12(:,:,100))
  call Hloop_Q_A(ntryL,G1H3(59),47,0,G2H3(36),n2h3(67))
call HGT_OLR(G1H12(44),1,1,12)
call HGT_invQ_OLR(G1H12(44),2,5,12)
  call Hloop_A_Q(ntryL,G1H12(44),-16,0,G2H12(11),n2h12(69))
  call Hloop_AW_Q(ntryL,G2H12(11),ex5(:),G2H4(8),m3h3x4(:,31),heltab2x12(:,:,101))
  call Hloop_QV_A(ntryL,G1H12(46),wf4(:,2),G1H3(63),m3h4x3(:,32),heltab2x12(:,:,102))
  call Hloop_Q_A(ntryL,G1H3(63),47,0,G2H3(37),n2h3(68))
  call Hloop_QV_A(ntryL,G1H12(47),wf4(:,2),G1H3(64),m3h4x3(:,33),heltab2x12(:,:,103))
  call Hloop_Q_A(ntryL,G1H3(64),47,0,G2H3(38),n2h3(69))
  call Hloop_QV_A(ntryL,G0H12(7),wf4(:,2),G0H3(1),m3h4x3(:,34),heltab2x12(:,:,104))
  call Hloop_Q_A(ntryL,G0H3(1),47,0,G1H3(65),n2h3(70))
  call Hloop_AV_Q(ntryL,G1H12(48),wf4(:,2),G1H3(69),m3h4x3(:,35),heltab2x12(:,:,105))
  call Hloop_A_Q(ntryL,G1H3(69),47,0,G2H3(39),n2h3(71))
call HGT_OLR(G1H12(49),1,1,12)
call HGT_invQ_OLR(G1H12(49),2,5,12)
  call Hloop_Q_A(ntryL,G1H12(49),-16,0,G2H12(12),n2h12(70))
  call Hloop_QW_A(ntryL,G2H12(12),ex5(:),G2H4(17),m3h3x4(:,32),heltab2x12(:,:,106))
  call Hloop_AV_Q(ntryL,G1H12(51),wf4(:,2),G1H3(70),m3h4x3(:,36),heltab2x12(:,:,107))
  call Hloop_A_Q(ntryL,G1H3(70),47,0,G2H3(40),n2h3(72))
  call Hloop_AV_Q(ntryL,G1H12(52),wf4(:,2),G1H3(71),m3h4x3(:,37),heltab2x12(:,:,108))
  call Hloop_A_Q(ntryL,G1H3(71),47,0,G2H3(41),n2h3(73))
  call Hloop_AV_Q(ntryL,G0H12(8),wf4(:,2),G0H3(1),m3h4x3(:,38),heltab2x12(:,:,109))
  call Hloop_A_Q(ntryL,G0H3(1),47,0,G1H3(93),n2h3(74))
  call Hloop_AV_Q(ntryL,G1H12(53),wf4(:,2),G1H3(76),m3h4x3(:,39),heltab2x12(:,:,110))
  call Hloop_A_Q(ntryL,G1H3(76),47,nMB,G2H3(42),n2h3(75))
call HGT_OLR(G1H12(54),1,1,12)
call HGT_invQ_OLR(G1H12(54),2,5,12)
  call Hloop_Q_A(ntryL,G1H12(54),-16,nMT,G2H12(13),n2h12(71))
  call Hloop_QW_A(ntryL,G2H12(13),ex5(:),G2H4(18),m3h3x4(:,33),heltab2x12(:,:,111))
  call Hloop_AV_Q(ntryL,G1H12(56),wf4(:,2),G1H3(77),m3h4x3(:,40),heltab2x12(:,:,112))
  call Hloop_A_Q(ntryL,G1H3(77),47,nMB,G2H3(43),n2h3(76))
  call Hloop_AV_Q(ntryL,G1H12(57),wf4(:,2),G1H3(81),m3h4x3(:,41),heltab2x12(:,:,113))
  call Hloop_A_Q(ntryL,G1H3(81),47,nMB,G2H3(44),n2h3(77))
  call Hloop_AV_Q(ntryL,G0H12(9),wf4(:,2),G0H3(1),m3h4x3(:,42),heltab2x12(:,:,114))
  call Hloop_A_Q(ntryL,G0H3(1),47,nMB,G1H3(82),n2h3(78))
  call Hloop_QW_A(ntryL,G1H12(58),ex5(:),G1H4(1),m3h3x4(:,34),heltab2x12(:,:,115))
  call Hloop_Q_A(ntryL,G1H4(1),51,0,G2H4(19),n2h4(39))
call HGT_OLR(G1H12(59),1,1,12)
call HGT_invQ_OLR(G1H12(59),2,5,12)
  call Hloop_A_Q(ntryL,G1H12(59),-12,0,G2H12(14),n2h12(72))
  call Hloop_AV_Q(ntryL,G2H12(14),wf4(:,2),G2H3(45),m3h4x3(:,43),heltab2x12(:,:,116))
  call Hloop_QW_A(ntryL,G1H12(61),ex5(:),G1H4(2),m3h3x4(:,35),heltab2x12(:,:,117))
  call Hloop_Q_A(ntryL,G1H4(2),51,0,G2H4(20),n2h4(40))
  call Hloop_QW_A(ntryL,G1H12(62),ex5(:),G1H4(12),m3h3x4(:,36),heltab2x12(:,:,118))
  call Hloop_Q_A(ntryL,G1H4(12),51,0,G2H4(21),n2h4(41))
  call Hloop_QW_A(ntryL,G0H12(10),ex5(:),G0H4(1),m3h3x4(:,37),heltab2x12(:,:,119))
  call Hloop_Q_A(ntryL,G0H4(1),51,0,G1H4(13),n2h4(42))
  call Hloop_AW_Q(ntryL,G1H12(63),ex5(:),G1H4(14),m3h3x4(:,38),heltab2x12(:,:,120))
  call Hloop_A_Q(ntryL,G1H4(14),51,0,G2H4(22),n2h4(43))
call HGT_OLR(G1H12(64),1,1,12)
call HGT_invQ_OLR(G1H12(64),2,5,12)
  call Hloop_Q_A(ntryL,G1H12(64),-12,0,G2H12(15),n2h12(73))
  call Hloop_QV_A(ntryL,G2H12(15),wf4(:,2),G2H3(46),m3h4x3(:,44),heltab2x12(:,:,121))
  call Hloop_AW_Q(ntryL,G1H12(66),ex5(:),G1H4(15),m3h3x4(:,39),heltab2x12(:,:,122))
  call Hloop_A_Q(ntryL,G1H4(15),51,0,G2H4(23),n2h4(44))
  call Hloop_AW_Q(ntryL,G1H12(67),ex5(:),G1H4(7),m3h3x4(:,40),heltab2x12(:,:,123))
  call Hloop_A_Q(ntryL,G1H4(7),51,0,G2H4(24),n2h4(45))
  call Hloop_AW_Q(ntryL,G0H12(11),ex5(:),G0H4(1),m3h3x4(:,41),heltab2x12(:,:,124))
  call Hloop_A_Q(ntryL,G0H4(1),51,0,G1H4(8),n2h4(46))
  call Hloop_AW_Q(ntryL,G1H12(68),ex5(:),G1H4(1),m3h3x4(:,42),heltab2x12(:,:,125))
  call Hloop_A_Q(ntryL,G1H4(1),51,nMT,G2H4(25),n2h4(47))
call HGT_OLR(G1H12(69),1,1,12)
call HGT_invQ_OLR(G1H12(69),2,5,12)
  call Hloop_Q_A(ntryL,G1H12(69),-12,nMT,G2H12(3),n2h12(74))
  call Hloop_QV_A(ntryL,G2H12(3),wf4(:,2),G2H3(47),m3h4x3(:,45),heltab2x12(:,:,126))
  call Hloop_AW_Q(ntryL,G1H12(71),ex5(:),G1H4(2),m3h3x4(:,43),heltab2x12(:,:,127))
  call Hloop_A_Q(ntryL,G1H4(2),51,nMT,G2H4(26),n2h4(48))
  call Hloop_AW_Q(ntryL,G1H12(72),ex5(:),G1H4(12),m3h3x4(:,44),heltab2x12(:,:,128))
  call Hloop_A_Q(ntryL,G1H4(12),51,nMT,G2H4(27),n2h4(49))
  call Hloop_AW_Q(ntryL,G0H12(12),ex5(:),G0H4(1),m3h3x4(:,45),heltab2x12(:,:,129))
  call Hloop_A_Q(ntryL,G0H4(1),51,nMT,G1H4(14),n2h4(50))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(12),[G2H2(20),G1H2(47),G1H2(1)])
call ol_merge_last(G1H3(1), G1H3(1)) 
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(25),[G1H3(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(13),[G1H3(122)])
call HGT_OLR(G2H3(25),1,1,3)
call HGT_invQ_OLR(G2H3(25),2,5,3)
call HGT_OLR(G2H3(25),6,15,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(25),[G2H3(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(19),[G2H2(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(36),[G1H3(30)])
call HGT_w2_OLR(G1H3(2),1,1,3)
call HGT_w2_invQ_OLR(G1H3(2),2,5,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(2),[G1H3(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(7),[G1H2(23),G1H2(17)])
call HGT_OLR(G2H2(28),1,1,2)
call HGT_invQ_OLR(G2H2(28),2,5,2)
call HGT_OLR(G2H2(28),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(28),[G2H2(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(7),[G2H3(20),G2H3(14),G1H3(102),G1H3(44),G1H3(4) &
    ,G1H3(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(35),[G1H2(29)])
call HGT_OLR(G2H2(29),1,1,2)
call HGT_invQ_OLR(G2H2(29),2,5,2)
call HGT_OLR(G2H2(29),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(29),[G1H2(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(9),[G2H3(30),G2H3(17),G1H3(135),G1H3(74),G1H3(26) &
    ,G1H3(16)])
call HGT_OLR(G2H2(30),1,1,2)
call HGT_invQ_OLR(G2H2(30),2,5,2)
call HGT_OLR(G2H2(30),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(30),[G2H2(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(42),[G2H3(23),G1H3(113)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(10),[G2H4(6),G1H4(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(29),[G2H3(27),G1H3(124)])
call HGT_OLR(G2H4(1),1,1,4)
call HGT_invQ_OLR(G2H4(1),2,5,4)
call HGT_OLR(G2H4(1),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(1),[G2H4(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(66),[G1H3(60)])
call HGT_w2_OLR(G1H3(7),1,1,3)
call HGT_w2_invQ_OLR(G1H3(7),2,5,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(7),[G1H3(66)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(9),[G2H2(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(13),[G1H2(41),G1H2(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(3),[G2H2(1),G1H2(71),G1H2(53),G1H2(10),G1H2(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(59),[G1H2(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(65),[G1H2(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(26),[G1H2(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(32),[G1H3(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(38),[G1H3(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(25),[G1H2(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(50),[G1H3(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(56),[G1H3(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(62),[G1H3(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(68),[G1H3(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(80),[G1H3(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(86),[G1H3(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(13),[G1H2(45),G1H2(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(51),[G1H2(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(2),[G1H2(52),G1H2(46)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(63),[G1H2(57)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(69),[G1H2(58)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(70),[G1H2(64)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(2),[G1H3(49),G1H3(42),G1H3(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(4),[G1H3(112),G1H3(55),G1H3(43),G1H3(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(16),[G1H3(54),G1H3(48)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(6),[G1H3(79),G1H3(72),G1H3(61)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(8),[G1H3(123),G1H3(85),G1H3(73),G1H3(67)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(10),[G1H3(84),G1H3(78)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(39),[G1H6(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(8),[G1H6(12),G1H6(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(19),[G1H6(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(21),[G1H6(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(3),[G1H6(35),G1H6(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(1),[G1H6(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(14),[G1H2(77)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(8),[G1H2(89),G1H2(83)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(118),[G1H3(91)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(108),[G1H3(92)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(129),[G1H3(96)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(141),[G1H3(97)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(1),[G1H3(100)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(11),[G1H3(101)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(15),[G1H3(107)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(3),[G1H3(111)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(44),[G1H3(119)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(9),[G1H4(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(15),[G1H4(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(5),[G1H4(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(32),[G1H3(130)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(5),[G1H3(133)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(19),[G1H3(134)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(22),[G1H3(140)])
  call Hotf_4pt_reduction(G2H2(12),RedSet_4(7),mass4set(:,7),  & 
G1H2(42),G1H2(43),G1H2(44),G1H2(91),G1H2(49),2)
  call HG1shiftOLR(G1H2(43),4,2)
  call Hotf_4pt_reduction(G2H3(25),RedSet_4(125),mass4set(:,6),  & 
G1H3(83),G1H3(87),G1H3(89),G1H3(94),G1H3(98),3)
  call HG1shiftOLR(G1H3(87),16,3)
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(19),ex4(:),G2tensor(2),m3h2x1(:,57),heltab2x2(:,:,57))
  call Hloop_AW_Q(ntryL,G1H3(2),ex5(:),G1H1(1),m3h3x1(:,69),heltab2x3(:,:,69))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(4),n2h1(135))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(26),ex1(:),G2tensor(6),m3h2x1(:,58),heltab2x2(:,:,58))
  call Hotf_4pt_reduction(G2H2(28),RedSet_4(90),mass4set(:,14),  & 
G1H2(50),G1H2(54),G1H2(55),G1H2(56),G1H2(60),2)
  call HG1shiftOLR(G1H2(54),8,2)
  call Hotf_4pt_reduction(G2H3(7),RedSet_4(39),mass4set(:,4),  & 
G1H3(99),G1H3(104),G1H3(105),G1H3(109),G1H3(110),3)
  call HG1shiftOLR(G1H3(104),16,3)
  call Hotf_4pt_reduction(G2H2(29),RedSet_4(97),mass4set(:,15),  & 
G1H2(61),G1H2(62),G1H2(66),G1H2(67),G1H2(68),2)
  call HG1shiftOLR(G1H2(62),1,2)
  call Hotf_4pt_reduction(G2H3(9),RedSet_4(64),mass4set(:,6),  & 
G1H3(115),G1H3(116),G1H3(120),G1H3(121),G1H3(126),3)
  call HG1shiftOLR(G1H3(116),16,3)
call HGT_OLR(G2H4(2),1,1,4)
call HGT_invQ_OLR(G2H4(2),2,5,4)
call HGT_OLR(G2H4(2),6,15,4)
  call Hotf_4pt_reduction(G2H4(2),RedSet_4(129),mass4set(:,16),  & 
G1H4(15),G1H4(7),G1H4(1),G1H4(2),G1H4(12),4)
  call HG1shiftOLR(G1H4(7),3,4)
  call Hotf_4pt_reduction(G2H2(30),RedSet_4(130),mass4set(:,17),  & 
G1H2(72),G1H2(73),G1H2(74),G1H2(78),G1H2(79),2)
  call HG1shiftOLR(G1H2(73),8,2)
  call Hotf_4pt_reduction(G2H3(42),RedSet_4(123),mass4set(:,10),  & 
G1H3(127),G1H3(131),G1H3(132),G1H3(137),G1H3(138),3)
  call HG1shiftOLR(G1H3(131),16,3)
  call Hotf_4pt_reduction(G2H4(10),RedSet_4(11),mass4set(:,18),  & 
G1H4(5),G1H4(3),G1H4(4),G1H4(10),G1H4(16),4)
  call HG1shiftOLR(G1H4(3),12,4)
call HGT_OLR(G2H2(31),1,1,2)
call HGT_invQ_OLR(G2H2(31),2,5,2)
call HGT_OLR(G2H2(31),6,15,2)
  call Hotf_4pt_reduction(G2H2(31),RedSet_4(131),mass4set(:,19),  & 
G1H2(80),G1H2(84),G1H2(85),G1H2(86),G1H2(90),2)
  call HG1shiftOLR(G1H2(84),1,2)
  call Hotf_4pt_reduction(G2H3(29),RedSet_4(120),mass4set(:,11),  & 
G1H3(45),G1H3(75),G1H3(103),G1H3(114),G1H3(125),3)
  call HG1shiftOLR(G1H3(75),16,3)
  call Hotf_4pt_reduction(G2H4(1),RedSet_4(132),mass4set(:,20),  & 
G1H4(17),G1H4(18),G1H4(19),G1H4(20),G1H4(21),4)
  call HG1shiftOLR(G1H4(18),12,4)
  call Hloop_QW_A(ntryL,G1H3(7),ex5(:),G1H1(1),m3h3x1(:,70),heltab2x3(:,:,70))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(8),n2h1(136))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(9),ex4(:),G2tensor(10),m3h2x1(:,59),heltab2x2(:,:,59))
  call Hloop_VQ_A(ntryL,G1H2(13),ex3(:),G1H1(1),m3h2x1(:,60),heltab2x2(:,:,60))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(12),n2h1(137))
  call Hotf_4pt_reduction(G2H2(3),RedSet_4(10),mass4set(:,3),  & 
G1H2(92),G1H2(48),G1H2(2),G1H2(7),G1H2(12),2)
  call HG1shiftOLR(G1H2(48),4,2)
  call Hloop_VQ_A(ntryL,G1H2(59),ex3(:),G1H1(1),m3h2x1(:,61),heltab2x2(:,:,61))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(1),n2h1(138))
  call Hloop_VQ_A(ntryL,G1H2(65),ex3(:),G1H1(1),m3h2x1(:,62),heltab2x2(:,:,62))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(5),n2h1(139))
  call Hloop_VA_Q(ntryL,G1H2(26),ex4(:),G1H1(1),m3h2x1(:,63),heltab2x2(:,:,63))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(19),n2h1(140))
  call Hloop_VA_Q(ntryL,G1H2(16),ex4(:),G1H1(1),m3h2x1(:,64),heltab2x2(:,:,64))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(25),n2h1(141))
  call Hloop_AW_Q(ntryL,G1H3(32),ex5(:),G1H1(1),m3h3x1(:,71),heltab2x3(:,:,71))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(31),n2h1(142))
  call Hloop_AW_Q(ntryL,G1H3(38),ex5(:),G1H1(1),m3h3x1(:,72),heltab2x3(:,:,72))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(37),n2h1(143))
  call Hloop_VA_Q(ntryL,G1H2(25),ex4(:),G1H1(1),m3h2x1(:,65),heltab2x2(:,:,65))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(43),n2h1(144))
  call Hloop_VA_Q(ntryL,G1H2(22),ex4(:),G1H1(1),m3h2x1(:,66),heltab2x2(:,:,66))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(46),n2h1(145))
  call Hloop_AW_Q(ntryL,G1H3(50),ex5(:),G1H1(1),m3h3x1(:,73),heltab2x3(:,:,73))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(49),n2h1(146))
  call Hloop_AW_Q(ntryL,G1H3(56),ex5(:),G1H1(1),m3h3x1(:,74),heltab2x3(:,:,74))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(13),n2h1(147))
  call Hloop_VQ_A(ntryL,G1H2(27),ex1(:),G1H1(1),m3h2x1(:,67),heltab2x2(:,:,67))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(52),n2h1(148))
  call Hloop_VQ_A(ntryL,G1H2(28),ex1(:),G1H1(1),m3h2x1(:,68),heltab2x2(:,:,68))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(55),n2h1(149))
  call Hloop_QW_A(ntryL,G1H3(62),ex5(:),G1H1(1),m3h3x1(:,75),heltab2x3(:,:,75))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(58),n2h1(150))
  call Hloop_QW_A(ntryL,G1H3(68),ex5(:),G1H1(1),m3h3x1(:,76),heltab2x3(:,:,76))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(16),n2h1(151))
  call Hloop_VQ_A(ntryL,G1H2(33),ex1(:),G1H1(1),m3h2x1(:,69),heltab2x2(:,:,69))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(61),n2h1(152))
  call Hloop_VQ_A(ntryL,G1H2(34),ex1(:),G1H1(1),m3h2x1(:,70),heltab2x2(:,:,70))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(64),n2h1(153))
  call Hloop_QW_A(ntryL,G1H3(80),ex5(:),G1H1(1),m3h3x1(:,77),heltab2x3(:,:,77))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(67),n2h1(154))
  call Hloop_QW_A(ntryL,G1H3(86),ex5(:),G1H1(1),m3h3x1(:,78),heltab2x3(:,:,78))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(22),n2h1(155))
  call Hotf_4pt_reduction(G2H2(13),RedSet_4(1),mass4set(:,21),  & 
G1H2(3),G1H2(4),G1H2(11),G1H2(20),G1H2(24),2)
  call HG1shiftOLR(G1H2(4),4,2)
  call Hloop_VQ_A(ntryL,G1H2(51),ex3(:),G1H1(1),m3h2x1(:,71),heltab2x2(:,:,71))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(70),n2h1(156))
  call Hotf_4pt_reduction(G2H2(2),RedSet_4(6),mass4set(:,21),  & 
G1H2(30),G1H2(31),G1H2(32),G1H2(36),G1H2(37),2)
  call HG1shiftOLR(G1H2(31),4,2)
  call Hloop_VQ_A(ntryL,G1H2(63),ex3(:),G1H1(1),m3h2x1(:,72),heltab2x2(:,:,72))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(73),n2h1(157))
  call Hloop_VQ_A(ntryL,G1H2(69),ex3(:),G1H1(1),m3h2x1(:,73),heltab2x2(:,:,73))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(28),n2h1(158))
  call Hloop_VQ_A(ntryL,G1H2(70),ex3(:),G1H1(1),m3h2x1(:,74),heltab2x2(:,:,74))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(76),n2h1(159))
  call Hotf_4pt_reduction(G2H3(2),RedSet_4(31),mass4set(:,22),  & 
G1H3(136),G1H3(8),G1H3(13),G1H3(6),G1H3(12),3)
  call HG1shiftOLR(G1H3(8),16,3)
  call Hotf_4pt_reduction(G2H3(4),RedSet_4(35),mass4set(:,4),  & 
G1H3(18),G1H3(11),G1H3(23),G1H3(17),G1H3(21),3)
  call HG1shiftOLR(G1H3(11),16,3)
  call Hotf_4pt_reduction(G2H3(16),RedSet_4(45),mass4set(:,23),  & 
G1H3(28),G1H3(29),G1H3(33),G1H3(35),G1H3(39),3)
  call HG1shiftOLR(G1H3(29),16,3)
  call Hotf_4pt_reduction(G2H3(6),RedSet_4(56),mass4set(:,24),  & 
G1H3(40),G1H3(88),G1H3(46),G1H3(47),G1H3(52),3)
  call HG1shiftOLR(G1H3(88),16,3)
  call Hotf_4pt_reduction(G2H3(8),RedSet_4(60),mass4set(:,6),  & 
G1H3(53),G1H3(57),G1H3(59),G1H3(63),G1H3(64),3)
  call HG1shiftOLR(G1H3(57),16,3)
  call Hotf_4pt_reduction(G2H3(10),RedSet_4(69),mass4set(:,25),  & 
G1H3(69),G1H3(70),G1H3(71),G1H3(76),G1H3(77),3)
  call HG1shiftOLR(G1H3(70),16,3)
  call Hloop_VQ_A(ntryL,G1H6(39),wf6(:,7),G1H1(1),m3h6x1(:,13),heltab2x6(:,:,80))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(79),n2h1(160))
  call Hloop_VQ_A(ntryL,G1H6(24),wf6(:,7),G1H1(1),m3h6x1(:,14),heltab2x6(:,:,81))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(82),n2h1(161))
  call Hotf_4pt_reduction(G2H6(8),RedSet_4(65),mass4set(:,3),  & 
G1H6(16),G1H6(3),G1H6(11),G1H6(37),G1H6(41),6)
  call HG1shiftOLR(G1H6(3),17,6)
  call Hloop_VQ_A(ntryL,G1H6(19),wf6(:,7),G1H1(1),m3h6x1(:,15),heltab2x6(:,:,82))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(34),n2h1(162))
  call Hloop_VQ_A(ntryL,G1H6(23),wf6(:,7),G1H1(1),m3h6x1(:,16),heltab2x6(:,:,83))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(85),n2h1(163))
  call Hloop_VA_Q(ntryL,G1H6(21),wf6(:,4),G1H1(1),m3h6x1(:,17),heltab2x6(:,:,84))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(88),n2h1(164))
  call Hloop_VA_Q(ntryL,G1H6(26),wf6(:,4),G1H1(1),m3h6x1(:,18),heltab2x6(:,:,85))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(40),n2h1(165))
  call Hotf_4pt_reduction(G2H6(3),RedSet_4(40),mass4set(:,2),  & 
G1H6(42),G1H6(13),G1H6(27),G1H6(33),G1H6(40),6)
  call HG1shiftOLR(G1H6(13),24,6)
  call Hloop_VA_Q(ntryL,G1H6(1),wf6(:,4),G1H1(1),m3h6x1(:,19),heltab2x6(:,:,86))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(9),n2h1(166))
  call Hloop_VA_Q(ntryL,G1H6(32),wf6(:,4),G1H1(1),m3h6x1(:,20),heltab2x6(:,:,87))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(91),n2h1(167))
  call Hloop_VA_Q(ntryL,G1H2(75),ex2(:),G1H1(1),m3h2x1(:,75),heltab2x2(:,:,75))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(94),n2h1(168))
  call Hloop_VA_Q(ntryL,G1H2(76),ex2(:),G1H1(1),m3h2x1(:,76),heltab2x2(:,:,76))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(97),n2h1(169))
  call Hloop_VA_Q(ntryL,G1H2(14),ex2(:),G1H1(1),m3h2x1(:,77),heltab2x2(:,:,77))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(100),n2h1(170))
  call Hloop_VA_Q(ntryL,G1H2(81),ex2(:),G1H1(1),m3h2x1(:,78),heltab2x2(:,:,78))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(103),n2h1(171))
  call Hloop_VA_Q(ntryL,G1H2(82),ex2(:),G1H1(1),m3h2x1(:,79),heltab2x2(:,:,79))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(106),n2h1(172))
  call Hotf_4pt_reduction(G2H2(8),RedSet_4(112),mass4set(:,15),  & 
G1H2(38),G1H2(47),G1H2(1),G1H2(23),G1H2(17),2)
  call HG1shiftOLR(G1H2(47),2,2)
  call Hloop_VA_Q(ntryL,G1H2(87),ex2(:),G1H1(1),m3h2x1(:,80),heltab2x2(:,:,80))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(109),n2h1(173))
  call Hloop_VA_Q(ntryL,G1H2(88),ex2(:),G1H1(1),m3h2x1(:,81),heltab2x2(:,:,81))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(115),n2h1(174))
  call Hloop_VQ_A(ntryL,G1H2(93),ex3(:),G1H1(1),m3h2x1(:,82),heltab2x2(:,:,82))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(119),n2h1(175))
  call Hloop_VQ_A(ntryL,G1H2(94),ex3(:),G1H1(1),m3h2x1(:,83),heltab2x2(:,:,83))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(123),n2h1(176))
  call Hloop_VQ_A(ntryL,G1H2(95),ex3(:),G1H1(1),m3h2x1(:,84),heltab2x2(:,:,84))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(127),n2h1(177))
  call Hloop_AW_Q(ntryL,G1H3(90),ex5(:),G1H1(1),m3h3x1(:,79),heltab2x3(:,:,79))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(131),n2h1(178))
  call Hloop_AW_Q(ntryL,G1H3(118),ex5(:),G1H1(1),m3h3x1(:,80),heltab2x3(:,:,80))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(135),n2h1(179))
  call Hloop_AW_Q(ntryL,G1H3(108),ex5(:),G1H1(1),m3h3x1(:,81),heltab2x3(:,:,81))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(136),n2h1(180))
  call Hloop_QW_A(ntryL,G1H3(95),ex5(:),G1H1(1),m3h3x1(:,82),heltab2x3(:,:,82))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(137),n2h1(181))
  call Hloop_QW_A(ntryL,G1H3(129),ex5(:),G1H1(1),m3h3x1(:,83),heltab2x3(:,:,83))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(138),n2h1(182))
  call Hloop_QW_A(ntryL,G1H3(141),ex5(:),G1H1(1),m3h3x1(:,84),heltab2x3(:,:,84))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(139),n2h1(183))
  call Hotf_4pt_reduction(G2H3(1),RedSet_4(119),mass4set(:,26),  & 
G1H3(81),G1H3(1),G1H3(122),G1H3(30),G1H3(36),3)
  call HG1shiftOLR(G1H3(1),16,3)
  call Hotf_4pt_reduction(G2H3(11),RedSet_4(120),mass4set(:,10),  & 
G1H3(102),G1H3(44),G1H3(4),G1H3(20),G1H3(135),3)
  call HG1shiftOLR(G1H3(44),16,3)
  call Hloop_AW_Q(ntryL,G1H3(106),ex5(:),G1H1(1),m3h3x1(:,85),heltab2x3(:,:,85))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(140),n2h1(184))
  call Hloop_AW_Q(ntryL,G2H3(15),ex5(:),G2H1(1),m3h3x1(:,86),heltab2x3(:,:,86))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),63,nMT,G3tensor(1),n2h1(185))
  call Hotf_4pt_reduction(G2H3(3),RedSet_4(122),mass4set(:,4),  & 
G1H3(74),G1H3(26),G1H3(16),G1H3(113),G1H3(124),3)
  call HG1shiftOLR(G1H3(26),16,3)
  call Hloop_AW_Q(ntryL,G1H3(117),ex5(:),G1H1(1),m3h3x1(:,87),heltab2x3(:,:,87))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(141),n2h1(186))
  call Hloop_AW_Q(ntryL,G2H3(44),ex5(:),G2H1(1),m3h3x1(:,88),heltab2x3(:,:,88))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),63,nMT,G3tensor(2),n2h1(187))
  call Hotf_4pt_reduction(G2H4(9),RedSet_4(4),mass4set(:,27),  & 
G1H4(22),G1H4(23),G1H4(24),G1H4(25),G1H4(26),4)
  call HG1shiftOLR(G1H4(23),12,4)
  call Hotf_4pt_reduction(G2H4(15),RedSet_4(8),mass4set(:,1),  & 
G1H4(27),G1H4(28),G1H4(29),G1H4(30),G1H4(31),4)
  call HG1shiftOLR(G1H4(28),12,4)
  call Hloop_QV_A(ntryL,G1H4(9),wf4(:,2),G1H1(1),m3h4x1(:,5),heltab2x4(:,:,34))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(142),n2h1(188))
  call Hloop_QV_A(ntryL,G2H4(5),wf4(:,2),G2H1(1),m3h4x1(:,6),heltab2x4(:,:,35))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),63,nMB,G3tensor(3),n2h1(189))
  call Hloop_QV_A(ntryL,G1H4(11),wf4(:,2),G1H1(1),m3h4x1(:,7),heltab2x4(:,:,36))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(143),n2h1(190))
  call Hloop_QW_A(ntryL,G1H3(128),ex5(:),G1H1(1),m3h3x1(:,89),heltab2x3(:,:,89))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(144),n2h1(191))
  call Hloop_QW_A(ntryL,G2H3(32),ex5(:),G2H1(1),m3h3x1(:,90),heltab2x3(:,:,90))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),63,nMB,G3tensor(4),n2h1(192))
  call Hotf_4pt_reduction(G2H3(5),RedSet_4(127),mass4set(:,28),  & 
G1H3(60),G1H3(66),G1H3(14),G1H3(19),G1H3(24),3)
  call HG1shiftOLR(G1H3(66),16,3)
  call Hotf_4pt_reduction(G2H3(19),RedSet_4(123),mass4set(:,11),  & 
G1H3(3),G1H3(10),G1H3(15),G1H3(22),G1H3(25),3)
  call HG1shiftOLR(G1H3(10),16,3)
  call Hloop_QW_A(ntryL,G1H3(139),ex5(:),G1H1(1),m3h3x1(:,91),heltab2x3(:,:,91))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(145),n2h1(193))
  call Hloop_QW_A(ntryL,G2H3(22),ex5(:),G2H1(1),m3h3x1(:,92),heltab2x3(:,:,92))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),63,nMB,G3tensor(5),n2h1(194))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(4),ex1(:),G2tensor(146),m3h2x1(:,85),heltab2x2(:,:,85))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(15),ex1(:),G2tensor(147),m3h2x1(:,86),heltab2x2(:,:,86))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(16),ex4(:),G2tensor(148),m3h2x1(:,87),heltab2x2(:,:,87))
  call Hotf_4pt_reduction(G2H6(7),RedSet_4(79),mass4set(:,5),  & 
G1H6(18),G1H6(17),G1H6(28),G1H6(34),G1H6(14),6)
  call HG1shiftOLR(G1H6(17),24,6)
  call Hotf_4pt_reduction(G2H2(6),RedSet_4(133),mass4set(:,17),  & 
G1H2(29),G1H2(35),G1H2(41),G1H2(8),G1H2(71),2)
  call HG1shiftOLR(G1H2(35),4,2)
  call Hotf_4pt_reduction(G2H6(5),RedSet_4(80),mass4set(:,7),  & 
G1H6(8),G1H6(9),G1H6(4),G1H6(10),G1H6(22),6)
  call HG1shiftOLR(G1H6(9),17,6)



end subroutine vamp_1

end module ol_vamp_1_ppwwtt_ttxbbxwwx_1_/**/REALKIND
