
module ol_vamp_14_ppwwtt_ttxwwxgg_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_14(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppwwtt_ttxwwxgg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppwwtt_ttxwwxgg_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_ppwwtt_ttxwwxgg_1_/**/DREALKIND
  use ol_tensor_sum_storage_ppwwtt_ttxwwxgg_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_ppwwtt_ttxwwxgg_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_ppwwtt_ttxwwxgg_1_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL, hel_states
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(hel_states)
  type(Hpolcont), intent(in) :: M(3,hel_states)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel(1:hel_states)
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel(1:hel_states)
#endif

  ! =============================================
  call Hloop_VQ_A(ntryL,G0H144(1),wf24(:,16),G0H6(28),m3h24x6(:,29),heltab2x144(:,:,937))
  call Hloop_Q_A(ntryL,G0H6(28),53,nMB,G1H6(268),n2h6(522))
  Gcoeff(:)%j = (c(21)*M(2,:)%j) * den(371)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(1037),h0tab(:,1037),[46,17],[nMT,0],2,2,wf36(:,45),wf4(:,7))
  call Hloop_VA_Q(ntryL,G0H144(1),wf36(:,45),G0H4(12),m3h36x4(:,39),heltab2x144(:,:,938))
  call Hloop_A_Q(ntryL,G0H4(12),46,nMT,G1H4(92),n2h4(300))
  Gcoeff(:)%j = (c(21)*M(2,:)%j) * den(372)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(1038),h0tab(:,1038),[46,17],[nMT,0],2,2,wf36(:,49),wf4(:,7))
  call Hloop_VA_Q(ntryL,G0H144(1),wf36(:,49),G0H4(11),m3h36x4(:,40),heltab2x144(:,:,939))
  call Hloop_A_Q(ntryL,G0H4(11),46,nMT,G1H4(93),n2h4(301))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(199)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(1039),h0tab(:,1039),[37,26],[0,nMB],2,2,wf12(:,14),wf12(:,6))
  call Hloop_AQ_V(ntryL,G0H144(1),wf12(:,14),G0H12(18),m3h12x12(:,30),heltab2x144(:,:,940))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(373)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(1040),h0tab(:,1040),[53,10],[nMB,0],2,2,wf24(:,22),wf6(:,4))
  call Hloop_VQ_A(ntryL,G0H144(1),wf24(:,22),G0H6(29),m3h24x6(:,30),heltab2x144(:,:,941))
  call Hloop_Q_A(ntryL,G0H6(29),53,nMB,G1H6(269),n2h6(523))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(200)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(1041),h0tab(:,1041),[49,14],[nMT,0],2,2,wf8(:,26),wf18(:,4))
  call Hloop_VQ_A(ntryL,G0H144(1),wf8(:,26),G0H18(1),m3h8x18(:,131),heltab2x144(:,:,942))
  call Hloop_Q_A(ntryL,G0H18(1),49,nMT,G1H18(27),n2h18(403))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(374)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(1042),h0tab(:,1042),[53,10],[nMB,0],2,2,wf24(:,24),wf6(:,4))
  call Hloop_VQ_A(ntryL,G0H144(1),wf24(:,24),G0H6(30),m3h24x6(:,31),heltab2x144(:,:,943))
  call Hloop_Q_A(ntryL,G0H6(30),53,nMB,G1H6(301),n2h6(524))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(375)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(1043),h0tab(:,1043),[33,30],[0,nMT],2,2,wf4(:,9),wf36(:,43))
  call Hloop_AQ_V(ntryL,G0H144(1),wf4(:,9),G0H36(28),m3h4x36(:,144),heltab2x144(:,:,944))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(376)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(1044),h0tab(:,1044),[33,30],[0,nMT],2,2,wf4(:,9),wf36(:,47))
  call Hloop_AQ_V(ntryL,G0H144(1),wf4(:,9),G0H36(29),m3h4x36(:,145),heltab2x144(:,:,945))
  Gcoeff(:)%j = (c(16)*(-M(1,:)%j+M(2,:)%j)) * den(377)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(1045),h0tab(:,1045),[53,10],[nMB,0],2,2,wf24(:,30),wf6(:,4))
  call Hloop_VQ_A(ntryL,G0H144(1),wf24(:,30),G0H6(31),m3h24x6(:,32),heltab2x144(:,:,946))
  call Hloop_Q_A(ntryL,G0H6(31),53,nMB,G1H6(424),n2h6(525))
  Gcoeff(:)%j = (c(55)*(M(1,:)%j-M(2,:)%j)) * den(378)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(1046),h0tab(:,1046),[48,15],[0,0],2,2,wf4(:,1),wf36(:,41))
  call Hloop_QV_A(ntryL,G0H144(1),wf4(:,1),G0H36(27),m3h4x36(:,146),heltab2x144(:,:,947))
  call Hloop_Q_A(ntryL,G0H36(27),48,0,G1H36(95),n2h36(206))
  Gcoeff(:)%j = (c(54)*(M(1,:)%j-M(2,:)%j)) * den(378)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(1047),h0tab(:,1047),[48,15],[nMT,nMT],2,2,wf4(:,1),wf36(:,41))
  call Hloop_QV_A(ntryL,G0H144(1),wf4(:,1),G0H36(33),m3h4x36(:,147),heltab2x144(:,:,948))
  call Hloop_Q_A(ntryL,G0H36(33),48,nMT,G1H36(4),n2h36(207))
  Gcoeff(:)%j = (c(55)*(M(1,:)%j-M(2,:)%j)) * den(378)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(1048),h0tab(:,1048),[48,15],[0,0],2,2,wf4(:,1),wf36(:,41))
  call Hloop_QV_A(ntryL,G0H144(1),wf4(:,1),G0H36(34),m3h4x36(:,148),heltab2x144(:,:,949))
  call Hloop_Q_A(ntryL,G0H36(34),48,0,G1H36(56),n2h36(208))
  Gcoeff(:)%j = (c(54)*(M(1,:)%j-M(2,:)%j)) * den(378)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(1049),h0tab(:,1049),[48,15],[nMB,nMB],2,2,wf4(:,1),wf36(:,41))
  call Hloop_QV_A(ntryL,G0H144(1),wf4(:,1),G0H36(35),m3h4x36(:,149),heltab2x144(:,:,950))
  call Hloop_Q_A(ntryL,G0H36(35),48,nMB,G1H36(53),n2h36(209))
  Gcoeff(:)%j = (c(18)*(M(1,:)%j-M(2,:)%j)) * den(378)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(1050),h0tab(:,1050),[48,15],[0,0],2,2,wf4(:,1),wf36(:,41))
  call Hloop_CV_D(ntryL,G0H144(1),0,wf4(:,1),48,G1H36(48),m3h4x36(:,150),heltab2x144(:,:,951))
  Gcoeff(:)%j = (c(13)*(-M(1,:)%j+M(2,:)%j)) * den(378)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(1051),h0tab(:,1051),[48,15],[0,0],2,2,wf4(:,1),wf36(:,41))
  call Hloop_UV_W(ntryL,G0H144(1),0,wf4(:,1),48,G1H36(43),m3h4x36(:,151),heltab2x144(:,:,952))
  Gcoeff(:)%j = (c(16)*(-M(1,:)%j+M(2,:)%j)) * den(201)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(1052),h0tab(:,1052),[49,14],[0,nMT],2,2,wf8(:,8),wf18(:,4))
  call Hloop_AQ_V(ntryL,G0H144(1),wf8(:,8),G0H18(4),m3h8x18(:,132),heltab2x144(:,:,953))
  Gcoeff(:)%j = (-(c(32)*M(2,:)%j)) * den(217)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(1053),h0tab(:,1053),[34,29],[0,nMT],2,2,wf4(:,5),wf36(:,15))
  call Hloop_QA_V(ntryL,G0H144(1),wf4(:,5),G0H36(24),m3h4x36(:,152),heltab2x144(:,:,954))
  Gcoeff(:)%j = (c(10)*M(2,:)%j) * den(220)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(1054),h0tab(:,1054),[34,29],[0,nMT],2,2,wf4(:,5),wf36(:,17))
  call Hloop_QA_V(ntryL,G0H144(1),wf4(:,5),G0H36(27),m3h4x36(:,153),heltab2x144(:,:,955))
  Gcoeff(:)%j = (c(43)*M(2,:)%j) * den(223)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(1055),h0tab(:,1055),[34,29],[0,nMT],2,2,wf4(:,5),wf36(:,19))
  call Hloop_QA_V(ntryL,G0H144(1),wf4(:,5),G0H36(33),m3h4x36(:,154),heltab2x144(:,:,956))
  Gcoeff(:)%j = (-(c(32)*M(2,:)%j)) * den(207)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(1056),h0tab(:,1056),[46,17],[nMT,0],2,2,wf36(:,9),wf4(:,7))
  call Hloop_VA_Q(ntryL,G0H144(1),wf36(:,9),G0H4(7),m3h36x4(:,41),heltab2x144(:,:,957))
  call Hloop_A_Q(ntryL,G0H4(7),46,nMT,G1H4(94),n2h4(302))
  Gcoeff(:)%j = (c(10)*M(2,:)%j) * den(210)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(1057),h0tab(:,1057),[46,17],[nMT,0],2,2,wf36(:,11),wf4(:,7))
  call Hloop_VA_Q(ntryL,G0H144(1),wf36(:,11),G0H4(6),m3h36x4(:,42),heltab2x144(:,:,958))
  call Hloop_A_Q(ntryL,G0H4(6),46,nMT,G1H4(97),n2h4(303))
  Gcoeff(:)%j = (c(43)*M(2,:)%j) * den(213)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(1058),h0tab(:,1058),[46,17],[nMT,0],2,2,wf36(:,13),wf4(:,7))
  call Hloop_VA_Q(ntryL,G0H144(1),wf36(:,13),G0H4(5),m3h36x4(:,43),heltab2x144(:,:,959))
  call Hloop_A_Q(ntryL,G0H4(5),46,nMT,G1H4(98),n2h4(304))
  Gcoeff(:)%j = (-(c(32)*M(2,:)%j)) * den(227)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(1059),h0tab(:,1059),[49,14],[nMT,0],2,2,wf8(:,25),wf18(:,6))
  call Hloop_VQ_A(ntryL,G0H144(1),wf8(:,25),G0H18(2),m3h8x18(:,133),heltab2x144(:,:,960))
  call Hloop_Q_A(ntryL,G0H18(2),49,nMT,G1H18(32),n2h18(404))
  Gcoeff(:)%j = (c(10)*M(2,:)%j) * den(228)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(1060),h0tab(:,1060),[49,14],[nMT,0],2,2,wf8(:,25),wf18(:,8))
  call Hloop_VQ_A(ntryL,G0H144(1),wf8(:,25),G0H18(5),m3h8x18(:,134),heltab2x144(:,:,961))
  call Hloop_Q_A(ntryL,G0H18(5),49,nMT,G1H18(33),n2h18(405))
  Gcoeff(:)%j = (c(43)*M(2,:)%j) * den(229)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(1061),h0tab(:,1061),[49,14],[nMT,0],2,2,wf8(:,25),wf18(:,10))
  call Hloop_VQ_A(ntryL,G0H144(1),wf8(:,25),G0H18(6),m3h8x18(:,135),heltab2x144(:,:,962))
  call Hloop_Q_A(ntryL,G0H18(6),49,nMT,G1H18(46),n2h18(406))
  Gcoeff(:)%j = (-(c(32)*M(2,:)%j)) * den(379)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(1062),h0tab(:,1062),[46,17],[nMT,0],2,2,wf36(:,75),wf4(:,7))
  call Hloop_VA_Q(ntryL,G0H144(1),wf36(:,75),G0H4(2),m3h36x4(:,44),heltab2x144(:,:,963))
  call Hloop_A_Q(ntryL,G0H4(2),46,nMT,G1H4(99),n2h4(305))
  Gcoeff(:)%j = (c(10)*M(2,:)%j) * den(380)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(1063),h0tab(:,1063),[46,17],[nMT,0],2,2,wf36(:,77),wf4(:,7))
  call Hloop_VA_Q(ntryL,G0H144(1),wf36(:,77),G0H4(1),m3h36x4(:,45),heltab2x144(:,:,964))
  call Hloop_A_Q(ntryL,G0H4(1),46,nMT,G1H4(102),n2h4(306))
  Gcoeff(:)%j = (c(43)*M(2,:)%j) * den(381)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(1064),h0tab(:,1064),[46,17],[nMT,0],2,2,wf36(:,79),wf4(:,7))
  call Hloop_VA_Q(ntryL,G0H144(1),wf36(:,79),G0H4(16),m3h36x4(:,46),heltab2x144(:,:,965))
  call Hloop_A_Q(ntryL,G0H4(16),46,nMT,G1H4(103),n2h4(307))
  Gcoeff(:)%j = (-(c(32)*M(1,:)%j)) * den(243)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(1065),h0tab(:,1065),[45,18],[nMT,0],2,2,wf36(:,27),wf4(:,3))
  call Hloop_VQ_A(ntryL,G0H144(1),wf36(:,27),G0H4(15),m3h36x4(:,47),heltab2x144(:,:,966))
  call Hloop_Q_A(ntryL,G0H4(15),45,nMT,G1H4(104),n2h4(308))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(246)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(1066),h0tab(:,1066),[45,18],[nMT,0],2,2,wf36(:,29),wf4(:,3))
  call Hloop_VQ_A(ntryL,G0H144(1),wf36(:,29),G0H4(14),m3h36x4(:,48),heltab2x144(:,:,967))
  call Hloop_Q_A(ntryL,G0H4(14),45,nMT,G1H4(107),n2h4(309))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(249)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(1067),h0tab(:,1067),[45,18],[nMT,0],2,2,wf36(:,31),wf4(:,3))
  call Hloop_VQ_A(ntryL,G0H144(1),wf36(:,31),G0H4(10),m3h36x4(:,49),heltab2x144(:,:,968))
  call Hloop_Q_A(ntryL,G0H4(10),45,nMT,G1H4(30),n2h4(310))
  Gcoeff(:)%j = (-(c(32)*M(1,:)%j)) * den(233)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(1068),h0tab(:,1068),[33,30],[0,nMT],2,2,wf4(:,9),wf36(:,21))
  call Hloop_AQ_V(ntryL,G0H144(1),wf4(:,9),G0H36(34),m3h4x36(:,155),heltab2x144(:,:,969))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(236)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(1069),h0tab(:,1069),[33,30],[0,nMT],2,2,wf4(:,9),wf36(:,23))
  call Hloop_AQ_V(ntryL,G0H144(1),wf4(:,9),G0H36(35),m3h4x36(:,156),heltab2x144(:,:,970))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(239)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(1070),h0tab(:,1070),[33,30],[0,nMT],2,2,wf4(:,9),wf36(:,25))
  call Hloop_AQ_V(ntryL,G0H144(1),wf4(:,9),G0H36(37),m3h4x36(:,157),heltab2x144(:,:,971))
  Gcoeff(:)%j = (-(c(32)*M(1,:)%j)) * den(382)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(1071),h0tab(:,1071),[45,18],[nMT,0],2,2,wf36(:,63),wf4(:,3))
  call Hloop_VQ_A(ntryL,G0H144(1),wf36(:,63),G0H4(9),m3h36x4(:,50),heltab2x144(:,:,972))
  call Hloop_Q_A(ntryL,G0H4(9),45,nMT,G1H4(36),n2h4(311))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(383)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(1072),h0tab(:,1072),[45,18],[nMT,0],2,2,wf36(:,65),wf4(:,3))
  call Hloop_VQ_A(ntryL,G0H144(1),wf36(:,65),G0H4(8),m3h36x4(:,51),heltab2x144(:,:,973))
  call Hloop_Q_A(ntryL,G0H4(8),45,nMT,G1H4(109),n2h4(312))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(384)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(1073),h0tab(:,1073),[45,18],[nMT,0],2,2,wf36(:,67),wf4(:,3))
  call Hloop_VQ_A(ntryL,G0H144(1),wf36(:,67),G0H4(4),m3h36x4(:,52),heltab2x144(:,:,974))
  call Hloop_Q_A(ntryL,G0H4(4),45,nMT,G1H4(14),n2h4(313))
  Gcoeff(:)%j = (-(c(32)*M(1,:)%j)) * den(250)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(1074),h0tab(:,1074),[50,13],[nMT,0],2,2,wf8(:,19),wf18(:,12))
  call Hloop_VA_Q(ntryL,G0H144(1),wf8(:,19),G0H18(7),m3h8x18(:,136),heltab2x144(:,:,975))
  call Hloop_A_Q(ntryL,G0H18(7),50,nMT,G1H18(165),n2h18(407))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(251)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(1075),h0tab(:,1075),[50,13],[nMT,0],2,2,wf8(:,19),wf18(:,14))
  call Hloop_VA_Q(ntryL,G0H144(1),wf8(:,19),G0H18(8),m3h8x18(:,137),heltab2x144(:,:,976))
  call Hloop_A_Q(ntryL,G0H18(8),50,nMT,G1H18(166),n2h18(408))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(252)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(1076),h0tab(:,1076),[50,13],[nMT,0],2,2,wf8(:,19),wf18(:,16))
  call Hloop_VA_Q(ntryL,G0H144(1),wf8(:,19),G0H18(9),m3h8x18(:,138),heltab2x144(:,:,977))
  call Hloop_A_Q(ntryL,G0H18(9),50,nMT,G1H18(168),n2h18(409))
  Gcoeff(:)%j = (-(c(32)*M(1,:)%j)) * den(259)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(1077),h0tab(:,1077),[49,14],[nMT,0],2,2,wf8(:,26),wf18(:,6))
  call Hloop_VQ_A(ntryL,G0H144(1),wf8(:,26),G0H18(10),m3h8x18(:,139),heltab2x144(:,:,978))
  call Hloop_Q_A(ntryL,G0H18(10),49,nMT,G1H18(169),n2h18(410))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(260)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(1078),h0tab(:,1078),[49,14],[nMT,0],2,2,wf8(:,26),wf18(:,8))
  call Hloop_VQ_A(ntryL,G0H144(1),wf8(:,26),G0H18(11),m3h8x18(:,140),heltab2x144(:,:,979))
  call Hloop_Q_A(ntryL,G0H18(11),49,nMT,G1H18(51),n2h18(411))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(261)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(1079),h0tab(:,1079),[49,14],[nMT,0],2,2,wf8(:,26),wf18(:,10))
  call Hloop_VQ_A(ntryL,G0H144(1),wf8(:,26),G0H18(12),m3h8x18(:,141),heltab2x144(:,:,980))
  call Hloop_Q_A(ntryL,G0H18(12),49,nMT,G1H18(134),n2h18(412))
  Gcoeff(:)%j = (-(c(32)*M(1,:)%j)) * den(385)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(1080),h0tab(:,1080),[33,30],[0,nMT],2,2,wf4(:,9),wf36(:,69))
  call Hloop_AQ_V(ntryL,G0H144(1),wf4(:,9),G0H36(38),m3h4x36(:,158),heltab2x144(:,:,981))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(386)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(1081),h0tab(:,1081),[33,30],[0,nMT],2,2,wf4(:,9),wf36(:,71))
  call Hloop_AQ_V(ntryL,G0H144(1),wf4(:,9),G0H36(39),m3h4x36(:,159),heltab2x144(:,:,982))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(387)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(1082),h0tab(:,1082),[33,30],[0,nMT],2,2,wf4(:,9),wf36(:,73))
  call Hloop_AQ_V(ntryL,G0H144(1),wf4(:,9),G0H36(40),m3h4x36(:,160),heltab2x144(:,:,983))
  Gcoeff(:)%j = (-(c(32)*M(2,:)%j)) * den(388)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(1083),h0tab(:,1083),[34,29],[0,nMT],2,2,wf4(:,5),wf36(:,57))
  call Hloop_QA_V(ntryL,G0H144(1),wf4(:,5),G0H36(41),m3h4x36(:,161),heltab2x144(:,:,984))
  Gcoeff(:)%j = (c(10)*M(2,:)%j) * den(389)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(1084),h0tab(:,1084),[34,29],[0,nMT],2,2,wf4(:,5),wf36(:,59))
  call Hloop_QA_V(ntryL,G0H144(1),wf4(:,5),G0H36(42),m3h4x36(:,162),heltab2x144(:,:,985))
  Gcoeff(:)%j = (c(43)*M(2,:)%j) * den(390)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(1085),h0tab(:,1085),[34,29],[0,nMT],2,2,wf4(:,5),wf36(:,61))
  call Hloop_QA_V(ntryL,G0H144(1),wf4(:,5),G0H36(43),m3h4x36(:,163),heltab2x144(:,:,986))
  Gcoeff(:)%j = (-(c(32)*M(2,:)%j)) * den(262)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(1086),h0tab(:,1086),[50,13],[nMT,0],2,2,wf8(:,20),wf18(:,12))
  call Hloop_VA_Q(ntryL,G0H144(1),wf8(:,20),G0H18(22),m3h8x18(:,142),heltab2x144(:,:,987))
  call Hloop_A_Q(ntryL,G0H18(22),50,nMT,G1H18(135),n2h18(413))
  Gcoeff(:)%j = (c(10)*M(2,:)%j) * den(263)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(1087),h0tab(:,1087),[50,13],[nMT,0],2,2,wf8(:,20),wf18(:,14))
  call Hloop_VA_Q(ntryL,G0H144(1),wf8(:,20),G0H18(21),m3h8x18(:,143),heltab2x144(:,:,988))
  call Hloop_A_Q(ntryL,G0H18(21),50,nMT,G1H18(141),n2h18(414))
  Gcoeff(:)%j = (c(43)*M(2,:)%j) * den(264)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(1088),h0tab(:,1088),[50,13],[nMT,0],2,2,wf8(:,20),wf18(:,16))
  call Hloop_VA_Q(ntryL,G0H144(1),wf8(:,20),G0H18(17),m3h8x18(:,144),heltab2x144(:,:,989))
  call Hloop_A_Q(ntryL,G0H18(17),50,nMT,G1H18(148),n2h18(415))
  Gcoeff(:)%j = (c(64)*(-M(1,:)%j+M(2,:)%j)) * den(391)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(1089),h0tab(:,1089),[48,15],[0,0],2,2,wf4(:,1),wf36(:,50))
  call Hloop_QV_A(ntryL,G0H144(1),wf4(:,1),G0H36(44),m3h4x36(:,164),heltab2x144(:,:,990))
  call Hloop_Q_A(ntryL,G0H36(44),48,0,G1H36(7),n2h36(210))
  Gcoeff(:)%j = (c(63)*(-M(1,:)%j+M(2,:)%j)) * den(391)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(1090),h0tab(:,1090),[48,15],[nMT,nMT],2,2,wf4(:,1),wf36(:,50))
  call Hloop_QV_A(ntryL,G0H144(1),wf4(:,1),G0H36(44),m3h4x36(:,165),heltab2x144(:,:,991))
  call Hloop_Q_A(ntryL,G0H36(44),48,nMT,G1H36(79),n2h36(211))
  Gcoeff(:)%j = (c(64)*(-M(1,:)%j+M(2,:)%j)) * den(391)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(1091),h0tab(:,1091),[48,15],[0,0],2,2,wf4(:,1),wf36(:,50))
  call Hloop_QV_A(ntryL,G0H144(1),wf4(:,1),G0H36(44),m3h4x36(:,166),heltab2x144(:,:,992))
  call Hloop_Q_A(ntryL,G0H36(44),48,0,G1H36(91),n2h36(212))
  Gcoeff(:)%j = (c(63)*(-M(1,:)%j+M(2,:)%j)) * den(391)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(1092),h0tab(:,1092),[48,15],[nMB,nMB],2,2,wf4(:,1),wf36(:,50))
  call Hloop_QV_A(ntryL,G0H144(1),wf4(:,1),G0H36(44),m3h4x36(:,167),heltab2x144(:,:,993))
  call Hloop_Q_A(ntryL,G0H36(44),48,nMB,G1H36(108),n2h36(213))
  Gcoeff(:)%j = (c(29)*(-M(1,:)%j+M(2,:)%j)) * den(391)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(1093),h0tab(:,1093),[48,15],[0,0],2,2,wf4(:,1),wf36(:,50))
  call Hloop_CV_D(ntryL,G0H144(1),0,wf4(:,1),48,G1H36(10),m3h4x36(:,168),heltab2x144(:,:,994))
  Gcoeff(:)%j = (c(24)*(M(1,:)%j-M(2,:)%j)) * den(391)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(1094),h0tab(:,1094),[48,15],[0,0],2,2,wf4(:,1),wf36(:,50))
  call Hloop_UV_W(ntryL,G0H144(1),0,wf4(:,1),48,G1H36(112),m3h4x36(:,169),heltab2x144(:,:,995))
  Gcoeff(:)%j = (c(47)*(M(1,:)%j-M(2,:)%j)) * den(392)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(1095),h0tab(:,1095),[48,15],[0,0],2,2,wf4(:,1),wf36(:,51))
  call Hloop_QV_A(ntryL,G0H144(1),wf4(:,1),G0H36(44),m3h4x36(:,170),heltab2x144(:,:,996))
  call Hloop_Q_A(ntryL,G0H36(44),48,0,G1H36(92),n2h36(214))
  Gcoeff(:)%j = (c(46)*(M(1,:)%j-M(2,:)%j)) * den(392)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(1096),h0tab(:,1096),[48,15],[nMT,nMT],2,2,wf4(:,1),wf36(:,51))
  call Hloop_QV_A(ntryL,G0H144(1),wf4(:,1),G0H36(44),m3h4x36(:,171),heltab2x144(:,:,997))
  call Hloop_Q_A(ntryL,G0H36(44),48,nMT,G1H36(15),n2h36(215))
  Gcoeff(:)%j = (c(47)*(M(1,:)%j-M(2,:)%j)) * den(392)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(1097),h0tab(:,1097),[48,15],[0,0],2,2,wf4(:,1),wf36(:,51))
  call Hloop_QV_A(ntryL,G0H144(1),wf4(:,1),G0H36(44),m3h4x36(:,172),heltab2x144(:,:,998))
  call Hloop_Q_A(ntryL,G0H36(44),48,0,G1H36(100),n2h36(216))
  Gcoeff(:)%j = (c(46)*(M(1,:)%j-M(2,:)%j)) * den(392)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(1098),h0tab(:,1098),[48,15],[nMB,nMB],2,2,wf4(:,1),wf36(:,51))
  call Hloop_QV_A(ntryL,G0H144(1),wf4(:,1),G0H36(44),m3h4x36(:,173),heltab2x144(:,:,999))
  call Hloop_Q_A(ntryL,G0H36(44),48,nMB,G1H36(109),n2h36(217))
  Gcoeff(:)%j = (c(70)*(M(1,:)%j-M(2,:)%j)) * den(393)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(1099),h0tab(:,1099),[48,15],[0,0],2,2,wf4(:,1),wf36(:,52))
  call Hloop_QV_A(ntryL,G0H144(1),wf4(:,1),G0H36(44),m3h4x36(:,174),heltab2x144(:,:,1000))
  call Hloop_Q_A(ntryL,G0H36(44),48,0,G1H36(110),n2h36(218))
  Gcoeff(:)%j = (c(69)*(M(1,:)%j-M(2,:)%j)) * den(393)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(1100),h0tab(:,1100),[48,15],[nMT,nMT],2,2,wf4(:,1),wf36(:,52))
  call Hloop_QV_A(ntryL,G0H144(1),wf4(:,1),G0H36(44),m3h4x36(:,175),heltab2x144(:,:,1001))
  call Hloop_Q_A(ntryL,G0H36(44),48,nMT,G1H36(111),n2h36(219))
  Gcoeff(:)%j = (c(70)*(M(1,:)%j-M(2,:)%j)) * den(393)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(1101),h0tab(:,1101),[48,15],[0,0],2,2,wf4(:,1),wf36(:,52))
  call Hloop_QV_A(ntryL,G0H144(1),wf4(:,1),G0H36(44),m3h4x36(:,176),heltab2x144(:,:,1002))
  call Hloop_Q_A(ntryL,G0H36(44),48,0,G1H36(114),n2h36(220))
  Gcoeff(:)%j = (c(69)*(M(1,:)%j-M(2,:)%j)) * den(393)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(1102),h0tab(:,1102),[48,15],[nMB,nMB],2,2,wf4(:,1),wf36(:,52))
  call Hloop_QV_A(ntryL,G0H144(1),wf4(:,1),G0H36(44),m3h4x36(:,177),heltab2x144(:,:,1003))
  call Hloop_Q_A(ntryL,G0H36(44),48,nMB,G1H36(115),n2h36(221))
  Gcoeff(:)%j = (c(7)*(M(1,:)%j-M(2,:)%j)) * den(392)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(1103),h0tab(:,1103),[48,15],[0,0],2,2,wf4(:,1),wf36(:,51))
  call Hloop_CV_D(ntryL,G0H144(1),0,wf4(:,1),48,G1H36(116),m3h4x36(:,178),heltab2x144(:,:,1004))
  Gcoeff(:)%j = (c(40)*(M(1,:)%j-M(2,:)%j)) * den(393)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(1104),h0tab(:,1104),[48,15],[0,0],2,2,wf4(:,1),wf36(:,52))
  call Hloop_CV_D(ntryL,G0H144(1),0,wf4(:,1),48,G1H36(32),m3h4x36(:,179),heltab2x144(:,:,1005))
  Gcoeff(:)%j = (c(2)*(-M(1,:)%j+M(2,:)%j)) * den(392)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(1105),h0tab(:,1105),[48,15],[0,0],2,2,wf4(:,1),wf36(:,51))
  call Hloop_UV_W(ntryL,G0H144(1),0,wf4(:,1),48,G1H36(38),m3h4x36(:,180),heltab2x144(:,:,1006))
  Gcoeff(:)%j = (c(35)*(-M(1,:)%j+M(2,:)%j)) * den(393)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(1106),h0tab(:,1106),[48,15],[0,0],2,2,wf4(:,1),wf36(:,52))
  call Hloop_UV_W(ntryL,G0H144(1),0,wf4(:,1),48,G1H36(1),m3h4x36(:,181),heltab2x144(:,:,1007))
  Gcoeff(:)%j = (c(64)*(-M(1,:)%j+M(2,:)%j)) * den(394)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(1107),h0tab(:,1107),[48,15],[0,0],2,2,wf4(:,1),wf36(:,53))
  call Hloop_QV_A(ntryL,G0H144(1),wf4(:,1),G0H36(44),m3h4x36(:,182),heltab2x144(:,:,1008))
  call Hloop_Q_A(ntryL,G0H36(44),48,0,G1H36(18),n2h36(222))
  Gcoeff(:)%j = (c(63)*(-M(1,:)%j+M(2,:)%j)) * den(394)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(1108),h0tab(:,1108),[48,15],[nMT,nMT],2,2,wf4(:,1),wf36(:,53))
  call Hloop_QV_A(ntryL,G0H144(1),wf4(:,1),G0H36(44),m3h4x36(:,183),heltab2x144(:,:,1009))
  call Hloop_Q_A(ntryL,G0H36(44),48,nMT,G1H36(73),n2h36(223))
  Gcoeff(:)%j = (c(64)*(-M(1,:)%j+M(2,:)%j)) * den(394)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(1109),h0tab(:,1109),[48,15],[0,0],2,2,wf4(:,1),wf36(:,53))
  call Hloop_QV_A(ntryL,G0H144(1),wf4(:,1),G0H36(44),m3h4x36(:,184),heltab2x144(:,:,1010))
  call Hloop_Q_A(ntryL,G0H36(44),48,0,G1H36(58),n2h36(224))
  Gcoeff(:)%j = (c(63)*(-M(1,:)%j+M(2,:)%j)) * den(394)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(1110),h0tab(:,1110),[48,15],[nMB,nMB],2,2,wf4(:,1),wf36(:,53))
  call Hloop_QV_A(ntryL,G0H144(1),wf4(:,1),G0H36(44),m3h4x36(:,185),heltab2x144(:,:,1011))
  call Hloop_Q_A(ntryL,G0H36(44),48,nMB,G1H36(29),n2h36(225))
  Gcoeff(:)%j = (c(29)*(-M(1,:)%j+M(2,:)%j)) * den(394)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(1111),h0tab(:,1111),[48,15],[0,0],2,2,wf4(:,1),wf36(:,53))
  call Hloop_CV_D(ntryL,G0H144(1),0,wf4(:,1),48,G1H36(16),m3h4x36(:,186),heltab2x144(:,:,1012))
  Gcoeff(:)%j = (c(24)*(M(1,:)%j-M(2,:)%j)) * den(394)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(1112),h0tab(:,1112),[48,15],[0,0],2,2,wf4(:,1),wf36(:,53))
  call Hloop_UV_W(ntryL,G0H144(1),0,wf4(:,1),48,G1H36(86),m3h4x36(:,187),heltab2x144(:,:,1013))
  Gcoeff(:)%j = (c(47)*(M(1,:)%j-M(2,:)%j)) * den(395)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(1113),h0tab(:,1113),[48,15],[0,0],2,2,wf4(:,1),wf36(:,54))
  call Hloop_QV_A(ntryL,G0H144(1),wf4(:,1),G0H36(44),m3h4x36(:,188),heltab2x144(:,:,1014))
  call Hloop_Q_A(ntryL,G0H36(44),48,0,G1H36(97),n2h36(226))
  Gcoeff(:)%j = (c(46)*(M(1,:)%j-M(2,:)%j)) * den(395)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(1114),h0tab(:,1114),[48,15],[nMT,nMT],2,2,wf4(:,1),wf36(:,54))
  call Hloop_QV_A(ntryL,G0H144(1),wf4(:,1),G0H36(44),m3h4x36(:,189),heltab2x144(:,:,1015))
  call Hloop_Q_A(ntryL,G0H36(44),48,nMT,G1H36(106),n2h36(227))
  Gcoeff(:)%j = (c(47)*(M(1,:)%j-M(2,:)%j)) * den(395)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(1115),h0tab(:,1115),[48,15],[0,0],2,2,wf4(:,1),wf36(:,54))
  call Hloop_QV_A(ntryL,G0H144(1),wf4(:,1),G0H36(44),m3h4x36(:,190),heltab2x144(:,:,1016))
  call Hloop_Q_A(ntryL,G0H36(44),48,0,G1H36(65),n2h36(228))
  Gcoeff(:)%j = (c(46)*(M(1,:)%j-M(2,:)%j)) * den(395)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(1116),h0tab(:,1116),[48,15],[nMB,nMB],2,2,wf4(:,1),wf36(:,54))
  call Hloop_QV_A(ntryL,G0H144(1),wf4(:,1),G0H36(44),m3h4x36(:,191),heltab2x144(:,:,1017))
  call Hloop_Q_A(ntryL,G0H36(44),48,nMB,G1H36(107),n2h36(229))
  Gcoeff(:)%j = (c(70)*(M(1,:)%j-M(2,:)%j)) * den(396)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(1117),h0tab(:,1117),[48,15],[0,0],2,2,wf4(:,1),wf36(:,55))
  call Hloop_QV_A(ntryL,G0H144(1),wf4(:,1),G0H36(44),m3h4x36(:,192),heltab2x144(:,:,1018))
  call Hloop_Q_A(ntryL,G0H36(44),48,0,G1H36(113),n2h36(230))
  Gcoeff(:)%j = (c(69)*(M(1,:)%j-M(2,:)%j)) * den(396)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(1118),h0tab(:,1118),[48,15],[nMT,nMT],2,2,wf4(:,1),wf36(:,55))
  call Hloop_QV_A(ntryL,G0H144(1),wf4(:,1),G0H36(44),m3h4x36(:,193),heltab2x144(:,:,1019))
  call Hloop_Q_A(ntryL,G0H36(44),48,nMT,G1H36(40),n2h36(231))
  Gcoeff(:)%j = (c(70)*(M(1,:)%j-M(2,:)%j)) * den(396)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(1119),h0tab(:,1119),[48,15],[0,0],2,2,wf4(:,1),wf36(:,55))
  call Hloop_QV_A(ntryL,G0H144(1),wf4(:,1),G0H36(44),m3h4x36(:,194),heltab2x144(:,:,1020))
  call Hloop_Q_A(ntryL,G0H36(44),48,0,G1H36(14),n2h36(232))
  Gcoeff(:)%j = (c(69)*(M(1,:)%j-M(2,:)%j)) * den(396)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(1120),h0tab(:,1120),[48,15],[nMB,nMB],2,2,wf4(:,1),wf36(:,55))
  call Hloop_QV_A(ntryL,G0H144(1),wf4(:,1),G0H36(44),m3h4x36(:,195),heltab2x144(:,:,1021))
  call Hloop_Q_A(ntryL,G0H36(44),48,nMB,G1H36(23),n2h36(233))
  Gcoeff(:)%j = (c(7)*(M(1,:)%j-M(2,:)%j)) * den(395)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(1121),h0tab(:,1121),[48,15],[0,0],2,2,wf4(:,1),wf36(:,54))
  call Hloop_CV_D(ntryL,G0H144(1),0,wf4(:,1),48,G1H36(99),m3h4x36(:,196),heltab2x144(:,:,1022))
  Gcoeff(:)%j = (c(40)*(M(1,:)%j-M(2,:)%j)) * den(396)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(1122),h0tab(:,1122),[48,15],[0,0],2,2,wf4(:,1),wf36(:,55))
  call Hloop_CV_D(ntryL,G0H144(1),0,wf4(:,1),48,G1H36(103),m3h4x36(:,197),heltab2x144(:,:,1023))
  Gcoeff(:)%j = (c(2)*(-M(1,:)%j+M(2,:)%j)) * den(395)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(1123),h0tab(:,1123),[48,15],[0,0],2,2,wf4(:,1),wf36(:,54))
  call Hloop_UV_W(ntryL,G0H144(1),0,wf4(:,1),48,G1H36(104),m3h4x36(:,198),heltab2x144(:,:,1024))
  Gcoeff(:)%j = (c(35)*(-M(1,:)%j+M(2,:)%j)) * den(396)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(1124),h0tab(:,1124),[48,15],[0,0],2,2,wf4(:,1),wf36(:,55))
  call Hloop_UV_W(ntryL,G0H144(1),0,wf4(:,1),48,G1H36(105),m3h4x36(:,199),heltab2x144(:,:,1025))
  Gcoeff(:)%j = (c(27)*(M(1,:)%j-M(2,:)%j)) * den(268)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(1125),h0tab(:,1125),[50,13],[nMT,0],2,2,wf8(:,4),wf18(:,12))
  call Hloop_VA_Q(ntryL,G0H144(1),wf8(:,4),G0H18(27),m3h8x18(:,145),heltab2x144(:,:,1026))
  call Hloop_A_Q(ntryL,G0H18(27),50,nMT,G1H18(150),n2h18(416))
  Gcoeff(:)%j = (c(5)*(-M(1,:)%j+M(2,:)%j)) * den(269)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(1126),h0tab(:,1126),[50,13],[nMT,0],2,2,wf8(:,4),wf18(:,14))
  call Hloop_VA_Q(ntryL,G0H144(1),wf8(:,4),G0H18(18),m3h8x18(:,146),heltab2x144(:,:,1027))
  call Hloop_A_Q(ntryL,G0H18(18),50,nMT,G1H18(156),n2h18(417))
  Gcoeff(:)%j = (c(38)*(-M(1,:)%j+M(2,:)%j)) * den(270)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(1127),h0tab(:,1127),[50,13],[nMT,0],2,2,wf8(:,4),wf18(:,16))
  call Hloop_VA_Q(ntryL,G0H144(1),wf8(:,4),G0H18(28),m3h8x18(:,147),heltab2x144(:,:,1028))
  call Hloop_A_Q(ntryL,G0H18(28),50,nMT,G1H18(157),n2h18(418))
  Gcoeff(:)%j = (c(27)*(M(1,:)%j-M(2,:)%j)) * den(271)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(1128),h0tab(:,1128),[49,14],[0,nMT],2,2,wf8(:,8),wf18(:,6))
  call Hloop_AQ_V(ntryL,G0H144(1),wf8(:,8),G0H18(19),m3h8x18(:,148),heltab2x144(:,:,1029))
  Gcoeff(:)%j = (c(5)*(-M(1,:)%j+M(2,:)%j)) * den(272)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(1129),h0tab(:,1129),[49,14],[0,nMT],2,2,wf8(:,8),wf18(:,8))
  call Hloop_AQ_V(ntryL,G0H144(1),wf8(:,8),G0H18(29),m3h8x18(:,149),heltab2x144(:,:,1030))
  Gcoeff(:)%j = (c(38)*(-M(1,:)%j+M(2,:)%j)) * den(273)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(1130),h0tab(:,1130),[49,14],[0,nMT],2,2,wf8(:,8),wf18(:,10))
  call Hloop_AQ_V(ntryL,G0H144(1),wf8(:,8),G0H18(13),m3h8x18(:,150),heltab2x144(:,:,1031))
  Gcoeff(:)%j = (c(21)*M(2,:)%j) * den(282)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(1131),h0tab(:,1131),[42,21],[nMB,0],2,2,wf12(:,10),wf12(:,12))
  call Hloop_VA_Q(ntryL,G0H144(1),wf12(:,10),G0H12(19),m3h12x12(:,31),heltab2x144(:,:,1032))
  call Hloop_A_Q(ntryL,G0H12(19),42,nMB,G1H12(159),n2h12(216))
  Gcoeff(:)%j = (c(21)*M(2,:)%j) * den(397)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(1132),h0tab(:,1132),[34,29],[0,nMT],2,2,wf4(:,5),wf36(:,81))
  call Hloop_QA_V(ntryL,G0H144(1),wf4(:,5),G0H36(44),m3h4x36(:,200),heltab2x144(:,:,1033))
  Gcoeff(:)%j = (c(21)*M(2,:)%j) * den(398)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(1133),h0tab(:,1133),[46,17],[nMT,0],2,2,wf36(:,87),wf4(:,7))
  call Hloop_VA_Q(ntryL,G0H144(1),wf36(:,87),G0H4(3),m3h36x4(:,53),heltab2x144(:,:,1034))
  call Hloop_A_Q(ntryL,G0H4(3),46,nMT,G1H4(2),n2h4(314))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(285)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(1134),h0tab(:,1134),[37,26],[0,nMB],2,2,wf12(:,14),wf12(:,8))
  call Hloop_AQ_V(ntryL,G0H144(1),wf12(:,14),G0H12(20),m3h12x12(:,32),heltab2x144(:,:,1035))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(399)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(1135),h0tab(:,1135),[45,18],[nMT,0],2,2,wf36(:,85),wf4(:,3))
  call Hloop_VQ_A(ntryL,G0H144(1),wf36(:,85),G0H4(17),m3h36x4(:,54),heltab2x144(:,:,1036))
  call Hloop_Q_A(ntryL,G0H4(17),45,nMT,G1H4(66),n2h4(315))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(400)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H144(1),m0h(1136),h0tab(:,1136),[33,30],[0,nMT],2,2,wf4(:,9),wf36(:,83))
  call Hloop_AQ_V(ntryL,G0H144(1),wf4(:,9),G0H36(45),m3h4x36(:,201),heltab2x144(:,:,1037))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H2(27),[G0H2(26),G0H2(25),G0H2(24),G0H2(23),G0H2(22) &
    ,G0H2(21),G0H2(20),G0H2(19),G0H2(18),G0H2(17),G0H2(16),G0H2(15),G0H2(14),G0H2(13),G0H2(12),G0H2(11),G0H2(10),G0H2(9),G0H2(8) &
    ,G0H2(7),G0H2(6),G0H2(5),G0H2(4),G0H2(3),G0H2(2),G0H2(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H36(80),[G0H36(2),G0H36(3),G0H36(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H36(117),[G0H36(5),G0H36(4),G0H36(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H36(43),[G0H36(8),G0H36(7),G0H36(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H36(112),[G0H36(12),G0H36(11),G0H36(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H36(38),[G0H36(15),G0H36(14),G0H36(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H36(1),[G0H36(16),G0H36(17),G0H36(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H36(86),[G0H36(19),G0H36(20),G0H36(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H36(104),[G0H36(22),G0H36(23),G0H36(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H36(105),[G0H36(25),G0H36(26),G0H36(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H36(20),[G1H36(57)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(424),[G1H6(301),G1H6(269),G1H6(268),G1H6(254),G1H6(152) &
    ,G1H6(151),G1H6(88)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(253),[G1H6(238),G1H6(237),G1H6(228),G1H6(227),G1H6(174) &
    ,G1H6(173),G1H6(93)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H18(15),[G1H18(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(66),[G1H4(14),G1H4(109),G1H4(36),G1H4(30),G1H4(107) &
    ,G1H4(104),G1H4(26),G1H4(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H36(90),[G1H36(85)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(159),[G1H12(157)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H18(27),[G1H18(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(2),[G1H4(103),G1H4(102),G1H4(99),G1H4(98),G1H4(97) &
    ,G1H4(94),G1H4(93),G1H4(92)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H36(56),[G1H36(95)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H18(169),[G1H18(32)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H18(51),[G1H18(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H18(134),[G1H18(46)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H18(150),[G1H18(135),G1H18(165)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H18(156),[G1H18(141),G1H18(166)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H18(157),[G1H18(148),G1H18(168)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H36(91),[G1H36(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H36(100),[G1H36(92)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H36(114),[G1H36(110)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H36(58),[G1H36(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H36(65),[G1H36(97)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H36(14),[G1H36(113)])
  call Hcheck_last_UV_W(ntryL,l_switch,G0H2(27),47,ex5(:),16,G1tensor(1477),m3h2x1(:,837),heltab2x2(:,:,837))
  call Hcheck_last_GGG_G_12(ntryL,l_switch,G1H72(45),ex5(:),wf36(:,1),G1tensor(1),m4h2x36x1(:,1),heltab3x72(:,:,1))
  call Hcheck_last_GGG_G_12(ntryL,l_switch,G1H72(1),wf36(:,1),ex5(:),G1tensor(74),m4h36x2x1(:,1),heltab3x72(:,:,2))
  call Hcheck_last_GGG_G_23(ntryL,l_switch,G1H72(21),ex5(:),wf36(:,1),G1tensor(21),m4h2x36x1(:,2),heltab3x72(:,:,3))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H36(80),48,wf36(:,1),15,G2tensor(442),m3h36x1(:,37),heltab2x36(:,:,449))
  call Hcheck_last_GGG_G_12(ntryL,l_switch,G1H72(23),ex5(:),wf36(:,32),G1tensor(70),m4h2x36x1(:,3),heltab3x72(:,:,4))
  call Hcheck_last_GGG_G_12(ntryL,l_switch,G1H72(38),wf36(:,32),ex5(:),G1tensor(121),m4h36x2x1(:,2),heltab3x72(:,:,5))
  call Hcheck_last_GGG_G_23(ntryL,l_switch,G1H72(40),ex5(:),wf36(:,32),G1tensor(151),m4h2x36x1(:,4),heltab3x72(:,:,6))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H36(117),48,wf36(:,32),15,G2tensor(438),m3h36x1(:,38),heltab2x36(:,:,450))
  call Hcheck_last_GGG_G_12(ntryL,l_switch,G1H72(59),ex5(:),wf36(:,41),G1tensor(181),m4h2x36x1(:,5),heltab3x72(:,:,7))
  call Hcheck_last_GGG_G_12(ntryL,l_switch,G1H72(61),wf36(:,41),ex5(:),G1tensor(211),m4h36x2x1(:,3),heltab3x72(:,:,8))
  call Hcheck_last_GGG_G_23(ntryL,l_switch,G1H72(78),ex5(:),wf36(:,41),G1tensor(241),m4h2x36x1(:,6),heltab3x72(:,:,9))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H36(43),48,wf36(:,41),15,G2tensor(434),m3h36x1(:,39),heltab2x36(:,:,451))
  call Hcheck_last_GGG_G_12(ntryL,l_switch,G1H72(80),ex5(:),wf36(:,50),G1tensor(271),m4h2x36x1(:,7),heltab3x72(:,:,10))
  call Hcheck_last_GGG_G_12(ntryL,l_switch,G1H72(110),wf36(:,50),ex5(:),G1tensor(301),m4h36x2x1(:,4),heltab3x72(:,:,11))
  call Hcheck_last_GGG_G_23(ntryL,l_switch,G1H72(112),ex5(:),wf36(:,50),G1tensor(331),m4h2x36x1(:,8),heltab3x72(:,:,12))
  call Hcheck_last_GGG_G_12(ntryL,l_switch,G1H72(138),ex5(:),wf36(:,51),G1tensor(248),m4h2x36x1(:,9),heltab3x72(:,:,13))
  call Hcheck_last_GGG_G_12(ntryL,l_switch,G1H72(140),wf36(:,51),ex5(:),G1tensor(312),m4h36x2x1(:,5),heltab3x72(:,:,14))
  call Hcheck_last_GGG_G_23(ntryL,l_switch,G1H72(149),ex5(:),wf36(:,51),G1tensor(105),m4h2x36x1(:,10),heltab3x72(:,:,15))
  call Hcheck_last_GGG_G_12(ntryL,l_switch,G1H72(151),ex5(:),wf36(:,52),G1tensor(344),m4h2x36x1(:,11),heltab3x72(:,:,16))
  call Hcheck_last_GGG_G_12(ntryL,l_switch,G1H72(157),wf36(:,52),ex5(:),G1tensor(80),m4h36x2x1(:,6),heltab3x72(:,:,17))
  call Hcheck_last_GGG_G_23(ntryL,l_switch,G1H72(159),ex5(:),wf36(:,52),G1tensor(366),m4h2x36x1(:,12),heltab3x72(:,:,18))
  call Hcheck_last_GGG_G_12(ntryL,l_switch,G1H72(171),ex5(:),wf36(:,53),G1tensor(255),m4h2x36x1(:,13),heltab3x72(:,:,19))
  call Hcheck_last_GGG_G_12(ntryL,l_switch,G1H72(173),wf36(:,53),ex5(:),G1tensor(41),m4h36x2x1(:,7),heltab3x72(:,:,20))
  call Hcheck_last_GGG_G_23(ntryL,l_switch,G1H72(182),ex5(:),wf36(:,53),G1tensor(576),m4h2x36x1(:,14),heltab3x72(:,:,21))
  call Hcheck_last_GGG_G_12(ntryL,l_switch,G1H72(184),ex5(:),wf36(:,54),G1tensor(107),m4h2x36x1(:,15),heltab3x72(:,:,22))
  call Hcheck_last_GGG_G_12(ntryL,l_switch,G1H72(190),wf36(:,54),ex5(:),G1tensor(560),m4h36x2x1(:,8),heltab3x72(:,:,23))
  call Hcheck_last_GGG_G_23(ntryL,l_switch,G1H72(192),ex5(:),wf36(:,54),G1tensor(71),m4h2x36x1(:,16),heltab3x72(:,:,24))
  call Hcheck_last_GGG_G_12(ntryL,l_switch,G1H72(5),ex5(:),wf36(:,55),G1tensor(578),m4h2x36x1(:,17),heltab3x72(:,:,25))
  call Hcheck_last_GGG_G_12(ntryL,l_switch,G1H72(7),wf36(:,55),ex5(:),G1tensor(88),m4h36x2x1(:,9),heltab3x72(:,:,26))
  call Hcheck_last_GGG_G_23(ntryL,l_switch,G1H72(25),ex5(:),wf36(:,55),G1tensor(90),m4h2x36x1(:,18),heltab3x72(:,:,27))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H36(112),48,wf36(:,50),15,G2tensor(214),m3h36x1(:,40),heltab2x36(:,:,452))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H36(38),48,wf36(:,51),15,G2tensor(217),m3h36x1(:,41),heltab2x36(:,:,453))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H36(1),48,wf36(:,52),15,G2tensor(215),m3h36x1(:,42),heltab2x36(:,:,454))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H36(86),48,wf36(:,53),15,G2tensor(1653),m3h36x1(:,43),heltab2x36(:,:,455))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H36(104),48,wf36(:,54),15,G2tensor(1650),m3h36x1(:,44),heltab2x36(:,:,456))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H36(105),48,wf36(:,55),15,G2tensor(1635),m3h36x1(:,45),heltab2x36(:,:,457))
  call Hloop_QV_A(ntryL,G1H36(20),wf36(:,1),G1H1(1),m3h36x1(:,46),heltab2x36(:,:,458))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(443),n2h1(2303))
  call Hloop_QV_A(ntryL,G1H36(59),wf36(:,1),G1H1(1),m3h36x1(:,47),heltab2x36(:,:,459))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(439),n2h1(2304))
  call Hloop_QV_A(ntryL,G1H36(21),wf36(:,1),G1H1(1),m3h36x1(:,48),heltab2x36(:,:,460))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(435),n2h1(2305))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H36(76),48,wf36(:,1),15,G2tensor(218),m3h36x1(:,49),heltab2x36(:,:,461))
  call Hcheck_last_QA_V(ntryL,l_switch,G1H6(424),wf6(:,4),G1tensor(536),m3h6x1(:,89),heltab2x6(:,:,1007))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H6(253),wf6(:,3),G1tensor(43),m3h6x1(:,90),heltab2x6(:,:,1008))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H12(148),wf12(:,3),G1tensor(176),m3h12x1(:,37),heltab2x12(:,:,503))
  call Hcheck_last_QA_V(ntryL,l_switch,G1H12(153),wf12(:,6),G1tensor(19),m3h12x1(:,38),heltab2x12(:,:,504))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H18(15),wf18(:,2),G1tensor(533),m3h18x1(:,89),heltab2x18(:,:,794))
  call Hcheck_last_QA_V(ntryL,l_switch,G1H4(66),wf4(:,3),G1tensor(61),m3h4x1(:,155),heltab2x4(:,:,313))
  call Hcheck_last_QA_V(ntryL,l_switch,G1H12(154),wf12(:,8),G1tensor(236),m3h12x1(:,39),heltab2x12(:,:,505))
  call Hloop_VQ_A(ntryL,G0H36(30),wf36(:,34),G0H1(1),m3h36x1(:,50),heltab2x36(:,:,462))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),63,nMT,G1tensor(252),n2h1(2306))
  call Hloop_VQ_A(ntryL,G0H12(16),wf12(:,3),G0H1(1),m3h12x1(:,40),heltab2x12(:,:,506))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),63,nMB,G1tensor(260),n2h1(2307))
  call Hloop_VQ_A(ntryL,G0H36(32),wf36(:,38),G0H1(1),m3h36x1(:,51),heltab2x36(:,:,463))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),63,nMT,G1tensor(56),n2h1(2308))
  call Hloop_QV_A(ntryL,G1H36(90),wf36(:,32),G1H1(1),m3h36x1(:,52),heltab2x36(:,:,464))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(222),n2h1(2309))
  call Hloop_QV_A(ntryL,G1H36(88),wf36(:,32),G1H1(1),m3h36x1(:,53),heltab2x36(:,:,465))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(223),n2h1(2310))
  call Hloop_QV_A(ntryL,G1H36(93),wf36(:,32),G1H1(1),m3h36x1(:,54),heltab2x36(:,:,466))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(226),n2h1(2311))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H36(94),48,wf36(:,32),15,G2tensor(230),m3h36x1(:,55),heltab2x36(:,:,467))
  call Hloop_VQ_A(ntryL,G0H18(36),wf18(:,2),G0H1(1),m3h18x1(:,90),heltab2x18(:,:,795))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),63,nMT,G1tensor(544),n2h1(2312))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H12(159),wf12(:,12),G1tensor(563),m3h12x1(:,41),heltab2x12(:,:,507))
  call Hcheck_last_QA_V(ntryL,l_switch,G1H18(27),wf18(:,4),G1tensor(300),m3h18x1(:,91),heltab2x18(:,:,796))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H4(2),wf4(:,7),G1tensor(110),m3h4x1(:,156),heltab2x4(:,:,314))
  call Hloop_VA_Q(ntryL,G0H12(18),wf12(:,6),G0H1(1),m3h12x1(:,42),heltab2x12(:,:,508))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),63,nMB,G1tensor(342),n2h1(2313))
  call Hloop_VA_Q(ntryL,G0H36(28),wf36(:,43),G0H1(1),m3h36x1(:,56),heltab2x36(:,:,468))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),63,nMT,G1tensor(338),n2h1(2314))
  call Hloop_VA_Q(ntryL,G0H36(29),wf36(:,47),G0H1(1),m3h36x1(:,57),heltab2x36(:,:,469))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),63,nMT,G1tensor(372),n2h1(2315))
  call Hloop_QV_A(ntryL,G1H36(56),wf36(:,41),G1H1(1),m3h36x1(:,58),heltab2x36(:,:,470))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(1332),n2h1(2316))
  call Hloop_QV_A(ntryL,G1H36(4),wf36(:,41),G1H1(1),m3h36x1(:,59),heltab2x36(:,:,471))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(1329),n2h1(2317))
  call Hloop_QV_A(ntryL,G1H36(53),wf36(:,41),G1H1(1),m3h36x1(:,60),heltab2x36(:,:,472))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(231),n2h1(2318))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H36(48),48,wf36(:,41),15,G2tensor(235),m3h36x1(:,61),heltab2x36(:,:,473))
  call Hloop_VA_Q(ntryL,G0H18(4),wf18(:,4),G0H1(1),m3h18x1(:,92),heltab2x18(:,:,797))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),63,nMT,G1tensor(360),n2h1(2319))
  call Hloop_VQ_A(ntryL,G0H36(24),wf36(:,15),G0H1(1),m3h36x1(:,62),heltab2x36(:,:,474))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),63,nMT,G1tensor(309),n2h1(2320))
  call Hloop_VQ_A(ntryL,G0H36(27),wf36(:,17),G0H1(1),m3h36x1(:,63),heltab2x36(:,:,475))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),63,nMT,G1tensor(568),n2h1(2321))
  call Hloop_VQ_A(ntryL,G0H36(33),wf36(:,19),G0H1(1),m3h36x1(:,64),heltab2x36(:,:,476))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),63,nMT,G1tensor(27),n2h1(2322))
  call Hcheck_last_QA_V(ntryL,l_switch,G1H18(169),wf18(:,6),G1tensor(495),m3h18x1(:,93),heltab2x18(:,:,798))
  call Hcheck_last_QA_V(ntryL,l_switch,G1H18(51),wf18(:,8),G1tensor(426),m3h18x1(:,94),heltab2x18(:,:,799))
  call Hcheck_last_QA_V(ntryL,l_switch,G1H18(134),wf18(:,10),G1tensor(408),m3h18x1(:,95),heltab2x18(:,:,800))
  call Hloop_VA_Q(ntryL,G0H36(34),wf36(:,21),G0H1(1),m3h36x1(:,65),heltab2x36(:,:,477))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),63,nMT,G1tensor(506),n2h1(2323))
  call Hloop_VA_Q(ntryL,G0H36(35),wf36(:,23),G0H1(1),m3h36x1(:,66),heltab2x36(:,:,478))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),63,nMT,G1tensor(321),n2h1(2324))
  call Hloop_VA_Q(ntryL,G0H36(37),wf36(:,25),G0H1(1),m3h36x1(:,67),heltab2x36(:,:,479))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),63,nMT,G1tensor(512),n2h1(2325))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H18(150),wf18(:,12),G1tensor(450),m3h18x1(:,96),heltab2x18(:,:,801))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H18(156),wf18(:,14),G1tensor(345),m3h18x1(:,97),heltab2x18(:,:,802))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H18(157),wf18(:,16),G1tensor(462),m3h18x1(:,98),heltab2x18(:,:,803))
  call Hloop_VA_Q(ntryL,G0H36(38),wf36(:,69),G0H1(1),m3h36x1(:,68),heltab2x36(:,:,480))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),63,nMT,G1tensor(470),n2h1(2326))
  call Hloop_VA_Q(ntryL,G0H36(39),wf36(:,71),G0H1(1),m3h36x1(:,69),heltab2x36(:,:,481))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),63,nMT,G1tensor(76),n2h1(2327))
  call Hloop_VA_Q(ntryL,G0H36(40),wf36(:,73),G0H1(1),m3h36x1(:,70),heltab2x36(:,:,482))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),63,nMT,G1tensor(113),n2h1(2328))
  call Hloop_VQ_A(ntryL,G0H36(41),wf36(:,57),G0H1(1),m3h36x1(:,71),heltab2x36(:,:,483))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),63,nMT,G1tensor(274),n2h1(2329))
  call Hloop_VQ_A(ntryL,G0H36(42),wf36(:,59),G0H1(1),m3h36x1(:,72),heltab2x36(:,:,484))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),63,nMT,G1tensor(618),n2h1(2330))
  call Hloop_VQ_A(ntryL,G0H36(43),wf36(:,61),G0H1(1),m3h36x1(:,73),heltab2x36(:,:,485))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),63,nMT,G1tensor(602),n2h1(2331))
  call Hloop_QV_A(ntryL,G1H36(91),wf36(:,50),G1H1(1),m3h36x1(:,74),heltab2x36(:,:,486))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(237),n2h1(2332))
  call Hloop_QV_A(ntryL,G1H36(79),wf36(:,50),G1H1(1),m3h36x1(:,75),heltab2x36(:,:,487))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(238),n2h1(2333))
  call Hloop_QV_A(ntryL,G1H36(108),wf36(:,50),G1H1(1),m3h36x1(:,76),heltab2x36(:,:,488))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(240),n2h1(2334))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H36(10),48,wf36(:,50),15,G2tensor(241),m3h36x1(:,77),heltab2x36(:,:,489))
  call Hloop_QV_A(ntryL,G1H36(100),wf36(:,51),G1H1(1),m3h36x1(:,78),heltab2x36(:,:,490))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(246),n2h1(2335))
  call Hloop_QV_A(ntryL,G1H36(15),wf36(:,51),G1H1(1),m3h36x1(:,79),heltab2x36(:,:,491))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(249),n2h1(2336))
  call Hloop_QV_A(ntryL,G1H36(109),wf36(:,51),G1H1(1),m3h36x1(:,80),heltab2x36(:,:,492))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(252),n2h1(2337))
  call Hloop_QV_A(ntryL,G1H36(114),wf36(:,52),G1H1(1),m3h36x1(:,81),heltab2x36(:,:,493))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(253),n2h1(2338))
  call Hloop_QV_A(ntryL,G1H36(111),wf36(:,52),G1H1(1),m3h36x1(:,82),heltab2x36(:,:,494))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(255),n2h1(2339))
  call Hloop_QV_A(ntryL,G1H36(115),wf36(:,52),G1H1(1),m3h36x1(:,83),heltab2x36(:,:,495))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(256),n2h1(2340))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H36(116),48,wf36(:,51),15,G2tensor(259),m3h36x1(:,84),heltab2x36(:,:,496))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H36(32),48,wf36(:,52),15,G2tensor(261),m3h36x1(:,85),heltab2x36(:,:,497))
  call Hloop_QV_A(ntryL,G1H36(58),wf36(:,53),G1H1(1),m3h36x1(:,86),heltab2x36(:,:,498))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(262),n2h1(2341))
  call Hloop_QV_A(ntryL,G1H36(73),wf36(:,53),G1H1(1),m3h36x1(:,87),heltab2x36(:,:,499))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(264),n2h1(2342))
  call Hloop_QV_A(ntryL,G1H36(29),wf36(:,53),G1H1(1),m3h36x1(:,88),heltab2x36(:,:,500))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(265),n2h1(2343))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H36(16),48,wf36(:,53),15,G2tensor(267),m3h36x1(:,89),heltab2x36(:,:,501))
  call Hloop_QV_A(ntryL,G1H36(65),wf36(:,54),G1H1(1),m3h36x1(:,90),heltab2x36(:,:,502))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(268),n2h1(2344))
  call Hloop_QV_A(ntryL,G1H36(106),wf36(:,54),G1H1(1),m3h36x1(:,91),heltab2x36(:,:,503))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(270),n2h1(2345))
  call Hloop_QV_A(ntryL,G1H36(107),wf36(:,54),G1H1(1),m3h36x1(:,92),heltab2x36(:,:,504))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(271),n2h1(2346))
  call Hloop_QV_A(ntryL,G1H36(14),wf36(:,55),G1H1(1),m3h36x1(:,93),heltab2x36(:,:,505))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(273),n2h1(2347))
  call Hloop_QV_A(ntryL,G1H36(40),wf36(:,55),G1H1(1),m3h36x1(:,94),heltab2x36(:,:,506))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(274),n2h1(2348))
  call Hloop_QV_A(ntryL,G1H36(23),wf36(:,55),G1H1(1),m3h36x1(:,95),heltab2x36(:,:,507))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(276),n2h1(2349))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H36(99),48,wf36(:,54),15,G2tensor(279),m3h36x1(:,96),heltab2x36(:,:,508))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H36(103),48,wf36(:,55),15,G2tensor(282),m3h36x1(:,97),heltab2x36(:,:,509))
  call Hloop_VA_Q(ntryL,G0H18(19),wf18(:,6),G0H1(1),m3h18x1(:,99),heltab2x18(:,:,804))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),63,nMT,G1tensor(612),n2h1(2350))
  call Hloop_VA_Q(ntryL,G0H18(29),wf18(:,8),G0H1(1),m3h18x1(:,100),heltab2x18(:,:,805))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),63,nMT,G1tensor(626),n2h1(2351))
  call Hloop_VA_Q(ntryL,G0H18(13),wf18(:,10),G0H1(1),m3h18x1(:,101),heltab2x18(:,:,806))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),63,nMT,G1tensor(690),n2h1(2352))
  call Hloop_VQ_A(ntryL,G0H36(44),wf36(:,81),G0H1(1),m3h36x1(:,98),heltab2x36(:,:,510))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),63,nMT,G1tensor(650),n2h1(2353))
  call Hloop_VA_Q(ntryL,G0H12(20),wf12(:,8),G0H1(1),m3h12x1(:,43),heltab2x12(:,:,509))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),63,nMB,G1tensor(662),n2h1(2354))
  call Hloop_VA_Q(ntryL,G0H36(45),wf36(:,83),G0H1(1),m3h36x1(:,99),heltab2x36(:,:,511))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),63,nMT,G1tensor(680),n2h1(2355))
  call ol_merge_tensors(G0tensor(876),[G0tensor(67),G0tensor(62),G0tensor(57),G0tensor(37),G0tensor(1047),G0tensor(1022) &
    ,G0tensor(827),G0tensor(372),G0tensor(252),G0tensor(162),G0tensor(132)])
  call ol_merge_tensors(G0tensor(1253),[G0tensor(1238),G0tensor(205),G0tensor(891),G0tensor(1274),G0tensor(343),G0tensor(308) &
    ,G0tensor(208),G0tensor(1259),G0tensor(125),G0tensor(26),G0tensor(1482),G0tensor(1382),G0tensor(1337),G0tensor(887) &
    ,G0tensor(487),G0tensor(13),G0tensor(137)])
  call ol_merge_tensors(G0tensor(726),[G0tensor(1399),G0tensor(708),G0tensor(1004),G0tensor(598),G0tensor(368),G0tensor(32) &
    ,G0tensor(612),G0tensor(427),G0tensor(142)])
  call ol_merge_tensors(G0tensor(654),[G0tensor(640),G0tensor(1288),G0tensor(570),G0tensor(1153),G0tensor(500),G0tensor(670) &
    ,G0tensor(425),G0tensor(395),G0tensor(1306),G0tensor(941),G0tensor(1028),G0tensor(1471),G0tensor(1421),G0tensor(885) &
    ,G0tensor(1206),G0tensor(715),G0tensor(1141),G0tensor(1126),G0tensor(440),G0tensor(155),G0tensor(706),G0tensor(701) &
    ,G0tensor(686),G0tensor(1236),G0tensor(566),G0tensor(1146),G0tensor(661),G0tensor(506),G0tensor(591),G0tensor(240) &
    ,G0tensor(235),G0tensor(1103),G0tensor(456),G0tensor(1073),G0tensor(189),G0tensor(411),G0tensor(1233),G0tensor(814) &
    ,G0tensor(441),G0tensor(831),G0tensor(1363),G0tensor(756),G0tensor(866),G0tensor(796),G0tensor(861),G0tensor(993) &
    ,G0tensor(685),G0tensor(971),G0tensor(320),G0tensor(616),G0tensor(546),G0tensor(536),G0tensor(511),G0tensor(386) &
    ,G0tensor(1063),G0tensor(136),G0tensor(176),G0tensor(946),G0tensor(913),G0tensor(868),G0tensor(843),G0tensor(1423) &
    ,G0tensor(1479),G0tensor(758),G0tensor(470),G0tensor(1104),G0tensor(583),G0tensor(548),G0tensor(518),G0tensor(498) &
    ,G0tensor(229),G0tensor(448),G0tensor(404),G0tensor(351),G0tensor(306),G0tensor(593),G0tensor(231),G0tensor(493) &
    ,G0tensor(1018),G0tensor(559),G0tensor(1279),G0tensor(684),G0tensor(1014),G0tensor(1044),G0tensor(288),G0tensor(394) &
    ,G0tensor(949),G0tensor(864),G0tensor(198),G0tensor(1198),G0tensor(188),G0tensor(128),G0tensor(499),G0tensor(122) &
    ,G0tensor(116),G0tensor(101),G0tensor(94),G0tensor(88),G0tensor(82),G0tensor(76),G0tensor(70),G0tensor(35),G0tensor(30) &
    ,G0tensor(1497),G0tensor(1447),G0tensor(1397),G0tensor(1347),G0tensor(1302),G0tensor(1247),G0tensor(1202),G0tensor(1152) &
    ,G0tensor(1007),G0tensor(952),G0tensor(897),G0tensor(872),G0tensor(842),G0tensor(807),G0tensor(677),G0tensor(622) &
    ,G0tensor(597),G0tensor(567),G0tensor(532),G0tensor(507),G0tensor(477),G0tensor(447),G0tensor(417),G0tensor(232),G0tensor(202) &
    ,G0tensor(23),G0tensor(17),G0tensor(11),G0tensor(4),G0tensor(147)])
  call ol_merge_tensors(G0tensor(644),[G0tensor(635),G0tensor(1193),G0tensor(510),G0tensor(435),G0tensor(405),G0tensor(159) &
    ,G0tensor(185),G0tensor(145),G0tensor(845),G0tensor(1506),G0tensor(794),G0tensor(1361),G0tensor(1451),G0tensor(1336) &
    ,G0tensor(725),G0tensor(1371),G0tensor(650),G0tensor(625),G0tensor(1231),G0tensor(1196),G0tensor(805),G0tensor(1071) &
    ,G0tensor(175),G0tensor(1278),G0tensor(1271),G0tensor(311),G0tensor(596),G0tensor(676),G0tensor(641),G0tensor(255) &
    ,G0tensor(576),G0tensor(1106),G0tensor(224),G0tensor(431),G0tensor(451),G0tensor(391),G0tensor(1036),G0tensor(646) &
    ,G0tensor(1488),G0tensor(886),G0tensor(1078),G0tensor(871),G0tensor(906),G0tensor(916),G0tensor(1411),G0tensor(766) &
    ,G0tensor(806),G0tensor(874),G0tensor(1454),G0tensor(594),G0tensor(966),G0tensor(586),G0tensor(821),G0tensor(381) &
    ,G0tensor(931),G0tensor(141),G0tensor(1011),G0tensor(151),G0tensor(166),G0tensor(171),G0tensor(779),G0tensor(873) &
    ,G0tensor(848),G0tensor(838),G0tensor(749),G0tensor(1389),G0tensor(1369),G0tensor(879),G0tensor(778),G0tensor(1433) &
    ,G0tensor(1319),G0tensor(909),G0tensor(763),G0tensor(723),G0tensor(669),G0tensor(693),G0tensor(668),G0tensor(324) &
    ,G0tensor(305),G0tensor(1114),G0tensor(509),G0tensor(483),G0tensor(200),G0tensor(326),G0tensor(474),G0tensor(301) &
    ,G0tensor(249),G0tensor(204),G0tensor(219),G0tensor(144),G0tensor(463),G0tensor(438),G0tensor(413),G0tensor(1284) &
    ,G0tensor(694),G0tensor(1024),G0tensor(1054),G0tensor(293),G0tensor(1199),G0tensor(1194),G0tensor(609),G0tensor(628) &
    ,G0tensor(299),G0tensor(143),G0tensor(679),G0tensor(123),G0tensor(117),G0tensor(111),G0tensor(106),G0tensor(100),G0tensor(95) &
    ,G0tensor(89),G0tensor(83),G0tensor(77),G0tensor(71),G0tensor(65),G0tensor(60),G0tensor(55),G0tensor(50),G0tensor(45) &
    ,G0tensor(40),G0tensor(29),G0tensor(1502),G0tensor(1452),G0tensor(1402),G0tensor(1352),G0tensor(1297),G0tensor(1252) &
    ,G0tensor(1197),G0tensor(1107),G0tensor(1082),G0tensor(1057),G0tensor(1032),G0tensor(982),G0tensor(957),G0tensor(927) &
    ,G0tensor(902),G0tensor(867),G0tensor(837),G0tensor(812),G0tensor(782),G0tensor(757),G0tensor(732),G0tensor(707),G0tensor(682) &
    ,G0tensor(652),G0tensor(627),G0tensor(592),G0tensor(562),G0tensor(537),G0tensor(502),G0tensor(472),G0tensor(442),G0tensor(412) &
    ,G0tensor(387),G0tensor(362),G0tensor(337),G0tensor(312),G0tensor(287),G0tensor(262),G0tensor(237),G0tensor(207),G0tensor(22) &
    ,G0tensor(16),G0tensor(10),G0tensor(5),G0tensor(177),G0tensor(152)])
  call ol_merge_tensors(G0tensor(149),[G0tensor(895),G0tensor(1446),G0tensor(734),G0tensor(1376),G0tensor(174),G0tensor(1056) &
    ,G0tensor(296),G0tensor(319),G0tensor(1393),G0tensor(663),G0tensor(454),G0tensor(388),G0tensor(1084),G0tensor(42) &
    ,G0tensor(972),G0tensor(917),G0tensor(767),G0tensor(20),G0tensor(167)])
  call ol_merge_tensors(G0tensor(883),[G0tensor(158),G0tensor(1264),G0tensor(1109),G0tensor(47),G0tensor(1027),G0tensor(642) &
    ,G0tensor(172)])
  call ol_merge_tensors(G0tensor(206),[G0tensor(226),G0tensor(683),G0tensor(201),G0tensor(173),G0tensor(52),G0tensor(1097) &
    ,G0tensor(1072),G0tensor(967),G0tensor(857),G0tensor(347),G0tensor(277),G0tensor(1)])
  call ol_merge_tensors(G0tensor(900),[G0tensor(1466),G0tensor(269),G0tensor(265),G0tensor(254),G0tensor(234),G0tensor(824) &
    ,G0tensor(656),G0tensor(294),G0tensor(216),G0tensor(376),G0tensor(403),G0tensor(1432),G0tensor(1237),G0tensor(942) &
    ,G0tensor(457),G0tensor(7),G0tensor(2)])
  call ol_merge_tensors(G0tensor(239),[G0tensor(1381),G0tensor(135),G0tensor(888),G0tensor(753),G0tensor(738),G0tensor(538) &
    ,G0tensor(399),G0tensor(667),G0tensor(397),G0tensor(3)])
  call ol_merge_tensors(G0tensor(415),[G0tensor(195),G0tensor(936),G0tensor(1218),G0tensor(1191),G0tensor(1091),G0tensor(384) &
    ,G0tensor(97),G0tensor(91),G0tensor(85),G0tensor(1287),G0tensor(1232),G0tensor(577),G0tensor(517),G0tensor(402),G0tensor(217) &
    ,G0tensor(19),G0tensor(8)])
  call ol_merge_tensors(G0tensor(724),[G0tensor(928),G0tensor(181),G0tensor(813),G0tensor(858),G0tensor(533),G0tensor(513) &
    ,G0tensor(709),G0tensor(383),G0tensor(104),G0tensor(742),G0tensor(717),G0tensor(377),G0tensor(352),G0tensor(15),G0tensor(9)])
  call ol_merge_tensors(G0tensor(1058),[G0tensor(595),G0tensor(555),G0tensor(154),G0tensor(696),G0tensor(691),G0tensor(1291) &
    ,G0tensor(1246),G0tensor(1349),G0tensor(563),G0tensor(79),G0tensor(73),G0tensor(1332),G0tensor(1187),G0tensor(547) &
    ,G0tensor(432),G0tensor(187),G0tensor(14)])
  call ol_merge_tensors(G0tensor(1134),[G0tensor(1176),G0tensor(148),G0tensor(976),G0tensor(1033),G0tensor(1013),G0tensor(623) &
    ,G0tensor(1214),G0tensor(792),G0tensor(21)])
  call ol_merge_tensors(G0tensor(1346),[G0tensor(614),G0tensor(705),G0tensor(1241),G0tensor(1491),G0tensor(648),G0tensor(613) &
    ,G0tensor(215),G0tensor(747),G0tensor(637),G0tensor(607),G0tensor(297),G0tensor(247),G0tensor(192)])
  call ol_merge_tensors(G1tensor(536),[G0tensor(775),G0tensor(1378),G0tensor(791),G0tensor(1366),G0tensor(1338),G0tensor(364) &
    ,G0tensor(230),G0tensor(1009),G0tensor(822),G0tensor(492),G0tensor(197)])
  call ol_merge_tensors(G0tensor(776),[G0tensor(335),G0tensor(1029),G0tensor(260),G0tensor(797),G0tensor(772),G0tensor(722) &
    ,G0tensor(692),G0tensor(662),G0tensor(322),G0tensor(272),G0tensor(222)])
  call ol_merge_tensors(G1tensor(43),[G0tensor(530),G0tensor(1123),G0tensor(450),G0tensor(1356),G0tensor(544),G0tensor(1089) &
    ,G0tensor(245),G0tensor(992),G0tensor(852),G0tensor(462),G0tensor(227)])
  call ol_merge_tensors(G0tensor(618),[G0tensor(444),G0tensor(508),G0tensor(119),G0tensor(113),G0tensor(108),G0tensor(103) &
    ,G0tensor(937),G0tensor(912),G0tensor(882),G0tensor(582),G0tensor(552),G0tensor(282),G0tensor(257)])
  call ol_merge_tensors(G1tensor(1477),[G0tensor(580),G0tensor(1496),G0tensor(1416),G0tensor(774),G0tensor(745),G0tensor(1181) &
    ,G0tensor(1086),G0tensor(1046),G0tensor(390),G0tensor(1221),G0tensor(270),G0tensor(1129),G0tensor(1136),G0tensor(789) &
    ,G0tensor(743),G0tensor(1419),G0tensor(713),G0tensor(1367),G0tensor(1122),G0tensor(1067),G0tensor(1017),G0tensor(997) &
    ,G0tensor(327),G0tensor(302)])
  call ol_merge_tensors(G1tensor(61),[G0tensor(744),G0tensor(1344),G0tensor(823),G0tensor(808),G0tensor(728),G0tensor(1404) &
    ,G0tensor(1042),G0tensor(307)])
  call ol_merge_tensors(G1tensor(110),[G0tensor(798),G0tensor(793),G0tensor(1329),G0tensor(833),G0tensor(1092),G0tensor(777) &
    ,G0tensor(522),G0tensor(332)])
  call ol_merge_tensors(G1tensor(690),[G1tensor(626),G1tensor(612),G1tensor(360),G0tensor(160),G0tensor(846),G0tensor(803) &
    ,G0tensor(799),G0tensor(773),G0tensor(1019),G0tensor(407),G0tensor(357)])
  call ol_merge_tensors(G1tensor(544),[G0tensor(1331),G0tensor(221),G0tensor(1358),G0tensor(1469),G0tensor(1414),G0tensor(608) &
    ,G0tensor(437),G0tensor(382)])
  call ol_merge_tensors(G1tensor(462),[G1tensor(345),G1tensor(450),G1tensor(533),G0tensor(875),G0tensor(466),G0tensor(771) &
    ,G0tensor(904),G0tensor(1124),G0tensor(53),G0tensor(727),G0tensor(467)])
  call ol_merge_tensors(G1tensor(408),[G1tensor(426),G1tensor(495),G1tensor(300),G0tensor(785),G0tensor(1441),G0tensor(1413) &
    ,G0tensor(58),G0tensor(48),G0tensor(43),G0tensor(752),G0tensor(497)])
  call ol_merge_tensors(G1tensor(563),[G1tensor(176),G0tensor(1108),G0tensor(436),G0tensor(893),G0tensor(389),G0tensor(184) &
    ,G0tensor(1002),G0tensor(802),G0tensor(527)])
  call ol_merge_tensors(G0tensor(981),[G0tensor(1473),G0tensor(178),G0tensor(183),G0tensor(898),G0tensor(303),G0tensor(1192) &
    ,G0tensor(832),G0tensor(557)])
  call ol_merge_tensors(G0tensor(524),[G0tensor(851),G0tensor(129),G0tensor(309),G0tensor(1292),G0tensor(862),G0tensor(587)])
  call ol_merge_tensors(G0tensor(1031),[G0tensor(191),G0tensor(1066),G0tensor(74),G0tensor(1492),G0tensor(892),G0tensor(617)])
  call ol_merge_tensors(G0tensor(321),[G0tensor(220),G0tensor(1006),G0tensor(336),G0tensor(558),G0tensor(528),G0tensor(98) &
    ,G0tensor(1102),G0tensor(1052),G0tensor(922),G0tensor(702),G0tensor(647)])
  call ol_merge_tensors(G0tensor(501),[G0tensor(210),G0tensor(146),G0tensor(428),G0tensor(658),G0tensor(86),G0tensor(1442) &
    ,G0tensor(947),G0tensor(672)])
  call ol_merge_tensors(G0tensor(521),[G0tensor(911),G0tensor(289),G0tensor(918),G0tensor(325),G0tensor(1077),G0tensor(977) &
    ,G0tensor(697)])
  call ol_merge_tensors(G0tensor(455),[G0tensor(464),G0tensor(1283),G0tensor(273),G0tensor(934),G0tensor(223),G0tensor(994) &
    ,G0tensor(1467),G0tensor(1417),G0tensor(1262),G0tensor(1162),G0tensor(1117)])
  call ol_merge_tensors(G0tensor(445),[G0tensor(316),G0tensor(439),G0tensor(514),G0tensor(290),G0tensor(1148),G0tensor(600) &
    ,G0tensor(1127)])
  call ol_merge_tensors(G0tensor(505),[G0tensor(485),G0tensor(355),G0tensor(199),G0tensor(248),G0tensor(233),G0tensor(1503) &
    ,G0tensor(1487),G0tensor(1437),G0tensor(1282),G0tensor(1182),G0tensor(1137)])
  call ol_merge_tensors(G0tensor(610),[G0tensor(460),G0tensor(1486),G0tensor(495),G0tensor(1273),G0tensor(286),G0tensor(250) &
    ,G0tensor(1116),G0tensor(1113),G0tensor(401),G0tensor(751),G0tensor(380),G0tensor(1151),G0tensor(519),G0tensor(1387) &
    ,G0tensor(1142)])
  call ol_merge_tensors(G0tensor(1461),[G0tensor(1276),G0tensor(291),G0tensor(554),G0tensor(636),G0tensor(271),G0tensor(1269) &
    ,G0tensor(1147)])
  call ol_merge_tensors(G0tensor(560),[G0tensor(545),G0tensor(409),G0tensor(716),G0tensor(1268),G0tensor(666),G0tensor(315) &
    ,G0tensor(276),G0tensor(714),G0tensor(353),G0tensor(1412),G0tensor(1312),G0tensor(1217),G0tensor(1167)])
  call ol_merge_tensors(G0tensor(400),[G0tensor(651),G0tensor(998),G0tensor(923),G0tensor(611),G0tensor(244),G0tensor(1422) &
    ,G0tensor(1172)])
  call ol_merge_tensors(G0tensor(1144),[G0tensor(634),G0tensor(606),G0tensor(275),G0tensor(1158),G0tensor(926),G0tensor(619) &
    ,G0tensor(424),G0tensor(278),G0tensor(1462),G0tensor(1362),G0tensor(1317),G0tensor(1267),G0tensor(1212)])
  call ol_merge_tensors(G0tensor(590),[G0tensor(354),G0tensor(571),G0tensor(781),G0tensor(826),G0tensor(443),G0tensor(1322) &
    ,G0tensor(1222)])
  call ol_merge_tensors(G0tensor(620),[G0tensor(475),G0tensor(921),G0tensor(241),G0tensor(1121),G0tensor(243),G0tensor(1342) &
    ,G0tensor(1242)])
  call ol_merge_tensors(G0tensor(525),[G0tensor(1286),G0tensor(1003),G0tensor(348),G0tensor(1472),G0tensor(1272)])
  call ol_merge_tensors(G0tensor(865),[G0tensor(465),G0tensor(671),G0tensor(163),G0tensor(551),G0tensor(236),G0tensor(963) &
    ,G0tensor(1372)])
  call ol_merge_tensors(G0tensor(565),[G0tensor(515),G0tensor(1396),G0tensor(379),G0tensor(1186),G0tensor(819),G0tensor(203) &
    ,G0tensor(114),G0tensor(68),G0tensor(1392)])
  call ol_merge_tensors(G1tensor(236),[G1tensor(19),G0tensor(784),G0tensor(1216),G0tensor(894),G0tensor(859),G0tensor(33) &
    ,G0tensor(27)])
  call ol_merge_tensors(G0tensor(1426),[G0tensor(664),G0tensor(1341),G0tensor(739),G0tensor(44),G0tensor(38),G0tensor(28)])
  call ol_merge_tensors(G1tensor(90),[G1tensor(88),G1tensor(578),G1tensor(71),G1tensor(560),G1tensor(107),G1tensor(576) &
    ,G1tensor(41),G1tensor(255),G1tensor(366),G1tensor(80),G1tensor(344),G1tensor(105),G1tensor(312),G1tensor(248),G1tensor(331) &
    ,G1tensor(301),G1tensor(271),G1tensor(241),G1tensor(211),G1tensor(181),G1tensor(151),G1tensor(121),G1tensor(70),G1tensor(21) &
    ,G1tensor(74),G1tensor(1),G0tensor(639),G0tensor(550),G0tensor(520),G0tensor(1406),G0tensor(604),G0tensor(1476),G0tensor(741) &
    ,G0tensor(680),G0tensor(649),G0tensor(295),G0tensor(310),G0tensor(531),G0tensor(818),G0tensor(1374),G0tensor(331) &
    ,G0tensor(1048),G0tensor(601),G0tensor(318),G0tensor(213),G0tensor(49),G0tensor(39),G0tensor(34)])
  call ol_merge_tensors(G2tensor(282),[G2tensor(279),G2tensor(273),G2tensor(268),G2tensor(267),G2tensor(262),G2tensor(261) &
    ,G2tensor(259),G2tensor(253),G2tensor(246),G2tensor(241),G2tensor(237),G2tensor(235),G2tensor(1332),G2tensor(230) &
    ,G2tensor(222),G2tensor(218),G2tensor(443),G2tensor(1635),G2tensor(1650),G2tensor(1653),G2tensor(215),G2tensor(217) &
    ,G2tensor(214),G2tensor(434),G2tensor(438),G2tensor(442),G0tensor(1401),G0tensor(360),G0tensor(711),G0tensor(314) &
    ,G0tensor(1101),G0tensor(1098),G0tensor(884),G0tensor(1326),G0tensor(329),G0tensor(479),G0tensor(414),G0tensor(59) &
    ,G0tensor(54)])
  call ol_merge_tensors(G0tensor(164),[G0tensor(1321),G0tensor(1261),G0tensor(1266),G0tensor(1133),G0tensor(678),G0tensor(378) &
    ,G0tensor(689),G0tensor(109),G0tensor(63)])
  call ol_merge_tensors(G1tensor(650),[G1tensor(602),G1tensor(618),G1tensor(274),G1tensor(27),G1tensor(568),G1tensor(309) &
    ,G1tensor(56),G1tensor(252),G0tensor(1391),G0tensor(1201),G0tensor(585),G0tensor(899),G0tensor(643),G0tensor(699) &
    ,G0tensor(279),G0tensor(64)])
  call ol_merge_tensors(G1tensor(260),[G0tensor(665),G0tensor(1353),G0tensor(489),G0tensor(1083),G0tensor(473),G0tensor(1254) &
    ,G0tensor(304),G0tensor(69)])
  call ol_merge_tensors(G2tensor(276),[G2tensor(271),G2tensor(265),G2tensor(256),G2tensor(252),G2tensor(240),G2tensor(231) &
    ,G2tensor(226),G2tensor(435),G0tensor(854),G0tensor(1281),G0tensor(1298),G0tensor(841),G0tensor(523),G0tensor(453) &
    ,G0tensor(214),G0tensor(87),G0tensor(75)])
  call ol_merge_tensors(G0tensor(140),[G0tensor(1156),G0tensor(1076),G0tensor(190),G0tensor(889),G0tensor(468),G0tensor(968) &
    ,G0tensor(115),G0tensor(80)])
  call ol_merge_tensors(G0tensor(1154),[G0tensor(855),G0tensor(844),G0tensor(369),G0tensor(1118),G0tensor(956),G0tensor(1051) &
    ,G0tensor(809),G0tensor(653),G0tensor(503),G0tensor(423),G0tensor(1038),G0tensor(93),G0tensor(81)])
  call ol_merge_tensors(G0tensor(420),[G0tensor(1161),G0tensor(1188),G0tensor(534),G0tensor(748),G0tensor(553),G0tensor(429) &
    ,G0tensor(121),G0tensor(92)])
  call ol_merge_tensors(G0tensor(804),[G0tensor(621),G0tensor(1301),G0tensor(1081),G0tensor(300),G0tensor(484),G0tensor(284) &
    ,G0tensor(1204),G0tensor(99)])
  call ol_merge_tensors(G2tensor(274),[G2tensor(270),G2tensor(264),G2tensor(255),G2tensor(249),G2tensor(238),G2tensor(1329) &
    ,G2tensor(223),G2tensor(439),G0tensor(1431),G0tensor(446),G0tensor(1021),G0tensor(816),G0tensor(1438),G0tensor(673) &
    ,G0tensor(529),G0tensor(246),G0tensor(973),G0tensor(259),G0tensor(105)])
  call ol_merge_tensors(G0tensor(1068),[G0tensor(416),G0tensor(795),G0tensor(1323),G0tensor(958),G0tensor(134),G0tensor(156) &
    ,G0tensor(878),G0tensor(853),G0tensor(783),G0tensor(1464),G0tensor(698),G0tensor(539),G0tensor(261),G0tensor(153) &
    ,G0tensor(333),G0tensor(110)])
  call ol_merge_tensors(G0tensor(480),[G0tensor(150),G0tensor(1131),G0tensor(481),G0tensor(1008),G0tensor(1061),G0tensor(1309) &
    ,G0tensor(120)])
  call ol_merge_tensors(G0tensor(1415),[G0tensor(605),G0tensor(991),G0tensor(340),G0tensor(961),G0tensor(449),G0tensor(363) &
    ,G0tensor(126)])
  call ol_merge_tensors(G0tensor(915),[G0tensor(1166),G0tensor(1111),G0tensor(1173),G0tensor(398),G0tensor(704),G0tensor(549)])
  call ol_merge_tensors(G0tensor(629),[G0tensor(1213),G0tensor(540),G0tensor(370),G0tensor(209),G0tensor(516),G0tensor(218)])
  call ol_merge_tensors(G0tensor(1149),[G0tensor(1434),G0tensor(575),G0tensor(1001),G0tensor(1171),G0tensor(786),G0tensor(228)])
  call ol_merge_tensors(G0tensor(1139),[G0tensor(1026),G0tensor(626),G0tensor(996),G0tensor(564),G0tensor(268)])
  call ol_merge_tensors(G0tensor(1228),[G0tensor(986),G0tensor(681),G0tensor(574),G0tensor(1183),G0tensor(323),G0tensor(263)])
  call ol_merge_tensors(G0tensor(1303),[G0tensor(169),G0tensor(345),G0tensor(1459),G0tensor(1398),G0tensor(281),G0tensor(338) &
    ,G0tensor(298)])
  call ol_merge_tensors(G1tensor(662),[G1tensor(342),G0tensor(800),G0tensor(1311),G0tensor(1248),G0tensor(486),G0tensor(1484) &
    ,G0tensor(1074),G0tensor(568),G0tensor(1304)])
  call ol_merge_tensors(G0tensor(750),[G0tensor(1456),G0tensor(836),G0tensor(788),G0tensor(179),G0tensor(139)])
  call ol_merge_tensors(G1tensor(680),[G1tensor(113),G1tensor(76),G1tensor(470),G1tensor(512),G1tensor(321),G1tensor(506) &
    ,G1tensor(372),G1tensor(338),G0tensor(1023),G0tensor(951),G0tensor(504),G0tensor(406),G0tensor(768),G0tensor(703) &
    ,G0tensor(334)])
call TI_bubble_red(G2tensor(282),48,mass2set(:,1),G0tensor(1308),M2L1R1)
call TI_bubble_red(G2tensor(276),48,mass2set(:,2),G0tensor(1258),M2L1R1,G0tensor(1159))
call TI_bubble_red(G2tensor(274),48,mass2set(:,3),G0tensor(700),M2L1R1,G0tensor(659))
  call ol_merge_tensors(G0tensor(1159),[G0tensor(654)])
  call ol_merge_tensors(G0tensor(659),[G0tensor(644)])
call TI_bubble_red(G1tensor(536),53,mass2set(:,4),G0tensor(645),M2L1R1,G0tensor(1263))
call TI_bubble_red(G1tensor(43),58,mass2set(:,4),G0tensor(1119),M2L1R1,G0tensor(1105))
call TI_bubble_red(G1tensor(1477),47,mass2set(:,1),G0tensor(710),M2L1R1)
call TI_bubble_red(G1tensor(61),45,mass2set(:,5),G0tensor(660),M2L1R1,G0tensor(655))
call TI_bubble_red(G1tensor(110),46,mass2set(:,5),G0tensor(1449),M2L1R1,G0tensor(1444))
call TI_bubble_red(G1tensor(690),49,mass2set(:,6),G0tensor(1313),M2L1R1,G0tensor(719))
call TI_bubble_red(G1tensor(544),50,mass2set(:,6),G0tensor(1318),M2L1R1,G0tensor(720))
call TI_bubble_red(G1tensor(462),50,mass2set(:,5),G0tensor(1328),M2L1R1,G0tensor(1239))
call TI_bubble_red(G1tensor(408),49,mass2set(:,5),G0tensor(1229),M2L1R1,G0tensor(1224))
call TI_bubble_red(G1tensor(563),42,mass2set(:,4),G0tensor(729),M2L1R1,G0tensor(1333))
call TI_bubble_red(G1tensor(236),37,mass2set(:,4),G0tensor(730),M2L1R1,G0tensor(1348))
call TI_bubble_red(G1tensor(90),32,mass2set(:,1),G0tensor(870),M2L1R1)
call TI_bubble_red(G1tensor(650),34,mass2set(:,6),G0tensor(740),M2L1R1,G0tensor(1499))
call TI_bubble_red(G1tensor(260),42,mass2set(:,7),G0tensor(1494),M2L1R1,G0tensor(1368))
call TI_bubble_red(G1tensor(662),37,mass2set(:,7),G0tensor(759),M2L1R1,G0tensor(1474))
call TI_bubble_red(G1tensor(680),33,mass2set(:,6),G0tensor(1465),M2L1R1,G0tensor(1373))
  call ol_merge_tensors(G0tensor(1474),[G0tensor(1368),G0tensor(1348),G0tensor(1333),G0tensor(1105),G0tensor(1263) &
    ,G0tensor(1159)])
  call ol_merge_tensors(G0tensor(1373),[G0tensor(1499),G0tensor(1224),G0tensor(1239),G0tensor(720),G0tensor(719),G0tensor(1444) &
    ,G0tensor(655),G0tensor(659)])
  call ol_merge_tensors(T0sum(646),[G0tensor(876)])
  call ol_merge_tensors(T0sum(647),[G0tensor(1253)])
  call ol_merge_tensors(T0sum(648),[G0tensor(726)])
  call ol_merge_tensors(T0sum(649),[G0tensor(1474)])
  call ol_merge_tensors(T0sum(650),[G0tensor(1373)])
  call ol_merge_tensors(T0sum(651),[G0tensor(149)])
  call ol_merge_tensors(T0sum(652),[G0tensor(883)])
  call ol_merge_tensors(T0sum(653),[G0tensor(206)])
  call ol_merge_tensors(T0sum(654),[G0tensor(900)])
  call ol_merge_tensors(T0sum(655),[G0tensor(239)])
  call ol_merge_tensors(T0sum(656),[G0tensor(415)])
  call ol_merge_tensors(T0sum(657),[G0tensor(724)])
  call ol_merge_tensors(T0sum(658),[G0tensor(1058)])
  call ol_merge_tensors(T0sum(659),[G0tensor(1134)])
  call ol_merge_tensors(T0sum(660),[G0tensor(1346)])
  call ol_merge_tensors(T0sum(661),[G0tensor(645)])
  call ol_merge_tensors(T0sum(662),[G0tensor(776)])
  call ol_merge_tensors(T0sum(663),[G0tensor(1119)])
  call ol_merge_tensors(T0sum(664),[G0tensor(618)])
  call ol_merge_tensors(T0sum(665),[G0tensor(710)])
  call ol_merge_tensors(T0sum(666),[G0tensor(660)])
  call ol_merge_tensors(T0sum(667),[G0tensor(1449)])
  call ol_merge_tensors(T0sum(668),[G0tensor(1313)])
  call ol_merge_tensors(T0sum(669),[G0tensor(1318)])
  call ol_merge_tensors(T0sum(670),[G0tensor(1328)])
  call ol_merge_tensors(T0sum(671),[G0tensor(1229)])
  call ol_merge_tensors(T0sum(672),[G0tensor(729)])
  call ol_merge_tensors(T0sum(673),[G0tensor(981)])
  call ol_merge_tensors(T0sum(674),[G0tensor(524)])
  call ol_merge_tensors(T0sum(675),[G0tensor(1031)])
  call ol_merge_tensors(T0sum(676),[G0tensor(321)])
  call ol_merge_tensors(T0sum(677),[G0tensor(501)])
  call ol_merge_tensors(T0sum(678),[G0tensor(521)])
  call ol_merge_tensors(T0sum(679),[G0tensor(455)])
  call ol_merge_tensors(T0sum(680),[G0tensor(445)])
  call ol_merge_tensors(T0sum(681),[G0tensor(505)])
  call ol_merge_tensors(T0sum(682),[G0tensor(610)])
  call ol_merge_tensors(T0sum(683),[G0tensor(1461)])
  call ol_merge_tensors(T0sum(684),[G0tensor(560)])
  call ol_merge_tensors(T0sum(685),[G0tensor(400)])
  call ol_merge_tensors(T0sum(686),[G0tensor(1144)])
  call ol_merge_tensors(T0sum(687),[G0tensor(590)])
  call ol_merge_tensors(T0sum(688),[G0tensor(620)])
  call ol_merge_tensors(T0sum(689),[G0tensor(525)])
  call ol_merge_tensors(T0sum(690),[G0tensor(865)])
  call ol_merge_tensors(T0sum(691),[G0tensor(565)])
  call ol_merge_tensors(T0sum(692),[G0tensor(730)])
  call ol_merge_tensors(T0sum(693),[G0tensor(1426)])
  call ol_merge_tensors(T0sum(694),[G0tensor(870)])
  call ol_merge_tensors(T0sum(695),[G0tensor(1308)])
  call ol_merge_tensors(T0sum(696),[G0tensor(164)])
  call ol_merge_tensors(T0sum(697),[G0tensor(740)])
  call ol_merge_tensors(T0sum(698),[G0tensor(1494)])
  call ol_merge_tensors(T0sum(699),[G0tensor(1258)])
  call ol_merge_tensors(T0sum(700),[G0tensor(140)])
  call ol_merge_tensors(T0sum(701),[G0tensor(1154)])
  call ol_merge_tensors(T0sum(702),[G0tensor(420)])
  call ol_merge_tensors(T0sum(703),[G0tensor(804)])
  call ol_merge_tensors(T0sum(704),[G0tensor(700)])
  call ol_merge_tensors(T0sum(705),[G0tensor(1068)])
  call ol_merge_tensors(T0sum(706),[G0tensor(480)])
  call ol_merge_tensors(T0sum(707),[G0tensor(1415)])
  call ol_merge_tensors(T0sum(708),[G0tensor(915)])
  call ol_merge_tensors(T0sum(709),[G0tensor(629)])
  call ol_merge_tensors(T0sum(710),[G0tensor(1149)])
  call ol_merge_tensors(T0sum(711),[G0tensor(1139)])
  call ol_merge_tensors(T0sum(712),[G0tensor(1228)])
  call ol_merge_tensors(T0sum(713),[G0tensor(1303)])
  call ol_merge_tensors(T0sum(714),[G0tensor(759)])
  call ol_merge_tensors(T0sum(715),[G0tensor(750)])
  call ol_merge_tensors(T0sum(716),[G0tensor(1465)])


! Compute scalar Master integrals 

  call compute_scalar_box([ 37, 53, 61 ],masses2_60,RedSet_4(3),ScalarBoxes(1))
  call compute_scalar_box([ 33, 53, 61 ],masses2_81,RedSet_4(4),ScalarBoxes(2))
  call compute_scalar_box([ 33, 37, 61 ],masses2_81,RedSet_4(5),ScalarBoxes(3))
  call compute_scalar_box([ 33, 37, 53 ],masses2_78,RedSet_4(6),ScalarBoxes(4))
  call compute_scalar_box([ 4, 20, 28 ],masses2_62,RedSet_4(7),ScalarBoxes(5))
  call compute_scalar_box([ 32, 53, 61 ],masses2_44,RedSet_4(8),ScalarBoxes(6))
  call compute_scalar_box([ 32, 37, 61 ],masses2_44,RedSet_4(9),ScalarBoxes(7))
  call compute_scalar_box([ 32, 37, 53 ],masses2_42,RedSet_4(10),ScalarBoxes(8))
  call compute_scalar_box([ 5, 21, 29 ],masses2_60,RedSet_4(11),ScalarBoxes(9))
  call compute_scalar_box([ 32, 33, 61 ],masses2_50,RedSet_4(12),ScalarBoxes(10))
  call compute_scalar_box([ 32, 33, 53 ],masses2_47,RedSet_4(13),ScalarBoxes(11))
  call compute_scalar_box([ 1, 21, 29 ],masses2_81,RedSet_4(14),ScalarBoxes(12))
  call compute_scalar_box([ 32, 33, 37 ],masses2_47,RedSet_4(1),ScalarBoxes(13))
  call compute_scalar_box([ 1, 5, 29 ],masses2_81,RedSet_4(15),ScalarBoxes(14))
  call compute_scalar_box([ 1, 5, 21 ],masses2_78,RedSet_4(16),ScalarBoxes(15))
  call compute_scalar_box([ 37, 45, 61 ],masses2_67,RedSet_4(17),ScalarBoxes(16))
  call compute_scalar_box([ 33, 45, 61 ],masses2_89,RedSet_4(18),ScalarBoxes(17))
  call compute_scalar_box([ 33, 37, 45 ],masses2_81,RedSet_4(19),ScalarBoxes(18))
  call compute_scalar_box([ 4, 12, 28 ],masses2_69,RedSet_4(20),ScalarBoxes(19))
  call compute_scalar_box([ 32, 45, 61 ],masses2_50,RedSet_4(21),ScalarBoxes(20))
  call compute_scalar_box([ 32, 37, 45 ],masses2_44,RedSet_4(22),ScalarBoxes(21))
  call compute_scalar_box([ 5, 13, 29 ],masses2_67,RedSet_4(23),ScalarBoxes(22))
  call compute_scalar_box([ 32, 33, 45 ],masses2_50,RedSet_4(24),ScalarBoxes(23))
  call compute_scalar_box([ 1, 13, 29 ],masses2_89,RedSet_4(25),ScalarBoxes(24))
  call compute_scalar_box([ 1, 5, 13 ],masses2_81,RedSet_4(26),ScalarBoxes(25))
  call compute_scalar_box([ 49, 53, 61 ],masses2_81,RedSet_4(27),ScalarBoxes(26))
  call compute_scalar_box([ 33, 49, 61 ],masses2_89,RedSet_4(28),ScalarBoxes(27))
  call compute_scalar_box([ 33, 49, 53 ],masses2_86,RedSet_4(29),ScalarBoxes(28))
  call compute_scalar_box([ 16, 20, 28 ],masses2_82,RedSet_4(30),ScalarBoxes(29))
  call compute_scalar_box([ 32, 49, 61 ],masses2_50,RedSet_4(31),ScalarBoxes(30))
  call compute_scalar_box([ 32, 49, 53 ],masses2_47,RedSet_4(32),ScalarBoxes(31))
  call compute_scalar_box([ 17, 21, 29 ],masses2_81,RedSet_4(33),ScalarBoxes(32))
  call compute_scalar_box([ 32, 33, 49 ],masses2_50,RedSet_4(2),ScalarBoxes(33))
  call compute_scalar_box([ 1, 17, 29 ],masses2_89,RedSet_4(34),ScalarBoxes(34))
  call compute_scalar_box([ 1, 17, 21 ],masses2_86,RedSet_4(35),ScalarBoxes(35))
  call compute_scalar_box([ 42, 46, 47 ],masses2_63,RedSet_4(36),ScalarBoxes(36))
  call compute_scalar_box([ 34, 46, 47 ],masses2_83,RedSet_4(37),ScalarBoxes(37))
  call compute_scalar_box([ 34, 42, 47 ],masses2_76,RedSet_4(38),ScalarBoxes(38))
  call compute_scalar_box([ 34, 42, 46 ],masses2_81,RedSet_4(39),ScalarBoxes(39))
  call compute_scalar_box([ 8, 12, 13 ],masses2_65,RedSet_4(40),ScalarBoxes(40))
  call compute_scalar_box([ 32, 46, 47 ],masses2_46,RedSet_4(41),ScalarBoxes(41))
  call compute_scalar_box([ 32, 42, 47 ],masses2_41,RedSet_4(42),ScalarBoxes(42))
  call compute_scalar_box([ 32, 42, 46 ],masses2_44,RedSet_4(43),ScalarBoxes(43))
  call compute_scalar_box([ 10, 14, 15 ],masses2_63,RedSet_4(44),ScalarBoxes(44))
  call compute_scalar_box([ 32, 34, 47 ],masses2_46,RedSet_4(45),ScalarBoxes(45))
  call compute_scalar_box([ 32, 34, 46 ],masses2_50,RedSet_4(46),ScalarBoxes(46))
  call compute_scalar_box([ 2, 14, 15 ],masses2_83,RedSet_4(47),ScalarBoxes(47))
  call compute_scalar_box([ 32, 34, 42 ],masses2_47,RedSet_4(48),ScalarBoxes(48))
  call compute_scalar_box([ 2, 10, 15 ],masses2_76,RedSet_4(49),ScalarBoxes(49))
  call compute_scalar_box([ 2, 10, 14 ],masses2_81,RedSet_4(50),ScalarBoxes(50))
  call compute_scalar_box([ 37, 45, 47 ],masses2_63,RedSet_4(51),ScalarBoxes(51))
  call compute_scalar_box([ 33, 45, 47 ],masses2_83,RedSet_4(52),ScalarBoxes(52))
  call compute_scalar_box([ 33, 37, 47 ],masses2_76,RedSet_4(53),ScalarBoxes(53))
  call compute_scalar_box([ 4, 12, 14 ],masses2_65,RedSet_4(54),ScalarBoxes(54))
  call compute_scalar_box([ 32, 45, 47 ],masses2_46,RedSet_4(55),ScalarBoxes(55))
  call compute_scalar_box([ 32, 37, 47 ],masses2_41,RedSet_4(56),ScalarBoxes(56))
  call compute_scalar_box([ 5, 13, 15 ],masses2_63,RedSet_4(57),ScalarBoxes(57))
  call compute_scalar_box([ 32, 33, 47 ],masses2_46,RedSet_4(58),ScalarBoxes(58))
  call compute_scalar_box([ 1, 13, 15 ],masses2_83,RedSet_4(59),ScalarBoxes(59))
  call compute_scalar_box([ 1, 5, 15 ],masses2_76,RedSet_4(60),ScalarBoxes(60))
  call compute_scalar_box([ 44, 45, 47 ],masses2_75,RedSet_4(61),ScalarBoxes(61))
  call compute_scalar_box([ 40, 45, 47 ],masses2_57,RedSet_4(62),ScalarBoxes(62))
  call compute_scalar_box([ 40, 44, 47 ],masses2_69,RedSet_4(63),ScalarBoxes(63))
  call compute_scalar_box([ 40, 44, 45 ],masses2_65,RedSet_4(64),ScalarBoxes(64))
  call compute_scalar_box([ 4, 5, 7 ],masses2_74,RedSet_4(65),ScalarBoxes(65))
  call compute_scalar_box([ 32, 45, 47 ],masses2_75,RedSet_4(55),ScalarBoxes(66))
  call compute_scalar_box([ 32, 44, 47 ],masses2_91,RedSet_4(66),ScalarBoxes(67))
  call compute_scalar_box([ 32, 44, 45 ],masses2_85,RedSet_4(67),ScalarBoxes(68))
  call compute_scalar_box([ 12, 13, 15 ],masses2_75,RedSet_4(68),ScalarBoxes(69))
  call compute_scalar_box([ 32, 40, 47 ],masses2_82,RedSet_4(69),ScalarBoxes(70))
  call compute_scalar_box([ 32, 40, 45 ],masses2_77,RedSet_4(70),ScalarBoxes(71))
  call compute_scalar_box([ 8, 13, 15 ],masses2_57,RedSet_4(71),ScalarBoxes(72))
  call compute_scalar_box([ 32, 40, 44 ],masses2_82,RedSet_4(72),ScalarBoxes(73))
  call compute_scalar_box([ 8, 12, 15 ],masses2_69,RedSet_4(73),ScalarBoxes(74))
  call compute_scalar_box([ 44, 46, 47 ],masses2_75,RedSet_4(74),ScalarBoxes(75))
  call compute_scalar_box([ 36, 46, 47 ],masses2_57,RedSet_4(75),ScalarBoxes(76))
  call compute_scalar_box([ 36, 44, 47 ],masses2_69,RedSet_4(76),ScalarBoxes(77))
  call compute_scalar_box([ 36, 44, 46 ],masses2_65,RedSet_4(77),ScalarBoxes(78))
  call compute_scalar_box([ 8, 10, 11 ],masses2_74,RedSet_4(78),ScalarBoxes(79))
  call compute_scalar_box([ 32, 46, 47 ],masses2_75,RedSet_4(41),ScalarBoxes(80))
  call compute_scalar_box([ 32, 44, 46 ],masses2_85,RedSet_4(79),ScalarBoxes(81))
  call compute_scalar_box([ 12, 14, 15 ],masses2_75,RedSet_4(80),ScalarBoxes(82))
  call compute_scalar_box([ 32, 36, 47 ],masses2_82,RedSet_4(81),ScalarBoxes(83))
  call compute_scalar_box([ 32, 36, 46 ],masses2_77,RedSet_4(82),ScalarBoxes(84))
  call compute_scalar_box([ 4, 14, 15 ],masses2_57,RedSet_4(83),ScalarBoxes(85))
  call compute_scalar_box([ 32, 36, 44 ],masses2_82,RedSet_4(84),ScalarBoxes(86))
  call compute_scalar_box([ 4, 12, 15 ],masses2_69,RedSet_4(85),ScalarBoxes(87))
  call compute_scalar_box([ 52, 53, 55 ],masses2_74,RedSet_4(86),ScalarBoxes(88))
  call compute_scalar_box([ 36, 53, 55 ],masses2_74,RedSet_4(87),ScalarBoxes(89))
  call compute_scalar_box([ 36, 52, 55 ],masses2_90,RedSet_4(88),ScalarBoxes(90))
  call compute_scalar_box([ 36, 52, 53 ],masses2_84,RedSet_4(89),ScalarBoxes(91))
  call compute_scalar_box([ 16, 17, 19 ],masses2_75,RedSet_4(90),ScalarBoxes(92))
  call compute_scalar_box([ 32, 53, 55 ],masses2_56,RedSet_4(91),ScalarBoxes(93))
  call compute_scalar_box([ 32, 52, 55 ],masses2_68,RedSet_4(92),ScalarBoxes(94))
  call compute_scalar_box([ 32, 52, 53 ],masses2_64,RedSet_4(93),ScalarBoxes(95))
  call compute_scalar_box([ 20, 21, 23 ],masses2_74,RedSet_4(94),ScalarBoxes(96))
  call compute_scalar_box([ 32, 36, 55 ],masses2_68,RedSet_4(95),ScalarBoxes(97))
  call compute_scalar_box([ 32, 36, 53 ],masses2_64,RedSet_4(96),ScalarBoxes(98))
  call compute_scalar_box([ 4, 21, 23 ],masses2_74,RedSet_4(97),ScalarBoxes(99))
  call compute_scalar_box([ 32, 36, 52 ],masses2_68,RedSet_4(98),ScalarBoxes(100))
  call compute_scalar_box([ 4, 20, 23 ],masses2_90,RedSet_4(99),ScalarBoxes(101))
  call compute_scalar_box([ 4, 20, 21 ],masses2_84,RedSet_4(100),ScalarBoxes(102))
  call compute_scalar_box([ 42, 43, 47 ],masses2_48,RedSet_4(101),ScalarBoxes(103))
  call compute_scalar_box([ 40, 43, 47 ],masses2_87,RedSet_4(102),ScalarBoxes(104))
  call compute_scalar_box([ 40, 42, 47 ],masses2_72,RedSet_4(103),ScalarBoxes(105))
  call compute_scalar_box([ 40, 42, 43 ],masses2_74,RedSet_4(104),ScalarBoxes(106))
  call compute_scalar_box([ 2, 3, 7 ],masses2_49,RedSet_4(105),ScalarBoxes(107))
  call compute_scalar_box([ 32, 43, 47 ],masses2_66,RedSet_4(106),ScalarBoxes(108))
  call compute_scalar_box([ 32, 42, 47 ],masses2_55,RedSet_4(42),ScalarBoxes(109))
  call compute_scalar_box([ 32, 42, 43 ],masses2_56,RedSet_4(107),ScalarBoxes(110))
  call compute_scalar_box([ 10, 11, 15 ],masses2_48,RedSet_4(108),ScalarBoxes(111))
  call compute_scalar_box([ 32, 40, 47 ],masses2_66,RedSet_4(69),ScalarBoxes(112))
  call compute_scalar_box([ 32, 40, 43 ],masses2_68,RedSet_4(109),ScalarBoxes(113))
  call compute_scalar_box([ 8, 11, 15 ],masses2_87,RedSet_4(110),ScalarBoxes(114))
  call compute_scalar_box([ 32, 40, 42 ],masses2_64,RedSet_4(111),ScalarBoxes(115))
  call compute_scalar_box([ 8, 10, 15 ],masses2_72,RedSet_4(112),ScalarBoxes(116))
  call compute_scalar_box([ 37, 39, 47 ],masses2_48,RedSet_4(113),ScalarBoxes(117))
  call compute_scalar_box([ 36, 39, 47 ],masses2_87,RedSet_4(114),ScalarBoxes(118))
  call compute_scalar_box([ 36, 37, 47 ],masses2_72,RedSet_4(115),ScalarBoxes(119))
  call compute_scalar_box([ 36, 37, 39 ],masses2_74,RedSet_4(116),ScalarBoxes(120))
  call compute_scalar_box([ 1, 3, 11 ],masses2_49,RedSet_4(117),ScalarBoxes(121))
  call compute_scalar_box([ 32, 39, 47 ],masses2_66,RedSet_4(118),ScalarBoxes(122))
  call compute_scalar_box([ 32, 37, 47 ],masses2_55,RedSet_4(56),ScalarBoxes(123))
  call compute_scalar_box([ 32, 37, 39 ],masses2_56,RedSet_4(119),ScalarBoxes(124))
  call compute_scalar_box([ 5, 7, 15 ],masses2_48,RedSet_4(120),ScalarBoxes(125))
  call compute_scalar_box([ 32, 36, 47 ],masses2_66,RedSet_4(81),ScalarBoxes(126))
  call compute_scalar_box([ 32, 36, 39 ],masses2_68,RedSet_4(121),ScalarBoxes(127))
  call compute_scalar_box([ 4, 7, 15 ],masses2_87,RedSet_4(122),ScalarBoxes(128))
  call compute_scalar_box([ 32, 36, 37 ],masses2_64,RedSet_4(123),ScalarBoxes(129))
  call compute_scalar_box([ 4, 5, 15 ],masses2_72,RedSet_4(124),ScalarBoxes(130))
  call compute_scalar_box([ 37, 39, 55 ],masses2_51,RedSet_4(125),ScalarBoxes(131))
  call compute_scalar_box([ 36, 39, 55 ],masses2_90,RedSet_4(126),ScalarBoxes(132))
  call compute_scalar_box([ 36, 37, 55 ],masses2_74,RedSet_4(127),ScalarBoxes(133))
  call compute_scalar_box([ 1, 3, 19 ],masses2_52,RedSet_4(128),ScalarBoxes(134))
  call compute_scalar_box([ 32, 39, 55 ],masses2_68,RedSet_4(129),ScalarBoxes(135))
  call compute_scalar_box([ 32, 37, 55 ],masses2_56,RedSet_4(130),ScalarBoxes(136))
  call compute_scalar_box([ 5, 7, 23 ],masses2_51,RedSet_4(131),ScalarBoxes(137))
  call compute_scalar_box([ 4, 7, 23 ],masses2_90,RedSet_4(132),ScalarBoxes(138))
  call compute_scalar_box([ 4, 5, 23 ],masses2_74,RedSet_4(133),ScalarBoxes(139))
  call compute_scalar_box([ 35, 39, 47 ],masses2_82,RedSet_4(134),ScalarBoxes(140))
  call compute_scalar_box([ 34, 39, 47 ],masses2_45,RedSet_4(135),ScalarBoxes(141))
  call compute_scalar_box([ 34, 35, 47 ],masses2_52,RedSet_4(136),ScalarBoxes(142))
  call compute_scalar_box([ 34, 35, 39 ],masses2_49,RedSet_4(137),ScalarBoxes(143))
  call compute_scalar_box([ 32, 39, 47 ],masses2_82,RedSet_4(118),ScalarBoxes(144))
  call compute_scalar_box([ 32, 35, 47 ],masses2_91,RedSet_4(138),ScalarBoxes(145))
  call compute_scalar_box([ 32, 35, 39 ],masses2_88,RedSet_4(139),ScalarBoxes(146))
  call compute_scalar_box([ 3, 7, 15 ],masses2_82,RedSet_4(140),ScalarBoxes(147))
  call compute_scalar_box([ 32, 34, 47 ],masses2_75,RedSet_4(45),ScalarBoxes(148))
  call compute_scalar_box([ 32, 34, 39 ],masses2_73,RedSet_4(141),ScalarBoxes(149))
  call compute_scalar_box([ 2, 7, 15 ],masses2_45,RedSet_4(142),ScalarBoxes(150))
  call compute_scalar_box([ 32, 34, 35 ],masses2_75,RedSet_4(143),ScalarBoxes(151))
  call compute_scalar_box([ 2, 3, 15 ],masses2_52,RedSet_4(144),ScalarBoxes(152))
  call compute_scalar_box([ 35, 39, 55 ],masses2_80,RedSet_4(145),ScalarBoxes(153))
  call compute_scalar_box([ 34, 39, 55 ],masses2_43,RedSet_4(146),ScalarBoxes(154))
  call compute_scalar_box([ 34, 35, 55 ],masses2_49,RedSet_4(147),ScalarBoxes(155))
  call compute_scalar_box([ 32, 39, 55 ],masses2_80,RedSet_4(129),ScalarBoxes(156))
  call compute_scalar_box([ 32, 35, 55 ],masses2_88,RedSet_4(148),ScalarBoxes(157))
  call compute_scalar_box([ 3, 7, 23 ],masses2_80,RedSet_4(149),ScalarBoxes(158))
  call compute_scalar_box([ 32, 34, 55 ],masses2_73,RedSet_4(150),ScalarBoxes(159))
  call compute_scalar_box([ 2, 7, 23 ],masses2_43,RedSet_4(151),ScalarBoxes(160))
  call compute_scalar_box([ 2, 3, 23 ],masses2_49,RedSet_4(152),ScalarBoxes(161))
  call compute_scalar_box([ 35, 51, 55 ],masses2_88,RedSet_4(153),ScalarBoxes(162))
  call compute_scalar_box([ 34, 51, 55 ],masses2_49,RedSet_4(154),ScalarBoxes(163))
  call compute_scalar_box([ 34, 35, 51 ],masses2_52,RedSet_4(155),ScalarBoxes(164))
  call compute_scalar_box([ 32, 51, 55 ],masses2_88,RedSet_4(156),ScalarBoxes(165))
  call compute_scalar_box([ 32, 35, 51 ],masses2_91,RedSet_4(157),ScalarBoxes(166))
  call compute_scalar_box([ 3, 19, 23 ],masses2_88,RedSet_4(158),ScalarBoxes(167))
  call compute_scalar_box([ 32, 34, 51 ],masses2_75,RedSet_4(159),ScalarBoxes(168))
  call compute_scalar_box([ 2, 19, 23 ],masses2_49,RedSet_4(160),ScalarBoxes(169))
  call compute_scalar_box([ 2, 3, 19 ],masses2_52,RedSet_4(161),ScalarBoxes(170))
  call compute_scalar_box([ 35, 43, 47 ],masses2_82,RedSet_4(162),ScalarBoxes(171))
  call compute_scalar_box([ 33, 43, 47 ],masses2_45,RedSet_4(163),ScalarBoxes(172))
  call compute_scalar_box([ 33, 35, 47 ],masses2_52,RedSet_4(164),ScalarBoxes(173))
  call compute_scalar_box([ 33, 35, 43 ],masses2_49,RedSet_4(165),ScalarBoxes(174))
  call compute_scalar_box([ 32, 43, 47 ],masses2_82,RedSet_4(106),ScalarBoxes(175))
  call compute_scalar_box([ 32, 35, 43 ],masses2_88,RedSet_4(166),ScalarBoxes(176))
  call compute_scalar_box([ 3, 11, 15 ],masses2_82,RedSet_4(167),ScalarBoxes(177))
  call compute_scalar_box([ 32, 33, 47 ],masses2_75,RedSet_4(58),ScalarBoxes(178))
  call compute_scalar_box([ 32, 33, 43 ],masses2_73,RedSet_4(168),ScalarBoxes(179))
  call compute_scalar_box([ 1, 11, 15 ],masses2_45,RedSet_4(169),ScalarBoxes(180))
  call compute_scalar_box([ 32, 33, 35 ],masses2_75,RedSet_4(170),ScalarBoxes(181))
  call compute_scalar_box([ 1, 3, 15 ],masses2_52,RedSet_4(171),ScalarBoxes(182))
  call compute_scalar_box([ 35, 43, 59 ],masses2_80,RedSet_4(172),ScalarBoxes(183))
  call compute_scalar_box([ 33, 43, 59 ],masses2_43,RedSet_4(173),ScalarBoxes(184))
  call compute_scalar_box([ 33, 35, 59 ],masses2_49,RedSet_4(174),ScalarBoxes(185))
  call compute_scalar_box([ 2, 10, 26 ],masses2_78,RedSet_4(175),ScalarBoxes(186))
  call compute_scalar_box([ 32, 43, 59 ],masses2_80,RedSet_4(176),ScalarBoxes(187))
  call compute_scalar_box([ 32, 35, 59 ],masses2_88,RedSet_4(177),ScalarBoxes(188))
  call compute_scalar_box([ 3, 11, 27 ],masses2_80,RedSet_4(178),ScalarBoxes(189))
  call compute_scalar_box([ 32, 33, 59 ],masses2_73,RedSet_4(179),ScalarBoxes(190))
  call compute_scalar_box([ 1, 11, 27 ],masses2_43,RedSet_4(180),ScalarBoxes(191))
  call compute_scalar_box([ 1, 3, 27 ],masses2_49,RedSet_4(181),ScalarBoxes(192))
  call compute_scalar_box([ 35, 51, 59 ],masses2_88,RedSet_4(182),ScalarBoxes(193))
  call compute_scalar_box([ 33, 51, 59 ],masses2_49,RedSet_4(183),ScalarBoxes(194))
  call compute_scalar_box([ 33, 35, 51 ],masses2_52,RedSet_4(184),ScalarBoxes(195))
  call compute_scalar_box([ 2, 18, 26 ],masses2_86,RedSet_4(185),ScalarBoxes(196))
  call compute_scalar_box([ 32, 51, 59 ],masses2_88,RedSet_4(186),ScalarBoxes(197))
  call compute_scalar_box([ 3, 19, 27 ],masses2_88,RedSet_4(187),ScalarBoxes(198))
  call compute_scalar_box([ 32, 33, 51 ],masses2_75,RedSet_4(188),ScalarBoxes(199))
  call compute_scalar_box([ 1, 19, 27 ],masses2_49,RedSet_4(189),ScalarBoxes(200))
  call compute_scalar_box([ 37, 53, 55 ],masses2_39,RedSet_4(190),ScalarBoxes(201))
  call compute_scalar_box([ 36, 37, 53 ],masses2_70,RedSet_4(191),ScalarBoxes(202))
  call compute_scalar_box([ 1, 17, 19 ],masses2_40,RedSet_4(192),ScalarBoxes(203))
  call compute_scalar_box([ 32, 37, 53 ],masses2_53,RedSet_4(10),ScalarBoxes(204))
  call compute_scalar_box([ 5, 21, 23 ],masses2_39,RedSet_4(193),ScalarBoxes(205))
  call compute_scalar_box([ 4, 5, 21 ],masses2_70,RedSet_4(194),ScalarBoxes(206))
  call compute_scalar_box([ 50, 51, 55 ],masses2_49,RedSet_4(195),ScalarBoxes(207))
  call compute_scalar_box([ 34, 50, 55 ],masses2_38,RedSet_4(196),ScalarBoxes(208))
  call compute_scalar_box([ 34, 50, 51 ],masses2_40,RedSet_4(197),ScalarBoxes(209))
  call compute_scalar_box([ 16, 17, 21 ],masses2_47,RedSet_4(198),ScalarBoxes(210))
  call compute_scalar_box([ 32, 50, 55 ],masses2_73,RedSet_4(199),ScalarBoxes(211))
  call compute_scalar_box([ 32, 50, 51 ],masses2_75,RedSet_4(200),ScalarBoxes(212))
  call compute_scalar_box([ 18, 19, 23 ],masses2_49,RedSet_4(201),ScalarBoxes(213))
  call compute_scalar_box([ 32, 34, 50 ],masses2_71,RedSet_4(202),ScalarBoxes(214))
  call compute_scalar_box([ 2, 18, 23 ],masses2_38,RedSet_4(203),ScalarBoxes(215))
  call compute_scalar_box([ 2, 18, 19 ],masses2_40,RedSet_4(204),ScalarBoxes(216))
  call compute_scalar_box([ 49, 51, 59 ],masses2_49,RedSet_4(205),ScalarBoxes(217))
  call compute_scalar_box([ 33, 49, 59 ],masses2_38,RedSet_4(206),ScalarBoxes(218))
  call compute_scalar_box([ 33, 49, 51 ],masses2_40,RedSet_4(207),ScalarBoxes(219))
  call compute_scalar_box([ 16, 18, 26 ],masses2_47,RedSet_4(208),ScalarBoxes(220))
  call compute_scalar_box([ 32, 49, 59 ],masses2_73,RedSet_4(209),ScalarBoxes(221))
  call compute_scalar_box([ 32, 49, 51 ],masses2_75,RedSet_4(210),ScalarBoxes(222))
  call compute_scalar_box([ 17, 19, 27 ],masses2_49,RedSet_4(211),ScalarBoxes(223))
  call compute_scalar_box([ 32, 33, 49 ],masses2_71,RedSet_4(2),ScalarBoxes(224))
  call compute_scalar_box([ 1, 17, 27 ],masses2_38,RedSet_4(212),ScalarBoxes(225))
  call compute_scalar_box([ 50, 58, 62 ],masses2_81,RedSet_4(226),ScalarBoxes(226))
  call compute_scalar_box([ 48, 58, 62 ],masses2_44,RedSet_4(227),ScalarBoxes(227))
  call compute_scalar_box([ 48, 50, 62 ],masses2_50,RedSet_4(213),ScalarBoxes(228))
  call compute_scalar_box([ 48, 50, 58 ],masses2_47,RedSet_4(214),ScalarBoxes(229))
  call compute_scalar_box([ 48, 53, 61 ],masses2_44,RedSet_4(228),ScalarBoxes(230))
  call compute_scalar_box([ 48, 49, 61 ],masses2_50,RedSet_4(215),ScalarBoxes(231))
  call compute_scalar_box([ 48, 49, 53 ],masses2_47,RedSet_4(216),ScalarBoxes(232))
  call compute_scalar_box([ 56, 60, 61 ],masses2_65,RedSet_4(229),ScalarBoxes(233))
  call compute_scalar_box([ 48, 60, 61 ],masses2_85,RedSet_4(230),ScalarBoxes(234))
  call compute_scalar_box([ 48, 56, 61 ],masses2_77,RedSet_4(231),ScalarBoxes(235))
  call compute_scalar_box([ 48, 56, 60 ],masses2_82,RedSet_4(218),ScalarBoxes(236))
  call compute_scalar_box([ 52, 60, 62 ],masses2_65,RedSet_4(232),ScalarBoxes(237))
  call compute_scalar_box([ 48, 60, 62 ],masses2_85,RedSet_4(233),ScalarBoxes(238))
  call compute_scalar_box([ 48, 52, 62 ],masses2_77,RedSet_4(234),ScalarBoxes(239))
  call compute_scalar_box([ 48, 52, 60 ],masses2_82,RedSet_4(219),ScalarBoxes(240))
  call compute_scalar_box([ 44, 60, 61 ],masses2_85,RedSet_4(235),ScalarBoxes(241))
  call compute_scalar_box([ 40, 60, 61 ],masses2_65,RedSet_4(236),ScalarBoxes(242))
  call compute_scalar_box([ 40, 44, 61 ],masses2_65,RedSet_4(237),ScalarBoxes(243))
  call compute_scalar_box([ 40, 44, 60 ],masses2_69,RedSet_4(220),ScalarBoxes(244))
  call compute_scalar_box([ 56, 58, 59 ],masses2_74,RedSet_4(238),ScalarBoxes(245))
  call compute_scalar_box([ 48, 58, 59 ],masses2_56,RedSet_4(239),ScalarBoxes(246))
  call compute_scalar_box([ 48, 56, 59 ],masses2_68,RedSet_4(240),ScalarBoxes(247))
  call compute_scalar_box([ 48, 56, 58 ],masses2_64,RedSet_4(221),ScalarBoxes(248))
  call compute_scalar_box([ 48, 53, 55 ],masses2_56,RedSet_4(241),ScalarBoxes(249))
  call compute_scalar_box([ 48, 52, 55 ],masses2_68,RedSet_4(242),ScalarBoxes(250))
  call compute_scalar_box([ 48, 52, 53 ],masses2_64,RedSet_4(222),ScalarBoxes(251))
  call compute_scalar_box([ 48, 51, 55 ],masses2_88,RedSet_4(243),ScalarBoxes(252))
  call compute_scalar_box([ 48, 50, 55 ],masses2_73,RedSet_4(244),ScalarBoxes(253))
  call compute_scalar_box([ 48, 50, 51 ],masses2_75,RedSet_4(223),ScalarBoxes(254))
  call compute_scalar_box([ 42, 43, 59 ],masses2_51,RedSet_4(245),ScalarBoxes(255))
  call compute_scalar_box([ 40, 43, 59 ],masses2_90,RedSet_4(246),ScalarBoxes(256))
  call compute_scalar_box([ 40, 42, 59 ],masses2_74,RedSet_4(247),ScalarBoxes(257))
  call compute_scalar_box([ 48, 51, 59 ],masses2_88,RedSet_4(248),ScalarBoxes(258))
  call compute_scalar_box([ 48, 49, 59 ],masses2_73,RedSet_4(249),ScalarBoxes(259))
  call compute_scalar_box([ 48, 49, 51 ],masses2_75,RedSet_4(224),ScalarBoxes(260))
  call compute_scalar_box([ 44, 45, 61 ],masses2_71,RedSet_4(250),ScalarBoxes(261))
  call compute_scalar_box([ 40, 45, 61 ],masses2_54,RedSet_4(251),ScalarBoxes(262))
  call compute_scalar_box([ 42, 58, 59 ],masses2_39,RedSet_4(252),ScalarBoxes(263))
  call compute_scalar_box([ 40, 58, 59 ],masses2_74,RedSet_4(253),ScalarBoxes(264))
  call compute_scalar_box([ 40, 42, 58 ],masses2_70,RedSet_4(225),ScalarBoxes(265))
  call compute_scalar_box([ 34, 42, 58 ],masses2_78,RedSet_4(254),ScalarBoxes(266))
  call compute_scalar_box([ 32, 42, 58 ],masses2_42,RedSet_4(255),ScalarBoxes(267))
  call compute_scalar_box([ 32, 34, 58 ],masses2_47,RedSet_4(217),ScalarBoxes(268))
  call compute_scalar_box([ 34, 50, 58 ],masses2_86,RedSet_4(256),ScalarBoxes(269))
  call compute_scalar_box([ 32, 50, 58 ],masses2_47,RedSet_4(257),ScalarBoxes(270))
  call compute_scalar_box([ 32, 34, 50 ],masses2_50,RedSet_4(202),ScalarBoxes(271))
  call compute_scalar_box([ 35, 51, 55 ],masses2_37,RedSet_4(153),ScalarBoxes(272))
  call compute_scalar_box([ 32, 51, 55 ],masses2_37,RedSet_4(156),ScalarBoxes(273))
  call compute_scalar_box([ 32, 35, 55 ],masses2_37,RedSet_4(148),ScalarBoxes(274))
  call compute_scalar_box([ 32, 35, 51 ],masses2_37,RedSet_4(157),ScalarBoxes(275))
  call compute_scalar_box([ 3, 19, 23 ],masses2_37,RedSet_4(158),ScalarBoxes(276))
  call compute_scalar_box([ 35, 51, 55 ],masses2_61,RedSet_4(153),ScalarBoxes(277))
  call compute_scalar_box([ 32, 51, 55 ],masses2_61,RedSet_4(156),ScalarBoxes(278))
  call compute_scalar_box([ 32, 35, 55 ],masses2_61,RedSet_4(148),ScalarBoxes(279))
  call compute_scalar_box([ 32, 35, 51 ],masses2_58,RedSet_4(157),ScalarBoxes(280))
  call compute_scalar_box([ 3, 19, 23 ],masses2_61,RedSet_4(158),ScalarBoxes(281))
  call compute_scalar_box([ 35, 43, 47 ],masses2_37,RedSet_4(162),ScalarBoxes(282))
  call compute_scalar_box([ 32, 43, 47 ],masses2_37,RedSet_4(106),ScalarBoxes(283))
  call compute_scalar_box([ 32, 35, 47 ],masses2_37,RedSet_4(138),ScalarBoxes(284))
  call compute_scalar_box([ 32, 35, 43 ],masses2_37,RedSet_4(166),ScalarBoxes(285))
  call compute_scalar_box([ 3, 11, 15 ],masses2_37,RedSet_4(167),ScalarBoxes(286))
  call compute_scalar_box([ 35, 43, 47 ],masses2_66,RedSet_4(162),ScalarBoxes(287))
  call compute_scalar_box([ 32, 35, 47 ],masses2_58,RedSet_4(138),ScalarBoxes(288))
  call compute_scalar_box([ 32, 35, 43 ],masses2_61,RedSet_4(166),ScalarBoxes(289))
  call compute_scalar_box([ 3, 11, 15 ],masses2_66,RedSet_4(167),ScalarBoxes(290))
  call compute_scalar_box([ 35, 51, 59 ],masses2_37,RedSet_4(182),ScalarBoxes(291))
  call compute_scalar_box([ 32, 51, 59 ],masses2_37,RedSet_4(186),ScalarBoxes(292))
  call compute_scalar_box([ 32, 35, 59 ],masses2_37,RedSet_4(177),ScalarBoxes(293))
  call compute_scalar_box([ 3, 19, 27 ],masses2_37,RedSet_4(187),ScalarBoxes(294))
  call compute_scalar_box([ 35, 51, 59 ],masses2_61,RedSet_4(182),ScalarBoxes(295))
  call compute_scalar_box([ 32, 51, 59 ],masses2_61,RedSet_4(186),ScalarBoxes(296))
  call compute_scalar_box([ 32, 35, 59 ],masses2_61,RedSet_4(177),ScalarBoxes(297))
  call compute_scalar_box([ 3, 19, 27 ],masses2_61,RedSet_4(187),ScalarBoxes(298))
  call compute_scalar_box([ 36, 44, 47 ],masses2_37,RedSet_4(76),ScalarBoxes(299))
  call compute_scalar_box([ 32, 44, 47 ],masses2_37,RedSet_4(66),ScalarBoxes(300))
  call compute_scalar_box([ 32, 36, 47 ],masses2_37,RedSet_4(81),ScalarBoxes(301))
  call compute_scalar_box([ 32, 36, 44 ],masses2_37,RedSet_4(84),ScalarBoxes(302))
  call compute_scalar_box([ 4, 12, 15 ],masses2_37,RedSet_4(85),ScalarBoxes(303))
  call compute_scalar_box([ 36, 44, 47 ],masses2_79,RedSet_4(76),ScalarBoxes(304))
  call compute_scalar_box([ 32, 44, 47 ],masses2_58,RedSet_4(66),ScalarBoxes(305))
  call compute_scalar_box([ 32, 36, 44 ],masses2_66,RedSet_4(84),ScalarBoxes(306))
  call compute_scalar_box([ 4, 12, 15 ],masses2_79,RedSet_4(85),ScalarBoxes(307))
  call compute_scalar_box([ 35, 39, 47 ],masses2_37,RedSet_4(134),ScalarBoxes(308))
  call compute_scalar_box([ 32, 39, 47 ],masses2_37,RedSet_4(118),ScalarBoxes(309))
  call compute_scalar_box([ 32, 35, 39 ],masses2_37,RedSet_4(139),ScalarBoxes(310))
  call compute_scalar_box([ 3, 7, 15 ],masses2_37,RedSet_4(140),ScalarBoxes(311))
  call compute_scalar_box([ 35, 39, 47 ],masses2_66,RedSet_4(134),ScalarBoxes(312))
  call compute_scalar_box([ 32, 35, 39 ],masses2_61,RedSet_4(139),ScalarBoxes(313))
  call compute_scalar_box([ 3, 7, 15 ],masses2_66,RedSet_4(140),ScalarBoxes(314))
  call compute_scalar_box([ 40, 44, 47 ],masses2_37,RedSet_4(63),ScalarBoxes(315))
  call compute_scalar_box([ 32, 40, 47 ],masses2_37,RedSet_4(69),ScalarBoxes(316))
  call compute_scalar_box([ 32, 40, 44 ],masses2_37,RedSet_4(72),ScalarBoxes(317))
  call compute_scalar_box([ 8, 12, 15 ],masses2_37,RedSet_4(73),ScalarBoxes(318))
  call compute_scalar_box([ 40, 44, 47 ],masses2_79,RedSet_4(63),ScalarBoxes(319))
  call compute_scalar_box([ 32, 40, 44 ],masses2_66,RedSet_4(72),ScalarBoxes(320))
  call compute_scalar_box([ 8, 12, 15 ],masses2_79,RedSet_4(73),ScalarBoxes(321))
  call compute_scalar_box([ 35, 43, 59 ],masses2_37,RedSet_4(172),ScalarBoxes(322))
  call compute_scalar_box([ 32, 43, 59 ],masses2_37,RedSet_4(176),ScalarBoxes(323))
  call compute_scalar_box([ 3, 11, 27 ],masses2_37,RedSet_4(178),ScalarBoxes(324))
  call compute_scalar_box([ 35, 43, 59 ],masses2_68,RedSet_4(172),ScalarBoxes(325))
  call compute_scalar_box([ 32, 43, 59 ],masses2_68,RedSet_4(176),ScalarBoxes(326))
  call compute_scalar_box([ 3, 11, 27 ],masses2_68,RedSet_4(178),ScalarBoxes(327))
  call compute_scalar_box([ 36, 52, 55 ],masses2_37,RedSet_4(88),ScalarBoxes(328))
  call compute_scalar_box([ 32, 52, 55 ],masses2_37,RedSet_4(92),ScalarBoxes(329))
  call compute_scalar_box([ 32, 36, 55 ],masses2_37,RedSet_4(95),ScalarBoxes(330))
  call compute_scalar_box([ 32, 36, 52 ],masses2_37,RedSet_4(98),ScalarBoxes(331))
  call compute_scalar_box([ 4, 20, 23 ],masses2_37,RedSet_4(99),ScalarBoxes(332))
  call compute_scalar_box([ 36, 52, 55 ],masses2_59,RedSet_4(88),ScalarBoxes(333))
  call compute_scalar_box([ 32, 52, 55 ],masses2_80,RedSet_4(92),ScalarBoxes(334))
  call compute_scalar_box([ 32, 36, 55 ],masses2_80,RedSet_4(95),ScalarBoxes(335))
  call compute_scalar_box([ 32, 36, 52 ],masses2_80,RedSet_4(98),ScalarBoxes(336))
  call compute_scalar_box([ 4, 20, 23 ],masses2_59,RedSet_4(99),ScalarBoxes(337))
  call compute_scalar_box([ 35, 39, 55 ],masses2_37,RedSet_4(145),ScalarBoxes(338))
  call compute_scalar_box([ 32, 39, 55 ],masses2_37,RedSet_4(129),ScalarBoxes(339))
  call compute_scalar_box([ 3, 7, 23 ],masses2_37,RedSet_4(149),ScalarBoxes(340))
  call compute_scalar_box([ 35, 39, 55 ],masses2_68,RedSet_4(145),ScalarBoxes(341))
  call compute_scalar_box([ 3, 7, 23 ],masses2_68,RedSet_4(149),ScalarBoxes(342))
  call compute_scalar_box([ 40, 43, 47 ],masses2_37,RedSet_4(102),ScalarBoxes(343))
  call compute_scalar_box([ 32, 40, 43 ],masses2_37,RedSet_4(109),ScalarBoxes(344))
  call compute_scalar_box([ 8, 11, 15 ],masses2_37,RedSet_4(110),ScalarBoxes(345))
  call compute_scalar_box([ 40, 43, 47 ],masses2_62,RedSet_4(102),ScalarBoxes(346))
  call compute_scalar_box([ 32, 40, 43 ],masses2_80,RedSet_4(109),ScalarBoxes(347))
  call compute_scalar_box([ 8, 11, 15 ],masses2_62,RedSet_4(110),ScalarBoxes(348))
  call compute_scalar_box([ 36, 39, 55 ],masses2_37,RedSet_4(126),ScalarBoxes(349))
  call compute_scalar_box([ 32, 36, 39 ],masses2_37,RedSet_4(121),ScalarBoxes(350))
  call compute_scalar_box([ 4, 7, 23 ],masses2_37,RedSet_4(132),ScalarBoxes(351))
  call compute_scalar_box([ 36, 39, 55 ],masses2_59,RedSet_4(126),ScalarBoxes(352))
  call compute_scalar_box([ 32, 36, 39 ],masses2_80,RedSet_4(121),ScalarBoxes(353))
  call compute_scalar_box([ 4, 7, 23 ],masses2_59,RedSet_4(132),ScalarBoxes(354))
  call compute_scalar_box([ 36, 39, 47 ],masses2_37,RedSet_4(114),ScalarBoxes(355))
  call compute_scalar_box([ 4, 7, 15 ],masses2_37,RedSet_4(122),ScalarBoxes(356))
  call compute_scalar_box([ 36, 39, 47 ],masses2_62,RedSet_4(114),ScalarBoxes(357))
  call compute_scalar_box([ 4, 7, 15 ],masses2_62,RedSet_4(122),ScalarBoxes(358))
! end of process


end subroutine vamp_14

end module ol_vamp_14_ppwwtt_ttxwwxgg_1_/**/REALKIND
