
! **********************************************************************
module ol_tables_storage_ppwwtt_uuxttxwwx_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_data_types_/**/REALKIND, only: hol
  use ol_data_types_/**/REALKIND, only: basis, redset4, redset5
 use ol_data_types_/**/REALKIND, only: scalarbox 

  implicit none

  ! helicity tables for the 1-loop recursion
integer(intkind2), save :: h0tab(144,329)
integer(intkind2), save :: heltab2x2(2,2,103)
integer(intkind2), save :: heltab2x3(2,3,176)
integer(intkind2), save :: heltab2x4(2,4,98)
integer(intkind2), save :: heltab2x6(2,6,91)
integer(intkind2), save :: heltab2x8(2,8,33)
integer(intkind2), save :: heltab2x12(2,12,114)
integer(intkind2), save :: heltab2x16(2,16,20)
integer(intkind2), save :: heltab2x24(2,24,46)
integer(intkind2), save :: heltab2x48(2,48,44)
integer(intkind2), save :: heltab2x144(2,144,329)


  ! number of helicity states for openloops recursion steps
integer(intkind2), save :: m0h(329)
integer(intkind2), save :: m3h2x1(3,103)
integer(intkind2), save :: m3h3x1(3,176)
integer(intkind2), save :: m3h4x1(3,75)
integer(intkind2), save :: m3h6x1(3,42)
integer(intkind2), save :: m3h8x1(3,9)
integer(intkind2), save :: m3h24x1(3,8)
integer(intkind2), save :: m3h2x2(3,23)
integer(intkind2), save :: m3h3x2(3,12)
integer(intkind2), save :: m3h4x2(3,6)
integer(intkind2), save :: m3h6x2(3,1)
integer(intkind2), save :: m3h8x2(3,1)
integer(intkind2), save :: m3h2x3(3,37)
integer(intkind2), save :: m3h4x3(3,53)
integer(intkind2), save :: m3h8x3(3,4)
integer(intkind2), save :: m3h2x4(3,18)
integer(intkind2), save :: m3h3x4(3,39)
integer(intkind2), save :: m3h4x4(3,8)
integer(intkind2), save :: m3h6x4(3,1)
integer(intkind2), save :: m3h36x4(3,128)
integer(intkind2), save :: m3h2x6(3,21)
integer(intkind2), save :: m3h4x6(3,11)
integer(intkind2), save :: m3h8x6(3,4)
integer(intkind2), save :: m3h24x6(3,8)
integer(intkind2), save :: m3h2x8(3,11)
integer(intkind2), save :: m3h18x8(3,70)
integer(intkind2), save :: m3h2x12(3,22)
integer(intkind2), save :: m3h4x12(3,18)
integer(intkind2), save :: m3h9x16(3,55)
integer(intkind2), save :: m3h2x24(3,22)
integer(intkind2), save :: m3h6x24(3,24)
integer(intkind2), save :: m3h3x48(3,44)

integer(intkind2), save :: n2h1(387)
integer(intkind2), save :: n2h2(12)
integer(intkind2), save :: n2h3(88)
integer(intkind2), save :: n2h4(130)
integer(intkind2), save :: n2h6(16)
integer(intkind2), save :: n2h8(35)
integer(intkind2), save :: n2h12(56)
integer(intkind2), save :: n2h16(55)
integer(intkind2), save :: n2h24(3)
integer(intkind2), save :: n2h48(44)


contains

!**********************************************************************
subroutine HOL_m3_init()
!**********************************************************************
! initialize m3 arrays for helicity summation
!**********************************************************************
  use KIND_TYPES, only: REALKIND, intkind2

m3h2x1(1,:)=2
m3h2x1(2,:)=1
m3h2x1(3,:)=2
m3h3x1(1,:)=3
m3h3x1(2,:)=1
m3h3x1(3,:)=3
m3h4x1(1,:)=4
m3h4x1(2,:)=1
m3h4x1(3,:)=4
m3h6x1(1,:)=6
m3h6x1(2,:)=1
m3h6x1(3,:)=6
m3h8x1(1,:)=8
m3h8x1(2,:)=1
m3h8x1(3,:)=8
m3h24x1(1,:)=24
m3h24x1(2,:)=1
m3h24x1(3,:)=24
m3h2x2(1,:)=2
m3h2x2(2,:)=2
m3h2x2(3,:)=4
m3h3x2(1,:)=3
m3h3x2(2,:)=2
m3h3x2(3,:)=6
m3h4x2(1,:)=4
m3h4x2(2,:)=2
m3h4x2(3,:)=8
m3h6x2(1,:)=6
m3h6x2(2,:)=2
m3h6x2(3,:)=12
m3h8x2(1,:)=8
m3h8x2(2,:)=2
m3h8x2(3,:)=16
m3h2x3(1,:)=2
m3h2x3(2,:)=3
m3h2x3(3,:)=6
m3h4x3(1,:)=4
m3h4x3(2,:)=3
m3h4x3(3,:)=12
m3h8x3(1,:)=8
m3h8x3(2,:)=3
m3h8x3(3,:)=24
m3h2x4(1,:)=2
m3h2x4(2,:)=4
m3h2x4(3,:)=8
m3h3x4(1,:)=3
m3h3x4(2,:)=4
m3h3x4(3,:)=12
m3h4x4(1,:)=4
m3h4x4(2,:)=4
m3h4x4(3,:)=16
m3h6x4(1,:)=6
m3h6x4(2,:)=4
m3h6x4(3,:)=24
m3h36x4(1,:)=36
m3h36x4(2,:)=4
m3h36x4(3,:)=144
m3h2x6(1,:)=2
m3h2x6(2,:)=6
m3h2x6(3,:)=12
m3h4x6(1,:)=4
m3h4x6(2,:)=6
m3h4x6(3,:)=24
m3h8x6(1,:)=8
m3h8x6(2,:)=6
m3h8x6(3,:)=48
m3h24x6(1,:)=24
m3h24x6(2,:)=6
m3h24x6(3,:)=144
m3h2x8(1,:)=2
m3h2x8(2,:)=8
m3h2x8(3,:)=16
m3h18x8(1,:)=18
m3h18x8(2,:)=8
m3h18x8(3,:)=144
m3h2x12(1,:)=2
m3h2x12(2,:)=12
m3h2x12(3,:)=24
m3h4x12(1,:)=4
m3h4x12(2,:)=12
m3h4x12(3,:)=48
m3h9x16(1,:)=9
m3h9x16(2,:)=16
m3h9x16(3,:)=144
m3h2x24(1,:)=2
m3h2x24(2,:)=24
m3h2x24(3,:)=48
m3h6x24(1,:)=6
m3h6x24(2,:)=24
m3h6x24(3,:)=144
m3h3x48(1,:)=3
m3h3x48(2,:)=48
m3h3x48(3,:)=144

n2h1(:)=1
n2h2(:)=2
n2h3(:)=3
n2h4(:)=4
n2h6(:)=6
n2h8(:)=8
n2h12(:)=12
n2h16(:)=16
n2h24(:)=24
n2h48(:)=48


end subroutine HOL_m3_init

!**********************************************************************

end module ol_tables_storage_ppwwtt_uuxttxwwx_1_/**/REALKIND

! **********************************************************************
module ol_tensor_sum_storage_ppwwtt_uuxttxwwx_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_data_types_/**/REALKIND, only: hol, hcl, met
  use ol_data_types_/**/REALKIND, only: basis, redset4, redset5
 use ol_data_types_/**/REALKIND, only: scalarbox 

  implicit none

  type(met), save :: M2L1R1

  ! Declarations of loop wave function tensors

  type(hol), save :: G0H1(1)
  type(hol), save :: G1H1(1)
  type(hol), save :: G2H1(1)
  type(hol), save :: G1H2(59)
  type(hol), save :: G2H2(19)
  type(hol), save :: G0H3(1)
  type(hol), save :: G1H3(138)
  type(hol), save :: G2H3(45)
  type(hol), save :: G0H4(1)
  type(hol), save :: G1H4(96)
  type(hol), save :: G2H4(27)
  type(hol), save :: G0H6(4)
  type(hol), save :: G1H6(32)
  type(hol), save :: G2H6(6)
  type(hol), save :: G0H8(16)
  type(hol), save :: G1H8(14)
  type(hol), save :: G0H12(12)
  type(hol), save :: G1H12(64)
  type(hol), save :: G2H12(15)
  type(hol), save :: G0H16(1)
  type(hol), save :: G1H16(30)
  type(hol), save :: G0H24(9)
  type(hol), save :: G1H24(9)
  type(hol), save :: G0H48(1)
  type(hol), save :: G1H48(22)
  type(hol), save :: G0H144(1)
  type(hcl), save, dimension(601) :: G0tensor
  type(hcl), save, dimension(521) :: G1tensor
  type(hcl), save, dimension(264) :: G2tensor
  type(hcl), save, dimension(42) :: G3tensor



  ! Declarations for on-the-fly tensor reduction
type (basis),      save :: RedBasis(135)
type (redset4),    save :: RedSet_4(118)
type (redset5),    save :: RedSet_5(32)
integer, save :: mass2set(0:1,7)
integer, save :: mass3set(0:2,19)
integer, save :: mass4set(0:3,21)
integer, save :: mass5set(0:4,10)



  ! Declarations for TI calls

  integer, save :: momenta_1(2)
  integer, save :: momenta_2(2)
  integer, save :: momenta_3(2)
  integer, save :: momenta_4(2)
  integer, save :: momenta_5(2)
  integer, save :: momenta_6(2)
  integer, save :: momenta_7(2)
  integer, save :: momenta_8(2)
  integer, save :: momenta_9(2)
  integer, save :: momenta_10(2)
  integer, save :: momenta_11(2)
  integer, save :: momenta_12(2)
  integer, save :: momenta_13(2)
  integer, save :: momenta_14(2)
  integer, save :: momenta_15(2)
  integer, save :: momenta_16(2)
  integer, save :: momenta_17(2)
  integer, save :: momenta_18(2)
  integer, save :: momenta_19(2)
  integer, save :: momenta_20(2)
  integer, save :: momenta_21(2)
  integer, save :: momenta_22(2)
  integer, save :: momenta_23(2)
  integer, save :: momenta_24(2)
  integer, save :: momenta_25(2)
  integer, save :: momenta_26(2)
  integer, save :: momenta_27(2)
  integer, save :: momenta_28(3)
  integer, save :: momenta_29(3)
  integer, save :: momenta_30(3)
  integer, save :: momenta_31(3)
  integer, save :: momenta_32(3)
  integer, save :: momenta_33(3)
  integer, save :: momenta_34(3)
  integer, save :: momenta_35(3)
  integer, save :: momenta_36(3)
  integer, save :: momenta_37(3)
  integer, save :: momenta_38(3)
  integer, save :: momenta_39(3)
  integer, save :: momenta_40(3)
  integer, save :: momenta_41(3)
  integer, save :: momenta_42(3)
  integer, save :: momenta_43(3)
  integer, save :: momenta_44(3)
  integer, save :: momenta_45(3)
  integer, save :: momenta_46(3)
  integer, save :: momenta_47(3)
  integer, save :: momenta_48(3)
  integer, save :: momenta_49(3)
  integer, save :: momenta_50(3)
  integer, save :: momenta_51(3)
  integer, save :: momenta_52(3)
  integer, save :: momenta_53(3)
  integer, save :: momenta_54(3)
  integer, save :: momenta_55(3)
  integer, save :: momenta_56(3)
  integer, save :: momenta_57(3)
  integer, save :: momenta_58(3)
  integer, save :: momenta_59(3)
  integer, save :: momenta_60(3)
  integer, save :: momenta_61(3)
  integer, save :: momenta_62(3)
  integer, save :: momenta_63(3)
  integer, save :: momenta_64(3)
  integer, save :: momenta_65(3)
  integer, save :: momenta_66(3)
  integer, save :: momenta_67(3)
  integer, save :: momenta_68(3)
  integer, save :: momenta_69(3)
  integer, save :: momenta_70(3)
  integer, save :: momenta_71(3)
  integer, save :: momenta_72(3)
  integer, save :: momenta_73(3)
  integer, save :: momenta_74(3)
  integer, save :: momenta_75(3)
  integer, save :: momenta_76(3)
  integer, save :: momenta_77(3)
  integer, save :: momenta_78(3)
  integer, save :: momenta_79(3)
  integer, save :: momenta_80(3)
  integer, save :: momenta_81(3)
  integer, save :: momenta_82(3)
  integer, save :: momenta_83(3)
  integer, save :: momenta_84(3)
  integer, save :: momenta_85(3)
  integer, save :: momenta_86(3)
  integer, save :: momenta_87(3)
  integer, save :: momenta_88(3)
  integer, save :: momenta_89(3)
  integer, save :: momenta_90(3)
  integer, save :: momenta_91(3)
  integer, save :: momenta_92(3)
  integer, save :: momenta_93(3)
  integer, save :: momenta_94(3)
  integer, save :: momenta_95(3)
  integer, save :: momenta_96(3)
  integer, save :: momenta_97(3)
  integer, save :: momenta_98(3)
  integer, save :: momenta_99(3)
  integer, save :: momenta_100(3)
  integer, save :: momenta_101(3)
  integer, save :: momenta_102(3)
  integer, save :: momenta_103(3)
  integer, save :: momenta_104(3)
  integer, save :: momenta_105(3)
  integer, save :: momenta_106(3)
  integer, save :: momenta_107(3)
  integer, save :: momenta_108(3)
  integer, save :: momenta_109(3)
  integer, save :: momenta_110(3)
  integer, save :: momenta_111(3)
  integer, save :: momenta_112(3)
  integer, save :: momenta_113(3)
  integer, save :: momenta_114(3)
  integer, save :: momenta_115(3)
  integer, save :: momenta_116(3)
  integer, save :: momenta_117(3)
  integer, save :: momenta_118(4)
  integer, save :: momenta_119(4)
  integer, save :: momenta_120(4)
  integer, save :: momenta_121(4)
  integer, save :: momenta_122(4)
  integer, save :: momenta_123(4)
  integer, save :: momenta_124(4)
  integer, save :: momenta_125(4)
  integer, save :: momenta_126(4)
  integer, save :: momenta_127(4)
  integer, save :: momenta_128(4)
  integer, save :: momenta_129(4)
  integer, save :: momenta_130(4)
  integer, save :: momenta_131(4)
  integer, save :: momenta_132(4)
  integer, save :: momenta_133(4)
  integer, save :: momenta_134(4)
  integer, save :: momenta_135(4)
  integer, save :: momenta_136(4)
  integer, save :: momenta_137(4)
  integer, save :: momenta_138(4)
  integer, save :: momenta_139(4)
  integer, save :: momenta_140(4)
  integer, save :: momenta_141(4)
  integer, save :: momenta_142(4)
  integer, save :: momenta_143(4)
  integer, save :: momenta_144(4)
  integer, save :: momenta_145(4)
  integer, save :: momenta_146(4)
  integer, save :: momenta_147(4)
  integer, save :: momenta_148(4)
  integer, save :: momenta_149(4)
  integer, save :: momenta_150(4)
  integer, save :: momenta_151(4)
  integer, save :: momenta_152(4)
  integer, save :: momenta_153(4)
  integer, save :: momenta_154(4)
  integer, save :: momenta_155(4)
  integer, save :: momenta_156(4)
  integer, save :: momenta_157(4)
  integer, save :: momenta_158(4)
  integer, save :: momenta_159(4)
  integer, save :: momenta_160(4)
  integer, save :: momenta_161(4)
  integer, save :: momenta_162(4)
  integer, save :: momenta_163(4)
  integer, save :: momenta_164(4)
  integer, save :: momenta_165(4)
  integer, save :: momenta_166(4)
  integer, save :: momenta_167(4)
  integer, save :: momenta_168(4)
  integer, save :: momenta_169(4)
  integer, save :: momenta_170(4)
  integer, save :: momenta_171(4)
  integer, save :: momenta_172(4)
  integer, save :: momenta_173(4)
  integer, save :: momenta_174(4)
  integer, save :: momenta_175(4)
  integer, save :: momenta_176(4)
  integer, save :: momenta_177(4)
  integer, save :: momenta_178(4)
  integer, save :: momenta_179(4)
  integer, save :: momenta_180(4)
  integer, save :: momenta_181(4)
  integer, save :: momenta_182(4)
  integer, save :: momenta_183(4)
  integer, save :: momenta_184(4)
  integer, save :: momenta_185(4)
  integer, save :: momenta_186(4)
  integer, save :: momenta_187(4)
  integer, save :: momenta_188(4)
  integer, save :: momenta_189(4)
  integer, save :: momenta_190(4)
  integer, save :: momenta_191(4)
  integer, save :: momenta_192(4)
  integer, save :: momenta_193(4)
  integer, save :: momenta_194(4)
  integer, save :: momenta_195(4)
  integer, save :: momenta_196(4)
  integer, save :: momenta_197(4)
  integer, save :: momenta_198(4)
  integer, save :: momenta_199(4)
  integer, save :: momenta_200(4)
  integer, save :: momenta_201(4)
  integer, save :: momenta_202(4)
  integer, save :: momenta_203(4)
  integer, save :: momenta_204(4)
  integer, save :: momenta_205(4)
  integer, save :: momenta_206(4)
  integer, save :: momenta_207(4)
  integer, save :: momenta_208(5)
  integer, save :: momenta_209(5)
  integer, save :: momenta_210(5)
  integer, save :: momenta_211(5)
  integer, save :: momenta_212(5)
  integer, save :: momenta_213(5)
  integer, save :: momenta_214(5)
  integer, save :: momenta_215(5)
  integer, save :: momenta_216(5)
  integer, save :: momenta_217(5)
  integer, save :: momenta_218(5)
  integer, save :: momenta_219(5)
  integer, save :: momenta_220(5)
  integer, save :: momenta_221(5)
  integer, save :: momenta_222(5)
  integer, save :: momenta_223(5)
  integer, save :: momenta_224(5)
  integer, save :: momenta_225(5)
  integer, save :: momenta_226(5)
  integer, save :: momenta_227(5)
  integer, save :: momenta_228(5)
  integer, save :: momenta_229(5)
  integer, save :: momenta_230(5)
  integer, save :: momenta_231(5)
  integer, save :: momenta_232(5)
  integer, save :: momenta_233(5)
  integer, save :: momenta_234(5)
  integer, save :: momenta_235(5)
  integer, save :: momenta_236(5)
  integer, save :: momenta_237(5)
  integer, save :: momenta_238(5)
  integer, save :: momenta_239(5)
  integer, save :: momenta_240(6)
  integer, save :: momenta_241(6)
  integer, save :: momenta_242(6)
  integer, save :: momenta_243(6)

  integer, save :: masses2_1(2)
  integer, save :: masses2_2(2)
  integer, save :: masses2_3(2)
  integer, save :: masses2_4(2)
  integer, save :: masses2_5(2)
  integer, save :: masses2_6(2)
  integer, save :: masses2_7(2)
  integer, save :: masses2_8(2)
  integer, save :: masses2_9(2)
  integer, save :: masses2_10(3)
  integer, save :: masses2_11(3)
  integer, save :: masses2_12(3)
  integer, save :: masses2_13(3)
  integer, save :: masses2_14(3)
  integer, save :: masses2_15(3)
  integer, save :: masses2_16(3)
  integer, save :: masses2_17(3)
  integer, save :: masses2_18(3)
  integer, save :: masses2_19(3)
  integer, save :: masses2_20(3)
  integer, save :: masses2_21(3)
  integer, save :: masses2_22(3)
  integer, save :: masses2_23(3)
  integer, save :: masses2_24(3)
  integer, save :: masses2_25(3)
  integer, save :: masses2_26(3)
  integer, save :: masses2_27(3)
  integer, save :: masses2_28(3)
  integer, save :: masses2_29(4)
  integer, save :: masses2_30(4)
  integer, save :: masses2_31(4)
  integer, save :: masses2_32(4)
  integer, save :: masses2_33(4)
  integer, save :: masses2_34(4)
  integer, save :: masses2_35(4)
  integer, save :: masses2_36(4)
  integer, save :: masses2_37(4)
  integer, save :: masses2_38(4)
  integer, save :: masses2_39(4)
  integer, save :: masses2_40(4)
  integer, save :: masses2_41(4)
  integer, save :: masses2_42(4)
  integer, save :: masses2_43(4)
  integer, save :: masses2_44(4)
  integer, save :: masses2_45(4)
  integer, save :: masses2_46(4)
  integer, save :: masses2_47(4)
  integer, save :: masses2_48(4)
  integer, save :: masses2_49(4)
  integer, save :: masses2_50(4)
  integer, save :: masses2_51(4)
  integer, save :: masses2_52(4)
  integer, save :: masses2_53(5)
  integer, save :: masses2_54(5)
  integer, save :: masses2_55(5)
  integer, save :: masses2_56(5)
  integer, save :: masses2_57(5)
  integer, save :: masses2_58(5)
  integer, save :: masses2_59(5)
  integer, save :: masses2_60(5)
  integer, save :: masses2_61(5)
  integer, save :: masses2_62(5)
  integer, save :: masses2_63(6)
  integer, save :: masses2_64(6)

type(scalarbox), save :: ScalarBoxes(107)

integer, save :: sbarray_1(15)
integer, save :: sbarray_2(15)
integer, save :: sbarray_3(15)
integer, save :: sbarray_4(15)
integer, save :: sbarray_5(5)
integer, save :: sbarray_6(5)
integer, save :: sbarray_7(5)
integer, save :: sbarray_8(5)
integer, save :: sbarray_9(5)
integer, save :: sbarray_10(5)
integer, save :: sbarray_11(5)
integer, save :: sbarray_12(5)
integer, save :: sbarray_13(5)
integer, save :: sbarray_14(5)
integer, save :: sbarray_15(5)
integer, save :: sbarray_16(5)
integer, save :: sbarray_17(5)
integer, save :: sbarray_18(5)
integer, save :: sbarray_19(5)
integer, save :: sbarray_20(5)
integer, save :: sbarray_21(5)
integer, save :: sbarray_22(5)
integer, save :: sbarray_23(5)
integer, save :: sbarray_24(5)
integer, save :: sbarray_25(5)
integer, save :: sbarray_26(5)
integer, save :: sbarray_27(5)
integer, save :: sbarray_28(5)
integer, save :: sbarray_29(5)
integer, save :: sbarray_30(5)
integer, save :: sbarray_31(5)
integer, save :: sbarray_32(5)
integer, save :: sbarray_33(5)
integer, save :: sbarray_34(5)
integer, save :: sbarray_35(5)
integer, save :: sbarray_36(5)

  type(hcl), save, dimension(279) :: T0sum
  type(hcl), save, dimension(63) :: T1sum


  contains

!**********************************************************************
subroutine HOL_memory_allocation_full()
!**********************************************************************
! allocation of memory for the types hol
!**********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_loop_storage_ppwwtt_uuxttxwwx_1_/**/DREALKIND, only: nhel
  use ol_data_types_/**/REALKIND, only: hol
  use hol_initialisation_/**/REALKIND, only: hol_allocation
  implicit none

    call hol_allocation(4,1,4,1,G0H1,1)
  call hol_allocation(4,5,4,1,G1H1,1)
  call hol_allocation(4,15,4,1,G2H1,1)
  call hol_allocation(4,5,4,2,G1H2,59)
  call hol_allocation(4,15,4,2,G2H2,19)
  call hol_allocation(4,1,4,3,G0H3,1)
  call hol_allocation(4,5,4,3,G1H3,138)
  call hol_allocation(4,15,4,3,G2H3,45)
  call hol_allocation(4,1,4,4,G0H4,1)
  call hol_allocation(4,5,4,4,G1H4,96)
  call hol_allocation(4,15,4,4,G2H4,27)
  call hol_allocation(4,1,4,6,G0H6,4)
  call hol_allocation(4,5,4,6,G1H6,32)
  call hol_allocation(4,15,4,6,G2H6,6)
  call hol_allocation(4,1,4,8,G0H8,16)
  call hol_allocation(4,5,4,8,G1H8,14)
  call hol_allocation(4,1,4,12,G0H12,12)
  call hol_allocation(4,5,4,12,G1H12,64)
  call hol_allocation(4,15,4,12,G2H12,15)
  call hol_allocation(4,1,4,16,G0H16,1)
  call hol_allocation(4,5,4,16,G1H16,30)
  call hol_allocation(4,1,4,24,G0H24,9)
  call hol_allocation(4,5,4,24,G1H24,9)
  call hol_allocation(4,1,4,48,G0H48,1)
  call hol_allocation(4,5,4,48,G1H48,22)
  call hol_allocation(4,1,4,144,G0H144,1)


end subroutine HOL_memory_allocation_full

!**********************************************************************
subroutine HOL_memory_allocation_optimized()
!**********************************************************************
! allocation of memory for the types hol
!**********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_loop_storage_ppwwtt_uuxttxwwx_1_/**/DREALKIND, only: nhel
  use ol_data_types_/**/REALKIND, only: hol
  use hol_initialisation_/**/REALKIND, only: hol_allocation
  implicit none

    call hol_allocation(4,1,4,min(nhel,1),G0H1,1)
  call hol_allocation(4,5,4,min(nhel,1),G1H1,1)
  call hol_allocation(4,15,4,min(nhel,1),G2H1,1)
  call hol_allocation(4,5,4,min(nhel,2),G1H2,59)
  call hol_allocation(4,15,4,min(nhel,2),G2H2,19)
  call hol_allocation(4,1,4,min(nhel,3),G0H3,1)
  call hol_allocation(4,5,4,min(nhel,3),G1H3,138)
  call hol_allocation(4,15,4,min(nhel,3),G2H3,45)
  call hol_allocation(4,1,4,min(nhel,4),G0H4,1)
  call hol_allocation(4,5,4,min(nhel,4),G1H4,96)
  call hol_allocation(4,15,4,min(nhel,4),G2H4,27)
  call hol_allocation(4,1,4,min(nhel,6),G0H6,4)
  call hol_allocation(4,5,4,min(nhel,6),G1H6,32)
  call hol_allocation(4,15,4,min(nhel,6),G2H6,6)
  call hol_allocation(4,1,4,min(nhel,8),G0H8,16)
  call hol_allocation(4,5,4,min(nhel,8),G1H8,14)
  call hol_allocation(4,1,4,min(nhel,12),G0H12,12)
  call hol_allocation(4,5,4,min(nhel,12),G1H12,64)
  call hol_allocation(4,15,4,min(nhel,12),G2H12,15)
  call hol_allocation(4,1,4,min(nhel,16),G0H16,1)
  call hol_allocation(4,5,4,min(nhel,16),G1H16,30)
  call hol_allocation(4,1,4,min(nhel,24),G0H24,9)
  call hol_allocation(4,5,4,min(nhel,24),G1H24,9)
  call hol_allocation(4,1,4,min(nhel,48),G0H48,1)
  call hol_allocation(4,5,4,min(nhel,48),G1H48,22)
  call hol_allocation(4,1,4,min(nhel,144),G0H144,1)


end subroutine HOL_memory_allocation_optimized

!**********************************************************************
subroutine HOL_memory_deallocation_/**/REALKIND(dmode)
!**********************************************************************
! allocation of memory for the types hol
!**********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_data_types_/**/REALKIND, only: hol
  use hol_initialisation_/**/REALKIND, only: hol_deallocation
  implicit none
  integer,   intent(in)    :: dmode

    call hol_deallocation(G0H1,1,dmode)
  call hol_deallocation(G1H1,1,dmode)
  call hol_deallocation(G2H1,1,dmode)
  call hol_deallocation(G1H2,59,dmode)
  call hol_deallocation(G2H2,19,dmode)
  call hol_deallocation(G0H3,1,dmode)
  call hol_deallocation(G1H3,138,dmode)
  call hol_deallocation(G2H3,45,dmode)
  call hol_deallocation(G0H4,1,dmode)
  call hol_deallocation(G1H4,96,dmode)
  call hol_deallocation(G2H4,27,dmode)
  call hol_deallocation(G0H6,4,dmode)
  call hol_deallocation(G1H6,32,dmode)
  call hol_deallocation(G2H6,6,dmode)
  call hol_deallocation(G0H8,16,dmode)
  call hol_deallocation(G1H8,14,dmode)
  call hol_deallocation(G0H12,12,dmode)
  call hol_deallocation(G1H12,64,dmode)
  call hol_deallocation(G2H12,15,dmode)
  call hol_deallocation(G0H16,1,dmode)
  call hol_deallocation(G1H16,30,dmode)
  call hol_deallocation(G0H24,9,dmode)
  call hol_deallocation(G1H24,9,dmode)
  call hol_deallocation(G0H48,1,dmode)
  call hol_deallocation(G1H48,22,dmode)
  call hol_deallocation(G0H144,1,dmode)


end subroutine HOL_memory_deallocation_/**/REALKIND

!**********************************************************************
subroutine HCL_memory_allocation()
!**********************************************************************
! allocation of memory for the types hcl
!**********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_data_types_/**/REALKIND, only: hcl
  use hol_initialisation_/**/REALKIND, only: hcl_allocation
  implicit none

  call hcl_allocation(1,G0tensor, 601)
call hcl_allocation(5,G1tensor, 521)
call hcl_allocation(15,G2tensor, 264)
call hcl_allocation(35,G3tensor, 42)


end subroutine HCL_memory_allocation


!**********************************************************************
subroutine HCL_memory_deallocation_/**/REALKIND(dmode)
!**********************************************************************
! deallocation of memory for the types hcl
!**********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_data_types_/**/REALKIND, only: hcl
  use hol_initialisation_/**/REALKIND, only: hcl_deallocation
  implicit none
  integer,   intent(in)    :: dmode

  call hcl_deallocation(G0tensor, 601,dmode)
call hcl_deallocation(G1tensor, 521,dmode)
call hcl_deallocation(G2tensor, 264,dmode)
call hcl_deallocation(G3tensor, 42,dmode)

    call hcl_deallocation(T0sum,279,dmode)
  call hcl_deallocation(T1sum,63,dmode)


end subroutine HCL_memory_deallocation_/**/REALKIND


!**********************************************************************
subroutine Tsum_memory_allocation()
!**********************************************************************
! allocation of memory for the types hcl
!**********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_data_types_/**/REALKIND, only: hcl
  use hol_initialisation_/**/REALKIND, only: hcl_allocation
  implicit none

    call hcl_allocation(1,T0sum,279)
  call hcl_allocation(5,T1sum,63)


end subroutine Tsum_memory_allocation


#ifdef PRECISION_dp
subroutine max_point(r) &
    & bind(c,name="ol_f_max_point_ppwwtt_uuxttxwwx_1")
  ! Return the number maximal tensor rank
  implicit none
  integer, intent(out) :: r
  r = 6
end subroutine max_point

subroutine tensor_rank(r) &
    & bind(c,name="ol_f_tensor_rank_ppwwtt_uuxttxwwx_1")
  ! Return the number maximal tensor rank
  implicit none
  integer, intent(out) :: r
  r = 1
end subroutine tensor_rank
#endif

subroutine reset_tensor_sum()
  use hol_initialisation_/**/REALKIND, only: hcl_allocation
  use ol_parameters_init_/**/REALKIND, only: init_hcl
  implicit none
  integer :: i

  do i = 1,279
    call init_hcl(T0sum(i))
  end do
  do i = 1,63
    call init_hcl(T1sum(i))
  end do

end subroutine reset_tensor_sum


subroutine scale_one_tsum(tsum, spow)
  use ol_parameters_decl_/**/REALKIND, only: scalefactor
  implicit none
  complex(REALKIND), intent(inout) :: tsum(:)
  integer, intent(in) :: spow ! rank 0 scale power
  real(REALKIND) :: sfinv, sfac
  integer :: sz
  sfinv = 1/scalefactor
  sfac = scalefactor**spow
  sz = size(tsum)
  tsum(1) = sfac*tsum(1)
  if (sz > 1) then ! rank 1
    sfac = sfac*sfinv
    tsum(2:5) = sfac*tsum(2:5)
  end if
  if (sz > 5) then ! rank 2
    sfac = sfac*sfinv
    tsum(6:15) = sfac*tsum(6:15)
  end if
  if (sz > 15) then ! rank 3
    sfac = sfac*sfinv
    tsum(16:35) = sfac*tsum(16:35)
  end if
  if (sz > 35) then ! rank 4
    sfac = sfac*sfinv
    tsum(36:70) = sfac*tsum(36:70)
  end if
  if (sz > 70) then ! rank 5
    sfac = sfac*sfinv
    tsum(71:126) = sfac*tsum(71:126)
  end if
  if (sz > 126) then ! rank 6
    sfac = sfac*sfinv
    tsum(127:210) = sfac*tsum(127:210)
  end if
  if (sz > 210) then ! rank 7
    sfac = sfac*sfinv
    tsum(211:330) = sfac*tsum(211:330)
  end if
end subroutine scale_one_tsum


subroutine scale_tensor_sum()
  implicit none
  call scale_one_tsum(T1sum(1)%cmp, 4)
  call scale_one_tsum(T1sum(2)%cmp, 4)
  call scale_one_tsum(T1sum(3)%cmp, 4)
  call scale_one_tsum(T1sum(4)%cmp, 4)
  call scale_one_tsum(T1sum(5)%cmp, 2)
  call scale_one_tsum(T1sum(6)%cmp, 2)
  call scale_one_tsum(T1sum(7)%cmp, 2)
  call scale_one_tsum(T1sum(8)%cmp, 2)
  call scale_one_tsum(T1sum(9)%cmp, 2)
  call scale_one_tsum(T1sum(10)%cmp, 2)
  call scale_one_tsum(T1sum(11)%cmp, 2)
  call scale_one_tsum(T1sum(12)%cmp, 2)
  call scale_one_tsum(T1sum(13)%cmp, 2)
  call scale_one_tsum(T1sum(14)%cmp, 2)
  call scale_one_tsum(T1sum(15)%cmp, 2)
  call scale_one_tsum(T1sum(16)%cmp, 2)
  call scale_one_tsum(T1sum(17)%cmp, 2)
  call scale_one_tsum(T1sum(18)%cmp, 2)
  call scale_one_tsum(T1sum(19)%cmp, 2)
  call scale_one_tsum(T1sum(20)%cmp, 2)
  call scale_one_tsum(T1sum(21)%cmp, 2)
  call scale_one_tsum(T1sum(22)%cmp, 2)
  call scale_one_tsum(T1sum(23)%cmp, 2)
  call scale_one_tsum(T1sum(24)%cmp, 2)
  call scale_one_tsum(T1sum(25)%cmp, 2)
  call scale_one_tsum(T1sum(26)%cmp, 2)
  call scale_one_tsum(T1sum(27)%cmp, 2)
  call scale_one_tsum(T1sum(28)%cmp, 2)
  call scale_one_tsum(T1sum(29)%cmp, 2)
  call scale_one_tsum(T1sum(30)%cmp, 2)
  call scale_one_tsum(T1sum(31)%cmp, 2)
  call scale_one_tsum(T1sum(32)%cmp, 2)
  call scale_one_tsum(T1sum(33)%cmp, 2)
  call scale_one_tsum(T1sum(34)%cmp, 2)
  call scale_one_tsum(T1sum(35)%cmp, 2)
  call scale_one_tsum(T1sum(36)%cmp, 2)
  call scale_one_tsum(T0sum(1)%cmp, 0)
  call scale_one_tsum(T0sum(2)%cmp, 0)
  call scale_one_tsum(T0sum(3)%cmp, 0)
  call scale_one_tsum(T0sum(4)%cmp, 0)
  call scale_one_tsum(T0sum(5)%cmp, 0)
  call scale_one_tsum(T0sum(6)%cmp, 0)
  call scale_one_tsum(T0sum(7)%cmp, 0)
  call scale_one_tsum(T0sum(8)%cmp, 0)
  call scale_one_tsum(T0sum(9)%cmp, 0)
  call scale_one_tsum(T0sum(10)%cmp, 0)
  call scale_one_tsum(T0sum(11)%cmp, 0)
  call scale_one_tsum(T0sum(12)%cmp, 0)
  call scale_one_tsum(T0sum(13)%cmp, 0)
  call scale_one_tsum(T0sum(14)%cmp, 0)
  call scale_one_tsum(T0sum(15)%cmp, 0)
  call scale_one_tsum(T0sum(16)%cmp, 0)
  call scale_one_tsum(T0sum(17)%cmp, 0)
  call scale_one_tsum(T0sum(18)%cmp, 0)
  call scale_one_tsum(T0sum(19)%cmp, 0)
  call scale_one_tsum(T0sum(20)%cmp, 0)
  call scale_one_tsum(T0sum(21)%cmp, 0)
  call scale_one_tsum(T0sum(22)%cmp, 0)
  call scale_one_tsum(T0sum(23)%cmp, 0)
  call scale_one_tsum(T0sum(24)%cmp, 0)
  call scale_one_tsum(T0sum(25)%cmp, 0)
  call scale_one_tsum(T0sum(26)%cmp, 0)
  call scale_one_tsum(T0sum(27)%cmp, 0)
  call scale_one_tsum(T0sum(28)%cmp, 0)
  call scale_one_tsum(T0sum(29)%cmp, 0)
  call scale_one_tsum(T0sum(30)%cmp, 0)
  call scale_one_tsum(T0sum(31)%cmp, 0)
  call scale_one_tsum(T0sum(32)%cmp, 0)
  call scale_one_tsum(T0sum(33)%cmp, 0)
  call scale_one_tsum(T0sum(34)%cmp, 0)
  call scale_one_tsum(T0sum(35)%cmp, 0)
  call scale_one_tsum(T0sum(36)%cmp, 0)
  call scale_one_tsum(T0sum(37)%cmp, 0)
  call scale_one_tsum(T0sum(38)%cmp, 0)
  call scale_one_tsum(T0sum(39)%cmp, 0)
  call scale_one_tsum(T0sum(40)%cmp, 0)
  call scale_one_tsum(T0sum(41)%cmp, 0)
  call scale_one_tsum(T0sum(42)%cmp, 0)
  call scale_one_tsum(T0sum(43)%cmp, 0)
  call scale_one_tsum(T0sum(44)%cmp, 0)
  call scale_one_tsum(T0sum(45)%cmp, 0)
  call scale_one_tsum(T0sum(46)%cmp, 0)
  call scale_one_tsum(T0sum(47)%cmp, 0)
  call scale_one_tsum(T0sum(48)%cmp, 0)
  call scale_one_tsum(T0sum(49)%cmp, 0)
  call scale_one_tsum(T0sum(50)%cmp, 0)
  call scale_one_tsum(T0sum(51)%cmp, 0)
  call scale_one_tsum(T0sum(52)%cmp, 0)
  call scale_one_tsum(T0sum(53)%cmp, 0)
  call scale_one_tsum(T0sum(54)%cmp, 0)
  call scale_one_tsum(T0sum(55)%cmp, 0)
  call scale_one_tsum(T0sum(56)%cmp, 0)
  call scale_one_tsum(T0sum(57)%cmp, 0)
  call scale_one_tsum(T0sum(58)%cmp, 0)
  call scale_one_tsum(T0sum(59)%cmp, 0)
  call scale_one_tsum(T0sum(60)%cmp, 0)
  call scale_one_tsum(T0sum(61)%cmp, 0)
  call scale_one_tsum(T0sum(62)%cmp, 0)
  call scale_one_tsum(T0sum(63)%cmp, 0)
  call scale_one_tsum(T0sum(64)%cmp, 0)
  call scale_one_tsum(T0sum(65)%cmp, 0)
  call scale_one_tsum(T0sum(66)%cmp, 0)
  call scale_one_tsum(T0sum(67)%cmp, 0)
  call scale_one_tsum(T0sum(68)%cmp, 0)
  call scale_one_tsum(T0sum(69)%cmp, 0)
  call scale_one_tsum(T0sum(70)%cmp, 0)
  call scale_one_tsum(T0sum(71)%cmp, 0)
  call scale_one_tsum(T0sum(72)%cmp, 0)
  call scale_one_tsum(T0sum(73)%cmp, 0)
  call scale_one_tsum(T0sum(74)%cmp, 0)
  call scale_one_tsum(T0sum(75)%cmp, 0)
  call scale_one_tsum(T0sum(76)%cmp, 0)
  call scale_one_tsum(T0sum(77)%cmp, 0)
  call scale_one_tsum(T0sum(78)%cmp, 0)
  call scale_one_tsum(T0sum(79)%cmp, 0)
  call scale_one_tsum(T0sum(80)%cmp, 0)
  call scale_one_tsum(T0sum(81)%cmp, 0)
  call scale_one_tsum(T0sum(82)%cmp, 0)
  call scale_one_tsum(T0sum(83)%cmp, 0)
  call scale_one_tsum(T0sum(84)%cmp, 0)
  call scale_one_tsum(T0sum(85)%cmp, 0)
  call scale_one_tsum(T0sum(86)%cmp, 0)
  call scale_one_tsum(T0sum(87)%cmp, 0)
  call scale_one_tsum(T0sum(88)%cmp, 0)
  call scale_one_tsum(T0sum(89)%cmp, 0)
  call scale_one_tsum(T0sum(90)%cmp, 0)
  call scale_one_tsum(T0sum(91)%cmp, 0)
  call scale_one_tsum(T0sum(92)%cmp, 0)
  call scale_one_tsum(T0sum(93)%cmp, 0)
  call scale_one_tsum(T0sum(94)%cmp, 0)
  call scale_one_tsum(T0sum(95)%cmp, 0)
  call scale_one_tsum(T0sum(96)%cmp, 0)
  call scale_one_tsum(T0sum(97)%cmp, 0)
  call scale_one_tsum(T0sum(98)%cmp, 0)
  call scale_one_tsum(T0sum(99)%cmp, 0)
  call scale_one_tsum(T0sum(100)%cmp, 0)
  call scale_one_tsum(T0sum(101)%cmp, 0)
  call scale_one_tsum(T0sum(102)%cmp, 0)
  call scale_one_tsum(T0sum(103)%cmp, 0)
  call scale_one_tsum(T0sum(104)%cmp, 0)
  call scale_one_tsum(T0sum(105)%cmp, 0)
  call scale_one_tsum(T0sum(106)%cmp, 0)
  call scale_one_tsum(T0sum(107)%cmp, -2)
  call scale_one_tsum(T0sum(108)%cmp, -2)
  call scale_one_tsum(T0sum(109)%cmp, -2)
  call scale_one_tsum(T0sum(110)%cmp, -2)
  call scale_one_tsum(T0sum(111)%cmp, -2)
  call scale_one_tsum(T0sum(112)%cmp, -2)
  call scale_one_tsum(T0sum(113)%cmp, -2)
  call scale_one_tsum(T0sum(114)%cmp, -2)
  call scale_one_tsum(T0sum(115)%cmp, -2)
  call scale_one_tsum(T0sum(116)%cmp, -2)
  call scale_one_tsum(T0sum(117)%cmp, -2)
  call scale_one_tsum(T0sum(118)%cmp, -2)
  call scale_one_tsum(T0sum(119)%cmp, -2)
  call scale_one_tsum(T0sum(120)%cmp, -2)
  call scale_one_tsum(T0sum(121)%cmp, -2)
  call scale_one_tsum(T0sum(122)%cmp, -2)
  call scale_one_tsum(T0sum(123)%cmp, -2)
  call scale_one_tsum(T0sum(124)%cmp, -2)
  call scale_one_tsum(T0sum(125)%cmp, -2)
  call scale_one_tsum(T0sum(126)%cmp, -2)
  call scale_one_tsum(T0sum(127)%cmp, -2)
  call scale_one_tsum(T0sum(128)%cmp, -2)
  call scale_one_tsum(T0sum(129)%cmp, -2)
  call scale_one_tsum(T0sum(130)%cmp, -2)
  call scale_one_tsum(T0sum(131)%cmp, -2)
  call scale_one_tsum(T0sum(132)%cmp, -2)
  call scale_one_tsum(T0sum(133)%cmp, -2)
  call scale_one_tsum(T0sum(134)%cmp, -2)
  call scale_one_tsum(T0sum(135)%cmp, -2)
  call scale_one_tsum(T0sum(136)%cmp, -2)
  call scale_one_tsum(T0sum(137)%cmp, -2)
  call scale_one_tsum(T0sum(138)%cmp, -2)
  call scale_one_tsum(T0sum(139)%cmp, -2)
  call scale_one_tsum(T0sum(140)%cmp, -2)
  call scale_one_tsum(T0sum(141)%cmp, -2)
  call scale_one_tsum(T0sum(142)%cmp, -2)
  call scale_one_tsum(T0sum(143)%cmp, -2)
  call scale_one_tsum(T0sum(144)%cmp, -2)
  call scale_one_tsum(T0sum(145)%cmp, -2)
  call scale_one_tsum(T0sum(146)%cmp, -2)
  call scale_one_tsum(T0sum(147)%cmp, -2)
  call scale_one_tsum(T0sum(148)%cmp, -2)
  call scale_one_tsum(T0sum(149)%cmp, -2)
  call scale_one_tsum(T0sum(150)%cmp, -2)
  call scale_one_tsum(T0sum(151)%cmp, -2)
  call scale_one_tsum(T0sum(152)%cmp, -2)
  call scale_one_tsum(T0sum(153)%cmp, -2)
  call scale_one_tsum(T0sum(154)%cmp, -2)
  call scale_one_tsum(T0sum(155)%cmp, -2)
  call scale_one_tsum(T0sum(156)%cmp, -2)
  call scale_one_tsum(T0sum(157)%cmp, -2)
  call scale_one_tsum(T0sum(158)%cmp, -2)
  call scale_one_tsum(T0sum(159)%cmp, -2)
  call scale_one_tsum(T0sum(160)%cmp, -2)
  call scale_one_tsum(T0sum(161)%cmp, -2)
  call scale_one_tsum(T0sum(162)%cmp, -2)
  call scale_one_tsum(T0sum(163)%cmp, -2)
  call scale_one_tsum(T0sum(164)%cmp, -2)
  call scale_one_tsum(T0sum(165)%cmp, -2)
  call scale_one_tsum(T0sum(166)%cmp, -2)
  call scale_one_tsum(T0sum(167)%cmp, -2)
  call scale_one_tsum(T0sum(168)%cmp, -2)
  call scale_one_tsum(T0sum(169)%cmp, -2)
  call scale_one_tsum(T0sum(170)%cmp, -2)
  call scale_one_tsum(T0sum(171)%cmp, -2)
  call scale_one_tsum(T0sum(172)%cmp, -2)
  call scale_one_tsum(T0sum(173)%cmp, -2)
  call scale_one_tsum(T0sum(174)%cmp, -2)
  call scale_one_tsum(T0sum(175)%cmp, -2)
  call scale_one_tsum(T0sum(176)%cmp, -2)
  call scale_one_tsum(T0sum(177)%cmp, -2)
  call scale_one_tsum(T0sum(178)%cmp, -2)
  call scale_one_tsum(T0sum(179)%cmp, -2)
  call scale_one_tsum(T0sum(180)%cmp, -2)
  call scale_one_tsum(T0sum(181)%cmp, -2)
  call scale_one_tsum(T0sum(182)%cmp, -2)
  call scale_one_tsum(T0sum(183)%cmp, -2)
  call scale_one_tsum(T0sum(184)%cmp, -2)
  call scale_one_tsum(T0sum(185)%cmp, -2)
  call scale_one_tsum(T0sum(186)%cmp, -2)
  call scale_one_tsum(T0sum(187)%cmp, -2)
  call scale_one_tsum(T0sum(188)%cmp, -2)
  call scale_one_tsum(T0sum(189)%cmp, -2)
  call scale_one_tsum(T0sum(190)%cmp, -2)
  call scale_one_tsum(T0sum(191)%cmp, -2)
  call scale_one_tsum(T0sum(192)%cmp, -2)
  call scale_one_tsum(T0sum(193)%cmp, -2)
  call scale_one_tsum(T0sum(194)%cmp, -2)
  call scale_one_tsum(T0sum(195)%cmp, -2)
  call scale_one_tsum(T0sum(196)%cmp, -2)
  call scale_one_tsum(T0sum(197)%cmp, -2)
  call scale_one_tsum(T0sum(198)%cmp, -2)
  call scale_one_tsum(T0sum(199)%cmp, -2)
  call scale_one_tsum(T0sum(200)%cmp, -2)
  call scale_one_tsum(T0sum(201)%cmp, -2)
  call scale_one_tsum(T0sum(202)%cmp, -2)
  call scale_one_tsum(T0sum(203)%cmp, -2)
  call scale_one_tsum(T0sum(204)%cmp, -2)
  call scale_one_tsum(T0sum(205)%cmp, -2)
  call scale_one_tsum(T0sum(206)%cmp, -2)
  call scale_one_tsum(T0sum(207)%cmp, -2)
  call scale_one_tsum(T0sum(208)%cmp, -2)
  call scale_one_tsum(T0sum(209)%cmp, -2)
  call scale_one_tsum(T0sum(210)%cmp, -2)
  call scale_one_tsum(T0sum(211)%cmp, -2)
  call scale_one_tsum(T0sum(212)%cmp, -2)
  call scale_one_tsum(T0sum(213)%cmp, -2)
  call scale_one_tsum(T0sum(214)%cmp, -2)
  call scale_one_tsum(T0sum(215)%cmp, -2)
  call scale_one_tsum(T0sum(216)%cmp, -2)
  call scale_one_tsum(T0sum(217)%cmp, -2)
  call scale_one_tsum(T0sum(218)%cmp, -2)
  call scale_one_tsum(T0sum(219)%cmp, -2)
  call scale_one_tsum(T0sum(220)%cmp, -2)
  call scale_one_tsum(T0sum(221)%cmp, -2)
  call scale_one_tsum(T0sum(222)%cmp, -2)
  call scale_one_tsum(T1sum(37)%cmp, -2)
  call scale_one_tsum(T1sum(38)%cmp, -2)
  call scale_one_tsum(T1sum(39)%cmp, -2)
  call scale_one_tsum(T1sum(40)%cmp, -2)
  call scale_one_tsum(T1sum(41)%cmp, -2)
  call scale_one_tsum(T1sum(42)%cmp, -2)
  call scale_one_tsum(T1sum(43)%cmp, -2)
  call scale_one_tsum(T1sum(44)%cmp, -2)
  call scale_one_tsum(T1sum(45)%cmp, -2)
  call scale_one_tsum(T1sum(46)%cmp, -2)
  call scale_one_tsum(T1sum(47)%cmp, -2)
  call scale_one_tsum(T1sum(48)%cmp, -2)
  call scale_one_tsum(T1sum(49)%cmp, -2)
  call scale_one_tsum(T1sum(50)%cmp, -2)
  call scale_one_tsum(T1sum(51)%cmp, -2)
  call scale_one_tsum(T1sum(52)%cmp, -2)
  call scale_one_tsum(T1sum(53)%cmp, -2)
  call scale_one_tsum(T1sum(54)%cmp, -2)
  call scale_one_tsum(T1sum(55)%cmp, -2)
  call scale_one_tsum(T1sum(56)%cmp, -2)
  call scale_one_tsum(T1sum(57)%cmp, -2)
  call scale_one_tsum(T1sum(58)%cmp, -2)
  call scale_one_tsum(T1sum(59)%cmp, -2)
  call scale_one_tsum(T1sum(60)%cmp, -2)
  call scale_one_tsum(T1sum(61)%cmp, -2)
  call scale_one_tsum(T1sum(62)%cmp, -2)
  call scale_one_tsum(T1sum(63)%cmp, -2)
  call scale_one_tsum(T0sum(223)%cmp, -2)
  call scale_one_tsum(T0sum(224)%cmp, -2)
  call scale_one_tsum(T0sum(225)%cmp, -2)
  call scale_one_tsum(T0sum(226)%cmp, -2)
  call scale_one_tsum(T0sum(227)%cmp, -4)
  call scale_one_tsum(T0sum(228)%cmp, -4)
  call scale_one_tsum(T0sum(229)%cmp, -4)
  call scale_one_tsum(T0sum(230)%cmp, -4)
  call scale_one_tsum(T0sum(231)%cmp, -4)
  call scale_one_tsum(T0sum(232)%cmp, -4)
  call scale_one_tsum(T0sum(233)%cmp, -4)
  call scale_one_tsum(T0sum(234)%cmp, -4)
  call scale_one_tsum(T0sum(235)%cmp, -4)
  call scale_one_tsum(T0sum(236)%cmp, -4)
  call scale_one_tsum(T0sum(237)%cmp, -4)
  call scale_one_tsum(T0sum(238)%cmp, -4)
  call scale_one_tsum(T0sum(239)%cmp, -4)
  call scale_one_tsum(T0sum(240)%cmp, -4)
  call scale_one_tsum(T0sum(241)%cmp, -4)
  call scale_one_tsum(T0sum(242)%cmp, -4)
  call scale_one_tsum(T0sum(243)%cmp, -4)
  call scale_one_tsum(T0sum(244)%cmp, -4)
  call scale_one_tsum(T0sum(245)%cmp, -4)
  call scale_one_tsum(T0sum(246)%cmp, -4)
  call scale_one_tsum(T0sum(247)%cmp, -4)
  call scale_one_tsum(T0sum(248)%cmp, -4)
  call scale_one_tsum(T0sum(249)%cmp, -4)
  call scale_one_tsum(T0sum(250)%cmp, -4)
  call scale_one_tsum(T0sum(251)%cmp, -4)
  call scale_one_tsum(T0sum(252)%cmp, -4)
  call scale_one_tsum(T0sum(253)%cmp, -4)
  call scale_one_tsum(T0sum(254)%cmp, -4)
  call scale_one_tsum(T0sum(255)%cmp, -4)
  call scale_one_tsum(T0sum(256)%cmp, -4)
  call scale_one_tsum(T0sum(257)%cmp, -4)
  call scale_one_tsum(T0sum(258)%cmp, -4)
  call scale_one_tsum(T0sum(259)%cmp, -4)
  call scale_one_tsum(T0sum(260)%cmp, -4)
  call scale_one_tsum(T0sum(261)%cmp, -4)
  call scale_one_tsum(T0sum(262)%cmp, -4)
  call scale_one_tsum(T0sum(263)%cmp, -4)
  call scale_one_tsum(T0sum(264)%cmp, -4)
  call scale_one_tsum(T0sum(265)%cmp, -4)
  call scale_one_tsum(T0sum(266)%cmp, -4)
  call scale_one_tsum(T0sum(267)%cmp, -4)
  call scale_one_tsum(T0sum(268)%cmp, -4)
  call scale_one_tsum(T0sum(269)%cmp, -4)
  call scale_one_tsum(T0sum(270)%cmp, -4)
  call scale_one_tsum(T0sum(271)%cmp, -4)
  call scale_one_tsum(T0sum(272)%cmp, -4)
  call scale_one_tsum(T0sum(273)%cmp, -4)
  call scale_one_tsum(T0sum(274)%cmp, -4)
  call scale_one_tsum(T0sum(275)%cmp, -4)
  call scale_one_tsum(T0sum(276)%cmp, -4)
  call scale_one_tsum(T0sum(277)%cmp, -4)
  call scale_one_tsum(T0sum(278)%cmp, -4)
  call scale_one_tsum(T0sum(279)%cmp, -4)

end subroutine scale_tensor_sum

! **********************************************************************
subroutine set_integral_masses_and_momenta()
! **********************************************************************

  use ol_parameters_decl_/**/REALKIND
  momenta_1 = [ 0, 0 ]
  momenta_2 = [ 32, 31 ]
  momenta_3 = [ 34, 29 ]
  momenta_4 = [ 35, 28 ]
  momenta_5 = [ 38, 25 ]
  momenta_6 = [ 40, 23 ]
  momenta_7 = [ 41, 22 ]
  momenta_8 = [ 42, 21 ]
  momenta_9 = [ 43, 20 ]
  momenta_10 = [ 44, 19 ]
  momenta_11 = [ 46, 17 ]
  momenta_12 = [ 47, 16 ]
  momenta_13 = [ 48, 15 ]
  momenta_14 = [ 49, 14 ]
  momenta_15 = [ 50, 13 ]
  momenta_16 = [ 51, 12 ]
  momenta_17 = [ 52, 11 ]
  momenta_18 = [ 53, 10 ]
  momenta_19 = [ 54, 9 ]
  momenta_20 = [ 55, 8 ]
  momenta_21 = [ 56, 7 ]
  momenta_22 = [ 57, 6 ]
  momenta_23 = [ 58, 5 ]
  momenta_24 = [ 59, 4 ]
  momenta_25 = [ 60, 3 ]
  momenta_26 = [ 61, 2 ]
  momenta_27 = [ 62, 1 ]
  momenta_28 = [ 32, 2, 29 ]
  momenta_29 = [ 32, 3, 28 ]
  momenta_30 = [ 32, 6, 25 ]
  momenta_31 = [ 32, 8, 23 ]
  momenta_32 = [ 32, 9, 22 ]
  momenta_33 = [ 32, 10, 21 ]
  momenta_34 = [ 32, 11, 20 ]
  momenta_35 = [ 32, 12, 19 ]
  momenta_36 = [ 32, 14, 17 ]
  momenta_37 = [ 32, 15, 16 ]
  momenta_38 = [ 32, 19, 12 ]
  momenta_39 = [ 32, 23, 8 ]
  momenta_40 = [ 34, 1, 28 ]
  momenta_41 = [ 34, 4, 25 ]
  momenta_42 = [ 34, 8, 21 ]
  momenta_43 = [ 34, 12, 17 ]
  momenta_44 = [ 34, 13, 16 ]
  momenta_45 = [ 34, 17, 12 ]
  momenta_46 = [ 35, 8, 20 ]
  momenta_47 = [ 35, 12, 16 ]
  momenta_48 = [ 35, 16, 12 ]
  momenta_49 = [ 35, 20, 8 ]
  momenta_50 = [ 38, 8, 17 ]
  momenta_51 = [ 38, 9, 16 ]
  momenta_52 = [ 40, 1, 22 ]
  momenta_53 = [ 40, 2, 21 ]
  momenta_54 = [ 40, 3, 20 ]
  momenta_55 = [ 40, 4, 19 ]
  momenta_56 = [ 40, 7, 16 ]
  momenta_57 = [ 40, 19, 4 ]
  momenta_58 = [ 41, 2, 20 ]
  momenta_59 = [ 41, 6, 16 ]
  momenta_60 = [ 42, 1, 20 ]
  momenta_61 = [ 42, 4, 17 ]
  momenta_62 = [ 42, 5, 16 ]
  momenta_63 = [ 43, 4, 16 ]
  momenta_64 = [ 43, 16, 4 ]
  momenta_65 = [ 44, 2, 17 ]
  momenta_66 = [ 44, 3, 16 ]
  momenta_67 = [ 46, 1, 16 ]
  momenta_68 = [ 48, 1, 14 ]
  momenta_69 = [ 48, 2, 13 ]
  momenta_70 = [ 48, 3, 12 ]
  momenta_71 = [ 48, 4, 11 ]
  momenta_72 = [ 48, 5, 10 ]
  momenta_73 = [ 48, 6, 9 ]
  momenta_74 = [ 48, 7, 8 ]
  momenta_75 = [ 48, 8, 7 ]
  momenta_76 = [ 48, 9, 6 ]
  momenta_77 = [ 48, 10, 5 ]
  momenta_78 = [ 48, 11, 4 ]
  momenta_79 = [ 48, 12, 3 ]
  momenta_80 = [ 48, 13, 2 ]
  momenta_81 = [ 48, 14, 1 ]
  momenta_82 = [ 49, 2, 12 ]
  momenta_83 = [ 49, 4, 10 ]
  momenta_84 = [ 49, 6, 8 ]
  momenta_85 = [ 49, 8, 6 ]
  momenta_86 = [ 49, 10, 4 ]
  momenta_87 = [ 49, 12, 2 ]
  momenta_88 = [ 50, 1, 12 ]
  momenta_89 = [ 50, 4, 9 ]
  momenta_90 = [ 50, 5, 8 ]
  momenta_91 = [ 50, 8, 5 ]
  momenta_92 = [ 50, 9, 4 ]
  momenta_93 = [ 50, 12, 1 ]
  momenta_94 = [ 51, 4, 8 ]
  momenta_95 = [ 51, 8, 4 ]
  momenta_96 = [ 52, 1, 10 ]
  momenta_97 = [ 52, 2, 9 ]
  momenta_98 = [ 52, 3, 8 ]
  momenta_99 = [ 52, 8, 3 ]
  momenta_100 = [ 52, 9, 2 ]
  momenta_101 = [ 52, 10, 1 ]
  momenta_102 = [ 53, 2, 8 ]
  momenta_103 = [ 53, 8, 2 ]
  momenta_104 = [ 54, 1, 8 ]
  momenta_105 = [ 54, 8, 1 ]
  momenta_106 = [ 56, 1, 6 ]
  momenta_107 = [ 56, 2, 5 ]
  momenta_108 = [ 56, 3, 4 ]
  momenta_109 = [ 56, 4, 3 ]
  momenta_110 = [ 56, 5, 2 ]
  momenta_111 = [ 56, 6, 1 ]
  momenta_112 = [ 57, 2, 4 ]
  momenta_113 = [ 57, 4, 2 ]
  momenta_114 = [ 58, 1, 4 ]
  momenta_115 = [ 58, 4, 1 ]
  momenta_116 = [ 60, 1, 2 ]
  momenta_117 = [ 60, 2, 1 ]
  momenta_118 = [ 32, 2, 1, 28 ]
  momenta_119 = [ 32, 2, 4, 25 ]
  momenta_120 = [ 32, 2, 8, 21 ]
  momenta_121 = [ 32, 2, 12, 17 ]
  momenta_122 = [ 32, 2, 13, 16 ]
  momenta_123 = [ 32, 2, 17, 12 ]
  momenta_124 = [ 32, 3, 8, 20 ]
  momenta_125 = [ 32, 3, 12, 16 ]
  momenta_126 = [ 32, 3, 16, 12 ]
  momenta_127 = [ 32, 3, 20, 8 ]
  momenta_128 = [ 32, 6, 8, 17 ]
  momenta_129 = [ 32, 6, 9, 16 ]
  momenta_130 = [ 32, 8, 1, 22 ]
  momenta_131 = [ 32, 8, 2, 21 ]
  momenta_132 = [ 32, 8, 3, 20 ]
  momenta_133 = [ 32, 8, 4, 19 ]
  momenta_134 = [ 32, 8, 7, 16 ]
  momenta_135 = [ 32, 9, 2, 20 ]
  momenta_136 = [ 32, 9, 6, 16 ]
  momenta_137 = [ 32, 10, 1, 20 ]
  momenta_138 = [ 32, 10, 4, 17 ]
  momenta_139 = [ 32, 10, 5, 16 ]
  momenta_140 = [ 32, 11, 4, 16 ]
  momenta_141 = [ 32, 12, 2, 17 ]
  momenta_142 = [ 32, 12, 3, 16 ]
  momenta_143 = [ 32, 14, 1, 16 ]
  momenta_144 = [ 32, 19, 4, 8 ]
  momenta_145 = [ 34, 1, 12, 16 ]
  momenta_146 = [ 34, 1, 16, 12 ]
  momenta_147 = [ 34, 4, 8, 17 ]
  momenta_148 = [ 34, 4, 9, 16 ]
  momenta_149 = [ 34, 8, 4, 17 ]
  momenta_150 = [ 34, 8, 5, 16 ]
  momenta_151 = [ 34, 12, 1, 16 ]
  momenta_152 = [ 35, 8, 4, 16 ]
  momenta_153 = [ 35, 16, 4, 8 ]
  momenta_154 = [ 38, 8, 1, 16 ]
  momenta_155 = [ 40, 1, 2, 20 ]
  momenta_156 = [ 40, 1, 6, 16 ]
  momenta_157 = [ 40, 2, 1, 20 ]
  momenta_158 = [ 40, 2, 5, 16 ]
  momenta_159 = [ 40, 3, 4, 16 ]
  momenta_160 = [ 40, 3, 16, 4 ]
  momenta_161 = [ 40, 4, 3, 16 ]
  momenta_162 = [ 41, 2, 4, 16 ]
  momenta_163 = [ 42, 1, 4, 16 ]
  momenta_164 = [ 42, 4, 1, 16 ]
  momenta_165 = [ 44, 2, 1, 16 ]
  momenta_166 = [ 48, 1, 2, 12 ]
  momenta_167 = [ 48, 1, 4, 10 ]
  momenta_168 = [ 48, 1, 8, 6 ]
  momenta_169 = [ 48, 1, 12, 2 ]
  momenta_170 = [ 48, 2, 1, 12 ]
  momenta_171 = [ 48, 2, 4, 9 ]
  momenta_172 = [ 48, 2, 8, 5 ]
  momenta_173 = [ 48, 2, 12, 1 ]
  momenta_174 = [ 48, 3, 4, 8 ]
  momenta_175 = [ 48, 3, 8, 4 ]
  momenta_176 = [ 48, 4, 1, 10 ]
  momenta_177 = [ 48, 4, 2, 9 ]
  momenta_178 = [ 48, 4, 3, 8 ]
  momenta_179 = [ 48, 5, 2, 8 ]
  momenta_180 = [ 48, 5, 8, 2 ]
  momenta_181 = [ 48, 6, 1, 8 ]
  momenta_182 = [ 48, 6, 8, 1 ]
  momenta_183 = [ 48, 8, 1, 6 ]
  momenta_184 = [ 48, 8, 2, 5 ]
  momenta_185 = [ 48, 8, 3, 4 ]
  momenta_186 = [ 48, 8, 4, 3 ]
  momenta_187 = [ 48, 9, 2, 4 ]
  momenta_188 = [ 48, 9, 4, 2 ]
  momenta_189 = [ 48, 10, 1, 4 ]
  momenta_190 = [ 48, 10, 4, 1 ]
  momenta_191 = [ 48, 12, 2, 1 ]
  momenta_192 = [ 49, 2, 4, 8 ]
  momenta_193 = [ 49, 2, 8, 4 ]
  momenta_194 = [ 49, 4, 8, 2 ]
  momenta_195 = [ 49, 8, 4, 2 ]
  momenta_196 = [ 50, 1, 4, 8 ]
  momenta_197 = [ 50, 1, 8, 4 ]
  momenta_198 = [ 50, 4, 8, 1 ]
  momenta_199 = [ 50, 8, 4, 1 ]
  momenta_200 = [ 52, 1, 2, 8 ]
  momenta_201 = [ 52, 2, 1, 8 ]
  momenta_202 = [ 52, 8, 1, 2 ]
  momenta_203 = [ 52, 8, 2, 1 ]
  momenta_204 = [ 56, 1, 2, 4 ]
  momenta_205 = [ 56, 2, 1, 4 ]
  momenta_206 = [ 56, 4, 1, 2 ]
  momenta_207 = [ 56, 4, 2, 1 ]
  momenta_208 = [ 32, 2, 1, 12, 16 ]
  momenta_209 = [ 32, 2, 1, 16, 12 ]
  momenta_210 = [ 32, 2, 4, 8, 17 ]
  momenta_211 = [ 32, 2, 4, 9, 16 ]
  momenta_212 = [ 32, 2, 8, 4, 17 ]
  momenta_213 = [ 32, 2, 8, 5, 16 ]
  momenta_214 = [ 32, 2, 12, 1, 16 ]
  momenta_215 = [ 32, 3, 8, 4, 16 ]
  momenta_216 = [ 32, 3, 16, 4, 8 ]
  momenta_217 = [ 32, 6, 8, 1, 16 ]
  momenta_218 = [ 32, 8, 1, 2, 20 ]
  momenta_219 = [ 32, 8, 1, 6, 16 ]
  momenta_220 = [ 32, 8, 2, 1, 20 ]
  momenta_221 = [ 32, 8, 2, 5, 16 ]
  momenta_222 = [ 32, 8, 3, 4, 16 ]
  momenta_223 = [ 32, 8, 4, 3, 16 ]
  momenta_224 = [ 32, 9, 2, 4, 16 ]
  momenta_225 = [ 32, 10, 1, 4, 16 ]
  momenta_226 = [ 32, 10, 4, 1, 16 ]
  momenta_227 = [ 32, 12, 2, 1, 16 ]
  momenta_228 = [ 34, 4, 8, 1, 16 ]
  momenta_229 = [ 34, 8, 4, 1, 16 ]
  momenta_230 = [ 40, 1, 2, 4, 16 ]
  momenta_231 = [ 40, 2, 1, 4, 16 ]
  momenta_232 = [ 48, 1, 4, 8, 2 ]
  momenta_233 = [ 48, 1, 8, 4, 2 ]
  momenta_234 = [ 48, 2, 4, 8, 1 ]
  momenta_235 = [ 48, 2, 8, 4, 1 ]
  momenta_236 = [ 48, 4, 1, 2, 8 ]
  momenta_237 = [ 48, 4, 2, 1, 8 ]
  momenta_238 = [ 48, 8, 1, 2, 4 ]
  momenta_239 = [ 48, 8, 2, 1, 4 ]
  momenta_240 = [ 32, 2, 4, 8, 1, 16 ]
  momenta_241 = [ 32, 2, 8, 4, 1, 16 ]
  momenta_242 = [ 32, 8, 1, 2, 4, 16 ]
  momenta_243 = [ 32, 8, 2, 1, 4, 16 ]

  masses2_1 = [ 0, 0 ]
  masses2_2 = [ nMB, 0 ]
  masses2_3 = [ nMT, 0 ]
  masses2_4 = [ 0, nMB ]
  masses2_5 = [ nMB, nMB ]
  masses2_6 = [ nMT, nMB ]
  masses2_7 = [ 0, nMT ]
  masses2_8 = [ nMB, nMT ]
  masses2_9 = [ nMT, nMT ]
  masses2_10 = [ 0, 0, 0 ]
  masses2_11 = [ nMB, 0, 0 ]
  masses2_12 = [ nMT, 0, 0 ]
  masses2_13 = [ 0, 0, nMT ]
  masses2_14 = [ nMB, 0, nMT ]
  masses2_15 = [ nMT, 0, nMT ]
  masses2_16 = [ nMT, nMB, 0 ]
  masses2_17 = [ 0, nMB, nMB ]
  masses2_18 = [ nMB, nMB, nMB ]
  masses2_19 = [ nMT, nMB, nMB ]
  masses2_20 = [ 0, nMB, nMT ]
  masses2_21 = [ nMT, nMB, nMT ]
  masses2_22 = [ 0, nMT, 0 ]
  masses2_23 = [ nMB, nMT, 0 ]
  masses2_24 = [ nMT, nMT, 0 ]
  masses2_25 = [ nMB, nMT, nMB ]
  masses2_26 = [ 0, nMT, nMT ]
  masses2_27 = [ nMB, nMT, nMT ]
  masses2_28 = [ nMT, nMT, nMT ]
  masses2_29 = [ 0, 0, 0, 0 ]
  masses2_30 = [ nMB, 0, 0, 0 ]
  masses2_31 = [ nMT, 0, 0, 0 ]
  masses2_32 = [ 0, 0, 0, nMT ]
  masses2_33 = [ nMB, 0, 0, nMT ]
  masses2_34 = [ nMT, 0, 0, nMT ]
  masses2_35 = [ 0, 0, nMT, 0 ]
  masses2_36 = [ nMB, 0, nMT, nMT ]
  masses2_37 = [ nMT, 0, nMT, nMT ]
  masses2_38 = [ nMT, nMB, nMB, 0 ]
  masses2_39 = [ nMT, nMB, nMB, nMB ]
  masses2_40 = [ 0, nMB, nMB, nMT ]
  masses2_41 = [ nMT, nMB, nMB, nMT ]
  masses2_42 = [ nMB, nMB, nMT, 0 ]
  masses2_43 = [ nMT, nMB, nMT, 0 ]
  masses2_44 = [ 0, nMT, 0, 0 ]
  masses2_45 = [ nMB, nMT, 0, 0 ]
  masses2_46 = [ nMT, nMT, 0, 0 ]
  masses2_47 = [ nMB, nMT, 0, nMT ]
  masses2_48 = [ nMT, nMT, 0, nMT ]
  masses2_49 = [ nMB, nMT, nMT, 0 ]
  masses2_50 = [ nMT, nMT, nMT, 0 ]
  masses2_51 = [ nMB, nMT, nMT, nMB ]
  masses2_52 = [ nMB, nMT, nMT, nMT ]
  masses2_53 = [ 0, 0, 0, 0, 0 ]
  masses2_54 = [ nMB, 0, 0, 0, nMT ]
  masses2_55 = [ 0, 0, 0, nMT, 0 ]
  masses2_56 = [ 0, 0, nMT, 0, 0 ]
  masses2_57 = [ nMT, nMB, nMB, nMT, 0 ]
  masses2_58 = [ nMB, nMT, 0, 0, 0 ]
  masses2_59 = [ nMT, nMT, 0, 0, 0 ]
  masses2_60 = [ nMB, nMT, 0, 0, nMT ]
  masses2_61 = [ nMB, nMT, 0, nMT, nMT ]
  masses2_62 = [ nMB, nMT, nMT, 0, nMT ]
  masses2_63 = [ 0, 0, 0, nMT, 0, 0 ]
  masses2_64 = [ nMB, nMT, 0, 0, 0, nMT ]


end subroutine  set_integral_masses_and_momenta

! **********************************************************************
subroutine integrate_tensor_sum(M2out)
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND ! only: ZERO, masses
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: a_switch
#endif
  use ol_parameters_init_/**/REALKIND, only: init_met, add_met, met_to_real
  use ol_loop_routines_/**/REALKIND, only: TI_call_OL
  implicit none
  real(REALKIND), intent(out) :: M2out
  type(met) :: M2
  call init_met(M2)

sbarray_1 = [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15]
sbarray_2 = [16, 2, 17, 18, 19, 6, 20, 21, 22, 10, 11, 12, 23, 24, 25]
sbarray_3 = [26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40]
sbarray_4 = [41, 27, 42, 43, 44, 31, 45, 46, 47, 35, 36, 37, 48, 49, 50]
sbarray_5 = [51, 52, 53, 54, 15]
sbarray_6 = [55, 56, 53, 57, 25]
sbarray_7 = [58, 59, 60, 61, 40]
sbarray_8 = [62, 63, 60, 64, 50]
sbarray_9 = [1, 2, 3, 4, 5]
sbarray_10 = [1, 6, 7, 8, 9]
sbarray_11 = [2, 6, 10, 11, 12]
sbarray_12 = [3, 7, 10, 13, 14]
sbarray_13 = [16, 2, 17, 18, 19]
sbarray_14 = [16, 6, 20, 21, 22]
sbarray_15 = [17, 20, 10, 23, 24]
sbarray_16 = [26, 27, 28, 29, 30]
sbarray_17 = [26, 31, 32, 33, 34]
sbarray_18 = [27, 31, 35, 36, 37]
sbarray_19 = [28, 32, 35, 38, 39]
sbarray_20 = [41, 27, 42, 43, 44]
sbarray_21 = [41, 31, 45, 46, 47]
sbarray_22 = [42, 45, 35, 48, 49]
sbarray_23 = [43, 46, 36, 48, 50]
sbarray_24 = [29, 33, 36, 38, 40]
sbarray_25 = [18, 21, 11, 23, 25]
sbarray_26 = [4, 8, 11, 13, 15]
sbarray_27 = [65, 66, 67, 68, 69]
sbarray_28 = [70, 71, 67, 72, 73]
sbarray_29 = [74, 75, 76, 77, 78]
sbarray_30 = [79, 80, 76, 81, 82]
sbarray_31 = [83, 84, 85, 86, 87]
sbarray_32 = [88, 6, 89, 90, 91]
sbarray_33 = [92, 93, 10, 94, 95]
sbarray_34 = [96, 97, 98, 99, 100]
sbarray_35 = [101, 31, 102, 103, 104]
sbarray_36 = [105, 106, 35, 99, 107]


#ifdef LOOPSQUARED
  if (a_switch == 1 .or. a_switch == 7) then
#endif
  call TI_call_OL(0,0, momenta_203, masses2_44, T0sum(1), M2,[15], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_184, masses2_46, T0sum(2), M2,[54], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_131, masses2_45, T0sum(3), M2,[13], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_202, masses2_44, T0sum(4), M2,[25], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_183, masses2_46, T0sum(5), M2,[57], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_130, masses2_45, T0sum(6), M2,[23], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_193, masses2_32, T0sum(7), M2,[40], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_172, masses2_32, T0sum(8), M2,[61], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_120, masses2_32, T0sum(9), M2,[38], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_192, masses2_32, T0sum(10), M2,[50], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_171, masses2_32, T0sum(11), M2,[64], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_119, masses2_32, T0sum(12), M2,[48], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_205, masses2_31, T0sum(13), M2,[51], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_157, masses2_30, T0sum(14), M2,[4], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_189, masses2_46, T0sum(15), M2,[52], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_137, masses2_45, T0sum(16), M2,[8], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_185, masses2_46, T0sum(17), M2,[53], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_132, masses2_45, T0sum(18), M2,[11], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_204, masses2_31, T0sum(19), M2,[55], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_155, masses2_30, T0sum(20), M2,[18], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_187, masses2_46, T0sum(21), M2,[56], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_135, masses2_45, T0sum(22), M2,[21], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_199, masses2_35, T0sum(23), M2,[58], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_149, masses2_35, T0sum(24), M2,[29], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_190, masses2_35, T0sum(25), M2,[59], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_138, masses2_35, T0sum(26), M2,[33], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_173, masses2_29, T0sum(27), M2,[60], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_121, masses2_29, T0sum(28), M2,[36], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_198, masses2_35, T0sum(29), M2,[62], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_147, masses2_35, T0sum(30), M2,[43], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_182, masses2_35, T0sum(31), M2,[63], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_128, masses2_35, T0sum(32), M2,[46], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_206, masses2_44, T0sum(33), M2,[69], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_176, masses2_46, T0sum(34), M2,[68], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_207, masses2_44, T0sum(35), M2,[73], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_177, masses2_46, T0sum(36), M2,[72], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_196, masses2_32, T0sum(37), M2,[78], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_167, masses2_32, T0sum(38), M2,[77], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_197, masses2_32, T0sum(39), M2,[82], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_168, masses2_32, T0sum(40), M2,[81], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_160, masses2_40, T0sum(41), M2,[87], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_126, masses2_41, T0sum(42), M2,[86], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_175, masses2_50, T0sum(43), M2,[91], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_124, masses2_49, T0sum(44), M2,[90], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_186, masses2_48, T0sum(45), M2,[95], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_133, masses2_47, T0sum(46), M2,[94], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_165, masses2_29, T0sum(47), M2,[101], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_118, masses2_29, T0sum(48), M2,[99], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_191, masses2_29, T0sum(49), M2,[104], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_141, masses2_29, T0sum(50), M2,[103], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_170, masses2_29, T0sum(51), M2,[107], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_163, masses2_33, T0sum(52), M2,[1], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_159, masses2_33, T0sum(53), M2,[2], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_158, masses2_33, T0sum(54), M2,[3], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_140, masses2_47, T0sum(55), M2,[6], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_139, masses2_47, T0sum(56), M2,[7], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_134, masses2_47, T0sum(57), M2,[10], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_162, masses2_33, T0sum(58), M2,[16], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_156, masses2_33, T0sum(59), M2,[17], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_136, masses2_47, T0sum(60), M2,[20], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_164, masses2_44, T0sum(61), M2,[26], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_151, masses2_29, T0sum(62), M2,[27], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_150, masses2_35, T0sum(63), M2,[28], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_143, masses2_29, T0sum(64), M2,[31], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_139, masses2_35, T0sum(65), M2,[32], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_122, masses2_29, T0sum(66), M2,[35], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_154, masses2_44, T0sum(67), M2,[41], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_148, masses2_35, T0sum(68), M2,[42], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_129, masses2_35, T0sum(69), M2,[45], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_200, masses2_31, T0sum(70), M2,[65], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_179, masses2_46, T0sum(71), M2,[66], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_178, masses2_46, T0sum(72), M2,[67], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_201, masses2_31, T0sum(73), M2,[70], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_181, masses2_46, T0sum(74), M2,[71], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_194, masses2_35, T0sum(75), M2,[74], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_180, masses2_35, T0sum(76), M2,[75], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_169, masses2_29, T0sum(77), M2,[76], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_195, masses2_35, T0sum(78), M2,[79], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_188, masses2_35, T0sum(79), M2,[80], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_153, masses2_43, T0sum(80), M2,[83], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_144, masses2_43, T0sum(81), M2,[84], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_127, masses2_38, T0sum(82), M2,[85], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_152, masses2_47, T0sum(83), M2,[88], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_125, masses2_52, T0sum(84), M2,[89], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_161, masses2_36, T0sum(85), M2,[92], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_142, masses2_52, T0sum(86), M2,[93], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_146, masses2_29, T0sum(87), M2,[96], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_126, masses2_29, T0sum(88), M2,[97], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_123, masses2_29, T0sum(89), M2,[98], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_142, masses2_29, T0sum(90), M2,[102], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_145, masses2_29, T0sum(91), M2,[105], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_125, masses2_29, T0sum(92), M2,[106], ScalarBoxes(:))
  call TI_call_OL(2,0, momenta_142, masses2_52, T0sum(93), M2,[93], ScalarBoxes(:))
  call TI_call_OL(2,0, momenta_126, masses2_29, T0sum(94), M2,[97], ScalarBoxes(:))
  call TI_call_OL(2,0, momenta_125, masses2_29, T0sum(95), M2,[106], ScalarBoxes(:))
  call TI_call_OL(2,0, momenta_142, masses2_29, T0sum(96), M2,[102], ScalarBoxes(:))
  call TI_call_OL(2,0, momenta_142, masses2_39, T0sum(97), M2)
  call TI_call_OL(2,0, momenta_125, masses2_52, T0sum(98), M2,[89], ScalarBoxes(:))
  call TI_call_OL(2,0, momenta_125, masses2_39, T0sum(99), M2)
  call TI_call_OL(2,0, momenta_126, masses2_51, T0sum(100), M2)
  call TI_call_OL(2,0, momenta_126, masses2_41, T0sum(101), M2,[86], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_174, masses2_50, T0sum(102), M2,[95], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_166, masses2_29, T0sum(103), M2,[104], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_142, masses2_39, T0sum(104), M2)
  call TI_call_OL(0,0, momenta_125, masses2_39, T0sum(105), M2)
  call TI_call_OL(0,0, momenta_126, masses2_51, T0sum(106), M2)
  call TI_call_OL(0,0, momenta_66, masses2_19, T0sum(107), M2)
  call TI_call_OL(0,0, momenta_99, masses2_22, T0sum(108), M2)
  call TI_call_OL(0,0, momenta_82, masses2_10, T0sum(109), M2)
  call TI_call_OL(0,0, momenta_98, masses2_26, T0sum(110), M2)
  call TI_call_OL(0,0, momenta_95, masses2_24, T0sum(111), M2)
  call TI_call_OL(0,0, momenta_117, masses2_10, T0sum(112), M2)
  call TI_call_OL(0,0, momenta_87, masses2_10, T0sum(113), M2)
  call TI_call_OL(0,0, momenta_48, masses2_21, T0sum(114), M2)
  call TI_call_OL(0,0, momenta_38, masses2_21, T0sum(115), M2)
  call TI_call_OL(0,0, momenta_29, masses2_19, T0sum(116), M2)
  call TI_call_OL(0,0, momenta_54, masses2_11, T0sum(117), M2)
  call TI_call_OL(0,0, momenta_34, masses2_23, T0sum(118), M2)
  call TI_call_OL(0,0, momenta_31, masses2_23, T0sum(119), M2)
  call TI_call_OL(0,0, momenta_43, masses2_10, T0sum(120), M2)
  call TI_call_OL(0,0, momenta_36, masses2_10, T0sum(121), M2)
  call TI_call_OL(0,0, momenta_28, masses2_10, T0sum(122), M2)
  call TI_call_OL(0,0, momenta_46, masses2_23, T0sum(123), M2)
  call TI_call_OL(0,0, momenta_29, masses2_27, T0sum(124), M2)
  call TI_call_OL(0,0, momenta_55, masses2_14, T0sum(125), M2)
  call TI_call_OL(0,0, momenta_35, masses2_27, T0sum(126), M2)
  call TI_call_OL(0,0, momenta_40, masses2_10, T0sum(127), M2)
  call TI_call_OL(0,0, momenta_29, masses2_10, T0sum(128), M2)
  call TI_call_OL(0,0, momenta_65, masses2_10, T0sum(129), M2)
  call TI_call_OL(0,0, momenta_35, masses2_10, T0sum(130), M2)
  call TI_call_OL(0,0, momenta_54, masses2_17, T0sum(131), M2)
  call TI_call_OL(0,0, momenta_35, masses2_19, T0sum(132), M2)
  call TI_call_OL(0,0, momenta_75, masses2_24, T0sum(133), M2)
  call TI_call_OL(0,0, momenta_69, masses2_10, T0sum(134), M2)
  call TI_call_OL(0,0, momenta_70, masses2_28, T0sum(135), M2)
  call TI_call_OL(0,0, momenta_79, masses2_10, T0sum(136), M2)
  call TI_call_OL(0,0, momenta_108, masses2_12, T0sum(137), M2)
  call TI_call_OL(0,0, momenta_78, masses2_24, T0sum(138), M2)
  call TI_call_OL(0,0, momenta_93, masses2_10, T0sum(139), M2)
  call TI_call_OL(0,0, momenta_81, masses2_10, T0sum(140), M2)
  call TI_call_OL(0,0, momenta_109, masses2_22, T0sum(141), M2)
  call TI_call_OL(0,0, momenta_71, masses2_24, T0sum(142), M2)
  call TI_call_OL(0,0, momenta_88, masses2_10, T0sum(143), M2)
  call TI_call_OL(0,0, momenta_68, masses2_10, T0sum(144), M2)
  call TI_call_OL(0,0, momenta_64, masses2_20, T0sum(145), M2)
  call TI_call_OL(0,0, momenta_57, masses2_20, T0sum(146), M2)
  call TI_call_OL(0,0, momenta_109, masses2_15, T0sum(147), M2)
  call TI_call_OL(0,0, momenta_79, masses2_28, T0sum(148), M2)
  call TI_call_OL(0,0, momenta_67, masses2_10, T0sum(149), M2)
  call TI_call_OL(0,0, momenta_66, masses2_10, T0sum(150), M2)
  call TI_call_OL(0,0, momenta_70, masses2_10, T0sum(151), M2)
  call TI_call_OL(0,0, momenta_108, masses2_26, T0sum(152), M2)
  call TI_call_OL(0,0, momenta_116, masses2_10, T0sum(153), M2)
  call TI_call_OL(0,0, momenta_79, masses2_18, T0sum(154), M2)
  call TI_call_OL(0,0, momenta_70, masses2_18, T0sum(155), M2)
  call TI_call_OL(0,0, momenta_66, masses2_27, T0sum(156), M2)
  call TI_call_OL(0,0, momenta_103, masses2_22, T0sum(157), M2)
  call TI_call_OL(0,0, momenta_101, masses2_22, T0sum(158), M2)
  call TI_call_OL(0,0, momenta_107, masses2_12, T0sum(159), M2)
  call TI_call_OL(0,0, momenta_77, masses2_24, T0sum(160), M2)
  call TI_call_OL(0,0, momenta_53, masses2_11, T0sum(161), M2)
  call TI_call_OL(0,0, momenta_33, masses2_23, T0sum(162), M2)
  call TI_call_OL(0,0, momenta_105, masses2_22, T0sum(163), M2)
  call TI_call_OL(0,0, momenta_100, masses2_22, T0sum(164), M2)
  call TI_call_OL(0,0, momenta_106, masses2_12, T0sum(165), M2)
  call TI_call_OL(0,0, momenta_76, masses2_24, T0sum(166), M2)
  call TI_call_OL(0,0, momenta_52, masses2_11, T0sum(167), M2)
  call TI_call_OL(0,0, momenta_32, masses2_23, T0sum(168), M2)
  call TI_call_OL(0,0, momenta_102, masses2_12, T0sum(169), M2)
  call TI_call_OL(0,0, momenta_95, masses2_13, T0sum(170), M2)
  call TI_call_OL(0,0, momenta_86, masses2_13, T0sum(171), M2)
  call TI_call_OL(0,0, momenta_91, masses2_13, T0sum(172), M2)
  call TI_call_OL(0,0, momenta_77, masses2_13, T0sum(173), M2)
  call TI_call_OL(0,0, momenta_42, masses2_13, T0sum(174), M2)
  call TI_call_OL(0,0, momenta_33, masses2_13, T0sum(175), M2)
  call TI_call_OL(0,0, momenta_112, masses2_12, T0sum(176), M2)
  call TI_call_OL(0,0, momenta_94, masses2_13, T0sum(177), M2)
  call TI_call_OL(0,0, momenta_84, masses2_13, T0sum(178), M2)
  call TI_call_OL(0,0, momenta_89, masses2_13, T0sum(179), M2)
  call TI_call_OL(0,0, momenta_73, masses2_13, T0sum(180), M2)
  call TI_call_OL(0,0, momenta_41, masses2_13, T0sum(181), M2)
  call TI_call_OL(0,0, momenta_30, masses2_13, T0sum(182), M2)
  call TI_call_OL(0,0, momenta_114, masses2_12, T0sum(183), M2)
  call TI_call_OL(0,0, momenta_60, masses2_11, T0sum(184), M2)
  call TI_call_OL(0,0, momenta_58, masses2_11, T0sum(185), M2)
  call TI_call_OL(0,0, momenta_115, masses2_22, T0sum(186), M2)
  call TI_call_OL(0,0, momenta_61, masses2_22, T0sum(187), M2)
  call TI_call_OL(0,0, momenta_50, masses2_22, T0sum(188), M2)
  call TI_call_OL(0,0, momenta_110, masses2_22, T0sum(189), M2)
  call TI_call_OL(0,0, momenta_96, masses2_12, T0sum(190), M2)
  call TI_call_OL(0,0, momenta_72, masses2_24, T0sum(191), M2)
  call TI_call_OL(0,0, momenta_113, masses2_22, T0sum(192), M2)
  call TI_call_OL(0,0, momenta_111, masses2_22, T0sum(193), M2)
  call TI_call_OL(0,0, momenta_97, masses2_12, T0sum(194), M2)
  call TI_call_OL(0,0, momenta_73, masses2_24, T0sum(195), M2)
  call TI_call_OL(0,0, momenta_90, masses2_13, T0sum(196), M2)
  call TI_call_OL(0,0, momenta_83, masses2_13, T0sum(197), M2)
  call TI_call_OL(0,0, momenta_72, masses2_13, T0sum(198), M2)
  call TI_call_OL(0,0, momenta_104, masses2_12, T0sum(199), M2)
  call TI_call_OL(0,0, momenta_92, masses2_13, T0sum(200), M2)
  call TI_call_OL(0,0, momenta_85, masses2_13, T0sum(201), M2)
  call TI_call_OL(0,0, momenta_76, masses2_13, T0sum(202), M2)
  call TI_call_OL(0,0, momenta_63, masses2_14, T0sum(203), M2)
  call TI_call_OL(0,0, momenta_62, masses2_14, T0sum(204), M2)
  call TI_call_OL(0,0, momenta_56, masses2_14, T0sum(205), M2)
  call TI_call_OL(0,0, momenta_37, masses2_27, T0sum(206), M2)
  call TI_call_OL(0,0, momenta_59, masses2_14, T0sum(207), M2)
  call TI_call_OL(0,0, momenta_62, masses2_22, T0sum(208), M2)
  call TI_call_OL(0,0, momenta_44, masses2_10, T0sum(209), M2)
  call TI_call_OL(0,0, momenta_37, masses2_10, T0sum(210), M2)
  call TI_call_OL(0,0, momenta_51, masses2_22, T0sum(211), M2)
  call TI_call_OL(0,0, momenta_98, masses2_12, T0sum(212), M2)
  call TI_call_OL(0,0, momenta_74, masses2_24, T0sum(213), M2)
  call TI_call_OL(0,0, momenta_80, masses2_10, T0sum(214), M2)
  call TI_call_OL(0,0, momenta_94, masses2_24, T0sum(215), M2)
  call TI_call_OL(0,0, momenta_49, masses2_16, T0sum(216), M2)
  call TI_call_OL(0,0, momenta_39, masses2_16, T0sum(217), M2)
  call TI_call_OL(0,0, momenta_47, masses2_27, T0sum(218), M2)
  call TI_call_OL(0,0, momenta_48, masses2_10, T0sum(219), M2)
  call TI_call_OL(0,0, momenta_45, masses2_10, T0sum(220), M2)
  call TI_call_OL(0,0, momenta_38, masses2_10, T0sum(221), M2)
  call TI_call_OL(0,0, momenta_47, masses2_10, T0sum(222), M2)
  call TI_call_OL(0,0, momenta_37, masses2_19, T0sum(223), M2)
  call TI_call_OL(0,0, momenta_47, masses2_19, T0sum(224), M2)
  call TI_call_OL(0,0, momenta_48, masses2_25, T0sum(225), M2)
  call TI_call_OL(0,0, momenta_38, masses2_25, T0sum(226), M2)
  call TI_call_OL(0,0, momenta_25, masses2_5, T0sum(227), M2)
  call TI_call_OL(0,0, momenta_1, masses2_2, T0sum(228), M2)
  call TI_call_OL(0,0, momenta_12, masses2_6, T0sum(229), M2)
  call TI_call_OL(0,0, momenta_10, masses2_6, T0sum(230), M2)
  call TI_call_OL(0,0, momenta_1, masses2_3, T0sum(231), M2)
  call TI_call_OL(0,0, momenta_20, masses2_7, T0sum(232), M2)
  call TI_call_OL(0,0, momenta_25, masses2_1, T0sum(233), M2)
  call TI_call_OL(0,0, momenta_17, masses2_7, T0sum(234), M2)
  call TI_call_OL(0,0, momenta_26, masses2_1, T0sum(235), M2)
  call TI_call_OL(0,0, momenta_16, masses2_1, T0sum(236), M2)
  call TI_call_OL(0,0, momenta_14, masses2_1, T0sum(237), M2)
  call TI_call_OL(0,0, momenta_25, masses2_9, T0sum(238), M2)
  call TI_call_OL(0,0, momenta_24, masses2_3, T0sum(239), M2)
  call TI_call_OL(0,0, momenta_16, masses2_9, T0sum(240), M2)
  call TI_call_OL(0,0, momenta_27, masses2_1, T0sum(241), M2)
  call TI_call_OL(0,0, momenta_4, masses2_6, T0sum(242), M2)
  call TI_call_OL(0,0, momenta_2, masses2_6, T0sum(243), M2)
  call TI_call_OL(0,0, momenta_9, masses2_2, T0sum(244), M2)
  call TI_call_OL(0,0, momenta_6, masses2_2, T0sum(245), M2)
  call TI_call_OL(0,0, momenta_2, masses2_8, T0sum(246), M2)
  call TI_call_OL(0,0, momenta_11, masses2_1, T0sum(247), M2)
  call TI_call_OL(0,0, momenta_3, masses2_1, T0sum(248), M2)
  call TI_call_OL(0,0, momenta_2, masses2_1, T0sum(249), M2)
  call TI_call_OL(0,0, momenta_4, masses2_8, T0sum(250), M2)
  call TI_call_OL(0,0, momenta_10, masses2_8, T0sum(251), M2)
  call TI_call_OL(0,0, momenta_4, masses2_1, T0sum(252), M2)
  call TI_call_OL(0,0, momenta_10, masses2_1, T0sum(253), M2)
  call TI_call_OL(0,0, momenta_9, masses2_4, T0sum(254), M2)
  call TI_call_OL(0,0, momenta_6, masses2_4, T0sum(255), M2)
  call TI_call_OL(0,0, momenta_16, masses2_5, T0sum(256), M2)
  call TI_call_OL(0,0, momenta_21, masses2_3, T0sum(257), M2)
  call TI_call_OL(0,0, momenta_13, masses2_9, T0sum(258), M2)
  call TI_call_OL(0,0, momenta_15, masses2_1, T0sum(259), M2)
  call TI_call_OL(0,0, momenta_13, masses2_1, T0sum(260), M2)
  call TI_call_OL(0,0, momenta_24, masses2_7, T0sum(261), M2)
  call TI_call_OL(0,0, momenta_21, masses2_7, T0sum(262), M2)
  call TI_call_OL(0,0, momenta_17, masses2_3, T0sum(263), M2)
  call TI_call_OL(0,0, momenta_12, masses2_1, T0sum(264), M2)
  call TI_call_OL(0,0, momenta_13, masses2_5, T0sum(265), M2)
  call TI_call_OL(0,0, momenta_12, masses2_8, T0sum(266), M2)
  call TI_call_OL(0,0, momenta_20, masses2_3, T0sum(267), M2)
  call TI_call_OL(0,0, momenta_18, masses2_7, T0sum(268), M2)
  call TI_call_OL(0,0, momenta_23, masses2_3, T0sum(269), M2)
  call TI_call_OL(0,0, momenta_8, masses2_2, T0sum(270), M2)
  call TI_call_OL(0,0, momenta_19, masses2_7, T0sum(271), M2)
  call TI_call_OL(0,0, momenta_22, masses2_3, T0sum(272), M2)
  call TI_call_OL(0,0, momenta_7, masses2_2, T0sum(273), M2)
  call TI_call_OL(0,0, momenta_18, masses2_3, T0sum(274), M2)
  call TI_call_OL(0,0, momenta_23, masses2_7, T0sum(275), M2)
  call TI_call_OL(0,0, momenta_8, masses2_7, T0sum(276), M2)
  call TI_call_OL(0,0, momenta_5, masses2_7, T0sum(277), M2)
  call TI_call_OL(0,0, momenta_22, masses2_7, T0sum(278), M2)
  call TI_call_OL(0,0, momenta_19, masses2_3, T0sum(279), M2)

  call TI_call_OL(0,1, momenta_243, masses2_64, T1sum(1), M2,sbarray_1, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_242, masses2_64, T1sum(2), M2,sbarray_2, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_241, masses2_63, T1sum(3), M2,sbarray_3, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_240, masses2_63, T1sum(4), M2,sbarray_4, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_239, masses2_59, T1sum(5), M2,sbarray_5, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_238, masses2_59, T1sum(6), M2,sbarray_6, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_235, masses2_55, T1sum(7), M2,sbarray_7, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_234, masses2_55, T1sum(8), M2,sbarray_8, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_231, masses2_54, T1sum(9), M2,sbarray_9, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_225, masses2_60, T1sum(10), M2,sbarray_10, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_222, masses2_60, T1sum(11), M2,sbarray_11, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_221, masses2_60, T1sum(12), M2,sbarray_12, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_230, masses2_54, T1sum(13), M2,sbarray_13, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_224, masses2_60, T1sum(14), M2,sbarray_14, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_219, masses2_60, T1sum(15), M2,sbarray_15, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_229, masses2_56, T1sum(16), M2,sbarray_16, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_226, masses2_56, T1sum(17), M2,sbarray_17, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_214, masses2_53, T1sum(18), M2,sbarray_18, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_213, masses2_55, T1sum(19), M2,sbarray_19, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_228, masses2_56, T1sum(20), M2,sbarray_20, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_217, masses2_56, T1sum(21), M2,sbarray_21, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_211, masses2_55, T1sum(22), M2,sbarray_22, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_210, masses2_55, T1sum(23), M2,sbarray_23, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_212, masses2_55, T1sum(24), M2,sbarray_24, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_218, masses2_58, T1sum(25), M2,sbarray_25, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_220, masses2_58, T1sum(26), M2,sbarray_26, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_236, masses2_59, T1sum(27), M2,sbarray_27, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_237, masses2_59, T1sum(28), M2,sbarray_28, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_232, masses2_55, T1sum(29), M2,sbarray_29, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_233, masses2_55, T1sum(30), M2,sbarray_30, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_216, masses2_57, T1sum(31), M2,sbarray_31, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_215, masses2_62, T1sum(32), M2,sbarray_32, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_223, masses2_61, T1sum(33), M2,sbarray_33, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_209, masses2_53, T1sum(34), M2,sbarray_34, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_227, masses2_53, T1sum(35), M2,sbarray_35, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_208, masses2_53, T1sum(36), M2,sbarray_36, ScalarBoxes(:))
  call TI_call_OL(1,1, momenta_79, masses2_28, T1sum(37), M2)
  call TI_call_OL(1,1, momenta_66, masses2_27, T1sum(38), M2)
  call TI_call_OL(1,1, momenta_37, masses2_27, T1sum(39), M2)
  call TI_call_OL(1,1, momenta_35, masses2_27, T1sum(40), M2)
  call TI_call_OL(1,1, momenta_66, masses2_10, T1sum(41), M2)
  call TI_call_OL(1,1, momenta_48, masses2_10, T1sum(42), M2)
  call TI_call_OL(1,1, momenta_38, masses2_10, T1sum(43), M2)
  call TI_call_OL(1,1, momenta_29, masses2_10, T1sum(44), M2)
  call TI_call_OL(1,1, momenta_70, masses2_10, T1sum(45), M2)
  call TI_call_OL(1,1, momenta_47, masses2_10, T1sum(46), M2)
  call TI_call_OL(1,1, momenta_37, masses2_10, T1sum(47), M2)
  call TI_call_OL(1,1, momenta_79, masses2_10, T1sum(48), M2)
  call TI_call_OL(1,1, momenta_35, masses2_10, T1sum(49), M2)
  call TI_call_OL(1,1, momenta_79, masses2_18, T1sum(50), M2)
  call TI_call_OL(1,1, momenta_66, masses2_19, T1sum(51), M2)
  call TI_call_OL(1,1, momenta_37, masses2_19, T1sum(52), M2)
  call TI_call_OL(1,1, momenta_35, masses2_19, T1sum(53), M2)
  call TI_call_OL(1,1, momenta_70, masses2_28, T1sum(54), M2)
  call TI_call_OL(1,1, momenta_47, masses2_27, T1sum(55), M2)
  call TI_call_OL(1,1, momenta_29, masses2_27, T1sum(56), M2)
  call TI_call_OL(1,1, momenta_70, masses2_18, T1sum(57), M2)
  call TI_call_OL(1,1, momenta_47, masses2_19, T1sum(58), M2)
  call TI_call_OL(1,1, momenta_29, masses2_19, T1sum(59), M2)
  call TI_call_OL(1,1, momenta_48, masses2_25, T1sum(60), M2)
  call TI_call_OL(1,1, momenta_38, masses2_25, T1sum(61), M2)
  call TI_call_OL(1,1, momenta_48, masses2_21, T1sum(62), M2)
  call TI_call_OL(1,1, momenta_38, masses2_21, T1sum(63), M2)

  call add_met(M2,M2L1R1)

#ifdef LOOPSQUARED
  end if
#endif

  call met_to_real(M2out,M2)

#ifdef PRECISION_dp
  call HOL_memory_deallocation_/**/REALKIND(1)
  call HCL_memory_deallocation_/**/REALKIND(1)
#endif

end subroutine integrate_tensor_sum

end module ol_tensor_sum_storage_ppwwtt_uuxttxwwx_1_/**/REALKIND
