
module ol_colourmatrix_ppwwtt_ttxwwxgg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  logical, save           :: colmat_not_initialised = .true.
  complex(REALKIND), save :: K1(46,2), K2(2,3), KL(2,3), Cas(6) = 0
  contains
  subroutine colourmatrix_init
    use ol_parameters_decl_/**/REALKIND, only: CI
    implicit none
    integer :: k, co
    colmat_not_initialised = .false.
    ! colour matrix

  K1( 1,:) = [  48,  -6]
  K1( 2,:) = [  -6,  48]
  K1( 3,:) = [  64,  -8]
  K1( 4,:) = [  -8,  64]
  K1( 5,:) = [  -1, -10]
  K1( 6,:) = [ -10,  -1]
  K1( 7,:) = [  64,  -8]
  K1( 8,:) = [  -8,  64]
  K1( 9,:) = [   0,   0]
  K1(10,:) = [   0,   0]
  K1(11,:) = [   0,   0]
  K1(12,:) = [   0,   0]
  K1(13,:) = [   0,   0]
  K1(14,:) = [   0,   0]
  K1(15,:) = [   0,   0]
  K1(16,:) = [   0,   0]
  K1(17,:) = [   0,   0]
  K1(18,:) = [   0,   0]
  K1(19,:) = [   0,   0]
  K1(20,:) = [   0,   0]
  K1(21,:) = [   0,   0]
  K1(22,:) = [   0,   0]
  K1(23,:) = [   9,   9]
  K1(24,:) = [   9, -72]
  K1(25,:) = [ -72,   9]
  K1(26,:) = [   9,   9]
  K1(27,:) = [   0,   0]
  K1(28,:) = [   0,   0]
  K1(29,:) = [   0,   0]
  K1(30,:) = [   0,   0]
  K1(31,:) = [ 144, -18]
  K1(32,:) = [ -18, 144]
  K1(33,:) = [ -72,   9]
  K1(34,:) = [   9,   9]
  K1(35,:) = [   9,   9]
  K1(36,:) = [   9, -72]
  K1(37,:) = [   0,   0]
  K1(38,:) = [   0,   0]
  K1(39,:) = [   0,   0]
  K1(40,:) = [   0,   0]
  K1(41,:) = [ -81,   0]
  K1(42,:) = [   0, -81]
  K1(43,:) = [ 144, -18]
  K1(44,:) = [ -18, 144]
  K1(45,:) = [   0,   0]
  K1(46,:) = [   0,   0]
  K1 = (1._/**/REALKIND / 9) * K1

  K2(1,:) = [ 16, -2,  6]
  K2(2,:) = [ -2, 16,  6]
  K2 = (1._/**/REALKIND / 3) * K2

  KL(1,:) = [ 16, -2,  6]
  KL(2,:) = [ -2, 16,  6]
  KL = (1._/**/REALKIND / 3) * KL

#if -1 > 0
    co = 0
    do k = 1, 6
      co = co + k
      Cas(k) = K1(1+2*co,1)/K1(1,1)
    end do
#endif
  end subroutine colourmatrix_init
end module ol_colourmatrix_ppwwtt_ttxwwxgg_1_/**/REALKIND



module ol_forced_parameters_ppwwtt_ttxwwxgg_1_/**/REALKIND
  implicit none
  contains
  subroutine check_forced_parameters
    use ol_parameters_decl_/**/REALKIND
    use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
    use ol_loop_parameters_decl_/**/DREALKIND, only: LeadingColour, nc, nf, CKMORDER
#endif
    implicit none
    logical, save :: checks_not_written = .true.

    if (checks_not_written) then
    ! e.g.
    ! if (ME /= 0) write(*,101) 'ME = 0'
  if (CKMORDER /= 0) write(*,101) 'CKMORDER = 0'
  if (nc /= 3) write(*,101) 'nc = 3'
  if (nf /= 6) write(*,101) 'nf = 6'
  if (MU /= 0) write(*,101) 'MU = 0'
  if (MD /= 0) write(*,101) 'MD = 0'
  if (MS /= 0) write(*,101) 'MS = 0'
  if (MC /= 0) write(*,101) 'MC = 0'
  if (LeadingColour /= 0) write(*,101) 'LeadingColour = 0'
  if (wMT /= 0) write(*,101) 'wMT = 0'
  if (wMT /= 0) write(*,101) 'wMT = 0'
  if (wMW /= 0) write(*,101) 'wMW = 0'
  if (wMW /= 0) write(*,101) 'wMW = 0'


    checks_not_written = .false.
    end if

    101 format('[OpenLoops] === WARNING ===',/,'[OpenLoops] code was generated with ',A,/,'[OpenLoops] ===============')
  end subroutine check_forced_parameters
end module ol_forced_parameters_ppwwtt_ttxwwxgg_1_/**/REALKIND


! **********************************************************************
module ol_loop_storage_ppwwtt_ttxwwxgg_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, intkind1, intkind2
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont

#ifdef PRECISION_dp
  integer(intkind1), save :: ntryL = 1
  integer(intkind1), save :: p_switch = 0 ! switch for dp or qp. Used for memory allocation of the OL types
  ! the following are flags for memory allocation of the hol coefficients in dp or qp
  logical, save :: dp_not_alloc = .TRUE., qp_not_alloc = .TRUE.
  integer, save :: n_merge_steps  ! total number of merging steps
  integer, save :: n_merge_mism   ! number of merging mismatches
  integer, save :: merge_step = 1 ! current merging step
  integer(intkind2), save, allocatable :: merge_tables(:,:,:) ! merging tables
  integer(intkind2), save, allocatable :: merge_mism(:)       ! array of merging mismatches
  integer(intkind2), save, allocatable :: merge_hels(:)       ! array with relevant helicities for a merging step
  logical, save :: merge_tables_on = .false.
  integer(intkind2), parameter :: nheltot = 144 ! number of helicity configurations
  integer(intkind2), save :: nhel = 144 ! number of non-vanishing helicity configurations (adapted at runtime)
  integer(intkind2), save :: hel_states = 144 ! number of helicity configurations needed for mem-allocation
  integer(intkind2), save :: Hel(144) ! physical helicity states
#endif

  type(Hpolcont), save, allocatable :: A(:,:), M1helarray(:,:), M1helarray_ct(:,:)
  complex(REALKIND), save :: den(400)

  ! external wave functions ex1(h1),... for h<n> helicities
  type(wfun) :: ex1(2), ex2(2), ex3(3), ex4(3), ex5(2), ex6(2)

  ! wf<h>(h,n) n wave functions with h helicity configurations
  type(wfun) :: wf4(4,28), wf6(6,12), wf8(8,40), wf9(9,3), wf12(12,52), wf16(16,28), wf18(18,44), wf24(24,32), wf36(36,87), &
    wf144(144,289)

  ! diagram prefactors
  integer,           save :: fac_status_loop1 = -1, fac_status_loop2 = -1
  complex(REALKIND), save :: f(77), c(74)

  !Vector in helicity and colour space for Born-Loop interference
  type(Hpolcont),   save, allocatable :: M0_col1_helarray(:,:), M0M1_hel_cc(:,:,:)
  complex(REALKIND), save :: M2ctcc(22)

end module ol_loop_storage_ppwwtt_ttxwwxgg_1_/**/REALKIND






! **********************************************************************
module ol_loop_ppwwtt_ttxwwxgg_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, DREALKIND, intkind1, intkind2
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont
  use ol_loop_storage_ppwwtt_ttxwwxgg_1_/**/REALKIND
  implicit none

!*********************************************************************************
  contains

! **********************************************************************
subroutine fac_init_loop()
! Writes diagram prefactors to 'f', rsp. 'c'
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND
  use ol_init, only: set_parameter, tree_parameters_flush, parameters_flush
#ifndef PRECISION_dp
  use ol_loop_parameters_decl_/**/DREALKIND, only: SwF, SwB
!  use ol_loop_parameters_decl_/**/DREALKIND, only: DOI
#endif
  implicit none
  call set_parameter("ew_renorm", 0)
  if (parameters_status == 0) call tree_parameters_flush()
  if (loop_parameters_status == 0) call parameters_flush()
  fac_status_loop1 = parameters_status
  fac_status_loop2 = loop_parameters_status
  ! factors of the diagrams
    f( 1) = (2*CI*eQED**2*gQCD**2)/3._/**/REALKIND
    f( 2) = (2*eQED**2*gQCD**2)/3._/**/REALKIND
    f( 3) = (2*CI*countertermnorm*eQED**2*gQCD**4)/3._/**/REALKIND
    f( 4) = CI*countertermnorm*eQED**2*gQCD**4
    f( 5) = (2*countertermnorm*eQED**2*gQCD**4)/3._/**/REALKIND
    f( 6) = (2*CI*countertermnorm*ctGtt*eQED**2*gQCD**4)/3._/**/REALKIND
    f( 7) = (2*countertermnorm*ctGtt*eQED**2*gQCD**4)/3._/**/REALKIND
    f( 8) = (2*CI*countertermnorm*ctVtt*eQED**2*gQCD**4)/3._/**/REALKIND
    f( 9) = (2*countertermnorm*ctVtt*eQED**2*gQCD**4)/3._/**/REALKIND
    f(10) = (2*countertermnorm*ctVVV*eQED**2*gQCD**4)/3._/**/REALKIND
    f(11) = CI*countertermnorm*ctWWGG*eQED**2*gQCD**4
    f(12) = countertermnorm*ctWWGG*eQED**2*gQCD**4
    f(13) = (CI*eQED**2*gQCD**2)/(2._/**/REALKIND*sw**2)
    f(14) = (eQED**2*gQCD**2)/(sw**2*2._/**/REALKIND)
    f(15) = (CI*countertermnorm*eQED**2*gQCD**4)/(2._/**/REALKIND*sw**2)
    f(16) = (countertermnorm*eQED**2*gQCD**4)/(sw**2*2._/**/REALKIND)
    f(17) = (CI*countertermnorm*ctGbb*eQED**2*gQCD**4)/(2._/**/REALKIND*sw**2)
    f(18) = (countertermnorm*ctGbb*eQED**2*gQCD**4)/(sw**2*2._/**/REALKIND)
    f(19) = (CI*countertermnorm*ctGtt*eQED**2*gQCD**4)/(2._/**/REALKIND*sw**2)
    f(20) = (countertermnorm*ctGtt*eQED**2*gQCD**4)/(sw**2*2._/**/REALKIND)
    f(21) = (CI*countertermnorm*ctVbt*eQED**2*gQCD**4)/(2._/**/REALKIND*sw**2)
    f(22) = (countertermnorm*ctVbt*eQED**2*gQCD**4)/(sw**2*2._/**/REALKIND)
    f(23) = (countertermnorm*ctVVV*eQED**2*gQCD**4)/(sw**2*2._/**/REALKIND)
    f(24) = (CI*eQED**2*gQCD**2*MT)/(2._/**/REALKIND*sw**2)
    f(25) = (eQED**2*gQCD**2*MT)/(sw**2*2._/**/REALKIND)
    f(26) = (CI*countertermnorm*eQED**2*gQCD**4*MT)/(2._/**/REALKIND*sw**2)
    f(27) = (countertermnorm*eQED**2*gQCD**4*MT)/(sw**2*2._/**/REALKIND)
    f(28) = (CI*countertermnorm*ctGtt*eQED**2*gQCD**4*MT)/(2._/**/REALKIND*sw**2)
    f(29) = (countertermnorm*ctGtt*eQED**2*gQCD**4*MT)/(sw**2*2._/**/REALKIND)
    f(30) = (CI*countertermnorm*ctStt*eQED**2*gQCD**4*MT)/(2._/**/REALKIND*sw**2)
    f(31) = (countertermnorm*ctStt*eQED**2*gQCD**4*MT)/(sw**2*2._/**/REALKIND)
    f(32) = (countertermnorm*ctVVV*eQED**2*gQCD**4*MT)/(sw**2*2._/**/REALKIND)
    f(33) = (CI*cw*eQED**2*gQCD**2)/sw
    f(34) = (cw*eQED**2*gQCD**2)/sw
    f(35) = (CI*countertermnorm*cw*eQED**2*gQCD**4)/sw
    f(36) = (countertermnorm*cw*eQED**2*gQCD**4)/sw
    f(37) = (CI*countertermnorm*ctGtt*cw*eQED**2*gQCD**4)/sw
    f(38) = (countertermnorm*ctGtt*cw*eQED**2*gQCD**4)/sw
    f(39) = (CI*countertermnorm*ctVtt*cw*eQED**2*gQCD**4)/sw
    f(40) = (countertermnorm*ctVtt*cw*eQED**2*gQCD**4)/sw
    f(41) = (countertermnorm*ctVVV*cw*eQED**2*gQCD**4)/sw
    f(42) = (CI*countertermnorm*ctZGG*cw*eQED**2*gQCD**4)/sw
    f(43) = (countertermnorm*ctZGG*cw*eQED**2*gQCD**4)/sw
    f(44) = (CI*countertermnorm*ctHGG*eQED**2*gQCD**4*MW)/sw
    f(45) = (countertermnorm*ctHGG*eQED**2*gQCD**4*MW)/sw
    f(46) = (CI*eQED**2*gQCD**4*integralnorm*SwB)/3._/**/REALKIND
    f(47) = (2*CI*eQED**2*gQCD**4*integralnorm*SwB)/3._/**/REALKIND
    f(48) = (2*eQED**2*gQCD**4*integralnorm*SwB)/3._/**/REALKIND
    f(49) = (CI*eQED**2*gQCD**4*integralnorm*SwB)/(4._/**/REALKIND*sw**2)
    f(50) = (CI*eQED**2*gQCD**4*integralnorm*SwB)/(2._/**/REALKIND*sw**2)
    f(51) = (eQED**2*gQCD**4*integralnorm*SwB)/(sw**2*2._/**/REALKIND)
    f(52) = (CI*eQED**2*gQCD**4*integralnorm*MT*SwB)/(4._/**/REALKIND*sw**2)
    f(53) = (CI*eQED**2*gQCD**4*integralnorm*MT*SwB)/(2._/**/REALKIND*sw**2)
    f(54) = (eQED**2*gQCD**4*integralnorm*MT*SwB)/(sw**2*2._/**/REALKIND)
    f(55) = (CI*cw*eQED**2*gQCD**4*integralnorm*SwB)/(2._/**/REALKIND*sw)
    f(56) = (CI*cw*eQED**2*gQCD**4*integralnorm*SwB)/sw
    f(57) = (cw*eQED**2*gQCD**4*integralnorm*SwB)/sw
    f(58) = (CI*eQED**2*gQCD**4*integralnorm*SwF)/3._/**/REALKIND
    f(59) = (2*CI*eQED**2*gQCD**4*integralnorm*SwF)/3._/**/REALKIND
    f(60) = (4*CI*eQED**2*gQCD**4*integralnorm*SwF)/3._/**/REALKIND
    f(61) = (eQED**2*gQCD**4*integralnorm*SwF)/3._/**/REALKIND
    f(62) = (2*eQED**2*gQCD**4*integralnorm*SwF)/3._/**/REALKIND
    f(63) = (4*eQED**2*gQCD**4*integralnorm*SwF)/3._/**/REALKIND
    f(64) = (CI*eQED**2*gQCD**4*integralnorm*SwF)/(2._/**/REALKIND*sw**2)
    f(65) = (CI*eQED**2*gQCD**4*integralnorm*SwF)/sw**2
    f(66) = (eQED**2*gQCD**4*integralnorm*SwF)/(sw**2*2._/**/REALKIND)
    f(67) = (eQED**2*gQCD**4*integralnorm*SwF)/sw**2
    f(68) = (CI*eQED**2*gQCD**4*integralnorm*MB*SwF)/(2._/**/REALKIND*sw**2)
    f(69) = (eQED**2*gQCD**4*integralnorm*MB*SwF)/(sw**2*2._/**/REALKIND)
    f(70) = (CI*eQED**2*gQCD**4*integralnorm*MT*SwF)/(2._/**/REALKIND*sw**2)
    f(71) = (CI*eQED**2*gQCD**4*integralnorm*MT*SwF)/sw**2
    f(72) = (eQED**2*gQCD**4*integralnorm*MT*SwF)/(sw**2*2._/**/REALKIND)
    f(73) = (eQED**2*gQCD**4*integralnorm*MT*SwF)/sw**2
    f(74) = (CI*cw*eQED**2*gQCD**4*integralnorm*SwF)/sw
    f(75) = (2*CI*cw*eQED**2*gQCD**4*integralnorm*SwF)/sw
    f(76) = (cw*eQED**2*gQCD**4*integralnorm*SwF)/sw
    f(77) = (2*cw*eQED**2*gQCD**4*integralnorm*SwF)/sw

  c = [ 9*CI*f(46), 18*CI*f(46), CI*f(47), 3*CI*f(47), 8*CI*f(47), 9*CI*f(47), 18*CI*f(47), f(48), 3*f(48), 8*f(48), 9*f(48) &
    , 9*CI*f(49), 18*CI*f(49), CI*f(50), 3*CI*f(50), 8*CI*f(50), 9*CI*f(50), 18*CI*f(50), f(51), 3*f(51), 8*f(51), 9*f(51) &
    , 9*CI*f(52), 18*CI*f(52), CI*f(53), 3*CI*f(53), 8*CI*f(53), 9*CI*f(53), 18*CI*f(53), f(54), 3*f(54), 8*f(54), 9*f(54) &
    , 9*CI*f(55), 18*CI*f(55), CI*f(56), 3*CI*f(56), 8*CI*f(56), 9*CI*f(56), 18*CI*f(56), f(57), 3*f(57), 8*f(57), 9*f(57) &
    , 3*CI*f(58), 3*CI*f(59), 3*CI*f(60), f(61), 3*f(61), f(62), 3*f(62), f(63), 3*f(63), 3*CI*f(64), 3*CI*f(65), f(66), 3*f(66) &
    , f(67), 3*f(67), 3*CI*f(68), f(69), 3*f(69), 3*CI*f(70), 3*CI*f(71), f(72), 3*f(72), f(73), 3*f(73), 3*CI*f(74), 3*CI*f(75) &
    , f(76), 3*f(76), f(77), 3*f(77) ]
  c = (1._/**/REALKIND / 6) * c
end subroutine fac_init_loop

subroutine denominators()
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_momenta_decl_/**/REALKIND, only: L
  implicit none
  ! propagators
  den(1) = 1 /((L(5,5) - MB2)+L(6,5))
  den(2) = 1 /((L(5,10) - MB2)+L(6,10))
  den(3) = 1 /((L(5,48))+L(6,48))
  den(6) = 1 /((L(5,21) - MB2)+L(6,21))
  den(9) = 1 /((L(5,26) - MB2)+L(6,26))
  den(12) = 1 /((L(5,18) - MT2)+L(6,18))
  den(13) = 1 /((L(5,13) - MT2)+L(6,13))
  den(18) = 1 /((L(5,34) - MT2)+L(6,34))
  den(20) = 1 /((L(5,42) - MB2)+L(6,42))
  den(23) = 1 /((L(5,50) - MT2)+L(6,50))
  den(26) = 1 /((L(5,17) - MT2)+L(6,17))
  den(29) = 1 /((L(5,14) - MT2)+L(6,14))
  den(32) = 1 /((L(5,33) - MT2)+L(6,33))
  den(33) = 1 /((L(5,37) - MB2)+L(6,37))
  den(37) = 1 /((L(5,49) - MT2)+L(6,49))
  den(40) = 1 /((L(5,12) - MH2)+L(6,12))
  den(43) = 1 /((L(5,12))+L(6,12))
  den(45) = 1 /((L(5,12) - MZ2)+L(6,12))
  den(77) = 1 /((L(5,3))+L(6,3))
  den(81) = 1 /((L(5,44))+L(6,44))
  den(83) = 1 /((L(5,28))+L(6,28))
  den(92) = 1 /((L(5,19))+L(6,19))
  den(96) = 1 /((L(5,35))+L(6,35))
  den(151) = 1 /((L(5,58) - MB2)+L(6,58))
  den(155) = 1 /((L(5,53) - MB2)+L(6,53))
  den(158) = 1 /((L(5,15))+L(6,15))
  den(205) = 1 /((L(5,46) - MT2)+L(6,46))
  den(215) = 1 /((L(5,29) - MT2)+L(6,29))
  den(231) = 1 /((L(5,30) - MT2)+L(6,30))
  den(241) = 1 /((L(5,45) - MT2)+L(6,45))

  ! denominators
  den(4) = den(1)*den(2)
  den(5) = den(3)*den(4)
  den(7) = den(1)*den(6)
  den(8) = den(2)*den(7)
  den(10) = den(2)*den(9)
  den(11) = den(1)*den(10)
  den(14) = den(1)*den(13)
  den(15) = den(12)*den(14)
  den(16) = den(9)*den(12)
  den(17) = den(1)*den(16)
  den(19) = den(14)*den(18)
  den(21) = den(18)*den(20)
  den(22) = den(1)*den(21)
  den(24) = den(3)*den(23)
  den(25) = den(1)*den(24)
  den(27) = den(6)*den(26)
  den(28) = den(2)*den(27)
  den(30) = den(2)*den(29)
  den(31) = den(26)*den(30)
  den(34) = den(32)*den(33)
  den(35) = den(2)*den(34)
  den(36) = den(30)*den(32)
  den(38) = den(3)*den(37)
  den(39) = den(2)*den(38)
  den(41) = den(18)*den(26)
  den(42) = den(40)*den(41)
  den(44) = den(41)*den(43)
  den(46) = den(41)*den(45)
  den(47) = den(29)*den(40)
  den(48) = den(26)*den(47)
  den(49) = den(29)*den(43)
  den(50) = den(26)*den(49)
  den(51) = den(29)*den(45)
  den(52) = den(26)*den(51)
  den(53) = den(12)*den(32)
  den(54) = den(40)*den(53)
  den(55) = den(43)*den(53)
  den(56) = den(45)*den(53)
  den(57) = den(13)*den(40)
  den(58) = den(12)*den(57)
  den(59) = den(13)*den(43)
  den(60) = den(12)*den(59)
  den(61) = den(13)*den(45)
  den(62) = den(12)*den(61)
  den(63) = den(32)*den(47)
  den(64) = den(32)*den(49)
  den(65) = den(32)*den(51)
  den(66) = den(18)*den(57)
  den(67) = den(18)*den(59)
  den(68) = den(18)*den(61)
  den(69) = den(3)*den(57)
  den(70) = den(3)*den(59)
  den(71) = den(3)*den(61)
  den(72) = den(38)*den(40)
  den(73) = den(38)*den(43)
  den(74) = den(38)*den(45)
  den(75) = den(18)*den(27)
  den(76) = den(12)*den(34)
  den(78) = den(43)*den(77)
  den(79) = den(45)*den(77)
  den(80) = den(3)*den(77)
  den(82) = den(77)*den(81)
  den(84) = den(77)*den(83)
  den(85) = den(26)*den(81)
  den(86) = den(12)*den(81)
  den(87) = den(32)*den(83)
  den(88) = den(18)*den(83)
  den(89) = den(40)*den(77)
  den(90) = den(3)*den(89)
  den(91) = den(3)*den(79)
  den(93) = den(77)*den(92)
  den(94) = den(40)*den(93)
  den(95) = den(45)*den(93)
  den(97) = den(77)*den(96)
  den(98) = den(40)*den(97)
  den(99) = den(45)*den(97)
  den(100) = den(1)*den(33)
  den(101) = den(2)*den(100)
  den(102) = den(2)*den(20)
  den(103) = den(1)*den(102)
  den(104) = den(12)*den(100)
  den(105) = den(12)*den(23)
  den(106) = den(1)*den(105)
  den(107) = den(7)*den(18)
  den(108) = den(18)*den(23)
  den(109) = den(1)*den(108)
  den(110) = den(26)*den(92)
  den(111) = den(40)*den(110)
  den(112) = den(45)*den(110)
  den(113) = den(12)*den(92)
  den(114) = den(40)*den(113)
  den(115) = den(45)*den(113)
  den(116) = den(32)*den(96)
  den(117) = den(40)*den(116)
  den(118) = den(45)*den(116)
  den(119) = den(18)*den(96)
  den(120) = den(40)*den(119)
  den(121) = den(45)*den(119)
  den(122) = den(26)*den(37)
  den(123) = den(2)*den(122)
  den(124) = den(26)*den(102)
  den(125) = den(32)*den(37)
  den(126) = den(2)*den(125)
  den(127) = den(10)*den(32)
  den(128) = den(21)*den(26)
  den(129) = den(16)*den(32)
  den(130) = den(3)*den(14)
  den(131) = den(40)*den(122)
  den(132) = den(43)*den(122)
  den(133) = den(45)*den(122)
  den(134) = den(40)*den(125)
  den(135) = den(43)*den(125)
  den(136) = den(45)*den(125)
  den(137) = den(3)*den(30)
  den(138) = den(40)*den(105)
  den(139) = den(43)*den(105)
  den(140) = den(45)*den(105)
  den(141) = den(40)*den(108)
  den(142) = den(43)*den(108)
  den(143) = den(45)*den(108)
  den(144) = den(24)*den(40)
  den(145) = den(24)*den(43)
  den(146) = den(24)*den(45)
  den(147) = den(3)*den(47)
  den(148) = den(3)*den(49)
  den(149) = den(3)*den(51)
  den(150) = den(2)*den(3)
  den(152) = den(150)*den(151)
  den(153) = den(1)*den(152)
  den(154) = den(1)*den(3)
  den(156) = den(154)*den(155)
  den(157) = den(2)*den(156)
  den(159) = den(4)*den(158)
  den(160) = den(3)*den(159)
  den(161) = den(1)**2
  den(162) = den(102)*den(161)
  den(163) = den(10)*den(161)
  den(164) = den(2)**2
  den(165) = den(100)*den(164)
  den(166) = den(7)*den(164)
  den(167) = den(7)*den(102)
  den(168) = den(10)*den(100)
  den(169) = den(105)*den(161)
  den(170) = den(16)*den(161)
  den(171) = den(12)**2
  den(172) = den(100)*den(171)
  den(173) = den(14)*den(171)
  den(174) = den(14)*den(105)
  den(175) = den(16)*den(100)
  den(176) = den(108)*den(161)
  den(177) = den(21)*den(161)
  den(178) = den(18)**2
  den(179) = den(7)*den(178)
  den(180) = den(14)*den(178)
  den(181) = den(14)*den(108)
  den(182) = den(7)*den(21)
  den(183) = den(24)*den(161)
  den(184) = den(14)*den(24)
  den(185) = den(3)**2
  den(186) = den(14)*den(185)
  den(187) = den(26)**2
  den(188) = den(102)*den(187)
  den(189) = den(30)*den(187)
  den(190) = den(122)*den(164)
  den(191) = den(27)*den(164)
  den(192) = den(27)*den(102)
  den(193) = den(30)*den(122)
  den(194) = den(32)**2
  den(195) = den(10)*den(194)
  den(196) = den(30)*den(194)
  den(197) = den(125)*den(164)
  den(198) = den(34)*den(164)
  den(199) = den(10)*den(34)
  den(200) = den(30)*den(125)
  den(201) = den(30)*den(38)
  den(202) = den(30)*den(185)
  den(203) = den(38)*den(164)
  den(204) = den(18)*den(40)
  den(206) = den(204)*den(205)
  den(207) = den(26)*den(206)
  den(208) = den(18)*den(43)
  den(209) = den(205)*den(208)
  den(210) = den(26)*den(209)
  den(211) = den(18)*den(45)
  den(212) = den(205)*den(211)
  den(213) = den(26)*den(212)
  den(214) = den(26)*den(40)
  den(216) = den(214)*den(215)
  den(217) = den(18)*den(216)
  den(218) = den(26)*den(43)
  den(219) = den(215)*den(218)
  den(220) = den(18)*den(219)
  den(221) = den(26)*den(45)
  den(222) = den(215)*den(221)
  den(223) = den(18)*den(222)
  den(224) = den(47)*den(187)
  den(225) = den(49)*den(187)
  den(226) = den(51)*den(187)
  den(227) = den(47)*den(122)
  den(228) = den(49)*den(122)
  den(229) = den(51)*den(122)
  den(230) = den(12)*den(40)
  den(232) = den(230)*den(231)
  den(233) = den(32)*den(232)
  den(234) = den(12)*den(43)
  den(235) = den(231)*den(234)
  den(236) = den(32)*den(235)
  den(237) = den(12)*den(45)
  den(238) = den(231)*den(237)
  den(239) = den(32)*den(238)
  den(240) = den(32)*den(40)
  den(242) = den(240)*den(241)
  den(243) = den(12)*den(242)
  den(244) = den(32)*den(43)
  den(245) = den(241)*den(244)
  den(246) = den(12)*den(245)
  den(247) = den(32)*den(45)
  den(248) = den(241)*den(247)
  den(249) = den(12)*den(248)
  den(250) = den(57)*den(105)
  den(251) = den(59)*den(105)
  den(252) = den(61)*den(105)
  den(253) = den(57)*den(171)
  den(254) = den(59)*den(171)
  den(255) = den(61)*den(171)
  den(256) = den(47)*den(194)
  den(257) = den(49)*den(194)
  den(258) = den(51)*den(194)
  den(259) = den(47)*den(125)
  den(260) = den(49)*den(125)
  den(261) = den(51)*den(125)
  den(262) = den(57)*den(108)
  den(263) = den(59)*den(108)
  den(264) = den(61)*den(108)
  den(265) = den(57)*den(178)
  den(266) = den(59)*den(178)
  den(267) = den(61)*den(178)
  den(268) = den(24)*den(57)
  den(269) = den(24)*den(59)
  den(270) = den(24)*den(61)
  den(271) = den(38)*den(47)
  den(272) = den(38)*den(49)
  den(273) = den(38)*den(51)
  den(274) = den(47)*den(185)
  den(275) = den(49)*den(185)
  den(276) = den(51)*den(185)
  den(277) = den(57)*den(185)
  den(278) = den(59)*den(185)
  den(279) = den(61)*den(185)
  den(280) = den(21)*den(187)
  den(281) = den(27)*den(178)
  den(282) = den(21)*den(27)
  den(283) = den(16)*den(194)
  den(284) = den(34)*den(171)
  den(285) = den(16)*den(34)
  den(286) = den(14)*den(158)
  den(287) = den(14)*den(215)
  den(288) = den(14)*den(241)
  den(289) = den(7)*den(215)
  den(290) = den(7)*den(155)
  den(291) = den(100)*den(241)
  den(292) = den(100)*den(155)
  den(293) = den(30)*den(158)
  den(294) = den(30)*den(231)
  den(295) = den(30)*den(205)
  den(296) = den(10)*den(231)
  den(297) = den(10)*den(151)
  den(298) = den(102)*den(205)
  den(299) = den(102)*den(151)
  den(300) = den(57)*den(158)
  den(301) = den(59)*den(158)
  den(302) = den(61)*den(158)
  den(303) = den(47)*den(158)
  den(304) = den(49)*den(158)
  den(305) = den(51)*den(158)
  den(306) = den(57)*den(215)
  den(307) = den(59)*den(215)
  den(308) = den(61)*den(215)
  den(309) = den(57)*den(241)
  den(310) = den(59)*den(241)
  den(311) = den(61)*den(241)
  den(312) = den(47)*den(231)
  den(313) = den(49)*den(231)
  den(314) = den(51)*den(231)
  den(315) = den(47)*den(205)
  den(316) = den(49)*den(205)
  den(317) = den(51)*den(205)
  den(318) = den(27)*den(215)
  den(319) = den(27)*den(155)
  den(320) = den(122)*den(155)
  den(321) = den(16)*den(231)
  den(322) = den(16)*den(151)
  den(323) = den(105)*den(151)
  den(324) = den(34)*den(241)
  den(325) = den(34)*den(155)
  den(326) = den(125)*den(155)
  den(327) = den(21)*den(205)
  den(328) = den(21)*den(151)
  den(329) = den(108)*den(151)
  den(330) = den(38)*den(155)
  den(331) = den(24)*den(151)
  den(332) = den(3)*den(40)*den(77)
  den(333) = den(3)*den(43)*den(77)
  den(334) = den(3)*den(45)*den(77)
  den(335) = den(43)*den(93)
  den(336) = den(43)*den(97)
  den(337) = den(1)*den(2)*den(3)
  den(338) = den(1)*den(12)
  den(339) = den(1)*den(18)
  den(340) = den(2)*den(26)
  den(341) = den(2)*den(32)
  den(342) = den(18)*den(26)*den(40)
  den(343) = den(18)*den(26)*den(43)
  den(344) = den(18)*den(26)*den(45)
  den(345) = den(43)*den(110)
  den(346) = den(12)*den(32)*den(40)
  den(347) = den(12)*den(32)*den(43)
  den(348) = den(12)*den(32)*den(45)
  den(349) = den(43)*den(113)
  den(350) = den(43)*den(116)
  den(351) = den(43)*den(119)
  den(352) = den(3)*den(40)
  den(353) = den(3)*den(43)
  den(354) = den(3)*den(45)
  den(355) = den(2)*den(290)
  den(356) = den(2)*den(292)
  den(357) = den(1)*den(297)
  den(358) = den(1)*den(299)
  den(359) = den(12)*den(288)
  den(360) = den(12)*den(291)
  den(361) = den(1)*den(322)
  den(362) = den(1)*den(323)
  den(363) = den(18)*den(287)
  den(364) = den(18)*den(289)
  den(365) = den(1)*den(328)
  den(366) = den(1)*den(329)
  den(367) = den(3)*den(286)
  den(368) = den(1)*den(331)
  den(369) = den(2)*den(319)
  den(370) = den(2)*den(320)
  den(371) = den(26)*den(295)
  den(372) = den(26)*den(298)
  den(373) = den(2)*den(325)
  den(374) = den(2)*den(326)
  den(375) = den(32)*den(294)
  den(376) = den(32)*den(296)
  den(377) = den(2)*den(330)
  den(378) = den(3)*den(293)
  den(379) = den(26)*den(315)
  den(380) = den(26)*den(316)
  den(381) = den(26)*den(317)
  den(382) = den(12)*den(309)
  den(383) = den(12)*den(310)
  den(384) = den(12)*den(311)
  den(385) = den(32)*den(312)
  den(386) = den(32)*den(313)
  den(387) = den(32)*den(314)
  den(388) = den(18)*den(306)
  den(389) = den(18)*den(307)
  den(390) = den(18)*den(308)
  den(391) = den(3)*den(300)
  den(392) = den(3)*den(301)
  den(393) = den(3)*den(302)
  den(394) = den(3)*den(303)
  den(395) = den(3)*den(304)
  den(396) = den(3)*den(305)
  den(397) = den(18)*den(318)
  den(398) = den(26)*den(327)
  den(399) = den(12)*den(324)
  den(400) = den(32)*den(321)

end subroutine denominators

#ifdef PRECISION_dp
! **********************************************************************
subroutine init_merging_tables(tot_num_hels, tot_num_merge_steps)
!-----------------------------------------------------------------------
! In the first event the merging tables are fully initialised
! **********************************************************************
  implicit none
  integer, intent(in) :: tot_num_hels, tot_num_merge_steps
  n_merge_steps = tot_num_merge_steps
  allocate(merge_tables(tot_num_hels,2,n_merge_steps))
  allocate(merge_mism(n_merge_steps+1))
  allocate(merge_hels(n_merge_steps))
  merge_tables_on = .true.
  merge_mism = 0_intkind2
  merge_tables = -1_intkind2
  merge_hels = -1_intkind2
end subroutine init_merging_tables

! **********************************************************************
subroutine update_merging_tables(tot_num_hels)
!-----------------------------------------------------------------------
! After the first evaluation the merging tables are adapted
! **********************************************************************
  implicit none
  integer, intent(in) :: tot_num_hels
  integer(intkind2), allocatable ::  merge_tables_tmp(:,:,:), merge_hels_tmp(:)

  if(merge_mism(1) == 0) then ! helicity configurations match in all merging steps
    if(allocated(merge_tables)) deallocate(merge_tables)
    if(allocated(merge_hels)) deallocate(merge_hels)
    if(allocated(merge_mism)) deallocate(merge_mism)
    allocate(merge_mism(1))
    allocate(merge_hels(1))
    allocate(merge_tables(1,1,1)) ! dummy allocation
    merge_mism = 0_intkind2
    merge_tables = -1_intkind2
    merge_hels = -1_intkind2
  else
    n_merge_mism = merge_mism(1)
    allocate(merge_tables_tmp(tot_num_hels,2,n_merge_mism))
    merge_tables_tmp(:,:,1:n_merge_mism) = merge_tables(:,:,1:n_merge_mism)
    if(allocated(merge_tables)) then
      deallocate(merge_tables)
      allocate(merge_tables(tot_num_hels,2,n_merge_mism))
    end if
    merge_tables = merge_tables_tmp
    if(allocated(merge_tables_tmp)) deallocate(merge_tables_tmp)
    allocate(merge_hels_tmp(n_merge_mism))
    merge_hels_tmp(1:n_merge_mism) = merge_hels(1:n_merge_mism)
    if(allocated(merge_hels)) then
      deallocate(merge_hels)
      allocate(merge_hels(n_merge_mism))
    end if
    merge_hels = merge_hels_tmp
    if(allocated(merge_hels_tmp)) deallocate(merge_hels_tmp)
  end if
  merge_tables_on = .true.
end subroutine update_merging_tables
#endif

! **********************************************************************
subroutine allocate_diagrams()
!-----------------------------------------------------------------------
! After the first Born evaluation, colour-stripped amplitudes and
! colour vectors are initialiased with the minimum number of relevant
! helicity states.
! **********************************************************************
#ifndef PRECISION_dp
  use ol_loop_storage_ppwwtt_ttxwwxgg_1_/**/DREALKIND, only: hel_states
#endif
  implicit none

  if (allocated(A)) deallocate(A)
  if (allocated(M1helarray)) deallocate(M1helarray)
  if (allocated(M1helarray_ct)) deallocate(M1helarray_ct)
  if (allocated(M0_col1_helarray)) deallocate(M0_col1_helarray)
  allocate(A(hel_states,289))
  allocate(M1helarray(2,hel_states))
  allocate(M1helarray_ct(3,hel_states))
  allocate(M0_col1_helarray(3,hel_states))
#if -1 > 0
  if (allocated(M0M1_hel_cc)) deallocate(M0M1_hel_cc)
  allocate(M0M1_hel_cc(3,hel_states,22))
#endif
end subroutine allocate_diagrams

!
!
!
! **********************************************************************
#ifdef PRECISION_dp
recursive subroutine amp2(P_scatt, M02, qp_kinematics, M2ct, M2colint)
#else
recursive subroutine amp2(P_scatt, M02, qp_kinematics, M2ct, M2colint)
  use ol_loop_storage_ppwwtt_ttxwwxgg_1_/**/DREALKIND, only: &
  nhel, Hel, hel_states
#endif
! P_scatt(0:3,Npart) = incoming external momenta
! M2  = helicity-summed squared matrix element for top anti-top W- W+ glue glue -> 0
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND !, only: ci, parameters_status, ZERO, scalefactor, >masses<
  use ol_parameters_init_/**/REALKIND, only: ensure_mp_init, ensure_mp_loop_init
  use ol_kinematics_/**/REALKIND, only: init_kinematics
  use ol_momenta_decl_/**/DREALKIND, only: momenta_nan_check
  use ol_settings_ppwwtt_ttxwwxgg_1, only: hel_mem_opt, loopcc
  use ol_data_types_/**/REALKIND
  use ol_h_helicity_bookkeeping_/**/REALKIND, only: &
    & helbookkeeping_wf, helsync, flip_phase
  use ol_helicity_init, only: helbookkeeping_flip, helsync_flip
  use ol_hel_propagators_/**/REALKIND
  use ol_hel_wavefunctions_/**/REALKIND
  use ol_wavefunctions_/**/REALKIND, only: wf_V_Std
  use ol_hel_vertices_/**/REALKIND
  use ol_hel_contractions_/**/REALKIND
  use ol_external_ppwwtt_ttxwwxgg_1, only: &
    & external_perm_ppwwtt_ttxwwxgg_1, &
    & external_perm_inv_ppwwtt_ttxwwxgg_1, &
    & extcomb_perm_ppwwtt_ttxwwxgg_1, &
    & average_factor_ppwwtt_ttxwwxgg_1
  use ol_external_ppwwtt_ttxwwxgg_1, only: &
    & H, hel_not_initialised, hel_init, POLSEL
  use ol_colourmatrix_ppwwtt_ttxwwxgg_1_/**/REALKIND, only: &
    & colmat_not_initialised, colourmatrix_init
  use ol_forced_parameters_ppwwtt_ttxwwxgg_1_/**/REALKIND, only: &
    & check_forced_parameters
  use ol_heltables_OLR_ppwwtt_ttxwwxgg_1
  use ol_kinematics_/**/REALKIND, only: LC2Std_Rep_cmplx
  use ol_h_counterterms_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND ! counterterms
  use ol_loop_parameters_decl_/**/DREALKIND, only: &
    & IR_is_on, DOI, CT_is_on, R2_is_on, TP_is_on
  use ol_init, only: set_parameter, parameters_flush
#ifdef PRECISION_dp
  use ol_kinematics_/**/QREALKIND, only: conv_mom_scatt2in_qp=>conv_mom_scatt2in, &
                                         internal_momenta_qp=>internal_momenta
  use ol_momenta_decl_/**/DREALKIND, only: L
  use ol_momenta_decl_/**/QREALKIND, only: L_qp=>L
#endif
  implicit none

  real(DREALKIND), intent(in)  :: P_scatt(0:3,6)
  real(REALKIND),  intent(out) :: M02
  logical, intent(in) :: qp_kinematics
  real(REALKIND),  intent(out), optional :: M2ct
  real(REALKIND),  intent(out), optional :: M2colint(22)
  real(REALKIND) :: iM2ct
  real(REALKIND) :: iM2colint(22)

  integer(intkind1), save :: ntry = 0

  integer           :: shift, k, r, m, n, i
  real(REALKIND)    :: P(0:3,6)
#ifdef PRECISION_dp
  real(QREALKIND)    :: P_qp(0:3,6)
#endif
  integer           :: extmasses2(6)
  real(REALKIND)    :: M2add, M2add_ct, M2add_colint(22)
  complex(REALKIND) :: M1(2), M2(3)
  real(REALKIND)    :: P_scatt_intern(0:3,6)
  real(REALKIND), save :: scalebackfactor, old_scalefactor = 0
  integer(intkind1) :: nsync
  integer, allocatable :: extcombs_permuted(:)
  integer              :: extcombs(22), nextcombs
  integer              :: CT_on_bak, R2_on_bak, TP_on_bak, DOI_bak
  logical              :: do_ct, do_colint
#if 6 > 3
  integer :: ind_cc_comb(9)
#endif
  complex(REALKIND) :: omega(2) ! phases for helicity correlations

  if (present(M2ct)) then
    do_ct = .true.
  else
    do_ct = .false.
  end if

  if (present(M2colint)) then
    do_colint = .true.
  else
    do_colint = .false.
  end if

  if(ntry == 0) then
    ! recursive initialization call needed for the correct helicity bokkeeping
    ntry = 1
    CT_on_bak = CT_is_on
    R2_on_bak = R2_is_on
    TP_on_bak = TP_is_on
    DOI_bak = DOI
    call set_parameter("ct_on", 1)
    call set_parameter("r2_on", 1)
    call set_parameter("tp_on", 1)
    DOI = 1
    call amp2(P_scatt, M02, qp_kinematics, M2ct=iM2ct, M2colint=iM2colint)
    call set_parameter("ct_on", CT_on_bak)
    call set_parameter("r2_on", R2_on_bak)
    call set_parameter("tp_on", TP_on_bak)
    DOI = DOI_bak
  end if

  if (ntry < 2) then
    if (allocated(A)) deallocate(A)
    allocate(A(nhel,289))
  end if

  if (do_ct) call set_parameter("ew_renorm", 0)
  call parameters_flush()
  call ensure_mp_init()
  if (do_ct) call ensure_mp_loop_init()

  if (colmat_not_initialised) call colourmatrix_init()

  if (fac_status_loop1 /= parameters_status .or. fac_status_loop2 /= loop_parameters_status) then
    call check_forced_parameters()
  end if
  if (do_ct) call fac_init_loop()

  if (momenta_nan_check(P_scatt) /= 0) then
    M02 = 0
    return
  end if

  extmasses2 = [ nMT, nMT, nMW, nMW, 0, 0 ]
  ! Convert 2 -> n-2 PS-point to n -> 0 (so that P(1) + ... + P(n) = 0) and compute
  ! internal-propagator momenta in light-cone representation
  call init_kinematics(P_scatt, extmasses2, P, &
     external_perm_inv_ppwwtt_ttxwwxgg_1, 6, qp_kinematics)

  ! denominators
  call denominators()

   if (heltables_not_init) call init_heltables()

  ! external WFs
  ! Here the external wavefunctions are initialiased
  call pol_wf_Q(P(:,1), rMT, H1, ex1, POLSEL(1),1)
  call pol_wf_A(P(:,2), rMT, H2, ex2, POLSEL(2),2)
  call pol_wf_V(P(:,3), rMW, H3, ex3, POLSEL(3),3)
  call pol_wf_V(P(:,4), rMW, H4, ex4, POLSEL(4),4)
  call pol_wf_V(P(:,5), rZERO, H5, ex5, POLSEL(5),5)
  call pol_wf_V(P(:,6), rZERO, H6, ex6, POLSEL(6),6)



  ! internal WFs
  ! e.g. call vert_VQ_A(ntry, ex3, ex1, wf1, n1, t1) ...
  call vert_WQ_A(ntry, ex3(:), ex1(:), wf6(:,1), n3(:,1), t3x6(:,:,1))
  call vert_AW_Q(ntry, ex2(:), ex4(:), wf6(:,2), n3(:,2), t3x6(:,:,2))
  call vert_UV_W(ntry, ex5(:), 16, ex6(:), 32, wf4(:,1), n3(:,3), t3x4(:,:,1))
  call prop_Q_A(ntry, wf6(:,1), 5, MB, 1_intkind1, wf6(:,3), n2(1))
  call prop_A_Q(ntry, wf6(:,2), 10, MB, 1_intkind1, wf6(:,4), n2(2))
  call vert_QA_V(ntry, wf6(:,3), wf6(:,4), wf36(:,1), n3(:,4), t3x36(:,:,1))
  call vert_VQ_A(ntry, ex5(:), wf6(:,3), wf12(:,1), n3(:,5), t3x12(:,:,1))
  call vert_AV_Q(ntry, wf6(:,4), ex6(:), wf12(:,2), n3(:,6), t3x12(:,:,2))
  call prop_Q_A(ntry, wf12(:,1), 21, MB, 1_intkind1, wf12(:,3), n2(3))
  call vert_AV_Q(ntry, wf6(:,4), ex5(:), wf12(:,4), n3(:,7), t3x12(:,:,3))
  call vert_VQ_A(ntry, ex6(:), wf6(:,3), wf12(:,5), n3(:,8), t3x12(:,:,4))
  call prop_A_Q(ntry, wf12(:,4), 26, MB, 1_intkind1, wf12(:,6), n2(4))
  call vert_AV_Q(ntry, ex2(:), ex5(:), wf4(:,2), n3(:,9), t3x4(:,:,2))
  call prop_A_Q(ntry, wf4(:,2), 18, MT, 1_intkind1, wf4(:,3), n2(5))
  call vert_WQ_A(ntry, ex4(:), wf6(:,3), wf18(:,1), n3(:,10), t3x18(:,:,1))
  call vert_AV_Q(ntry, wf4(:,3), ex6(:), wf8(:,1), n3(:,11), t3x8(:,:,1))
  call prop_Q_A(ntry, wf18(:,1), 13, MT, 1_intkind1, wf18(:,2), n2(6))
  call vert_AW_Q(ntry, wf4(:,3), ex4(:), wf12(:,7), n3(:,12), t3x12(:,:,5))
  call prop_A_Q(ntry, wf12(:,7), 26, MB, 1_intkind1, wf12(:,8), n2(7))
  call vert_AV_Q(ntry, ex2(:), ex6(:), wf4(:,4), n3(:,13), t3x4(:,:,3))
  call prop_A_Q(ntry, wf4(:,4), 34, MT, 1_intkind1, wf4(:,5), n2(8))
  call vert_AV_Q(ntry, wf4(:,5), ex5(:), wf8(:,2), n3(:,14), t3x8(:,:,2))
  call vert_AW_Q(ntry, wf4(:,5), ex4(:), wf12(:,9), n3(:,15), t3x12(:,:,6))
  call prop_A_Q(ntry, wf12(:,9), 42, MB, 1_intkind1, wf12(:,10), n2(9))
  call vert_AV_Q(ntry, ex2(:), wf4(:,1), wf8(:,3), n3(:,16), t3x8(:,:,3))
  call prop_A_Q(ntry, wf8(:,3), 50, MT, 1_intkind1, wf8(:,4), n2(10))
  call vert_VQ_A(ntry, ex5(:), ex1(:), wf4(:,6), n3(:,17), t3x4(:,:,4))
  call prop_Q_A(ntry, wf4(:,6), 17, MT, 1_intkind1, wf4(:,7), n2(11))
  call vert_WQ_A(ntry, ex3(:), wf4(:,7), wf12(:,11), n3(:,18), t3x12(:,:,7))
  call prop_Q_A(ntry, wf12(:,11), 21, MB, 1_intkind1, wf12(:,12), n2(12))
  call vert_AW_Q(ntry, wf6(:,4), ex3(:), wf18(:,3), n3(:,19), t3x18(:,:,2))
  call vert_VQ_A(ntry, ex6(:), wf4(:,7), wf8(:,5), n3(:,20), t3x8(:,:,4))
  call prop_A_Q(ntry, wf18(:,3), 14, MT, 1_intkind1, wf18(:,4), n2(13))
  call vert_VQ_A(ntry, ex6(:), ex1(:), wf4(:,8), n3(:,21), t3x4(:,:,5))
  call prop_Q_A(ntry, wf4(:,8), 33, MT, 1_intkind1, wf4(:,9), n2(14))
  call vert_WQ_A(ntry, ex3(:), wf4(:,9), wf12(:,13), n3(:,22), t3x12(:,:,8))
  call prop_Q_A(ntry, wf12(:,13), 37, MB, 1_intkind1, wf12(:,14), n2(15))
  call vert_VQ_A(ntry, ex5(:), wf4(:,9), wf8(:,6), n3(:,23), t3x8(:,:,5))
  call vert_VQ_A(ntry, wf4(:,1), ex1(:), wf8(:,7), n3(:,24), t3x8(:,:,6))
  call prop_Q_A(ntry, wf8(:,7), 49, MT, 1_intkind1, wf8(:,8), n2(16))
  call vert_VV_S(ntry, ex3(:), ex4(:), wf9(:,1), n3(:,25), t3x9(:,:,1))
  call vert_AQ_S(gH,ntry, wf4(:,5), wf4(:,7), wf16(:,1), n3(:,26), t3x16(:,:,1))
  call vert_UV_W(ntry, ex4(:), 8, ex3(:), 4, wf9(:,2), n3(:,27), t3x9(:,:,2))
  call vert_QA_V(ntry, wf4(:,7), wf4(:,5), wf16(:,2), n3(:,28), t3x16(:,:,2))
  call prop_W_W(ntry, wf9(:,2), 12, MZ, 1_intkind1, wf9(:,3), n2(17))
  call vert_QA_Z(gZu,ntry, wf4(:,7), wf4(:,5), wf16(:,3), n3(:,29), t3x16(:,:,3))
  call vert_SA_Q(gH,ntry, wf9(:,1), ex2(:), wf18(:,5), n3(:,30), t3x18(:,:,3))
  call prop_A_Q(ntry, wf18(:,5), 14, MT, 1_intkind1, wf18(:,6), n2(18))
  call vert_AV_Q(ntry, ex2(:), wf9(:,2), wf18(:,7), n3(:,31), t3x18(:,:,4))
  call prop_A_Q(ntry, wf18(:,7), 14, MT, 1_intkind1, wf18(:,8), n2(19))
  call vert_AZ_Q(gZu,ntry, ex2(:), wf9(:,3), wf18(:,9), n3(:,32), t3x18(:,:,5))
  call prop_A_Q(ntry, wf18(:,9), 14, MT, 1_intkind1, wf18(:,10), n2(20))
  call vert_AQ_S(gH,ntry, wf4(:,3), wf4(:,9), wf16(:,4), n3(:,33), t3x16(:,:,4))
  call vert_QA_V(ntry, wf4(:,9), wf4(:,3), wf16(:,5), n3(:,34), t3x16(:,:,5))
  call vert_QA_Z(gZu,ntry, wf4(:,9), wf4(:,3), wf16(:,6), n3(:,35), t3x16(:,:,6))
  call vert_QS_A(gH,ntry, ex1(:), wf9(:,1), wf18(:,11), n3(:,36), t3x18(:,:,6))
  call prop_Q_A(ntry, wf18(:,11), 13, MT, 1_intkind1, wf18(:,12), n2(21))
  call vert_VQ_A(ntry, wf9(:,2), ex1(:), wf18(:,13), n3(:,37), t3x18(:,:,7))
  call prop_Q_A(ntry, wf18(:,13), 13, MT, 1_intkind1, wf18(:,14), n2(22))
  call vert_ZQ_A(gZu,ntry, wf9(:,3), ex1(:), wf18(:,15), n3(:,38), t3x18(:,:,8))
  call prop_Q_A(ntry, wf18(:,15), 13, MT, 1_intkind1, wf18(:,16), n2(23))
  call vert_QA_V(ntry, ex1(:), ex2(:), wf4(:,10), n3(:,39), t3x4(:,:,6))
  call counter_GGG_V(ctAGGG,ntry, wf4(:,10), ex5(:), ex6(:), wf16(:,7), n4(:,1), t4x16(:,:,1))
  call counter_GGG_V(ctAGGG,ntry, wf4(:,10), ex6(:), ex5(:), wf16(:,8), n4(:,2), t4x16(:,:,2))
  call counter_GGG_V(ctZGGG,ntry, wf4(:,10), ex5(:), ex6(:), wf16(:,9), n4(:,3), t4x16(:,:,3))
  call counter_GGG_V(ctZGGG,ntry, wf4(:,10), ex6(:), ex5(:), wf16(:,10), n4(:,4), t4x16(:,:,4))
  call counter_VVG_G(ntry, ex3(:), ex4(:), wf4(:,10), wf36(:,2), n4(:,5), t4x36(:,:,1))
  call counter_VVG_G(ntry, ex3(:), ex4(:), ex6(:), wf18(:,17), n4(:,6), t4x18(:,:,1))
  call vert_UV_W(ntry, wf4(:,10), 3, ex5(:), 16, wf8(:,9), n3(:,40), t3x8(:,:,7))
  call counter_VVG_G(ntry, ex3(:), ex4(:), ex5(:), wf18(:,18), n4(:,7), t4x18(:,:,2))
  call vert_UV_W(ntry, wf4(:,10), 3, ex6(:), 32, wf8(:,10), n3(:,41), t3x8(:,:,8))
  call vert_QA_V(ntry, wf4(:,7), ex2(:), wf8(:,11), n3(:,42), t3x8(:,:,9))
  call vert_QA_V(ntry, ex1(:), wf4(:,3), wf8(:,12), n3(:,43), t3x8(:,:,10))
  call vert_QA_V(ntry, wf4(:,9), ex2(:), wf8(:,13), n3(:,44), t3x8(:,:,11))
  call vert_QA_V(ntry, ex1(:), wf4(:,5), wf8(:,14), n3(:,45), t3x8(:,:,12))
  call counter_SG_G(ntry, wf9(:,1), wf4(:,10), wf36(:,3), n3(:,46), t3x36(:,:,2))
  call counter_VG_G(ntry, wf9(:,3), wf4(:,10), 3, wf36(:,4), 15, n3(:,47), t3x36(:,:,3))
  call counter_SG_G(ntry, wf9(:,1), ex6(:), wf18(:,19), n3(:,48), t3x18(:,:,9))
  call counter_VG_G(ntry, wf9(:,3), ex6(:), 32, wf18(:,20), 44, n3(:,49), t3x18(:,:,10))
  call counter_SG_G(ntry, wf9(:,1), ex5(:), wf18(:,21), n3(:,50), t3x18(:,:,11))
  call counter_VG_G(ntry, wf9(:,3), ex5(:), 16, wf18(:,22), 28, n3(:,51), t3x18(:,:,12))
  call counter_QA_V(ntry, wf6(:,3), wf6(:,4), wf36(:,5), n3(:,52), t3x36(:,:,4))
  call counter_AV_Q(ntry, wf6(:,4), ex6(:), wf12(:,15), n3(:,53), t3x12(:,:,9))
  call counter_VQ_A(ntry, ex6(:), wf6(:,3), wf12(:,16), n3(:,54), t3x12(:,:,10))
  call counter_AV_Q(ntry, wf6(:,4), ex5(:), wf12(:,17), n3(:,55), t3x12(:,:,11))
  call prop_Q_A(ntry, wf12(:,5), 37, MB, 1_intkind1, wf12(:,18), n2(24))
  call counter_VQ_A(ntry, ex5(:), wf6(:,3), wf12(:,19), n3(:,56), t3x12(:,:,12))
  call prop_A_Q(ntry, wf12(:,2), 42, MB, 1_intkind1, wf12(:,20), n2(25))
  call counter_UV_W(ntry, ex5(:), 16, ex6(:), 32, wf4(:,11), n3(:,57), t3x4(:,:,7))
  call counter_AV_Q(ntry, wf4(:,3), ex6(:), wf8(:,15), n3(:,58), t3x8(:,:,13))
  call counter_AV_Q(ntry, wf4(:,5), ex5(:), wf8(:,16), n3(:,59), t3x8(:,:,14))
  call vert_AV_Q(ntry, ex2(:), wf4(:,11), wf8(:,17), n3(:,60), t3x8(:,:,15))
  call prop_A_Q(ntry, wf8(:,17), 50, MT, 1_intkind1, wf8(:,18), n2(26))
  call counter_AW_Q(ntry, wf4(:,3), ex4(:), wf12(:,21), n3(:,61), t3x12(:,:,13))
  call counter_WQ_A(ntry, ex4(:), wf6(:,3), wf18(:,23), n3(:,62), t3x18(:,:,13))
  call prop_A_Q(ntry, wf8(:,1), 50, MT, 1_intkind1, wf8(:,19), n2(27))
  call counter_AW_Q(ntry, wf4(:,5), ex4(:), wf12(:,22), n3(:,63), t3x12(:,:,14))
  call prop_A_Q(ntry, wf8(:,2), 50, MT, 1_intkind1, wf8(:,20), n2(28))
  call counter_VQ_A(ntry, ex6(:), wf4(:,7), wf8(:,21), n3(:,64), t3x8(:,:,16))
  call counter_VQ_A(ntry, ex5(:), wf4(:,9), wf8(:,22), n3(:,65), t3x8(:,:,17))
  call vert_VQ_A(ntry, wf4(:,11), ex1(:), wf8(:,23), n3(:,66), t3x8(:,:,18))
  call prop_Q_A(ntry, wf8(:,23), 49, MT, 1_intkind1, wf8(:,24), n2(29))
  call counter_AQ_S(gH,ntry, wf4(:,5), wf4(:,7), wf16(:,11), n3(:,67), t3x16(:,:,7))
  call counter_QA_V(ntry, wf4(:,7), wf4(:,5), wf16(:,12), n3(:,68), t3x16(:,:,8))
  call counter_QA_Z(gZu,ntry, wf4(:,7), wf4(:,5), wf16(:,13), n3(:,69), t3x16(:,:,9))
  call counter_AQ_S(gH,ntry, wf4(:,3), wf4(:,9), wf16(:,14), n3(:,70), t3x16(:,:,10))
  call counter_QA_V(ntry, wf4(:,9), wf4(:,3), wf16(:,15), n3(:,71), t3x16(:,:,11))
  call counter_QA_Z(gZu,ntry, wf4(:,9), wf4(:,3), wf16(:,16), n3(:,72), t3x16(:,:,12))
  call counter_AW_Q(ntry, wf6(:,4), ex3(:), wf18(:,24), n3(:,73), t3x18(:,:,14))
  call prop_Q_A(ntry, wf8(:,5), 49, MT, 1_intkind1, wf8(:,25), n2(30))
  call counter_WQ_A(ntry, ex3(:), wf4(:,7), wf12(:,23), n3(:,74), t3x12(:,:,15))
  call prop_Q_A(ntry, wf8(:,6), 49, MT, 1_intkind1, wf8(:,26), n2(31))
  call counter_WQ_A(ntry, ex3(:), wf4(:,9), wf12(:,24), n3(:,75), t3x12(:,:,16))
  call counter_AV_Q(ntry, ex2(:), wf4(:,1), wf8(:,27), n3(:,76), t3x8(:,:,19))
  call counter_AV_Q(ntry, ex2(:), ex6(:), wf4(:,12), n3(:,77), t3x4(:,:,8))
  call prop_A_Q(ntry, wf4(:,12), 34, MT, 1_intkind1, wf4(:,13), n2(32))
  call vert_AV_Q(ntry, wf4(:,13), ex5(:), wf8(:,28), n3(:,78), t3x8(:,:,20))
  call vert_AW_Q(ntry, wf4(:,13), ex4(:), wf12(:,25), n3(:,79), t3x12(:,:,17))
  call prop_A_Q(ntry, wf12(:,25), 42, MB, 1_intkind1, wf12(:,26), n2(33))
  call counter_AV_Q(ntry, ex2(:), ex5(:), wf4(:,14), n3(:,80), t3x4(:,:,9))
  call prop_A_Q(ntry, wf4(:,14), 18, MT, 1_intkind1, wf4(:,15), n2(34))
  call vert_AV_Q(ntry, wf4(:,15), ex6(:), wf8(:,29), n3(:,81), t3x8(:,:,21))
  call vert_AW_Q(ntry, wf4(:,15), ex4(:), wf12(:,27), n3(:,82), t3x12(:,:,18))
  call prop_A_Q(ntry, wf12(:,27), 26, MB, 1_intkind1, wf12(:,28), n2(35))
  call counter_AW_Q(ntry, ex2(:), ex4(:), wf6(:,5), n3(:,83), t3x6(:,:,3))
  call prop_A_Q(ntry, wf6(:,5), 10, MB, 1_intkind1, wf6(:,6), n2(36))
  call vert_QA_V(ntry, wf6(:,3), wf6(:,6), wf36(:,6), n3(:,84), t3x36(:,:,5))
  call vert_AV_Q(ntry, wf6(:,6), ex6(:), wf12(:,29), n3(:,85), t3x12(:,:,19))
  call vert_AV_Q(ntry, wf6(:,6), ex5(:), wf12(:,30), n3(:,86), t3x12(:,:,20))
  call prop_A_Q(ntry, wf12(:,30), 26, MB, 1_intkind1, wf12(:,31), n2(37))
  call counter_SA_Q(gH,ntry, wf9(:,1), ex2(:), wf18(:,25), n3(:,87), t3x18(:,:,15))
  call counter_AV_Q(ntry, ex2(:), wf9(:,2), wf18(:,26), n3(:,88), t3x18(:,:,16))
  call counter_AZ_Q(gZu,ntry, ex2(:), wf9(:,3), wf18(:,27), n3(:,89), t3x18(:,:,17))
  call vert_AQ_S(gH,ntry, wf4(:,13), wf4(:,7), wf16(:,17), n3(:,90), t3x16(:,:,13))
  call vert_QA_V(ntry, wf4(:,7), wf4(:,13), wf16(:,18), n3(:,91), t3x16(:,:,14))
  call vert_QA_Z(gZu,ntry, wf4(:,7), wf4(:,13), wf16(:,19), n3(:,92), t3x16(:,:,15))
  call vert_AQ_S(gH,ntry, wf4(:,15), wf4(:,9), wf16(:,20), n3(:,93), t3x16(:,:,16))
  call vert_QA_V(ntry, wf4(:,9), wf4(:,15), wf16(:,21), n3(:,94), t3x16(:,:,17))
  call vert_QA_Z(gZu,ntry, wf4(:,9), wf4(:,15), wf16(:,22), n3(:,95), t3x16(:,:,18))
  call vert_AW_Q(ntry, wf6(:,6), ex3(:), wf18(:,28), n3(:,96), t3x18(:,:,18))
  call prop_A_Q(ntry, wf18(:,28), 14, MT, 1_intkind1, wf18(:,29), n2(38))
  call counter_VQ_A(ntry, wf4(:,1), ex1(:), wf8(:,30), n3(:,97), t3x8(:,:,22))
  call counter_VQ_A(ntry, ex6(:), ex1(:), wf4(:,16), n3(:,98), t3x4(:,:,10))
  call prop_Q_A(ntry, wf4(:,16), 33, MT, 1_intkind1, wf4(:,17), n2(39))
  call vert_WQ_A(ntry, ex3(:), wf4(:,17), wf12(:,32), n3(:,99), t3x12(:,:,21))
  call prop_Q_A(ntry, wf12(:,32), 37, MB, 1_intkind1, wf12(:,33), n2(40))
  call vert_VQ_A(ntry, ex5(:), wf4(:,17), wf8(:,31), n3(:,100), t3x8(:,:,23))
  call counter_VQ_A(ntry, ex5(:), ex1(:), wf4(:,18), n3(:,101), t3x4(:,:,11))
  call prop_Q_A(ntry, wf4(:,18), 17, MT, 1_intkind1, wf4(:,19), n2(41))
  call vert_WQ_A(ntry, ex3(:), wf4(:,19), wf12(:,34), n3(:,102), t3x12(:,:,22))
  call prop_Q_A(ntry, wf12(:,34), 21, MB, 1_intkind1, wf12(:,35), n2(42))
  call vert_VQ_A(ntry, ex6(:), wf4(:,19), wf8(:,32), n3(:,103), t3x8(:,:,24))
  call counter_QS_A(gH,ntry, ex1(:), wf9(:,1), wf18(:,30), n3(:,104), t3x18(:,:,19))
  call counter_VQ_A(ntry, wf9(:,2), ex1(:), wf18(:,31), n3(:,105), t3x18(:,:,20))
  call counter_ZQ_A(gZu,ntry, wf9(:,3), ex1(:), wf18(:,32), n3(:,106), t3x18(:,:,21))
  call vert_AQ_S(gH,ntry, wf4(:,3), wf4(:,17), wf16(:,23), n3(:,107), t3x16(:,:,19))
  call vert_QA_V(ntry, wf4(:,17), wf4(:,3), wf16(:,24), n3(:,108), t3x16(:,:,20))
  call vert_QA_Z(gZu,ntry, wf4(:,17), wf4(:,3), wf16(:,25), n3(:,109), t3x16(:,:,21))
  call vert_AQ_S(gH,ntry, wf4(:,5), wf4(:,19), wf16(:,26), n3(:,110), t3x16(:,:,22))
  call vert_QA_V(ntry, wf4(:,19), wf4(:,5), wf16(:,27), n3(:,111), t3x16(:,:,23))
  call vert_QA_Z(gZu,ntry, wf4(:,19), wf4(:,5), wf16(:,28), n3(:,112), t3x16(:,:,24))
  call counter_WQ_A(ntry, ex3(:), ex1(:), wf6(:,7), n3(:,113), t3x6(:,:,4))
  call prop_Q_A(ntry, wf6(:,7), 5, MB, 1_intkind1, wf6(:,8), n2(43))
  call vert_QA_V(ntry, wf6(:,8), wf6(:,4), wf36(:,7), n3(:,114), t3x36(:,:,6))
  call vert_VQ_A(ntry, ex5(:), wf6(:,8), wf12(:,36), n3(:,115), t3x12(:,:,23))
  call prop_Q_A(ntry, wf12(:,36), 21, MB, 1_intkind1, wf12(:,37), n2(44))
  call vert_VQ_A(ntry, ex6(:), wf6(:,8), wf12(:,38), n3(:,116), t3x12(:,:,24))
  call vert_WQ_A(ntry, ex4(:), wf6(:,8), wf18(:,33), n3(:,117), t3x18(:,:,22))
  call prop_Q_A(ntry, wf18(:,33), 13, MT, 1_intkind1, wf18(:,34), n2(45))
  call vert_AV_Q(ntry, wf6(:,4), wf4(:,1), wf24(:,1), n3(:,118), t3x24(:,:,1))
  call counter_Q_A(ctbb,5,ntry, wf6(:,3), 5, wf6(:,9), n2(46))
  call prop_A_Q(ntry, wf24(:,1), 58, MB, 1_intkind1, wf24(:,2), n2(47))
  call vert_VQ_A(ntry, wf4(:,1), wf6(:,3), wf24(:,3), n3(:,119), t3x24(:,:,2))
  call counter_A_Q(ctbb,5,ntry, wf6(:,4), 10, wf6(:,10), n2(48))
  call prop_Q_A(ntry, wf24(:,3), 53, MB, 1_intkind1, wf24(:,4), n2(49))
  call counter_V_V(ctGG,21,ntry, wf4(:,1), 48, wf4(:,20), n2(50))
  call prop_Q_A(ntry, wf6(:,9), 5, MB, 1_intkind1, wf6(:,11), n2(51))
  call vert_VQ_A(ntry, ex5(:), wf6(:,11), wf12(:,39), n3(:,120), t3x12(:,:,25))
  call vert_VQ_A(ntry, ex6(:), wf6(:,11), wf12(:,40), n3(:,121), t3x12(:,:,26))
  call prop_A_Q(ntry, wf6(:,10), 10, MB, 1_intkind1, wf6(:,12), n2(52))
  call vert_AV_Q(ntry, wf6(:,12), ex5(:), wf12(:,41), n3(:,122), t3x12(:,:,27))
  call vert_AV_Q(ntry, wf6(:,12), ex6(:), wf12(:,42), n3(:,123), t3x12(:,:,28))
  call counter_Q_A(ctbb,5,ntry, wf12(:,3), 21, wf12(:,43), n2(53))
  call counter_A_Q(ctbb,5,ntry, wf12(:,6), 26, wf12(:,44), n2(54))
  call vert_WQ_A(ntry, ex4(:), wf6(:,11), wf18(:,35), n3(:,124), t3x18(:,:,23))
  call counter_A_Q(cttt,6,ntry, wf4(:,3), 18, wf4(:,21), n2(55))
  call prop_A_Q(ntry, wf4(:,21), 18, MT, 1_intkind1, wf4(:,22), n2(56))
  call vert_AW_Q(ntry, wf4(:,22), ex4(:), wf12(:,45), n3(:,125), t3x12(:,:,29))
  call vert_AV_Q(ntry, wf4(:,22), ex6(:), wf8(:,33), n3(:,126), t3x8(:,:,25))
  call counter_Q_A(cttt,6,ntry, wf18(:,2), 13, wf18(:,36), n2(57))
  call counter_A_Q(ctbb,5,ntry, wf12(:,8), 26, wf12(:,46), n2(58))
  call counter_A_Q(cttt,6,ntry, wf4(:,5), 34, wf4(:,23), n2(59))
  call prop_A_Q(ntry, wf4(:,23), 34, MT, 1_intkind1, wf4(:,24), n2(60))
  call vert_AW_Q(ntry, wf4(:,24), ex4(:), wf12(:,47), n3(:,127), t3x12(:,:,30))
  call vert_AV_Q(ntry, wf4(:,24), ex5(:), wf8(:,34), n3(:,128), t3x8(:,:,26))
  call counter_A_Q(ctbb,5,ntry, wf12(:,10), 42, wf12(:,48), n2(61))
  call counter_A_Q(cttt,6,ntry, wf8(:,4), 50, wf8(:,35), n2(62))
  call vert_AV_Q(ntry, ex2(:), wf4(:,20), wf8(:,36), n3(:,129), t3x8(:,:,27))
  call counter_Q_A(cttt,6,ntry, wf4(:,7), 17, wf4(:,25), n2(63))
  call prop_Q_A(ntry, wf4(:,25), 17, MT, 1_intkind1, wf4(:,26), n2(64))
  call vert_WQ_A(ntry, ex3(:), wf4(:,26), wf12(:,49), n3(:,130), t3x12(:,:,31))
  call vert_VQ_A(ntry, ex6(:), wf4(:,26), wf8(:,37), n3(:,131), t3x8(:,:,28))
  call vert_AW_Q(ntry, wf6(:,12), ex3(:), wf18(:,37), n3(:,132), t3x18(:,:,24))
  call counter_Q_A(ctbb,5,ntry, wf12(:,12), 21, wf12(:,50), n2(65))
  call counter_A_Q(cttt,6,ntry, wf18(:,4), 14, wf18(:,38), n2(66))
  call counter_Q_A(cttt,6,ntry, wf4(:,9), 33, wf4(:,27), n2(67))
  call prop_Q_A(ntry, wf4(:,27), 33, MT, 1_intkind1, wf4(:,28), n2(68))
  call vert_WQ_A(ntry, ex3(:), wf4(:,28), wf12(:,51), n3(:,133), t3x12(:,:,32))
  call vert_VQ_A(ntry, ex5(:), wf4(:,28), wf8(:,38), n3(:,134), t3x8(:,:,29))
  call counter_Q_A(ctbb,5,ntry, wf12(:,14), 37, wf12(:,52), n2(69))
  call counter_Q_A(cttt,6,ntry, wf8(:,8), 49, wf8(:,39), n2(70))
  call vert_VQ_A(ntry, wf4(:,20), ex1(:), wf8(:,40), n3(:,135), t3x8(:,:,30))
  call vert_SA_Q(gH,ntry, wf9(:,1), wf4(:,5), wf36(:,8), n3(:,136), t3x36(:,:,7))
  call prop_A_Q(ntry, wf36(:,8), 46, MT, 1_intkind1, wf36(:,9), n2(71))
  call vert_AV_Q(ntry, wf4(:,5), wf9(:,2), wf36(:,10), n3(:,137), t3x36(:,:,8))
  call prop_A_Q(ntry, wf36(:,10), 46, MT, 1_intkind1, wf36(:,11), n2(72))
  call vert_AZ_Q(gZu,ntry, wf4(:,5), wf9(:,3), wf36(:,12), n3(:,138), t3x36(:,:,9))
  call prop_A_Q(ntry, wf36(:,12), 46, MT, 1_intkind1, wf36(:,13), n2(73))
  call vert_QS_A(gH,ntry, wf4(:,7), wf9(:,1), wf36(:,14), n3(:,139), t3x36(:,:,10))
  call prop_Q_A(ntry, wf36(:,14), 29, MT, 1_intkind1, wf36(:,15), n2(74))
  call vert_VQ_A(ntry, wf9(:,2), wf4(:,7), wf36(:,16), n3(:,140), t3x36(:,:,11))
  call prop_Q_A(ntry, wf36(:,16), 29, MT, 1_intkind1, wf36(:,17), n2(75))
  call vert_ZQ_A(gZu,ntry, wf9(:,3), wf4(:,7), wf36(:,18), n3(:,141), t3x36(:,:,12))
  call prop_Q_A(ntry, wf36(:,18), 29, MT, 1_intkind1, wf36(:,19), n2(76))
  call counter_A_Q(cttt,6,ntry, wf18(:,6), 14, wf18(:,39), n2(77))
  call counter_A_Q(cttt,6,ntry, wf18(:,8), 14, wf18(:,40), n2(78))
  call counter_A_Q(cttt,6,ntry, wf18(:,10), 14, wf18(:,41), n2(79))
  call vert_SA_Q(gH,ntry, wf9(:,1), wf4(:,3), wf36(:,20), n3(:,142), t3x36(:,:,13))
  call prop_A_Q(ntry, wf36(:,20), 30, MT, 1_intkind1, wf36(:,21), n2(80))
  call vert_AV_Q(ntry, wf4(:,3), wf9(:,2), wf36(:,22), n3(:,143), t3x36(:,:,14))
  call prop_A_Q(ntry, wf36(:,22), 30, MT, 1_intkind1, wf36(:,23), n2(81))
  call vert_AZ_Q(gZu,ntry, wf4(:,3), wf9(:,3), wf36(:,24), n3(:,144), t3x36(:,:,15))
  call prop_A_Q(ntry, wf36(:,24), 30, MT, 1_intkind1, wf36(:,25), n2(82))
  call vert_QS_A(gH,ntry, wf4(:,9), wf9(:,1), wf36(:,26), n3(:,145), t3x36(:,:,16))
  call prop_Q_A(ntry, wf36(:,26), 45, MT, 1_intkind1, wf36(:,27), n2(83))
  call vert_VQ_A(ntry, wf9(:,2), wf4(:,9), wf36(:,28), n3(:,146), t3x36(:,:,17))
  call prop_Q_A(ntry, wf36(:,28), 45, MT, 1_intkind1, wf36(:,29), n2(84))
  call vert_ZQ_A(gZu,ntry, wf9(:,3), wf4(:,9), wf36(:,30), n3(:,147), t3x36(:,:,18))
  call prop_Q_A(ntry, wf36(:,30), 45, MT, 1_intkind1, wf36(:,31), n2(85))
  call counter_Q_A(cttt,6,ntry, wf18(:,12), 13, wf18(:,42), n2(86))
  call counter_Q_A(cttt,6,ntry, wf18(:,14), 13, wf18(:,43), n2(87))
  call counter_Q_A(cttt,6,ntry, wf18(:,16), 13, wf18(:,44), n2(88))
  call vert_QA_V(ntry, wf18(:,2), ex2(:), wf36(:,32), n3(:,148), t3x36(:,:,19))
  call vert_VQ_A(ntry, ex5(:), wf18(:,2), wf36(:,33), n3(:,149), t3x36(:,:,20))
  call prop_Q_A(ntry, wf36(:,33), 29, MT, 1_intkind1, wf36(:,34), n2(89))
  call vert_VQ_A(ntry, ex6(:), wf18(:,2), wf36(:,35), n3(:,150), t3x36(:,:,21))
  call prop_Q_A(ntry, wf36(:,35), 45, MT, 1_intkind1, wf36(:,36), n2(90))
  call vert_WQ_A(ntry, ex4(:), wf12(:,3), wf36(:,37), n3(:,151), t3x36(:,:,22))
  call prop_Q_A(ntry, wf36(:,37), 29, MT, 1_intkind1, wf36(:,38), n2(91))
  call vert_VQ_A(ntry, ex6(:), wf12(:,3), wf24(:,5), n3(:,152), t3x24(:,:,3))
  call prop_Q_A(ntry, wf24(:,5), 53, MB, 1_intkind1, wf24(:,6), n2(92))
  call vert_WQ_A(ntry, ex4(:), wf12(:,18), wf36(:,39), n3(:,153), t3x36(:,:,23))
  call prop_Q_A(ntry, wf36(:,39), 45, MT, 1_intkind1, wf36(:,40), n2(93))
  call vert_VQ_A(ntry, ex5(:), wf12(:,18), wf24(:,7), n3(:,154), t3x24(:,:,4))
  call prop_Q_A(ntry, wf24(:,7), 53, MB, 1_intkind1, wf24(:,8), n2(94))
  call vert_QA_V(ntry, ex1(:), wf18(:,4), wf36(:,41), n3(:,155), t3x36(:,:,24))
  call vert_AV_Q(ntry, wf18(:,4), ex5(:), wf36(:,42), n3(:,156), t3x36(:,:,25))
  call prop_A_Q(ntry, wf36(:,42), 30, MT, 1_intkind1, wf36(:,43), n2(95))
  call vert_AV_Q(ntry, wf18(:,4), ex6(:), wf36(:,44), n3(:,157), t3x36(:,:,26))
  call prop_A_Q(ntry, wf36(:,44), 46, MT, 1_intkind1, wf36(:,45), n2(96))
  call vert_AW_Q(ntry, wf12(:,6), ex3(:), wf36(:,46), n3(:,158), t3x36(:,:,27))
  call prop_A_Q(ntry, wf36(:,46), 30, MT, 1_intkind1, wf36(:,47), n2(97))
  call vert_AV_Q(ntry, wf12(:,6), ex6(:), wf24(:,9), n3(:,159), t3x24(:,:,5))
  call prop_A_Q(ntry, wf24(:,9), 58, MB, 1_intkind1, wf24(:,10), n2(98))
  call vert_AW_Q(ntry, wf12(:,20), ex3(:), wf36(:,48), n3(:,160), t3x36(:,:,28))
  call prop_A_Q(ntry, wf36(:,48), 46, MT, 1_intkind1, wf36(:,49), n2(99))
  call vert_AV_Q(ntry, wf12(:,20), ex5(:), wf24(:,11), n3(:,161), t3x24(:,:,6))
  call prop_A_Q(ntry, wf24(:,11), 58, MB, 1_intkind1, wf24(:,12), n2(100))
  call vert_QA_V(ntry, wf18(:,12), ex2(:), wf36(:,50), n3(:,162), t3x36(:,:,29))
  call vert_QA_V(ntry, wf18(:,14), ex2(:), wf36(:,51), n3(:,163), t3x36(:,:,30))
  call vert_QA_V(ntry, wf18(:,16), ex2(:), wf36(:,52), n3(:,164), t3x36(:,:,31))
  call vert_QA_V(ntry, ex1(:), wf18(:,6), wf36(:,53), n3(:,165), t3x36(:,:,32))
  call vert_QA_V(ntry, ex1(:), wf18(:,8), wf36(:,54), n3(:,166), t3x36(:,:,33))
  call vert_QA_V(ntry, ex1(:), wf18(:,10), wf36(:,55), n3(:,167), t3x36(:,:,34))
  call vert_VQ_A(ntry, ex5(:), wf18(:,12), wf36(:,56), n3(:,168), t3x36(:,:,35))
  call prop_Q_A(ntry, wf36(:,56), 29, MT, 1_intkind1, wf36(:,57), n2(101))
  call vert_VQ_A(ntry, ex5(:), wf18(:,14), wf36(:,58), n3(:,169), t3x36(:,:,36))
  call prop_Q_A(ntry, wf36(:,58), 29, MT, 1_intkind1, wf36(:,59), n2(102))
  call vert_VQ_A(ntry, ex5(:), wf18(:,16), wf36(:,60), n3(:,170), t3x36(:,:,37))
  call prop_Q_A(ntry, wf36(:,60), 29, MT, 1_intkind1, wf36(:,61), n2(103))
  call vert_VQ_A(ntry, ex6(:), wf18(:,12), wf36(:,62), n3(:,171), t3x36(:,:,38))
  call prop_Q_A(ntry, wf36(:,62), 45, MT, 1_intkind1, wf36(:,63), n2(104))
  call vert_VQ_A(ntry, ex6(:), wf18(:,14), wf36(:,64), n3(:,172), t3x36(:,:,39))
  call prop_Q_A(ntry, wf36(:,64), 45, MT, 1_intkind1, wf36(:,65), n2(105))
  call vert_VQ_A(ntry, ex6(:), wf18(:,16), wf36(:,66), n3(:,173), t3x36(:,:,40))
  call prop_Q_A(ntry, wf36(:,66), 45, MT, 1_intkind1, wf36(:,67), n2(106))
  call vert_AV_Q(ntry, wf18(:,6), ex5(:), wf36(:,68), n3(:,174), t3x36(:,:,41))
  call prop_A_Q(ntry, wf36(:,68), 30, MT, 1_intkind1, wf36(:,69), n2(107))
  call vert_AV_Q(ntry, wf18(:,8), ex5(:), wf36(:,70), n3(:,175), t3x36(:,:,42))
  call prop_A_Q(ntry, wf36(:,70), 30, MT, 1_intkind1, wf36(:,71), n2(108))
  call vert_AV_Q(ntry, wf18(:,10), ex5(:), wf36(:,72), n3(:,176), t3x36(:,:,43))
  call prop_A_Q(ntry, wf36(:,72), 30, MT, 1_intkind1, wf36(:,73), n2(109))
  call vert_AV_Q(ntry, wf18(:,6), ex6(:), wf36(:,74), n3(:,177), t3x36(:,:,44))
  call prop_A_Q(ntry, wf36(:,74), 46, MT, 1_intkind1, wf36(:,75), n2(110))
  call vert_AV_Q(ntry, wf18(:,8), ex6(:), wf36(:,76), n3(:,178), t3x36(:,:,45))
  call prop_A_Q(ntry, wf36(:,76), 46, MT, 1_intkind1, wf36(:,77), n2(111))
  call vert_AV_Q(ntry, wf18(:,10), ex6(:), wf36(:,78), n3(:,179), t3x36(:,:,46))
  call prop_A_Q(ntry, wf36(:,78), 46, MT, 1_intkind1, wf36(:,79), n2(112))
  call vert_WQ_A(ntry, ex4(:), wf12(:,12), wf36(:,80), n3(:,180), t3x36(:,:,47))
  call prop_Q_A(ntry, wf36(:,80), 29, MT, 1_intkind1, wf36(:,81), n2(113))
  call vert_VQ_A(ntry, ex6(:), wf12(:,12), wf24(:,13), n3(:,181), t3x24(:,:,7))
  call prop_Q_A(ntry, wf24(:,13), 53, MB, 1_intkind1, wf24(:,14), n2(114))
  call vert_WQ_A(ntry, ex3(:), wf8(:,25), wf24(:,15), n3(:,182), t3x24(:,:,8))
  call prop_Q_A(ntry, wf24(:,15), 53, MB, 1_intkind1, wf24(:,16), n2(115))
  call vert_AW_Q(ntry, wf12(:,8), ex3(:), wf36(:,82), n3(:,183), t3x36(:,:,48))
  call prop_A_Q(ntry, wf36(:,82), 30, MT, 1_intkind1, wf36(:,83), n2(116))
  call vert_AV_Q(ntry, wf12(:,8), ex6(:), wf24(:,17), n3(:,184), t3x24(:,:,9))
  call prop_A_Q(ntry, wf24(:,17), 58, MB, 1_intkind1, wf24(:,18), n2(117))
  call vert_AW_Q(ntry, wf8(:,19), ex4(:), wf24(:,19), n3(:,185), t3x24(:,:,10))
  call prop_A_Q(ntry, wf24(:,19), 58, MB, 1_intkind1, wf24(:,20), n2(118))
  call vert_WQ_A(ntry, ex4(:), wf12(:,14), wf36(:,84), n3(:,186), t3x36(:,:,49))
  call prop_Q_A(ntry, wf36(:,84), 45, MT, 1_intkind1, wf36(:,85), n2(119))
  call vert_VQ_A(ntry, ex5(:), wf12(:,14), wf24(:,21), n3(:,187), t3x24(:,:,11))
  call prop_Q_A(ntry, wf24(:,21), 53, MB, 1_intkind1, wf24(:,22), n2(120))
  call vert_WQ_A(ntry, ex3(:), wf8(:,26), wf24(:,23), n3(:,188), t3x24(:,:,12))
  call prop_Q_A(ntry, wf24(:,23), 53, MB, 1_intkind1, wf24(:,24), n2(121))
  call vert_AW_Q(ntry, wf12(:,10), ex3(:), wf36(:,86), n3(:,189), t3x36(:,:,50))
  call prop_A_Q(ntry, wf36(:,86), 46, MT, 1_intkind1, wf36(:,87), n2(122))
  call vert_AV_Q(ntry, wf12(:,10), ex5(:), wf24(:,25), n3(:,190), t3x24(:,:,13))
  call prop_A_Q(ntry, wf24(:,25), 58, MB, 1_intkind1, wf24(:,26), n2(123))
  call vert_AW_Q(ntry, wf8(:,20), ex4(:), wf24(:,27), n3(:,191), t3x24(:,:,14))
  call prop_A_Q(ntry, wf24(:,27), 58, MB, 1_intkind1, wf24(:,28), n2(124))
  call vert_WQ_A(ntry, ex3(:), wf8(:,8), wf24(:,29), n3(:,192), t3x24(:,:,15))
  call prop_Q_A(ntry, wf24(:,29), 53, MB, 1_intkind1, wf24(:,30), n2(125))
  call vert_AW_Q(ntry, wf8(:,4), ex4(:), wf24(:,31), n3(:,193), t3x24(:,:,16))
  call prop_A_Q(ntry, wf24(:,31), 58, MB, 1_intkind1, wf24(:,32), n2(126))


  if (ntry==1) then
    call physical_helicities()
  end if

  ! computation of the colour-stripped amplitudes
  do nsync = ntry+ntry-1, ntry+1  !  nsync = 1,2  for 1st point and nsync = 3 later
    call diagrams()
    if (nsync == 1) call helsync(nsync, A, nhel, Hel)
  end do

  if (ntry < 2) then
    if(hel_mem_opt) hel_states = nhel
    call allocate_diagrams()
  end if

  ! In the following loop the coefficients \Gamma_{i} of the expansion in
  ! the colour basis are computed for every helicity state and stored in M1helarray.
  ! Also the colour vector for the Born-loop interference is computed and saved in
  ! M0_col1_helarray
  do k = 1, nhel
    if (do_ct) call colourvectors(A, k, M1helarray(:,k),M1helarray_ct(:,k))
    call colborninterf(M1helarray(:,k), M0_col1_helarray(:,k), 0)
  end do
  M1helarray(:,nhel+1:)%j = 0
  M0_col1_helarray(:,nhel+1:)%hf = -1_intkind2
  M0_col1_helarray(:,nhel+1:)%j = 0

  M2add = 0
  M2add_ct = 0
  M2add_colint = 0

  M02 = 0
  if (do_ct) M2ct = 0
  if (do_colint) M2colint = 0

  do k = 1, nhel
    call colint(M1helarray(:,k)%j, M2add)
    if (do_ct) call colint_ct(M1helarray(:,k)%j, M1helarray_ct(:,k)%j, M2add_ct, 0)
    if (IR_is_on > 0) then
      if (do_colint) call colint_IR(M1helarray(:,k)%j, M2add_colint)
    end if
    !summation over helicity configurations
    M02 = M02 + M2add
    if (do_ct) M2ct = M2ct + M2add_ct
    if (do_colint) M2colint = M2colint + M2add_colint
  end do

#if -1 > 0 && 6 > 3
  if (loopcc) then
    !!Born-loop colour correlators interference
    
    M0M1_hel_cc(:,:,:)%j = 0
    M2ctcc = 0
    do n = 1, 9
      M2add_ct = 0
      m = ind_cc_comb(n)
        do k = 1, nhel
          call colint_ct(M1helarray(:,k)%j, M1helarray_ct(:,k)%j, M2add_ct, m)
          call colborninterf(M1helarray(:,k), M0M1_hel_cc(:,k,m), m)
          M2ctcc(m) = M2ctcc(m) + M2add_ct
        end do
    end do
    M0M1_hel_cc(:,nhel+1:,:)%hf = -1_intkind2
    M0M1_hel_cc(:,nhel+1:,:)%j = 0
  end if
#endif

  if (ntry < 1) then
    if (allocated(A)) deallocate(A)
  end if
  ntry=2


  contains

subroutine physical_helicities()
  implicit none

integer :: i1,i2,i3,i4,i5,i6
integer :: n

n=0

do i6= 1, 2
do i5= 1, 2
do i4= 1, 3
do i3= 1, 3
do i2= 1, 2
do i1= 1, 2
n = n + 1
 if((ex1(i1)%hf==-1_intkind2) .OR. (ex2(i2)%hf==-1_intkind2) .OR. (ex3(i3)%hf==-1_intkind2) .OR. (ex4(i4)%hf==-1_intkind2)  &
    .OR. (ex5(i5)%hf==-1_intkind2) .OR. (ex6(i6)%hf==-1_intkind2)) then
  Hel(n) = -1_intkind2
 else
  Hel(n) = ex1(i1)%hf + ex2(i2)%hf + ex3(i3)%hf + ex4(i4)%hf + ex5(i5)%hf + ex6(i6)%hf
 end if
end do
end do
end do
end do
end do
end do

end subroutine physical_helicities

subroutine diagrams()
  implicit none
  integer :: h
  ! e.g. call cont_VV(nsync, wf3, wf6, A(:,1), n64, t64, nhel, den(5)) ...

    call Hcont_VV(nsync, wf4(:,1), wf36(:,1), A(:,1), n3(:,194), t3x144(:,:,1), nhel, den(5))
    call Hcont_QA(nsync, wf12(:,2), wf12(:,3), A(:,2), n3(:,195), t3x144(:,:,2), nhel, den(8))
    call Hcont_QA(nsync, wf12(:,5), wf12(:,6), A(:,3), n3(:,196), t3x144(:,:,3), nhel, den(11))
    call Hcont_QA(nsync, wf8(:,1), wf18(:,2), A(:,4), n3(:,197), t3x144(:,:,4), nhel, den(15))
    call Hcont_QA(nsync, wf12(:,5), wf12(:,8), A(:,5), n3(:,198), t3x144(:,:,5), nhel, den(17))
    call Hcont_QA(nsync, wf18(:,2), wf8(:,2), A(:,6), n3(:,199), t3x144(:,:,6), nhel, den(19))
    call Hcont_QA(nsync, wf12(:,1), wf12(:,10), A(:,7), n3(:,200), t3x144(:,:,7), nhel, den(22))
    call Hcont_QA(nsync, wf18(:,1), wf8(:,4), A(:,8), n3(:,201), t3x144(:,:,8), nhel, den(25))
    call Hcont_QA(nsync, wf12(:,2), wf12(:,12), A(:,9), n3(:,202), t3x144(:,:,9), nhel, den(28))
    call Hcont_QA(nsync, wf8(:,5), wf18(:,4), A(:,10), n3(:,203), t3x144(:,:,10), nhel, den(31))
    call Hcont_QA(nsync, wf12(:,4), wf12(:,14), A(:,11), n3(:,204), t3x144(:,:,11), nhel, den(35))
    call Hcont_QA(nsync, wf18(:,4), wf8(:,6), A(:,12), n3(:,205), t3x144(:,:,12), nhel, den(36))
    call Hcont_QA(nsync, wf18(:,3), wf8(:,8), A(:,13), n3(:,206), t3x144(:,:,13), nhel, den(39))
    call Hcont_SS(nsync, wf9(:,1), wf16(:,1), A(:,14), n3(:,207), t3x144(:,:,14), nhel, den(42))
    call Hcont_VV(nsync, wf9(:,2), wf16(:,2), A(:,15), n3(:,208), t3x144(:,:,15), nhel, den(44))
    call Hcont_VV(nsync, wf9(:,3), wf16(:,3), A(:,16), n3(:,209), t3x144(:,:,16), nhel, den(46))
    call Hcont_QA(nsync, wf8(:,5), wf18(:,6), A(:,17), n3(:,210), t3x144(:,:,17), nhel, den(48))
    call Hcont_QA(nsync, wf8(:,5), wf18(:,8), A(:,18), n3(:,211), t3x144(:,:,18), nhel, den(50))
    call Hcont_QA(nsync, wf8(:,5), wf18(:,10), A(:,19), n3(:,212), t3x144(:,:,19), nhel, den(52))
    call Hcont_SS(nsync, wf9(:,1), wf16(:,4), A(:,20), n3(:,213), t3x144(:,:,20), nhel, den(54))
    call Hcont_VV(nsync, wf9(:,2), wf16(:,5), A(:,21), n3(:,214), t3x144(:,:,21), nhel, den(55))
    call Hcont_VV(nsync, wf9(:,3), wf16(:,6), A(:,22), n3(:,215), t3x144(:,:,22), nhel, den(56))
    call Hcont_QA(nsync, wf8(:,1), wf18(:,12), A(:,23), n3(:,216), t3x144(:,:,23), nhel, den(58))
    call Hcont_QA(nsync, wf8(:,1), wf18(:,14), A(:,24), n3(:,217), t3x144(:,:,24), nhel, den(60))
    call Hcont_QA(nsync, wf8(:,1), wf18(:,16), A(:,25), n3(:,218), t3x144(:,:,25), nhel, den(62))
    call Hcont_QA(nsync, wf8(:,6), wf18(:,6), A(:,26), n3(:,219), t3x144(:,:,26), nhel, den(63))
    call Hcont_QA(nsync, wf8(:,6), wf18(:,8), A(:,27), n3(:,220), t3x144(:,:,27), nhel, den(64))
    call Hcont_QA(nsync, wf8(:,6), wf18(:,10), A(:,28), n3(:,221), t3x144(:,:,28), nhel, den(65))
    call Hcont_QA(nsync, wf8(:,2), wf18(:,12), A(:,29), n3(:,222), t3x144(:,:,29), nhel, den(66))
    call Hcont_QA(nsync, wf8(:,2), wf18(:,14), A(:,30), n3(:,223), t3x144(:,:,30), nhel, den(67))
    call Hcont_QA(nsync, wf8(:,2), wf18(:,16), A(:,31), n3(:,224), t3x144(:,:,31), nhel, den(68))
    call Hcont_QA(nsync, wf8(:,3), wf18(:,12), A(:,32), n3(:,225), t3x144(:,:,32), nhel, den(69))
    call Hcont_QA(nsync, wf8(:,3), wf18(:,14), A(:,33), n3(:,226), t3x144(:,:,33), nhel, den(70))
    call Hcont_QA(nsync, wf8(:,3), wf18(:,16), A(:,34), n3(:,227), t3x144(:,:,34), nhel, den(71))
    call Hcont_QA(nsync, wf8(:,8), wf18(:,5), A(:,35), n3(:,228), t3x144(:,:,35), nhel, den(72))
    call Hcont_QA(nsync, wf8(:,8), wf18(:,7), A(:,36), n3(:,229), t3x144(:,:,36), nhel, den(73))
    call Hcont_QA(nsync, wf8(:,8), wf18(:,9), A(:,37), n3(:,230), t3x144(:,:,37), nhel, den(74))
    call Hcont_QA(nsync, wf12(:,9), wf12(:,12), A(:,38), n3(:,231), t3x144(:,:,38), nhel, den(75))
    call Hcont_QA(nsync, wf12(:,7), wf12(:,14), A(:,39), n3(:,232), t3x144(:,:,39), nhel, den(76))

    call Hcont_VV(nsync, wf9(:,2), wf16(:,7), A(:,40), n3(:,233), t3x144(:,:,40), nhel, den(78))
    call Hcont_VV(nsync, wf9(:,2), wf16(:,8), A(:,41), n3(:,234), t3x144(:,:,41), nhel, den(78))
    call Hcont_VV(nsync, wf9(:,3), wf16(:,9), A(:,42), n3(:,235), t3x144(:,:,42), nhel, den(79))
    call Hcont_VV(nsync, wf9(:,3), wf16(:,10), A(:,43), n3(:,236), t3x144(:,:,43), nhel, den(79))
    call Hcont_VV(nsync, wf4(:,1), wf36(:,2), A(:,44), n3(:,237), t3x144(:,:,44), nhel, den(80))
    call Hcont_VV(nsync, wf18(:,17), wf8(:,9), A(:,45), n3(:,238), t3x144(:,:,45), nhel, den(82))
    call Hcont_VV(nsync, wf18(:,18), wf8(:,10), A(:,46), n3(:,239), t3x144(:,:,46), nhel, den(84))
    call Hcont_VV(nsync, wf18(:,17), wf8(:,11), A(:,47), n3(:,240), t3x144(:,:,47), nhel, den(85))
    call Hcont_VV(nsync, wf18(:,17), wf8(:,12), A(:,48), n3(:,241), t3x144(:,:,48), nhel, den(86))
    call Hcont_VV(nsync, wf18(:,18), wf8(:,13), A(:,49), n3(:,242), t3x144(:,:,49), nhel, den(87))
    call Hcont_VV(nsync, wf18(:,18), wf8(:,14), A(:,50), n3(:,243), t3x144(:,:,50), nhel, den(88))
    call Hcont_VV(nsync, wf4(:,1), wf36(:,3), A(:,51), n3(:,244), t3x144(:,:,51), nhel, den(90))
    call Hcont_VV(nsync, wf4(:,1), wf36(:,4), A(:,52), n3(:,245), t3x144(:,:,52), nhel, den(91))
    call Hcont_VV(nsync, wf8(:,9), wf18(:,19), A(:,53), n3(:,246), t3x144(:,:,53), nhel, den(94))
    call Hcont_VV(nsync, wf8(:,9), wf18(:,20), A(:,54), n3(:,247), t3x144(:,:,54), nhel, den(95))
    call Hcont_VV(nsync, wf8(:,10), wf18(:,21), A(:,55), n3(:,248), t3x144(:,:,55), nhel, den(98))
    call Hcont_VV(nsync, wf8(:,10), wf18(:,22), A(:,56), n3(:,249), t3x144(:,:,56), nhel, den(99))
    call Hcont_VV(nsync, wf4(:,1), wf36(:,5), A(:,57), n3(:,250), t3x144(:,:,57), nhel, den(5))
    call Hcont_QA(nsync, wf12(:,3), wf12(:,15), A(:,58), n3(:,251), t3x144(:,:,58), nhel, den(8))
    call Hcont_QA(nsync, wf12(:,6), wf12(:,16), A(:,59), n3(:,252), t3x144(:,:,59), nhel, den(11))
    call Hcont_QA(nsync, wf12(:,17), wf12(:,18), A(:,60), n3(:,253), t3x144(:,:,60), nhel, den(101))
    call Hcont_QA(nsync, wf12(:,19), wf12(:,20), A(:,61), n3(:,254), t3x144(:,:,61), nhel, den(103))
    call Hcont_VV(nsync, wf36(:,1), wf4(:,11), A(:,62), n3(:,255), t3x144(:,:,62), nhel, den(5))
    call Hcont_QA(nsync, wf18(:,2), wf8(:,15), A(:,63), n3(:,256), t3x144(:,:,63), nhel, den(15))
    call Hcont_QA(nsync, wf12(:,8), wf12(:,16), A(:,64), n3(:,257), t3x144(:,:,64), nhel, den(17))
    call Hcont_QA(nsync, wf18(:,2), wf8(:,16), A(:,65), n3(:,258), t3x144(:,:,65), nhel, den(19))
    call Hcont_QA(nsync, wf12(:,10), wf12(:,19), A(:,66), n3(:,259), t3x144(:,:,66), nhel, den(22))
    call Hcont_QA(nsync, wf18(:,1), wf8(:,18), A(:,67), n3(:,260), t3x144(:,:,67), nhel, den(25))
    call Hcont_QA(nsync, wf12(:,18), wf12(:,21), A(:,68), n3(:,261), t3x144(:,:,68), nhel, den(104))
    call Hcont_QA(nsync, wf18(:,23), wf8(:,19), A(:,69), n3(:,262), t3x144(:,:,69), nhel, den(106))
    call Hcont_QA(nsync, wf12(:,3), wf12(:,22), A(:,70), n3(:,263), t3x144(:,:,70), nhel, den(107))
    call Hcont_QA(nsync, wf18(:,23), wf8(:,20), A(:,71), n3(:,264), t3x144(:,:,71), nhel, den(109))
    call Hcont_QA(nsync, wf8(:,4), wf18(:,23), A(:,72), n3(:,265), t3x144(:,:,72), nhel, den(25))
    call Hcont_QA(nsync, wf12(:,12), wf12(:,15), A(:,73), n3(:,266), t3x144(:,:,73), nhel, den(28))
    call Hcont_QA(nsync, wf18(:,4), wf8(:,21), A(:,74), n3(:,267), t3x144(:,:,74), nhel, den(31))
    call Hcont_QA(nsync, wf12(:,14), wf12(:,17), A(:,75), n3(:,268), t3x144(:,:,75), nhel, den(35))
    call Hcont_QA(nsync, wf18(:,4), wf8(:,22), A(:,76), n3(:,269), t3x144(:,:,76), nhel, den(36))
    call Hcont_QA(nsync, wf18(:,3), wf8(:,24), A(:,77), n3(:,270), t3x144(:,:,77), nhel, den(39))
    call Hcont_SS(nsync, wf9(:,1), wf16(:,11), A(:,78), n3(:,271), t3x144(:,:,78), nhel, den(42))
    call Hcont_VV(nsync, wf9(:,2), wf16(:,12), A(:,79), n3(:,272), t3x144(:,:,79), nhel, den(44))
    call Hcont_VV(nsync, wf9(:,3), wf16(:,13), A(:,80), n3(:,273), t3x144(:,:,80), nhel, den(46))
    call Hcont_VV(nsync, wf8(:,11), wf18(:,19), A(:,81), n3(:,274), t3x144(:,:,81), nhel, den(111))
    call Hcont_VV(nsync, wf8(:,11), wf18(:,20), A(:,82), n3(:,275), t3x144(:,:,82), nhel, den(112))
    call Hcont_QA(nsync, wf18(:,6), wf8(:,21), A(:,83), n3(:,276), t3x144(:,:,83), nhel, den(48))
    call Hcont_QA(nsync, wf18(:,8), wf8(:,21), A(:,84), n3(:,277), t3x144(:,:,84), nhel, den(50))
    call Hcont_QA(nsync, wf18(:,10), wf8(:,21), A(:,85), n3(:,278), t3x144(:,:,85), nhel, den(52))
    call Hcont_SS(nsync, wf9(:,1), wf16(:,14), A(:,86), n3(:,279), t3x144(:,:,86), nhel, den(54))
    call Hcont_VV(nsync, wf9(:,2), wf16(:,15), A(:,87), n3(:,280), t3x144(:,:,87), nhel, den(55))
    call Hcont_VV(nsync, wf9(:,3), wf16(:,16), A(:,88), n3(:,281), t3x144(:,:,88), nhel, den(56))
    call Hcont_VV(nsync, wf8(:,12), wf18(:,19), A(:,89), n3(:,282), t3x144(:,:,89), nhel, den(114))
    call Hcont_VV(nsync, wf8(:,12), wf18(:,20), A(:,90), n3(:,283), t3x144(:,:,90), nhel, den(115))
    call Hcont_QA(nsync, wf18(:,12), wf8(:,15), A(:,91), n3(:,284), t3x144(:,:,91), nhel, den(58))
    call Hcont_QA(nsync, wf18(:,14), wf8(:,15), A(:,92), n3(:,285), t3x144(:,:,92), nhel, den(60))
    call Hcont_QA(nsync, wf18(:,16), wf8(:,15), A(:,93), n3(:,286), t3x144(:,:,93), nhel, den(62))
    call Hcont_VV(nsync, wf8(:,13), wf18(:,21), A(:,94), n3(:,287), t3x144(:,:,94), nhel, den(117))
    call Hcont_VV(nsync, wf8(:,13), wf18(:,22), A(:,95), n3(:,288), t3x144(:,:,95), nhel, den(118))
    call Hcont_QA(nsync, wf18(:,6), wf8(:,22), A(:,96), n3(:,289), t3x144(:,:,96), nhel, den(63))
    call Hcont_QA(nsync, wf18(:,8), wf8(:,22), A(:,97), n3(:,290), t3x144(:,:,97), nhel, den(64))
    call Hcont_QA(nsync, wf18(:,10), wf8(:,22), A(:,98), n3(:,291), t3x144(:,:,98), nhel, den(65))
    call Hcont_VV(nsync, wf8(:,14), wf18(:,21), A(:,99), n3(:,292), t3x144(:,:,99), nhel, den(120))
    call Hcont_VV(nsync, wf8(:,14), wf18(:,22), A(:,100), n3(:,293), t3x144(:,:,100), nhel, den(121))
    call Hcont_QA(nsync, wf18(:,12), wf8(:,16), A(:,101), n3(:,294), t3x144(:,:,101), nhel, den(66))
    call Hcont_QA(nsync, wf18(:,14), wf8(:,16), A(:,102), n3(:,295), t3x144(:,:,102), nhel, den(67))
    call Hcont_QA(nsync, wf18(:,16), wf8(:,16), A(:,103), n3(:,296), t3x144(:,:,103), nhel, den(68))
    call Hcont_QA(nsync, wf18(:,12), wf8(:,17), A(:,104), n3(:,297), t3x144(:,:,104), nhel, den(69))
    call Hcont_QA(nsync, wf18(:,14), wf8(:,17), A(:,105), n3(:,298), t3x144(:,:,105), nhel, den(70))
    call Hcont_QA(nsync, wf18(:,16), wf8(:,17), A(:,106), n3(:,299), t3x144(:,:,106), nhel, den(71))
    call Hcont_QA(nsync, wf18(:,5), wf8(:,24), A(:,107), n3(:,300), t3x144(:,:,107), nhel, den(72))
    call Hcont_QA(nsync, wf18(:,7), wf8(:,24), A(:,108), n3(:,301), t3x144(:,:,108), nhel, den(73))
    call Hcont_QA(nsync, wf18(:,9), wf8(:,24), A(:,109), n3(:,302), t3x144(:,:,109), nhel, den(74))
    call Hcont_QA(nsync, wf12(:,12), wf12(:,22), A(:,110), n3(:,303), t3x144(:,:,110), nhel, den(75))
    call Hcont_QA(nsync, wf12(:,14), wf12(:,21), A(:,111), n3(:,304), t3x144(:,:,111), nhel, den(76))
    call Hcont_QA(nsync, wf18(:,24), wf8(:,25), A(:,112), n3(:,305), t3x144(:,:,112), nhel, den(123))
    call Hcont_QA(nsync, wf12(:,20), wf12(:,23), A(:,113), n3(:,306), t3x144(:,:,113), nhel, den(124))
    call Hcont_QA(nsync, wf18(:,24), wf8(:,26), A(:,114), n3(:,307), t3x144(:,:,114), nhel, den(126))
    call Hcont_QA(nsync, wf12(:,6), wf12(:,24), A(:,115), n3(:,308), t3x144(:,:,115), nhel, den(127))
    call Hcont_QA(nsync, wf8(:,8), wf18(:,24), A(:,116), n3(:,309), t3x144(:,:,116), nhel, den(39))
    call Hcont_QA(nsync, wf12(:,10), wf12(:,23), A(:,117), n3(:,310), t3x144(:,:,117), nhel, den(128))
    call Hcont_QA(nsync, wf12(:,8), wf12(:,24), A(:,118), n3(:,311), t3x144(:,:,118), nhel, den(129))
    call Hcont_QA(nsync, wf18(:,2), wf8(:,27), A(:,119), n3(:,312), t3x144(:,:,119), nhel, den(130))
    call Hcont_QA(nsync, wf18(:,2), wf8(:,28), A(:,120), n3(:,313), t3x144(:,:,120), nhel, den(19))
    call Hcont_QA(nsync, wf12(:,1), wf12(:,26), A(:,121), n3(:,314), t3x144(:,:,121), nhel, den(22))
    call Hcont_QA(nsync, wf18(:,2), wf8(:,29), A(:,122), n3(:,315), t3x144(:,:,122), nhel, den(15))
    call Hcont_QA(nsync, wf12(:,5), wf12(:,28), A(:,123), n3(:,316), t3x144(:,:,123), nhel, den(17))
    call Hcont_VV(nsync, wf4(:,1), wf36(:,6), A(:,124), n3(:,317), t3x144(:,:,124), nhel, den(5))
    call Hcont_QA(nsync, wf12(:,3), wf12(:,29), A(:,125), n3(:,318), t3x144(:,:,125), nhel, den(8))
    call Hcont_QA(nsync, wf12(:,5), wf12(:,31), A(:,126), n3(:,319), t3x144(:,:,126), nhel, den(11))
    call Hcont_QA(nsync, wf8(:,25), wf18(:,25), A(:,127), n3(:,320), t3x144(:,:,127), nhel, den(131))
    call Hcont_QA(nsync, wf8(:,25), wf18(:,26), A(:,128), n3(:,321), t3x144(:,:,128), nhel, den(132))
    call Hcont_QA(nsync, wf8(:,25), wf18(:,27), A(:,129), n3(:,322), t3x144(:,:,129), nhel, den(133))
    call Hcont_SS(nsync, wf9(:,1), wf16(:,17), A(:,130), n3(:,323), t3x144(:,:,130), nhel, den(42))
    call Hcont_VV(nsync, wf9(:,2), wf16(:,18), A(:,131), n3(:,324), t3x144(:,:,131), nhel, den(44))
    call Hcont_VV(nsync, wf9(:,3), wf16(:,19), A(:,132), n3(:,325), t3x144(:,:,132), nhel, den(46))
    call Hcont_QA(nsync, wf8(:,26), wf18(:,25), A(:,133), n3(:,326), t3x144(:,:,133), nhel, den(134))
    call Hcont_QA(nsync, wf8(:,26), wf18(:,26), A(:,134), n3(:,327), t3x144(:,:,134), nhel, den(135))
    call Hcont_QA(nsync, wf8(:,26), wf18(:,27), A(:,135), n3(:,328), t3x144(:,:,135), nhel, den(136))
    call Hcont_QA(nsync, wf18(:,12), wf8(:,27), A(:,136), n3(:,329), t3x144(:,:,136), nhel, den(69))
    call Hcont_QA(nsync, wf18(:,14), wf8(:,27), A(:,137), n3(:,330), t3x144(:,:,137), nhel, den(70))
    call Hcont_QA(nsync, wf18(:,16), wf8(:,27), A(:,138), n3(:,331), t3x144(:,:,138), nhel, den(71))
    call Hcont_QA(nsync, wf8(:,8), wf18(:,25), A(:,139), n3(:,332), t3x144(:,:,139), nhel, den(72))
    call Hcont_QA(nsync, wf8(:,8), wf18(:,26), A(:,140), n3(:,333), t3x144(:,:,140), nhel, den(73))
    call Hcont_QA(nsync, wf8(:,8), wf18(:,27), A(:,141), n3(:,334), t3x144(:,:,141), nhel, den(74))
    call Hcont_QA(nsync, wf18(:,12), wf8(:,28), A(:,142), n3(:,335), t3x144(:,:,142), nhel, den(66))
    call Hcont_QA(nsync, wf18(:,14), wf8(:,28), A(:,143), n3(:,336), t3x144(:,:,143), nhel, den(67))
    call Hcont_QA(nsync, wf18(:,16), wf8(:,28), A(:,144), n3(:,337), t3x144(:,:,144), nhel, den(68))
    call Hcont_SS(nsync, wf9(:,1), wf16(:,20), A(:,145), n3(:,338), t3x144(:,:,145), nhel, den(54))
    call Hcont_VV(nsync, wf9(:,2), wf16(:,21), A(:,146), n3(:,339), t3x144(:,:,146), nhel, den(55))
    call Hcont_VV(nsync, wf9(:,3), wf16(:,22), A(:,147), n3(:,340), t3x144(:,:,147), nhel, den(56))
    call Hcont_QA(nsync, wf18(:,12), wf8(:,29), A(:,148), n3(:,341), t3x144(:,:,148), nhel, den(58))
    call Hcont_QA(nsync, wf18(:,14), wf8(:,29), A(:,149), n3(:,342), t3x144(:,:,149), nhel, den(60))
    call Hcont_QA(nsync, wf18(:,16), wf8(:,29), A(:,150), n3(:,343), t3x144(:,:,150), nhel, den(62))
    call Hcont_QA(nsync, wf12(:,12), wf12(:,25), A(:,151), n3(:,344), t3x144(:,:,151), nhel, den(75))
    call Hcont_QA(nsync, wf12(:,14), wf12(:,27), A(:,152), n3(:,345), t3x144(:,:,152), nhel, den(76))
    call Hcont_QA(nsync, wf12(:,12), wf12(:,29), A(:,153), n3(:,346), t3x144(:,:,153), nhel, den(28))
    call Hcont_QA(nsync, wf8(:,5), wf18(:,29), A(:,154), n3(:,347), t3x144(:,:,154), nhel, den(31))
    call Hcont_QA(nsync, wf12(:,14), wf12(:,30), A(:,155), n3(:,348), t3x144(:,:,155), nhel, den(35))
    call Hcont_QA(nsync, wf8(:,6), wf18(:,29), A(:,156), n3(:,349), t3x144(:,:,156), nhel, den(36))
    call Hcont_QA(nsync, wf8(:,8), wf18(:,28), A(:,157), n3(:,350), t3x144(:,:,157), nhel, den(39))
    call Hcont_QA(nsync, wf18(:,4), wf8(:,30), A(:,158), n3(:,351), t3x144(:,:,158), nhel, den(137))
    call Hcont_QA(nsync, wf12(:,4), wf12(:,33), A(:,159), n3(:,352), t3x144(:,:,159), nhel, den(35))
    call Hcont_QA(nsync, wf18(:,4), wf8(:,31), A(:,160), n3(:,353), t3x144(:,:,160), nhel, den(36))
    call Hcont_QA(nsync, wf12(:,2), wf12(:,35), A(:,161), n3(:,354), t3x144(:,:,161), nhel, den(28))
    call Hcont_QA(nsync, wf18(:,4), wf8(:,32), A(:,162), n3(:,355), t3x144(:,:,162), nhel, den(31))
    call Hcont_QA(nsync, wf8(:,19), wf18(:,30), A(:,163), n3(:,356), t3x144(:,:,163), nhel, den(138))
    call Hcont_QA(nsync, wf8(:,19), wf18(:,31), A(:,164), n3(:,357), t3x144(:,:,164), nhel, den(139))
    call Hcont_QA(nsync, wf8(:,19), wf18(:,32), A(:,165), n3(:,358), t3x144(:,:,165), nhel, den(140))
    call Hcont_SS(nsync, wf9(:,1), wf16(:,23), A(:,166), n3(:,359), t3x144(:,:,166), nhel, den(54))
    call Hcont_VV(nsync, wf9(:,2), wf16(:,24), A(:,167), n3(:,360), t3x144(:,:,167), nhel, den(55))
    call Hcont_VV(nsync, wf9(:,3), wf16(:,25), A(:,168), n3(:,361), t3x144(:,:,168), nhel, den(56))
    call Hcont_QA(nsync, wf8(:,20), wf18(:,30), A(:,169), n3(:,362), t3x144(:,:,169), nhel, den(141))
    call Hcont_QA(nsync, wf8(:,20), wf18(:,31), A(:,170), n3(:,363), t3x144(:,:,170), nhel, den(142))
    call Hcont_QA(nsync, wf8(:,20), wf18(:,32), A(:,171), n3(:,364), t3x144(:,:,171), nhel, den(143))
    call Hcont_QA(nsync, wf8(:,4), wf18(:,30), A(:,172), n3(:,365), t3x144(:,:,172), nhel, den(144))
    call Hcont_QA(nsync, wf8(:,4), wf18(:,31), A(:,173), n3(:,366), t3x144(:,:,173), nhel, den(145))
    call Hcont_QA(nsync, wf8(:,4), wf18(:,32), A(:,174), n3(:,367), t3x144(:,:,174), nhel, den(146))
    call Hcont_QA(nsync, wf18(:,6), wf8(:,30), A(:,175), n3(:,368), t3x144(:,:,175), nhel, den(147))
    call Hcont_QA(nsync, wf18(:,8), wf8(:,30), A(:,176), n3(:,369), t3x144(:,:,176), nhel, den(148))
    call Hcont_QA(nsync, wf18(:,10), wf8(:,30), A(:,177), n3(:,370), t3x144(:,:,177), nhel, den(149))
    call Hcont_QA(nsync, wf18(:,6), wf8(:,31), A(:,178), n3(:,371), t3x144(:,:,178), nhel, den(63))
    call Hcont_QA(nsync, wf18(:,8), wf8(:,31), A(:,179), n3(:,372), t3x144(:,:,179), nhel, den(64))
    call Hcont_QA(nsync, wf18(:,10), wf8(:,31), A(:,180), n3(:,373), t3x144(:,:,180), nhel, den(65))
    call Hcont_SS(nsync, wf9(:,1), wf16(:,26), A(:,181), n3(:,374), t3x144(:,:,181), nhel, den(42))
    call Hcont_VV(nsync, wf9(:,2), wf16(:,27), A(:,182), n3(:,375), t3x144(:,:,182), nhel, den(44))
    call Hcont_VV(nsync, wf9(:,3), wf16(:,28), A(:,183), n3(:,376), t3x144(:,:,183), nhel, den(46))
    call Hcont_QA(nsync, wf18(:,6), wf8(:,32), A(:,184), n3(:,377), t3x144(:,:,184), nhel, den(48))
    call Hcont_QA(nsync, wf18(:,8), wf8(:,32), A(:,185), n3(:,378), t3x144(:,:,185), nhel, den(50))
    call Hcont_QA(nsync, wf18(:,10), wf8(:,32), A(:,186), n3(:,379), t3x144(:,:,186), nhel, den(52))
    call Hcont_QA(nsync, wf12(:,7), wf12(:,33), A(:,187), n3(:,380), t3x144(:,:,187), nhel, den(76))
    call Hcont_QA(nsync, wf12(:,9), wf12(:,35), A(:,188), n3(:,381), t3x144(:,:,188), nhel, den(75))
    call Hcont_VV(nsync, wf4(:,1), wf36(:,7), A(:,189), n3(:,382), t3x144(:,:,189), nhel, den(5))
    call Hcont_QA(nsync, wf12(:,2), wf12(:,37), A(:,190), n3(:,383), t3x144(:,:,190), nhel, den(8))
    call Hcont_QA(nsync, wf12(:,6), wf12(:,38), A(:,191), n3(:,384), t3x144(:,:,191), nhel, den(11))
    call Hcont_QA(nsync, wf8(:,1), wf18(:,34), A(:,192), n3(:,385), t3x144(:,:,192), nhel, den(15))
    call Hcont_QA(nsync, wf12(:,8), wf12(:,38), A(:,193), n3(:,386), t3x144(:,:,193), nhel, den(17))
    call Hcont_QA(nsync, wf8(:,2), wf18(:,34), A(:,194), n3(:,387), t3x144(:,:,194), nhel, den(19))
    call Hcont_QA(nsync, wf12(:,10), wf12(:,36), A(:,195), n3(:,388), t3x144(:,:,195), nhel, den(22))
    call Hcont_QA(nsync, wf8(:,4), wf18(:,33), A(:,196), n3(:,389), t3x144(:,:,196), nhel, den(25))
    call Hcont_QA(nsync, wf6(:,9), wf24(:,2), A(:,197), n3(:,390), t3x144(:,:,197), nhel, den(153))
    call Hcont_QA(nsync, wf6(:,10), wf24(:,4), A(:,198), n3(:,391), t3x144(:,:,198), nhel, den(157))
    call Hcont_VV(nsync, wf36(:,1), wf4(:,20), A(:,199), n3(:,392), t3x144(:,:,199), nhel, den(160))
    call Hcont_QA(nsync, wf12(:,20), wf12(:,39), A(:,200), n3(:,393), t3x144(:,:,200), nhel, den(162))
    call Hcont_QA(nsync, wf12(:,6), wf12(:,40), A(:,201), n3(:,394), t3x144(:,:,201), nhel, den(163))
    call Hcont_QA(nsync, wf12(:,18), wf12(:,41), A(:,202), n3(:,395), t3x144(:,:,202), nhel, den(165))
    call Hcont_QA(nsync, wf12(:,3), wf12(:,42), A(:,203), n3(:,396), t3x144(:,:,203), nhel, den(166))
    call Hcont_QA(nsync, wf12(:,20), wf12(:,43), A(:,204), n3(:,397), t3x144(:,:,204), nhel, den(167))
    call Hcont_QA(nsync, wf12(:,18), wf12(:,44), A(:,205), n3(:,398), t3x144(:,:,205), nhel, den(168))
    call Hcont_QA(nsync, wf8(:,19), wf18(:,35), A(:,206), n3(:,399), t3x144(:,:,206), nhel, den(169))
    call Hcont_QA(nsync, wf12(:,8), wf12(:,40), A(:,207), n3(:,400), t3x144(:,:,207), nhel, den(170))
    call Hcont_QA(nsync, wf12(:,18), wf12(:,45), A(:,208), n3(:,401), t3x144(:,:,208), nhel, den(172))
    call Hcont_QA(nsync, wf18(:,2), wf8(:,33), A(:,209), n3(:,402), t3x144(:,:,209), nhel, den(173))
    call Hcont_QA(nsync, wf8(:,19), wf18(:,36), A(:,210), n3(:,403), t3x144(:,:,210), nhel, den(174))
    call Hcont_QA(nsync, wf12(:,18), wf12(:,46), A(:,211), n3(:,404), t3x144(:,:,211), nhel, den(175))
    call Hcont_QA(nsync, wf8(:,20), wf18(:,35), A(:,212), n3(:,405), t3x144(:,:,212), nhel, den(176))
    call Hcont_QA(nsync, wf12(:,10), wf12(:,39), A(:,213), n3(:,406), t3x144(:,:,213), nhel, den(177))
    call Hcont_QA(nsync, wf12(:,3), wf12(:,47), A(:,214), n3(:,407), t3x144(:,:,214), nhel, den(179))
    call Hcont_QA(nsync, wf18(:,2), wf8(:,34), A(:,215), n3(:,408), t3x144(:,:,215), nhel, den(180))
    call Hcont_QA(nsync, wf8(:,20), wf18(:,36), A(:,216), n3(:,409), t3x144(:,:,216), nhel, den(181))
    call Hcont_QA(nsync, wf12(:,3), wf12(:,48), A(:,217), n3(:,410), t3x144(:,:,217), nhel, den(182))
    call Hcont_QA(nsync, wf8(:,4), wf18(:,35), A(:,218), n3(:,411), t3x144(:,:,218), nhel, den(183))
    call Hcont_QA(nsync, wf18(:,2), wf8(:,35), A(:,219), n3(:,412), t3x144(:,:,219), nhel, den(184))
    call Hcont_QA(nsync, wf18(:,2), wf8(:,36), A(:,220), n3(:,413), t3x144(:,:,220), nhel, den(186))
    call Hcont_QA(nsync, wf12(:,20), wf12(:,49), A(:,221), n3(:,414), t3x144(:,:,221), nhel, den(188))
    call Hcont_QA(nsync, wf18(:,4), wf8(:,37), A(:,222), n3(:,415), t3x144(:,:,222), nhel, den(189))
    call Hcont_QA(nsync, wf8(:,25), wf18(:,37), A(:,223), n3(:,416), t3x144(:,:,223), nhel, den(190))
    call Hcont_QA(nsync, wf12(:,12), wf12(:,42), A(:,224), n3(:,417), t3x144(:,:,224), nhel, den(191))
    call Hcont_QA(nsync, wf12(:,20), wf12(:,50), A(:,225), n3(:,418), t3x144(:,:,225), nhel, den(192))
    call Hcont_QA(nsync, wf8(:,25), wf18(:,38), A(:,226), n3(:,419), t3x144(:,:,226), nhel, den(193))
    call Hcont_QA(nsync, wf12(:,6), wf12(:,51), A(:,227), n3(:,420), t3x144(:,:,227), nhel, den(195))
    call Hcont_QA(nsync, wf18(:,4), wf8(:,38), A(:,228), n3(:,421), t3x144(:,:,228), nhel, den(196))
    call Hcont_QA(nsync, wf8(:,26), wf18(:,37), A(:,229), n3(:,422), t3x144(:,:,229), nhel, den(197))
    call Hcont_QA(nsync, wf12(:,14), wf12(:,41), A(:,230), n3(:,423), t3x144(:,:,230), nhel, den(198))
    call Hcont_QA(nsync, wf12(:,6), wf12(:,52), A(:,231), n3(:,424), t3x144(:,:,231), nhel, den(199))
    call Hcont_QA(nsync, wf8(:,26), wf18(:,38), A(:,232), n3(:,425), t3x144(:,:,232), nhel, den(200))
    call Hcont_QA(nsync, wf18(:,4), wf8(:,39), A(:,233), n3(:,426), t3x144(:,:,233), nhel, den(201))
    call Hcont_QA(nsync, wf18(:,4), wf8(:,40), A(:,234), n3(:,427), t3x144(:,:,234), nhel, den(202))
    call Hcont_QA(nsync, wf8(:,8), wf18(:,37), A(:,235), n3(:,428), t3x144(:,:,235), nhel, den(203))
    call Hcont_QA(nsync, wf4(:,25), wf36(:,9), A(:,236), n3(:,429), t3x144(:,:,236), nhel, den(207))
    call Hcont_QA(nsync, wf4(:,25), wf36(:,11), A(:,237), n3(:,430), t3x144(:,:,237), nhel, den(210))
    call Hcont_QA(nsync, wf4(:,25), wf36(:,13), A(:,238), n3(:,431), t3x144(:,:,238), nhel, den(213))
    call Hcont_QA(nsync, wf4(:,23), wf36(:,15), A(:,239), n3(:,432), t3x144(:,:,239), nhel, den(217))
    call Hcont_QA(nsync, wf4(:,23), wf36(:,17), A(:,240), n3(:,433), t3x144(:,:,240), nhel, den(220))
    call Hcont_QA(nsync, wf4(:,23), wf36(:,19), A(:,241), n3(:,434), t3x144(:,:,241), nhel, den(223))
    call Hcont_QA(nsync, wf18(:,6), wf8(:,37), A(:,242), n3(:,435), t3x144(:,:,242), nhel, den(224))
    call Hcont_QA(nsync, wf18(:,8), wf8(:,37), A(:,243), n3(:,436), t3x144(:,:,243), nhel, den(225))
    call Hcont_QA(nsync, wf18(:,10), wf8(:,37), A(:,244), n3(:,437), t3x144(:,:,244), nhel, den(226))
    call Hcont_QA(nsync, wf8(:,25), wf18(:,39), A(:,245), n3(:,438), t3x144(:,:,245), nhel, den(227))
    call Hcont_QA(nsync, wf8(:,25), wf18(:,40), A(:,246), n3(:,439), t3x144(:,:,246), nhel, den(228))
    call Hcont_QA(nsync, wf8(:,25), wf18(:,41), A(:,247), n3(:,440), t3x144(:,:,247), nhel, den(229))
    call Hcont_QA(nsync, wf4(:,27), wf36(:,21), A(:,248), n3(:,441), t3x144(:,:,248), nhel, den(233))
    call Hcont_QA(nsync, wf4(:,27), wf36(:,23), A(:,249), n3(:,442), t3x144(:,:,249), nhel, den(236))
    call Hcont_QA(nsync, wf4(:,27), wf36(:,25), A(:,250), n3(:,443), t3x144(:,:,250), nhel, den(239))
    call Hcont_QA(nsync, wf4(:,21), wf36(:,27), A(:,251), n3(:,444), t3x144(:,:,251), nhel, den(243))
    call Hcont_QA(nsync, wf4(:,21), wf36(:,29), A(:,252), n3(:,445), t3x144(:,:,252), nhel, den(246))
    call Hcont_QA(nsync, wf4(:,21), wf36(:,31), A(:,253), n3(:,446), t3x144(:,:,253), nhel, den(249))
    call Hcont_QA(nsync, wf8(:,19), wf18(:,42), A(:,254), n3(:,447), t3x144(:,:,254), nhel, den(250))
    call Hcont_QA(nsync, wf8(:,19), wf18(:,43), A(:,255), n3(:,448), t3x144(:,:,255), nhel, den(251))
    call Hcont_QA(nsync, wf8(:,19), wf18(:,44), A(:,256), n3(:,449), t3x144(:,:,256), nhel, den(252))
    call Hcont_QA(nsync, wf18(:,12), wf8(:,33), A(:,257), n3(:,450), t3x144(:,:,257), nhel, den(253))
    call Hcont_QA(nsync, wf18(:,14), wf8(:,33), A(:,258), n3(:,451), t3x144(:,:,258), nhel, den(254))
    call Hcont_QA(nsync, wf18(:,16), wf8(:,33), A(:,259), n3(:,452), t3x144(:,:,259), nhel, den(255))
    call Hcont_QA(nsync, wf18(:,6), wf8(:,38), A(:,260), n3(:,453), t3x144(:,:,260), nhel, den(256))
    call Hcont_QA(nsync, wf18(:,8), wf8(:,38), A(:,261), n3(:,454), t3x144(:,:,261), nhel, den(257))
    call Hcont_QA(nsync, wf18(:,10), wf8(:,38), A(:,262), n3(:,455), t3x144(:,:,262), nhel, den(258))
    call Hcont_QA(nsync, wf8(:,26), wf18(:,39), A(:,263), n3(:,456), t3x144(:,:,263), nhel, den(259))
    call Hcont_QA(nsync, wf8(:,26), wf18(:,40), A(:,264), n3(:,457), t3x144(:,:,264), nhel, den(260))
    call Hcont_QA(nsync, wf8(:,26), wf18(:,41), A(:,265), n3(:,458), t3x144(:,:,265), nhel, den(261))
    call Hcont_QA(nsync, wf8(:,20), wf18(:,42), A(:,266), n3(:,459), t3x144(:,:,266), nhel, den(262))
    call Hcont_QA(nsync, wf8(:,20), wf18(:,43), A(:,267), n3(:,460), t3x144(:,:,267), nhel, den(263))
    call Hcont_QA(nsync, wf8(:,20), wf18(:,44), A(:,268), n3(:,461), t3x144(:,:,268), nhel, den(264))
    call Hcont_QA(nsync, wf18(:,12), wf8(:,34), A(:,269), n3(:,462), t3x144(:,:,269), nhel, den(265))
    call Hcont_QA(nsync, wf18(:,14), wf8(:,34), A(:,270), n3(:,463), t3x144(:,:,270), nhel, den(266))
    call Hcont_QA(nsync, wf18(:,16), wf8(:,34), A(:,271), n3(:,464), t3x144(:,:,271), nhel, den(267))
    call Hcont_QA(nsync, wf8(:,4), wf18(:,42), A(:,272), n3(:,465), t3x144(:,:,272), nhel, den(268))
    call Hcont_QA(nsync, wf8(:,4), wf18(:,43), A(:,273), n3(:,466), t3x144(:,:,273), nhel, den(269))
    call Hcont_QA(nsync, wf8(:,4), wf18(:,44), A(:,274), n3(:,467), t3x144(:,:,274), nhel, den(270))
    call Hcont_QA(nsync, wf18(:,6), wf8(:,39), A(:,275), n3(:,468), t3x144(:,:,275), nhel, den(271))
    call Hcont_QA(nsync, wf18(:,8), wf8(:,39), A(:,276), n3(:,469), t3x144(:,:,276), nhel, den(272))
    call Hcont_QA(nsync, wf18(:,10), wf8(:,39), A(:,277), n3(:,470), t3x144(:,:,277), nhel, den(273))
    call Hcont_QA(nsync, wf18(:,6), wf8(:,40), A(:,278), n3(:,471), t3x144(:,:,278), nhel, den(274))
    call Hcont_QA(nsync, wf18(:,8), wf8(:,40), A(:,279), n3(:,472), t3x144(:,:,279), nhel, den(275))
    call Hcont_QA(nsync, wf18(:,10), wf8(:,40), A(:,280), n3(:,473), t3x144(:,:,280), nhel, den(276))
    call Hcont_QA(nsync, wf18(:,12), wf8(:,36), A(:,281), n3(:,474), t3x144(:,:,281), nhel, den(277))
    call Hcont_QA(nsync, wf18(:,14), wf8(:,36), A(:,282), n3(:,475), t3x144(:,:,282), nhel, den(278))
    call Hcont_QA(nsync, wf18(:,16), wf8(:,36), A(:,283), n3(:,476), t3x144(:,:,283), nhel, den(279))
    call Hcont_QA(nsync, wf12(:,10), wf12(:,49), A(:,284), n3(:,477), t3x144(:,:,284), nhel, den(280))
    call Hcont_QA(nsync, wf12(:,12), wf12(:,47), A(:,285), n3(:,478), t3x144(:,:,285), nhel, den(281))
    call Hcont_QA(nsync, wf12(:,10), wf12(:,50), A(:,286), n3(:,479), t3x144(:,:,286), nhel, den(282))
    call Hcont_QA(nsync, wf12(:,8), wf12(:,51), A(:,287), n3(:,480), t3x144(:,:,287), nhel, den(283))
    call Hcont_QA(nsync, wf12(:,14), wf12(:,45), A(:,288), n3(:,481), t3x144(:,:,288), nhel, den(284))
    call Hcont_QA(nsync, wf12(:,8), wf12(:,52), A(:,289), n3(:,482), t3x144(:,:,289), nhel, den(285))

end subroutine diagrams


elemental function diagmap(j, n)
  implicit none
  integer, intent(in) :: j, n
  complex(REALKIND) :: diagmap
  diagmap = A(j,n)%j
end function diagmap

function diagsum(j, pos, neg)
  implicit none
  integer, intent(in) :: j, pos(:), neg(:)
  complex(REALKIND) :: diagsum
  diagsum = sum(diagmap(j, pos)) - sum(diagmap(j, neg))
end function diagsum

subroutine colourvectors(A, j, M1, M2)
  implicit none
  type(Hpolcont) :: A(:,:)
  integer, intent(in) :: j
  type(Hpolcont), intent(out) :: M1(2), M2(3) ! M1helarray(3,nhel)
  integer :: empty(0), i

  M1(1)%j = (A(j,21)%j+A(j,24)%j+A(j,27)%j)*f(1)+CI*(A(j,33)%j+A(j,36)%j)*f(2)+(A(j,3)%j+A(j,4)%j+A(j,5)%j+A(j,11)%j+A(j,12)%j &
       +A(j,39)%j)*f(13)+CI*(A(j,1)%j+A(j,8)%j+A(j,13)%j)*f(14)+(-A(j,20)%j-A(j,23)%j-A(j,26)%j)*f(24)+CI*(-A(j,32)%j &
       -A(j,35)%j)*f(25)+(A(j,22)%j+A(j,25)%j+A(j,28)%j)*f(33)+CI*(A(j,34)%j+A(j,37)%j)*f(34)
  M1(2)%j = (A(j,15)%j+A(j,18)%j+A(j,30)%j)*f(1)+CI*(-A(j,33)%j-A(j,36)%j)*f(2)+(A(j,2)%j+A(j,6)%j+A(j,7)%j+A(j,9)%j+A(j,10)%j &
       +A(j,38)%j)*f(13)+CI*(-A(j,1)%j-A(j,8)%j-A(j,13)%j)*f(14)+(-A(j,14)%j-A(j,17)%j-A(j,29)%j)*f(24)+CI*(A(j,32)%j &
       +A(j,35)%j)*f(25)+(A(j,16)%j+A(j,19)%j+A(j,31)%j)*f(33)+CI*(-A(j,34)%j-A(j,37)%j)*f(34)

  M2(1)%j = (-A(j,249)%j-A(j,252)%j-A(j,255)%j-A(j,258)%j-A(j,261)%j-A(j,264)%j)*f(3)-(A(j,40)%j*f(4))/2._/**/REALKIND+CI*( &
       -A(j,273)%j-A(j,276)%j-A(j,279)%j-A(j,282)%j)*f(5)+(A(j,92)%j+A(j,97)%j+A(j,146)%j+A(j,149)%j+A(j,167)%j+A(j,179)%j)*f(6) &
       +CI*(A(j,137)%j+A(j,176)%j)*f(7)+(A(j,87)%j+A(j,134)%j+A(j,164)%j)*f(8)+CI*(A(j,140)%j+A(j,173)%j)*f(9)+CI*(A(j,105)%j &
       +A(j,108)%j)*f(10)+(A(j,48)%j+A(j,49)%j)*f(11)+CI*(A(j,44)%j+A(j,45)%j-A(j,46)%j)*f(12)+(-A(j,201)%j-A(j,202)%j-A(j,205)%j &
       -A(j,206)%j-A(j,207)%j-A(j,208)%j-A(j,209)%j-A(j,210)%j-A(j,211)%j-A(j,227)%j-A(j,228)%j-A(j,229)%j-A(j,230)%j-A(j,231)%j &
       -A(j,232)%j-A(j,287)%j-A(j,288)%j-A(j,289)%j)*f(15)+CI*(-A(j,197)%j-A(j,198)%j-A(j,199)%j-A(j,218)%j-A(j,219)%j-A(j,220)%j &
       -A(j,233)%j-A(j,234)%j-A(j,235)%j)*f(16)+(A(j,59)%j+A(j,60)%j+A(j,64)%j+A(j,75)%j)*f(17)+CI*A(j,57)%j*f(18)+(A(j,63)%j &
       +A(j,76)%j+A(j,122)%j+A(j,123)%j+A(j,152)%j+A(j,159)%j+A(j,160)%j+A(j,187)%j)*f(19)+CI*(A(j,119)%j+A(j,158)%j)*f(20) &
       +(A(j,68)%j+A(j,69)%j+A(j,111)%j+A(j,114)%j+A(j,115)%j+A(j,118)%j+A(j,126)%j+A(j,155)%j+A(j,156)%j+A(j,191)%j+A(j,192)%j &
       +A(j,193)%j)*f(21)+CI*(A(j,72)%j+A(j,116)%j+A(j,124)%j+A(j,157)%j+A(j,189)%j+A(j,196)%j)*f(22)+CI*(A(j,62)%j+A(j,67)%j &
       +A(j,77)%j)*f(23)+(A(j,248)%j+A(j,251)%j+A(j,254)%j+A(j,257)%j+A(j,260)%j+A(j,263)%j)*f(26)+CI*(A(j,272)%j+A(j,275)%j &
       +A(j,278)%j+A(j,281)%j)*f(27)+(-A(j,91)%j-A(j,96)%j-A(j,145)%j-A(j,148)%j-A(j,166)%j-A(j,178)%j)*f(28)+CI*(-A(j,136)%j &
       -A(j,175)%j)*f(29)+(-A(j,86)%j-A(j,133)%j-A(j,163)%j)*f(30)+CI*(-A(j,139)%j-A(j,172)%j)*f(31)+CI*(-A(j,104)%j &
       -A(j,107)%j)*f(32)+(A(j,42)%j*f(35))/2._/**/REALKIND+(-A(j,250)%j-A(j,253)%j-A(j,256)%j-A(j,259)%j-A(j,262)%j &
       -A(j,265)%j)*f(35)+CI*(-A(j,274)%j-A(j,277)%j-A(j,280)%j-A(j,283)%j)*f(36)+(A(j,93)%j+A(j,98)%j+A(j,147)%j+A(j,150)%j &
       +A(j,168)%j+A(j,180)%j)*f(37)+CI*(A(j,138)%j+A(j,177)%j)*f(38)+(A(j,88)%j+A(j,135)%j+A(j,165)%j)*f(39)+CI*(A(j,141)%j &
       +A(j,174)%j)*f(40)+CI*(A(j,106)%j+A(j,109)%j)*f(41)+CI*(A(j,52)%j+A(j,54)%j-A(j,56)%j)*f(42)+(-A(j,90)%j-A(j,95)%j)*f(43)+( &
       -A(j,89)%j-A(j,94)%j)*f(44)+CI*(-A(j,51)%j-A(j,53)%j+A(j,55)%j)*f(45)
  M2(2)%j = (-A(j,237)%j-A(j,240)%j-A(j,243)%j-A(j,246)%j-A(j,267)%j-A(j,270)%j)*f(3)-(A(j,41)%j*f(4))/2._/**/REALKIND &
       +CI*(A(j,273)%j+A(j,276)%j+A(j,279)%j+A(j,282)%j)*f(5)+(A(j,84)%j+A(j,102)%j+A(j,131)%j+A(j,143)%j+A(j,182)%j &
       +A(j,185)%j)*f(6)+CI*(-A(j,137)%j-A(j,176)%j)*f(7)+(A(j,79)%j+A(j,128)%j+A(j,170)%j)*f(8)+CI*(-A(j,140)%j-A(j,173)%j)*f(9) &
       +CI*(-A(j,105)%j-A(j,108)%j)*f(10)+(A(j,47)%j+A(j,50)%j)*f(11)+CI*(-A(j,44)%j-A(j,45)%j+A(j,46)%j)*f(12)+(-A(j,200)%j &
       -A(j,203)%j-A(j,204)%j-A(j,212)%j-A(j,213)%j-A(j,214)%j-A(j,215)%j-A(j,216)%j-A(j,217)%j-A(j,221)%j-A(j,222)%j-A(j,223)%j &
       -A(j,224)%j-A(j,225)%j-A(j,226)%j-A(j,284)%j-A(j,285)%j-A(j,286)%j)*f(15)+CI*(A(j,197)%j+A(j,198)%j+A(j,199)%j+A(j,218)%j &
       +A(j,219)%j+A(j,220)%j+A(j,233)%j+A(j,234)%j+A(j,235)%j)*f(16)+(A(j,58)%j+A(j,61)%j+A(j,66)%j+A(j,73)%j)*f(17) &
       -CI*A(j,57)%j*f(18)+(A(j,65)%j+A(j,74)%j+A(j,120)%j+A(j,121)%j+A(j,151)%j+A(j,161)%j+A(j,162)%j+A(j,188)%j)*f(19)+CI*( &
       -A(j,119)%j-A(j,158)%j)*f(20)+(A(j,70)%j+A(j,71)%j+A(j,110)%j+A(j,112)%j+A(j,113)%j+A(j,117)%j+A(j,125)%j+A(j,153)%j &
       +A(j,154)%j+A(j,190)%j+A(j,194)%j+A(j,195)%j)*f(21)+CI*(-A(j,72)%j-A(j,116)%j-A(j,124)%j-A(j,157)%j-A(j,189)%j &
       -A(j,196)%j)*f(22)+CI*(-A(j,62)%j-A(j,67)%j-A(j,77)%j)*f(23)+(A(j,236)%j+A(j,239)%j+A(j,242)%j+A(j,245)%j+A(j,266)%j &
       +A(j,269)%j)*f(26)+CI*(-A(j,272)%j-A(j,275)%j-A(j,278)%j-A(j,281)%j)*f(27)+(-A(j,83)%j-A(j,101)%j-A(j,130)%j-A(j,142)%j &
       -A(j,181)%j-A(j,184)%j)*f(28)+CI*(A(j,136)%j+A(j,175)%j)*f(29)+(-A(j,78)%j-A(j,127)%j-A(j,169)%j)*f(30)+CI*(A(j,139)%j &
       +A(j,172)%j)*f(31)+CI*(A(j,104)%j+A(j,107)%j)*f(32)+(A(j,43)%j*f(35))/2._/**/REALKIND+(-A(j,238)%j-A(j,241)%j-A(j,244)%j &
       -A(j,247)%j-A(j,268)%j-A(j,271)%j)*f(35)+CI*(A(j,274)%j+A(j,277)%j+A(j,280)%j+A(j,283)%j)*f(36)+(A(j,85)%j+A(j,103)%j &
       +A(j,132)%j+A(j,144)%j+A(j,183)%j+A(j,186)%j)*f(37)+CI*(-A(j,138)%j-A(j,177)%j)*f(38)+(A(j,80)%j+A(j,129)%j &
       +A(j,171)%j)*f(39)+CI*(-A(j,141)%j-A(j,174)%j)*f(40)+CI*(-A(j,106)%j-A(j,109)%j)*f(41)+CI*(-A(j,52)%j-A(j,54)%j &
       +A(j,56)%j)*f(42)+(-A(j,82)%j-A(j,100)%j)*f(43)+(-A(j,81)%j-A(j,99)%j)*f(44)+CI*(A(j,51)%j+A(j,53)%j-A(j,55)%j)*f(45)
  M2(3)%j = ((A(j,40)%j+A(j,41)%j)*f(4))/6._/**/REALKIND+((-A(j,42)%j-A(j,43)%j)*f(35))/6._/**/REALKIND


  M1(:)%hf = Hel(j)
  M2(:)%hf = Hel(j)

  !M(i) corresponds to \Gamma_{i} in Fabios thesis

end subroutine colourvectors


! **********************************************************************
subroutine colint(M, M2colint)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K1(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppwwtt_ttxwwxgg_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(2)
  real(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

    do i = 1, 2
      do j = 1, 2
        M2colint = M2colint + real(conjg(M(i))*K1(i,j)*M(j))
      end do
    end do

end subroutine colint

! **********************************************************************
subroutine colint_ct(M, Mct, M2colint_ct, l)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppwwtt_ttxwwxgg_1_/**/REALKIND, only: K2
  implicit none
  complex(REALKIND), intent(in)  :: M(2), Mct(3)
  real(REALKIND),    intent(out) :: M2colint_ct
  integer, intent(in) :: l
  integer ::  i, j

  M2colint_ct = 0

  do i = 1, 2
    do j = 1, 3
      M2colint_ct = M2colint_ct + real(conjg(M(i))*K2(i+2*l,j)*Mct(j))
    end do
  end do

end subroutine colint_ct

! **********************************************************************
subroutine colint_IR(M, M2IRadd)
! M(i)   = <M|Ci> colour component of matrix element
! K1(i,j) = .....
! **********************************************************************
  use ol_colourmatrix_ppwwtt_ttxwwxgg_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(2)
  real(REALKIND),    intent(out) :: M2IRadd(22)
  integer ::  i, j, k, colmatpos

  M2IRadd = 0

  do k = 1, 23-1
    colmatpos = 2*k
    do i = 1, 2
      do j = 1, 2
        M2IRadd(k) = M2IRadd(k) + real(conjg(M(i))*K1(i+colmatpos,j)*M(j))
      end do
    end do
  end do

end subroutine colint_IR

! **********************************************************************
subroutine colintmunu(M1, M2, M2colint)
! M1(i)    = <M1|Ci> colour component of matrix element
! M2(i)    = <M2|Ci> colour component of matrix element
! M2colint = <M1|M2>
!          = Sum_{i,j} <M1|Ci> * <Ci|Cj> * <Cj|M2>
!          = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppwwtt_ttxwwxgg_1_/**/REALKIND, only: K2
  implicit none

  complex(REALKIND), intent(in)  :: M1(2)
  complex(REALKIND), intent(in)  :: M2(2)
  complex(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

  do i = 1, 2
    do j = 1, 2
      M2colint = M2colint + M1(i)*K2(i,j)*conjg(M2(j))
    end do
  end do

end subroutine colintmunu





! **********************************************************************
subroutine colborninterf(M, M0_col, l)
! M(i)         = <M|Ci> colour component of matrix element
! M0_col(i)    = <M2|Ci> colour component of matrix element,
!                see \tilde{M}_{j} in Fabios thesis
! M2colint = Sum_{i} <M1|Ci> * <Ci|Cj>
!          = colour-summed squared matrix element
! KL(i,j) = <Ci|Cj> with elements Cj of 1-loop colour basis
! **********************************************************************
  use ol_colourmatrix_ppwwtt_ttxwwxgg_1_/**/REALKIND, only: KL
  implicit none

  type(Hpolcont), intent(in)  :: M(2)
  type(Hpolcont), intent(out)  :: M0_col(3)
  integer, intent(in) :: l
  integer :: i, j

  do j = 1, 3 !size(KL(1,:))
    M0_col(j)%j = 0
    M0_col(j)%hf = M(1)%hf
    do i = 1, 2 !size(KL(:,1))
      M0_col(j)%j = M0_col(j)%j  + conjg(M(i)%j)*KL(i+2*l,j)
    end do
  end do

end subroutine colborninterf

end subroutine amp2

end module ol_loop_ppwwtt_ttxwwxgg_1_/**/REALKIND
