
module ol_colourmatrix_ppwwtt_ttxbbxwwx_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  logical, save           :: colmat_not_initialised = .true.
  complex(REALKIND), save :: K1(46,2), K2(2,2), KL(2,2), Cas(6) = 0
  contains
  subroutine colourmatrix_init
    use ol_parameters_decl_/**/REALKIND, only: CI
    implicit none
    integer :: k, co
    colmat_not_initialised = .false.
    ! colour matrix

  K1( 1,:) = [   9,   3]
  K1( 2,:) = [   3,   9]
  K1( 3,:) = [  12,   4]
  K1( 4,:) = [   4,  12]
  K1( 5,:) = [   0,  -4]
  K1( 6,:) = [  -4, -12]
  K1( 7,:) = [  12,   4]
  K1( 8,:) = [   4,  12]
  K1( 9,:) = [   0,   4]
  K1(10,:) = [   4,   0]
  K1(11,:) = [ -12,  -4]
  K1(12,:) = [  -4,   0]
  K1(13,:) = [  12,   4]
  K1(14,:) = [   4,  12]
  K1(15,:) = [ -12,  -4]
  K1(16,:) = [  -4,   0]
  K1(17,:) = [   0,   4]
  K1(18,:) = [   4,   0]
  K1(19,:) = [   0,  -4]
  K1(20,:) = [  -4, -12]
  K1(21,:) = [  12,   4]
  K1(22,:) = [   4,  12]
  K1(23,:) = [   0,   0]
  K1(24,:) = [   0,   0]
  K1(25,:) = [   0,   0]
  K1(26,:) = [   0,   0]
  K1(27,:) = [   0,   0]
  K1(28,:) = [   0,   0]
  K1(29,:) = [   0,   0]
  K1(30,:) = [   0,   0]
  K1(31,:) = [   0,   0]
  K1(32,:) = [   0,   0]
  K1(33,:) = [   0,   0]
  K1(34,:) = [   0,   0]
  K1(35,:) = [   0,   0]
  K1(36,:) = [   0,   0]
  K1(37,:) = [   0,   0]
  K1(38,:) = [   0,   0]
  K1(39,:) = [   0,   0]
  K1(40,:) = [   0,   0]
  K1(41,:) = [   0,   0]
  K1(42,:) = [   0,   0]
  K1(43,:) = [   0,   0]
  K1(44,:) = [   0,   0]
  K1(45,:) = [   0,   0]
  K1(46,:) = [   0,   0]

  K2(1,:) = [ 9, 3]
  K2(2,:) = [ 3, 9]

  KL(1,:) = [ 9, 3]
  KL(2,:) = [ 3, 9]

#if -1 > 0
    co = 0
    do k = 1, 6
      co = co + k
      Cas(k) = K1(1+2*co,1)/K1(1,1)
    end do
#endif
  end subroutine colourmatrix_init
end module ol_colourmatrix_ppwwtt_ttxbbxwwx_1_/**/REALKIND



module ol_forced_parameters_ppwwtt_ttxbbxwwx_1_/**/REALKIND
  implicit none
  contains
  subroutine check_forced_parameters
    use ol_parameters_decl_/**/REALKIND
    use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
    use ol_loop_parameters_decl_/**/DREALKIND, only: LeadingColour, nc, nf, CKMORDER
#endif
    implicit none
    logical, save :: checks_not_written = .true.

    if (checks_not_written) then
    ! e.g.
    ! if (ME /= 0) write(*,101) 'ME = 0'
  if (CKMORDER /= 0) write(*,101) 'CKMORDER = 0'
  if (nc /= 3) write(*,101) 'nc = 3'
  if (nf /= 6) write(*,101) 'nf = 6'
  if (MU /= 0) write(*,101) 'MU = 0'
  if (MD /= 0) write(*,101) 'MD = 0'
  if (MS /= 0) write(*,101) 'MS = 0'
  if (MC /= 0) write(*,101) 'MC = 0'
  if (LeadingColour /= 0) write(*,101) 'LeadingColour = 0'
  if (wMT /= 0) write(*,101) 'wMT = 0'
  if (wMT /= 0) write(*,101) 'wMT = 0'
  if (wMB /= 0) write(*,101) 'wMB = 0'
  if (wMB /= 0) write(*,101) 'wMB = 0'
  if (wMW /= 0) write(*,101) 'wMW = 0'
  if (wMW /= 0) write(*,101) 'wMW = 0'


    checks_not_written = .false.
    end if

    101 format('[OpenLoops] === WARNING ===',/,'[OpenLoops] code was generated with ',A,/,'[OpenLoops] ===============')
  end subroutine check_forced_parameters
end module ol_forced_parameters_ppwwtt_ttxbbxwwx_1_/**/REALKIND


! **********************************************************************
module ol_loop_storage_ppwwtt_ttxbbxwwx_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, intkind1, intkind2
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont

#ifdef PRECISION_dp
  integer(intkind1), save :: ntryL = 1
  integer(intkind1), save :: p_switch = 0 ! switch for dp or qp. Used for memory allocation of the OL types
  ! the following are flags for memory allocation of the hol coefficients in dp or qp
  logical, save :: dp_not_alloc = .TRUE., qp_not_alloc = .TRUE.
  integer, save :: n_merge_steps  ! total number of merging steps
  integer, save :: n_merge_mism   ! number of merging mismatches
  integer, save :: merge_step = 1 ! current merging step
  integer(intkind2), save, allocatable :: merge_tables(:,:,:) ! merging tables
  integer(intkind2), save, allocatable :: merge_mism(:)       ! array of merging mismatches
  integer(intkind2), save, allocatable :: merge_hels(:)       ! array with relevant helicities for a merging step
  logical, save :: merge_tables_on = .false.
  integer(intkind2), parameter :: nheltot = 144 ! number of helicity configurations
  integer(intkind2), save :: nhel = 144 ! number of non-vanishing helicity configurations (adapted at runtime)
  integer(intkind2), save :: hel_states = 144 ! number of helicity configurations needed for mem-allocation
  integer(intkind2), save :: Hel(144) ! physical helicity states
#endif

  type(Hpolcont), save, allocatable :: A(:,:), M1helarray(:,:), M1helarray_ct(:,:)
  complex(REALKIND), save :: den(235)

  ! external wave functions ex1(h1),... for h<n> helicities
  type(wfun) :: ex1(2), ex2(2), ex3(2), ex4(2), ex5(3), ex6(3)

  ! wf<h>(h,n) n wave functions with h helicity configurations
  type(wfun) :: wf4(4,6), wf6(6,24), wf8(8,28), wf9(9,3), wf12(12,19), wf16(16,2), wf18(18,62), wf24(24,35), wf36(36,22), &
    wf144(144,155)

  ! diagram prefactors
  integer,           save :: fac_status_loop1 = -1, fac_status_loop2 = -1
  complex(REALKIND), save :: f(62), c(98)

  !Vector in helicity and colour space for Born-Loop interference
  type(Hpolcont),   save, allocatable :: M0_col1_helarray(:,:), M0M1_hel_cc(:,:,:)
  complex(REALKIND), save :: M2ctcc(22)

end module ol_loop_storage_ppwwtt_ttxbbxwwx_1_/**/REALKIND






! **********************************************************************
module ol_loop_ppwwtt_ttxbbxwwx_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, DREALKIND, intkind1, intkind2
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont
  use ol_loop_storage_ppwwtt_ttxbbxwwx_1_/**/REALKIND
  implicit none

!*********************************************************************************
  contains

! **********************************************************************
subroutine fac_init_loop()
! Writes diagram prefactors to 'f', rsp. 'c'
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND
  use ol_init, only: set_parameter, tree_parameters_flush, parameters_flush
#ifndef PRECISION_dp
  use ol_loop_parameters_decl_/**/DREALKIND, only: SwF, SwB
!  use ol_loop_parameters_decl_/**/DREALKIND, only: DOI
#endif
  implicit none
  call set_parameter("ew_renorm", 0)
  if (parameters_status == 0) call tree_parameters_flush()
  if (loop_parameters_status == 0) call parameters_flush()
  fac_status_loop1 = parameters_status
  fac_status_loop2 = loop_parameters_status
  ! factors of the diagrams
    f( 1) = (CI*eQED**2*gQCD**2)/3._/**/REALKIND
    f( 2) = (2*CI*eQED**2*gQCD**2)/3._/**/REALKIND
    f( 3) = (CI*countertermnorm*eQED**2*gQCD**4)/3._/**/REALKIND
    f( 4) = (2*CI*countertermnorm*eQED**2*gQCD**4)/3._/**/REALKIND
    f( 5) = (CI*countertermnorm*ctGbb*eQED**2*gQCD**4)/3._/**/REALKIND
    f( 6) = (2*CI*countertermnorm*ctGbb*eQED**2*gQCD**4)/3._/**/REALKIND
    f( 7) = (CI*countertermnorm*ctGtt*eQED**2*gQCD**4)/3._/**/REALKIND
    f( 8) = (2*CI*countertermnorm*ctGtt*eQED**2*gQCD**4)/3._/**/REALKIND
    f( 9) = (CI*countertermnorm*ctVbb*eQED**2*gQCD**4)/3._/**/REALKIND
    f(10) = (2*CI*countertermnorm*ctVtt*eQED**2*gQCD**4)/3._/**/REALKIND
    f(11) = CI*countertermnorm*ctWWGG*eQED**2*gQCD**4
    f(12) = (CI*eQED**2*gQCD**2)/(2._/**/REALKIND*sw**2)
    f(13) = (CI*countertermnorm*eQED**2*gQCD**4)/(2._/**/REALKIND*sw**2)
    f(14) = (CI*countertermnorm*ctGbb*eQED**2*gQCD**4)/(2._/**/REALKIND*sw**2)
    f(15) = (CI*countertermnorm*ctGtt*eQED**2*gQCD**4)/(2._/**/REALKIND*sw**2)
    f(16) = (CI*countertermnorm*ctVbt*eQED**2*gQCD**4)/(2._/**/REALKIND*sw**2)
    f(17) = (CI*eQED**2*gQCD**2*MB)/(2._/**/REALKIND*sw**2)
    f(18) = (CI*countertermnorm*eQED**2*gQCD**4*MB)/(2._/**/REALKIND*sw**2)
    f(19) = (CI*countertermnorm*ctGbb*eQED**2*gQCD**4*MB)/(2._/**/REALKIND*sw**2)
    f(20) = (CI*countertermnorm*ctGtt*eQED**2*gQCD**4*MB)/(2._/**/REALKIND*sw**2)
    f(21) = (CI*countertermnorm*ctSbb*eQED**2*gQCD**4*MB)/(2._/**/REALKIND*sw**2)
    f(22) = (CI*eQED**2*gQCD**2*MT)/(2._/**/REALKIND*sw**2)
    f(23) = (CI*countertermnorm*eQED**2*gQCD**4*MT)/(2._/**/REALKIND*sw**2)
    f(24) = (CI*countertermnorm*ctGbb*eQED**2*gQCD**4*MT)/(2._/**/REALKIND*sw**2)
    f(25) = (CI*countertermnorm*ctGtt*eQED**2*gQCD**4*MT)/(2._/**/REALKIND*sw**2)
    f(26) = (CI*countertermnorm*ctStt*eQED**2*gQCD**4*MT)/(2._/**/REALKIND*sw**2)
    f(27) = (CI*cw*eQED**2*gQCD**2)/sw
    f(28) = (CI*countertermnorm*cw*eQED**2*gQCD**4)/sw
    f(29) = (CI*countertermnorm*ctGbb*cw*eQED**2*gQCD**4)/sw
    f(30) = (CI*countertermnorm*ctGtt*cw*eQED**2*gQCD**4)/sw
    f(31) = (CI*countertermnorm*ctVbb*cw*eQED**2*gQCD**4)/sw
    f(32) = (CI*countertermnorm*ctVtt*cw*eQED**2*gQCD**4)/sw
    f(33) = (countertermnorm*ctZGG*cw*eQED**2*gQCD**4)/sw
    f(34) = (CI*countertermnorm*ctHGG*eQED**2*gQCD**4*MW)/sw
    f(35) = (CI*eQED**2*gQCD**4*integralnorm*SwB)/3._/**/REALKIND
    f(36) = (2*CI*eQED**2*gQCD**4*integralnorm*SwB)/3._/**/REALKIND
    f(37) = (eQED**2*gQCD**4*integralnorm*SwB)/6._/**/REALKIND
    f(38) = (eQED**2*gQCD**4*integralnorm*SwB)/3._/**/REALKIND
    f(39) = (2*eQED**2*gQCD**4*integralnorm*SwB)/3._/**/REALKIND
    f(40) = (CI*eQED**2*gQCD**4*integralnorm*SwB)/(2._/**/REALKIND*sw**2)
    f(41) = (eQED**2*gQCD**4*integralnorm*SwB)/(sw**2*4._/**/REALKIND)
    f(42) = (eQED**2*gQCD**4*integralnorm*SwB)/(sw**2*2._/**/REALKIND)
    f(43) = (CI*eQED**2*gQCD**4*integralnorm*MB*SwB)/(2._/**/REALKIND*sw**2)
    f(44) = (eQED**2*gQCD**4*integralnorm*MB*SwB)/(sw**2*4._/**/REALKIND)
    f(45) = (eQED**2*gQCD**4*integralnorm*MB*SwB)/(sw**2*2._/**/REALKIND)
    f(46) = (CI*eQED**2*gQCD**4*integralnorm*MT*SwB)/(2._/**/REALKIND*sw**2)
    f(47) = (eQED**2*gQCD**4*integralnorm*MT*SwB)/(sw**2*4._/**/REALKIND)
    f(48) = (eQED**2*gQCD**4*integralnorm*MT*SwB)/(sw**2*2._/**/REALKIND)
    f(49) = (CI*cw*eQED**2*gQCD**4*integralnorm*SwB)/sw
    f(50) = (cw*eQED**2*gQCD**4*integralnorm*SwB)/(sw*2._/**/REALKIND)
    f(51) = (cw*eQED**2*gQCD**4*integralnorm*SwB)/sw
    f(52) = (eQED**2*gQCD**4*integralnorm*SwF)/3._/**/REALKIND
    f(53) = (2*eQED**2*gQCD**4*integralnorm*SwF)/3._/**/REALKIND
    f(54) = (4*eQED**2*gQCD**4*integralnorm*SwF)/3._/**/REALKIND
    f(55) = (eQED**2*gQCD**4*integralnorm*SwF)/(sw**2*2._/**/REALKIND)
    f(56) = (eQED**2*gQCD**4*integralnorm*SwF)/sw**2
    f(57) = (eQED**2*gQCD**4*integralnorm*MB*SwF)/(sw**2*2._/**/REALKIND)
    f(58) = (eQED**2*gQCD**4*integralnorm*MB*SwF)/sw**2
    f(59) = (eQED**2*gQCD**4*integralnorm*MT*SwF)/(sw**2*2._/**/REALKIND)
    f(60) = (eQED**2*gQCD**4*integralnorm*MT*SwF)/sw**2
    f(61) = (cw*eQED**2*gQCD**4*integralnorm*SwF)/sw
    f(62) = (2*cw*eQED**2*gQCD**4*integralnorm*SwF)/sw

  c = [ 9*CI*f(35), 27*CI*f(35), 9*CI*f(36), 27*CI*f(36), 18*f(37), 54*f(37), f(38), 3*f(38), 6*f(38), 8*f(38), 10*f(38), 18*f(38) &
    , 21*f(38), 24*f(38), 54*f(38), f(39), 3*f(39), 6*f(39), 8*f(39), 10*f(39), 18*f(39), 21*f(39), 24*f(39), 54*f(39), 9*CI*f(40) &
    , 27*CI*f(40), 18*f(41), 54*f(41), f(42), 3*f(42), 6*f(42), 8*f(42), 10*f(42), 18*f(42), 21*f(42), 24*f(42), 54*f(42) &
    , 9*CI*f(43), 27*CI*f(43), 18*f(44), 54*f(44), f(45), 3*f(45), 6*f(45), 8*f(45), 10*f(45), 18*f(45), 21*f(45), 24*f(45) &
    , 54*f(45), 9*CI*f(46), 27*CI*f(46), 18*f(47), 54*f(47), f(48), 3*f(48), 6*f(48), 8*f(48), 10*f(48), 18*f(48), 21*f(48) &
    , 24*f(48), 54*f(48), 9*CI*f(49), 27*CI*f(49), 18*f(50), 54*f(50), f(51), 3*f(51), 6*f(51), 8*f(51), 10*f(51), 18*f(51) &
    , 21*f(51), 24*f(51), 54*f(51), 3*f(52), 9*f(52), 3*f(53), 9*f(53), 3*f(54), 9*f(54), 3*f(55), 9*f(55), 3*f(56), 9*f(56) &
    , 3*f(57), 9*f(57), 3*f(58), 9*f(58), 3*f(59), 9*f(59), 3*f(60), 9*f(60), 3*f(61), 9*f(61), 3*f(62), 9*f(62) ]
  c = (1._/**/REALKIND / 36) * c
end subroutine fac_init_loop

subroutine denominators()
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_momenta_decl_/**/REALKIND, only: L
  implicit none
  ! propagators
  den(1) = 1 /((L(5,3))+L(6,3))
  den(2) = 1 /((L(5,36) - MT2)+L(6,36))
  den(3) = 1 /((L(5,24) - MT2)+L(6,24))
  den(6) = 1 /((L(5,7) - MB2)+L(6,7))
  den(9) = 1 /((L(5,11) - MB2)+L(6,11))
  den(12) = 1 /((L(5,48) - MH2)+L(6,48))
  den(14) = 1 /((L(5,48))+L(6,48))
  den(16) = 1 /((L(5,48) - MZ2)+L(6,48))
  den(18) = 1 /((L(5,52) - MB2)+L(6,52))
  den(25) = 1 /((L(5,17) - MB2)+L(6,17))
  den(26) = 1 /((L(5,34) - MB2)+L(6,34))
  den(27) = 1 /((L(5,12))+L(6,12))
  den(30) = 1 /((L(5,14) - MT2)+L(6,14))
  den(33) = 1 /((L(5,13) - MT2)+L(6,13))
  den(39) = 1 /((L(5,49) - MT2)+L(6,49))
  den(46) = 1 /((L(5,38))+L(6,38))
  den(51) = 1 /((L(5,25))+L(6,25))
  den(60) = 1 /((L(5,56) - MB2)+L(6,56))
  den(77) = 1 /((L(5,50) - MT2)+L(6,50))
  den(92) = 1 /((L(5,60))+L(6,60))
  den(96) = 1 /((L(5,27) - MT2)+L(6,27))
  den(99) = 1 /((L(5,39) - MT2)+L(6,39))
  den(124) = 1 /((L(5,46) - MB2)+L(6,46))
  den(128) = 1 /((L(5,29) - MB2)+L(6,29))
  den(131) = 1 /((L(5,51))+L(6,51))

  ! denominators
  den(4) = den(1)*den(2)
  den(5) = den(3)*den(4)
  den(7) = den(1)*den(6)
  den(8) = den(3)*den(7)
  den(10) = den(1)*den(9)
  den(11) = den(2)*den(10)
  den(13) = den(7)*den(12)
  den(15) = den(7)*den(14)
  den(17) = den(7)*den(16)
  den(19) = den(12)*den(18)
  den(20) = den(1)*den(19)
  den(21) = den(14)*den(18)
  den(22) = den(1)*den(21)
  den(23) = den(16)*den(18)
  den(24) = den(1)*den(23)
  den(28) = den(25)*den(26)
  den(29) = den(27)*den(28)
  den(31) = den(27)*den(30)
  den(32) = den(25)*den(31)
  den(34) = den(27)*den(33)
  den(35) = den(26)*den(34)
  den(36) = den(12)*den(34)
  den(37) = den(14)*den(34)
  den(38) = den(16)*den(34)
  den(40) = den(12)*den(39)
  den(41) = den(27)*den(40)
  den(42) = den(14)*den(39)
  den(43) = den(27)*den(42)
  den(44) = den(16)*den(39)
  den(45) = den(27)*den(44)
  den(47) = den(26)*den(46)
  den(48) = den(25)*den(47)
  den(49) = den(2)*den(46)
  den(50) = den(25)*den(49)
  den(52) = den(3)*den(51)
  den(53) = den(26)*den(52)
  den(54) = den(2)*den(52)
  den(55) = den(1)*den(27)
  den(56) = den(12)*den(55)
  den(57) = den(16)*den(55)
  den(58) = den(2)*den(18)
  den(59) = den(1)*den(58)
  den(61) = den(3)*den(60)
  den(62) = den(1)*den(61)
  den(63) = den(10)*den(12)
  den(64) = den(10)*den(14)
  den(65) = den(10)*den(16)
  den(66) = den(12)*den(60)
  den(67) = den(1)*den(66)
  den(68) = den(14)*den(60)
  den(69) = den(1)*den(68)
  den(70) = den(16)*den(60)
  den(71) = den(1)*den(70)
  den(72) = den(25)*den(51)
  den(73) = den(26)*den(72)
  den(74) = den(25)*den(39)
  den(75) = den(27)*den(74)
  den(76) = den(2)*den(72)
  den(78) = den(26)*den(77)
  den(79) = den(27)*den(78)
  den(80) = den(12)*den(77)
  den(81) = den(27)*den(80)
  den(82) = den(14)*den(77)
  den(83) = den(27)*den(82)
  den(84) = den(16)*den(77)
  den(85) = den(27)*den(84)
  den(86) = den(12)*den(31)
  den(87) = den(14)*den(31)
  den(88) = den(16)*den(31)
  den(89) = den(3)*den(47)
  den(90) = den(3)*den(49)
  den(91) = den(2)*den(3)
  den(93) = den(91)*den(92)
  den(94) = den(1)*den(93)
  den(95) = den(1)*den(3)
  den(97) = den(95)*den(96)
  den(98) = den(2)*den(97)
  den(100) = den(4)*den(99)
  den(101) = den(3)*den(100)
  den(102) = den(1)**2
  den(103) = den(61)*den(102)
  den(104) = den(7)*den(61)
  den(105) = den(3)**2
  den(106) = den(7)*den(105)
  den(107) = den(58)*den(102)
  den(108) = den(2)**2
  den(109) = den(10)*den(108)
  den(110) = den(10)*den(58)
  den(111) = den(66)*den(102)
  den(112) = den(68)*den(102)
  den(113) = den(70)*den(102)
  den(114) = den(19)*den(102)
  den(115) = den(21)*den(102)
  den(116) = den(23)*den(102)
  den(117) = den(7)*den(66)
  den(118) = den(7)*den(68)
  den(119) = den(7)*den(70)
  den(120) = den(10)*den(19)
  den(121) = den(10)*den(21)
  den(122) = den(10)*den(23)
  den(123) = den(26)*den(27)
  den(125) = den(123)*den(124)
  den(126) = den(25)*den(125)
  den(127) = den(25)*den(27)
  den(129) = den(127)*den(128)
  den(130) = den(26)*den(129)
  den(132) = den(28)*den(131)
  den(133) = den(27)*den(132)
  den(134) = den(25)**2
  den(135) = den(31)*den(134)
  den(136) = den(27)**2
  den(137) = den(74)*den(136)
  den(138) = den(31)*den(74)
  den(139) = den(78)*den(136)
  den(140) = den(34)*den(78)
  den(141) = den(26)**2
  den(142) = den(34)*den(141)
  den(143) = den(34)*den(80)
  den(144) = den(34)*den(82)
  den(145) = den(34)*den(84)
  den(146) = den(31)*den(40)
  den(147) = den(31)*den(42)
  den(148) = den(31)*den(44)
  den(149) = den(80)*den(136)
  den(150) = den(82)*den(136)
  den(151) = den(84)*den(136)
  den(152) = den(40)*den(136)
  den(153) = den(42)*den(136)
  den(154) = den(44)*den(136)
  den(155) = den(47)*den(134)
  den(156) = den(72)*den(141)
  den(157) = den(47)*den(72)
  den(158) = den(49)*den(134)
  den(159) = den(72)*den(108)
  den(160) = den(49)*den(72)
  den(161) = den(47)*den(52)
  den(162) = den(47)*den(105)
  den(163) = den(52)*den(141)
  den(164) = den(49)*den(52)
  den(165) = den(49)*den(105)
  den(166) = den(52)*den(108)
  den(167) = den(7)*den(99)
  den(168) = den(10)*den(96)
  den(169) = den(34)*den(128)
  den(170) = den(31)*den(124)
  den(171) = den(72)*den(96)
  den(172) = den(72)*den(128)
  den(173) = den(74)*den(131)
  den(174) = den(52)*den(96)
  den(175) = den(52)*den(128)
  den(176) = den(61)*den(92)
  den(177) = den(47)*den(99)
  den(178) = den(78)*den(131)
  den(179) = den(47)*den(124)
  den(180) = den(49)*den(99)
  den(181) = den(49)*den(124)
  den(182) = den(58)*den(92)
  den(183) = den(40)*den(131)
  den(184) = den(42)*den(131)
  den(185) = den(44)*den(131)
  den(186) = den(80)*den(131)
  den(187) = den(82)*den(131)
  den(188) = den(84)*den(131)
  den(189) = den(19)*den(92)
  den(190) = den(21)*den(92)
  den(191) = den(23)*den(92)
  den(192) = den(66)*den(92)
  den(193) = den(68)*den(92)
  den(194) = den(70)*den(92)
  den(195) = den(1)*den(12)*den(27)
  den(196) = den(1)*den(14)*den(27)
  den(197) = den(1)*den(16)*den(27)
  den(198) = den(1)*den(2)*den(3)
  den(199) = den(1)*den(12)
  den(200) = den(1)*den(14)
  den(201) = den(1)*den(16)
  den(202) = den(25)*den(26)*den(27)
  den(203) = den(12)*den(27)
  den(204) = den(14)*den(27)
  den(205) = den(16)*den(27)
  den(206) = den(2)*den(25)
  den(207) = den(3)*den(26)
  den(208) = den(3)*den(167)
  den(209) = den(1)*den(176)
  den(210) = den(2)*den(168)
  den(211) = den(1)*den(182)
  den(212) = den(1)*den(189)
  den(213) = den(1)*den(190)
  den(214) = den(1)*den(191)
  den(215) = den(1)*den(192)
  den(216) = den(1)*den(193)
  den(217) = den(1)*den(194)
  den(218) = den(27)*den(173)
  den(219) = den(25)*den(170)
  den(220) = den(26)*den(169)
  den(221) = den(27)*den(178)
  den(222) = den(27)*den(183)
  den(223) = den(27)*den(184)
  den(224) = den(27)*den(185)
  den(225) = den(27)*den(186)
  den(226) = den(27)*den(187)
  den(227) = den(27)*den(188)
  den(228) = den(26)*den(172)
  den(229) = den(25)*den(179)
  den(230) = den(2)*den(171)
  den(231) = den(25)*den(181)
  den(232) = den(26)*den(175)
  den(233) = den(3)*den(177)
  den(234) = den(2)*den(174)
  den(235) = den(3)*den(180)

end subroutine denominators

#ifdef PRECISION_dp
! **********************************************************************
subroutine init_merging_tables(tot_num_hels, tot_num_merge_steps)
!-----------------------------------------------------------------------
! In the first event the merging tables are fully initialised
! **********************************************************************
  implicit none
  integer, intent(in) :: tot_num_hels, tot_num_merge_steps
  n_merge_steps = tot_num_merge_steps
  allocate(merge_tables(tot_num_hels,2,n_merge_steps))
  allocate(merge_mism(n_merge_steps+1))
  allocate(merge_hels(n_merge_steps))
  merge_tables_on = .true.
  merge_mism = 0_intkind2
  merge_tables = -1_intkind2
  merge_hels = -1_intkind2
end subroutine init_merging_tables

! **********************************************************************
subroutine update_merging_tables(tot_num_hels)
!-----------------------------------------------------------------------
! After the first evaluation the merging tables are adapted
! **********************************************************************
  implicit none
  integer, intent(in) :: tot_num_hels
  integer(intkind2), allocatable ::  merge_tables_tmp(:,:,:), merge_hels_tmp(:)

  if(merge_mism(1) == 0) then ! helicity configurations match in all merging steps
    if(allocated(merge_tables)) deallocate(merge_tables)
    if(allocated(merge_hels)) deallocate(merge_hels)
    if(allocated(merge_mism)) deallocate(merge_mism)
    allocate(merge_mism(1))
    allocate(merge_hels(1))
    allocate(merge_tables(1,1,1)) ! dummy allocation
    merge_mism = 0_intkind2
    merge_tables = -1_intkind2
    merge_hels = -1_intkind2
  else
    n_merge_mism = merge_mism(1)
    allocate(merge_tables_tmp(tot_num_hels,2,n_merge_mism))
    merge_tables_tmp(:,:,1:n_merge_mism) = merge_tables(:,:,1:n_merge_mism)
    if(allocated(merge_tables)) then
      deallocate(merge_tables)
      allocate(merge_tables(tot_num_hels,2,n_merge_mism))
    end if
    merge_tables = merge_tables_tmp
    if(allocated(merge_tables_tmp)) deallocate(merge_tables_tmp)
    allocate(merge_hels_tmp(n_merge_mism))
    merge_hels_tmp(1:n_merge_mism) = merge_hels(1:n_merge_mism)
    if(allocated(merge_hels)) then
      deallocate(merge_hels)
      allocate(merge_hels(n_merge_mism))
    end if
    merge_hels = merge_hels_tmp
    if(allocated(merge_hels_tmp)) deallocate(merge_hels_tmp)
  end if
  merge_tables_on = .true.
end subroutine update_merging_tables
#endif

! **********************************************************************
subroutine allocate_diagrams()
!-----------------------------------------------------------------------
! After the first Born evaluation, colour-stripped amplitudes and
! colour vectors are initialiased with the minimum number of relevant
! helicity states.
! **********************************************************************
#ifndef PRECISION_dp
  use ol_loop_storage_ppwwtt_ttxbbxwwx_1_/**/DREALKIND, only: hel_states
#endif
  implicit none

  if (allocated(A)) deallocate(A)
  if (allocated(M1helarray)) deallocate(M1helarray)
  if (allocated(M1helarray_ct)) deallocate(M1helarray_ct)
  if (allocated(M0_col1_helarray)) deallocate(M0_col1_helarray)
  allocate(A(hel_states,155))
  allocate(M1helarray(2,hel_states))
  allocate(M1helarray_ct(2,hel_states))
  allocate(M0_col1_helarray(2,hel_states))
#if -1 > 0
  if (allocated(M0M1_hel_cc)) deallocate(M0M1_hel_cc)
  allocate(M0M1_hel_cc(2,hel_states,22))
#endif
end subroutine allocate_diagrams

!
!
!
! **********************************************************************
#ifdef PRECISION_dp
recursive subroutine amp2(P_scatt, M02, qp_kinematics, M2ct, M2colint)
#else
recursive subroutine amp2(P_scatt, M02, qp_kinematics, M2ct, M2colint)
  use ol_loop_storage_ppwwtt_ttxbbxwwx_1_/**/DREALKIND, only: &
  nhel, Hel, hel_states
#endif
! P_scatt(0:3,Npart) = incoming external momenta
! M2  = helicity-summed squared matrix element for top anti-top bottom anti-bottom W- W+ -> 0
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND !, only: ci, parameters_status, ZERO, scalefactor, >masses<
  use ol_parameters_init_/**/REALKIND, only: ensure_mp_init, ensure_mp_loop_init
  use ol_kinematics_/**/REALKIND, only: init_kinematics
  use ol_momenta_decl_/**/DREALKIND, only: momenta_nan_check
  use ol_settings_ppwwtt_ttxbbxwwx_1, only: hel_mem_opt, loopcc
  use ol_data_types_/**/REALKIND
  use ol_h_helicity_bookkeeping_/**/REALKIND, only: &
    & helbookkeeping_wf, helsync, flip_phase
  use ol_helicity_init, only: helbookkeeping_flip, helsync_flip
  use ol_hel_propagators_/**/REALKIND
  use ol_hel_wavefunctions_/**/REALKIND
  use ol_wavefunctions_/**/REALKIND, only: wf_V_Std
  use ol_hel_vertices_/**/REALKIND
  use ol_hel_contractions_/**/REALKIND
  use ol_external_ppwwtt_ttxbbxwwx_1, only: &
    & external_perm_ppwwtt_ttxbbxwwx_1, &
    & external_perm_inv_ppwwtt_ttxbbxwwx_1, &
    & extcomb_perm_ppwwtt_ttxbbxwwx_1, &
    & average_factor_ppwwtt_ttxbbxwwx_1
  use ol_external_ppwwtt_ttxbbxwwx_1, only: &
    & H, hel_not_initialised, hel_init, POLSEL
  use ol_colourmatrix_ppwwtt_ttxbbxwwx_1_/**/REALKIND, only: &
    & colmat_not_initialised, colourmatrix_init
  use ol_forced_parameters_ppwwtt_ttxbbxwwx_1_/**/REALKIND, only: &
    & check_forced_parameters
  use ol_heltables_OLR_ppwwtt_ttxbbxwwx_1
  use ol_kinematics_/**/REALKIND, only: LC2Std_Rep_cmplx
  use ol_h_counterterms_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND ! counterterms
  use ol_loop_parameters_decl_/**/DREALKIND, only: &
    & IR_is_on, DOI, CT_is_on, R2_is_on, TP_is_on
  use ol_init, only: set_parameter, parameters_flush
#ifdef PRECISION_dp
  use ol_kinematics_/**/QREALKIND, only: conv_mom_scatt2in_qp=>conv_mom_scatt2in, &
                                         internal_momenta_qp=>internal_momenta
  use ol_momenta_decl_/**/DREALKIND, only: L
  use ol_momenta_decl_/**/QREALKIND, only: L_qp=>L
#endif
  implicit none

  real(DREALKIND), intent(in)  :: P_scatt(0:3,6)
  real(REALKIND),  intent(out) :: M02
  logical, intent(in) :: qp_kinematics
  real(REALKIND),  intent(out), optional :: M2ct
  real(REALKIND),  intent(out), optional :: M2colint(22)
  real(REALKIND) :: iM2ct
  real(REALKIND) :: iM2colint(22)

  integer(intkind1), save :: ntry = 0

  integer           :: shift, k, r, m, n, i
  real(REALKIND)    :: P(0:3,6)
#ifdef PRECISION_dp
  real(QREALKIND)    :: P_qp(0:3,6)
#endif
  integer           :: extmasses2(6)
  real(REALKIND)    :: M2add, M2add_ct, M2add_colint(22)
  complex(REALKIND) :: M1(2), M2(2)
  real(REALKIND)    :: P_scatt_intern(0:3,6)
  real(REALKIND), save :: scalebackfactor, old_scalefactor = 0
  integer(intkind1) :: nsync
  integer, allocatable :: extcombs_permuted(:)
  integer              :: extcombs(22), nextcombs
  integer              :: CT_on_bak, R2_on_bak, TP_on_bak, DOI_bak
  logical              :: do_ct, do_colint
#if 6 > 3
  integer :: ind_cc_comb(9)
#endif
  complex(REALKIND) :: omega(2) ! phases for helicity correlations

  if (present(M2ct)) then
    do_ct = .true.
  else
    do_ct = .false.
  end if

  if (present(M2colint)) then
    do_colint = .true.
  else
    do_colint = .false.
  end if

  if(ntry == 0) then
    ! recursive initialization call needed for the correct helicity bokkeeping
    ntry = 1
    CT_on_bak = CT_is_on
    R2_on_bak = R2_is_on
    TP_on_bak = TP_is_on
    DOI_bak = DOI
    call set_parameter("ct_on", 1)
    call set_parameter("r2_on", 1)
    call set_parameter("tp_on", 1)
    DOI = 1
    call amp2(P_scatt, M02, qp_kinematics, M2ct=iM2ct, M2colint=iM2colint)
    call set_parameter("ct_on", CT_on_bak)
    call set_parameter("r2_on", R2_on_bak)
    call set_parameter("tp_on", TP_on_bak)
    DOI = DOI_bak
  end if

  if (ntry < 2) then
    if (allocated(A)) deallocate(A)
    allocate(A(nhel,155))
  end if

  if (do_ct) call set_parameter("ew_renorm", 0)
  call parameters_flush()
  call ensure_mp_init()
  if (do_ct) call ensure_mp_loop_init()

  if (colmat_not_initialised) call colourmatrix_init()

  if (fac_status_loop1 /= parameters_status .or. fac_status_loop2 /= loop_parameters_status) then
    call check_forced_parameters()
  end if
  if (do_ct) call fac_init_loop()

  if (momenta_nan_check(P_scatt) /= 0) then
    M02 = 0
    return
  end if

  extmasses2 = [ nMT, nMT, nMB, nMB, nMW, nMW ]
  ! Convert 2 -> n-2 PS-point to n -> 0 (so that P(1) + ... + P(n) = 0) and compute
  ! internal-propagator momenta in light-cone representation
  call init_kinematics(P_scatt, extmasses2, P, &
     external_perm_inv_ppwwtt_ttxbbxwwx_1, 6, qp_kinematics)

  ! denominators
  call denominators()

   if (heltables_not_init) call init_heltables()

  ! external WFs
  ! Here the external wavefunctions are initialiased
  call pol_wf_Q(P(:,1), rMT, H1, ex1, POLSEL(1),1)
  call pol_wf_A(P(:,2), rMT, H2, ex2, POLSEL(2),2)
  call pol_wf_Q(P(:,3), rMB, H3, ex3, POLSEL(3),3)
  call pol_wf_A(P(:,4), rMB, H4, ex4, POLSEL(4),4)
  call pol_wf_V(P(:,5), rMW, H5, ex5, POLSEL(5),5)
  call pol_wf_V(P(:,6), rMW, H6, ex6, POLSEL(6),6)



  ! internal WFs
  ! e.g. call vert_VQ_A(ntry, ex3, ex1, wf1, n1, t1) ...
  call vert_QA_V(ntry, ex1(:), ex2(:), wf4(:,1), n3(:,1), t3x4(:,:,1))
  call vert_WQ_A(ntry, ex6(:), ex3(:), wf6(:,1), n3(:,2), t3x6(:,:,1))
  call vert_AW_Q(ntry, ex4(:), ex5(:), wf6(:,2), n3(:,3), t3x6(:,:,2))
  call prop_Q_A(ntry, wf6(:,1), 36, MT, 1_intkind1, wf6(:,3), n2(1))
  call prop_A_Q(ntry, wf6(:,2), 24, MT, 1_intkind1, wf6(:,4), n2(2))
  call vert_VQ_A(ntry, wf4(:,1), wf6(:,3), wf24(:,1), n3(:,4), t3x24(:,:,1))
  call vert_VQ_A(ntry, wf4(:,1), ex3(:), wf8(:,1), n3(:,5), t3x8(:,:,1))
  call vert_AW_Q(ntry, wf6(:,4), ex6(:), wf18(:,1), n3(:,6), t3x18(:,:,1))
  call prop_Q_A(ntry, wf8(:,1), 7, MB, 1_intkind1, wf8(:,2), n2(3))
  call vert_AV_Q(ntry, ex4(:), wf4(:,1), wf8(:,3), n3(:,7), t3x8(:,:,2))
  call vert_WQ_A(ntry, ex5(:), wf6(:,3), wf18(:,2), n3(:,8), t3x18(:,:,2))
  call prop_A_Q(ntry, wf8(:,3), 11, MB, 1_intkind1, wf8(:,4), n2(4))
  call vert_VV_S(ntry, ex5(:), ex6(:), wf9(:,1), n3(:,9), t3x9(:,:,1))
  call vert_SA_Q(gH,ntry, wf9(:,1), ex4(:), wf18(:,3), n3(:,10), t3x18(:,:,3))
  call vert_UV_W(ntry, ex6(:), 32, ex5(:), 16, wf9(:,2), n3(:,11), t3x9(:,:,2))
  call vert_AV_Q(ntry, ex4(:), wf9(:,2), wf18(:,4), n3(:,12), t3x18(:,:,4))
  call prop_W_W(ntry, wf9(:,2), 48, MZ, 1_intkind1, wf9(:,3), n2(5))
  call vert_AZ_Q(gZd,ntry, ex4(:), wf9(:,3), wf18(:,5), n3(:,13), t3x18(:,:,5))
  call vert_QS_A(gH,ntry, ex3(:), wf9(:,1), wf18(:,6), n3(:,14), t3x18(:,:,6))
  call prop_Q_A(ntry, wf18(:,6), 52, MB, 1_intkind1, wf18(:,7), n2(6))
  call vert_VQ_A(ntry, wf9(:,2), ex3(:), wf18(:,8), n3(:,15), t3x18(:,:,7))
  call prop_Q_A(ntry, wf18(:,8), 52, MB, 1_intkind1, wf18(:,9), n2(7))
  call vert_ZQ_A(gZd,ntry, wf9(:,3), ex3(:), wf18(:,10), n3(:,16), t3x18(:,:,8))
  call prop_Q_A(ntry, wf18(:,10), 52, MB, 1_intkind1, wf18(:,11), n2(8))
  call vert_WQ_A(ntry, ex5(:), ex1(:), wf6(:,5), n3(:,17), t3x6(:,:,3))
  call vert_AW_Q(ntry, ex2(:), ex6(:), wf6(:,6), n3(:,18), t3x6(:,:,4))
  call vert_QA_V(ntry, ex3(:), ex4(:), wf4(:,2), n3(:,19), t3x4(:,:,2))
  call prop_Q_A(ntry, wf6(:,5), 17, MB, 1_intkind1, wf6(:,7), n2(9))
  call prop_A_Q(ntry, wf6(:,6), 34, MB, 1_intkind1, wf6(:,8), n2(10))
  call vert_QA_V(ntry, wf6(:,7), wf6(:,8), wf36(:,1), n3(:,20), t3x36(:,:,1))
  call vert_AV_Q(ntry, ex2(:), wf4(:,2), wf8(:,5), n3(:,21), t3x8(:,:,3))
  call vert_WQ_A(ntry, ex6(:), wf6(:,7), wf18(:,12), n3(:,22), t3x18(:,:,9))
  call prop_A_Q(ntry, wf8(:,5), 14, MT, 1_intkind1, wf8(:,6), n2(11))
  call vert_VQ_A(ntry, wf4(:,2), ex1(:), wf8(:,7), n3(:,23), t3x8(:,:,4))
  call vert_AW_Q(ntry, wf6(:,8), ex5(:), wf18(:,13), n3(:,24), t3x18(:,:,10))
  call prop_Q_A(ntry, wf8(:,7), 13, MT, 1_intkind1, wf8(:,8), n2(12))
  call vert_SA_Q(gH,ntry, wf9(:,1), ex2(:), wf18(:,14), n3(:,25), t3x18(:,:,11))
  call vert_AV_Q(ntry, ex2(:), wf9(:,2), wf18(:,15), n3(:,26), t3x18(:,:,12))
  call vert_AZ_Q(gZu,ntry, ex2(:), wf9(:,3), wf18(:,16), n3(:,27), t3x18(:,:,13))
  call vert_QS_A(gH,ntry, ex1(:), wf9(:,1), wf18(:,17), n3(:,28), t3x18(:,:,14))
  call prop_Q_A(ntry, wf18(:,17), 49, MT, 1_intkind1, wf18(:,18), n2(13))
  call vert_VQ_A(ntry, wf9(:,2), ex1(:), wf18(:,19), n3(:,29), t3x18(:,:,15))
  call prop_Q_A(ntry, wf18(:,19), 49, MT, 1_intkind1, wf18(:,20), n2(14))
  call vert_ZQ_A(gZu,ntry, wf9(:,3), ex1(:), wf18(:,21), n3(:,30), t3x18(:,:,16))
  call prop_Q_A(ntry, wf18(:,21), 49, MT, 1_intkind1, wf18(:,22), n2(15))
  call vert_QA_V(ntry, ex3(:), wf6(:,8), wf12(:,1), n3(:,31), t3x12(:,:,1))
  call vert_QA_V(ntry, wf6(:,7), ex4(:), wf12(:,2), n3(:,32), t3x12(:,:,2))
  call vert_QA_V(ntry, wf6(:,3), ex2(:), wf12(:,3), n3(:,33), t3x12(:,:,3))
  call vert_QA_V(ntry, ex1(:), wf6(:,4), wf12(:,4), n3(:,34), t3x12(:,:,4))
  call counter_VVG_G(ntry, ex5(:), ex6(:), wf4(:,1), wf36(:,2), n4(:,1), t4x36(:,:,1))
  call counter_GG_S(ntry, wf4(:,1), wf4(:,2), wf16(:,1), n3(:,35), t3x16(:,:,1))
  call counter_GG_V(ntry, wf4(:,1), 3, wf4(:,2), 12, wf16(:,2), n3(:,36), t3x16(:,:,2))
  call counter_VQ_A(ntry, wf4(:,1), wf6(:,3), wf24(:,2), n3(:,37), t3x24(:,:,2))
  call counter_AW_Q(ntry, wf6(:,4), ex6(:), wf18(:,23), n3(:,38), t3x18(:,:,17))
  call counter_WQ_A(ntry, ex5(:), wf6(:,3), wf18(:,24), n3(:,39), t3x18(:,:,18))
  call counter_AV_Q(ntry, ex4(:), wf4(:,1), wf8(:,9), n3(:,40), t3x8(:,:,5))
  call prop_Q_A(ntry, wf18(:,2), 52, MB, 1_intkind1, wf18(:,25), n2(16))
  call counter_SA_Q(gH,ntry, wf9(:,1), ex4(:), wf18(:,26), n3(:,41), t3x18(:,:,19))
  call counter_AV_Q(ntry, ex4(:), wf9(:,2), wf18(:,27), n3(:,42), t3x18(:,:,20))
  call counter_AZ_Q(gZd,ntry, ex4(:), wf9(:,3), wf18(:,28), n3(:,43), t3x18(:,:,21))
  call counter_AW_Q(ntry, ex4(:), ex5(:), wf6(:,9), n3(:,44), t3x6(:,:,5))
  call prop_A_Q(ntry, wf6(:,9), 24, MT, 1_intkind1, wf6(:,10), n2(17))
  call vert_AW_Q(ntry, wf6(:,10), ex6(:), wf18(:,29), n3(:,45), t3x18(:,:,22))
  call counter_VQ_A(ntry, wf4(:,1), ex3(:), wf8(:,10), n3(:,46), t3x8(:,:,6))
  call prop_A_Q(ntry, wf18(:,1), 56, MB, 1_intkind1, wf18(:,30), n2(18))
  call counter_WQ_A(ntry, ex6(:), ex3(:), wf6(:,11), n3(:,47), t3x6(:,:,6))
  call prop_Q_A(ntry, wf6(:,11), 36, MT, 1_intkind1, wf6(:,12), n2(19))
  call vert_VQ_A(ntry, wf4(:,1), wf6(:,12), wf24(:,3), n3(:,48), t3x24(:,:,3))
  call counter_QS_A(gH,ntry, ex3(:), wf9(:,1), wf18(:,31), n3(:,49), t3x18(:,:,23))
  call counter_VQ_A(ntry, wf9(:,2), ex3(:), wf18(:,32), n3(:,50), t3x18(:,:,24))
  call counter_ZQ_A(gZd,ntry, wf9(:,3), ex3(:), wf18(:,33), n3(:,51), t3x18(:,:,25))
  call prop_A_Q(ntry, wf18(:,3), 56, MB, 1_intkind1, wf18(:,34), n2(20))
  call prop_A_Q(ntry, wf18(:,4), 56, MB, 1_intkind1, wf18(:,35), n2(21))
  call prop_A_Q(ntry, wf18(:,5), 56, MB, 1_intkind1, wf18(:,36), n2(22))
  call vert_WQ_A(ntry, ex5(:), wf6(:,12), wf18(:,37), n3(:,52), t3x18(:,:,26))
  call counter_QA_V(ntry, wf6(:,7), wf6(:,8), wf36(:,3), n3(:,53), t3x36(:,:,2))
  call counter_WQ_A(ntry, ex6(:), wf6(:,7), wf18(:,38), n3(:,54), t3x18(:,:,27))
  call counter_AW_Q(ntry, wf6(:,8), ex5(:), wf18(:,39), n3(:,55), t3x18(:,:,28))
  call counter_QA_V(ntry, wf6(:,7), ex4(:), wf12(:,5), n3(:,56), t3x12(:,:,5))
  call vert_QA_V(ntry, ex1(:), wf6(:,10), wf12(:,6), n3(:,57), t3x12(:,:,6))
  call counter_QA_V(ntry, ex3(:), wf6(:,8), wf12(:,7), n3(:,58), t3x12(:,:,7))
  call vert_QA_V(ntry, wf6(:,12), ex2(:), wf12(:,8), n3(:,59), t3x12(:,:,8))
  call counter_QA_V(ntry, ex3(:), ex4(:), wf4(:,3), n3(:,60), t3x4(:,:,3))
  call vert_AV_Q(ntry, ex2(:), wf4(:,3), wf8(:,11), n3(:,61), t3x8(:,:,7))
  call prop_A_Q(ntry, wf8(:,11), 14, MT, 1_intkind1, wf8(:,12), n2(23))
  call vert_VQ_A(ntry, wf4(:,3), ex1(:), wf8(:,13), n3(:,62), t3x8(:,:,8))
  call prop_Q_A(ntry, wf8(:,13), 13, MT, 1_intkind1, wf8(:,14), n2(24))
  call counter_AV_Q(ntry, ex2(:), wf4(:,2), wf8(:,15), n3(:,63), t3x8(:,:,9))
  call prop_Q_A(ntry, wf18(:,12), 49, MT, 1_intkind1, wf18(:,40), n2(25))
  call counter_AW_Q(ntry, ex2(:), ex6(:), wf6(:,13), n3(:,64), t3x6(:,:,7))
  call prop_A_Q(ntry, wf6(:,13), 34, MB, 1_intkind1, wf6(:,14), n2(26))
  call vert_QA_V(ntry, wf6(:,7), wf6(:,14), wf36(:,4), n3(:,65), t3x36(:,:,3))
  call counter_SA_Q(gH,ntry, wf9(:,1), ex2(:), wf18(:,41), n3(:,66), t3x18(:,:,29))
  call counter_AV_Q(ntry, ex2(:), wf9(:,2), wf18(:,42), n3(:,67), t3x18(:,:,30))
  call counter_AZ_Q(gZu,ntry, ex2(:), wf9(:,3), wf18(:,43), n3(:,68), t3x18(:,:,31))
  call vert_AW_Q(ntry, wf6(:,14), ex5(:), wf18(:,44), n3(:,69), t3x18(:,:,32))
  call counter_QA_V(ntry, wf6(:,3), ex2(:), wf12(:,9), n3(:,70), t3x12(:,:,9))
  call vert_QA_V(ntry, ex3(:), wf6(:,14), wf12(:,10), n3(:,71), t3x12(:,:,10))
  call counter_VQ_A(ntry, wf4(:,2), ex1(:), wf8(:,16), n3(:,72), t3x8(:,:,10))
  call prop_A_Q(ntry, wf18(:,13), 50, MT, 1_intkind1, wf18(:,45), n2(27))
  call prop_A_Q(ntry, wf18(:,14), 50, MT, 1_intkind1, wf18(:,46), n2(28))
  call prop_A_Q(ntry, wf18(:,15), 50, MT, 1_intkind1, wf18(:,47), n2(29))
  call prop_A_Q(ntry, wf18(:,16), 50, MT, 1_intkind1, wf18(:,48), n2(30))
  call counter_QS_A(gH,ntry, ex1(:), wf9(:,1), wf18(:,49), n3(:,73), t3x18(:,:,33))
  call counter_VQ_A(ntry, wf9(:,2), ex1(:), wf18(:,50), n3(:,74), t3x18(:,:,34))
  call counter_ZQ_A(gZu,ntry, wf9(:,3), ex1(:), wf18(:,51), n3(:,75), t3x18(:,:,35))
  call counter_WQ_A(ntry, ex5(:), ex1(:), wf6(:,15), n3(:,76), t3x6(:,:,8))
  call prop_Q_A(ntry, wf6(:,15), 17, MB, 1_intkind1, wf6(:,16), n2(31))
  call vert_QA_V(ntry, wf6(:,16), wf6(:,8), wf36(:,5), n3(:,77), t3x36(:,:,4))
  call vert_WQ_A(ntry, ex6(:), wf6(:,16), wf18(:,52), n3(:,78), t3x18(:,:,36))
  call counter_QA_V(ntry, ex1(:), wf6(:,4), wf12(:,11), n3(:,79), t3x12(:,:,11))
  call vert_QA_V(ntry, wf6(:,16), ex4(:), wf12(:,12), n3(:,80), t3x12(:,:,12))
  call counter_QA_V(ntry, ex1(:), ex2(:), wf4(:,4), n3(:,81), t3x4(:,:,4))
  call vert_VQ_A(ntry, wf4(:,4), wf6(:,3), wf24(:,4), n3(:,82), t3x24(:,:,4))
  call vert_VQ_A(ntry, wf4(:,4), ex3(:), wf8(:,17), n3(:,83), t3x8(:,:,11))
  call prop_Q_A(ntry, wf8(:,17), 7, MB, 1_intkind1, wf8(:,18), n2(32))
  call vert_AV_Q(ntry, ex4(:), wf4(:,4), wf8(:,19), n3(:,84), t3x8(:,:,12))
  call prop_A_Q(ntry, wf8(:,19), 11, MB, 1_intkind1, wf8(:,20), n2(33))
  call vert_QA_V(ntry, wf6(:,3), wf6(:,4), wf36(:,6), n3(:,85), t3x36(:,:,5))
  call counter_V_V(ctGG,21,ntry, wf4(:,1), 3, wf4(:,5), n2(34))
  call vert_AV_Q(ntry, wf6(:,4), wf4(:,1), wf24(:,5), n3(:,86), t3x24(:,:,5))
  call counter_Q_A(cttt,6,ntry, wf6(:,3), 36, wf6(:,17), n2(35))
  call prop_A_Q(ntry, wf24(:,5), 27, MT, 1_intkind1, wf24(:,6), n2(36))
  call counter_A_Q(cttt,6,ntry, wf6(:,4), 24, wf6(:,18), n2(37))
  call prop_Q_A(ntry, wf24(:,1), 39, MT, 1_intkind1, wf24(:,7), n2(38))
  call vert_VQ_A(ntry, wf4(:,5), ex3(:), wf8(:,21), n3(:,87), t3x8(:,:,13))
  call counter_Q_A(ctbb,5,ntry, wf8(:,2), 7, wf8(:,22), n2(39))
  call prop_A_Q(ntry, wf6(:,18), 24, MT, 1_intkind1, wf6(:,19), n2(40))
  call vert_AW_Q(ntry, wf6(:,19), ex6(:), wf18(:,53), n3(:,88), t3x18(:,:,37))
  call vert_AV_Q(ntry, ex4(:), wf4(:,5), wf8(:,23), n3(:,89), t3x8(:,:,14))
  call prop_Q_A(ntry, wf6(:,17), 36, MT, 1_intkind1, wf6(:,20), n2(41))
  call vert_WQ_A(ntry, ex5(:), wf6(:,20), wf18(:,54), n3(:,90), t3x18(:,:,38))
  call counter_A_Q(ctbb,5,ntry, wf8(:,4), 11, wf8(:,24), n2(42))
  call counter_Q_A(ctbb,5,ntry, wf18(:,7), 52, wf18(:,55), n2(43))
  call counter_Q_A(ctbb,5,ntry, wf18(:,9), 52, wf18(:,56), n2(44))
  call counter_Q_A(ctbb,5,ntry, wf18(:,11), 52, wf18(:,57), n2(45))
  call vert_AV_Q(ntry, wf6(:,8), wf4(:,2), wf24(:,8), n3(:,91), t3x24(:,:,6))
  call counter_Q_A(ctbb,5,ntry, wf6(:,7), 17, wf6(:,21), n2(46))
  call prop_A_Q(ntry, wf24(:,8), 46, MB, 1_intkind1, wf24(:,9), n2(47))
  call vert_VQ_A(ntry, wf4(:,2), wf6(:,7), wf24(:,10), n3(:,92), t3x24(:,:,7))
  call counter_A_Q(ctbb,5,ntry, wf6(:,8), 34, wf6(:,22), n2(48))
  call prop_Q_A(ntry, wf24(:,10), 29, MB, 1_intkind1, wf24(:,11), n2(49))
  call counter_V_V(ctGG,21,ntry, wf4(:,2), 12, wf4(:,6), n2(50))
  call prop_Q_A(ntry, wf6(:,21), 17, MB, 1_intkind1, wf6(:,23), n2(51))
  call vert_WQ_A(ntry, ex6(:), wf6(:,23), wf18(:,58), n3(:,93), t3x18(:,:,39))
  call vert_AV_Q(ntry, ex2(:), wf4(:,6), wf8(:,25), n3(:,94), t3x8(:,:,15))
  call counter_A_Q(cttt,6,ntry, wf8(:,6), 14, wf8(:,26), n2(52))
  call vert_VQ_A(ntry, wf4(:,6), ex1(:), wf8(:,27), n3(:,95), t3x8(:,:,16))
  call counter_Q_A(cttt,6,ntry, wf8(:,8), 13, wf8(:,28), n2(53))
  call prop_A_Q(ntry, wf6(:,22), 34, MB, 1_intkind1, wf6(:,24), n2(54))
  call vert_AW_Q(ntry, wf6(:,24), ex5(:), wf18(:,59), n3(:,96), t3x18(:,:,40))
  call counter_Q_A(cttt,6,ntry, wf18(:,18), 49, wf18(:,60), n2(55))
  call counter_Q_A(cttt,6,ntry, wf18(:,20), 49, wf18(:,61), n2(56))
  call counter_Q_A(cttt,6,ntry, wf18(:,22), 49, wf18(:,62), n2(57))
  call vert_QA_V(ntry, wf6(:,23), ex4(:), wf12(:,13), n3(:,97), t3x12(:,:,13))
  call vert_QA_V(ntry, ex3(:), wf6(:,24), wf12(:,14), n3(:,98), t3x12(:,:,14))
  call counter_V_V(ctGG,21,ntry, wf12(:,1), 38, wf12(:,15), n2(58))
  call vert_QA_V(ntry, wf6(:,20), ex2(:), wf12(:,16), n3(:,99), t3x12(:,:,15))
  call counter_V_V(ctGG,21,ntry, wf12(:,3), 38, wf12(:,17), n2(59))
  call counter_V_V(ctGG,21,ntry, wf12(:,4), 25, wf12(:,18), n2(60))
  call vert_QA_V(ntry, ex1(:), wf6(:,19), wf12(:,19), n3(:,100), t3x12(:,:,16))
  call vert_WQ_A(ntry, ex6(:), wf8(:,2), wf24(:,12), n3(:,101), t3x24(:,:,8))
  call prop_Q_A(ntry, wf24(:,12), 39, MT, 1_intkind1, wf24(:,13), n2(61))
  call vert_AW_Q(ntry, wf8(:,4), ex5(:), wf24(:,14), n3(:,102), t3x24(:,:,9))
  call prop_A_Q(ntry, wf24(:,14), 27, MT, 1_intkind1, wf24(:,15), n2(62))
  call vert_WQ_A(ntry, ex5(:), wf8(:,8), wf24(:,16), n3(:,103), t3x24(:,:,10))
  call prop_Q_A(ntry, wf24(:,16), 29, MB, 1_intkind1, wf24(:,17), n2(63))
  call vert_AW_Q(ntry, wf8(:,6), ex6(:), wf24(:,18), n3(:,104), t3x24(:,:,11))
  call prop_A_Q(ntry, wf24(:,18), 46, MB, 1_intkind1, wf24(:,19), n2(64))
  call vert_AV_Q(ntry, ex2(:), wf12(:,2), wf24(:,20), n3(:,105), t3x24(:,:,12))
  call prop_A_Q(ntry, wf24(:,20), 27, MT, 1_intkind1, wf24(:,21), n2(65))
  call vert_VQ_A(ntry, wf12(:,2), ex3(:), wf24(:,22), n3(:,106), t3x24(:,:,13))
  call prop_Q_A(ntry, wf24(:,22), 29, MB, 1_intkind1, wf24(:,23), n2(66))
  call vert_QA_V(ntry, wf18(:,40), ex2(:), wf36(:,7), n3(:,107), t3x36(:,:,6))
  call vert_AV_Q(ntry, ex2(:), wf12(:,4), wf24(:,24), n3(:,108), t3x24(:,:,14))
  call prop_A_Q(ntry, wf24(:,24), 27, MT, 1_intkind1, wf24(:,25), n2(67))
  call vert_VQ_A(ntry, wf12(:,4), ex3(:), wf24(:,26), n3(:,109), t3x24(:,:,15))
  call prop_Q_A(ntry, wf24(:,26), 29, MB, 1_intkind1, wf24(:,27), n2(68))
  call vert_QA_V(ntry, ex3(:), wf18(:,30), wf36(:,8), n3(:,110), t3x36(:,:,7))
  call vert_VQ_A(ntry, wf12(:,1), ex1(:), wf24(:,28), n3(:,111), t3x24(:,:,16))
  call prop_Q_A(ntry, wf24(:,28), 39, MT, 1_intkind1, wf24(:,29), n2(69))
  call vert_QA_V(ntry, ex1(:), wf18(:,45), wf36(:,9), n3(:,112), t3x36(:,:,8))
  call vert_AV_Q(ntry, ex4(:), wf12(:,1), wf24(:,30), n3(:,113), t3x24(:,:,17))
  call prop_A_Q(ntry, wf24(:,30), 46, MB, 1_intkind1, wf24(:,31), n2(70))
  call vert_VQ_A(ntry, wf12(:,3), ex1(:), wf24(:,32), n3(:,114), t3x24(:,:,18))
  call prop_Q_A(ntry, wf24(:,32), 39, MT, 1_intkind1, wf24(:,33), n2(71))
  call vert_AV_Q(ntry, ex4(:), wf12(:,3), wf24(:,34), n3(:,115), t3x24(:,:,19))
  call prop_A_Q(ntry, wf24(:,34), 46, MB, 1_intkind1, wf24(:,35), n2(72))
  call vert_QA_V(ntry, wf18(:,25), ex4(:), wf36(:,10), n3(:,116), t3x36(:,:,9))
  call vert_QA_V(ntry, wf18(:,18), ex2(:), wf36(:,11), n3(:,117), t3x36(:,:,10))
  call vert_QA_V(ntry, wf18(:,20), ex2(:), wf36(:,12), n3(:,118), t3x36(:,:,11))
  call vert_QA_V(ntry, wf18(:,22), ex2(:), wf36(:,13), n3(:,119), t3x36(:,:,12))
  call vert_QA_V(ntry, ex1(:), wf18(:,46), wf36(:,14), n3(:,120), t3x36(:,:,13))
  call vert_QA_V(ntry, ex1(:), wf18(:,47), wf36(:,15), n3(:,121), t3x36(:,:,14))
  call vert_QA_V(ntry, ex1(:), wf18(:,48), wf36(:,16), n3(:,122), t3x36(:,:,15))
  call vert_QA_V(ntry, wf18(:,7), ex4(:), wf36(:,17), n3(:,123), t3x36(:,:,16))
  call vert_QA_V(ntry, wf18(:,9), ex4(:), wf36(:,18), n3(:,124), t3x36(:,:,17))
  call vert_QA_V(ntry, wf18(:,11), ex4(:), wf36(:,19), n3(:,125), t3x36(:,:,18))
  call vert_QA_V(ntry, ex3(:), wf18(:,34), wf36(:,20), n3(:,126), t3x36(:,:,19))
  call vert_QA_V(ntry, ex3(:), wf18(:,35), wf36(:,21), n3(:,127), t3x36(:,:,20))
  call vert_QA_V(ntry, ex3(:), wf18(:,36), wf36(:,22), n3(:,128), t3x36(:,:,21))


  if (ntry==1) then
    call physical_helicities()
  end if

  ! computation of the colour-stripped amplitudes
  do nsync = ntry+ntry-1, ntry+1  !  nsync = 1,2  for 1st point and nsync = 3 later
    call diagrams()
    if (nsync == 1) call helsync(nsync, A, nhel, Hel)
  end do

  if (ntry < 2) then
    if(hel_mem_opt) hel_states = nhel
    call allocate_diagrams()
  end if

  ! In the following loop the coefficients \Gamma_{i} of the expansion in
  ! the colour basis are computed for every helicity state and stored in M1helarray.
  ! Also the colour vector for the Born-loop interference is computed and saved in
  ! M0_col1_helarray
  do k = 1, nhel
    if (do_ct) call colourvectors(A, k, M1helarray(:,k),M1helarray_ct(:,k))
    call colborninterf(M1helarray(:,k), M0_col1_helarray(:,k), 0)
  end do
  M1helarray(:,nhel+1:)%j = 0
  M0_col1_helarray(:,nhel+1:)%hf = -1_intkind2
  M0_col1_helarray(:,nhel+1:)%j = 0

  M2add = 0
  M2add_ct = 0
  M2add_colint = 0

  M02 = 0
  if (do_ct) M2ct = 0
  if (do_colint) M2colint = 0

  do k = 1, nhel
    call colint(M1helarray(:,k)%j, M2add)
    if (do_ct) call colint_ct(M1helarray(:,k)%j, M1helarray_ct(:,k)%j, M2add_ct, 0)
    if (IR_is_on > 0) then
      if (do_colint) call colint_IR(M1helarray(:,k)%j, M2add_colint)
    end if
    !summation over helicity configurations
    M02 = M02 + M2add
    if (do_ct) M2ct = M2ct + M2add_ct
    if (do_colint) M2colint = M2colint + M2add_colint
  end do

#if -1 > 0 && 6 > 3
  if (loopcc) then
    !!Born-loop colour correlators interference
    
    M0M1_hel_cc(:,:,:)%j = 0
    M2ctcc = 0
    do n = 1, 9
      M2add_ct = 0
      m = ind_cc_comb(n)
        do k = 1, nhel
          call colint_ct(M1helarray(:,k)%j, M1helarray_ct(:,k)%j, M2add_ct, m)
          call colborninterf(M1helarray(:,k), M0M1_hel_cc(:,k,m), m)
          M2ctcc(m) = M2ctcc(m) + M2add_ct
        end do
    end do
    M0M1_hel_cc(:,nhel+1:,:)%hf = -1_intkind2
    M0M1_hel_cc(:,nhel+1:,:)%j = 0
  end if
#endif

  if (ntry < 1) then
    if (allocated(A)) deallocate(A)
  end if
  ntry=2


  contains

subroutine physical_helicities()
  implicit none

integer :: i1,i2,i3,i4,i5,i6
integer :: n

n=0

do i6= 1, 3
do i5= 1, 3
do i4= 1, 2
do i3= 1, 2
do i2= 1, 2
do i1= 1, 2
n = n + 1
 if((ex1(i1)%hf==-1_intkind2) .OR. (ex2(i2)%hf==-1_intkind2) .OR. (ex3(i3)%hf==-1_intkind2) .OR. (ex4(i4)%hf==-1_intkind2)  &
    .OR. (ex5(i5)%hf==-1_intkind2) .OR. (ex6(i6)%hf==-1_intkind2)) then
  Hel(n) = -1_intkind2
 else
  Hel(n) = ex1(i1)%hf + ex2(i2)%hf + ex3(i3)%hf + ex4(i4)%hf + ex5(i5)%hf + ex6(i6)%hf
 end if
end do
end do
end do
end do
end do
end do

end subroutine physical_helicities

subroutine diagrams()
  implicit none
  integer :: h
  ! e.g. call cont_VV(nsync, wf3, wf6, A(:,1), n64, t64, nhel, den(5)) ...

    call Hcont_QA(nsync, wf6(:,4), wf24(:,1), A(:,1), n3(:,129), t3x144(:,:,1), nhel, den(5))
    call Hcont_QA(nsync, wf18(:,1), wf8(:,2), A(:,2), n3(:,130), t3x144(:,:,2), nhel, den(8))
    call Hcont_QA(nsync, wf18(:,2), wf8(:,4), A(:,3), n3(:,131), t3x144(:,:,3), nhel, den(11))
    call Hcont_QA(nsync, wf8(:,2), wf18(:,3), A(:,4), n3(:,132), t3x144(:,:,4), nhel, den(13))
    call Hcont_QA(nsync, wf8(:,2), wf18(:,4), A(:,5), n3(:,133), t3x144(:,:,5), nhel, den(15))
    call Hcont_QA(nsync, wf8(:,2), wf18(:,5), A(:,6), n3(:,134), t3x144(:,:,6), nhel, den(17))
    call Hcont_QA(nsync, wf8(:,3), wf18(:,7), A(:,7), n3(:,135), t3x144(:,:,7), nhel, den(20))
    call Hcont_QA(nsync, wf8(:,3), wf18(:,9), A(:,8), n3(:,136), t3x144(:,:,8), nhel, den(22))
    call Hcont_QA(nsync, wf8(:,3), wf18(:,11), A(:,9), n3(:,137), t3x144(:,:,9), nhel, den(24))
    call Hcont_VV(nsync, wf4(:,2), wf36(:,1), A(:,10), n3(:,138), t3x144(:,:,10), nhel, den(29))
    call Hcont_QA(nsync, wf18(:,12), wf8(:,6), A(:,11), n3(:,139), t3x144(:,:,11), nhel, den(32))
    call Hcont_QA(nsync, wf18(:,13), wf8(:,8), A(:,12), n3(:,140), t3x144(:,:,12), nhel, den(35))
    call Hcont_QA(nsync, wf8(:,8), wf18(:,14), A(:,13), n3(:,141), t3x144(:,:,13), nhel, den(36))
    call Hcont_QA(nsync, wf8(:,8), wf18(:,15), A(:,14), n3(:,142), t3x144(:,:,14), nhel, den(37))
    call Hcont_QA(nsync, wf8(:,8), wf18(:,16), A(:,15), n3(:,143), t3x144(:,:,15), nhel, den(38))
    call Hcont_QA(nsync, wf8(:,5), wf18(:,18), A(:,16), n3(:,144), t3x144(:,:,16), nhel, den(41))
    call Hcont_QA(nsync, wf8(:,5), wf18(:,20), A(:,17), n3(:,145), t3x144(:,:,17), nhel, den(43))
    call Hcont_QA(nsync, wf8(:,5), wf18(:,22), A(:,18), n3(:,146), t3x144(:,:,18), nhel, den(45))
    call Hcont_VV(nsync, wf12(:,1), wf12(:,2), A(:,19), n3(:,147), t3x144(:,:,19), nhel, den(48))
    call Hcont_VV(nsync, wf12(:,2), wf12(:,3), A(:,20), n3(:,148), t3x144(:,:,20), nhel, den(50))
    call Hcont_VV(nsync, wf12(:,1), wf12(:,4), A(:,21), n3(:,149), t3x144(:,:,21), nhel, den(53))
    call Hcont_VV(nsync, wf12(:,3), wf12(:,4), A(:,22), n3(:,150), t3x144(:,:,22), nhel, den(54))

    call Hcont_VV(nsync, wf4(:,2), wf36(:,2), A(:,23), n3(:,151), t3x144(:,:,23), nhel, den(55))
    call Hcont_SS(nsync, wf9(:,1), wf16(:,1), A(:,24), n3(:,152), t3x144(:,:,24), nhel, den(56))
    call Hcont_VV(nsync, wf9(:,3), wf16(:,2), A(:,25), n3(:,153), t3x144(:,:,25), nhel, den(57))
    call Hcont_QA(nsync, wf6(:,4), wf24(:,2), A(:,26), n3(:,154), t3x144(:,:,26), nhel, den(5))
    call Hcont_QA(nsync, wf8(:,2), wf18(:,23), A(:,27), n3(:,155), t3x144(:,:,27), nhel, den(8))
    call Hcont_QA(nsync, wf8(:,4), wf18(:,24), A(:,28), n3(:,156), t3x144(:,:,28), nhel, den(11))
    call Hcont_QA(nsync, wf8(:,9), wf18(:,25), A(:,29), n3(:,157), t3x144(:,:,29), nhel, den(59))
    call Hcont_QA(nsync, wf8(:,2), wf18(:,26), A(:,30), n3(:,158), t3x144(:,:,30), nhel, den(13))
    call Hcont_QA(nsync, wf8(:,2), wf18(:,27), A(:,31), n3(:,159), t3x144(:,:,31), nhel, den(15))
    call Hcont_QA(nsync, wf8(:,2), wf18(:,28), A(:,32), n3(:,160), t3x144(:,:,32), nhel, den(17))
    call Hcont_QA(nsync, wf18(:,7), wf8(:,9), A(:,33), n3(:,161), t3x144(:,:,33), nhel, den(20))
    call Hcont_QA(nsync, wf18(:,9), wf8(:,9), A(:,34), n3(:,162), t3x144(:,:,34), nhel, den(22))
    call Hcont_QA(nsync, wf18(:,11), wf8(:,9), A(:,35), n3(:,163), t3x144(:,:,35), nhel, den(24))
    call Hcont_QA(nsync, wf24(:,1), wf6(:,10), A(:,36), n3(:,164), t3x144(:,:,36), nhel, den(5))
    call Hcont_QA(nsync, wf8(:,2), wf18(:,29), A(:,37), n3(:,165), t3x144(:,:,37), nhel, den(8))
    call Hcont_QA(nsync, wf8(:,10), wf18(:,30), A(:,38), n3(:,166), t3x144(:,:,38), nhel, den(62))
    call Hcont_QA(nsync, wf6(:,4), wf24(:,3), A(:,39), n3(:,167), t3x144(:,:,39), nhel, den(5))
    call Hcont_QA(nsync, wf8(:,4), wf18(:,31), A(:,40), n3(:,168), t3x144(:,:,40), nhel, den(63))
    call Hcont_QA(nsync, wf8(:,4), wf18(:,32), A(:,41), n3(:,169), t3x144(:,:,41), nhel, den(64))
    call Hcont_QA(nsync, wf8(:,4), wf18(:,33), A(:,42), n3(:,170), t3x144(:,:,42), nhel, den(65))
    call Hcont_QA(nsync, wf8(:,10), wf18(:,34), A(:,43), n3(:,171), t3x144(:,:,43), nhel, den(67))
    call Hcont_QA(nsync, wf8(:,10), wf18(:,35), A(:,44), n3(:,172), t3x144(:,:,44), nhel, den(69))
    call Hcont_QA(nsync, wf8(:,10), wf18(:,36), A(:,45), n3(:,173), t3x144(:,:,45), nhel, den(71))
    call Hcont_QA(nsync, wf8(:,4), wf18(:,37), A(:,46), n3(:,174), t3x144(:,:,46), nhel, den(11))
    call Hcont_VV(nsync, wf4(:,2), wf36(:,3), A(:,47), n3(:,175), t3x144(:,:,47), nhel, den(29))
    call Hcont_QA(nsync, wf8(:,6), wf18(:,38), A(:,48), n3(:,176), t3x144(:,:,48), nhel, den(32))
    call Hcont_QA(nsync, wf8(:,8), wf18(:,39), A(:,49), n3(:,177), t3x144(:,:,49), nhel, den(35))
    call Hcont_VV(nsync, wf12(:,1), wf12(:,5), A(:,50), n3(:,178), t3x144(:,:,50), nhel, den(48))
    call Hcont_VV(nsync, wf12(:,3), wf12(:,5), A(:,51), n3(:,179), t3x144(:,:,51), nhel, den(50))
    call Hcont_VV(nsync, wf12(:,1), wf12(:,6), A(:,52), n3(:,180), t3x144(:,:,52), nhel, den(53))
    call Hcont_VV(nsync, wf12(:,3), wf12(:,6), A(:,53), n3(:,181), t3x144(:,:,53), nhel, den(54))
    call Hcont_VV(nsync, wf12(:,2), wf12(:,7), A(:,54), n3(:,182), t3x144(:,:,54), nhel, den(73))
    call Hcont_VV(nsync, wf12(:,2), wf12(:,8), A(:,55), n3(:,183), t3x144(:,:,55), nhel, den(50))
    call Hcont_VV(nsync, wf12(:,4), wf12(:,7), A(:,56), n3(:,184), t3x144(:,:,56), nhel, den(53))
    call Hcont_VV(nsync, wf12(:,4), wf12(:,8), A(:,57), n3(:,185), t3x144(:,:,57), nhel, den(54))
    call Hcont_VV(nsync, wf36(:,1), wf4(:,3), A(:,58), n3(:,186), t3x144(:,:,58), nhel, den(29))
    call Hcont_QA(nsync, wf18(:,12), wf8(:,12), A(:,59), n3(:,187), t3x144(:,:,59), nhel, den(32))
    call Hcont_QA(nsync, wf18(:,13), wf8(:,14), A(:,60), n3(:,188), t3x144(:,:,60), nhel, den(35))
    call Hcont_QA(nsync, wf18(:,18), wf8(:,11), A(:,61), n3(:,189), t3x144(:,:,61), nhel, den(41))
    call Hcont_QA(nsync, wf18(:,20), wf8(:,11), A(:,62), n3(:,190), t3x144(:,:,62), nhel, den(43))
    call Hcont_QA(nsync, wf18(:,22), wf8(:,11), A(:,63), n3(:,191), t3x144(:,:,63), nhel, den(45))
    call Hcont_QA(nsync, wf18(:,14), wf8(:,14), A(:,64), n3(:,192), t3x144(:,:,64), nhel, den(36))
    call Hcont_QA(nsync, wf18(:,15), wf8(:,14), A(:,65), n3(:,193), t3x144(:,:,65), nhel, den(37))
    call Hcont_QA(nsync, wf18(:,16), wf8(:,14), A(:,66), n3(:,194), t3x144(:,:,66), nhel, den(38))
    call Hcont_QA(nsync, wf8(:,15), wf18(:,40), A(:,67), n3(:,195), t3x144(:,:,67), nhel, den(75))
    call Hcont_VV(nsync, wf4(:,2), wf36(:,4), A(:,68), n3(:,196), t3x144(:,:,68), nhel, den(29))
    call Hcont_QA(nsync, wf8(:,8), wf18(:,41), A(:,69), n3(:,197), t3x144(:,:,69), nhel, den(36))
    call Hcont_QA(nsync, wf8(:,8), wf18(:,42), A(:,70), n3(:,198), t3x144(:,:,70), nhel, den(37))
    call Hcont_QA(nsync, wf8(:,8), wf18(:,43), A(:,71), n3(:,199), t3x144(:,:,71), nhel, den(38))
    call Hcont_QA(nsync, wf18(:,18), wf8(:,15), A(:,72), n3(:,200), t3x144(:,:,72), nhel, den(41))
    call Hcont_QA(nsync, wf18(:,20), wf8(:,15), A(:,73), n3(:,201), t3x144(:,:,73), nhel, den(43))
    call Hcont_QA(nsync, wf18(:,22), wf8(:,15), A(:,74), n3(:,202), t3x144(:,:,74), nhel, den(45))
    call Hcont_QA(nsync, wf8(:,8), wf18(:,44), A(:,75), n3(:,203), t3x144(:,:,75), nhel, den(35))
    call Hcont_VV(nsync, wf12(:,2), wf12(:,9), A(:,76), n3(:,204), t3x144(:,:,76), nhel, den(76))
    call Hcont_VV(nsync, wf12(:,2), wf12(:,10), A(:,77), n3(:,205), t3x144(:,:,77), nhel, den(48))
    call Hcont_VV(nsync, wf12(:,4), wf12(:,9), A(:,78), n3(:,206), t3x144(:,:,78), nhel, den(54))
    call Hcont_VV(nsync, wf12(:,4), wf12(:,10), A(:,79), n3(:,207), t3x144(:,:,79), nhel, den(53))
    call Hcont_QA(nsync, wf8(:,16), wf18(:,45), A(:,80), n3(:,208), t3x144(:,:,80), nhel, den(79))
    call Hcont_QA(nsync, wf8(:,16), wf18(:,46), A(:,81), n3(:,209), t3x144(:,:,81), nhel, den(81))
    call Hcont_QA(nsync, wf8(:,16), wf18(:,47), A(:,82), n3(:,210), t3x144(:,:,82), nhel, den(83))
    call Hcont_QA(nsync, wf8(:,16), wf18(:,48), A(:,83), n3(:,211), t3x144(:,:,83), nhel, den(85))
    call Hcont_QA(nsync, wf8(:,6), wf18(:,49), A(:,84), n3(:,212), t3x144(:,:,84), nhel, den(86))
    call Hcont_QA(nsync, wf8(:,6), wf18(:,50), A(:,85), n3(:,213), t3x144(:,:,85), nhel, den(87))
    call Hcont_QA(nsync, wf8(:,6), wf18(:,51), A(:,86), n3(:,214), t3x144(:,:,86), nhel, den(88))
    call Hcont_VV(nsync, wf4(:,2), wf36(:,5), A(:,87), n3(:,215), t3x144(:,:,87), nhel, den(29))
    call Hcont_QA(nsync, wf8(:,6), wf18(:,52), A(:,88), n3(:,216), t3x144(:,:,88), nhel, den(32))
    call Hcont_VV(nsync, wf12(:,1), wf12(:,11), A(:,89), n3(:,217), t3x144(:,:,89), nhel, den(89))
    call Hcont_VV(nsync, wf12(:,3), wf12(:,11), A(:,90), n3(:,218), t3x144(:,:,90), nhel, den(90))
    call Hcont_VV(nsync, wf12(:,1), wf12(:,12), A(:,91), n3(:,219), t3x144(:,:,91), nhel, den(48))
    call Hcont_VV(nsync, wf12(:,3), wf12(:,12), A(:,92), n3(:,220), t3x144(:,:,92), nhel, den(50))
    call Hcont_QA(nsync, wf6(:,4), wf24(:,4), A(:,93), n3(:,221), t3x144(:,:,93), nhel, den(5))
    call Hcont_QA(nsync, wf18(:,1), wf8(:,18), A(:,94), n3(:,222), t3x144(:,:,94), nhel, den(8))
    call Hcont_QA(nsync, wf18(:,2), wf8(:,20), A(:,95), n3(:,223), t3x144(:,:,95), nhel, den(11))
    call Hcont_QA(nsync, wf18(:,3), wf8(:,18), A(:,96), n3(:,224), t3x144(:,:,96), nhel, den(13))
    call Hcont_QA(nsync, wf18(:,4), wf8(:,18), A(:,97), n3(:,225), t3x144(:,:,97), nhel, den(15))
    call Hcont_QA(nsync, wf18(:,5), wf8(:,18), A(:,98), n3(:,226), t3x144(:,:,98), nhel, den(17))
    call Hcont_QA(nsync, wf18(:,7), wf8(:,19), A(:,99), n3(:,227), t3x144(:,:,99), nhel, den(20))
    call Hcont_QA(nsync, wf18(:,9), wf8(:,19), A(:,100), n3(:,228), t3x144(:,:,100), nhel, den(22))
    call Hcont_QA(nsync, wf18(:,11), wf8(:,19), A(:,101), n3(:,229), t3x144(:,:,101), nhel, den(24))
    call Hcont_VV(nsync, wf36(:,6), wf4(:,5), A(:,102), n3(:,230), t3x144(:,:,102), nhel, den(94))
    call Hcont_QA(nsync, wf6(:,17), wf24(:,6), A(:,103), n3(:,231), t3x144(:,:,103), nhel, den(98))
    call Hcont_QA(nsync, wf6(:,18), wf24(:,7), A(:,104), n3(:,232), t3x144(:,:,104), nhel, den(101))
    call Hcont_QA(nsync, wf18(:,30), wf8(:,21), A(:,105), n3(:,233), t3x144(:,:,105), nhel, den(103))
    call Hcont_QA(nsync, wf18(:,30), wf8(:,22), A(:,106), n3(:,234), t3x144(:,:,106), nhel, den(104))
    call Hcont_QA(nsync, wf8(:,2), wf18(:,53), A(:,107), n3(:,235), t3x144(:,:,107), nhel, den(106))
    call Hcont_QA(nsync, wf18(:,25), wf8(:,23), A(:,108), n3(:,236), t3x144(:,:,108), nhel, den(107))
    call Hcont_QA(nsync, wf8(:,4), wf18(:,54), A(:,109), n3(:,237), t3x144(:,:,109), nhel, den(109))
    call Hcont_QA(nsync, wf18(:,25), wf8(:,24), A(:,110), n3(:,238), t3x144(:,:,110), nhel, den(110))
    call Hcont_QA(nsync, wf18(:,34), wf8(:,21), A(:,111), n3(:,239), t3x144(:,:,111), nhel, den(111))
    call Hcont_QA(nsync, wf18(:,35), wf8(:,21), A(:,112), n3(:,240), t3x144(:,:,112), nhel, den(112))
    call Hcont_QA(nsync, wf18(:,36), wf8(:,21), A(:,113), n3(:,241), t3x144(:,:,113), nhel, den(113))
    call Hcont_QA(nsync, wf18(:,7), wf8(:,23), A(:,114), n3(:,242), t3x144(:,:,114), nhel, den(114))
    call Hcont_QA(nsync, wf18(:,9), wf8(:,23), A(:,115), n3(:,243), t3x144(:,:,115), nhel, den(115))
    call Hcont_QA(nsync, wf18(:,11), wf8(:,23), A(:,116), n3(:,244), t3x144(:,:,116), nhel, den(116))
    call Hcont_QA(nsync, wf18(:,34), wf8(:,22), A(:,117), n3(:,245), t3x144(:,:,117), nhel, den(117))
    call Hcont_QA(nsync, wf18(:,35), wf8(:,22), A(:,118), n3(:,246), t3x144(:,:,118), nhel, den(118))
    call Hcont_QA(nsync, wf18(:,36), wf8(:,22), A(:,119), n3(:,247), t3x144(:,:,119), nhel, den(119))
    call Hcont_QA(nsync, wf8(:,4), wf18(:,55), A(:,120), n3(:,248), t3x144(:,:,120), nhel, den(120))
    call Hcont_QA(nsync, wf8(:,4), wf18(:,56), A(:,121), n3(:,249), t3x144(:,:,121), nhel, den(121))
    call Hcont_QA(nsync, wf8(:,4), wf18(:,57), A(:,122), n3(:,250), t3x144(:,:,122), nhel, den(122))
    call Hcont_QA(nsync, wf6(:,21), wf24(:,9), A(:,123), n3(:,251), t3x144(:,:,123), nhel, den(126))
    call Hcont_QA(nsync, wf6(:,22), wf24(:,11), A(:,124), n3(:,252), t3x144(:,:,124), nhel, den(130))
    call Hcont_VV(nsync, wf36(:,1), wf4(:,6), A(:,125), n3(:,253), t3x144(:,:,125), nhel, den(133))
    call Hcont_QA(nsync, wf8(:,6), wf18(:,58), A(:,126), n3(:,254), t3x144(:,:,126), nhel, den(135))
    call Hcont_QA(nsync, wf18(:,40), wf8(:,25), A(:,127), n3(:,255), t3x144(:,:,127), nhel, den(137))
    call Hcont_QA(nsync, wf18(:,40), wf8(:,26), A(:,128), n3(:,256), t3x144(:,:,128), nhel, den(138))
    call Hcont_QA(nsync, wf18(:,45), wf8(:,27), A(:,129), n3(:,257), t3x144(:,:,129), nhel, den(139))
    call Hcont_QA(nsync, wf18(:,45), wf8(:,28), A(:,130), n3(:,258), t3x144(:,:,130), nhel, den(140))
    call Hcont_QA(nsync, wf8(:,8), wf18(:,59), A(:,131), n3(:,259), t3x144(:,:,131), nhel, den(142))
    call Hcont_QA(nsync, wf18(:,46), wf8(:,28), A(:,132), n3(:,260), t3x144(:,:,132), nhel, den(143))
    call Hcont_QA(nsync, wf18(:,47), wf8(:,28), A(:,133), n3(:,261), t3x144(:,:,133), nhel, den(144))
    call Hcont_QA(nsync, wf18(:,48), wf8(:,28), A(:,134), n3(:,262), t3x144(:,:,134), nhel, den(145))
    call Hcont_QA(nsync, wf8(:,6), wf18(:,60), A(:,135), n3(:,263), t3x144(:,:,135), nhel, den(146))
    call Hcont_QA(nsync, wf8(:,6), wf18(:,61), A(:,136), n3(:,264), t3x144(:,:,136), nhel, den(147))
    call Hcont_QA(nsync, wf8(:,6), wf18(:,62), A(:,137), n3(:,265), t3x144(:,:,137), nhel, den(148))
    call Hcont_QA(nsync, wf18(:,46), wf8(:,27), A(:,138), n3(:,266), t3x144(:,:,138), nhel, den(149))
    call Hcont_QA(nsync, wf18(:,47), wf8(:,27), A(:,139), n3(:,267), t3x144(:,:,139), nhel, den(150))
    call Hcont_QA(nsync, wf18(:,48), wf8(:,27), A(:,140), n3(:,268), t3x144(:,:,140), nhel, den(151))
    call Hcont_QA(nsync, wf18(:,18), wf8(:,25), A(:,141), n3(:,269), t3x144(:,:,141), nhel, den(152))
    call Hcont_QA(nsync, wf18(:,20), wf8(:,25), A(:,142), n3(:,270), t3x144(:,:,142), nhel, den(153))
    call Hcont_QA(nsync, wf18(:,22), wf8(:,25), A(:,143), n3(:,271), t3x144(:,:,143), nhel, den(154))
    call Hcont_VV(nsync, wf12(:,1), wf12(:,13), A(:,144), n3(:,272), t3x144(:,:,144), nhel, den(155))
    call Hcont_VV(nsync, wf12(:,2), wf12(:,14), A(:,145), n3(:,273), t3x144(:,:,145), nhel, den(156))
    call Hcont_VV(nsync, wf12(:,2), wf12(:,15), A(:,146), n3(:,274), t3x144(:,:,146), nhel, den(157))
    call Hcont_VV(nsync, wf12(:,3), wf12(:,13), A(:,147), n3(:,275), t3x144(:,:,147), nhel, den(158))
    call Hcont_VV(nsync, wf12(:,2), wf12(:,16), A(:,148), n3(:,276), t3x144(:,:,148), nhel, den(159))
    call Hcont_VV(nsync, wf12(:,2), wf12(:,17), A(:,149), n3(:,277), t3x144(:,:,149), nhel, den(160))
    call Hcont_VV(nsync, wf12(:,1), wf12(:,18), A(:,150), n3(:,278), t3x144(:,:,150), nhel, den(161))
    call Hcont_VV(nsync, wf12(:,1), wf12(:,19), A(:,151), n3(:,279), t3x144(:,:,151), nhel, den(162))
    call Hcont_VV(nsync, wf12(:,4), wf12(:,14), A(:,152), n3(:,280), t3x144(:,:,152), nhel, den(163))
    call Hcont_VV(nsync, wf12(:,3), wf12(:,18), A(:,153), n3(:,281), t3x144(:,:,153), nhel, den(164))
    call Hcont_VV(nsync, wf12(:,3), wf12(:,19), A(:,154), n3(:,282), t3x144(:,:,154), nhel, den(165))
    call Hcont_VV(nsync, wf12(:,4), wf12(:,16), A(:,155), n3(:,283), t3x144(:,:,155), nhel, den(166))

end subroutine diagrams


elemental function diagmap(j, n)
  implicit none
  integer, intent(in) :: j, n
  complex(REALKIND) :: diagmap
  diagmap = A(j,n)%j
end function diagmap

function diagsum(j, pos, neg)
  implicit none
  integer, intent(in) :: j, pos(:), neg(:)
  complex(REALKIND) :: diagsum
  diagsum = sum(diagmap(j, pos)) - sum(diagmap(j, neg))
end function diagsum

subroutine colourvectors(A, j, M1, M2)
  implicit none
  type(Hpolcont) :: A(:,:)
  integer, intent(in) :: j
  type(Hpolcont), intent(out) :: M1(2), M2(2) ! M1helarray(2,nhel)
  integer :: empty(0), i

  M1(1)%j = ((-A(j,5)%j-A(j,8)%j)*f(1))/2._/**/REALKIND+((A(j,14)%j+A(j,17)%j)*f(2))/2._/**/REALKIND+((A(j,1)%j+A(j,2)%j+A(j,3)%j &
       +A(j,10)%j+A(j,11)%j+A(j,12)%j)*f(12))/2._/**/REALKIND+((A(j,19)%j+A(j,20)%j+A(j,21)%j+A(j,22)%j)*f(12))/6._/**/REALKIND+(( &
       -A(j,4)%j-A(j,7)%j)*f(17))/2._/**/REALKIND+((-A(j,13)%j-A(j,16)%j)*f(22))/2._/**/REALKIND+((A(j,6)%j+A(j,9)%j+A(j,15)%j &
       +A(j,18)%j)*f(27))/2._/**/REALKIND
  M1(2)%j = ((A(j,5)%j+A(j,8)%j)*f(1))/6._/**/REALKIND+((-A(j,14)%j-A(j,17)%j)*f(2))/6._/**/REALKIND+((-A(j,1)%j-A(j,2)%j-A(j,3)%j &
       -A(j,10)%j-A(j,11)%j-A(j,12)%j)*f(12))/6._/**/REALKIND+((-A(j,19)%j-A(j,20)%j-A(j,21)%j-A(j,22)%j)*f(12))/2._/**/REALKIND &
       +((A(j,4)%j+A(j,7)%j)*f(17))/6._/**/REALKIND+((A(j,13)%j+A(j,16)%j)*f(22))/6._/**/REALKIND+((-A(j,6)%j-A(j,9)%j-A(j,15)%j &
       -A(j,18)%j)*f(27))/6._/**/REALKIND

  M2(1)%j = ((A(j,112)%j+A(j,115)%j+A(j,118)%j+A(j,121)%j)*f(3))/2._/**/REALKIND+((-A(j,133)%j-A(j,136)%j-A(j,139)%j &
       -A(j,142)%j)*f(4))/2._/**/REALKIND+((-A(j,34)%j-A(j,44)%j)*f(5))/2._/**/REALKIND+((A(j,62)%j &
       +A(j,65)%j)*f(6))/2._/**/REALKIND+((-A(j,97)%j-A(j,100)%j)*f(7))/2._/**/REALKIND+((A(j,73)%j &
       +A(j,82)%j)*f(8))/2._/**/REALKIND+((-A(j,31)%j-A(j,41)%j)*f(9))/2._/**/REALKIND+((A(j,70)%j &
       +A(j,85)%j)*f(10))/2._/**/REALKIND+(A(j,23)%j*f(11))/2._/**/REALKIND+((-A(j,102)%j-A(j,103)%j-A(j,104)%j-A(j,105)%j &
       -A(j,106)%j-A(j,107)%j-A(j,108)%j-A(j,109)%j-A(j,110)%j-A(j,123)%j-A(j,124)%j-A(j,125)%j-A(j,126)%j-A(j,127)%j-A(j,128)%j &
       -A(j,129)%j-A(j,130)%j-A(j,131)%j)*f(13))/2._/**/REALKIND+((-A(j,144)%j-A(j,145)%j-A(j,146)%j-A(j,147)%j-A(j,148)%j &
       -A(j,149)%j-A(j,150)%j-A(j,151)%j-A(j,152)%j-A(j,153)%j-A(j,154)%j-A(j,155)%j)*f(13))/6._/**/REALKIND+((A(j,50)%j+A(j,51)%j &
       +A(j,54)%j+A(j,56)%j)*f(14))/6._/**/REALKIND+((A(j,29)%j+A(j,38)%j+A(j,47)%j+A(j,58)%j+A(j,59)%j &
       +A(j,60)%j)*f(14))/2._/**/REALKIND+((A(j,76)%j+A(j,78)%j+A(j,89)%j+A(j,90)%j)*f(15))/6._/**/REALKIND+((A(j,26)%j+A(j,67)%j &
       +A(j,80)%j+A(j,93)%j+A(j,94)%j+A(j,95)%j)*f(15))/2._/**/REALKIND+((A(j,27)%j+A(j,28)%j+A(j,36)%j+A(j,37)%j+A(j,39)%j &
       +A(j,46)%j+A(j,48)%j+A(j,49)%j+A(j,68)%j+A(j,75)%j+A(j,87)%j+A(j,88)%j)*f(16))/2._/**/REALKIND+((A(j,52)%j+A(j,53)%j &
       +A(j,55)%j+A(j,57)%j+A(j,77)%j+A(j,79)%j+A(j,91)%j+A(j,92)%j)*f(16))/6._/**/REALKIND+((A(j,111)%j+A(j,114)%j+A(j,117)%j &
       +A(j,120)%j)*f(18))/2._/**/REALKIND+((-A(j,33)%j-A(j,43)%j)*f(19))/2._/**/REALKIND+((-A(j,96)%j &
       -A(j,99)%j)*f(20))/2._/**/REALKIND+((-A(j,30)%j-A(j,40)%j)*f(21))/2._/**/REALKIND+((A(j,132)%j+A(j,135)%j+A(j,138)%j &
       +A(j,141)%j)*f(23))/2._/**/REALKIND+((-A(j,61)%j-A(j,64)%j)*f(24))/2._/**/REALKIND+((-A(j,72)%j &
       -A(j,81)%j)*f(25))/2._/**/REALKIND+((-A(j,69)%j-A(j,84)%j)*f(26))/2._/**/REALKIND+((-A(j,113)%j-A(j,116)%j-A(j,119)%j &
       -A(j,122)%j-A(j,134)%j-A(j,137)%j-A(j,140)%j-A(j,143)%j)*f(28))/2._/**/REALKIND+((A(j,35)%j+A(j,45)%j+A(j,63)%j &
       +A(j,66)%j)*f(29))/2._/**/REALKIND+((A(j,74)%j+A(j,83)%j+A(j,98)%j+A(j,101)%j)*f(30))/2._/**/REALKIND+((A(j,32)%j &
       +A(j,42)%j)*f(31))/2._/**/REALKIND+((A(j,71)%j+A(j,86)%j)*f(32))/2._/**/REALKIND-(A(j,25)%j*f(33))/2._/**/REALKIND &
       -(A(j,24)%j*f(34))/2._/**/REALKIND
  M2(2)%j = ((-A(j,112)%j-A(j,115)%j-A(j,118)%j-A(j,121)%j)*f(3))/6._/**/REALKIND+((A(j,133)%j+A(j,136)%j+A(j,139)%j &
       +A(j,142)%j)*f(4))/6._/**/REALKIND+((A(j,34)%j+A(j,44)%j)*f(5))/6._/**/REALKIND+((-A(j,62)%j &
       -A(j,65)%j)*f(6))/6._/**/REALKIND+((A(j,97)%j+A(j,100)%j)*f(7))/6._/**/REALKIND+((-A(j,73)%j &
       -A(j,82)%j)*f(8))/6._/**/REALKIND+((A(j,31)%j+A(j,41)%j)*f(9))/6._/**/REALKIND+((-A(j,70)%j &
       -A(j,85)%j)*f(10))/6._/**/REALKIND-(A(j,23)%j*f(11))/6._/**/REALKIND+((A(j,102)%j+A(j,103)%j+A(j,104)%j+A(j,105)%j &
       +A(j,106)%j+A(j,107)%j+A(j,108)%j+A(j,109)%j+A(j,110)%j+A(j,123)%j+A(j,124)%j+A(j,125)%j+A(j,126)%j+A(j,127)%j+A(j,128)%j &
       +A(j,129)%j+A(j,130)%j+A(j,131)%j)*f(13))/6._/**/REALKIND+((A(j,144)%j+A(j,145)%j+A(j,146)%j+A(j,147)%j+A(j,148)%j &
       +A(j,149)%j+A(j,150)%j+A(j,151)%j+A(j,152)%j+A(j,153)%j+A(j,154)%j+A(j,155)%j)*f(13))/2._/**/REALKIND+((-A(j,50)%j &
       -A(j,51)%j-A(j,54)%j-A(j,56)%j)*f(14))/2._/**/REALKIND+((-A(j,29)%j-A(j,38)%j-A(j,47)%j-A(j,58)%j-A(j,59)%j &
       -A(j,60)%j)*f(14))/6._/**/REALKIND+((-A(j,76)%j-A(j,78)%j-A(j,89)%j-A(j,90)%j)*f(15))/2._/**/REALKIND+((-A(j,26)%j &
       -A(j,67)%j-A(j,80)%j-A(j,93)%j-A(j,94)%j-A(j,95)%j)*f(15))/6._/**/REALKIND+((-A(j,27)%j-A(j,28)%j-A(j,36)%j-A(j,37)%j &
       -A(j,39)%j-A(j,46)%j-A(j,48)%j-A(j,49)%j-A(j,68)%j-A(j,75)%j-A(j,87)%j-A(j,88)%j)*f(16))/6._/**/REALKIND+((-A(j,52)%j &
       -A(j,53)%j-A(j,55)%j-A(j,57)%j-A(j,77)%j-A(j,79)%j-A(j,91)%j-A(j,92)%j)*f(16))/2._/**/REALKIND+((-A(j,111)%j-A(j,114)%j &
       -A(j,117)%j-A(j,120)%j)*f(18))/6._/**/REALKIND+((A(j,33)%j+A(j,43)%j)*f(19))/6._/**/REALKIND+((A(j,96)%j &
       +A(j,99)%j)*f(20))/6._/**/REALKIND+((A(j,30)%j+A(j,40)%j)*f(21))/6._/**/REALKIND+((-A(j,132)%j-A(j,135)%j-A(j,138)%j &
       -A(j,141)%j)*f(23))/6._/**/REALKIND+((A(j,61)%j+A(j,64)%j)*f(24))/6._/**/REALKIND+((A(j,72)%j &
       +A(j,81)%j)*f(25))/6._/**/REALKIND+((A(j,69)%j+A(j,84)%j)*f(26))/6._/**/REALKIND+((A(j,113)%j+A(j,116)%j+A(j,119)%j &
       +A(j,122)%j+A(j,134)%j+A(j,137)%j+A(j,140)%j+A(j,143)%j)*f(28))/6._/**/REALKIND+((-A(j,35)%j-A(j,45)%j-A(j,63)%j &
       -A(j,66)%j)*f(29))/6._/**/REALKIND+((-A(j,74)%j-A(j,83)%j-A(j,98)%j-A(j,101)%j)*f(30))/6._/**/REALKIND+((-A(j,32)%j &
       -A(j,42)%j)*f(31))/6._/**/REALKIND+((-A(j,71)%j-A(j,86)%j)*f(32))/6._/**/REALKIND+(A(j,25)%j*f(33))/6._/**/REALKIND &
       +(A(j,24)%j*f(34))/6._/**/REALKIND


  M1(:)%hf = Hel(j)
  M2(:)%hf = Hel(j)

  !M(i) corresponds to \Gamma_{i} in Fabios thesis

end subroutine colourvectors


! **********************************************************************
subroutine colint(M, M2colint)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K1(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppwwtt_ttxbbxwwx_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(2)
  real(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

    do i = 1, 2
      do j = 1, 2
        M2colint = M2colint + real(conjg(M(i))*K1(i,j)*M(j))
      end do
    end do

end subroutine colint

! **********************************************************************
subroutine colint_ct(M, Mct, M2colint_ct, l)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppwwtt_ttxbbxwwx_1_/**/REALKIND, only: K2
  implicit none
  complex(REALKIND), intent(in)  :: M(2), Mct(2)
  real(REALKIND),    intent(out) :: M2colint_ct
  integer, intent(in) :: l
  integer ::  i, j

  M2colint_ct = 0

  do i = 1, 2
    do j = 1, 2
      M2colint_ct = M2colint_ct + real(conjg(M(i))*K2(i+2*l,j)*Mct(j))
    end do
  end do

end subroutine colint_ct

! **********************************************************************
subroutine colint_IR(M, M2IRadd)
! M(i)   = <M|Ci> colour component of matrix element
! K1(i,j) = .....
! **********************************************************************
  use ol_colourmatrix_ppwwtt_ttxbbxwwx_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(2)
  real(REALKIND),    intent(out) :: M2IRadd(22)
  integer ::  i, j, k, colmatpos

  M2IRadd = 0

  do k = 1, 23-1
    colmatpos = 2*k
    do i = 1, 2
      do j = 1, 2
        M2IRadd(k) = M2IRadd(k) + real(conjg(M(i))*K1(i+colmatpos,j)*M(j))
      end do
    end do
  end do

end subroutine colint_IR

! **********************************************************************
subroutine colintmunu(M1, M2, M2colint)
! M1(i)    = <M1|Ci> colour component of matrix element
! M2(i)    = <M2|Ci> colour component of matrix element
! M2colint = <M1|M2>
!          = Sum_{i,j} <M1|Ci> * <Ci|Cj> * <Cj|M2>
!          = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppwwtt_ttxbbxwwx_1_/**/REALKIND, only: K2
  implicit none

  complex(REALKIND), intent(in)  :: M1(2)
  complex(REALKIND), intent(in)  :: M2(2)
  complex(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

  do i = 1, 2
    do j = 1, 2
      M2colint = M2colint + M1(i)*K2(i,j)*conjg(M2(j))
    end do
  end do

end subroutine colintmunu





! **********************************************************************
subroutine colborninterf(M, M0_col, l)
! M(i)         = <M|Ci> colour component of matrix element
! M0_col(i)    = <M2|Ci> colour component of matrix element,
!                see \tilde{M}_{j} in Fabios thesis
! M2colint = Sum_{i} <M1|Ci> * <Ci|Cj>
!          = colour-summed squared matrix element
! KL(i,j) = <Ci|Cj> with elements Cj of 1-loop colour basis
! **********************************************************************
  use ol_colourmatrix_ppwwtt_ttxbbxwwx_1_/**/REALKIND, only: KL
  implicit none

  type(Hpolcont), intent(in)  :: M(2)
  type(Hpolcont), intent(out)  :: M0_col(2)
  integer, intent(in) :: l
  integer :: i, j

  do j = 1, 2 !size(KL(1,:))
    M0_col(j)%j = 0
    M0_col(j)%hf = M(1)%hf
    do i = 1, 2 !size(KL(:,1))
      M0_col(j)%j = M0_col(j)%j  + conjg(M(i)%j)*KL(i+2*l,j)
    end do
  end do

end subroutine colborninterf

end subroutine amp2

end module ol_loop_ppwwtt_ttxbbxwwx_1_/**/REALKIND
