
module ol_external_ppwwtt_ttxwwxgg_1
  implicit none
  integer :: dummy_counter
  ! Permutation and inverse permutation of external particles
  integer, save :: external_perm_ppwwtt_ttxwwxgg_1(6) = &
                     [ (dummy_counter, dummy_counter = 1, 6) ]
  integer, save :: external_perm_inv_ppwwtt_ttxwwxgg_1(6) = &
                     [ (dummy_counter, dummy_counter = 1, 6) ]
  integer, save :: extcomb_perm_ppwwtt_ttxwwxgg_1(0:22) = &
                     [ (dummy_counter, dummy_counter = 0, 22) ]
  ! Particle types (mapping of fields to integers is not fixed!)
  integer, save :: particle_types_ppwwtt_ttxwwxgg_1(6) = &
                     [ 1, 2, 3, 4, 5, 5 ]
  ! Colour and helicity average factors per particle
  integer, save :: average_factors_ppwwtt_ttxwwxgg_1(6) = &
                     [ 6, 6, 3, 3, 16, 16 ]
  ! Average factor; initialised to the identity permutation
  integer, save :: average_factor_ppwwtt_ttxwwxgg_1 = &
                     72
  integer, save :: channel_number_ppwwtt_ttxwwxgg_1 = -1
  ! external particle helicities
  logical, save :: hel_not_initialised = .true.
  integer, save :: H(6,144) ! H(i,la) = helicity of particle i in configuration la
  integer, save :: H_HC(144,6)
  integer, save :: POLSEL(6) = 0
  integer, save :: photonid_ppwwtt_ttxwwxgg_1(6) = 0

  contains

  subroutine n_external(n) &
      & bind(c,name="ol_f_n_external_ppwwtt_ttxwwxgg_1")
    ! Return the number of external particles
    implicit none
    integer, intent(out) :: n
    n = 6
  end subroutine n_external


  subroutine n_external_c(n) &
      & bind(c,name="ol_n_external_ppwwtt_ttxwwxgg_1")
    use, intrinsic :: iso_c_binding, only: c_int
    implicit none
    integer(c_int) :: n
    n = 6
  end subroutine n_external_c


  subroutine set_permutation(perm) &
      & bind(c,name="ol_f_set_permutation_ppwwtt_ttxwwxgg_1")
    use ol_parameters_decl_/**/DREALKIND, only: out_symmetry_on
    use ol_external_decl_/**/DREALKIND, only: n_scatt
    use ol_generic, only: factorial
    implicit none
    integer, intent(in) :: perm(6)
    integer :: i, j, ii, jj
    integer :: particle_types_perm_ppwwtt_ttxwwxgg_1(6)
    external_perm_ppwwtt_ttxwwxgg_1 = perm
    do i = 1, 6
      external_perm_inv_ppwwtt_ttxwwxgg_1( &
        external_perm_ppwwtt_ttxwwxgg_1(i)) = i
      particle_types_perm_ppwwtt_ttxwwxgg_1(i) = &
        particle_types_ppwwtt_ttxwwxgg_1( &
        external_perm_ppwwtt_ttxwwxgg_1(i))
    end do
    do i = 1, 6
      do j = 1, i
        if (external_perm_ppwwtt_ttxwwxgg_1(i) >= &
          external_perm_ppwwtt_ttxwwxgg_1(j)) then
          ii = external_perm_ppwwtt_ttxwwxgg_1(i)
          jj = external_perm_ppwwtt_ttxwwxgg_1(j)
        else
          ii = external_perm_ppwwtt_ttxwwxgg_1(j)
          jj = external_perm_ppwwtt_ttxwwxgg_1(i)
        end if
        extcomb_perm_ppwwtt_ttxwwxgg_1((i*(i-1))/2 + j) = (ii*(ii-1))/2 + jj
      end do
    end do
    ! Colour and helicity average factor
    average_factor_ppwwtt_ttxwwxgg_1 = 1
    do i = 1, n_scatt
      average_factor_ppwwtt_ttxwwxgg_1 = &
        average_factor_ppwwtt_ttxwwxgg_1 &
        * average_factors_ppwwtt_ttxwwxgg_1( &
        external_perm_ppwwtt_ttxwwxgg_1(i))
    end do
    ! Symmetry factor for outgoing particles
    if (out_symmetry_on /= 0) then
      do i = 1, 6
        average_factor_ppwwtt_ttxwwxgg_1 = &
          average_factor_ppwwtt_ttxwwxgg_1 &
          * factorial(count(particle_types_perm_ppwwtt_ttxwwxgg_1(n_scatt+1:6) == i))
      end do
    end if
  end subroutine set_permutation


  subroutine set_permutation_c(perm) &
      & bind(c,name="ol_set_permutation_ppwwtt_ttxwwxgg_1")
    use, intrinsic :: iso_c_binding, only: c_int
    implicit none
    integer(c_int), intent(in) :: perm(6)
    integer :: f_perm(6)
    f_perm = perm
    call set_permutation(f_perm)
  end subroutine set_permutation_c


  subroutine get_masses(m_ex) &
      & bind(c,name="ol_f_get_masses_ppwwtt_ttxwwxgg_1")
    ! Return the masses of the external particles in the current permutation.
    use KIND_TYPES, only: DREALKIND
    use ol_parameters_decl_/**/DREALKIND
    implicit none
    real(DREALKIND), intent(out) :: m_ex(6)
    integer        :: i
    real(DREALKIND) :: m_ex_orig(6)
    ! External particle masses for in the identity permutation
    m_ex_orig = [ rMT_unscaled, rMT_unscaled, rMW_unscaled, rMW_unscaled, rZERO, rZERO ]
    do i = 1, 6
      m_ex(i) = m_ex_orig(external_perm_ppwwtt_ttxwwxgg_1(i))
    end do
  end subroutine get_masses


  subroutine get_masses_c(m_ex) &
      & bind(c,name="ol_get_masses_ppwwtt_ttxwwxgg_1")
    use KIND_TYPES, only: DREALKIND
    use, intrinsic :: iso_c_binding, only: c_double
    implicit none
    real(c_double), intent(out) :: m_ex(6)
    real(DREALKIND) :: f_m_ex(6)
    call get_masses(f_m_ex)
    m_ex = f_m_ex
  end subroutine get_masses_c


  subroutine rambo(sqrt_s, p_rambo) &
      & bind(c,name="ol_f_rambo_ppwwtt_ttxwwxgg_1")
    use KIND_TYPES, only: DREALKIND
    use ol_kinematics_/**/DREALKIND, only: rambo_generic => rambo
    implicit none
    real(DREALKIND), intent(in) :: sqrt_s
    real(DREALKIND), intent(out) :: p_rambo(0:3,6)
    real(DREALKIND) :: m_ex(6)
    call get_masses(m_ex)
    call rambo_generic(sqrt_s, m_ex, p_rambo)
  end subroutine rambo


  subroutine rambo_c(sqrt_s, p_rambo) &
      & bind(c,name="ol_rambo_ppwwtt_ttxwwxgg_1")
    use KIND_TYPES, only: DREALKIND
    use, intrinsic :: iso_c_binding, only: c_double
    implicit none
    real(c_double), intent(in) :: sqrt_s
    real(c_double), intent(out) :: p_rambo(0:3,6)
    real(DREALKIND) :: f_sqrt_s
    real(DREALKIND) :: f_p_rambo(0:3,6)
    f_sqrt_s = sqrt_s
    call rambo(f_sqrt_s, f_p_rambo)
    p_rambo = f_p_rambo
  end subroutine rambo_c


  subroutine hel_init
    implicit none
    integer :: binpos, flip, binco
    hel_not_initialised = .false.
    ! helicity configurations for this process
  H(:,  1) = [ -1, -1, -1, -1, -1, -1 ]
  H(:,  2) = [ -1, -1, -1, -1, -1,  1 ]
  H(:,  3) = [ -1, -1, -1, -1,  1, -1 ]
  H(:,  4) = [ -1, -1, -1, -1,  1,  1 ]
  H(:,  5) = [ -1, -1, -1,  0, -1, -1 ]
  H(:,  6) = [ -1, -1, -1,  0, -1,  1 ]
  H(:,  7) = [ -1, -1, -1,  0,  1, -1 ]
  H(:,  8) = [ -1, -1, -1,  0,  1,  1 ]
  H(:,  9) = [ -1, -1, -1,  1, -1, -1 ]
  H(:, 10) = [ -1, -1, -1,  1, -1,  1 ]
  H(:, 11) = [ -1, -1, -1,  1,  1, -1 ]
  H(:, 12) = [ -1, -1, -1,  1,  1,  1 ]
  H(:, 13) = [ -1, -1,  0, -1, -1, -1 ]
  H(:, 14) = [ -1, -1,  0, -1, -1,  1 ]
  H(:, 15) = [ -1, -1,  0, -1,  1, -1 ]
  H(:, 16) = [ -1, -1,  0, -1,  1,  1 ]
  H(:, 17) = [ -1, -1,  0,  0, -1, -1 ]
  H(:, 18) = [ -1, -1,  0,  0, -1,  1 ]
  H(:, 19) = [ -1, -1,  0,  0,  1, -1 ]
  H(:, 20) = [ -1, -1,  0,  0,  1,  1 ]
  H(:, 21) = [ -1, -1,  0,  1, -1, -1 ]
  H(:, 22) = [ -1, -1,  0,  1, -1,  1 ]
  H(:, 23) = [ -1, -1,  0,  1,  1, -1 ]
  H(:, 24) = [ -1, -1,  0,  1,  1,  1 ]
  H(:, 25) = [ -1, -1,  1, -1, -1, -1 ]
  H(:, 26) = [ -1, -1,  1, -1, -1,  1 ]
  H(:, 27) = [ -1, -1,  1, -1,  1, -1 ]
  H(:, 28) = [ -1, -1,  1, -1,  1,  1 ]
  H(:, 29) = [ -1, -1,  1,  0, -1, -1 ]
  H(:, 30) = [ -1, -1,  1,  0, -1,  1 ]
  H(:, 31) = [ -1, -1,  1,  0,  1, -1 ]
  H(:, 32) = [ -1, -1,  1,  0,  1,  1 ]
  H(:, 33) = [ -1, -1,  1,  1, -1, -1 ]
  H(:, 34) = [ -1, -1,  1,  1, -1,  1 ]
  H(:, 35) = [ -1, -1,  1,  1,  1, -1 ]
  H(:, 36) = [ -1, -1,  1,  1,  1,  1 ]
  H(:, 37) = [ -1,  1, -1, -1, -1, -1 ]
  H(:, 38) = [ -1,  1, -1, -1, -1,  1 ]
  H(:, 39) = [ -1,  1, -1, -1,  1, -1 ]
  H(:, 40) = [ -1,  1, -1, -1,  1,  1 ]
  H(:, 41) = [ -1,  1, -1,  0, -1, -1 ]
  H(:, 42) = [ -1,  1, -1,  0, -1,  1 ]
  H(:, 43) = [ -1,  1, -1,  0,  1, -1 ]
  H(:, 44) = [ -1,  1, -1,  0,  1,  1 ]
  H(:, 45) = [ -1,  1, -1,  1, -1, -1 ]
  H(:, 46) = [ -1,  1, -1,  1, -1,  1 ]
  H(:, 47) = [ -1,  1, -1,  1,  1, -1 ]
  H(:, 48) = [ -1,  1, -1,  1,  1,  1 ]
  H(:, 49) = [ -1,  1,  0, -1, -1, -1 ]
  H(:, 50) = [ -1,  1,  0, -1, -1,  1 ]
  H(:, 51) = [ -1,  1,  0, -1,  1, -1 ]
  H(:, 52) = [ -1,  1,  0, -1,  1,  1 ]
  H(:, 53) = [ -1,  1,  0,  0, -1, -1 ]
  H(:, 54) = [ -1,  1,  0,  0, -1,  1 ]
  H(:, 55) = [ -1,  1,  0,  0,  1, -1 ]
  H(:, 56) = [ -1,  1,  0,  0,  1,  1 ]
  H(:, 57) = [ -1,  1,  0,  1, -1, -1 ]
  H(:, 58) = [ -1,  1,  0,  1, -1,  1 ]
  H(:, 59) = [ -1,  1,  0,  1,  1, -1 ]
  H(:, 60) = [ -1,  1,  0,  1,  1,  1 ]
  H(:, 61) = [ -1,  1,  1, -1, -1, -1 ]
  H(:, 62) = [ -1,  1,  1, -1, -1,  1 ]
  H(:, 63) = [ -1,  1,  1, -1,  1, -1 ]
  H(:, 64) = [ -1,  1,  1, -1,  1,  1 ]
  H(:, 65) = [ -1,  1,  1,  0, -1, -1 ]
  H(:, 66) = [ -1,  1,  1,  0, -1,  1 ]
  H(:, 67) = [ -1,  1,  1,  0,  1, -1 ]
  H(:, 68) = [ -1,  1,  1,  0,  1,  1 ]
  H(:, 69) = [ -1,  1,  1,  1, -1, -1 ]
  H(:, 70) = [ -1,  1,  1,  1, -1,  1 ]
  H(:, 71) = [ -1,  1,  1,  1,  1, -1 ]
  H(:, 72) = [ -1,  1,  1,  1,  1,  1 ]
  H(:, 73) = [  1, -1, -1, -1, -1, -1 ]
  H(:, 74) = [  1, -1, -1, -1, -1,  1 ]
  H(:, 75) = [  1, -1, -1, -1,  1, -1 ]
  H(:, 76) = [  1, -1, -1, -1,  1,  1 ]
  H(:, 77) = [  1, -1, -1,  0, -1, -1 ]
  H(:, 78) = [  1, -1, -1,  0, -1,  1 ]
  H(:, 79) = [  1, -1, -1,  0,  1, -1 ]
  H(:, 80) = [  1, -1, -1,  0,  1,  1 ]
  H(:, 81) = [  1, -1, -1,  1, -1, -1 ]
  H(:, 82) = [  1, -1, -1,  1, -1,  1 ]
  H(:, 83) = [  1, -1, -1,  1,  1, -1 ]
  H(:, 84) = [  1, -1, -1,  1,  1,  1 ]
  H(:, 85) = [  1, -1,  0, -1, -1, -1 ]
  H(:, 86) = [  1, -1,  0, -1, -1,  1 ]
  H(:, 87) = [  1, -1,  0, -1,  1, -1 ]
  H(:, 88) = [  1, -1,  0, -1,  1,  1 ]
  H(:, 89) = [  1, -1,  0,  0, -1, -1 ]
  H(:, 90) = [  1, -1,  0,  0, -1,  1 ]
  H(:, 91) = [  1, -1,  0,  0,  1, -1 ]
  H(:, 92) = [  1, -1,  0,  0,  1,  1 ]
  H(:, 93) = [  1, -1,  0,  1, -1, -1 ]
  H(:, 94) = [  1, -1,  0,  1, -1,  1 ]
  H(:, 95) = [  1, -1,  0,  1,  1, -1 ]
  H(:, 96) = [  1, -1,  0,  1,  1,  1 ]
  H(:, 97) = [  1, -1,  1, -1, -1, -1 ]
  H(:, 98) = [  1, -1,  1, -1, -1,  1 ]
  H(:, 99) = [  1, -1,  1, -1,  1, -1 ]
  H(:,100) = [  1, -1,  1, -1,  1,  1 ]
  H(:,101) = [  1, -1,  1,  0, -1, -1 ]
  H(:,102) = [  1, -1,  1,  0, -1,  1 ]
  H(:,103) = [  1, -1,  1,  0,  1, -1 ]
  H(:,104) = [  1, -1,  1,  0,  1,  1 ]
  H(:,105) = [  1, -1,  1,  1, -1, -1 ]
  H(:,106) = [  1, -1,  1,  1, -1,  1 ]
  H(:,107) = [  1, -1,  1,  1,  1, -1 ]
  H(:,108) = [  1, -1,  1,  1,  1,  1 ]
  H(:,109) = [  1,  1, -1, -1, -1, -1 ]
  H(:,110) = [  1,  1, -1, -1, -1,  1 ]
  H(:,111) = [  1,  1, -1, -1,  1, -1 ]
  H(:,112) = [  1,  1, -1, -1,  1,  1 ]
  H(:,113) = [  1,  1, -1,  0, -1, -1 ]
  H(:,114) = [  1,  1, -1,  0, -1,  1 ]
  H(:,115) = [  1,  1, -1,  0,  1, -1 ]
  H(:,116) = [  1,  1, -1,  0,  1,  1 ]
  H(:,117) = [  1,  1, -1,  1, -1, -1 ]
  H(:,118) = [  1,  1, -1,  1, -1,  1 ]
  H(:,119) = [  1,  1, -1,  1,  1, -1 ]
  H(:,120) = [  1,  1, -1,  1,  1,  1 ]
  H(:,121) = [  1,  1,  0, -1, -1, -1 ]
  H(:,122) = [  1,  1,  0, -1, -1,  1 ]
  H(:,123) = [  1,  1,  0, -1,  1, -1 ]
  H(:,124) = [  1,  1,  0, -1,  1,  1 ]
  H(:,125) = [  1,  1,  0,  0, -1, -1 ]
  H(:,126) = [  1,  1,  0,  0, -1,  1 ]
  H(:,127) = [  1,  1,  0,  0,  1, -1 ]
  H(:,128) = [  1,  1,  0,  0,  1,  1 ]
  H(:,129) = [  1,  1,  0,  1, -1, -1 ]
  H(:,130) = [  1,  1,  0,  1, -1,  1 ]
  H(:,131) = [  1,  1,  0,  1,  1, -1 ]
  H(:,132) = [  1,  1,  0,  1,  1,  1 ]
  H(:,133) = [  1,  1,  1, -1, -1, -1 ]
  H(:,134) = [  1,  1,  1, -1, -1,  1 ]
  H(:,135) = [  1,  1,  1, -1,  1, -1 ]
  H(:,136) = [  1,  1,  1, -1,  1,  1 ]
  H(:,137) = [  1,  1,  1,  0, -1, -1 ]
  H(:,138) = [  1,  1,  1,  0, -1,  1 ]
  H(:,139) = [  1,  1,  1,  0,  1, -1 ]
  H(:,140) = [  1,  1,  1,  0,  1,  1 ]
  H(:,141) = [  1,  1,  1,  1, -1, -1 ]
  H(:,142) = [  1,  1,  1,  1, -1,  1 ]
  H(:,143) = [  1,  1,  1,  1,  1, -1 ]
  H(:,144) = [  1,  1,  1,  1,  1,  1 ]

  H_HC(:,5) = [ ((((2*(binco-1)+flip)*2+binpos, flip = 0, 1), binpos = 1, 2), binco = 1, 144/2/2) ]
  H_HC(:,6) = [ ((((2*(binco-1)+flip)*1+binpos, flip = 0, 1), binpos = 1, 1), binco = 1, 144/1/2) ]
  end subroutine hel_init


  subroutine pol_init(pol) &
      & bind(c,name="ol_f_pol_init_ppwwtt_ttxwwxgg_1")
    implicit none
    integer, intent(in) :: pol(6)
    POLSEL = pol
  end subroutine pol_init


  subroutine set_photons(photon_id) &
      & bind(c,name="ol_f_set_photons_ppwwtt_ttxwwxgg_1")
    implicit none
    integer, intent(in) :: photon_id(6)
    photonid_ppwwtt_ttxwwxgg_1 = photon_id
  end subroutine set_photons


end module ol_external_ppwwtt_ttxwwxgg_1


module ol_settings_ppwwtt_ttxwwxgg_1
  implicit none
  ! Activates optimized helicity bookkeeping. Default=false
    logical, save :: hel_mem_opt = .false.
  ! Calculate loop correlators
    logical, save :: loopcc = .false.

  contains

  subroutine set_hel_mem_opt(set) &
      & bind(c,name="ol_hel_mem_opt_ppwwtt_ttxwwxgg_1")
    implicit none
    logical, intent(in) :: set
    hel_mem_opt = set
  end subroutine set_hel_mem_opt

  subroutine set_loopcc(set,was) &
      & bind(c,name="ol_loopcc_ppwwtt_ttxwwxgg_1")
    implicit none
    logical, intent(in) :: set
    logical :: was
    was = loopcc
    loopcc = set
  end subroutine set_loopcc

end module ol_settings_ppwwtt_ttxwwxgg_1

module colour_basis_ppwwtt_ttxwwxgg_1
  implicit none
  ! tree colour basis
  integer, save :: extcolours(6) = [1,1,0,0,2,2]
  contains

  pure subroutine tree_colbasis_dim(extcols, ncolb, ncoupl, maxpows, nhel) &
    & bind(c, name="ol_tree_colbasis_dim_ppwwtt_ttxwwxgg_1")
    implicit none
    ! colour representation of external particles: 0=neutral, 1=fundamental, 2=adjoint
    integer, intent(out) :: extcols(6)
    ! number of tree colour basis elements; number of selected couplings, number of selected powers per coupling
    integer, intent(out) :: ncolb, ncoupl, maxpows
    ! number of helicity configurations (all, not just non-vanishing)
    integer, intent(out) :: nhel
    extcols = extcolours
    ncolb = 2
    ncoupl = 1
    maxpows = 1
    nhel = 144
  end subroutine tree_colbasis_dim

  subroutine tree_colbasis(basis, powers) &
    & bind(c, name="ol_tree_colbasis_ppwwtt_ttxwwxgg_1")
    implicit none
    integer, intent(out) :: powers(1,1)
    integer, intent(out) :: basis(3,2)
#if 1 > 0
    ! selected powers for each selected coupling
    powers = reshape([4], [1,1])
#endif
#if 2 > 0
    ! tree colour basis: [[composition_number, permutation_number, *coupling_powers], ...]
    basis = reshape( &
      [2,18,2,2,24,2], &
      [3,2])
#endif
  end subroutine tree_colbasis

end module colour_basis_ppwwtt_ttxwwxgg_1

! **********************************************************************
module ol_heltables_OLR_ppwwtt_ttxwwxgg_1
! **********************************************************************
  use KIND_TYPES, only: intkind2
  implicit none

  logical :: heltables_not_init = .true.

  ! helicity states of external particles
  ! integer, save :: &
  !   H1(2) = [-1,1], &
  !   H2(3) = [-1,0,1]
  !   ...
  integer, save :: &
    H1(2) = [-1,1], &
    H2(2) = [-1,1], &
    H3(3) = [-1,0,1], &
    H4(3) = [-1,0,1], &
    H5(2) = [-1,1], &
    H6(2) = [-1,1]

  ! number of helicity states for wave functions returned by a propagator call: n2(sz)
  ! number of helicity states for wave functions in a v-point vertex call (v >= 3)
  ! or a contraction (v = 3): n<v>(v,sz)
  integer(intkind2), save :: n2(126), n3(3,482), n4(4,7)

  ! helicity tables used in the construction of the h helicity states of a wave function (amplitude)
  ! from an v-point vertex (contraction): t<v>x<h>(v-1,h,sz)
  integer(intkind2), save :: t3x9(2,9,2), t3x6(2,6,4), t3x4(2,4,11), t3x24(2,24,16), t3x18(2,18,24), t3x16(2,16,24), t3x8(2,8,30), &
    t3x12(2,12,32), t3x36(2,36,50), t3x144(2,144,289), t4x36(3,36,1), t4x18(3,18,2), t4x16(3,16,4)

  ! change of global-helicity state resulting from flip of individual-particle helicity
  integer(intkind2), save :: eflip(144,6)
  integer,           save :: exthel(144,6)
  integer,           save :: firstpol(6)

  contains

! **********************************************************************
subroutine init_heltables
! **********************************************************************
  use ol_helicity_init, only: heltable
  implicit none

  ! I/O helicity tables for vertices, propagators and contractions;
  ! helicity table for a vertex call: n_in/n_out are the number helicity states of the incoming/outgoing wave functions
  ! call heltable([<n_in1>, <n_in2>, ..., <n_out>], n, t)
  ! propagators only need the number of helicity configurations which is equal for the incoming and outgoing wave function
  ! n = <n>
  call heltable([3,2,6], n3(:,1), t3x6(:,:,1))
  call heltable([2,3,6], n3(:,2), t3x6(:,:,2))
  call heltable([2,2,4], n3(:,3), t3x4(:,:,1))
  n2(1) = 6
  n2(2) = 6
  call heltable([6,6,36], n3(:,4), t3x36(:,:,1))
  call heltable([2,6,12], n3(:,5), t3x12(:,:,1))
  call heltable([6,2,12], n3(:,6), t3x12(:,:,2))
  n2(3) = 12
  call heltable([6,2,12], n3(:,7), t3x12(:,:,3))
  call heltable([2,6,12], n3(:,8), t3x12(:,:,4))
  n2(4) = 12
  call heltable([2,2,4], n3(:,9), t3x4(:,:,2))
  n2(5) = 4
  call heltable([3,6,18], n3(:,10), t3x18(:,:,1))
  call heltable([4,2,8], n3(:,11), t3x8(:,:,1))
  n2(6) = 18
  call heltable([4,3,12], n3(:,12), t3x12(:,:,5))
  n2(7) = 12
  call heltable([2,2,4], n3(:,13), t3x4(:,:,3))
  n2(8) = 4
  call heltable([4,2,8], n3(:,14), t3x8(:,:,2))
  call heltable([4,3,12], n3(:,15), t3x12(:,:,6))
  n2(9) = 12
  call heltable([2,4,8], n3(:,16), t3x8(:,:,3))
  n2(10) = 8
  call heltable([2,2,4], n3(:,17), t3x4(:,:,4))
  n2(11) = 4
  call heltable([3,4,12], n3(:,18), t3x12(:,:,7))
  n2(12) = 12
  call heltable([6,3,18], n3(:,19), t3x18(:,:,2))
  call heltable([2,4,8], n3(:,20), t3x8(:,:,4))
  n2(13) = 18
  call heltable([2,2,4], n3(:,21), t3x4(:,:,5))
  n2(14) = 4
  call heltable([3,4,12], n3(:,22), t3x12(:,:,8))
  n2(15) = 12
  call heltable([2,4,8], n3(:,23), t3x8(:,:,5))
  call heltable([4,2,8], n3(:,24), t3x8(:,:,6))
  n2(16) = 8
  call heltable([3,3,9], n3(:,25), t3x9(:,:,1))
  call heltable([4,4,16], n3(:,26), t3x16(:,:,1))
  call heltable([3,3,9], n3(:,27), t3x9(:,:,2))
  call heltable([4,4,16], n3(:,28), t3x16(:,:,2))
  n2(17) = 9
  call heltable([4,4,16], n3(:,29), t3x16(:,:,3))
  call heltable([9,2,18], n3(:,30), t3x18(:,:,3))
  n2(18) = 18
  call heltable([2,9,18], n3(:,31), t3x18(:,:,4))
  n2(19) = 18
  call heltable([2,9,18], n3(:,32), t3x18(:,:,5))
  n2(20) = 18
  call heltable([4,4,16], n3(:,33), t3x16(:,:,4))
  call heltable([4,4,16], n3(:,34), t3x16(:,:,5))
  call heltable([4,4,16], n3(:,35), t3x16(:,:,6))
  call heltable([2,9,18], n3(:,36), t3x18(:,:,6))
  n2(21) = 18
  call heltable([9,2,18], n3(:,37), t3x18(:,:,7))
  n2(22) = 18
  call heltable([9,2,18], n3(:,38), t3x18(:,:,8))
  n2(23) = 18
  call heltable([2,2,4], n3(:,39), t3x4(:,:,6))
  call heltable([4,2,2,16], n4(:,1), t4x16(:,:,1))
  call heltable([4,2,2,16], n4(:,2), t4x16(:,:,2))
  call heltable([4,2,2,16], n4(:,3), t4x16(:,:,3))
  call heltable([4,2,2,16], n4(:,4), t4x16(:,:,4))
  call heltable([3,3,4,36], n4(:,5), t4x36(:,:,1))
  call heltable([3,3,2,18], n4(:,6), t4x18(:,:,1))
  call heltable([4,2,8], n3(:,40), t3x8(:,:,7))
  call heltable([3,3,2,18], n4(:,7), t4x18(:,:,2))
  call heltable([4,2,8], n3(:,41), t3x8(:,:,8))
  call heltable([4,2,8], n3(:,42), t3x8(:,:,9))
  call heltable([2,4,8], n3(:,43), t3x8(:,:,10))
  call heltable([4,2,8], n3(:,44), t3x8(:,:,11))
  call heltable([2,4,8], n3(:,45), t3x8(:,:,12))
  call heltable([9,4,36], n3(:,46), t3x36(:,:,2))
  call heltable([9,4,36], n3(:,47), t3x36(:,:,3))
  call heltable([9,2,18], n3(:,48), t3x18(:,:,9))
  call heltable([9,2,18], n3(:,49), t3x18(:,:,10))
  call heltable([9,2,18], n3(:,50), t3x18(:,:,11))
  call heltable([9,2,18], n3(:,51), t3x18(:,:,12))
  call heltable([6,6,36], n3(:,52), t3x36(:,:,4))
  call heltable([6,2,12], n3(:,53), t3x12(:,:,9))
  call heltable([2,6,12], n3(:,54), t3x12(:,:,10))
  call heltable([6,2,12], n3(:,55), t3x12(:,:,11))
  n2(24) = 12
  call heltable([2,6,12], n3(:,56), t3x12(:,:,12))
  n2(25) = 12
  call heltable([2,2,4], n3(:,57), t3x4(:,:,7))
  call heltable([4,2,8], n3(:,58), t3x8(:,:,13))
  call heltable([4,2,8], n3(:,59), t3x8(:,:,14))
  call heltable([2,4,8], n3(:,60), t3x8(:,:,15))
  n2(26) = 8
  call heltable([4,3,12], n3(:,61), t3x12(:,:,13))
  call heltable([3,6,18], n3(:,62), t3x18(:,:,13))
  n2(27) = 8
  call heltable([4,3,12], n3(:,63), t3x12(:,:,14))
  n2(28) = 8
  call heltable([2,4,8], n3(:,64), t3x8(:,:,16))
  call heltable([2,4,8], n3(:,65), t3x8(:,:,17))
  call heltable([4,2,8], n3(:,66), t3x8(:,:,18))
  n2(29) = 8
  call heltable([4,4,16], n3(:,67), t3x16(:,:,7))
  call heltable([4,4,16], n3(:,68), t3x16(:,:,8))
  call heltable([4,4,16], n3(:,69), t3x16(:,:,9))
  call heltable([4,4,16], n3(:,70), t3x16(:,:,10))
  call heltable([4,4,16], n3(:,71), t3x16(:,:,11))
  call heltable([4,4,16], n3(:,72), t3x16(:,:,12))
  call heltable([6,3,18], n3(:,73), t3x18(:,:,14))
  n2(30) = 8
  call heltable([3,4,12], n3(:,74), t3x12(:,:,15))
  n2(31) = 8
  call heltable([3,4,12], n3(:,75), t3x12(:,:,16))
  call heltable([2,4,8], n3(:,76), t3x8(:,:,19))
  call heltable([2,2,4], n3(:,77), t3x4(:,:,8))
  n2(32) = 4
  call heltable([4,2,8], n3(:,78), t3x8(:,:,20))
  call heltable([4,3,12], n3(:,79), t3x12(:,:,17))
  n2(33) = 12
  call heltable([2,2,4], n3(:,80), t3x4(:,:,9))
  n2(34) = 4
  call heltable([4,2,8], n3(:,81), t3x8(:,:,21))
  call heltable([4,3,12], n3(:,82), t3x12(:,:,18))
  n2(35) = 12
  call heltable([2,3,6], n3(:,83), t3x6(:,:,3))
  n2(36) = 6
  call heltable([6,6,36], n3(:,84), t3x36(:,:,5))
  call heltable([6,2,12], n3(:,85), t3x12(:,:,19))
  call heltable([6,2,12], n3(:,86), t3x12(:,:,20))
  n2(37) = 12
  call heltable([9,2,18], n3(:,87), t3x18(:,:,15))
  call heltable([2,9,18], n3(:,88), t3x18(:,:,16))
  call heltable([2,9,18], n3(:,89), t3x18(:,:,17))
  call heltable([4,4,16], n3(:,90), t3x16(:,:,13))
  call heltable([4,4,16], n3(:,91), t3x16(:,:,14))
  call heltable([4,4,16], n3(:,92), t3x16(:,:,15))
  call heltable([4,4,16], n3(:,93), t3x16(:,:,16))
  call heltable([4,4,16], n3(:,94), t3x16(:,:,17))
  call heltable([4,4,16], n3(:,95), t3x16(:,:,18))
  call heltable([6,3,18], n3(:,96), t3x18(:,:,18))
  n2(38) = 18
  call heltable([4,2,8], n3(:,97), t3x8(:,:,22))
  call heltable([2,2,4], n3(:,98), t3x4(:,:,10))
  n2(39) = 4
  call heltable([3,4,12], n3(:,99), t3x12(:,:,21))
  n2(40) = 12
  call heltable([2,4,8], n3(:,100), t3x8(:,:,23))
  call heltable([2,2,4], n3(:,101), t3x4(:,:,11))
  n2(41) = 4
  call heltable([3,4,12], n3(:,102), t3x12(:,:,22))
  n2(42) = 12
  call heltable([2,4,8], n3(:,103), t3x8(:,:,24))
  call heltable([2,9,18], n3(:,104), t3x18(:,:,19))
  call heltable([9,2,18], n3(:,105), t3x18(:,:,20))
  call heltable([9,2,18], n3(:,106), t3x18(:,:,21))
  call heltable([4,4,16], n3(:,107), t3x16(:,:,19))
  call heltable([4,4,16], n3(:,108), t3x16(:,:,20))
  call heltable([4,4,16], n3(:,109), t3x16(:,:,21))
  call heltable([4,4,16], n3(:,110), t3x16(:,:,22))
  call heltable([4,4,16], n3(:,111), t3x16(:,:,23))
  call heltable([4,4,16], n3(:,112), t3x16(:,:,24))
  call heltable([3,2,6], n3(:,113), t3x6(:,:,4))
  n2(43) = 6
  call heltable([6,6,36], n3(:,114), t3x36(:,:,6))
  call heltable([2,6,12], n3(:,115), t3x12(:,:,23))
  n2(44) = 12
  call heltable([2,6,12], n3(:,116), t3x12(:,:,24))
  call heltable([3,6,18], n3(:,117), t3x18(:,:,22))
  n2(45) = 18
  call heltable([6,4,24], n3(:,118), t3x24(:,:,1))
  n2(46) = 6
  n2(47) = 24
  call heltable([4,6,24], n3(:,119), t3x24(:,:,2))
  n2(48) = 6
  n2(49) = 24
  n2(50) = 4
  n2(51) = 6
  call heltable([2,6,12], n3(:,120), t3x12(:,:,25))
  call heltable([2,6,12], n3(:,121), t3x12(:,:,26))
  n2(52) = 6
  call heltable([6,2,12], n3(:,122), t3x12(:,:,27))
  call heltable([6,2,12], n3(:,123), t3x12(:,:,28))
  n2(53) = 12
  n2(54) = 12
  call heltable([3,6,18], n3(:,124), t3x18(:,:,23))
  n2(55) = 4
  n2(56) = 4
  call heltable([4,3,12], n3(:,125), t3x12(:,:,29))
  call heltable([4,2,8], n3(:,126), t3x8(:,:,25))
  n2(57) = 18
  n2(58) = 12
  n2(59) = 4
  n2(60) = 4
  call heltable([4,3,12], n3(:,127), t3x12(:,:,30))
  call heltable([4,2,8], n3(:,128), t3x8(:,:,26))
  n2(61) = 12
  n2(62) = 8
  call heltable([2,4,8], n3(:,129), t3x8(:,:,27))
  n2(63) = 4
  n2(64) = 4
  call heltable([3,4,12], n3(:,130), t3x12(:,:,31))
  call heltable([2,4,8], n3(:,131), t3x8(:,:,28))
  call heltable([6,3,18], n3(:,132), t3x18(:,:,24))
  n2(65) = 12
  n2(66) = 18
  n2(67) = 4
  n2(68) = 4
  call heltable([3,4,12], n3(:,133), t3x12(:,:,32))
  call heltable([2,4,8], n3(:,134), t3x8(:,:,29))
  n2(69) = 12
  n2(70) = 8
  call heltable([4,2,8], n3(:,135), t3x8(:,:,30))
  call heltable([9,4,36], n3(:,136), t3x36(:,:,7))
  n2(71) = 36
  call heltable([4,9,36], n3(:,137), t3x36(:,:,8))
  n2(72) = 36
  call heltable([4,9,36], n3(:,138), t3x36(:,:,9))
  n2(73) = 36
  call heltable([4,9,36], n3(:,139), t3x36(:,:,10))
  n2(74) = 36
  call heltable([9,4,36], n3(:,140), t3x36(:,:,11))
  n2(75) = 36
  call heltable([9,4,36], n3(:,141), t3x36(:,:,12))
  n2(76) = 36
  n2(77) = 18
  n2(78) = 18
  n2(79) = 18
  call heltable([9,4,36], n3(:,142), t3x36(:,:,13))
  n2(80) = 36
  call heltable([4,9,36], n3(:,143), t3x36(:,:,14))
  n2(81) = 36
  call heltable([4,9,36], n3(:,144), t3x36(:,:,15))
  n2(82) = 36
  call heltable([4,9,36], n3(:,145), t3x36(:,:,16))
  n2(83) = 36
  call heltable([9,4,36], n3(:,146), t3x36(:,:,17))
  n2(84) = 36
  call heltable([9,4,36], n3(:,147), t3x36(:,:,18))
  n2(85) = 36
  n2(86) = 18
  n2(87) = 18
  n2(88) = 18
  call heltable([18,2,36], n3(:,148), t3x36(:,:,19))
  call heltable([2,18,36], n3(:,149), t3x36(:,:,20))
  n2(89) = 36
  call heltable([2,18,36], n3(:,150), t3x36(:,:,21))
  n2(90) = 36
  call heltable([3,12,36], n3(:,151), t3x36(:,:,22))
  n2(91) = 36
  call heltable([2,12,24], n3(:,152), t3x24(:,:,3))
  n2(92) = 24
  call heltable([3,12,36], n3(:,153), t3x36(:,:,23))
  n2(93) = 36
  call heltable([2,12,24], n3(:,154), t3x24(:,:,4))
  n2(94) = 24
  call heltable([2,18,36], n3(:,155), t3x36(:,:,24))
  call heltable([18,2,36], n3(:,156), t3x36(:,:,25))
  n2(95) = 36
  call heltable([18,2,36], n3(:,157), t3x36(:,:,26))
  n2(96) = 36
  call heltable([12,3,36], n3(:,158), t3x36(:,:,27))
  n2(97) = 36
  call heltable([12,2,24], n3(:,159), t3x24(:,:,5))
  n2(98) = 24
  call heltable([12,3,36], n3(:,160), t3x36(:,:,28))
  n2(99) = 36
  call heltable([12,2,24], n3(:,161), t3x24(:,:,6))
  n2(100) = 24
  call heltable([18,2,36], n3(:,162), t3x36(:,:,29))
  call heltable([18,2,36], n3(:,163), t3x36(:,:,30))
  call heltable([18,2,36], n3(:,164), t3x36(:,:,31))
  call heltable([2,18,36], n3(:,165), t3x36(:,:,32))
  call heltable([2,18,36], n3(:,166), t3x36(:,:,33))
  call heltable([2,18,36], n3(:,167), t3x36(:,:,34))
  call heltable([2,18,36], n3(:,168), t3x36(:,:,35))
  n2(101) = 36
  call heltable([2,18,36], n3(:,169), t3x36(:,:,36))
  n2(102) = 36
  call heltable([2,18,36], n3(:,170), t3x36(:,:,37))
  n2(103) = 36
  call heltable([2,18,36], n3(:,171), t3x36(:,:,38))
  n2(104) = 36
  call heltable([2,18,36], n3(:,172), t3x36(:,:,39))
  n2(105) = 36
  call heltable([2,18,36], n3(:,173), t3x36(:,:,40))
  n2(106) = 36
  call heltable([18,2,36], n3(:,174), t3x36(:,:,41))
  n2(107) = 36
  call heltable([18,2,36], n3(:,175), t3x36(:,:,42))
  n2(108) = 36
  call heltable([18,2,36], n3(:,176), t3x36(:,:,43))
  n2(109) = 36
  call heltable([18,2,36], n3(:,177), t3x36(:,:,44))
  n2(110) = 36
  call heltable([18,2,36], n3(:,178), t3x36(:,:,45))
  n2(111) = 36
  call heltable([18,2,36], n3(:,179), t3x36(:,:,46))
  n2(112) = 36
  call heltable([3,12,36], n3(:,180), t3x36(:,:,47))
  n2(113) = 36
  call heltable([2,12,24], n3(:,181), t3x24(:,:,7))
  n2(114) = 24
  call heltable([3,8,24], n3(:,182), t3x24(:,:,8))
  n2(115) = 24
  call heltable([12,3,36], n3(:,183), t3x36(:,:,48))
  n2(116) = 36
  call heltable([12,2,24], n3(:,184), t3x24(:,:,9))
  n2(117) = 24
  call heltable([8,3,24], n3(:,185), t3x24(:,:,10))
  n2(118) = 24
  call heltable([3,12,36], n3(:,186), t3x36(:,:,49))
  n2(119) = 36
  call heltable([2,12,24], n3(:,187), t3x24(:,:,11))
  n2(120) = 24
  call heltable([3,8,24], n3(:,188), t3x24(:,:,12))
  n2(121) = 24
  call heltable([12,3,36], n3(:,189), t3x36(:,:,50))
  n2(122) = 36
  call heltable([12,2,24], n3(:,190), t3x24(:,:,13))
  n2(123) = 24
  call heltable([8,3,24], n3(:,191), t3x24(:,:,14))
  n2(124) = 24
  call heltable([3,8,24], n3(:,192), t3x24(:,:,15))
  n2(125) = 24
  call heltable([8,3,24], n3(:,193), t3x24(:,:,16))
  n2(126) = 24
  call heltable([4,36,144], n3(:,194), t3x144(:,:,1))
  call heltable([12,12,144], n3(:,195), t3x144(:,:,2))
  call heltable([12,12,144], n3(:,196), t3x144(:,:,3))
  call heltable([8,18,144], n3(:,197), t3x144(:,:,4))
  call heltable([12,12,144], n3(:,198), t3x144(:,:,5))
  call heltable([18,8,144], n3(:,199), t3x144(:,:,6))
  call heltable([12,12,144], n3(:,200), t3x144(:,:,7))
  call heltable([18,8,144], n3(:,201), t3x144(:,:,8))
  call heltable([12,12,144], n3(:,202), t3x144(:,:,9))
  call heltable([8,18,144], n3(:,203), t3x144(:,:,10))
  call heltable([12,12,144], n3(:,204), t3x144(:,:,11))
  call heltable([18,8,144], n3(:,205), t3x144(:,:,12))
  call heltable([18,8,144], n3(:,206), t3x144(:,:,13))
  call heltable([9,16,144], n3(:,207), t3x144(:,:,14))
  call heltable([9,16,144], n3(:,208), t3x144(:,:,15))
  call heltable([9,16,144], n3(:,209), t3x144(:,:,16))
  call heltable([8,18,144], n3(:,210), t3x144(:,:,17))
  call heltable([8,18,144], n3(:,211), t3x144(:,:,18))
  call heltable([8,18,144], n3(:,212), t3x144(:,:,19))
  call heltable([9,16,144], n3(:,213), t3x144(:,:,20))
  call heltable([9,16,144], n3(:,214), t3x144(:,:,21))
  call heltable([9,16,144], n3(:,215), t3x144(:,:,22))
  call heltable([8,18,144], n3(:,216), t3x144(:,:,23))
  call heltable([8,18,144], n3(:,217), t3x144(:,:,24))
  call heltable([8,18,144], n3(:,218), t3x144(:,:,25))
  call heltable([8,18,144], n3(:,219), t3x144(:,:,26))
  call heltable([8,18,144], n3(:,220), t3x144(:,:,27))
  call heltable([8,18,144], n3(:,221), t3x144(:,:,28))
  call heltable([8,18,144], n3(:,222), t3x144(:,:,29))
  call heltable([8,18,144], n3(:,223), t3x144(:,:,30))
  call heltable([8,18,144], n3(:,224), t3x144(:,:,31))
  call heltable([8,18,144], n3(:,225), t3x144(:,:,32))
  call heltable([8,18,144], n3(:,226), t3x144(:,:,33))
  call heltable([8,18,144], n3(:,227), t3x144(:,:,34))
  call heltable([8,18,144], n3(:,228), t3x144(:,:,35))
  call heltable([8,18,144], n3(:,229), t3x144(:,:,36))
  call heltable([8,18,144], n3(:,230), t3x144(:,:,37))
  call heltable([12,12,144], n3(:,231), t3x144(:,:,38))
  call heltable([12,12,144], n3(:,232), t3x144(:,:,39))
  call heltable([9,16,144], n3(:,233), t3x144(:,:,40))
  call heltable([9,16,144], n3(:,234), t3x144(:,:,41))
  call heltable([9,16,144], n3(:,235), t3x144(:,:,42))
  call heltable([9,16,144], n3(:,236), t3x144(:,:,43))
  call heltable([4,36,144], n3(:,237), t3x144(:,:,44))
  call heltable([18,8,144], n3(:,238), t3x144(:,:,45))
  call heltable([18,8,144], n3(:,239), t3x144(:,:,46))
  call heltable([18,8,144], n3(:,240), t3x144(:,:,47))
  call heltable([18,8,144], n3(:,241), t3x144(:,:,48))
  call heltable([18,8,144], n3(:,242), t3x144(:,:,49))
  call heltable([18,8,144], n3(:,243), t3x144(:,:,50))
  call heltable([4,36,144], n3(:,244), t3x144(:,:,51))
  call heltable([4,36,144], n3(:,245), t3x144(:,:,52))
  call heltable([8,18,144], n3(:,246), t3x144(:,:,53))
  call heltable([8,18,144], n3(:,247), t3x144(:,:,54))
  call heltable([8,18,144], n3(:,248), t3x144(:,:,55))
  call heltable([8,18,144], n3(:,249), t3x144(:,:,56))
  call heltable([4,36,144], n3(:,250), t3x144(:,:,57))
  call heltable([12,12,144], n3(:,251), t3x144(:,:,58))
  call heltable([12,12,144], n3(:,252), t3x144(:,:,59))
  call heltable([12,12,144], n3(:,253), t3x144(:,:,60))
  call heltable([12,12,144], n3(:,254), t3x144(:,:,61))
  call heltable([36,4,144], n3(:,255), t3x144(:,:,62))
  call heltable([18,8,144], n3(:,256), t3x144(:,:,63))
  call heltable([12,12,144], n3(:,257), t3x144(:,:,64))
  call heltable([18,8,144], n3(:,258), t3x144(:,:,65))
  call heltable([12,12,144], n3(:,259), t3x144(:,:,66))
  call heltable([18,8,144], n3(:,260), t3x144(:,:,67))
  call heltable([12,12,144], n3(:,261), t3x144(:,:,68))
  call heltable([18,8,144], n3(:,262), t3x144(:,:,69))
  call heltable([12,12,144], n3(:,263), t3x144(:,:,70))
  call heltable([18,8,144], n3(:,264), t3x144(:,:,71))
  call heltable([8,18,144], n3(:,265), t3x144(:,:,72))
  call heltable([12,12,144], n3(:,266), t3x144(:,:,73))
  call heltable([18,8,144], n3(:,267), t3x144(:,:,74))
  call heltable([12,12,144], n3(:,268), t3x144(:,:,75))
  call heltable([18,8,144], n3(:,269), t3x144(:,:,76))
  call heltable([18,8,144], n3(:,270), t3x144(:,:,77))
  call heltable([9,16,144], n3(:,271), t3x144(:,:,78))
  call heltable([9,16,144], n3(:,272), t3x144(:,:,79))
  call heltable([9,16,144], n3(:,273), t3x144(:,:,80))
  call heltable([8,18,144], n3(:,274), t3x144(:,:,81))
  call heltable([8,18,144], n3(:,275), t3x144(:,:,82))
  call heltable([18,8,144], n3(:,276), t3x144(:,:,83))
  call heltable([18,8,144], n3(:,277), t3x144(:,:,84))
  call heltable([18,8,144], n3(:,278), t3x144(:,:,85))
  call heltable([9,16,144], n3(:,279), t3x144(:,:,86))
  call heltable([9,16,144], n3(:,280), t3x144(:,:,87))
  call heltable([9,16,144], n3(:,281), t3x144(:,:,88))
  call heltable([8,18,144], n3(:,282), t3x144(:,:,89))
  call heltable([8,18,144], n3(:,283), t3x144(:,:,90))
  call heltable([18,8,144], n3(:,284), t3x144(:,:,91))
  call heltable([18,8,144], n3(:,285), t3x144(:,:,92))
  call heltable([18,8,144], n3(:,286), t3x144(:,:,93))
  call heltable([8,18,144], n3(:,287), t3x144(:,:,94))
  call heltable([8,18,144], n3(:,288), t3x144(:,:,95))
  call heltable([18,8,144], n3(:,289), t3x144(:,:,96))
  call heltable([18,8,144], n3(:,290), t3x144(:,:,97))
  call heltable([18,8,144], n3(:,291), t3x144(:,:,98))
  call heltable([8,18,144], n3(:,292), t3x144(:,:,99))
  call heltable([8,18,144], n3(:,293), t3x144(:,:,100))
  call heltable([18,8,144], n3(:,294), t3x144(:,:,101))
  call heltable([18,8,144], n3(:,295), t3x144(:,:,102))
  call heltable([18,8,144], n3(:,296), t3x144(:,:,103))
  call heltable([18,8,144], n3(:,297), t3x144(:,:,104))
  call heltable([18,8,144], n3(:,298), t3x144(:,:,105))
  call heltable([18,8,144], n3(:,299), t3x144(:,:,106))
  call heltable([18,8,144], n3(:,300), t3x144(:,:,107))
  call heltable([18,8,144], n3(:,301), t3x144(:,:,108))
  call heltable([18,8,144], n3(:,302), t3x144(:,:,109))
  call heltable([12,12,144], n3(:,303), t3x144(:,:,110))
  call heltable([12,12,144], n3(:,304), t3x144(:,:,111))
  call heltable([18,8,144], n3(:,305), t3x144(:,:,112))
  call heltable([12,12,144], n3(:,306), t3x144(:,:,113))
  call heltable([18,8,144], n3(:,307), t3x144(:,:,114))
  call heltable([12,12,144], n3(:,308), t3x144(:,:,115))
  call heltable([8,18,144], n3(:,309), t3x144(:,:,116))
  call heltable([12,12,144], n3(:,310), t3x144(:,:,117))
  call heltable([12,12,144], n3(:,311), t3x144(:,:,118))
  call heltable([18,8,144], n3(:,312), t3x144(:,:,119))
  call heltable([18,8,144], n3(:,313), t3x144(:,:,120))
  call heltable([12,12,144], n3(:,314), t3x144(:,:,121))
  call heltable([18,8,144], n3(:,315), t3x144(:,:,122))
  call heltable([12,12,144], n3(:,316), t3x144(:,:,123))
  call heltable([4,36,144], n3(:,317), t3x144(:,:,124))
  call heltable([12,12,144], n3(:,318), t3x144(:,:,125))
  call heltable([12,12,144], n3(:,319), t3x144(:,:,126))
  call heltable([8,18,144], n3(:,320), t3x144(:,:,127))
  call heltable([8,18,144], n3(:,321), t3x144(:,:,128))
  call heltable([8,18,144], n3(:,322), t3x144(:,:,129))
  call heltable([9,16,144], n3(:,323), t3x144(:,:,130))
  call heltable([9,16,144], n3(:,324), t3x144(:,:,131))
  call heltable([9,16,144], n3(:,325), t3x144(:,:,132))
  call heltable([8,18,144], n3(:,326), t3x144(:,:,133))
  call heltable([8,18,144], n3(:,327), t3x144(:,:,134))
  call heltable([8,18,144], n3(:,328), t3x144(:,:,135))
  call heltable([18,8,144], n3(:,329), t3x144(:,:,136))
  call heltable([18,8,144], n3(:,330), t3x144(:,:,137))
  call heltable([18,8,144], n3(:,331), t3x144(:,:,138))
  call heltable([8,18,144], n3(:,332), t3x144(:,:,139))
  call heltable([8,18,144], n3(:,333), t3x144(:,:,140))
  call heltable([8,18,144], n3(:,334), t3x144(:,:,141))
  call heltable([18,8,144], n3(:,335), t3x144(:,:,142))
  call heltable([18,8,144], n3(:,336), t3x144(:,:,143))
  call heltable([18,8,144], n3(:,337), t3x144(:,:,144))
  call heltable([9,16,144], n3(:,338), t3x144(:,:,145))
  call heltable([9,16,144], n3(:,339), t3x144(:,:,146))
  call heltable([9,16,144], n3(:,340), t3x144(:,:,147))
  call heltable([18,8,144], n3(:,341), t3x144(:,:,148))
  call heltable([18,8,144], n3(:,342), t3x144(:,:,149))
  call heltable([18,8,144], n3(:,343), t3x144(:,:,150))
  call heltable([12,12,144], n3(:,344), t3x144(:,:,151))
  call heltable([12,12,144], n3(:,345), t3x144(:,:,152))
  call heltable([12,12,144], n3(:,346), t3x144(:,:,153))
  call heltable([8,18,144], n3(:,347), t3x144(:,:,154))
  call heltable([12,12,144], n3(:,348), t3x144(:,:,155))
  call heltable([8,18,144], n3(:,349), t3x144(:,:,156))
  call heltable([8,18,144], n3(:,350), t3x144(:,:,157))
  call heltable([18,8,144], n3(:,351), t3x144(:,:,158))
  call heltable([12,12,144], n3(:,352), t3x144(:,:,159))
  call heltable([18,8,144], n3(:,353), t3x144(:,:,160))
  call heltable([12,12,144], n3(:,354), t3x144(:,:,161))
  call heltable([18,8,144], n3(:,355), t3x144(:,:,162))
  call heltable([8,18,144], n3(:,356), t3x144(:,:,163))
  call heltable([8,18,144], n3(:,357), t3x144(:,:,164))
  call heltable([8,18,144], n3(:,358), t3x144(:,:,165))
  call heltable([9,16,144], n3(:,359), t3x144(:,:,166))
  call heltable([9,16,144], n3(:,360), t3x144(:,:,167))
  call heltable([9,16,144], n3(:,361), t3x144(:,:,168))
  call heltable([8,18,144], n3(:,362), t3x144(:,:,169))
  call heltable([8,18,144], n3(:,363), t3x144(:,:,170))
  call heltable([8,18,144], n3(:,364), t3x144(:,:,171))
  call heltable([8,18,144], n3(:,365), t3x144(:,:,172))
  call heltable([8,18,144], n3(:,366), t3x144(:,:,173))
  call heltable([8,18,144], n3(:,367), t3x144(:,:,174))
  call heltable([18,8,144], n3(:,368), t3x144(:,:,175))
  call heltable([18,8,144], n3(:,369), t3x144(:,:,176))
  call heltable([18,8,144], n3(:,370), t3x144(:,:,177))
  call heltable([18,8,144], n3(:,371), t3x144(:,:,178))
  call heltable([18,8,144], n3(:,372), t3x144(:,:,179))
  call heltable([18,8,144], n3(:,373), t3x144(:,:,180))
  call heltable([9,16,144], n3(:,374), t3x144(:,:,181))
  call heltable([9,16,144], n3(:,375), t3x144(:,:,182))
  call heltable([9,16,144], n3(:,376), t3x144(:,:,183))
  call heltable([18,8,144], n3(:,377), t3x144(:,:,184))
  call heltable([18,8,144], n3(:,378), t3x144(:,:,185))
  call heltable([18,8,144], n3(:,379), t3x144(:,:,186))
  call heltable([12,12,144], n3(:,380), t3x144(:,:,187))
  call heltable([12,12,144], n3(:,381), t3x144(:,:,188))
  call heltable([4,36,144], n3(:,382), t3x144(:,:,189))
  call heltable([12,12,144], n3(:,383), t3x144(:,:,190))
  call heltable([12,12,144], n3(:,384), t3x144(:,:,191))
  call heltable([8,18,144], n3(:,385), t3x144(:,:,192))
  call heltable([12,12,144], n3(:,386), t3x144(:,:,193))
  call heltable([8,18,144], n3(:,387), t3x144(:,:,194))
  call heltable([12,12,144], n3(:,388), t3x144(:,:,195))
  call heltable([8,18,144], n3(:,389), t3x144(:,:,196))
  call heltable([6,24,144], n3(:,390), t3x144(:,:,197))
  call heltable([6,24,144], n3(:,391), t3x144(:,:,198))
  call heltable([36,4,144], n3(:,392), t3x144(:,:,199))
  call heltable([12,12,144], n3(:,393), t3x144(:,:,200))
  call heltable([12,12,144], n3(:,394), t3x144(:,:,201))
  call heltable([12,12,144], n3(:,395), t3x144(:,:,202))
  call heltable([12,12,144], n3(:,396), t3x144(:,:,203))
  call heltable([12,12,144], n3(:,397), t3x144(:,:,204))
  call heltable([12,12,144], n3(:,398), t3x144(:,:,205))
  call heltable([8,18,144], n3(:,399), t3x144(:,:,206))
  call heltable([12,12,144], n3(:,400), t3x144(:,:,207))
  call heltable([12,12,144], n3(:,401), t3x144(:,:,208))
  call heltable([18,8,144], n3(:,402), t3x144(:,:,209))
  call heltable([8,18,144], n3(:,403), t3x144(:,:,210))
  call heltable([12,12,144], n3(:,404), t3x144(:,:,211))
  call heltable([8,18,144], n3(:,405), t3x144(:,:,212))
  call heltable([12,12,144], n3(:,406), t3x144(:,:,213))
  call heltable([12,12,144], n3(:,407), t3x144(:,:,214))
  call heltable([18,8,144], n3(:,408), t3x144(:,:,215))
  call heltable([8,18,144], n3(:,409), t3x144(:,:,216))
  call heltable([12,12,144], n3(:,410), t3x144(:,:,217))
  call heltable([8,18,144], n3(:,411), t3x144(:,:,218))
  call heltable([18,8,144], n3(:,412), t3x144(:,:,219))
  call heltable([18,8,144], n3(:,413), t3x144(:,:,220))
  call heltable([12,12,144], n3(:,414), t3x144(:,:,221))
  call heltable([18,8,144], n3(:,415), t3x144(:,:,222))
  call heltable([8,18,144], n3(:,416), t3x144(:,:,223))
  call heltable([12,12,144], n3(:,417), t3x144(:,:,224))
  call heltable([12,12,144], n3(:,418), t3x144(:,:,225))
  call heltable([8,18,144], n3(:,419), t3x144(:,:,226))
  call heltable([12,12,144], n3(:,420), t3x144(:,:,227))
  call heltable([18,8,144], n3(:,421), t3x144(:,:,228))
  call heltable([8,18,144], n3(:,422), t3x144(:,:,229))
  call heltable([12,12,144], n3(:,423), t3x144(:,:,230))
  call heltable([12,12,144], n3(:,424), t3x144(:,:,231))
  call heltable([8,18,144], n3(:,425), t3x144(:,:,232))
  call heltable([18,8,144], n3(:,426), t3x144(:,:,233))
  call heltable([18,8,144], n3(:,427), t3x144(:,:,234))
  call heltable([8,18,144], n3(:,428), t3x144(:,:,235))
  call heltable([4,36,144], n3(:,429), t3x144(:,:,236))
  call heltable([4,36,144], n3(:,430), t3x144(:,:,237))
  call heltable([4,36,144], n3(:,431), t3x144(:,:,238))
  call heltable([4,36,144], n3(:,432), t3x144(:,:,239))
  call heltable([4,36,144], n3(:,433), t3x144(:,:,240))
  call heltable([4,36,144], n3(:,434), t3x144(:,:,241))
  call heltable([18,8,144], n3(:,435), t3x144(:,:,242))
  call heltable([18,8,144], n3(:,436), t3x144(:,:,243))
  call heltable([18,8,144], n3(:,437), t3x144(:,:,244))
  call heltable([8,18,144], n3(:,438), t3x144(:,:,245))
  call heltable([8,18,144], n3(:,439), t3x144(:,:,246))
  call heltable([8,18,144], n3(:,440), t3x144(:,:,247))
  call heltable([4,36,144], n3(:,441), t3x144(:,:,248))
  call heltable([4,36,144], n3(:,442), t3x144(:,:,249))
  call heltable([4,36,144], n3(:,443), t3x144(:,:,250))
  call heltable([4,36,144], n3(:,444), t3x144(:,:,251))
  call heltable([4,36,144], n3(:,445), t3x144(:,:,252))
  call heltable([4,36,144], n3(:,446), t3x144(:,:,253))
  call heltable([8,18,144], n3(:,447), t3x144(:,:,254))
  call heltable([8,18,144], n3(:,448), t3x144(:,:,255))
  call heltable([8,18,144], n3(:,449), t3x144(:,:,256))
  call heltable([18,8,144], n3(:,450), t3x144(:,:,257))
  call heltable([18,8,144], n3(:,451), t3x144(:,:,258))
  call heltable([18,8,144], n3(:,452), t3x144(:,:,259))
  call heltable([18,8,144], n3(:,453), t3x144(:,:,260))
  call heltable([18,8,144], n3(:,454), t3x144(:,:,261))
  call heltable([18,8,144], n3(:,455), t3x144(:,:,262))
  call heltable([8,18,144], n3(:,456), t3x144(:,:,263))
  call heltable([8,18,144], n3(:,457), t3x144(:,:,264))
  call heltable([8,18,144], n3(:,458), t3x144(:,:,265))
  call heltable([8,18,144], n3(:,459), t3x144(:,:,266))
  call heltable([8,18,144], n3(:,460), t3x144(:,:,267))
  call heltable([8,18,144], n3(:,461), t3x144(:,:,268))
  call heltable([18,8,144], n3(:,462), t3x144(:,:,269))
  call heltable([18,8,144], n3(:,463), t3x144(:,:,270))
  call heltable([18,8,144], n3(:,464), t3x144(:,:,271))
  call heltable([8,18,144], n3(:,465), t3x144(:,:,272))
  call heltable([8,18,144], n3(:,466), t3x144(:,:,273))
  call heltable([8,18,144], n3(:,467), t3x144(:,:,274))
  call heltable([18,8,144], n3(:,468), t3x144(:,:,275))
  call heltable([18,8,144], n3(:,469), t3x144(:,:,276))
  call heltable([18,8,144], n3(:,470), t3x144(:,:,277))
  call heltable([18,8,144], n3(:,471), t3x144(:,:,278))
  call heltable([18,8,144], n3(:,472), t3x144(:,:,279))
  call heltable([18,8,144], n3(:,473), t3x144(:,:,280))
  call heltable([18,8,144], n3(:,474), t3x144(:,:,281))
  call heltable([18,8,144], n3(:,475), t3x144(:,:,282))
  call heltable([18,8,144], n3(:,476), t3x144(:,:,283))
  call heltable([12,12,144], n3(:,477), t3x144(:,:,284))
  call heltable([12,12,144], n3(:,478), t3x144(:,:,285))
  call heltable([12,12,144], n3(:,479), t3x144(:,:,286))
  call heltable([12,12,144], n3(:,480), t3x144(:,:,287))
  call heltable([12,12,144], n3(:,481), t3x144(:,:,288))
  call heltable([12,12,144], n3(:,482), t3x144(:,:,289))

  heltables_not_init = .false.

end subroutine init_heltables

end module ol_heltables_OLR_ppwwtt_ttxwwxgg_1
