
module ol_external_ppwwtt_ttxbbxwwx_1
  implicit none
  integer :: dummy_counter
  ! Permutation and inverse permutation of external particles
  integer, save :: external_perm_ppwwtt_ttxbbxwwx_1(6) = &
                     [ (dummy_counter, dummy_counter = 1, 6) ]
  integer, save :: external_perm_inv_ppwwtt_ttxbbxwwx_1(6) = &
                     [ (dummy_counter, dummy_counter = 1, 6) ]
  integer, save :: extcomb_perm_ppwwtt_ttxbbxwwx_1(0:22) = &
                     [ (dummy_counter, dummy_counter = 0, 22) ]
  ! Particle types (mapping of fields to integers is not fixed!)
  integer, save :: particle_types_ppwwtt_ttxbbxwwx_1(6) = &
                     [ 1, 2, 3, 4, 5, 6 ]
  ! Colour and helicity average factors per particle
  integer, save :: average_factors_ppwwtt_ttxbbxwwx_1(6) = &
                     [ 6, 6, 6, 6, 3, 3 ]
  ! Average factor; initialised to the identity permutation
  integer, save :: average_factor_ppwwtt_ttxbbxwwx_1 = &
                     36
  integer, save :: channel_number_ppwwtt_ttxbbxwwx_1 = -1
  ! external particle helicities
  logical, save :: hel_not_initialised = .true.
  integer, save :: H(6,144) ! H(i,la) = helicity of particle i in configuration la
  integer, save :: H_HC(144,6)
  integer, save :: POLSEL(6) = 0
  integer, save :: photonid_ppwwtt_ttxbbxwwx_1(6) = 0

  contains

  subroutine n_external(n) &
      & bind(c,name="ol_f_n_external_ppwwtt_ttxbbxwwx_1")
    ! Return the number of external particles
    implicit none
    integer, intent(out) :: n
    n = 6
  end subroutine n_external


  subroutine n_external_c(n) &
      & bind(c,name="ol_n_external_ppwwtt_ttxbbxwwx_1")
    use, intrinsic :: iso_c_binding, only: c_int
    implicit none
    integer(c_int) :: n
    n = 6
  end subroutine n_external_c


  subroutine set_permutation(perm) &
      & bind(c,name="ol_f_set_permutation_ppwwtt_ttxbbxwwx_1")
    use ol_parameters_decl_/**/DREALKIND, only: out_symmetry_on
    use ol_external_decl_/**/DREALKIND, only: n_scatt
    use ol_generic, only: factorial
    implicit none
    integer, intent(in) :: perm(6)
    integer :: i, j, ii, jj
    integer :: particle_types_perm_ppwwtt_ttxbbxwwx_1(6)
    external_perm_ppwwtt_ttxbbxwwx_1 = perm
    do i = 1, 6
      external_perm_inv_ppwwtt_ttxbbxwwx_1( &
        external_perm_ppwwtt_ttxbbxwwx_1(i)) = i
      particle_types_perm_ppwwtt_ttxbbxwwx_1(i) = &
        particle_types_ppwwtt_ttxbbxwwx_1( &
        external_perm_ppwwtt_ttxbbxwwx_1(i))
    end do
    do i = 1, 6
      do j = 1, i
        if (external_perm_ppwwtt_ttxbbxwwx_1(i) >= &
          external_perm_ppwwtt_ttxbbxwwx_1(j)) then
          ii = external_perm_ppwwtt_ttxbbxwwx_1(i)
          jj = external_perm_ppwwtt_ttxbbxwwx_1(j)
        else
          ii = external_perm_ppwwtt_ttxbbxwwx_1(j)
          jj = external_perm_ppwwtt_ttxbbxwwx_1(i)
        end if
        extcomb_perm_ppwwtt_ttxbbxwwx_1((i*(i-1))/2 + j) = (ii*(ii-1))/2 + jj
      end do
    end do
    ! Colour and helicity average factor
    average_factor_ppwwtt_ttxbbxwwx_1 = 1
    do i = 1, n_scatt
      average_factor_ppwwtt_ttxbbxwwx_1 = &
        average_factor_ppwwtt_ttxbbxwwx_1 &
        * average_factors_ppwwtt_ttxbbxwwx_1( &
        external_perm_ppwwtt_ttxbbxwwx_1(i))
    end do
    ! Symmetry factor for outgoing particles
    if (out_symmetry_on /= 0) then
      do i = 1, 6
        average_factor_ppwwtt_ttxbbxwwx_1 = &
          average_factor_ppwwtt_ttxbbxwwx_1 &
          * factorial(count(particle_types_perm_ppwwtt_ttxbbxwwx_1(n_scatt+1:6) == i))
      end do
    end if
  end subroutine set_permutation


  subroutine set_permutation_c(perm) &
      & bind(c,name="ol_set_permutation_ppwwtt_ttxbbxwwx_1")
    use, intrinsic :: iso_c_binding, only: c_int
    implicit none
    integer(c_int), intent(in) :: perm(6)
    integer :: f_perm(6)
    f_perm = perm
    call set_permutation(f_perm)
  end subroutine set_permutation_c


  subroutine get_masses(m_ex) &
      & bind(c,name="ol_f_get_masses_ppwwtt_ttxbbxwwx_1")
    ! Return the masses of the external particles in the current permutation.
    use KIND_TYPES, only: DREALKIND
    use ol_parameters_decl_/**/DREALKIND
    implicit none
    real(DREALKIND), intent(out) :: m_ex(6)
    integer        :: i
    real(DREALKIND) :: m_ex_orig(6)
    ! External particle masses for in the identity permutation
    m_ex_orig = [ rMT_unscaled, rMT_unscaled, rMB_unscaled, rMB_unscaled, rMW_unscaled, rMW_unscaled ]
    do i = 1, 6
      m_ex(i) = m_ex_orig(external_perm_ppwwtt_ttxbbxwwx_1(i))
    end do
  end subroutine get_masses


  subroutine get_masses_c(m_ex) &
      & bind(c,name="ol_get_masses_ppwwtt_ttxbbxwwx_1")
    use KIND_TYPES, only: DREALKIND
    use, intrinsic :: iso_c_binding, only: c_double
    implicit none
    real(c_double), intent(out) :: m_ex(6)
    real(DREALKIND) :: f_m_ex(6)
    call get_masses(f_m_ex)
    m_ex = f_m_ex
  end subroutine get_masses_c


  subroutine rambo(sqrt_s, p_rambo) &
      & bind(c,name="ol_f_rambo_ppwwtt_ttxbbxwwx_1")
    use KIND_TYPES, only: DREALKIND
    use ol_kinematics_/**/DREALKIND, only: rambo_generic => rambo
    implicit none
    real(DREALKIND), intent(in) :: sqrt_s
    real(DREALKIND), intent(out) :: p_rambo(0:3,6)
    real(DREALKIND) :: m_ex(6)
    call get_masses(m_ex)
    call rambo_generic(sqrt_s, m_ex, p_rambo)
  end subroutine rambo


  subroutine rambo_c(sqrt_s, p_rambo) &
      & bind(c,name="ol_rambo_ppwwtt_ttxbbxwwx_1")
    use KIND_TYPES, only: DREALKIND
    use, intrinsic :: iso_c_binding, only: c_double
    implicit none
    real(c_double), intent(in) :: sqrt_s
    real(c_double), intent(out) :: p_rambo(0:3,6)
    real(DREALKIND) :: f_sqrt_s
    real(DREALKIND) :: f_p_rambo(0:3,6)
    f_sqrt_s = sqrt_s
    call rambo(f_sqrt_s, f_p_rambo)
    p_rambo = f_p_rambo
  end subroutine rambo_c


  subroutine hel_init
    implicit none
    integer :: binpos, flip, binco
    hel_not_initialised = .false.
    ! helicity configurations for this process
  H(:,  1) = [ -1, -1, -1, -1, -1, -1 ]
  H(:,  2) = [ -1, -1, -1, -1, -1,  0 ]
  H(:,  3) = [ -1, -1, -1, -1, -1,  1 ]
  H(:,  4) = [ -1, -1, -1, -1,  0, -1 ]
  H(:,  5) = [ -1, -1, -1, -1,  0,  0 ]
  H(:,  6) = [ -1, -1, -1, -1,  0,  1 ]
  H(:,  7) = [ -1, -1, -1, -1,  1, -1 ]
  H(:,  8) = [ -1, -1, -1, -1,  1,  0 ]
  H(:,  9) = [ -1, -1, -1, -1,  1,  1 ]
  H(:, 10) = [ -1, -1, -1,  1, -1, -1 ]
  H(:, 11) = [ -1, -1, -1,  1, -1,  0 ]
  H(:, 12) = [ -1, -1, -1,  1, -1,  1 ]
  H(:, 13) = [ -1, -1, -1,  1,  0, -1 ]
  H(:, 14) = [ -1, -1, -1,  1,  0,  0 ]
  H(:, 15) = [ -1, -1, -1,  1,  0,  1 ]
  H(:, 16) = [ -1, -1, -1,  1,  1, -1 ]
  H(:, 17) = [ -1, -1, -1,  1,  1,  0 ]
  H(:, 18) = [ -1, -1, -1,  1,  1,  1 ]
  H(:, 19) = [ -1, -1,  1, -1, -1, -1 ]
  H(:, 20) = [ -1, -1,  1, -1, -1,  0 ]
  H(:, 21) = [ -1, -1,  1, -1, -1,  1 ]
  H(:, 22) = [ -1, -1,  1, -1,  0, -1 ]
  H(:, 23) = [ -1, -1,  1, -1,  0,  0 ]
  H(:, 24) = [ -1, -1,  1, -1,  0,  1 ]
  H(:, 25) = [ -1, -1,  1, -1,  1, -1 ]
  H(:, 26) = [ -1, -1,  1, -1,  1,  0 ]
  H(:, 27) = [ -1, -1,  1, -1,  1,  1 ]
  H(:, 28) = [ -1, -1,  1,  1, -1, -1 ]
  H(:, 29) = [ -1, -1,  1,  1, -1,  0 ]
  H(:, 30) = [ -1, -1,  1,  1, -1,  1 ]
  H(:, 31) = [ -1, -1,  1,  1,  0, -1 ]
  H(:, 32) = [ -1, -1,  1,  1,  0,  0 ]
  H(:, 33) = [ -1, -1,  1,  1,  0,  1 ]
  H(:, 34) = [ -1, -1,  1,  1,  1, -1 ]
  H(:, 35) = [ -1, -1,  1,  1,  1,  0 ]
  H(:, 36) = [ -1, -1,  1,  1,  1,  1 ]
  H(:, 37) = [ -1,  1, -1, -1, -1, -1 ]
  H(:, 38) = [ -1,  1, -1, -1, -1,  0 ]
  H(:, 39) = [ -1,  1, -1, -1, -1,  1 ]
  H(:, 40) = [ -1,  1, -1, -1,  0, -1 ]
  H(:, 41) = [ -1,  1, -1, -1,  0,  0 ]
  H(:, 42) = [ -1,  1, -1, -1,  0,  1 ]
  H(:, 43) = [ -1,  1, -1, -1,  1, -1 ]
  H(:, 44) = [ -1,  1, -1, -1,  1,  0 ]
  H(:, 45) = [ -1,  1, -1, -1,  1,  1 ]
  H(:, 46) = [ -1,  1, -1,  1, -1, -1 ]
  H(:, 47) = [ -1,  1, -1,  1, -1,  0 ]
  H(:, 48) = [ -1,  1, -1,  1, -1,  1 ]
  H(:, 49) = [ -1,  1, -1,  1,  0, -1 ]
  H(:, 50) = [ -1,  1, -1,  1,  0,  0 ]
  H(:, 51) = [ -1,  1, -1,  1,  0,  1 ]
  H(:, 52) = [ -1,  1, -1,  1,  1, -1 ]
  H(:, 53) = [ -1,  1, -1,  1,  1,  0 ]
  H(:, 54) = [ -1,  1, -1,  1,  1,  1 ]
  H(:, 55) = [ -1,  1,  1, -1, -1, -1 ]
  H(:, 56) = [ -1,  1,  1, -1, -1,  0 ]
  H(:, 57) = [ -1,  1,  1, -1, -1,  1 ]
  H(:, 58) = [ -1,  1,  1, -1,  0, -1 ]
  H(:, 59) = [ -1,  1,  1, -1,  0,  0 ]
  H(:, 60) = [ -1,  1,  1, -1,  0,  1 ]
  H(:, 61) = [ -1,  1,  1, -1,  1, -1 ]
  H(:, 62) = [ -1,  1,  1, -1,  1,  0 ]
  H(:, 63) = [ -1,  1,  1, -1,  1,  1 ]
  H(:, 64) = [ -1,  1,  1,  1, -1, -1 ]
  H(:, 65) = [ -1,  1,  1,  1, -1,  0 ]
  H(:, 66) = [ -1,  1,  1,  1, -1,  1 ]
  H(:, 67) = [ -1,  1,  1,  1,  0, -1 ]
  H(:, 68) = [ -1,  1,  1,  1,  0,  0 ]
  H(:, 69) = [ -1,  1,  1,  1,  0,  1 ]
  H(:, 70) = [ -1,  1,  1,  1,  1, -1 ]
  H(:, 71) = [ -1,  1,  1,  1,  1,  0 ]
  H(:, 72) = [ -1,  1,  1,  1,  1,  1 ]
  H(:, 73) = [  1, -1, -1, -1, -1, -1 ]
  H(:, 74) = [  1, -1, -1, -1, -1,  0 ]
  H(:, 75) = [  1, -1, -1, -1, -1,  1 ]
  H(:, 76) = [  1, -1, -1, -1,  0, -1 ]
  H(:, 77) = [  1, -1, -1, -1,  0,  0 ]
  H(:, 78) = [  1, -1, -1, -1,  0,  1 ]
  H(:, 79) = [  1, -1, -1, -1,  1, -1 ]
  H(:, 80) = [  1, -1, -1, -1,  1,  0 ]
  H(:, 81) = [  1, -1, -1, -1,  1,  1 ]
  H(:, 82) = [  1, -1, -1,  1, -1, -1 ]
  H(:, 83) = [  1, -1, -1,  1, -1,  0 ]
  H(:, 84) = [  1, -1, -1,  1, -1,  1 ]
  H(:, 85) = [  1, -1, -1,  1,  0, -1 ]
  H(:, 86) = [  1, -1, -1,  1,  0,  0 ]
  H(:, 87) = [  1, -1, -1,  1,  0,  1 ]
  H(:, 88) = [  1, -1, -1,  1,  1, -1 ]
  H(:, 89) = [  1, -1, -1,  1,  1,  0 ]
  H(:, 90) = [  1, -1, -1,  1,  1,  1 ]
  H(:, 91) = [  1, -1,  1, -1, -1, -1 ]
  H(:, 92) = [  1, -1,  1, -1, -1,  0 ]
  H(:, 93) = [  1, -1,  1, -1, -1,  1 ]
  H(:, 94) = [  1, -1,  1, -1,  0, -1 ]
  H(:, 95) = [  1, -1,  1, -1,  0,  0 ]
  H(:, 96) = [  1, -1,  1, -1,  0,  1 ]
  H(:, 97) = [  1, -1,  1, -1,  1, -1 ]
  H(:, 98) = [  1, -1,  1, -1,  1,  0 ]
  H(:, 99) = [  1, -1,  1, -1,  1,  1 ]
  H(:,100) = [  1, -1,  1,  1, -1, -1 ]
  H(:,101) = [  1, -1,  1,  1, -1,  0 ]
  H(:,102) = [  1, -1,  1,  1, -1,  1 ]
  H(:,103) = [  1, -1,  1,  1,  0, -1 ]
  H(:,104) = [  1, -1,  1,  1,  0,  0 ]
  H(:,105) = [  1, -1,  1,  1,  0,  1 ]
  H(:,106) = [  1, -1,  1,  1,  1, -1 ]
  H(:,107) = [  1, -1,  1,  1,  1,  0 ]
  H(:,108) = [  1, -1,  1,  1,  1,  1 ]
  H(:,109) = [  1,  1, -1, -1, -1, -1 ]
  H(:,110) = [  1,  1, -1, -1, -1,  0 ]
  H(:,111) = [  1,  1, -1, -1, -1,  1 ]
  H(:,112) = [  1,  1, -1, -1,  0, -1 ]
  H(:,113) = [  1,  1, -1, -1,  0,  0 ]
  H(:,114) = [  1,  1, -1, -1,  0,  1 ]
  H(:,115) = [  1,  1, -1, -1,  1, -1 ]
  H(:,116) = [  1,  1, -1, -1,  1,  0 ]
  H(:,117) = [  1,  1, -1, -1,  1,  1 ]
  H(:,118) = [  1,  1, -1,  1, -1, -1 ]
  H(:,119) = [  1,  1, -1,  1, -1,  0 ]
  H(:,120) = [  1,  1, -1,  1, -1,  1 ]
  H(:,121) = [  1,  1, -1,  1,  0, -1 ]
  H(:,122) = [  1,  1, -1,  1,  0,  0 ]
  H(:,123) = [  1,  1, -1,  1,  0,  1 ]
  H(:,124) = [  1,  1, -1,  1,  1, -1 ]
  H(:,125) = [  1,  1, -1,  1,  1,  0 ]
  H(:,126) = [  1,  1, -1,  1,  1,  1 ]
  H(:,127) = [  1,  1,  1, -1, -1, -1 ]
  H(:,128) = [  1,  1,  1, -1, -1,  0 ]
  H(:,129) = [  1,  1,  1, -1, -1,  1 ]
  H(:,130) = [  1,  1,  1, -1,  0, -1 ]
  H(:,131) = [  1,  1,  1, -1,  0,  0 ]
  H(:,132) = [  1,  1,  1, -1,  0,  1 ]
  H(:,133) = [  1,  1,  1, -1,  1, -1 ]
  H(:,134) = [  1,  1,  1, -1,  1,  0 ]
  H(:,135) = [  1,  1,  1, -1,  1,  1 ]
  H(:,136) = [  1,  1,  1,  1, -1, -1 ]
  H(:,137) = [  1,  1,  1,  1, -1,  0 ]
  H(:,138) = [  1,  1,  1,  1, -1,  1 ]
  H(:,139) = [  1,  1,  1,  1,  0, -1 ]
  H(:,140) = [  1,  1,  1,  1,  0,  0 ]
  H(:,141) = [  1,  1,  1,  1,  0,  1 ]
  H(:,142) = [  1,  1,  1,  1,  1, -1 ]
  H(:,143) = [  1,  1,  1,  1,  1,  0 ]
  H(:,144) = [  1,  1,  1,  1,  1,  1 ]

  end subroutine hel_init


  subroutine pol_init(pol) &
      & bind(c,name="ol_f_pol_init_ppwwtt_ttxbbxwwx_1")
    implicit none
    integer, intent(in) :: pol(6)
    POLSEL = pol
  end subroutine pol_init


  subroutine set_photons(photon_id) &
      & bind(c,name="ol_f_set_photons_ppwwtt_ttxbbxwwx_1")
    implicit none
    integer, intent(in) :: photon_id(6)
    photonid_ppwwtt_ttxbbxwwx_1 = photon_id
  end subroutine set_photons


end module ol_external_ppwwtt_ttxbbxwwx_1


module ol_settings_ppwwtt_ttxbbxwwx_1
  implicit none
  ! Activates optimized helicity bookkeeping. Default=false
    logical, save :: hel_mem_opt = .false.
  ! Calculate loop correlators
    logical, save :: loopcc = .false.

  contains

  subroutine set_hel_mem_opt(set) &
      & bind(c,name="ol_hel_mem_opt_ppwwtt_ttxbbxwwx_1")
    implicit none
    logical, intent(in) :: set
    hel_mem_opt = set
  end subroutine set_hel_mem_opt

  subroutine set_loopcc(set,was) &
      & bind(c,name="ol_loopcc_ppwwtt_ttxbbxwwx_1")
    implicit none
    logical, intent(in) :: set
    logical :: was
    was = loopcc
    loopcc = set
  end subroutine set_loopcc

end module ol_settings_ppwwtt_ttxbbxwwx_1

module colour_basis_ppwwtt_ttxbbxwwx_1
  implicit none
  ! tree colour basis
  integer, save :: extcolours(6) = [1,1,1,1,0,0]
  contains

  pure subroutine tree_colbasis_dim(extcols, ncolb, ncoupl, maxpows, nhel) &
    & bind(c, name="ol_tree_colbasis_dim_ppwwtt_ttxbbxwwx_1")
    implicit none
    ! colour representation of external particles: 0=neutral, 1=fundamental, 2=adjoint
    integer, intent(out) :: extcols(6)
    ! number of tree colour basis elements; number of selected couplings, number of selected powers per coupling
    integer, intent(out) :: ncolb, ncoupl, maxpows
    ! number of helicity configurations (all, not just non-vanishing)
    integer, intent(out) :: nhel
    extcols = extcolours
    ncolb = 2
    ncoupl = 1
    maxpows = 1
    nhel = 144
  end subroutine tree_colbasis_dim

  subroutine tree_colbasis(basis, powers) &
    & bind(c, name="ol_tree_colbasis_ppwwtt_ttxbbxwwx_1")
    implicit none
    integer, intent(out) :: powers(1,1)
    integer, intent(out) :: basis(3,2)
#if 1 > 0
    ! selected powers for each selected coupling
    powers = reshape([4], [1,1])
#endif
#if 2 > 0
    ! tree colour basis: [[composition_number, permutation_number, *coupling_powers], ...]
    basis = reshape( &
      [1,10,2,1,8,2], &
      [3,2])
#endif
  end subroutine tree_colbasis

end module colour_basis_ppwwtt_ttxbbxwwx_1

! **********************************************************************
module ol_heltables_OLR_ppwwtt_ttxbbxwwx_1
! **********************************************************************
  use KIND_TYPES, only: intkind2
  implicit none

  logical :: heltables_not_init = .true.

  ! helicity states of external particles
  ! integer, save :: &
  !   H1(2) = [-1,1], &
  !   H2(3) = [-1,0,1]
  !   ...
  integer, save :: &
    H1(2) = [-1,1], &
    H2(2) = [-1,1], &
    H3(2) = [-1,1], &
    H4(2) = [-1,1], &
    H5(3) = [-1,0,1], &
    H6(3) = [-1,0,1]

  ! number of helicity states for wave functions returned by a propagator call: n2(sz)
  ! number of helicity states for wave functions in a v-point vertex call (v >= 3)
  ! or a contraction (v = 3): n<v>(v,sz)
  integer(intkind2), save :: n2(72), n3(3,283), n4(4,1)

  ! helicity tables used in the construction of the h helicity states of a wave function (amplitude)
  ! from an v-point vertex (contraction): t<v>x<h>(v-1,h,sz)
  integer(intkind2), save :: t3x9(2,9,2), t3x16(2,16,2), t3x4(2,4,4), t3x6(2,6,8), t3x8(2,8,16), t3x12(2,12,16), t3x24(2,24,19), &
    t3x36(2,36,21), t3x18(2,18,40), t3x144(2,144,155), t4x36(3,36,1)

  ! change of global-helicity state resulting from flip of individual-particle helicity
  integer(intkind2), save :: eflip(144,6)
  integer,           save :: exthel(144,6)
  integer,           save :: firstpol(6)

  contains

! **********************************************************************
subroutine init_heltables
! **********************************************************************
  use ol_helicity_init, only: heltable
  implicit none

  ! I/O helicity tables for vertices, propagators and contractions;
  ! helicity table for a vertex call: n_in/n_out are the number helicity states of the incoming/outgoing wave functions
  ! call heltable([<n_in1>, <n_in2>, ..., <n_out>], n, t)
  ! propagators only need the number of helicity configurations which is equal for the incoming and outgoing wave function
  ! n = <n>
  call heltable([2,2,4], n3(:,1), t3x4(:,:,1))
  call heltable([3,2,6], n3(:,2), t3x6(:,:,1))
  call heltable([2,3,6], n3(:,3), t3x6(:,:,2))
  n2(1) = 6
  n2(2) = 6
  call heltable([4,6,24], n3(:,4), t3x24(:,:,1))
  call heltable([4,2,8], n3(:,5), t3x8(:,:,1))
  call heltable([6,3,18], n3(:,6), t3x18(:,:,1))
  n2(3) = 8
  call heltable([2,4,8], n3(:,7), t3x8(:,:,2))
  call heltable([3,6,18], n3(:,8), t3x18(:,:,2))
  n2(4) = 8
  call heltable([3,3,9], n3(:,9), t3x9(:,:,1))
  call heltable([9,2,18], n3(:,10), t3x18(:,:,3))
  call heltable([3,3,9], n3(:,11), t3x9(:,:,2))
  call heltable([2,9,18], n3(:,12), t3x18(:,:,4))
  n2(5) = 9
  call heltable([2,9,18], n3(:,13), t3x18(:,:,5))
  call heltable([2,9,18], n3(:,14), t3x18(:,:,6))
  n2(6) = 18
  call heltable([9,2,18], n3(:,15), t3x18(:,:,7))
  n2(7) = 18
  call heltable([9,2,18], n3(:,16), t3x18(:,:,8))
  n2(8) = 18
  call heltable([3,2,6], n3(:,17), t3x6(:,:,3))
  call heltable([2,3,6], n3(:,18), t3x6(:,:,4))
  call heltable([2,2,4], n3(:,19), t3x4(:,:,2))
  n2(9) = 6
  n2(10) = 6
  call heltable([6,6,36], n3(:,20), t3x36(:,:,1))
  call heltable([2,4,8], n3(:,21), t3x8(:,:,3))
  call heltable([3,6,18], n3(:,22), t3x18(:,:,9))
  n2(11) = 8
  call heltable([4,2,8], n3(:,23), t3x8(:,:,4))
  call heltable([6,3,18], n3(:,24), t3x18(:,:,10))
  n2(12) = 8
  call heltable([9,2,18], n3(:,25), t3x18(:,:,11))
  call heltable([2,9,18], n3(:,26), t3x18(:,:,12))
  call heltable([2,9,18], n3(:,27), t3x18(:,:,13))
  call heltable([2,9,18], n3(:,28), t3x18(:,:,14))
  n2(13) = 18
  call heltable([9,2,18], n3(:,29), t3x18(:,:,15))
  n2(14) = 18
  call heltable([9,2,18], n3(:,30), t3x18(:,:,16))
  n2(15) = 18
  call heltable([2,6,12], n3(:,31), t3x12(:,:,1))
  call heltable([6,2,12], n3(:,32), t3x12(:,:,2))
  call heltable([6,2,12], n3(:,33), t3x12(:,:,3))
  call heltable([2,6,12], n3(:,34), t3x12(:,:,4))
  call heltable([3,3,4,36], n4(:,1), t4x36(:,:,1))
  call heltable([4,4,16], n3(:,35), t3x16(:,:,1))
  call heltable([4,4,16], n3(:,36), t3x16(:,:,2))
  call heltable([4,6,24], n3(:,37), t3x24(:,:,2))
  call heltable([6,3,18], n3(:,38), t3x18(:,:,17))
  call heltable([3,6,18], n3(:,39), t3x18(:,:,18))
  call heltable([2,4,8], n3(:,40), t3x8(:,:,5))
  n2(16) = 18
  call heltable([9,2,18], n3(:,41), t3x18(:,:,19))
  call heltable([2,9,18], n3(:,42), t3x18(:,:,20))
  call heltable([2,9,18], n3(:,43), t3x18(:,:,21))
  call heltable([2,3,6], n3(:,44), t3x6(:,:,5))
  n2(17) = 6
  call heltable([6,3,18], n3(:,45), t3x18(:,:,22))
  call heltable([4,2,8], n3(:,46), t3x8(:,:,6))
  n2(18) = 18
  call heltable([3,2,6], n3(:,47), t3x6(:,:,6))
  n2(19) = 6
  call heltable([4,6,24], n3(:,48), t3x24(:,:,3))
  call heltable([2,9,18], n3(:,49), t3x18(:,:,23))
  call heltable([9,2,18], n3(:,50), t3x18(:,:,24))
  call heltable([9,2,18], n3(:,51), t3x18(:,:,25))
  n2(20) = 18
  n2(21) = 18
  n2(22) = 18
  call heltable([3,6,18], n3(:,52), t3x18(:,:,26))
  call heltable([6,6,36], n3(:,53), t3x36(:,:,2))
  call heltable([3,6,18], n3(:,54), t3x18(:,:,27))
  call heltable([6,3,18], n3(:,55), t3x18(:,:,28))
  call heltable([6,2,12], n3(:,56), t3x12(:,:,5))
  call heltable([2,6,12], n3(:,57), t3x12(:,:,6))
  call heltable([2,6,12], n3(:,58), t3x12(:,:,7))
  call heltable([6,2,12], n3(:,59), t3x12(:,:,8))
  call heltable([2,2,4], n3(:,60), t3x4(:,:,3))
  call heltable([2,4,8], n3(:,61), t3x8(:,:,7))
  n2(23) = 8
  call heltable([4,2,8], n3(:,62), t3x8(:,:,8))
  n2(24) = 8
  call heltable([2,4,8], n3(:,63), t3x8(:,:,9))
  n2(25) = 18
  call heltable([2,3,6], n3(:,64), t3x6(:,:,7))
  n2(26) = 6
  call heltable([6,6,36], n3(:,65), t3x36(:,:,3))
  call heltable([9,2,18], n3(:,66), t3x18(:,:,29))
  call heltable([2,9,18], n3(:,67), t3x18(:,:,30))
  call heltable([2,9,18], n3(:,68), t3x18(:,:,31))
  call heltable([6,3,18], n3(:,69), t3x18(:,:,32))
  call heltable([6,2,12], n3(:,70), t3x12(:,:,9))
  call heltable([2,6,12], n3(:,71), t3x12(:,:,10))
  call heltable([4,2,8], n3(:,72), t3x8(:,:,10))
  n2(27) = 18
  n2(28) = 18
  n2(29) = 18
  n2(30) = 18
  call heltable([2,9,18], n3(:,73), t3x18(:,:,33))
  call heltable([9,2,18], n3(:,74), t3x18(:,:,34))
  call heltable([9,2,18], n3(:,75), t3x18(:,:,35))
  call heltable([3,2,6], n3(:,76), t3x6(:,:,8))
  n2(31) = 6
  call heltable([6,6,36], n3(:,77), t3x36(:,:,4))
  call heltable([3,6,18], n3(:,78), t3x18(:,:,36))
  call heltable([2,6,12], n3(:,79), t3x12(:,:,11))
  call heltable([6,2,12], n3(:,80), t3x12(:,:,12))
  call heltable([2,2,4], n3(:,81), t3x4(:,:,4))
  call heltable([4,6,24], n3(:,82), t3x24(:,:,4))
  call heltable([4,2,8], n3(:,83), t3x8(:,:,11))
  n2(32) = 8
  call heltable([2,4,8], n3(:,84), t3x8(:,:,12))
  n2(33) = 8
  call heltable([6,6,36], n3(:,85), t3x36(:,:,5))
  n2(34) = 4
  call heltable([6,4,24], n3(:,86), t3x24(:,:,5))
  n2(35) = 6
  n2(36) = 24
  n2(37) = 6
  n2(38) = 24
  call heltable([4,2,8], n3(:,87), t3x8(:,:,13))
  n2(39) = 8
  n2(40) = 6
  call heltable([6,3,18], n3(:,88), t3x18(:,:,37))
  call heltable([2,4,8], n3(:,89), t3x8(:,:,14))
  n2(41) = 6
  call heltable([3,6,18], n3(:,90), t3x18(:,:,38))
  n2(42) = 8
  n2(43) = 18
  n2(44) = 18
  n2(45) = 18
  call heltable([6,4,24], n3(:,91), t3x24(:,:,6))
  n2(46) = 6
  n2(47) = 24
  call heltable([4,6,24], n3(:,92), t3x24(:,:,7))
  n2(48) = 6
  n2(49) = 24
  n2(50) = 4
  n2(51) = 6
  call heltable([3,6,18], n3(:,93), t3x18(:,:,39))
  call heltable([2,4,8], n3(:,94), t3x8(:,:,15))
  n2(52) = 8
  call heltable([4,2,8], n3(:,95), t3x8(:,:,16))
  n2(53) = 8
  n2(54) = 6
  call heltable([6,3,18], n3(:,96), t3x18(:,:,40))
  n2(55) = 18
  n2(56) = 18
  n2(57) = 18
  call heltable([6,2,12], n3(:,97), t3x12(:,:,13))
  call heltable([2,6,12], n3(:,98), t3x12(:,:,14))
  n2(58) = 12
  call heltable([6,2,12], n3(:,99), t3x12(:,:,15))
  n2(59) = 12
  n2(60) = 12
  call heltable([2,6,12], n3(:,100), t3x12(:,:,16))
  call heltable([3,8,24], n3(:,101), t3x24(:,:,8))
  n2(61) = 24
  call heltable([8,3,24], n3(:,102), t3x24(:,:,9))
  n2(62) = 24
  call heltable([3,8,24], n3(:,103), t3x24(:,:,10))
  n2(63) = 24
  call heltable([8,3,24], n3(:,104), t3x24(:,:,11))
  n2(64) = 24
  call heltable([2,12,24], n3(:,105), t3x24(:,:,12))
  n2(65) = 24
  call heltable([12,2,24], n3(:,106), t3x24(:,:,13))
  n2(66) = 24
  call heltable([18,2,36], n3(:,107), t3x36(:,:,6))
  call heltable([2,12,24], n3(:,108), t3x24(:,:,14))
  n2(67) = 24
  call heltable([12,2,24], n3(:,109), t3x24(:,:,15))
  n2(68) = 24
  call heltable([2,18,36], n3(:,110), t3x36(:,:,7))
  call heltable([12,2,24], n3(:,111), t3x24(:,:,16))
  n2(69) = 24
  call heltable([2,18,36], n3(:,112), t3x36(:,:,8))
  call heltable([2,12,24], n3(:,113), t3x24(:,:,17))
  n2(70) = 24
  call heltable([12,2,24], n3(:,114), t3x24(:,:,18))
  n2(71) = 24
  call heltable([2,12,24], n3(:,115), t3x24(:,:,19))
  n2(72) = 24
  call heltable([18,2,36], n3(:,116), t3x36(:,:,9))
  call heltable([18,2,36], n3(:,117), t3x36(:,:,10))
  call heltable([18,2,36], n3(:,118), t3x36(:,:,11))
  call heltable([18,2,36], n3(:,119), t3x36(:,:,12))
  call heltable([2,18,36], n3(:,120), t3x36(:,:,13))
  call heltable([2,18,36], n3(:,121), t3x36(:,:,14))
  call heltable([2,18,36], n3(:,122), t3x36(:,:,15))
  call heltable([18,2,36], n3(:,123), t3x36(:,:,16))
  call heltable([18,2,36], n3(:,124), t3x36(:,:,17))
  call heltable([18,2,36], n3(:,125), t3x36(:,:,18))
  call heltable([2,18,36], n3(:,126), t3x36(:,:,19))
  call heltable([2,18,36], n3(:,127), t3x36(:,:,20))
  call heltable([2,18,36], n3(:,128), t3x36(:,:,21))
  call heltable([6,24,144], n3(:,129), t3x144(:,:,1))
  call heltable([18,8,144], n3(:,130), t3x144(:,:,2))
  call heltable([18,8,144], n3(:,131), t3x144(:,:,3))
  call heltable([8,18,144], n3(:,132), t3x144(:,:,4))
  call heltable([8,18,144], n3(:,133), t3x144(:,:,5))
  call heltable([8,18,144], n3(:,134), t3x144(:,:,6))
  call heltable([8,18,144], n3(:,135), t3x144(:,:,7))
  call heltable([8,18,144], n3(:,136), t3x144(:,:,8))
  call heltable([8,18,144], n3(:,137), t3x144(:,:,9))
  call heltable([4,36,144], n3(:,138), t3x144(:,:,10))
  call heltable([18,8,144], n3(:,139), t3x144(:,:,11))
  call heltable([18,8,144], n3(:,140), t3x144(:,:,12))
  call heltable([8,18,144], n3(:,141), t3x144(:,:,13))
  call heltable([8,18,144], n3(:,142), t3x144(:,:,14))
  call heltable([8,18,144], n3(:,143), t3x144(:,:,15))
  call heltable([8,18,144], n3(:,144), t3x144(:,:,16))
  call heltable([8,18,144], n3(:,145), t3x144(:,:,17))
  call heltable([8,18,144], n3(:,146), t3x144(:,:,18))
  call heltable([12,12,144], n3(:,147), t3x144(:,:,19))
  call heltable([12,12,144], n3(:,148), t3x144(:,:,20))
  call heltable([12,12,144], n3(:,149), t3x144(:,:,21))
  call heltable([12,12,144], n3(:,150), t3x144(:,:,22))
  call heltable([4,36,144], n3(:,151), t3x144(:,:,23))
  call heltable([9,16,144], n3(:,152), t3x144(:,:,24))
  call heltable([9,16,144], n3(:,153), t3x144(:,:,25))
  call heltable([6,24,144], n3(:,154), t3x144(:,:,26))
  call heltable([8,18,144], n3(:,155), t3x144(:,:,27))
  call heltable([8,18,144], n3(:,156), t3x144(:,:,28))
  call heltable([8,18,144], n3(:,157), t3x144(:,:,29))
  call heltable([8,18,144], n3(:,158), t3x144(:,:,30))
  call heltable([8,18,144], n3(:,159), t3x144(:,:,31))
  call heltable([8,18,144], n3(:,160), t3x144(:,:,32))
  call heltable([18,8,144], n3(:,161), t3x144(:,:,33))
  call heltable([18,8,144], n3(:,162), t3x144(:,:,34))
  call heltable([18,8,144], n3(:,163), t3x144(:,:,35))
  call heltable([24,6,144], n3(:,164), t3x144(:,:,36))
  call heltable([8,18,144], n3(:,165), t3x144(:,:,37))
  call heltable([8,18,144], n3(:,166), t3x144(:,:,38))
  call heltable([6,24,144], n3(:,167), t3x144(:,:,39))
  call heltable([8,18,144], n3(:,168), t3x144(:,:,40))
  call heltable([8,18,144], n3(:,169), t3x144(:,:,41))
  call heltable([8,18,144], n3(:,170), t3x144(:,:,42))
  call heltable([8,18,144], n3(:,171), t3x144(:,:,43))
  call heltable([8,18,144], n3(:,172), t3x144(:,:,44))
  call heltable([8,18,144], n3(:,173), t3x144(:,:,45))
  call heltable([8,18,144], n3(:,174), t3x144(:,:,46))
  call heltable([4,36,144], n3(:,175), t3x144(:,:,47))
  call heltable([8,18,144], n3(:,176), t3x144(:,:,48))
  call heltable([8,18,144], n3(:,177), t3x144(:,:,49))
  call heltable([12,12,144], n3(:,178), t3x144(:,:,50))
  call heltable([12,12,144], n3(:,179), t3x144(:,:,51))
  call heltable([12,12,144], n3(:,180), t3x144(:,:,52))
  call heltable([12,12,144], n3(:,181), t3x144(:,:,53))
  call heltable([12,12,144], n3(:,182), t3x144(:,:,54))
  call heltable([12,12,144], n3(:,183), t3x144(:,:,55))
  call heltable([12,12,144], n3(:,184), t3x144(:,:,56))
  call heltable([12,12,144], n3(:,185), t3x144(:,:,57))
  call heltable([36,4,144], n3(:,186), t3x144(:,:,58))
  call heltable([18,8,144], n3(:,187), t3x144(:,:,59))
  call heltable([18,8,144], n3(:,188), t3x144(:,:,60))
  call heltable([18,8,144], n3(:,189), t3x144(:,:,61))
  call heltable([18,8,144], n3(:,190), t3x144(:,:,62))
  call heltable([18,8,144], n3(:,191), t3x144(:,:,63))
  call heltable([18,8,144], n3(:,192), t3x144(:,:,64))
  call heltable([18,8,144], n3(:,193), t3x144(:,:,65))
  call heltable([18,8,144], n3(:,194), t3x144(:,:,66))
  call heltable([8,18,144], n3(:,195), t3x144(:,:,67))
  call heltable([4,36,144], n3(:,196), t3x144(:,:,68))
  call heltable([8,18,144], n3(:,197), t3x144(:,:,69))
  call heltable([8,18,144], n3(:,198), t3x144(:,:,70))
  call heltable([8,18,144], n3(:,199), t3x144(:,:,71))
  call heltable([18,8,144], n3(:,200), t3x144(:,:,72))
  call heltable([18,8,144], n3(:,201), t3x144(:,:,73))
  call heltable([18,8,144], n3(:,202), t3x144(:,:,74))
  call heltable([8,18,144], n3(:,203), t3x144(:,:,75))
  call heltable([12,12,144], n3(:,204), t3x144(:,:,76))
  call heltable([12,12,144], n3(:,205), t3x144(:,:,77))
  call heltable([12,12,144], n3(:,206), t3x144(:,:,78))
  call heltable([12,12,144], n3(:,207), t3x144(:,:,79))
  call heltable([8,18,144], n3(:,208), t3x144(:,:,80))
  call heltable([8,18,144], n3(:,209), t3x144(:,:,81))
  call heltable([8,18,144], n3(:,210), t3x144(:,:,82))
  call heltable([8,18,144], n3(:,211), t3x144(:,:,83))
  call heltable([8,18,144], n3(:,212), t3x144(:,:,84))
  call heltable([8,18,144], n3(:,213), t3x144(:,:,85))
  call heltable([8,18,144], n3(:,214), t3x144(:,:,86))
  call heltable([4,36,144], n3(:,215), t3x144(:,:,87))
  call heltable([8,18,144], n3(:,216), t3x144(:,:,88))
  call heltable([12,12,144], n3(:,217), t3x144(:,:,89))
  call heltable([12,12,144], n3(:,218), t3x144(:,:,90))
  call heltable([12,12,144], n3(:,219), t3x144(:,:,91))
  call heltable([12,12,144], n3(:,220), t3x144(:,:,92))
  call heltable([6,24,144], n3(:,221), t3x144(:,:,93))
  call heltable([18,8,144], n3(:,222), t3x144(:,:,94))
  call heltable([18,8,144], n3(:,223), t3x144(:,:,95))
  call heltable([18,8,144], n3(:,224), t3x144(:,:,96))
  call heltable([18,8,144], n3(:,225), t3x144(:,:,97))
  call heltable([18,8,144], n3(:,226), t3x144(:,:,98))
  call heltable([18,8,144], n3(:,227), t3x144(:,:,99))
  call heltable([18,8,144], n3(:,228), t3x144(:,:,100))
  call heltable([18,8,144], n3(:,229), t3x144(:,:,101))
  call heltable([36,4,144], n3(:,230), t3x144(:,:,102))
  call heltable([6,24,144], n3(:,231), t3x144(:,:,103))
  call heltable([6,24,144], n3(:,232), t3x144(:,:,104))
  call heltable([18,8,144], n3(:,233), t3x144(:,:,105))
  call heltable([18,8,144], n3(:,234), t3x144(:,:,106))
  call heltable([8,18,144], n3(:,235), t3x144(:,:,107))
  call heltable([18,8,144], n3(:,236), t3x144(:,:,108))
  call heltable([8,18,144], n3(:,237), t3x144(:,:,109))
  call heltable([18,8,144], n3(:,238), t3x144(:,:,110))
  call heltable([18,8,144], n3(:,239), t3x144(:,:,111))
  call heltable([18,8,144], n3(:,240), t3x144(:,:,112))
  call heltable([18,8,144], n3(:,241), t3x144(:,:,113))
  call heltable([18,8,144], n3(:,242), t3x144(:,:,114))
  call heltable([18,8,144], n3(:,243), t3x144(:,:,115))
  call heltable([18,8,144], n3(:,244), t3x144(:,:,116))
  call heltable([18,8,144], n3(:,245), t3x144(:,:,117))
  call heltable([18,8,144], n3(:,246), t3x144(:,:,118))
  call heltable([18,8,144], n3(:,247), t3x144(:,:,119))
  call heltable([8,18,144], n3(:,248), t3x144(:,:,120))
  call heltable([8,18,144], n3(:,249), t3x144(:,:,121))
  call heltable([8,18,144], n3(:,250), t3x144(:,:,122))
  call heltable([6,24,144], n3(:,251), t3x144(:,:,123))
  call heltable([6,24,144], n3(:,252), t3x144(:,:,124))
  call heltable([36,4,144], n3(:,253), t3x144(:,:,125))
  call heltable([8,18,144], n3(:,254), t3x144(:,:,126))
  call heltable([18,8,144], n3(:,255), t3x144(:,:,127))
  call heltable([18,8,144], n3(:,256), t3x144(:,:,128))
  call heltable([18,8,144], n3(:,257), t3x144(:,:,129))
  call heltable([18,8,144], n3(:,258), t3x144(:,:,130))
  call heltable([8,18,144], n3(:,259), t3x144(:,:,131))
  call heltable([18,8,144], n3(:,260), t3x144(:,:,132))
  call heltable([18,8,144], n3(:,261), t3x144(:,:,133))
  call heltable([18,8,144], n3(:,262), t3x144(:,:,134))
  call heltable([8,18,144], n3(:,263), t3x144(:,:,135))
  call heltable([8,18,144], n3(:,264), t3x144(:,:,136))
  call heltable([8,18,144], n3(:,265), t3x144(:,:,137))
  call heltable([18,8,144], n3(:,266), t3x144(:,:,138))
  call heltable([18,8,144], n3(:,267), t3x144(:,:,139))
  call heltable([18,8,144], n3(:,268), t3x144(:,:,140))
  call heltable([18,8,144], n3(:,269), t3x144(:,:,141))
  call heltable([18,8,144], n3(:,270), t3x144(:,:,142))
  call heltable([18,8,144], n3(:,271), t3x144(:,:,143))
  call heltable([12,12,144], n3(:,272), t3x144(:,:,144))
  call heltable([12,12,144], n3(:,273), t3x144(:,:,145))
  call heltable([12,12,144], n3(:,274), t3x144(:,:,146))
  call heltable([12,12,144], n3(:,275), t3x144(:,:,147))
  call heltable([12,12,144], n3(:,276), t3x144(:,:,148))
  call heltable([12,12,144], n3(:,277), t3x144(:,:,149))
  call heltable([12,12,144], n3(:,278), t3x144(:,:,150))
  call heltable([12,12,144], n3(:,279), t3x144(:,:,151))
  call heltable([12,12,144], n3(:,280), t3x144(:,:,152))
  call heltable([12,12,144], n3(:,281), t3x144(:,:,153))
  call heltable([12,12,144], n3(:,282), t3x144(:,:,154))
  call heltable([12,12,144], n3(:,283), t3x144(:,:,155))

  heltables_not_init = .false.

end subroutine init_heltables

end module ol_heltables_OLR_ppwwtt_ttxbbxwwx_1
