
module ol_vamp_1_ppww_uuxwwx_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppww_uuxwwx_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppww_uuxwwx_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_ppww_uuxwwx_1_/**/DREALKIND
  use ol_tensor_sum_storage_ppww_uuxwwx_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red

  use ol_loop_storage_ppww_uuxwwx_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_ppww_uuxwwx_1_/**/DREALKIND, only: ntryL, p_switch, Hel
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(36)
  type(Hpolcont), intent(in) :: M(1,36)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

Gcoeff(:)%j = (c(2)*M(1,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1),h0tab(:,1),[8,2,1,4],[0,0,0,0],4,0)
  call Hloop_QW_A(ntryL,G0H36(1),ex4(:),G0H12(1),m3h3x12(:,1),heltab2x36(:,:,1))
  call Hloop_Q_A(ntryL,G0H12(1),8,0,G1H12(1),n2h12(1))
  call Hloop_QA_V(ntryL,G1H12(1),ex2(:),G1H6(1),m3h2x6(:,1),heltab2x12(:,:,1))
  call Hloop_VQ_A(ntryL,G1H6(1),ex1(:),G1H3(1),m3h2x3(:,1),heltab2x6(:,:,1))
  call Hloop_Q_A(ntryL,G1H3(1),11,0,G2H3(1),n2h3(1))
call Hotf_4pt_reduction(G2H3(1),RedSet_4(1),mass4set(:,1),  & 
G1H3(1),G1H3(2),G1H3(3),G1H3(4),G1H3(5),3)
call HG1shiftOLR(G1H3(2),4,3)
  call Hloop_QW_A(ntryL,G1H3(1),ex3(:),G1H1(1),m3h3x1(:,1),heltab2x3(:,:,1))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,0,G2tensor(1),n2h1(1))
  call Hloop_QW_A(ntryL,G1H3(2),ex3(:),G1H1(1),m3h3x1(:,2),heltab2x3(:,:,2))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(2),n2h1(2))
  call Hloop_QW_A(ntryL,G1H3(5),ex3(:),G1H1(1),m3h3x1(:,3),heltab2x3(:,:,3))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,0,G2tensor(3),n2h1(3))
call Hotf_4pt_reduction_last(G2tensor(1),RedSet_4(1),mass4set(:,1),  & 
G1tensor(1),G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(5))
call G_TensorShift(G1tensor(2),4)
call Hotf_4pt_reduction_last(G1tensor(1),RedSet_4(1),mass4set(:,1),  & 
G0tensor(1),G0tensor(2),G0tensor(3),G0tensor(4),G0tensor(5))
call ol_merge_tensors(T0sum(1),[G0tensor(1)])
Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(3)
call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(2),h0tab(:,2),[8,2,5],[0,0,0],3,1,wf6(:,3))
  call Hloop_QW_A(ntryL,G0H36(1),ex4(:),G0H12(1),m3h3x12(:,2),heltab2x36(:,:,2))
  call Hloop_Q_A(ntryL,G0H12(1),8,0,G1H12(1),n2h12(2))
Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(4)
call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(3),h0tab(:,3),[10,1,4],[0,0,0],3,1,wf6(:,6))
  call Hloop_QA_V(ntryL,G0H36(1),wf6(:,6),G0H6(1),m3h6x6(:,1),heltab2x36(:,:,3))
Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(5)
call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(4),h0tab(:,4),[12,1,2],[0,0,0],3,1,wf9(:,1))
  call Hloop_AV_Q(ntryL,G0H36(1),wf9(:,1),G0H4(1),m3h9x4(:,1),heltab2x36(:,:,4))
  call Hloop_A_Q(ntryL,G0H4(1),12,0,G1H4(1),n2h4(1))
Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(6)
call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(5),h0tab(:,5),[12,1,2],[0,0,0],3,1,wf9(:,2))
  call Hloop_AZ_Q(ntryL,G0H36(1),wf9(:,2),G0H4(1),ngZu,m3h9x4(:,2),heltab2x36(:,:,5))
  call Hloop_A_Q(ntryL,G0H4(1),12,0,G1H4(2),n2h4(2))
  call ol_merge(ntryL,G1H4(2),[G1H4(1)])
  call Hloop_QA_V(ntryL,G1H12(1),ex2(:),G1H6(1),m3h2x6(:,2),heltab2x12(:,:,2))
  call Hloop_VQ_A(ntryL,G0H6(1),ex1(:),G0H3(1),m3h2x3(:,2),heltab2x6(:,:,2))
  call Hloop_Q_A(ntryL,G0H3(1),11,0,G1H3(1),n2h3(2))
  call Hloop_AQ_V(ntryL,G1H4(2),ex1(:),G1H2(1),m3h2x2(:,1),heltab2x4(:,:,1))
  call ol_merge(ntryL,G1H3(1),[G1H3(3)])
  call Hloop_QW_A(ntryL,G1H3(1),ex3(:),G1H1(1),m3h3x1(:,4),heltab2x3(:,:,4))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,0,G2tensor(1),n2h1(4))
  call Hloop_QW_A(ntryL,G1H3(4),ex3(:),G1H1(1),m3h3x1(:,5),heltab2x3(:,:,5))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,0,G2tensor(4),n2h1(5))
  call Hloop_VQ_A(ntryL,G1H6(1),wf6(:,3),G1H1(1),m3h6x1(:,1),heltab2x6(:,:,3))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,0,G2tensor(5),n2h1(6))
  call Hloop_VA_Q(ntryL,G1H2(1),ex2(:),G1H1(1),m3h2x1(:,1),heltab2x2(:,:,1))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,0,G2tensor(6),n2h1(7))
  call ol_merge_tensors(G2tensor(2),[G1tensor(2),G0tensor(2)])
  call ol_merge_tensors(G2tensor(5),[G2tensor(3),G1tensor(5),G0tensor(5)])
  call ol_merge_tensors(G2tensor(1),[G1tensor(3),G0tensor(3)])
  call ol_merge_tensors(G2tensor(4),[G1tensor(4),G0tensor(4)])
call TI_triangle_red(G2tensor(2),RedBasis(4),mass3set(:,1),G0tensor(1),G0tensor(2),G0tensor(5),G0tensor(3),M2L1R1)
call TI_triangle_red(G2tensor(5),RedBasis(1),mass3set(:,1),G0tensor(4),G0tensor(6),G0tensor(7),G0tensor(8),M2L1R1)
call TI_triangle_red(G2tensor(1),RedBasis(3),mass3set(:,1),G0tensor(9),G0tensor(10),G0tensor(11),G0tensor(12),M2L1R1)
call TI_triangle_red(G2tensor(4),RedBasis(2),mass3set(:,1),G0tensor(13),G0tensor(14),G0tensor(15),G0tensor(16),M2L1R1)
call TI_triangle_red(G2tensor(6),RedBasis(5),mass3set(:,1),G0tensor(17),G0tensor(18),G0tensor(19),G0tensor(20),M2L1R1)
call ol_merge_tensors(T0sum(2),[G0tensor(1)])
call ol_merge_tensors(T0sum(3),[G0tensor(4)])
call ol_merge_tensors(T0sum(4),[G0tensor(9)])
call ol_merge_tensors(T0sum(5),[G0tensor(13)])
call ol_merge_tensors(T0sum(6),[G0tensor(17)])
Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(7)
call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(6),h0tab(:,6),[10,5],[0,0],2,2,wf6(:,6),wf6(:,3))
  call Hloop_VA_Q(ntryL,G0H36(1),wf6(:,6),G0H6(1),m3h6x6(:,2),heltab2x36(:,:,6))
  call Hloop_A_Q(ntryL,G0H6(1),10,0,G1H6(1),n2h6(1))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H6(1),wf6(:,3),G1tensor(1),m3h6x1(:,2),heltab2x6(:,:,4))
  call ol_merge_tensors(G0tensor(19),[G0tensor(6),G0tensor(2)])
  call ol_merge_tensors(G0tensor(18),[G0tensor(10),G0tensor(5)])
  call ol_merge_tensors(G0tensor(20),[G0tensor(14),G0tensor(3)])
  call ol_merge_tensors(G1tensor(1),[G0tensor(12),G0tensor(7)])
  call ol_merge_tensors(G0tensor(16),[G0tensor(8)])
  call ol_merge_tensors(G0tensor(15),[G0tensor(11)])
call TI_bubble_red(G1tensor(1),10,mass2set(:,1),G0tensor(1),M2L1R1)
call ol_merge_tensors(T0sum(7),[G0tensor(19)])
call ol_merge_tensors(T0sum(8),[G0tensor(18)])
call ol_merge_tensors(T0sum(9),[G0tensor(20)])
call ol_merge_tensors(T0sum(10),[G0tensor(1)])
call ol_merge_tensors(T0sum(11),[G0tensor(16)])
call ol_merge_tensors(T0sum(12),[G0tensor(15)])
! end of process


end subroutine vamp_1

end module ol_vamp_1_ppww_uuxwwx_1_/**/REALKIND
