
module ol_vamp_3_ppwttj_ew_uttxdxwg_3_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_3(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppwttj_ew_uttxdxwg_3.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppwttj_ew_uttxdxwg_3.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_ppwttj_ew_uttxdxwg_3_/**/DREALKIND
  use ol_tensor_sum_storage_ppwttj_ew_uttxdxwg_3_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_ppwttj_ew_uttxdxwg_3_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_ppwttj_ew_uttxdxwg_3_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL, hel_states
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(hel_states)
  type(Hpolcont), intent(in) :: M(6,hel_states)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel(1:hel_states)
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel(1:hel_states)
#endif

  ! =============================================
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(264),n2h48(405))
  Gcoeff(:)%j = (c(169)*M(1,:)%j-c(168)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(441),h0tab(:,441),[32,2,17,8,4],[nMT,0,0,0,nMT],5,1,wf6(:,2))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,441),heltab2x96(:,:,441))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(265),n2h48(406))
  Gcoeff(:)%j = (c(179)*M(2,:)%j-c(180)*M(6,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(442),h0tab(:,442),[32,2,17,8,4],[nMT,nMZ,0,0,nMT],5,1,wf6(:,2))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,442),heltab2x96(:,:,442))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(266),n2h48(407))
  Gcoeff(:)%j = (-(c(180)*M(1,:)%j)+c(179)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(443),h0tab(:,443),[32,2,17,8,4],[nMT,0,0,nMZ,nMT],5,1,wf6(:,2))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,443),heltab2x96(:,:,443))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(267),n2h48(408))
  Gcoeff(:)%j = (-(c(107)*M(3,:)%j)) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(444),h0tab(:,444),[32,4,1,8,18],[nMT,0,0,nMW,nMT],5,1,wf6(:,6))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,444),heltab2x96(:,:,444))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(268),n2h48(409))
  Gcoeff(:)%j = (-(c(104)*M(3,:)%j)) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(445),h0tab(:,445),[32,4,1,8,18],[nMB,nMW,0,0,nMB],5,1,wf6(:,6))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,445),heltab2x96(:,:,445))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMB,G1H48(269),n2h48(410))
  Gcoeff(:)%j = (-(c(109)*M(3,:)%j)) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(446),h0tab(:,446),[32,4,1,8,18],[nMT,nMZ,0,nMW,nMT],5,1,wf6(:,6))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,446),heltab2x96(:,:,446))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(270),n2h48(411))
  Gcoeff(:)%j = (-(c(109)*M(3,:)%j)) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(447),h0tab(:,447),[32,4,1,8,18],[nMB,nMW,0,nMZ,nMB],5,1,wf6(:,6))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,447),heltab2x96(:,:,447))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMB,G1H48(271),n2h48(412))
  Gcoeff(:)%j = (c(112)*M(2,:)%j-c(113)*M(6,:)%j) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(448),h0tab(:,448),[32,4,1,8,18],[nMT,0,0,nMW,nMT],5,1,wf6(:,6))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,448),heltab2x96(:,:,448))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(272),n2h48(413))
  Gcoeff(:)%j = (-(c(113)*M(1,:)%j)+c(112)*M(2,:)%j) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(449),h0tab(:,449),[32,4,1,8,18],[nMB,nMW,0,0,nMB],5,1,wf6(:,6))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,449),heltab2x96(:,:,449))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMB,G1H48(273),n2h48(414))
  Gcoeff(:)%j = (c(110)*(M(1,:)%j-M(6,:)%j)) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(450),h0tab(:,450),[32,8,1,4,18],[0,0,nMW,nMB,0],5,1,wf6(:,6))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(274),m3h2x48(:,450),heltab2x96(:,:,450))
  Gcoeff(:)%j = (-(c(107)*M(5,:)%j)) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(451),h0tab(:,451),[32,1,4,18,8],[0,0,nMT,nMW,0],5,1,wf6(:,6))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,451),heltab2x96(:,:,451))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(275),n2h48(415))
  Gcoeff(:)%j = (-(c(104)*M(5,:)%j)) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(452),h0tab(:,452),[32,1,4,18,8],[0,nMW,nMB,0,0],5,1,wf6(:,6))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,452),heltab2x96(:,:,452))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(276),n2h48(416))
  Gcoeff(:)%j = (-(c(109)*M(5,:)%j)) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(453),h0tab(:,453),[32,1,4,18,8],[0,nMZ,nMT,nMW,0],5,1,wf6(:,6))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,453),heltab2x96(:,:,453))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(277),n2h48(417))
  Gcoeff(:)%j = (-(c(109)*M(5,:)%j)) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(454),h0tab(:,454),[32,1,4,18,8],[0,nMW,nMB,nMZ,0],5,1,wf6(:,6))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,454),heltab2x96(:,:,454))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(278),n2h48(418))
  Gcoeff(:)%j = (c(112)*M(4,:)%j-c(113)*M(6,:)%j) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(455),h0tab(:,455),[32,1,4,18,8],[0,0,nMT,nMW,0],5,1,wf6(:,6))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,455),heltab2x96(:,:,455))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(279),n2h48(419))
  Gcoeff(:)%j = (-(c(113)*M(1,:)%j)+c(112)*M(4,:)%j) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(456),h0tab(:,456),[32,1,4,18,8],[0,nMW,nMB,0,0],5,1,wf6(:,6))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,456),heltab2x96(:,:,456))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(280),n2h48(420))
  Gcoeff(:)%j = (c(110)*(M(1,:)%j-M(6,:)%j)) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(457),h0tab(:,457),[32,1,8,4,18],[0,0,nMW,nMB,0],5,1,wf6(:,6))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(281),m3h2x48(:,457),heltab2x96(:,:,457))
  Gcoeff(:)%j = (c(110)*(M(1,:)%j-M(6,:)%j)) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(458),h0tab(:,458),[32,1,8,18,4],[0,0,nMW,nMT,0],5,1,wf6(:,6))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(282),m3h2x48(:,458),heltab2x96(:,:,458))
  Gcoeff(:)%j = (c(105)*M(3,:)%j) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(459),h0tab(:,459),[32,4,8,1,18],[nMT,0,0,nMW,nMT],5,1,wf6(:,6))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,459),heltab2x96(:,:,459))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(283),n2h48(421))
  Gcoeff(:)%j = (c(105)*M(3,:)%j) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(460),h0tab(:,460),[32,4,8,1,18],[nMB,nMW,0,0,nMB],5,1,wf6(:,6))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,460),heltab2x96(:,:,460))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMB,G1H48(284),n2h48(422))
  Gcoeff(:)%j = (-(c(109)*M(3,:)%j)) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(461),h0tab(:,461),[32,4,8,1,18],[nMT,nMZ,0,nMW,nMT],5,1,wf6(:,6))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,461),heltab2x96(:,:,461))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(285),n2h48(423))
  Gcoeff(:)%j = (-(c(109)*M(3,:)%j)) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(462),h0tab(:,462),[32,4,8,1,18],[nMB,nMW,0,nMZ,nMB],5,1,wf6(:,6))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,462),heltab2x96(:,:,462))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMB,G1H48(286),n2h48(424))
  Gcoeff(:)%j = (c(112)*M(2,:)%j-c(113)*M(6,:)%j) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(463),h0tab(:,463),[32,4,8,1,18],[nMT,0,0,nMW,nMT],5,1,wf6(:,6))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,463),heltab2x96(:,:,463))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(287),n2h48(425))
  Gcoeff(:)%j = (-(c(113)*M(1,:)%j)+c(112)*M(2,:)%j) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(464),h0tab(:,464),[32,4,8,1,18],[nMB,nMW,0,0,nMB],5,1,wf6(:,6))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,464),heltab2x96(:,:,464))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMB,G1H48(288),n2h48(426))
  Gcoeff(:)%j = (c(110)*(-M(1,:)%j+M(6,:)%j)) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(465),h0tab(:,465),[32,4,18,1,8],[0,nMT,nMW,0,0],5,1,wf6(:,6))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(289),m3h2x48(:,465),heltab2x96(:,:,465))
  Gcoeff(:)%j = (c(105)*M(5,:)%j) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(466),h0tab(:,466),[32,1,18,4,8],[0,0,nMB,nMW,0],5,1,wf6(:,6))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,466),heltab2x96(:,:,466))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(290),n2h48(427))
  Gcoeff(:)%j = (c(105)*M(5,:)%j) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(467),h0tab(:,467),[32,1,18,4,8],[0,nMW,nMT,0,0],5,1,wf6(:,6))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,467),heltab2x96(:,:,467))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(291),n2h48(428))
  Gcoeff(:)%j = (-(c(109)*M(5,:)%j)) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(468),h0tab(:,468),[32,1,18,4,8],[0,nMZ,nMB,nMW,0],5,1,wf6(:,6))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,468),heltab2x96(:,:,468))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(292),n2h48(429))
  Gcoeff(:)%j = (-(c(109)*M(5,:)%j)) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(469),h0tab(:,469),[32,1,18,4,8],[0,nMW,nMT,nMZ,0],5,1,wf6(:,6))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,469),heltab2x96(:,:,469))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(293),n2h48(430))
  Gcoeff(:)%j = (c(112)*M(4,:)%j-c(113)*M(6,:)%j) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(470),h0tab(:,470),[32,1,18,4,8],[0,0,nMB,nMW,0],5,1,wf6(:,6))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,470),heltab2x96(:,:,470))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(294),n2h48(431))
  Gcoeff(:)%j = (-(c(113)*M(1,:)%j)+c(112)*M(4,:)%j) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(471),h0tab(:,471),[32,1,18,4,8],[0,nMW,nMT,0,0],5,1,wf6(:,6))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,471),heltab2x96(:,:,471))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(295),n2h48(432))
  Gcoeff(:)%j = (-(c(149)*M(5,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(472),h0tab(:,472),[32,1,2,4,24],[0,0,nMT,0,0],5,1,wf6(:,4))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,472),heltab2x96(:,:,472))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(296),n2h48(433))
  Gcoeff(:)%j = (-(c(153)*M(5,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(473),h0tab(:,473),[32,1,2,4,24],[0,0,nMT,nMZ,0],5,1,wf6(:,4))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,473),heltab2x96(:,:,473))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(297),n2h48(434))
  Gcoeff(:)%j = (-(c(153)*M(5,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(474),h0tab(:,474),[32,1,2,4,24],[0,nMZ,nMT,0,0],5,1,wf6(:,4))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,474),heltab2x96(:,:,474))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(298),n2h48(435))
  Gcoeff(:)%j = (-(c(155)*M(5,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(475),h0tab(:,475),[32,1,2,4,24],[0,nMZ,nMT,nMZ,0],5,1,wf6(:,4))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,475),heltab2x96(:,:,475))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(299),n2h48(436))
  Gcoeff(:)%j = (-(c(174)*M(1,:)%j)+c(173)*M(4,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(476),h0tab(:,476),[32,1,2,4,24],[0,0,nMT,0,0],5,1,wf6(:,4))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,476),heltab2x96(:,:,476))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(300),n2h48(437))
  Gcoeff(:)%j = (c(173)*M(4,:)%j-c(174)*M(6,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(477),h0tab(:,477),[32,1,2,4,24],[0,0,nMT,0,0],5,1,wf6(:,4))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,477),heltab2x96(:,:,477))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(301),n2h48(438))
  Gcoeff(:)%j = (-(c(180)*M(1,:)%j)+c(179)*M(4,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(478),h0tab(:,478),[32,1,2,4,24],[0,nMZ,nMT,0,0],5,1,wf6(:,4))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,478),heltab2x96(:,:,478))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(302),n2h48(439))
  Gcoeff(:)%j = (c(179)*M(4,:)%j-c(180)*M(6,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(479),h0tab(:,479),[32,1,2,4,24],[0,0,nMT,nMZ,0],5,1,wf6(:,4))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,479),heltab2x96(:,:,479))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(303),n2h48(440))
  Gcoeff(:)%j = (c(160)*(-M(1,:)%j+M(6,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(480),h0tab(:,480),[32,4,2,1,24],[0,nMT,0,0,0],5,1,wf6(:,4))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(304),m3h2x48(:,480),heltab2x96(:,:,480))
  Gcoeff(:)%j = (c(164)*(-M(1,:)%j+M(6,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(481),h0tab(:,481),[32,4,2,1,24],[0,nMT,nMZ,0,0],5,1,wf6(:,4))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(305),m3h2x48(:,481),heltab2x96(:,:,481))
  Gcoeff(:)%j = (-(c(149)*M(3,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(482),h0tab(:,482),[32,2,1,24,4],[nMT,0,0,0,nMT],5,1,wf6(:,4))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,482),heltab2x96(:,:,482))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(306),n2h48(441))
  Gcoeff(:)%j = (-(c(153)*M(3,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(483),h0tab(:,483),[32,2,1,24,4],[nMT,0,0,nMZ,nMT],5,1,wf6(:,4))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,483),heltab2x96(:,:,483))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(307),n2h48(442))
  Gcoeff(:)%j = (-(c(153)*M(3,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(484),h0tab(:,484),[32,2,1,24,4],[nMT,nMZ,0,0,nMT],5,1,wf6(:,4))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,484),heltab2x96(:,:,484))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(308),n2h48(443))
  Gcoeff(:)%j = (-(c(155)*M(3,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(485),h0tab(:,485),[32,2,1,24,4],[nMT,nMZ,0,nMZ,nMT],5,1,wf6(:,4))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,485),heltab2x96(:,:,485))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(309),n2h48(444))
  Gcoeff(:)%j = (c(173)*M(2,:)%j-c(174)*M(6,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(486),h0tab(:,486),[32,2,1,24,4],[nMT,0,0,0,nMT],5,1,wf6(:,4))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,486),heltab2x96(:,:,486))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(310),n2h48(445))
  Gcoeff(:)%j = (-(c(174)*M(1,:)%j)+c(173)*M(2,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(487),h0tab(:,487),[32,2,1,24,4],[nMT,0,0,0,nMT],5,1,wf6(:,4))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,487),heltab2x96(:,:,487))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(311),n2h48(446))
  Gcoeff(:)%j = (c(179)*M(2,:)%j-c(180)*M(6,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(488),h0tab(:,488),[32,2,1,24,4],[nMT,nMZ,0,0,nMT],5,1,wf6(:,4))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,488),heltab2x96(:,:,488))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(312),n2h48(447))
  Gcoeff(:)%j = (-(c(180)*M(1,:)%j)+c(179)*M(2,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(489),h0tab(:,489),[32,2,1,24,4],[nMT,0,0,nMZ,nMT],5,1,wf6(:,4))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,489),heltab2x96(:,:,489))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(313),n2h48(448))
  Gcoeff(:)%j = (-(c(149)*M(5,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(490),h0tab(:,490),[32,1,4,2,24],[0,0,nMT,0,0],5,1,wf6(:,4))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,490),heltab2x96(:,:,490))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(314),n2h48(449))
  Gcoeff(:)%j = (-(c(153)*M(5,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(491),h0tab(:,491),[32,1,4,2,24],[0,0,nMT,nMZ,0],5,1,wf6(:,4))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,491),heltab2x96(:,:,491))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(315),n2h48(450))
  Gcoeff(:)%j = (-(c(153)*M(5,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(492),h0tab(:,492),[32,1,4,2,24],[0,nMZ,nMT,0,0],5,1,wf6(:,4))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,492),heltab2x96(:,:,492))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(316),n2h48(451))
  Gcoeff(:)%j = (-(c(155)*M(5,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(493),h0tab(:,493),[32,1,4,2,24],[0,nMZ,nMT,nMZ,0],5,1,wf6(:,4))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,493),heltab2x96(:,:,493))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(317),n2h48(452))
  Gcoeff(:)%j = (-(c(29)*M(5,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(494),h0tab(:,494),[32,1,4,2,24],[0,nMW,nMB,nMW,0],5,1,wf6(:,4))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,494),heltab2x96(:,:,494))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(318),n2h48(453))
  Gcoeff(:)%j = (-(c(174)*M(1,:)%j)+c(173)*M(4,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(495),h0tab(:,495),[32,1,4,2,24],[0,0,nMT,0,0],5,1,wf6(:,4))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,495),heltab2x96(:,:,495))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(319),n2h48(454))
  Gcoeff(:)%j = (c(173)*M(4,:)%j-c(174)*M(6,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(496),h0tab(:,496),[32,1,4,2,24],[0,0,nMT,0,0],5,1,wf6(:,4))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,496),heltab2x96(:,:,496))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(320),n2h48(455))
  Gcoeff(:)%j = (-(c(180)*M(1,:)%j)+c(179)*M(4,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(497),h0tab(:,497),[32,1,4,2,24],[0,nMZ,nMT,0,0],5,1,wf6(:,4))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,497),heltab2x96(:,:,497))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(321),n2h48(456))
  Gcoeff(:)%j = (c(179)*M(4,:)%j-c(180)*M(6,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(498),h0tab(:,498),[32,1,4,2,24],[0,0,nMT,nMZ,0],5,1,wf6(:,4))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,498),heltab2x96(:,:,498))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(322),n2h48(457))
  Gcoeff(:)%j = (c(160)*(-M(1,:)%j+M(6,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(499),h0tab(:,499),[32,2,4,1,24],[0,nMT,0,0,0],5,1,wf6(:,4))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(323),m3h2x48(:,499),heltab2x96(:,:,499))
  Gcoeff(:)%j = (c(164)*(-M(1,:)%j+M(6,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(500),h0tab(:,500),[32,2,4,1,24],[0,nMT,nMZ,0,0],5,1,wf6(:,4))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(324),m3h2x48(:,500),heltab2x96(:,:,500))
  Gcoeff(:)%j = (-(c(149)*M(3,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(501),h0tab(:,501),[32,2,24,1,4],[nMT,0,0,0,nMT],5,1,wf6(:,4))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,501),heltab2x96(:,:,501))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(325),n2h48(458))
  Gcoeff(:)%j = (-(c(153)*M(3,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(502),h0tab(:,502),[32,2,24,1,4],[nMT,nMZ,0,0,nMT],5,1,wf6(:,4))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,502),heltab2x96(:,:,502))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(326),n2h48(459))
  Gcoeff(:)%j = (-(c(153)*M(3,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(503),h0tab(:,503),[32,2,24,1,4],[nMT,0,0,nMZ,nMT],5,1,wf6(:,4))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,503),heltab2x96(:,:,503))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(327),n2h48(460))
  Gcoeff(:)%j = (-(c(155)*M(3,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(504),h0tab(:,504),[32,2,24,1,4],[nMT,nMZ,0,nMZ,nMT],5,1,wf6(:,4))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,504),heltab2x96(:,:,504))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(328),n2h48(461))
  Gcoeff(:)%j = (-(c(29)*M(3,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(505),h0tab(:,505),[32,2,24,1,4],[nMB,nMW,0,nMW,nMB],5,1,wf6(:,4))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,505),heltab2x96(:,:,505))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMB,G1H48(329),n2h48(462))
  Gcoeff(:)%j = (-(c(174)*M(1,:)%j)+c(173)*M(2,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(506),h0tab(:,506),[32,2,24,1,4],[nMT,0,0,0,nMT],5,1,wf6(:,4))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,506),heltab2x96(:,:,506))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(330),n2h48(463))
  Gcoeff(:)%j = (c(173)*M(2,:)%j-c(174)*M(6,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(507),h0tab(:,507),[32,2,24,1,4],[nMT,0,0,0,nMT],5,1,wf6(:,4))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,507),heltab2x96(:,:,507))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(331),n2h48(464))
  Gcoeff(:)%j = (-(c(180)*M(1,:)%j)+c(179)*M(2,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(508),h0tab(:,508),[32,2,24,1,4],[nMT,0,0,nMZ,nMT],5,1,wf6(:,4))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,508),heltab2x96(:,:,508))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(332),n2h48(465))
  Gcoeff(:)%j = (c(179)*M(2,:)%j-c(180)*M(6,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(509),h0tab(:,509),[32,2,24,1,4],[nMT,nMZ,0,0,nMT],5,1,wf6(:,4))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,509),heltab2x96(:,:,509))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(333),n2h48(466))
  Gcoeff(:)%j = (c(160)*(M(1,:)%j-M(6,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(510),h0tab(:,510),[32,1,24,4,2],[0,0,0,nMT,0],5,1,wf6(:,4))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(334),m3h2x48(:,510),heltab2x96(:,:,510))
  Gcoeff(:)%j = (c(164)*(M(1,:)%j-M(6,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(511),h0tab(:,511),[32,1,24,4,2],[0,0,nMZ,nMT,0],5,1,wf6(:,4))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(335),m3h2x48(:,511),heltab2x96(:,:,511))
  Gcoeff(:)%j = (c(160)*(M(1,:)%j-M(6,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(512),h0tab(:,512),[32,1,24,2,4],[0,0,0,nMT,0],5,1,wf6(:,4))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(336),m3h2x48(:,512),heltab2x96(:,:,512))
  Gcoeff(:)%j = (c(164)*(M(1,:)%j-M(6,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(513),h0tab(:,513),[32,1,24,2,4],[0,0,nMZ,nMT,0],5,1,wf6(:,4))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(337),m3h2x48(:,513),heltab2x96(:,:,513))
  Gcoeff(:)%j = (-(c(75)*M(5,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(514),h0tab(:,514),[33,8,2,4,16],[0,0,nMT,nMH,nMW],5,1,wf4(:,6))
  call Hloop_WQ_A(ntryL,G0H96(1),wf4(:,6),G0H24(1),m3h4x24(:,1),heltab2x96(:,:,514))
  call Hloop_Q_A(ntryL,G0H24(1),33,0,G1H24(30),n2h24(28))
  Gcoeff(:)%j = (c(80)*M(5,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(515),h0tab(:,515),[33,8,2,4,16],[0,nMZ,nMT,nMH,nMW],5,1,wf4(:,6))
  call Hloop_WQ_A(ntryL,G0H96(1),wf4(:,6),G0H24(1),m3h4x24(:,2),heltab2x96(:,:,515))
  call Hloop_Q_A(ntryL,G0H24(1),33,0,G1H24(31),n2h24(29))
  Gcoeff(:)%j = (c(86)*M(1,:)%j-c(85)*M(4,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(516),h0tab(:,516),[33,8,2,4,16],[0,0,nMT,nMH,nMW],5,1,wf4(:,6))
  call Hloop_WQ_A(ntryL,G0H96(1),wf4(:,6),G0H24(1),m3h4x24(:,3),heltab2x96(:,:,516))
  call Hloop_Q_A(ntryL,G0H24(1),33,0,G1H24(32),n2h24(30))
  Gcoeff(:)%j = (c(148)*M(5,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(517),h0tab(:,517),[33,8,2,4,16],[0,0,nMT,0,nMW],5,1,wf4(:,6))
  call Hloop_WQ_A(ntryL,G0H96(1),wf4(:,6),G0H24(1),m3h4x24(:,4),heltab2x96(:,:,517))
  call Hloop_Q_A(ntryL,G0H24(1),33,0,G1H24(33),n2h24(31))
  Gcoeff(:)%j = (c(127)*M(5,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(518),h0tab(:,518),[33,8,2,4,16],[0,0,nMT,nMZ,nMW],5,1,wf4(:,6))
  call Hloop_WQ_A(ntryL,G0H96(1),wf4(:,6),G0H24(1),m3h4x24(:,5),heltab2x96(:,:,518))
  call Hloop_Q_A(ntryL,G0H24(1),33,0,G1H24(34),n2h24(32))
  Gcoeff(:)%j = (-(c(154)*M(5,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(519),h0tab(:,519),[33,8,2,4,16],[0,nMZ,nMT,0,nMW],5,1,wf4(:,6))
  call Hloop_WQ_A(ntryL,G0H96(1),wf4(:,6),G0H24(1),m3h4x24(:,6),heltab2x96(:,:,519))
  call Hloop_Q_A(ntryL,G0H24(1),33,0,G1H24(35),n2h24(33))
  Gcoeff(:)%j = (-(c(131)*M(5,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(520),h0tab(:,520),[33,8,2,4,16],[0,nMZ,nMT,nMZ,nMW],5,1,wf4(:,6))
  call Hloop_WQ_A(ntryL,G0H96(1),wf4(:,6),G0H24(1),m3h4x24(:,7),heltab2x96(:,:,520))
  call Hloop_Q_A(ntryL,G0H24(1),33,0,G1H24(36),n2h24(34))
  Gcoeff(:)%j = (-(c(177)*M(1,:)%j)+c(176)*M(4,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(521),h0tab(:,521),[33,8,2,4,16],[0,0,nMT,0,nMW],5,1,wf4(:,6))
  call Hloop_WQ_A(ntryL,G0H96(1),wf4(:,6),G0H24(1),m3h4x24(:,8),heltab2x96(:,:,521))
  call Hloop_Q_A(ntryL,G0H24(1),33,0,G1H24(37),n2h24(35))
  Gcoeff(:)%j = (-(c(135)*M(1,:)%j)+c(134)*M(4,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(522),h0tab(:,522),[33,8,2,4,16],[0,0,nMT,nMZ,nMW],5,1,wf4(:,6))
  call Hloop_WQ_A(ntryL,G0H96(1),wf4(:,6),G0H24(1),m3h4x24(:,9),heltab2x96(:,:,522))
  call Hloop_Q_A(ntryL,G0H24(1),33,0,G1H24(38),n2h24(36))
  Gcoeff(:)%j = (c(146)*M(5,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(523),h0tab(:,523),[33,4,2,8,16],[0,nMT,0,0,0],5,1,wf4(:,6))
  call Hloop_AQ_V(ntryL,G0H96(1),wf4(:,6),G0H24(1),m3h4x24(:,10),heltab2x96(:,:,523))
  Gcoeff(:)%j = (c(150)*M(5,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(524),h0tab(:,524),[33,4,2,8,16],[nMZ,nMT,0,0,0],5,1,wf4(:,6))
  call Hloop_AQ_Z(ntryL,G0H96(1),wf4(:,6),G0H24(2),ngZu,m3h4x24(:,11),heltab2x96(:,:,524))
  Gcoeff(:)%j = (-(c(153)*M(5,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(525),h0tab(:,525),[33,4,2,8,16],[0,nMT,nMZ,0,0],5,1,wf4(:,6))
  call Hloop_AQ_V(ntryL,G0H96(1),wf4(:,6),G0H24(3),m3h4x24(:,12),heltab2x96(:,:,525))
  Gcoeff(:)%j = (-(c(155)*M(5,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(526),h0tab(:,526),[33,4,2,8,16],[nMZ,nMT,nMZ,0,0],5,1,wf4(:,6))
  call Hloop_AQ_Z(ntryL,G0H96(1),wf4(:,6),G0H24(4),ngZu,m3h4x24(:,13),heltab2x96(:,:,526))
  Gcoeff(:)%j = (c(169)*M(1,:)%j-c(168)*M(4,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(527),h0tab(:,527),[33,4,2,8,16],[0,nMT,0,0,0],5,1,wf4(:,6))
  call Hloop_AQ_V(ntryL,G0H96(1),wf4(:,6),G0H24(5),m3h4x24(:,14),heltab2x96(:,:,527))
  Gcoeff(:)%j = (-(c(174)*M(1,:)%j)+c(173)*M(4,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(528),h0tab(:,528),[33,4,2,8,16],[0,nMT,0,0,0],5,1,wf4(:,6))
  call Hloop_AQ_V(ntryL,G0H96(1),wf4(:,6),G0H24(6),m3h4x24(:,15),heltab2x96(:,:,528))
  Gcoeff(:)%j = (-(c(180)*M(1,:)%j)+c(179)*M(4,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(529),h0tab(:,529),[33,4,2,8,16],[0,nMT,nMZ,0,0],5,1,wf4(:,6))
  call Hloop_AQ_V(ntryL,G0H96(1),wf4(:,6),G0H24(7),m3h4x24(:,16),heltab2x96(:,:,529))
  Gcoeff(:)%j = (-(c(180)*M(1,:)%j)+c(179)*M(4,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(530),h0tab(:,530),[33,4,2,8,16],[nMZ,nMT,0,0,0],5,1,wf4(:,6))
  call Hloop_AQ_Z(ntryL,G0H96(1),wf4(:,6),G0H24(8),ngZu,m3h4x24(:,17),heltab2x96(:,:,530))
  Gcoeff(:)%j = (-(c(75)*M(5,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(531),h0tab(:,531),[33,8,4,2,16],[0,0,nMT,nMH,nMW],5,1,wf4(:,6))
  call Hloop_WQ_A(ntryL,G0H96(1),wf4(:,6),G0H24(9),m3h4x24(:,18),heltab2x96(:,:,531))
  call Hloop_Q_A(ntryL,G0H24(9),33,0,G1H24(39),n2h24(37))
  Gcoeff(:)%j = (c(108)*M(5,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(532),h0tab(:,532),[33,8,4,2,16],[0,nMW,nMB,nMW,0],5,1,wf4(:,6))
  call Hloop_VQ_A(ntryL,G0H96(1),wf4(:,6),G0H24(9),m3h4x24(:,19),heltab2x96(:,:,532))
  call Hloop_Q_A(ntryL,G0H24(9),33,0,G1H24(40),n2h24(38))
  Gcoeff(:)%j = (c(80)*M(5,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(533),h0tab(:,533),[33,8,4,2,16],[0,nMZ,nMT,nMH,nMW],5,1,wf4(:,6))
  call Hloop_WQ_A(ntryL,G0H96(1),wf4(:,6),G0H24(9),m3h4x24(:,20),heltab2x96(:,:,533))
  call Hloop_Q_A(ntryL,G0H24(9),33,0,G1H24(41),n2h24(39))
  Gcoeff(:)%j = (-(c(142)*M(5,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(534),h0tab(:,534),[33,8,4,2,16],[0,nMW,nMB,nMW,nMZ],5,1,wf4(:,6))
  call Hloop_ZQ_A(ntryL,G0H96(1),wf4(:,6),G0H24(9),ngZu,m3h4x24(:,21),heltab2x96(:,:,534))
  call Hloop_Q_A(ntryL,G0H24(9),33,0,G1H24(42),n2h24(40))
  Gcoeff(:)%j = (c(86)*M(1,:)%j-c(85)*M(4,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(535),h0tab(:,535),[33,8,4,2,16],[0,0,nMT,nMH,nMW],5,1,wf4(:,6))
  call Hloop_WQ_A(ntryL,G0H96(1),wf4(:,6),G0H24(9),m3h4x24(:,22),heltab2x96(:,:,535))
  call Hloop_Q_A(ntryL,G0H24(9),33,0,G1H24(43),n2h24(41))
  Gcoeff(:)%j = (c(148)*M(5,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(536),h0tab(:,536),[33,8,4,2,16],[0,0,nMT,0,nMW],5,1,wf4(:,6))
  call Hloop_WQ_A(ntryL,G0H96(1),wf4(:,6),G0H24(9),m3h4x24(:,23),heltab2x96(:,:,536))
  call Hloop_Q_A(ntryL,G0H24(9),33,0,G1H24(44),n2h24(42))
  Gcoeff(:)%j = (-(c(154)*M(5,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(537),h0tab(:,537),[33,8,4,2,16],[0,nMZ,nMT,0,nMW],5,1,wf4(:,6))
  call Hloop_WQ_A(ntryL,G0H96(1),wf4(:,6),G0H24(9),m3h4x24(:,24),heltab2x96(:,:,537))
  call Hloop_Q_A(ntryL,G0H24(9),33,0,G1H24(45),n2h24(43))
  Gcoeff(:)%j = (c(127)*M(5,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(538),h0tab(:,538),[33,8,4,2,16],[0,0,nMT,nMZ,nMW],5,1,wf4(:,6))
  call Hloop_WQ_A(ntryL,G0H96(1),wf4(:,6),G0H24(9),m3h4x24(:,25),heltab2x96(:,:,538))
  call Hloop_Q_A(ntryL,G0H24(9),33,0,G1H24(46),n2h24(44))
  Gcoeff(:)%j = (-(c(131)*M(5,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(539),h0tab(:,539),[33,8,4,2,16],[0,nMZ,nMT,nMZ,nMW],5,1,wf4(:,6))
  call Hloop_WQ_A(ntryL,G0H96(1),wf4(:,6),G0H24(9),m3h4x24(:,26),heltab2x96(:,:,539))
  call Hloop_Q_A(ntryL,G0H24(9),33,0,G1H24(47),n2h24(45))
  Gcoeff(:)%j = (-(c(108)*M(5,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(540),h0tab(:,540),[33,8,4,2,16],[0,nMW,nMB,nMW,0],5,1,wf4(:,6))
  call Hloop_VQ_A(ntryL,G0H96(1),wf4(:,6),G0H24(9),m3h4x24(:,27),heltab2x96(:,:,540))
  call Hloop_Q_A(ntryL,G0H24(9),33,0,G1H24(48),n2h24(46))
  Gcoeff(:)%j = (-(c(63)*M(5,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(541),h0tab(:,541),[33,8,4,2,16],[0,nMW,nMB,nMW,nMZ],5,1,wf4(:,6))
  call Hloop_ZQ_A(ntryL,G0H96(1),wf4(:,6),G0H24(9),ngZu,m3h4x24(:,28),heltab2x96(:,:,541))
  call Hloop_Q_A(ntryL,G0H24(9),33,0,G1H24(49),n2h24(47))
  Gcoeff(:)%j = (-(c(177)*M(1,:)%j)+c(176)*M(4,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(542),h0tab(:,542),[33,8,4,2,16],[0,0,nMT,0,nMW],5,1,wf4(:,6))
  call Hloop_WQ_A(ntryL,G0H96(1),wf4(:,6),G0H24(9),m3h4x24(:,29),heltab2x96(:,:,542))
  call Hloop_Q_A(ntryL,G0H24(9),33,0,G1H24(50),n2h24(48))
  Gcoeff(:)%j = (-(c(135)*M(1,:)%j)+c(134)*M(4,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(543),h0tab(:,543),[33,8,4,2,16],[0,0,nMT,nMZ,nMW],5,1,wf4(:,6))
  call Hloop_WQ_A(ntryL,G0H96(1),wf4(:,6),G0H24(9),m3h4x24(:,30),heltab2x96(:,:,543))
  call Hloop_Q_A(ntryL,G0H24(9),33,0,G1H24(51),n2h24(49))
  Gcoeff(:)%j = (c(77)*M(5,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(544),h0tab(:,544),[33,4,2,16,8],[0,nMT,nMH,nMW,0],5,1,wf4(:,6))
  call Hloop_AQ_V(ntryL,G0H96(1),wf4(:,6),G0H24(9),m3h4x24(:,31),heltab2x96(:,:,544))
  Gcoeff(:)%j = (-(c(106)*M(5,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(545),h0tab(:,545),[33,4,2,16,8],[nMW,nMB,nMW,0,0],5,1,wf4(:,6))
  call Hloop_AQ_W(ntryL,G0H96(1),wf4(:,6),G0H24(10),m3h4x24(:,32),heltab2x96(:,:,545))
  Gcoeff(:)%j = (c(80)*M(5,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(546),h0tab(:,546),[33,4,2,16,8],[nMZ,nMT,nMH,nMW,0],5,1,wf4(:,6))
  call Hloop_AQ_Z(ntryL,G0H96(1),wf4(:,6),G0H24(11),ngZu,m3h4x24(:,33),heltab2x96(:,:,546))
  Gcoeff(:)%j = (-(c(142)*M(5,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(547),h0tab(:,547),[33,4,2,16,8],[nMW,nMB,nMW,nMZ,0],5,1,wf4(:,6))
  call Hloop_AQ_W(ntryL,G0H96(1),wf4(:,6),G0H24(12),m3h4x24(:,34),heltab2x96(:,:,547))
  Gcoeff(:)%j = (c(86)*M(1,:)%j-c(85)*M(4,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(548),h0tab(:,548),[33,4,2,16,8],[0,nMT,nMH,nMW,0],5,1,wf4(:,6))
  call Hloop_AQ_V(ntryL,G0H96(1),wf4(:,6),G0H24(13),m3h4x24(:,35),heltab2x96(:,:,548))
  Gcoeff(:)%j = (-(c(151)*M(5,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(549),h0tab(:,549),[33,4,2,16,8],[0,nMT,0,nMW,0],5,1,wf4(:,6))
  call Hloop_AQ_V(ntryL,G0H96(1),wf4(:,6),G0H24(14),m3h4x24(:,36),heltab2x96(:,:,549))
  Gcoeff(:)%j = (-(c(154)*M(5,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(550),h0tab(:,550),[33,4,2,16,8],[nMZ,nMT,0,nMW,0],5,1,wf4(:,6))
  call Hloop_AQ_Z(ntryL,G0H96(1),wf4(:,6),G0H24(15),ngZu,m3h4x24(:,37),heltab2x96(:,:,550))
  Gcoeff(:)%j = (-(c(129)*M(5,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(551),h0tab(:,551),[33,4,2,16,8],[0,nMT,nMZ,nMW,0],5,1,wf4(:,6))
  call Hloop_AQ_V(ntryL,G0H96(1),wf4(:,6),G0H24(16),m3h4x24(:,38),heltab2x96(:,:,551))
  Gcoeff(:)%j = (-(c(131)*M(5,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(552),h0tab(:,552),[33,4,2,16,8],[nMZ,nMT,nMZ,nMW,0],5,1,wf4(:,6))
  call Hloop_AQ_Z(ntryL,G0H96(1),wf4(:,6),G0H24(17),ngZu,m3h4x24(:,39),heltab2x96(:,:,552))
  Gcoeff(:)%j = (c(106)*M(5,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(553),h0tab(:,553),[33,4,2,16,8],[nMW,nMB,nMW,0,0],5,1,wf4(:,6))
  call Hloop_AQ_W(ntryL,G0H96(1),wf4(:,6),G0H24(18),m3h4x24(:,40),heltab2x96(:,:,553))
  Gcoeff(:)%j = (-(c(63)*M(5,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(554),h0tab(:,554),[33,4,2,16,8],[nMW,nMB,nMW,nMZ,0],5,1,wf4(:,6))
  call Hloop_AQ_W(ntryL,G0H96(1),wf4(:,6),G0H24(19),m3h4x24(:,41),heltab2x96(:,:,554))
  Gcoeff(:)%j = (-(c(177)*M(1,:)%j)+c(176)*M(4,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(555),h0tab(:,555),[33,4,2,16,8],[0,nMT,0,nMW,0],5,1,wf4(:,6))
  call Hloop_AQ_V(ntryL,G0H96(1),wf4(:,6),G0H24(20),m3h4x24(:,42),heltab2x96(:,:,555))
  Gcoeff(:)%j = (-(c(135)*M(1,:)%j)+c(134)*M(4,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(556),h0tab(:,556),[33,4,2,16,8],[0,nMT,nMZ,nMW,0],5,1,wf4(:,6))
  call Hloop_AQ_V(ntryL,G0H96(1),wf4(:,6),G0H24(21),m3h4x24(:,43),heltab2x96(:,:,556))
  Gcoeff(:)%j = (c(146)*M(5,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(557),h0tab(:,557),[33,2,4,8,16],[0,nMT,0,0,0],5,1,wf4(:,6))
  call Hloop_AQ_V(ntryL,G0H96(1),wf4(:,6),G0H24(22),m3h4x24(:,44),heltab2x96(:,:,557))
  Gcoeff(:)%j = (-(c(153)*M(5,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(558),h0tab(:,558),[33,2,4,8,16],[0,nMT,nMZ,0,0],5,1,wf4(:,6))
  call Hloop_AQ_V(ntryL,G0H96(1),wf4(:,6),G0H24(23),m3h4x24(:,45),heltab2x96(:,:,558))
  Gcoeff(:)%j = (c(150)*M(5,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(559),h0tab(:,559),[33,2,4,8,16],[nMZ,nMT,0,0,0],5,1,wf4(:,6))
  call Hloop_AQ_Z(ntryL,G0H96(1),wf4(:,6),G0H24(24),ngZu,m3h4x24(:,46),heltab2x96(:,:,559))
  Gcoeff(:)%j = (-(c(155)*M(5,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(560),h0tab(:,560),[33,2,4,8,16],[nMZ,nMT,nMZ,0,0],5,1,wf4(:,6))
  call Hloop_AQ_Z(ntryL,G0H96(1),wf4(:,6),G0H24(25),ngZu,m3h4x24(:,47),heltab2x96(:,:,560))
  Gcoeff(:)%j = (-(c(174)*M(1,:)%j)+c(173)*M(4,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(561),h0tab(:,561),[33,2,4,8,16],[0,nMT,0,0,0],5,1,wf4(:,6))
  call Hloop_AQ_V(ntryL,G0H96(1),wf4(:,6),G0H24(26),m3h4x24(:,48),heltab2x96(:,:,561))
  Gcoeff(:)%j = (c(169)*M(1,:)%j-c(168)*M(4,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(562),h0tab(:,562),[33,2,4,8,16],[0,nMT,0,0,0],5,1,wf4(:,6))
  call Hloop_AQ_V(ntryL,G0H96(1),wf4(:,6),G0H24(27),m3h4x24(:,49),heltab2x96(:,:,562))
  Gcoeff(:)%j = (-(c(180)*M(1,:)%j)+c(179)*M(4,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(563),h0tab(:,563),[33,2,4,8,16],[nMZ,nMT,0,0,0],5,1,wf4(:,6))
  call Hloop_AQ_Z(ntryL,G0H96(1),wf4(:,6),G0H24(28),ngZu,m3h4x24(:,50),heltab2x96(:,:,563))
  Gcoeff(:)%j = (-(c(180)*M(1,:)%j)+c(179)*M(4,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(564),h0tab(:,564),[33,2,4,8,16],[0,nMT,nMZ,0,0],5,1,wf4(:,6))
  call Hloop_AQ_V(ntryL,G0H96(1),wf4(:,6),G0H24(29),m3h4x24(:,51),heltab2x96(:,:,564))
  Gcoeff(:)%j = (c(77)*M(5,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(565),h0tab(:,565),[33,2,4,16,8],[0,nMT,nMH,nMW,0],5,1,wf4(:,6))
  call Hloop_AQ_V(ntryL,G0H96(1),wf4(:,6),G0H24(30),m3h4x24(:,52),heltab2x96(:,:,565))
  Gcoeff(:)%j = (c(80)*M(5,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(566),h0tab(:,566),[33,2,4,16,8],[nMZ,nMT,nMH,nMW,0],5,1,wf4(:,6))
  call Hloop_AQ_Z(ntryL,G0H96(1),wf4(:,6),G0H24(31),ngZu,m3h4x24(:,53),heltab2x96(:,:,566))
  Gcoeff(:)%j = (c(86)*M(1,:)%j-c(85)*M(4,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(567),h0tab(:,567),[33,2,4,16,8],[0,nMT,nMH,nMW,0],5,1,wf4(:,6))
  call Hloop_AQ_V(ntryL,G0H96(1),wf4(:,6),G0H24(32),m3h4x24(:,54),heltab2x96(:,:,567))
  Gcoeff(:)%j = (-(c(151)*M(5,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(568),h0tab(:,568),[33,2,4,16,8],[0,nMT,0,nMW,0],5,1,wf4(:,6))
  call Hloop_AQ_V(ntryL,G0H96(1),wf4(:,6),G0H24(33),m3h4x24(:,55),heltab2x96(:,:,568))
  Gcoeff(:)%j = (-(c(129)*M(5,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(569),h0tab(:,569),[33,2,4,16,8],[0,nMT,nMZ,nMW,0],5,1,wf4(:,6))
  call Hloop_AQ_V(ntryL,G0H96(1),wf4(:,6),G0H24(34),m3h4x24(:,56),heltab2x96(:,:,569))
  Gcoeff(:)%j = (-(c(154)*M(5,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(570),h0tab(:,570),[33,2,4,16,8],[nMZ,nMT,0,nMW,0],5,1,wf4(:,6))
  call Hloop_AQ_Z(ntryL,G0H96(1),wf4(:,6),G0H24(35),ngZu,m3h4x24(:,57),heltab2x96(:,:,570))
  Gcoeff(:)%j = (-(c(131)*M(5,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(571),h0tab(:,571),[33,2,4,16,8],[nMZ,nMT,nMZ,nMW,0],5,1,wf4(:,6))
  call Hloop_AQ_Z(ntryL,G0H96(1),wf4(:,6),G0H24(36),ngZu,m3h4x24(:,58),heltab2x96(:,:,571))
  Gcoeff(:)%j = (-(c(177)*M(1,:)%j)+c(176)*M(4,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(572),h0tab(:,572),[33,2,4,16,8],[0,nMT,0,nMW,0],5,1,wf4(:,6))
  call Hloop_AQ_V(ntryL,G0H96(1),wf4(:,6),G0H24(37),m3h4x24(:,59),heltab2x96(:,:,572))
  Gcoeff(:)%j = (-(c(135)*M(1,:)%j)+c(134)*M(4,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(573),h0tab(:,573),[33,2,4,16,8],[0,nMT,nMZ,nMW,0],5,1,wf4(:,6))
  call Hloop_AQ_V(ntryL,G0H96(1),wf4(:,6),G0H24(38),m3h4x24(:,60),heltab2x96(:,:,573))
  Gcoeff(:)%j = (c(105)*M(5,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(574),h0tab(:,574),[33,4,16,2,8],[nMW,nMB,nMT,0,0],5,1,wf4(:,6))
  call Hloop_AQ_W(ntryL,G0H96(1),wf4(:,6),G0H24(39),m3h4x24(:,61),heltab2x96(:,:,574))
  Gcoeff(:)%j = (-(c(109)*M(5,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(575),h0tab(:,575),[33,4,16,2,8],[nMW,nMB,nMT,nMZ,0],5,1,wf4(:,6))
  call Hloop_AQ_W(ntryL,G0H96(1),wf4(:,6),G0H24(40),m3h4x24(:,62),heltab2x96(:,:,575))
  Gcoeff(:)%j = (-(c(113)*M(1,:)%j)+c(112)*M(4,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(576),h0tab(:,576),[33,4,16,2,8],[nMW,nMB,nMT,0,0],5,1,wf4(:,6))
  call Hloop_AQ_W(ntryL,G0H96(1),wf4(:,6),G0H24(41),m3h4x24(:,63),heltab2x96(:,:,576))
  Gcoeff(:)%j = (-(c(107)*M(5,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(577),h0tab(:,577),[33,2,16,4,8],[0,nMT,nMB,nMW,0],5,1,wf4(:,6))
  call Hloop_AQ_V(ntryL,G0H96(1),wf4(:,6),G0H24(42),m3h4x24(:,64),heltab2x96(:,:,577))
  Gcoeff(:)%j = (-(c(109)*M(5,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(578),h0tab(:,578),[33,2,16,4,8],[nMZ,nMT,nMB,nMW,0],5,1,wf4(:,6))
  call Hloop_AQ_Z(ntryL,G0H96(1),wf4(:,6),G0H24(43),ngZu,m3h4x24(:,65),heltab2x96(:,:,578))
  Gcoeff(:)%j = (-(c(113)*M(1,:)%j)+c(112)*M(4,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(579),h0tab(:,579),[33,2,16,4,8],[0,nMT,nMB,nMW,0],5,1,wf4(:,6))
  call Hloop_AQ_V(ntryL,G0H96(1),wf4(:,6),G0H24(44),m3h4x24(:,66),heltab2x96(:,:,579))
  Gcoeff(:)%j = (c(105)*M(3,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(580),h0tab(:,580),[34,8,1,4,16],[0,0,nMW,nMB,nMT],5,1,wf4(:,12))
  call Hloop_AQ_V(ntryL,G0H96(1),wf4(:,12),G0H24(45),m3h4x24(:,67),heltab2x96(:,:,580))
  Gcoeff(:)%j = (-(c(109)*M(3,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(581),h0tab(:,581),[34,8,1,4,16],[nMZ,0,nMW,nMB,nMT],5,1,wf4(:,12))
  call Hloop_AQ_Z(ntryL,G0H96(1),wf4(:,12),G0H24(46),ngZu,m3h4x24(:,68),heltab2x96(:,:,581))
  Gcoeff(:)%j = (c(112)*M(2,:)%j-c(113)*M(6,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(582),h0tab(:,582),[34,8,1,4,16],[0,0,nMW,nMB,nMT],5,1,wf4(:,12))
  call Hloop_AQ_V(ntryL,G0H96(1),wf4(:,12),G0H24(47),m3h4x24(:,69),heltab2x96(:,:,582))
  Gcoeff(:)%j = (c(77)*M(3,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(583),h0tab(:,583),[34,4,1,8,16],[nMT,0,0,nMW,nMH],5,1,wf4(:,12))
  call Hloop_SQ_A(ntryL,G0H96(1),wf4(:,12),G0H24(48),ngH,m3h4x24(:,70),heltab2x96(:,:,583))
  call Hloop_Q_A(ntryL,G0H24(48),34,nMT,G1H24(52),n2h24(50))
  Gcoeff(:)%j = (-(c(106)*M(3,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(584),h0tab(:,584),[34,4,1,8,16],[nMB,nMW,0,0,nMW],5,1,wf4(:,12))
  call Hloop_SQ_A(ntryL,G0H96(1),wf4(:,12),G0H24(48),ngPbt,m3h4x24(:,71),heltab2x96(:,:,584))
  call Hloop_Q_A(ntryL,G0H24(48),34,nMB,G1H24(53),n2h24(51))
  Gcoeff(:)%j = (c(80)*M(3,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(585),h0tab(:,585),[34,4,1,8,16],[nMT,nMZ,0,nMW,nMH],5,1,wf4(:,12))
  call Hloop_SQ_A(ntryL,G0H96(1),wf4(:,12),G0H24(48),ngH,m3h4x24(:,72),heltab2x96(:,:,585))
  call Hloop_Q_A(ntryL,G0H24(48),34,nMT,G1H24(54),n2h24(52))
  Gcoeff(:)%j = (-(c(142)*M(3,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(586),h0tab(:,586),[34,4,1,8,16],[nMB,nMW,0,nMZ,nMW],5,1,wf4(:,12))
  call Hloop_SQ_A(ntryL,G0H96(1),wf4(:,12),G0H24(48),ngPbt,m3h4x24(:,73),heltab2x96(:,:,586))
  call Hloop_Q_A(ntryL,G0H24(48),34,nMB,G1H24(55),n2h24(53))
  Gcoeff(:)%j = (-(c(85)*M(2,:)%j)+c(86)*M(6,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(587),h0tab(:,587),[34,4,1,8,16],[nMT,0,0,nMW,nMH],5,1,wf4(:,12))
  call Hloop_SQ_A(ntryL,G0H96(1),wf4(:,12),G0H24(48),ngH,m3h4x24(:,74),heltab2x96(:,:,587))
  call Hloop_Q_A(ntryL,G0H24(48),34,nMT,G1H24(56),n2h24(54))
  Gcoeff(:)%j = (-(c(151)*M(3,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(588),h0tab(:,588),[34,4,1,8,16],[nMT,0,0,nMW,0],5,1,wf4(:,12))
  call Hloop_VQ_A(ntryL,G0H96(1),wf4(:,12),G0H24(48),m3h4x24(:,75),heltab2x96(:,:,588))
  call Hloop_Q_A(ntryL,G0H24(48),34,nMT,G1H24(57),n2h24(55))
  Gcoeff(:)%j = (-(c(129)*M(3,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(589),h0tab(:,589),[34,4,1,8,16],[nMT,0,0,nMW,nMZ],5,1,wf4(:,12))
  call Hloop_ZQ_A(ntryL,G0H96(1),wf4(:,12),G0H24(48),ngZu,m3h4x24(:,76),heltab2x96(:,:,589))
  call Hloop_Q_A(ntryL,G0H24(48),34,nMT,G1H24(58),n2h24(56))
  Gcoeff(:)%j = (-(c(154)*M(3,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(590),h0tab(:,590),[34,4,1,8,16],[nMT,nMZ,0,nMW,0],5,1,wf4(:,12))
  call Hloop_VQ_A(ntryL,G0H96(1),wf4(:,12),G0H24(48),m3h4x24(:,77),heltab2x96(:,:,590))
  call Hloop_Q_A(ntryL,G0H24(48),34,nMT,G1H24(59),n2h24(57))
  Gcoeff(:)%j = (-(c(131)*M(3,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(591),h0tab(:,591),[34,4,1,8,16],[nMT,nMZ,0,nMW,nMZ],5,1,wf4(:,12))
  call Hloop_ZQ_A(ntryL,G0H96(1),wf4(:,12),G0H24(48),ngZu,m3h4x24(:,78),heltab2x96(:,:,591))
  call Hloop_Q_A(ntryL,G0H24(48),34,nMT,G1H24(60),n2h24(58))
  Gcoeff(:)%j = (c(106)*M(3,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(592),h0tab(:,592),[34,4,1,8,16],[nMB,nMW,0,0,nMW],5,1,wf4(:,12))
  call Hloop_WQ_A(ntryL,G0H96(1),wf4(:,12),G0H24(48),m3h4x24(:,79),heltab2x96(:,:,592))
  call Hloop_Q_A(ntryL,G0H24(48),34,nMB,G1H24(61),n2h24(59))
  Gcoeff(:)%j = (-(c(63)*M(3,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(593),h0tab(:,593),[34,4,1,8,16],[nMB,nMW,0,nMZ,nMW],5,1,wf4(:,12))
  call Hloop_WQ_A(ntryL,G0H96(1),wf4(:,12),G0H24(48),m3h4x24(:,80),heltab2x96(:,:,593))
  call Hloop_Q_A(ntryL,G0H24(48),34,nMB,G1H24(62),n2h24(60))
  Gcoeff(:)%j = (c(176)*M(2,:)%j-c(177)*M(6,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(594),h0tab(:,594),[34,4,1,8,16],[nMT,0,0,nMW,0],5,1,wf4(:,12))
  call Hloop_VQ_A(ntryL,G0H96(1),wf4(:,12),G0H24(48),m3h4x24(:,81),heltab2x96(:,:,594))
  call Hloop_Q_A(ntryL,G0H24(48),34,nMT,G1H24(63),n2h24(61))
  Gcoeff(:)%j = (c(134)*M(2,:)%j-c(135)*M(6,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(595),h0tab(:,595),[34,4,1,8,16],[nMT,0,0,nMW,nMZ],5,1,wf4(:,12))
  call Hloop_ZQ_A(ntryL,G0H96(1),wf4(:,12),G0H24(48),ngZu,m3h4x24(:,82),heltab2x96(:,:,595))
  call Hloop_Q_A(ntryL,G0H24(48),34,nMT,G1H24(64),n2h24(62))
  Gcoeff(:)%j = (c(146)*M(3,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(596),h0tab(:,596),[34,4,1,16,8],[nMT,0,0,0,0],5,1,wf4(:,12))
  call Hloop_VQ_A(ntryL,G0H96(1),wf4(:,12),G0H24(48),m3h4x24(:,83),heltab2x96(:,:,596))
  call Hloop_Q_A(ntryL,G0H24(48),34,nMT,G1H24(65),n2h24(63))
  Gcoeff(:)%j = (-(c(153)*M(3,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(597),h0tab(:,597),[34,4,1,16,8],[nMT,0,0,0,nMZ],5,1,wf4(:,12))
  call Hloop_ZQ_A(ntryL,G0H96(1),wf4(:,12),G0H24(48),ngZu,m3h4x24(:,84),heltab2x96(:,:,597))
  call Hloop_Q_A(ntryL,G0H24(48),34,nMT,G1H24(66),n2h24(64))
  Gcoeff(:)%j = (c(150)*M(3,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(598),h0tab(:,598),[34,4,1,16,8],[nMT,nMZ,0,0,0],5,1,wf4(:,12))
  call Hloop_VQ_A(ntryL,G0H96(1),wf4(:,12),G0H24(48),m3h4x24(:,85),heltab2x96(:,:,598))
  call Hloop_Q_A(ntryL,G0H24(48),34,nMT,G1H24(67),n2h24(65))
  Gcoeff(:)%j = (-(c(155)*M(3,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(599),h0tab(:,599),[34,4,1,16,8],[nMT,nMZ,0,0,nMZ],5,1,wf4(:,12))
  call Hloop_ZQ_A(ntryL,G0H96(1),wf4(:,12),G0H24(48),ngZu,m3h4x24(:,86),heltab2x96(:,:,599))
  call Hloop_Q_A(ntryL,G0H24(48),34,nMT,G1H24(68),n2h24(66))
  Gcoeff(:)%j = (c(173)*M(2,:)%j-c(174)*M(6,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(600),h0tab(:,600),[34,4,1,16,8],[nMT,0,0,0,0],5,1,wf4(:,12))
  call Hloop_VQ_A(ntryL,G0H96(1),wf4(:,12),G0H24(48),m3h4x24(:,87),heltab2x96(:,:,600))
  call Hloop_Q_A(ntryL,G0H24(48),34,nMT,G1H24(69),n2h24(67))
  Gcoeff(:)%j = (-(c(168)*M(2,:)%j)+c(169)*M(6,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(601),h0tab(:,601),[34,4,1,16,8],[nMT,0,0,0,0],5,1,wf4(:,12))
  call Hloop_VQ_A(ntryL,G0H96(1),wf4(:,12),G0H24(48),m3h4x24(:,88),heltab2x96(:,:,601))
  call Hloop_Q_A(ntryL,G0H24(48),34,nMT,G1H24(70),n2h24(68))
  Gcoeff(:)%j = (c(179)*M(2,:)%j-c(180)*M(6,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(602),h0tab(:,602),[34,4,1,16,8],[nMT,nMZ,0,0,0],5,1,wf4(:,12))
  call Hloop_VQ_A(ntryL,G0H96(1),wf4(:,12),G0H24(48),m3h4x24(:,89),heltab2x96(:,:,602))
  call Hloop_Q_A(ntryL,G0H24(48),34,nMT,G1H24(71),n2h24(69))
  Gcoeff(:)%j = (c(179)*M(2,:)%j-c(180)*M(6,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(603),h0tab(:,603),[34,4,1,16,8],[nMT,0,0,0,nMZ],5,1,wf4(:,12))
  call Hloop_ZQ_A(ntryL,G0H96(1),wf4(:,12),G0H24(48),ngZu,m3h4x24(:,90),heltab2x96(:,:,603))
  call Hloop_Q_A(ntryL,G0H24(48),34,nMT,G1H24(72),n2h24(70))
  Gcoeff(:)%j = (-(c(75)*M(3,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(604),h0tab(:,604),[34,4,8,1,16],[nMT,0,0,nMW,nMH],5,1,wf4(:,12))
  call Hloop_SQ_A(ntryL,G0H96(1),wf4(:,12),G0H24(48),ngH,m3h4x24(:,91),heltab2x96(:,:,604))
  call Hloop_Q_A(ntryL,G0H24(48),34,nMT,G1H24(73),n2h24(71))
  Gcoeff(:)%j = (c(108)*M(3,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(605),h0tab(:,605),[34,4,8,1,16],[nMB,nMW,0,0,nMW],5,1,wf4(:,12))
  call Hloop_SQ_A(ntryL,G0H96(1),wf4(:,12),G0H24(48),ngPbt,m3h4x24(:,92),heltab2x96(:,:,605))
  call Hloop_Q_A(ntryL,G0H24(48),34,nMB,G1H24(74),n2h24(72))
  Gcoeff(:)%j = (c(80)*M(3,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(606),h0tab(:,606),[34,4,8,1,16],[nMT,nMZ,0,nMW,nMH],5,1,wf4(:,12))
  call Hloop_SQ_A(ntryL,G0H96(1),wf4(:,12),G0H24(48),ngH,m3h4x24(:,93),heltab2x96(:,:,606))
  call Hloop_Q_A(ntryL,G0H24(48),34,nMT,G1H24(75),n2h24(73))
  Gcoeff(:)%j = (-(c(142)*M(3,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(607),h0tab(:,607),[34,4,8,1,16],[nMB,nMW,0,nMZ,nMW],5,1,wf4(:,12))
  call Hloop_SQ_A(ntryL,G0H96(1),wf4(:,12),G0H24(48),ngPbt,m3h4x24(:,94),heltab2x96(:,:,607))
  call Hloop_Q_A(ntryL,G0H24(48),34,nMB,G1H24(76),n2h24(74))
  Gcoeff(:)%j = (-(c(85)*M(2,:)%j)+c(86)*M(6,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(608),h0tab(:,608),[34,4,8,1,16],[nMT,0,0,nMW,nMH],5,1,wf4(:,12))
  call Hloop_SQ_A(ntryL,G0H96(1),wf4(:,12),G0H24(48),ngH,m3h4x24(:,95),heltab2x96(:,:,608))
  call Hloop_Q_A(ntryL,G0H24(48),34,nMT,G1H24(77),n2h24(75))
  Gcoeff(:)%j = (c(148)*M(3,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(609),h0tab(:,609),[34,4,8,1,16],[nMT,0,0,nMW,0],5,1,wf4(:,12))
  call Hloop_VQ_A(ntryL,G0H96(1),wf4(:,12),G0H24(48),m3h4x24(:,96),heltab2x96(:,:,609))
  call Hloop_Q_A(ntryL,G0H24(48),34,nMT,G1H24(78),n2h24(76))
  Gcoeff(:)%j = (c(127)*M(3,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(610),h0tab(:,610),[34,4,8,1,16],[nMT,0,0,nMW,nMZ],5,1,wf4(:,12))
  call Hloop_ZQ_A(ntryL,G0H96(1),wf4(:,12),G0H24(48),ngZu,m3h4x24(:,97),heltab2x96(:,:,610))
  call Hloop_Q_A(ntryL,G0H24(48),34,nMT,G1H24(79),n2h24(77))
  Gcoeff(:)%j = (-(c(154)*M(3,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(611),h0tab(:,611),[34,4,8,1,16],[nMT,nMZ,0,nMW,0],5,1,wf4(:,12))
  call Hloop_VQ_A(ntryL,G0H96(1),wf4(:,12),G0H24(48),m3h4x24(:,98),heltab2x96(:,:,611))
  call Hloop_Q_A(ntryL,G0H24(48),34,nMT,G1H24(80),n2h24(78))
  Gcoeff(:)%j = (-(c(131)*M(3,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(612),h0tab(:,612),[34,4,8,1,16],[nMT,nMZ,0,nMW,nMZ],5,1,wf4(:,12))
  call Hloop_ZQ_A(ntryL,G0H96(1),wf4(:,12),G0H24(48),ngZu,m3h4x24(:,99),heltab2x96(:,:,612))
  call Hloop_Q_A(ntryL,G0H24(48),34,nMT,G1H24(81),n2h24(79))
  Gcoeff(:)%j = (-(c(108)*M(3,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(613),h0tab(:,613),[34,4,8,1,16],[nMB,nMW,0,0,nMW],5,1,wf4(:,12))
  call Hloop_WQ_A(ntryL,G0H96(1),wf4(:,12),G0H24(48),m3h4x24(:,100),heltab2x96(:,:,613))
  call Hloop_Q_A(ntryL,G0H24(48),34,nMB,G1H24(82),n2h24(80))
  Gcoeff(:)%j = (-(c(63)*M(3,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(614),h0tab(:,614),[34,4,8,1,16],[nMB,nMW,0,nMZ,nMW],5,1,wf4(:,12))
  call Hloop_WQ_A(ntryL,G0H96(1),wf4(:,12),G0H24(48),m3h4x24(:,101),heltab2x96(:,:,614))
  call Hloop_Q_A(ntryL,G0H24(48),34,nMB,G1H24(83),n2h24(81))
  Gcoeff(:)%j = (c(176)*M(2,:)%j-c(177)*M(6,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(615),h0tab(:,615),[34,4,8,1,16],[nMT,0,0,nMW,0],5,1,wf4(:,12))
  call Hloop_VQ_A(ntryL,G0H96(1),wf4(:,12),G0H24(48),m3h4x24(:,102),heltab2x96(:,:,615))
  call Hloop_Q_A(ntryL,G0H24(48),34,nMT,G1H24(84),n2h24(82))
  Gcoeff(:)%j = (c(134)*M(2,:)%j-c(135)*M(6,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(616),h0tab(:,616),[34,4,8,1,16],[nMT,0,0,nMW,nMZ],5,1,wf4(:,12))
  call Hloop_ZQ_A(ntryL,G0H96(1),wf4(:,12),G0H24(48),ngZu,m3h4x24(:,103),heltab2x96(:,:,616))
  call Hloop_Q_A(ntryL,G0H24(48),34,nMT,G1H24(85),n2h24(83))
  Gcoeff(:)%j = (-(c(75)*M(3,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(617),h0tab(:,617),[34,4,16,1,8],[nMT,nMH,nMW,0,0],5,1,wf4(:,12))
  call Hloop_VQ_A(ntryL,G0H96(1),wf4(:,12),G0H24(48),m3h4x24(:,104),heltab2x96(:,:,617))
  call Hloop_Q_A(ntryL,G0H24(48),34,nMT,G1H24(86),n2h24(84))
  Gcoeff(:)%j = (c(80)*M(3,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(618),h0tab(:,618),[34,4,16,1,8],[nMT,nMH,nMW,0,nMZ],5,1,wf4(:,12))
  call Hloop_ZQ_A(ntryL,G0H96(1),wf4(:,12),G0H24(48),ngZu,m3h4x24(:,105),heltab2x96(:,:,618))
  call Hloop_Q_A(ntryL,G0H24(48),34,nMT,G1H24(87),n2h24(85))
  Gcoeff(:)%j = (-(c(85)*M(2,:)%j)+c(86)*M(6,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(619),h0tab(:,619),[34,4,16,1,8],[nMT,nMH,nMW,0,0],5,1,wf4(:,12))
  call Hloop_VQ_A(ntryL,G0H96(1),wf4(:,12),G0H24(48),m3h4x24(:,106),heltab2x96(:,:,619))
  call Hloop_Q_A(ntryL,G0H24(48),34,nMT,G1H24(88),n2h24(86))
  Gcoeff(:)%j = (c(148)*M(3,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(620),h0tab(:,620),[34,4,16,1,8],[nMT,0,nMW,0,0],5,1,wf4(:,12))
  call Hloop_VQ_A(ntryL,G0H96(1),wf4(:,12),G0H24(48),m3h4x24(:,107),heltab2x96(:,:,620))
  call Hloop_Q_A(ntryL,G0H24(48),34,nMT,G1H24(89),n2h24(87))
  Gcoeff(:)%j = (-(c(154)*M(3,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(621),h0tab(:,621),[34,4,16,1,8],[nMT,0,nMW,0,nMZ],5,1,wf4(:,12))
  call Hloop_ZQ_A(ntryL,G0H96(1),wf4(:,12),G0H24(48),ngZu,m3h4x24(:,108),heltab2x96(:,:,621))
  call Hloop_Q_A(ntryL,G0H24(48),34,nMT,G1H24(90),n2h24(88))
  Gcoeff(:)%j = (c(127)*M(3,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(622),h0tab(:,622),[34,4,16,1,8],[nMT,nMZ,nMW,0,0],5,1,wf4(:,12))
  call Hloop_VQ_A(ntryL,G0H96(1),wf4(:,12),G0H24(48),m3h4x24(:,109),heltab2x96(:,:,622))
  call Hloop_Q_A(ntryL,G0H24(48),34,nMT,G1H24(91),n2h24(89))
  Gcoeff(:)%j = (-(c(131)*M(3,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(623),h0tab(:,623),[34,4,16,1,8],[nMT,nMZ,nMW,0,nMZ],5,1,wf4(:,12))
  call Hloop_ZQ_A(ntryL,G0H96(1),wf4(:,12),G0H24(48),ngZu,m3h4x24(:,110),heltab2x96(:,:,623))
  call Hloop_Q_A(ntryL,G0H24(48),34,nMT,G1H24(92),n2h24(90))
  Gcoeff(:)%j = (c(176)*M(2,:)%j-c(177)*M(6,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(624),h0tab(:,624),[34,4,16,1,8],[nMT,0,nMW,0,0],5,1,wf4(:,12))
  call Hloop_VQ_A(ntryL,G0H96(1),wf4(:,12),G0H24(48),m3h4x24(:,111),heltab2x96(:,:,624))
  call Hloop_Q_A(ntryL,G0H24(48),34,nMT,G1H24(93),n2h24(91))
  Gcoeff(:)%j = (c(134)*M(2,:)%j-c(135)*M(6,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(625),h0tab(:,625),[34,4,16,1,8],[nMT,nMZ,nMW,0,0],5,1,wf4(:,12))
  call Hloop_VQ_A(ntryL,G0H96(1),wf4(:,12),G0H24(48),m3h4x24(:,112),heltab2x96(:,:,625))
  call Hloop_Q_A(ntryL,G0H24(48),34,nMT,G1H24(94),n2h24(92))
  Gcoeff(:)%j = (-(c(107)*M(3,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(626),h0tab(:,626),[34,1,8,4,16],[0,0,nMW,nMB,nMT],5,1,wf4(:,12))
  call Hloop_AQ_V(ntryL,G0H96(1),wf4(:,12),G0H24(48),m3h4x24(:,113),heltab2x96(:,:,626))
  Gcoeff(:)%j = (-(c(109)*M(3,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(627),h0tab(:,627),[34,1,8,4,16],[nMZ,0,nMW,nMB,nMT],5,1,wf4(:,12))
  call Hloop_AQ_Z(ntryL,G0H96(1),wf4(:,12),G0H24(49),ngZu,m3h4x24(:,114),heltab2x96(:,:,627))
  Gcoeff(:)%j = (c(112)*M(2,:)%j-c(113)*M(6,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(628),h0tab(:,628),[34,1,8,4,16],[0,0,nMW,nMB,nMT],5,1,wf4(:,12))
  call Hloop_AQ_V(ntryL,G0H96(1),wf4(:,12),G0H24(50),m3h4x24(:,115),heltab2x96(:,:,628))
  Gcoeff(:)%j = (c(77)*M(3,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(629),h0tab(:,629),[34,1,8,16,4],[0,0,nMW,nMH,nMT],5,1,wf4(:,12))
  call Hloop_AQ_V(ntryL,G0H96(1),wf4(:,12),G0H24(51),m3h4x24(:,116),heltab2x96(:,:,629))
  Gcoeff(:)%j = (c(80)*M(3,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(630),h0tab(:,630),[34,1,8,16,4],[nMZ,0,nMW,nMH,nMT],5,1,wf4(:,12))
  call Hloop_AQ_Z(ntryL,G0H96(1),wf4(:,12),G0H24(52),ngZu,m3h4x24(:,117),heltab2x96(:,:,630))
  Gcoeff(:)%j = (-(c(85)*M(2,:)%j)+c(86)*M(6,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(631),h0tab(:,631),[34,1,8,16,4],[0,0,nMW,nMH,nMT],5,1,wf4(:,12))
  call Hloop_AQ_V(ntryL,G0H96(1),wf4(:,12),G0H24(53),m3h4x24(:,118),heltab2x96(:,:,631))
  Gcoeff(:)%j = (-(c(151)*M(3,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(632),h0tab(:,632),[34,1,8,16,4],[0,0,nMW,0,nMT],5,1,wf4(:,12))
  call Hloop_AQ_V(ntryL,G0H96(1),wf4(:,12),G0H24(54),m3h4x24(:,119),heltab2x96(:,:,632))
  Gcoeff(:)%j = (-(c(129)*M(3,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(633),h0tab(:,633),[34,1,8,16,4],[0,0,nMW,nMZ,nMT],5,1,wf4(:,12))
  call Hloop_AQ_V(ntryL,G0H96(1),wf4(:,12),G0H24(55),m3h4x24(:,120),heltab2x96(:,:,633))
  Gcoeff(:)%j = (-(c(154)*M(3,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(634),h0tab(:,634),[34,1,8,16,4],[nMZ,0,nMW,0,nMT],5,1,wf4(:,12))
  call Hloop_AQ_Z(ntryL,G0H96(1),wf4(:,12),G0H24(56),ngZu,m3h4x24(:,121),heltab2x96(:,:,634))
  Gcoeff(:)%j = (-(c(131)*M(3,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(635),h0tab(:,635),[34,1,8,16,4],[nMZ,0,nMW,nMZ,nMT],5,1,wf4(:,12))
  call Hloop_AQ_Z(ntryL,G0H96(1),wf4(:,12),G0H24(57),ngZu,m3h4x24(:,122),heltab2x96(:,:,635))
  Gcoeff(:)%j = (c(176)*M(2,:)%j-c(177)*M(6,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(636),h0tab(:,636),[34,1,8,16,4],[0,0,nMW,0,nMT],5,1,wf4(:,12))
  call Hloop_AQ_V(ntryL,G0H96(1),wf4(:,12),G0H24(58),m3h4x24(:,123),heltab2x96(:,:,636))
  Gcoeff(:)%j = (c(134)*M(2,:)%j-c(135)*M(6,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(637),h0tab(:,637),[34,1,8,16,4],[0,0,nMW,nMZ,nMT],5,1,wf4(:,12))
  call Hloop_AQ_V(ntryL,G0H96(1),wf4(:,12),G0H24(59),m3h4x24(:,124),heltab2x96(:,:,637))
  Gcoeff(:)%j = (c(146)*M(3,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(638),h0tab(:,638),[34,1,16,8,4],[0,0,0,0,nMT],5,1,wf4(:,12))
  call Hloop_AQ_V(ntryL,G0H96(1),wf4(:,12),G0H24(60),m3h4x24(:,125),heltab2x96(:,:,638))
  Gcoeff(:)%j = (-(c(153)*M(3,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(639),h0tab(:,639),[34,1,16,8,4],[0,0,0,nMZ,nMT],5,1,wf4(:,12))
  call Hloop_AQ_V(ntryL,G0H96(1),wf4(:,12),G0H24(61),m3h4x24(:,126),heltab2x96(:,:,639))
  Gcoeff(:)%j = (c(150)*M(3,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(640),h0tab(:,640),[34,1,16,8,4],[nMZ,0,0,0,nMT],5,1,wf4(:,12))
  call Hloop_AQ_Z(ntryL,G0H96(1),wf4(:,12),G0H24(62),ngZu,m3h4x24(:,127),heltab2x96(:,:,640))
  Gcoeff(:)%j = (-(c(155)*M(3,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(641),h0tab(:,641),[34,1,16,8,4],[nMZ,0,0,nMZ,nMT],5,1,wf4(:,12))
  call Hloop_AQ_Z(ntryL,G0H96(1),wf4(:,12),G0H24(63),ngZu,m3h4x24(:,128),heltab2x96(:,:,641))
  Gcoeff(:)%j = (c(173)*M(2,:)%j-c(174)*M(6,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(642),h0tab(:,642),[34,1,16,8,4],[0,0,0,0,nMT],5,1,wf4(:,12))
  call Hloop_AQ_V(ntryL,G0H96(1),wf4(:,12),G0H24(64),m3h4x24(:,129),heltab2x96(:,:,642))
  Gcoeff(:)%j = (-(c(168)*M(2,:)%j)+c(169)*M(6,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(643),h0tab(:,643),[34,1,16,8,4],[0,0,0,0,nMT],5,1,wf4(:,12))
  call Hloop_AQ_V(ntryL,G0H96(1),wf4(:,12),G0H24(65),m3h4x24(:,130),heltab2x96(:,:,643))
  Gcoeff(:)%j = (c(179)*M(2,:)%j-c(180)*M(6,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(644),h0tab(:,644),[34,1,16,8,4],[nMZ,0,0,0,nMT],5,1,wf4(:,12))
  call Hloop_AQ_Z(ntryL,G0H96(1),wf4(:,12),G0H24(66),ngZu,m3h4x24(:,131),heltab2x96(:,:,644))
  Gcoeff(:)%j = (c(179)*M(2,:)%j-c(180)*M(6,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(645),h0tab(:,645),[34,1,16,8,4],[0,0,0,nMZ,nMT],5,1,wf4(:,12))
  call Hloop_AQ_V(ntryL,G0H96(1),wf4(:,12),G0H24(67),m3h4x24(:,132),heltab2x96(:,:,645))
  Gcoeff(:)%j = (-(c(107)*M(3,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(646),h0tab(:,646),[36,8,1,2,16],[nMW,0,0,nMT,nMB],5,1,wf4(:,10))
  call Hloop_QA_W(ntryL,G0H96(1),wf4(:,10),G0H24(68),m3h4x24(:,133),heltab2x96(:,:,646))
  Gcoeff(:)%j = (-(c(109)*M(3,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(647),h0tab(:,647),[36,8,1,2,16],[nMW,0,nMZ,nMT,nMB],5,1,wf4(:,10))
  call Hloop_QA_W(ntryL,G0H96(1),wf4(:,10),G0H24(69),m3h4x24(:,134),heltab2x96(:,:,647))
  Gcoeff(:)%j = (-(c(113)*M(1,:)%j)+c(112)*M(2,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(648),h0tab(:,648),[36,8,1,2,16],[nMW,0,0,nMT,nMB],5,1,wf4(:,10))
  call Hloop_QA_W(ntryL,G0H96(1),wf4(:,10),G0H24(70),m3h4x24(:,135),heltab2x96(:,:,648))
  Gcoeff(:)%j = (c(77)*M(3,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(649),h0tab(:,649),[36,2,1,8,16],[nMT,0,0,nMW,nMH],5,1,wf4(:,10))
  call Hloop_SA_Q(ntryL,G0H96(1),wf4(:,10),G0H24(71),ngH,m3h4x24(:,136),heltab2x96(:,:,649))
  call Hloop_A_Q(ntryL,G0H24(71),36,nMT,G1H24(95),n2h24(93))
  Gcoeff(:)%j = (c(80)*M(3,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(650),h0tab(:,650),[36,2,1,8,16],[nMT,nMZ,0,nMW,nMH],5,1,wf4(:,10))
  call Hloop_SA_Q(ntryL,G0H96(1),wf4(:,10),G0H24(71),ngH,m3h4x24(:,137),heltab2x96(:,:,650))
  call Hloop_A_Q(ntryL,G0H24(71),36,nMT,G1H24(96),n2h24(94))
  Gcoeff(:)%j = (c(86)*M(1,:)%j-c(85)*M(2,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(651),h0tab(:,651),[36,2,1,8,16],[nMT,0,0,nMW,nMH],5,1,wf4(:,10))
  call Hloop_SA_Q(ntryL,G0H96(1),wf4(:,10),G0H24(71),ngH,m3h4x24(:,138),heltab2x96(:,:,651))
  call Hloop_A_Q(ntryL,G0H24(71),36,nMT,G1H24(97),n2h24(95))
  Gcoeff(:)%j = (-(c(151)*M(3,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(652),h0tab(:,652),[36,2,1,8,16],[nMT,0,0,nMW,0],5,1,wf4(:,10))
  call Hloop_VA_Q(ntryL,G0H96(1),wf4(:,10),G0H24(71),m3h4x24(:,139),heltab2x96(:,:,652))
  call Hloop_A_Q(ntryL,G0H24(71),36,nMT,G1H24(98),n2h24(96))
  Gcoeff(:)%j = (-(c(129)*M(3,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(653),h0tab(:,653),[36,2,1,8,16],[nMT,0,0,nMW,nMZ],5,1,wf4(:,10))
  call Hloop_ZA_Q(ntryL,G0H96(1),wf4(:,10),G0H24(71),ngZu,m3h4x24(:,140),heltab2x96(:,:,653))
  call Hloop_A_Q(ntryL,G0H24(71),36,nMT,G1H24(99),n2h24(97))
  Gcoeff(:)%j = (-(c(154)*M(3,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(654),h0tab(:,654),[36,2,1,8,16],[nMT,nMZ,0,nMW,0],5,1,wf4(:,10))
  call Hloop_VA_Q(ntryL,G0H96(1),wf4(:,10),G0H24(71),m3h4x24(:,141),heltab2x96(:,:,654))
  call Hloop_A_Q(ntryL,G0H24(71),36,nMT,G1H24(100),n2h24(98))
  Gcoeff(:)%j = (-(c(131)*M(3,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(655),h0tab(:,655),[36,2,1,8,16],[nMT,nMZ,0,nMW,nMZ],5,1,wf4(:,10))
  call Hloop_ZA_Q(ntryL,G0H96(1),wf4(:,10),G0H24(71),ngZu,m3h4x24(:,142),heltab2x96(:,:,655))
  call Hloop_A_Q(ntryL,G0H24(71),36,nMT,G1H24(101),n2h24(99))
  Gcoeff(:)%j = (-(c(177)*M(1,:)%j)+c(176)*M(2,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(656),h0tab(:,656),[36,2,1,8,16],[nMT,0,0,nMW,0],5,1,wf4(:,10))
  call Hloop_VA_Q(ntryL,G0H96(1),wf4(:,10),G0H24(71),m3h4x24(:,143),heltab2x96(:,:,656))
  call Hloop_A_Q(ntryL,G0H24(71),36,nMT,G1H24(1),n2h24(100))
  Gcoeff(:)%j = (-(c(135)*M(1,:)%j)+c(134)*M(2,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(657),h0tab(:,657),[36,2,1,8,16],[nMT,0,0,nMW,nMZ],5,1,wf4(:,10))
  call Hloop_ZA_Q(ntryL,G0H96(1),wf4(:,10),G0H24(71),ngZu,m3h4x24(:,144),heltab2x96(:,:,657))
  call Hloop_A_Q(ntryL,G0H24(71),36,nMT,G1H24(3),n2h24(101))
  Gcoeff(:)%j = (c(146)*M(3,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(658),h0tab(:,658),[36,2,1,16,8],[nMT,0,0,0,0],5,1,wf4(:,10))
  call Hloop_VA_Q(ntryL,G0H96(1),wf4(:,10),G0H24(71),m3h4x24(:,145),heltab2x96(:,:,658))
  call Hloop_A_Q(ntryL,G0H24(71),36,nMT,G1H24(4),n2h24(102))
  Gcoeff(:)%j = (-(c(153)*M(3,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(659),h0tab(:,659),[36,2,1,16,8],[nMT,0,0,0,nMZ],5,1,wf4(:,10))
  call Hloop_ZA_Q(ntryL,G0H96(1),wf4(:,10),G0H24(71),ngZu,m3h4x24(:,146),heltab2x96(:,:,659))
  call Hloop_A_Q(ntryL,G0H24(71),36,nMT,G1H24(5),n2h24(103))
  Gcoeff(:)%j = (c(150)*M(3,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(660),h0tab(:,660),[36,2,1,16,8],[nMT,nMZ,0,0,0],5,1,wf4(:,10))
  call Hloop_VA_Q(ntryL,G0H96(1),wf4(:,10),G0H24(71),m3h4x24(:,147),heltab2x96(:,:,660))
  call Hloop_A_Q(ntryL,G0H24(71),36,nMT,G1H24(6),n2h24(104))
  Gcoeff(:)%j = (-(c(155)*M(3,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(661),h0tab(:,661),[36,2,1,16,8],[nMT,nMZ,0,0,nMZ],5,1,wf4(:,10))
  call Hloop_ZA_Q(ntryL,G0H96(1),wf4(:,10),G0H24(71),ngZu,m3h4x24(:,148),heltab2x96(:,:,661))
  call Hloop_A_Q(ntryL,G0H24(71),36,nMT,G1H24(7),n2h24(105))
  Gcoeff(:)%j = (-(c(174)*M(1,:)%j)+c(173)*M(2,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(662),h0tab(:,662),[36,2,1,16,8],[nMT,0,0,0,0],5,1,wf4(:,10))
  call Hloop_VA_Q(ntryL,G0H96(1),wf4(:,10),G0H24(71),m3h4x24(:,149),heltab2x96(:,:,662))
  call Hloop_A_Q(ntryL,G0H24(71),36,nMT,G1H24(9),n2h24(106))
  Gcoeff(:)%j = (c(169)*M(1,:)%j-c(168)*M(2,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(663),h0tab(:,663),[36,2,1,16,8],[nMT,0,0,0,0],5,1,wf4(:,10))
  call Hloop_VA_Q(ntryL,G0H96(1),wf4(:,10),G0H24(71),m3h4x24(:,150),heltab2x96(:,:,663))
  call Hloop_A_Q(ntryL,G0H24(71),36,nMT,G1H24(10),n2h24(107))
  Gcoeff(:)%j = (-(c(180)*M(1,:)%j)+c(179)*M(2,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(664),h0tab(:,664),[36,2,1,16,8],[nMT,nMZ,0,0,0],5,1,wf4(:,10))
  call Hloop_VA_Q(ntryL,G0H96(1),wf4(:,10),G0H24(71),m3h4x24(:,151),heltab2x96(:,:,664))
  call Hloop_A_Q(ntryL,G0H24(71),36,nMT,G1H24(11),n2h24(108))
  Gcoeff(:)%j = (-(c(180)*M(1,:)%j)+c(179)*M(2,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(665),h0tab(:,665),[36,2,1,16,8],[nMT,0,0,0,nMZ],5,1,wf4(:,10))
  call Hloop_ZA_Q(ntryL,G0H96(1),wf4(:,10),G0H24(71),ngZu,m3h4x24(:,152),heltab2x96(:,:,665))
  call Hloop_A_Q(ntryL,G0H24(71),36,nMT,G1H24(12),n2h24(109))
  Gcoeff(:)%j = (-(c(75)*M(3,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(666),h0tab(:,666),[36,2,8,1,16],[nMT,0,0,nMW,nMH],5,1,wf4(:,10))
  call Hloop_SA_Q(ntryL,G0H96(1),wf4(:,10),G0H24(71),ngH,m3h4x24(:,153),heltab2x96(:,:,666))
  call Hloop_A_Q(ntryL,G0H24(71),36,nMT,G1H24(13),n2h24(110))
  Gcoeff(:)%j = (c(80)*M(3,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(667),h0tab(:,667),[36,2,8,1,16],[nMT,nMZ,0,nMW,nMH],5,1,wf4(:,10))
  call Hloop_SA_Q(ntryL,G0H96(1),wf4(:,10),G0H24(71),ngH,m3h4x24(:,154),heltab2x96(:,:,667))
  call Hloop_A_Q(ntryL,G0H24(71),36,nMT,G1H24(15),n2h24(111))
  Gcoeff(:)%j = (c(86)*M(1,:)%j-c(85)*M(2,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(668),h0tab(:,668),[36,2,8,1,16],[nMT,0,0,nMW,nMH],5,1,wf4(:,10))
  call Hloop_SA_Q(ntryL,G0H96(1),wf4(:,10),G0H24(71),ngH,m3h4x24(:,155),heltab2x96(:,:,668))
  call Hloop_A_Q(ntryL,G0H24(71),36,nMT,G1H24(16),n2h24(112))
  Gcoeff(:)%j = (c(148)*M(3,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(669),h0tab(:,669),[36,2,8,1,16],[nMT,0,0,nMW,0],5,1,wf4(:,10))
  call Hloop_VA_Q(ntryL,G0H96(1),wf4(:,10),G0H24(71),m3h4x24(:,156),heltab2x96(:,:,669))
  call Hloop_A_Q(ntryL,G0H24(71),36,nMT,G1H24(17),n2h24(113))
  Gcoeff(:)%j = (c(127)*M(3,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(670),h0tab(:,670),[36,2,8,1,16],[nMT,0,0,nMW,nMZ],5,1,wf4(:,10))
  call Hloop_ZA_Q(ntryL,G0H96(1),wf4(:,10),G0H24(71),ngZu,m3h4x24(:,157),heltab2x96(:,:,670))
  call Hloop_A_Q(ntryL,G0H24(71),36,nMT,G1H24(18),n2h24(114))
  Gcoeff(:)%j = (-(c(154)*M(3,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(671),h0tab(:,671),[36,2,8,1,16],[nMT,nMZ,0,nMW,0],5,1,wf4(:,10))
  call Hloop_VA_Q(ntryL,G0H96(1),wf4(:,10),G0H24(71),m3h4x24(:,158),heltab2x96(:,:,671))
  call Hloop_A_Q(ntryL,G0H24(71),36,nMT,G1H24(19),n2h24(115))
  Gcoeff(:)%j = (-(c(131)*M(3,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(672),h0tab(:,672),[36,2,8,1,16],[nMT,nMZ,0,nMW,nMZ],5,1,wf4(:,10))
  call Hloop_ZA_Q(ntryL,G0H96(1),wf4(:,10),G0H24(71),ngZu,m3h4x24(:,159),heltab2x96(:,:,672))
  call Hloop_A_Q(ntryL,G0H24(71),36,nMT,G1H24(21),n2h24(116))
  Gcoeff(:)%j = (-(c(177)*M(1,:)%j)+c(176)*M(2,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(673),h0tab(:,673),[36,2,8,1,16],[nMT,0,0,nMW,0],5,1,wf4(:,10))
  call Hloop_VA_Q(ntryL,G0H96(1),wf4(:,10),G0H24(71),m3h4x24(:,160),heltab2x96(:,:,673))
  call Hloop_A_Q(ntryL,G0H24(71),36,nMT,G1H24(22),n2h24(117))
  Gcoeff(:)%j = (-(c(135)*M(1,:)%j)+c(134)*M(2,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(674),h0tab(:,674),[36,2,8,1,16],[nMT,0,0,nMW,nMZ],5,1,wf4(:,10))
  call Hloop_ZA_Q(ntryL,G0H96(1),wf4(:,10),G0H24(71),ngZu,m3h4x24(:,161),heltab2x96(:,:,674))
  call Hloop_A_Q(ntryL,G0H24(71),36,nMT,G1H24(23),n2h24(118))
  Gcoeff(:)%j = (-(c(75)*M(3,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(675),h0tab(:,675),[36,2,16,1,8],[nMT,nMH,nMW,0,0],5,1,wf4(:,10))
  call Hloop_VA_Q(ntryL,G0H96(1),wf4(:,10),G0H24(71),m3h4x24(:,162),heltab2x96(:,:,675))
  call Hloop_A_Q(ntryL,G0H24(71),36,nMT,G1H24(24),n2h24(119))
  Gcoeff(:)%j = (c(108)*M(3,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(676),h0tab(:,676),[36,2,16,1,8],[nMB,nMW,0,0,nMW],5,1,wf4(:,10))
  call Hloop_WA_Q(ntryL,G0H96(1),wf4(:,10),G0H24(71),m3h4x24(:,163),heltab2x96(:,:,676))
  call Hloop_A_Q(ntryL,G0H24(71),36,nMB,G1H24(25),n2h24(120))
  Gcoeff(:)%j = (c(80)*M(3,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(677),h0tab(:,677),[36,2,16,1,8],[nMT,nMH,nMW,0,nMZ],5,1,wf4(:,10))
  call Hloop_ZA_Q(ntryL,G0H96(1),wf4(:,10),G0H24(71),ngZu,m3h4x24(:,164),heltab2x96(:,:,677))
  call Hloop_A_Q(ntryL,G0H24(71),36,nMT,G1H24(27),n2h24(121))
  Gcoeff(:)%j = (-(c(142)*M(3,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(678),h0tab(:,678),[36,2,16,1,8],[nMB,nMW,nMZ,0,nMW],5,1,wf4(:,10))
  call Hloop_WA_Q(ntryL,G0H96(1),wf4(:,10),G0H24(71),m3h4x24(:,165),heltab2x96(:,:,678))
  call Hloop_A_Q(ntryL,G0H24(71),36,nMB,G1H24(28),n2h24(122))
  Gcoeff(:)%j = (c(86)*M(1,:)%j-c(85)*M(2,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(679),h0tab(:,679),[36,2,16,1,8],[nMT,nMH,nMW,0,0],5,1,wf4(:,10))
  call Hloop_VA_Q(ntryL,G0H96(1),wf4(:,10),G0H24(71),m3h4x24(:,166),heltab2x96(:,:,679))
  call Hloop_A_Q(ntryL,G0H24(71),36,nMT,G1H24(29),n2h24(123))
  Gcoeff(:)%j = (c(148)*M(3,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(680),h0tab(:,680),[36,2,16,1,8],[nMT,0,nMW,0,0],5,1,wf4(:,10))
  call Hloop_VA_Q(ntryL,G0H96(1),wf4(:,10),G0H24(71),m3h4x24(:,167),heltab2x96(:,:,680))
  call Hloop_A_Q(ntryL,G0H24(71),36,nMT,G1H24(102),n2h24(124))
  Gcoeff(:)%j = (-(c(154)*M(3,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(681),h0tab(:,681),[36,2,16,1,8],[nMT,0,nMW,0,nMZ],5,1,wf4(:,10))
  call Hloop_ZA_Q(ntryL,G0H96(1),wf4(:,10),G0H24(71),ngZu,m3h4x24(:,168),heltab2x96(:,:,681))
  call Hloop_A_Q(ntryL,G0H24(71),36,nMT,G1H24(103),n2h24(125))
  Gcoeff(:)%j = (c(127)*M(3,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(682),h0tab(:,682),[36,2,16,1,8],[nMT,nMZ,nMW,0,0],5,1,wf4(:,10))
  call Hloop_VA_Q(ntryL,G0H96(1),wf4(:,10),G0H24(71),m3h4x24(:,169),heltab2x96(:,:,682))
  call Hloop_A_Q(ntryL,G0H24(71),36,nMT,G1H24(104),n2h24(126))
  Gcoeff(:)%j = (-(c(131)*M(3,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(683),h0tab(:,683),[36,2,16,1,8],[nMT,nMZ,nMW,0,nMZ],5,1,wf4(:,10))
  call Hloop_ZA_Q(ntryL,G0H96(1),wf4(:,10),G0H24(71),ngZu,m3h4x24(:,170),heltab2x96(:,:,683))
  call Hloop_A_Q(ntryL,G0H24(71),36,nMT,G1H24(105),n2h24(127))
  Gcoeff(:)%j = (-(c(108)*M(3,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(684),h0tab(:,684),[36,2,16,1,8],[nMB,nMW,0,0,nMW],5,1,wf4(:,10))
  call Hloop_WA_Q(ntryL,G0H96(1),wf4(:,10),G0H24(71),m3h4x24(:,171),heltab2x96(:,:,684))
  call Hloop_A_Q(ntryL,G0H24(71),36,nMB,G1H24(106),n2h24(128))
  Gcoeff(:)%j = (-(c(63)*M(3,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(685),h0tab(:,685),[36,2,16,1,8],[nMB,nMW,nMZ,0,nMW],5,1,wf4(:,10))
  call Hloop_WA_Q(ntryL,G0H96(1),wf4(:,10),G0H24(71),m3h4x24(:,172),heltab2x96(:,:,685))
  call Hloop_A_Q(ntryL,G0H24(71),36,nMB,G1H24(107),n2h24(129))
  Gcoeff(:)%j = (-(c(177)*M(1,:)%j)+c(176)*M(2,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(686),h0tab(:,686),[36,2,16,1,8],[nMT,0,nMW,0,0],5,1,wf4(:,10))
  call Hloop_VA_Q(ntryL,G0H96(1),wf4(:,10),G0H24(71),m3h4x24(:,173),heltab2x96(:,:,686))
  call Hloop_A_Q(ntryL,G0H24(71),36,nMT,G1H24(108),n2h24(130))
  Gcoeff(:)%j = (-(c(135)*M(1,:)%j)+c(134)*M(2,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(687),h0tab(:,687),[36,2,16,1,8],[nMT,nMZ,nMW,0,0],5,1,wf4(:,10))
  call Hloop_VA_Q(ntryL,G0H96(1),wf4(:,10),G0H24(71),m3h4x24(:,174),heltab2x96(:,:,687))
  call Hloop_A_Q(ntryL,G0H24(71),36,nMT,G1H24(109),n2h24(131))
  Gcoeff(:)%j = (c(105)*M(3,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(688),h0tab(:,688),[36,1,8,2,16],[nMW,0,0,nMT,nMB],5,1,wf4(:,10))
  call Hloop_QA_W(ntryL,G0H96(1),wf4(:,10),G0H24(71),m3h4x24(:,175),heltab2x96(:,:,688))
  Gcoeff(:)%j = (-(c(109)*M(3,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(689),h0tab(:,689),[36,1,8,2,16],[nMW,0,nMZ,nMT,nMB],5,1,wf4(:,10))
  call Hloop_QA_W(ntryL,G0H96(1),wf4(:,10),G0H24(72),m3h4x24(:,176),heltab2x96(:,:,689))
  Gcoeff(:)%j = (-(c(113)*M(1,:)%j)+c(112)*M(2,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(690),h0tab(:,690),[36,1,8,2,16],[nMW,0,0,nMT,nMB],5,1,wf4(:,10))
  call Hloop_QA_W(ntryL,G0H96(1),wf4(:,10),G0H24(73),m3h4x24(:,177),heltab2x96(:,:,690))
  Gcoeff(:)%j = (c(77)*M(3,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(691),h0tab(:,691),[36,1,8,16,2],[0,0,nMW,nMH,nMT],5,1,wf4(:,10))
  call Hloop_QA_V(ntryL,G0H96(1),wf4(:,10),G0H24(74),m3h4x24(:,178),heltab2x96(:,:,691))
  Gcoeff(:)%j = (-(c(106)*M(3,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(692),h0tab(:,692),[36,1,8,16,2],[nMW,0,0,nMW,nMB],5,1,wf4(:,10))
  call Hloop_QA_W(ntryL,G0H96(1),wf4(:,10),G0H24(75),m3h4x24(:,179),heltab2x96(:,:,692))
  Gcoeff(:)%j = (c(80)*M(3,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(693),h0tab(:,693),[36,1,8,16,2],[nMZ,0,nMW,nMH,nMT],5,1,wf4(:,10))
  call Hloop_QA_Z(ntryL,G0H96(1),wf4(:,10),G0H24(76),ngZu,m3h4x24(:,180),heltab2x96(:,:,693))
  Gcoeff(:)%j = (-(c(142)*M(3,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(694),h0tab(:,694),[36,1,8,16,2],[nMW,0,nMZ,nMW,nMB],5,1,wf4(:,10))
  call Hloop_QA_W(ntryL,G0H96(1),wf4(:,10),G0H24(77),m3h4x24(:,181),heltab2x96(:,:,694))
  Gcoeff(:)%j = (c(86)*M(1,:)%j-c(85)*M(2,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(695),h0tab(:,695),[36,1,8,16,2],[0,0,nMW,nMH,nMT],5,1,wf4(:,10))
  call Hloop_QA_V(ntryL,G0H96(1),wf4(:,10),G0H24(78),m3h4x24(:,182),heltab2x96(:,:,695))
  Gcoeff(:)%j = (-(c(151)*M(3,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(696),h0tab(:,696),[36,1,8,16,2],[0,0,nMW,0,nMT],5,1,wf4(:,10))
  call Hloop_QA_V(ntryL,G0H96(1),wf4(:,10),G0H24(79),m3h4x24(:,183),heltab2x96(:,:,696))
  Gcoeff(:)%j = (-(c(129)*M(3,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(697),h0tab(:,697),[36,1,8,16,2],[0,0,nMW,nMZ,nMT],5,1,wf4(:,10))
  call Hloop_QA_V(ntryL,G0H96(1),wf4(:,10),G0H24(80),m3h4x24(:,184),heltab2x96(:,:,697))
  Gcoeff(:)%j = (-(c(154)*M(3,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(698),h0tab(:,698),[36,1,8,16,2],[nMZ,0,nMW,0,nMT],5,1,wf4(:,10))
  call Hloop_QA_Z(ntryL,G0H96(1),wf4(:,10),G0H24(81),ngZu,m3h4x24(:,185),heltab2x96(:,:,698))
  Gcoeff(:)%j = (-(c(131)*M(3,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(699),h0tab(:,699),[36,1,8,16,2],[nMZ,0,nMW,nMZ,nMT],5,1,wf4(:,10))
  call Hloop_QA_Z(ntryL,G0H96(1),wf4(:,10),G0H24(82),ngZu,m3h4x24(:,186),heltab2x96(:,:,699))
  Gcoeff(:)%j = (c(106)*M(3,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(700),h0tab(:,700),[36,1,8,16,2],[nMW,0,0,nMW,nMB],5,1,wf4(:,10))
  call Hloop_QA_W(ntryL,G0H96(1),wf4(:,10),G0H24(83),m3h4x24(:,187),heltab2x96(:,:,700))
  Gcoeff(:)%j = (-(c(63)*M(3,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(701),h0tab(:,701),[36,1,8,16,2],[nMW,0,nMZ,nMW,nMB],5,1,wf4(:,10))
  call Hloop_QA_W(ntryL,G0H96(1),wf4(:,10),G0H24(84),m3h4x24(:,188),heltab2x96(:,:,701))
  Gcoeff(:)%j = (-(c(177)*M(1,:)%j)+c(176)*M(2,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(702),h0tab(:,702),[36,1,8,16,2],[0,0,nMW,0,nMT],5,1,wf4(:,10))
  call Hloop_QA_V(ntryL,G0H96(1),wf4(:,10),G0H24(85),m3h4x24(:,189),heltab2x96(:,:,702))
  Gcoeff(:)%j = (-(c(135)*M(1,:)%j)+c(134)*M(2,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(703),h0tab(:,703),[36,1,8,16,2],[0,0,nMW,nMZ,nMT],5,1,wf4(:,10))
  call Hloop_QA_V(ntryL,G0H96(1),wf4(:,10),G0H24(86),m3h4x24(:,190),heltab2x96(:,:,703))
  Gcoeff(:)%j = (c(146)*M(3,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(704),h0tab(:,704),[36,1,16,8,2],[0,0,0,0,nMT],5,1,wf4(:,10))
  call Hloop_QA_V(ntryL,G0H96(1),wf4(:,10),G0H24(87),m3h4x24(:,191),heltab2x96(:,:,704))
  Gcoeff(:)%j = (-(c(153)*M(3,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(705),h0tab(:,705),[36,1,16,8,2],[0,0,0,nMZ,nMT],5,1,wf4(:,10))
  call Hloop_QA_V(ntryL,G0H96(1),wf4(:,10),G0H24(88),m3h4x24(:,192),heltab2x96(:,:,705))
  Gcoeff(:)%j = (c(150)*M(3,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(706),h0tab(:,706),[36,1,16,8,2],[nMZ,0,0,0,nMT],5,1,wf4(:,10))
  call Hloop_QA_Z(ntryL,G0H96(1),wf4(:,10),G0H24(89),ngZu,m3h4x24(:,193),heltab2x96(:,:,706))
  Gcoeff(:)%j = (-(c(155)*M(3,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(707),h0tab(:,707),[36,1,16,8,2],[nMZ,0,0,nMZ,nMT],5,1,wf4(:,10))
  call Hloop_QA_Z(ntryL,G0H96(1),wf4(:,10),G0H24(90),ngZu,m3h4x24(:,194),heltab2x96(:,:,707))
  Gcoeff(:)%j = (-(c(174)*M(1,:)%j)+c(173)*M(2,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(708),h0tab(:,708),[36,1,16,8,2],[0,0,0,0,nMT],5,1,wf4(:,10))
  call Hloop_QA_V(ntryL,G0H96(1),wf4(:,10),G0H24(91),m3h4x24(:,195),heltab2x96(:,:,708))
  Gcoeff(:)%j = (c(169)*M(1,:)%j-c(168)*M(2,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(709),h0tab(:,709),[36,1,16,8,2],[0,0,0,0,nMT],5,1,wf4(:,10))
  call Hloop_QA_V(ntryL,G0H96(1),wf4(:,10),G0H24(92),m3h4x24(:,196),heltab2x96(:,:,709))
  Gcoeff(:)%j = (-(c(180)*M(1,:)%j)+c(179)*M(2,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(710),h0tab(:,710),[36,1,16,8,2],[nMZ,0,0,0,nMT],5,1,wf4(:,10))
  call Hloop_QA_Z(ntryL,G0H96(1),wf4(:,10),G0H24(93),ngZu,m3h4x24(:,197),heltab2x96(:,:,710))
  Gcoeff(:)%j = (-(c(180)*M(1,:)%j)+c(179)*M(2,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(711),h0tab(:,711),[36,1,16,8,2],[0,0,0,nMZ,nMT],5,1,wf4(:,10))
  call Hloop_QA_V(ntryL,G0H96(1),wf4(:,10),G0H24(94),m3h4x24(:,198),heltab2x96(:,:,711))
  Gcoeff(:)%j = (c(146)*M(5,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(712),h0tab(:,712),[40,4,2,1,16],[0,nMT,0,0,0],5,1,wf4(:,3))
  call Hloop_QA_V(ntryL,G0H96(1),wf4(:,3),G0H24(95),m3h4x24(:,199),heltab2x96(:,:,712))
  Gcoeff(:)%j = (-(c(153)*M(5,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(713),h0tab(:,713),[40,4,2,1,16],[nMZ,nMT,0,0,0],5,1,wf4(:,3))
  call Hloop_QA_Z(ntryL,G0H96(1),wf4(:,3),G0H24(96),ngZd,m3h4x24(:,200),heltab2x96(:,:,713))
  Gcoeff(:)%j = (c(150)*M(5,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(714),h0tab(:,714),[40,4,2,1,16],[0,nMT,nMZ,0,0],5,1,wf4(:,3))
  call Hloop_QA_V(ntryL,G0H96(1),wf4(:,3),G0H24(97),m3h4x24(:,201),heltab2x96(:,:,714))
  Gcoeff(:)%j = (-(c(155)*M(5,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(715),h0tab(:,715),[40,4,2,1,16],[nMZ,nMT,nMZ,0,0],5,1,wf4(:,3))
  call Hloop_QA_Z(ntryL,G0H96(1),wf4(:,3),G0H24(98),ngZd,m3h4x24(:,202),heltab2x96(:,:,715))
  Gcoeff(:)%j = (c(173)*M(4,:)%j-c(174)*M(6,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(716),h0tab(:,716),[40,4,2,1,16],[0,nMT,0,0,0],5,1,wf4(:,3))
  call Hloop_QA_V(ntryL,G0H96(1),wf4(:,3),G0H24(99),m3h4x24(:,203),heltab2x96(:,:,716))
  Gcoeff(:)%j = (-(c(168)*M(4,:)%j)+c(169)*M(6,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(717),h0tab(:,717),[40,4,2,1,16],[0,nMT,0,0,0],5,1,wf4(:,3))
  call Hloop_QA_V(ntryL,G0H96(1),wf4(:,3),G0H24(100),m3h4x24(:,204),heltab2x96(:,:,717))
  Gcoeff(:)%j = (c(179)*M(4,:)%j-c(180)*M(6,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(718),h0tab(:,718),[40,4,2,1,16],[0,nMT,nMZ,0,0],5,1,wf4(:,3))
  call Hloop_QA_V(ntryL,G0H96(1),wf4(:,3),G0H24(101),m3h4x24(:,205),heltab2x96(:,:,718))
  Gcoeff(:)%j = (c(179)*M(4,:)%j-c(180)*M(6,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(719),h0tab(:,719),[40,4,2,1,16],[nMZ,nMT,0,0,0],5,1,wf4(:,3))
  call Hloop_QA_Z(ntryL,G0H96(1),wf4(:,3),G0H24(102),ngZd,m3h4x24(:,206),heltab2x96(:,:,719))
  Gcoeff(:)%j = (c(77)*M(5,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(720),h0tab(:,720),[40,1,2,4,16],[0,0,nMT,nMH,nMW],5,1,wf4(:,3))
  call Hloop_WA_Q(ntryL,G0H96(1),wf4(:,3),G0H24(103),m3h4x24(:,207),heltab2x96(:,:,720))
  call Hloop_A_Q(ntryL,G0H24(103),40,0,G1H24(110),n2h24(132))
  Gcoeff(:)%j = (c(80)*M(5,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(721),h0tab(:,721),[40,1,2,4,16],[0,nMZ,nMT,nMH,nMW],5,1,wf4(:,3))
  call Hloop_WA_Q(ntryL,G0H96(1),wf4(:,3),G0H24(103),m3h4x24(:,208),heltab2x96(:,:,721))
  call Hloop_A_Q(ntryL,G0H24(103),40,0,G1H24(111),n2h24(133))
  Gcoeff(:)%j = (-(c(85)*M(4,:)%j)+c(86)*M(6,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(722),h0tab(:,722),[40,1,2,4,16],[0,0,nMT,nMH,nMW],5,1,wf4(:,3))
  call Hloop_WA_Q(ntryL,G0H96(1),wf4(:,3),G0H24(103),m3h4x24(:,209),heltab2x96(:,:,722))
  call Hloop_A_Q(ntryL,G0H24(103),40,0,G1H24(112),n2h24(134))
  Gcoeff(:)%j = (-(c(151)*M(5,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(723),h0tab(:,723),[40,1,2,4,16],[0,0,nMT,0,nMW],5,1,wf4(:,3))
  call Hloop_WA_Q(ntryL,G0H96(1),wf4(:,3),G0H24(103),m3h4x24(:,210),heltab2x96(:,:,723))
  call Hloop_A_Q(ntryL,G0H24(103),40,0,G1H24(113),n2h24(135))
  Gcoeff(:)%j = (-(c(129)*M(5,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(724),h0tab(:,724),[40,1,2,4,16],[0,0,nMT,nMZ,nMW],5,1,wf4(:,3))
  call Hloop_WA_Q(ntryL,G0H96(1),wf4(:,3),G0H24(103),m3h4x24(:,211),heltab2x96(:,:,724))
  call Hloop_A_Q(ntryL,G0H24(103),40,0,G1H24(114),n2h24(136))
  Gcoeff(:)%j = (-(c(154)*M(5,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(725),h0tab(:,725),[40,1,2,4,16],[0,nMZ,nMT,0,nMW],5,1,wf4(:,3))
  call Hloop_WA_Q(ntryL,G0H96(1),wf4(:,3),G0H24(103),m3h4x24(:,212),heltab2x96(:,:,725))
  call Hloop_A_Q(ntryL,G0H24(103),40,0,G1H24(115),n2h24(137))
  Gcoeff(:)%j = (-(c(131)*M(5,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(726),h0tab(:,726),[40,1,2,4,16],[0,nMZ,nMT,nMZ,nMW],5,1,wf4(:,3))
  call Hloop_WA_Q(ntryL,G0H96(1),wf4(:,3),G0H24(103),m3h4x24(:,213),heltab2x96(:,:,726))
  call Hloop_A_Q(ntryL,G0H24(103),40,0,G1H24(116),n2h24(138))
  Gcoeff(:)%j = (c(176)*M(4,:)%j-c(177)*M(6,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(727),h0tab(:,727),[40,1,2,4,16],[0,0,nMT,0,nMW],5,1,wf4(:,3))
  call Hloop_WA_Q(ntryL,G0H96(1),wf4(:,3),G0H24(103),m3h4x24(:,214),heltab2x96(:,:,727))
  call Hloop_A_Q(ntryL,G0H24(103),40,0,G1H24(117),n2h24(139))
  Gcoeff(:)%j = (c(134)*M(4,:)%j-c(135)*M(6,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(728),h0tab(:,728),[40,1,2,4,16],[0,0,nMT,nMZ,nMW],5,1,wf4(:,3))
  call Hloop_WA_Q(ntryL,G0H96(1),wf4(:,3),G0H24(103),m3h4x24(:,215),heltab2x96(:,:,728))
  call Hloop_A_Q(ntryL,G0H24(103),40,0,G1H24(118),n2h24(140))
  Gcoeff(:)%j = (-(c(107)*M(5,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(729),h0tab(:,729),[40,1,2,16,4],[0,0,nMT,nMB,nMW],5,1,wf4(:,3))
  call Hloop_WA_Q(ntryL,G0H96(1),wf4(:,3),G0H24(103),m3h4x24(:,216),heltab2x96(:,:,729))
  call Hloop_A_Q(ntryL,G0H24(103),40,0,G1H24(119),n2h24(141))
  Gcoeff(:)%j = (-(c(109)*M(5,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(730),h0tab(:,730),[40,1,2,16,4],[0,nMZ,nMT,nMB,nMW],5,1,wf4(:,3))
  call Hloop_WA_Q(ntryL,G0H96(1),wf4(:,3),G0H24(103),m3h4x24(:,217),heltab2x96(:,:,730))
  call Hloop_A_Q(ntryL,G0H24(103),40,0,G1H24(120),n2h24(142))
  Gcoeff(:)%j = (c(112)*M(4,:)%j-c(113)*M(6,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(731),h0tab(:,731),[40,1,2,16,4],[0,0,nMT,nMB,nMW],5,1,wf4(:,3))
  call Hloop_WA_Q(ntryL,G0H96(1),wf4(:,3),G0H24(103),m3h4x24(:,218),heltab2x96(:,:,731))
  call Hloop_A_Q(ntryL,G0H24(103),40,0,G1H24(121),n2h24(143))
  Gcoeff(:)%j = (c(146)*M(5,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(732),h0tab(:,732),[40,2,4,1,16],[0,nMT,0,0,0],5,1,wf4(:,3))
  call Hloop_QA_V(ntryL,G0H96(1),wf4(:,3),G0H24(103),m3h4x24(:,219),heltab2x96(:,:,732))
  Gcoeff(:)%j = (-(c(153)*M(5,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(733),h0tab(:,733),[40,2,4,1,16],[nMZ,nMT,0,0,0],5,1,wf4(:,3))
  call Hloop_QA_Z(ntryL,G0H96(1),wf4(:,3),G0H24(104),ngZd,m3h4x24(:,220),heltab2x96(:,:,733))
  Gcoeff(:)%j = (c(150)*M(5,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(734),h0tab(:,734),[40,2,4,1,16],[0,nMT,nMZ,0,0],5,1,wf4(:,3))
  call Hloop_QA_V(ntryL,G0H96(1),wf4(:,3),G0H24(105),m3h4x24(:,221),heltab2x96(:,:,734))
  Gcoeff(:)%j = (-(c(155)*M(5,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(735),h0tab(:,735),[40,2,4,1,16],[nMZ,nMT,nMZ,0,0],5,1,wf4(:,3))
  call Hloop_QA_Z(ntryL,G0H96(1),wf4(:,3),G0H24(106),ngZd,m3h4x24(:,222),heltab2x96(:,:,735))
  Gcoeff(:)%j = (c(173)*M(4,:)%j-c(174)*M(6,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(736),h0tab(:,736),[40,2,4,1,16],[0,nMT,0,0,0],5,1,wf4(:,3))
  call Hloop_QA_V(ntryL,G0H96(1),wf4(:,3),G0H24(107),m3h4x24(:,223),heltab2x96(:,:,736))
  Gcoeff(:)%j = (-(c(168)*M(4,:)%j)+c(169)*M(6,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(737),h0tab(:,737),[40,2,4,1,16],[0,nMT,0,0,0],5,1,wf4(:,3))
  call Hloop_QA_V(ntryL,G0H96(1),wf4(:,3),G0H24(108),m3h4x24(:,224),heltab2x96(:,:,737))
  Gcoeff(:)%j = (c(179)*M(4,:)%j-c(180)*M(6,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(738),h0tab(:,738),[40,2,4,1,16],[0,nMT,nMZ,0,0],5,1,wf4(:,3))
  call Hloop_QA_V(ntryL,G0H96(1),wf4(:,3),G0H24(109),m3h4x24(:,225),heltab2x96(:,:,738))
  Gcoeff(:)%j = (c(179)*M(4,:)%j-c(180)*M(6,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(739),h0tab(:,739),[40,2,4,1,16],[nMZ,nMT,0,0,0],5,1,wf4(:,3))
  call Hloop_QA_Z(ntryL,G0H96(1),wf4(:,3),G0H24(110),ngZd,m3h4x24(:,226),heltab2x96(:,:,739))
  Gcoeff(:)%j = (c(77)*M(5,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(740),h0tab(:,740),[40,1,4,2,16],[0,0,nMT,nMH,nMW],5,1,wf4(:,3))
  call Hloop_WA_Q(ntryL,G0H96(1),wf4(:,3),G0H24(111),m3h4x24(:,227),heltab2x96(:,:,740))
  call Hloop_A_Q(ntryL,G0H24(111),40,0,G1H24(122),n2h24(144))
  Gcoeff(:)%j = (-(c(106)*M(5,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(741),h0tab(:,741),[40,1,4,2,16],[0,nMW,nMB,nMW,0],5,1,wf4(:,3))
  call Hloop_VA_Q(ntryL,G0H96(1),wf4(:,3),G0H24(111),m3h4x24(:,228),heltab2x96(:,:,741))
  call Hloop_A_Q(ntryL,G0H24(111),40,0,G1H24(123),n2h24(145))
  Gcoeff(:)%j = (c(80)*M(5,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(742),h0tab(:,742),[40,1,4,2,16],[0,nMZ,nMT,nMH,nMW],5,1,wf4(:,3))
  call Hloop_WA_Q(ntryL,G0H96(1),wf4(:,3),G0H24(111),m3h4x24(:,229),heltab2x96(:,:,742))
  call Hloop_A_Q(ntryL,G0H24(111),40,0,G1H24(124),n2h24(146))
  Gcoeff(:)%j = (-(c(142)*M(5,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(743),h0tab(:,743),[40,1,4,2,16],[0,nMW,nMB,nMW,nMZ],5,1,wf4(:,3))
  call Hloop_ZA_Q(ntryL,G0H96(1),wf4(:,3),G0H24(111),ngZd,m3h4x24(:,230),heltab2x96(:,:,743))
  call Hloop_A_Q(ntryL,G0H24(111),40,0,G1H24(125),n2h24(147))
  Gcoeff(:)%j = (-(c(85)*M(4,:)%j)+c(86)*M(6,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(744),h0tab(:,744),[40,1,4,2,16],[0,0,nMT,nMH,nMW],5,1,wf4(:,3))
  call Hloop_WA_Q(ntryL,G0H96(1),wf4(:,3),G0H24(111),m3h4x24(:,231),heltab2x96(:,:,744))
  call Hloop_A_Q(ntryL,G0H24(111),40,0,G1H24(126),n2h24(148))
  Gcoeff(:)%j = (-(c(151)*M(5,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(745),h0tab(:,745),[40,1,4,2,16],[0,0,nMT,0,nMW],5,1,wf4(:,3))
  call Hloop_WA_Q(ntryL,G0H96(1),wf4(:,3),G0H24(111),m3h4x24(:,232),heltab2x96(:,:,745))
  call Hloop_A_Q(ntryL,G0H24(111),40,0,G1H24(127),n2h24(149))
  Gcoeff(:)%j = (-(c(129)*M(5,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(746),h0tab(:,746),[40,1,4,2,16],[0,0,nMT,nMZ,nMW],5,1,wf4(:,3))
  call Hloop_WA_Q(ntryL,G0H96(1),wf4(:,3),G0H24(111),m3h4x24(:,233),heltab2x96(:,:,746))
  call Hloop_A_Q(ntryL,G0H24(111),40,0,G1H24(128),n2h24(150))
  Gcoeff(:)%j = (-(c(154)*M(5,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(747),h0tab(:,747),[40,1,4,2,16],[0,nMZ,nMT,0,nMW],5,1,wf4(:,3))
  call Hloop_WA_Q(ntryL,G0H96(1),wf4(:,3),G0H24(111),m3h4x24(:,234),heltab2x96(:,:,747))
  call Hloop_A_Q(ntryL,G0H24(111),40,0,G1H24(129),n2h24(151))
  Gcoeff(:)%j = (-(c(131)*M(5,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(748),h0tab(:,748),[40,1,4,2,16],[0,nMZ,nMT,nMZ,nMW],5,1,wf4(:,3))
  call Hloop_WA_Q(ntryL,G0H96(1),wf4(:,3),G0H24(111),m3h4x24(:,235),heltab2x96(:,:,748))
  call Hloop_A_Q(ntryL,G0H24(111),40,0,G1H24(130),n2h24(152))
  Gcoeff(:)%j = (c(106)*M(5,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(749),h0tab(:,749),[40,1,4,2,16],[0,nMW,nMB,nMW,0],5,1,wf4(:,3))
  call Hloop_VA_Q(ntryL,G0H96(1),wf4(:,3),G0H24(111),m3h4x24(:,236),heltab2x96(:,:,749))
  call Hloop_A_Q(ntryL,G0H24(111),40,0,G1H24(131),n2h24(153))
  Gcoeff(:)%j = (-(c(63)*M(5,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(750),h0tab(:,750),[40,1,4,2,16],[0,nMW,nMB,nMW,nMZ],5,1,wf4(:,3))
  call Hloop_ZA_Q(ntryL,G0H96(1),wf4(:,3),G0H24(111),ngZd,m3h4x24(:,237),heltab2x96(:,:,750))
  call Hloop_A_Q(ntryL,G0H24(111),40,0,G1H24(132),n2h24(154))
  Gcoeff(:)%j = (c(176)*M(4,:)%j-c(177)*M(6,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(751),h0tab(:,751),[40,1,4,2,16],[0,0,nMT,0,nMW],5,1,wf4(:,3))
  call Hloop_WA_Q(ntryL,G0H96(1),wf4(:,3),G0H24(111),m3h4x24(:,238),heltab2x96(:,:,751))
  call Hloop_A_Q(ntryL,G0H24(111),40,0,G1H24(133),n2h24(155))
  Gcoeff(:)%j = (c(134)*M(4,:)%j-c(135)*M(6,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(752),h0tab(:,752),[40,1,4,2,16],[0,0,nMT,nMZ,nMW],5,1,wf4(:,3))
  call Hloop_WA_Q(ntryL,G0H96(1),wf4(:,3),G0H24(111),m3h4x24(:,239),heltab2x96(:,:,752))
  call Hloop_A_Q(ntryL,G0H24(111),40,0,G1H24(134),n2h24(156))
  Gcoeff(:)%j = (c(105)*M(5,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(753),h0tab(:,753),[40,1,4,16,2],[0,nMW,nMB,nMT,0],5,1,wf4(:,3))
  call Hloop_VA_Q(ntryL,G0H96(1),wf4(:,3),G0H24(111),m3h4x24(:,240),heltab2x96(:,:,753))
  call Hloop_A_Q(ntryL,G0H24(111),40,0,G1H24(135),n2h24(157))
  Gcoeff(:)%j = (-(c(109)*M(5,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(754),h0tab(:,754),[40,1,4,16,2],[0,nMW,nMB,nMT,nMZ],5,1,wf4(:,3))
  call Hloop_ZA_Q(ntryL,G0H96(1),wf4(:,3),G0H24(111),ngZd,m3h4x24(:,241),heltab2x96(:,:,754))
  call Hloop_A_Q(ntryL,G0H24(111),40,0,G1H24(136),n2h24(158))
  Gcoeff(:)%j = (c(112)*M(4,:)%j-c(113)*M(6,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(755),h0tab(:,755),[40,1,4,16,2],[0,nMW,nMB,nMT,0],5,1,wf4(:,3))
  call Hloop_VA_Q(ntryL,G0H96(1),wf4(:,3),G0H24(111),m3h4x24(:,242),heltab2x96(:,:,755))
  call Hloop_A_Q(ntryL,G0H24(111),40,0,G1H24(137),n2h24(159))
  Gcoeff(:)%j = (-(c(75)*M(5,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(756),h0tab(:,756),[40,1,16,2,4],[0,nMW,nMH,nMT,0],5,1,wf4(:,3))
  call Hloop_VA_Q(ntryL,G0H96(1),wf4(:,3),G0H24(111),m3h4x24(:,243),heltab2x96(:,:,756))
  call Hloop_A_Q(ntryL,G0H24(111),40,0,G1H24(138),n2h24(160))
  Gcoeff(:)%j = (c(108)*M(5,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(757),h0tab(:,757),[40,1,16,2,4],[0,0,nMW,nMB,nMW],5,1,wf4(:,3))
  call Hloop_WA_Q(ntryL,G0H96(1),wf4(:,3),G0H24(111),m3h4x24(:,244),heltab2x96(:,:,757))
  call Hloop_A_Q(ntryL,G0H24(111),40,0,G1H24(139),n2h24(161))
  Gcoeff(:)%j = (c(80)*M(5,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(758),h0tab(:,758),[40,1,16,2,4],[0,nMW,nMH,nMT,nMZ],5,1,wf4(:,3))
  call Hloop_ZA_Q(ntryL,G0H96(1),wf4(:,3),G0H24(111),ngZd,m3h4x24(:,245),heltab2x96(:,:,758))
  call Hloop_A_Q(ntryL,G0H24(111),40,0,G1H24(140),n2h24(162))
  Gcoeff(:)%j = (-(c(142)*M(5,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(759),h0tab(:,759),[40,1,16,2,4],[0,nMZ,nMW,nMB,nMW],5,1,wf4(:,3))
  call Hloop_WA_Q(ntryL,G0H96(1),wf4(:,3),G0H24(111),m3h4x24(:,246),heltab2x96(:,:,759))
  call Hloop_A_Q(ntryL,G0H24(111),40,0,G1H24(141),n2h24(163))
  Gcoeff(:)%j = (-(c(85)*M(4,:)%j)+c(86)*M(6,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(760),h0tab(:,760),[40,1,16,2,4],[0,nMW,nMH,nMT,0],5,1,wf4(:,3))
  call Hloop_VA_Q(ntryL,G0H96(1),wf4(:,3),G0H24(111),m3h4x24(:,247),heltab2x96(:,:,760))
  call Hloop_A_Q(ntryL,G0H24(111),40,0,G1H24(142),n2h24(164))
  Gcoeff(:)%j = (c(148)*M(5,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(761),h0tab(:,761),[40,1,16,2,4],[0,nMW,0,nMT,0],5,1,wf4(:,3))
  call Hloop_VA_Q(ntryL,G0H96(1),wf4(:,3),G0H24(111),m3h4x24(:,248),heltab2x96(:,:,761))
  call Hloop_A_Q(ntryL,G0H24(111),40,0,G1H24(143),n2h24(165))
  Gcoeff(:)%j = (-(c(154)*M(5,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(762),h0tab(:,762),[40,1,16,2,4],[0,nMW,0,nMT,nMZ],5,1,wf4(:,3))
  call Hloop_ZA_Q(ntryL,G0H96(1),wf4(:,3),G0H24(111),ngZd,m3h4x24(:,249),heltab2x96(:,:,762))
  call Hloop_A_Q(ntryL,G0H24(111),40,0,G1H24(144),n2h24(166))
  Gcoeff(:)%j = (c(127)*M(5,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(763),h0tab(:,763),[40,1,16,2,4],[0,nMW,nMZ,nMT,0],5,1,wf4(:,3))
  call Hloop_VA_Q(ntryL,G0H96(1),wf4(:,3),G0H24(111),m3h4x24(:,250),heltab2x96(:,:,763))
  call Hloop_A_Q(ntryL,G0H24(111),40,0,G1H24(145),n2h24(167))
  Gcoeff(:)%j = (-(c(131)*M(5,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(764),h0tab(:,764),[40,1,16,2,4],[0,nMW,nMZ,nMT,nMZ],5,1,wf4(:,3))
  call Hloop_ZA_Q(ntryL,G0H96(1),wf4(:,3),G0H24(111),ngZd,m3h4x24(:,251),heltab2x96(:,:,764))
  call Hloop_A_Q(ntryL,G0H24(111),40,0,G1H24(146),n2h24(168))
  Gcoeff(:)%j = (-(c(108)*M(5,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(765),h0tab(:,765),[40,1,16,2,4],[0,0,nMW,nMB,nMW],5,1,wf4(:,3))
  call Hloop_WA_Q(ntryL,G0H96(1),wf4(:,3),G0H24(111),m3h4x24(:,252),heltab2x96(:,:,765))
  call Hloop_A_Q(ntryL,G0H24(111),40,0,G1H24(147),n2h24(169))
  Gcoeff(:)%j = (-(c(63)*M(5,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(766),h0tab(:,766),[40,1,16,2,4],[0,nMZ,nMW,nMB,nMW],5,1,wf4(:,3))
  call Hloop_WA_Q(ntryL,G0H96(1),wf4(:,3),G0H24(111),m3h4x24(:,253),heltab2x96(:,:,766))
  call Hloop_A_Q(ntryL,G0H24(111),40,0,G1H24(148),n2h24(170))
  Gcoeff(:)%j = (c(176)*M(4,:)%j-c(177)*M(6,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(767),h0tab(:,767),[40,1,16,2,4],[0,nMW,0,nMT,0],5,1,wf4(:,3))
  call Hloop_VA_Q(ntryL,G0H96(1),wf4(:,3),G0H24(111),m3h4x24(:,254),heltab2x96(:,:,767))
  call Hloop_A_Q(ntryL,G0H24(111),40,0,G1H24(149),n2h24(171))
  Gcoeff(:)%j = (c(134)*M(4,:)%j-c(135)*M(6,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(768),h0tab(:,768),[40,1,16,2,4],[0,nMW,nMZ,nMT,0],5,1,wf4(:,3))
  call Hloop_VA_Q(ntryL,G0H96(1),wf4(:,3),G0H24(111),m3h4x24(:,255),heltab2x96(:,:,768))
  call Hloop_A_Q(ntryL,G0H24(111),40,0,G1H24(150),n2h24(172))
  Gcoeff(:)%j = (-(c(75)*M(5,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(769),h0tab(:,769),[40,1,16,4,2],[0,nMW,nMH,nMT,0],5,1,wf4(:,3))
  call Hloop_VA_Q(ntryL,G0H96(1),wf4(:,3),G0H24(111),m3h4x24(:,256),heltab2x96(:,:,769))
  call Hloop_A_Q(ntryL,G0H24(111),40,0,G1H24(151),n2h24(173))
  Gcoeff(:)%j = (c(80)*M(5,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(770),h0tab(:,770),[40,1,16,4,2],[0,nMW,nMH,nMT,nMZ],5,1,wf4(:,3))
  call Hloop_ZA_Q(ntryL,G0H96(1),wf4(:,3),G0H24(111),ngZd,m3h4x24(:,257),heltab2x96(:,:,770))
  call Hloop_A_Q(ntryL,G0H24(111),40,0,G1H24(152),n2h24(174))
  Gcoeff(:)%j = (-(c(85)*M(4,:)%j)+c(86)*M(6,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(771),h0tab(:,771),[40,1,16,4,2],[0,nMW,nMH,nMT,0],5,1,wf4(:,3))
  call Hloop_VA_Q(ntryL,G0H96(1),wf4(:,3),G0H24(111),m3h4x24(:,258),heltab2x96(:,:,771))
  call Hloop_A_Q(ntryL,G0H24(111),40,0,G1H24(153),n2h24(175))
  Gcoeff(:)%j = (c(148)*M(5,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(772),h0tab(:,772),[40,1,16,4,2],[0,nMW,0,nMT,0],5,1,wf4(:,3))
  call Hloop_VA_Q(ntryL,G0H96(1),wf4(:,3),G0H24(111),m3h4x24(:,259),heltab2x96(:,:,772))
  call Hloop_A_Q(ntryL,G0H24(111),40,0,G1H24(154),n2h24(176))
  Gcoeff(:)%j = (c(127)*M(5,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(773),h0tab(:,773),[40,1,16,4,2],[0,nMW,nMZ,nMT,0],5,1,wf4(:,3))
  call Hloop_VA_Q(ntryL,G0H96(1),wf4(:,3),G0H24(111),m3h4x24(:,260),heltab2x96(:,:,773))
  call Hloop_A_Q(ntryL,G0H24(111),40,0,G1H24(155),n2h24(177))
  Gcoeff(:)%j = (-(c(154)*M(5,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(774),h0tab(:,774),[40,1,16,4,2],[0,nMW,0,nMT,nMZ],5,1,wf4(:,3))
  call Hloop_ZA_Q(ntryL,G0H96(1),wf4(:,3),G0H24(111),ngZd,m3h4x24(:,261),heltab2x96(:,:,774))
  call Hloop_A_Q(ntryL,G0H24(111),40,0,G1H24(156),n2h24(178))
  Gcoeff(:)%j = (-(c(131)*M(5,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(775),h0tab(:,775),[40,1,16,4,2],[0,nMW,nMZ,nMT,nMZ],5,1,wf4(:,3))
  call Hloop_ZA_Q(ntryL,G0H96(1),wf4(:,3),G0H24(111),ngZd,m3h4x24(:,262),heltab2x96(:,:,775))
  call Hloop_A_Q(ntryL,G0H24(111),40,0,G1H24(157),n2h24(179))
  Gcoeff(:)%j = (c(176)*M(4,:)%j-c(177)*M(6,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(776),h0tab(:,776),[40,1,16,4,2],[0,nMW,0,nMT,0],5,1,wf4(:,3))
  call Hloop_VA_Q(ntryL,G0H96(1),wf4(:,3),G0H24(111),m3h4x24(:,263),heltab2x96(:,:,776))
  call Hloop_A_Q(ntryL,G0H24(111),40,0,G1H24(158),n2h24(180))
  Gcoeff(:)%j = (c(134)*M(4,:)%j-c(135)*M(6,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(777),h0tab(:,777),[40,1,16,4,2],[0,nMW,nMZ,nMT,0],5,1,wf4(:,3))
  call Hloop_VA_Q(ntryL,G0H96(1),wf4(:,3),G0H24(111),m3h4x24(:,264),heltab2x96(:,:,777))
  call Hloop_A_Q(ntryL,G0H24(111),40,0,G1H24(159),n2h24(181))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(16),[G1H48(7),G1H48(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(17),[G1H48(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(20),[G1H48(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(34),[G1H48(26),G1H48(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(35),[G1H48(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(38),[G1H48(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(57),[G1H48(45),G1H48(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(61),[G1H48(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(54),[G1H48(46)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(88),[G1H48(78),G1H48(66)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(84),[G1H48(67)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(76),[G1H48(74)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(100),[G1H48(96),G1H48(85)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(105),[G1H48(86)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(94),[G1H48(92)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(136),[G1H48(122),G1H48(106)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(138),[G1H48(113)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(131),[G1H48(125)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(6),[G1H48(151)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(5),[G1H48(154)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(9),[G1H48(155)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(8),[G1H48(162)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(55),[G1H48(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(59),[G1H48(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(58),[G1H48(50)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(60),[G1H48(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(101),[G1H48(95)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(107),[G1H48(111)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(117),[G1H48(114)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(233),[G1H48(232),G1H48(228)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(235),[G1H48(229)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(234),[G1H48(230)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(246),[G1H48(245),G1H48(240)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(248),[G1H48(241)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(247),[G1H48(242)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(256),[G1H48(255),G1H48(251)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(258),[G1H48(252)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(257),[G1H48(253)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(265),[G1H48(264),G1H48(259)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(267),[G1H48(260)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(266),[G1H48(261)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(272),[G1H48(268)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(273),[G1H48(269)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(279),[G1H48(275)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(280),[G1H48(276)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(287),[G1H48(283)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(288),[G1H48(284)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(294),[G1H48(290)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(295),[G1H48(291)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(301),[G1H48(300),G1H48(296)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(303),[G1H48(297)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(302),[G1H48(298)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(311),[G1H48(310),G1H48(306)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(313),[G1H48(307)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(312),[G1H48(308)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(320),[G1H48(319),G1H48(314)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(322),[G1H48(315)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(321),[G1H48(316)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(331),[G1H48(330),G1H48(325)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(333),[G1H48(326)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H48(332),[G1H48(327)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H24(32),[G1H24(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H24(37),[G1H24(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H24(38),[G1H24(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H24(6),[G0H24(5),G0H24(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H24(8),[G0H24(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H24(7),[G0H24(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H24(43),[G1H24(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H24(50),[G1H24(44)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H24(51),[G1H24(46)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H24(13),[G0H24(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H24(20),[G0H24(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H24(21),[G0H24(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H24(27),[G0H24(26),G0H24(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H24(29),[G0H24(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H24(28),[G0H24(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H24(32),[G0H24(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H24(37),[G0H24(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H24(38),[G0H24(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H24(41),[G0H24(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H24(44),[G0H24(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H24(47),[G0H24(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H24(56),[G1H24(52)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H24(63),[G1H24(57)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H24(64),[G1H24(58)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H24(70),[G1H24(69),G1H24(65)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H24(72),[G1H24(66)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H24(71),[G1H24(67)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H24(77),[G1H24(73)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H24(84),[G1H24(78)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H24(85),[G1H24(79)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H24(88),[G1H24(86)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H24(93),[G1H24(89)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H24(94),[G1H24(91)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H24(50),[G0H24(48)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H24(53),[G0H24(51)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H24(58),[G0H24(54)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H24(59),[G0H24(55)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H24(65),[G0H24(64),G0H24(60)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H24(67),[G0H24(61)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H24(66),[G0H24(62)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H24(70),[G0H24(68)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H24(97),[G1H24(95)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H24(1),[G1H24(98)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H24(3),[G1H24(99)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H24(10),[G1H24(9),G1H24(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H24(12),[G1H24(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H24(11),[G1H24(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H24(16),[G1H24(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H24(22),[G1H24(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H24(23),[G1H24(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H24(29),[G1H24(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H24(108),[G1H24(102)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H24(109),[G1H24(104)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H24(73),[G0H24(71)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H24(78),[G0H24(74)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H24(85),[G0H24(79)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H24(86),[G0H24(80)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H24(92),[G0H24(91),G0H24(87)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H24(94),[G0H24(88)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H24(93),[G0H24(89)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H24(100),[G0H24(99),G0H24(95)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H24(102),[G0H24(96)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H24(101),[G0H24(97)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H24(112),[G1H24(110)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H24(117),[G1H24(113)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H24(118),[G1H24(114)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H24(121),[G1H24(119)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H24(108),[G0H24(107),G0H24(103)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H24(110),[G0H24(104)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H24(109),[G0H24(105)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H24(126),[G1H24(122)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H24(133),[G1H24(127)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H24(134),[G1H24(128)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H24(137),[G1H24(135)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H24(142),[G1H24(138)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H24(149),[G1H24(143)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H24(150),[G1H24(145)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H24(153),[G1H24(151)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H24(158),[G1H24(154)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H24(159),[G1H24(155)])
  call Hloop_QW_A(ntryL,G1H24(2),ex5(:),G1H8(15),m3h3x8(:,57),heltab2x24(:,:,143))
  call Hloop_Q_A(ntryL,G1H8(15),50,nMB,G2H8(23),n2h8(43))
  call Hloop_QW_A(ntryL,G1H24(8),ex5(:),G1H8(2),m3h3x8(:,58),heltab2x24(:,:,144))
  call Hloop_Q_A(ntryL,G1H8(2),49,0,G2H8(25),n2h8(44))
  call Hloop_QW_A(ntryL,G1H24(14),ex5(:),G1H8(8),m3h3x8(:,59),heltab2x24(:,:,145))
  call Hloop_Q_A(ntryL,G1H8(8),49,0,G2H8(26),n2h8(45))
  call Hloop_QW_A(ntryL,G1H24(20),ex5(:),G1H8(1),m3h3x8(:,60),heltab2x24(:,:,146))
  call Hloop_Q_A(ntryL,G1H8(1),49,0,G2H8(27),n2h8(46))
  call Hloop_QW_A(ntryL,G1H24(26),ex5(:),G1H8(3),m3h3x8(:,61),heltab2x24(:,:,147))
  call Hloop_Q_A(ntryL,G1H8(3),49,0,G2H8(29),n2h8(47))
  call Hloop_AV_Q(ntryL,G1H48(16),wf4(:,1),G1H12(6),m3h4x12(:,1),heltab2x48(:,:,123))
  call Hloop_A_Q(ntryL,G1H12(6),38,0,G2H12(13),n2h12(90))
  call Hloop_AV_Q(ntryL,G1H48(17),wf4(:,1),G1H12(7),m3h4x12(:,2),heltab2x48(:,:,124))
  call Hloop_A_Q(ntryL,G1H12(7),38,0,G2H12(14),n2h12(91))
  call Hloop_AZ_Q(ntryL,G1H48(20),wf4(:,4),G1H12(10),ngZd,m3h4x12(:,3),heltab2x48(:,:,125))
  call Hloop_A_Q(ntryL,G1H12(10),38,0,G2H12(15),n2h12(92))
  call Hloop_AZ_Q(ntryL,G1H48(11),wf4(:,4),G1H12(11),ngZd,m3h4x12(:,4),heltab2x48(:,:,126))
  call Hloop_A_Q(ntryL,G1H12(11),38,0,G2H12(16),n2h12(93))
  call Hloop_QV_A(ntryL,G1H48(34),wf4(:,1),G1H12(12),m3h4x12(:,5),heltab2x48(:,:,127))
  call Hloop_Q_A(ntryL,G1H12(12),38,0,G2H12(17),n2h12(94))
  call Hloop_QV_A(ntryL,G1H48(35),wf4(:,1),G1H12(13),m3h4x12(:,6),heltab2x48(:,:,128))
  call Hloop_Q_A(ntryL,G1H12(13),38,0,G2H12(18),n2h12(95))
  call Hloop_QZ_A(ntryL,G1H48(38),wf4(:,4),G1H12(16),ngZd,m3h4x12(:,7),heltab2x48(:,:,129))
  call Hloop_Q_A(ntryL,G1H12(16),38,0,G2H12(19),n2h12(96))
  call Hloop_QZ_A(ntryL,G1H48(28),wf4(:,4),G1H12(17),ngZd,m3h4x12(:,8),heltab2x48(:,:,130))
  call Hloop_Q_A(ntryL,G1H12(17),38,0,G2H12(20),n2h12(97))
  call Hloop_AQ_V(ntryL,G1H48(57),ex1(:),G1H24(30),m3h2x24(:,123),heltab2x48(:,:,131))
  call Hloop_AQ_Z(ntryL,G1H48(61),ex1(:),G1H24(33),ngZu,m3h2x24(:,124),heltab2x48(:,:,132))
  call Hloop_AQ_V(ntryL,G1H48(54),ex1(:),G1H24(34),m3h2x24(:,125),heltab2x48(:,:,133))
  call Hloop_AQ_Z(ntryL,G1H48(51),ex1(:),G1H24(39),ngZu,m3h2x24(:,126),heltab2x48(:,:,134))
  call Hloop_AQ_V(ntryL,G1H48(88),ex1(:),G1H24(44),m3h2x24(:,127),heltab2x48(:,:,135))
  call Hloop_AQ_Z(ntryL,G1H48(84),ex1(:),G1H24(46),ngZu,m3h2x24(:,128),heltab2x48(:,:,136))
  call Hloop_AQ_V(ntryL,G1H48(76),ex1(:),G1H24(52),m3h2x24(:,129),heltab2x48(:,:,137))
  call Hloop_AQ_Z(ntryL,G1H48(75),ex1(:),G1H24(57),ngZu,m3h2x24(:,130),heltab2x48(:,:,138))
  call Hloop_AV_Q(ntryL,G1H48(100),wf4(:,1),G1H12(18),m3h4x12(:,9),heltab2x48(:,:,139))
  call Hloop_A_Q(ntryL,G1H12(18),38,0,G2H12(21),n2h12(98))
  call Hloop_AV_Q(ntryL,G1H48(105),wf4(:,1),G1H12(19),m3h4x12(:,10),heltab2x48(:,:,140))
  call Hloop_A_Q(ntryL,G1H12(19),38,0,G2H12(22),n2h12(99))
  call Hloop_AZ_Q(ntryL,G1H48(94),wf4(:,4),G1H12(22),ngZu,m3h4x12(:,11),heltab2x48(:,:,141))
  call Hloop_A_Q(ntryL,G1H12(22),38,0,G2H12(23),n2h12(100))
  call Hloop_AZ_Q(ntryL,G1H48(93),wf4(:,4),G1H12(23),ngZu,m3h4x12(:,12),heltab2x48(:,:,142))
  call Hloop_A_Q(ntryL,G1H12(23),38,0,G2H12(24),n2h12(101))
  call Hloop_QA_V(ntryL,G1H48(136),ex4(:),G1H24(58),m3h2x24(:,131),heltab2x48(:,:,143))
  call Hloop_QA_Z(ntryL,G1H48(138),ex4(:),G1H24(69),ngZd,m3h2x24(:,132),heltab2x48(:,:,144))
  call Hloop_QA_V(ntryL,G1H48(131),ex4(:),G1H24(65),m3h2x24(:,133),heltab2x48(:,:,145))
  call Hloop_QA_Z(ntryL,G1H48(126),ex4(:),G1H24(66),ngZd,m3h2x24(:,134),heltab2x48(:,:,146))
  call Hloop_AQ_V(ntryL,G1H48(6),ex1(:),G1H24(67),m3h2x24(:,135),heltab2x48(:,:,147))
  call Hloop_AQ_W(ntryL,G1H48(5),ex1(:),G1H24(73),m3h2x24(:,136),heltab2x48(:,:,148))
  call Hloop_AQ_Z(ntryL,G1H48(9),ex1(:),G1H24(78),ngZu,m3h2x24(:,137),heltab2x48(:,:,149))
  call Hloop_AQ_W(ntryL,G1H48(8),ex1(:),G1H24(79),m3h2x24(:,138),heltab2x48(:,:,150))
  call Hloop_AQ_V(ntryL,G1H48(167),ex1(:),G1H24(86),m3h2x24(:,139),heltab2x48(:,:,151))
  call Hloop_AQ_W(ntryL,G1H48(169),ex1(:),G1H24(89),m3h2x24(:,140),heltab2x48(:,:,152))
  call Hloop_AQ_Z(ntryL,G1H48(3),ex1(:),G1H24(91),ngZu,m3h2x24(:,141),heltab2x48(:,:,153))
  call Hloop_AQ_W(ntryL,G1H48(2),ex1(:),G1H24(95),m3h2x24(:,142),heltab2x48(:,:,154))
  call Hloop_AQ_V(ntryL,G1H48(14),ex1(:),G1H24(98),m3h2x24(:,143),heltab2x48(:,:,155))
  call Hloop_AQ_Z(ntryL,G1H48(15),ex1(:),G1H24(99),ngZu,m3h2x24(:,144),heltab2x48(:,:,156))
  call Hloop_AQ_V(ntryL,G1H48(12),ex1(:),G1H24(9),m3h2x24(:,145),heltab2x48(:,:,157))
  call Hloop_AQ_W(ntryL,G1H48(13),ex1(:),G1H24(4),m3h2x24(:,146),heltab2x48(:,:,158))
  call Hloop_AQ_Z(ntryL,G1H48(21),ex1(:),G1H24(5),ngZu,m3h2x24(:,147),heltab2x48(:,:,159))
  call Hloop_AQ_W(ntryL,G1H48(23),ex1(:),G1H24(6),m3h2x24(:,148),heltab2x48(:,:,160))
  call Hloop_AQ_V(ntryL,G1H48(22),ex1(:),G1H24(13),m3h2x24(:,149),heltab2x48(:,:,161))
  call Hloop_AQ_Z(ntryL,G1H48(19),ex1(:),G1H24(17),ngZu,m3h2x24(:,150),heltab2x48(:,:,162))
  call Hloop_VQ_A(ntryL,G1H48(24),ex1(:),G1H24(18),m3h2x24(:,151),heltab2x48(:,:,163))
  call Hloop_Q_A(ntryL,G1H24(18),33,0,G2H24(1),n2h24(182))
  call Hloop_VQ_A(ntryL,G1H48(25),ex1(:),G1H24(24),m3h2x24(:,152),heltab2x48(:,:,164))
  call Hloop_Q_A(ntryL,G1H24(24),33,0,G2H24(2),n2h24(183))
  call Hloop_AQ_V(ntryL,G1H48(31),ex1(:),G1H24(102),m3h2x24(:,153),heltab2x48(:,:,165))
  call Hloop_AQ_Z(ntryL,G1H48(33),ex1(:),G1H24(104),ngZu,m3h2x24(:,154),heltab2x48(:,:,166))
  call Hloop_AQ_V(ntryL,G1H48(32),ex1(:),G1H24(110),m3h2x24(:,155),heltab2x48(:,:,167))
  call Hloop_AQ_W(ntryL,G1H48(29),ex1(:),G1H24(113),m3h2x24(:,156),heltab2x48(:,:,168))
  call Hloop_AQ_Z(ntryL,G1H48(39),ex1(:),G1H24(114),ngZu,m3h2x24(:,157),heltab2x48(:,:,169))
  call Hloop_AQ_V(ntryL,G1H48(41),ex1(:),G1H24(119),m3h2x24(:,158),heltab2x48(:,:,170))
  call Hloop_AQ_Z(ntryL,G1H48(40),ex1(:),G1H24(122),ngZu,m3h2x24(:,159),heltab2x48(:,:,171))
  call Hloop_AQ_V(ntryL,G1H48(37),ex1(:),G1H24(127),m3h2x24(:,160),heltab2x48(:,:,172))
  call Hloop_AQ_Z(ntryL,G1H48(44),ex1(:),G1H24(128),ngZu,m3h2x24(:,161),heltab2x48(:,:,173))
  call Hloop_AV_Q(ntryL,G1H48(55),wf4(:,1),G1H12(24),m3h4x12(:,13),heltab2x48(:,:,174))
  call Hloop_A_Q(ntryL,G1H12(24),38,0,G2H12(25),n2h12(102))
  call Hloop_AV_Q(ntryL,G1H48(59),wf4(:,1),G1H12(25),m3h4x12(:,14),heltab2x48(:,:,175))
  call Hloop_A_Q(ntryL,G1H12(25),38,0,G2H12(26),n2h12(103))
  call Hloop_AV_Q(ntryL,G1H48(58),wf4(:,1),G1H12(28),m3h4x12(:,15),heltab2x48(:,:,176))
  call Hloop_A_Q(ntryL,G1H12(28),38,0,G2H12(27),n2h12(104))
  call Hloop_AV_Q(ntryL,G1H48(60),wf4(:,1),G1H12(29),m3h4x12(:,16),heltab2x48(:,:,177))
  call Hloop_A_Q(ntryL,G1H12(29),38,0,G2H12(28),n2h12(105))
  call Hloop_AZ_Q(ntryL,G1H48(48),wf4(:,4),G1H12(30),ngZu,m3h4x12(:,17),heltab2x48(:,:,178))
  call Hloop_A_Q(ntryL,G1H12(30),38,0,G2H12(29),n2h12(106))
  call Hloop_AZ_Q(ntryL,G1H48(53),wf4(:,4),G1H12(31),ngZd,m3h4x12(:,18),heltab2x48(:,:,179))
  call Hloop_A_Q(ntryL,G1H12(31),38,0,G2H12(30),n2h12(107))
  call Hloop_AZ_Q(ntryL,G1H48(52),wf4(:,4),G1H12(34),ngZu,m3h4x12(:,19),heltab2x48(:,:,180))
  call Hloop_A_Q(ntryL,G1H12(34),38,0,G2H12(31),n2h12(108))
  call Hloop_AZ_Q(ntryL,G1H48(56),wf4(:,4),G1H12(35),ngZd,m3h4x12(:,20),heltab2x48(:,:,181))
  call Hloop_A_Q(ntryL,G1H12(35),38,0,G2H12(32),n2h12(109))
  call Hloop_QA_Z(ntryL,G1H48(65),ex4(:),G1H24(135),ngZd,m3h2x24(:,162),heltab2x48(:,:,182))
  call Hloop_AQ_W(ntryL,G1H48(62),ex1(:),G1H24(138),m3h2x24(:,163),heltab2x48(:,:,183))
  call Hloop_AQ_W(ntryL,G1H48(63),ex1(:),G1H24(143),m3h2x24(:,164),heltab2x48(:,:,184))
  call Hloop_AQ_W(ntryL,G1H48(64),ex1(:),G1H24(145),m3h2x24(:,165),heltab2x48(:,:,185))
  call Hloop_AQ_Z(ntryL,G1H48(72),ex1(:),G1H24(151),ngZu,m3h2x24(:,166),heltab2x48(:,:,186))
  call Hloop_AQ_W(ntryL,G1H48(73),ex1(:),G1H24(154),m3h2x24(:,167),heltab2x48(:,:,187))
  call Hloop_AQ_Z(ntryL,G1H48(68),ex1(:),G1H24(155),ngZu,m3h2x24(:,168),heltab2x48(:,:,188))
  call Hloop_AQ_W(ntryL,G1H48(69),ex1(:),G1H24(2),m3h2x24(:,169),heltab2x48(:,:,189))
  call Hloop_AQ_W(ntryL,G1H48(70),ex1(:),G1H24(8),m3h2x24(:,170),heltab2x48(:,:,190))
  call Hloop_VQ_A(ntryL,G1H48(71),ex1(:),G1H24(14),m3h2x24(:,171),heltab2x48(:,:,191))
  call Hloop_Q_A(ntryL,G1H24(14),33,0,G2H24(3),n2h24(184))
  call Hloop_VQ_A(ntryL,G1H48(79),ex1(:),G1H24(20),m3h2x24(:,172),heltab2x48(:,:,192))
  call Hloop_Q_A(ntryL,G1H24(20),33,0,G2H24(4),n2h24(185))
  call Hloop_AQ_W(ntryL,G1H48(81),ex1(:),G1H24(26),m3h2x24(:,173),heltab2x48(:,:,193))
  call Hloop_AQ_W(ntryL,G1H48(80),ex1(:),G1H24(18),m3h2x24(:,174),heltab2x48(:,:,194))
  call Hloop_AQ_W(ntryL,G1H48(77),ex1(:),G1H24(24),m3h2x24(:,175),heltab2x48(:,:,195))
  call Hloop_AQ_Z(ntryL,G1H48(82),ex1(:),G1H24(14),ngZu,m3h2x24(:,176),heltab2x48(:,:,196))
  call Hloop_AQ_W(ntryL,G1H48(83),ex1(:),G1H24(20),m3h2x24(:,177),heltab2x48(:,:,197))
  call Hloop_AQ_W(ntryL,G1H48(89),ex1(:),G1H24(160),m3h2x24(:,178),heltab2x48(:,:,198))
  call Hloop_AQ_W(ntryL,G1H48(91),ex1(:),G1H24(161),m3h2x24(:,179),heltab2x48(:,:,199))
  call Hloop_AQ_W(ntryL,G1H48(90),ex1(:),G1H24(162),m3h2x24(:,180),heltab2x48(:,:,200))
  call Hloop_AQ_W(ntryL,G1H48(87),ex1(:),G1H24(163),m3h2x24(:,181),heltab2x48(:,:,201))
  call Hloop_AQ_Z(ntryL,G1H48(97),ex1(:),G1H24(164),ngZu,m3h2x24(:,182),heltab2x48(:,:,202))
  call Hloop_QA_S(ntryL,G1H48(99),ex3(:),G1H24(165),ngH,m3h2x24(:,183),heltab2x48(:,:,203))
  call Hloop_QA_S(ntryL,G1H48(98),ex3(:),G1H24(166),ngX,m3h2x24(:,184),heltab2x48(:,:,204))
  call Hloop_QA_V(ntryL,G1H48(101),ex3(:),G1H24(167),m3h2x24(:,185),heltab2x48(:,:,205))
  call Hloop_QA_Z(ntryL,G1H48(104),ex3(:),G1H24(168),ngZu,m3h2x24(:,186),heltab2x48(:,:,206))
  call Hloop_QW_A(ntryL,G1H48(102),wf4(:,8),G1H12(36),m3h4x12(:,21),heltab2x48(:,:,207))
  call Hloop_Q_A(ntryL,G1H12(36),41,nMT,G2H12(33),n2h12(110))
  call Hloop_QW_A(ntryL,G1H48(103),wf4(:,8),G1H12(37),m3h4x12(:,22),heltab2x48(:,:,208))
  call Hloop_Q_A(ntryL,G1H12(37),41,nMT,G2H12(34),n2h12(111))
  call Hloop_QW_A(ntryL,G1H48(107),wf4(:,8),G1H12(40),m3h4x12(:,23),heltab2x48(:,:,209))
  call Hloop_Q_A(ntryL,G1H12(40),41,nMT,G2H12(35),n2h12(112))
  call Hloop_QW_A(ntryL,G1H48(112),wf4(:,8),G1H12(41),m3h4x12(:,24),heltab2x48(:,:,210))
  call Hloop_Q_A(ntryL,G1H12(41),41,nMT,G2H12(36),n2h12(113))
  call Hloop_AQ_S(ntryL,G1H48(108),ex2(:),G1H24(169),ngPbt,m3h2x24(:,187),heltab2x48(:,:,211))
  call Hloop_AQ_W(ntryL,G1H48(109),ex2(:),G1H24(170),m3h2x24(:,188),heltab2x48(:,:,212))
  call Hloop_AQ_S(ntryL,G1H48(110),ex2(:),G1H24(171),ngH,m3h2x24(:,189),heltab2x48(:,:,213))
  call Hloop_AQ_S(ntryL,G1H48(115),ex2(:),G1H24(172),ngX,m3h2x24(:,190),heltab2x48(:,:,214))
  call Hloop_AQ_V(ntryL,G1H48(117),ex2(:),G1H24(173),m3h2x24(:,191),heltab2x48(:,:,215))
  call Hloop_AQ_Z(ntryL,G1H48(116),ex2(:),G1H24(174),ngZu,m3h2x24(:,192),heltab2x48(:,:,216))
  call Hloop_AW_Q(ntryL,G1H48(118),wf4(:,8),G1H12(42),m3h4x12(:,25),heltab2x48(:,:,217))
  call Hloop_A_Q(ntryL,G1H12(42),41,nMB,G2H12(37),n2h12(114))
  call Hloop_AW_Q(ntryL,G1H48(119),wf4(:,8),G1H12(43),m3h4x12(:,26),heltab2x48(:,:,218))
  call Hloop_A_Q(ntryL,G1H12(43),41,nMB,G2H12(38),n2h12(115))
  call Hloop_QA_S(ntryL,G1H48(120),ex3(:),G1H24(175),ngPtb,m3h2x24(:,193),heltab2x48(:,:,219))
  call Hloop_QA_W(ntryL,G1H48(121),ex3(:),G1H24(176),m3h2x24(:,194),heltab2x48(:,:,220))
  call Hloop_AQ_S(ntryL,G1H48(124),ex2(:),G1H24(177),ngPbt,m3h2x24(:,195),heltab2x48(:,:,221))
  call Hloop_AQ_S(ntryL,G1H48(123),ex2(:),G1H24(178),ngPbt,m3h2x24(:,196),heltab2x48(:,:,222))
  call Hloop_AQ_S(ntryL,G1H48(129),ex2(:),G1H24(179),ngPbt,m3h2x24(:,197),heltab2x48(:,:,223))
  call Hloop_AQ_S(ntryL,G1H48(130),ex2(:),G1H24(180),ngPbt,m3h2x24(:,198),heltab2x48(:,:,224))
  call Hloop_AQ_W(ntryL,G1H48(127),ex2(:),G1H24(181),m3h2x24(:,199),heltab2x48(:,:,225))
  call Hloop_AQ_W(ntryL,G1H48(128),ex2(:),G1H24(182),m3h2x24(:,200),heltab2x48(:,:,226))
  call Hloop_AQ_W(ntryL,G1H48(135),ex2(:),G1H24(183),m3h2x24(:,201),heltab2x48(:,:,227))
  call Hloop_AQ_S(ntryL,G1H48(132),ex2(:),G1H24(184),ngH,m3h2x24(:,202),heltab2x48(:,:,228))
  call Hloop_AQ_S(ntryL,G1H48(133),ex2(:),G1H24(185),ngH,m3h2x24(:,203),heltab2x48(:,:,229))
  call Hloop_AQ_S(ntryL,G1H48(134),ex2(:),G1H24(186),ngX,m3h2x24(:,204),heltab2x48(:,:,230))
  call Hloop_AQ_S(ntryL,G1H48(142),ex2(:),G1H24(187),ngX,m3h2x24(:,205),heltab2x48(:,:,231))
  call Hloop_AQ_S(ntryL,G1H48(137),ex2(:),G1H24(188),ngPbt,m3h2x24(:,206),heltab2x48(:,:,232))
  call Hloop_AQ_S(ntryL,G1H48(143),ex2(:),G1H24(189),ngPbt,m3h2x24(:,207),heltab2x48(:,:,233))
  call Hloop_AQ_S(ntryL,G1H48(139),ex2(:),G1H24(190),ngPbt,m3h2x24(:,208),heltab2x48(:,:,234))
  call Hloop_AQ_S(ntryL,G1H48(140),ex2(:),G1H24(191),ngPbt,m3h2x24(:,209),heltab2x48(:,:,235))
  call Hloop_AQ_S(ntryL,G1H48(141),ex2(:),G1H24(192),ngH,m3h2x24(:,210),heltab2x48(:,:,236))
  call Hloop_AQ_S(ntryL,G1H48(144),ex2(:),G1H24(193),ngH,m3h2x24(:,211),heltab2x48(:,:,237))
  call Hloop_AQ_S(ntryL,G1H48(145),ex2(:),G1H24(194),ngX,m3h2x24(:,212),heltab2x48(:,:,238))
  call Hloop_AQ_S(ntryL,G1H48(146),ex2(:),G1H24(195),ngH,m3h2x24(:,213),heltab2x48(:,:,239))
  call Hloop_AQ_S(ntryL,G1H48(147),ex2(:),G1H24(196),ngX,m3h2x24(:,214),heltab2x48(:,:,240))
  call Hloop_AQ_S(ntryL,G1H48(148),ex2(:),G1H24(197),ngPbt,m3h2x24(:,215),heltab2x48(:,:,241))
  call Hloop_AQ_V(ntryL,G1H48(149),ex2(:),G1H24(198),m3h2x24(:,216),heltab2x48(:,:,242))
  call Hloop_AQ_V(ntryL,G1H48(150),ex2(:),G1H24(199),m3h2x24(:,217),heltab2x48(:,:,243))
  call Hloop_AQ_Z(ntryL,G1H48(153),ex2(:),G1H24(200),ngZu,m3h2x24(:,218),heltab2x48(:,:,244))
  call Hloop_AQ_Z(ntryL,G1H48(152),ex2(:),G1H24(201),ngZu,m3h2x24(:,219),heltab2x48(:,:,245))
  call Hloop_AQ_W(ntryL,G1H48(158),ex2(:),G1H24(202),m3h2x24(:,220),heltab2x48(:,:,246))
  call Hloop_VQ_A(ntryL,G1H48(159),ex2(:),G1H24(203),m3h2x24(:,221),heltab2x48(:,:,247))
  call Hloop_Q_A(ntryL,G1H24(203),34,nMT,G2H24(5),n2h24(186))
  call Hloop_AQ_S(ntryL,G1H48(156),ex2(:),G1H24(203),ngH,m3h2x24(:,222),heltab2x48(:,:,248))
  call Hloop_AQ_S(ntryL,G1H48(157),ex2(:),G1H24(204),ngPbt,m3h2x24(:,223),heltab2x48(:,:,249))
  call Hloop_AQ_S(ntryL,G1H48(160),ex2(:),G1H24(205),ngH,m3h2x24(:,224),heltab2x48(:,:,250))
  call Hloop_AQ_S(ntryL,G1H48(161),ex2(:),G1H24(206),ngPbt,m3h2x24(:,225),heltab2x48(:,:,251))
  call Hloop_AQ_V(ntryL,G1H48(166),ex2(:),G1H24(207),m3h2x24(:,226),heltab2x48(:,:,252))
  call Hloop_AQ_W(ntryL,G1H48(163),ex2(:),G1H24(208),m3h2x24(:,227),heltab2x48(:,:,253))
  call Hloop_AQ_Z(ntryL,G1H48(164),ex2(:),G1H24(209),ngZu,m3h2x24(:,228),heltab2x48(:,:,254))
  call Hloop_AQ_W(ntryL,G1H48(165),ex2(:),G1H24(210),m3h2x24(:,229),heltab2x48(:,:,255))
  call Hloop_AQ_V(ntryL,G1H48(173),ex2(:),G1H24(211),m3h2x24(:,230),heltab2x48(:,:,256))
  call Hloop_AQ_V(ntryL,G1H48(168),ex2(:),G1H24(212),m3h2x24(:,231),heltab2x48(:,:,257))
  call Hloop_AQ_Z(ntryL,G1H48(174),ex2(:),G1H24(213),ngZu,m3h2x24(:,232),heltab2x48(:,:,258))
  call Hloop_AQ_Z(ntryL,G1H48(170),ex2(:),G1H24(214),ngZu,m3h2x24(:,233),heltab2x48(:,:,259))
  call Hloop_AQ_W(ntryL,G1H48(171),ex2(:),G1H24(215),m3h2x24(:,234),heltab2x48(:,:,260))
  call Hloop_AQ_V(ntryL,G1H48(172),ex2(:),G1H24(216),m3h2x24(:,235),heltab2x48(:,:,261))
  call Hloop_AQ_V(ntryL,G1H48(175),ex2(:),G1H24(217),m3h2x24(:,236),heltab2x48(:,:,262))
  call Hloop_AQ_Z(ntryL,G1H48(176),ex2(:),G1H24(218),ngZu,m3h2x24(:,237),heltab2x48(:,:,263))
  call Hloop_AQ_Z(ntryL,G1H48(177),ex2(:),G1H24(219),ngZu,m3h2x24(:,238),heltab2x48(:,:,264))
  call Hloop_AQ_W(ntryL,G1H48(178),ex2(:),G1H24(220),m3h2x24(:,239),heltab2x48(:,:,265))
  call Hloop_AQ_W(ntryL,G1H48(179),ex2(:),G1H24(221),m3h2x24(:,240),heltab2x48(:,:,266))
  call Hloop_QA_S(ntryL,G1H48(180),ex3(:),G1H24(222),ngH,m3h2x24(:,241),heltab2x48(:,:,267))
  call Hloop_QA_S(ntryL,G1H48(181),ex3(:),G1H24(223),ngX,m3h2x24(:,242),heltab2x48(:,:,268))
  call Hloop_QA_V(ntryL,G1H48(182),ex3(:),G1H24(224),m3h2x24(:,243),heltab2x48(:,:,269))
  call Hloop_QA_Z(ntryL,G1H48(183),ex3(:),G1H24(225),ngZu,m3h2x24(:,244),heltab2x48(:,:,270))
  call Hloop_QA_S(ntryL,G1H48(184),ex3(:),G1H24(226),ngH,m3h2x24(:,245),heltab2x48(:,:,271))
  call Hloop_QA_V(ntryL,G1H48(185),ex3(:),G1H24(227),m3h2x24(:,246),heltab2x48(:,:,272))
  call Hloop_QA_Z(ntryL,G1H48(186),ex3(:),G1H24(228),ngZu,m3h2x24(:,247),heltab2x48(:,:,273))
  call Hloop_QA_S(ntryL,G1H48(187),ex3(:),G1H24(229),ngPtb,m3h2x24(:,248),heltab2x48(:,:,274))
  call Hloop_QA_S(ntryL,G1H48(188),ex3(:),G1H24(230),ngPtb,m3h2x24(:,249),heltab2x48(:,:,275))
  call Hloop_QA_W(ntryL,G1H48(189),ex3(:),G1H24(231),m3h2x24(:,250),heltab2x48(:,:,276))
  call Hloop_QA_S(ntryL,G1H48(190),ex3(:),G1H24(232),ngPtb,m3h2x24(:,251),heltab2x48(:,:,277))
  call Hloop_QA_S(ntryL,G1H48(191),ex3(:),G1H24(233),ngPtb,m3h2x24(:,252),heltab2x48(:,:,278))
  call Hloop_QA_W(ntryL,G1H48(192),ex3(:),G1H24(234),m3h2x24(:,253),heltab2x48(:,:,279))
  call Hloop_QA_W(ntryL,G1H48(193),ex3(:),G1H24(235),m3h2x24(:,254),heltab2x48(:,:,280))
  call Hloop_AQ_S(ntryL,G1H48(194),ex2(:),G1H24(236),ngH,m3h2x24(:,255),heltab2x48(:,:,281))
  call Hloop_AQ_S(ntryL,G1H48(195),ex2(:),G1H24(237),ngH,m3h2x24(:,256),heltab2x48(:,:,282))
  call Hloop_AQ_S(ntryL,G1H48(196),ex2(:),G1H24(238),ngX,m3h2x24(:,257),heltab2x48(:,:,283))
  call Hloop_AQ_S(ntryL,G1H48(197),ex2(:),G1H24(239),ngX,m3h2x24(:,258),heltab2x48(:,:,284))
  call Hloop_AQ_S(ntryL,G1H48(198),ex2(:),G1H24(240),ngH,m3h2x24(:,259),heltab2x48(:,:,285))
  call Hloop_AQ_S(ntryL,G1H48(199),ex2(:),G1H24(241),ngH,m3h2x24(:,260),heltab2x48(:,:,286))
  call Hloop_AQ_S(ntryL,G1H48(200),ex2(:),G1H24(242),ngX,m3h2x24(:,261),heltab2x48(:,:,287))
  call Hloop_AQ_S(ntryL,G1H48(201),ex2(:),G1H24(243),ngH,m3h2x24(:,262),heltab2x48(:,:,288))
  call Hloop_AQ_S(ntryL,G1H48(202),ex2(:),G1H24(244),ngX,m3h2x24(:,263),heltab2x48(:,:,289))
  call Hloop_AQ_V(ntryL,G1H48(203),ex2(:),G1H24(245),m3h2x24(:,264),heltab2x48(:,:,290))
  call Hloop_AQ_V(ntryL,G1H48(204),ex2(:),G1H24(246),m3h2x24(:,265),heltab2x48(:,:,291))
  call Hloop_AQ_Z(ntryL,G1H48(205),ex2(:),G1H24(247),ngZu,m3h2x24(:,266),heltab2x48(:,:,292))
  call Hloop_AQ_Z(ntryL,G1H48(206),ex2(:),G1H24(248),ngZu,m3h2x24(:,267),heltab2x48(:,:,293))
  call Hloop_AQ_S(ntryL,G1H48(207),ex2(:),G1H24(249),ngH,m3h2x24(:,268),heltab2x48(:,:,294))
  call Hloop_AQ_S(ntryL,G1H48(208),ex2(:),G1H24(250),ngH,m3h2x24(:,269),heltab2x48(:,:,295))
  call Hloop_AQ_V(ntryL,G1H48(209),ex2(:),G1H24(251),m3h2x24(:,270),heltab2x48(:,:,296))
  call Hloop_AQ_Z(ntryL,G1H48(210),ex2(:),G1H24(252),ngZu,m3h2x24(:,271),heltab2x48(:,:,297))
  call Hloop_AQ_V(ntryL,G1H48(211),ex2(:),G1H24(253),m3h2x24(:,272),heltab2x48(:,:,298))
  call Hloop_AQ_V(ntryL,G1H48(212),ex2(:),G1H24(254),m3h2x24(:,273),heltab2x48(:,:,299))
  call Hloop_AQ_Z(ntryL,G1H48(213),ex2(:),G1H24(255),ngZu,m3h2x24(:,274),heltab2x48(:,:,300))
  call Hloop_AQ_Z(ntryL,G1H48(214),ex2(:),G1H24(256),ngZu,m3h2x24(:,275),heltab2x48(:,:,301))
  call Hloop_AQ_V(ntryL,G1H48(215),ex2(:),G1H24(257),m3h2x24(:,276),heltab2x48(:,:,302))
  call Hloop_AQ_V(ntryL,G1H48(216),ex2(:),G1H24(258),m3h2x24(:,277),heltab2x48(:,:,303))
  call Hloop_AQ_Z(ntryL,G1H48(217),ex2(:),G1H24(259),ngZu,m3h2x24(:,278),heltab2x48(:,:,304))
  call Hloop_AQ_Z(ntryL,G1H48(218),ex2(:),G1H24(260),ngZu,m3h2x24(:,279),heltab2x48(:,:,305))
  call Hloop_AQ_S(ntryL,G1H48(219),ex2(:),G1H24(261),ngH,m3h2x24(:,280),heltab2x48(:,:,306))
  call Hloop_AQ_S(ntryL,G1H48(220),ex2(:),G1H24(262),ngX,m3h2x24(:,281),heltab2x48(:,:,307))
  call Hloop_AQ_S(ntryL,G1H48(221),ex2(:),G1H24(263),ngH,m3h2x24(:,282),heltab2x48(:,:,308))
  call Hloop_AQ_V(ntryL,G1H48(222),ex2(:),G1H24(264),m3h2x24(:,283),heltab2x48(:,:,309))
  call Hloop_AQ_Z(ntryL,G1H48(223),ex2(:),G1H24(265),ngZu,m3h2x24(:,284),heltab2x48(:,:,310))
  call Hloop_AQ_V(ntryL,G1H48(224),ex2(:),G1H24(266),m3h2x24(:,285),heltab2x48(:,:,311))
  call Hloop_AQ_Z(ntryL,G1H48(225),ex2(:),G1H24(267),ngZu,m3h2x24(:,286),heltab2x48(:,:,312))
  call Hloop_VA_Q(ntryL,G1H48(226),ex3(:),G1H24(268),m3h2x24(:,287),heltab2x48(:,:,313))
  call Hloop_A_Q(ntryL,G1H24(268),36,nMT,G2H24(6),n2h24(187))
  call Hloop_VA_Q(ntryL,G1H48(227),ex3(:),G1H24(268),m3h2x24(:,288),heltab2x48(:,:,314))
  call Hloop_A_Q(ntryL,G1H24(268),36,nMT,G2H24(7),n2h24(188))
  call Hloop_QA_V(ntryL,G1H48(233),ex4(:),G1H24(268),m3h2x24(:,289),heltab2x48(:,:,315))
  call Hloop_QA_V(ntryL,G1H48(235),ex4(:),G1H24(269),m3h2x24(:,290),heltab2x48(:,:,316))
  call Hloop_QA_Z(ntryL,G1H48(234),ex4(:),G1H24(270),ngZd,m3h2x24(:,291),heltab2x48(:,:,317))
  call Hloop_QA_Z(ntryL,G1H48(231),ex4(:),G1H24(271),ngZd,m3h2x24(:,292),heltab2x48(:,:,318))
  call Hloop_VQ_A(ntryL,G1H48(236),ex2(:),G1H24(272),m3h2x24(:,293),heltab2x48(:,:,319))
  call Hloop_Q_A(ntryL,G1H24(272),34,nMT,G2H24(8),n2h24(189))
  call Hloop_VQ_A(ntryL,G1H48(237),ex2(:),G1H24(272),m3h2x24(:,294),heltab2x48(:,:,320))
  call Hloop_Q_A(ntryL,G1H24(272),34,nMT,G2H24(9),n2h24(190))
  call Hloop_VQ_A(ntryL,G1H48(238),ex2(:),G1H24(272),m3h2x24(:,295),heltab2x48(:,:,321))
  call Hloop_Q_A(ntryL,G1H24(272),34,nMT,G2H24(10),n2h24(191))
  call Hloop_VQ_A(ntryL,G1H48(239),ex2(:),G1H24(272),m3h2x24(:,296),heltab2x48(:,:,322))
  call Hloop_Q_A(ntryL,G1H24(272),34,nMT,G2H24(11),n2h24(192))
  call Hloop_QA_V(ntryL,G1H48(246),ex4(:),G1H24(272),m3h2x24(:,297),heltab2x48(:,:,323))
  call Hloop_QA_Z(ntryL,G1H48(248),ex4(:),G1H24(273),ngZd,m3h2x24(:,298),heltab2x48(:,:,324))
  call Hloop_QA_V(ntryL,G1H48(247),ex4(:),G1H24(274),m3h2x24(:,299),heltab2x48(:,:,325))
  call Hloop_QA_Z(ntryL,G1H48(243),ex4(:),G1H24(275),ngZd,m3h2x24(:,300),heltab2x48(:,:,326))
  call Hloop_QA_W(ntryL,G1H48(244),ex4(:),G1H24(276),m3h2x24(:,301),heltab2x48(:,:,327))
  call Hloop_VA_Q(ntryL,G1H48(249),ex3(:),G1H24(277),m3h2x24(:,302),heltab2x48(:,:,328))
  call Hloop_A_Q(ntryL,G1H24(277),36,nMT,G2H24(12),n2h24(193))
  call Hloop_VA_Q(ntryL,G1H48(250),ex3(:),G1H24(277),m3h2x24(:,303),heltab2x48(:,:,329))
  call Hloop_A_Q(ntryL,G1H24(277),36,nMT,G2H24(13),n2h24(194))
  call Hloop_AQ_V(ntryL,G1H48(256),ex2(:),G1H24(277),m3h2x24(:,304),heltab2x48(:,:,330))
  call Hloop_AQ_V(ntryL,G1H48(258),ex2(:),G1H24(278),m3h2x24(:,305),heltab2x48(:,:,331))
  call Hloop_AQ_Z(ntryL,G1H48(257),ex2(:),G1H24(279),ngZu,m3h2x24(:,306),heltab2x48(:,:,332))
  call Hloop_AQ_Z(ntryL,G1H48(254),ex2(:),G1H24(280),ngZu,m3h2x24(:,307),heltab2x48(:,:,333))
  call Hloop_AQ_V(ntryL,G1H48(265),ex2(:),G1H24(281),m3h2x24(:,308),heltab2x48(:,:,334))
  call Hloop_AQ_V(ntryL,G1H48(267),ex2(:),G1H24(282),m3h2x24(:,309),heltab2x48(:,:,335))
  call Hloop_AQ_Z(ntryL,G1H48(266),ex2(:),G1H24(283),ngZu,m3h2x24(:,310),heltab2x48(:,:,336))
  call Hloop_AQ_Z(ntryL,G1H48(262),ex2(:),G1H24(284),ngZu,m3h2x24(:,311),heltab2x48(:,:,337))
  call Hloop_AQ_W(ntryL,G1H48(263),ex2(:),G1H24(285),m3h2x24(:,312),heltab2x48(:,:,338))
  call Hloop_QA_V(ntryL,G1H48(272),ex3(:),G1H24(286),m3h2x24(:,313),heltab2x48(:,:,339))
  call Hloop_QA_W(ntryL,G1H48(273),ex3(:),G1H24(287),m3h2x24(:,314),heltab2x48(:,:,340))
  call Hloop_QA_Z(ntryL,G1H48(270),ex3(:),G1H24(288),ngZu,m3h2x24(:,315),heltab2x48(:,:,341))
  call Hloop_QA_W(ntryL,G1H48(271),ex3(:),G1H24(289),m3h2x24(:,316),heltab2x48(:,:,342))
  call Hloop_VA_Q(ntryL,G1H48(274),ex4(:),G1H24(290),m3h2x24(:,317),heltab2x48(:,:,343))
  call Hloop_A_Q(ntryL,G1H24(290),40,0,G2H24(14),n2h24(195))
  call Hloop_AQ_V(ntryL,G1H48(279),ex1(:),G1H24(290),m3h2x24(:,318),heltab2x48(:,:,344))
  call Hloop_AQ_W(ntryL,G1H48(280),ex1(:),G1H24(291),m3h2x24(:,319),heltab2x48(:,:,345))
  call Hloop_AQ_Z(ntryL,G1H48(277),ex1(:),G1H24(292),ngZu,m3h2x24(:,320),heltab2x48(:,:,346))
  call Hloop_AQ_W(ntryL,G1H48(278),ex1(:),G1H24(293),m3h2x24(:,321),heltab2x48(:,:,347))
  call Hloop_VQ_A(ntryL,G1H48(281),ex1(:),G1H24(294),m3h2x24(:,322),heltab2x48(:,:,348))
  call Hloop_Q_A(ntryL,G1H24(294),33,0,G2H24(15),n2h24(196))
  call Hloop_VQ_A(ntryL,G1H48(282),ex1(:),G1H24(294),m3h2x24(:,323),heltab2x48(:,:,349))
  call Hloop_Q_A(ntryL,G1H24(294),33,0,G2H24(16),n2h24(197))
  call Hloop_QA_V(ntryL,G1H48(287),ex3(:),G1H24(294),m3h2x24(:,324),heltab2x48(:,:,350))
  call Hloop_QA_W(ntryL,G1H48(288),ex3(:),G1H24(295),m3h2x24(:,325),heltab2x48(:,:,351))
  call Hloop_QA_Z(ntryL,G1H48(285),ex3(:),G1H24(296),ngZu,m3h2x24(:,326),heltab2x48(:,:,352))
  call Hloop_QA_W(ntryL,G1H48(286),ex3(:),G1H24(297),m3h2x24(:,327),heltab2x48(:,:,353))
  call Hloop_VA_Q(ntryL,G1H48(289),ex3(:),G1H24(298),m3h2x24(:,328),heltab2x48(:,:,354))
  call Hloop_A_Q(ntryL,G1H24(298),36,nMT,G2H24(17),n2h24(198))
  call Hloop_AQ_V(ntryL,G1H48(294),ex1(:),G1H24(298),m3h2x24(:,329),heltab2x48(:,:,355))
  call Hloop_AQ_W(ntryL,G1H48(295),ex1(:),G1H24(299),m3h2x24(:,330),heltab2x48(:,:,356))
  call Hloop_AQ_Z(ntryL,G1H48(292),ex1(:),G1H24(300),ngZu,m3h2x24(:,331),heltab2x48(:,:,357))
  call Hloop_AQ_W(ntryL,G1H48(293),ex1(:),G1H24(301),m3h2x24(:,332),heltab2x48(:,:,358))
  call Hloop_AQ_V(ntryL,G1H48(301),ex1(:),G1H24(302),m3h2x24(:,333),heltab2x48(:,:,359))
  call Hloop_AQ_V(ntryL,G1H48(303),ex1(:),G1H24(303),m3h2x24(:,334),heltab2x48(:,:,360))
  call Hloop_AQ_Z(ntryL,G1H48(302),ex1(:),G1H24(304),ngZu,m3h2x24(:,335),heltab2x48(:,:,361))
  call Hloop_AQ_Z(ntryL,G1H48(299),ex1(:),G1H24(305),ngZu,m3h2x24(:,336),heltab2x48(:,:,362))
  call Hloop_VA_Q(ntryL,G1H48(304),ex3(:),G1H24(306),m3h2x24(:,337),heltab2x48(:,:,363))
  call Hloop_A_Q(ntryL,G1H24(306),36,nMT,G2H24(18),n2h24(199))
  call Hloop_VA_Q(ntryL,G1H48(305),ex3(:),G1H24(306),m3h2x24(:,338),heltab2x48(:,:,364))
  call Hloop_A_Q(ntryL,G1H24(306),36,nMT,G2H24(19),n2h24(200))
  call Hloop_AQ_V(ntryL,G1H48(311),ex2(:),G1H24(306),m3h2x24(:,339),heltab2x48(:,:,365))
  call Hloop_AQ_V(ntryL,G1H48(313),ex2(:),G1H24(307),m3h2x24(:,340),heltab2x48(:,:,366))
  call Hloop_AQ_Z(ntryL,G1H48(312),ex2(:),G1H24(308),ngZu,m3h2x24(:,341),heltab2x48(:,:,367))
  call Hloop_AQ_Z(ntryL,G1H48(309),ex2(:),G1H24(309),ngZu,m3h2x24(:,342),heltab2x48(:,:,368))
  call Hloop_AQ_V(ntryL,G1H48(320),ex1(:),G1H24(310),m3h2x24(:,343),heltab2x48(:,:,369))
  call Hloop_AQ_V(ntryL,G1H48(322),ex1(:),G1H24(311),m3h2x24(:,344),heltab2x48(:,:,370))
  call Hloop_AQ_Z(ntryL,G1H48(321),ex1(:),G1H24(312),ngZu,m3h2x24(:,345),heltab2x48(:,:,371))
  call Hloop_AQ_Z(ntryL,G1H48(317),ex1(:),G1H24(313),ngZu,m3h2x24(:,346),heltab2x48(:,:,372))
  call Hloop_AQ_W(ntryL,G1H48(318),ex1(:),G1H24(314),m3h2x24(:,347),heltab2x48(:,:,373))
  call Hloop_VQ_A(ntryL,G1H48(323),ex2(:),G1H24(315),m3h2x24(:,348),heltab2x48(:,:,374))
  call Hloop_Q_A(ntryL,G1H24(315),34,nMT,G2H24(20),n2h24(201))
  call Hloop_VQ_A(ntryL,G1H48(324),ex2(:),G1H24(315),m3h2x24(:,349),heltab2x48(:,:,375))
  call Hloop_Q_A(ntryL,G1H24(315),34,nMT,G2H24(21),n2h24(202))
  call Hloop_AQ_V(ntryL,G1H48(331),ex2(:),G1H24(315),m3h2x24(:,350),heltab2x48(:,:,376))
  call Hloop_AQ_Z(ntryL,G1H48(333),ex2(:),G1H24(316),ngZu,m3h2x24(:,351),heltab2x48(:,:,377))
  call Hloop_AQ_V(ntryL,G1H48(332),ex2(:),G1H24(317),m3h2x24(:,352),heltab2x48(:,:,378))
  call Hloop_AQ_Z(ntryL,G1H48(328),ex2(:),G1H24(318),ngZu,m3h2x24(:,353),heltab2x48(:,:,379))
  call Hloop_AQ_W(ntryL,G1H48(329),ex2(:),G1H24(319),m3h2x24(:,354),heltab2x48(:,:,380))
  call Hloop_VQ_A(ntryL,G1H48(334),ex1(:),G1H24(320),m3h2x24(:,355),heltab2x48(:,:,381))
  call Hloop_Q_A(ntryL,G1H24(320),33,0,G2H24(22),n2h24(203))
  call Hloop_VQ_A(ntryL,G1H48(335),ex1(:),G1H24(320),m3h2x24(:,356),heltab2x48(:,:,382))
  call Hloop_Q_A(ntryL,G1H24(320),33,0,G2H24(23),n2h24(204))
  call Hloop_VQ_A(ntryL,G1H48(336),ex1(:),G1H24(320),m3h2x24(:,357),heltab2x48(:,:,383))
  call Hloop_Q_A(ntryL,G1H24(320),33,0,G2H24(24),n2h24(205))
  call Hloop_VQ_A(ntryL,G1H48(337),ex1(:),G1H24(320),m3h2x24(:,358),heltab2x48(:,:,384))
  call Hloop_Q_A(ntryL,G1H24(320),33,0,G2H24(25),n2h24(206))
  call Hloop_QA_V(ntryL,G1H24(32),ex4(:),G1H12(46),m3h2x12(:,87),heltab2x24(:,:,148))
  call Hloop_QA_Z(ntryL,G1H24(31),ex4(:),G1H12(47),ngZd,m3h2x12(:,88),heltab2x24(:,:,149))
  call Hloop_QA_V(ntryL,G1H24(37),ex4(:),G1H12(48),m3h2x12(:,89),heltab2x24(:,:,150))
  call Hloop_QA_V(ntryL,G1H24(38),ex4(:),G1H12(49),m3h2x12(:,90),heltab2x24(:,:,151))
  call Hloop_QA_Z(ntryL,G1H24(35),ex4(:),G1H12(52),ngZd,m3h2x12(:,91),heltab2x24(:,:,152))
  call Hloop_QA_Z(ntryL,G1H24(36),ex4(:),G1H12(53),ngZd,m3h2x12(:,92),heltab2x24(:,:,153))
  call Hloop_VA_Q(ntryL,G0H24(6),ex3(:),G0H12(1),m3h2x12(:,93),heltab2x24(:,:,154))
  call Hloop_A_Q(ntryL,G0H12(1),37,nMT,G1H12(54),n2h12(116))
  call Hloop_ZA_Q(ntryL,G0H24(8),ex3(:),G0H12(1),ngZu,m3h2x12(:,94),heltab2x24(:,:,155))
  call Hloop_A_Q(ntryL,G0H12(1),37,nMT,G1H12(55),n2h12(117))
  call Hloop_VA_Q(ntryL,G0H24(7),ex3(:),G0H12(1),m3h2x12(:,95),heltab2x24(:,:,156))
  call Hloop_A_Q(ntryL,G0H12(1),37,nMT,G1H12(58),n2h12(118))
  call Hloop_ZA_Q(ntryL,G0H24(4),ex3(:),G0H12(1),ngZu,m3h2x12(:,96),heltab2x24(:,:,157))
  call Hloop_A_Q(ntryL,G0H12(1),37,nMT,G1H12(59),n2h12(119))
  call Hloop_QA_V(ntryL,G1H24(43),ex4(:),G1H12(60),m3h2x12(:,97),heltab2x24(:,:,158))
  call Hloop_QA_W(ntryL,G1H24(40),ex4(:),G1H12(61),m3h2x12(:,98),heltab2x24(:,:,159))
  call Hloop_QA_Z(ntryL,G1H24(41),ex4(:),G1H12(64),ngZd,m3h2x12(:,99),heltab2x24(:,:,160))
  call Hloop_QA_W(ntryL,G1H24(42),ex4(:),G1H12(65),m3h2x12(:,100),heltab2x24(:,:,161))
  call Hloop_QA_V(ntryL,G1H24(50),ex4(:),G1H12(66),m3h2x12(:,101),heltab2x24(:,:,162))
  call Hloop_QA_Z(ntryL,G1H24(45),ex4(:),G1H12(67),ngZd,m3h2x12(:,102),heltab2x24(:,:,163))
  call Hloop_QA_V(ntryL,G1H24(51),ex4(:),G1H12(70),m3h2x12(:,103),heltab2x24(:,:,164))
  call Hloop_QA_Z(ntryL,G1H24(47),ex4(:),G1H12(71),ngZd,m3h2x12(:,104),heltab2x24(:,:,165))
  call Hloop_QA_W(ntryL,G1H24(48),ex4(:),G1H12(72),m3h2x12(:,105),heltab2x24(:,:,166))
  call Hloop_QA_W(ntryL,G1H24(49),ex4(:),G1H12(73),m3h2x12(:,106),heltab2x24(:,:,167))
  call Hloop_VA_Q(ntryL,G0H24(13),ex3(:),G0H12(1),m3h2x12(:,107),heltab2x24(:,:,168))
  call Hloop_A_Q(ntryL,G0H12(1),37,nMT,G1H12(76),n2h12(120))
  call Hloop_WA_Q(ntryL,G0H24(10),ex3(:),G0H12(1),m3h2x12(:,108),heltab2x24(:,:,169))
  call Hloop_A_Q(ntryL,G0H12(1),37,nMB,G1H12(77),n2h12(121))
  call Hloop_ZA_Q(ntryL,G0H24(11),ex3(:),G0H12(1),ngZu,m3h2x12(:,109),heltab2x24(:,:,170))
  call Hloop_A_Q(ntryL,G0H12(1),37,nMT,G1H12(78),n2h12(122))
  call Hloop_WA_Q(ntryL,G0H24(12),ex3(:),G0H12(1),m3h2x12(:,110),heltab2x24(:,:,171))
  call Hloop_A_Q(ntryL,G0H12(1),37,nMB,G1H12(79),n2h12(123))
  call Hloop_VA_Q(ntryL,G0H24(20),ex3(:),G0H12(1),m3h2x12(:,111),heltab2x24(:,:,172))
  call Hloop_A_Q(ntryL,G0H12(1),37,nMT,G1H12(82),n2h12(124))
  call Hloop_ZA_Q(ntryL,G0H24(15),ex3(:),G0H12(1),ngZu,m3h2x12(:,112),heltab2x24(:,:,173))
  call Hloop_A_Q(ntryL,G0H12(1),37,nMT,G1H12(83),n2h12(125))
  call Hloop_VA_Q(ntryL,G0H24(21),ex3(:),G0H12(1),m3h2x12(:,113),heltab2x24(:,:,174))
  call Hloop_A_Q(ntryL,G0H12(1),37,nMT,G1H12(84),n2h12(126))
  call Hloop_ZA_Q(ntryL,G0H24(17),ex3(:),G0H12(1),ngZu,m3h2x12(:,114),heltab2x24(:,:,175))
  call Hloop_A_Q(ntryL,G0H12(1),37,nMT,G1H12(85),n2h12(127))
  call Hloop_WA_Q(ntryL,G0H24(18),ex3(:),G0H12(1),m3h2x12(:,115),heltab2x24(:,:,176))
  call Hloop_A_Q(ntryL,G0H12(1),37,nMB,G1H12(88),n2h12(128))
  call Hloop_WA_Q(ntryL,G0H24(19),ex3(:),G0H12(1),m3h2x12(:,116),heltab2x24(:,:,177))
  call Hloop_A_Q(ntryL,G0H12(1),37,nMB,G1H12(89),n2h12(129))
  call Hloop_VQ_A(ntryL,G0H24(27),ex2(:),G0H12(1),m3h2x12(:,117),heltab2x24(:,:,178))
  call Hloop_Q_A(ntryL,G0H12(1),35,nMT,G1H12(90),n2h12(130))
  call Hloop_VQ_A(ntryL,G0H24(29),ex2(:),G0H12(1),m3h2x12(:,118),heltab2x24(:,:,179))
  call Hloop_Q_A(ntryL,G0H12(1),35,nMT,G1H12(91),n2h12(131))
  call Hloop_ZQ_A(ntryL,G0H24(28),ex2(:),G0H12(1),ngZu,m3h2x12(:,119),heltab2x24(:,:,180))
  call Hloop_Q_A(ntryL,G0H12(1),35,nMT,G1H12(94),n2h12(132))
  call Hloop_ZQ_A(ntryL,G0H24(25),ex2(:),G0H12(1),ngZu,m3h2x12(:,120),heltab2x24(:,:,181))
  call Hloop_Q_A(ntryL,G0H12(1),35,nMT,G1H12(95),n2h12(133))
  call Hloop_VQ_A(ntryL,G0H24(32),ex2(:),G0H12(1),m3h2x12(:,121),heltab2x24(:,:,182))
  call Hloop_Q_A(ntryL,G0H12(1),35,nMT,G1H12(96),n2h12(134))
  call Hloop_ZQ_A(ntryL,G0H24(31),ex2(:),G0H12(1),ngZu,m3h2x12(:,122),heltab2x24(:,:,183))
  call Hloop_Q_A(ntryL,G0H12(1),35,nMT,G1H12(97),n2h12(135))
  call Hloop_VQ_A(ntryL,G0H24(37),ex2(:),G0H12(1),m3h2x12(:,123),heltab2x24(:,:,184))
  call Hloop_Q_A(ntryL,G0H12(1),35,nMT,G1H12(100),n2h12(136))
  call Hloop_VQ_A(ntryL,G0H24(38),ex2(:),G0H12(1),m3h2x12(:,124),heltab2x24(:,:,185))
  call Hloop_Q_A(ntryL,G0H12(1),35,nMT,G1H12(101),n2h12(137))
  call Hloop_ZQ_A(ntryL,G0H24(35),ex2(:),G0H12(1),ngZu,m3h2x12(:,125),heltab2x24(:,:,186))
  call Hloop_Q_A(ntryL,G0H12(1),35,nMT,G1H12(102),n2h12(138))
  call Hloop_ZQ_A(ntryL,G0H24(36),ex2(:),G0H12(1),ngZu,m3h2x12(:,126),heltab2x24(:,:,187))
  call Hloop_Q_A(ntryL,G0H12(1),35,nMT,G1H12(103),n2h12(139))
  call Hloop_WA_Q(ntryL,G0H24(41),ex3(:),G0H12(1),m3h2x12(:,127),heltab2x24(:,:,188))
  call Hloop_A_Q(ntryL,G0H12(1),37,nMB,G1H12(106),n2h12(140))
  call Hloop_WA_Q(ntryL,G0H24(40),ex3(:),G0H12(1),m3h2x12(:,128),heltab2x24(:,:,189))
  call Hloop_A_Q(ntryL,G0H12(1),37,nMB,G1H12(107),n2h12(141))
  call Hloop_VQ_A(ntryL,G0H24(44),ex2(:),G0H12(1),m3h2x12(:,129),heltab2x24(:,:,190))
  call Hloop_Q_A(ntryL,G0H12(1),35,nMT,G1H12(108),n2h12(142))
  call Hloop_ZQ_A(ntryL,G0H24(43),ex2(:),G0H12(1),ngZu,m3h2x12(:,130),heltab2x24(:,:,191))
  call Hloop_Q_A(ntryL,G0H12(1),35,nMT,G1H12(109),n2h12(143))
  call Hloop_VA_Q(ntryL,G0H24(47),ex4(:),G0H12(1),m3h2x12(:,131),heltab2x24(:,:,192))
  call Hloop_A_Q(ntryL,G0H12(1),42,0,G1H12(112),n2h12(144))
  call Hloop_ZA_Q(ntryL,G0H24(46),ex4(:),G0H12(1),ngZd,m3h2x12(:,132),heltab2x24(:,:,193))
  call Hloop_A_Q(ntryL,G0H12(1),42,0,G1H12(113),n2h12(145))
  call Hloop_QA_V(ntryL,G1H24(56),ex3(:),G1H12(114),m3h2x12(:,133),heltab2x24(:,:,194))
  call Hloop_QA_W(ntryL,G1H24(53),ex3(:),G1H12(115),m3h2x12(:,134),heltab2x24(:,:,195))
  call Hloop_QA_Z(ntryL,G1H24(54),ex3(:),G1H12(118),ngZu,m3h2x12(:,135),heltab2x24(:,:,196))
  call Hloop_QA_W(ntryL,G1H24(55),ex3(:),G1H12(119),m3h2x12(:,136),heltab2x24(:,:,197))
  call Hloop_QA_V(ntryL,G1H24(63),ex3(:),G1H12(120),m3h2x12(:,137),heltab2x24(:,:,198))
  call Hloop_QA_V(ntryL,G1H24(64),ex3(:),G1H12(121),m3h2x12(:,138),heltab2x24(:,:,199))
  call Hloop_QA_Z(ntryL,G1H24(59),ex3(:),G1H12(124),ngZu,m3h2x12(:,139),heltab2x24(:,:,200))
  call Hloop_QA_Z(ntryL,G1H24(60),ex3(:),G1H12(125),ngZu,m3h2x12(:,140),heltab2x24(:,:,201))
  call Hloop_QA_W(ntryL,G1H24(61),ex3(:),G1H12(126),m3h2x12(:,141),heltab2x24(:,:,202))
  call Hloop_QA_W(ntryL,G1H24(62),ex3(:),G1H12(127),m3h2x12(:,142),heltab2x24(:,:,203))
  call Hloop_QA_V(ntryL,G1H24(70),ex3(:),G1H12(130),m3h2x12(:,143),heltab2x24(:,:,204))
  call Hloop_QA_V(ntryL,G1H24(72),ex3(:),G1H12(131),m3h2x12(:,144),heltab2x24(:,:,205))
  call Hloop_QA_Z(ntryL,G1H24(71),ex3(:),G1H12(132),ngZu,m3h2x12(:,145),heltab2x24(:,:,206))
  call Hloop_QA_Z(ntryL,G1H24(68),ex3(:),G1H12(133),ngZu,m3h2x12(:,146),heltab2x24(:,:,207))
  call Hloop_QA_V(ntryL,G1H24(77),ex3(:),G1H12(136),m3h2x12(:,147),heltab2x24(:,:,208))
  call Hloop_QA_W(ntryL,G1H24(74),ex3(:),G1H12(137),m3h2x12(:,148),heltab2x24(:,:,209))
  call Hloop_QA_Z(ntryL,G1H24(75),ex3(:),G1H12(138),ngZu,m3h2x12(:,149),heltab2x24(:,:,210))
  call Hloop_QA_W(ntryL,G1H24(76),ex3(:),G1H12(139),m3h2x12(:,150),heltab2x24(:,:,211))
  call Hloop_QA_V(ntryL,G1H24(84),ex3(:),G1H12(142),m3h2x12(:,151),heltab2x24(:,:,212))
  call Hloop_QA_V(ntryL,G1H24(85),ex3(:),G1H12(143),m3h2x12(:,152),heltab2x24(:,:,213))
  call Hloop_QA_Z(ntryL,G1H24(80),ex3(:),G1H12(144),ngZu,m3h2x12(:,153),heltab2x24(:,:,214))
  call Hloop_QA_Z(ntryL,G1H24(81),ex3(:),G1H12(145),ngZu,m3h2x12(:,154),heltab2x24(:,:,215))
  call Hloop_QA_W(ntryL,G1H24(82),ex3(:),G1H12(148),m3h2x12(:,155),heltab2x24(:,:,216))
  call Hloop_QA_W(ntryL,G1H24(83),ex3(:),G1H12(149),m3h2x12(:,156),heltab2x24(:,:,217))
  call Hloop_QA_S(ntryL,G1H24(88),ex3(:),G1H12(150),ngH,m3h2x12(:,157),heltab2x24(:,:,218))
  call Hloop_QA_S(ntryL,G1H24(87),ex3(:),G1H12(151),ngH,m3h2x12(:,158),heltab2x24(:,:,219))
  call Hloop_QA_V(ntryL,G1H24(93),ex3(:),G1H12(154),m3h2x12(:,159),heltab2x24(:,:,220))
  call Hloop_QA_V(ntryL,G1H24(90),ex3(:),G1H12(155),m3h2x12(:,160),heltab2x24(:,:,221))
  call Hloop_QA_Z(ntryL,G1H24(94),ex3(:),G1H12(6),ngZu,m3h2x12(:,161),heltab2x24(:,:,222))
  call Hloop_QA_Z(ntryL,G1H24(92),ex3(:),G1H12(7),ngZu,m3h2x12(:,162),heltab2x24(:,:,223))
  call Hloop_VQ_A(ntryL,G0H24(50),ex1(:),G0H12(1),m3h2x12(:,163),heltab2x24(:,:,224))
  call Hloop_Q_A(ntryL,G0H12(1),35,0,G1H12(10),n2h12(146))
  call Hloop_ZQ_A(ntryL,G0H24(49),ex1(:),G0H12(1),ngZu,m3h2x12(:,164),heltab2x24(:,:,225))
  call Hloop_Q_A(ntryL,G0H12(1),35,0,G1H12(11),n2h12(147))
  call Hloop_VQ_A(ntryL,G0H24(53),ex1(:),G0H12(1),m3h2x12(:,165),heltab2x24(:,:,226))
  call Hloop_Q_A(ntryL,G0H12(1),35,0,G1H12(12),n2h12(148))
  call Hloop_ZQ_A(ntryL,G0H24(52),ex1(:),G0H12(1),ngZu,m3h2x12(:,166),heltab2x24(:,:,227))
  call Hloop_Q_A(ntryL,G0H12(1),35,0,G1H12(13),n2h12(149))
  call Hloop_VQ_A(ntryL,G0H24(58),ex1(:),G0H12(1),m3h2x12(:,167),heltab2x24(:,:,228))
  call Hloop_Q_A(ntryL,G0H12(1),35,0,G1H12(16),n2h12(150))
  call Hloop_VQ_A(ntryL,G0H24(59),ex1(:),G0H12(1),m3h2x12(:,168),heltab2x24(:,:,229))
  call Hloop_Q_A(ntryL,G0H12(1),35,0,G1H12(17),n2h12(151))
  call Hloop_ZQ_A(ntryL,G0H24(56),ex1(:),G0H12(1),ngZu,m3h2x12(:,169),heltab2x24(:,:,230))
  call Hloop_Q_A(ntryL,G0H12(1),35,0,G1H12(18),n2h12(152))
  call Hloop_ZQ_A(ntryL,G0H24(57),ex1(:),G0H12(1),ngZu,m3h2x12(:,170),heltab2x24(:,:,231))
  call Hloop_Q_A(ntryL,G0H12(1),35,0,G1H12(19),n2h12(153))
  call Hloop_VQ_A(ntryL,G0H24(65),ex1(:),G0H12(1),m3h2x12(:,171),heltab2x24(:,:,232))
  call Hloop_Q_A(ntryL,G0H12(1),35,0,G1H12(22),n2h12(154))
  call Hloop_VQ_A(ntryL,G0H24(67),ex1(:),G0H12(1),m3h2x12(:,172),heltab2x24(:,:,233))
  call Hloop_Q_A(ntryL,G0H12(1),35,0,G1H12(23),n2h12(155))
  call Hloop_ZQ_A(ntryL,G0H24(66),ex1(:),G0H12(1),ngZu,m3h2x12(:,173),heltab2x24(:,:,234))
  call Hloop_Q_A(ntryL,G0H12(1),35,0,G1H12(24),n2h12(156))
  call Hloop_ZQ_A(ntryL,G0H24(63),ex1(:),G0H12(1),ngZu,m3h2x12(:,174),heltab2x24(:,:,235))
  call Hloop_Q_A(ntryL,G0H12(1),35,0,G1H12(25),n2h12(157))
  call Hloop_WA_Q(ntryL,G0H24(70),ex4(:),G0H12(1),m3h2x12(:,175),heltab2x24(:,:,236))
  call Hloop_A_Q(ntryL,G0H12(1),44,0,G1H12(28),n2h12(158))
  call Hloop_WA_Q(ntryL,G0H24(69),ex4(:),G0H12(1),m3h2x12(:,176),heltab2x24(:,:,237))
  call Hloop_A_Q(ntryL,G0H12(1),44,0,G1H12(29),n2h12(159))
  call Hloop_AQ_V(ntryL,G1H24(97),ex2(:),G1H12(30),m3h2x12(:,177),heltab2x24(:,:,238))
  call Hloop_AQ_Z(ntryL,G1H24(96),ex2(:),G1H12(31),ngZu,m3h2x12(:,178),heltab2x24(:,:,239))
  call Hloop_AQ_V(ntryL,G1H24(1),ex2(:),G1H12(34),m3h2x12(:,179),heltab2x24(:,:,240))
  call Hloop_AQ_V(ntryL,G1H24(3),ex2(:),G1H12(35),m3h2x12(:,180),heltab2x24(:,:,241))
  call Hloop_AQ_Z(ntryL,G1H24(100),ex2(:),G1H12(36),ngZu,m3h2x12(:,181),heltab2x24(:,:,242))
  call Hloop_AQ_Z(ntryL,G1H24(101),ex2(:),G1H12(37),ngZu,m3h2x12(:,182),heltab2x24(:,:,243))
  call Hloop_AQ_V(ntryL,G1H24(10),ex2(:),G1H12(40),m3h2x12(:,183),heltab2x24(:,:,244))
  call Hloop_AQ_V(ntryL,G1H24(12),ex2(:),G1H12(41),m3h2x12(:,184),heltab2x24(:,:,245))
  call Hloop_AQ_Z(ntryL,G1H24(11),ex2(:),G1H12(42),ngZu,m3h2x12(:,185),heltab2x24(:,:,246))
  call Hloop_AQ_Z(ntryL,G1H24(7),ex2(:),G1H12(43),ngZu,m3h2x12(:,186),heltab2x24(:,:,247))
  call Hloop_AQ_V(ntryL,G1H24(16),ex2(:),G1H12(156),m3h2x12(:,187),heltab2x24(:,:,248))
  call Hloop_AQ_Z(ntryL,G1H24(15),ex2(:),G1H12(157),ngZu,m3h2x12(:,188),heltab2x24(:,:,249))
  call Hloop_AQ_V(ntryL,G1H24(22),ex2(:),G1H12(158),m3h2x12(:,189),heltab2x24(:,:,250))
  call Hloop_AQ_V(ntryL,G1H24(23),ex2(:),G1H12(159),m3h2x12(:,190),heltab2x24(:,:,251))
  call Hloop_AQ_Z(ntryL,G1H24(19),ex2(:),G1H12(160),ngZu,m3h2x12(:,191),heltab2x24(:,:,252))
  call Hloop_AQ_Z(ntryL,G1H24(21),ex2(:),G1H12(161),ngZu,m3h2x12(:,192),heltab2x24(:,:,253))
  call Hloop_AQ_S(ntryL,G1H24(29),ex2(:),G1H12(162),ngH,m3h2x12(:,193),heltab2x24(:,:,254))
  call Hloop_AQ_S(ntryL,G1H24(25),ex2(:),G1H12(163),ngPbt,m3h2x12(:,194),heltab2x24(:,:,255))
  call Hloop_AQ_S(ntryL,G1H24(27),ex2(:),G1H12(164),ngH,m3h2x12(:,195),heltab2x24(:,:,256))
  call Hloop_AQ_S(ntryL,G1H24(28),ex2(:),G1H12(165),ngPbt,m3h2x12(:,196),heltab2x24(:,:,257))
  call Hloop_AQ_V(ntryL,G1H24(108),ex2(:),G1H12(166),m3h2x12(:,197),heltab2x24(:,:,258))
  call Hloop_AQ_V(ntryL,G1H24(103),ex2(:),G1H12(167),m3h2x12(:,198),heltab2x24(:,:,259))
  call Hloop_AQ_Z(ntryL,G1H24(109),ex2(:),G1H12(168),ngZu,m3h2x12(:,199),heltab2x24(:,:,260))
  call Hloop_AQ_Z(ntryL,G1H24(105),ex2(:),G1H12(169),ngZu,m3h2x12(:,200),heltab2x24(:,:,261))
  call Hloop_AQ_W(ntryL,G1H24(106),ex2(:),G1H12(170),m3h2x12(:,201),heltab2x24(:,:,262))
  call Hloop_AQ_W(ntryL,G1H24(107),ex2(:),G1H12(171),m3h2x12(:,202),heltab2x24(:,:,263))
  call Hloop_WQ_A(ntryL,G0H24(73),ex1(:),G0H12(1),m3h2x12(:,203),heltab2x24(:,:,264))
  call Hloop_Q_A(ntryL,G0H12(1),37,0,G1H12(172),n2h12(160))
  call Hloop_WQ_A(ntryL,G0H24(72),ex1(:),G0H12(1),m3h2x12(:,204),heltab2x24(:,:,265))
  call Hloop_Q_A(ntryL,G0H12(1),37,0,G1H12(173),n2h12(161))
  call Hloop_VQ_A(ntryL,G0H24(78),ex1(:),G0H12(1),m3h2x12(:,205),heltab2x24(:,:,266))
  call Hloop_Q_A(ntryL,G0H12(1),37,0,G1H12(174),n2h12(162))
  call Hloop_WQ_A(ntryL,G0H24(75),ex1(:),G0H12(1),m3h2x12(:,206),heltab2x24(:,:,267))
  call Hloop_Q_A(ntryL,G0H12(1),37,0,G1H12(175),n2h12(163))
  call Hloop_ZQ_A(ntryL,G0H24(76),ex1(:),G0H12(1),ngZu,m3h2x12(:,207),heltab2x24(:,:,268))
  call Hloop_Q_A(ntryL,G0H12(1),37,0,G1H12(176),n2h12(164))
  call Hloop_WQ_A(ntryL,G0H24(77),ex1(:),G0H12(1),m3h2x12(:,208),heltab2x24(:,:,269))
  call Hloop_Q_A(ntryL,G0H12(1),37,0,G1H12(177),n2h12(165))
  call Hloop_VQ_A(ntryL,G0H24(85),ex1(:),G0H12(1),m3h2x12(:,209),heltab2x24(:,:,270))
  call Hloop_Q_A(ntryL,G0H12(1),37,0,G1H12(178),n2h12(166))
  call Hloop_VQ_A(ntryL,G0H24(86),ex1(:),G0H12(1),m3h2x12(:,210),heltab2x24(:,:,271))
  call Hloop_Q_A(ntryL,G0H12(1),37,0,G1H12(179),n2h12(167))
  call Hloop_ZQ_A(ntryL,G0H24(81),ex1(:),G0H12(1),ngZu,m3h2x12(:,211),heltab2x24(:,:,272))
  call Hloop_Q_A(ntryL,G0H12(1),37,0,G1H12(180),n2h12(168))
  call Hloop_ZQ_A(ntryL,G0H24(82),ex1(:),G0H12(1),ngZu,m3h2x12(:,212),heltab2x24(:,:,273))
  call Hloop_Q_A(ntryL,G0H12(1),37,0,G1H12(181),n2h12(169))
  call Hloop_WQ_A(ntryL,G0H24(83),ex1(:),G0H12(1),m3h2x12(:,213),heltab2x24(:,:,274))
  call Hloop_Q_A(ntryL,G0H12(1),37,0,G1H12(182),n2h12(170))
  call Hloop_WQ_A(ntryL,G0H24(84),ex1(:),G0H12(1),m3h2x12(:,214),heltab2x24(:,:,275))
  call Hloop_Q_A(ntryL,G0H12(1),37,0,G1H12(183),n2h12(171))
  call Hloop_VQ_A(ntryL,G0H24(92),ex1(:),G0H12(1),m3h2x12(:,215),heltab2x24(:,:,276))
  call Hloop_Q_A(ntryL,G0H12(1),37,0,G1H12(184),n2h12(172))
  call Hloop_VQ_A(ntryL,G0H24(94),ex1(:),G0H12(1),m3h2x12(:,216),heltab2x24(:,:,277))
  call Hloop_Q_A(ntryL,G0H12(1),37,0,G1H12(185),n2h12(173))
  call Hloop_ZQ_A(ntryL,G0H24(93),ex1(:),G0H12(1),ngZu,m3h2x12(:,217),heltab2x24(:,:,278))
  call Hloop_Q_A(ntryL,G0H12(1),37,0,G1H12(186),n2h12(174))
  call Hloop_ZQ_A(ntryL,G0H24(90),ex1(:),G0H12(1),ngZu,m3h2x12(:,218),heltab2x24(:,:,279))
  call Hloop_Q_A(ntryL,G0H12(1),37,0,G1H12(187),n2h12(175))
  call Hloop_VA_Q(ntryL,G0H24(100),ex3(:),G0H12(1),m3h2x12(:,219),heltab2x24(:,:,280))
  call Hloop_A_Q(ntryL,G0H12(1),44,nMT,G1H12(188),n2h12(176))
  call Hloop_ZA_Q(ntryL,G0H24(102),ex3(:),G0H12(1),ngZu,m3h2x12(:,220),heltab2x24(:,:,281))
  call Hloop_A_Q(ntryL,G0H12(1),44,nMT,G1H12(189),n2h12(177))
  call Hloop_VA_Q(ntryL,G0H24(101),ex3(:),G0H12(1),m3h2x12(:,221),heltab2x24(:,:,282))
  call Hloop_A_Q(ntryL,G0H12(1),44,nMT,G1H12(190),n2h12(178))
  call Hloop_ZA_Q(ntryL,G0H24(98),ex3(:),G0H12(1),ngZu,m3h2x12(:,222),heltab2x24(:,:,283))
  call Hloop_A_Q(ntryL,G0H12(1),44,nMT,G1H12(191),n2h12(179))
  call Hloop_AQ_V(ntryL,G1H24(112),ex1(:),G1H12(192),m3h2x12(:,223),heltab2x24(:,:,284))
  call Hloop_AQ_Z(ntryL,G1H24(111),ex1(:),G1H12(193),ngZu,m3h2x12(:,224),heltab2x24(:,:,285))
  call Hloop_AQ_V(ntryL,G1H24(117),ex1(:),G1H12(194),m3h2x12(:,225),heltab2x24(:,:,286))
  call Hloop_AQ_V(ntryL,G1H24(118),ex1(:),G1H12(195),m3h2x12(:,226),heltab2x24(:,:,287))
  call Hloop_AQ_Z(ntryL,G1H24(115),ex1(:),G1H12(196),ngZu,m3h2x12(:,227),heltab2x24(:,:,288))
  call Hloop_AQ_Z(ntryL,G1H24(116),ex1(:),G1H12(197),ngZu,m3h2x12(:,228),heltab2x24(:,:,289))
  call Hloop_AQ_V(ntryL,G1H24(121),ex1(:),G1H12(198),m3h2x12(:,229),heltab2x24(:,:,290))
  call Hloop_AQ_Z(ntryL,G1H24(120),ex1(:),G1H12(199),ngZu,m3h2x12(:,230),heltab2x24(:,:,291))
  call Hloop_VQ_A(ntryL,G0H24(108),ex2(:),G0H12(1),m3h2x12(:,231),heltab2x24(:,:,292))
  call Hloop_Q_A(ntryL,G0H12(1),42,nMT,G1H12(200),n2h12(180))
  call Hloop_ZQ_A(ntryL,G0H24(110),ex2(:),G0H12(1),ngZu,m3h2x12(:,232),heltab2x24(:,:,293))
  call Hloop_Q_A(ntryL,G0H12(1),42,nMT,G1H12(201),n2h12(181))
  call Hloop_VQ_A(ntryL,G0H24(109),ex2(:),G0H12(1),m3h2x12(:,233),heltab2x24(:,:,294))
  call Hloop_Q_A(ntryL,G0H12(1),42,nMT,G1H12(202),n2h12(182))
  call Hloop_ZQ_A(ntryL,G0H24(106),ex2(:),G0H12(1),ngZu,m3h2x12(:,234),heltab2x24(:,:,295))
  call Hloop_Q_A(ntryL,G0H12(1),42,nMT,G1H12(203),n2h12(183))
  call Hloop_AQ_V(ntryL,G1H24(126),ex1(:),G1H12(204),m3h2x12(:,235),heltab2x24(:,:,296))
  call Hloop_AQ_W(ntryL,G1H24(123),ex1(:),G1H12(205),m3h2x12(:,236),heltab2x24(:,:,297))
  call Hloop_AQ_Z(ntryL,G1H24(124),ex1(:),G1H12(206),ngZu,m3h2x12(:,237),heltab2x24(:,:,298))
  call Hloop_AQ_W(ntryL,G1H24(125),ex1(:),G1H12(207),m3h2x12(:,238),heltab2x24(:,:,299))
  call Hloop_AQ_V(ntryL,G1H24(133),ex1(:),G1H12(208),m3h2x12(:,239),heltab2x24(:,:,300))
  call Hloop_AQ_V(ntryL,G1H24(134),ex1(:),G1H12(209),m3h2x12(:,240),heltab2x24(:,:,301))
  call Hloop_AQ_Z(ntryL,G1H24(129),ex1(:),G1H12(210),ngZu,m3h2x12(:,241),heltab2x24(:,:,302))
  call Hloop_AQ_Z(ntryL,G1H24(130),ex1(:),G1H12(211),ngZu,m3h2x12(:,242),heltab2x24(:,:,303))
  call Hloop_AQ_W(ntryL,G1H24(131),ex1(:),G1H12(212),m3h2x12(:,243),heltab2x24(:,:,304))
  call Hloop_AQ_W(ntryL,G1H24(132),ex1(:),G1H12(213),m3h2x12(:,244),heltab2x24(:,:,305))
  call Hloop_AQ_W(ntryL,G1H24(137),ex1(:),G1H12(214),m3h2x12(:,245),heltab2x24(:,:,306))
  call Hloop_AQ_W(ntryL,G1H24(136),ex1(:),G1H12(215),m3h2x12(:,246),heltab2x24(:,:,307))
  call Hloop_AQ_W(ntryL,G1H24(142),ex1(:),G1H12(216),m3h2x12(:,247),heltab2x24(:,:,308))
  call Hloop_AQ_V(ntryL,G1H24(139),ex1(:),G1H12(217),m3h2x12(:,248),heltab2x24(:,:,309))
  call Hloop_AQ_W(ntryL,G1H24(140),ex1(:),G1H12(218),m3h2x12(:,249),heltab2x24(:,:,310))
  call Hloop_AQ_Z(ntryL,G1H24(141),ex1(:),G1H12(219),ngZu,m3h2x12(:,250),heltab2x24(:,:,311))
  call Hloop_AQ_W(ntryL,G1H24(149),ex1(:),G1H12(220),m3h2x12(:,251),heltab2x24(:,:,312))
  call Hloop_AQ_W(ntryL,G1H24(144),ex1(:),G1H12(221),m3h2x12(:,252),heltab2x24(:,:,313))
  call Hloop_AQ_W(ntryL,G1H24(150),ex1(:),G1H12(222),m3h2x12(:,253),heltab2x24(:,:,314))
  call Hloop_AQ_W(ntryL,G1H24(146),ex1(:),G1H12(223),m3h2x12(:,254),heltab2x24(:,:,315))
  call Hloop_AQ_V(ntryL,G1H24(147),ex1(:),G1H12(224),m3h2x12(:,255),heltab2x24(:,:,316))
  call Hloop_AQ_Z(ntryL,G1H24(148),ex1(:),G1H12(225),ngZu,m3h2x12(:,256),heltab2x24(:,:,317))
  call Hloop_AQ_W(ntryL,G1H24(153),ex1(:),G1H12(226),m3h2x12(:,257),heltab2x24(:,:,318))
  call Hloop_AQ_W(ntryL,G1H24(152),ex1(:),G1H12(227),m3h2x12(:,258),heltab2x24(:,:,319))
  call Hloop_AQ_W(ntryL,G1H24(158),ex1(:),G1H12(228),m3h2x12(:,259),heltab2x24(:,:,320))
  call Hloop_AQ_W(ntryL,G1H24(159),ex1(:),G1H12(229),m3h2x12(:,260),heltab2x24(:,:,321))
  call Hloop_AQ_W(ntryL,G1H24(156),ex1(:),G1H12(230),m3h2x12(:,261),heltab2x24(:,:,322))
  call Hloop_AQ_W(ntryL,G1H24(157),ex1(:),G1H12(231),m3h2x12(:,262),heltab2x24(:,:,323))
call HGT_w2_OLR(G1H12(2),1,1,12)
call HGT_w2_invQ_OLR(G1H12(2),2,5,12)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(2),[G1H12(184)])
call HGT_w2_OLR(G1H12(3),1,1,12)
call HGT_w2_invQ_OLR(G1H12(3),2,5,12)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(3),[G1H12(185)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(22),[G1H12(20)])
call HGT_w2_OLR(G1H12(4),1,1,12)
call HGT_w2_invQ_OLR(G1H12(4),2,5,12)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(4),[G1H12(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(23),[G1H12(26)])
call HGT_w2_OLR(G1H12(5),1,1,12)
call HGT_w2_invQ_OLR(G1H12(5),2,5,12)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(5),[G1H12(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(40),[G1H12(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(57),[G1H12(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(42),[G1H12(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(63),[G1H12(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(33),[G1H12(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(39),[G1H12(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(24),[G1H12(32)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(25),[G1H12(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(108),[G1H12(44)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(51),[G1H12(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(109),[G1H12(50)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(30),[G1H8(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(42),[G1H8(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(130),[G1H12(56)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(132),[G1H12(62)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(75),[G1H12(69)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(87),[G1H12(81)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(106),[G1H12(92)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(107),[G1H12(98)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(166),[G1H12(104)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(117),[G1H12(105)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(168),[G1H12(110)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(123),[G1H12(111)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(154),[G1H12(116)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(6),[G1H12(122)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(70),[G1H8(58)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(76),[G1H8(64)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(130),[G1H8(124)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(15),[G2H12(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(16),[G2H12(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(19),[G2H12(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(20),[G2H12(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(23),[G2H12(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(24),[G2H12(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(29),[G2H12(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(30),[G2H12(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(31),[G2H12(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(32),[G2H12(28)])
call HGT_w2_OLR(G1H12(1),1,1,12)
call HGT_w2_invQ_OLR(G1H12(1),2,5,12)
  call Hloop_QW_A(ntryL,G1H12(1),ex5(:),G1H4(30),m3h3x4(:,65),heltab2x12(:,:,157))
  call Hloop_Q_A(ntryL,G1H4(30),58,nMB,G2H4(12),n2h4(143))
  call Hloop_QA_W(ntryL,G2H8(24),ex3(:),G2H4(14),m3h2x4(:,114),heltab2x8(:,:,114))
  call Hloop_QW_A(ntryL,G1H12(2),ex5(:),G1H4(42),m3h3x4(:,66),heltab2x12(:,:,158))
  call Hloop_Q_A(ntryL,G1H4(42),53,0,G2H4(1),n2h4(144))
  call Hloop_QA_V(ntryL,G2H8(28),ex4(:),G2H4(2),m3h2x4(:,115),heltab2x8(:,:,115))
  call Hloop_QW_A(ntryL,G1H12(3),ex5(:),G1H4(54),m3h3x4(:,67),heltab2x12(:,:,159))
  call Hloop_Q_A(ntryL,G1H4(54),53,0,G2H4(3),n2h4(145))
  call Hloop_QA_Z(ntryL,G2H8(32),ex4(:),G2H4(4),ngZd,m3h2x4(:,116),heltab2x8(:,:,116))
  call Hloop_QW_A(ntryL,G1H12(4),ex5(:),G1H4(66),m3h3x4(:,68),heltab2x12(:,:,160))
  call Hloop_Q_A(ntryL,G1H4(66),51,0,G2H4(5),n2h4(146))
  call Hloop_QA_V(ntryL,G2H8(36),ex4(:),G2H4(6),m3h2x4(:,117),heltab2x8(:,:,117))
  call Hloop_QW_A(ntryL,G1H12(5),ex5(:),G1H4(78),m3h3x4(:,69),heltab2x12(:,:,161))
  call Hloop_Q_A(ntryL,G1H4(78),51,0,G2H4(7),n2h4(147))
  call Hloop_QA_Z(ntryL,G2H8(40),ex4(:),G2H4(8),ngZd,m3h2x4(:,118),heltab2x8(:,:,118))
  call Hloop_VQ_A(ntryL,G1H12(40),ex1(:),G1H6(271),m3h2x6(:,93),heltab2x12(:,:,162))
  call Hloop_Q_A(ntryL,G1H6(271),39,0,G2H6(43),n2h6(68))
  call Hloop_VQ_A(ntryL,G1H12(57),ex1(:),G1H6(283),m3h2x6(:,94),heltab2x12(:,:,163))
  call Hloop_Q_A(ntryL,G1H6(283),39,0,G2H6(44),n2h6(69))
  call Hloop_ZQ_A(ntryL,G1H12(42),ex1(:),G1H6(295),ngZu,m3h2x6(:,95),heltab2x12(:,:,164))
  call Hloop_Q_A(ntryL,G1H6(295),39,0,G2H6(45),n2h6(70))
  call Hloop_ZQ_A(ntryL,G1H12(63),ex1(:),G1H6(307),ngZu,m3h2x6(:,96),heltab2x12(:,:,165))
  call Hloop_Q_A(ntryL,G1H6(307),39,0,G2H6(46),n2h6(71))
  call Hloop_QW_A(ntryL,G1H12(33),ex5(:),G1H4(90),m3h3x4(:,70),heltab2x12(:,:,166))
  call Hloop_Q_A(ntryL,G1H4(90),51,0,G2H4(9),n2h4(148))
  call Hloop_QW_A(ntryL,G1H12(39),ex5(:),G1H4(102),m3h3x4(:,71),heltab2x12(:,:,167))
  call Hloop_Q_A(ntryL,G1H4(102),51,0,G2H4(10),n2h4(149))
  call Hloop_QW_A(ntryL,G1H12(24),ex5(:),G1H4(114),m3h3x4(:,72),heltab2x12(:,:,168))
  call Hloop_Q_A(ntryL,G1H4(114),51,0,G2H4(11),n2h4(150))
  call Hloop_QW_A(ntryL,G1H12(25),ex5(:),G1H4(126),m3h3x4(:,73),heltab2x12(:,:,169))
  call Hloop_Q_A(ntryL,G1H4(126),51,0,G2H4(170),n2h4(151))
  call Hloop_QW_A(ntryL,G1H12(108),ex5(:),G1H4(138),m3h3x4(:,74),heltab2x12(:,:,170))
  call Hloop_Q_A(ntryL,G1H4(138),51,nMB,G2H4(13),n2h4(152))
  call Hloop_QW_A(ntryL,G1H12(51),ex5(:),G1H4(150),m3h3x4(:,75),heltab2x12(:,:,171))
  call Hloop_Q_A(ntryL,G1H4(150),51,nMB,G2H4(174),n2h4(153))
  call Hloop_QW_A(ntryL,G1H12(109),ex5(:),G1H4(162),m3h3x4(:,76),heltab2x12(:,:,172))
  call Hloop_Q_A(ntryL,G1H4(162),51,nMB,G2H4(15),n2h4(154))
  call Hloop_VA_Q(ntryL,G1H8(4),ex4(:),G1H4(174),m3h2x4(:,119),heltab2x8(:,:,119))
  call Hloop_A_Q(ntryL,G1H4(174),58,0,G2H4(17),n2h4(155))
  call Hloop_VA_Q(ntryL,G1H8(6),ex4(:),G1H4(1),m3h2x4(:,120),heltab2x8(:,:,120))
  call Hloop_A_Q(ntryL,G1H4(1),58,0,G2H4(18),n2h4(156))
  call Hloop_ZA_Q(ntryL,G1H8(17),ex4(:),G1H4(2),ngZd,m3h2x4(:,121),heltab2x8(:,:,121))
  call Hloop_A_Q(ntryL,G1H4(2),58,0,G2H4(20),n2h4(157))
  call Hloop_ZA_Q(ntryL,G1H8(18),ex4(:),G1H4(6),ngZd,m3h2x4(:,122),heltab2x8(:,:,122))
  call Hloop_A_Q(ntryL,G1H4(6),58,0,G2H4(21),n2h4(158))
  call Hloop_WA_Q(ntryL,G1H8(23),ex4(:),G1H4(7),m3h2x4(:,123),heltab2x8(:,:,123))
  call Hloop_A_Q(ntryL,G1H4(7),58,0,G2H4(23),n2h4(159))
  call Hloop_WA_Q(ntryL,G1H8(30),ex4(:),G1H4(8),m3h2x4(:,124),heltab2x8(:,:,124))
  call Hloop_A_Q(ntryL,G1H4(8),58,0,G2H4(24),n2h4(160))
  call Hloop_WA_Q(ntryL,G1H8(29),ex4(:),G1H4(12),m3h2x4(:,125),heltab2x8(:,:,125))
  call Hloop_A_Q(ntryL,G1H4(12),58,0,G2H4(26),n2h4(161))
  call Hloop_WA_Q(ntryL,G1H8(35),ex4(:),G1H4(13),m3h2x4(:,126),heltab2x8(:,:,126))
  call Hloop_A_Q(ntryL,G1H4(13),58,0,G2H4(27),n2h4(162))
  call Hloop_WA_Q(ntryL,G1H8(42),ex4(:),G1H4(14),m3h2x4(:,127),heltab2x8(:,:,127))
  call Hloop_A_Q(ntryL,G1H4(14),58,0,G2H4(29),n2h4(163))
  call Hloop_WA_Q(ntryL,G1H8(41),ex4(:),G1H4(18),m3h2x4(:,128),heltab2x8(:,:,128))
  call Hloop_A_Q(ntryL,G1H4(18),58,0,G2H4(30),n2h4(164))
  call Hloop_VQ_A(ntryL,G1H12(130),ex1(:),G1H6(319),m3h2x6(:,97),heltab2x12(:,:,173))
  call Hloop_Q_A(ntryL,G1H6(319),39,0,G2H6(47),n2h6(72))
  call Hloop_ZQ_A(ntryL,G1H12(132),ex1(:),G1H6(14),ngZu,m3h2x6(:,98),heltab2x12(:,:,174))
  call Hloop_Q_A(ntryL,G1H6(14),39,0,G2H6(48),n2h6(73))
  call Hloop_AW_Q(ntryL,G1H12(68),ex5(:),G1H4(19),m3h3x4(:,77),heltab2x12(:,:,175))
  call Hloop_A_Q(ntryL,G1H4(19),58,0,G2H4(32),n2h4(165))
  call Hloop_AW_Q(ntryL,G1H12(75),ex5(:),G1H4(20),m3h3x4(:,78),heltab2x12(:,:,176))
  call Hloop_A_Q(ntryL,G1H4(20),58,0,G2H4(33),n2h4(166))
  call Hloop_AW_Q(ntryL,G1H12(74),ex5(:),G1H4(24),m3h3x4(:,79),heltab2x12(:,:,177))
  call Hloop_A_Q(ntryL,G1H4(24),58,0,G2H4(35),n2h4(167))
  call Hloop_AW_Q(ntryL,G1H12(80),ex5(:),G1H4(25),m3h3x4(:,80),heltab2x12(:,:,178))
  call Hloop_A_Q(ntryL,G1H4(25),58,0,G2H4(36),n2h4(168))
  call Hloop_AW_Q(ntryL,G1H12(87),ex5(:),G1H4(26),m3h3x4(:,81),heltab2x12(:,:,179))
  call Hloop_A_Q(ntryL,G1H4(26),58,0,G2H4(38),n2h4(169))
  call Hloop_AW_Q(ntryL,G1H12(86),ex5(:),G1H4(31),m3h3x4(:,82),heltab2x12(:,:,180))
  call Hloop_A_Q(ntryL,G1H4(31),58,0,G2H4(39),n2h4(170))
  call Hloop_AW_Q(ntryL,G1H12(106),ex5(:),G1H4(32),m3h3x4(:,83),heltab2x12(:,:,181))
  call Hloop_A_Q(ntryL,G1H4(32),53,nMT,G2H4(41),n2h4(171))
  call Hloop_AW_Q(ntryL,G1H12(93),ex5(:),G1H4(36),m3h3x4(:,84),heltab2x12(:,:,182))
  call Hloop_A_Q(ntryL,G1H4(36),53,nMT,G2H4(42),n2h4(172))
  call Hloop_AW_Q(ntryL,G1H12(107),ex5(:),G1H4(37),m3h3x4(:,85),heltab2x12(:,:,183))
  call Hloop_A_Q(ntryL,G1H4(37),53,nMT,G2H4(44),n2h4(173))
  call Hloop_AW_Q(ntryL,G1H12(99),ex5(:),G1H4(38),m3h3x4(:,86),heltab2x12(:,:,184))
  call Hloop_A_Q(ntryL,G1H4(38),53,nMT,G2H4(45),n2h4(174))
  call Hloop_UW_V(ntryL,G1H12(166),38,ex5(:),16,G2H4(47),m3h3x4(:,87),heltab2x12(:,:,185))
  call Hloop_UW_V(ntryL,G1H12(117),38,ex5(:),16,G2H4(48),m3h3x4(:,88),heltab2x12(:,:,186))
  call Hloop_UW_V(ntryL,G1H12(168),38,ex5(:),16,G2H4(51),m3h3x4(:,89),heltab2x12(:,:,187))
  call Hloop_UW_V(ntryL,G1H12(123),38,ex5(:),16,G2H4(52),m3h3x4(:,90),heltab2x12(:,:,188))
  call Hloop_UW_V(ntryL,G1H12(154),38,ex5(:),16,G2H4(55),m3h3x4(:,91),heltab2x12(:,:,189))
  call Hloop_UW_V(ntryL,G1H12(6),38,ex5(:),16,G2H4(56),m3h3x4(:,92),heltab2x12(:,:,190))
  call Hloop_VQ_A(ntryL,G1H8(46),ex1(:),G1H4(43),m3h2x4(:,129),heltab2x8(:,:,129))
  call Hloop_Q_A(ntryL,G1H4(43),51,0,G2H4(59),n2h4(175))
  call Hloop_VQ_A(ntryL,G1H8(47),ex1(:),G1H4(44),m3h2x4(:,130),heltab2x8(:,:,130))
  call Hloop_Q_A(ntryL,G1H4(44),51,0,G2H4(60),n2h4(176))
  call Hloop_ZQ_A(ntryL,G1H8(51),ex1(:),G1H4(48),ngZu,m3h2x4(:,131),heltab2x8(:,:,131))
  call Hloop_Q_A(ntryL,G1H4(48),51,0,G2H4(63),n2h4(177))
  call Hloop_ZQ_A(ntryL,G1H8(52),ex1(:),G1H4(49),ngZu,m3h2x4(:,132),heltab2x8(:,:,132))
  call Hloop_Q_A(ntryL,G1H4(49),51,0,G2H4(64),n2h4(178))
  call Hloop_WQ_A(ntryL,G1H8(57),ex1(:),G1H4(50),m3h2x4(:,133),heltab2x8(:,:,133))
  call Hloop_Q_A(ntryL,G1H4(50),51,0,G2H4(67),n2h4(179))
  call Hloop_WQ_A(ntryL,G1H8(70),ex1(:),G1H4(55),m3h2x4(:,134),heltab2x8(:,:,134))
  call Hloop_Q_A(ntryL,G1H4(55),51,0,G2H4(68),n2h4(180))
  call Hloop_WQ_A(ntryL,G1H8(63),ex1(:),G1H4(56),m3h2x4(:,135),heltab2x8(:,:,135))
  call Hloop_Q_A(ntryL,G1H4(56),51,0,G2H4(71),n2h4(181))
  call Hloop_WQ_A(ntryL,G1H8(76),ex1(:),G1H4(60),m3h2x4(:,136),heltab2x8(:,:,136))
  call Hloop_Q_A(ntryL,G1H4(60),51,0,G2H4(72),n2h4(182))
  call Hloop_WQ_A(ntryL,G1H8(69),ex1(:),G1H4(61),m3h2x4(:,137),heltab2x8(:,:,137))
  call Hloop_Q_A(ntryL,G1H4(61),51,0,G2H4(74),n2h4(183))
  call Hloop_WQ_A(ntryL,G1H8(75),ex1(:),G1H4(62),m3h2x4(:,138),heltab2x8(:,:,138))
  call Hloop_Q_A(ntryL,G1H4(62),51,0,G2H4(75),n2h4(184))
  call Hloop_UV_W(ntryL,G1H12(128),41,ex5(:),16,G2H4(77),m3h3x4(:,93),heltab2x12(:,:,191))
  call Hloop_UV_W(ntryL,G1H12(129),41,ex5(:),16,G2H4(78),m3h3x4(:,94),heltab2x12(:,:,192))
  call Hloop_UV_W(ntryL,G1H12(134),41,ex5(:),16,G2H4(80),m3h3x4(:,95),heltab2x12(:,:,193))
  call Hloop_UV_W(ntryL,G1H12(135),41,ex5(:),16,G2H4(81),m3h3x4(:,96),heltab2x12(:,:,194))
  call Hloop_UV_W(ntryL,G1H12(140),41,ex5(:),16,G2H4(83),m3h3x4(:,97),heltab2x12(:,:,195))
  call Hloop_UV_W(ntryL,G1H12(141),41,ex5(:),16,G2H4(84),m3h3x4(:,98),heltab2x12(:,:,196))
  call Hloop_UV_W(ntryL,G1H12(146),41,ex5(:),16,G2H4(86),m3h3x4(:,99),heltab2x12(:,:,197))
  call Hloop_UV_W(ntryL,G1H12(147),41,ex5(:),16,G2H4(87),m3h3x4(:,100),heltab2x12(:,:,198))
  call Hloop_WA_Q(ntryL,G1H12(152),ex3(:),G1H6(15),m3h2x6(:,99),heltab2x12(:,:,199))
  call Hloop_A_Q(ntryL,G1H6(15),45,nMB,G2H6(49),n2h6(74))
  call Hloop_WA_Q(ntryL,G1H12(153),ex3(:),G1H6(19),m3h2x6(:,100),heltab2x12(:,:,200))
  call Hloop_A_Q(ntryL,G1H6(19),45,nMB,G2H6(50),n2h6(75))
  call Hloop_VA_Q(ntryL,G1H8(79),ex3(:),G1H4(67),m3h2x4(:,139),heltab2x8(:,:,139))
  call Hloop_A_Q(ntryL,G1H4(67),53,nMT,G2H4(89),n2h4(185))
  call Hloop_VA_Q(ntryL,G1H8(80),ex3(:),G1H4(68),m3h2x4(:,140),heltab2x8(:,:,140))
  call Hloop_A_Q(ntryL,G1H4(68),53,nMT,G2H4(90),n2h4(186))
  call Hloop_ZA_Q(ntryL,G1H8(85),ex3(:),G1H4(72),ngZu,m3h2x4(:,141),heltab2x8(:,:,141))
  call Hloop_A_Q(ntryL,G1H4(72),53,nMT,G2H4(92),n2h4(187))
  call Hloop_ZA_Q(ntryL,G1H8(86),ex3(:),G1H4(73),ngZu,m3h2x4(:,142),heltab2x8(:,:,142))
  call Hloop_A_Q(ntryL,G1H4(73),53,nMT,G2H4(93),n2h4(188))
  call Hloop_VA_Q(ntryL,G1H8(91),ex3(:),G1H4(74),m3h2x4(:,143),heltab2x8(:,:,143))
  call Hloop_A_Q(ntryL,G1H4(74),53,nMT,G2H4(95),n2h4(189))
  call Hloop_VA_Q(ntryL,G1H8(92),ex3(:),G1H4(79),m3h2x4(:,144),heltab2x8(:,:,144))
  call Hloop_A_Q(ntryL,G1H4(79),53,nMT,G2H4(96),n2h4(190))
  call Hloop_ZA_Q(ntryL,G1H8(97),ex3(:),G1H4(80),ngZu,m3h2x4(:,145),heltab2x8(:,:,145))
  call Hloop_A_Q(ntryL,G1H4(80),53,nMT,G2H4(98),n2h4(191))
  call Hloop_ZA_Q(ntryL,G1H8(98),ex3(:),G1H4(84),ngZu,m3h2x4(:,146),heltab2x8(:,:,146))
  call Hloop_A_Q(ntryL,G1H4(84),53,nMT,G2H4(99),n2h4(192))
  call Hloop_VQ_A(ntryL,G1H8(13),ex2(:),G1H4(85),m3h2x4(:,147),heltab2x8(:,:,147))
  call Hloop_Q_A(ntryL,G1H4(85),51,nMT,G2H4(101),n2h4(193))
  call Hloop_VQ_A(ntryL,G1H8(14),ex2(:),G1H4(86),m3h2x4(:,148),heltab2x8(:,:,148))
  call Hloop_Q_A(ntryL,G1H4(86),51,nMT,G2H4(102),n2h4(194))
  call Hloop_VQ_A(ntryL,G1H8(105),ex2(:),G1H4(91),m3h2x4(:,149),heltab2x8(:,:,149))
  call Hloop_Q_A(ntryL,G1H4(91),51,nMT,G2H4(105),n2h4(195))
  call Hloop_VQ_A(ntryL,G1H8(106),ex2(:),G1H4(92),m3h2x4(:,150),heltab2x8(:,:,150))
  call Hloop_Q_A(ntryL,G1H4(92),51,nMT,G2H4(106),n2h4(196))
  call Hloop_ZQ_A(ntryL,G1H8(111),ex2(:),G1H4(96),ngZu,m3h2x4(:,151),heltab2x8(:,:,151))
  call Hloop_Q_A(ntryL,G1H4(96),51,nMT,G2H4(109),n2h4(197))
  call Hloop_ZQ_A(ntryL,G1H8(112),ex2(:),G1H4(97),ngZu,m3h2x4(:,152),heltab2x8(:,:,152))
  call Hloop_Q_A(ntryL,G1H4(97),51,nMT,G2H4(110),n2h4(198))
  call Hloop_ZQ_A(ntryL,G1H8(117),ex2(:),G1H4(98),ngZu,m3h2x4(:,153),heltab2x8(:,:,153))
  call Hloop_Q_A(ntryL,G1H4(98),51,nMT,G2H4(113),n2h4(199))
  call Hloop_ZQ_A(ntryL,G1H8(118),ex2(:),G1H4(103),ngZu,m3h2x4(:,154),heltab2x8(:,:,154))
  call Hloop_Q_A(ntryL,G1H4(103),51,nMT,G2H4(114),n2h4(200))
  call Hloop_WQ_A(ntryL,G1H8(123),ex2(:),G1H4(104),m3h2x4(:,155),heltab2x8(:,:,155))
  call Hloop_Q_A(ntryL,G1H4(104),51,nMB,G2H4(117),n2h4(201))
  call Hloop_WQ_A(ntryL,G1H8(130),ex2(:),G1H4(108),m3h2x4(:,156),heltab2x8(:,:,156))
  call Hloop_Q_A(ntryL,G1H4(108),51,nMB,G2H4(118),n2h4(202))
  call Hloop_WQ_A(ntryL,G1H8(129),ex2(:),G1H4(109),m3h2x4(:,157),heltab2x8(:,:,157))
  call Hloop_Q_A(ntryL,G1H4(109),51,nMB,G2H4(121),n2h4(203))
  call Hloop_QA_W(ntryL,G2H8(23),ex3(:),G2H4(122),m3h2x4(:,158),heltab2x8(:,:,158))
  call Hloop_QA_V(ntryL,G2H8(25),ex4(:),G2H4(125),m3h2x4(:,159),heltab2x8(:,:,159))
  call Hloop_QA_Z(ntryL,G2H8(26),ex4(:),G2H4(126),ngZd,m3h2x4(:,160),heltab2x8(:,:,160))
  call Hloop_QA_V(ntryL,G2H8(27),ex4(:),G2H4(128),m3h2x4(:,161),heltab2x8(:,:,161))
  call Hloop_QA_Z(ntryL,G2H8(29),ex4(:),G2H4(129),ngZd,m3h2x4(:,162),heltab2x8(:,:,162))
  call Hotf_5pt_reduction(G2H12(15),RedSet_5(32),mass5set(:,2),  & 
G1H12(184),G1H12(185),G1H12(20),G1H12(22),G1H12(26),G1H12(23),12)
  call HG1shiftOLR(G1H12(185),8,12)
  call Hotf_5pt_reduction(G2H12(16),RedSet_5(32),mass5set(:,3),  & 
G1H12(8),G1H12(9),G1H12(14),G1H12(15),G1H12(21),G1H12(27),12)
  call HG1shiftOLR(G1H12(9),8,12)
  call Hloop_QA_V(ntryL,G2H12(19),ex4(:),G2H6(51),m3h2x6(:,101),heltab2x12(:,:,201))
  call Hloop_QA_Z(ntryL,G2H12(20),ex4(:),G2H6(52),ngZd,m3h2x6(:,102),heltab2x12(:,:,202))
  call Hloop_VA_Q(ntryL,G1H24(30),ex4(:),G1H12(32),m3h2x12(:,263),heltab2x24(:,:,324))
  call Hloop_A_Q(ntryL,G1H12(32),41,0,G2H12(39),n2h12(184))
  call Hloop_ZA_Q(ntryL,G1H24(33),ex4(:),G1H12(38),ngZd,m3h2x12(:,264),heltab2x24(:,:,325))
  call Hloop_A_Q(ntryL,G1H12(38),41,0,G2H12(40),n2h12(185))
  call Hloop_VA_Q(ntryL,G1H24(34),ex4(:),G1H12(44),m3h2x12(:,265),heltab2x24(:,:,326))
  call Hloop_A_Q(ntryL,G1H12(44),41,0,G2H12(41),n2h12(186))
  call Hloop_ZA_Q(ntryL,G1H24(39),ex4(:),G1H12(45),ngZd,m3h2x12(:,266),heltab2x24(:,:,327))
  call Hloop_A_Q(ntryL,G1H12(45),41,0,G2H12(42),n2h12(187))
  call Hloop_VA_Q(ntryL,G1H24(44),ex4(:),G1H12(50),m3h2x12(:,267),heltab2x24(:,:,328))
  call Hloop_A_Q(ntryL,G1H12(50),41,0,G2H12(43),n2h12(188))
  call Hloop_ZA_Q(ntryL,G1H24(46),ex4(:),G1H12(56),ngZd,m3h2x12(:,268),heltab2x24(:,:,329))
  call Hloop_A_Q(ntryL,G1H12(56),41,0,G2H12(44),n2h12(189))
  call Hloop_VA_Q(ntryL,G1H24(52),ex4(:),G1H12(62),m3h2x12(:,269),heltab2x24(:,:,330))
  call Hloop_A_Q(ntryL,G1H12(62),41,0,G2H12(45),n2h12(190))
  call Hloop_ZA_Q(ntryL,G1H24(57),ex4(:),G1H12(69),ngZd,m3h2x12(:,270),heltab2x24(:,:,331))
  call Hloop_A_Q(ntryL,G1H12(69),41,0,G2H12(46),n2h12(191))
  call Hloop_AQ_V(ntryL,G2H12(23),ex1(:),G2H6(53),m3h2x6(:,103),heltab2x12(:,:,203))
  call Hloop_AQ_Z(ntryL,G2H12(24),ex1(:),G2H6(55),ngZu,m3h2x6(:,104),heltab2x12(:,:,204))
  call Hloop_VQ_A(ntryL,G1H24(58),ex1(:),G1H12(81),m3h2x12(:,271),heltab2x24(:,:,332))
  call Hloop_Q_A(ntryL,G1H12(81),41,0,G2H12(47),n2h12(192))
  call Hloop_ZQ_A(ntryL,G1H24(69),ex1(:),G1H12(92),ngZu,m3h2x12(:,272),heltab2x24(:,:,333))
  call Hloop_Q_A(ntryL,G1H12(92),41,0,G2H12(48),n2h12(193))
  call Hloop_VQ_A(ntryL,G1H24(65),ex1(:),G1H12(98),m3h2x12(:,273),heltab2x24(:,:,334))
  call Hloop_Q_A(ntryL,G1H12(98),41,0,G2H12(49),n2h12(194))
  call Hloop_ZQ_A(ntryL,G1H24(66),ex1(:),G1H12(104),ngZu,m3h2x12(:,274),heltab2x24(:,:,335))
  call Hloop_Q_A(ntryL,G1H12(104),41,0,G2H12(50),n2h12(195))
  call Hloop_UW_V(ntryL,G1H24(67),33,ex5(:),16,G2H8(30),m3h3x8(:,62),heltab2x24(:,:,336))
  call Hloop_UV_W(ntryL,G1H24(73),33,ex5(:),16,G2H8(31),m3h3x8(:,63),heltab2x24(:,:,337))
  call Hloop_UW_V(ntryL,G1H24(78),33,ex5(:),16,G2H8(33),m3h3x8(:,64),heltab2x24(:,:,338))
  call Hloop_UV_W(ntryL,G1H24(79),33,ex5(:),16,G2H8(34),m3h3x8(:,65),heltab2x24(:,:,339))
  call Hloop_UW_V(ntryL,G1H24(86),33,ex5(:),16,G2H8(35),m3h3x8(:,66),heltab2x24(:,:,340))
  call Hloop_UV_W(ntryL,G1H24(89),33,ex5(:),16,G2H8(37),m3h3x8(:,67),heltab2x24(:,:,341))
  call Hloop_UW_V(ntryL,G1H24(91),33,ex5(:),16,G2H8(38),m3h3x8(:,68),heltab2x24(:,:,342))
  call Hloop_UV_W(ntryL,G1H24(95),33,ex5(:),16,G2H8(39),m3h3x8(:,69),heltab2x24(:,:,343))
  call Hloop_VV_S(ntryL,G1H24(98),ex5(:),G1H8(16),m3h3x8(:,70),heltab2x24(:,:,344))
  call Hloop_VV_S(ntryL,G1H24(99),ex5(:),G1H8(19),m3h3x8(:,71),heltab2x24(:,:,345))
  call Hloop_VV_S(ntryL,G1H24(9),ex5(:),G1H8(20),m3h3x8(:,72),heltab2x24(:,:,346))
  call Hloop_VV_S(ntryL,G1H24(4),ex5(:),G1H8(21),m3h3x8(:,73),heltab2x24(:,:,347))
  call Hloop_VV_S(ntryL,G1H24(5),ex5(:),G1H8(22),m3h3x8(:,74),heltab2x24(:,:,348))
  call Hloop_UV_W(ntryL,G1H24(6),33,ex5(:),16,G2H8(41),m3h3x8(:,75),heltab2x24(:,:,349))
  call Hloop_UW_V(ntryL,G1H24(13),33,ex5(:),16,G2H8(42),m3h3x8(:,76),heltab2x24(:,:,350))
  call Hloop_UW_V(ntryL,G1H24(17),33,ex5(:),16,G2H8(5),m3h3x8(:,77),heltab2x24(:,:,351))
  call Hotf_5pt_reduction(G2H24(1),RedSet_5(33),mass5set(:,2),  & 
G1H24(320),G1H24(32),G1H24(31),G1H24(37),G1H24(38),G1H24(35),24)
  call HG1shiftOLR(G1H24(32),8,24)
  call Hotf_5pt_reduction(G2H24(2),RedSet_5(33),mass5set(:,2),  & 
G1H24(36),G1H24(43),G1H24(40),G1H24(41),G1H24(42),G1H24(50),24)
  call HG1shiftOLR(G1H24(43),8,24)
  call Hloop_VV_S(ntryL,G1H24(102),ex5(:),G1H8(25),m3h3x8(:,78),heltab2x24(:,:,352))
  call Hloop_VV_S(ntryL,G1H24(104),ex5(:),G1H8(26),m3h3x8(:,79),heltab2x24(:,:,353))
  call Hloop_VV_S(ntryL,G1H24(110),ex5(:),G1H8(27),m3h3x8(:,80),heltab2x24(:,:,354))
  call Hloop_VV_S(ntryL,G1H24(113),ex5(:),G1H8(28),m3h3x8(:,81),heltab2x24(:,:,355))
  call Hloop_VV_S(ntryL,G1H24(114),ex5(:),G1H8(31),m3h3x8(:,82),heltab2x24(:,:,356))
  call Hloop_UW_V(ntryL,G1H24(119),33,ex5(:),16,G2H8(6),m3h3x8(:,83),heltab2x24(:,:,357))
  call Hloop_UW_V(ntryL,G1H24(122),33,ex5(:),16,G2H8(1),m3h3x8(:,84),heltab2x24(:,:,358))
  call Hloop_UW_V(ntryL,G1H24(127),33,ex5(:),16,G2H8(2),m3h3x8(:,85),heltab2x24(:,:,359))
  call Hloop_UW_V(ntryL,G1H24(128),33,ex5(:),16,G2H8(3),m3h3x8(:,86),heltab2x24(:,:,360))
  call Hloop_AQ_V(ntryL,G2H12(29),ex1(:),G2H6(56),m3h2x6(:,105),heltab2x12(:,:,205))
  call Hloop_AQ_W(ntryL,G2H12(30),ex1(:),G2H6(58),m3h2x6(:,106),heltab2x12(:,:,206))
  call Hloop_AQ_Z(ntryL,G2H12(31),ex1(:),G2H6(65),ngZu,m3h2x6(:,107),heltab2x12(:,:,207))
  call Hloop_AQ_W(ntryL,G2H12(32),ex1(:),G2H6(67),m3h2x6(:,108),heltab2x12(:,:,208))
  call Hloop_VS_V(ntryL,G1H24(135),wf4(:,7),G1H6(20),m3h4x6(:,1),heltab2x24(:,:,361))
  call Hloop_VT_S(ntryL,G1H24(138),33,wf4(:,7),6,G2H6(68),m3h4x6(:,2),heltab2x24(:,:,362))
  call Hloop_VT_S(ntryL,G1H24(143),33,wf4(:,7),6,G2H6(70),m3h4x6(:,3),heltab2x24(:,:,363))
  call Hloop_VT_S(ntryL,G1H24(145),33,wf4(:,17),6,G2H6(77),m3h4x6(:,4),heltab2x24(:,:,364))
  call Hloop_VS_T(ntryL,G1H24(151),33,wf4(:,17),6,G2H6(79),m3h4x6(:,5),heltab2x24(:,:,365))
  call Hloop_VT_S(ntryL,G1H24(154),33,wf4(:,17),6,G2H6(1),m3h4x6(:,6),heltab2x24(:,:,366))
  call Hloop_VS_V(ntryL,G1H24(155),wf4(:,7),G1H6(21),m3h4x6(:,7),heltab2x24(:,:,367))
  call Hloop_VS_V(ntryL,G1H24(2),wf4(:,7),G1H6(25),m3h4x6(:,8),heltab2x24(:,:,368))
  call Hloop_VS_V(ntryL,G1H24(8),wf4(:,7),G1H6(26),m3h4x6(:,9),heltab2x24(:,:,369))
  call Hotf_5pt_reduction(G2H24(3),RedSet_5(34),mass5set(:,2),  & 
G1H24(45),G1H24(51),G1H24(47),G1H24(48),G1H24(49),G1H24(56),24)
  call HG1shiftOLR(G1H24(51),8,24)
  call Hotf_5pt_reduction(G2H24(4),RedSet_5(34),mass5set(:,2),  & 
G1H24(53),G1H24(54),G1H24(55),G1H24(63),G1H24(64),G1H24(59),24)
  call HG1shiftOLR(G1H24(54),8,24)
  call Hloop_VV_S(ntryL,G1H24(26),wf4(:,1),G1H6(27),m3h4x6(:,10),heltab2x24(:,:,370))
  call Hloop_VV_S(ntryL,G1H24(18),wf4(:,1),G1H6(31),m3h4x6(:,11),heltab2x24(:,:,371))
  call Hloop_VV_S(ntryL,G1H24(24),wf4(:,4),G1H6(32),m3h4x6(:,12),heltab2x24(:,:,372))
  call Hloop_VV_S(ntryL,G1H24(14),wf4(:,4),G1H6(33),m3h4x6(:,13),heltab2x24(:,:,373))
  call Hloop_VV_S(ntryL,G1H24(20),wf4(:,4),G1H6(37),m3h4x6(:,14),heltab2x24(:,:,374))
  call Hloop_UW_V(ntryL,G1H24(160),33,wf4(:,1),6,G2H6(2),m3h4x6(:,15),heltab2x24(:,:,375))
  call Hloop_UW_V(ntryL,G1H24(161),33,wf4(:,1),6,G2H6(3),m3h4x6(:,16),heltab2x24(:,:,376))
  call Hloop_UW_V(ntryL,G1H24(162),33,wf4(:,4),6,G2H6(4),m3h4x6(:,17),heltab2x24(:,:,377))
  call Hloop_UW_V(ntryL,G1H24(163),33,wf4(:,4),6,G2H6(5),m3h4x6(:,18),heltab2x24(:,:,378))
  call Hloop_VS_V(ntryL,G1H24(164),wf4(:,7),G1H6(38),m3h4x6(:,19),heltab2x24(:,:,379))
  call Hloop_SQ_A(ntryL,G1H24(165),ex2(:),G1H12(105),ngH,m3h2x12(:,275),heltab2x24(:,:,380))
  call Hloop_Q_A(ntryL,G1H12(105),38,nMT,G2H12(51),n2h12(196))
  call Hloop_SQ_A(ntryL,G1H24(166),ex2(:),G1H12(110),ngX,m3h2x12(:,276),heltab2x24(:,:,381))
  call Hloop_Q_A(ntryL,G1H12(110),38,nMT,G2H12(52),n2h12(197))
  call Hloop_VQ_A(ntryL,G1H24(167),ex2(:),G1H12(111),m3h2x12(:,277),heltab2x24(:,:,382))
  call Hloop_Q_A(ntryL,G1H12(111),38,nMT,G2H12(53),n2h12(198))
  call Hloop_ZQ_A(ntryL,G1H24(168),ex2(:),G1H12(116),ngZu,m3h2x12(:,278),heltab2x24(:,:,383))
  call Hloop_Q_A(ntryL,G1H12(116),38,nMT,G2H12(54),n2h12(199))
  call Hloop_QA_S(ntryL,G2H12(33),ex3(:),G2H6(6),ngH,m3h2x6(:,109),heltab2x12(:,:,209))
  call Hloop_QA_S(ntryL,G2H12(34),ex3(:),G2H6(7),ngX,m3h2x6(:,110),heltab2x12(:,:,210))
  call Hloop_QA_V(ntryL,G2H12(35),ex3(:),G2H6(8),m3h2x6(:,111),heltab2x12(:,:,211))
  call Hloop_QA_Z(ntryL,G2H12(36),ex3(:),G2H6(9),ngZu,m3h2x6(:,112),heltab2x12(:,:,212))
  call Hloop_SA_Q(ntryL,G1H24(169),ex3(:),G1H12(122),ngPtb,m3h2x12(:,279),heltab2x24(:,:,384))
  call Hloop_A_Q(ntryL,G1H12(122),38,nMB,G2H12(55),n2h12(200))
  call Hloop_WA_Q(ntryL,G1H24(170),ex3(:),G1H12(1),m3h2x12(:,280),heltab2x24(:,:,385))
  call Hloop_A_Q(ntryL,G1H12(1),38,nMB,G2H12(56),n2h12(201))
  call Hloop_SA_Q(ntryL,G1H24(171),ex3(:),G1H12(2),ngH,m3h2x12(:,281),heltab2x24(:,:,386))
  call Hloop_A_Q(ntryL,G1H12(2),38,nMT,G2H12(57),n2h12(202))
  call Hloop_SA_Q(ntryL,G1H24(172),ex3(:),G1H12(3),ngX,m3h2x12(:,282),heltab2x24(:,:,387))
  call Hloop_A_Q(ntryL,G1H12(3),38,nMT,G2H12(58),n2h12(203))
  call Hloop_VA_Q(ntryL,G1H24(173),ex3(:),G1H12(4),m3h2x12(:,283),heltab2x24(:,:,388))
  call Hloop_A_Q(ntryL,G1H12(4),38,nMT,G2H12(59),n2h12(204))
  call Hloop_ZA_Q(ntryL,G1H24(174),ex3(:),G1H12(5),ngZu,m3h2x12(:,284),heltab2x24(:,:,389))
  call Hloop_A_Q(ntryL,G1H12(5),38,nMT,G2H12(60),n2h12(205))
  call Hloop_AQ_S(ntryL,G2H12(37),ex2(:),G2H6(10),ngPbt,m3h2x6(:,113),heltab2x12(:,:,213))
  call Hloop_AQ_W(ntryL,G2H12(38),ex2(:),G2H6(11),m3h2x6(:,114),heltab2x12(:,:,214))
  call Hloop_SQ_A(ntryL,G1H24(175),ex2(:),G1H12(40),ngPbt,m3h2x12(:,285),heltab2x24(:,:,390))
  call Hloop_Q_A(ntryL,G1H12(40),38,nMB,G2H12(61),n2h12(206))
  call Hloop_WQ_A(ntryL,G1H24(176),ex2(:),G1H12(57),m3h2x12(:,286),heltab2x24(:,:,391))
  call Hloop_Q_A(ntryL,G1H12(57),38,nMB,G2H12(62),n2h12(207))
  call Hloop_SV_T(ntryL,G1H24(177),34,ex5(:),16,G2H8(4),m3h3x8(:,87),heltab2x24(:,:,392))
  call Hloop_SV_T(ntryL,G1H24(178),34,ex5(:),16,G2H8(11),m3h3x8(:,88),heltab2x24(:,:,393))
  call Hloop_SV_V(ntryL,G1H24(179),ex5(:),G1H8(32),m3h3x8(:,89),heltab2x24(:,:,394))
  call Hloop_SV_V(ntryL,G1H24(180),ex5(:),G1H8(33),m3h3x8(:,90),heltab2x24(:,:,395))
  call Hloop_VV_S(ntryL,G1H24(181),ex5(:),G1H8(34),m3h3x8(:,91),heltab2x24(:,:,396))
  call Hloop_UV_W(ntryL,G1H24(182),34,ex5(:),16,G2H8(12),m3h3x8(:,92),heltab2x24(:,:,397))
  call Hloop_UV_W(ntryL,G1H24(183),34,ex5(:),16,G2H8(7),m3h3x8(:,93),heltab2x24(:,:,398))
  call Hloop_TV_S(ntryL,G1H24(184),34,ex5(:),16,G2H8(8),m3h3x8(:,94),heltab2x24(:,:,399))
  call Hloop_TV_S(ntryL,G1H24(185),34,ex5(:),16,G2H8(9),m3h3x8(:,95),heltab2x24(:,:,400))
  call Hloop_TV_S(ntryL,G1H24(186),34,ex5(:),16,G2H8(10),m3h3x8(:,96),heltab2x24(:,:,401))
  call Hloop_TV_S(ntryL,G1H24(187),34,ex5(:),16,G2H8(13),m3h3x8(:,97),heltab2x24(:,:,402))
  call Hloop_SV_T(ntryL,G1H24(188),34,ex5(:),16,G2H8(14),m3h3x8(:,98),heltab2x24(:,:,403))
  call Hloop_SV_T(ntryL,G1H24(189),34,ex5(:),16,G2H8(15),m3h3x8(:,99),heltab2x24(:,:,404))
  call Hloop_SV_V(ntryL,G1H24(190),ex5(:),G1H8(37),m3h3x8(:,100),heltab2x24(:,:,405))
  call Hloop_SV_V(ntryL,G1H24(191),ex5(:),G1H8(38),m3h3x8(:,101),heltab2x24(:,:,406))
  call Hloop_SV_V(ntryL,G1H24(192),ex5(:),G1H8(39),m3h3x8(:,102),heltab2x24(:,:,407))
  call Hloop_TV_S(ntryL,G1H24(193),34,ex5(:),16,G2H8(16),m3h3x8(:,103),heltab2x24(:,:,408))
  call Hloop_TV_S(ntryL,G1H24(194),34,ex5(:),16,G2H8(17),m3h3x8(:,104),heltab2x24(:,:,409))
  call Hloop_TV_S(ntryL,G1H24(195),34,ex5(:),16,G2H8(18),m3h3x8(:,105),heltab2x24(:,:,410))
  call Hloop_TV_S(ntryL,G1H24(196),34,ex5(:),16,G2H8(19),m3h3x8(:,106),heltab2x24(:,:,411))
  call Hloop_SV_T(ntryL,G1H24(197),34,ex5(:),16,G2H8(20),m3h3x8(:,107),heltab2x24(:,:,412))
  call Hloop_VV_S(ntryL,G1H24(198),ex5(:),G1H8(40),m3h3x8(:,108),heltab2x24(:,:,413))
  call Hloop_VV_S(ntryL,G1H24(199),ex5(:),G1H8(43),m3h3x8(:,109),heltab2x24(:,:,414))
  call Hloop_VV_S(ntryL,G1H24(200),ex5(:),G1H8(44),m3h3x8(:,110),heltab2x24(:,:,415))
  call Hloop_VV_S(ntryL,G1H24(201),ex5(:),G1H8(5),m3h3x8(:,111),heltab2x24(:,:,416))
  call Hloop_VV_S(ntryL,G1H24(202),ex5(:),G1H8(45),m3h3x8(:,112),heltab2x24(:,:,417))
  call Hotf_5pt_reduction(G2H24(5),RedSet_5(35),mass5set(:,40),  & 
G1H24(60),G1H24(61),G1H24(62),G1H24(70),G1H24(72),G1H24(71),24)
  call HG1shiftOLR(G1H24(61),4,24)
  call Hloop_SV_V(ntryL,G1H24(203),ex5(:),G1H8(48),m3h3x8(:,113),heltab2x24(:,:,418))
  call Hloop_SV_V(ntryL,G1H24(204),ex5(:),G1H8(49),m3h3x8(:,114),heltab2x24(:,:,419))
  call Hloop_SV_V(ntryL,G1H24(205),ex5(:),G1H8(7),m3h3x8(:,115),heltab2x24(:,:,420))
  call Hloop_SV_V(ntryL,G1H24(206),ex5(:),G1H8(50),m3h3x8(:,116),heltab2x24(:,:,421))
  call Hloop_UW_V(ntryL,G1H24(207),34,ex5(:),16,G2H8(21),m3h3x8(:,117),heltab2x24(:,:,422))
  call Hloop_UV_W(ntryL,G1H24(208),34,ex5(:),16,G2H8(22),m3h3x8(:,118),heltab2x24(:,:,423))
  call Hloop_UW_V(ntryL,G1H24(209),34,ex5(:),16,G2H8(24),m3h3x8(:,119),heltab2x24(:,:,424))
  call Hloop_UV_W(ntryL,G1H24(210),34,ex5(:),16,G2H8(28),m3h3x8(:,120),heltab2x24(:,:,425))
  call Hloop_VV_S(ntryL,G1H24(211),ex5(:),G1H8(53),m3h3x8(:,121),heltab2x24(:,:,426))
  call Hloop_VV_S(ntryL,G1H24(212),ex5(:),G1H8(54),m3h3x8(:,122),heltab2x24(:,:,427))
  call Hloop_VV_S(ntryL,G1H24(213),ex5(:),G1H8(55),m3h3x8(:,123),heltab2x24(:,:,428))
  call Hloop_VV_S(ntryL,G1H24(214),ex5(:),G1H8(56),m3h3x8(:,124),heltab2x24(:,:,429))
  call Hloop_VV_S(ntryL,G1H24(215),ex5(:),G1H8(59),m3h3x8(:,125),heltab2x24(:,:,430))
  call Hloop_UW_V(ntryL,G1H24(216),34,ex5(:),16,G2H8(32),m3h3x8(:,126),heltab2x24(:,:,431))
  call Hloop_UW_V(ntryL,G1H24(217),34,ex5(:),16,G2H8(36),m3h3x8(:,127),heltab2x24(:,:,432))
  call Hloop_UW_V(ntryL,G1H24(218),34,ex5(:),16,G2H8(40),m3h3x8(:,128),heltab2x24(:,:,433))
  call Hloop_UW_V(ntryL,G1H24(219),34,ex5(:),16,G2H8(23),m3h3x8(:,129),heltab2x24(:,:,434))
  call Hloop_UV_W(ntryL,G1H24(220),34,ex5(:),16,G2H8(25),m3h3x8(:,130),heltab2x24(:,:,435))
  call Hloop_UV_W(ntryL,G1H24(221),34,ex5(:),16,G2H8(26),m3h3x8(:,131),heltab2x24(:,:,436))
  call Hloop_TV_S(ntryL,G1H24(222),36,ex5(:),16,G2H8(27),m3h3x8(:,132),heltab2x24(:,:,437))
  call Hloop_TV_S(ntryL,G1H24(223),36,ex5(:),16,G2H8(29),m3h3x8(:,133),heltab2x24(:,:,438))
  call Hloop_VV_S(ntryL,G1H24(224),ex5(:),G1H8(60),m3h3x8(:,134),heltab2x24(:,:,439))
  call Hloop_VV_S(ntryL,G1H24(225),ex5(:),G1H8(61),m3h3x8(:,135),heltab2x24(:,:,440))
  call Hloop_SV_V(ntryL,G1H24(226),ex5(:),G1H8(62),m3h3x8(:,136),heltab2x24(:,:,441))
  call Hloop_UW_V(ntryL,G1H24(227),36,ex5(:),16,G2H8(43),m3h3x8(:,137),heltab2x24(:,:,442))
  call Hloop_UW_V(ntryL,G1H24(228),36,ex5(:),16,G2H8(44),m3h3x8(:,138),heltab2x24(:,:,443))
  call Hloop_SV_T(ntryL,G1H24(229),36,wf4(:,8),9,G2H6(12),m3h4x6(:,20),heltab2x24(:,:,444))
  call Hloop_SV_T(ntryL,G1H24(230),36,wf4(:,8),9,G2H6(13),m3h4x6(:,21),heltab2x24(:,:,445))
  call Hloop_VV_S(ntryL,G1H24(231),wf4(:,8),G1H6(39),m3h4x6(:,22),heltab2x24(:,:,446))
  call Hloop_SV_V(ntryL,G1H24(232),wf4(:,8),G1H6(43),m3h4x6(:,23),heltab2x24(:,:,447))
  call Hloop_SV_V(ntryL,G1H24(233),wf4(:,8),G1H6(44),m3h4x6(:,24),heltab2x24(:,:,448))
  call Hloop_UW_V(ntryL,G1H24(234),36,wf4(:,8),9,G2H6(14),m3h4x6(:,25),heltab2x24(:,:,449))
  call Hloop_UW_V(ntryL,G1H24(235),36,wf4(:,8),9,G2H6(15),m3h4x6(:,26),heltab2x24(:,:,450))
  call Hloop_TV_S(ntryL,G1H24(236),34,wf4(:,8),9,G2H6(16),m3h4x6(:,27),heltab2x24(:,:,451))
  call Hloop_TV_S(ntryL,G1H24(237),34,wf4(:,8),9,G2H6(17),m3h4x6(:,28),heltab2x24(:,:,452))
  call Hloop_TV_S(ntryL,G1H24(238),34,wf4(:,8),9,G2H6(18),m3h4x6(:,29),heltab2x24(:,:,453))
  call Hloop_TV_S(ntryL,G1H24(239),34,wf4(:,8),9,G2H6(19),m3h4x6(:,30),heltab2x24(:,:,454))
  call Hloop_SV_V(ntryL,G1H24(240),wf4(:,8),G1H6(45),m3h4x6(:,31),heltab2x24(:,:,455))
  call Hloop_TV_S(ntryL,G1H24(241),34,wf4(:,8),9,G2H6(20),m3h4x6(:,32),heltab2x24(:,:,456))
  call Hloop_TV_S(ntryL,G1H24(242),34,wf4(:,8),9,G2H6(21),m3h4x6(:,33),heltab2x24(:,:,457))
  call Hloop_TV_S(ntryL,G1H24(243),34,wf4(:,8),9,G2H6(22),m3h4x6(:,34),heltab2x24(:,:,458))
  call Hloop_TV_S(ntryL,G1H24(244),34,wf4(:,8),9,G2H6(23),m3h4x6(:,35),heltab2x24(:,:,459))
  call Hloop_VV_S(ntryL,G1H24(245),wf4(:,8),G1H6(49),m3h4x6(:,36),heltab2x24(:,:,460))
  call Hloop_VV_S(ntryL,G1H24(246),wf4(:,8),G1H6(50),m3h4x6(:,37),heltab2x24(:,:,461))
  call Hloop_VV_S(ntryL,G1H24(247),wf4(:,8),G1H6(51),m3h4x6(:,38),heltab2x24(:,:,462))



end subroutine vamp_3

end module ol_vamp_3_ppwttj_ew_uttxdxwg_3_/**/REALKIND
