
module ol_vamp_25_ppwttj_ew_uxttxdwxg_3_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_25(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppwttj_ew_uxttxdwxg_3.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppwttj_ew_uxttxdwxg_3.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_ppwttj_ew_uxttxdwxg_3_/**/DREALKIND
  use ol_tensor_sum_storage_ppwttj_ew_uxttxdwxg_3_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_ppwttj_ew_uxttxdwxg_3_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_ppwttj_ew_uxttxdwxg_3_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL, hel_states
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(hel_states)
  type(Hpolcont), intent(in) :: M(6,hel_states)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel(1:hel_states)
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel(1:hel_states)
#endif

  ! =============================================
  call Hloop_VA_Q(ntryL,G0H96(1),wf16(:,33),G0H6(36),m3h16x6(:,289),heltab2x96(:,:,4551))
  call Hloop_A_Q(ntryL,G0H6(36),39,0,G1H6(273),n2h6(675))
  Gcoeff(:)%j = (c(155)*M(3,:)%j) * den(434)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4680),h0tab(:,4680),[39,24],[0,nMZ],2,2,wf16(:,33),wf6(:,4))
  call Hloop_ZA_Q(ntryL,G0H96(1),wf16(:,33),G0H6(34),ngZu,m3h16x6(:,290),heltab2x96(:,:,4552))
  call Hloop_A_Q(ntryL,G0H6(34),39,0,G1H6(351),n2h6(676))
  Gcoeff(:)%j = (c(109)*M(3,:)%j) * den(434)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4681),h0tab(:,4681),[39,24],[0,nMW],2,2,wf16(:,33),wf6(:,4))
  call Hloop_WA_Q(ntryL,G0H96(1),wf16(:,33),G0H6(31),m3h16x6(:,291),heltab2x96(:,:,4553))
  call Hloop_A_Q(ntryL,G0H6(31),39,0,G1H6(3),n2h6(677))
  Gcoeff(:)%j = (c(181)*M(2,:)%j) * den(434)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4682),h0tab(:,4682),[39,24],[0,0],2,2,wf16(:,33),wf6(:,4))
  call Hloop_VA_Q(ntryL,G0H96(1),wf16(:,33),G0H6(28),m3h16x6(:,292),heltab2x96(:,:,4554))
  call Hloop_A_Q(ntryL,G0H6(28),39,0,G1H6(8),n2h6(678))
  Gcoeff(:)%j = (-(c(173)*M(2,:)%j)+c(174)*M(6,:)%j) * den(433)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4683),h0tab(:,4683),[39,24],[0,0],2,2,wf16(:,31),wf6(:,4))
  call Hloop_VA_Q(ntryL,G0H96(1),wf16(:,31),G0H6(8),m3h16x6(:,293),heltab2x96(:,:,4555))
  call Hloop_A_Q(ntryL,G0H6(8),39,0,G1H6(23),n2h6(679))
  Gcoeff(:)%j = (-(c(179)*M(2,:)%j)+c(180)*M(6,:)%j) * den(433)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4684),h0tab(:,4684),[39,24],[0,nMZ],2,2,wf16(:,31),wf6(:,4))
  call Hloop_ZA_Q(ntryL,G0H96(1),wf16(:,31),G0H6(14),ngZu,m3h16x6(:,294),heltab2x96(:,:,4556))
  call Hloop_A_Q(ntryL,G0H6(14),39,0,G1H6(35),n2h6(680))
  Gcoeff(:)%j = (-(c(112)*M(2,:)%j)+c(113)*M(6,:)%j) * den(433)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4685),h0tab(:,4685),[39,24],[0,nMW],2,2,wf16(:,31),wf6(:,4))
  call Hloop_WA_Q(ntryL,G0H96(1),wf16(:,31),G0H6(1),m3h16x6(:,295),heltab2x96(:,:,4557))
  call Hloop_A_Q(ntryL,G0H6(1),39,0,G1H6(65),n2h6(681))
  Gcoeff(:)%j = (c(149)*M(3,:)%j) * den(201)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4686),h0tab(:,4686),[56,7],[0,0],2,2,wf12(:,61),wf8(:,7))
  call Hloop_VQ_A(ntryL,G0H96(1),wf12(:,61),G0H8(1),m3h12x8(:,202),heltab2x96(:,:,4558))
  call Hloop_Q_A(ntryL,G0H8(1),56,0,G1H8(154),n2h8(219))
  Gcoeff(:)%j = (c(153)*M(3,:)%j) * den(201)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4687),h0tab(:,4687),[56,7],[0,nMZ],2,2,wf12(:,61),wf8(:,7))
  call Hloop_ZQ_A(ntryL,G0H96(1),wf12(:,61),G0H8(24),ngZu,m3h12x8(:,203),heltab2x96(:,:,4559))
  call Hloop_Q_A(ntryL,G0H8(24),56,0,G1H8(159),n2h8(220))
  Gcoeff(:)%j = (c(107)*M(3,:)%j) * den(201)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4688),h0tab(:,4688),[56,7],[0,nMW],2,2,wf12(:,61),wf8(:,7))
  call Hloop_WQ_A(ntryL,G0H96(1),wf12(:,61),G0H8(13),m3h12x8(:,204),heltab2x96(:,:,4560))
  call Hloop_Q_A(ntryL,G0H8(13),56,0,G1H8(160),n2h8(221))
  Gcoeff(:)%j = (c(175)*M(2,:)%j) * den(201)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4689),h0tab(:,4689),[56,7],[0,0],2,2,wf12(:,61),wf8(:,7))
  call Hloop_VQ_A(ntryL,G0H96(1),wf12(:,61),G0H8(17),m3h12x8(:,205),heltab2x96(:,:,4561))
  call Hloop_Q_A(ntryL,G0H8(17),56,0,G1H8(165),n2h8(222))
  Gcoeff(:)%j = (c(153)*M(3,:)%j) * den(202)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4690),h0tab(:,4690),[56,7],[0,0],2,2,wf12(:,61),wf8(:,9))
  call Hloop_VQ_A(ntryL,G0H96(1),wf12(:,61),G0H8(14),m3h12x8(:,206),heltab2x96(:,:,4562))
  call Hloop_Q_A(ntryL,G0H8(14),56,0,G1H8(166),n2h8(223))
  Gcoeff(:)%j = (c(155)*M(3,:)%j) * den(202)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4691),h0tab(:,4691),[56,7],[0,nMZ],2,2,wf12(:,61),wf8(:,9))
  call Hloop_ZQ_A(ntryL,G0H96(1),wf12(:,61),G0H8(7),ngZu,m3h12x8(:,207),heltab2x96(:,:,4563))
  call Hloop_Q_A(ntryL,G0H8(7),56,0,G1H8(177),n2h8(224))
  Gcoeff(:)%j = (c(109)*M(3,:)%j) * den(202)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4692),h0tab(:,4692),[56,7],[0,nMW],2,2,wf12(:,61),wf8(:,9))
  call Hloop_WQ_A(ntryL,G0H96(1),wf12(:,61),G0H8(41),m3h12x8(:,208),heltab2x96(:,:,4564))
  call Hloop_Q_A(ntryL,G0H8(41),56,0,G1H8(178),n2h8(225))
  Gcoeff(:)%j = (c(181)*M(2,:)%j) * den(202)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4693),h0tab(:,4693),[56,7],[0,0],2,2,wf12(:,61),wf8(:,9))
  call Hloop_VQ_A(ntryL,G0H96(1),wf12(:,61),G0H8(10),m3h12x8(:,209),heltab2x96(:,:,4565))
  call Hloop_Q_A(ntryL,G0H8(10),56,0,G1H8(182),n2h8(226))
  Gcoeff(:)%j = (-(c(173)*M(2,:)%j)+c(174)*M(6,:)%j) * den(201)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4694),h0tab(:,4694),[56,7],[0,0],2,2,wf12(:,61),wf8(:,7))
  call Hloop_VQ_A(ntryL,G0H96(1),wf12(:,61),G0H8(6),m3h12x8(:,210),heltab2x96(:,:,4566))
  call Hloop_Q_A(ntryL,G0H8(6),56,0,G1H8(183),n2h8(227))
  Gcoeff(:)%j = (-(c(179)*M(2,:)%j)+c(180)*M(6,:)%j) * den(201)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4695),h0tab(:,4695),[56,7],[0,nMZ],2,2,wf12(:,61),wf8(:,7))
  call Hloop_ZQ_A(ntryL,G0H96(1),wf12(:,61),G0H8(22),ngZu,m3h12x8(:,211),heltab2x96(:,:,4567))
  call Hloop_Q_A(ntryL,G0H8(22),56,0,G1H8(193),n2h8(228))
  Gcoeff(:)%j = (-(c(112)*M(2,:)%j)+c(113)*M(6,:)%j) * den(201)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4696),h0tab(:,4696),[56,7],[0,nMW],2,2,wf12(:,61),wf8(:,7))
  call Hloop_WQ_A(ntryL,G0H96(1),wf12(:,61),G0H8(34),m3h12x8(:,212),heltab2x96(:,:,4568))
  call Hloop_Q_A(ntryL,G0H8(34),56,0,G1H8(194),n2h8(229))
  Gcoeff(:)%j = (c(160)*(M(1,:)%j-M(6,:)%j)) * den(435)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4697),h0tab(:,4697),[39,24],[0,0],2,2,wf16(:,35),wf6(:,4))
  call Hloop_QA_V(ntryL,G0H96(1),wf16(:,35),G0H6(47),m3h16x6(:,296),heltab2x96(:,:,4569))
  Gcoeff(:)%j = (c(164)*(M(1,:)%j-M(6,:)%j)) * den(435)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4698),h0tab(:,4698),[39,24],[nMZ,0],2,2,wf16(:,35),wf6(:,4))
  call Hloop_QA_Z(ntryL,G0H96(1),wf16(:,35),G0H6(42),ngZu,m3h16x6(:,297),heltab2x96(:,:,4570))
  Gcoeff(:)%j = (c(110)*(M(1,:)%j-M(6,:)%j)) * den(435)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4699),h0tab(:,4699),[39,24],[nMW,0],2,2,wf16(:,35),wf6(:,4))
  call Hloop_QA_W(ntryL,G0H96(1),wf16(:,35),G0H6(37),m3h16x6(:,298),heltab2x96(:,:,4571))
  Gcoeff(:)%j = (-(c(261)*M(3,:)%j)) * den(436)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4700),h0tab(:,4700),[57,6],[nME,nME],2,2,wf24(:,90),wf4(:,7))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,90),G0H4(29),m3h24x4(:,687),heltab2x96(:,:,4572))
  call Hloop_Q_A(ntryL,G0H4(29),57,nME,G1H4(305),n2h4(775))
  Gcoeff(:)%j = (-(c(267)*M(3,:)%j)) * den(436)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4701),h0tab(:,4701),[57,6],[nMM,nMM],2,2,wf24(:,90),wf4(:,7))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,90),G0H4(30),m3h24x4(:,688),heltab2x96(:,:,4573))
  call Hloop_Q_A(ntryL,G0H4(30),57,nMM,G1H4(266),n2h4(776))
  Gcoeff(:)%j = (-(c(264)*M(3,:)%j)) * den(436)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4702),h0tab(:,4702),[57,6],[nML,nML],2,2,wf24(:,90),wf4(:,7))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,90),G0H4(121),m3h24x4(:,689),heltab2x96(:,:,4574))
  call Hloop_Q_A(ntryL,G0H4(121),57,nML,G1H4(74),n2h4(777))
  Gcoeff(:)%j = (c(270)*M(3,:)%j) * den(436)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4703),h0tab(:,4703),[57,6],[nMT,nMT],2,2,wf24(:,90),wf4(:,7))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,90),G0H4(65),m3h24x4(:,690),heltab2x96(:,:,4575))
  call Hloop_Q_A(ntryL,G0H4(65),57,nMT,G1H4(91),n2h4(778))
  Gcoeff(:)%j = (-(c(256)*M(3,:)%j)) * den(436)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4704),h0tab(:,4704),[57,6],[nMB,nMB],2,2,wf24(:,90),wf4(:,7))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,90),G0H4(25),m3h24x4(:,691),heltab2x96(:,:,4576))
  call Hloop_Q_A(ntryL,G0H4(25),57,nMB,G1H4(462),n2h4(779))
  Gcoeff(:)%j = (-(c(261)*M(3,:)%j)) * den(437)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4705),h0tab(:,4705),[57,6],[nME,nME],2,2,wf24(:,90),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,90),G0H4(1),m3h24x4(:,692),heltab2x96(:,:,4577))
  call Hloop_Q_A(ntryL,G0H4(1),57,nME,G1H4(446),n2h4(780))
  Gcoeff(:)%j = (-(c(267)*M(3,:)%j)) * den(437)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4706),h0tab(:,4706),[57,6],[nMM,nMM],2,2,wf24(:,90),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,90),G0H4(66),m3h24x4(:,693),heltab2x96(:,:,4578))
  call Hloop_Q_A(ntryL,G0H4(66),57,nMM,G1H4(441),n2h4(781))
  Gcoeff(:)%j = (-(c(264)*M(3,:)%j)) * den(437)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4707),h0tab(:,4707),[57,6],[nML,nML],2,2,wf24(:,90),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,90),G0H4(11),m3h24x4(:,694),heltab2x96(:,:,4579))
  call Hloop_Q_A(ntryL,G0H4(11),57,nML,G1H4(2),n2h4(782))
  Gcoeff(:)%j = (-(c(270)*M(3,:)%j)) * den(437)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4708),h0tab(:,4708),[57,6],[nMT,nMT],2,2,wf24(:,90),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,90),G0H4(117),m3h24x4(:,695),heltab2x96(:,:,4580))
  call Hloop_Q_A(ntryL,G0H4(117),57,nMT,G1H4(465),n2h4(783))
  Gcoeff(:)%j = (-(c(256)*M(3,:)%j)) * den(437)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4709),h0tab(:,4709),[57,6],[nMB,nMB],2,2,wf24(:,90),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,90),G0H4(113),m3h24x4(:,696),heltab2x96(:,:,4581))
  call Hloop_Q_A(ntryL,G0H4(113),57,nMB,G1H4(478),n2h4(784))
  Gcoeff(:)%j = (c(262)*M(3,:)%j) * den(438)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4710),h0tab(:,4710),[57,6],[nME,nME],2,2,wf24(:,91),wf4(:,7))
  call Hloop_QZ_A(ntryL,G0H96(1),wf24(:,91),G0H4(109),ngZl,m3h24x4(:,697),heltab2x96(:,:,4582))
  call Hloop_Q_A(ntryL,G0H4(109),57,nME,G1H4(413),n2h4(785))
  Gcoeff(:)%j = (c(268)*M(3,:)%j) * den(438)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4711),h0tab(:,4711),[57,6],[nMM,nMM],2,2,wf24(:,91),wf4(:,7))
  call Hloop_QZ_A(ntryL,G0H96(1),wf24(:,91),G0H4(105),ngZl,m3h24x4(:,698),heltab2x96(:,:,4583))
  call Hloop_Q_A(ntryL,G0H4(105),57,nMM,G1H4(414),n2h4(786))
  Gcoeff(:)%j = (c(265)*M(3,:)%j) * den(438)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4712),h0tab(:,4712),[57,6],[nML,nML],2,2,wf24(:,91),wf4(:,7))
  call Hloop_QZ_A(ntryL,G0H96(1),wf24(:,91),G0H4(101),ngZl,m3h24x4(:,699),heltab2x96(:,:,4584))
  call Hloop_Q_A(ntryL,G0H4(101),57,nML,G1H4(417),n2h4(787))
  Gcoeff(:)%j = (c(272)*M(3,:)%j) * den(438)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4713),h0tab(:,4713),[57,6],[nMT,nMT],2,2,wf24(:,91),wf4(:,7))
  call Hloop_QZ_A(ntryL,G0H96(1),wf24(:,91),G0H4(97),ngZu,m3h24x4(:,700),heltab2x96(:,:,4585))
  call Hloop_Q_A(ntryL,G0H4(97),57,nMT,G1H4(418),n2h4(788))
  Gcoeff(:)%j = (c(258)*M(3,:)%j) * den(438)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4714),h0tab(:,4714),[57,6],[nMB,nMB],2,2,wf24(:,91),wf4(:,7))
  call Hloop_QZ_A(ntryL,G0H96(1),wf24(:,91),G0H4(93),ngZd,m3h24x4(:,701),heltab2x96(:,:,4586))
  call Hloop_Q_A(ntryL,G0H4(93),57,nMB,G1H4(459),n2h4(789))
  Gcoeff(:)%j = (c(262)*M(3,:)%j) * den(439)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4715),h0tab(:,4715),[57,6],[nME,nME],2,2,wf24(:,91),wf4(:,17))
  call Hloop_QZ_A(ntryL,G0H96(1),wf24(:,91),G0H4(89),ngZl,m3h24x4(:,702),heltab2x96(:,:,4587))
  call Hloop_Q_A(ntryL,G0H4(89),57,nME,G1H4(460),n2h4(790))
  Gcoeff(:)%j = (c(268)*M(3,:)%j) * den(439)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4716),h0tab(:,4716),[57,6],[nMM,nMM],2,2,wf24(:,91),wf4(:,17))
  call Hloop_QZ_A(ntryL,G0H96(1),wf24(:,91),G0H4(85),ngZl,m3h24x4(:,703),heltab2x96(:,:,4588))
  call Hloop_Q_A(ntryL,G0H4(85),57,nMM,G1H4(461),n2h4(791))
  Gcoeff(:)%j = (c(265)*M(3,:)%j) * den(439)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4717),h0tab(:,4717),[57,6],[nML,nML],2,2,wf24(:,91),wf4(:,17))
  call Hloop_QZ_A(ntryL,G0H96(1),wf24(:,91),G0H4(123),ngZl,m3h24x4(:,704),heltab2x96(:,:,4589))
  call Hloop_Q_A(ntryL,G0H4(123),57,nML,G1H4(463),n2h4(792))
  Gcoeff(:)%j = (-(c(272)*M(3,:)%j)) * den(439)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4718),h0tab(:,4718),[57,6],[nMT,nMT],2,2,wf24(:,91),wf4(:,17))
  call Hloop_QZ_A(ntryL,G0H96(1),wf24(:,91),G0H4(78),ngZu,m3h24x4(:,705),heltab2x96(:,:,4590))
  call Hloop_Q_A(ntryL,G0H4(78),57,nMT,G1H4(464),n2h4(793))
  Gcoeff(:)%j = (c(258)*M(3,:)%j) * den(439)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4719),h0tab(:,4719),[57,6],[nMB,nMB],2,2,wf24(:,91),wf4(:,17))
  call Hloop_QZ_A(ntryL,G0H96(1),wf24(:,91),G0H4(76),ngZd,m3h24x4(:,706),heltab2x96(:,:,4591))
  call Hloop_Q_A(ntryL,G0H4(76),57,nMB,G1H4(474),n2h4(794))
  Gcoeff(:)%j = (-(c(90)*M(3,:)%j)) * den(436)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4720),h0tab(:,4720),[57,6],[nMW,nMW],2,2,wf24(:,90),wf4(:,7))
  call Hloop_TV_S(ntryL,G0H96(1),0,wf24(:,90),57,G1H4(475),m3h24x4(:,707),heltab2x96(:,:,4592))
  Gcoeff(:)%j = (c(204)*M(3,:)%j) * den(438)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4721),h0tab(:,4721),[57,6],[nMW,nMW],2,2,wf24(:,91),wf4(:,7))
  call Hloop_TV_S(ntryL,G0H96(1),0,wf24(:,91),57,G1H4(476),m3h24x4(:,708),heltab2x96(:,:,4593))
  Gcoeff(:)%j = (-(c(56)*M(3,:)%j)) * den(439)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4722),h0tab(:,4722),[57,6],[nMZ,nMH],2,2,wf24(:,91),wf4(:,17))
  call Hloop_TV_S(ntryL,G0H96(1),0,wf24(:,91),57,G1H4(322),m3h24x4(:,709),heltab2x96(:,:,4594))
  Gcoeff(:)%j = (-(c(76)*M(3,:)%j)) * den(436)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4723),h0tab(:,4723),[57,6],[nMW,nMW],2,2,wf24(:,90),wf4(:,7))
  call Hloop_CV_D(ntryL,G0H96(1),0,wf24(:,90),57,G1H4(432),m3h24x4(:,710),heltab2x96(:,:,4595))
  Gcoeff(:)%j = (c(76)*M(3,:)%j) * den(436)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4724),h0tab(:,4724),[57,6],[nMW,nMW],2,2,wf24(:,90),wf4(:,7))
  call Hloop_CV_D(ntryL,G0H96(1),0,wf24(:,90),57,G1H4(412),m3h24x4(:,711),heltab2x96(:,:,4596))
  Gcoeff(:)%j = (-(c(76)*M(3,:)%j)) * den(437)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4725),h0tab(:,4725),[57,6],[nMW,nMW],2,2,wf24(:,90),wf4(:,17))
  call Hloop_CV_D(ntryL,G0H96(1),0,wf24(:,90),57,G1H4(409),m3h24x4(:,712),heltab2x96(:,:,4597))
  Gcoeff(:)%j = (-(c(76)*M(3,:)%j)) * den(437)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4726),h0tab(:,4726),[57,6],[nMW,nMW],2,2,wf24(:,90),wf4(:,17))
  call Hloop_CV_D(ntryL,G0H96(1),0,wf24(:,90),57,G1H4(428),m3h24x4(:,713),heltab2x96(:,:,4598))
  Gcoeff(:)%j = (-(c(54)*M(3,:)%j)) * den(438)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4727),h0tab(:,4727),[57,6],[nMW,nMW],2,2,wf24(:,91),wf4(:,7))
  call Hloop_CV_D(ntryL,G0H96(1),0,wf24(:,91),57,G1H4(429),m3h24x4(:,714),heltab2x96(:,:,4599))
  Gcoeff(:)%j = (c(54)*M(3,:)%j) * den(438)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4728),h0tab(:,4728),[57,6],[nMW,nMW],2,2,wf24(:,91),wf4(:,7))
  call Hloop_CV_D(ntryL,G0H96(1),0,wf24(:,91),57,G1H4(320),m3h24x4(:,715),heltab2x96(:,:,4600))
  Gcoeff(:)%j = (-(c(54)*M(3,:)%j)) * den(439)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4729),h0tab(:,4729),[57,6],[nMW,nMW],2,2,wf24(:,91),wf4(:,17))
  call Hloop_CV_D(ntryL,G0H96(1),0,wf24(:,91),57,G1H4(169),m3h24x4(:,716),heltab2x96(:,:,4601))
  Gcoeff(:)%j = (-(c(54)*M(3,:)%j)) * den(439)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4730),h0tab(:,4730),[57,6],[nMW,nMW],2,2,wf24(:,91),wf4(:,17))
  call Hloop_CV_D(ntryL,G0H96(1),0,wf24(:,91),57,G1H4(248),m3h24x4(:,717),heltab2x96(:,:,4602))
  Gcoeff(:)%j = (-(c(79)*M(3,:)%j)) * den(436)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4731),h0tab(:,4731),[57,6],[nMW,nMW],2,2,wf24(:,90),wf4(:,7))
  call Hloop_UV_W(ntryL,G0H96(1),0,wf24(:,90),57,G1H4(274),m3h24x4(:,718),heltab2x96(:,:,4603))
  Gcoeff(:)%j = (-(c(55)*M(3,:)%j)) * den(438)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4732),h0tab(:,4732),[57,6],[nMW,nMW],2,2,wf24(:,91),wf4(:,7))
  call Hloop_UV_W(ntryL,G0H96(1),0,wf24(:,91),57,G1H4(273),m3h24x4(:,719),heltab2x96(:,:,4604))
  Gcoeff(:)%j = (-(c(76)*M(3,:)%j)) * den(436)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4733),h0tab(:,4733),[57,6],[nMW,nMW],2,2,wf24(:,90),wf4(:,7))
  call Hloop_SV_V(ntryL,G0H96(1),wf24(:,90),G0H4(72),m3h24x4(:,720),heltab2x96(:,:,4605))
  Gcoeff(:)%j = (c(76)*M(3,:)%j) * den(436)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4734),h0tab(:,4734),[57,6],[nMW,nMW],2,2,wf24(:,90),wf4(:,7))
  call Hloop_SV_V(ntryL,G0H96(1),wf24(:,90),G0H4(70),m3h24x4(:,721),heltab2x96(:,:,4606))
  Gcoeff(:)%j = (-(c(76)*M(3,:)%j)) * den(437)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4735),h0tab(:,4735),[57,6],[nMW,nMW],2,2,wf24(:,90),wf4(:,17))
  call Hloop_SV_V(ntryL,G0H96(1),wf24(:,90),G0H4(61),m3h24x4(:,722),heltab2x96(:,:,4607))
  Gcoeff(:)%j = (-(c(76)*M(3,:)%j)) * den(437)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4736),h0tab(:,4736),[57,6],[nMW,nMW],2,2,wf24(:,90),wf4(:,17))
  call Hloop_SV_V(ntryL,G0H96(1),wf24(:,90),G0H4(59),m3h24x4(:,723),heltab2x96(:,:,4608))
  Gcoeff(:)%j = (c(138)*M(3,:)%j) * den(438)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4737),h0tab(:,4737),[57,6],[nMW,nMW],2,2,wf24(:,91),wf4(:,7))
  call Hloop_SV_V(ntryL,G0H96(1),wf24(:,91),G0H4(55),m3h24x4(:,724),heltab2x96(:,:,4609))
  Gcoeff(:)%j = (-(c(138)*M(3,:)%j)) * den(438)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4738),h0tab(:,4738),[57,6],[nMW,nMW],2,2,wf24(:,91),wf4(:,7))
  call Hloop_SV_V(ntryL,G0H96(1),wf24(:,91),G0H4(53),m3h24x4(:,725),heltab2x96(:,:,4610))
  Gcoeff(:)%j = (-(c(51)*M(3,:)%j)) * den(439)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4739),h0tab(:,4739),[57,6],[nMZ,nMH],2,2,wf24(:,91),wf4(:,17))
  call Hloop_SV_V(ntryL,G0H96(1),wf24(:,91),G0H4(41),m3h24x4(:,726),heltab2x96(:,:,4611))
  Gcoeff(:)%j = (c(138)*M(3,:)%j) * den(439)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4740),h0tab(:,4740),[57,6],[nMW,nMW],2,2,wf24(:,91),wf4(:,17))
  call Hloop_SV_V(ntryL,G0H96(1),wf24(:,91),G0H4(39),m3h24x4(:,727),heltab2x96(:,:,4612))
  Gcoeff(:)%j = (c(138)*M(3,:)%j) * den(439)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4741),h0tab(:,4741),[57,6],[nMW,nMW],2,2,wf24(:,91),wf4(:,17))
  call Hloop_SV_V(ntryL,G0H96(1),wf24(:,91),G0H4(35),m3h24x4(:,728),heltab2x96(:,:,4613))
  Gcoeff(:)%j = (-(c(315)*M(3,:)%j)) * den(440)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4742),h0tab(:,4742),[57,6],[nME,nME],2,2,wf24(:,90),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,90),G0H4(33),m3h24x4(:,729),heltab2x96(:,:,4614))
  call Hloop_Q_A(ntryL,G0H4(33),57,nME,G1H4(28),n2h4(795))
  Gcoeff(:)%j = (-(c(315)*M(3,:)%j)) * den(440)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4743),h0tab(:,4743),[57,6],[nMM,nMM],2,2,wf24(:,90),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,90),G0H4(124),m3h24x4(:,730),heltab2x96(:,:,4615))
  call Hloop_Q_A(ntryL,G0H4(124),57,nMM,G1H4(398),n2h4(796))
  Gcoeff(:)%j = (-(c(315)*M(3,:)%j)) * den(440)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4744),h0tab(:,4744),[57,6],[nML,nML],2,2,wf24(:,90),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,90),G0H4(77),m3h24x4(:,731),heltab2x96(:,:,4616))
  call Hloop_Q_A(ntryL,G0H4(77),57,nML,G1H4(390),n2h4(797))
  Gcoeff(:)%j = (-(c(314)*M(3,:)%j)) * den(440)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4745),h0tab(:,4745),[57,6],[0,0],2,2,wf24(:,90),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,90),G0H4(81),m3h24x4(:,732),heltab2x96(:,:,4617))
  call Hloop_Q_A(ntryL,G0H4(81),57,0,G1H4(382),n2h4(798))
  Gcoeff(:)%j = (-(c(308)*M(3,:)%j)) * den(440)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4746),h0tab(:,4746),[57,6],[nMT,nMT],2,2,wf24(:,90),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,90),G0H4(79),m3h24x4(:,733),heltab2x96(:,:,4618))
  call Hloop_Q_A(ntryL,G0H4(79),57,nMT,G1H4(359),n2h4(799))
  Gcoeff(:)%j = (-(c(305)*M(3,:)%j)) * den(440)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4747),h0tab(:,4747),[57,6],[0,0],2,2,wf24(:,90),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,90),G0H4(75),m3h24x4(:,734),heltab2x96(:,:,4619))
  call Hloop_Q_A(ntryL,G0H4(75),57,0,G1H4(141),n2h4(800))
  Gcoeff(:)%j = (-(c(303)*M(3,:)%j)) * den(440)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4748),h0tab(:,4748),[57,6],[nMB,nMB],2,2,wf24(:,90),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,90),G0H4(73),m3h24x4(:,735),heltab2x96(:,:,4620))
  call Hloop_Q_A(ntryL,G0H4(73),57,nMB,G1H4(367),n2h4(801))
  Gcoeff(:)%j = (c(318)*M(3,:)%j) * den(437)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4749),h0tab(:,4749),[57,6],[nME,nME],2,2,wf24(:,90),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,90),G0H4(29),m3h24x4(:,736),heltab2x96(:,:,4621))
  call Hloop_Q_A(ntryL,G0H4(29),57,nME,G1H4(76),n2h4(802))
  Gcoeff(:)%j = (c(318)*M(3,:)%j) * den(437)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4750),h0tab(:,4750),[57,6],[nMM,nMM],2,2,wf24(:,90),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,90),G0H4(30),m3h24x4(:,737),heltab2x96(:,:,4622))
  call Hloop_Q_A(ntryL,G0H4(30),57,nMM,G1H4(293),n2h4(803))
  Gcoeff(:)%j = (c(318)*M(3,:)%j) * den(437)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4751),h0tab(:,4751),[57,6],[nML,nML],2,2,wf24(:,90),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,90),G0H4(121),m3h24x4(:,738),heltab2x96(:,:,4623))
  call Hloop_Q_A(ntryL,G0H4(121),57,nML,G1H4(146),n2h4(804))
  Gcoeff(:)%j = (-(c(320)*M(3,:)%j)) * den(437)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4752),h0tab(:,4752),[57,6],[0,0],2,2,wf24(:,90),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,90),G0H4(65),m3h24x4(:,739),heltab2x96(:,:,4624))
  call Hloop_Q_A(ntryL,G0H4(65),57,0,G1H4(271),n2h4(805))
  Gcoeff(:)%j = (-(c(316)*M(3,:)%j)) * den(437)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4753),h0tab(:,4753),[57,6],[nMT,nMT],2,2,wf24(:,90),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,90),G0H4(25),m3h24x4(:,740),heltab2x96(:,:,4625))
  call Hloop_Q_A(ntryL,G0H4(25),57,nMT,G1H4(150),n2h4(806))
  Gcoeff(:)%j = (c(316)*M(3,:)%j) * den(437)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4754),h0tab(:,4754),[57,6],[0,0],2,2,wf24(:,90),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,90),G0H4(1),m3h24x4(:,741),heltab2x96(:,:,4626))
  call Hloop_Q_A(ntryL,G0H4(1),57,0,G1H4(17),n2h4(807))
  Gcoeff(:)%j = (c(310)*M(3,:)%j) * den(437)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4755),h0tab(:,4755),[57,6],[nMB,nMB],2,2,wf24(:,90),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,90),G0H4(66),m3h24x4(:,742),heltab2x96(:,:,4627))
  call Hloop_Q_A(ntryL,G0H4(66),57,nMB,G1H4(101),n2h4(808))
  Gcoeff(:)%j = (c(318)*M(3,:)%j) * den(441)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4756),h0tab(:,4756),[57,6],[nME,nME],2,2,wf24(:,91),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H96(1),wf24(:,91),G0H4(11),ngZl,m3h24x4(:,743),heltab2x96(:,:,4628))
  call Hloop_Q_A(ntryL,G0H4(11),57,nME,G1H4(249),n2h4(809))
  Gcoeff(:)%j = (c(318)*M(3,:)%j) * den(441)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4757),h0tab(:,4757),[57,6],[nMM,nMM],2,2,wf24(:,91),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H96(1),wf24(:,91),G0H4(117),ngZl,m3h24x4(:,744),heltab2x96(:,:,4629))
  call Hloop_Q_A(ntryL,G0H4(117),57,nMM,G1H4(331),n2h4(810))
  Gcoeff(:)%j = (c(318)*M(3,:)%j) * den(441)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4758),h0tab(:,4758),[57,6],[nML,nML],2,2,wf24(:,91),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H96(1),wf24(:,91),G0H4(113),ngZl,m3h24x4(:,745),heltab2x96(:,:,4630))
  call Hloop_Q_A(ntryL,G0H4(113),57,nML,G1H4(26),n2h4(811))
  Gcoeff(:)%j = (-(c(320)*M(3,:)%j)) * den(441)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4759),h0tab(:,4759),[57,6],[0,0],2,2,wf24(:,91),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H96(1),wf24(:,91),G0H4(109),ngZu,m3h24x4(:,746),heltab2x96(:,:,4631))
  call Hloop_Q_A(ntryL,G0H4(109),57,0,G1H4(302),n2h4(812))
  Gcoeff(:)%j = (-(c(316)*M(3,:)%j)) * den(441)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4760),h0tab(:,4760),[57,6],[nMT,nMT],2,2,wf24(:,91),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H96(1),wf24(:,91),G0H4(105),ngZu,m3h24x4(:,747),heltab2x96(:,:,4632))
  call Hloop_Q_A(ntryL,G0H4(105),57,nMT,G1H4(400),n2h4(813))
  Gcoeff(:)%j = (c(316)*M(3,:)%j) * den(441)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4761),h0tab(:,4761),[57,6],[0,0],2,2,wf24(:,91),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H96(1),wf24(:,91),G0H4(101),ngZd,m3h24x4(:,748),heltab2x96(:,:,4633))
  call Hloop_Q_A(ntryL,G0H4(101),57,0,G1H4(168),n2h4(814))
  Gcoeff(:)%j = (c(310)*M(3,:)%j) * den(441)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4762),h0tab(:,4762),[57,6],[nMB,nMB],2,2,wf24(:,91),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H96(1),wf24(:,91),G0H4(97),ngZd,m3h24x4(:,749),heltab2x96(:,:,4634))
  call Hloop_Q_A(ntryL,G0H4(97),57,nMB,G1H4(213),n2h4(815))
  Gcoeff(:)%j = (-(c(325)*M(3,:)%j)) * den(439)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4763),h0tab(:,4763),[57,6],[0,0],2,2,wf24(:,91),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H96(1),wf24(:,91),G0H4(93),ngZn,m3h24x4(:,750),heltab2x96(:,:,4635))
  call Hloop_Q_A(ntryL,G0H4(93),57,0,G1H4(120),n2h4(816))
  Gcoeff(:)%j = (-(c(321)*M(3,:)%j)) * den(439)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4764),h0tab(:,4764),[57,6],[nME,nME],2,2,wf24(:,91),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H96(1),wf24(:,91),G0H4(89),ngZl,m3h24x4(:,751),heltab2x96(:,:,4636))
  call Hloop_Q_A(ntryL,G0H4(89),57,nME,G1H4(235),n2h4(817))
  Gcoeff(:)%j = (-(c(321)*M(3,:)%j)) * den(439)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4765),h0tab(:,4765),[57,6],[nMM,nMM],2,2,wf24(:,91),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H96(1),wf24(:,91),G0H4(85),ngZl,m3h24x4(:,752),heltab2x96(:,:,4637))
  call Hloop_Q_A(ntryL,G0H4(85),57,nMM,G1H4(309),n2h4(818))
  Gcoeff(:)%j = (-(c(321)*M(3,:)%j)) * den(439)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4766),h0tab(:,4766),[57,6],[nML,nML],2,2,wf24(:,91),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H96(1),wf24(:,91),G0H4(123),ngZl,m3h24x4(:,753),heltab2x96(:,:,4638))
  call Hloop_Q_A(ntryL,G0H4(123),57,nML,G1H4(46),n2h4(819))
  Gcoeff(:)%j = (-(c(324)*M(3,:)%j)) * den(439)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4767),h0tab(:,4767),[57,6],[0,0],2,2,wf24(:,91),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H96(1),wf24(:,91),G0H4(78),ngZu,m3h24x4(:,754),heltab2x96(:,:,4639))
  call Hloop_Q_A(ntryL,G0H4(78),57,0,G1H4(50),n2h4(820))
  Gcoeff(:)%j = (-(c(322)*M(3,:)%j)) * den(439)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4768),h0tab(:,4768),[57,6],[nMT,nMT],2,2,wf24(:,91),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H96(1),wf24(:,91),G0H4(76),ngZu,m3h24x4(:,755),heltab2x96(:,:,4640))
  call Hloop_Q_A(ntryL,G0H4(76),57,nMT,G1H4(230),n2h4(821))
  Gcoeff(:)%j = (-(c(324)*M(3,:)%j)) * den(439)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4769),h0tab(:,4769),[57,6],[0,0],2,2,wf24(:,91),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H96(1),wf24(:,91),G0H4(33),ngZd,m3h24x4(:,756),heltab2x96(:,:,4641))
  call Hloop_Q_A(ntryL,G0H4(33),57,0,G1H4(304),n2h4(822))
  Gcoeff(:)%j = (-(c(322)*M(3,:)%j)) * den(439)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4770),h0tab(:,4770),[57,6],[nMB,nMB],2,2,wf24(:,91),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H96(1),wf24(:,91),G0H4(124),ngZd,m3h24x4(:,757),heltab2x96(:,:,4642))
  call Hloop_Q_A(ntryL,G0H4(124),57,nMB,G1H4(300),n2h4(823))
  Gcoeff(:)%j = (c(153)*M(3,:)%j) * den(440)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4771),h0tab(:,4771),[57,6],[nMW,nMW],2,2,wf24(:,90),wf4(:,1))
  call Hloop_TV_S(ntryL,G0H96(1),0,wf24(:,90),57,G1H4(124),m3h24x4(:,758),heltab2x96(:,:,4643))
  Gcoeff(:)%j = (c(200)*M(3,:)%j) * den(437)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4772),h0tab(:,4772),[57,6],[nMW,nMW],2,2,wf24(:,90),wf4(:,4))
  call Hloop_TV_S(ntryL,G0H96(1),0,wf24(:,90),57,G1H4(332),m3h24x4(:,759),heltab2x96(:,:,4644))
  Gcoeff(:)%j = (c(200)*M(3,:)%j) * den(441)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4773),h0tab(:,4773),[57,6],[nMW,nMW],2,2,wf24(:,91),wf4(:,1))
  call Hloop_TV_S(ntryL,G0H96(1),0,wf24(:,91),57,G1H4(397),m3h24x4(:,760),heltab2x96(:,:,4645))
  Gcoeff(:)%j = (-(c(68)*M(3,:)%j)) * den(439)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4774),h0tab(:,4774),[57,6],[nMZ,nMH],2,2,wf24(:,91),wf4(:,4))
  call Hloop_TV_S(ntryL,G0H96(1),0,wf24(:,91),57,G1H4(392),m3h24x4(:,761),heltab2x96(:,:,4646))
  Gcoeff(:)%j = (c(211)*M(3,:)%j) * den(439)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4775),h0tab(:,4775),[57,6],[nMW,nMW],2,2,wf24(:,91),wf4(:,4))
  call Hloop_TV_S(ntryL,G0H96(1),0,wf24(:,91),57,G1H4(237),m3h24x4(:,762),heltab2x96(:,:,4647))
  Gcoeff(:)%j = (-(c(153)*M(3,:)%j)) * den(440)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4776),h0tab(:,4776),[57,6],[nMW,nMW],2,2,wf24(:,90),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H96(1),0,wf24(:,90),57,G1H4(40),m3h24x4(:,763),heltab2x96(:,:,4648))
  Gcoeff(:)%j = (-(c(153)*M(3,:)%j)) * den(440)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4777),h0tab(:,4777),[57,6],[nMW,nMW],2,2,wf24(:,90),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H96(1),0,wf24(:,90),57,G1H4(212),m3h24x4(:,764),heltab2x96(:,:,4649))
  Gcoeff(:)%j = (-(c(130)*M(3,:)%j)) * den(437)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4778),h0tab(:,4778),[57,6],[nMW,nMW],2,2,wf24(:,90),wf4(:,4))
  call Hloop_CV_D(ntryL,G0H96(1),0,wf24(:,90),57,G1H4(29),m3h24x4(:,765),heltab2x96(:,:,4650))
  Gcoeff(:)%j = (-(c(130)*M(3,:)%j)) * den(437)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4779),h0tab(:,4779),[57,6],[nMW,nMW],2,2,wf24(:,90),wf4(:,4))
  call Hloop_CV_D(ntryL,G0H96(1),0,wf24(:,90),57,G1H4(294),m3h24x4(:,766),heltab2x96(:,:,4651))
  Gcoeff(:)%j = (-(c(130)*M(3,:)%j)) * den(441)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4780),h0tab(:,4780),[57,6],[nMW,nMW],2,2,wf24(:,91),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H96(1),0,wf24(:,91),57,G1H4(97),m3h24x4(:,767),heltab2x96(:,:,4652))
  Gcoeff(:)%j = (-(c(130)*M(3,:)%j)) * den(441)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4781),h0tab(:,4781),[57,6],[nMW,nMW],2,2,wf24(:,91),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H96(1),0,wf24(:,91),57,G1H4(220),m3h24x4(:,768),heltab2x96(:,:,4653))
  Gcoeff(:)%j = (-(c(70)*M(3,:)%j)) * den(439)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4782),h0tab(:,4782),[57,6],[nMW,nMW],2,2,wf24(:,91),wf4(:,4))
  call Hloop_CV_D(ntryL,G0H96(1),0,wf24(:,91),57,G1H4(200),m3h24x4(:,769),heltab2x96(:,:,4654))
  Gcoeff(:)%j = (-(c(70)*M(3,:)%j)) * den(439)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4783),h0tab(:,4783),[57,6],[nMW,nMW],2,2,wf24(:,91),wf4(:,4))
  call Hloop_CV_D(ntryL,G0H96(1),0,wf24(:,91),57,G1H4(247),m3h24x4(:,770),heltab2x96(:,:,4655))
  Gcoeff(:)%j = (c(153)*M(3,:)%j) * den(440)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4784),h0tab(:,4784),[57,6],[nMW,nMW],2,2,wf24(:,90),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H96(1),0,wf24(:,90),57,G1H4(267),m3h24x4(:,771),heltab2x96(:,:,4656))
  Gcoeff(:)%j = (c(130)*M(3,:)%j) * den(437)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4785),h0tab(:,4785),[57,6],[nMW,nMW],2,2,wf24(:,90),wf4(:,4))
  call Hloop_UV_W(ntryL,G0H96(1),0,wf24(:,90),57,G1H4(93),m3h24x4(:,772),heltab2x96(:,:,4657))
  Gcoeff(:)%j = (c(130)*M(3,:)%j) * den(441)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4786),h0tab(:,4786),[57,6],[nMW,nMW],2,2,wf24(:,91),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H96(1),0,wf24(:,91),57,G1H4(75),m3h24x4(:,773),heltab2x96(:,:,4658))
  Gcoeff(:)%j = (c(70)*M(3,:)%j) * den(439)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4787),h0tab(:,4787),[57,6],[nMW,nMW],2,2,wf24(:,91),wf4(:,4))
  call Hloop_UV_W(ntryL,G0H96(1),0,wf24(:,91),57,G1H4(260),m3h24x4(:,774),heltab2x96(:,:,4659))
  Gcoeff(:)%j = (-(c(185)*M(3,:)%j)) * den(440)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4788),h0tab(:,4788),[57,6],[nMW,nMW],2,2,wf24(:,90),wf4(:,1))
  call Hloop_SV_V(ntryL,G0H96(1),wf24(:,90),G0H4(77),m3h24x4(:,775),heltab2x96(:,:,4660))
  Gcoeff(:)%j = (-(c(185)*M(3,:)%j)) * den(440)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4789),h0tab(:,4789),[57,6],[nMW,nMW],2,2,wf24(:,90),wf4(:,1))
  call Hloop_SV_V(ntryL,G0H96(1),wf24(:,90),G0H4(81),m3h24x4(:,776),heltab2x96(:,:,4661))
  Gcoeff(:)%j = (c(2)*M(3,:)%j) * den(437)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4790),h0tab(:,4790),[57,6],[nMW,nMW],2,2,wf24(:,90),wf4(:,4))
  call Hloop_SV_V(ntryL,G0H96(1),wf24(:,90),G0H4(79),m3h24x4(:,777),heltab2x96(:,:,4662))
  Gcoeff(:)%j = (c(2)*M(3,:)%j) * den(437)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4791),h0tab(:,4791),[57,6],[nMW,nMW],2,2,wf24(:,90),wf4(:,4))
  call Hloop_SV_V(ntryL,G0H96(1),wf24(:,90),G0H4(75),m3h24x4(:,778),heltab2x96(:,:,4663))
  Gcoeff(:)%j = (c(2)*M(3,:)%j) * den(441)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4792),h0tab(:,4792),[57,6],[nMW,nMW],2,2,wf24(:,91),wf4(:,1))
  call Hloop_SV_V(ntryL,G0H96(1),wf24(:,91),G0H4(73),m3h24x4(:,779),heltab2x96(:,:,4664))
  Gcoeff(:)%j = (c(2)*M(3,:)%j) * den(441)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4793),h0tab(:,4793),[57,6],[nMW,nMW],2,2,wf24(:,91),wf4(:,1))
  call Hloop_SV_V(ntryL,G0H96(1),wf24(:,91),G0H4(29),m3h24x4(:,780),heltab2x96(:,:,4665))
  Gcoeff(:)%j = (-(c(101)*M(3,:)%j)) * den(439)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4794),h0tab(:,4794),[57,6],[nMZ,nMH],2,2,wf24(:,91),wf4(:,4))
  call Hloop_SV_V(ntryL,G0H96(1),wf24(:,91),G0H4(30),m3h24x4(:,781),heltab2x96(:,:,4666))
  Gcoeff(:)%j = (-(c(192)*M(3,:)%j)) * den(439)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4795),h0tab(:,4795),[57,6],[nMW,nMW],2,2,wf24(:,91),wf4(:,4))
  call Hloop_SV_V(ntryL,G0H96(1),wf24(:,91),G0H4(121),m3h24x4(:,782),heltab2x96(:,:,4667))
  Gcoeff(:)%j = (-(c(192)*M(3,:)%j)) * den(439)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4796),h0tab(:,4796),[57,6],[nMW,nMW],2,2,wf24(:,91),wf4(:,4))
  call Hloop_SV_V(ntryL,G0H96(1),wf24(:,91),G0H4(65),m3h24x4(:,783),heltab2x96(:,:,4668))
  Gcoeff(:)%j = (-(c(231)*M(3,:)%j)) * den(219)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4797),h0tab(:,4797),[41,22],[nME,0],2,2,wf8(:,10),wf12(:,29))
  call Hloop_QW_A(ntryL,G0H96(1),wf8(:,10),G0H12(92),m3h8x12(:,887),heltab2x96(:,:,4669))
  call Hloop_Q_A(ntryL,G0H12(92),41,nME,G1H12(292),n2h12(940))
  Gcoeff(:)%j = (-(c(233)*M(3,:)%j)) * den(219)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4798),h0tab(:,4798),[41,22],[nMM,0],2,2,wf8(:,10),wf12(:,29))
  call Hloop_QW_A(ntryL,G0H96(1),wf8(:,10),G0H12(93),m3h8x12(:,888),heltab2x96(:,:,4670))
  call Hloop_Q_A(ntryL,G0H12(93),41,nMM,G1H12(293),n2h12(941))
  Gcoeff(:)%j = (-(c(232)*M(3,:)%j)) * den(219)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4799),h0tab(:,4799),[41,22],[nML,0],2,2,wf8(:,10),wf12(:,29))
  call Hloop_QW_A(ntryL,G0H96(1),wf8(:,10),G0H12(94),m3h8x12(:,889),heltab2x96(:,:,4671))
  call Hloop_Q_A(ntryL,G0H12(94),41,nML,G1H12(296),n2h12(942))
  Gcoeff(:)%j = (c(229)*M(3,:)%j) * den(219)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4800),h0tab(:,4800),[41,22],[nMB,nMT],2,2,wf8(:,10),wf12(:,29))
  call Hloop_QW_A(ntryL,G0H96(1),wf8(:,10),G0H12(95),m3h8x12(:,890),heltab2x96(:,:,4672))
  call Hloop_Q_A(ntryL,G0H12(95),41,nMB,G1H12(299),n2h12(943))
  Gcoeff(:)%j = (c(231)*M(3,:)%j) * den(220)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4801),h0tab(:,4801),[41,22],[nME,0],2,2,wf8(:,10),wf12(:,30))
  call Hloop_QW_A(ntryL,G0H96(1),wf8(:,10),G0H12(96),m3h8x12(:,891),heltab2x96(:,:,4673))
  call Hloop_Q_A(ntryL,G0H12(96),41,nME,G1H12(300),n2h12(944))
  Gcoeff(:)%j = (c(233)*M(3,:)%j) * den(220)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4802),h0tab(:,4802),[41,22],[nMM,0],2,2,wf8(:,10),wf12(:,30))
  call Hloop_QW_A(ntryL,G0H96(1),wf8(:,10),G0H12(49),m3h8x12(:,892),heltab2x96(:,:,4674))
  call Hloop_Q_A(ntryL,G0H12(49),41,nMM,G1H12(311),n2h12(945))
  Gcoeff(:)%j = (c(232)*M(3,:)%j) * den(220)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4803),h0tab(:,4803),[41,22],[nML,0],2,2,wf8(:,10),wf12(:,30))
  call Hloop_QW_A(ntryL,G0H96(1),wf8(:,10),G0H12(57),m3h8x12(:,893),heltab2x96(:,:,4675))
  call Hloop_Q_A(ntryL,G0H12(57),41,nML,G1H12(312),n2h12(946))
  Gcoeff(:)%j = (-(c(229)*M(3,:)%j)) * den(220)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4804),h0tab(:,4804),[41,22],[nMB,nMT],2,2,wf8(:,10),wf12(:,30))
  call Hloop_QW_A(ntryL,G0H96(1),wf8(:,10),G0H12(65),m3h8x12(:,894),heltab2x96(:,:,4676))
  call Hloop_Q_A(ntryL,G0H12(65),41,nMB,G1H12(315),n2h12(947))
  Gcoeff(:)%j = (c(13)*M(3,:)%j) * den(219)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4805),h0tab(:,4805),[41,22],[nMW,nMH],2,2,wf8(:,10),wf12(:,29))
  call Hloop_TV_S(ntryL,G0H96(1),0,wf8(:,10),41,G1H12(316),m3h8x12(:,895),heltab2x96(:,:,4677))
  Gcoeff(:)%j = (-(c(13)*M(3,:)%j)) * den(220)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4806),h0tab(:,4806),[41,22],[nMW,nMH],2,2,wf8(:,10),wf12(:,30))
  call Hloop_TV_S(ntryL,G0H96(1),0,wf8(:,10),41,G1H12(317),m3h8x12(:,896),heltab2x96(:,:,4678))
  Gcoeff(:)%j = (c(4)*M(3,:)%j) * den(219)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4807),h0tab(:,4807),[41,22],[nMW,nMZ],2,2,wf8(:,10),wf12(:,29))
  call Hloop_CV_D(ntryL,G0H96(1),0,wf8(:,10),41,G1H12(320),m3h8x12(:,897),heltab2x96(:,:,4679))
  Gcoeff(:)%j = (c(78)*M(3,:)%j) * den(219)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4808),h0tab(:,4808),[41,22],[nMW,0],2,2,wf8(:,10),wf12(:,29))
  call Hloop_DV_C(ntryL,G0H96(1),0,wf8(:,10),G1H12(321),m3h8x12(:,898),heltab2x96(:,:,4680))
  Gcoeff(:)%j = (-(c(193)*M(3,:)%j)) * den(219)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4809),h0tab(:,4809),[41,22],[nMW,nMZ],2,2,wf8(:,10),wf12(:,29))
  call Hloop_DV_C(ntryL,G0H96(1),0,wf8(:,10),G1H12(322),m3h8x12(:,899),heltab2x96(:,:,4681))
  Gcoeff(:)%j = (-(c(4)*M(3,:)%j)) * den(220)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4810),h0tab(:,4810),[41,22],[nMW,nMZ],2,2,wf8(:,10),wf12(:,30))
  call Hloop_CV_D(ntryL,G0H96(1),0,wf8(:,10),41,G1H12(325),m3h8x12(:,900),heltab2x96(:,:,4682))
  Gcoeff(:)%j = (-(c(78)*M(3,:)%j)) * den(220)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4811),h0tab(:,4811),[41,22],[nMW,0],2,2,wf8(:,10),wf12(:,30))
  call Hloop_DV_C(ntryL,G0H96(1),0,wf8(:,10),G1H12(326),m3h8x12(:,901),heltab2x96(:,:,4683))
  Gcoeff(:)%j = (c(193)*M(3,:)%j) * den(220)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4812),h0tab(:,4812),[41,22],[nMW,nMZ],2,2,wf8(:,10),wf12(:,30))
  call Hloop_DV_C(ntryL,G0H96(1),0,wf8(:,10),G1H12(327),m3h8x12(:,902),heltab2x96(:,:,4684))
  Gcoeff(:)%j = (c(78)*M(3,:)%j) * den(219)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4813),h0tab(:,4813),[41,22],[nMW,0],2,2,wf8(:,10),wf12(:,29))
  call Hloop_UW_V(ntryL,G0H96(1),0,wf8(:,10),41,G1H12(330),m3h8x12(:,903),heltab2x96(:,:,4685))
  Gcoeff(:)%j = (-(c(78)*M(3,:)%j)) * den(219)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4814),h0tab(:,4814),[41,22],[nMW,nMZ],2,2,wf8(:,10),wf12(:,29))
  call Hloop_UW_V(ntryL,G0H96(1),0,wf8(:,10),41,G1H12(331),m3h8x12(:,904),heltab2x96(:,:,4686))
  Gcoeff(:)%j = (-(c(78)*M(3,:)%j)) * den(220)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4815),h0tab(:,4815),[41,22],[nMW,0],2,2,wf8(:,10),wf12(:,30))
  call Hloop_UW_V(ntryL,G0H96(1),0,wf8(:,10),41,G1H12(332),m3h8x12(:,905),heltab2x96(:,:,4687))
  Gcoeff(:)%j = (c(78)*M(3,:)%j) * den(220)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4816),h0tab(:,4816),[41,22],[nMW,nMZ],2,2,wf8(:,10),wf12(:,30))
  call Hloop_UW_V(ntryL,G0H96(1),0,wf8(:,10),41,G1H12(335),m3h8x12(:,906),heltab2x96(:,:,4688))
  Gcoeff(:)%j = (c(78)*M(3,:)%j) * den(219)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4817),h0tab(:,4817),[41,22],[0,nMW],2,2,wf8(:,10),wf12(:,29))
  call Hloop_SV_V(ntryL,G0H96(1),wf8(:,10),G0H12(17),m3h8x12(:,907),heltab2x96(:,:,4689))
  Gcoeff(:)%j = (c(208)*M(3,:)%j) * den(219)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4818),h0tab(:,4818),[41,22],[nMZ,nMW],2,2,wf8(:,10),wf12(:,29))
  call Hloop_SV_V(ntryL,G0H96(1),wf8(:,10),G0H12(18),m3h8x12(:,908),heltab2x96(:,:,4690))
  Gcoeff(:)%j = (c(4)*M(3,:)%j) * den(219)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4819),h0tab(:,4819),[41,22],[nMW,nMH],2,2,wf8(:,10),wf12(:,29))
  call Hloop_SV_V(ntryL,G0H96(1),wf8(:,10),G0H12(19),m3h8x12(:,909),heltab2x96(:,:,4691))
  Gcoeff(:)%j = (-(c(78)*M(3,:)%j)) * den(220)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4820),h0tab(:,4820),[41,22],[0,nMW],2,2,wf8(:,10),wf12(:,30))
  call Hloop_SV_V(ntryL,G0H96(1),wf8(:,10),G0H12(20),m3h8x12(:,910),heltab2x96(:,:,4692))
  Gcoeff(:)%j = (-(c(208)*M(3,:)%j)) * den(220)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4821),h0tab(:,4821),[41,22],[nMZ,nMW],2,2,wf8(:,10),wf12(:,30))
  call Hloop_SV_V(ntryL,G0H96(1),wf8(:,10),G0H12(21),m3h8x12(:,911),heltab2x96(:,:,4693))
  Gcoeff(:)%j = (-(c(4)*M(3,:)%j)) * den(220)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4822),h0tab(:,4822),[41,22],[nMW,nMH],2,2,wf8(:,10),wf12(:,30))
  call Hloop_SV_V(ntryL,G0H96(1),wf8(:,10),G0H12(22),m3h8x12(:,912),heltab2x96(:,:,4694))
  Gcoeff(:)%j = (c(222)*M(3,:)%j) * den(219)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4823),h0tab(:,4823),[41,22],[nME,0],2,2,wf8(:,10),wf12(:,5))
  call Hloop_QW_A(ntryL,G0H96(1),wf8(:,10),G0H12(23),m3h8x12(:,913),heltab2x96(:,:,4695))
  call Hloop_Q_A(ntryL,G0H12(23),41,nME,G1H12(336),n2h12(948))
  Gcoeff(:)%j = (c(222)*M(3,:)%j) * den(219)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4824),h0tab(:,4824),[41,22],[nMM,0],2,2,wf8(:,10),wf12(:,5))
  call Hloop_QW_A(ntryL,G0H96(1),wf8(:,10),G0H12(24),m3h8x12(:,914),heltab2x96(:,:,4696))
  call Hloop_Q_A(ntryL,G0H12(24),41,nMM,G1H12(337),n2h12(949))
  Gcoeff(:)%j = (c(222)*M(3,:)%j) * den(219)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4825),h0tab(:,4825),[41,22],[nML,0],2,2,wf8(:,10),wf12(:,5))
  call Hloop_QW_A(ntryL,G0H96(1),wf8(:,10),G0H12(25),m3h8x12(:,915),heltab2x96(:,:,4697))
  call Hloop_Q_A(ntryL,G0H12(25),41,nML,G1H12(86),n2h12(950))
  Gcoeff(:)%j = (c(224)*M(3,:)%j) * den(219)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4826),h0tab(:,4826),[41,22],[0,0],2,2,wf8(:,10),wf12(:,5))
  call Hloop_QW_A(ntryL,G0H96(1),wf8(:,10),G0H12(26),m3h8x12(:,916),heltab2x96(:,:,4698))
  call Hloop_Q_A(ntryL,G0H12(26),41,0,G1H12(126),n2h12(951))
  Gcoeff(:)%j = (c(223)*M(3,:)%j) * den(219)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4827),h0tab(:,4827),[41,22],[nMB,nMT],2,2,wf8(:,10),wf12(:,5))
  call Hloop_QW_A(ntryL,G0H96(1),wf8(:,10),G0H12(27),m3h8x12(:,917),heltab2x96(:,:,4699))
  call Hloop_Q_A(ntryL,G0H12(27),41,nMB,G1H12(87),n2h12(952))
  Gcoeff(:)%j = (c(4)*M(3,:)%j) * den(219)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4828),h0tab(:,4828),[41,22],[nMW,nMH],2,2,wf8(:,10),wf12(:,5))
  call Hloop_TV_S(ntryL,G0H96(1),0,wf8(:,10),41,G1H12(129),m3h8x12(:,918),heltab2x96(:,:,4700))
  Gcoeff(:)%j = (c(4)*M(3,:)%j) * den(219)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4829),h0tab(:,4829),[41,22],[nMW,nMZ],2,2,wf8(:,10),wf12(:,5))
  call Hloop_TV_S(ntryL,G0H96(1),0,wf8(:,10),41,G1H12(47),m3h8x12(:,919),heltab2x96(:,:,4701))
  Gcoeff(:)%j = (c(80)*M(3,:)%j) * den(219)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4830),h0tab(:,4830),[41,22],[nMW,0],2,2,wf8(:,10),wf12(:,5))
  call Hloop_CV_D(ntryL,G0H96(1),0,wf8(:,10),41,G1H12(152),m3h8x12(:,920),heltab2x96(:,:,4702))
  Gcoeff(:)%j = (c(10)*M(3,:)%j) * den(219)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4831),h0tab(:,4831),[41,22],[nMW,nMZ],2,2,wf8(:,10),wf12(:,5))
  call Hloop_CV_D(ntryL,G0H96(1),0,wf8(:,10),41,G1H12(64),m3h8x12(:,921),heltab2x96(:,:,4703))
  Gcoeff(:)%j = (c(80)*M(3,:)%j) * den(219)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4832),h0tab(:,4832),[41,22],[nMW,0],2,2,wf8(:,10),wf12(:,5))
  call Hloop_DV_C(ntryL,G0H96(1),0,wf8(:,10),G1H12(142),m3h8x12(:,922),heltab2x96(:,:,4704))
  Gcoeff(:)%j = (c(10)*M(3,:)%j) * den(219)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4833),h0tab(:,4833),[41,22],[nMW,nMZ],2,2,wf8(:,10),wf12(:,5))
  call Hloop_DV_C(ntryL,G0H96(1),0,wf8(:,10),G1H12(72),m3h8x12(:,923),heltab2x96(:,:,4705))
  Gcoeff(:)%j = (-(c(80)*M(3,:)%j)) * den(219)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4834),h0tab(:,4834),[41,22],[nMW,0],2,2,wf8(:,10),wf12(:,5))
  call Hloop_UW_V(ntryL,G0H96(1),0,wf8(:,10),41,G1H12(101),m3h8x12(:,924),heltab2x96(:,:,4706))
  Gcoeff(:)%j = (-(c(10)*M(3,:)%j)) * den(219)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4835),h0tab(:,4835),[41,22],[nMW,nMZ],2,2,wf8(:,10),wf12(:,5))
  call Hloop_UW_V(ntryL,G0H96(1),0,wf8(:,10),41,G1H12(91),m3h8x12(:,925),heltab2x96(:,:,4707))
  Gcoeff(:)%j = (c(103)*M(3,:)%j) * den(219)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4836),h0tab(:,4836),[41,22],[0,nMW],2,2,wf8(:,10),wf12(:,5))
  call Hloop_SV_V(ntryL,G0H96(1),wf8(:,10),G0H12(32),m3h8x12(:,926),heltab2x96(:,:,4708))
  Gcoeff(:)%j = (c(188)*M(3,:)%j) * den(219)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4837),h0tab(:,4837),[41,22],[nMZ,nMW],2,2,wf8(:,10),wf12(:,5))
  call Hloop_SV_V(ntryL,G0H96(1),wf8(:,10),G0H12(50),m3h8x12(:,927),heltab2x96(:,:,4709))
  Gcoeff(:)%j = (c(25)*M(3,:)%j) * den(219)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4838),h0tab(:,4838),[41,22],[nMW,nMH],2,2,wf8(:,10),wf12(:,5))
  call Hloop_SV_V(ntryL,G0H96(1),wf8(:,10),G0H12(33),m3h8x12(:,928),heltab2x96(:,:,4710))
  Gcoeff(:)%j = (c(285)*M(3,:)%j) * den(221)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4839),h0tab(:,4839),[41,22],[nME,0],2,2,wf8(:,10),wf12(:,31))
  call Hloop_QW_A(ntryL,G0H96(1),wf8(:,10),G0H12(157),m3h8x12(:,929),heltab2x96(:,:,4711))
  call Hloop_Q_A(ntryL,G0H12(157),41,nME,G1H12(83),n2h12(953))
  Gcoeff(:)%j = (c(287)*M(3,:)%j) * den(221)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4840),h0tab(:,4840),[41,22],[nMM,0],2,2,wf8(:,10),wf12(:,31))
  call Hloop_QW_A(ntryL,G0H96(1),wf8(:,10),G0H12(28),m3h8x12(:,930),heltab2x96(:,:,4712))
  call Hloop_Q_A(ntryL,G0H12(28),41,nMM,G1H12(100),n2h12(954))
  Gcoeff(:)%j = (c(286)*M(3,:)%j) * den(221)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4841),h0tab(:,4841),[41,22],[nML,0],2,2,wf8(:,10),wf12(:,31))
  call Hloop_QW_A(ntryL,G0H96(1),wf8(:,10),G0H12(29),m3h8x12(:,931),heltab2x96(:,:,4713))
  call Hloop_Q_A(ntryL,G0H12(29),41,nML,G1H12(165),n2h12(955))
  Gcoeff(:)%j = (-(c(277)*M(3,:)%j)) * den(221)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4842),h0tab(:,4842),[41,22],[nMB,nMT],2,2,wf8(:,10),wf12(:,31))
  call Hloop_QW_A(ntryL,G0H96(1),wf8(:,10),G0H12(30),m3h8x12(:,932),heltab2x96(:,:,4714))
  call Hloop_Q_A(ntryL,G0H12(30),41,nMB,G1H12(114),n2h12(956))
  Gcoeff(:)%j = (-(c(299)*M(3,:)%j)) * den(220)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4843),h0tab(:,4843),[41,22],[nME,0],2,2,wf8(:,10),wf12(:,32))
  call Hloop_QW_A(ntryL,G0H96(1),wf8(:,10),G0H12(31),m3h8x12(:,933),heltab2x96(:,:,4715))
  call Hloop_Q_A(ntryL,G0H12(31),41,nME,G1H12(149),n2h12(957))
  Gcoeff(:)%j = (-(c(301)*M(3,:)%j)) * den(220)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4844),h0tab(:,4844),[41,22],[nMM,0],2,2,wf8(:,10),wf12(:,32))
  call Hloop_QW_A(ntryL,G0H96(1),wf8(:,10),G0H12(54),m3h8x12(:,934),heltab2x96(:,:,4716))
  call Hloop_Q_A(ntryL,G0H12(54),41,nMM,G1H12(137),n2h12(958))
  Gcoeff(:)%j = (-(c(300)*M(3,:)%j)) * den(220)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4845),h0tab(:,4845),[41,22],[nML,0],2,2,wf8(:,10),wf12(:,32))
  call Hloop_QW_A(ntryL,G0H96(1),wf8(:,10),G0H12(52),m3h8x12(:,935),heltab2x96(:,:,4717))
  call Hloop_Q_A(ntryL,G0H12(52),41,nML,G1H12(127),n2h12(959))
  Gcoeff(:)%j = (c(298)*M(3,:)%j) * den(220)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4846),h0tab(:,4846),[41,22],[nMB,nMT],2,2,wf8(:,10),wf12(:,32))
  call Hloop_QW_A(ntryL,G0H96(1),wf8(:,10),G0H12(37),m3h8x12(:,936),heltab2x96(:,:,4718))
  call Hloop_Q_A(ntryL,G0H12(37),41,nMB,G1H12(6),n2h12(960))
  Gcoeff(:)%j = (-(c(71)*M(3,:)%j)) * den(221)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4847),h0tab(:,4847),[41,22],[nMW,nMH],2,2,wf8(:,10),wf12(:,31))
  call Hloop_TV_S(ntryL,G0H96(1),0,wf8(:,10),41,G1H12(443),m3h8x12(:,937),heltab2x96(:,:,4719))
  Gcoeff(:)%j = (c(137)*M(3,:)%j) * den(220)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4848),h0tab(:,4848),[41,22],[nMW,nMH],2,2,wf8(:,10),wf12(:,32))
  call Hloop_TV_S(ntryL,G0H96(1),0,wf8(:,10),41,G1H12(444),m3h8x12(:,938),heltab2x96(:,:,4720))
  Gcoeff(:)%j = (-(c(99)*M(3,:)%j)) * den(221)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4849),h0tab(:,4849),[41,22],[nMW,nMZ],2,2,wf8(:,10),wf12(:,31))
  call Hloop_CV_D(ntryL,G0H96(1),0,wf8(:,10),41,G1H12(445),m3h8x12(:,939),heltab2x96(:,:,4721))
  Gcoeff(:)%j = (-(c(186)*M(3,:)%j)) * den(221)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4850),h0tab(:,4850),[41,22],[nMW,0],2,2,wf8(:,10),wf12(:,31))
  call Hloop_DV_C(ntryL,G0H96(1),0,wf8(:,10),G1H12(454),m3h8x12(:,940),heltab2x96(:,:,4722))
  Gcoeff(:)%j = (c(209)*M(3,:)%j) * den(221)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4851),h0tab(:,4851),[41,22],[nMW,nMZ],2,2,wf8(:,10),wf12(:,31))
  call Hloop_DV_C(ntryL,G0H96(1),0,wf8(:,10),G1H12(455),m3h8x12(:,941),heltab2x96(:,:,4723))
  Gcoeff(:)%j = (c(140)*M(3,:)%j) * den(220)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4852),h0tab(:,4852),[41,22],[nMW,nMZ],2,2,wf8(:,10),wf12(:,32))
  call Hloop_CV_D(ntryL,G0H96(1),0,wf8(:,10),41,G1H12(452),m3h8x12(:,942),heltab2x96(:,:,4724))
  Gcoeff(:)%j = (c(3)*M(3,:)%j) * den(220)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4853),h0tab(:,4853),[41,22],[nMW,0],2,2,wf8(:,10),wf12(:,32))
  call Hloop_DV_C(ntryL,G0H96(1),0,wf8(:,10),G1H12(453),m3h8x12(:,943),heltab2x96(:,:,4725))
  Gcoeff(:)%j = (c(205)*M(3,:)%j) * den(220)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4854),h0tab(:,4854),[41,22],[nMW,nMZ],2,2,wf8(:,10),wf12(:,32))
  call Hloop_DV_C(ntryL,G0H96(1),0,wf8(:,10),G1H12(460),m3h8x12(:,944),heltab2x96(:,:,4726))
  Gcoeff(:)%j = (-(c(186)*M(3,:)%j)) * den(221)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4855),h0tab(:,4855),[41,22],[nMW,0],2,2,wf8(:,10),wf12(:,31))
  call Hloop_UW_V(ntryL,G0H96(1),0,wf8(:,10),41,G1H12(461),m3h8x12(:,945),heltab2x96(:,:,4727))
  Gcoeff(:)%j = (c(186)*M(3,:)%j) * den(221)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4856),h0tab(:,4856),[41,22],[nMW,nMZ],2,2,wf8(:,10),wf12(:,31))
  call Hloop_UW_V(ntryL,G0H96(1),0,wf8(:,10),41,G1H12(462),m3h8x12(:,946),heltab2x96(:,:,4728))
  Gcoeff(:)%j = (c(3)*M(3,:)%j) * den(220)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4857),h0tab(:,4857),[41,22],[nMW,0],2,2,wf8(:,10),wf12(:,32))
  call Hloop_UW_V(ntryL,G0H96(1),0,wf8(:,10),41,G1H12(463),m3h8x12(:,947),heltab2x96(:,:,4729))
  Gcoeff(:)%j = (-(c(3)*M(3,:)%j)) * den(220)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4858),h0tab(:,4858),[41,22],[nMW,nMZ],2,2,wf8(:,10),wf12(:,32))
  call Hloop_UW_V(ntryL,G0H96(1),0,wf8(:,10),41,G1H12(466),m3h8x12(:,948),heltab2x96(:,:,4730))
  Gcoeff(:)%j = (-(c(186)*M(3,:)%j)) * den(221)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4859),h0tab(:,4859),[41,22],[0,nMW],2,2,wf8(:,10),wf12(:,31))
  call Hloop_SV_V(ntryL,G0H96(1),wf8(:,10),G0H12(35),m3h8x12(:,949),heltab2x96(:,:,4731))
  Gcoeff(:)%j = (-(c(212)*M(3,:)%j)) * den(221)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4860),h0tab(:,4860),[41,22],[nMZ,nMW],2,2,wf8(:,10),wf12(:,31))
  call Hloop_SV_V(ntryL,G0H96(1),wf8(:,10),G0H12(56),m3h8x12(:,950),heltab2x96(:,:,4732))
  Gcoeff(:)%j = (-(c(99)*M(3,:)%j)) * den(221)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4861),h0tab(:,4861),[41,22],[nMW,nMH],2,2,wf8(:,10),wf12(:,31))
  call Hloop_SV_V(ntryL,G0H96(1),wf8(:,10),G0H12(53),m3h8x12(:,951),heltab2x96(:,:,4733))
  Gcoeff(:)%j = (c(3)*M(3,:)%j) * den(220)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4862),h0tab(:,4862),[41,22],[0,nMW],2,2,wf8(:,10),wf12(:,32))
  call Hloop_SV_V(ntryL,G0H96(1),wf8(:,10),G0H12(39),m3h8x12(:,952),heltab2x96(:,:,4734))
  Gcoeff(:)%j = (c(213)*M(3,:)%j) * den(220)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4863),h0tab(:,4863),[41,22],[nMZ,nMW],2,2,wf8(:,10),wf12(:,32))
  call Hloop_SV_V(ntryL,G0H96(1),wf8(:,10),G0H12(36),m3h8x12(:,953),heltab2x96(:,:,4735))
  Gcoeff(:)%j = (c(140)*M(3,:)%j) * den(220)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4864),h0tab(:,4864),[41,22],[nMW,nMH],2,2,wf8(:,10),wf12(:,32))
  call Hloop_SV_V(ntryL,G0H96(1),wf8(:,10),G0H12(55),m3h8x12(:,954),heltab2x96(:,:,4736))
  Gcoeff(:)%j = (-(c(276)*M(3,:)%j)) * den(221)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4865),h0tab(:,4865),[41,22],[nME,0],2,2,wf8(:,10),wf12(:,6))
  call Hloop_QW_A(ntryL,G0H96(1),wf8(:,10),G0H12(38),m3h8x12(:,955),heltab2x96(:,:,4737))
  call Hloop_Q_A(ntryL,G0H12(38),41,nME,G1H12(467),n2h12(961))
  Gcoeff(:)%j = (-(c(276)*M(3,:)%j)) * den(221)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4866),h0tab(:,4866),[41,22],[nMM,0],2,2,wf8(:,10),wf12(:,6))
  call Hloop_QW_A(ntryL,G0H96(1),wf8(:,10),G0H12(41),m3h8x12(:,956),heltab2x96(:,:,4738))
  call Hloop_Q_A(ntryL,G0H12(41),41,nMM,G1H12(245),n2h12(962))
  Gcoeff(:)%j = (-(c(276)*M(3,:)%j)) * den(221)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4867),h0tab(:,4867),[41,22],[nML,0],2,2,wf8(:,10),wf12(:,6))
  call Hloop_QW_A(ntryL,G0H96(1),wf8(:,10),G0H12(59),m3h8x12(:,957),heltab2x96(:,:,4739))
  call Hloop_Q_A(ntryL,G0H12(59),41,nML,G1H12(418),n2h12(963))
  Gcoeff(:)%j = (-(c(281)*M(3,:)%j)) * den(221)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4868),h0tab(:,4868),[41,22],[0,0],2,2,wf8(:,10),wf12(:,6))
  call Hloop_QW_A(ntryL,G0H96(1),wf8(:,10),G0H12(42),m3h8x12(:,958),heltab2x96(:,:,4740))
  call Hloop_Q_A(ntryL,G0H12(42),41,0,G1H12(417),n2h12(964))
  Gcoeff(:)%j = (-(c(277)*M(3,:)%j)) * den(221)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4869),h0tab(:,4869),[41,22],[nMB,nMT],2,2,wf8(:,10),wf12(:,6))
  call Hloop_QW_A(ntryL,G0H96(1),wf8(:,10),G0H12(48),m3h8x12(:,959),heltab2x96(:,:,4741))
  call Hloop_Q_A(ntryL,G0H12(48),41,nMB,G1H12(419),n2h12(965))
  Gcoeff(:)%j = (-(c(240)*M(3,:)%j)) * den(220)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4870),h0tab(:,4870),[41,22],[nME,0],2,2,wf8(:,10),wf12(:,7))
  call Hloop_QW_A(ntryL,G0H96(1),wf8(:,10),G0H12(66),m3h8x12(:,960),heltab2x96(:,:,4742))
  call Hloop_Q_A(ntryL,G0H12(66),41,nME,G1H12(422),n2h12(966))
  Gcoeff(:)%j = (-(c(240)*M(3,:)%j)) * den(220)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4871),h0tab(:,4871),[41,22],[nMM,0],2,2,wf8(:,10),wf12(:,7))
  call Hloop_QW_A(ntryL,G0H96(1),wf8(:,10),G0H12(67),m3h8x12(:,961),heltab2x96(:,:,4743))
  call Hloop_Q_A(ntryL,G0H12(67),41,nMM,G1H12(421),n2h12(967))
  Gcoeff(:)%j = (-(c(240)*M(3,:)%j)) * den(220)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4872),h0tab(:,4872),[41,22],[nML,0],2,2,wf8(:,10),wf12(:,7))
  call Hloop_QW_A(ntryL,G0H96(1),wf8(:,10),G0H12(68),m3h8x12(:,962),heltab2x96(:,:,4744))
  call Hloop_Q_A(ntryL,G0H12(68),41,nML,G1H12(470),n2h12(968))
  Gcoeff(:)%j = (-(c(242)*M(3,:)%j)) * den(220)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4873),h0tab(:,4873),[41,22],[0,0],2,2,wf8(:,10),wf12(:,7))
  call Hloop_QW_A(ntryL,G0H96(1),wf8(:,10),G0H12(69),m3h8x12(:,963),heltab2x96(:,:,4745))
  call Hloop_Q_A(ntryL,G0H12(69),41,0,G1H12(471),n2h12(969))
  Gcoeff(:)%j = (-(c(241)*M(3,:)%j)) * den(220)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4874),h0tab(:,4874),[41,22],[nMB,nMT],2,2,wf8(:,10),wf12(:,7))
  call Hloop_QW_A(ntryL,G0H96(1),wf8(:,10),G0H12(70),m3h8x12(:,964),heltab2x96(:,:,4746))
  call Hloop_Q_A(ntryL,G0H12(70),41,nMB,G1H12(473),n2h12(970))
  Gcoeff(:)%j = (-(c(65)*M(3,:)%j)) * den(221)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4875),h0tab(:,4875),[41,22],[nMW,nMH],2,2,wf8(:,10),wf12(:,6))
  call Hloop_TV_S(ntryL,G0H96(1),0,wf8(:,10),41,G1H12(425),m3h8x12(:,965),heltab2x96(:,:,4747))
  Gcoeff(:)%j = (-(c(65)*M(3,:)%j)) * den(221)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4876),h0tab(:,4876),[41,22],[nMW,nMZ],2,2,wf8(:,10),wf12(:,6))
  call Hloop_TV_S(ntryL,G0H96(1),0,wf8(:,10),41,G1H12(427),m3h8x12(:,966),heltab2x96(:,:,4748))
  Gcoeff(:)%j = (-(c(48)*M(3,:)%j)) * den(220)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4877),h0tab(:,4877),[41,22],[nMW,nMH],2,2,wf8(:,10),wf12(:,7))
  call Hloop_TV_S(ntryL,G0H96(1),0,wf8(:,10),41,G1H12(426),m3h8x12(:,967),heltab2x96(:,:,4749))
  Gcoeff(:)%j = (-(c(48)*M(3,:)%j)) * den(220)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4878),h0tab(:,4878),[41,22],[nMW,nMZ],2,2,wf8(:,10),wf12(:,7))
  call Hloop_TV_S(ntryL,G0H96(1),0,wf8(:,10),41,G1H12(430),m3h8x12(:,968),heltab2x96(:,:,4750))
  Gcoeff(:)%j = (-(c(154)*M(3,:)%j)) * den(221)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4879),h0tab(:,4879),[41,22],[nMW,0],2,2,wf8(:,10),wf12(:,6))
  call Hloop_CV_D(ntryL,G0H96(1),0,wf8(:,10),41,G1H12(432),m3h8x12(:,969),heltab2x96(:,:,4751))
  Gcoeff(:)%j = (-(c(69)*M(3,:)%j)) * den(221)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4880),h0tab(:,4880),[41,22],[nMW,nMZ],2,2,wf8(:,10),wf12(:,6))
  call Hloop_CV_D(ntryL,G0H96(1),0,wf8(:,10),41,G1H12(431),m3h8x12(:,970),heltab2x96(:,:,4752))
  Gcoeff(:)%j = (-(c(154)*M(3,:)%j)) * den(221)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4881),h0tab(:,4881),[41,22],[nMW,0],2,2,wf8(:,10),wf12(:,6))
  call Hloop_DV_C(ntryL,G0H96(1),0,wf8(:,10),G1H12(440),m3h8x12(:,971),heltab2x96(:,:,4753))
  Gcoeff(:)%j = (-(c(69)*M(3,:)%j)) * den(221)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4882),h0tab(:,4882),[41,22],[nMW,nMZ],2,2,wf8(:,10),wf12(:,6))
  call Hloop_DV_C(ntryL,G0H96(1),0,wf8(:,10),G1H12(441),m3h8x12(:,972),heltab2x96(:,:,4754))
  Gcoeff(:)%j = (-(c(131)*M(3,:)%j)) * den(220)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4883),h0tab(:,4883),[41,22],[nMW,0],2,2,wf8(:,10),wf12(:,7))
  call Hloop_CV_D(ntryL,G0H96(1),0,wf8(:,10),41,G1H12(442),m3h8x12(:,973),heltab2x96(:,:,4755))
  Gcoeff(:)%j = (-(c(50)*M(3,:)%j)) * den(220)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4884),h0tab(:,4884),[41,22],[nMW,nMZ],2,2,wf8(:,10),wf12(:,7))
  call Hloop_CV_D(ntryL,G0H96(1),0,wf8(:,10),41,G1H12(499),m3h8x12(:,974),heltab2x96(:,:,4756))
  Gcoeff(:)%j = (-(c(131)*M(3,:)%j)) * den(220)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4885),h0tab(:,4885),[41,22],[nMW,0],2,2,wf8(:,10),wf12(:,7))
  call Hloop_DV_C(ntryL,G0H96(1),0,wf8(:,10),G1H12(513),m3h8x12(:,975),heltab2x96(:,:,4757))
  Gcoeff(:)%j = (-(c(50)*M(3,:)%j)) * den(220)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4886),h0tab(:,4886),[41,22],[nMW,nMZ],2,2,wf8(:,10),wf12(:,7))
  call Hloop_DV_C(ntryL,G0H96(1),0,wf8(:,10),G1H12(514),m3h8x12(:,976),heltab2x96(:,:,4758))
  Gcoeff(:)%j = (c(154)*M(3,:)%j) * den(221)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4887),h0tab(:,4887),[41,22],[nMW,0],2,2,wf8(:,10),wf12(:,6))
  call Hloop_UW_V(ntryL,G0H96(1),0,wf8(:,10),41,G1H12(515),m3h8x12(:,977),heltab2x96(:,:,4759))
  Gcoeff(:)%j = (c(69)*M(3,:)%j) * den(221)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4888),h0tab(:,4888),[41,22],[nMW,nMZ],2,2,wf8(:,10),wf12(:,6))
  call Hloop_UW_V(ntryL,G0H96(1),0,wf8(:,10),41,G1H12(516),m3h8x12(:,978),heltab2x96(:,:,4760))
  Gcoeff(:)%j = (c(131)*M(3,:)%j) * den(220)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4889),h0tab(:,4889),[41,22],[nMW,0],2,2,wf8(:,10),wf12(:,7))
  call Hloop_UW_V(ntryL,G0H96(1),0,wf8(:,10),41,G1H12(517),m3h8x12(:,979),heltab2x96(:,:,4761))
  Gcoeff(:)%j = (c(50)*M(3,:)%j) * den(220)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4890),h0tab(:,4890),[41,22],[nMW,nMZ],2,2,wf8(:,10),wf12(:,7))
  call Hloop_UW_V(ntryL,G0H96(1),0,wf8(:,10),41,G1H12(518),m3h8x12(:,980),heltab2x96(:,:,4762))
  Gcoeff(:)%j = (-(c(186)*M(3,:)%j)) * den(221)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4891),h0tab(:,4891),[41,22],[0,nMW],2,2,wf8(:,10),wf12(:,6))
  call Hloop_SV_V(ntryL,G0H96(1),wf8(:,10),G0H12(71),m3h8x12(:,981),heltab2x96(:,:,4763))
  Gcoeff(:)%j = (-(c(191)*M(3,:)%j)) * den(221)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4892),h0tab(:,4892),[41,22],[nMZ,nMW],2,2,wf8(:,10),wf12(:,6))
  call Hloop_SV_V(ntryL,G0H96(1),wf8(:,10),G0H12(72),m3h8x12(:,982),heltab2x96(:,:,4764))
  Gcoeff(:)%j = (-(c(100)*M(3,:)%j)) * den(221)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4893),h0tab(:,4893),[41,22],[nMW,nMH],2,2,wf8(:,10),wf12(:,6))
  call Hloop_SV_V(ntryL,G0H96(1),wf8(:,10),G0H12(73),m3h8x12(:,983),heltab2x96(:,:,4765))
  Gcoeff(:)%j = (-(c(141)*M(3,:)%j)) * den(220)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4894),h0tab(:,4894),[41,22],[0,nMW],2,2,wf8(:,10),wf12(:,7))
  call Hloop_SV_V(ntryL,G0H96(1),wf8(:,10),G0H12(74),m3h8x12(:,984),heltab2x96(:,:,4766))
  Gcoeff(:)%j = (-(c(3)*M(3,:)%j)) * den(220)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4895),h0tab(:,4895),[41,22],[nMZ,nMW],2,2,wf8(:,10),wf12(:,7))
  call Hloop_SV_V(ntryL,G0H96(1),wf8(:,10),G0H12(75),m3h8x12(:,985),heltab2x96(:,:,4767))
  Gcoeff(:)%j = (-(c(62)*M(3,:)%j)) * den(220)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4896),h0tab(:,4896),[41,22],[nMW,nMH],2,2,wf8(:,10),wf12(:,7))
  call Hloop_SV_V(ntryL,G0H96(1),wf8(:,10),G0H12(63),m3h8x12(:,986),heltab2x96(:,:,4768))
  Gcoeff(:)%j = (-(c(215)*M(3,:)%j)) * den(442)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4897),h0tab(:,4897),[57,6],[nME,nME],2,2,wf24(:,92),wf4(:,7))
  call Hloop_QS_A(ntryL,G0H96(1),wf24(:,92),G0H4(25),ngH,m3h24x4(:,784),heltab2x96(:,:,4769))
  call Hloop_Q_A(ntryL,G0H4(25),57,nME,G1H4(23),n2h4(824))
  Gcoeff(:)%j = (-(c(217)*M(3,:)%j)) * den(442)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4898),h0tab(:,4898),[57,6],[nMM,nMM],2,2,wf24(:,92),wf4(:,7))
  call Hloop_QS_A(ntryL,G0H96(1),wf24(:,92),G0H4(1),ngH,m3h24x4(:,785),heltab2x96(:,:,4770))
  call Hloop_Q_A(ntryL,G0H4(1),57,nMM,G1H4(133),n2h4(825))
  Gcoeff(:)%j = (-(c(216)*M(3,:)%j)) * den(442)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4899),h0tab(:,4899),[57,6],[nML,nML],2,2,wf24(:,92),wf4(:,7))
  call Hloop_QS_A(ntryL,G0H96(1),wf24(:,92),G0H4(66),ngH,m3h24x4(:,786),heltab2x96(:,:,4771))
  call Hloop_Q_A(ntryL,G0H4(66),57,nML,G1H4(299),n2h4(826))
  Gcoeff(:)%j = (-(c(218)*M(3,:)%j)) * den(442)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4900),h0tab(:,4900),[57,6],[nMT,nMT],2,2,wf24(:,92),wf4(:,7))
  call Hloop_QS_A(ntryL,G0H96(1),wf24(:,92),G0H4(11),ngH,m3h24x4(:,787),heltab2x96(:,:,4772))
  call Hloop_Q_A(ntryL,G0H4(11),57,nMT,G1H4(121),n2h4(827))
  Gcoeff(:)%j = (-(c(214)*M(3,:)%j)) * den(442)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4901),h0tab(:,4901),[57,6],[nMB,nMB],2,2,wf24(:,92),wf4(:,7))
  call Hloop_QS_A(ntryL,G0H96(1),wf24(:,92),G0H4(117),ngH,m3h24x4(:,788),heltab2x96(:,:,4773))
  call Hloop_Q_A(ntryL,G0H4(117),57,nMB,G1H4(18),n2h4(828))
  Gcoeff(:)%j = (-(c(215)*M(3,:)%j)) * den(443)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4902),h0tab(:,4902),[57,6],[nME,nME],2,2,wf24(:,92),wf4(:,17))
  call Hloop_QS_A(ntryL,G0H96(1),wf24(:,92),G0H4(113),ngH,m3h24x4(:,789),heltab2x96(:,:,4774))
  call Hloop_Q_A(ntryL,G0H4(113),57,nME,G1H4(167),n2h4(829))
  Gcoeff(:)%j = (-(c(217)*M(3,:)%j)) * den(443)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4903),h0tab(:,4903),[57,6],[nMM,nMM],2,2,wf24(:,92),wf4(:,17))
  call Hloop_QS_A(ntryL,G0H96(1),wf24(:,92),G0H4(109),ngH,m3h24x4(:,790),heltab2x96(:,:,4775))
  call Hloop_Q_A(ntryL,G0H4(109),57,nMM,G1H4(307),n2h4(830))
  Gcoeff(:)%j = (-(c(216)*M(3,:)%j)) * den(443)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4904),h0tab(:,4904),[57,6],[nML,nML],2,2,wf24(:,92),wf4(:,17))
  call Hloop_QS_A(ntryL,G0H96(1),wf24(:,92),G0H4(105),ngH,m3h24x4(:,791),heltab2x96(:,:,4776))
  call Hloop_Q_A(ntryL,G0H4(105),57,nML,G1H4(268),n2h4(831))
  Gcoeff(:)%j = (c(218)*M(3,:)%j) * den(443)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4905),h0tab(:,4905),[57,6],[nMT,nMT],2,2,wf24(:,92),wf4(:,17))
  call Hloop_QS_A(ntryL,G0H96(1),wf24(:,92),G0H4(101),ngH,m3h24x4(:,792),heltab2x96(:,:,4777))
  call Hloop_Q_A(ntryL,G0H4(101),57,nMT,G1H4(49),n2h4(832))
  Gcoeff(:)%j = (-(c(214)*M(3,:)%j)) * den(443)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4906),h0tab(:,4906),[57,6],[nMB,nMB],2,2,wf24(:,92),wf4(:,17))
  call Hloop_QS_A(ntryL,G0H96(1),wf24(:,92),G0H4(97),ngH,m3h24x4(:,793),heltab2x96(:,:,4778))
  call Hloop_Q_A(ntryL,G0H4(97),57,nMB,G1H4(152),n2h4(833))
  Gcoeff(:)%j = (c(18)*M(3,:)%j) * den(442)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4907),h0tab(:,4907),[57,6],[nMH,nMH],2,2,wf24(:,92),wf4(:,7))
  call Hloop_SS_S(ntryL,G0H96(1),wf24(:,92),G0H4(93),m3h24x4(:,794),heltab2x96(:,:,4779))
  Gcoeff(:)%j = (c(16)*M(3,:)%j) * den(442)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4908),h0tab(:,4908),[57,6],[nMZ,nMZ],2,2,wf24(:,92),wf4(:,7))
  call Hloop_SS_S(ntryL,G0H96(1),wf24(:,92),G0H4(89),m3h24x4(:,795),heltab2x96(:,:,4780))
  Gcoeff(:)%j = (c(17)*M(3,:)%j) * den(442)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4909),h0tab(:,4909),[57,6],[nMW,nMW],2,2,wf24(:,92),wf4(:,7))
  call Hloop_SS_S(ntryL,G0H96(1),wf24(:,92),G0H4(85),m3h24x4(:,796),heltab2x96(:,:,4781))
  Gcoeff(:)%j = (-(c(26)*M(3,:)%j)) * den(442)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4910),h0tab(:,4910),[57,6],[nMZ,nMZ],2,2,wf24(:,92),wf4(:,7))
  call Hloop_SS_S(ntryL,G0H96(1),wf24(:,92),G0H4(123),m3h24x4(:,797),heltab2x96(:,:,4782))
  Gcoeff(:)%j = (-(c(24)*M(3,:)%j)) * den(442)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4911),h0tab(:,4911),[57,6],[nMW,nMW],2,2,wf24(:,92),wf4(:,7))
  call Hloop_SS_S(ntryL,G0H96(1),wf24(:,92),G0H4(78),m3h24x4(:,798),heltab2x96(:,:,4783))
  Gcoeff(:)%j = (-(c(24)*M(3,:)%j)) * den(442)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4912),h0tab(:,4912),[57,6],[nMW,nMW],2,2,wf24(:,92),wf4(:,7))
  call Hloop_SS_S(ntryL,G0H96(1),wf24(:,92),G0H4(76),m3h24x4(:,799),heltab2x96(:,:,4784))
  Gcoeff(:)%j = (-(c(24)*M(3,:)%j)) * den(443)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4913),h0tab(:,4913),[57,6],[nMW,nMW],2,2,wf24(:,92),wf4(:,17))
  call Hloop_SS_S(ntryL,G0H96(1),wf24(:,92),G0H4(33),m3h24x4(:,800),heltab2x96(:,:,4785))
  Gcoeff(:)%j = (c(24)*M(3,:)%j) * den(443)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4914),h0tab(:,4914),[57,6],[nMW,nMW],2,2,wf24(:,92),wf4(:,17))
  call Hloop_SS_S(ntryL,G0H96(1),wf24(:,92),G0H4(124),m3h24x4(:,801),heltab2x96(:,:,4786))
  Gcoeff(:)%j = (c(27)*M(3,:)%j) * den(442)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4915),h0tab(:,4915),[57,6],[nMZ,nMZ],2,2,wf24(:,92),wf4(:,7))
  call Hloop_VS_V(ntryL,G0H96(1),wf24(:,92),G0H4(25),m3h24x4(:,802),heltab2x96(:,:,4787))
  Gcoeff(:)%j = (c(25)*M(3,:)%j) * den(442)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4916),h0tab(:,4916),[57,6],[nMW,nMW],2,2,wf24(:,92),wf4(:,7))
  call Hloop_VS_V(ntryL,G0H96(1),wf24(:,92),G0H4(1),m3h24x4(:,803),heltab2x96(:,:,4788))
  Gcoeff(:)%j = (c(7)*M(3,:)%j) * den(442)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4917),h0tab(:,4917),[57,6],[nMZ,nMZ],2,2,wf24(:,92),wf4(:,7))
  call Hloop_VT_S(ntryL,G0H96(1),0,wf24(:,92),57,G1H4(243),m3h24x4(:,804),heltab2x96(:,:,4789))
  Gcoeff(:)%j = (c(4)*M(3,:)%j) * den(442)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4918),h0tab(:,4918),[57,6],[nMW,nMW],2,2,wf24(:,92),wf4(:,7))
  call Hloop_VT_S(ntryL,G0H96(1),0,wf24(:,92),57,G1H4(27),m3h24x4(:,805),heltab2x96(:,:,4790))
  Gcoeff(:)%j = (c(4)*M(3,:)%j) * den(442)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4919),h0tab(:,4919),[57,6],[nMW,nMW],2,2,wf24(:,92),wf4(:,7))
  call Hloop_VT_S(ntryL,G0H96(1),0,wf24(:,92),57,G1H4(94),m3h24x4(:,806),heltab2x96(:,:,4791))
  Gcoeff(:)%j = (-(c(4)*M(3,:)%j)) * den(443)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4920),h0tab(:,4920),[57,6],[nMW,nMW],2,2,wf24(:,92),wf4(:,17))
  call Hloop_VT_S(ntryL,G0H96(1),0,wf24(:,92),57,G1H4(171),m3h24x4(:,807),heltab2x96(:,:,4792))
  Gcoeff(:)%j = (c(4)*M(3,:)%j) * den(443)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4921),h0tab(:,4921),[57,6],[nMW,nMW],2,2,wf24(:,92),wf4(:,17))
  call Hloop_VT_S(ntryL,G0H96(1),0,wf24(:,92),57,G1H4(158),m3h24x4(:,808),heltab2x96(:,:,4793))
  Gcoeff(:)%j = (-(c(262)*M(3,:)%j)) * den(444)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4922),h0tab(:,4922),[57,6],[nME,nME],2,2,wf24(:,93),wf4(:,7))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,93),G0H4(66),m3h24x4(:,809),heltab2x96(:,:,4794))
  call Hloop_Q_A(ntryL,G0H4(66),57,nME,G1H4(126),n2h4(834))
  Gcoeff(:)%j = (-(c(268)*M(3,:)%j)) * den(444)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4923),h0tab(:,4923),[57,6],[nMM,nMM],2,2,wf24(:,93),wf4(:,7))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,93),G0H4(11),m3h24x4(:,810),heltab2x96(:,:,4795))
  call Hloop_Q_A(ntryL,G0H4(11),57,nMM,G1H4(217),n2h4(835))
  Gcoeff(:)%j = (-(c(265)*M(3,:)%j)) * den(444)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4924),h0tab(:,4924),[57,6],[nML,nML],2,2,wf24(:,93),wf4(:,7))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,93),G0H4(117),m3h24x4(:,811),heltab2x96(:,:,4796))
  call Hloop_Q_A(ntryL,G0H4(117),57,nML,G1H4(181),n2h4(836))
  Gcoeff(:)%j = (c(271)*M(3,:)%j) * den(444)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4925),h0tab(:,4925),[57,6],[nMT,nMT],2,2,wf24(:,93),wf4(:,7))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,93),G0H4(113),m3h24x4(:,812),heltab2x96(:,:,4797))
  call Hloop_Q_A(ntryL,G0H4(113),57,nMT,G1H4(255),n2h4(837))
  Gcoeff(:)%j = (-(c(257)*M(3,:)%j)) * den(444)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4926),h0tab(:,4926),[57,6],[nMB,nMB],2,2,wf24(:,93),wf4(:,7))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,93),G0H4(109),m3h24x4(:,813),heltab2x96(:,:,4798))
  call Hloop_Q_A(ntryL,G0H4(109),57,nMB,G1H4(184),n2h4(838))
  Gcoeff(:)%j = (c(236)*M(3,:)%j) * den(445)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4927),h0tab(:,4927),[57,6],[nME,nME],2,2,wf24(:,93),wf4(:,7))
  call Hloop_QZ_A(ntryL,G0H96(1),wf24(:,93),G0H4(105),ngZl,m3h24x4(:,814),heltab2x96(:,:,4799))
  call Hloop_Q_A(ntryL,G0H4(105),57,nME,G1H4(34),n2h4(839))
  Gcoeff(:)%j = (c(238)*M(3,:)%j) * den(445)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4928),h0tab(:,4928),[57,6],[nMM,nMM],2,2,wf24(:,93),wf4(:,7))
  call Hloop_QZ_A(ntryL,G0H96(1),wf24(:,93),G0H4(101),ngZl,m3h24x4(:,815),heltab2x96(:,:,4800))
  call Hloop_Q_A(ntryL,G0H4(101),57,nMM,G1H4(226),n2h4(840))
  Gcoeff(:)%j = (c(237)*M(3,:)%j) * den(445)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4929),h0tab(:,4929),[57,6],[nML,nML],2,2,wf24(:,93),wf4(:,7))
  call Hloop_QZ_A(ntryL,G0H96(1),wf24(:,93),G0H4(97),ngZl,m3h24x4(:,816),heltab2x96(:,:,4801))
  call Hloop_Q_A(ntryL,G0H4(97),57,nML,G1H4(385),n2h4(841))
  Gcoeff(:)%j = (c(239)*M(3,:)%j) * den(445)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4930),h0tab(:,4930),[57,6],[nMT,nMT],2,2,wf24(:,93),wf4(:,7))
  call Hloop_QZ_A(ntryL,G0H96(1),wf24(:,93),G0H4(66),ngZu,m3h24x4(:,817),heltab2x96(:,:,4802))
  call Hloop_Q_A(ntryL,G0H4(66),57,nMT,G1H4(377),n2h4(842))
  Gcoeff(:)%j = (c(235)*M(3,:)%j) * den(445)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4931),h0tab(:,4931),[57,6],[nMB,nMB],2,2,wf24(:,93),wf4(:,7))
  call Hloop_QZ_A(ntryL,G0H96(1),wf24(:,93),G0H4(11),ngZd,m3h24x4(:,818),heltab2x96(:,:,4803))
  call Hloop_Q_A(ntryL,G0H4(11),57,nMB,G1H4(354),n2h4(843))
  Gcoeff(:)%j = (-(c(262)*M(3,:)%j)) * den(446)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4932),h0tab(:,4932),[57,6],[nME,nME],2,2,wf24(:,93),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,93),G0H4(117),m3h24x4(:,819),heltab2x96(:,:,4804))
  call Hloop_Q_A(ntryL,G0H4(117),57,nME,G1H4(251),n2h4(844))
  Gcoeff(:)%j = (-(c(268)*M(3,:)%j)) * den(446)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4933),h0tab(:,4933),[57,6],[nMM,nMM],2,2,wf24(:,93),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,93),G0H4(113),m3h24x4(:,820),heltab2x96(:,:,4805))
  call Hloop_Q_A(ntryL,G0H4(113),57,nMM,G1H4(9),n2h4(845))
  Gcoeff(:)%j = (-(c(265)*M(3,:)%j)) * den(446)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4934),h0tab(:,4934),[57,6],[nML,nML],2,2,wf24(:,93),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,93),G0H4(109),m3h24x4(:,821),heltab2x96(:,:,4806))
  call Hloop_Q_A(ntryL,G0H4(109),57,nML,G1H4(270),n2h4(846))
  Gcoeff(:)%j = (-(c(271)*M(3,:)%j)) * den(446)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4935),h0tab(:,4935),[57,6],[nMT,nMT],2,2,wf24(:,93),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,93),G0H4(105),m3h24x4(:,822),heltab2x96(:,:,4807))
  call Hloop_Q_A(ntryL,G0H4(105),57,nMT,G1H4(370),n2h4(847))
  Gcoeff(:)%j = (-(c(257)*M(3,:)%j)) * den(446)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4936),h0tab(:,4936),[57,6],[nMB,nMB],2,2,wf24(:,93),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,93),G0H4(101),m3h24x4(:,823),heltab2x96(:,:,4808))
  call Hloop_Q_A(ntryL,G0H4(101),57,nMB,G1H4(286),n2h4(848))
  Gcoeff(:)%j = (c(236)*M(3,:)%j) * den(447)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4937),h0tab(:,4937),[57,6],[nME,nME],2,2,wf24(:,93),wf4(:,17))
  call Hloop_QZ_A(ntryL,G0H96(1),wf24(:,93),G0H4(97),ngZl,m3h24x4(:,824),heltab2x96(:,:,4809))
  call Hloop_Q_A(ntryL,G0H4(97),57,nME,G1H4(186),n2h4(849))
  Gcoeff(:)%j = (c(238)*M(3,:)%j) * den(447)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4938),h0tab(:,4938),[57,6],[nMM,nMM],2,2,wf24(:,93),wf4(:,17))
  call Hloop_QZ_A(ntryL,G0H96(1),wf24(:,93),G0H4(66),ngZl,m3h24x4(:,825),heltab2x96(:,:,4810))
  call Hloop_Q_A(ntryL,G0H4(66),57,nMM,G1H4(292),n2h4(850))
  Gcoeff(:)%j = (c(237)*M(3,:)%j) * den(447)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4939),h0tab(:,4939),[57,6],[nML,nML],2,2,wf24(:,93),wf4(:,17))
  call Hloop_QZ_A(ntryL,G0H96(1),wf24(:,93),G0H4(11),ngZl,m3h24x4(:,826),heltab2x96(:,:,4811))
  call Hloop_Q_A(ntryL,G0H4(11),57,nML,G1H4(172),n2h4(851))
  Gcoeff(:)%j = (-(c(239)*M(3,:)%j)) * den(447)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4940),h0tab(:,4940),[57,6],[nMT,nMT],2,2,wf24(:,93),wf4(:,17))
  call Hloop_QZ_A(ntryL,G0H96(1),wf24(:,93),G0H4(117),ngZu,m3h24x4(:,827),heltab2x96(:,:,4812))
  call Hloop_Q_A(ntryL,G0H4(117),57,nMT,G1H4(111),n2h4(852))
  Gcoeff(:)%j = (c(235)*M(3,:)%j) * den(447)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4941),h0tab(:,4941),[57,6],[nMB,nMB],2,2,wf24(:,93),wf4(:,17))
  call Hloop_QZ_A(ntryL,G0H96(1),wf24(:,93),G0H4(113),ngZd,m3h24x4(:,828),heltab2x96(:,:,4813))
  call Hloop_Q_A(ntryL,G0H4(113),57,nMB,G1H4(136),n2h4(853))
  Gcoeff(:)%j = (-(c(91)*M(3,:)%j)) * den(444)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4942),h0tab(:,4942),[57,6],[nMW,nMW],2,2,wf24(:,93),wf4(:,7))
  call Hloop_TV_S(ntryL,G0H96(1),0,wf24(:,93),57,G1H4(138),m3h24x4(:,829),heltab2x96(:,:,4814))
  Gcoeff(:)%j = (c(194)*M(3,:)%j) * den(445)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4943),h0tab(:,4943),[57,6],[nMW,nMW],2,2,wf24(:,93),wf4(:,7))
  call Hloop_TV_S(ntryL,G0H96(1),0,wf24(:,93),57,G1H4(381),m3h24x4(:,830),heltab2x96(:,:,4815))
  Gcoeff(:)%j = (-(c(14)*M(3,:)%j)) * den(447)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4944),h0tab(:,4944),[57,6],[nMH,nMZ],2,2,wf24(:,93),wf4(:,17))
  call Hloop_SV_T(ntryL,G0H96(1),0,wf24(:,93),57,G1H4(376),m3h24x4(:,831),heltab2x96(:,:,4816))
  Gcoeff(:)%j = (-(c(78)*M(3,:)%j)) * den(444)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4945),h0tab(:,4945),[57,6],[nMW,nMW],2,2,wf24(:,93),wf4(:,7))
  call Hloop_CV_D(ntryL,G0H96(1),0,wf24(:,93),57,G1H4(85),m3h24x4(:,832),heltab2x96(:,:,4817))
  Gcoeff(:)%j = (c(78)*M(3,:)%j) * den(444)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4946),h0tab(:,4946),[57,6],[nMW,nMW],2,2,wf24(:,93),wf4(:,7))
  call Hloop_CV_D(ntryL,G0H96(1),0,wf24(:,93),57,G1H4(477),m3h24x4(:,833),heltab2x96(:,:,4818))
  Gcoeff(:)%j = (-(c(9)*M(3,:)%j)) * den(445)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4947),h0tab(:,4947),[57,6],[nMW,nMW],2,2,wf24(:,93),wf4(:,7))
  call Hloop_CV_D(ntryL,G0H96(1),0,wf24(:,93),57,G1H4(389),m3h24x4(:,834),heltab2x96(:,:,4819))
  Gcoeff(:)%j = (c(9)*M(3,:)%j) * den(445)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4948),h0tab(:,4948),[57,6],[nMW,nMW],2,2,wf24(:,93),wf4(:,7))
  call Hloop_CV_D(ntryL,G0H96(1),0,wf24(:,93),57,G1H4(384),m3h24x4(:,835),heltab2x96(:,:,4820))
  Gcoeff(:)%j = (-(c(78)*M(3,:)%j)) * den(446)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4949),h0tab(:,4949),[57,6],[nMW,nMW],2,2,wf24(:,93),wf4(:,17))
  call Hloop_CV_D(ntryL,G0H96(1),0,wf24(:,93),57,G1H4(128),m3h24x4(:,836),heltab2x96(:,:,4821))
  Gcoeff(:)%j = (-(c(78)*M(3,:)%j)) * den(446)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4950),h0tab(:,4950),[57,6],[nMW,nMW],2,2,wf24(:,93),wf4(:,17))
  call Hloop_CV_D(ntryL,G0H96(1),0,wf24(:,93),57,G1H4(25),m3h24x4(:,837),heltab2x96(:,:,4822))
  Gcoeff(:)%j = (-(c(9)*M(3,:)%j)) * den(447)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4951),h0tab(:,4951),[57,6],[nMW,nMW],2,2,wf24(:,93),wf4(:,17))
  call Hloop_CV_D(ntryL,G0H96(1),0,wf24(:,93),57,G1H4(61),m3h24x4(:,838),heltab2x96(:,:,4823))
  Gcoeff(:)%j = (-(c(9)*M(3,:)%j)) * den(447)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4952),h0tab(:,4952),[57,6],[nMW,nMW],2,2,wf24(:,93),wf4(:,17))
  call Hloop_CV_D(ntryL,G0H96(1),0,wf24(:,93),57,G1H4(303),m3h24x4(:,839),heltab2x96(:,:,4824))
  Gcoeff(:)%j = (-(c(80)*M(3,:)%j)) * den(444)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4953),h0tab(:,4953),[57,6],[nMW,nMW],2,2,wf24(:,93),wf4(:,7))
  call Hloop_UV_W(ntryL,G0H96(1),0,wf24(:,93),57,G1H4(321),m3h24x4(:,840),heltab2x96(:,:,4825))
  Gcoeff(:)%j = (-(c(10)*M(3,:)%j)) * den(445)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4954),h0tab(:,4954),[57,6],[nMW,nMW],2,2,wf24(:,93),wf4(:,7))
  call Hloop_UV_W(ntryL,G0H96(1),0,wf24(:,93),57,G1H4(63),m3h24x4(:,841),heltab2x96(:,:,4826))
  Gcoeff(:)%j = (c(78)*M(3,:)%j) * den(444)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4955),h0tab(:,4955),[57,6],[nMW,nMW],2,2,wf24(:,93),wf4(:,7))
  call Hloop_VV_S(ntryL,G0H96(1),wf24(:,93),G0H4(109),m3h24x4(:,842),heltab2x96(:,:,4827))
  Gcoeff(:)%j = (-(c(78)*M(3,:)%j)) * den(444)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4956),h0tab(:,4956),[57,6],[nMW,nMW],2,2,wf24(:,93),wf4(:,7))
  call Hloop_VV_S(ntryL,G0H96(1),wf24(:,93),G0H4(105),m3h24x4(:,843),heltab2x96(:,:,4828))
  Gcoeff(:)%j = (-(c(78)*M(3,:)%j)) * den(445)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4957),h0tab(:,4957),[57,6],[nMW,nMW],2,2,wf24(:,93),wf4(:,7))
  call Hloop_VV_S(ntryL,G0H96(1),wf24(:,93),G0H4(101),m3h24x4(:,844),heltab2x96(:,:,4829))
  Gcoeff(:)%j = (c(78)*M(3,:)%j) * den(445)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4958),h0tab(:,4958),[57,6],[nMW,nMW],2,2,wf24(:,93),wf4(:,7))
  call Hloop_VV_S(ntryL,G0H96(1),wf24(:,93),G0H4(97),m3h24x4(:,845),heltab2x96(:,:,4830))
  Gcoeff(:)%j = (-(c(78)*M(3,:)%j)) * den(446)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4959),h0tab(:,4959),[57,6],[nMW,nMW],2,2,wf24(:,93),wf4(:,17))
  call Hloop_VV_S(ntryL,G0H96(1),wf24(:,93),G0H4(66),m3h24x4(:,846),heltab2x96(:,:,4831))
  Gcoeff(:)%j = (-(c(78)*M(3,:)%j)) * den(446)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4960),h0tab(:,4960),[57,6],[nMW,nMW],2,2,wf24(:,93),wf4(:,17))
  call Hloop_VV_S(ntryL,G0H96(1),wf24(:,93),G0H4(11),m3h24x4(:,847),heltab2x96(:,:,4832))
  Gcoeff(:)%j = (-(c(8)*M(3,:)%j)) * den(447)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4961),h0tab(:,4961),[57,6],[nMH,nMZ],2,2,wf24(:,93),wf4(:,17))
  call Hloop_VV_S(ntryL,G0H96(1),wf24(:,93),G0H4(117),m3h24x4(:,848),heltab2x96(:,:,4833))
  Gcoeff(:)%j = (c(78)*M(3,:)%j) * den(447)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4962),h0tab(:,4962),[57,6],[nMW,nMW],2,2,wf24(:,93),wf4(:,17))
  call Hloop_VV_S(ntryL,G0H96(1),wf24(:,93),G0H4(113),m3h24x4(:,849),heltab2x96(:,:,4834))
  Gcoeff(:)%j = (c(78)*M(3,:)%j) * den(447)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4963),h0tab(:,4963),[57,6],[nMW,nMW],2,2,wf24(:,93),wf4(:,17))
  call Hloop_VV_S(ntryL,G0H96(1),wf24(:,93),G0H4(135),m3h24x4(:,850),heltab2x96(:,:,4835))
  Gcoeff(:)%j = (-(c(246)*M(3,:)%j)) * den(448)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4964),h0tab(:,4964),[57,6],[nME,nME],2,2,wf24(:,92),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H96(1),wf24(:,92),G0H4(136),ngH,m3h24x4(:,851),heltab2x96(:,:,4836))
  call Hloop_Q_A(ntryL,G0H4(136),57,nME,G1H4(90),n2h4(854))
  Gcoeff(:)%j = (-(c(250)*M(3,:)%j)) * den(448)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4965),h0tab(:,4965),[57,6],[nMM,nMM],2,2,wf24(:,92),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H96(1),wf24(:,92),G0H4(136),ngH,m3h24x4(:,852),heltab2x96(:,:,4837))
  call Hloop_Q_A(ntryL,G0H4(136),57,nMM,G1H4(174),n2h4(855))
  Gcoeff(:)%j = (-(c(248)*M(3,:)%j)) * den(448)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4966),h0tab(:,4966),[57,6],[nML,nML],2,2,wf24(:,92),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H96(1),wf24(:,92),G0H4(136),ngH,m3h24x4(:,853),heltab2x96(:,:,4838))
  call Hloop_Q_A(ntryL,G0H4(136),57,nML,G1H4(12),n2h4(856))
  Gcoeff(:)%j = (c(252)*M(3,:)%j) * den(448)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4967),h0tab(:,4967),[57,6],[nMT,nMT],2,2,wf24(:,92),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H96(1),wf24(:,92),G0H4(136),ngH,m3h24x4(:,854),heltab2x96(:,:,4839))
  call Hloop_Q_A(ntryL,G0H4(136),57,nMT,G1H4(37),n2h4(857))
  Gcoeff(:)%j = (-(c(243)*M(3,:)%j)) * den(448)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4968),h0tab(:,4968),[57,6],[nMB,nMB],2,2,wf24(:,92),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H96(1),wf24(:,92),G0H4(136),ngH,m3h24x4(:,855),heltab2x96(:,:,4840))
  call Hloop_Q_A(ntryL,G0H4(136),57,nMB,G1H4(67),n2h4(858))
  Gcoeff(:)%j = (c(247)*M(3,:)%j) * den(443)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4969),h0tab(:,4969),[57,6],[nME,nME],2,2,wf24(:,92),wf4(:,4))
  call Hloop_QS_A(ntryL,G0H96(1),wf24(:,92),G0H4(136),ngH,m3h24x4(:,856),heltab2x96(:,:,4841))
  call Hloop_Q_A(ntryL,G0H4(136),57,nME,G1H4(16),n2h4(859))
  Gcoeff(:)%j = (c(251)*M(3,:)%j) * den(443)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4970),h0tab(:,4970),[57,6],[nMM,nMM],2,2,wf24(:,92),wf4(:,4))
  call Hloop_QS_A(ntryL,G0H96(1),wf24(:,92),G0H4(136),ngH,m3h24x4(:,857),heltab2x96(:,:,4842))
  call Hloop_Q_A(ntryL,G0H4(136),57,nMM,G1H4(261),n2h4(860))
  Gcoeff(:)%j = (c(249)*M(3,:)%j) * den(443)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4971),h0tab(:,4971),[57,6],[nML,nML],2,2,wf24(:,92),wf4(:,4))
  call Hloop_QS_A(ntryL,G0H96(1),wf24(:,92),G0H4(136),ngH,m3h24x4(:,858),heltab2x96(:,:,4843))
  call Hloop_Q_A(ntryL,G0H4(136),57,nML,G1H4(211),n2h4(861))
  Gcoeff(:)%j = (c(253)*M(3,:)%j) * den(443)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4972),h0tab(:,4972),[57,6],[nMT,nMT],2,2,wf24(:,92),wf4(:,4))
  call Hloop_QS_A(ntryL,G0H96(1),wf24(:,92),G0H4(136),ngH,m3h24x4(:,859),heltab2x96(:,:,4844))
  call Hloop_Q_A(ntryL,G0H4(136),57,nMT,G1H4(197),n2h4(862))
  Gcoeff(:)%j = (c(244)*M(3,:)%j) * den(443)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4973),h0tab(:,4973),[57,6],[nMB,nMB],2,2,wf24(:,92),wf4(:,4))
  call Hloop_QS_A(ntryL,G0H96(1),wf24(:,92),G0H4(136),ngH,m3h24x4(:,860),heltab2x96(:,:,4845))
  call Hloop_Q_A(ntryL,G0H4(136),57,nMB,G1H4(281),n2h4(863))
  Gcoeff(:)%j = (-(c(72)*M(3,:)%j)) * den(448)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4974),h0tab(:,4974),[57,6],[nMW,nMW],2,2,wf24(:,92),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H96(1),wf24(:,92),G0H4(136),m3h24x4(:,861),heltab2x96(:,:,4846))
  Gcoeff(:)%j = (c(203)*M(3,:)%j) * den(443)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4975),h0tab(:,4975),[57,6],[nMW,nMW],2,2,wf24(:,92),wf4(:,4))
  call Hloop_SS_S(ntryL,G0H96(1),wf24(:,92),G0H4(137),m3h24x4(:,862),heltab2x96(:,:,4847))
  Gcoeff(:)%j = (-(c(99)*M(3,:)%j)) * den(448)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4976),h0tab(:,4976),[57,6],[nMW,nMW],2,2,wf24(:,92),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H96(1),wf24(:,92),G0H4(138),m3h24x4(:,863),heltab2x96(:,:,4848))
  Gcoeff(:)%j = (c(99)*M(3,:)%j) * den(448)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4977),h0tab(:,4977),[57,6],[nMW,nMW],2,2,wf24(:,92),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H96(1),wf24(:,92),G0H4(139),m3h24x4(:,864),heltab2x96(:,:,4849))
  Gcoeff(:)%j = (-(c(61)*M(3,:)%j)) * den(443)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4978),h0tab(:,4978),[57,6],[nMW,nMW],2,2,wf24(:,92),wf4(:,4))
  call Hloop_SS_S(ntryL,G0H96(1),wf24(:,92),G0H4(140),m3h24x4(:,865),heltab2x96(:,:,4850))
  Gcoeff(:)%j = (c(61)*M(3,:)%j) * den(443)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4979),h0tab(:,4979),[57,6],[nMW,nMW],2,2,wf24(:,92),wf4(:,4))
  call Hloop_SS_S(ntryL,G0H96(1),wf24(:,92),G0H4(141),m3h24x4(:,866),heltab2x96(:,:,4851))
  Gcoeff(:)%j = (-(c(100)*M(3,:)%j)) * den(448)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4980),h0tab(:,4980),[57,6],[nMW,nMW],2,2,wf24(:,92),wf4(:,1))
  call Hloop_VS_V(ntryL,G0H96(1),wf24(:,92),G0H4(142),m3h24x4(:,867),heltab2x96(:,:,4852))
  Gcoeff(:)%j = (-(c(62)*M(3,:)%j)) * den(443)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4981),h0tab(:,4981),[57,6],[nMW,nMW],2,2,wf24(:,92),wf4(:,4))
  call Hloop_VS_V(ntryL,G0H96(1),wf24(:,92),G0H4(143),m3h24x4(:,868),heltab2x96(:,:,4853))
  Gcoeff(:)%j = (-(c(99)*M(3,:)%j)) * den(448)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4982),h0tab(:,4982),[57,6],[nMW,nMW],2,2,wf24(:,92),wf4(:,1))
  call Hloop_VT_S(ntryL,G0H96(1),0,wf24(:,92),57,G1H4(259),m3h24x4(:,869),heltab2x96(:,:,4854))
  Gcoeff(:)%j = (c(99)*M(3,:)%j) * den(448)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4983),h0tab(:,4983),[57,6],[nMW,nMW],2,2,wf24(:,92),wf4(:,1))
  call Hloop_VT_S(ntryL,G0H96(1),0,wf24(:,92),57,G1H4(163),m3h24x4(:,870),heltab2x96(:,:,4855))
  Gcoeff(:)%j = (c(140)*M(3,:)%j) * den(443)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4984),h0tab(:,4984),[57,6],[nMW,nMW],2,2,wf24(:,92),wf4(:,4))
  call Hloop_VT_S(ntryL,G0H96(1),0,wf24(:,92),57,G1H4(337),m3h24x4(:,871),heltab2x96(:,:,4856))
  Gcoeff(:)%j = (-(c(140)*M(3,:)%j)) * den(443)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4985),h0tab(:,4985),[57,6],[nMW,nMW],2,2,wf24(:,92),wf4(:,4))
  call Hloop_VT_S(ntryL,G0H96(1),0,wf24(:,92),57,G1H4(185),m3h24x4(:,872),heltab2x96(:,:,4857))
  Gcoeff(:)%j = (-(c(318)*M(3,:)%j)) * den(449)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4986),h0tab(:,4986),[57,6],[nME,nME],2,2,wf24(:,93),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,93),G0H4(144),m3h24x4(:,873),heltab2x96(:,:,4858))
  call Hloop_Q_A(ntryL,G0H4(144),57,nME,G1H4(96),n2h4(864))
  Gcoeff(:)%j = (-(c(318)*M(3,:)%j)) * den(449)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4987),h0tab(:,4987),[57,6],[nMM,nMM],2,2,wf24(:,93),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,93),G0H4(144),m3h24x4(:,874),heltab2x96(:,:,4859))
  call Hloop_Q_A(ntryL,G0H4(144),57,nMM,G1H4(358),n2h4(865))
  Gcoeff(:)%j = (-(c(318)*M(3,:)%j)) * den(449)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4988),h0tab(:,4988),[57,6],[nML,nML],2,2,wf24(:,93),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,93),G0H4(144),m3h24x4(:,875),heltab2x96(:,:,4860))
  call Hloop_Q_A(ntryL,G0H4(144),57,nML,G1H4(353),n2h4(866))
  Gcoeff(:)%j = (-(c(317)*M(3,:)%j)) * den(449)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4989),h0tab(:,4989),[57,6],[0,0],2,2,wf24(:,93),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,93),G0H4(144),m3h24x4(:,876),heltab2x96(:,:,4861))
  call Hloop_Q_A(ntryL,G0H4(144),57,0,G1H4(372),n2h4(867))
  Gcoeff(:)%j = (-(c(311)*M(3,:)%j)) * den(449)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4990),h0tab(:,4990),[57,6],[nMT,nMT],2,2,wf24(:,93),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,93),G0H4(144),m3h24x4(:,877),heltab2x96(:,:,4862))
  call Hloop_Q_A(ntryL,G0H4(144),57,nMT,G1H4(369),n2h4(868))
  Gcoeff(:)%j = (-(c(307)*M(3,:)%j)) * den(449)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4991),h0tab(:,4991),[57,6],[0,0],2,2,wf24(:,93),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,93),G0H4(144),m3h24x4(:,878),heltab2x96(:,:,4863))
  call Hloop_Q_A(ntryL,G0H4(144),57,0,G1H4(366),n2h4(869))
  Gcoeff(:)%j = (-(c(304)*M(3,:)%j)) * den(449)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4992),h0tab(:,4992),[57,6],[nMB,nMB],2,2,wf24(:,93),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,93),G0H4(144),m3h24x4(:,879),heltab2x96(:,:,4864))
  call Hloop_Q_A(ntryL,G0H4(144),57,nMB,G1H4(361),n2h4(870))
  Gcoeff(:)%j = (c(290)*M(3,:)%j) * den(450)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4993),h0tab(:,4993),[57,6],[nME,nME],2,2,wf24(:,93),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H96(1),wf24(:,93),G0H4(144),ngZl,m3h24x4(:,880),heltab2x96(:,:,4865))
  call Hloop_Q_A(ntryL,G0H4(144),57,nME,G1H4(156),n2h4(871))
  Gcoeff(:)%j = (c(290)*M(3,:)%j) * den(450)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4994),h0tab(:,4994),[57,6],[nMM,nMM],2,2,wf24(:,93),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H96(1),wf24(:,93),G0H4(144),ngZl,m3h24x4(:,881),heltab2x96(:,:,4866))
  call Hloop_Q_A(ntryL,G0H4(144),57,nMM,G1H4(406),n2h4(872))
  Gcoeff(:)%j = (c(290)*M(3,:)%j) * den(450)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4995),h0tab(:,4995),[57,6],[nML,nML],2,2,wf24(:,93),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H96(1),wf24(:,93),G0H4(144),ngZl,m3h24x4(:,882),heltab2x96(:,:,4867))
  call Hloop_Q_A(ntryL,G0H4(144),57,nML,G1H4(434),n2h4(873))
  Gcoeff(:)%j = (-(c(291)*M(3,:)%j)) * den(450)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4996),h0tab(:,4996),[57,6],[0,0],2,2,wf24(:,93),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H96(1),wf24(:,93),G0H4(144),ngZu,m3h24x4(:,883),heltab2x96(:,:,4868))
  call Hloop_Q_A(ntryL,G0H4(144),57,0,G1H4(439),n2h4(874))
  Gcoeff(:)%j = (-(c(289)*M(3,:)%j)) * den(450)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4997),h0tab(:,4997),[57,6],[nMT,nMT],2,2,wf24(:,93),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H96(1),wf24(:,93),G0H4(144),ngZu,m3h24x4(:,884),heltab2x96(:,:,4869))
  call Hloop_Q_A(ntryL,G0H4(144),57,nMT,G1H4(345),n2h4(875))
  Gcoeff(:)%j = (c(289)*M(3,:)%j) * den(450)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4998),h0tab(:,4998),[57,6],[0,0],2,2,wf24(:,93),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H96(1),wf24(:,93),G0H4(144),ngZd,m3h24x4(:,885),heltab2x96(:,:,4870))
  call Hloop_Q_A(ntryL,G0H4(144),57,0,G1H4(204),n2h4(876))
  Gcoeff(:)%j = (c(288)*M(3,:)%j) * den(450)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4999),h0tab(:,4999),[57,6],[nMB,nMB],2,2,wf24(:,93),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H96(1),wf24(:,93),G0H4(144),ngZd,m3h24x4(:,886),heltab2x96(:,:,4871))
  call Hloop_Q_A(ntryL,G0H4(144),57,nMB,G1H4(30),n2h4(877))
  Gcoeff(:)%j = (c(321)*M(3,:)%j) * den(446)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5000),h0tab(:,5000),[57,6],[nME,nME],2,2,wf24(:,93),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,93),G0H4(144),m3h24x4(:,887),heltab2x96(:,:,4872))
  call Hloop_Q_A(ntryL,G0H4(144),57,nME,G1H4(195),n2h4(878))
  Gcoeff(:)%j = (c(321)*M(3,:)%j) * den(446)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5001),h0tab(:,5001),[57,6],[nMM,nMM],2,2,wf24(:,93),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,93),G0H4(144),m3h24x4(:,888),heltab2x96(:,:,4873))
  call Hloop_Q_A(ntryL,G0H4(144),57,nMM,G1H4(8),n2h4(879))
  Gcoeff(:)%j = (c(321)*M(3,:)%j) * den(446)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5002),h0tab(:,5002),[57,6],[nML,nML],2,2,wf24(:,93),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,93),G0H4(144),m3h24x4(:,889),heltab2x96(:,:,4874))
  call Hloop_Q_A(ntryL,G0H4(144),57,nML,G1H4(219),n2h4(880))
  Gcoeff(:)%j = (-(c(323)*M(3,:)%j)) * den(446)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5003),h0tab(:,5003),[57,6],[0,0],2,2,wf24(:,93),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,93),G0H4(144),m3h24x4(:,890),heltab2x96(:,:,4875))
  call Hloop_Q_A(ntryL,G0H4(144),57,0,G1H4(92),n2h4(881))
  Gcoeff(:)%j = (-(c(319)*M(3,:)%j)) * den(446)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5004),h0tab(:,5004),[57,6],[nMT,nMT],2,2,wf24(:,93),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,93),G0H4(144),m3h24x4(:,891),heltab2x96(:,:,4876))
  call Hloop_Q_A(ntryL,G0H4(144),57,nMT,G1H4(179),n2h4(882))
  Gcoeff(:)%j = (c(319)*M(3,:)%j) * den(446)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5005),h0tab(:,5005),[57,6],[0,0],2,2,wf24(:,93),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,93),G0H4(144),m3h24x4(:,892),heltab2x96(:,:,4877))
  call Hloop_Q_A(ntryL,G0H4(144),57,0,G1H4(108),n2h4(883))
  Gcoeff(:)%j = (c(313)*M(3,:)%j) * den(446)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5006),h0tab(:,5006),[57,6],[nMB,nMB],2,2,wf24(:,93),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,93),G0H4(144),m3h24x4(:,893),heltab2x96(:,:,4878))
  call Hloop_Q_A(ntryL,G0H4(144),57,nMB,G1H4(134),n2h4(884))
  Gcoeff(:)%j = (-(c(295)*M(3,:)%j)) * den(447)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5007),h0tab(:,5007),[57,6],[0,0],2,2,wf24(:,93),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H96(1),wf24(:,93),G0H4(144),ngZn,m3h24x4(:,894),heltab2x96(:,:,4879))
  call Hloop_Q_A(ntryL,G0H4(144),57,0,G1H4(139),n2h4(885))
  Gcoeff(:)%j = (-(c(292)*M(3,:)%j)) * den(447)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5008),h0tab(:,5008),[57,6],[nME,nME],2,2,wf24(:,93),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H96(1),wf24(:,93),G0H4(144),ngZl,m3h24x4(:,895),heltab2x96(:,:,4880))
  call Hloop_Q_A(ntryL,G0H4(144),57,nME,G1H4(326),n2h4(886))
  Gcoeff(:)%j = (-(c(292)*M(3,:)%j)) * den(447)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5009),h0tab(:,5009),[57,6],[nMM,nMM],2,2,wf24(:,93),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H96(1),wf24(:,93),G0H4(144),ngZl,m3h24x4(:,896),heltab2x96(:,:,4881))
  call Hloop_Q_A(ntryL,G0H4(144),57,nMM,G1H4(4),n2h4(887))
  Gcoeff(:)%j = (-(c(292)*M(3,:)%j)) * den(447)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5010),h0tab(:,5010),[57,6],[nML,nML],2,2,wf24(:,93),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H96(1),wf24(:,93),G0H4(144),ngZl,m3h24x4(:,897),heltab2x96(:,:,4882))
  call Hloop_Q_A(ntryL,G0H4(144),57,nML,G1H4(330),n2h4(888))
  Gcoeff(:)%j = (-(c(294)*M(3,:)%j)) * den(447)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5011),h0tab(:,5011),[57,6],[0,0],2,2,wf24(:,93),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H96(1),wf24(:,93),G0H4(144),ngZu,m3h24x4(:,898),heltab2x96(:,:,4883))
  call Hloop_Q_A(ntryL,G0H4(144),57,0,G1H4(95),n2h4(889))
  Gcoeff(:)%j = (-(c(293)*M(3,:)%j)) * den(447)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5012),h0tab(:,5012),[57,6],[nMT,nMT],2,2,wf24(:,93),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H96(1),wf24(:,93),G0H4(144),ngZu,m3h24x4(:,899),heltab2x96(:,:,4884))
  call Hloop_Q_A(ntryL,G0H4(144),57,nMT,G1H4(194),n2h4(890))
  Gcoeff(:)%j = (-(c(294)*M(3,:)%j)) * den(447)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5013),h0tab(:,5013),[57,6],[0,0],2,2,wf24(:,93),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H96(1),wf24(:,93),G0H4(144),ngZd,m3h24x4(:,900),heltab2x96(:,:,4885))
  call Hloop_Q_A(ntryL,G0H4(144),57,0,G1H4(153),n2h4(891))
  Gcoeff(:)%j = (-(c(293)*M(3,:)%j)) * den(447)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5014),h0tab(:,5014),[57,6],[nMB,nMB],2,2,wf24(:,93),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H96(1),wf24(:,93),G0H4(144),ngZd,m3h24x4(:,901),heltab2x96(:,:,4886))
  call Hloop_Q_A(ntryL,G0H4(144),57,nMB,G1H4(3),n2h4(892))
  Gcoeff(:)%j = (c(154)*M(3,:)%j) * den(449)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5015),h0tab(:,5015),[57,6],[nMW,nMW],2,2,wf24(:,93),wf4(:,1))
  call Hloop_TV_S(ntryL,G0H96(1),0,wf24(:,93),57,G1H4(238),m3h24x4(:,902),heltab2x96(:,:,4887))
  Gcoeff(:)%j = (-(c(207)*M(3,:)%j)) * den(450)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5016),h0tab(:,5016),[57,6],[nMW,nMW],2,2,wf24(:,93),wf4(:,1))
  call Hloop_TV_S(ntryL,G0H96(1),0,wf24(:,93),57,G1H4(350),m3h24x4(:,903),heltab2x96(:,:,4888))
  Gcoeff(:)%j = (c(201)*M(3,:)%j) * den(446)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5017),h0tab(:,5017),[57,6],[nMW,nMW],2,2,wf24(:,93),wf4(:,4))
  call Hloop_TV_S(ntryL,G0H96(1),0,wf24(:,93),57,G1H4(10),m3h24x4(:,904),heltab2x96(:,:,4889))
  Gcoeff(:)%j = (-(c(47)*M(3,:)%j)) * den(447)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5018),h0tab(:,5018),[57,6],[nMH,nMZ],2,2,wf24(:,93),wf4(:,4))
  call Hloop_SV_T(ntryL,G0H96(1),0,wf24(:,93),57,G1H4(263),m3h24x4(:,905),heltab2x96(:,:,4890))
  Gcoeff(:)%j = (-(c(202)*M(3,:)%j)) * den(447)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5019),h0tab(:,5019),[57,6],[nMW,nMW],2,2,wf24(:,93),wf4(:,4))
  call Hloop_TV_S(ntryL,G0H96(1),0,wf24(:,93),57,G1H4(103),m3h24x4(:,906),heltab2x96(:,:,4891))
  Gcoeff(:)%j = (-(c(154)*M(3,:)%j)) * den(449)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5020),h0tab(:,5020),[57,6],[nMW,nMW],2,2,wf24(:,93),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H96(1),0,wf24(:,93),57,G1H4(312),m3h24x4(:,907),heltab2x96(:,:,4892))
  Gcoeff(:)%j = (-(c(154)*M(3,:)%j)) * den(449)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5021),h0tab(:,5021),[57,6],[nMW,nMW],2,2,wf24(:,93),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H96(1),0,wf24(:,93),57,G1H4(175),m3h24x4(:,908),heltab2x96(:,:,4893))
  Gcoeff(:)%j = (-(c(69)*M(3,:)%j)) * den(450)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5022),h0tab(:,5022),[57,6],[nMW,nMW],2,2,wf24(:,93),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H96(1),0,wf24(:,93),57,G1H4(351),m3h24x4(:,909),heltab2x96(:,:,4894))
  Gcoeff(:)%j = (-(c(69)*M(3,:)%j)) * den(450)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5023),h0tab(:,5023),[57,6],[nMW,nMW],2,2,wf24(:,93),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H96(1),0,wf24(:,93),57,G1H4(22),m3h24x4(:,910),heltab2x96(:,:,4895))
  Gcoeff(:)%j = (-(c(131)*M(3,:)%j)) * den(446)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5024),h0tab(:,5024),[57,6],[nMW,nMW],2,2,wf24(:,93),wf4(:,4))
  call Hloop_CV_D(ntryL,G0H96(1),0,wf24(:,93),57,G1H4(208),m3h24x4(:,911),heltab2x96(:,:,4896))
  Gcoeff(:)%j = (-(c(131)*M(3,:)%j)) * den(446)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5025),h0tab(:,5025),[57,6],[nMW,nMW],2,2,wf24(:,93),wf4(:,4))
  call Hloop_CV_D(ntryL,G0H96(1),0,wf24(:,93),57,G1H4(207),m3h24x4(:,912),heltab2x96(:,:,4897))
  Gcoeff(:)%j = (-(c(50)*M(3,:)%j)) * den(447)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5026),h0tab(:,5026),[57,6],[nMW,nMW],2,2,wf24(:,93),wf4(:,4))
  call Hloop_CV_D(ntryL,G0H96(1),0,wf24(:,93),57,G1H4(69),m3h24x4(:,913),heltab2x96(:,:,4898))
  Gcoeff(:)%j = (-(c(50)*M(3,:)%j)) * den(447)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5027),h0tab(:,5027),[57,6],[nMW,nMW],2,2,wf24(:,93),wf4(:,4))
  call Hloop_CV_D(ntryL,G0H96(1),0,wf24(:,93),57,G1H4(130),m3h24x4(:,914),heltab2x96(:,:,4899))
  Gcoeff(:)%j = (c(154)*M(3,:)%j) * den(449)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5028),h0tab(:,5028),[57,6],[nMW,nMW],2,2,wf24(:,93),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H96(1),0,wf24(:,93),57,G1H4(105),m3h24x4(:,915),heltab2x96(:,:,4900))
  Gcoeff(:)%j = (c(69)*M(3,:)%j) * den(450)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5029),h0tab(:,5029),[57,6],[nMW,nMW],2,2,wf24(:,93),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H96(1),0,wf24(:,93),57,G1H4(393),m3h24x4(:,916),heltab2x96(:,:,4901))
  Gcoeff(:)%j = (c(131)*M(3,:)%j) * den(446)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5030),h0tab(:,5030),[57,6],[nMW,nMW],2,2,wf24(:,93),wf4(:,4))
  call Hloop_UV_W(ntryL,G0H96(1),0,wf24(:,93),57,G1H4(362),m3h24x4(:,917),heltab2x96(:,:,4902))
  Gcoeff(:)%j = (c(50)*M(3,:)%j) * den(447)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5031),h0tab(:,5031),[57,6],[nMW,nMW],2,2,wf24(:,93),wf4(:,4))
  call Hloop_UV_W(ntryL,G0H96(1),0,wf24(:,93),57,G1H4(314),m3h24x4(:,918),heltab2x96(:,:,4903))
  Gcoeff(:)%j = (-(c(186)*M(3,:)%j)) * den(449)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5032),h0tab(:,5032),[57,6],[nMW,nMW],2,2,wf24(:,93),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H96(1),wf24(:,93),G0H4(144),m3h24x4(:,919),heltab2x96(:,:,4904))
  Gcoeff(:)%j = (-(c(186)*M(3,:)%j)) * den(449)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5033),h0tab(:,5033),[57,6],[nMW,nMW],2,2,wf24(:,93),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H96(1),wf24(:,93),G0H4(145),m3h24x4(:,920),heltab2x96(:,:,4905))
  Gcoeff(:)%j = (c(186)*M(3,:)%j) * den(450)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5034),h0tab(:,5034),[57,6],[nMW,nMW],2,2,wf24(:,93),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H96(1),wf24(:,93),G0H4(146),m3h24x4(:,921),heltab2x96(:,:,4906))
  Gcoeff(:)%j = (c(186)*M(3,:)%j) * den(450)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5035),h0tab(:,5035),[57,6],[nMW,nMW],2,2,wf24(:,93),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H96(1),wf24(:,93),G0H4(147),m3h24x4(:,922),heltab2x96(:,:,4907))
  Gcoeff(:)%j = (c(3)*M(3,:)%j) * den(446)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5036),h0tab(:,5036),[57,6],[nMW,nMW],2,2,wf24(:,93),wf4(:,4))
  call Hloop_VV_S(ntryL,G0H96(1),wf24(:,93),G0H4(148),m3h24x4(:,923),heltab2x96(:,:,4908))
  Gcoeff(:)%j = (c(3)*M(3,:)%j) * den(446)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5037),h0tab(:,5037),[57,6],[nMW,nMW],2,2,wf24(:,93),wf4(:,4))
  call Hloop_VV_S(ntryL,G0H96(1),wf24(:,93),G0H4(149),m3h24x4(:,924),heltab2x96(:,:,4909))
  Gcoeff(:)%j = (-(c(59)*M(3,:)%j)) * den(447)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5038),h0tab(:,5038),[57,6],[nMH,nMZ],2,2,wf24(:,93),wf4(:,4))
  call Hloop_VV_S(ntryL,G0H96(1),wf24(:,93),G0H4(150),m3h24x4(:,925),heltab2x96(:,:,4910))
  Gcoeff(:)%j = (-(c(3)*M(3,:)%j)) * den(447)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5039),h0tab(:,5039),[57,6],[nMW,nMW],2,2,wf24(:,93),wf4(:,4))
  call Hloop_VV_S(ntryL,G0H96(1),wf24(:,93),G0H4(151),m3h24x4(:,926),heltab2x96(:,:,4911))
  Gcoeff(:)%j = (-(c(3)*M(3,:)%j)) * den(447)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5040),h0tab(:,5040),[57,6],[nMW,nMW],2,2,wf24(:,93),wf4(:,4))
  call Hloop_VV_S(ntryL,G0H96(1),wf24(:,93),G0H4(152),m3h24x4(:,927),heltab2x96(:,:,4912))
  Gcoeff(:)%j = (-(c(143)*M(3,:)%j)) * den(222)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5041),h0tab(:,5041),[49,14],[0,0],2,2,wf12(:,28),wf8(:,3))
  call Hloop_VA_Q(ntryL,G0H96(1),wf12(:,28),G0H8(25),m3h12x8(:,213),heltab2x96(:,:,4913))
  call Hloop_A_Q(ntryL,G0H8(25),49,0,G1H8(198),n2h8(230))
  Gcoeff(:)%j = (-(c(150)*M(3,:)%j)) * den(222)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5042),h0tab(:,5042),[49,14],[0,nMZ],2,2,wf12(:,28),wf8(:,3))
  call Hloop_ZA_Q(ntryL,G0H96(1),wf12(:,28),G0H8(12),ngZd,m3h12x8(:,214),heltab2x96(:,:,4914))
  call Hloop_A_Q(ntryL,G0H8(12),49,0,G1H8(199),n2h8(231))
  Gcoeff(:)%j = (-(c(105)*M(3,:)%j)) * den(222)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5043),h0tab(:,5043),[49,14],[0,nMW],2,2,wf12(:,28),wf8(:,3))
  call Hloop_WA_Q(ntryL,G0H96(1),wf12(:,28),G0H8(11),m3h12x8(:,215),heltab2x96(:,:,4915))
  call Hloop_A_Q(ntryL,G0H8(11),49,0,G1H8(88),n2h8(232))
  Gcoeff(:)%j = (-(c(170)*M(2,:)%j)) * den(222)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5044),h0tab(:,5044),[49,14],[0,0],2,2,wf12(:,28),wf8(:,3))
  call Hloop_VA_Q(ntryL,G0H96(1),wf12(:,28),G0H8(35),m3h12x8(:,216),heltab2x96(:,:,4916))
  call Hloop_A_Q(ntryL,G0H8(35),49,0,G1H8(93),n2h8(233))
  Gcoeff(:)%j = (c(147)*M(3,:)%j) * den(223)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5045),h0tab(:,5045),[49,14],[0,0],2,2,wf12(:,28),wf8(:,5))
  call Hloop_VA_Q(ntryL,G0H96(1),wf12(:,28),G0H8(16),m3h12x8(:,217),heltab2x96(:,:,4917))
  call Hloop_A_Q(ntryL,G0H8(16),49,0,G1H8(105),n2h8(234))
  Gcoeff(:)%j = (c(155)*M(3,:)%j) * den(223)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5046),h0tab(:,5046),[49,14],[0,nMZ],2,2,wf12(:,28),wf8(:,5))
  call Hloop_ZA_Q(ntryL,G0H96(1),wf12(:,28),G0H8(18),ngZd,m3h12x8(:,218),heltab2x96(:,:,4918))
  call Hloop_A_Q(ntryL,G0H8(18),49,0,G1H8(106),n2h8(235))
  Gcoeff(:)%j = (c(109)*M(3,:)%j) * den(223)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5047),h0tab(:,5047),[49,14],[0,nMW],2,2,wf12(:,28),wf8(:,5))
  call Hloop_WA_Q(ntryL,G0H96(1),wf12(:,28),G0H8(42),m3h12x8(:,219),heltab2x96(:,:,4919))
  call Hloop_A_Q(ntryL,G0H8(42),49,0,G1H8(5),n2h8(236))
  Gcoeff(:)%j = (c(181)*M(2,:)%j) * den(223)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5048),h0tab(:,5048),[49,14],[0,0],2,2,wf12(:,28),wf8(:,5))
  call Hloop_VA_Q(ntryL,G0H96(1),wf12(:,28),G0H8(43),m3h12x8(:,220),heltab2x96(:,:,4920))
  call Hloop_A_Q(ntryL,G0H8(43),49,0,G1H8(56),n2h8(237))
  Gcoeff(:)%j = (c(167)*M(1,:)%j-c(166)*M(2,:)%j) * den(222)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5049),h0tab(:,5049),[49,14],[0,0],2,2,wf12(:,28),wf8(:,3))
  call Hloop_VA_Q(ntryL,G0H96(1),wf12(:,28),G0H8(28),m3h12x8(:,221),heltab2x96(:,:,4921))
  call Hloop_A_Q(ntryL,G0H8(28),49,0,G1H8(58),n2h8(238))
  Gcoeff(:)%j = (c(180)*M(1,:)%j-c(179)*M(2,:)%j) * den(222)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5050),h0tab(:,5050),[49,14],[0,nMZ],2,2,wf12(:,28),wf8(:,3))
  call Hloop_ZA_Q(ntryL,G0H96(1),wf12(:,28),G0H8(31),ngZd,m3h12x8(:,222),heltab2x96(:,:,4922))
  call Hloop_A_Q(ntryL,G0H8(31),49,0,G1H8(61),n2h8(239))
  Gcoeff(:)%j = (c(113)*M(1,:)%j-c(112)*M(2,:)%j) * den(222)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5051),h0tab(:,5051),[49,14],[0,nMW],2,2,wf12(:,28),wf8(:,3))
  call Hloop_WA_Q(ntryL,G0H96(1),wf12(:,28),G0H8(27),m3h12x8(:,223),heltab2x96(:,:,4923))
  call Hloop_A_Q(ntryL,G0H8(27),49,0,G1H8(38),n2h8(240))
  Gcoeff(:)%j = (c(260)*M(3,:)%j) * den(451)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5052),h0tab(:,5052),[57,6],[nME,nME],2,2,wf24(:,94),wf4(:,7))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,94),G0H4(153),m3h24x4(:,928),heltab2x96(:,:,4924))
  call Hloop_Q_A(ntryL,G0H4(153),57,nME,G1H4(373),n2h4(893))
  Gcoeff(:)%j = (c(266)*M(3,:)%j) * den(451)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5053),h0tab(:,5053),[57,6],[nMM,nMM],2,2,wf24(:,94),wf4(:,7))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,94),G0H4(153),m3h24x4(:,929),heltab2x96(:,:,4925))
  call Hloop_Q_A(ntryL,G0H4(153),57,nMM,G1H4(291),n2h4(894))
  Gcoeff(:)%j = (c(263)*M(3,:)%j) * den(451)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5054),h0tab(:,5054),[57,6],[nML,nML],2,2,wf24(:,94),wf4(:,7))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,94),G0H4(153),m3h24x4(:,930),heltab2x96(:,:,4926))
  call Hloop_Q_A(ntryL,G0H4(153),57,nML,G1H4(107),n2h4(895))
  Gcoeff(:)%j = (-(c(269)*M(3,:)%j)) * den(451)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5055),h0tab(:,5055),[57,6],[nMT,nMT],2,2,wf24(:,94),wf4(:,7))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,94),G0H4(153),m3h24x4(:,931),heltab2x96(:,:,4927))
  call Hloop_Q_A(ntryL,G0H4(153),57,nMT,G1H4(35),n2h4(896))
  Gcoeff(:)%j = (c(255)*M(3,:)%j) * den(451)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5056),h0tab(:,5056),[57,6],[nMB,nMB],2,2,wf24(:,94),wf4(:,7))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,94),G0H4(153),m3h24x4(:,932),heltab2x96(:,:,4928))
  call Hloop_Q_A(ntryL,G0H4(153),57,nMB,G1H4(110),n2h4(897))
  Gcoeff(:)%j = (c(262)*M(3,:)%j) * den(452)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5057),h0tab(:,5057),[57,6],[nME,nME],2,2,wf24(:,95),wf4(:,7))
  call Hloop_QZ_A(ntryL,G0H96(1),wf24(:,95),G0H4(153),ngZl,m3h24x4(:,933),heltab2x96(:,:,4929))
  call Hloop_Q_A(ntryL,G0H4(153),57,nME,G1H4(290),n2h4(898))
  Gcoeff(:)%j = (c(268)*M(3,:)%j) * den(452)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5058),h0tab(:,5058),[57,6],[nMM,nMM],2,2,wf24(:,95),wf4(:,7))
  call Hloop_QZ_A(ntryL,G0H96(1),wf24(:,95),G0H4(153),ngZl,m3h24x4(:,934),heltab2x96(:,:,4930))
  call Hloop_Q_A(ntryL,G0H4(153),57,nMM,G1H4(405),n2h4(899))
  Gcoeff(:)%j = (c(265)*M(3,:)%j) * den(452)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5059),h0tab(:,5059),[57,6],[nML,nML],2,2,wf24(:,95),wf4(:,7))
  call Hloop_QZ_A(ntryL,G0H96(1),wf24(:,95),G0H4(153),ngZl,m3h24x4(:,935),heltab2x96(:,:,4931))
  call Hloop_Q_A(ntryL,G0H4(153),57,nML,G1H4(201),n2h4(900))
  Gcoeff(:)%j = (c(272)*M(3,:)%j) * den(452)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5060),h0tab(:,5060),[57,6],[nMT,nMT],2,2,wf24(:,95),wf4(:,7))
  call Hloop_QZ_A(ntryL,G0H96(1),wf24(:,95),G0H4(153),ngZu,m3h24x4(:,936),heltab2x96(:,:,4932))
  call Hloop_Q_A(ntryL,G0H4(153),57,nMT,G1H4(410),n2h4(901))
  Gcoeff(:)%j = (c(258)*M(3,:)%j) * den(452)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5061),h0tab(:,5061),[57,6],[nMB,nMB],2,2,wf24(:,95),wf4(:,7))
  call Hloop_QZ_A(ntryL,G0H96(1),wf24(:,95),G0H4(153),ngZd,m3h24x4(:,937),heltab2x96(:,:,4933))
  call Hloop_Q_A(ntryL,G0H4(153),57,nMB,G1H4(415),n2h4(902))
  Gcoeff(:)%j = (c(260)*M(3,:)%j) * den(453)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5062),h0tab(:,5062),[57,6],[nME,nME],2,2,wf24(:,94),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,94),G0H4(153),m3h24x4(:,938),heltab2x96(:,:,4934))
  call Hloop_Q_A(ntryL,G0H4(153),57,nME,G1H4(433),n2h4(903))
  Gcoeff(:)%j = (c(266)*M(3,:)%j) * den(453)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5063),h0tab(:,5063),[57,6],[nMM,nMM],2,2,wf24(:,94),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,94),G0H4(153),m3h24x4(:,939),heltab2x96(:,:,4935))
  call Hloop_Q_A(ntryL,G0H4(153),57,nMM,G1H4(276),n2h4(904))
  Gcoeff(:)%j = (c(263)*M(3,:)%j) * den(453)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5064),h0tab(:,5064),[57,6],[nML,nML],2,2,wf24(:,94),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,94),G0H4(153),m3h24x4(:,940),heltab2x96(:,:,4936))
  call Hloop_Q_A(ntryL,G0H4(153),57,nML,G1H4(438),n2h4(905))
  Gcoeff(:)%j = (c(269)*M(3,:)%j) * den(453)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5065),h0tab(:,5065),[57,6],[nMT,nMT],2,2,wf24(:,94),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,94),G0H4(153),m3h24x4(:,941),heltab2x96(:,:,4937))
  call Hloop_Q_A(ntryL,G0H4(153),57,nMT,G1H4(236),n2h4(906))
  Gcoeff(:)%j = (c(255)*M(3,:)%j) * den(453)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5066),h0tab(:,5066),[57,6],[nMB,nMB],2,2,wf24(:,94),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,94),G0H4(153),m3h24x4(:,942),heltab2x96(:,:,4938))
  call Hloop_Q_A(ntryL,G0H4(153),57,nMB,G1H4(443),n2h4(907))
  Gcoeff(:)%j = (c(262)*M(3,:)%j) * den(454)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5067),h0tab(:,5067),[57,6],[nME,nME],2,2,wf24(:,95),wf4(:,17))
  call Hloop_QZ_A(ntryL,G0H96(1),wf24(:,95),G0H4(153),ngZl,m3h24x4(:,943),heltab2x96(:,:,4939))
  call Hloop_Q_A(ntryL,G0H4(153),57,nME,G1H4(448),n2h4(908))
  Gcoeff(:)%j = (c(268)*M(3,:)%j) * den(454)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5068),h0tab(:,5068),[57,6],[nMM,nMM],2,2,wf24(:,95),wf4(:,17))
  call Hloop_QZ_A(ntryL,G0H96(1),wf24(:,95),G0H4(153),ngZl,m3h24x4(:,944),heltab2x96(:,:,4940))
  call Hloop_Q_A(ntryL,G0H4(153),57,nMM,G1H4(81),n2h4(909))
  Gcoeff(:)%j = (c(265)*M(3,:)%j) * den(454)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5069),h0tab(:,5069),[57,6],[nML,nML],2,2,wf24(:,95),wf4(:,17))
  call Hloop_QZ_A(ntryL,G0H96(1),wf24(:,95),G0H4(153),ngZl,m3h24x4(:,945),heltab2x96(:,:,4941))
  call Hloop_Q_A(ntryL,G0H4(153),57,nML,G1H4(14),n2h4(910))
  Gcoeff(:)%j = (-(c(272)*M(3,:)%j)) * den(454)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5070),h0tab(:,5070),[57,6],[nMT,nMT],2,2,wf24(:,95),wf4(:,17))
  call Hloop_QZ_A(ntryL,G0H96(1),wf24(:,95),G0H4(153),ngZu,m3h24x4(:,946),heltab2x96(:,:,4942))
  call Hloop_Q_A(ntryL,G0H4(153),57,nMT,G1H4(329),n2h4(911))
  Gcoeff(:)%j = (c(258)*M(3,:)%j) * den(454)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5071),h0tab(:,5071),[57,6],[nMB,nMB],2,2,wf24(:,95),wf4(:,17))
  call Hloop_QZ_A(ntryL,G0H96(1),wf24(:,95),G0H4(153),ngZd,m3h24x4(:,947),heltab2x96(:,:,4943))
  call Hloop_Q_A(ntryL,G0H4(153),57,nMB,G1H4(252),n2h4(912))
  Gcoeff(:)%j = (c(89)*M(3,:)%j) * den(451)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5072),h0tab(:,5072),[57,6],[nMW,nMW],2,2,wf24(:,94),wf4(:,7))
  call Hloop_TV_S(ntryL,G0H96(1),0,wf24(:,94),57,G1H4(31),m3h24x4(:,948),heltab2x96(:,:,4944))
  Gcoeff(:)%j = (c(204)*M(3,:)%j) * den(452)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5073),h0tab(:,5073),[57,6],[nMW,nMW],2,2,wf24(:,95),wf4(:,7))
  call Hloop_TV_S(ntryL,G0H96(1),0,wf24(:,95),57,G1H4(401),m3h24x4(:,949),heltab2x96(:,:,4945))
  Gcoeff(:)%j = (-(c(56)*M(3,:)%j)) * den(454)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5074),h0tab(:,5074),[57,6],[nMH,nMZ],2,2,wf24(:,95),wf4(:,17))
  call Hloop_SV_T(ntryL,G0H96(1),0,wf24(:,95),57,G1H4(411),m3h24x4(:,950),heltab2x96(:,:,4946))
  Gcoeff(:)%j = (c(74)*M(3,:)%j) * den(451)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5075),h0tab(:,5075),[57,6],[nMW,nMW],2,2,wf24(:,94),wf4(:,7))
  call Hloop_CV_D(ntryL,G0H96(1),0,wf24(:,94),57,G1H4(416),m3h24x4(:,951),heltab2x96(:,:,4947))
  Gcoeff(:)%j = (-(c(74)*M(3,:)%j)) * den(451)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5076),h0tab(:,5076),[57,6],[nMW,nMW],2,2,wf24(:,94),wf4(:,7))
  call Hloop_CV_D(ntryL,G0H96(1),0,wf24(:,94),57,G1H4(420),m3h24x4(:,952),heltab2x96(:,:,4948))
  Gcoeff(:)%j = (-(c(54)*M(3,:)%j)) * den(452)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5077),h0tab(:,5077),[57,6],[nMW,nMW],2,2,wf24(:,95),wf4(:,7))
  call Hloop_CV_D(ntryL,G0H96(1),0,wf24(:,95),57,G1H4(421),m3h24x4(:,953),heltab2x96(:,:,4949))
  Gcoeff(:)%j = (c(54)*M(3,:)%j) * den(452)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5078),h0tab(:,5078),[57,6],[nMW,nMW],2,2,wf24(:,95),wf4(:,7))
  call Hloop_CV_D(ntryL,G0H96(1),0,wf24(:,95),57,G1H4(425),m3h24x4(:,954),heltab2x96(:,:,4950))
  Gcoeff(:)%j = (c(74)*M(3,:)%j) * den(453)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5079),h0tab(:,5079),[57,6],[nMW,nMW],2,2,wf24(:,94),wf4(:,17))
  call Hloop_CV_D(ntryL,G0H96(1),0,wf24(:,94),57,G1H4(426),m3h24x4(:,955),heltab2x96(:,:,4951))
  Gcoeff(:)%j = (c(74)*M(3,:)%j) * den(453)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5080),h0tab(:,5080),[57,6],[nMW,nMW],2,2,wf24(:,94),wf4(:,17))
  call Hloop_CV_D(ntryL,G0H96(1),0,wf24(:,94),57,G1H4(297),m3h24x4(:,956),heltab2x96(:,:,4952))
  Gcoeff(:)%j = (-(c(54)*M(3,:)%j)) * den(454)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5081),h0tab(:,5081),[57,6],[nMW,nMW],2,2,wf24(:,95),wf4(:,17))
  call Hloop_CV_D(ntryL,G0H96(1),0,wf24(:,95),57,G1H4(316),m3h24x4(:,957),heltab2x96(:,:,4953))
  Gcoeff(:)%j = (-(c(54)*M(3,:)%j)) * den(454)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5082),h0tab(:,5082),[57,6],[nMW,nMW],2,2,wf24(:,95),wf4(:,17))
  call Hloop_CV_D(ntryL,G0H96(1),0,wf24(:,95),57,G1H4(430),m3h24x4(:,958),heltab2x96(:,:,4954))
  Gcoeff(:)%j = (c(76)*M(3,:)%j) * den(451)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5083),h0tab(:,5083),[57,6],[nMW,nMW],2,2,wf24(:,94),wf4(:,7))
  call Hloop_UV_W(ntryL,G0H96(1),0,wf24(:,94),57,G1H4(431),m3h24x4(:,959),heltab2x96(:,:,4955))
  Gcoeff(:)%j = (-(c(55)*M(3,:)%j)) * den(452)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5084),h0tab(:,5084),[57,6],[nMW,nMW],2,2,wf24(:,95),wf4(:,7))
  call Hloop_UV_W(ntryL,G0H96(1),0,wf24(:,95),57,G1H4(444),m3h24x4(:,960),heltab2x96(:,:,4956))
  Gcoeff(:)%j = (-(c(74)*M(3,:)%j)) * den(451)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5085),h0tab(:,5085),[57,6],[nMW,nMW],2,2,wf24(:,94),wf4(:,7))
  call Hloop_VV_S(ntryL,G0H96(1),wf24(:,94),G0H4(153),m3h24x4(:,961),heltab2x96(:,:,4957))
  Gcoeff(:)%j = (c(74)*M(3,:)%j) * den(451)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5086),h0tab(:,5086),[57,6],[nMW,nMW],2,2,wf24(:,94),wf4(:,7))
  call Hloop_VV_S(ntryL,G0H96(1),wf24(:,94),G0H4(154),m3h24x4(:,962),heltab2x96(:,:,4958))
  Gcoeff(:)%j = (-(c(138)*M(3,:)%j)) * den(452)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5087),h0tab(:,5087),[57,6],[nMW,nMW],2,2,wf24(:,95),wf4(:,7))
  call Hloop_VV_S(ntryL,G0H96(1),wf24(:,95),G0H4(155),m3h24x4(:,963),heltab2x96(:,:,4959))
  Gcoeff(:)%j = (c(138)*M(3,:)%j) * den(452)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5088),h0tab(:,5088),[57,6],[nMW,nMW],2,2,wf24(:,95),wf4(:,7))
  call Hloop_VV_S(ntryL,G0H96(1),wf24(:,95),G0H4(156),m3h24x4(:,964),heltab2x96(:,:,4960))
  Gcoeff(:)%j = (c(74)*M(3,:)%j) * den(453)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5089),h0tab(:,5089),[57,6],[nMW,nMW],2,2,wf24(:,94),wf4(:,17))
  call Hloop_VV_S(ntryL,G0H96(1),wf24(:,94),G0H4(157),m3h24x4(:,965),heltab2x96(:,:,4961))
  Gcoeff(:)%j = (c(74)*M(3,:)%j) * den(453)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5090),h0tab(:,5090),[57,6],[nMW,nMW],2,2,wf24(:,94),wf4(:,17))
  call Hloop_VV_S(ntryL,G0H96(1),wf24(:,94),G0H4(158),m3h24x4(:,966),heltab2x96(:,:,4962))
  Gcoeff(:)%j = (-(c(51)*M(3,:)%j)) * den(454)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5091),h0tab(:,5091),[57,6],[nMH,nMZ],2,2,wf24(:,95),wf4(:,17))
  call Hloop_VV_S(ntryL,G0H96(1),wf24(:,95),G0H4(159),m3h24x4(:,967),heltab2x96(:,:,4963))
  Gcoeff(:)%j = (c(138)*M(3,:)%j) * den(454)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5092),h0tab(:,5092),[57,6],[nMW,nMW],2,2,wf24(:,95),wf4(:,17))
  call Hloop_VV_S(ntryL,G0H96(1),wf24(:,95),G0H4(160),m3h24x4(:,968),heltab2x96(:,:,4964))
  Gcoeff(:)%j = (c(138)*M(3,:)%j) * den(454)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5093),h0tab(:,5093),[57,6],[nMW,nMW],2,2,wf24(:,95),wf4(:,17))
  call Hloop_VV_S(ntryL,G0H96(1),wf24(:,95),G0H4(161),m3h24x4(:,969),heltab2x96(:,:,4965))
  Gcoeff(:)%j = (c(309)*M(3,:)%j) * den(455)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5094),h0tab(:,5094),[57,6],[nME,nME],2,2,wf24(:,94),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,94),G0H4(162),m3h24x4(:,970),heltab2x96(:,:,4966))
  call Hloop_Q_A(ntryL,G0H4(162),57,nME,G1H4(449),n2h4(913))
  Gcoeff(:)%j = (c(309)*M(3,:)%j) * den(455)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5095),h0tab(:,5095),[57,6],[nMM,nMM],2,2,wf24(:,94),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,94),G0H4(162),m3h24x4(:,971),heltab2x96(:,:,4967))
  call Hloop_Q_A(ntryL,G0H4(162),57,nMM,G1H4(269),n2h4(914))
  Gcoeff(:)%j = (c(309)*M(3,:)%j) * den(455)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5096),h0tab(:,5096),[57,6],[nML,nML],2,2,wf24(:,94),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,94),G0H4(162),m3h24x4(:,972),heltab2x96(:,:,4968))
  call Hloop_Q_A(ntryL,G0H4(162),57,nML,G1H4(340),n2h4(915))
  Gcoeff(:)%j = (c(308)*M(3,:)%j) * den(455)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5097),h0tab(:,5097),[57,6],[0,0],2,2,wf24(:,94),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,94),G0H4(162),m3h24x4(:,973),heltab2x96(:,:,4969))
  call Hloop_Q_A(ntryL,G0H4(162),57,0,G1H4(301),n2h4(916))
  Gcoeff(:)%j = (c(305)*M(3,:)%j) * den(455)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5098),h0tab(:,5098),[57,6],[nMT,nMT],2,2,wf24(:,94),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,94),G0H4(162),m3h24x4(:,974),heltab2x96(:,:,4970))
  call Hloop_Q_A(ntryL,G0H4(162),57,nMT,G1H4(21),n2h4(917))
  Gcoeff(:)%j = (c(303)*M(3,:)%j) * den(455)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5099),h0tab(:,5099),[57,6],[0,0],2,2,wf24(:,94),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,94),G0H4(162),m3h24x4(:,975),heltab2x96(:,:,4971))
  call Hloop_Q_A(ntryL,G0H4(162),57,0,G1H4(227),n2h4(918))
  Gcoeff(:)%j = (c(302)*M(3,:)%j) * den(455)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5100),h0tab(:,5100),[57,6],[nMB,nMB],2,2,wf24(:,94),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,94),G0H4(162),m3h24x4(:,976),heltab2x96(:,:,4972))
  call Hloop_Q_A(ntryL,G0H4(162),57,nMB,G1H4(147),n2h4(919))
  Gcoeff(:)%j = (c(318)*M(3,:)%j) * den(456)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5101),h0tab(:,5101),[57,6],[nME,nME],2,2,wf24(:,95),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H96(1),wf24(:,95),G0H4(162),ngZl,m3h24x4(:,977),heltab2x96(:,:,4973))
  call Hloop_Q_A(ntryL,G0H4(162),57,nME,G1H4(452),n2h4(920))
  Gcoeff(:)%j = (c(318)*M(3,:)%j) * den(456)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5102),h0tab(:,5102),[57,6],[nMM,nMM],2,2,wf24(:,95),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H96(1),wf24(:,95),G0H4(162),ngZl,m3h24x4(:,978),heltab2x96(:,:,4974))
  call Hloop_Q_A(ntryL,G0H4(162),57,nMM,G1H4(451),n2h4(921))
  Gcoeff(:)%j = (c(318)*M(3,:)%j) * den(456)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5103),h0tab(:,5103),[57,6],[nML,nML],2,2,wf24(:,95),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H96(1),wf24(:,95),G0H4(162),ngZl,m3h24x4(:,979),heltab2x96(:,:,4975))
  call Hloop_Q_A(ntryL,G0H4(162),57,nML,G1H4(363),n2h4(922))
  Gcoeff(:)%j = (-(c(320)*M(3,:)%j)) * den(456)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5104),h0tab(:,5104),[57,6],[0,0],2,2,wf24(:,95),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H96(1),wf24(:,95),G0H4(162),ngZu,m3h24x4(:,980),heltab2x96(:,:,4976))
  call Hloop_Q_A(ntryL,G0H4(162),57,0,G1H4(348),n2h4(923))
  Gcoeff(:)%j = (-(c(316)*M(3,:)%j)) * den(456)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5105),h0tab(:,5105),[57,6],[nMT,nMT],2,2,wf24(:,95),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H96(1),wf24(:,95),G0H4(162),ngZu,m3h24x4(:,981),heltab2x96(:,:,4977))
  call Hloop_Q_A(ntryL,G0H4(162),57,nMT,G1H4(272),n2h4(924))
  Gcoeff(:)%j = (c(316)*M(3,:)%j) * den(456)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5106),h0tab(:,5106),[57,6],[0,0],2,2,wf24(:,95),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H96(1),wf24(:,95),G0H4(162),ngZd,m3h24x4(:,982),heltab2x96(:,:,4978))
  call Hloop_Q_A(ntryL,G0H4(162),57,0,G1H4(245),n2h4(925))
  Gcoeff(:)%j = (c(310)*M(3,:)%j) * den(456)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5107),h0tab(:,5107),[57,6],[nMB,nMB],2,2,wf24(:,95),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H96(1),wf24(:,95),G0H4(162),ngZd,m3h24x4(:,983),heltab2x96(:,:,4979))
  call Hloop_Q_A(ntryL,G0H4(162),57,nMB,G1H4(122),n2h4(926))
  Gcoeff(:)%j = (-(c(312)*M(3,:)%j)) * den(453)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5108),h0tab(:,5108),[57,6],[nME,nME],2,2,wf24(:,94),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,94),G0H4(162),m3h24x4(:,984),heltab2x96(:,:,4980))
  call Hloop_Q_A(ntryL,G0H4(162),57,nME,G1H4(224),n2h4(927))
  Gcoeff(:)%j = (-(c(312)*M(3,:)%j)) * den(453)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5109),h0tab(:,5109),[57,6],[nMM,nMM],2,2,wf24(:,94),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,94),G0H4(162),m3h24x4(:,985),heltab2x96(:,:,4981))
  call Hloop_Q_A(ntryL,G0H4(162),57,nMM,G1H4(142),n2h4(928))
  Gcoeff(:)%j = (-(c(312)*M(3,:)%j)) * den(453)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5110),h0tab(:,5110),[57,6],[nML,nML],2,2,wf24(:,94),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,94),G0H4(162),m3h24x4(:,986),heltab2x96(:,:,4982))
  call Hloop_Q_A(ntryL,G0H4(162),57,nML,G1H4(250),n2h4(929))
  Gcoeff(:)%j = (c(316)*M(3,:)%j) * den(453)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5111),h0tab(:,5111),[57,6],[0,0],2,2,wf24(:,94),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,94),G0H4(162),m3h24x4(:,987),heltab2x96(:,:,4983))
  call Hloop_Q_A(ntryL,G0H4(162),57,0,G1H4(5),n2h4(930))
  Gcoeff(:)%j = (c(310)*M(3,:)%j) * den(453)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5112),h0tab(:,5112),[57,6],[nMT,nMT],2,2,wf24(:,94),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,94),G0H4(162),m3h24x4(:,988),heltab2x96(:,:,4984))
  call Hloop_Q_A(ntryL,G0H4(162),57,nMT,G1H4(298),n2h4(931))
  Gcoeff(:)%j = (-(c(310)*M(3,:)%j)) * den(453)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5113),h0tab(:,5113),[57,6],[0,0],2,2,wf24(:,94),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,94),G0H4(162),m3h24x4(:,989),heltab2x96(:,:,4985))
  call Hloop_Q_A(ntryL,G0H4(162),57,0,G1H4(157),n2h4(932))
  Gcoeff(:)%j = (-(c(306)*M(3,:)%j)) * den(453)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5114),h0tab(:,5114),[57,6],[nMB,nMB],2,2,wf24(:,94),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,94),G0H4(162),m3h24x4(:,990),heltab2x96(:,:,4986))
  call Hloop_Q_A(ntryL,G0H4(162),57,nMB,G1H4(68),n2h4(933))
  Gcoeff(:)%j = (-(c(325)*M(3,:)%j)) * den(454)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5115),h0tab(:,5115),[57,6],[0,0],2,2,wf24(:,95),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H96(1),wf24(:,95),G0H4(162),ngZn,m3h24x4(:,991),heltab2x96(:,:,4987))
  call Hloop_Q_A(ntryL,G0H4(162),57,0,G1H4(479),n2h4(934))
  Gcoeff(:)%j = (-(c(321)*M(3,:)%j)) * den(454)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5116),h0tab(:,5116),[57,6],[nME,nME],2,2,wf24(:,95),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H96(1),wf24(:,95),G0H4(162),ngZl,m3h24x4(:,992),heltab2x96(:,:,4988))
  call Hloop_Q_A(ntryL,G0H4(162),57,nME,G1H4(480),n2h4(935))
  Gcoeff(:)%j = (-(c(321)*M(3,:)%j)) * den(454)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5117),h0tab(:,5117),[57,6],[nMM,nMM],2,2,wf24(:,95),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H96(1),wf24(:,95),G0H4(162),ngZl,m3h24x4(:,993),heltab2x96(:,:,4989))
  call Hloop_Q_A(ntryL,G0H4(162),57,nMM,G1H4(481),n2h4(936))
  Gcoeff(:)%j = (-(c(321)*M(3,:)%j)) * den(454)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5118),h0tab(:,5118),[57,6],[nML,nML],2,2,wf24(:,95),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H96(1),wf24(:,95),G0H4(162),ngZl,m3h24x4(:,994),heltab2x96(:,:,4990))
  call Hloop_Q_A(ntryL,G0H4(162),57,nML,G1H4(482),n2h4(937))
  Gcoeff(:)%j = (-(c(324)*M(3,:)%j)) * den(454)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5119),h0tab(:,5119),[57,6],[0,0],2,2,wf24(:,95),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H96(1),wf24(:,95),G0H4(162),ngZu,m3h24x4(:,995),heltab2x96(:,:,4991))
  call Hloop_Q_A(ntryL,G0H4(162),57,0,G1H4(483),n2h4(938))
  Gcoeff(:)%j = (-(c(322)*M(3,:)%j)) * den(454)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5120),h0tab(:,5120),[57,6],[nMT,nMT],2,2,wf24(:,95),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H96(1),wf24(:,95),G0H4(162),ngZu,m3h24x4(:,996),heltab2x96(:,:,4992))
  call Hloop_Q_A(ntryL,G0H4(162),57,nMT,G1H4(484),n2h4(939))
  Gcoeff(:)%j = (-(c(324)*M(3,:)%j)) * den(454)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5121),h0tab(:,5121),[57,6],[0,0],2,2,wf24(:,95),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H96(1),wf24(:,95),G0H4(162),ngZd,m3h24x4(:,997),heltab2x96(:,:,4993))
  call Hloop_Q_A(ntryL,G0H4(162),57,0,G1H4(485),n2h4(940))
  Gcoeff(:)%j = (-(c(322)*M(3,:)%j)) * den(454)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5122),h0tab(:,5122),[57,6],[nMB,nMB],2,2,wf24(:,95),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H96(1),wf24(:,95),G0H4(162),ngZd,m3h24x4(:,998),heltab2x96(:,:,4994))
  call Hloop_Q_A(ntryL,G0H4(162),57,nMB,G1H4(486),n2h4(941))
  Gcoeff(:)%j = (-(c(150)*M(3,:)%j)) * den(455)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5123),h0tab(:,5123),[57,6],[nMW,nMW],2,2,wf24(:,94),wf4(:,1))
  call Hloop_TV_S(ntryL,G0H96(1),0,wf24(:,94),57,G1H4(487),m3h24x4(:,999),heltab2x96(:,:,4995))
  Gcoeff(:)%j = (c(200)*M(3,:)%j) * den(456)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5124),h0tab(:,5124),[57,6],[nMW,nMW],2,2,wf24(:,95),wf4(:,1))
  call Hloop_TV_S(ntryL,G0H96(1),0,wf24(:,95),57,G1H4(488),m3h24x4(:,1000),heltab2x96(:,:,4996))
  Gcoeff(:)%j = (-(c(199)*M(3,:)%j)) * den(453)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5125),h0tab(:,5125),[57,6],[nMW,nMW],2,2,wf24(:,94),wf4(:,4))
  call Hloop_TV_S(ntryL,G0H96(1),0,wf24(:,94),57,G1H4(489),m3h24x4(:,1001),heltab2x96(:,:,4997))
  Gcoeff(:)%j = (-(c(68)*M(3,:)%j)) * den(454)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5126),h0tab(:,5126),[57,6],[nMH,nMZ],2,2,wf24(:,95),wf4(:,4))
  call Hloop_SV_T(ntryL,G0H96(1),0,wf24(:,95),57,G1H4(490),m3h24x4(:,1002),heltab2x96(:,:,4998))
  Gcoeff(:)%j = (c(211)*M(3,:)%j) * den(454)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5127),h0tab(:,5127),[57,6],[nMW,nMW],2,2,wf24(:,95),wf4(:,4))
  call Hloop_TV_S(ntryL,G0H96(1),0,wf24(:,95),57,G1H4(491),m3h24x4(:,1003),heltab2x96(:,:,4999))
  Gcoeff(:)%j = (c(150)*M(3,:)%j) * den(455)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5128),h0tab(:,5128),[57,6],[nMW,nMW],2,2,wf24(:,94),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H96(1),0,wf24(:,94),57,G1H4(492),m3h24x4(:,1004),heltab2x96(:,:,5000))
  Gcoeff(:)%j = (c(150)*M(3,:)%j) * den(455)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5129),h0tab(:,5129),[57,6],[nMW,nMW],2,2,wf24(:,94),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H96(1),0,wf24(:,94),57,G1H4(493),m3h24x4(:,1005),heltab2x96(:,:,5001))
  Gcoeff(:)%j = (-(c(130)*M(3,:)%j)) * den(456)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5130),h0tab(:,5130),[57,6],[nMW,nMW],2,2,wf24(:,95),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H96(1),0,wf24(:,95),57,G1H4(494),m3h24x4(:,1006),heltab2x96(:,:,5002))
  Gcoeff(:)%j = (-(c(130)*M(3,:)%j)) * den(456)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5131),h0tab(:,5131),[57,6],[nMW,nMW],2,2,wf24(:,95),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H96(1),0,wf24(:,95),57,G1H4(495),m3h24x4(:,1007),heltab2x96(:,:,5003))
  Gcoeff(:)%j = (c(128)*M(3,:)%j) * den(453)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5132),h0tab(:,5132),[57,6],[nMW,nMW],2,2,wf24(:,94),wf4(:,4))
  call Hloop_CV_D(ntryL,G0H96(1),0,wf24(:,94),57,G1H4(496),m3h24x4(:,1008),heltab2x96(:,:,5004))
  Gcoeff(:)%j = (c(128)*M(3,:)%j) * den(453)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5133),h0tab(:,5133),[57,6],[nMW,nMW],2,2,wf24(:,94),wf4(:,4))
  call Hloop_CV_D(ntryL,G0H96(1),0,wf24(:,94),57,G1H4(497),m3h24x4(:,1009),heltab2x96(:,:,5005))
  Gcoeff(:)%j = (-(c(70)*M(3,:)%j)) * den(454)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5134),h0tab(:,5134),[57,6],[nMW,nMW],2,2,wf24(:,95),wf4(:,4))
  call Hloop_CV_D(ntryL,G0H96(1),0,wf24(:,95),57,G1H4(498),m3h24x4(:,1010),heltab2x96(:,:,5006))
  Gcoeff(:)%j = (-(c(70)*M(3,:)%j)) * den(454)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5135),h0tab(:,5135),[57,6],[nMW,nMW],2,2,wf24(:,95),wf4(:,4))
  call Hloop_CV_D(ntryL,G0H96(1),0,wf24(:,95),57,G1H4(499),m3h24x4(:,1011),heltab2x96(:,:,5007))
  Gcoeff(:)%j = (-(c(150)*M(3,:)%j)) * den(455)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5136),h0tab(:,5136),[57,6],[nMW,nMW],2,2,wf24(:,94),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H96(1),0,wf24(:,94),57,G1H4(500),m3h24x4(:,1012),heltab2x96(:,:,5008))
  Gcoeff(:)%j = (c(130)*M(3,:)%j) * den(456)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5137),h0tab(:,5137),[57,6],[nMW,nMW],2,2,wf24(:,95),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H96(1),0,wf24(:,95),57,G1H4(501),m3h24x4(:,1013),heltab2x96(:,:,5009))
  Gcoeff(:)%j = (-(c(128)*M(3,:)%j)) * den(453)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5138),h0tab(:,5138),[57,6],[nMW,nMW],2,2,wf24(:,94),wf4(:,4))
  call Hloop_UV_W(ntryL,G0H96(1),0,wf24(:,94),57,G1H4(502),m3h24x4(:,1014),heltab2x96(:,:,5010))
  Gcoeff(:)%j = (c(70)*M(3,:)%j) * den(454)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5139),h0tab(:,5139),[57,6],[nMW,nMW],2,2,wf24(:,95),wf4(:,4))
  call Hloop_UV_W(ntryL,G0H96(1),0,wf24(:,95),57,G1H4(503),m3h24x4(:,1015),heltab2x96(:,:,5011))
  Gcoeff(:)%j = (c(184)*M(3,:)%j) * den(455)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5140),h0tab(:,5140),[57,6],[nMW,nMW],2,2,wf24(:,94),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H96(1),wf24(:,94),G0H4(162),m3h24x4(:,1016),heltab2x96(:,:,5012))
  Gcoeff(:)%j = (c(184)*M(3,:)%j) * den(455)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5141),h0tab(:,5141),[57,6],[nMW,nMW],2,2,wf24(:,94),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H96(1),wf24(:,94),G0H4(163),m3h24x4(:,1017),heltab2x96(:,:,5013))
  Gcoeff(:)%j = (c(2)*M(3,:)%j) * den(456)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5142),h0tab(:,5142),[57,6],[nMW,nMW],2,2,wf24(:,95),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H96(1),wf24(:,95),G0H4(164),m3h24x4(:,1018),heltab2x96(:,:,5014))
  Gcoeff(:)%j = (c(2)*M(3,:)%j) * den(456)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5143),h0tab(:,5143),[57,6],[nMW,nMW],2,2,wf24(:,95),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H96(1),wf24(:,95),G0H4(165),m3h24x4(:,1019),heltab2x96(:,:,5015))
  Gcoeff(:)%j = (-(c(1)*M(3,:)%j)) * den(453)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5144),h0tab(:,5144),[57,6],[nMW,nMW],2,2,wf24(:,94),wf4(:,4))
  call Hloop_VV_S(ntryL,G0H96(1),wf24(:,94),G0H4(166),m3h24x4(:,1020),heltab2x96(:,:,5016))
  Gcoeff(:)%j = (-(c(1)*M(3,:)%j)) * den(453)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5145),h0tab(:,5145),[57,6],[nMW,nMW],2,2,wf24(:,94),wf4(:,4))
  call Hloop_VV_S(ntryL,G0H96(1),wf24(:,94),G0H4(167),m3h24x4(:,1021),heltab2x96(:,:,5017))
  Gcoeff(:)%j = (-(c(101)*M(3,:)%j)) * den(454)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5146),h0tab(:,5146),[57,6],[nMH,nMZ],2,2,wf24(:,95),wf4(:,4))
  call Hloop_VV_S(ntryL,G0H96(1),wf24(:,95),G0H4(168),m3h24x4(:,1022),heltab2x96(:,:,5018))
  Gcoeff(:)%j = (-(c(192)*M(3,:)%j)) * den(454)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5147),h0tab(:,5147),[57,6],[nMW,nMW],2,2,wf24(:,95),wf4(:,4))
  call Hloop_VV_S(ntryL,G0H96(1),wf24(:,95),G0H4(169),m3h24x4(:,1023),heltab2x96(:,:,5019))
  Gcoeff(:)%j = (-(c(192)*M(3,:)%j)) * den(454)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5148),h0tab(:,5148),[57,6],[nMW,nMW],2,2,wf24(:,95),wf4(:,4))
  call Hloop_VV_S(ntryL,G0H96(1),wf24(:,95),G0H4(170),m3h24x4(:,1024),heltab2x96(:,:,5020))
  Gcoeff(:)%j = (-(c(146)*M(3,:)%j)) * den(457)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5149),h0tab(:,5149),[33,30],[0,0],2,2,wf4(:,6),wf24(:,41))
  call Hloop_QA_V(ntryL,G0H96(1),wf4(:,6),G0H24(123),m3h4x24(:,1167),heltab2x96(:,:,5021))
  Gcoeff(:)%j = (-(c(150)*M(3,:)%j)) * den(457)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5150),h0tab(:,5150),[33,30],[nMZ,0],2,2,wf4(:,6),wf24(:,41))
  call Hloop_QA_Z(ntryL,G0H96(1),wf4(:,6),G0H24(122),ngZu,m3h4x24(:,1168),heltab2x96(:,:,5022))
  Gcoeff(:)%j = (-(c(105)*M(3,:)%j)) * den(457)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5151),h0tab(:,5151),[33,30],[nMW,0],2,2,wf4(:,6),wf24(:,41))
  call Hloop_QA_W(ntryL,G0H96(1),wf4(:,6),G0H24(132),m3h4x24(:,1169),heltab2x96(:,:,5023))
  Gcoeff(:)%j = (-(c(170)*M(2,:)%j)) * den(457)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5152),h0tab(:,5152),[33,30],[0,0],2,2,wf4(:,6),wf24(:,41))
  call Hloop_QA_V(ntryL,G0H96(1),wf4(:,6),G0H24(78),m3h4x24(:,1170),heltab2x96(:,:,5024))
  Gcoeff(:)%j = (c(153)*M(3,:)%j) * den(458)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5153),h0tab(:,5153),[33,30],[0,0],2,2,wf4(:,6),wf24(:,43))
  call Hloop_QA_V(ntryL,G0H96(1),wf4(:,6),G0H24(69),m3h4x24(:,1171),heltab2x96(:,:,5025))
  Gcoeff(:)%j = (c(155)*M(3,:)%j) * den(458)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5154),h0tab(:,5154),[33,30],[nMZ,0],2,2,wf4(:,6),wf24(:,43))
  call Hloop_QA_Z(ntryL,G0H96(1),wf4(:,6),G0H24(106),ngZu,m3h4x24(:,1172),heltab2x96(:,:,5026))
  Gcoeff(:)%j = (c(109)*M(3,:)%j) * den(458)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5155),h0tab(:,5155),[33,30],[nMW,0],2,2,wf4(:,6),wf24(:,43))
  call Hloop_QA_W(ntryL,G0H96(1),wf4(:,6),G0H24(18),m3h4x24(:,1173),heltab2x96(:,:,5027))
  Gcoeff(:)%j = (c(181)*M(2,:)%j) * den(458)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5156),h0tab(:,5156),[33,30],[0,0],2,2,wf4(:,6),wf24(:,43))
  call Hloop_QA_V(ntryL,G0H96(1),wf4(:,6),G0H24(81),m3h4x24(:,1174),heltab2x96(:,:,5028))
  Gcoeff(:)%j = (c(174)*M(1,:)%j-c(173)*M(2,:)%j) * den(457)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5157),h0tab(:,5157),[33,30],[0,0],2,2,wf4(:,6),wf24(:,41))
  call Hloop_QA_V(ntryL,G0H96(1),wf4(:,6),G0H24(101),m3h4x24(:,1175),heltab2x96(:,:,5029))
  Gcoeff(:)%j = (c(180)*M(1,:)%j-c(179)*M(2,:)%j) * den(457)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5158),h0tab(:,5158),[33,30],[nMZ,0],2,2,wf4(:,6),wf24(:,41))
  call Hloop_QA_Z(ntryL,G0H96(1),wf4(:,6),G0H24(90),ngZu,m3h4x24(:,1176),heltab2x96(:,:,5030))
  Gcoeff(:)%j = (c(113)*M(1,:)%j-c(112)*M(2,:)%j) * den(457)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5159),h0tab(:,5159),[33,30],[nMW,0],2,2,wf4(:,6),wf24(:,41))
  call Hloop_QA_W(ntryL,G0H96(1),wf4(:,6),G0H24(100),m3h4x24(:,1177),heltab2x96(:,:,5031))
  Gcoeff(:)%j = (-(c(77)*M(3,:)%j)) * den(459)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5160),h0tab(:,5160),[33,30],[0,0],2,2,wf4(:,6),wf24(:,45))
  call Hloop_QA_V(ntryL,G0H96(1),wf4(:,6),G0H24(102),m3h4x24(:,1178),heltab2x96(:,:,5032))
  Gcoeff(:)%j = (-(c(80)*M(3,:)%j)) * den(459)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5161),h0tab(:,5161),[33,30],[nMZ,0],2,2,wf4(:,6),wf24(:,45))
  call Hloop_QA_Z(ntryL,G0H96(1),wf4(:,6),G0H24(89),ngZu,m3h4x24(:,1179),heltab2x96(:,:,5033))
  Gcoeff(:)%j = (-(c(33)*M(3,:)%j)) * den(459)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5162),h0tab(:,5162),[33,30],[nMW,0],2,2,wf4(:,6),wf24(:,45))
  call Hloop_QA_W(ntryL,G0H96(1),wf4(:,6),G0H24(105),m3h4x24(:,1180),heltab2x96(:,:,5034))
  Gcoeff(:)%j = (-(c(87)*M(2,:)%j)) * den(459)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5163),h0tab(:,5163),[33,30],[0,0],2,2,wf4(:,6),wf24(:,45))
  call Hloop_QA_V(ntryL,G0H96(1),wf4(:,6),G0H24(41),m3h4x24(:,1181),heltab2x96(:,:,5035))
  Gcoeff(:)%j = (c(151)*M(3,:)%j) * den(460)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5164),h0tab(:,5164),[33,30],[0,0],2,2,wf4(:,6),wf24(:,47))
  call Hloop_QA_V(ntryL,G0H96(1),wf4(:,6),G0H24(118),m3h4x24(:,1182),heltab2x96(:,:,5036))
  Gcoeff(:)%j = (c(154)*M(3,:)%j) * den(460)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5165),h0tab(:,5165),[33,30],[nMZ,0],2,2,wf4(:,6),wf24(:,47))
  call Hloop_QA_Z(ntryL,G0H96(1),wf4(:,6),G0H24(144),ngZu,m3h4x24(:,1183),heltab2x96(:,:,5037))
  Gcoeff(:)%j = (c(108)*M(3,:)%j) * den(460)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5166),h0tab(:,5166),[33,30],[nMW,0],2,2,wf4(:,6),wf24(:,47))
  call Hloop_QA_W(ntryL,G0H96(1),wf4(:,6),G0H24(147),m3h4x24(:,1184),heltab2x96(:,:,5038))
  Gcoeff(:)%j = (c(178)*M(2,:)%j) * den(460)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5167),h0tab(:,5167),[33,30],[0,0],2,2,wf4(:,6),wf24(:,47))
  call Hloop_QA_V(ntryL,G0H96(1),wf4(:,6),G0H24(150),m3h4x24(:,1185),heltab2x96(:,:,5039))
  Gcoeff(:)%j = (c(129)*M(3,:)%j) * den(461)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5168),h0tab(:,5168),[33,30],[0,0],2,2,wf4(:,6),wf24(:,49))
  call Hloop_QA_V(ntryL,G0H96(1),wf4(:,6),G0H24(151),m3h4x24(:,1186),heltab2x96(:,:,5040))
  Gcoeff(:)%j = (c(131)*M(3,:)%j) * den(461)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5169),h0tab(:,5169),[33,30],[nMZ,0],2,2,wf4(:,6),wf24(:,49))
  call Hloop_QA_Z(ntryL,G0H96(1),wf4(:,6),G0H24(152),ngZu,m3h4x24(:,1187),heltab2x96(:,:,5041))
  Gcoeff(:)%j = (c(63)*M(3,:)%j) * den(461)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5170),h0tab(:,5170),[33,30],[nMW,0],2,2,wf4(:,6),wf24(:,49))
  call Hloop_QA_W(ntryL,G0H96(1),wf4(:,6),G0H24(162),m3h4x24(:,1188),heltab2x96(:,:,5042))
  Gcoeff(:)%j = (c(136)*M(2,:)%j) * den(461)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5171),h0tab(:,5171),[33,30],[0,0],2,2,wf4(:,6),wf24(:,49))
  call Hloop_QA_V(ntryL,G0H96(1),wf4(:,6),G0H24(159),m3h4x24(:,1189),heltab2x96(:,:,5043))
  Gcoeff(:)%j = (c(144)*M(3,:)%j) * den(462)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5172),h0tab(:,5172),[40,23],[0,0],2,2,wf4(:,3),wf24(:,31))
  call Hloop_AQ_V(ntryL,G0H96(1),wf4(:,3),G0H24(160),m3h4x24(:,1190),heltab2x96(:,:,5044))
  Gcoeff(:)%j = (c(153)*M(3,:)%j) * den(462)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5173),h0tab(:,5173),[40,23],[nMZ,0],2,2,wf4(:,3),wf24(:,31))
  call Hloop_AQ_Z(ntryL,G0H96(1),wf4(:,3),G0H24(161),ngZd,m3h4x24(:,1191),heltab2x96(:,:,5045))
  Gcoeff(:)%j = (c(107)*M(3,:)%j) * den(462)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5174),h0tab(:,5174),[40,23],[nMW,0],2,2,wf4(:,3),wf24(:,31))
  call Hloop_AQ_W(ntryL,G0H96(1),wf4(:,3),G0H24(163),m3h4x24(:,1192),heltab2x96(:,:,5046))
  Gcoeff(:)%j = (c(175)*M(2,:)%j) * den(462)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5175),h0tab(:,5175),[40,23],[0,0],2,2,wf4(:,3),wf24(:,31))
  call Hloop_AQ_V(ntryL,G0H96(1),wf4(:,3),G0H24(170),m3h4x24(:,1193),heltab2x96(:,:,5047))
  Gcoeff(:)%j = (c(147)*M(3,:)%j) * den(463)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5176),h0tab(:,5176),[40,23],[0,0],2,2,wf4(:,3),wf24(:,33))
  call Hloop_AQ_V(ntryL,G0H96(1),wf4(:,3),G0H24(171),m3h4x24(:,1194),heltab2x96(:,:,5048))
  Gcoeff(:)%j = (c(155)*M(3,:)%j) * den(463)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5177),h0tab(:,5177),[40,23],[nMZ,0],2,2,wf4(:,3),wf24(:,33))
  call Hloop_AQ_Z(ntryL,G0H96(1),wf4(:,3),G0H24(172),ngZd,m3h4x24(:,1195),heltab2x96(:,:,5049))
  Gcoeff(:)%j = (c(109)*M(3,:)%j) * den(463)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5178),h0tab(:,5178),[40,23],[nMW,0],2,2,wf4(:,3),wf24(:,33))
  call Hloop_AQ_W(ntryL,G0H96(1),wf4(:,3),G0H24(182),m3h4x24(:,1196),heltab2x96(:,:,5050))
  Gcoeff(:)%j = (c(181)*M(2,:)%j) * den(463)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5179),h0tab(:,5179),[40,23],[0,0],2,2,wf4(:,3),wf24(:,33))
  call Hloop_AQ_V(ntryL,G0H96(1),wf4(:,3),G0H24(179),m3h4x24(:,1197),heltab2x96(:,:,5051))
  Gcoeff(:)%j = (-(c(166)*M(2,:)%j)+c(167)*M(6,:)%j) * den(462)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5180),h0tab(:,5180),[40,23],[0,0],2,2,wf4(:,3),wf24(:,31))
  call Hloop_AQ_V(ntryL,G0H96(1),wf4(:,3),G0H24(180),m3h4x24(:,1198),heltab2x96(:,:,5052))
  Gcoeff(:)%j = (-(c(179)*M(2,:)%j)+c(180)*M(6,:)%j) * den(462)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5181),h0tab(:,5181),[40,23],[nMZ,0],2,2,wf4(:,3),wf24(:,31))
  call Hloop_AQ_Z(ntryL,G0H96(1),wf4(:,3),G0H24(181),ngZd,m3h4x24(:,1199),heltab2x96(:,:,5053))
  Gcoeff(:)%j = (-(c(112)*M(2,:)%j)+c(113)*M(6,:)%j) * den(462)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5182),h0tab(:,5182),[40,23],[nMW,0],2,2,wf4(:,3),wf24(:,31))
  call Hloop_AQ_W(ntryL,G0H96(1),wf4(:,3),G0H24(183),m3h4x24(:,1200),heltab2x96(:,:,5054))
  Gcoeff(:)%j = (c(149)*M(3,:)%j) * den(231)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5183),h0tab(:,5183),[56,7],[0,0],2,2,wf12(:,63),wf8(:,7))
  call Hloop_VQ_A(ntryL,G0H96(1),wf12(:,63),G0H8(23),m3h12x8(:,224),heltab2x96(:,:,5055))
  call Hloop_Q_A(ntryL,G0H8(23),56,0,G1H8(41),n2h8(241))
  Gcoeff(:)%j = (c(153)*M(3,:)%j) * den(231)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5184),h0tab(:,5184),[56,7],[0,nMZ],2,2,wf12(:,63),wf8(:,7))
  call Hloop_ZQ_A(ntryL,G0H96(1),wf12(:,63),G0H8(19),ngZu,m3h12x8(:,225),heltab2x96(:,:,5056))
  call Hloop_Q_A(ntryL,G0H8(19),56,0,G1H8(49),n2h8(242))
  Gcoeff(:)%j = (c(107)*M(3,:)%j) * den(231)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5185),h0tab(:,5185),[56,7],[0,nMW],2,2,wf12(:,63),wf8(:,7))
  call Hloop_WQ_A(ntryL,G0H96(1),wf12(:,63),G0H8(45),m3h12x8(:,226),heltab2x96(:,:,5057))
  call Hloop_Q_A(ntryL,G0H8(45),56,0,G1H8(54),n2h8(243))
  Gcoeff(:)%j = (c(175)*M(2,:)%j) * den(231)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5186),h0tab(:,5186),[56,7],[0,0],2,2,wf12(:,63),wf8(:,7))
  call Hloop_VQ_A(ntryL,G0H96(1),wf12(:,63),G0H8(46),m3h12x8(:,227),heltab2x96(:,:,5058))
  call Hloop_Q_A(ntryL,G0H8(46),56,0,G1H8(16),n2h8(244))
  Gcoeff(:)%j = (c(153)*M(3,:)%j) * den(232)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5187),h0tab(:,5187),[56,7],[0,0],2,2,wf12(:,63),wf8(:,9))
  call Hloop_VQ_A(ntryL,G0H96(1),wf12(:,63),G0H8(8),m3h12x8(:,228),heltab2x96(:,:,5059))
  call Hloop_Q_A(ntryL,G0H8(8),56,0,G1H8(19),n2h8(245))
  Gcoeff(:)%j = (c(155)*M(3,:)%j) * den(232)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5188),h0tab(:,5188),[56,7],[0,nMZ],2,2,wf12(:,63),wf8(:,9))
  call Hloop_ZQ_A(ntryL,G0H96(1),wf12(:,63),G0H8(3),ngZu,m3h12x8(:,229),heltab2x96(:,:,5060))
  call Hloop_Q_A(ntryL,G0H8(3),56,0,G1H8(25),n2h8(246))
  Gcoeff(:)%j = (c(109)*M(3,:)%j) * den(232)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5189),h0tab(:,5189),[56,7],[0,nMW],2,2,wf12(:,63),wf8(:,9))
  call Hloop_WQ_A(ntryL,G0H96(1),wf12(:,63),G0H8(4),m3h12x8(:,230),heltab2x96(:,:,5061))
  call Hloop_Q_A(ntryL,G0H8(4),56,0,G1H8(26),n2h8(247))
  Gcoeff(:)%j = (c(181)*M(2,:)%j) * den(232)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5190),h0tab(:,5190),[56,7],[0,0],2,2,wf12(:,63),wf8(:,9))
  call Hloop_VQ_A(ntryL,G0H96(1),wf12(:,63),G0H8(26),m3h12x8(:,231),heltab2x96(:,:,5062))
  call Hloop_Q_A(ntryL,G0H8(26),56,0,G1H8(114),n2h8(248))
  Gcoeff(:)%j = (-(c(173)*M(2,:)%j)+c(174)*M(6,:)%j) * den(231)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5191),h0tab(:,5191),[56,7],[0,0],2,2,wf12(:,63),wf8(:,7))
  call Hloop_VQ_A(ntryL,G0H96(1),wf12(:,63),G0H8(9),m3h12x8(:,232),heltab2x96(:,:,5063))
  call Hloop_Q_A(ntryL,G0H8(9),56,0,G1H8(115),n2h8(249))
  Gcoeff(:)%j = (-(c(179)*M(2,:)%j)+c(180)*M(6,:)%j) * den(231)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5192),h0tab(:,5192),[56,7],[0,nMZ],2,2,wf12(:,63),wf8(:,7))
  call Hloop_ZQ_A(ntryL,G0H96(1),wf12(:,63),G0H8(2),ngZu,m3h12x8(:,233),heltab2x96(:,:,5064))
  call Hloop_Q_A(ntryL,G0H8(2),56,0,G1H8(116),n2h8(250))
  Gcoeff(:)%j = (-(c(112)*M(2,:)%j)+c(113)*M(6,:)%j) * den(231)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5193),h0tab(:,5193),[56,7],[0,nMW],2,2,wf12(:,63),wf8(:,7))
  call Hloop_WQ_A(ntryL,G0H96(1),wf12(:,63),G0H8(30),m3h12x8(:,234),heltab2x96(:,:,5065))
  call Hloop_Q_A(ntryL,G0H8(30),56,0,G1H8(117),n2h8(251))
  Gcoeff(:)%j = (-(c(215)*M(3,:)%j)) * den(464)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5194),h0tab(:,5194),[57,6],[nME,nME],2,2,wf24(:,112),wf4(:,7))
  call Hloop_QS_A(ntryL,G0H96(1),wf24(:,112),G0H4(171),ngH,m3h24x4(:,1025),heltab2x96(:,:,5066))
  call Hloop_Q_A(ntryL,G0H4(171),57,nME,G1H4(504),n2h4(942))
  Gcoeff(:)%j = (-(c(217)*M(3,:)%j)) * den(464)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5195),h0tab(:,5195),[57,6],[nMM,nMM],2,2,wf24(:,112),wf4(:,7))
  call Hloop_QS_A(ntryL,G0H96(1),wf24(:,112),G0H4(171),ngH,m3h24x4(:,1026),heltab2x96(:,:,5067))
  call Hloop_Q_A(ntryL,G0H4(171),57,nMM,G1H4(505),n2h4(943))
  Gcoeff(:)%j = (-(c(216)*M(3,:)%j)) * den(464)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5196),h0tab(:,5196),[57,6],[nML,nML],2,2,wf24(:,112),wf4(:,7))
  call Hloop_QS_A(ntryL,G0H96(1),wf24(:,112),G0H4(171),ngH,m3h24x4(:,1027),heltab2x96(:,:,5068))
  call Hloop_Q_A(ntryL,G0H4(171),57,nML,G1H4(506),n2h4(944))
  Gcoeff(:)%j = (-(c(218)*M(3,:)%j)) * den(464)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5197),h0tab(:,5197),[57,6],[nMT,nMT],2,2,wf24(:,112),wf4(:,7))
  call Hloop_QS_A(ntryL,G0H96(1),wf24(:,112),G0H4(171),ngH,m3h24x4(:,1028),heltab2x96(:,:,5069))
  call Hloop_Q_A(ntryL,G0H4(171),57,nMT,G1H4(507),n2h4(945))
  Gcoeff(:)%j = (-(c(214)*M(3,:)%j)) * den(464)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5198),h0tab(:,5198),[57,6],[nMB,nMB],2,2,wf24(:,112),wf4(:,7))
  call Hloop_QS_A(ntryL,G0H96(1),wf24(:,112),G0H4(171),ngH,m3h24x4(:,1029),heltab2x96(:,:,5070))
  call Hloop_Q_A(ntryL,G0H4(171),57,nMB,G1H4(508),n2h4(946))
  Gcoeff(:)%j = (-(c(215)*M(3,:)%j)) * den(465)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5199),h0tab(:,5199),[57,6],[nME,nME],2,2,wf24(:,112),wf4(:,17))
  call Hloop_QS_A(ntryL,G0H96(1),wf24(:,112),G0H4(171),ngH,m3h24x4(:,1030),heltab2x96(:,:,5071))
  call Hloop_Q_A(ntryL,G0H4(171),57,nME,G1H4(509),n2h4(947))
  Gcoeff(:)%j = (-(c(217)*M(3,:)%j)) * den(465)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5200),h0tab(:,5200),[57,6],[nMM,nMM],2,2,wf24(:,112),wf4(:,17))
  call Hloop_QS_A(ntryL,G0H96(1),wf24(:,112),G0H4(171),ngH,m3h24x4(:,1031),heltab2x96(:,:,5072))
  call Hloop_Q_A(ntryL,G0H4(171),57,nMM,G1H4(510),n2h4(948))
  Gcoeff(:)%j = (-(c(216)*M(3,:)%j)) * den(465)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5201),h0tab(:,5201),[57,6],[nML,nML],2,2,wf24(:,112),wf4(:,17))
  call Hloop_QS_A(ntryL,G0H96(1),wf24(:,112),G0H4(171),ngH,m3h24x4(:,1032),heltab2x96(:,:,5073))
  call Hloop_Q_A(ntryL,G0H4(171),57,nML,G1H4(511),n2h4(949))
  Gcoeff(:)%j = (c(218)*M(3,:)%j) * den(465)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5202),h0tab(:,5202),[57,6],[nMT,nMT],2,2,wf24(:,112),wf4(:,17))
  call Hloop_QS_A(ntryL,G0H96(1),wf24(:,112),G0H4(171),ngH,m3h24x4(:,1033),heltab2x96(:,:,5074))
  call Hloop_Q_A(ntryL,G0H4(171),57,nMT,G1H4(512),n2h4(950))
  Gcoeff(:)%j = (-(c(214)*M(3,:)%j)) * den(465)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5203),h0tab(:,5203),[57,6],[nMB,nMB],2,2,wf24(:,112),wf4(:,17))
  call Hloop_QS_A(ntryL,G0H96(1),wf24(:,112),G0H4(171),ngH,m3h24x4(:,1034),heltab2x96(:,:,5075))
  call Hloop_Q_A(ntryL,G0H4(171),57,nMB,G1H4(513),n2h4(951))
  Gcoeff(:)%j = (c(18)*M(3,:)%j) * den(464)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5204),h0tab(:,5204),[57,6],[nMH,nMH],2,2,wf24(:,112),wf4(:,7))
  call Hloop_SS_S(ntryL,G0H96(1),wf24(:,112),G0H4(171),m3h24x4(:,1035),heltab2x96(:,:,5076))
  Gcoeff(:)%j = (c(16)*M(3,:)%j) * den(464)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5205),h0tab(:,5205),[57,6],[nMZ,nMZ],2,2,wf24(:,112),wf4(:,7))
  call Hloop_SS_S(ntryL,G0H96(1),wf24(:,112),G0H4(172),m3h24x4(:,1036),heltab2x96(:,:,5077))
  Gcoeff(:)%j = (c(17)*M(3,:)%j) * den(464)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5206),h0tab(:,5206),[57,6],[nMW,nMW],2,2,wf24(:,112),wf4(:,7))
  call Hloop_SS_S(ntryL,G0H96(1),wf24(:,112),G0H4(173),m3h24x4(:,1037),heltab2x96(:,:,5078))
  Gcoeff(:)%j = (-(c(26)*M(3,:)%j)) * den(464)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5207),h0tab(:,5207),[57,6],[nMZ,nMZ],2,2,wf24(:,112),wf4(:,7))
  call Hloop_SS_S(ntryL,G0H96(1),wf24(:,112),G0H4(174),m3h24x4(:,1038),heltab2x96(:,:,5079))
  Gcoeff(:)%j = (-(c(24)*M(3,:)%j)) * den(464)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5208),h0tab(:,5208),[57,6],[nMW,nMW],2,2,wf24(:,112),wf4(:,7))
  call Hloop_SS_S(ntryL,G0H96(1),wf24(:,112),G0H4(175),m3h24x4(:,1039),heltab2x96(:,:,5080))
  Gcoeff(:)%j = (-(c(24)*M(3,:)%j)) * den(464)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5209),h0tab(:,5209),[57,6],[nMW,nMW],2,2,wf24(:,112),wf4(:,7))
  call Hloop_SS_S(ntryL,G0H96(1),wf24(:,112),G0H4(176),m3h24x4(:,1040),heltab2x96(:,:,5081))
  Gcoeff(:)%j = (-(c(24)*M(3,:)%j)) * den(465)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5210),h0tab(:,5210),[57,6],[nMW,nMW],2,2,wf24(:,112),wf4(:,17))
  call Hloop_SS_S(ntryL,G0H96(1),wf24(:,112),G0H4(177),m3h24x4(:,1041),heltab2x96(:,:,5082))
  Gcoeff(:)%j = (c(24)*M(3,:)%j) * den(465)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5211),h0tab(:,5211),[57,6],[nMW,nMW],2,2,wf24(:,112),wf4(:,17))
  call Hloop_SS_S(ntryL,G0H96(1),wf24(:,112),G0H4(178),m3h24x4(:,1042),heltab2x96(:,:,5083))
  Gcoeff(:)%j = (c(27)*M(3,:)%j) * den(464)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5212),h0tab(:,5212),[57,6],[nMZ,nMZ],2,2,wf24(:,112),wf4(:,7))
  call Hloop_VS_V(ntryL,G0H96(1),wf24(:,112),G0H4(179),m3h24x4(:,1043),heltab2x96(:,:,5084))
  Gcoeff(:)%j = (c(25)*M(3,:)%j) * den(464)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5213),h0tab(:,5213),[57,6],[nMW,nMW],2,2,wf24(:,112),wf4(:,7))
  call Hloop_VS_V(ntryL,G0H96(1),wf24(:,112),G0H4(180),m3h24x4(:,1044),heltab2x96(:,:,5085))
  Gcoeff(:)%j = (c(7)*M(3,:)%j) * den(464)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5214),h0tab(:,5214),[57,6],[nMZ,nMZ],2,2,wf24(:,112),wf4(:,7))
  call Hloop_VT_S(ntryL,G0H96(1),0,wf24(:,112),57,G1H4(514),m3h24x4(:,1045),heltab2x96(:,:,5086))
  Gcoeff(:)%j = (c(4)*M(3,:)%j) * den(464)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5215),h0tab(:,5215),[57,6],[nMW,nMW],2,2,wf24(:,112),wf4(:,7))
  call Hloop_VT_S(ntryL,G0H96(1),0,wf24(:,112),57,G1H4(515),m3h24x4(:,1046),heltab2x96(:,:,5087))
  Gcoeff(:)%j = (c(4)*M(3,:)%j) * den(464)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5216),h0tab(:,5216),[57,6],[nMW,nMW],2,2,wf24(:,112),wf4(:,7))
  call Hloop_VT_S(ntryL,G0H96(1),0,wf24(:,112),57,G1H4(516),m3h24x4(:,1047),heltab2x96(:,:,5088))
  Gcoeff(:)%j = (-(c(4)*M(3,:)%j)) * den(465)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5217),h0tab(:,5217),[57,6],[nMW,nMW],2,2,wf24(:,112),wf4(:,17))
  call Hloop_VT_S(ntryL,G0H96(1),0,wf24(:,112),57,G1H4(517),m3h24x4(:,1048),heltab2x96(:,:,5089))
  Gcoeff(:)%j = (c(4)*M(3,:)%j) * den(465)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5218),h0tab(:,5218),[57,6],[nMW,nMW],2,2,wf24(:,112),wf4(:,17))
  call Hloop_VT_S(ntryL,G0H96(1),0,wf24(:,112),57,G1H4(518),m3h24x4(:,1049),heltab2x96(:,:,5090))
  Gcoeff(:)%j = (-(c(262)*M(3,:)%j)) * den(466)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5219),h0tab(:,5219),[57,6],[nME,nME],2,2,wf24(:,113),wf4(:,7))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,113),G0H4(181),m3h24x4(:,1050),heltab2x96(:,:,5091))
  call Hloop_Q_A(ntryL,G0H4(181),57,nME,G1H4(519),n2h4(952))
  Gcoeff(:)%j = (-(c(268)*M(3,:)%j)) * den(466)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5220),h0tab(:,5220),[57,6],[nMM,nMM],2,2,wf24(:,113),wf4(:,7))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,113),G0H4(181),m3h24x4(:,1051),heltab2x96(:,:,5092))
  call Hloop_Q_A(ntryL,G0H4(181),57,nMM,G1H4(520),n2h4(953))
  Gcoeff(:)%j = (-(c(265)*M(3,:)%j)) * den(466)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5221),h0tab(:,5221),[57,6],[nML,nML],2,2,wf24(:,113),wf4(:,7))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,113),G0H4(181),m3h24x4(:,1052),heltab2x96(:,:,5093))
  call Hloop_Q_A(ntryL,G0H4(181),57,nML,G1H4(521),n2h4(954))
  Gcoeff(:)%j = (c(271)*M(3,:)%j) * den(466)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5222),h0tab(:,5222),[57,6],[nMT,nMT],2,2,wf24(:,113),wf4(:,7))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,113),G0H4(181),m3h24x4(:,1053),heltab2x96(:,:,5094))
  call Hloop_Q_A(ntryL,G0H4(181),57,nMT,G1H4(522),n2h4(955))
  Gcoeff(:)%j = (-(c(257)*M(3,:)%j)) * den(466)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5223),h0tab(:,5223),[57,6],[nMB,nMB],2,2,wf24(:,113),wf4(:,7))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,113),G0H4(181),m3h24x4(:,1054),heltab2x96(:,:,5095))
  call Hloop_Q_A(ntryL,G0H4(181),57,nMB,G1H4(523),n2h4(956))
  Gcoeff(:)%j = (c(236)*M(3,:)%j) * den(467)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5224),h0tab(:,5224),[57,6],[nME,nME],2,2,wf24(:,113),wf4(:,7))
  call Hloop_QZ_A(ntryL,G0H96(1),wf24(:,113),G0H4(181),ngZl,m3h24x4(:,1055),heltab2x96(:,:,5096))
  call Hloop_Q_A(ntryL,G0H4(181),57,nME,G1H4(524),n2h4(957))
  Gcoeff(:)%j = (c(238)*M(3,:)%j) * den(467)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5225),h0tab(:,5225),[57,6],[nMM,nMM],2,2,wf24(:,113),wf4(:,7))
  call Hloop_QZ_A(ntryL,G0H96(1),wf24(:,113),G0H4(181),ngZl,m3h24x4(:,1056),heltab2x96(:,:,5097))
  call Hloop_Q_A(ntryL,G0H4(181),57,nMM,G1H4(525),n2h4(958))
  Gcoeff(:)%j = (c(237)*M(3,:)%j) * den(467)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5226),h0tab(:,5226),[57,6],[nML,nML],2,2,wf24(:,113),wf4(:,7))
  call Hloop_QZ_A(ntryL,G0H96(1),wf24(:,113),G0H4(181),ngZl,m3h24x4(:,1057),heltab2x96(:,:,5098))
  call Hloop_Q_A(ntryL,G0H4(181),57,nML,G1H4(526),n2h4(959))
  Gcoeff(:)%j = (c(239)*M(3,:)%j) * den(467)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5227),h0tab(:,5227),[57,6],[nMT,nMT],2,2,wf24(:,113),wf4(:,7))
  call Hloop_QZ_A(ntryL,G0H96(1),wf24(:,113),G0H4(181),ngZu,m3h24x4(:,1058),heltab2x96(:,:,5099))
  call Hloop_Q_A(ntryL,G0H4(181),57,nMT,G1H4(527),n2h4(960))
  Gcoeff(:)%j = (c(235)*M(3,:)%j) * den(467)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5228),h0tab(:,5228),[57,6],[nMB,nMB],2,2,wf24(:,113),wf4(:,7))
  call Hloop_QZ_A(ntryL,G0H96(1),wf24(:,113),G0H4(181),ngZd,m3h24x4(:,1059),heltab2x96(:,:,5100))
  call Hloop_Q_A(ntryL,G0H4(181),57,nMB,G1H4(528),n2h4(961))
  Gcoeff(:)%j = (-(c(262)*M(3,:)%j)) * den(468)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5229),h0tab(:,5229),[57,6],[nME,nME],2,2,wf24(:,113),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,113),G0H4(181),m3h24x4(:,1060),heltab2x96(:,:,5101))
  call Hloop_Q_A(ntryL,G0H4(181),57,nME,G1H4(529),n2h4(962))
  Gcoeff(:)%j = (-(c(268)*M(3,:)%j)) * den(468)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5230),h0tab(:,5230),[57,6],[nMM,nMM],2,2,wf24(:,113),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,113),G0H4(181),m3h24x4(:,1061),heltab2x96(:,:,5102))
  call Hloop_Q_A(ntryL,G0H4(181),57,nMM,G1H4(530),n2h4(963))
  Gcoeff(:)%j = (-(c(265)*M(3,:)%j)) * den(468)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5231),h0tab(:,5231),[57,6],[nML,nML],2,2,wf24(:,113),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,113),G0H4(181),m3h24x4(:,1062),heltab2x96(:,:,5103))
  call Hloop_Q_A(ntryL,G0H4(181),57,nML,G1H4(531),n2h4(964))
  Gcoeff(:)%j = (-(c(271)*M(3,:)%j)) * den(468)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5232),h0tab(:,5232),[57,6],[nMT,nMT],2,2,wf24(:,113),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,113),G0H4(181),m3h24x4(:,1063),heltab2x96(:,:,5104))
  call Hloop_Q_A(ntryL,G0H4(181),57,nMT,G1H4(532),n2h4(965))
  Gcoeff(:)%j = (-(c(257)*M(3,:)%j)) * den(468)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5233),h0tab(:,5233),[57,6],[nMB,nMB],2,2,wf24(:,113),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,113),G0H4(181),m3h24x4(:,1064),heltab2x96(:,:,5105))
  call Hloop_Q_A(ntryL,G0H4(181),57,nMB,G1H4(533),n2h4(966))
  Gcoeff(:)%j = (c(236)*M(3,:)%j) * den(469)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5234),h0tab(:,5234),[57,6],[nME,nME],2,2,wf24(:,113),wf4(:,17))
  call Hloop_QZ_A(ntryL,G0H96(1),wf24(:,113),G0H4(181),ngZl,m3h24x4(:,1065),heltab2x96(:,:,5106))
  call Hloop_Q_A(ntryL,G0H4(181),57,nME,G1H4(534),n2h4(967))
  Gcoeff(:)%j = (c(238)*M(3,:)%j) * den(469)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5235),h0tab(:,5235),[57,6],[nMM,nMM],2,2,wf24(:,113),wf4(:,17))
  call Hloop_QZ_A(ntryL,G0H96(1),wf24(:,113),G0H4(181),ngZl,m3h24x4(:,1066),heltab2x96(:,:,5107))
  call Hloop_Q_A(ntryL,G0H4(181),57,nMM,G1H4(535),n2h4(968))
  Gcoeff(:)%j = (c(237)*M(3,:)%j) * den(469)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5236),h0tab(:,5236),[57,6],[nML,nML],2,2,wf24(:,113),wf4(:,17))
  call Hloop_QZ_A(ntryL,G0H96(1),wf24(:,113),G0H4(181),ngZl,m3h24x4(:,1067),heltab2x96(:,:,5108))
  call Hloop_Q_A(ntryL,G0H4(181),57,nML,G1H4(536),n2h4(969))
  Gcoeff(:)%j = (-(c(239)*M(3,:)%j)) * den(469)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5237),h0tab(:,5237),[57,6],[nMT,nMT],2,2,wf24(:,113),wf4(:,17))
  call Hloop_QZ_A(ntryL,G0H96(1),wf24(:,113),G0H4(181),ngZu,m3h24x4(:,1068),heltab2x96(:,:,5109))
  call Hloop_Q_A(ntryL,G0H4(181),57,nMT,G1H4(537),n2h4(970))
  Gcoeff(:)%j = (c(235)*M(3,:)%j) * den(469)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5238),h0tab(:,5238),[57,6],[nMB,nMB],2,2,wf24(:,113),wf4(:,17))
  call Hloop_QZ_A(ntryL,G0H96(1),wf24(:,113),G0H4(181),ngZd,m3h24x4(:,1069),heltab2x96(:,:,5110))
  call Hloop_Q_A(ntryL,G0H4(181),57,nMB,G1H4(538),n2h4(971))
  Gcoeff(:)%j = (-(c(91)*M(3,:)%j)) * den(466)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5239),h0tab(:,5239),[57,6],[nMW,nMW],2,2,wf24(:,113),wf4(:,7))
  call Hloop_TV_S(ntryL,G0H96(1),0,wf24(:,113),57,G1H4(539),m3h24x4(:,1070),heltab2x96(:,:,5111))
  Gcoeff(:)%j = (c(194)*M(3,:)%j) * den(467)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5240),h0tab(:,5240),[57,6],[nMW,nMW],2,2,wf24(:,113),wf4(:,7))
  call Hloop_TV_S(ntryL,G0H96(1),0,wf24(:,113),57,G1H4(540),m3h24x4(:,1071),heltab2x96(:,:,5112))
  Gcoeff(:)%j = (-(c(14)*M(3,:)%j)) * den(469)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5241),h0tab(:,5241),[57,6],[nMH,nMZ],2,2,wf24(:,113),wf4(:,17))
  call Hloop_SV_T(ntryL,G0H96(1),0,wf24(:,113),57,G1H4(541),m3h24x4(:,1072),heltab2x96(:,:,5113))
  Gcoeff(:)%j = (-(c(78)*M(3,:)%j)) * den(466)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5242),h0tab(:,5242),[57,6],[nMW,nMW],2,2,wf24(:,113),wf4(:,7))
  call Hloop_CV_D(ntryL,G0H96(1),0,wf24(:,113),57,G1H4(542),m3h24x4(:,1073),heltab2x96(:,:,5114))
  Gcoeff(:)%j = (c(78)*M(3,:)%j) * den(466)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5243),h0tab(:,5243),[57,6],[nMW,nMW],2,2,wf24(:,113),wf4(:,7))
  call Hloop_CV_D(ntryL,G0H96(1),0,wf24(:,113),57,G1H4(543),m3h24x4(:,1074),heltab2x96(:,:,5115))
  Gcoeff(:)%j = (-(c(9)*M(3,:)%j)) * den(467)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5244),h0tab(:,5244),[57,6],[nMW,nMW],2,2,wf24(:,113),wf4(:,7))
  call Hloop_CV_D(ntryL,G0H96(1),0,wf24(:,113),57,G1H4(544),m3h24x4(:,1075),heltab2x96(:,:,5116))
  Gcoeff(:)%j = (c(9)*M(3,:)%j) * den(467)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5245),h0tab(:,5245),[57,6],[nMW,nMW],2,2,wf24(:,113),wf4(:,7))
  call Hloop_CV_D(ntryL,G0H96(1),0,wf24(:,113),57,G1H4(545),m3h24x4(:,1076),heltab2x96(:,:,5117))
  Gcoeff(:)%j = (-(c(78)*M(3,:)%j)) * den(468)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5246),h0tab(:,5246),[57,6],[nMW,nMW],2,2,wf24(:,113),wf4(:,17))
  call Hloop_CV_D(ntryL,G0H96(1),0,wf24(:,113),57,G1H4(546),m3h24x4(:,1077),heltab2x96(:,:,5118))
  Gcoeff(:)%j = (-(c(78)*M(3,:)%j)) * den(468)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5247),h0tab(:,5247),[57,6],[nMW,nMW],2,2,wf24(:,113),wf4(:,17))
  call Hloop_CV_D(ntryL,G0H96(1),0,wf24(:,113),57,G1H4(547),m3h24x4(:,1078),heltab2x96(:,:,5119))
  Gcoeff(:)%j = (-(c(9)*M(3,:)%j)) * den(469)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5248),h0tab(:,5248),[57,6],[nMW,nMW],2,2,wf24(:,113),wf4(:,17))
  call Hloop_CV_D(ntryL,G0H96(1),0,wf24(:,113),57,G1H4(548),m3h24x4(:,1079),heltab2x96(:,:,5120))
  Gcoeff(:)%j = (-(c(9)*M(3,:)%j)) * den(469)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5249),h0tab(:,5249),[57,6],[nMW,nMW],2,2,wf24(:,113),wf4(:,17))
  call Hloop_CV_D(ntryL,G0H96(1),0,wf24(:,113),57,G1H4(549),m3h24x4(:,1080),heltab2x96(:,:,5121))
  Gcoeff(:)%j = (-(c(80)*M(3,:)%j)) * den(466)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5250),h0tab(:,5250),[57,6],[nMW,nMW],2,2,wf24(:,113),wf4(:,7))
  call Hloop_UV_W(ntryL,G0H96(1),0,wf24(:,113),57,G1H4(550),m3h24x4(:,1081),heltab2x96(:,:,5122))
  Gcoeff(:)%j = (-(c(10)*M(3,:)%j)) * den(467)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5251),h0tab(:,5251),[57,6],[nMW,nMW],2,2,wf24(:,113),wf4(:,7))
  call Hloop_UV_W(ntryL,G0H96(1),0,wf24(:,113),57,G1H4(551),m3h24x4(:,1082),heltab2x96(:,:,5123))
  Gcoeff(:)%j = (c(78)*M(3,:)%j) * den(466)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5252),h0tab(:,5252),[57,6],[nMW,nMW],2,2,wf24(:,113),wf4(:,7))
  call Hloop_VV_S(ntryL,G0H96(1),wf24(:,113),G0H4(181),m3h24x4(:,1083),heltab2x96(:,:,5124))
  Gcoeff(:)%j = (-(c(78)*M(3,:)%j)) * den(466)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5253),h0tab(:,5253),[57,6],[nMW,nMW],2,2,wf24(:,113),wf4(:,7))
  call Hloop_VV_S(ntryL,G0H96(1),wf24(:,113),G0H4(182),m3h24x4(:,1084),heltab2x96(:,:,5125))
  Gcoeff(:)%j = (-(c(78)*M(3,:)%j)) * den(467)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5254),h0tab(:,5254),[57,6],[nMW,nMW],2,2,wf24(:,113),wf4(:,7))
  call Hloop_VV_S(ntryL,G0H96(1),wf24(:,113),G0H4(183),m3h24x4(:,1085),heltab2x96(:,:,5126))
  Gcoeff(:)%j = (c(78)*M(3,:)%j) * den(467)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5255),h0tab(:,5255),[57,6],[nMW,nMW],2,2,wf24(:,113),wf4(:,7))
  call Hloop_VV_S(ntryL,G0H96(1),wf24(:,113),G0H4(184),m3h24x4(:,1086),heltab2x96(:,:,5127))
  Gcoeff(:)%j = (-(c(78)*M(3,:)%j)) * den(468)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5256),h0tab(:,5256),[57,6],[nMW,nMW],2,2,wf24(:,113),wf4(:,17))
  call Hloop_VV_S(ntryL,G0H96(1),wf24(:,113),G0H4(185),m3h24x4(:,1087),heltab2x96(:,:,5128))
  Gcoeff(:)%j = (-(c(78)*M(3,:)%j)) * den(468)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5257),h0tab(:,5257),[57,6],[nMW,nMW],2,2,wf24(:,113),wf4(:,17))
  call Hloop_VV_S(ntryL,G0H96(1),wf24(:,113),G0H4(186),m3h24x4(:,1088),heltab2x96(:,:,5129))
  Gcoeff(:)%j = (-(c(8)*M(3,:)%j)) * den(469)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5258),h0tab(:,5258),[57,6],[nMH,nMZ],2,2,wf24(:,113),wf4(:,17))
  call Hloop_VV_S(ntryL,G0H96(1),wf24(:,113),G0H4(187),m3h24x4(:,1089),heltab2x96(:,:,5130))
  Gcoeff(:)%j = (c(78)*M(3,:)%j) * den(469)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5259),h0tab(:,5259),[57,6],[nMW,nMW],2,2,wf24(:,113),wf4(:,17))
  call Hloop_VV_S(ntryL,G0H96(1),wf24(:,113),G0H4(188),m3h24x4(:,1090),heltab2x96(:,:,5131))
  Gcoeff(:)%j = (c(78)*M(3,:)%j) * den(469)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5260),h0tab(:,5260),[57,6],[nMW,nMW],2,2,wf24(:,113),wf4(:,17))
  call Hloop_VV_S(ntryL,G0H96(1),wf24(:,113),G0H4(189),m3h24x4(:,1091),heltab2x96(:,:,5132))
  Gcoeff(:)%j = (-(c(246)*M(3,:)%j)) * den(470)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5261),h0tab(:,5261),[57,6],[nME,nME],2,2,wf24(:,112),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H96(1),wf24(:,112),G0H4(190),ngH,m3h24x4(:,1092),heltab2x96(:,:,5133))
  call Hloop_Q_A(ntryL,G0H4(190),57,nME,G1H4(552),n2h4(972))
  Gcoeff(:)%j = (-(c(250)*M(3,:)%j)) * den(470)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5262),h0tab(:,5262),[57,6],[nMM,nMM],2,2,wf24(:,112),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H96(1),wf24(:,112),G0H4(190),ngH,m3h24x4(:,1093),heltab2x96(:,:,5134))
  call Hloop_Q_A(ntryL,G0H4(190),57,nMM,G1H4(553),n2h4(973))
  Gcoeff(:)%j = (-(c(248)*M(3,:)%j)) * den(470)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5263),h0tab(:,5263),[57,6],[nML,nML],2,2,wf24(:,112),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H96(1),wf24(:,112),G0H4(190),ngH,m3h24x4(:,1094),heltab2x96(:,:,5135))
  call Hloop_Q_A(ntryL,G0H4(190),57,nML,G1H4(554),n2h4(974))
  Gcoeff(:)%j = (c(252)*M(3,:)%j) * den(470)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5264),h0tab(:,5264),[57,6],[nMT,nMT],2,2,wf24(:,112),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H96(1),wf24(:,112),G0H4(190),ngH,m3h24x4(:,1095),heltab2x96(:,:,5136))
  call Hloop_Q_A(ntryL,G0H4(190),57,nMT,G1H4(555),n2h4(975))
  Gcoeff(:)%j = (-(c(243)*M(3,:)%j)) * den(470)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5265),h0tab(:,5265),[57,6],[nMB,nMB],2,2,wf24(:,112),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H96(1),wf24(:,112),G0H4(190),ngH,m3h24x4(:,1096),heltab2x96(:,:,5137))
  call Hloop_Q_A(ntryL,G0H4(190),57,nMB,G1H4(556),n2h4(976))
  Gcoeff(:)%j = (c(247)*M(3,:)%j) * den(465)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5266),h0tab(:,5266),[57,6],[nME,nME],2,2,wf24(:,112),wf4(:,4))
  call Hloop_QS_A(ntryL,G0H96(1),wf24(:,112),G0H4(190),ngH,m3h24x4(:,1097),heltab2x96(:,:,5138))
  call Hloop_Q_A(ntryL,G0H4(190),57,nME,G1H4(557),n2h4(977))
  Gcoeff(:)%j = (c(251)*M(3,:)%j) * den(465)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5267),h0tab(:,5267),[57,6],[nMM,nMM],2,2,wf24(:,112),wf4(:,4))
  call Hloop_QS_A(ntryL,G0H96(1),wf24(:,112),G0H4(190),ngH,m3h24x4(:,1098),heltab2x96(:,:,5139))
  call Hloop_Q_A(ntryL,G0H4(190),57,nMM,G1H4(558),n2h4(978))
  Gcoeff(:)%j = (c(249)*M(3,:)%j) * den(465)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5268),h0tab(:,5268),[57,6],[nML,nML],2,2,wf24(:,112),wf4(:,4))
  call Hloop_QS_A(ntryL,G0H96(1),wf24(:,112),G0H4(190),ngH,m3h24x4(:,1099),heltab2x96(:,:,5140))
  call Hloop_Q_A(ntryL,G0H4(190),57,nML,G1H4(559),n2h4(979))
  Gcoeff(:)%j = (c(253)*M(3,:)%j) * den(465)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5269),h0tab(:,5269),[57,6],[nMT,nMT],2,2,wf24(:,112),wf4(:,4))
  call Hloop_QS_A(ntryL,G0H96(1),wf24(:,112),G0H4(190),ngH,m3h24x4(:,1100),heltab2x96(:,:,5141))
  call Hloop_Q_A(ntryL,G0H4(190),57,nMT,G1H4(560),n2h4(980))
  Gcoeff(:)%j = (c(244)*M(3,:)%j) * den(465)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5270),h0tab(:,5270),[57,6],[nMB,nMB],2,2,wf24(:,112),wf4(:,4))
  call Hloop_QS_A(ntryL,G0H96(1),wf24(:,112),G0H4(190),ngH,m3h24x4(:,1101),heltab2x96(:,:,5142))
  call Hloop_Q_A(ntryL,G0H4(190),57,nMB,G1H4(561),n2h4(981))
  Gcoeff(:)%j = (-(c(72)*M(3,:)%j)) * den(470)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5271),h0tab(:,5271),[57,6],[nMW,nMW],2,2,wf24(:,112),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H96(1),wf24(:,112),G0H4(190),m3h24x4(:,1102),heltab2x96(:,:,5143))
  Gcoeff(:)%j = (c(203)*M(3,:)%j) * den(465)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5272),h0tab(:,5272),[57,6],[nMW,nMW],2,2,wf24(:,112),wf4(:,4))
  call Hloop_SS_S(ntryL,G0H96(1),wf24(:,112),G0H4(191),m3h24x4(:,1103),heltab2x96(:,:,5144))
  Gcoeff(:)%j = (-(c(99)*M(3,:)%j)) * den(470)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5273),h0tab(:,5273),[57,6],[nMW,nMW],2,2,wf24(:,112),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H96(1),wf24(:,112),G0H4(192),m3h24x4(:,1104),heltab2x96(:,:,5145))
  Gcoeff(:)%j = (c(99)*M(3,:)%j) * den(470)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5274),h0tab(:,5274),[57,6],[nMW,nMW],2,2,wf24(:,112),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H96(1),wf24(:,112),G0H4(193),m3h24x4(:,1105),heltab2x96(:,:,5146))
  Gcoeff(:)%j = (-(c(61)*M(3,:)%j)) * den(465)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5275),h0tab(:,5275),[57,6],[nMW,nMW],2,2,wf24(:,112),wf4(:,4))
  call Hloop_SS_S(ntryL,G0H96(1),wf24(:,112),G0H4(194),m3h24x4(:,1106),heltab2x96(:,:,5147))
  Gcoeff(:)%j = (c(61)*M(3,:)%j) * den(465)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5276),h0tab(:,5276),[57,6],[nMW,nMW],2,2,wf24(:,112),wf4(:,4))
  call Hloop_SS_S(ntryL,G0H96(1),wf24(:,112),G0H4(195),m3h24x4(:,1107),heltab2x96(:,:,5148))
  Gcoeff(:)%j = (-(c(100)*M(3,:)%j)) * den(470)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5277),h0tab(:,5277),[57,6],[nMW,nMW],2,2,wf24(:,112),wf4(:,1))
  call Hloop_VS_V(ntryL,G0H96(1),wf24(:,112),G0H4(196),m3h24x4(:,1108),heltab2x96(:,:,5149))
  Gcoeff(:)%j = (-(c(62)*M(3,:)%j)) * den(465)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5278),h0tab(:,5278),[57,6],[nMW,nMW],2,2,wf24(:,112),wf4(:,4))
  call Hloop_VS_V(ntryL,G0H96(1),wf24(:,112),G0H4(197),m3h24x4(:,1109),heltab2x96(:,:,5150))
  Gcoeff(:)%j = (-(c(99)*M(3,:)%j)) * den(470)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5279),h0tab(:,5279),[57,6],[nMW,nMW],2,2,wf24(:,112),wf4(:,1))
  call Hloop_VT_S(ntryL,G0H96(1),0,wf24(:,112),57,G1H4(562),m3h24x4(:,1110),heltab2x96(:,:,5151))
  Gcoeff(:)%j = (c(99)*M(3,:)%j) * den(470)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5280),h0tab(:,5280),[57,6],[nMW,nMW],2,2,wf24(:,112),wf4(:,1))
  call Hloop_VT_S(ntryL,G0H96(1),0,wf24(:,112),57,G1H4(563),m3h24x4(:,1111),heltab2x96(:,:,5152))
  Gcoeff(:)%j = (c(140)*M(3,:)%j) * den(465)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5281),h0tab(:,5281),[57,6],[nMW,nMW],2,2,wf24(:,112),wf4(:,4))
  call Hloop_VT_S(ntryL,G0H96(1),0,wf24(:,112),57,G1H4(564),m3h24x4(:,1112),heltab2x96(:,:,5153))
  Gcoeff(:)%j = (-(c(140)*M(3,:)%j)) * den(465)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5282),h0tab(:,5282),[57,6],[nMW,nMW],2,2,wf24(:,112),wf4(:,4))
  call Hloop_VT_S(ntryL,G0H96(1),0,wf24(:,112),57,G1H4(565),m3h24x4(:,1113),heltab2x96(:,:,5154))
  Gcoeff(:)%j = (-(c(318)*M(3,:)%j)) * den(471)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5283),h0tab(:,5283),[57,6],[nME,nME],2,2,wf24(:,113),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,113),G0H4(198),m3h24x4(:,1114),heltab2x96(:,:,5155))
  call Hloop_Q_A(ntryL,G0H4(198),57,nME,G1H4(566),n2h4(982))
  Gcoeff(:)%j = (-(c(318)*M(3,:)%j)) * den(471)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5284),h0tab(:,5284),[57,6],[nMM,nMM],2,2,wf24(:,113),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,113),G0H4(198),m3h24x4(:,1115),heltab2x96(:,:,5156))
  call Hloop_Q_A(ntryL,G0H4(198),57,nMM,G1H4(567),n2h4(983))
  Gcoeff(:)%j = (-(c(318)*M(3,:)%j)) * den(471)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5285),h0tab(:,5285),[57,6],[nML,nML],2,2,wf24(:,113),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,113),G0H4(198),m3h24x4(:,1116),heltab2x96(:,:,5157))
  call Hloop_Q_A(ntryL,G0H4(198),57,nML,G1H4(568),n2h4(984))
  Gcoeff(:)%j = (-(c(317)*M(3,:)%j)) * den(471)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5286),h0tab(:,5286),[57,6],[0,0],2,2,wf24(:,113),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,113),G0H4(198),m3h24x4(:,1117),heltab2x96(:,:,5158))
  call Hloop_Q_A(ntryL,G0H4(198),57,0,G1H4(569),n2h4(985))
  Gcoeff(:)%j = (-(c(311)*M(3,:)%j)) * den(471)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5287),h0tab(:,5287),[57,6],[nMT,nMT],2,2,wf24(:,113),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,113),G0H4(198),m3h24x4(:,1118),heltab2x96(:,:,5159))
  call Hloop_Q_A(ntryL,G0H4(198),57,nMT,G1H4(570),n2h4(986))
  Gcoeff(:)%j = (-(c(307)*M(3,:)%j)) * den(471)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5288),h0tab(:,5288),[57,6],[0,0],2,2,wf24(:,113),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,113),G0H4(198),m3h24x4(:,1119),heltab2x96(:,:,5160))
  call Hloop_Q_A(ntryL,G0H4(198),57,0,G1H4(571),n2h4(987))
  Gcoeff(:)%j = (-(c(304)*M(3,:)%j)) * den(471)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5289),h0tab(:,5289),[57,6],[nMB,nMB],2,2,wf24(:,113),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,113),G0H4(198),m3h24x4(:,1120),heltab2x96(:,:,5161))
  call Hloop_Q_A(ntryL,G0H4(198),57,nMB,G1H4(572),n2h4(988))
  Gcoeff(:)%j = (c(290)*M(3,:)%j) * den(472)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5290),h0tab(:,5290),[57,6],[nME,nME],2,2,wf24(:,113),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H96(1),wf24(:,113),G0H4(198),ngZl,m3h24x4(:,1121),heltab2x96(:,:,5162))
  call Hloop_Q_A(ntryL,G0H4(198),57,nME,G1H4(573),n2h4(989))
  Gcoeff(:)%j = (c(290)*M(3,:)%j) * den(472)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5291),h0tab(:,5291),[57,6],[nMM,nMM],2,2,wf24(:,113),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H96(1),wf24(:,113),G0H4(198),ngZl,m3h24x4(:,1122),heltab2x96(:,:,5163))
  call Hloop_Q_A(ntryL,G0H4(198),57,nMM,G1H4(574),n2h4(990))
  Gcoeff(:)%j = (c(290)*M(3,:)%j) * den(472)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5292),h0tab(:,5292),[57,6],[nML,nML],2,2,wf24(:,113),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H96(1),wf24(:,113),G0H4(198),ngZl,m3h24x4(:,1123),heltab2x96(:,:,5164))
  call Hloop_Q_A(ntryL,G0H4(198),57,nML,G1H4(575),n2h4(991))
  Gcoeff(:)%j = (-(c(291)*M(3,:)%j)) * den(472)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5293),h0tab(:,5293),[57,6],[0,0],2,2,wf24(:,113),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H96(1),wf24(:,113),G0H4(198),ngZu,m3h24x4(:,1124),heltab2x96(:,:,5165))
  call Hloop_Q_A(ntryL,G0H4(198),57,0,G1H4(576),n2h4(992))
  Gcoeff(:)%j = (-(c(289)*M(3,:)%j)) * den(472)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5294),h0tab(:,5294),[57,6],[nMT,nMT],2,2,wf24(:,113),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H96(1),wf24(:,113),G0H4(198),ngZu,m3h24x4(:,1125),heltab2x96(:,:,5166))
  call Hloop_Q_A(ntryL,G0H4(198),57,nMT,G1H4(577),n2h4(993))
  Gcoeff(:)%j = (c(289)*M(3,:)%j) * den(472)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5295),h0tab(:,5295),[57,6],[0,0],2,2,wf24(:,113),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H96(1),wf24(:,113),G0H4(198),ngZd,m3h24x4(:,1126),heltab2x96(:,:,5167))
  call Hloop_Q_A(ntryL,G0H4(198),57,0,G1H4(578),n2h4(994))
  Gcoeff(:)%j = (c(288)*M(3,:)%j) * den(472)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5296),h0tab(:,5296),[57,6],[nMB,nMB],2,2,wf24(:,113),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H96(1),wf24(:,113),G0H4(198),ngZd,m3h24x4(:,1127),heltab2x96(:,:,5168))
  call Hloop_Q_A(ntryL,G0H4(198),57,nMB,G1H4(579),n2h4(995))
  Gcoeff(:)%j = (c(321)*M(3,:)%j) * den(468)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5297),h0tab(:,5297),[57,6],[nME,nME],2,2,wf24(:,113),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,113),G0H4(198),m3h24x4(:,1128),heltab2x96(:,:,5169))
  call Hloop_Q_A(ntryL,G0H4(198),57,nME,G1H4(580),n2h4(996))
  Gcoeff(:)%j = (c(321)*M(3,:)%j) * den(468)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5298),h0tab(:,5298),[57,6],[nMM,nMM],2,2,wf24(:,113),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,113),G0H4(198),m3h24x4(:,1129),heltab2x96(:,:,5170))
  call Hloop_Q_A(ntryL,G0H4(198),57,nMM,G1H4(581),n2h4(997))
  Gcoeff(:)%j = (c(321)*M(3,:)%j) * den(468)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5299),h0tab(:,5299),[57,6],[nML,nML],2,2,wf24(:,113),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,113),G0H4(198),m3h24x4(:,1130),heltab2x96(:,:,5171))
  call Hloop_Q_A(ntryL,G0H4(198),57,nML,G1H4(582),n2h4(998))
  Gcoeff(:)%j = (-(c(323)*M(3,:)%j)) * den(468)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5300),h0tab(:,5300),[57,6],[0,0],2,2,wf24(:,113),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,113),G0H4(198),m3h24x4(:,1131),heltab2x96(:,:,5172))
  call Hloop_Q_A(ntryL,G0H4(198),57,0,G1H4(583),n2h4(999))
  Gcoeff(:)%j = (-(c(319)*M(3,:)%j)) * den(468)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5301),h0tab(:,5301),[57,6],[nMT,nMT],2,2,wf24(:,113),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,113),G0H4(198),m3h24x4(:,1132),heltab2x96(:,:,5173))
  call Hloop_Q_A(ntryL,G0H4(198),57,nMT,G1H4(584),n2h4(1000))
  Gcoeff(:)%j = (c(319)*M(3,:)%j) * den(468)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5302),h0tab(:,5302),[57,6],[0,0],2,2,wf24(:,113),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,113),G0H4(198),m3h24x4(:,1133),heltab2x96(:,:,5174))
  call Hloop_Q_A(ntryL,G0H4(198),57,0,G1H4(585),n2h4(1001))
  Gcoeff(:)%j = (c(313)*M(3,:)%j) * den(468)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5303),h0tab(:,5303),[57,6],[nMB,nMB],2,2,wf24(:,113),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,113),G0H4(198),m3h24x4(:,1134),heltab2x96(:,:,5175))
  call Hloop_Q_A(ntryL,G0H4(198),57,nMB,G1H4(586),n2h4(1002))
  Gcoeff(:)%j = (-(c(295)*M(3,:)%j)) * den(469)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5304),h0tab(:,5304),[57,6],[0,0],2,2,wf24(:,113),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H96(1),wf24(:,113),G0H4(198),ngZn,m3h24x4(:,1135),heltab2x96(:,:,5176))
  call Hloop_Q_A(ntryL,G0H4(198),57,0,G1H4(587),n2h4(1003))
  Gcoeff(:)%j = (-(c(292)*M(3,:)%j)) * den(469)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5305),h0tab(:,5305),[57,6],[nME,nME],2,2,wf24(:,113),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H96(1),wf24(:,113),G0H4(198),ngZl,m3h24x4(:,1136),heltab2x96(:,:,5177))
  call Hloop_Q_A(ntryL,G0H4(198),57,nME,G1H4(588),n2h4(1004))
  Gcoeff(:)%j = (-(c(292)*M(3,:)%j)) * den(469)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5306),h0tab(:,5306),[57,6],[nMM,nMM],2,2,wf24(:,113),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H96(1),wf24(:,113),G0H4(198),ngZl,m3h24x4(:,1137),heltab2x96(:,:,5178))
  call Hloop_Q_A(ntryL,G0H4(198),57,nMM,G1H4(589),n2h4(1005))
  Gcoeff(:)%j = (-(c(292)*M(3,:)%j)) * den(469)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5307),h0tab(:,5307),[57,6],[nML,nML],2,2,wf24(:,113),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H96(1),wf24(:,113),G0H4(198),ngZl,m3h24x4(:,1138),heltab2x96(:,:,5179))
  call Hloop_Q_A(ntryL,G0H4(198),57,nML,G1H4(590),n2h4(1006))
  Gcoeff(:)%j = (-(c(294)*M(3,:)%j)) * den(469)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5308),h0tab(:,5308),[57,6],[0,0],2,2,wf24(:,113),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H96(1),wf24(:,113),G0H4(198),ngZu,m3h24x4(:,1139),heltab2x96(:,:,5180))
  call Hloop_Q_A(ntryL,G0H4(198),57,0,G1H4(591),n2h4(1007))
  Gcoeff(:)%j = (-(c(293)*M(3,:)%j)) * den(469)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5309),h0tab(:,5309),[57,6],[nMT,nMT],2,2,wf24(:,113),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H96(1),wf24(:,113),G0H4(198),ngZu,m3h24x4(:,1140),heltab2x96(:,:,5181))
  call Hloop_Q_A(ntryL,G0H4(198),57,nMT,G1H4(592),n2h4(1008))
  Gcoeff(:)%j = (-(c(294)*M(3,:)%j)) * den(469)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5310),h0tab(:,5310),[57,6],[0,0],2,2,wf24(:,113),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H96(1),wf24(:,113),G0H4(198),ngZd,m3h24x4(:,1141),heltab2x96(:,:,5182))
  call Hloop_Q_A(ntryL,G0H4(198),57,0,G1H4(593),n2h4(1009))
  Gcoeff(:)%j = (-(c(293)*M(3,:)%j)) * den(469)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5311),h0tab(:,5311),[57,6],[nMB,nMB],2,2,wf24(:,113),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H96(1),wf24(:,113),G0H4(198),ngZd,m3h24x4(:,1142),heltab2x96(:,:,5183))
  call Hloop_Q_A(ntryL,G0H4(198),57,nMB,G1H4(594),n2h4(1010))
  Gcoeff(:)%j = (c(154)*M(3,:)%j) * den(471)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5312),h0tab(:,5312),[57,6],[nMW,nMW],2,2,wf24(:,113),wf4(:,1))
  call Hloop_TV_S(ntryL,G0H96(1),0,wf24(:,113),57,G1H4(595),m3h24x4(:,1143),heltab2x96(:,:,5184))
  Gcoeff(:)%j = (-(c(207)*M(3,:)%j)) * den(472)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5313),h0tab(:,5313),[57,6],[nMW,nMW],2,2,wf24(:,113),wf4(:,1))
  call Hloop_TV_S(ntryL,G0H96(1),0,wf24(:,113),57,G1H4(596),m3h24x4(:,1144),heltab2x96(:,:,5185))
  Gcoeff(:)%j = (c(201)*M(3,:)%j) * den(468)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5314),h0tab(:,5314),[57,6],[nMW,nMW],2,2,wf24(:,113),wf4(:,4))
  call Hloop_TV_S(ntryL,G0H96(1),0,wf24(:,113),57,G1H4(597),m3h24x4(:,1145),heltab2x96(:,:,5186))
  Gcoeff(:)%j = (-(c(47)*M(3,:)%j)) * den(469)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5315),h0tab(:,5315),[57,6],[nMH,nMZ],2,2,wf24(:,113),wf4(:,4))
  call Hloop_SV_T(ntryL,G0H96(1),0,wf24(:,113),57,G1H4(598),m3h24x4(:,1146),heltab2x96(:,:,5187))
  Gcoeff(:)%j = (-(c(202)*M(3,:)%j)) * den(469)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5316),h0tab(:,5316),[57,6],[nMW,nMW],2,2,wf24(:,113),wf4(:,4))
  call Hloop_TV_S(ntryL,G0H96(1),0,wf24(:,113),57,G1H4(599),m3h24x4(:,1147),heltab2x96(:,:,5188))
  Gcoeff(:)%j = (-(c(154)*M(3,:)%j)) * den(471)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5317),h0tab(:,5317),[57,6],[nMW,nMW],2,2,wf24(:,113),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H96(1),0,wf24(:,113),57,G1H4(600),m3h24x4(:,1148),heltab2x96(:,:,5189))
  Gcoeff(:)%j = (-(c(154)*M(3,:)%j)) * den(471)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5318),h0tab(:,5318),[57,6],[nMW,nMW],2,2,wf24(:,113),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H96(1),0,wf24(:,113),57,G1H4(601),m3h24x4(:,1149),heltab2x96(:,:,5190))
  Gcoeff(:)%j = (-(c(69)*M(3,:)%j)) * den(472)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5319),h0tab(:,5319),[57,6],[nMW,nMW],2,2,wf24(:,113),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H96(1),0,wf24(:,113),57,G1H4(602),m3h24x4(:,1150),heltab2x96(:,:,5191))
  Gcoeff(:)%j = (-(c(69)*M(3,:)%j)) * den(472)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5320),h0tab(:,5320),[57,6],[nMW,nMW],2,2,wf24(:,113),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H96(1),0,wf24(:,113),57,G1H4(603),m3h24x4(:,1151),heltab2x96(:,:,5192))
  Gcoeff(:)%j = (-(c(131)*M(3,:)%j)) * den(468)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5321),h0tab(:,5321),[57,6],[nMW,nMW],2,2,wf24(:,113),wf4(:,4))
  call Hloop_CV_D(ntryL,G0H96(1),0,wf24(:,113),57,G1H4(604),m3h24x4(:,1152),heltab2x96(:,:,5193))
  Gcoeff(:)%j = (-(c(131)*M(3,:)%j)) * den(468)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5322),h0tab(:,5322),[57,6],[nMW,nMW],2,2,wf24(:,113),wf4(:,4))
  call Hloop_CV_D(ntryL,G0H96(1),0,wf24(:,113),57,G1H4(605),m3h24x4(:,1153),heltab2x96(:,:,5194))
  Gcoeff(:)%j = (-(c(50)*M(3,:)%j)) * den(469)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5323),h0tab(:,5323),[57,6],[nMW,nMW],2,2,wf24(:,113),wf4(:,4))
  call Hloop_CV_D(ntryL,G0H96(1),0,wf24(:,113),57,G1H4(606),m3h24x4(:,1154),heltab2x96(:,:,5195))
  Gcoeff(:)%j = (-(c(50)*M(3,:)%j)) * den(469)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5324),h0tab(:,5324),[57,6],[nMW,nMW],2,2,wf24(:,113),wf4(:,4))
  call Hloop_CV_D(ntryL,G0H96(1),0,wf24(:,113),57,G1H4(607),m3h24x4(:,1155),heltab2x96(:,:,5196))
  Gcoeff(:)%j = (c(154)*M(3,:)%j) * den(471)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5325),h0tab(:,5325),[57,6],[nMW,nMW],2,2,wf24(:,113),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H96(1),0,wf24(:,113),57,G1H4(608),m3h24x4(:,1156),heltab2x96(:,:,5197))
  Gcoeff(:)%j = (c(69)*M(3,:)%j) * den(472)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5326),h0tab(:,5326),[57,6],[nMW,nMW],2,2,wf24(:,113),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H96(1),0,wf24(:,113),57,G1H4(609),m3h24x4(:,1157),heltab2x96(:,:,5198))
  Gcoeff(:)%j = (c(131)*M(3,:)%j) * den(468)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5327),h0tab(:,5327),[57,6],[nMW,nMW],2,2,wf24(:,113),wf4(:,4))
  call Hloop_UV_W(ntryL,G0H96(1),0,wf24(:,113),57,G1H4(610),m3h24x4(:,1158),heltab2x96(:,:,5199))
  Gcoeff(:)%j = (c(50)*M(3,:)%j) * den(469)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5328),h0tab(:,5328),[57,6],[nMW,nMW],2,2,wf24(:,113),wf4(:,4))
  call Hloop_UV_W(ntryL,G0H96(1),0,wf24(:,113),57,G1H4(611),m3h24x4(:,1159),heltab2x96(:,:,5200))
  Gcoeff(:)%j = (-(c(186)*M(3,:)%j)) * den(471)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5329),h0tab(:,5329),[57,6],[nMW,nMW],2,2,wf24(:,113),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H96(1),wf24(:,113),G0H4(198),m3h24x4(:,1160),heltab2x96(:,:,5201))
  Gcoeff(:)%j = (-(c(186)*M(3,:)%j)) * den(471)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5330),h0tab(:,5330),[57,6],[nMW,nMW],2,2,wf24(:,113),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H96(1),wf24(:,113),G0H4(199),m3h24x4(:,1161),heltab2x96(:,:,5202))
  Gcoeff(:)%j = (c(186)*M(3,:)%j) * den(472)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5331),h0tab(:,5331),[57,6],[nMW,nMW],2,2,wf24(:,113),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H96(1),wf24(:,113),G0H4(200),m3h24x4(:,1162),heltab2x96(:,:,5203))
  Gcoeff(:)%j = (c(186)*M(3,:)%j) * den(472)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5332),h0tab(:,5332),[57,6],[nMW,nMW],2,2,wf24(:,113),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H96(1),wf24(:,113),G0H4(201),m3h24x4(:,1163),heltab2x96(:,:,5204))
  Gcoeff(:)%j = (c(3)*M(3,:)%j) * den(468)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5333),h0tab(:,5333),[57,6],[nMW,nMW],2,2,wf24(:,113),wf4(:,4))
  call Hloop_VV_S(ntryL,G0H96(1),wf24(:,113),G0H4(202),m3h24x4(:,1164),heltab2x96(:,:,5205))
  Gcoeff(:)%j = (c(3)*M(3,:)%j) * den(468)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5334),h0tab(:,5334),[57,6],[nMW,nMW],2,2,wf24(:,113),wf4(:,4))
  call Hloop_VV_S(ntryL,G0H96(1),wf24(:,113),G0H4(203),m3h24x4(:,1165),heltab2x96(:,:,5206))
  Gcoeff(:)%j = (-(c(59)*M(3,:)%j)) * den(469)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5335),h0tab(:,5335),[57,6],[nMH,nMZ],2,2,wf24(:,113),wf4(:,4))
  call Hloop_VV_S(ntryL,G0H96(1),wf24(:,113),G0H4(204),m3h24x4(:,1166),heltab2x96(:,:,5207))
  Gcoeff(:)%j = (-(c(3)*M(3,:)%j)) * den(469)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5336),h0tab(:,5336),[57,6],[nMW,nMW],2,2,wf24(:,113),wf4(:,4))
  call Hloop_VV_S(ntryL,G0H96(1),wf24(:,113),G0H4(205),m3h24x4(:,1167),heltab2x96(:,:,5208))
  Gcoeff(:)%j = (-(c(3)*M(3,:)%j)) * den(469)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5337),h0tab(:,5337),[57,6],[nMW,nMW],2,2,wf24(:,113),wf4(:,4))
  call Hloop_VV_S(ntryL,G0H96(1),wf24(:,113),G0H4(206),m3h24x4(:,1168),heltab2x96(:,:,5209))
  Gcoeff(:)%j = (-(c(231)*M(3,:)%j)) * den(233)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5338),h0tab(:,5338),[41,22],[nME,0],2,2,wf8(:,11),wf12(:,29))
  call Hloop_QW_A(ntryL,G0H96(1),wf8(:,11),G0H12(44),m3h8x12(:,987),heltab2x96(:,:,5210))
  call Hloop_Q_A(ntryL,G0H12(44),41,nME,G1H12(521),n2h12(971))
  Gcoeff(:)%j = (-(c(233)*M(3,:)%j)) * den(233)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5339),h0tab(:,5339),[41,22],[nMM,0],2,2,wf8(:,11),wf12(:,29))
  call Hloop_QW_A(ntryL,G0H96(1),wf8(:,11),G0H12(98),m3h8x12(:,988),heltab2x96(:,:,5211))
  call Hloop_Q_A(ntryL,G0H12(98),41,nMM,G1H12(520),n2h12(972))
  Gcoeff(:)%j = (-(c(232)*M(3,:)%j)) * den(233)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5340),h0tab(:,5340),[41,22],[nML,0],2,2,wf8(:,11),wf12(:,29))
  call Hloop_QW_A(ntryL,G0H96(1),wf8(:,11),G0H12(103),m3h8x12(:,989),heltab2x96(:,:,5212))
  call Hloop_Q_A(ntryL,G0H12(103),41,nML,G1H12(522),n2h12(973))
  Gcoeff(:)%j = (c(229)*M(3,:)%j) * den(233)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5341),h0tab(:,5341),[41,22],[nMB,nMT],2,2,wf8(:,11),wf12(:,29))
  call Hloop_QW_A(ntryL,G0H96(1),wf8(:,11),G0H12(106),m3h8x12(:,990),heltab2x96(:,:,5213))
  call Hloop_Q_A(ntryL,G0H12(106),41,nMB,G1H12(523),n2h12(974))
  Gcoeff(:)%j = (c(231)*M(3,:)%j) * den(234)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5342),h0tab(:,5342),[41,22],[nME,0],2,2,wf8(:,11),wf12(:,30))
  call Hloop_QW_A(ntryL,G0H96(1),wf8(:,11),G0H12(113),m3h8x12(:,991),heltab2x96(:,:,5214))
  call Hloop_Q_A(ntryL,G0H12(113),41,nME,G1H12(524),n2h12(975))
  Gcoeff(:)%j = (c(233)*M(3,:)%j) * den(234)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5343),h0tab(:,5343),[41,22],[nMM,0],2,2,wf8(:,11),wf12(:,30))
  call Hloop_QW_A(ntryL,G0H96(1),wf8(:,11),G0H12(118),m3h8x12(:,992),heltab2x96(:,:,5215))
  call Hloop_Q_A(ntryL,G0H12(118),41,nMM,G1H12(525),n2h12(976))
  Gcoeff(:)%j = (c(232)*M(3,:)%j) * den(234)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5344),h0tab(:,5344),[41,22],[nML,0],2,2,wf8(:,11),wf12(:,30))
  call Hloop_QW_A(ntryL,G0H96(1),wf8(:,11),G0H12(119),m3h8x12(:,993),heltab2x96(:,:,5216))
  call Hloop_Q_A(ntryL,G0H12(119),41,nML,G1H12(551),n2h12(977))
  Gcoeff(:)%j = (-(c(229)*M(3,:)%j)) * den(234)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5345),h0tab(:,5345),[41,22],[nMB,nMT],2,2,wf8(:,11),wf12(:,30))
  call Hloop_QW_A(ntryL,G0H96(1),wf8(:,11),G0H12(46),m3h8x12(:,994),heltab2x96(:,:,5217))
  call Hloop_Q_A(ntryL,G0H12(46),41,nMB,G1H12(111),n2h12(978))
  Gcoeff(:)%j = (c(13)*M(3,:)%j) * den(233)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5346),h0tab(:,5346),[41,22],[nMW,nMH],2,2,wf8(:,11),wf12(:,29))
  call Hloop_TV_S(ntryL,G0H96(1),0,wf8(:,11),41,G1H12(182),m3h8x12(:,995),heltab2x96(:,:,5218))
  Gcoeff(:)%j = (-(c(13)*M(3,:)%j)) * den(234)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5347),h0tab(:,5347),[41,22],[nMW,nMH],2,2,wf8(:,11),wf12(:,30))
  call Hloop_TV_S(ntryL,G0H96(1),0,wf8(:,11),41,G1H12(108),m3h8x12(:,996),heltab2x96(:,:,5219))
  Gcoeff(:)%j = (c(4)*M(3,:)%j) * den(233)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5348),h0tab(:,5348),[41,22],[nMW,nMZ],2,2,wf8(:,11),wf12(:,29))
  call Hloop_CV_D(ntryL,G0H96(1),0,wf8(:,11),41,G1H12(16),m3h8x12(:,997),heltab2x96(:,:,5220))
  Gcoeff(:)%j = (c(78)*M(3,:)%j) * den(233)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5349),h0tab(:,5349),[41,22],[nMW,0],2,2,wf8(:,11),wf12(:,29))
  call Hloop_DV_C(ntryL,G0H96(1),0,wf8(:,11),G1H12(144),m3h8x12(:,998),heltab2x96(:,:,5221))
  Gcoeff(:)%j = (-(c(193)*M(3,:)%j)) * den(233)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5350),h0tab(:,5350),[41,22],[nMW,nMZ],2,2,wf8(:,11),wf12(:,29))
  call Hloop_DV_C(ntryL,G0H96(1),0,wf8(:,11),G1H12(239),m3h8x12(:,999),heltab2x96(:,:,5222))
  Gcoeff(:)%j = (-(c(4)*M(3,:)%j)) * den(234)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5351),h0tab(:,5351),[41,22],[nMW,nMZ],2,2,wf8(:,11),wf12(:,30))
  call Hloop_CV_D(ntryL,G0H96(1),0,wf8(:,11),41,G1H12(226),m3h8x12(:,1000),heltab2x96(:,:,5223))
  Gcoeff(:)%j = (-(c(78)*M(3,:)%j)) * den(234)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5352),h0tab(:,5352),[41,22],[nMW,0],2,2,wf8(:,11),wf12(:,30))
  call Hloop_DV_C(ntryL,G0H96(1),0,wf8(:,11),G1H12(423),m3h8x12(:,1001),heltab2x96(:,:,5224))
  Gcoeff(:)%j = (c(193)*M(3,:)%j) * den(234)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5353),h0tab(:,5353),[41,22],[nMW,nMZ],2,2,wf8(:,11),wf12(:,30))
  call Hloop_DV_C(ntryL,G0H96(1),0,wf8(:,11),G1H12(318),m3h8x12(:,1002),heltab2x96(:,:,5225))
  Gcoeff(:)%j = (c(78)*M(3,:)%j) * den(233)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5354),h0tab(:,5354),[41,22],[nMW,0],2,2,wf8(:,11),wf12(:,29))
  call Hloop_UW_V(ntryL,G0H96(1),0,wf8(:,11),41,G1H12(486),m3h8x12(:,1003),heltab2x96(:,:,5226))
  Gcoeff(:)%j = (-(c(78)*M(3,:)%j)) * den(233)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5355),h0tab(:,5355),[41,22],[nMW,nMZ],2,2,wf8(:,11),wf12(:,29))
  call Hloop_UW_V(ntryL,G0H96(1),0,wf8(:,11),41,G1H12(323),m3h8x12(:,1004),heltab2x96(:,:,5227))
  Gcoeff(:)%j = (-(c(78)*M(3,:)%j)) * den(234)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5356),h0tab(:,5356),[41,22],[nMW,0],2,2,wf8(:,11),wf12(:,30))
  call Hloop_UW_V(ntryL,G0H96(1),0,wf8(:,11),41,G1H12(501),m3h8x12(:,1005),heltab2x96(:,:,5228))
  Gcoeff(:)%j = (c(78)*M(3,:)%j) * den(234)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5357),h0tab(:,5357),[41,22],[nMW,nMZ],2,2,wf8(:,11),wf12(:,30))
  call Hloop_UW_V(ntryL,G0H96(1),0,wf8(:,11),41,G1H12(167),m3h8x12(:,1006),heltab2x96(:,:,5229))
  Gcoeff(:)%j = (c(78)*M(3,:)%j) * den(233)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5358),h0tab(:,5358),[41,22],[0,nMW],2,2,wf8(:,11),wf12(:,29))
  call Hloop_SV_V(ntryL,G0H96(1),wf8(:,11),G0H12(99),m3h8x12(:,1007),heltab2x96(:,:,5230))
  Gcoeff(:)%j = (c(208)*M(3,:)%j) * den(233)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5359),h0tab(:,5359),[41,22],[nMZ,nMW],2,2,wf8(:,11),wf12(:,29))
  call Hloop_SV_V(ntryL,G0H96(1),wf8(:,11),G0H12(40),m3h8x12(:,1008),heltab2x96(:,:,5231))
  Gcoeff(:)%j = (c(4)*M(3,:)%j) * den(233)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5360),h0tab(:,5360),[41,22],[nMW,nMH],2,2,wf8(:,11),wf12(:,29))
  call Hloop_SV_V(ntryL,G0H96(1),wf8(:,11),G0H12(100),m3h8x12(:,1009),heltab2x96(:,:,5232))
  Gcoeff(:)%j = (-(c(78)*M(3,:)%j)) * den(234)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5361),h0tab(:,5361),[41,22],[0,nMW],2,2,wf8(:,11),wf12(:,30))
  call Hloop_SV_V(ntryL,G0H96(1),wf8(:,11),G0H12(58),m3h8x12(:,1010),heltab2x96(:,:,5233))
  Gcoeff(:)%j = (-(c(208)*M(3,:)%j)) * den(234)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5362),h0tab(:,5362),[41,22],[nMZ,nMW],2,2,wf8(:,11),wf12(:,30))
  call Hloop_SV_V(ntryL,G0H96(1),wf8(:,11),G0H12(101),m3h8x12(:,1011),heltab2x96(:,:,5234))
  Gcoeff(:)%j = (-(c(4)*M(3,:)%j)) * den(234)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5363),h0tab(:,5363),[41,22],[nMW,nMH],2,2,wf8(:,11),wf12(:,30))
  call Hloop_SV_V(ntryL,G0H96(1),wf8(:,11),G0H12(76),m3h8x12(:,1012),heltab2x96(:,:,5235))
  Gcoeff(:)%j = (c(222)*M(3,:)%j) * den(233)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5364),h0tab(:,5364),[41,22],[nME,0],2,2,wf8(:,11),wf12(:,5))
  call Hloop_QW_A(ntryL,G0H96(1),wf8(:,11),G0H12(102),m3h8x12(:,1013),heltab2x96(:,:,5236))
  call Hloop_Q_A(ntryL,G0H12(102),41,nME,G1H12(475),n2h12(979))
  Gcoeff(:)%j = (c(222)*M(3,:)%j) * den(233)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5365),h0tab(:,5365),[41,22],[nMM,0],2,2,wf8(:,11),wf12(:,5))
  call Hloop_QW_A(ntryL,G0H96(1),wf8(:,11),G0H12(77),m3h8x12(:,1014),heltab2x96(:,:,5237))
  call Hloop_Q_A(ntryL,G0H12(77),41,nMM,G1H12(194),n2h12(980))
  Gcoeff(:)%j = (c(222)*M(3,:)%j) * den(233)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5366),h0tab(:,5366),[41,22],[nML,0],2,2,wf8(:,11),wf12(:,5))
  call Hloop_QW_A(ntryL,G0H96(1),wf8(:,11),G0H12(78),m3h8x12(:,1015),heltab2x96(:,:,5238))
  call Hloop_Q_A(ntryL,G0H12(78),41,nML,G1H12(489),n2h12(981))
  Gcoeff(:)%j = (c(224)*M(3,:)%j) * den(233)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5367),h0tab(:,5367),[41,22],[0,0],2,2,wf8(:,11),wf12(:,5))
  call Hloop_QW_A(ntryL,G0H96(1),wf8(:,11),G0H12(109),m3h8x12(:,1016),heltab2x96(:,:,5239))
  call Hloop_Q_A(ntryL,G0H12(109),41,0,G1H12(366),n2h12(982))
  Gcoeff(:)%j = (c(223)*M(3,:)%j) * den(233)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5368),h0tab(:,5368),[41,22],[nMB,nMT],2,2,wf8(:,11),wf12(:,5))
  call Hloop_QW_A(ntryL,G0H96(1),wf8(:,11),G0H12(104),m3h8x12(:,1017),heltab2x96(:,:,5240))
  call Hloop_Q_A(ntryL,G0H12(104),41,nMB,G1H12(528),n2h12(983))
  Gcoeff(:)%j = (c(4)*M(3,:)%j) * den(233)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5369),h0tab(:,5369),[41,22],[nMW,nMH],2,2,wf8(:,11),wf12(:,5))
  call Hloop_TV_S(ntryL,G0H96(1),0,wf8(:,11),41,G1H12(240),m3h8x12(:,1018),heltab2x96(:,:,5241))
  Gcoeff(:)%j = (c(4)*M(3,:)%j) * den(233)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5370),h0tab(:,5370),[41,22],[nMW,nMZ],2,2,wf8(:,11),wf12(:,5))
  call Hloop_TV_S(ntryL,G0H96(1),0,wf8(:,11),41,G1H12(548),m3h8x12(:,1019),heltab2x96(:,:,5242))
  Gcoeff(:)%j = (c(80)*M(3,:)%j) * den(233)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5371),h0tab(:,5371),[41,22],[nMW,0],2,2,wf8(:,11),wf12(:,5))
  call Hloop_CV_D(ntryL,G0H96(1),0,wf8(:,11),41,G1H12(246),m3h8x12(:,1020),heltab2x96(:,:,5243))
  Gcoeff(:)%j = (c(10)*M(3,:)%j) * den(233)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5372),h0tab(:,5372),[41,22],[nMW,nMZ],2,2,wf8(:,11),wf12(:,5))
  call Hloop_CV_D(ntryL,G0H96(1),0,wf8(:,11),41,G1H12(112),m3h8x12(:,1021),heltab2x96(:,:,5244))
  Gcoeff(:)%j = (c(80)*M(3,:)%j) * den(233)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5373),h0tab(:,5373),[41,22],[nMW,0],2,2,wf8(:,11),wf12(:,5))
  call Hloop_DV_C(ntryL,G0H96(1),0,wf8(:,11),G1H12(130),m3h8x12(:,1022),heltab2x96(:,:,5245))
  Gcoeff(:)%j = (c(10)*M(3,:)%j) * den(233)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5374),h0tab(:,5374),[41,22],[nMW,nMZ],2,2,wf8(:,11),wf12(:,5))
  call Hloop_DV_C(ntryL,G0H96(1),0,wf8(:,11),G1H12(231),m3h8x12(:,1023),heltab2x96(:,:,5246))
  Gcoeff(:)%j = (-(c(80)*M(3,:)%j)) * den(233)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5375),h0tab(:,5375),[41,22],[nMW,0],2,2,wf8(:,11),wf12(:,5))
  call Hloop_UW_V(ntryL,G0H96(1),0,wf8(:,11),41,G1H12(13),m3h8x12(:,1024),heltab2x96(:,:,5247))
  Gcoeff(:)%j = (-(c(10)*M(3,:)%j)) * den(233)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5376),h0tab(:,5376),[41,22],[nMW,nMZ],2,2,wf8(:,11),wf12(:,5))
  call Hloop_UW_V(ntryL,G0H96(1),0,wf8(:,11),41,G1H12(217),m3h8x12(:,1025),heltab2x96(:,:,5248))
  Gcoeff(:)%j = (c(103)*M(3,:)%j) * den(233)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5377),h0tab(:,5377),[41,22],[0,nMW],2,2,wf8(:,11),wf12(:,5))
  call Hloop_SV_V(ntryL,G0H96(1),wf8(:,11),G0H12(84),m3h8x12(:,1026),heltab2x96(:,:,5249))
  Gcoeff(:)%j = (c(188)*M(3,:)%j) * den(233)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5378),h0tab(:,5378),[41,22],[nMZ,nMW],2,2,wf8(:,11),wf12(:,5))
  call Hloop_SV_V(ntryL,G0H96(1),wf8(:,11),G0H12(79),m3h8x12(:,1027),heltab2x96(:,:,5250))
  Gcoeff(:)%j = (c(25)*M(3,:)%j) * den(233)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5379),h0tab(:,5379),[41,22],[nMW,nMH],2,2,wf8(:,11),wf12(:,5))
  call Hloop_SV_V(ntryL,G0H96(1),wf8(:,11),G0H12(110),m3h8x12(:,1028),heltab2x96(:,:,5251))
  Gcoeff(:)%j = (c(285)*M(3,:)%j) * den(235)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5380),h0tab(:,5380),[41,22],[nME,0],2,2,wf8(:,11),wf12(:,31))
  call Hloop_QW_A(ntryL,G0H96(1),wf8(:,11),G0H12(105),m3h8x12(:,1029),heltab2x96(:,:,5252))
  call Hloop_Q_A(ntryL,G0H12(105),41,nME,G1H12(211),n2h12(984))
  Gcoeff(:)%j = (c(287)*M(3,:)%j) * den(235)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5381),h0tab(:,5381),[41,22],[nMM,0],2,2,wf8(:,11),wf12(:,31))
  call Hloop_QW_A(ntryL,G0H96(1),wf8(:,11),G0H12(85),m3h8x12(:,1030),heltab2x96(:,:,5253))
  call Hloop_Q_A(ntryL,G0H12(85),41,nMM,G1H12(22),n2h12(985))
  Gcoeff(:)%j = (c(286)*M(3,:)%j) * den(235)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5382),h0tab(:,5382),[41,22],[nML,0],2,2,wf8(:,11),wf12(:,31))
  call Hloop_QW_A(ntryL,G0H96(1),wf8(:,11),G0H12(80),m3h8x12(:,1031),heltab2x96(:,:,5254))
  call Hloop_Q_A(ntryL,G0H12(80),41,nML,G1H12(12),n2h12(986))
  Gcoeff(:)%j = (-(c(277)*M(3,:)%j)) * den(235)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5383),h0tab(:,5383),[41,22],[nMB,nMT],2,2,wf8(:,11),wf12(:,31))
  call Hloop_QW_A(ntryL,G0H96(1),wf8(:,11),G0H12(81),m3h8x12(:,1032),heltab2x96(:,:,5255))
  call Hloop_Q_A(ntryL,G0H12(81),41,nMB,G1H12(26),n2h12(987))
  Gcoeff(:)%j = (-(c(299)*M(3,:)%j)) * den(234)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5384),h0tab(:,5384),[41,22],[nME,0],2,2,wf8(:,11),wf12(:,32))
  call Hloop_QW_A(ntryL,G0H96(1),wf8(:,11),G0H12(111),m3h8x12(:,1033),heltab2x96(:,:,5256))
  call Hloop_Q_A(ntryL,G0H12(111),41,nME,G1H12(21),n2h12(988))
  Gcoeff(:)%j = (-(c(301)*M(3,:)%j)) * den(234)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5385),h0tab(:,5385),[41,22],[nMM,0],2,2,wf8(:,11),wf12(:,32))
  call Hloop_QW_A(ntryL,G0H96(1),wf8(:,11),G0H12(107),m3h8x12(:,1034),heltab2x96(:,:,5257))
  call Hloop_Q_A(ntryL,G0H12(107),41,nMM,G1H12(116),n2h12(989))
  Gcoeff(:)%j = (-(c(300)*M(3,:)%j)) * den(234)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5386),h0tab(:,5386),[41,22],[nML,0],2,2,wf8(:,11),wf12(:,32))
  call Hloop_QW_A(ntryL,G0H96(1),wf8(:,11),G0H12(97),m3h8x12(:,1035),heltab2x96(:,:,5258))
  call Hloop_Q_A(ntryL,G0H12(97),41,nML,G1H12(5),n2h12(990))
  Gcoeff(:)%j = (c(298)*M(3,:)%j) * den(234)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5387),h0tab(:,5387),[41,22],[nMB,nMT],2,2,wf8(:,11),wf12(:,32))
  call Hloop_QW_A(ntryL,G0H96(1),wf8(:,11),G0H12(82),m3h8x12(:,1036),heltab2x96(:,:,5259))
  call Hloop_Q_A(ntryL,G0H12(82),41,nMB,G1H12(45),n2h12(991))
  Gcoeff(:)%j = (-(c(71)*M(3,:)%j)) * den(235)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5388),h0tab(:,5388),[41,22],[nMW,nMH],2,2,wf8(:,11),wf12(:,31))
  call Hloop_TV_S(ntryL,G0H96(1),0,wf8(:,11),41,G1H12(106),m3h8x12(:,1037),heltab2x96(:,:,5260))
  Gcoeff(:)%j = (c(137)*M(3,:)%j) * den(234)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5389),h0tab(:,5389),[41,22],[nMW,nMH],2,2,wf8(:,11),wf12(:,32))
  call Hloop_TV_S(ntryL,G0H96(1),0,wf8(:,11),41,G1H12(148),m3h8x12(:,1038),heltab2x96(:,:,5261))
  Gcoeff(:)%j = (-(c(99)*M(3,:)%j)) * den(235)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5390),h0tab(:,5390),[41,22],[nMW,nMZ],2,2,wf8(:,11),wf12(:,31))
  call Hloop_CV_D(ntryL,G0H96(1),0,wf8(:,11),41,G1H12(15),m3h8x12(:,1039),heltab2x96(:,:,5262))
  Gcoeff(:)%j = (-(c(186)*M(3,:)%j)) * den(235)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5391),h0tab(:,5391),[41,22],[nMW,0],2,2,wf8(:,11),wf12(:,31))
  call Hloop_DV_C(ntryL,G0H96(1),0,wf8(:,11),G1H12(68),m3h8x12(:,1040),heltab2x96(:,:,5263))
  Gcoeff(:)%j = (c(209)*M(3,:)%j) * den(235)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5392),h0tab(:,5392),[41,22],[nMW,nMZ],2,2,wf8(:,11),wf12(:,31))
  call Hloop_DV_C(ntryL,G0H96(1),0,wf8(:,11),G1H12(67),m3h8x12(:,1041),heltab2x96(:,:,5264))
  Gcoeff(:)%j = (c(140)*M(3,:)%j) * den(234)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5393),h0tab(:,5393),[41,22],[nMW,nMZ],2,2,wf8(:,11),wf12(:,32))
  call Hloop_CV_D(ntryL,G0H96(1),0,wf8(:,11),41,G1H12(44),m3h8x12(:,1042),heltab2x96(:,:,5265))
  Gcoeff(:)%j = (c(3)*M(3,:)%j) * den(234)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5394),h0tab(:,5394),[41,22],[nMW,0],2,2,wf8(:,11),wf12(:,32))
  call Hloop_DV_C(ntryL,G0H96(1),0,wf8(:,11),G1H12(145),m3h8x12(:,1043),heltab2x96(:,:,5266))
  Gcoeff(:)%j = (c(205)*M(3,:)%j) * den(234)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5395),h0tab(:,5395),[41,22],[nMW,nMZ],2,2,wf8(:,11),wf12(:,32))
  call Hloop_DV_C(ntryL,G0H96(1),0,wf8(:,11),G1H12(393),m3h8x12(:,1044),heltab2x96(:,:,5267))
  Gcoeff(:)%j = (-(c(186)*M(3,:)%j)) * den(235)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5396),h0tab(:,5396),[41,22],[nMW,0],2,2,wf8(:,11),wf12(:,31))
  call Hloop_UW_V(ntryL,G0H96(1),0,wf8(:,11),41,G1H12(38),m3h8x12(:,1045),heltab2x96(:,:,5268))
  Gcoeff(:)%j = (c(186)*M(3,:)%j) * den(235)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5397),h0tab(:,5397),[41,22],[nMW,nMZ],2,2,wf8(:,11),wf12(:,31))
  call Hloop_UW_V(ntryL,G0H96(1),0,wf8(:,11),41,G1H12(396),m3h8x12(:,1046),heltab2x96(:,:,5269))
  Gcoeff(:)%j = (c(3)*M(3,:)%j) * den(234)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5398),h0tab(:,5398),[41,22],[nMW,0],2,2,wf8(:,11),wf12(:,32))
  call Hloop_UW_V(ntryL,G0H96(1),0,wf8(:,11),41,G1H12(53),m3h8x12(:,1047),heltab2x96(:,:,5270))
  Gcoeff(:)%j = (-(c(3)*M(3,:)%j)) * den(234)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5399),h0tab(:,5399),[41,22],[nMW,nMZ],2,2,wf8(:,11),wf12(:,32))
  call Hloop_UW_V(ntryL,G0H96(1),0,wf8(:,11),41,G1H12(60),m3h8x12(:,1048),heltab2x96(:,:,5271))
  Gcoeff(:)%j = (-(c(186)*M(3,:)%j)) * den(235)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5400),h0tab(:,5400),[41,22],[0,nMW],2,2,wf8(:,11),wf12(:,31))
  call Hloop_SV_V(ntryL,G0H96(1),wf8(:,11),G0H12(112),m3h8x12(:,1049),heltab2x96(:,:,5272))
  Gcoeff(:)%j = (-(c(212)*M(3,:)%j)) * den(235)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5401),h0tab(:,5401),[41,22],[nMZ,nMW],2,2,wf8(:,11),wf12(:,31))
  call Hloop_SV_V(ntryL,G0H96(1),wf8(:,11),G0H12(108),m3h8x12(:,1050),heltab2x96(:,:,5273))
  Gcoeff(:)%j = (-(c(99)*M(3,:)%j)) * den(235)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5402),h0tab(:,5402),[41,22],[nMW,nMH],2,2,wf8(:,11),wf12(:,31))
  call Hloop_SV_V(ntryL,G0H96(1),wf8(:,11),G0H12(1),m3h8x12(:,1051),heltab2x96(:,:,5274))
  Gcoeff(:)%j = (c(3)*M(3,:)%j) * den(234)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5403),h0tab(:,5403),[41,22],[0,nMW],2,2,wf8(:,11),wf12(:,32))
  call Hloop_SV_V(ntryL,G0H96(1),wf8(:,11),G0H12(83),m3h8x12(:,1052),heltab2x96(:,:,5275))
  Gcoeff(:)%j = (c(213)*M(3,:)%j) * den(234)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5404),h0tab(:,5404),[41,22],[nMZ,nMW],2,2,wf8(:,11),wf12(:,32))
  call Hloop_SV_V(ntryL,G0H96(1),wf8(:,11),G0H12(2),m3h8x12(:,1053),heltab2x96(:,:,5276))
  Gcoeff(:)%j = (c(140)*M(3,:)%j) * den(234)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5405),h0tab(:,5405),[41,22],[nMW,nMH],2,2,wf8(:,11),wf12(:,32))
  call Hloop_SV_V(ntryL,G0H96(1),wf8(:,11),G0H12(114),m3h8x12(:,1054),heltab2x96(:,:,5277))
  Gcoeff(:)%j = (-(c(276)*M(3,:)%j)) * den(235)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5406),h0tab(:,5406),[41,22],[nME,0],2,2,wf8(:,11),wf12(:,6))
  call Hloop_QW_A(ntryL,G0H96(1),wf8(:,11),G0H12(3),m3h8x12(:,1055),heltab2x96(:,:,5278))
  call Hloop_Q_A(ntryL,G0H12(3),41,nME,G1H12(71),n2h12(992))
  Gcoeff(:)%j = (-(c(276)*M(3,:)%j)) * den(235)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5407),h0tab(:,5407),[41,22],[nMM,0],2,2,wf8(:,11),wf12(:,6))
  call Hloop_QW_A(ntryL,G0H96(1),wf8(:,11),G0H12(139),m3h8x12(:,1056),heltab2x96(:,:,5279))
  call Hloop_Q_A(ntryL,G0H12(139),41,nMM,G1H12(76),n2h12(993))
  Gcoeff(:)%j = (-(c(276)*M(3,:)%j)) * den(235)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5408),h0tab(:,5408),[41,22],[nML,0],2,2,wf8(:,11),wf12(:,6))
  call Hloop_QW_A(ntryL,G0H96(1),wf8(:,11),G0H12(115),m3h8x12(:,1057),heltab2x96(:,:,5280))
  call Hloop_Q_A(ntryL,G0H12(115),41,nML,G1H12(163),n2h12(994))
  Gcoeff(:)%j = (-(c(281)*M(3,:)%j)) * den(235)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5409),h0tab(:,5409),[41,22],[0,0],2,2,wf8(:,11),wf12(:,6))
  call Hloop_QW_A(ntryL,G0H96(1),wf8(:,11),G0H12(4),m3h8x12(:,1058),heltab2x96(:,:,5281))
  call Hloop_Q_A(ntryL,G0H12(4),41,0,G1H12(97),n2h12(995))
  Gcoeff(:)%j = (-(c(277)*M(3,:)%j)) * den(235)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5410),h0tab(:,5410),[41,22],[nMB,nMT],2,2,wf8(:,11),wf12(:,6))
  call Hloop_QW_A(ntryL,G0H96(1),wf8(:,11),G0H12(123),m3h8x12(:,1059),heltab2x96(:,:,5282))
  call Hloop_Q_A(ntryL,G0H12(123),41,nMB,G1H12(176),n2h12(996))
  Gcoeff(:)%j = (-(c(240)*M(3,:)%j)) * den(234)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5411),h0tab(:,5411),[41,22],[nME,0],2,2,wf8(:,11),wf12(:,7))
  call Hloop_QW_A(ntryL,G0H96(1),wf8(:,11),G0H12(121),m3h8x12(:,1060),heltab2x96(:,:,5283))
  call Hloop_Q_A(ntryL,G0H12(121),41,nME,G1H12(464),n2h12(997))
  Gcoeff(:)%j = (-(c(240)*M(3,:)%j)) * den(234)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5412),h0tab(:,5412),[41,22],[nMM,0],2,2,wf8(:,11),wf12(:,7))
  call Hloop_QW_A(ntryL,G0H96(1),wf8(:,11),G0H12(12),m3h8x12(:,1061),heltab2x96(:,:,5284))
  call Hloop_Q_A(ntryL,G0H12(12),41,nMM,G1H12(103),n2h12(998))
  Gcoeff(:)%j = (-(c(240)*M(3,:)%j)) * den(234)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5413),h0tab(:,5413),[41,22],[nML,0],2,2,wf8(:,11),wf12(:,7))
  call Hloop_QW_A(ntryL,G0H96(1),wf8(:,11),G0H12(10),m3h8x12(:,1062),heltab2x96(:,:,5285))
  call Hloop_Q_A(ntryL,G0H12(10),41,nML,G1H12(65),n2h12(999))
  Gcoeff(:)%j = (-(c(242)*M(3,:)%j)) * den(234)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5414),h0tab(:,5414),[41,22],[0,0],2,2,wf8(:,11),wf12(:,7))
  call Hloop_QW_A(ntryL,G0H96(1),wf8(:,11),G0H12(122),m3h8x12(:,1063),heltab2x96(:,:,5286))
  call Hloop_Q_A(ntryL,G0H12(122),41,0,G1H12(183),n2h12(1000))
  Gcoeff(:)%j = (-(c(241)*M(3,:)%j)) * den(234)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5415),h0tab(:,5415),[41,22],[nMB,nMT],2,2,wf8(:,11),wf12(:,7))
  call Hloop_QW_A(ntryL,G0H96(1),wf8(:,11),G0H12(11),m3h8x12(:,1064),heltab2x96(:,:,5287))
  call Hloop_Q_A(ntryL,G0H12(11),41,nMB,G1H12(120),n2h12(1001))
  Gcoeff(:)%j = (-(c(65)*M(3,:)%j)) * den(235)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5416),h0tab(:,5416),[41,22],[nMW,nMH],2,2,wf8(:,11),wf12(:,6))
  call Hloop_TV_S(ntryL,G0H96(1),0,wf8(:,11),41,G1H12(151),m3h8x12(:,1065),heltab2x96(:,:,5288))
  Gcoeff(:)%j = (-(c(65)*M(3,:)%j)) * den(235)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5417),h0tab(:,5417),[41,22],[nMW,nMZ],2,2,wf8(:,11),wf12(:,6))
  call Hloop_TV_S(ntryL,G0H96(1),0,wf8(:,11),41,G1H12(198),m3h8x12(:,1066),heltab2x96(:,:,5289))
  Gcoeff(:)%j = (-(c(48)*M(3,:)%j)) * den(234)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5418),h0tab(:,5418),[41,22],[nMW,nMH],2,2,wf8(:,11),wf12(:,7))
  call Hloop_TV_S(ntryL,G0H96(1),0,wf8(:,11),41,G1H12(14),m3h8x12(:,1067),heltab2x96(:,:,5290))
  Gcoeff(:)%j = (-(c(48)*M(3,:)%j)) * den(234)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5419),h0tab(:,5419),[41,22],[nMW,nMZ],2,2,wf8(:,11),wf12(:,7))
  call Hloop_TV_S(ntryL,G0H96(1),0,wf8(:,11),41,G1H12(143),m3h8x12(:,1068),heltab2x96(:,:,5291))
  Gcoeff(:)%j = (-(c(154)*M(3,:)%j)) * den(235)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5420),h0tab(:,5420),[41,22],[nMW,0],2,2,wf8(:,11),wf12(:,6))
  call Hloop_CV_D(ntryL,G0H96(1),0,wf8(:,11),41,G1H12(465),m3h8x12(:,1069),heltab2x96(:,:,5292))
  Gcoeff(:)%j = (-(c(69)*M(3,:)%j)) * den(235)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5421),h0tab(:,5421),[41,22],[nMW,nMZ],2,2,wf8(:,11),wf12(:,6))
  call Hloop_CV_D(ntryL,G0H96(1),0,wf8(:,11),41,G1H12(20),m3h8x12(:,1070),heltab2x96(:,:,5293))
  Gcoeff(:)%j = (-(c(154)*M(3,:)%j)) * den(235)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5422),h0tab(:,5422),[41,22],[nMW,0],2,2,wf8(:,11),wf12(:,6))
  call Hloop_DV_C(ntryL,G0H96(1),0,wf8(:,11),G1H12(153),m3h8x12(:,1071),heltab2x96(:,:,5294))
  Gcoeff(:)%j = (-(c(69)*M(3,:)%j)) * den(235)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5423),h0tab(:,5423),[41,22],[nMW,nMZ],2,2,wf8(:,11),wf12(:,6))
  call Hloop_DV_C(ntryL,G0H96(1),0,wf8(:,11),G1H12(94),m3h8x12(:,1072),heltab2x96(:,:,5295))
  Gcoeff(:)%j = (-(c(131)*M(3,:)%j)) * den(234)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5424),h0tab(:,5424),[41,22],[nMW,0],2,2,wf8(:,11),wf12(:,7))
  call Hloop_CV_D(ntryL,G0H96(1),0,wf8(:,11),41,G1H12(89),m3h8x12(:,1073),heltab2x96(:,:,5296))
  Gcoeff(:)%j = (-(c(50)*M(3,:)%j)) * den(234)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5425),h0tab(:,5425),[41,22],[nMW,nMZ],2,2,wf8(:,11),wf12(:,7))
  call Hloop_CV_D(ntryL,G0H96(1),0,wf8(:,11),41,G1H12(168),m3h8x12(:,1074),heltab2x96(:,:,5297))
  Gcoeff(:)%j = (-(c(131)*M(3,:)%j)) * den(234)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5426),h0tab(:,5426),[41,22],[nMW,0],2,2,wf8(:,11),wf12(:,7))
  call Hloop_DV_C(ntryL,G0H96(1),0,wf8(:,11),G1H12(229),m3h8x12(:,1075),heltab2x96(:,:,5298))
  Gcoeff(:)%j = (-(c(50)*M(3,:)%j)) * den(234)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5427),h0tab(:,5427),[41,22],[nMW,nMZ],2,2,wf8(:,11),wf12(:,7))
  call Hloop_DV_C(ntryL,G0H96(1),0,wf8(:,11),G1H12(139),m3h8x12(:,1076),heltab2x96(:,:,5299))
  Gcoeff(:)%j = (c(154)*M(3,:)%j) * den(235)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5428),h0tab(:,5428),[41,22],[nMW,0],2,2,wf8(:,11),wf12(:,6))
  call Hloop_UW_V(ntryL,G0H96(1),0,wf8(:,11),41,G1H12(135),m3h8x12(:,1077),heltab2x96(:,:,5300))
  Gcoeff(:)%j = (c(69)*M(3,:)%j) * den(235)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5429),h0tab(:,5429),[41,22],[nMW,nMZ],2,2,wf8(:,11),wf12(:,6))
  call Hloop_UW_V(ntryL,G0H96(1),0,wf8(:,11),41,G1H12(197),m3h8x12(:,1078),heltab2x96(:,:,5301))
  Gcoeff(:)%j = (c(131)*M(3,:)%j) * den(234)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5430),h0tab(:,5430),[41,22],[nMW,0],2,2,wf8(:,11),wf12(:,7))
  call Hloop_UW_V(ntryL,G0H96(1),0,wf8(:,11),41,G1H12(138),m3h8x12(:,1079),heltab2x96(:,:,5302))
  Gcoeff(:)%j = (c(50)*M(3,:)%j) * den(234)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5431),h0tab(:,5431),[41,22],[nMW,nMZ],2,2,wf8(:,11),wf12(:,7))
  call Hloop_UW_V(ntryL,G0H96(1),0,wf8(:,11),41,G1H12(348),m3h8x12(:,1080),heltab2x96(:,:,5303))
  Gcoeff(:)%j = (-(c(186)*M(3,:)%j)) * den(235)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5432),h0tab(:,5432),[41,22],[0,nMW],2,2,wf8(:,11),wf12(:,6))
  call Hloop_SV_V(ntryL,G0H96(1),wf8(:,11),G0H12(126),m3h8x12(:,1081),heltab2x96(:,:,5304))
  Gcoeff(:)%j = (-(c(191)*M(3,:)%j)) * den(235)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5433),h0tab(:,5433),[41,22],[nMZ,nMW],2,2,wf8(:,11),wf12(:,6))
  call Hloop_SV_V(ntryL,G0H96(1),wf8(:,11),G0H12(124),m3h8x12(:,1082),heltab2x96(:,:,5305))
  Gcoeff(:)%j = (-(c(100)*M(3,:)%j)) * den(235)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5434),h0tab(:,5434),[41,22],[nMW,nMH],2,2,wf8(:,11),wf12(:,6))
  call Hloop_SV_V(ntryL,G0H96(1),wf8(:,11),G0H12(15),m3h8x12(:,1083),heltab2x96(:,:,5306))
  Gcoeff(:)%j = (-(c(141)*M(3,:)%j)) * den(234)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5435),h0tab(:,5435),[41,22],[0,nMW],2,2,wf8(:,11),wf12(:,7))
  call Hloop_SV_V(ntryL,G0H96(1),wf8(:,11),G0H12(13),m3h8x12(:,1084),heltab2x96(:,:,5307))
  Gcoeff(:)%j = (-(c(3)*M(3,:)%j)) * den(234)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5436),h0tab(:,5436),[41,22],[nMZ,nMW],2,2,wf8(:,11),wf12(:,7))
  call Hloop_SV_V(ntryL,G0H96(1),wf8(:,11),G0H12(147),m3h8x12(:,1085),heltab2x96(:,:,5308))
  Gcoeff(:)%j = (-(c(62)*M(3,:)%j)) * den(234)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5437),h0tab(:,5437),[41,22],[nMW,nMH],2,2,wf8(:,11),wf12(:,7))
  call Hloop_SV_V(ntryL,G0H96(1),wf8(:,11),G0H12(148),m3h8x12(:,1086),heltab2x96(:,:,5309))
  Gcoeff(:)%j = (-(c(73)*M(3,:)%j)) * den(473)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5438),h0tab(:,5438),[40,23],[0,0],2,2,wf4(:,3),wf24(:,35))
  call Hloop_VQ_A(ntryL,G0H96(1),wf4(:,3),G0H24(120),m3h4x24(:,1201),heltab2x96(:,:,5310))
  call Hloop_Q_A(ntryL,G0H24(120),40,0,G1H24(114),n2h24(833))
  Gcoeff(:)%j = (-(c(80)*M(3,:)%j)) * den(473)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5439),h0tab(:,5439),[40,23],[0,nMZ],2,2,wf4(:,3),wf24(:,35))
  call Hloop_ZQ_A(ntryL,G0H96(1),wf4(:,3),G0H24(116),ngZd,m3h4x24(:,1202),heltab2x96(:,:,5311))
  call Hloop_Q_A(ntryL,G0H24(116),40,0,G1H24(33),n2h24(834))
  Gcoeff(:)%j = (-(c(33)*M(3,:)%j)) * den(473)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5440),h0tab(:,5440),[40,23],[0,nMW],2,2,wf4(:,3),wf24(:,35))
  call Hloop_WQ_A(ntryL,G0H96(1),wf4(:,3),G0H24(5),m3h4x24(:,1203),heltab2x96(:,:,5312))
  call Hloop_Q_A(ntryL,G0H24(5),40,0,G1H24(40),n2h24(835))
  Gcoeff(:)%j = (-(c(87)*M(2,:)%j)) * den(473)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5441),h0tab(:,5441),[40,23],[0,0],2,2,wf4(:,3),wf24(:,35))
  call Hloop_VQ_A(ntryL,G0H96(1),wf4(:,3),G0H24(1),m3h4x24(:,1204),heltab2x96(:,:,5313))
  call Hloop_Q_A(ntryL,G0H24(1),40,0,G1H24(253),n2h24(836))
  Gcoeff(:)%j = (c(145)*M(3,:)%j) * den(474)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5442),h0tab(:,5442),[40,23],[0,0],2,2,wf4(:,3),wf24(:,37))
  call Hloop_VQ_A(ntryL,G0H96(1),wf4(:,3),G0H24(2),m3h4x24(:,1205),heltab2x96(:,:,5314))
  call Hloop_Q_A(ntryL,G0H24(2),40,0,G1H24(254),n2h24(837))
  Gcoeff(:)%j = (c(154)*M(3,:)%j) * den(474)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5443),h0tab(:,5443),[40,23],[0,nMZ],2,2,wf4(:,3),wf24(:,37))
  call Hloop_ZQ_A(ntryL,G0H96(1),wf4(:,3),G0H24(3),ngZd,m3h4x24(:,1206),heltab2x96(:,:,5315))
  call Hloop_Q_A(ntryL,G0H24(3),40,0,G1H24(43),n2h24(838))
  Gcoeff(:)%j = (c(108)*M(3,:)%j) * den(474)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5444),h0tab(:,5444),[40,23],[0,nMW],2,2,wf4(:,3),wf24(:,37))
  call Hloop_WQ_A(ntryL,G0H96(1),wf4(:,3),G0H24(65),m3h4x24(:,1207),heltab2x96(:,:,5316))
  call Hloop_Q_A(ntryL,G0H24(65),40,0,G1H24(45),n2h24(839))
  Gcoeff(:)%j = (c(178)*M(2,:)%j) * den(474)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5445),h0tab(:,5445),[40,23],[0,0],2,2,wf4(:,3),wf24(:,37))
  call Hloop_VQ_A(ntryL,G0H96(1),wf4(:,3),G0H24(66),m3h4x24(:,1208),heltab2x96(:,:,5317))
  call Hloop_Q_A(ntryL,G0H24(66),40,0,G1H24(49),n2h24(840))
  Gcoeff(:)%j = (c(126)*M(3,:)%j) * den(475)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5446),h0tab(:,5446),[40,23],[0,0],2,2,wf4(:,3),wf24(:,39))
  call Hloop_VQ_A(ntryL,G0H96(1),wf4(:,3),G0H24(77),m3h4x24(:,1209),heltab2x96(:,:,5318))
  call Hloop_Q_A(ntryL,G0H24(77),40,0,G1H24(52),n2h24(841))
  Gcoeff(:)%j = (c(131)*M(3,:)%j) * den(475)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5447),h0tab(:,5447),[40,23],[0,nMZ],2,2,wf4(:,3),wf24(:,39))
  call Hloop_ZQ_A(ntryL,G0H96(1),wf4(:,3),G0H24(74),ngZd,m3h4x24(:,1210),heltab2x96(:,:,5319))
  call Hloop_Q_A(ntryL,G0H24(74),40,0,G1H24(53),n2h24(842))
  Gcoeff(:)%j = (c(63)*M(3,:)%j) * den(475)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5448),h0tab(:,5448),[40,23],[0,nMW],2,2,wf4(:,3),wf24(:,39))
  call Hloop_WQ_A(ntryL,G0H96(1),wf4(:,3),G0H24(73),m3h4x24(:,1211),heltab2x96(:,:,5320))
  call Hloop_Q_A(ntryL,G0H24(73),40,0,G1H24(62),n2h24(843))
  Gcoeff(:)%j = (c(136)*M(2,:)%j) * den(475)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5449),h0tab(:,5449),[40,23],[0,0],2,2,wf4(:,3),wf24(:,39))
  call Hloop_VQ_A(ntryL,G0H96(1),wf4(:,3),G0H24(33),m3h4x24(:,1212),heltab2x96(:,:,5321))
  call Hloop_Q_A(ntryL,G0H24(33),40,0,G1H24(58),n2h24(844))
  Gcoeff(:)%j = (-(c(261)*M(3,:)%j)) * den(476)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5450),h0tab(:,5450),[57,6],[nME,nME],2,2,wf24(:,114),wf4(:,7))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,114),G0H4(207),m3h24x4(:,1169),heltab2x96(:,:,5322))
  call Hloop_Q_A(ntryL,G0H4(207),57,nME,G1H4(612),n2h4(1011))
  Gcoeff(:)%j = (-(c(267)*M(3,:)%j)) * den(476)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5451),h0tab(:,5451),[57,6],[nMM,nMM],2,2,wf24(:,114),wf4(:,7))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,114),G0H4(207),m3h24x4(:,1170),heltab2x96(:,:,5323))
  call Hloop_Q_A(ntryL,G0H4(207),57,nMM,G1H4(613),n2h4(1012))
  Gcoeff(:)%j = (-(c(264)*M(3,:)%j)) * den(476)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5452),h0tab(:,5452),[57,6],[nML,nML],2,2,wf24(:,114),wf4(:,7))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,114),G0H4(207),m3h24x4(:,1171),heltab2x96(:,:,5324))
  call Hloop_Q_A(ntryL,G0H4(207),57,nML,G1H4(614),n2h4(1013))
  Gcoeff(:)%j = (c(270)*M(3,:)%j) * den(476)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5453),h0tab(:,5453),[57,6],[nMT,nMT],2,2,wf24(:,114),wf4(:,7))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,114),G0H4(207),m3h24x4(:,1172),heltab2x96(:,:,5325))
  call Hloop_Q_A(ntryL,G0H4(207),57,nMT,G1H4(615),n2h4(1014))
  Gcoeff(:)%j = (-(c(256)*M(3,:)%j)) * den(476)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5454),h0tab(:,5454),[57,6],[nMB,nMB],2,2,wf24(:,114),wf4(:,7))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,114),G0H4(207),m3h24x4(:,1173),heltab2x96(:,:,5326))
  call Hloop_Q_A(ntryL,G0H4(207),57,nMB,G1H4(616),n2h4(1015))
  Gcoeff(:)%j = (-(c(261)*M(3,:)%j)) * den(477)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5455),h0tab(:,5455),[57,6],[nME,nME],2,2,wf24(:,114),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,114),G0H4(207),m3h24x4(:,1174),heltab2x96(:,:,5327))
  call Hloop_Q_A(ntryL,G0H4(207),57,nME,G1H4(617),n2h4(1016))
  Gcoeff(:)%j = (-(c(267)*M(3,:)%j)) * den(477)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5456),h0tab(:,5456),[57,6],[nMM,nMM],2,2,wf24(:,114),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,114),G0H4(207),m3h24x4(:,1175),heltab2x96(:,:,5328))
  call Hloop_Q_A(ntryL,G0H4(207),57,nMM,G1H4(618),n2h4(1017))
  Gcoeff(:)%j = (-(c(264)*M(3,:)%j)) * den(477)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5457),h0tab(:,5457),[57,6],[nML,nML],2,2,wf24(:,114),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,114),G0H4(207),m3h24x4(:,1176),heltab2x96(:,:,5329))
  call Hloop_Q_A(ntryL,G0H4(207),57,nML,G1H4(619),n2h4(1018))
  Gcoeff(:)%j = (-(c(270)*M(3,:)%j)) * den(477)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5458),h0tab(:,5458),[57,6],[nMT,nMT],2,2,wf24(:,114),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,114),G0H4(207),m3h24x4(:,1177),heltab2x96(:,:,5330))
  call Hloop_Q_A(ntryL,G0H4(207),57,nMT,G1H4(620),n2h4(1019))
  Gcoeff(:)%j = (-(c(256)*M(3,:)%j)) * den(477)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5459),h0tab(:,5459),[57,6],[nMB,nMB],2,2,wf24(:,114),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,114),G0H4(207),m3h24x4(:,1178),heltab2x96(:,:,5331))
  call Hloop_Q_A(ntryL,G0H4(207),57,nMB,G1H4(621),n2h4(1020))
  Gcoeff(:)%j = (c(262)*M(3,:)%j) * den(478)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5460),h0tab(:,5460),[57,6],[nME,nME],2,2,wf24(:,115),wf4(:,7))
  call Hloop_QZ_A(ntryL,G0H96(1),wf24(:,115),G0H4(207),ngZl,m3h24x4(:,1179),heltab2x96(:,:,5332))
  call Hloop_Q_A(ntryL,G0H4(207),57,nME,G1H4(622),n2h4(1021))
  Gcoeff(:)%j = (c(268)*M(3,:)%j) * den(478)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5461),h0tab(:,5461),[57,6],[nMM,nMM],2,2,wf24(:,115),wf4(:,7))
  call Hloop_QZ_A(ntryL,G0H96(1),wf24(:,115),G0H4(207),ngZl,m3h24x4(:,1180),heltab2x96(:,:,5333))
  call Hloop_Q_A(ntryL,G0H4(207),57,nMM,G1H4(623),n2h4(1022))
  Gcoeff(:)%j = (c(265)*M(3,:)%j) * den(478)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5462),h0tab(:,5462),[57,6],[nML,nML],2,2,wf24(:,115),wf4(:,7))
  call Hloop_QZ_A(ntryL,G0H96(1),wf24(:,115),G0H4(207),ngZl,m3h24x4(:,1181),heltab2x96(:,:,5334))
  call Hloop_Q_A(ntryL,G0H4(207),57,nML,G1H4(624),n2h4(1023))
  Gcoeff(:)%j = (c(272)*M(3,:)%j) * den(478)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5463),h0tab(:,5463),[57,6],[nMT,nMT],2,2,wf24(:,115),wf4(:,7))
  call Hloop_QZ_A(ntryL,G0H96(1),wf24(:,115),G0H4(207),ngZu,m3h24x4(:,1182),heltab2x96(:,:,5335))
  call Hloop_Q_A(ntryL,G0H4(207),57,nMT,G1H4(625),n2h4(1024))
  Gcoeff(:)%j = (c(258)*M(3,:)%j) * den(478)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5464),h0tab(:,5464),[57,6],[nMB,nMB],2,2,wf24(:,115),wf4(:,7))
  call Hloop_QZ_A(ntryL,G0H96(1),wf24(:,115),G0H4(207),ngZd,m3h24x4(:,1183),heltab2x96(:,:,5336))
  call Hloop_Q_A(ntryL,G0H4(207),57,nMB,G1H4(626),n2h4(1025))
  Gcoeff(:)%j = (c(262)*M(3,:)%j) * den(479)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5465),h0tab(:,5465),[57,6],[nME,nME],2,2,wf24(:,115),wf4(:,17))
  call Hloop_QZ_A(ntryL,G0H96(1),wf24(:,115),G0H4(207),ngZl,m3h24x4(:,1184),heltab2x96(:,:,5337))
  call Hloop_Q_A(ntryL,G0H4(207),57,nME,G1H4(627),n2h4(1026))
  Gcoeff(:)%j = (c(268)*M(3,:)%j) * den(479)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5466),h0tab(:,5466),[57,6],[nMM,nMM],2,2,wf24(:,115),wf4(:,17))
  call Hloop_QZ_A(ntryL,G0H96(1),wf24(:,115),G0H4(207),ngZl,m3h24x4(:,1185),heltab2x96(:,:,5338))
  call Hloop_Q_A(ntryL,G0H4(207),57,nMM,G1H4(628),n2h4(1027))
  Gcoeff(:)%j = (c(265)*M(3,:)%j) * den(479)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5467),h0tab(:,5467),[57,6],[nML,nML],2,2,wf24(:,115),wf4(:,17))
  call Hloop_QZ_A(ntryL,G0H96(1),wf24(:,115),G0H4(207),ngZl,m3h24x4(:,1186),heltab2x96(:,:,5339))
  call Hloop_Q_A(ntryL,G0H4(207),57,nML,G1H4(629),n2h4(1028))
  Gcoeff(:)%j = (-(c(272)*M(3,:)%j)) * den(479)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5468),h0tab(:,5468),[57,6],[nMT,nMT],2,2,wf24(:,115),wf4(:,17))
  call Hloop_QZ_A(ntryL,G0H96(1),wf24(:,115),G0H4(207),ngZu,m3h24x4(:,1187),heltab2x96(:,:,5340))
  call Hloop_Q_A(ntryL,G0H4(207),57,nMT,G1H4(630),n2h4(1029))
  Gcoeff(:)%j = (c(258)*M(3,:)%j) * den(479)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5469),h0tab(:,5469),[57,6],[nMB,nMB],2,2,wf24(:,115),wf4(:,17))
  call Hloop_QZ_A(ntryL,G0H96(1),wf24(:,115),G0H4(207),ngZd,m3h24x4(:,1188),heltab2x96(:,:,5341))
  call Hloop_Q_A(ntryL,G0H4(207),57,nMB,G1H4(631),n2h4(1030))
  Gcoeff(:)%j = (-(c(90)*M(3,:)%j)) * den(476)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5470),h0tab(:,5470),[57,6],[nMW,nMW],2,2,wf24(:,114),wf4(:,7))
  call Hloop_TV_S(ntryL,G0H96(1),0,wf24(:,114),57,G1H4(632),m3h24x4(:,1189),heltab2x96(:,:,5342))
  Gcoeff(:)%j = (c(204)*M(3,:)%j) * den(478)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5471),h0tab(:,5471),[57,6],[nMW,nMW],2,2,wf24(:,115),wf4(:,7))
  call Hloop_TV_S(ntryL,G0H96(1),0,wf24(:,115),57,G1H4(633),m3h24x4(:,1190),heltab2x96(:,:,5343))
  Gcoeff(:)%j = (-(c(56)*M(3,:)%j)) * den(479)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5472),h0tab(:,5472),[57,6],[nMZ,nMH],2,2,wf24(:,115),wf4(:,17))
  call Hloop_TV_S(ntryL,G0H96(1),0,wf24(:,115),57,G1H4(634),m3h24x4(:,1191),heltab2x96(:,:,5344))
  Gcoeff(:)%j = (-(c(76)*M(3,:)%j)) * den(476)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5473),h0tab(:,5473),[57,6],[nMW,nMW],2,2,wf24(:,114),wf4(:,7))
  call Hloop_CV_D(ntryL,G0H96(1),0,wf24(:,114),57,G1H4(635),m3h24x4(:,1192),heltab2x96(:,:,5345))
  Gcoeff(:)%j = (c(76)*M(3,:)%j) * den(476)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5474),h0tab(:,5474),[57,6],[nMW,nMW],2,2,wf24(:,114),wf4(:,7))
  call Hloop_CV_D(ntryL,G0H96(1),0,wf24(:,114),57,G1H4(636),m3h24x4(:,1193),heltab2x96(:,:,5346))
  Gcoeff(:)%j = (-(c(76)*M(3,:)%j)) * den(477)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5475),h0tab(:,5475),[57,6],[nMW,nMW],2,2,wf24(:,114),wf4(:,17))
  call Hloop_CV_D(ntryL,G0H96(1),0,wf24(:,114),57,G1H4(637),m3h24x4(:,1194),heltab2x96(:,:,5347))
  Gcoeff(:)%j = (-(c(76)*M(3,:)%j)) * den(477)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5476),h0tab(:,5476),[57,6],[nMW,nMW],2,2,wf24(:,114),wf4(:,17))
  call Hloop_CV_D(ntryL,G0H96(1),0,wf24(:,114),57,G1H4(638),m3h24x4(:,1195),heltab2x96(:,:,5348))
  Gcoeff(:)%j = (-(c(54)*M(3,:)%j)) * den(478)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5477),h0tab(:,5477),[57,6],[nMW,nMW],2,2,wf24(:,115),wf4(:,7))
  call Hloop_CV_D(ntryL,G0H96(1),0,wf24(:,115),57,G1H4(639),m3h24x4(:,1196),heltab2x96(:,:,5349))
  Gcoeff(:)%j = (c(54)*M(3,:)%j) * den(478)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5478),h0tab(:,5478),[57,6],[nMW,nMW],2,2,wf24(:,115),wf4(:,7))
  call Hloop_CV_D(ntryL,G0H96(1),0,wf24(:,115),57,G1H4(640),m3h24x4(:,1197),heltab2x96(:,:,5350))
  Gcoeff(:)%j = (-(c(54)*M(3,:)%j)) * den(479)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5479),h0tab(:,5479),[57,6],[nMW,nMW],2,2,wf24(:,115),wf4(:,17))
  call Hloop_CV_D(ntryL,G0H96(1),0,wf24(:,115),57,G1H4(641),m3h24x4(:,1198),heltab2x96(:,:,5351))
  Gcoeff(:)%j = (-(c(54)*M(3,:)%j)) * den(479)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5480),h0tab(:,5480),[57,6],[nMW,nMW],2,2,wf24(:,115),wf4(:,17))
  call Hloop_CV_D(ntryL,G0H96(1),0,wf24(:,115),57,G1H4(642),m3h24x4(:,1199),heltab2x96(:,:,5352))
  Gcoeff(:)%j = (-(c(79)*M(3,:)%j)) * den(476)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5481),h0tab(:,5481),[57,6],[nMW,nMW],2,2,wf24(:,114),wf4(:,7))
  call Hloop_UV_W(ntryL,G0H96(1),0,wf24(:,114),57,G1H4(643),m3h24x4(:,1200),heltab2x96(:,:,5353))
  Gcoeff(:)%j = (-(c(55)*M(3,:)%j)) * den(478)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5482),h0tab(:,5482),[57,6],[nMW,nMW],2,2,wf24(:,115),wf4(:,7))
  call Hloop_UV_W(ntryL,G0H96(1),0,wf24(:,115),57,G1H4(644),m3h24x4(:,1201),heltab2x96(:,:,5354))
  Gcoeff(:)%j = (-(c(76)*M(3,:)%j)) * den(476)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5483),h0tab(:,5483),[57,6],[nMW,nMW],2,2,wf24(:,114),wf4(:,7))
  call Hloop_SV_V(ntryL,G0H96(1),wf24(:,114),G0H4(207),m3h24x4(:,1202),heltab2x96(:,:,5355))
  Gcoeff(:)%j = (c(76)*M(3,:)%j) * den(476)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5484),h0tab(:,5484),[57,6],[nMW,nMW],2,2,wf24(:,114),wf4(:,7))
  call Hloop_SV_V(ntryL,G0H96(1),wf24(:,114),G0H4(208),m3h24x4(:,1203),heltab2x96(:,:,5356))
  Gcoeff(:)%j = (-(c(76)*M(3,:)%j)) * den(477)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5485),h0tab(:,5485),[57,6],[nMW,nMW],2,2,wf24(:,114),wf4(:,17))
  call Hloop_SV_V(ntryL,G0H96(1),wf24(:,114),G0H4(209),m3h24x4(:,1204),heltab2x96(:,:,5357))
  Gcoeff(:)%j = (-(c(76)*M(3,:)%j)) * den(477)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5486),h0tab(:,5486),[57,6],[nMW,nMW],2,2,wf24(:,114),wf4(:,17))
  call Hloop_SV_V(ntryL,G0H96(1),wf24(:,114),G0H4(210),m3h24x4(:,1205),heltab2x96(:,:,5358))
  Gcoeff(:)%j = (c(138)*M(3,:)%j) * den(478)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5487),h0tab(:,5487),[57,6],[nMW,nMW],2,2,wf24(:,115),wf4(:,7))
  call Hloop_SV_V(ntryL,G0H96(1),wf24(:,115),G0H4(211),m3h24x4(:,1206),heltab2x96(:,:,5359))
  Gcoeff(:)%j = (-(c(138)*M(3,:)%j)) * den(478)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5488),h0tab(:,5488),[57,6],[nMW,nMW],2,2,wf24(:,115),wf4(:,7))
  call Hloop_SV_V(ntryL,G0H96(1),wf24(:,115),G0H4(212),m3h24x4(:,1207),heltab2x96(:,:,5360))
  Gcoeff(:)%j = (-(c(51)*M(3,:)%j)) * den(479)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5489),h0tab(:,5489),[57,6],[nMZ,nMH],2,2,wf24(:,115),wf4(:,17))
  call Hloop_SV_V(ntryL,G0H96(1),wf24(:,115),G0H4(213),m3h24x4(:,1208),heltab2x96(:,:,5361))
  Gcoeff(:)%j = (c(138)*M(3,:)%j) * den(479)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5490),h0tab(:,5490),[57,6],[nMW,nMW],2,2,wf24(:,115),wf4(:,17))
  call Hloop_SV_V(ntryL,G0H96(1),wf24(:,115),G0H4(214),m3h24x4(:,1209),heltab2x96(:,:,5362))
  Gcoeff(:)%j = (c(138)*M(3,:)%j) * den(479)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5491),h0tab(:,5491),[57,6],[nMW,nMW],2,2,wf24(:,115),wf4(:,17))
  call Hloop_SV_V(ntryL,G0H96(1),wf24(:,115),G0H4(215),m3h24x4(:,1210),heltab2x96(:,:,5363))
  Gcoeff(:)%j = (-(c(315)*M(3,:)%j)) * den(480)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5492),h0tab(:,5492),[57,6],[nME,nME],2,2,wf24(:,114),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,114),G0H4(216),m3h24x4(:,1211),heltab2x96(:,:,5364))
  call Hloop_Q_A(ntryL,G0H4(216),57,nME,G1H4(645),n2h4(1031))
  Gcoeff(:)%j = (-(c(315)*M(3,:)%j)) * den(480)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5493),h0tab(:,5493),[57,6],[nMM,nMM],2,2,wf24(:,114),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H96(1),wf24(:,114),G0H4(216),m3h24x4(:,1212),heltab2x96(:,:,5365))



end subroutine vamp_25

end module ol_vamp_25_ppwttj_ew_uxttxdwxg_3_/**/REALKIND
