
module ol_vamp_1_ppwttj_ew_uxttxdwxg_4_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppwttj_ew_uxttxdwxg_4.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppwttj_ew_uxttxdwxg_4.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_ppwttj_ew_uxttxdwxg_4_/**/DREALKIND
  use ol_tensor_sum_storage_ppwttj_ew_uxttxdwxg_4_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_ppwttj_ew_uxttxdwxg_4_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_ppwttj_ew_uxttxdwxg_4_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL, hel_states
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(hel_states)
  type(Hpolcont), intent(in) :: M(2,hel_states)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel(1:hel_states)
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel(1:hel_states)
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

  Gcoeff(:)%j = (-(c(97)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1),h0tab(:,1),[32,4,8,1,2,16],[nMT,0,0,nMW,nMB,nMT],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,1),heltab2x96(:,:,1))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(1),n2h48(1))
  Gcoeff(:)%j = (c(101)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2),h0tab(:,2),[32,4,8,1,2,16],[nMT,nMZ,0,nMW,nMB,nMT],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,2),heltab2x96(:,:,2))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(2),n2h48(2))
  Gcoeff(:)%j = (-(c(97)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(3),h0tab(:,3),[32,2,1,8,4,16],[nMB,nMW,0,0,nMT,nMB],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,3),heltab2x96(:,:,3))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMB,G1H48(3),n2h48(3))
  Gcoeff(:)%j = (c(101)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4),h0tab(:,4),[32,2,1,8,4,16],[nMB,nMW,0,nMZ,nMT,nMB],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,4),heltab2x96(:,:,4))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMB,G1H48(4),n2h48(4))
  Gcoeff(:)%j = (-(c(77)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5),h0tab(:,5),[32,2,1,8,16,4],[nMT,0,0,nMW,nMH,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,5),heltab2x96(:,:,5))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(5),n2h48(5))
  Gcoeff(:)%j = (-(c(98)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(6),h0tab(:,6),[32,2,1,8,16,4],[nMB,nMW,0,0,nMW,nMB],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,6),heltab2x96(:,:,6))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMB,G1H48(6),n2h48(6))
  Gcoeff(:)%j = (-(c(80)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(7),h0tab(:,7),[32,2,1,8,16,4],[nMT,nMZ,0,nMW,nMH,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,7),heltab2x96(:,:,7))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(7),n2h48(7))
  Gcoeff(:)%j = (-(c(121)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(8),h0tab(:,8),[32,2,1,8,16,4],[nMB,nMW,0,nMZ,nMW,nMB],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,8),heltab2x96(:,:,8))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMB,G1H48(8),n2h48(8))
  Gcoeff(:)%j = (c(130)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(9),h0tab(:,9),[32,2,1,8,16,4],[nMT,0,0,nMW,0,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,9),heltab2x96(:,:,9))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(9),n2h48(9))
  Gcoeff(:)%j = (c(113)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(10),h0tab(:,10),[32,2,1,8,16,4],[nMT,0,0,nMW,nMZ,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,10),heltab2x96(:,:,10))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(10),n2h48(10))
  Gcoeff(:)%j = (c(133)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(11),h0tab(:,11),[32,2,1,8,16,4],[nMT,nMZ,0,nMW,0,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,11),heltab2x96(:,:,11))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(11),n2h48(11))
  Gcoeff(:)%j = (c(115)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(12),h0tab(:,12),[32,2,1,8,16,4],[nMT,nMZ,0,nMW,nMZ,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,12),heltab2x96(:,:,12))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(12),n2h48(12))
  Gcoeff(:)%j = (-(c(98)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(13),h0tab(:,13),[32,2,1,8,16,4],[nMB,nMW,0,0,nMW,nMB],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,13),heltab2x96(:,:,13))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMB,G1H48(13),n2h48(13))
  Gcoeff(:)%j = (c(63)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(14),h0tab(:,14),[32,2,1,8,16,4],[nMB,nMW,0,nMZ,nMW,nMB],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,14),heltab2x96(:,:,14))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMB,G1H48(14),n2h48(14))
  Gcoeff(:)%j = (-(c(125)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(15),h0tab(:,15),[32,8,4,2,1,16],[0,0,nMT,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,15),heltab2x96(:,:,15))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(15),n2h48(15))
  Gcoeff(:)%j = (c(132)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(16),h0tab(:,16),[32,8,4,2,1,16],[0,nMZ,nMT,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,16),heltab2x96(:,:,16))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(16),n2h48(16))
  Gcoeff(:)%j = (-(c(129)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(17),h0tab(:,17),[32,8,4,2,1,16],[0,0,nMT,nMZ,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,17),heltab2x96(:,:,17))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(17),n2h48(17))
  Gcoeff(:)%j = (c(134)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(18),h0tab(:,18),[32,8,4,2,1,16],[0,nMZ,nMT,nMZ,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,18),heltab2x96(:,:,18))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(18),n2h48(18))
  Gcoeff(:)%j = (-(c(125)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(19),h0tab(:,19),[32,2,1,16,8,4],[nMT,0,0,0,0,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,19),heltab2x96(:,:,19))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(19),n2h48(19))
  Gcoeff(:)%j = (c(132)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(20),h0tab(:,20),[32,2,1,16,8,4],[nMT,0,0,0,nMZ,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,20),heltab2x96(:,:,20))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(20),n2h48(20))
  Gcoeff(:)%j = (-(c(129)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(21),h0tab(:,21),[32,2,1,16,8,4],[nMT,nMZ,0,0,0,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,21),heltab2x96(:,:,21))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(21),n2h48(21))
  Gcoeff(:)%j = (c(134)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(22),h0tab(:,22),[32,2,1,16,8,4],[nMT,nMZ,0,0,nMZ,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,22),heltab2x96(:,:,22))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(22),n2h48(22))
  Gcoeff(:)%j = (-(c(125)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(23),h0tab(:,23),[32,1,2,4,8,16],[0,0,nMT,0,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,23),heltab2x96(:,:,23))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(23),n2h48(23))
  Gcoeff(:)%j = (c(132)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(24),h0tab(:,24),[32,1,2,4,8,16],[0,0,nMT,nMZ,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,24),heltab2x96(:,:,24))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(24),n2h48(24))
  Gcoeff(:)%j = (-(c(129)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(25),h0tab(:,25),[32,1,2,4,8,16],[0,nMZ,nMT,0,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,25),heltab2x96(:,:,25))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(25),n2h48(25))
  Gcoeff(:)%j = (c(134)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(26),h0tab(:,26),[32,1,2,4,8,16],[0,nMZ,nMT,nMZ,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,26),heltab2x96(:,:,26))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(26),n2h48(26))
  Gcoeff(:)%j = (-(c(77)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(27),h0tab(:,27),[32,1,2,4,16,8],[0,0,nMT,nMH,nMW,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,27),heltab2x96(:,:,27))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(27),n2h48(27))
  Gcoeff(:)%j = (-(c(98)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(28),h0tab(:,28),[32,1,2,4,16,8],[0,nMW,nMB,nMW,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,28),heltab2x96(:,:,28))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(28),n2h48(28))
  Gcoeff(:)%j = (-(c(80)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(29),h0tab(:,29),[32,1,2,4,16,8],[0,nMZ,nMT,nMH,nMW,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,29),heltab2x96(:,:,29))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(29),n2h48(29))
  Gcoeff(:)%j = (-(c(121)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(30),h0tab(:,30),[32,1,2,4,16,8],[0,nMW,nMB,nMW,nMZ,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,30),heltab2x96(:,:,30))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(30),n2h48(30))
  Gcoeff(:)%j = (c(130)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(31),h0tab(:,31),[32,1,2,4,16,8],[0,0,nMT,0,nMW,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,31),heltab2x96(:,:,31))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(31),n2h48(31))
  Gcoeff(:)%j = (c(113)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(32),h0tab(:,32),[32,1,2,4,16,8],[0,0,nMT,nMZ,nMW,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,32),heltab2x96(:,:,32))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(32),n2h48(32))
  Gcoeff(:)%j = (c(133)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(33),h0tab(:,33),[32,1,2,4,16,8],[0,nMZ,nMT,0,nMW,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,33),heltab2x96(:,:,33))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(33),n2h48(33))
  Gcoeff(:)%j = (c(115)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(34),h0tab(:,34),[32,1,2,4,16,8],[0,nMZ,nMT,nMZ,nMW,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,34),heltab2x96(:,:,34))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(34),n2h48(34))
  Gcoeff(:)%j = (-(c(98)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(35),h0tab(:,35),[32,1,2,4,16,8],[0,nMW,nMB,nMW,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,35),heltab2x96(:,:,35))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(35),n2h48(35))
  Gcoeff(:)%j = (c(63)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(36),h0tab(:,36),[32,1,2,4,16,8],[0,nMW,nMB,nMW,nMZ,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,36),heltab2x96(:,:,36))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(36),n2h48(36))
  Gcoeff(:)%j = (-(c(97)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(37),h0tab(:,37),[32,1,2,16,4,8],[0,nMW,nMB,nMT,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,37),heltab2x96(:,:,37))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(37),n2h48(37))
  Gcoeff(:)%j = (c(101)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(38),h0tab(:,38),[32,1,2,16,4,8],[0,nMW,nMB,nMT,nMZ,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,38),heltab2x96(:,:,38))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(38),n2h48(38))
  Gcoeff(:)%j = (c(99)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(39),h0tab(:,39),[32,4,1,8,2,16],[nMT,0,0,nMW,nMB,nMT],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,39),heltab2x96(:,:,39))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(39),n2h48(39))
  Gcoeff(:)%j = (c(101)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(40),h0tab(:,40),[32,4,1,8,2,16],[nMT,nMZ,0,nMW,nMB,nMT],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,40),heltab2x96(:,:,40))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(40),n2h48(40))
  Gcoeff(:)%j = (c(99)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(41),h0tab(:,41),[32,2,8,1,4,16],[nMB,nMW,0,0,nMT,nMB],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,41),heltab2x96(:,:,41))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMB,G1H48(41),n2h48(41))
  Gcoeff(:)%j = (c(101)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(42),h0tab(:,42),[32,2,8,1,4,16],[nMB,nMW,0,nMZ,nMT,nMB],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,42),heltab2x96(:,:,42))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMB,G1H48(42),n2h48(42))
  Gcoeff(:)%j = (-(c(77)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(43),h0tab(:,43),[32,2,16,8,1,4],[nMT,nMH,nMW,0,0,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,43),heltab2x96(:,:,43))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(43),n2h48(43))
  Gcoeff(:)%j = (-(c(80)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(44),h0tab(:,44),[32,2,16,8,1,4],[nMT,nMH,nMW,0,nMZ,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,44),heltab2x96(:,:,44))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(44),n2h48(44))
  Gcoeff(:)%j = (c(130)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(45),h0tab(:,45),[32,2,16,8,1,4],[nMT,0,nMW,0,0,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,45),heltab2x96(:,:,45))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(45),n2h48(45))
  Gcoeff(:)%j = (c(113)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(46),h0tab(:,46),[32,2,16,8,1,4],[nMT,nMZ,nMW,0,0,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,46),heltab2x96(:,:,46))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(46),n2h48(46))
  Gcoeff(:)%j = (c(133)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(47),h0tab(:,47),[32,2,16,8,1,4],[nMT,0,nMW,0,nMZ,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,47),heltab2x96(:,:,47))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(47),n2h48(47))
  Gcoeff(:)%j = (c(115)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(48),h0tab(:,48),[32,2,16,8,1,4],[nMT,nMZ,nMW,0,nMZ,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,48),heltab2x96(:,:,48))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(48),n2h48(48))
  Gcoeff(:)%j = (-(c(125)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(49),h0tab(:,49),[32,8,2,4,1,16],[0,0,nMT,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,49),heltab2x96(:,:,49))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(49),n2h48(49))
  Gcoeff(:)%j = (c(132)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(50),h0tab(:,50),[32,8,2,4,1,16],[0,nMZ,nMT,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,50),heltab2x96(:,:,50))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(50),n2h48(50))
  Gcoeff(:)%j = (-(c(129)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(51),h0tab(:,51),[32,8,2,4,1,16],[0,0,nMT,nMZ,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,51),heltab2x96(:,:,51))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(51),n2h48(51))
  Gcoeff(:)%j = (c(134)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(52),h0tab(:,52),[32,8,2,4,1,16],[0,nMZ,nMT,nMZ,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,52),heltab2x96(:,:,52))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(52),n2h48(52))
  Gcoeff(:)%j = (-(c(125)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(53),h0tab(:,53),[32,2,8,16,1,4],[nMT,0,0,0,0,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,53),heltab2x96(:,:,53))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(53),n2h48(53))
  Gcoeff(:)%j = (c(132)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(54),h0tab(:,54),[32,2,8,16,1,4],[nMT,nMZ,0,0,0,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,54),heltab2x96(:,:,54))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(54),n2h48(54))
  Gcoeff(:)%j = (-(c(129)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(55),h0tab(:,55),[32,2,8,16,1,4],[nMT,0,0,0,nMZ,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,55),heltab2x96(:,:,55))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(55),n2h48(55))
  Gcoeff(:)%j = (c(134)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(56),h0tab(:,56),[32,2,8,16,1,4],[nMT,nMZ,0,0,nMZ,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,56),heltab2x96(:,:,56))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(56),n2h48(56))
  Gcoeff(:)%j = (-(c(125)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(57),h0tab(:,57),[32,1,4,2,8,16],[0,0,nMT,0,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,57),heltab2x96(:,:,57))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(57),n2h48(57))
  Gcoeff(:)%j = (c(132)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(58),h0tab(:,58),[32,1,4,2,8,16],[0,0,nMT,nMZ,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,58),heltab2x96(:,:,58))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(58),n2h48(58))
  Gcoeff(:)%j = (-(c(129)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(59),h0tab(:,59),[32,1,4,2,8,16],[0,nMZ,nMT,0,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,59),heltab2x96(:,:,59))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(59),n2h48(59))
  Gcoeff(:)%j = (c(134)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(60),h0tab(:,60),[32,1,4,2,8,16],[0,nMZ,nMT,nMZ,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,60),heltab2x96(:,:,60))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(60),n2h48(60))
  Gcoeff(:)%j = (-(c(77)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(61),h0tab(:,61),[32,1,4,2,16,8],[0,0,nMT,nMH,nMW,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,61),heltab2x96(:,:,61))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(61),n2h48(61))
  Gcoeff(:)%j = (-(c(80)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(62),h0tab(:,62),[32,1,4,2,16,8],[0,nMZ,nMT,nMH,nMW,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,62),heltab2x96(:,:,62))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(62),n2h48(62))
  Gcoeff(:)%j = (c(130)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(63),h0tab(:,63),[32,1,4,2,16,8],[0,0,nMT,0,nMW,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,63),heltab2x96(:,:,63))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(63),n2h48(63))
  Gcoeff(:)%j = (c(113)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(64),h0tab(:,64),[32,1,4,2,16,8],[0,0,nMT,nMZ,nMW,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,64),heltab2x96(:,:,64))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(64),n2h48(64))
  Gcoeff(:)%j = (c(133)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(65),h0tab(:,65),[32,1,4,2,16,8],[0,nMZ,nMT,0,nMW,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,65),heltab2x96(:,:,65))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(65),n2h48(65))
  Gcoeff(:)%j = (c(115)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(66),h0tab(:,66),[32,1,4,2,16,8],[0,nMZ,nMT,nMZ,nMW,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,66),heltab2x96(:,:,66))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(66),n2h48(66))
  Gcoeff(:)%j = (c(99)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(67),h0tab(:,67),[32,1,4,16,2,8],[0,0,nMT,nMB,nMW,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,67),heltab2x96(:,:,67))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(67),n2h48(67))
  Gcoeff(:)%j = (c(101)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(68),h0tab(:,68),[32,1,4,16,2,8],[0,nMZ,nMT,nMB,nMW,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,68),heltab2x96(:,:,68))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(68),n2h48(68))
  Gcoeff(:)%j = (c(75)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(69),h0tab(:,69),[32,2,8,1,16,4],[nMT,0,0,nMW,nMH,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,69),heltab2x96(:,:,69))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(69),n2h48(69))
  Gcoeff(:)%j = (c(100)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(70),h0tab(:,70),[32,2,8,1,16,4],[nMB,nMW,0,0,nMW,nMB],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,70),heltab2x96(:,:,70))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMB,G1H48(70),n2h48(70))
  Gcoeff(:)%j = (-(c(80)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(71),h0tab(:,71),[32,2,8,1,16,4],[nMT,nMZ,0,nMW,nMH,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,71),heltab2x96(:,:,71))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(71),n2h48(71))
  Gcoeff(:)%j = (-(c(121)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(72),h0tab(:,72),[32,2,8,1,16,4],[nMB,nMW,0,nMZ,nMW,nMB],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,72),heltab2x96(:,:,72))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMB,G1H48(72),n2h48(72))
  Gcoeff(:)%j = (-(c(127)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(73),h0tab(:,73),[32,2,8,1,16,4],[nMT,0,0,nMW,0,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,73),heltab2x96(:,:,73))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(73),n2h48(73))
  Gcoeff(:)%j = (-(c(111)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(74),h0tab(:,74),[32,2,8,1,16,4],[nMT,0,0,nMW,nMZ,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,74),heltab2x96(:,:,74))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(74),n2h48(74))
  Gcoeff(:)%j = (c(133)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(75),h0tab(:,75),[32,2,8,1,16,4],[nMT,nMZ,0,nMW,0,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,75),heltab2x96(:,:,75))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(75),n2h48(75))
  Gcoeff(:)%j = (c(115)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(76),h0tab(:,76),[32,2,8,1,16,4],[nMT,nMZ,0,nMW,nMZ,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,76),heltab2x96(:,:,76))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(76),n2h48(76))
  Gcoeff(:)%j = (c(100)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(77),h0tab(:,77),[32,2,8,1,16,4],[nMB,nMW,0,0,nMW,nMB],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,77),heltab2x96(:,:,77))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMB,G1H48(77),n2h48(77))
  Gcoeff(:)%j = (c(63)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(78),h0tab(:,78),[32,2,8,1,16,4],[nMB,nMW,0,nMZ,nMW,nMB],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,78),heltab2x96(:,:,78))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMB,G1H48(78),n2h48(78))
  Gcoeff(:)%j = (c(75)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(79),h0tab(:,79),[32,2,16,1,8,4],[nMT,nMH,nMW,0,0,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,79),heltab2x96(:,:,79))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(79),n2h48(79))
  Gcoeff(:)%j = (-(c(80)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(80),h0tab(:,80),[32,2,16,1,8,4],[nMT,nMH,nMW,0,nMZ,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,80),heltab2x96(:,:,80))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(80),n2h48(80))
  Gcoeff(:)%j = (-(c(127)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(81),h0tab(:,81),[32,2,16,1,8,4],[nMT,0,nMW,0,0,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,81),heltab2x96(:,:,81))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(81),n2h48(81))
  Gcoeff(:)%j = (c(133)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(82),h0tab(:,82),[32,2,16,1,8,4],[nMT,0,nMW,0,nMZ,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,82),heltab2x96(:,:,82))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(82),n2h48(82))
  Gcoeff(:)%j = (-(c(111)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(83),h0tab(:,83),[32,2,16,1,8,4],[nMT,nMZ,nMW,0,0,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,83),heltab2x96(:,:,83))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(83),n2h48(83))
  Gcoeff(:)%j = (c(115)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(84),h0tab(:,84),[32,2,16,1,8,4],[nMT,nMZ,nMW,0,nMZ,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,84),heltab2x96(:,:,84))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(84),n2h48(84))
  Gcoeff(:)%j = (c(75)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(85),h0tab(:,85),[32,1,16,4,2,8],[0,nMW,nMH,nMT,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,85),heltab2x96(:,:,85))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(85),n2h48(85))
  Gcoeff(:)%j = (c(100)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(86),h0tab(:,86),[32,1,16,4,2,8],[0,0,nMW,nMB,nMW,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,86),heltab2x96(:,:,86))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(86),n2h48(86))
  Gcoeff(:)%j = (-(c(80)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(87),h0tab(:,87),[32,1,16,4,2,8],[0,nMW,nMH,nMT,nMZ,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,87),heltab2x96(:,:,87))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(87),n2h48(87))
  Gcoeff(:)%j = (-(c(121)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(88),h0tab(:,88),[32,1,16,4,2,8],[0,nMZ,nMW,nMB,nMW,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,88),heltab2x96(:,:,88))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(88),n2h48(88))
  Gcoeff(:)%j = (-(c(127)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(89),h0tab(:,89),[32,1,16,4,2,8],[0,nMW,0,nMT,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,89),heltab2x96(:,:,89))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(89),n2h48(89))
  Gcoeff(:)%j = (-(c(111)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(90),h0tab(:,90),[32,1,16,4,2,8],[0,nMW,nMZ,nMT,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,90),heltab2x96(:,:,90))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(90),n2h48(90))
  Gcoeff(:)%j = (c(133)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(91),h0tab(:,91),[32,1,16,4,2,8],[0,nMW,0,nMT,nMZ,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,91),heltab2x96(:,:,91))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(91),n2h48(91))
  Gcoeff(:)%j = (c(115)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(92),h0tab(:,92),[32,1,16,4,2,8],[0,nMW,nMZ,nMT,nMZ,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,92),heltab2x96(:,:,92))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(92),n2h48(92))
  Gcoeff(:)%j = (c(100)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(93),h0tab(:,93),[32,1,16,4,2,8],[0,0,nMW,nMB,nMW,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,93),heltab2x96(:,:,93))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(93),n2h48(93))
  Gcoeff(:)%j = (c(63)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(94),h0tab(:,94),[32,1,16,4,2,8],[0,nMZ,nMW,nMB,nMW,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,94),heltab2x96(:,:,94))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(94),n2h48(94))
  Gcoeff(:)%j = (c(75)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(95),h0tab(:,95),[32,1,16,2,4,8],[0,nMW,nMH,nMT,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,95),heltab2x96(:,:,95))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(95),n2h48(95))
  Gcoeff(:)%j = (-(c(80)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(96),h0tab(:,96),[32,1,16,2,4,8],[0,nMW,nMH,nMT,nMZ,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,96),heltab2x96(:,:,96))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(96),n2h48(96))
  Gcoeff(:)%j = (-(c(127)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(97),h0tab(:,97),[32,1,16,2,4,8],[0,nMW,0,nMT,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,97),heltab2x96(:,:,97))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(97),n2h48(97))
  Gcoeff(:)%j = (c(133)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(98),h0tab(:,98),[32,1,16,2,4,8],[0,nMW,0,nMT,nMZ,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,98),heltab2x96(:,:,98))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(98),n2h48(98))
  Gcoeff(:)%j = (-(c(111)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(99),h0tab(:,99),[32,1,16,2,4,8],[0,nMW,nMZ,nMT,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,99),heltab2x96(:,:,99))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(99),n2h48(99))
  Gcoeff(:)%j = (c(115)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(100),h0tab(:,100),[32,1,16,2,4,8],[0,nMW,nMZ,nMT,nMZ,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,100),heltab2x96(:,:,100))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(100),n2h48(100))
  call Hloop_QA_V(ntryL,G1H48(1),ex3(:),G1H24(1),m3h2x24(:,1),heltab2x48(:,:,1))
  call Hloop_QA_Z(ntryL,G1H48(2),ex3(:),G1H24(2),ngZu,m3h2x24(:,2),heltab2x48(:,:,2))
  call Hloop_AQ_W(ntryL,G1H48(3),ex2(:),G1H24(3),m3h2x24(:,3),heltab2x48(:,:,3))
  call Hloop_AQ_W(ntryL,G1H48(4),ex2(:),G1H24(4),m3h2x24(:,4),heltab2x48(:,:,4))
  call Hloop_AQ_V(ntryL,G1H48(5),ex2(:),G1H24(5),m3h2x24(:,5),heltab2x48(:,:,5))
  call Hloop_AQ_W(ntryL,G1H48(6),ex2(:),G1H24(6),m3h2x24(:,6),heltab2x48(:,:,6))
  call Hloop_AQ_Z(ntryL,G1H48(7),ex2(:),G1H24(7),ngZu,m3h2x24(:,7),heltab2x48(:,:,7))
  call Hloop_AQ_W(ntryL,G1H48(8),ex2(:),G1H24(8),m3h2x24(:,8),heltab2x48(:,:,8))
  call Hloop_AQ_V(ntryL,G1H48(9),ex2(:),G1H24(9),m3h2x24(:,9),heltab2x48(:,:,9))
  call Hloop_AQ_V(ntryL,G1H48(10),ex2(:),G1H24(10),m3h2x24(:,10),heltab2x48(:,:,10))
  call Hloop_AQ_Z(ntryL,G1H48(11),ex2(:),G1H24(11),ngZu,m3h2x24(:,11),heltab2x48(:,:,11))
  call Hloop_AQ_Z(ntryL,G1H48(12),ex2(:),G1H24(12),ngZu,m3h2x24(:,12),heltab2x48(:,:,12))
  call Hloop_AQ_W(ntryL,G1H48(13),ex2(:),G1H24(13),m3h2x24(:,13),heltab2x48(:,:,13))
  call Hloop_AQ_W(ntryL,G1H48(14),ex2(:),G1H24(14),m3h2x24(:,14),heltab2x48(:,:,14))
  call Hloop_AQ_V(ntryL,G1H48(15),ex4(:),G1H24(15),m3h2x24(:,15),heltab2x48(:,:,15))
  call Hloop_AQ_Z(ntryL,G1H48(16),ex4(:),G1H24(16),ngZd,m3h2x24(:,16),heltab2x48(:,:,16))
  call Hloop_AQ_V(ntryL,G1H48(17),ex4(:),G1H24(17),m3h2x24(:,17),heltab2x48(:,:,17))
  call Hloop_AQ_Z(ntryL,G1H48(18),ex4(:),G1H24(18),ngZd,m3h2x24(:,18),heltab2x48(:,:,18))
  call Hloop_AQ_V(ntryL,G1H48(19),ex2(:),G1H24(19),m3h2x24(:,19),heltab2x48(:,:,19))
  call Hloop_AQ_V(ntryL,G1H48(20),ex2(:),G1H24(20),m3h2x24(:,20),heltab2x48(:,:,20))
  call Hloop_AQ_Z(ntryL,G1H48(21),ex2(:),G1H24(21),ngZu,m3h2x24(:,21),heltab2x48(:,:,21))
  call Hloop_AQ_Z(ntryL,G1H48(22),ex2(:),G1H24(22),ngZu,m3h2x24(:,22),heltab2x48(:,:,22))
  call Hloop_QA_V(ntryL,G1H48(23),ex1(:),G1H24(23),m3h2x24(:,23),heltab2x48(:,:,23))
  call Hloop_QA_V(ntryL,G1H48(24),ex1(:),G1H24(24),m3h2x24(:,24),heltab2x48(:,:,24))
  call Hloop_QA_Z(ntryL,G1H48(25),ex1(:),G1H24(25),ngZu,m3h2x24(:,25),heltab2x48(:,:,25))
  call Hloop_QA_Z(ntryL,G1H48(26),ex1(:),G1H24(26),ngZu,m3h2x24(:,26),heltab2x48(:,:,26))
  call Hloop_QA_V(ntryL,G1H48(27),ex1(:),G1H24(27),m3h2x24(:,27),heltab2x48(:,:,27))
  call Hloop_QA_W(ntryL,G1H48(28),ex1(:),G1H24(28),m3h2x24(:,28),heltab2x48(:,:,28))
  call Hloop_QA_Z(ntryL,G1H48(29),ex1(:),G1H24(29),ngZu,m3h2x24(:,29),heltab2x48(:,:,29))
  call Hloop_QA_W(ntryL,G1H48(30),ex1(:),G1H24(30),m3h2x24(:,30),heltab2x48(:,:,30))
  call Hloop_QA_V(ntryL,G1H48(31),ex1(:),G1H24(31),m3h2x24(:,31),heltab2x48(:,:,31))
  call Hloop_QA_V(ntryL,G1H48(32),ex1(:),G1H24(32),m3h2x24(:,32),heltab2x48(:,:,32))
  call Hloop_QA_Z(ntryL,G1H48(33),ex1(:),G1H24(33),ngZu,m3h2x24(:,33),heltab2x48(:,:,33))
  call Hloop_QA_Z(ntryL,G1H48(34),ex1(:),G1H24(34),ngZu,m3h2x24(:,34),heltab2x48(:,:,34))
  call Hloop_QA_W(ntryL,G1H48(35),ex1(:),G1H24(35),m3h2x24(:,35),heltab2x48(:,:,35))
  call Hloop_QA_W(ntryL,G1H48(36),ex1(:),G1H24(36),m3h2x24(:,36),heltab2x48(:,:,36))
  call Hloop_QA_W(ntryL,G1H48(37),ex1(:),G1H24(37),m3h2x24(:,37),heltab2x48(:,:,37))
  call Hloop_QA_W(ntryL,G1H48(38),ex1(:),G1H24(38),m3h2x24(:,38),heltab2x48(:,:,38))
  call Hloop_QA_V(ntryL,G1H48(39),ex3(:),G1H24(39),m3h2x24(:,39),heltab2x48(:,:,39))
  call Hloop_QA_Z(ntryL,G1H48(40),ex3(:),G1H24(40),ngZu,m3h2x24(:,40),heltab2x48(:,:,40))
  call Hloop_AQ_W(ntryL,G1H48(41),ex2(:),G1H24(41),m3h2x24(:,41),heltab2x48(:,:,41))
  call Hloop_AQ_W(ntryL,G1H48(42),ex2(:),G1H24(42),m3h2x24(:,42),heltab2x48(:,:,42))
  call Hloop_AQ_S(ntryL,G1H48(43),ex2(:),G1H24(43),ngH,m3h2x24(:,43),heltab2x48(:,:,43))
  call Hloop_AQ_S(ntryL,G1H48(44),ex2(:),G1H24(44),ngH,m3h2x24(:,44),heltab2x48(:,:,44))
  call Hloop_AQ_V(ntryL,G1H48(45),ex2(:),G1H24(45),m3h2x24(:,45),heltab2x48(:,:,45))
  call Hloop_AQ_Z(ntryL,G1H48(46),ex2(:),G1H24(46),ngZu,m3h2x24(:,46),heltab2x48(:,:,46))
  call Hloop_AQ_V(ntryL,G1H48(47),ex2(:),G1H24(47),m3h2x24(:,47),heltab2x48(:,:,47))
  call Hloop_AQ_Z(ntryL,G1H48(48),ex2(:),G1H24(48),ngZu,m3h2x24(:,48),heltab2x48(:,:,48))
  call Hloop_AQ_V(ntryL,G1H48(49),ex4(:),G1H24(49),m3h2x24(:,49),heltab2x48(:,:,49))
  call Hloop_AQ_Z(ntryL,G1H48(50),ex4(:),G1H24(50),ngZd,m3h2x24(:,50),heltab2x48(:,:,50))
  call Hloop_AQ_V(ntryL,G1H48(51),ex4(:),G1H24(51),m3h2x24(:,51),heltab2x48(:,:,51))
  call Hloop_AQ_Z(ntryL,G1H48(52),ex4(:),G1H24(52),ngZd,m3h2x24(:,52),heltab2x48(:,:,52))
  call Hloop_AQ_V(ntryL,G1H48(53),ex2(:),G1H24(53),m3h2x24(:,53),heltab2x48(:,:,53))
  call Hloop_AQ_Z(ntryL,G1H48(54),ex2(:),G1H24(54),ngZu,m3h2x24(:,54),heltab2x48(:,:,54))
  call Hloop_AQ_V(ntryL,G1H48(55),ex2(:),G1H24(55),m3h2x24(:,55),heltab2x48(:,:,55))
  call Hloop_AQ_Z(ntryL,G1H48(56),ex2(:),G1H24(56),ngZu,m3h2x24(:,56),heltab2x48(:,:,56))
  call Hloop_QA_V(ntryL,G1H48(57),ex1(:),G1H24(57),m3h2x24(:,57),heltab2x48(:,:,57))
  call Hloop_QA_V(ntryL,G1H48(58),ex1(:),G1H24(58),m3h2x24(:,58),heltab2x48(:,:,58))
  call Hloop_QA_Z(ntryL,G1H48(59),ex1(:),G1H24(59),ngZu,m3h2x24(:,59),heltab2x48(:,:,59))
  call Hloop_QA_Z(ntryL,G1H48(60),ex1(:),G1H24(60),ngZu,m3h2x24(:,60),heltab2x48(:,:,60))
  call Hloop_QA_V(ntryL,G1H48(61),ex1(:),G1H24(61),m3h2x24(:,61),heltab2x48(:,:,61))
  call Hloop_QA_Z(ntryL,G1H48(62),ex1(:),G1H24(62),ngZu,m3h2x24(:,62),heltab2x48(:,:,62))
  call Hloop_QA_V(ntryL,G1H48(63),ex1(:),G1H24(63),m3h2x24(:,63),heltab2x48(:,:,63))
  call Hloop_QA_V(ntryL,G1H48(64),ex1(:),G1H24(64),m3h2x24(:,64),heltab2x48(:,:,64))
  call Hloop_QA_Z(ntryL,G1H48(65),ex1(:),G1H24(65),ngZu,m3h2x24(:,65),heltab2x48(:,:,65))
  call Hloop_QA_Z(ntryL,G1H48(66),ex1(:),G1H24(66),ngZu,m3h2x24(:,66),heltab2x48(:,:,66))
  call Hloop_QA_V(ntryL,G1H48(67),ex1(:),G1H24(67),m3h2x24(:,67),heltab2x48(:,:,67))
  call Hloop_QA_Z(ntryL,G1H48(68),ex1(:),G1H24(68),ngZu,m3h2x24(:,68),heltab2x48(:,:,68))
  call Hloop_AQ_V(ntryL,G1H48(69),ex2(:),G1H24(69),m3h2x24(:,69),heltab2x48(:,:,69))
  call Hloop_AQ_W(ntryL,G1H48(70),ex2(:),G1H24(70),m3h2x24(:,70),heltab2x48(:,:,70))
  call Hloop_AQ_Z(ntryL,G1H48(71),ex2(:),G1H24(71),ngZu,m3h2x24(:,71),heltab2x48(:,:,71))
  call Hloop_AQ_W(ntryL,G1H48(72),ex2(:),G1H24(72),m3h2x24(:,72),heltab2x48(:,:,72))
  call Hloop_AQ_V(ntryL,G1H48(73),ex2(:),G1H24(73),m3h2x24(:,73),heltab2x48(:,:,73))
  call Hloop_AQ_V(ntryL,G1H48(74),ex2(:),G1H24(74),m3h2x24(:,74),heltab2x48(:,:,74))
  call Hloop_AQ_Z(ntryL,G1H48(75),ex2(:),G1H24(75),ngZu,m3h2x24(:,75),heltab2x48(:,:,75))
  call Hloop_AQ_Z(ntryL,G1H48(76),ex2(:),G1H24(76),ngZu,m3h2x24(:,76),heltab2x48(:,:,76))
  call Hloop_AQ_W(ntryL,G1H48(77),ex2(:),G1H24(77),m3h2x24(:,77),heltab2x48(:,:,77))
  call Hloop_AQ_W(ntryL,G1H48(78),ex2(:),G1H24(78),m3h2x24(:,78),heltab2x48(:,:,78))
  call Hloop_AQ_S(ntryL,G1H48(79),ex2(:),G1H24(79),ngH,m3h2x24(:,79),heltab2x48(:,:,79))
  call Hloop_AQ_S(ntryL,G1H48(80),ex2(:),G1H24(80),ngH,m3h2x24(:,80),heltab2x48(:,:,80))
  call Hloop_AQ_V(ntryL,G1H48(81),ex2(:),G1H24(81),m3h2x24(:,81),heltab2x48(:,:,81))
  call Hloop_AQ_V(ntryL,G1H48(82),ex2(:),G1H24(82),m3h2x24(:,82),heltab2x48(:,:,82))
  call Hloop_AQ_Z(ntryL,G1H48(83),ex2(:),G1H24(83),ngZu,m3h2x24(:,83),heltab2x48(:,:,83))
  call Hloop_AQ_Z(ntryL,G1H48(84),ex2(:),G1H24(84),ngZu,m3h2x24(:,84),heltab2x48(:,:,84))
  call Hloop_QA_W(ntryL,G1H48(85),ex1(:),G1H24(85),m3h2x24(:,85),heltab2x48(:,:,85))
  call Hloop_QA_V(ntryL,G1H48(86),ex1(:),G1H24(86),m3h2x24(:,86),heltab2x48(:,:,86))
  call Hloop_QA_W(ntryL,G1H48(87),ex1(:),G1H24(87),m3h2x24(:,87),heltab2x48(:,:,87))
  call Hloop_QA_Z(ntryL,G1H48(88),ex1(:),G1H24(88),ngZu,m3h2x24(:,88),heltab2x48(:,:,88))
  call Hloop_QA_W(ntryL,G1H48(89),ex1(:),G1H24(89),m3h2x24(:,89),heltab2x48(:,:,89))
  call Hloop_QA_W(ntryL,G1H48(90),ex1(:),G1H24(90),m3h2x24(:,90),heltab2x48(:,:,90))
  call Hloop_QA_W(ntryL,G1H48(91),ex1(:),G1H24(91),m3h2x24(:,91),heltab2x48(:,:,91))
  call Hloop_QA_W(ntryL,G1H48(92),ex1(:),G1H24(92),m3h2x24(:,92),heltab2x48(:,:,92))
  call Hloop_QA_V(ntryL,G1H48(93),ex1(:),G1H24(93),m3h2x24(:,93),heltab2x48(:,:,93))
  call Hloop_QA_Z(ntryL,G1H48(94),ex1(:),G1H24(94),ngZu,m3h2x24(:,94),heltab2x48(:,:,94))
  call Hloop_QA_W(ntryL,G1H48(95),ex1(:),G1H24(95),m3h2x24(:,95),heltab2x48(:,:,95))
  call Hloop_QA_W(ntryL,G1H48(96),ex1(:),G1H24(96),m3h2x24(:,96),heltab2x48(:,:,96))
  call Hloop_QA_W(ntryL,G1H48(97),ex1(:),G1H24(97),m3h2x24(:,97),heltab2x48(:,:,97))
  call Hloop_QA_W(ntryL,G1H48(98),ex1(:),G1H24(98),m3h2x24(:,98),heltab2x48(:,:,98))
  call Hloop_QA_W(ntryL,G1H48(99),ex1(:),G1H24(99),m3h2x24(:,99),heltab2x48(:,:,99))
  call Hloop_QA_W(ntryL,G1H48(100),ex1(:),G1H24(100),m3h2x24(:,100),heltab2x48(:,:,100))
  call Hloop_VQ_A(ntryL,G1H24(1),ex4(:),G1H12(1),m3h2x12(:,1),heltab2x24(:,:,1))
  call Hloop_Q_A(ntryL,G1H12(1),44,0,G2H12(1),n2h12(1))
  call Hloop_ZQ_A(ntryL,G1H24(2),ex4(:),G1H12(1),ngZd,m3h2x12(:,2),heltab2x24(:,:,2))
  call Hloop_Q_A(ntryL,G1H12(1),44,0,G2H12(2),n2h12(2))
  call Hloop_WA_Q(ntryL,G1H24(3),ex1(:),G1H12(1),m3h2x12(:,3),heltab2x24(:,:,3))
  call Hloop_A_Q(ntryL,G1H12(1),35,0,G2H12(3),n2h12(3))
  call Hloop_WA_Q(ntryL,G1H24(4),ex1(:),G1H12(1),m3h2x12(:,4),heltab2x24(:,:,4))
  call Hloop_A_Q(ntryL,G1H12(1),35,0,G2H12(4),n2h12(4))
  call Hloop_VA_Q(ntryL,G1H24(5),ex1(:),G1H12(1),m3h2x12(:,5),heltab2x24(:,:,5))
  call Hloop_A_Q(ntryL,G1H12(1),35,0,G2H12(5),n2h12(5))
  call Hloop_WA_Q(ntryL,G1H24(6),ex1(:),G1H12(1),m3h2x12(:,6),heltab2x24(:,:,6))
  call Hloop_A_Q(ntryL,G1H12(1),35,0,G2H12(6),n2h12(6))
  call Hloop_ZA_Q(ntryL,G1H24(7),ex1(:),G1H12(1),ngZu,m3h2x12(:,7),heltab2x24(:,:,7))
  call Hloop_A_Q(ntryL,G1H12(1),35,0,G2H12(7),n2h12(7))
  call Hloop_WA_Q(ntryL,G1H24(8),ex1(:),G1H12(1),m3h2x12(:,8),heltab2x24(:,:,8))
  call Hloop_A_Q(ntryL,G1H12(1),35,0,G2H12(8),n2h12(8))
  call Hloop_VA_Q(ntryL,G1H24(9),ex1(:),G1H12(1),m3h2x12(:,9),heltab2x24(:,:,9))
  call Hloop_A_Q(ntryL,G1H12(1),35,0,G2H12(9),n2h12(9))
  call Hloop_VA_Q(ntryL,G1H24(10),ex1(:),G1H12(1),m3h2x12(:,10),heltab2x24(:,:,10))
  call Hloop_A_Q(ntryL,G1H12(1),35,0,G2H12(10),n2h12(10))
  call Hloop_ZA_Q(ntryL,G1H24(11),ex1(:),G1H12(1),ngZu,m3h2x12(:,11),heltab2x24(:,:,11))
  call Hloop_A_Q(ntryL,G1H12(1),35,0,G2H12(11),n2h12(11))
  call Hloop_ZA_Q(ntryL,G1H24(12),ex1(:),G1H12(1),ngZu,m3h2x12(:,12),heltab2x24(:,:,12))
  call Hloop_A_Q(ntryL,G1H12(1),35,0,G2H12(12),n2h12(12))
  call Hloop_WA_Q(ntryL,G1H24(13),ex1(:),G1H12(1),m3h2x12(:,13),heltab2x24(:,:,13))
  call Hloop_A_Q(ntryL,G1H12(1),35,0,G2H12(13),n2h12(13))
  call Hloop_WA_Q(ntryL,G1H24(14),ex1(:),G1H12(1),m3h2x12(:,14),heltab2x24(:,:,14))
  call Hloop_A_Q(ntryL,G1H12(1),35,0,G2H12(14),n2h12(14))
  call Hloop_VA_Q(ntryL,G1H24(15),ex3(:),G1H12(1),m3h2x12(:,15),heltab2x24(:,:,15))
  call Hloop_A_Q(ntryL,G1H12(1),44,nMT,G2H12(15),n2h12(15))
  call Hloop_ZA_Q(ntryL,G1H24(16),ex3(:),G1H12(1),ngZu,m3h2x12(:,16),heltab2x24(:,:,16))
  call Hloop_A_Q(ntryL,G1H12(1),44,nMT,G2H12(16),n2h12(16))
  call Hloop_VA_Q(ntryL,G1H24(17),ex3(:),G1H12(1),m3h2x12(:,17),heltab2x24(:,:,17))
  call Hloop_A_Q(ntryL,G1H12(1),44,nMT,G2H12(17),n2h12(17))
  call Hloop_ZA_Q(ntryL,G1H24(18),ex3(:),G1H12(1),ngZu,m3h2x12(:,18),heltab2x24(:,:,18))
  call Hloop_A_Q(ntryL,G1H12(1),44,nMT,G2H12(18),n2h12(18))
  call Hloop_VA_Q(ntryL,G1H24(19),ex1(:),G1H12(1),m3h2x12(:,19),heltab2x24(:,:,19))
  call Hloop_A_Q(ntryL,G1H12(1),35,0,G2H12(19),n2h12(19))
  call Hloop_VA_Q(ntryL,G1H24(20),ex1(:),G1H12(1),m3h2x12(:,20),heltab2x24(:,:,20))
  call Hloop_A_Q(ntryL,G1H12(1),35,0,G2H12(20),n2h12(20))
  call Hloop_ZA_Q(ntryL,G1H24(21),ex1(:),G1H12(1),ngZu,m3h2x12(:,21),heltab2x24(:,:,21))
  call Hloop_A_Q(ntryL,G1H12(1),35,0,G2H12(21),n2h12(21))
  call Hloop_ZA_Q(ntryL,G1H24(22),ex1(:),G1H12(1),ngZu,m3h2x12(:,22),heltab2x24(:,:,22))
  call Hloop_A_Q(ntryL,G1H12(1),35,0,G2H12(22),n2h12(22))
  call Hloop_VQ_A(ntryL,G1H24(23),ex2(:),G1H12(1),m3h2x12(:,23),heltab2x24(:,:,23))
  call Hloop_Q_A(ntryL,G1H12(1),35,nMT,G2H12(23),n2h12(23))
  call Hloop_VQ_A(ntryL,G1H24(24),ex2(:),G1H12(1),m3h2x12(:,24),heltab2x24(:,:,24))
  call Hloop_Q_A(ntryL,G1H12(1),35,nMT,G2H12(24),n2h12(24))
  call Hloop_ZQ_A(ntryL,G1H24(25),ex2(:),G1H12(1),ngZu,m3h2x12(:,25),heltab2x24(:,:,25))
  call Hloop_Q_A(ntryL,G1H12(1),35,nMT,G2H12(25),n2h12(25))
  call Hloop_ZQ_A(ntryL,G1H24(26),ex2(:),G1H12(1),ngZu,m3h2x12(:,26),heltab2x24(:,:,26))
  call Hloop_Q_A(ntryL,G1H12(1),35,nMT,G2H12(26),n2h12(26))
  call Hloop_VQ_A(ntryL,G1H24(27),ex2(:),G1H12(1),m3h2x12(:,27),heltab2x24(:,:,27))
  call Hloop_Q_A(ntryL,G1H12(1),35,nMT,G2H12(27),n2h12(27))
  call Hloop_WQ_A(ntryL,G1H24(28),ex2(:),G1H12(1),m3h2x12(:,28),heltab2x24(:,:,28))
  call Hloop_Q_A(ntryL,G1H12(1),35,nMB,G2H12(28),n2h12(28))
  call Hloop_ZQ_A(ntryL,G1H24(29),ex2(:),G1H12(1),ngZu,m3h2x12(:,29),heltab2x24(:,:,29))
  call Hloop_Q_A(ntryL,G1H12(1),35,nMT,G2H12(29),n2h12(29))
  call Hloop_WQ_A(ntryL,G1H24(30),ex2(:),G1H12(1),m3h2x12(:,30),heltab2x24(:,:,30))
  call Hloop_Q_A(ntryL,G1H12(1),35,nMB,G2H12(30),n2h12(30))
  call Hloop_VQ_A(ntryL,G1H24(31),ex2(:),G1H12(1),m3h2x12(:,31),heltab2x24(:,:,31))
  call Hloop_Q_A(ntryL,G1H12(1),35,nMT,G2H12(31),n2h12(31))
  call Hloop_VQ_A(ntryL,G1H24(32),ex2(:),G1H12(1),m3h2x12(:,32),heltab2x24(:,:,32))
  call Hloop_Q_A(ntryL,G1H12(1),35,nMT,G2H12(32),n2h12(32))
  call Hloop_ZQ_A(ntryL,G1H24(33),ex2(:),G1H12(1),ngZu,m3h2x12(:,33),heltab2x24(:,:,33))
  call Hloop_Q_A(ntryL,G1H12(1),35,nMT,G2H12(33),n2h12(33))
  call Hloop_ZQ_A(ntryL,G1H24(34),ex2(:),G1H12(1),ngZu,m3h2x12(:,34),heltab2x24(:,:,34))
  call Hloop_Q_A(ntryL,G1H12(1),35,nMT,G2H12(34),n2h12(34))
  call Hloop_WQ_A(ntryL,G1H24(35),ex2(:),G1H12(1),m3h2x12(:,35),heltab2x24(:,:,35))
  call Hloop_Q_A(ntryL,G1H12(1),35,nMB,G2H12(35),n2h12(35))
  call Hloop_WQ_A(ntryL,G1H24(36),ex2(:),G1H12(1),m3h2x12(:,36),heltab2x24(:,:,36))
  call Hloop_Q_A(ntryL,G1H12(1),35,nMB,G2H12(36),n2h12(36))
  call Hloop_WQ_A(ntryL,G1H24(37),ex2(:),G1H12(1),m3h2x12(:,37),heltab2x24(:,:,37))
  call Hloop_Q_A(ntryL,G1H12(1),35,nMB,G2H12(37),n2h12(37))
  call Hloop_WQ_A(ntryL,G1H24(38),ex2(:),G1H12(1),m3h2x12(:,38),heltab2x24(:,:,38))
  call Hloop_Q_A(ntryL,G1H12(1),35,nMB,G2H12(38),n2h12(38))
  call Hloop_VA_Q(ntryL,G1H24(39),ex1(:),G1H12(1),m3h2x12(:,39),heltab2x24(:,:,39))
  call Hloop_A_Q(ntryL,G1H12(1),37,0,G2H12(39),n2h12(39))
  call Hloop_ZA_Q(ntryL,G1H24(40),ex1(:),G1H12(1),ngZu,m3h2x12(:,40),heltab2x24(:,:,40))
  call Hloop_A_Q(ntryL,G1H12(1),37,0,G2H12(40),n2h12(40))
  call Hloop_WQ_A(ntryL,G1H24(41),ex4(:),G1H12(1),m3h2x12(:,41),heltab2x24(:,:,41))
  call Hloop_Q_A(ntryL,G1H12(1),42,0,G2H12(41),n2h12(41))
  call Hloop_WQ_A(ntryL,G1H24(42),ex4(:),G1H12(1),m3h2x12(:,42),heltab2x24(:,:,42))
  call Hloop_Q_A(ntryL,G1H12(1),42,0,G2H12(42),n2h12(42))
  call Hloop_SV_V(ntryL,G1H24(43),ex5(:),G1H8(1),m3h3x8(:,1),heltab2x24(:,:,43))
  call Hloop_SV_V(ntryL,G1H24(44),ex5(:),G1H8(2),m3h3x8(:,2),heltab2x24(:,:,44))
  call Hloop_UV_W(ntryL,G1H24(45),34,ex5(:),16,G2H8(1),m3h3x8(:,3),heltab2x24(:,:,45))
  call Hloop_UV_W(ntryL,G1H24(46),34,ex5(:),16,G2H8(2),m3h3x8(:,4),heltab2x24(:,:,46))
  call Hloop_UV_W(ntryL,G1H24(47),34,ex5(:),16,G2H8(3),m3h3x8(:,5),heltab2x24(:,:,47))
  call Hloop_UV_W(ntryL,G1H24(48),34,ex5(:),16,G2H8(4),m3h3x8(:,6),heltab2x24(:,:,48))
  call Hloop_VQ_A(ntryL,G1H24(49),ex2(:),G1H12(1),m3h2x12(:,43),heltab2x24(:,:,49))
  call Hloop_Q_A(ntryL,G1H12(1),42,nMT,G2H12(43),n2h12(43))
  call Hloop_ZQ_A(ntryL,G1H24(50),ex2(:),G1H12(1),ngZu,m3h2x12(:,44),heltab2x24(:,:,50))
  call Hloop_Q_A(ntryL,G1H12(1),42,nMT,G2H12(44),n2h12(44))
  call Hloop_VQ_A(ntryL,G1H24(51),ex2(:),G1H12(1),m3h2x12(:,45),heltab2x24(:,:,51))
  call Hloop_Q_A(ntryL,G1H12(1),42,nMT,G2H12(45),n2h12(45))
  call Hloop_ZQ_A(ntryL,G1H24(52),ex2(:),G1H12(1),ngZu,m3h2x12(:,46),heltab2x24(:,:,52))
  call Hloop_Q_A(ntryL,G1H12(1),42,nMT,G2H12(46),n2h12(46))
  call Hloop_VQ_A(ntryL,G1H24(53),ex4(:),G1H12(1),m3h2x12(:,47),heltab2x24(:,:,53))
  call Hloop_Q_A(ntryL,G1H12(1),42,0,G2H12(47),n2h12(47))
  call Hloop_ZQ_A(ntryL,G1H24(54),ex4(:),G1H12(1),ngZd,m3h2x12(:,48),heltab2x24(:,:,54))
  call Hloop_Q_A(ntryL,G1H12(1),42,0,G2H12(48),n2h12(48))
  call Hloop_VQ_A(ntryL,G1H24(55),ex4(:),G1H12(1),m3h2x12(:,49),heltab2x24(:,:,55))
  call Hloop_Q_A(ntryL,G1H12(1),42,0,G2H12(49),n2h12(49))
  call Hloop_ZQ_A(ntryL,G1H24(56),ex4(:),G1H12(1),ngZd,m3h2x12(:,50),heltab2x24(:,:,56))
  call Hloop_Q_A(ntryL,G1H12(1),42,0,G2H12(50),n2h12(50))
  call Hloop_VA_Q(ntryL,G1H24(57),ex3(:),G1H12(1),m3h2x12(:,51),heltab2x24(:,:,57))
  call Hloop_A_Q(ntryL,G1H12(1),37,nMT,G2H12(51),n2h12(51))
  call Hloop_VA_Q(ntryL,G1H24(58),ex3(:),G1H12(1),m3h2x12(:,52),heltab2x24(:,:,58))
  call Hloop_A_Q(ntryL,G1H12(1),37,nMT,G2H12(52),n2h12(52))
  call Hloop_ZA_Q(ntryL,G1H24(59),ex3(:),G1H12(1),ngZu,m3h2x12(:,53),heltab2x24(:,:,59))
  call Hloop_A_Q(ntryL,G1H12(1),37,nMT,G2H12(53),n2h12(53))
  call Hloop_ZA_Q(ntryL,G1H24(60),ex3(:),G1H12(1),ngZu,m3h2x12(:,54),heltab2x24(:,:,60))
  call Hloop_A_Q(ntryL,G1H12(1),37,nMT,G2H12(54),n2h12(54))
  call Hloop_VA_Q(ntryL,G1H24(61),ex3(:),G1H12(1),m3h2x12(:,55),heltab2x24(:,:,61))
  call Hloop_A_Q(ntryL,G1H12(1),37,nMT,G2H12(55),n2h12(55))
  call Hloop_ZA_Q(ntryL,G1H24(62),ex3(:),G1H12(1),ngZu,m3h2x12(:,56),heltab2x24(:,:,62))
  call Hloop_A_Q(ntryL,G1H12(1),37,nMT,G2H12(56),n2h12(56))
  call Hloop_VA_Q(ntryL,G1H24(63),ex3(:),G1H12(1),m3h2x12(:,57),heltab2x24(:,:,63))
  call Hloop_A_Q(ntryL,G1H12(1),37,nMT,G2H12(57),n2h12(57))
  call Hloop_VA_Q(ntryL,G1H24(64),ex3(:),G1H12(1),m3h2x12(:,58),heltab2x24(:,:,64))
  call Hloop_A_Q(ntryL,G1H12(1),37,nMT,G2H12(58),n2h12(58))
  call Hloop_ZA_Q(ntryL,G1H24(65),ex3(:),G1H12(1),ngZu,m3h2x12(:,59),heltab2x24(:,:,65))
  call Hloop_A_Q(ntryL,G1H12(1),37,nMT,G2H12(59),n2h12(59))
  call Hloop_ZA_Q(ntryL,G1H24(66),ex3(:),G1H12(1),ngZu,m3h2x12(:,60),heltab2x24(:,:,66))
  call Hloop_A_Q(ntryL,G1H12(1),37,nMT,G2H12(60),n2h12(60))
  call Hloop_VA_Q(ntryL,G1H24(67),ex3(:),G1H12(1),m3h2x12(:,61),heltab2x24(:,:,67))
  call Hloop_A_Q(ntryL,G1H12(1),37,nMT,G2H12(61),n2h12(61))
  call Hloop_ZA_Q(ntryL,G1H24(68),ex3(:),G1H12(1),ngZu,m3h2x12(:,62),heltab2x24(:,:,68))
  call Hloop_A_Q(ntryL,G1H12(1),37,nMT,G2H12(62),n2h12(62))
  call Hloop_VQ_A(ntryL,G1H24(69),ex4(:),G1H12(1),m3h2x12(:,63),heltab2x24(:,:,69))
  call Hloop_Q_A(ntryL,G1H12(1),42,0,G2H12(63),n2h12(63))
  call Hloop_WQ_A(ntryL,G1H24(70),ex4(:),G1H12(1),m3h2x12(:,64),heltab2x24(:,:,70))
  call Hloop_Q_A(ntryL,G1H12(1),42,0,G2H12(64),n2h12(64))
  call Hloop_ZQ_A(ntryL,G1H24(71),ex4(:),G1H12(1),ngZd,m3h2x12(:,65),heltab2x24(:,:,71))
  call Hloop_Q_A(ntryL,G1H12(1),42,0,G2H12(65),n2h12(65))
  call Hloop_WQ_A(ntryL,G1H24(72),ex4(:),G1H12(1),m3h2x12(:,66),heltab2x24(:,:,72))
  call Hloop_Q_A(ntryL,G1H12(1),42,0,G2H12(66),n2h12(66))
  call Hloop_VQ_A(ntryL,G1H24(73),ex4(:),G1H12(1),m3h2x12(:,67),heltab2x24(:,:,73))
  call Hloop_Q_A(ntryL,G1H12(1),42,0,G2H12(67),n2h12(67))
  call Hloop_VQ_A(ntryL,G1H24(74),ex4(:),G1H12(1),m3h2x12(:,68),heltab2x24(:,:,74))
  call Hloop_Q_A(ntryL,G1H12(1),42,0,G2H12(68),n2h12(68))
  call Hloop_ZQ_A(ntryL,G1H24(75),ex4(:),G1H12(1),ngZd,m3h2x12(:,69),heltab2x24(:,:,75))
  call Hloop_Q_A(ntryL,G1H12(1),42,0,G2H12(69),n2h12(69))
  call Hloop_ZQ_A(ntryL,G1H24(76),ex4(:),G1H12(1),ngZd,m3h2x12(:,70),heltab2x24(:,:,76))
  call Hloop_Q_A(ntryL,G1H12(1),42,0,G2H12(70),n2h12(70))
  call Hloop_WQ_A(ntryL,G1H24(77),ex4(:),G1H12(1),m3h2x12(:,71),heltab2x24(:,:,77))
  call Hloop_Q_A(ntryL,G1H12(1),42,0,G2H12(71),n2h12(71))
  call Hloop_WQ_A(ntryL,G1H24(78),ex4(:),G1H12(1),m3h2x12(:,72),heltab2x24(:,:,78))
  call Hloop_Q_A(ntryL,G1H12(1),42,0,G2H12(72),n2h12(72))
  call Hloop_SV_V(ntryL,G1H24(79),ex5(:),G1H8(3),m3h3x8(:,7),heltab2x24(:,:,79))
  call Hloop_SV_V(ntryL,G1H24(80),ex5(:),G1H8(4),m3h3x8(:,8),heltab2x24(:,:,80))
  call Hloop_UV_W(ntryL,G1H24(81),34,ex5(:),16,G2H8(5),m3h3x8(:,9),heltab2x24(:,:,81))
  call Hloop_UV_W(ntryL,G1H24(82),34,ex5(:),16,G2H8(6),m3h3x8(:,10),heltab2x24(:,:,82))
  call Hloop_UV_W(ntryL,G1H24(83),34,ex5(:),16,G2H8(7),m3h3x8(:,11),heltab2x24(:,:,83))
  call Hloop_UV_W(ntryL,G1H24(84),34,ex5(:),16,G2H8(8),m3h3x8(:,12),heltab2x24(:,:,84))
  call Hloop_VV_S(ntryL,G1H24(85),ex5(:),G1H8(5),m3h3x8(:,13),heltab2x24(:,:,85))
  call Hloop_VV_S(ntryL,G1H24(86),ex5(:),G1H8(6),m3h3x8(:,14),heltab2x24(:,:,86))
  call Hloop_VV_S(ntryL,G1H24(87),ex5(:),G1H8(7),m3h3x8(:,15),heltab2x24(:,:,87))
  call Hloop_VV_S(ntryL,G1H24(88),ex5(:),G1H8(8),m3h3x8(:,16),heltab2x24(:,:,88))
  call Hloop_UW_V(ntryL,G1H24(89),33,ex5(:),16,G2H8(9),m3h3x8(:,17),heltab2x24(:,:,89))
  call Hloop_UW_V(ntryL,G1H24(90),33,ex5(:),16,G2H8(10),m3h3x8(:,18),heltab2x24(:,:,90))
  call Hloop_UW_V(ntryL,G1H24(91),33,ex5(:),16,G2H8(11),m3h3x8(:,19),heltab2x24(:,:,91))
  call Hloop_UW_V(ntryL,G1H24(92),33,ex5(:),16,G2H8(12),m3h3x8(:,20),heltab2x24(:,:,92))
  call Hloop_UV_W(ntryL,G1H24(93),33,ex5(:),16,G2H8(13),m3h3x8(:,21),heltab2x24(:,:,93))
  call Hloop_UV_W(ntryL,G1H24(94),33,ex5(:),16,G2H8(14),m3h3x8(:,22),heltab2x24(:,:,94))
  call Hloop_VV_S(ntryL,G1H24(95),ex5(:),G1H8(9),m3h3x8(:,23),heltab2x24(:,:,95))
  call Hloop_VV_S(ntryL,G1H24(96),ex5(:),G1H8(10),m3h3x8(:,24),heltab2x24(:,:,96))
  call Hloop_UW_V(ntryL,G1H24(97),33,ex5(:),16,G2H8(15),m3h3x8(:,25),heltab2x24(:,:,97))
  call Hloop_UW_V(ntryL,G1H24(98),33,ex5(:),16,G2H8(16),m3h3x8(:,26),heltab2x24(:,:,98))
  call Hloop_UW_V(ntryL,G1H24(99),33,ex5(:),16,G2H8(17),m3h3x8(:,27),heltab2x24(:,:,99))
  call Hloop_UW_V(ntryL,G1H24(100),33,ex5(:),16,G2H8(18),m3h3x8(:,28),heltab2x24(:,:,100))
  call Hloop_QA_W(ntryL,G2H12(1),ex1(:),G2H6(1),m3h2x6(:,1),heltab2x12(:,:,1))
  call Hloop_QA_W(ntryL,G2H12(2),ex1(:),G2H6(2),m3h2x6(:,2),heltab2x12(:,:,2))
  call Hloop_AQ_V(ntryL,G2H12(3),ex4(:),G2H6(3),m3h2x6(:,3),heltab2x12(:,:,3))
  call Hloop_AQ_Z(ntryL,G2H12(4),ex4(:),G2H6(4),ngZd,m3h2x6(:,4),heltab2x12(:,:,4))
  call Hloop_AQ_W(ntryL,G2H12(5),ex4(:),G2H6(5),m3h2x6(:,5),heltab2x12(:,:,5))
  call Hloop_AQ_V(ntryL,G2H12(6),ex4(:),G2H6(6),m3h2x6(:,6),heltab2x12(:,:,6))
  call Hloop_AQ_W(ntryL,G2H12(7),ex4(:),G2H6(7),m3h2x6(:,7),heltab2x12(:,:,7))
  call Hloop_AQ_Z(ntryL,G2H12(8),ex4(:),G2H6(8),ngZd,m3h2x6(:,8),heltab2x12(:,:,8))
  call Hloop_AQ_W(ntryL,G2H12(9),ex4(:),G2H6(9),m3h2x6(:,9),heltab2x12(:,:,9))
  call Hloop_AQ_W(ntryL,G2H12(10),ex4(:),G2H6(10),m3h2x6(:,10),heltab2x12(:,:,10))
  call Hloop_AQ_W(ntryL,G2H12(11),ex4(:),G2H6(11),m3h2x6(:,11),heltab2x12(:,:,11))
  call Hloop_AQ_W(ntryL,G2H12(12),ex4(:),G2H6(12),m3h2x6(:,12),heltab2x12(:,:,12))
  call Hloop_AQ_V(ntryL,G2H12(13),ex4(:),G2H6(13),m3h2x6(:,13),heltab2x12(:,:,13))
  call Hloop_AQ_Z(ntryL,G2H12(14),ex4(:),G2H6(14),ngZd,m3h2x6(:,14),heltab2x12(:,:,14))
  call Hloop_AQ_V(ntryL,G2H12(15),ex2(:),G2H6(15),m3h2x6(:,15),heltab2x12(:,:,15))
  call Hloop_AQ_V(ntryL,G2H12(16),ex2(:),G2H6(16),m3h2x6(:,16),heltab2x12(:,:,16))
  call Hloop_AQ_Z(ntryL,G2H12(17),ex2(:),G2H6(17),ngZu,m3h2x6(:,17),heltab2x12(:,:,17))
  call Hloop_AQ_Z(ntryL,G2H12(18),ex2(:),G2H6(18),ngZu,m3h2x6(:,18),heltab2x12(:,:,18))
  call Hotf_5pt_reduction(G2H12(19),RedSet_5(1),mass5set(:,1),  & 
G1H12(1),G1H12(2),G1H12(3),G1H12(4),G1H12(5),G1H12(6),12)
  call HG1shiftOLR(G1H12(2),4,12)
  call Hotf_5pt_reduction(G2H12(20),RedSet_5(1),mass5set(:,1),  & 
G1H12(7),G1H12(8),G1H12(9),G1H12(10),G1H12(11),G1H12(12),12)
  call HG1shiftOLR(G1H12(8),4,12)
  call Hotf_5pt_reduction(G2H12(21),RedSet_5(1),mass5set(:,2),  & 
G1H12(13),G1H12(14),G1H12(15),G1H12(16),G1H12(17),G1H12(18),12)
  call HG1shiftOLR(G1H12(14),4,12)
  call Hotf_5pt_reduction(G2H12(22),RedSet_5(1),mass5set(:,2),  & 
G1H12(19),G1H12(20),G1H12(21),G1H12(22),G1H12(23),G1H12(24),12)
  call HG1shiftOLR(G1H12(20),4,12)
  call Hloop_QA_V(ntryL,G2H12(23),ex3(:),G2H6(19),m3h2x6(:,19),heltab2x12(:,:,19))
  call Hloop_QA_Z(ntryL,G2H12(24),ex3(:),G2H6(20),ngZu,m3h2x6(:,20),heltab2x12(:,:,20))
  call Hloop_QA_V(ntryL,G2H12(25),ex3(:),G2H6(21),m3h2x6(:,21),heltab2x12(:,:,21))
  call Hloop_QA_Z(ntryL,G2H12(26),ex3(:),G2H6(22),ngZu,m3h2x6(:,22),heltab2x12(:,:,22))
  call Hloop_QA_S(ntryL,G2H12(27),ex3(:),G2H6(23),ngH,m3h2x6(:,23),heltab2x12(:,:,23))
  call Hloop_QA_S(ntryL,G2H12(28),ex3(:),G2H6(24),ngPtb,m3h2x6(:,24),heltab2x12(:,:,24))
  call Hloop_QA_S(ntryL,G2H12(29),ex3(:),G2H6(25),ngH,m3h2x6(:,25),heltab2x12(:,:,25))
  call Hloop_QA_S(ntryL,G2H12(30),ex3(:),G2H6(26),ngPtb,m3h2x6(:,26),heltab2x12(:,:,26))
  call Hloop_QA_V(ntryL,G2H12(31),ex3(:),G2H6(27),m3h2x6(:,27),heltab2x12(:,:,27))
  call Hloop_QA_Z(ntryL,G2H12(32),ex3(:),G2H6(28),ngZu,m3h2x6(:,28),heltab2x12(:,:,28))
  call Hloop_QA_V(ntryL,G2H12(33),ex3(:),G2H6(29),m3h2x6(:,29),heltab2x12(:,:,29))
  call Hloop_QA_Z(ntryL,G2H12(34),ex3(:),G2H6(30),ngZu,m3h2x6(:,30),heltab2x12(:,:,30))
  call Hloop_QA_W(ntryL,G2H12(35),ex3(:),G2H6(31),m3h2x6(:,31),heltab2x12(:,:,31))
  call Hloop_QA_W(ntryL,G2H12(36),ex3(:),G2H6(32),m3h2x6(:,32),heltab2x12(:,:,32))
  call Hotf_5pt_reduction(G2H12(37),RedSet_5(2),mass5set(:,3),  & 
G1H12(25),G1H12(26),G1H12(27),G1H12(28),G1H12(29),G1H12(30),12)
  call HG1shiftOLR(G1H12(26),8,12)
  call Hotf_5pt_reduction(G2H12(38),RedSet_5(2),mass5set(:,3),  & 
G1H12(31),G1H12(32),G1H12(33),G1H12(34),G1H12(35),G1H12(36),12)
  call HG1shiftOLR(G1H12(32),8,12)
  call Hloop_AQ_W(ntryL,G2H12(39),ex4(:),G2H6(33),m3h2x6(:,33),heltab2x12(:,:,33))
  call Hloop_AQ_W(ntryL,G2H12(40),ex4(:),G2H6(34),m3h2x6(:,34),heltab2x12(:,:,34))
  call Hloop_QA_V(ntryL,G2H12(41),ex1(:),G2H6(35),m3h2x6(:,35),heltab2x12(:,:,35))
  call Hloop_QA_Z(ntryL,G2H12(42),ex1(:),G2H6(36),ngZu,m3h2x6(:,36),heltab2x12(:,:,36))
  call Hloop_WQ_A(ntryL,G1H8(1),ex4(:),G1H4(1),m3h2x4(:,1),heltab2x8(:,:,1))
  call Hloop_Q_A(ntryL,G1H4(1),58,0,G2H4(1),n2h4(1))
  call Hloop_WQ_A(ntryL,G1H8(2),ex4(:),G1H4(1),m3h2x4(:,2),heltab2x8(:,:,2))
  call Hloop_Q_A(ntryL,G1H4(1),58,0,G2H4(2),n2h4(2))
  call Hotf_5pt_reduction(G2H8(1),RedSet_5(3),mass5set(:,4),  & 
G1H8(1),G1H8(2),G1H8(11),G1H8(12),G1H8(13),G1H8(14),8)
  call HG1shiftOLR(G1H8(2),4,8)
  call Hotf_5pt_reduction(G2H8(2),RedSet_5(3),mass5set(:,5),  & 
G1H8(15),G1H8(16),G1H8(17),G1H8(18),G1H8(19),G1H8(20),8)
  call HG1shiftOLR(G1H8(16),4,8)
  call Hotf_5pt_reduction(G2H8(3),RedSet_5(3),mass5set(:,4),  & 
G1H8(21),G1H8(22),G1H8(23),G1H8(24),G1H8(25),G1H8(26),8)
  call HG1shiftOLR(G1H8(22),4,8)
  call Hotf_5pt_reduction(G2H8(4),RedSet_5(3),mass5set(:,5),  & 
G1H8(27),G1H8(28),G1H8(29),G1H8(30),G1H8(31),G1H8(32),8)
  call HG1shiftOLR(G1H8(28),4,8)
  call Hloop_QA_V(ntryL,G2H12(43),ex3(:),G2H6(37),m3h2x6(:,37),heltab2x12(:,:,37))
  call Hloop_QA_V(ntryL,G2H12(44),ex3(:),G2H6(38),m3h2x6(:,38),heltab2x12(:,:,38))
  call Hloop_QA_Z(ntryL,G2H12(45),ex3(:),G2H6(39),ngZu,m3h2x6(:,39),heltab2x12(:,:,39))
  call Hloop_QA_Z(ntryL,G2H12(46),ex3(:),G2H6(40),ngZu,m3h2x6(:,40),heltab2x12(:,:,40))
  call Hotf_5pt_reduction(G2H12(47),RedSet_5(4),mass5set(:,1),  & 
G1H12(37),G1H12(38),G1H12(39),G1H12(40),G1H12(41),G1H12(42),12)
  call HG1shiftOLR(G1H12(38),4,12)
  call Hotf_5pt_reduction(G2H12(48),RedSet_5(4),mass5set(:,2),  & 
G1H12(43),G1H12(44),G1H12(45),G1H12(46),G1H12(47),G1H12(48),12)
  call HG1shiftOLR(G1H12(44),4,12)
  call Hotf_5pt_reduction(G2H12(49),RedSet_5(4),mass5set(:,1),  & 
G1H12(49),G1H12(50),G1H12(51),G1H12(52),G1H12(53),G1H12(54),12)
  call HG1shiftOLR(G1H12(50),4,12)
  call Hotf_5pt_reduction(G2H12(50),RedSet_5(4),mass5set(:,2),  & 
G1H12(55),G1H12(56),G1H12(57),G1H12(58),G1H12(59),G1H12(60),12)
  call HG1shiftOLR(G1H12(56),4,12)
  call Hloop_AQ_V(ntryL,G2H12(51),ex2(:),G2H6(41),m3h2x6(:,41),heltab2x12(:,:,41))
  call Hloop_AQ_Z(ntryL,G2H12(52),ex2(:),G2H6(42),ngZu,m3h2x6(:,42),heltab2x12(:,:,42))
  call Hloop_AQ_V(ntryL,G2H12(53),ex2(:),G2H6(43),m3h2x6(:,43),heltab2x12(:,:,43))
  call Hloop_AQ_Z(ntryL,G2H12(54),ex2(:),G2H6(44),ngZu,m3h2x6(:,44),heltab2x12(:,:,44))
  call Hloop_AQ_S(ntryL,G2H12(55),ex2(:),G2H6(45),ngH,m3h2x6(:,45),heltab2x12(:,:,45))
  call Hloop_AQ_S(ntryL,G2H12(56),ex2(:),G2H6(46),ngH,m3h2x6(:,46),heltab2x12(:,:,46))
  call Hloop_AQ_V(ntryL,G2H12(57),ex2(:),G2H6(47),m3h2x6(:,47),heltab2x12(:,:,47))
  call Hloop_AQ_Z(ntryL,G2H12(58),ex2(:),G2H6(48),ngZu,m3h2x6(:,48),heltab2x12(:,:,48))
  call Hloop_AQ_V(ntryL,G2H12(59),ex2(:),G2H6(49),m3h2x6(:,49),heltab2x12(:,:,49))
  call Hloop_AQ_Z(ntryL,G2H12(60),ex2(:),G2H6(50),ngZu,m3h2x6(:,50),heltab2x12(:,:,50))
  call Hotf_5pt_reduction(G2H12(61),RedSet_5(5),mass5set(:,6),  & 
G1H12(61),G1H12(62),G1H12(63),G1H12(64),G1H12(65),G1H12(66),12)
  call HG1shiftOLR(G1H12(62),8,12)
  call Hotf_5pt_reduction(G2H12(62),RedSet_5(5),mass5set(:,7),  & 
G1H12(67),G1H12(68),G1H12(69),G1H12(70),G1H12(71),G1H12(72),12)
  call HG1shiftOLR(G1H12(68),8,12)
  call Hloop_QA_W(ntryL,G2H12(63),ex1(:),G2H6(51),m3h2x6(:,51),heltab2x12(:,:,51))
  call Hloop_QA_V(ntryL,G2H12(64),ex1(:),G2H6(52),m3h2x6(:,52),heltab2x12(:,:,52))
  call Hloop_QA_W(ntryL,G2H12(65),ex1(:),G2H6(53),m3h2x6(:,53),heltab2x12(:,:,53))
  call Hloop_QA_Z(ntryL,G2H12(66),ex1(:),G2H6(54),ngZu,m3h2x6(:,54),heltab2x12(:,:,54))
  call Hloop_QA_W(ntryL,G2H12(67),ex1(:),G2H6(55),m3h2x6(:,55),heltab2x12(:,:,55))
  call Hloop_QA_W(ntryL,G2H12(68),ex1(:),G2H6(56),m3h2x6(:,56),heltab2x12(:,:,56))
  call Hloop_QA_W(ntryL,G2H12(69),ex1(:),G2H6(57),m3h2x6(:,57),heltab2x12(:,:,57))
  call Hloop_QA_W(ntryL,G2H12(70),ex1(:),G2H6(58),m3h2x6(:,58),heltab2x12(:,:,58))
  call Hloop_QA_V(ntryL,G2H12(71),ex1(:),G2H6(59),m3h2x6(:,59),heltab2x12(:,:,59))
  call Hloop_QA_Z(ntryL,G2H12(72),ex1(:),G2H6(60),ngZu,m3h2x6(:,60),heltab2x12(:,:,60))
  call Hloop_WA_Q(ntryL,G1H8(3),ex1(:),G1H4(1),m3h2x4(:,3),heltab2x8(:,:,3))
  call Hloop_A_Q(ntryL,G1H4(1),51,0,G2H4(3),n2h4(3))
  call Hloop_WA_Q(ntryL,G1H8(4),ex1(:),G1H4(1),m3h2x4(:,4),heltab2x8(:,:,4))
  call Hloop_A_Q(ntryL,G1H4(1),51,0,G2H4(4),n2h4(4))
  call Hotf_5pt_reduction(G2H8(5),RedSet_5(6),mass5set(:,4),  & 
G1H8(3),G1H8(4),G1H8(33),G1H8(34),G1H8(35),G1H8(36),8)
  call HG1shiftOLR(G1H8(4),4,8)
  call Hotf_5pt_reduction(G2H8(6),RedSet_5(6),mass5set(:,4),  & 
G1H8(37),G1H8(38),G1H8(39),G1H8(40),G1H8(41),G1H8(42),8)
  call HG1shiftOLR(G1H8(38),4,8)
  call Hotf_5pt_reduction(G2H8(7),RedSet_5(6),mass5set(:,5),  & 
G1H8(43),G1H8(44),G1H8(45),G1H8(46),G1H8(47),G1H8(48),8)
  call HG1shiftOLR(G1H8(44),4,8)
  call Hotf_5pt_reduction(G2H8(8),RedSet_5(6),mass5set(:,5),  & 
G1H8(49),G1H8(50),G1H8(51),G1H8(52),G1H8(53),G1H8(54),8)
  call HG1shiftOLR(G1H8(50),4,8)
  call Hloop_SA_Q(ntryL,G1H8(5),ex3(:),G1H4(1),ngH,m3h2x4(:,5),heltab2x8(:,:,5))
  call Hloop_A_Q(ntryL,G1H4(1),53,nMT,G2H4(5),n2h4(5))
  call Hloop_SA_Q(ntryL,G1H8(6),ex3(:),G1H4(1),ngPtb,m3h2x4(:,6),heltab2x8(:,:,6))
  call Hloop_A_Q(ntryL,G1H4(1),53,nMB,G2H4(6),n2h4(6))
  call Hloop_SA_Q(ntryL,G1H8(7),ex3(:),G1H4(1),ngH,m3h2x4(:,7),heltab2x8(:,:,7))
  call Hloop_A_Q(ntryL,G1H4(1),53,nMT,G2H4(7),n2h4(7))
  call Hloop_SA_Q(ntryL,G1H8(8),ex3(:),G1H4(1),ngPtb,m3h2x4(:,8),heltab2x8(:,:,8))
  call Hloop_A_Q(ntryL,G1H4(1),53,nMB,G2H4(8),n2h4(8))
  call Hotf_5pt_reduction(G2H8(9),RedSet_5(7),mass5set(:,8),  & 
G1H8(5),G1H8(6),G1H8(7),G1H8(8),G1H8(55),G1H8(56),8)
  call HG1shiftOLR(G1H8(6),8,8)
  call Hotf_5pt_reduction(G2H8(10),RedSet_5(7),mass5set(:,9),  & 
G1H8(57),G1H8(58),G1H8(59),G1H8(60),G1H8(61),G1H8(62),8)
  call HG1shiftOLR(G1H8(58),8,8)
  call Hotf_5pt_reduction(G2H8(11),RedSet_5(7),mass5set(:,8),  & 
G1H8(63),G1H8(64),G1H8(65),G1H8(66),G1H8(67),G1H8(68),8)
  call HG1shiftOLR(G1H8(64),8,8)
  call Hotf_5pt_reduction(G2H8(12),RedSet_5(7),mass5set(:,9),  & 
G1H8(69),G1H8(70),G1H8(71),G1H8(72),G1H8(73),G1H8(74),8)
  call HG1shiftOLR(G1H8(70),8,8)
  call Hotf_5pt_reduction(G2H8(13),RedSet_5(7),mass5set(:,10),  & 
G1H8(75),G1H8(76),G1H8(77),G1H8(78),G1H8(79),G1H8(80),8)
  call HG1shiftOLR(G1H8(76),8,8)
  call Hotf_5pt_reduction(G2H8(14),RedSet_5(7),mass5set(:,11),  & 
G1H8(81),G1H8(82),G1H8(83),G1H8(84),G1H8(85),G1H8(86),8)
  call HG1shiftOLR(G1H8(82),8,8)
  call Hloop_SQ_A(ntryL,G1H8(9),ex2(:),G1H4(1),ngH,m3h2x4(:,9),heltab2x8(:,:,9))
  call Hloop_Q_A(ntryL,G1H4(1),51,nMT,G2H4(9),n2h4(9))
  call Hloop_SQ_A(ntryL,G1H8(10),ex2(:),G1H4(1),ngH,m3h2x4(:,10),heltab2x8(:,:,10))
  call Hloop_Q_A(ntryL,G1H4(1),51,nMT,G2H4(10),n2h4(10))
  call Hotf_5pt_reduction(G2H8(15),RedSet_5(8),mass5set(:,8),  & 
G1H8(9),G1H8(10),G1H8(87),G1H8(88),G1H8(89),G1H8(90),8)
  call HG1shiftOLR(G1H8(10),8,8)
  call Hotf_5pt_reduction(G2H8(16),RedSet_5(8),mass5set(:,8),  & 
G1H8(91),G1H8(92),G1H8(93),G1H8(94),G1H8(95),G1H8(96),8)
  call HG1shiftOLR(G1H8(92),8,8)
  call Hotf_5pt_reduction(G2H8(17),RedSet_5(8),mass5set(:,9),  & 
G1H8(97),G1H8(98),G1H8(99),G1H8(100),G1H8(101),G1H8(102),8)
  call HG1shiftOLR(G1H8(98),8,8)
  call Hotf_5pt_reduction(G2H8(18),RedSet_5(8),mass5set(:,9),  & 
G1H8(103),G1H8(104),G1H8(105),G1H8(106),G1H8(107),G1H8(108),8)
  call HG1shiftOLR(G1H8(104),8,8)
  call Hloop_AW_Q(ntryL,G1H12(1),ex5(:),G1H4(1),m3h3x4(:,1),heltab2x12(:,:,61))
  call Hloop_A_Q(ntryL,G1H4(1),51,0,G2H4(11),n2h4(11))
call HGT_OLR(G1H12(2),1,1,12)
call HGT_invQ_OLR(G1H12(2),2,5,12)
  call Hloop_Q_A(ntryL,G1H12(2),-4,nMT,G2H12(1),n2h12(73))
  call Hloop_QA_V(ntryL,G2H12(1),ex3(:),G2H6(61),m3h2x6(:,61),heltab2x12(:,:,62))
  call Hloop_AW_Q(ntryL,G1H12(5),ex5(:),G1H4(1),m3h3x4(:,2),heltab2x12(:,:,63))
  call Hloop_A_Q(ntryL,G1H4(1),51,0,G2H4(12),n2h4(12))
  call Hloop_AW_Q(ntryL,G1H12(6),ex5(:),G1H4(1),m3h3x4(:,3),heltab2x12(:,:,64))
  call Hloop_A_Q(ntryL,G1H4(1),51,0,G2H4(13),n2h4(13))
  call Hloop_AW_Q(ntryL,G1H12(7),ex5(:),G1H4(1),m3h3x4(:,4),heltab2x12(:,:,65))
  call Hloop_A_Q(ntryL,G1H4(1),51,0,G2H4(14),n2h4(14))
call HGT_OLR(G1H12(8),1,1,12)
call HGT_invQ_OLR(G1H12(8),2,5,12)
  call Hloop_Q_A(ntryL,G1H12(8),-4,nMT,G2H12(2),n2h12(74))
  call Hloop_QA_Z(ntryL,G2H12(2),ex3(:),G2H6(62),ngZu,m3h2x6(:,62),heltab2x12(:,:,66))
  call Hloop_AW_Q(ntryL,G1H12(11),ex5(:),G1H4(1),m3h3x4(:,5),heltab2x12(:,:,67))
  call Hloop_A_Q(ntryL,G1H4(1),51,0,G2H4(15),n2h4(15))
  call Hloop_AW_Q(ntryL,G1H12(12),ex5(:),G1H4(1),m3h3x4(:,6),heltab2x12(:,:,68))
  call Hloop_A_Q(ntryL,G1H4(1),51,0,G2H4(16),n2h4(16))
  call Hloop_AW_Q(ntryL,G1H12(13),ex5(:),G1H4(1),m3h3x4(:,7),heltab2x12(:,:,69))
  call Hloop_A_Q(ntryL,G1H4(1),51,0,G2H4(17),n2h4(17))
call HGT_OLR(G1H12(14),1,1,12)
call HGT_invQ_OLR(G1H12(14),2,5,12)
  call Hloop_Q_A(ntryL,G1H12(14),-4,nMT,G2H12(3),n2h12(75))
  call Hloop_QA_V(ntryL,G2H12(3),ex3(:),G2H6(63),m3h2x6(:,63),heltab2x12(:,:,70))
  call Hloop_AW_Q(ntryL,G1H12(17),ex5(:),G1H4(1),m3h3x4(:,8),heltab2x12(:,:,71))
  call Hloop_A_Q(ntryL,G1H4(1),51,0,G2H4(18),n2h4(18))
  call Hloop_AW_Q(ntryL,G1H12(18),ex5(:),G1H4(1),m3h3x4(:,9),heltab2x12(:,:,72))
  call Hloop_A_Q(ntryL,G1H4(1),51,0,G2H4(19),n2h4(19))
  call Hloop_AW_Q(ntryL,G1H12(19),ex5(:),G1H4(1),m3h3x4(:,10),heltab2x12(:,:,73))
  call Hloop_A_Q(ntryL,G1H4(1),51,0,G2H4(20),n2h4(20))
call HGT_OLR(G1H12(20),1,1,12)
call HGT_invQ_OLR(G1H12(20),2,5,12)
  call Hloop_Q_A(ntryL,G1H12(20),-4,nMT,G2H12(4),n2h12(76))
  call Hloop_QA_Z(ntryL,G2H12(4),ex3(:),G2H6(64),ngZu,m3h2x6(:,64),heltab2x12(:,:,74))
  call Hloop_AW_Q(ntryL,G1H12(23),ex5(:),G1H4(1),m3h3x4(:,11),heltab2x12(:,:,75))
  call Hloop_A_Q(ntryL,G1H4(1),51,0,G2H4(21),n2h4(21))
  call Hloop_AW_Q(ntryL,G1H12(24),ex5(:),G1H4(1),m3h3x4(:,12),heltab2x12(:,:,76))
  call Hloop_A_Q(ntryL,G1H4(1),51,0,G2H4(22),n2h4(22))
  call Hloop_QW_A(ntryL,G1H12(25),ex5(:),G1H4(1),m3h3x4(:,13),heltab2x12(:,:,77))
  call Hloop_Q_A(ntryL,G1H4(1),51,nMT,G2H4(23),n2h4(23))
call HGT_OLR(G1H12(26),1,1,12)
call HGT_invQ_OLR(G1H12(26),2,5,12)
  call Hloop_A_Q(ntryL,G1H12(26),-8,0,G2H12(5),n2h12(77))
  call Hloop_AQ_V(ntryL,G2H12(5),ex4(:),G2H6(65),m3h2x6(:,65),heltab2x12(:,:,78))
  call Hloop_QW_A(ntryL,G1H12(29),ex5(:),G1H4(1),m3h3x4(:,14),heltab2x12(:,:,79))
  call Hloop_Q_A(ntryL,G1H4(1),51,nMT,G2H4(24),n2h4(24))
  call Hloop_QW_A(ntryL,G1H12(30),ex5(:),G1H4(1),m3h3x4(:,15),heltab2x12(:,:,80))
  call Hloop_Q_A(ntryL,G1H4(1),51,nMT,G2H4(25),n2h4(25))
  call Hloop_QW_A(ntryL,G1H12(31),ex5(:),G1H4(1),m3h3x4(:,16),heltab2x12(:,:,81))
  call Hloop_Q_A(ntryL,G1H4(1),51,nMT,G2H4(26),n2h4(26))
call HGT_OLR(G1H12(32),1,1,12)
call HGT_invQ_OLR(G1H12(32),2,5,12)
  call Hloop_A_Q(ntryL,G1H12(32),-8,0,G2H12(6),n2h12(78))
  call Hloop_AQ_Z(ntryL,G2H12(6),ex4(:),G2H6(66),ngZd,m3h2x6(:,66),heltab2x12(:,:,82))
  call Hloop_QW_A(ntryL,G1H12(35),ex5(:),G1H4(1),m3h3x4(:,17),heltab2x12(:,:,83))
  call Hloop_Q_A(ntryL,G1H4(1),51,nMT,G2H4(27),n2h4(27))
  call Hloop_QW_A(ntryL,G1H12(36),ex5(:),G1H4(1),m3h3x4(:,18),heltab2x12(:,:,84))
  call Hloop_Q_A(ntryL,G1H4(1),51,nMT,G2H4(28),n2h4(28))
  call Hloop_WQ_A(ntryL,G1H8(1),ex4(:),G1H4(1),m3h2x4(:,11),heltab2x8(:,:,11))
  call Hloop_Q_A(ntryL,G1H4(1),58,0,G2H4(29),n2h4(29))
call HGT_OLR(G1H8(2),1,1,8)
call HGT_invQ_OLR(G1H8(2),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(2),-4,nMT,G2H8(1),n2h8(1))
  call Hloop_QA_V(ntryL,G2H8(1),ex3(:),G2H4(30),m3h2x4(:,12),heltab2x8(:,:,12))
  call Hloop_WQ_A(ntryL,G1H8(13),ex4(:),G1H4(1),m3h2x4(:,13),heltab2x8(:,:,13))
  call Hloop_Q_A(ntryL,G1H4(1),58,0,G2H4(31),n2h4(30))
  call Hloop_WQ_A(ntryL,G1H8(14),ex4(:),G1H4(1),m3h2x4(:,14),heltab2x8(:,:,14))
  call Hloop_Q_A(ntryL,G1H4(1),58,0,G2H4(32),n2h4(31))
  call Hloop_WQ_A(ntryL,G1H8(15),ex4(:),G1H4(1),m3h2x4(:,15),heltab2x8(:,:,15))
  call Hloop_Q_A(ntryL,G1H4(1),58,0,G2H4(33),n2h4(32))
call HGT_OLR(G1H8(16),1,1,8)
call HGT_invQ_OLR(G1H8(16),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(16),-4,nMT,G2H8(2),n2h8(2))
  call Hloop_QA_V(ntryL,G2H8(2),ex3(:),G2H4(34),m3h2x4(:,16),heltab2x8(:,:,16))
  call Hloop_WQ_A(ntryL,G1H8(19),ex4(:),G1H4(1),m3h2x4(:,17),heltab2x8(:,:,17))
  call Hloop_Q_A(ntryL,G1H4(1),58,0,G2H4(35),n2h4(33))
  call Hloop_WQ_A(ntryL,G1H8(20),ex4(:),G1H4(1),m3h2x4(:,18),heltab2x8(:,:,18))
  call Hloop_Q_A(ntryL,G1H4(1),58,0,G2H4(36),n2h4(34))
  call Hloop_WQ_A(ntryL,G1H8(21),ex4(:),G1H4(1),m3h2x4(:,19),heltab2x8(:,:,19))
  call Hloop_Q_A(ntryL,G1H4(1),58,0,G2H4(37),n2h4(35))
call HGT_OLR(G1H8(22),1,1,8)
call HGT_invQ_OLR(G1H8(22),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(22),-4,nMT,G2H8(3),n2h8(3))
  call Hloop_QA_Z(ntryL,G2H8(3),ex3(:),G2H4(38),ngZu,m3h2x4(:,20),heltab2x8(:,:,20))
  call Hloop_WQ_A(ntryL,G1H8(25),ex4(:),G1H4(1),m3h2x4(:,21),heltab2x8(:,:,21))
  call Hloop_Q_A(ntryL,G1H4(1),58,0,G2H4(39),n2h4(36))
  call Hloop_WQ_A(ntryL,G1H8(26),ex4(:),G1H4(1),m3h2x4(:,22),heltab2x8(:,:,22))
  call Hloop_Q_A(ntryL,G1H4(1),58,0,G2H4(40),n2h4(37))
  call Hloop_WQ_A(ntryL,G1H8(27),ex4(:),G1H4(1),m3h2x4(:,23),heltab2x8(:,:,23))
  call Hloop_Q_A(ntryL,G1H4(1),58,0,G2H4(41),n2h4(38))
call HGT_OLR(G1H8(28),1,1,8)
call HGT_invQ_OLR(G1H8(28),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(28),-4,nMT,G2H8(4),n2h8(4))
  call Hloop_QA_Z(ntryL,G2H8(4),ex3(:),G2H4(42),ngZu,m3h2x4(:,24),heltab2x8(:,:,24))
  call Hloop_WQ_A(ntryL,G1H8(31),ex4(:),G1H4(1),m3h2x4(:,25),heltab2x8(:,:,25))
  call Hloop_Q_A(ntryL,G1H4(1),58,0,G2H4(43),n2h4(39))
  call Hloop_WQ_A(ntryL,G1H8(32),ex4(:),G1H4(1),m3h2x4(:,26),heltab2x8(:,:,26))
  call Hloop_Q_A(ntryL,G1H4(1),58,0,G2H4(44),n2h4(40))
  call Hloop_QW_A(ntryL,G1H12(37),ex5(:),G1H4(1),m3h3x4(:,19),heltab2x12(:,:,85))
  call Hloop_Q_A(ntryL,G1H4(1),58,0,G2H4(45),n2h4(41))
call HGT_OLR(G1H12(38),1,1,12)
call HGT_invQ_OLR(G1H12(38),2,5,12)
  call Hloop_Q_A(ntryL,G1H12(38),-4,nMT,G2H12(7),n2h12(79))
  call Hloop_QA_V(ntryL,G2H12(7),ex3(:),G2H6(67),m3h2x6(:,67),heltab2x12(:,:,86))
  call Hloop_QW_A(ntryL,G1H12(41),ex5(:),G1H4(1),m3h3x4(:,20),heltab2x12(:,:,87))
  call Hloop_Q_A(ntryL,G1H4(1),58,0,G2H4(46),n2h4(42))
  call Hloop_QW_A(ntryL,G1H12(42),ex5(:),G1H4(1),m3h3x4(:,21),heltab2x12(:,:,88))
  call Hloop_Q_A(ntryL,G1H4(1),58,0,G2H4(47),n2h4(43))
  call Hloop_QW_A(ntryL,G1H12(43),ex5(:),G1H4(1),m3h3x4(:,22),heltab2x12(:,:,89))
  call Hloop_Q_A(ntryL,G1H4(1),58,0,G2H4(48),n2h4(44))
call HGT_OLR(G1H12(44),1,1,12)
call HGT_invQ_OLR(G1H12(44),2,5,12)
  call Hloop_Q_A(ntryL,G1H12(44),-4,nMT,G2H12(8),n2h12(80))
  call Hloop_QA_V(ntryL,G2H12(8),ex3(:),G2H6(68),m3h2x6(:,68),heltab2x12(:,:,90))
  call Hloop_QW_A(ntryL,G1H12(47),ex5(:),G1H4(1),m3h3x4(:,23),heltab2x12(:,:,91))
  call Hloop_Q_A(ntryL,G1H4(1),58,0,G2H4(49),n2h4(45))
  call Hloop_QW_A(ntryL,G1H12(48),ex5(:),G1H4(1),m3h3x4(:,24),heltab2x12(:,:,92))
  call Hloop_Q_A(ntryL,G1H4(1),58,0,G2H4(50),n2h4(46))
  call Hloop_QW_A(ntryL,G1H12(49),ex5(:),G1H4(1),m3h3x4(:,25),heltab2x12(:,:,93))
  call Hloop_Q_A(ntryL,G1H4(1),58,0,G2H4(51),n2h4(47))
call HGT_OLR(G1H12(50),1,1,12)
call HGT_invQ_OLR(G1H12(50),2,5,12)
  call Hloop_Q_A(ntryL,G1H12(50),-4,nMT,G2H12(9),n2h12(81))
  call Hloop_QA_Z(ntryL,G2H12(9),ex3(:),G2H6(69),ngZu,m3h2x6(:,69),heltab2x12(:,:,94))
  call Hloop_QW_A(ntryL,G1H12(53),ex5(:),G1H4(1),m3h3x4(:,26),heltab2x12(:,:,95))
  call Hloop_Q_A(ntryL,G1H4(1),58,0,G2H4(52),n2h4(48))
  call Hloop_QW_A(ntryL,G1H12(54),ex5(:),G1H4(1),m3h3x4(:,27),heltab2x12(:,:,96))
  call Hloop_Q_A(ntryL,G1H4(1),58,0,G2H4(53),n2h4(49))
  call Hloop_QW_A(ntryL,G1H12(55),ex5(:),G1H4(1),m3h3x4(:,28),heltab2x12(:,:,97))
  call Hloop_Q_A(ntryL,G1H4(1),58,0,G2H4(54),n2h4(50))
call HGT_OLR(G1H12(56),1,1,12)
call HGT_invQ_OLR(G1H12(56),2,5,12)
  call Hloop_Q_A(ntryL,G1H12(56),-4,nMT,G2H12(10),n2h12(82))
  call Hloop_QA_Z(ntryL,G2H12(10),ex3(:),G2H6(70),ngZu,m3h2x6(:,70),heltab2x12(:,:,98))
  call Hloop_QW_A(ntryL,G1H12(59),ex5(:),G1H4(1),m3h3x4(:,29),heltab2x12(:,:,99))
  call Hloop_Q_A(ntryL,G1H4(1),58,0,G2H4(55),n2h4(51))
  call Hloop_QW_A(ntryL,G1H12(60),ex5(:),G1H4(1),m3h3x4(:,30),heltab2x12(:,:,100))
  call Hloop_Q_A(ntryL,G1H4(1),58,0,G2H4(56),n2h4(52))
  call Hloop_AW_Q(ntryL,G1H12(61),ex5(:),G1H4(1),m3h3x4(:,31),heltab2x12(:,:,101))
  call Hloop_A_Q(ntryL,G1H4(1),53,nMB,G2H4(57),n2h4(53))
call HGT_OLR(G1H12(62),1,1,12)
call HGT_invQ_OLR(G1H12(62),2,5,12)
  call Hloop_A_Q(ntryL,G1H12(62),-8,0,G2H12(11),n2h12(83))
  call Hloop_AQ_W(ntryL,G2H12(11),ex4(:),G2H6(71),m3h2x6(:,71),heltab2x12(:,:,102))
  call Hloop_AW_Q(ntryL,G1H12(65),ex5(:),G1H4(1),m3h3x4(:,32),heltab2x12(:,:,103))
  call Hloop_A_Q(ntryL,G1H4(1),53,nMB,G2H4(58),n2h4(54))
  call Hloop_AW_Q(ntryL,G1H12(66),ex5(:),G1H4(1),m3h3x4(:,33),heltab2x12(:,:,104))
  call Hloop_A_Q(ntryL,G1H4(1),53,nMB,G2H4(59),n2h4(55))
  call Hloop_AW_Q(ntryL,G1H12(67),ex5(:),G1H4(1),m3h3x4(:,34),heltab2x12(:,:,105))
  call Hloop_A_Q(ntryL,G1H4(1),53,nMB,G2H4(60),n2h4(56))
call HGT_OLR(G1H12(68),1,1,12)
call HGT_invQ_OLR(G1H12(68),2,5,12)
  call Hloop_A_Q(ntryL,G1H12(68),-8,0,G2H12(12),n2h12(84))
  call Hloop_AQ_W(ntryL,G2H12(12),ex4(:),G2H6(72),m3h2x6(:,72),heltab2x12(:,:,106))
  call Hloop_AW_Q(ntryL,G1H12(71),ex5(:),G1H4(1),m3h3x4(:,35),heltab2x12(:,:,107))
  call Hloop_A_Q(ntryL,G1H4(1),53,nMB,G2H4(61),n2h4(57))
  call Hloop_AW_Q(ntryL,G1H12(72),ex5(:),G1H4(1),m3h3x4(:,36),heltab2x12(:,:,108))
  call Hloop_A_Q(ntryL,G1H4(1),53,nMB,G2H4(62),n2h4(58))
  call Hloop_WA_Q(ntryL,G1H8(3),ex1(:),G1H4(1),m3h2x4(:,27),heltab2x8(:,:,27))
  call Hloop_A_Q(ntryL,G1H4(1),51,0,G2H4(63),n2h4(59))
call HGT_OLR(G1H8(4),1,1,8)
call HGT_invQ_OLR(G1H8(4),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(4),-4,nMT,G2H8(5),n2h8(5))
  call Hloop_QA_V(ntryL,G2H8(5),ex3(:),G2H4(64),m3h2x4(:,28),heltab2x8(:,:,28))
  call Hloop_WA_Q(ntryL,G1H8(35),ex1(:),G1H4(1),m3h2x4(:,29),heltab2x8(:,:,29))
  call Hloop_A_Q(ntryL,G1H4(1),51,0,G2H4(65),n2h4(60))
  call Hloop_WA_Q(ntryL,G1H8(36),ex1(:),G1H4(1),m3h2x4(:,30),heltab2x8(:,:,30))
  call Hloop_A_Q(ntryL,G1H4(1),51,0,G2H4(66),n2h4(61))
  call Hloop_WA_Q(ntryL,G1H8(37),ex1(:),G1H4(1),m3h2x4(:,31),heltab2x8(:,:,31))
  call Hloop_A_Q(ntryL,G1H4(1),51,0,G2H4(67),n2h4(62))
call HGT_OLR(G1H8(38),1,1,8)
call HGT_invQ_OLR(G1H8(38),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(38),-4,nMT,G2H8(6),n2h8(6))
  call Hloop_QA_Z(ntryL,G2H8(6),ex3(:),G2H4(68),ngZu,m3h2x4(:,32),heltab2x8(:,:,32))
  call Hloop_WA_Q(ntryL,G1H8(41),ex1(:),G1H4(1),m3h2x4(:,33),heltab2x8(:,:,33))
  call Hloop_A_Q(ntryL,G1H4(1),51,0,G2H4(69),n2h4(63))
  call Hloop_WA_Q(ntryL,G1H8(42),ex1(:),G1H4(1),m3h2x4(:,34),heltab2x8(:,:,34))
  call Hloop_A_Q(ntryL,G1H4(1),51,0,G2H4(70),n2h4(64))
  call Hloop_WA_Q(ntryL,G1H8(43),ex1(:),G1H4(1),m3h2x4(:,35),heltab2x8(:,:,35))
  call Hloop_A_Q(ntryL,G1H4(1),51,0,G2H4(71),n2h4(65))
call HGT_OLR(G1H8(44),1,1,8)
call HGT_invQ_OLR(G1H8(44),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(44),-4,nMT,G2H8(7),n2h8(7))
  call Hloop_QA_V(ntryL,G2H8(7),ex3(:),G2H4(72),m3h2x4(:,36),heltab2x8(:,:,36))
  call Hloop_WA_Q(ntryL,G1H8(47),ex1(:),G1H4(1),m3h2x4(:,37),heltab2x8(:,:,37))
  call Hloop_A_Q(ntryL,G1H4(1),51,0,G2H4(73),n2h4(66))
  call Hloop_WA_Q(ntryL,G1H8(48),ex1(:),G1H4(1),m3h2x4(:,38),heltab2x8(:,:,38))
  call Hloop_A_Q(ntryL,G1H4(1),51,0,G2H4(74),n2h4(67))
  call Hloop_WA_Q(ntryL,G1H8(49),ex1(:),G1H4(1),m3h2x4(:,39),heltab2x8(:,:,39))
  call Hloop_A_Q(ntryL,G1H4(1),51,0,G2H4(75),n2h4(68))
call HGT_OLR(G1H8(50),1,1,8)
call HGT_invQ_OLR(G1H8(50),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(50),-4,nMT,G2H8(8),n2h8(8))
  call Hloop_QA_Z(ntryL,G2H8(8),ex3(:),G2H4(76),ngZu,m3h2x4(:,40),heltab2x8(:,:,40))
  call Hloop_WA_Q(ntryL,G1H8(53),ex1(:),G1H4(1),m3h2x4(:,41),heltab2x8(:,:,41))
  call Hloop_A_Q(ntryL,G1H4(1),51,0,G2H4(77),n2h4(69))
  call Hloop_WA_Q(ntryL,G1H8(54),ex1(:),G1H4(1),m3h2x4(:,42),heltab2x8(:,:,42))
  call Hloop_A_Q(ntryL,G1H4(1),51,0,G2H4(78),n2h4(70))
  call Hloop_VA_Q(ntryL,G1H8(5),ex3(:),G1H4(1),m3h2x4(:,43),heltab2x8(:,:,43))
  call Hloop_A_Q(ntryL,G1H4(1),53,nMT,G2H4(79),n2h4(71))
call HGT_OLR(G1H8(6),1,1,8)
call HGT_invQ_OLR(G1H8(6),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(6),-8,0,G2H8(9),n2h8(9))
  call Hloop_AQ_V(ntryL,G2H8(9),ex4(:),G2H4(80),m3h2x4(:,44),heltab2x8(:,:,44))
  call Hloop_VA_Q(ntryL,G1H8(55),ex3(:),G1H4(1),m3h2x4(:,45),heltab2x8(:,:,45))
  call Hloop_A_Q(ntryL,G1H4(1),53,nMT,G2H4(81),n2h4(72))
  call Hloop_VA_Q(ntryL,G1H8(56),ex3(:),G1H4(1),m3h2x4(:,46),heltab2x8(:,:,46))
  call Hloop_A_Q(ntryL,G1H4(1),53,nMT,G2H4(82),n2h4(73))
  call Hloop_ZA_Q(ntryL,G1H8(57),ex3(:),G1H4(1),ngZu,m3h2x4(:,47),heltab2x8(:,:,47))
  call Hloop_A_Q(ntryL,G1H4(1),53,nMT,G2H4(83),n2h4(74))
call HGT_OLR(G1H8(58),1,1,8)
call HGT_invQ_OLR(G1H8(58),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(58),-8,0,G2H8(10),n2h8(10))
  call Hloop_AQ_V(ntryL,G2H8(10),ex4(:),G2H4(84),m3h2x4(:,48),heltab2x8(:,:,48))
  call Hloop_ZA_Q(ntryL,G1H8(61),ex3(:),G1H4(1),ngZu,m3h2x4(:,49),heltab2x8(:,:,49))
  call Hloop_A_Q(ntryL,G1H4(1),53,nMT,G2H4(85),n2h4(75))
  call Hloop_ZA_Q(ntryL,G1H8(62),ex3(:),G1H4(1),ngZu,m3h2x4(:,50),heltab2x8(:,:,50))
  call Hloop_A_Q(ntryL,G1H4(1),53,nMT,G2H4(86),n2h4(76))
  call Hloop_VA_Q(ntryL,G1H8(63),ex3(:),G1H4(1),m3h2x4(:,51),heltab2x8(:,:,51))
  call Hloop_A_Q(ntryL,G1H4(1),53,nMT,G2H4(87),n2h4(77))
call HGT_OLR(G1H8(64),1,1,8)
call HGT_invQ_OLR(G1H8(64),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(64),-8,0,G2H8(11),n2h8(11))
  call Hloop_AQ_Z(ntryL,G2H8(11),ex4(:),G2H4(88),ngZd,m3h2x4(:,52),heltab2x8(:,:,52))
  call Hloop_VA_Q(ntryL,G1H8(67),ex3(:),G1H4(1),m3h2x4(:,53),heltab2x8(:,:,53))
  call Hloop_A_Q(ntryL,G1H4(1),53,nMT,G2H4(89),n2h4(78))
  call Hloop_VA_Q(ntryL,G1H8(68),ex3(:),G1H4(1),m3h2x4(:,54),heltab2x8(:,:,54))
  call Hloop_A_Q(ntryL,G1H4(1),53,nMT,G2H4(90),n2h4(79))
  call Hloop_ZA_Q(ntryL,G1H8(69),ex3(:),G1H4(1),ngZu,m3h2x4(:,55),heltab2x8(:,:,55))
  call Hloop_A_Q(ntryL,G1H4(1),53,nMT,G2H4(91),n2h4(80))
call HGT_OLR(G1H8(70),1,1,8)
call HGT_invQ_OLR(G1H8(70),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(70),-8,0,G2H8(12),n2h8(12))
  call Hloop_AQ_Z(ntryL,G2H8(12),ex4(:),G2H4(92),ngZd,m3h2x4(:,56),heltab2x8(:,:,56))
  call Hloop_ZA_Q(ntryL,G1H8(73),ex3(:),G1H4(1),ngZu,m3h2x4(:,57),heltab2x8(:,:,57))
  call Hloop_A_Q(ntryL,G1H4(1),53,nMT,G2H4(93),n2h4(81))
  call Hloop_ZA_Q(ntryL,G1H8(74),ex3(:),G1H4(1),ngZu,m3h2x4(:,58),heltab2x8(:,:,58))
  call Hloop_A_Q(ntryL,G1H4(1),53,nMT,G2H4(94),n2h4(82))
  call Hloop_WA_Q(ntryL,G1H8(75),ex3(:),G1H4(1),m3h2x4(:,59),heltab2x8(:,:,59))
  call Hloop_A_Q(ntryL,G1H4(1),53,nMB,G2H4(95),n2h4(83))
call HGT_OLR(G1H8(76),1,1,8)
call HGT_invQ_OLR(G1H8(76),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(76),-8,0,G2H8(13),n2h8(13))
  call Hloop_AQ_W(ntryL,G2H8(13),ex4(:),G2H4(96),m3h2x4(:,60),heltab2x8(:,:,60))
  call Hloop_WA_Q(ntryL,G1H8(79),ex3(:),G1H4(1),m3h2x4(:,61),heltab2x8(:,:,61))
  call Hloop_A_Q(ntryL,G1H4(1),53,nMB,G2H4(97),n2h4(84))
  call Hloop_WA_Q(ntryL,G1H8(80),ex3(:),G1H4(1),m3h2x4(:,62),heltab2x8(:,:,62))
  call Hloop_A_Q(ntryL,G1H4(1),53,nMB,G2H4(98),n2h4(85))
  call Hloop_WA_Q(ntryL,G1H8(81),ex3(:),G1H4(1),m3h2x4(:,63),heltab2x8(:,:,63))
  call Hloop_A_Q(ntryL,G1H4(1),53,nMB,G2H4(99),n2h4(86))
call HGT_OLR(G1H8(82),1,1,8)
call HGT_invQ_OLR(G1H8(82),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(82),-8,0,G2H8(14),n2h8(14))
  call Hloop_AQ_W(ntryL,G2H8(14),ex4(:),G2H4(100),m3h2x4(:,64),heltab2x8(:,:,64))
  call Hloop_WA_Q(ntryL,G1H8(85),ex3(:),G1H4(1),m3h2x4(:,65),heltab2x8(:,:,65))
  call Hloop_A_Q(ntryL,G1H4(1),53,nMB,G2H4(101),n2h4(87))
  call Hloop_WA_Q(ntryL,G1H8(86),ex3(:),G1H4(1),m3h2x4(:,66),heltab2x8(:,:,66))
  call Hloop_A_Q(ntryL,G1H4(1),53,nMB,G2H4(102),n2h4(88))
  call Hloop_VQ_A(ntryL,G1H8(9),ex2(:),G1H4(1),m3h2x4(:,67),heltab2x8(:,:,67))
  call Hloop_Q_A(ntryL,G1H4(1),51,nMT,G2H4(103),n2h4(89))
call HGT_OLR(G1H8(10),1,1,8)
call HGT_invQ_OLR(G1H8(10),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(10),-8,0,G2H8(15),n2h8(15))
  call Hloop_AQ_V(ntryL,G2H8(15),ex4(:),G2H4(104),m3h2x4(:,68),heltab2x8(:,:,68))
  call Hloop_VQ_A(ntryL,G1H8(89),ex2(:),G1H4(1),m3h2x4(:,69),heltab2x8(:,:,69))
  call Hloop_Q_A(ntryL,G1H4(1),51,nMT,G2H4(105),n2h4(90))
  call Hloop_VQ_A(ntryL,G1H8(90),ex2(:),G1H4(1),m3h2x4(:,70),heltab2x8(:,:,70))
  call Hloop_Q_A(ntryL,G1H4(1),51,nMT,G2H4(106),n2h4(91))
  call Hloop_VQ_A(ntryL,G1H8(91),ex2(:),G1H4(1),m3h2x4(:,71),heltab2x8(:,:,71))
  call Hloop_Q_A(ntryL,G1H4(1),51,nMT,G2H4(107),n2h4(92))
call HGT_OLR(G1H8(92),1,1,8)
call HGT_invQ_OLR(G1H8(92),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(92),-8,0,G2H8(16),n2h8(16))
  call Hloop_AQ_Z(ntryL,G2H8(16),ex4(:),G2H4(108),ngZd,m3h2x4(:,72),heltab2x8(:,:,72))
  call Hloop_VQ_A(ntryL,G1H8(95),ex2(:),G1H4(1),m3h2x4(:,73),heltab2x8(:,:,73))
  call Hloop_Q_A(ntryL,G1H4(1),51,nMT,G2H4(109),n2h4(93))
  call Hloop_VQ_A(ntryL,G1H8(96),ex2(:),G1H4(1),m3h2x4(:,74),heltab2x8(:,:,74))
  call Hloop_Q_A(ntryL,G1H4(1),51,nMT,G2H4(110),n2h4(94))
  call Hloop_ZQ_A(ntryL,G1H8(97),ex2(:),G1H4(1),ngZu,m3h2x4(:,75),heltab2x8(:,:,75))
  call Hloop_Q_A(ntryL,G1H4(1),51,nMT,G2H4(111),n2h4(95))
call HGT_OLR(G1H8(98),1,1,8)
call HGT_invQ_OLR(G1H8(98),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(98),-8,0,G2H8(17),n2h8(17))
  call Hloop_AQ_V(ntryL,G2H8(17),ex4(:),G2H4(112),m3h2x4(:,76),heltab2x8(:,:,76))
  call Hloop_ZQ_A(ntryL,G1H8(101),ex2(:),G1H4(1),ngZu,m3h2x4(:,77),heltab2x8(:,:,77))
  call Hloop_Q_A(ntryL,G1H4(1),51,nMT,G2H4(113),n2h4(96))
  call Hloop_ZQ_A(ntryL,G1H8(102),ex2(:),G1H4(1),ngZu,m3h2x4(:,78),heltab2x8(:,:,78))
  call Hloop_Q_A(ntryL,G1H4(1),51,nMT,G2H4(114),n2h4(97))
  call Hloop_ZQ_A(ntryL,G1H8(103),ex2(:),G1H4(1),ngZu,m3h2x4(:,79),heltab2x8(:,:,79))
  call Hloop_Q_A(ntryL,G1H4(1),51,nMT,G2H4(115),n2h4(98))
call HGT_OLR(G1H8(104),1,1,8)
call HGT_invQ_OLR(G1H8(104),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(104),-8,0,G2H8(18),n2h8(18))
  call Hloop_AQ_Z(ntryL,G2H8(18),ex4(:),G2H4(116),ngZd,m3h2x4(:,80),heltab2x8(:,:,80))
  call Hloop_ZQ_A(ntryL,G1H8(107),ex2(:),G1H4(1),ngZu,m3h2x4(:,81),heltab2x8(:,:,81))
  call Hloop_Q_A(ntryL,G1H4(1),51,nMT,G2H4(117),n2h4(99))
  call Hloop_ZQ_A(ntryL,G1H8(108),ex2(:),G1H4(1),ngZu,m3h2x4(:,82),heltab2x8(:,:,82))
  call Hloop_Q_A(ntryL,G1H4(1),51,nMT,G2H4(118),n2h4(100))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(95),[G2H4(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(99),[G2H4(8)])
  call Hotf_5pt_reduction(G2H6(1),RedSet_5(9),mass5set(:,12),  & 
G1H6(1),G1H6(2),G1H6(3),G1H6(4),G1H6(5),G1H6(6),6)
  call HG1shiftOLR(G1H6(2),16,6)
  call Hotf_5pt_reduction(G2H6(2),RedSet_5(9),mass5set(:,13),  & 
G1H6(7),G1H6(8),G1H6(9),G1H6(10),G1H6(11),G1H6(12),6)
  call HG1shiftOLR(G1H6(8),16,6)
  call Hotf_5pt_reduction(G2H6(3),RedSet_5(10),mass5set(:,14),  & 
G1H6(13),G1H6(14),G1H6(15),G1H6(16),G1H6(17),G1H6(18),6)
  call HG1shiftOLR(G1H6(14),16,6)
  call Hotf_5pt_reduction(G2H6(4),RedSet_5(10),mass5set(:,15),  & 
G1H6(19),G1H6(20),G1H6(21),G1H6(22),G1H6(23),G1H6(24),6)
  call HG1shiftOLR(G1H6(20),16,6)
  call Hloop_VV_S(ntryL,G2H6(5),ex5(:),G2H2(1),m3h3x2(:,1),heltab2x6(:,:,1))
  call Hloop_VV_S(ntryL,G2H6(6),ex5(:),G2H2(2),m3h3x2(:,2),heltab2x6(:,:,2))
  call Hloop_VV_S(ntryL,G2H6(7),ex5(:),G2H2(3),m3h3x2(:,3),heltab2x6(:,:,3))
  call Hloop_VV_S(ntryL,G2H6(8),ex5(:),G2H2(4),m3h3x2(:,4),heltab2x6(:,:,4))
  call Hotf_5pt_reduction(G2H6(9),RedSet_5(10),mass5set(:,12),  & 
G1H6(25),G1H6(26),G1H6(27),G1H6(28),G1H6(29),G1H6(30),6)
  call HG1shiftOLR(G1H6(26),4,6)
  call Hotf_5pt_reduction(G2H6(10),RedSet_5(10),mass5set(:,12),  & 
G1H6(31),G1H6(32),G1H6(33),G1H6(34),G1H6(35),G1H6(36),6)
  call HG1shiftOLR(G1H6(32),4,6)
  call Hotf_5pt_reduction(G2H6(11),RedSet_5(10),mass5set(:,13),  & 
G1H6(37),G1H6(38),G1H6(39),G1H6(40),G1H6(41),G1H6(42),6)
  call HG1shiftOLR(G1H6(38),4,6)
  call Hotf_5pt_reduction(G2H6(12),RedSet_5(10),mass5set(:,13),  & 
G1H6(43),G1H6(44),G1H6(45),G1H6(46),G1H6(47),G1H6(48),6)
  call HG1shiftOLR(G1H6(44),4,6)
  call Hotf_5pt_reduction(G2H6(13),RedSet_5(10),mass5set(:,14),  & 
G1H6(49),G1H6(50),G1H6(51),G1H6(52),G1H6(53),G1H6(54),6)
  call HG1shiftOLR(G1H6(50),4,6)
  call Hotf_5pt_reduction(G2H6(14),RedSet_5(10),mass5set(:,15),  & 
G1H6(55),G1H6(56),G1H6(57),G1H6(58),G1H6(59),G1H6(60),6)
  call HG1shiftOLR(G1H6(56),4,6)
  call Hotf_5pt_reduction(G2H6(15),RedSet_5(11),mass5set(:,16),  & 
G1H6(61),G1H6(62),G1H6(63),G1H6(64),G1H6(65),G1H6(66),6)
  call HG1shiftOLR(G1H6(62),16,6)
  call Hotf_5pt_reduction(G2H6(16),RedSet_5(11),mass5set(:,17),  & 
G1H6(67),G1H6(68),G1H6(69),G1H6(70),G1H6(71),G1H6(72),6)
  call HG1shiftOLR(G1H6(68),16,6)
  call Hotf_5pt_reduction(G2H6(17),RedSet_5(11),mass5set(:,18),  & 
G1H6(73),G1H6(74),G1H6(75),G1H6(76),G1H6(77),G1H6(78),6)
  call HG1shiftOLR(G1H6(74),16,6)
  call Hotf_5pt_reduction(G2H6(18),RedSet_5(11),mass5set(:,19),  & 
G1H6(79),G1H6(80),G1H6(81),G1H6(82),G1H6(83),G1H6(84),6)
  call HG1shiftOLR(G1H6(80),16,6)
  call Hotf_5pt_reduction(G2H6(19),RedSet_5(12),mass5set(:,16),  & 
G1H6(85),G1H6(86),G1H6(87),G1H6(88),G1H6(89),G1H6(90),6)
  call HG1shiftOLR(G1H6(86),16,6)
  call Hotf_5pt_reduction(G2H6(20),RedSet_5(12),mass5set(:,18),  & 
G1H6(91),G1H6(92),G1H6(93),G1H6(94),G1H6(95),G1H6(96),6)
  call HG1shiftOLR(G1H6(92),16,6)
  call Hotf_5pt_reduction(G2H6(21),RedSet_5(12),mass5set(:,17),  & 
G1H6(97),G1H6(98),G1H6(99),G1H6(100),G1H6(101),G1H6(102),6)
  call HG1shiftOLR(G1H6(98),16,6)
  call Hotf_5pt_reduction(G2H6(22),RedSet_5(12),mass5set(:,19),  & 
G1H6(103),G1H6(104),G1H6(105),G1H6(106),G1H6(107),G1H6(108),6)
  call HG1shiftOLR(G1H6(104),16,6)
  call Hloop_SV_V(ntryL,G2H6(23),ex5(:),G2H2(5),m3h3x2(:,5),heltab2x6(:,:,5))
  call Hloop_SV_V(ntryL,G2H6(24),ex5(:),G2H2(6),m3h3x2(:,6),heltab2x6(:,:,6))
  call Hloop_SV_V(ntryL,G2H6(25),ex5(:),G2H2(7),m3h3x2(:,7),heltab2x6(:,:,7))
  call Hloop_SV_V(ntryL,G2H6(26),ex5(:),G2H2(8),m3h3x2(:,8),heltab2x6(:,:,8))
  call Hotf_5pt_reduction(G2H6(27),RedSet_5(12),mass5set(:,16),  & 
G1H6(109),G1H6(110),G1H6(111),G1H6(112),G1H6(113),G1H6(114),6)
  call HG1shiftOLR(G1H6(110),8,6)
  call Hotf_5pt_reduction(G2H6(28),RedSet_5(12),mass5set(:,18),  & 
G1H6(115),G1H6(116),G1H6(117),G1H6(118),G1H6(119),G1H6(120),6)
  call HG1shiftOLR(G1H6(116),8,6)
  call Hotf_5pt_reduction(G2H6(29),RedSet_5(12),mass5set(:,17),  & 
G1H6(121),G1H6(122),G1H6(123),G1H6(124),G1H6(125),G1H6(126),6)
  call HG1shiftOLR(G1H6(122),8,6)
  call Hotf_5pt_reduction(G2H6(30),RedSet_5(12),mass5set(:,19),  & 
G1H6(127),G1H6(128),G1H6(129),G1H6(130),G1H6(131),G1H6(132),6)
  call HG1shiftOLR(G1H6(128),8,6)
  call Hotf_5pt_reduction(G2H6(31),RedSet_5(12),mass5set(:,20),  & 
G1H6(133),G1H6(134),G1H6(135),G1H6(136),G1H6(137),G1H6(138),6)
  call HG1shiftOLR(G1H6(134),8,6)
  call Hotf_5pt_reduction(G2H6(32),RedSet_5(12),mass5set(:,20),  & 
G1H6(139),G1H6(140),G1H6(141),G1H6(142),G1H6(143),G1H6(144),6)
  call HG1shiftOLR(G1H6(140),8,6)
  call Hotf_5pt_reduction(G2H6(33),RedSet_5(13),mass5set(:,12),  & 
G1H6(145),G1H6(146),G1H6(147),G1H6(148),G1H6(149),G1H6(150),6)
  call HG1shiftOLR(G1H6(146),16,6)
  call Hotf_5pt_reduction(G2H6(34),RedSet_5(13),mass5set(:,13),  & 
G1H6(151),G1H6(152),G1H6(153),G1H6(154),G1H6(155),G1H6(156),6)
  call HG1shiftOLR(G1H6(152),16,6)
  call Hotf_5pt_reduction(G2H6(35),RedSet_5(14),mass5set(:,14),  & 
G1H6(157),G1H6(158),G1H6(159),G1H6(160),G1H6(161),G1H6(162),6)
  call HG1shiftOLR(G1H6(158),16,6)
  call Hotf_5pt_reduction(G2H6(36),RedSet_5(14),mass5set(:,15),  & 
G1H6(163),G1H6(164),G1H6(165),G1H6(166),G1H6(167),G1H6(168),6)
  call HG1shiftOLR(G1H6(164),16,6)
  call Hloop_QA_V(ntryL,G2H4(1),ex1(:),G2H2(9),m3h2x2(:,1),heltab2x4(:,:,1))
  call Hloop_QA_Z(ntryL,G2H4(2),ex1(:),G2H2(10),ngZu,m3h2x2(:,2),heltab2x4(:,:,2))
  call Hotf_5pt_reduction(G2H6(37),RedSet_5(15),mass5set(:,16),  & 
G1H6(169),G1H6(170),G1H6(171),G1H6(172),G1H6(173),G1H6(174),6)
  call HG1shiftOLR(G1H6(170),16,6)
  call Hotf_5pt_reduction(G2H6(38),RedSet_5(15),mass5set(:,17),  & 
G1H6(175),G1H6(176),G1H6(177),G1H6(178),G1H6(179),G1H6(180),6)
  call HG1shiftOLR(G1H6(176),16,6)
  call Hotf_5pt_reduction(G2H6(39),RedSet_5(15),mass5set(:,18),  & 
G1H6(181),G1H6(182),G1H6(183),G1H6(184),G1H6(185),G1H6(186),6)
  call HG1shiftOLR(G1H6(182),16,6)
  call Hotf_5pt_reduction(G2H6(40),RedSet_5(15),mass5set(:,19),  & 
G1H6(187),G1H6(188),G1H6(189),G1H6(190),G1H6(191),G1H6(192),6)
  call HG1shiftOLR(G1H6(188),16,6)
  call Hotf_5pt_reduction(G2H6(41),RedSet_5(16),mass5set(:,16),  & 
G1H6(193),G1H6(194),G1H6(195),G1H6(196),G1H6(197),G1H6(198),6)
  call HG1shiftOLR(G1H6(194),16,6)
  call Hotf_5pt_reduction(G2H6(42),RedSet_5(16),mass5set(:,18),  & 
G1H6(199),G1H6(200),G1H6(201),G1H6(202),G1H6(203),G1H6(204),6)
  call HG1shiftOLR(G1H6(200),16,6)
  call Hotf_5pt_reduction(G2H6(43),RedSet_5(16),mass5set(:,17),  & 
G1H6(205),G1H6(206),G1H6(207),G1H6(208),G1H6(209),G1H6(210),6)
  call HG1shiftOLR(G1H6(206),16,6)
  call Hotf_5pt_reduction(G2H6(44),RedSet_5(16),mass5set(:,19),  & 
G1H6(211),G1H6(212),G1H6(213),G1H6(214),G1H6(215),G1H6(216),6)
  call HG1shiftOLR(G1H6(212),16,6)
  call Hloop_SV_V(ntryL,G2H6(45),ex5(:),G2H2(11),m3h3x2(:,9),heltab2x6(:,:,9))
  call Hloop_SV_V(ntryL,G2H6(46),ex5(:),G2H2(12),m3h3x2(:,10),heltab2x6(:,:,10))
  call Hotf_5pt_reduction(G2H6(47),RedSet_5(16),mass5set(:,16),  & 
G1H6(217),G1H6(218),G1H6(219),G1H6(220),G1H6(221),G1H6(222),6)
  call HG1shiftOLR(G1H6(218),8,6)
  call Hotf_5pt_reduction(G2H6(48),RedSet_5(16),mass5set(:,18),  & 
G1H6(223),G1H6(224),G1H6(225),G1H6(226),G1H6(227),G1H6(228),6)
  call HG1shiftOLR(G1H6(224),8,6)
  call Hotf_5pt_reduction(G2H6(49),RedSet_5(16),mass5set(:,17),  & 
G1H6(229),G1H6(230),G1H6(231),G1H6(232),G1H6(233),G1H6(234),6)
  call HG1shiftOLR(G1H6(230),8,6)
  call Hotf_5pt_reduction(G2H6(50),RedSet_5(16),mass5set(:,19),  & 
G1H6(235),G1H6(236),G1H6(237),G1H6(238),G1H6(239),G1H6(240),6)
  call HG1shiftOLR(G1H6(236),8,6)
  call Hloop_VV_S(ntryL,G2H6(51),ex5(:),G2H2(13),m3h3x2(:,11),heltab2x6(:,:,11))
  call Hloop_VV_S(ntryL,G2H6(52),ex5(:),G2H2(14),m3h3x2(:,12),heltab2x6(:,:,12))
  call Hloop_VV_S(ntryL,G2H6(53),ex5(:),G2H2(15),m3h3x2(:,13),heltab2x6(:,:,13))
  call Hloop_VV_S(ntryL,G2H6(54),ex5(:),G2H2(16),m3h3x2(:,14),heltab2x6(:,:,14))
  call Hotf_5pt_reduction(G2H6(55),RedSet_5(14),mass5set(:,12),  & 
G1H6(241),G1H6(242),G1H6(243),G1H6(244),G1H6(245),G1H6(246),6)
  call HG1shiftOLR(G1H6(242),4,6)
  call Hotf_5pt_reduction(G2H6(56),RedSet_5(14),mass5set(:,12),  & 
G1H6(247),G1H6(248),G1H6(249),G1H6(250),G1H6(251),G1H6(252),6)
  call HG1shiftOLR(G1H6(248),4,6)
  call Hotf_5pt_reduction(G2H6(57),RedSet_5(14),mass5set(:,13),  & 
G1H6(253),G1H6(254),G1H6(255),G1H6(256),G1H6(257),G1H6(258),6)
  call HG1shiftOLR(G1H6(254),4,6)
  call Hotf_5pt_reduction(G2H6(58),RedSet_5(14),mass5set(:,13),  & 
G1H6(259),G1H6(260),G1H6(261),G1H6(262),G1H6(263),G1H6(264),6)
  call HG1shiftOLR(G1H6(260),4,6)
  call Hotf_5pt_reduction(G2H6(59),RedSet_5(14),mass5set(:,14),  & 
G1H6(265),G1H6(266),G1H6(267),G1H6(268),G1H6(269),G1H6(270),6)
  call HG1shiftOLR(G1H6(266),4,6)
  call Hotf_5pt_reduction(G2H6(60),RedSet_5(14),mass5set(:,15),  & 
G1H6(271),G1H6(272),G1H6(273),G1H6(274),G1H6(275),G1H6(276),6)
  call HG1shiftOLR(G1H6(272),4,6)
  call Hloop_AQ_V(ntryL,G2H4(3),ex4(:),G2H2(17),m3h2x2(:,3),heltab2x4(:,:,3))
  call Hloop_AQ_Z(ntryL,G2H4(4),ex4(:),G2H2(18),ngZd,m3h2x2(:,4),heltab2x4(:,:,4))
  call Hloop_AQ_V(ntryL,G2H4(5),ex2(:),G2H2(19),m3h2x2(:,5),heltab2x4(:,:,5))
  call Hloop_AQ_W(ntryL,G2H4(95),ex2(:),G2H2(20),m3h2x2(:,6),heltab2x4(:,:,6))
  call Hloop_AQ_Z(ntryL,G2H4(7),ex2(:),G2H2(21),ngZu,m3h2x2(:,7),heltab2x4(:,:,7))
  call Hloop_AQ_W(ntryL,G2H4(99),ex2(:),G2H2(22),m3h2x2(:,8),heltab2x4(:,:,8))
  call Hloop_QA_V(ntryL,G2H4(9),ex3(:),G2H2(23),m3h2x2(:,9),heltab2x4(:,:,9))
  call Hloop_QA_Z(ntryL,G2H4(10),ex3(:),G2H2(24),ngZu,m3h2x2(:,10),heltab2x4(:,:,10))
  call Hloop_AQ_V(ntryL,G2H4(11),ex4(:),G2H2(25),m3h2x2(:,11),heltab2x4(:,:,11))
  call Hloop_AQ_V(ntryL,G2H4(13),ex4(:),G2H2(26),m3h2x2(:,12),heltab2x4(:,:,12))
  call Hloop_AQ_Z(ntryL,G2H4(14),ex4(:),G2H2(27),ngZd,m3h2x2(:,13),heltab2x4(:,:,13))
  call Hloop_AQ_Z(ntryL,G2H4(16),ex4(:),G2H2(28),ngZd,m3h2x2(:,14),heltab2x4(:,:,14))
  call Hloop_AQ_V(ntryL,G2H4(17),ex4(:),G2H2(29),m3h2x2(:,15),heltab2x4(:,:,15))
  call Hloop_AQ_V(ntryL,G2H4(19),ex4(:),G2H2(30),m3h2x2(:,16),heltab2x4(:,:,16))
  call Hloop_AQ_Z(ntryL,G2H4(20),ex4(:),G2H2(31),ngZd,m3h2x2(:,17),heltab2x4(:,:,17))
  call Hloop_AQ_Z(ntryL,G2H4(22),ex4(:),G2H2(32),ngZd,m3h2x2(:,18),heltab2x4(:,:,18))
  call Hloop_QA_V(ntryL,G2H4(23),ex3(:),G2H2(33),m3h2x2(:,19),heltab2x4(:,:,19))
  call Hloop_QA_V(ntryL,G2H4(25),ex3(:),G2H2(34),m3h2x2(:,20),heltab2x4(:,:,20))
  call Hloop_QA_Z(ntryL,G2H4(26),ex3(:),G2H2(35),ngZu,m3h2x2(:,21),heltab2x4(:,:,21))
  call Hloop_QA_Z(ntryL,G2H4(28),ex3(:),G2H2(36),ngZu,m3h2x2(:,22),heltab2x4(:,:,22))
  call Hloop_QA_V(ntryL,G2H4(29),ex1(:),G2H2(37),m3h2x2(:,23),heltab2x4(:,:,23))
  call Hloop_QA_V(ntryL,G2H4(32),ex1(:),G2H2(38),m3h2x2(:,24),heltab2x4(:,:,24))
  call Hloop_QA_V(ntryL,G2H4(33),ex1(:),G2H2(39),m3h2x2(:,25),heltab2x4(:,:,25))
  call Hloop_QA_V(ntryL,G2H4(36),ex1(:),G2H2(40),m3h2x2(:,26),heltab2x4(:,:,26))
  call Hloop_QA_Z(ntryL,G2H4(37),ex1(:),G2H2(41),ngZu,m3h2x2(:,27),heltab2x4(:,:,27))
  call Hloop_QA_Z(ntryL,G2H4(40),ex1(:),G2H2(42),ngZu,m3h2x2(:,28),heltab2x4(:,:,28))
  call Hloop_QA_Z(ntryL,G2H4(41),ex1(:),G2H2(43),ngZu,m3h2x2(:,29),heltab2x4(:,:,29))
  call Hloop_QA_Z(ntryL,G2H4(44),ex1(:),G2H2(44),ngZu,m3h2x2(:,30),heltab2x4(:,:,30))
  call Hloop_QA_V(ntryL,G2H4(45),ex1(:),G2H2(45),m3h2x2(:,31),heltab2x4(:,:,31))
  call Hloop_QA_V(ntryL,G2H4(47),ex1(:),G2H2(46),m3h2x2(:,32),heltab2x4(:,:,32))
  call Hloop_QA_V(ntryL,G2H4(48),ex1(:),G2H2(47),m3h2x2(:,33),heltab2x4(:,:,33))
  call Hloop_QA_V(ntryL,G2H4(50),ex1(:),G2H2(48),m3h2x2(:,34),heltab2x4(:,:,34))
  call Hloop_QA_Z(ntryL,G2H4(51),ex1(:),G2H2(49),ngZu,m3h2x2(:,35),heltab2x4(:,:,35))
  call Hloop_QA_Z(ntryL,G2H4(53),ex1(:),G2H2(50),ngZu,m3h2x2(:,36),heltab2x4(:,:,36))
  call Hloop_QA_Z(ntryL,G2H4(54),ex1(:),G2H2(51),ngZu,m3h2x2(:,37),heltab2x4(:,:,37))
  call Hloop_QA_Z(ntryL,G2H4(56),ex1(:),G2H2(52),ngZu,m3h2x2(:,38),heltab2x4(:,:,38))
  call Hloop_AQ_W(ntryL,G2H4(57),ex2(:),G2H2(53),m3h2x2(:,39),heltab2x4(:,:,39))
  call Hloop_AQ_W(ntryL,G2H4(59),ex2(:),G2H2(54),m3h2x2(:,40),heltab2x4(:,:,40))
  call Hloop_AQ_W(ntryL,G2H4(60),ex2(:),G2H2(55),m3h2x2(:,41),heltab2x4(:,:,41))
  call Hloop_AQ_W(ntryL,G2H4(62),ex2(:),G2H2(56),m3h2x2(:,42),heltab2x4(:,:,42))
  call Hloop_AQ_V(ntryL,G2H4(63),ex4(:),G2H2(57),m3h2x2(:,43),heltab2x4(:,:,43))
  call Hloop_AQ_V(ntryL,G2H4(66),ex4(:),G2H2(58),m3h2x2(:,44),heltab2x4(:,:,44))
  call Hloop_AQ_Z(ntryL,G2H4(67),ex4(:),G2H2(59),ngZd,m3h2x2(:,45),heltab2x4(:,:,45))
  call Hloop_AQ_Z(ntryL,G2H4(70),ex4(:),G2H2(60),ngZd,m3h2x2(:,46),heltab2x4(:,:,46))
  call Hloop_AQ_V(ntryL,G2H4(71),ex4(:),G2H2(61),m3h2x2(:,47),heltab2x4(:,:,47))
  call Hloop_AQ_V(ntryL,G2H4(74),ex4(:),G2H2(62),m3h2x2(:,48),heltab2x4(:,:,48))
  call Hloop_AQ_Z(ntryL,G2H4(75),ex4(:),G2H2(63),ngZd,m3h2x2(:,49),heltab2x4(:,:,49))
  call Hloop_AQ_Z(ntryL,G2H4(78),ex4(:),G2H2(64),ngZd,m3h2x2(:,50),heltab2x4(:,:,50))
  call Hloop_AQ_V(ntryL,G2H4(79),ex2(:),G2H2(65),m3h2x2(:,51),heltab2x4(:,:,51))
  call Hloop_AQ_V(ntryL,G2H4(82),ex2(:),G2H2(66),m3h2x2(:,52),heltab2x4(:,:,52))
  call Hloop_AQ_V(ntryL,G2H4(83),ex2(:),G2H2(67),m3h2x2(:,53),heltab2x4(:,:,53))
  call Hloop_AQ_V(ntryL,G2H4(86),ex2(:),G2H2(68),m3h2x2(:,54),heltab2x4(:,:,54))
  call Hloop_AQ_Z(ntryL,G2H4(87),ex2(:),G2H2(69),ngZu,m3h2x2(:,55),heltab2x4(:,:,55))
  call Hloop_AQ_Z(ntryL,G2H4(90),ex2(:),G2H2(70),ngZu,m3h2x2(:,56),heltab2x4(:,:,56))
  call Hloop_AQ_Z(ntryL,G2H4(91),ex2(:),G2H2(71),ngZu,m3h2x2(:,57),heltab2x4(:,:,57))
  call Hloop_AQ_Z(ntryL,G2H4(94),ex2(:),G2H2(72),ngZu,m3h2x2(:,58),heltab2x4(:,:,58))
  call Hloop_AQ_W(ntryL,G2H4(98),ex2(:),G2H2(73),m3h2x2(:,59),heltab2x4(:,:,59))
  call Hloop_AQ_W(ntryL,G2H4(102),ex2(:),G2H2(74),m3h2x2(:,60),heltab2x4(:,:,60))
  call Hloop_QA_V(ntryL,G2H4(103),ex3(:),G2H2(75),m3h2x2(:,61),heltab2x4(:,:,61))
  call Hloop_QA_V(ntryL,G2H4(106),ex3(:),G2H2(76),m3h2x2(:,62),heltab2x4(:,:,62))
  call Hloop_QA_Z(ntryL,G2H4(107),ex3(:),G2H2(77),ngZu,m3h2x2(:,63),heltab2x4(:,:,63))
  call Hloop_QA_Z(ntryL,G2H4(110),ex3(:),G2H2(78),ngZu,m3h2x2(:,64),heltab2x4(:,:,64))
  call Hloop_QA_V(ntryL,G2H4(111),ex3(:),G2H2(79),m3h2x2(:,65),heltab2x4(:,:,65))
  call Hloop_QA_V(ntryL,G2H4(114),ex3(:),G2H2(80),m3h2x2(:,66),heltab2x4(:,:,66))
  call Hloop_QA_Z(ntryL,G2H4(115),ex3(:),G2H2(81),ngZu,m3h2x2(:,67),heltab2x4(:,:,67))
  call Hloop_QA_Z(ntryL,G2H4(118),ex3(:),G2H2(82),ngZu,m3h2x2(:,68),heltab2x4(:,:,68))
  call Hloop_WQ_A(ntryL,G1H6(1),ex2(:),G1H3(1),m3h2x3(:,1),heltab2x6(:,:,15))
  call Hloop_Q_A(ntryL,G1H3(1),47,nMB,G2H3(1),n2h3(1))
call HGT_OLR(G1H6(2),1,1,6)
call HGT_invQ_OLR(G1H6(2),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(2),-16,nMT,G2H6(1),n2h6(1))
  call Hloop_AW_Q(ntryL,G2H6(1),ex5(:),G2H2(83),m3h3x2(:,15),heltab2x6(:,:,16))
  call Hloop_WQ_A(ntryL,G1H6(6),ex2(:),G1H3(1),m3h2x3(:,2),heltab2x6(:,:,17))
  call Hloop_Q_A(ntryL,G1H3(1),47,nMB,G2H3(2),n2h3(2))
  call Hloop_WQ_A(ntryL,G1H6(7),ex2(:),G1H3(1),m3h2x3(:,3),heltab2x6(:,:,18))
  call Hloop_Q_A(ntryL,G1H3(1),47,nMB,G2H3(3),n2h3(3))
call HGT_OLR(G1H6(8),1,1,6)
call HGT_invQ_OLR(G1H6(8),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(8),-16,nMT,G2H6(2),n2h6(2))
  call Hloop_AW_Q(ntryL,G2H6(2),ex5(:),G2H2(84),m3h3x2(:,16),heltab2x6(:,:,19))
  call Hloop_WQ_A(ntryL,G1H6(12),ex2(:),G1H3(1),m3h2x3(:,4),heltab2x6(:,:,20))
  call Hloop_Q_A(ntryL,G1H3(1),47,nMB,G2H3(4),n2h3(4))
  call Hloop_VA_Q(ntryL,G1H6(13),ex3(:),G1H3(1),m3h2x3(:,5),heltab2x6(:,:,21))
  call Hloop_A_Q(ntryL,G1H3(1),47,nMT,G2H3(5),n2h3(5))
call HGT_OLR(G1H6(14),1,1,6)
call HGT_invQ_OLR(G1H6(14),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(14),-16,nMB,G2H6(3),n2h6(3))
  call Hloop_QW_A(ntryL,G2H6(3),ex5(:),G2H2(85),m3h3x2(:,17),heltab2x6(:,:,22))
  call Hloop_VA_Q(ntryL,G1H6(18),ex3(:),G1H3(1),m3h2x3(:,6),heltab2x6(:,:,23))
  call Hloop_A_Q(ntryL,G1H3(1),47,nMT,G2H3(6),n2h3(6))
  call Hloop_ZA_Q(ntryL,G1H6(19),ex3(:),G1H3(1),ngZu,m3h2x3(:,7),heltab2x6(:,:,24))
  call Hloop_A_Q(ntryL,G1H3(1),47,nMT,G2H3(7),n2h3(7))
call HGT_OLR(G1H6(20),1,1,6)
call HGT_invQ_OLR(G1H6(20),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(20),-16,nMB,G2H6(4),n2h6(4))
  call Hloop_QW_A(ntryL,G2H6(4),ex5(:),G2H2(86),m3h3x2(:,18),heltab2x6(:,:,25))
  call Hloop_ZA_Q(ntryL,G1H6(24),ex3(:),G1H3(1),ngZu,m3h2x3(:,8),heltab2x6(:,:,26))
  call Hloop_A_Q(ntryL,G1H3(1),47,nMT,G2H3(8),n2h3(8))
  call Hloop_UW_V(ntryL,G1H6(25),43,ex5(:),16,G2H2(87),m3h3x2(:,19),heltab2x6(:,:,27))
call HGT_OLR(G1H6(26),1,1,6)
call HGT_invQ_OLR(G1H6(26),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(26),-4,nMT,G2H6(5),n2h6(5))
  call Hloop_QA_V(ntryL,G2H6(5),ex3(:),G2H3(9),m3h2x3(:,9),heltab2x6(:,:,28))
  call Hloop_UW_V(ntryL,G1H6(30),43,ex5(:),16,G2H2(88),m3h3x2(:,20),heltab2x6(:,:,29))
  call Hloop_UW_V(ntryL,G1H6(31),43,ex5(:),16,G2H2(89),m3h3x2(:,21),heltab2x6(:,:,30))
call HGT_OLR(G1H6(32),1,1,6)
call HGT_invQ_OLR(G1H6(32),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(32),-4,nMT,G2H6(6),n2h6(6))
  call Hloop_QA_Z(ntryL,G2H6(6),ex3(:),G2H3(10),ngZu,m3h2x3(:,10),heltab2x6(:,:,31))
  call Hloop_UW_V(ntryL,G1H6(36),43,ex5(:),16,G2H2(90),m3h3x2(:,22),heltab2x6(:,:,32))
  call Hloop_UW_V(ntryL,G1H6(37),43,ex5(:),16,G2H2(91),m3h3x2(:,23),heltab2x6(:,:,33))
call HGT_OLR(G1H6(38),1,1,6)
call HGT_invQ_OLR(G1H6(38),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(38),-4,nMT,G2H6(7),n2h6(7))
  call Hloop_QA_V(ntryL,G2H6(7),ex3(:),G2H3(11),m3h2x3(:,11),heltab2x6(:,:,34))
  call Hloop_UW_V(ntryL,G1H6(42),43,ex5(:),16,G2H2(92),m3h3x2(:,24),heltab2x6(:,:,35))
  call Hloop_UW_V(ntryL,G1H6(43),43,ex5(:),16,G2H2(93),m3h3x2(:,25),heltab2x6(:,:,36))
call HGT_OLR(G1H6(44),1,1,6)
call HGT_invQ_OLR(G1H6(44),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(44),-4,nMT,G2H6(8),n2h6(8))
  call Hloop_QA_Z(ntryL,G2H6(8),ex3(:),G2H3(12),ngZu,m3h2x3(:,12),heltab2x6(:,:,37))
  call Hloop_UW_V(ntryL,G1H6(48),43,ex5(:),16,G2H2(94),m3h3x2(:,26),heltab2x6(:,:,38))
  call Hloop_UV_W(ntryL,G1H6(49),43,ex5(:),16,G2H2(95),m3h3x2(:,27),heltab2x6(:,:,39))
call HGT_OLR(G1H6(50),1,1,6)
call HGT_invQ_OLR(G1H6(50),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(50),-4,nMB,G2H6(9),n2h6(9))
  call Hloop_QA_W(ntryL,G2H6(9),ex3(:),G2H3(13),m3h2x3(:,13),heltab2x6(:,:,40))
  call Hloop_UV_W(ntryL,G1H6(54),43,ex5(:),16,G2H2(96),m3h3x2(:,28),heltab2x6(:,:,41))
  call Hloop_UV_W(ntryL,G1H6(55),43,ex5(:),16,G2H2(97),m3h3x2(:,29),heltab2x6(:,:,42))
call HGT_OLR(G1H6(56),1,1,6)
call HGT_invQ_OLR(G1H6(56),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(56),-4,nMB,G2H6(10),n2h6(10))
  call Hloop_QA_W(ntryL,G2H6(10),ex3(:),G2H3(14),m3h2x3(:,14),heltab2x6(:,:,43))
  call Hloop_UV_W(ntryL,G1H6(60),43,ex5(:),16,G2H2(98),m3h3x2(:,30),heltab2x6(:,:,44))
  call Hloop_VA_Q(ntryL,G1H6(61),ex1(:),G1H3(1),m3h2x3(:,15),heltab2x6(:,:,45))
  call Hloop_A_Q(ntryL,G1H3(1),47,0,G2H3(15),n2h3(9))
call HGT_OLR(G1H6(62),1,1,6)
call HGT_invQ_OLR(G1H6(62),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(62),-16,0,G2H6(11),n2h6(11))
  call Hloop_QW_A(ntryL,G2H6(11),ex5(:),G2H2(99),m3h3x2(:,31),heltab2x6(:,:,46))
  call Hloop_VA_Q(ntryL,G1H6(66),ex1(:),G1H3(1),m3h2x3(:,16),heltab2x6(:,:,47))
  call Hloop_A_Q(ntryL,G1H3(1),47,0,G2H3(16),n2h3(10))
  call Hloop_VA_Q(ntryL,G1H6(67),ex1(:),G1H3(1),m3h2x3(:,17),heltab2x6(:,:,48))
  call Hloop_A_Q(ntryL,G1H3(1),47,0,G2H3(17),n2h3(11))
call HGT_OLR(G1H6(68),1,1,6)
call HGT_invQ_OLR(G1H6(68),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(68),-16,0,G2H6(12),n2h6(12))
  call Hloop_QW_A(ntryL,G2H6(12),ex5(:),G2H2(100),m3h3x2(:,32),heltab2x6(:,:,49))
  call Hloop_VA_Q(ntryL,G1H6(72),ex1(:),G1H3(1),m3h2x3(:,18),heltab2x6(:,:,50))
  call Hloop_A_Q(ntryL,G1H3(1),47,0,G2H3(18),n2h3(12))
  call Hloop_ZA_Q(ntryL,G1H6(73),ex1(:),G1H3(1),ngZu,m3h2x3(:,19),heltab2x6(:,:,51))
  call Hloop_A_Q(ntryL,G1H3(1),47,0,G2H3(19),n2h3(13))
call HGT_OLR(G1H6(74),1,1,6)
call HGT_invQ_OLR(G1H6(74),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(74),-16,0,G2H6(13),n2h6(13))
  call Hloop_QW_A(ntryL,G2H6(13),ex5(:),G2H2(101),m3h3x2(:,33),heltab2x6(:,:,52))
  call Hloop_ZA_Q(ntryL,G1H6(78),ex1(:),G1H3(1),ngZu,m3h2x3(:,20),heltab2x6(:,:,53))
  call Hloop_A_Q(ntryL,G1H3(1),47,0,G2H3(20),n2h3(14))
  call Hloop_ZA_Q(ntryL,G1H6(79),ex1(:),G1H3(1),ngZu,m3h2x3(:,21),heltab2x6(:,:,54))
  call Hloop_A_Q(ntryL,G1H3(1),47,0,G2H3(21),n2h3(15))
call HGT_OLR(G1H6(80),1,1,6)
call HGT_invQ_OLR(G1H6(80),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(80),-16,0,G2H6(14),n2h6(14))
  call Hloop_QW_A(ntryL,G2H6(14),ex5(:),G2H2(102),m3h3x2(:,34),heltab2x6(:,:,55))
  call Hloop_ZA_Q(ntryL,G1H6(84),ex1(:),G1H3(1),ngZu,m3h2x3(:,22),heltab2x6(:,:,56))
  call Hloop_A_Q(ntryL,G1H3(1),47,0,G2H3(22),n2h3(16))
  call Hloop_VQ_A(ntryL,G1H6(85),ex4(:),G1H3(1),m3h2x3(:,23),heltab2x6(:,:,57))
  call Hloop_Q_A(ntryL,G1H3(1),47,0,G2H3(23),n2h3(17))
call HGT_OLR(G1H6(86),1,1,6)
call HGT_invQ_OLR(G1H6(86),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(86),-16,0,G2H6(15),n2h6(15))
  call Hloop_AW_Q(ntryL,G2H6(15),ex5(:),G2H2(103),m3h3x2(:,35),heltab2x6(:,:,58))
  call Hloop_VQ_A(ntryL,G1H6(90),ex4(:),G1H3(1),m3h2x3(:,24),heltab2x6(:,:,59))
  call Hloop_Q_A(ntryL,G1H3(1),47,0,G2H3(24),n2h3(18))
  call Hloop_ZQ_A(ntryL,G1H6(91),ex4(:),G1H3(1),ngZd,m3h2x3(:,25),heltab2x6(:,:,60))
  call Hloop_Q_A(ntryL,G1H3(1),47,0,G2H3(25),n2h3(19))
call HGT_OLR(G1H6(92),1,1,6)
call HGT_invQ_OLR(G1H6(92),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(92),-16,0,G2H6(16),n2h6(16))
  call Hloop_AW_Q(ntryL,G2H6(16),ex5(:),G2H2(104),m3h3x2(:,36),heltab2x6(:,:,61))
  call Hloop_ZQ_A(ntryL,G1H6(96),ex4(:),G1H3(1),ngZd,m3h2x3(:,26),heltab2x6(:,:,62))
  call Hloop_Q_A(ntryL,G1H3(1),47,0,G2H3(26),n2h3(20))
  call Hloop_VQ_A(ntryL,G1H6(97),ex4(:),G1H3(1),m3h2x3(:,27),heltab2x6(:,:,63))
  call Hloop_Q_A(ntryL,G1H3(1),47,0,G2H3(27),n2h3(21))
call HGT_OLR(G1H6(98),1,1,6)
call HGT_invQ_OLR(G1H6(98),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(98),-16,0,G2H6(17),n2h6(17))
  call Hloop_AW_Q(ntryL,G2H6(17),ex5(:),G2H2(105),m3h3x2(:,37),heltab2x6(:,:,64))
  call Hloop_VQ_A(ntryL,G1H6(102),ex4(:),G1H3(1),m3h2x3(:,28),heltab2x6(:,:,65))
  call Hloop_Q_A(ntryL,G1H3(1),47,0,G2H3(28),n2h3(22))
  call Hloop_ZQ_A(ntryL,G1H6(103),ex4(:),G1H3(1),ngZd,m3h2x3(:,29),heltab2x6(:,:,66))
  call Hloop_Q_A(ntryL,G1H3(1),47,0,G2H3(29),n2h3(23))
call HGT_OLR(G1H6(104),1,1,6)
call HGT_invQ_OLR(G1H6(104),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(104),-16,0,G2H6(18),n2h6(18))
  call Hloop_AW_Q(ntryL,G2H6(18),ex5(:),G2H2(106),m3h3x2(:,38),heltab2x6(:,:,67))
  call Hloop_ZQ_A(ntryL,G1H6(108),ex4(:),G1H3(1),ngZd,m3h2x3(:,30),heltab2x6(:,:,68))
  call Hloop_Q_A(ntryL,G1H3(1),47,0,G2H3(30),n2h3(24))
  call Hloop_UV_W(ntryL,G1H6(109),39,ex5(:),16,G2H2(107),m3h3x2(:,39),heltab2x6(:,:,69))
call HGT_OLR(G1H6(110),1,1,6)
call HGT_invQ_OLR(G1H6(110),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(110),-8,0,G2H6(19),n2h6(19))
  call Hloop_AQ_W(ntryL,G2H6(19),ex4(:),G2H3(31),m3h2x3(:,31),heltab2x6(:,:,70))
  call Hloop_UV_W(ntryL,G1H6(114),39,ex5(:),16,G2H2(108),m3h3x2(:,40),heltab2x6(:,:,71))
  call Hloop_UV_W(ntryL,G1H6(115),39,ex5(:),16,G2H2(109),m3h3x2(:,41),heltab2x6(:,:,72))
call HGT_OLR(G1H6(116),1,1,6)
call HGT_invQ_OLR(G1H6(116),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(116),-8,0,G2H6(20),n2h6(20))
  call Hloop_AQ_W(ntryL,G2H6(20),ex4(:),G2H3(32),m3h2x3(:,32),heltab2x6(:,:,73))
  call Hloop_UV_W(ntryL,G1H6(120),39,ex5(:),16,G2H2(110),m3h3x2(:,42),heltab2x6(:,:,74))
  call Hloop_UV_W(ntryL,G1H6(121),39,ex5(:),16,G2H2(111),m3h3x2(:,43),heltab2x6(:,:,75))
call HGT_OLR(G1H6(122),1,1,6)
call HGT_invQ_OLR(G1H6(122),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(122),-8,0,G2H6(21),n2h6(21))
  call Hloop_AQ_W(ntryL,G2H6(21),ex4(:),G2H3(33),m3h2x3(:,33),heltab2x6(:,:,76))
  call Hloop_UV_W(ntryL,G1H6(126),39,ex5(:),16,G2H2(112),m3h3x2(:,44),heltab2x6(:,:,77))
  call Hloop_UV_W(ntryL,G1H6(127),39,ex5(:),16,G2H2(113),m3h3x2(:,45),heltab2x6(:,:,78))
call HGT_OLR(G1H6(128),1,1,6)
call HGT_invQ_OLR(G1H6(128),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(128),-8,0,G2H6(22),n2h6(22))
  call Hloop_AQ_W(ntryL,G2H6(22),ex4(:),G2H3(34),m3h2x3(:,34),heltab2x6(:,:,79))
  call Hloop_UV_W(ntryL,G1H6(132),39,ex5(:),16,G2H2(114),m3h3x2(:,46),heltab2x6(:,:,80))
  call Hloop_UW_V(ntryL,G1H6(133),39,ex5(:),16,G2H2(115),m3h3x2(:,47),heltab2x6(:,:,81))
call HGT_OLR(G1H6(134),1,1,6)
call HGT_invQ_OLR(G1H6(134),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(134),-8,0,G2H6(23),n2h6(23))
  call Hloop_AQ_V(ntryL,G2H6(23),ex4(:),G2H3(35),m3h2x3(:,35),heltab2x6(:,:,82))
  call Hloop_UW_V(ntryL,G1H6(138),39,ex5(:),16,G2H2(116),m3h3x2(:,48),heltab2x6(:,:,83))
  call Hloop_UW_V(ntryL,G1H6(139),39,ex5(:),16,G2H2(117),m3h3x2(:,49),heltab2x6(:,:,84))
call HGT_OLR(G1H6(140),1,1,6)
call HGT_invQ_OLR(G1H6(140),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(140),-8,0,G2H6(24),n2h6(24))
  call Hloop_AQ_Z(ntryL,G2H6(24),ex4(:),G2H3(36),ngZd,m3h2x3(:,36),heltab2x6(:,:,85))
  call Hloop_UW_V(ntryL,G1H6(144),39,ex5(:),16,G2H2(118),m3h3x2(:,50),heltab2x6(:,:,86))
  call Hloop_WQ_A(ntryL,G1H6(145),ex2(:),G1H3(1),m3h2x3(:,37),heltab2x6(:,:,87))
  call Hloop_Q_A(ntryL,G1H3(1),47,nMB,G2H3(37),n2h3(25))
call HGT_OLR(G1H6(146),1,1,6)
call HGT_invQ_OLR(G1H6(146),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(146),-16,nMT,G2H6(25),n2h6(25))
  call Hloop_AW_Q(ntryL,G2H6(25),ex5(:),G2H2(119),m3h3x2(:,51),heltab2x6(:,:,88))
  call Hloop_WQ_A(ntryL,G1H6(150),ex2(:),G1H3(1),m3h2x3(:,38),heltab2x6(:,:,89))
  call Hloop_Q_A(ntryL,G1H3(1),47,nMB,G2H3(38),n2h3(26))
  call Hloop_WQ_A(ntryL,G1H6(151),ex2(:),G1H3(1),m3h2x3(:,39),heltab2x6(:,:,90))
  call Hloop_Q_A(ntryL,G1H3(1),47,nMB,G2H3(39),n2h3(27))
call HGT_OLR(G1H6(152),1,1,6)
call HGT_invQ_OLR(G1H6(152),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(152),-16,nMT,G2H6(26),n2h6(26))
  call Hloop_AW_Q(ntryL,G2H6(26),ex5(:),G2H2(120),m3h3x2(:,52),heltab2x6(:,:,91))
  call Hloop_WQ_A(ntryL,G1H6(156),ex2(:),G1H3(1),m3h2x3(:,40),heltab2x6(:,:,92))
  call Hloop_Q_A(ntryL,G1H3(1),47,nMB,G2H3(40),n2h3(28))
  call Hloop_VA_Q(ntryL,G1H6(157),ex3(:),G1H3(1),m3h2x3(:,41),heltab2x6(:,:,93))
  call Hloop_A_Q(ntryL,G1H3(1),47,nMT,G2H3(41),n2h3(29))
call HGT_OLR(G1H6(158),1,1,6)
call HGT_invQ_OLR(G1H6(158),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(158),-16,nMB,G2H6(27),n2h6(27))
  call Hloop_QW_A(ntryL,G2H6(27),ex5(:),G2H2(121),m3h3x2(:,53),heltab2x6(:,:,94))
  call Hloop_VA_Q(ntryL,G1H6(162),ex3(:),G1H3(1),m3h2x3(:,42),heltab2x6(:,:,95))
  call Hloop_A_Q(ntryL,G1H3(1),47,nMT,G2H3(42),n2h3(30))
  call Hloop_ZA_Q(ntryL,G1H6(163),ex3(:),G1H3(1),ngZu,m3h2x3(:,43),heltab2x6(:,:,96))
  call Hloop_A_Q(ntryL,G1H3(1),47,nMT,G2H3(43),n2h3(31))
call HGT_OLR(G1H6(164),1,1,6)
call HGT_invQ_OLR(G1H6(164),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(164),-16,nMB,G2H6(28),n2h6(28))
  call Hloop_QW_A(ntryL,G2H6(28),ex5(:),G2H2(122),m3h3x2(:,54),heltab2x6(:,:,97))
  call Hloop_ZA_Q(ntryL,G1H6(168),ex3(:),G1H3(1),ngZu,m3h2x3(:,44),heltab2x6(:,:,98))
  call Hloop_A_Q(ntryL,G1H3(1),47,nMT,G2H3(44),n2h3(32))
  call Hloop_VA_Q(ntryL,G1H6(169),ex1(:),G1H3(1),m3h2x3(:,45),heltab2x6(:,:,99))
  call Hloop_A_Q(ntryL,G1H3(1),47,0,G2H3(45),n2h3(33))
call HGT_OLR(G1H6(170),1,1,6)
call HGT_invQ_OLR(G1H6(170),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(170),-16,0,G2H6(29),n2h6(29))
  call Hloop_QW_A(ntryL,G2H6(29),ex5(:),G2H2(123),m3h3x2(:,55),heltab2x6(:,:,100))
  call Hloop_VA_Q(ntryL,G1H6(174),ex1(:),G1H3(1),m3h2x3(:,46),heltab2x6(:,:,101))
  call Hloop_A_Q(ntryL,G1H3(1),47,0,G2H3(46),n2h3(34))
  call Hloop_VA_Q(ntryL,G1H6(175),ex1(:),G1H3(1),m3h2x3(:,47),heltab2x6(:,:,102))
  call Hloop_A_Q(ntryL,G1H3(1),47,0,G2H3(47),n2h3(35))
call HGT_OLR(G1H6(176),1,1,6)
call HGT_invQ_OLR(G1H6(176),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(176),-16,0,G2H6(30),n2h6(30))
  call Hloop_QW_A(ntryL,G2H6(30),ex5(:),G2H2(124),m3h3x2(:,56),heltab2x6(:,:,103))
  call Hloop_VA_Q(ntryL,G1H6(180),ex1(:),G1H3(1),m3h2x3(:,48),heltab2x6(:,:,104))
  call Hloop_A_Q(ntryL,G1H3(1),47,0,G2H3(48),n2h3(36))
  call Hloop_ZA_Q(ntryL,G1H6(181),ex1(:),G1H3(1),ngZu,m3h2x3(:,49),heltab2x6(:,:,105))
  call Hloop_A_Q(ntryL,G1H3(1),47,0,G2H3(49),n2h3(37))
call HGT_OLR(G1H6(182),1,1,6)
call HGT_invQ_OLR(G1H6(182),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(182),-16,0,G2H6(31),n2h6(31))
  call Hloop_QW_A(ntryL,G2H6(31),ex5(:),G2H2(125),m3h3x2(:,57),heltab2x6(:,:,106))
  call Hloop_ZA_Q(ntryL,G1H6(186),ex1(:),G1H3(1),ngZu,m3h2x3(:,50),heltab2x6(:,:,107))
  call Hloop_A_Q(ntryL,G1H3(1),47,0,G2H3(50),n2h3(38))
  call Hloop_ZA_Q(ntryL,G1H6(187),ex1(:),G1H3(1),ngZu,m3h2x3(:,51),heltab2x6(:,:,108))
  call Hloop_A_Q(ntryL,G1H3(1),47,0,G2H3(51),n2h3(39))
call HGT_OLR(G1H6(188),1,1,6)
call HGT_invQ_OLR(G1H6(188),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(188),-16,0,G2H6(32),n2h6(32))
  call Hloop_QW_A(ntryL,G2H6(32),ex5(:),G2H2(126),m3h3x2(:,58),heltab2x6(:,:,109))
  call Hloop_ZA_Q(ntryL,G1H6(192),ex1(:),G1H3(1),ngZu,m3h2x3(:,52),heltab2x6(:,:,110))
  call Hloop_A_Q(ntryL,G1H3(1),47,0,G2H3(52),n2h3(40))
  call Hloop_VQ_A(ntryL,G1H6(193),ex4(:),G1H3(1),m3h2x3(:,53),heltab2x6(:,:,111))
  call Hloop_Q_A(ntryL,G1H3(1),47,0,G2H3(53),n2h3(41))
call HGT_OLR(G1H6(194),1,1,6)
call HGT_invQ_OLR(G1H6(194),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(194),-16,0,G2H6(33),n2h6(33))
  call Hloop_AW_Q(ntryL,G2H6(33),ex5(:),G2H2(127),m3h3x2(:,59),heltab2x6(:,:,112))
  call Hloop_VQ_A(ntryL,G1H6(198),ex4(:),G1H3(1),m3h2x3(:,54),heltab2x6(:,:,113))
  call Hloop_Q_A(ntryL,G1H3(1),47,0,G2H3(54),n2h3(42))
  call Hloop_ZQ_A(ntryL,G1H6(199),ex4(:),G1H3(1),ngZd,m3h2x3(:,55),heltab2x6(:,:,114))
  call Hloop_Q_A(ntryL,G1H3(1),47,0,G2H3(55),n2h3(43))
call HGT_OLR(G1H6(200),1,1,6)
call HGT_invQ_OLR(G1H6(200),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(200),-16,0,G2H6(34),n2h6(34))
  call Hloop_AW_Q(ntryL,G2H6(34),ex5(:),G2H2(128),m3h3x2(:,60),heltab2x6(:,:,115))
  call Hloop_ZQ_A(ntryL,G1H6(204),ex4(:),G1H3(1),ngZd,m3h2x3(:,56),heltab2x6(:,:,116))
  call Hloop_Q_A(ntryL,G1H3(1),47,0,G2H3(56),n2h3(44))
  call Hloop_VQ_A(ntryL,G1H6(205),ex4(:),G1H3(1),m3h2x3(:,57),heltab2x6(:,:,117))
  call Hloop_Q_A(ntryL,G1H3(1),47,0,G2H3(57),n2h3(45))
call HGT_OLR(G1H6(206),1,1,6)
call HGT_invQ_OLR(G1H6(206),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(206),-16,0,G2H6(35),n2h6(35))
  call Hloop_AW_Q(ntryL,G2H6(35),ex5(:),G2H2(129),m3h3x2(:,61),heltab2x6(:,:,118))
  call Hloop_VQ_A(ntryL,G1H6(210),ex4(:),G1H3(1),m3h2x3(:,58),heltab2x6(:,:,119))
  call Hloop_Q_A(ntryL,G1H3(1),47,0,G2H3(58),n2h3(46))
  call Hloop_ZQ_A(ntryL,G1H6(211),ex4(:),G1H3(1),ngZd,m3h2x3(:,59),heltab2x6(:,:,120))
  call Hloop_Q_A(ntryL,G1H3(1),47,0,G2H3(59),n2h3(47))
call HGT_OLR(G1H6(212),1,1,6)
call HGT_invQ_OLR(G1H6(212),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(212),-16,0,G2H6(36),n2h6(36))
  call Hloop_AW_Q(ntryL,G2H6(36),ex5(:),G2H2(130),m3h3x2(:,62),heltab2x6(:,:,121))
  call Hloop_ZQ_A(ntryL,G1H6(216),ex4(:),G1H3(1),ngZd,m3h2x3(:,60),heltab2x6(:,:,122))
  call Hloop_Q_A(ntryL,G1H3(1),47,0,G2H3(60),n2h3(48))
  call Hloop_UV_W(ntryL,G1H6(217),39,ex5(:),16,G2H2(131),m3h3x2(:,63),heltab2x6(:,:,123))
call HGT_OLR(G1H6(218),1,1,6)
call HGT_invQ_OLR(G1H6(218),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(218),-8,0,G2H6(37),n2h6(37))
  call Hloop_AQ_W(ntryL,G2H6(37),ex4(:),G2H3(61),m3h2x3(:,61),heltab2x6(:,:,124))
  call Hloop_UV_W(ntryL,G1H6(222),39,ex5(:),16,G2H2(132),m3h3x2(:,64),heltab2x6(:,:,125))
  call Hloop_UV_W(ntryL,G1H6(223),39,ex5(:),16,G2H2(133),m3h3x2(:,65),heltab2x6(:,:,126))
call HGT_OLR(G1H6(224),1,1,6)
call HGT_invQ_OLR(G1H6(224),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(224),-8,0,G2H6(38),n2h6(38))
  call Hloop_AQ_W(ntryL,G2H6(38),ex4(:),G2H3(62),m3h2x3(:,62),heltab2x6(:,:,127))
  call Hloop_UV_W(ntryL,G1H6(228),39,ex5(:),16,G2H2(134),m3h3x2(:,66),heltab2x6(:,:,128))
  call Hloop_UV_W(ntryL,G1H6(229),39,ex5(:),16,G2H2(135),m3h3x2(:,67),heltab2x6(:,:,129))
call HGT_OLR(G1H6(230),1,1,6)
call HGT_invQ_OLR(G1H6(230),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(230),-8,0,G2H6(39),n2h6(39))
  call Hloop_AQ_W(ntryL,G2H6(39),ex4(:),G2H3(63),m3h2x3(:,63),heltab2x6(:,:,130))
  call Hloop_UV_W(ntryL,G1H6(234),39,ex5(:),16,G2H2(136),m3h3x2(:,68),heltab2x6(:,:,131))
  call Hloop_UV_W(ntryL,G1H6(235),39,ex5(:),16,G2H2(137),m3h3x2(:,69),heltab2x6(:,:,132))
call HGT_OLR(G1H6(236),1,1,6)
call HGT_invQ_OLR(G1H6(236),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(236),-8,0,G2H6(40),n2h6(40))
  call Hloop_AQ_W(ntryL,G2H6(40),ex4(:),G2H3(64),m3h2x3(:,64),heltab2x6(:,:,133))
  call Hloop_UV_W(ntryL,G1H6(240),39,ex5(:),16,G2H2(138),m3h3x2(:,70),heltab2x6(:,:,134))
  call Hloop_UW_V(ntryL,G1H6(241),43,ex5(:),16,G2H2(139),m3h3x2(:,71),heltab2x6(:,:,135))
call HGT_OLR(G1H6(242),1,1,6)
call HGT_invQ_OLR(G1H6(242),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(242),-4,nMT,G2H6(41),n2h6(41))
  call Hloop_QA_V(ntryL,G2H6(41),ex3(:),G2H3(65),m3h2x3(:,65),heltab2x6(:,:,136))
  call Hloop_UW_V(ntryL,G1H6(246),43,ex5(:),16,G2H2(140),m3h3x2(:,72),heltab2x6(:,:,137))
  call Hloop_UW_V(ntryL,G1H6(247),43,ex5(:),16,G2H2(141),m3h3x2(:,73),heltab2x6(:,:,138))
call HGT_OLR(G1H6(248),1,1,6)
call HGT_invQ_OLR(G1H6(248),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(248),-4,nMT,G2H6(42),n2h6(42))
  call Hloop_QA_Z(ntryL,G2H6(42),ex3(:),G2H3(66),ngZu,m3h2x3(:,66),heltab2x6(:,:,139))
  call Hloop_UW_V(ntryL,G1H6(252),43,ex5(:),16,G2H2(142),m3h3x2(:,74),heltab2x6(:,:,140))
  call Hloop_UW_V(ntryL,G1H6(253),43,ex5(:),16,G2H2(143),m3h3x2(:,75),heltab2x6(:,:,141))
call HGT_OLR(G1H6(254),1,1,6)
call HGT_invQ_OLR(G1H6(254),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(254),-4,nMT,G2H6(43),n2h6(43))
  call Hloop_QA_V(ntryL,G2H6(43),ex3(:),G2H3(67),m3h2x3(:,67),heltab2x6(:,:,142))
  call Hloop_UW_V(ntryL,G1H6(258),43,ex5(:),16,G2H2(144),m3h3x2(:,76),heltab2x6(:,:,143))
  call Hloop_UW_V(ntryL,G1H6(259),43,ex5(:),16,G2H2(145),m3h3x2(:,77),heltab2x6(:,:,144))
call HGT_OLR(G1H6(260),1,1,6)
call HGT_invQ_OLR(G1H6(260),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(260),-4,nMT,G2H6(44),n2h6(44))
  call Hloop_QA_Z(ntryL,G2H6(44),ex3(:),G2H3(68),ngZu,m3h2x3(:,68),heltab2x6(:,:,145))
  call Hloop_UW_V(ntryL,G1H6(264),43,ex5(:),16,G2H2(146),m3h3x2(:,78),heltab2x6(:,:,146))
  call Hloop_UV_W(ntryL,G1H6(265),43,ex5(:),16,G2H2(147),m3h3x2(:,79),heltab2x6(:,:,147))
call HGT_OLR(G1H6(266),1,1,6)
call HGT_invQ_OLR(G1H6(266),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(266),-4,nMB,G2H6(45),n2h6(45))
  call Hloop_QA_W(ntryL,G2H6(45),ex3(:),G2H3(69),m3h2x3(:,69),heltab2x6(:,:,148))
  call Hloop_UV_W(ntryL,G1H6(270),43,ex5(:),16,G2H2(148),m3h3x2(:,80),heltab2x6(:,:,149))
  call Hloop_UV_W(ntryL,G1H6(271),43,ex5(:),16,G2H2(149),m3h3x2(:,81),heltab2x6(:,:,150))
call HGT_OLR(G1H6(272),1,1,6)
call HGT_invQ_OLR(G1H6(272),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(272),-4,nMB,G2H6(46),n2h6(46))
  call Hloop_QA_W(ntryL,G2H6(46),ex3(:),G2H3(70),m3h2x3(:,70),heltab2x6(:,:,151))
  call Hloop_UV_W(ntryL,G1H6(276),43,ex5(:),16,G2H2(150),m3h3x2(:,82),heltab2x6(:,:,152))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(115),[G2H2(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(117),[G2H2(8)])
  call Hotf_5pt_reduction(G2H2(1),RedSet_5(10),mass5set(:,12),  & 
G1H2(1),G1H2(2),G1H2(3),G1H2(4),G1H2(5),G1H2(6),2)
  call HG1shiftOLR(G1H2(2),4,2)
  call Hotf_5pt_reduction(G2H2(2),RedSet_5(10),mass5set(:,14),  & 
G1H2(7),G1H2(8),G1H2(9),G1H2(10),G1H2(11),G1H2(12),2)
  call HG1shiftOLR(G1H2(8),4,2)
  call Hotf_5pt_reduction(G2H2(3),RedSet_5(10),mass5set(:,13),  & 
G1H2(13),G1H2(14),G1H2(15),G1H2(16),G1H2(17),G1H2(18),2)
  call HG1shiftOLR(G1H2(14),4,2)
  call Hotf_5pt_reduction(G2H2(4),RedSet_5(10),mass5set(:,15),  & 
G1H2(19),G1H2(20),G1H2(21),G1H2(22),G1H2(23),G1H2(24),2)
  call HG1shiftOLR(G1H2(20),4,2)
  call Hotf_5pt_reduction(G2H2(5),RedSet_5(12),mass5set(:,21),  & 
G1H2(25),G1H2(26),G1H2(27),G1H2(28),G1H2(29),G1H2(30),2)
  call HG1shiftOLR(G1H2(26),8,2)
  call Hotf_5pt_reduction(G2H2(115),RedSet_5(12),mass5set(:,20),  & 
G1H2(31),G1H2(32),G1H2(33),G1H2(34),G1H2(35),G1H2(36),2)
  call HG1shiftOLR(G1H2(32),8,2)
  call Hotf_5pt_reduction(G2H2(7),RedSet_5(12),mass5set(:,22),  & 
G1H2(37),G1H2(38),G1H2(39),G1H2(40),G1H2(41),G1H2(42),2)
  call HG1shiftOLR(G1H2(38),8,2)
  call Hotf_5pt_reduction(G2H2(117),RedSet_5(12),mass5set(:,20),  & 
G1H2(43),G1H2(44),G1H2(45),G1H2(46),G1H2(47),G1H2(48),2)
  call HG1shiftOLR(G1H2(44),8,2)
  call Hotf_5pt_reduction(G2H2(9),RedSet_5(3),mass5set(:,23),  & 
G1H2(49),G1H2(50),G1H2(51),G1H2(52),G1H2(53),G1H2(54),2)
  call HG1shiftOLR(G1H2(50),4,2)
  call Hotf_5pt_reduction(G2H2(10),RedSet_5(3),mass5set(:,23),  & 
G1H2(55),G1H2(56),G1H2(57),G1H2(58),G1H2(59),G1H2(60),2)
  call HG1shiftOLR(G1H2(56),4,2)
  call Hotf_5pt_reduction(G2H2(11),RedSet_5(16),mass5set(:,21),  & 
G1H2(61),G1H2(62),G1H2(63),G1H2(64),G1H2(65),G1H2(66),2)
  call HG1shiftOLR(G1H2(62),8,2)
  call Hotf_5pt_reduction(G2H2(12),RedSet_5(16),mass5set(:,22),  & 
G1H2(67),G1H2(68),G1H2(69),G1H2(70),G1H2(71),G1H2(72),2)
  call HG1shiftOLR(G1H2(68),8,2)
  call Hotf_5pt_reduction(G2H2(13),RedSet_5(14),mass5set(:,12),  & 
G1H2(73),G1H2(74),G1H2(75),G1H2(76),G1H2(77),G1H2(78),2)
  call HG1shiftOLR(G1H2(74),4,2)
  call Hotf_5pt_reduction(G2H2(14),RedSet_5(14),mass5set(:,14),  & 
G1H2(79),G1H2(80),G1H2(81),G1H2(82),G1H2(83),G1H2(84),2)
  call HG1shiftOLR(G1H2(80),4,2)
  call Hotf_5pt_reduction(G2H2(15),RedSet_5(14),mass5set(:,13),  & 
G1H2(85),G1H2(86),G1H2(87),G1H2(88),G1H2(89),G1H2(90),2)
  call HG1shiftOLR(G1H2(86),4,2)
  call Hotf_5pt_reduction(G2H2(16),RedSet_5(14),mass5set(:,15),  & 
G1H2(91),G1H2(92),G1H2(93),G1H2(94),G1H2(95),G1H2(96),2)
  call HG1shiftOLR(G1H2(92),4,2)
  call Hotf_5pt_reduction(G2H2(17),RedSet_5(6),mass5set(:,23),  & 
G1H2(97),G1H2(98),G1H2(99),G1H2(100),G1H2(101),G1H2(102),2)
  call HG1shiftOLR(G1H2(98),4,2)
  call Hotf_5pt_reduction(G2H2(18),RedSet_5(6),mass5set(:,23),  & 
G1H2(103),G1H2(104),G1H2(105),G1H2(106),G1H2(107),G1H2(108),2)
  call HG1shiftOLR(G1H2(104),4,2)
  call Hotf_5pt_reduction(G2H2(19),RedSet_5(7),mass5set(:,24),  & 
G1H2(109),G1H2(110),G1H2(111),G1H2(112),G1H2(113),G1H2(114),2)
  call HG1shiftOLR(G1H2(110),8,2)
  call Hotf_5pt_reduction(G2H2(20),RedSet_5(7),mass5set(:,10),  & 
G1H2(115),G1H2(116),G1H2(117),G1H2(118),G1H2(119),G1H2(120),2)
  call HG1shiftOLR(G1H2(116),8,2)
  call Hotf_5pt_reduction(G2H2(21),RedSet_5(7),mass5set(:,24),  & 
G1H2(121),G1H2(122),G1H2(123),G1H2(124),G1H2(125),G1H2(126),2)
  call HG1shiftOLR(G1H2(122),8,2)
  call Hotf_5pt_reduction(G2H2(22),RedSet_5(7),mass5set(:,11),  & 
G1H2(127),G1H2(128),G1H2(129),G1H2(130),G1H2(131),G1H2(132),2)
  call HG1shiftOLR(G1H2(128),8,2)
  call Hotf_5pt_reduction(G2H2(23),RedSet_5(8),mass5set(:,24),  & 
G1H2(133),G1H2(134),G1H2(135),G1H2(136),G1H2(137),G1H2(138),2)
  call HG1shiftOLR(G1H2(134),8,2)
  call Hotf_5pt_reduction(G2H2(24),RedSet_5(8),mass5set(:,24),  & 
G1H2(139),G1H2(140),G1H2(141),G1H2(142),G1H2(143),G1H2(144),2)
  call HG1shiftOLR(G1H2(140),8,2)
  call Hotf_5pt_reduction(G2H2(25),RedSet_5(1),mass5set(:,1),  & 
G1H2(145),G1H2(146),G1H2(147),G1H2(148),G1H2(149),G1H2(150),2)
  call HG1shiftOLR(G1H2(146),4,2)
  call Hotf_5pt_reduction(G2H2(27),RedSet_5(1),mass5set(:,1),  & 
G1H2(151),G1H2(152),G1H2(153),G1H2(154),G1H2(155),G1H2(156),2)
  call HG1shiftOLR(G1H2(152),4,2)
  call Hotf_5pt_reduction(G2H2(29),RedSet_5(1),mass5set(:,2),  & 
G1H2(157),G1H2(158),G1H2(159),G1H2(160),G1H2(161),G1H2(162),2)
  call HG1shiftOLR(G1H2(158),4,2)
  call Hotf_5pt_reduction(G2H2(31),RedSet_5(1),mass5set(:,2),  & 
G1H2(163),G1H2(164),G1H2(165),G1H2(166),G1H2(167),G1H2(168),2)
  call HG1shiftOLR(G1H2(164),4,2)
  call Hotf_5pt_reduction(G2H2(33),RedSet_5(2),mass5set(:,3),  & 
G1H2(169),G1H2(170),G1H2(171),G1H2(172),G1H2(173),G1H2(174),2)
  call HG1shiftOLR(G1H2(170),8,2)
  call Hotf_5pt_reduction(G2H2(35),RedSet_5(2),mass5set(:,3),  & 
G1H2(175),G1H2(176),G1H2(177),G1H2(178),G1H2(179),G1H2(180),2)
  call HG1shiftOLR(G1H2(176),8,2)
  call Hotf_5pt_reduction(G2H2(37),RedSet_5(3),mass5set(:,4),  & 
G1H2(181),G1H2(182),G1H2(183),G1H2(184),G1H2(185),G1H2(186),2)
  call HG1shiftOLR(G1H2(182),4,2)
  call Hotf_5pt_reduction(G2H2(39),RedSet_5(3),mass5set(:,5),  & 
G1H2(187),G1H2(188),G1H2(189),G1H2(190),G1H2(191),G1H2(192),2)
  call HG1shiftOLR(G1H2(188),4,2)
  call Hotf_5pt_reduction(G2H2(41),RedSet_5(3),mass5set(:,4),  & 
G1H2(193),G1H2(194),G1H2(195),G1H2(196),G1H2(197),G1H2(198),2)
  call HG1shiftOLR(G1H2(194),4,2)
  call Hotf_5pt_reduction(G2H2(43),RedSet_5(3),mass5set(:,5),  & 
G1H2(199),G1H2(200),G1H2(201),G1H2(202),G1H2(203),G1H2(204),2)
  call HG1shiftOLR(G1H2(200),4,2)
  call Hotf_5pt_reduction(G2H2(45),RedSet_5(4),mass5set(:,1),  & 
G1H2(205),G1H2(206),G1H2(207),G1H2(208),G1H2(209),G1H2(210),2)
  call HG1shiftOLR(G1H2(206),4,2)
  call Hotf_5pt_reduction(G2H2(47),RedSet_5(4),mass5set(:,2),  & 
G1H2(211),G1H2(212),G1H2(213),G1H2(214),G1H2(215),G1H2(216),2)
  call HG1shiftOLR(G1H2(212),4,2)
  call Hotf_5pt_reduction(G2H2(49),RedSet_5(4),mass5set(:,1),  & 
G1H2(217),G1H2(218),G1H2(219),G1H2(220),G1H2(221),G1H2(222),2)
  call HG1shiftOLR(G1H2(218),4,2)
  call Hotf_5pt_reduction(G2H2(51),RedSet_5(4),mass5set(:,2),  & 
G1H2(223),G1H2(224),G1H2(225),G1H2(226),G1H2(227),G1H2(228),2)
  call HG1shiftOLR(G1H2(224),4,2)
  call Hotf_5pt_reduction(G2H2(53),RedSet_5(5),mass5set(:,6),  & 
G1H2(229),G1H2(230),G1H2(231),G1H2(232),G1H2(233),G1H2(234),2)
  call HG1shiftOLR(G1H2(230),8,2)
  call Hotf_5pt_reduction(G2H2(55),RedSet_5(5),mass5set(:,7),  & 
G1H2(235),G1H2(236),G1H2(237),G1H2(238),G1H2(239),G1H2(240),2)
  call HG1shiftOLR(G1H2(236),8,2)
  call Hotf_5pt_reduction(G2H2(57),RedSet_5(6),mass5set(:,4),  & 
G1H2(241),G1H2(242),G1H2(243),G1H2(244),G1H2(245),G1H2(246),2)
  call HG1shiftOLR(G1H2(242),4,2)
  call Hotf_5pt_reduction(G2H2(59),RedSet_5(6),mass5set(:,4),  & 
G1H2(247),G1H2(248),G1H2(249),G1H2(250),G1H2(251),G1H2(252),2)
  call HG1shiftOLR(G1H2(248),4,2)
  call Hotf_5pt_reduction(G2H2(61),RedSet_5(6),mass5set(:,5),  & 
G1H2(253),G1H2(254),G1H2(255),G1H2(256),G1H2(257),G1H2(258),2)
  call HG1shiftOLR(G1H2(254),4,2)
  call Hotf_5pt_reduction(G2H2(63),RedSet_5(6),mass5set(:,5),  & 
G1H2(259),G1H2(260),G1H2(261),G1H2(262),G1H2(263),G1H2(264),2)
  call HG1shiftOLR(G1H2(260),4,2)
  call Hotf_5pt_reduction(G2H2(65),RedSet_5(7),mass5set(:,8),  & 
G1H2(265),G1H2(266),G1H2(267),G1H2(268),G1H2(269),G1H2(270),2)
  call HG1shiftOLR(G1H2(266),8,2)
  call Hotf_5pt_reduction(G2H2(67),RedSet_5(7),mass5set(:,9),  & 
G1H2(271),G1H2(272),G1H2(273),G1H2(274),G1H2(275),G1H2(276),2)
  call HG1shiftOLR(G1H2(272),8,2)
  call Hotf_5pt_reduction(G2H2(69),RedSet_5(7),mass5set(:,8),  & 
G1H2(277),G1H2(278),G1H2(279),G1H2(280),G1H2(281),G1H2(282),2)
  call HG1shiftOLR(G1H2(278),8,2)
  call Hotf_5pt_reduction(G2H2(71),RedSet_5(7),mass5set(:,9),  & 
G1H2(283),G1H2(284),G1H2(285),G1H2(286),G1H2(287),G1H2(288),2)
  call HG1shiftOLR(G1H2(284),8,2)
  call Hotf_5pt_reduction(G2H2(75),RedSet_5(8),mass5set(:,8),  & 
G1H2(289),G1H2(290),G1H2(291),G1H2(292),G1H2(293),G1H2(294),2)
  call HG1shiftOLR(G1H2(290),8,2)
  call Hotf_5pt_reduction(G2H2(77),RedSet_5(8),mass5set(:,8),  & 
G1H2(295),G1H2(296),G1H2(297),G1H2(298),G1H2(299),G1H2(300),2)
  call HG1shiftOLR(G1H2(296),8,2)
  call Hotf_5pt_reduction(G2H2(79),RedSet_5(8),mass5set(:,9),  & 
G1H2(301),G1H2(302),G1H2(303),G1H2(304),G1H2(305),G1H2(306),2)
  call HG1shiftOLR(G1H2(302),8,2)
  call Hotf_5pt_reduction(G2H2(81),RedSet_5(8),mass5set(:,9),  & 
G1H2(307),G1H2(308),G1H2(309),G1H2(310),G1H2(311),G1H2(312),2)
  call HG1shiftOLR(G1H2(308),8,2)
  call Hotf_5pt_reduction(G2H3(1),RedSet_5(9),mass5set(:,12),  & 
G1H3(1),G1H3(2),G1H3(3),G1H3(4),G1H3(5),G1H3(6),3)
  call HG1shiftOLR(G1H3(2),16,3)
  call Hotf_5pt_reduction(G2H3(3),RedSet_5(9),mass5set(:,13),  & 
G1H3(7),G1H3(8),G1H3(9),G1H3(10),G1H3(11),G1H3(12),3)
  call HG1shiftOLR(G1H3(8),16,3)
  call Hotf_5pt_reduction(G2H3(5),RedSet_5(10),mass5set(:,14),  & 
G1H3(13),G1H3(14),G1H3(15),G1H3(16),G1H3(17),G1H3(18),3)
  call HG1shiftOLR(G1H3(14),16,3)
  call Hotf_5pt_reduction(G2H3(7),RedSet_5(10),mass5set(:,15),  & 
G1H3(19),G1H3(20),G1H3(21),G1H3(22),G1H3(23),G1H3(24),3)
  call HG1shiftOLR(G1H3(20),16,3)
  call Hotf_5pt_reduction(G2H2(87),RedSet_5(10),mass5set(:,12),  & 
G1H2(313),G1H2(314),G1H2(315),G1H2(316),G1H2(317),G1H2(318),2)
  call HG1shiftOLR(G1H2(314),4,2)
  call Hotf_5pt_reduction(G2H2(89),RedSet_5(10),mass5set(:,12),  & 
G1H2(319),G1H2(320),G1H2(321),G1H2(322),G1H2(323),G1H2(324),2)
  call HG1shiftOLR(G1H2(320),4,2)
  call Hotf_5pt_reduction(G2H2(91),RedSet_5(10),mass5set(:,13),  & 
G1H2(325),G1H2(326),G1H2(327),G1H2(328),G1H2(329),G1H2(330),2)
  call HG1shiftOLR(G1H2(326),4,2)
  call Hotf_5pt_reduction(G2H2(93),RedSet_5(10),mass5set(:,13),  & 
G1H2(331),G1H2(332),G1H2(333),G1H2(334),G1H2(335),G1H2(336),2)
  call HG1shiftOLR(G1H2(332),4,2)
  call Hotf_5pt_reduction(G2H2(95),RedSet_5(10),mass5set(:,14),  & 
G1H2(337),G1H2(338),G1H2(339),G1H2(340),G1H2(341),G1H2(342),2)
  call HG1shiftOLR(G1H2(338),4,2)
  call Hotf_5pt_reduction(G2H2(97),RedSet_5(10),mass5set(:,15),  & 
G1H2(343),G1H2(344),G1H2(345),G1H2(346),G1H2(347),G1H2(348),2)
  call HG1shiftOLR(G1H2(344),4,2)
  call Hotf_5pt_reduction(G2H3(15),RedSet_5(11),mass5set(:,16),  & 
G1H3(25),G1H3(26),G1H3(27),G1H3(28),G1H3(29),G1H3(30),3)
  call HG1shiftOLR(G1H3(26),16,3)
  call Hotf_5pt_reduction(G2H3(17),RedSet_5(11),mass5set(:,17),  & 
G1H3(31),G1H3(32),G1H3(33),G1H3(34),G1H3(35),G1H3(36),3)
  call HG1shiftOLR(G1H3(32),16,3)
  call Hotf_5pt_reduction(G2H3(19),RedSet_5(11),mass5set(:,18),  & 
G1H3(37),G1H3(38),G1H3(39),G1H3(40),G1H3(41),G1H3(42),3)
  call HG1shiftOLR(G1H3(38),16,3)
  call Hotf_5pt_reduction(G2H3(21),RedSet_5(11),mass5set(:,19),  & 
G1H3(43),G1H3(44),G1H3(45),G1H3(46),G1H3(47),G1H3(48),3)
  call HG1shiftOLR(G1H3(44),16,3)
  call Hotf_5pt_reduction(G2H3(23),RedSet_5(12),mass5set(:,16),  & 
G1H3(49),G1H3(50),G1H3(51),G1H3(52),G1H3(53),G1H3(54),3)
  call HG1shiftOLR(G1H3(50),16,3)
  call Hotf_5pt_reduction(G2H3(25),RedSet_5(12),mass5set(:,18),  & 
G1H3(55),G1H3(56),G1H3(57),G1H3(58),G1H3(59),G1H3(60),3)
  call HG1shiftOLR(G1H3(56),16,3)
  call Hotf_5pt_reduction(G2H3(27),RedSet_5(12),mass5set(:,17),  & 
G1H3(61),G1H3(62),G1H3(63),G1H3(64),G1H3(65),G1H3(66),3)
  call HG1shiftOLR(G1H3(62),16,3)
  call Hotf_5pt_reduction(G2H3(29),RedSet_5(12),mass5set(:,19),  & 
G1H3(67),G1H3(68),G1H3(69),G1H3(70),G1H3(71),G1H3(72),3)
  call HG1shiftOLR(G1H3(68),16,3)
  call Hotf_5pt_reduction(G2H2(107),RedSet_5(12),mass5set(:,16),  & 
G1H2(349),G1H2(350),G1H2(351),G1H2(352),G1H2(353),G1H2(354),2)
  call HG1shiftOLR(G1H2(350),8,2)
  call Hotf_5pt_reduction(G2H2(109),RedSet_5(12),mass5set(:,18),  & 
G1H2(355),G1H2(356),G1H2(357),G1H2(358),G1H2(359),G1H2(360),2)
  call HG1shiftOLR(G1H2(356),8,2)
  call Hotf_5pt_reduction(G2H2(111),RedSet_5(12),mass5set(:,17),  & 
G1H2(361),G1H2(362),G1H2(363),G1H2(364),G1H2(365),G1H2(366),2)
  call HG1shiftOLR(G1H2(362),8,2)
  call Hotf_5pt_reduction(G2H2(113),RedSet_5(12),mass5set(:,19),  & 
G1H2(367),G1H2(368),G1H2(369),G1H2(370),G1H2(371),G1H2(372),2)
  call HG1shiftOLR(G1H2(368),8,2)
  call Hotf_5pt_reduction(G2H3(37),RedSet_5(13),mass5set(:,12),  & 
G1H3(73),G1H3(74),G1H3(75),G1H3(76),G1H3(77),G1H3(78),3)
  call HG1shiftOLR(G1H3(74),16,3)
  call Hotf_5pt_reduction(G2H3(39),RedSet_5(13),mass5set(:,13),  & 
G1H3(79),G1H3(80),G1H3(81),G1H3(82),G1H3(83),G1H3(84),3)
  call HG1shiftOLR(G1H3(80),16,3)
  call Hotf_5pt_reduction(G2H3(41),RedSet_5(14),mass5set(:,14),  & 
G1H3(85),G1H3(86),G1H3(87),G1H3(88),G1H3(89),G1H3(90),3)
  call HG1shiftOLR(G1H3(86),16,3)
  call Hotf_5pt_reduction(G2H3(43),RedSet_5(14),mass5set(:,15),  & 
G1H3(91),G1H3(92),G1H3(93),G1H3(94),G1H3(95),G1H3(96),3)
  call HG1shiftOLR(G1H3(92),16,3)
  call Hotf_5pt_reduction(G2H3(45),RedSet_5(15),mass5set(:,16),  & 
G1H3(97),G1H3(98),G1H3(99),G1H3(100),G1H3(101),G1H3(102),3)
  call HG1shiftOLR(G1H3(98),16,3)
  call Hotf_5pt_reduction(G2H3(47),RedSet_5(15),mass5set(:,17),  & 
G1H3(103),G1H3(104),G1H3(105),G1H3(106),G1H3(107),G1H3(108),3)
  call HG1shiftOLR(G1H3(104),16,3)
  call Hotf_5pt_reduction(G2H3(49),RedSet_5(15),mass5set(:,18),  & 
G1H3(109),G1H3(110),G1H3(111),G1H3(112),G1H3(113),G1H3(114),3)
  call HG1shiftOLR(G1H3(110),16,3)
  call Hotf_5pt_reduction(G2H3(51),RedSet_5(15),mass5set(:,19),  & 
G1H3(115),G1H3(116),G1H3(117),G1H3(118),G1H3(119),G1H3(120),3)
  call HG1shiftOLR(G1H3(116),16,3)
  call Hotf_5pt_reduction(G2H3(53),RedSet_5(16),mass5set(:,16),  & 
G1H3(121),G1H3(122),G1H3(123),G1H3(124),G1H3(125),G1H3(126),3)
  call HG1shiftOLR(G1H3(122),16,3)
  call Hotf_5pt_reduction(G2H3(55),RedSet_5(16),mass5set(:,18),  & 
G1H3(127),G1H3(128),G1H3(129),G1H3(130),G1H3(131),G1H3(132),3)
  call HG1shiftOLR(G1H3(128),16,3)
  call Hotf_5pt_reduction(G2H3(57),RedSet_5(16),mass5set(:,17),  & 
G1H3(133),G1H3(134),G1H3(135),G1H3(136),G1H3(137),G1H3(138),3)
  call HG1shiftOLR(G1H3(134),16,3)
  call Hotf_5pt_reduction(G2H3(59),RedSet_5(16),mass5set(:,19),  & 
G1H3(139),G1H3(140),G1H3(141),G1H3(142),G1H3(143),G1H3(144),3)
  call HG1shiftOLR(G1H3(140),16,3)
  call Hotf_5pt_reduction(G2H2(131),RedSet_5(16),mass5set(:,16),  & 
G1H2(373),G1H2(374),G1H2(375),G1H2(376),G1H2(377),G1H2(378),2)
  call HG1shiftOLR(G1H2(374),8,2)
  call Hotf_5pt_reduction(G2H2(133),RedSet_5(16),mass5set(:,18),  & 
G1H2(379),G1H2(380),G1H2(381),G1H2(382),G1H2(383),G1H2(384),2)
  call HG1shiftOLR(G1H2(380),8,2)
  call Hotf_5pt_reduction(G2H2(135),RedSet_5(16),mass5set(:,17),  & 
G1H2(385),G1H2(386),G1H2(387),G1H2(388),G1H2(389),G1H2(390),2)
  call HG1shiftOLR(G1H2(386),8,2)
  call Hotf_5pt_reduction(G2H2(137),RedSet_5(16),mass5set(:,19),  & 
G1H2(391),G1H2(392),G1H2(393),G1H2(394),G1H2(395),G1H2(396),2)
  call HG1shiftOLR(G1H2(392),8,2)
  call Hotf_5pt_reduction(G2H2(139),RedSet_5(14),mass5set(:,12),  & 
G1H2(397),G1H2(398),G1H2(399),G1H2(400),G1H2(401),G1H2(402),2)
  call HG1shiftOLR(G1H2(398),4,2)
  call Hotf_5pt_reduction(G2H2(141),RedSet_5(14),mass5set(:,12),  & 
G1H2(403),G1H2(404),G1H2(405),G1H2(406),G1H2(407),G1H2(408),2)
  call HG1shiftOLR(G1H2(404),4,2)
  call Hotf_5pt_reduction(G2H2(143),RedSet_5(14),mass5set(:,13),  & 
G1H2(409),G1H2(410),G1H2(411),G1H2(412),G1H2(413),G1H2(414),2)
  call HG1shiftOLR(G1H2(410),4,2)
  call Hotf_5pt_reduction(G2H2(145),RedSet_5(14),mass5set(:,13),  & 
G1H2(415),G1H2(416),G1H2(417),G1H2(418),G1H2(419),G1H2(420),2)
  call HG1shiftOLR(G1H2(416),4,2)
  call Hotf_5pt_reduction(G2H2(147),RedSet_5(14),mass5set(:,14),  & 
G1H2(421),G1H2(422),G1H2(423),G1H2(424),G1H2(425),G1H2(426),2)
  call HG1shiftOLR(G1H2(422),4,2)
  call Hotf_5pt_reduction(G2H2(149),RedSet_5(14),mass5set(:,15),  & 
G1H2(427),G1H2(428),G1H2(429),G1H2(430),G1H2(431),G1H2(432),2)
  call HG1shiftOLR(G1H2(428),4,2)
  call Hloop_SA_Q(ntryL,G1H2(1),ex3(:),G1H1(1),ngH,m3h2x1(:,1),heltab2x2(:,:,1))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(1),n2h1(1))
  call Hloop_SA_Q(ntryL,G1H2(2),ex3(:),G1H1(1),ngH,m3h2x1(:,2),heltab2x2(:,:,2))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(2),n2h1(2))
  call Hloop_SA_Q(ntryL,G1H2(7),ex3(:),G1H1(1),ngPtb,m3h2x1(:,3),heltab2x2(:,:,3))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(3),n2h1(3))
  call Hloop_SA_Q(ntryL,G1H2(8),ex3(:),G1H1(1),ngPtb,m3h2x1(:,4),heltab2x2(:,:,4))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(4),n2h1(4))
  call Hloop_SA_Q(ntryL,G1H2(13),ex3(:),G1H1(1),ngH,m3h2x1(:,5),heltab2x2(:,:,5))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(5),n2h1(5))
  call Hloop_SA_Q(ntryL,G1H2(14),ex3(:),G1H1(1),ngH,m3h2x1(:,6),heltab2x2(:,:,6))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(6),n2h1(6))
  call Hloop_SA_Q(ntryL,G1H2(19),ex3(:),G1H1(1),ngPtb,m3h2x1(:,7),heltab2x2(:,:,7))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(7),n2h1(7))
  call Hloop_SA_Q(ntryL,G1H2(20),ex3(:),G1H1(1),ngPtb,m3h2x1(:,8),heltab2x2(:,:,8))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(8),n2h1(8))
  call Hloop_WQ_A(ntryL,G1H2(25),ex4(:),G1H1(1),m3h2x1(:,9),heltab2x2(:,:,9))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(9),n2h1(9))
  call Hloop_WQ_A(ntryL,G1H2(26),ex4(:),G1H1(1),m3h2x1(:,10),heltab2x2(:,:,10))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(10),n2h1(10))
  call Hloop_VQ_A(ntryL,G1H2(31),ex4(:),G1H1(1),m3h2x1(:,11),heltab2x2(:,:,11))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(11),n2h1(11))
  call Hloop_VQ_A(ntryL,G1H2(32),ex4(:),G1H1(1),m3h2x1(:,12),heltab2x2(:,:,12))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(12),n2h1(12))
  call Hloop_WQ_A(ntryL,G1H2(37),ex4(:),G1H1(1),m3h2x1(:,13),heltab2x2(:,:,13))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(13),n2h1(13))
  call Hloop_WQ_A(ntryL,G1H2(38),ex4(:),G1H1(1),m3h2x1(:,14),heltab2x2(:,:,14))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(14),n2h1(14))
  call Hloop_ZQ_A(ntryL,G1H2(43),ex4(:),G1H1(1),ngZd,m3h2x1(:,15),heltab2x2(:,:,15))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(15),n2h1(15))
  call Hloop_ZQ_A(ntryL,G1H2(44),ex4(:),G1H1(1),ngZd,m3h2x1(:,16),heltab2x2(:,:,16))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(16),n2h1(16))
  call Hloop_VA_Q(ntryL,G1H2(49),ex3(:),G1H1(1),m3h2x1(:,17),heltab2x2(:,:,17))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(17),n2h1(17))
  call Hloop_VA_Q(ntryL,G1H2(50),ex3(:),G1H1(1),m3h2x1(:,18),heltab2x2(:,:,18))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(18),n2h1(18))
  call Hloop_ZA_Q(ntryL,G1H2(55),ex3(:),G1H1(1),ngZu,m3h2x1(:,19),heltab2x2(:,:,19))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(19),n2h1(19))
  call Hloop_ZA_Q(ntryL,G1H2(56),ex3(:),G1H1(1),ngZu,m3h2x1(:,20),heltab2x2(:,:,20))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(20),n2h1(20))
  call Hloop_WQ_A(ntryL,G1H2(61),ex4(:),G1H1(1),m3h2x1(:,21),heltab2x2(:,:,21))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(21),n2h1(21))
  call Hloop_WQ_A(ntryL,G1H2(62),ex4(:),G1H1(1),m3h2x1(:,22),heltab2x2(:,:,22))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(22),n2h1(22))
  call Hloop_WQ_A(ntryL,G1H2(67),ex4(:),G1H1(1),m3h2x1(:,23),heltab2x2(:,:,23))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(23),n2h1(23))
  call Hloop_WQ_A(ntryL,G1H2(68),ex4(:),G1H1(1),m3h2x1(:,24),heltab2x2(:,:,24))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(24),n2h1(24))
  call Hloop_SA_Q(ntryL,G1H2(73),ex3(:),G1H1(1),ngH,m3h2x1(:,25),heltab2x2(:,:,25))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(25),n2h1(25))
  call Hloop_SA_Q(ntryL,G1H2(74),ex3(:),G1H1(1),ngH,m3h2x1(:,26),heltab2x2(:,:,26))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(26),n2h1(26))
  call Hloop_SA_Q(ntryL,G1H2(79),ex3(:),G1H1(1),ngPtb,m3h2x1(:,27),heltab2x2(:,:,27))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(27),n2h1(27))
  call Hloop_SA_Q(ntryL,G1H2(80),ex3(:),G1H1(1),ngPtb,m3h2x1(:,28),heltab2x2(:,:,28))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(28),n2h1(28))
  call Hloop_SA_Q(ntryL,G1H2(85),ex3(:),G1H1(1),ngH,m3h2x1(:,29),heltab2x2(:,:,29))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(29),n2h1(29))
  call Hloop_SA_Q(ntryL,G1H2(86),ex3(:),G1H1(1),ngH,m3h2x1(:,30),heltab2x2(:,:,30))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(30),n2h1(30))
  call Hloop_SA_Q(ntryL,G1H2(91),ex3(:),G1H1(1),ngPtb,m3h2x1(:,31),heltab2x2(:,:,31))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(31),n2h1(31))
  call Hloop_SA_Q(ntryL,G1H2(92),ex3(:),G1H1(1),ngPtb,m3h2x1(:,32),heltab2x2(:,:,32))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(32),n2h1(32))
  call Hloop_VA_Q(ntryL,G1H2(97),ex3(:),G1H1(1),m3h2x1(:,33),heltab2x2(:,:,33))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(33),n2h1(33))
  call Hloop_VA_Q(ntryL,G1H2(98),ex3(:),G1H1(1),m3h2x1(:,34),heltab2x2(:,:,34))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(34),n2h1(34))
  call Hloop_ZA_Q(ntryL,G1H2(103),ex3(:),G1H1(1),ngZu,m3h2x1(:,35),heltab2x2(:,:,35))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(35),n2h1(35))
  call Hloop_ZA_Q(ntryL,G1H2(104),ex3(:),G1H1(1),ngZu,m3h2x1(:,36),heltab2x2(:,:,36))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(36),n2h1(36))
  call Hloop_VQ_A(ntryL,G1H2(109),ex4(:),G1H1(1),m3h2x1(:,37),heltab2x2(:,:,37))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(37),n2h1(37))
  call Hloop_VQ_A(ntryL,G1H2(110),ex4(:),G1H1(1),m3h2x1(:,38),heltab2x2(:,:,38))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(38),n2h1(38))
  call Hloop_WQ_A(ntryL,G1H2(115),ex4(:),G1H1(1),m3h2x1(:,39),heltab2x2(:,:,39))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(39),n2h1(39))
  call Hloop_WQ_A(ntryL,G1H2(116),ex4(:),G1H1(1),m3h2x1(:,40),heltab2x2(:,:,40))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(40),n2h1(40))
  call Hloop_ZQ_A(ntryL,G1H2(121),ex4(:),G1H1(1),ngZd,m3h2x1(:,41),heltab2x2(:,:,41))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(41),n2h1(41))
  call Hloop_ZQ_A(ntryL,G1H2(122),ex4(:),G1H1(1),ngZd,m3h2x1(:,42),heltab2x2(:,:,42))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(42),n2h1(42))
  call Hloop_WQ_A(ntryL,G1H2(127),ex4(:),G1H1(1),m3h2x1(:,43),heltab2x2(:,:,43))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(43),n2h1(43))
  call Hloop_WQ_A(ntryL,G1H2(128),ex4(:),G1H1(1),m3h2x1(:,44),heltab2x2(:,:,44))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(44),n2h1(44))
  call Hloop_VQ_A(ntryL,G1H2(133),ex4(:),G1H1(1),m3h2x1(:,45),heltab2x2(:,:,45))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(45),n2h1(45))
  call Hloop_VQ_A(ntryL,G1H2(134),ex4(:),G1H1(1),m3h2x1(:,46),heltab2x2(:,:,46))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(46),n2h1(46))
  call Hloop_ZQ_A(ntryL,G1H2(139),ex4(:),G1H1(1),ngZd,m3h2x1(:,47),heltab2x2(:,:,47))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(47),n2h1(47))
  call Hloop_ZQ_A(ntryL,G1H2(140),ex4(:),G1H1(1),ngZd,m3h2x1(:,48),heltab2x2(:,:,48))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(48),n2h1(48))
  call Hloop_VA_Q(ntryL,G1H2(145),ex3(:),G1H1(1),m3h2x1(:,49),heltab2x2(:,:,49))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(49),n2h1(49))
  call Hloop_VA_Q(ntryL,G1H2(146),ex3(:),G1H1(1),m3h2x1(:,50),heltab2x2(:,:,50))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(50),n2h1(50))
  call Hloop_ZA_Q(ntryL,G1H2(151),ex3(:),G1H1(1),ngZu,m3h2x1(:,51),heltab2x2(:,:,51))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(51),n2h1(51))
  call Hloop_ZA_Q(ntryL,G1H2(152),ex3(:),G1H1(1),ngZu,m3h2x1(:,52),heltab2x2(:,:,52))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(52),n2h1(52))
  call Hloop_VA_Q(ntryL,G1H2(157),ex3(:),G1H1(1),m3h2x1(:,53),heltab2x2(:,:,53))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(53),n2h1(53))
  call Hloop_VA_Q(ntryL,G1H2(158),ex3(:),G1H1(1),m3h2x1(:,54),heltab2x2(:,:,54))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(54),n2h1(54))
  call Hloop_ZA_Q(ntryL,G1H2(163),ex3(:),G1H1(1),ngZu,m3h2x1(:,55),heltab2x2(:,:,55))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(55),n2h1(55))
  call Hloop_ZA_Q(ntryL,G1H2(164),ex3(:),G1H1(1),ngZu,m3h2x1(:,56),heltab2x2(:,:,56))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(56),n2h1(56))
  call Hloop_VQ_A(ntryL,G1H2(169),ex4(:),G1H1(1),m3h2x1(:,57),heltab2x2(:,:,57))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(57),n2h1(57))
  call Hloop_VQ_A(ntryL,G1H2(170),ex4(:),G1H1(1),m3h2x1(:,58),heltab2x2(:,:,58))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(58),n2h1(58))
  call Hloop_ZQ_A(ntryL,G1H2(175),ex4(:),G1H1(1),ngZd,m3h2x1(:,59),heltab2x2(:,:,59))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(59),n2h1(59))
  call Hloop_ZQ_A(ntryL,G1H2(176),ex4(:),G1H1(1),ngZd,m3h2x1(:,60),heltab2x2(:,:,60))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(60),n2h1(60))
  call Hloop_VA_Q(ntryL,G1H2(181),ex3(:),G1H1(1),m3h2x1(:,61),heltab2x2(:,:,61))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(61),n2h1(61))
  call Hloop_VA_Q(ntryL,G1H2(182),ex3(:),G1H1(1),m3h2x1(:,62),heltab2x2(:,:,62))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(62),n2h1(62))
  call Hloop_VA_Q(ntryL,G1H2(187),ex3(:),G1H1(1),m3h2x1(:,63),heltab2x2(:,:,63))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(63),n2h1(63))
  call Hloop_VA_Q(ntryL,G1H2(188),ex3(:),G1H1(1),m3h2x1(:,64),heltab2x2(:,:,64))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(64),n2h1(64))
  call Hloop_ZA_Q(ntryL,G1H2(193),ex3(:),G1H1(1),ngZu,m3h2x1(:,65),heltab2x2(:,:,65))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(65),n2h1(65))
  call Hloop_ZA_Q(ntryL,G1H2(194),ex3(:),G1H1(1),ngZu,m3h2x1(:,66),heltab2x2(:,:,66))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(66),n2h1(66))
  call Hloop_ZA_Q(ntryL,G1H2(199),ex3(:),G1H1(1),ngZu,m3h2x1(:,67),heltab2x2(:,:,67))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(67),n2h1(67))
  call Hloop_ZA_Q(ntryL,G1H2(200),ex3(:),G1H1(1),ngZu,m3h2x1(:,68),heltab2x2(:,:,68))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(68),n2h1(68))
  call Hloop_VA_Q(ntryL,G1H2(205),ex3(:),G1H1(1),m3h2x1(:,69),heltab2x2(:,:,69))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(69),n2h1(69))
  call Hloop_VA_Q(ntryL,G1H2(206),ex3(:),G1H1(1),m3h2x1(:,70),heltab2x2(:,:,70))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(70),n2h1(70))
  call Hloop_VA_Q(ntryL,G1H2(211),ex3(:),G1H1(1),m3h2x1(:,71),heltab2x2(:,:,71))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(71),n2h1(71))
  call Hloop_VA_Q(ntryL,G1H2(212),ex3(:),G1H1(1),m3h2x1(:,72),heltab2x2(:,:,72))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(72),n2h1(72))
  call Hloop_ZA_Q(ntryL,G1H2(217),ex3(:),G1H1(1),ngZu,m3h2x1(:,73),heltab2x2(:,:,73))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(73),n2h1(73))
  call Hloop_ZA_Q(ntryL,G1H2(218),ex3(:),G1H1(1),ngZu,m3h2x1(:,74),heltab2x2(:,:,74))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(74),n2h1(74))
  call Hloop_ZA_Q(ntryL,G1H2(223),ex3(:),G1H1(1),ngZu,m3h2x1(:,75),heltab2x2(:,:,75))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(75),n2h1(75))
  call Hloop_ZA_Q(ntryL,G1H2(224),ex3(:),G1H1(1),ngZu,m3h2x1(:,76),heltab2x2(:,:,76))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(76),n2h1(76))
  call Hloop_WQ_A(ntryL,G1H2(229),ex4(:),G1H1(1),m3h2x1(:,77),heltab2x2(:,:,77))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(77),n2h1(77))
  call Hloop_WQ_A(ntryL,G1H2(230),ex4(:),G1H1(1),m3h2x1(:,78),heltab2x2(:,:,78))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(78),n2h1(78))
  call Hloop_WQ_A(ntryL,G1H2(235),ex4(:),G1H1(1),m3h2x1(:,79),heltab2x2(:,:,79))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(79),n2h1(79))
  call Hloop_WQ_A(ntryL,G1H2(236),ex4(:),G1H1(1),m3h2x1(:,80),heltab2x2(:,:,80))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(80),n2h1(80))
  call Hloop_VA_Q(ntryL,G1H2(241),ex3(:),G1H1(1),m3h2x1(:,81),heltab2x2(:,:,81))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(81),n2h1(81))
  call Hloop_VA_Q(ntryL,G1H2(242),ex3(:),G1H1(1),m3h2x1(:,82),heltab2x2(:,:,82))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(82),n2h1(82))
  call Hloop_ZA_Q(ntryL,G1H2(247),ex3(:),G1H1(1),ngZu,m3h2x1(:,83),heltab2x2(:,:,83))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(83),n2h1(83))
  call Hloop_ZA_Q(ntryL,G1H2(248),ex3(:),G1H1(1),ngZu,m3h2x1(:,84),heltab2x2(:,:,84))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(84),n2h1(84))
  call Hloop_VA_Q(ntryL,G1H2(253),ex3(:),G1H1(1),m3h2x1(:,85),heltab2x2(:,:,85))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(85),n2h1(85))
  call Hloop_VA_Q(ntryL,G1H2(254),ex3(:),G1H1(1),m3h2x1(:,86),heltab2x2(:,:,86))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(86),n2h1(86))
  call Hloop_ZA_Q(ntryL,G1H2(259),ex3(:),G1H1(1),ngZu,m3h2x1(:,87),heltab2x2(:,:,87))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(87),n2h1(87))
  call Hloop_ZA_Q(ntryL,G1H2(260),ex3(:),G1H1(1),ngZu,m3h2x1(:,88),heltab2x2(:,:,88))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(88),n2h1(88))
  call Hloop_VQ_A(ntryL,G1H2(265),ex4(:),G1H1(1),m3h2x1(:,89),heltab2x2(:,:,89))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(89),n2h1(89))
  call Hloop_VQ_A(ntryL,G1H2(266),ex4(:),G1H1(1),m3h2x1(:,90),heltab2x2(:,:,90))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(90),n2h1(90))
  call Hloop_VQ_A(ntryL,G1H2(271),ex4(:),G1H1(1),m3h2x1(:,91),heltab2x2(:,:,91))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(91),n2h1(91))
  call Hloop_VQ_A(ntryL,G1H2(272),ex4(:),G1H1(1),m3h2x1(:,92),heltab2x2(:,:,92))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(92),n2h1(92))
  call Hloop_ZQ_A(ntryL,G1H2(277),ex4(:),G1H1(1),ngZd,m3h2x1(:,93),heltab2x2(:,:,93))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(93),n2h1(93))
  call Hloop_ZQ_A(ntryL,G1H2(278),ex4(:),G1H1(1),ngZd,m3h2x1(:,94),heltab2x2(:,:,94))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(94),n2h1(94))
  call Hloop_ZQ_A(ntryL,G1H2(283),ex4(:),G1H1(1),ngZd,m3h2x1(:,95),heltab2x2(:,:,95))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(95),n2h1(95))
  call Hloop_ZQ_A(ntryL,G1H2(284),ex4(:),G1H1(1),ngZd,m3h2x1(:,96),heltab2x2(:,:,96))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(96),n2h1(96))
  call Hloop_VQ_A(ntryL,G1H2(289),ex4(:),G1H1(1),m3h2x1(:,97),heltab2x2(:,:,97))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(97),n2h1(97))
  call Hloop_VQ_A(ntryL,G1H2(290),ex4(:),G1H1(1),m3h2x1(:,98),heltab2x2(:,:,98))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(98),n2h1(98))
  call Hloop_ZQ_A(ntryL,G1H2(295),ex4(:),G1H1(1),ngZd,m3h2x1(:,99),heltab2x2(:,:,99))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(99),n2h1(99))
  call Hloop_ZQ_A(ntryL,G1H2(296),ex4(:),G1H1(1),ngZd,m3h2x1(:,100),heltab2x2(:,:,100))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(100),n2h1(100))
  call Hloop_VQ_A(ntryL,G1H2(301),ex4(:),G1H1(1),m3h2x1(:,101),heltab2x2(:,:,101))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(101),n2h1(101))
  call Hloop_VQ_A(ntryL,G1H2(302),ex4(:),G1H1(1),m3h2x1(:,102),heltab2x2(:,:,102))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(102),n2h1(102))
  call Hloop_ZQ_A(ntryL,G1H2(307),ex4(:),G1H1(1),ngZd,m3h2x1(:,103),heltab2x2(:,:,103))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(103),n2h1(103))
  call Hloop_ZQ_A(ntryL,G1H2(308),ex4(:),G1H1(1),ngZd,m3h2x1(:,104),heltab2x2(:,:,104))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(104),n2h1(104))
  call Hloop_QW_A(ntryL,G1H3(1),ex5(:),G1H1(1),m3h3x1(:,1),heltab2x3(:,:,1))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(105),n2h1(105))
  call Hloop_QW_A(ntryL,G1H3(2),ex5(:),G1H1(1),m3h3x1(:,2),heltab2x3(:,:,2))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMT,G2tensor(106),n2h1(106))
  call Hloop_QW_A(ntryL,G1H3(7),ex5(:),G1H1(1),m3h3x1(:,3),heltab2x3(:,:,3))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(107),n2h1(107))
  call Hloop_QW_A(ntryL,G1H3(8),ex5(:),G1H1(1),m3h3x1(:,4),heltab2x3(:,:,4))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMT,G2tensor(108),n2h1(108))
  call Hloop_AW_Q(ntryL,G1H3(13),ex5(:),G1H1(1),m3h3x1(:,5),heltab2x3(:,:,5))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(109),n2h1(109))
  call Hloop_AW_Q(ntryL,G1H3(14),ex5(:),G1H1(1),m3h3x1(:,6),heltab2x3(:,:,6))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(110),n2h1(110))
  call Hloop_AW_Q(ntryL,G1H3(19),ex5(:),G1H1(1),m3h3x1(:,7),heltab2x3(:,:,7))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(111),n2h1(111))
  call Hloop_AW_Q(ntryL,G1H3(20),ex5(:),G1H1(1),m3h3x1(:,8),heltab2x3(:,:,8))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(112),n2h1(112))
  call Hloop_VA_Q(ntryL,G1H2(313),ex3(:),G1H1(1),m3h2x1(:,105),heltab2x2(:,:,105))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(113),n2h1(113))
  call Hloop_VA_Q(ntryL,G1H2(314),ex3(:),G1H1(1),m3h2x1(:,106),heltab2x2(:,:,106))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(114),n2h1(114))
  call Hloop_ZA_Q(ntryL,G1H2(319),ex3(:),G1H1(1),ngZu,m3h2x1(:,107),heltab2x2(:,:,107))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(115),n2h1(115))
  call Hloop_ZA_Q(ntryL,G1H2(320),ex3(:),G1H1(1),ngZu,m3h2x1(:,108),heltab2x2(:,:,108))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(116),n2h1(116))
  call Hloop_VA_Q(ntryL,G1H2(325),ex3(:),G1H1(1),m3h2x1(:,109),heltab2x2(:,:,109))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(117),n2h1(117))
  call Hloop_VA_Q(ntryL,G1H2(326),ex3(:),G1H1(1),m3h2x1(:,110),heltab2x2(:,:,110))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(118),n2h1(118))
  call Hloop_ZA_Q(ntryL,G1H2(331),ex3(:),G1H1(1),ngZu,m3h2x1(:,111),heltab2x2(:,:,111))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(119),n2h1(119))
  call Hloop_ZA_Q(ntryL,G1H2(332),ex3(:),G1H1(1),ngZu,m3h2x1(:,112),heltab2x2(:,:,112))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(120),n2h1(120))
  call Hloop_WA_Q(ntryL,G1H2(337),ex3(:),G1H1(1),m3h2x1(:,113),heltab2x2(:,:,113))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(121),n2h1(121))
  call Hloop_WA_Q(ntryL,G1H2(338),ex3(:),G1H1(1),m3h2x1(:,114),heltab2x2(:,:,114))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(122),n2h1(122))
  call Hloop_WA_Q(ntryL,G1H2(343),ex3(:),G1H1(1),m3h2x1(:,115),heltab2x2(:,:,115))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(123),n2h1(123))
  call Hloop_WA_Q(ntryL,G1H2(344),ex3(:),G1H1(1),m3h2x1(:,116),heltab2x2(:,:,116))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(124),n2h1(124))
  call Hloop_AW_Q(ntryL,G1H3(25),ex5(:),G1H1(1),m3h3x1(:,9),heltab2x3(:,:,9))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(125),n2h1(125))
  call Hloop_AW_Q(ntryL,G1H3(26),ex5(:),G1H1(1),m3h3x1(:,10),heltab2x3(:,:,10))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(126),n2h1(126))
  call Hloop_AW_Q(ntryL,G1H3(31),ex5(:),G1H1(1),m3h3x1(:,11),heltab2x3(:,:,11))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(127),n2h1(127))
  call Hloop_AW_Q(ntryL,G1H3(32),ex5(:),G1H1(1),m3h3x1(:,12),heltab2x3(:,:,12))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(128),n2h1(128))
  call Hloop_AW_Q(ntryL,G1H3(37),ex5(:),G1H1(1),m3h3x1(:,13),heltab2x3(:,:,13))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(129),n2h1(129))
  call Hloop_AW_Q(ntryL,G1H3(38),ex5(:),G1H1(1),m3h3x1(:,14),heltab2x3(:,:,14))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(130),n2h1(130))
  call Hloop_AW_Q(ntryL,G1H3(43),ex5(:),G1H1(1),m3h3x1(:,15),heltab2x3(:,:,15))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(131),n2h1(131))
  call Hloop_AW_Q(ntryL,G1H3(44),ex5(:),G1H1(1),m3h3x1(:,16),heltab2x3(:,:,16))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(132),n2h1(132))
  call Hloop_QW_A(ntryL,G1H3(49),ex5(:),G1H1(1),m3h3x1(:,17),heltab2x3(:,:,17))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(133),n2h1(133))
  call Hloop_QW_A(ntryL,G1H3(50),ex5(:),G1H1(1),m3h3x1(:,18),heltab2x3(:,:,18))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(134),n2h1(134))
  call Hloop_QW_A(ntryL,G1H3(55),ex5(:),G1H1(1),m3h3x1(:,19),heltab2x3(:,:,19))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(135),n2h1(135))
  call Hloop_QW_A(ntryL,G1H3(56),ex5(:),G1H1(1),m3h3x1(:,20),heltab2x3(:,:,20))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(136),n2h1(136))
  call Hloop_QW_A(ntryL,G1H3(61),ex5(:),G1H1(1),m3h3x1(:,21),heltab2x3(:,:,21))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(137),n2h1(137))
  call Hloop_QW_A(ntryL,G1H3(62),ex5(:),G1H1(1),m3h3x1(:,22),heltab2x3(:,:,22))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(138),n2h1(138))
  call Hloop_QW_A(ntryL,G1H3(67),ex5(:),G1H1(1),m3h3x1(:,23),heltab2x3(:,:,23))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(139),n2h1(139))
  call Hloop_QW_A(ntryL,G1H3(68),ex5(:),G1H1(1),m3h3x1(:,24),heltab2x3(:,:,24))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(140),n2h1(140))
  call Hloop_WQ_A(ntryL,G1H2(349),ex4(:),G1H1(1),m3h2x1(:,117),heltab2x2(:,:,117))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(141),n2h1(141))
  call Hloop_WQ_A(ntryL,G1H2(350),ex4(:),G1H1(1),m3h2x1(:,118),heltab2x2(:,:,118))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(142),n2h1(142))
  call Hloop_WQ_A(ntryL,G1H2(355),ex4(:),G1H1(1),m3h2x1(:,119),heltab2x2(:,:,119))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(143),n2h1(143))
  call Hloop_WQ_A(ntryL,G1H2(356),ex4(:),G1H1(1),m3h2x1(:,120),heltab2x2(:,:,120))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(144),n2h1(144))
  call Hloop_WQ_A(ntryL,G1H2(361),ex4(:),G1H1(1),m3h2x1(:,121),heltab2x2(:,:,121))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(145),n2h1(145))
  call Hloop_WQ_A(ntryL,G1H2(362),ex4(:),G1H1(1),m3h2x1(:,122),heltab2x2(:,:,122))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(146),n2h1(146))
  call Hloop_WQ_A(ntryL,G1H2(367),ex4(:),G1H1(1),m3h2x1(:,123),heltab2x2(:,:,123))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(147),n2h1(147))
  call Hloop_WQ_A(ntryL,G1H2(368),ex4(:),G1H1(1),m3h2x1(:,124),heltab2x2(:,:,124))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(148),n2h1(148))
  call Hloop_QW_A(ntryL,G1H3(73),ex5(:),G1H1(1),m3h3x1(:,25),heltab2x3(:,:,25))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(149),n2h1(149))
  call Hloop_QW_A(ntryL,G1H3(74),ex5(:),G1H1(1),m3h3x1(:,26),heltab2x3(:,:,26))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMT,G2tensor(150),n2h1(150))
  call Hloop_QW_A(ntryL,G1H3(79),ex5(:),G1H1(1),m3h3x1(:,27),heltab2x3(:,:,27))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(151),n2h1(151))
  call Hloop_QW_A(ntryL,G1H3(80),ex5(:),G1H1(1),m3h3x1(:,28),heltab2x3(:,:,28))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMT,G2tensor(152),n2h1(152))
  call Hloop_AW_Q(ntryL,G1H3(85),ex5(:),G1H1(1),m3h3x1(:,29),heltab2x3(:,:,29))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(153),n2h1(153))
  call Hloop_AW_Q(ntryL,G1H3(86),ex5(:),G1H1(1),m3h3x1(:,30),heltab2x3(:,:,30))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(154),n2h1(154))
  call Hloop_AW_Q(ntryL,G1H3(91),ex5(:),G1H1(1),m3h3x1(:,31),heltab2x3(:,:,31))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(155),n2h1(155))
  call Hloop_AW_Q(ntryL,G1H3(92),ex5(:),G1H1(1),m3h3x1(:,32),heltab2x3(:,:,32))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(156),n2h1(156))
  call Hloop_AW_Q(ntryL,G1H3(97),ex5(:),G1H1(1),m3h3x1(:,33),heltab2x3(:,:,33))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(157),n2h1(157))
  call Hloop_AW_Q(ntryL,G1H3(98),ex5(:),G1H1(1),m3h3x1(:,34),heltab2x3(:,:,34))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(158),n2h1(158))
  call Hloop_AW_Q(ntryL,G1H3(103),ex5(:),G1H1(1),m3h3x1(:,35),heltab2x3(:,:,35))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(159),n2h1(159))
  call Hloop_AW_Q(ntryL,G1H3(104),ex5(:),G1H1(1),m3h3x1(:,36),heltab2x3(:,:,36))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(160),n2h1(160))
  call Hloop_AW_Q(ntryL,G1H3(109),ex5(:),G1H1(1),m3h3x1(:,37),heltab2x3(:,:,37))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(161),n2h1(161))
  call Hloop_AW_Q(ntryL,G1H3(110),ex5(:),G1H1(1),m3h3x1(:,38),heltab2x3(:,:,38))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(162),n2h1(162))
  call Hloop_AW_Q(ntryL,G1H3(115),ex5(:),G1H1(1),m3h3x1(:,39),heltab2x3(:,:,39))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(163),n2h1(163))
  call Hloop_AW_Q(ntryL,G1H3(116),ex5(:),G1H1(1),m3h3x1(:,40),heltab2x3(:,:,40))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(164),n2h1(164))
  call Hloop_QW_A(ntryL,G1H3(121),ex5(:),G1H1(1),m3h3x1(:,41),heltab2x3(:,:,41))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(165),n2h1(165))
  call Hloop_QW_A(ntryL,G1H3(122),ex5(:),G1H1(1),m3h3x1(:,42),heltab2x3(:,:,42))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(166),n2h1(166))
  call Hloop_QW_A(ntryL,G1H3(127),ex5(:),G1H1(1),m3h3x1(:,43),heltab2x3(:,:,43))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(167),n2h1(167))
  call Hloop_QW_A(ntryL,G1H3(128),ex5(:),G1H1(1),m3h3x1(:,44),heltab2x3(:,:,44))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(168),n2h1(168))
  call Hloop_QW_A(ntryL,G1H3(133),ex5(:),G1H1(1),m3h3x1(:,45),heltab2x3(:,:,45))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(169),n2h1(169))
  call Hloop_QW_A(ntryL,G1H3(134),ex5(:),G1H1(1),m3h3x1(:,46),heltab2x3(:,:,46))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(170),n2h1(170))
  call Hloop_QW_A(ntryL,G1H3(139),ex5(:),G1H1(1),m3h3x1(:,47),heltab2x3(:,:,47))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(171),n2h1(171))
  call Hloop_QW_A(ntryL,G1H3(140),ex5(:),G1H1(1),m3h3x1(:,48),heltab2x3(:,:,48))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(172),n2h1(172))
  call Hloop_WQ_A(ntryL,G1H2(373),ex4(:),G1H1(1),m3h2x1(:,125),heltab2x2(:,:,125))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(173),n2h1(173))
  call Hloop_WQ_A(ntryL,G1H2(374),ex4(:),G1H1(1),m3h2x1(:,126),heltab2x2(:,:,126))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(174),n2h1(174))
  call Hloop_WQ_A(ntryL,G1H2(379),ex4(:),G1H1(1),m3h2x1(:,127),heltab2x2(:,:,127))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(175),n2h1(175))
  call Hloop_WQ_A(ntryL,G1H2(380),ex4(:),G1H1(1),m3h2x1(:,128),heltab2x2(:,:,128))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(176),n2h1(176))
  call Hloop_WQ_A(ntryL,G1H2(385),ex4(:),G1H1(1),m3h2x1(:,129),heltab2x2(:,:,129))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(177),n2h1(177))
  call Hloop_WQ_A(ntryL,G1H2(386),ex4(:),G1H1(1),m3h2x1(:,130),heltab2x2(:,:,130))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(178),n2h1(178))
  call Hloop_WQ_A(ntryL,G1H2(391),ex4(:),G1H1(1),m3h2x1(:,131),heltab2x2(:,:,131))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(179),n2h1(179))
  call Hloop_WQ_A(ntryL,G1H2(392),ex4(:),G1H1(1),m3h2x1(:,132),heltab2x2(:,:,132))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(180),n2h1(180))
  call Hloop_VA_Q(ntryL,G1H2(397),ex3(:),G1H1(1),m3h2x1(:,133),heltab2x2(:,:,133))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(181),n2h1(181))
  call Hloop_VA_Q(ntryL,G1H2(398),ex3(:),G1H1(1),m3h2x1(:,134),heltab2x2(:,:,134))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(182),n2h1(182))
  call Hloop_ZA_Q(ntryL,G1H2(403),ex3(:),G1H1(1),ngZu,m3h2x1(:,135),heltab2x2(:,:,135))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(183),n2h1(183))
  call Hloop_ZA_Q(ntryL,G1H2(404),ex3(:),G1H1(1),ngZu,m3h2x1(:,136),heltab2x2(:,:,136))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(184),n2h1(184))
  call Hloop_VA_Q(ntryL,G1H2(409),ex3(:),G1H1(1),m3h2x1(:,137),heltab2x2(:,:,137))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(185),n2h1(185))



end subroutine vamp_1

end module ol_vamp_1_ppwttj_ew_uxttxdwxg_4_/**/REALKIND
